# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['nonebot_plugin_pixivbot_onebot_v11',
 'nonebot_plugin_pixivbot_onebot_v11.protocol_dep',
 'nonebot_plugin_pixivbot_onebot_v11.query']

package_data = \
{'': ['*']}

install_requires = \
['nonebot-adapter-onebot>=2.1.1,<3.0.0',
 'nonebot-plugin-pixivbot==1.1.1',
 'nonebot2>=2.0.0-beta.4,<3.0.0']

setup_kwargs = {
    'name': 'nonebot-plugin-pixivbot-onebot-v11',
    'version': '1.1.1',
    'description': 'Nonebot Plugin PixivBot (Onebot V11)',
    'long_description': 'nonebot-plugin-pixivbot-onebot-v11\n=====\n\nOnebot V11协议版本的PixivBot\n\n## 环境配置\n\n事前准备：登录pixiv账号并获取refresh_token。（参考：[@ZipFile Pixiv OAuth Flow](https://gist.github.com/ZipFile/c9ebedb224406f4f11845ab700124362)）\n\n1. 参考[安装 | NoneBot](https://v2.nonebot.dev/docs/start/installation)安装NoneBot；\n2. 参考[创建项目 | NoneBot](https://v2.nonebot.dev/docs/tutorial/create-project)创建一个Bot实例；\n5. 运行`nb plugin install nonebot_plugin_pixivbot-onebot-v11`安装本插件；\n6. 安装MongoDB，并创建一个数据库及用户供应用使用；\n7. 在.env.prod中修改配置（参考下方）；\n\n## 触发语句\n\n普通语句：\n\n所有数字参数均支持中文数字和罗马数字。\n\n- **看看<类型>榜<范围>***：查看pixiv榜单（<类型>可省略，<范围>应为a-b或a）\n  - 示例：看看榜、看看日榜、看看榜1-5、看看月榜一\n- **来<数量>张图**：从推荐插画随机抽选一张插画（<数量>可省略，下同）\n  - 示例：来张图、来五张图\n- **来<数量>张<关键字>图**：搜索关键字，从搜索结果随机抽选一张插画\n  - 示例：来张初音ミク图、来五张初音ミク图\n  - 注：默认开启关键字翻译功能。Bot会在平时的数据爬取时记录各个Tag的中文翻译。在搜索时，若关键字的日文翻译存在，则使用日文翻译代替关键字进行搜索。\n- **来<数量>张<用户>老师的图**：搜索用户，从插画列表中随机抽选一张插画\n  - 示例：来张Rella老师的图、来五张Rella老师的图\n- **看看图<插画ID>**：查看ID对应的插画\n  - 示例：看看图114514\n- **来<数量>张私家车**：从书签中随机抽选一张插画（发送者需绑定Pixiv账号，或者在配置中指定默认Pixiv账号）\n  - 示例：来张私家车、来五张私家车\n- **还要**：重复上一次请求\n- **不够色**：获取上一张插画的相关插画\n\n命令语句：\n\n- **/pixivbot schedule \\<type\\> \\<schedule\\> [..args]**：为本群（本用户）订阅类型为<type>的定时推送功能，时间满足<schedule>时进行推送\n    - \\<type\\>：可选值有ranking, random_bookmark, random_recommended_illust, random_illust, random_user_illust\n    - \\<schedule\\>：有三种格式，*00:30\\*x*为每隔30分钟进行一次推送，*12:00*为每天12:00进行一次推送，*00:10+00:30\\*x*为从今天00:10开始每隔30分钟进行一次推送（开始时间若是一个过去的时间点，则从下一个开始推送的时间点进行推送）\n    - [..args]：\n      - \\<type\\>为ranking时，接受\\<mode\\> \\<range\\>\n      - \\<type\\>为random_bookmark时，接受\\<pixiv_user_id\\>\n      - \\<type\\>为random_illust时，接受\\<word\\>\n      - \\<type\\>为random_user_illust时，接受\\<user\\>\n- **/pixivbot schedule**：查看本群（本用户）的所有订阅\n- **/pixivbot unschedule <type>**：取消本群（本用户）的订阅\n- **/pixivbot bind <pixiv_user_id>**：绑定Pixiv账号（用于随机书签功能）\n- **/pixivbot unbind**：解绑Pixiv账号\n- **/pixivbot invalidate_cache**：清除缓存\n\n## 配置\n\n最小配置：\n```\npixiv_refresh_token=  # 前面获取的REFRESH_TOKEN\npixiv_mongo_conn_url=  # MongoDB连接URL，格式：mongodb://<用户名>:<密码>@<主机>:<端口>/<数据库>\npixiv_mongo_database_name=  # 连接的MongoDB数据库\n```\n\n完整配置（除最小配置出现的配置项以外都是可选项，给出的是默认值）（NoneBot配置项这里不列出，参考[配置 | NoneBot](https://v2.nonebot.dev/docs/tutorial/configuration#%E8%AF%A6%E7%BB%86%E9%85%8D%E7%BD%AE%E9%A1%B9)）：\n```\nsuperuser=[]  # 能够发送超级命令的用户（JSON数组，格式为["onebot:123456", "kaiheila:1919810"]，下同）\nblocklist=[]  # Bot不响应的用户，可以避免Bot之间相互调用（JSON数组）\n\npixiv_refresh_token=  # 前面获取的REFRESH_TOKEN\npixiv_mongo_conn_url=  # MongoDB连接URL，格式：mongodb://<用户名>:<密码>@<主机>:<端口>/<数据库>\npixiv_mongo_database_name=  # 连接的MongoDB数据库\npixiv_proxy=None  # 代理URL\npixiv_query_timeout=60  # 查询超时（单位：秒）\npixiv_simultaneous_query=8  # 向Pixiv查询的并发数\n\n# 缓存过期时间（单位：秒）\npixiv_download_cache_expires_in = 3600 * 24 * 7\npixiv_illust_detail_cache_expires_in = 3600 * 24 * 7\npixiv_user_detail_cache_expires_in = 3600 * 24 * 7\npixiv_illust_ranking_cache_expires_in = 3600 * 6\npixiv_search_illust_cache_expires_in = 3600 * 24\npixiv_search_user_cache_expires_in = 3600 * 24\npixiv_user_illusts_cache_expires_in = 3600 * 24\npixiv_user_bookmarks_cache_expires_in = 3600 * 24\npixiv_related_illusts_cache_expires_in = 3600 * 24\npixiv_other_cache_expires_in = 3600 * 6\n\npixiv_block_tags=[]  # 当插画含有指定tag时会被过滤\npixiv_block_action=no_image  # 过滤时的动作，可选值：no_image(不显示插画，回复插画信息), completely_block(只回复过滤提示), no_reply(无回复)\n\npixiv_download_quantity=original  # 插画下载品质，可选值：original, square_medium, medium, large\npixiv_download_custom_domain=None  # 使用反向代理下载插画的域名\n\npixiv_compression_enabled=False  # 启用插画压缩\npixiv_compression_max_size=None  # 插画压缩最大尺寸\npixiv_compression_quantity=None  # 插画压缩品质（0到100）\n\npixiv_query_to_me_only=False  # 只响应关于Bot的查询\npixiv_command_to_me_only=False  # 只响应关于Bot的命令\n\npixiv_query_cooldown=0  # 每次查询的冷却时间\npixiv_no_query_cooldown_users=[]  # 在这个列表中的用户不受冷却时间的影响（JSON数组）\npixiv_max_item_per_query=10  # 每个查询最多请求的插画数量\n\npixiv_tag_translation_enabled=True  # 启用搜索关键字翻译功能（平时搜索时记录标签翻译，在查询时判断是否存在对应中日翻译）\n\npixiv_more_enabled=True  # 启用重复上一次请求（还要）功能\npixiv_query_expires_in=10*60  # 上一次请求的过期时间（单位：秒）\n\npixiv_illust_query_enabled=True  # 启用插画查询（看看图）功能\n\npixiv_ranking_query_enabled=True  # 启用榜单查询（看看榜）功能\npixiv_ranking_default_mode=day  # 默认查询的榜单，可选值：day, week, month, day_male, day_female, week_original, week_rookie, day_manga\npixiv_ranking_default_range=[1, 3]  # 默认查询的榜单范围\npixiv_ranking_fetch_item=150  # 每次从服务器获取的榜单项数（查询的榜单范围必须在这个数目内）\npixiv_ranking_max_item_per_query=5  # 每次榜单查询最多能查询多少项\n\npixiv_random_illust_query_enabled=True  # 启用关键字插画随机抽选（来张xx图）功能\npixiv_random_illust_method=bookmark_proportion  # 随机抽选方法，下同，可选值：bookmark_proportion(概率与书签数成正比), view_proportion(概率与阅读量成正比), timedelta_proportion(概率与投稿时间和现在的时间差成正比), uniform(相等概率)\npixiv_random_illust_min_bookmark=0  # 过滤掉书签数小于该值的插画，下同\npixiv_random_illust_min_view=0  # 过滤掉阅读量小于该值的插画，下同\npixiv_random_illust_max_page=20  # 每次从服务器获取的查询结果页数，下同\npixiv_random_illust_max_item=500  # 每次从服务器获取的查询结果项数，下同\n\npixiv_random_recommended_illust_query_enabled=True  # 启用推荐插画随机抽选（来张图）功能\npixiv_random_recommended_illust_method=uniform\npixiv_random_recommended_illust_min_bookmark=0\npixiv_random_recommended_illust_min_view=0\npixiv_random_recommended_illust_max_page=40\npixiv_random_recommended_illust_max_item=1000\n\npixiv_random_related_illust_query_enabled=True  # 启用关联插画随机抽选（不够色）功能\npixiv_random_related_illust_method=bookmark_proportion\npixiv_random_related_illust_min_bookmark=0\npixiv_random_related_illust_min_view=0\npixiv_random_related_illust_max_page=4\npixiv_random_related_illust_max_item=100\n\npixiv_random_user_illust_query_enabled=True  # 启用用户插画随机抽选（来张xx老师的图）功能\npixiv_random_user_illust_method=timedelta_proportion\npixiv_random_user_illust_min_bookmark=0\npixiv_random_user_illust_min_view=0\npixiv_random_user_illust_max_page=2147483647\npixiv_random_user_illust_max_item=2147483647\n\npixiv_random_bookmark_query_enabled=True  # 启用用户书签随机抽选（来张私家车）功能\npixiv_random_bookmark_user_id=0  # 当QQ用户未绑定Pixiv账号时，从该Pixiv账号的书签内抽选\npixiv_random_bookmark_method=uniform\npixiv_random_bookmark_min_bookmark=0\npixiv_random_bookmark_min_view=0\npixiv_random_bookmark_max_page=2147483647\npixiv_random_bookmark_max_item=2147483647\n\npixiv_poke_action=random_recommended_illust  # 【go-cqhttp限定】戳一戳功能，可选值：空, ranking, random_recommended_illust, random_bookmark\n```\n\n## Special Thanks\n\n[Mikubill/pixivpy-async](https://github.com/Mikubill/pixivpy-async)\n\n[nonebot/nonebot2](https://github.com/nonebot/nonebot2)\n\n\n## LICENSE\n\n```\nMIT License\n\nCopyright (c) 2021 ssttkkl\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n\n```\n',
    'author': 'ssttkkl',
    'author_email': 'huang.wen.long@hotmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ssttkkl/nonebot-plugin-pixivbot-onebot-v11',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
