/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolEdge;
import org.jmol.api.JmolNode;

public class SmilesAromatic {
    public static final boolean isFlatSp2Ring(JmolNode[] jmolNodeArray, BitSet bitSet, BitSet bitSet2, float f) {
        JmolEdge[] jmolEdgeArray;
        JmolNode jmolNode;
        if (f <= 0.0f) {
            f = 0.01f;
        }
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = null;
        int n = bitSet2.cardinality();
        Vector3f[] vector3fArray = new Vector3f[n * 2];
        int n2 = 0;
        float f2 = 1.0f - f * 5.0f;
        int n3 = bitSet2.nextSetBit(0);
        while (n3 >= 0) {
            jmolNode = jmolNodeArray[n3];
            jmolEdgeArray = jmolNode.getEdges();
            if (jmolEdgeArray.length >= 3 && jmolEdgeArray.length > 3) {
                return false;
            }
            n3 = bitSet2.nextSetBit(n3 + 1);
        }
        n3 = bitSet2.nextSetBit(0);
        while (n3 >= 0) {
            jmolNode = jmolNodeArray[n3];
            jmolEdgeArray = jmolNode.getEdges();
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = jmolEdgeArray.length;
            while (--n7 >= 0) {
                int n8 = jmolNode.getBondedAtomIndex(n7);
                if (!bitSet.get(n8)) continue;
                if (!bitSet2.get(n8)) {
                    n4 = n8;
                    continue;
                }
                if (n5 < 0) {
                    n5 = n8;
                    continue;
                }
                n6 = n8;
            }
            SmilesAromatic.getNormalThroughPoints(jmolNodeArray[n5], jmolNodeArray[n3], jmolNodeArray[n6], vector3f, vector3f2, vector3f3);
            if (vector3f4 == null) {
                vector3f4 = new Vector3f();
            }
            if (!SmilesAromatic.addNormal(vector3f, vector3f4, f2)) {
                return false;
            }
            vector3fArray[n2++] = new Vector3f(vector3f);
            if (n4 >= 0) {
                SmilesAromatic.getNormalThroughPoints(jmolNodeArray[n5], jmolNodeArray[n4], jmolNodeArray[n6], vector3f, vector3f2, vector3f3);
                if (!SmilesAromatic.addNormal(vector3f, vector3f4, f2)) {
                    return false;
                }
                vector3fArray[n2++] = new Vector3f(vector3f);
            }
            n3 = bitSet2.nextSetBit(n3 + 1);
        }
        n3 = SmilesAromatic.checkStandardDeviation(vector3fArray, vector3f4, n2, f) ? 1 : 0;
        return n3 != 0;
    }

    private static final boolean addNormal(Vector3f vector3f, Vector3f vector3f2, float f) {
        float f2 = vector3f2.dot(vector3f);
        if (f2 != 0.0f && Math.abs(f2) < f) {
            return false;
        }
        if (f2 < 0.0f) {
            vector3f.scale(-1.0f);
        }
        vector3f2.add((Tuple3f)vector3f);
        vector3f2.normalize();
        return true;
    }

    private static final boolean checkStandardDeviation(Vector3f[] vector3fArray, Vector3f vector3f, int n, float f) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            float f2 = vector3fArray[i].dot(vector3f);
            d += (double)f2;
            d2 += (double)f2 * (double)f2;
        }
        return (d = Math.sqrt((d2 - d * d / (double)n) / (double)(n - 1))) < (double)f;
    }

    static float getNormalThroughPoints(JmolNode jmolNode, JmolNode jmolNode2, JmolNode jmolNode3, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f2.sub((Tuple3f)((Point3f)jmolNode2), (Tuple3f)((Point3f)jmolNode));
        vector3f3.sub((Tuple3f)((Point3f)jmolNode3), (Tuple3f)((Point3f)jmolNode));
        vector3f.cross(vector3f2, vector3f3);
        vector3f.normalize();
        vector3f2.set((Tuple3f)((Point3f)jmolNode));
        return -vector3f2.dot(vector3f);
    }
}

