# Generated by Django 5.2.4 on 2025-08-03 14:51

from django.db import migrations


def migrate(apps, schema_editor):
    Episode = apps.get_model("spodcat", "Episode")
    Season = apps.get_model("spodcat", "Season")

    for episode in Episode.objects.exclude(season=None):
        episode.season2 = Season.objects.get_or_create(podcast_id=episode.podcast_id, number=episode.season)[0]
        episode.save()


class Migration(migrations.Migration):

    dependencies = [
        ('spodcat', '0005_season_episode_season2'),
    ]

    operations = [
        migrations.RunPython(migrate, migrations.RunPython.noop),
    ]
