# Generated by Django 5.2.4 on 2025-07-28 16:50

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('spodcat', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AddField(
            model_name='podcast',
            name='authors',
            field=models.ManyToManyField(blank=True, related_name='podcasts', to=settings.AUTH_USER_MODEL, verbose_name='authors'),
        ),
        migrations.AddField(
            model_name='podcast',
            name='categories',
            field=models.ManyToManyField(blank=True, to='spodcat.category', verbose_name='categories'),
        ),
        migrations.AddField(
            model_name='podcast',
            name='name_font_face',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='spodcat.fontface', verbose_name='name font face'),
        ),
        migrations.AddField(
            model_name='podcast',
            name='owner',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='owned_podcasts', to=settings.AUTH_USER_MODEL, verbose_name='owner'),
        ),
        migrations.AddField(
            model_name='challenge',
            name='podcast',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='spodcat.podcast'),
        ),
        migrations.AddField(
            model_name='podcastlink',
            name='podcast',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='links', to='spodcat.podcast', verbose_name='podcast'),
        ),
        migrations.AddField(
            model_name='video',
            name='podcast_content',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='videos', to='spodcat.podcastcontent', verbose_name='podcast content'),
        ),
        migrations.AddField(
            model_name='episodesong',
            name='episode',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='songs', to='spodcat.episode', verbose_name='episode'),
        ),
        migrations.AddField(
            model_name='episodechapter',
            name='episode',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='chapters', to='spodcat.episode', verbose_name='episode'),
        ),
        migrations.AddIndex(
            model_name='podcastcontent',
            index=models.Index(fields=['-published'], name='spodcat_pod_publish_002d6d_idx'),
        ),
        migrations.AddConstraint(
            model_name='podcastcontent',
            constraint=models.UniqueConstraint(fields=('slug', 'podcast'), name='podcasts__podcastcontent__slug_podcast__uq'),
        ),
        migrations.AddIndex(
            model_name='podcast',
            index=models.Index(fields=['name'], name='spodcat_pod_name_794c0b_idx'),
        ),
        migrations.AddIndex(
            model_name='podcastlink',
            index=models.Index(fields=['order'], name='spodcat_pod_order_cc6f16_idx'),
        ),
        migrations.AddIndex(
            model_name='episodesong',
            index=models.Index(fields=['start_time'], name='spodcat_epi_start_t_a289b0_idx'),
        ),
    ]
