# Generated by Django 5.2.4 on 2025-07-28 16:50

import uuid

import django.db.models.deletion
import django.db.models.functions.text
import django.utils.timezone
import martor.models
from django.db import migrations, models

import spodcat.model_fields
import spodcat.model_mixin
import spodcat.models.challenge
import spodcat.models.functions
import spodcat.models.podcast


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Challenge',
            fields=[
                ('created', models.DateTimeField(auto_now_add=True)),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('term1', models.PositiveSmallIntegerField(default=spodcat.models.challenge.generate_term)),
                ('term2', models.PositiveSmallIntegerField(default=spodcat.models.challenge.generate_term)),
            ],
            options={
                'verbose_name': 'challenge',
                'verbose_name_plural': 'challenges',
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='PodcastContent',
            fields=[
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('description', martor.models.MartorField(blank=True, default=None, null=True, verbose_name='description')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('is_draft', models.BooleanField(default=False, verbose_name='draft')),
                ('name', models.CharField(max_length=100, verbose_name='name')),
                ('published', models.DateTimeField(default=django.utils.timezone.now, verbose_name='published')),
                ('slug', models.SlugField(max_length=100, verbose_name='slug')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_%(app_label)s.%(class)s_set+', to='contenttypes.contenttype')),
            ],
            options={
                'verbose_name': 'podcast content',
                'verbose_name_plural': 'podcast contents',
                'ordering': ['-published'],
                'get_latest_by': 'published',
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='EpisodeChapter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, default='', max_length=100, verbose_name='title')),
                ('start_time', spodcat.model_fields.TimestampField(verbose_name='start time')),
                ('end_time', spodcat.model_fields.TimestampField(blank=True, default=None, null=True, verbose_name='end time')),
                ('image', models.ImageField(blank=True, default=None, max_length=300, null=True, storage=spodcat.models.functions.episode_chapter_image_storage, upload_to=spodcat.models.functions.episode_chapter_image_upload_to, verbose_name='image')),
                ('url', models.URLField(blank=True, default=None, null=True, verbose_name='URL')),
            ],
            options={
                'verbose_name': 'episode chapter',
                'verbose_name_plural': 'episode chapters',
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='FontFace',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=30, unique=True, verbose_name='name')),
                ('file', models.FileField(storage=spodcat.models.functions.fontface_file_storage, upload_to=spodcat.models.functions.fontface_file_upload_to, verbose_name='font file')),
                ('format', models.CharField(choices=[('truetype', 'Truetype'), ('woff', 'WOFF 1.0'), ('woff2', 'WOFF 2.0'), ('opentype', 'Opentype'), ('collection', 'Opentype Collection'), ('embedded-opentype', 'Embedded Opentype'), ('svg', 'SVG font (deprecated)')], default=None, max_length=20, null=True, verbose_name='format')),
                ('weight', models.PositiveSmallIntegerField(choices=[(100, '100'), (200, '200'), (300, '300'), (400, '400'), (500, '500'), (600, '600'), (700, '700'), (800, '800'), (900, '900')], default=400, verbose_name='weight')),
                ('updated', models.DateTimeField()),
            ],
            options={
                'verbose_name': 'font face',
                'verbose_name_plural': 'font faces',
                'ordering': [django.db.models.functions.text.Lower('name')],
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Podcast',
            fields=[
                ('banner', models.ImageField(blank=True, default=None, help_text='Should be >= 960px wide and have aspect ratio 3:1.', max_length=300, null=True, storage=spodcat.models.functions.podcast_banner_storage, upload_to=spodcat.models.functions.podcast_banner_upload_to, verbose_name='banner image')),
                ('banner_height', models.PositiveIntegerField(default=None, null=True)),
                ('banner_width', models.PositiveIntegerField(default=None, null=True)),
                ('cover', models.ImageField(blank=True, default=None, help_text="This is the round 'avatar' image. It should ideally have height and width >= 1400px.", max_length=300, null=True, storage=spodcat.models.functions.podcast_cover_storage, upload_to=spodcat.models.functions.podcast_cover_upload_to, verbose_name='cover')),
                ('cover_height', models.PositiveIntegerField(default=None, null=True)),
                ('cover_mimetype', models.CharField(default=None, max_length=50, null=True)),
                ('cover_thumbnail', models.ImageField(blank=True, default=None, max_length=300, null=True, storage=spodcat.models.functions.podcast_cover_thumbnail_storage, upload_to=spodcat.models.functions.podcast_cover_thumbnail_upload_to)),
                ('cover_thumbnail_height', models.PositiveIntegerField(default=None, null=True)),
                ('cover_thumbnail_mimetype', models.CharField(default=None, max_length=50, null=True)),
                ('cover_thumbnail_width', models.PositiveIntegerField(default=None, null=True)),
                ('cover_width', models.PositiveIntegerField(default=None, null=True)),
                ('description', martor.models.MartorField(blank=True, default=None, null=True, verbose_name='description')),
                ('enable_comments', models.BooleanField(default=False, verbose_name='enable comments')),
                ('favicon', models.ImageField(blank=True, default=None, max_length=300, null=True, storage=spodcat.models.functions.podcast_favicon_storage, upload_to=spodcat.models.functions.podcast_favicon_upload_to, verbose_name='favicon')),
                ('favicon_content_type', models.CharField(blank=True, default=None, max_length=50, null=True)),
                ('language', models.CharField(blank=True, choices=spodcat.models.podcast.get_language_choices, default=None, max_length=5, null=True, verbose_name='language')),
                ('name', models.CharField(max_length=100, verbose_name='name')),
                ('name_font_size', models.CharField(choices=[('small', 'small'), ('normal', 'normal'), ('large', 'large')], default='normal', max_length=10, verbose_name='name font size')),
                ('require_comment_approval', models.BooleanField(default=True, verbose_name='require comment approval')),
                ('slug', models.SlugField(help_text='Will be used in URLs.', primary_key=True, serialize=False, validators=[spodcat.models.podcast.podcast_slug_validator], verbose_name='slug')),
                ('tagline', models.CharField(blank=True, default=None, max_length=500, null=True, verbose_name='tagline')),
                ('custom_guid', models.UUIDField(blank=True, default=None, help_text="Don't set if you don't know what you're doing. Ref: https://podcasting2.org/podcast-namespace/tags/guid", null=True, verbose_name='custom GUID')),
            ],
            options={
                'verbose_name': 'podcast',
                'verbose_name_plural': 'podcasts',
                'ordering': ['name'],
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='PodcastLink',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('custom_icon', models.ImageField(blank=True, default=None, max_length=300, null=True, storage=spodcat.models.functions.podcast_link_icon_storage, upload_to=spodcat.models.functions.podcast_link_icon_upload_to, verbose_name='custom icon')),
                ('icon', models.CharField(choices=[('facebook', 'The Facebook'), ('patreon', 'Patreon'), ('discord', 'Discord'), ('apple', 'Apple'), ('android', 'Android'), ('spotify', 'Spotify'), ('itunes', 'Itunes')], default=None, max_length=10, null=True, verbose_name='icon')),
                ('label', models.CharField(max_length=100, verbose_name='label')),
                ('order', models.PositiveSmallIntegerField(default=0, verbose_name='order')),
                ('theme', models.CharField(choices=[('primary', 'Primary'), ('secondary', 'Secondary'), ('tertiary', 'Tertiary'), ('boring', 'Boring')], default='primary', max_length=10, verbose_name='theme')),
                ('url', models.URLField(verbose_name='URL')),
            ],
            options={
                'verbose_name': 'podcast link',
                'verbose_name_plural': 'podcast links',
                'ordering': ['order'],
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Video',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('video_type', models.CharField(choices=[('youtube', 'Youtube')], default='youtube', max_length=20)),
                ('video_id', models.CharField(max_length=100)),
                ('title', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='title')),
            ],
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Artist',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='name')),
            ],
            options={
                'verbose_name': 'artist',
                'verbose_name_plural': 'artists',
                'ordering': [django.db.models.functions.text.Lower('name')],
                'indexes': [models.Index(fields=['name'], name='spodcat_art_name_30d017_idx')],
                'constraints': [models.UniqueConstraint(fields=('name',), name='podcasts__artist__name__uq')],
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cat', models.CharField(max_length=50)),
                ('sub', models.CharField(default=None, max_length=50, null=True)),
            ],
            options={
                'verbose_name': 'category',
                'verbose_name_plural': 'categories',
                'ordering': ['cat', 'sub'],
                'indexes': [models.Index(fields=['cat', 'sub'], name='spodcat_cat_cat_8f0c74_idx')],
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Episode',
            fields=[
                ('podcastcontent_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='spodcat.podcastcontent')),
                ('audio_content_type', models.CharField(blank=True, max_length=100, verbose_name='audio content type')),
                ('audio_file', models.FileField(blank=True, default=None, max_length=300, null=True, storage=spodcat.models.functions.episode_audio_file_storage, upload_to=spodcat.models.functions.episode_audio_file_upload_to, verbose_name='audio file')),
                ('audio_file_length', models.PositiveIntegerField(blank=True, db_index=True, default=0, verbose_name='audio file length')),
                ('dbfs_array', models.JSONField(blank=True, default=list, verbose_name='dBFS array')),
                ('duration_seconds', models.FloatField(blank=True, db_index=True, default=0.0, verbose_name='duration')),
                ('image', models.ImageField(blank=True, default=None, max_length=300, null=True, storage=spodcat.models.functions.episode_image_storage, upload_to=spodcat.models.functions.episode_image_upload_to, verbose_name='image')),
                ('image_height', models.PositiveIntegerField(default=None, null=True)),
                ('image_mimetype', models.CharField(default=None, max_length=50, null=True)),
                ('image_thumbnail', models.ImageField(blank=True, default=None, max_length=300, null=True, storage=spodcat.models.functions.episode_image_thumbnail_storage, upload_to=spodcat.models.functions.episode_image_thumbnail_upload_to)),
                ('image_thumbnail_height', models.PositiveIntegerField(default=None, null=True)),
                ('image_thumbnail_mimetype', models.CharField(default=None, max_length=50, null=True)),
                ('image_thumbnail_width', models.PositiveIntegerField(default=None, null=True)),
                ('image_width', models.PositiveIntegerField(default=None, null=True)),
                ('number', models.FloatField(blank=True, default=None, null=True, verbose_name='number')),
                ('season', models.PositiveSmallIntegerField(blank=True, default=None, null=True, verbose_name='season')),
            ],
            options={
                'verbose_name': 'episode',
                'verbose_name_plural': 'episodes',
            },
            bases=('spodcat.podcastcontent',),
        ),
        migrations.CreateModel(
            name='Post',
            fields=[
                ('podcastcontent_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='spodcat.podcastcontent')),
            ],
            options={
                'verbose_name': 'post',
                'verbose_name_plural': 'posts',
            },
            bases=('spodcat.podcastcontent',),
        ),
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('is_approved', models.BooleanField(default=False, verbose_name='is approved')),
                ('name', models.CharField(max_length=50, verbose_name='name')),
                ('text', models.TextField(verbose_name='text')),
                ('podcast_content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comments', to='spodcat.podcastcontent', verbose_name='podcast content')),
            ],
            options={
                'verbose_name': 'comment',
                'verbose_name_plural': 'comments',
                'ordering': ['created'],
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='EpisodeSong',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_time', spodcat.model_fields.TimestampField(verbose_name='start time')),
                ('end_time', spodcat.model_fields.TimestampField(blank=True, default=None, null=True, verbose_name='end time')),
                ('image', models.ImageField(blank=True, default=None, max_length=300, null=True, storage=spodcat.models.functions.episode_chapter_image_storage, upload_to=spodcat.models.functions.episode_chapter_image_upload_to, verbose_name='image')),
                ('url', models.URLField(blank=True, default=None, null=True, verbose_name='URL')),
                ('comment', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='comment')),
                ('title', models.CharField(max_length=100, verbose_name='title')),
                ('artists', models.ManyToManyField(blank=True, related_name='songs', to='spodcat.artist', verbose_name='artists')),
            ],
            options={
                'verbose_name': 'episode song',
                'verbose_name_plural': 'episode songs',
                'ordering': ['start_time'],
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.AddField(
            model_name='podcastcontent',
            name='podcast',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='contents', to='spodcat.podcast', verbose_name='podcast'),
        ),
    ]
