# Generated by Django 5.2.4 on 2025-07-28 16:50

import django.db.models.deletion
import klaatu_django.db
from django.db import migrations, models

import spodcat.model_mixin


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('spodcat', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='GeoIP',
            fields=[
                ('city', models.CharField(max_length=100, verbose_name='city')),
                ('country', models.CharField(max_length=10, verbose_name='country')),
                ('ip', models.GenericIPAddressField(primary_key=True, serialize=False, verbose_name='IP')),
                ('org', models.CharField(max_length=100, verbose_name='org')),
                ('region', models.CharField(max_length=100, verbose_name='region')),
            ],
            options={
                'verbose_name': 'GeoIP',
                'verbose_name_plural': 'GeoIP:s',
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='UserAgent',
            fields=[
                ('device_category', models.CharField(choices=[('auto', 'Auto'), ('computer', 'Computer'), ('mobile', 'Mobile'), ('smart_speaker', 'Smart speaker'), ('smart_tv', 'Smart TV'), ('watch', 'Watch')], default=None, max_length=20, null=True, verbose_name='device category')),
                ('device_name', models.CharField(blank=True, default='', max_length=40, verbose_name='device name')),
                ('name', models.CharField(max_length=100, verbose_name='name')),
                ('type', models.CharField(choices=[('app', 'App'), ('bot', 'Bot'), ('browser', 'Browser'), ('library', 'Library')], db_index=True, max_length=10, verbose_name='type')),
                ('user_agent', models.CharField(max_length=400, primary_key=True, serialize=False, verbose_name='user agent')),
            ],
            options={
                'verbose_name': 'user agent',
                'verbose_name_plural': 'user agents',
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='PodcastRssRequestLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(db_index=True, verbose_name='created')),
                ('is_bot', models.BooleanField(db_index=True, default=False, verbose_name='is bot')),
                ('path_info', klaatu_django.db.TruncatedCharField(blank=True, default='', max_length=200, verbose_name='path')),
                ('referrer', klaatu_django.db.TruncatedCharField(blank=True, default='', max_length=150, verbose_name='referrer')),
                ('referrer_category', models.CharField(choices=[('app', 'App'), ('host', 'Host')], default=None, max_length=10, null=True, verbose_name='referrer category')),
                ('referrer_name', models.CharField(blank=True, default='', max_length=50, verbose_name='referrer name')),
                ('remote_addr', models.GenericIPAddressField(db_index=True, default=None, null=True, verbose_name='remote address')),
                ('remote_addr_category', models.CharField(choices=[('applebot', 'Applebot'), ('bingbot', 'Bingbot'), ('duckduckbot', 'Duckduckbot'), ('facebookbot', 'Facebookbot'), ('googlebot', 'Googlebot'), ('twitterbot', 'Twitterbot'), ('unknown', 'Unknown')], default='unknown', max_length=20, verbose_name='remote address category')),
                ('remote_host', models.CharField(blank=True, default='', max_length=100, verbose_name='remote host')),
                ('user_agent', models.CharField(blank=True, default='', max_length=400, verbose_name='user agent')),
                ('geoip', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='spodcat_logs.geoip', verbose_name='GeoIP')),
                ('podcast', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='rss_requests', to='spodcat.podcast', verbose_name='podcast')),
                ('user_agent_data', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='spodcat_logs.useragent', verbose_name='user agent data')),
            ],
            options={
                'verbose_name': 'request log',
                'verbose_name_plural': 'request logs',
                'abstract': False,
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='PodcastRequestLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(db_index=True, verbose_name='created')),
                ('is_bot', models.BooleanField(db_index=True, default=False, verbose_name='is bot')),
                ('path_info', klaatu_django.db.TruncatedCharField(blank=True, default='', max_length=200, verbose_name='path')),
                ('referrer', klaatu_django.db.TruncatedCharField(blank=True, default='', max_length=150, verbose_name='referrer')),
                ('referrer_category', models.CharField(choices=[('app', 'App'), ('host', 'Host')], default=None, max_length=10, null=True, verbose_name='referrer category')),
                ('referrer_name', models.CharField(blank=True, default='', max_length=50, verbose_name='referrer name')),
                ('remote_addr', models.GenericIPAddressField(db_index=True, default=None, null=True, verbose_name='remote address')),
                ('remote_addr_category', models.CharField(choices=[('applebot', 'Applebot'), ('bingbot', 'Bingbot'), ('duckduckbot', 'Duckduckbot'), ('facebookbot', 'Facebookbot'), ('googlebot', 'Googlebot'), ('twitterbot', 'Twitterbot'), ('unknown', 'Unknown')], default='unknown', max_length=20, verbose_name='remote address category')),
                ('remote_host', models.CharField(blank=True, default='', max_length=100, verbose_name='remote host')),
                ('user_agent', models.CharField(blank=True, default='', max_length=400, verbose_name='user agent')),
                ('geoip', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='spodcat_logs.geoip', verbose_name='GeoIP')),
                ('podcast', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='requests', to='spodcat.podcast', verbose_name='podcast')),
                ('user_agent_data', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='spodcat_logs.useragent', verbose_name='user agent data')),
            ],
            options={
                'verbose_name': 'podcast page request log',
                'verbose_name_plural': 'podcast page request logs',
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='PodcastEpisodeAudioRequestLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(db_index=True, verbose_name='created')),
                ('is_bot', models.BooleanField(db_index=True, default=False, verbose_name='is bot')),
                ('path_info', klaatu_django.db.TruncatedCharField(blank=True, default='', max_length=200, verbose_name='path')),
                ('referrer', klaatu_django.db.TruncatedCharField(blank=True, default='', max_length=150, verbose_name='referrer')),
                ('referrer_category', models.CharField(choices=[('app', 'App'), ('host', 'Host')], default=None, max_length=10, null=True, verbose_name='referrer category')),
                ('referrer_name', models.CharField(blank=True, default='', max_length=50, verbose_name='referrer name')),
                ('remote_addr', models.GenericIPAddressField(db_index=True, default=None, null=True, verbose_name='remote address')),
                ('remote_addr_category', models.CharField(choices=[('applebot', 'Applebot'), ('bingbot', 'Bingbot'), ('duckduckbot', 'Duckduckbot'), ('facebookbot', 'Facebookbot'), ('googlebot', 'Googlebot'), ('twitterbot', 'Twitterbot'), ('unknown', 'Unknown')], default='unknown', max_length=20, verbose_name='remote address category')),
                ('remote_host', models.CharField(blank=True, default='', max_length=100, verbose_name='remote host')),
                ('user_agent', models.CharField(blank=True, default='', max_length=400, verbose_name='user agent')),
                ('duration_ms', models.IntegerField(default=None, null=True, verbose_name='duration')),
                ('response_body_size', models.IntegerField(db_index=True, verbose_name='response body size')),
                ('status_code', models.CharField(max_length=10, verbose_name='status code')),
                ('episode', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='audio_requests', to='spodcat.episode', verbose_name='episode')),
                ('geoip', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='spodcat_logs.geoip', verbose_name='GeoIP')),
                ('user_agent_data', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='spodcat_logs.useragent', verbose_name='user agent data')),
            ],
            options={
                'verbose_name': 'podcast episode audio request log',
                'verbose_name_plural': 'podcast episode audio request logs',
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='PodcastContentRequestLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(db_index=True, verbose_name='created')),
                ('is_bot', models.BooleanField(db_index=True, default=False, verbose_name='is bot')),
                ('path_info', klaatu_django.db.TruncatedCharField(blank=True, default='', max_length=200, verbose_name='path')),
                ('referrer', klaatu_django.db.TruncatedCharField(blank=True, default='', max_length=150, verbose_name='referrer')),
                ('referrer_category', models.CharField(choices=[('app', 'App'), ('host', 'Host')], default=None, max_length=10, null=True, verbose_name='referrer category')),
                ('referrer_name', models.CharField(blank=True, default='', max_length=50, verbose_name='referrer name')),
                ('remote_addr', models.GenericIPAddressField(db_index=True, default=None, null=True, verbose_name='remote address')),
                ('remote_addr_category', models.CharField(choices=[('applebot', 'Applebot'), ('bingbot', 'Bingbot'), ('duckduckbot', 'Duckduckbot'), ('facebookbot', 'Facebookbot'), ('googlebot', 'Googlebot'), ('twitterbot', 'Twitterbot'), ('unknown', 'Unknown')], default='unknown', max_length=20, verbose_name='remote address category')),
                ('remote_host', models.CharField(blank=True, default='', max_length=100, verbose_name='remote host')),
                ('user_agent', models.CharField(blank=True, default='', max_length=400, verbose_name='user agent')),
                ('content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='requests', to='spodcat.podcastcontent', verbose_name='podcast content')),
                ('geoip', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='spodcat_logs.geoip', verbose_name='GeoIP')),
                ('user_agent_data', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='spodcat_logs.useragent', verbose_name='user agent data')),
            ],
            options={
                'verbose_name': 'podcast content page request log',
                'verbose_name_plural': 'podcast content page request logs',
            },
            bases=(spodcat.model_mixin.ModelMixin, models.Model),
        ),
    ]
