---
title: "Key Features"
---

<div class="homepage-hero-section">
  <div class="hero-content">
    <div class="hero-logo-section">
      <img class="hero-logo" noZoom src="/ag2/assets/img/ag2.svg" alt="AG2 Logo" />
    </div>
    <div class="hero-text-section">
      <h2 class="hero-title">AG2</h2>
      <p class="hero-subtitle">The Open Source Agent OS</p>
      <a class="hero-btn" href="/ag2/docs/home/quick-start">
        <div>Getting Started - 3 Minute</div>
      </a>
    </div>
  </div>
</div>

### Key Features

<div class="key-features not-prose grid gap-x-4 sm:grid-cols-3">
  <div class="card">
    <div class="key-feature">
        <img noZoom src="/ag2/assets/img/conv_2.svg" alt="Multi-Agent Conversation Framework" />
        <p><b>Multi-Agent Conversation Framework</b></p>
        <p>AG2 provides multi-agent conversation framework as a high-level abstraction. With this framework, one can conveniently build LLM workflows.</p>
    </div>
  </div>

  <div class="card">
    <div class="key-feature">
      <img noZoom src='/ag2/assets/img/autogen_app.svg' alt='Easily Build Diverse Applications' />
      <p><b>Easily Build Diverse Applications</b></p>
      <p>AG2 offers a collection of working systems spanning a wide range of applications from various domains and complexities.</p>
    </div>
  </div>

  <div class="card">
    <div class="key-feature">
        <img noZoom src='/ag2/assets/img/extend.svg' alt='Enhanced LLM Inference & Optimization' />
        <p><b>Enhanced LLM Inference & Optimization</b></p>
        <p>AG2 supports enhanced LLM inference APIs, which can be used to improve inference performance and reduce cost.</p>
    </div>
  </div>
</div>

### Explore content
<div class="explore-content">
    <div class="not-prose grid gap-x-4 sm:grid-cols-2">
      <a class="card" href="/ag2/docs/home/quick-start">
        <div class="px-6 py-5">
          <div>
            <h2 class="font-semibold text-base text-gray-800 dark:text-white">Quick Start</h2>
            <div class="mt-1 font-normal text-sm leading-6 text-gray-600 dark:text-gray-400">Start building your AG2 application.</div>
          </div>
        </div>
      </a>
      <a class="card" href="/ag2/docs/user-guide/basic-concepts/installing-ag2">
        <div class="px-6 py-5">
          <div>
            <h2 class="font-semibold text-base text-gray-800 dark:text-white">Concepts</h2>
            <div class="mt-1 font-normal text-sm leading-6 text-gray-600 dark:text-gray-400">Work through the key concepts of AG2 including ConversableAgent, GroupChat, Swarm, and tools.</div>
          </div>
        </div>
      </a>
      <a class="card" href="/ag2/docs/user-guide/advanced-concepts">
        <div class="px-6 py-5">
          <div>
            <h2 class="font-semibold text-base text-gray-800 dark:text-white">Advanced Concepts</h2>
            <div class="mt-1 font-normal text-sm leading-6 text-gray-600 dark:text-gray-400">Advance to RAG, Code Execution, and more complex GroupChats and Swarms.</div>
          </div>
        </div>
      </a>
      <a class="card" href="/ag2/docs/use-cases/use-cases">
        <div class="px-6 py-5">
          <div>
            <h2 class="font-semibold text-base text-gray-800 dark:text-white">Use Cases</h2>
            <div class="mt-1 font-normal text-sm leading-6 text-gray-600 dark:text-gray-400">Try out use case workflows including Customer Service, Travel Planning, and Game Design.</div>
          </div>
        </div>
      </a>
      <a class="card" href="/ag2/docs/use-cases/notebooks/Notebooks">
        <div class="px-6 py-5">
          <div>
            <h2 class="font-semibold text-base text-gray-800 dark:text-white">Notebook Examples</h2>
            <div class="mt-1 font-normal text-sm leading-6 text-gray-600 dark:text-gray-400">A collection of interactive notebooks across all AG2 topics.</div>
          </div>
        </div>
      </a>
      <a class="card" href="/ag2/docs/api-reference">
        <div class="px-6 py-5">
          <div>
            <h2 class="font-semibold text-base text-gray-800 dark:text-white">API Reference</h2>
            <div class="mt-1 font-normal text-sm leading-6 text-gray-600 dark:text-gray-400">Delve into the AG2 API reference.</div>
          </div>
        </div>
      </a>
      <a class="card" href="/ag2/docs/contributor-guide/contributing">
        <div class="px-6 py-5">
          <div>
            <h2 class="font-semibold text-base text-gray-800 dark:text-white">How to Contribute</h2>
            <div class="mt-1 font-normal text-sm leading-6 text-gray-600 dark:text-gray-400">Get involved with AG2 by adding what you need and making the framework even better!</div>
          </div>
        </div>
      </a>
    </div>
</div>

### Popular resources
<div class="popular-resources">
  <div class="card-group not-prose grid gap-x-4 sm:grid-cols-2">
      <div class="card">
        <div class="youtube-video">
          <iframe
            class="w-full aspect-video rounded-md"
            src="https://www.youtube.com/embed/RLwyXRVvlNk"
            title="YouTube video player"
            frameborder="0"
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
            allowfullscreen
          ></iframe>
          <a target="_blank" href="https://www.youtube.com/watch?v=RLwyXRVvlNk">
            Foundation Capital Interview with Dr. Chi Wang
          </a>
        </div>
      </div>
      <div class="card">
        <div class="youtube-video">
          <iframe
            class="w-full aspect-video rounded-md"
            src="https://www.youtube.com/embed/TBNTH-fwGPE"
            title="YouTube video player"
            frameborder="0"
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
            allowfullscreen
          ></iframe>
          <a target="_blank" href="https://www.youtube.com/watch?v=TBNTH-fwGPE">
            Learn AG2 on DeepLearningAI
          </a>
        </div>
      </div>
  </div>
</div>
