# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.development_board_response import DevelopmentBoardResponse
from edgeimpulse_api.models.project_type import ProjectType
from edgeimpulse_api.models.theme import Theme
from edgeimpulse_api.models.whitelabel_all_learning_blocks_inner import WhitelabelAllLearningBlocksInner
from edgeimpulse_api.models.whitelabel_custom_deployment_blocks_inner import WhitelabelCustomDeploymentBlocksInner

class Whitelabel(BaseModel):
    id: StrictInt = ...
    name: StrictStr = ...
    domain: StrictStr = ...
    owner_organization_id: Optional[StrictInt] = Field(None, alias="ownerOrganizationId")
    theme_id: StrictInt = Field(..., alias="themeId")
    theme: Optional[Theme] = None
    identity_providers: List[StrictStr] = Field(..., alias="identityProviders")
    allow_password_auth: StrictBool = Field(..., alias="allowPasswordAuth")
    deployment_targets: List[StrictStr] = Field(..., alias="deploymentTargets", description="List of deployment targets enabled for this white label")
    all_deployment_targets: List[StrictStr] = Field(..., alias="allDeploymentTargets", description="List of all supported deployment targets")
    custom_deployment_blocks: Optional[List[WhitelabelCustomDeploymentBlocksInner]] = Field(None, alias="customDeploymentBlocks", description="List of custom deployment blocks available to this white label")
    deployment_options_order: Optional[List[StrictStr]] = Field(None, alias="deploymentOptionsOrder", description="Optional attribute allowing a whitelabel to customize the order of deployment options in the deployment view, given as an in-order list of deployment options.")
    allow_signup: StrictBool = Field(..., alias="allowSignup")
    allow_free_projects: StrictBool = Field(..., alias="allowFreeProjects")
    expose_public_projects: Optional[StrictBool] = Field(None, alias="exposePublicProjects")
    default_deployment_target: Optional[StrictStr] = Field(None, alias="defaultDeploymentTarget", description="The name of the default deployment target for this white label")
    supported_project_types: List[ProjectType] = Field(..., alias="supportedProjectTypes")
    allow_new_project_ui: StrictBool = Field(..., alias="allowNewProjectUi", description="Whether the new project UI should be enabled for this white label or not.")
    learning_blocks: List[StrictStr] = Field(..., alias="learningBlocks", description="List of learning blocks enabled for this white label")
    all_learning_blocks: List[WhitelabelAllLearningBlocksInner] = Field(..., alias="allLearningBlocks", description="List of all supported learning blocks")
    development_boards: List[DevelopmentBoardResponse] = Field(..., alias="developmentBoards")
    all_development_boards: List[DevelopmentBoardResponse] = Field(..., alias="allDevelopmentBoards")
    organizations_limit: Optional[StrictInt] = Field(None, alias="organizationsLimit", description="The maximum number of organizations that can be created under this white label.")
    __properties = ["id", "name", "domain", "ownerOrganizationId", "themeId", "theme", "identityProviders", "allowPasswordAuth", "deploymentTargets", "allDeploymentTargets", "customDeploymentBlocks", "deploymentOptionsOrder", "allowSignup", "allowFreeProjects", "exposePublicProjects", "defaultDeploymentTarget", "supportedProjectTypes", "allowNewProjectUi", "learningBlocks", "allLearningBlocks", "developmentBoards", "allDevelopmentBoards", "organizationsLimit"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> Whitelabel:
        """Create an instance of Whitelabel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of theme
        if self.theme:
            _dict['theme'] = self.theme.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in custom_deployment_blocks (list)
        _items = []
        if self.custom_deployment_blocks:
            for _item in self.custom_deployment_blocks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['customDeploymentBlocks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in all_learning_blocks (list)
        _items = []
        if self.all_learning_blocks:
            for _item in self.all_learning_blocks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['allLearningBlocks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in development_boards (list)
        _items = []
        if self.development_boards:
            for _item in self.development_boards:
                if _item:
                    _items.append(_item.to_dict())
            _dict['developmentBoards'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in all_development_boards (list)
        _items = []
        if self.all_development_boards:
            for _item in self.all_development_boards:
                if _item:
                    _items.append(_item.to_dict())
            _dict['allDevelopmentBoards'] = _items
        # set to None if default_deployment_target (nullable) is None
        if self.default_deployment_target is None:
            _dict['defaultDeploymentTarget'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Whitelabel:
        """Create an instance of Whitelabel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Whitelabel.construct(**obj)

        _obj = Whitelabel.construct(**{
            "id": obj.get("id"),
            "name": obj.get("name"),
            "domain": obj.get("domain"),
            "owner_organization_id": obj.get("ownerOrganizationId"),
            "theme_id": obj.get("themeId"),
            "theme": Theme.from_dict(obj.get("theme")) if obj.get("theme") is not None else None,
            "identity_providers": obj.get("identityProviders"),
            "allow_password_auth": obj.get("allowPasswordAuth"),
            "deployment_targets": obj.get("deploymentTargets"),
            "all_deployment_targets": obj.get("allDeploymentTargets"),
            "custom_deployment_blocks": [WhitelabelCustomDeploymentBlocksInner.from_dict(_item) for _item in obj.get("customDeploymentBlocks")] if obj.get("customDeploymentBlocks") is not None else None,
            "deployment_options_order": obj.get("deploymentOptionsOrder"),
            "allow_signup": obj.get("allowSignup"),
            "allow_free_projects": obj.get("allowFreeProjects"),
            "expose_public_projects": obj.get("exposePublicProjects"),
            "default_deployment_target": obj.get("defaultDeploymentTarget"),
            "supported_project_types": obj.get("supportedProjectTypes"),
            "allow_new_project_ui": obj.get("allowNewProjectUi"),
            "learning_blocks": obj.get("learningBlocks"),
            "all_learning_blocks": [WhitelabelAllLearningBlocksInner.from_dict(_item) for _item in obj.get("allLearningBlocks")] if obj.get("allLearningBlocks") is not None else None,
            "development_boards": [DevelopmentBoardResponse.from_dict(_item) for _item in obj.get("developmentBoards")] if obj.get("developmentBoards") is not None else None,
            "all_development_boards": [DevelopmentBoardResponse.from_dict(_item) for _item in obj.get("allDevelopmentBoards")] if obj.get("allDevelopmentBoards") is not None else None,
            "organizations_limit": obj.get("organizationsLimit")
        })
        return _obj

