# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator
from edgeimpulse_api.models.verify_organization_bucket_response_all_of_files import VerifyOrganizationBucketResponseAllOfFiles

class VerifyOrganizationBucketResponseAllOf(BaseModel):
    connection_status: StrictStr = Field(..., alias="connectionStatus", description="Indicates the current state of the connectivity verification process. - \"connected\": Verification successful, other properties are available. - \"connecting\": Verification in progress, continue polling. - \"error\": Verification failed, check connectionError for details. ")
    connection_error: Optional[StrictStr] = Field(None, alias="connectionError", description="Provides additional details if connectionStatus is \"error\". Helps diagnose verification failures. ")
    connection_status_since: Optional[datetime] = Field(None, alias="connectionStatusSince", description="Timestamp of when the connectionStatus last changed. ")
    files: Optional[List[VerifyOrganizationBucketResponseAllOfFiles]] = Field(None, description="Random files from the bucket. Only available when connectionStatus is \"connected\".")
    has_info_labels_file: Optional[StrictBool] = Field(None, alias="hasInfoLabelsFile", description="Indicates whether there are any info.labels files in this bucket. If so, those are used for category/labels. Only available when connectionStatus is \"connected\". ")
    signed_url: Optional[StrictStr] = Field(None, alias="signedUrl", description="A signed URL that allows you to PUT an item, to check whether CORS headers are set up correctly for this bucket. Only available when connectionStatus is \"connected\". ")
    endpoint: Optional[StrictStr] = Field(None, description="An alternative endpoint URL. Only returned and required for Azure storage accounts, where the endpoint must be reformatted. This field will be undefined for other storage providers. ")
    __properties = ["connectionStatus", "connectionError", "connectionStatusSince", "files", "hasInfoLabelsFile", "signedUrl", "endpoint"]

    @validator('connection_status')
    def connection_status_validate_enum(cls, v):
        if v not in ('connected', 'connecting', 'error'):
            raise ValueError("must validate the enum values ('connected', 'connecting', 'error')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> VerifyOrganizationBucketResponseAllOf:
        """Create an instance of VerifyOrganizationBucketResponseAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item in self.files:
                if _item:
                    _items.append(_item.to_dict())
            _dict['files'] = _items
        # set to None if connection_error (nullable) is None
        if self.connection_error is None:
            _dict['connectionError'] = None

        # set to None if connection_status_since (nullable) is None
        if self.connection_status_since is None:
            _dict['connectionStatusSince'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VerifyOrganizationBucketResponseAllOf:
        """Create an instance of VerifyOrganizationBucketResponseAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return VerifyOrganizationBucketResponseAllOf.construct(**obj)

        _obj = VerifyOrganizationBucketResponseAllOf.construct(**{
            "connection_status": obj.get("connectionStatus"),
            "connection_error": obj.get("connectionError"),
            "connection_status_since": obj.get("connectionStatusSince"),
            "files": [VerifyOrganizationBucketResponseAllOfFiles.from_dict(_item) for _item in obj.get("files")] if obj.get("files") is not None else None,
            "has_info_labels_file": obj.get("hasInfoLabelsFile"),
            "signed_url": obj.get("signedUrl"),
            "endpoint": obj.get("endpoint")
        })
        return _obj

