# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, validator
from edgeimpulse_api.models.tuner_trial_blocks_inner import TunerTrialBlocksInner
from edgeimpulse_api.models.tuner_trial_dsp_job_id import TunerTrialDspJobId
from edgeimpulse_api.models.tuner_trial_impulse import TunerTrialImpulse
from edgeimpulse_api.models.tuner_trial_impulse_added_to_project import TunerTrialImpulseAddedToProject
from edgeimpulse_api.models.tuner_trial_metrics import TunerTrialMetrics
from edgeimpulse_api.models.tuner_trial_progress import TunerTrialProgress

class TunerTrial(BaseModel):
    id: StrictStr = ...
    name: StrictStr = ...
    status: StrictStr = ...
    last_completed_epoch: Optional[datetime] = Field(None, alias="lastCompletedEpoch")
    last_completed_training: Optional[datetime] = Field(None, alias="lastCompletedTraining")
    retries: Optional[StrictInt] = None
    current_epoch: Optional[StrictInt] = Field(None, alias="currentEpoch")
    worker_id: Optional[StrictStr] = Field(None, alias="workerId")
    blocks: List[TunerTrialBlocksInner] = ...
    impulse: TunerTrialImpulse = ...
    experiment: Optional[StrictStr] = None
    original_trial_id: Optional[StrictStr] = None
    model: Optional[Dict[str, Any]] = None
    dsp_job_id: Optional[TunerTrialDspJobId] = Field(None, alias="dspJobId")
    learn_job_id: Optional[float] = Field(None, alias="learnJobId")
    device_performance: Optional[Dict[str, Any]] = Field(None, alias="devicePerformance")
    optimization_round: Optional[float] = Field(None, alias="optimizationRound")
    progress: Optional[TunerTrialProgress] = None
    metrics: Optional[TunerTrialMetrics] = None
    impulse_added_to_project: Optional[TunerTrialImpulseAddedToProject] = Field(None, alias="impulseAddedToProject")
    __properties = ["id", "name", "status", "lastCompletedEpoch", "lastCompletedTraining", "retries", "currentEpoch", "workerId", "blocks", "impulse", "experiment", "original_trial_id", "model", "dspJobId", "learnJobId", "devicePerformance", "optimizationRound", "progress", "metrics", "impulseAddedToProject"]

    @validator('status')
    def status_validate_enum(cls, v):
        if v not in ('pending', 'running', 'completed', 'failed'):
            raise ValueError("must validate the enum values ('pending', 'running', 'completed', 'failed')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> TunerTrial:
        """Create an instance of TunerTrial from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in blocks (list)
        _items = []
        if self.blocks:
            for _item in self.blocks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['blocks'] = _items
        # override the default output from pydantic by calling `to_dict()` of impulse
        if self.impulse:
            _dict['impulse'] = self.impulse.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dsp_job_id
        if self.dsp_job_id:
            _dict['dspJobId'] = self.dsp_job_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of progress
        if self.progress:
            _dict['progress'] = self.progress.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metrics
        if self.metrics:
            _dict['metrics'] = self.metrics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of impulse_added_to_project
        if self.impulse_added_to_project:
            _dict['impulseAddedToProject'] = self.impulse_added_to_project.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TunerTrial:
        """Create an instance of TunerTrial from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TunerTrial.construct(**obj)

        _obj = TunerTrial.construct(**{
            "id": obj.get("id"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "last_completed_epoch": obj.get("lastCompletedEpoch"),
            "last_completed_training": obj.get("lastCompletedTraining"),
            "retries": obj.get("retries"),
            "current_epoch": obj.get("currentEpoch"),
            "worker_id": obj.get("workerId"),
            "blocks": [TunerTrialBlocksInner.from_dict(_item) for _item in obj.get("blocks")] if obj.get("blocks") is not None else None,
            "impulse": TunerTrialImpulse.from_dict(obj.get("impulse")) if obj.get("impulse") is not None else None,
            "experiment": obj.get("experiment"),
            "original_trial_id": obj.get("original_trial_id"),
            "model": obj.get("model"),
            "dsp_job_id": TunerTrialDspJobId.from_dict(obj.get("dspJobId")) if obj.get("dspJobId") is not None else None,
            "learn_job_id": obj.get("learnJobId"),
            "device_performance": obj.get("devicePerformance"),
            "optimization_round": obj.get("optimizationRound"),
            "progress": TunerTrialProgress.from_dict(obj.get("progress")) if obj.get("progress") is not None else None,
            "metrics": TunerTrialMetrics.from_dict(obj.get("metrics")) if obj.get("metrics") is not None else None,
            "impulse_added_to_project": TunerTrialImpulseAddedToProject.from_dict(obj.get("impulseAddedToProject")) if obj.get("impulseAddedToProject") is not None else None
        })
        return _obj

