# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class TrashBinEntity(BaseModel):
    id: StrictInt = Field(..., description="The ID of the entity in the trash bin. This is not the same as the user, project or organization ID.")
    organization_id: Optional[StrictInt] = Field(None, alias="organizationId", description="The ID of the organization in the trash bin. This should only be set if the entity is an organization (userId and projectId should be null in this case). ")
    user_id: Optional[StrictInt] = Field(None, alias="userId", description="The ID of the user in the trash bin. This should only be set if the entity is a user (organizationId and projectId should be null in this case). ")
    project_id: Optional[StrictInt] = Field(None, alias="projectId", description="The ID of the project in the trash bin. This should only be set if the entity is a project (organizationId and userId should be null in this case). ")
    name: StrictStr = Field(..., description="The name of the entity in the trash bin.")
    deleted_at: datetime = Field(..., alias="deletedAt", description="The timestamp when the entity was moved to the trash bin.")
    deletion_requested_by_user_email: StrictStr = Field(..., alias="deletionRequestedByUserEmail", description="The email of the user that requested the deletion.")
    __properties = ["id", "organizationId", "userId", "projectId", "name", "deletedAt", "deletionRequestedByUserEmail"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> TrashBinEntity:
        """Create an instance of TrashBinEntity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TrashBinEntity:
        """Create an instance of TrashBinEntity from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TrashBinEntity.construct(**obj)

        _obj = TrashBinEntity.construct(**{
            "id": obj.get("id"),
            "organization_id": obj.get("organizationId"),
            "user_id": obj.get("userId"),
            "project_id": obj.get("projectId"),
            "name": obj.get("name"),
            "deleted_at": obj.get("deletedAt"),
            "deletion_requested_by_user_email": obj.get("deletionRequestedByUserEmail")
        })
        return _obj

