# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.ai_actions_data_category import AIActionsDataCategory

class PreviewAIActionsSamplesRequest(BaseModel):
    save_config: StrictBool = Field(..., alias="saveConfig", description="If this is passed in, the `previewConfig` of the AI action is overwritten (requires actionId to be a valid action).")
    data_category: AIActionsDataCategory = Field(..., alias="dataCategory")
    data_metadata_key: Optional[StrictStr] = Field(None, alias="dataMetadataKey", description="Metadata key to filter on. Required if dataCategory is equal to \"dataWithoutMetadataKey\" or \"dataWithMetadata\".")
    data_metadata_value: Optional[StrictStr] = Field(None, alias="dataMetadataValue", description="Metadata value to filter on. Required if dataCategory is equal to \"dataWithMetadata\".")
    max_data_preview_count: StrictInt = Field(..., alias="maxDataPreviewCount", description="Max. amount of data items to return.")
    __properties = ["saveConfig", "dataCategory", "dataMetadataKey", "dataMetadataValue", "maxDataPreviewCount"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> PreviewAIActionsSamplesRequest:
        """Create an instance of PreviewAIActionsSamplesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PreviewAIActionsSamplesRequest:
        """Create an instance of PreviewAIActionsSamplesRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PreviewAIActionsSamplesRequest.construct(**obj)

        _obj = PreviewAIActionsSamplesRequest.construct(**{
            "save_config": obj.get("saveConfig"),
            "data_category": obj.get("dataCategory"),
            "data_metadata_key": obj.get("dataMetadataKey"),
            "data_metadata_value": obj.get("dataMetadataValue"),
            "max_data_preview_count": obj.get("maxDataPreviewCount")
        })
        return _obj

