# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.ai_actions_operates_on import AIActionsOperatesOn
from edgeimpulse_api.models.created_updated_by_user import CreatedUpdatedByUser
from edgeimpulse_api.models.dsp_group_item import DSPGroupItem
from edgeimpulse_api.models.environment_variable import EnvironmentVariable
from edgeimpulse_api.models.transformation_block_additional_mount_point import TransformationBlockAdditionalMountPoint
from edgeimpulse_api.models.transformation_job_operates_on_enum import TransformationJobOperatesOnEnum

class OrganizationTransformationBlock(BaseModel):
    id: StrictInt = ...
    name: StrictStr = ...
    docker_container: StrictStr = Field(..., alias="dockerContainer")
    docker_container_managed_by_edge_impulse: StrictBool = Field(..., alias="dockerContainerManagedByEdgeImpulse")
    created: datetime = ...
    created_by_user: Optional[CreatedUpdatedByUser] = Field(None, alias="createdByUser")
    last_updated: Optional[datetime] = Field(None, alias="lastUpdated")
    last_updated_by_user: Optional[CreatedUpdatedByUser] = Field(None, alias="lastUpdatedByUser")
    user_id: Optional[StrictInt] = Field(None, alias="userId")
    user_name: Optional[StrictStr] = Field(None, alias="userName")
    description: StrictStr = ...
    cli_arguments: StrictStr = Field(..., alias="cliArguments", description="These arguments are passed into the container")
    ind_metadata: StrictBool = Field(..., alias="indMetadata")
    requests_cpu: Optional[float] = Field(None, alias="requestsCpu")
    requests_memory: Optional[StrictInt] = Field(None, alias="requestsMemory")
    limits_cpu: Optional[float] = Field(None, alias="limitsCpu")
    limits_memory: Optional[StrictInt] = Field(None, alias="limitsMemory")
    additional_mount_points: List[TransformationBlockAdditionalMountPoint] = Field(..., alias="additionalMountPoints")
    operates_on: TransformationJobOperatesOnEnum = Field(..., alias="operatesOn")
    allow_extra_cli_arguments: StrictBool = Field(..., alias="allowExtraCliArguments")
    parameters: Optional[List[Dict[str, Any]]] = Field(None, description="List of parameters, spec'ed according to https://docs.edgeimpulse.com/docs/tips-and-tricks/adding-parameters-to-custom-blocks")
    parameters_ui: Optional[List[DSPGroupItem]] = Field(None, alias="parametersUI", description="List of parameters to be rendered in the UI")
    max_running_time_str: Optional[StrictStr] = Field(None, alias="maxRunningTimeStr", description="15m for 15 minutes, 2h for 2 hours, 1d for 1 day. If not set, the default is 8 hours.")
    source_code_available: StrictBool = Field(..., alias="sourceCodeAvailable")
    repository_url: Optional[StrictStr] = Field(None, alias="repositoryUrl", description="URL to the source code of this custom learn block.")
    is_public: StrictBool = Field(..., alias="isPublic", description="Whether this block is publicly available to Edge Impulse users (if false, then only for members of the owning organization)")
    show_in_data_sources: StrictBool = Field(..., alias="showInDataSources", description="Whether to show this block in 'Data sources'. Only applies for standalone blocks.")
    show_in_create_transformation_job: StrictBool = Field(..., alias="showInCreateTransformationJob", description="Whether to show this block in 'Create transformation job'. Only applies for standalone blocks.")
    show_in_synthetic_data: StrictBool = Field(..., alias="showInSyntheticData", description="Whether to show this block in 'Synthetic data'. Only applies for standalone blocks.")
    show_in_ai_actions: StrictBool = Field(..., alias="showInAIActions", description="Whether to show this block in 'AI Labeling'. Only applies for standalone blocks.")
    environment_variables: List[EnvironmentVariable] = Field(..., alias="environmentVariables", description="Extra environmental variables that are passed into the transformation block (key/value pairs).")
    ai_actions_operates_on: Optional[List[AIActionsOperatesOn]] = Field(None, alias="aiActionsOperatesOn", description="For AI labeling blocks, this lists the data types that the block supports. If this field is empty then there's no information about supported data types.")
    __properties = ["id", "name", "dockerContainer", "dockerContainerManagedByEdgeImpulse", "created", "createdByUser", "lastUpdated", "lastUpdatedByUser", "userId", "userName", "description", "cliArguments", "indMetadata", "requestsCpu", "requestsMemory", "limitsCpu", "limitsMemory", "additionalMountPoints", "operatesOn", "allowExtraCliArguments", "parameters", "parametersUI", "maxRunningTimeStr", "sourceCodeAvailable", "repositoryUrl", "isPublic", "showInDataSources", "showInCreateTransformationJob", "showInSyntheticData", "showInAIActions", "environmentVariables", "aiActionsOperatesOn"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationTransformationBlock:
        """Create an instance of OrganizationTransformationBlock from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by_user
        if self.created_by_user:
            _dict['createdByUser'] = self.created_by_user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_updated_by_user
        if self.last_updated_by_user:
            _dict['lastUpdatedByUser'] = self.last_updated_by_user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in additional_mount_points (list)
        _items = []
        if self.additional_mount_points:
            for _item in self.additional_mount_points:
                if _item:
                    _items.append(_item.to_dict())
            _dict['additionalMountPoints'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in parameters_ui (list)
        _items = []
        if self.parameters_ui:
            for _item in self.parameters_ui:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parametersUI'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in environment_variables (list)
        _items = []
        if self.environment_variables:
            for _item in self.environment_variables:
                if _item:
                    _items.append(_item.to_dict())
            _dict['environmentVariables'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationTransformationBlock:
        """Create an instance of OrganizationTransformationBlock from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationTransformationBlock.construct(**obj)

        _obj = OrganizationTransformationBlock.construct(**{
            "id": obj.get("id"),
            "name": obj.get("name"),
            "docker_container": obj.get("dockerContainer"),
            "docker_container_managed_by_edge_impulse": obj.get("dockerContainerManagedByEdgeImpulse"),
            "created": obj.get("created"),
            "created_by_user": CreatedUpdatedByUser.from_dict(obj.get("createdByUser")) if obj.get("createdByUser") is not None else None,
            "last_updated": obj.get("lastUpdated"),
            "last_updated_by_user": CreatedUpdatedByUser.from_dict(obj.get("lastUpdatedByUser")) if obj.get("lastUpdatedByUser") is not None else None,
            "user_id": obj.get("userId"),
            "user_name": obj.get("userName"),
            "description": obj.get("description"),
            "cli_arguments": obj.get("cliArguments"),
            "ind_metadata": obj.get("indMetadata"),
            "requests_cpu": obj.get("requestsCpu"),
            "requests_memory": obj.get("requestsMemory"),
            "limits_cpu": obj.get("limitsCpu"),
            "limits_memory": obj.get("limitsMemory"),
            "additional_mount_points": [TransformationBlockAdditionalMountPoint.from_dict(_item) for _item in obj.get("additionalMountPoints")] if obj.get("additionalMountPoints") is not None else None,
            "operates_on": obj.get("operatesOn"),
            "allow_extra_cli_arguments": obj.get("allowExtraCliArguments"),
            "parameters": obj.get("parameters"),
            "parameters_ui": [DSPGroupItem.from_dict(_item) for _item in obj.get("parametersUI")] if obj.get("parametersUI") is not None else None,
            "max_running_time_str": obj.get("maxRunningTimeStr"),
            "source_code_available": obj.get("sourceCodeAvailable"),
            "repository_url": obj.get("repositoryUrl"),
            "is_public": obj.get("isPublic"),
            "show_in_data_sources": obj.get("showInDataSources"),
            "show_in_create_transformation_job": obj.get("showInCreateTransformationJob"),
            "show_in_synthetic_data": obj.get("showInSyntheticData"),
            "show_in_ai_actions": obj.get("showInAIActions"),
            "environment_variables": [EnvironmentVariable.from_dict(_item) for _item in obj.get("environmentVariables")] if obj.get("environmentVariables") is not None else None,
            "ai_actions_operates_on": obj.get("aiActionsOperatesOn")
        })
        return _obj

