# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.storage_provider import StorageProvider

class OrganizationBucket(BaseModel):
    id: StrictInt = ...
    access_key: StrictStr = Field(..., alias="accessKey", description="Access key for the storage service")
    endpoint: StrictStr = Field(..., description="Endpoint URL for the storage service")
    bucket: StrictStr = Field(..., description="Name of the storage bucket")
    region: StrictStr = Field(..., description="Region of the storage service (if applicable)")
    connected: StrictBool = Field(..., description="Whether we can reach the bucket")
    check_connectivity_prefix: Optional[StrictStr] = Field(None, alias="checkConnectivityPrefix", description="Optional prefix used for connectivity verification when root bucket access is restricted. ")
    storage_provider: StorageProvider = Field(..., alias="storageProvider")
    storage_account_name: Optional[StrictStr] = Field(None, alias="storageAccountName", description="The name of the storage account for Azure Blob Storage")
    __properties = ["id", "accessKey", "endpoint", "bucket", "region", "connected", "checkConnectivityPrefix", "storageProvider", "storageAccountName"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationBucket:
        """Create an instance of OrganizationBucket from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationBucket:
        """Create an instance of OrganizationBucket from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationBucket.construct(**obj)

        _obj = OrganizationBucket.construct(**{
            "id": obj.get("id"),
            "access_key": obj.get("accessKey"),
            "endpoint": obj.get("endpoint"),
            "bucket": obj.get("bucket"),
            "region": obj.get("region"),
            "connected": obj.get("connected"),
            "check_connectivity_prefix": obj.get("checkConnectivityPrefix"),
            "storage_provider": obj.get("storageProvider"),
            "storage_account_name": obj.get("storageAccountName")
        })
        return _obj

