# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from edgeimpulse_api.models.keras_custom_metric import KerasCustomMetric
from edgeimpulse_api.models.keras_model_metadata_metrics_on_device_performance_inner_tflite import KerasModelMetadataMetricsOnDevicePerformanceInnerTflite

class KerasModelMetadataMetricsOnDevicePerformanceInner(BaseModel):
    mcu: StrictStr = ...
    name: StrictStr = ...
    is_default: StrictBool = Field(..., alias="isDefault")
    latency: float = ...
    tflite: KerasModelMetadataMetricsOnDevicePerformanceInnerTflite = ...
    eon: KerasModelMetadataMetricsOnDevicePerformanceInnerTflite = ...
    eon_ram_optimized: Optional[KerasModelMetadataMetricsOnDevicePerformanceInnerTflite] = None
    custom_metrics: Optional[List[KerasCustomMetric]] = Field(None, alias="customMetrics", description="Custom, device-specific performance metrics")
    __properties = ["mcu", "name", "isDefault", "latency", "tflite", "eon", "eon_ram_optimized", "customMetrics"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> KerasModelMetadataMetricsOnDevicePerformanceInner:
        """Create an instance of KerasModelMetadataMetricsOnDevicePerformanceInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of tflite
        if self.tflite:
            _dict['tflite'] = self.tflite.to_dict()
        # override the default output from pydantic by calling `to_dict()` of eon
        if self.eon:
            _dict['eon'] = self.eon.to_dict()
        # override the default output from pydantic by calling `to_dict()` of eon_ram_optimized
        if self.eon_ram_optimized:
            _dict['eon_ram_optimized'] = self.eon_ram_optimized.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in custom_metrics (list)
        _items = []
        if self.custom_metrics:
            for _item in self.custom_metrics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['customMetrics'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> KerasModelMetadataMetricsOnDevicePerformanceInner:
        """Create an instance of KerasModelMetadataMetricsOnDevicePerformanceInner from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return KerasModelMetadataMetricsOnDevicePerformanceInner.construct(**obj)

        _obj = KerasModelMetadataMetricsOnDevicePerformanceInner.construct(**{
            "mcu": obj.get("mcu"),
            "name": obj.get("name"),
            "is_default": obj.get("isDefault"),
            "latency": obj.get("latency"),
            "tflite": KerasModelMetadataMetricsOnDevicePerformanceInnerTflite.from_dict(obj.get("tflite")) if obj.get("tflite") is not None else None,
            "eon": KerasModelMetadataMetricsOnDevicePerformanceInnerTflite.from_dict(obj.get("eon")) if obj.get("eon") is not None else None,
            "eon_ram_optimized": KerasModelMetadataMetricsOnDevicePerformanceInnerTflite.from_dict(obj.get("eon_ram_optimized")) if obj.get("eon_ram_optimized") is not None else None,
            "custom_metrics": [KerasCustomMetric.from_dict(_item) for _item in obj.get("customMetrics")] if obj.get("customMetrics") is not None else None
        })
        return _obj

