# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class BlockParamsVisualAnomalyPatchcore(BaseModel):
    backbone: Optional[StrictStr] = Field(None, description="The backbone to use for feature extraction")
    num_layers: Optional[StrictInt] = Field(None, alias="numLayers", description="The number of layers in the feature extractor (1-3)")
    pool_size: Optional[StrictInt] = Field(None, alias="poolSize", description="The pool size for the feature extractor")
    sampling_ratio: Optional[float] = Field(None, alias="samplingRatio", description="The sampling ratio for the coreset, used for anomaly scoring")
    num_nearest_neighbors: Optional[StrictInt] = Field(None, alias="numNearestNeighbors", description="The number of nearest neighbors to consider, used for anomaly scoring")
    __properties = ["backbone", "numLayers", "poolSize", "samplingRatio", "numNearestNeighbors"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> BlockParamsVisualAnomalyPatchcore:
        """Create an instance of BlockParamsVisualAnomalyPatchcore from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BlockParamsVisualAnomalyPatchcore:
        """Create an instance of BlockParamsVisualAnomalyPatchcore from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BlockParamsVisualAnomalyPatchcore.construct(**obj)

        _obj = BlockParamsVisualAnomalyPatchcore.construct(**{
            "backbone": obj.get("backbone"),
            "num_layers": obj.get("numLayers"),
            "pool_size": obj.get("poolSize"),
            "sampling_ratio": obj.get("samplingRatio"),
            "num_nearest_neighbors": obj.get("numNearestNeighbors")
        })
        return _obj

