# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class AdminUpdateTrialRequest(BaseModel):
    expiration_date: Optional[datetime] = Field(None, alias="expirationDate", description="Expiration date of the trial. The trial will be set as expired after this date. There will be a grace period of 30 days after a trial expires before fully deleting the trial organization. This field is ignored if the trial is requested by a non-admin user, defaulting to 14 days trial.")
    notes: Optional[StrictStr] = Field(None, description="Notes about the trial. Free form text. This field is ignored if the trial is requested by a non-admin user.")
    __properties = ["expirationDate", "notes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> AdminUpdateTrialRequest:
        """Create an instance of AdminUpdateTrialRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AdminUpdateTrialRequest:
        """Create an instance of AdminUpdateTrialRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AdminUpdateTrialRequest.construct(**obj)

        _obj = AdminUpdateTrialRequest.construct(**{
            "expiration_date": obj.get("expirationDate"),
            "notes": obj.get("notes")
        })
        return _obj

