# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr

from typing import List, Optional

from edgeimpulse_api.models.deployment_target_engine import DeploymentTargetEngine
from edgeimpulse_api.models.deployment_targets_response import DeploymentTargetsResponse
from edgeimpulse_api.models.evaluate_job_response import EvaluateJobResponse
from edgeimpulse_api.models.generic_api_response import GenericApiResponse
from edgeimpulse_api.models.get_deployment_response import GetDeploymentResponse
from edgeimpulse_api.models.get_last_deployment_build_response import GetLastDeploymentBuildResponse
from edgeimpulse_api.models.get_syntiant_posterior_response import GetSyntiantPosteriorResponse
from edgeimpulse_api.models.keras_model_type_enum import KerasModelTypeEnum
from edgeimpulse_api.models.project_deployment_targets_response import ProjectDeploymentTargetsResponse
from edgeimpulse_api.models.set_syntiant_posterior_request import SetSyntiantPosteriorRequest
from edgeimpulse_api.models.start_job_response import StartJobResponse

from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DeploymentApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def download_build(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], type : Annotated[StrictStr, Field(..., description="The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type.")], model_type : Annotated[Optional[KerasModelTypeEnum], Field(description="Optional model type of the build (if not, it uses the settings in the Keras block)")] = None, engine : Annotated[Optional[DeploymentTargetEngine], Field(description="Optional engine for the build (if not, it uses the default engine for the deployment target)")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> str:  # noqa: E501
        """Download

        Download the build artefacts for a project

        :param project_id: Project ID (required)
        :type project_id: int
        :param type: The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type. (required)
        :type type: str
        :param model_type: Optional model type of the build (if not, it uses the settings in the Keras block)
        :type model_type: KerasModelTypeEnum
        :param engine: Optional engine for the build (if not, it uses the default engine for the deployment target)
        :type engine: DeploymentTargetEngine
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._download_build_with_http_info(project_id, type, model_type, engine, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _download_build_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], type : Annotated[StrictStr, Field(..., description="The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type.")], model_type : Annotated[Optional[KerasModelTypeEnum], Field(description="Optional model type of the build (if not, it uses the settings in the Keras block)")] = None, engine : Annotated[Optional[DeploymentTargetEngine], Field(description="Optional engine for the build (if not, it uses the default engine for the deployment target)")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Download 

        Download the build artefacts for a project

        :param project_id: Project ID (required)
        :type project_id: int
        :param type: The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type. (required)
        :type type: str
        :param model_type: Optional model type of the build (if not, it uses the settings in the Keras block)
        :type model_type: KerasModelTypeEnum
        :param engine: Optional engine for the build (if not, it uses the default engine for the deployment target)
        :type engine: DeploymentTargetEngine
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'type',
            'model_type',
            'engine',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_build" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type']))
        if _params.get('model_type') is not None:  # noqa: E501
            _query_params.append(('modelType', _params['model_type']))
        if _params.get('engine') is not None:  # noqa: E501
            _query_params.append(('engine', _params['engine']))
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/deployment/download', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def find_syntiant_posterior(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], target_words : List[StrictStr], reference_set : StrictStr, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, wav_file : Optional[StrictStr] = None, meta_csv_file : Optional[StrictStr] = None, deployment_target : Optional[StrictStr] = None, **kwargs) -> StartJobResponse:  # noqa: E501
        """Find Syntiant posterior parameters

        Automatically find the current posterior parameters for the Syntiant deployment target

        :param project_id: Project ID (required)
        :type project_id: int
        :param target_words: (required)
        :type target_words: List[str]
        :param reference_set: (required)
        :type reference_set: str
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param wav_file:
        :type wav_file: str
        :param meta_csv_file:
        :type meta_csv_file: str
        :param deployment_target:
        :type deployment_target: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._find_syntiant_posterior_with_http_info(project_id, target_words, reference_set, impulse_id, wav_file, meta_csv_file, deployment_target, **kwargs)  # noqa: E501

    @validate_arguments
    def _find_syntiant_posterior_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], target_words : List[StrictStr], reference_set : StrictStr, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, wav_file : Optional[StrictStr] = None, meta_csv_file : Optional[StrictStr] = None, deployment_target : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """Find Syntiant posterior parameters 

        Automatically find the current posterior parameters for the Syntiant deployment target

        :param project_id: Project ID (required)
        :type project_id: int
        :param target_words: (required)
        :type target_words: List[str]
        :param reference_set: (required)
        :type reference_set: str
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param wav_file:
        :type wav_file: str
        :param meta_csv_file:
        :type meta_csv_file: str
        :param deployment_target:
        :type deployment_target: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'target_words',
            'reference_set',
            'impulse_id',
            'wav_file',
            'meta_csv_file',
            'deployment_target'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_syntiant_posterior" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}
        if _params['target_words']:
            _form_params.append(('targetWords', _params['target_words']))
            _collection_formats['targetWords'] = 'csv'
        if _params['reference_set']:
            _form_params.append(('referenceSet', _params['reference_set']))
        if _params['wav_file']:
            _files['wavFile'] = _params['wav_file']
        if _params['meta_csv_file']:
            _files['metaCsvFile'] = _params['meta_csv_file']
        if _params['deployment_target']:
            _form_params.append(('deploymentTarget', _params['deployment_target']))

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/jobs/find-syntiant-posterior', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_deployment(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], type : Annotated[StrictStr, Field(..., description="The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type.")], model_type : Annotated[Optional[KerasModelTypeEnum], Field(description="Optional model type of the build (if not, it uses the settings in the Keras block)")] = None, engine : Annotated[Optional[DeploymentTargetEngine], Field(description="Optional engine for the build (if not, it uses the default engine for the deployment target)")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> GetDeploymentResponse:  # noqa: E501
        """Get deployment info

        Gives information on whether a deployment was already built for a type

        :param project_id: Project ID (required)
        :type project_id: int
        :param type: The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type. (required)
        :type type: str
        :param model_type: Optional model type of the build (if not, it uses the settings in the Keras block)
        :type model_type: KerasModelTypeEnum
        :param engine: Optional engine for the build (if not, it uses the default engine for the deployment target)
        :type engine: DeploymentTargetEngine
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetDeploymentResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_deployment_with_http_info(project_id, type, model_type, engine, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_deployment_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], type : Annotated[StrictStr, Field(..., description="The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type.")], model_type : Annotated[Optional[KerasModelTypeEnum], Field(description="Optional model type of the build (if not, it uses the settings in the Keras block)")] = None, engine : Annotated[Optional[DeploymentTargetEngine], Field(description="Optional engine for the build (if not, it uses the default engine for the deployment target)")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Get deployment info 

        Gives information on whether a deployment was already built for a type

        :param project_id: Project ID (required)
        :type project_id: int
        :param type: The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type. (required)
        :type type: str
        :param model_type: Optional model type of the build (if not, it uses the settings in the Keras block)
        :type model_type: KerasModelTypeEnum
        :param engine: Optional engine for the build (if not, it uses the default engine for the deployment target)
        :type engine: DeploymentTargetEngine
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetDeploymentResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'type',
            'model_type',
            'engine',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type']))
        if _params.get('model_type') is not None:  # noqa: E501
            _query_params.append(('modelType', _params['model_type']))
        if _params.get('engine') is not None:  # noqa: E501
            _query_params.append(('engine', _params['engine']))
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetDeploymentResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/deployment', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_evaluate_job_result(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> EvaluateJobResponse:  # noqa: E501
        """Evaluate job result

        Get evaluate job result, containing detailed performance statistics for every possible variant of the impulse.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EvaluateJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_evaluate_job_result_with_http_info(project_id, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_evaluate_job_result_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Evaluate job result 

        Get evaluate job result, containing detailed performance statistics for every possible variant of the impulse.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EvaluateJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_evaluate_job_result" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "EvaluateJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/deployment/evaluate', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_evaluate_job_result_cache(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> EvaluateJobResponse:  # noqa: E501
        """Check evaluate job result (cache)

        Get evaluate job result, containing detailed performance statistics for every possible variant of the impulse. This only checks cache, and throws an error if there is no data in cache.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EvaluateJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_evaluate_job_result_cache_with_http_info(project_id, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_evaluate_job_result_cache_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Check evaluate job result (cache) 

        Get evaluate job result, containing detailed performance statistics for every possible variant of the impulse. This only checks cache, and throws an error if there is no data in cache.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EvaluateJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_evaluate_job_result_cache" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "EvaluateJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/deployment/evaluate/cache', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_last_deployment_build(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> GetLastDeploymentBuildResponse:  # noqa: E501
        """Get information on the last deployment build

        Get information on the result of the last successful deployment job, including info on the build e.g. whether it is still valid.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetLastDeploymentBuildResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_last_deployment_build_with_http_info(project_id, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_last_deployment_build_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Get information on the last deployment build 

        Get information on the result of the last successful deployment job, including info on the build e.g. whether it is still valid.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetLastDeploymentBuildResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_last_deployment_build" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetLastDeploymentBuildResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/deployment/last', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_syntiant_posterior(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> GetSyntiantPosteriorResponse:  # noqa: E501
        """Get Syntiant posterior parameters

        Get the current posterior parameters for the Syntiant deployment target

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSyntiantPosteriorResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_syntiant_posterior_with_http_info(project_id, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_syntiant_posterior_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Get Syntiant posterior parameters 

        Get the current posterior parameters for the Syntiant deployment target

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetSyntiantPosteriorResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_syntiant_posterior" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetSyntiantPosteriorResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/deployment/syntiant/posterior', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_all_deployment_targets(self, **kwargs) -> DeploymentTargetsResponse:  # noqa: E501
        """Deployment targets

        List all deployment targets

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeploymentTargetsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_all_deployment_targets_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def _list_all_deployment_targets_with_http_info(self, **kwargs):  # noqa: E501
        """Deployment targets 

        List all deployment targets

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeploymentTargetsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_deployment_targets" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DeploymentTargetsResponse",
        }

        return self.api_client.call_api(
            '/api/deployment/targets', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_deployment_targets_for_project(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> ProjectDeploymentTargetsResponse:  # noqa: E501
        """Deployment targets

        List deployment targets for a project

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ProjectDeploymentTargetsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_deployment_targets_for_project_with_http_info(project_id, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_deployment_targets_for_project_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Deployment targets 

        List deployment targets for a project

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ProjectDeploymentTargetsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_deployment_targets_for_project" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ProjectDeploymentTargetsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/deployment/targets', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_deployment_targets_for_project_data_sources(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> DeploymentTargetsResponse:  # noqa: E501
        """Deployment targets (data sources)

        List deployment targets for a project from data sources page  (it shows some things like all Linux deploys, and hides 'fake' deploy targets like mobile phone / computer)

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeploymentTargetsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_deployment_targets_for_project_data_sources_with_http_info(project_id, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_deployment_targets_for_project_data_sources_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Deployment targets (data sources) 

        List deployment targets for a project from data sources page  (it shows some things like all Linux deploys, and hides 'fake' deploy targets like mobile phone / computer)

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeploymentTargetsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_deployment_targets_for_project_data_sources" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DeploymentTargetsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/deployment/targets/data-sources', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def set_syntiant_posterior(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], set_syntiant_posterior_request : SetSyntiantPosteriorRequest, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Set Syntiant posterior parameters

        Set the current posterior parameters for the Syntiant deployment target

        :param project_id: Project ID (required)
        :type project_id: int
        :param set_syntiant_posterior_request: (required)
        :type set_syntiant_posterior_request: SetSyntiantPosteriorRequest
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._set_syntiant_posterior_with_http_info(project_id, set_syntiant_posterior_request, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _set_syntiant_posterior_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], set_syntiant_posterior_request : SetSyntiantPosteriorRequest, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Set Syntiant posterior parameters 

        Set the current posterior parameters for the Syntiant deployment target

        :param project_id: Project ID (required)
        :type project_id: int
        :param set_syntiant_posterior_request: (required)
        :type set_syntiant_posterior_request: SetSyntiantPosteriorRequest
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'set_syntiant_posterior_request',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_syntiant_posterior" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['set_syntiant_posterior_request']:
            _body_params = _params['set_syntiant_posterior_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/deployment/syntiant/posterior', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
