"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys
import video.coordinator.event_v1.event_pb2
import video.coordinator.push_v1.push_pb2
import video.coordinator.user_v1.user_pb2

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class WebsocketEvent(google.protobuf.message.Message):
    """WebsocketEvent only includes events that are sent to the client via websocket connection
    This is not an exhaustive list of events, since not all of them are sent via websocket
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class UsersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> video.coordinator.user_v1.user_pb2.User: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: video.coordinator.user_v1.user_pb2.User | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    USERS_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    HEALTHCHECK_FIELD_NUMBER: builtins.int
    CALL_CREATED_FIELD_NUMBER: builtins.int
    CALL_UPDATED_FIELD_NUMBER: builtins.int
    CALL_DELETED_FIELD_NUMBER: builtins.int
    CALL_MEMBERS_CREATED_FIELD_NUMBER: builtins.int
    CALL_MEMBERS_UPDATED_FIELD_NUMBER: builtins.int
    CALL_MEMBERS_DELETED_FIELD_NUMBER: builtins.int
    CALL_ENDED_FIELD_NUMBER: builtins.int
    CALL_ACCEPTED_FIELD_NUMBER: builtins.int
    CALL_REJECTED_FIELD_NUMBER: builtins.int
    CALL_CANCELLED_FIELD_NUMBER: builtins.int
    USER_UPDATED_FIELD_NUMBER: builtins.int
    CALL_CUSTOM_FIELD_NUMBER: builtins.int
    @property
    def users(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, video.coordinator.user_v1.user_pb2.User]:
        """All users mentioned in the event payload, indexed by User.id"""
    @property
    def error(self) -> global___WebsocketError: ...
    @property
    def healthcheck(self) -> global___WebsocketHealthcheck: ...
    @property
    def call_created(self) -> video.coordinator.event_v1.event_pb2.CallCreated:
        """Call events"""
    @property
    def call_updated(self) -> video.coordinator.event_v1.event_pb2.CallUpdated: ...
    @property
    def call_deleted(self) -> video.coordinator.event_v1.event_pb2.CallDeleted: ...
    @property
    def call_members_created(self) -> video.coordinator.event_v1.event_pb2.CallMembersCreated: ...
    @property
    def call_members_updated(self) -> video.coordinator.event_v1.event_pb2.CallMembersUpdated: ...
    @property
    def call_members_deleted(self) -> video.coordinator.event_v1.event_pb2.CallMembersDeleted: ...
    @property
    def call_ended(self) -> video.coordinator.event_v1.event_pb2.CallEnded: ...
    @property
    def call_accepted(self) -> video.coordinator.event_v1.event_pb2.CallAccepted:
        """User initiated call events"""
    @property
    def call_rejected(self) -> video.coordinator.event_v1.event_pb2.CallRejected: ...
    @property
    def call_cancelled(self) -> video.coordinator.event_v1.event_pb2.CallCancelled: ...
    @property
    def user_updated(self) -> video.coordinator.event_v1.event_pb2.UserUpdated:
        """User events"""
    @property
    def call_custom(self) -> video.coordinator.event_v1.event_pb2.CallCustom:
        """Custom event"""
    def __init__(
        self,
        *,
        users: collections.abc.Mapping[builtins.str, video.coordinator.user_v1.user_pb2.User] | None = ...,
        error: global___WebsocketError | None = ...,
        healthcheck: global___WebsocketHealthcheck | None = ...,
        call_created: video.coordinator.event_v1.event_pb2.CallCreated | None = ...,
        call_updated: video.coordinator.event_v1.event_pb2.CallUpdated | None = ...,
        call_deleted: video.coordinator.event_v1.event_pb2.CallDeleted | None = ...,
        call_members_created: video.coordinator.event_v1.event_pb2.CallMembersCreated | None = ...,
        call_members_updated: video.coordinator.event_v1.event_pb2.CallMembersUpdated | None = ...,
        call_members_deleted: video.coordinator.event_v1.event_pb2.CallMembersDeleted | None = ...,
        call_ended: video.coordinator.event_v1.event_pb2.CallEnded | None = ...,
        call_accepted: video.coordinator.event_v1.event_pb2.CallAccepted | None = ...,
        call_rejected: video.coordinator.event_v1.event_pb2.CallRejected | None = ...,
        call_cancelled: video.coordinator.event_v1.event_pb2.CallCancelled | None = ...,
        user_updated: video.coordinator.event_v1.event_pb2.UserUpdated | None = ...,
        call_custom: video.coordinator.event_v1.event_pb2.CallCustom | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["call_accepted", b"call_accepted", "call_cancelled", b"call_cancelled", "call_created", b"call_created", "call_custom", b"call_custom", "call_deleted", b"call_deleted", "call_ended", b"call_ended", "call_members_created", b"call_members_created", "call_members_deleted", b"call_members_deleted", "call_members_updated", b"call_members_updated", "call_rejected", b"call_rejected", "call_updated", b"call_updated", "error", b"error", "event", b"event", "healthcheck", b"healthcheck", "user_updated", b"user_updated"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["call_accepted", b"call_accepted", "call_cancelled", b"call_cancelled", "call_created", b"call_created", "call_custom", b"call_custom", "call_deleted", b"call_deleted", "call_ended", b"call_ended", "call_members_created", b"call_members_created", "call_members_deleted", b"call_members_deleted", "call_members_updated", b"call_members_updated", "call_rejected", b"call_rejected", "call_updated", b"call_updated", "error", b"error", "event", b"event", "healthcheck", b"healthcheck", "user_updated", b"user_updated", "users", b"users"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["event", b"event"]) -> typing_extensions.Literal["error", "healthcheck", "call_created", "call_updated", "call_deleted", "call_members_created", "call_members_updated", "call_members_deleted", "call_ended", "call_accepted", "call_rejected", "call_cancelled", "user_updated", "call_custom"] | None: ...

global___WebsocketEvent = WebsocketEvent

class WebsocketClientEvent(google.protobuf.message.Message):
    """WebsocketClientEvent contains all events that client is allowed to send to the server
    When clients sends any of mentioned events, they should be wrapped into ClientEvent
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTHCHECK_FIELD_NUMBER: builtins.int
    AUTH_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def healthcheck(self) -> global___WebsocketHealthcheck: ...
    @property
    def auth_request(self) -> global___WebsocketAuthRequest: ...
    def __init__(
        self,
        *,
        healthcheck: global___WebsocketHealthcheck | None = ...,
        auth_request: global___WebsocketAuthRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_request", b"auth_request", "event", b"event", "healthcheck", b"healthcheck"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_request", b"auth_request", "event", b"event", "healthcheck", b"healthcheck"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["event", b"event"]) -> typing_extensions.Literal["healthcheck", "auth_request"] | None: ...

global___WebsocketClientEvent = WebsocketClientEvent

class WebsocketAuthRequest(google.protobuf.message.Message):
    """A payload that is sent through websocket to authenticate a connection"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    DEVICE_FIELD_NUMBER: builtins.int
    api_key: builtins.str
    """Application API key that matches a secret is used to sign a token"""
    token: builtins.str
    """A client JWT token"""
    @property
    def user(self) -> video.coordinator.user_v1.user_pb2.UserInput:
        """Optional UserInput. When present, it is used to create or update user information.
        If contains some changes, a permission check will be performed
        """
    @property
    def device(self) -> video.coordinator.push_v1.push_pb2.DeviceInput:
        """Optional DeviceInput. When present, a device will be created for a user. If device
        already exists, nothing will happen
        """
    def __init__(
        self,
        *,
        api_key: builtins.str = ...,
        token: builtins.str = ...,
        user: video.coordinator.user_v1.user_pb2.UserInput | None = ...,
        device: video.coordinator.push_v1.push_pb2.DeviceInput | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["device", b"device", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["api_key", b"api_key", "device", b"device", "token", b"token", "user", b"user"]) -> None: ...

global___WebsocketAuthRequest = WebsocketAuthRequest

class WebsocketHealthcheck(google.protobuf.message.Message):
    """Healthcheck is sent back and forth between websocket client and server
    When server sends a healthcheck, it is wrapped into WebsocketEvent
    When client sends healthcheck, it should be wrapped into WebsocketClientEvent
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    CLIENT_ID_FIELD_NUMBER: builtins.int
    CALL_TYPE_FIELD_NUMBER: builtins.int
    CALL_ID_FIELD_NUMBER: builtins.int
    VIDEO_FIELD_NUMBER: builtins.int
    AUDIO_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    client_id: builtins.str
    call_type: builtins.str
    call_id: builtins.str
    video: builtins.bool
    audio: builtins.bool
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        client_id: builtins.str = ...,
        call_type: builtins.str = ...,
        call_id: builtins.str = ...,
        video: builtins.bool = ...,
        audio: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio", b"audio", "call_id", b"call_id", "call_type", b"call_type", "client_id", b"client_id", "user_id", b"user_id", "video", b"video"]) -> None: ...

global___WebsocketHealthcheck = WebsocketHealthcheck

class WebsocketError(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CODE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    code: builtins.int
    message: builtins.str
    def __init__(
        self,
        *,
        code: builtins.int = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["code", b"code", "message", b"message"]) -> None: ...

global___WebsocketError = WebsocketError
