"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import video.coordinator.member_v1.member_pb2

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class CallType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    SETTINGS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The unique name for the call type."""
    @property
    def settings(self) -> global___CallSettings: ...
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        settings: global___CallSettings | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "settings", b"settings", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "name", b"name", "settings", b"settings", "updated_at", b"updated_at"]) -> None: ...

global___CallType = CallType

class Call(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    CALL_CID_FIELD_NUMBER: builtins.int
    CREATED_BY_USER_ID_FIELD_NUMBER: builtins.int
    CUSTOM_JSON_FIELD_NUMBER: builtins.int
    SETTINGS_OVERRIDES_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    RECORDING_ACTIVE_FIELD_NUMBER: builtins.int
    BROADCASTING_ACTIVE_FIELD_NUMBER: builtins.int
    type: builtins.str
    """The call type."""
    id: builtins.str
    """The call id."""
    call_cid: builtins.str
    """A concatenation of call type and call id with ":" inbetween"""
    created_by_user_id: builtins.str
    """The id of the user that created this call."""
    custom_json: builtins.bytes
    @property
    def settings_overrides(self) -> global___CallSettings:
        """Call settings overrides that are set explicitly in this call
        This set of settings does not include CallType settings
        """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    recording_active: builtins.bool
    """If true, the call is currently recording"""
    broadcasting_active: builtins.bool
    """If true, the call is currently broadcasting"""
    def __init__(
        self,
        *,
        type: builtins.str = ...,
        id: builtins.str = ...,
        call_cid: builtins.str = ...,
        created_by_user_id: builtins.str = ...,
        custom_json: builtins.bytes = ...,
        settings_overrides: global___CallSettings | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        recording_active: builtins.bool = ...,
        broadcasting_active: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "settings_overrides", b"settings_overrides", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["broadcasting_active", b"broadcasting_active", "call_cid", b"call_cid", "created_at", b"created_at", "created_by_user_id", b"created_by_user_id", "custom_json", b"custom_json", "id", b"id", "recording_active", b"recording_active", "settings_overrides", b"settings_overrides", "type", b"type", "updated_at", b"updated_at"]) -> None: ...

global___Call = Call

class CallDetails(google.protobuf.message.Message):
    """CallDetails contains call additional details"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class MembersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> video.coordinator.member_v1.member_pb2.Member: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: video.coordinator.member_v1.member_pb2.Member | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    SETTINGS_FIELD_NUMBER: builtins.int
    MEMBER_USER_IDS_FIELD_NUMBER: builtins.int
    MEMBERS_FIELD_NUMBER: builtins.int
    @property
    def settings(self) -> global___CallSettings:
        """Call settings_overrides merged with CallType settings"""
    @property
    def member_user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Ordered list of member user IDs"""
    @property
    def members(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, video.coordinator.member_v1.member_pb2.Member]:
        """Call members map indexed by Member.user_id
        Cannot have more than 100 members
        """
    def __init__(
        self,
        *,
        settings: global___CallSettings | None = ...,
        member_user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        members: collections.abc.Mapping[builtins.str, video.coordinator.member_v1.member_pb2.Member] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["settings", b"settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["member_user_ids", b"member_user_ids", "members", b"members", "settings", b"settings"]) -> None: ...

global___CallDetails = CallDetails

class CallSettings(google.protobuf.message.Message):
    """CallSettings contains all options available to change for a CallType
    Settings can also be set on the call level where they will be merged with call options using `json.Merge`
    To make sure options can be overridden on the call level, all underlying option fields should be optional
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECORDING_FIELD_NUMBER: builtins.int
    BROADCASTING_FIELD_NUMBER: builtins.int
    GEOFENCING_FIELD_NUMBER: builtins.int
    @property
    def recording(self) -> global___RecordingSettings: ...
    @property
    def broadcasting(self) -> global___BroadcastingSettings: ...
    @property
    def geofencing(self) -> global___GeofencingSettings: ...
    def __init__(
        self,
        *,
        recording: global___RecordingSettings | None = ...,
        broadcasting: global___BroadcastingSettings | None = ...,
        geofencing: global___GeofencingSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["broadcasting", b"broadcasting", "geofencing", b"geofencing", "recording", b"recording"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["broadcasting", b"broadcasting", "geofencing", b"geofencing", "recording", b"recording"]) -> None: ...

global___CallSettings = CallSettings

class RecordingSettings(google.protobuf.message.Message):
    """Contains all settings regarding to call recording"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLED_FIELD_NUMBER: builtins.int
    enabled: builtins.bool
    """Whether recording feature is enabled
    Default: false
    """
    def __init__(
        self,
        *,
        enabled: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_enabled", b"_enabled", "enabled", b"enabled"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_enabled", b"_enabled", "enabled", b"enabled"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_enabled", b"_enabled"]) -> typing_extensions.Literal["enabled"] | None: ...

global___RecordingSettings = RecordingSettings

class BroadcastingSettings(google.protobuf.message.Message):
    """Contains all settings regarding to call broadcasting"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLED_FIELD_NUMBER: builtins.int
    enabled: builtins.bool
    """Whether broadcasting feature is enabled
    Default: false
    """
    def __init__(
        self,
        *,
        enabled: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_enabled", b"_enabled", "enabled", b"enabled"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_enabled", b"_enabled", "enabled", b"enabled"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_enabled", b"_enabled"]) -> typing_extensions.Literal["enabled"] | None: ...

global___BroadcastingSettings = BroadcastingSettings

class GeofencingSettings(google.protobuf.message.Message):
    """Contains all settings regarding to call geofencing
    Initialization of geofencing enables the feature
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMES_FIELD_NUMBER: builtins.int
    @property
    def names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of the geofences that are selected"""
    def __init__(
        self,
        *,
        names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["names", b"names"]) -> None: ...

global___GeofencingSettings = GeofencingSettings
