# -*- coding: utf-8 -*-
#
# Leo documentation documentation build configuration file, created by
# sphinx-quickstart on Mon Mar 30 16:39:02 2009.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# -- General configuration -----------------------------------------------------

# import sys, os

# http://docs.readthedocs.io/en/latest/getting_started.html#in-markdown
# The suffix of source filenames.
try:
    from recommonmark.parser import CommonMarkParser

    source_parsers = {
        '.md': CommonMarkParser,
    }
    source_suffix = ['.html.txt', '.md'] # possible: '.rst',
    print('===== conf.py: .md files enabled')
except ImportError:
    source_suffix = '.html.txt'
    print('===== conf.py: .md files NOT enabled')

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#sys.path.append(os.path.abspath('.'))

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = []

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The encoding of source files.
#source_encoding = 'utf-8'

# The master toctree document.
master_doc = 'leo_toc' # don't use any suffix.

# General information about the project.
project = 'Leo'

copyright = '1997-2022, Edward K. Ream'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = '6.6.4'
# The full version, including alpha/beta/rc tags.
release = '6.6.4' # Using the short version is simplest and good.

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of documents that shouldn't be included in the build.
#unused_docs = []

# List of directories, relative to source directory, that shouldn't be searched
# for source files.
exclude_trees = ['_build']

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []


# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  Major themes that come with
# Sphinx are currently 'default' and 'sphinxdoc'.
html_theme = 'classic'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {

    'collapsiblesidebar': True,

        #  footerbgcolor (CSS color): Background color for the footer line.
        #  footertextcolor (CSS color): Text color for the footer line.
        #  sidebarbgcolor (CSS color): Background color for the sidebar.
        'sidebarbgcolor': "#fffdbc", # typical yellow.
    ## 'sidebarbgcolor': "#cbf5b1", # 203,245,177 # green1 harsh
    ##'sidebarbgcolor': "#e2fad3", # 226, 250, 211 # green2
        #  sidebartextcolor (CSS color): Text color for the sidebar.
        'sidebartextcolor': 'black',
        #  sidebarlinkcolor (CSS color): Link color for the sidebar.
        'sidebarlinkcolor': 'black',
        #  relbarbgcolor (CSS color): Background color for the relation bar.
        #  relbartextcolor (CSS color): Text color for the relation bar.
        #  relbarlinkcolor (CSS color): Link color for the relation bar.
        #  bgcolor (CSS color): Body background color.
        'bgcolor': "#fffbdc", # r = 256, g = 253, b = 220

        #  textcolor (CSS color): Body text color.
        #  linkcolor (CSS color): Body link color.
        #  headbgcolor (CSS color): Background color for headings.
        #  headtextcolor (CSS color): Text color for headings.
        #  headlinkcolor (CSS color): Link color for headings.
        #  codebgcolor (CSS color): Background color for code blocks.
        #  codetextcolor (CSS color): Default text color for code blocks, if not set differently by the highlighting style.
        #  bodyfont (CSS font-family): Font for normal text.
        #  headfont (CSS font-family): Font for headings.
}

# Add any paths that contain custom themes here, relative to this directory.
#html_theme_path = ["_themes"]

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
#html_logo = None
html_logo = 'Leo4-80-border.jpg'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
#html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
html_last_updated_fmt = '%B %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.

## html_sidebars = {'FAQ':'noSideBar.txt'} # raises TemplateNotFound exception.

# * localtoc.html – a fine-grained table of contents of the current document
# * globaltoc.html – a coarse-grained table of contents for the whole documentation set, collapsed
# * relations.html – two links to the previous and next documents
# * sourcelink.html – a link to the source of the current document, if enabled in html_show_sourcelink
# * searchbox.html – the “quick search” box

html_sidebars = {

   '**': ['relations.html','searchbox.html',]

   # 'localtoc.html',
   # 'globaltoc.html',
   # 'sourcelink.html',
}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
html_use_modindex = False

# If false, no index is generated.
html_use_index = True

# If true, the index is split into individual pages for each letter.
html_split_index = False

# If true, links to the reST sources are added to the pages.
html_show_sourcelink = False

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
html_use_opensearch = ''

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = ''

# Output file base name for HTML help builder.
htmlhelp_basename = 'Leodoc'


# -- Options for LaTeX output --------------------------------------------------

# The paper size ('letter' or 'a4').
latex_paper_size = 'a4'

# The font size ('10pt', '11pt' or '12pt').
#latex_font_size = '10pt'

# Grouping the document tree into LaTeX files. List of tuples
# tex_documents(source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
  ('leo_toc', 'Leodocumentation.tex', 'Leo',
   'Edward K. Ream', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# Additional stuff for the LaTeX preamble.
#latex_preamble = ''

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
latex_use_modindex = False
