---
name: Bug report
about: Tell us about decompyle3 bugs

---

<!-- __Note:__ Bugs are not for asking questions about a problem you
are trying to solve that involve the use of decompyle3 along the way,
although I may be more tolerent of this if you sponsor the project.

Also, the unless you are a sponsor of the project, it may take a
while, maybe a week or so, before the bug report is noticed, let alone
acted upon.

To set expectations, some legitimate bugs can take years to fix, but
they eventually do get fixed.

Funding the project was added to address the problem that there are
lots of people seeking help and reporting bugs, but few people who are
willing or capable of providing help or fixing bugs.

Finally https://github.com/rocky/python-decompile3/blob/master/HOW-TO-REPORT-A-BUG.md ?
-->

<!--
Please remove any of the optional sections if they are not applicable.

Prerequisites

* Make sure the bytecode you have can be disassembled with a
  disassembler and produces valid results.
* Don't put bytecode and corresponding source code on any service that
  requires registration to download.
* When you open a bug report there is no privacy. If you need privacy, then
  contact me by email and explain who you are and the need for privacy.
  But be mindful that you may be asked to sponsor the project for the
  personal and private help that you are requesting.
* If the legitimacy of the activity is deemed suspicous, I may flag it as suspicious,
  making the issue even more easy to detect.

Bug reports that violate a prerequisite may be discarded.

-->

## Description

<!-- Add a clear and concise description of the bug. -->

## How to Reproduce

<!-- Please show both the *input* you gave and the
output you got in describing how to reproduce the bug:

or give a complete console log with input and output

```console
$ decompyle3 <command-line-options>
...
$
```

Provide links to the Python bytecode. For example you can create a
gist with the information. If you have the correct source code, you
can add that too.

-->

## Expected behavior

<!-- Add a clear and concise description of what you expected to happen. -->

## Environment

<!-- _This section sometimes is optional but helpful to us._

Please modify for your setup

- Decompyle3 version: output from  `decompyle3 --version` or `pip show decompyle3`
- Python version for the version of Python the byte-compiled the file: `python -c "import sys; print(sys.version)"` where `python` is the correct Cpython or Pypy binary.
- OS and Version: [e.g. Ubuntu bionic]

-->

## Additional Environment or Context

<!-- _This section is optional._

Add any other context about the problem here or special environment setup.

-->
