# coding: utf8
from __future__ import unicode_literals

from ...symbols import POS, PUNCT, SYM, ADJ, CCONJ, SCONJ, NUM, DET, ADV, ADP, X, VERB
from ...symbols import NOUN, PROPN, PART, INTJ, PRON, AUX


TAG_MAP = {
    "ABBR": {POS: NOUN, "Abbr": "Yes"},
    "AdXxBa": {POS: ADV, "Degree": ""},
    "AdXxCp": {POS: ADV, "Degree": "Cmp"},
    "AdXxSu": {POS: ADV, "Degree": "Sup"},
    "AjBaFePlAc": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Acc",
    },
    "AjBaFePlDa": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Dat",
    },
    "AjBaFePlGe": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Gen",
    },
    "AjBaFePlNm": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Nom",
    },
    "AjBaFePlVo": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Voc",
    },
    "AjBaFeSgAc": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Acc",
    },
    "AjBaFeSgDa": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Dat",
    },
    "AjBaFeSgGe": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Gen",
    },
    "AjBaFeSgNm": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Nom",
    },
    "AjBaFeSgVo": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Voc",
    },
    "AjBaMaPlAc": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Acc",
    },
    "AjBaMaPlDa": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Dat",
    },
    "AjBaMaPlGe": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Gen",
    },
    "AjBaMaPlNm": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Nom",
    },
    "AjBaMaPlVo": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Voc",
    },
    "AjBaMaSgAc": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Acc",
    },
    "AjBaMaSgDa": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Dat",
    },
    "AjBaMaSgGe": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Gen",
    },
    "AjBaMaSgNm": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Nom",
    },
    "AjBaMaSgVo": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Voc",
    },
    "AjBaNePlAc": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Acc",
    },
    "AjBaNePlDa": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Dat",
    },
    "AjBaNePlGe": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Gen",
    },
    "AjBaNePlNm": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Nom",
    },
    "AjBaNePlVo": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Voc",
    },
    "AjBaNeSgAc": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Acc",
    },
    "AjBaNeSgDa": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Dat",
    },
    "AjBaNeSgGe": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Gen",
    },
    "AjBaNeSgNm": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Nom",
    },
    "AjBaNeSgVo": {
        POS: ADJ,
        "Degree": "",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Voc",
    },
    "AjCpFePlAc": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Acc",
    },
    "AjCpFePlDa": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Dat",
    },
    "AjCpFePlGe": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Gen",
    },
    "AjCpFePlNm": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Nom",
    },
    "AjCpFePlVo": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Voc",
    },
    "AjCpFeSgAc": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Acc",
    },
    "AjCpFeSgDa": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Dat",
    },
    "AjCpFeSgGe": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Gen",
    },
    "AjCpFeSgNm": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Nom",
    },
    "AjCpFeSgVo": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Voc",
    },
    "AjCpMaPlAc": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Acc",
    },
    "AjCpMaPlDa": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Dat",
    },
    "AjCpMaPlGe": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Gen",
    },
    "AjCpMaPlNm": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Nom",
    },
    "AjCpMaPlVo": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Voc",
    },
    "AjCpMaSgAc": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Acc",
    },
    "AjCpMaSgDa": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Dat",
    },
    "AjCpMaSgGe": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Gen",
    },
    "AjCpMaSgNm": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Nom",
    },
    "AjCpMaSgVo": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Voc",
    },
    "AjCpNePlAc": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Acc",
    },
    "AjCpNePlDa": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Dat",
    },
    "AjCpNePlGe": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Gen",
    },
    "AjCpNePlNm": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Nom",
    },
    "AjCpNePlVo": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Voc",
    },
    "AjCpNeSgAc": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Acc",
    },
    "AjCpNeSgDa": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Dat",
    },
    "AjCpNeSgGe": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Gen",
    },
    "AjCpNeSgNm": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Nom",
    },
    "AjCpNeSgVo": {
        POS: ADJ,
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Voc",
    },
    "AjSuFePlAc": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Acc",
    },
    "AjSuFePlDa": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Dat",
    },
    "AjSuFePlGe": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Gen",
    },
    "AjSuFePlNm": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Nom",
    },
    "AjSuFePlVo": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Voc",
    },
    "AjSuFeSgAc": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Acc",
    },
    "AjSuFeSgDa": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Dat",
    },
    "AjSuFeSgGe": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Gen",
    },
    "AjSuFeSgNm": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Nom",
    },
    "AjSuFeSgVo": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Voc",
    },
    "AjSuMaPlAc": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Acc",
    },
    "AjSuMaPlDa": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Dat",
    },
    "AjSuMaPlGe": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Gen",
    },
    "AjSuMaPlNm": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Nom",
    },
    "AjSuMaPlVo": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Voc",
    },
    "AjSuMaSgAc": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Acc",
    },
    "AjSuMaSgDa": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Dat",
    },
    "AjSuMaSgGe": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Gen",
    },
    "AjSuMaSgNm": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Nom",
    },
    "AjSuMaSgVo": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Voc",
    },
    "AjSuNePlAc": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Acc",
    },
    "AjSuNePlDa": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Dat",
    },
    "AjSuNePlGe": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Gen",
    },
    "AjSuNePlNm": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Nom",
    },
    "AjSuNePlVo": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Voc",
    },
    "AjSuNeSgAc": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Acc",
    },
    "AjSuNeSgDa": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Dat",
    },
    "AjSuNeSgGe": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Gen",
    },
    "AjSuNeSgNm": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Nom",
    },
    "AjSuNeSgVo": {
        POS: ADJ,
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Voc",
    },
    "AsPpPaFePlAc": {POS: ADP, "Gender": "Fem", "Number": "Plur", "Case": "Acc"},
    "AsPpPaFePlGe": {POS: ADP, "Gender": "Fem", "Number": "Plur", "Case": "Gen"},
    "AsPpPaFeSgAc": {POS: ADP, "Gender": "Fem", "Number": "Sing", "Case": "Acc"},
    "AsPpPaFeSgGe": {POS: ADP, "Gender": "Fem", "Number": "Sing", "Case": "Gen"},
    "AsPpPaMaPlAc": {POS: ADP, "Gender": "Masc", "Number": "Plur", "Case": "Acc"},
    "AsPpPaMaPlGe": {POS: ADP, "Gender": "Masc", "Number": "Plur", "Case": "Gen"},
    "AsPpPaMaSgAc": {POS: ADP, "Gender": "Masc", "Number": "Sing", "Case": "Acc"},
    "AsPpPaMaSgGe": {POS: ADP, "Gender": "Masc", "Number": "Sing", "Case": "Gen"},
    "AsPpPaNePlAc": {POS: ADP, "Gender": "Neut", "Number": "Plur", "Case": "Acc"},
    "AsPpPaNePlGe": {POS: ADP, "Gender": "Neut", "Number": "Plur", "Case": "Gen"},
    "AsPpPaNeSgAc": {POS: ADP, "Gender": "Neut", "Number": "Sing", "Case": "Acc"},
    "AsPpPaNeSgGe": {POS: ADP, "Gender": "Neut", "Number": "Sing", "Case": "Gen"},
    "AsPpSp": {POS: ADP},
    "AtDfFePlAc": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Acc",
        "Other": {"Definite": "Def"},
    },
    "AtDfFePlGe": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Gen",
        "Other": {"Definite": "Def"},
    },
    "AtDfFePlNm": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Nom",
        "Other": {"Definite": "Def"},
    },
    "AtDfFeSgAc": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Acc",
        "Other": {"Definite": "Def"},
    },
    "AtDfFeSgDa": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Dat",
        "Other": {"Definite": "Def"},
    },
    "AtDfFeSgGe": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Gen",
        "Other": {"Definite": "Def"},
    },
    "AtDfFeSgNm": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Nom",
        "Other": {"Definite": "Def"},
    },
    "AtDfMaPlAc": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Acc",
        "Other": {"Definite": "Def"},
    },
    "AtDfMaPlGe": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Gen",
        "Other": {"Definite": "Def"},
    },
    "AtDfMaPlNm": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Nom",
        "Other": {"Definite": "Def"},
    },
    "AtDfMaSgAc": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Acc",
        "Other": {"Definite": "Def"},
    },
    "AtDfMaSgDa": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Dat",
        "Other": {"Definite": "Def"},
    },
    "AtDfMaSgGe": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Gen",
        "Other": {"Definite": "Def"},
    },
    "AtDfMaSgNm": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Nom",
        "Other": {"Definite": "Def"},
    },
    "AtDfNePlAc": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Acc",
        "Other": {"Definite": "Def"},
    },
    "AtDfNePlDa": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Dat",
        "Other": {"Definite": "Def"},
    },
    "AtDfNePlGe": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Gen",
        "Other": {"Definite": "Def"},
    },
    "AtDfNePlNm": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Nom",
        "Other": {"Definite": "Def"},
    },
    "AtDfNeSgAc": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Acc",
        "Other": {"Definite": "Def"},
    },
    "AtDfNeSgDa": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Dat",
        "Other": {"Definite": "Def"},
    },
    "AtDfNeSgGe": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Gen",
        "Other": {"Definite": "Def"},
    },
    "AtDfNeSgNm": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Nom",
        "Other": {"Definite": "Def"},
    },
    "AtIdFeSgAc": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Acc",
        "Other": {"Definite": "Ind"},
    },
    "AtIdFeSgDa": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Dat",
        "Other": {"Definite": "Ind"},
    },
    "AtIdFeSgGe": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Gen",
        "Other": {"Definite": "Ind"},
    },
    "AtIdFeSgNm": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Nom",
        "Other": {"Definite": "Ind"},
    },
    "AtIdMaSgAc": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Acc",
        "Other": {"Definite": "Ind"},
    },
    "AtIdMaSgGe": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Gen",
        "Other": {"Definite": "Ind"},
    },
    "AtIdMaSgNm": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Nom",
        "Other": {"Definite": "Ind"},
    },
    "AtIdNeSgAc": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Acc",
        "Other": {"Definite": "Ind"},
    },
    "AtIdNeSgGe": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Gen",
        "Other": {"Definite": "Ind"},
    },
    "AtIdNeSgNm": {
        POS: DET,
        "PronType": "Art",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Nom",
        "Other": {"Definite": "Ind"},
    },
    "CjCo": {POS: CCONJ},
    "CjSb": {POS: SCONJ},
    "CPUNCT": {POS: PUNCT},
    "DATE": {POS: NUM},
    "DIG": {POS: NUM},
    "ENUM": {POS: NUM},
    "Ij": {POS: INTJ},
    "INIT": {POS: SYM},
    "NBABBR": {POS: NOUN, "Abbr": "Yes"},
    "NmAnFePlAcAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Acc",
    },
    "NmAnFePlGeAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Gen",
    },
    "NmAnFePlNmAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Nom",
    },
    "NmAnFePlVoAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Voc",
    },
    "NmAnFeSgAcAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Acc",
    },
    "NmAnFeSgGeAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Gen",
    },
    "NmAnFeSgNmAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Nom",
    },
    "NmAnFeSgVoAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Voc",
    },
    "NmAnMaPlAcAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Acc",
    },
    "NmAnMaPlGeAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Gen",
    },
    "NmAnMaPlNmAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Nom",
    },
    "NmAnMaPlVoAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Voc",
    },
    "NmAnMaSgAcAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Acc",
    },
    "NmAnMaSgGeAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Gen",
    },
    "NmAnMaSgNmAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Nom",
    },
    "NmAnMaSgVoAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Voc",
    },
    "NmAnNePlAcAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Acc",
    },
    "NmAnNePlGeAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Gen",
    },
    "NmAnNePlNmAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Nom",
    },
    "NmAnNePlVoAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Voc",
    },
    "NmAnNeSgAcAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Acc",
    },
    "NmAnNeSgGeAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Gen",
    },
    "NmAnNeSgNmAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Nom",
    },
    "NmAnNeSgVoAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Voc",
    },
    "NmAnXxXxXxAd": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc|Fem|Neut",
        "Number": "Sing|Plur",
        "Case": "Acc|Gen|Nom|Voc",
    },
    "NmCdFePlAcAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Acc",
    },
    "NmCdFePlGeAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Gen",
    },
    "NmCdFePlNmAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Nom",
    },
    "NmCdFePlVoAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Voc",
    },
    "NmCdFeSgAcAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Acc",
    },
    "NmCdFeSgDaAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Dat",
    },
    "NmCdFeSgGeAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Gen",
    },
    "NmCdFeSgNmAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Nom",
    },
    "NmCdMaPlAcAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Acc",
    },
    "NmCdMaPlGeAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Gen",
    },
    "NmCdMaPlNmAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Nom",
    },
    "NmCdMaPlVoAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Voc",
    },
    "NmCdMaSgAcAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Acc",
    },
    "NmCdMaSgGeAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Gen",
    },
    "NmCdMaSgNmAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Nom",
    },
    "NmCdNePlAcAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Acc",
    },
    "NmCdNePlDaAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Dat",
    },
    "NmCdNePlGeAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Gen",
    },
    "NmCdNePlNmAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Nom",
    },
    "NmCdNePlVoAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Voc",
    },
    "NmCdNeSgAcAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Acc",
    },
    "NmCdNeSgGeAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Gen",
    },
    "NmCdNeSgNmAj": {
        POS: NUM,
        "NumType": "Card",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Nom",
    },
    "NmCtFePlAcNo": {
        POS: NUM,
        "NumType": "Sets",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Acc",
    },
    "NmCtFePlGeNo": {
        POS: NUM,
        "NumType": "Sets",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Gen",
    },
    "NmCtFePlNmNo": {
        POS: NUM,
        "NumType": "Sets",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Nom",
    },
    "NmCtFePlVoNo": {
        POS: NUM,
        "NumType": "Sets",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Voc",
    },
    "NmCtFeSgAcNo": {
        POS: NUM,
        "NumType": "Sets",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Acc",
    },
    "NmCtFeSgGeNo": {
        POS: NUM,
        "NumType": "Sets",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Gen",
    },
    "NmCtFeSgNmNo": {
        POS: NUM,
        "NumType": "Sets",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Nom",
    },
    "NmCtFeSgVoNo": {
        POS: NUM,
        "NumType": "Sets",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Voc",
    },
    "NmMlFePlAcAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Acc",
    },
    "NmMlFePlGeAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Gen",
    },
    "NmMlFePlNmAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Nom",
    },
    "NmMlFePlVoAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Voc",
    },
    "NmMlFeSgAcAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Acc",
    },
    "NmMlFeSgGeAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Gen",
    },
    "NmMlFeSgNmAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Nom",
    },
    "NmMlFeSgVoAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Voc",
    },
    "NmMlMaPlAcAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Acc",
    },
    "NmMlMaPlGeAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Gen",
    },
    "NmMlMaPlNmAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Nom",
    },
    "NmMlMaPlVoAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Voc",
    },
    "NmMlMaSgAcAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Acc",
    },
    "NmMlMaSgGeAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Gen",
    },
    "NmMlMaSgNmAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Nom",
    },
    "NmMlMaSgVoAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Voc",
    },
    "NmMlNePlAcAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Acc",
    },
    "NmMlNePlGeAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Gen",
    },
    "NmMlNePlNmAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Nom",
    },
    "NmMlNePlVoAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Voc",
    },
    "NmMlNeSgAcAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Acc",
    },
    "NmMlNeSgGeAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Gen",
    },
    "NmMlNeSgNmAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Nom",
    },
    "NmMlNeSgVoAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Voc",
    },
    "NmMlXxXxXxAd": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Masc|Fem|Neut",
        "Number": "Sing|Plur",
        "Case": "Acc|Gen|Nom|Voc",
    },
    "NmOdFePlAcAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Acc",
    },
    "NmOdFePlGeAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Gen",
    },
    "NmOdFePlNmAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Nom",
    },
    "NmOdFePlVoAj": {
        POS: NUM,
        "NumType": "Mult",
        "Gender": "Fem",
        "Number": "Plur",
        "Case": "Voc",
    },
    "NmOdFeSgAcAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Acc",
    },
    "NmOdFeSgGeAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Gen",
    },
    "NmOdFeSgNmAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Nom",
    },
    "NmOdFeSgVoAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Fem",
        "Number": "Sing",
        "Case": "Voc",
    },
    "NmOdMaPlAcAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Acc",
    },
    "NmOdMaPlGeAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Gen",
    },
    "NmOdMaPlNmAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Nom",
    },
    "NmOdMaPlVoAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Masc",
        "Number": "Plur",
        "Case": "Voc",
    },
    "NmOdMaSgAcAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Acc",
    },
    "NmOdMaSgGeAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Gen",
    },
    "NmOdMaSgNmAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Nom",
    },
    "NmOdMaSgVoAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Masc",
        "Number": "Sing",
        "Case": "Voc",
    },
    "NmOdNePlAcAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Acc",
    },
    "NmOdNePlGeAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Gen",
    },
    "NmOdNePlNmAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Nom",
    },
    "NmOdNePlVoAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Neut",
        "Number": "Plur",
        "Case": "Voc",
    },
    "NmOdNeSgAcAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Acc",
    },
    "NmOdNeSgGeAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Gen",
    },
    "NmOdNeSgNmAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Nom",
    },
    "NmOdNeSgVoAj": {
        POS: NUM,
        "NumType": "Ord",
        "Gender": "Neut",
        "Number": "Sing",
        "Case": "Voc",
    },
    "NoCmFePlAc": {POS: NOUN, "Gender": "Fem", "Number": "Plur", "Case": "Acc"},
    "NoCmFePlDa": {POS: NOUN, "Gender": "Fem", "Number": "Plur", "Case": "Dat"},
    "NoCmFePlGe": {POS: NOUN, "Gender": "Fem", "Number": "Plur", "Case": "Gen"},
    "NoCmFePlNm": {POS: NOUN, "Gender": "Fem", "Number": "Plur", "Case": "Nom"},
    "NoCmFePlVo": {POS: NOUN, "Gender": "Fem", "Number": "Plur", "Case": "Voc"},
    "NoCmFeSgAc": {POS: NOUN, "Gender": "Fem", "Number": "Sing", "Case": "Acc"},
    "NoCmFeSgDa": {POS: NOUN, "Gender": "Fem", "Number": "Sing", "Case": "Dat"},
    "NoCmFeSgGe": {POS: NOUN, "Gender": "Fem", "Number": "Sing", "Case": "Gen"},
    "NoCmFeSgNm": {POS: NOUN, "Gender": "Fem", "Number": "Sing", "Case": "Nom"},
    "NoCmFeSgVo": {POS: NOUN, "Gender": "Fem", "Number": "Sing", "Case": "Voc"},
    "NoCmMaPlAc": {POS: NOUN, "Gender": "Masc", "Number": "Plur", "Case": "Acc"},
    "NoCmMaPlDa": {POS: NOUN, "Gender": "Masc", "Number": "Plur", "Case": "Dat"},
    "NoCmMaPlGe": {POS: NOUN, "Gender": "Masc", "Number": "Plur", "Case": "Gen"},
    "NoCmMaPlNm": {POS: NOUN, "Gender": "Masc", "Number": "Plur", "Case": "Nom"},
    "NoCmMaPlVo": {POS: NOUN, "Gender": "Masc", "Number": "Plur", "Case": "Voc"},
    "NoCmMaSgAc": {POS: NOUN, "Gender": "Masc", "Number": "Sing", "Case": "Acc"},
    "NoCmMaSgDa": {POS: NOUN, "Gender": "Masc", "Number": "Sing", "Case": "Dat"},
    "NoCmMaSgGe": {POS: NOUN, "Gender": "Masc", "Number": "Sing", "Case": "Gen"},
    "NoCmMaSgNm": {POS: NOUN, "Gender": "Masc", "Number": "Sing", "Case": "Nom"},
    "NoCmMaSgVo": {POS: NOUN, "Gender": "Masc", "Number": "Sing", "Case": "Voc"},
    "NoCmNePlAc": {POS: NOUN, "Gender": "Neut", "Number": "Plur", "Case": "Acc"},
    "NoCmNePlDa": {POS: NOUN, "Gender": "Neut", "Number": "Plur", "Case": "Dat"},
    "NoCmNePlGe": {POS: NOUN, "Gender": "Neut", "Number": "Plur", "Case": "Gen"},
    "NoCmNePlNm": {POS: NOUN, "Gender": "Neut", "Number": "Plur", "Case": "Nom"},
    "NoCmNePlVo": {POS: NOUN, "Gender": "Neut", "Number": "Plur", "Case": "Voc"},
    "NoCmNeSgAc": {POS: NOUN, "Gender": "Neut", "Number": "Sing", "Case": "Acc"},
    "NoCmNeSgDa": {POS: NOUN, "Gender": "Neut", "Number": "Sing", "Case": "Dat"},
    "NoCmNeSgGe": {POS: NOUN, "Gender": "Neut", "Number": "Sing", "Case": "Gen"},
    "NoCmNeSgNm": {POS: NOUN, "Gender": "Neut", "Number": "Sing", "Case": "Nom"},
    "NoCmNeSgVo": {POS: NOUN, "Gender": "Neut", "Number": "Sing", "Case": "Voc"},
    "NoPrFePlAc": {POS: PROPN, "Gender": "Fem", "Number": "Plur", "Case": "Acc"},
    "NoPrFePlDa": {POS: PROPN, "Gender": "Fem", "Number": "Plur", "Case": "Dat"},
    "NoPrFePlGe": {POS: PROPN, "Gender": "Fem", "Number": "Plur", "Case": "Gen"},
    "NoPrFePlNm": {POS: PROPN, "Gender": "Fem", "Number": "Plur", "Case": "Nom"},
    "NoPrFePlVo": {POS: PROPN, "Gender": "Fem", "Number": "Plur", "Case": "Voc"},
    "NoPrFeSgAc": {POS: PROPN, "Gender": "Fem", "Number": "Sing", "Case": "Acc"},
    "NoPrFeSgDa": {POS: PROPN, "Gender": "Fem", "Number": "Sing", "Case": "Dat"},
    "NoPrFeSgGe": {POS: PROPN, "Gender": "Fem", "Number": "Sing", "Case": "Gen"},
    "NoPrFeSgNm": {POS: PROPN, "Gender": "Fem", "Number": "Sing", "Case": "Nom"},
    "NoPrFeSgVo": {POS: PROPN, "Gender": "Fem", "Number": "Sing", "Case": "Voc"},
    "NoPrMaPlAc": {POS: PROPN, "Gender": "Masc", "Number": "Plur", "Case": "Acc"},
    "NoPrMaPlGe": {POS: PROPN, "Gender": "Masc", "Number": "Plur", "Case": "Gen"},
    "NoPrMaPlNm": {POS: PROPN, "Gender": "Masc", "Number": "Plur", "Case": "Nom"},
    "NoPrMaPlVo": {POS: PROPN, "Gender": "Masc", "Number": "Plur", "Case": "Voc"},
    "NoPrMaSgAc": {POS: PROPN, "Gender": "Masc", "Number": "Sing", "Case": "Acc"},
    "NoPrMaSgDa": {POS: PROPN, "Gender": "Masc", "Number": "Sing", "Case": "Dat"},
    "NoPrMaSgGe": {POS: PROPN, "Gender": "Masc", "Number": "Sing", "Case": "Gen"},
    "NoPrMaSgNm": {POS: PROPN, "Gender": "Masc", "Number": "Sing", "Case": "Nom"},
    "NoPrMaSgVo": {POS: PROPN, "Gender": "Masc", "Number": "Sing", "Case": "Voc"},
    "NoPrNePlAc": {POS: PROPN, "Gender": "Neut", "Number": "Plur", "Case": "Acc"},
    "NoPrNePlGe": {POS: PROPN, "Gender": "Neut", "Number": "Plur", "Case": "Gen"},
    "NoPrNePlNm": {POS: PROPN, "Gender": "Neut", "Number": "Plur", "Case": "Nom"},
    "NoPrNeSgAc": {POS: PROPN, "Gender": "Neut", "Number": "Sing", "Case": "Acc"},
    "NoPrNeSgGe": {POS: PROPN, "Gender": "Neut", "Number": "Sing", "Case": "Gen"},
    "NoPrNeSgNm": {POS: PROPN, "Gender": "Neut", "Number": "Sing", "Case": "Nom"},
    "OPUNCT": {POS: PUNCT},
    "PnDfFe03PlAcXx": {
        POS: PRON,
        "PronType": "",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnDfFe03SgAcXx": {
        POS: PRON,
        "PronType": "",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnDfMa03PlGeXx": {
        POS: PRON,
        "PronType": "",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnDmFe03PlAcXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnDmFe03PlGeXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnDmFe03PlNmXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnDmFe03SgAcXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnDmFe03SgDaXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Dat",
    },
    "PnDmFe03SgGeXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnDmFe03SgNmXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnDmMa03PlAcXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnDmMa03PlDaXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Dat",
    },
    "PnDmMa03PlGeXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnDmMa03PlNmXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnDmMa03SgAcXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnDmMa03SgGeXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnDmMa03SgNmXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnDmNe03PlAcXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnDmNe03PlDaXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Dat",
    },
    "PnDmNe03PlGeXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnDmNe03PlNmXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnDmNe03SgAcXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnDmNe03SgDaXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Dat",
    },
    "PnDmNe03SgGeXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnDmNe03SgNmXx": {
        POS: PRON,
        "PronType": "Dem",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnIdFe03PlAcXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnIdFe03PlGeXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnIdFe03PlNmXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnIdFe03SgAcXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnIdFe03SgGeXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnIdFe03SgNmXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnIdMa03PlAcXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnIdMa03PlGeXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnIdMa03PlNmXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnIdMa03SgAcXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnIdMa03SgGeXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnIdMa03SgNmXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnIdNe03PlAcXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnIdNe03PlGeXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnIdNe03PlNmXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnIdNe03SgAcXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnIdNe03SgDaXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Dat",
    },
    "PnIdNe03SgGeXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnIdNe03SgNmXx": {
        POS: PRON,
        "PronType": "Ind",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnIrFe03PlAcXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnIrFe03PlGeXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnIrFe03PlNmXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnIrFe03SgAcXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnIrFe03SgGeXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnIrFe03SgNmXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnIrMa03PlAcXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnIrMa03PlGeXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnIrMa03PlNmXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnIrMa03SgAcXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnIrMa03SgGeXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnIrMa03SgNmXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnIrNe03PlAcXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnIrNe03PlGeXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnIrNe03PlNmXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnIrNe03SgAcXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnIrNe03SgGeXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnIrNe03SgNmXx": {
        POS: PRON,
        "PronType": "Int",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnPeFe01PlAcSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "1",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnPeFe01PlAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "1",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnPeFe01PlGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "1",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPeFe01PlNmSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "1",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnPeFe01SgAcSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "1",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeFe01SgAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "1",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeFe01SgGeSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "1",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPeFe01SgGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "1",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPeFe01SgNmSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "1",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnPeFe02PlAcSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "2",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnPeFe02PlAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "2",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnPeFe02PlGeSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "2",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPeFe02PlGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "2",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPeFe02PlNmSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "2",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnPeFe02SgAcSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "2",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeFe02SgAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "2",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeFe02SgGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "2",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPeFe02SgNmSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "2",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnPeFe03PlAcSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnPeFe03PlAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnPeFe03PlGeSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPeFe03PlGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPeFe03PlNmSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnPeFe03SgAcSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeFe03SgAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeFe03SgGeSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPeFe03SgGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPeMa01PlAcSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "1",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnPeMa01PlAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "1",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnPeMa01PlDaSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "1",
        "Number": "Plur",
        "Case": "Dat",
    },
    "PnPeMa01PlGeSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "1",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPeMa01PlGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "1",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPeMa01PlNmSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "1",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnPeMa01SgAcSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "1",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeMa01SgAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "1",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeMa01SgGeSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "1",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPeMa01SgGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "1",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPeMa01SgNmSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "1",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnPeMa02PlAcSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "2",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnPeMa02PlAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "2",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnPeMa02PlGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "2",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPeMa02PlNmSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "2",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnPeMa02PlVoSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "2",
        "Number": "Plur",
        "Case": "Voc",
    },
    "PnPeMa02SgAcSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "2",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeMa02SgAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "2",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeMa02SgGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "2",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPeMa02SgNmSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "2",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnPeMa03PlAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnPeMa03PlGeSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPeMa03PlGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPeMa03PlNmSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnPeMa03SgAcSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeMa03SgAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeMa03SgGeSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPeMa03SgGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPeMa03SgNmWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnPeNe03PlAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnPeNe03PlGeSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPeNe03PlGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPeNe03SgAcSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeNe03SgAcWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnPeNe03SgGeSt": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPeNe03SgGeWe": {
        POS: PRON,
        "PronType": "Prs",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPoFe01PlGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Fem",
        "Person": "1",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPoFe01SgGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Fem",
        "Person": "1",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPoFe02PlGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Fem",
        "Person": "2",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPoFe02SgGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Fem",
        "Person": "2",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPoFe03PlGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPoFe03SgGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPoMa01PlGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Masc",
        "Person": "1",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPoMa01SgGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Masc",
        "Person": "1",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPoMa02PlGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Masc",
        "Person": "2",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPoMa02SgGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Masc",
        "Person": "2",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPoMa03PlGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPoMa03SgGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnPoNe03PlGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnPoNe03SgGeXx": {
        POS: PRON,
        "Poss": "Yes",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnReFe03PlAcXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnReFe03PlGeXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnReFe03PlNmXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnReFe03SgAcXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnReFe03SgGeXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnReFe03SgNmXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnReMa03PlAcXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnReMa03PlGeXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnReMa03PlNmXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnReMa03SgAcXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnReMa03SgGeXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnReMa03SgNmXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnReNe03PlAcXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnReNe03PlGeXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnReNe03PlNmXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnReNe03SgAcXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnReNe03SgGeXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnReNe03SgNmXx": {
        POS: PRON,
        "PronType": "Rel",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnRiFe03PlAcXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnRiFe03PlGeXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnRiFe03PlNmXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnRiFe03SgAcXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnRiFe03SgGeXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnRiFe03SgNmXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Fem",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnRiMa03PlAcXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnRiMa03PlGeXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnRiMa03PlNmXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnRiMa03SgAcXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnRiMa03SgGeXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnRiMa03SgNmXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Masc",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PnRiNe03PlAcXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Acc",
    },
    "PnRiNe03PlGeXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Gen",
    },
    "PnRiNe03PlNmXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Plur",
        "Case": "Nom",
    },
    "PnRiNe03SgAcXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Acc",
    },
    "PnRiNe03SgGeXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Gen",
    },
    "PnRiNe03SgNmXx": {
        POS: PRON,
        "PronType": "Ind,Rel",
        "Gender": "Neut",
        "Person": "3",
        "Number": "Sing",
        "Case": "Nom",
    },
    "PTERM_P": {POS: PUNCT},
    "PtFu": {POS: PART},
    "PtNg": {POS: PART},
    "PtOt": {POS: PART},
    "PtSj": {POS: PART},
    "Pu": {POS: SYM},
    "PUNCT": {POS: PUNCT},
    "RgAbXx": {POS: X},
    "RgAnXx": {POS: X},
    "RgFwOr": {POS: X, "Foreign": "Yes"},
    "RgFwTr": {POS: X, "Foreign": "Yes"},
    "RgSyXx": {POS: SYM},
    "VbIsIdPa03SgXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbIsIdPa03SgXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbIsIdPa03SgXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbIsIdPa03SgXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbIsIdPr03SgXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbIsIdPr03SgXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbIsIdXx03SgXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbIsIdXx03SgXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbIsNfXxXxXxXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Inf",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing|Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa01PlXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "1",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa01PlXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "1",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa01PlXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "1",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa01PlXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "1",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa01SgXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "1",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa01SgXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "1",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa01SgXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "1|2|3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa01SgXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "1",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa02PlXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "2",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa02PlXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "2",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa02PlXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "2",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa02PlXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "2",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa02SgXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "2",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa02SgXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "2",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa02SgXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "2",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa02SgXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "2",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa03PlXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "3",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa03PlXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "3",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa03PlXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "3",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa03PlXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "3",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa03SgXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa03SgXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa03SgXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPa03SgXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Past",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPr01PlXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "1",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPr01PlXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "1",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPr01SgXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "1",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPr01SgXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "1",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPr02PlXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "2",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPr02PlXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "2",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPr02SgXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "2",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPr02SgXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "2",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPr03PlXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "3",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPr03PlXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "3",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPr03SgXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdPr03SgXxIpPvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdXx01PlXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "1",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdXx01PlXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "1",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdXx01SgXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "1",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdXx01SgXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "1",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdXx02PlXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "2",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdXx02PlXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "2",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdXx02SgXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "2",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdXx02SgXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "2",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdXx03PlXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "3",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdXx03PlXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "3",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdXx03SgXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnIdXx03SgXxPePvXx": {
        POS: VERB,
        "VerbForm": "Fin",
        "Mood": "Ind",
        "Tense": "Pres|Past",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnMpXx02PlXxIpAvXx": {
        POS: VERB,
        "VerbForm": "",
        "Mood": "Imp",
        "Tense": "Pres|Past",
        "Person": "2",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnMpXx02PlXxIpPvXx": {
        POS: VERB,
        "VerbForm": "",
        "Mood": "Imp",
        "Tense": "Pres|Past",
        "Person": "2",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnMpXx02PlXxPeAvXx": {
        POS: VERB,
        "VerbForm": "",
        "Mood": "Imp",
        "Tense": "Pres|Past",
        "Person": "2",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnMpXx02PlXxPePvXx": {
        POS: VERB,
        "VerbForm": "",
        "Mood": "Imp",
        "Tense": "Pres|Past",
        "Person": "2",
        "Number": "Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnMpXx02SgXxIpAvXx": {
        POS: VERB,
        "VerbForm": "",
        "Mood": "Imp",
        "Tense": "Pres|Past",
        "Person": "2",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnMpXx02SgXxIpPvXx": {
        POS: VERB,
        "VerbForm": "",
        "Mood": "Imp",
        "Tense": "Pres|Past",
        "Person": "2",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnMpXx02SgXxPeAvXx": {
        POS: VERB,
        "VerbForm": "",
        "Mood": "Imp",
        "Tense": "Pres|Past",
        "Person": "2",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnMpXx02SgXxPePvXx": {
        POS: VERB,
        "VerbForm": "",
        "Mood": "Imp",
        "Tense": "Pres|Past",
        "Person": "2",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnMpXx03SgXxIpPvXx": {
        POS: VERB,
        "VerbForm": "",
        "Mood": "Imp",
        "Tense": "Pres|Past",
        "Person": "3",
        "Number": "Sing",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnNfXxXxXxXxPeAvXx": {
        POS: VERB,
        "VerbForm": "Inf",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing|Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnNfXxXxXxXxPePvXx": {
        POS: VERB,
        "VerbForm": "Inf",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing|Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnPpPrXxXxXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Conv",
        "Mood": "",
        "Tense": "Pres",
        "Person": "1|2|3",
        "Number": "Sing|Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "VbMnPpXxXxPlFePePvAc": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Plur",
        "Gender": "Fem",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Acc",
    },
    "VbMnPpXxXxPlFePePvGe": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Plur",
        "Gender": "Fem",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Gen",
    },
    "VbMnPpXxXxPlFePePvNm": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Plur",
        "Gender": "Fem",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom",
    },
    "VbMnPpXxXxPlFePePvVo": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Plur",
        "Gender": "Fem",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Voc",
    },
    "VbMnPpXxXxPlMaPePvAc": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Plur",
        "Gender": "Masc",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Acc",
    },
    "VbMnPpXxXxPlMaPePvGe": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Plur",
        "Gender": "Masc",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Gen",
    },
    "VbMnPpXxXxPlMaPePvNm": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Plur",
        "Gender": "Masc",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom",
    },
    "VbMnPpXxXxPlMaPePvVo": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Plur",
        "Gender": "Masc",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Voc",
    },
    "VbMnPpXxXxPlNePePvAc": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Plur",
        "Gender": "Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Acc",
    },
    "VbMnPpXxXxPlNePePvGe": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Plur",
        "Gender": "Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Gen",
    },
    "VbMnPpXxXxPlNePePvNm": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Plur",
        "Gender": "Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom",
    },
    "VbMnPpXxXxPlNePePvVo": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Plur",
        "Gender": "Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Voc",
    },
    "VbMnPpXxXxSgFePePvAc": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing",
        "Gender": "Fem",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Acc",
    },
    "VbMnPpXxXxSgFePePvGe": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing",
        "Gender": "Fem",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Gen",
    },
    "VbMnPpXxXxSgFePePvNm": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing",
        "Gender": "Fem",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom",
    },
    "VbMnPpXxXxSgFePePvVo": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing",
        "Gender": "Fem",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Voc",
    },
    "VbMnPpXxXxSgMaPePvAc": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing",
        "Gender": "Masc",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Acc",
    },
    "VbMnPpXxXxSgMaPePvGe": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing",
        "Gender": "Masc",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Gen",
    },
    "VbMnPpXxXxSgMaPePvNm": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing",
        "Gender": "Masc",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom",
    },
    "VbMnPpXxXxSgMaPePvVo": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing",
        "Gender": "Masc",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Voc",
    },
    "VbMnPpXxXxSgNePePvAc": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing",
        "Gender": "Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Acc",
    },
    "VbMnPpXxXxSgNePePvGe": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing",
        "Gender": "Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Gen",
    },
    "VbMnPpXxXxSgNePePvNm": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing",
        "Gender": "Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Nom",
    },
    "VbMnPpXxXxSgNePePvVo": {
        POS: VERB,
        "VerbForm": "Part",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing",
        "Gender": "Neut",
        "Aspect": "Perf",
        "Voice": "Pass",
        "Case": "Voc",
    },
    "VbMnPpXxXxXxXxIpAvXx": {
        POS: VERB,
        "VerbForm": "Conv",
        "Mood": "",
        "Tense": "Pres|Past",
        "Person": "1|2|3",
        "Number": "Sing|Plur",
        "Gender": "Masc|Fem|Neut",
        "Aspect": "Imp",
        "Voice": "Act",
        "Case": "Nom|Gen|Dat|Acc|Voc",
    },
    "ADJ": {POS: ADJ},
    "ADP": {POS: ADP},
    "ADV": {POS: ADV},
    "AtDf": {POS: DET},
    "AUX": {POS: AUX},
    "CCONJ": {POS: CCONJ},
    "DET": {POS: DET},
    "NOUN": {POS: NOUN},
    "NUM": {POS: NUM},
    "PART": {POS: PART},
    "PRON": {POS: PRON},
    "PROPN": {POS: PROPN},
    "SCONJ": {POS: SCONJ},
    "SYM": {POS: SYM},
    "VERB": {POS: VERB},
    "X": {POS: X},
}
