"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InitSource = exports.InitService = exports.InitPackage = exports.InitUser = exports.InitGroup = exports.InitFile = exports.InitCommand = exports.InitCommandWaitDuration = exports.InitElement = exports.InitServiceRestartHandle = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const s3_assets = require("@aws-cdk/aws-s3-assets");
const core_1 = require("@aws-cdk/core");
const cfn_init_internal_1 = require("./private/cfn-init-internal");
/**
 * An object that represents reasons to restart an InitService.
 *
 * Pass an instance of this object to the `InitFile`, `InitCommand`,
 * `InitSource` and `InitPackage` objects, and finally to an `InitService`
 * itself to cause the actions (files, commands, sources, and packages)
 * to trigger a restart of the service.
 *
 * For example, the following will run a custom command to install Nginx,
 * and trigger the nginx service to be restarted after the command has run.
 *
 * ```ts
 * const handle = new ec2.InitServiceRestartHandle();
 * ec2.CloudFormationInit.fromElements(
 *    ec2.InitCommand.shellCommand('/usr/bin/custom-nginx-install.sh', { serviceRestartHandles: [handle] }),
 *    ec2.InitService.enable('nginx', { serviceRestartHandle: handle }),
 * );
 * ```
 *
 * @stability stable
 */
class InitServiceRestartHandle {
    constructor() {
        this.commands = new Array();
        this.files = new Array();
        this.sources = new Array();
        this.packages = {};
    }
    /**
     * Add a command key to the restart set
     * @internal
     */
    _addCommand(key) {
        return this.commands.push(key);
    }
    /**
     * Add a file key to the restart set
     * @internal
     */
    _addFile(key) {
        return this.files.push(key);
    }
    /**
     * Add a source key to the restart set
     * @internal
     */
    _addSource(key) {
        return this.sources.push(key);
    }
    /**
     * Add a package key to the restart set
     * @internal
     */
    _addPackage(packageType, key) {
        if (!this.packages[packageType]) {
            this.packages[packageType] = [];
        }
        this.packages[packageType].push(key);
    }
    /**
     * Render the restart handles for use in an InitService declaration
     * @internal
     */
    _renderRestartHandles() {
        const nonEmpty = (x) => x.length > 0 ? x : undefined;
        return {
            commands: nonEmpty(this.commands),
            files: nonEmpty(this.files),
            packages: Object.keys(this.packages).length > 0 ? this.packages : undefined,
            sources: nonEmpty(this.sources),
        };
    }
}
exports.InitServiceRestartHandle = InitServiceRestartHandle;
_a = JSII_RTTI_SYMBOL_1;
InitServiceRestartHandle[_a] = { fqn: "@aws-cdk/aws-ec2.InitServiceRestartHandle", version: "1.136.0" };
/**
 * Base class for all CloudFormation Init elements.
 *
 * @stability stable
 */
class InitElement {
}
exports.InitElement = InitElement;
_b = JSII_RTTI_SYMBOL_1;
InitElement[_b] = { fqn: "@aws-cdk/aws-ec2.InitElement", version: "1.136.0" };
/**
 * Represents a duration to wait after a command has finished, in case of a reboot (Windows only).
 *
 * @stability stable
 */
class InitCommandWaitDuration {
    /**
     * Wait for a specified duration after a command.
     *
     * @stability stable
     */
    static of(duration) {
        return new class extends InitCommandWaitDuration {
            /** @internal */
            _render() { return duration.toSeconds(); }
        }();
    }
    /**
     * Do not wait for this command.
     *
     * @stability stable
     */
    static none() {
        return InitCommandWaitDuration.of(core_1.Duration.seconds(0));
    }
    /**
     * cfn-init will exit and resume only after a reboot.
     *
     * @stability stable
     */
    static forever() {
        return new class extends InitCommandWaitDuration {
            /** @internal */
            _render() { return 'forever'; }
        }();
    }
}
exports.InitCommandWaitDuration = InitCommandWaitDuration;
_c = JSII_RTTI_SYMBOL_1;
InitCommandWaitDuration[_c] = { fqn: "@aws-cdk/aws-ec2.InitCommandWaitDuration", version: "1.136.0" };
/**
 * Command to execute on the instance.
 *
 * @stability stable
 */
class InitCommand extends InitElement {
    constructor(command, options) {
        super();
        this.command = command;
        this.options = options;
        /**
         * Returns the init element type for this element.
         *
         * @stability stable
         */
        this.elementType = cfn_init_internal_1.InitElementType.COMMAND.toString();
    }
    /**
     * Run a shell command.
     *
     * Remember that some characters like `&`, `|`, `;`, `>` etc. have special meaning in a shell and
     * need to be preceded by a `\` if you want to treat them as part of a filename.
     *
     * @stability stable
     */
    static shellCommand(shellCommand, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitCommandOptions(options);
        return new InitCommand(shellCommand, options);
    }
    /**
     * Run a command from an argv array.
     *
     * You do not need to escape space characters or enclose command parameters in quotes.
     *
     * @stability stable
     */
    static argvCommand(argv, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitCommandOptions(options);
        if (argv.length === 0) {
            throw new Error('Cannot define argvCommand with an empty arguments');
        }
        return new InitCommand(argv, options);
    }
    /** @internal */
    _bind(options) {
        var _l, _m;
        const commandKey = this.options.key || `${options.index}`.padStart(3, '0'); // 001, 005, etc.
        if (options.platform !== cfn_init_internal_1.InitPlatform.WINDOWS && this.options.waitAfterCompletion !== undefined) {
            throw new Error(`Command '${this.command}': 'waitAfterCompletion' is only valid for Windows systems.`);
        }
        for (const handle of (_l = this.options.serviceRestartHandles) !== null && _l !== void 0 ? _l : []) {
            handle._addCommand(commandKey);
        }
        return {
            config: {
                [commandKey]: {
                    command: this.command,
                    env: this.options.env,
                    cwd: this.options.cwd,
                    test: this.options.testCmd,
                    ignoreErrors: this.options.ignoreErrors,
                    waitAfterCompletion: (_m = this.options.waitAfterCompletion) === null || _m === void 0 ? void 0 : _m._render(),
                },
            },
        };
    }
}
exports.InitCommand = InitCommand;
_d = JSII_RTTI_SYMBOL_1;
InitCommand[_d] = { fqn: "@aws-cdk/aws-ec2.InitCommand", version: "1.136.0" };
/**
 * Create files on the EC2 instance.
 *
 * @stability stable
 */
class InitFile extends InitElement {
    /**
     * @stability stable
     */
    constructor(fileName, options) {
        super();
        this.fileName = fileName;
        this.options = options;
        /**
         * Returns the init element type for this element.
         *
         * @stability stable
         */
        this.elementType = cfn_init_internal_1.InitElementType.FILE.toString();
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
    }
    /**
     * Use a literal string as the file content.
     *
     * @stability stable
     */
    static fromString(fileName, content, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        if (!content) {
            throw new Error(`InitFile ${fileName}: cannot create empty file. Please supply at least one character of content.`);
        }
        return new class extends InitFile {
            _doBind(bindOptions) {
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        content,
                        encoding: this.options.base64Encoded ? 'base64' : 'plain',
                    }),
                };
            }
        }(fileName, options);
    }
    /**
     * Write a symlink with the given symlink target.
     *
     * @stability stable
     */
    static symlink(fileName, target, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        const { mode, ...otherOptions } = options;
        if (mode && mode.slice(0, 3) !== '120') {
            throw new Error('File mode for symlinks must begin with 120XXX');
        }
        return InitFile.fromString(fileName, target, { mode: (mode || '120644'), ...otherOptions });
    }
    /**
     * Use a JSON-compatible object as the file content, write it to a JSON file.
     *
     * May contain tokens.
     *
     * @stability stable
     */
    static fromObject(fileName, obj, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        return new class extends InitFile {
            _doBind(bindOptions) {
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        content: obj,
                    }),
                };
            }
        }(fileName, options);
    }
    /**
     * Read a file from disk and use its contents.
     *
     * The file will be embedded in the template, so care should be taken to not
     * exceed the template size.
     *
     * If options.base64encoded is set to true, this will base64-encode the file's contents.
     *
     * @stability stable
     */
    static fromFileInline(targetFileName, sourceFileName, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        const encoding = options.base64Encoded ? 'base64' : 'utf8';
        const fileContents = fs.readFileSync(sourceFileName).toString(encoding);
        return InitFile.fromString(targetFileName, fileContents, options);
    }
    /**
     * Download from a URL at instance startup time.
     *
     * @stability stable
     */
    static fromUrl(fileName, url, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        return new class extends InitFile {
            _doBind(bindOptions) {
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        source: url,
                    }),
                };
            }
        }(fileName, options);
    }
    /**
     * Download a file from an S3 bucket at instance startup time.
     *
     * @stability stable
     */
    static fromS3Object(fileName, bucket, key, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        return new class extends InitFile {
            _doBind(bindOptions) {
                bucket.grantRead(bindOptions.instanceRole, key);
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        source: bucket.urlForObject(key),
                    }),
                    authentication: standardS3Auth(bindOptions.instanceRole, bucket.bucketName),
                };
            }
        }(fileName, options);
    }
    /**
     * Create an asset from the given file.
     *
     * This is appropriate for files that are too large to embed into the template.
     *
     * @stability stable
     */
    static fromAsset(targetFileName, path, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileAssetOptions(options);
        return new class extends InitFile {
            _doBind(bindOptions) {
                const asset = new s3_assets.Asset(bindOptions.scope, `${targetFileName}Asset`, {
                    path,
                    ...options,
                });
                asset.grantRead(bindOptions.instanceRole);
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        source: asset.httpUrl,
                    }),
                    authentication: standardS3Auth(bindOptions.instanceRole, asset.s3BucketName),
                    assetHash: asset.assetHash,
                };
            }
        }(targetFileName, options);
    }
    /**
     * Use a file from an asset at instance startup time.
     *
     * @stability stable
     */
    static fromExistingAsset(targetFileName, asset, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        return new class extends InitFile {
            _doBind(bindOptions) {
                asset.grantRead(bindOptions.instanceRole);
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        source: asset.httpUrl,
                    }),
                    authentication: standardS3Auth(bindOptions.instanceRole, asset.s3BucketName),
                    assetHash: asset.assetHash,
                };
            }
        }(targetFileName, options);
    }
    /** @internal */
    _bind(bindOptions) {
        var _l;
        for (const handle of (_l = this.options.serviceRestartHandles) !== null && _l !== void 0 ? _l : []) {
            handle._addFile(this.fileName);
        }
        return this._doBind(bindOptions);
    }
    /**
     * Render the standard config block, given content vars
     * @internal
     */
    _standardConfig(fileOptions, platform, contentVars) {
        if (platform === cfn_init_internal_1.InitPlatform.WINDOWS) {
            if (fileOptions.group || fileOptions.owner || fileOptions.mode) {
                throw new Error('Owner, group, and mode options not supported for Windows.');
            }
            return {
                [this.fileName]: { ...contentVars },
            };
        }
        return {
            [this.fileName]: {
                ...contentVars,
                mode: fileOptions.mode || '000644',
                owner: fileOptions.owner || 'root',
                group: fileOptions.group || 'root',
            },
        };
    }
}
exports.InitFile = InitFile;
_e = JSII_RTTI_SYMBOL_1;
InitFile[_e] = { fqn: "@aws-cdk/aws-ec2.InitFile", version: "1.136.0" };
/**
 * Create Linux/UNIX groups and assign group IDs.
 *
 * Not supported for Windows systems.
 *
 * @stability stable
 */
class InitGroup extends InitElement {
    /**
     * @stability stable
     */
    constructor(groupName, groupId) {
        super();
        this.groupName = groupName;
        this.groupId = groupId;
        /**
         * Returns the init element type for this element.
         *
         * @stability stable
         */
        this.elementType = cfn_init_internal_1.InitElementType.GROUP.toString();
    }
    /**
     * Create a group from its name, and optionally, group id.
     *
     * @stability stable
     */
    static fromName(groupName, groupId) {
        return new InitGroup(groupName, groupId);
    }
    /** @internal */
    _bind(options) {
        if (options.platform === cfn_init_internal_1.InitPlatform.WINDOWS) {
            throw new Error('Init groups are not supported on Windows');
        }
        return {
            config: {
                [this.groupName]: this.groupId !== undefined ? { gid: this.groupId } : {},
            },
        };
    }
}
exports.InitGroup = InitGroup;
_f = JSII_RTTI_SYMBOL_1;
InitGroup[_f] = { fqn: "@aws-cdk/aws-ec2.InitGroup", version: "1.136.0" };
/**
 * Create Linux/UNIX users and to assign user IDs.
 *
 * Users are created as non-interactive system users with a shell of
 * /sbin/nologin. This is by design and cannot be modified.
 *
 * Not supported for Windows systems.
 *
 * @stability stable
 */
class InitUser extends InitElement {
    /**
     * @stability stable
     */
    constructor(userName, userOptions) {
        super();
        this.userName = userName;
        this.userOptions = userOptions;
        /**
         * Returns the init element type for this element.
         *
         * @stability stable
         */
        this.elementType = cfn_init_internal_1.InitElementType.USER.toString();
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitUserOptions(userOptions);
    }
    /**
     * Create a user from user name.
     *
     * @stability stable
     */
    static fromName(userName, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitUserOptions(options);
        return new InitUser(userName, options);
    }
    /** @internal */
    _bind(options) {
        if (options.platform === cfn_init_internal_1.InitPlatform.WINDOWS) {
            throw new Error('Init users are not supported on Windows');
        }
        return {
            config: {
                [this.userName]: {
                    uid: this.userOptions.userId,
                    groups: this.userOptions.groups,
                    homeDir: this.userOptions.homeDir,
                },
            },
        };
    }
}
exports.InitUser = InitUser;
_g = JSII_RTTI_SYMBOL_1;
InitUser[_g] = { fqn: "@aws-cdk/aws-ec2.InitUser", version: "1.136.0" };
/**
 * A package to be installed during cfn-init time.
 *
 * @stability stable
 */
class InitPackage extends InitElement {
    /**
     * @stability stable
     */
    constructor(type, versions, packageName, serviceHandles) {
        super();
        this.type = type;
        this.versions = versions;
        this.packageName = packageName;
        this.serviceHandles = serviceHandles;
        /**
         * Returns the init element type for this element.
         *
         * @stability stable
         */
        this.elementType = cfn_init_internal_1.InitElementType.PACKAGE.toString();
    }
    /**
     * Install an RPM from an HTTP URL or a location on disk.
     *
     * @stability stable
     */
    static rpm(location, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_LocationPackageOptions(options);
        return new InitPackage('rpm', [location], options.key, options.serviceRestartHandles);
    }
    /**
     * Install a package using Yum.
     *
     * @stability stable
     */
    static yum(packageName, options = {}) {
        var _l;
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_NamedPackageOptions(options);
        return new InitPackage('yum', (_l = options.version) !== null && _l !== void 0 ? _l : [], packageName, options.serviceRestartHandles);
    }
    /**
     * Install a package from RubyGems.
     *
     * @stability stable
     */
    static rubyGem(gemName, options = {}) {
        var _l;
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_NamedPackageOptions(options);
        return new InitPackage('rubygems', (_l = options.version) !== null && _l !== void 0 ? _l : [], gemName, options.serviceRestartHandles);
    }
    /**
     * Install a package from PyPI.
     *
     * @stability stable
     */
    static python(packageName, options = {}) {
        var _l;
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_NamedPackageOptions(options);
        return new InitPackage('python', (_l = options.version) !== null && _l !== void 0 ? _l : [], packageName, options.serviceRestartHandles);
    }
    /**
     * Install a package using APT.
     *
     * @stability stable
     */
    static apt(packageName, options = {}) {
        var _l;
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_NamedPackageOptions(options);
        return new InitPackage('apt', (_l = options.version) !== null && _l !== void 0 ? _l : [], packageName, options.serviceRestartHandles);
    }
    /**
     * Install an MSI package from an HTTP URL or a location on disk.
     *
     * @stability stable
     */
    static msi(location, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_LocationPackageOptions(options);
        // The MSI package version must be a string, not an array.
        return new class extends InitPackage {
            renderPackageVersions() { return location; }
        }('msi', [location], options.key, options.serviceRestartHandles);
    }
    /** @internal */
    _bind(options) {
        var _l;
        if ((this.type === 'msi') !== (options.platform === cfn_init_internal_1.InitPlatform.WINDOWS)) {
            if (this.type === 'msi') {
                throw new Error('MSI installers are only supported on Windows systems.');
            }
            else {
                throw new Error('Windows only supports the MSI package type');
            }
        }
        if (!this.packageName && !['rpm', 'msi'].includes(this.type)) {
            throw new Error('Package name must be specified for all package types besides RPM and MSI.');
        }
        const packageName = this.packageName || `${options.index}`.padStart(3, '0');
        for (const handle of (_l = this.serviceHandles) !== null && _l !== void 0 ? _l : []) {
            handle._addPackage(this.type, packageName);
        }
        return {
            config: {
                [this.type]: {
                    [packageName]: this.renderPackageVersions(),
                },
            },
        };
    }
    /**
     * @stability stable
     */
    renderPackageVersions() {
        return this.versions;
    }
}
exports.InitPackage = InitPackage;
_h = JSII_RTTI_SYMBOL_1;
InitPackage[_h] = { fqn: "@aws-cdk/aws-ec2.InitPackage", version: "1.136.0" };
/**
 * A services that be enabled, disabled or restarted when the instance is launched.
 *
 * @stability stable
 */
class InitService extends InitElement {
    constructor(serviceName, serviceOptions) {
        super();
        this.serviceName = serviceName;
        this.serviceOptions = serviceOptions;
        /**
         * Returns the init element type for this element.
         *
         * @stability stable
         */
        this.elementType = cfn_init_internal_1.InitElementType.SERVICE.toString();
    }
    /**
     * Enable and start the given service, optionally restarting it.
     *
     * @stability stable
     */
    static enable(serviceName, options = {}) {
        var _l;
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitServiceOptions(options);
        const { enabled, ensureRunning, ...otherOptions } = options;
        return new InitService(serviceName, {
            enabled: enabled !== null && enabled !== void 0 ? enabled : true,
            ensureRunning: (_l = ensureRunning !== null && ensureRunning !== void 0 ? ensureRunning : enabled) !== null && _l !== void 0 ? _l : true,
            ...otherOptions,
        });
    }
    /**
     * Disable and stop the given service.
     *
     * @stability stable
     */
    static disable(serviceName) {
        return new InitService(serviceName, { enabled: false, ensureRunning: false });
    }
    /** @internal */
    _bind(options) {
        var _l;
        const serviceManager = options.platform === cfn_init_internal_1.InitPlatform.LINUX ? 'sysvinit' : 'windows';
        return {
            config: {
                [serviceManager]: {
                    [this.serviceName]: {
                        enabled: this.serviceOptions.enabled,
                        ensureRunning: this.serviceOptions.ensureRunning,
                        ...(_l = this.serviceOptions.serviceRestartHandle) === null || _l === void 0 ? void 0 : _l._renderRestartHandles(),
                    },
                },
            },
        };
    }
}
exports.InitService = InitService;
_j = JSII_RTTI_SYMBOL_1;
InitService[_j] = { fqn: "@aws-cdk/aws-ec2.InitService", version: "1.136.0" };
/**
 * Extract an archive into a directory.
 *
 * @stability stable
 */
class InitSource extends InitElement {
    /**
     * @stability stable
     */
    constructor(targetDirectory, serviceHandles) {
        super();
        this.targetDirectory = targetDirectory;
        this.serviceHandles = serviceHandles;
        /**
         * Returns the init element type for this element.
         *
         * @stability stable
         */
        this.elementType = cfn_init_internal_1.InitElementType.SOURCE.toString();
    }
    /**
     * Retrieve a URL and extract it into the given directory.
     *
     * @stability stable
     */
    static fromUrl(targetDirectory, url, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitSourceOptions(options);
        return new class extends InitSource {
            _doBind() {
                return {
                    config: { [this.targetDirectory]: url },
                };
            }
        }(targetDirectory, options.serviceRestartHandles);
    }
    /**
     * Extract a GitHub branch into a given directory.
     *
     * @stability stable
     */
    static fromGitHub(targetDirectory, owner, repo, refSpec, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitSourceOptions(options);
        return InitSource.fromUrl(targetDirectory, `https://github.com/${owner}/${repo}/tarball/${refSpec !== null && refSpec !== void 0 ? refSpec : 'master'}`, options);
    }
    /**
     * Extract an archive stored in an S3 bucket into the given directory.
     *
     * @stability stable
     */
    static fromS3Object(targetDirectory, bucket, key, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitSourceOptions(options);
        return new class extends InitSource {
            _doBind(bindOptions) {
                bucket.grantRead(bindOptions.instanceRole, key);
                return {
                    config: { [this.targetDirectory]: bucket.urlForObject(key) },
                    authentication: standardS3Auth(bindOptions.instanceRole, bucket.bucketName),
                };
            }
        }(targetDirectory, options.serviceRestartHandles);
    }
    /**
     * Create an InitSource from an asset created from the given path.
     *
     * @stability stable
     */
    static fromAsset(targetDirectory, path, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitSourceAssetOptions(options);
        return new class extends InitSource {
            _doBind(bindOptions) {
                const asset = new s3_assets.Asset(bindOptions.scope, `${targetDirectory}Asset`, {
                    path,
                    ...bindOptions,
                });
                asset.grantRead(bindOptions.instanceRole);
                return {
                    config: { [this.targetDirectory]: asset.httpUrl },
                    authentication: standardS3Auth(bindOptions.instanceRole, asset.s3BucketName),
                    assetHash: asset.assetHash,
                };
            }
        }(targetDirectory, options.serviceRestartHandles);
    }
    /**
     * Extract a directory from an existing directory asset.
     *
     * @stability stable
     */
    static fromExistingAsset(targetDirectory, asset, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitSourceOptions(options);
        return new class extends InitSource {
            _doBind(bindOptions) {
                asset.grantRead(bindOptions.instanceRole);
                return {
                    config: { [this.targetDirectory]: asset.httpUrl },
                    authentication: standardS3Auth(bindOptions.instanceRole, asset.s3BucketName),
                    assetHash: asset.assetHash,
                };
            }
        }(targetDirectory, options.serviceRestartHandles);
    }
    /** @internal */
    _bind(options) {
        var _l;
        for (const handle of (_l = this.serviceHandles) !== null && _l !== void 0 ? _l : []) {
            handle._addSource(this.targetDirectory);
        }
        // Delegate actual bind to subclasses
        return this._doBind(options);
    }
}
exports.InitSource = InitSource;
_k = JSII_RTTI_SYMBOL_1;
InitSource[_k] = { fqn: "@aws-cdk/aws-ec2.InitSource", version: "1.136.0" };
/**
 * Render a standard S3 auth block for use in AWS::CloudFormation::Authentication
 *
 * This block is the same every time (modulo bucket name), so it has the same
 * key every time so the blocks are merged into one in the final render.
 */
function standardS3Auth(role, bucketName) {
    return {
        S3AccessCreds: {
            type: 'S3',
            roleName: role.roleName,
            buckets: [bucketName],
        },
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ZuLWluaXQtZWxlbWVudHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjZm4taW5pdC1lbGVtZW50cy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx5QkFBeUI7QUFHekIsb0RBQW9EO0FBQ3BELHdDQUF5QztBQUN6QyxtRUFBZ0g7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFHaEgsTUFBYSx3QkFBd0I7SUFBckM7UUFDbUIsYUFBUSxHQUFHLElBQUksS0FBSyxFQUFVLENBQUM7UUFDL0IsVUFBSyxHQUFHLElBQUksS0FBSyxFQUFVLENBQUM7UUFDNUIsWUFBTyxHQUFHLElBQUksS0FBSyxFQUFVLENBQUM7UUFDOUIsYUFBUSxHQUE2QixFQUFFLENBQUM7S0FtRDFEO0lBakRDOzs7T0FHRztJQUNJLFdBQVcsQ0FBQyxHQUFXO1FBQzVCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7S0FDaEM7SUFFRDs7O09BR0c7SUFDSSxRQUFRLENBQUMsR0FBVztRQUN6QixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0tBQzdCO0lBRUQ7OztPQUdHO0lBQ0ksVUFBVSxDQUFDLEdBQVc7UUFDM0IsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztLQUMvQjtJQUVEOzs7T0FHRztJQUNJLFdBQVcsQ0FBQyxXQUFtQixFQUFFLEdBQVc7UUFDakQsSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLEVBQUU7WUFDL0IsSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsR0FBRyxFQUFFLENBQUM7U0FDakM7UUFDRCxJQUFJLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztLQUN0QztJQUVEOzs7T0FHRztJQUNJLHFCQUFxQjtRQUMxQixNQUFNLFFBQVEsR0FBRyxDQUFJLENBQU0sRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO1FBRTdELE9BQU87WUFDTCxRQUFRLEVBQUUsUUFBUSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7WUFDakMsS0FBSyxFQUFFLFFBQVEsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQzNCLFFBQVEsRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQzNFLE9BQU8sRUFBRSxRQUFRLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUNoQyxDQUFDO0tBQ0g7O0FBdERILDREQXVEQzs7Ozs7Ozs7QUFHRCxNQUFzQixXQUFXOztBQUFqQyxrQ0FlQzs7Ozs7Ozs7QUEyQkQsTUFBc0IsdUJBQXVCOzs7Ozs7SUFFcEMsTUFBTSxDQUFDLEVBQUUsQ0FBQyxRQUFrQjtRQUNqQyxPQUFPLElBQUksS0FBTSxTQUFRLHVCQUF1QjtZQUM5QyxnQkFBZ0I7WUFDVCxPQUFPLEtBQUssT0FBTyxRQUFRLENBQUMsU0FBUyxFQUFFLENBQUMsQ0FBQyxDQUFDO1NBQ2xELEVBQUUsQ0FBQztLQUNMOzs7Ozs7SUFHTSxNQUFNLENBQUMsSUFBSTtRQUNoQixPQUFPLHVCQUF1QixDQUFDLEVBQUUsQ0FBQyxlQUFRLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDeEQ7Ozs7OztJQUdNLE1BQU0sQ0FBQyxPQUFPO1FBQ25CLE9BQU8sSUFBSSxLQUFNLFNBQVEsdUJBQXVCO1lBQzlDLGdCQUFnQjtZQUNULE9BQU8sS0FBSyxPQUFPLFNBQVMsQ0FBQyxDQUFDLENBQUM7U0FDdkMsRUFBRSxDQUFDO0tBQ0w7O0FBcEJILDBEQTJCQzs7Ozs7Ozs7QUFHRCxNQUFhLFdBQVksU0FBUSxXQUFXO0lBZ0IxQyxZQUFxQyxPQUEwQixFQUFtQixPQUEyQjtRQUMzRyxLQUFLLEVBQUUsQ0FBQztRQUQyQixZQUFPLEdBQVAsT0FBTyxDQUFtQjtRQUFtQixZQUFPLEdBQVAsT0FBTyxDQUFvQjs7Ozs7O1FBRjdGLGdCQUFXLEdBQUcsbUNBQWUsQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFLENBQUM7S0FJaEU7Ozs7Ozs7OztJQWhCTSxNQUFNLENBQUMsWUFBWSxDQUFDLFlBQW9CLEVBQUUsVUFBOEIsRUFBRTs7UUFDL0UsT0FBTyxJQUFJLFdBQVcsQ0FBQyxZQUFZLEVBQUUsT0FBTyxDQUFDLENBQUM7S0FDL0M7Ozs7Ozs7O0lBR00sTUFBTSxDQUFDLFdBQVcsQ0FBQyxJQUFjLEVBQUUsVUFBOEIsRUFBRTs7UUFDeEUsSUFBSSxJQUFJLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtZQUNyQixNQUFNLElBQUksS0FBSyxDQUFDLG1EQUFtRCxDQUFDLENBQUM7U0FDdEU7UUFDRCxPQUFPLElBQUksV0FBVyxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsQ0FBQztLQUN2QztJQVFELGdCQUFnQjtJQUNULEtBQUssQ0FBQyxPQUF3Qjs7UUFDbkMsTUFBTSxVQUFVLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLElBQUksR0FBRyxPQUFPLENBQUMsS0FBSyxFQUFFLENBQUMsUUFBUSxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsQ0FBQyxDQUFDLGlCQUFpQjtRQUU3RixJQUFJLE9BQU8sQ0FBQyxRQUFRLEtBQUssZ0NBQVksQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxtQkFBbUIsS0FBSyxTQUFTLEVBQUU7WUFDL0YsTUFBTSxJQUFJLEtBQUssQ0FBQyxZQUFZLElBQUksQ0FBQyxPQUFPLDZEQUE2RCxDQUFDLENBQUM7U0FDeEc7UUFFRCxLQUFLLE1BQU0sTUFBTSxVQUFJLElBQUksQ0FBQyxPQUFPLENBQUMscUJBQXFCLG1DQUFJLEVBQUUsRUFBRTtZQUM3RCxNQUFNLENBQUMsV0FBVyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1NBQ2hDO1FBRUQsT0FBTztZQUNMLE1BQU0sRUFBRTtnQkFDTixDQUFDLFVBQVUsQ0FBQyxFQUFFO29CQUNaLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztvQkFDckIsR0FBRyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRztvQkFDckIsR0FBRyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRztvQkFDckIsSUFBSSxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTztvQkFDMUIsWUFBWSxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWTtvQkFDdkMsbUJBQW1CLFFBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxtQkFBbUIsMENBQUUsT0FBTyxFQUFFO2lCQUNqRTthQUNGO1NBQ0YsQ0FBQztLQUNIOztBQTVDSCxrQ0E4Q0M7Ozs7Ozs7O0FBeUJELE1BQXNCLFFBQVMsU0FBUSxXQUFXOzs7O0lBbUhoRCxZQUF1QyxRQUFnQixFQUFtQixPQUF3QjtRQUNoRyxLQUFLLEVBQUUsQ0FBQztRQUQ2QixhQUFRLEdBQVIsUUFBUSxDQUFRO1FBQW1CLFlBQU8sR0FBUCxPQUFPLENBQWlCOzs7Ozs7UUFGbEYsZ0JBQVcsR0FBRyxtQ0FBZSxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQzs7S0FJN0Q7Ozs7OztJQWxITSxNQUFNLENBQUMsVUFBVSxDQUFDLFFBQWdCLEVBQUUsT0FBZSxFQUFFLFVBQTJCLEVBQUU7O1FBQ3ZGLElBQUksQ0FBQyxPQUFPLEVBQUU7WUFDWixNQUFNLElBQUksS0FBSyxDQUFDLFlBQVksUUFBUSw4RUFBOEUsQ0FBQyxDQUFDO1NBQ3JIO1FBQ0QsT0FBTyxJQUFJLEtBQU0sU0FBUSxRQUFRO1lBQ3JCLE9BQU8sQ0FBQyxXQUE0QjtnQkFDNUMsT0FBTztvQkFDTCxNQUFNLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxPQUFPLEVBQUUsV0FBVyxDQUFDLFFBQVEsRUFBRTt3QkFDMUQsT0FBTzt3QkFDUCxRQUFRLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsT0FBTztxQkFDMUQsQ0FBQztpQkFDSCxDQUFDO1lBQ0osQ0FBQztTQUNGLENBQUMsUUFBUSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0tBQ3RCOzs7Ozs7SUFHTSxNQUFNLENBQUMsT0FBTyxDQUFDLFFBQWdCLEVBQUUsTUFBYyxFQUFFLFVBQTJCLEVBQUU7O1FBQ25GLE1BQU0sRUFBRSxJQUFJLEVBQUUsR0FBRyxZQUFZLEVBQUUsR0FBRyxPQUFPLENBQUM7UUFDMUMsSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEtBQUssS0FBSyxFQUFFO1lBQ3RDLE1BQU0sSUFBSSxLQUFLLENBQUMsK0NBQStDLENBQUMsQ0FBQztTQUNsRTtRQUNELE9BQU8sUUFBUSxDQUFDLFVBQVUsQ0FBQyxRQUFRLEVBQUUsTUFBTSxFQUFFLEVBQUUsSUFBSSxFQUFFLENBQUMsSUFBSSxJQUFJLFFBQVEsQ0FBQyxFQUFFLEdBQUcsWUFBWSxFQUFFLENBQUMsQ0FBQztLQUM3Rjs7Ozs7Ozs7SUFHTSxNQUFNLENBQUMsVUFBVSxDQUFDLFFBQWdCLEVBQUUsR0FBd0IsRUFBRSxVQUEyQixFQUFFOztRQUNoRyxPQUFPLElBQUksS0FBTSxTQUFRLFFBQVE7WUFDckIsT0FBTyxDQUFDLFdBQTRCO2dCQUM1QyxPQUFPO29CQUNMLE1BQU0sRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLE9BQU8sRUFBRSxXQUFXLENBQUMsUUFBUSxFQUFFO3dCQUMxRCxPQUFPLEVBQUUsR0FBRztxQkFDYixDQUFDO2lCQUNILENBQUM7WUFDSixDQUFDO1NBQ0YsQ0FBQyxRQUFRLEVBQUUsT0FBTyxDQUFDLENBQUM7S0FDdEI7Ozs7Ozs7Ozs7O0lBR00sTUFBTSxDQUFDLGNBQWMsQ0FBQyxjQUFzQixFQUFFLGNBQXNCLEVBQUUsVUFBMkIsRUFBRTs7UUFDeEcsTUFBTSxRQUFRLEdBQUcsT0FBTyxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUM7UUFDM0QsTUFBTSxZQUFZLEdBQUcsRUFBRSxDQUFDLFlBQVksQ0FBQyxjQUFjLENBQUMsQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDeEUsT0FBTyxRQUFRLENBQUMsVUFBVSxDQUFDLGNBQWMsRUFBRSxZQUFZLEVBQUUsT0FBTyxDQUFDLENBQUM7S0FDbkU7Ozs7OztJQUdNLE1BQU0sQ0FBQyxPQUFPLENBQUMsUUFBZ0IsRUFBRSxHQUFXLEVBQUUsVUFBMkIsRUFBRTs7UUFDaEYsT0FBTyxJQUFJLEtBQU0sU0FBUSxRQUFRO1lBQ3JCLE9BQU8sQ0FBQyxXQUE0QjtnQkFDNUMsT0FBTztvQkFDTCxNQUFNLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxPQUFPLEVBQUUsV0FBVyxDQUFDLFFBQVEsRUFBRTt3QkFDMUQsTUFBTSxFQUFFLEdBQUc7cUJBQ1osQ0FBQztpQkFDSCxDQUFDO1lBQ0osQ0FBQztTQUNGLENBQUMsUUFBUSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0tBQ3RCOzs7Ozs7SUFHTSxNQUFNLENBQUMsWUFBWSxDQUFDLFFBQWdCLEVBQUUsTUFBa0IsRUFBRSxHQUFXLEVBQUUsVUFBMkIsRUFBRTs7UUFDekcsT0FBTyxJQUFJLEtBQU0sU0FBUSxRQUFRO1lBQ3JCLE9BQU8sQ0FBQyxXQUE0QjtnQkFDNUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUNoRCxPQUFPO29CQUNMLE1BQU0sRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLE9BQU8sRUFBRSxXQUFXLENBQUMsUUFBUSxFQUFFO3dCQUMxRCxNQUFNLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUM7cUJBQ2pDLENBQUM7b0JBQ0YsY0FBYyxFQUFFLGNBQWMsQ0FBQyxXQUFXLENBQUMsWUFBWSxFQUFFLE1BQU0sQ0FBQyxVQUFVLENBQUM7aUJBQzVFLENBQUM7WUFDSixDQUFDO1NBQ0YsQ0FBQyxRQUFRLEVBQUUsT0FBTyxDQUFDLENBQUM7S0FDdEI7Ozs7Ozs7O0lBR00sTUFBTSxDQUFDLFNBQVMsQ0FBQyxjQUFzQixFQUFFLElBQVksRUFBRSxVQUFnQyxFQUFFOztRQUM5RixPQUFPLElBQUksS0FBTSxTQUFRLFFBQVE7WUFDckIsT0FBTyxDQUFDLFdBQTRCO2dCQUM1QyxNQUFNLEtBQUssR0FBRyxJQUFJLFNBQVMsQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBRSxHQUFHLGNBQWMsT0FBTyxFQUFFO29CQUM3RSxJQUFJO29CQUNKLEdBQUcsT0FBTztpQkFDWCxDQUFDLENBQUM7Z0JBQ0gsS0FBSyxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsWUFBWSxDQUFDLENBQUM7Z0JBRTFDLE9BQU87b0JBQ0wsTUFBTSxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsT0FBTyxFQUFFLFdBQVcsQ0FBQyxRQUFRLEVBQUU7d0JBQzFELE1BQU0sRUFBRSxLQUFLLENBQUMsT0FBTztxQkFDdEIsQ0FBQztvQkFDRixjQUFjLEVBQUUsY0FBYyxDQUFDLFdBQVcsQ0FBQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVksQ0FBQztvQkFDNUUsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO2lCQUMzQixDQUFDO1lBQ0osQ0FBQztTQUNGLENBQUMsY0FBYyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0tBQzVCOzs7Ozs7SUFHTSxNQUFNLENBQUMsaUJBQWlCLENBQUMsY0FBc0IsRUFBRSxLQUFzQixFQUFFLFVBQTJCLEVBQUU7O1FBQzNHLE9BQU8sSUFBSSxLQUFNLFNBQVEsUUFBUTtZQUNyQixPQUFPLENBQUMsV0FBNEI7Z0JBQzVDLEtBQUssQ0FBQyxTQUFTLENBQUMsV0FBVyxDQUFDLFlBQVksQ0FBQyxDQUFDO2dCQUMxQyxPQUFPO29CQUNMLE1BQU0sRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLE9BQU8sRUFBRSxXQUFXLENBQUMsUUFBUSxFQUFFO3dCQUMxRCxNQUFNLEVBQUUsS0FBSyxDQUFDLE9BQU87cUJBQ3RCLENBQUM7b0JBQ0YsY0FBYyxFQUFFLGNBQWMsQ0FBQyxXQUFXLENBQUMsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZLENBQUM7b0JBQzVFLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztpQkFDM0IsQ0FBQztZQUNKLENBQUM7U0FDRixDQUFDLGNBQWMsRUFBRSxPQUFPLENBQUMsQ0FBQztLQUM1QjtJQVFELGdCQUFnQjtJQUNULEtBQUssQ0FBQyxXQUE0Qjs7UUFDdkMsS0FBSyxNQUFNLE1BQU0sVUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLHFCQUFxQixtQ0FBSSxFQUFFLEVBQUU7WUFDN0QsTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7U0FDaEM7UUFFRCxPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLENBQUM7S0FDbEM7SUFXRDs7O09BR0c7SUFDTyxlQUFlLENBQUMsV0FBNEIsRUFBRSxRQUFzQixFQUFFLFdBQWdDO1FBQzlHLElBQUksUUFBUSxLQUFLLGdDQUFZLENBQUMsT0FBTyxFQUFFO1lBQ3JDLElBQUksV0FBVyxDQUFDLEtBQUssSUFBSSxXQUFXLENBQUMsS0FBSyxJQUFJLFdBQVcsQ0FBQyxJQUFJLEVBQUU7Z0JBQzlELE1BQU0sSUFBSSxLQUFLLENBQUMsMkRBQTJELENBQUMsQ0FBQzthQUM5RTtZQUNELE9BQU87Z0JBQ0wsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxHQUFHLFdBQVcsRUFBRTthQUNwQyxDQUFDO1NBQ0g7UUFFRCxPQUFPO1lBQ0wsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLEVBQUU7Z0JBQ2YsR0FBRyxXQUFXO2dCQUNkLElBQUksRUFBRSxXQUFXLENBQUMsSUFBSSxJQUFJLFFBQVE7Z0JBQ2xDLEtBQUssRUFBRSxXQUFXLENBQUMsS0FBSyxJQUFJLE1BQU07Z0JBQ2xDLEtBQUssRUFBRSxXQUFXLENBQUMsS0FBSyxJQUFJLE1BQU07YUFDbkM7U0FDRixDQUFDO0tBQ0g7O0FBL0pILDRCQWdLQzs7Ozs7Ozs7OztBQUdELE1BQWEsU0FBVSxTQUFRLFdBQVc7Ozs7SUFTeEMsWUFBOEIsU0FBaUIsRUFBVSxPQUFnQjtRQUN2RSxLQUFLLEVBQUUsQ0FBQztRQURvQixjQUFTLEdBQVQsU0FBUyxDQUFRO1FBQVUsWUFBTyxHQUFQLE9BQU8sQ0FBUzs7Ozs7O1FBRnpELGdCQUFXLEdBQUcsbUNBQWUsQ0FBQyxLQUFLLENBQUMsUUFBUSxFQUFFLENBQUM7S0FJOUQ7Ozs7OztJQVJNLE1BQU0sQ0FBQyxRQUFRLENBQUMsU0FBaUIsRUFBRSxPQUFnQjtRQUN4RCxPQUFPLElBQUksU0FBUyxDQUFDLFNBQVMsRUFBRSxPQUFPLENBQUMsQ0FBQztLQUMxQztJQVFELGdCQUFnQjtJQUNULEtBQUssQ0FBQyxPQUF3QjtRQUNuQyxJQUFJLE9BQU8sQ0FBQyxRQUFRLEtBQUssZ0NBQVksQ0FBQyxPQUFPLEVBQUU7WUFDN0MsTUFBTSxJQUFJLEtBQUssQ0FBQywwQ0FBMEMsQ0FBQyxDQUFDO1NBQzdEO1FBRUQsT0FBTztZQUNMLE1BQU0sRUFBRTtnQkFDTixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsRUFBRSxJQUFJLENBQUMsT0FBTyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsRUFBRSxHQUFHLEVBQUUsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFO2FBQzFFO1NBQ0YsQ0FBQztLQUNIOztBQXhCSCw4QkEwQkM7Ozs7Ozs7Ozs7Ozs7QUFlRCxNQUFhLFFBQVMsU0FBUSxXQUFXOzs7O0lBUXZDLFlBQXVDLFFBQWdCLEVBQW1CLFdBQTRCO1FBQ3BHLEtBQUssRUFBRSxDQUFDO1FBRDZCLGFBQVEsR0FBUixRQUFRLENBQVE7UUFBbUIsZ0JBQVcsR0FBWCxXQUFXLENBQWlCOzs7Ozs7UUFGdEYsZ0JBQVcsR0FBRyxtQ0FBZSxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQzs7S0FJN0Q7Ozs7OztJQVJNLE1BQU0sQ0FBQyxRQUFRLENBQUMsUUFBZ0IsRUFBRSxVQUEyQixFQUFFOztRQUNwRSxPQUFPLElBQUksUUFBUSxDQUFDLFFBQVEsRUFBRSxPQUFPLENBQUMsQ0FBQztLQUN4QztJQVFELGdCQUFnQjtJQUNULEtBQUssQ0FBQyxPQUF3QjtRQUNuQyxJQUFJLE9BQU8sQ0FBQyxRQUFRLEtBQUssZ0NBQVksQ0FBQyxPQUFPLEVBQUU7WUFDN0MsTUFBTSxJQUFJLEtBQUssQ0FBQyx5Q0FBeUMsQ0FBQyxDQUFDO1NBQzVEO1FBRUQsT0FBTztZQUNMLE1BQU0sRUFBRTtnQkFDTixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsRUFBRTtvQkFDZixHQUFHLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxNQUFNO29CQUM1QixNQUFNLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxNQUFNO29CQUMvQixPQUFPLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxPQUFPO2lCQUNsQzthQUNGO1NBQ0YsQ0FBQztLQUNIOztBQTNCSCw0QkE0QkM7Ozs7Ozs7O0FBcUJELE1BQWEsV0FBWSxTQUFRLFdBQVc7Ozs7SUFvQzFDLFlBQ21CLElBQVksRUFDWixRQUFrQixFQUNsQixXQUFvQixFQUNwQixjQUEyQztRQUU1RCxLQUFLLEVBQUUsQ0FBQztRQUxTLFNBQUksR0FBSixJQUFJLENBQVE7UUFDWixhQUFRLEdBQVIsUUFBUSxDQUFVO1FBQ2xCLGdCQUFXLEdBQVgsV0FBVyxDQUFTO1FBQ3BCLG1CQUFjLEdBQWQsY0FBYyxDQUE2Qjs7Ozs7O1FBTjlDLGdCQUFXLEdBQUcsbUNBQWUsQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFLENBQUM7S0FTaEU7Ozs7OztJQXpDTSxNQUFNLENBQUMsR0FBRyxDQUFDLFFBQWdCLEVBQUUsVUFBa0MsRUFBRTs7UUFDdEUsT0FBTyxJQUFJLFdBQVcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxRQUFRLENBQUMsRUFBRSxPQUFPLENBQUMsR0FBRyxFQUFFLE9BQU8sQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0tBQ3ZGOzs7Ozs7SUFHTSxNQUFNLENBQUMsR0FBRyxDQUFDLFdBQW1CLEVBQUUsVUFBK0IsRUFBRTs7O1FBQ3RFLE9BQU8sSUFBSSxXQUFXLENBQUMsS0FBSyxRQUFFLE9BQU8sQ0FBQyxPQUFPLG1DQUFJLEVBQUUsRUFBRSxXQUFXLEVBQUUsT0FBTyxDQUFDLHFCQUFxQixDQUFDLENBQUM7S0FDbEc7Ozs7OztJQUdNLE1BQU0sQ0FBQyxPQUFPLENBQUMsT0FBZSxFQUFFLFVBQStCLEVBQUU7OztRQUN0RSxPQUFPLElBQUksV0FBVyxDQUFDLFVBQVUsUUFBRSxPQUFPLENBQUMsT0FBTyxtQ0FBSSxFQUFFLEVBQUUsT0FBTyxFQUFFLE9BQU8sQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0tBQ25HOzs7Ozs7SUFHTSxNQUFNLENBQUMsTUFBTSxDQUFDLFdBQW1CLEVBQUUsVUFBK0IsRUFBRTs7O1FBQ3pFLE9BQU8sSUFBSSxXQUFXLENBQUMsUUFBUSxRQUFFLE9BQU8sQ0FBQyxPQUFPLG1DQUFJLEVBQUUsRUFBRSxXQUFXLEVBQUUsT0FBTyxDQUFDLHFCQUFxQixDQUFDLENBQUM7S0FDckc7Ozs7OztJQUdNLE1BQU0sQ0FBQyxHQUFHLENBQUMsV0FBbUIsRUFBRSxVQUErQixFQUFFOzs7UUFDdEUsT0FBTyxJQUFJLFdBQVcsQ0FBQyxLQUFLLFFBQUUsT0FBTyxDQUFDLE9BQU8sbUNBQUksRUFBRSxFQUFFLFdBQVcsRUFBRSxPQUFPLENBQUMscUJBQXFCLENBQUMsQ0FBQztLQUNsRzs7Ozs7O0lBR00sTUFBTSxDQUFDLEdBQUcsQ0FBQyxRQUFnQixFQUFFLFVBQWtDLEVBQUU7O1FBQ3RFLDBEQUEwRDtRQUMxRCxPQUFPLElBQUksS0FBTSxTQUFRLFdBQVc7WUFDeEIscUJBQXFCLEtBQUssT0FBTyxRQUFRLENBQUMsQ0FBQyxDQUFDO1NBQ3ZELENBQUMsS0FBSyxFQUFFLENBQUMsUUFBUSxDQUFDLEVBQUUsT0FBTyxDQUFDLEdBQUcsRUFBRSxPQUFPLENBQUMscUJBQXFCLENBQUMsQ0FBQztLQUNsRTtJQWFELGdCQUFnQjtJQUNULEtBQUssQ0FBQyxPQUF3Qjs7UUFDbkMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLEtBQUssS0FBSyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsUUFBUSxLQUFLLGdDQUFZLENBQUMsT0FBTyxDQUFDLEVBQUU7WUFDekUsSUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLEtBQUssRUFBRTtnQkFDdkIsTUFBTSxJQUFJLEtBQUssQ0FBQyx1REFBdUQsQ0FBQyxDQUFDO2FBQzFFO2lCQUFNO2dCQUNMLE1BQU0sSUFBSSxLQUFLLENBQUMsNENBQTRDLENBQUMsQ0FBQzthQUMvRDtTQUNGO1FBRUQsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLElBQUksQ0FBQyxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFO1lBQzVELE1BQU0sSUFBSSxLQUFLLENBQUMsMkVBQTJFLENBQUMsQ0FBQztTQUM5RjtRQUVELE1BQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxXQUFXLElBQUksR0FBRyxPQUFPLENBQUMsS0FBSyxFQUFFLENBQUMsUUFBUSxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsQ0FBQztRQUU1RSxLQUFLLE1BQU0sTUFBTSxVQUFJLElBQUksQ0FBQyxjQUFjLG1DQUFJLEVBQUUsRUFBRTtZQUM5QyxNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsV0FBVyxDQUFDLENBQUM7U0FDNUM7UUFFRCxPQUFPO1lBQ0wsTUFBTSxFQUFFO2dCQUNOLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFO29CQUNYLENBQUMsV0FBVyxDQUFDLEVBQUUsSUFBSSxDQUFDLHFCQUFxQixFQUFFO2lCQUM1QzthQUNGO1NBQ0YsQ0FBQztLQUNIOzs7O0lBRVMscUJBQXFCO1FBQzdCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztLQUN0Qjs7QUE1RUgsa0NBNkVDOzs7Ozs7OztBQWVELE1BQWEsV0FBWSxTQUFRLFdBQVc7SUFrQjFDLFlBQXFDLFdBQW1CLEVBQW1CLGNBQWtDO1FBQzNHLEtBQUssRUFBRSxDQUFDO1FBRDJCLGdCQUFXLEdBQVgsV0FBVyxDQUFRO1FBQW1CLG1CQUFjLEdBQWQsY0FBYyxDQUFvQjs7Ozs7O1FBRjdGLGdCQUFXLEdBQUcsbUNBQWUsQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFLENBQUM7S0FJaEU7Ozs7OztJQWxCTSxNQUFNLENBQUMsTUFBTSxDQUFDLFdBQW1CLEVBQUUsVUFBOEIsRUFBRTs7O1FBQ3hFLE1BQU0sRUFBRSxPQUFPLEVBQUUsYUFBYSxFQUFFLEdBQUcsWUFBWSxFQUFFLEdBQUcsT0FBTyxDQUFDO1FBQzVELE9BQU8sSUFBSSxXQUFXLENBQUMsV0FBVyxFQUFFO1lBQ2xDLE9BQU8sRUFBRSxPQUFPLGFBQVAsT0FBTyxjQUFQLE9BQU8sR0FBSSxJQUFJO1lBQ3hCLGFBQWEsUUFBRSxhQUFhLGFBQWIsYUFBYSxjQUFiLGFBQWEsR0FBSSxPQUFPLG1DQUFJLElBQUk7WUFDL0MsR0FBRyxZQUFZO1NBQ2hCLENBQUMsQ0FBQztLQUNKOzs7Ozs7SUFHTSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQW1CO1FBQ3ZDLE9BQU8sSUFBSSxXQUFXLENBQUMsV0FBVyxFQUFFLEVBQUUsT0FBTyxFQUFFLEtBQUssRUFBRSxhQUFhLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQztLQUMvRTtJQVFELGdCQUFnQjtJQUNULEtBQUssQ0FBQyxPQUF3Qjs7UUFDbkMsTUFBTSxjQUFjLEdBQUcsT0FBTyxDQUFDLFFBQVEsS0FBSyxnQ0FBWSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7UUFFeEYsT0FBTztZQUNMLE1BQU0sRUFBRTtnQkFDTixDQUFDLGNBQWMsQ0FBQyxFQUFFO29CQUNoQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsRUFBRTt3QkFDbEIsT0FBTyxFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsT0FBTzt3QkFDcEMsYUFBYSxFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsYUFBYTt3QkFDaEQsU0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDLG9CQUFvQiwwQ0FBRSxxQkFBcUIsRUFBRTtxQkFDckU7aUJBQ0Y7YUFDRjtTQUNGLENBQUM7S0FDSDs7QUFyQ0gsa0NBdUNDOzs7Ozs7OztBQWVELE1BQXNCLFVBQVcsU0FBUSxXQUFXOzs7O0lBbUVsRCxZQUF1QyxlQUF1QixFQUFtQixjQUEyQztRQUMxSCxLQUFLLEVBQUUsQ0FBQztRQUQ2QixvQkFBZSxHQUFmLGVBQWUsQ0FBUTtRQUFtQixtQkFBYyxHQUFkLGNBQWMsQ0FBNkI7Ozs7OztRQUY1RyxnQkFBVyxHQUFHLG1DQUFlLENBQUMsTUFBTSxDQUFDLFFBQVEsRUFBRSxDQUFDO0tBSS9EOzs7Ozs7SUFuRU0sTUFBTSxDQUFDLE9BQU8sQ0FBQyxlQUF1QixFQUFFLEdBQVcsRUFBRSxVQUE2QixFQUFFOztRQUN6RixPQUFPLElBQUksS0FBTSxTQUFRLFVBQVU7WUFDdkIsT0FBTztnQkFDZixPQUFPO29CQUNMLE1BQU0sRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxFQUFFLEdBQUcsRUFBRTtpQkFDeEMsQ0FBQztZQUNKLENBQUM7U0FDRixDQUFDLGVBQWUsRUFBRSxPQUFPLENBQUMscUJBQXFCLENBQUMsQ0FBQztLQUNuRDs7Ozs7O0lBR00sTUFBTSxDQUFDLFVBQVUsQ0FBQyxlQUF1QixFQUFFLEtBQWEsRUFBRSxJQUFZLEVBQUUsT0FBZ0IsRUFBRSxVQUE2QixFQUFFOztRQUM5SCxPQUFPLFVBQVUsQ0FBQyxPQUFPLENBQUMsZUFBZSxFQUFFLHNCQUFzQixLQUFLLElBQUksSUFBSSxZQUFZLE9BQU8sYUFBUCxPQUFPLGNBQVAsT0FBTyxHQUFJLFFBQVEsRUFBRSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0tBQzNIOzs7Ozs7SUFHTSxNQUFNLENBQUMsWUFBWSxDQUFDLGVBQXVCLEVBQUUsTUFBa0IsRUFBRSxHQUFXLEVBQUUsVUFBNkIsRUFBRTs7UUFDbEgsT0FBTyxJQUFJLEtBQU0sU0FBUSxVQUFVO1lBQ3ZCLE9BQU8sQ0FBQyxXQUE0QjtnQkFDNUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUVoRCxPQUFPO29CQUNMLE1BQU0sRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLEVBQUU7b0JBQzVELGNBQWMsRUFBRSxjQUFjLENBQUMsV0FBVyxDQUFDLFlBQVksRUFBRSxNQUFNLENBQUMsVUFBVSxDQUFDO2lCQUM1RSxDQUFDO1lBQ0osQ0FBQztTQUNGLENBQUMsZUFBZSxFQUFFLE9BQU8sQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0tBQ25EOzs7Ozs7SUFHTSxNQUFNLENBQUMsU0FBUyxDQUFDLGVBQXVCLEVBQUUsSUFBWSxFQUFFLFVBQWtDLEVBQUU7O1FBQ2pHLE9BQU8sSUFBSSxLQUFNLFNBQVEsVUFBVTtZQUN2QixPQUFPLENBQUMsV0FBNEI7Z0JBQzVDLE1BQU0sS0FBSyxHQUFHLElBQUksU0FBUyxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLEdBQUcsZUFBZSxPQUFPLEVBQUU7b0JBQzlFLElBQUk7b0JBQ0osR0FBRyxXQUFXO2lCQUNmLENBQUMsQ0FBQztnQkFDSCxLQUFLLENBQUMsU0FBUyxDQUFDLFdBQVcsQ0FBQyxZQUFZLENBQUMsQ0FBQztnQkFFMUMsT0FBTztvQkFDTCxNQUFNLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsRUFBRSxLQUFLLENBQUMsT0FBTyxFQUFFO29CQUNqRCxjQUFjLEVBQUUsY0FBYyxDQUFDLFdBQVcsQ0FBQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVksQ0FBQztvQkFDNUUsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO2lCQUMzQixDQUFDO1lBQ0osQ0FBQztTQUNGLENBQUMsZUFBZSxFQUFFLE9BQU8sQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0tBQ25EOzs7Ozs7SUFHTSxNQUFNLENBQUMsaUJBQWlCLENBQUMsZUFBdUIsRUFBRSxLQUFzQixFQUFFLFVBQTZCLEVBQUU7O1FBQzlHLE9BQU8sSUFBSSxLQUFNLFNBQVEsVUFBVTtZQUN2QixPQUFPLENBQUMsV0FBNEI7Z0JBQzVDLEtBQUssQ0FBQyxTQUFTLENBQUMsV0FBVyxDQUFDLFlBQVksQ0FBQyxDQUFDO2dCQUUxQyxPQUFPO29CQUNMLE1BQU0sRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxFQUFFLEtBQUssQ0FBQyxPQUFPLEVBQUU7b0JBQ2pELGNBQWMsRUFBRSxjQUFjLENBQUMsV0FBVyxDQUFDLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDO29CQUM1RSxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7aUJBQzNCLENBQUM7WUFDSixDQUFDO1NBQ0YsQ0FBQyxlQUFlLEVBQUUsT0FBTyxDQUFDLHFCQUFxQixDQUFDLENBQUM7S0FDbkQ7SUFRRCxnQkFBZ0I7SUFDVCxLQUFLLENBQUMsT0FBd0I7O1FBQ25DLEtBQUssTUFBTSxNQUFNLFVBQUksSUFBSSxDQUFDLGNBQWMsbUNBQUksRUFBRSxFQUFFO1lBQzlDLE1BQU0sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1NBQ3pDO1FBRUQscUNBQXFDO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQztLQUM5Qjs7QUEvRUgsZ0NBeUZDOzs7QUFFRDs7Ozs7R0FLRztBQUNILFNBQVMsY0FBYyxDQUFDLElBQWUsRUFBRSxVQUFrQjtJQUN6RCxPQUFPO1FBQ0wsYUFBYSxFQUFFO1lBQ2IsSUFBSSxFQUFFLElBQUk7WUFDVixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsT0FBTyxFQUFFLENBQUMsVUFBVSxDQUFDO1NBQ3RCO0tBQ0YsQ0FBQztBQUNKLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBmcyBmcm9tICdmcyc7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBzMyBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0ICogYXMgczNfYXNzZXRzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zMy1hc3NldHMnO1xuaW1wb3J0IHsgRHVyYXRpb24gfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IEluaXRCaW5kT3B0aW9ucywgSW5pdEVsZW1lbnRDb25maWcsIEluaXRFbGVtZW50VHlwZSwgSW5pdFBsYXRmb3JtIH0gZnJvbSAnLi9wcml2YXRlL2Nmbi1pbml0LWludGVybmFsJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEluaXRTZXJ2aWNlUmVzdGFydEhhbmRsZSB7XG4gIHByaXZhdGUgcmVhZG9ubHkgY29tbWFuZHMgPSBuZXcgQXJyYXk8c3RyaW5nPigpO1xuICBwcml2YXRlIHJlYWRvbmx5IGZpbGVzID0gbmV3IEFycmF5PHN0cmluZz4oKTtcbiAgcHJpdmF0ZSByZWFkb25seSBzb3VyY2VzID0gbmV3IEFycmF5PHN0cmluZz4oKTtcbiAgcHJpdmF0ZSByZWFkb25seSBwYWNrYWdlczogUmVjb3JkPHN0cmluZywgc3RyaW5nW10+ID0ge307XG5cbiAgLyoqXG4gICAqIEFkZCBhIGNvbW1hbmQga2V5IHRvIHRoZSByZXN0YXJ0IHNldFxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyBfYWRkQ29tbWFuZChrZXk6IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLmNvbW1hbmRzLnB1c2goa2V5KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGQgYSBmaWxlIGtleSB0byB0aGUgcmVzdGFydCBzZXRcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwdWJsaWMgX2FkZEZpbGUoa2V5OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5maWxlcy5wdXNoKGtleSk7XG4gIH1cblxuICAvKipcbiAgICogQWRkIGEgc291cmNlIGtleSB0byB0aGUgcmVzdGFydCBzZXRcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwdWJsaWMgX2FkZFNvdXJjZShrZXk6IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLnNvdXJjZXMucHVzaChrZXkpO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZCBhIHBhY2thZ2Uga2V5IHRvIHRoZSByZXN0YXJ0IHNldFxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyBfYWRkUGFja2FnZShwYWNrYWdlVHlwZTogc3RyaW5nLCBrZXk6IHN0cmluZykge1xuICAgIGlmICghdGhpcy5wYWNrYWdlc1twYWNrYWdlVHlwZV0pIHtcbiAgICAgIHRoaXMucGFja2FnZXNbcGFja2FnZVR5cGVdID0gW107XG4gICAgfVxuICAgIHRoaXMucGFja2FnZXNbcGFja2FnZVR5cGVdLnB1c2goa2V5KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZW5kZXIgdGhlIHJlc3RhcnQgaGFuZGxlcyBmb3IgdXNlIGluIGFuIEluaXRTZXJ2aWNlIGRlY2xhcmF0aW9uXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIF9yZW5kZXJSZXN0YXJ0SGFuZGxlcygpOiBhbnkge1xuICAgIGNvbnN0IG5vbkVtcHR5ID0gPEE+KHg6IEFbXSkgPT4geC5sZW5ndGggPiAwID8geCA6IHVuZGVmaW5lZDtcblxuICAgIHJldHVybiB7XG4gICAgICBjb21tYW5kczogbm9uRW1wdHkodGhpcy5jb21tYW5kcyksXG4gICAgICBmaWxlczogbm9uRW1wdHkodGhpcy5maWxlcyksXG4gICAgICBwYWNrYWdlczogT2JqZWN0LmtleXModGhpcy5wYWNrYWdlcykubGVuZ3RoID4gMCA/IHRoaXMucGFja2FnZXMgOiB1bmRlZmluZWQsXG4gICAgICBzb3VyY2VzOiBub25FbXB0eSh0aGlzLnNvdXJjZXMpLFxuICAgIH07XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEluaXRFbGVtZW50IHtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgZWxlbWVudFR5cGU6IHN0cmluZztcblxuICAvKipcbiAgICogQ2FsbGVkIHdoZW4gdGhlIEluaXQgY29uZmlnIGlzIGJlaW5nIGNvbnN1bWVkLiBSZW5kZXJzIHRoZSBDbG91ZEZvcm1hdGlvblxuICAgKiByZXByZXNlbnRhdGlvbiBvZiB0aGlzIGluaXQgZWxlbWVudCwgYW5kIGNhbGN1bGF0ZXMgYW55IGF1dGhlbnRpY2F0aW9uXG4gICAqIHByb3BlcnRpZXMgbmVlZGVkLCBpZiBhbnkuXG4gICAqXG4gICAqIEBwYXJhbSBvcHRpb25zIGJpbmQgb3B0aW9ucyBmb3IgdGhlIGVsZW1lbnQuXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IF9iaW5kKG9wdGlvbnM6IEluaXRCaW5kT3B0aW9ucyk6IEluaXRFbGVtZW50Q29uZmlnO1xuXG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSW5pdENvbW1hbmRPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGtleT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZW52PzogUmVjb3JkPHN0cmluZywgc3RyaW5nPjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY3dkPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGVzdENtZD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaWdub3JlRXJyb3JzPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHdhaXRBZnRlckNvbXBsZXRpb24/OiBJbml0Q29tbWFuZFdhaXREdXJhdGlvbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNlcnZpY2VSZXN0YXJ0SGFuZGxlcz86IEluaXRTZXJ2aWNlUmVzdGFydEhhbmRsZVtdO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgSW5pdENvbW1hbmRXYWl0RHVyYXRpb24ge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIG9mKGR1cmF0aW9uOiBEdXJhdGlvbik6IEluaXRDb21tYW5kV2FpdER1cmF0aW9uIHtcbiAgICByZXR1cm4gbmV3IGNsYXNzIGV4dGVuZHMgSW5pdENvbW1hbmRXYWl0RHVyYXRpb24ge1xuICAgICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgICAgcHVibGljIF9yZW5kZXIoKSB7IHJldHVybiBkdXJhdGlvbi50b1NlY29uZHMoKTsgfVxuICAgIH0oKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIG5vbmUoKTogSW5pdENvbW1hbmRXYWl0RHVyYXRpb24ge1xuICAgIHJldHVybiBJbml0Q29tbWFuZFdhaXREdXJhdGlvbi5vZihEdXJhdGlvbi5zZWNvbmRzKDApKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGZvcmV2ZXIoKTogSW5pdENvbW1hbmRXYWl0RHVyYXRpb24ge1xuICAgIHJldHVybiBuZXcgY2xhc3MgZXh0ZW5kcyBJbml0Q29tbWFuZFdhaXREdXJhdGlvbiB7XG4gICAgICAvKiogQGludGVybmFsICovXG4gICAgICBwdWJsaWMgX3JlbmRlcigpIHsgcmV0dXJuICdmb3JldmVyJzsgfVxuICAgIH0oKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZW5kZXIgdG8gYSBDbG91ZEZvcm1hdGlvbiB2YWx1ZS5cbiAgICogQGludGVybmFsXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgX3JlbmRlcigpOiBhbnk7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEluaXRDb21tYW5kIGV4dGVuZHMgSW5pdEVsZW1lbnQge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBzaGVsbENvbW1hbmQoc2hlbGxDb21tYW5kOiBzdHJpbmcsIG9wdGlvbnM6IEluaXRDb21tYW5kT3B0aW9ucyA9IHt9KTogSW5pdENvbW1hbmQge1xuICAgIHJldHVybiBuZXcgSW5pdENvbW1hbmQoc2hlbGxDb21tYW5kLCBvcHRpb25zKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGFyZ3ZDb21tYW5kKGFyZ3Y6IHN0cmluZ1tdLCBvcHRpb25zOiBJbml0Q29tbWFuZE9wdGlvbnMgPSB7fSk6IEluaXRDb21tYW5kIHtcbiAgICBpZiAoYXJndi5sZW5ndGggPT09IDApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQ2Fubm90IGRlZmluZSBhcmd2Q29tbWFuZCB3aXRoIGFuIGVtcHR5IGFyZ3VtZW50cycpO1xuICAgIH1cbiAgICByZXR1cm4gbmV3IEluaXRDb21tYW5kKGFyZ3YsIG9wdGlvbnMpO1xuICB9XG5cbiAgcHVibGljIHJlYWRvbmx5IGVsZW1lbnRUeXBlID0gSW5pdEVsZW1lbnRUeXBlLkNPTU1BTkQudG9TdHJpbmcoKTtcblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgY29tbWFuZDogc3RyaW5nW10gfCBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgb3B0aW9uczogSW5pdENvbW1hbmRPcHRpb25zKSB7XG4gICAgc3VwZXIoKTtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgcHVibGljIF9iaW5kKG9wdGlvbnM6IEluaXRCaW5kT3B0aW9ucyk6IEluaXRFbGVtZW50Q29uZmlnIHtcbiAgICBjb25zdCBjb21tYW5kS2V5ID0gdGhpcy5vcHRpb25zLmtleSB8fCBgJHtvcHRpb25zLmluZGV4fWAucGFkU3RhcnQoMywgJzAnKTsgLy8gMDAxLCAwMDUsIGV0Yy5cblxuICAgIGlmIChvcHRpb25zLnBsYXRmb3JtICE9PSBJbml0UGxhdGZvcm0uV0lORE9XUyAmJiB0aGlzLm9wdGlvbnMud2FpdEFmdGVyQ29tcGxldGlvbiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYENvbW1hbmQgJyR7dGhpcy5jb21tYW5kfSc6ICd3YWl0QWZ0ZXJDb21wbGV0aW9uJyBpcyBvbmx5IHZhbGlkIGZvciBXaW5kb3dzIHN5c3RlbXMuYCk7XG4gICAgfVxuXG4gICAgZm9yIChjb25zdCBoYW5kbGUgb2YgdGhpcy5vcHRpb25zLnNlcnZpY2VSZXN0YXJ0SGFuZGxlcyA/PyBbXSkge1xuICAgICAgaGFuZGxlLl9hZGRDb21tYW5kKGNvbW1hbmRLZXkpO1xuICAgIH1cblxuICAgIHJldHVybiB7XG4gICAgICBjb25maWc6IHtcbiAgICAgICAgW2NvbW1hbmRLZXldOiB7XG4gICAgICAgICAgY29tbWFuZDogdGhpcy5jb21tYW5kLFxuICAgICAgICAgIGVudjogdGhpcy5vcHRpb25zLmVudixcbiAgICAgICAgICBjd2Q6IHRoaXMub3B0aW9ucy5jd2QsXG4gICAgICAgICAgdGVzdDogdGhpcy5vcHRpb25zLnRlc3RDbWQsXG4gICAgICAgICAgaWdub3JlRXJyb3JzOiB0aGlzLm9wdGlvbnMuaWdub3JlRXJyb3JzLFxuICAgICAgICAgIHdhaXRBZnRlckNvbXBsZXRpb246IHRoaXMub3B0aW9ucy53YWl0QWZ0ZXJDb21wbGV0aW9uPy5fcmVuZGVyKCksXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH07XG4gIH1cblxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEluaXRGaWxlT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBncm91cD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBvd25lcj86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1vZGU/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGJhc2U2NEVuY29kZWQ/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc2VydmljZVJlc3RhcnRIYW5kbGVzPzogSW5pdFNlcnZpY2VSZXN0YXJ0SGFuZGxlW107XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBJbml0RmlsZUFzc2V0T3B0aW9ucyBleHRlbmRzIEluaXRGaWxlT3B0aW9ucywgczNfYXNzZXRzLkFzc2V0T3B0aW9ucyB7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgSW5pdEZpbGUgZXh0ZW5kcyBJbml0RWxlbWVudCB7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGZyb21TdHJpbmcoZmlsZU5hbWU6IHN0cmluZywgY29udGVudDogc3RyaW5nLCBvcHRpb25zOiBJbml0RmlsZU9wdGlvbnMgPSB7fSk6IEluaXRGaWxlIHtcbiAgICBpZiAoIWNvbnRlbnQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgSW5pdEZpbGUgJHtmaWxlTmFtZX06IGNhbm5vdCBjcmVhdGUgZW1wdHkgZmlsZS4gUGxlYXNlIHN1cHBseSBhdCBsZWFzdCBvbmUgY2hhcmFjdGVyIG9mIGNvbnRlbnQuYCk7XG4gICAgfVxuICAgIHJldHVybiBuZXcgY2xhc3MgZXh0ZW5kcyBJbml0RmlsZSB7XG4gICAgICBwcm90ZWN0ZWQgX2RvQmluZChiaW5kT3B0aW9uczogSW5pdEJpbmRPcHRpb25zKSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgY29uZmlnOiB0aGlzLl9zdGFuZGFyZENvbmZpZyhvcHRpb25zLCBiaW5kT3B0aW9ucy5wbGF0Zm9ybSwge1xuICAgICAgICAgICAgY29udGVudCxcbiAgICAgICAgICAgIGVuY29kaW5nOiB0aGlzLm9wdGlvbnMuYmFzZTY0RW5jb2RlZCA/ICdiYXNlNjQnIDogJ3BsYWluJyxcbiAgICAgICAgICB9KSxcbiAgICAgICAgfTtcbiAgICAgIH1cbiAgICB9KGZpbGVOYW1lLCBvcHRpb25zKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHN5bWxpbmsoZmlsZU5hbWU6IHN0cmluZywgdGFyZ2V0OiBzdHJpbmcsIG9wdGlvbnM6IEluaXRGaWxlT3B0aW9ucyA9IHt9KTogSW5pdEZpbGUge1xuICAgIGNvbnN0IHsgbW9kZSwgLi4ub3RoZXJPcHRpb25zIH0gPSBvcHRpb25zO1xuICAgIGlmIChtb2RlICYmIG1vZGUuc2xpY2UoMCwgMykgIT09ICcxMjAnKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0ZpbGUgbW9kZSBmb3Igc3ltbGlua3MgbXVzdCBiZWdpbiB3aXRoIDEyMFhYWCcpO1xuICAgIH1cbiAgICByZXR1cm4gSW5pdEZpbGUuZnJvbVN0cmluZyhmaWxlTmFtZSwgdGFyZ2V0LCB7IG1vZGU6IChtb2RlIHx8ICcxMjA2NDQnKSwgLi4ub3RoZXJPcHRpb25zIH0pO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBmcm9tT2JqZWN0KGZpbGVOYW1lOiBzdHJpbmcsIG9iajogUmVjb3JkPHN0cmluZywgYW55Piwgb3B0aW9uczogSW5pdEZpbGVPcHRpb25zID0ge30pOiBJbml0RmlsZSB7XG4gICAgcmV0dXJuIG5ldyBjbGFzcyBleHRlbmRzIEluaXRGaWxlIHtcbiAgICAgIHByb3RlY3RlZCBfZG9CaW5kKGJpbmRPcHRpb25zOiBJbml0QmluZE9wdGlvbnMpIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICBjb25maWc6IHRoaXMuX3N0YW5kYXJkQ29uZmlnKG9wdGlvbnMsIGJpbmRPcHRpb25zLnBsYXRmb3JtLCB7XG4gICAgICAgICAgICBjb250ZW50OiBvYmosXG4gICAgICAgICAgfSksXG4gICAgICAgIH07XG4gICAgICB9XG4gICAgfShmaWxlTmFtZSwgb3B0aW9ucyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUZpbGVJbmxpbmUodGFyZ2V0RmlsZU5hbWU6IHN0cmluZywgc291cmNlRmlsZU5hbWU6IHN0cmluZywgb3B0aW9uczogSW5pdEZpbGVPcHRpb25zID0ge30pOiBJbml0RmlsZSB7XG4gICAgY29uc3QgZW5jb2RpbmcgPSBvcHRpb25zLmJhc2U2NEVuY29kZWQgPyAnYmFzZTY0JyA6ICd1dGY4JztcbiAgICBjb25zdCBmaWxlQ29udGVudHMgPSBmcy5yZWFkRmlsZVN5bmMoc291cmNlRmlsZU5hbWUpLnRvU3RyaW5nKGVuY29kaW5nKTtcbiAgICByZXR1cm4gSW5pdEZpbGUuZnJvbVN0cmluZyh0YXJnZXRGaWxlTmFtZSwgZmlsZUNvbnRlbnRzLCBvcHRpb25zKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVVybChmaWxlTmFtZTogc3RyaW5nLCB1cmw6IHN0cmluZywgb3B0aW9uczogSW5pdEZpbGVPcHRpb25zID0ge30pOiBJbml0RmlsZSB7XG4gICAgcmV0dXJuIG5ldyBjbGFzcyBleHRlbmRzIEluaXRGaWxlIHtcbiAgICAgIHByb3RlY3RlZCBfZG9CaW5kKGJpbmRPcHRpb25zOiBJbml0QmluZE9wdGlvbnMpIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICBjb25maWc6IHRoaXMuX3N0YW5kYXJkQ29uZmlnKG9wdGlvbnMsIGJpbmRPcHRpb25zLnBsYXRmb3JtLCB7XG4gICAgICAgICAgICBzb3VyY2U6IHVybCxcbiAgICAgICAgICB9KSxcbiAgICAgICAgfTtcbiAgICAgIH1cbiAgICB9KGZpbGVOYW1lLCBvcHRpb25zKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBmcm9tUzNPYmplY3QoZmlsZU5hbWU6IHN0cmluZywgYnVja2V0OiBzMy5JQnVja2V0LCBrZXk6IHN0cmluZywgb3B0aW9uczogSW5pdEZpbGVPcHRpb25zID0ge30pOiBJbml0RmlsZSB7XG4gICAgcmV0dXJuIG5ldyBjbGFzcyBleHRlbmRzIEluaXRGaWxlIHtcbiAgICAgIHByb3RlY3RlZCBfZG9CaW5kKGJpbmRPcHRpb25zOiBJbml0QmluZE9wdGlvbnMpIHtcbiAgICAgICAgYnVja2V0LmdyYW50UmVhZChiaW5kT3B0aW9ucy5pbnN0YW5jZVJvbGUsIGtleSk7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgY29uZmlnOiB0aGlzLl9zdGFuZGFyZENvbmZpZyhvcHRpb25zLCBiaW5kT3B0aW9ucy5wbGF0Zm9ybSwge1xuICAgICAgICAgICAgc291cmNlOiBidWNrZXQudXJsRm9yT2JqZWN0KGtleSksXG4gICAgICAgICAgfSksXG4gICAgICAgICAgYXV0aGVudGljYXRpb246IHN0YW5kYXJkUzNBdXRoKGJpbmRPcHRpb25zLmluc3RhbmNlUm9sZSwgYnVja2V0LmJ1Y2tldE5hbWUpLFxuICAgICAgICB9O1xuICAgICAgfVxuICAgIH0oZmlsZU5hbWUsIG9wdGlvbnMpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBmcm9tQXNzZXQodGFyZ2V0RmlsZU5hbWU6IHN0cmluZywgcGF0aDogc3RyaW5nLCBvcHRpb25zOiBJbml0RmlsZUFzc2V0T3B0aW9ucyA9IHt9KTogSW5pdEZpbGUge1xuICAgIHJldHVybiBuZXcgY2xhc3MgZXh0ZW5kcyBJbml0RmlsZSB7XG4gICAgICBwcm90ZWN0ZWQgX2RvQmluZChiaW5kT3B0aW9uczogSW5pdEJpbmRPcHRpb25zKSB7XG4gICAgICAgIGNvbnN0IGFzc2V0ID0gbmV3IHMzX2Fzc2V0cy5Bc3NldChiaW5kT3B0aW9ucy5zY29wZSwgYCR7dGFyZ2V0RmlsZU5hbWV9QXNzZXRgLCB7XG4gICAgICAgICAgcGF0aCxcbiAgICAgICAgICAuLi5vcHRpb25zLFxuICAgICAgICB9KTtcbiAgICAgICAgYXNzZXQuZ3JhbnRSZWFkKGJpbmRPcHRpb25zLmluc3RhbmNlUm9sZSk7XG5cbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICBjb25maWc6IHRoaXMuX3N0YW5kYXJkQ29uZmlnKG9wdGlvbnMsIGJpbmRPcHRpb25zLnBsYXRmb3JtLCB7XG4gICAgICAgICAgICBzb3VyY2U6IGFzc2V0Lmh0dHBVcmwsXG4gICAgICAgICAgfSksXG4gICAgICAgICAgYXV0aGVudGljYXRpb246IHN0YW5kYXJkUzNBdXRoKGJpbmRPcHRpb25zLmluc3RhbmNlUm9sZSwgYXNzZXQuczNCdWNrZXROYW1lKSxcbiAgICAgICAgICBhc3NldEhhc2g6IGFzc2V0LmFzc2V0SGFzaCxcbiAgICAgICAgfTtcbiAgICAgIH1cbiAgICB9KHRhcmdldEZpbGVOYW1lLCBvcHRpb25zKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBmcm9tRXhpc3RpbmdBc3NldCh0YXJnZXRGaWxlTmFtZTogc3RyaW5nLCBhc3NldDogczNfYXNzZXRzLkFzc2V0LCBvcHRpb25zOiBJbml0RmlsZU9wdGlvbnMgPSB7fSk6IEluaXRGaWxlIHtcbiAgICByZXR1cm4gbmV3IGNsYXNzIGV4dGVuZHMgSW5pdEZpbGUge1xuICAgICAgcHJvdGVjdGVkIF9kb0JpbmQoYmluZE9wdGlvbnM6IEluaXRCaW5kT3B0aW9ucykge1xuICAgICAgICBhc3NldC5ncmFudFJlYWQoYmluZE9wdGlvbnMuaW5zdGFuY2VSb2xlKTtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICBjb25maWc6IHRoaXMuX3N0YW5kYXJkQ29uZmlnKG9wdGlvbnMsIGJpbmRPcHRpb25zLnBsYXRmb3JtLCB7XG4gICAgICAgICAgICBzb3VyY2U6IGFzc2V0Lmh0dHBVcmwsXG4gICAgICAgICAgfSksXG4gICAgICAgICAgYXV0aGVudGljYXRpb246IHN0YW5kYXJkUzNBdXRoKGJpbmRPcHRpb25zLmluc3RhbmNlUm9sZSwgYXNzZXQuczNCdWNrZXROYW1lKSxcbiAgICAgICAgICBhc3NldEhhc2g6IGFzc2V0LmFzc2V0SGFzaCxcbiAgICAgICAgfTtcbiAgICAgIH1cbiAgICB9KHRhcmdldEZpbGVOYW1lLCBvcHRpb25zKTtcbiAgfVxuXG4gIHB1YmxpYyByZWFkb25seSBlbGVtZW50VHlwZSA9IEluaXRFbGVtZW50VHlwZS5GSUxFLnRvU3RyaW5nKCk7XG5cbiAgcHJvdGVjdGVkIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgZmlsZU5hbWU6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBvcHRpb25zOiBJbml0RmlsZU9wdGlvbnMpIHtcbiAgICBzdXBlcigpO1xuICB9XG5cbiAgLyoqIEBpbnRlcm5hbCAqL1xuICBwdWJsaWMgX2JpbmQoYmluZE9wdGlvbnM6IEluaXRCaW5kT3B0aW9ucyk6IEluaXRFbGVtZW50Q29uZmlnIHtcbiAgICBmb3IgKGNvbnN0IGhhbmRsZSBvZiB0aGlzLm9wdGlvbnMuc2VydmljZVJlc3RhcnRIYW5kbGVzID8/IFtdKSB7XG4gICAgICBoYW5kbGUuX2FkZEZpbGUodGhpcy5maWxlTmFtZSk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMuX2RvQmluZChiaW5kT3B0aW9ucyk7XG4gIH1cblxuICAvKipcbiAgICogUGVyZm9ybSB0aGUgYWN0dWFsIGJpbmQgYW5kIHJlbmRlclxuICAgKlxuICAgKiBUaGlzIGlzIGluIGEgc2Vjb25kIG1ldGhvZCBzbyB0aGUgc3VwZXJjbGFzcyBjYW4gZ3VhcmFudGVlIHRoYXRcbiAgICogdGhlIGNvbW1vbiB3b3JrIG9mIHJlZ2lzdGVyaW5nIGludG8gc2VydmljZUhhbmRsZXMgY2Fubm90IGJlIGZvcmdvdHRlbi5cbiAgICogQGludGVybmFsXG4gICAqL1xuICBwcm90ZWN0ZWQgYWJzdHJhY3QgX2RvQmluZChvcHRpb25zOiBJbml0QmluZE9wdGlvbnMpOiBJbml0RWxlbWVudENvbmZpZztcblxuICAvKipcbiAgICogUmVuZGVyIHRoZSBzdGFuZGFyZCBjb25maWcgYmxvY2ssIGdpdmVuIGNvbnRlbnQgdmFyc1xuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHByb3RlY3RlZCBfc3RhbmRhcmRDb25maWcoZmlsZU9wdGlvbnM6IEluaXRGaWxlT3B0aW9ucywgcGxhdGZvcm06IEluaXRQbGF0Zm9ybSwgY29udGVudFZhcnM6IFJlY29yZDxzdHJpbmcsIGFueT4pOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHtcbiAgICBpZiAocGxhdGZvcm0gPT09IEluaXRQbGF0Zm9ybS5XSU5ET1dTKSB7XG4gICAgICBpZiAoZmlsZU9wdGlvbnMuZ3JvdXAgfHwgZmlsZU9wdGlvbnMub3duZXIgfHwgZmlsZU9wdGlvbnMubW9kZSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ093bmVyLCBncm91cCwgYW5kIG1vZGUgb3B0aW9ucyBub3Qgc3VwcG9ydGVkIGZvciBXaW5kb3dzLicpO1xuICAgICAgfVxuICAgICAgcmV0dXJuIHtcbiAgICAgICAgW3RoaXMuZmlsZU5hbWVdOiB7IC4uLmNvbnRlbnRWYXJzIH0sXG4gICAgICB9O1xuICAgIH1cblxuICAgIHJldHVybiB7XG4gICAgICBbdGhpcy5maWxlTmFtZV06IHtcbiAgICAgICAgLi4uY29udGVudFZhcnMsXG4gICAgICAgIG1vZGU6IGZpbGVPcHRpb25zLm1vZGUgfHwgJzAwMDY0NCcsXG4gICAgICAgIG93bmVyOiBmaWxlT3B0aW9ucy5vd25lciB8fCAncm9vdCcsXG4gICAgICAgIGdyb3VwOiBmaWxlT3B0aW9ucy5ncm91cCB8fCAncm9vdCcsXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBJbml0R3JvdXAgZXh0ZW5kcyBJbml0RWxlbWVudCB7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZnJvbU5hbWUoZ3JvdXBOYW1lOiBzdHJpbmcsIGdyb3VwSWQ/OiBudW1iZXIpOiBJbml0R3JvdXAge1xuICAgIHJldHVybiBuZXcgSW5pdEdyb3VwKGdyb3VwTmFtZSwgZ3JvdXBJZCk7XG4gIH1cblxuICBwdWJsaWMgcmVhZG9ubHkgZWxlbWVudFR5cGUgPSBJbml0RWxlbWVudFR5cGUuR1JPVVAudG9TdHJpbmcoKTtcblxuICBwcm90ZWN0ZWQgY29uc3RydWN0b3IocHJpdmF0ZSBncm91cE5hbWU6IHN0cmluZywgcHJpdmF0ZSBncm91cElkPzogbnVtYmVyKSB7XG4gICAgc3VwZXIoKTtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgcHVibGljIF9iaW5kKG9wdGlvbnM6IEluaXRCaW5kT3B0aW9ucyk6IEluaXRFbGVtZW50Q29uZmlnIHtcbiAgICBpZiAob3B0aW9ucy5wbGF0Zm9ybSA9PT0gSW5pdFBsYXRmb3JtLldJTkRPV1MpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignSW5pdCBncm91cHMgYXJlIG5vdCBzdXBwb3J0ZWQgb24gV2luZG93cycpO1xuICAgIH1cblxuICAgIHJldHVybiB7XG4gICAgICBjb25maWc6IHtcbiAgICAgICAgW3RoaXMuZ3JvdXBOYW1lXTogdGhpcy5ncm91cElkICE9PSB1bmRlZmluZWQgPyB7IGdpZDogdGhpcy5ncm91cElkIH0gOiB7fSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxuXG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEluaXRVc2VyT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaG9tZURpcj86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHVzZXJJZD86IG51bWJlcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZ3JvdXBzPzogc3RyaW5nW107XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEluaXRVc2VyIGV4dGVuZHMgSW5pdEVsZW1lbnQge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGZyb21OYW1lKHVzZXJOYW1lOiBzdHJpbmcsIG9wdGlvbnM6IEluaXRVc2VyT3B0aW9ucyA9IHt9KTogSW5pdFVzZXIge1xuICAgIHJldHVybiBuZXcgSW5pdFVzZXIodXNlck5hbWUsIG9wdGlvbnMpO1xuICB9XG5cbiAgcHVibGljIHJlYWRvbmx5IGVsZW1lbnRUeXBlID0gSW5pdEVsZW1lbnRUeXBlLlVTRVIudG9TdHJpbmcoKTtcblxuICBwcm90ZWN0ZWQgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSB1c2VyTmFtZTogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHVzZXJPcHRpb25zOiBJbml0VXNlck9wdGlvbnMpIHtcbiAgICBzdXBlcigpO1xuICB9XG5cbiAgLyoqIEBpbnRlcm5hbCAqL1xuICBwdWJsaWMgX2JpbmQob3B0aW9uczogSW5pdEJpbmRPcHRpb25zKTogSW5pdEVsZW1lbnRDb25maWcge1xuICAgIGlmIChvcHRpb25zLnBsYXRmb3JtID09PSBJbml0UGxhdGZvcm0uV0lORE9XUykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdJbml0IHVzZXJzIGFyZSBub3Qgc3VwcG9ydGVkIG9uIFdpbmRvd3MnKTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgY29uZmlnOiB7XG4gICAgICAgIFt0aGlzLnVzZXJOYW1lXToge1xuICAgICAgICAgIHVpZDogdGhpcy51c2VyT3B0aW9ucy51c2VySWQsXG4gICAgICAgICAgZ3JvdXBzOiB0aGlzLnVzZXJPcHRpb25zLmdyb3VwcyxcbiAgICAgICAgICBob21lRGlyOiB0aGlzLnVzZXJPcHRpb25zLmhvbWVEaXIsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIExvY2F0aW9uUGFja2FnZU9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGtleT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNlcnZpY2VSZXN0YXJ0SGFuZGxlcz86IEluaXRTZXJ2aWNlUmVzdGFydEhhbmRsZVtdO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgTmFtZWRQYWNrYWdlT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdmVyc2lvbj86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNlcnZpY2VSZXN0YXJ0SGFuZGxlcz86IEluaXRTZXJ2aWNlUmVzdGFydEhhbmRsZVtdO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBJbml0UGFja2FnZSBleHRlbmRzIEluaXRFbGVtZW50IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBycG0obG9jYXRpb246IHN0cmluZywgb3B0aW9uczogTG9jYXRpb25QYWNrYWdlT3B0aW9ucyA9IHt9KTogSW5pdFBhY2thZ2Uge1xuICAgIHJldHVybiBuZXcgSW5pdFBhY2thZ2UoJ3JwbScsIFtsb2NhdGlvbl0sIG9wdGlvbnMua2V5LCBvcHRpb25zLnNlcnZpY2VSZXN0YXJ0SGFuZGxlcyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyB5dW0ocGFja2FnZU5hbWU6IHN0cmluZywgb3B0aW9uczogTmFtZWRQYWNrYWdlT3B0aW9ucyA9IHt9KTogSW5pdFBhY2thZ2Uge1xuICAgIHJldHVybiBuZXcgSW5pdFBhY2thZ2UoJ3l1bScsIG9wdGlvbnMudmVyc2lvbiA/PyBbXSwgcGFja2FnZU5hbWUsIG9wdGlvbnMuc2VydmljZVJlc3RhcnRIYW5kbGVzKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBydWJ5R2VtKGdlbU5hbWU6IHN0cmluZywgb3B0aW9uczogTmFtZWRQYWNrYWdlT3B0aW9ucyA9IHt9KTogSW5pdFBhY2thZ2Uge1xuICAgIHJldHVybiBuZXcgSW5pdFBhY2thZ2UoJ3J1YnlnZW1zJywgb3B0aW9ucy52ZXJzaW9uID8/IFtdLCBnZW1OYW1lLCBvcHRpb25zLnNlcnZpY2VSZXN0YXJ0SGFuZGxlcyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBweXRob24ocGFja2FnZU5hbWU6IHN0cmluZywgb3B0aW9uczogTmFtZWRQYWNrYWdlT3B0aW9ucyA9IHt9KTogSW5pdFBhY2thZ2Uge1xuICAgIHJldHVybiBuZXcgSW5pdFBhY2thZ2UoJ3B5dGhvbicsIG9wdGlvbnMudmVyc2lvbiA/PyBbXSwgcGFja2FnZU5hbWUsIG9wdGlvbnMuc2VydmljZVJlc3RhcnRIYW5kbGVzKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGFwdChwYWNrYWdlTmFtZTogc3RyaW5nLCBvcHRpb25zOiBOYW1lZFBhY2thZ2VPcHRpb25zID0ge30pOiBJbml0UGFja2FnZSB7XG4gICAgcmV0dXJuIG5ldyBJbml0UGFja2FnZSgnYXB0Jywgb3B0aW9ucy52ZXJzaW9uID8/IFtdLCBwYWNrYWdlTmFtZSwgb3B0aW9ucy5zZXJ2aWNlUmVzdGFydEhhbmRsZXMpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIG1zaShsb2NhdGlvbjogc3RyaW5nLCBvcHRpb25zOiBMb2NhdGlvblBhY2thZ2VPcHRpb25zID0ge30pOiBJbml0UGFja2FnZSB7XG4gICAgLy8gVGhlIE1TSSBwYWNrYWdlIHZlcnNpb24gbXVzdCBiZSBhIHN0cmluZywgbm90IGFuIGFycmF5LlxuICAgIHJldHVybiBuZXcgY2xhc3MgZXh0ZW5kcyBJbml0UGFja2FnZSB7XG4gICAgICBwcm90ZWN0ZWQgcmVuZGVyUGFja2FnZVZlcnNpb25zKCkgeyByZXR1cm4gbG9jYXRpb247IH1cbiAgICB9KCdtc2knLCBbbG9jYXRpb25dLCBvcHRpb25zLmtleSwgb3B0aW9ucy5zZXJ2aWNlUmVzdGFydEhhbmRsZXMpO1xuICB9XG5cbiAgcHVibGljIHJlYWRvbmx5IGVsZW1lbnRUeXBlID0gSW5pdEVsZW1lbnRUeXBlLlBBQ0tBR0UudG9TdHJpbmcoKTtcblxuICBwcm90ZWN0ZWQgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSByZWFkb25seSB0eXBlOiBzdHJpbmcsXG4gICAgcHJpdmF0ZSByZWFkb25seSB2ZXJzaW9uczogc3RyaW5nW10sXG4gICAgcHJpdmF0ZSByZWFkb25seSBwYWNrYWdlTmFtZT86IHN0cmluZyxcbiAgICBwcml2YXRlIHJlYWRvbmx5IHNlcnZpY2VIYW5kbGVzPzogSW5pdFNlcnZpY2VSZXN0YXJ0SGFuZGxlW10sXG4gICkge1xuICAgIHN1cGVyKCk7XG4gIH1cblxuICAvKiogQGludGVybmFsICovXG4gIHB1YmxpYyBfYmluZChvcHRpb25zOiBJbml0QmluZE9wdGlvbnMpOiBJbml0RWxlbWVudENvbmZpZyB7XG4gICAgaWYgKCh0aGlzLnR5cGUgPT09ICdtc2knKSAhPT0gKG9wdGlvbnMucGxhdGZvcm0gPT09IEluaXRQbGF0Zm9ybS5XSU5ET1dTKSkge1xuICAgICAgaWYgKHRoaXMudHlwZSA9PT0gJ21zaScpIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdNU0kgaW5zdGFsbGVycyBhcmUgb25seSBzdXBwb3J0ZWQgb24gV2luZG93cyBzeXN0ZW1zLicpO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdXaW5kb3dzIG9ubHkgc3VwcG9ydHMgdGhlIE1TSSBwYWNrYWdlIHR5cGUnKTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBpZiAoIXRoaXMucGFja2FnZU5hbWUgJiYgIVsncnBtJywgJ21zaSddLmluY2x1ZGVzKHRoaXMudHlwZSkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignUGFja2FnZSBuYW1lIG11c3QgYmUgc3BlY2lmaWVkIGZvciBhbGwgcGFja2FnZSB0eXBlcyBiZXNpZGVzIFJQTSBhbmQgTVNJLicpO1xuICAgIH1cblxuICAgIGNvbnN0IHBhY2thZ2VOYW1lID0gdGhpcy5wYWNrYWdlTmFtZSB8fCBgJHtvcHRpb25zLmluZGV4fWAucGFkU3RhcnQoMywgJzAnKTtcblxuICAgIGZvciAoY29uc3QgaGFuZGxlIG9mIHRoaXMuc2VydmljZUhhbmRsZXMgPz8gW10pIHtcbiAgICAgIGhhbmRsZS5fYWRkUGFja2FnZSh0aGlzLnR5cGUsIHBhY2thZ2VOYW1lKTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgY29uZmlnOiB7XG4gICAgICAgIFt0aGlzLnR5cGVdOiB7XG4gICAgICAgICAgW3BhY2thZ2VOYW1lXTogdGhpcy5yZW5kZXJQYWNrYWdlVmVyc2lvbnMoKSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxuXG4gIHByb3RlY3RlZCByZW5kZXJQYWNrYWdlVmVyc2lvbnMoKTogYW55IHtcbiAgICByZXR1cm4gdGhpcy52ZXJzaW9ucztcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEluaXRTZXJ2aWNlT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBlbmFibGVkPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZW5zdXJlUnVubmluZz86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzZXJ2aWNlUmVzdGFydEhhbmRsZT86IEluaXRTZXJ2aWNlUmVzdGFydEhhbmRsZTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEluaXRTZXJ2aWNlIGV4dGVuZHMgSW5pdEVsZW1lbnQge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBlbmFibGUoc2VydmljZU5hbWU6IHN0cmluZywgb3B0aW9uczogSW5pdFNlcnZpY2VPcHRpb25zID0ge30pOiBJbml0U2VydmljZSB7XG4gICAgY29uc3QgeyBlbmFibGVkLCBlbnN1cmVSdW5uaW5nLCAuLi5vdGhlck9wdGlvbnMgfSA9IG9wdGlvbnM7XG4gICAgcmV0dXJuIG5ldyBJbml0U2VydmljZShzZXJ2aWNlTmFtZSwge1xuICAgICAgZW5hYmxlZDogZW5hYmxlZCA/PyB0cnVlLFxuICAgICAgZW5zdXJlUnVubmluZzogZW5zdXJlUnVubmluZyA/PyBlbmFibGVkID8/IHRydWUsXG4gICAgICAuLi5vdGhlck9wdGlvbnMsXG4gICAgfSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZGlzYWJsZShzZXJ2aWNlTmFtZTogc3RyaW5nKTogSW5pdFNlcnZpY2Uge1xuICAgIHJldHVybiBuZXcgSW5pdFNlcnZpY2Uoc2VydmljZU5hbWUsIHsgZW5hYmxlZDogZmFsc2UsIGVuc3VyZVJ1bm5pbmc6IGZhbHNlIH0pO1xuICB9XG5cbiAgcHVibGljIHJlYWRvbmx5IGVsZW1lbnRUeXBlID0gSW5pdEVsZW1lbnRUeXBlLlNFUlZJQ0UudG9TdHJpbmcoKTtcblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgc2VydmljZU5hbWU6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBzZXJ2aWNlT3B0aW9uczogSW5pdFNlcnZpY2VPcHRpb25zKSB7XG4gICAgc3VwZXIoKTtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgcHVibGljIF9iaW5kKG9wdGlvbnM6IEluaXRCaW5kT3B0aW9ucyk6IEluaXRFbGVtZW50Q29uZmlnIHtcbiAgICBjb25zdCBzZXJ2aWNlTWFuYWdlciA9IG9wdGlvbnMucGxhdGZvcm0gPT09IEluaXRQbGF0Zm9ybS5MSU5VWCA/ICdzeXN2aW5pdCcgOiAnd2luZG93cyc7XG5cbiAgICByZXR1cm4ge1xuICAgICAgY29uZmlnOiB7XG4gICAgICAgIFtzZXJ2aWNlTWFuYWdlcl06IHtcbiAgICAgICAgICBbdGhpcy5zZXJ2aWNlTmFtZV06IHtcbiAgICAgICAgICAgIGVuYWJsZWQ6IHRoaXMuc2VydmljZU9wdGlvbnMuZW5hYmxlZCxcbiAgICAgICAgICAgIGVuc3VyZVJ1bm5pbmc6IHRoaXMuc2VydmljZU9wdGlvbnMuZW5zdXJlUnVubmluZyxcbiAgICAgICAgICAgIC4uLnRoaXMuc2VydmljZU9wdGlvbnMuc2VydmljZVJlc3RhcnRIYW5kbGU/Ll9yZW5kZXJSZXN0YXJ0SGFuZGxlcygpLFxuICAgICAgICAgIH0sXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH07XG4gIH1cblxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBJbml0U291cmNlT3B0aW9ucyB7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzZXJ2aWNlUmVzdGFydEhhbmRsZXM/OiBJbml0U2VydmljZVJlc3RhcnRIYW5kbGVbXTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSW5pdFNvdXJjZUFzc2V0T3B0aW9ucyBleHRlbmRzIEluaXRTb3VyY2VPcHRpb25zLCBzM19hc3NldHMuQXNzZXRPcHRpb25zIHtcblxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgSW5pdFNvdXJjZSBleHRlbmRzIEluaXRFbGVtZW50IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVVybCh0YXJnZXREaXJlY3Rvcnk6IHN0cmluZywgdXJsOiBzdHJpbmcsIG9wdGlvbnM6IEluaXRTb3VyY2VPcHRpb25zID0ge30pOiBJbml0U291cmNlIHtcbiAgICByZXR1cm4gbmV3IGNsYXNzIGV4dGVuZHMgSW5pdFNvdXJjZSB7XG4gICAgICBwcm90ZWN0ZWQgX2RvQmluZCgpIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICBjb25maWc6IHsgW3RoaXMudGFyZ2V0RGlyZWN0b3J5XTogdXJsIH0sXG4gICAgICAgIH07XG4gICAgICB9XG4gICAgfSh0YXJnZXREaXJlY3RvcnksIG9wdGlvbnMuc2VydmljZVJlc3RhcnRIYW5kbGVzKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBmcm9tR2l0SHViKHRhcmdldERpcmVjdG9yeTogc3RyaW5nLCBvd25lcjogc3RyaW5nLCByZXBvOiBzdHJpbmcsIHJlZlNwZWM/OiBzdHJpbmcsIG9wdGlvbnM6IEluaXRTb3VyY2VPcHRpb25zID0ge30pOiBJbml0U291cmNlIHtcbiAgICByZXR1cm4gSW5pdFNvdXJjZS5mcm9tVXJsKHRhcmdldERpcmVjdG9yeSwgYGh0dHBzOi8vZ2l0aHViLmNvbS8ke293bmVyfS8ke3JlcG99L3RhcmJhbGwvJHtyZWZTcGVjID8/ICdtYXN0ZXInfWAsIG9wdGlvbnMpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVMzT2JqZWN0KHRhcmdldERpcmVjdG9yeTogc3RyaW5nLCBidWNrZXQ6IHMzLklCdWNrZXQsIGtleTogc3RyaW5nLCBvcHRpb25zOiBJbml0U291cmNlT3B0aW9ucyA9IHt9KTogSW5pdFNvdXJjZSB7XG4gICAgcmV0dXJuIG5ldyBjbGFzcyBleHRlbmRzIEluaXRTb3VyY2Uge1xuICAgICAgcHJvdGVjdGVkIF9kb0JpbmQoYmluZE9wdGlvbnM6IEluaXRCaW5kT3B0aW9ucykge1xuICAgICAgICBidWNrZXQuZ3JhbnRSZWFkKGJpbmRPcHRpb25zLmluc3RhbmNlUm9sZSwga2V5KTtcblxuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgIGNvbmZpZzogeyBbdGhpcy50YXJnZXREaXJlY3RvcnldOiBidWNrZXQudXJsRm9yT2JqZWN0KGtleSkgfSxcbiAgICAgICAgICBhdXRoZW50aWNhdGlvbjogc3RhbmRhcmRTM0F1dGgoYmluZE9wdGlvbnMuaW5zdGFuY2VSb2xlLCBidWNrZXQuYnVja2V0TmFtZSksXG4gICAgICAgIH07XG4gICAgICB9XG4gICAgfSh0YXJnZXREaXJlY3RvcnksIG9wdGlvbnMuc2VydmljZVJlc3RhcnRIYW5kbGVzKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGZyb21Bc3NldCh0YXJnZXREaXJlY3Rvcnk6IHN0cmluZywgcGF0aDogc3RyaW5nLCBvcHRpb25zOiBJbml0U291cmNlQXNzZXRPcHRpb25zID0ge30pOiBJbml0U291cmNlIHtcbiAgICByZXR1cm4gbmV3IGNsYXNzIGV4dGVuZHMgSW5pdFNvdXJjZSB7XG4gICAgICBwcm90ZWN0ZWQgX2RvQmluZChiaW5kT3B0aW9uczogSW5pdEJpbmRPcHRpb25zKSB7XG4gICAgICAgIGNvbnN0IGFzc2V0ID0gbmV3IHMzX2Fzc2V0cy5Bc3NldChiaW5kT3B0aW9ucy5zY29wZSwgYCR7dGFyZ2V0RGlyZWN0b3J5fUFzc2V0YCwge1xuICAgICAgICAgIHBhdGgsXG4gICAgICAgICAgLi4uYmluZE9wdGlvbnMsXG4gICAgICAgIH0pO1xuICAgICAgICBhc3NldC5ncmFudFJlYWQoYmluZE9wdGlvbnMuaW5zdGFuY2VSb2xlKTtcblxuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgIGNvbmZpZzogeyBbdGhpcy50YXJnZXREaXJlY3RvcnldOiBhc3NldC5odHRwVXJsIH0sXG4gICAgICAgICAgYXV0aGVudGljYXRpb246IHN0YW5kYXJkUzNBdXRoKGJpbmRPcHRpb25zLmluc3RhbmNlUm9sZSwgYXNzZXQuczNCdWNrZXROYW1lKSxcbiAgICAgICAgICBhc3NldEhhc2g6IGFzc2V0LmFzc2V0SGFzaCxcbiAgICAgICAgfTtcbiAgICAgIH1cbiAgICB9KHRhcmdldERpcmVjdG9yeSwgb3B0aW9ucy5zZXJ2aWNlUmVzdGFydEhhbmRsZXMpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBmcm9tRXhpc3RpbmdBc3NldCh0YXJnZXREaXJlY3Rvcnk6IHN0cmluZywgYXNzZXQ6IHMzX2Fzc2V0cy5Bc3NldCwgb3B0aW9uczogSW5pdFNvdXJjZU9wdGlvbnMgPSB7fSk6IEluaXRTb3VyY2Uge1xuICAgIHJldHVybiBuZXcgY2xhc3MgZXh0ZW5kcyBJbml0U291cmNlIHtcbiAgICAgIHByb3RlY3RlZCBfZG9CaW5kKGJpbmRPcHRpb25zOiBJbml0QmluZE9wdGlvbnMpIHtcbiAgICAgICAgYXNzZXQuZ3JhbnRSZWFkKGJpbmRPcHRpb25zLmluc3RhbmNlUm9sZSk7XG5cbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICBjb25maWc6IHsgW3RoaXMudGFyZ2V0RGlyZWN0b3J5XTogYXNzZXQuaHR0cFVybCB9LFxuICAgICAgICAgIGF1dGhlbnRpY2F0aW9uOiBzdGFuZGFyZFMzQXV0aChiaW5kT3B0aW9ucy5pbnN0YW5jZVJvbGUsIGFzc2V0LnMzQnVja2V0TmFtZSksXG4gICAgICAgICAgYXNzZXRIYXNoOiBhc3NldC5hc3NldEhhc2gsXG4gICAgICAgIH07XG4gICAgICB9XG4gICAgfSh0YXJnZXREaXJlY3RvcnksIG9wdGlvbnMuc2VydmljZVJlc3RhcnRIYW5kbGVzKTtcbiAgfVxuXG4gIHB1YmxpYyByZWFkb25seSBlbGVtZW50VHlwZSA9IEluaXRFbGVtZW50VHlwZS5TT1VSQ0UudG9TdHJpbmcoKTtcblxuICBwcm90ZWN0ZWQgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSB0YXJnZXREaXJlY3Rvcnk6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBzZXJ2aWNlSGFuZGxlcz86IEluaXRTZXJ2aWNlUmVzdGFydEhhbmRsZVtdKSB7XG4gICAgc3VwZXIoKTtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgcHVibGljIF9iaW5kKG9wdGlvbnM6IEluaXRCaW5kT3B0aW9ucyk6IEluaXRFbGVtZW50Q29uZmlnIHtcbiAgICBmb3IgKGNvbnN0IGhhbmRsZSBvZiB0aGlzLnNlcnZpY2VIYW5kbGVzID8/IFtdKSB7XG4gICAgICBoYW5kbGUuX2FkZFNvdXJjZSh0aGlzLnRhcmdldERpcmVjdG9yeSk7XG4gICAgfVxuXG4gICAgLy8gRGVsZWdhdGUgYWN0dWFsIGJpbmQgdG8gc3ViY2xhc3Nlc1xuICAgIHJldHVybiB0aGlzLl9kb0JpbmQob3B0aW9ucyk7XG4gIH1cblxuICAvKipcbiAgICogUGVyZm9ybSB0aGUgYWN0dWFsIGJpbmQgYW5kIHJlbmRlclxuICAgKlxuICAgKiBUaGlzIGlzIGluIGEgc2Vjb25kIG1ldGhvZCBzbyB0aGUgc3VwZXJjbGFzcyBjYW4gZ3VhcmFudGVlIHRoYXRcbiAgICogdGhlIGNvbW1vbiB3b3JrIG9mIHJlZ2lzdGVyaW5nIGludG8gc2VydmljZUhhbmRsZXMgY2Fubm90IGJlIGZvcmdvdHRlbi5cbiAgICogQGludGVybmFsXG4gICAqL1xuICBwcm90ZWN0ZWQgYWJzdHJhY3QgX2RvQmluZChvcHRpb25zOiBJbml0QmluZE9wdGlvbnMpOiBJbml0RWxlbWVudENvbmZpZztcbn1cblxuLyoqXG4gKiBSZW5kZXIgYSBzdGFuZGFyZCBTMyBhdXRoIGJsb2NrIGZvciB1c2UgaW4gQVdTOjpDbG91ZEZvcm1hdGlvbjo6QXV0aGVudGljYXRpb25cbiAqXG4gKiBUaGlzIGJsb2NrIGlzIHRoZSBzYW1lIGV2ZXJ5IHRpbWUgKG1vZHVsbyBidWNrZXQgbmFtZSksIHNvIGl0IGhhcyB0aGUgc2FtZVxuICoga2V5IGV2ZXJ5IHRpbWUgc28gdGhlIGJsb2NrcyBhcmUgbWVyZ2VkIGludG8gb25lIGluIHRoZSBmaW5hbCByZW5kZXIuXG4gKi9cbmZ1bmN0aW9uIHN0YW5kYXJkUzNBdXRoKHJvbGU6IGlhbS5JUm9sZSwgYnVja2V0TmFtZTogc3RyaW5nKSB7XG4gIHJldHVybiB7XG4gICAgUzNBY2Nlc3NDcmVkczoge1xuICAgICAgdHlwZTogJ1MzJyxcbiAgICAgIHJvbGVOYW1lOiByb2xlLnJvbGVOYW1lLFxuICAgICAgYnVja2V0czogW2J1Y2tldE5hbWVdLFxuICAgIH0sXG4gIH07XG59XG4iXX0=