# flake8: noqa

"""
    University Human Resources API

     This API exposes identity information from the University Human Resources system. The purpose of this API is to give access to basic identity information about staff members for use by downstream systems, therefore the data exposed is limited to basic information about who a staff member is and details of any affiliations they have.  This API uses the following identifiers to link people to person-records held within different systems:  * `person.v1.human-resources.university.identifiers.cam.ac.uk` - the university human resources (uhr) identifier of     this person - also known as the staff number of HRN. * `v1.person.identifiers.cam.ac.uk` - the common registration scheme identifier (CRSid) of     this person.  Additionally this API uses the following identifiers to link people to institutions or entities which a person may have an affiliation to:  * `institution.v1.human-resources.university.identifiers.cam.ac.uk` - the university human resources (uhr) institution     identifier. This encompasses colleges and departments held within the University HR system     (currently CHRIS).  Affiliations can be used to indicate an institution that a person holds a position within, with the `status` indicating the job role that is held and the scheme of the affiliation being `institution.v1.human-resources.university.identifiers.cam.ac.uk`. Additionally an affiliation can indicate a staff member's line manager with the scheme being `person.v1.human-resources.university.identifiers.cam.ac.uk` and the status being `report`. A staff member can have multiple institution affiliations and multiple report affiliations.  This API is currently backed by data from CHRIS, exposing a view which is updated hourly.    # noqa: E501

    The version of the OpenAPI document: v1alpha2
    Generated by: https://openapi-generator.tech
"""


__version__ = "1.0.0"

# import ApiClient
from identitylib.hr_client.api_client import ApiClient

# import Configuration
from identitylib.hr_client.configuration import Configuration

# import exceptions
from identitylib.hr_client.exceptions import OpenApiException
from identitylib.hr_client.exceptions import ApiAttributeError
from identitylib.hr_client.exceptions import ApiTypeError
from identitylib.hr_client.exceptions import ApiValueError
from identitylib.hr_client.exceptions import ApiKeyError
from identitylib.hr_client.exceptions import ApiException
