from cfinterface.components.block import Block
from typing import IO


class VersaoModelo(Block):
    """
    Bloco para ler a versão utilizada do modelo a partir da linha de
    título do arquivo.
    """

    BEGIN_PATTERN = r"MODELO DESSEM"
    END_PATTERN = ""

    def __eq__(self, o: object) -> bool:
        if not isinstance(o, VersaoModelo):
            return False
        else:
            if not all([type(self.data) == str, type(o.data) == str]):
                return False
            return self.data == o.data

    def read(self, file: IO):
        linha = file.readline()
        self.data = linha.split("VERSAO")[1].split("-")[0].strip()
