# bankid-asyncio 🏦

## Badges 🏷
![GitHub](https://img.shields.io/github/license/Kostiantyn-Salnykov/bankid_asyncio)
![GitHub Workflow Status (branch)](https://img.shields.io/github/workflow/status/Kostiantyn-Salnykov/bankid_asyncio/Python%20package/main)
![GitHub (branch)](https://img.shields.io/badge/branch-main-brightgreen)
![GitHub last commit (branch)](https://img.shields.io/github/last-commit/Kostiantyn-Salnykov/bankid_asyncio/main)
[![codecov](https://codecov.io/gh/Kostiantyn-Salnykov/bankid_asyncio/branch/main/graph/badge.svg?token=F4XO2O9DXY)](https://codecov.io/gh/Kostiantyn-Salnykov/bankid_asyncio)

![PyPI - Python Version](https://img.shields.io/pypi/pyversions/bankid-asyncio)
![PyPI - Format](https://img.shields.io/pypi/format/bankid-asyncio)
![PyPI](https://img.shields.io/pypi/v/bankid-asyncio)
![PyPI - Downloads](https://img.shields.io/pypi/dm/bankid-asyncio)

[![Imports: isort](https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336)](https://pycqa.github.io/isort/)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000?style=flat)](https://github.com/psf/black)

## Dependencies ⛓

[![Pydantic](https://img.shields.io/badge/pydantic-%5E1.10.1-orange)](https://pydantic-docs.helpmanual.io/)
[![HTTPX](https://img.shields.io/badge/httpx-%5E0.23.0-orange)](https://www.python-httpx.org/)

## Description 📖
**bankid-asyncio** - is a BankID client for Python with asyncio support.

Asynchronous realization turned out to be implemented due to the fact that the library is written based on HTTPX, which 
allows not only synchronous requests (**Client**), but also asynchronous ones (**AsyncClient**).

## Install 💾

### pip
```{.terminal linenums="0"}
pip install bankid-asyncio
```

### Poetry
```{.terminal linenums="0"}
poetry add bankid-asyncio
```

## Documentation 🗂 (In progress)
[Documentation🔗](https://kostiantyn-salnykov.github.io/bankid_asyncio/)
