"use strict";
const cdk = require("@aws-cdk/core");
const stepfunctions = require("../lib");
function render(sm) {
    return new cdk.Stack().resolve(new stepfunctions.StateGraph(sm.startState, 'Test Graph').toGraphJson());
}
module.exports = {
    'State Machine With Parallel State'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const parallel = new stepfunctions.Parallel(stack, 'Parallel State');
        parallel.branch(new stepfunctions.Pass(stack, 'Branch 1'));
        parallel.branch(new stepfunctions.Pass(stack, 'Branch 2'));
        // THEN
        test.deepEqual(render(parallel), {
            StartAt: 'Parallel State',
            States: {
                'Parallel State': {
                    Type: 'Parallel',
                    End: true,
                    Branches: [
                        { StartAt: 'Branch 1', States: { 'Branch 1': { Type: 'Pass', End: true } } },
                        { StartAt: 'Branch 2', States: { 'Branch 2': { Type: 'Pass', End: true } } }
                    ]
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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