"use strict";
const lib_1 = require("../lib");
module.exports = {
    'deep replace correctly handles fields in arrays'(test) {
        test.deepEqual(lib_1.FieldUtils.renderObject({
            unknown: undefined,
            bool: true,
            literal: 'literal',
            field: lib_1.Data.stringAt('$.stringField'),
            listField: lib_1.Data.listAt('$.listField'),
            deep: [
                'literal',
                {
                    deepField: lib_1.Data.numberAt('$.numField'),
                }
            ]
        }), {
            'bool': true,
            'literal': 'literal',
            'field.$': '$.stringField',
            'listField.$': '$.listField',
            'deep': [
                'literal',
                {
                    'deepField.$': '$.numField'
                }
            ],
        });
        test.done();
    },
    'exercise contextpaths'(test) {
        test.deepEqual(lib_1.FieldUtils.renderObject({
            str: lib_1.Context.stringAt('$$.Execution.StartTime'),
            count: lib_1.Context.numberAt('$$.State.RetryCount'),
            token: lib_1.Context.taskToken,
            entire: lib_1.Context.entireContext
        }), {
            'str.$': '$$.Execution.StartTime',
            'count.$': '$$.State.RetryCount',
            'token.$': '$$.Task.Token',
            'entire.$': '$$'
        });
        test.done();
    },
    'find all referenced paths'(test) {
        test.deepEqual(lib_1.FieldUtils.findReferencedPaths({
            bool: false,
            literal: 'literal',
            field: lib_1.Data.stringAt('$.stringField'),
            listField: lib_1.Data.listAt('$.listField'),
            deep: [
                'literal',
                {
                    field: lib_1.Data.stringAt('$.stringField'),
                    deepField: lib_1.Data.numberAt('$.numField'),
                }
            ]
        }), [
            '$.listField',
            '$.numField',
            '$.stringField',
        ]);
        test.done();
    },
    'cannot have JsonPath fields in arrays'(test) {
        test.throws(() => {
            lib_1.FieldUtils.renderObject({
                deep: [lib_1.Data.stringAt('$.hello')]
            });
        }, /Cannot use JsonPath fields in an array/);
        test.done();
    },
    'datafield path must be correct'(test) {
        test.ok(lib_1.Data.stringAt('$'));
        test.throws(() => {
            lib_1.Data.stringAt('$hello');
        }, /exactly equal to '\$' or start with '\$.'/);
        test.throws(() => {
            lib_1.Data.stringAt('hello');
        }, /exactly equal to '\$' or start with '\$.'/);
        test.done();
    },
    'context path must be correct'(test) {
        test.ok(lib_1.Context.stringAt('$$'));
        test.throws(() => {
            lib_1.Context.stringAt('$$hello');
        }, /exactly equal to '\$\$' or start with '\$\$.'/);
        test.throws(() => {
            lib_1.Context.stringAt('hello');
        }, /exactly equal to '\$\$' or start with '\$\$.'/);
        test.done();
    },
    'test contains task token'(test) {
        test.equal(true, lib_1.FieldUtils.containsTaskToken({
            field: lib_1.Context.taskToken
        }));
        test.equal(true, lib_1.FieldUtils.containsTaskToken({
            field: lib_1.Context.stringAt('$$.Task'),
        }));
        test.equal(true, lib_1.FieldUtils.containsTaskToken({
            field: lib_1.Context.entireContext
        }));
        test.equal(false, lib_1.FieldUtils.containsTaskToken({
            oops: 'not here'
        }));
        test.equal(false, lib_1.FieldUtils.containsTaskToken({
            oops: lib_1.Context.stringAt('$$.Execution.StartTime')
        }));
        test.done();
    },
    'arbitrary JSONPath fields are not replaced'(test) {
        test.deepEqual(lib_1.FieldUtils.renderObject({
            field: '$.content',
        }), {
            field: '$.content'
        });
        test.done();
    },
    'fields cannot be used somewhere in a string interpolation'(test) {
        test.throws(() => {
            lib_1.FieldUtils.renderObject({
                field: `contains ${lib_1.Data.stringAt('$.hello')}`
            });
        }, /Field references must be the entire string/);
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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