"use strict";
const stepfunctions = require("../lib");
function assertRendersTo(test, cond, expected) {
    test.deepEqual(cond.renderCondition(), expected);
}
module.exports = {
    'Condition variables must start with $. or $['(test) {
        test.throws(() => {
            stepfunctions.Condition.stringEquals('a', 'b');
        });
        test.done();
    },
    'Condition variables can start with $.'(test) {
        test.doesNotThrow(() => {
            stepfunctions.Condition.stringEquals('$.a', 'b');
        });
        test.done();
    },
    'Condition variables can start with $['(test) {
        test.doesNotThrow(() => {
            stepfunctions.Condition.stringEquals('$[0]', 'a');
        });
        test.done();
    },
    'NotConditon must render properly'(test) {
        assertRendersTo(test, stepfunctions.Condition.not(stepfunctions.Condition.stringEquals('$.a', 'b')), { Not: { Variable: '$.a', StringEquals: 'b' } });
        test.done();
    },
    'CompoundCondition must render properly'(test) {
        assertRendersTo(test, stepfunctions.Condition.and(stepfunctions.Condition.booleanEquals('$.a', true), stepfunctions.Condition.numberGreaterThan('$.b', 3)), { And: [{ Variable: '$.a', BooleanEquals: true }, { Variable: '$.b', NumericGreaterThan: 3 }] });
        test.done();
    },
    'Exercise a number of other conditions'(test) {
        const cases = [
            [
                stepfunctions.Condition.stringLessThan('$.a', 'foo'),
                { Variable: '$.a', StringLessThan: 'foo' },
            ],
            [
                stepfunctions.Condition.stringLessThanEquals('$.a', 'foo'),
                { Variable: '$.a', StringLessThanEquals: 'foo' },
            ],
            [
                stepfunctions.Condition.stringGreaterThan('$.a', 'foo'),
                { Variable: '$.a', StringGreaterThan: 'foo' },
            ],
            [
                stepfunctions.Condition.stringGreaterThanEquals('$.a', 'foo'),
                { Variable: '$.a', StringGreaterThanEquals: 'foo' },
            ],
            [
                stepfunctions.Condition.numberEquals('$.a', 5),
                { Variable: '$.a', NumericEquals: 5 }
            ],
        ];
        for (const [cond, expected] of cases) {
            assertRendersTo(test, cond, expected);
        }
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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