"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Predefined error strings
 * Error names in Amazon States Language - https://docs.aws.amazon.com/step-functions/latest/dg/concepts-error-handling.html
 */
class Errors {
}
exports.Errors = Errors;
/**
 * Matches any Error.
 */
Errors.ALL = 'States.ALL';
/**
 * A Task State either ran longer than the “TimeoutSeconds” value, or
 * failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
 */
Errors.TIMEOUT = 'States.Timeout';
/**
 * A Task State failed during the execution.
 */
Errors.TASKS_FAILED = 'States.TaskFailed';
/**
 * A Task State failed because it had insufficient privileges to execute
 * the specified code.
 */
Errors.PERMISSIONS = 'States.Permissions';
/**
 * A Task State’s “ResultPath” field cannot be applied to the input the state received.
 */
Errors.RESULT_PATH_MATCH_FAILURE = 'States.ResultPathMatchFailure';
/**
 * A branch of a Parallel state failed.
 */
Errors.BRANCH_FAILED = 'States.BranchFailed';
/**
 * A Choice state failed to find a match for the condition field extracted
 * from its input.
 */
Errors.NO_CHOICE_MATCHED = 'States.NoChoiceMatched';
/**
 * Special string value to discard state input, output or result
 */
exports.DISCARD = 'DISCARD';
//# sourceMappingURL=data:application/json;base64,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