import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[RAYLEIGH INTERACTIONS (RITA sampling  of atomic form factor from EPDL database)]
#[SAMPLING DATA FROM COMMON/CGRA/: X, P, A, B, ITL, ITU] <- ITL is lower bound for "hinted" binary search, ITU is upper bound for "hinted" binary search

lung_ICRP110_RITA_PARAMS = np.array([
	[  0.0000000000E+00,  0.0000000000E+00, -3.0719312332E-02, -1.8318043236E-04,   1,   2],
	[  2.8785386004E-03,  1.6737066194E-02, -3.0268924600E-02, -7.8090399249E-05,   1,   2],
	[  5.7570772008E-03,  3.2461810851E-02, -5.7486243635E-02, -1.8088011679E-04,   1,   3],
	[  1.1514154402E-02,  6.1196093971E-02, -1.0394197458E-01, -3.2982045578E-04,   2,   3],
	[  2.3028308803E-02,  1.0969505185E-01, -9.4900605045E-02, -7.7361628808E-05,   2,   4],
	[  3.4542463205E-02,  1.4899795158E-01, -8.6868263464E-02,  8.7231103412E-05,   3,   4],
	[  4.6056617607E-02,  1.8147862858E-01, -7.9736408797E-02,  2.0998510364E-04,   3,   4],
	[  5.7570772008E-02,  2.0878407036E-01, -7.3359606370E-02,  3.0241751828E-04,   3,   5],
	[  6.9084926410E-02,  2.3208668639E-01, -6.7621029782E-02,  3.7027887688E-04,   4,   5],
	[  8.0599080812E-02,  2.5224034445E-01, -6.2431228439E-02,  4.1792359270E-04,   4,   5],
	[  9.2113235213E-02,  2.6987943997E-01, -5.7720715922E-02,  4.4906931440E-04,   4,   5],
	[  1.0362738961E-01,  2.8548362527E-01, -5.3433997719E-02,  4.6693103245E-04,   4,   5],
	[  1.1514154402E-01,  2.9942121968E-01, -4.9525475921E-02,  4.7425879029E-04,   4,   5],
	[  1.2665569842E-01,  3.1197899950E-01, -4.5956729813E-02,  4.7337247432E-04,   4,   6],
	[  1.3816985282E-01,  3.2338306000E-01, -8.2091831238E-02,  1.8408778058E-03,   5,   6],
	[  1.6119816162E-01,  3.4341615228E-01, -7.1470928495E-02,  1.7206252864E-03,   5,   6],
	[  1.8422647043E-01,  3.6058800262E-01, -6.2469794276E-02,  1.5687838853E-03,   5,   6],
	[  2.0725477923E-01,  3.7561512789E-01, -5.4837507323E-02,  1.4067366907E-03,   5,   6],
	[  2.3028308803E-01,  3.8899406191E-01, -9.2655832106E-02,  4.6805664173E-03,   5,   7],
	[  2.7633970564E-01,  4.1212652484E-01, -7.3737681922E-02,  3.5920683648E-03,   6,   7],
	[  3.2239632325E-01,  4.3183626740E-01, -5.9781504518E-02,  2.7279116671E-03,   6,   7],
	[  3.6845294085E-01,  4.4918012624E-01, -4.9422380779E-02,  2.0671511793E-03,   6,   7],
	[  4.1450955846E-01,  4.6480260934E-01, -4.1664696603E-02,  1.5699712385E-03,   6,   7],
	[  4.6056617607E-01,  4.7911816175E-01, -3.5794756986E-02,  1.1977269152E-03,   6,   8],
	[  5.0662279367E-01,  4.9240517859E-01, -3.1304051297E-02,  9.1871933653E-04,   7,   8],
	[  5.5267941128E-01,  5.0485765623E-01, -2.7829915779E-02,  7.0866749065E-04,   7,   8],
	[  5.9873602889E-01,  5.1661509819E-01, -2.5112358338E-02,  5.4954201359E-04,   7,   9],
	[  6.4479264649E-01,  5.2778061291E-01, -4.4859223066E-02,  1.5203710358E-03,   8,   9],
	[  7.3690588171E-01,  5.4863055803E-01, -3.8919014072E-02,  9.3436282915E-04,   8,   9],
	[  8.2901911692E-01,  5.6784845431E-01, -3.4959567423E-02,  5.7562773346E-04,   8,  10],
	[  9.2113235213E-01,  5.8571737434E-01, -3.2222856301E-02,  3.5008602787E-04,   9,  10],
	[  1.0132455873E+00,  6.0243156242E-01, -3.0164563496E-02,  2.1612802372E-04,   9,  10],
	[  1.1053588226E+00,  6.1813391077E-01, -5.5737033945E-02,  2.9791930717E-04,   9,  11],
	[  1.2895852930E+00,  6.4691539952E-01, -5.2049711890E-02, -5.4151817355E-05,  10,  11],
	[  1.4738117634E+00,  6.7269245871E-01, -4.9619756444E-02, -2.1796243349E-04,  10,  12],
	[  1.6580382338E+00,  6.9590744283E-01, -4.7840351969E-02, -2.9421624796E-04,  11,  12],
	[  1.8422647043E+00,  7.1689911728E-01, -4.6421885649E-02, -3.2751536126E-04,  11,  13],
	[  2.0264911747E+00,  7.3594065278E-01, -4.5064709230E-02, -3.0424145264E-04,  12,  13],
	[  2.2107176451E+00,  7.5326282669E-01, -4.4058750508E-02, -1.4928586442E-04,  12,  14],
	[  2.3949441155E+00,  7.6906326790E-01, -4.2652173375E-02, -3.2955115051E-04,  13,  15],
	[  2.5791705860E+00,  7.8351393815E-01, -4.1776840704E-02, -3.1900514388E-04,  14,  15],
	[  2.7633970564E+00,  7.9675696259E-01, -4.1042827201E-02, -1.3685271579E-04,  14,  16],
	[  2.9476235268E+00,  8.0891624502E-01, -7.6527233285E-02, -1.1387669025E-03,  15,  16],
	[  3.3160764677E+00,  8.3041948785E-01, -7.3796702373E-02, -1.0440055416E-03,  15,  17],
	[  3.6845294085E+00,  8.4874745990E-01, -7.1230012734E-02, -9.5785087312E-04,  16,  17],
	[  4.0529823494E+00,  8.6446330751E-01, -6.8626107372E-02, -7.7397416393E-04,  16,  18],
	[  4.4214352902E+00,  8.7801972945E-01, -6.6166951864E-02, -7.9149737683E-04,  17,  18],
	[  4.7898882311E+00,  8.8978150993E-01, -6.4005091693E-02, -7.2988713234E-04,  17,  19],
	[  5.1583411719E+00,  9.0003720594E-01, -6.1959937579E-02, -6.7483027420E-04,  18,  19],
	[  5.5267941128E+00,  9.0902166226E-01, -6.0024276557E-02, -6.2547047250E-04,  18,  20],
	[  5.8952470537E+00,  9.1692726931E-01, -1.0967518951E-01, -2.2448452558E-03,  19,  20],
	[  6.6321529354E+00,  9.3010902611E-01, -1.0366474680E-01, -1.9535917832E-03,  19,  20],
	[  7.3690588171E+00,  9.4055561303E-01, -9.8209812049E-02, -1.7130237400E-03,  19,  21],
	[  8.1059646988E+00,  9.4894884923E-01, -9.3245871249E-02, -1.5123031195E-03,  20,  21],
	[  8.8428705805E+00,  9.5577585830E-01, -8.8715895072E-02, -1.3433413121E-03,  20,  22],
	[  9.5797764622E+00,  9.6139088626E-01, -8.4570088461E-02, -1.1999946972E-03,  21,  22],
	[  1.0316682344E+01,  9.6605573386E-01, -1.4870874784E-01, -4.1014025056E-03,  21,  22],
	[  1.1790494107E+01,  9.7327316733E-01, -1.3729053225E-01, -3.3674380790E-03,  21,  23],
	[  1.3264305871E+01,  9.7850618272E-01, -1.2738157997E-01, -2.8103627932E-03,  22,  23],
	[  1.4738117634E+01,  9.8240453865E-01, -1.1872375253E-01, -2.3794643299E-03,  22,  24],
	[  1.6211929398E+01,  9.8537636876E-01, -1.1111073211E-01, -2.0405356985E-03,  23,  25],
	[  1.7685741161E+01,  9.8768725858E-01, -1.8749956956E-01, -6.6457315900E-03,  24,  25],
	[  2.0633364688E+01,  9.9098358521E-01, -1.6914649774E-01, -5.1901029813E-03,  24,  26],
	[  2.3580988215E+01,  9.9316236509E-01, -1.5397967552E-01, -4.1815843420E-03,  25,  26],
	[  2.6528611741E+01,  9.9466896208E-01, -1.4128963329E-01, -3.4545659437E-03,  25,  27],
	[  2.9476235268E+01,  9.9574917602E-01, -2.2790435089E-01, -1.0832228293E-02,  26,  28],
	[  3.5371482322E+01,  9.9715093404E-01, -2.0165938750E-01, -8.1619031142E-03,  27,  28],
	[  4.1266729376E+01,  9.9798510345E-01, -1.8096988058E-01, -6.4192715765E-03,  27,  29],
	[  4.7161976429E+01,  9.9851639378E-01, -2.7566994359E-01, -1.9118971206E-02,  28,  29],
	[  5.8952470537E+01,  9.9912143465E-01, -2.4003441912E-01, -1.3616857442E-02,  28,  30],
	[  7.0742964644E+01,  9.9943391359E-01, -3.3555819145E-01, -3.6742513850E-02,  29,  30],
	[  9.4323952858E+01,  9.9972276225E-01, -2.8773477100E-01, -2.3596515192E-02,  29,  30],
	[  1.1790494107E+02,  9.9984319967E-01, -2.5147707419E-01, -1.6487876508E-02,  29,  31],
	[  1.4148592929E+02,  9.9990251608E-01, -3.4609498673E-01, -4.3468340874E-02,  30,  31],
	[  1.8864790572E+02,  9.9995466858E-01, -4.0991088709E-01, -9.2871760165E-02,  30,  32],
	[  2.8297185858E+02,  9.9998500838E-01, -3.5387822291E-01, -4.7938108994E-02,  31,  32],
	[  3.7729581143E+02,  9.9999326542E-01, -3.7794425734E-01, -3.1507052325E-01,  31,  33],
	[  7.5459162287E+02,  9.9999905305E-01, -3.7424804153E-01, -3.2343042777E-01,  32,  33],
	[  1.5091832457E+03,  9.9999986995E-01, -3.7579166969E-01, -3.2352777827E-01,  32,  34],
	[  3.0183664915E+03,  9.9999998217E-01, -3.8135645944E-01, -3.1761873603E-01,  33,  34],
	[  6.0367329829E+03,  9.9999999752E-01, -3.9032138456E-01, -3.0683479028E-01,  33,  34],
	[  1.2073465966E+04,  9.9999999965E-01, -4.0230496426E-01, -2.9173469579E-01,  33,  34],
	[  2.4146931932E+04,  9.9999999995E-01, -4.1677677100E-01, -2.7286733297E-01,  33,  35],
	[  4.8293863864E+04,  9.9999999999E-01, -4.3276955552E-01, -2.5120739340E-01,  34,  35],
	[  9.6587727727E+04,  1.0000000000E+00, -4.4884906072E-01, -2.2831526415E-01,  34,  35],
	[  1.9317545545E+05,  1.0000000000E+00, -4.6344486287E-01, -2.0609127509E-01,  34,  36],
	[  3.8635091091E+05,  1.0000000000E+00, -4.7538798066E-01, -1.8622675155E-01,  35,  36],
	[  7.7270182182E+05,  1.0000000000E+00, -4.8426895041E-01, -1.6972217732E-01,  35,  36],
	[  1.5454036436E+06,  1.0000000000E+00, -4.9037466399E-01, -1.5678161479E-01,  35,  37],
	[  3.0908072873E+06,  1.0000000000E+00, -4.9434498545E-01, -1.4704593211E-01,  36,  37],
	[  6.1816145745E+06,  1.0000000000E+00, -4.9684505065E-01, -1.3991426399E-01,  36,  37],
	[  1.2363229149E+07,  1.0000000000E+00, -4.9840090091E-01, -1.3477255330E-01,  36,  38],
	[  2.4726458298E+07,  1.0000000000E+00, -4.9937236049E-01, -1.3109849563E-01,  37,  38],
	[  4.9452916596E+07,  1.0000000000E+00, -4.9998668313E-01, -1.2848577948E-01,  37,  39],
	[  9.8905833192E+07,  1.0000000000E+00, -5.0038189366E-01, -1.2663251961E-01,  38,  39],
	[  1.9781166638E+08,  1.0000000000E+00, -5.0064078532E-01, -1.2531968825E-01,  38,  40],
	[  3.9562333277E+08,  1.0000000000E+00, -5.0081325553E-01, -1.2439030855E-01,  39,  40],
	[  7.9124666554E+08,  1.0000000000E+00, -5.0092983171E-01, -1.2373258296E-01,  39,  41],
	[  1.5824933311E+09,  1.0000000000E+00, -4.0264672752E-01, -4.1132185022E-02,  40,  41],
	[  2.3737399966E+09,  1.0000000000E+00, -3.2249123639E-01, -2.0537307144E-02,  40,  42],
	[  3.1649866622E+09,  1.0000000000E+00, -2.6698586122E-01, -1.2311264572E-02,  41,  42],
	[  3.9562333277E+09,  1.0000000000E+00, -2.2724508412E-01, -8.2022095675E-03,  41,  43],
	[  4.7474799932E+09,  1.0000000000E+00, -1.9760479258E-01, -5.8558382108E-03,  42,  44],
	[  5.5387266588E+09,  1.0000000000E+00, -1.7471743837E-01, -4.3901604246E-03,  43,  44],
	[  6.3299733243E+09,  1.0000000000E+00, -1.5653816604E-01, -3.4134738636E-03,  43,  44],
	[  7.1212199899E+09,  1.0000000000E+00, -1.4176179272E-01, -2.7300437823E-03,  43,  45],
	[  7.9124666554E+09,  1.0000000000E+00, -1.2952060571E-01, -2.2331579337E-03,  44,  45],
	[  8.7037133209E+09,  1.0000000000E+00, -1.1921691001E-01, -1.8605931176E-03,  44,  46],
	[  9.4949599865E+09,  1.0000000000E+00, -1.1042627320E-01, -1.5740716512E-03,  45,  46],
	[  1.0286206652E+10,  1.0000000000E+00, -1.0283930361E-01, -1.3489940179E-03,  45,  47],
	[  1.1077453318E+10,  1.0000000000E+00, -9.6225304307E-02, -1.1689649842E-03,  46,  47],
	[  1.1868699983E+10,  1.0000000000E+00, -9.0408831028E-02, -1.0227155468E-03,  46,  48],
	[  1.2659946649E+10,  1.0000000000E+00, -8.5254130594E-02, -9.0229283940E-04,  47,  48],
	[  1.3451193314E+10,  1.0000000000E+00, -8.0654543671E-02, -8.0195425110E-04,  47,  49],
	[  1.4242439980E+10,  1.0000000000E+00, -7.6525122728E-02, -7.1746913987E-04,  48,  50],
	[  1.5033686645E+10,  1.0000000000E+00, -7.2797384582E-02, -6.4566504286E-04,  49,  51],
	[  1.5824933311E+10,  1.0000000000E+00, -6.9415512017E-02, -5.8412520906E-04,  50,  52],
	[  1.6616179976E+10,  1.0000000000E+00, -6.6333558960E-02, -5.3098240877E-04,  51,  52],
	[  1.7407426642E+10,  1.0000000000E+00, -6.3513363418E-02, -4.8477552025E-04,  51,  53],
	[  1.8198673307E+10,  1.0000000000E+00, -6.0922967812E-02, -4.4434796112E-04,  52,  54],
	[  1.8989919973E+10,  1.0000000000E+00, -5.8535408572E-02, -4.0877456934E-04,  53,  55],
	[  1.9781166638E+10,  1.0000000000E+00, -5.6327778179E-02, -3.7730817737E-04,  54,  56],
	[  2.0572413304E+10,  1.0000000000E+00, -5.4280490756E-02, -3.4934004205E-04,  55,  58],
	[  2.1363659970E+10,  1.0000000000E+00, -5.2376701529E-02, -3.2437017102E-04,  57,  59],
	[  2.2154906635E+10,  1.0000000000E+00, -5.0601843840E-02, -3.0198481386E-04,  58,  61],
	[  2.2946153301E+10,  1.0000000000E+00, -4.8943256869E-02, -2.8183920726E-04,  60,  64],
	[  2.3737399966E+10,  1.0000000000E+00, -4.7389884002E-02, -2.6364421772E-04,  63, 128],
	[  2.4528646632E+10,  1.0000000000E+00,  0.0000000000E+00,  0.0000000000E+00, 127, 128],
])
