import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[RAYLEIGH INTERACTIONS (RITA sampling  of atomic form factor from EPDL database)]
#[SAMPLING DATA FROM COMMON/CGRA/: X, P, A, B, ITL, ITU] <- ITL is lower bound for "hinted" binary search, ITU is upper bound for "hinted" binary search

air_RITA_PARAMS = np.array([
	[  0.0000000000E+00,  0.0000000000E+00, -2.9444260648E-02, -4.1382062347E-04,   1,   2],
	[  2.5835083284E-03,  1.5375200709E-02, -2.9651719365E-02, -1.6060149152E-04,   1,   3],
	[  5.1670166567E-03,  2.9840656965E-02, -5.6822924337E-02, -3.3076158910E-04,   2,   3],
	[  1.0334033313E-02,  5.6300608956E-02, -5.4597210738E-02, -1.5846007103E-04,   2,   4],
	[  1.5501049970E-02,  7.9874453531E-02, -5.2174881652E-02, -6.8231626989E-05,   3,   4],
	[  2.0668066627E-02,  1.0099001493E-01, -9.4870462195E-02,  4.1302571714E-05,   3,   4],
	[  3.1002099940E-02,  1.3721685887E-01, -8.6573595350E-02,  2.8596251633E-04,   3,   4],
	[  4.1336133254E-02,  1.6718007977E-01, -7.9021738076E-02,  4.2813098630E-04,   3,   5],
	[  5.1670166567E-02,  1.9241334370E-01, -7.2222212465E-02,  5.1293874286E-04,   4,   5],
	[  6.2004199880E-02,  2.1400543151E-01, -6.6114953106E-02,  5.6132510011E-04,   4,   5],
	[  7.2338233194E-02,  2.3274483902E-01, -6.0627625863E-02,  5.8508832819E-04,   4,   6],
	[  8.2672266507E-02,  2.4921365159E-01, -5.5690940228E-02,  5.9170250091E-04,   5,   6],
	[  9.3006299821E-02,  2.6384926270E-01, -5.1242682534E-02,  5.8625750515E-04,   5,   7],
	[  1.0334033313E-01,  2.7698569782E-01, -9.0457850666E-02,  2.2495982824E-03,   6,   7],
	[  1.2400839976E-01,  2.9974093030E-01, -7.7698791940E-02,  2.0643105925E-03,   6,   7],
	[  1.4467646639E-01,  3.1896293855E-01, -6.7096386936E-02,  1.8491397328E-03,   6,   7],
	[  1.6534453301E-01,  3.3560613326E-01, -5.8264119465E-02,  1.6310280548E-03,   6,   7],
	[  1.8601259964E-01,  3.5030953758E-01, -5.0887344597E-02,  1.4242775959E-03,   6,   8],
	[  2.0668066627E-01,  3.6351569465E-01, -8.5907857377E-02,  4.5966774987E-03,   7,   8],
	[  2.4801679952E-01,  3.8661308309E-01, -6.8051289272E-02,  3.4206299422E-03,   7,   8],
	[  2.8935293278E-01,  4.0655263314E-01, -5.5123301522E-02,  2.5390478870E-03,   7,   8],
	[  3.3068906603E-01,  4.2428338658E-01, -4.5664108285E-02,  1.8902373628E-03,   7,   9],
	[  3.7202519928E-01,  4.4038733951E-01, -3.8658310587E-02,  1.4151800864E-03,   8,   9],
	[  4.1336133254E-01,  4.5524092916E-01, -3.3402548452E-02,  1.0666884241E-03,   8,   9],
	[  4.5469746579E-01,  4.6909852004E-01, -2.9408284593E-02,  8.0959456776E-04,   8,  10],
	[  4.9603359904E-01,  4.8213842936E-01, -2.6333829562E-02,  6.1848008795E-04,   9,  10],
	[  5.3736973230E-01,  4.9448967791E-01, -2.3937949180E-02,  4.7519710994E-04,   9,  10],
	[  5.7870586555E-01,  5.0624824011E-01, -4.3106571336E-02,  1.2970149374E-03,   9,  11],
	[  6.6137813206E-01,  5.2826387880E-01, -3.7889768833E-02,  7.8064213668E-04,  10,  11],
	[  7.4405039857E-01,  5.4860260953E-01, -3.4413247476E-02,  4.6799473505E-04,  10,  12],
	[  8.2672266507E-01,  5.6753658530E-01, -3.2002848576E-02,  2.7321969436E-04,  11,  12],
	[  9.0939493158E-01,  5.8525576015E-01, -3.0267285642E-02,  1.4888278923E-04,  11,  13],
	[  9.9206719809E-01,  6.0190051985E-01, -5.6248291241E-02,  1.6000732309E-04,  12,  13],
	[  1.1574117311E+00,  6.3238103373E-01, -5.2858214130E-02, -1.3680209087E-04,  12,  14],
	[  1.3227562641E+00,  6.5963159312E-01, -5.0560055509E-02, -2.7168808789E-04,  13,  14],
	[  1.4881007971E+00,  6.8412287312E-01, -4.8829380509E-02, -3.3180133969E-04,  13,  15],
	[  1.6534453301E+00,  7.0622039720E-01, -4.7416557631E-02, -3.5552929637E-04,  14,  15],
	[  1.8187898632E+00,  7.2622119649E-01, -4.6195138530E-02, -3.6091450135E-04,  14,  15],
	[  1.9841343962E+00,  7.4437338733E-01, -8.6136148189E-02, -1.4111848172E-03,  14,  16],
	[  2.3148234622E+00,  7.7594580506E-01, -8.2565460697E-02, -1.3239858457E-03,  15,  16],
	[  2.6455125282E+00,  8.0230023542E-01, -7.9359816586E-02, -1.2252172256E-03,  15,  17],
	[  2.9762015943E+00,  8.2446884574E-01, -3.9785008626E-02, -2.8816410127E-04,  16,  17],
	[  3.1415461273E+00,  8.3423956179E-01, -3.9347944050E-02,  3.7275203218E-04,  16,  18],
	[  3.3068906603E+00,  8.4325058255E-01, -7.1525890343E-02, -9.3311781630E-04,  17,  18],
	[  3.6375797263E+00,  8.5932123876E-01, -6.9007289248E-02, -8.5061296405E-04,  17,  19],
	[  3.9682687923E+00,  8.7317319034E-01, -6.6625091559E-02, -7.7726988717E-04,  18,  19],
	[  4.2989578584E+00,  8.8517883036E-01, -6.4371096366E-02, -7.1200250872E-04,  18,  20],
	[  4.6296469244E+00,  8.9563843350E-01, -6.2237641475E-02, -6.5377053580E-04,  19,  20],
	[  4.9603359904E+00,  9.0479576691E-01, -6.0217340055E-02, -6.0165387506E-04,  19,  20],
	[  5.2910250565E+00,  9.1285000400E-01, -1.0989485710E-01, -2.1356671031E-03,  19,  21],
	[  5.9524031885E+00,  9.2627581492E-01, -1.0361283482E-01, -1.8300700719E-03,  20,  21],
	[  6.6137813206E+00,  9.3691773784E-01, -9.7903831901E-02, -1.5789976830E-03,  20,  22],
	[  7.2751594526E+00,  9.4547482801E-01, -9.2702492690E-02, -1.3708581154E-03,  21,  22],
	[  7.9365375847E+00,  9.5244471815E-01, -8.7951089077E-02, -1.1969874114E-03,  21,  23],
	[  8.5979157168E+00,  9.5818815433E-01, -8.3599256279E-02, -1.0507869531E-03,  22,  23],
	[  9.2592938488E+00,  9.6297100928E-01, -1.4685786003E-01, -3.4986947971E-03,  22,  24],
	[  1.0582050113E+01,  9.7040265455E-01, -1.3481081175E-01, -2.7752823169E-03,  23,  24],
	[  1.1904806377E+01,  9.7582916472E-01, -1.2435835967E-01, -2.2417095856E-03,  23,  25],
	[  1.3227562641E+01,  9.7990527480E-01, -1.1524140494E-01, -1.8421447568E-03,  24,  25],
	[  1.4550318905E+01,  9.8304149245E-01, -1.0724986993E-01, -1.5387203951E-03,  24,  26],
	[  1.5873075169E+01,  9.8550473537E-01, -1.8113381963E-01, -4.8548898503E-03,  25,  26],
	[  1.8518587698E+01,  9.8907319396E-01, -1.6182191316E-01, -3.6860878669E-03,  25,  27],
	[  2.1164100226E+01,  9.9148548618E-01, -1.4608881328E-01, -2.9302843596E-03,  26,  28],
	[  2.3809612754E+01,  9.9319225226E-01, -1.3313503294E-01, -2.4161330429E-03,  27,  28],
	[  2.6455125282E+01,  9.9444413129E-01, -2.1599956790E-01, -7.6528930499E-03,  27,  29],
	[  3.1746150339E+01,  9.9612038513E-01, -1.8950896097E-01, -5.9237020556E-03,  28,  29],
	[  3.7037175395E+01,  9.9715946135E-01, -1.6928258852E-01, -4.8011605994E-03,  28,  29],
	[  4.2328200452E+01,  9.9784586689E-01, -2.6111583627E-01, -1.4862197151E-02,  28,  30],
	[  5.2910250565E+01,  9.9866286000E-01, -2.2671844646E-01, -1.1048239009E-02,  29,  30],
	[  6.3492300678E+01,  9.9910713410E-01, -2.0116892791E-01, -8.5745813004E-03,  29,  31],
	[  7.4074350790E+01,  9.9937182262E-01, -1.8126057390E-01, -6.8594025079E-03,  30,  31],
	[  8.4656400903E+01,  9.9954020127E-01, -2.7641002182E-01, -2.0676071840E-02,  30,  31],
	[  1.0582050113E+02,  9.9973107325E-01, -2.4217882647E-01, -1.4780479315E-02,  30,  32],
	[  1.2698460136E+02,  9.9982874500E-01, -3.3789023664E-01, -3.9748870702E-02,  31,  32],
	[  1.6931280181E+02,  9.9991776381E-01, -4.0583404012E-01, -8.6809188772E-02,  31,  33],
	[  2.5396920271E+02,  9.9997183165E-01, -3.4943449660E-01, -4.5604594796E-02,  32,  33],
	[  3.3862560361E+02,  9.9998710121E-01, -3.8473555305E-01, -3.0329523651E-01,  32,  34],
	[  6.7725120723E+02,  9.9999812569E-01, -3.7952259512E-01, -3.1520330482E-01,  33,  34],
	[  1.3545024145E+03,  9.9999973688E-01, -3.8046756811E-01, -3.1681461947E-01,  33,  34],
	[  2.7090048289E+03,  9.9999996330E-01, -3.8600195261E-01, -3.1126815942E-01,  33,  34],
	[  5.4180096578E+03,  9.9999999482E-01, -3.9513835261E-01, -3.0034864014E-01,  33,  35],
	[  1.0836019316E+04,  9.9999999925E-01, -4.0717860330E-01, -2.8509886210E-01,  34,  35],
	[  2.1672038631E+04,  9.9999999989E-01, -4.2135435588E-01, -2.6642322766E-01,  34,  35],
	[  4.3344077263E+04,  9.9999999998E-01, -4.3660604451E-01, -2.4548278239E-01,  34,  36],
	[  8.6688154525E+04,  1.0000000000E+00, -4.5161286020E-01, -2.2378817813E-01,  35,  36],
	[  1.7337630905E+05,  1.0000000000E+00, -4.6508016660E-01, -2.0297436007E-01,  35,  36],
	[  3.4675261810E+05,  1.0000000000E+00, -4.7611505093E-01, -1.8440405599E-01,  35,  37],
	[  6.9350523620E+05,  1.0000000000E+00, -4.8443336878E-01, -1.6886271858E-01,  36,  37],
	[  1.3870104724E+06,  1.0000000000E+00, -4.9028162849E-01, -1.5651518412E-01,  36,  37],
	[  2.7740209448E+06,  1.0000000000E+00, -4.9418421703E-01, -1.4708020899E-01,  36,  38],
	[  5.5480418896E+06,  1.0000000000E+00, -4.9670207366E-01, -1.4006484935E-01,  37,  38],
	[  1.1096083779E+07,  1.0000000000E+00, -4.9829941134E-01, -1.3494224257E-01,  37,  38],
	[  2.2192167558E+07,  1.0000000000E+00, -4.9930959049E-01, -1.3124492181E-01,  37,  39],
	[  4.4384335117E+07,  1.0000000000E+00, -4.9995269837E-01, -1.2859578476E-01,  38,  39],
	[  8.8768670234E+07,  1.0000000000E+00, -5.0036727925E-01, -1.2670638161E-01,  38,  40],
	[  1.7753734047E+08,  1.0000000000E+00, -5.0063860101E-01, -1.2536274908E-01,  39,  40],
	[  3.5507468093E+08,  1.0000000000E+00, -5.0081888367E-01, -1.2440902105E-01,  39,  40],
	[  7.1014936187E+08,  1.0000000000E+00, -5.0094033534E-01, -1.2373287833E-01,  39,  40],
	[  1.4202987237E+09,  1.0000000000E+00, -4.0265147775E-01, -4.1128677696E-02,  39,  41],
	[  2.1304480856E+09,  1.0000000000E+00, -3.2249104192E-01, -2.0534658738E-02,  40,  41],
	[  2.8405974475E+09,  1.0000000000E+00, -2.6698317112E-01, -1.2309335245E-02,  40,  41],
	[  3.5507468093E+09,  1.0000000000E+00, -2.2724114305E-01, -8.2007627075E-03,  40,  42],
	[  4.2608961712E+09,  1.0000000000E+00, -1.9760023169E-01, -5.8547179884E-03,  41,  42],
	[  4.9710455331E+09,  1.0000000000E+00, -1.7471259249E-01, -4.3892688645E-03,  41,  42],
	[  5.6811948950E+09,  1.0000000000E+00, -1.5653321988E-01, -3.4127478412E-03,  41,  43],
	[  6.3913442568E+09,  1.0000000000E+00, -1.4175685079E-01, -2.7294411979E-03,  42,  44],
	[  7.1014936187E+09,  1.0000000000E+00, -1.2951572775E-01, -2.2326497589E-03,  43,  44],
	[  7.8116429806E+09,  1.0000000000E+00, -1.1921212983E-01, -1.8601587330E-03,  43,  45],
	[  8.5217923424E+09,  1.0000000000E+00, -1.1042160918E-01, -1.5736960245E-03,  44,  45],
	[  9.2319417043E+09,  1.0000000000E+00, -1.0283476481E-01, -1.3486659384E-03,  44,  46],
	[  9.9420910662E+09,  1.0000000000E+00, -9.6220894048E-02, -1.1686759238E-03,  45,  47],
	[  1.0652240428E+10,  1.0000000000E+00, -9.0404549103E-02, -1.0224589041E-03,  46,  47],
	[  1.1362389790E+10,  1.0000000000E+00, -8.5249974649E-02, -9.0206342465E-04,  46,  48],
	[  1.2072539152E+10,  1.0000000000E+00, -8.0650510074E-02, -8.0174792835E-04,  47,  49],
	[  1.2782688514E+10,  1.0000000000E+00, -7.6521207122E-02, -7.1728257227E-04,  48,  50],
	[  1.3492837876E+10,  1.0000000000E+00, -7.2793582246E-02, -6.4549550835E-04,  49,  51],
	[  1.4202987237E+10,  1.0000000000E+00, -6.9411818091E-02, -5.8397046502E-04,  50,  51],
	[  1.4913136599E+10,  1.0000000000E+00, -6.6329968597E-02, -5.3084059072E-04,  50,  52],
	[  1.5623285961E+10,  1.0000000000E+00, -6.3509871873E-02, -4.8464506531E-04,  51,  53],
	[  1.6333435323E+10,  1.0000000000E+00, -6.0919570502E-02, -4.4422754929E-04,  52,  53],
	[  1.7043584685E+10,  1.0000000000E+00, -5.8532101105E-02, -4.0866307807E-04,  52,  55],
	[  1.7753734047E+10,  1.0000000000E+00, -5.6324556372E-02, -3.7720464573E-04,  54,  56],
	[  1.8463883409E+10,  1.0000000000E+00, -5.4277350643E-02, -3.4924364284E-04,  55,  57],
	[  1.9174032770E+10,  1.0000000000E+00, -5.2373639358E-02, -3.2428018819E-04,  56,  59],
	[  1.9884182132E+10,  1.0000000000E+00, -5.0598856071E-02, -3.0190062433E-04,  58,  61],
	[  2.0594331494E+10,  1.0000000000E+00, -4.8940340162E-02, -2.8176026634E-04,  60,  64],
	[  2.1304480856E+10,  1.0000000000E+00, -4.7387035210E-02, -2.6357004706E-04,  63, 128],
	[  2.2014630218E+10,  1.0000000000E+00,  0.0000000000E+00,  0.0000000000E+00, 127, 128],
])
