import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

stomach_intestines_ICRP110_MFP = np.array([
	[5.0000000000E+03, 1.8093817611E+00, 8.0805023759E+00, 2.3864113145E-02, 2.3485008888E-02, 3.4686553501E-01],
	[5.0050000000E+03, 1.8114573394E+00, 8.0756187668E+00, 2.3936261251E-02, 2.3555189396E-02, 3.4712328307E-01],
	[5.0100000000E+03, 1.8135332227E+00, 8.0707429811E+00, 2.4008554969E-02, 2.3625507144E-02, 3.4738072973E-01],
	[5.0150000000E+03, 1.8156094105E+00, 8.0658749985E+00, 2.4080994447E-02, 2.3695962253E-02, 3.4763787574E-01],
	[5.0200000000E+03, 1.8176859027E+00, 8.0610147986E+00, 2.4153579832E-02, 2.3766554841E-02, 3.4789472184E-01],
	[5.0250000000E+03, 1.8197626991E+00, 8.0561623614E+00, 2.4226311273E-02, 2.3837285029E-02, 3.4815126876E-01],
	[5.0300000000E+03, 1.8218397993E+00, 8.0513176668E+00, 2.4299188916E-02, 2.3908152936E-02, 3.4840751724E-01],
	[5.0350000000E+03, 1.8239172032E+00, 8.0464806946E+00, 2.4372212909E-02, 2.3979158681E-02, 3.4866346800E-01],
	[5.0400000000E+03, 1.8259949104E+00, 8.0416514249E+00, 2.4445383400E-02, 2.4050302383E-02, 3.4891912178E-01],
	[5.0450000000E+03, 1.8280729206E+00, 8.0368298380E+00, 2.4518700537E-02, 2.4121584162E-02, 3.4917447931E-01],
	[5.0500000000E+03, 1.8301512338E+00, 8.0320159138E+00, 2.4592164468E-02, 2.4193004137E-02, 3.4942954129E-01],
	[5.0550000000E+03, 1.8322298495E+00, 8.0272096327E+00, 2.4665775339E-02, 2.4264562426E-02, 3.4968430845E-01],
	[5.0600000000E+03, 1.8343087675E+00, 8.0224109751E+00, 2.4739533299E-02, 2.4336259149E-02, 3.4993878152E-01],
	[5.0650000000E+03, 1.8363879876E+00, 8.0176199212E+00, 2.4813438495E-02, 2.4408094425E-02, 3.5019296119E-01],
	[5.0700000000E+03, 1.8384675095E+00, 8.0128364516E+00, 2.4887491075E-02, 2.4480068372E-02, 3.5044684819E-01],
	[5.0750000000E+03, 1.8405473330E+00, 8.0080605468E+00, 2.4961691186E-02, 2.4552181110E-02, 3.5070044322E-01],
	[5.0800000000E+03, 1.8426274578E+00, 8.0032921874E+00, 2.5036038977E-02, 2.4624432756E-02, 3.5095374699E-01],
	[5.0850000000E+03, 1.8447216545E+00, 7.9986120635E+00, 2.5110534594E-02, 2.4696826668E-02, 3.5120676020E-01],
	[5.0900000000E+03, 1.8468175071E+00, 7.9939470979E+00, 2.5185178186E-02, 2.4769360072E-02, 3.5145948356E-01],
	[5.0950000000E+03, 1.8489136796E+00, 7.9892894291E+00, 2.5259969900E-02, 2.4842032773E-02, 3.5171191775E-01],
	[5.1000000000E+03, 1.8510101717E+00, 7.9846390387E+00, 2.5334909884E-02, 2.4914844892E-02, 3.5196406348E-01],
	[5.1050000000E+03, 1.8531069832E+00, 7.9799959082E+00, 2.5409998286E-02, 2.4987796545E-02, 3.5221592144E-01],
	[5.1100000000E+03, 1.8552041137E+00, 7.9753600192E+00, 2.5485235252E-02, 2.5060887852E-02, 3.5246749231E-01],
	[5.1150000000E+03, 1.8573015631E+00, 7.9707313533E+00, 2.5560620931E-02, 2.5134118932E-02, 3.5271877680E-01],
	[5.1200000000E+03, 1.8593993311E+00, 7.9661098921E+00, 2.5636155471E-02, 2.5207489901E-02, 3.5296977557E-01],
	[5.1250000000E+03, 1.8614974173E+00, 7.9614956176E+00, 2.5711839019E-02, 2.5281000879E-02, 3.5322048932E-01],
	[5.1300000000E+03, 1.8635958216E+00, 7.9568885114E+00, 2.5787671722E-02, 2.5354651984E-02, 3.5347091872E-01],
	[5.1350000000E+03, 1.8656945436E+00, 7.9522885555E+00, 2.5863653729E-02, 2.5428443334E-02, 3.5372106446E-01],
	[5.1400000000E+03, 1.8677935832E+00, 7.9476957319E+00, 2.5939785188E-02, 2.5502375047E-02, 3.5397092720E-01],
	[5.1450000000E+03, 1.8698929400E+00, 7.9431100225E+00, 2.6016066244E-02, 2.5576447241E-02, 3.5422050762E-01],
	[5.1500000000E+03, 1.8719926138E+00, 7.9385314094E+00, 2.6092497048E-02, 2.5650660034E-02, 3.5446980639E-01],
	[5.1550000000E+03, 1.8740926043E+00, 7.9339598749E+00, 2.6169077745E-02, 2.5725013543E-02, 3.5471882418E-01],
	[5.1600000000E+03, 1.8761929113E+00, 7.9293954010E+00, 2.6245808484E-02, 2.5799507887E-02, 3.5496756165E-01],
	[5.1650000000E+03, 1.8783016665E+00, 7.9248851291E+00, 2.6322689413E-02, 2.5874145229E-02, 3.5521601946E-01],
	[5.1700000000E+03, 1.8804173020E+00, 7.9204197271E+00, 2.6399720678E-02, 2.5948925315E-02, 3.5546419828E-01],
	[5.1750000000E+03, 1.8825332719E+00, 7.9159611539E+00, 2.6476902429E-02, 2.6023846623E-02, 3.5571209877E-01],
	[5.1800000000E+03, 1.8846495759E+00, 7.9115093927E+00, 2.6554234812E-02, 2.6098909269E-02, 3.5595972157E-01],
	[5.1850000000E+03, 1.8867662138E+00, 7.9070644265E+00, 2.6631717975E-02, 2.6174113372E-02, 3.5620706734E-01],
	[5.1900000000E+03, 1.8888831854E+00, 7.9026262382E+00, 2.6709352066E-02, 2.6249459050E-02, 3.5645413674E-01],
	[5.1950000000E+03, 1.8910004903E+00, 7.8981948112E+00, 2.6787137232E-02, 2.6324946419E-02, 3.5670093041E-01],
	[5.2000000000E+03, 1.8931181282E+00, 7.8937701285E+00, 2.6865073621E-02, 2.6400575597E-02, 3.5694744899E-01],
	[5.2050000000E+03, 1.8952360990E+00, 7.8893521735E+00, 2.6943161382E-02, 2.6476346702E-02, 3.5719369313E-01],
	[5.2100000000E+03, 1.8973544023E+00, 7.8849409295E+00, 2.7021400660E-02, 2.6552259850E-02, 3.5743966348E-01],
	[5.2150000000E+03, 1.8994730379E+00, 7.8805363799E+00, 2.7099791605E-02, 2.6628315160E-02, 3.5768536067E-01],
	[5.2200000000E+03, 1.9015920055E+00, 7.8761385080E+00, 2.7178334364E-02, 2.6704512747E-02, 3.5793078534E-01],
	[5.2250000000E+03, 1.9037113048E+00, 7.8717472975E+00, 2.7257029085E-02, 2.6780852729E-02, 3.5817593811E-01],
	[5.2300000000E+03, 1.9058309356E+00, 7.8673627317E+00, 2.7335875914E-02, 2.6857335223E-02, 3.5842081964E-01],
	[5.2350000000E+03, 1.9079508977E+00, 7.8629847945E+00, 2.7414875001E-02, 2.6933960346E-02, 3.5866543054E-01],
	[5.2400000000E+03, 1.9100711906E+00, 7.8586134693E+00, 2.7494026492E-02, 2.7010728214E-02, 3.5890977144E-01],
	[5.2450000000E+03, 1.9121918143E+00, 7.8542487400E+00, 2.7573330535E-02, 2.7087638945E-02, 3.5915384296E-01],
	[5.2500000000E+03, 1.9143260739E+00, 7.8499669083E+00, 2.7652787279E-02, 2.7164696248E-02, 3.5939764574E-01],
	[5.2550000000E+03, 1.9164616382E+00, 7.8456969670E+00, 2.7732396870E-02, 2.7241896938E-02, 3.5964118039E-01],
	[5.2600000000E+03, 1.9185975505E+00, 7.8414334057E+00, 2.7812159457E-02, 2.7319240876E-02, 3.5988444754E-01],
	[5.2650000000E+03, 1.9207338106E+00, 7.8371762090E+00, 2.7892075186E-02, 2.7396728178E-02, 3.6012744779E-01],
	[5.2700000000E+03, 1.9228704181E+00, 7.8329253612E+00, 2.7972144206E-02, 2.7474358960E-02, 3.6037018176E-01],
	[5.2750000000E+03, 1.9250073727E+00, 7.8286808470E+00, 2.8052366665E-02, 2.7552133339E-02, 3.6061265006E-01],
	[5.2800000000E+03, 1.9271446743E+00, 7.8244426508E+00, 2.8132742710E-02, 2.7630051431E-02, 3.6085485332E-01],
	[5.2850000000E+03, 1.9292823225E+00, 7.8202107574E+00, 2.8213272488E-02, 2.7708113352E-02, 3.6109679212E-01],
	[5.2900000000E+03, 1.9314203171E+00, 7.8159851513E+00, 2.8293956148E-02, 2.7786319220E-02, 3.6133846708E-01],
	[5.2950000000E+03, 1.9335586578E+00, 7.8117658174E+00, 2.8374793838E-02, 2.7864669150E-02, 3.6157987880E-01],
	[5.3000000000E+03, 1.9356973443E+00, 7.8075527404E+00, 2.8455785704E-02, 2.7943163258E-02, 3.6182102789E-01],
	[5.3050000000E+03, 1.9378363764E+00, 7.8033459050E+00, 2.8536931895E-02, 2.8021801660E-02, 3.6206191494E-01],
	[5.3100000000E+03, 1.9399757537E+00, 7.7991452964E+00, 2.8618232558E-02, 2.8100584473E-02, 3.6230254055E-01],
	[5.3150000000E+03, 1.9421154760E+00, 7.7949508992E+00, 2.8699687841E-02, 2.8179511811E-02, 3.6254290532E-01],
	[5.3200000000E+03, 1.9442555431E+00, 7.7907626986E+00, 2.8781297892E-02, 2.8258583792E-02, 3.6278300984E-01],
	[5.3250000000E+03, 1.9463959547E+00, 7.7865806796E+00, 2.8863062858E-02, 2.8337800531E-02, 3.6302285473E-01],
	[5.3300000000E+03, 1.9485373239E+00, 7.7824083177E+00, 2.8944982888E-02, 2.8417162320E-02, 3.6326244076E-01],
	[5.3350000000E+03, 1.9506922643E+00, 7.7783172355E+00, 2.9027058128E-02, 2.8496672931E-02, 3.6350176861E-01],
	[5.3400000000E+03, 1.9528475658E+00, 7.7742321332E+00, 2.9109288726E-02, 2.8576328682E-02, 3.6374083895E-01],
	[5.3450000000E+03, 1.9550032282E+00, 7.7701529966E+00, 2.9191674831E-02, 2.8656129689E-02, 3.6397965248E-01],
	[5.3500000000E+03, 1.9571592512E+00, 7.7660798113E+00, 2.9274216590E-02, 2.8736076068E-02, 3.6421820985E-01],
	[5.3550000000E+03, 1.9593156346E+00, 7.7620125633E+00, 2.9356914151E-02, 2.8816167934E-02, 3.6445651175E-01],
	[5.3600000000E+03, 1.9614723781E+00, 7.7579512381E+00, 2.9439767660E-02, 2.8896405403E-02, 3.6469455883E-01],
	[5.3650000000E+03, 1.9636294813E+00, 7.7538958218E+00, 2.9522777267E-02, 2.8976788589E-02, 3.6493235177E-01],
	[5.3700000000E+03, 1.9657869441E+00, 7.7498463003E+00, 2.9605943119E-02, 2.9057317609E-02, 3.6516989123E-01],
	[5.3750000000E+03, 1.9679447661E+00, 7.7458026594E+00, 2.9689265363E-02, 2.9137992577E-02, 3.6540717787E-01],
	[5.3800000000E+03, 1.9701029471E+00, 7.7417648852E+00, 2.9772744147E-02, 2.9218813609E-02, 3.6564421234E-01],
	[5.3850000000E+03, 1.9722614868E+00, 7.7377329637E+00, 2.9856379619E-02, 2.9299780820E-02, 3.6588099531E-01],
	[5.3900000000E+03, 1.9744203849E+00, 7.7337068811E+00, 2.9940171927E-02, 2.9380894324E-02, 3.6611752742E-01],
	[5.3950000000E+03, 1.9765796412E+00, 7.7296866235E+00, 3.0024121218E-02, 2.9462154237E-02, 3.6635380934E-01],
	[5.4000000000E+03, 1.9787392553E+00, 7.7256721770E+00, 3.0108227640E-02, 2.9543560673E-02, 3.6658984169E-01],
	[5.4050000000E+03, 1.9808992270E+00, 7.7216635279E+00, 3.0192491341E-02, 2.9625113747E-02, 3.6682562514E-01],
	[5.4100000000E+03, 1.9830595561E+00, 7.7176606624E+00, 3.0276912469E-02, 2.9706813574E-02, 3.6706116032E-01],
	[5.4150000000E+03, 1.9852202422E+00, 7.7136635670E+00, 3.0361491170E-02, 2.9788660269E-02, 3.6729644787E-01],
	[5.4200000000E+03, 1.9873931427E+00, 7.7097390325E+00, 3.0446227594E-02, 2.9870657627E-02, 3.6753148844E-01],
	[5.4250000000E+03, 1.9895679727E+00, 7.7058288756E+00, 3.0531121887E-02, 2.9952802600E-02, 3.6776628265E-01],
	[5.4300000000E+03, 1.9917431759E+00, 7.7019243012E+00, 3.0616174197E-02, 3.0035094821E-02, 3.6800083114E-01],
	[5.4350000000E+03, 1.9939187520E+00, 7.6980252962E+00, 3.0701384673E-02, 3.0117534403E-02, 3.6823513455E-01],
	[5.4400000000E+03, 1.9960947006E+00, 7.6941318477E+00, 3.0786753461E-02, 3.0200121463E-02, 3.6846919350E-01],
	[5.4450000000E+03, 1.9982710215E+00, 7.6902439425E+00, 3.0872280710E-02, 3.0282856113E-02, 3.6870300861E-01],
	[5.4500000000E+03, 2.0004477144E+00, 7.6863615678E+00, 3.0957966567E-02, 3.0365738468E-02, 3.6893658051E-01],
	[5.4550000000E+03, 2.0026247791E+00, 7.6824847105E+00, 3.1043811180E-02, 3.0448768644E-02, 3.6916990982E-01],
	[5.4600000000E+03, 2.0048022152E+00, 7.6786133578E+00, 3.1129814697E-02, 3.0531946752E-02, 3.6940299716E-01],
	[5.4650000000E+03, 2.0069800225E+00, 7.6747474968E+00, 3.1215977265E-02, 3.0615272909E-02, 3.6963584315E-01],
	[5.4700000000E+03, 2.0091582007E+00, 7.6708871148E+00, 3.1302299032E-02, 3.0698747227E-02, 3.6986844841E-01],
	[5.4750000000E+03, 2.0113367495E+00, 7.6670321990E+00, 3.1388780146E-02, 3.0782369821E-02, 3.7010081353E-01],
	[5.4800000000E+03, 2.0135156687E+00, 7.6631827366E+00, 3.1475788850E-02, 3.0866494786E-02, 3.7033293914E-01],
	[5.4850000000E+03, 2.0156949579E+00, 7.6593387150E+00, 3.1563255923E-02, 3.0951055451E-02, 3.7056482583E-01],
	[5.4900000000E+03, 2.0178746170E+00, 7.6555001216E+00, 3.1650885870E-02, 3.1035767598E-02, 3.7079647423E-01],
	[5.4950000000E+03, 2.0200546455E+00, 7.6516669437E+00, 3.1738678844E-02, 3.1120631344E-02, 3.7102788492E-01],
	[5.5000000000E+03, 2.0222350434E+00, 7.6478391687E+00, 3.1826635000E-02, 3.1205646810E-02, 3.7125905851E-01],
	[5.5050000000E+03, 2.0244216178E+00, 7.6440492824E+00, 3.1914754492E-02, 3.1290816046E-02, 3.7148999560E-01],
	[5.5100000000E+03, 2.0266157512E+00, 7.6403048428E+00, 3.2003037474E-02, 3.1376139653E-02, 3.7172069678E-01],
	[5.5150000000E+03, 2.0288102692E+00, 7.6365656312E+00, 3.2091484099E-02, 3.1461615373E-02, 3.7195116265E-01],
	[5.5200000000E+03, 2.0310051716E+00, 7.6328316356E+00, 3.2180094522E-02, 3.1547243324E-02, 3.7218139380E-01],
	[5.5250000000E+03, 2.0332004582E+00, 7.6291028440E+00, 3.2268868897E-02, 3.1633023626E-02, 3.7241139081E-01],
	[5.5300000000E+03, 2.0353961286E+00, 7.6253792444E+00, 3.2357807378E-02, 3.1718956395E-02, 3.7264115429E-01],
	[5.5350000000E+03, 2.0375921826E+00, 7.6216608251E+00, 3.2446910120E-02, 3.1805041752E-02, 3.7287068481E-01],
	[5.5400000000E+03, 2.0397886199E+00, 7.6179475740E+00, 3.2536177275E-02, 3.1891279813E-02, 3.7309998295E-01],
	[5.5450000000E+03, 2.0419854402E+00, 7.6142394793E+00, 3.2625608999E-02, 3.1977670698E-02, 3.7332904930E-01],
	[5.5500000000E+03, 2.0441826432E+00, 7.6105365293E+00, 3.2715205446E-02, 3.2064214524E-02, 3.7355788443E-01],
	[5.5550000000E+03, 2.0463802287E+00, 7.6068387121E+00, 3.2804966769E-02, 3.2150911410E-02, 3.7378648893E-01],
	[5.5600000000E+03, 2.0485781963E+00, 7.6031460161E+00, 3.2894893122E-02, 3.2237761474E-02, 3.7401486336E-01],
	[5.5650000000E+03, 2.0507765459E+00, 7.5994584296E+00, 3.2984984661E-02, 3.2324764833E-02, 3.7424300830E-01],
	[5.5700000000E+03, 2.0529752771E+00, 7.5957759408E+00, 3.3075241538E-02, 3.2411921606E-02, 3.7447092432E-01],
	[5.5750000000E+03, 2.0551743896E+00, 7.5920985383E+00, 3.3165663909E-02, 3.2499231909E-02, 3.7469861199E-01],
	[5.5800000000E+03, 2.0573738832E+00, 7.5884262104E+00, 3.3256251927E-02, 3.2586695862E-02, 3.7492607188E-01],
	[5.5850000000E+03, 2.0595737576E+00, 7.5847589455E+00, 3.3347005746E-02, 3.2674313582E-02, 3.7515330454E-01],
	[5.5900000000E+03, 2.0617740125E+00, 7.5810967323E+00, 3.3437925520E-02, 3.2762085185E-02, 3.7538031055E-01],
	[5.5950000000E+03, 2.0639838157E+00, 7.5774905117E+00, 3.3529011404E-02, 3.2850014071E-02, 3.7560709045E-01],
	[5.6000000000E+03, 2.0661974064E+00, 7.5739080709E+00, 3.3620263552E-02, 3.2938098323E-02, 3.7583364482E-01],
	[5.6050000000E+03, 2.0684113923E+00, 7.5703305186E+00, 3.3711682118E-02, 3.3026336850E-02, 3.7605997420E-01],
	[5.6100000000E+03, 2.0706257734E+00, 7.5667578439E+00, 3.3803267256E-02, 3.3114729769E-02, 3.7628607915E-01],
	[5.6150000000E+03, 2.0728405492E+00, 7.5631900357E+00, 3.3895019120E-02, 3.3203277199E-02, 3.7651196023E-01],
	[5.6200000000E+03, 2.0750557195E+00, 7.5596270832E+00, 3.3986937864E-02, 3.3291979256E-02, 3.7673761798E-01],
	[5.6250000000E+03, 2.0772712840E+00, 7.5560689755E+00, 3.4079023644E-02, 3.3380836057E-02, 3.7696305295E-01],
	[5.6300000000E+03, 2.0794872424E+00, 7.5525157015E+00, 3.4171276611E-02, 3.3469847720E-02, 3.7718826569E-01],
	[5.6350000000E+03, 2.0817035944E+00, 7.5489672506E+00, 3.4263696922E-02, 3.3559014362E-02, 3.7741325674E-01],
	[5.6400000000E+03, 2.0839203398E+00, 7.5454236118E+00, 3.4356284730E-02, 3.3648336099E-02, 3.7763802664E-01],
	[5.6450000000E+03, 2.0861374783E+00, 7.5418847743E+00, 3.4449040189E-02, 3.3737813049E-02, 3.7786257594E-01],
	[5.6500000000E+03, 2.0883550096E+00, 7.5383507276E+00, 3.4541963454E-02, 3.3827445328E-02, 3.7808690526E-01],
	[5.6550000000E+03, 2.0905729334E+00, 7.5348214607E+00, 3.4635054678E-02, 3.3917233053E-02, 3.7831101523E-01],
	[5.6600000000E+03, 2.0927912494E+00, 7.5312969630E+00, 3.4728314016E-02, 3.4007176341E-02, 3.7853490645E-01],
	[5.6650000000E+03, 2.0950099574E+00, 7.5277772239E+00, 3.4821741622E-02, 3.4097275309E-02, 3.7875857951E-01],
	[5.6700000000E+03, 2.0972290572E+00, 7.5242622328E+00, 3.4915337650E-02, 3.4187530071E-02, 3.7898203502E-01],
	[5.6750000000E+03, 2.0994485483E+00, 7.5207519791E+00, 3.5009102255E-02, 3.4277940747E-02, 3.7920527356E-01],
	[5.6800000000E+03, 2.1016684306E+00, 7.5172464522E+00, 3.5103035591E-02, 3.4368507450E-02, 3.7942829573E-01],
	[5.6850000000E+03, 2.1038975277E+00, 7.5137944285E+00, 3.5197137811E-02, 3.4459233692E-02, 3.7965110211E-01],
	[5.6900000000E+03, 2.1061303386E+00, 7.5103653085E+00, 3.5291409071E-02, 3.4550117502E-02, 3.7987369328E-01],
	[5.6950000000E+03, 2.1083635548E+00, 7.5069407634E+00, 3.5385849524E-02, 3.4641157729E-02, 3.8009606983E-01],
	[5.7000000000E+03, 2.1105971761E+00, 7.5035207831E+00, 3.5480459325E-02, 3.4732354488E-02, 3.8031823235E-01],
	[5.7050000000E+03, 2.1128312021E+00, 7.5001053575E+00, 3.5575238627E-02, 3.4823707897E-02, 3.8054018141E-01],
	[5.7100000000E+03, 2.1150656326E+00, 7.4966944765E+00, 3.5670187585E-02, 3.4915218071E-02, 3.8076191758E-01],
	[5.7150000000E+03, 2.1173004673E+00, 7.4932881301E+00, 3.5765306354E-02, 3.5006885127E-02, 3.8098344144E-01],
	[5.7200000000E+03, 2.1195357059E+00, 7.4898863083E+00, 3.5860595087E-02, 3.5098709179E-02, 3.8120475357E-01],
	[5.7250000000E+03, 2.1217713482E+00, 7.4864890012E+00, 3.5956053939E-02, 3.5190690345E-02, 3.8142585453E-01],
	[5.7300000000E+03, 2.1240073937E+00, 7.4830961988E+00, 3.6051683065E-02, 3.5282828739E-02, 3.8164674490E-01],
	[5.7350000000E+03, 2.1262438424E+00, 7.4797078913E+00, 3.6147493558E-02, 3.5375134956E-02, 3.8186742523E-01],
	[5.7400000000E+03, 2.1284806938E+00, 7.4763240687E+00, 3.6243487159E-02, 3.5467610626E-02, 3.8208789609E-01],
	[5.7450000000E+03, 2.1307179477E+00, 7.4729447213E+00, 3.6339651614E-02, 3.5560243981E-02, 3.8230815805E-01],
	[5.7500000000E+03, 2.1329556039E+00, 7.4695698392E+00, 3.6435987079E-02, 3.5653035138E-02, 3.8252821166E-01],
	[5.7550000000E+03, 2.1351936620E+00, 7.4661994127E+00, 3.6532493709E-02, 3.5745984213E-02, 3.8274805748E-01],
	[5.7600000000E+03, 2.1374321218E+00, 7.4628334320E+00, 3.6629171657E-02, 3.5839091320E-02, 3.8296769606E-01],
	[5.7650000000E+03, 2.1396709830E+00, 7.4594718874E+00, 3.6726021078E-02, 3.5932356575E-02, 3.8318712797E-01],
	[5.7700000000E+03, 2.1419102454E+00, 7.4561147693E+00, 3.6823042128E-02, 3.6025780094E-02, 3.8340635375E-01],
	[5.7750000000E+03, 2.1441549963E+00, 7.4527901008E+00, 3.6920234960E-02, 3.6119364093E-02, 3.8362537395E-01],
	[5.7800000000E+03, 2.1464067731E+00, 7.4495062061E+00, 3.7017599730E-02, 3.6213109349E-02, 3.8384418911E-01],
	[5.7850000000E+03, 2.1486589646E+00, 7.4462265959E+00, 3.7115136591E-02, 3.6307013254E-02, 3.8406279979E-01],
	[5.7900000000E+03, 2.1509115705E+00, 7.4429512611E+00, 3.7212845698E-02, 3.6401075924E-02, 3.8428120653E-01],
	[5.7950000000E+03, 2.1531645905E+00, 7.4396801924E+00, 3.7310727207E-02, 3.6495297474E-02, 3.8449940986E-01],
	[5.8000000000E+03, 2.1554180243E+00, 7.4364133804E+00, 3.7408781271E-02, 3.6589678019E-02, 3.8471741033E-01],
	[5.8050000000E+03, 2.1576718717E+00, 7.4331508161E+00, 3.7507008045E-02, 3.6684217674E-02, 3.8493520848E-01],
	[5.8100000000E+03, 2.1599261323E+00, 7.4298924903E+00, 3.7605407684E-02, 3.6778916554E-02, 3.8515280483E-01],
	[5.8150000000E+03, 2.1621808059E+00, 7.4266383938E+00, 3.7703980343E-02, 3.6873774773E-02, 3.8537019994E-01],
	[5.8200000000E+03, 2.1644358922E+00, 7.4233885174E+00, 3.7802726175E-02, 3.6968792447E-02, 3.8558739431E-01],
	[5.8250000000E+03, 2.1666913910E+00, 7.4201428522E+00, 3.7901645337E-02, 3.7063969690E-02, 3.8580438849E-01],
	[5.8300000000E+03, 2.1689473019E+00, 7.4169013890E+00, 3.8000737981E-02, 3.7159306616E-02, 3.8602118301E-01],
	[5.8350000000E+03, 2.1712036246E+00, 7.4136641188E+00, 3.8100004264E-02, 3.7254803341E-02, 3.8623777838E-01],
	[5.8400000000E+03, 2.1734603590E+00, 7.4104310325E+00, 3.8199444339E-02, 3.7350459978E-02, 3.8645417514E-01],
	[5.8450000000E+03, 2.1757175047E+00, 7.4072021213E+00, 3.8299058361E-02, 3.7446276642E-02, 3.8667037380E-01],
	[5.8500000000E+03, 2.1779750614E+00, 7.4039773761E+00, 3.8398846485E-02, 3.7542253446E-02, 3.8688637489E-01],
	[5.8550000000E+03, 2.1802330288E+00, 7.4007567881E+00, 3.8498808866E-02, 3.7638390507E-02, 3.8710217892E-01],
	[5.8600000000E+03, 2.1824914068E+00, 7.3975403482E+00, 3.8598945658E-02, 3.7734687936E-02, 3.8731778641E-01],
	[5.8650000000E+03, 2.1847501950E+00, 7.3943280477E+00, 3.8699257015E-02, 3.7831145849E-02, 3.8753319787E-01],
	[5.8700000000E+03, 2.1870189518E+00, 7.3911723833E+00, 3.8799743094E-02, 3.7927768616E-02, 3.8774841383E-01],
	[5.8750000000E+03, 2.1892898467E+00, 7.3880301671E+00, 3.8900404047E-02, 3.8024552897E-02, 3.8796343478E-01],
	[5.8800000000E+03, 2.1915611647E+00, 7.3848919581E+00, 3.9001240031E-02, 3.8121498045E-02, 3.8817826125E-01],
	[5.8850000000E+03, 2.1938329056E+00, 7.3817577479E+00, 3.9102251198E-02, 3.8218604172E-02, 3.8839289373E-01],
	[5.8900000000E+03, 2.1961050690E+00, 7.3786275279E+00, 3.9203437706E-02, 3.8315871393E-02, 3.8860733273E-01],
	[5.8950000000E+03, 2.1983776548E+00, 7.3755012897E+00, 3.9304799707E-02, 3.8413299823E-02, 3.8882157875E-01],
	[5.9000000000E+03, 2.2006506625E+00, 7.3723790248E+00, 3.9406337356E-02, 3.8510889573E-02, 3.8903563231E-01],
	[5.9050000000E+03, 2.2029240919E+00, 7.3692607249E+00, 3.9508050809E-02, 3.8608640758E-02, 3.8924949389E-01],
	[5.9100000000E+03, 2.2051979428E+00, 7.3661463815E+00, 3.9609940220E-02, 3.8706553492E-02, 3.8946316400E-01],
	[5.9150000000E+03, 2.2074722149E+00, 7.3630359863E+00, 3.9712005744E-02, 3.8804627887E-02, 3.8967664313E-01],
	[5.9200000000E+03, 2.2097469079E+00, 7.3599295310E+00, 3.9814247535E-02, 3.8902864057E-02, 3.8988993179E-01],
	[5.9250000000E+03, 2.2120220214E+00, 7.3568270072E+00, 3.9916665748E-02, 3.9001262116E-02, 3.9010303045E-01],
	[5.9300000000E+03, 2.2142975553E+00, 7.3537284066E+00, 4.0019260538E-02, 3.9099822175E-02, 3.9031593962E-01],
	[5.9350000000E+03, 2.2165735093E+00, 7.3506337211E+00, 4.0122032060E-02, 3.9198544349E-02, 3.9052865978E-01],
	[5.9400000000E+03, 2.2188498830E+00, 7.3475429423E+00, 4.0224980467E-02, 3.9297428751E-02, 3.9074119143E-01],
	[5.9450000000E+03, 2.2211266762E+00, 7.3444560620E+00, 4.0328105916E-02, 3.9396475492E-02, 3.9095353505E-01],
	[5.9500000000E+03, 2.2234038887E+00, 7.3413730721E+00, 4.0431408561E-02, 3.9495684686E-02, 3.9116569112E-01],
	[5.9550000000E+03, 2.2256815201E+00, 7.3382939643E+00, 4.0534888556E-02, 3.9595056446E-02, 3.9137765998E-01],
	[5.9600000000E+03, 2.2279595702E+00, 7.3352187306E+00, 4.0638546056E-02, 3.9694590884E-02, 3.9158944204E-01],
	[5.9650000000E+03, 2.2302484675E+00, 7.3322045702E+00, 4.0742381217E-02, 3.9794293118E-02, 3.9180103782E-01],
	[5.9700000000E+03, 2.2325382116E+00, 7.3291964507E+00, 4.0846394192E-02, 3.9894158496E-02, 3.9201244787E-01],
	[5.9750000000E+03, 2.2348283866E+00, 7.3261920820E+00, 4.0950585136E-02, 3.9994186933E-02, 3.9222367272E-01],
	[5.9800000000E+03, 2.2371189923E+00, 7.3231914564E+00, 4.1054954205E-02, 4.0094378540E-02, 3.9243471288E-01],
	[5.9850000000E+03, 2.2394100284E+00, 7.3201945661E+00, 4.1159501553E-02, 4.0194733429E-02, 3.9264556890E-01],
	[5.9900000000E+03, 2.2417014947E+00, 7.3172014033E+00, 4.1264227334E-02, 4.0295251714E-02, 3.9285624130E-01],
	[5.9950000000E+03, 2.2439933908E+00, 7.3142119603E+00, 4.1369131704E-02, 4.0395933507E-02, 3.9306673059E-01],
	[6.0000000000E+03, 2.2462857165E+00, 7.3112262294E+00, 4.1474214818E-02, 4.0496778919E-02, 3.9327703730E-01],
	[6.0050000000E+03, 2.2485784715E+00, 7.3082442027E+00, 4.1579960898E-02, 4.0598249544E-02, 3.9348716196E-01],
	[6.0100000000E+03, 2.2508716555E+00, 7.3052658728E+00, 4.1685888097E-02, 4.0699885900E-02, 3.9369710507E-01],
	[6.0150000000E+03, 2.2531652682E+00, 7.3022912319E+00, 4.1791996572E-02, 4.0801688102E-02, 3.9390686716E-01],
	[6.0200000000E+03, 2.2554593094E+00, 7.2993202724E+00, 4.1898286482E-02, 4.0903656265E-02, 3.9411644873E-01],
	[6.0250000000E+03, 2.2577537788E+00, 7.2963529867E+00, 4.2004757986E-02, 4.1005790504E-02, 3.9432585031E-01],
	[6.0300000000E+03, 2.2600486761E+00, 7.2933893672E+00, 4.2111411243E-02, 4.1108090934E-02, 3.9453507240E-01],
	[6.0350000000E+03, 2.2623440011E+00, 7.2904294063E+00, 4.2218246411E-02, 4.1210557669E-02, 3.9474411551E-01],
	[6.0400000000E+03, 2.2646397534E+00, 7.2874730965E+00, 4.2325263650E-02, 4.1313190823E-02, 3.9495298014E-01],
	[6.0450000000E+03, 2.2669359328E+00, 7.2845204303E+00, 4.2432463118E-02, 4.1415990512E-02, 3.9516166680E-01],
	[6.0500000000E+03, 2.2692325390E+00, 7.2815714002E+00, 4.2539844973E-02, 4.1518956850E-02, 3.9537017600E-01],
	[6.0550000000E+03, 2.2715295718E+00, 7.2786259987E+00, 4.2647409375E-02, 4.1622089950E-02, 3.9557850823E-01],
	[6.0600000000E+03, 2.2738350952E+00, 7.2757282790E+00, 4.2755156482E-02, 4.1725394092E-02, 3.9578666400E-01],
	[6.0650000000E+03, 2.2761434444E+00, 7.2728471426E+00, 4.2863086453E-02, 4.1828866498E-02, 3.9599464380E-01],
	[6.0700000000E+03, 2.2784522319E+00, 7.2699695200E+00, 4.2971199448E-02, 4.1932506053E-02, 3.9620244813E-01],
	[6.0750000000E+03, 2.2807614574E+00, 7.2670954039E+00, 4.3079495624E-02, 4.2036312870E-02, 3.9641007748E-01],
	[6.0800000000E+03, 2.2830711207E+00, 7.2642247872E+00, 4.3187975140E-02, 4.2140287066E-02, 3.9661753235E-01],
	[6.0850000000E+03, 2.2853812213E+00, 7.2613576627E+00, 4.3296638156E-02, 4.2244428752E-02, 3.9682481323E-01],
	[6.0900000000E+03, 2.2876917591E+00, 7.2584940235E+00, 4.3405484830E-02, 4.2348738044E-02, 3.9703192060E-01],
	[6.0950000000E+03, 2.2900027338E+00, 7.2556338623E+00, 4.3514515320E-02, 4.2453215054E-02, 3.9723885495E-01],
	[6.1000000000E+03, 2.2923141451E+00, 7.2527771721E+00, 4.3623729787E-02, 4.2557859897E-02, 3.9744561677E-01],
	[6.1050000000E+03, 2.2946259928E+00, 7.2499239459E+00, 4.3733128388E-02, 4.2662672687E-02, 3.9765220654E-01],
	[6.1100000000E+03, 2.2969382765E+00, 7.2470741765E+00, 4.3842711282E-02, 4.2767653537E-02, 3.9785862475E-01],
	[6.1150000000E+03, 2.2992509959E+00, 7.2442278571E+00, 4.3952478629E-02, 4.2872802559E-02, 3.9806487187E-01],
	[6.1200000000E+03, 2.3015641509E+00, 7.2413849806E+00, 4.4062430587E-02, 4.2978119869E-02, 3.9827094839E-01],
	[6.1250000000E+03, 2.3038777411E+00, 7.2385455400E+00, 4.4172567315E-02, 4.3083605579E-02, 3.9847685478E-01],
	[6.1300000000E+03, 2.3061917662E+00, 7.2357095284E+00, 4.4282888971E-02, 4.3189259802E-02, 3.9868259151E-01],
	[6.1350000000E+03, 2.3085062261E+00, 7.2328769388E+00, 4.4393395716E-02, 4.3295082651E-02, 3.9888815907E-01],
	[6.1400000000E+03, 2.3108211203E+00, 7.2300477644E+00, 4.4504087707E-02, 4.3401074240E-02, 3.9909355792E-01],
	[6.1450000000E+03, 2.3131364487E+00, 7.2272219983E+00, 4.4614965103E-02, 4.3507234681E-02, 3.9929878854E-01],
	[6.1500000000E+03, 2.3154522110E+00, 7.2243996335E+00, 4.4726028064E-02, 4.3613564087E-02, 3.9950385138E-01],
	[6.1550000000E+03, 2.3177711554E+00, 7.2215955897E+00, 4.4837276748E-02, 4.3720064097E-02, 3.9970874693E-01],
	[6.1600000000E+03, 2.3200978845E+00, 7.2188347596E+00, 4.4948711314E-02, 4.3826737400E-02, 3.9991347565E-01],
	[6.1650000000E+03, 2.3224250586E+00, 7.2160772237E+00, 4.5060331921E-02, 4.3933580050E-02, 4.0011803800E-01],
	[6.1700000000E+03, 2.3247526775E+00, 7.2133229755E+00, 4.5172138728E-02, 4.4040592162E-02, 4.0032243444E-01],
	[6.1750000000E+03, 2.3270807409E+00, 7.2105720082E+00, 4.5284131894E-02, 4.4147773846E-02, 4.0052666544E-01],
	[6.1800000000E+03, 2.3294092486E+00, 7.2078243155E+00, 4.5396311578E-02, 4.4255125217E-02, 4.0073073145E-01],
	[6.1850000000E+03, 2.3317382002E+00, 7.2050798906E+00, 4.5508677938E-02, 4.4362646385E-02, 4.0093463293E-01],
	[6.1900000000E+03, 2.3340675956E+00, 7.2023387272E+00, 4.5621231134E-02, 4.4470337465E-02, 4.0113837035E-01],
	[6.1950000000E+03, 2.3363974343E+00, 7.1996008187E+00, 4.5733971325E-02, 4.4578198566E-02, 4.0134194415E-01],
	[6.2000000000E+03, 2.3387277162E+00, 7.1968661586E+00, 4.5846898669E-02, 4.4686229803E-02, 4.0154535479E-01],
	[6.2050000000E+03, 2.3410584409E+00, 7.1941347404E+00, 4.5960013326E-02, 4.4794431287E-02, 4.0174860272E-01],
	[6.2100000000E+03, 2.3433896083E+00, 7.1914065578E+00, 4.6073315454E-02, 4.4902803131E-02, 4.0195168840E-01],
	[6.2150000000E+03, 2.3457212180E+00, 7.1886816042E+00, 4.6186805213E-02, 4.5011345445E-02, 4.0215461226E-01],
	[6.2200000000E+03, 2.3480532697E+00, 7.1859598732E+00, 4.6300482761E-02, 4.5120058342E-02, 4.0235737476E-01],
	[6.2250000000E+03, 2.3503857632E+00, 7.1832413585E+00, 4.6414348257E-02, 4.5228941933E-02, 4.0255997635E-01],
	[6.2300000000E+03, 2.3527186982E+00, 7.1805260537E+00, 4.6528401860E-02, 4.5337996331E-02, 4.0276241746E-01],
	[6.2350000000E+03, 2.3550520745E+00, 7.1778139524E+00, 4.6642643730E-02, 4.5447221646E-02, 4.0296469854E-01],
	[6.2400000000E+03, 2.3573858917E+00, 7.1751050482E+00, 4.6757074025E-02, 4.5556617991E-02, 4.0316682004E-01],
	[6.2450000000E+03, 2.3597201496E+00, 7.1723993349E+00, 4.6871692905E-02, 4.5666185477E-02, 4.0336878240E-01],
	[6.2500000000E+03, 2.3620548480E+00, 7.1696968061E+00, 4.6986500528E-02, 4.5775924214E-02, 4.0357058604E-01],
	[6.2550000000E+03, 2.3643944576E+00, 7.1670215951E+00, 4.7101497053E-02, 4.5885836987E-02, 4.0377223142E-01],
	[6.2600000000E+03, 2.3667397790E+00, 7.1643779142E+00, 4.7216682639E-02, 4.5995924416E-02, 4.0397371896E-01],
	[6.2650000000E+03, 2.3690855515E+00, 7.1617373180E+00, 4.7332057446E-02, 4.6106183475E-02, 4.0417504910E-01],
	[6.2700000000E+03, 2.3714317748E+00, 7.1590998004E+00, 4.7447621632E-02, 4.6216614277E-02, 4.0437622228E-01],
	[6.2750000000E+03, 2.3737784487E+00, 7.1564653555E+00, 4.7563375356E-02, 4.6327216931E-02, 4.0457723892E-01],
	[6.2800000000E+03, 2.3761255728E+00, 7.1538339772E+00, 4.7679318779E-02, 4.6437991550E-02, 4.0477809946E-01],
	[6.2850000000E+03, 2.3784731470E+00, 7.1512056595E+00, 4.7795452057E-02, 4.6548938243E-02, 4.0497880432E-01],
	[6.2900000000E+03, 2.3808211709E+00, 7.1485803964E+00, 4.7911775351E-02, 4.6660057123E-02, 4.0517935393E-01],
	[6.2950000000E+03, 2.3831696443E+00, 7.1459581819E+00, 4.8028288820E-02, 4.6771348298E-02, 4.0537974873E-01],
	[6.3000000000E+03, 2.3855185669E+00, 7.1433390101E+00, 4.8144992622E-02, 4.6882811881E-02, 4.0557998912E-01],
	[6.3050000000E+03, 2.3878679384E+00, 7.1407228750E+00, 4.8261886917E-02, 4.6994447981E-02, 4.0578007554E-01],
	[6.3100000000E+03, 2.3902177585E+00, 7.1381097708E+00, 4.8378971864E-02, 4.7106256710E-02, 4.0598000842E-01],
	[6.3150000000E+03, 2.3925680271E+00, 7.1354996914E+00, 4.8496247622E-02, 4.7218238176E-02, 4.0617978816E-01],
	[6.3200000000E+03, 2.3949187437E+00, 7.1328926311E+00, 4.8613714350E-02, 4.7330392491E-02, 4.0637941519E-01],
	[6.3250000000E+03, 2.3972699083E+00, 7.1302885838E+00, 4.8731372206E-02, 4.7442719764E-02, 4.0657888992E-01],
	[6.3300000000E+03, 2.3996215204E+00, 7.1276875439E+00, 4.8849221351E-02, 4.7555220107E-02, 4.0677821279E-01],
	[6.3350000000E+03, 2.4019735798E+00, 7.1250895053E+00, 4.8967261944E-02, 4.7667893627E-02, 4.0697738419E-01],
	[6.3400000000E+03, 2.4043260862E+00, 7.1224944624E+00, 4.9085494142E-02, 4.7780740437E-02, 4.0717640454E-01],
	[6.3450000000E+03, 2.4066790394E+00, 7.1199024093E+00, 4.9203918106E-02, 4.7893760644E-02, 4.0737527426E-01],
	[6.3500000000E+03, 2.4090324392E+00, 7.1173133401E+00, 4.9322533995E-02, 4.8006954360E-02, 4.0757399376E-01],
	[6.3550000000E+03, 2.4113893530E+00, 7.1147437455E+00, 4.9441341968E-02, 4.8120323669E-02, 4.0777256345E-01],
	[6.3600000000E+03, 2.4137530252E+00, 7.1122109777E+00, 4.9560342183E-02, 4.8233870798E-02, 4.0797098373E-01],
	[6.3650000000E+03, 2.4161171542E+00, 7.1096811009E+00, 4.9679534800E-02, 4.8347591810E-02, 4.0816925502E-01],
	[6.3700000000E+03, 2.4184817395E+00, 7.1071541095E+00, 4.9798919979E-02, 4.8461486815E-02, 4.0836737772E-01],
	[6.3750000000E+03, 2.4208467809E+00, 7.1046299979E+00, 4.9918497878E-02, 4.8575555922E-02, 4.0856535224E-01],
	[6.3800000000E+03, 2.4232122783E+00, 7.1021087606E+00, 5.0038268656E-02, 4.8689799240E-02, 4.0876317898E-01],
	[6.3850000000E+03, 2.4255782311E+00, 7.0995903921E+00, 5.0158232473E-02, 4.8804216880E-02, 4.0896085834E-01],
	[6.3900000000E+03, 2.4279446393E+00, 7.0970748869E+00, 5.0278389487E-02, 4.8918808949E-02, 4.0915839073E-01],
	[6.3950000000E+03, 2.4303115026E+00, 7.0945622395E+00, 5.0398739859E-02, 4.9033575557E-02, 4.0935577654E-01],
	[6.4000000000E+03, 2.4326788206E+00, 7.0920524443E+00, 5.0519283747E-02, 4.9148516813E-02, 4.0955301618E-01],
	[6.4050000000E+03, 2.4350465932E+00, 7.0895454961E+00, 5.0640021310E-02, 4.9263632826E-02, 4.0975011004E-01],
	[6.4100000000E+03, 2.4374148200E+00, 7.0870413892E+00, 5.0760952707E-02, 4.9378923705E-02, 4.0994705851E-01],
	[6.4150000000E+03, 2.4397835007E+00, 7.0845401183E+00, 5.0882078099E-02, 4.9494389558E-02, 4.1014386200E-01],
	[6.4200000000E+03, 2.4421526352E+00, 7.0820416779E+00, 5.1003397643E-02, 4.9610030494E-02, 4.1034052090E-01],
	[6.4250000000E+03, 2.4445222231E+00, 7.0795460627E+00, 5.1124911499E-02, 4.9725846621E-02, 4.1053703560E-01],
	[6.4300000000E+03, 2.4468922642E+00, 7.0770532672E+00, 5.1246619827E-02, 4.9841838048E-02, 4.1073340649E-01],
	[6.4350000000E+03, 2.4492627582E+00, 7.0745632861E+00, 5.1368522785E-02, 4.9958004884E-02, 4.1092963397E-01],
	[6.4400000000E+03, 2.4516337049E+00, 7.0720761140E+00, 5.1490620533E-02, 5.0074347235E-02, 4.1112571842E-01],
	[6.4450000000E+03, 2.4540051039E+00, 7.0695917456E+00, 5.1612913230E-02, 5.0190865211E-02, 4.1132166023E-01],
	[6.4500000000E+03, 2.4563769550E+00, 7.0671101756E+00, 5.1735401035E-02, 5.0307558920E-02, 4.1151745978E-01],
	[6.4550000000E+03, 2.4587492580E+00, 7.0646313985E+00, 5.1858084107E-02, 5.0424428469E-02, 4.1171311747E-01],
	[6.4600000000E+03, 2.4611298646E+00, 7.0621974876E+00, 5.1980962606E-02, 5.0541479434E-02, 4.1190863368E-01],
	[6.4650000000E+03, 2.4635120932E+00, 7.0597725137E+00, 5.2104036692E-02, 5.0658707307E-02, 4.1210400880E-01],
	[6.4700000000E+03, 2.4658947832E+00, 7.0573502462E+00, 5.2227306522E-02, 5.0776111392E-02, 4.1229924319E-01],
	[6.4750000000E+03, 2.4682779344E+00, 7.0549306801E+00, 5.2350772257E-02, 5.0893691796E-02, 4.1249433726E-01],
	[6.4800000000E+03, 2.4706615466E+00, 7.0525138103E+00, 5.2474434056E-02, 5.1011448628E-02, 4.1268929137E-01],
	[6.4850000000E+03, 2.4730456195E+00, 7.0500996316E+00, 5.2598295098E-02, 5.1129384848E-02, 4.1288410590E-01],
	[6.4900000000E+03, 2.4754301529E+00, 7.0476881389E+00, 5.2722353060E-02, 5.1247498219E-02, 4.1307878124E-01],
	[6.4950000000E+03, 2.4778151463E+00, 7.0452793274E+00, 5.2846607579E-02, 5.1365788352E-02, 4.1327331776E-01],
	[6.5000000000E+03, 2.4802005997E+00, 7.0428731918E+00, 5.2971058813E-02, 5.1484255356E-02, 4.1346771584E-01],
	[6.5050000000E+03, 2.4825865127E+00, 7.0404697272E+00, 5.3095706921E-02, 5.1602899337E-02, 4.1366197585E-01],
	[6.5100000000E+03, 2.4849728851E+00, 7.0380689285E+00, 5.3220552064E-02, 5.1721720403E-02, 4.1385609816E-01],
	[6.5150000000E+03, 2.4873597165E+00, 7.0356707908E+00, 5.3345594401E-02, 5.1840718660E-02, 4.1405008315E-01],
	[6.5200000000E+03, 2.4897470068E+00, 7.0332753091E+00, 5.3470834090E-02, 5.1959894216E-02, 4.1424393121E-01],
	[6.5250000000E+03, 2.4921347557E+00, 7.0308824783E+00, 5.3596271291E-02, 5.2079247177E-02, 4.1443764297E-01],
	[6.5300000000E+03, 2.4945229628E+00, 7.0284922936E+00, 5.3721906163E-02, 5.2198777651E-02, 4.1463121884E-01],
	[6.5350000000E+03, 2.4969116280E+00, 7.0261047500E+00, 5.3847738867E-02, 5.2318485743E-02, 4.1482465921E-01],
	[6.5400000000E+03, 2.4993007510E+00, 7.0237198425E+00, 5.3973769560E-02, 5.2438371561E-02, 4.1501796447E-01],
	[6.5450000000E+03, 2.5016903315E+00, 7.0213375662E+00, 5.4099998403E-02, 5.2558435210E-02, 4.1521113502E-01],
	[6.5500000000E+03, 2.5040803693E+00, 7.0189579163E+00, 5.4226425555E-02, 5.2678676799E-02, 4.1540417122E-01],
	[6.5550000000E+03, 2.5064708640E+00, 7.0165808877E+00, 5.4353051176E-02, 5.2799096431E-02, 4.1559707348E-01],
	[6.5600000000E+03, 2.5088625570E+00, 7.0142104492E+00, 5.4479875424E-02, 5.2919694771E-02, 4.1578984217E-01],
	[6.5650000000E+03, 2.5112626138E+00, 7.0118849325E+00, 5.4606898459E-02, 5.3040477320E-02, 4.1598247767E-01],
	[6.5700000000E+03, 2.5136631368E+00, 7.0095619564E+00, 5.4734120441E-02, 5.3161438280E-02, 4.1617498037E-01],
	[6.5750000000E+03, 2.5160641256E+00, 7.0072415162E+00, 5.4861541528E-02, 5.3282577759E-02, 4.1636735064E-01],
	[6.5800000000E+03, 2.5184655800E+00, 7.0049236072E+00, 5.4989161881E-02, 5.3403895862E-02, 4.1655958886E-01],
	[6.5850000000E+03, 2.5208674997E+00, 7.0026082248E+00, 5.5116981658E-02, 5.3525392694E-02, 4.1675169542E-01],
	[6.5900000000E+03, 2.5232698845E+00, 7.0002953641E+00, 5.5245001020E-02, 5.3647068362E-02, 4.1694367068E-01],
	[6.5950000000E+03, 2.5256727342E+00, 6.9979850207E+00, 5.5373220125E-02, 5.3768922972E-02, 4.1713551503E-01],
	[6.6000000000E+03, 2.5280760483E+00, 6.9956771899E+00, 5.5501639133E-02, 5.3890956628E-02, 4.1732722883E-01],
	[6.6050000000E+03, 2.5304798268E+00, 6.9933718669E+00, 5.5630258203E-02, 5.4013169437E-02, 4.1751881246E-01],
	[6.6100000000E+03, 2.5328840692E+00, 6.9910690472E+00, 5.5759077496E-02, 5.4135561505E-02, 4.1771026629E-01],
	[6.6150000000E+03, 2.5352887754E+00, 6.9887687263E+00, 5.5888097169E-02, 5.4258132935E-02, 4.1790159070E-01],
	[6.6200000000E+03, 2.5376939452E+00, 6.9864708994E+00, 5.6017317383E-02, 5.4380883835E-02, 4.1809278604E-01],
	[6.6250000000E+03, 2.5400995781E+00, 6.9841755620E+00, 5.6146738298E-02, 5.4503814308E-02, 4.1828385270E-01],
	[6.6300000000E+03, 2.5425056740E+00, 6.9818827096E+00, 5.6276360072E-02, 5.4626924460E-02, 4.1847479103E-01],
	[6.6350000000E+03, 2.5449122327E+00, 6.9795923376E+00, 5.6406182865E-02, 5.4750214396E-02, 4.1866560140E-01],
	[6.6400000000E+03, 2.5473192538E+00, 6.9773044413E+00, 5.6536206837E-02, 5.4873684221E-02, 4.1885628419E-01],
	[6.6450000000E+03, 2.5497267371E+00, 6.9750190164E+00, 5.6666432147E-02, 5.4997334039E-02, 4.1904683975E-01],
	[6.6500000000E+03, 2.5521346823E+00, 6.9727360582E+00, 5.6796858955E-02, 5.5121163956E-02, 4.1923726844E-01],
	[6.6550000000E+03, 2.5545430893E+00, 6.9704555623E+00, 5.6927487419E-02, 5.5245174075E-02, 4.1942757063E-01],
	[6.6600000000E+03, 2.5569519576E+00, 6.9681775241E+00, 5.7058317701E-02, 5.5369364502E-02, 4.1961774668E-01],
	[6.6650000000E+03, 2.5593612871E+00, 6.9659019391E+00, 5.7189349958E-02, 5.5493735340E-02, 4.1980779694E-01],
	[6.6700000000E+03, 2.5617790738E+00, 6.9636716412E+00, 5.7320584350E-02, 5.5618293197E-02, 4.1999772179E-01],
	[6.6750000000E+03, 2.5641976139E+00, 6.9614452460E+00, 5.7452021038E-02, 5.5743031952E-02, 4.2018752157E-01],
	[6.6800000000E+03, 2.5666166238E+00, 6.9592212288E+00, 5.7583660181E-02, 5.5867951483E-02, 4.2037719664E-01],
	[6.6850000000E+03, 2.5690361033E+00, 6.9569995855E+00, 5.7715501937E-02, 5.5993051891E-02, 4.2056674735E-01],
	[6.6900000000E+03, 2.5714560520E+00, 6.9547803116E+00, 5.7847546467E-02, 5.6118333283E-02, 4.2075617407E-01],
	[6.6950000000E+03, 2.5738764697E+00, 6.9525634029E+00, 5.7979793931E-02, 5.6243795760E-02, 4.2094547715E-01],
	[6.7000000000E+03, 2.5762973561E+00, 6.9503488551E+00, 5.8112244487E-02, 5.6369439429E-02, 4.2113465693E-01],
	[6.7050000000E+03, 2.5787187110E+00, 6.9481366639E+00, 5.8244898295E-02, 5.6495264392E-02, 4.2132371377E-01],
	[6.7100000000E+03, 2.5811405342E+00, 6.9459268251E+00, 5.8377755515E-02, 5.6621270753E-02, 4.2151264803E-01],
	[6.7150000000E+03, 2.5835628253E+00, 6.9437193344E+00, 5.8510816306E-02, 5.6747458616E-02, 4.2170146004E-01],
	[6.7200000000E+03, 2.5859855841E+00, 6.9415141875E+00, 5.8644080829E-02, 5.6873828084E-02, 4.2189015016E-01],
	[6.7250000000E+03, 2.5884088104E+00, 6.9393113803E+00, 5.8777549241E-02, 5.7000379261E-02, 4.2207871874E-01],
	[6.7300000000E+03, 2.5908325039E+00, 6.9371109086E+00, 5.8911221704E-02, 5.7127112249E-02, 4.2226716612E-01],
	[6.7350000000E+03, 2.5932566643E+00, 6.9349127680E+00, 5.9045098377E-02, 5.7254027153E-02, 4.2245549265E-01],
	[6.7400000000E+03, 2.5956812914E+00, 6.9327169545E+00, 5.9179179418E-02, 5.7381124076E-02, 4.2264369867E-01],
	[6.7450000000E+03, 2.5981063849E+00, 6.9305234638E+00, 5.9313464989E-02, 5.7508403120E-02, 4.2283178453E-01],
	[6.7500000000E+03, 2.6005319446E+00, 6.9283322917E+00, 5.9447955248E-02, 5.7635864388E-02, 4.2301975056E-01],
	[6.7550000000E+03, 2.6029579702E+00, 6.9261434341E+00, 5.9582650355E-02, 5.7763507984E-02, 4.2320759712E-01],
	[6.7600000000E+03, 2.6053844615E+00, 6.9239568869E+00, 5.9717550469E-02, 5.7891334009E-02, 4.2339532454E-01],
	[6.7650000000E+03, 2.6078114181E+00, 6.9217726458E+00, 5.9852655751E-02, 5.8019342567E-02, 4.2358293316E-01],
	[6.7700000000E+03, 2.6102388399E+00, 6.9195907068E+00, 5.9987966359E-02, 5.8147533760E-02, 4.2377042332E-01],
	[6.7750000000E+03, 2.6126707254E+00, 6.9174325623E+00, 6.0123482454E-02, 5.8275911206E-02, 4.2395779536E-01],
	[6.7800000000E+03, 2.6151069906E+00, 6.9152976788E+00, 6.0259204195E-02, 5.8404474965E-02, 4.2414504962E-01],
	[6.7850000000E+03, 2.6175437291E+00, 6.9131650272E+00, 6.0395131742E-02, 5.8533221718E-02, 4.2433218642E-01],
	[6.7900000000E+03, 2.6199809406E+00, 6.9110346036E+00, 6.0531265254E-02, 5.8662151566E-02, 4.2451920612E-01],
	[6.7950000000E+03, 2.6224186248E+00, 6.9089064040E+00, 6.0667604891E-02, 5.8791264612E-02, 4.2470610903E-01],
	[6.8000000000E+03, 2.6248567816E+00, 6.9067804244E+00, 6.0804150812E-02, 5.8920560958E-02, 4.2489289550E-01],
	[6.8050000000E+03, 2.6272954105E+00, 6.9046566610E+00, 6.0940903178E-02, 5.9050040705E-02, 4.2507956585E-01],
	[6.8100000000E+03, 2.6297345115E+00, 6.9025351098E+00, 6.1077862148E-02, 5.9179703957E-02, 4.2526612043E-01],
	[6.8150000000E+03, 2.6321740842E+00, 6.9004157669E+00, 6.1215027881E-02, 5.9309550814E-02, 4.2545255955E-01],
	[6.8200000000E+03, 2.6346141283E+00, 6.8982986283E+00, 6.1352400538E-02, 5.9439581379E-02, 4.2563888355E-01],
	[6.8250000000E+03, 2.6370546437E+00, 6.8961836901E+00, 6.1489980278E-02, 5.9569795753E-02, 4.2582509276E-01],
	[6.8300000000E+03, 2.6394956300E+00, 6.8940709485E+00, 6.1627767260E-02, 5.9700194038E-02, 4.2601118750E-01],
	[6.8350000000E+03, 2.6419370871E+00, 6.8919603995E+00, 6.1765761644E-02, 5.9830776335E-02, 4.2619716810E-01],
	[6.8400000000E+03, 2.6443790146E+00, 6.8898520393E+00, 6.1903963591E-02, 5.9961542745E-02, 4.2638303490E-01],
	[6.8450000000E+03, 2.6468214123E+00, 6.8877458640E+00, 6.2042373259E-02, 6.0092493370E-02, 4.2656878821E-01],
	[6.8500000000E+03, 2.6492642800E+00, 6.8856418698E+00, 6.2180990808E-02, 6.0223628312E-02, 4.2675442835E-01],
	[6.8550000000E+03, 2.6517076173E+00, 6.8835400527E+00, 6.2319816399E-02, 6.0354947670E-02, 4.2693995566E-01],
	[6.8600000000E+03, 2.6541514241E+00, 6.8814404091E+00, 6.2458850190E-02, 6.0486451546E-02, 4.2712537045E-01],
	[6.8650000000E+03, 2.6565957001E+00, 6.8793429350E+00, 6.2598092342E-02, 6.0618140041E-02, 4.2731067305E-01],
	[6.8700000000E+03, 2.6590404451E+00, 6.8772476265E+00, 6.2737543014E-02, 6.0750013256E-02, 4.2749586377E-01],
	[6.8750000000E+03, 2.6614856587E+00, 6.8751544800E+00, 6.2877202366E-02, 6.0882071291E-02, 4.2768094295E-01],
	[6.8800000000E+03, 2.6639313408E+00, 6.8730634916E+00, 6.3017070558E-02, 6.1014314246E-02, 4.2786591089E-01],
	[6.8850000000E+03, 2.6663827669E+00, 6.8710031589E+00, 6.3157147749E-02, 6.1146747255E-02, 4.2805076791E-01],
	[6.8900000000E+03, 2.6688369270E+00, 6.8689571338E+00, 6.3297434100E-02, 6.1279367583E-02, 4.2823551434E-01],
	[6.8950000000E+03, 2.6712915632E+00, 6.8669132016E+00, 6.3437929769E-02, 6.1412173186E-02, 4.2842015049E-01],
	[6.9000000000E+03, 2.6737466752E+00, 6.8648713585E+00, 6.3578634917E-02, 6.1545164162E-02, 4.2860467667E-01],
	[6.9050000000E+03, 2.6762022628E+00, 6.8628316010E+00, 6.3719549703E-02, 6.1678340613E-02, 4.2878909320E-01],
	[6.9100000000E+03, 2.6786583256E+00, 6.8607939254E+00, 6.3860674288E-02, 6.1811702639E-02, 4.2897340040E-01],
	[6.9150000000E+03, 2.6811148635E+00, 6.8587583281E+00, 6.4002008830E-02, 6.1945250339E-02, 4.2915759858E-01],
	[6.9200000000E+03, 2.6835718762E+00, 6.8567248054E+00, 6.4143553490E-02, 6.2078983814E-02, 4.2934168805E-01],
	[6.9250000000E+03, 2.6860293634E+00, 6.8546933537E+00, 6.4285308428E-02, 6.2212903164E-02, 4.2952566912E-01],
	[6.9300000000E+03, 2.6884873250E+00, 6.8526639695E+00, 6.4427273803E-02, 6.2347008487E-02, 4.2970954211E-01],
	[6.9350000000E+03, 2.6909457605E+00, 6.8506366491E+00, 6.4569449775E-02, 6.2481299885E-02, 4.2989330732E-01],
	[6.9400000000E+03, 2.6934046699E+00, 6.8486113890E+00, 6.4711836504E-02, 6.2615777456E-02, 4.3007696507E-01],
	[6.9450000000E+03, 2.6958640528E+00, 6.8465881855E+00, 6.4854434150E-02, 6.2750441300E-02, 4.3026051566E-01],
	[6.9500000000E+03, 2.6983239090E+00, 6.8445670351E+00, 6.4997242872E-02, 6.2885291516E-02, 4.3044395940E-01],
	[6.9550000000E+03, 2.7007842383E+00, 6.8425479343E+00, 6.5140262830E-02, 6.3020328203E-02, 4.3062729660E-01],
	[6.9600000000E+03, 2.7032450403E+00, 6.8405308796E+00, 6.5283494185E-02, 6.3155551461E-02, 4.3081052757E-01],
	[6.9650000000E+03, 2.7057063149E+00, 6.8385158672E+00, 6.5426937095E-02, 6.3290961389E-02, 4.3099365261E-01],
	[6.9700000000E+03, 2.7081680618E+00, 6.8365028938E+00, 6.5570591721E-02, 6.3426558085E-02, 4.3117667202E-01],
	[6.9750000000E+03, 2.7106302807E+00, 6.8344919558E+00, 6.5714458223E-02, 6.3562341649E-02, 4.3135958611E-01],
	[6.9800000000E+03, 2.7130929715E+00, 6.8324830497E+00, 6.5858536760E-02, 6.3698312178E-02, 4.3154239518E-01],
	[6.9850000000E+03, 2.7155561338E+00, 6.8304761720E+00, 6.6002827493E-02, 6.3834469773E-02, 4.3172509954E-01],
	[6.9900000000E+03, 2.7180197674E+00, 6.8284713192E+00, 6.6147330580E-02, 6.3970814530E-02, 4.3190769949E-01],
	[6.9950000000E+03, 2.7204877716E+00, 6.8264896761E+00, 6.6292046183E-02, 6.4107350584E-02, 4.3209019532E-01],
	[7.0000000000E+03, 2.7229595261E+00, 6.8245277980E+00, 6.6436974460E-02, 6.4244077424E-02, 4.3227258735E-01],
	[7.0050000000E+03, 2.7254317591E+00, 6.8225678840E+00, 6.6583544476E-02, 6.4382327764E-02, 4.3245487586E-01],
	[7.0100000000E+03, 2.7279044702E+00, 6.8206099306E+00, 6.6730332756E-02, 6.4520770353E-02, 4.3263706116E-01],
	[7.0150000000E+03, 2.7303776593E+00, 6.8186539346E+00, 6.6877339470E-02, 6.4659405296E-02, 4.3281914355E-01],
	[7.0200000000E+03, 2.7328513262E+00, 6.8166998926E+00, 6.7024564785E-02, 6.4798232696E-02, 4.3300112332E-01],
	[7.0250000000E+03, 2.7353254704E+00, 6.8147478012E+00, 6.7172008871E-02, 6.4937252658E-02, 4.3318300077E-01],
	[7.0300000000E+03, 2.7378000919E+00, 6.8127976571E+00, 6.7319671896E-02, 6.5076465286E-02, 4.3336477620E-01],
	[7.0350000000E+03, 2.7402751903E+00, 6.8108494571E+00, 6.7467554029E-02, 6.5215870684E-02, 4.3354644990E-01],
	[7.0400000000E+03, 2.7427507655E+00, 6.8089031977E+00, 6.7615655439E-02, 6.5355468956E-02, 4.3372802216E-01],
	[7.0450000000E+03, 2.7452268171E+00, 6.8069588757E+00, 6.7763976293E-02, 6.5495260206E-02, 4.3390949335E-01],
	[7.0500000000E+03, 2.7477033449E+00, 6.8050164877E+00, 6.7912516762E-02, 6.5635244536E-02, 4.3409086380E-01],
	[7.0550000000E+03, 2.7501803488E+00, 6.8030760305E+00, 6.8061277013E-02, 6.5775422052E-02, 4.3427213381E-01],
	[7.0600000000E+03, 2.7526578283E+00, 6.8011375008E+00, 6.8210257215E-02, 6.5915792855E-02, 4.3445330365E-01],
	[7.0650000000E+03, 2.7551357833E+00, 6.7992008953E+00, 6.8359457537E-02, 6.6056357050E-02, 4.3463437361E-01],
	[7.0700000000E+03, 2.7576142136E+00, 6.7972662107E+00, 6.8508878147E-02, 6.6197114740E-02, 4.3481534398E-01],
	[7.0750000000E+03, 2.7600931188E+00, 6.7953334438E+00, 6.8658519215E-02, 6.6338066028E-02, 4.3499621502E-01],
	[7.0800000000E+03, 2.7625724988E+00, 6.7934025913E+00, 6.8808380908E-02, 6.6479211016E-02, 4.3517698703E-01],
	[7.0850000000E+03, 2.7650523533E+00, 6.7914736500E+00, 6.8958463397E-02, 6.6620549808E-02, 4.3535766029E-01],
	[7.0900000000E+03, 2.7675326820E+00, 6.7895466167E+00, 6.9108766849E-02, 6.6762082507E-02, 4.3553823507E-01],
	[7.0950000000E+03, 2.7700134848E+00, 6.7876214880E+00, 6.9259291433E-02, 6.6903809215E-02, 4.3571871165E-01],
	[7.1000000000E+03, 2.7724947613E+00, 6.7856982609E+00, 6.9410037319E-02, 6.7045730034E-02, 4.3589909031E-01],
	[7.1050000000E+03, 2.7749767206E+00, 6.7837780663E+00, 6.9561004674E-02, 6.7187845302E-02, 4.3607937134E-01],
	[7.1100000000E+03, 2.7774658282E+00, 6.7818959170E+00, 6.9712193668E-02, 6.7330162374E-02, 4.3625955500E-01],
	[7.1150000000E+03, 2.7799554164E+00, 6.7800156124E+00, 6.9863604469E-02, 6.7472673920E-02, 4.3643964157E-01],
	[7.1200000000E+03, 2.7824454849E+00, 6.7781371495E+00, 7.0015237246E-02, 6.7615380041E-02, 4.3661963133E-01],
	[7.1250000000E+03, 2.7849360334E+00, 6.7762605252E+00, 7.0167092169E-02, 6.7758280841E-02, 4.3679952455E-01],
	[7.1300000000E+03, 2.7874270616E+00, 6.7743857363E+00, 7.0319169405E-02, 6.7901376421E-02, 4.3697932151E-01],
	[7.1350000000E+03, 2.7899185695E+00, 6.7725127799E+00, 7.0471469124E-02, 6.8044666883E-02, 4.3715902249E-01],
	[7.1400000000E+03, 2.7924105566E+00, 6.7706416528E+00, 7.0623991494E-02, 6.8188152330E-02, 4.3733862774E-01],
	[7.1450000000E+03, 2.7949030227E+00, 6.7687723520E+00, 7.0776736685E-02, 6.8331832863E-02, 4.3751813755E-01],
	[7.1500000000E+03, 2.7973959677E+00, 6.7669048744E+00, 7.0929704865E-02, 6.8475708585E-02, 4.3769755219E-01],
	[7.1550000000E+03, 2.7998893913E+00, 6.7650392170E+00, 7.1082896203E-02, 6.8619779595E-02, 4.3787687193E-01],
	[7.1600000000E+03, 2.8023832932E+00, 6.7631753766E+00, 7.1236310867E-02, 6.8764045997E-02, 4.3805609704E-01],
	[7.1650000000E+03, 2.8048776731E+00, 6.7613133504E+00, 7.1389949028E-02, 6.8908507891E-02, 4.3823522779E-01],
	[7.1700000000E+03, 2.8073725310E+00, 6.7594531352E+00, 7.1543810854E-02, 6.9053165378E-02, 4.3841426444E-01],
	[7.1750000000E+03, 2.8098678664E+00, 6.7575947280E+00, 7.1697896513E-02, 6.9198018561E-02, 4.3859320727E-01],
	[7.1800000000E+03, 2.8123636791E+00, 6.7557381259E+00, 7.1852206174E-02, 6.9343067539E-02, 4.3877205655E-01],
	[7.1850000000E+03, 2.8148599690E+00, 6.7538833258E+00, 7.2006740007E-02, 6.9488312415E-02, 4.3895081253E-01],
	[7.1900000000E+03, 2.8173567358E+00, 6.7520303246E+00, 7.2161498181E-02, 6.9633753288E-02, 4.3912947550E-01],
	[7.1950000000E+03, 2.8198539792E+00, 6.7501791195E+00, 7.2316480863E-02, 6.9779390259E-02, 4.3930804571E-01],
	[7.2000000000E+03, 2.8223516990E+00, 6.7483297074E+00, 7.2471688224E-02, 6.9925223430E-02, 4.3948652342E-01],
	[7.2050000000E+03, 2.8248498949E+00, 6.7464820853E+00, 7.2627120432E-02, 7.0071252899E-02, 4.3966490891E-01],
	[7.2100000000E+03, 2.8273485668E+00, 6.7446362503E+00, 7.2782777657E-02, 7.0217478769E-02, 4.3984320244E-01],
	[7.2150000000E+03, 2.8298477144E+00, 6.7427921994E+00, 7.2938660066E-02, 7.0363901139E-02, 4.4002140427E-01],
	[7.2200000000E+03, 2.8323483602E+00, 6.7409554513E+00, 7.3094767830E-02, 7.0510521348E-02, 4.4019951467E-01],
	[7.2250000000E+03, 2.8348550733E+00, 6.7391506200E+00, 7.3251101117E-02, 7.0657345053E-02, 4.4037753389E-01],
	[7.2300000000E+03, 2.8373622685E+00, 6.7373475200E+00, 7.3407660096E-02, 7.0804365614E-02, 4.4055546219E-01],
	[7.2350000000E+03, 2.8398699455E+00, 6.7355461485E+00, 7.3564444936E-02, 7.0951583132E-02, 4.4073329985E-01],
	[7.2400000000E+03, 2.8423781040E+00, 6.7337465025E+00, 7.3721455806E-02, 7.1098997707E-02, 4.4091104712E-01],
	[7.2450000000E+03, 2.8448867439E+00, 6.7319485794E+00, 7.3878692875E-02, 7.1246609438E-02, 4.4108870425E-01],
	[7.2500000000E+03, 2.8473958649E+00, 6.7301523761E+00, 7.4036156313E-02, 7.1394418425E-02, 4.4126627151E-01],
	[7.2550000000E+03, 2.8499054668E+00, 6.7283578900E+00, 7.4193846288E-02, 7.1542424768E-02, 4.4144374917E-01],
	[7.2600000000E+03, 2.8524155493E+00, 6.7265651182E+00, 7.4351762969E-02, 7.1690628566E-02, 4.4162113746E-01],
	[7.2650000000E+03, 2.8549261122E+00, 6.7247740577E+00, 7.4509906526E-02, 7.1839029920E-02, 4.4179843666E-01],
	[7.2700000000E+03, 2.8574371552E+00, 6.7229847060E+00, 7.4668277127E-02, 7.1987628927E-02, 4.4197564702E-01],
	[7.2750000000E+03, 2.8599486781E+00, 6.7211970601E+00, 7.4826874941E-02, 7.2136425687E-02, 4.4215276879E-01],
	[7.2800000000E+03, 2.8624606807E+00, 6.7194111172E+00, 7.4985700139E-02, 7.2285420300E-02, 4.4232980224E-01],
	[7.2850000000E+03, 2.8649731628E+00, 6.7176268746E+00, 7.5144752888E-02, 7.2434612864E-02, 4.4250674761E-01],
	[7.2900000000E+03, 2.8674861240E+00, 6.7158443295E+00, 7.5304033358E-02, 7.2584003478E-02, 4.4268360517E-01],
	[7.2950000000E+03, 2.8699995642E+00, 6.7140634790E+00, 7.5463541717E-02, 7.2733592241E-02, 4.4286037516E-01],
	[7.3000000000E+03, 2.8725134831E+00, 6.7122843205E+00, 7.5623278136E-02, 7.2883379252E-02, 4.4303705784E-01],
	[7.3050000000E+03, 2.8750278805E+00, 6.7105068512E+00, 7.5783242783E-02, 7.3033364608E-02, 4.4321365346E-01],
	[7.3100000000E+03, 2.8775427561E+00, 6.7087310682E+00, 7.5943435828E-02, 7.3183548409E-02, 4.4339016228E-01],
	[7.3150000000E+03, 2.8800581098E+00, 6.7069569689E+00, 7.6103857439E-02, 7.3333930753E-02, 4.4356658455E-01],
	[7.3200000000E+03, 2.8825739412E+00, 6.7051845505E+00, 7.6264507786E-02, 7.3484511737E-02, 4.4374292051E-01],
	[7.3250000000E+03, 2.8850902502E+00, 6.7034138103E+00, 7.6425387037E-02, 7.3635291461E-02, 4.4391917042E-01],
	[7.3300000000E+03, 2.8876070364E+00, 6.7016447455E+00, 7.6586495363E-02, 7.3786270021E-02, 4.4409533453E-01],
	[7.3350000000E+03, 2.8901242997E+00, 6.6998773534E+00, 7.6747832931E-02, 7.3937447516E-02, 4.4427141309E-01],
	[7.3400000000E+03, 2.8926478153E+00, 6.6981426958E+00, 7.6909399913E-02, 7.4088831632E-02, 4.4444740635E-01],
	[7.3450000000E+03, 2.8951723795E+00, 6.6964127091E+00, 7.7071196475E-02, 7.4240415677E-02, 4.4462331455E-01],
	[7.3500000000E+03, 2.8976974269E+00, 6.6946843461E+00, 7.7233222789E-02, 7.4392199008E-02, 4.4479913795E-01],
	[7.3550000000E+03, 2.9002229571E+00, 6.6929576041E+00, 7.7395479023E-02, 7.4544181720E-02, 4.4497487679E-01],
	[7.3600000000E+03, 2.9027489699E+00, 6.6912324804E+00, 7.7557965346E-02, 7.4696363914E-02, 4.4515053132E-01],
	[7.3650000000E+03, 2.9052754651E+00, 6.6895089726E+00, 7.7720681927E-02, 7.4848745685E-02, 4.4532610178E-01],
	[7.3700000000E+03, 2.9078024425E+00, 6.6877870778E+00, 7.7883628937E-02, 7.5001327131E-02, 4.4550158843E-01],
	[7.3750000000E+03, 2.9103299018E+00, 6.6860667937E+00, 7.8046806543E-02, 7.5154108349E-02, 4.4567699151E-01],
	[7.3800000000E+03, 2.9128578428E+00, 6.6843481174E+00, 7.8210214915E-02, 7.5307089436E-02, 4.4585231125E-01],
	[7.3850000000E+03, 2.9153862652E+00, 6.6826310466E+00, 7.8373854224E-02, 7.5460270490E-02, 4.4602754792E-01],
	[7.3900000000E+03, 2.9179151688E+00, 6.6809155785E+00, 7.8537724637E-02, 7.5613651606E-02, 4.4620270174E-01],
	[7.3950000000E+03, 2.9204445534E+00, 6.6792017106E+00, 7.8701826324E-02, 7.5767232882E-02, 4.4637777297E-01],
	[7.4000000000E+03, 2.9229744188E+00, 6.6774894404E+00, 7.8866159455E-02, 7.5921014415E-02, 4.4655276185E-01],
	[7.4050000000E+03, 2.9255047646E+00, 6.6757787652E+00, 7.9030724198E-02, 7.6074996300E-02, 4.4672766861E-01],
	[7.4100000000E+03, 2.9280355908E+00, 6.6740696825E+00, 7.9195520724E-02, 7.6229178634E-02, 4.4690249351E-01],
	[7.4150000000E+03, 2.9305668969E+00, 6.6723621897E+00, 7.9360549201E-02, 7.6383561514E-02, 4.4707723678E-01],
	[7.4200000000E+03, 2.9330986829E+00, 6.6706562844E+00, 7.9525809798E-02, 7.6538145035E-02, 4.4725189866E-01],
	[7.4250000000E+03, 2.9356309485E+00, 6.6689519639E+00, 7.9691302686E-02, 7.6692929293E-02, 4.4742647940E-01],
	[7.4300000000E+03, 2.9381636934E+00, 6.6672492256E+00, 7.9857028033E-02, 7.6847914385E-02, 4.4760097923E-01],
	[7.4350000000E+03, 2.9406969175E+00, 6.6655480672E+00, 8.0022986009E-02, 7.7003100406E-02, 4.4777539840E-01],
	[7.4400000000E+03, 2.9432306204E+00, 6.6638484861E+00, 8.0189176784E-02, 7.7158487452E-02, 4.4794973714E-01],
	[7.4450000000E+03, 2.9457648019E+00, 6.6621504796E+00, 8.0355600526E-02, 7.7314075619E-02, 4.4812399569E-01],
	[7.4500000000E+03, 2.9482994619E+00, 6.6604540454E+00, 8.0522257404E-02, 7.7469865001E-02, 4.4829817429E-01],
	[7.4550000000E+03, 2.9508363749E+00, 6.6587687249E+00, 8.0689147590E-02, 7.7625858220E-02, 4.4847227318E-01],
	[7.4600000000E+03, 2.9533780595E+00, 6.6571080156E+00, 8.0856271250E-02, 7.7782058986E-02, 4.4864629259E-01],
	[7.4650000000E+03, 2.9559202283E+00, 6.6554488327E+00, 8.1023628557E-02, 7.7938461313E-02, 4.4882023276E-01],
	[7.4700000000E+03, 2.9584628810E+00, 6.6537911739E+00, 8.1191219677E-02, 7.8095065296E-02, 4.4899409393E-01],
	[7.4750000000E+03, 2.9610060172E+00, 6.6521350367E+00, 8.1359044782E-02, 7.8251871030E-02, 4.4916787634E-01],
	[7.4800000000E+03, 2.9635496369E+00, 6.6504804187E+00, 8.1527104040E-02, 7.8408878609E-02, 4.4934158021E-01],
	[7.4850000000E+03, 2.9660937397E+00, 6.6488273175E+00, 8.1695397622E-02, 7.8566088128E-02, 4.4951520578E-01],
	[7.4900000000E+03, 2.9686383255E+00, 6.6471757308E+00, 8.1863925695E-02, 7.8723499683E-02, 4.4968875329E-01],
	[7.4950000000E+03, 2.9711833940E+00, 6.6455256560E+00, 8.2032688430E-02, 7.8881113368E-02, 4.4986222297E-01],
	[7.5000000000E+03, 2.9737289449E+00, 6.6438770909E+00, 8.2201685997E-02, 7.9038929278E-02, 4.5003561506E-01],
	[7.5050000000E+03, 2.9762749781E+00, 6.6422300330E+00, 8.2370918565E-02, 7.9196947506E-02, 4.5020892978E-01],
	[7.5100000000E+03, 2.9788214933E+00, 6.6405844799E+00, 8.2540386303E-02, 7.9355168148E-02, 4.5038216737E-01],
	[7.5150000000E+03, 2.9813684903E+00, 6.6389404294E+00, 8.2710089380E-02, 7.9513591297E-02, 4.5055532807E-01],
	[7.5200000000E+03, 2.9839159689E+00, 6.6372978789E+00, 8.2880027967E-02, 7.9672217047E-02, 4.5072841210E-01],
	[7.5250000000E+03, 2.9864639287E+00, 6.6356568261E+00, 8.3050202233E-02, 7.9831045493E-02, 4.5090141969E-01],
	[7.5300000000E+03, 2.9890123697E+00, 6.6340172688E+00, 8.3220612348E-02, 7.9990076728E-02, 4.5107435109E-01],
	[7.5350000000E+03, 2.9915612915E+00, 6.6323792045E+00, 8.3391258480E-02, 8.0149310846E-02, 4.5124720653E-01],
	[7.5400000000E+03, 2.9941106940E+00, 6.6307426308E+00, 8.3562140799E-02, 8.0308747941E-02, 4.5141998624E-01],
	[7.5450000000E+03, 2.9966605769E+00, 6.6291075455E+00, 8.3733259476E-02, 8.0468388105E-02, 4.5159269040E-01],
	[7.5500000000E+03, 2.9992109399E+00, 6.6274739462E+00, 8.3904614679E-02, 8.0628231433E-02, 4.5176531924E-01],
	[7.5550000000E+03, 3.0017617829E+00, 6.6258418305E+00, 8.4076206578E-02, 8.0788278017E-02, 4.5193787297E-01],
	[7.5600000000E+03, 3.0043131057E+00, 6.6242111962E+00, 8.4248035343E-02, 8.0948527951E-02, 4.5211035178E-01],
	[7.5650000000E+03, 3.0068649079E+00, 6.6225820408E+00, 8.4420101144E-02, 8.1108981328E-02, 4.5228275589E-01],
	[7.5700000000E+03, 3.0094171894E+00, 6.6209543622E+00, 8.4592404149E-02, 8.1269638240E-02, 4.5245508551E-01],
	[7.5750000000E+03, 3.0119716532E+00, 6.6193373275E+00, 8.4764944529E-02, 8.1430501414E-02, 4.5262734083E-01],
	[7.5800000000E+03, 3.0145306841E+00, 6.6177437307E+00, 8.4937722452E-02, 8.1591574660E-02, 4.5279952207E-01],
	[7.5850000000E+03, 3.0170901995E+00, 6.6161515680E+00, 8.5110738090E-02, 8.1752851780E-02, 4.5297162944E-01],
	[7.5900000000E+03, 3.0196501993E+00, 6.6145608372E+00, 8.5283991611E-02, 8.1914332866E-02, 4.5314366313E-01],
	[7.5950000000E+03, 3.0222106833E+00, 6.6129715360E+00, 8.5457483185E-02, 8.2076018011E-02, 4.5331562336E-01],
	[7.6000000000E+03, 3.0247716511E+00, 6.6113836623E+00, 8.5631212982E-02, 8.2237907308E-02, 4.5348751032E-01],
	[7.6050000000E+03, 3.0273331027E+00, 6.6097972138E+00, 8.5805181171E-02, 8.2400000848E-02, 4.5365932423E-01],
	[7.6100000000E+03, 3.0298950377E+00, 6.6082121882E+00, 8.5979387921E-02, 8.2562298724E-02, 4.5383106528E-01],
	[7.6150000000E+03, 3.0324574559E+00, 6.6066285835E+00, 8.6153833404E-02, 8.2724801028E-02, 4.5400273368E-01],
	[7.6200000000E+03, 3.0350203572E+00, 6.6050463973E+00, 8.6328517788E-02, 8.2887507852E-02, 4.5417432964E-01],
	[7.6250000000E+03, 3.0375837412E+00, 6.6034656275E+00, 8.6503441243E-02, 8.3050419288E-02, 4.5434585334E-01],
	[7.6300000000E+03, 3.0401476077E+00, 6.6018862718E+00, 8.6678603939E-02, 8.3213535427E-02, 4.5451730501E-01],
	[7.6350000000E+03, 3.0427119566E+00, 6.6003083282E+00, 8.6854006045E-02, 8.3376856361E-02, 4.5468868483E-01],
	[7.6400000000E+03, 3.0452767876E+00, 6.5987317944E+00, 8.7029647731E-02, 8.3540382181E-02, 4.5485999302E-01],
	[7.6450000000E+03, 3.0478421005E+00, 6.5971566682E+00, 8.7205529167E-02, 8.3704112979E-02, 4.5503122977E-01],
	[7.6500000000E+03, 3.0504078951E+00, 6.5955829474E+00, 8.7381650523E-02, 8.3868048846E-02, 4.5520239528E-01],
	[7.6550000000E+03, 3.0529741710E+00, 6.5940106299E+00, 8.7558011968E-02, 8.4032189874E-02, 4.5537348975E-01],
	[7.6600000000E+03, 3.0555409282E+00, 6.5924397135E+00, 8.7734613672E-02, 8.4196536152E-02, 4.5554451339E-01],
	[7.6650000000E+03, 3.0581081663E+00, 6.5908701961E+00, 8.7911455805E-02, 8.4361087773E-02, 4.5571546639E-01],
	[7.6700000000E+03, 3.0606758852E+00, 6.5893020755E+00, 8.8088538537E-02, 8.4525844826E-02, 4.5588634895E-01],
	[7.6750000000E+03, 3.0632440847E+00, 6.5877353495E+00, 8.8265862037E-02, 8.4690807403E-02, 4.5605716127E-01],
	[7.6800000000E+03, 3.0658127644E+00, 6.5861700159E+00, 8.8443426475E-02, 8.4855975593E-02, 4.5622790355E-01],
	[7.6850000000E+03, 3.0683819243E+00, 6.5846060728E+00, 8.8621232021E-02, 8.5021349488E-02, 4.5639857600E-01],
	[7.6900000000E+03, 3.0709515640E+00, 6.5830435178E+00, 8.8799278845E-02, 8.5186929178E-02, 4.5656917879E-01],
	[7.6950000000E+03, 3.0735216833E+00, 6.5814823489E+00, 8.8977567116E-02, 8.5352714752E-02, 4.5673971215E-01],
	[7.7000000000E+03, 3.0760972940E+00, 6.5799496198E+00, 8.9156097005E-02, 8.5518714745E-02, 4.5691017625E-01],
	[7.7050000000E+03, 3.0786738874E+00, 6.5784209300E+00, 8.9334868681E-02, 8.5684921701E-02, 4.5708057130E-01],
	[7.7100000000E+03, 3.0812509654E+00, 6.5768935867E+00, 8.9513882315E-02, 8.5851334872E-02, 4.5725089749E-01],
	[7.7150000000E+03, 3.0838285278E+00, 6.5753675879E+00, 8.9693138075E-02, 8.6017954350E-02, 4.5742115503E-01],
	[7.7200000000E+03, 3.0864065744E+00, 6.5738429314E+00, 8.9872636131E-02, 8.6184780224E-02, 4.5759134410E-01],
	[7.7250000000E+03, 3.0889851050E+00, 6.5723196153E+00, 9.0052376655E-02, 8.6351812583E-02, 4.5776146491E-01],
	[7.7300000000E+03, 3.0915641192E+00, 6.5707976375E+00, 9.0232359815E-02, 8.6519051517E-02, 4.5793151764E-01],
	[7.7350000000E+03, 3.0941436170E+00, 6.5692769959E+00, 9.0412585781E-02, 8.6686497116E-02, 4.5810150249E-01],
	[7.7400000000E+03, 3.0967235980E+00, 6.5677576886E+00, 9.0593054723E-02, 8.6854149469E-02, 4.5827141966E-01],
	[7.7450000000E+03, 3.0993040621E+00, 6.5662397134E+00, 9.0773766812E-02, 8.7022008664E-02, 4.5844126934E-01],
	[7.7500000000E+03, 3.1018850091E+00, 6.5647230684E+00, 9.0954722217E-02, 8.7190074792E-02, 4.5861105172E-01],
	[7.7550000000E+03, 3.1044664386E+00, 6.5632077515E+00, 9.1135921107E-02, 8.7358347941E-02, 4.5878076701E-01],
	[7.7600000000E+03, 3.1070483506E+00, 6.5616937607E+00, 9.1317363654E-02, 8.7526828200E-02, 4.5895041538E-01],
	[7.7650000000E+03, 3.1096307447E+00, 6.5601810941E+00, 9.1499050026E-02, 8.7695515657E-02, 4.5911999703E-01],
	[7.7700000000E+03, 3.1122136208E+00, 6.5586697495E+00, 9.1680980394E-02, 8.7864410402E-02, 4.5928951217E-01],
	[7.7750000000E+03, 3.1147969786E+00, 6.5571597250E+00, 9.1863154927E-02, 8.8033512522E-02, 4.5945896097E-01],
	[7.7800000000E+03, 3.1173808179E+00, 6.5556510187E+00, 9.2045573796E-02, 8.8202822106E-02, 4.5962834363E-01],
	[7.7850000000E+03, 3.1199651385E+00, 6.5541436284E+00, 9.2228237171E-02, 8.8372339242E-02, 4.5979766034E-01],
	[7.7900000000E+03, 3.1225499402E+00, 6.5526375522E+00, 9.2411145221E-02, 8.8542064019E-02, 4.5996691130E-01],
	[7.7950000000E+03, 3.1251352227E+00, 6.5511327881E+00, 9.2594298117E-02, 8.8711996524E-02, 4.6013609669E-01],
	[7.8000000000E+03, 3.1277209859E+00, 6.5496293341E+00, 9.2777696028E-02, 8.8882136845E-02, 4.6030521670E-01],
	[7.8050000000E+03, 3.1303072295E+00, 6.5481271883E+00, 9.2961339125E-02, 8.9052485070E-02, 4.6047427153E-01],
	[7.8100000000E+03, 3.1328939533E+00, 6.5466263487E+00, 9.3145227577E-02, 8.9223041287E-02, 4.6064326136E-01],
	[7.8150000000E+03, 3.1354811571E+00, 6.5451268132E+00, 9.3329361554E-02, 8.9393805582E-02, 4.6081218639E-01],
	[7.8200000000E+03, 3.1380695322E+00, 6.5436323387E+00, 9.3513741227E-02, 8.9564779312E-02, 4.6098104680E-01],
	[7.8250000000E+03, 3.1406629244E+00, 6.5421637920E+00, 9.3698366766E-02, 8.9735969641E-02, 4.6114984278E-01],
	[7.8300000000E+03, 3.1432568013E+00, 6.5406965128E+00, 9.3883238340E-02, 8.9907368374E-02, 4.6131857453E-01],
	[7.8350000000E+03, 3.1458511626E+00, 6.5392304989E+00, 9.4068356120E-02, 9.0078975598E-02, 4.6148724222E-01],
	[7.8400000000E+03, 3.1484460080E+00, 6.5377657486E+00, 9.4253720276E-02, 9.0250791399E-02, 4.6165584605E-01],
	[7.8450000000E+03, 3.1510413374E+00, 6.5363022599E+00, 9.4439330977E-02, 9.0422815866E-02, 4.6182438621E-01],
	[7.8500000000E+03, 3.1536371505E+00, 6.5348400310E+00, 9.4625188394E-02, 9.0595049084E-02, 4.6199286288E-01],
	[7.8550000000E+03, 3.1562334472E+00, 6.5333790599E+00, 9.4811292697E-02, 9.0767491140E-02, 4.6216127625E-01],
	[7.8600000000E+03, 3.1588302271E+00, 6.5319193448E+00, 9.4997644056E-02, 9.0940142121E-02, 4.6232962650E-01],
	[7.8650000000E+03, 3.1614274902E+00, 6.5304608838E+00, 9.5184242640E-02, 9.1113002114E-02, 4.6249791383E-01],
	[7.8700000000E+03, 3.1640252361E+00, 6.5290036750E+00, 9.5371088621E-02, 9.1286071205E-02, 4.6266613842E-01],
	[7.8750000000E+03, 3.1666234646E+00, 6.5275477166E+00, 9.5558182169E-02, 9.1459349480E-02, 4.6283430046E-01],
	[7.8800000000E+03, 3.1692221756E+00, 6.5260930067E+00, 9.5745523452E-02, 9.1632837026E-02, 4.6300240012E-01],
	[7.8850000000E+03, 3.1718213688E+00, 6.5246395434E+00, 9.5933112642E-02, 9.1806533928E-02, 4.6317043760E-01],
	[7.8900000000E+03, 3.1744210440E+00, 6.5231873249E+00, 9.6120949909E-02, 9.1980440272E-02, 4.6333841309E-01],
	[7.8950000000E+03, 3.1770212010E+00, 6.5217363493E+00, 9.6309035422E-02, 9.2154556144E-02, 4.6350632676E-01],
	[7.9000000000E+03, 3.1796218395E+00, 6.5202866148E+00, 9.6497369352E-02, 9.2328881630E-02, 4.6367417880E-01],
	[7.9050000000E+03, 3.1822229594E+00, 6.5188381194E+00, 9.6685951870E-02, 9.2503416815E-02, 4.6384196940E-01],
	[7.9100000000E+03, 3.1848245604E+00, 6.5173908615E+00, 9.6874783144E-02, 9.2678161785E-02, 4.6400969874E-01],
	[7.9150000000E+03, 3.1874266424E+00, 6.5159448391E+00, 9.7063863346E-02, 9.2853116624E-02, 4.6417736700E-01],
	[7.9200000000E+03, 3.1900292050E+00, 6.5145000505E+00, 9.7253192646E-02, 9.3028281419E-02, 4.6434497437E-01],
	[7.9250000000E+03, 3.1926322482E+00, 6.5130564937E+00, 9.7442771213E-02, 9.3203656253E-02, 4.6451252103E-01],
	[7.9300000000E+03, 3.1952357716E+00, 6.5116141669E+00, 9.7632599218E-02, 9.3379241213E-02, 4.6468000716E-01],
	[7.9350000000E+03, 3.1978397751E+00, 6.5101730684E+00, 9.7822676832E-02, 9.3555036382E-02, 4.6484743294E-01],
	[7.9400000000E+03, 3.2004442584E+00, 6.5087331963E+00, 9.8013004223E-02, 9.3731041846E-02, 4.6501479857E-01],
	[7.9450000000E+03, 3.2030492214E+00, 6.5072945488E+00, 9.8203581564E-02, 9.3907257688E-02, 4.6518210421E-01],
	[7.9500000000E+03, 3.2056593950E+00, 6.5058830247E+00, 9.8394409023E-02, 9.4083693486E-02, 4.6534935006E-01],
	[7.9550000000E+03, 3.2082702693E+00, 6.5044738801E+00, 9.8585486771E-02, 9.4260340328E-02, 4.6551653628E-01],
	[7.9600000000E+03, 3.2108816276E+00, 6.5030659259E+00, 9.8776814979E-02, 9.4437197867E-02, 4.6568366307E-01],
	[7.9650000000E+03, 3.2134934696E+00, 6.5016591602E+00, 9.8968393816E-02, 9.4614266185E-02, 4.6585073061E-01],
	[7.9700000000E+03, 3.2161057952E+00, 6.5002535814E+00, 9.9160223453E-02, 9.4791545368E-02, 4.6601773907E-01],
	[7.9750000000E+03, 3.2187186040E+00, 6.4988491877E+00, 9.9352304060E-02, 9.4969035499E-02, 4.6618468864E-01],
	[7.9800000000E+03, 3.2213318959E+00, 6.4974459774E+00, 9.9544635808E-02, 9.5146736662E-02, 4.6635157950E-01],
	[7.9850000000E+03, 3.2239456706E+00, 6.4960439487E+00, 9.9737218866E-02, 9.5324648941E-02, 4.6651841182E-01],
	[7.9900000000E+03, 3.2265599280E+00, 6.4946430998E+00, 9.9930053405E-02, 9.5502772420E-02, 4.6668518578E-01],
	[7.9950000000E+03, 3.2291746678E+00, 6.4932434291E+00, 1.0012313960E-01, 9.5681107182E-02, 4.6685190152E-01],
	[8.0000000000E+03, 3.2317898899E+00, 6.4918449349E+00, 1.0031647761E-01, 9.5859653310E-02, 4.6701855921E-01],
	[8.0050000000E+03, 3.2344055939E+00, 6.4904476153E+00, 1.0051100975E-01, 9.6039271062E-02, 4.6718515899E-01],
	[8.0100000000E+03, 3.2370217798E+00, 6.4890514688E+00, 1.0070579711E-01, 9.6219102912E-02, 4.6735170103E-01],
	[8.0150000000E+03, 3.2396384472E+00, 6.4876564935E+00, 1.0090083987E-01, 9.6399148947E-02, 4.6751818547E-01],
	[8.0200000000E+03, 3.2422555961E+00, 6.4862626878E+00, 1.0109613819E-01, 9.6579409252E-02, 4.6768461247E-01],
	[8.0250000000E+03, 3.2448732260E+00, 6.4848700499E+00, 1.0129169226E-01, 9.6759883912E-02, 4.6785098218E-01],
	[8.0300000000E+03, 3.2474913370E+00, 6.4834785782E+00, 1.0148750225E-01, 9.6940573013E-02, 4.6801729476E-01],
	[8.0350000000E+03, 3.2501099286E+00, 6.4820882709E+00, 1.0168356832E-01, 9.7121476641E-02, 4.6818355036E-01],
	[8.0400000000E+03, 3.2527290008E+00, 6.4806991263E+00, 1.0187989067E-01, 9.7302594880E-02, 4.6834974913E-01],
	[8.0450000000E+03, 3.2553485534E+00, 6.4793111428E+00, 1.0207646945E-01, 9.7483927815E-02, 4.6851589123E-01],
	[8.0500000000E+03, 3.2579685860E+00, 6.4779243187E+00, 1.0227330486E-01, 9.7665475531E-02, 4.6868197681E-01],
	[8.0550000000E+03, 3.2605890985E+00, 6.4765386523E+00, 1.0247039706E-01, 9.7847238113E-02, 4.6884800601E-01],
	[8.0600000000E+03, 3.2632100907E+00, 6.4751541418E+00, 1.0266774622E-01, 9.8029215645E-02, 4.6901397900E-01],
	[8.0650000000E+03, 3.2658315624E+00, 6.4737707856E+00, 1.0286535253E-01, 9.8211408213E-02, 4.6917989592E-01],
	[8.0700000000E+03, 3.2684535133E+00, 6.4723885821E+00, 1.0306321615E-01, 9.8393815899E-02, 4.6934575692E-01],
	[8.0750000000E+03, 3.2710777160E+00, 6.4710172256E+00, 1.0326133726E-01, 9.8576442648E-02, 4.6951156216E-01],
	[8.0800000000E+03, 3.2737053582E+00, 6.4696631777E+00, 1.0345971604E-01, 9.8759291170E-02, 4.6967731179E-01],
	[8.0850000000E+03, 3.2763334837E+00, 6.4683102505E+00, 1.0365835267E-01, 9.8942355130E-02, 4.6984300596E-01],
	[8.0900000000E+03, 3.2789620923E+00, 6.4669584424E+00, 1.0385724731E-01, 9.9125634611E-02, 4.7000864482E-01],
	[8.0950000000E+03, 3.2815911838E+00, 6.4656077517E+00, 1.0405640014E-01, 9.9309129697E-02, 4.7017422851E-01],
	[8.1000000000E+03, 3.2842207580E+00, 6.4642581769E+00, 1.0425581133E-01, 9.9492840472E-02, 4.7033975720E-01],
	[8.1050000000E+03, 3.2868508146E+00, 6.4629097164E+00, 1.0445548107E-01, 9.9676767019E-02, 4.7050523103E-01],
	[8.1100000000E+03, 3.2894813535E+00, 6.4615623685E+00, 1.0465540953E-01, 9.9860909423E-02, 4.7067065015E-01],
	[8.1150000000E+03, 3.2921123744E+00, 6.4602161317E+00, 1.0485559688E-01, 1.0004526777E-01, 4.7083601471E-01],
	[8.1200000000E+03, 3.2947438772E+00, 6.4588710042E+00, 1.0505604329E-01, 1.0022984213E-01, 4.7100132486E-01],
	[8.1250000000E+03, 3.2973758616E+00, 6.4575269847E+00, 1.0525674895E-01, 1.0041463261E-01, 4.7116658074E-01],
	[8.1300000000E+03, 3.3000083274E+00, 6.4561840714E+00, 1.0545771402E-01, 1.0059963927E-01, 4.7133178252E-01],
	[8.1350000000E+03, 3.3026412744E+00, 6.4548422627E+00, 1.0565893868E-01, 1.0078486220E-01, 4.7149693033E-01],
	[8.1400000000E+03, 3.3052747024E+00, 6.4535015572E+00, 1.0586042311E-01, 1.0097030149E-01, 4.7166202433E-01],
	[8.1450000000E+03, 3.3079086112E+00, 6.4521619531E+00, 1.0606216748E-01, 1.0115595721E-01, 4.7182706466E-01],
	[8.1500000000E+03, 3.3105430007E+00, 6.4508234489E+00, 1.0626417197E-01, 1.0134182946E-01, 4.7199205148E-01],
	[8.1550000000E+03, 3.3131778704E+00, 6.4494860431E+00, 1.0646643676E-01, 1.0152791831E-01, 4.7215698492E-01],
	[8.1600000000E+03, 3.3158132204E+00, 6.4481497340E+00, 1.0666896200E-01, 1.0171422384E-01, 4.7232186515E-01],
	[8.1650000000E+03, 3.3184490503E+00, 6.4468145201E+00, 1.0687174789E-01, 1.0190074614E-01, 4.7248669230E-01],
	[8.1700000000E+03, 3.3210853600E+00, 6.4454803999E+00, 1.0707479460E-01, 1.0208748529E-01, 4.7265146653E-01],
	[8.1750000000E+03, 3.3237221492E+00, 6.4441473716E+00, 1.0727810230E-01, 1.0227444136E-01, 4.7281618797E-01],
	[8.1800000000E+03, 3.3263594178E+00, 6.4428154339E+00, 1.0748167117E-01, 1.0246161445E-01, 4.7298085679E-01],
	[8.1850000000E+03, 3.3289971656E+00, 6.4414845852E+00, 1.0768550138E-01, 1.0264900464E-01, 4.7314547312E-01],
	[8.1900000000E+03, 3.3316353922E+00, 6.4401548238E+00, 1.0788959311E-01, 1.0283661199E-01, 4.7331003711E-01],
	[8.1950000000E+03, 3.3342740976E+00, 6.4388261482E+00, 1.0809394653E-01, 1.0302443661E-01, 4.7347454892E-01],
	[8.2000000000E+03, 3.3369132815E+00, 6.4374985570E+00, 1.0829856182E-01, 1.0321247856E-01, 4.7363900868E-01],
	[8.2050000000E+03, 3.3395546862E+00, 6.4361814802E+00, 1.0850343915E-01, 1.0340074204E-01, 4.7380341654E-01],
	[8.2100000000E+03, 3.3421993971E+00, 6.4348807597E+00, 1.0870857870E-01, 1.0358922971E-01, 4.7396777265E-01],
	[8.2150000000E+03, 3.3448445905E+00, 6.4335810938E+00, 1.0891398065E-01, 1.0377793504E-01, 4.7413207715E-01],
	[8.2200000000E+03, 3.3474902659E+00, 6.4322824810E+00, 1.0911964516E-01, 1.0396685809E-01, 4.7429633019E-01],
	[8.2250000000E+03, 3.3501364234E+00, 6.4309849197E+00, 1.0932557242E-01, 1.0415599896E-01, 4.7446053192E-01],
	[8.2300000000E+03, 3.3527830625E+00, 6.4296884084E+00, 1.0953176260E-01, 1.0434535771E-01, 4.7462468248E-01],
	[8.2350000000E+03, 3.3554301832E+00, 6.4283929458E+00, 1.0973821587E-01, 1.0453493444E-01, 4.7478878201E-01],
	[8.2400000000E+03, 3.3580777852E+00, 6.4270985302E+00, 1.0994493241E-01, 1.0472472921E-01, 4.7495283066E-01],
	[8.2450000000E+03, 3.3607258683E+00, 6.4258051602E+00, 1.1015191240E-01, 1.0491474212E-01, 4.7511682858E-01],
	[8.2500000000E+03, 3.3633744324E+00, 6.4245128344E+00, 1.1035915601E-01, 1.0510497324E-01, 4.7528077591E-01],
	[8.2550000000E+03, 3.3660234771E+00, 6.4232215512E+00, 1.1056666341E-01, 1.0529542266E-01, 4.7544467280E-01],
	[8.2600000000E+03, 3.3686730024E+00, 6.4219313093E+00, 1.1077443479E-01, 1.0548609044E-01, 4.7560851938E-01],
	[8.2650000000E+03, 3.3713230080E+00, 6.4206421070E+00, 1.1098247031E-01, 1.0567697667E-01, 4.7577231580E-01],
	[8.2700000000E+03, 3.3739734937E+00, 6.4193539430E+00, 1.1119077015E-01, 1.0586808144E-01, 4.7593606222E-01],
	[8.2750000000E+03, 3.3766244592E+00, 6.4180668158E+00, 1.1139933449E-01, 1.0605940482E-01, 4.7609975876E-01],
	[8.2800000000E+03, 3.3792759045E+00, 6.4167807239E+00, 1.1160816350E-01, 1.0625094688E-01, 4.7626340558E-01],
	[8.2850000000E+03, 3.3819278293E+00, 6.4154956659E+00, 1.1181725736E-01, 1.0644270772E-01, 4.7642700281E-01],
	[8.2900000000E+03, 3.3845802333E+00, 6.4142116403E+00, 1.1202661625E-01, 1.0663468740E-01, 4.7659055061E-01],
	[8.2950000000E+03, 3.3872331165E+00, 6.4129286457E+00, 1.1223624033E-01, 1.0682688601E-01, 4.7675404911E-01],
	[8.3000000000E+03, 3.3898864785E+00, 6.4116466806E+00, 1.1244612978E-01, 1.0701930362E-01, 4.7691749845E-01],
	[8.3050000000E+03, 3.3925403192E+00, 6.4103657436E+00, 1.1265628478E-01, 1.0721194032E-01, 4.7708089879E-01],
	[8.3100000000E+03, 3.3951946384E+00, 6.4090858332E+00, 1.1286670551E-01, 1.0740479618E-01, 4.7724425026E-01],
	[8.3150000000E+03, 3.3978494358E+00, 6.4078069480E+00, 1.1307739214E-01, 1.0759787129E-01, 4.7740755300E-01],
	[8.3200000000E+03, 3.4005047114E+00, 6.4065290865E+00, 1.1328834484E-01, 1.0779116571E-01, 4.7757080716E-01],
	[8.3250000000E+03, 3.4031604648E+00, 6.4052522474E+00, 1.1349956380E-01, 1.0798467953E-01, 4.7773401288E-01],
	[8.3300000000E+03, 3.4058166959E+00, 6.4039764291E+00, 1.1371104918E-01, 1.0817841283E-01, 4.7789717030E-01],
	[8.3350000000E+03, 3.4084734045E+00, 6.4027016304E+00, 1.1392280116E-01, 1.0837236567E-01, 4.7806027957E-01],
	[8.3400000000E+03, 3.4111348634E+00, 6.4014507436E+00, 1.1413481991E-01, 1.0856654907E-01, 4.7822334082E-01],
	[8.3450000000E+03, 3.4137969369E+00, 6.4002015645E+00, 1.1434710563E-01, 1.0876095258E-01, 4.7838635419E-01],
	[8.3500000000E+03, 3.4164594915E+00, 6.3989533771E+00, 1.1455965846E-01, 1.0895557595E-01, 4.7854931983E-01],
	[8.3550000000E+03, 3.4191225270E+00, 6.3977061802E+00, 1.1477247861E-01, 1.0915041925E-01, 4.7871223788E-01],
	[8.3600000000E+03, 3.4217860431E+00, 6.3964599723E+00, 1.1498556623E-01, 1.0934548256E-01, 4.7887510848E-01],
	[8.3650000000E+03, 3.4244500398E+00, 6.3952147520E+00, 1.1519892150E-01, 1.0954076596E-01, 4.7903793177E-01],
	[8.3700000000E+03, 3.4271145168E+00, 6.3939705180E+00, 1.1541254460E-01, 1.0973626952E-01, 4.7920070789E-01],
	[8.3750000000E+03, 3.4297794738E+00, 6.3927272689E+00, 1.1562643571E-01, 1.0993199333E-01, 4.7936343698E-01],
	[8.3800000000E+03, 3.4324449108E+00, 6.3914850033E+00, 1.1584059501E-01, 1.1012793746E-01, 4.7952611919E-01],
	[8.3850000000E+03, 3.4351108274E+00, 6.3902437199E+00, 1.1605502265E-01, 1.1032410198E-01, 4.7968875464E-01],
	[8.3900000000E+03, 3.4377772236E+00, 6.3890034173E+00, 1.1626971883E-01, 1.1052048697E-01, 4.7985134349E-01],
	[8.3950000000E+03, 3.4404440990E+00, 6.3877640942E+00, 1.1648468372E-01, 1.1071709252E-01, 4.8001388587E-01],
	[8.4000000000E+03, 3.4431114536E+00, 6.3865257492E+00, 1.1669991749E-01, 1.1091391869E-01, 4.8017638193E-01],
	[8.4050000000E+03, 3.4457792870E+00, 6.3852883809E+00, 1.1691542031E-01, 1.1111096556E-01, 4.8033883179E-01],
	[8.4100000000E+03, 3.4484475992E+00, 6.3840519880E+00, 1.1713119238E-01, 1.1130823321E-01, 4.8050123560E-01],
	[8.4150000000E+03, 3.4511163898E+00, 6.3828165692E+00, 1.1734723385E-01, 1.1150572172E-01, 4.8066359351E-01],
	[8.4200000000E+03, 3.4537856587E+00, 6.3815821230E+00, 1.1756354491E-01, 1.1170343115E-01, 4.8082590563E-01],
	[8.4250000000E+03, 3.4564554058E+00, 6.3803486483E+00, 1.1778012572E-01, 1.1190136159E-01, 4.8098817207E-01],
	[8.4300000000E+03, 3.4591256308E+00, 6.3791161435E+00, 1.1799697648E-01, 1.1209951311E-01, 4.8115039296E-01],
	[8.4350000000E+03, 3.4617963334E+00, 6.3778846074E+00, 1.1821409734E-01, 1.1229788579E-01, 4.8131256840E-01],
	[8.4400000000E+03, 3.4644675136E+00, 6.3766540387E+00, 1.1843148850E-01, 1.1249647969E-01, 4.8147469850E-01],
	[8.4450000000E+03, 3.4671391711E+00, 6.3754244360E+00, 1.1864915012E-01, 1.1269529491E-01, 4.8163678339E-01],
	[8.4500000000E+03, 3.4698113057E+00, 6.3741957979E+00, 1.1886708237E-01, 1.1289433150E-01, 4.8179882318E-01],
	[8.4550000000E+03, 3.4724839172E+00, 6.3729681232E+00, 1.1908528545E-01, 1.1309358956E-01, 4.8196081798E-01],
	[8.4600000000E+03, 3.4751570054E+00, 6.3717414106E+00, 1.1930375951E-01, 1.1329306914E-01, 4.8212276791E-01],
	[8.4650000000E+03, 3.4778305702E+00, 6.3705156586E+00, 1.1952250474E-01, 1.1349277033E-01, 4.8228467307E-01],
	[8.4700000000E+03, 3.4805051746E+00, 6.3692938610E+00, 1.1974152131E-01, 1.1369269476E-01, 4.8244653358E-01],
	[8.4750000000E+03, 3.4831839348E+00, 6.3680925606E+00, 1.1996080939E-01, 1.1389285113E-01, 4.8260834956E-01],
	[8.4800000000E+03, 3.4858631750E+00, 6.3668921950E+00, 1.2018036917E-01, 1.1409322940E-01, 4.8277012112E-01],
	[8.4850000000E+03, 3.4885428949E+00, 6.3656927631E+00, 1.2040020082E-01, 1.1429382965E-01, 4.8293184838E-01],
	[8.4900000000E+03, 3.4912230944E+00, 6.3644942635E+00, 1.2062036159E-01, 1.1449470337E-01, 4.8309353143E-01],
	[8.4950000000E+03, 3.4939037732E+00, 6.3632966950E+00, 1.2084079816E-01, 1.1469580243E-01, 4.8325517041E-01],
	[8.5000000000E+03, 3.4965849313E+00, 6.3621000563E+00, 1.2106150733E-01, 1.1489712385E-01, 4.8341676542E-01],
	[8.5050000000E+03, 3.4992665682E+00, 6.3609043461E+00, 1.2128248928E-01, 1.1509866772E-01, 4.8357831657E-01],
	[8.5100000000E+03, 3.5019486840E+00, 6.3597095631E+00, 1.2150374418E-01, 1.1530043409E-01, 4.8373982399E-01],
	[8.5150000000E+03, 3.5046312783E+00, 6.3585157062E+00, 1.2172527221E-01, 1.1550242305E-01, 4.8390128777E-01],
	[8.5200000000E+03, 3.5073143510E+00, 6.3573227740E+00, 1.2194707355E-01, 1.1570463468E-01, 4.8406270803E-01],
	[8.5250000000E+03, 3.5099979019E+00, 6.3561307653E+00, 1.2216914836E-01, 1.1590706904E-01, 4.8422408489E-01],
	[8.5300000000E+03, 3.5126819308E+00, 6.3549396788E+00, 1.2239149684E-01, 1.1610972620E-01, 4.8438541846E-01],
	[8.5350000000E+03, 3.5153664375E+00, 6.3537495133E+00, 1.2261411914E-01, 1.1631260624E-01, 4.8454670884E-01],
	[8.5400000000E+03, 3.5180514218E+00, 6.3525602676E+00, 1.2283701546E-01, 1.1651570924E-01, 4.8470795616E-01],
	[8.5450000000E+03, 3.5207368834E+00, 6.3513719403E+00, 1.2306018597E-01, 1.1671903527E-01, 4.8486916052E-01],
	[8.5500000000E+03, 3.5234228223E+00, 6.3501845302E+00, 1.2328363083E-01, 1.1692258439E-01, 4.8503032204E-01],
	[8.5550000000E+03, 3.5261092383E+00, 6.3489980361E+00, 1.2350735023E-01, 1.1712635668E-01, 4.8519144082E-01],
	[8.5600000000E+03, 3.5287961310E+00, 6.3478124568E+00, 1.2373134435E-01, 1.1733035222E-01, 4.8535251699E-01],
	[8.5650000000E+03, 3.5314835004E+00, 6.3466277909E+00, 1.2395561336E-01, 1.1753457108E-01, 4.8551355064E-01],
	[8.5700000000E+03, 3.5341713462E+00, 6.3454440374E+00, 1.2418015743E-01, 1.1773901332E-01, 4.8567454190E-01],
	[8.5750000000E+03, 3.5368596682E+00, 6.3442611948E+00, 1.2440497675E-01, 1.1794367903E-01, 4.8583549087E-01],
	[8.5800000000E+03, 3.5395484663E+00, 6.3430792621E+00, 1.2463007149E-01, 1.1814856826E-01, 4.8599639766E-01],
	[8.5850000000E+03, 3.5422377402E+00, 6.3418982379E+00, 1.2485544182E-01, 1.1835368110E-01, 4.8615726239E-01],
	[8.5900000000E+03, 3.5449274898E+00, 6.3407181211E+00, 1.2508108793E-01, 1.1855901762E-01, 4.8631808517E-01],
	[8.5950000000E+03, 3.5476177149E+00, 6.3395389104E+00, 1.2530700998E-01, 1.1876457788E-01, 4.8647886611E-01],
	[8.6000000000E+03, 3.5503084153E+00, 6.3383606046E+00, 1.2553320816E-01, 1.1897036196E-01, 4.8663960531E-01],
	[8.6050000000E+03, 3.5529995907E+00, 6.3371832025E+00, 1.2575968264E-01, 1.1917636993E-01, 4.8680030290E-01],
	[8.6100000000E+03, 3.5556947628E+00, 6.3360252797E+00, 1.2598643359E-01, 1.1938261243E-01, 4.8696095897E-01],
	[8.6150000000E+03, 3.5583909680E+00, 6.3348711664E+00, 1.2621346120E-01, 1.1958908069E-01, 4.8712157365E-01],
	[8.6200000000E+03, 3.5610876516E+00, 6.3337179327E+00, 1.2644076563E-01, 1.1979577313E-01, 4.8728214704E-01],
	[8.6250000000E+03, 3.5637848132E+00, 6.3325655775E+00, 1.2666834708E-01, 1.2000268982E-01, 4.8744267925E-01],
	[8.6300000000E+03, 3.5664824529E+00, 6.3314140996E+00, 1.2689620570E-01, 1.2020983082E-01, 4.8760317039E-01],
	[8.6350000000E+03, 3.5691805702E+00, 6.3302634979E+00, 1.2712434169E-01, 1.2041719621E-01, 4.8776362058E-01],
	[8.6400000000E+03, 3.5718791651E+00, 6.3291137711E+00, 1.2735275520E-01, 1.2062478606E-01, 4.8792402991E-01],
	[8.6450000000E+03, 3.5745782373E+00, 6.3279649181E+00, 1.2758144643E-01, 1.2083260044E-01, 4.8808439851E-01],
	[8.6500000000E+03, 3.5772777868E+00, 6.3268169377E+00, 1.2781041555E-01, 1.2104063942E-01, 4.8824472649E-01],
	[8.6550000000E+03, 3.5799778131E+00, 6.3256698288E+00, 1.2803966273E-01, 1.2124890307E-01, 4.8840501394E-01],
	[8.6600000000E+03, 3.5826783163E+00, 6.3245235902E+00, 1.2826918815E-01, 1.2145739146E-01, 4.8856526099E-01],
	[8.6650000000E+03, 3.5853792961E+00, 6.3233782208E+00, 1.2849899199E-01, 1.2166610466E-01, 4.8872546774E-01],
	[8.6700000000E+03, 3.5880807522E+00, 6.3222337193E+00, 1.2872907442E-01, 1.2187504273E-01, 4.8888563430E-01],
	[8.6750000000E+03, 3.5907826846E+00, 6.3210900846E+00, 1.2895943562E-01, 1.2208420576E-01, 4.8904576078E-01],
	[8.6800000000E+03, 3.5934850929E+00, 6.3199473156E+00, 1.2919007576E-01, 1.2229359380E-01, 4.8920584729E-01],
	[8.6850000000E+03, 3.5961879771E+00, 6.3188054111E+00, 1.2942099503E-01, 1.2250320693E-01, 4.8936589394E-01],
	[8.6900000000E+03, 3.5988913370E+00, 6.3176643699E+00, 1.2965219360E-01, 1.2271304521E-01, 4.8952590084E-01],
	[8.6950000000E+03, 3.6015951723E+00, 6.3165241910E+00, 1.2988367164E-01, 1.2292310872E-01, 4.8968586810E-01],
	[8.7000000000E+03, 3.6042994828E+00, 6.3153848731E+00, 1.3011542933E-01, 1.2313339753E-01, 4.8984579582E-01],
	[8.7050000000E+03, 3.6070042684E+00, 6.3142464151E+00, 1.3034746686E-01, 1.2334391169E-01, 4.9000568412E-01],
	[8.7100000000E+03, 3.6097095289E+00, 6.3131088159E+00, 1.3057978438E-01, 1.2355465129E-01, 4.9016553311E-01],
	[8.7150000000E+03, 3.6124152640E+00, 6.3119720743E+00, 1.3081238209E-01, 1.2376561639E-01, 4.9032534288E-01],
	[8.7200000000E+03, 3.6151214737E+00, 6.3108361892E+00, 1.3104526015E-01, 1.2397680705E-01, 4.9048511356E-01],
	[8.7250000000E+03, 3.6178281577E+00, 6.3097011595E+00, 1.3127841875E-01, 1.2418822335E-01, 4.9064484525E-01],
	[8.7300000000E+03, 3.6205353158E+00, 6.3085669840E+00, 1.3151185806E-01, 1.2439986536E-01, 4.9080453806E-01],
	[8.7350000000E+03, 3.6232429478E+00, 6.3074336616E+00, 1.3174557826E-01, 1.2461173313E-01, 4.9096419210E-01],
	[8.7400000000E+03, 3.6259510536E+00, 6.3063011912E+00, 1.3197957952E-01, 1.2482382675E-01, 4.9112380747E-01],
	[8.7450000000E+03, 3.6286602423E+00, 6.3051727700E+00, 1.3221386202E-01, 1.2503614825E-01, 4.9128338429E-01],
	[8.7500000000E+03, 3.6313732054E+00, 6.3040625008E+00, 1.3244842594E-01, 1.2524870650E-01, 4.9144292266E-01],
	[8.7550000000E+03, 3.6340866452E+00, 6.3029530612E+00, 1.3268327145E-01, 1.2546149086E-01, 4.9160242269E-01],
	[8.7600000000E+03, 3.6368005617E+00, 6.3018444500E+00, 1.3291839873E-01, 1.2567450141E-01, 4.9176188448E-01],
	[8.7650000000E+03, 3.6395149545E+00, 6.3007366663E+00, 1.3315380795E-01, 1.2588773820E-01, 4.9192130816E-01],
	[8.7700000000E+03, 3.6422298236E+00, 6.2996297089E+00, 1.3338949930E-01, 1.2610120132E-01, 4.9208069381E-01],
	[8.7750000000E+03, 3.6449451687E+00, 6.2985235768E+00, 1.3362547295E-01, 1.2631489082E-01, 4.9224004156E-01],
	[8.7800000000E+03, 3.6476609896E+00, 6.2974182688E+00, 1.3386172908E-01, 1.2652880678E-01, 4.9239935151E-01],
	[8.7850000000E+03, 3.6503772862E+00, 6.2963137838E+00, 1.3409826785E-01, 1.2674294925E-01, 4.9255862377E-01],
	[8.7900000000E+03, 3.6530940582E+00, 6.2952101209E+00, 1.3433508946E-01, 1.2695731831E-01, 4.9271785844E-01],
	[8.7950000000E+03, 3.6558113056E+00, 6.2941072789E+00, 1.3457219408E-01, 1.2717191402E-01, 4.9287705563E-01],
	[8.8000000000E+03, 3.6585290280E+00, 6.2930052567E+00, 1.3480958187E-01, 1.2738673644E-01, 4.9303621545E-01],
	[8.8050000000E+03, 3.6612472253E+00, 6.2919040532E+00, 1.3504725303E-01, 1.2760178566E-01, 4.9319533801E-01],
	[8.8100000000E+03, 3.6639658974E+00, 6.2908036674E+00, 1.3528520772E-01, 1.2781706172E-01, 4.9335442341E-01],
	[8.8150000000E+03, 3.6666850440E+00, 6.2897040983E+00, 1.3552344612E-01, 1.2803256470E-01, 4.9351347176E-01],
	[8.8200000000E+03, 3.6694046649E+00, 6.2886053447E+00, 1.3576196842E-01, 1.2824829466E-01, 4.9367248317E-01],
	[8.8250000000E+03, 3.6721247600E+00, 6.2875074056E+00, 1.3600077478E-01, 1.2846425166E-01, 4.9383145775E-01],
	[8.8300000000E+03, 3.6748453291E+00, 6.2864102799E+00, 1.3623986538E-01, 1.2868043578E-01, 4.9399039558E-01],
	[8.8350000000E+03, 3.6775663719E+00, 6.2853139665E+00, 1.3647924040E-01, 1.2889684708E-01, 4.9414929675E-01],
	[8.8400000000E+03, 3.6802878884E+00, 6.2842184644E+00, 1.3671890002E-01, 1.2911348562E-01, 4.9430816134E-01],
	[8.8450000000E+03, 3.6830098783E+00, 6.2831237726E+00, 1.3695884441E-01, 1.2933035146E-01, 4.9446698944E-01],
	[8.8500000000E+03, 3.6857323414E+00, 6.2820298899E+00, 1.3719907375E-01, 1.2954744468E-01, 4.9462578112E-01],
	[8.8550000000E+03, 3.6884552775E+00, 6.2809368154E+00, 1.3743958822E-01, 1.2976476534E-01, 4.9478453648E-01],
	[8.8600000000E+03, 3.6911786865E+00, 6.2798445479E+00, 1.3768038799E-01, 1.2998231350E-01, 4.9494325560E-01],
	[8.8650000000E+03, 3.6939025682E+00, 6.2787530865E+00, 1.3792147324E-01, 1.3020008923E-01, 4.9510193856E-01],
	[8.8700000000E+03, 3.6966269224E+00, 6.2776624300E+00, 1.3816284415E-01, 1.3041809258E-01, 4.9526058545E-01],
	[8.8750000000E+03, 3.6993517489E+00, 6.2765725774E+00, 1.3840450089E-01, 1.3063632363E-01, 4.9541919634E-01],
	[8.8800000000E+03, 3.7020770475E+00, 6.2754835277E+00, 1.3864644364E-01, 1.3085478244E-01, 4.9557777134E-01],
	[8.8850000000E+03, 3.7048028252E+00, 6.2743953174E+00, 1.3888867258E-01, 1.3107346910E-01, 4.9573631051E-01],
	[8.8900000000E+03, 3.7075328087E+00, 6.2733274090E+00, 1.3913118788E-01, 1.3129239686E-01, 4.9589481394E-01],
	[8.8950000000E+03, 3.7102632671E+00, 6.2722602826E+00, 1.3937398972E-01, 1.3151155266E-01, 4.9605328171E-01],
	[8.9000000000E+03, 3.7129942004E+00, 6.2711939372E+00, 1.3961707828E-01, 1.3173093654E-01, 4.9621171392E-01],
	[8.9050000000E+03, 3.7157256082E+00, 6.2701283719E+00, 1.3986045373E-01, 1.3195054858E-01, 4.9637011064E-01],
	[8.9100000000E+03, 3.7184574905E+00, 6.2690635856E+00, 1.4010411626E-01, 1.3217038883E-01, 4.9652847196E-01],
	[8.9150000000E+03, 3.7211898469E+00, 6.2679995774E+00, 1.4034806603E-01, 1.3239045737E-01, 4.9668679796E-01],
	[8.9200000000E+03, 3.7239226775E+00, 6.2669363461E+00, 1.4059230323E-01, 1.3261075425E-01, 4.9684508873E-01],
	[8.9250000000E+03, 3.7266559819E+00, 6.2658738909E+00, 1.4083682803E-01, 1.3283127953E-01, 4.9700334434E-01],
	[8.9300000000E+03, 3.7293897600E+00, 6.2648122107E+00, 1.4108164061E-01, 1.3305203328E-01, 4.9716156488E-01],
	[8.9350000000E+03, 3.7321240116E+00, 6.2637513045E+00, 1.4132674115E-01, 1.3327301557E-01, 4.9731975044E-01],
	[8.9400000000E+03, 3.7348587365E+00, 6.2626911714E+00, 1.4157212981E-01, 1.3349422645E-01, 4.9747790110E-01],
	[8.9450000000E+03, 3.7375939346E+00, 6.2616318102E+00, 1.4181780679E-01, 1.3371566599E-01, 4.9763601694E-01],
	[8.9500000000E+03, 3.7403296056E+00, 6.2605732201E+00, 1.4206377225E-01, 1.3393733424E-01, 4.9779409804E-01],
	[8.9550000000E+03, 3.7430657494E+00, 6.2595154001E+00, 1.4231002638E-01, 1.3415923128E-01, 4.9795214449E-01],
	[8.9600000000E+03, 3.7458023657E+00, 6.2584583490E+00, 1.4255656934E-01, 1.3438135716E-01, 4.9811015638E-01],
	[8.9650000000E+03, 3.7485394545E+00, 6.2574020661E+00, 1.4280340133E-01, 1.3460371194E-01, 4.9826813378E-01],
	[8.9700000000E+03, 3.7512770155E+00, 6.2563465502E+00, 1.4305052250E-01, 1.3482629569E-01, 4.9842607677E-01],
	[8.9750000000E+03, 3.7540150485E+00, 6.2552918004E+00, 1.4329793305E-01, 1.3504910847E-01, 4.9858398545E-01],
	[8.9800000000E+03, 3.7567535535E+00, 6.2542378158E+00, 1.4354563315E-01, 1.3527215034E-01, 4.9874185989E-01],
	[8.9850000000E+03, 3.7594925300E+00, 6.2531845952E+00, 1.4379362297E-01, 1.3549542135E-01, 4.9889970018E-01],
	[8.9900000000E+03, 3.7622319781E+00, 6.2521321378E+00, 1.4404190269E-01, 1.3571892158E-01, 4.9905750640E-01],
	[8.9950000000E+03, 3.7649718975E+00, 6.2510804426E+00, 1.4429047249E-01, 1.3594265108E-01, 4.9921527863E-01],
	[9.0000000000E+03, 3.7677122881E+00, 6.2500295086E+00, 1.4453933255E-01, 1.3616660992E-01, 4.9937301696E-01],
	[9.0050000000E+03, 3.7704531496E+00, 6.2489793348E+00, 1.4478999642E-01, 1.3639214107E-01, 4.9953072146E-01],
	[9.0100000000E+03, 3.7731944818E+00, 6.2479299203E+00, 1.4504095529E-01, 1.3661790514E-01, 4.9968839223E-01],
	[9.0150000000E+03, 3.7759362847E+00, 6.2468812641E+00, 1.4529220933E-01, 1.3684390220E-01, 4.9984602934E-01],
	[9.0200000000E+03, 3.7786785580E+00, 6.2458333651E+00, 1.4554375873E-01, 1.3707013232E-01, 5.0000363288E-01],
	[9.0250000000E+03, 3.7814213015E+00, 6.2447862226E+00, 1.4579560367E-01, 1.3729659555E-01, 5.0016120292E-01],
	[9.0300000000E+03, 3.7841659324E+00, 6.2437471879E+00, 1.4604774434E-01, 1.3752329740E-01, 5.0031873956E-01],
	[9.0350000000E+03, 3.7869132093E+00, 6.2427201732E+00, 1.4630018091E-01, 1.3775024088E-01, 5.0047624288E-01],
	[9.0400000000E+03, 3.7896609591E+00, 6.2416938954E+00, 1.4655291357E-01, 1.3797741775E-01, 5.0063371294E-01],
	[9.0450000000E+03, 3.7924091816E+00, 6.2406683536E+00, 1.4680594251E-01, 1.3820482807E-01, 5.0079114985E-01],
	[9.0500000000E+03, 3.7951578767E+00, 6.2396435470E+00, 1.4705926790E-01, 1.3843247189E-01, 5.0094855368E-01],
	[9.0550000000E+03, 3.7979070442E+00, 6.2386194745E+00, 1.4731288993E-01, 1.3866034928E-01, 5.0110592452E-01],
	[9.0600000000E+03, 3.8006566838E+00, 6.2375961353E+00, 1.4756680878E-01, 1.3888846031E-01, 5.0126326244E-01],
	[9.0650000000E+03, 3.8034067955E+00, 6.2365735285E+00, 1.4782102464E-01, 1.3911680502E-01, 5.0142056753E-01],
	[9.0700000000E+03, 3.8061573790E+00, 6.2355516530E+00, 1.4807553768E-01, 1.3934538350E-01, 5.0157783987E-01],
	[9.0750000000E+03, 3.8089084342E+00, 6.2345305080E+00, 1.4833034809E-01, 1.3957419579E-01, 5.0173507954E-01],
	[9.0800000000E+03, 3.8116599609E+00, 6.2335100925E+00, 1.4858545606E-01, 1.3980324196E-01, 5.0189228663E-01],
	[9.0850000000E+03, 3.8144119588E+00, 6.2324904057E+00, 1.4884086176E-01, 1.4003252207E-01, 5.0204946122E-01],
	[9.0900000000E+03, 3.8171644279E+00, 6.2314714465E+00, 1.4909656538E-01, 1.4026203618E-01, 5.0220660338E-01],
	[9.0950000000E+03, 3.8199173679E+00, 6.2304532142E+00, 1.4935256710E-01, 1.4049178436E-01, 5.0236371321E-01],
	[9.1000000000E+03, 3.8226707787E+00, 6.2294357077E+00, 1.4960886711E-01, 1.4072176666E-01, 5.0252079078E-01],
	[9.1050000000E+03, 3.8254246601E+00, 6.2284189262E+00, 1.4986546558E-01, 1.4095198314E-01, 5.0267783618E-01],
	[9.1100000000E+03, 3.8281790118E+00, 6.2274028687E+00, 1.5012236271E-01, 1.4118243387E-01, 5.0283484948E-01],
	[9.1150000000E+03, 3.8309338338E+00, 6.2263875343E+00, 1.5037955867E-01, 1.4141311890E-01, 5.0299183078E-01],
	[9.1200000000E+03, 3.8336891259E+00, 6.2253729221E+00, 1.5063705364E-01, 1.4164403830E-01, 5.0314878014E-01],
	[9.1250000000E+03, 3.8364448878E+00, 6.2243590313E+00, 1.5089484782E-01, 1.4187519212E-01, 5.0330569766E-01],
	[9.1300000000E+03, 3.8392011195E+00, 6.2233458608E+00, 1.5115294138E-01, 1.4210658043E-01, 5.0346258341E-01],
	[9.1350000000E+03, 3.8419578206E+00, 6.2223334098E+00, 1.5141133450E-01, 1.4233820329E-01, 5.0361943748E-01],
	[9.1400000000E+03, 3.8447149911E+00, 6.2213216774E+00, 1.5167002737E-01, 1.4257006075E-01, 5.0377625995E-01],
	[9.1450000000E+03, 3.8474726308E+00, 6.2203106627E+00, 1.5192902018E-01, 1.4280215288E-01, 5.0393305090E-01],
	[9.1500000000E+03, 3.8502307394E+00, 6.2193003648E+00, 1.5218831310E-01, 1.4303447973E-01, 5.0408981040E-01],
	[9.1550000000E+03, 3.8529893169E+00, 6.2182907828E+00, 1.5244790632E-01, 1.4326704136E-01, 5.0424653856E-01],
	[9.1600000000E+03, 3.8557483630E+00, 6.2172819157E+00, 1.5270780002E-01, 1.4349983783E-01, 5.0440323543E-01],
	[9.1650000000E+03, 3.8585078775E+00, 6.2162737627E+00, 1.5296799438E-01, 1.4373286921E-01, 5.0455990112E-01],
	[9.1700000000E+03, 3.8612678604E+00, 6.2152663229E+00, 1.5322848959E-01, 1.4396613555E-01, 5.0471653569E-01],
	[9.1750000000E+03, 3.8640294519E+00, 6.2142654096E+00, 1.5348928583E-01, 1.4419964163E-01, 5.0487313923E-01],
	[9.1800000000E+03, 3.8667938620E+00, 6.2132771698E+00, 1.5375038329E-01, 1.4443339255E-01, 5.0502971182E-01],
	[9.1850000000E+03, 3.8695587430E+00, 6.2122896251E+00, 1.5401178214E-01, 1.4466737869E-01, 5.0518625354E-01],
	[9.1900000000E+03, 3.8723240946E+00, 6.2113027747E+00, 1.5427348258E-01, 1.4490160011E-01, 5.0534276448E-01],
	[9.1950000000E+03, 3.8750899167E+00, 6.2103166177E+00, 1.5453548477E-01, 1.4513605687E-01, 5.0549924471E-01],
	[9.2000000000E+03, 3.8778562092E+00, 6.2093311533E+00, 1.5479778892E-01, 1.4537074901E-01, 5.0565569431E-01],
	[9.2050000000E+03, 3.8806229718E+00, 6.2083463805E+00, 1.5506039519E-01, 1.4560567661E-01, 5.0581211338E-01],
	[9.2100000000E+03, 3.8833902043E+00, 6.2073622986E+00, 1.5532330377E-01, 1.4584083972E-01, 5.0596850198E-01],
	[9.2150000000E+03, 3.8861579066E+00, 6.2063789066E+00, 1.5558651485E-01, 1.4607623839E-01, 5.0612486020E-01],
	[9.2200000000E+03, 3.8889260786E+00, 6.2053962037E+00, 1.5585002861E-01, 1.4631187268E-01, 5.0628118812E-01],
	[9.2250000000E+03, 3.8916947200E+00, 6.2044141891E+00, 1.5611384524E-01, 1.4654774266E-01, 5.0643748579E-01],
	[9.2300000000E+03, 3.8944638306E+00, 6.2034328618E+00, 1.5637796491E-01, 1.4678384838E-01, 5.0659375328E-01],
	[9.2350000000E+03, 3.8972334103E+00, 6.2024522211E+00, 1.5664238780E-01, 1.4702018989E-01, 5.0674999064E-01],
	[9.2400000000E+03, 3.9000034590E+00, 6.2014722661E+00, 1.5690711411E-01, 1.4725676725E-01, 5.0690619794E-01],
	[9.2450000000E+03, 3.9027739764E+00, 6.2004929959E+00, 1.5717214402E-01, 1.4749358053E-01, 5.0706237523E-01],
	[9.2500000000E+03, 3.9055449623E+00, 6.1995144097E+00, 1.5743747770E-01, 1.4773062976E-01, 5.0721852259E-01],
	[9.2550000000E+03, 3.9083164167E+00, 6.1985365067E+00, 1.5770311535E-01, 1.4796791503E-01, 5.0737464006E-01],
	[9.2600000000E+03, 3.9110883392E+00, 6.1975592859E+00, 1.5796905714E-01, 1.4820543637E-01, 5.0753072772E-01],
	[9.2650000000E+03, 3.9138607298E+00, 6.1965827466E+00, 1.5823530326E-01, 1.4844319384E-01, 5.0768678562E-01],
	[9.2700000000E+03, 3.9166335883E+00, 6.1956068879E+00, 1.5850185390E-01, 1.4868118751E-01, 5.0784281383E-01],
	[9.2750000000E+03, 3.9194069145E+00, 6.1946317090E+00, 1.5876870923E-01, 1.4891941742E-01, 5.0799881240E-01],
	[9.2800000000E+03, 3.9221807082E+00, 6.1936572090E+00, 1.5903586944E-01, 1.4915788363E-01, 5.0815478139E-01],
	[9.2850000000E+03, 3.9249549692E+00, 6.1926833871E+00, 1.5930333471E-01, 1.4939658621E-01, 5.0831072088E-01],
	[9.2900000000E+03, 3.9277296975E+00, 6.1917102425E+00, 1.5957110522E-01, 1.4963552519E-01, 5.0846663091E-01],
	[9.2950000000E+03, 3.9305048927E+00, 6.1907377742E+00, 1.5983918117E-01, 1.4987470065E-01, 5.0862251156E-01],
	[9.3000000000E+03, 3.9332805547E+00, 6.1897659816E+00, 1.6010756272E-01, 1.5011411263E-01, 5.0877836288E-01],
	[9.3050000000E+03, 3.9360566835E+00, 6.1887948637E+00, 1.6037625008E-01, 1.5035376118E-01, 5.0893418493E-01],
	[9.3100000000E+03, 3.9388332787E+00, 6.1878244197E+00, 1.6064524341E-01, 1.5059364637E-01, 5.0908997777E-01],
	[9.3150000000E+03, 3.9416103402E+00, 6.1868546489E+00, 1.6091454291E-01, 1.5083376825E-01, 5.0924574147E-01],
	[9.3200000000E+03, 3.9443878679E+00, 6.1858855502E+00, 1.6118414875E-01, 1.5107412687E-01, 5.0940147609E-01],
	[9.3250000000E+03, 3.9471685464E+00, 6.1849305513E+00, 1.6145406112E-01, 1.5131473428E-01, 5.0955718168E-01],
	[9.3300000000E+03, 3.9499504021E+00, 6.1839797551E+00, 1.6172428021E-01, 1.5155558177E-01, 5.0971285831E-01],
	[9.3350000000E+03, 3.9527327265E+00, 6.1830296142E+00, 1.6199480619E-01, 1.5179666625E-01, 5.0986850604E-01],
	[9.3400000000E+03, 3.9555155192E+00, 6.1820801281E+00, 1.6226563925E-01, 1.5203798777E-01, 5.1002412494E-01],
	[9.3450000000E+03, 3.9582987802E+00, 6.1811312957E+00, 1.6253677957E-01, 1.5227954640E-01, 5.1017971505E-01],
	[9.3500000000E+03, 3.9610825093E+00, 6.1801831164E+00, 1.6280822735E-01, 1.5252134217E-01, 5.1033527645E-01],
	[9.3550000000E+03, 3.9638667063E+00, 6.1792355894E+00, 1.6307998275E-01, 1.5276337515E-01, 5.1049080919E-01],
	[9.3600000000E+03, 3.9666513710E+00, 6.1782887138E+00, 1.6335204597E-01, 1.5300564539E-01, 5.1064631334E-01],
	[9.3650000000E+03, 3.9694365032E+00, 6.1773424889E+00, 1.6362441718E-01, 1.5324815294E-01, 5.1080178896E-01],
	[9.3700000000E+03, 3.9722221029E+00, 6.1763969138E+00, 1.6389709658E-01, 1.5349089786E-01, 5.1095723610E-01],
	[9.3750000000E+03, 3.9750081697E+00, 6.1754519878E+00, 1.6417008434E-01, 1.5373388020E-01, 5.1111265483E-01],
	[9.3800000000E+03, 3.9777947036E+00, 6.1745077100E+00, 1.6444338065E-01, 1.5397710000E-01, 5.1126804520E-01],
	[9.3850000000E+03, 3.9805817044E+00, 6.1735640798E+00, 1.6471698569E-01, 1.5422055734E-01, 5.1142340729E-01],
	[9.3900000000E+03, 3.9833691719E+00, 6.1726210962E+00, 1.6499089965E-01, 1.5446425224E-01, 5.1157874115E-01],
	[9.3950000000E+03, 3.9861571059E+00, 6.1716787586E+00, 1.6526512271E-01, 1.5470818478E-01, 5.1173404684E-01],
	[9.4000000000E+03, 3.9889455062E+00, 6.1707370660E+00, 1.6553965505E-01, 1.5495235500E-01, 5.1188932443E-01],
	[9.4050000000E+03, 3.9917343728E+00, 6.1697960178E+00, 1.6581449685E-01, 1.5519676296E-01, 5.1204457397E-01],
	[9.4100000000E+03, 3.9945237054E+00, 6.1688556132E+00, 1.6608964831E-01, 1.5544140869E-01, 5.1219979552E-01],
	[9.4150000000E+03, 3.9973135038E+00, 6.1679158513E+00, 1.6636510960E-01, 1.5568629227E-01, 5.1235498915E-01],
	[9.4200000000E+03, 4.0001037679E+00, 6.1669767315E+00, 1.6664088091E-01, 1.5593141374E-01, 5.1251015491E-01],
	[9.4250000000E+03, 4.0028944975E+00, 6.1660382528E+00, 1.6691696242E-01, 1.5617677314E-01, 5.1266529288E-01],
	[9.4300000000E+03, 4.0056856925E+00, 6.1651004146E+00, 1.6719335431E-01, 1.5642237054E-01, 5.1282040310E-01],
	[9.4350000000E+03, 4.0084773526E+00, 6.1641632160E+00, 1.6747005677E-01, 1.5666820598E-01, 5.1297548564E-01],
	[9.4400000000E+03, 4.0112694778E+00, 6.1632266564E+00, 1.6774706999E-01, 1.5691427952E-01, 5.1313054056E-01],
	[9.4450000000E+03, 4.0140620677E+00, 6.1622907348E+00, 1.6802439414E-01, 1.5716059120E-01, 5.1328556792E-01],
	[9.4500000000E+03, 4.0168551224E+00, 6.1613554506E+00, 1.6830202941E-01, 1.5740714108E-01, 5.1344056778E-01],
	[9.4550000000E+03, 4.0196486415E+00, 6.1604208030E+00, 1.6857997598E-01, 1.5765392920E-01, 5.1359554021E-01],
	[9.4600000000E+03, 4.0224426250E+00, 6.1594867911E+00, 1.6885823405E-01, 1.5790095562E-01, 5.1375048526E-01],
	[9.4650000000E+03, 4.0252370726E+00, 6.1585534143E+00, 1.6913680378E-01, 1.5814822039E-01, 5.1390540299E-01],
	[9.4700000000E+03, 4.0280319843E+00, 6.1576206717E+00, 1.6941568537E-01, 1.5839572356E-01, 5.1406029347E-01],
	[9.4750000000E+03, 4.0308299307E+00, 6.1567011900E+00, 1.6969487899E-01, 1.5864347754E-01, 5.1421515675E-01],
	[9.4800000000E+03, 4.0336290688E+00, 6.1557858922E+00, 1.6997438484E-01, 1.5889147358E-01, 5.1436999290E-01],
	[9.4850000000E+03, 4.0364286732E+00, 6.1548712130E+00, 1.7025420309E-01, 1.5913970826E-01, 5.1452480198E-01],
	[9.4900000000E+03, 4.0392287438E+00, 6.1539571516E+00, 1.7053437278E-01, 1.5938821555E-01, 5.1467958404E-01],
	[9.4950000000E+03, 4.0420292804E+00, 6.1530437074E+00, 1.7081487782E-01, 1.5963698128E-01, 5.1483433915E-01],
	[9.5000000000E+03, 4.0448302827E+00, 6.1521308795E+00, 1.7109569600E-01, 1.5988598595E-01, 5.1498906738E-01],
	[9.5050000000E+03, 4.0476317508E+00, 6.1512186672E+00, 1.7137682752E-01, 1.6013522959E-01, 5.1514376877E-01],
	[9.5100000000E+03, 4.0504336843E+00, 6.1503070699E+00, 1.7165827255E-01, 1.6038471226E-01, 5.1529844339E-01],
	[9.5150000000E+03, 4.0532360831E+00, 6.1493960866E+00, 1.7194003128E-01, 1.6063443401E-01, 5.1545309131E-01],
	[9.5200000000E+03, 4.0560389471E+00, 6.1484857168E+00, 1.7222210390E-01, 1.6088439489E-01, 5.1560771257E-01],
	[9.5250000000E+03, 4.0588422761E+00, 6.1475759597E+00, 1.7250449058E-01, 1.6113459494E-01, 5.1576230725E-01],
	[9.5300000000E+03, 4.0616460699E+00, 6.1466668145E+00, 1.7278719152E-01, 1.6138503422E-01, 5.1591687540E-01],
	[9.5350000000E+03, 4.0644503283E+00, 6.1457582805E+00, 1.7307020689E-01, 1.6163571276E-01, 5.1607141709E-01],
	[9.5400000000E+03, 4.0672550513E+00, 6.1448503570E+00, 1.7335353688E-01, 1.6188663064E-01, 5.1622593237E-01],
	[9.5450000000E+03, 4.0700602385E+00, 6.1439430432E+00, 1.7363718167E-01, 1.6213778788E-01, 5.1638042131E-01],
	[9.5500000000E+03, 4.0728658899E+00, 6.1430363385E+00, 1.7392114146E-01, 1.6238918453E-01, 5.1653488396E-01],
	[9.5550000000E+03, 4.0756720053E+00, 6.1421302421E+00, 1.7420541641E-01, 1.6264082066E-01, 5.1668932039E-01],
	[9.5600000000E+03, 4.0784785845E+00, 6.1412247532E+00, 1.7449000673E-01, 1.6289269629E-01, 5.1684373065E-01],
	[9.5650000000E+03, 4.0812856273E+00, 6.1403198712E+00, 1.7477491259E-01, 1.6314481149E-01, 5.1699811482E-01],
	[9.5700000000E+03, 4.0840931336E+00, 6.1394155952E+00, 1.7506013417E-01, 1.6339716629E-01, 5.1715247294E-01],
	[9.5750000000E+03, 4.0869011033E+00, 6.1385119247E+00, 1.7534567166E-01, 1.6364976075E-01, 5.1730680508E-01],
	[9.5800000000E+03, 4.0897095361E+00, 6.1376088589E+00, 1.7563152525E-01, 1.6390259491E-01, 5.1746111130E-01],
	[9.5850000000E+03, 4.0925184319E+00, 6.1367063970E+00, 1.7591769511E-01, 1.6415566883E-01, 5.1761539166E-01],
	[9.5900000000E+03, 4.0953277905E+00, 6.1358045384E+00, 1.7620418144E-01, 1.6440898253E-01, 5.1776964622E-01],
	[9.5950000000E+03, 4.0981376117E+00, 6.1349032823E+00, 1.7649098442E-01, 1.6466253608E-01, 5.1792387504E-01],
	[9.6000000000E+03, 4.1009478955E+00, 6.1340026279E+00, 1.7677810423E-01, 1.6491632952E-01, 5.1807807816E-01],
	[9.6050000000E+03, 4.1037586416E+00, 6.1331025747E+00, 1.7706554105E-01, 1.6517036290E-01, 5.1823225563E-01],
	[9.6100000000E+03, 4.1065698499E+00, 6.1322031219E+00, 1.7735329507E-01, 1.6542463625E-01, 5.1838640749E-01],
	[9.6150000000E+03, 4.1093815201E+00, 6.1313042687E+00, 1.7764136648E-01, 1.6567914964E-01, 5.1854053378E-01],
	[9.6200000000E+03, 4.1121936522E+00, 6.1304060144E+00, 1.7792975546E-01, 1.6593390309E-01, 5.1869463454E-01],
	[9.6250000000E+03, 4.1150071591E+00, 6.1295127665E+00, 1.7821846219E-01, 1.6618890140E-01, 5.1884870982E-01],
	[9.6300000000E+03, 4.1178234137E+00, 6.1286311368E+00, 1.7850748686E-01, 1.6644415176E-01, 5.1900275966E-01],
	[9.6350000000E+03, 4.1206401324E+00, 6.1277500915E+00, 1.7879682966E-01, 1.6669964242E-01, 5.1915678411E-01],
	[9.6400000000E+03, 4.1234573149E+00, 6.1268696298E+00, 1.7908649075E-01, 1.6695537343E-01, 5.1931078321E-01],
	[9.6450000000E+03, 4.1262749612E+00, 6.1259897510E+00, 1.7937647035E-01, 1.6721134482E-01, 5.1946475700E-01],
	[9.6500000000E+03, 4.1290930711E+00, 6.1251104545E+00, 1.7966676861E-01, 1.6746755665E-01, 5.1961870553E-01],
	[9.6550000000E+03, 4.1319116443E+00, 6.1242317397E+00, 1.7995738574E-01, 1.6772400897E-01, 5.1977262884E-01],
	[9.6600000000E+03, 4.1347306808E+00, 6.1233536057E+00, 1.8024832191E-01, 1.6798070180E-01, 5.1992652697E-01],
	[9.6650000000E+03, 4.1375501804E+00, 6.1224760519E+00, 1.8053957731E-01, 1.6823763521E-01, 5.2008039997E-01],
	[9.6700000000E+03, 4.1403701428E+00, 6.1215990777E+00, 1.8083115212E-01, 1.6849480923E-01, 5.2023424788E-01],
	[9.6750000000E+03, 4.1431905680E+00, 6.1207226823E+00, 1.8112304653E-01, 1.6875222391E-01, 5.2038807075E-01],
	[9.6800000000E+03, 4.1460114558E+00, 6.1198468651E+00, 1.8141526073E-01, 1.6900987929E-01, 5.2054186861E-01],
	[9.6850000000E+03, 4.1488328060E+00, 6.1189716254E+00, 1.8170779489E-01, 1.6926777542E-01, 5.2069564152E-01],
	[9.6900000000E+03, 4.1516546185E+00, 6.1180969625E+00, 1.8200064920E-01, 1.6952591234E-01, 5.2084938951E-01],
	[9.6950000000E+03, 4.1544768930E+00, 6.1172228757E+00, 1.8229382385E-01, 1.6978429010E-01, 5.2100311264E-01],
	[9.7000000000E+03, 4.1572996295E+00, 6.1163493644E+00, 1.8258731902E-01, 1.7004290873E-01, 5.2115681094E-01],
	[9.7050000000E+03, 4.1601228278E+00, 6.1154764279E+00, 1.8288113490E-01, 1.7030176829E-01, 5.2131048445E-01],
	[9.7100000000E+03, 4.1629464876E+00, 6.1146040655E+00, 1.8317527166E-01, 1.7056086881E-01, 5.2146413323E-01],
	[9.7150000000E+03, 4.1657706089E+00, 6.1137322765E+00, 1.8346972950E-01, 1.7082021034E-01, 5.2161775731E-01],
	[9.7200000000E+03, 4.1685951915E+00, 6.1128610603E+00, 1.8376450860E-01, 1.7107979292E-01, 5.2177135674E-01],
	[9.7250000000E+03, 4.1714202352E+00, 6.1119904162E+00, 1.8405960914E-01, 1.7133961659E-01, 5.2192493156E-01],
	[9.7300000000E+03, 4.1742457398E+00, 6.1111203435E+00, 1.8435503131E-01, 1.7159968140E-01, 5.2207848182E-01],
	[9.7350000000E+03, 4.1770717053E+00, 6.1102508416E+00, 1.8465077530E-01, 1.7185998739E-01, 5.2223200755E-01],
	[9.7400000000E+03, 4.1798981313E+00, 6.1093819098E+00, 1.8494684128E-01, 1.7212053459E-01, 5.2238550881E-01],
	[9.7450000000E+03, 4.1827250179E+00, 6.1085135474E+00, 1.8524322944E-01, 1.7238132307E-01, 5.2253898564E-01],
	[9.7500000000E+03, 4.1855523647E+00, 6.1076457537E+00, 1.8553993997E-01, 1.7264235284E-01, 5.2269243808E-01],
	[9.7550000000E+03, 4.1883801717E+00, 6.1067785282E+00, 1.8583697305E-01, 1.7290362397E-01, 5.2284586618E-01],
	[9.7600000000E+03, 4.1912084387E+00, 6.1059118700E+00, 1.8613432887E-01, 1.7316513648E-01, 5.2299926997E-01],
	[9.7650000000E+03, 4.1940371655E+00, 6.1050457787E+00, 1.8643200761E-01, 1.7342689042E-01, 5.2315264951E-01],
	[9.7700000000E+03, 4.1968663520E+00, 6.1041802534E+00, 1.8673000945E-01, 1.7368888584E-01, 5.2330600483E-01],
	[9.7750000000E+03, 4.1996959980E+00, 6.1033152936E+00, 1.8702833459E-01, 1.7395112277E-01, 5.2345933598E-01],
	[9.7800000000E+03, 4.2025270337E+00, 6.1024553142E+00, 1.8732698320E-01, 1.7421360645E-01, 5.2361264301E-01],
	[9.7850000000E+03, 4.2053606984E+00, 6.1016061806E+00, 1.8762595547E-01, 1.7447634389E-01, 5.2376592595E-01],
	[9.7900000000E+03, 4.2081948247E+00, 6.1007575990E+00, 1.8792525158E-01, 1.7473932306E-01, 5.2391918485E-01],
	[9.7950000000E+03, 4.2110294124E+00, 6.0999095685E+00, 1.8822487172E-01, 1.7500254400E-01, 5.2407241977E-01],
	[9.8000000000E+03, 4.2138644614E+00, 6.0990620886E+00, 1.8852481608E-01, 1.7526600675E-01, 5.2422563073E-01],
	[9.8050000000E+03, 4.2166999716E+00, 6.0982151586E+00, 1.8882508484E-01, 1.7552971135E-01, 5.2437881778E-01],
	[9.8100000000E+03, 4.2195359427E+00, 6.0973687779E+00, 1.8912567818E-01, 1.7579365783E-01, 5.2453198097E-01],
	[9.8150000000E+03, 4.2223723747E+00, 6.0965229459E+00, 1.8942659628E-01, 1.7605784625E-01, 5.2468512034E-01],
	[9.8200000000E+03, 4.2252092673E+00, 6.0956776619E+00, 1.8972783934E-01, 1.7632227664E-01, 5.2483823593E-01],
	[9.8250000000E+03, 4.2280466204E+00, 6.0948329253E+00, 1.9002940754E-01, 1.7658694903E-01, 5.2499132780E-01],
	[9.8300000000E+03, 4.2308844338E+00, 6.0939887354E+00, 1.9033130107E-01, 1.7685186348E-01, 5.2514439598E-01],
	[9.8350000000E+03, 4.2337227074E+00, 6.0931450917E+00, 1.9063352010E-01, 1.7711702001E-01, 5.2529744051E-01],
	[9.8400000000E+03, 4.2365614411E+00, 6.0923019934E+00, 1.9093606482E-01, 1.7738241867E-01, 5.2545046144E-01],
	[9.8450000000E+03, 4.2394006345E+00, 6.0914594401E+00, 1.9123893542E-01, 1.7764805950E-01, 5.2560345882E-01],
	[9.8500000000E+03, 4.2422402877E+00, 6.0906174309E+00, 1.9154213208E-01, 1.7791394254E-01, 5.2575643268E-01],
	[9.8550000000E+03, 4.2450804004E+00, 6.0897759654E+00, 1.9184565499E-01, 1.7818006782E-01, 5.2590938308E-01],
	[9.8600000000E+03, 4.2479209725E+00, 6.0889350428E+00, 1.9214950433E-01, 1.7844643538E-01, 5.2606231005E-01],
	[9.8650000000E+03, 4.2507620038E+00, 6.0880946626E+00, 1.9245368029E-01, 1.7871304527E-01, 5.2621521365E-01],
	[9.8700000000E+03, 4.2536034942E+00, 6.0872548242E+00, 1.9275818305E-01, 1.7897989752E-01, 5.2636809390E-01],
	[9.8750000000E+03, 4.2564454435E+00, 6.0864155268E+00, 1.9306301279E-01, 1.7924699217E-01, 5.2652095087E-01],
	[9.8800000000E+03, 4.2592878515E+00, 6.0855767700E+00, 1.9336816971E-01, 1.7951432926E-01, 5.2667378458E-01],
	[9.8850000000E+03, 4.2621307181E+00, 6.0847385529E+00, 1.9367365398E-01, 1.7978190882E-01, 5.2682659509E-01],
	[9.8900000000E+03, 4.2649740432E+00, 6.0839008752E+00, 1.9397946580E-01, 1.8004973089E-01, 5.2697938244E-01],
	[9.8950000000E+03, 4.2678178265E+00, 6.0830637360E+00, 1.9428560534E-01, 1.8031779552E-01, 5.2713214668E-01],
	[9.9000000000E+03, 4.2706620679E+00, 6.0822271349E+00, 1.9459207280E-01, 1.8058610273E-01, 5.2728488784E-01],
	[9.9050000000E+03, 4.2735067673E+00, 6.0813910712E+00, 1.9489886835E-01, 1.8085465257E-01, 5.2743760597E-01],
	[9.9100000000E+03, 4.2763519245E+00, 6.0805555442E+00, 1.9520599218E-01, 1.8112344507E-01, 5.2759030112E-01],
	[9.9150000000E+03, 4.2791975393E+00, 6.0797205534E+00, 1.9551344448E-01, 1.8139248027E-01, 5.2774297333E-01],
	[9.9200000000E+03, 4.2820436116E+00, 6.0788860981E+00, 1.9582122543E-01, 1.8166175821E-01, 5.2789562264E-01],
	[9.9250000000E+03, 4.2848901412E+00, 6.0780521778E+00, 1.9612933522E-01, 1.8193127892E-01, 5.2804824910E-01],
	[9.9300000000E+03, 4.2877371280E+00, 6.0772187918E+00, 1.9643777403E-01, 1.8220104244E-01, 5.2820085275E-01],
	[9.9350000000E+03, 4.2905845718E+00, 6.0763859395E+00, 1.9674654204E-01, 1.8247104880E-01, 5.2835343364E-01],
	[9.9400000000E+03, 4.2934349267E+00, 6.0755650482E+00, 1.9705563945E-01, 1.8274131283E-01, 5.2850599180E-01],
	[9.9450000000E+03, 4.2962862932E+00, 6.0747472535E+00, 1.9736506643E-01, 1.8301182320E-01, 5.2865852729E-01],
	[9.9500000000E+03, 4.2991381188E+00, 6.0739299798E+00, 1.9767482318E-01, 1.8328257661E-01, 5.2881104015E-01],
	[9.9550000000E+03, 4.3019904032E+00, 6.0731132266E+00, 1.9798490987E-01, 1.8355357311E-01, 5.2896353042E-01],
	[9.9600000000E+03, 4.3048431464E+00, 6.0722969932E+00, 1.9829532669E-01, 1.8382481273E-01, 5.2911599821E-01],
	[9.9650000000E+03, 4.3076963481E+00, 6.0714812791E+00, 1.9860607383E-01, 1.8409629550E-01, 5.2926844368E-01],
	[9.9700000000E+03, 4.3105500082E+00, 6.0706660837E+00, 1.9891715148E-01, 1.8436802147E-01, 5.2942086685E-01],
	[9.9750000000E+03, 4.3134041265E+00, 6.0698514064E+00, 1.9922855981E-01, 1.8463999066E-01, 5.2957326775E-01],
	[9.9800000000E+03, 4.3162587029E+00, 6.0690372466E+00, 1.9954029901E-01, 1.8491220311E-01, 5.2972564640E-01],
	[9.9850000000E+03, 4.3191137373E+00, 6.0682236037E+00, 1.9985236927E-01, 1.8518465886E-01, 5.2987800283E-01],
	[9.9900000000E+03, 4.3219692294E+00, 6.0674104772E+00, 2.0016477078E-01, 1.8545735794E-01, 5.3003033705E-01],
	[9.9950000000E+03, 4.3248251791E+00, 6.0665978664E+00, 2.0047750371E-01, 1.8573030039E-01, 5.3018264910E-01],
	[1.0000000000E+04, 4.3276815863E+00, 6.0657857707E+00, 2.0079056825E-01, 1.8600348623E-01, 5.3033493899E-01],
	[1.0005000000E+04, 4.3305384508E+00, 6.0649741896E+00, 2.0110522557E-01, 1.8627799740E-01, 5.3048720675E-01],
	[1.0010000000E+04, 4.3333957724E+00, 6.0641631226E+00, 2.0142021819E-01, 1.8655275450E-01, 5.3063945240E-01],
	[1.0015000000E+04, 4.3362535510E+00, 6.0633525689E+00, 2.0173554631E-01, 1.8682775756E-01, 5.3079167596E-01],
	[1.0020000000E+04, 4.3391117865E+00, 6.0625425280E+00, 2.0205121012E-01, 1.8710300662E-01, 5.3094387747E-01],
	[1.0025000000E+04, 4.3419704787E+00, 6.0617329994E+00, 2.0236720981E-01, 1.8737850171E-01, 5.3109605694E-01],
	[1.0030000000E+04, 4.3448296273E+00, 6.0609239825E+00, 2.0268354556E-01, 1.8765424287E-01, 5.3124821439E-01],
	[1.0035000000E+04, 4.3476892324E+00, 6.0601154767E+00, 2.0300021757E-01, 1.8793023014E-01, 5.3140034986E-01],
	[1.0040000000E+04, 4.3505492937E+00, 6.0593074813E+00, 2.0331722602E-01, 1.8820646354E-01, 5.3155246335E-01],
	[1.0045000000E+04, 4.3534098110E+00, 6.0584999959E+00, 2.0363457110E-01, 1.8848294312E-01, 5.3170455491E-01],
	[1.0050000000E+04, 4.3562707842E+00, 6.0576930199E+00, 2.0395225300E-01, 1.8875966890E-01, 5.3185662455E-01],
	[1.0055000000E+04, 4.3591322132E+00, 6.0568865527E+00, 2.0427027192E-01, 1.8903664093E-01, 5.3200867229E-01],
	[1.0060000000E+04, 4.3619940978E+00, 6.0560805937E+00, 2.0458862804E-01, 1.8931385923E-01, 5.3216069817E-01],
	[1.0065000000E+04, 4.3648564379E+00, 6.0552751423E+00, 2.0490732155E-01, 1.8959132384E-01, 5.3231270219E-01],
	[1.0070000000E+04, 4.3677192332E+00, 6.0544701980E+00, 2.0522635264E-01, 1.8986903479E-01, 5.3246468440E-01],
	[1.0075000000E+04, 4.3705824837E+00, 6.0536657602E+00, 2.0554572150E-01, 1.9014699212E-01, 5.3261664480E-01],
	[1.0080000000E+04, 4.3734461892E+00, 6.0528618283E+00, 2.0586542832E-01, 1.9042519586E-01, 5.3276858343E-01],
	[1.0085000000E+04, 4.3763103494E+00, 6.0520584017E+00, 2.0618547329E-01, 1.9070364605E-01, 5.3292050031E-01],
	[1.0090000000E+04, 4.3791749644E+00, 6.0512554800E+00, 2.0650585659E-01, 1.9098234271E-01, 5.3307239546E-01],
	[1.0095000000E+04, 4.3820400339E+00, 6.0504530625E+00, 2.0682657843E-01, 1.9126128588E-01, 5.3322426890E-01],
	[1.0100000000E+04, 4.3849080627E+00, 6.0496622330E+00, 2.0714763897E-01, 1.9154049148E-01, 5.3337612067E-01],
	[1.0105000000E+04, 4.3877770785E+00, 6.0488742449E+00, 2.0746903843E-01, 1.9181994711E-01, 5.3352795078E-01],
	[1.0110000000E+04, 4.3906465509E+00, 6.0480867492E+00, 2.0779077698E-01, 1.9209964945E-01, 5.3367975926E-01],
	[1.0115000000E+04, 4.3935164796E+00, 6.0472997453E+00, 2.0811285481E-01, 1.9237959853E-01, 5.3383154614E-01],
	[1.0120000000E+04, 4.3963868646E+00, 6.0465132327E+00, 2.0843527212E-01, 1.9265979438E-01, 5.3398331143E-01],
	[1.0125000000E+04, 4.3992577056E+00, 6.0457272108E+00, 2.0875802909E-01, 1.9294023703E-01, 5.3413505516E-01],
	[1.0130000000E+04, 4.4021290025E+00, 6.0449416790E+00, 2.0908112591E-01, 1.9322092652E-01, 5.3428677736E-01],
	[1.0135000000E+04, 4.4050007553E+00, 6.0441566369E+00, 2.0940456278E-01, 1.9350186287E-01, 5.3443847804E-01],
	[1.0140000000E+04, 4.4078729636E+00, 6.0433720838E+00, 2.0972833988E-01, 1.9378304612E-01, 5.3459015724E-01],
	[1.0145000000E+04, 4.4107456274E+00, 6.0425880193E+00, 2.1005245740E-01, 1.9406447630E-01, 5.3474181498E-01],
	[1.0150000000E+04, 4.4136187465E+00, 6.0418044428E+00, 2.1037691553E-01, 1.9434615344E-01, 5.3489345128E-01],
	[1.0155000000E+04, 4.4164923208E+00, 6.0410213537E+00, 2.1070171446E-01, 1.9462807758E-01, 5.3504506616E-01],
	[1.0160000000E+04, 4.4193663501E+00, 6.0402387515E+00, 2.1102685439E-01, 1.9491024874E-01, 5.3519665966E-01],
	[1.0165000000E+04, 4.4222408342E+00, 6.0394566356E+00, 2.1135233549E-01, 1.9519266695E-01, 5.3534823179E-01],
	[1.0170000000E+04, 4.4251157730E+00, 6.0386750056E+00, 2.1167815796E-01, 1.9547533225E-01, 5.3549978257E-01],
	[1.0175000000E+04, 4.4279911664E+00, 6.0378938608E+00, 2.1200432199E-01, 1.9575824466E-01, 5.3565131205E-01],
	[1.0180000000E+04, 4.4308670142E+00, 6.0371132008E+00, 2.1233082777E-01, 1.9604140422E-01, 5.3580282023E-01],
	[1.0185000000E+04, 4.4337433162E+00, 6.0363330249E+00, 2.1265767549E-01, 1.9632481095E-01, 5.3595430714E-01],
	[1.0190000000E+04, 4.4366200724E+00, 6.0355533327E+00, 2.1298486533E-01, 1.9660846489E-01, 5.3610577281E-01],
	[1.0195000000E+04, 4.4394972825E+00, 6.0347741237E+00, 2.1331239750E-01, 1.9689236607E-01, 5.3625721726E-01],
	[1.0200000000E+04, 4.4423749463E+00, 6.0339953972E+00, 2.1364027217E-01, 1.9717651451E-01, 5.3640864051E-01],
	[1.0205000000E+04, 4.4452530639E+00, 6.0332171528E+00, 2.1396848953E-01, 1.9746091025E-01, 5.3656004260E-01],
	[1.0210000000E+04, 4.4481316349E+00, 6.0324393898E+00, 2.1429704979E-01, 1.9774555331E-01, 5.3671142353E-01],
	[1.0215000000E+04, 4.4510106593E+00, 6.0316621079E+00, 2.1462595312E-01, 1.9803044372E-01, 5.3686278335E-01],
	[1.0220000000E+04, 4.4538901368E+00, 6.0308853064E+00, 2.1495519971E-01, 1.9831558152E-01, 5.3701412207E-01],
	[1.0225000000E+04, 4.4567700674E+00, 6.0301089848E+00, 2.1528478976E-01, 1.9860096673E-01, 5.3716543972E-01],
	[1.0230000000E+04, 4.4596504509E+00, 6.0293331426E+00, 2.1561472346E-01, 1.9888659938E-01, 5.3731673632E-01],
	[1.0235000000E+04, 4.4625312871E+00, 6.0285577793E+00, 2.1594500099E-01, 1.9917247949E-01, 5.3746801190E-01],
	[1.0240000000E+04, 4.4654125760E+00, 6.0277828943E+00, 2.1627562254E-01, 1.9945860710E-01, 5.3761926648E-01],
	[1.0245000000E+04, 4.4682943172E+00, 6.0270084871E+00, 2.1660658831E-01, 1.9974498224E-01, 5.3777050008E-01],
	[1.0250000000E+04, 4.4711765108E+00, 6.0262345571E+00, 2.1693789849E-01, 2.0003160493E-01, 5.3792171274E-01],
	[1.0255000000E+04, 4.4740591565E+00, 6.0254611039E+00, 2.1726955326E-01, 2.0031847520E-01, 5.3807290447E-01],
	[1.0260000000E+04, 4.4769432625E+00, 6.0246922658E+00, 2.1760155281E-01, 2.0060559969E-01, 5.3822407530E-01],
	[1.0265000000E+04, 4.4798299721E+00, 6.0239327221E+00, 2.1793389733E-01, 2.0089298599E-01, 5.3837522526E-01],
	[1.0270000000E+04, 4.4827171359E+00, 6.0231736441E+00, 2.1826658702E-01, 2.0118062006E-01, 5.3852635437E-01],
	[1.0275000000E+04, 4.4856047538E+00, 6.0224150311E+00, 2.1859962206E-01, 2.0146850192E-01, 5.3867746265E-01],
	[1.0280000000E+04, 4.4884928256E+00, 6.0216568826E+00, 2.1893300265E-01, 2.0175663160E-01, 5.3882855013E-01],
	[1.0285000000E+04, 4.4913813512E+00, 6.0208991982E+00, 2.1926672897E-01, 2.0204500913E-01, 5.3897961683E-01],
	[1.0290000000E+04, 4.4942703304E+00, 6.0201419773E+00, 2.1960080121E-01, 2.0233363454E-01, 5.3913066278E-01],
	[1.0295000000E+04, 4.4971597631E+00, 6.0193852194E+00, 2.1993521956E-01, 2.0262250785E-01, 5.3928168801E-01],
	[1.0300000000E+04, 4.5000496492E+00, 6.0186289240E+00, 2.2026998422E-01, 2.0291162909E-01, 5.3943269254E-01],
	[1.0305000000E+04, 4.5029399884E+00, 6.0178730906E+00, 2.2060509537E-01, 2.0320099828E-01, 5.3958367638E-01],
	[1.0310000000E+04, 4.5058307806E+00, 6.0171177187E+00, 2.2094055320E-01, 2.0349061546E-01, 5.3973463958E-01],
	[1.0315000000E+04, 4.5087220257E+00, 6.0163628078E+00, 2.2127635790E-01, 2.0378048064E-01, 5.3988558215E-01],
	[1.0320000000E+04, 4.5116137236E+00, 6.0156083573E+00, 2.2161250966E-01, 2.0407059386E-01, 5.4003650412E-01],
	[1.0325000000E+04, 4.5145058740E+00, 6.0148543669E+00, 2.2194900868E-01, 2.0436095514E-01, 5.4018740551E-01],
	[1.0330000000E+04, 4.5173984769E+00, 6.0141008359E+00, 2.2228585514E-01, 2.0465156451E-01, 5.4033828635E-01],
	[1.0335000000E+04, 4.5202915320E+00, 6.0133477639E+00, 2.2262304923E-01, 2.0494242199E-01, 5.4048914666E-01],
	[1.0340000000E+04, 4.5231850393E+00, 6.0125951504E+00, 2.2296059114E-01, 2.0523352760E-01, 5.4063998647E-01],
	[1.0345000000E+04, 4.5260789986E+00, 6.0118429948E+00, 2.2329848107E-01, 2.0552488137E-01, 5.4079080581E-01],
	[1.0350000000E+04, 4.5289734098E+00, 6.0110912967E+00, 2.2363671919E-01, 2.0581648333E-01, 5.4094160469E-01],
	[1.0355000000E+04, 4.5318682726E+00, 6.0103400556E+00, 2.2397530571E-01, 2.0610833350E-01, 5.4109238315E-01],
	[1.0360000000E+04, 4.5347635870E+00, 6.0095892710E+00, 2.2431424081E-01, 2.0640043191E-01, 5.4124314120E-01],
	[1.0365000000E+04, 4.5376593528E+00, 6.0088389423E+00, 2.2465352468E-01, 2.0669277857E-01, 5.4139387888E-01],
	[1.0370000000E+04, 4.5405555698E+00, 6.0080890691E+00, 2.2499315752E-01, 2.0698537353E-01, 5.4154459621E-01],
	[1.0375000000E+04, 4.5434522379E+00, 6.0073396509E+00, 2.2533313950E-01, 2.0727821678E-01, 5.4169529321E-01],
	[1.0380000000E+04, 4.5463493570E+00, 6.0065906872E+00, 2.2567347083E-01, 2.0757130837E-01, 5.4184596991E-01],
	[1.0385000000E+04, 4.5492469269E+00, 6.0058421775E+00, 2.2601415169E-01, 2.0786464832E-01, 5.4199662633E-01],
	[1.0390000000E+04, 4.5521449475E+00, 6.0050941213E+00, 2.2635518227E-01, 2.0815823665E-01, 5.4214726250E-01],
	[1.0395000000E+04, 4.5550434186E+00, 6.0043465181E+00, 2.2669656277E-01, 2.0845207338E-01, 5.4229787845E-01],
	[1.0400000000E+04, 4.5579423401E+00, 6.0035993674E+00, 2.2703829337E-01, 2.0874615853E-01, 5.4244847420E-01],
	[1.0405000000E+04, 4.5608417117E+00, 6.0028526688E+00, 2.2738037426E-01, 2.0904049213E-01, 5.4259904977E-01],
	[1.0410000000E+04, 4.5637415335E+00, 6.0021064216E+00, 2.2772280563E-01, 2.0933507421E-01, 5.4274960520E-01],
	[1.0415000000E+04, 4.5666418052E+00, 6.0013606256E+00, 2.2806558767E-01, 2.0962990478E-01, 5.4290014050E-01],
	[1.0420000000E+04, 4.5695425267E+00, 6.0006152800E+00, 2.2840872058E-01, 2.0992498387E-01, 5.4305065570E-01],
	[1.0425000000E+04, 4.5724446506E+00, 5.9998740123E+00, 2.2875220454E-01, 2.1022031796E-01, 5.4320115083E-01],
	[1.0430000000E+04, 4.5753495586E+00, 5.9991420706E+00, 2.2909603975E-01, 2.1051591653E-01, 5.4335162591E-01],
	[1.0435000000E+04, 4.5782549185E+00, 5.9984105689E+00, 2.2944022639E-01, 2.1081176378E-01, 5.4350208097E-01],
	[1.0440000000E+04, 4.5811607301E+00, 5.9976795068E+00, 2.2978476465E-01, 2.1110785975E-01, 5.4365251603E-01],
	[1.0445000000E+04, 4.5840669935E+00, 5.9969488837E+00, 2.3012965473E-01, 2.1140420446E-01, 5.4380293112E-01],
	[1.0450000000E+04, 4.5869737083E+00, 5.9962186992E+00, 2.3047489681E-01, 2.1170079793E-01, 5.4395332626E-01],
	[1.0455000000E+04, 4.5898808745E+00, 5.9954889529E+00, 2.3082049108E-01, 2.1199764018E-01, 5.4410370148E-01],
	[1.0460000000E+04, 4.5927884919E+00, 5.9947596442E+00, 2.3116643774E-01, 2.1229473124E-01, 5.4425405681E-01],
	[1.0465000000E+04, 4.5956965604E+00, 5.9940307727E+00, 2.3151273698E-01, 2.1259207112E-01, 5.4440439227E-01],
	[1.0470000000E+04, 4.5986050798E+00, 5.9933023379E+00, 2.3185938897E-01, 2.1288965984E-01, 5.4455470788E-01],
	[1.0475000000E+04, 4.6015140500E+00, 5.9925743394E+00, 2.3220639393E-01, 2.1318749743E-01, 5.4470500368E-01],
	[1.0480000000E+04, 4.6044234708E+00, 5.9918467766E+00, 2.3255375203E-01, 2.1348558391E-01, 5.4485527968E-01],
	[1.0485000000E+04, 4.6073333421E+00, 5.9911196492E+00, 2.3290146347E-01, 2.1378391929E-01, 5.4500553592E-01],
	[1.0490000000E+04, 4.6102436638E+00, 5.9903929566E+00, 2.3324952843E-01, 2.1408250361E-01, 5.4515577241E-01],
	[1.0495000000E+04, 4.6131544356E+00, 5.9896666984E+00, 2.3359794711E-01, 2.1438133687E-01, 5.4530598919E-01],
	[1.0500000000E+04, 4.6160656575E+00, 5.9889408740E+00, 2.3394671969E-01, 2.1468041910E-01, 5.4545618628E-01],
	[1.0505000000E+04, 4.6189773293E+00, 5.9882154831E+00, 2.3429584638E-01, 2.1497975032E-01, 5.4560636370E-01],
	[1.0510000000E+04, 4.6218894508E+00, 5.9874905252E+00, 2.3464532735E-01, 2.1527933055E-01, 5.4575652149E-01],
	[1.0515000000E+04, 4.6248020220E+00, 5.9867659998E+00, 2.3499516280E-01, 2.1557915981E-01, 5.4590665966E-01],
	[1.0520000000E+04, 4.6277150426E+00, 5.9860419065E+00, 2.3534535292E-01, 2.1587923811E-01, 5.4605677824E-01],
	[1.0525000000E+04, 4.6306285126E+00, 5.9853182447E+00, 2.3569589789E-01, 2.1617956548E-01, 5.4620687726E-01],
	[1.0530000000E+04, 4.6335424317E+00, 5.9845950141E+00, 2.3604679792E-01, 2.1648014194E-01, 5.4635695675E-01],
	[1.0535000000E+04, 4.6364567999E+00, 5.9838722141E+00, 2.3639805319E-01, 2.1678096750E-01, 5.4650701672E-01],
	[1.0540000000E+04, 4.6393716170E+00, 5.9831498443E+00, 2.3674966388E-01, 2.1708204219E-01, 5.4665705722E-01],
	[1.0545000000E+04, 4.6422868828E+00, 5.9824279042E+00, 2.3710163020E-01, 2.1738336602E-01, 5.4680707825E-01],
	[1.0550000000E+04, 4.6452025973E+00, 5.9817063935E+00, 2.3745395232E-01, 2.1768493901E-01, 5.4695707985E-01],
	[1.0555000000E+04, 4.6481187602E+00, 5.9809853115E+00, 2.3780663045E-01, 2.1798676118E-01, 5.4710706205E-01],
	[1.0560000000E+04, 4.6510353714E+00, 5.9802646580E+00, 2.3815966477E-01, 2.1828883254E-01, 5.4725702486E-01],
	[1.0565000000E+04, 4.6539524308E+00, 5.9795444323E+00, 2.3851305548E-01, 2.1859115312E-01, 5.4740696832E-01],
	[1.0570000000E+04, 4.6568699383E+00, 5.9788246341E+00, 2.3886680275E-01, 2.1889372294E-01, 5.4755689245E-01],
	[1.0575000000E+04, 4.6597878936E+00, 5.9781052629E+00, 2.3922090679E-01, 2.1919654200E-01, 5.4770679727E-01],
	[1.0580000000E+04, 4.6627062967E+00, 5.9773863182E+00, 2.3957536778E-01, 2.1949961033E-01, 5.4785668282E-01],
	[1.0585000000E+04, 4.6656251474E+00, 5.9766677996E+00, 2.3993018592E-01, 2.1980292795E-01, 5.4800654912E-01],
	[1.0590000000E+04, 4.6685444455E+00, 5.9759497067E+00, 2.4028536139E-01, 2.2010649487E-01, 5.4815639620E-01],
	[1.0595000000E+04, 4.6714666804E+00, 5.9752408362E+00, 2.4064089439E-01, 2.2041032862E-01, 5.4830622407E-01],
	[1.0600000000E+04, 4.6743902902E+00, 5.9745356535E+00, 2.4099678510E-01, 2.2071441831E-01, 5.4845603278E-01],
	[1.0605000000E+04, 4.6773143497E+00, 5.9738308866E+00, 2.4135303372E-01, 2.2101875748E-01, 5.4860582233E-01],
	[1.0610000000E+04, 4.6802388587E+00, 5.9731265349E+00, 2.4170964044E-01, 2.2132334613E-01, 5.4875559277E-01],
	[1.0615000000E+04, 4.6831638172E+00, 5.9724225980E+00, 2.4206660545E-01, 2.2162818428E-01, 5.4890534411E-01],
	[1.0620000000E+04, 4.6860892249E+00, 5.9717190755E+00, 2.4242392893E-01, 2.2193327195E-01, 5.4905507638E-01],
	[1.0625000000E+04, 4.6890150818E+00, 5.9710159670E+00, 2.4278161108E-01, 2.2223860915E-01, 5.4920478961E-01],
	[1.0630000000E+04, 4.6919413876E+00, 5.9703132721E+00, 2.4313965209E-01, 2.2254419590E-01, 5.4935448383E-01],
	[1.0635000000E+04, 4.6948681422E+00, 5.9696109902E+00, 2.4349805216E-01, 2.2285003222E-01, 5.4950415905E-01],
	[1.0640000000E+04, 4.6977953456E+00, 5.9689091209E+00, 2.4385681146E-01, 2.2315611812E-01, 5.4965381531E-01],
	[1.0645000000E+04, 4.7007229975E+00, 5.9682076639E+00, 2.4421593019E-01, 2.2346245362E-01, 5.4980345263E-01],
	[1.0650000000E+04, 4.7036510978E+00, 5.9675066186E+00, 2.4457540855E-01, 2.2376903873E-01, 5.4995307097E-01],
	[1.0655000000E+04, 4.7065796464E+00, 5.9668059847E+00, 2.4493524672E-01, 2.2407587347E-01, 5.5010267032E-01],
	[1.0660000000E+04, 4.7095086431E+00, 5.9661057617E+00, 2.4529544489E-01, 2.2438295785E-01, 5.5025225068E-01],
	[1.0665000000E+04, 4.7124380878E+00, 5.9654059492E+00, 2.4565600326E-01, 2.2469029188E-01, 5.5040181207E-01],
	[1.0670000000E+04, 4.7153679804E+00, 5.9647065467E+00, 2.4601692201E-01, 2.2499787559E-01, 5.5055135448E-01],
	[1.0675000000E+04, 4.7182983207E+00, 5.9640075538E+00, 2.4637820134E-01, 2.2530570899E-01, 5.5070087792E-01],
	[1.0680000000E+04, 4.7212291085E+00, 5.9633089701E+00, 2.4673984144E-01, 2.2561379209E-01, 5.5085038241E-01],
	[1.0685000000E+04, 4.7241603437E+00, 5.9626107951E+00, 2.4710184249E-01, 2.2592212490E-01, 5.5099986793E-01],
	[1.0690000000E+04, 4.7270920262E+00, 5.9619130285E+00, 2.4746420469E-01, 2.2623070744E-01, 5.5114933451E-01],
	[1.0695000000E+04, 4.7300241559E+00, 5.9612156697E+00, 2.4782692823E-01, 2.2653953972E-01, 5.5129878215E-01],
	[1.0700000000E+04, 4.7329567325E+00, 5.9605187184E+00, 2.4819001330E-01, 2.2684862176E-01, 5.5144821084E-01],
	[1.0705000000E+04, 4.7358897560E+00, 5.9598221741E+00, 2.4855346009E-01, 2.2715795357E-01, 5.5159762060E-01],
	[1.0710000000E+04, 4.7388232263E+00, 5.9591260365E+00, 2.4891726879E-01, 2.2746753516E-01, 5.5174701144E-01],
	[1.0715000000E+04, 4.7417571431E+00, 5.9584303050E+00, 2.4928143959E-01, 2.2777736655E-01, 5.5189638336E-01],
	[1.0720000000E+04, 4.7446915063E+00, 5.9577349792E+00, 2.4964597269E-01, 2.2808744775E-01, 5.5204573636E-01],
	[1.0725000000E+04, 4.7476263158E+00, 5.9570400588E+00, 2.5001086827E-01, 2.2839777877E-01, 5.5219507046E-01],
	[1.0730000000E+04, 4.7505615715E+00, 5.9563455432E+00, 2.5037612652E-01, 2.2870835962E-01, 5.5234438565E-01],
	[1.0735000000E+04, 4.7534972732E+00, 5.9556514322E+00, 2.5074174764E-01, 2.2901919033E-01, 5.5249368194E-01],
	[1.0740000000E+04, 4.7564334208E+00, 5.9549577252E+00, 2.5110773181E-01, 2.2933027089E-01, 5.5264295935E-01],
	[1.0745000000E+04, 4.7593700141E+00, 5.9542644218E+00, 2.5147407923E-01, 2.2964160132E-01, 5.5279221787E-01],
	[1.0750000000E+04, 4.7623070530E+00, 5.9535715216E+00, 2.5184079009E-01, 2.2995318163E-01, 5.5294145752E-01],
	[1.0755000000E+04, 4.7652445373E+00, 5.9528790242E+00, 2.5220786458E-01, 2.3026501184E-01, 5.5309067829E-01],
	[1.0760000000E+04, 4.7681824670E+00, 5.9521869291E+00, 2.5257530289E-01, 2.3057709196E-01, 5.5323988020E-01],
	[1.0765000000E+04, 4.7711230669E+00, 5.9515025434E+00, 2.5294310521E-01, 2.3088943820E-01, 5.5338906325E-01],
	[1.0770000000E+04, 4.7740654337E+00, 5.9508228865E+00, 2.5331127173E-01, 2.3120204409E-01, 5.5353822745E-01],
	[1.0775000000E+04, 4.7770082481E+00, 5.9501436226E+00, 2.5367980264E-01, 2.3151490003E-01, 5.5368737281E-01],
	[1.0780000000E+04, 4.7799515100E+00, 5.9494647513E+00, 2.5404869814E-01, 2.3182800605E-01, 5.5383649932E-01],
	[1.0785000000E+04, 4.7828952193E+00, 5.9487862722E+00, 2.5441795841E-01, 2.3214136215E-01, 5.5398560700E-01],
	[1.0790000000E+04, 4.7858393757E+00, 5.9481081849E+00, 2.5478758365E-01, 2.3245496835E-01, 5.5413469585E-01],
	[1.0795000000E+04, 4.7887839792E+00, 5.9474304890E+00, 2.5515757404E-01, 2.3276882466E-01, 5.5428376589E-01],
	[1.0800000000E+04, 4.7917290296E+00, 5.9467531841E+00, 2.5552792979E-01, 2.3308293108E-01, 5.5443281711E-01],
	[1.0805000000E+04, 4.7946745268E+00, 5.9460762698E+00, 2.5589865107E-01, 2.3339728763E-01, 5.5458184952E-01],
	[1.0810000000E+04, 4.7976204706E+00, 5.9453997456E+00, 2.5626973808E-01, 2.3371189431E-01, 5.5473086313E-01],
	[1.0815000000E+04, 4.8005668610E+00, 5.9447236112E+00, 2.5664119101E-01, 2.3402675114E-01, 5.5487985795E-01],
	[1.0820000000E+04, 4.8035136977E+00, 5.9440478661E+00, 2.5701301005E-01, 2.3434185813E-01, 5.5502883398E-01],
	[1.0825000000E+04, 4.8064609807E+00, 5.9433725100E+00, 2.5738519539E-01, 2.3465721528E-01, 5.5517779123E-01],
	[1.0830000000E+04, 4.8094087097E+00, 5.9426975424E+00, 2.5775774723E-01, 2.3497282261E-01, 5.5532672970E-01],
	[1.0835000000E+04, 4.8123568847E+00, 5.9420229630E+00, 2.5813066575E-01, 2.3528868013E-01, 5.5547564941E-01],
	[1.0840000000E+04, 4.8153055055E+00, 5.9413487714E+00, 2.5850395115E-01, 2.3560478784E-01, 5.5562455036E-01],
	[1.0845000000E+04, 4.8182545719E+00, 5.9406749671E+00, 2.5887760362E-01, 2.3592114575E-01, 5.5577343255E-01],
	[1.0850000000E+04, 4.8212040839E+00, 5.9400015497E+00, 2.5925162334E-01, 2.3623775387E-01, 5.5592229599E-01],
	[1.0855000000E+04, 4.8241540413E+00, 5.9393285189E+00, 2.5962601052E-01, 2.3655461222E-01, 5.5607114070E-01],
	[1.0860000000E+04, 4.8271044440E+00, 5.9386558742E+00, 2.6000076533E-01, 2.3687172079E-01, 5.5621996667E-01],
	[1.0865000000E+04, 4.8300552918E+00, 5.9379836152E+00, 2.6037588797E-01, 2.3718907961E-01, 5.5636877392E-01],
	[1.0870000000E+04, 4.8330065845E+00, 5.9373117416E+00, 2.6075137864E-01, 2.3750668866E-01, 5.5651756245E-01],
	[1.0875000000E+04, 4.8359583222E+00, 5.9366402530E+00, 2.6112723753E-01, 2.3782454797E-01, 5.5666633226E-01],
	[1.0880000000E+04, 4.8389105045E+00, 5.9359691489E+00, 2.6150346481E-01, 2.3814265755E-01, 5.5681508337E-01],
	[1.0885000000E+04, 4.8418631314E+00, 5.9352984289E+00, 2.6188006070E-01, 2.3846101739E-01, 5.5696381578E-01],
	[1.0890000000E+04, 4.8448162027E+00, 5.9346280927E+00, 2.6225702537E-01, 2.3877962750E-01, 5.5711252949E-01],
	[1.0895000000E+04, 4.8477697183E+00, 5.9339581399E+00, 2.6263435902E-01, 2.3909848790E-01, 5.5726122453E-01],
	[1.0900000000E+04, 4.8507236781E+00, 5.9332885701E+00, 2.6301206184E-01, 2.3941759859E-01, 5.5740990088E-01],
	[1.0905000000E+04, 4.8536780819E+00, 5.9326193828E+00, 2.6339013402E-01, 2.3973695958E-01, 5.5755855857E-01],
	[1.0910000000E+04, 4.8566329296E+00, 5.9319505777E+00, 2.6376857575E-01, 2.4005657087E-01, 5.5770719759E-01],
	[1.0915000000E+04, 4.8595882211E+00, 5.9312821543E+00, 2.6414738723E-01, 2.4037643247E-01, 5.5785581795E-01],
	[1.0920000000E+04, 4.8625439561E+00, 5.9306141124E+00, 2.6452656864E-01, 2.4069654439E-01, 5.5800441967E-01],
	[1.0925000000E+04, 4.8655001347E+00, 5.9299464515E+00, 2.6490612018E-01, 2.4101690663E-01, 5.5815300275E-01],
	[1.0930000000E+04, 4.8684567565E+00, 5.9292791711E+00, 2.6528604203E-01, 2.4133751921E-01, 5.5830156719E-01],
	[1.0935000000E+04, 4.8714138216E+00, 5.9286122710E+00, 2.6566633440E-01, 2.4165838211E-01, 5.5845011300E-01],
	[1.0940000000E+04, 4.8743749233E+00, 5.9279567235E+00, 2.6604699746E-01, 2.4197952250E-01, 5.5859864019E-01],
	[1.0945000000E+04, 4.8773365537E+00, 5.9273018010E+00, 2.6642803141E-01, 2.4230091399E-01, 5.5874714877E-01],
	[1.0950000000E+04, 4.8802986296E+00, 5.9266472499E+00, 2.6680943645E-01, 2.4262255595E-01, 5.5889563875E-01],
	[1.0955000000E+04, 4.8832611509E+00, 5.9259930699E+00, 2.6719121277E-01, 2.4294444840E-01, 5.5904411013E-01],
	[1.0960000000E+04, 4.8862241176E+00, 5.9253392605E+00, 2.6757336054E-01, 2.4326659135E-01, 5.5919256292E-01],
	[1.0965000000E+04, 4.8891875294E+00, 5.9246858214E+00, 2.6795587998E-01, 2.4358898478E-01, 5.5934099712E-01],
	[1.0970000000E+04, 4.8921513863E+00, 5.9240327523E+00, 2.6833877126E-01, 2.4391162872E-01, 5.5948941275E-01],
	[1.0975000000E+04, 4.8951156880E+00, 5.9233800526E+00, 2.6872203458E-01, 2.4423452317E-01, 5.5963780981E-01],
	[1.0980000000E+04, 4.8980804345E+00, 5.9227277221E+00, 2.6910567014E-01, 2.4455766812E-01, 5.5978618831E-01],
	[1.0985000000E+04, 4.9010456257E+00, 5.9220757604E+00, 2.6948967811E-01, 2.4488106359E-01, 5.5993454826E-01],
	[1.0990000000E+04, 4.9040112613E+00, 5.9214241671E+00, 2.6987405870E-01, 2.4520470958E-01, 5.6008288966E-01],
	[1.0995000000E+04, 4.9069773413E+00, 5.9207729418E+00, 2.7025881209E-01, 2.4552860610E-01, 5.6023121253E-01],
	[1.1000000000E+04, 4.9099438655E+00, 5.9201220842E+00, 2.7064393849E-01, 2.4585275314E-01, 5.6037951686E-01],
	[1.1005000000E+04, 4.9129108337E+00, 5.9194715938E+00, 2.7102943807E-01, 2.4617715071E-01, 5.6052780267E-01],
	[1.1010000000E+04, 4.9158782460E+00, 5.9188214704E+00, 2.7141531102E-01, 2.4650179881E-01, 5.6067606997E-01],
	[1.1015000000E+04, 4.9188461020E+00, 5.9181717135E+00, 2.7180155755E-01, 2.4682669746E-01, 5.6082431876E-01],
	[1.1020000000E+04, 4.9218144017E+00, 5.9175223227E+00, 2.7218817785E-01, 2.4715184664E-01, 5.6097254905E-01],
	[1.1025000000E+04, 4.9247831450E+00, 5.9168732977E+00, 2.7257517209E-01, 2.4747724637E-01, 5.6112076085E-01],
	[1.1030000000E+04, 4.9277523317E+00, 5.9162246381E+00, 2.7296254048E-01, 2.4780289665E-01, 5.6126895417E-01],
	[1.1035000000E+04, 4.9307219616E+00, 5.9155763436E+00, 2.7335028321E-01, 2.4812879747E-01, 5.6141712901E-01],
	[1.1040000000E+04, 4.9336920347E+00, 5.9149284137E+00, 2.7373840047E-01, 2.4845494885E-01, 5.6156528538E-01],
	[1.1045000000E+04, 4.9366625507E+00, 5.9142808482E+00, 2.7412689245E-01, 2.4878135079E-01, 5.6171342330E-01],
	[1.1050000000E+04, 4.9396335097E+00, 5.9136336465E+00, 2.7451575934E-01, 2.4910800328E-01, 5.6186154276E-01],
	[1.1055000000E+04, 4.9426049114E+00, 5.9129868085E+00, 2.7490500133E-01, 2.4943490633E-01, 5.6200964377E-01],
	[1.1060000000E+04, 4.9455767557E+00, 5.9123403336E+00, 2.7529461862E-01, 2.4976205994E-01, 5.6215772635E-01],
	[1.1065000000E+04, 4.9485490424E+00, 5.9116942215E+00, 2.7568461139E-01, 2.5008946411E-01, 5.6230579050E-01],
	[1.1070000000E+04, 4.9515217715E+00, 5.9110484719E+00, 2.7607497984E-01, 2.5041711885E-01, 5.6245383624E-01],
	[1.1075000000E+04, 4.9544949427E+00, 5.9104030844E+00, 2.7646572416E-01, 2.5074502416E-01, 5.6260186355E-01],
	[1.1080000000E+04, 4.9574685561E+00, 5.9097580586E+00, 2.7685684454E-01, 2.5107318003E-01, 5.6274987247E-01],
	[1.1085000000E+04, 4.9604426114E+00, 5.9091133942E+00, 2.7724834118E-01, 2.5140158647E-01, 5.6289786299E-01],
	[1.1090000000E+04, 4.9634171084E+00, 5.9084690907E+00, 2.7764021426E-01, 2.5173024347E-01, 5.6304583512E-01],
	[1.1095000000E+04, 4.9663920471E+00, 5.9078251479E+00, 2.7803246397E-01, 2.5205915105E-01, 5.6319378887E-01],
	[1.1100000000E+04, 4.9693674274E+00, 5.9071815654E+00, 2.7842509052E-01, 2.5238830920E-01, 5.6334172425E-01],
	[1.1105000000E+04, 4.9723432490E+00, 5.9065383427E+00, 2.7881809408E-01, 2.5271771792E-01, 5.6348964126E-01],
	[1.1110000000E+04, 4.9753195120E+00, 5.9058954796E+00, 2.7921147485E-01, 2.5304737720E-01, 5.6363753992E-01],
	[1.1115000000E+04, 4.9782991465E+00, 5.9052613042E+00, 2.7960523303E-01, 2.5337730998E-01, 5.6378542024E-01],
	[1.1120000000E+04, 4.9812801029E+00, 5.9046299779E+00, 2.7999936880E-01, 2.5370750033E-01, 5.6393328221E-01],
	[1.1125000000E+04, 4.9842615031E+00, 5.9039990028E+00, 2.8039388236E-01, 2.5403794137E-01, 5.6408112586E-01],
	[1.1130000000E+04, 4.9872433469E+00, 5.9033683787E+00, 2.8078877389E-01, 2.5436863313E-01, 5.6422895118E-01],
	[1.1135000000E+04, 4.9902256341E+00, 5.9027381050E+00, 2.8118404359E-01, 2.5469957558E-01, 5.6437675819E-01],
	[1.1140000000E+04, 4.9932083646E+00, 5.9021081816E+00, 2.8157969166E-01, 2.5503076874E-01, 5.6452454689E-01],
	[1.1145000000E+04, 4.9961915382E+00, 5.9014786081E+00, 2.8197571828E-01, 2.5536221260E-01, 5.6467231730E-01],
	[1.1150000000E+04, 4.9991751549E+00, 5.9008493840E+00, 2.8237212364E-01, 2.5569390716E-01, 5.6482006941E-01],
	[1.1155000000E+04, 5.0021592146E+00, 5.9002205091E+00, 2.8276890794E-01, 2.5602585243E-01, 5.6496780325E-01],
	[1.1160000000E+04, 5.0051437170E+00, 5.8995919829E+00, 2.8316607137E-01, 2.5635804839E-01, 5.6511551882E-01],
	[1.1165000000E+04, 5.0081286620E+00, 5.8989638052E+00, 2.8356361412E-01, 2.5669049505E-01, 5.6526321612E-01],
	[1.1170000000E+04, 5.0111140496E+00, 5.8983359757E+00, 2.8396153638E-01, 2.5702319241E-01, 5.6541089517E-01],
	[1.1175000000E+04, 5.0140998795E+00, 5.8977084938E+00, 2.8435983834E-01, 2.5735614046E-01, 5.6555855597E-01],
	[1.1180000000E+04, 5.0170861517E+00, 5.8970813594E+00, 2.8475852020E-01, 2.5768933920E-01, 5.6570619854E-01],
	[1.1185000000E+04, 5.0200728659E+00, 5.8964545720E+00, 2.8516019472E-01, 2.5802492765E-01, 5.6585382287E-01],
	[1.1190000000E+04, 5.0230600222E+00, 5.8958281313E+00, 2.8556242265E-01, 2.5836090758E-01, 5.6600142899E-01],
	[1.1195000000E+04, 5.0260476203E+00, 5.8952020369E+00, 2.8596503763E-01, 2.5869714260E-01, 5.6614901689E-01],
	[1.1200000000E+04, 5.0290356601E+00, 5.8945762886E+00, 2.8636803986E-01, 2.5903363271E-01, 5.6629658659E-01],
	[1.1205000000E+04, 5.0320241416E+00, 5.8939508859E+00, 2.8677142954E-01, 2.5937037791E-01, 5.6644413810E-01],
	[1.1210000000E+04, 5.0350130644E+00, 5.8933258286E+00, 2.8717520687E-01, 2.5970737818E-01, 5.6659167142E-01],
	[1.1215000000E+04, 5.0380024286E+00, 5.8927011162E+00, 2.8757937205E-01, 2.6004463354E-01, 5.6673918657E-01],
	[1.1220000000E+04, 5.0409922340E+00, 5.8920767485E+00, 2.8798392527E-01, 2.6038214398E-01, 5.6688668354E-01],
	[1.1225000000E+04, 5.0439824804E+00, 5.8914527250E+00, 2.8838886674E-01, 2.6071990950E-01, 5.6703416236E-01],
	[1.1230000000E+04, 5.0469731678E+00, 5.8908290455E+00, 2.8879419666E-01, 2.6105793010E-01, 5.6718162303E-01],
	[1.1235000000E+04, 5.0499642959E+00, 5.8902057096E+00, 2.8919991522E-01, 2.6139620577E-01, 5.6732906555E-01],
	[1.1240000000E+04, 5.0529558647E+00, 5.8895827170E+00, 2.8960602263E-01, 2.6173473651E-01, 5.6747648995E-01],
	[1.1245000000E+04, 5.0559478741E+00, 5.8889600673E+00, 2.9001251907E-01, 2.6207352232E-01, 5.6762389622E-01],
	[1.1250000000E+04, 5.0589403238E+00, 5.8883377601E+00, 2.9041940476E-01, 2.6241256320E-01, 5.6777128437E-01],
	[1.1255000000E+04, 5.0619332139E+00, 5.8877157952E+00, 2.9082667989E-01, 2.6275185914E-01, 5.6791865442E-01],
	[1.1260000000E+04, 5.0649265440E+00, 5.8870941722E+00, 2.9123434466E-01, 2.6309141014E-01, 5.6806600637E-01],
	[1.1265000000E+04, 5.0679203142E+00, 5.8864728908E+00, 2.9164239926E-01, 2.6343121620E-01, 5.6821334024E-01],
	[1.1270000000E+04, 5.0709145242E+00, 5.8858519505E+00, 2.9205084391E-01, 2.6377127731E-01, 5.6836065603E-01],
	[1.1275000000E+04, 5.0739091740E+00, 5.8852313512E+00, 2.9245967879E-01, 2.6411159347E-01, 5.6850795374E-01],
	[1.1280000000E+04, 5.0769042634E+00, 5.8846110924E+00, 2.9286890411E-01, 2.6445216468E-01, 5.6865523340E-01],
	[1.1285000000E+04, 5.0798997923E+00, 5.8839911738E+00, 2.9327852006E-01, 2.6479299092E-01, 5.6880249500E-01],
	[1.1290000000E+04, 5.0828957606E+00, 5.8833715950E+00, 2.9368852685E-01, 2.6513407221E-01, 5.6894973856E-01],
	[1.1295000000E+04, 5.0858960896E+00, 5.8827627332E+00, 2.9409892468E-01, 2.6547544035E-01, 5.6909696405E-01],
	[1.1300000000E+04, 5.0888968825E+00, 5.8821542615E+00, 2.9450971373E-01, 2.6581706383E-01, 5.6924417145E-01],
	[1.1305000000E+04, 5.0918981172E+00, 5.8815461218E+00, 2.9492089422E-01, 2.6615894249E-01, 5.6939136075E-01],
	[1.1310000000E+04, 5.0948997936E+00, 5.8809383139E+00, 2.9533246634E-01, 2.6650107630E-01, 5.6953853194E-01],
	[1.1315000000E+04, 5.0979019116E+00, 5.8803308373E+00, 2.9574443029E-01, 2.6684346527E-01, 5.6968568503E-01],
	[1.1320000000E+04, 5.1009044712E+00, 5.8797236919E+00, 2.9615678627E-01, 2.6718610940E-01, 5.6983282000E-01],
	[1.1325000000E+04, 5.1039074720E+00, 5.8791168772E+00, 2.9656953448E-01, 2.6752900867E-01, 5.6997993686E-01],
	[1.1330000000E+04, 5.1069109141E+00, 5.8785103930E+00, 2.9698267512E-01, 2.6787216308E-01, 5.7012703559E-01],
	[1.1335000000E+04, 5.1099147973E+00, 5.8779042389E+00, 2.9739620839E-01, 2.6821557263E-01, 5.7027411620E-01],
	[1.1340000000E+04, 5.1129191214E+00, 5.8772984145E+00, 2.9781013449E-01, 2.6855923731E-01, 5.7042117867E-01],
	[1.1345000000E+04, 5.1159238864E+00, 5.8766929196E+00, 2.9822445361E-01, 2.6890315711E-01, 5.7056822300E-01],
	[1.1350000000E+04, 5.1189290921E+00, 5.8760877539E+00, 2.9863916596E-01, 2.6924733203E-01, 5.7071524918E-01],
	[1.1355000000E+04, 5.1219347383E+00, 5.8754829169E+00, 2.9905427173E-01, 2.6959176207E-01, 5.7086225722E-01],
	[1.1360000000E+04, 5.1249408250E+00, 5.8748784085E+00, 2.9946977113E-01, 2.6993644721E-01, 5.7100924710E-01],
	[1.1365000000E+04, 5.1279473520E+00, 5.8742742282E+00, 2.9988566435E-01, 2.7028138745E-01, 5.7115621883E-01],
	[1.1370000000E+04, 5.1309543191E+00, 5.8736703758E+00, 3.0030195160E-01, 2.7062658278E-01, 5.7130317238E-01],
	[1.1375000000E+04, 5.1339617263E+00, 5.8730668508E+00, 3.0071863307E-01, 2.7097203320E-01, 5.7145010777E-01],
	[1.1380000000E+04, 5.1369695735E+00, 5.8724636531E+00, 3.0113570896E-01, 2.7131773870E-01, 5.7159702499E-01],
	[1.1385000000E+04, 5.1399778604E+00, 5.8718607823E+00, 3.0155317948E-01, 2.7166369927E-01, 5.7174392402E-01],
	[1.1390000000E+04, 5.1429865870E+00, 5.8712582380E+00, 3.0197104482E-01, 2.7200991490E-01, 5.7189080487E-01],
	[1.1395000000E+04, 5.1459957532E+00, 5.8706560199E+00, 3.0238930517E-01, 2.7235638559E-01, 5.7203766754E-01],
	[1.1400000000E+04, 5.1490053587E+00, 5.8700541278E+00, 3.0280796075E-01, 2.7270311133E-01, 5.7218451201E-01],
	[1.1405000000E+04, 5.1520154035E+00, 5.8694525613E+00, 3.0322701175E-01, 2.7305009211E-01, 5.7233133828E-01],
	[1.1410000000E+04, 5.1550258875E+00, 5.8688513200E+00, 3.0364645837E-01, 2.7339732792E-01, 5.7247814634E-01],
	[1.1415000000E+04, 5.1580368105E+00, 5.8682504037E+00, 3.0406630081E-01, 2.7374481875E-01, 5.7262493620E-01],
	[1.1420000000E+04, 5.1610481724E+00, 5.8676498121E+00, 3.0448653926E-01, 2.7409256461E-01, 5.7277170785E-01],
	[1.1425000000E+04, 5.1640599731E+00, 5.8670495447E+00, 3.0490717394E-01, 2.7444056546E-01, 5.7291846128E-01],
	[1.1430000000E+04, 5.1670722124E+00, 5.8664496014E+00, 3.0532820503E-01, 2.7478882132E-01, 5.7306519649E-01],
	[1.1435000000E+04, 5.1700848902E+00, 5.8658499818E+00, 3.0574963274E-01, 2.7513733216E-01, 5.7321191347E-01],
	[1.1440000000E+04, 5.1730980064E+00, 5.8652506856E+00, 3.0617145726E-01, 2.7548609798E-01, 5.7335861222E-01],
	[1.1445000000E+04, 5.1761115608E+00, 5.8646517124E+00, 3.0659367881E-01, 2.7583511878E-01, 5.7350529273E-01],
	[1.1450000000E+04, 5.1791255534E+00, 5.8640530619E+00, 3.0701629757E-01, 2.7618439453E-01, 5.7365195501E-01],
	[1.1455000000E+04, 5.1821399840E+00, 5.8634547339E+00, 3.0743931374E-01, 2.7653392523E-01, 5.7379859904E-01],
	[1.1460000000E+04, 5.1851548524E+00, 5.8628567280E+00, 3.0786272753E-01, 2.7688371088E-01, 5.7394522482E-01],
	[1.1465000000E+04, 5.1881701586E+00, 5.8622590440E+00, 3.0828653913E-01, 2.7723375145E-01, 5.7409183235E-01],
	[1.1470000000E+04, 5.1911859024E+00, 5.8616616814E+00, 3.0871074875E-01, 2.7758404695E-01, 5.7423842163E-01],
	[1.1475000000E+04, 5.1942047088E+00, 5.8610711143E+00, 3.0913535659E-01, 2.7793461943E-01, 5.7438499264E-01],
	[1.1480000000E+04, 5.1972254083E+00, 5.8604844470E+00, 3.0956036284E-01, 2.7828545915E-01, 5.7453154538E-01],
	[1.1485000000E+04, 5.2002465479E+00, 5.8598980939E+00, 3.0998576770E-01, 2.7863655391E-01, 5.7467807986E-01],
	[1.1490000000E+04, 5.2032681277E+00, 5.8593120547E+00, 3.1041157137E-01, 2.7898790369E-01, 5.7482459606E-01],
	[1.1495000000E+04, 5.2062901473E+00, 5.8587263289E+00, 3.1083777406E-01, 2.7933950850E-01, 5.7497109398E-01],
	[1.1500000000E+04, 5.2093126068E+00, 5.8581409164E+00, 3.1126437597E-01, 2.7969136830E-01, 5.7511757362E-01],
	[1.1505000000E+04, 5.2123355060E+00, 5.8575558169E+00, 3.1169137728E-01, 2.8004348310E-01, 5.7526403497E-01],
	[1.1510000000E+04, 5.2153588447E+00, 5.8569710299E+00, 3.1211877821E-01, 2.8039585289E-01, 5.7541047803E-01],
	[1.1515000000E+04, 5.2183826229E+00, 5.8563865553E+00, 3.1254657895E-01, 2.8074847764E-01, 5.7555690279E-01],
	[1.1520000000E+04, 5.2214068404E+00, 5.8558023927E+00, 3.1297477970E-01, 2.8110135735E-01, 5.7570330926E-01],
	[1.1525000000E+04, 5.2244314970E+00, 5.8552185419E+00, 3.1340338066E-01, 2.8145449201E-01, 5.7584969742E-01],
	[1.1530000000E+04, 5.2274565928E+00, 5.8546350024E+00, 3.1383238204E-01, 2.8180788160E-01, 5.7599606728E-01],
	[1.1535000000E+04, 5.2304821274E+00, 5.8540517741E+00, 3.1426178402E-01, 2.8216152612E-01, 5.7614241883E-01],
	[1.1540000000E+04, 5.2335081008E+00, 5.8534688565E+00, 3.1469158682E-01, 2.8251542555E-01, 5.7628875206E-01],
	[1.1545000000E+04, 5.2365345129E+00, 5.8528862495E+00, 3.1512179063E-01, 2.8286957987E-01, 5.7643506697E-01],
	[1.1550000000E+04, 5.2395613636E+00, 5.8523039527E+00, 3.1555239565E-01, 2.8322398908E-01, 5.7658136356E-01],
	[1.1555000000E+04, 5.2425886527E+00, 5.8517219658E+00, 3.1598340209E-01, 2.8357865316E-01, 5.7672764182E-01],
	[1.1560000000E+04, 5.2456163800E+00, 5.8511402886E+00, 3.1641481013E-01, 2.8393357209E-01, 5.7687390175E-01],
	[1.1565000000E+04, 5.2486445455E+00, 5.8505589206E+00, 3.1684661998E-01, 2.8428874587E-01, 5.7702014335E-01],
	[1.1570000000E+04, 5.2516731491E+00, 5.8499778617E+00, 3.1727883185E-01, 2.8464417449E-01, 5.7716636661E-01],
	[1.1575000000E+04, 5.2547021906E+00, 5.8493971115E+00, 3.1771144592E-01, 2.8499985792E-01, 5.7731257153E-01],
	[1.1580000000E+04, 5.2577316699E+00, 5.8488166697E+00, 3.1814446241E-01, 2.8535579615E-01, 5.7745875810E-01],
	[1.1585000000E+04, 5.2607615868E+00, 5.8482365361E+00, 3.1857788150E-01, 2.8571198918E-01, 5.7760492633E-01],
	[1.1590000000E+04, 5.2637919413E+00, 5.8476567103E+00, 3.1901170341E-01, 2.8606843697E-01, 5.7775107620E-01],
	[1.1595000000E+04, 5.2668227332E+00, 5.8470771920E+00, 3.1944592833E-01, 2.8642513953E-01, 5.7789720772E-01],
	[1.1600000000E+04, 5.2698539624E+00, 5.8464979810E+00, 3.1988055646E-01, 2.8678209684E-01, 5.7804332088E-01],
	[1.1605000000E+04, 5.2728856287E+00, 5.8459190769E+00, 3.2031558799E-01, 2.8713930888E-01, 5.7818941567E-01],
	[1.1610000000E+04, 5.2759177321E+00, 5.8453404795E+00, 3.2075102314E-01, 2.8749677563E-01, 5.7833549210E-01],
	[1.1615000000E+04, 5.2789502724E+00, 5.8447621884E+00, 3.2118686210E-01, 2.8785449708E-01, 5.7848155016E-01],
	[1.1620000000E+04, 5.2819832495E+00, 5.8441842034E+00, 3.2162310507E-01, 2.8821247322E-01, 5.7862758984E-01],
	[1.1625000000E+04, 5.2850166632E+00, 5.8436065241E+00, 3.2205975225E-01, 2.8857070403E-01, 5.7877361115E-01],
	[1.1630000000E+04, 5.2880505135E+00, 5.8430291503E+00, 3.2249680385E-01, 2.8892918949E-01, 5.7891961407E-01],
	[1.1635000000E+04, 5.2910848001E+00, 5.8424520817E+00, 3.2293426005E-01, 2.8928792959E-01, 5.7906559862E-01],
	[1.1640000000E+04, 5.2941195231E+00, 5.8418753180E+00, 3.2337212106E-01, 2.8964692432E-01, 5.7921156477E-01],
	[1.1645000000E+04, 5.2971546822E+00, 5.8412988589E+00, 3.2381038709E-01, 2.9000617365E-01, 5.7935751254E-01],
	[1.1650000000E+04, 5.3001902774E+00, 5.8407227041E+00, 3.2424905832E-01, 2.9036567757E-01, 5.7950344191E-01],
	[1.1655000000E+04, 5.3032263085E+00, 5.8401468534E+00, 3.2468813497E-01, 2.9072543606E-01, 5.7964935289E-01],
	[1.1660000000E+04, 5.3062657584E+00, 5.8395781649E+00, 3.2512761723E-01, 2.9108547513E-01, 5.7979524547E-01],
	[1.1665000000E+04, 5.3093068790E+00, 5.8390126082E+00, 3.2556750530E-01, 2.9144577962E-01, 5.7994111964E-01],
	[1.1670000000E+04, 5.3123484381E+00, 5.8384473486E+00, 3.2600779938E-01, 2.9180633878E-01, 5.8008697541E-01],
	[1.1675000000E+04, 5.3153904357E+00, 5.8378823859E+00, 3.2644849968E-01, 2.9216715261E-01, 5.8023281276E-01],
	[1.1680000000E+04, 5.3184328715E+00, 5.8373177196E+00, 3.2688960639E-01, 2.9252822109E-01, 5.8037863171E-01],
	[1.1685000000E+04, 5.3214757456E+00, 5.8367533496E+00, 3.2733111971E-01, 2.9288954419E-01, 5.8052443224E-01],
	[1.1690000000E+04, 5.3245190577E+00, 5.8361892756E+00, 3.2777303984E-01, 2.9325112190E-01, 5.8067021435E-01],
	[1.1695000000E+04, 5.3275628078E+00, 5.8356254973E+00, 3.2821536698E-01, 2.9361295420E-01, 5.8081597804E-01],
	[1.1700000000E+04, 5.3306069956E+00, 5.8350620144E+00, 3.2865810134E-01, 2.9397504108E-01, 5.8096172331E-01],
	[1.1705000000E+04, 5.3336516212E+00, 5.8344988266E+00, 3.2910124311E-01, 2.9433738251E-01, 5.8110745015E-01],
	[1.1710000000E+04, 5.3366966843E+00, 5.8339359337E+00, 3.2954479250E-01, 2.9469997849E-01, 5.8125315855E-01],
	[1.1715000000E+04, 5.3397421849E+00, 5.8333733353E+00, 3.2998874970E-01, 2.9506282898E-01, 5.8139884853E-01],
	[1.1720000000E+04, 5.3427881227E+00, 5.8328110312E+00, 3.3043311491E-01, 2.9542593397E-01, 5.8154452007E-01],
	[1.1725000000E+04, 5.3458344978E+00, 5.8322490212E+00, 3.3087788834E-01, 2.9578929344E-01, 5.8169017317E-01],
	[1.1730000000E+04, 5.3488813099E+00, 5.8316873048E+00, 3.3132307018E-01, 2.9615290738E-01, 5.8183580783E-01],
	[1.1735000000E+04, 5.3519285590E+00, 5.8311258819E+00, 3.3176866064E-01, 2.9651677576E-01, 5.8198142404E-01],
	[1.1740000000E+04, 5.3549762449E+00, 5.8305647522E+00, 3.3221465991E-01, 2.9688089857E-01, 5.8212702181E-01],
	[1.1745000000E+04, 5.3580243675E+00, 5.8300039154E+00, 3.3266106820E-01, 2.9724527578E-01, 5.8227260112E-01],
	[1.1750000000E+04, 5.3610729267E+00, 5.8294433712E+00, 3.3310788571E-01, 2.9760990738E-01, 5.8241816199E-01],
	[1.1755000000E+04, 5.3641219223E+00, 5.8288831193E+00, 3.3355511263E-01, 2.9797479334E-01, 5.8256370440E-01],
	[1.1760000000E+04, 5.3671713542E+00, 5.8283231595E+00, 3.3400274917E-01, 2.9833993365E-01, 5.8270922835E-01],
	[1.1765000000E+04, 5.3702212224E+00, 5.8277634914E+00, 3.3445079552E-01, 2.9870532828E-01, 5.8285473384E-01],
	[1.1770000000E+04, 5.3732715266E+00, 5.8272041149E+00, 3.3489925190E-01, 2.9907097722E-01, 5.8300022087E-01],
	[1.1775000000E+04, 5.3763222668E+00, 5.8266450297E+00, 3.3534811849E-01, 2.9943688045E-01, 5.8314568943E-01],
	[1.1780000000E+04, 5.3793734428E+00, 5.8260862353E+00, 3.3579739550E-01, 2.9980303794E-01, 5.8329113952E-01],
	[1.1785000000E+04, 5.3824250546E+00, 5.8255277317E+00, 3.3624708314E-01, 3.0016944967E-01, 5.8343657115E-01],
	[1.1790000000E+04, 5.3854771019E+00, 5.8249695185E+00, 3.3669718159E-01, 3.0053611562E-01, 5.8358198430E-01],
	[1.1795000000E+04, 5.3885295847E+00, 5.8244115954E+00, 3.3714769106E-01, 3.0090303577E-01, 5.8372737897E-01],
	[1.1800000000E+04, 5.3915825029E+00, 5.8238539622E+00, 3.3759861175E-01, 3.0127021010E-01, 5.8387275517E-01],
	[1.1805000000E+04, 5.3946358562E+00, 5.8232966185E+00, 3.3804994386E-01, 3.0163763859E-01, 5.8401811288E-01],
	[1.1810000000E+04, 5.3976896447E+00, 5.8227395642E+00, 3.3850168760E-01, 3.0200532122E-01, 5.8416345212E-01],
	[1.1815000000E+04, 5.4007438681E+00, 5.8221827990E+00, 3.3895384316E-01, 3.0237325796E-01, 5.8430877287E-01],
	[1.1820000000E+04, 5.4037985264E+00, 5.8216263225E+00, 3.3940641074E-01, 3.0274144879E-01, 5.8445407513E-01],
	[1.1825000000E+04, 5.4068536195E+00, 5.8210701344E+00, 3.3985939054E-01, 3.0310989369E-01, 5.8459935890E-01],
	[1.1830000000E+04, 5.4099091471E+00, 5.8205142347E+00, 3.4031278277E-01, 3.0347859263E-01, 5.8474462418E-01],
	[1.1835000000E+04, 5.4129651092E+00, 5.8199586229E+00, 3.4076658762E-01, 3.0384754560E-01, 5.8488987096E-01],
	[1.1840000000E+04, 5.4160215058E+00, 5.8194032987E+00, 3.4122080530E-01, 3.0421675257E-01, 5.8503509925E-01],
	[1.1845000000E+04, 5.4190791071E+00, 5.8188499151E+00, 3.4167543600E-01, 3.0458622048E-01, 5.8518030904E-01],
	[1.1850000000E+04, 5.4221407269E+00, 5.8183045005E+00, 3.4213047993E-01, 3.0495597482E-01, 5.8532550034E-01],
	[1.1855000000E+04, 5.4252027838E+00, 5.8177593671E+00, 3.4258593728E-01, 3.0532598326E-01, 5.8547067312E-01],
	[1.1860000000E+04, 5.4282652776E+00, 5.8172145146E+00, 3.4304180827E-01, 3.0569624576E-01, 5.8561582741E-01],
	[1.1865000000E+04, 5.4313282083E+00, 5.8166699427E+00, 3.4349809308E-01, 3.0606676231E-01, 5.8576096318E-01],
	[1.1870000000E+04, 5.4343915757E+00, 5.8161256513E+00, 3.4395479192E-01, 3.0643753289E-01, 5.8590608045E-01],
	[1.1875000000E+04, 5.4374553797E+00, 5.8155816399E+00, 3.4441190499E-01, 3.0680855747E-01, 5.8605117921E-01],
	[1.1880000000E+04, 5.4405196202E+00, 5.8150379084E+00, 3.4486943249E-01, 3.0717983603E-01, 5.8619625945E-01],
	[1.1885000000E+04, 5.4435842970E+00, 5.8144944566E+00, 3.4532737463E-01, 3.0755136854E-01, 5.8634132118E-01],
	[1.1890000000E+04, 5.4466494100E+00, 5.8139512840E+00, 3.4578573159E-01, 3.0792315498E-01, 5.8648636439E-01],
	[1.1895000000E+04, 5.4497149592E+00, 5.8134083905E+00, 3.4624450359E-01, 3.0829519532E-01, 5.8663138909E-01],
	[1.1900000000E+04, 5.4527809443E+00, 5.8128657759E+00, 3.4670369082E-01, 3.0866748954E-01, 5.8677639526E-01],
	[1.1905000000E+04, 5.4558473653E+00, 5.8123234398E+00, 3.4716329348E-01, 3.0904003762E-01, 5.8692138289E-01],
	[1.1910000000E+04, 5.4589142220E+00, 5.8117813820E+00, 3.4762331178E-01, 3.0941283952E-01, 5.8706635195E-01],
	[1.1915000000E+04, 5.4619815144E+00, 5.8112396022E+00, 3.4808374591E-01, 3.0978589524E-01, 5.8721130243E-01],
	[1.1920000000E+04, 5.4650492422E+00, 5.8106981003E+00, 3.4854459608E-01, 3.1015920473E-01, 5.8735623432E-01],
	[1.1925000000E+04, 5.4681174055E+00, 5.8101568758E+00, 3.4900586249E-01, 3.1053276797E-01, 5.8750114761E-01],
	[1.1930000000E+04, 5.4711860040E+00, 5.8096159286E+00, 3.4946754534E-01, 3.1090658494E-01, 5.8764604228E-01],
	[1.1935000000E+04, 5.4742550376E+00, 5.8090752584E+00, 3.4992964482E-01, 3.1128065561E-01, 5.8779091832E-01],
	[1.1940000000E+04, 5.4773245063E+00, 5.8085348649E+00, 3.5039216114E-01, 3.1165497996E-01, 5.8793577572E-01],
	[1.1945000000E+04, 5.4803944098E+00, 5.8079947480E+00, 3.5085509451E-01, 3.1202955796E-01, 5.8808061447E-01],
	[1.1950000000E+04, 5.4834647482E+00, 5.8074549072E+00, 3.5131844511E-01, 3.1240438958E-01, 5.8822543456E-01],
	[1.1955000000E+04, 5.4865355212E+00, 5.8069153425E+00, 3.5178221316E-01, 3.1277947480E-01, 5.8837023596E-01],
	[1.1960000000E+04, 5.4896067287E+00, 5.8063760534E+00, 3.5224639885E-01, 3.1315481359E-01, 5.8851501869E-01],
	[1.1965000000E+04, 5.4926783706E+00, 5.8058370398E+00, 3.5271100239E-01, 3.1353040592E-01, 5.8865978271E-01],
	[1.1970000000E+04, 5.4957504469E+00, 5.8052983014E+00, 3.5317602397E-01, 3.1390625176E-01, 5.8880452801E-01],
	[1.1975000000E+04, 5.4988229573E+00, 5.8047598380E+00, 3.5364146380E-01, 3.1428235110E-01, 5.8894925460E-01],
	[1.1980000000E+04, 5.5018959017E+00, 5.8042216493E+00, 3.5410732207E-01, 3.1465870389E-01, 5.8909396245E-01],
	[1.1985000000E+04, 5.5049692801E+00, 5.8036837350E+00, 3.5457359899E-01, 3.1503531012E-01, 5.8923865155E-01],
	[1.1990000000E+04, 5.5080430924E+00, 5.8031460949E+00, 3.5504029476E-01, 3.1541216975E-01, 5.8938332189E-01],
	[1.1995000000E+04, 5.5111173383E+00, 5.8026087287E+00, 3.5550740958E-01, 3.1578928276E-01, 5.8952797347E-01],
	[1.2000000000E+04, 5.5141920178E+00, 5.8020716362E+00, 3.5597494365E-01, 3.1616664912E-01, 5.8967260626E-01],
	[1.2005000000E+04, 5.5172671307E+00, 5.8015348171E+00, 3.5644289717E-01, 3.1654426880E-01, 5.8981722025E-01],
	[1.2010000000E+04, 5.5203426770E+00, 5.8009982712E+00, 3.5691127034E-01, 3.1692214176E-01, 5.8996181545E-01],
	[1.2015000000E+04, 5.5234186565E+00, 5.8004619982E+00, 3.5738006337E-01, 3.1730026800E-01, 5.9010639182E-01],
	[1.2020000000E+04, 5.5264950691E+00, 5.7999259979E+00, 3.5784927646E-01, 3.1767864746E-01, 5.9025094936E-01],
	[1.2025000000E+04, 5.5295719147E+00, 5.7993902700E+00, 3.5831890979E-01, 3.1805728013E-01, 5.9039548807E-01],
	[1.2030000000E+04, 5.5326491931E+00, 5.7988548142E+00, 3.5878896359E-01, 3.1843616598E-01, 5.9054000792E-01],
	[1.2035000000E+04, 5.5357270939E+00, 5.7983200099E+00, 3.5925943804E-01, 3.1881530674E-01, 5.9068450891E-01],
	[1.2040000000E+04, 5.5388097322E+00, 5.7977940889E+00, 3.5973033336E-01, 3.1919474104E-01, 5.9082899103E-01],
	[1.2045000000E+04, 5.5418928062E+00, 5.7972684340E+00, 3.6020164973E-01, 3.1957442858E-01, 5.9097345426E-01],
	[1.2050000000E+04, 5.5449763156E+00, 5.7967430449E+00, 3.6067338736E-01, 3.1995436936E-01, 5.9111789859E-01],
	[1.2055000000E+04, 5.5480602605E+00, 5.7962179213E+00, 3.6114554646E-01, 3.2033456334E-01, 5.9126232402E-01],
	[1.2060000000E+04, 5.5511446406E+00, 5.7956930630E+00, 3.6161812722E-01, 3.2071501048E-01, 5.9140673053E-01],
	[1.2065000000E+04, 5.5542294559E+00, 5.7951684697E+00, 3.6209112985E-01, 3.2109571076E-01, 5.9155111810E-01],
	[1.2070000000E+04, 5.5573147063E+00, 5.7946441413E+00, 3.6256455454E-01, 3.2147666415E-01, 5.9169548673E-01],
	[1.2075000000E+04, 5.5604003916E+00, 5.7941200775E+00, 3.6303840149E-01, 3.2185787062E-01, 5.9183983641E-01],
	[1.2080000000E+04, 5.5634865116E+00, 5.7935962779E+00, 3.6351267092E-01, 3.2223933013E-01, 5.9198416713E-01],
	[1.2085000000E+04, 5.5665730664E+00, 5.7930727425E+00, 3.6398736302E-01, 3.2262104266E-01, 5.9212847887E-01],
	[1.2090000000E+04, 5.5696600557E+00, 5.7925494709E+00, 3.6446247798E-01, 3.2300300817E-01, 5.9227277162E-01],
	[1.2095000000E+04, 5.5727474795E+00, 5.7920264629E+00, 3.6493801602E-01, 3.2338522664E-01, 5.9241704538E-01],
	[1.2100000000E+04, 5.5758353376E+00, 5.7915037182E+00, 3.6541397733E-01, 3.2376769803E-01, 5.9256130012E-01],
	[1.2105000000E+04, 5.5789236299E+00, 5.7909812367E+00, 3.6589036211E-01, 3.2415042231E-01, 5.9270553585E-01],
	[1.2110000000E+04, 5.5820123563E+00, 5.7904590180E+00, 3.6636717058E-01, 3.2453339945E-01, 5.9284975255E-01],
	[1.2115000000E+04, 5.5851015166E+00, 5.7899370620E+00, 3.6684440291E-01, 3.2491662941E-01, 5.9299395020E-01],
	[1.2120000000E+04, 5.5881911109E+00, 5.7894153684E+00, 3.6732205933E-01, 3.2530011217E-01, 5.9313812880E-01],
	[1.2125000000E+04, 5.5912811388E+00, 5.7888939369E+00, 3.6780014002E-01, 3.2568384769E-01, 5.9328228834E-01],
	[1.2130000000E+04, 5.5943716004E+00, 5.7883727673E+00, 3.6827864520E-01, 3.2606783594E-01, 5.9342642881E-01],
	[1.2135000000E+04, 5.5974624955E+00, 5.7878518594E+00, 3.6875757506E-01, 3.2645207689E-01, 5.9357055019E-01],
	[1.2140000000E+04, 5.6005538240E+00, 5.7873312130E+00, 3.6923692980E-01, 3.2683657051E-01, 5.9371465248E-01],
	[1.2145000000E+04, 5.6036455857E+00, 5.7868108277E+00, 3.6971670962E-01, 3.2722131675E-01, 5.9385873566E-01],
	[1.2150000000E+04, 5.6067377806E+00, 5.7862907034E+00, 3.7019691474E-01, 3.2760631559E-01, 5.9400279972E-01],
	[1.2155000000E+04, 5.6098304085E+00, 5.7857708398E+00, 3.7067754534E-01, 3.2799156700E-01, 5.9414684465E-01],
	[1.2160000000E+04, 5.6129234693E+00, 5.7852512367E+00, 3.7115860162E-01, 3.2837707093E-01, 5.9429087045E-01],
	[1.2165000000E+04, 5.6160169630E+00, 5.7847318939E+00, 3.7164008380E-01, 3.2876282737E-01, 5.9443487710E-01],
	[1.2170000000E+04, 5.6191108893E+00, 5.7842128110E+00, 3.7212199207E-01, 3.2914883626E-01, 5.9457886458E-01],
	[1.2175000000E+04, 5.6222052481E+00, 5.7836939879E+00, 3.7260432664E-01, 3.2953509759E-01, 5.9472283290E-01],
	[1.2180000000E+04, 5.6253000394E+00, 5.7831754244E+00, 3.7308708769E-01, 3.2992161131E-01, 5.9486678204E-01],
	[1.2185000000E+04, 5.6283952631E+00, 5.7826571201E+00, 3.7357027545E-01, 3.3030837739E-01, 5.9501071199E-01],
	[1.2190000000E+04, 5.6314909189E+00, 5.7821390749E+00, 3.7405389010E-01, 3.3069539580E-01, 5.9515462273E-01],
	[1.2195000000E+04, 5.6345870069E+00, 5.7816212886E+00, 3.7453793185E-01, 3.3108266650E-01, 5.9529851426E-01],
	[1.2200000000E+04, 5.6376835268E+00, 5.7811037608E+00, 3.7502240090E-01, 3.3147018945E-01, 5.9544238658E-01],
	[1.2205000000E+04, 5.6407804785E+00, 5.7805864914E+00, 3.7550729745E-01, 3.3185796463E-01, 5.9558623965E-01],
	[1.2210000000E+04, 5.6438778621E+00, 5.7800694801E+00, 3.7599262170E-01, 3.3224599199E-01, 5.9573007349E-01],
	[1.2215000000E+04, 5.6469756772E+00, 5.7795527267E+00, 3.7647837386E-01, 3.3263427150E-01, 5.9587388807E-01],
	[1.2220000000E+04, 5.6500739238E+00, 5.7790362309E+00, 3.7696455413E-01, 3.3302280312E-01, 5.9601768339E-01],
	[1.2225000000E+04, 5.6531726019E+00, 5.7785199925E+00, 3.7745116270E-01, 3.3341158683E-01, 5.9616145943E-01],
	[1.2230000000E+04, 5.6562730713E+00, 5.7780065524E+00, 3.7793819978E-01, 3.3380063579E-01, 5.9630521620E-01],
	[1.2235000000E+04, 5.6593772486E+00, 5.7774994839E+00, 3.7842566558E-01, 3.3418996870E-01, 5.9644895366E-01],
	[1.2240000000E+04, 5.6624818601E+00, 5.7769926671E+00, 3.7891356028E-01, 3.3457955375E-01, 5.9659267182E-01],
	[1.2245000000E+04, 5.6655869057E+00, 5.7764861018E+00, 3.7940188410E-01, 3.3496939092E-01, 5.9673637067E-01],
	[1.2250000000E+04, 5.6686923854E+00, 5.7759797876E+00, 3.7989063724E-01, 3.3535948017E-01, 5.9688005020E-01],
	[1.2255000000E+04, 5.6717982989E+00, 5.7754737244E+00, 3.8037981989E-01, 3.3574982146E-01, 5.9702371039E-01],
	[1.2260000000E+04, 5.6749046462E+00, 5.7749679119E+00, 3.8086943226E-01, 3.3614041475E-01, 5.9716735123E-01],
	[1.2265000000E+04, 5.6780114271E+00, 5.7744623499E+00, 3.8135947456E-01, 3.3653126000E-01, 5.9731097272E-01],
	[1.2270000000E+04, 5.6811186416E+00, 5.7739570383E+00, 3.8184994697E-01, 3.3692235719E-01, 5.9745457485E-01],
	[1.2275000000E+04, 5.6842262895E+00, 5.7734519767E+00, 3.8234084971E-01, 3.3731370627E-01, 5.9759815760E-01],
	[1.2280000000E+04, 5.6873343707E+00, 5.7729471649E+00, 3.8283218298E-01, 3.3770530720E-01, 5.9774172096E-01],
	[1.2285000000E+04, 5.6904428850E+00, 5.7724426028E+00, 3.8332394697E-01, 3.3809715995E-01, 5.9788526494E-01],
	[1.2290000000E+04, 5.6935518325E+00, 5.7719382900E+00, 3.8381614189E-01, 3.3848926448E-01, 5.9802878950E-01],
	[1.2295000000E+04, 5.6966612129E+00, 5.7714342264E+00, 3.8430876794E-01, 3.3888162075E-01, 5.9817229466E-01],
	[1.2300000000E+04, 5.6997710261E+00, 5.7709304118E+00, 3.8480182532E-01, 3.3927422872E-01, 5.9831578039E-01],
	[1.2305000000E+04, 5.7028812720E+00, 5.7704268458E+00, 3.8529531424E-01, 3.3966708836E-01, 5.9845924669E-01],
	[1.2310000000E+04, 5.7059919506E+00, 5.7699235283E+00, 3.8578923489E-01, 3.4006019962E-01, 5.9860269354E-01],
	[1.2315000000E+04, 5.7091030616E+00, 5.7694204592E+00, 3.8628358748E-01, 3.4045356247E-01, 5.9874612094E-01],
	[1.2320000000E+04, 5.7122146050E+00, 5.7689176380E+00, 3.8677837221E-01, 3.4084717687E-01, 5.9888952888E-01],
	[1.2325000000E+04, 5.7153265807E+00, 5.7684150647E+00, 3.8727358928E-01, 3.4124104278E-01, 5.9903291735E-01],
	[1.2330000000E+04, 5.7184389885E+00, 5.7679127390E+00, 3.8776923889E-01, 3.4163516016E-01, 5.9917628633E-01],
	[1.2335000000E+04, 5.7215518284E+00, 5.7674106606E+00, 3.8826532125E-01, 3.4202952897E-01, 5.9931963582E-01],
	[1.2340000000E+04, 5.7246651001E+00, 5.7669088294E+00, 3.8876183656E-01, 3.4242414917E-01, 5.9946296582E-01],
	[1.2345000000E+04, 5.7277788037E+00, 5.7664072452E+00, 3.8925878501E-01, 3.4281902073E-01, 5.9960627630E-01],
	[1.2350000000E+04, 5.7308929389E+00, 5.7659059076E+00, 3.8975616681E-01, 3.4321414360E-01, 5.9974956726E-01],
	[1.2355000000E+04, 5.7340075057E+00, 5.7654048166E+00, 3.9025398217E-01, 3.4360951773E-01, 5.9989283869E-01],
	[1.2360000000E+04, 5.7371225040E+00, 5.7649039718E+00, 3.9075223127E-01, 3.4400514311E-01, 6.0003609059E-01],
	[1.2365000000E+04, 5.7402379336E+00, 5.7644033730E+00, 3.9125091434E-01, 3.4440101967E-01, 6.0017932293E-01],
	[1.2370000000E+04, 5.7433537944E+00, 5.7639030201E+00, 3.9175003156E-01, 3.4479714738E-01, 6.0032253572E-01],
	[1.2375000000E+04, 5.7464700863E+00, 5.7634029128E+00, 3.9224958314E-01, 3.4519352620E-01, 6.0046572894E-01],
	[1.2380000000E+04, 5.7495868092E+00, 5.7629030509E+00, 3.9274956928E-01, 3.4559015609E-01, 6.0060890259E-01],
	[1.2385000000E+04, 5.7527039630E+00, 5.7624034341E+00, 3.9324999019E-01, 3.4598703701E-01, 6.0075205665E-01],
	[1.2390000000E+04, 5.7558215476E+00, 5.7619040623E+00, 3.9375084606E-01, 3.4638416891E-01, 6.0089519111E-01],
	[1.2395000000E+04, 5.7589395628E+00, 5.7614049353E+00, 3.9425213710E-01, 3.4678155176E-01, 6.0103830597E-01],
	[1.2400000000E+04, 5.7620580085E+00, 5.7609060527E+00, 3.9475386350E-01, 3.4717918551E-01, 6.0118140122E-01],
	[1.2405000000E+04, 5.7651768847E+00, 5.7604074145E+00, 3.9525602548E-01, 3.4757707013E-01, 6.0132447684E-01],
	[1.2410000000E+04, 5.7682961912E+00, 5.7599090203E+00, 3.9575862323E-01, 3.4797520556E-01, 6.0146753283E-01],
	[1.2415000000E+04, 5.7714159279E+00, 5.7594108700E+00, 3.9626165696E-01, 3.4837359177E-01, 6.0161056919E-01],
	[1.2420000000E+04, 5.7745360946E+00, 5.7589129633E+00, 3.9676512686E-01, 3.4877222871E-01, 6.0175358589E-01],
	[1.2425000000E+04, 5.7776566913E+00, 5.7584153000E+00, 3.9726903314E-01, 3.4917111635E-01, 6.0189658293E-01],
	[1.2430000000E+04, 5.7807821284E+00, 5.7579255594E+00, 3.9777337601E-01, 3.4957029906E-01, 6.0203956031E-01],
	[1.2435000000E+04, 5.7839083771E+00, 5.7574367168E+00, 3.9827815565E-01, 3.4996973639E-01, 6.0218251800E-01],
	[1.2440000000E+04, 5.7870350586E+00, 5.7569481122E+00, 3.9878337228E-01, 3.5036942446E-01, 6.0232545602E-01],
	[1.2445000000E+04, 5.7901621730E+00, 5.7564597453E+00, 3.9928902610E-01, 3.5076936324E-01, 6.0246837433E-01],
	[1.2450000000E+04, 5.7932897200E+00, 5.7559716161E+00, 3.9979511731E-01, 3.5116955268E-01, 6.0261127295E-01],
	[1.2455000000E+04, 5.7964176995E+00, 5.7554837242E+00, 4.0030164611E-01, 3.5156999275E-01, 6.0275415185E-01],
	[1.2460000000E+04, 5.7995461114E+00, 5.7549960695E+00, 4.0080861270E-01, 3.5197068340E-01, 6.0289701103E-01],
	[1.2465000000E+04, 5.8026749557E+00, 5.7545086517E+00, 4.0131601729E-01, 3.5237162458E-01, 6.0303985048E-01],
	[1.2470000000E+04, 5.8058042321E+00, 5.7540214706E+00, 4.0182386007E-01, 3.5277281625E-01, 6.0318267019E-01],
	[1.2475000000E+04, 5.8089339406E+00, 5.7535345261E+00, 4.0233214126E-01, 3.5317425838E-01, 6.0332547015E-01],
	[1.2480000000E+04, 5.8120640811E+00, 5.7530478178E+00, 4.0284086104E-01, 3.5357595090E-01, 6.0346825035E-01],
	[1.2485000000E+04, 5.8151946534E+00, 5.7525613457E+00, 4.0335001964E-01, 3.5397789378E-01, 6.0361101085E-01],
	[1.2490000000E+04, 5.8183256574E+00, 5.7520751095E+00, 4.0385961723E-01, 3.5438008698E-01, 6.0375375167E-01],
	[1.2495000000E+04, 5.8214570931E+00, 5.7515891089E+00, 4.0436965404E-01, 3.5478253045E-01, 6.0389647282E-01],
	[1.2500000000E+04, 5.8245889603E+00, 5.7511033438E+00, 4.0488013025E-01, 3.5518522414E-01, 6.0403917426E-01],
	[1.2505000000E+04, 5.8277212589E+00, 5.7506178140E+00, 4.0539171677E-01, 3.5558868403E-01, 6.0418185600E-01],
	[1.2510000000E+04, 5.8308539887E+00, 5.7501325193E+00, 4.0590374455E-01, 3.5599239491E-01, 6.0432451800E-01],
	[1.2515000000E+04, 5.8339871498E+00, 5.7496474594E+00, 4.0641621380E-01, 3.5639635673E-01, 6.0446716027E-01],
	[1.2520000000E+04, 5.8371207418E+00, 5.7491626342E+00, 4.0692912472E-01, 3.5680056945E-01, 6.0460978277E-01],
	[1.2525000000E+04, 5.8402547649E+00, 5.7486780434E+00, 4.0744247752E-01, 3.5720503302E-01, 6.0475238550E-01],
	[1.2530000000E+04, 5.8433892187E+00, 5.7481936868E+00, 4.0795627240E-01, 3.5760974740E-01, 6.0489496843E-01],
	[1.2535000000E+04, 5.8465241033E+00, 5.7477095643E+00, 4.0847050956E-01, 3.5801471254E-01, 6.0503753156E-01],
	[1.2540000000E+04, 5.8496594185E+00, 5.7472256756E+00, 4.0898518921E-01, 3.5841992839E-01, 6.0518007487E-01],
	[1.2545000000E+04, 5.8527951642E+00, 5.7467420204E+00, 4.0950031155E-01, 3.5882539490E-01, 6.0532259834E-01],
	[1.2550000000E+04, 5.8559313403E+00, 5.7462585987E+00, 4.1001587679E-01, 3.5923111204E-01, 6.0546510195E-01],
	[1.2555000000E+04, 5.8590679466E+00, 5.7457754102E+00, 4.1053188512E-01, 3.5963707976E-01, 6.0560758570E-01],
	[1.2560000000E+04, 5.8622049831E+00, 5.7452924547E+00, 4.1104833676E-01, 3.6004329800E-01, 6.0575004956E-01],
	[1.2565000000E+04, 5.8653424496E+00, 5.7448097320E+00, 4.1156523191E-01, 3.6044976672E-01, 6.0589249352E-01],
	[1.2570000000E+04, 5.8684803461E+00, 5.7443272419E+00, 4.1208257076E-01, 3.6085648588E-01, 6.0603491757E-01],
	[1.2575000000E+04, 5.8716186724E+00, 5.7438449841E+00, 4.1260035353E-01, 3.6126345542E-01, 6.0617732168E-01],
	[1.2580000000E+04, 5.8747574284E+00, 5.7433629586E+00, 4.1311858042E-01, 3.6167067530E-01, 6.0631970585E-01],
	[1.2585000000E+04, 5.8778966139E+00, 5.7428811650E+00, 4.1363725162E-01, 3.6207814547E-01, 6.0646207006E-01],
	[1.2590000000E+04, 5.8810362290E+00, 5.7423996032E+00, 4.1415636736E-01, 3.6248586588E-01, 6.0660441430E-01],
	[1.2595000000E+04, 5.8841762735E+00, 5.7419182729E+00, 4.1467592782E-01, 3.6289383650E-01, 6.0674673854E-01],
	[1.2600000000E+04, 5.8873167472E+00, 5.7414371740E+00, 4.1519593322E-01, 3.6330205725E-01, 6.0688904277E-01],
	[1.2605000000E+04, 5.8904576500E+00, 5.7409563063E+00, 4.1571638375E-01, 3.6371052811E-01, 6.0703132698E-01],
	[1.2610000000E+04, 5.8935989819E+00, 5.7404756695E+00, 4.1623727963E-01, 3.6411924902E-01, 6.0717359116E-01],
	[1.2615000000E+04, 5.8967407427E+00, 5.7399952635E+00, 4.1675862105E-01, 3.6452821992E-01, 6.0731583528E-01],
	[1.2620000000E+04, 5.8998829323E+00, 5.7395150880E+00, 4.1728040822E-01, 3.6493744079E-01, 6.0745805933E-01],
	[1.2625000000E+04, 5.9030255507E+00, 5.7390351429E+00, 4.1780264134E-01, 3.6534691155E-01, 6.0760026331E-01],
	[1.2630000000E+04, 5.9061732496E+00, 5.7385628419E+00, 4.1832532062E-01, 3.6575668013E-01, 6.0774244718E-01],
	[1.2635000000E+04, 5.9093218152E+00, 5.7380914595E+00, 4.1884844626E-01, 3.6616670318E-01, 6.0788461095E-01],
	[1.2640000000E+04, 5.9124708126E+00, 5.7376203023E+00, 4.1937201847E-01, 3.6657697620E-01, 6.0802675458E-01],
	[1.2645000000E+04, 5.9156202416E+00, 5.7371493701E+00, 4.1989603744E-01, 3.6698749911E-01, 6.0816887807E-01],
	[1.2650000000E+04, 5.9187701022E+00, 5.7366786627E+00, 4.2042050339E-01, 3.6739827189E-01, 6.0831098141E-01],
	[1.2655000000E+04, 5.9219203942E+00, 5.7362081799E+00, 4.2094541652E-01, 3.6780929447E-01, 6.0845306458E-01],
	[1.2660000000E+04, 5.9250711175E+00, 5.7357379215E+00, 4.2147077702E-01, 3.6822056680E-01, 6.0859512755E-01],
	[1.2665000000E+04, 5.9282222721E+00, 5.7352678874E+00, 4.2199658511E-01, 3.6863208884E-01, 6.0873717033E-01],
	[1.2670000000E+04, 5.9313738577E+00, 5.7347980772E+00, 4.2252284099E-01, 3.6904386054E-01, 6.0887919289E-01],
	[1.2675000000E+04, 5.9345258744E+00, 5.7343284909E+00, 4.2304954487E-01, 3.6945588184E-01, 6.0902119522E-01],
	[1.2680000000E+04, 5.9376783219E+00, 5.7338591283E+00, 4.2357669694E-01, 3.6986815270E-01, 6.0916317730E-01],
	[1.2685000000E+04, 5.9408312002E+00, 5.7333899891E+00, 4.2410429741E-01, 3.7028067307E-01, 6.0930513913E-01],
	[1.2690000000E+04, 5.9439845092E+00, 5.7329210731E+00, 4.2463234649E-01, 3.7069344288E-01, 6.0944708068E-01],
	[1.2695000000E+04, 5.9471382487E+00, 5.7324523802E+00, 4.2516084437E-01, 3.7110646210E-01, 6.0958900194E-01],
	[1.2700000000E+04, 5.9502924187E+00, 5.7319839101E+00, 4.2568979127E-01, 3.7151973067E-01, 6.0973090289E-01],
	[1.2705000000E+04, 5.9534470189E+00, 5.7315156627E+00, 4.2621918739E-01, 3.7193324854E-01, 6.0987278353E-01],
	[1.2710000000E+04, 5.9566020494E+00, 5.7310476377E+00, 4.2674903293E-01, 3.7234701566E-01, 6.1001464383E-01],
	[1.2715000000E+04, 5.9597575100E+00, 5.7305798351E+00, 4.2727932810E-01, 3.7276103197E-01, 6.1015648379E-01],
	[1.2720000000E+04, 5.9629134006E+00, 5.7301122545E+00, 4.2781007310E-01, 3.7317529743E-01, 6.1029830338E-01],
	[1.2725000000E+04, 5.9660697211E+00, 5.7296448958E+00, 4.2834126813E-01, 3.7358981198E-01, 6.1044010260E-01],
	[1.2730000000E+04, 5.9692264714E+00, 5.7291777588E+00, 4.2887291340E-01, 3.7400457557E-01, 6.1058188143E-01],
	[1.2735000000E+04, 5.9723836513E+00, 5.7287108433E+00, 4.2940500912E-01, 3.7441958815E-01, 6.1072363985E-01],
	[1.2740000000E+04, 5.9755412607E+00, 5.7282441491E+00, 4.2993755548E-01, 3.7483484966E-01, 6.1086537785E-01],
	[1.2745000000E+04, 5.9786992997E+00, 5.7277776761E+00, 4.3047055269E-01, 3.7525036005E-01, 6.1100709542E-01],
	[1.2750000000E+04, 5.9818577679E+00, 5.7273114240E+00, 4.3100400096E-01, 3.7566611927E-01, 6.1114879254E-01],
	[1.2755000000E+04, 5.9850166654E+00, 5.7268453926E+00, 4.3153790049E-01, 3.7608212727E-01, 6.1129046920E-01],
	[1.2760000000E+04, 5.9881759920E+00, 5.7263795817E+00, 4.3207225148E-01, 3.7649838399E-01, 6.1143212539E-01],
	[1.2765000000E+04, 5.9913357476E+00, 5.7259139913E+00, 4.3260705414E-01, 3.7691488938E-01, 6.1157376108E-01],
	[1.2770000000E+04, 5.9944959320E+00, 5.7254486210E+00, 4.3314230867E-01, 3.7733164338E-01, 6.1171537627E-01],
	[1.2775000000E+04, 5.9976565453E+00, 5.7249834706E+00, 4.3367801529E-01, 3.7774864595E-01, 6.1185697094E-01],
	[1.2780000000E+04, 6.0008175873E+00, 5.7245185401E+00, 4.3421417418E-01, 3.7816589702E-01, 6.1199854508E-01],
	[1.2785000000E+04, 6.0039790578E+00, 5.7240538291E+00, 4.3475078556E-01, 3.7858339654E-01, 6.1214009867E-01],
	[1.2790000000E+04, 6.0071409567E+00, 5.7235893376E+00, 4.3528784963E-01, 3.7900114446E-01, 6.1228163170E-01],
	[1.2795000000E+04, 6.0103032840E+00, 5.7231250653E+00, 4.3582536659E-01, 3.7941914073E-01, 6.1242314415E-01],
	[1.2800000000E+04, 6.0134660396E+00, 5.7226610120E+00, 4.3636333665E-01, 3.7983738528E-01, 6.1256463602E-01],
	[1.2805000000E+04, 6.0166292233E+00, 5.7221971776E+00, 4.3690176002E-01, 3.8025587807E-01, 6.1270610729E-01],
	[1.2810000000E+04, 6.0197928350E+00, 5.7217335618E+00, 4.3744063689E-01, 3.8067461903E-01, 6.1284755793E-01],
	[1.2815000000E+04, 6.0229568746E+00, 5.7212701644E+00, 4.3797996748E-01, 3.8109360812E-01, 6.1298898795E-01],
	[1.2820000000E+04, 6.0261213420E+00, 5.7208069854E+00, 4.3851975198E-01, 3.8151284528E-01, 6.1313039733E-01],
	[1.2825000000E+04, 6.0292862371E+00, 5.7203440244E+00, 4.3905999060E-01, 3.8193233045E-01, 6.1327178604E-01],
	[1.2830000000E+04, 6.0324530095E+00, 5.7198833773E+00, 4.3960068355E-01, 3.8235207877E-01, 6.1341315409E-01],
	[1.2835000000E+04, 6.0356242518E+00, 5.7194287860E+00, 4.4014183103E-01, 3.8277211745E-01, 6.1355450145E-01],
	[1.2840000000E+04, 6.0387959252E+00, 5.7189744080E+00, 4.4068343324E-01, 3.8319240419E-01, 6.1369582811E-01],
	[1.2845000000E+04, 6.0419680294E+00, 5.7185202429E+00, 4.4122549039E-01, 3.8361293893E-01, 6.1383713406E-01],
	[1.2850000000E+04, 6.0451405644E+00, 5.7180662906E+00, 4.4176800269E-01, 3.8403372162E-01, 6.1397841929E-01],
	[1.2855000000E+04, 6.0483135301E+00, 5.7176125509E+00, 4.4231097033E-01, 3.8445475220E-01, 6.1411968377E-01],
	[1.2860000000E+04, 6.0514869263E+00, 5.7171590237E+00, 4.4285439353E-01, 3.8487603061E-01, 6.1426092750E-01],
	[1.2865000000E+04, 6.0546607530E+00, 5.7167057087E+00, 4.4339827248E-01, 3.8529755680E-01, 6.1440215046E-01],
	[1.2870000000E+04, 6.0578350100E+00, 5.7162526058E+00, 4.4394260739E-01, 3.8571933070E-01, 6.1454335265E-01],
	[1.2875000000E+04, 6.0610096972E+00, 5.7157997147E+00, 4.4448739847E-01, 3.8614135227E-01, 6.1468453404E-01],
	[1.2880000000E+04, 6.0641848146E+00, 5.7153470354E+00, 4.4503264592E-01, 3.8656362145E-01, 6.1482569462E-01],
	[1.2885000000E+04, 6.0673603619E+00, 5.7148945676E+00, 4.4557834995E-01, 3.8698613817E-01, 6.1496683438E-01],
	[1.2890000000E+04, 6.0705363392E+00, 5.7144423112E+00, 4.4612451075E-01, 3.8740890238E-01, 6.1510795331E-01],
	[1.2895000000E+04, 6.0737127462E+00, 5.7139902659E+00, 4.4667112854E-01, 3.8783191403E-01, 6.1524905139E-01],
	[1.2900000000E+04, 6.0768895830E+00, 5.7135384316E+00, 4.4721820352E-01, 3.8825517305E-01, 6.1539012861E-01],
	[1.2905000000E+04, 6.0800668493E+00, 5.7130868081E+00, 4.4776573589E-01, 3.8867867939E-01, 6.1553118495E-01],
	[1.2910000000E+04, 6.0832445451E+00, 5.7126353952E+00, 4.4831372586E-01, 3.8910243299E-01, 6.1567222041E-01],
	[1.2915000000E+04, 6.0864226702E+00, 5.7121841928E+00, 4.4886217364E-01, 3.8952643380E-01, 6.1581323497E-01],
	[1.2920000000E+04, 6.0896012246E+00, 5.7117332006E+00, 4.4941107942E-01, 3.8995068174E-01, 6.1595422861E-01],
	[1.2925000000E+04, 6.0927802081E+00, 5.7112824185E+00, 4.4996044341E-01, 3.9037517677E-01, 6.1609520133E-01],
	[1.2930000000E+04, 6.0959596207E+00, 5.7108318464E+00, 4.5051026582E-01, 3.9079991882E-01, 6.1623615311E-01],
	[1.2935000000E+04, 6.0991394622E+00, 5.7103814839E+00, 4.5106054685E-01, 3.9122490784E-01, 6.1637708393E-01],
	[1.2940000000E+04, 6.1023197325E+00, 5.7099313310E+00, 4.5161128671E-01, 3.9165014377E-01, 6.1651799379E-01],
	[1.2945000000E+04, 6.1055004315E+00, 5.7094813875E+00, 4.5216248559E-01, 3.9207562654E-01, 6.1665888267E-01],
	[1.2950000000E+04, 6.1086815591E+00, 5.7090316531E+00, 4.5271414372E-01, 3.9250135610E-01, 6.1679975055E-01],
	[1.2955000000E+04, 6.1118631152E+00, 5.7085821278E+00, 4.5326626128E-01, 3.9292733239E-01, 6.1694059744E-01],
	[1.2960000000E+04, 6.1150450997E+00, 5.7081328113E+00, 4.5381883849E-01, 3.9335355535E-01, 6.1708142330E-01],
	[1.2965000000E+04, 6.1182275125E+00, 5.7076837035E+00, 4.5437187555E-01, 3.9378002492E-01, 6.1722222813E-01],
	[1.2970000000E+04, 6.1214103535E+00, 5.7072348042E+00, 4.5492537267E-01, 3.9420674103E-01, 6.1736301192E-01],
	[1.2975000000E+04, 6.1245936225E+00, 5.7067861131E+00, 4.5547933004E-01, 3.9463370363E-01, 6.1750377465E-01],
	[1.2980000000E+04, 6.1277773194E+00, 5.7063376302E+00, 4.5603374788E-01, 3.9506091266E-01, 6.1764451631E-01],
	[1.2985000000E+04, 6.1309614443E+00, 5.7058893552E+00, 4.5658862639E-01, 3.9548836806E-01, 6.1778523689E-01],
	[1.2990000000E+04, 6.1341459968E+00, 5.7054412881E+00, 4.5714396577E-01, 3.9591606976E-01, 6.1792593637E-01],
	[1.2995000000E+04, 6.1373309770E+00, 5.7049934285E+00, 4.5769976623E-01, 3.9634401771E-01, 6.1806661475E-01],
	[1.3000000000E+04, 6.1405163848E+00, 5.7045457763E+00, 4.5825602797E-01, 3.9677221184E-01, 6.1820727200E-01],
	[1.3005000000E+04, 6.1437022199E+00, 5.7040983314E+00, 4.5881275120E-01, 3.9720065210E-01, 6.1834790812E-01],
	[1.3010000000E+04, 6.1468884824E+00, 5.7036510935E+00, 4.5936993613E-01, 3.9762933841E-01, 6.1848852309E-01],
	[1.3015000000E+04, 6.1500751720E+00, 5.7032040626E+00, 4.5992758295E-01, 3.9805827072E-01, 6.1862911691E-01],
	[1.3020000000E+04, 6.1532622888E+00, 5.7027572383E+00, 4.6048569188E-01, 3.9848744897E-01, 6.1876968955E-01],
	[1.3025000000E+04, 6.1564498326E+00, 5.7023106206E+00, 4.6104426312E-01, 3.9891687309E-01, 6.1891024101E-01],
	[1.3030000000E+04, 6.1596378032E+00, 5.7018642093E+00, 4.6160329686E-01, 3.9934654303E-01, 6.1905077127E-01],
	[1.3035000000E+04, 6.1628262006E+00, 5.7014180042E+00, 4.6216279333E-01, 3.9977645872E-01, 6.1919128033E-01],
	[1.3040000000E+04, 6.1660206862E+00, 5.7009794573E+00, 4.6272275272E-01, 4.0020668066E-01, 6.1933176820E-01],
	[1.3045000000E+04, 6.1692158428E+00, 5.7005414290E+00, 4.6328317524E-01, 4.0063715103E-01, 6.1947223490E-01],
	[1.3050000000E+04, 6.1724114298E+00, 5.7001036023E+00, 4.6384406109E-01, 4.0106786720E-01, 6.1961268043E-01],
	[1.3055000000E+04, 6.1756074469E+00, 5.6996659768E+00, 4.6440541048E-01, 4.0149882908E-01, 6.1975310476E-01],
	[1.3060000000E+04, 6.1788038941E+00, 5.6992285525E+00, 4.6496722361E-01, 4.0193003664E-01, 6.1989350786E-01],
	[1.3065000000E+04, 6.1820007714E+00, 5.6987913292E+00, 4.6552950069E-01, 4.0236148979E-01, 6.2003388972E-01],
	[1.3070000000E+04, 6.1851980784E+00, 5.6983543067E+00, 4.6609224192E-01, 4.0279318848E-01, 6.2017425032E-01],
	[1.3075000000E+04, 6.1883958153E+00, 5.6979174848E+00, 4.6665544751E-01, 4.0322513265E-01, 6.2031458963E-01],
	[1.3080000000E+04, 6.1915939818E+00, 5.6974808634E+00, 4.6721911766E-01, 4.0365732222E-01, 6.2045490764E-01],
	[1.3085000000E+04, 6.1947925779E+00, 5.6970444424E+00, 4.6778325258E-01, 4.0408975715E-01, 6.2059520433E-01],
	[1.3090000000E+04, 6.1979916035E+00, 5.6966082214E+00, 4.6834785247E-01, 4.0452243736E-01, 6.2073547966E-01],
	[1.3095000000E+04, 6.2011910584E+00, 5.6961722005E+00, 4.6891291754E-01, 4.0495536279E-01, 6.2087573364E-01],
	[1.3100000000E+04, 6.2043909425E+00, 5.6957363793E+00, 4.6947844800E-01, 4.0538853337E-01, 6.2101596623E-01],
	[1.3105000000E+04, 6.2075912558E+00, 5.6953007578E+00, 4.7004444404E-01, 4.0582194904E-01, 6.2115617741E-01],
	[1.3110000000E+04, 6.2107919981E+00, 5.6948653358E+00, 4.7061090588E-01, 4.0625560974E-01, 6.2129636716E-01],
	[1.3115000000E+04, 6.2139931693E+00, 5.6944301131E+00, 4.7117783371E-01, 4.0668951541E-01, 6.2143653547E-01],
	[1.3120000000E+04, 6.2171947693E+00, 5.6939950895E+00, 4.7174522775E-01, 4.0712366597E-01, 6.2157668231E-01],
	[1.3125000000E+04, 6.2203967980E+00, 5.6935602649E+00, 4.7231308820E-01, 4.0755806136E-01, 6.2171680766E-01],
	[1.3130000000E+04, 6.2235992554E+00, 5.6931256390E+00, 4.7288141526E-01, 4.0799270152E-01, 6.2185691150E-01],
	[1.3135000000E+04, 6.2268021412E+00, 5.6926912118E+00, 4.7345020914E-01, 4.0842758638E-01, 6.2199699382E-01],
	[1.3140000000E+04, 6.2300054555E+00, 5.6922569831E+00, 4.7401947004E-01, 4.0886271587E-01, 6.2213705459E-01],
	[1.3145000000E+04, 6.2332091980E+00, 5.6918229527E+00, 4.7458919818E-01, 4.0929808994E-01, 6.2227709379E-01],
	[1.3150000000E+04, 6.2364133687E+00, 5.6913891204E+00, 4.7515939375E-01, 4.0973370851E-01, 6.2241711141E-01],
	[1.3155000000E+04, 6.2396179675E+00, 5.6909554861E+00, 4.7573005696E-01, 4.1016957151E-01, 6.2255710741E-01],
	[1.3160000000E+04, 6.2428229942E+00, 5.6905220496E+00, 4.7630118801E-01, 4.1060567889E-01, 6.2269708179E-01],
	[1.3165000000E+04, 6.2460284488E+00, 5.6900888108E+00, 4.7687278711E-01, 4.1104203058E-01, 6.2283703452E-01],
	[1.3170000000E+04, 6.2492343312E+00, 5.6896557694E+00, 4.7744485447E-01, 4.1147862650E-01, 6.2297696558E-01],
	[1.3175000000E+04, 6.2524406412E+00, 5.6892229253E+00, 4.7801739029E-01, 4.1191546659E-01, 6.2311687496E-01],
	[1.3180000000E+04, 6.2556473788E+00, 5.6887902784E+00, 4.7859039478E-01, 4.1235255079E-01, 6.2325676263E-01],
	[1.3185000000E+04, 6.2588545438E+00, 5.6883578285E+00, 4.7916386814E-01, 4.1278987903E-01, 6.2339662857E-01],
	[1.3190000000E+04, 6.2620621361E+00, 5.6879255753E+00, 4.7973781058E-01, 4.1322745124E-01, 6.2353647276E-01],
	[1.3195000000E+04, 6.2652701557E+00, 5.6874935189E+00, 4.8031222229E-01, 4.1366526735E-01, 6.2367629519E-01],
	[1.3200000000E+04, 6.2684786024E+00, 5.6870616589E+00, 4.8088710350E-01, 4.1410332730E-01, 6.2381609583E-01],
	[1.3205000000E+04, 6.2716874762E+00, 5.6866299952E+00, 4.8146245439E-01, 4.1454163101E-01, 6.2395587467E-01],
	[1.3210000000E+04, 6.2748967768E+00, 5.6861985277E+00, 4.8203827519E-01, 4.1498017843E-01, 6.2409563168E-01],
	[1.3215000000E+04, 6.2781065043E+00, 5.6857672562E+00, 4.8261456609E-01, 4.1541896948E-01, 6.2423536685E-01],
	[1.3220000000E+04, 6.2813166584E+00, 5.6853361806E+00, 4.8319132730E-01, 4.1585800409E-01, 6.2437508015E-01],
	[1.3225000000E+04, 6.2845272392E+00, 5.6849053006E+00, 4.8376855902E-01, 4.1629728219E-01, 6.2451477157E-01],
	[1.3230000000E+04, 6.2877382465E+00, 5.6844746161E+00, 4.8434626146E-01, 4.1673680373E-01, 6.2465444108E-01],
	[1.3235000000E+04, 6.2909496802E+00, 5.6840441270E+00, 4.8492443483E-01, 4.1717656862E-01, 6.2479408867E-01],
	[1.3240000000E+04, 6.2941615401E+00, 5.6836138330E+00, 4.8550307932E-01, 4.1761657680E-01, 6.2493371432E-01],
	[1.3245000000E+04, 6.2973738262E+00, 5.6831837341E+00, 4.8608219516E-01, 4.1805682820E-01, 6.2507331801E-01],
	[1.3250000000E+04, 6.3005927895E+00, 5.6827613561E+00, 4.8666178253E-01, 4.1849739114E-01, 6.2521289972E-01],
	[1.3255000000E+04, 6.3038122497E+00, 5.6823392493E+00, 4.8724184165E-01, 4.1893819814E-01, 6.2535245942E-01],
	[1.3260000000E+04, 6.3070321398E+00, 5.6819173331E+00, 4.8782237272E-01, 4.1937924840E-01, 6.2549199711E-01],
	[1.3265000000E+04, 6.3102524597E+00, 5.6814956073E+00, 4.8840337595E-01, 4.1982054184E-01, 6.2563151276E-01],
	[1.3270000000E+04, 6.3134732094E+00, 5.6810740716E+00, 4.8898485155E-01, 4.2026207839E-01, 6.2577100635E-01],
	[1.3275000000E+04, 6.3166943887E+00, 5.6806527261E+00, 4.8956679971E-01, 4.2070385800E-01, 6.2591047787E-01],
	[1.3280000000E+04, 6.3199159975E+00, 5.6802315704E+00, 4.9014922065E-01, 4.2114588058E-01, 6.2604992729E-01],
	[1.3285000000E+04, 6.3231380357E+00, 5.6798106044E+00, 4.9073211456E-01, 4.2158814606E-01, 6.2618935459E-01],
	[1.3290000000E+04, 6.3263605033E+00, 5.6793898281E+00, 4.9131548166E-01, 4.2203065439E-01, 6.2632875976E-01],
	[1.3295000000E+04, 6.3295834000E+00, 5.6789692412E+00, 4.9189932215E-01, 4.2247340548E-01, 6.2646814277E-01],
	[1.3300000000E+04, 6.3328067259E+00, 5.6785488435E+00, 4.9248363624E-01, 4.2291639926E-01, 6.2660750362E-01],
	[1.3305000000E+04, 6.3360304807E+00, 5.6781286350E+00, 4.9306842413E-01, 4.2335963567E-01, 6.2674684227E-01],
	[1.3310000000E+04, 6.3392546644E+00, 5.6777086155E+00, 4.9365368603E-01, 4.2380311463E-01, 6.2688615871E-01],
	[1.3315000000E+04, 6.3424792770E+00, 5.6772887847E+00, 4.9423942214E-01, 4.2424683608E-01, 6.2702545293E-01],
	[1.3320000000E+04, 6.3457043182E+00, 5.6768691426E+00, 4.9482563267E-01, 4.2469079994E-01, 6.2716472489E-01],
	[1.3325000000E+04, 6.3489297880E+00, 5.6764496890E+00, 4.9541231782E-01, 4.2513500614E-01, 6.2730397459E-01],
	[1.3330000000E+04, 6.3521556862E+00, 5.6760304237E+00, 4.9599947780E-01, 4.2557945461E-01, 6.2744320201E-01],
	[1.3335000000E+04, 6.3553820129E+00, 5.6756113466E+00, 4.9658711282E-01, 4.2602414528E-01, 6.2758240712E-01],
	[1.3340000000E+04, 6.3586087678E+00, 5.6751924576E+00, 4.9717522308E-01, 4.2646907807E-01, 6.2772158991E-01],
	[1.3345000000E+04, 6.3618359508E+00, 5.6747737564E+00, 4.9776380879E-01, 4.2691425291E-01, 6.2786075035E-01],
	[1.3350000000E+04, 6.3650635620E+00, 5.6743552429E+00, 4.9835287015E-01, 4.2735966974E-01, 6.2799988844E-01],
	[1.3355000000E+04, 6.3682916011E+00, 5.6739369170E+00, 4.9894240737E-01, 4.2780532848E-01, 6.2813900415E-01],
	[1.3360000000E+04, 6.3715200680E+00, 5.6735187785E+00, 4.9953242065E-01, 4.2825122905E-01, 6.2827809746E-01],
	[1.3365000000E+04, 6.3747489627E+00, 5.6731008273E+00, 5.0012291020E-01, 4.2869737139E-01, 6.2841716835E-01],
	[1.3370000000E+04, 6.3779782851E+00, 5.6726830632E+00, 5.0071387622E-01, 4.2914375542E-01, 6.2855621682E-01],
	[1.3375000000E+04, 6.3812080350E+00, 5.6722654860E+00, 5.0130531893E-01, 4.2959038107E-01, 6.2869524282E-01],
	[1.3380000000E+04, 6.3844382123E+00, 5.6718480956E+00, 5.0189723852E-01, 4.3003724826E-01, 6.2883424636E-01],
	[1.3385000000E+04, 6.3876688170E+00, 5.6714308919E+00, 5.0248963521E-01, 4.3048435693E-01, 6.2897322741E-01],
	[1.3390000000E+04, 6.3908998489E+00, 5.6710138746E+00, 5.0308250919E-01, 4.3093170699E-01, 6.2911218595E-01],
	[1.3395000000E+04, 6.3941313079E+00, 5.6705970437E+00, 5.0367586068E-01, 4.3137929838E-01, 6.2925112196E-01],
	[1.3400000000E+04, 6.3973631940E+00, 5.6701803990E+00, 5.0426968988E-01, 4.3182713102E-01, 6.2939003543E-01],
	[1.3405000000E+04, 6.4005955070E+00, 5.6697639403E+00, 5.0486399699E-01, 4.3227520484E-01, 6.2952892634E-01],
	[1.3410000000E+04, 6.4038282468E+00, 5.6693476675E+00, 5.0545878223E-01, 4.3272351975E-01, 6.2966779467E-01],
	[1.3415000000E+04, 6.4070614133E+00, 5.6689315804E+00, 5.0605404579E-01, 4.3317207570E-01, 6.2980664039E-01],
	[1.3420000000E+04, 6.4102950065E+00, 5.6685156788E+00, 5.0664978788E-01, 4.3362087260E-01, 6.2994546350E-01],
	[1.3425000000E+04, 6.4135290261E+00, 5.6680999627E+00, 5.0724600872E-01, 4.3406991039E-01, 6.3008426398E-01],
	[1.3430000000E+04, 6.4167634722E+00, 5.6676844319E+00, 5.0784270850E-01, 4.3451918897E-01, 6.3022304180E-01],
	[1.3435000000E+04, 6.4199983446E+00, 5.6672690862E+00, 5.0843988743E-01, 4.3496870829E-01, 6.3036179695E-01],
	[1.3440000000E+04, 6.4232336432E+00, 5.6668539255E+00, 5.0903754571E-01, 4.3541846826E-01, 6.3050052941E-01],
	[1.3445000000E+04, 6.4264693679E+00, 5.6664389495E+00, 5.0963568356E-01, 4.3586846881E-01, 6.3063923916E-01],
	[1.3450000000E+04, 6.4297055186E+00, 5.6660241583E+00, 5.1023430118E-01, 4.3631870986E-01, 6.3077792619E-01],
	[1.3455000000E+04, 6.4329420952E+00, 5.6656095515E+00, 5.1083339877E-01, 4.3676919134E-01, 6.3091659047E-01],
	[1.3460000000E+04, 6.4361814148E+00, 5.6651976913E+00, 5.1143297654E-01, 4.3721993913E-01, 6.3105523199E-01],
	[1.3465000000E+04, 6.4394255828E+00, 5.6647908998E+00, 5.1203303470E-01, 4.3767097687E-01, 6.3119385074E-01],
	[1.3470000000E+04, 6.4426701806E+00, 5.6643842885E+00, 5.1263357345E-01, 4.3812225507E-01, 6.3133244668E-01],
	[1.3475000000E+04, 6.4459152083E+00, 5.6639778572E+00, 5.1323459299E-01, 4.3857377366E-01, 6.3147101981E-01],
	[1.3480000000E+04, 6.4491606656E+00, 5.6635716059E+00, 5.1383609354E-01, 4.3902553255E-01, 6.3160957011E-01],
	[1.3485000000E+04, 6.4524065524E+00, 5.6631655344E+00, 5.1443807531E-01, 4.3947753167E-01, 6.3174809756E-01],
	[1.3490000000E+04, 6.4556528688E+00, 5.6627596425E+00, 5.1504053848E-01, 4.3992977095E-01, 6.3188660214E-01],
	[1.3495000000E+04, 6.4588996144E+00, 5.6623539301E+00, 5.1564348328E-01, 4.4038225031E-01, 6.3202508383E-01],
	[1.3500000000E+04, 6.4621467894E+00, 5.6619483970E+00, 5.1624690991E-01, 4.4083496966E-01, 6.3216354262E-01],
	[1.3505000000E+04, 6.4653943935E+00, 5.6615430432E+00, 5.1685081857E-01, 4.4128792895E-01, 6.3230197850E-01],
	[1.3510000000E+04, 6.4686424267E+00, 5.6611378683E+00, 5.1745520947E-01, 4.4174112808E-01, 6.3244039143E-01],
	[1.3515000000E+04, 6.4718908888E+00, 5.6607328724E+00, 5.1806008282E-01, 4.4219456698E-01, 6.3257878140E-01],
	[1.3520000000E+04, 6.4751397797E+00, 5.6603280553E+00, 5.1866543882E-01, 4.4264824558E-01, 6.3271714841E-01],
	[1.3525000000E+04, 6.4783890995E+00, 5.6599234168E+00, 5.1927127767E-01, 4.4310216379E-01, 6.3285549242E-01],
	[1.3530000000E+04, 6.4816388478E+00, 5.6595189567E+00, 5.1987759959E-01, 4.4355632154E-01, 6.3299381342E-01],
	[1.3535000000E+04, 6.4848890247E+00, 5.6591146750E+00, 5.2048440479E-01, 4.4401071875E-01, 6.3313211140E-01],
	[1.3540000000E+04, 6.4881396301E+00, 5.6587105714E+00, 5.2109169346E-01, 4.4446535535E-01, 6.3327038633E-01],
	[1.3545000000E+04, 6.4913906638E+00, 5.6583066459E+00, 5.2169946581E-01, 4.4492023124E-01, 6.3340863821E-01],
	[1.3550000000E+04, 6.4946421257E+00, 5.6579028983E+00, 5.2230772205E-01, 4.4537534637E-01, 6.3354686700E-01],
	[1.3555000000E+04, 6.4978940158E+00, 5.6574993284E+00, 5.2291646238E-01, 4.4583070064E-01, 6.3368507270E-01],
	[1.3560000000E+04, 6.5011463339E+00, 5.6570959362E+00, 5.2352568702E-01, 4.4628629399E-01, 6.3382325529E-01],
	[1.3565000000E+04, 6.5043990799E+00, 5.6566927214E+00, 5.2413539616E-01, 4.4674212632E-01, 6.3396141475E-01],
	[1.3570000000E+04, 6.5076522538E+00, 5.6562896839E+00, 5.2474559002E-01, 4.4719819757E-01, 6.3409955107E-01],
	[1.3575000000E+04, 6.5109058554E+00, 5.6558868236E+00, 5.2535626879E-01, 4.4765450765E-01, 6.3423766421E-01],
	[1.3580000000E+04, 6.5141598846E+00, 5.6554841404E+00, 5.2596743269E-01, 4.4811105648E-01, 6.3437575418E-01],
	[1.3585000000E+04, 6.5174143414E+00, 5.6550816340E+00, 5.2657908193E-01, 4.4856784398E-01, 6.3451382095E-01],
	[1.3590000000E+04, 6.5206692256E+00, 5.6546793044E+00, 5.2719121670E-01, 4.4902487009E-01, 6.3465186451E-01],
	[1.3595000000E+04, 6.5239245371E+00, 5.6542771513E+00, 5.2780383721E-01, 4.4948213470E-01, 6.3478988483E-01],
	[1.3600000000E+04, 6.5271802758E+00, 5.6538751748E+00, 5.2841694368E-01, 4.4993963775E-01, 6.3492788191E-01],
	[1.3605000000E+04, 6.5304364417E+00, 5.6534733745E+00, 5.2903053630E-01, 4.5039737916E-01, 6.3506585572E-01],
	[1.3610000000E+04, 6.5336930346E+00, 5.6530717505E+00, 5.2964461529E-01, 4.5085535884E-01, 6.3520380624E-01],
	[1.3615000000E+04, 6.5369500544E+00, 5.6526703024E+00, 5.3025918085E-01, 4.5131357671E-01, 6.3534173347E-01],
	[1.3620000000E+04, 6.5402075010E+00, 5.6522690303E+00, 5.3087423318E-01, 4.5177203270E-01, 6.3547963738E-01],
	[1.3625000000E+04, 6.5434653744E+00, 5.6518679339E+00, 5.3148977249E-01, 4.5223072672E-01, 6.3561751795E-01],
	[1.3630000000E+04, 6.5467236744E+00, 5.6514670132E+00, 5.3210579900E-01, 4.5268965869E-01, 6.3575537518E-01],
	[1.3635000000E+04, 6.5499824009E+00, 5.6510662679E+00, 5.3272231289E-01, 4.5314882854E-01, 6.3589320904E-01],
	[1.3640000000E+04, 6.5532415538E+00, 5.6506656979E+00, 5.3333931439E-01, 4.5360823617E-01, 6.3603101952E-01],
	[1.3645000000E+04, 6.5565011331E+00, 5.6502653031E+00, 5.3395680370E-01, 4.5406788152E-01, 6.3616880659E-01],
	[1.3650000000E+04, 6.5597611385E+00, 5.6498650834E+00, 5.3457478102E-01, 4.5452776449E-01, 6.3630657025E-01],
	[1.3655000000E+04, 6.5630215701E+00, 5.6494650385E+00, 5.3519324656E-01, 4.5498788500E-01, 6.3644431047E-01],
	[1.3660000000E+04, 6.5662824277E+00, 5.6490651685E+00, 5.3581220052E-01, 4.5544824298E-01, 6.3658202725E-01],
	[1.3665000000E+04, 6.5695437112E+00, 5.6486654730E+00, 5.3643164312E-01, 4.5590883834E-01, 6.3671972056E-01],
	[1.3670000000E+04, 6.5728054205E+00, 5.6482659521E+00, 5.3705157456E-01, 4.5636967100E-01, 6.3685739038E-01],
	[1.3675000000E+04, 6.5760676411E+00, 5.6478666927E+00, 5.3767199504E-01, 4.5683074186E-01, 6.3699503671E-01],
	[1.3680000000E+04, 6.5793373656E+00, 5.6474748132E+00, 5.3829290478E-01, 4.5729213130E-01, 6.3713265952E-01],
	[1.3685000000E+04, 6.5826075201E+00, 5.6470831042E+00, 5.3891430397E-01, 4.5775375807E-01, 6.3727025879E-01],
	[1.3690000000E+04, 6.5858781045E+00, 5.6466915654E+00, 5.3953619283E-01, 4.5821562208E-01, 6.3740783452E-01],
	[1.3695000000E+04, 6.5891491187E+00, 5.6463001967E+00, 5.4016017638E-01, 4.5867888042E-01, 6.3754538668E-01],
	[1.3700000000E+04, 6.5924205626E+00, 5.6459089980E+00, 5.4078727408E-01, 4.5914426674E-01, 6.3768291526E-01],
	[1.3705000000E+04, 6.5956924361E+00, 5.6455179691E+00, 5.4141487031E-01, 4.5960989422E-01, 6.3782042025E-01],
	[1.3710000000E+04, 6.5989647391E+00, 5.6451271099E+00, 5.4204296528E-01, 4.6007576278E-01, 6.3795790161E-01],
	[1.3715000000E+04, 6.6022374716E+00, 5.6447364203E+00, 5.4267155921E-01, 4.6054187234E-01, 6.3809535935E-01],
	[1.3720000000E+04, 6.6055106333E+00, 5.6443459001E+00, 5.4330065231E-01, 4.6100822281E-01, 6.3823279344E-01],
	[1.3725000000E+04, 6.6087842243E+00, 5.6439555493E+00, 5.4393024480E-01, 4.6147481411E-01, 6.3837020387E-01],
	[1.3730000000E+04, 6.6120582443E+00, 5.6435653675E+00, 5.4456033689E-01, 4.6194164616E-01, 6.3850759062E-01],
	[1.3735000000E+04, 6.6153326934E+00, 5.6431753548E+00, 5.4519092879E-01, 4.6240871886E-01, 6.3864495367E-01],
	[1.3740000000E+04, 6.6186075714E+00, 5.6427855110E+00, 5.4582202072E-01, 4.6287603214E-01, 6.3878229301E-01],
	[1.3745000000E+04, 6.6218828781E+00, 5.6423958359E+00, 5.4645361289E-01, 4.6334358591E-01, 6.3891960863E-01],
	[1.3750000000E+04, 6.6251586136E+00, 5.6420063295E+00, 5.4708570552E-01, 4.6381138009E-01, 6.3905690050E-01],
	[1.3755000000E+04, 6.6284347777E+00, 5.6416169916E+00, 5.4771829882E-01, 4.6427941459E-01, 6.3919416861E-01],
	[1.3760000000E+04, 6.6317113703E+00, 5.6412278220E+00, 5.4835139300E-01, 4.6474768933E-01, 6.3933141295E-01],
	[1.3765000000E+04, 6.6349883913E+00, 5.6408388206E+00, 5.4898498828E-01, 4.6521620421E-01, 6.3946863350E-01],
	[1.3770000000E+04, 6.6382658407E+00, 5.6404499873E+00, 5.4961908488E-01, 4.6568495917E-01, 6.3960583024E-01],
	[1.3775000000E+04, 6.6415437182E+00, 5.6400613219E+00, 5.5025368300E-01, 4.6615395410E-01, 6.3974300315E-01],
	[1.3780000000E+04, 6.6448220239E+00, 5.6396728244E+00, 5.5088878286E-01, 4.6662318893E-01, 6.3988015223E-01],
	[1.3785000000E+04, 6.6481007575E+00, 5.6392844946E+00, 5.5152438467E-01, 4.6709266356E-01, 6.4001727745E-01],
	[1.3790000000E+04, 6.6513799191E+00, 5.6388963323E+00, 5.5216048865E-01, 4.6756237792E-01, 6.4015437880E-01],
	[1.3795000000E+04, 6.6546595084E+00, 5.6385083374E+00, 5.5279709502E-01, 4.6803233192E-01, 6.4029145627E-01],
	[1.3800000000E+04, 6.6579395255E+00, 5.6381205098E+00, 5.5343420398E-01, 4.6850252546E-01, 6.4042850983E-01],
	[1.3805000000E+04, 6.6612199702E+00, 5.6377328494E+00, 5.5407181575E-01, 4.6897295847E-01, 6.4056553948E-01],
	[1.3810000000E+04, 6.6645008425E+00, 5.6373453560E+00, 5.5470993055E-01, 4.6944363085E-01, 6.4070254519E-01],
	[1.3815000000E+04, 6.6677821421E+00, 5.6369580294E+00, 5.5534854859E-01, 4.6991454252E-01, 6.4083952696E-01],
	[1.3820000000E+04, 6.6710638690E+00, 5.6365708697E+00, 5.5598767008E-01, 4.7038569339E-01, 6.4097648476E-01],
	[1.3825000000E+04, 6.6743460232E+00, 5.6361838765E+00, 5.5662729524E-01, 4.7085708338E-01, 6.4111341858E-01],
	[1.3830000000E+04, 6.6776286045E+00, 5.6357970499E+00, 5.5726742428E-01, 4.7132871240E-01, 6.4125032840E-01],
	[1.3835000000E+04, 6.6809116128E+00, 5.6354103896E+00, 5.5790805742E-01, 4.7180058036E-01, 6.4138721422E-01],
	[1.3840000000E+04, 6.6841950480E+00, 5.6350238955E+00, 5.5854919487E-01, 4.7227268716E-01, 6.4152407601E-01],
	[1.3845000000E+04, 6.6874789101E+00, 5.6346375675E+00, 5.5919083684E-01, 4.7274503274E-01, 6.4166091375E-01],
	[1.3850000000E+04, 6.6907631988E+00, 5.6342514055E+00, 5.5983298355E-01, 4.7321761699E-01, 6.4179772744E-01],
	[1.3855000000E+04, 6.6940479142E+00, 5.6338654094E+00, 5.6047563521E-01, 4.7369043982E-01, 6.4193451706E-01],
	[1.3860000000E+04, 6.6973330561E+00, 5.6334795789E+00, 5.6111879204E-01, 4.7416350116E-01, 6.4207128259E-01],
	[1.3865000000E+04, 6.7006186245E+00, 5.6330939140E+00, 5.6176245425E-01, 4.7463680091E-01, 6.4220802401E-01],
	[1.3870000000E+04, 6.7039046192E+00, 5.6327084145E+00, 5.6240662206E-01, 4.7511033898E-01, 6.4234474132E-01],
	[1.3875000000E+04, 6.7071910401E+00, 5.6323230804E+00, 5.6305129568E-01, 4.7558411528E-01, 6.4248143449E-01],
	[1.3880000000E+04, 6.7104778871E+00, 5.6319379114E+00, 5.6369647533E-01, 4.7605812973E-01, 6.4261810351E-01],
	[1.3885000000E+04, 6.7137651602E+00, 5.6315529075E+00, 5.6434216121E-01, 4.7653238223E-01, 6.4275474837E-01],
	[1.3890000000E+04, 6.7170528592E+00, 5.6311680685E+00, 5.6498835355E-01, 4.7700687270E-01, 6.4289136905E-01],
	[1.3895000000E+04, 6.7203409840E+00, 5.6307833943E+00, 5.6563505255E-01, 4.7748160104E-01, 6.4302796554E-01],
	[1.3900000000E+04, 6.7236369948E+00, 5.6304059006E+00, 5.6628225844E-01, 4.7795665543E-01, 6.4316453781E-01],
	[1.3905000000E+04, 6.7269335697E+00, 5.6300286938E+00, 5.6692997142E-01, 4.7843194938E-01, 6.4330108587E-01],
	[1.3910000000E+04, 6.7302305749E+00, 5.6296516479E+00, 5.6757819171E-01, 4.7890748124E-01, 6.4343760968E-01],
	[1.3915000000E+04, 6.7335280102E+00, 5.6292747627E+00, 5.6822691953E-01, 4.7938325091E-01, 6.4357410923E-01],
	[1.3920000000E+04, 6.7368258756E+00, 5.6288980381E+00, 5.6887615509E-01, 4.7985925831E-01, 6.4371058452E-01],
	[1.3925000000E+04, 6.7401241710E+00, 5.6285214741E+00, 5.6952589860E-01, 4.8033550333E-01, 6.4384703552E-01],
	[1.3930000000E+04, 6.7434228962E+00, 5.6281450703E+00, 5.7017615029E-01, 4.8081198590E-01, 6.4398346223E-01],
	[1.3935000000E+04, 6.7467220511E+00, 5.6277688269E+00, 5.7082691035E-01, 4.8128870592E-01, 6.4411986462E-01],
	[1.3940000000E+04, 6.7500216358E+00, 5.6273927435E+00, 5.7147817902E-01, 4.8176566329E-01, 6.4425624268E-01],
	[1.3945000000E+04, 6.7533216499E+00, 5.6270168202E+00, 5.7212995649E-01, 4.8224285794E-01, 6.4439259639E-01],
	[1.3950000000E+04, 6.7566220936E+00, 5.6266410567E+00, 5.7278224299E-01, 4.8272028977E-01, 6.4452892575E-01],
	[1.3955000000E+04, 6.7599229666E+00, 5.6262654529E+00, 5.7343503874E-01, 4.8319795869E-01, 6.4466523073E-01],
	[1.3960000000E+04, 6.7632242688E+00, 5.6258900087E+00, 5.7408834394E-01, 4.8367586461E-01, 6.4480151133E-01],
	[1.3965000000E+04, 6.7665260003E+00, 5.6255147241E+00, 5.7474215881E-01, 4.8415400743E-01, 6.4493776752E-01],
	[1.3970000000E+04, 6.7698281608E+00, 5.6251395988E+00, 5.7539648357E-01, 4.8463238706E-01, 6.4507399929E-01],
	[1.3975000000E+04, 6.7731307502E+00, 5.6247646327E+00, 5.7605131842E-01, 4.8511100342E-01, 6.4521020663E-01],
	[1.3980000000E+04, 6.7764337686E+00, 5.6243898258E+00, 5.7670666359E-01, 4.8558985641E-01, 6.4534638953E-01],
	[1.3985000000E+04, 6.7797372157E+00, 5.6240151778E+00, 5.7736251929E-01, 4.8606894594E-01, 6.4548254796E-01],
	[1.3990000000E+04, 6.7830410915E+00, 5.6236406887E+00, 5.7801888573E-01, 4.8654827192E-01, 6.4561868192E-01],
	[1.3995000000E+04, 6.7863453959E+00, 5.6232663583E+00, 5.7867576314E-01, 4.8702783425E-01, 6.4575479139E-01],
	[1.4000000000E+04, 6.7896501288E+00, 5.6228921866E+00, 5.7933315171E-01, 4.8750763285E-01, 6.4589087635E-01],
	[1.4005000000E+04, 6.7929552900E+00, 5.6225181734E+00, 5.7999105167E-01, 4.8798766761E-01, 6.4602693679E-01],
	[1.4010000000E+04, 6.7962608796E+00, 5.6221443185E+00, 5.8064946323E-01, 4.8846793845E-01, 6.4616297270E-01],
	[1.4015000000E+04, 6.7995668973E+00, 5.6217706219E+00, 5.8130838661E-01, 4.8894844528E-01, 6.4629898405E-01],
	[1.4020000000E+04, 6.8028733431E+00, 5.6213970833E+00, 5.8196782203E-01, 4.8942918800E-01, 6.4643497085E-01],
	[1.4025000000E+04, 6.8061802170E+00, 5.6210237028E+00, 5.8262776969E-01, 4.8991016651E-01, 6.4657093307E-01],
	[1.4030000000E+04, 6.8094875187E+00, 5.6206504802E+00, 5.8328822981E-01, 4.9039138073E-01, 6.4670687070E-01],
	[1.4035000000E+04, 6.8127952482E+00, 5.6202774153E+00, 5.8394920260E-01, 4.9087283056E-01, 6.4684278372E-01],
	[1.4040000000E+04, 6.8161034054E+00, 5.6199045081E+00, 5.8461068829E-01, 4.9135451591E-01, 6.4697867212E-01],
	[1.4045000000E+04, 6.8194119903E+00, 5.6195317583E+00, 5.8527268708E-01, 4.9183643669E-01, 6.4711453589E-01],
	[1.4050000000E+04, 6.8227210026E+00, 5.6191591660E+00, 5.8593519919E-01, 4.9231859279E-01, 6.4725037501E-01],
	[1.4055000000E+04, 6.8260304424E+00, 5.6187867309E+00, 5.8659822484E-01, 4.9280098413E-01, 6.4738618946E-01],
	[1.4060000000E+04, 6.8293403095E+00, 5.6184144529E+00, 5.8726176424E-01, 4.9328361061E-01, 6.4752197924E-01],
	[1.4065000000E+04, 6.8326506038E+00, 5.6180423320E+00, 5.8792581760E-01, 4.9376647213E-01, 6.4765774433E-01],
	[1.4070000000E+04, 6.8359613252E+00, 5.6176703679E+00, 5.8859038514E-01, 4.9424956861E-01, 6.4779348471E-01],
	[1.4075000000E+04, 6.8392724737E+00, 5.6172985607E+00, 5.8925546708E-01, 4.9473289994E-01, 6.4792920038E-01],
	[1.4080000000E+04, 6.8425840490E+00, 5.6169269101E+00, 5.8992106362E-01, 4.9521646604E-01, 6.4806489131E-01],
	[1.4085000000E+04, 6.8458960513E+00, 5.6165554160E+00, 5.9058717499E-01, 4.9570026681E-01, 6.4820055746E-01],
	[1.4090000000E+04, 6.8492084802E+00, 5.6161840783E+00, 5.9125380140E-01, 4.9618430214E-01, 6.4833619880E-01],
	[1.4095000000E+04, 6.8525213358E+00, 5.6158128969E+00, 5.9192094306E-01, 4.9666857195E-01, 6.4847181530E-01],
	[1.4100000000E+04, 6.8558346180E+00, 5.6154418717E+00, 5.9258860019E-01, 4.9715307615E-01, 6.4860740694E-01],
	[1.4105000000E+04, 6.8591483266E+00, 5.6150710025E+00, 5.9325677301E-01, 4.9763781463E-01, 6.4874297371E-01],
	[1.4110000000E+04, 6.8624624615E+00, 5.6147002893E+00, 5.9392546172E-01, 4.9812278729E-01, 6.4887851558E-01],
	[1.4115000000E+04, 6.8657770227E+00, 5.6143297318E+00, 5.9459466655E-01, 4.9860799405E-01, 6.4901403253E-01],
	[1.4120000000E+04, 6.8690939685E+00, 5.6139610366E+00, 5.9526438770E-01, 4.9909345864E-01, 6.4914952454E-01],
	[1.4125000000E+04, 6.8724174127E+00, 5.6135977835E+00, 5.9593462540E-01, 4.9957923116E-01, 6.4928499159E-01],
	[1.4130000000E+04, 6.8757412878E+00, 5.6132346824E+00, 5.9660537986E-01, 5.0006523779E-01, 6.4942043366E-01],
	[1.4135000000E+04, 6.8790655936E+00, 5.6128717332E+00, 5.9727665130E-01, 5.0055147844E-01, 6.4955585073E-01],
	[1.4140000000E+04, 6.8823903301E+00, 5.6125089358E+00, 5.9794843992E-01, 5.0103795302E-01, 6.4969124278E-01],
	[1.4145000000E+04, 6.8857154973E+00, 5.6121462902E+00, 5.9862074594E-01, 5.0152466143E-01, 6.4982660978E-01],
	[1.4150000000E+04, 6.8890410949E+00, 5.6117837961E+00, 5.9929356958E-01, 5.0201160356E-01, 6.4996195173E-01],
	[1.4155000000E+04, 6.8923671229E+00, 5.6114214535E+00, 5.9996691106E-01, 5.0249877933E-01, 6.5009726860E-01],
	[1.4160000000E+04, 6.8956935812E+00, 5.6110592623E+00, 6.0064077059E-01, 5.0298618864E-01, 6.5023256037E-01],
	[1.4165000000E+04, 6.8990204698E+00, 5.6106972222E+00, 6.0131514838E-01, 5.0347383138E-01, 6.5036782702E-01],
	[1.4170000000E+04, 6.9023477884E+00, 5.6103353334E+00, 6.0199004465E-01, 5.0396170747E-01, 6.5050306852E-01],
	[1.4175000000E+04, 6.9056755371E+00, 5.6099735955E+00, 6.0266545961E-01, 5.0444981680E-01, 6.5063828487E-01],
	[1.4180000000E+04, 6.9090037156E+00, 5.6096120085E+00, 6.0334139349E-01, 5.0493815928E-01, 6.5077347603E-01],
	[1.4185000000E+04, 6.9123323240E+00, 5.6092505722E+00, 6.0401784649E-01, 5.0542673481E-01, 6.5090864200E-01],
	[1.4190000000E+04, 6.9156613621E+00, 5.6088892866E+00, 6.0469481882E-01, 5.0591554329E-01, 6.5104378274E-01],
	[1.4195000000E+04, 6.9189908299E+00, 5.6085281516E+00, 6.0537231072E-01, 5.0640458463E-01, 6.5117889825E-01],
	[1.4200000000E+04, 6.9223207272E+00, 5.6081671670E+00, 6.0605032238E-01, 5.0689385872E-01, 6.5131398849E-01],
	[1.4205000000E+04, 6.9256510539E+00, 5.6078063327E+00, 6.0672885403E-01, 5.0738336546E-01, 6.5144905346E-01],
	[1.4210000000E+04, 6.9289818100E+00, 5.6074456486E+00, 6.0740790588E-01, 5.0787310477E-01, 6.5158409312E-01],
	[1.4215000000E+04, 6.9323129953E+00, 5.6070851145E+00, 6.0808747814E-01, 5.0836307654E-01, 6.5171910747E-01],
	[1.4220000000E+04, 6.9356446097E+00, 5.6067247304E+00, 6.0876757104E-01, 5.0885328066E-01, 6.5185409647E-01],
	[1.4225000000E+04, 6.9389766533E+00, 5.6063644962E+00, 6.0944818478E-01, 5.0934371705E-01, 6.5198906012E-01],
	[1.4230000000E+04, 6.9423091257E+00, 5.6060044117E+00, 6.1012931958E-01, 5.0983438560E-01, 6.5212399840E-01],
	[1.4235000000E+04, 6.9456420271E+00, 5.6056444768E+00, 6.1081097566E-01, 5.1032528621E-01, 6.5225891127E-01],
	[1.4240000000E+04, 6.9489753572E+00, 5.6052846914E+00, 6.1149315323E-01, 5.1081641879E-01, 6.5239379873E-01],
	[1.4245000000E+04, 6.9523091160E+00, 5.6049250554E+00, 6.1217585251E-01, 5.1130778324E-01, 6.5252866075E-01],
	[1.4250000000E+04, 6.9556433033E+00, 5.6045655687E+00, 6.1285907371E-01, 5.1179937944E-01, 6.5266349732E-01],
	[1.4255000000E+04, 6.9589779192E+00, 5.6042062311E+00, 6.1354281705E-01, 5.1229120731E-01, 6.5279830841E-01],
	[1.4260000000E+04, 6.9623129634E+00, 5.6038470426E+00, 6.1422708275E-01, 5.1278326675E-01, 6.5293309400E-01],
	[1.4265000000E+04, 6.9656484359E+00, 5.6034880030E+00, 6.1491187101E-01, 5.1327555765E-01, 6.5306785409E-01],
	[1.4270000000E+04, 6.9689843366E+00, 5.6031291122E+00, 6.1559718206E-01, 5.1376807992E-01, 6.5320258864E-01],
	[1.4275000000E+04, 6.9723206655E+00, 5.6027703701E+00, 6.1628301610E-01, 5.1426083345E-01, 6.5333729764E-01],
	[1.4280000000E+04, 6.9756574223E+00, 5.6024117766E+00, 6.1696937336E-01, 5.1475381814E-01, 6.5347198106E-01],
	[1.4285000000E+04, 6.9789946070E+00, 5.6020533316E+00, 6.1765625405E-01, 5.1524703389E-01, 6.5360663890E-01],
	[1.4290000000E+04, 6.9823322196E+00, 5.6016950349E+00, 6.1834365839E-01, 5.1574048060E-01, 6.5374127112E-01],
	[1.4295000000E+04, 6.9856702599E+00, 5.6013368865E+00, 6.1903158659E-01, 5.1623415818E-01, 6.5387587772E-01],
	[1.4300000000E+04, 6.9890087278E+00, 5.6009788863E+00, 6.1972003886E-01, 5.1672806651E-01, 6.5401045867E-01],
	[1.4305000000E+04, 6.9923476232E+00, 5.6006210340E+00, 6.2040901542E-01, 5.1722220550E-01, 6.5414501395E-01],
	[1.4310000000E+04, 6.9956869461E+00, 5.6002633297E+00, 6.2109851650E-01, 5.1771657504E-01, 6.5427954355E-01],
	[1.4315000000E+04, 6.9990266963E+00, 5.5999057731E+00, 6.2178854229E-01, 5.1821117504E-01, 6.5441404744E-01],
	[1.4320000000E+04, 7.0023668738E+00, 5.5995483643E+00, 6.2247909303E-01, 5.1870600539E-01, 6.5454852561E-01],
	[1.4325000000E+04, 7.0057074784E+00, 5.5991911030E+00, 6.2317016892E-01, 5.1920106599E-01, 6.5468297804E-01],
	[1.4330000000E+04, 7.0090485101E+00, 5.5988339891E+00, 6.2386177017E-01, 5.1969635674E-01, 6.5481740470E-01],
	[1.4335000000E+04, 7.0123899687E+00, 5.5984770226E+00, 6.2455389702E-01, 5.2019187753E-01, 6.5495180558E-01],
	[1.4340000000E+04, 7.0157318542E+00, 5.5981202034E+00, 6.2524654966E-01, 5.2068762826E-01, 6.5508618067E-01],
	[1.4345000000E+04, 7.0190741665E+00, 5.5977635313E+00, 6.2593972832E-01, 5.2118360883E-01, 6.5522052994E-01],
	[1.4350000000E+04, 7.0224235571E+00, 5.5974123856E+00, 6.2663343321E-01, 5.2167990258E-01, 6.5535485337E-01],
	[1.4355000000E+04, 7.0257751970E+00, 5.5970628542E+00, 6.2732766455E-01, 5.2217644906E-01, 6.5548915094E-01],
	[1.4360000000E+04, 7.0291272684E+00, 5.5967134665E+00, 6.2802242255E-01, 5.2267322540E-01, 6.5562342264E-01],
	[1.4365000000E+04, 7.0324797714E+00, 5.5963642221E+00, 6.2871770743E-01, 5.2317023150E-01, 6.5575766845E-01],
	[1.4370000000E+04, 7.0358327059E+00, 5.5960151211E+00, 6.2941351940E-01, 5.2366746726E-01, 6.5589188835E-01],
	[1.4375000000E+04, 7.0391860716E+00, 5.5956661633E+00, 6.3010985869E-01, 5.2416493257E-01, 6.5602608232E-01],
	[1.4380000000E+04, 7.0425398686E+00, 5.5953173485E+00, 6.3080672550E-01, 5.2466262733E-01, 6.5616025034E-01],
	[1.4385000000E+04, 7.0458940967E+00, 5.5949686768E+00, 6.3150412005E-01, 5.2516055143E-01, 6.5629439239E-01],
	[1.4390000000E+04, 7.0492487559E+00, 5.5946201480E+00, 6.3220204255E-01, 5.2565870478E-01, 6.5642850846E-01],
	[1.4395000000E+04, 7.0526038461E+00, 5.5942717620E+00, 6.3290049323E-01, 5.2615708727E-01, 6.5656259852E-01],
	[1.4400000000E+04, 7.0559593670E+00, 5.5939235186E+00, 6.3359947230E-01, 5.2665569879E-01, 6.5669666257E-01],
	[1.4405000000E+04, 7.0593153188E+00, 5.5935754178E+00, 6.3429897997E-01, 5.2715453925E-01, 6.5683070057E-01],
	[1.4410000000E+04, 7.0626717012E+00, 5.5932274594E+00, 6.3499901646E-01, 5.2765360853E-01, 6.5696471252E-01],
	[1.4415000000E+04, 7.0660285142E+00, 5.5928796434E+00, 6.3569958199E-01, 5.2815290653E-01, 6.5709869838E-01],
	[1.4420000000E+04, 7.0693857577E+00, 5.5925319696E+00, 6.3640067676E-01, 5.2865243316E-01, 6.5723265816E-01],
	[1.4425000000E+04, 7.0727434316E+00, 5.5921844380E+00, 6.3710230101E-01, 5.2915218829E-01, 6.5736659182E-01],
	[1.4430000000E+04, 7.0761015358E+00, 5.5918370484E+00, 6.3780445493E-01, 5.2965217184E-01, 6.5750049935E-01],
	[1.4435000000E+04, 7.0794600702E+00, 5.5914898007E+00, 6.3850713876E-01, 5.3015238369E-01, 6.5763438073E-01],
	[1.4440000000E+04, 7.0828190346E+00, 5.5911426948E+00, 6.3921035270E-01, 5.3065282374E-01, 6.5776823594E-01],
	[1.4445000000E+04, 7.0861784291E+00, 5.5907957306E+00, 6.3991409697E-01, 5.3115349188E-01, 6.5790206497E-01],
	[1.4450000000E+04, 7.0895382535E+00, 5.5904489081E+00, 6.4061837178E-01, 5.3165438801E-01, 6.5803586779E-01],
	[1.4455000000E+04, 7.0928985078E+00, 5.5901022270E+00, 6.4132317736E-01, 5.3215551203E-01, 6.5816964439E-01],
	[1.4460000000E+04, 7.0962591917E+00, 5.5897556873E+00, 6.4202851391E-01, 5.3265686382E-01, 6.5830339475E-01],
	[1.4465000000E+04, 7.0996203053E+00, 5.5894092889E+00, 6.4273438166E-01, 5.3315844329E-01, 6.5843711886E-01],
	[1.4470000000E+04, 7.1029818485E+00, 5.5890630316E+00, 6.4344078082E-01, 5.3366025032E-01, 6.5857081669E-01],
	[1.4475000000E+04, 7.1063438211E+00, 5.5887169154E+00, 6.4414771160E-01, 5.3416228481E-01, 6.5870448823E-01],
	[1.4480000000E+04, 7.1097062230E+00, 5.5883709402E+00, 6.4485517422E-01, 5.3466454665E-01, 6.5883813345E-01],
	[1.4485000000E+04, 7.1130690543E+00, 5.5880251058E+00, 6.4556316890E-01, 5.3516703574E-01, 6.5897175235E-01],
	[1.4490000000E+04, 7.1164323146E+00, 5.5876794122E+00, 6.4627169585E-01, 5.3566975198E-01, 6.5910534490E-01],
	[1.4495000000E+04, 7.1197960041E+00, 5.5873338592E+00, 6.4698075529E-01, 5.3617269524E-01, 6.5923891109E-01],
	[1.4500000000E+04, 7.1231601226E+00, 5.5869884468E+00, 6.4769034744E-01, 5.3667586544E-01, 6.5937245089E-01],
	[1.4505000000E+04, 7.1265246699E+00, 5.5866431747E+00, 6.4840047251E-01, 5.3717926245E-01, 6.5950596430E-01],
	[1.4510000000E+04, 7.1298896460E+00, 5.5862980430E+00, 6.4911113071E-01, 5.3768288618E-01, 6.5963945129E-01],
	[1.4515000000E+04, 7.1332550509E+00, 5.5859530516E+00, 6.4982232227E-01, 5.3818673651E-01, 6.5977291184E-01],
	[1.4520000000E+04, 7.1366208843E+00, 5.5856082002E+00, 6.5053404739E-01, 5.3869081334E-01, 6.5990634594E-01],
	[1.4525000000E+04, 7.1399871463E+00, 5.5852634888E+00, 6.5124630631E-01, 5.3919511656E-01, 6.6003975357E-01],
	[1.4530000000E+04, 7.1433538367E+00, 5.5849189174E+00, 6.5195909922E-01, 5.3969964607E-01, 6.6017313472E-01],
	[1.4535000000E+04, 7.1467209554E+00, 5.5845744857E+00, 6.5267242634E-01, 5.4020440175E-01, 6.6030648936E-01],
	[1.4540000000E+04, 7.1500885024E+00, 5.5842301938E+00, 6.5338628791E-01, 5.4070938349E-01, 6.6043981748E-01],
	[1.4545000000E+04, 7.1534564775E+00, 5.5838860414E+00, 6.5410068412E-01, 5.4121459120E-01, 6.6057311906E-01],
	[1.4550000000E+04, 7.1568248806E+00, 5.5835420285E+00, 6.5481561519E-01, 5.4172002476E-01, 6.6070639408E-01],
	[1.4555000000E+04, 7.1601937117E+00, 5.5831981550E+00, 6.5553108135E-01, 5.4222568406E-01, 6.6083964253E-01],
	[1.4560000000E+04, 7.1635629707E+00, 5.5828544208E+00, 6.5624708280E-01, 5.4273156899E-01, 6.6097286439E-01],
	[1.4565000000E+04, 7.1669326575E+00, 5.5825108257E+00, 6.5696361977E-01, 5.4323767945E-01, 6.6110605964E-01],
	[1.4570000000E+04, 7.1703027719E+00, 5.5821673697E+00, 6.5768069247E-01, 5.4374401532E-01, 6.6123922826E-01],
	[1.4575000000E+04, 7.1736733140E+00, 5.5818240527E+00, 6.5839830111E-01, 5.4425057650E-01, 6.6137237024E-01],
	[1.4580000000E+04, 7.1770495871E+00, 5.5814848656E+00, 6.5911644591E-01, 5.4475743146E-01, 6.6150548556E-01],
	[1.4585000000E+04, 7.1804299036E+00, 5.5811485327E+00, 6.5983512710E-01, 5.4526455848E-01, 6.6163857420E-01],
	[1.4590000000E+04, 7.1838106527E+00, 5.5808123354E+00, 6.6055434487E-01, 5.4577191082E-01, 6.6177163615E-01],
	[1.4595000000E+04, 7.1871918344E+00, 5.5804762735E+00, 6.6127409946E-01, 5.4627948839E-01, 6.6190467139E-01],
	[1.4600000000E+04, 7.1905734485E+00, 5.5801403469E+00, 6.6199439107E-01, 5.4678729107E-01, 6.6203767990E-01],
	[1.4605000000E+04, 7.1939554950E+00, 5.5798045555E+00, 6.6271521993E-01, 5.4729531874E-01, 6.6217066167E-01],
	[1.4610000000E+04, 7.1973379738E+00, 5.5794688993E+00, 6.6343658625E-01, 5.4780357131E-01, 6.6230361667E-01],
	[1.4615000000E+04, 7.2007208847E+00, 5.5791333781E+00, 6.6415849024E-01, 5.4831204867E-01, 6.6243654489E-01],
	[1.4620000000E+04, 7.2041042277E+00, 5.5787979919E+00, 6.6488093212E-01, 5.4882075069E-01, 6.6256944632E-01],
	[1.4625000000E+04, 7.2074880028E+00, 5.5784627405E+00, 6.6560391211E-01, 5.4932967727E-01, 6.6270232094E-01],
	[1.4630000000E+04, 7.2108722097E+00, 5.5781276238E+00, 6.6632743043E-01, 5.4983882831E-01, 6.6283516872E-01],
	[1.4635000000E+04, 7.2142568484E+00, 5.5777926417E+00, 6.6705148728E-01, 5.5034820369E-01, 6.6296798966E-01],
	[1.4640000000E+04, 7.2176419188E+00, 5.5774577942E+00, 6.6777608290E-01, 5.5085780330E-01, 6.6310078374E-01],
	[1.4645000000E+04, 7.2210274209E+00, 5.5771230811E+00, 6.6850121748E-01, 5.5136762703E-01, 6.6323355094E-01],
	[1.4650000000E+04, 7.2244133545E+00, 5.5767885024E+00, 6.6922689126E-01, 5.5187767477E-01, 6.6336629124E-01],
	[1.4655000000E+04, 7.2277997195E+00, 5.5764540579E+00, 6.6995310444E-01, 5.5238794641E-01, 6.6349900463E-01],
	[1.4660000000E+04, 7.2311865159E+00, 5.5761197475E+00, 6.7067985724E-01, 5.5289844184E-01, 6.6363169109E-01],
	[1.4665000000E+04, 7.2345737435E+00, 5.5757855711E+00, 6.7140714988E-01, 5.5340916094E-01, 6.6376435060E-01],
	[1.4670000000E+04, 7.2379614023E+00, 5.5754515287E+00, 6.7213498258E-01, 5.5392010362E-01, 6.6389698315E-01],
	[1.4675000000E+04, 7.2413494921E+00, 5.5751176201E+00, 6.7286335555E-01, 5.5443126974E-01, 6.6402958872E-01],
	[1.4680000000E+04, 7.2447380129E+00, 5.5747838453E+00, 6.7359226901E-01, 5.5494265921E-01, 6.6416216730E-01],
	[1.4685000000E+04, 7.2481269647E+00, 5.5744502041E+00, 6.7432172317E-01, 5.5545427191E-01, 6.6429471886E-01],
	[1.4690000000E+04, 7.2515163472E+00, 5.5741166964E+00, 6.7505171825E-01, 5.5596610773E-01, 6.6442724339E-01],
	[1.4695000000E+04, 7.2549061604E+00, 5.5737833221E+00, 6.7578225446E-01, 5.5647816655E-01, 6.6455974088E-01],
	[1.4700000000E+04, 7.2582964042E+00, 5.5734500812E+00, 6.7651333204E-01, 5.5699044827E-01, 6.6469221131E-01],
	[1.4705000000E+04, 7.2616870785E+00, 5.5731169736E+00, 6.7724495118E-01, 5.5750295278E-01, 6.6482465467E-01],
	[1.4710000000E+04, 7.2650781833E+00, 5.5727839991E+00, 6.7797711211E-01, 5.5801567995E-01, 6.6495707092E-01],
	[1.4715000000E+04, 7.2684697184E+00, 5.5724511576E+00, 6.7870981504E-01, 5.5852862968E-01, 6.6508946007E-01],
	[1.4720000000E+04, 7.2718616837E+00, 5.5721184491E+00, 6.7944306019E-01, 5.5904180186E-01, 6.6522182209E-01],
	[1.4725000000E+04, 7.2752540792E+00, 5.5717858734E+00, 6.8017684778E-01, 5.5955519637E-01, 6.6535415697E-01],
	[1.4730000000E+04, 7.2786469047E+00, 5.5714534305E+00, 6.8091117802E-01, 5.6006881310E-01, 6.6548646470E-01],
	[1.4735000000E+04, 7.2820401602E+00, 5.5711211202E+00, 6.8164605113E-01, 5.6058265193E-01, 6.6561874524E-01],
	[1.4740000000E+04, 7.2854338456E+00, 5.5707889425E+00, 6.8238146732E-01, 5.6109671276E-01, 6.6575099860E-01],
	[1.4745000000E+04, 7.2888279608E+00, 5.5704568972E+00, 6.8311742682E-01, 5.6161099547E-01, 6.6588322475E-01],
	[1.4750000000E+04, 7.2922225056E+00, 5.5701249843E+00, 6.8385392983E-01, 5.6212549994E-01, 6.6601542368E-01],
	[1.4755000000E+04, 7.2956174801E+00, 5.5697932037E+00, 6.8459097659E-01, 5.6264022607E-01, 6.6614759536E-01],
	[1.4760000000E+04, 7.2990128840E+00, 5.5694615552E+00, 6.8532856729E-01, 5.6315517373E-01, 6.6627973980E-01],
	[1.4765000000E+04, 7.3024087174E+00, 5.5691300388E+00, 6.8606670216E-01, 5.6367034282E-01, 6.6641185696E-01],
	[1.4770000000E+04, 7.3058049802E+00, 5.5687986544E+00, 6.8680538142E-01, 5.6418573322E-01, 6.6654394684E-01],
	[1.4775000000E+04, 7.3092016721E+00, 5.5684674018E+00, 6.8754460528E-01, 5.6470134482E-01, 6.6667600942E-01],
	[1.4780000000E+04, 7.3125987932E+00, 5.5681362810E+00, 6.8828437396E-01, 5.6521717749E-01, 6.6680804467E-01],
	[1.4785000000E+04, 7.3159963434E+00, 5.5678052919E+00, 6.8902468767E-01, 5.6573323114E-01, 6.6694005260E-01],
	[1.4790000000E+04, 7.3193943225E+00, 5.5674744343E+00, 6.8976554664E-01, 5.6624950563E-01, 6.6707203317E-01],
	[1.4795000000E+04, 7.3227927305E+00, 5.5671437082E+00, 6.9050695108E-01, 5.6676600087E-01, 6.6720398638E-01],
	[1.4800000000E+04, 7.3261915673E+00, 5.5668131136E+00, 6.9124890120E-01, 5.6728271672E-01, 6.6733591221E-01],
	[1.4805000000E+04, 7.3295908327E+00, 5.5664826502E+00, 6.9199139722E-01, 5.6779965309E-01, 6.6746781064E-01],
	[1.4810000000E+04, 7.3329905268E+00, 5.5661523180E+00, 6.9273443936E-01, 5.6831680984E-01, 6.6759968166E-01],
	[1.4815000000E+04, 7.3363968395E+00, 5.5658264593E+00, 6.9347802784E-01, 5.6883426945E-01, 6.6773152525E-01],
	[1.4820000000E+04, 7.3398067622E+00, 5.5655029578E+00, 6.9422216287E-01, 5.6935199189E-01, 6.6786334140E-01],
	[1.4825000000E+04, 7.3432171188E+00, 5.5651795842E+00, 6.9496684467E-01, 5.6986993476E-01, 6.6799513009E-01],
	[1.4830000000E+04, 7.3466279092E+00, 5.5648563385E+00, 6.9571207346E-01, 5.7038809792E-01, 6.6812689131E-01],
	[1.4835000000E+04, 7.3500391332E+00, 5.5645332205E+00, 6.9645784945E-01, 5.7090648127E-01, 6.6825862504E-01],
	[1.4840000000E+04, 7.3534507908E+00, 5.5642102301E+00, 6.9720417286E-01, 5.7142508468E-01, 6.6839033126E-01],
	[1.4845000000E+04, 7.3568628819E+00, 5.5638873673E+00, 6.9795104390E-01, 5.7194390805E-01, 6.6852200996E-01],
	[1.4850000000E+04, 7.3602754064E+00, 5.5635646319E+00, 6.9869846280E-01, 5.7246295125E-01, 6.6865366112E-01],
	[1.4855000000E+04, 7.3636883643E+00, 5.5632420238E+00, 6.9944642977E-01, 5.7298221418E-01, 6.6878528474E-01],
	[1.4860000000E+04, 7.3671017553E+00, 5.5629195431E+00, 7.0019494503E-01, 5.7350169670E-01, 6.6891688079E-01],
	[1.4865000000E+04, 7.3705155795E+00, 5.5625971895E+00, 7.0094400879E-01, 5.7402139872E-01, 6.6904844925E-01],
	[1.4870000000E+04, 7.3739298368E+00, 5.5622749630E+00, 7.0169362127E-01, 5.7454132011E-01, 6.6917999012E-01],
	[1.4875000000E+04, 7.3773445270E+00, 5.5619528634E+00, 7.0244378269E-01, 5.7506146076E-01, 6.6931150338E-01],
	[1.4880000000E+04, 7.3807596500E+00, 5.5616308908E+00, 7.0319449326E-01, 5.7558182054E-01, 6.6944298901E-01],
	[1.4885000000E+04, 7.3841752058E+00, 5.5613090450E+00, 7.0394575321E-01, 5.7610239935E-01, 6.6957444699E-01],
	[1.4890000000E+04, 7.3875911944E+00, 5.5609873259E+00, 7.0469756274E-01, 5.7662319706E-01, 6.6970587733E-01],
	[1.4895000000E+04, 7.3910076154E+00, 5.5606657333E+00, 7.0544992208E-01, 5.7714421356E-01, 6.6983727998E-01],
	[1.4900000000E+04, 7.3944244690E+00, 5.5603442674E+00, 7.0620283144E-01, 5.7766544873E-01, 6.6996865495E-01],
	[1.4905000000E+04, 7.3978417550E+00, 5.5600229278E+00, 7.0695629105E-01, 5.7818690245E-01, 6.7010000222E-01],
	[1.4910000000E+04, 7.4012594734E+00, 5.5597017146E+00, 7.0771030110E-01, 5.7870857461E-01, 6.7023132177E-01],
	[1.4915000000E+04, 7.4046776239E+00, 5.5593806276E+00, 7.0846486184E-01, 5.7923046509E-01, 6.7036261359E-01],
	[1.4920000000E+04, 7.4080962066E+00, 5.5590596668E+00, 7.0921997346E-01, 5.7975257377E-01, 6.7049387766E-01],
	[1.4925000000E+04, 7.4115152214E+00, 5.5587388321E+00, 7.0997563619E-01, 5.8027490053E-01, 6.7062511397E-01],
	[1.4930000000E+04, 7.4149346681E+00, 5.5584181233E+00, 7.1073185024E-01, 5.8079744525E-01, 6.7075632250E-01],
	[1.4935000000E+04, 7.4183545466E+00, 5.5580975404E+00, 7.1148861584E-01, 5.8132020782E-01, 6.7088750323E-01],
	[1.4940000000E+04, 7.4217748570E+00, 5.5577770833E+00, 7.1224593320E-01, 5.8184318812E-01, 6.7101865617E-01],
	[1.4945000000E+04, 7.4251955990E+00, 5.5574567519E+00, 7.1300380253E-01, 5.8236638603E-01, 6.7114978128E-01],
	[1.4950000000E+04, 7.4286167726E+00, 5.5571365461E+00, 7.1376222405E-01, 5.8288980143E-01, 6.7128087855E-01],
	[1.4955000000E+04, 7.4320383778E+00, 5.5568164658E+00, 7.1452119799E-01, 5.8341343420E-01, 6.7141194798E-01],
	[1.4960000000E+04, 7.4354604143E+00, 5.5564965109E+00, 7.1528072455E-01, 5.8393728423E-01, 6.7154298953E-01],
	[1.4965000000E+04, 7.4388828822E+00, 5.5561766814E+00, 7.1604080395E-01, 5.8446135139E-01, 6.7167400321E-01],
	[1.4970000000E+04, 7.4423057813E+00, 5.5558569771E+00, 7.1680143642E-01, 5.8498563556E-01, 6.7180498900E-01],
	[1.4975000000E+04, 7.4457291116E+00, 5.5555373979E+00, 7.1756262217E-01, 5.8551013664E-01, 6.7193594687E-01],
	[1.4980000000E+04, 7.4491528729E+00, 5.5552179438E+00, 7.1832436141E-01, 5.8603485448E-01, 6.7206687682E-01],
	[1.4985000000E+04, 7.4525770652E+00, 5.5548986147E+00, 7.1908665436E-01, 5.8655978899E-01, 6.7219777883E-01],
	[1.4990000000E+04, 7.4560016884E+00, 5.5545794105E+00, 7.1984950125E-01, 5.8708494003E-01, 6.7232865289E-01],
	[1.4995000000E+04, 7.4594267424E+00, 5.5542603310E+00, 7.2061290228E-01, 5.8761030749E-01, 6.7245949899E-01],
	[1.5000000000E+04, 7.4628522270E+00, 5.5539413763E+00, 7.2137685767E-01, 5.8813589124E-01, 6.7259031710E-01],
	[1.5005000000E+04, 7.4662781423E+00, 5.5536225461E+00, 7.2214338955E-01, 5.8866303470E-01, 6.7272110721E-01],
	[1.5010000000E+04, 7.4697044881E+00, 5.5533038405E+00, 7.2291047987E-01, 5.8919039575E-01, 6.7285186932E-01],
	[1.5015000000E+04, 7.4731312644E+00, 5.5529852593E+00, 7.2367812885E-01, 5.8971797426E-01, 6.7298260340E-01],
	[1.5020000000E+04, 7.4765584709E+00, 5.5526668024E+00, 7.2444633672E-01, 5.9024577011E-01, 6.7311330944E-01],
	[1.5025000000E+04, 7.4799861078E+00, 5.5523484698E+00, 7.2521510369E-01, 5.9077378319E-01, 6.7324398743E-01],
	[1.5030000000E+04, 7.4834141748E+00, 5.5520302614E+00, 7.2598442999E-01, 5.9130201338E-01, 6.7337463735E-01],
	[1.5035000000E+04, 7.4868426719E+00, 5.5517121770E+00, 7.2675431583E-01, 5.9183046054E-01, 6.7350525919E-01],
	[1.5040000000E+04, 7.4902715989E+00, 5.5513942166E+00, 7.2752476144E-01, 5.9235912456E-01, 6.7363585293E-01],
	[1.5045000000E+04, 7.4937009559E+00, 5.5510763800E+00, 7.2829576704E-01, 5.9288800532E-01, 6.7376641857E-01],
	[1.5050000000E+04, 7.4971307426E+00, 5.5507586673E+00, 7.2906733284E-01, 5.9341710269E-01, 6.7389695608E-01],
	[1.5055000000E+04, 7.5005705124E+00, 5.5504473349E+00, 7.2983945907E-01, 5.9394654811E-01, 6.7402746545E-01],
	[1.5060000000E+04, 7.5040110007E+00, 5.5501363087E+00, 7.3061214595E-01, 5.9447621418E-01, 6.7415794664E-01],
	[1.5065000000E+04, 7.5074519242E+00, 5.5498254032E+00, 7.3138539370E-01, 5.9500609689E-01, 6.7428839964E-01],
	[1.5070000000E+04, 7.5108932830E+00, 5.5495146183E+00, 7.3215920254E-01, 5.9553619612E-01, 6.7441882442E-01],
	[1.5075000000E+04, 7.5143350768E+00, 5.5492039539E+00, 7.3293357268E-01, 5.9606651174E-01, 6.7454922097E-01],
	[1.5080000000E+04, 7.5177773057E+00, 5.5488934098E+00, 7.3370850436E-01, 5.9659704364E-01, 6.7467958927E-01],
	[1.5085000000E+04, 7.5212199695E+00, 5.5485829861E+00, 7.3448399778E-01, 5.9712779169E-01, 6.7480992931E-01],
	[1.5090000000E+04, 7.5246630681E+00, 5.5482726827E+00, 7.3526005318E-01, 5.9765875576E-01, 6.7494024106E-01],
	[1.5095000000E+04, 7.5281066015E+00, 5.5479624993E+00, 7.3603667077E-01, 5.9818993575E-01, 6.7507052450E-01],
	[1.5100000000E+04, 7.5315505696E+00, 5.5476524361E+00, 7.3681385077E-01, 5.9872133151E-01, 6.7520077962E-01],
	[1.5105000000E+04, 7.5349949722E+00, 5.5473424928E+00, 7.3759159340E-01, 5.9925294294E-01, 6.7533100640E-01],
	[1.5110000000E+04, 7.5384398093E+00, 5.5470326694E+00, 7.3836989888E-01, 5.9978476991E-01, 6.7546120483E-01],
	[1.5115000000E+04, 7.5418850808E+00, 5.5467229658E+00, 7.3914876744E-01, 6.0031681229E-01, 6.7559137488E-01],
	[1.5120000000E+04, 7.5453307866E+00, 5.5464133819E+00, 7.3992819929E-01, 6.0084906996E-01, 6.7572151653E-01],
	[1.5125000000E+04, 7.5487769266E+00, 5.5461039176E+00, 7.4070819466E-01, 6.0138154280E-01, 6.7585162977E-01],
	[1.5130000000E+04, 7.5522235007E+00, 5.5457945729E+00, 7.4148875376E-01, 6.0191423068E-01, 6.7598171459E-01],
	[1.5135000000E+04, 7.5556705089E+00, 5.5454853476E+00, 7.4226987682E-01, 6.0244713348E-01, 6.7611177096E-01],
	[1.5140000000E+04, 7.5591179510E+00, 5.5451762417E+00, 7.4305156405E-01, 6.0298025109E-01, 6.7624179886E-01],
	[1.5145000000E+04, 7.5625658270E+00, 5.5448672551E+00, 7.4383381568E-01, 6.0351358336E-01, 6.7637179828E-01],
	[1.5150000000E+04, 7.5660141367E+00, 5.5445583877E+00, 7.4461663193E-01, 6.0404713018E-01, 6.7650176920E-01],
	[1.5155000000E+04, 7.5694628801E+00, 5.5442496394E+00, 7.4540001302E-01, 6.0458089143E-01, 6.7663171161E-01],
	[1.5160000000E+04, 7.5729120572E+00, 5.5439410102E+00, 7.4618395916E-01, 6.0511486698E-01, 6.7676162547E-01],
	[1.5165000000E+04, 7.5763616677E+00, 5.5436324999E+00, 7.4696847059E-01, 6.0564905671E-01, 6.7689151079E-01],
	[1.5170000000E+04, 7.5798117117E+00, 5.5433241084E+00, 7.4775354752E-01, 6.0618346049E-01, 6.7702136754E-01],
	[1.5175000000E+04, 7.5832621889E+00, 5.5430158358E+00, 7.4853919016E-01, 6.0671807819E-01, 6.7715119570E-01],
	[1.5180000000E+04, 7.5867130994E+00, 5.5427076818E+00, 7.4932539875E-01, 6.0725290970E-01, 6.7728099525E-01],
	[1.5185000000E+04, 7.5901644431E+00, 5.5423996464E+00, 7.5011217351E-01, 6.0778795488E-01, 6.7741076619E-01],
	[1.5190000000E+04, 7.5936162198E+00, 5.5420917296E+00, 7.5089951464E-01, 6.0832321362E-01, 6.7754050848E-01],
	[1.5195000000E+04, 7.5970684295E+00, 5.5417839311E+00, 7.5168742238E-01, 6.0885868578E-01, 6.7767022212E-01],
	[1.5200000000E+04, 7.6005210721E+00, 5.5414762511E+00, 7.5247589695E-01, 6.0939437125E-01, 6.7779990708E-01],
	[1.5205000000E+04, 7.6039741475E+00, 5.5411686893E+00, 7.5326493856E-01, 6.0993026989E-01, 6.7792956335E-01],
	[1.5210000000E+04, 7.6074276556E+00, 5.5408612457E+00, 7.5405454744E-01, 6.1046638158E-01, 6.7805919091E-01],
	[1.5215000000E+04, 7.6108815964E+00, 5.5405539201E+00, 7.5484472380E-01, 6.1100270619E-01, 6.7818878975E-01],
	[1.5220000000E+04, 7.6143359696E+00, 5.5402467126E+00, 7.5563546788E-01, 6.1153924361E-01, 6.7831835985E-01],
	[1.5225000000E+04, 7.6177907753E+00, 5.5399396231E+00, 7.5642677988E-01, 6.1207599370E-01, 6.7844790118E-01],
	[1.5230000000E+04, 7.6212460134E+00, 5.5396326514E+00, 7.5721866003E-01, 6.1261295633E-01, 6.7857741374E-01],
	[1.5235000000E+04, 7.6247016837E+00, 5.5393257974E+00, 7.5801110856E-01, 6.1315013138E-01, 6.7870689751E-01],
	[1.5240000000E+04, 7.6281577862E+00, 5.5390190611E+00, 7.5880412567E-01, 6.1368751873E-01, 6.7883635246E-01],
	[1.5245000000E+04, 7.6316143209E+00, 5.5387124424E+00, 7.5959771160E-01, 6.1422511825E-01, 6.7896577859E-01],
	[1.5250000000E+04, 7.6350712875E+00, 5.5384059413E+00, 7.6039186657E-01, 6.1476292980E-01, 6.7909517587E-01],
	[1.5255000000E+04, 7.6385286860E+00, 5.5380995575E+00, 7.6118659078E-01, 6.1530095327E-01, 6.7922454430E-01],
	[1.5260000000E+04, 7.6419865164E+00, 5.5377932911E+00, 7.6198188448E-01, 6.1583918853E-01, 6.7935388384E-01],
	[1.5265000000E+04, 7.6454447785E+00, 5.5374871420E+00, 7.6277774787E-01, 6.1637763545E-01, 6.7948319449E-01],
	[1.5270000000E+04, 7.6489034723E+00, 5.5371811100E+00, 7.6357418117E-01, 6.1691629390E-01, 6.7961247622E-01],
	[1.5275000000E+04, 7.6523625976E+00, 5.5368751952E+00, 7.6437118462E-01, 6.1745516375E-01, 6.7974172903E-01],
	[1.5280000000E+04, 7.6558221545E+00, 5.5365693973E+00, 7.6516875842E-01, 6.1799424488E-01, 6.7987095290E-01],
	[1.5285000000E+04, 7.6592821427E+00, 5.5362637164E+00, 7.6596690281E-01, 6.1853353716E-01, 6.8000014780E-01],
	[1.5290000000E+04, 7.6627425622E+00, 5.5359581523E+00, 7.6676561800E-01, 6.1907304047E-01, 6.8012931372E-01],
	[1.5295000000E+04, 7.6662087230E+00, 5.5356559576E+00, 7.6756490421E-01, 6.1961283011E-01, 6.8025845065E-01],
	[1.5300000000E+04, 7.6696803434E+00, 5.5353569549E+00, 7.6836476166E-01, 6.2015290220E-01, 6.8038755857E-01],
	[1.5305000000E+04, 7.6731524008E+00, 5.5350580660E+00, 7.6916519058E-01, 6.2069318534E-01, 6.8051663745E-01],
	[1.5310000000E+04, 7.6766248952E+00, 5.5347592908E+00, 7.6996619118E-01, 6.2123367940E-01, 6.8064568730E-01],
	[1.5315000000E+04, 7.6800978264E+00, 5.5344606294E+00, 7.7076776369E-01, 6.2177438426E-01, 6.8077470808E-01],
	[1.5320000000E+04, 7.6835711943E+00, 5.5341620815E+00, 7.7156990833E-01, 6.2231529979E-01, 6.8090369979E-01],
	[1.5325000000E+04, 7.6870449989E+00, 5.5338636471E+00, 7.7237262532E-01, 6.2285642586E-01, 6.8103266240E-01],
	[1.5330000000E+04, 7.6905192400E+00, 5.5335653262E+00, 7.7317591488E-01, 6.2339776233E-01, 6.8116159590E-01],
	[1.5335000000E+04, 7.6939939177E+00, 5.5332671187E+00, 7.7397977723E-01, 6.2393930909E-01, 6.8129050028E-01],
	[1.5340000000E+04, 7.6974690317E+00, 5.5329690244E+00, 7.7478421259E-01, 6.2448106601E-01, 6.8141937551E-01],
	[1.5345000000E+04, 7.7009445821E+00, 5.5326710433E+00, 7.7558922119E-01, 6.2502303295E-01, 6.8154822159E-01],
	[1.5350000000E+04, 7.7044205687E+00, 5.5323731753E+00, 7.7639480324E-01, 6.2556520978E-01, 6.8167703849E-01],
	[1.5355000000E+04, 7.7078969914E+00, 5.5320754204E+00, 7.7720095896E-01, 6.2610759639E-01, 6.8180582620E-01],
	[1.5360000000E+04, 7.7113738502E+00, 5.5317777784E+00, 7.7800768859E-01, 6.2665019263E-01, 6.8193458470E-01],
	[1.5365000000E+04, 7.7148511449E+00, 5.5314802493E+00, 7.7881499233E-01, 6.2719299839E-01, 6.8206331398E-01],
	[1.5370000000E+04, 7.7183288755E+00, 5.5311828331E+00, 7.7962287041E-01, 6.2773601352E-01, 6.8219201401E-01],
	[1.5375000000E+04, 7.7218070419E+00, 5.5308855295E+00, 7.8043132306E-01, 6.2827923791E-01, 6.8232068480E-01],
	[1.5380000000E+04, 7.7252856440E+00, 5.5305883386E+00, 7.8124035048E-01, 6.2882267142E-01, 6.8244932631E-01],
	[1.5385000000E+04, 7.7287646817E+00, 5.5302912602E+00, 7.8204995291E-01, 6.2936631392E-01, 6.8257793853E-01],
	[1.5390000000E+04, 7.7322441549E+00, 5.5299942943E+00, 7.8286013057E-01, 6.2991016529E-01, 6.8270652146E-01],
	[1.5395000000E+04, 7.7357240636E+00, 5.5296974408E+00, 7.8367088367E-01, 6.3045422538E-01, 6.8283507506E-01],
	[1.5400000000E+04, 7.7392044076E+00, 5.5294006997E+00, 7.8448221244E-01, 6.3099849409E-01, 6.8296359933E-01],
	[1.5405000000E+04, 7.7426851869E+00, 5.5291040708E+00, 7.8529411709E-01, 6.3154297126E-01, 6.8309209424E-01],
	[1.5410000000E+04, 7.7461664013E+00, 5.5288075540E+00, 7.8610659786E-01, 6.3208765678E-01, 6.8322055979E-01],
	[1.5415000000E+04, 7.7496480509E+00, 5.5285111494E+00, 7.8691965496E-01, 6.3263255051E-01, 6.8334899596E-01],
	[1.5420000000E+04, 7.7531301354E+00, 5.5282148567E+00, 7.8773328861E-01, 6.3317765232E-01, 6.8347740273E-01],
	[1.5425000000E+04, 7.7566126549E+00, 5.5279186760E+00, 7.8854749904E-01, 6.3372296208E-01, 6.8360578009E-01],
	[1.5430000000E+04, 7.7600956092E+00, 5.5276226071E+00, 7.8936228646E-01, 6.3426847966E-01, 6.8373412801E-01],
	[1.5435000000E+04, 7.7635789982E+00, 5.5273266500E+00, 7.9017765110E-01, 6.3481420494E-01, 6.8386244650E-01],
	[1.5440000000E+04, 7.7670628220E+00, 5.5270308046E+00, 7.9099359317E-01, 6.3536013777E-01, 6.8399073552E-01],
	[1.5445000000E+04, 7.7705470802E+00, 5.5267350709E+00, 7.9181011291E-01, 6.3590627803E-01, 6.8411899506E-01],
	[1.5450000000E+04, 7.7740317730E+00, 5.5264394486E+00, 7.9262721053E-01, 6.3645262559E-01, 6.8424722512E-01],
	[1.5455000000E+04, 7.7775169001E+00, 5.5261439378E+00, 7.9344488625E-01, 6.3699918031E-01, 6.8437542566E-01],
	[1.5460000000E+04, 7.7810024616E+00, 5.5258485384E+00, 7.9426314029E-01, 6.3754594207E-01, 6.8450359669E-01],
	[1.5465000000E+04, 7.7844884573E+00, 5.5255532503E+00, 7.9508197288E-01, 6.3809291073E-01, 6.8463173818E-01],
	[1.5470000000E+04, 7.7879748871E+00, 5.5252580735E+00, 7.9590138424E-01, 6.3864008615E-01, 6.8475985011E-01],
	[1.5475000000E+04, 7.7914617510E+00, 5.5249630077E+00, 7.9672137459E-01, 6.3918746822E-01, 6.8488793248E-01],
	[1.5480000000E+04, 7.7949490489E+00, 5.5246680531E+00, 7.9754194414E-01, 6.3973505680E-01, 6.8501598526E-01],
	[1.5485000000E+04, 7.7984367806E+00, 5.5243732094E+00, 7.9836309313E-01, 6.4028285175E-01, 6.8514400844E-01],
	[1.5490000000E+04, 7.8019249461E+00, 5.5240784767E+00, 7.9918482177E-01, 6.4083085294E-01, 6.8527200201E-01],
	[1.5495000000E+04, 7.8054135454E+00, 5.5237838548E+00, 8.0000713029E-01, 6.4137906024E-01, 6.8539996595E-01],
	[1.5500000000E+04, 7.8089025782E+00, 5.5234893436E+00, 8.0083001890E-01, 6.4192747352E-01, 6.8552790025E-01],
	[1.5505000000E+04, 7.8123920446E+00, 5.5231949432E+00, 8.0165348784E-01, 6.4247609265E-01, 6.8565580488E-01],
	[1.5510000000E+04, 7.8158819445E+00, 5.5229006533E+00, 8.0247753731E-01, 6.4302491748E-01, 6.8578367984E-01],
	[1.5515000000E+04, 7.8193722777E+00, 5.5226064740E+00, 8.0330216754E-01, 6.4357394790E-01, 6.8591152511E-01],
	[1.5520000000E+04, 7.8228630442E+00, 5.5223124051E+00, 8.0412737875E-01, 6.4412318376E-01, 6.8603934068E-01],
	[1.5525000000E+04, 7.8263542438E+00, 5.5220184466E+00, 8.0495317117E-01, 6.4467262494E-01, 6.8616712653E-01],
	[1.5530000000E+04, 7.8298458766E+00, 5.5217245984E+00, 8.0577954502E-01, 6.4522227130E-01, 6.8629488264E-01],
	[1.5535000000E+04, 7.8333379424E+00, 5.5214308604E+00, 8.0660650051E-01, 6.4577212270E-01, 6.8642260900E-01],
	[1.5540000000E+04, 7.8368334376E+00, 5.5211389521E+00, 8.0743403787E-01, 6.4632222297E-01, 6.8655030560E-01],
	[1.5545000000E+04, 7.8403372149E+00, 5.5208516541E+00, 8.0826215733E-01, 6.4687264334E-01, 6.8667797242E-01],
	[1.5550000000E+04, 7.8438414312E+00, 5.5205644636E+00, 8.0909085910E-01, 6.4742326880E-01, 6.8680560944E-01],
	[1.5555000000E+04, 7.8473460863E+00, 5.5202773802E+00, 8.0992014340E-01, 6.4797409921E-01, 6.8693321665E-01],
	[1.5560000000E+04, 7.8508511803E+00, 5.5199904041E+00, 8.1075001045E-01, 6.4852513442E-01, 6.8706079405E-01],
	[1.5565000000E+04, 7.8543567129E+00, 5.5197035350E+00, 8.1158046049E-01, 6.4907637432E-01, 6.8718834160E-01],
	[1.5570000000E+04, 7.8578626841E+00, 5.5194167730E+00, 8.1241149373E-01, 6.4962781877E-01, 6.8731585930E-01],
	[1.5575000000E+04, 7.8613690939E+00, 5.5191301180E+00, 8.1324311038E-01, 6.5017946763E-01, 6.8744334713E-01],
	[1.5580000000E+04, 7.8648759420E+00, 5.5188435699E+00, 8.1407531068E-01, 6.5073132077E-01, 6.8757080508E-01],
	[1.5585000000E+04, 7.8683832286E+00, 5.5185571285E+00, 8.1490809485E-01, 6.5128337805E-01, 6.8769823314E-01],
	[1.5590000000E+04, 7.8718909534E+00, 5.5182707939E+00, 8.1574146310E-01, 6.5183563934E-01, 6.8782563128E-01],
	[1.5595000000E+04, 7.8753991164E+00, 5.5179845660E+00, 8.1657541566E-01, 6.5238810452E-01, 6.8795299949E-01],
	[1.5600000000E+04, 7.8789077175E+00, 5.5176984447E+00, 8.1740995276E-01, 6.5294077343E-01, 6.8808033777E-01],
	[1.5605000000E+04, 7.8824167565E+00, 5.5174124299E+00, 8.1824507460E-01, 6.5349364596E-01, 6.8820764609E-01],
	[1.5610000000E+04, 7.8859262336E+00, 5.5171265215E+00, 8.1908078142E-01, 6.5404672195E-01, 6.8833492444E-01],
	[1.5615000000E+04, 7.8894361484E+00, 5.5168407195E+00, 8.1991707344E-01, 6.5460000129E-01, 6.8846217281E-01],
	[1.5620000000E+04, 7.8929465010E+00, 5.5165550238E+00, 8.2075395087E-01, 6.5515348383E-01, 6.8858939118E-01],
	[1.5625000000E+04, 7.8964572913E+00, 5.5162694344E+00, 8.2159141394E-01, 6.5570716944E-01, 6.8871657954E-01],
	[1.5630000000E+04, 7.8999685191E+00, 5.5159839511E+00, 8.2242946288E-01, 6.5626105799E-01, 6.8884373787E-01],
	[1.5635000000E+04, 7.9034801844E+00, 5.5156985738E+00, 8.2326809789E-01, 6.5681514933E-01, 6.8897086616E-01],
	[1.5640000000E+04, 7.9069922872E+00, 5.5154133026E+00, 8.2410731922E-01, 6.5736944334E-01, 6.8909796440E-01],
	[1.5645000000E+04, 7.9105048273E+00, 5.5151281373E+00, 8.2494712707E-01, 6.5792393988E-01, 6.8922503257E-01],
	[1.5650000000E+04, 7.9140178046E+00, 5.5148430779E+00, 8.2578752167E-01, 6.5847863881E-01, 6.8935207065E-01],
	[1.5655000000E+04, 7.9175312190E+00, 5.5145581242E+00, 8.2662850325E-01, 6.5903354000E-01, 6.8947907864E-01],
	[1.5660000000E+04, 7.9210450706E+00, 5.5142732763E+00, 8.2747007201E-01, 6.5958864331E-01, 6.8960605651E-01],
	[1.5665000000E+04, 7.9245593591E+00, 5.5139885340E+00, 8.2831222819E-01, 6.6014394861E-01, 6.8973300426E-01],
	[1.5670000000E+04, 7.9280740845E+00, 5.5137038972E+00, 8.2915497201E-01, 6.6069945575E-01, 6.8985992187E-01],
	[1.5675000000E+04, 7.9315892467E+00, 5.5134193660E+00, 8.2999830369E-01, 6.6125516461E-01, 6.8998680933E-01],
	[1.5680000000E+04, 7.9351048457E+00, 5.5131349402E+00, 8.3084222345E-01, 6.6181107505E-01, 6.9011366662E-01],
	[1.5685000000E+04, 7.9386208813E+00, 5.5128506197E+00, 8.3168673152E-01, 6.6236718693E-01, 6.9024049372E-01],
	[1.5690000000E+04, 7.9421373534E+00, 5.5125664045E+00, 8.3253182811E-01, 6.6292350012E-01, 6.9036729064E-01],
	[1.5695000000E+04, 7.9456542621E+00, 5.5122822945E+00, 8.3337751345E-01, 6.6348001447E-01, 6.9049405734E-01],
	[1.5700000000E+04, 7.9491716071E+00, 5.5119982897E+00, 8.3422378775E-01, 6.6403672985E-01, 6.9062079382E-01],
	[1.5705000000E+04, 7.9526893884E+00, 5.5117143899E+00, 8.3507065125E-01, 6.6459364613E-01, 6.9074750007E-01],
	[1.5710000000E+04, 7.9562076059E+00, 5.5114305950E+00, 8.3591810417E-01, 6.6515076317E-01, 6.9087417606E-01],
	[1.5715000000E+04, 7.9597262596E+00, 5.5111469051E+00, 8.3676614672E-01, 6.6570808083E-01, 6.9100082179E-01],
	[1.5720000000E+04, 7.9632453493E+00, 5.5108633201E+00, 8.3761477913E-01, 6.6626559897E-01, 6.9112743724E-01],
	[1.5725000000E+04, 7.9667648750E+00, 5.5105798398E+00, 8.3846400162E-01, 6.6682331746E-01, 6.9125402241E-01],
	[1.5730000000E+04, 7.9702848365E+00, 5.5102964642E+00, 8.3931381441E-01, 6.6738123616E-01, 6.9138057726E-01],
	[1.5735000000E+04, 7.9738052339E+00, 5.5100131932E+00, 8.4016421772E-01, 6.6793935493E-01, 6.9150710180E-01],
	[1.5740000000E+04, 7.9773260670E+00, 5.5097300268E+00, 8.4101521179E-01, 6.6849767363E-01, 6.9163359601E-01],
	[1.5745000000E+04, 7.9808473357E+00, 5.5094469649E+00, 8.4186679682E-01, 6.6905619214E-01, 6.9176005987E-01],
	[1.5750000000E+04, 7.9843690399E+00, 5.5091640074E+00, 8.4271897304E-01, 6.6961491029E-01, 6.9188649337E-01],
	[1.5755000000E+04, 7.9878911796E+00, 5.5088811542E+00, 8.4357174068E-01, 6.7017382797E-01, 6.9201289650E-01],
	[1.5760000000E+04, 7.9914137546E+00, 5.5085984053E+00, 8.4442509995E-01, 6.7073294504E-01, 6.9213926924E-01],
	[1.5765000000E+04, 7.9949367650E+00, 5.5083157606E+00, 8.4527905109E-01, 6.7129226134E-01, 6.9226561159E-01],
	[1.5770000000E+04, 7.9984602105E+00, 5.5080332200E+00, 8.4613359430E-01, 6.7185177676E-01, 6.9239192352E-01],
	[1.5775000000E+04, 8.0019840912E+00, 5.5077507834E+00, 8.4698872981E-01, 6.7241149114E-01, 6.9251820502E-01],
	[1.5780000000E+04, 8.0055084069E+00, 5.5074684509E+00, 8.4784445785E-01, 6.7297140435E-01, 6.9264445609E-01],
	[1.5785000000E+04, 8.0090331576E+00, 5.5071862222E+00, 8.4870077864E-01, 6.7353151625E-01, 6.9277067671E-01],
	[1.5790000000E+04, 8.0125611398E+00, 5.5069056033E+00, 8.4955769239E-01, 6.7409186906E-01, 6.9289686686E-01],
	[1.5795000000E+04, 8.0160981209E+00, 5.5066296957E+00, 8.5041519934E-01, 6.7465255021E-01, 6.9302302653E-01],
	[1.5800000000E+04, 8.0196355432E+00, 5.5063538892E+00, 8.5127329971E-01, 6.7521343010E-01, 6.9314915570E-01],
	[1.5805000000E+04, 8.0231734064E+00, 5.5060781838E+00, 8.5213199370E-01, 6.7577450858E-01, 6.9327525438E-01],
	[1.5810000000E+04, 8.0267117106E+00, 5.5058025794E+00, 8.5299128156E-01, 6.7633578551E-01, 6.9340132253E-01],
	[1.5815000000E+04, 8.0302504557E+00, 5.5055270759E+00, 8.5385116350E-01, 6.7689726076E-01, 6.9352736016E-01],
	[1.5820000000E+04, 8.0337896415E+00, 5.5052516733E+00, 8.5471163975E-01, 6.7745893418E-01, 6.9365336724E-01],
	[1.5825000000E+04, 8.0373292680E+00, 5.5049763715E+00, 8.5557271051E-01, 6.7802080564E-01, 6.9377934376E-01],
	[1.5830000000E+04, 8.0408693352E+00, 5.5047011704E+00, 8.5643437603E-01, 6.7858287500E-01, 6.9390528971E-01],
	[1.5835000000E+04, 8.0444098428E+00, 5.5044260700E+00, 8.5729663652E-01, 6.7914514211E-01, 6.9403120508E-01],
	[1.5840000000E+04, 8.0479507909E+00, 5.5041510702E+00, 8.5815949220E-01, 6.7970760685E-01, 6.9415708986E-01],
	[1.5845000000E+04, 8.0514921793E+00, 5.5038761709E+00, 8.5902294330E-01, 6.8027026906E-01, 6.9428294402E-01],
	[1.5850000000E+04, 8.0550340080E+00, 5.5036013721E+00, 8.5988699004E-01, 6.8083312862E-01, 6.9440876757E-01],
	[1.5855000000E+04, 8.0585762769E+00, 5.5033266736E+00, 8.6075163264E-01, 6.8139618537E-01, 6.9453456048E-01],
	[1.5860000000E+04, 8.0621189859E+00, 5.5030520755E+00, 8.6161687132E-01, 6.8195943919E-01, 6.9466032274E-01],
	[1.5865000000E+04, 8.0656621349E+00, 5.5027775776E+00, 8.6248270630E-01, 6.8252288993E-01, 6.9478605434E-01],
	[1.5870000000E+04, 8.0692057238E+00, 5.5025031799E+00, 8.6334913782E-01, 6.8308653745E-01, 6.9491175527E-01],
	[1.5875000000E+04, 8.0727497526E+00, 5.5022288824E+00, 8.6421616608E-01, 6.8365038160E-01, 6.9503742552E-01],
	[1.5880000000E+04, 8.0762942212E+00, 5.5019546848E+00, 8.6508379132E-01, 6.8421442226E-01, 6.9516306506E-01],
	[1.5885000000E+04, 8.0798391294E+00, 5.5016805873E+00, 8.6595201376E-01, 6.8477865929E-01, 6.9528867390E-01],
	[1.5890000000E+04, 8.0833844772E+00, 5.5014065896E+00, 8.6682083361E-01, 6.8534309253E-01, 6.9541425201E-01],
	[1.5895000000E+04, 8.0869302645E+00, 5.5011326918E+00, 8.6769025110E-01, 6.8590772185E-01, 6.9553979939E-01],
	[1.5900000000E+04, 8.0904764913E+00, 5.5008588938E+00, 8.6856026646E-01, 6.8647254710E-01, 6.9566531602E-01],
	[1.5905000000E+04, 8.0940231574E+00, 5.5005851955E+00, 8.6943087991E-01, 6.8703756816E-01, 6.9579080189E-01],
	[1.5910000000E+04, 8.0975702628E+00, 5.5003115968E+00, 8.7030209166E-01, 6.8760278487E-01, 6.9591625699E-01],
	[1.5915000000E+04, 8.1011178073E+00, 5.5000380977E+00, 8.7117390194E-01, 6.8816819710E-01, 6.9604168130E-01],
	[1.5920000000E+04, 8.1046657909E+00, 5.4997646981E+00, 8.7204631098E-01, 6.8873380471E-01, 6.9616707482E-01],
	[1.5925000000E+04, 8.1082142136E+00, 5.4994913979E+00, 8.7291931900E-01, 6.8929960755E-01, 6.9629243752E-01],
	[1.5930000000E+04, 8.1117630751E+00, 5.4992181971E+00, 8.7379292621E-01, 6.8986560548E-01, 6.9641776940E-01],
	[1.5935000000E+04, 8.1153123755E+00, 5.4989450956E+00, 8.7466713285E-01, 6.9043179836E-01, 6.9654307045E-01],
	[1.5940000000E+04, 8.1188621147E+00, 5.4986720934E+00, 8.7554193913E-01, 6.9099818605E-01, 6.9666834065E-01],
	[1.5945000000E+04, 8.1224122925E+00, 5.4983991903E+00, 8.7641734528E-01, 6.9156476841E-01, 6.9679357999E-01],
	[1.5950000000E+04, 8.1259629090E+00, 5.4981263863E+00, 8.7729335152E-01, 6.9213154530E-01, 6.9691878846E-01],
	[1.5955000000E+04, 8.1295139639E+00, 5.4978536813E+00, 8.7816995808E-01, 6.9269851657E-01, 6.9704396605E-01],
	[1.5960000000E+04, 8.1330654573E+00, 5.4975810753E+00, 8.7904716517E-01, 6.9326568208E-01, 6.9716911274E-01],
	[1.5965000000E+04, 8.1366173890E+00, 5.4973085682E+00, 8.7992497301E-01, 6.9383304169E-01, 6.9729422853E-01],
	[1.5970000000E+04, 8.1401697590E+00, 5.4970361600E+00, 8.8080338184E-01, 6.9440059526E-01, 6.9741931338E-01],
	[1.5975000000E+04, 8.1437225671E+00, 5.4967638505E+00, 8.8168239188E-01, 6.9496834265E-01, 6.9754436730E-01],
	[1.5980000000E+04, 8.1472758133E+00, 5.4964916397E+00, 8.8256200334E-01, 6.9553628371E-01, 6.9766939025E-01],
	[1.5985000000E+04, 8.1508294976E+00, 5.4962195275E+00, 8.8344221645E-01, 6.9610441830E-01, 6.9779438222E-01],
	[1.5990000000E+04, 8.1543836198E+00, 5.4959475139E+00, 8.8432303143E-01, 6.9667274628E-01, 6.9791934321E-01],
	[1.5995000000E+04, 8.1579381798E+00, 5.4956755989E+00, 8.8520444851E-01, 6.9724126751E-01, 6.9804427319E-01],
	[1.6000000000E+04, 8.1614931776E+00, 5.4954037822E+00, 8.8608646790E-01, 6.9780998183E-01, 6.9816917214E-01],
	[1.6005000000E+04, 8.1650486130E+00, 5.4951320639E+00, 8.8696908984E-01, 6.9837888912E-01, 6.9829404007E-01],
	[1.6010000000E+04, 8.1686044861E+00, 5.4948604439E+00, 8.8785231454E-01, 6.9894798923E-01, 6.9841887694E-01],
	[1.6015000000E+04, 8.1721607966E+00, 5.4945889222E+00, 8.8873614223E-01, 6.9951728200E-01, 6.9854368275E-01],
	[1.6020000000E+04, 8.1757175446E+00, 5.4943174986E+00, 8.8962057312E-01, 7.0008676731E-01, 6.9866845748E-01],
	[1.6025000000E+04, 8.1792747300E+00, 5.4940461731E+00, 8.9050560745E-01, 7.0065644501E-01, 6.9879320111E-01],
	[1.6030000000E+04, 8.1828323526E+00, 5.4937749457E+00, 8.9139124544E-01, 7.0122631495E-01, 6.9891791364E-01],
	[1.6035000000E+04, 8.1863904124E+00, 5.4935038162E+00, 8.9227748730E-01, 7.0179637699E-01, 6.9904259504E-01],
	[1.6040000000E+04, 8.1899489092E+00, 5.4932327846E+00, 8.9316433327E-01, 7.0236663098E-01, 6.9916724530E-01],
	[1.6045000000E+04, 8.1935127223E+00, 5.4929643195E+00, 8.9405178355E-01, 7.0293715313E-01, 6.9929186441E-01],
	[1.6050000000E+04, 8.1970839771E+00, 5.4926994922E+00, 8.9493983839E-01, 7.0350797681E-01, 6.9941645236E-01],
	[1.6055000000E+04, 8.2006556755E+00, 5.4924347601E+00, 8.9582849800E-01, 7.0407899249E-01, 6.9954100912E-01],
	[1.6060000000E+04, 8.2042278172E+00, 5.4921701232E+00, 8.9671776260E-01, 7.0465020003E-01, 6.9966553469E-01],
	[1.6065000000E+04, 8.2078004023E+00, 5.4919055815E+00, 8.9760763241E-01, 7.0522159929E-01, 6.9979002904E-01],
	[1.6070000000E+04, 8.2113734306E+00, 5.4916411348E+00, 8.9849810767E-01, 7.0579319012E-01, 6.9991449217E-01],
	[1.6075000000E+04, 8.2149469021E+00, 5.4913767831E+00, 8.9938918859E-01, 7.0636497239E-01, 7.0003892407E-01],
	[1.6080000000E+04, 8.2185208166E+00, 5.4911125263E+00, 9.0028087539E-01, 7.0693694594E-01, 7.0016332470E-01],
	[1.6085000000E+04, 8.2220951741E+00, 5.4908483644E+00, 9.0117316830E-01, 7.0750911063E-01, 7.0028769408E-01],
	[1.6090000000E+04, 8.2256699745E+00, 5.4905842974E+00, 9.0206606755E-01, 7.0808146631E-01, 7.0041203216E-01],
	[1.6095000000E+04, 8.2292452178E+00, 5.4903203250E+00, 9.0295957335E-01, 7.0865401286E-01, 7.0053633896E-01],
	[1.6100000000E+04, 8.2328209038E+00, 5.4900564473E+00, 9.0385368592E-01, 7.0922675011E-01, 7.0066061444E-01],
	[1.6105000000E+04, 8.2363970324E+00, 5.4897926643E+00, 9.0474840550E-01, 7.0979967792E-01, 7.0078485860E-01],
	[1.6110000000E+04, 8.2399736036E+00, 5.4895289757E+00, 9.0564373230E-01, 7.1037279615E-01, 7.0090907142E-01],
	[1.6115000000E+04, 8.2435506173E+00, 5.4892653817E+00, 9.0653966655E-01, 7.1094610466E-01, 7.0103325289E-01],
	[1.6120000000E+04, 8.2471280735E+00, 5.4890018821E+00, 9.0743620846E-01, 7.1151960330E-01, 7.0115740299E-01],
	[1.6125000000E+04, 8.2507059719E+00, 5.4887384769E+00, 9.0833335827E-01, 7.1209329193E-01, 7.0128152171E-01],
	[1.6130000000E+04, 8.2542843126E+00, 5.4884751659E+00, 9.0923111620E-01, 7.1266717039E-01, 7.0140560904E-01],
	[1.6135000000E+04, 8.2578630954E+00, 5.4882119492E+00, 9.1012948247E-01, 7.1324123855E-01, 7.0152966496E-01],
	[1.6140000000E+04, 8.2614423204E+00, 5.4879488267E+00, 9.1102845730E-01, 7.1381549626E-01, 7.0165368946E-01],
	[1.6145000000E+04, 8.2650219873E+00, 5.4876857983E+00, 9.1192804092E-01, 7.1438994338E-01, 7.0177768252E-01],
	[1.6150000000E+04, 8.2686020961E+00, 5.4874228639E+00, 9.1282823354E-01, 7.1496457975E-01, 7.0190164413E-01],
	[1.6155000000E+04, 8.2721826468E+00, 5.4871600235E+00, 9.1372903540E-01, 7.1553940524E-01, 7.0202557428E-01],
	[1.6160000000E+04, 8.2757636392E+00, 5.4868972770E+00, 9.1463044671E-01, 7.1611441970E-01, 7.0214947295E-01],
	[1.6165000000E+04, 8.2793450733E+00, 5.4866346244E+00, 9.1553246771E-01, 7.1668962298E-01, 7.0227334013E-01],
	[1.6170000000E+04, 8.2829269490E+00, 5.4863720656E+00, 9.1643509860E-01, 7.1726501494E-01, 7.0239717580E-01],
	[1.6175000000E+04, 8.2865092662E+00, 5.4861096005E+00, 9.1733833962E-01, 7.1784059542E-01, 7.0252097996E-01],
	[1.6180000000E+04, 8.2900920248E+00, 5.4858472291E+00, 9.1824219099E-01, 7.1841636430E-01, 7.0264475258E-01],
	[1.6185000000E+04, 8.2936752248E+00, 5.4855849512E+00, 9.1914665293E-01, 7.1899232141E-01, 7.0276849367E-01],
	[1.6190000000E+04, 8.2972588660E+00, 5.4853227670E+00, 9.2005172567E-01, 7.1956846661E-01, 7.0289220319E-01],
	[1.6195000000E+04, 8.3008429483E+00, 5.4850606762E+00, 9.2095740943E-01, 7.2014479976E-01, 7.0301588114E-01],
	[1.6200000000E+04, 8.3044274718E+00, 5.4847986788E+00, 9.2186370443E-01, 7.2072132071E-01, 7.0313952750E-01],
	[1.6205000000E+04, 8.3080124363E+00, 5.4845367748E+00, 9.2277061089E-01, 7.2129802931E-01, 7.0326314227E-01],
	[1.6210000000E+04, 8.3115978417E+00, 5.4842749641E+00, 9.2367812904E-01, 7.2187492542E-01, 7.0338672542E-01],
	[1.6215000000E+04, 8.3151836880E+00, 5.4840132467E+00, 9.2458625911E-01, 7.2245200889E-01, 7.0351027694E-01],
	[1.6220000000E+04, 8.3187699750E+00, 5.4837516224E+00, 9.2549500131E-01, 7.2302927958E-01, 7.0363379683E-01],
	[1.6225000000E+04, 8.3223567027E+00, 5.4834900912E+00, 9.2640435587E-01, 7.2360673733E-01, 7.0375728507E-01],
	[1.6230000000E+04, 8.3259438710E+00, 5.4832286531E+00, 9.2731432301E-01, 7.2418438199E-01, 7.0388074164E-01],
	[1.6235000000E+04, 8.3295314799E+00, 5.4829673079E+00, 9.2822490296E-01, 7.2476221343E-01, 7.0400416653E-01],
	[1.6240000000E+04, 8.3331195291E+00, 5.4827060557E+00, 9.2913609594E-01, 7.2534023150E-01, 7.0412755973E-01],
	[1.6245000000E+04, 8.3367080188E+00, 5.4824448964E+00, 9.3004790217E-01, 7.2591843604E-01, 7.0425092122E-01],
	[1.6250000000E+04, 8.3402969487E+00, 5.4821838298E+00, 9.3096032188E-01, 7.2649682692E-01, 7.0437425100E-01],
	[1.6255000000E+04, 8.3438863188E+00, 5.4819228560E+00, 9.3187335529E-01, 7.2707540397E-01, 7.0449754904E-01],
	[1.6260000000E+04, 8.3474761290E+00, 5.4816619749E+00, 9.3278700262E-01, 7.2765416706E-01, 7.0462081534E-01],
	[1.6265000000E+04, 8.3510663793E+00, 5.4814011864E+00, 9.3370126409E-01, 7.2823311604E-01, 7.0474404989E-01],
	[1.6270000000E+04, 8.3546570695E+00, 5.4811404904E+00, 9.3461613994E-01, 7.2881225076E-01, 7.0486725266E-01],
	[1.6275000000E+04, 8.3582481995E+00, 5.4808798870E+00, 9.3553163038E-01, 7.2939157107E-01, 7.0499042365E-01],
	[1.6280000000E+04, 8.3618397694E+00, 5.4806193759E+00, 9.3644773564E-01, 7.2997107682E-01, 7.0511356284E-01],
	[1.6285000000E+04, 8.3654317790E+00, 5.4803589573E+00, 9.3736445594E-01, 7.3055076787E-01, 7.0523667023E-01],
	[1.6290000000E+04, 8.3690242282E+00, 5.4800986310E+00, 9.3828179150E-01, 7.3113064406E-01, 7.0535974579E-01],
	[1.6295000000E+04, 8.3726171169E+00, 5.4798383969E+00, 9.3919974256E-01, 7.3171070526E-01, 7.0548278952E-01],
	[1.6300000000E+04, 8.3762104451E+00, 5.4795782550E+00, 9.4011830932E-01, 7.3229095130E-01, 7.0560580140E-01],
	[1.6305000000E+04, 8.3798136043E+00, 5.4793226762E+00, 9.4103749202E-01, 7.3287153387E-01, 7.0572878142E-01],
	[1.6310000000E+04, 8.3834202268E+00, 5.4790686241E+00, 9.4195729088E-01, 7.3345235021E-01, 7.0585172957E-01],
	[1.6315000000E+04, 8.3870272954E+00, 5.4788146617E+00, 9.4287770612E-01, 7.3403335147E-01, 7.0597464584E-01],
	[1.6320000000E+04, 8.3906348100E+00, 5.4785607888E+00, 9.4379873797E-01, 7.3461453748E-01, 7.0609753020E-01],
	[1.6325000000E+04, 8.3942427705E+00, 5.4783070055E+00, 9.4472038664E-01, 7.3519590810E-01, 7.0622038266E-01],
	[1.6330000000E+04, 8.3978511768E+00, 5.4780533116E+00, 9.4564265237E-01, 7.3577746319E-01, 7.0634320319E-01],
	[1.6335000000E+04, 8.4014600289E+00, 5.4777997071E+00, 9.4656553538E-01, 7.3635920259E-01, 7.0646599179E-01],
	[1.6340000000E+04, 8.4050693267E+00, 5.4775461920E+00, 9.4748903589E-01, 7.3694112616E-01, 7.0658874844E-01],
	[1.6345000000E+04, 8.4086790700E+00, 5.4772927662E+00, 9.4841315412E-01, 7.3752323375E-01, 7.0671147312E-01],
	[1.6350000000E+04, 8.4122892589E+00, 5.4770394296E+00, 9.4933789030E-01, 7.3810552520E-01, 7.0683416584E-01],
	[1.6355000000E+04, 8.4158998931E+00, 5.4767861822E+00, 9.5026324465E-01, 7.3868800038E-01, 7.0695682657E-01],
	[1.6360000000E+04, 8.4195109727E+00, 5.4765330239E+00, 9.5118921740E-01, 7.3927065912E-01, 7.0707945530E-01],
	[1.6365000000E+04, 8.4231224976E+00, 5.4762799546E+00, 9.5211580877E-01, 7.3985350129E-01, 7.0720205203E-01],
	[1.6370000000E+04, 8.4267344677E+00, 5.4760269744E+00, 9.5304301898E-01, 7.4043652673E-01, 7.0732461673E-01],
	[1.6375000000E+04, 8.4303468829E+00, 5.4757740831E+00, 9.5397084826E-01, 7.4101973529E-01, 7.0744714939E-01],
	[1.6380000000E+04, 8.4339597430E+00, 5.4755212807E+00, 9.5489929683E-01, 7.4160312682E-01, 7.0756965001E-01],
	[1.6385000000E+04, 8.4375730482E+00, 5.4752685671E+00, 9.5582836491E-01, 7.4218670118E-01, 7.0769211858E-01],
	[1.6390000000E+04, 8.4411867981E+00, 5.4750159422E+00, 9.5675805274E-01, 7.4277045822E-01, 7.0781455507E-01],
	[1.6395000000E+04, 8.4448009929E+00, 5.4747634061E+00, 9.5768836052E-01, 7.4335439778E-01, 7.0793695947E-01],
	[1.6400000000E+04, 8.4484156323E+00, 5.4745109586E+00, 9.5861928849E-01, 7.4393851971E-01, 7.0805933179E-01],
	[1.6405000000E+04, 8.4520307164E+00, 5.4742585997E+00, 9.5955083687E-01, 7.4452282387E-01, 7.0818167199E-01],
	[1.6410000000E+04, 8.4556462450E+00, 5.4740063293E+00, 9.6048300589E-01, 7.4510731011E-01, 7.0830398008E-01],
	[1.6415000000E+04, 8.4592622181E+00, 5.4737541474E+00, 9.6141579576E-01, 7.4569197827E-01, 7.0842625603E-01],
	[1.6420000000E+04, 8.4628786355E+00, 5.4735020539E+00, 9.6234920671E-01, 7.4627682821E-01, 7.0854849985E-01],
	[1.6425000000E+04, 8.4664954972E+00, 5.4732500488E+00, 9.6328323897E-01, 7.4686185977E-01, 7.0867071150E-01],
	[1.6430000000E+04, 8.4701128032E+00, 5.4729981320E+00, 9.6421789276E-01, 7.4744707281E-01, 7.0879289099E-01],
	[1.6435000000E+04, 8.4737305532E+00, 5.4727463034E+00, 9.6515316830E-01, 7.4803246717E-01, 7.0891503831E-01],
	[1.6440000000E+04, 8.4773487473E+00, 5.4724945630E+00, 9.6608906582E-01, 7.4861804271E-01, 7.0903715343E-01],
	[1.6445000000E+04, 8.4809673854E+00, 5.4722429107E+00, 9.6702558554E-01, 7.4920379927E-01, 7.0915923635E-01],
	[1.6450000000E+04, 8.4845864674E+00, 5.4719913465E+00, 9.6796272769E-01, 7.4978973670E-01, 7.0928128705E-01],
	[1.6455000000E+04, 8.4882059932E+00, 5.4717398703E+00, 9.6890049248E-01, 7.5037585485E-01, 7.0940330553E-01],
	[1.6460000000E+04, 8.4918259627E+00, 5.4714884821E+00, 9.6983888015E-01, 7.5096215358E-01, 7.0952529178E-01],
	[1.6465000000E+04, 8.4954463758E+00, 5.4712371818E+00, 9.7077789091E-01, 7.5154863272E-01, 7.0964724577E-01],
	[1.6470000000E+04, 8.4990672326E+00, 5.4709859693E+00, 9.7171752500E-01, 7.5213529214E-01, 7.0976916750E-01],
	[1.6475000000E+04, 8.5026885328E+00, 5.4707348445E+00, 9.7265778263E-01, 7.5272213167E-01, 7.0989105696E-01],
	[1.6480000000E+04, 8.5063102764E+00, 5.4704838075E+00, 9.7359866403E-01, 7.5330915117E-01, 7.1001291414E-01],
	[1.6485000000E+04, 8.5099324633E+00, 5.4702328582E+00, 9.7454016943E-01, 7.5389635049E-01, 7.1013473902E-01],
	[1.6490000000E+04, 8.5135550935E+00, 5.4699819965E+00, 9.7548229904E-01, 7.5448372947E-01, 7.1025653160E-01],
	[1.6495000000E+04, 8.5171781669E+00, 5.4697312223E+00, 9.7642505309E-01, 7.5507128796E-01, 7.1037829186E-01],
	[1.6500000000E+04, 8.5208016833E+00, 5.4694805356E+00, 9.7736843181E-01, 7.5565902581E-01, 7.1050001979E-01],
	[1.6505000000E+04, 8.5244256428E+00, 5.4692299364E+00, 9.7831243541E-01, 7.5624694287E-01, 7.1062171537E-01],
	[1.6510000000E+04, 8.5280500451E+00, 5.4689794245E+00, 9.7925706413E-01, 7.5683503899E-01, 7.1074337861E-01],
	[1.6515000000E+04, 8.5316748904E+00, 5.4687290000E+00, 9.8020231819E-01, 7.5742331402E-01, 7.1086500948E-01],
	[1.6520000000E+04, 8.5353001784E+00, 5.4684786627E+00, 9.8114819781E-01, 7.5801176780E-01, 7.1098660798E-01],
	[1.6525000000E+04, 8.5389259090E+00, 5.4682284127E+00, 9.8209470322E-01, 7.5860040018E-01, 7.1110817409E-01],
	[1.6530000000E+04, 8.5425520823E+00, 5.4679782498E+00, 9.8304183464E-01, 7.5918921101E-01, 7.1122970781E-01],
	[1.6535000000E+04, 8.5461786981E+00, 5.4677281740E+00, 9.8398959229E-01, 7.5977820014E-01, 7.1135120911E-01],
	[1.6540000000E+04, 8.5498057563E+00, 5.4674781852E+00, 9.8493797640E-01, 7.6036736741E-01, 7.1147267800E-01],
	[1.6545000000E+04, 8.5534332570E+00, 5.4672282835E+00, 9.8588698719E-01, 7.6095671268E-01, 7.1159411445E-01],
	[1.6550000000E+04, 8.5570611999E+00, 5.4669784686E+00, 9.8683662489E-01, 7.6154623578E-01, 7.1171551847E-01],
	[1.6555000000E+04, 8.5606895850E+00, 5.4667287406E+00, 9.8778688972E-01, 7.6213593657E-01, 7.1183689003E-01],
	[1.6560000000E+04, 8.5643184122E+00, 5.4664790995E+00, 9.8873778190E-01, 7.6272581490E-01, 7.1195822913E-01],
	[1.6565000000E+04, 8.5679511936E+00, 5.4662311209E+00, 9.8968930167E-01, 7.6331592922E-01, 7.1207953575E-01],
	[1.6570000000E+04, 8.5715938536E+00, 5.4659874598E+00, 9.9064144924E-01, 7.6390637848E-01, 7.1220080989E-01],
	[1.6575000000E+04, 8.5752369626E+00, 5.4657438830E+00, 9.9159422483E-01, 7.6449700535E-01, 7.1232205153E-01],
	[1.6580000000E+04, 8.5788805204E+00, 5.4655003905E+00, 9.9254762868E-01, 7.6508780967E-01, 7.1244326066E-01],
	[1.6585000000E+04, 8.5825245271E+00, 5.4652569823E+00, 9.9350166101E-01, 7.6567879129E-01, 7.1256443728E-01],
	[1.6590000000E+04, 8.5861689825E+00, 5.4650136583E+00, 9.9445632204E-01, 7.6626995006E-01, 7.1268558137E-01],
	[1.6595000000E+04, 8.5898138865E+00, 5.4647704185E+00, 9.9541161199E-01, 7.6686128581E-01, 7.1280669291E-01],
	[1.6600000000E+04, 8.5934592391E+00, 5.4645272627E+00, 9.9636753109E-01, 7.6745279841E-01, 7.1292777191E-01],
	[1.6605000000E+04, 8.5971050402E+00, 5.4642841910E+00, 9.9732407957E-01, 7.6804448769E-01, 7.1304881835E-01],
	[1.6610000000E+04, 8.6007512897E+00, 5.4640412033E+00, 9.9828125764E-01, 7.6863635350E-01, 7.1316983221E-01],
	[1.6615000000E+04, 8.6043979875E+00, 5.4637982995E+00, 9.9923906554E-01, 7.6922839570E-01, 7.1329081349E-01],
	[1.6620000000E+04, 8.6080451336E+00, 5.4635554796E+00, 1.0001975035E+00, 7.6982061413E-01, 7.1341176218E-01],
	[1.6625000000E+04, 8.6116927278E+00, 5.4633127436E+00, 1.0011565717E+00, 7.7041300862E-01, 7.1353267826E-01],
	[1.6630000000E+04, 8.6153407701E+00, 5.4630700913E+00, 1.0021162704E+00, 7.7100557904E-01, 7.1365356173E-01],
	[1.6635000000E+04, 8.6189892605E+00, 5.4628275227E+00, 1.0030765998E+00, 7.7159832523E-01, 7.1377441257E-01],
	[1.6640000000E+04, 8.6226381987E+00, 5.4625850378E+00, 1.0040375602E+00, 7.7219124703E-01, 7.1389523078E-01],
	[1.6645000000E+04, 8.6262875848E+00, 5.4623426364E+00, 1.0049991518E+00, 7.7278434430E-01, 7.1401601635E-01],
	[1.6650000000E+04, 8.6299374187E+00, 5.4621003187E+00, 1.0059613747E+00, 7.7337761686E-01, 7.1413676925E-01],
	[1.6655000000E+04, 8.6335877003E+00, 5.4618580844E+00, 1.0069242293E+00, 7.7397106459E-01, 7.1425748949E-01],
	[1.6660000000E+04, 8.6372384295E+00, 5.4616159336E+00, 1.0078877157E+00, 7.7456468731E-01, 7.1437817706E-01],
	[1.6665000000E+04, 8.6408896062E+00, 5.4613738662E+00, 1.0088518341E+00, 7.7515848487E-01, 7.1449883193E-01],
	[1.6670000000E+04, 8.6445412303E+00, 5.4611318821E+00, 1.0098165849E+00, 7.7575245713E-01, 7.1461945411E-01],
	[1.6675000000E+04, 8.6481933018E+00, 5.4608899814E+00, 1.0107819682E+00, 7.7634660393E-01, 7.1474004358E-01],
	[1.6680000000E+04, 8.6518458207E+00, 5.4606481638E+00, 1.0117479842E+00, 7.7694092511E-01, 7.1486060034E-01],
	[1.6685000000E+04, 8.6554987867E+00, 5.4604064294E+00, 1.0127146332E+00, 7.7753542051E-01, 7.1498112436E-01],
	[1.6690000000E+04, 8.6591521999E+00, 5.4601647782E+00, 1.0136819153E+00, 7.7813009000E-01, 7.1510161565E-01],
	[1.6695000000E+04, 8.6628060601E+00, 5.4599232100E+00, 1.0146498309E+00, 7.7872493340E-01, 7.1522207418E-01],
	[1.6700000000E+04, 8.6664603673E+00, 5.4596817249E+00, 1.0156183801E+00, 7.7931995056E-01, 7.1534249996E-01],
	[1.6705000000E+04, 8.6701151214E+00, 5.4594403227E+00, 1.0165875632E+00, 7.7991514134E-01, 7.1546289297E-01],
	[1.6710000000E+04, 8.6737703223E+00, 5.4591990034E+00, 1.0175573804E+00, 7.8051050558E-01, 7.1558325321E-01],
	[1.6715000000E+04, 8.6774259699E+00, 5.4589577670E+00, 1.0185278319E+00, 7.8110604311E-01, 7.1570358065E-01],
	[1.6720000000E+04, 8.6810820642E+00, 5.4587166134E+00, 1.0194989179E+00, 7.8170175380E-01, 7.1582387529E-01],
	[1.6725000000E+04, 8.6847386051E+00, 5.4584755425E+00, 1.0204706387E+00, 7.8229763747E-01, 7.1594413713E-01],
	[1.6730000000E+04, 8.6883955925E+00, 5.4582345544E+00, 1.0214429945E+00, 7.8289369398E-01, 7.1606436614E-01],
	[1.6735000000E+04, 8.6920530263E+00, 5.4579936489E+00, 1.0224159855E+00, 7.8348992317E-01, 7.1618456233E-01],
	[1.6740000000E+04, 8.6957109064E+00, 5.4577528259E+00, 1.0233896119E+00, 7.8408632489E-01, 7.1630472568E-01],
	[1.6745000000E+04, 8.6993692329E+00, 5.4575120856E+00, 1.0243638740E+00, 7.8468289898E-01, 7.1642485618E-01],
	[1.6750000000E+04, 8.7030280055E+00, 5.4572714277E+00, 1.0253387719E+00, 7.8527964529E-01, 7.1654495383E-01],
	[1.6755000000E+04, 8.7066872242E+00, 5.4570308522E+00, 1.0263143060E+00, 7.8587656365E-01, 7.1666501860E-01],
	[1.6760000000E+04, 8.7103468889E+00, 5.4567903591E+00, 1.0272904764E+00, 7.8647365392E-01, 7.1678505050E-01],
	[1.6765000000E+04, 8.7140069996E+00, 5.4565499484E+00, 1.0282672834E+00, 7.8707091594E-01, 7.1690504951E-01],
	[1.6770000000E+04, 8.7176675561E+00, 5.4563096199E+00, 1.0292447271E+00, 7.8766834955E-01, 7.1702501563E-01],
	[1.6775000000E+04, 8.7213285585E+00, 5.4560693737E+00, 1.0302228079E+00, 7.8826595461E-01, 7.1714494884E-01],
	[1.6780000000E+04, 8.7249900065E+00, 5.4558292096E+00, 1.0312015259E+00, 7.8886373094E-01, 7.1726484913E-01],
	[1.6785000000E+04, 8.7286519002E+00, 5.4555891277E+00, 1.0321808813E+00, 7.8946167840E-01, 7.1738471650E-01],
	[1.6790000000E+04, 8.7323142394E+00, 5.4553491278E+00, 1.0331608745E+00, 7.9005979682E-01, 7.1750455093E-01],
	[1.6795000000E+04, 8.7359770242E+00, 5.4551092099E+00, 1.0341415055E+00, 7.9065808607E-01, 7.1762435242E-01],
	[1.6800000000E+04, 8.7396402543E+00, 5.4548693740E+00, 1.0351227747E+00, 7.9125654597E-01, 7.1774412095E-01],
	[1.6805000000E+04, 8.7433039297E+00, 5.4546296200E+00, 1.0361046822E+00, 7.9185517637E-01, 7.1786385652E-01],
	[1.6810000000E+04, 8.7469680504E+00, 5.4543899479E+00, 1.0370872283E+00, 7.9245397711E-01, 7.1798355912E-01],
	[1.6815000000E+04, 8.7506326163E+00, 5.4541503575E+00, 1.0380704133E+00, 7.9305294805E-01, 7.1810322873E-01],
	[1.6820000000E+04, 8.7542976272E+00, 5.4539108489E+00, 1.0390542372E+00, 7.9365208902E-01, 7.1822286536E-01],
	[1.6825000000E+04, 8.7579630831E+00, 5.4536714220E+00, 1.0400387004E+00, 7.9425139986E-01, 7.1834246898E-01],
	[1.6830000000E+04, 8.7616289840E+00, 5.4534320768E+00, 1.0410238031E+00, 7.9485088042E-01, 7.1846203959E-01],
	[1.6835000000E+04, 8.7653080230E+00, 5.4531981848E+00, 1.0420095455E+00, 7.9545074938E-01, 7.1858157718E-01],
	[1.6840000000E+04, 8.7689883111E+00, 5.4529647096E+00, 1.0429959279E+00, 7.9605080202E-01, 7.1870108173E-01],
	[1.6845000000E+04, 8.7726690512E+00, 5.4527313137E+00, 1.0439829503E+00, 7.9665102445E-01, 7.1882055323E-01],
	[1.6850000000E+04, 8.7763502432E+00, 5.4524979971E+00, 1.0449706132E+00, 7.9725141654E-01, 7.1893999167E-01],
	[1.6855000000E+04, 8.7800318870E+00, 5.4522647596E+00, 1.0459589167E+00, 7.9785197810E-01, 7.1905939704E-01],
	[1.6860000000E+04, 8.7837139826E+00, 5.4520316014E+00, 1.0469478610E+00, 7.9845270900E-01, 7.1917876932E-01],
	[1.6865000000E+04, 8.7873965298E+00, 5.4517985222E+00, 1.0479374464E+00, 7.9905360907E-01, 7.1929810851E-01],
	[1.6870000000E+04, 8.7910795287E+00, 5.4515655220E+00, 1.0489276730E+00, 7.9965467816E-01, 7.1941741460E-01],
	[1.6875000000E+04, 8.7947629791E+00, 5.4513326009E+00, 1.0499185412E+00, 8.0025591610E-01, 7.1953668756E-01],
	[1.6880000000E+04, 8.7984468809E+00, 5.4510997587E+00, 1.0509100510E+00, 8.0085732275E-01, 7.1965592740E-01],
	[1.6885000000E+04, 8.8021312341E+00, 5.4508669954E+00, 1.0519022029E+00, 8.0145889795E-01, 7.1977513410E-01],
	[1.6890000000E+04, 8.8058160386E+00, 5.4506343110E+00, 1.0528949969E+00, 8.0206064153E-01, 7.1989430765E-01],
	[1.6895000000E+04, 8.8095012943E+00, 5.4504017054E+00, 1.0538884333E+00, 8.0266255335E-01, 7.2001344803E-01],
	[1.6900000000E+04, 8.8131870011E+00, 5.4501691785E+00, 1.0548825124E+00, 8.0326463323E-01, 7.2013255524E-01],
	[1.6905000000E+04, 8.8168731590E+00, 5.4499367303E+00, 1.0558772343E+00, 8.0386688104E-01, 7.2025162927E-01],
	[1.6910000000E+04, 8.8205597678E+00, 5.4497043608E+00, 1.0568725993E+00, 8.0446929661E-01, 7.2037067010E-01],
	[1.6915000000E+04, 8.8242468276E+00, 5.4494720698E+00, 1.0578686076E+00, 8.0507187978E-01, 7.2048967772E-01],
	[1.6920000000E+04, 8.8279343381E+00, 5.4492398575E+00, 1.0588652594E+00, 8.0567463039E-01, 7.2060865213E-01],
	[1.6925000000E+04, 8.8316222994E+00, 5.4490077236E+00, 1.0598625550E+00, 8.0627754829E-01, 7.2072759330E-01],
	[1.6930000000E+04, 8.8353107114E+00, 5.4487756682E+00, 1.0608604946E+00, 8.0688063332E-01, 7.2084650124E-01],
	[1.6935000000E+04, 8.8389995739E+00, 5.4485436911E+00, 1.0618590784E+00, 8.0748388532E-01, 7.2096537593E-01],
	[1.6940000000E+04, 8.8426888870E+00, 5.4483117925E+00, 1.0628583066E+00, 8.0808730414E-01, 7.2108421735E-01],
	[1.6945000000E+04, 8.8463786505E+00, 5.4480799721E+00, 1.0638581795E+00, 8.0869088962E-01, 7.2120302550E-01],
	[1.6950000000E+04, 8.8500688643E+00, 5.4478482300E+00, 1.0648586972E+00, 8.0929464159E-01, 7.2132180037E-01],
	[1.6955000000E+04, 8.8537595284E+00, 5.4476165661E+00, 1.0658598601E+00, 8.0989855990E-01, 7.2144054195E-01],
	[1.6960000000E+04, 8.8574506427E+00, 5.4473849803E+00, 1.0668616683E+00, 8.1050264439E-01, 7.2155925022E-01],
	[1.6965000000E+04, 8.8611422071E+00, 5.4471534726E+00, 1.0678641220E+00, 8.1110689491E-01, 7.2167792518E-01],
	[1.6970000000E+04, 8.8648342215E+00, 5.4469220430E+00, 1.0688672216E+00, 8.1171131130E-01, 7.2179656681E-01],
	[1.6975000000E+04, 8.8685266859E+00, 5.4466906914E+00, 1.0698709671E+00, 8.1231589339E-01, 7.2191517510E-01],
	[1.6980000000E+04, 8.8722196002E+00, 5.4464594178E+00, 1.0708753589E+00, 8.1292064103E-01, 7.2203375005E-01],
	[1.6985000000E+04, 8.8759129643E+00, 5.4462282221E+00, 1.0718803971E+00, 8.1352555406E-01, 7.2215229163E-01],
	[1.6990000000E+04, 8.8796067781E+00, 5.4459971042E+00, 1.0728860821E+00, 8.1413063233E-01, 7.2227079985E-01],
	[1.6995000000E+04, 8.8833010416E+00, 5.4457660641E+00, 1.0738924139E+00, 8.1473587566E-01, 7.2238927470E-01],
	[1.7000000000E+04, 8.8869957546E+00, 5.4455351018E+00, 1.0748993929E+00, 8.1534128391E-01, 7.2250771615E-01],
	[1.7005000000E+04, 8.8906909172E+00, 5.4453042173E+00, 1.0759070192E+00, 8.1594685692E-01, 7.2262612420E-01],
	[1.7010000000E+04, 8.8943865291E+00, 5.4450734103E+00, 1.0769152931E+00, 8.1655259453E-01, 7.2274449884E-01],
	[1.7015000000E+04, 8.8980825904E+00, 5.4448426810E+00, 1.0779242148E+00, 8.1715849657E-01, 7.2286284006E-01],
	[1.7020000000E+04, 8.9017791010E+00, 5.4446120293E+00, 1.0789337846E+00, 8.1776456289E-01, 7.2298114785E-01],
	[1.7025000000E+04, 8.9054760607E+00, 5.4443814550E+00, 1.0799440026E+00, 8.1837079334E-01, 7.2309942220E-01],
	[1.7030000000E+04, 8.9091734696E+00, 5.4441509583E+00, 1.0809548691E+00, 8.1897718774E-01, 7.2321766310E-01],
	[1.7035000000E+04, 8.9128713274E+00, 5.4439205389E+00, 1.0819663843E+00, 8.1958374595E-01, 7.2333587054E-01],
	[1.7040000000E+04, 8.9165696343E+00, 5.4436901969E+00, 1.0829785485E+00, 8.2019046780E-01, 7.2345404451E-01],
	[1.7045000000E+04, 8.9202683900E+00, 5.4434599323E+00, 1.0839913618E+00, 8.2079735313E-01, 7.2357218499E-01],
	[1.7050000000E+04, 8.9239675945E+00, 5.4432297449E+00, 1.0850048245E+00, 8.2140440178E-01, 7.2369029198E-01],
	[1.7055000000E+04, 8.9276672477E+00, 5.4429996347E+00, 1.0860189369E+00, 8.2201161360E-01, 7.2380836547E-01],
	[1.7060000000E+04, 8.9313673496E+00, 5.4427696017E+00, 1.0870336990E+00, 8.2261898843E-01, 7.2392640545E-01],
	[1.7065000000E+04, 8.9350679000E+00, 5.4425396459E+00, 1.0880491113E+00, 8.2322652610E-01, 7.2404441190E-01],
	[1.7070000000E+04, 8.9387688989E+00, 5.4423097671E+00, 1.0890651738E+00, 8.2383422645E-01, 7.2416238483E-01],
	[1.7075000000E+04, 8.9424703462E+00, 5.4420799653E+00, 1.0900818868E+00, 8.2444208933E-01, 7.2428032421E-01],
	[1.7080000000E+04, 8.9461722419E+00, 5.4418502405E+00, 1.0910992506E+00, 8.2505011458E-01, 7.2439823004E-01],
	[1.7085000000E+04, 8.9498745858E+00, 5.4416205927E+00, 1.0921172653E+00, 8.2565830203E-01, 7.2451610230E-01],
	[1.7090000000E+04, 8.9535773780E+00, 5.4413910217E+00, 1.0931359313E+00, 8.2626665153E-01, 7.2463394100E-01],
	[1.7095000000E+04, 8.9572806182E+00, 5.4411615276E+00, 1.0941552486E+00, 8.2687516291E-01, 7.2475174611E-01],
	[1.7100000000E+04, 8.9609843064E+00, 5.4409321103E+00, 1.0951752176E+00, 8.2748383602E-01, 7.2486951764E-01],
	[1.7105000000E+04, 8.9646990009E+00, 5.4407069903E+00, 1.0961958385E+00, 8.2809285855E-01, 7.2498725556E-01],
	[1.7110000000E+04, 8.9684176329E+00, 5.4404833376E+00, 1.0972171114E+00, 8.2870210498E-01, 7.2510495987E-01],
	[1.7115000000E+04, 8.9721367203E+00, 5.4402597593E+00, 1.0982390367E+00, 8.2931151322E-01, 7.2522263056E-01],
	[1.7120000000E+04, 8.9758562629E+00, 5.4400362556E+00, 1.0992616145E+00, 8.2992108312E-01, 7.2534026762E-01],
	[1.7125000000E+04, 8.9795762607E+00, 5.4398128263E+00, 1.1002848451E+00, 8.3053081452E-01, 7.2545787104E-01],
	[1.7130000000E+04, 8.9832967136E+00, 5.4395894714E+00, 1.1013087287E+00, 8.3114070726E-01, 7.2557544081E-01],
	[1.7135000000E+04, 8.9870176215E+00, 5.4393661909E+00, 1.1023332655E+00, 8.3175076117E-01, 7.2569297692E-01],
	[1.7140000000E+04, 8.9907389843E+00, 5.4391429846E+00, 1.1033584558E+00, 8.3236097611E-01, 7.2581047937E-01],
	[1.7145000000E+04, 8.9944608019E+00, 5.4389198527E+00, 1.1043842997E+00, 8.3297135190E-01, 7.2592794813E-01],
	[1.7150000000E+04, 8.9981830744E+00, 5.4386967949E+00, 1.1054107976E+00, 8.3358188840E-01, 7.2604538321E-01],
	[1.7155000000E+04, 9.0019058015E+00, 5.4384738113E+00, 1.1064379495E+00, 8.3419258543E-01, 7.2616278459E-01],
	[1.7160000000E+04, 9.0056289833E+00, 5.4382509018E+00, 1.1074657559E+00, 8.3480344284E-01, 7.2628015227E-01],
	[1.7165000000E+04, 9.0093526196E+00, 5.4380280664E+00, 1.1084942167E+00, 8.3541446047E-01, 7.2639748623E-01],
	[1.7170000000E+04, 9.0130767104E+00, 5.4378053050E+00, 1.1095233324E+00, 8.3602563815E-01, 7.2651478646E-01],
	[1.7175000000E+04, 9.0168012556E+00, 5.4375826176E+00, 1.1105531032E+00, 8.3663697573E-01, 7.2663205296E-01],
	[1.7180000000E+04, 9.0205262551E+00, 5.4373600042E+00, 1.1115835291E+00, 8.3724847304E-01, 7.2674928572E-01],
	[1.7185000000E+04, 9.0242517088E+00, 5.4371374646E+00, 1.1126146106E+00, 8.3786012993E-01, 7.2686648472E-01],
	[1.7190000000E+04, 9.0279776167E+00, 5.4369149989E+00, 1.1136463477E+00, 8.3847194624E-01, 7.2698364997E-01],
	[1.7195000000E+04, 9.0317039787E+00, 5.4366926070E+00, 1.1146787408E+00, 8.3908392179E-01, 7.2710078144E-01],
	[1.7200000000E+04, 9.0354307947E+00, 5.4364702888E+00, 1.1157117901E+00, 8.3969605644E-01, 7.2721787913E-01],
	[1.7205000000E+04, 9.0391580646E+00, 5.4362480443E+00, 1.1167454957E+00, 8.4030835002E-01, 7.2733494303E-01],
	[1.7210000000E+04, 9.0428857884E+00, 5.4360258735E+00, 1.1177798579E+00, 8.4092080237E-01, 7.2745197314E-01],
	[1.7215000000E+04, 9.0466139660E+00, 5.4358037763E+00, 1.1188148770E+00, 8.4153341333E-01, 7.2756896943E-01],
	[1.7220000000E+04, 9.0503425973E+00, 5.4355817526E+00, 1.1198505531E+00, 8.4214618273E-01, 7.2768593191E-01],
	[1.7225000000E+04, 9.0540716821E+00, 5.4353598025E+00, 1.1208868865E+00, 8.4275911042E-01, 7.2780286057E-01],
	[1.7230000000E+04, 9.0578012206E+00, 5.4351379259E+00, 1.1219238774E+00, 8.4337219624E-01, 7.2791975539E-01],
	[1.7235000000E+04, 9.0615312125E+00, 5.4349161227E+00, 1.1229615261E+00, 8.4398544002E-01, 7.2803661637E-01],
	[1.7240000000E+04, 9.0652616578E+00, 5.4346943929E+00, 1.1239998327E+00, 8.4459884160E-01, 7.2815344349E-01],
	[1.7245000000E+04, 9.0689925565E+00, 5.4344727364E+00, 1.1250387975E+00, 8.4521240082E-01, 7.2827023676E-01],
	[1.7250000000E+04, 9.0727239083E+00, 5.4342511532E+00, 1.1260784207E+00, 8.4582611752E-01, 7.2838699616E-01],
	[1.7255000000E+04, 9.0764557134E+00, 5.4340296432E+00, 1.1271187026E+00, 8.4643999154E-01, 7.2850372167E-01],
	[1.7260000000E+04, 9.0801879715E+00, 5.4338082065E+00, 1.1281596433E+00, 8.4705402272E-01, 7.2862041330E-01],
	[1.7265000000E+04, 9.0839206827E+00, 5.4335868429E+00, 1.1292012432E+00, 8.4766821088E-01, 7.2873707104E-01],
	[1.7270000000E+04, 9.0876538468E+00, 5.4333655525E+00, 1.1302435023E+00, 8.4828255588E-01, 7.2885369487E-01],
	[1.7275000000E+04, 9.0913874637E+00, 5.4331443351E+00, 1.1312864210E+00, 8.4889705755E-01, 7.2897028479E-01],
	[1.7280000000E+04, 9.0951215335E+00, 5.4329231907E+00, 1.1323299995E+00, 8.4951171572E-01, 7.2908684078E-01],
	[1.7285000000E+04, 9.0988560559E+00, 5.4327021193E+00, 1.1333742379E+00, 8.5012653024E-01, 7.2920336285E-01],
	[1.7290000000E+04, 9.1025910310E+00, 5.4324811208E+00, 1.1344191366E+00, 8.5074150095E-01, 7.2931985097E-01],
	[1.7295000000E+04, 9.1063264586E+00, 5.4322601952E+00, 1.1354646957E+00, 8.5135662767E-01, 7.2943630515E-01],
	[1.7300000000E+04, 9.1100623388E+00, 5.4320393425E+00, 1.1365109155E+00, 8.5197191026E-01, 7.2955272538E-01],
	[1.7305000000E+04, 9.1137986713E+00, 5.4318185625E+00, 1.1375577962E+00, 8.5258734854E-01, 7.2966911163E-01],
	[1.7310000000E+04, 9.1175354562E+00, 5.4315978553E+00, 1.1386053380E+00, 8.5320294236E-01, 7.2978546392E-01],
	[1.7315000000E+04, 9.1212726933E+00, 5.4313772208E+00, 1.1396535412E+00, 8.5381869154E-01, 7.2990178223E-01],
	[1.7320000000E+04, 9.1250103826E+00, 5.4311566590E+00, 1.1407024060E+00, 8.5443459594E-01, 7.3001806654E-01],
	[1.7325000000E+04, 9.1287485240E+00, 5.4309361698E+00, 1.1417519325E+00, 8.5505065538E-01, 7.3013431686E-01],
	[1.7330000000E+04, 9.1324871174E+00, 5.4307157532E+00, 1.1428021211E+00, 8.5566686971E-01, 7.3025053317E-01],
	[1.7335000000E+04, 9.1362261628E+00, 5.4304954091E+00, 1.1438529720E+00, 8.5628323876E-01, 7.3036671547E-01],
	[1.7340000000E+04, 9.1399656600E+00, 5.4302751374E+00, 1.1449044853E+00, 8.5689976236E-01, 7.3048286375E-01],
	[1.7345000000E+04, 9.1437056091E+00, 5.4300549382E+00, 1.1459566613E+00, 8.5751644037E-01, 7.3059897799E-01],
	[1.7350000000E+04, 9.1474460099E+00, 5.4298348114E+00, 1.1470095003E+00, 8.5813327260E-01, 7.3071505820E-01],
	[1.7355000000E+04, 9.1511868623E+00, 5.4296147570E+00, 1.1480630024E+00, 8.5875025890E-01, 7.3083110436E-01],
	[1.7360000000E+04, 9.1549281663E+00, 5.4293947748E+00, 1.1491171679E+00, 8.5936739912E-01, 7.3094711646E-01],
	[1.7365000000E+04, 9.1586699218E+00, 5.4291748649E+00, 1.1501719971E+00, 8.5998469307E-01, 7.3106309451E-01],
	[1.7370000000E+04, 9.1624121287E+00, 5.4289550272E+00, 1.1512274901E+00, 8.6060214061E-01, 7.3117903848E-01],
	[1.7375000000E+04, 9.1661547870E+00, 5.4287352617E+00, 1.1522836471E+00, 8.6121974156E-01, 7.3129494837E-01],
	[1.7380000000E+04, 9.1699079779E+00, 5.4285193798E+00, 1.1533404684E+00, 8.6183768089E-01, 7.3141082417E-01],
	[1.7385000000E+04, 9.1736661433E+00, 5.4283052758E+00, 1.1543979543E+00, 8.6245585675E-01, 7.3152666588E-01],
	[1.7390000000E+04, 9.1774247675E+00, 5.4280912419E+00, 1.1554561049E+00, 8.6307418613E-01, 7.3164247349E-01],
	[1.7395000000E+04, 9.1811838506E+00, 5.4278772779E+00, 1.1565149204E+00, 8.6369266888E-01, 7.3175824698E-01],
	[1.7400000000E+04, 9.1849433923E+00, 5.4276633838E+00, 1.1575744012E+00, 8.6431130482E-01, 7.3187398636E-01],
	[1.7405000000E+04, 9.1887033927E+00, 5.4274495596E+00, 1.1586345474E+00, 8.6493009381E-01, 7.3198969161E-01],
	[1.7410000000E+04, 9.1924638516E+00, 5.4272358052E+00, 1.1596953592E+00, 8.6554903566E-01, 7.3210536273E-01],
	[1.7415000000E+04, 9.1962247690E+00, 5.4270221207E+00, 1.1607568369E+00, 8.6616813023E-01, 7.3222099970E-01],
	[1.7420000000E+04, 9.1999861448E+00, 5.4268085059E+00, 1.1618189807E+00, 8.6678737735E-01, 7.3233660253E-01],
	[1.7425000000E+04, 9.2037479789E+00, 5.4265949607E+00, 1.1628817908E+00, 8.6740677684E-01, 7.3245217119E-01],
	[1.7430000000E+04, 9.2075102713E+00, 5.4263814853E+00, 1.1639452675E+00, 8.6802632856E-01, 7.3256770570E-01],
	[1.7435000000E+04, 9.2112730219E+00, 5.4261680795E+00, 1.1650094110E+00, 8.6864603234E-01, 7.3268320603E-01],
	[1.7440000000E+04, 9.2150362306E+00, 5.4259547433E+00, 1.1660742215E+00, 8.6926588801E-01, 7.3279867218E-01],
	[1.7445000000E+04, 9.2187998973E+00, 5.4257414766E+00, 1.1671396992E+00, 8.6988589540E-01, 7.3291410414E-01],
	[1.7450000000E+04, 9.2225640219E+00, 5.4255282794E+00, 1.1682058444E+00, 8.7050605437E-01, 7.3302950190E-01],
	[1.7455000000E+04, 9.2263286045E+00, 5.4253151516E+00, 1.1692726572E+00, 8.7112636474E-01, 7.3314486547E-01],
	[1.7460000000E+04, 9.2300936448E+00, 5.4251020933E+00, 1.1703401380E+00, 8.7174682635E-01, 7.3326019482E-01],
	[1.7465000000E+04, 9.2338591429E+00, 5.4248891043E+00, 1.1714082869E+00, 8.7236743903E-01, 7.3337548996E-01],
	[1.7470000000E+04, 9.2376250986E+00, 5.4246761847E+00, 1.1724771042E+00, 8.7298820263E-01, 7.3349075087E-01],
	[1.7475000000E+04, 9.2413915118E+00, 5.4244633343E+00, 1.1735465900E+00, 8.7360911697E-01, 7.3360597755E-01],
	[1.7480000000E+04, 9.2451583826E+00, 5.4242505532E+00, 1.1746167447E+00, 8.7423018190E-01, 7.3372116998E-01],
	[1.7485000000E+04, 9.2489257108E+00, 5.4240378413E+00, 1.1756875685E+00, 8.7485139725E-01, 7.3383632818E-01],
	[1.7490000000E+04, 9.2526934964E+00, 5.4238251985E+00, 1.1767590614E+00, 8.7547276285E-01, 7.3395145211E-01],
	[1.7495000000E+04, 9.2564617392E+00, 5.4236126249E+00, 1.1778312239E+00, 8.7609427855E-01, 7.3406654179E-01],
	[1.7500000000E+04, 9.2602304392E+00, 5.4234001203E+00, 1.1789040562E+00, 8.7671594417E-01, 7.3418159720E-01],
	[1.7505000000E+04, 9.2639995964E+00, 5.4231876847E+00, 1.1799862121E+00, 8.7734254357E-01, 7.3429661833E-01],
	[1.7510000000E+04, 9.2677692106E+00, 5.4229753182E+00, 1.1810690516E+00, 8.7796929609E-01, 7.3441160517E-01],
	[1.7515000000E+04, 9.2715392818E+00, 5.4227630206E+00, 1.1821525749E+00, 8.7859620154E-01, 7.3452655773E-01],
	[1.7520000000E+04, 9.2753098098E+00, 5.4225507918E+00, 1.1832367822E+00, 8.7922325978E-01, 7.3464147599E-01],
	[1.7525000000E+04, 9.2790807947E+00, 5.4223386320E+00, 1.1843216737E+00, 8.7985047062E-01, 7.3475635994E-01],
	[1.7530000000E+04, 9.2828522364E+00, 5.4221265410E+00, 1.1854072497E+00, 8.8047783390E-01, 7.3487120959E-01],
	[1.7535000000E+04, 9.2866241347E+00, 5.4219145187E+00, 1.1864935104E+00, 8.8110534946E-01, 7.3498602491E-01],
	[1.7540000000E+04, 9.2903964896E+00, 5.4217025652E+00, 1.1875804561E+00, 8.8173301712E-01, 7.3510080591E-01],
	[1.7545000000E+04, 9.2941693010E+00, 5.4214906804E+00, 1.1886680869E+00, 8.8236083671E-01, 7.3521555258E-01],
	[1.7550000000E+04, 9.2979425689E+00, 5.4212788642E+00, 1.1897564032E+00, 8.8298880808E-01, 7.3533026491E-01],
	[1.7555000000E+04, 9.3017162932E+00, 5.4210671166E+00, 1.1908454051E+00, 8.8361693105E-01, 7.3544494289E-01],
	[1.7560000000E+04, 9.3054904737E+00, 5.4208554376E+00, 1.1919350930E+00, 8.8424520544E-01, 7.3555958652E-01],
	[1.7565000000E+04, 9.3092651105E+00, 5.4206438272E+00, 1.1930254669E+00, 8.8487363111E-01, 7.3567419579E-01],
	[1.7570000000E+04, 9.3130402034E+00, 5.4204322852E+00, 1.1941165272E+00, 8.8550220786E-01, 7.3578877069E-01],
	[1.7575000000E+04, 9.3168157524E+00, 5.4202208116E+00, 1.1952082742E+00, 8.8613093555E-01, 7.3590331122E-01],
	[1.7580000000E+04, 9.3205917574E+00, 5.4200094065E+00, 1.1963007079E+00, 8.8675981399E-01, 7.3601781737E-01],
	[1.7585000000E+04, 9.3243682183E+00, 5.4197980697E+00, 1.1973938288E+00, 8.8738884302E-01, 7.3613228913E-01],
	[1.7590000000E+04, 9.3281451351E+00, 5.4195868012E+00, 1.1984876369E+00, 8.8801802248E-01, 7.3624672649E-01],
	[1.7595000000E+04, 9.3319225077E+00, 5.4193756011E+00, 1.1995821326E+00, 8.8864735219E-01, 7.3636112946E-01],
	[1.7600000000E+04, 9.3357003359E+00, 5.4191644691E+00, 1.2006773161E+00, 8.8927683198E-01, 7.3647549802E-01],
	[1.7605000000E+04, 9.3394786198E+00, 5.4189534054E+00, 1.2017731876E+00, 8.8990646168E-01, 7.3658983217E-01],
	[1.7610000000E+04, 9.3432573592E+00, 5.4187424098E+00, 1.2028697474E+00, 8.9053624113E-01, 7.3670413190E-01],
	[1.7615000000E+04, 9.3470365542E+00, 5.4185314823E+00, 1.2039669956E+00, 8.9116617016E-01, 7.3681839720E-01],
	[1.7620000000E+04, 9.3508162045E+00, 5.4183206228E+00, 1.2050649326E+00, 8.9179624860E-01, 7.3693262807E-01],
	[1.7625000000E+04, 9.3545963101E+00, 5.4181098314E+00, 1.2061635586E+00, 8.9242647628E-01, 7.3704682450E-01],
	[1.7630000000E+04, 9.3583768710E+00, 5.4178991080E+00, 1.2072628737E+00, 8.9305685303E-01, 7.3716098648E-01],
	[1.7635000000E+04, 9.3621578871E+00, 5.4176884526E+00, 1.2083628783E+00, 8.9368737868E-01, 7.3727511401E-01],
	[1.7640000000E+04, 9.3659393583E+00, 5.4174778650E+00, 1.2094635726E+00, 8.9431805306E-01, 7.3738920708E-01],
	[1.7645000000E+04, 9.3697212845E+00, 5.4172673453E+00, 1.2105649567E+00, 8.9494887600E-01, 7.3750326569E-01],
	[1.7650000000E+04, 9.3735036656E+00, 5.4170568935E+00, 1.2116670311E+00, 8.9557984734E-01, 7.3761728983E-01],
	[1.7655000000E+04, 9.3772865017E+00, 5.4168465094E+00, 1.2127697958E+00, 8.9621096690E-01, 7.3773127955E-01],
	[1.7660000000E+04, 9.3810810218E+00, 5.4166402286E+00, 1.2138732511E+00, 8.9684244778E-01, 7.3784523491E-01],
	[1.7665000000E+04, 9.3848798907E+00, 5.4164354107E+00, 1.2149773973E+00, 8.9747415091E-01, 7.3795915589E-01],
	[1.7670000000E+04, 9.3886792221E+00, 5.4162306586E+00, 1.2160822346E+00, 8.9810600239E-01, 7.3807304249E-01],
	[1.7675000000E+04, 9.3924790162E+00, 5.4160259721E+00, 1.2171877632E+00, 8.9873800204E-01, 7.3818689470E-01],
	[1.7680000000E+04, 9.3962792726E+00, 5.4158213512E+00, 1.2182939834E+00, 8.9937014970E-01, 7.3830071251E-01],
	[1.7685000000E+04, 9.4000799915E+00, 5.4156167960E+00, 1.2194008954E+00, 9.0000244519E-01, 7.3841449592E-01],
	[1.7690000000E+04, 9.4038811726E+00, 5.4154123062E+00, 1.2205084994E+00, 9.0063488835E-01, 7.3852824491E-01],
	[1.7695000000E+04, 9.4076828159E+00, 5.4152078820E+00, 1.2216167957E+00, 9.0126747901E-01, 7.3864195948E-01],
	[1.7700000000E+04, 9.4114849215E+00, 5.4150035233E+00, 1.2227257845E+00, 9.0190021700E-01, 7.3875563962E-01],
	[1.7705000000E+04, 9.4152874890E+00, 5.4147992300E+00, 1.2238354660E+00, 9.0253310214E-01, 7.3886928533E-01],
	[1.7710000000E+04, 9.4190905186E+00, 5.4145950020E+00, 1.2249458406E+00, 9.0316613428E-01, 7.3898289660E-01],
	[1.7715000000E+04, 9.4228940102E+00, 5.4143908394E+00, 1.2260569084E+00, 9.0379931324E-01, 7.3909647341E-01],
	[1.7720000000E+04, 9.4266979635E+00, 5.4141867422E+00, 1.2271686696E+00, 9.0443263885E-01, 7.3921001577E-01],
	[1.7725000000E+04, 9.4305023787E+00, 5.4139827102E+00, 1.2282811245E+00, 9.0506611094E-01, 7.3932352366E-01],
	[1.7730000000E+04, 9.4343072555E+00, 5.4137787434E+00, 1.2293942734E+00, 9.0569972934E-01, 7.3943699708E-01],
	[1.7735000000E+04, 9.4381125940E+00, 5.4135748419E+00, 1.2305081164E+00, 9.0633349389E-01, 7.3955043601E-01],
	[1.7740000000E+04, 9.4419183941E+00, 5.4133710054E+00, 1.2316226538E+00, 9.0696740441E-01, 7.3966384046E-01],
	[1.7745000000E+04, 9.4457246556E+00, 5.4131672341E+00, 1.2327378859E+00, 9.0760146073E-01, 7.3977721042E-01],
	[1.7750000000E+04, 9.4495313785E+00, 5.4129635279E+00, 1.2338538129E+00, 9.0823566268E-01, 7.3989054587E-01],
	[1.7755000000E+04, 9.4533385628E+00, 5.4127598867E+00, 1.2349704349E+00, 9.0887001010E-01, 7.4000384682E-01],
	[1.7760000000E+04, 9.4571462083E+00, 5.4125563105E+00, 1.2360877524E+00, 9.0950450281E-01, 7.4011711325E-01],
	[1.7765000000E+04, 9.4609543150E+00, 5.4123527993E+00, 1.2372057654E+00, 9.1013914065E-01, 7.4023034515E-01],
	[1.7770000000E+04, 9.4647628829E+00, 5.4121493530E+00, 1.2383244742E+00, 9.1077392343E-01, 7.4034354253E-01],
	[1.7775000000E+04, 9.4685719117E+00, 5.4119459716E+00, 1.2394438791E+00, 9.1140885101E-01, 7.4045670537E-01],
	[1.7780000000E+04, 9.4723814016E+00, 5.4117426550E+00, 1.2405639803E+00, 9.1204392319E-01, 7.4056983366E-01],
	[1.7785000000E+04, 9.4761913523E+00, 5.4115394032E+00, 1.2416847781E+00, 9.1267913982E-01, 7.4068292740E-01],
	[1.7790000000E+04, 9.4800017638E+00, 5.4113362161E+00, 1.2428062726E+00, 9.1331450072E-01, 7.4079598658E-01],
	[1.7795000000E+04, 9.4838126361E+00, 5.4111330938E+00, 1.2439284641E+00, 9.1395000572E-01, 7.4090901120E-01],
	[1.7800000000E+04, 9.4876239691E+00, 5.4109300362E+00, 1.2450513529E+00, 9.1458565466E-01, 7.4102200124E-01],
	[1.7805000000E+04, 9.4914357626E+00, 5.4107270433E+00, 1.2461749391E+00, 9.1522144736E-01, 7.4113495671E-01],
	[1.7810000000E+04, 9.4952480167E+00, 5.4105241149E+00, 1.2472992231E+00, 9.1585738365E-01, 7.4124787759E-01],
	[1.7815000000E+04, 9.4990607312E+00, 5.4103212511E+00, 1.2484242051E+00, 9.1649346336E-01, 7.4136076388E-01],
	[1.7820000000E+04, 9.5028739061E+00, 5.4101184519E+00, 1.2495498852E+00, 9.1712968632E-01, 7.4147361556E-01],
	[1.7825000000E+04, 9.5066875413E+00, 5.4099157171E+00, 1.2506762637E+00, 9.1776605236E-01, 7.4158643264E-01],
	[1.7830000000E+04, 9.5105016367E+00, 5.4097130468E+00, 1.2518033410E+00, 9.1840256131E-01, 7.4169921511E-01],
	[1.7835000000E+04, 9.5143161923E+00, 5.4095104409E+00, 1.2529311171E+00, 9.1903921300E-01, 7.4181196296E-01],
	[1.7840000000E+04, 9.5181312080E+00, 5.4093078994E+00, 1.2540595924E+00, 9.1967600726E-01, 7.4192467618E-01],
	[1.7845000000E+04, 9.5219466836E+00, 5.4091054222E+00, 1.2551887670E+00, 9.2031294391E-01, 7.4203735477E-01],
	[1.7850000000E+04, 9.5257626192E+00, 5.4089030093E+00, 1.2563186413E+00, 9.2095002280E-01, 7.4214999872E-01],
	[1.7855000000E+04, 9.5295790147E+00, 5.4087006607E+00, 1.2574492154E+00, 9.2158724373E-01, 7.4226260802E-01],
	[1.7860000000E+04, 9.5333958699E+00, 5.4084983763E+00, 1.2585804897E+00, 9.2222460655E-01, 7.4237518267E-01],
	[1.7865000000E+04, 9.5372131849E+00, 5.4082961561E+00, 1.2597124642E+00, 9.2286211109E-01, 7.4248772266E-01],
	[1.7870000000E+04, 9.5410309595E+00, 5.4080940000E+00, 1.2608451393E+00, 9.2349975717E-01, 7.4260022798E-01],
	[1.7875000000E+04, 9.5448491936E+00, 5.4078919081E+00, 1.2619785152E+00, 9.2413754462E-01, 7.4271269863E-01],
	[1.7880000000E+04, 9.5486678873E+00, 5.4076898802E+00, 1.2631125922E+00, 9.2477547327E-01, 7.4282513460E-01],
	[1.7885000000E+04, 9.5524870404E+00, 5.4074879163E+00, 1.2642473704E+00, 9.2541354295E-01, 7.4293753589E-01],
	[1.7890000000E+04, 9.5563066528E+00, 5.4072860165E+00, 1.2653828501E+00, 9.2605175348E-01, 7.4304990249E-01],
	[1.7895000000E+04, 9.5601267245E+00, 5.4070841806E+00, 1.2665190316E+00, 9.2669010471E-01, 7.4316223439E-01],
	[1.7900000000E+04, 9.5639472554E+00, 5.4068824086E+00, 1.2676559151E+00, 9.2732859645E-01, 7.4327453158E-01],
	[1.7905000000E+04, 9.5677682454E+00, 5.4066807005E+00, 1.2687935008E+00, 9.2796722853E-01, 7.4338679407E-01],
	[1.7910000000E+04, 9.5715896945E+00, 5.4064790562E+00, 1.2699317890E+00, 9.2860600079E-01, 7.4349902184E-01],
	[1.7915000000E+04, 9.5754116026E+00, 5.4062774758E+00, 1.2710707798E+00, 9.2924491305E-01, 7.4361121488E-01],
	[1.7920000000E+04, 9.5792339695E+00, 5.4060759591E+00, 1.2722104736E+00, 9.2988396514E-01, 7.4372337320E-01],
	[1.7925000000E+04, 9.5830567953E+00, 5.4058745061E+00, 1.2733508706E+00, 9.3052315689E-01, 7.4383549678E-01],
	[1.7930000000E+04, 9.5868800799E+00, 5.4056731168E+00, 1.2744919709E+00, 9.3116248812E-01, 7.4394758562E-01],
	[1.7935000000E+04, 9.5907038232E+00, 5.4054717912E+00, 1.2756337750E+00, 9.3180195867E-01, 7.4405963971E-01],
	[1.7940000000E+04, 9.5945280250E+00, 5.4052705292E+00, 1.2767762829E+00, 9.3244156836E-01, 7.4417165905E-01],
	[1.7945000000E+04, 9.5983666402E+00, 5.4050741179E+00, 1.2779194949E+00, 9.3308159157E-01, 7.4428364363E-01],
	[1.7950000000E+04, 9.6022073687E+00, 5.4048783334E+00, 1.2790634113E+00, 9.3372178660E-01, 7.4439559345E-01],
	[1.7955000000E+04, 9.6060485638E+00, 5.4046826106E+00, 1.2802080323E+00, 9.3436212090E-01, 7.4450750850E-01],
	[1.7960000000E+04, 9.6098902253E+00, 5.4044869493E+00, 1.2813533581E+00, 9.3500259432E-01, 7.4461938876E-01],
	[1.7965000000E+04, 9.6137323532E+00, 5.4042913496E+00, 1.2824993890E+00, 9.3564320667E-01, 7.4473123425E-01],
	[1.7970000000E+04, 9.6175749474E+00, 5.4040958114E+00, 1.2836461252E+00, 9.3628395779E-01, 7.4484304494E-01],
	[1.7975000000E+04, 9.6214180078E+00, 5.4039003347E+00, 1.2847935669E+00, 9.3692484751E-01, 7.4495482085E-01],
	[1.7980000000E+04, 9.6252615343E+00, 5.4037049194E+00, 1.2859417144E+00, 9.3756587564E-01, 7.4506656195E-01],
	[1.7985000000E+04, 9.6291055269E+00, 5.4035095655E+00, 1.2870905680E+00, 9.3820704203E-01, 7.4517826824E-01],
	[1.7990000000E+04, 9.6329499855E+00, 5.4033142730E+00, 1.2882401278E+00, 9.3884834650E-01, 7.4528993972E-01],
	[1.7995000000E+04, 9.6367949100E+00, 5.4031190418E+00, 1.2893903941E+00, 9.3948978887E-01, 7.4540157639E-01],
	[1.8000000000E+04, 9.6406403004E+00, 5.4029238719E+00, 1.2905413671E+00, 9.4013136899E-01, 7.4551317823E-01],
	[1.8005000000E+04, 9.6444861566E+00, 5.4027287632E+00, 1.2916930471E+00, 9.4077308666E-01, 7.4562474524E-01],
	[1.8010000000E+04, 9.6483324784E+00, 5.4025337158E+00, 1.2928454343E+00, 9.4141494173E-01, 7.4573627742E-01],
	[1.8015000000E+04, 9.6521792659E+00, 5.4023387295E+00, 1.2939985289E+00, 9.4205693402E-01, 7.4584777476E-01],
	[1.8020000000E+04, 9.6560265190E+00, 5.4021438044E+00, 1.2951523313E+00, 9.4269906336E-01, 7.4595923725E-01],
	[1.8025000000E+04, 9.6598742375E+00, 5.4019489404E+00, 1.2963068415E+00, 9.4334132958E-01, 7.4607066490E-01],
	[1.8030000000E+04, 9.6637224215E+00, 5.4017541375E+00, 1.2974620599E+00, 9.4398373250E-01, 7.4618205768E-01],
	[1.8035000000E+04, 9.6675710708E+00, 5.4015593956E+00, 1.2986179867E+00, 9.4462627196E-01, 7.4629341560E-01],
	[1.8040000000E+04, 9.6714201854E+00, 5.4013647147E+00, 1.2997746221E+00, 9.4526894778E-01, 7.4640473866E-01],
	[1.8045000000E+04, 9.6752697651E+00, 5.4011700948E+00, 1.3009319664E+00, 9.4591175979E-01, 7.4651602684E-01],
	[1.8050000000E+04, 9.6791198100E+00, 5.4009755357E+00, 1.3020900198E+00, 9.4655470781E-01, 7.4662728014E-01],
	[1.8055000000E+04, 9.6829703200E+00, 5.4007810376E+00, 1.3032487826E+00, 9.4719779168E-01, 7.4673849856E-01],
	[1.8060000000E+04, 9.6868212949E+00, 5.4005866004E+00, 1.3044082549E+00, 9.4784101123E-01, 7.4684968209E-01],
	[1.8065000000E+04, 9.6906727347E+00, 5.4003922239E+00, 1.3055684371E+00, 9.4848436627E-01, 7.4696083073E-01],
	[1.8070000000E+04, 9.6945246394E+00, 5.4001979083E+00, 1.3067293293E+00, 9.4912785665E-01, 7.4707194447E-01],
	[1.8075000000E+04, 9.6983770088E+00, 5.4000036534E+00, 1.3078909318E+00, 9.4977148218E-01, 7.4718302330E-01],
	[1.8080000000E+04, 9.7022298429E+00, 5.3998094592E+00, 1.3090532448E+00, 9.5041524270E-01, 7.4729406722E-01],
	[1.8085000000E+04, 9.7060831417E+00, 5.3996153257E+00, 1.3102162686E+00, 9.5105913802E-01, 7.4740507623E-01],
	[1.8090000000E+04, 9.7099369049E+00, 5.3994212528E+00, 1.3113800034E+00, 9.5170316799E-01, 7.4751605031E-01],
	[1.8095000000E+04, 9.7137911327E+00, 5.3992272406E+00, 1.3125444495E+00, 9.5234733242E-01, 7.4762698947E-01],
	[1.8100000000E+04, 9.7176458248E+00, 5.3990332889E+00, 1.3137096070E+00, 9.5299163115E-01, 7.4773789370E-01],
	[1.8105000000E+04, 9.7215009813E+00, 5.3988393977E+00, 1.3148754763E+00, 9.5363606400E-01, 7.4784876300E-01],
	[1.8110000000E+04, 9.7253566020E+00, 5.3986455670E+00, 1.3160420575E+00, 9.5428063080E-01, 7.4795959735E-01],
	[1.8115000000E+04, 9.7292126869E+00, 5.3984517968E+00, 1.3172093509E+00, 9.5492533138E-01, 7.4807039676E-01],
	[1.8120000000E+04, 9.7330692359E+00, 5.3982580871E+00, 1.3183773568E+00, 9.5557016556E-01, 7.4818116121E-01],
	[1.8125000000E+04, 9.7369262489E+00, 5.3980644377E+00, 1.3195460753E+00, 9.5621513318E-01, 7.4829189072E-01],
	[1.8130000000E+04, 9.7407837260E+00, 5.3978708487E+00, 1.3207155067E+00, 9.5686023405E-01, 7.4840258526E-01],
	[1.8135000000E+04, 9.7446416669E+00, 5.3976773200E+00, 1.3218856513E+00, 9.5750546801E-01, 7.4851324483E-01],
	[1.8140000000E+04, 9.7485000716E+00, 5.3974838516E+00, 1.3230565092E+00, 9.5815083488E-01, 7.4862386944E-01],
	[1.8145000000E+04, 9.7523589401E+00, 5.3972904434E+00, 1.3242280808E+00, 9.5879633449E-01, 7.4873445907E-01],
	[1.8150000000E+04, 9.7562182722E+00, 5.3970970955E+00, 1.3254003662E+00, 9.5944196667E-01, 7.4884501372E-01],
	[1.8155000000E+04, 9.7600780680E+00, 5.3969038077E+00, 1.3265733658E+00, 9.6008773124E-01, 7.4895553339E-01],
	[1.8160000000E+04, 9.7639383272E+00, 5.3967105801E+00, 1.3277470796E+00, 9.6073362804E-01, 7.4906601806E-01],
	[1.8165000000E+04, 9.7677990500E+00, 5.3965174126E+00, 1.3289215081E+00, 9.6137965688E-01, 7.4917646775E-01],
	[1.8170000000E+04, 9.7716602361E+00, 5.3963243051E+00, 1.3300966513E+00, 9.6202581760E-01, 7.4928688243E-01],
	[1.8175000000E+04, 9.7755218856E+00, 5.3961312577E+00, 1.3312725096E+00, 9.6267211002E-01, 7.4939726211E-01],
	[1.8180000000E+04, 9.7793839983E+00, 5.3959382703E+00, 1.3324490832E+00, 9.6331853398E-01, 7.4950760679E-01],
	[1.8185000000E+04, 9.7832465741E+00, 5.3957453429E+00, 1.3336263723E+00, 9.6396508928E-01, 7.4961791645E-01],
	[1.8190000000E+04, 9.7871096131E+00, 5.3955524754E+00, 1.3348043772E+00, 9.6461177578E-01, 7.4972819109E-01],
	[1.8195000000E+04, 9.7909731151E+00, 5.3953596678E+00, 1.3359830981E+00, 9.6525859328E-01, 7.4983843071E-01],
	[1.8200000000E+04, 9.7948370801E+00, 5.3951669201E+00, 1.3371625352E+00, 9.6590554162E-01, 7.4994863531E-01],
	[1.8205000000E+04, 9.7987015079E+00, 5.3949742322E+00, 1.3383426888E+00, 9.6655262062E-01, 7.5005880488E-01],
	[1.8210000000E+04, 9.8025663986E+00, 5.3947816041E+00, 1.3395235591E+00, 9.6719983011E-01, 7.5016893941E-01],
	[1.8215000000E+04, 9.8064317520E+00, 5.3945890357E+00, 1.3407051464E+00, 9.6784716992E-01, 7.5027903890E-01],
	[1.8220000000E+04, 9.8102975680E+00, 5.3943965271E+00, 1.3418874508E+00, 9.6849463987E-01, 7.5038910334E-01],
	[1.8225000000E+04, 9.8141638467E+00, 5.3942040782E+00, 1.3430704727E+00, 9.6914223979E-01, 7.5049913274E-01],
	[1.8230000000E+04, 9.8180326925E+00, 5.3940123788E+00, 1.3442542122E+00, 9.6979001234E-01, 7.5060912709E-01],
	[1.8235000000E+04, 9.8219159908E+00, 5.3938253225E+00, 1.3454386697E+00, 9.7043819955E-01, 7.5071908638E-01],
	[1.8240000000E+04, 9.8257997598E+00, 5.3936383240E+00, 1.3466238453E+00, 9.7108651687E-01, 7.5082901061E-01],
	[1.8245000000E+04, 9.8296839993E+00, 5.3934513832E+00, 1.3478097393E+00, 9.7173496414E-01, 7.5093889977E-01],
	[1.8250000000E+04, 9.8335687094E+00, 5.3932645002E+00, 1.3489963518E+00, 9.7238354120E-01, 7.5104875387E-01],
	[1.8255000000E+04, 9.8374538900E+00, 5.3930776748E+00, 1.3501836833E+00, 9.7303224785E-01, 7.5115857289E-01],
	[1.8260000000E+04, 9.8413395409E+00, 5.3928909070E+00, 1.3513717338E+00, 9.7368108394E-01, 7.5126835683E-01],
	[1.8265000000E+04, 9.8452256622E+00, 5.3927041968E+00, 1.3525605037E+00, 9.7433004929E-01, 7.5137810569E-01],
	[1.8270000000E+04, 9.8491122537E+00, 5.3925175442E+00, 1.3537499932E+00, 9.7497914371E-01, 7.5148781946E-01],
	[1.8275000000E+04, 9.8529993153E+00, 5.3923309491E+00, 1.3549402024E+00, 9.7562836706E-01, 7.5159749815E-01],
	[1.8280000000E+04, 9.8568868471E+00, 5.3921444115E+00, 1.3561311317E+00, 9.7627771914E-01, 7.5170714174E-01],
	[1.8285000000E+04, 9.8607748489E+00, 5.3919579314E+00, 1.3573227813E+00, 9.7692719978E-01, 7.5181675023E-01],
	[1.8290000000E+04, 9.8646633206E+00, 5.3917715087E+00, 1.3585151514E+00, 9.7757680882E-01, 7.5192632362E-01],
	[1.8295000000E+04, 9.8685522622E+00, 5.3915851435E+00, 1.3597082423E+00, 9.7822654607E-01, 7.5203586190E-01],
	[1.8300000000E+04, 9.8724416736E+00, 5.3913988356E+00, 1.3609020541E+00, 9.7887641137E-01, 7.5214536508E-01],
	[1.8305000000E+04, 9.8763315548E+00, 5.3912125850E+00, 1.3620965873E+00, 9.7952640454E-01, 7.5225483314E-01],
	[1.8310000000E+04, 9.8802219056E+00, 5.3910263917E+00, 1.3632918418E+00, 9.8017652541E-01, 7.5236426608E-01],
	[1.8315000000E+04, 9.8841127261E+00, 5.3908402557E+00, 1.3644878181E+00, 9.8082677380E-01, 7.5247366390E-01],
	[1.8320000000E+04, 9.8880040160E+00, 5.3906541769E+00, 1.3656845164E+00, 9.8147714954E-01, 7.5258302659E-01],
	[1.8325000000E+04, 9.8918957754E+00, 5.3904681553E+00, 1.3668819368E+00, 9.8212765246E-01, 7.5269235416E-01],
	[1.8330000000E+04, 9.8957880042E+00, 5.3902821909E+00, 1.3680800797E+00, 9.8277828238E-01, 7.5280164659E-01],
	[1.8335000000E+04, 9.8996807023E+00, 5.3900962836E+00, 1.3692789452E+00, 9.8342903914E-01, 7.5291090388E-01],
	[1.8340000000E+04, 9.9035738696E+00, 5.3899104334E+00, 1.3704785337E+00, 9.8407992255E-01, 7.5302012604E-01],
	[1.8345000000E+04, 9.9074675061E+00, 5.3897246403E+00, 1.3716788453E+00, 9.8473093244E-01, 7.5312931305E-01],
	[1.8350000000E+04, 9.9113616117E+00, 5.3895389042E+00, 1.3728798803E+00, 9.8538206864E-01, 7.5323846491E-01],
	[1.8355000000E+04, 9.9152561863E+00, 5.3893532251E+00, 1.3740816388E+00, 9.8603333097E-01, 7.5334758162E-01],
	[1.8360000000E+04, 9.9191512298E+00, 5.3891676030E+00, 1.3752841213E+00, 9.8668471927E-01, 7.5345666318E-01],
	[1.8365000000E+04, 9.9230467423E+00, 5.3889820378E+00, 1.3764873278E+00, 9.8733623336E-01, 7.5356570957E-01],
	[1.8370000000E+04, 9.9269427235E+00, 5.3887965295E+00, 1.3776912587E+00, 9.8798787305E-01, 7.5367472081E-01],
	[1.8375000000E+04, 9.9308391735E+00, 5.3886110781E+00, 1.3788959142E+00, 9.8863963819E-01, 7.5378369688E-01],
	[1.8380000000E+04, 9.9347360922E+00, 5.3884256835E+00, 1.3801012945E+00, 9.8929152859E-01, 7.5389263778E-01],
	[1.8385000000E+04, 9.9386334794E+00, 5.3882403457E+00, 1.3813073998E+00, 9.8994354409E-01, 7.5400154351E-01],
	[1.8390000000E+04, 9.9425313352E+00, 5.3880550647E+00, 1.3825142304E+00, 9.9059568450E-01, 7.5411041406E-01],
	[1.8395000000E+04, 9.9464296594E+00, 5.3878698405E+00, 1.3837217865E+00, 9.9124794966E-01, 7.5421924943E-01],
	[1.8400000000E+04, 9.9503284521E+00, 5.3876846729E+00, 1.3849300684E+00, 9.9190033939E-01, 7.5432804962E-01],
	[1.8405000000E+04, 9.9542277130E+00, 5.3874995620E+00, 1.3861390764E+00, 9.9255285351E-01, 7.5443681462E-01],
	[1.8410000000E+04, 9.9581274421E+00, 5.3873145077E+00, 1.3873488105E+00, 9.9320549185E-01, 7.5454554443E-01],
	[1.8415000000E+04, 9.9620276395E+00, 5.3871295101E+00, 1.3885592712E+00, 9.9385825424E-01, 7.5465423905E-01],
	[1.8420000000E+04, 9.9659283049E+00, 5.3869445690E+00, 1.3897704585E+00, 9.9451114051E-01, 7.5476289848E-01],
	[1.8425000000E+04, 9.9698294384E+00, 5.3867596845E+00, 1.3909823728E+00, 9.9516415047E-01, 7.5487152270E-01],
	[1.8430000000E+04, 9.9737310398E+00, 5.3865748564E+00, 1.3921950143E+00, 9.9581728396E-01, 7.5498011173E-01],
	[1.8435000000E+04, 9.9776331091E+00, 5.3863900849E+00, 1.3934083833E+00, 9.9647054079E-01, 7.5508866554E-01],
	[1.8440000000E+04, 9.9815356462E+00, 5.3862053698E+00, 1.3946224799E+00, 9.9712392081E-01, 7.5519718410E-01],
	[1.8445000000E+04, 9.9854386511E+00, 5.3860207111E+00, 1.3958373045E+00, 9.9777742383E-01, 7.5530566737E-01],
	[1.8450000000E+04, 9.9893421236E+00, 5.3858361088E+00, 1.3970528572E+00, 9.9843104967E-01, 7.5541411535E-01],
	[1.8455000000E+04, 9.9932460638E+00, 5.3856515628E+00, 1.3982691382E+00, 9.9908479817E-01, 7.5552252803E-01],
	[1.8460000000E+04, 9.9971504715E+00, 5.3854670731E+00, 1.3994861479E+00, 9.9973866914E-01, 7.5563090541E-01],
	[1.8465000000E+04, 1.0001055347E+01, 5.3852826397E+00, 1.4007038865E+00, 1.0003926624E+00, 7.5573924749E-01],
	[1.8470000000E+04, 1.0004960689E+01, 5.3850982626E+00, 1.4019223542E+00, 1.0010467778E+00, 7.5584755425E-01],
	[1.8475000000E+04, 1.0008866499E+01, 5.3849139417E+00, 1.4031415512E+00, 1.0017010152E+00, 7.5595582571E-01],
	[1.8480000000E+04, 1.0012772776E+01, 5.3847296770E+00, 1.4043614778E+00, 1.0023553743E+00, 7.5606406186E-01],
	[1.8485000000E+04, 1.0016679520E+01, 5.3845454684E+00, 1.4055821343E+00, 1.0030098551E+00, 7.5617226269E-01],
	[1.8490000000E+04, 1.0020586732E+01, 5.3843613159E+00, 1.4068035208E+00, 1.0036644573E+00, 7.5628042820E-01],
	[1.8495000000E+04, 1.0024494410E+01, 5.3841772195E+00, 1.4080256376E+00, 1.0043191807E+00, 7.5638855839E-01],
	[1.8500000000E+04, 1.0028402556E+01, 5.3839931792E+00, 1.4092484849E+00, 1.0049740253E+00, 7.5649665325E-01],
	[1.8505000000E+04, 1.0032311168E+01, 5.3838091949E+00, 1.4104720630E+00, 1.0056289907E+00, 7.5660471279E-01],
	[1.8510000000E+04, 1.0036220247E+01, 5.3836252666E+00, 1.4116963721E+00, 1.0062840769E+00, 7.5671273699E-01],
	[1.8515000000E+04, 1.0040129793E+01, 5.3834413943E+00, 1.4129214125E+00, 1.0069392836E+00, 7.5682072586E-01],
	[1.8520000000E+04, 1.0044039805E+01, 5.3832575778E+00, 1.4141471844E+00, 1.0075946107E+00, 7.5692867940E-01],
	[1.8525000000E+04, 1.0047957539E+01, 5.3830760898E+00, 1.4153736880E+00, 1.0082502108E+00, 7.5703659759E-01],
	[1.8530000000E+04, 1.0051885081E+01, 5.3828975809E+00, 1.4166009236E+00, 1.0089061280E+00, 7.5714448045E-01],
	[1.8535000000E+04, 1.0055813098E+01, 5.3827191260E+00, 1.4178288914E+00, 1.0095621658E+00, 7.5725232795E-01],
	[1.8540000000E+04, 1.0059741589E+01, 5.3825407252E+00, 1.4190575916E+00, 1.0102183239E+00, 7.5736014011E-01],
	[1.8545000000E+04, 1.0063670556E+01, 5.3823623784E+00, 1.4202870245E+00, 1.0108746023E+00, 7.5746791692E-01],
	[1.8550000000E+04, 1.0067599997E+01, 5.3821840856E+00, 1.4215171904E+00, 1.0115310007E+00, 7.5757565838E-01],
	[1.8555000000E+04, 1.0071529913E+01, 5.3820058467E+00, 1.4227480894E+00, 1.0121875189E+00, 7.5768336448E-01],
	[1.8560000000E+04, 1.0075460303E+01, 5.3818276618E+00, 1.4239797218E+00, 1.0128441569E+00, 7.5779103522E-01],
	[1.8565000000E+04, 1.0079391168E+01, 5.3816495308E+00, 1.4252120879E+00, 1.0135009143E+00, 7.5789867060E-01],
	[1.8570000000E+04, 1.0083322507E+01, 5.3814714536E+00, 1.4264451878E+00, 1.0141577911E+00, 7.5800627062E-01],
	[1.8575000000E+04, 1.0087254321E+01, 5.3812934303E+00, 1.4276790219E+00, 1.0148147870E+00, 7.5811383527E-01],
	[1.8580000000E+04, 1.0091186609E+01, 5.3811154607E+00, 1.4289135903E+00, 1.0154719020E+00, 7.5822136455E-01],
	[1.8585000000E+04, 1.0095119371E+01, 5.3809375449E+00, 1.4301488933E+00, 1.0161291357E+00, 7.5832885846E-01],
	[1.8590000000E+04, 1.0099052608E+01, 5.3807596829E+00, 1.4313849312E+00, 1.0167864881E+00, 7.5843631700E-01],
	[1.8595000000E+04, 1.0102986318E+01, 5.3805818746E+00, 1.4326217041E+00, 1.0174439590E+00, 7.5854374016E-01],
	[1.8600000000E+04, 1.0106920503E+01, 5.3804041199E+00, 1.4338592124E+00, 1.0181015481E+00, 7.5865112794E-01],
	[1.8605000000E+04, 1.0110855161E+01, 5.3802264189E+00, 1.4350974562E+00, 1.0187592553E+00, 7.5875848034E-01],
	[1.8610000000E+04, 1.0114790294E+01, 5.3800487715E+00, 1.4363364358E+00, 1.0194170805E+00, 7.5886579736E-01],
	[1.8615000000E+04, 1.0118725900E+01, 5.3798711777E+00, 1.4375761515E+00, 1.0200750235E+00, 7.5897307899E-01],
	[1.8620000000E+04, 1.0122661980E+01, 5.3796936375E+00, 1.4388166034E+00, 1.0207330840E+00, 7.5908032524E-01],
	[1.8625000000E+04, 1.0126598533E+01, 5.3795161508E+00, 1.4400577918E+00, 1.0213912620E+00, 7.5918753609E-01],
	[1.8630000000E+04, 1.0130535560E+01, 5.3793387175E+00, 1.4412997170E+00, 1.0220495572E+00, 7.5929471155E-01],
	[1.8635000000E+04, 1.0134473061E+01, 5.3791613378E+00, 1.4425423791E+00, 1.0227079695E+00, 7.5940185161E-01],
	[1.8640000000E+04, 1.0138411035E+01, 5.3789840115E+00, 1.4437857785E+00, 1.0233664986E+00, 7.5950895628E-01],
	[1.8645000000E+04, 1.0142349483E+01, 5.3788067385E+00, 1.4450299154E+00, 1.0240251445E+00, 7.5961602555E-01],
	[1.8650000000E+04, 1.0146288404E+01, 5.3786295190E+00, 1.4462747899E+00, 1.0246839069E+00, 7.5972305942E-01],
	[1.8655000000E+04, 1.0150227798E+01, 5.3784523528E+00, 1.4475204024E+00, 1.0253427857E+00, 7.5983005788E-01],
	[1.8660000000E+04, 1.0154167665E+01, 5.3782752399E+00, 1.4487667531E+00, 1.0260017807E+00, 7.5993702094E-01],
	[1.8665000000E+04, 1.0158108006E+01, 5.3780981803E+00, 1.4500138422E+00, 1.0266608917E+00, 7.6004394859E-01],
	[1.8670000000E+04, 1.0162048819E+01, 5.3779211739E+00, 1.4512616700E+00, 1.0273201185E+00, 7.6015084083E-01],
	[1.8675000000E+04, 1.0165990106E+01, 5.3777442207E+00, 1.4525102367E+00, 1.0279794610E+00, 7.6025769766E-01],
	[1.8680000000E+04, 1.0169931865E+01, 5.3775673208E+00, 1.4537595425E+00, 1.0286389190E+00, 7.6036451907E-01],
	[1.8685000000E+04, 1.0173874097E+01, 5.3773904740E+00, 1.4550095877E+00, 1.0292984924E+00, 7.6047130507E-01],
	[1.8690000000E+04, 1.0177816802E+01, 5.3772136803E+00, 1.4562603725E+00, 1.0299581808E+00, 7.6057805565E-01],
	[1.8695000000E+04, 1.0181759980E+01, 5.3770369398E+00, 1.4575118972E+00, 1.0306179842E+00, 7.6068477081E-01],
	[1.8700000000E+04, 1.0185703630E+01, 5.3768602523E+00, 1.4587641620E+00, 1.0312779025E+00, 7.6079145054E-01],
	[1.8705000000E+04, 1.0189647753E+01, 5.3766836178E+00, 1.4600171671E+00, 1.0319379353E+00, 7.6089809486E-01],
	[1.8710000000E+04, 1.0193592348E+01, 5.3765070364E+00, 1.4612709509E+00, 1.0325981016E+00, 7.6100470374E-01],
	[1.8715000000E+04, 1.0197537416E+01, 5.3763305079E+00, 1.4625255496E+00, 1.0332584191E+00, 7.6111127721E-01],
	[1.8720000000E+04, 1.0201482956E+01, 5.3761540324E+00, 1.4637808895E+00, 1.0339188508E+00, 7.6121781524E-01],
	[1.8725000000E+04, 1.0205428968E+01, 5.3759776098E+00, 1.4650369709E+00, 1.0345793964E+00, 7.6132431784E-01],
	[1.8730000000E+04, 1.0209375452E+01, 5.3758012401E+00, 1.4662937940E+00, 1.0352400558E+00, 7.6143078501E-01],
	[1.8735000000E+04, 1.0213322409E+01, 5.3756249233E+00, 1.4675513590E+00, 1.0359008288E+00, 7.6153721674E-01],
	[1.8740000000E+04, 1.0217269838E+01, 5.3754486593E+00, 1.4688096662E+00, 1.0365617152E+00, 7.6164361304E-01],
	[1.8745000000E+04, 1.0221217738E+01, 5.3752724480E+00, 1.4700687159E+00, 1.0372227149E+00, 7.6174997390E-01],
	[1.8750000000E+04, 1.0225166111E+01, 5.3750962896E+00, 1.4713285082E+00, 1.0378838277E+00, 7.6185629932E-01],
	[1.8755000000E+04, 1.0229114956E+01, 5.3749201839E+00, 1.4725890434E+00, 1.0385450533E+00, 7.6196258929E-01],
	[1.8760000000E+04, 1.0233064272E+01, 5.3747441309E+00, 1.4738503218E+00, 1.0392063917E+00, 7.6206884383E-01],
	[1.8765000000E+04, 1.0237014060E+01, 5.3745681306E+00, 1.4751123435E+00, 1.0398678426E+00, 7.6217506292E-01],
	[1.8770000000E+04, 1.0240964319E+01, 5.3743921829E+00, 1.4763751089E+00, 1.0405294060E+00, 7.6228124657E-01],
	[1.8775000000E+04, 1.0244915051E+01, 5.3742162879E+00, 1.4776386181E+00, 1.0411910815E+00, 7.6238739477E-01],
	[1.8780000000E+04, 1.0248866253E+01, 5.3740404454E+00, 1.4789028715E+00, 1.0418528690E+00, 7.6249350752E-01],
	[1.8785000000E+04, 1.0252817927E+01, 5.3738646555E+00, 1.4801678692E+00, 1.0425147684E+00, 7.6259958481E-01],
	[1.8790000000E+04, 1.0256770073E+01, 5.3736889182E+00, 1.4814336114E+00, 1.0431767795E+00, 7.6270562666E-01],
	[1.8795000000E+04, 1.0260722690E+01, 5.3735132333E+00, 1.4827000985E+00, 1.0438389021E+00, 7.6281163306E-01],
	[1.8800000000E+04, 1.0264675778E+01, 5.3733376009E+00, 1.4839673306E+00, 1.0445011360E+00, 7.6291760399E-01],
	[1.8805000000E+04, 1.0268629337E+01, 5.3731620210E+00, 1.4852353081E+00, 1.0451634810E+00, 7.6302353948E-01],
	[1.8810000000E+04, 1.0272583367E+01, 5.3729864935E+00, 1.4865040311E+00, 1.0458259370E+00, 7.6312943950E-01],
	[1.8815000000E+04, 1.0276537869E+01, 5.3728110183E+00, 1.4877734998E+00, 1.0464885038E+00, 7.6323530407E-01],
	[1.8820000000E+04, 1.0280492841E+01, 5.3726355955E+00, 1.4890437146E+00, 1.0471511813E+00, 7.6334113318E-01],
	[1.8825000000E+04, 1.0284461943E+01, 5.3724643159E+00, 1.4903146756E+00, 1.0478142665E+00, 7.6344692682E-01],
	[1.8830000000E+04, 1.0288434963E+01, 5.3722941172E+00, 1.4915863832E+00, 1.0484775376E+00, 7.6355268501E-01],
	[1.8835000000E+04, 1.0292408463E+01, 5.3721239690E+00, 1.4928588375E+00, 1.0491409195E+00, 7.6365840772E-01],
	[1.8840000000E+04, 1.0296382441E+01, 5.3719538713E+00, 1.4941320387E+00, 1.0498044121E+00, 7.6376409498E-01],
	[1.8845000000E+04, 1.0300356899E+01, 5.3717838242E+00, 1.4954059872E+00, 1.0504680151E+00, 7.6386974677E-01],
	[1.8850000000E+04, 1.0304331836E+01, 5.3716138275E+00, 1.4966806831E+00, 1.0511317283E+00, 7.6397536309E-01],
	[1.8855000000E+04, 1.0308307253E+01, 5.3714438814E+00, 1.4979561268E+00, 1.0517955518E+00, 7.6408094394E-01],
	[1.8860000000E+04, 1.0312283148E+01, 5.3712739856E+00, 1.4992323183E+00, 1.0524594851E+00, 7.6418648932E-01],
	[1.8865000000E+04, 1.0316259522E+01, 5.3711041403E+00, 1.5005092581E+00, 1.0531235282E+00, 7.6429199923E-01],
	[1.8870000000E+04, 1.0320236375E+01, 5.3709343453E+00, 1.5017869462E+00, 1.0537876809E+00, 7.6439747368E-01],
	[1.8875000000E+04, 1.0324213707E+01, 5.3707646007E+00, 1.5030653831E+00, 1.0544519430E+00, 7.6450291264E-01],
	[1.8880000000E+04, 1.0328191518E+01, 5.3705949064E+00, 1.5043445688E+00, 1.0551163144E+00, 7.6460831614E-01],
	[1.8885000000E+04, 1.0332169808E+01, 5.3704252625E+00, 1.5056245036E+00, 1.0557807948E+00, 7.6471368416E-01],
	[1.8890000000E+04, 1.0336148576E+01, 5.3702556687E+00, 1.5069051879E+00, 1.0564453841E+00, 7.6481901670E-01],
	[1.8895000000E+04, 1.0340127822E+01, 5.3700861252E+00, 1.5081866217E+00, 1.0571100822E+00, 7.6492431377E-01],
	[1.8900000000E+04, 1.0344107548E+01, 5.3699166320E+00, 1.5094688054E+00, 1.0577748887E+00, 7.6502957536E-01],
	[1.8905000000E+04, 1.0348087751E+01, 5.3697471889E+00, 1.5107517392E+00, 1.0584398036E+00, 7.6513480147E-01],
	[1.8910000000E+04, 1.0352068433E+01, 5.3695777959E+00, 1.5120354233E+00, 1.0591048268E+00, 7.6523999210E-01],
	[1.8915000000E+04, 1.0356049593E+01, 5.3694084531E+00, 1.5133198580E+00, 1.0597699579E+00, 7.6534514725E-01],
	[1.8920000000E+04, 1.0360031232E+01, 5.3692391604E+00, 1.5146050436E+00, 1.0604351969E+00, 7.6545026692E-01],
	[1.8925000000E+04, 1.0364013348E+01, 5.3690699177E+00, 1.5158909802E+00, 1.0611005435E+00, 7.6555535111E-01],
	[1.8930000000E+04, 1.0367995943E+01, 5.3689007251E+00, 1.5171776680E+00, 1.0617659976E+00, 7.6566039982E-01],
	[1.8935000000E+04, 1.0371979015E+01, 5.3687315825E+00, 1.5184651075E+00, 1.0624315590E+00, 7.6576541304E-01],
	[1.8940000000E+04, 1.0375962566E+01, 5.3685624899E+00, 1.5197532986E+00, 1.0630972276E+00, 7.6587039078E-01],
	[1.8945000000E+04, 1.0379946594E+01, 5.3683934473E+00, 1.5210422419E+00, 1.0637630031E+00, 7.6597533304E-01],
	[1.8950000000E+04, 1.0383931101E+01, 5.3682244545E+00, 1.5223319373E+00, 1.0644288855E+00, 7.6608023981E-01],
	[1.8955000000E+04, 1.0387916084E+01, 5.3680555117E+00, 1.5236223853E+00, 1.0650948744E+00, 7.6618511109E-01],
	[1.8960000000E+04, 1.0391901546E+01, 5.3678866188E+00, 1.5249135860E+00, 1.0657609697E+00, 7.6628994689E-01],
	[1.8965000000E+04, 1.0395887485E+01, 5.3677177756E+00, 1.5262055396E+00, 1.0664271714E+00, 7.6639474720E-01],
	[1.8970000000E+04, 1.0399873902E+01, 5.3675489823E+00, 1.5274982465E+00, 1.0670934791E+00, 7.6649951203E-01],
	[1.8975000000E+04, 1.0403860796E+01, 5.3673802388E+00, 1.5287917069E+00, 1.0677598927E+00, 7.6660424136E-01],
	[1.8980000000E+04, 1.0407848168E+01, 5.3672115451E+00, 1.5300859209E+00, 1.0684264120E+00, 7.6670893521E-01],
	[1.8985000000E+04, 1.0411836016E+01, 5.3670429011E+00, 1.5313808889E+00, 1.0690930369E+00, 7.6681359357E-01],
	[1.8990000000E+04, 1.0415824343E+01, 5.3668743068E+00, 1.5326766111E+00, 1.0697597672E+00, 7.6691821643E-01],
	[1.8995000000E+04, 1.0419813146E+01, 5.3667057622E+00, 1.5339730876E+00, 1.0704266027E+00, 7.6702280381E-01],
	[1.9000000000E+04, 1.0423802426E+01, 5.3665372672E+00, 1.5352703189E+00, 1.0710935432E+00, 7.6712735570E-01],
	[1.9005000000E+04, 1.0427792184E+01, 5.3663688219E+00, 1.5365683050E+00, 1.0717605886E+00, 7.6723187209E-01],
	[1.9010000000E+04, 1.0431782418E+01, 5.3662004261E+00, 1.5378670463E+00, 1.0724277387E+00, 7.6733635300E-01],
	[1.9015000000E+04, 1.0435773129E+01, 5.3660320799E+00, 1.5391665429E+00, 1.0730949933E+00, 7.6744079841E-01],
	[1.9020000000E+04, 1.0439764318E+01, 5.3658637833E+00, 1.5404667952E+00, 1.0737623522E+00, 7.6754520833E-01],
	[1.9025000000E+04, 1.0443755982E+01, 5.3656955361E+00, 1.5417678033E+00, 1.0744298152E+00, 7.6764958276E-01],
	[1.9030000000E+04, 1.0447748124E+01, 5.3655273385E+00, 1.5430695675E+00, 1.0750973822E+00, 7.6775392170E-01],
	[1.9035000000E+04, 1.0451740742E+01, 5.3653591903E+00, 1.5443720881E+00, 1.0757650531E+00, 7.6785822514E-01],
	[1.9040000000E+04, 1.0455733837E+01, 5.3651910915E+00, 1.5456753652E+00, 1.0764328275E+00, 7.6796249309E-01],
	[1.9045000000E+04, 1.0459727408E+01, 5.3650230422E+00, 1.5469793992E+00, 1.0771007055E+00, 7.6806672555E-01],
	[1.9050000000E+04, 1.0463721456E+01, 5.3648550422E+00, 1.5482841902E+00, 1.0777686867E+00, 7.6817092251E-01],
	[1.9055000000E+04, 1.0467715980E+01, 5.3646870916E+00, 1.5495897385E+00, 1.0784367709E+00, 7.6827508398E-01],
	[1.9060000000E+04, 1.0471710981E+01, 5.3645191902E+00, 1.5508960444E+00, 1.0791049582E+00, 7.6837920996E-01],
	[1.9065000000E+04, 1.0475706457E+01, 5.3643513382E+00, 1.5522031080E+00, 1.0797732481E+00, 7.6848330044E-01],
	[1.9070000000E+04, 1.0479702410E+01, 5.3641835355E+00, 1.5535109296E+00, 1.0804416407E+00, 7.6858735543E-01],
	[1.9075000000E+04, 1.0483698839E+01, 5.3640157819E+00, 1.5548195096E+00, 1.0811101356E+00, 7.6869137492E-01],
	[1.9080000000E+04, 1.0487695744E+01, 5.3638480776E+00, 1.5561288480E+00, 1.0817787328E+00, 7.6879535892E-01],
	[1.9085000000E+04, 1.0491693125E+01, 5.3636804225E+00, 1.5574389452E+00, 1.0824474320E+00, 7.6889930743E-01],
	[1.9090000000E+04, 1.0495690981E+01, 5.3635128165E+00, 1.5587498013E+00, 1.0831162331E+00, 7.6900322044E-01],
	[1.9095000000E+04, 1.0499689314E+01, 5.3633452597E+00, 1.5600614167E+00, 1.0837851359E+00, 7.6910709796E-01],
	[1.9100000000E+04, 1.0503688122E+01, 5.3631777519E+00, 1.5613737915E+00, 1.0844541402E+00, 7.6921093998E-01],
	[1.9105000000E+04, 1.0507687406E+01, 5.3630102933E+00, 1.5626869260E+00, 1.0851232458E+00, 7.6931474651E-01],
	[1.9110000000E+04, 1.0511687165E+01, 5.3628428836E+00, 1.5640008205E+00, 1.0857924526E+00, 7.6941851755E-01],
	[1.9115000000E+04, 1.0515687401E+01, 5.3626755230E+00, 1.5653154752E+00, 1.0864617604E+00, 7.6952225309E-01],
	[1.9120000000E+04, 1.0519688111E+01, 5.3625082114E+00, 1.5666308903E+00, 1.0871311691E+00, 7.6962595314E-01],
	[1.9125000000E+04, 1.0523692825E+01, 5.3623419599E+00, 1.5679470660E+00, 1.0878007576E+00, 7.6972961770E-01],
	[1.9130000000E+04, 1.0527712102E+01, 5.3621797922E+00, 1.5692640027E+00, 1.0884707637E+00, 7.6983324676E-01],
	[1.9135000000E+04, 1.0531731864E+01, 5.3620176718E+00, 1.5705817005E+00, 1.0891408707E+00, 7.6993684033E-01],
	[1.9140000000E+04, 1.0535752109E+01, 5.3618555986E+00, 1.5719001597E+00, 1.0898110787E+00, 7.7004039840E-01],
	[1.9145000000E+04, 1.0539772838E+01, 5.3616935727E+00, 1.5732193805E+00, 1.0904813873E+00, 7.7014392098E-01],
	[1.9150000000E+04, 1.0543794051E+01, 5.3615315939E+00, 1.5745393632E+00, 1.0911517964E+00, 7.7024740808E-01],
	[1.9155000000E+04, 1.0547815748E+01, 5.3613696624E+00, 1.5758601080E+00, 1.0918223058E+00, 7.7035085967E-01],
	[1.9160000000E+04, 1.0551837929E+01, 5.3612077780E+00, 1.5771816152E+00, 1.0924929154E+00, 7.7045427578E-01],
	[1.9165000000E+04, 1.0555860593E+01, 5.3610459407E+00, 1.5785038849E+00, 1.0931636250E+00, 7.7055765640E-01],
	[1.9170000000E+04, 1.0559883741E+01, 5.3608841505E+00, 1.5798269175E+00, 1.0938344344E+00, 7.7066100152E-01],
	[1.9175000000E+04, 1.0563907373E+01, 5.3607224074E+00, 1.5811507131E+00, 1.0945053434E+00, 7.7076431115E-01],
	[1.9180000000E+04, 1.0567931487E+01, 5.3605607114E+00, 1.5824752721E+00, 1.0951763519E+00, 7.7086758530E-01],
	[1.9185000000E+04, 1.0571956086E+01, 5.3603990623E+00, 1.5838005946E+00, 1.0958474596E+00, 7.7097082395E-01],
	[1.9190000000E+04, 1.0575981168E+01, 5.3602374603E+00, 1.5851266809E+00, 1.0965186665E+00, 7.7107402711E-01],
	[1.9195000000E+04, 1.0580006733E+01, 5.3600759052E+00, 1.5864535312E+00, 1.0971899723E+00, 7.7117719475E-01],
	[1.9200000000E+04, 1.0584032781E+01, 5.3599143971E+00, 1.5877811458E+00, 1.0978613768E+00, 7.7128032686E-01],
	[1.9205000000E+04, 1.0588059312E+01, 5.3597529359E+00, 1.5891095250E+00, 1.0985328799E+00, 7.7138342343E-01],
	[1.9210000000E+04, 1.0592086326E+01, 5.3595915216E+00, 1.5904386688E+00, 1.0992044815E+00, 7.7148648448E-01],
	[1.9215000000E+04, 1.0596113824E+01, 5.3594301541E+00, 1.5917685777E+00, 1.0998761812E+00, 7.7158950998E-01],
	[1.9220000000E+04, 1.0600141804E+01, 5.3592688335E+00, 1.5930992518E+00, 1.1005479790E+00, 7.7169249995E-01],
	[1.9225000000E+04, 1.0604170267E+01, 5.3591075597E+00, 1.5944306914E+00, 1.1012198747E+00, 7.7179545437E-01],
	[1.9230000000E+04, 1.0608199213E+01, 5.3589463327E+00, 1.5957628967E+00, 1.1018918681E+00, 7.7189837325E-01],
	[1.9235000000E+04, 1.0612228642E+01, 5.3587851525E+00, 1.5970958680E+00, 1.1025639590E+00, 7.7200125659E-01],
	[1.9240000000E+04, 1.0616258553E+01, 5.3586240190E+00, 1.5984296055E+00, 1.1032361473E+00, 7.7210410438E-01],
	[1.9245000000E+04, 1.0620288947E+01, 5.3584629322E+00, 1.5997641094E+00, 1.1039084327E+00, 7.7220691661E-01],
	[1.9250000000E+04, 1.0624319824E+01, 5.3583018921E+00, 1.6010993800E+00, 1.1045808151E+00, 7.7230969329E-01],
	[1.9255000000E+04, 1.0628351183E+01, 5.3581408987E+00, 1.6024354175E+00, 1.1052532944E+00, 7.7241243442E-01],
	[1.9260000000E+04, 1.0632383024E+01, 5.3579799519E+00, 1.6037722222E+00, 1.1059258703E+00, 7.7251513999E-01],
	[1.9265000000E+04, 1.0636415348E+01, 5.3578190517E+00, 1.6051097943E+00, 1.1065985427E+00, 7.7261781000E-01],
	[1.9270000000E+04, 1.0640448154E+01, 5.3576581981E+00, 1.6064481340E+00, 1.1072713114E+00, 7.7272044444E-01],
	[1.9275000000E+04, 1.0644481442E+01, 5.3574973910E+00, 1.6077872416E+00, 1.1079441762E+00, 7.7282304332E-01],
	[1.9280000000E+04, 1.0648515212E+01, 5.3573366305E+00, 1.6091271174E+00, 1.1086171370E+00, 7.7292560664E-01],
	[1.9285000000E+04, 1.0652549464E+01, 5.3571759165E+00, 1.6104677615E+00, 1.1092901935E+00, 7.7302813438E-01],
	[1.9290000000E+04, 1.0656584198E+01, 5.3570152490E+00, 1.6118091742E+00, 1.1099633456E+00, 7.7313062656E-01],
	[1.9295000000E+04, 1.0660619414E+01, 5.3568546279E+00, 1.6131513558E+00, 1.1106365932E+00, 7.7323308316E-01],
	[1.9300000000E+04, 1.0664655113E+01, 5.3566940533E+00, 1.6144943065E+00, 1.1113099360E+00, 7.7333550419E-01],
	[1.9305000000E+04, 1.0668691292E+01, 5.3565335251E+00, 1.6158380265E+00, 1.1119833739E+00, 7.7343788964E-01],
	[1.9310000000E+04, 1.0672727954E+01, 5.3563730432E+00, 1.6171825160E+00, 1.1126569067E+00, 7.7354023951E-01],
	[1.9315000000E+04, 1.0676765097E+01, 5.3562126077E+00, 1.6185277754E+00, 1.1133305342E+00, 7.7364255380E-01],
	[1.9320000000E+04, 1.0680802722E+01, 5.3560522185E+00, 1.6198738049E+00, 1.1140042562E+00, 7.7374483251E-01],
	[1.9325000000E+04, 1.0684840828E+01, 5.3558918757E+00, 1.6212206046E+00, 1.1146780726E+00, 7.7384707563E-01],
	[1.9330000000E+04, 1.0688879416E+01, 5.3557315791E+00, 1.6225681749E+00, 1.1153519833E+00, 7.7394928317E-01],
	[1.9335000000E+04, 1.0692918485E+01, 5.3555713288E+00, 1.6239165159E+00, 1.1160259879E+00, 7.7405145512E-01],
	[1.9340000000E+04, 1.0696958035E+01, 5.3554111247E+00, 1.6252656280E+00, 1.1167000864E+00, 7.7415359147E-01],
	[1.9345000000E+04, 1.0700998067E+01, 5.3552509668E+00, 1.6266155113E+00, 1.1173742785E+00, 7.7425569224E-01],
	[1.9350000000E+04, 1.0705038580E+01, 5.3550908550E+00, 1.6279661662E+00, 1.1180485642E+00, 7.7435775741E-01],
	[1.9355000000E+04, 1.0709079574E+01, 5.3549307895E+00, 1.6293175927E+00, 1.1187229431E+00, 7.7445978699E-01],
	[1.9360000000E+04, 1.0713121049E+01, 5.3547707700E+00, 1.6306697913E+00, 1.1193974152E+00, 7.7456178097E-01],
	[1.9365000000E+04, 1.0717163005E+01, 5.3546107967E+00, 1.6320227621E+00, 1.1200719803E+00, 7.7466373935E-01],
	[1.9370000000E+04, 1.0721205441E+01, 5.3544508694E+00, 1.6333765053E+00, 1.1207466382E+00, 7.7476566213E-01],
	[1.9375000000E+04, 1.0725248359E+01, 5.3542909882E+00, 1.6347310213E+00, 1.1214213887E+00, 7.7486754931E-01],
	[1.9380000000E+04, 1.0729291758E+01, 5.3541311530E+00, 1.6360863102E+00, 1.1220962316E+00, 7.7496940088E-01],
	[1.9385000000E+04, 1.0733335637E+01, 5.3539713638E+00, 1.6374423723E+00, 1.1227711668E+00, 7.7507121685E-01],
	[1.9390000000E+04, 1.0737379997E+01, 5.3538116206E+00, 1.6387992078E+00, 1.1234461941E+00, 7.7517299721E-01],
	[1.9395000000E+04, 1.0741424837E+01, 5.3536519234E+00, 1.6401568170E+00, 1.1241213133E+00, 7.7527474197E-01],
	[1.9400000000E+04, 1.0745470158E+01, 5.3534922720E+00, 1.6415152001E+00, 1.1247965242E+00, 7.7537645111E-01],
	[1.9405000000E+04, 1.0749515959E+01, 5.3533326666E+00, 1.6428743573E+00, 1.1254718268E+00, 7.7547812465E-01],
	[1.9410000000E+04, 1.0753562241E+01, 5.3531731070E+00, 1.6442342890E+00, 1.1261472207E+00, 7.7557976257E-01],
	[1.9415000000E+04, 1.0757609003E+01, 5.3530135933E+00, 1.6455949953E+00, 1.1268227058E+00, 7.7568136487E-01],
	[1.9420000000E+04, 1.0761656245E+01, 5.3528541255E+00, 1.6469564765E+00, 1.1274982819E+00, 7.7578293156E-01],
	[1.9425000000E+04, 1.0765703968E+01, 5.3526947034E+00, 1.6483187327E+00, 1.1281739490E+00, 7.7588446264E-01],
	[1.9430000000E+04, 1.0769752171E+01, 5.3525353271E+00, 1.6496817644E+00, 1.1288497067E+00, 7.7598595810E-01],
	[1.9435000000E+04, 1.0773812211E+01, 5.3523791113E+00, 1.6510455716E+00, 1.1295258185E+00, 7.7608741793E-01],
	[1.9440000000E+04, 1.0777879517E+01, 5.3522247987E+00, 1.6524101547E+00, 1.1302021785E+00, 7.7618884215E-01],
	[1.9445000000E+04, 1.0781947312E+01, 5.3520705303E+00, 1.6537755139E+00, 1.1308786294E+00, 7.7629023075E-01],
	[1.9450000000E+04, 1.0786015595E+01, 5.3519163060E+00, 1.6551416494E+00, 1.1315551711E+00, 7.7639158372E-01],
	[1.9455000000E+04, 1.0790084367E+01, 5.3517621257E+00, 1.6565085615E+00, 1.1322318034E+00, 7.7649290107E-01],
	[1.9460000000E+04, 1.0794153628E+01, 5.3516079895E+00, 1.6578762503E+00, 1.1329085261E+00, 7.7659418279E-01],
	[1.9465000000E+04, 1.0798223378E+01, 5.3514538973E+00, 1.6592447163E+00, 1.1335853390E+00, 7.7669542889E-01],
	[1.9470000000E+04, 1.0802293616E+01, 5.3512998492E+00, 1.6606139595E+00, 1.1342622420E+00, 7.7679663935E-01],
	[1.9475000000E+04, 1.0806364342E+01, 5.3511458450E+00, 1.6619839802E+00, 1.1349392348E+00, 7.7689781419E-01],
	[1.9480000000E+04, 1.0810435558E+01, 5.3509918848E+00, 1.6633547788E+00, 1.1356163173E+00, 7.7699895341E-01],
	[1.9485000000E+04, 1.0814507261E+01, 5.3508379685E+00, 1.6647263553E+00, 1.1362934894E+00, 7.7710005699E-01],
	[1.9490000000E+04, 1.0818579453E+01, 5.3506840962E+00, 1.6660987101E+00, 1.1369707508E+00, 7.7720112493E-01],
	[1.9495000000E+04, 1.0822652133E+01, 5.3505302677E+00, 1.6674718434E+00, 1.1376481014E+00, 7.7730215725E-01],
	[1.9500000000E+04, 1.0826725301E+01, 5.3503764832E+00, 1.6688457554E+00, 1.1383255410E+00, 7.7740315393E-01],
	[1.9505000000E+04, 1.0830798957E+01, 5.3502227424E+00, 1.6702204464E+00, 1.1390030694E+00, 7.7750411498E-01],
	[1.9510000000E+04, 1.0834873101E+01, 5.3500690455E+00, 1.6715959166E+00, 1.1396806865E+00, 7.7760504039E-01],
	[1.9515000000E+04, 1.0838947734E+01, 5.3499153924E+00, 1.6729721663E+00, 1.1403583921E+00, 7.7770593017E-01],
	[1.9520000000E+04, 1.0843022854E+01, 5.3497617830E+00, 1.6743491957E+00, 1.1410361860E+00, 7.7780678431E-01],
	[1.9525000000E+04, 1.0847098462E+01, 5.3496082175E+00, 1.6757270051E+00, 1.1417140680E+00, 7.7790760281E-01],
	[1.9530000000E+04, 1.0851174558E+01, 5.3494546956E+00, 1.6771055946E+00, 1.1423920379E+00, 7.7800838567E-01],
	[1.9535000000E+04, 1.0855251141E+01, 5.3493012174E+00, 1.6784849646E+00, 1.1430700956E+00, 7.7810913289E-01],
	[1.9540000000E+04, 1.0859328212E+01, 5.3491477829E+00, 1.6798651152E+00, 1.1437482410E+00, 7.7820984448E-01],
	[1.9545000000E+04, 1.0863405771E+01, 5.3489943921E+00, 1.6812460468E+00, 1.1444264737E+00, 7.7831052042E-01],
	[1.9550000000E+04, 1.0867483817E+01, 5.3488410449E+00, 1.6826277595E+00, 1.1451047938E+00, 7.7841116072E-01],
	[1.9555000000E+04, 1.0871562351E+01, 5.3486877413E+00, 1.6840102536E+00, 1.1457832009E+00, 7.7851176538E-01],
	[1.9560000000E+04, 1.0875641372E+01, 5.3485344813E+00, 1.6853935293E+00, 1.1464616949E+00, 7.7861233440E-01],
	[1.9565000000E+04, 1.0879720880E+01, 5.3483812649E+00, 1.6867775869E+00, 1.1471402756E+00, 7.7871286777E-01],
	[1.9570000000E+04, 1.0883800876E+01, 5.3482280920E+00, 1.6881624267E+00, 1.1478189429E+00, 7.7881336550E-01],
	[1.9575000000E+04, 1.0887881358E+01, 5.3480749626E+00, 1.6895480488E+00, 1.1484976966E+00, 7.7891382759E-01],
	[1.9580000000E+04, 1.0891962328E+01, 5.3479218767E+00, 1.6909344535E+00, 1.1491765365E+00, 7.7901425403E-01],
	[1.9585000000E+04, 1.0896043785E+01, 5.3477688343E+00, 1.6923216410E+00, 1.1498554625E+00, 7.7911464482E-01],
	[1.9590000000E+04, 1.0900125729E+01, 5.3476158353E+00, 1.6937096117E+00, 1.1505344742E+00, 7.7921499997E-01],
	[1.9595000000E+04, 1.0904208160E+01, 5.3474628797E+00, 1.6950983657E+00, 1.1512135717E+00, 7.7931531947E-01],
	[1.9600000000E+04, 1.0908291077E+01, 5.3473099676E+00, 1.6964879032E+00, 1.1518927547E+00, 7.7941560333E-01],
	[1.9605000000E+04, 1.0912374482E+01, 5.3471570988E+00, 1.6978782245E+00, 1.1525720230E+00, 7.7951585154E-01],
	[1.9610000000E+04, 1.0916458373E+01, 5.3470042733E+00, 1.6992693300E+00, 1.1532513765E+00, 7.7961606410E-01],
	[1.9615000000E+04, 1.0920542750E+01, 5.3468514912E+00, 1.7006612197E+00, 1.1539308149E+00, 7.7971624101E-01],
	[1.9620000000E+04, 1.0924627615E+01, 5.3466987524E+00, 1.7020538939E+00, 1.1546103382E+00, 7.7981638228E-01],
	[1.9625000000E+04, 1.0928712965E+01, 5.3465460569E+00, 1.7034473529E+00, 1.1552899461E+00, 7.7991648790E-01],
	[1.9630000000E+04, 1.0932798803E+01, 5.3463934046E+00, 1.7048415970E+00, 1.1559696385E+00, 7.8001655786E-01],
	[1.9635000000E+04, 1.0936885126E+01, 5.3462407956E+00, 1.7062366263E+00, 1.1566494151E+00, 7.8011659219E-01],
	[1.9640000000E+04, 1.0940971936E+01, 5.3460882297E+00, 1.7076324411E+00, 1.1573292759E+00, 7.8021659086E-01],
	[1.9645000000E+04, 1.0945059232E+01, 5.3459357071E+00, 1.7090290416E+00, 1.1580092206E+00, 7.8031655388E-01],
	[1.9650000000E+04, 1.0949147015E+01, 5.3457832276E+00, 1.7104264282E+00, 1.1586892491E+00, 7.8041648125E-01],
	[1.9655000000E+04, 1.0953235283E+01, 5.3456307913E+00, 1.7118246010E+00, 1.1593693611E+00, 7.8051637297E-01],
	[1.9660000000E+04, 1.0957324038E+01, 5.3454783981E+00, 1.7132235602E+00, 1.1600495566E+00, 7.8061622905E-01],
	[1.9665000000E+04, 1.0961413278E+01, 5.3453260480E+00, 1.7146233062E+00, 1.1607298353E+00, 7.8071604947E-01],
	[1.9670000000E+04, 1.0965503005E+01, 5.3451737409E+00, 1.7160238391E+00, 1.1614101971E+00, 7.8081583425E-01],
	[1.9675000000E+04, 1.0969593217E+01, 5.3450214769E+00, 1.7174251592E+00, 1.1620906417E+00, 7.8091558337E-01],
	[1.9680000000E+04, 1.0973683915E+01, 5.3448692560E+00, 1.7188272668E+00, 1.1627711691E+00, 7.8101529685E-01],
	[1.9685000000E+04, 1.0977775099E+01, 5.3447170780E+00, 1.7202301620E+00, 1.1634517791E+00, 7.8111497467E-01],
	[1.9690000000E+04, 1.0981866768E+01, 5.3445649430E+00, 1.7216338452E+00, 1.1641324713E+00, 7.8121461685E-01],
	[1.9695000000E+04, 1.0985958923E+01, 5.3444128510E+00, 1.7230383165E+00, 1.1648132458E+00, 7.8131422337E-01],
	[1.9700000000E+04, 1.0990051564E+01, 5.3442608019E+00, 1.7244435763E+00, 1.1654941023E+00, 7.8141379425E-01],
	[1.9705000000E+04, 1.0994144690E+01, 5.3441087957E+00, 1.7258496247E+00, 1.1661750407E+00, 7.8151332948E-01],
	[1.9710000000E+04, 1.0998238301E+01, 5.3439568324E+00, 1.7272564619E+00, 1.1668560607E+00, 7.8161282905E-01],
	[1.9715000000E+04, 1.1002332398E+01, 5.3438049119E+00, 1.7286640883E+00, 1.1675371622E+00, 7.8171229298E-01],
	[1.9720000000E+04, 1.1006426980E+01, 5.3436530343E+00, 1.7300725041E+00, 1.1682183450E+00, 7.8181172126E-01],
	[1.9725000000E+04, 1.1010522047E+01, 5.3435011996E+00, 1.7314817095E+00, 1.1688996090E+00, 7.8191111390E-01],
	[1.9730000000E+04, 1.1014617599E+01, 5.3433494076E+00, 1.7328917048E+00, 1.1695809539E+00, 7.8201047088E-01],
	[1.9735000000E+04, 1.1018713637E+01, 5.3431976584E+00, 1.7343024902E+00, 1.1702623797E+00, 7.8210979221E-01],
	[1.9740000000E+04, 1.1022810159E+01, 5.3430459519E+00, 1.7357140659E+00, 1.1709438861E+00, 7.8220907790E-01],
	[1.9745000000E+04, 1.1026908304E+01, 5.3428945869E+00, 1.7371264322E+00, 1.1716255001E+00, 7.8230832794E-01],
	[1.9750000000E+04, 1.1031024466E+01, 5.3427478672E+00, 1.7385395893E+00, 1.1723076140E+00, 7.8240754234E-01],
	[1.9755000000E+04, 1.1035141122E+01, 5.3426011887E+00, 1.7399535375E+00, 1.1729898089E+00, 7.8250672108E-01],
	[1.9760000000E+04, 1.1039258272E+01, 5.3424545513E+00, 1.7413682770E+00, 1.1736720844E+00, 7.8260586418E-01],
	[1.9765000000E+04, 1.1043375915E+01, 5.3423079550E+00, 1.7427838081E+00, 1.1743544405E+00, 7.8270497164E-01],
	[1.9770000000E+04, 1.1047494053E+01, 5.3421613998E+00, 1.7442001310E+00, 1.1750368769E+00, 7.8280404345E-01],
	[1.9775000000E+04, 1.1051612684E+01, 5.3420148857E+00, 1.7456172459E+00, 1.1757193935E+00, 7.8290307961E-01],
	[1.9780000000E+04, 1.1055731809E+01, 5.3418684127E+00, 1.7470351531E+00, 1.1764019901E+00, 7.8300208013E-01],
	[1.9785000000E+04, 1.1059851427E+01, 5.3417219807E+00, 1.7484538528E+00, 1.1770846666E+00, 7.8310104501E-01],
	[1.9790000000E+04, 1.1063971539E+01, 5.3415755897E+00, 1.7498733452E+00, 1.1777674227E+00, 7.8319997424E-01],
	[1.9795000000E+04, 1.1068092144E+01, 5.3414292397E+00, 1.7512936307E+00, 1.1784502584E+00, 7.8329886783E-01],
	[1.9800000000E+04, 1.1072213243E+01, 5.3412829306E+00, 1.7527147095E+00, 1.1791331733E+00, 7.8339772578E-01],
	[1.9805000000E+04, 1.1076334835E+01, 5.3411366625E+00, 1.7541365817E+00, 1.1798161674E+00, 7.8349654809E-01],
	[1.9810000000E+04, 1.1080456920E+01, 5.3409904354E+00, 1.7555592476E+00, 1.1804992405E+00, 7.8359533475E-01],
	[1.9815000000E+04, 1.1084579499E+01, 5.3408442491E+00, 1.7569827076E+00, 1.1811823923E+00, 7.8369408578E-01],
	[1.9820000000E+04, 1.1088702571E+01, 5.3406981038E+00, 1.7584069617E+00, 1.1818656228E+00, 7.8379280117E-01],
	[1.9825000000E+04, 1.1092826135E+01, 5.3405519992E+00, 1.7598320103E+00, 1.1825489318E+00, 7.8389148091E-01],
	[1.9830000000E+04, 1.1096950193E+01, 5.3404059356E+00, 1.7612578536E+00, 1.1832323190E+00, 7.8399012502E-01],
	[1.9835000000E+04, 1.1101074744E+01, 5.3402599127E+00, 1.7626844919E+00, 1.1839157843E+00, 7.8408873350E-01],
	[1.9840000000E+04, 1.1105199787E+01, 5.3401139307E+00, 1.7641119254E+00, 1.1845993275E+00, 7.8418730633E-01],
	[1.9845000000E+04, 1.1109325323E+01, 5.3399679894E+00, 1.7655401542E+00, 1.1852829485E+00, 7.8428584353E-01],
	[1.9850000000E+04, 1.1113451352E+01, 5.3398220888E+00, 1.7669691788E+00, 1.1859666471E+00, 7.8438434510E-01],
	[1.9855000000E+04, 1.1117577874E+01, 5.3396762290E+00, 1.7683989993E+00, 1.1866504230E+00, 7.8448281103E-01],
	[1.9860000000E+04, 1.1121704888E+01, 5.3395304100E+00, 1.7698296159E+00, 1.1873342763E+00, 7.8458124133E-01],
	[1.9865000000E+04, 1.1125832395E+01, 5.3393846316E+00, 1.7712610289E+00, 1.1880182065E+00, 7.8467963600E-01],
	[1.9870000000E+04, 1.1129960394E+01, 5.3392388938E+00, 1.7726932386E+00, 1.1887022137E+00, 7.8477799503E-01],
	[1.9875000000E+04, 1.1134088886E+01, 5.3390931967E+00, 1.7741262451E+00, 1.1893862976E+00, 7.8487631844E-01],
	[1.9880000000E+04, 1.1138217870E+01, 5.3389475403E+00, 1.7755600488E+00, 1.1900704580E+00, 7.8497460621E-01],
	[1.9885000000E+04, 1.1142347346E+01, 5.3388019244E+00, 1.7769946498E+00, 1.1907546948E+00, 7.8507285836E-01],
	[1.9890000000E+04, 1.1146477315E+01, 5.3386563491E+00, 1.7784300485E+00, 1.1914390077E+00, 7.8517107488E-01],
	[1.9895000000E+04, 1.1150607776E+01, 5.3385108144E+00, 1.7798662450E+00, 1.1921233967E+00, 7.8526925578E-01],
	[1.9900000000E+04, 1.1154738728E+01, 5.3383653202E+00, 1.7813032396E+00, 1.1928078616E+00, 7.8536740105E-01],
	[1.9905000000E+04, 1.1158870173E+01, 5.3382198665E+00, 1.7827410326E+00, 1.1934924021E+00, 7.8546551069E-01],
	[1.9910000000E+04, 1.1163002110E+01, 5.3380744533E+00, 1.7841796241E+00, 1.1941770181E+00, 7.8556358472E-01],
	[1.9915000000E+04, 1.1167134538E+01, 5.3379290806E+00, 1.7856190145E+00, 1.1948617094E+00, 7.8566162312E-01],
	[1.9920000000E+04, 1.1171267459E+01, 5.3377837484E+00, 1.7870592039E+00, 1.1955464759E+00, 7.8575962590E-01],
	[1.9925000000E+04, 1.1175400871E+01, 5.3376384565E+00, 1.7885001926E+00, 1.1962313174E+00, 7.8585759305E-01],
	[1.9930000000E+04, 1.1179534775E+01, 5.3374932051E+00, 1.7899419809E+00, 1.1969162336E+00, 7.8595552459E-01],
	[1.9935000000E+04, 1.1183669170E+01, 5.3373479941E+00, 1.7913845690E+00, 1.1976012245E+00, 7.8605342050E-01],
	[1.9940000000E+04, 1.1187804057E+01, 5.3372028234E+00, 1.7928279571E+00, 1.1982862899E+00, 7.8615128079E-01],
	[1.9945000000E+04, 1.1191939436E+01, 5.3370576931E+00, 1.7942721455E+00, 1.1989714295E+00, 7.8624910546E-01],
	[1.9950000000E+04, 1.1196075306E+01, 5.3369126031E+00, 1.7957171344E+00, 1.1996566433E+00, 7.8634689450E-01],
	[1.9955000000E+04, 1.1200211667E+01, 5.3367675534E+00, 1.7971629241E+00, 1.2003419310E+00, 7.8644464792E-01],
	[1.9960000000E+04, 1.1204348520E+01, 5.3366225440E+00, 1.7986095148E+00, 1.2010272924E+00, 7.8654236572E-01],
	[1.9965000000E+04, 1.1208485864E+01, 5.3364775748E+00, 1.8000569067E+00, 1.2017127275E+00, 7.8664004790E-01],
	[1.9970000000E+04, 1.1212623699E+01, 5.3363326459E+00, 1.8015051001E+00, 1.2023982359E+00, 7.8673769445E-01],
	[1.9975000000E+04, 1.1216762025E+01, 5.3361877572E+00, 1.8029540953E+00, 1.2030838177E+00, 7.8683530538E-01],
	[1.9980000000E+04, 1.1220900842E+01, 5.3360429087E+00, 1.8044038924E+00, 1.2037694724E+00, 7.8693288069E-01],
	[1.9985000000E+04, 1.1225040150E+01, 5.3358981003E+00, 1.8058544918E+00, 1.2044552001E+00, 7.8703042038E-01],
	[1.9990000000E+04, 1.1229179949E+01, 5.3357533321E+00, 1.8073058936E+00, 1.2051410005E+00, 7.8712792444E-01],
	[1.9995000000E+04, 1.1233320239E+01, 5.3356086041E+00, 1.8087580982E+00, 1.2058268735E+00, 7.8722539288E-01],
	[2.0000000000E+04, 1.1237461020E+01, 5.3354639162E+00, 1.8102111056E+00, 1.2065128188E+00, 7.8732282570E-01],
	[2.0005000000E+04, 1.1241602292E+01, 5.3353192683E+00, 1.8116665040E+00, 1.2071995414E+00, 7.8742022290E-01],
	[2.0010000000E+04, 1.1245744054E+01, 5.3351746605E+00, 1.8131227081E+00, 1.2078863362E+00, 7.8751758448E-01],
	[2.0015000000E+04, 1.1249886306E+01, 5.3350300928E+00, 1.8145797180E+00, 1.2085732033E+00, 7.8761491044E-01],
	[2.0020000000E+04, 1.1254029050E+01, 5.3348855651E+00, 1.8160375340E+00, 1.2092601424E+00, 7.8771220077E-01],
	[2.0025000000E+04, 1.1258172283E+01, 5.3347410774E+00, 1.8174961565E+00, 1.2099471533E+00, 7.8780945549E-01],
	[2.0030000000E+04, 1.1262316007E+01, 5.3345966297E+00, 1.8189555856E+00, 1.2106342358E+00, 7.8790667458E-01],
	[2.0035000000E+04, 1.1266460222E+01, 5.3344522219E+00, 1.8204158215E+00, 1.2113213899E+00, 7.8800385806E-01],
	[2.0040000000E+04, 1.1270604926E+01, 5.3343078541E+00, 1.8218768646E+00, 1.2120086152E+00, 7.8810100592E-01],
	[2.0045000000E+04, 1.1274750121E+01, 5.3341635262E+00, 1.8233387150E+00, 1.2126959118E+00, 7.8819811816E-01],
	[2.0050000000E+04, 1.1278895806E+01, 5.3340192382E+00, 1.8248013730E+00, 1.2133832792E+00, 7.8829519478E-01],
	[2.0055000000E+04, 1.1283041981E+01, 5.3338749901E+00, 1.8262648389E+00, 1.2140707175E+00, 7.8839223578E-01],
	[2.0060000000E+04, 1.1287188646E+01, 5.3337307818E+00, 1.8277291129E+00, 1.2147582264E+00, 7.8848924117E-01],
	[2.0065000000E+04, 1.1291345141E+01, 5.3335889724E+00, 1.8291941952E+00, 1.2154460364E+00, 7.8858621094E-01],
	[2.0070000000E+04, 1.1295511915E+01, 5.3334496725E+00, 1.8306600861E+00, 1.2161341590E+00, 7.8868314510E-01],
	[2.0075000000E+04, 1.1299679188E+01, 5.3333104111E+00, 1.8321267858E+00, 1.2168223526E+00, 7.8878004364E-01],
	[2.0080000000E+04, 1.1303846961E+01, 5.3331711879E+00, 1.8335942946E+00, 1.2175106168E+00, 7.8887690656E-01],
	[2.0085000000E+04, 1.1308015232E+01, 5.3330320030E+00, 1.8350626128E+00, 1.2181989516E+00, 7.8897373387E-01],
	[2.0090000000E+04, 1.1312184002E+01, 5.3328928565E+00, 1.8365317404E+00, 1.2188873568E+00, 7.8907052557E-01],
	[2.0095000000E+04, 1.1316353272E+01, 5.3327537481E+00, 1.8380016779E+00, 1.2195758322E+00, 7.8916728165E-01],
	[2.0100000000E+04, 1.1320523040E+01, 5.3326146780E+00, 1.8394724254E+00, 1.2202643776E+00, 7.8926400213E-01],
	[2.0105000000E+04, 1.1324693306E+01, 5.3324756461E+00, 1.8409439832E+00, 1.2209529929E+00, 7.8936068699E-01],
	[2.0110000000E+04, 1.1328864072E+01, 5.3323366524E+00, 1.8424163516E+00, 1.2216416779E+00, 7.8945733624E-01],
	[2.0115000000E+04, 1.1333035336E+01, 5.3321976969E+00, 1.8438895307E+00, 1.2223304324E+00, 7.8955394988E-01],
	[2.0120000000E+04, 1.1337207098E+01, 5.3320587796E+00, 1.8453635209E+00, 1.2230192562E+00, 7.8965052792E-01],
	[2.0125000000E+04, 1.1341379359E+01, 5.3319199004E+00, 1.8468383223E+00, 1.2237081493E+00, 7.8974707034E-01],
	[2.0130000000E+04, 1.1345552119E+01, 5.3317810593E+00, 1.8483139353E+00, 1.2243971113E+00, 7.8984357716E-01],
	[2.0135000000E+04, 1.1349725377E+01, 5.3316422562E+00, 1.8497903600E+00, 1.2250861422E+00, 7.8994004838E-01],
	[2.0140000000E+04, 1.1353899133E+01, 5.3315034913E+00, 1.8512675967E+00, 1.2257752417E+00, 7.9003648398E-01],
	[2.0145000000E+04, 1.1358073387E+01, 5.3313647644E+00, 1.8527456457E+00, 1.2264644097E+00, 7.9013288399E-01],
	[2.0150000000E+04, 1.1362248140E+01, 5.3312260756E+00, 1.8542245072E+00, 1.2271536460E+00, 7.9022924839E-01],
	[2.0155000000E+04, 1.1366423390E+01, 5.3310874248E+00, 1.8557041814E+00, 1.2278429505E+00, 7.9032557719E-01],
	[2.0160000000E+04, 1.1370599139E+01, 5.3309488119E+00, 1.8571846686E+00, 1.2285323229E+00, 7.9042187039E-01],
	[2.0165000000E+04, 1.1374775386E+01, 5.3308102371E+00, 1.8586659690E+00, 1.2292217631E+00, 7.9051812798E-01],
	[2.0170000000E+04, 1.1378952130E+01, 5.3306717002E+00, 1.8601480828E+00, 1.2299112709E+00, 7.9061434998E-01],
	[2.0175000000E+04, 1.1383129373E+01, 5.3305332012E+00, 1.8616310105E+00, 1.2306008462E+00, 7.9071053638E-01],
	[2.0180000000E+04, 1.1387307113E+01, 5.3303947402E+00, 1.8631147520E+00, 1.2312904888E+00, 7.9080668719E-01],
	[2.0185000000E+04, 1.1391485351E+01, 5.3302563171E+00, 1.8645993078E+00, 1.2319801984E+00, 7.9090280240E-01],
	[2.0190000000E+04, 1.1395664087E+01, 5.3301179318E+00, 1.8660846780E+00, 1.2326699750E+00, 7.9099888201E-01],
	[2.0195000000E+04, 1.1399843320E+01, 5.3299795844E+00, 1.8675708629E+00, 1.2333598184E+00, 7.9109492603E-01],
	[2.0200000000E+04, 1.1404023050E+01, 5.3298412748E+00, 1.8690578628E+00, 1.2340497283E+00, 7.9119093446E-01],
	[2.0205000000E+04, 1.1408203279E+01, 5.3297030031E+00, 1.8705456778E+00, 1.2347397047E+00, 7.9128690730E-01],
	[2.0210000000E+04, 1.1412384004E+01, 5.3295647691E+00, 1.8720343083E+00, 1.2354297473E+00, 7.9138284455E-01],
	[2.0215000000E+04, 1.1416565227E+01, 5.3294265729E+00, 1.8735237545E+00, 1.2361198559E+00, 7.9147874621E-01],
	[2.0220000000E+04, 1.1420746947E+01, 5.3292884145E+00, 1.8750140165E+00, 1.2368100305E+00, 7.9157461229E-01],
	[2.0225000000E+04, 1.1424929165E+01, 5.3291502939E+00, 1.8765050948E+00, 1.2375002708E+00, 7.9167044278E-01],
	[2.0230000000E+04, 1.1429111879E+01, 5.3290122109E+00, 1.8779969894E+00, 1.2381905766E+00, 7.9176623768E-01],
	[2.0235000000E+04, 1.1433295091E+01, 5.3288741656E+00, 1.8794897007E+00, 1.2388809478E+00, 7.9186199701E-01],
	[2.0240000000E+04, 1.1437478799E+01, 5.3287361581E+00, 1.8809832289E+00, 1.2395713843E+00, 7.9195772075E-01],
	[2.0245000000E+04, 1.1441663005E+01, 5.3285981882E+00, 1.8824775742E+00, 1.2402618857E+00, 7.9205340891E-01],
	[2.0250000000E+04, 1.1445847707E+01, 5.3284602559E+00, 1.8839727370E+00, 1.2409524521E+00, 7.9214906150E-01],
	[2.0255000000E+04, 1.1450032907E+01, 5.3283223613E+00, 1.8854687173E+00, 1.2416430831E+00, 7.9224467850E-01],
	[2.0260000000E+04, 1.1454218603E+01, 5.3281845042E+00, 1.8869655156E+00, 1.2423337786E+00, 7.9234025993E-01],
	[2.0265000000E+04, 1.1458404795E+01, 5.3280466847E+00, 1.8884631319E+00, 1.2430245385E+00, 7.9243580579E-01],
	[2.0270000000E+04, 1.1462591485E+01, 5.3279089028E+00, 1.8899615666E+00, 1.2437153626E+00, 7.9253131608E-01],
	[2.0275000000E+04, 1.1466778671E+01, 5.3277711585E+00, 1.8914608200E+00, 1.2444062507E+00, 7.9262679079E-01],
	[2.0280000000E+04, 1.1470966353E+01, 5.3276334517E+00, 1.8929608922E+00, 1.2450972026E+00, 7.9272222994E-01],
	[2.0285000000E+04, 1.1475154532E+01, 5.3274957823E+00, 1.8944617835E+00, 1.2457882181E+00, 7.9281763352E-01],
	[2.0290000000E+04, 1.1479343207E+01, 5.3273581505E+00, 1.8959634941E+00, 1.2464792972E+00, 7.9291300154E-01],
	[2.0295000000E+04, 1.1483532379E+01, 5.3272205561E+00, 1.8974660244E+00, 1.2471704395E+00, 7.9300833399E-01],
	[2.0300000000E+04, 1.1487722047E+01, 5.3270829992E+00, 1.8989693744E+00, 1.2478616451E+00, 7.9310363087E-01],
	[2.0305000000E+04, 1.1491912211E+01, 5.3269454797E+00, 1.9004735446E+00, 1.2485529135E+00, 7.9319889220E-01],
	[2.0310000000E+04, 1.1496102871E+01, 5.3268079976E+00, 1.9019785351E+00, 1.2492442448E+00, 7.9329411797E-01],
	[2.0315000000E+04, 1.1500294027E+01, 5.3266705529E+00, 1.9034843461E+00, 1.2499356387E+00, 7.9338930818E-01],
	[2.0320000000E+04, 1.1504485679E+01, 5.3265331456E+00, 1.9049909780E+00, 1.2506270951E+00, 7.9348446284E-01],
	[2.0325000000E+04, 1.1508677827E+01, 5.3263957756E+00, 1.9064984309E+00, 1.2513186138E+00, 7.9357958194E-01],
	[2.0330000000E+04, 1.1512870471E+01, 5.3262584430E+00, 1.9080067052E+00, 1.2520101945E+00, 7.9367466549E-01],
	[2.0335000000E+04, 1.1517063611E+01, 5.3261211476E+00, 1.9095158010E+00, 1.2527018372E+00, 7.9376971350E-01],
	[2.0340000000E+04, 1.1521257247E+01, 5.3259838896E+00, 1.9110257186E+00, 1.2533935417E+00, 7.9386472595E-01],
	[2.0345000000E+04, 1.1525451378E+01, 5.3258466688E+00, 1.9125364582E+00, 1.2540853078E+00, 7.9395970286E-01],
	[2.0350000000E+04, 1.1529646005E+01, 5.3257094853E+00, 1.9140480201E+00, 1.2547771353E+00, 7.9405464423E-01],
	[2.0355000000E+04, 1.1533841127E+01, 5.3255723390E+00, 1.9155604046E+00, 1.2554690241E+00, 7.9414955005E-01],
	[2.0360000000E+04, 1.1538036745E+01, 5.3254352299E+00, 1.9170736118E+00, 1.2561609739E+00, 7.9424442033E-01],
	[2.0365000000E+04, 1.1542232859E+01, 5.3252981581E+00, 1.9185876421E+00, 1.2568529847E+00, 7.9433925508E-01],
	[2.0370000000E+04, 1.1546429467E+01, 5.3251611234E+00, 1.9201024956E+00, 1.2575450562E+00, 7.9443405429E-01],
	[2.0375000000E+04, 1.1550626571E+01, 5.3250241258E+00, 1.9216181726E+00, 1.2582371882E+00, 7.9452881797E-01],
	[2.0380000000E+04, 1.1554824171E+01, 5.3248871654E+00, 1.9231346734E+00, 1.2589293807E+00, 7.9462354611E-01],
	[2.0385000000E+04, 1.1559022265E+01, 5.3247502421E+00, 1.9246519982E+00, 1.2596216334E+00, 7.9471823873E-01],
	[2.0390000000E+04, 1.1563238162E+01, 5.3246176003E+00, 1.9261701473E+00, 1.2603143895E+00, 7.9481289582E-01],
	[2.0395000000E+04, 1.1567456649E+01, 5.3244855059E+00, 1.9276891208E+00, 1.2610072598E+00, 7.9490751738E-01],
	[2.0400000000E+04, 1.1571675640E+01, 5.3243534471E+00, 1.9292089191E+00, 1.2617001906E+00, 7.9500210342E-01],
	[2.0405000000E+04, 1.1575895136E+01, 5.3242214239E+00, 1.9307295423E+00, 1.2623931817E+00, 7.9509665394E-01],
	[2.0410000000E+04, 1.1580115135E+01, 5.3240894363E+00, 1.9322509908E+00, 1.2630862330E+00, 7.9519116894E-01],
	[2.0415000000E+04, 1.1584335639E+01, 5.3239574844E+00, 1.9337732648E+00, 1.2637793444E+00, 7.9528564843E-01],
	[2.0420000000E+04, 1.1588556647E+01, 5.3238255680E+00, 1.9352963645E+00, 1.2644725155E+00, 7.9538009240E-01],
	[2.0425000000E+04, 1.1592778160E+01, 5.3236936872E+00, 1.9368202901E+00, 1.2651657464E+00, 7.9547450086E-01],
	[2.0430000000E+04, 1.1597000176E+01, 5.3235618419E+00, 1.9383450420E+00, 1.2658590368E+00, 7.9556887380E-01],
	[2.0435000000E+04, 1.1601222695E+01, 5.3234300322E+00, 1.9398706203E+00, 1.2665523865E+00, 7.9566321125E-01],
	[2.0440000000E+04, 1.1605445719E+01, 5.3232982580E+00, 1.9413970253E+00, 1.2672457953E+00, 7.9575751318E-01],
	[2.0445000000E+04, 1.1609669247E+01, 5.3231665192E+00, 1.9429242573E+00, 1.2679392632E+00, 7.9585177962E-01],
	[2.0450000000E+04, 1.1613893278E+01, 5.3230348160E+00, 1.9444523164E+00, 1.2686327898E+00, 7.9594601056E-01],
	[2.0455000000E+04, 1.1618117813E+01, 5.3229031482E+00, 1.9459812030E+00, 1.2693263752E+00, 7.9604020599E-01],
	[2.0460000000E+04, 1.1622342852E+01, 5.3227715158E+00, 1.9475109173E+00, 1.2700200190E+00, 7.9613436594E-01],
	[2.0465000000E+04, 1.1626568394E+01, 5.3226399189E+00, 1.9490414595E+00, 1.2707137211E+00, 7.9622849039E-01],
	[2.0470000000E+04, 1.1630794439E+01, 5.3225083573E+00, 1.9505728298E+00, 1.2714074813E+00, 7.9632257935E-01],
	[2.0475000000E+04, 1.1635020988E+01, 5.3223768311E+00, 1.9521050286E+00, 1.2721012996E+00, 7.9641663282E-01],
	[2.0480000000E+04, 1.1639248040E+01, 5.3222453403E+00, 1.9536380561E+00, 1.2727951756E+00, 7.9651065081E-01],
	[2.0485000000E+04, 1.1643475596E+01, 5.3221138849E+00, 1.9551719125E+00, 1.2734891092E+00, 7.9660463331E-01],
	[2.0490000000E+04, 1.1647703655E+01, 5.3219824647E+00, 1.9567065980E+00, 1.2741831003E+00, 7.9669858034E-01],
	[2.0495000000E+04, 1.1651932216E+01, 5.3218510799E+00, 1.9582421129E+00, 1.2748771487E+00, 7.9679249188E-01],
	[2.0500000000E+04, 1.1656161281E+01, 5.3217197304E+00, 1.9597784575E+00, 1.2755712543E+00, 7.9688636796E-01],
	[2.0505000000E+04, 1.1660390849E+01, 5.3215884161E+00, 1.9613156319E+00, 1.2762654167E+00, 7.9698020856E-01],
	[2.0510000000E+04, 1.1664620920E+01, 5.3214571371E+00, 1.9628536365E+00, 1.2769596360E+00, 7.9707401369E-01],
	[2.0515000000E+04, 1.1668851494E+01, 5.3213258934E+00, 1.9643924715E+00, 1.2776539118E+00, 7.9716778336E-01],
	[2.0520000000E+04, 1.1673082571E+01, 5.3211946848E+00, 1.9659321371E+00, 1.2783482441E+00, 7.9726151756E-01],
	[2.0525000000E+04, 1.1677314150E+01, 5.3210635115E+00, 1.9674726335E+00, 1.2790426326E+00, 7.9735521630E-01],
	[2.0530000000E+04, 1.1681546232E+01, 5.3209323733E+00, 1.9690139611E+00, 1.2797370773E+00, 7.9744887958E-01],
	[2.0535000000E+04, 1.1685778817E+01, 5.3208012703E+00, 1.9705561201E+00, 1.2804315779E+00, 7.9754250741E-01],
	[2.0540000000E+04, 1.1690011905E+01, 5.3206702025E+00, 1.9720991106E+00, 1.2811261342E+00, 7.9763609978E-01],
	[2.0545000000E+04, 1.1694245495E+01, 5.3205391697E+00, 1.9736429331E+00, 1.2818207461E+00, 7.9772965671E-01],
	[2.0550000000E+04, 1.1698479587E+01, 5.3204081721E+00, 1.9751875876E+00, 1.2825154134E+00, 7.9782317818E-01],
	[2.0555000000E+04, 1.1702714182E+01, 5.3202772096E+00, 1.9767330744E+00, 1.2832101360E+00, 7.9791666421E-01],
	[2.0560000000E+04, 1.1706949279E+01, 5.3201462822E+00, 1.9782793939E+00, 1.2839049137E+00, 7.9801011481E-01],
	[2.0565000000E+04, 1.1711184878E+01, 5.3200153898E+00, 1.9798265462E+00, 1.2845997462E+00, 7.9810352996E-01],
	[2.0570000000E+04, 1.1715420980E+01, 5.3198845324E+00, 1.9813745316E+00, 1.2852946335E+00, 7.9819690968E-01],
	[2.0575000000E+04, 1.1719657583E+01, 5.3197537101E+00, 1.9829233503E+00, 1.2859895754E+00, 7.9829025396E-01],
	[2.0580000000E+04, 1.1723894689E+01, 5.3196229228E+00, 1.9844730026E+00, 1.2866845717E+00, 7.9838356282E-01],
	[2.0585000000E+04, 1.1728132297E+01, 5.3194921705E+00, 1.9860234887E+00, 1.2873796221E+00, 7.9847683624E-01],
	[2.0590000000E+04, 1.1732370407E+01, 5.3193614531E+00, 1.9875748088E+00, 1.2880747267E+00, 7.9857007425E-01],
	[2.0595000000E+04, 1.1736609019E+01, 5.3192307707E+00, 1.9891269633E+00, 1.2887698851E+00, 7.9866327683E-01],
	[2.0600000000E+04, 1.1740848132E+01, 5.3191001232E+00, 1.9906799523E+00, 1.2894650973E+00, 7.9875644400E-01],
	[2.0605000000E+04, 1.1745087747E+01, 5.3189695106E+00, 1.9922337762E+00, 1.2901603630E+00, 7.9884957576E-01],
	[2.0610000000E+04, 1.1749327864E+01, 5.3188389329E+00, 1.9937884351E+00, 1.2908556821E+00, 7.9894267210E-01],
	[2.0615000000E+04, 1.1753568483E+01, 5.3187083902E+00, 1.9953439292E+00, 1.2915510544E+00, 7.9903573300E-01],
	[2.0620000000E+04, 1.1757809603E+01, 5.3185778822E+00, 1.9969002590E+00, 1.2922464797E+00, 7.9912875840E-01],
	[2.0625000000E+04, 1.1762051225E+01, 5.3184474091E+00, 1.9984574245E+00, 1.2929419579E+00, 7.9922174832E-01],
	[2.0630000000E+04, 1.1766293348E+01, 5.3183169709E+00, 2.0000154260E+00, 1.2936374888E+00, 7.9931470275E-01],
	[2.0635000000E+04, 1.1770535973E+01, 5.3181865674E+00, 2.0015742638E+00, 1.2943330722E+00, 7.9940762171E-01],
	[2.0640000000E+04, 1.1774779099E+01, 5.3180561987E+00, 2.0031339382E+00, 1.2950287080E+00, 7.9950050520E-01],
	[2.0645000000E+04, 1.1779022726E+01, 5.3179258648E+00, 2.0046944493E+00, 1.2957243960E+00, 7.9959335323E-01],
	[2.0650000000E+04, 1.1783266854E+01, 5.3177955657E+00, 2.0062557974E+00, 1.2964201360E+00, 7.9968616580E-01],
	[2.0655000000E+04, 1.1787511484E+01, 5.3176653013E+00, 2.0078179828E+00, 1.2971159279E+00, 7.9977894291E-01],
	[2.0660000000E+04, 1.1791756614E+01, 5.3175350716E+00, 2.0093810057E+00, 1.2978117715E+00, 7.9987168458E-01],
	[2.0665000000E+04, 1.1796002246E+01, 5.3174048766E+00, 2.0109448663E+00, 1.2985076665E+00, 7.9996439080E-01],
	[2.0670000000E+04, 1.1800248379E+01, 5.3172747163E+00, 2.0125095649E+00, 1.2992036129E+00, 8.0005706160E-01],
	[2.0675000000E+04, 1.1804495012E+01, 5.3171445907E+00, 2.0140751018E+00, 1.2998996105E+00, 8.0014969696E-01],
	[2.0680000000E+04, 1.1808742147E+01, 5.3170144997E+00, 2.0156414772E+00, 1.3005956591E+00, 8.0024229689E-01],
	[2.0685000000E+04, 1.1812989782E+01, 5.3168844434E+00, 2.0172086913E+00, 1.3012917586E+00, 8.0033486141E-01],
	[2.0690000000E+04, 1.1817237918E+01, 5.3167544216E+00, 2.0187767444E+00, 1.3019879087E+00, 8.0042739052E-01],
	[2.0695000000E+04, 1.1821486554E+01, 5.3166244345E+00, 2.0203456367E+00, 1.3026841093E+00, 8.0051988422E-01],
	[2.0700000000E+04, 1.1825735691E+01, 5.3164944819E+00, 2.0219153685E+00, 1.3033803603E+00, 8.0061234252E-01],
	[2.0705000000E+04, 1.1829985329E+01, 5.3163645639E+00, 2.0234859400E+00, 1.3040766614E+00, 8.0070476543E-01],
	[2.0710000000E+04, 1.1834235467E+01, 5.3162346805E+00, 2.0250573515E+00, 1.3047730125E+00, 8.0079715295E-01],
	[2.0715000000E+04, 1.1838491143E+01, 5.3161060332E+00, 2.0266296032E+00, 1.3054695472E+00, 8.0088950509E-01],
	[2.0720000000E+04, 1.1842761926E+01, 5.3159809017E+00, 2.0282026953E+00, 1.3061665195E+00, 8.0098182185E-01],
	[2.0725000000E+04, 1.1847033219E+01, 5.3158558033E+00, 2.0297766282E+00, 1.3068635422E+00, 8.0107410324E-01],
	[2.0730000000E+04, 1.1851305021E+01, 5.3157307380E+00, 2.0313514020E+00, 1.3075606151E+00, 8.0116634927E-01],
	[2.0735000000E+04, 1.1855577333E+01, 5.3156057058E+00, 2.0329270170E+00, 1.3082577379E+00, 8.0125855993E-01],
	[2.0740000000E+04, 1.1859850154E+01, 5.3154807068E+00, 2.0345034734E+00, 1.3089549105E+00, 8.0135073525E-01],
	[2.0745000000E+04, 1.1864123484E+01, 5.3153557407E+00, 2.0360807716E+00, 1.3096521328E+00, 8.0144287522E-01],
	[2.0750000000E+04, 1.1868397324E+01, 5.3152308078E+00, 2.0376589116E+00, 1.3103494045E+00, 8.0153497985E-01],
	[2.0755000000E+04, 1.1872671674E+01, 5.3151059079E+00, 2.0392378939E+00, 1.3110467256E+00, 8.0162704915E-01],
	[2.0760000000E+04, 1.1876946532E+01, 5.3149810410E+00, 2.0408177185E+00, 1.3117440958E+00, 8.0171908311E-01],
	[2.0765000000E+04, 1.1881221900E+01, 5.3148562071E+00, 2.0423983859E+00, 1.3124415150E+00, 8.0181108176E-01],
	[2.0770000000E+04, 1.1885497776E+01, 5.3147314062E+00, 2.0439798961E+00, 1.3131389829E+00, 8.0190304509E-01],
	[2.0775000000E+04, 1.1889774162E+01, 5.3146066382E+00, 2.0455622495E+00, 1.3138364996E+00, 8.0199497311E-01],
	[2.0780000000E+04, 1.1894051057E+01, 5.3144819032E+00, 2.0471454464E+00, 1.3145340646E+00, 8.0208686583E-01],
	[2.0785000000E+04, 1.1898328461E+01, 5.3143572012E+00, 2.0487294869E+00, 1.3152316780E+00, 8.0217872325E-01],
	[2.0790000000E+04, 1.1902606374E+01, 5.3142325320E+00, 2.0503143713E+00, 1.3159293395E+00, 8.0227054538E-01],
	[2.0795000000E+04, 1.1906884795E+01, 5.3141078958E+00, 2.0519000998E+00, 1.3166270490E+00, 8.0236233223E-01],
	[2.0800000000E+04, 1.1911163725E+01, 5.3139832925E+00, 2.0534866727E+00, 1.3173248063E+00, 8.0245408380E-01],
	[2.0805000000E+04, 1.1915443164E+01, 5.3138587220E+00, 2.0550740903E+00, 1.3180226112E+00, 8.0254580009E-01],
	[2.0810000000E+04, 1.1919723111E+01, 5.3137341844E+00, 2.0566623528E+00, 1.3187204636E+00, 8.0263748112E-01],
	[2.0815000000E+04, 1.1924003568E+01, 5.3136096796E+00, 2.0582514604E+00, 1.3194183632E+00, 8.0272912689E-01],
	[2.0820000000E+04, 1.1928284532E+01, 5.3134852076E+00, 2.0598414134E+00, 1.3201163100E+00, 8.0282073741E-01],
	[2.0825000000E+04, 1.1932566005E+01, 5.3133607685E+00, 2.0614322120E+00, 1.3208143038E+00, 8.0291231268E-01],
	[2.0830000000E+04, 1.1936847986E+01, 5.3132363621E+00, 2.0630238565E+00, 1.3215123443E+00, 8.0300385270E-01],
	[2.0835000000E+04, 1.1941130476E+01, 5.3131119885E+00, 2.0646163471E+00, 1.3222104314E+00, 8.0309535750E-01],
	[2.0840000000E+04, 1.1945413474E+01, 5.3129876476E+00, 2.0662096840E+00, 1.3229085651E+00, 8.0318682706E-01],
	[2.0845000000E+04, 1.1949696980E+01, 5.3128633395E+00, 2.0678038676E+00, 1.3236067450E+00, 8.0327826141E-01],
	[2.0850000000E+04, 1.1953980994E+01, 5.3127390641E+00, 2.0693988981E+00, 1.3243049710E+00, 8.0336966054E-01],
	[2.0855000000E+04, 1.1958265517E+01, 5.3126148214E+00, 2.0709947756E+00, 1.3250032430E+00, 8.0346102446E-01],
	[2.0860000000E+04, 1.1962550547E+01, 5.3124906114E+00, 2.0725915005E+00, 1.3257015607E+00, 8.0355235317E-01],
	[2.0865000000E+04, 1.1966836085E+01, 5.3123664341E+00, 2.0741890730E+00, 1.3263999241E+00, 8.0364364669E-01],
	[2.0870000000E+04, 1.1971122131E+01, 5.3122422894E+00, 2.0757874933E+00, 1.3270983330E+00, 8.0373490502E-01],
	[2.0875000000E+04, 1.1975408685E+01, 5.3121181774E+00, 2.0773867617E+00, 1.3277967871E+00, 8.0382612817E-01],
	[2.0880000000E+04, 1.1979695747E+01, 5.3119940980E+00, 2.0789868785E+00, 1.3284952863E+00, 8.0391731614E-01],
	[2.0885000000E+04, 1.1983983316E+01, 5.3118700512E+00, 2.0805878438E+00, 1.3291938305E+00, 8.0400846894E-01],
	[2.0890000000E+04, 1.1988271393E+01, 5.3117460370E+00, 2.0821896580E+00, 1.3298924195E+00, 8.0409958658E-01],
	[2.0895000000E+04, 1.1992559978E+01, 5.3116220553E+00, 2.0837923213E+00, 1.3305910531E+00, 8.0419066906E-01],
	[2.0900000000E+04, 1.1996849070E+01, 5.3114981062E+00, 2.0853958338E+00, 1.3312897311E+00, 8.0428171638E-01],
	[2.0905000000E+04, 1.2001138670E+01, 5.3113741897E+00, 2.0870001960E+00, 1.3319884534E+00, 8.0437272857E-01],
	[2.0910000000E+04, 1.2005428776E+01, 5.3112503057E+00, 2.0886054079E+00, 1.3326872198E+00, 8.0446370561E-01],
	[2.0915000000E+04, 1.2009719391E+01, 5.3111264542E+00, 2.0902114699E+00, 1.3333860302E+00, 8.0455464753E-01],
	[2.0920000000E+04, 1.2014010512E+01, 5.3110026352E+00, 2.0918183823E+00, 1.3340848844E+00, 8.0464555432E-01],
	[2.0925000000E+04, 1.2018302141E+01, 5.3108788486E+00, 2.0934261451E+00, 1.3347837822E+00, 8.0473642599E-01],
	[2.0930000000E+04, 1.2022594277E+01, 5.3107550945E+00, 2.0950347588E+00, 1.3354827234E+00, 8.0482726255E-01],
	[2.0935000000E+04, 1.2026886920E+01, 5.3106313729E+00, 2.0966442235E+00, 1.3361817079E+00, 8.0491806400E-01],
	[2.0940000000E+04, 1.2031180070E+01, 5.3105076837E+00, 2.0982545396E+00, 1.3368807355E+00, 8.0500883036E-01],
	[2.0945000000E+04, 1.2035473727E+01, 5.3103840269E+00, 2.0998657071E+00, 1.3375798061E+00, 8.0509956162E-01],
	[2.0950000000E+04, 1.2039767891E+01, 5.3102604025E+00, 2.1014777265E+00, 1.3382789194E+00, 8.0519025780E-01],
	[2.0955000000E+04, 1.2044062561E+01, 5.3101368104E+00, 2.1030905979E+00, 1.3389780754E+00, 8.0528091890E-01],
	[2.0960000000E+04, 1.2048357739E+01, 5.3100132508E+00, 2.1047043215E+00, 1.3396772738E+00, 8.0537154493E-01],
	[2.0965000000E+04, 1.2052653423E+01, 5.3098897234E+00, 2.1063188977E+00, 1.3403765145E+00, 8.0546213589E-01],
	[2.0970000000E+04, 1.2056949614E+01, 5.3097662284E+00, 2.1079343267E+00, 1.3410757973E+00, 8.0555269180E-01],
	[2.0975000000E+04, 1.2061246311E+01, 5.3096427658E+00, 2.1095506087E+00, 1.3417751221E+00, 8.0564321265E-01],
	[2.0980000000E+04, 1.2065543515E+01, 5.3095193354E+00, 2.1111677439E+00, 1.3424744886E+00, 8.0573369846E-01],
	[2.0985000000E+04, 1.2069841226E+01, 5.3093959373E+00, 2.1127857327E+00, 1.3431738968E+00, 8.0582414923E-01],
	[2.0990000000E+04, 1.2074139443E+01, 5.3092725714E+00, 2.1144045752E+00, 1.3438733464E+00, 8.0591456497E-01],
	[2.0995000000E+04, 1.2078438166E+01, 5.3091492378E+00, 2.1160242717E+00, 1.3445728373E+00, 8.0600494569E-01],
	[2.1000000000E+04, 1.2082737395E+01, 5.3090259365E+00, 2.1176448225E+00, 1.3452723693E+00, 8.0609529139E-01],
	[2.1005000000E+04, 1.2087037131E+01, 5.3089026673E+00, 2.1192662278E+00, 1.3459719423E+00, 8.0618560207E-01],
	[2.1010000000E+04, 1.2091337373E+01, 5.3087794304E+00, 2.1208884879E+00, 1.3466715560E+00, 8.0627587775E-01],
	[2.1015000000E+04, 1.2095638121E+01, 5.3086562256E+00, 2.1225116029E+00, 1.3473712104E+00, 8.0636611844E-01],
	[2.1020000000E+04, 1.2099939375E+01, 5.3085330531E+00, 2.1241355732E+00, 1.3480709052E+00, 8.0645632413E-01],
	[2.1025000000E+04, 1.2104241135E+01, 5.3084099126E+00, 2.1257603989E+00, 1.3487706404E+00, 8.0654649484E-01],
	[2.1030000000E+04, 1.2108543401E+01, 5.3082868043E+00, 2.1273860804E+00, 1.3494704156E+00, 8.0663663058E-01],
	[2.1035000000E+04, 1.2112846173E+01, 5.3081637281E+00, 2.1290126179E+00, 1.3501702308E+00, 8.0672673134E-01],
	[2.1040000000E+04, 1.2117149450E+01, 5.3080406841E+00, 2.1306400116E+00, 1.3508700858E+00, 8.0681679714E-01],
	[2.1045000000E+04, 1.2121453234E+01, 5.3079176721E+00, 2.1322682618E+00, 1.3515699804E+00, 8.0690682798E-01],
	[2.1050000000E+04, 1.2125768742E+01, 5.3077972936E+00, 2.1338973686E+00, 1.3522702228E+00, 8.0699682388E-01],
	[2.1055000000E+04, 1.2130093436E+01, 5.3076789569E+00, 2.1355273325E+00, 1.3529707436E+00, 8.0708678483E-01],
	[2.1060000000E+04, 1.2134418645E+01, 5.3075606510E+00, 2.1371581536E+00, 1.3536713044E+00, 8.0717671085E-01],
	[2.1065000000E+04, 1.2138744369E+01, 5.3074423759E+00, 2.1387898321E+00, 1.3543719049E+00, 8.0726660194E-01],
	[2.1070000000E+04, 1.2143070608E+01, 5.3073241314E+00, 2.1404223684E+00, 1.3550725451E+00, 8.0735645810E-01],
	[2.1075000000E+04, 1.2147397362E+01, 5.3072059176E+00, 2.1420557626E+00, 1.3557732248E+00, 8.0744627936E-01],
	[2.1080000000E+04, 1.2151724630E+01, 5.3070877345E+00, 2.1436900150E+00, 1.3564739437E+00, 8.0753606570E-01],
	[2.1085000000E+04, 1.2156052413E+01, 5.3069695821E+00, 2.1453251259E+00, 1.3571747018E+00, 8.0762581715E-01],
	[2.1090000000E+04, 1.2160380711E+01, 5.3068514602E+00, 2.1469610954E+00, 1.3578754989E+00, 8.0771553370E-01],
	[2.1095000000E+04, 1.2164709523E+01, 5.3067333691E+00, 2.1485979239E+00, 1.3585763348E+00, 8.0780521536E-01],
	[2.1100000000E+04, 1.2169038850E+01, 5.3066153085E+00, 2.1502356116E+00, 1.3592772094E+00, 8.0789486215E-01],
	[2.1105000000E+04, 1.2173368691E+01, 5.3064972785E+00, 2.1518741587E+00, 1.3599781224E+00, 8.0798447406E-01],
	[2.1110000000E+04, 1.2177699047E+01, 5.3063792792E+00, 2.1535135655E+00, 1.3606790738E+00, 8.0807405111E-01],
	[2.1115000000E+04, 1.2182029917E+01, 5.3062613104E+00, 2.1551538323E+00, 1.3613800633E+00, 8.0816359330E-01],
	[2.1120000000E+04, 1.2186361301E+01, 5.3061433721E+00, 2.1567949592E+00, 1.3620810908E+00, 8.0825310064E-01],
	[2.1125000000E+04, 1.2190693199E+01, 5.3060254644E+00, 2.1584369465E+00, 1.3627821561E+00, 8.0834257314E-01],
	[2.1130000000E+04, 1.2195025612E+01, 5.3059075872E+00, 2.1600797946E+00, 1.3634832591E+00, 8.0843201079E-01],
	[2.1135000000E+04, 1.2199358539E+01, 5.3057897405E+00, 2.1617235035E+00, 1.3641843995E+00, 8.0852141362E-01],
	[2.1140000000E+04, 1.2203691979E+01, 5.3056719243E+00, 2.1633680736E+00, 1.3648855773E+00, 8.0861078163E-01],
	[2.1145000000E+04, 1.2208025934E+01, 5.3055541386E+00, 2.1650135051E+00, 1.3655867923E+00, 8.0870011482E-01],
	[2.1150000000E+04, 1.2212360402E+01, 5.3054363833E+00, 2.1666597983E+00, 1.3662880443E+00, 8.0878941320E-01],
	[2.1155000000E+04, 1.2216695385E+01, 5.3053186585E+00, 2.1683069534E+00, 1.3669893331E+00, 8.0887867679E-01],
	[2.1160000000E+04, 1.2221030881E+01, 5.3052009641E+00, 2.1699549706E+00, 1.3676906585E+00, 8.0896790557E-01],
	[2.1165000000E+04, 1.2225366890E+01, 5.3050833002E+00, 2.1716038503E+00, 1.3683920205E+00, 8.0905709958E-01],
	[2.1170000000E+04, 1.2229703414E+01, 5.3049656666E+00, 2.1732535925E+00, 1.3690934188E+00, 8.0914625880E-01],
	[2.1175000000E+04, 1.2234040451E+01, 5.3048480635E+00, 2.1749041977E+00, 1.3697948533E+00, 8.0923538325E-01],
	[2.1180000000E+04, 1.2238378001E+01, 5.3047304907E+00, 2.1765556661E+00, 1.3704963239E+00, 8.0932447293E-01],
	[2.1185000000E+04, 1.2242716065E+01, 5.3046129482E+00, 2.1782079978E+00, 1.3711978302E+00, 8.0941352786E-01],
	[2.1190000000E+04, 1.2247054643E+01, 5.3044954361E+00, 2.1798611931E+00, 1.3718993723E+00, 8.0950254804E-01],
	[2.1195000000E+04, 1.2251393734E+01, 5.3043779544E+00, 2.1815152524E+00, 1.3726009499E+00, 8.0959153347E-01],
	[2.1200000000E+04, 1.2255733338E+01, 5.3042605029E+00, 2.1831701757E+00, 1.3733025628E+00, 8.0968048417E-01],
	[2.1205000000E+04, 1.2260073455E+01, 5.3041430817E+00, 2.1848259635E+00, 1.3740042109E+00, 8.0976940014E-01],
	[2.1210000000E+04, 1.2264414086E+01, 5.3040256909E+00, 2.1864826159E+00, 1.3747058941E+00, 8.0985828139E-01],
	[2.1215000000E+04, 1.2268755229E+01, 5.3039083302E+00, 2.1881401331E+00, 1.3754076121E+00, 8.0994712793E-01],
	[2.1220000000E+04, 1.2273096886E+01, 5.3037909999E+00, 2.1897985155E+00, 1.3761093649E+00, 8.1003593976E-01],
	[2.1225000000E+04, 1.2277439055E+01, 5.3036736998E+00, 2.1914577632E+00, 1.3768111521E+00, 8.1012471689E-01],
	[2.1230000000E+04, 1.2281781738E+01, 5.3035564299E+00, 2.1931178766E+00, 1.3775129738E+00, 8.1021345933E-01],
	[2.1235000000E+04, 1.2286124933E+01, 5.3034391902E+00, 2.1947788558E+00, 1.3782148297E+00, 8.1030216709E-01],
	[2.1240000000E+04, 1.2290468642E+01, 5.3033219807E+00, 2.1964407011E+00, 1.3789167196E+00, 8.1039084016E-01],
	[2.1245000000E+04, 1.2294812863E+01, 5.3032048014E+00, 2.1981034128E+00, 1.3796186434E+00, 8.1047947857E-01],
	[2.1250000000E+04, 1.2299157596E+01, 5.3030876522E+00, 2.1997669911E+00, 1.3803206009E+00, 8.1056808232E-01],
	[2.1255000000E+04, 1.2303502843E+01, 5.3029705332E+00, 2.2014314363E+00, 1.3810225920E+00, 8.1065665141E-01],
	[2.1260000000E+04, 1.2307848601E+01, 5.3028534443E+00, 2.2030967485E+00, 1.3817246164E+00, 8.1074518586E-01],
	[2.1265000000E+04, 1.2312194873E+01, 5.3027363856E+00, 2.2047629281E+00, 1.3824266741E+00, 8.1083368566E-01],
	[2.1270000000E+04, 1.2316541657E+01, 5.3026193569E+00, 2.2064299753E+00, 1.3831287649E+00, 8.1092215084E-01],
	[2.1275000000E+04, 1.2320888953E+01, 5.3025023583E+00, 2.2080978903E+00, 1.3838308886E+00, 8.1101058138E-01],
	[2.1280000000E+04, 1.2325236761E+01, 5.3023853898E+00, 2.2097666734E+00, 1.3845330450E+00, 8.1109897732E-01],
	[2.1285000000E+04, 1.2329585082E+01, 5.3022684514E+00, 2.2114363248E+00, 1.3852352340E+00, 8.1118733864E-01],
	[2.1290000000E+04, 1.2333933915E+01, 5.3021515430E+00, 2.2131068449E+00, 1.3859374554E+00, 8.1127566535E-01],
	[2.1295000000E+04, 1.2338283260E+01, 5.3020346647E+00, 2.2147782337E+00, 1.3866397091E+00, 8.1136395744E-01],
	[2.1300000000E+04, 1.2342633118E+01, 5.3019178163E+00, 2.2164504917E+00, 1.3873419948E+00, 8.1145221491E-01],
	[2.1305000000E+04, 1.2346983487E+01, 5.3018009980E+00, 2.2181236189E+00, 1.3880443125E+00, 8.1154043776E-01],
	[2.1310000000E+04, 1.2351334368E+01, 5.3016842096E+00, 2.2197976158E+00, 1.3887466619E+00, 8.1162862600E-01],
	[2.1315000000E+04, 1.2355685761E+01, 5.3015674513E+00, 2.2214724824E+00, 1.3894490430E+00, 8.1171677962E-01],
	[2.1320000000E+04, 1.2360037666E+01, 5.3014507228E+00, 2.2231482192E+00, 1.3901514555E+00, 8.1180489864E-01],
	[2.1325000000E+04, 1.2364390083E+01, 5.3013340243E+00, 2.2248248262E+00, 1.3908538992E+00, 8.1189298304E-01],
	[2.1330000000E+04, 1.2368743011E+01, 5.3012173558E+00, 2.2265023038E+00, 1.3915563741E+00, 8.1198103285E-01],
	[2.1335000000E+04, 1.2373096452E+01, 5.3011007171E+00, 2.2281806522E+00, 1.3922588799E+00, 8.1206904805E-01],
	[2.1340000000E+04, 1.2377450403E+01, 5.3009841084E+00, 2.2298598717E+00, 1.3929614165E+00, 8.1215702865E-01],
	[2.1345000000E+04, 1.2381804867E+01, 5.3008675295E+00, 2.2315399625E+00, 1.3936639837E+00, 8.1224497466E-01],
	[2.1350000000E+04, 1.2386159842E+01, 5.3007509805E+00, 2.2332209248E+00, 1.3943665814E+00, 8.1233288608E-01],
	[2.1355000000E+04, 1.2390515328E+01, 5.3006344614E+00, 2.2349027589E+00, 1.3950692094E+00, 8.1242076290E-01],
	[2.1360000000E+04, 1.2394871325E+01, 5.3005179720E+00, 2.2365854651E+00, 1.3957718675E+00, 8.1250860515E-01],
	[2.1365000000E+04, 1.2399227834E+01, 5.3004015126E+00, 2.2382690436E+00, 1.3964745557E+00, 8.1259641280E-01],
	[2.1370000000E+04, 1.2403584855E+01, 5.3002850829E+00, 2.2399534946E+00, 1.3971772736E+00, 8.1268418588E-01],
	[2.1375000000E+04, 1.2407942386E+01, 5.3001686830E+00, 2.2416388184E+00, 1.3978800211E+00, 8.1277192438E-01],
	[2.1380000000E+04, 1.2412300428E+01, 5.3000523129E+00, 2.2433250153E+00, 1.3985827982E+00, 8.1285962831E-01],
	[2.1385000000E+04, 1.2416658982E+01, 5.2999359726E+00, 2.2450120854E+00, 1.3992856046E+00, 8.1294729767E-01],
	[2.1390000000E+04, 1.2421034123E+01, 5.2998232858E+00, 2.2467000291E+00, 1.3999888972E+00, 8.1303493246E-01],
	[2.1395000000E+04, 1.2425413858E+01, 5.2997115460E+00, 2.2483888465E+00, 1.4006923354E+00, 8.1312253268E-01],
	[2.1400000000E+04, 1.2429794113E+01, 5.2995998346E+00, 2.2500785380E+00, 1.4013958034E+00, 8.1321009835E-01],
	[2.1405000000E+04, 1.2434174888E+01, 5.2994881517E+00, 2.2517691038E+00, 1.4020993008E+00, 8.1329762946E-01],
	[2.1410000000E+04, 1.2438556184E+01, 5.2993764972E+00, 2.2534605440E+00, 1.4028028277E+00, 8.1338512601E-01],
	[2.1415000000E+04, 1.2442938000E+01, 5.2992648711E+00, 2.2551528591E+00, 1.4035063837E+00, 8.1347258801E-01],
	[2.1420000000E+04, 1.2447320336E+01, 5.2991532734E+00, 2.2568460492E+00, 1.4042099688E+00, 8.1356001546E-01],
	[2.1425000000E+04, 1.2451703191E+01, 5.2990417042E+00, 2.2585401145E+00, 1.4049135828E+00, 8.1364740837E-01],
	[2.1430000000E+04, 1.2456086567E+01, 5.2989301633E+00, 2.2602350554E+00, 1.4056172254E+00, 8.1373476674E-01],
	[2.1435000000E+04, 1.2460470463E+01, 5.2988186508E+00, 2.2619308720E+00, 1.4063208967E+00, 8.1382209057E-01],
	[2.1440000000E+04, 1.2464854879E+01, 5.2987071666E+00, 2.2636275646E+00, 1.4070245963E+00, 8.1390937986E-01],
	[2.1445000000E+04, 1.2469239815E+01, 5.2985957108E+00, 2.2653251335E+00, 1.4077283242E+00, 8.1399663462E-01],
	[2.1450000000E+04, 1.2473625270E+01, 5.2984842833E+00, 2.2670235789E+00, 1.4084320802E+00, 8.1408385486E-01],
	[2.1455000000E+04, 1.2478011245E+01, 5.2983728841E+00, 2.2687229011E+00, 1.4091358640E+00, 8.1417104057E-01],
	[2.1460000000E+04, 1.2482397740E+01, 5.2982615132E+00, 2.2704231003E+00, 1.4098396757E+00, 8.1425819176E-01],
	[2.1465000000E+04, 1.2486784754E+01, 5.2981501706E+00, 2.2721241767E+00, 1.4105435149E+00, 8.1434530844E-01],
	[2.1470000000E+04, 1.2491172288E+01, 5.2980388563E+00, 2.2738261306E+00, 1.4112473816E+00, 8.1443239060E-01],
	[2.1475000000E+04, 1.2495560341E+01, 5.2979275703E+00, 2.2755289622E+00, 1.4119512755E+00, 8.1451943824E-01],
	[2.1480000000E+04, 1.2499948914E+01, 5.2978163124E+00, 2.2772326719E+00, 1.4126551965E+00, 8.1460645139E-01],
	[2.1485000000E+04, 1.2504338006E+01, 5.2977050829E+00, 2.2789372598E+00, 1.4133591445E+00, 8.1469343003E-01],
	[2.1490000000E+04, 1.2508727617E+01, 5.2975938815E+00, 2.2806427261E+00, 1.4140631193E+00, 8.1478037417E-01],
	[2.1495000000E+04, 1.2513117747E+01, 5.2974827083E+00, 2.2823490713E+00, 1.4147671207E+00, 8.1486728381E-01],
	[2.1500000000E+04, 1.2517508397E+01, 5.2973715633E+00, 2.2840562954E+00, 1.4154711486E+00, 8.1495415896E-01],
	[2.1505000000E+04, 1.2521899566E+01, 5.2972604465E+00, 2.2857643987E+00, 1.4161752027E+00, 8.1504099963E-01],
	[2.1510000000E+04, 1.2526291254E+01, 5.2971493579E+00, 2.2874733815E+00, 1.4168792831E+00, 8.1512780581E-01],
	[2.1515000000E+04, 1.2530683460E+01, 5.2970382974E+00, 2.2891832441E+00, 1.4175833894E+00, 8.1521457750E-01],
	[2.1520000000E+04, 1.2535076186E+01, 5.2969272650E+00, 2.2908939866E+00, 1.4182875215E+00, 8.1530131473E-01],
	[2.1525000000E+04, 1.2539469431E+01, 5.2968162608E+00, 2.2926056093E+00, 1.4189916793E+00, 8.1538801747E-01],
	[2.1530000000E+04, 1.2543863194E+01, 5.2967052847E+00, 2.2943181125E+00, 1.4196958626E+00, 8.1547468575E-01],
	[2.1535000000E+04, 1.2548257476E+01, 5.2965943366E+00, 2.2960314965E+00, 1.4204000713E+00, 8.1556131956E-01],
	[2.1540000000E+04, 1.2552652277E+01, 5.2964834167E+00, 2.2977457614E+00, 1.4211043051E+00, 8.1564791891E-01],
	[2.1545000000E+04, 1.2557047597E+01, 5.2963725248E+00, 2.2994609075E+00, 1.4218085640E+00, 8.1573448380E-01],
	[2.1550000000E+04, 1.2561443435E+01, 5.2962616609E+00, 2.3011769351E+00, 1.4225128477E+00, 8.1582101424E-01],
	[2.1555000000E+04, 1.2565839791E+01, 5.2961508251E+00, 2.3028938444E+00, 1.4232171561E+00, 8.1590751022E-01],
	[2.1560000000E+04, 1.2570236666E+01, 5.2960400174E+00, 2.3046116357E+00, 1.4239214891E+00, 8.1599397176E-01],
	[2.1565000000E+04, 1.2574634060E+01, 5.2959292376E+00, 2.3063303092E+00, 1.4246258465E+00, 8.1608039886E-01],
	[2.1570000000E+04, 1.2579031972E+01, 5.2958184858E+00, 2.3080498651E+00, 1.4253302281E+00, 8.1616679151E-01],
	[2.1575000000E+04, 1.2583430402E+01, 5.2957077621E+00, 2.3097703038E+00, 1.4260346337E+00, 8.1625314974E-01],
	[2.1580000000E+04, 1.2587829350E+01, 5.2955970663E+00, 2.3114916254E+00, 1.4267390633E+00, 8.1633947353E-01],
	[2.1585000000E+04, 1.2592228816E+01, 5.2954863984E+00, 2.3132138302E+00, 1.4274435166E+00, 8.1642576289E-01],
	[2.1590000000E+04, 1.2596628801E+01, 5.2953757585E+00, 2.3149369184E+00, 1.4281479934E+00, 8.1651201783E-01],
	[2.1595000000E+04, 1.2601029304E+01, 5.2952651465E+00, 2.3166608904E+00, 1.4288524938E+00, 8.1659823836E-01],
	[2.1600000000E+04, 1.2605430324E+01, 5.2951545625E+00, 2.3183857463E+00, 1.4295570173E+00, 8.1668442447E-01],
	[2.1605000000E+04, 1.2609831863E+01, 5.2950440063E+00, 2.3201114864E+00, 1.4302615640E+00, 8.1677057616E-01],
	[2.1610000000E+04, 1.2614233919E+01, 5.2949334781E+00, 2.3218381109E+00, 1.4309661337E+00, 8.1685669345E-01],
	[2.1615000000E+04, 1.2618636493E+01, 5.2948229777E+00, 2.3235656201E+00, 1.4316707261E+00, 8.1694277634E-01],
	[2.1620000000E+04, 1.2623039585E+01, 5.2947125052E+00, 2.3252940143E+00, 1.4323753411E+00, 8.1702882483E-01],
	[2.1625000000E+04, 1.2627443195E+01, 5.2946020605E+00, 2.3270232936E+00, 1.4330799786E+00, 8.1711483893E-01],
	[2.1630000000E+04, 1.2631847322E+01, 5.2944916437E+00, 2.3287534584E+00, 1.4337846385E+00, 8.1720081864E-01],
	[2.1635000000E+04, 1.2636251967E+01, 5.2943812546E+00, 2.3304845089E+00, 1.4344893205E+00, 8.1728676396E-01],
	[2.1640000000E+04, 1.2640657129E+01, 5.2942708934E+00, 2.3322164453E+00, 1.4351940244E+00, 8.1737267490E-01],
	[2.1645000000E+04, 1.2645062809E+01, 5.2941605600E+00, 2.3339492679E+00, 1.4358987502E+00, 8.1745855146E-01],
	[2.1650000000E+04, 1.2649469006E+01, 5.2940502544E+00, 2.3356829769E+00, 1.4366034977E+00, 8.1754439365E-01],
	[2.1655000000E+04, 1.2653875721E+01, 5.2939399766E+00, 2.3374175726E+00, 1.4373082667E+00, 8.1763020148E-01],
	[2.1660000000E+04, 1.2658282952E+01, 5.2938297265E+00, 2.3391530552E+00, 1.4380130571E+00, 8.1771597493E-01],
	[2.1665000000E+04, 1.2662690701E+01, 5.2937195041E+00, 2.3408894250E+00, 1.4387178686E+00, 8.1780171403E-01],
	[2.1670000000E+04, 1.2667098967E+01, 5.2936093095E+00, 2.3426266822E+00, 1.4394227012E+00, 8.1788741877E-01],
	[2.1675000000E+04, 1.2671507751E+01, 5.2934991426E+00, 2.3443648270E+00, 1.4401275547E+00, 8.1797308917E-01],
	[2.1680000000E+04, 1.2675917051E+01, 5.2933890034E+00, 2.3461038598E+00, 1.4408324289E+00, 8.1805872521E-01],
	[2.1685000000E+04, 1.2680326868E+01, 5.2932788918E+00, 2.3478437808E+00, 1.4415373236E+00, 8.1814432691E-01],
	[2.1690000000E+04, 1.2684737203E+01, 5.2931688080E+00, 2.3495845902E+00, 1.4422422388E+00, 8.1822989428E-01],
	[2.1695000000E+04, 1.2689148054E+01, 5.2930587518E+00, 2.3513262882E+00, 1.4429471742E+00, 8.1831542731E-01],
	[2.1700000000E+04, 1.2693559422E+01, 5.2929487233E+00, 2.3530688752E+00, 1.4436521297E+00, 8.1840092601E-01],
	[2.1705000000E+04, 1.2697971306E+01, 5.2928387224E+00, 2.3548123513E+00, 1.4443571051E+00, 8.1848639039E-01],
	[2.1710000000E+04, 1.2702383707E+01, 5.2927287491E+00, 2.3565567168E+00, 1.4450621003E+00, 8.1857182045E-01],
	[2.1715000000E+04, 1.2706796625E+01, 5.2926188034E+00, 2.3583019720E+00, 1.4457671151E+00, 8.1865721619E-01],
	[2.1720000000E+04, 1.2711210060E+01, 5.2925088854E+00, 2.3600481171E+00, 1.4464721493E+00, 8.1874257762E-01],
	[2.1725000000E+04, 1.2715624011E+01, 5.2923989949E+00, 2.3617951524E+00, 1.4471772029E+00, 8.1882790475E-01],
	[2.1730000000E+04, 1.2720038479E+01, 5.2922891320E+00, 2.3635430780E+00, 1.4478822756E+00, 8.1891319758E-01],
	[2.1735000000E+04, 1.2724472666E+01, 5.2921835047E+00, 2.3652918943E+00, 1.4485879314E+00, 8.1899845610E-01],
	[2.1740000000E+04, 1.2728908589E+01, 5.2920781691E+00, 2.3670416015E+00, 1.4492936425E+00, 8.1908368034E-01],
	[2.1745000000E+04, 1.2733345038E+01, 5.2919728598E+00, 2.3687921999E+00, 1.4499993731E+00, 8.1916887029E-01],
	[2.1750000000E+04, 1.2737782013E+01, 5.2918675768E+00, 2.3705436896E+00, 1.4507051230E+00, 8.1925402595E-01],
	[2.1755000000E+04, 1.2742219514E+01, 5.2917623201E+00, 2.3722960710E+00, 1.4514108922E+00, 8.1933914734E-01],
	[2.1760000000E+04, 1.2746657540E+01, 5.2916570897E+00, 2.3740493443E+00, 1.4521166804E+00, 8.1942423445E-01],
	[2.1765000000E+04, 1.2751096092E+01, 5.2915518856E+00, 2.3758035097E+00, 1.4528224875E+00, 8.1950928730E-01],
	[2.1770000000E+04, 1.2755535169E+01, 5.2914467077E+00, 2.3775585675E+00, 1.4535283134E+00, 8.1959430588E-01],
	[2.1775000000E+04, 1.2759974772E+01, 5.2913415560E+00, 2.3793145180E+00, 1.4542341578E+00, 8.1967929020E-01],
	[2.1780000000E+04, 1.2764414900E+01, 5.2912364306E+00, 2.3810713613E+00, 1.4549400206E+00, 8.1976424027E-01],
	[2.1785000000E+04, 1.2768855553E+01, 5.2911313314E+00, 2.3828290978E+00, 1.4556459017E+00, 8.1984915609E-01],
	[2.1790000000E+04, 1.2773296731E+01, 5.2910262584E+00, 2.3845877277E+00, 1.4563518010E+00, 8.1993403766E-01],
	[2.1795000000E+04, 1.2777738435E+01, 5.2909212116E+00, 2.3863472512E+00, 1.4570577181E+00, 8.2001888499E-01],
	[2.1800000000E+04, 1.2782180664E+01, 5.2908161910E+00, 2.3881076686E+00, 1.4577636531E+00, 8.2010369809E-01],
	[2.1805000000E+04, 1.2786623418E+01, 5.2907111966E+00, 2.3898689801E+00, 1.4584696057E+00, 8.2018847696E-01],
	[2.1810000000E+04, 1.2791066697E+01, 5.2906062283E+00, 2.3916311860E+00, 1.4591755758E+00, 8.2027322160E-01],
	[2.1815000000E+04, 1.2795510501E+01, 5.2905012861E+00, 2.3933942865E+00, 1.4598815632E+00, 8.2035793203E-01],
	[2.1820000000E+04, 1.2799954830E+01, 5.2903963701E+00, 2.3951582819E+00, 1.4605875678E+00, 8.2044260823E-01],
	[2.1825000000E+04, 1.2804399684E+01, 5.2902914802E+00, 2.3969231724E+00, 1.4612935894E+00, 8.2052725023E-01],
	[2.1830000000E+04, 1.2808845062E+01, 5.2901866164E+00, 2.3986889583E+00, 1.4619996278E+00, 8.2061185802E-01],
	[2.1835000000E+04, 1.2813290966E+01, 5.2900817787E+00, 2.4004556399E+00, 1.4627056829E+00, 8.2069643162E-01],
	[2.1840000000E+04, 1.2817737394E+01, 5.2899769671E+00, 2.4022232173E+00, 1.4634117546E+00, 8.2078097101E-01],
	[2.1845000000E+04, 1.2822184346E+01, 5.2898721815E+00, 2.4039916908E+00, 1.4641178427E+00, 8.2086547622E-01],
	[2.1850000000E+04, 1.2826631823E+01, 5.2897674220E+00, 2.4057610607E+00, 1.4648239470E+00, 8.2094994724E-01],
	[2.1855000000E+04, 1.2831079825E+01, 5.2896626886E+00, 2.4075313272E+00, 1.4655300674E+00, 8.2103438408E-01],
	[2.1860000000E+04, 1.2835528351E+01, 5.2895579812E+00, 2.4093024906E+00, 1.4662362036E+00, 8.2111878675E-01],
	[2.1865000000E+04, 1.2839977402E+01, 5.2894532998E+00, 2.4110745511E+00, 1.4669423557E+00, 8.2120315524E-01],
	[2.1870000000E+04, 1.2844426976E+01, 5.2893486444E+00, 2.4128475089E+00, 1.4676485233E+00, 8.2128748958E-01],
	[2.1875000000E+04, 1.2848877075E+01, 5.2892440150E+00, 2.4146213644E+00, 1.4683547064E+00, 8.2137178975E-01],
	[2.1880000000E+04, 1.2853327699E+01, 5.2891394116E+00, 2.4163961177E+00, 1.4690609048E+00, 8.2145605577E-01],
	[2.1885000000E+04, 1.2857778846E+01, 5.2890348341E+00, 2.4181717692E+00, 1.4697671183E+00, 8.2154028764E-01],
	[2.1890000000E+04, 1.2862230518E+01, 5.2889302826E+00, 2.4199483190E+00, 1.4704733468E+00, 8.2162448536E-01],
	[2.1895000000E+04, 1.2866682713E+01, 5.2888257571E+00, 2.4217257674E+00, 1.4711795901E+00, 8.2170864895E-01],
	[2.1900000000E+04, 1.2871135433E+01, 5.2887212575E+00, 2.4235041147E+00, 1.4718858481E+00, 8.2179277840E-01],
	[2.1905000000E+04, 1.2875588676E+01, 5.2886167838E+00, 2.4252833611E+00, 1.4725921206E+00, 8.2187687373E-01],
	[2.1910000000E+04, 1.2880042444E+01, 5.2885123360E+00, 2.4270635068E+00, 1.4732984075E+00, 8.2196093493E-01],
	[2.1915000000E+04, 1.2884496735E+01, 5.2884079141E+00, 2.4288445522E+00, 1.4740047085E+00, 8.2204496202E-01],
	[2.1920000000E+04, 1.2888951550E+01, 5.2883035181E+00, 2.4306264974E+00, 1.4747110236E+00, 8.2212895499E-01],
	[2.1925000000E+04, 1.2893406888E+01, 5.2881991479E+00, 2.4324093427E+00, 1.4754173526E+00, 8.2221291386E-01],
	[2.1930000000E+04, 1.2897862750E+01, 5.2880948036E+00, 2.4341930883E+00, 1.4761236953E+00, 8.2229683862E-01],
	[2.1935000000E+04, 1.2902319136E+01, 5.2879904852E+00, 2.4359777346E+00, 1.4768300516E+00, 8.2238072929E-01],
	[2.1940000000E+04, 1.2906776045E+01, 5.2878861926E+00, 2.4377632817E+00, 1.4775364214E+00, 8.2246458587E-01],
	[2.1945000000E+04, 1.2911233478E+01, 5.2877819258E+00, 2.4395497299E+00, 1.4782428044E+00, 8.2254840836E-01],
	[2.1950000000E+04, 1.2915691434E+01, 5.2876776848E+00, 2.4413370794E+00, 1.4789492005E+00, 8.2263219677E-01],
	[2.1955000000E+04, 1.2920149914E+01, 5.2875734697E+00, 2.4431253306E+00, 1.4796556095E+00, 8.2271595111E-01],
	[2.1960000000E+04, 1.2924608916E+01, 5.2874692803E+00, 2.4449144836E+00, 1.4803620314E+00, 8.2279967138E-01],
	[2.1965000000E+04, 1.2929068442E+01, 5.2873651166E+00, 2.4467045386E+00, 1.4810684659E+00, 8.2288335759E-01],
	[2.1970000000E+04, 1.2933528491E+01, 5.2872609788E+00, 2.4484954961E+00, 1.4817749130E+00, 8.2296700974E-01],
	[2.1975000000E+04, 1.2937989064E+01, 5.2871568667E+00, 2.4502873561E+00, 1.4824813723E+00, 8.2305062784E-01],
	[2.1980000000E+04, 1.2942450159E+01, 5.2870527803E+00, 2.4520801190E+00, 1.4831878438E+00, 8.2313421189E-01],
	[2.1985000000E+04, 1.2946911777E+01, 5.2869487196E+00, 2.4538737849E+00, 1.4838943274E+00, 8.2321776190E-01],
	[2.1990000000E+04, 1.2951373919E+01, 5.2868446847E+00, 2.4556683542E+00, 1.4846008228E+00, 8.2330127787E-01],
	[2.1995000000E+04, 1.2955836583E+01, 5.2867406754E+00, 2.4574638271E+00, 1.4853073300E+00, 8.2338475981E-01],
	[2.2000000000E+04, 1.2960299770E+01, 5.2866366919E+00, 2.4592602038E+00, 1.4860138487E+00, 8.2346820773E-01],
	[2.2005000000E+04, 1.2964763479E+01, 5.2865327340E+00, 2.4610574846E+00, 1.4867203789E+00, 8.2355162163E-01],
	[2.2010000000E+04, 1.2969227712E+01, 5.2864288018E+00, 2.4628556698E+00, 1.4874269202E+00, 8.2363500152E-01],
	[2.2015000000E+04, 1.2973692467E+01, 5.2863248952E+00, 2.4646547595E+00, 1.4881334727E+00, 8.2371834740E-01],
	[2.2020000000E+04, 1.2978157744E+01, 5.2862210143E+00, 2.4664547541E+00, 1.4888400362E+00, 8.2380165928E-01],
	[2.2025000000E+04, 1.2982623545E+01, 5.2861171590E+00, 2.4682556537E+00, 1.4895466104E+00, 8.2388493716E-01],
	[2.2030000000E+04, 1.2987089867E+01, 5.2860133293E+00, 2.4700574587E+00, 1.4902531953E+00, 8.2396818106E-01],
	[2.2035000000E+04, 1.2991556712E+01, 5.2859095252E+00, 2.4718601693E+00, 1.4909597906E+00, 8.2405139096E-01],
	[2.2040000000E+04, 1.2996024080E+01, 5.2858057467E+00, 2.4736637857E+00, 1.4916663963E+00, 8.2413456689E-01],
	[2.2045000000E+04, 1.3000491970E+01, 5.2857019938E+00, 2.4754683082E+00, 1.4923730122E+00, 8.2421770885E-01],
	[2.2050000000E+04, 1.3004960382E+01, 5.2855982664E+00, 2.4772737370E+00, 1.4930796381E+00, 8.2430081684E-01],
	[2.2055000000E+04, 1.3009429316E+01, 5.2854945646E+00, 2.4790800724E+00, 1.4937862738E+00, 8.2438389087E-01],
	[2.2060000000E+04, 1.3013898772E+01, 5.2853908883E+00, 2.4808873146E+00, 1.4944929193E+00, 8.2446693094E-01],
	[2.2065000000E+04, 1.3018368750E+01, 5.2852872376E+00, 2.4826954639E+00, 1.4951995743E+00, 8.2454993707E-01],
	[2.2070000000E+04, 1.3022839251E+01, 5.2851836124E+00, 2.4845045205E+00, 1.4959062388E+00, 8.2463290925E-01],
	[2.2075000000E+04, 1.3027310273E+01, 5.2850800127E+00, 2.4863144847E+00, 1.4966129125E+00, 8.2471584749E-01],
	[2.2080000000E+04, 1.3031781817E+01, 5.2849764384E+00, 2.4881253567E+00, 1.4973195953E+00, 8.2479875180E-01],
	[2.2085000000E+04, 1.3036274050E+01, 5.2848771858E+00, 2.4899371368E+00, 1.4980268985E+00, 8.2488162218E-01],
	[2.2090000000E+04, 1.3040767329E+01, 5.2847780673E+00, 2.4917498253E+00, 1.4987342270E+00, 8.2496445865E-01],
	[2.2095000000E+04, 1.3045261140E+01, 5.2846789732E+00, 2.4935634223E+00, 1.4994415650E+00, 8.2504726120E-01],
	[2.2100000000E+04, 1.3049755481E+01, 5.2845799033E+00, 2.4953779281E+00, 1.5001489124E+00, 8.2513002984E-01],
	[2.2105000000E+04, 1.3054250354E+01, 5.2844808577E+00, 2.4971933430E+00, 1.5008562690E+00, 8.2521276458E-01],
	[2.2110000000E+04, 1.3058745758E+01, 5.2843818363E+00, 2.4990096672E+00, 1.5015636346E+00, 8.2529546543E-01],
	[2.2115000000E+04, 1.3063241693E+01, 5.2842828392E+00, 2.5008269010E+00, 1.5022710091E+00, 8.2537813238E-01],
	[2.2120000000E+04, 1.3067738159E+01, 5.2841838664E+00, 2.5026450446E+00, 1.5029783924E+00, 8.2546076545E-01],
	[2.2125000000E+04, 1.3072235156E+01, 5.2840849177E+00, 2.5044640983E+00, 1.5036857842E+00, 8.2554336464E-01],
	[2.2130000000E+04, 1.3076732684E+01, 5.2839859933E+00, 2.5062840623E+00, 1.5043931845E+00, 8.2562592996E-01],
	[2.2135000000E+04, 1.3081230742E+01, 5.2838870930E+00, 2.5081049369E+00, 1.5051005931E+00, 8.2570846142E-01],
	[2.2140000000E+04, 1.3085729332E+01, 5.2837882170E+00, 2.5099267223E+00, 1.5058080098E+00, 8.2579095901E-01],
	[2.2145000000E+04, 1.3090228452E+01, 5.2836893651E+00, 2.5117494187E+00, 1.5065154345E+00, 8.2587342275E-01],
	[2.2150000000E+04, 1.3094728103E+01, 5.2835905374E+00, 2.5135730265E+00, 1.5072228670E+00, 8.2595585265E-01],
	[2.2155000000E+04, 1.3099228284E+01, 5.2834917338E+00, 2.5153975458E+00, 1.5079303072E+00, 8.2603824870E-01],
	[2.2160000000E+04, 1.3103728996E+01, 5.2833929544E+00, 2.5172229770E+00, 1.5086377550E+00, 8.2612061092E-01],
	[2.2165000000E+04, 1.3108230238E+01, 5.2832941991E+00, 2.5190493202E+00, 1.5093452100E+00, 8.2620293931E-01],
	[2.2170000000E+04, 1.3112732011E+01, 5.2831954679E+00, 2.5208765757E+00, 1.5100526724E+00, 8.2628523388E-01],
	[2.2175000000E+04, 1.3117234314E+01, 5.2830967609E+00, 2.5227047439E+00, 1.5107601418E+00, 8.2636749463E-01],
	[2.2180000000E+04, 1.3121737147E+01, 5.2829980779E+00, 2.5245338248E+00, 1.5114676181E+00, 8.2644972157E-01],
	[2.2185000000E+04, 1.3126240511E+01, 5.2828994190E+00, 2.5263638188E+00, 1.5121751011E+00, 8.2653191470E-01],
	[2.2190000000E+04, 1.3130744404E+01, 5.2828007842E+00, 2.5281947260E+00, 1.5128825908E+00, 8.2661407404E-01],
	[2.2195000000E+04, 1.3135248828E+01, 5.2827021735E+00, 2.5300265469E+00, 1.5135900869E+00, 8.2669619959E-01],
	[2.2200000000E+04, 1.3139753782E+01, 5.2826035868E+00, 2.5318592816E+00, 1.5142975894E+00, 8.2677829135E-01],
	[2.2205000000E+04, 1.3144259266E+01, 5.2825050242E+00, 2.5336929303E+00, 1.5150050980E+00, 8.2686034933E-01],
	[2.2210000000E+04, 1.3148765280E+01, 5.2824064856E+00, 2.5355274934E+00, 1.5157126126E+00, 8.2694237354E-01],
	[2.2215000000E+04, 1.3153271824E+01, 5.2823079710E+00, 2.5373629710E+00, 1.5164201331E+00, 8.2702436399E-01],
	[2.2220000000E+04, 1.3157778898E+01, 5.2822094804E+00, 2.5391993634E+00, 1.5171276592E+00, 8.2710632068E-01],
	[2.2225000000E+04, 1.3162286501E+01, 5.2821110138E+00, 2.5410366709E+00, 1.5178351910E+00, 8.2718824361E-01],
	[2.2230000000E+04, 1.3166794634E+01, 5.2820125712E+00, 2.5428748937E+00, 1.5185427281E+00, 8.2727013280E-01],
	[2.2235000000E+04, 1.3171303297E+01, 5.2819141526E+00, 2.5447140320E+00, 1.5192502704E+00, 8.2735198824E-01],
	[2.2240000000E+04, 1.3175812490E+01, 5.2818157579E+00, 2.5465540862E+00, 1.5199578179E+00, 8.2743380995E-01],
	[2.2245000000E+04, 1.3180322212E+01, 5.2817173872E+00, 2.5483950564E+00, 1.5206653703E+00, 8.2751559794E-01],
	[2.2250000000E+04, 1.3184832463E+01, 5.2816190404E+00, 2.5502369429E+00, 1.5213729275E+00, 8.2759735220E-01],
	[2.2255000000E+04, 1.3189343244E+01, 5.2815207175E+00, 2.5520797460E+00, 1.5220804894E+00, 8.2767907275E-01],
	[2.2260000000E+04, 1.3193854555E+01, 5.2814224186E+00, 2.5539234659E+00, 1.5227880557E+00, 8.2776075959E-01],
	[2.2265000000E+04, 1.3198366394E+01, 5.2813241436E+00, 2.5557681029E+00, 1.5234956264E+00, 8.2784241273E-01],
	[2.2270000000E+04, 1.3202878763E+01, 5.2812258925E+00, 2.5576136571E+00, 1.5242032013E+00, 8.2792403218E-01],
	[2.2275000000E+04, 1.3207391661E+01, 5.2811276652E+00, 2.5594601290E+00, 1.5249107802E+00, 8.2800561793E-01],
	[2.2280000000E+04, 1.3211905089E+01, 5.2810294618E+00, 2.5613075186E+00, 1.5256183630E+00, 8.2808717001E-01],
	[2.2285000000E+04, 1.3216419045E+01, 5.2809312823E+00, 2.5631558263E+00, 1.5263259495E+00, 8.2816868841E-01],
	[2.2290000000E+04, 1.3220933531E+01, 5.2808331266E+00, 2.5650050523E+00, 1.5270335397E+00, 8.2825017314E-01],
	[2.2295000000E+04, 1.3225448545E+01, 5.2807349948E+00, 2.5668551968E+00, 1.5277411332E+00, 8.2833162421E-01],
	[2.2300000000E+04, 1.3229964088E+01, 5.2806368868E+00, 2.5687062602E+00, 1.5284487301E+00, 8.2841304162E-01],
	[2.2305000000E+04, 1.3234480161E+01, 5.2805388026E+00, 2.5705582426E+00, 1.5291563301E+00, 8.2849442539E-01],
	[2.2310000000E+04, 1.3238996762E+01, 5.2804407423E+00, 2.5724111443E+00, 1.5298639331E+00, 8.2857577551E-01],
	[2.2315000000E+04, 1.3243513892E+01, 5.2803427057E+00, 2.5742649656E+00, 1.5305715389E+00, 8.2865709200E-01],
	[2.2320000000E+04, 1.3248031550E+01, 5.2802446929E+00, 2.5761197067E+00, 1.5312791474E+00, 8.2873837486E-01],
	[2.2325000000E+04, 1.3252549738E+01, 5.2801467039E+00, 2.5779753679E+00, 1.5319867584E+00, 8.2881962410E-01],
	[2.2330000000E+04, 1.3257068453E+01, 5.2800487386E+00, 2.5798319493E+00, 1.5326943719E+00, 8.2890083972E-01],
	[2.2335000000E+04, 1.3261587698E+01, 5.2799507971E+00, 2.5816894513E+00, 1.5334019875E+00, 8.2898202173E-01],
	[2.2340000000E+04, 1.3266107471E+01, 5.2798528793E+00, 2.5835478741E+00, 1.5341096053E+00, 8.2906317015E-01],
	[2.2345000000E+04, 1.3270627772E+01, 5.2797549853E+00, 2.5854072180E+00, 1.5348172250E+00, 8.2914428496E-01],
	[2.2350000000E+04, 1.3275148601E+01, 5.2796571150E+00, 2.5872674832E+00, 1.5355248465E+00, 8.2922536619E-01],
	[2.2355000000E+04, 1.3279669959E+01, 5.2795592683E+00, 2.5891286699E+00, 1.5362324696E+00, 8.2930641384E-01],
	[2.2360000000E+04, 1.3284191846E+01, 5.2794614454E+00, 2.5909907785E+00, 1.5369400942E+00, 8.2938742792E-01],
	[2.2365000000E+04, 1.3288714260E+01, 5.2793636462E+00, 2.5928653026E+00, 1.5376517623E+00, 8.2946840842E-01],
	[2.2370000000E+04, 1.3293237202E+01, 5.2792658706E+00, 2.5947426352E+00, 1.5383640903E+00, 8.2954935537E-01],
	[2.2375000000E+04, 1.3297760673E+01, 5.2791681187E+00, 2.5966209066E+00, 1.5390764203E+00, 8.2963026876E-01],
	[2.2380000000E+04, 1.3302284672E+01, 5.2790703904E+00, 2.5985001171E+00, 1.5397887519E+00, 8.2971114861E-01],
	[2.2385000000E+04, 1.3306809198E+01, 5.2789726858E+00, 2.6003802669E+00, 1.5405010851E+00, 8.2979199491E-01],
	[2.2390000000E+04, 1.3311334253E+01, 5.2788750048E+00, 2.6022613563E+00, 1.5412134198E+00, 8.2987280768E-01],
	[2.2395000000E+04, 1.3315859835E+01, 5.2787773475E+00, 2.6041433855E+00, 1.5419257557E+00, 8.2995358693E-01],
	[2.2400000000E+04, 1.3320385945E+01, 5.2786797137E+00, 2.6060263549E+00, 1.5426380926E+00, 8.3003433265E-01],
	[2.2405000000E+04, 1.3324912583E+01, 5.2785821035E+00, 2.6079102646E+00, 1.5433504306E+00, 8.3011504487E-01],
	[2.2410000000E+04, 1.3329439749E+01, 5.2784845169E+00, 2.6097951150E+00, 1.5440627693E+00, 8.3019572358E-01],
	[2.2415000000E+04, 1.3333967442E+01, 5.2783869539E+00, 2.6116809062E+00, 1.5447751087E+00, 8.3027636879E-01],
	[2.2420000000E+04, 1.3338495663E+01, 5.2782894145E+00, 2.6135676386E+00, 1.5454874486E+00, 8.3035698051E-01],
	[2.2425000000E+04, 1.3343024411E+01, 5.2781918986E+00, 2.6154553124E+00, 1.5461997889E+00, 8.3043755874E-01],
	[2.2430000000E+04, 1.3347553687E+01, 5.2780944063E+00, 2.6173439279E+00, 1.5469121293E+00, 8.3051810350E-01],
	[2.2435000000E+04, 1.3352083490E+01, 5.2779969374E+00, 2.6192334852E+00, 1.5476244698E+00, 8.3059861479E-01],
	[2.2440000000E+04, 1.3356632326E+01, 5.2779033246E+00, 2.6211239848E+00, 1.5483373886E+00, 8.3067909261E-01],
	[2.2445000000E+04, 1.3361184147E+01, 5.2778102416E+00, 2.6230154268E+00, 1.5490503846E+00, 8.3075953698E-01],
	[2.2450000000E+04, 1.3365736506E+01, 5.2777171810E+00, 2.6249078115E+00, 1.5497633811E+00, 8.3083994790E-01],
	[2.2455000000E+04, 1.3370289401E+01, 5.2776241428E+00, 2.6268011392E+00, 1.5504763779E+00, 8.3092032537E-01],
	[2.2460000000E+04, 1.3374842833E+01, 5.2775311270E+00, 2.6286954100E+00, 1.5511893749E+00, 8.3100066942E-01],
	[2.2465000000E+04, 1.3379396801E+01, 5.2774381334E+00, 2.6305906244E+00, 1.5519023719E+00, 8.3108098003E-01],
	[2.2470000000E+04, 1.3383951306E+01, 5.2773451622E+00, 2.6324867825E+00, 1.5526153688E+00, 8.3116125723E-01],
	[2.2475000000E+04, 1.3388506348E+01, 5.2772522134E+00, 2.6343838846E+00, 1.5533283653E+00, 8.3124150101E-01],
	[2.2480000000E+04, 1.3393061926E+01, 5.2771592868E+00, 2.6362819310E+00, 1.5540413614E+00, 8.3132171138E-01],
	[2.2485000000E+04, 1.3397618041E+01, 5.2770663826E+00, 2.6381809219E+00, 1.5547543570E+00, 8.3140188836E-01],
	[2.2490000000E+04, 1.3402174692E+01, 5.2769735006E+00, 2.6400808575E+00, 1.5554673518E+00, 8.3148203194E-01],
	[2.2495000000E+04, 1.3406731879E+01, 5.2768806409E+00, 2.6419817382E+00, 1.5561803457E+00, 8.3156214214E-01],
	[2.2500000000E+04, 1.3411289603E+01, 5.2767878035E+00, 2.6438835642E+00, 1.5568933386E+00, 8.3164221897E-01],
	[2.2505000000E+04, 1.3415847862E+01, 5.2766949884E+00, 2.6457863357E+00, 1.5576063302E+00, 8.3172226242E-01],
	[2.2510000000E+04, 1.3420406658E+01, 5.2766021955E+00, 2.6476900531E+00, 1.5583193206E+00, 8.3180227251E-01],
	[2.2515000000E+04, 1.3424965990E+01, 5.2765094248E+00, 2.6495947165E+00, 1.5590323094E+00, 8.3188224925E-01],
	[2.2520000000E+04, 1.3429525858E+01, 5.2764166764E+00, 2.6515003263E+00, 1.5597452966E+00, 8.3196219263E-01],
	[2.2525000000E+04, 1.3434086262E+01, 5.2763239502E+00, 2.6534068827E+00, 1.5604582820E+00, 8.3204210268E-01],
	[2.2530000000E+04, 1.3438647202E+01, 5.2762312462E+00, 2.6553143859E+00, 1.5611712655E+00, 8.3212197939E-01],
	[2.2535000000E+04, 1.3443208678E+01, 5.2761385644E+00, 2.6572228362E+00, 1.5618842468E+00, 8.3220182278E-01],
	[2.2540000000E+04, 1.3447770689E+01, 5.2760459048E+00, 2.6591322339E+00, 1.5625972260E+00, 8.3228163285E-01],
	[2.2545000000E+04, 1.3452333237E+01, 5.2759532674E+00, 2.6610425793E+00, 1.5633102027E+00, 8.3236140960E-01],
	[2.2550000000E+04, 1.3456896320E+01, 5.2758606521E+00, 2.6629538725E+00, 1.5640231769E+00, 8.3244115306E-01],
	[2.2555000000E+04, 1.3461459938E+01, 5.2757680590E+00, 2.6648661139E+00, 1.5647361483E+00, 8.3252086321E-01],
	[2.2560000000E+04, 1.3466024093E+01, 5.2756754881E+00, 2.6667793037E+00, 1.5654491170E+00, 8.3260054008E-01],
	[2.2565000000E+04, 1.3470588782E+01, 5.2755829393E+00, 2.6686934421E+00, 1.5661620826E+00, 8.3268018366E-01],
	[2.2570000000E+04, 1.3475154008E+01, 5.2754904126E+00, 2.6706085295E+00, 1.5668750451E+00, 8.3275979397E-01],
	[2.2575000000E+04, 1.3479719768E+01, 5.2753979080E+00, 2.6725245661E+00, 1.5675880043E+00, 8.3283937102E-01],
	[2.2580000000E+04, 1.3484286064E+01, 5.2753054255E+00, 2.6744415521E+00, 1.5683009601E+00, 8.3291891480E-01],
	[2.2585000000E+04, 1.3488852896E+01, 5.2752129652E+00, 2.6763594879E+00, 1.5690139123E+00, 8.3299842533E-01],
	[2.2590000000E+04, 1.3493420262E+01, 5.2751205269E+00, 2.6782783736E+00, 1.5697268607E+00, 8.3307790261E-01],
	[2.2595000000E+04, 1.3497988164E+01, 5.2750281107E+00, 2.6801982095E+00, 1.5704398052E+00, 8.3315734665E-01],
	[2.2600000000E+04, 1.3502556601E+01, 5.2749357166E+00, 2.6821189960E+00, 1.5711527457E+00, 8.3323675745E-01],
	[2.2605000000E+04, 1.3507125573E+01, 5.2748433445E+00, 2.6840407332E+00, 1.5718656820E+00, 8.3331613501E-01],
	[2.2610000000E+04, 1.3511695080E+01, 5.2747509945E+00, 2.6859634214E+00, 1.5725786140E+00, 8.3339547935E-01],
	[2.2615000000E+04, 1.3516265122E+01, 5.2746586665E+00, 2.6878870608E+00, 1.5732915415E+00, 8.3347479047E-01],
	[2.2620000000E+04, 1.3520835699E+01, 5.2745663605E+00, 2.6898116518E+00, 1.5740044643E+00, 8.3355406837E-01],
	[2.2625000000E+04, 1.3525406811E+01, 5.2744740765E+00, 2.6917371946E+00, 1.5747173824E+00, 8.3363331305E-01],
	[2.2630000000E+04, 1.3529978457E+01, 5.2743818146E+00, 2.6936636894E+00, 1.5754302955E+00, 8.3371252454E-01],
	[2.2635000000E+04, 1.3534550639E+01, 5.2742895747E+00, 2.6955911366E+00, 1.5761432035E+00, 8.3379170282E-01],
	[2.2640000000E+04, 1.3539123355E+01, 5.2741973567E+00, 2.6975195363E+00, 1.5768561064E+00, 8.3387084791E-01],
	[2.2645000000E+04, 1.3543696606E+01, 5.2741051607E+00, 2.6994488888E+00, 1.5775690038E+00, 8.3394995982E-01],
	[2.2650000000E+04, 1.3548270391E+01, 5.2740129867E+00, 2.7013791944E+00, 1.5782818957E+00, 8.3402903854E-01],
	[2.2655000000E+04, 1.3552844711E+01, 5.2739208346E+00, 2.7033104534E+00, 1.5789947819E+00, 8.3410808408E-01],
	[2.2660000000E+04, 1.3557419565E+01, 5.2738287045E+00, 2.7052426660E+00, 1.5797076623E+00, 8.3418709645E-01],
	[2.2665000000E+04, 1.3561994954E+01, 5.2737365963E+00, 2.7071758324E+00, 1.5804205367E+00, 8.3426607566E-01],
	[2.2670000000E+04, 1.3566570877E+01, 5.2736445101E+00, 2.7091099530E+00, 1.5811334050E+00, 8.3434502171E-01],
	[2.2675000000E+04, 1.3571147334E+01, 5.2735524457E+00, 2.7110450280E+00, 1.5818462670E+00, 8.3442393461E-01],
	[2.2680000000E+04, 1.3575724326E+01, 5.2734604033E+00, 2.7129810576E+00, 1.5825591226E+00, 8.3450281435E-01],
	[2.2685000000E+04, 1.3580301852E+01, 5.2733683827E+00, 2.7149180421E+00, 1.5832719716E+00, 8.3458166096E-01],
	[2.2690000000E+04, 1.3584879911E+01, 5.2732763841E+00, 2.7168559818E+00, 1.5839848139E+00, 8.3466047443E-01],
	[2.2695000000E+04, 1.3589458506E+01, 5.2731844073E+00, 2.7187948769E+00, 1.5846976494E+00, 8.3473925477E-01],
	[2.2700000000E+04, 1.3594037634E+01, 5.2730924524E+00, 2.7207347277E+00, 1.5854104778E+00, 8.3481800198E-01],
	[2.2705000000E+04, 1.3598617296E+01, 5.2730005193E+00, 2.7226755344E+00, 1.5861232991E+00, 8.3489671608E-01],
	[2.2710000000E+04, 1.3603197492E+01, 5.2729086081E+00, 2.7246172974E+00, 1.5868361130E+00, 8.3497539706E-01],
	[2.2715000000E+04, 1.3607778221E+01, 5.2728167187E+00, 2.7265600168E+00, 1.5875489196E+00, 8.3505404494E-01],
	[2.2720000000E+04, 1.3612359485E+01, 5.2727248512E+00, 2.7285036930E+00, 1.5882617185E+00, 8.3513265972E-01],
	[2.2725000000E+04, 1.3616941282E+01, 5.2726330054E+00, 2.7304483261E+00, 1.5889745096E+00, 8.3521124140E-01],
	[2.2730000000E+04, 1.3621523614E+01, 5.2725411815E+00, 2.7323939165E+00, 1.5896872929E+00, 8.3528978999E-01],
	[2.2735000000E+04, 1.3626106478E+01, 5.2724493793E+00, 2.7343404644E+00, 1.5904000681E+00, 8.3536830550E-01],
	[2.2740000000E+04, 1.3630689877E+01, 5.2723575990E+00, 2.7362879701E+00, 1.5911128351E+00, 8.3544678793E-01],
	[2.2745000000E+04, 1.3635273808E+01, 5.2722658404E+00, 2.7382364338E+00, 1.5918255938E+00, 8.3552523730E-01],
	[2.2750000000E+04, 1.3639858274E+01, 5.2721741036E+00, 2.7401858558E+00, 1.5925383440E+00, 8.3560365360E-01],
	[2.2755000000E+04, 1.3644443272E+01, 5.2720823885E+00, 2.7421362363E+00, 1.5932510856E+00, 8.3568203684E-01],
	[2.2760000000E+04, 1.3649028805E+01, 5.2719906952E+00, 2.7440875757E+00, 1.5939638184E+00, 8.3576038702E-01],
	[2.2765000000E+04, 1.3653614870E+01, 5.2718990236E+00, 2.7460398741E+00, 1.5946765423E+00, 8.3583870416E-01],
	[2.2770000000E+04, 1.3658201469E+01, 5.2718073738E+00, 2.7479931318E+00, 1.5953892570E+00, 8.3591698827E-01],
	[2.2775000000E+04, 1.3662788601E+01, 5.2717157456E+00, 2.7499473492E+00, 1.5961019626E+00, 8.3599523933E-01],
	[2.2780000000E+04, 1.3667376266E+01, 5.2716241392E+00, 2.7519025264E+00, 1.5968146588E+00, 8.3607345737E-01],
	[2.2785000000E+04, 1.3671964464E+01, 5.2715325545E+00, 2.7538586637E+00, 1.5975273455E+00, 8.3615164239E-01],
	[2.2790000000E+04, 1.3676553195E+01, 5.2714409914E+00, 2.7558157614E+00, 1.5982400225E+00, 8.3622979439E-01],
	[2.2795000000E+04, 1.3681142459E+01, 5.2713494500E+00, 2.7577738197E+00, 1.5989526898E+00, 8.3630791339E-01],
	[2.2800000000E+04, 1.3685745985E+01, 5.2712606946E+00, 2.7597328389E+00, 1.5996657892E+00, 8.3638599937E-01],
	[2.2805000000E+04, 1.3690357555E+01, 5.2711734708E+00, 2.7616928192E+00, 1.6003791209E+00, 8.3646405237E-01],
	[2.2810000000E+04, 1.3694969667E+01, 5.2710862675E+00, 2.7636537610E+00, 1.6010924432E+00, 8.3654207237E-01],
	[2.2815000000E+04, 1.3699582322E+01, 5.2709990848E+00, 2.7656156644E+00, 1.6018057560E+00, 8.3662005939E-01],
	[2.2820000000E+04, 1.3704195520E+01, 5.2709119226E+00, 2.7675785298E+00, 1.6025190592E+00, 8.3669801343E-01],
	[2.2825000000E+04, 1.3708809259E+01, 5.2708247810E+00, 2.7695423574E+00, 1.6032323526E+00, 8.3677593450E-01],
	[2.2830000000E+04, 1.3713423541E+01, 5.2707376599E+00, 2.7715071474E+00, 1.6039456360E+00, 8.3685382260E-01],
	[2.2835000000E+04, 1.3718038365E+01, 5.2706505593E+00, 2.7734729001E+00, 1.6046589094E+00, 8.3693167775E-01],
	[2.2840000000E+04, 1.3722653731E+01, 5.2705634792E+00, 2.7754396158E+00, 1.6053721725E+00, 8.3700949994E-01],
	[2.2845000000E+04, 1.3727269639E+01, 5.2704764197E+00, 2.7774072948E+00, 1.6060854252E+00, 8.3708728918E-01],
	[2.2850000000E+04, 1.3731886089E+01, 5.2703893806E+00, 2.7793759372E+00, 1.6067986675E+00, 8.3716504549E-01],
	[2.2855000000E+04, 1.3736503081E+01, 5.2703023620E+00, 2.7813455434E+00, 1.6075118990E+00, 8.3724276886E-01],
	[2.2860000000E+04, 1.3741120615E+01, 5.2702153638E+00, 2.7833161136E+00, 1.6082251197E+00, 8.3732045931E-01],
	[2.2865000000E+04, 1.3745738690E+01, 5.2701283861E+00, 2.7852876481E+00, 1.6089383295E+00, 8.3739811683E-01],
	[2.2870000000E+04, 1.3750357308E+01, 5.2700414289E+00, 2.7872601471E+00, 1.6096515282E+00, 8.3747574144E-01],
	[2.2875000000E+04, 1.3754976467E+01, 5.2699544921E+00, 2.7892336110E+00, 1.6103647156E+00, 8.3755333315E-01],
	[2.2880000000E+04, 1.3759596168E+01, 5.2698675758E+00, 2.7912080399E+00, 1.6110778916E+00, 8.3763089195E-01],
	[2.2885000000E+04, 1.3764216410E+01, 5.2697806799E+00, 2.7931834341E+00, 1.6117910561E+00, 8.3770841786E-01],
	[2.2890000000E+04, 1.3768837194E+01, 5.2696938044E+00, 2.7951597938E+00, 1.6125042089E+00, 8.3778591088E-01],
	[2.2895000000E+04, 1.3773458520E+01, 5.2696069493E+00, 2.7971371195E+00, 1.6132173499E+00, 8.3786337102E-01],
	[2.2900000000E+04, 1.3778080387E+01, 5.2695201146E+00, 2.7991154112E+00, 1.6139304789E+00, 8.3794079828E-01],
	[2.2905000000E+04, 1.3782702795E+01, 5.2694333003E+00, 2.8010946693E+00, 1.6146435958E+00, 8.3801819268E-01],
	[2.2910000000E+04, 1.3787325745E+01, 5.2693465063E+00, 2.8030748940E+00, 1.6153567004E+00, 8.3809555421E-01],
	[2.2915000000E+04, 1.3791949236E+01, 5.2692597328E+00, 2.8050560856E+00, 1.6160697927E+00, 8.3817288289E-01],
	[2.2920000000E+04, 1.3796573268E+01, 5.2691729796E+00, 2.8070382444E+00, 1.6167828723E+00, 8.3825017872E-01],
	[2.2925000000E+04, 1.3801197841E+01, 5.2690862467E+00, 2.8090213705E+00, 1.6174959393E+00, 8.3832744171E-01],
	[2.2930000000E+04, 1.3805822956E+01, 5.2689995342E+00, 2.8110054643E+00, 1.6182089934E+00, 8.3840467187E-01],
	[2.2935000000E+04, 1.3810448611E+01, 5.2689128420E+00, 2.8129905260E+00, 1.6189220346E+00, 8.3848186919E-01],
	[2.2940000000E+04, 1.3815074808E+01, 5.2688261702E+00, 2.8149765560E+00, 1.6196350626E+00, 8.3855903370E-01],
	[2.2945000000E+04, 1.3819701546E+01, 5.2687395186E+00, 2.8169635543E+00, 1.6203480773E+00, 8.3863616539E-01],
	[2.2950000000E+04, 1.3824328824E+01, 5.2686528874E+00, 2.8189515214E+00, 1.6210610787E+00, 8.3871326427E-01],
	[2.2955000000E+04, 1.3828956643E+01, 5.2685662764E+00, 2.8209404575E+00, 1.6217740664E+00, 8.3879033035E-01],
	[2.2960000000E+04, 1.3833585003E+01, 5.2684796858E+00, 2.8229303627E+00, 1.6224870405E+00, 8.3886736363E-01],
	[2.2965000000E+04, 1.3838213904E+01, 5.2683931154E+00, 2.8249212375E+00, 1.6232000007E+00, 8.3894436413E-01],
	[2.2970000000E+04, 1.3842843345E+01, 5.2683065653E+00, 2.8269130820E+00, 1.6239129469E+00, 8.3902133184E-01],
	[2.2975000000E+04, 1.3847473327E+01, 5.2682200354E+00, 2.8289058966E+00, 1.6246258790E+00, 8.3909826679E-01],
	[2.2980000000E+04, 1.3852103850E+01, 5.2681335258E+00, 2.8308996814E+00, 1.6253387968E+00, 8.3917516896E-01],
	[2.2985000000E+04, 1.3856734913E+01, 5.2680470365E+00, 2.8328944367E+00, 1.6260517002E+00, 8.3925203837E-01],
	[2.2990000000E+04, 1.3861366517E+01, 5.2679605674E+00, 2.8348901628E+00, 1.6267645891E+00, 8.3932887503E-01],
	[2.2995000000E+04, 1.3865998661E+01, 5.2678741185E+00, 2.8368868600E+00, 1.6274774632E+00, 8.3940567895E-01],
	[2.3000000000E+04, 1.3870631345E+01, 5.2677876898E+00, 2.8388845285E+00, 1.6281903225E+00, 8.3948245012E-01],
	[2.3005000000E+04, 1.3875264570E+01, 5.2677012813E+00, 2.8408831686E+00, 1.6289031667E+00, 8.3955918856E-01],
	[2.3010000000E+04, 1.3879898335E+01, 5.2676148930E+00, 2.8428827805E+00, 1.6296159959E+00, 8.3963589427E-01],
	[2.3015000000E+04, 1.3884532640E+01, 5.2675285249E+00, 2.8448833645E+00, 1.6303288097E+00, 8.3971256727E-01],
	[2.3020000000E+04, 1.3889167485E+01, 5.2674421769E+00, 2.8468849209E+00, 1.6310416082E+00, 8.3978920755E-01],
	[2.3025000000E+04, 1.3893802870E+01, 5.2673558492E+00, 2.8488874499E+00, 1.6317543910E+00, 8.3986581513E-01],
	[2.3030000000E+04, 1.3898438796E+01, 5.2672695416E+00, 2.8508909518E+00, 1.6324671582E+00, 8.3994239000E-01],
	[2.3035000000E+04, 1.3903075261E+01, 5.2671832541E+00, 2.8528954268E+00, 1.6331799095E+00, 8.4001893219E-01],
	[2.3040000000E+04, 1.3907712266E+01, 5.2670969868E+00, 2.8549008752E+00, 1.6338926448E+00, 8.4009544169E-01],
	[2.3045000000E+04, 1.3912349811E+01, 5.2670107396E+00, 2.8569072973E+00, 1.6346053640E+00, 8.4017191852E-01],
	[2.3050000000E+04, 1.3916987896E+01, 5.2669245126E+00, 2.8589146933E+00, 1.6353180669E+00, 8.4024836268E-01],
	[2.3055000000E+04, 1.3921626521E+01, 5.2668383056E+00, 2.8609230635E+00, 1.6360307534E+00, 8.4032477417E-01],
	[2.3060000000E+04, 1.3926265685E+01, 5.2667521188E+00, 2.8629324081E+00, 1.6367434233E+00, 8.4040115301E-01],
	[2.3065000000E+04, 1.3930905389E+01, 5.2666659521E+00, 2.8649427275E+00, 1.6374560765E+00, 8.4047749919E-01],
	[2.3070000000E+04, 1.3935545633E+01, 5.2665798054E+00, 2.8669540218E+00, 1.6381687129E+00, 8.4055381274E-01],
	[2.3075000000E+04, 1.3940186416E+01, 5.2664936788E+00, 2.8689662914E+00, 1.6388813323E+00, 8.4063009365E-01],
	[2.3080000000E+04, 1.3944827739E+01, 5.2664075723E+00, 2.8709795364E+00, 1.6395939345E+00, 8.4070634193E-01],
	[2.3085000000E+04, 1.3949469601E+01, 5.2663214859E+00, 2.8729937572E+00, 1.6403065195E+00, 8.4078255760E-01],
	[2.3090000000E+04, 1.3954112002E+01, 5.2662354195E+00, 2.8750089540E+00, 1.6410190871E+00, 8.4085874065E-01],
	[2.3095000000E+04, 1.3958754943E+01, 5.2661493731E+00, 2.8770251271E+00, 1.6417316371E+00, 8.4093489109E-01],
	[2.3100000000E+04, 1.3963398423E+01, 5.2660633468E+00, 2.8790422767E+00, 1.6424441694E+00, 8.4101100894E-01],
	[2.3105000000E+04, 1.3968042442E+01, 5.2659773405E+00, 2.8810604031E+00, 1.6431566839E+00, 8.4108709419E-01],
	[2.3110000000E+04, 1.3972687000E+01, 5.2658913542E+00, 2.8830795066E+00, 1.6438691804E+00, 8.4116314686E-01],
	[2.3115000000E+04, 1.3977332098E+01, 5.2658053879E+00, 2.8850995874E+00, 1.6445816587E+00, 8.4123916695E-01],
	[2.3120000000E+04, 1.3981977734E+01, 5.2657194416E+00, 2.8871206458E+00, 1.6452941188E+00, 8.4131515447E-01],
	[2.3125000000E+04, 1.3986623910E+01, 5.2656335153E+00, 2.8891426820E+00, 1.6460065605E+00, 8.4139110943E-01],
	[2.3130000000E+04, 1.3991270624E+01, 5.2655476090E+00, 2.8911656963E+00, 1.6467189837E+00, 8.4146703184E-01],
	[2.3135000000E+04, 1.3995917878E+01, 5.2654617226E+00, 2.8931896890E+00, 1.6474313882E+00, 8.4154292170E-01],
	[2.3140000000E+04, 1.4000565670E+01, 5.2653758562E+00, 2.8952146603E+00, 1.6481437738E+00, 8.4161877901E-01],
	[2.3145000000E+04, 1.4005214001E+01, 5.2652900098E+00, 2.8972406105E+00, 1.6488561405E+00, 8.4169460379E-01],
	[2.3150000000E+04, 1.4009862870E+01, 5.2652041833E+00, 2.8992675398E+00, 1.6495684880E+00, 8.4177039605E-01],
	[2.3155000000E+04, 1.4014512279E+01, 5.2651183767E+00, 2.9012954486E+00, 1.6502808163E+00, 8.4184615579E-01],
	[2.3160000000E+04, 1.4019162226E+01, 5.2650325901E+00, 2.9033243370E+00, 1.6509931253E+00, 8.4192188302E-01],
	[2.3165000000E+04, 1.4023818030E+01, 5.2649478645E+00, 2.9053542053E+00, 1.6517055909E+00, 8.4199757774E-01],
	[2.3170000000E+04, 1.4028490575E+01, 5.2648663287E+00, 2.9073850539E+00, 1.6524185741E+00, 8.4207323997E-01],
	[2.3175000000E+04, 1.4033163668E+01, 5.2647848117E+00, 2.9094168829E+00, 1.6531315384E+00, 8.4214886970E-01],
	[2.3180000000E+04, 1.4037837309E+01, 5.2647033135E+00, 2.9114496926E+00, 1.6538444837E+00, 8.4222446696E-01],
	[2.3185000000E+04, 1.4042511498E+01, 5.2646218342E+00, 2.9134834833E+00, 1.6545574097E+00, 8.4230003174E-01],
	[2.3190000000E+04, 1.4047186235E+01, 5.2645403737E+00, 2.9155182552E+00, 1.6552703164E+00, 8.4237556406E-01],
	[2.3195000000E+04, 1.4051861519E+01, 5.2644589320E+00, 2.9175540086E+00, 1.6559832036E+00, 8.4245106392E-01],
	[2.3200000000E+04, 1.4056537352E+01, 5.2643775091E+00, 2.9195907438E+00, 1.6566960712E+00, 8.4252653132E-01],
	[2.3205000000E+04, 1.4061213733E+01, 5.2642961051E+00, 2.9216284610E+00, 1.6574089191E+00, 8.4260196628E-01],
	[2.3210000000E+04, 1.4065890661E+01, 5.2642147198E+00, 2.9236671605E+00, 1.6581217470E+00, 8.4267736881E-01],
	[2.3215000000E+04, 1.4070568137E+01, 5.2641333533E+00, 2.9257068425E+00, 1.6588345549E+00, 8.4275273890E-01],
	[2.3220000000E+04, 1.4075246160E+01, 5.2640520056E+00, 2.9277475074E+00, 1.6595473426E+00, 8.4282807658E-01],
	[2.3225000000E+04, 1.4079924731E+01, 5.2639706767E+00, 2.9297891553E+00, 1.6602601100E+00, 8.4290338184E-01],
	[2.3230000000E+04, 1.4084603850E+01, 5.2638893666E+00, 2.9318317865E+00, 1.6609728570E+00, 8.4297865469E-01],
	[2.3235000000E+04, 1.4089283516E+01, 5.2638080752E+00, 2.9338754014E+00, 1.6616855833E+00, 8.4305389515E-01],
	[2.3240000000E+04, 1.4093963730E+01, 5.2637268025E+00, 2.9359200001E+00, 1.6623982889E+00, 8.4312910321E-01],
	[2.3245000000E+04, 1.4098644490E+01, 5.2636455486E+00, 2.9379655829E+00, 1.6631109737E+00, 8.4320427889E-01],
	[2.3250000000E+04, 1.4103325799E+01, 5.2635643134E+00, 2.9400121500E+00, 1.6638236374E+00, 8.4327942220E-01],
	[2.3255000000E+04, 1.4108007654E+01, 5.2634830969E+00, 2.9420597018E+00, 1.6645362799E+00, 8.4335453313E-01],
	[2.3260000000E+04, 1.4112690057E+01, 5.2634018992E+00, 2.9441082385E+00, 1.6652489012E+00, 8.4342961171E-01],
	[2.3265000000E+04, 1.4117373006E+01, 5.2633207201E+00, 2.9461577604E+00, 1.6659615011E+00, 8.4350465793E-01],
	[2.3270000000E+04, 1.4122056503E+01, 5.2632395598E+00, 2.9482082677E+00, 1.6666740793E+00, 8.4357967181E-01],
	[2.3275000000E+04, 1.4126740547E+01, 5.2631584181E+00, 2.9502597607E+00, 1.6673866359E+00, 8.4365465335E-01],
	[2.3280000000E+04, 1.4131425138E+01, 5.2630772951E+00, 2.9523122396E+00, 1.6680991706E+00, 8.4372960256E-01],
	[2.3285000000E+04, 1.4136110276E+01, 5.2629961908E+00, 2.9543657047E+00, 1.6688116833E+00, 8.4380451945E-01],
	[2.3290000000E+04, 1.4140795961E+01, 5.2629151052E+00, 2.9564201563E+00, 1.6695241739E+00, 8.4387940403E-01],
	[2.3295000000E+04, 1.4145482192E+01, 5.2628340382E+00, 2.9584755946E+00, 1.6702366423E+00, 8.4395425630E-01],
	[2.3300000000E+04, 1.4150168970E+01, 5.2627529898E+00, 2.9605320199E+00, 1.6709490882E+00, 8.4402907627E-01],
	[2.3305000000E+04, 1.4154856295E+01, 5.2626719601E+00, 2.9625894325E+00, 1.6716615116E+00, 8.4410386395E-01],
	[2.3310000000E+04, 1.4159544167E+01, 5.2625909490E+00, 2.9646478326E+00, 1.6723739123E+00, 8.4417861935E-01],
	[2.3315000000E+04, 1.4164232585E+01, 5.2625099566E+00, 2.9667072204E+00, 1.6730862902E+00, 8.4425334247E-01],
	[2.3320000000E+04, 1.4168921550E+01, 5.2624289827E+00, 2.9687675963E+00, 1.6737986452E+00, 8.4432803332E-01],
	[2.3325000000E+04, 1.4173611062E+01, 5.2623480275E+00, 2.9708289605E+00, 1.6745109770E+00, 8.4440269192E-01],
	[2.3330000000E+04, 1.4178301119E+01, 5.2622670908E+00, 2.9728913133E+00, 1.6752232856E+00, 8.4447731826E-01],
	[2.3335000000E+04, 1.4182991724E+01, 5.2621861728E+00, 2.9749546548E+00, 1.6759355709E+00, 8.4455191236E-01],
	[2.3340000000E+04, 1.4187682874E+01, 5.2621052733E+00, 2.9770189855E+00, 1.6766478327E+00, 8.4462647422E-01],
	[2.3345000000E+04, 1.4192374571E+01, 5.2620243924E+00, 2.9790843055E+00, 1.6773600708E+00, 8.4470100386E-01],
	[2.3350000000E+04, 1.4197066814E+01, 5.2619435301E+00, 2.9811506151E+00, 1.6780722851E+00, 8.4477550128E-01],
	[2.3355000000E+04, 1.4201759603E+01, 5.2618626863E+00, 2.9832179146E+00, 1.6787844755E+00, 8.4484996648E-01],
	[2.3360000000E+04, 1.4206452939E+01, 5.2617818610E+00, 2.9852862042E+00, 1.6794966419E+00, 8.4492439948E-01],
	[2.3365000000E+04, 1.4211146820E+01, 5.2617010543E+00, 2.9873554842E+00, 1.6802087840E+00, 8.4499880028E-01],
	[2.3370000000E+04, 1.4215841247E+01, 5.2616202662E+00, 2.9894257549E+00, 1.6809209019E+00, 8.4507316890E-01],
	[2.3375000000E+04, 1.4220536221E+01, 5.2615394965E+00, 2.9914970165E+00, 1.6816329953E+00, 8.4514750533E-01],
	[2.3380000000E+04, 1.4225231740E+01, 5.2614587454E+00, 2.9935692692E+00, 1.6823450640E+00, 8.4522180960E-01],
	[2.3385000000E+04, 1.4229927805E+01, 5.2613780128E+00, 2.9956425134E+00, 1.6830571081E+00, 8.4529608170E-01],
	[2.3390000000E+04, 1.4234624417E+01, 5.2612972987E+00, 2.9977167493E+00, 1.6837691272E+00, 8.4537032164E-01],
	[2.3395000000E+04, 1.4239321573E+01, 5.2612166030E+00, 2.9997919772E+00, 1.6844811214E+00, 8.4544452943E-01],
	[2.3400000000E+04, 1.4244019276E+01, 5.2611359259E+00, 3.0018681973E+00, 1.6851930904E+00, 8.4551870509E-01],
	[2.3405000000E+04, 1.4248717524E+01, 5.2610552672E+00, 3.0039454099E+00, 1.6859050341E+00, 8.4559284861E-01],
	[2.3410000000E+04, 1.4253416318E+01, 5.2609746270E+00, 3.0060236152E+00, 1.6866169523E+00, 8.4566696001E-01],
	[2.3415000000E+04, 1.4258115657E+01, 5.2608940052E+00, 3.0081028136E+00, 1.6873288451E+00, 8.4574103929E-01],
	[2.3420000000E+04, 1.4262815542E+01, 5.2608134019E+00, 3.0101830052E+00, 1.6880407121E+00, 8.4581508647E-01],
	[2.3425000000E+04, 1.4267515972E+01, 5.2607328170E+00, 3.0122641903E+00, 1.6887525533E+00, 8.4588910154E-01],
	[2.3430000000E+04, 1.4272216947E+01, 5.2606522506E+00, 3.0143463693E+00, 1.6894643685E+00, 8.4596308452E-01],
	[2.3435000000E+04, 1.4276918468E+01, 5.2605717026E+00, 3.0164295423E+00, 1.6901761576E+00, 8.4603703543E-01],
	[2.3440000000E+04, 1.4281620535E+01, 5.2604911730E+00, 3.0185137097E+00, 1.6908879205E+00, 8.4611095425E-01],
	[2.3445000000E+04, 1.4286323146E+01, 5.2604106618E+00, 3.0205988716E+00, 1.6915996570E+00, 8.4618484101E-01],
	[2.3450000000E+04, 1.4291026303E+01, 5.2603301690E+00, 3.0226850283E+00, 1.6923113670E+00, 8.4625869571E-01],
	[2.3455000000E+04, 1.4295730004E+01, 5.2602496947E+00, 3.0247721802E+00, 1.6930230504E+00, 8.4633251836E-01],
	[2.3460000000E+04, 1.4300434251E+01, 5.2601692386E+00, 3.0268603275E+00, 1.6937347069E+00, 8.4640630896E-01],
	[2.3465000000E+04, 1.4305139043E+01, 5.2600888010E+00, 3.0289494703E+00, 1.6944463366E+00, 8.4648006754E-01],
	[2.3470000000E+04, 1.4309844380E+01, 5.2600083818E+00, 3.0310396091E+00, 1.6951579392E+00, 8.4655379408E-01],
	[2.3475000000E+04, 1.4314550261E+01, 5.2599279808E+00, 3.0331307440E+00, 1.6958695145E+00, 8.4662748861E-01],
	[2.3480000000E+04, 1.4319256688E+01, 5.2598475983E+00, 3.0352228754E+00, 1.6965810626E+00, 8.4670115113E-01],
	[2.3485000000E+04, 1.4323963659E+01, 5.2597672341E+00, 3.0373160034E+00, 1.6972925832E+00, 8.4677478165E-01],
	[2.3490000000E+04, 1.4328671175E+01, 5.2596868882E+00, 3.0394101284E+00, 1.6980040762E+00, 8.4684838017E-01],
	[2.3495000000E+04, 1.4333379236E+01, 5.2596065607E+00, 3.0415052506E+00, 1.6987155415E+00, 8.4692194671E-01],
	[2.3500000000E+04, 1.4338087841E+01, 5.2595262514E+00, 3.0436013702E+00, 1.6994269789E+00, 8.4699548127E-01],
	[2.3505000000E+04, 1.4342796991E+01, 5.2594459605E+00, 3.0456984876E+00, 1.7001383883E+00, 8.4706898387E-01],
	[2.3510000000E+04, 1.4347506686E+01, 5.2593656879E+00, 3.0477966030E+00, 1.7008497696E+00, 8.4714245451E-01],
	[2.3515000000E+04, 1.4352216925E+01, 5.2592854336E+00, 3.0498957166E+00, 1.7015611226E+00, 8.4721589319E-01],
	[2.3520000000E+04, 1.4356927708E+01, 5.2592051976E+00, 3.0519958287E+00, 1.7022724472E+00, 8.4728929993E-01],
	[2.3525000000E+04, 1.4361639036E+01, 5.2591249798E+00, 3.0540969396E+00, 1.7029837433E+00, 8.4736267474E-01],
	[2.3530000000E+04, 1.4366350908E+01, 5.2590447803E+00, 3.0561990496E+00, 1.7036950107E+00, 8.4743601762E-01],
	[2.3535000000E+04, 1.4371063324E+01, 5.2589645991E+00, 3.0583021588E+00, 1.7044062493E+00, 8.4750932858E-01],
	[2.3540000000E+04, 1.4375790813E+01, 5.2588872001E+00, 3.0604062677E+00, 1.7051179538E+00, 8.4758260764E-01],
	[2.3545000000E+04, 1.4380526133E+01, 5.2588112034E+00, 3.0625113763E+00, 1.7058298781E+00, 8.4765585479E-01],
	[2.3550000000E+04, 1.4385262006E+01, 5.2587352239E+00, 3.0646174850E+00, 1.7065417740E+00, 8.4772907005E-01],
	[2.3555000000E+04, 1.4389998434E+01, 5.2586592617E+00, 3.0667245941E+00, 1.7072536415E+00, 8.4780225343E-01],
	[2.3560000000E+04, 1.4394735415E+01, 5.2585833167E+00, 3.0688327038E+00, 1.7079654804E+00, 8.4787540493E-01],
	[2.3565000000E+04, 1.4399472950E+01, 5.2585073888E+00, 3.0709418144E+00, 1.7086772906E+00, 8.4794852456E-01],
	[2.3570000000E+04, 1.4404211038E+01, 5.2584314782E+00, 3.0730519261E+00, 1.7093890719E+00, 8.4802161234E-01],
	[2.3575000000E+04, 1.4408949680E+01, 5.2583555848E+00, 3.0751630392E+00, 1.7101008242E+00, 8.4809466826E-01],
	[2.3580000000E+04, 1.4413688875E+01, 5.2582797086E+00, 3.0772751540E+00, 1.7108125474E+00, 8.4816769234E-01],
	[2.3585000000E+04, 1.4418428624E+01, 5.2582038495E+00, 3.0793882707E+00, 1.7115242414E+00, 8.4824068459E-01],
	[2.3590000000E+04, 1.4423168926E+01, 5.2581280077E+00, 3.0815023896E+00, 1.7122359060E+00, 8.4831364502E-01],
	[2.3595000000E+04, 1.4427909782E+01, 5.2580521830E+00, 3.0836175110E+00, 1.7129475410E+00, 8.4838657362E-01],
	[2.3600000000E+04, 1.4432651191E+01, 5.2579763754E+00, 3.0857336350E+00, 1.7136591464E+00, 8.4845947043E-01],
	[2.3605000000E+04, 1.4437393153E+01, 5.2579005850E+00, 3.0878507621E+00, 1.7143707220E+00, 8.4853233543E-01],
	[2.3610000000E+04, 1.4442135668E+01, 5.2578248118E+00, 3.0899688924E+00, 1.7150822677E+00, 8.4860516864E-01],
	[2.3615000000E+04, 1.4446878736E+01, 5.2577490557E+00, 3.0920880261E+00, 1.7157937833E+00, 8.4867797007E-01],
	[2.3620000000E+04, 1.4451622358E+01, 5.2576733167E+00, 3.0942081637E+00, 1.7165052687E+00, 8.4875073972E-01],
	[2.3625000000E+04, 1.4456366532E+01, 5.2575975948E+00, 3.0963293052E+00, 1.7172167239E+00, 8.4882347762E-01],
	[2.3630000000E+04, 1.4461111260E+01, 5.2575218901E+00, 3.0984514511E+00, 1.7179281485E+00, 8.4889618375E-01],
	[2.3635000000E+04, 1.4465856540E+01, 5.2574462024E+00, 3.1005746015E+00, 1.7186395426E+00, 8.4896885814E-01],
	[2.3640000000E+04, 1.4470602373E+01, 5.2573705319E+00, 3.1026987567E+00, 1.7193509060E+00, 8.4904150079E-01],
	[2.3645000000E+04, 1.4475348759E+01, 5.2572948784E+00, 3.1048239170E+00, 1.7200622385E+00, 8.4911411171E-01],
	[2.3650000000E+04, 1.4480095698E+01, 5.2572192421E+00, 3.1069500826E+00, 1.7207735400E+00, 8.4918669091E-01],
	[2.3655000000E+04, 1.4484843190E+01, 5.2571436228E+00, 3.1090772538E+00, 1.7214848104E+00, 8.4925923839E-01],
	[2.3660000000E+04, 1.4489591234E+01, 5.2570680206E+00, 3.1112054309E+00, 1.7221960496E+00, 8.4933175417E-01],
	[2.3665000000E+04, 1.4494339830E+01, 5.2569924354E+00, 3.1133346141E+00, 1.7229072574E+00, 8.4940423826E-01],
	[2.3670000000E+04, 1.4499088980E+01, 5.2569168673E+00, 3.1154648037E+00, 1.7236184336E+00, 8.4947669066E-01],
	[2.3675000000E+04, 1.4503838682E+01, 5.2568413162E+00, 3.1175960000E+00, 1.7243295783E+00, 8.4954911138E-01],
	[2.3680000000E+04, 1.4508588936E+01, 5.2567657822E+00, 3.1197282032E+00, 1.7250406911E+00, 8.4962150043E-01],
	[2.3685000000E+04, 1.4513339743E+01, 5.2566902652E+00, 3.1218614135E+00, 1.7257517721E+00, 8.4969385782E-01],
	[2.3690000000E+04, 1.4518091102E+01, 5.2566147653E+00, 3.1239956313E+00, 1.7264628210E+00, 8.4976618356E-01],
	[2.3695000000E+04, 1.4522843013E+01, 5.2565392823E+00, 3.1261308568E+00, 1.7271738377E+00, 8.4983847766E-01],
	[2.3700000000E+04, 1.4527595476E+01, 5.2564638164E+00, 3.1282670902E+00, 1.7278848221E+00, 8.4991074012E-01],
	[2.3705000000E+04, 1.4532348492E+01, 5.2563883675E+00, 3.1304043319E+00, 1.7285957741E+00, 8.4998297096E-01],
	[2.3710000000E+04, 1.4537102060E+01, 5.2563129356E+00, 3.1325425821E+00, 1.7293066936E+00, 8.5005517018E-01],
	[2.3715000000E+04, 1.4541856180E+01, 5.2562375206E+00, 3.1346818410E+00, 1.7300175803E+00, 8.5012733779E-01],
	[2.3720000000E+04, 1.4546610852E+01, 5.2561621226E+00, 3.1368221089E+00, 1.7307284342E+00, 8.5019947380E-01],
	[2.3725000000E+04, 1.4551366076E+01, 5.2560867416E+00, 3.1389633861E+00, 1.7314392551E+00, 8.5027157823E-01],
	[2.3730000000E+04, 1.4556121851E+01, 5.2560113776E+00, 3.1411056729E+00, 1.7321500430E+00, 8.5034365107E-01],
	[2.3735000000E+04, 1.4560878179E+01, 5.2559360306E+00, 3.1432489694E+00, 1.7328607976E+00, 8.5041569234E-01],
	[2.3740000000E+04, 1.4565635059E+01, 5.2558607004E+00, 3.1453932760E+00, 1.7335715189E+00, 8.5048770205E-01],
	[2.3745000000E+04, 1.4570392490E+01, 5.2557853873E+00, 3.1475385930E+00, 1.7342822067E+00, 8.5055968020E-01],
	[2.3750000000E+04, 1.4575150473E+01, 5.2557100910E+00, 3.1496849205E+00, 1.7349928609E+00, 8.5063162681E-01],
	[2.3755000000E+04, 1.4579909008E+01, 5.2556348117E+00, 3.1518322589E+00, 1.7357034813E+00, 8.5070354188E-01],
	[2.3760000000E+04, 1.4584668094E+01, 5.2555595493E+00, 3.1539806084E+00, 1.7364140679E+00, 8.5077542542E-01],
	[2.3765000000E+04, 1.4589427732E+01, 5.2554843038E+00, 3.1561299693E+00, 1.7371246204E+00, 8.5084727744E-01],
	[2.3770000000E+04, 1.4594187921E+01, 5.2554090753E+00, 3.1582803419E+00, 1.7378351388E+00, 8.5091909796E-01],
	[2.3775000000E+04, 1.4598948662E+01, 5.2553338636E+00, 3.1604317263E+00, 1.7385456230E+00, 8.5099088697E-01],
	[2.3780000000E+04, 1.4603709954E+01, 5.2552586688E+00, 3.1625841229E+00, 1.7392560727E+00, 8.5106264449E-01],
	[2.3785000000E+04, 1.4608471797E+01, 5.2551834909E+00, 3.1647375319E+00, 1.7399664879E+00, 8.5113437053E-01],
	[2.3790000000E+04, 1.4613234192E+01, 5.2551083299E+00, 3.1668919537E+00, 1.7406768685E+00, 8.5120606509E-01],
	[2.3795000000E+04, 1.4617997138E+01, 5.2550331858E+00, 3.1690473884E+00, 1.7413872143E+00, 8.5127772818E-01],
	[2.3800000000E+04, 1.4622760636E+01, 5.2549580585E+00, 3.1712038363E+00, 1.7420975251E+00, 8.5134935983E-01],
	[2.3805000000E+04, 1.4627524684E+01, 5.2548829481E+00, 3.1733612977E+00, 1.7428078010E+00, 8.5142096002E-01],
	[2.3810000000E+04, 1.4632289283E+01, 5.2548078545E+00, 3.1755197728E+00, 1.7435180416E+00, 8.5149252877E-01],
	[2.3815000000E+04, 1.4637054434E+01, 5.2547327777E+00, 3.1776792620E+00, 1.7442282469E+00, 8.5156406608E-01],
	[2.3820000000E+04, 1.4641820135E+01, 5.2546577178E+00, 3.1798397654E+00, 1.7449384168E+00, 8.5163557197E-01],
	[2.3825000000E+04, 1.4646586388E+01, 5.2545826747E+00, 3.1820012833E+00, 1.7456485511E+00, 8.5170704644E-01],
	[2.3830000000E+04, 1.4651353191E+01, 5.2545076485E+00, 3.1841638161E+00, 1.7463586497E+00, 8.5177848950E-01],
	[2.3835000000E+04, 1.4656120545E+01, 5.2544326390E+00, 3.1863273639E+00, 1.7470687125E+00, 8.5184990115E-01],
	[2.3840000000E+04, 1.4660888450E+01, 5.2543576464E+00, 3.1884919270E+00, 1.7477787394E+00, 8.5192128140E-01],
	[2.3845000000E+04, 1.4665656906E+01, 5.2542826705E+00, 3.1906575058E+00, 1.7484887302E+00, 8.5199263026E-01],
	[2.3850000000E+04, 1.4670425912E+01, 5.2542077115E+00, 3.1928241003E+00, 1.7491986847E+00, 8.5206394774E-01],
	[2.3855000000E+04, 1.4675195469E+01, 5.2541327692E+00, 3.1949917110E+00, 1.7499086029E+00, 8.5213523384E-01],
	[2.3860000000E+04, 1.4679965577E+01, 5.2540578437E+00, 3.1971603381E+00, 1.7506184846E+00, 8.5220648858E-01],
	[2.3865000000E+04, 1.4684736235E+01, 5.2539829349E+00, 3.1993299818E+00, 1.7513283298E+00, 8.5227771195E-01],
	[2.3870000000E+04, 1.4689507443E+01, 5.2539080430E+00, 3.2015006424E+00, 1.7520381382E+00, 8.5234890397E-01],
	[2.3875000000E+04, 1.4694279202E+01, 5.2538331677E+00, 3.2036723202E+00, 1.7527479097E+00, 8.5242006464E-01],
	[2.3880000000E+04, 1.4699051511E+01, 5.2537583093E+00, 3.2058450154E+00, 1.7534576443E+00, 8.5249119398E-01],
	[2.3885000000E+04, 1.4703824371E+01, 5.2536834675E+00, 3.2080187283E+00, 1.7541673418E+00, 8.5256229198E-01],
	[2.3890000000E+04, 1.4708597781E+01, 5.2536086425E+00, 3.2101934591E+00, 1.7548770020E+00, 8.5263335866E-01],
	[2.3895000000E+04, 1.4713371741E+01, 5.2535338342E+00, 3.2123692082E+00, 1.7555866248E+00, 8.5270439402E-01],
	[2.3900000000E+04, 1.4718146251E+01, 5.2534590426E+00, 3.2145459757E+00, 1.7562962102E+00, 8.5277539808E-01],
	[2.3905000000E+04, 1.4722921311E+01, 5.2533842678E+00, 3.2167237620E+00, 1.7570057579E+00, 8.5284637083E-01],
	[2.3910000000E+04, 1.4727696921E+01, 5.2533095096E+00, 3.2189025673E+00, 1.7577152678E+00, 8.5291731229E-01],
	[2.3915000000E+04, 1.4732473082E+01, 5.2532347682E+00, 3.2210823919E+00, 1.7584247399E+00, 8.5298822246E-01],
	[2.3920000000E+04, 1.4737269344E+01, 5.2531636588E+00, 3.2232632360E+00, 1.7591348580E+00, 8.5305910135E-01],
	[2.3925000000E+04, 1.4742068717E+01, 5.2530930372E+00, 3.2254450999E+00, 1.7598450280E+00, 8.5312994897E-01],
	[2.3930000000E+04, 1.4746868651E+01, 5.2530224312E+00, 3.2276279839E+00, 1.7605551607E+00, 8.5320076533E-01],
	[2.3935000000E+04, 1.4751669143E+01, 5.2529518410E+00, 3.2298118882E+00, 1.7612652559E+00, 8.5327155044E-01],
	[2.3940000000E+04, 1.4756470195E+01, 5.2528812664E+00, 3.2319968131E+00, 1.7619753135E+00, 8.5334230429E-01],
	[2.3945000000E+04, 1.4761271807E+01, 5.2528107075E+00, 3.2341827588E+00, 1.7626853333E+00, 8.5341302691E-01],
	[2.3950000000E+04, 1.4766073978E+01, 5.2527401644E+00, 3.2363697256E+00, 1.7633953152E+00, 8.5348371829E-01],
	[2.3955000000E+04, 1.4770876708E+01, 5.2526696368E+00, 3.2385577138E+00, 1.7641052591E+00, 8.5355437844E-01],
	[2.3960000000E+04, 1.4775679997E+01, 5.2525991250E+00, 3.2407467237E+00, 1.7648151649E+00, 8.5362500738E-01],
	[2.3965000000E+04, 1.4780483846E+01, 5.2525286288E+00, 3.2429367555E+00, 1.7655250324E+00, 8.5369560511E-01],
	[2.3970000000E+04, 1.4785288254E+01, 5.2524581482E+00, 3.2451278094E+00, 1.7662348616E+00, 8.5376617163E-01],
	[2.3975000000E+04, 1.4790093221E+01, 5.2523876834E+00, 3.2473198858E+00, 1.7669446522E+00, 8.5383670697E-01],
	[2.3980000000E+04, 1.4794898747E+01, 5.2523172341E+00, 3.2495129848E+00, 1.7676544041E+00, 8.5390721111E-01],
	[2.3985000000E+04, 1.4799704832E+01, 5.2522468005E+00, 3.2517071068E+00, 1.7683641173E+00, 8.5397768408E-01],
	[2.3990000000E+04, 1.4804511476E+01, 5.2521763825E+00, 3.2539022521E+00, 1.7690737916E+00, 8.5404812587E-01],
	[2.3995000000E+04, 1.4809318679E+01, 5.2521059801E+00, 3.2560984208E+00, 1.7697834269E+00, 8.5411853650E-01],
	[2.4000000000E+04, 1.4814126441E+01, 5.2520355933E+00, 3.2582956133E+00, 1.7704930230E+00, 8.5418891598E-01],
	[2.4005000000E+04, 1.4818934762E+01, 5.2519652222E+00, 3.2604938297E+00, 1.7712025799E+00, 8.5425926430E-01],
	[2.4010000000E+04, 1.4823743641E+01, 5.2518948666E+00, 3.2626930705E+00, 1.7719120973E+00, 8.5432958149E-01],
	[2.4015000000E+04, 1.4828553079E+01, 5.2518245266E+00, 3.2648933358E+00, 1.7726215752E+00, 8.5439986755E-01],
	[2.4020000000E+04, 1.4833363076E+01, 5.2517542022E+00, 3.2670946259E+00, 1.7733310135E+00, 8.5447012248E-01],
	[2.4025000000E+04, 1.4838173631E+01, 5.2516838934E+00, 3.2692969410E+00, 1.7740404120E+00, 8.5454034629E-01],
	[2.4030000000E+04, 1.4842984745E+01, 5.2516136002E+00, 3.2715002815E+00, 1.7747497705E+00, 8.5461053900E-01],
	[2.4035000000E+04, 1.4847796418E+01, 5.2515433225E+00, 3.2737046476E+00, 1.7754590891E+00, 8.5468070060E-01],
	[2.4040000000E+04, 1.4852608649E+01, 5.2514730604E+00, 3.2759100395E+00, 1.7761683674E+00, 8.5475083111E-01],
	[2.4045000000E+04, 1.4857421438E+01, 5.2514028139E+00, 3.2781164576E+00, 1.7768776055E+00, 8.5482093054E-01],
	[2.4050000000E+04, 1.4862234785E+01, 5.2513325828E+00, 3.2803239020E+00, 1.7775868032E+00, 8.5489099889E-01],
	[2.4055000000E+04, 1.4867048691E+01, 5.2512623674E+00, 3.2825323731E+00, 1.7782959603E+00, 8.5496103617E-01],
	[2.4060000000E+04, 1.4871863156E+01, 5.2511921674E+00, 3.2847418711E+00, 1.7790050768E+00, 8.5503104239E-01],
	[2.4065000000E+04, 1.4876678178E+01, 5.2511219830E+00, 3.2869523963E+00, 1.7797141525E+00, 8.5510101756E-01],
	[2.4070000000E+04, 1.4881493759E+01, 5.2510518141E+00, 3.2891639489E+00, 1.7804231873E+00, 8.5517096168E-01],
	[2.4075000000E+04, 1.4886309897E+01, 5.2509816607E+00, 3.2913765292E+00, 1.7811321810E+00, 8.5524087477E-01],
	[2.4080000000E+04, 1.4891126594E+01, 5.2509115228E+00, 3.2935901375E+00, 1.7818411336E+00, 8.5531075682E-01],
	[2.4085000000E+04, 1.4895943849E+01, 5.2508414004E+00, 3.2958047739E+00, 1.7825500449E+00, 8.5538060786E-01],
	[2.4090000000E+04, 1.4900761661E+01, 5.2507712935E+00, 3.2980204389E+00, 1.7832589148E+00, 8.5545042788E-01],
	[2.4095000000E+04, 1.4905580032E+01, 5.2507012021E+00, 3.3002371327E+00, 1.7839677431E+00, 8.5552021689E-01],
	[2.4100000000E+04, 1.4910398960E+01, 5.2506311262E+00, 3.3024548555E+00, 1.7846765298E+00, 8.5558997491E-01],
	[2.4105000000E+04, 1.4915218446E+01, 5.2505610657E+00, 3.3046736075E+00, 1.7853852747E+00, 8.5565970194E-01],
	[2.4110000000E+04, 1.4920038490E+01, 5.2504910208E+00, 3.3068933891E+00, 1.7860939777E+00, 8.5572939799E-01],
	[2.4115000000E+04, 1.4924859091E+01, 5.2504209912E+00, 3.3091142005E+00, 1.7868026386E+00, 8.5579906307E-01],
	[2.4120000000E+04, 1.4929680251E+01, 5.2503509771E+00, 3.3113360420E+00, 1.7875112574E+00, 8.5586869718E-01],
	[2.4125000000E+04, 1.4934501967E+01, 5.2502809785E+00, 3.3135589138E+00, 1.7882198339E+00, 8.5593830034E-01],
	[2.4130000000E+04, 1.4939324242E+01, 5.2502109953E+00, 3.3157828162E+00, 1.7889283680E+00, 8.5600787255E-01],
	[2.4135000000E+04, 1.4944147073E+01, 5.2501410275E+00, 3.3180077495E+00, 1.7896368596E+00, 8.5607741381E-01],
	[2.4140000000E+04, 1.4948970463E+01, 5.2500710752E+00, 3.3202337139E+00, 1.7903453085E+00, 8.5614692415E-01],
	[2.4145000000E+04, 1.4953794409E+01, 5.2500011383E+00, 3.3224607097E+00, 1.7910537146E+00, 8.5621640356E-01],
	[2.4150000000E+04, 1.4958618913E+01, 5.2499312168E+00, 3.3246887372E+00, 1.7917620778E+00, 8.5628585206E-01],
	[2.4155000000E+04, 1.4963443974E+01, 5.2498613107E+00, 3.3269177966E+00, 1.7924703980E+00, 8.5635526964E-01],
	[2.4160000000E+04, 1.4968269593E+01, 5.2497914200E+00, 3.3291478882E+00, 1.7931786750E+00, 8.5642465633E-01],
	[2.4165000000E+04, 1.4973095768E+01, 5.2497215447E+00, 3.3313790122E+00, 1.7938869088E+00, 8.5649401213E-01],
	[2.4170000000E+04, 1.4977922501E+01, 5.2496516847E+00, 3.3336111689E+00, 1.7945950991E+00, 8.5656333705E-01],
	[2.4175000000E+04, 1.4982749791E+01, 5.2495818402E+00, 3.3358443586E+00, 1.7953032460E+00, 8.5663263109E-01],
	[2.4180000000E+04, 1.4987577637E+01, 5.2495120110E+00, 3.3380785816E+00, 1.7960113491E+00, 8.5670189426E-01],
	[2.4185000000E+04, 1.4992406041E+01, 5.2494421972E+00, 3.3403138380E+00, 1.7967194086E+00, 8.5677112658E-01],
	[2.4190000000E+04, 1.4997235002E+01, 5.2493723988E+00, 3.3425501282E+00, 1.7974274241E+00, 8.5684032805E-01],
	[2.4195000000E+04, 1.5002064519E+01, 5.2493026157E+00, 3.3447874525E+00, 1.7981353956E+00, 8.5690949868E-01],
	[2.4200000000E+04, 1.5006894594E+01, 5.2492328479E+00, 3.3470258110E+00, 1.7988433230E+00, 8.5697863847E-01],
	[2.4205000000E+04, 1.5011725225E+01, 5.2491630955E+00, 3.3492652041E+00, 1.7995512061E+00, 8.5704774744E-01],
	[2.4210000000E+04, 1.5016556412E+01, 5.2490933585E+00, 3.3515056321E+00, 1.8002590448E+00, 8.5711682559E-01],
	[2.4215000000E+04, 1.5021388157E+01, 5.2490236367E+00, 3.3537470951E+00, 1.8009668390E+00, 8.5718587293E-01],
	[2.4220000000E+04, 1.5026220458E+01, 5.2489539303E+00, 3.3559895935E+00, 1.8016745886E+00, 8.5725488948E-01],
	[2.4225000000E+04, 1.5031053316E+01, 5.2488842392E+00, 3.3582331275E+00, 1.8023822934E+00, 8.5732387523E-01],
	[2.4230000000E+04, 1.5035886730E+01, 5.2488145634E+00, 3.3604776973E+00, 1.8030899534E+00, 8.5739283020E-01],
	[2.4235000000E+04, 1.5040720701E+01, 5.2487449029E+00, 3.3627233033E+00, 1.8037975683E+00, 8.5746175440E-01],
	[2.4240000000E+04, 1.5045555228E+01, 5.2486752577E+00, 3.3649699458E+00, 1.8045051381E+00, 8.5753064783E-01],
	[2.4245000000E+04, 1.5050390311E+01, 5.2486056278E+00, 3.3672176248E+00, 1.8052126627E+00, 8.5759951050E-01],
	[2.4250000000E+04, 1.5055225951E+01, 5.2485360131E+00, 3.3694663409E+00, 1.8059201420E+00, 8.5766834242E-01],
	[2.4255000000E+04, 1.5060062147E+01, 5.2484664138E+00, 3.3717160941E+00, 1.8066275757E+00, 8.5773714361E-01],
	[2.4260000000E+04, 1.5064898899E+01, 5.2483968297E+00, 3.3739668848E+00, 1.8073349638E+00, 8.5780591406E-01],
	[2.4265000000E+04, 1.5069736207E+01, 5.2483272609E+00, 3.3762187132E+00, 1.8080423062E+00, 8.5787465378E-01],
	[2.4270000000E+04, 1.5074574072E+01, 5.2482577073E+00, 3.3784715796E+00, 1.8087496028E+00, 8.5794336279E-01],
	[2.4275000000E+04, 1.5079412492E+01, 5.2481881690E+00, 3.3807254843E+00, 1.8094568533E+00, 8.5801204110E-01],
	[2.4280000000E+04, 1.5084251469E+01, 5.2481186459E+00, 3.3829804275E+00, 1.8101640578E+00, 8.5808068871E-01],
	[2.4285000000E+04, 1.5089091001E+01, 5.2480491380E+00, 3.3852364095E+00, 1.8108712161E+00, 8.5814930562E-01],
	[2.4290000000E+04, 1.5093931089E+01, 5.2479796454E+00, 3.3874934305E+00, 1.8115783280E+00, 8.5821789186E-01],
	[2.4295000000E+04, 1.5098771734E+01, 5.2479101680E+00, 3.3897514908E+00, 1.8122853934E+00, 8.5828644742E-01],
	[2.4300000000E+04, 1.5103612934E+01, 5.2478407059E+00, 3.3920105907E+00, 1.8129924123E+00, 8.5835497232E-01],
	[2.4305000000E+04, 1.5108474472E+01, 5.2477748144E+00, 3.3942707305E+00, 1.8137000942E+00, 8.5842346656E-01],
	[2.4310000000E+04, 1.5113339199E+01, 5.2477094089E+00, 3.3965319103E+00, 1.8144078244E+00, 8.5849193016E-01],
	[2.4315000000E+04, 1.5118204491E+01, 5.2476440176E+00, 3.3987941306E+00, 1.8151155084E+00, 8.5856036312E-01],
	[2.4320000000E+04, 1.5123070349E+01, 5.2475786406E+00, 3.4010573914E+00, 1.8158231463E+00, 8.5862876545E-01],
	[2.4325000000E+04, 1.5127936772E+01, 5.2475132778E+00, 3.4033216932E+00, 1.8165307379E+00, 8.5869713715E-01],
	[2.4330000000E+04, 1.5132803761E+01, 5.2474479293E+00, 3.4055870361E+00, 1.8172382831E+00, 8.5876547825E-01],
	[2.4335000000E+04, 1.5137671315E+01, 5.2473825950E+00, 3.4078534205E+00, 1.8179457817E+00, 8.5883378874E-01],
	[2.4340000000E+04, 1.5142539433E+01, 5.2473172750E+00, 3.4101208465E+00, 1.8186532337E+00, 8.5890206863E-01],
	[2.4345000000E+04, 1.5147408117E+01, 5.2472519691E+00, 3.4123893145E+00, 1.8193606389E+00, 8.5897031794E-01],
	[2.4350000000E+04, 1.5152277366E+01, 5.2471866776E+00, 3.4146588248E+00, 1.8200679972E+00, 8.5903853667E-01],
	[2.4355000000E+04, 1.5157147181E+01, 5.2471214002E+00, 3.4169293775E+00, 1.8207753085E+00, 8.5910672484E-01],
	[2.4360000000E+04, 1.5162017560E+01, 5.2470561370E+00, 3.4192009729E+00, 1.8214825727E+00, 8.5917488244E-01],
	[2.4365000000E+04, 1.5166888504E+01, 5.2469908881E+00, 3.4214736114E+00, 1.8221897896E+00, 8.5924300949E-01],
	[2.4370000000E+04, 1.5171760013E+01, 5.2469256533E+00, 3.4237472931E+00, 1.8228969591E+00, 8.5931110600E-01],
	[2.4375000000E+04, 1.5176632086E+01, 5.2468604328E+00, 3.4260220184E+00, 1.8236040811E+00, 8.5937917197E-01],
	[2.4380000000E+04, 1.5181504725E+01, 5.2467952264E+00, 3.4282977875E+00, 1.8243111555E+00, 8.5944720742E-01],
	[2.4385000000E+04, 1.5186377928E+01, 5.2467300342E+00, 3.4305746007E+00, 1.8250181822E+00, 8.5951521235E-01],
	[2.4390000000E+04, 1.5191251696E+01, 5.2466648562E+00, 3.4328524582E+00, 1.8257251610E+00, 8.5958318677E-01],
	[2.4395000000E+04, 1.5196126029E+01, 5.2465996924E+00, 3.4351313603E+00, 1.8264320919E+00, 8.5965113069E-01],
	[2.4400000000E+04, 1.5201000926E+01, 5.2465345427E+00, 3.4374113073E+00, 1.8271389746E+00, 8.5971904413E-01],
	[2.4405000000E+04, 1.5205876387E+01, 5.2464694072E+00, 3.4396922994E+00, 1.8278458092E+00, 8.5978692708E-01],
	[2.4410000000E+04, 1.5210752414E+01, 5.2464042858E+00, 3.4419743368E+00, 1.8285525954E+00, 8.5985477955E-01],
	[2.4415000000E+04, 1.5215629004E+01, 5.2463391786E+00, 3.4442574200E+00, 1.8292593331E+00, 8.5992260157E-01],
	[2.4420000000E+04, 1.5220506159E+01, 5.2462740855E+00, 3.4465415491E+00, 1.8299660223E+00, 8.5999039313E-01],
	[2.4425000000E+04, 1.5225383878E+01, 5.2462090065E+00, 3.4488267243E+00, 1.8306726628E+00, 8.6005815424E-01],
	[2.4430000000E+04, 1.5230262162E+01, 5.2461439417E+00, 3.4511129460E+00, 1.8313792544E+00, 8.6012588492E-01],
	[2.4435000000E+04, 1.5235141010E+01, 5.2460788910E+00, 3.4534002144E+00, 1.8320857972E+00, 8.6019358516E-01],
	[2.4440000000E+04, 1.5240020422E+01, 5.2460138544E+00, 3.4556885298E+00, 1.8327922909E+00, 8.6026125499E-01],
	[2.4445000000E+04, 1.5244900398E+01, 5.2459488319E+00, 3.4579778925E+00, 1.8334987354E+00, 8.6032889441E-01],
	[2.4450000000E+04, 1.5249780938E+01, 5.2458838236E+00, 3.4602683026E+00, 1.8342051306E+00, 8.6039650342E-01],
	[2.4455000000E+04, 1.5254662042E+01, 5.2458188293E+00, 3.4625597606E+00, 1.8349114765E+00, 8.6046408204E-01],
	[2.4460000000E+04, 1.5259543710E+01, 5.2457538491E+00, 3.4648522665E+00, 1.8356177728E+00, 8.6053163028E-01],
	[2.4465000000E+04, 1.5264425942E+01, 5.2456888830E+00, 3.4671458208E+00, 1.8363240194E+00, 8.6059914814E-01],
	[2.4470000000E+04, 1.5269308738E+01, 5.2456239310E+00, 3.4694404236E+00, 1.8370302164E+00, 8.6066663564E-01],
	[2.4475000000E+04, 1.5274192098E+01, 5.2455589931E+00, 3.4717360753E+00, 1.8377363634E+00, 8.6073409278E-01],
	[2.4480000000E+04, 1.5279076022E+01, 5.2454940692E+00, 3.4740327761E+00, 1.8384424604E+00, 8.6080151957E-01],
	[2.4485000000E+04, 1.5283960509E+01, 5.2454291594E+00, 3.4763305262E+00, 1.8391485073E+00, 8.6086891602E-01],
	[2.4490000000E+04, 1.5288845560E+01, 5.2453642636E+00, 3.4786293260E+00, 1.8398545040E+00, 8.6093628214E-01],
	[2.4495000000E+04, 1.5293731174E+01, 5.2452993819E+00, 3.4809291756E+00, 1.8405604504E+00, 8.6100361794E-01],
	[2.4500000000E+04, 1.5298617353E+01, 5.2452345143E+00, 3.4832300754E+00, 1.8412663462E+00, 8.6107092343E-01],
	[2.4505000000E+04, 1.5303504094E+01, 5.2451696607E+00, 3.4855320256E+00, 1.8419721915E+00, 8.6113819861E-01],
	[2.4510000000E+04, 1.5308391399E+01, 5.2451048211E+00, 3.4878350265E+00, 1.8426779861E+00, 8.6120544350E-01],
	[2.4515000000E+04, 1.5313279268E+01, 5.2450399955E+00, 3.4901390784E+00, 1.8433837299E+00, 8.6127265810E-01],
	[2.4520000000E+04, 1.5318167700E+01, 5.2449751840E+00, 3.4924441815E+00, 1.8440894227E+00, 8.6133984243E-01],
	[2.4525000000E+04, 1.5323056695E+01, 5.2449103865E+00, 3.4947503360E+00, 1.8447950645E+00, 8.6140699649E-01],
	[2.4530000000E+04, 1.5327946254E+01, 5.2448456030E+00, 3.4970575423E+00, 1.8455006551E+00, 8.6147412030E-01],
	[2.4535000000E+04, 1.5332836376E+01, 5.2447808334E+00, 3.4993658006E+00, 1.8462061944E+00, 8.6154121385E-01],
	[2.4540000000E+04, 1.5337727060E+01, 5.2447160779E+00, 3.5016751112E+00, 1.8469116823E+00, 8.6160827716E-01],
	[2.4545000000E+04, 1.5342618309E+01, 5.2446513364E+00, 3.5039854743E+00, 1.8476171187E+00, 8.6167531025E-01],
	[2.4550000000E+04, 1.5347510120E+01, 5.2445866089E+00, 3.5062968902E+00, 1.8483225034E+00, 8.6174231311E-01],
	[2.4555000000E+04, 1.5352402494E+01, 5.2445218953E+00, 3.5086093592E+00, 1.8490278364E+00, 8.6180928576E-01],
	[2.4560000000E+04, 1.5357295431E+01, 5.2444571958E+00, 3.5109228816E+00, 1.8497331175E+00, 8.6187622820E-01],
	[2.4565000000E+04, 1.5362188931E+01, 5.2443925101E+00, 3.5132374575E+00, 1.8504383466E+00, 8.6194314046E-01],
	[2.4570000000E+04, 1.5367082994E+01, 5.2443278385E+00, 3.5155530873E+00, 1.8511435236E+00, 8.6201002252E-01],
	[2.4575000000E+04, 1.5371977620E+01, 5.2442631808E+00, 3.5178697712E+00, 1.8518486484E+00, 8.6207687441E-01],
	[2.4580000000E+04, 1.5376872808E+01, 5.2441985371E+00, 3.5201875095E+00, 1.8525537208E+00, 8.6214369614E-01],
	[2.4585000000E+04, 1.5381768560E+01, 5.2441339073E+00, 3.5225063024E+00, 1.8532587408E+00, 8.6221048770E-01],
	[2.4590000000E+04, 1.5386664874E+01, 5.2440692914E+00, 3.5248261503E+00, 1.8539637082E+00, 8.6227724912E-01],
	[2.4595000000E+04, 1.5391561750E+01, 5.2440046895E+00, 3.5271470534E+00, 1.8546686230E+00, 8.6234398040E-01],
	[2.4600000000E+04, 1.5396459189E+01, 5.2439401015E+00, 3.5294690119E+00, 1.8553734849E+00, 8.6241068155E-01],
	[2.4605000000E+04, 1.5401357191E+01, 5.2438755274E+00, 3.5317920262E+00, 1.8560782939E+00, 8.6247735257E-01],
	[2.4610000000E+04, 1.5406255755E+01, 5.2438109673E+00, 3.5341160964E+00, 1.8567830498E+00, 8.6254399349E-01],
	[2.4615000000E+04, 1.5411154882E+01, 5.2437464210E+00, 3.5364412229E+00, 1.8574877526E+00, 8.6261060430E-01],
	[2.4620000000E+04, 1.5416054571E+01, 5.2436818887E+00, 3.5387674059E+00, 1.8581924022E+00, 8.6267718502E-01],
	[2.4625000000E+04, 1.5420954822E+01, 5.2436173702E+00, 3.5410946456E+00, 1.8588969983E+00, 8.6274373566E-01],
	[2.4630000000E+04, 1.5425855636E+01, 5.2435528657E+00, 3.5434229424E+00, 1.8596015410E+00, 8.6281025622E-01],
	[2.4635000000E+04, 1.5430757011E+01, 5.2434883750E+00, 3.5457522965E+00, 1.8603060301E+00, 8.6287674672E-01],
	[2.4640000000E+04, 1.5435658949E+01, 5.2434238982E+00, 3.5480827082E+00, 1.8610104654E+00, 8.6294320716E-01],
	[2.4645000000E+04, 1.5440561450E+01, 5.2433594353E+00, 3.5504141777E+00, 1.8617148468E+00, 8.6300963755E-01],
	[2.4650000000E+04, 1.5445464512E+01, 5.2432949863E+00, 3.5527467054E+00, 1.8624191744E+00, 8.6307603791E-01],
	[2.4655000000E+04, 1.5450368136E+01, 5.2432305511E+00, 3.5550802914E+00, 1.8631234478E+00, 8.6314240824E-01],
	[2.4660000000E+04, 1.5455272322E+01, 5.2431661298E+00, 3.5574149360E+00, 1.8638276670E+00, 8.6320874855E-01],
	[2.4665000000E+04, 1.5460177070E+01, 5.2431017223E+00, 3.5597506395E+00, 1.8645318320E+00, 8.6327505885E-01],
	[2.4670000000E+04, 1.5465082380E+01, 5.2430373287E+00, 3.5620874022E+00, 1.8652359425E+00, 8.6334133915E-01],
	[2.4675000000E+04, 1.5469988252E+01, 5.2429729489E+00, 3.5644252243E+00, 1.8659399985E+00, 8.6340758946E-01],
	[2.4680000000E+04, 1.5474894686E+01, 5.2429085830E+00, 3.5667641061E+00, 1.8666439998E+00, 8.6347380979E-01],
	[2.4685000000E+04, 1.5479801681E+01, 5.2428442308E+00, 3.5691040479E+00, 1.8673479464E+00, 8.6354000015E-01],
	[2.4690000000E+04, 1.5484709238E+01, 5.2427798925E+00, 3.5714450499E+00, 1.8680518381E+00, 8.6360616054E-01],
	[2.4695000000E+04, 1.5489631930E+01, 5.2427181141E+00, 3.5737871124E+00, 1.8687562104E+00, 8.6367229098E-01],
	[2.4700000000E+04, 1.5494563331E+01, 5.2426577707E+00, 3.5761302356E+00, 1.8694608275E+00, 8.6373839148E-01],
	[2.4705000000E+04, 1.5499495304E+01, 5.2425974402E+00, 3.5784744198E+00, 1.8701653902E+00, 8.6380446204E-01],
	[2.4710000000E+04, 1.5504427848E+01, 5.2425371227E+00, 3.5808196654E+00, 1.8708698985E+00, 8.6387050268E-01],
	[2.4715000000E+04, 1.5509360963E+01, 5.2424768180E+00, 3.5831659725E+00, 1.8715743523E+00, 8.6393651340E-01],
	[2.4720000000E+04, 1.5514294650E+01, 5.2424165262E+00, 3.5855133414E+00, 1.8722787513E+00, 8.6400249422E-01],
	[2.4725000000E+04, 1.5519228907E+01, 5.2423562473E+00, 3.5878617724E+00, 1.8729830956E+00, 8.6406844514E-01],
	[2.4730000000E+04, 1.5524163736E+01, 5.2422959813E+00, 3.5902112657E+00, 1.8736873850E+00, 8.6413436617E-01],
	[2.4735000000E+04, 1.5529099135E+01, 5.2422357282E+00, 3.5925618216E+00, 1.8743916194E+00, 8.6420025733E-01],
	[2.4740000000E+04, 1.5534035106E+01, 5.2421754879E+00, 3.5949134404E+00, 1.8750957986E+00, 8.6426611862E-01],
	[2.4745000000E+04, 1.5538971648E+01, 5.2421152605E+00, 3.5972661224E+00, 1.8757999227E+00, 8.6433195005E-01],
	[2.4750000000E+04, 1.5543908761E+01, 5.2420550460E+00, 3.5996198678E+00, 1.8765039913E+00, 8.6439775163E-01],
	[2.4755000000E+04, 1.5548846444E+01, 5.2419948443E+00, 3.6019746768E+00, 1.8772080045E+00, 8.6446352337E-01],
	[2.4760000000E+04, 1.5553784699E+01, 5.2419346555E+00, 3.6043305498E+00, 1.8779119621E+00, 8.6452926528E-01],
	[2.4765000000E+04, 1.5558723524E+01, 5.2418744795E+00, 3.6066874869E+00, 1.8786158640E+00, 8.6459497736E-01],
	[2.4770000000E+04, 1.5563662919E+01, 5.2418143164E+00, 3.6090454886E+00, 1.8793197102E+00, 8.6466065964E-01],
	[2.4775000000E+04, 1.5568602886E+01, 5.2417541661E+00, 3.6114045550E+00, 1.8800235004E+00, 8.6472631212E-01],
	[2.4780000000E+04, 1.5573543423E+01, 5.2416940286E+00, 3.6137646864E+00, 1.8807272345E+00, 8.6479193480E-01],
	[2.4785000000E+04, 1.5578484531E+01, 5.2416339039E+00, 3.6161258830E+00, 1.8814309125E+00, 8.6485752771E-01],
	[2.4790000000E+04, 1.5583426209E+01, 5.2415737921E+00, 3.6184881452E+00, 1.8821345343E+00, 8.6492309084E-01],
	[2.4795000000E+04, 1.5588368458E+01, 5.2415136931E+00, 3.6208514731E+00, 1.8828380997E+00, 8.6498862420E-01],
	[2.4800000000E+04, 1.5593311277E+01, 5.2414536068E+00, 3.6232158672E+00, 1.8835416086E+00, 8.6505412781E-01],
	[2.4805000000E+04, 1.5598254666E+01, 5.2413935334E+00, 3.6255813275E+00, 1.8842450609E+00, 8.6511960168E-01],
	[2.4810000000E+04, 1.5603198626E+01, 5.2413334728E+00, 3.6279478545E+00, 1.8849484565E+00, 8.6518504582E-01],
	[2.4815000000E+04, 1.5608143156E+01, 5.2412734250E+00, 3.6303154483E+00, 1.8856517953E+00, 8.6525046022E-01],
	[2.4820000000E+04, 1.5613088257E+01, 5.2412133899E+00, 3.6326841092E+00, 1.8863550772E+00, 8.6531584492E-01],
	[2.4825000000E+04, 1.5618033927E+01, 5.2411533676E+00, 3.6350538375E+00, 1.8870583020E+00, 8.6538119991E-01],
	[2.4830000000E+04, 1.5622980168E+01, 5.2410933581E+00, 3.6374246335E+00, 1.8877614697E+00, 8.6544652520E-01],
	[2.4835000000E+04, 1.5627926979E+01, 5.2410333614E+00, 3.6397964974E+00, 1.8884645801E+00, 8.6551182080E-01],
	[2.4840000000E+04, 1.5632874360E+01, 5.2409733775E+00, 3.6421694294E+00, 1.8891676331E+00, 8.6557708673E-01],
	[2.4845000000E+04, 1.5637822310E+01, 5.2409134063E+00, 3.6445434300E+00, 1.8898706286E+00, 8.6564232299E-01],
	[2.4850000000E+04, 1.5642770831E+01, 5.2408534478E+00, 3.6469184992E+00, 1.8905735665E+00, 8.6570752960E-01],
	[2.4855000000E+04, 1.5647719922E+01, 5.2407935021E+00, 3.6492946374E+00, 1.8912764468E+00, 8.6577270655E-01],
	[2.4860000000E+04, 1.5652669582E+01, 5.2407335692E+00, 3.6516718449E+00, 1.8919792691E+00, 8.6583785387E-01],
	[2.4865000000E+04, 1.5657619812E+01, 5.2406736489E+00, 3.6540501219E+00, 1.8926820336E+00, 8.6590297156E-01],
	[2.4870000000E+04, 1.5662570612E+01, 5.2406137415E+00, 3.6564294686E+00, 1.8933847400E+00, 8.6596805964E-01],
	[2.4875000000E+04, 1.5667521982E+01, 5.2405538467E+00, 3.6588098854E+00, 1.8940873883E+00, 8.6603311810E-01],
	[2.4880000000E+04, 1.5672473921E+01, 5.2404939647E+00, 3.6611913726E+00, 1.8947899782E+00, 8.6609814696E-01],
	[2.4885000000E+04, 1.5677426430E+01, 5.2404340953E+00, 3.6635739302E+00, 1.8954925098E+00, 8.6616314624E-01],
	[2.4890000000E+04, 1.5682379509E+01, 5.2403742387E+00, 3.6659575588E+00, 1.8961949829E+00, 8.6622811593E-01],
	[2.4895000000E+04, 1.5687333157E+01, 5.2403143948E+00, 3.6683422584E+00, 1.8968973974E+00, 8.6629305606E-01],
	[2.4900000000E+04, 1.5692287374E+01, 5.2402545636E+00, 3.6707280294E+00, 1.8975997532E+00, 8.6635796662E-01],
	[2.4905000000E+04, 1.5697242161E+01, 5.2401947451E+00, 3.6731148721E+00, 1.8983020502E+00, 8.6642284764E-01],
	[2.4910000000E+04, 1.5702197517E+01, 5.2401349393E+00, 3.6755027866E+00, 1.8990042882E+00, 8.6648769911E-01],
	[2.4915000000E+04, 1.5707153442E+01, 5.2400751462E+00, 3.6778917733E+00, 1.8997064672E+00, 8.6655252105E-01],
	[2.4920000000E+04, 1.5712109937E+01, 5.2400153658E+00, 3.6802818325E+00, 1.9004085870E+00, 8.6661731347E-01],
	[2.4925000000E+04, 1.5717067001E+01, 5.2399555980E+00, 3.6826729643E+00, 1.9011106476E+00, 8.6668207638E-01],
	[2.4930000000E+04, 1.5722024634E+01, 5.2398958429E+00, 3.6850651692E+00, 1.9018126488E+00, 8.6674680979E-01],
	[2.4935000000E+04, 1.5726982836E+01, 5.2398361005E+00, 3.6874584472E+00, 1.9025145905E+00, 8.6681151371E-01],
	[2.4940000000E+04, 1.5731941607E+01, 5.2397763707E+00, 3.6898527988E+00, 1.9032164726E+00, 8.6687618814E-01],
	[2.4945000000E+04, 1.5736900947E+01, 5.2397166536E+00, 3.6922482241E+00, 1.9039182950E+00, 8.6694083311E-01],
	[2.4950000000E+04, 1.5741860857E+01, 5.2396569491E+00, 3.6946447234E+00, 1.9046200576E+00, 8.6700544861E-01],
	[2.4955000000E+04, 1.5746821335E+01, 5.2395972573E+00, 3.6970422971E+00, 1.9053217602E+00, 8.6707003466E-01],
	[2.4960000000E+04, 1.5751782382E+01, 5.2395375781E+00, 3.6994409453E+00, 1.9060234029E+00, 8.6713459126E-01],
	[2.4965000000E+04, 1.5756743997E+01, 5.2394779115E+00, 3.7018406683E+00, 1.9067249854E+00, 8.6719911846E-01],
	[2.4970000000E+04, 1.5761706182E+01, 5.2394182576E+00, 3.7042414665E+00, 1.9074265076E+00, 8.6726361630E-01],
	[2.4975000000E+04, 1.5766668935E+01, 5.2393586163E+00, 3.7066433399E+00, 1.9081279695E+00, 8.6732808478E-01],
	[2.4980000000E+04, 1.5771632257E+01, 5.2392989876E+00, 3.7090462891E+00, 1.9088293708E+00, 8.6739252392E-01],
	[2.4985000000E+04, 1.5776596147E+01, 5.2392393715E+00, 3.7114503141E+00, 1.9095307117E+00, 8.6745693373E-01],
	[2.4990000000E+04, 1.5781560607E+01, 5.2391797680E+00, 3.7138554152E+00, 1.9102319918E+00, 8.6752131421E-01],
	[2.4995000000E+04, 1.5786525634E+01, 5.2391201772E+00, 3.7162615928E+00, 1.9109332111E+00, 8.6758566537E-01],
	[2.5000000000E+04, 1.5791491230E+01, 5.2390605989E+00, 3.7186688471E+00, 1.9116343695E+00, 8.6764998722E-01],
	[2.5005000000E+04, 1.5796457395E+01, 5.2390010332E+00, 3.7210819488E+00, 1.9123367269E+00, 8.6771427977E-01],
	[2.5010000000E+04, 1.5801424127E+01, 5.2389414801E+00, 3.7234961330E+00, 1.9130390231E+00, 8.6777854303E-01],
	[2.5015000000E+04, 1.5806391429E+01, 5.2388819396E+00, 3.7259114001E+00, 1.9137412580E+00, 8.6784277701E-01],
	[2.5020000000E+04, 1.5811359298E+01, 5.2388224117E+00, 3.7283277503E+00, 1.9144434316E+00, 8.6790698171E-01],
	[2.5025000000E+04, 1.5816327736E+01, 5.2387628963E+00, 3.7307451838E+00, 1.9151455438E+00, 8.6797115715E-01],
	[2.5030000000E+04, 1.5821296742E+01, 5.2387033935E+00, 3.7331637009E+00, 1.9158475943E+00, 8.6803530333E-01],
	[2.5035000000E+04, 1.5826266316E+01, 5.2386439033E+00, 3.7355833019E+00, 1.9165495832E+00, 8.6809942027E-01],
	[2.5040000000E+04, 1.5831236458E+01, 5.2385844256E+00, 3.7380039870E+00, 1.9172515103E+00, 8.6816350796E-01],
	[2.5045000000E+04, 1.5836207168E+01, 5.2385249605E+00, 3.7404257566E+00, 1.9179533755E+00, 8.6822756643E-01],
	[2.5050000000E+04, 1.5841178446E+01, 5.2384655079E+00, 3.7428486109E+00, 1.9186551787E+00, 8.6829159568E-01],
	[2.5055000000E+04, 1.5846150292E+01, 5.2384060678E+00, 3.7452725502E+00, 1.9193569197E+00, 8.6835559571E-01],
	[2.5060000000E+04, 1.5851122706E+01, 5.2383466403E+00, 3.7476975746E+00, 1.9200585985E+00, 8.6841956654E-01],
	[2.5065000000E+04, 1.5856095688E+01, 5.2382872254E+00, 3.7501236846E+00, 1.9207602150E+00, 8.6848350818E-01],
	[2.5070000000E+04, 1.5861069237E+01, 5.2382278229E+00, 3.7525508804E+00, 1.9214617691E+00, 8.6854742063E-01],
	[2.5075000000E+04, 1.5866043355E+01, 5.2381684330E+00, 3.7549791622E+00, 1.9221632606E+00, 8.6861130391E-01],
	[2.5080000000E+04, 1.5871018040E+01, 5.2381090555E+00, 3.7574085303E+00, 1.9228646894E+00, 8.6867515802E-01],
	[2.5085000000E+04, 1.5875993292E+01, 5.2380496906E+00, 3.7598389849E+00, 1.9235660555E+00, 8.6873898297E-01],
	[2.5090000000E+04, 1.5880972337E+01, 5.2379908882E+00, 3.7622705265E+00, 1.9242674802E+00, 8.6880277877E-01],
	[2.5095000000E+04, 1.5885971635E+01, 5.2379354544E+00, 3.7647031551E+00, 1.9249695845E+00, 8.6886654543E-01],
	[2.5100000000E+04, 1.5890971510E+01, 5.2378800323E+00, 3.7671368711E+00, 1.9256716265E+00, 8.6893028295E-01],
	[2.5105000000E+04, 1.5895971963E+01, 5.2378246217E+00, 3.7695716748E+00, 1.9263736062E+00, 8.6899399136E-01],
	[2.5110000000E+04, 1.5900972992E+01, 5.2377692228E+00, 3.7720075664E+00, 1.9270755235E+00, 8.6905767065E-01],
	[2.5115000000E+04, 1.5905974599E+01, 5.2377138356E+00, 3.7744445462E+00, 1.9277773782E+00, 8.6912132084E-01],
	[2.5120000000E+04, 1.5910976784E+01, 5.2376584599E+00, 3.7768826144E+00, 1.9284791703E+00, 8.6918494193E-01],
	[2.5125000000E+04, 1.5915979545E+01, 5.2376030958E+00, 3.7793217714E+00, 1.9291808997E+00, 8.6924853394E-01],
	[2.5130000000E+04, 1.5920982883E+01, 5.2375477433E+00, 3.7817620174E+00, 1.9298825662E+00, 8.6931209686E-01],
	[2.5135000000E+04, 1.5925986798E+01, 5.2374924025E+00, 3.7842033527E+00, 1.9305841698E+00, 8.6937563072E-01],
	[2.5140000000E+04, 1.5930991290E+01, 5.2374370732E+00, 3.7866457774E+00, 1.9312857103E+00, 8.6943913552E-01],
	[2.5145000000E+04, 1.5935996359E+01, 5.2373817555E+00, 3.7890892920E+00, 1.9319871876E+00, 8.6950261127E-01],
	[2.5150000000E+04, 1.5941002005E+01, 5.2373264494E+00, 3.7915338967E+00, 1.9326886017E+00, 8.6956605798E-01],
	[2.5155000000E+04, 1.5946008228E+01, 5.2372711549E+00, 3.7939795917E+00, 1.9333899523E+00, 8.6962947566E-01],
	[2.5160000000E+04, 1.5951015027E+01, 5.2372158719E+00, 3.7964263773E+00, 1.9340912395E+00, 8.6969286431E-01],
	[2.5165000000E+04, 1.5956022403E+01, 5.2371606005E+00, 3.7988742538E+00, 1.9347924631E+00, 8.6975622395E-01],
	[2.5170000000E+04, 1.5961030356E+01, 5.2371053407E+00, 3.8013232215E+00, 1.9354936230E+00, 8.6981955458E-01],
	[2.5175000000E+04, 1.5966038885E+01, 5.2370500924E+00, 3.8037732806E+00, 1.9361947190E+00, 8.6988285622E-01],
	[2.5180000000E+04, 1.5971047991E+01, 5.2369948557E+00, 3.8062244313E+00, 1.9368957511E+00, 8.6994612887E-01],
	[2.5185000000E+04, 1.5976057674E+01, 5.2369396305E+00, 3.8086766741E+00, 1.9375967192E+00, 8.7000937254E-01],
	[2.5190000000E+04, 1.5981067932E+01, 5.2368844169E+00, 3.8111300090E+00, 1.9382976232E+00, 8.7007258724E-01],
	[2.5195000000E+04, 1.5986078768E+01, 5.2368292149E+00, 3.8135844365E+00, 1.9389984630E+00, 8.7013577299E-01],
	[2.5200000000E+04, 1.5991090179E+01, 5.2367740243E+00, 3.8160399567E+00, 1.9396992384E+00, 8.7019892978E-01],
	[2.5205000000E+04, 1.5996102167E+01, 5.2367188453E+00, 3.8184965700E+00, 1.9403999493E+00, 8.7026205764E-01],
	[2.5210000000E+04, 1.6001114731E+01, 5.2366636778E+00, 3.8209542765E+00, 1.9411005957E+00, 8.7032515656E-01],
	[2.5215000000E+04, 1.6006127872E+01, 5.2366085219E+00, 3.8234130767E+00, 1.9418011774E+00, 8.7038822656E-01],
	[2.5220000000E+04, 1.6011141588E+01, 5.2365533774E+00, 3.8258729707E+00, 1.9425016944E+00, 8.7045126765E-01],
	[2.5225000000E+04, 1.6016155881E+01, 5.2364982445E+00, 3.8283339588E+00, 1.9432021465E+00, 8.7051427983E-01],
	[2.5230000000E+04, 1.6021170750E+01, 5.2364431230E+00, 3.8307960413E+00, 1.9439025336E+00, 8.7057726311E-01],
	[2.5235000000E+04, 1.6026186195E+01, 5.2363880131E+00, 3.8332592184E+00, 1.9446028556E+00, 8.7064021752E-01],
	[2.5240000000E+04, 1.6031202215E+01, 5.2363329147E+00, 3.8357234904E+00, 1.9453031124E+00, 8.7070314304E-01],
	[2.5245000000E+04, 1.6036218812E+01, 5.2362778278E+00, 3.8381888577E+00, 1.9460033040E+00, 8.7076603970E-01],
	[2.5250000000E+04, 1.6041235985E+01, 5.2362227523E+00, 3.8406553204E+00, 1.9467034301E+00, 8.7082890750E-01],
	[2.5255000000E+04, 1.6046253733E+01, 5.2361676884E+00, 3.8431228788E+00, 1.9474034907E+00, 8.7089174645E-01],
	[2.5260000000E+04, 1.6051272057E+01, 5.2361126359E+00, 3.8455915333E+00, 1.9481034858E+00, 8.7095455656E-01],
	[2.5265000000E+04, 1.6056290957E+01, 5.2360575949E+00, 3.8480612840E+00, 1.9488034151E+00, 8.7101733784E-01],
	[2.5270000000E+04, 1.6061310433E+01, 5.2360025653E+00, 3.8505321312E+00, 1.9495032786E+00, 8.7108009030E-01],
	[2.5275000000E+04, 1.6066330484E+01, 5.2359475473E+00, 3.8530040753E+00, 1.9502030761E+00, 8.7114281394E-01],
	[2.5280000000E+04, 1.6071351111E+01, 5.2358925407E+00, 3.8554771164E+00, 1.9509028076E+00, 8.7120550879E-01],
	[2.5285000000E+04, 1.6076372313E+01, 5.2358375455E+00, 3.8579512549E+00, 1.9516024730E+00, 8.7126817484E-01],
	[2.5290000000E+04, 1.6081394091E+01, 5.2357825618E+00, 3.8604264910E+00, 1.9523020722E+00, 8.7133081211E-01],
	[2.5295000000E+04, 1.6086416444E+01, 5.2357275896E+00, 3.8629028250E+00, 1.9530016050E+00, 8.7139342060E-01],
	[2.5300000000E+04, 1.6091439373E+01, 5.2356726287E+00, 3.8653802571E+00, 1.9537010714E+00, 8.7145600033E-01],
	[2.5305000000E+04, 1.6096462877E+01, 5.2356176794E+00, 3.8678587877E+00, 1.9544004712E+00, 8.7151855131E-01],
	[2.5310000000E+04, 1.6101486956E+01, 5.2355627414E+00, 3.8703384169E+00, 1.9550998044E+00, 8.7158107353E-01],
	[2.5315000000E+04, 1.6106511611E+01, 5.2355078149E+00, 3.8728191451E+00, 1.9557990708E+00, 8.7164356702E-01],
	[2.5320000000E+04, 1.6111536841E+01, 5.2354528998E+00, 3.8753009726E+00, 1.9564982703E+00, 8.7170603179E-01],
	[2.5325000000E+04, 1.6116562646E+01, 5.2353979961E+00, 3.8777838996E+00, 1.9571974029E+00, 8.7176846783E-01],
	[2.5330000000E+04, 1.6121589026E+01, 5.2353431039E+00, 3.8802679263E+00, 1.9578964684E+00, 8.7183087517E-01],
	[2.5335000000E+04, 1.6126615981E+01, 5.2352882230E+00, 3.8827530531E+00, 1.9585954667E+00, 8.7189325380E-01],
	[2.5340000000E+04, 1.6131643511E+01, 5.2352333536E+00, 3.8852392801E+00, 1.9592943977E+00, 8.7195560375E-01],
	[2.5345000000E+04, 1.6136671616E+01, 5.2351784956E+00, 3.8877266078E+00, 1.9599932614E+00, 8.7201792501E-01],
	[2.5350000000E+04, 1.6141700297E+01, 5.2351236489E+00, 3.8902150363E+00, 1.9606920576E+00, 8.7208021761E-01],
	[2.5355000000E+04, 1.6146729551E+01, 5.2350688137E+00, 3.8927045660E+00, 1.9613907862E+00, 8.7214248154E-01],
	[2.5360000000E+04, 1.6151759381E+01, 5.2350139898E+00, 3.8951951970E+00, 1.9620894471E+00, 8.7220471682E-01],
	[2.5365000000E+04, 1.6156789786E+01, 5.2349591773E+00, 3.8976869297E+00, 1.9627880401E+00, 8.7226692346E-01],
	[2.5370000000E+04, 1.6161820765E+01, 5.2349043762E+00, 3.9001797643E+00, 1.9634865653E+00, 8.7232910146E-01],
	[2.5375000000E+04, 1.6166852319E+01, 5.2348495865E+00, 3.9026737011E+00, 1.9641850225E+00, 8.7239125084E-01],
	[2.5380000000E+04, 1.6171884448E+01, 5.2347948081E+00, 3.9051687404E+00, 1.9648834116E+00, 8.7245337161E-01],
	[2.5385000000E+04, 1.6176917151E+01, 5.2347400411E+00, 3.9076648824E+00, 1.9655817325E+00, 8.7251546377E-01],
	[2.5390000000E+04, 1.6181950429E+01, 5.2346852854E+00, 3.9101621275E+00, 1.9662799851E+00, 8.7257752733E-01],
	[2.5395000000E+04, 1.6186984281E+01, 5.2346305412E+00, 3.9126604758E+00, 1.9669781693E+00, 8.7263956231E-01],
	[2.5400000000E+04, 1.6192018708E+01, 5.2345758082E+00, 3.9151599276E+00, 1.9676762849E+00, 8.7270156871E-01],
	[2.5405000000E+04, 1.6197053709E+01, 5.2345210866E+00, 3.9176604833E+00, 1.9683743320E+00, 8.7276354655E-01],
	[2.5410000000E+04, 1.6202089284E+01, 5.2344663764E+00, 3.9201621431E+00, 1.9690723103E+00, 8.7282549583E-01],
	[2.5415000000E+04, 1.6207125434E+01, 5.2344116774E+00, 3.9226649072E+00, 1.9697702198E+00, 8.7288741656E-01],
	[2.5420000000E+04, 1.6212162158E+01, 5.2343569899E+00, 3.9251687760E+00, 1.9704680603E+00, 8.7294930875E-01],
	[2.5425000000E+04, 1.6217199456E+01, 5.2343023136E+00, 3.9276737496E+00, 1.9711658319E+00, 8.7301117242E-01],
	[2.5430000000E+04, 1.6222237328E+01, 5.2342476487E+00, 3.9301798285E+00, 1.9718635343E+00, 8.7307300756E-01],
	[2.5435000000E+04, 1.6227275775E+01, 5.2341929950E+00, 3.9326870127E+00, 1.9725611674E+00, 8.7313481420E-01],
	[2.5440000000E+04, 1.6232314795E+01, 5.2341383527E+00, 3.9351953027E+00, 1.9732587313E+00, 8.7319659233E-01],
	[2.5445000000E+04, 1.6237354390E+01, 5.2340837217E+00, 3.9377046986E+00, 1.9739562257E+00, 8.7325834198E-01],
	[2.5450000000E+04, 1.6242394558E+01, 5.2340291020E+00, 3.9402152008E+00, 1.9746536506E+00, 8.7332006314E-01],
	[2.5455000000E+04, 1.6247435301E+01, 5.2339744936E+00, 3.9427268095E+00, 1.9753510058E+00, 8.7338175583E-01],
	[2.5460000000E+04, 1.6252476617E+01, 5.2339198965E+00, 3.9452395250E+00, 1.9760482913E+00, 8.7344342006E-01],
	[2.5465000000E+04, 1.6257518507E+01, 5.2338653107E+00, 3.9477533476E+00, 1.9767455070E+00, 8.7350505584E-01],
	[2.5470000000E+04, 1.6262560971E+01, 5.2338107362E+00, 3.9502682774E+00, 1.9774426527E+00, 8.7356666318E-01],
	[2.5475000000E+04, 1.6267604009E+01, 5.2337561730E+00, 3.9527843149E+00, 1.9781397284E+00, 8.7362824208E-01],
	[2.5480000000E+04, 1.6272647620E+01, 5.2337016210E+00, 3.9553014603E+00, 1.9788367339E+00, 8.7368979256E-01],
	[2.5485000000E+04, 1.6277691805E+01, 5.2336470803E+00, 3.9578197137E+00, 1.9795336692E+00, 8.7375131463E-01],
	[2.5490000000E+04, 1.6282736564E+01, 5.2335925509E+00, 3.9603390756E+00, 1.9802305342E+00, 8.7381280829E-01],
	[2.5495000000E+04, 1.6287790124E+01, 5.2335394150E+00, 3.9628595462E+00, 1.9809276484E+00, 8.7387427356E-01],
	[2.5500000000E+04, 1.6292858887E+01, 5.2334887463E+00, 3.9653811257E+00, 1.9816252609E+00, 8.7393571045E-01],
	[2.5505000000E+04, 1.6297928234E+01, 5.2334380881E+00, 3.9679038144E+00, 1.9823228037E+00, 8.7399711896E-01],
	[2.5510000000E+04, 1.6302998163E+01, 5.2333874403E+00, 3.9704276126E+00, 1.9830202766E+00, 8.7405849910E-01],
	[2.5515000000E+04, 1.6308068675E+01, 5.2333368029E+00, 3.9729525206E+00, 1.9837176795E+00, 8.7411985089E-01],
	[2.5520000000E+04, 1.6313139771E+01, 5.2332861759E+00, 3.9754785386E+00, 1.9844150123E+00, 8.7418117434E-01],
	[2.5525000000E+04, 1.6318211449E+01, 5.2332355593E+00, 3.9780056669E+00, 1.9851122750E+00, 8.7424246944E-01],
	[2.5530000000E+04, 1.6323283711E+01, 5.2331849532E+00, 3.9805339057E+00, 1.9858094674E+00, 8.7430373623E-01],
	[2.5535000000E+04, 1.6328356555E+01, 5.2331343574E+00, 3.9830632554E+00, 1.9865065894E+00, 8.7436497469E-01],
	[2.5540000000E+04, 1.6333429982E+01, 5.2330837720E+00, 3.9855937162E+00, 1.9872036409E+00, 8.7442618485E-01],
	[2.5545000000E+04, 1.6338503992E+01, 5.2330331970E+00, 3.9881252884E+00, 1.9879006219E+00, 8.7448736671E-01],
	[2.5550000000E+04, 1.6343578585E+01, 5.2329826324E+00, 3.9906579722E+00, 1.9885975322E+00, 8.7454852028E-01],
	[2.5555000000E+04, 1.6348653760E+01, 5.2329320782E+00, 3.9931917680E+00, 1.9892943717E+00, 8.7460964558E-01],
	[2.5560000000E+04, 1.6353729518E+01, 5.2328815344E+00, 3.9957266759E+00, 1.9899911404E+00, 8.7467074261E-01],
	[2.5565000000E+04, 1.6358805858E+01, 5.2328310009E+00, 3.9982626963E+00, 1.9906878380E+00, 8.7473181138E-01],
	[2.5570000000E+04, 1.6363882781E+01, 5.2327804778E+00, 4.0007998294E+00, 1.9913844647E+00, 8.7479285190E-01],
	[2.5575000000E+04, 1.6368960287E+01, 5.2327299651E+00, 4.0033380756E+00, 1.9920810201E+00, 8.7485386418E-01],
	[2.5580000000E+04, 1.6374038375E+01, 5.2326794627E+00, 4.0058774350E+00, 1.9927775043E+00, 8.7491484824E-01],
	[2.5585000000E+04, 1.6379117045E+01, 5.2326289707E+00, 4.0084179079E+00, 1.9934739171E+00, 8.7497580407E-01],
	[2.5590000000E+04, 1.6384196298E+01, 5.2325784890E+00, 4.0109594946E+00, 1.9941702584E+00, 8.7503673170E-01],
	[2.5595000000E+04, 1.6389276133E+01, 5.2325280177E+00, 4.0135021955E+00, 1.9948665282E+00, 8.7509763113E-01],
	[2.5600000000E+04, 1.6394356551E+01, 5.2324775568E+00, 4.0160460106E+00, 1.9955627263E+00, 8.7515850237E-01],
	[2.5605000000E+04, 1.6399437550E+01, 5.2324271062E+00, 4.0185909404E+00, 1.9962588526E+00, 8.7521934542E-01],
	[2.5610000000E+04, 1.6404519132E+01, 5.2323766659E+00, 4.0211369851E+00, 1.9969549071E+00, 8.7528016031E-01],
	[2.5615000000E+04, 1.6409601296E+01, 5.2323262359E+00, 4.0236841449E+00, 1.9976508896E+00, 8.7534094704E-01],
	[2.5620000000E+04, 1.6414684042E+01, 5.2322758163E+00, 4.0262324202E+00, 1.9983468000E+00, 8.7540170562E-01],
	[2.5625000000E+04, 1.6419767370E+01, 5.2322254070E+00, 4.0287818112E+00, 1.9990426383E+00, 8.7546243606E-01],
	[2.5630000000E+04, 1.6424851280E+01, 5.2321750080E+00, 4.0313323181E+00, 1.9997384043E+00, 8.7552313837E-01],
	[2.5635000000E+04, 1.6429935771E+01, 5.2321246194E+00, 4.0338839413E+00, 2.0004340980E+00, 8.7558381255E-01],
	[2.5640000000E+04, 1.6435020845E+01, 5.2320742410E+00, 4.0364366810E+00, 2.0011297192E+00, 8.7564445863E-01],
	[2.5645000000E+04, 1.6440106501E+01, 5.2320238730E+00, 4.0389905375E+00, 2.0018252678E+00, 8.7570507661E-01],
	[2.5650000000E+04, 1.6445192738E+01, 5.2319735152E+00, 4.0415455110E+00, 2.0025207438E+00, 8.7576566649E-01],
	[2.5655000000E+04, 1.6450279557E+01, 5.2319231678E+00, 4.0441016019E+00, 2.0032161471E+00, 8.7582622830E-01],
	[2.5660000000E+04, 1.6455366958E+01, 5.2318728307E+00, 4.0466588104E+00, 2.0039114775E+00, 8.7588676203E-01],
	[2.5665000000E+04, 1.6460454941E+01, 5.2318225038E+00, 4.0492171367E+00, 2.0046067349E+00, 8.7594726770E-01],
	[2.5670000000E+04, 1.6465543505E+01, 5.2317721873E+00, 4.0517765811E+00, 2.0053019193E+00, 8.7600774532E-01],
	[2.5675000000E+04, 1.6470632650E+01, 5.2317218810E+00, 4.0543371440E+00, 2.0059970306E+00, 8.7606819490E-01],
	[2.5680000000E+04, 1.6475722377E+01, 5.2316715850E+00, 4.0568988255E+00, 2.0066920686E+00, 8.7612861645E-01],
	[2.5685000000E+04, 1.6480812686E+01, 5.2316212993E+00, 4.0594616260E+00, 2.0073870333E+00, 8.7618900997E-01],
	[2.5690000000E+04, 1.6485903576E+01, 5.2315710238E+00, 4.0620255457E+00, 2.0080819246E+00, 8.7624937549E-01],
	[2.5695000000E+04, 1.6490995048E+01, 5.2315207586E+00, 4.0645905849E+00, 2.0087767423E+00, 8.7630971300E-01],
	[2.5700000000E+04, 1.6496087100E+01, 5.2314705037E+00, 4.0671567439E+00, 2.0094714864E+00, 8.7637002252E-01],
	[2.5705000000E+04, 1.6501179734E+01, 5.2314202590E+00, 4.0697240229E+00, 2.0101661568E+00, 8.7643030406E-01],
	[2.5710000000E+04, 1.6506272950E+01, 5.2313700246E+00, 4.0722924221E+00, 2.0108607534E+00, 8.7649055763E-01],
	[2.5715000000E+04, 1.6511366746E+01, 5.2313198005E+00, 4.0748619420E+00, 2.0115552760E+00, 8.7655078324E-01],
	[2.5720000000E+04, 1.6516461124E+01, 5.2312695866E+00, 4.0774325827E+00, 2.0122497246E+00, 8.7661098090E-01],
	[2.5725000000E+04, 1.6521556082E+01, 5.2312193829E+00, 4.0800043445E+00, 2.0129440991E+00, 8.7667115061E-01],
	[2.5730000000E+04, 1.6526651622E+01, 5.2311691895E+00, 4.0825772277E+00, 2.0136383994E+00, 8.7673129239E-01],
	[2.5735000000E+04, 1.6531747743E+01, 5.2311190063E+00, 4.0851512325E+00, 2.0143326254E+00, 8.7679140625E-01],
	[2.5740000000E+04, 1.6536844444E+01, 5.2310688333E+00, 4.0877263593E+00, 2.0150267770E+00, 8.7685149220E-01],
	[2.5745000000E+04, 1.6541941727E+01, 5.2310186706E+00, 4.0903026082E+00, 2.0157208541E+00, 8.7691155025E-01],
	[2.5750000000E+04, 1.6547039590E+01, 5.2309685181E+00, 4.0928799796E+00, 2.0164148566E+00, 8.7697158040E-01],
	[2.5755000000E+04, 1.6552138035E+01, 5.2309183758E+00, 4.0954584738E+00, 2.0171087844E+00, 8.7703158267E-01],
	[2.5760000000E+04, 1.6557237060E+01, 5.2308682437E+00, 4.0980380909E+00, 2.0178026374E+00, 8.7709155708E-01],
	[2.5765000000E+04, 1.6562336665E+01, 5.2308181218E+00, 4.1006188314E+00, 2.0184964155E+00, 8.7715150362E-01],
	[2.5770000000E+04, 1.6567436852E+01, 5.2307680101E+00, 4.1032006954E+00, 2.0191901186E+00, 8.7721142231E-01],
	[2.5775000000E+04, 1.6572537619E+01, 5.2307179087E+00, 4.1057836832E+00, 2.0198837467E+00, 8.7727131315E-01],
	[2.5780000000E+04, 1.6577638966E+01, 5.2306678174E+00, 4.1083677951E+00, 2.0205772996E+00, 8.7733117617E-01],
	[2.5785000000E+04, 1.6582740895E+01, 5.2306177363E+00, 4.1109530313E+00, 2.0212707772E+00, 8.7739101136E-01],
	[2.5790000000E+04, 1.6587843403E+01, 5.2305676654E+00, 4.1135393922E+00, 2.0219641795E+00, 8.7745081875E-01],
	[2.5795000000E+04, 1.6592946492E+01, 5.2305176047E+00, 4.1161268780E+00, 2.0226575063E+00, 8.7751059833E-01],
	[2.5800000000E+04, 1.6598050162E+01, 5.2304675542E+00, 4.1187154889E+00, 2.0233507576E+00, 8.7757035012E-01],
	[2.5805000000E+04, 1.6603154411E+01, 5.2304175139E+00, 4.1213052253E+00, 2.0240439332E+00, 8.7763007413E-01],
	[2.5810000000E+04, 1.6608259242E+01, 5.2303674837E+00, 4.1238960874E+00, 2.0247370330E+00, 8.7768977037E-01],
	[2.5815000000E+04, 1.6613364652E+01, 5.2303174637E+00, 4.1264880755E+00, 2.0254300571E+00, 8.7774943885E-01],
	[2.5820000000E+04, 1.6618470643E+01, 5.2302674539E+00, 4.1290811899E+00, 2.0261230051E+00, 8.7780907958E-01],
	[2.5825000000E+04, 1.6623577213E+01, 5.2302174542E+00, 4.1316754307E+00, 2.0268158772E+00, 8.7786869257E-01],
	[2.5830000000E+04, 1.6628684364E+01, 5.2301674647E+00, 4.1342707984E+00, 2.0275086731E+00, 8.7792827782E-01],
	[2.5835000000E+04, 1.6633792095E+01, 5.2301174853E+00, 4.1368672931E+00, 2.0282013928E+00, 8.7798783536E-01],
	[2.5840000000E+04, 1.6638900406E+01, 5.2300675161E+00, 4.1394649152E+00, 2.0288940362E+00, 8.7804736519E-01],
	[2.5845000000E+04, 1.6644009297E+01, 5.2300175571E+00, 4.1420636649E+00, 2.0295866032E+00, 8.7810686731E-01],
	[2.5850000000E+04, 1.6649118768E+01, 5.2299676081E+00, 4.1446635425E+00, 2.0302790937E+00, 8.7816634175E-01],
	[2.5855000000E+04, 1.6654228818E+01, 5.2299176694E+00, 4.1472645482E+00, 2.0309715076E+00, 8.7822578851E-01],
	[2.5860000000E+04, 1.6659339449E+01, 5.2298677407E+00, 4.1498666823E+00, 2.0316638448E+00, 8.7828520760E-01],
	[2.5865000000E+04, 1.6664450659E+01, 5.2298178222E+00, 4.1524699452E+00, 2.0323561052E+00, 8.7834459902E-01],
	[2.5870000000E+04, 1.6669562449E+01, 5.2297679138E+00, 4.1550743370E+00, 2.0330482887E+00, 8.7840396280E-01],
	[2.5875000000E+04, 1.6674674819E+01, 5.2297180155E+00, 4.1576798580E+00, 2.0337403952E+00, 8.7846329894E-01],
	[2.5880000000E+04, 1.6679787768E+01, 5.2296681273E+00, 4.1602865085E+00, 2.0344324247E+00, 8.7852260745E-01],
	[2.5885000000E+04, 1.6684901298E+01, 5.2296182493E+00, 4.1628942889E+00, 2.0351243770E+00, 8.7858188835E-01],
	[2.5890000000E+04, 1.6690015406E+01, 5.2295683814E+00, 4.1655031992E+00, 2.0358162521E+00, 8.7864114163E-01],
	[2.5895000000E+04, 1.6695130094E+01, 5.2295185235E+00, 4.1681132399E+00, 2.0365080498E+00, 8.7870036732E-01],
	[2.5900000000E+04, 1.6700245362E+01, 5.2294686758E+00, 4.1707244112E+00, 2.0371997700E+00, 8.7875956542E-01],
	[2.5905000000E+04, 1.6705367558E+01, 5.2294198901E+00, 4.1733367133E+00, 2.0378916670E+00, 8.7881873594E-01],
	[2.5910000000E+04, 1.6710506754E+01, 5.2293738337E+00, 4.1759501466E+00, 2.0385841442E+00, 8.7887787889E-01],
	[2.5915000000E+04, 1.6715646538E+01, 5.2293277866E+00, 4.1785647112E+00, 2.0392765445E+00, 8.7893699428E-01],
	[2.5920000000E+04, 1.6720786912E+01, 5.2292817487E+00, 4.1811804076E+00, 2.0399688678E+00, 8.7899608213E-01],
	[2.5925000000E+04, 1.6725927874E+01, 5.2292357202E+00, 4.1837972359E+00, 2.0406611142E+00, 8.7905514244E-01],
	[2.5930000000E+04, 1.6731069425E+01, 5.2291897009E+00, 4.1864151964E+00, 2.0413532833E+00, 8.7911417522E-01],
	[2.5935000000E+04, 1.6736211565E+01, 5.2291436909E+00, 4.1890342894E+00, 2.0420453753E+00, 8.7917318049E-01],
	[2.5940000000E+04, 1.6741354294E+01, 5.2290976902E+00, 4.1916545151E+00, 2.0427373899E+00, 8.7923215825E-01],
	[2.5945000000E+04, 1.6746497611E+01, 5.2290516987E+00, 4.1942758739E+00, 2.0434293271E+00, 8.7929110852E-01],
	[2.5950000000E+04, 1.6751641517E+01, 5.2290057165E+00, 4.1968983660E+00, 2.0441211867E+00, 8.7935003130E-01],
	[2.5955000000E+04, 1.6756786011E+01, 5.2289597436E+00, 4.1995219917E+00, 2.0448129688E+00, 8.7940892660E-01],
	[2.5960000000E+04, 1.6761931094E+01, 5.2289137799E+00, 4.2021467512E+00, 2.0455046732E+00, 8.7946779444E-01],
	[2.5965000000E+04, 1.6767076765E+01, 5.2288678255E+00, 4.2047726448E+00, 2.0461962998E+00, 8.7952663483E-01],
	[2.5970000000E+04, 1.6772223025E+01, 5.2288218804E+00, 4.2073996728E+00, 2.0468878485E+00, 8.7958544777E-01],
	[2.5975000000E+04, 1.6777369872E+01, 5.2287759445E+00, 4.2100278355E+00, 2.0475793192E+00, 8.7964423327E-01],
	[2.5980000000E+04, 1.6782517309E+01, 5.2287300178E+00, 4.2126571331E+00, 2.0482707119E+00, 8.7970299135E-01],
	[2.5985000000E+04, 1.6787665333E+01, 5.2286841004E+00, 4.2152875658E+00, 2.0489620264E+00, 8.7976172202E-01],
	[2.5990000000E+04, 1.6792813946E+01, 5.2286381922E+00, 4.2179191341E+00, 2.0496532626E+00, 8.7982042528E-01],
	[2.5995000000E+04, 1.6797963147E+01, 5.2285922932E+00, 4.2205518381E+00, 2.0503444205E+00, 8.7987910115E-01],
	[2.6000000000E+04, 1.6803112936E+01, 5.2285464035E+00, 4.2231856781E+00, 2.0510355000E+00, 8.7993774964E-01],
	[2.6005000000E+04, 1.6808263313E+01, 5.2285005230E+00, 4.2258206544E+00, 2.0517265009E+00, 8.7999637076E-01],
	[2.6010000000E+04, 1.6813414278E+01, 5.2284546517E+00, 4.2284567673E+00, 2.0524174233E+00, 8.8005496451E-01],
	[2.6015000000E+04, 1.6818565832E+01, 5.2284087897E+00, 4.2310940170E+00, 2.0531082669E+00, 8.8011353091E-01],
	[2.6020000000E+04, 1.6823717973E+01, 5.2283629369E+00, 4.2337324038E+00, 2.0537990317E+00, 8.8017206997E-01],
	[2.6025000000E+04, 1.6828870702E+01, 5.2283170932E+00, 4.2363719279E+00, 2.0544897176E+00, 8.8023058170E-01],
	[2.6030000000E+04, 1.6834024018E+01, 5.2282712588E+00, 4.2390125897E+00, 2.0551803245E+00, 8.8028906611E-01],
	[2.6035000000E+04, 1.6839177923E+01, 5.2282254336E+00, 4.2416543894E+00, 2.0558708524E+00, 8.8034752321E-01],
	[2.6040000000E+04, 1.6844332415E+01, 5.2281796176E+00, 4.2442973273E+00, 2.0565613011E+00, 8.8040595301E-01],
	[2.6045000000E+04, 1.6849487496E+01, 5.2281338108E+00, 4.2469414037E+00, 2.0572516705E+00, 8.8046435551E-01],
	[2.6050000000E+04, 1.6854643163E+01, 5.2280880132E+00, 4.2495866187E+00, 2.0579419606E+00, 8.8052273074E-01],
	[2.6055000000E+04, 1.6859799419E+01, 5.2280422247E+00, 4.2522329728E+00, 2.0586321712E+00, 8.8058107870E-01],
	[2.6060000000E+04, 1.6864956262E+01, 5.2279964455E+00, 4.2548804662E+00, 2.0593223023E+00, 8.8063939940E-01],
	[2.6065000000E+04, 1.6870113692E+01, 5.2279506754E+00, 4.2575290990E+00, 2.0600123538E+00, 8.8069769286E-01],
	[2.6070000000E+04, 1.6875271710E+01, 5.2279049146E+00, 4.2601788717E+00, 2.0607023255E+00, 8.8075595907E-01],
	[2.6075000000E+04, 1.6880430316E+01, 5.2278591629E+00, 4.2628297845E+00, 2.0613922175E+00, 8.8081419805E-01],
	[2.6080000000E+04, 1.6885589508E+01, 5.2278134203E+00, 4.2654818377E+00, 2.0620820295E+00, 8.8087240979E-01],
	[2.6085000000E+04, 1.6890749288E+01, 5.2277676870E+00, 4.2681350314E+00, 2.0627717616E+00, 8.8093059429E-01],
	[2.6090000000E+04, 1.6895909656E+01, 5.2277219628E+00, 4.2707893661E+00, 2.0634614136E+00, 8.8098875158E-01],
	[2.6095000000E+04, 1.6901070611E+01, 5.2276762478E+00, 4.2734448420E+00, 2.0641509854E+00, 8.8104688165E-01],
	[2.6100000000E+04, 1.6906232153E+01, 5.2276305419E+00, 4.2761014592E+00, 2.0648404770E+00, 8.8110498452E-01],
	[2.6105000000E+04, 1.6911394282E+01, 5.2275848452E+00, 4.2787592182E+00, 2.0655298883E+00, 8.8116306019E-01],
	[2.6110000000E+04, 1.6916556998E+01, 5.2275391576E+00, 4.2814181192E+00, 2.0662192190E+00, 8.8122110868E-01],
	[2.6115000000E+04, 1.6921720301E+01, 5.2274934792E+00, 4.2840781624E+00, 2.0669084693E+00, 8.8127912999E-01],
	[2.6120000000E+04, 1.6926884191E+01, 5.2274478099E+00, 4.2867393482E+00, 2.0675976390E+00, 8.8133712413E-01],
	[2.6125000000E+04, 1.6932048669E+01, 5.2274021498E+00, 4.2894016768E+00, 2.0682867279E+00, 8.8139509110E-01],
	[2.6130000000E+04, 1.6937213733E+01, 5.2273564988E+00, 4.2920651484E+00, 2.0689757360E+00, 8.8145303093E-01],
	[2.6135000000E+04, 1.6942379384E+01, 5.2273108569E+00, 4.2947297634E+00, 2.0696646633E+00, 8.8151094362E-01],
	[2.6140000000E+04, 1.6947545622E+01, 5.2272652242E+00, 4.2973955220E+00, 2.0703535096E+00, 8.8156882917E-01],
	[2.6145000000E+04, 1.6952712446E+01, 5.2272196006E+00, 4.3000624245E+00, 2.0710422748E+00, 8.8162668760E-01],
	[2.6150000000E+04, 1.6957879858E+01, 5.2271739861E+00, 4.3027304711E+00, 2.0717309589E+00, 8.8168451891E-01],
	[2.6155000000E+04, 1.6963047856E+01, 5.2271283807E+00, 4.3053996622E+00, 2.0724195617E+00, 8.8174232312E-01],
	[2.6160000000E+04, 1.6968216441E+01, 5.2270827844E+00, 4.3080699979E+00, 2.0731080832E+00, 8.8180010023E-01],
	[2.6165000000E+04, 1.6973385612E+01, 5.2270371973E+00, 4.3107414787E+00, 2.0737965233E+00, 8.8185785025E-01],
	[2.6170000000E+04, 1.6978555370E+01, 5.2269916193E+00, 4.3134141047E+00, 2.0744848818E+00, 8.8191557319E-01],
	[2.6175000000E+04, 1.6983725715E+01, 5.2269460503E+00, 4.3160878762E+00, 2.0751731588E+00, 8.8197326905E-01],
	[2.6180000000E+04, 1.6988896646E+01, 5.2269004905E+00, 4.3187627935E+00, 2.0758613540E+00, 8.8203093786E-01],
	[2.6185000000E+04, 1.6994068163E+01, 5.2268549398E+00, 4.3214388568E+00, 2.0765494675E+00, 8.8208857962E-01],
	[2.6190000000E+04, 1.6999240267E+01, 5.2268093981E+00, 4.3241160665E+00, 2.0772374992E+00, 8.8214619433E-01],
	[2.6195000000E+04, 1.7004412957E+01, 5.2267638656E+00, 4.3267944228E+00, 2.0779254488E+00, 8.8220378201E-01],
	[2.6200000000E+04, 1.7009586234E+01, 5.2267183421E+00, 4.3294739260E+00, 2.0786133165E+00, 8.8226134266E-01],
	[2.6205000000E+04, 1.7014760097E+01, 5.2266728277E+00, 4.3321545763E+00, 2.0793011020E+00, 8.8231887629E-01],
	[2.6210000000E+04, 1.7019934546E+01, 5.2266273224E+00, 4.3348363740E+00, 2.0799888053E+00, 8.8237638292E-01],
	[2.6215000000E+04, 1.7025109581E+01, 5.2265818262E+00, 4.3375193194E+00, 2.0806764262E+00, 8.8243386255E-01],
	[2.6220000000E+04, 1.7030285202E+01, 5.2265363391E+00, 4.3402034128E+00, 2.0813639648E+00, 8.8249131519E-01],
	[2.6225000000E+04, 1.7035461409E+01, 5.2264908610E+00, 4.3428886544E+00, 2.0820514209E+00, 8.8254874085E-01],
	[2.6230000000E+04, 1.7040638202E+01, 5.2264453920E+00, 4.3455750446E+00, 2.0827387944E+00, 8.8260613953E-01],
	[2.6235000000E+04, 1.7045815582E+01, 5.2263999320E+00, 4.3482625835E+00, 2.0834260853E+00, 8.8266351126E-01],
	[2.6240000000E+04, 1.7050993547E+01, 5.2263544811E+00, 4.3509512714E+00, 2.0841132934E+00, 8.8272085603E-01],
	[2.6245000000E+04, 1.7056172098E+01, 5.2263090393E+00, 4.3536411087E+00, 2.0848004187E+00, 8.8277817386E-01],
	[2.6250000000E+04, 1.7061351235E+01, 5.2262636065E+00, 4.3563320956E+00, 2.0854874611E+00, 8.8283546475E-01],
	[2.6255000000E+04, 1.7066530958E+01, 5.2262181828E+00, 4.3590242323E+00, 2.0861744204E+00, 8.8289272872E-01],
	[2.6260000000E+04, 1.7071711266E+01, 5.2261727681E+00, 4.3617175192E+00, 2.0868612967E+00, 8.8294996577E-01],
	[2.6265000000E+04, 1.7076892160E+01, 5.2261273624E+00, 4.3644119565E+00, 2.0875480898E+00, 8.8300717591E-01],
	[2.6270000000E+04, 1.7082073640E+01, 5.2260819658E+00, 4.3671075444E+00, 2.0882347996E+00, 8.8306435916E-01],
	[2.6275000000E+04, 1.7087255706E+01, 5.2260365782E+00, 4.3698042833E+00, 2.0889214260E+00, 8.8312151551E-01],
	[2.6280000000E+04, 1.7092438357E+01, 5.2259911997E+00, 4.3725021735E+00, 2.0896079690E+00, 8.8317864499E-01],
	[2.6285000000E+04, 1.7097621593E+01, 5.2259458301E+00, 4.3752012151E+00, 2.0902944285E+00, 8.8323574759E-01],
	[2.6290000000E+04, 1.7102805415E+01, 5.2259004696E+00, 4.3779014085E+00, 2.0909808043E+00, 8.8329282333E-01],
	[2.6295000000E+04, 1.7107989823E+01, 5.2258551181E+00, 4.3806027540E+00, 2.0916670965E+00, 8.8334987222E-01],
	[2.6300000000E+04, 1.7113174816E+01, 5.2258097757E+00, 4.3833052518E+00, 2.0923533048E+00, 8.8340689427E-01],
	[2.6305000000E+04, 1.7118360394E+01, 5.2257644422E+00, 4.3860089021E+00, 2.0930394293E+00, 8.8346388948E-01],
	[2.6310000000E+04, 1.7123546557E+01, 5.2257191178E+00, 4.3887137053E+00, 2.0937254698E+00, 8.8352085787E-01],
	[2.6315000000E+04, 1.7128733306E+01, 5.2256738023E+00, 4.3914196617E+00, 2.0944114262E+00, 8.8357779944E-01],
	[2.6320000000E+04, 1.7133920640E+01, 5.2256284959E+00, 4.3941267714E+00, 2.0950972985E+00, 8.8363471420E-01],
	[2.6325000000E+04, 1.7139128433E+01, 5.2255864459E+00, 4.3968350348E+00, 2.0957839061E+00, 8.8369160217E-01],
	[2.6330000000E+04, 1.7144339624E+01, 5.2255448623E+00, 4.3995444522E+00, 2.0964705458E+00, 8.8374846335E-01],
	[2.6335000000E+04, 1.7149551409E+01, 5.2255032869E+00, 4.4022550238E+00, 2.0971571020E+00, 8.8380529775E-01],
	[2.6340000000E+04, 1.7154763789E+01, 5.2254617198E+00, 4.4049667499E+00, 2.0978435745E+00, 8.8386210538E-01],
	[2.6345000000E+04, 1.7159976764E+01, 5.2254201609E+00, 4.4076796307E+00, 2.0985299633E+00, 8.8391888625E-01],
	[2.6350000000E+04, 1.7165190332E+01, 5.2253786102E+00, 4.4103936666E+00, 2.0992162683E+00, 8.8397564037E-01],
	[2.6355000000E+04, 1.7170404495E+01, 5.2253370677E+00, 4.4131088577E+00, 2.0999024895E+00, 8.8403236775E-01],
	[2.6360000000E+04, 1.7175619253E+01, 5.2252955334E+00, 4.4158252045E+00, 2.1005886266E+00, 8.8408906839E-01],
	[2.6365000000E+04, 1.7180834605E+01, 5.2252540073E+00, 4.4185427071E+00, 2.1012746797E+00, 8.8414574231E-01],
	[2.6370000000E+04, 1.7186050550E+01, 5.2252124895E+00, 4.4212613658E+00, 2.1019606486E+00, 8.8420238952E-01],
	[2.6375000000E+04, 1.7191267090E+01, 5.2251709798E+00, 4.4239811810E+00, 2.1026465333E+00, 8.8425901002E-01],
	[2.6380000000E+04, 1.7196484225E+01, 5.2251294784E+00, 4.4267021528E+00, 2.1033323337E+00, 8.8431560383E-01],
	[2.6385000000E+04, 1.7201701953E+01, 5.2250879851E+00, 4.4294242815E+00, 2.1040180497E+00, 8.8437217095E-01],
	[2.6390000000E+04, 1.7206920275E+01, 5.2250465000E+00, 4.4321475675E+00, 2.1047036812E+00, 8.8442871139E-01],
	[2.6395000000E+04, 1.7212139191E+01, 5.2250050231E+00, 4.4348720109E+00, 2.1053892281E+00, 8.8448522517E-01],
	[2.6400000000E+04, 1.7217358701E+01, 5.2249635544E+00, 4.4375976121E+00, 2.1060746903E+00, 8.8454171229E-01],
	[2.6405000000E+04, 1.7222578805E+01, 5.2249220939E+00, 4.4403243713E+00, 2.1067600678E+00, 8.8459817276E-01],
	[2.6410000000E+04, 1.7227799503E+01, 5.2248806416E+00, 4.4430522888E+00, 2.1074453605E+00, 8.8465460659E-01],
	[2.6415000000E+04, 1.7233020795E+01, 5.2248391974E+00, 4.4457813649E+00, 2.1081305683E+00, 8.8471101379E-01],
	[2.6420000000E+04, 1.7238242681E+01, 5.2247977614E+00, 4.4485115999E+00, 2.1088156911E+00, 8.8476739437E-01],
	[2.6425000000E+04, 1.7243465160E+01, 5.2247563336E+00, 4.4512429939E+00, 2.1095007288E+00, 8.8482374834E-01],
	[2.6430000000E+04, 1.7248688233E+01, 5.2247149139E+00, 4.4539755474E+00, 2.1101856813E+00, 8.8488007571E-01],
	[2.6435000000E+04, 1.7253911899E+01, 5.2246735024E+00, 4.4567092605E+00, 2.1108705486E+00, 8.8493637648E-01],
	[2.6440000000E+04, 1.7259136159E+01, 5.2246320991E+00, 4.4594441335E+00, 2.1115553305E+00, 8.8499265068E-01],
	[2.6445000000E+04, 1.7264361013E+01, 5.2245907039E+00, 4.4621801668E+00, 2.1122400271E+00, 8.8504889829E-01],
	[2.6450000000E+04, 1.7269586460E+01, 5.2245493169E+00, 4.4649173605E+00, 2.1129246381E+00, 8.8510511935E-01],
	[2.6455000000E+04, 1.7274812500E+01, 5.2245079380E+00, 4.4676557150E+00, 2.1136091635E+00, 8.8516131385E-01],
	[2.6460000000E+04, 1.7280039134E+01, 5.2244665673E+00, 4.4703952306E+00, 2.1142936033E+00, 8.8521748180E-01],
	[2.6465000000E+04, 1.7285266362E+01, 5.2244252047E+00, 4.4731359074E+00, 2.1149779573E+00, 8.8527362322E-01],
	[2.6470000000E+04, 1.7290494182E+01, 5.2243838503E+00, 4.4758777458E+00, 2.1156622254E+00, 8.8532973811E-01],
	[2.6475000000E+04, 1.7295722596E+01, 5.2243425040E+00, 4.4786207460E+00, 2.1163464077E+00, 8.8538582649E-01],
	[2.6480000000E+04, 1.7300951603E+01, 5.2243011658E+00, 4.4813649083E+00, 2.1170305039E+00, 8.8544188835E-01],
	[2.6485000000E+04, 1.7306181204E+01, 5.2242598357E+00, 4.4841102331E+00, 2.1177145140E+00, 8.8549792372E-01],
	[2.6490000000E+04, 1.7311411397E+01, 5.2242185138E+00, 4.4868567205E+00, 2.1183984380E+00, 8.8555393260E-01],
	[2.6495000000E+04, 1.7316642184E+01, 5.2241772001E+00, 4.4896043708E+00, 2.1190822757E+00, 8.8560991500E-01],
	[2.6500000000E+04, 1.7321873563E+01, 5.2241358944E+00, 4.4923531843E+00, 2.1197660271E+00, 8.8566587093E-01],
	[2.6505000000E+04, 1.7327105536E+01, 5.2240945969E+00, 4.4951031613E+00, 2.1204496920E+00, 8.8572180040E-01],
	[2.6510000000E+04, 1.7332338101E+01, 5.2240533074E+00, 4.4978543021E+00, 2.1211332705E+00, 8.8577770342E-01],
	[2.6515000000E+04, 1.7337571260E+01, 5.2240120261E+00, 4.5006066069E+00, 2.1218167623E+00, 8.8583358000E-01],
	[2.6520000000E+04, 1.7342805011E+01, 5.2239707529E+00, 4.5033600760E+00, 2.1225001675E+00, 8.8588943015E-01],
	[2.6525000000E+04, 1.7348039355E+01, 5.2239294878E+00, 4.5061147096E+00, 2.1231834859E+00, 8.8594525388E-01],
	[2.6530000000E+04, 1.7353274292E+01, 5.2238882308E+00, 4.5088705081E+00, 2.1238667175E+00, 8.8600105119E-01],
	[2.6535000000E+04, 1.7358509821E+01, 5.2238469820E+00, 4.5116274717E+00, 2.1245498621E+00, 8.8605682210E-01],
	[2.6540000000E+04, 1.7363745944E+01, 5.2238057412E+00, 4.5143856007E+00, 2.1252329198E+00, 8.8611256662E-01],
	[2.6545000000E+04, 1.7368982659E+01, 5.2237645085E+00, 4.5171448953E+00, 2.1259158903E+00, 8.8616828475E-01],
	[2.6550000000E+04, 1.7374219966E+01, 5.2237232839E+00, 4.5199053559E+00, 2.1265987737E+00, 8.8622397651E-01],
	[2.6555000000E+04, 1.7379457866E+01, 5.2236820673E+00, 4.5226669827E+00, 2.1272815699E+00, 8.8627964190E-01],
	[2.6560000000E+04, 1.7384696359E+01, 5.2236408589E+00, 4.5254297759E+00, 2.1279642787E+00, 8.8633528094E-01],
	[2.6565000000E+04, 1.7389935444E+01, 5.2235996586E+00, 4.5281937360E+00, 2.1286469001E+00, 8.8639089363E-01],
	[2.6570000000E+04, 1.7395175122E+01, 5.2235584663E+00, 4.5309588630E+00, 2.1293294340E+00, 8.8644647999E-01],
	[2.6575000000E+04, 1.7400415391E+01, 5.2235172821E+00, 4.5337251573E+00, 2.1300118803E+00, 8.8650204002E-01],
	[2.6580000000E+04, 1.7405656254E+01, 5.2234761060E+00, 4.5364926192E+00, 2.1306942390E+00, 8.8655757373E-01],
	[2.6585000000E+04, 1.7410897708E+01, 5.2234349379E+00, 4.5392612489E+00, 2.1313765099E+00, 8.8661308113E-01],
	[2.6590000000E+04, 1.7416139755E+01, 5.2233937779E+00, 4.5420310468E+00, 2.1320586930E+00, 8.8666856224E-01],
	[2.6595000000E+04, 1.7421382394E+01, 5.2233526260E+00, 4.5448020130E+00, 2.1327407882E+00, 8.8672401706E-01],
	[2.6600000000E+04, 1.7426625625E+01, 5.2233114821E+00, 4.5475741479E+00, 2.1334227954E+00, 8.8677944560E-01],
	[2.6605000000E+04, 1.7431869448E+01, 5.2232703463E+00, 4.5503474517E+00, 2.1341047145E+00, 8.8683484787E-01],
	[2.6610000000E+04, 1.7437113863E+01, 5.2232292186E+00, 4.5531219247E+00, 2.1347865454E+00, 8.8689022389E-01],
	[2.6615000000E+04, 1.7442358870E+01, 5.2231880989E+00, 4.5558975672E+00, 2.1354682882E+00, 8.8694557365E-01],
	[2.6620000000E+04, 1.7447604470E+01, 5.2231469872E+00, 4.5586743795E+00, 2.1361499426E+00, 8.8700089717E-01],
	[2.6625000000E+04, 1.7452850661E+01, 5.2231058836E+00, 4.5614523618E+00, 2.1368315086E+00, 8.8705619446E-01],
	[2.6630000000E+04, 1.7458097444E+01, 5.2230647880E+00, 4.5642315143E+00, 2.1375129862E+00, 8.8711146554E-01],
	[2.6635000000E+04, 1.7463344819E+01, 5.2230237005E+00, 4.5670118375E+00, 2.1381943752E+00, 8.8716671040E-01],
	[2.6640000000E+04, 1.7468592786E+01, 5.2229826210E+00, 4.5697933314E+00, 2.1388756755E+00, 8.8722192906E-01],
	[2.6645000000E+04, 1.7473841344E+01, 5.2229415495E+00, 4.5725759965E+00, 2.1395568872E+00, 8.8727712153E-01],
	[2.6650000000E+04, 1.7479090494E+01, 5.2229004861E+00, 4.5753598330E+00, 2.1402380100E+00, 8.8733228781E-01],
	[2.6655000000E+04, 1.7484340236E+01, 5.2228594307E+00, 4.5781448411E+00, 2.1409190440E+00, 8.8738742793E-01],
	[2.6660000000E+04, 1.7489590569E+01, 5.2228183833E+00, 4.5809310212E+00, 2.1415999890E+00, 8.8744254188E-01],
	[2.6665000000E+04, 1.7494841494E+01, 5.2227773439E+00, 4.5837183735E+00, 2.1422808449E+00, 8.8749762968E-01],
	[2.6670000000E+04, 1.7500093011E+01, 5.2227363126E+00, 4.5865068983E+00, 2.1429616118E+00, 8.8755269133E-01],
	[2.6675000000E+04, 1.7505345119E+01, 5.2226952893E+00, 4.5892965958E+00, 2.1436422894E+00, 8.8760772685E-01],
	[2.6680000000E+04, 1.7510597818E+01, 5.2226542739E+00, 4.5920874663E+00, 2.1443228777E+00, 8.8766273625E-01],
	[2.6685000000E+04, 1.7515851109E+01, 5.2226132666E+00, 4.5948795101E+00, 2.1450033767E+00, 8.8771771954E-01],
	[2.6690000000E+04, 1.7521104992E+01, 5.2225722673E+00, 4.5976727275E+00, 2.1456837863E+00, 8.8777267672E-01],
	[2.6695000000E+04, 1.7526359465E+01, 5.2225312760E+00, 4.6004671188E+00, 2.1463641063E+00, 8.8782760780E-01],
	[2.6700000000E+04, 1.7531614530E+01, 5.2224902927E+00, 4.6032626841E+00, 2.1470443367E+00, 8.8788251280E-01],
	[2.6705000000E+04, 1.7536870186E+01, 5.2224493174E+00, 4.6060594239E+00, 2.1477244775E+00, 8.8793739173E-01],
	[2.6710000000E+04, 1.7542126433E+01, 5.2224083501E+00, 4.6088573383E+00, 2.1484045285E+00, 8.8799224459E-01],
	[2.6715000000E+04, 1.7547383272E+01, 5.2223673907E+00, 4.6116564276E+00, 2.1490844896E+00, 8.8804707139E-01],
	[2.6720000000E+04, 1.7552640701E+01, 5.2223264394E+00, 4.6144566922E+00, 2.1497643608E+00, 8.8810187215E-01],
	[2.6725000000E+04, 1.7557898721E+01, 5.2222854960E+00, 4.6172581322E+00, 2.1504441420E+00, 8.8815664687E-01],
	[2.6730000000E+04, 1.7563157333E+01, 5.2222445606E+00, 4.6200607480E+00, 2.1511238332E+00, 8.8821139557E-01],
	[2.6735000000E+04, 1.7568416535E+01, 5.2222036332E+00, 4.6228645398E+00, 2.1518034342E+00, 8.8826611825E-01],
	[2.6740000000E+04, 1.7573676329E+01, 5.2221627138E+00, 4.6256695080E+00, 2.1524829449E+00, 8.8832081493E-01],
	[2.6745000000E+04, 1.7578939675E+01, 5.2221222799E+00, 4.6284756527E+00, 2.1531624909E+00, 8.8837548560E-01],
	[2.6750000000E+04, 1.7584223240E+01, 5.2220850174E+00, 4.6312829742E+00, 2.1538427793E+00, 8.8843013029E-01],
	[2.6755000000E+04, 1.7589507405E+01, 5.2220477621E+00, 4.6340914729E+00, 2.1545229781E+00, 8.8848474901E-01],
	[2.6760000000E+04, 1.7594792170E+01, 5.2220105140E+00, 4.6369011489E+00, 2.1552030871E+00, 8.8853934175E-01],
	[2.6765000000E+04, 1.7600077535E+01, 5.2219732732E+00, 4.6397120026E+00, 2.1558831064E+00, 8.8859390854E-01],
	[2.6770000000E+04, 1.7605363501E+01, 5.2219360396E+00, 4.6425240343E+00, 2.1565630357E+00, 8.8864844938E-01],
	[2.6775000000E+04, 1.7610650066E+01, 5.2218988132E+00, 4.6453372442E+00, 2.1572428751E+00, 8.8870296428E-01],
	[2.6780000000E+04, 1.7615937231E+01, 5.2218615940E+00, 4.6481516326E+00, 2.1579226245E+00, 8.8875745326E-01],
	[2.6785000000E+04, 1.7621224996E+01, 5.2218243821E+00, 4.6509671997E+00, 2.1586022838E+00, 8.8881191631E-01],
	[2.6790000000E+04, 1.7626513360E+01, 5.2217871773E+00, 4.6537839458E+00, 2.1592818529E+00, 8.8886635346E-01],
	[2.6795000000E+04, 1.7631802325E+01, 5.2217499798E+00, 4.6566018713E+00, 2.1599613317E+00, 8.8892076471E-01],
	[2.6800000000E+04, 1.7637091889E+01, 5.2217127895E+00, 4.6594209763E+00, 2.1606407201E+00, 8.8897515007E-01],
	[2.6805000000E+04, 1.7642382052E+01, 5.2216756063E+00, 4.6622412612E+00, 2.1613200182E+00, 8.8902950955E-01],
	[2.6810000000E+04, 1.7647672816E+01, 5.2216384304E+00, 4.6650627263E+00, 2.1619992257E+00, 8.8908384316E-01],
	[2.6815000000E+04, 1.7652964179E+01, 5.2216012617E+00, 4.6678853717E+00, 2.1626783427E+00, 8.8913815091E-01],
	[2.6820000000E+04, 1.7658256141E+01, 5.2215641001E+00, 4.6707091978E+00, 2.1633573690E+00, 8.8919243282E-01],
	[2.6825000000E+04, 1.7663548703E+01, 5.2215269458E+00, 4.6735342048E+00, 2.1640363046E+00, 8.8924668888E-01],
	[2.6830000000E+04, 1.7668841865E+01, 5.2214897986E+00, 4.6763603931E+00, 2.1647151493E+00, 8.8930091912E-01],
	[2.6835000000E+04, 1.7674135626E+01, 5.2214526587E+00, 4.6791877628E+00, 2.1653939032E+00, 8.8935512353E-01],
	[2.6840000000E+04, 1.7679429986E+01, 5.2214155259E+00, 4.6820163143E+00, 2.1660725661E+00, 8.8940930214E-01],
	[2.6845000000E+04, 1.7684724945E+01, 5.2213784003E+00, 4.6848460479E+00, 2.1667511380E+00, 8.8946345495E-01],
	[2.6850000000E+04, 1.7690020504E+01, 5.2213412818E+00, 4.6876769638E+00, 2.1674296187E+00, 8.8951758196E-01],
	[2.6855000000E+04, 1.7695316662E+01, 5.2213041706E+00, 4.6905090622E+00, 2.1681080082E+00, 8.8957168320E-01],
	[2.6860000000E+04, 1.7700613419E+01, 5.2212670665E+00, 4.6933423435E+00, 2.1687863065E+00, 8.8962575867E-01],
	[2.6865000000E+04, 1.7705910776E+01, 5.2212299696E+00, 4.6961768080E+00, 2.1694645134E+00, 8.8967980837E-01],
	[2.6870000000E+04, 1.7711208731E+01, 5.2211928798E+00, 4.6990124558E+00, 2.1701426289E+00, 8.8973383233E-01],
	[2.6875000000E+04, 1.7716507286E+01, 5.2211557973E+00, 4.7018492874E+00, 2.1708206528E+00, 8.8978783055E-01],
	[2.6880000000E+04, 1.7721806439E+01, 5.2211187218E+00, 4.7046873029E+00, 2.1714985852E+00, 8.8984180303E-01],
	[2.6885000000E+04, 1.7727106192E+01, 5.2210816536E+00, 4.7075265026E+00, 2.1721764259E+00, 8.8989574980E-01],
	[2.6890000000E+04, 1.7732406543E+01, 5.2210445925E+00, 4.7103668868E+00, 2.1728541749E+00, 8.8994967086E-01],
	[2.6895000000E+04, 1.7737707493E+01, 5.2210075385E+00, 4.7132084558E+00, 2.1735318321E+00, 8.9000356621E-01],
	[2.6900000000E+04, 1.7743009042E+01, 5.2209704917E+00, 4.7160512098E+00, 2.1742093973E+00, 8.9005743588E-01],
	[2.6905000000E+04, 1.7748311190E+01, 5.2209334521E+00, 4.7188951492E+00, 2.1748868706E+00, 8.9011127986E-01],
	[2.6910000000E+04, 1.7753613937E+01, 5.2208964196E+00, 4.7217402741E+00, 2.1755642519E+00, 8.9016509817E-01],
	[2.6915000000E+04, 1.7758917282E+01, 5.2208593942E+00, 4.7245865849E+00, 2.1762415410E+00, 8.9021889083E-01],
	[2.6920000000E+04, 1.7764221226E+01, 5.2208223760E+00, 4.7274340819E+00, 2.1769187380E+00, 8.9027265783E-01],
	[2.6925000000E+04, 1.7769525769E+01, 5.2207853649E+00, 4.7302827653E+00, 2.1775958426E+00, 8.9032639919E-01],
	[2.6930000000E+04, 1.7774830910E+01, 5.2207483610E+00, 4.7331326353E+00, 2.1782728549E+00, 8.9038011492E-01],
	[2.6935000000E+04, 1.7780136650E+01, 5.2207113641E+00, 4.7359836924E+00, 2.1789497748E+00, 8.9043380504E-01],
	[2.6940000000E+04, 1.7785442988E+01, 5.2206743745E+00, 4.7388359366E+00, 2.1796266022E+00, 8.9048746954E-01],
	[2.6945000000E+04, 1.7790749925E+01, 5.2206373919E+00, 4.7416893684E+00, 2.1803033370E+00, 8.9054110844E-01],
	[2.6950000000E+04, 1.7796057460E+01, 5.2206004165E+00, 4.7445439880E+00, 2.1809799792E+00, 8.9059472175E-01],
	[2.6955000000E+04, 1.7801365593E+01, 5.2205634481E+00, 4.7473997956E+00, 2.1816565286E+00, 8.9064830948E-01],
	[2.6960000000E+04, 1.7806674325E+01, 5.2205264869E+00, 4.7502567915E+00, 2.1823329852E+00, 8.9070187163E-01],
	[2.6965000000E+04, 1.7811983655E+01, 5.2204895329E+00, 4.7531149761E+00, 2.1830093490E+00, 8.9075540823E-01],
	[2.6970000000E+04, 1.7817293583E+01, 5.2204525859E+00, 4.7559743495E+00, 2.1836856198E+00, 8.9080891928E-01],
	[2.6975000000E+04, 1.7822604109E+01, 5.2204156460E+00, 4.7588349120E+00, 2.1843617975E+00, 8.9086240479E-01],
	[2.6980000000E+04, 1.7827915234E+01, 5.2203787133E+00, 4.7616966640E+00, 2.1850378822E+00, 8.9091586476E-01],
	[2.6985000000E+04, 1.7833226956E+01, 5.2203417876E+00, 4.7645596057E+00, 2.1857138737E+00, 8.9096929922E-01],
	[2.6990000000E+04, 1.7838539277E+01, 5.2203048691E+00, 4.7674237374E+00, 2.1863897719E+00, 8.9102270817E-01],
	[2.6995000000E+04, 1.7843852195E+01, 5.2202679576E+00, 4.7702890593E+00, 2.1870655768E+00, 8.9107609161E-01],
	[2.7000000000E+04, 1.7849165712E+01, 5.2202310533E+00, 4.7731555718E+00, 2.1877412883E+00, 8.9112944957E-01],
	[2.7005000000E+04, 1.7854479827E+01, 5.2201941560E+00, 4.7760232750E+00, 2.1884169063E+00, 8.9118278205E-01],
	[2.7010000000E+04, 1.7859794539E+01, 5.2201572659E+00, 4.7788921693E+00, 2.1890924307E+00, 8.9123608905E-01],
	[2.7015000000E+04, 1.7865109849E+01, 5.2201203828E+00, 4.7817622549E+00, 2.1897678616E+00, 8.9128937060E-01],
	[2.7020000000E+04, 1.7870425757E+01, 5.2200835068E+00, 4.7846335322E+00, 2.1904431987E+00, 8.9134262669E-01],
	[2.7025000000E+04, 1.7875742263E+01, 5.2200466379E+00, 4.7875060013E+00, 2.1911184420E+00, 8.9139585735E-01],
	[2.7030000000E+04, 1.7881059366E+01, 5.2200097761E+00, 4.7903796626E+00, 2.1917935915E+00, 8.9144906258E-01],
	[2.7035000000E+04, 1.7886377068E+01, 5.2199729214E+00, 4.7932545164E+00, 2.1924686471E+00, 8.9150224238E-01],
	[2.7040000000E+04, 1.7891695366E+01, 5.2199360737E+00, 4.7961305628E+00, 2.1931436087E+00, 8.9155539678E-01],
	[2.7045000000E+04, 1.7897014263E+01, 5.2198992331E+00, 4.7990078023E+00, 2.1938184762E+00, 8.9160852578E-01],
	[2.7050000000E+04, 1.7902333756E+01, 5.2198623996E+00, 4.8018862350E+00, 2.1944932495E+00, 8.9166162939E-01],
	[2.7055000000E+04, 1.7907653848E+01, 5.2198255731E+00, 4.8047658612E+00, 2.1951679286E+00, 8.9171470762E-01],
	[2.7060000000E+04, 1.7912974537E+01, 5.2197887537E+00, 4.8076466812E+00, 2.1958425134E+00, 8.9176776048E-01],
	[2.7065000000E+04, 1.7918295823E+01, 5.2197519414E+00, 4.8105286953E+00, 2.1965170039E+00, 8.9182078798E-01],
	[2.7070000000E+04, 1.7923617706E+01, 5.2197151361E+00, 4.8134119038E+00, 2.1971913999E+00, 8.9187379013E-01],
	[2.7075000000E+04, 1.7928940187E+01, 5.2196783379E+00, 4.8162963069E+00, 2.1978657014E+00, 8.9192676694E-01],
	[2.7080000000E+04, 1.7934263265E+01, 5.2196415468E+00, 4.8191819049E+00, 2.1985399083E+00, 8.9197971843E-01],
	[2.7085000000E+04, 1.7939586940E+01, 5.2196047626E+00, 4.8220686981E+00, 2.1992140205E+00, 8.9203264460E-01],
	[2.7090000000E+04, 1.7944911213E+01, 5.2195679856E+00, 4.8249566867E+00, 2.1998880380E+00, 8.9208554545E-01],
	[2.7095000000E+04, 1.7950236083E+01, 5.2195312156E+00, 4.8278458710E+00, 2.2005619607E+00, 8.9213842101E-01],
	[2.7100000000E+04, 1.7955561549E+01, 5.2194944526E+00, 4.8307362514E+00, 2.2012357885E+00, 8.9219127129E-01],
	[2.7105000000E+04, 1.7960887613E+01, 5.2194576967E+00, 4.8336278280E+00, 2.2019095214E+00, 8.9224409628E-01],
	[2.7110000000E+04, 1.7966214274E+01, 5.2194209478E+00, 4.8365206011E+00, 2.2025831592E+00, 8.9229689601E-01],
	[2.7115000000E+04, 1.7971541532E+01, 5.2193842059E+00, 4.8394145711E+00, 2.2032567019E+00, 8.9234967048E-01],
	[2.7120000000E+04, 1.7976869386E+01, 5.2193474711E+00, 4.8423097382E+00, 2.2039301494E+00, 8.9240241970E-01],
	[2.7125000000E+04, 1.7982197838E+01, 5.2193107433E+00, 4.8452061026E+00, 2.2046035017E+00, 8.9245514368E-01],
	[2.7130000000E+04, 1.7987526886E+01, 5.2192740226E+00, 4.8481036647E+00, 2.2052767587E+00, 8.9250784244E-01],
	[2.7135000000E+04, 1.7992856531E+01, 5.2192373088E+00, 4.8510024247E+00, 2.2059499202E+00, 8.9256051598E-01],
	[2.7140000000E+04, 1.7998186773E+01, 5.2192006021E+00, 4.8539023829E+00, 2.2066229864E+00, 8.9261316431E-01],
	[2.7145000000E+04, 1.8003517612E+01, 5.2191639024E+00, 4.8568035395E+00, 2.2072959569E+00, 8.9266578744E-01],
	[2.7150000000E+04, 1.8008849047E+01, 5.2191272098E+00, 4.8597058949E+00, 2.2079688319E+00, 8.9271838539E-01],
	[2.7155000000E+04, 1.8014181079E+01, 5.2190905241E+00, 4.8626094493E+00, 2.2086416112E+00, 8.9277095815E-01],
	[2.7160000000E+04, 1.8019513708E+01, 5.2190538454E+00, 4.8655142030E+00, 2.2093142947E+00, 8.9282350574E-01],
	[2.7165000000E+04, 1.8024846933E+01, 5.2190171738E+00, 4.8684201562E+00, 2.2099868824E+00, 8.9287602817E-01],
	[2.7170000000E+04, 1.8030180754E+01, 5.2189805092E+00, 4.8713273093E+00, 2.2106593742E+00, 8.9292852545E-01],
	[2.7175000000E+04, 1.8035515659E+01, 5.2189439289E+00, 4.8742356625E+00, 2.2113317912E+00, 8.9298099758E-01],
	[2.7180000000E+04, 1.8040873171E+01, 5.2189108563E+00, 4.8771452161E+00, 2.2120050720E+00, 8.9303344458E-01],
	[2.7185000000E+04, 1.8046231289E+01, 5.2188777899E+00, 4.8800559703E+00, 2.2126782574E+00, 8.9308586645E-01],
	[2.7190000000E+04, 1.8051590013E+01, 5.2188447298E+00, 4.8829679255E+00, 2.2133513475E+00, 8.9313826320E-01],
	[2.7195000000E+04, 1.8056949341E+01, 5.2188116760E+00, 4.8858810818E+00, 2.2140243422E+00, 8.9319063485E-01],
	[2.7200000000E+04, 1.8062309276E+01, 5.2187786284E+00, 4.8887954397E+00, 2.2146972413E+00, 8.9324298140E-01],
	[2.7205000000E+04, 1.8067669816E+01, 5.2187455872E+00, 4.8917109993E+00, 2.2153700449E+00, 8.9329530285E-01],
	[2.7210000000E+04, 1.8073030961E+01, 5.2187125522E+00, 4.8946277609E+00, 2.2160427529E+00, 8.9334759923E-01],
	[2.7215000000E+04, 1.8078392711E+01, 5.2186795235E+00, 4.8975457249E+00, 2.2167153651E+00, 8.9339987053E-01],
	[2.7220000000E+04, 1.8083755067E+01, 5.2186465011E+00, 4.9004648914E+00, 2.2173878815E+00, 8.9345211678E-01],
	[2.7225000000E+04, 1.8089118028E+01, 5.2186134850E+00, 4.9033852607E+00, 2.2180603020E+00, 8.9350433796E-01],
	[2.7230000000E+04, 1.8094481594E+01, 5.2185804752E+00, 4.9063068332E+00, 2.2187326266E+00, 8.9355653411E-01],
	[2.7235000000E+04, 1.8099845765E+01, 5.2185474716E+00, 4.9092296091E+00, 2.2194048552E+00, 8.9360870522E-01],
	[2.7240000000E+04, 1.8105210541E+01, 5.2185144742E+00, 4.9121535887E+00, 2.2200769877E+00, 8.9366085130E-01],
	[2.7245000000E+04, 1.8110575922E+01, 5.2184814832E+00, 4.9150787722E+00, 2.2207490241E+00, 8.9371297237E-01],
	[2.7250000000E+04, 1.8115941909E+01, 5.2184484984E+00, 4.9180051599E+00, 2.2214209642E+00, 8.9376506843E-01],
	[2.7255000000E+04, 1.8121308500E+01, 5.2184155198E+00, 4.9209327521E+00, 2.2220928081E+00, 8.9381713949E-01],
	[2.7260000000E+04, 1.8126675696E+01, 5.2183825476E+00, 4.9238615491E+00, 2.2227645556E+00, 8.9386918556E-01],
	[2.7265000000E+04, 1.8132043497E+01, 5.2183495815E+00, 4.9267915512E+00, 2.2234362067E+00, 8.9392120665E-01],
	[2.7270000000E+04, 1.8137411903E+01, 5.2183166218E+00, 4.9297227585E+00, 2.2241077612E+00, 8.9397320277E-01],
	[2.7275000000E+04, 1.8142780913E+01, 5.2182836683E+00, 4.9326551715E+00, 2.2247792192E+00, 8.9402517393E-01],
	[2.7280000000E+04, 1.8148150529E+01, 5.2182507210E+00, 4.9355887903E+00, 2.2254505805E+00, 8.9407712013E-01],
	[2.7285000000E+04, 1.8153520749E+01, 5.2182177800E+00, 4.9385236153E+00, 2.2261218452E+00, 8.9412904140E-01],
	[2.7290000000E+04, 1.8158891574E+01, 5.2181848452E+00, 4.9414596467E+00, 2.2267930130E+00, 8.9418093772E-01],
	[2.7295000000E+04, 1.8164263003E+01, 5.2181519166E+00, 4.9443968848E+00, 2.2274640840E+00, 8.9423280913E-01],
	[2.7300000000E+04, 1.8169635037E+01, 5.2181189943E+00, 4.9473353298E+00, 2.2281350581E+00, 8.9428465562E-01],
	[2.7305000000E+04, 1.8175007675E+01, 5.2180860783E+00, 4.9502749821E+00, 2.2288059351E+00, 8.9433647720E-01],
	[2.7310000000E+04, 1.8180380918E+01, 5.2180531685E+00, 4.9532158419E+00, 2.2294767152E+00, 8.9438827388E-01],
	[2.7315000000E+04, 1.8185754766E+01, 5.2180202649E+00, 4.9561579095E+00, 2.2301473980E+00, 8.9444004568E-01],
	[2.7320000000E+04, 1.8191129218E+01, 5.2179873675E+00, 4.9591011852E+00, 2.2308179837E+00, 8.9449179259E-01],
	[2.7325000000E+04, 1.8196504274E+01, 5.2179544764E+00, 4.9620456692E+00, 2.2314884721E+00, 8.9454351464E-01],
	[2.7330000000E+04, 1.8201879934E+01, 5.2179215914E+00, 4.9649913618E+00, 2.2321588632E+00, 8.9459521183E-01],
	[2.7335000000E+04, 1.8207256199E+01, 5.2178887127E+00, 4.9679382633E+00, 2.2328291568E+00, 8.9464688416E-01],
	[2.7340000000E+04, 1.8212633068E+01, 5.2178558403E+00, 4.9708863740E+00, 2.2334993530E+00, 8.9469853166E-01],
	[2.7345000000E+04, 1.8218010541E+01, 5.2178229740E+00, 4.9738356941E+00, 2.2341694516E+00, 8.9475015432E-01],
	[2.7350000000E+04, 1.8223388618E+01, 5.2177901140E+00, 4.9767862239E+00, 2.2348394526E+00, 8.9480175216E-01],
	[2.7355000000E+04, 1.8228767300E+01, 5.2177572602E+00, 4.9797379637E+00, 2.2355093559E+00, 8.9485332519E-01],
	[2.7360000000E+04, 1.8234146585E+01, 5.2177244126E+00, 4.9826909138E+00, 2.2361791615E+00, 8.9490487341E-01],
	[2.7365000000E+04, 1.8239526475E+01, 5.2176915712E+00, 4.9856450744E+00, 2.2368488692E+00, 8.9495639683E-01],
	[2.7370000000E+04, 1.8244906968E+01, 5.2176587360E+00, 4.9886004458E+00, 2.2375184790E+00, 8.9500789547E-01],
	[2.7375000000E+04, 1.8250288066E+01, 5.2176259070E+00, 4.9915570283E+00, 2.2381879909E+00, 8.9505936933E-01],
	[2.7380000000E+04, 1.8255669767E+01, 5.2175930842E+00, 4.9945148221E+00, 2.2388574048E+00, 8.9511081843E-01],
	[2.7385000000E+04, 1.8261052072E+01, 5.2175602676E+00, 4.9974738276E+00, 2.2395267205E+00, 8.9516224277E-01],
	[2.7390000000E+04, 1.8266434981E+01, 5.2175274572E+00, 5.0004342698E+00, 2.2401959832E+00, 8.9521364236E-01],
	[2.7395000000E+04, 1.8271818494E+01, 5.2174946530E+00, 5.0033959879E+00, 2.2408651604E+00, 8.9526501721E-01],
	[2.7400000000E+04, 1.8277202610E+01, 5.2174618550E+00, 5.0063589187E+00, 2.2415342392E+00, 8.9531636733E-01],
	[2.7405000000E+04, 1.8282587330E+01, 5.2174290632E+00, 5.0093230626E+00, 2.2422032197E+00, 8.9536769273E-01],
	[2.7410000000E+04, 1.8287972654E+01, 5.2173962776E+00, 5.0122884198E+00, 2.2428721017E+00, 8.9541899341E-01],
	[2.7415000000E+04, 1.8293358581E+01, 5.2173634981E+00, 5.0152549905E+00, 2.2435408852E+00, 8.9547026940E-01],
	[2.7420000000E+04, 1.8298745112E+01, 5.2173307249E+00, 5.0182227752E+00, 2.2442095702E+00, 8.9552152069E-01],
	[2.7425000000E+04, 1.8304132247E+01, 5.2172979578E+00, 5.0211917739E+00, 2.2448781565E+00, 8.9557274730E-01],
	[2.7430000000E+04, 1.8309519984E+01, 5.2172651969E+00, 5.0241619871E+00, 2.2455466440E+00, 8.9562394924E-01],
	[2.7435000000E+04, 1.8314908326E+01, 5.2172324422E+00, 5.0271334150E+00, 2.2462150328E+00, 8.9567512651E-01],
	[2.7440000000E+04, 1.8320297270E+01, 5.2171996936E+00, 5.0301060578E+00, 2.2468833227E+00, 8.9572627913E-01],
	[2.7445000000E+04, 1.8325686818E+01, 5.2171669513E+00, 5.0330799159E+00, 2.2475515137E+00, 8.9577740710E-01],
	[2.7450000000E+04, 1.8331076970E+01, 5.2171342151E+00, 5.0360549895E+00, 2.2482196057E+00, 8.9582851044E-01],
	[2.7455000000E+04, 1.8336467724E+01, 5.2171014850E+00, 5.0390312789E+00, 2.2488875986E+00, 8.9587958915E-01],
	[2.7460000000E+04, 1.8341859082E+01, 5.2170687612E+00, 5.0420087843E+00, 2.2495554924E+00, 8.9593064324E-01],
	[2.7465000000E+04, 1.8347251043E+01, 5.2170360435E+00, 5.0449875061E+00, 2.2502232871E+00, 8.9598167272E-01],
	[2.7470000000E+04, 1.8352643607E+01, 5.2170033319E+00, 5.0479674445E+00, 2.2508909824E+00, 8.9603267761E-01],
	[2.7475000000E+04, 1.8358036774E+01, 5.2169706265E+00, 5.0509485998E+00, 2.2515585785E+00, 8.9608365790E-01],
	[2.7480000000E+04, 1.8363430544E+01, 5.2169379273E+00, 5.0539309722E+00, 2.2522260751E+00, 8.9613461362E-01],
	[2.7485000000E+04, 1.8368824918E+01, 5.2169052342E+00, 5.0569145621E+00, 2.2528934723E+00, 8.9618554476E-01],
	[2.7490000000E+04, 1.8374219894E+01, 5.2168725473E+00, 5.0598993697E+00, 2.2535607699E+00, 8.9623645135E-01],
	[2.7495000000E+04, 1.8379615473E+01, 5.2168398665E+00, 5.0628853953E+00, 2.2542279680E+00, 8.9628733338E-01],
	[2.7500000000E+04, 1.8385011655E+01, 5.2168071919E+00, 5.0658726392E+00, 2.2548950664E+00, 8.9633819088E-01],
	[2.7505000000E+04, 1.8390408440E+01, 5.2167745234E+00, 5.0688611016E+00, 2.2555620650E+00, 8.9638902384E-01],
	[2.7510000000E+04, 1.8395805827E+01, 5.2167418611E+00, 5.0718507828E+00, 2.2562289639E+00, 8.9643983227E-01],
	[2.7515000000E+04, 1.8401203817E+01, 5.2167092049E+00, 5.0748416831E+00, 2.2568957629E+00, 8.9649061620E-01],
	[2.7520000000E+04, 1.8406602410E+01, 5.2166765548E+00, 5.0778338027E+00, 2.2575624620E+00, 8.9654137562E-01],
	[2.7525000000E+04, 1.8412001606E+01, 5.2166439109E+00, 5.0808271421E+00, 2.2582290611E+00, 8.9659211054E-01],
	[2.7530000000E+04, 1.8417401404E+01, 5.2166112731E+00, 5.0838217013E+00, 2.2588955601E+00, 8.9664282098E-01],
	[2.7535000000E+04, 1.8422801805E+01, 5.2165786415E+00, 5.0868174807E+00, 2.2595619590E+00, 8.9669350695E-01],
	[2.7540000000E+04, 1.8428202809E+01, 5.2165460159E+00, 5.0898144806E+00, 2.2602282578E+00, 8.9674416844E-01],
	[2.7545000000E+04, 1.8433604414E+01, 5.2165133965E+00, 5.0928127012E+00, 2.2608944562E+00, 8.9679480549E-01],
	[2.7550000000E+04, 1.8439006623E+01, 5.2164807833E+00, 5.0958121428E+00, 2.2615605543E+00, 8.9684541808E-01],
	[2.7555000000E+04, 1.8444409434E+01, 5.2164481761E+00, 5.0988128057E+00, 2.2622265521E+00, 8.9689600624E-01],
	[2.7560000000E+04, 1.8449812847E+01, 5.2164155751E+00, 5.1018146902E+00, 2.2628924494E+00, 8.9694656997E-01],
	[2.7565000000E+04, 1.8455216862E+01, 5.2163829801E+00, 5.1048177966E+00, 2.2635582461E+00, 8.9699710928E-01],
	[2.7570000000E+04, 1.8460621480E+01, 5.2163503913E+00, 5.1078221250E+00, 2.2642239423E+00, 8.9704762418E-01],
	[2.7575000000E+04, 1.8466026700E+01, 5.2163178087E+00, 5.1108276759E+00, 2.2648895378E+00, 8.9709811469E-01],
	[2.7580000000E+04, 1.8471432522E+01, 5.2162852321E+00, 5.1138344494E+00, 2.2655550327E+00, 8.9714858080E-01],
	[2.7585000000E+04, 1.8476838946E+01, 5.2162526616E+00, 5.1168424458E+00, 2.2662204267E+00, 8.9719902253E-01],
	[2.7590000000E+04, 1.8482245973E+01, 5.2162200972E+00, 5.1198516655E+00, 2.2668857199E+00, 8.9724943990E-01],
	[2.7595000000E+04, 1.8487653601E+01, 5.2161875390E+00, 5.1228621087E+00, 2.2675509121E+00, 8.9729983290E-01],
	[2.7600000000E+04, 1.8493061832E+01, 5.2161549868E+00, 5.1258737756E+00, 2.2682160034E+00, 8.9735020155E-01],
	[2.7605000000E+04, 1.8498470664E+01, 5.2161224408E+00, 5.1288866666E+00, 2.2688809937E+00, 8.9740054586E-01],
	[2.7610000000E+04, 1.8503880099E+01, 5.2160899008E+00, 5.1319007819E+00, 2.2695458828E+00, 8.9745086583E-01],
	[2.7615000000E+04, 1.8509301916E+01, 5.2160592161E+00, 5.1349161218E+00, 2.2702111983E+00, 8.9750116148E-01],
	[2.7620000000E+04, 1.8514734965E+01, 5.2160302041E+00, 5.1379326866E+00, 2.2708768887E+00, 8.9755143282E-01],
	[2.7625000000E+04, 1.8520168624E+01, 5.2160011975E+00, 5.1409504765E+00, 2.2715424787E+00, 8.9760167986E-01],
	[2.7630000000E+04, 1.8525602894E+01, 5.2159721963E+00, 5.1439694918E+00, 2.2722079681E+00, 8.9765190260E-01],
	[2.7635000000E+04, 1.8531037775E+01, 5.2159432006E+00, 5.1469897329E+00, 2.2728733569E+00, 8.9770210106E-01],
	[2.7640000000E+04, 1.8536473267E+01, 5.2159142102E+00, 5.1500111999E+00, 2.2735386449E+00, 8.9775227524E-01],
	[2.7645000000E+04, 1.8541909369E+01, 5.2158852253E+00, 5.1530338931E+00, 2.2742038323E+00, 8.9780242516E-01],
	[2.7650000000E+04, 1.8547346082E+01, 5.2158562458E+00, 5.1560578129E+00, 2.2748689188E+00, 8.9785255082E-01],
	[2.7655000000E+04, 1.8552783406E+01, 5.2158272716E+00, 5.1590829595E+00, 2.2755339044E+00, 8.9790265223E-01],
	[2.7660000000E+04, 1.8558221340E+01, 5.2157983029E+00, 5.1621093331E+00, 2.2761987890E+00, 8.9795272941E-01],
	[2.7665000000E+04, 1.8563659885E+01, 5.2157693395E+00, 5.1651369341E+00, 2.2768635727E+00, 8.9800278237E-01],
	[2.7670000000E+04, 1.8569099040E+01, 5.2157403816E+00, 5.1681657627E+00, 2.2775282553E+00, 8.9805281110E-01],
	[2.7675000000E+04, 1.8574538806E+01, 5.2157114290E+00, 5.1711958193E+00, 2.2781928367E+00, 8.9810281563E-01],
	[2.7680000000E+04, 1.8579979182E+01, 5.2156824819E+00, 5.1742271040E+00, 2.2788573169E+00, 8.9815279596E-01],
	[2.7685000000E+04, 1.8585420169E+01, 5.2156535401E+00, 5.1772596171E+00, 2.2795216959E+00, 8.9820275210E-01],
	[2.7690000000E+04, 1.8590861766E+01, 5.2156246037E+00, 5.1802933590E+00, 2.2801859735E+00, 8.9825268406E-01],
	[2.7695000000E+04, 1.8596303973E+01, 5.2155956727E+00, 5.1833283299E+00, 2.2808501498E+00, 8.9830259185E-01],
	[2.7700000000E+04, 1.8601746790E+01, 5.2155667471E+00, 5.1863645301E+00, 2.2815142245E+00, 8.9835247549E-01],
	[2.7705000000E+04, 1.8607190218E+01, 5.2155378268E+00, 5.1894019598E+00, 2.2821781978E+00, 8.9840233497E-01],
	[2.7710000000E+04, 1.8612634256E+01, 5.2155089120E+00, 5.1924406193E+00, 2.2828420694E+00, 8.9845217032E-01],
	[2.7715000000E+04, 1.8618078904E+01, 5.2154800025E+00, 5.1954805090E+00, 2.2835058395E+00, 8.9850198153E-01],
	[2.7720000000E+04, 1.8623524162E+01, 5.2154510984E+00, 5.1985216290E+00, 2.2841695078E+00, 8.9855176863E-01],
	[2.7725000000E+04, 1.8628970030E+01, 5.2154221996E+00, 5.2015639797E+00, 2.2848330743E+00, 8.9860153161E-01],
	[2.7730000000E+04, 1.8634416509E+01, 5.2153933063E+00, 5.2046075613E+00, 2.2854965390E+00, 8.9865127049E-01],
	[2.7735000000E+04, 1.8639863597E+01, 5.2153644183E+00, 5.2076523742E+00, 2.2861599017E+00, 8.9870098528E-01],
	[2.7740000000E+04, 1.8645311295E+01, 5.2153355356E+00, 5.2106984185E+00, 2.2868231625E+00, 8.9875067599E-01],
	[2.7745000000E+04, 1.8650759603E+01, 5.2153066584E+00, 5.2137456945E+00, 2.2874863213E+00, 8.9880034262E-01],
	[2.7750000000E+04, 1.8656208521E+01, 5.2152777865E+00, 5.2167942027E+00, 2.2881493780E+00, 8.9884998520E-01],
	[2.7755000000E+04, 1.8661658048E+01, 5.2152489199E+00, 5.2198439431E+00, 2.2888123325E+00, 8.9889960372E-01],
	[2.7760000000E+04, 1.8667108186E+01, 5.2152200588E+00, 5.2228949161E+00, 2.2894751849E+00, 8.9894919819E-01],
	[2.7765000000E+04, 1.8672558933E+01, 5.2151912029E+00, 5.2259471219E+00, 2.2901379349E+00, 8.9899876864E-01],
	[2.7770000000E+04, 1.8678010290E+01, 5.2151623525E+00, 5.2290005610E+00, 2.2908005826E+00, 8.9904831506E-01],
	[2.7775000000E+04, 1.8683462256E+01, 5.2151335074E+00, 5.2320552334E+00, 2.2914631279E+00, 8.9909783747E-01],
	[2.7780000000E+04, 1.8688914832E+01, 5.2151046676E+00, 5.2351111395E+00, 2.2921255707E+00, 8.9914733587E-01],
	[2.7785000000E+04, 1.8694368018E+01, 5.2150758332E+00, 5.2381682796E+00, 2.2927879110E+00, 8.9919681028E-01],
	[2.7790000000E+04, 1.8699821813E+01, 5.2150470041E+00, 5.2412266539E+00, 2.2934501487E+00, 8.9924626070E-01],
	[2.7795000000E+04, 1.8705276217E+01, 5.2150181804E+00, 5.2442862627E+00, 2.2941122838E+00, 8.9929568715E-01],
	[2.7800000000E+04, 1.8710731231E+01, 5.2149893620E+00, 5.2473471063E+00, 2.2947743161E+00, 8.9934508963E-01],
	[2.7805000000E+04, 1.8716186854E+01, 5.2149605490E+00, 5.2504091850E+00, 2.2954362457E+00, 8.9939446816E-01],
	[2.7810000000E+04, 1.8721643087E+01, 5.2149317413E+00, 5.2534724991E+00, 2.2960980724E+00, 8.9944382274E-01],
	[2.7815000000E+04, 1.8727099929E+01, 5.2149029390E+00, 5.2565370487E+00, 2.2967597962E+00, 8.9949315338E-01],
	[2.7820000000E+04, 1.8732557380E+01, 5.2148741420E+00, 5.2596028343E+00, 2.2974214171E+00, 8.9954246010E-01],
	[2.7825000000E+04, 1.8738015441E+01, 5.2148453503E+00, 5.2626698560E+00, 2.2980829349E+00, 8.9959174290E-01],
	[2.7830000000E+04, 1.8743474110E+01, 5.2148165639E+00, 5.2657381142E+00, 2.2987443497E+00, 8.9964100180E-01],
	[2.7835000000E+04, 1.8748933389E+01, 5.2147877829E+00, 5.2688076091E+00, 2.2994056613E+00, 8.9969023680E-01],
	[2.7840000000E+04, 1.8754393277E+01, 5.2147590072E+00, 5.2718783410E+00, 2.3000668697E+00, 8.9973944791E-01],
	[2.7845000000E+04, 1.8759853774E+01, 5.2147302368E+00, 5.2749503102E+00, 2.3007279748E+00, 8.9978863515E-01],
	[2.7850000000E+04, 1.8765314880E+01, 5.2147014718E+00, 5.2780235169E+00, 2.3013889766E+00, 8.9983779851E-01],
	[2.7855000000E+04, 1.8770776595E+01, 5.2146727121E+00, 5.2810979615E+00, 2.3020498750E+00, 8.9988693802E-01],
	[2.7860000000E+04, 1.8776238919E+01, 5.2146439577E+00, 5.2841736441E+00, 2.3027106699E+00, 8.9993605368E-01],
	[2.7865000000E+04, 1.8781701852E+01, 5.2146152086E+00, 5.2872505652E+00, 2.3033713614E+00, 8.9998514550E-01],
	[2.7870000000E+04, 1.8787165393E+01, 5.2145864648E+00, 5.2903287249E+00, 2.3040319492E+00, 9.0003421350E-01],
	[2.7875000000E+04, 1.8792629543E+01, 5.2145577264E+00, 5.2934081235E+00, 2.3046924335E+00, 9.0008325767E-01],
	[2.7880000000E+04, 1.8798094303E+01, 5.2145289933E+00, 5.2964887613E+00, 2.3053528140E+00, 9.0013227804E-01],
	[2.7885000000E+04, 1.8803559671E+01, 5.2145002654E+00, 5.2995706386E+00, 2.3060130908E+00, 9.0018127461E-01],
	[2.7890000000E+04, 1.8809025647E+01, 5.2144715429E+00, 5.3026537557E+00, 2.3066732637E+00, 9.0023024739E-01],
	[2.7895000000E+04, 1.8814492232E+01, 5.2144428257E+00, 5.3057381128E+00, 2.3073333328E+00, 9.0027919639E-01],
	[2.7900000000E+04, 1.8819959426E+01, 5.2144141138E+00, 5.3088237103E+00, 2.3079932979E+00, 9.0032812162E-01],
	[2.7905000000E+04, 1.8825427228E+01, 5.2143854072E+00, 5.3119105483E+00, 2.3086531591E+00, 9.0037702309E-01],
	[2.7910000000E+04, 1.8830895639E+01, 5.2143567059E+00, 5.3149986272E+00, 2.3093129161E+00, 9.0042590080E-01],
	[2.7915000000E+04, 1.8836364659E+01, 5.2143280099E+00, 5.3180879472E+00, 2.3099725691E+00, 9.0047475478E-01],
	[2.7920000000E+04, 1.8841834286E+01, 5.2142993192E+00, 5.3211785086E+00, 2.3106321179E+00, 9.0052358503E-01],
	[2.7925000000E+04, 1.8847304523E+01, 5.2142706338E+00, 5.3242703117E+00, 2.3112915624E+00, 9.0057239156E-01],
	[2.7930000000E+04, 1.8852775367E+01, 5.2142419537E+00, 5.3273633568E+00, 2.3119509027E+00, 9.0062117438E-01],
	[2.7935000000E+04, 1.8858246820E+01, 5.2142132789E+00, 5.3304576442E+00, 2.3126101386E+00, 9.0066993350E-01],
	[2.7940000000E+04, 1.8863718881E+01, 5.2141846093E+00, 5.3335531740E+00, 2.3132692700E+00, 9.0071866892E-01],
	[2.7945000000E+04, 1.8869191550E+01, 5.2141559451E+00, 5.3366499467E+00, 2.3139282970E+00, 9.0076738067E-01],
	[2.7950000000E+04, 1.8874664828E+01, 5.2141272861E+00, 5.3397479624E+00, 2.3145872195E+00, 9.0081606874E-01],
	[2.7955000000E+04, 1.8880138713E+01, 5.2140986324E+00, 5.3428472215E+00, 2.3152460373E+00, 9.0086473316E-01],
	[2.7960000000E+04, 1.8885613207E+01, 5.2140699841E+00, 5.3459477242E+00, 2.3159047505E+00, 9.0091337392E-01],
	[2.7965000000E+04, 1.8891088309E+01, 5.2140413409E+00, 5.3490494708E+00, 2.3165633590E+00, 9.0096199104E-01],
	[2.7970000000E+04, 1.8896564019E+01, 5.2140127031E+00, 5.3521524616E+00, 2.3172218627E+00, 9.0101058453E-01],
	[2.7975000000E+04, 1.8902040337E+01, 5.2139840705E+00, 5.3552566968E+00, 2.3178802616E+00, 9.0105915439E-01],
	[2.7980000000E+04, 1.8907517262E+01, 5.2139554433E+00, 5.3583621768E+00, 2.3185385555E+00, 9.0110770065E-01],
	[2.7985000000E+04, 1.8912994796E+01, 5.2139268212E+00, 5.3614689018E+00, 2.3191967446E+00, 9.0115622330E-01],
	[2.7990000000E+04, 1.8918472938E+01, 5.2138982045E+00, 5.3645768720E+00, 2.3198548286E+00, 9.0120472236E-01],
	[2.7995000000E+04, 1.8923951687E+01, 5.2138695930E+00, 5.3676860879E+00, 2.3205128075E+00, 9.0125319784E-01],
	[2.8000000000E+04, 1.8929431044E+01, 5.2138409868E+00, 5.3707965495E+00, 2.3211706813E+00, 9.0130164974E-01],
	[2.8005000000E+04, 1.8934911009E+01, 5.2138123859E+00, 5.3739082573E+00, 2.3218284499E+00, 9.0135007808E-01],
	[2.8010000000E+04, 1.8940391581E+01, 5.2137837902E+00, 5.3770212114E+00, 2.3224861133E+00, 9.0139848287E-01],
	[2.8015000000E+04, 1.8945872761E+01, 5.2137551998E+00, 5.3801354123E+00, 2.3231436714E+00, 9.0144686412E-01],
	[2.8020000000E+04, 1.8951354549E+01, 5.2137266146E+00, 5.3832508600E+00, 2.3238011241E+00, 9.0149522184E-01],
	[2.8025000000E+04, 1.8956836945E+01, 5.2136980347E+00, 5.3863675550E+00, 2.3244584713E+00, 9.0154355603E-01],
	[2.8030000000E+04, 1.8962319947E+01, 5.2136694601E+00, 5.3894854975E+00, 2.3251157131E+00, 9.0159186670E-01],
	[2.8035000000E+04, 1.8967803558E+01, 5.2136408907E+00, 5.3926046877E+00, 2.3257728494E+00, 9.0164015388E-01],
	[2.8040000000E+04, 1.8973287776E+01, 5.2136123265E+00, 5.3957251260E+00, 2.3264298801E+00, 9.0168841756E-01],
	[2.8045000000E+04, 1.8978772601E+01, 5.2135837676E+00, 5.3988468126E+00, 2.3270868051E+00, 9.0173665776E-01],
	[2.8050000000E+04, 1.8984258033E+01, 5.2135552140E+00, 5.4019697478E+00, 2.3277436244E+00, 9.0178487448E-01],
	[2.8055000000E+04, 1.8989744073E+01, 5.2135266656E+00, 5.4050939319E+00, 2.3284003379E+00, 9.0183306774E-01],
	[2.8060000000E+04, 1.8995244587E+01, 5.2135002704E+00, 5.4082193651E+00, 2.3290575827E+00, 9.0188123755E-01],
	[2.8065000000E+04, 1.9000754158E+01, 5.2134751877E+00, 5.4113460478E+00, 2.3297151102E+00, 9.0192938392E-01],
	[2.8070000000E+04, 1.9006264346E+01, 5.2134501095E+00, 5.4144739802E+00, 2.3303725326E+00, 9.0197750685E-01],
	[2.8075000000E+04, 1.9011775149E+01, 5.2134250360E+00, 5.4176031625E+00, 2.3310298497E+00, 9.0202560635E-01],
	[2.8080000000E+04, 1.9017286569E+01, 5.2133999670E+00, 5.4207335951E+00, 2.3316870615E+00, 9.0207368245E-01],
	[2.8085000000E+04, 1.9022798604E+01, 5.2133749026E+00, 5.4238652783E+00, 2.3323441681E+00, 9.0212173514E-01],
	[2.8090000000E+04, 1.9028311256E+01, 5.2133498428E+00, 5.4269982122E+00, 2.3330011692E+00, 9.0216976443E-01],
	[2.8095000000E+04, 1.9033824523E+01, 5.2133247876E+00, 5.4301323973E+00, 2.3336580649E+00, 9.0221777034E-01],
	[2.8100000000E+04, 1.9039338407E+01, 5.2132997370E+00, 5.4332678337E+00, 2.3343148551E+00, 9.0226575288E-01],
	[2.8105000000E+04, 1.9044852906E+01, 5.2132746909E+00, 5.4364045217E+00, 2.3349715397E+00, 9.0231371205E-01],
	[2.8110000000E+04, 1.9050368021E+01, 5.2132496494E+00, 5.4395424617E+00, 2.3356281187E+00, 9.0236164787E-01],
	[2.8115000000E+04, 1.9055883751E+01, 5.2132246125E+00, 5.4426816539E+00, 2.3362845920E+00, 9.0240956034E-01],
	[2.8120000000E+04, 1.9061400098E+01, 5.2131995802E+00, 5.4458220985E+00, 2.3369409596E+00, 9.0245744948E-01],
	[2.8125000000E+04, 1.9066917060E+01, 5.2131745524E+00, 5.4489637959E+00, 2.3375972214E+00, 9.0250531530E-01],
	[2.8130000000E+04, 1.9072434638E+01, 5.2131495292E+00, 5.4521067463E+00, 2.3382533774E+00, 9.0255315780E-01],
	[2.8135000000E+04, 1.9077952831E+01, 5.2131245106E+00, 5.4552509500E+00, 2.3389094274E+00, 9.0260097700E-01],
	[2.8140000000E+04, 1.9083471640E+01, 5.2130994965E+00, 5.4583964072E+00, 2.3395653715E+00, 9.0264877290E-01],
	[2.8145000000E+04, 1.9088991065E+01, 5.2130744870E+00, 5.4615431184E+00, 2.3402212096E+00, 9.0269654552E-01],
	[2.8150000000E+04, 1.9094511105E+01, 5.2130494821E+00, 5.4646910836E+00, 2.3408769416E+00, 9.0274429487E-01],
	[2.8155000000E+04, 1.9100031760E+01, 5.2130244817E+00, 5.4678403033E+00, 2.3415325675E+00, 9.0279202095E-01],
	[2.8160000000E+04, 1.9105553031E+01, 5.2129994859E+00, 5.4709907776E+00, 2.3421880872E+00, 9.0283972377E-01],
	[2.8165000000E+04, 1.9111074917E+01, 5.2129744946E+00, 5.4741425070E+00, 2.3428435006E+00, 9.0288740335E-01],
	[2.8170000000E+04, 1.9116597419E+01, 5.2129495079E+00, 5.4772954915E+00, 2.3434988077E+00, 9.0293505969E-01],
	[2.8175000000E+04, 1.9122120536E+01, 5.2129245257E+00, 5.4804497316E+00, 2.3441540085E+00, 9.0298269281E-01],
	[2.8180000000E+04, 1.9127644268E+01, 5.2128995481E+00, 5.4836052274E+00, 2.3448091029E+00, 9.0303030271E-01],
	[2.8185000000E+04, 1.9133168615E+01, 5.2128745751E+00, 5.4867619793E+00, 2.3454640908E+00, 9.0307788940E-01],
	[2.8190000000E+04, 1.9138693578E+01, 5.2128496066E+00, 5.4899199876E+00, 2.3461189721E+00, 9.0312545289E-01],
	[2.8195000000E+04, 1.9144219155E+01, 5.2128246427E+00, 5.4930792525E+00, 2.3467737469E+00, 9.0317299319E-01],
	[2.8200000000E+04, 1.9149745348E+01, 5.2127996832E+00, 5.4962397742E+00, 2.3474284151E+00, 9.0322051030E-01],
	[2.8205000000E+04, 1.9155272156E+01, 5.2127747284E+00, 5.4994015532E+00, 2.3480829766E+00, 9.0326800424E-01],
	[2.8210000000E+04, 1.9160799578E+01, 5.2127497781E+00, 5.5025645896E+00, 2.3487374313E+00, 9.0331547502E-01],
	[2.8215000000E+04, 1.9166327616E+01, 5.2127248323E+00, 5.5057288837E+00, 2.3493917792E+00, 9.0336292264E-01],
	[2.8220000000E+04, 1.9171856268E+01, 5.2126998911E+00, 5.5088944359E+00, 2.3500460202E+00, 9.0341034712E-01],
	[2.8225000000E+04, 1.9177385536E+01, 5.2126749544E+00, 5.5120612463E+00, 2.3507001544E+00, 9.0345774846E-01],
	[2.8230000000E+04, 1.9182915418E+01, 5.2126500222E+00, 5.5152293153E+00, 2.3513541815E+00, 9.0350512667E-01],
	[2.8235000000E+04, 1.9188445915E+01, 5.2126250946E+00, 5.5183986431E+00, 2.3520081017E+00, 9.0355248176E-01],
	[2.8240000000E+04, 1.9193977027E+01, 5.2126001715E+00, 5.5215692300E+00, 2.3526619148E+00, 9.0359981374E-01],
	[2.8245000000E+04, 1.9199508753E+01, 5.2125752529E+00, 5.5247410763E+00, 2.3533156207E+00, 9.0364712262E-01],
	[2.8250000000E+04, 1.9205041095E+01, 5.2125503389E+00, 5.5279141823E+00, 2.3539692194E+00, 9.0369440841E-01],
	[2.8255000000E+04, 1.9210574050E+01, 5.2125254294E+00, 5.5310885482E+00, 2.3546227109E+00, 9.0374167111E-01],
	[2.8260000000E+04, 1.9216107621E+01, 5.2125005244E+00, 5.5342641743E+00, 2.3552760951E+00, 9.0378891074E-01],
	[2.8265000000E+04, 1.9221641806E+01, 5.2124756239E+00, 5.5374410609E+00, 2.3559293719E+00, 9.0383612731E-01],
	[2.8270000000E+04, 1.9227176605E+01, 5.2124507280E+00, 5.5406192084E+00, 2.3565825413E+00, 9.0388332082E-01],
	[2.8275000000E+04, 1.9232712019E+01, 5.2124258366E+00, 5.5437986168E+00, 2.3572356033E+00, 9.0393049128E-01],
	[2.8280000000E+04, 1.9238248048E+01, 5.2124009497E+00, 5.5469792866E+00, 2.3578885577E+00, 9.0397763871E-01],
	[2.8285000000E+04, 1.9243784690E+01, 5.2123760674E+00, 5.5501612180E+00, 2.3585414046E+00, 9.0402476311E-01],
	[2.8290000000E+04, 1.9249321948E+01, 5.2123511895E+00, 5.5533444112E+00, 2.3591941438E+00, 9.0407186448E-01],
	[2.8295000000E+04, 1.9254859819E+01, 5.2123263162E+00, 5.5565288667E+00, 2.3598467753E+00, 9.0411894285E-01],
	[2.8300000000E+04, 1.9260398305E+01, 5.2123014473E+00, 5.5597145845E+00, 2.3604992991E+00, 9.0416599822E-01],
	[2.8305000000E+04, 1.9265937405E+01, 5.2122765830E+00, 5.5629015651E+00, 2.3611517152E+00, 9.0421303059E-01],
	[2.8310000000E+04, 1.9271477119E+01, 5.2122517232E+00, 5.5660898087E+00, 2.3618040233E+00, 9.0426003998E-01],
	[2.8315000000E+04, 1.9277017447E+01, 5.2122268679E+00, 5.5692793155E+00, 2.3624562236E+00, 9.0430702640E-01],
	[2.8320000000E+04, 1.9282558389E+01, 5.2122020172E+00, 5.5724700859E+00, 2.3631083159E+00, 9.0435398985E-01],
	[2.8325000000E+04, 1.9288099946E+01, 5.2121771709E+00, 5.5756621201E+00, 2.3637603002E+00, 9.0440093035E-01],
	[2.8330000000E+04, 1.9293642116E+01, 5.2121523291E+00, 5.5788554184E+00, 2.3644121764E+00, 9.0444784790E-01],
	[2.8335000000E+04, 1.9299184901E+01, 5.2121274918E+00, 5.5820499810E+00, 2.3650639445E+00, 9.0449474251E-01],
	[2.8340000000E+04, 1.9304728299E+01, 5.2121026591E+00, 5.5852458083E+00, 2.3657156045E+00, 9.0454161420E-01],
	[2.8345000000E+04, 1.9310272311E+01, 5.2120778308E+00, 5.5884429006E+00, 2.3663671562E+00, 9.0458846297E-01],
	[2.8350000000E+04, 1.9315816938E+01, 5.2120530070E+00, 5.5916412580E+00, 2.3670185997E+00, 9.0463528882E-01],
	[2.8355000000E+04, 1.9321362178E+01, 5.2120281877E+00, 5.5948408810E+00, 2.3676699348E+00, 9.0468209178E-01],
	[2.8360000000E+04, 1.9326908031E+01, 5.2120033729E+00, 5.5980417696E+00, 2.3683211615E+00, 9.0472887184E-01],
	[2.8365000000E+04, 1.9332454499E+01, 5.2119785626E+00, 5.6012439244E+00, 2.3689722798E+00, 9.0477562902E-01],
	[2.8370000000E+04, 1.9338001580E+01, 5.2119537568E+00, 5.6044473454E+00, 2.3696232896E+00, 9.0482236333E-01],
	[2.8375000000E+04, 1.9343549275E+01, 5.2119289555E+00, 5.6076520331E+00, 2.3702741909E+00, 9.0486907477E-01],
	[2.8380000000E+04, 1.9349097583E+01, 5.2119041587E+00, 5.6108579876E+00, 2.3709249835E+00, 9.0491576336E-01],
	[2.8385000000E+04, 1.9354646506E+01, 5.2118793664E+00, 5.6140652092E+00, 2.3715756675E+00, 9.0496242910E-01],
	[2.8390000000E+04, 1.9360196041E+01, 5.2118545785E+00, 5.6172736983E+00, 2.3722262428E+00, 9.0500907201E-01],
	[2.8395000000E+04, 1.9365746190E+01, 5.2118297951E+00, 5.6204834551E+00, 2.3728767094E+00, 9.0505569209E-01],
	[2.8400000000E+04, 1.9371296953E+01, 5.2118050163E+00, 5.6236944798E+00, 2.3735270671E+00, 9.0510228935E-01],
	[2.8405000000E+04, 1.9376848329E+01, 5.2117802418E+00, 5.6269067728E+00, 2.3741773160E+00, 9.0514886380E-01],
	[2.8410000000E+04, 1.9382400318E+01, 5.2117554719E+00, 5.6301203343E+00, 2.3748274560E+00, 9.0519541545E-01],
	[2.8415000000E+04, 1.9387952921E+01, 5.2117307065E+00, 5.6333351647E+00, 2.3754774870E+00, 9.0524194431E-01],
	[2.8420000000E+04, 1.9393506137E+01, 5.2117059455E+00, 5.6365512641E+00, 2.3761274089E+00, 9.0528845039E-01],
	[2.8425000000E+04, 1.9399059966E+01, 5.2116811890E+00, 5.6397686329E+00, 2.3767772218E+00, 9.0533493370E-01],
	[2.8430000000E+04, 1.9404614409E+01, 5.2116564369E+00, 5.6429872714E+00, 2.3774269256E+00, 9.0538139425E-01],
	[2.8435000000E+04, 1.9410169465E+01, 5.2116316894E+00, 5.6462071797E+00, 2.3780765202E+00, 9.0542783204E-01],
	[2.8440000000E+04, 1.9415725134E+01, 5.2116069463E+00, 5.6494283583E+00, 2.3787260056E+00, 9.0547424709E-01],
	[2.8445000000E+04, 1.9421281416E+01, 5.2115822077E+00, 5.6526508073E+00, 2.3793753817E+00, 9.0552063940E-01],
	[2.8450000000E+04, 1.9426838311E+01, 5.2115574735E+00, 5.6558745271E+00, 2.3800246484E+00, 9.0556700898E-01],
	[2.8455000000E+04, 1.9432395819E+01, 5.2115327438E+00, 5.6590995179E+00, 2.3806738058E+00, 9.0561335585E-01],
	[2.8460000000E+04, 1.9437953940E+01, 5.2115080186E+00, 5.6623257800E+00, 2.3813228537E+00, 9.0565968001E-01],
	[2.8465000000E+04, 1.9443512674E+01, 5.2114832978E+00, 5.6655533137E+00, 2.3819717922E+00, 9.0570598148E-01],
	[2.8470000000E+04, 1.9449072020E+01, 5.2114585815E+00, 5.6687821192E+00, 2.3826206211E+00, 9.0575226025E-01],
	[2.8475000000E+04, 1.9454631980E+01, 5.2114338696E+00, 5.6720121969E+00, 2.3832693404E+00, 9.0579851635E-01],
	[2.8480000000E+04, 1.9460192553E+01, 5.2114091622E+00, 5.6752435470E+00, 2.3839179500E+00, 9.0584474977E-01],
	[2.8485000000E+04, 1.9465753738E+01, 5.2113844593E+00, 5.6784761698E+00, 2.3845664500E+00, 9.0589096053E-01],
	[2.8490000000E+04, 1.9471315536E+01, 5.2113597608E+00, 5.6817100656E+00, 2.3852148402E+00, 9.0593714864E-01],
	[2.8495000000E+04, 1.9476877947E+01, 5.2113350667E+00, 5.6849452346E+00, 2.3858631206E+00, 9.0598331411E-01],
	[2.8500000000E+04, 1.9482440970E+01, 5.2113103771E+00, 5.6881816772E+00, 2.3865112912E+00, 9.0602945695E-01],
	[2.8505000000E+04, 1.9488004606E+01, 5.2112856920E+00, 5.6914193935E+00, 2.3871593518E+00, 9.0607557716E-01],
	[2.8510000000E+04, 1.9493575208E+01, 5.2112619827E+00, 5.6946583839E+00, 2.3878076018E+00, 9.0612167475E-01],
	[2.8515000000E+04, 1.9499162287E+01, 5.2112407026E+00, 5.6978986487E+00, 2.3884564894E+00, 9.0616774975E-01],
	[2.8520000000E+04, 1.9504749987E+01, 5.2112194262E+00, 5.7011401881E+00, 2.3891052677E+00, 9.0621380214E-01],
	[2.8525000000E+04, 1.9510338309E+01, 5.2111981537E+00, 5.7043830024E+00, 2.3897539366E+00, 9.0625983195E-01],
	[2.8530000000E+04, 1.9515927252E+01, 5.2111768850E+00, 5.7076270920E+00, 2.3904024962E+00, 9.0630583918E-01],
	[2.8535000000E+04, 1.9521516816E+01, 5.2111556202E+00, 5.7108724569E+00, 2.3910509463E+00, 9.0635182384E-01],
	[2.8540000000E+04, 1.9527107001E+01, 5.2111343591E+00, 5.7141190977E+00, 2.3916992870E+00, 9.0639778594E-01],
	[2.8545000000E+04, 1.9532697807E+01, 5.2111131018E+00, 5.7173670144E+00, 2.3923475180E+00, 9.0644372550E-01],
	[2.8550000000E+04, 1.9538289235E+01, 5.2110918484E+00, 5.7206162075E+00, 2.3929956395E+00, 9.0648964251E-01],
	[2.8555000000E+04, 1.9543881283E+01, 5.2110705987E+00, 5.7238666771E+00, 2.3936436514E+00, 9.0653553699E-01],
	[2.8560000000E+04, 1.9549473953E+01, 5.2110493529E+00, 5.7271184236E+00, 2.3942915536E+00, 9.0658140895E-01],
	[2.8565000000E+04, 1.9555067243E+01, 5.2110281109E+00, 5.7303714472E+00, 2.3949393460E+00, 9.0662725840E-01],
	[2.8570000000E+04, 1.9560661154E+01, 5.2110068726E+00, 5.7336257482E+00, 2.3955870286E+00, 9.0667308534E-01],
	[2.8575000000E+04, 1.9566255687E+01, 5.2109856382E+00, 5.7368813269E+00, 2.3962346014E+00, 9.0671888980E-01],
	[2.8580000000E+04, 1.9571850840E+01, 5.2109644076E+00, 5.7401381836E+00, 2.3968820642E+00, 9.0676467176E-01],
	[2.8585000000E+04, 1.9577446613E+01, 5.2109431808E+00, 5.7433963186E+00, 2.3975294172E+00, 9.0681043125E-01],
	[2.8590000000E+04, 1.9583043008E+01, 5.2109219578E+00, 5.7466557320E+00, 2.3981766601E+00, 9.0685616828E-01],
	[2.8595000000E+04, 1.9588640023E+01, 5.2109007385E+00, 5.7499164242E+00, 2.3988237930E+00, 9.0690188285E-01],
	[2.8600000000E+04, 1.9594237659E+01, 5.2108795231E+00, 5.7531783956E+00, 2.3994708158E+00, 9.0694757497E-01],
	[2.8605000000E+04, 1.9599835916E+01, 5.2108583115E+00, 5.7564416462E+00, 2.4001177285E+00, 9.0699324466E-01],
	[2.8610000000E+04, 1.9605434793E+01, 5.2108371037E+00, 5.7597061766E+00, 2.4007645309E+00, 9.0703889192E-01],
	[2.8615000000E+04, 1.9611034291E+01, 5.2108158996E+00, 5.7629719868E+00, 2.4014112231E+00, 9.0708451676E-01],
	[2.8620000000E+04, 1.9616634409E+01, 5.2107946994E+00, 5.7662390772E+00, 2.4020578050E+00, 9.0713011919E-01],
	[2.8625000000E+04, 1.9622235148E+01, 5.2107735029E+00, 5.7695074481E+00, 2.4027042766E+00, 9.0717569922E-01],
	[2.8630000000E+04, 1.9627836507E+01, 5.2107523102E+00, 5.7727770997E+00, 2.4033506378E+00, 9.0722125685E-01],
	[2.8635000000E+04, 1.9633438486E+01, 5.2107311213E+00, 5.7760480323E+00, 2.4039968885E+00, 9.0726679211E-01],
	[2.8640000000E+04, 1.9639041086E+01, 5.2107099362E+00, 5.7793202462E+00, 2.4046430287E+00, 9.0731230500E-01],
	[2.8645000000E+04, 1.9644644306E+01, 5.2106887549E+00, 5.7825937418E+00, 2.4052890584E+00, 9.0735779552E-01],
	[2.8650000000E+04, 1.9650248147E+01, 5.2106675774E+00, 5.7858685191E+00, 2.4059349775E+00, 9.0740326369E-01],
	[2.8655000000E+04, 1.9655852608E+01, 5.2106464036E+00, 5.7891445786E+00, 2.4065807860E+00, 9.0744870952E-01],
	[2.8660000000E+04, 1.9661457689E+01, 5.2106252336E+00, 5.7924219205E+00, 2.4072264838E+00, 9.0749413301E-01],
	[2.8665000000E+04, 1.9667063390E+01, 5.2106040674E+00, 5.7957005451E+00, 2.4078720708E+00, 9.0753953417E-01],
	[2.8670000000E+04, 1.9672669711E+01, 5.2105829050E+00, 5.7989804527E+00, 2.4085175470E+00, 9.0758491303E-01],
	[2.8675000000E+04, 1.9678276652E+01, 5.2105617464E+00, 5.8022616435E+00, 2.4091629124E+00, 9.0763026957E-01],
	[2.8680000000E+04, 1.9683884214E+01, 5.2105405915E+00, 5.8055441178E+00, 2.4098081670E+00, 9.0767560382E-01],
	[2.8685000000E+04, 1.9689492395E+01, 5.2105194404E+00, 5.8088278759E+00, 2.4104533105E+00, 9.0772091578E-01],
	[2.8690000000E+04, 1.9695101196E+01, 5.2104982931E+00, 5.8121129181E+00, 2.4110983431E+00, 9.0776620546E-01],
	[2.8695000000E+04, 1.9700710618E+01, 5.2104771496E+00, 5.8153992447E+00, 2.4117432647E+00, 9.0781147288E-01],
	[2.8700000000E+04, 1.9706320659E+01, 5.2104560098E+00, 5.8186868559E+00, 2.4123880752E+00, 9.0785671804E-01],
	[2.8705000000E+04, 1.9711931320E+01, 5.2104348738E+00, 5.8219757520E+00, 2.4130327745E+00, 9.0790194094E-01],
	[2.8710000000E+04, 1.9717542600E+01, 5.2104137415E+00, 5.8252659333E+00, 2.4136773627E+00, 9.0794714161E-01],
	[2.8715000000E+04, 1.9723154501E+01, 5.2103926131E+00, 5.8285574000E+00, 2.4143218397E+00, 9.0799232004E-01],
	[2.8720000000E+04, 1.9728767021E+01, 5.2103714883E+00, 5.8318501525E+00, 2.4149662053E+00, 9.0803747626E-01],
	[2.8725000000E+04, 1.9734380161E+01, 5.2103503674E+00, 5.8351441911E+00, 2.4156104597E+00, 9.0808261026E-01],
	[2.8730000000E+04, 1.9739993921E+01, 5.2103292502E+00, 5.8384395159E+00, 2.4162546027E+00, 9.0812772206E-01],
	[2.8735000000E+04, 1.9745608300E+01, 5.2103081368E+00, 5.8417361273E+00, 2.4168986342E+00, 9.0817281167E-01],
	[2.8740000000E+04, 1.9751223299E+01, 5.2102870271E+00, 5.8450340256E+00, 2.4175425543E+00, 9.0821787909E-01],
	[2.8745000000E+04, 1.9756838917E+01, 5.2102659212E+00, 5.8483332110E+00, 2.4181863629E+00, 9.0826292434E-01],
	[2.8750000000E+04, 1.9762455155E+01, 5.2102448190E+00, 5.8516336838E+00, 2.4188300599E+00, 9.0830794743E-01],
	[2.8755000000E+04, 1.9768072012E+01, 5.2102237206E+00, 5.8549354443E+00, 2.4194736453E+00, 9.0835294836E-01],
	[2.8760000000E+04, 1.9773689488E+01, 5.2102026260E+00, 5.8582384928E+00, 2.4201171191E+00, 9.0839792714E-01],
	[2.8765000000E+04, 1.9779307584E+01, 5.2101815351E+00, 5.8615428295E+00, 2.4207604811E+00, 9.0844288379E-01],
	[2.8770000000E+04, 1.9784926300E+01, 5.2101604479E+00, 5.8648484547E+00, 2.4214037314E+00, 9.0848781831E-01],
	[2.8775000000E+04, 1.9790545634E+01, 5.2101393646E+00, 5.8681553688E+00, 2.4220468699E+00, 9.0853273071E-01],
	[2.8780000000E+04, 1.9796165588E+01, 5.2101182849E+00, 5.8714635719E+00, 2.4226898965E+00, 9.0857762101E-01],
	[2.8785000000E+04, 1.9801786161E+01, 5.2100972090E+00, 5.8747730644E+00, 2.4233328113E+00, 9.0862248921E-01],
	[2.8790000000E+04, 1.9807407354E+01, 5.2100761369E+00, 5.8780838465E+00, 2.4239756141E+00, 9.0866733532E-01],
	[2.8795000000E+04, 1.9813029165E+01, 5.2100550684E+00, 5.8813959186E+00, 2.4246183049E+00, 9.0871215935E-01],
	[2.8800000000E+04, 1.9818651595E+01, 5.2100340038E+00, 5.8847092808E+00, 2.4252608837E+00, 9.0875696131E-01],
	[2.8805000000E+04, 1.9824274645E+01, 5.2100129429E+00, 5.8880239335E+00, 2.4259033504E+00, 9.0880174121E-01],
	[2.8810000000E+04, 1.9829898314E+01, 5.2099918857E+00, 5.8913398770E+00, 2.4265457049E+00, 9.0884649906E-01],
	[2.8815000000E+04, 1.9835522601E+01, 5.2099708322E+00, 5.8946571115E+00, 2.4271879473E+00, 9.0889123487E-01],
	[2.8820000000E+04, 1.9841147507E+01, 5.2099497825E+00, 5.8979756373E+00, 2.4278300775E+00, 9.0893594864E-01],
	[2.8825000000E+04, 1.9846773033E+01, 5.2099287366E+00, 5.9012954547E+00, 2.4284720954E+00, 9.0898064040E-01],
	[2.8830000000E+04, 1.9852399177E+01, 5.2099076943E+00, 5.9046165639E+00, 2.4291140009E+00, 9.0902531014E-01],
	[2.8835000000E+04, 1.9858025940E+01, 5.2098866558E+00, 5.9079389653E+00, 2.4297557941E+00, 9.0906995787E-01],
	[2.8840000000E+04, 1.9863653322E+01, 5.2098656211E+00, 5.9112626591E+00, 2.4303974749E+00, 9.0911458362E-01],
	[2.8845000000E+04, 1.9869281322E+01, 5.2098445900E+00, 5.9145876456E+00, 2.4310390433E+00, 9.0915918738E-01],
	[2.8850000000E+04, 1.9874909942E+01, 5.2098235627E+00, 5.9179139251E+00, 2.4316804991E+00, 9.0920376916E-01],
	[2.8855000000E+04, 1.9880539180E+01, 5.2098025392E+00, 5.9212414978E+00, 2.4323218424E+00, 9.0924832898E-01],
	[2.8860000000E+04, 1.9886169036E+01, 5.2097815193E+00, 5.9245703641E+00, 2.4329630731E+00, 9.0929286684E-01],
	[2.8865000000E+04, 1.9891799511E+01, 5.2097605032E+00, 5.9279005242E+00, 2.4336041911E+00, 9.0933738276E-01],
	[2.8870000000E+04, 1.9897430605E+01, 5.2097394908E+00, 5.9312319784E+00, 2.4342451965E+00, 9.0938187674E-01],
	[2.8875000000E+04, 1.9903062317E+01, 5.2097184821E+00, 5.9345647269E+00, 2.4348860891E+00, 9.0942634879E-01],
	[2.8880000000E+04, 1.9908694648E+01, 5.2096974772E+00, 5.9378987701E+00, 2.4355268689E+00, 9.0947079893E-01],
	[2.8885000000E+04, 1.9914327597E+01, 5.2096764759E+00, 5.9412341082E+00, 2.4361675359E+00, 9.0951522716E-01],
	[2.8890000000E+04, 1.9919961164E+01, 5.2096554784E+00, 5.9445707415E+00, 2.4368080901E+00, 9.0955963349E-01],
	[2.8895000000E+04, 1.9925595350E+01, 5.2096344846E+00, 5.9479086703E+00, 2.4374485313E+00, 9.0960401793E-01],
	[2.8900000000E+04, 1.9931230154E+01, 5.2096134945E+00, 5.9512478949E+00, 2.4380888596E+00, 9.0964838049E-01],
	[2.8905000000E+04, 1.9936865577E+01, 5.2095925082E+00, 5.9545884155E+00, 2.4387290748E+00, 9.0969272118E-01],
	[2.8910000000E+04, 1.9942501617E+01, 5.2095715255E+00, 5.9579302324E+00, 2.4393691770E+00, 9.0973704001E-01],
	[2.8915000000E+04, 1.9948138276E+01, 5.2095505466E+00, 5.9612733459E+00, 2.4400091661E+00, 9.0978133699E-01],
	[2.8920000000E+04, 1.9953775553E+01, 5.2095295714E+00, 5.9646177563E+00, 2.4406490420E+00, 9.0982561212E-01],
	[2.8925000000E+04, 1.9959413448E+01, 5.2095085999E+00, 5.9679634638E+00, 2.4412888048E+00, 9.0986986543E-01],
	[2.8930000000E+04, 1.9965051961E+01, 5.2094876321E+00, 5.9713104688E+00, 2.4419284543E+00, 9.0991409691E-01],
	[2.8935000000E+04, 1.9970691092E+01, 5.2094666680E+00, 5.9746587715E+00, 2.4425679906E+00, 9.0995830659E-01],
	[2.8940000000E+04, 1.9976330842E+01, 5.2094457076E+00, 5.9780083721E+00, 2.4432074135E+00, 9.1000249445E-01],
	[2.8945000000E+04, 1.9981971209E+01, 5.2094247509E+00, 5.9813592711E+00, 2.4438467230E+00, 9.1004666053E-01],
	[2.8950000000E+04, 1.9987612194E+01, 5.2094037979E+00, 5.9847114685E+00, 2.4444859191E+00, 9.1009080482E-01],
	[2.8955000000E+04, 1.9993253797E+01, 5.2093828487E+00, 5.9880649648E+00, 2.4451250018E+00, 9.1013492734E-01],
	[2.8960000000E+04, 1.9998896017E+01, 5.2093619031E+00, 5.9914197602E+00, 2.4457639709E+00, 9.1017902809E-01],
	[2.8965000000E+04, 2.0004538856E+01, 5.2093409612E+00, 5.9947758550E+00, 2.4464028266E+00, 9.1022310708E-01],
	[2.8970000000E+04, 2.0010193286E+01, 5.2093216795E+00, 5.9981332495E+00, 2.4470420982E+00, 9.1026716433E-01],
	[2.8975000000E+04, 2.0015859482E+01, 5.2093040829E+00, 6.0014919438E+00, 2.4476817945E+00, 9.1031119985E-01],
	[2.8980000000E+04, 2.0021526304E+01, 5.2092864894E+00, 6.0048519384E+00, 2.4483213778E+00, 9.1035521363E-01],
	[2.8985000000E+04, 2.0027193753E+01, 5.2092688990E+00, 6.0082132335E+00, 2.4489608482E+00, 9.1039920571E-01],
	[2.8990000000E+04, 2.0032861828E+01, 5.2092513117E+00, 6.0115758294E+00, 2.4496002056E+00, 9.1044317607E-01],
	[2.8995000000E+04, 2.0038530529E+01, 5.2092337275E+00, 6.0149397263E+00, 2.4502394498E+00, 9.1048712473E-01],
	[2.9000000000E+04, 2.0044199856E+01, 5.2092161464E+00, 6.0183049245E+00, 2.4508785810E+00, 9.1053105171E-01],
	[2.9005000000E+04, 2.0049869810E+01, 5.2091985684E+00, 6.0216714244E+00, 2.4515175990E+00, 9.1057495701E-01],
	[2.9010000000E+04, 2.0055540390E+01, 5.2091809934E+00, 6.0250392261E+00, 2.4521565039E+00, 9.1061884064E-01],
	[2.9015000000E+04, 2.0061211596E+01, 5.2091634216E+00, 6.0284083300E+00, 2.4527952954E+00, 9.1066270261E-01],
	[2.9020000000E+04, 2.0066883427E+01, 5.2091458528E+00, 6.0317787364E+00, 2.4534339737E+00, 9.1070654293E-01],
	[2.9025000000E+04, 2.0072555885E+01, 5.2091282872E+00, 6.0351504454E+00, 2.4540725386E+00, 9.1075036161E-01],
	[2.9030000000E+04, 2.0078228969E+01, 5.2091107246E+00, 6.0385234575E+00, 2.4547109902E+00, 9.1079415866E-01],
	[2.9035000000E+04, 2.0083902679E+01, 5.2090931651E+00, 6.0418977729E+00, 2.4553493283E+00, 9.1083793409E-01],
	[2.9040000000E+04, 2.0089577015E+01, 5.2090756087E+00, 6.0452733918E+00, 2.4559875530E+00, 9.1088168791E-01],
	[2.9045000000E+04, 2.0095251976E+01, 5.2090580553E+00, 6.0486503146E+00, 2.4566256642E+00, 9.1092542012E-01],
	[2.9050000000E+04, 2.0100927564E+01, 5.2090405051E+00, 6.0520285414E+00, 2.4572636618E+00, 9.1096913074E-01],
	[2.9055000000E+04, 2.0106603777E+01, 5.2090229579E+00, 6.0554080727E+00, 2.4579015458E+00, 9.1101281978E-01],
	[2.9060000000E+04, 2.0112280616E+01, 5.2090054138E+00, 6.0587889086E+00, 2.4585393162E+00, 9.1105648725E-01],
	[2.9065000000E+04, 2.0117958081E+01, 5.2089878728E+00, 6.0621710495E+00, 2.4591769729E+00, 9.1110013316E-01],
	[2.9070000000E+04, 2.0123636171E+01, 5.2089703348E+00, 6.0655544957E+00, 2.4598145158E+00, 9.1114375751E-01],
	[2.9075000000E+04, 2.0129314887E+01, 5.2089527999E+00, 6.0689392473E+00, 2.4604519450E+00, 9.1118736031E-01],
	[2.9080000000E+04, 2.0134994229E+01, 5.2089352681E+00, 6.0723253047E+00, 2.4610892604E+00, 9.1123094158E-01],
	[2.9085000000E+04, 2.0140674196E+01, 5.2089177394E+00, 6.0757126683E+00, 2.4617264619E+00, 9.1127450133E-01],
	[2.9090000000E+04, 2.0146354788E+01, 5.2089002138E+00, 6.0791013381E+00, 2.4623635495E+00, 9.1131803956E-01],
	[2.9095000000E+04, 2.0152036006E+01, 5.2088826912E+00, 6.0824913146E+00, 2.4630005232E+00, 9.1136155629E-01],
	[2.9100000000E+04, 2.0157717850E+01, 5.2088651717E+00, 6.0858825980E+00, 2.4636373829E+00, 9.1140505152E-01],
	[2.9105000000E+04, 2.0163400319E+01, 5.2088476552E+00, 6.0892751885E+00, 2.4642741286E+00, 9.1144852526E-01],
	[2.9110000000E+04, 2.0169083413E+01, 5.2088301419E+00, 6.0926690866E+00, 2.4649107601E+00, 9.1149197752E-01],
	[2.9115000000E+04, 2.0174767133E+01, 5.2088126316E+00, 6.0960642923E+00, 2.4655472776E+00, 9.1153540832E-01],
	[2.9120000000E+04, 2.0180451478E+01, 5.2087951243E+00, 6.0994608061E+00, 2.4661836809E+00, 9.1157881766E-01],
	[2.9125000000E+04, 2.0186136448E+01, 5.2087776201E+00, 6.1028586282E+00, 2.4668199700E+00, 9.1162220556E-01],
	[2.9130000000E+04, 2.0191822043E+01, 5.2087601190E+00, 6.1062577589E+00, 2.4674561449E+00, 9.1166557201E-01],
	[2.9135000000E+04, 2.0197508264E+01, 5.2087426210E+00, 6.1096581984E+00, 2.4680922055E+00, 9.1170891704E-01],
	[2.9140000000E+04, 2.0203195109E+01, 5.2087251260E+00, 6.1130599471E+00, 2.4687281517E+00, 9.1175224065E-01],
	[2.9145000000E+04, 2.0208882580E+01, 5.2087076341E+00, 6.1164630052E+00, 2.4693639836E+00, 9.1179554285E-01],
	[2.9150000000E+04, 2.0214570676E+01, 5.2086901452E+00, 6.1198673729E+00, 2.4699997010E+00, 9.1183882364E-01],
	[2.9155000000E+04, 2.0220259397E+01, 5.2086726594E+00, 6.1232730507E+00, 2.4706353040E+00, 9.1188208305E-01],
	[2.9160000000E+04, 2.0225948743E+01, 5.2086551766E+00, 6.1266800387E+00, 2.4712707926E+00, 9.1192532108E-01],
	[2.9165000000E+04, 2.0231638713E+01, 5.2086376969E+00, 6.1300883372E+00, 2.4719061665E+00, 9.1196853773E-01],
	[2.9170000000E+04, 2.0237329309E+01, 5.2086202203E+00, 6.1334979466E+00, 2.4725414259E+00, 9.1201173302E-01],
	[2.9175000000E+04, 2.0243020529E+01, 5.2086027467E+00, 6.1369088670E+00, 2.4731765707E+00, 9.1205490695E-01],
	[2.9180000000E+04, 2.0248712375E+01, 5.2085852762E+00, 6.1403210988E+00, 2.4738116008E+00, 9.1209805953E-01],
	[2.9185000000E+04, 2.0254404845E+01, 5.2085678087E+00, 6.1437346423E+00, 2.4744465162E+00, 9.1214119078E-01],
	[2.9190000000E+04, 2.0260097940E+01, 5.2085503442E+00, 6.1471494976E+00, 2.4750813168E+00, 9.1218430069E-01],
	[2.9195000000E+04, 2.0265791659E+01, 5.2085328829E+00, 6.1505656652E+00, 2.4757160026E+00, 9.1222738929E-01],
	[2.9200000000E+04, 2.0271486003E+01, 5.2085154245E+00, 6.1539831453E+00, 2.4763505737E+00, 9.1227045657E-01],
	[2.9205000000E+04, 2.0277180972E+01, 5.2084979692E+00, 6.1574019381E+00, 2.4769850298E+00, 9.1231350255E-01],
	[2.9210000000E+04, 2.0282876565E+01, 5.2084805170E+00, 6.1608220440E+00, 2.4776193710E+00, 9.1235652723E-01],
	[2.9215000000E+04, 2.0288572783E+01, 5.2084630678E+00, 6.1642434632E+00, 2.4782535973E+00, 9.1239953063E-01],
	[2.9220000000E+04, 2.0294269626E+01, 5.2084456216E+00, 6.1676661960E+00, 2.4788877086E+00, 9.1244251276E-01],
	[2.9225000000E+04, 2.0299967093E+01, 5.2084281785E+00, 6.1710902427E+00, 2.4795217048E+00, 9.1248547361E-01],
	[2.9230000000E+04, 2.0305665184E+01, 5.2084107385E+00, 6.1745156035E+00, 2.4801555859E+00, 9.1252841321E-01],
	[2.9235000000E+04, 2.0311363900E+01, 5.2083933015E+00, 6.1779422788E+00, 2.4807893520E+00, 9.1257133155E-01],
	[2.9240000000E+04, 2.0317063240E+01, 5.2083758675E+00, 6.1813702688E+00, 2.4814230028E+00, 9.1261422865E-01],
	[2.9245000000E+04, 2.0322763205E+01, 5.2083584365E+00, 6.1847995738E+00, 2.4820565385E+00, 9.1265710452E-01],
	[2.9250000000E+04, 2.0328463793E+01, 5.2083410086E+00, 6.1882301941E+00, 2.4826899589E+00, 9.1269995917E-01],
	[2.9255000000E+04, 2.0334165006E+01, 5.2083235838E+00, 6.1916621299E+00, 2.4833232640E+00, 9.1274279260E-01],
	[2.9260000000E+04, 2.0339866843E+01, 5.2083061619E+00, 6.1950953815E+00, 2.4839564538E+00, 9.1278560483E-01],
	[2.9265000000E+04, 2.0345569305E+01, 5.2082887431E+00, 6.1985299493E+00, 2.4845895283E+00, 9.1282839585E-01],
	[2.9270000000E+04, 2.0351272390E+01, 5.2082713274E+00, 6.2019658335E+00, 2.4852224873E+00, 9.1287116569E-01],
	[2.9275000000E+04, 2.0356976100E+01, 5.2082539146E+00, 6.2054030343E+00, 2.4858553309E+00, 9.1291391435E-01],
	[2.9280000000E+04, 2.0362680433E+01, 5.2082365049E+00, 6.2088415521E+00, 2.4864880589E+00, 9.1295664184E-01],
	[2.9285000000E+04, 2.0368385391E+01, 5.2082190983E+00, 6.2122813872E+00, 2.4871206715E+00, 9.1299934817E-01],
	[2.9290000000E+04, 2.0374090973E+01, 5.2082016946E+00, 6.2157225397E+00, 2.4877531685E+00, 9.1304203334E-01],
	[2.9295000000E+04, 2.0379797178E+01, 5.2081842940E+00, 6.2191650100E+00, 2.4883855498E+00, 9.1308469737E-01],
	[2.9300000000E+04, 2.0385504008E+01, 5.2081668964E+00, 6.2226087984E+00, 2.4890178156E+00, 9.1312734026E-01],
	[2.9305000000E+04, 2.0391211461E+01, 5.2081495019E+00, 6.2260539052E+00, 2.4896499656E+00, 9.1316996203E-01],
	[2.9310000000E+04, 2.0396919538E+01, 5.2081321104E+00, 6.2295003305E+00, 2.4902819999E+00, 9.1321256267E-01],
	[2.9315000000E+04, 2.0402628239E+01, 5.2081147219E+00, 6.2329480748E+00, 2.4909139184E+00, 9.1325514221E-01],
	[2.9320000000E+04, 2.0408337564E+01, 5.2080973364E+00, 6.2363971383E+00, 2.4915457211E+00, 9.1329770065E-01],
	[2.9325000000E+04, 2.0414047512E+01, 5.2080799539E+00, 6.2398475212E+00, 2.4921774080E+00, 9.1334023800E-01],
	[2.9330000000E+04, 2.0419758084E+01, 5.2080625745E+00, 6.2432992239E+00, 2.4928089790E+00, 9.1338275427E-01],
	[2.9335000000E+04, 2.0425469280E+01, 5.2080451981E+00, 6.2467522466E+00, 2.4934404340E+00, 9.1342524946E-01],
	[2.9340000000E+04, 2.0431181099E+01, 5.2080278247E+00, 6.2502065896E+00, 2.4940717731E+00, 9.1346772359E-01],
	[2.9345000000E+04, 2.0436893542E+01, 5.2080104543E+00, 6.2536622532E+00, 2.4947029962E+00, 9.1351017666E-01],
	[2.9350000000E+04, 2.0442606608E+01, 5.2079930869E+00, 6.2571192376E+00, 2.4953341032E+00, 9.1355260869E-01],
	[2.9355000000E+04, 2.0448320298E+01, 5.2079757226E+00, 6.2605775432E+00, 2.4959650941E+00, 9.1359501968E-01],
	[2.9360000000E+04, 2.0454034611E+01, 5.2079583613E+00, 6.2640371702E+00, 2.4965959689E+00, 9.1363740964E-01],
	[2.9365000000E+04, 2.0459749548E+01, 5.2079410029E+00, 6.2674981190E+00, 2.4972267275E+00, 9.1367977858E-01],
	[2.9370000000E+04, 2.0465465108E+01, 5.2079236476E+00, 6.2709603897E+00, 2.4978573700E+00, 9.1372212650E-01],
	[2.9375000000E+04, 2.0471181291E+01, 5.2079062954E+00, 6.2744239826E+00, 2.4984878961E+00, 9.1376445343E-01],
	[2.9380000000E+04, 2.0476898098E+01, 5.2078889461E+00, 6.2778888981E+00, 2.4991183060E+00, 9.1380675936E-01],
	[2.9385000000E+04, 2.0482615528E+01, 5.2078715998E+00, 6.2813551364E+00, 2.4997485996E+00, 9.1384904431E-01],
	[2.9390000000E+04, 2.0488333581E+01, 5.2078542565E+00, 6.2848226979E+00, 2.5003787768E+00, 9.1389130829E-01],
	[2.9395000000E+04, 2.0494052257E+01, 5.2078369163E+00, 6.2882915826E+00, 2.5010088376E+00, 9.1393355129E-01],
	[2.9400000000E+04, 2.0499771557E+01, 5.2078195791E+00, 6.2917617911E+00, 2.5016387819E+00, 9.1397577334E-01],
	[2.9405000000E+04, 2.0505491479E+01, 5.2078022448E+00, 6.2952333235E+00, 2.5022686098E+00, 9.1401797444E-01],
	[2.9410000000E+04, 2.0511212025E+01, 5.2077849136E+00, 6.2987061801E+00, 2.5028983212E+00, 9.1406015460E-01],
	[2.9415000000E+04, 2.0516933193E+01, 5.2077675854E+00, 6.3021803612E+00, 2.5035279160E+00, 9.1410231383E-01],
	[2.9420000000E+04, 2.0522654985E+01, 5.2077502601E+00, 6.3056558671E+00, 2.5041573942E+00, 9.1414445214E-01],
	[2.9425000000E+04, 2.0528377399E+01, 5.2077329379E+00, 6.3091326980E+00, 2.5047867557E+00, 9.1418656954E-01],
	[2.9430000000E+04, 2.0534100437E+01, 5.2077156187E+00, 6.3126108543E+00, 2.5054160006E+00, 9.1422866603E-01],
	[2.9435000000E+04, 2.0539829131E+01, 5.2076990528E+00, 6.3160903362E+00, 2.5060453775E+00, 9.1427074163E-01],
	[2.9440000000E+04, 2.0545575434E+01, 5.2076850207E+00, 6.3195711440E+00, 2.5066754770E+00, 9.1431279634E-01],
	[2.9445000000E+04, 2.0551322368E+01, 5.2076709911E+00, 6.3230532779E+00, 2.5073054605E+00, 9.1435483017E-01],
	[2.9450000000E+04, 2.0557069934E+01, 5.2076569638E+00, 6.3265367383E+00, 2.5079353278E+00, 9.1439684314E-01],
	[2.9455000000E+04, 2.0562818130E+01, 5.2076429390E+00, 6.3300215255E+00, 2.5085650790E+00, 9.1443883525E-01],
	[2.9460000000E+04, 2.0568566958E+01, 5.2076289166E+00, 6.3335076396E+00, 2.5091947140E+00, 9.1448080650E-01],
	[2.9465000000E+04, 2.0574316418E+01, 5.2076148967E+00, 6.3369950811E+00, 2.5098242329E+00, 9.1452275692E-01],
	[2.9470000000E+04, 2.0580066508E+01, 5.2076008791E+00, 6.3404838501E+00, 2.5104536354E+00, 9.1456468650E-01],
	[2.9475000000E+04, 2.0585817230E+01, 5.2075868640E+00, 6.3439739470E+00, 2.5110829217E+00, 9.1460659526E-01],
	[2.9480000000E+04, 2.0591568582E+01, 5.2075728512E+00, 6.3474653720E+00, 2.5117120917E+00, 9.1464848321E-01],
	[2.9485000000E+04, 2.0597320566E+01, 5.2075588409E+00, 6.3509581254E+00, 2.5123411453E+00, 9.1469035035E-01],
	[2.9490000000E+04, 2.0603073181E+01, 5.2075448330E+00, 6.3544522075E+00, 2.5129700825E+00, 9.1473219669E-01],
	[2.9495000000E+04, 2.0608826426E+01, 5.2075308275E+00, 6.3579476186E+00, 2.5135989032E+00, 9.1477402225E-01],
	[2.9500000000E+04, 2.0614580303E+01, 5.2075168245E+00, 6.3614443589E+00, 2.5142276075E+00, 9.1481582703E-01],
	[2.9505000000E+04, 2.0620334810E+01, 5.2075028238E+00, 6.3649424288E+00, 2.5148561952E+00, 9.1485761104E-01],
	[2.9510000000E+04, 2.0626089949E+01, 5.2074888255E+00, 6.3684418284E+00, 2.5154846664E+00, 9.1489937429E-01],
	[2.9515000000E+04, 2.0631845718E+01, 5.2074748297E+00, 6.3719425582E+00, 2.5161130211E+00, 9.1494111679E-01],
	[2.9520000000E+04, 2.0637602118E+01, 5.2074608362E+00, 6.3754446183E+00, 2.5167412590E+00, 9.1498283854E-01],
	[2.9525000000E+04, 2.0643359148E+01, 5.2074468452E+00, 6.3789480091E+00, 2.5173693804E+00, 9.1502453957E-01],
	[2.9530000000E+04, 2.0649116810E+01, 5.2074328566E+00, 6.3824527308E+00, 2.5179973850E+00, 9.1506621987E-01],
	[2.9535000000E+04, 2.0654875102E+01, 5.2074188704E+00, 6.3859587838E+00, 2.5186252728E+00, 9.1510787945E-01],
	[2.9540000000E+04, 2.0660634025E+01, 5.2074048866E+00, 6.3894661682E+00, 2.5192530439E+00, 9.1514951833E-01],
	[2.9545000000E+04, 2.0666393578E+01, 5.2073909052E+00, 6.3929748844E+00, 2.5198806982E+00, 9.1519113651E-01],
	[2.9550000000E+04, 2.0672153762E+01, 5.2073769261E+00, 6.3964849326E+00, 2.5205082357E+00, 9.1523273400E-01],
	[2.9555000000E+04, 2.0677914576E+01, 5.2073629495E+00, 6.3999963132E+00, 2.5211356562E+00, 9.1527431081E-01],
	[2.9560000000E+04, 2.0683676021E+01, 5.2073489753E+00, 6.4035090263E+00, 2.5217629598E+00, 9.1531586695E-01],
	[2.9565000000E+04, 2.0689438096E+01, 5.2073350035E+00, 6.4070230724E+00, 2.5223901465E+00, 9.1535740244E-01],
	[2.9570000000E+04, 2.0695200802E+01, 5.2073210341E+00, 6.4105384516E+00, 2.5230172161E+00, 9.1539891726E-01],
	[2.9575000000E+04, 2.0700964138E+01, 5.2073070671E+00, 6.4140551643E+00, 2.5236441688E+00, 9.1544041145E-01],
	[2.9580000000E+04, 2.0706728104E+01, 5.2072931025E+00, 6.4175732107E+00, 2.5242710043E+00, 9.1548188500E-01],
	[2.9585000000E+04, 2.0712492701E+01, 5.2072791403E+00, 6.4210925911E+00, 2.5248977227E+00, 9.1552333793E-01],
	[2.9590000000E+04, 2.0718257928E+01, 5.2072651805E+00, 6.4246133058E+00, 2.5255243240E+00, 9.1556477024E-01],
	[2.9595000000E+04, 2.0724023785E+01, 5.2072512231E+00, 6.4281353551E+00, 2.5261508081E+00, 9.1560618195E-01],
	[2.9600000000E+04, 2.0729790272E+01, 5.2072372681E+00, 6.4316587392E+00, 2.5267771750E+00, 9.1564757305E-01],
	[2.9605000000E+04, 2.0735557389E+01, 5.2072233155E+00, 6.4351834585E+00, 2.5274034247E+00, 9.1568894357E-01],
	[2.9610000000E+04, 2.0741325137E+01, 5.2072093653E+00, 6.4387095131E+00, 2.5280295570E+00, 9.1573029351E-01],
	[2.9615000000E+04, 2.0747093514E+01, 5.2071954174E+00, 6.4422369035E+00, 2.5286555720E+00, 9.1577162288E-01],
	[2.9620000000E+04, 2.0752862522E+01, 5.2071814720E+00, 6.4457656298E+00, 2.5292814697E+00, 9.1581293168E-01],
	[2.9625000000E+04, 2.0758632160E+01, 5.2071675289E+00, 6.4492956924E+00, 2.5299072499E+00, 9.1585421993E-01],
	[2.9630000000E+04, 2.0764402427E+01, 5.2071535883E+00, 6.4528270915E+00, 2.5305329128E+00, 9.1589548764E-01],
	[2.9635000000E+04, 2.0770173325E+01, 5.2071396500E+00, 6.4563598274E+00, 2.5311584581E+00, 9.1593673482E-01],
	[2.9640000000E+04, 2.0775944852E+01, 5.2071257141E+00, 6.4598939004E+00, 2.5317838859E+00, 9.1597796147E-01],
	[2.9645000000E+04, 2.0781717009E+01, 5.2071117806E+00, 6.4634293108E+00, 2.5324091962E+00, 9.1601916760E-01],
	[2.9650000000E+04, 2.0787489796E+01, 5.2070978495E+00, 6.4669660588E+00, 2.5330343890E+00, 9.1606035323E-01],
	[2.9655000000E+04, 2.0793263213E+01, 5.2070839208E+00, 6.4705041447E+00, 2.5336594641E+00, 9.1610151835E-01],
	[2.9660000000E+04, 2.0799037259E+01, 5.2070699945E+00, 6.4740435689E+00, 2.5342844215E+00, 9.1614266299E-01],
	[2.9665000000E+04, 2.0804811936E+01, 5.2070560705E+00, 6.4775843315E+00, 2.5349092613E+00, 9.1618378715E-01],
	[2.9670000000E+04, 2.0810587241E+01, 5.2070421489E+00, 6.4811264329E+00, 2.5355339833E+00, 9.1622489084E-01],
	[2.9675000000E+04, 2.0816363177E+01, 5.2070282298E+00, 6.4846698734E+00, 2.5361585876E+00, 9.1626597406E-01],
	[2.9680000000E+04, 2.0822139742E+01, 5.2070143130E+00, 6.4882146532E+00, 2.5367830741E+00, 9.1630703684E-01],
	[2.9685000000E+04, 2.0827916936E+01, 5.2070003985E+00, 6.4917607726E+00, 2.5374074427E+00, 9.1634807917E-01],
	[2.9690000000E+04, 2.0833694760E+01, 5.2069864865E+00, 6.4953082319E+00, 2.5380316935E+00, 9.1638910106E-01],
	[2.9695000000E+04, 2.0839473214E+01, 5.2069725768E+00, 6.4988570314E+00, 2.5386558264E+00, 9.1643010253E-01],
	[2.9700000000E+04, 2.0845252297E+01, 5.2069586696E+00, 6.5024071713E+00, 2.5392798414E+00, 9.1647108358E-01],
	[2.9705000000E+04, 2.0851032009E+01, 5.2069447647E+00, 6.5059586519E+00, 2.5399037384E+00, 9.1651204422E-01],
	[2.9710000000E+04, 2.0856812351E+01, 5.2069308621E+00, 6.5095114736E+00, 2.5405275174E+00, 9.1655298447E-01],
	[2.9715000000E+04, 2.0862593322E+01, 5.2069169620E+00, 6.5130656365E+00, 2.5411511784E+00, 9.1659390433E-01],
	[2.9720000000E+04, 2.0868374922E+01, 5.2069030642E+00, 6.5166211411E+00, 2.5417747212E+00, 9.1663480381E-01],
	[2.9725000000E+04, 2.0874157152E+01, 5.2068891688E+00, 6.5201779874E+00, 2.5423981460E+00, 9.1667568291E-01],
	[2.9730000000E+04, 2.0879940010E+01, 5.2068752758E+00, 6.5237361760E+00, 2.5430214527E+00, 9.1671654166E-01],
	[2.9735000000E+04, 2.0885723498E+01, 5.2068613851E+00, 6.5272957069E+00, 2.5436446411E+00, 9.1675738005E-01],
	[2.9740000000E+04, 2.0891507615E+01, 5.2068474969E+00, 6.5308565805E+00, 2.5442677114E+00, 9.1679819810E-01],
	[2.9745000000E+04, 2.0897292361E+01, 5.2068336110E+00, 6.5344187971E+00, 2.5448906634E+00, 9.1683899581E-01],
	[2.9750000000E+04, 2.0903077737E+01, 5.2068197274E+00, 6.5379823569E+00, 2.5455134971E+00, 9.1687977320E-01],
	[2.9755000000E+04, 2.0908863741E+01, 5.2068058463E+00, 6.5415472603E+00, 2.5461362125E+00, 9.1692053027E-01],
	[2.9760000000E+04, 2.0914650374E+01, 5.2067919675E+00, 6.5451135075E+00, 2.5467588095E+00, 9.1696126703E-01],
	[2.9765000000E+04, 2.0920437636E+01, 5.2067780910E+00, 6.5486810988E+00, 2.5473812882E+00, 9.1700198350E-01],
	[2.9770000000E+04, 2.0926225527E+01, 5.2067642170E+00, 6.5522500345E+00, 2.5480036484E+00, 9.1704267967E-01],
	[2.9775000000E+04, 2.0932014047E+01, 5.2067503453E+00, 6.5558203148E+00, 2.5486258902E+00, 9.1708335557E-01],
	[2.9780000000E+04, 2.0937803196E+01, 5.2067364760E+00, 6.5593919400E+00, 2.5492480135E+00, 9.1712401120E-01],
	[2.9785000000E+04, 2.0943592973E+01, 5.2067226090E+00, 6.5629649105E+00, 2.5498700183E+00, 9.1716464656E-01],
	[2.9790000000E+04, 2.0949383379E+01, 5.2067087444E+00, 6.5665392265E+00, 2.5504919046E+00, 9.1720526167E-01],
	[2.9795000000E+04, 2.0955174414E+01, 5.2066948822E+00, 6.5701148882E+00, 2.5511136722E+00, 9.1724585654E-01],
	[2.9800000000E+04, 2.0960966078E+01, 5.2066810223E+00, 6.5736918960E+00, 2.5517353212E+00, 9.1728643118E-01],
	[2.9805000000E+04, 2.0966758370E+01, 5.2066671648E+00, 6.5772702502E+00, 2.5523568516E+00, 9.1732698559E-01],
	[2.9810000000E+04, 2.0972551291E+01, 5.2066533097E+00, 6.5808499510E+00, 2.5529782633E+00, 9.1736751978E-01],
	[2.9815000000E+04, 2.0978344840E+01, 5.2066394569E+00, 6.5844309986E+00, 2.5535995563E+00, 9.1740803377E-01],
	[2.9820000000E+04, 2.0984139018E+01, 5.2066256064E+00, 6.5880133935E+00, 2.5542207305E+00, 9.1744852755E-01],
	[2.9825000000E+04, 2.0989933825E+01, 5.2066117584E+00, 6.5915971358E+00, 2.5548417859E+00, 9.1748900115E-01],
	[2.9830000000E+04, 2.0995729260E+01, 5.2065979127E+00, 6.5951822258E+00, 2.5554627224E+00, 9.1752945458E-01],
	[2.9835000000E+04, 2.1001525323E+01, 5.2065840693E+00, 6.5987686639E+00, 2.5560835402E+00, 9.1756988783E-01],
	[2.9840000000E+04, 2.1007322015E+01, 5.2065702283E+00, 6.6023564503E+00, 2.5567042390E+00, 9.1761030091E-01],
	[2.9845000000E+04, 2.1013119335E+01, 5.2065563897E+00, 6.6059455852E+00, 2.5573248189E+00, 9.1765069385E-01],
	[2.9850000000E+04, 2.1018917283E+01, 5.2065425534E+00, 6.6095360690E+00, 2.5579452799E+00, 9.1769106665E-01],
	[2.9855000000E+04, 2.1024715860E+01, 5.2065287195E+00, 6.6131279020E+00, 2.5585656219E+00, 9.1773141931E-01],
	[2.9860000000E+04, 2.1030515065E+01, 5.2065148879E+00, 6.6167210844E+00, 2.5591858448E+00, 9.1777175184E-01],
	[2.9865000000E+04, 2.1036314898E+01, 5.2065010587E+00, 6.6203156164E+00, 2.5598059487E+00, 9.1781206426E-01],
	[2.9870000000E+04, 2.1042115359E+01, 5.2064872318E+00, 6.6239114985E+00, 2.5604259335E+00, 9.1785235658E-01],
	[2.9875000000E+04, 2.1047916449E+01, 5.2064734073E+00, 6.6275087309E+00, 2.5610457992E+00, 9.1789262879E-01],
	[2.9880000000E+04, 2.1053718166E+01, 5.2064595851E+00, 6.6311073137E+00, 2.5616655457E+00, 9.1793288092E-01],
	[2.9885000000E+04, 2.1059520512E+01, 5.2064457653E+00, 6.6347072475E+00, 2.5622851731E+00, 9.1797311297E-01],
	[2.9890000000E+04, 2.1065323485E+01, 5.2064319478E+00, 6.6383085323E+00, 2.5629046812E+00, 9.1801332495E-01],
	[2.9895000000E+04, 2.1071127087E+01, 5.2064181327E+00, 6.6419111685E+00, 2.5635240700E+00, 9.1805351687E-01],
	[2.9900000000E+04, 2.1076931316E+01, 5.2064043199E+00, 6.6455151564E+00, 2.5641433396E+00, 9.1809368874E-01],
	[2.9905000000E+04, 2.1082736173E+01, 5.2063905095E+00, 6.6491204962E+00, 2.5647624899E+00, 9.1813384057E-01],
	[2.9910000000E+04, 2.1088551726E+01, 5.2063781837E+00, 6.6527271883E+00, 2.5653820297E+00, 9.1817397236E-01],
	[2.9915000000E+04, 2.1094379748E+01, 5.2063676023E+00, 6.6563352328E+00, 2.5660020488E+00, 9.1821408413E-01],
	[2.9920000000E+04, 2.1100208407E+01, 5.2063570226E+00, 6.6599446302E+00, 2.5666219492E+00, 9.1825417589E-01],
	[2.9925000000E+04, 2.1106037701E+01, 5.2063464448E+00, 6.6635553806E+00, 2.5672417309E+00, 9.1829424764E-01],
	[2.9930000000E+04, 2.1111867632E+01, 5.2063358688E+00, 6.6671674844E+00, 2.5678613938E+00, 9.1833429939E-01],
	[2.9935000000E+04, 2.1117698198E+01, 5.2063252945E+00, 6.6707809419E+00, 2.5684809379E+00, 9.1837433115E-01],
	[2.9940000000E+04, 2.1123529401E+01, 5.2063147221E+00, 6.6743957532E+00, 2.5691003631E+00, 9.1841434294E-01],
	[2.9945000000E+04, 2.1129361240E+01, 5.2063041514E+00, 6.6780119187E+00, 2.5697196695E+00, 9.1845433476E-01],
	[2.9950000000E+04, 2.1135193715E+01, 5.2062935825E+00, 6.6816294387E+00, 2.5703388570E+00, 9.1849430662E-01],
	[2.9955000000E+04, 2.1141026825E+01, 5.2062830154E+00, 6.6852483135E+00, 2.5709579256E+00, 9.1853425853E-01],
	[2.9960000000E+04, 2.1146860572E+01, 5.2062724501E+00, 6.6888685433E+00, 2.5715768752E+00, 9.1857419050E-01],
	[2.9965000000E+04, 2.1152694954E+01, 5.2062618866E+00, 6.6924901284E+00, 2.5721957058E+00, 9.1861410253E-01],
	[2.9970000000E+04, 2.1158529973E+01, 5.2062513248E+00, 6.6961130692E+00, 2.5728144174E+00, 9.1865399465E-01],
	[2.9975000000E+04, 2.1164365627E+01, 5.2062407649E+00, 6.6997373658E+00, 2.5734330099E+00, 9.1869386684E-01],
	[2.9980000000E+04, 2.1170201917E+01, 5.2062302067E+00, 6.7033630186E+00, 2.5740514833E+00, 9.1873371914E-01],
	[2.9985000000E+04, 2.1176038842E+01, 5.2062196503E+00, 6.7069900278E+00, 2.5746698376E+00, 9.1877355154E-01],
	[2.9990000000E+04, 2.1181876404E+01, 5.2062090957E+00, 6.7106183937E+00, 2.5752880728E+00, 9.1881336405E-01],
	[2.9995000000E+04, 2.1187714601E+01, 5.2061985428E+00, 6.7142481166E+00, 2.5759061888E+00, 9.1885315669E-01],
	[3.0000000000E+04, 2.1193553433E+01, 5.2061879918E+00, 6.7178791969E+00, 2.5765241855E+00, 9.1889292945E-01],
	[3.0005000000E+04, 2.1199392902E+01, 5.2061774425E+00, 6.7215344760E+00, 2.5771454209E+00, 9.1893268236E-01],
	[3.0010000000E+04, 2.1205233005E+01, 5.2061668950E+00, 6.7251911339E+00, 2.5777665360E+00, 9.1897241542E-01],
	[3.0015000000E+04, 2.1211073745E+01, 5.2061563493E+00, 6.7288491709E+00, 2.5783875308E+00, 9.1901212864E-01],
	[3.0020000000E+04, 2.1216915119E+01, 5.2061458053E+00, 6.7325085873E+00, 2.5790084054E+00, 9.1905182203E-01],
	[3.0025000000E+04, 2.1222757129E+01, 5.2061352632E+00, 6.7361693834E+00, 2.5796291595E+00, 9.1909149560E-01],
	[3.0030000000E+04, 2.1228599775E+01, 5.2061247228E+00, 6.7398315594E+00, 2.5802497933E+00, 9.1913114935E-01],
	[3.0035000000E+04, 2.1234443056E+01, 5.2061141842E+00, 6.7434951157E+00, 2.5808703067E+00, 9.1917078330E-01],
	[3.0040000000E+04, 2.1240286972E+01, 5.2061036473E+00, 6.7471600525E+00, 2.5814906996E+00, 9.1921039746E-01],
	[3.0045000000E+04, 2.1246131524E+01, 5.2060931123E+00, 6.7508263702E+00, 2.5821109720E+00, 9.1924999183E-01],
	[3.0050000000E+04, 2.1251976711E+01, 5.2060825790E+00, 6.7544940689E+00, 2.5827311240E+00, 9.1928956642E-01],
	[3.0055000000E+04, 2.1257822533E+01, 5.2060720475E+00, 6.7581631491E+00, 2.5833511554E+00, 9.1932912125E-01],
	[3.0060000000E+04, 2.1263668990E+01, 5.2060615177E+00, 6.7618336110E+00, 2.5839710662E+00, 9.1936865632E-01],
	[3.0065000000E+04, 2.1269516082E+01, 5.2060509898E+00, 6.7655054549E+00, 2.5845908564E+00, 9.1940817164E-01],
	[3.0070000000E+04, 2.1275363810E+01, 5.2060404636E+00, 6.7691786810E+00, 2.5852105260E+00, 9.1944766723E-01],
	[3.0075000000E+04, 2.1281212172E+01, 5.2060299391E+00, 6.7728532897E+00, 2.5858300749E+00, 9.1948714308E-01],
	[3.0080000000E+04, 2.1287061170E+01, 5.2060194165E+00, 6.7765292813E+00, 2.5864495031E+00, 9.1952659921E-01],
	[3.0085000000E+04, 2.1292910802E+01, 5.2060088956E+00, 6.7802066560E+00, 2.5870688106E+00, 9.1956603563E-01],
	[3.0090000000E+04, 2.1298761070E+01, 5.2059983765E+00, 6.7838854142E+00, 2.5876879973E+00, 9.1960545235E-01],
	[3.0095000000E+04, 2.1304611972E+01, 5.2059878591E+00, 6.7875655561E+00, 2.5883070632E+00, 9.1964484938E-01],
	[3.0100000000E+04, 2.1310463509E+01, 5.2059773436E+00, 6.7912470820E+00, 2.5889260083E+00, 9.1968422672E-01],
	[3.0105000000E+04, 2.1316315682E+01, 5.2059668298E+00, 6.7949299922E+00, 2.5895448326E+00, 9.1972358439E-01],
	[3.0110000000E+04, 2.1322168489E+01, 5.2059563177E+00, 6.7986142870E+00, 2.5901635359E+00, 9.1976292242E-01],
	[3.0115000000E+04, 2.1328021930E+01, 5.2059458075E+00, 6.8022999668E+00, 2.5907821184E+00, 9.1980224083E-01],
	[3.0120000000E+04, 2.1333876007E+01, 5.2059352989E+00, 6.8059870317E+00, 2.5914005799E+00, 9.1984153962E-01],
	[3.0125000000E+04, 2.1339730718E+01, 5.2059247922E+00, 6.8096754820E+00, 2.5920189204E+00, 9.1988081880E-01],
	[3.0130000000E+04, 2.1345586064E+01, 5.2059142872E+00, 6.8133653182E+00, 2.5926371399E+00, 9.1992007839E-01],
	[3.0135000000E+04, 2.1351442045E+01, 5.2059037840E+00, 6.8170565404E+00, 2.5932552384E+00, 9.1995931839E-01],
	[3.0140000000E+04, 2.1357298660E+01, 5.2058932826E+00, 6.8207491489E+00, 2.5938732158E+00, 9.1999853880E-01],
	[3.0145000000E+04, 2.1363155909E+01, 5.2058827829E+00, 6.8244431441E+00, 2.5944910721E+00, 9.2003773964E-01],
	[3.0150000000E+04, 2.1369013794E+01, 5.2058722850E+00, 6.8281385261E+00, 2.5951088073E+00, 9.2007692091E-01],
	[3.0155000000E+04, 2.1374872312E+01, 5.2058617888E+00, 6.8318352954E+00, 2.5957264213E+00, 9.2011608263E-01],
	[3.0160000000E+04, 2.1380731465E+01, 5.2058512944E+00, 6.8355334522E+00, 2.5963439141E+00, 9.2015522479E-01],
	[3.0165000000E+04, 2.1386591253E+01, 5.2058408018E+00, 6.8392329968E+00, 2.5969612857E+00, 9.2019434741E-01],
	[3.0170000000E+04, 2.1392451675E+01, 5.2058303109E+00, 6.8429339295E+00, 2.5975785360E+00, 9.2023345049E-01],
	[3.0175000000E+04, 2.1398312731E+01, 5.2058198218E+00, 6.8466362506E+00, 2.5981956651E+00, 9.2027253405E-01],
	[3.0180000000E+04, 2.1404174422E+01, 5.2058093344E+00, 6.8503399603E+00, 2.5988126729E+00, 9.2031159809E-01],
	[3.0185000000E+04, 2.1410036746E+01, 5.2057988488E+00, 6.8540450590E+00, 2.5994295593E+00, 9.2035064262E-01],
	[3.0190000000E+04, 2.1415899705E+01, 5.2057883650E+00, 6.8577515469E+00, 2.6000463243E+00, 9.2038966765E-01],
	[3.0195000000E+04, 2.1421763299E+01, 5.2057778829E+00, 6.8614594243E+00, 2.6006629679E+00, 9.2042867318E-01],
	[3.0200000000E+04, 2.1427627526E+01, 5.2057674025E+00, 6.8651686916E+00, 2.6012794901E+00, 9.2046765923E-01],
	[3.0205000000E+04, 2.1433492388E+01, 5.2057569240E+00, 6.8688793490E+00, 2.6018958909E+00, 9.2050662579E-01],
	[3.0210000000E+04, 2.1439357883E+01, 5.2057464471E+00, 6.8725913968E+00, 2.6025121701E+00, 9.2054557289E-01],
	[3.0215000000E+04, 2.1445224013E+01, 5.2057359721E+00, 6.8763048353E+00, 2.6031283279E+00, 9.2058450052E-01],
	[3.0220000000E+04, 2.1451090777E+01, 5.2057254988E+00, 6.8800196648E+00, 2.6037443641E+00, 9.2062340870E-01],
	[3.0225000000E+04, 2.1456958174E+01, 5.2057150272E+00, 6.8837358856E+00, 2.6043602787E+00, 9.2066229744E-01],
	[3.0230000000E+04, 2.1462826206E+01, 5.2057045574E+00, 6.8874534979E+00, 2.6049760716E+00, 9.2070116673E-01],
	[3.0235000000E+04, 2.1468694871E+01, 5.2056940894E+00, 6.8911725021E+00, 2.6055917430E+00, 9.2074001660E-01],
	[3.0240000000E+04, 2.1474564171E+01, 5.2056836231E+00, 6.8948928985E+00, 2.6062072927E+00, 9.2077884704E-01],
	[3.0245000000E+04, 2.1480434104E+01, 5.2056731585E+00, 6.8986146873E+00, 2.6068227207E+00, 9.2081765807E-01],
	[3.0250000000E+04, 2.1486304671E+01, 5.2056626957E+00, 6.9023378688E+00, 2.6074380269E+00, 9.2085644969E-01],
	[3.0255000000E+04, 2.1492175871E+01, 5.2056522347E+00, 6.9060624433E+00, 2.6080532114E+00, 9.2089522192E-01],
	[3.0260000000E+04, 2.1498047706E+01, 5.2056417754E+00, 6.9097884112E+00, 2.6086682741E+00, 9.2093397475E-01],
	[3.0265000000E+04, 2.1503920174E+01, 5.2056313178E+00, 6.9135157726E+00, 2.6092832150E+00, 9.2097270821E-01],
	[3.0270000000E+04, 2.1509793276E+01, 5.2056208620E+00, 6.9172445280E+00, 2.6098980341E+00, 9.2101142228E-01],
	[3.0275000000E+04, 2.1515667011E+01, 5.2056104080E+00, 6.9209746775E+00, 2.6105127313E+00, 9.2105011700E-01],
	[3.0280000000E+04, 2.1521541380E+01, 5.2055999557E+00, 6.9247062215E+00, 2.6111273066E+00, 9.2108879236E-01],
	[3.0285000000E+04, 2.1527416383E+01, 5.2055895051E+00, 6.9284391603E+00, 2.6117417599E+00, 9.2112744836E-01],
	[3.0290000000E+04, 2.1533292019E+01, 5.2055790563E+00, 6.9321734941E+00, 2.6123560913E+00, 9.2116608503E-01],
	[3.0295000000E+04, 2.1539168288E+01, 5.2055686093E+00, 6.9359092233E+00, 2.6129703008E+00, 9.2120470236E-01],
	[3.0300000000E+04, 2.1545045191E+01, 5.2055581640E+00, 6.9396463481E+00, 2.6135843882E+00, 9.2124330037E-01],
	[3.0305000000E+04, 2.1550922727E+01, 5.2055477204E+00, 6.9433848689E+00, 2.6141983535E+00, 9.2128187906E-01],
	[3.0310000000E+04, 2.1556800897E+01, 5.2055372785E+00, 6.9471247858E+00, 2.6148121968E+00, 9.2132043844E-01],
	[3.0315000000E+04, 2.1562679700E+01, 5.2055268385E+00, 6.9508660993E+00, 2.6154259180E+00, 9.2135897852E-01],
	[3.0320000000E+04, 2.1568559136E+01, 5.2055164001E+00, 6.9546088096E+00, 2.6160395170E+00, 9.2139749931E-01],
	[3.0325000000E+04, 2.1574439206E+01, 5.2055059635E+00, 6.9583529169E+00, 2.6166529939E+00, 9.2143600082E-01],
	[3.0330000000E+04, 2.1580319908E+01, 5.2054955287E+00, 6.9620984217E+00, 2.6172663486E+00, 9.2147448304E-01],
	[3.0335000000E+04, 2.1586201244E+01, 5.2054850955E+00, 6.9658453241E+00, 2.6178795811E+00, 9.2151294600E-01],
	[3.0340000000E+04, 2.1592083213E+01, 5.2054746642E+00, 6.9695936244E+00, 2.6184926914E+00, 9.2155138970E-01],
	[3.0345000000E+04, 2.1597965816E+01, 5.2054642345E+00, 6.9733433231E+00, 2.6191056794E+00, 9.2158981415E-01],
	[3.0350000000E+04, 2.1603849051E+01, 5.2054538066E+00, 6.9770944202E+00, 2.6197185451E+00, 9.2162821935E-01],
	[3.0355000000E+04, 2.1609732919E+01, 5.2054433805E+00, 6.9808469162E+00, 2.6203312884E+00, 9.2166660532E-01],
	[3.0360000000E+04, 2.1615617420E+01, 5.2054329560E+00, 6.9846008114E+00, 2.6209439094E+00, 9.2170497206E-01],
	[3.0365000000E+04, 2.1621502554E+01, 5.2054225333E+00, 6.9883561059E+00, 2.6215564081E+00, 9.2174331958E-01],
	[3.0370000000E+04, 2.1627388322E+01, 5.2054121124E+00, 6.9921128002E+00, 2.6221687843E+00, 9.2178164790E-01],
	[3.0375000000E+04, 2.1633274722E+01, 5.2054016932E+00, 6.9958708944E+00, 2.6227810381E+00, 9.2181995700E-01],
	[3.0380000000E+04, 2.1639161754E+01, 5.2053912757E+00, 6.9996303890E+00, 2.6233931694E+00, 9.2185824692E-01],
	[3.0385000000E+04, 2.1645049420E+01, 5.2053808600E+00, 7.0033912841E+00, 2.6240051782E+00, 9.2189651764E-01],
	[3.0390000000E+04, 2.1650941300E+01, 5.2053709678E+00, 7.0071535801E+00, 2.6246172498E+00, 9.2193476919E-01],
	[3.0395000000E+04, 2.1656851945E+01, 5.2053637177E+00, 7.0109172773E+00, 2.6252301370E+00, 9.2197300157E-01],
	[3.0400000000E+04, 2.1662763230E+01, 5.2053564689E+00, 7.0146823759E+00, 2.6258429023E+00, 9.2201121478E-01],
	[3.0405000000E+04, 2.1668675156E+01, 5.2053492213E+00, 7.0184488762E+00, 2.6264555457E+00, 9.2204940884E-01],
	[3.0410000000E+04, 2.1674587724E+01, 5.2053419749E+00, 7.0222167786E+00, 2.6270680672E+00, 9.2208758376E-01],
	[3.0415000000E+04, 2.1680500932E+01, 5.2053347297E+00, 7.0259860833E+00, 2.6276804667E+00, 9.2212573954E-01],
	[3.0420000000E+04, 2.1686414780E+01, 5.2053274856E+00, 7.0297567907E+00, 2.6282927442E+00, 9.2216387619E-01],
	[3.0425000000E+04, 2.1692329270E+01, 5.2053202428E+00, 7.0335289009E+00, 2.6289048997E+00, 9.2220199371E-01],
	[3.0430000000E+04, 2.1698244401E+01, 5.2053130012E+00, 7.0373024143E+00, 2.6295169331E+00, 9.2224009213E-01],
	[3.0435000000E+04, 2.1704160172E+01, 5.2053057608E+00, 7.0410773313E+00, 2.6301288445E+00, 9.2227817144E-01],
	[3.0440000000E+04, 2.1710076583E+01, 5.2052985216E+00, 7.0448536520E+00, 2.6307406337E+00, 9.2231623165E-01],
	[3.0445000000E+04, 2.1715993636E+01, 5.2052912836E+00, 7.0486313768E+00, 2.6313523009E+00, 9.2235427278E-01],
	[3.0450000000E+04, 2.1721911329E+01, 5.2052840468E+00, 7.0524105059E+00, 2.6319638459E+00, 9.2239229482E-01],
	[3.0455000000E+04, 2.1727829662E+01, 5.2052768111E+00, 7.0561910397E+00, 2.6325752687E+00, 9.2243029779E-01],
	[3.0460000000E+04, 2.1733748637E+01, 5.2052695767E+00, 7.0599729784E+00, 2.6331865693E+00, 9.2246828170E-01],
	[3.0465000000E+04, 2.1739668251E+01, 5.2052623435E+00, 7.0637563224E+00, 2.6337977476E+00, 9.2250624656E-01],
	[3.0470000000E+04, 2.1745588506E+01, 5.2052551115E+00, 7.0675410719E+00, 2.6344088037E+00, 9.2254419236E-01],
	[3.0475000000E+04, 2.1751509402E+01, 5.2052478806E+00, 7.0713272272E+00, 2.6350197375E+00, 9.2258211913E-01],
	[3.0480000000E+04, 2.1757430938E+01, 5.2052406510E+00, 7.0751147887E+00, 2.6356305490E+00, 9.2262002687E-01],
	[3.0485000000E+04, 2.1763353114E+01, 5.2052334226E+00, 7.0789037565E+00, 2.6362412382E+00, 9.2265791558E-01],
	[3.0490000000E+04, 2.1769275931E+01, 5.2052261953E+00, 7.0826941310E+00, 2.6368518050E+00, 9.2269578528E-01],
	[3.0495000000E+04, 2.1775199388E+01, 5.2052189693E+00, 7.0864859125E+00, 2.6374622494E+00, 9.2273363598E-01],
	[3.0500000000E+04, 2.1781123485E+01, 5.2052117444E+00, 7.0902791013E+00, 2.6380725713E+00, 9.2277146767E-01],
	[3.0505000000E+04, 2.1787048222E+01, 5.2052045208E+00, 7.0940736976E+00, 2.6386827708E+00, 9.2280928038E-01],
	[3.0510000000E+04, 2.1792973600E+01, 5.2051972983E+00, 7.0978697018E+00, 2.6392928479E+00, 9.2284707410E-01],
	[3.0515000000E+04, 2.1798899617E+01, 5.2051900770E+00, 7.1016671142E+00, 2.6399028024E+00, 9.2288484886E-01],
	[3.0520000000E+04, 2.1804826275E+01, 5.2051828569E+00, 7.1054659349E+00, 2.6405126344E+00, 9.2292260464E-01],
	[3.0525000000E+04, 2.1810753573E+01, 5.2051756381E+00, 7.1092661644E+00, 2.6411223439E+00, 9.2296034147E-01],
	[3.0530000000E+04, 2.1816681511E+01, 5.2051684204E+00, 7.1130678030E+00, 2.6417319308E+00, 9.2299805936E-01],
	[3.0535000000E+04, 2.1822610089E+01, 5.2051612039E+00, 7.1168708508E+00, 2.6423413951E+00, 9.2303575830E-01],
	[3.0540000000E+04, 2.1828539306E+01, 5.2051539886E+00, 7.1206753083E+00, 2.6429507367E+00, 9.2307343831E-01],
	[3.0545000000E+04, 2.1834469164E+01, 5.2051467744E+00, 7.1244811756E+00, 2.6435599557E+00, 9.2311109940E-01],
	[3.0550000000E+04, 2.1840399662E+01, 5.2051395615E+00, 7.1282884531E+00, 2.6441690520E+00, 9.2314874157E-01],
	[3.0555000000E+04, 2.1846330799E+01, 5.2051323498E+00, 7.1320971411E+00, 2.6447780257E+00, 9.2318636483E-01],
	[3.0560000000E+04, 2.1852262577E+01, 5.2051251392E+00, 7.1359072399E+00, 2.6453868765E+00, 9.2322396920E-01],
	[3.0565000000E+04, 2.1858194994E+01, 5.2051179299E+00, 7.1397187497E+00, 2.6459956046E+00, 9.2326155467E-01],
	[3.0570000000E+04, 2.1864128050E+01, 5.2051107217E+00, 7.1435316709E+00, 2.6466042100E+00, 9.2329912127E-01],
	[3.0575000000E+04, 2.1870061747E+01, 5.2051035147E+00, 7.1473460037E+00, 2.6472126925E+00, 9.2333666899E-01],
	[3.0580000000E+04, 2.1875996083E+01, 5.2050963089E+00, 7.1511617485E+00, 2.6478210522E+00, 9.2337419784E-01],
	[3.0585000000E+04, 2.1881931059E+01, 5.2050891043E+00, 7.1549789055E+00, 2.6484292890E+00, 9.2341170784E-01],
	[3.0590000000E+04, 2.1887866675E+01, 5.2050819009E+00, 7.1587974750E+00, 2.6490374029E+00, 9.2344919898E-01],
	[3.0595000000E+04, 2.1893802930E+01, 5.2050746987E+00, 7.1626174573E+00, 2.6496453940E+00, 9.2348667129E-01],
	[3.0600000000E+04, 2.1899739824E+01, 5.2050674976E+00, 7.1664388527E+00, 2.6502532621E+00, 9.2352412477E-01],
	[3.0605000000E+04, 2.1905677358E+01, 5.2050602978E+00, 7.1702616615E+00, 2.6508610072E+00, 9.2356155942E-01],
	[3.0610000000E+04, 2.1911615532E+01, 5.2050530991E+00, 7.1740858839E+00, 2.6514686293E+00, 9.2359897525E-01],
	[3.0615000000E+04, 2.1917554345E+01, 5.2050459016E+00, 7.1779115204E+00, 2.6520761285E+00, 9.2363637228E-01],
	[3.0620000000E+04, 2.1923493797E+01, 5.2050387053E+00, 7.1817385711E+00, 2.6526835046E+00, 9.2367375051E-01],
	[3.0625000000E+04, 2.1929433889E+01, 5.2050315102E+00, 7.1855670364E+00, 2.6532907576E+00, 9.2371110994E-01],
	[3.0630000000E+04, 2.1935374620E+01, 5.2050243163E+00, 7.1893969165E+00, 2.6538978875E+00, 9.2374845060E-01],
	[3.0635000000E+04, 2.1941315990E+01, 5.2050171236E+00, 7.1932282117E+00, 2.6545048944E+00, 9.2378577248E-01],
	[3.0640000000E+04, 2.1947258000E+01, 5.2050099320E+00, 7.1970609224E+00, 2.6551117781E+00, 9.2382307559E-01],
	[3.0645000000E+04, 2.1953200649E+01, 5.2050027416E+00, 7.2008950488E+00, 2.6557185386E+00, 9.2386035995E-01],
	[3.0650000000E+04, 2.1959143937E+01, 5.2049955524E+00, 7.2047305913E+00, 2.6563251760E+00, 9.2389762555E-01],
	[3.0655000000E+04, 2.1965087864E+01, 5.2049883644E+00, 7.2085675500E+00, 2.6569316901E+00, 9.2393487242E-01],
	[3.0660000000E+04, 2.1971032430E+01, 5.2049811776E+00, 7.2124059253E+00, 2.6575380810E+00, 9.2397210055E-01],
	[3.0665000000E+04, 2.1976977635E+01, 5.2049739919E+00, 7.2162457175E+00, 2.6581443487E+00, 9.2400930996E-01],
	[3.0670000000E+04, 2.1982923480E+01, 5.2049668075E+00, 7.2200869269E+00, 2.6587504930E+00, 9.2404650066E-01],
	[3.0675000000E+04, 2.1988869963E+01, 5.2049596242E+00, 7.2239295538E+00, 2.6593565141E+00, 9.2408367264E-01],
	[3.0680000000E+04, 2.1994817085E+01, 5.2049524421E+00, 7.2277735984E+00, 2.6599624118E+00, 9.2412082593E-01],
	[3.0685000000E+04, 2.2000764847E+01, 5.2049452612E+00, 7.2316190611E+00, 2.6605681862E+00, 9.2415796052E-01],
	[3.0690000000E+04, 2.2006713247E+01, 5.2049380814E+00, 7.2354659421E+00, 2.6611738372E+00, 9.2419507644E-01],
	[3.0695000000E+04, 2.2012662286E+01, 5.2049309029E+00, 7.2393142418E+00, 2.6617793648E+00, 9.2423217367E-01],
	[3.0700000000E+04, 2.2018611963E+01, 5.2049237255E+00, 7.2431639604E+00, 2.6623847689E+00, 9.2426925225E-01],
	[3.0705000000E+04, 2.2024562280E+01, 5.2049165493E+00, 7.2470150982E+00, 2.6629900496E+00, 9.2430631216E-01],
	[3.0710000000E+04, 2.2030513235E+01, 5.2049093742E+00, 7.2508676555E+00, 2.6635952069E+00, 9.2434335343E-01],
	[3.0715000000E+04, 2.2036464829E+01, 5.2049022004E+00, 7.2547216327E+00, 2.6642002406E+00, 9.2438037605E-01],
	[3.0720000000E+04, 2.2042417062E+01, 5.2048950277E+00, 7.2585770299E+00, 2.6648051508E+00, 9.2441738004E-01],
	[3.0725000000E+04, 2.2048369934E+01, 5.2048878562E+00, 7.2624338475E+00, 2.6654099375E+00, 9.2445436541E-01],
	[3.0730000000E+04, 2.2054323444E+01, 5.2048806859E+00, 7.2662920858E+00, 2.6660146006E+00, 9.2449133216E-01],
	[3.0735000000E+04, 2.2060277592E+01, 5.2048735168E+00, 7.2701517451E+00, 2.6666191401E+00, 9.2452828031E-01],
	[3.0740000000E+04, 2.2066232379E+01, 5.2048663488E+00, 7.2740128256E+00, 2.6672235559E+00, 9.2456520985E-01],
	[3.0745000000E+04, 2.2072187805E+01, 5.2048591820E+00, 7.2778753277E+00, 2.6678278482E+00, 9.2460212081E-01],
	[3.0750000000E+04, 2.2078143869E+01, 5.2048520164E+00, 7.2817392516E+00, 2.6684320167E+00, 9.2463901318E-01],
	[3.0755000000E+04, 2.2084100571E+01, 5.2048448520E+00, 7.2856045977E+00, 2.6690360616E+00, 9.2467588698E-01],
	[3.0760000000E+04, 2.2090057912E+01, 5.2048376887E+00, 7.2894713662E+00, 2.6696399828E+00, 9.2471274221E-01],
	[3.0765000000E+04, 2.2096015892E+01, 5.2048305266E+00, 7.2933395574E+00, 2.6702437802E+00, 9.2474957888E-01],
	[3.0770000000E+04, 2.2101974509E+01, 5.2048233657E+00, 7.2972091717E+00, 2.6708474539E+00, 9.2478639701E-01],
	[3.0775000000E+04, 2.2107933765E+01, 5.2048162059E+00, 7.3010802092E+00, 2.6714510038E+00, 9.2482319659E-01],
	[3.0780000000E+04, 2.2113893659E+01, 5.2048090474E+00, 7.3049526703E+00, 2.6720544299E+00, 9.2485997765E-01],
	[3.0785000000E+04, 2.2119854192E+01, 5.2048018900E+00, 7.3088265554E+00, 2.6726577321E+00, 9.2489674018E-01],
	[3.0790000000E+04, 2.2125815362E+01, 5.2047947337E+00, 7.3127018646E+00, 2.6732609105E+00, 9.2493348419E-01],
	[3.0795000000E+04, 2.2131777171E+01, 5.2047875787E+00, 7.3165785983E+00, 2.6738639651E+00, 9.2497020970E-01],
	[3.0800000000E+04, 2.2137739618E+01, 5.2047804248E+00, 7.3204567567E+00, 2.6744668957E+00, 9.2500691671E-01],
	[3.0805000000E+04, 2.2143702703E+01, 5.2047732721E+00, 7.3243363402E+00, 2.6750697024E+00, 9.2504360522E-01],
	[3.0810000000E+04, 2.2149666426E+01, 5.2047661206E+00, 7.3282173491E+00, 2.6756723852E+00, 9.2508027526E-01],
	[3.0815000000E+04, 2.2155630787E+01, 5.2047589702E+00, 7.3320997836E+00, 2.6762749440E+00, 9.2511692682E-01],
	[3.0820000000E+04, 2.2161595786E+01, 5.2047518210E+00, 7.3359836440E+00, 2.6768773789E+00, 9.2515355992E-01],
	[3.0825000000E+04, 2.2167561422E+01, 5.2047446730E+00, 7.3398689307E+00, 2.6774796897E+00, 9.2519017456E-01],
	[3.0830000000E+04, 2.2173527697E+01, 5.2047375261E+00, 7.3437556438E+00, 2.6780818765E+00, 9.2522677075E-01],
	[3.0835000000E+04, 2.2179494610E+01, 5.2047303804E+00, 7.3476437838E+00, 2.6786839392E+00, 9.2526334851E-01],
	[3.0840000000E+04, 2.2185462160E+01, 5.2047232359E+00, 7.3515333509E+00, 2.6792858778E+00, 9.2529990783E-01],
	[3.0845000000E+04, 2.2191430349E+01, 5.2047160925E+00, 7.3554243454E+00, 2.6798876924E+00, 9.2533644873E-01],
	[3.0850000000E+04, 2.2197399175E+01, 5.2047089503E+00, 7.3593167675E+00, 2.6804893828E+00, 9.2537297121E-01],
	[3.0855000000E+04, 2.2203368639E+01, 5.2047018093E+00, 7.3632106176E+00, 2.6810909491E+00, 9.2540947529E-01],
	[3.0860000000E+04, 2.2209338740E+01, 5.2046946695E+00, 7.3671058960E+00, 2.6816923912E+00, 9.2544596096E-01],
	[3.0865000000E+04, 2.2215309479E+01, 5.2046875308E+00, 7.3710026030E+00, 2.6822937091E+00, 9.2548242825E-01],
	[3.0870000000E+04, 2.2221280856E+01, 5.2046803932E+00, 7.3749007388E+00, 2.6828949029E+00, 9.2551887716E-01],
	[3.0875000000E+04, 2.2227252870E+01, 5.2046732569E+00, 7.3788003038E+00, 2.6834959723E+00, 9.2555530770E-01],
	[3.0880000000E+04, 2.2233232397E+01, 5.2046671137E+00, 7.3827012982E+00, 2.6840972816E+00, 9.2559171987E-01],
	[3.0885000000E+04, 2.2239227169E+01, 5.2046630780E+00, 7.3866037223E+00, 2.6846992401E+00, 9.2562811369E-01],
	[3.0890000000E+04, 2.2245222586E+01, 5.2046590430E+00, 7.3905075764E+00, 2.6853010750E+00, 9.2566448915E-01],
	[3.0895000000E+04, 2.2251218648E+01, 5.2046550086E+00, 7.3944128609E+00, 2.6859027863E+00, 9.2570084628E-01],
	[3.0900000000E+04, 2.2257215356E+01, 5.2046509749E+00, 7.3983195760E+00, 2.6865043738E+00, 9.2573718508E-01],
	[3.0905000000E+04, 2.2263212710E+01, 5.2046469419E+00, 7.4022277219E+00, 2.6871058377E+00, 9.2577350556E-01],
	[3.0910000000E+04, 2.2269210709E+01, 5.2046429095E+00, 7.4061372991E+00, 2.6877071778E+00, 9.2580980772E-01],
	[3.0915000000E+04, 2.2275209353E+01, 5.2046388778E+00, 7.4100483077E+00, 2.6883083943E+00, 9.2584609158E-01],
	[3.0920000000E+04, 2.2281208643E+01, 5.2046348467E+00, 7.4139607481E+00, 2.6889094869E+00, 9.2588235714E-01],
	[3.0925000000E+04, 2.2287208578E+01, 5.2046308163E+00, 7.4178746206E+00, 2.6895104558E+00, 9.2591860441E-01],
	[3.0930000000E+04, 2.2293209158E+01, 5.2046267865E+00, 7.4217899254E+00, 2.6901113008E+00, 9.2595483341E-01],
	[3.0935000000E+04, 2.2299210383E+01, 5.2046227574E+00, 7.4257066629E+00, 2.6907120221E+00, 9.2599104413E-01],
	[3.0940000000E+04, 2.2305212254E+01, 5.2046187289E+00, 7.4296248333E+00, 2.6913126195E+00, 9.2602723658E-01],
	[3.0945000000E+04, 2.2311214770E+01, 5.2046147011E+00, 7.4335444370E+00, 2.6919130930E+00, 9.2606341079E-01],
	[3.0950000000E+04, 2.2317217931E+01, 5.2046106740E+00, 7.4374654742E+00, 2.6925134426E+00, 9.2609956674E-01],
	[3.0955000000E+04, 2.2323221737E+01, 5.2046066475E+00, 7.4413879452E+00, 2.6931136683E+00, 9.2613570446E-01],
	[3.0960000000E+04, 2.2329226188E+01, 5.2046026217E+00, 7.4453118503E+00, 2.6937137701E+00, 9.2617182395E-01],
	[3.0965000000E+04, 2.2335231285E+01, 5.2045985965E+00, 7.4492371898E+00, 2.6943137479E+00, 9.2620792522E-01],
	[3.0970000000E+04, 2.2341237026E+01, 5.2045945719E+00, 7.4531639641E+00, 2.6949136018E+00, 9.2624400827E-01],
	[3.0975000000E+04, 2.2347243412E+01, 5.2045905480E+00, 7.4570921733E+00, 2.6955133316E+00, 9.2628007313E-01],
	[3.0980000000E+04, 2.2353250443E+01, 5.2045865248E+00, 7.4610218178E+00, 2.6961129375E+00, 9.2631611978E-01],
	[3.0985000000E+04, 2.2359258119E+01, 5.2045825022E+00, 7.4649528978E+00, 2.6967124192E+00, 9.2635214825E-01],
	[3.0990000000E+04, 2.2365266440E+01, 5.2045784803E+00, 7.4688854138E+00, 2.6973117770E+00, 9.2638815854E-01],
	[3.0995000000E+04, 2.2371275406E+01, 5.2045744590E+00, 7.4728193659E+00, 2.6979110106E+00, 9.2642415066E-01],
	[3.1000000000E+04, 2.2377285017E+01, 5.2045704384E+00, 7.4767547544E+00, 2.6985101202E+00, 9.2646012462E-01],
	[3.1005000000E+04, 2.2383295272E+01, 5.2045664184E+00, 7.4806915797E+00, 2.6991091056E+00, 9.2649608042E-01],
	[3.1010000000E+04, 2.2389306172E+01, 5.2045623991E+00, 7.4846298420E+00, 2.6997079669E+00, 9.2653201808E-01],
	[3.1015000000E+04, 2.2395317717E+01, 5.2045583805E+00, 7.4885695416E+00, 2.7003067040E+00, 9.2656793760E-01],
	[3.1020000000E+04, 2.2401329906E+01, 5.2045543624E+00, 7.4925106789E+00, 2.7009053170E+00, 9.2660383900E-01],
	[3.1025000000E+04, 2.2407342740E+01, 5.2045503451E+00, 7.4964532541E+00, 2.7015038057E+00, 9.2663972227E-01],
	[3.1030000000E+04, 2.2413356219E+01, 5.2045463283E+00, 7.5003972675E+00, 2.7021021702E+00, 9.2667558744E-01],
	[3.1035000000E+04, 2.2419370342E+01, 5.2045423123E+00, 7.5043427193E+00, 2.7027004104E+00, 9.2671143450E-01],
	[3.1040000000E+04, 2.2425385110E+01, 5.2045382969E+00, 7.5082896100E+00, 2.7032985264E+00, 9.2674726347E-01],
	[3.1045000000E+04, 2.2431400522E+01, 5.2045342821E+00, 7.5122379398E+00, 2.7038965181E+00, 9.2678307435E-01],
	[3.1050000000E+04, 2.2437416578E+01, 5.2045302680E+00, 7.5161877089E+00, 2.7044943855E+00, 9.2681886715E-01],
	[3.1055000000E+04, 2.2443433279E+01, 5.2045262545E+00, 7.5201389177E+00, 2.7050921286E+00, 9.2685464189E-01],
	[3.1060000000E+04, 2.2449450625E+01, 5.2045222417E+00, 7.5240915665E+00, 2.7056897473E+00, 9.2689039856E-01],
	[3.1065000000E+04, 2.2455468615E+01, 5.2045182295E+00, 7.5280456555E+00, 2.7062872417E+00, 9.2692613718E-01],
	[3.1070000000E+04, 2.2461487249E+01, 5.2045142180E+00, 7.5320011850E+00, 2.7068846116E+00, 9.2696185776E-01],
	[3.1075000000E+04, 2.2467506527E+01, 5.2045102071E+00, 7.5359581554E+00, 2.7074818572E+00, 9.2699756031E-01],
	[3.1080000000E+04, 2.2473526450E+01, 5.2045061969E+00, 7.5399165669E+00, 2.7080789783E+00, 9.2703324482E-01],
	[3.1085000000E+04, 2.2479547016E+01, 5.2045021873E+00, 7.5438764199E+00, 2.7086759750E+00, 9.2706891132E-01],
	[3.1090000000E+04, 2.2485568227E+01, 5.2044981784E+00, 7.5478377145E+00, 2.7092728472E+00, 9.2710455981E-01],
	[3.1095000000E+04, 2.2491590082E+01, 5.2044941701E+00, 7.5518004512E+00, 2.7098695950E+00, 9.2714019030E-01],
	[3.1100000000E+04, 2.2497612582E+01, 5.2044901625E+00, 7.5557646302E+00, 2.7104662182E+00, 9.2717580280E-01],
	[3.1105000000E+04, 2.2503635725E+01, 5.2044861555E+00, 7.5597302518E+00, 2.7110627169E+00, 9.2721139731E-01],
	[3.1110000000E+04, 2.2509659512E+01, 5.2044821492E+00, 7.5636973162E+00, 2.7116590910E+00, 9.2724697384E-01],
	[3.1115000000E+04, 2.2515683943E+01, 5.2044781435E+00, 7.5676658238E+00, 2.7122553406E+00, 9.2728253241E-01],
	[3.1120000000E+04, 2.2521709019E+01, 5.2044741384E+00, 7.5716357749E+00, 2.7128514656E+00, 9.2731807302E-01],
	[3.1125000000E+04, 2.2527734738E+01, 5.2044701340E+00, 7.5756071698E+00, 2.7134474660E+00, 9.2735359568E-01],
	[3.1130000000E+04, 2.2533761101E+01, 5.2044661303E+00, 7.5795800087E+00, 2.7140433417E+00, 9.2738910040E-01],
	[3.1135000000E+04, 2.2539788108E+01, 5.2044621272E+00, 7.5835542920E+00, 2.7146390928E+00, 9.2742458719E-01],
	[3.1140000000E+04, 2.2545815759E+01, 5.2044581247E+00, 7.5875300199E+00, 2.7152347193E+00, 9.2746005604E-01],
	[3.1145000000E+04, 2.2551844053E+01, 5.2044541229E+00, 7.5915071927E+00, 2.7158302211E+00, 9.2749550699E-01],
	[3.1150000000E+04, 2.2557872991E+01, 5.2044501217E+00, 7.5954858108E+00, 2.7164255981E+00, 9.2753094002E-01],
	[3.1155000000E+04, 2.2563902573E+01, 5.2044461212E+00, 7.5994658744E+00, 2.7170208505E+00, 9.2756635516E-01],
	[3.1160000000E+04, 2.2569932799E+01, 5.2044421213E+00, 7.6034473838E+00, 2.7176159781E+00, 9.2760175240E-01],
	[3.1165000000E+04, 2.2575963668E+01, 5.2044381221E+00, 7.6074303393E+00, 2.7182109809E+00, 9.2763713177E-01],
	[3.1170000000E+04, 2.2581995181E+01, 5.2044341235E+00, 7.6114147413E+00, 2.7188058590E+00, 9.2767249325E-01],
	[3.1175000000E+04, 2.2588027338E+01, 5.2044301256E+00, 7.6154005899E+00, 2.7194006123E+00, 9.2770783688E-01],
	[3.1180000000E+04, 2.2594060138E+01, 5.2044261283E+00, 7.6193878855E+00, 2.7199952407E+00, 9.2774316264E-01],
	[3.1185000000E+04, 2.2600093582E+01, 5.2044221316E+00, 7.6233766283E+00, 2.7205897444E+00, 9.2777847056E-01],
	[3.1190000000E+04, 2.2606127669E+01, 5.2044181356E+00, 7.6273668188E+00, 2.7211841231E+00, 9.2781376064E-01],
	[3.1195000000E+04, 2.2612162399E+01, 5.2044141403E+00, 7.6313584571E+00, 2.7217783770E+00, 9.2784903288E-01],
	[3.1200000000E+04, 2.2618197773E+01, 5.2044101455E+00, 7.6353515435E+00, 2.7223725060E+00, 9.2788428731E-01],
	[3.1205000000E+04, 2.2624233790E+01, 5.2044061514E+00, 7.6393460784E+00, 2.7229665101E+00, 9.2791952391E-01],
	[3.1210000000E+04, 2.2630270451E+01, 5.2044021580E+00, 7.6433420621E+00, 2.7235603893E+00, 9.2795474272E-01],
	[3.1215000000E+04, 2.2636307755E+01, 5.2043981652E+00, 7.6473394948E+00, 2.7241541435E+00, 9.2798994372E-01],
	[3.1220000000E+04, 2.2642345702E+01, 5.2043941731E+00, 7.6513383768E+00, 2.7247477728E+00, 9.2802512694E-01],
	[3.1225000000E+04, 2.2648384293E+01, 5.2043901815E+00, 7.6553387084E+00, 2.7253412770E+00, 9.2806029237E-01],
	[3.1230000000E+04, 2.2654423526E+01, 5.2043861907E+00, 7.6593404899E+00, 2.7259346563E+00, 9.2809544003E-01],
	[3.1235000000E+04, 2.2660463403E+01, 5.2043822005E+00, 7.6633437217E+00, 2.7265279106E+00, 9.2813056993E-01],
	[3.1240000000E+04, 2.2666503923E+01, 5.2043782109E+00, 7.6673484039E+00, 2.7271210398E+00, 9.2816568208E-01],
	[3.1245000000E+04, 2.2672545086E+01, 5.2043742219E+00, 7.6713545370E+00, 2.7277140439E+00, 9.2820077647E-01],
	[3.1250000000E+04, 2.2678586892E+01, 5.2043702336E+00, 7.6753621211E+00, 2.7283069230E+00, 9.2823585313E-01],
	[3.1255000000E+04, 2.2684629342E+01, 5.2043662460E+00, 7.6793711566E+00, 2.7288996770E+00, 9.2827091206E-01],
	[3.1260000000E+04, 2.2690672434E+01, 5.2043622589E+00, 7.6833816438E+00, 2.7294923059E+00, 9.2830595327E-01],
	[3.1265000000E+04, 2.2696716169E+01, 5.2043582726E+00, 7.6873935829E+00, 2.7300848096E+00, 9.2834097676E-01],
	[3.1270000000E+04, 2.2702760547E+01, 5.2043542868E+00, 7.6914069743E+00, 2.7306771882E+00, 9.2837598255E-01],
	[3.1275000000E+04, 2.2708805568E+01, 5.2043503017E+00, 7.6954218183E+00, 2.7312694417E+00, 9.2841097065E-01],
	[3.1280000000E+04, 2.2714851232E+01, 5.2043463173E+00, 7.6994381150E+00, 2.7318615699E+00, 9.2844594106E-01],
	[3.1285000000E+04, 2.2720897538E+01, 5.2043423335E+00, 7.7034558650E+00, 2.7324535730E+00, 9.2848089379E-01],
	[3.1290000000E+04, 2.2726944488E+01, 5.2043383503E+00, 7.7074750683E+00, 2.7330454508E+00, 9.2851582885E-01],
	[3.1295000000E+04, 2.2732992080E+01, 5.2043343677E+00, 7.7114957254E+00, 2.7336372034E+00, 9.2855074624E-01],
	[3.1300000000E+04, 2.2739040315E+01, 5.2043303858E+00, 7.7155178365E+00, 2.7342288308E+00, 9.2858564599E-01],
	[3.1305000000E+04, 2.2745089192E+01, 5.2043264046E+00, 7.7195414019E+00, 2.7348203328E+00, 9.2862052809E-01],
	[3.1310000000E+04, 2.2751138712E+01, 5.2043224240E+00, 7.7235664219E+00, 2.7354117096E+00, 9.2865539255E-01],
	[3.1315000000E+04, 2.2757188875E+01, 5.2043184440E+00, 7.7275928968E+00, 2.7360029611E+00, 9.2869023939E-01],
	[3.1320000000E+04, 2.2763239681E+01, 5.2043144646E+00, 7.7316208269E+00, 2.7365940873E+00, 9.2872506860E-01],
	[3.1325000000E+04, 2.2769291128E+01, 5.2043104859E+00, 7.7356502125E+00, 2.7371850881E+00, 9.2875988021E-01],
	[3.1330000000E+04, 2.2775343219E+01, 5.2043065078E+00, 7.7396810538E+00, 2.7377759636E+00, 9.2879467421E-01],
	[3.1335000000E+04, 2.2781395952E+01, 5.2043025304E+00, 7.7437133512E+00, 2.7383667136E+00, 9.2882945062E-01],
	[3.1340000000E+04, 2.2787449327E+01, 5.2042985536E+00, 7.7477471050E+00, 2.7389573383E+00, 9.2886420945E-01],
	[3.1345000000E+04, 2.2793503345E+01, 5.2042945775E+00, 7.7517823154E+00, 2.7395478376E+00, 9.2889895070E-01],
	[3.1350000000E+04, 2.2799558005E+01, 5.2042906020E+00, 7.7558189828E+00, 2.7401382115E+00, 9.2893367438E-01],
	[3.1355000000E+04, 2.2805613308E+01, 5.2042866271E+00, 7.7598571074E+00, 2.7407284599E+00, 9.2896838050E-01],
	[3.1360000000E+04, 2.2811669253E+01, 5.2042826528E+00, 7.7638966896E+00, 2.7413185829E+00, 9.2900306906E-01],
	[3.1365000000E+04, 2.2817725840E+01, 5.2042786792E+00, 7.7679377296E+00, 2.7419085804E+00, 9.2903774009E-01],
	[3.1370000000E+04, 2.2823783069E+01, 5.2042747062E+00, 7.7719802277E+00, 2.7424984523E+00, 9.2907239358E-01],
	[3.1375000000E+04, 2.2829840941E+01, 5.2042707339E+00, 7.7760241842E+00, 2.7430881988E+00, 9.2910702955E-01],
	[3.1380000000E+04, 2.2835918573E+01, 5.2042694950E+00, 7.7800695994E+00, 2.7436788553E+00, 9.2914164800E-01],
	[3.1385000000E+04, 2.2841998978E+01, 5.2042685596E+00, 7.7841164736E+00, 2.7442695018E+00, 9.2917624894E-01],
	[3.1390000000E+04, 2.2848080032E+01, 5.2042676244E+00, 7.7881648071E+00, 2.7448600234E+00, 9.2921083238E-01],
	[3.1395000000E+04, 2.2854161737E+01, 5.2042666893E+00, 7.7922146002E+00, 2.7454504200E+00, 9.2924539833E-01],
	[3.1400000000E+04, 2.2860244091E+01, 5.2042657543E+00, 7.7962658532E+00, 2.7460406917E+00, 9.2927994679E-01],
	[3.1405000000E+04, 2.2866327096E+01, 5.2042648195E+00, 7.8003185664E+00, 2.7466308385E+00, 9.2931447778E-01],
	[3.1410000000E+04, 2.2872410750E+01, 5.2042638849E+00, 7.8043727400E+00, 2.7472208602E+00, 9.2934899131E-01],
	[3.1415000000E+04, 2.2878495054E+01, 5.2042629504E+00, 7.8084283744E+00, 2.7478107570E+00, 9.2938348738E-01],
	[3.1420000000E+04, 2.2884580008E+01, 5.2042620160E+00, 7.8124854698E+00, 2.7484005287E+00, 9.2941796599E-01],
	[3.1425000000E+04, 2.2890665612E+01, 5.2042610818E+00, 7.8165440266E+00, 2.7489901754E+00, 9.2945242717E-01],
	[3.1430000000E+04, 2.2896751865E+01, 5.2042601478E+00, 7.8206040450E+00, 2.7495796970E+00, 9.2948687092E-01],
	[3.1435000000E+04, 2.2902838768E+01, 5.2042592139E+00, 7.8246655254E+00, 2.7501690936E+00, 9.2952129724E-01],
	[3.1440000000E+04, 2.2908926321E+01, 5.2042582801E+00, 7.8287284680E+00, 2.7507583651E+00, 9.2955570615E-01],
	[3.1445000000E+04, 2.2915014523E+01, 5.2042573465E+00, 7.8327928731E+00, 2.7513475115E+00, 9.2959009765E-01],
	[3.1450000000E+04, 2.2921103375E+01, 5.2042564130E+00, 7.8368587410E+00, 2.7519365328E+00, 9.2962447175E-01],
	[3.1455000000E+04, 2.2927192877E+01, 5.2042554797E+00, 7.8409260720E+00, 2.7525254290E+00, 9.2965882846E-01],
	[3.1460000000E+04, 2.2933283028E+01, 5.2042545466E+00, 7.8449948665E+00, 2.7531142000E+00, 9.2969316779E-01],
	[3.1465000000E+04, 2.2939373829E+01, 5.2042536135E+00, 7.8490651246E+00, 2.7537028458E+00, 9.2972748975E-01],
	[3.1470000000E+04, 2.2945465279E+01, 5.2042526807E+00, 7.8531368467E+00, 2.7542913665E+00, 9.2976179434E-01],
	[3.1475000000E+04, 2.2951557378E+01, 5.2042517480E+00, 7.8572100331E+00, 2.7548797619E+00, 9.2979608158E-01],
	[3.1480000000E+04, 2.2957650127E+01, 5.2042508154E+00, 7.8612846841E+00, 2.7554680322E+00, 9.2983035147E-01],
	[3.1485000000E+04, 2.2963743525E+01, 5.2042498830E+00, 7.8653608000E+00, 2.7560561772E+00, 9.2986460403E-01],
	[3.1490000000E+04, 2.2969837573E+01, 5.2042489507E+00, 7.8694383810E+00, 2.7566441970E+00, 9.2989883925E-01],
	[3.1495000000E+04, 2.2975932270E+01, 5.2042480186E+00, 7.8735174274E+00, 2.7572320915E+00, 9.2993305715E-01],
	[3.1500000000E+04, 2.2982027616E+01, 5.2042470866E+00, 7.8775979396E+00, 2.7578198608E+00, 9.2996725774E-01],
	[3.1505000000E+04, 2.2988123611E+01, 5.2042461548E+00, 7.8816799179E+00, 2.7584075047E+00, 9.3000144103E-01],
	[3.1510000000E+04, 2.2994220256E+01, 5.2042452231E+00, 7.8857633625E+00, 2.7589950234E+00, 9.3003560701E-01],
	[3.1515000000E+04, 2.3000317550E+01, 5.2042442916E+00, 7.8898482737E+00, 2.7595824167E+00, 9.3006975571E-01],
	[3.1520000000E+04, 2.3006415492E+01, 5.2042433602E+00, 7.8939346519E+00, 2.7601696847E+00, 9.3010388714E-01],
	[3.1525000000E+04, 2.3012514084E+01, 5.2042424289E+00, 7.8980224973E+00, 2.7607568273E+00, 9.3013800129E-01],
	[3.1530000000E+04, 2.3018613325E+01, 5.2042414979E+00, 7.9021118101E+00, 2.7613438446E+00, 9.3017209818E-01],
	[3.1535000000E+04, 2.3024713215E+01, 5.2042405669E+00, 7.9062025908E+00, 2.7619307365E+00, 9.3020617781E-01],
	[3.1540000000E+04, 2.3030813754E+01, 5.2042396361E+00, 7.9102948396E+00, 2.7625175030E+00, 9.3024024020E-01],
	[3.1545000000E+04, 2.3036914942E+01, 5.2042387055E+00, 7.9143885568E+00, 2.7631041441E+00, 9.3027428536E-01],
	[3.1550000000E+04, 2.3043016779E+01, 5.2042377750E+00, 7.9184837427E+00, 2.7636906597E+00, 9.3030831328E-01],
	[3.1555000000E+04, 2.3049119265E+01, 5.2042368446E+00, 7.9225803975E+00, 2.7642770499E+00, 9.3034232399E-01],
	[3.1560000000E+04, 2.3055222400E+01, 5.2042359144E+00, 7.9266785216E+00, 2.7648633146E+00, 9.3037631748E-01],
	[3.1565000000E+04, 2.3061326183E+01, 5.2042349844E+00, 7.9307781153E+00, 2.7654494539E+00, 9.3041029378E-01],
	[3.1570000000E+04, 2.3067430615E+01, 5.2042340545E+00, 7.9348791789E+00, 2.7660354677E+00, 9.3044425288E-01],
	[3.1575000000E+04, 2.3073535696E+01, 5.2042331247E+00, 7.9389817126E+00, 2.7666213560E+00, 9.3047819479E-01],
	[3.1580000000E+04, 2.3079641426E+01, 5.2042321951E+00, 7.9430857168E+00, 2.7672071187E+00, 9.3051211953E-01],
	[3.1585000000E+04, 2.3085747804E+01, 5.2042312656E+00, 7.9471911917E+00, 2.7677927559E+00, 9.3054602710E-01],
	[3.1590000000E+04, 2.3091854832E+01, 5.2042303363E+00, 7.9512981376E+00, 2.7683782676E+00, 9.3057991751E-01],
	[3.1595000000E+04, 2.3097962507E+01, 5.2042294072E+00, 7.9554065549E+00, 2.7689636537E+00, 9.3061379076E-01],
	[3.1600000000E+04, 2.3104070831E+01, 5.2042284781E+00, 7.9595164438E+00, 2.7695489142E+00, 9.3064764688E-01],
	[3.1605000000E+04, 2.3110179804E+01, 5.2042275493E+00, 7.9636278046E+00, 2.7701340491E+00, 9.3068148586E-01],
	[3.1610000000E+04, 2.3116289426E+01, 5.2042266205E+00, 7.9677406376E+00, 2.7707190584E+00, 9.3071530771E-01],
	[3.1615000000E+04, 2.3122399695E+01, 5.2042256919E+00, 7.9718549431E+00, 2.7713039421E+00, 9.3074911245E-01],
	[3.1620000000E+04, 2.3128510614E+01, 5.2042247635E+00, 7.9759707215E+00, 2.7718887002E+00, 9.3078290007E-01],
	[3.1625000000E+04, 2.3134622180E+01, 5.2042238352E+00, 7.9800879729E+00, 2.7724733326E+00, 9.3081667060E-01],
	[3.1630000000E+04, 2.3140734395E+01, 5.2042229071E+00, 7.9842066977E+00, 2.7730578393E+00, 9.3085042404E-01],
	[3.1635000000E+04, 2.3146847259E+01, 5.2042219791E+00, 7.9883268962E+00, 2.7736422204E+00, 9.3088416039E-01],
	[3.1640000000E+04, 2.3152960770E+01, 5.2042210512E+00, 7.9924485687E+00, 2.7742264758E+00, 9.3091787967E-01],
	[3.1645000000E+04, 2.3159074930E+01, 5.2042201235E+00, 7.9965717154E+00, 2.7748106054E+00, 9.3095158188E-01],
	[3.1650000000E+04, 2.3165189739E+01, 5.2042191960E+00, 8.0006963367E+00, 2.7753946093E+00, 9.3098526703E-01],
	[3.1655000000E+04, 2.3171305195E+01, 5.2042182686E+00, 8.0048224329E+00, 2.7759784875E+00, 9.3101893513E-01],
	[3.1660000000E+04, 2.3177421300E+01, 5.2042173413E+00, 8.0089500042E+00, 2.7765622400E+00, 9.3105258619E-01],
	[3.1665000000E+04, 2.3183538053E+01, 5.2042164142E+00, 8.0130790509E+00, 2.7771458666E+00, 9.3108622022E-01],
	[3.1670000000E+04, 2.3189655453E+01, 5.2042154872E+00, 8.0172095734E+00, 2.7777293675E+00, 9.3111983723E-01],
	[3.1675000000E+04, 2.3195773502E+01, 5.2042145604E+00, 8.0213415720E+00, 2.7783127426E+00, 9.3115343722E-01],
	[3.1680000000E+04, 2.3201892199E+01, 5.2042136337E+00, 8.0254750468E+00, 2.7788959919E+00, 9.3118702020E-01],
	[3.1685000000E+04, 2.3208011544E+01, 5.2042127072E+00, 8.0296099983E+00, 2.7794791154E+00, 9.3122058619E-01],
	[3.1690000000E+04, 2.3214131537E+01, 5.2042117808E+00, 8.0337464267E+00, 2.7800621130E+00, 9.3125413518E-01],
	[3.1695000000E+04, 2.3220252178E+01, 5.2042108546E+00, 8.0378843323E+00, 2.7806449848E+00, 9.3128766720E-01],
	[3.1700000000E+04, 2.3226373467E+01, 5.2042099285E+00, 8.0420237154E+00, 2.7812277307E+00, 9.3132118224E-01],
	[3.1705000000E+04, 2.3232495404E+01, 5.2042090026E+00, 8.0461645763E+00, 2.7818103508E+00, 9.3135468031E-01],
	[3.1710000000E+04, 2.3238617989E+01, 5.2042080768E+00, 8.0503069153E+00, 2.7823928449E+00, 9.3138816143E-01],
	[3.1715000000E+04, 2.3244741221E+01, 5.2042071511E+00, 8.0544507327E+00, 2.7829752132E+00, 9.3142162561E-01],
	[3.1720000000E+04, 2.3250865101E+01, 5.2042062256E+00, 8.0585960288E+00, 2.7835574555E+00, 9.3145507284E-01],
	[3.1725000000E+04, 2.3256989629E+01, 5.2042053003E+00, 8.0627428038E+00, 2.7841395719E+00, 9.3148850314E-01],
	[3.1730000000E+04, 2.3263114805E+01, 5.2042043751E+00, 8.0668910581E+00, 2.7847215623E+00, 9.3152191653E-01],
	[3.1735000000E+04, 2.3269240628E+01, 5.2042034500E+00, 8.0710407920E+00, 2.7853034268E+00, 9.3155531299E-01],
	[3.1740000000E+04, 2.3275367099E+01, 5.2042025251E+00, 8.0751920057E+00, 2.7858851654E+00, 9.3158869256E-01],
	[3.1745000000E+04, 2.3281494217E+01, 5.2042016003E+00, 8.0793446996E+00, 2.7864667779E+00, 9.3162205522E-01],
	[3.1750000000E+04, 2.3287621983E+01, 5.2042006757E+00, 8.0834988739E+00, 2.7870482644E+00, 9.3165540100E-01],
	[3.1755000000E+04, 2.3293750397E+01, 5.2041997512E+00, 8.0876545290E+00, 2.7876296250E+00, 9.3168872990E-01],
	[3.1760000000E+04, 2.3299879458E+01, 5.2041988268E+00, 8.0918116651E+00, 2.7882108595E+00, 9.3172204193E-01],
	[3.1765000000E+04, 2.3306009167E+01, 5.2041979027E+00, 8.0959702825E+00, 2.7887919679E+00, 9.3175533709E-01],
	[3.1770000000E+04, 2.3312139523E+01, 5.2041969786E+00, 8.1001303816E+00, 2.7893729504E+00, 9.3178861541E-01],
	[3.1775000000E+04, 2.3318270526E+01, 5.2041960547E+00, 8.1042919625E+00, 2.7899538067E+00, 9.3182187687E-01],
	[3.1780000000E+04, 2.3324402177E+01, 5.2041951310E+00, 8.1084550257E+00, 2.7905345370E+00, 9.3185512150E-01],
	[3.1785000000E+04, 2.3330534475E+01, 5.2041942073E+00, 8.1126195714E+00, 2.7911151412E+00, 9.3188834930E-01],
	[3.1790000000E+04, 2.3336667421E+01, 5.2041932839E+00, 8.1167855999E+00, 2.7916956193E+00, 9.3192156028E-01],
	[3.1795000000E+04, 2.3342801014E+01, 5.2041923606E+00, 8.1209531115E+00, 2.7922759713E+00, 9.3195475445E-01],
	[3.1800000000E+04, 2.3348935254E+01, 5.2041914374E+00, 8.1251221064E+00, 2.7928561971E+00, 9.3198793181E-01],
	[3.1805000000E+04, 2.3355070141E+01, 5.2041905144E+00, 8.1292925851E+00, 2.7934362968E+00, 9.3202109238E-01],
	[3.1810000000E+04, 2.3361205675E+01, 5.2041895915E+00, 8.1334645477E+00, 2.7940162704E+00, 9.3205423617E-01],
	[3.1815000000E+04, 2.3367341857E+01, 5.2041886687E+00, 8.1376379946E+00, 2.7945961178E+00, 9.3208736317E-01],
	[3.1820000000E+04, 2.3373478685E+01, 5.2041877462E+00, 8.1418129260E+00, 2.7951758390E+00, 9.3212047341E-01],
	[3.1825000000E+04, 2.3379616161E+01, 5.2041868237E+00, 8.1459893424E+00, 2.7957554340E+00, 9.3215356689E-01],
	[3.1830000000E+04, 2.3385754284E+01, 5.2041859014E+00, 8.1501672438E+00, 2.7963349028E+00, 9.3218664361E-01],
	[3.1835000000E+04, 2.3391893054E+01, 5.2041849793E+00, 8.1543466307E+00, 2.7969142454E+00, 9.3221970359E-01],
	[3.1840000000E+04, 2.3398032470E+01, 5.2041840572E+00, 8.1585275034E+00, 2.7974934618E+00, 9.3225274684E-01],
	[3.1845000000E+04, 2.3404172534E+01, 5.2041831354E+00, 8.1627098621E+00, 2.7980725519E+00, 9.3228577335E-01],
	[3.1850000000E+04, 2.3410313245E+01, 5.2041822137E+00, 8.1668937071E+00, 2.7986515158E+00, 9.3231878315E-01],
	[3.1855000000E+04, 2.3416454602E+01, 5.2041812921E+00, 8.1710790388E+00, 2.7992303534E+00, 9.3235177624E-01],
	[3.1860000000E+04, 2.3422596606E+01, 5.2041803706E+00, 8.1752658574E+00, 2.7998090647E+00, 9.3238475263E-01],
	[3.1865000000E+04, 2.3428739257E+01, 5.2041794494E+00, 8.1794541632E+00, 2.8003876498E+00, 9.3241771233E-01],
	[3.1870000000E+04, 2.3434882555E+01, 5.2041785282E+00, 8.1836439565E+00, 2.8009661085E+00, 9.3245065534E-01],
	[3.1875000000E+04, 2.3441026500E+01, 5.2041776072E+00, 8.1878352376E+00, 2.8015444410E+00, 9.3248358168E-01],
	[3.1880000000E+04, 2.3447171091E+01, 5.2041766864E+00, 8.1920280068E+00, 2.8021226471E+00, 9.3251649134E-01],
	[3.1885000000E+04, 2.3453334797E+01, 5.2041783823E+00, 8.1962222644E+00, 2.8027017495E+00, 9.3254938435E-01],
	[3.1890000000E+04, 2.3459501686E+01, 5.2041804364E+00, 8.2004180107E+00, 2.8032808663E+00, 9.3258226071E-01],
	[3.1895000000E+04, 2.3465669230E+01, 5.2041824902E+00, 8.2046152460E+00, 2.8038598573E+00, 9.3261512042E-01],
	[3.1900000000E+04, 2.3471837429E+01, 5.2041845436E+00, 8.2088139705E+00, 2.8044387225E+00, 9.3264796351E-01],
	[3.1905000000E+04, 2.3478006281E+01, 5.2041865968E+00, 8.2130141846E+00, 2.8050174620E+00, 9.3268078996E-01],
	[3.1910000000E+04, 2.3484175788E+01, 5.2041886496E+00, 8.2172158886E+00, 2.8055960757E+00, 9.3271359980E-01],
	[3.1915000000E+04, 2.3490345949E+01, 5.2041907021E+00, 8.2214190828E+00, 2.8061745637E+00, 9.3274639304E-01],
	[3.1920000000E+04, 2.3496516764E+01, 5.2041927542E+00, 8.2256237674E+00, 2.8067529258E+00, 9.3277916967E-01],
	[3.1925000000E+04, 2.3502688233E+01, 5.2041948061E+00, 8.2298299427E+00, 2.8073311621E+00, 9.3281192971E-01],
	[3.1930000000E+04, 2.3508860356E+01, 5.2041968576E+00, 8.2340376091E+00, 2.8079092726E+00, 9.3284467317E-01],
	[3.1935000000E+04, 2.3515033133E+01, 5.2041989088E+00, 8.2382467668E+00, 2.8084872573E+00, 9.3287740005E-01],
	[3.1940000000E+04, 2.3521206565E+01, 5.2042009597E+00, 8.2424574162E+00, 2.8090651161E+00, 9.3291011036E-01],
	[3.1945000000E+04, 2.3527380650E+01, 5.2042030103E+00, 8.2466695575E+00, 2.8096428490E+00, 9.3294280411E-01],
	[3.1950000000E+04, 2.3533555390E+01, 5.2042050605E+00, 8.2508831910E+00, 2.8102204561E+00, 9.3297548131E-01],
	[3.1955000000E+04, 2.3539730783E+01, 5.2042071104E+00, 8.2550983171E+00, 2.8107979373E+00, 9.3300814195E-01],
	[3.1960000000E+04, 2.3545906830E+01, 5.2042091600E+00, 8.2593149359E+00, 2.8113752926E+00, 9.3304078606E-01],
	[3.1965000000E+04, 2.3552083531E+01, 5.2042112093E+00, 8.2635330479E+00, 2.8119525220E+00, 9.3307341363E-01],
	[3.1970000000E+04, 2.3558260886E+01, 5.2042132583E+00, 8.2677526532E+00, 2.8125296255E+00, 9.3310602468E-01],
	[3.1975000000E+04, 2.3564438895E+01, 5.2042153069E+00, 8.2719737523E+00, 2.8131066031E+00, 9.3313861921E-01],
	[3.1980000000E+04, 2.3570617557E+01, 5.2042173553E+00, 8.2761963453E+00, 2.8136834547E+00, 9.3317119723E-01],
	[3.1985000000E+04, 2.3576796873E+01, 5.2042194033E+00, 8.2804204327E+00, 2.8142601804E+00, 9.3320375874E-01],
	[3.1990000000E+04, 2.3582976843E+01, 5.2042214509E+00, 8.2846460146E+00, 2.8148367801E+00, 9.3323630376E-01],
	[3.1995000000E+04, 2.3589157467E+01, 5.2042234983E+00, 8.2888730914E+00, 2.8154132538E+00, 9.3326883229E-01],
	[3.2000000000E+04, 2.3595338744E+01, 5.2042255454E+00, 8.2931016633E+00, 2.8159896016E+00, 9.3330134433E-01],
	[3.2005000000E+04, 2.3601520675E+01, 5.2042275921E+00, 8.2973317308E+00, 2.8165658233E+00, 9.3333383990E-01],
	[3.2010000000E+04, 2.3607703260E+01, 5.2042296385E+00, 8.3015632939E+00, 2.8171419191E+00, 9.3336631901E-01],
	[3.2015000000E+04, 2.3613886497E+01, 5.2042316846E+00, 8.3057963532E+00, 2.8177178888E+00, 9.3339878165E-01],
	[3.2020000000E+04, 2.3620070389E+01, 5.2042337304E+00, 8.3100309088E+00, 2.8182937326E+00, 9.3343122784E-01],
	[3.2025000000E+04, 2.3626254934E+01, 5.2042357758E+00, 8.3142669610E+00, 2.8188694502E+00, 9.3346365758E-01],
	[3.2030000000E+04, 2.3632440132E+01, 5.2042378210E+00, 8.3185045102E+00, 2.8194450419E+00, 9.3349607088E-01],
	[3.2035000000E+04, 2.3638625984E+01, 5.2042398658E+00, 8.3227435566E+00, 2.8200205074E+00, 9.3352846776E-01],
	[3.2040000000E+04, 2.3644812489E+01, 5.2042419103E+00, 8.3269841005E+00, 2.8205958469E+00, 9.3356084821E-01],
	[3.2045000000E+04, 2.3650999648E+01, 5.2042439545E+00, 8.3312261423E+00, 2.8211710604E+00, 9.3359321224E-01],
	[3.2050000000E+04, 2.3657187460E+01, 5.2042459983E+00, 8.3354696822E+00, 2.8217461477E+00, 9.3362555987E-01],
	[3.2055000000E+04, 2.3663375925E+01, 5.2042480419E+00, 8.3397147205E+00, 2.8223211089E+00, 9.3365789109E-01],
	[3.2060000000E+04, 2.3669565043E+01, 5.2042500851E+00, 8.3439612575E+00, 2.8228959440E+00, 9.3369020592E-01],
	[3.2065000000E+04, 2.3675754815E+01, 5.2042521280E+00, 8.3482092935E+00, 2.8234706530E+00, 9.3372250436E-01],
	[3.2070000000E+04, 2.3681945239E+01, 5.2042541706E+00, 8.3524588288E+00, 2.8240452359E+00, 9.3375478642E-01],
	[3.2075000000E+04, 2.3688136317E+01, 5.2042562129E+00, 8.3567098637E+00, 2.8246196926E+00, 9.3378705210E-01],
	[3.2080000000E+04, 2.3694328048E+01, 5.2042582548E+00, 8.3609623985E+00, 2.8251940232E+00, 9.3381930143E-01],
	[3.2085000000E+04, 2.3700520432E+01, 5.2042602965E+00, 8.3652164335E+00, 2.8257682276E+00, 9.3385153439E-01],
	[3.2090000000E+04, 2.3706713469E+01, 5.2042623378E+00, 8.3694719689E+00, 2.8263423058E+00, 9.3388375100E-01],
	[3.2095000000E+04, 2.3712907160E+01, 5.2042643788E+00, 8.3737290051E+00, 2.8269162579E+00, 9.3391595127E-01],
	[3.2100000000E+04, 2.3719101503E+01, 5.2042664195E+00, 8.3779875424E+00, 2.8274900837E+00, 9.3394813521E-01],
	[3.2105000000E+04, 2.3725296499E+01, 5.2042684599E+00, 8.3822475811E+00, 2.8280637834E+00, 9.3398030282E-01],
	[3.2110000000E+04, 2.3731492148E+01, 5.2042704999E+00, 8.3865091214E+00, 2.8286373568E+00, 9.3401245410E-01],
	[3.2115000000E+04, 2.3737688450E+01, 5.2042725396E+00, 8.3907721637E+00, 2.8292108040E+00, 9.3404458907E-01],
	[3.2120000000E+04, 2.3743885404E+01, 5.2042745791E+00, 8.3950367082E+00, 2.8297841250E+00, 9.3407670773E-01],
	[3.2125000000E+04, 2.3750083012E+01, 5.2042766182E+00, 8.3993027553E+00, 2.8303573197E+00, 9.3410881010E-01],
	[3.2130000000E+04, 2.3756281272E+01, 5.2042786570E+00, 8.4035703052E+00, 2.8309303882E+00, 9.3414089617E-01],
	[3.2135000000E+04, 2.3762480185E+01, 5.2042806954E+00, 8.4078393582E+00, 2.8315033304E+00, 9.3417296596E-01],
	[3.2140000000E+04, 2.3768679751E+01, 5.2042827336E+00, 8.4121099147E+00, 2.8320761463E+00, 9.3420501947E-01],
	[3.2145000000E+04, 2.3774879969E+01, 5.2042847714E+00, 8.4163819749E+00, 2.8326488360E+00, 9.3423705671E-01],
	[3.2150000000E+04, 2.3781080840E+01, 5.2042868089E+00, 8.4206555391E+00, 2.8332213993E+00, 9.3426907769E-01],
	[3.2155000000E+04, 2.3787282364E+01, 5.2042888461E+00, 8.4249306077E+00, 2.8337938364E+00, 9.3430108241E-01],
	[3.2160000000E+04, 2.3793484540E+01, 5.2042908830E+00, 8.4292071808E+00, 2.8343661472E+00, 9.3433307089E-01],
	[3.2165000000E+04, 2.3799687369E+01, 5.2042929196E+00, 8.4334852588E+00, 2.8349383316E+00, 9.3436504312E-01],
	[3.2170000000E+04, 2.3805890851E+01, 5.2042949559E+00, 8.4377648421E+00, 2.8355103897E+00, 9.3439699912E-01],
	[3.2175000000E+04, 2.3812094985E+01, 5.2042969918E+00, 8.4420459308E+00, 2.8360823214E+00, 9.3442893890E-01],
	[3.2180000000E+04, 2.3818299771E+01, 5.2042990274E+00, 8.4463285254E+00, 2.8366541268E+00, 9.3446086246E-01],
	[3.2185000000E+04, 2.3824505210E+01, 5.2043010628E+00, 8.4506126260E+00, 2.8372258059E+00, 9.3449276980E-01],
	[3.2190000000E+04, 2.3830711301E+01, 5.2043030977E+00, 8.4548982330E+00, 2.8377973585E+00, 9.3452466095E-01],
	[3.2195000000E+04, 2.3836918044E+01, 5.2043051324E+00, 8.4591853467E+00, 2.8383687848E+00, 9.3455653589E-01],
	[3.2200000000E+04, 2.3843125440E+01, 5.2043071668E+00, 8.4634739673E+00, 2.8389400848E+00, 9.3458839465E-01],
	[3.2205000000E+04, 2.3849333488E+01, 5.2043092008E+00, 8.4677640952E+00, 2.8395112583E+00, 9.3462023723E-01],
	[3.2210000000E+04, 2.3855542189E+01, 5.2043112346E+00, 8.4720557307E+00, 2.8400823054E+00, 9.3465206363E-01],
	[3.2215000000E+04, 2.3861751541E+01, 5.2043132680E+00, 8.4763488741E+00, 2.8406532261E+00, 9.3468387387E-01],
	[3.2220000000E+04, 2.3867961546E+01, 5.2043153011E+00, 8.4806435256E+00, 2.8412240203E+00, 9.3471566794E-01],
	[3.2225000000E+04, 2.3874172203E+01, 5.2043173339E+00, 8.4849396855E+00, 2.8417946882E+00, 9.3474744587E-01],
	[3.2230000000E+04, 2.3880383512E+01, 5.2043193664E+00, 8.4892373542E+00, 2.8423652296E+00, 9.3477920764E-01],
	[3.2235000000E+04, 2.3886595473E+01, 5.2043213985E+00, 8.4935365319E+00, 2.8429356445E+00, 9.3481095329E-01],
	[3.2240000000E+04, 2.3892808086E+01, 5.2043234304E+00, 8.4978372190E+00, 2.8435059330E+00, 9.3484268280E-01],
	[3.2245000000E+04, 2.3899021352E+01, 5.2043254619E+00, 8.5021394157E+00, 2.8440760950E+00, 9.3487439619E-01],
	[3.2250000000E+04, 2.3905235269E+01, 5.2043274931E+00, 8.5064431223E+00, 2.8446461306E+00, 9.3490609346E-01],
	[3.2255000000E+04, 2.3911449838E+01, 5.2043295240E+00, 8.5107483391E+00, 2.8452160396E+00, 9.3493777463E-01],
	[3.2260000000E+04, 2.3917665059E+01, 5.2043315546E+00, 8.5150550665E+00, 2.8457858222E+00, 9.3496943970E-01],
	[3.2265000000E+04, 2.3923880932E+01, 5.2043335849E+00, 8.5193633046E+00, 2.8463554783E+00, 9.3500108867E-01],
	[3.2270000000E+04, 2.3930097457E+01, 5.2043356149E+00, 8.5236730539E+00, 2.8469250078E+00, 9.3503272156E-01],
	[3.2275000000E+04, 2.3936314634E+01, 5.2043376445E+00, 8.5279843146E+00, 2.8474944108E+00, 9.3506433837E-01],
	[3.2280000000E+04, 2.3942532463E+01, 5.2043396739E+00, 8.5322970870E+00, 2.8480636873E+00, 9.3509593911E-01],
	[3.2285000000E+04, 2.3948750943E+01, 5.2043417029E+00, 8.5366113713E+00, 2.8486328373E+00, 9.3512752378E-01],
	[3.2290000000E+04, 2.3954970075E+01, 5.2043437316E+00, 8.5409271680E+00, 2.8492018607E+00, 9.3515909240E-01],
	[3.2295000000E+04, 2.3961189859E+01, 5.2043457600E+00, 8.5452444772E+00, 2.8497707576E+00, 9.3519064497E-01],
	[3.2300000000E+04, 2.3967410294E+01, 5.2043477881E+00, 8.5495632994E+00, 2.8503395279E+00, 9.3522218151E-01],
	[3.2305000000E+04, 2.3973631381E+01, 5.2043498158E+00, 8.5538836347E+00, 2.8509081716E+00, 9.3525370200E-01],
	[3.2310000000E+04, 2.3979853120E+01, 5.2043518433E+00, 8.5582054834E+00, 2.8514766888E+00, 9.3528520647E-01],
	[3.2315000000E+04, 2.3986075510E+01, 5.2043538704E+00, 8.5625288460E+00, 2.8520450793E+00, 9.3531669492E-01],
	[3.2320000000E+04, 2.3992298552E+01, 5.2043558973E+00, 8.5668537226E+00, 2.8526133433E+00, 9.3534816736E-01],
	[3.2325000000E+04, 2.3998522245E+01, 5.2043579238E+00, 8.5711801135E+00, 2.8531814807E+00, 9.3537962380E-01],
	[3.2330000000E+04, 2.4004746590E+01, 5.2043599500E+00, 8.5755080191E+00, 2.8537494915E+00, 9.3541106424E-01],
	[3.2335000000E+04, 2.4010971586E+01, 5.2043619759E+00, 8.5798374397E+00, 2.8543173756E+00, 9.3544248869E-01],
	[3.2340000000E+04, 2.4017197234E+01, 5.2043640015E+00, 8.5841683755E+00, 2.8548851331E+00, 9.3547389716E-01],
	[3.2345000000E+04, 2.4023423533E+01, 5.2043660267E+00, 8.5885008268E+00, 2.8554527640E+00, 9.3550528965E-01],
	[3.2350000000E+04, 2.4029650483E+01, 5.2043680517E+00, 8.5928347940E+00, 2.8560202682E+00, 9.3553666618E-01],
	[3.2355000000E+04, 2.4035878085E+01, 5.2043700763E+00, 8.5971702773E+00, 2.8565876458E+00, 9.3556802675E-01],
	[3.2360000000E+04, 2.4042106338E+01, 5.2043721007E+00, 8.6015072770E+00, 2.8571548968E+00, 9.3559937136E-01],
	[3.2365000000E+04, 2.4048335242E+01, 5.2043741247E+00, 8.6058457935E+00, 2.8577220210E+00, 9.3563070003E-01],
	[3.2370000000E+04, 2.4054564797E+01, 5.2043761484E+00, 8.6101858270E+00, 2.8582890186E+00, 9.3566201277E-01],
	[3.2375000000E+04, 2.4060795004E+01, 5.2043781718E+00, 8.6145273778E+00, 2.8588558895E+00, 9.3569330957E-01],
	[3.2380000000E+04, 2.4067025862E+01, 5.2043801949E+00, 8.6188704462E+00, 2.8594226337E+00, 9.3572459045E-01],
	[3.2385000000E+04, 2.4073257371E+01, 5.2043822176E+00, 8.6232150325E+00, 2.8599892513E+00, 9.3575585542E-01],
	[3.2390000000E+04, 2.4079489530E+01, 5.2043842401E+00, 8.6275611370E+00, 2.8605557421E+00, 9.3578710448E-01],
	[3.2395000000E+04, 2.4085727168E+01, 5.2043869406E+00, 8.6319087600E+00, 2.8611223793E+00, 9.3581833764E-01],
	[3.2400000000E+04, 2.4091981381E+01, 5.2043918777E+00, 8.6362579018E+00, 2.8616897910E+00, 9.3584955490E-01],
	[3.2405000000E+04, 2.4098236252E+01, 5.2043968140E+00, 8.6406088913E+00, 2.8622571126E+00, 9.3588075628E-01],
	[3.2410000000E+04, 2.4104491782E+01, 5.2044017496E+00, 8.6449623362E+00, 2.8628244106E+00, 9.3591194178E-01],
	[3.2415000000E+04, 2.4110747970E+01, 5.2044066845E+00, 8.6493173019E+00, 2.8633915825E+00, 9.3594311142E-01],
	[3.2420000000E+04, 2.4117004817E+01, 5.2044116185E+00, 8.6536737887E+00, 2.8639586282E+00, 9.3597426519E-01],
	[3.2425000000E+04, 2.4123262322E+01, 5.2044165519E+00, 8.6580317969E+00, 2.8645255476E+00, 9.3600540310E-01],
	[3.2430000000E+04, 2.4129520485E+01, 5.2044214844E+00, 8.6623913269E+00, 2.8650923409E+00, 9.3603652517E-01],
	[3.2435000000E+04, 2.4135779307E+01, 5.2044264162E+00, 8.6667523789E+00, 2.8656590079E+00, 9.3606763139E-01],
	[3.2440000000E+04, 2.4142038787E+01, 5.2044313473E+00, 8.6711149532E+00, 2.8662255487E+00, 9.3609872178E-01],
	[3.2445000000E+04, 2.4148298925E+01, 5.2044362776E+00, 8.6754790500E+00, 2.8667919633E+00, 9.3612979635E-01],
	[3.2450000000E+04, 2.4154559722E+01, 5.2044412071E+00, 8.6798446698E+00, 2.8673582516E+00, 9.3616085510E-01],
	[3.2455000000E+04, 2.4160821177E+01, 5.2044461359E+00, 8.6842118128E+00, 2.8679244137E+00, 9.3619189803E-01],
	[3.2460000000E+04, 2.4167083290E+01, 5.2044510640E+00, 8.6885804793E+00, 2.8684904495E+00, 9.3622292517E-01],
	[3.2465000000E+04, 2.4173346061E+01, 5.2044559912E+00, 8.6929506696E+00, 2.8690563591E+00, 9.3625393651E-01],
	[3.2470000000E+04, 2.4179609490E+01, 5.2044609178E+00, 8.6973223839E+00, 2.8696221424E+00, 9.3628493206E-01],
	[3.2475000000E+04, 2.4185873577E+01, 5.2044658435E+00, 8.7016956226E+00, 2.8701877994E+00, 9.3631591182E-01],
	[3.2480000000E+04, 2.4192138323E+01, 5.2044707685E+00, 8.7060703861E+00, 2.8707533302E+00, 9.3634687582E-01],
	[3.2485000000E+04, 2.4198403726E+01, 5.2044756928E+00, 8.7104466745E+00, 2.8713187346E+00, 9.3637782405E-01],
	[3.2490000000E+04, 2.4204669788E+01, 5.2044806163E+00, 8.7148244881E+00, 2.8718840128E+00, 9.3640875652E-01],
	[3.2495000000E+04, 2.4210936507E+01, 5.2044855391E+00, 8.7192038274E+00, 2.8724491646E+00, 9.3643967323E-01],
	[3.2500000000E+04, 2.4217203884E+01, 5.2044904611E+00, 8.7235846925E+00, 2.8730141902E+00, 9.3647057421E-01],
	[3.2505000000E+04, 2.4223471920E+01, 5.2044953823E+00, 8.7279670837E+00, 2.8735790894E+00, 9.3650145945E-01],
	[3.2510000000E+04, 2.4229740613E+01, 5.2045003028E+00, 8.7323510015E+00, 2.8741438623E+00, 9.3653232896E-01],
	[3.2515000000E+04, 2.4236009964E+01, 5.2045052226E+00, 8.7367364459E+00, 2.8747085089E+00, 9.3656318275E-01],
	[3.2520000000E+04, 2.4242279972E+01, 5.2045101416E+00, 8.7411234175E+00, 2.8752730291E+00, 9.3659402082E-01],
	[3.2525000000E+04, 2.4248550639E+01, 5.2045150598E+00, 8.7455119164E+00, 2.8758374230E+00, 9.3662484319E-01],
	[3.2530000000E+04, 2.4254821963E+01, 5.2045199773E+00, 8.7499019429E+00, 2.8764016905E+00, 9.3665564986E-01],
	[3.2535000000E+04, 2.4261093945E+01, 5.2045248941E+00, 8.7542934974E+00, 2.8769658317E+00, 9.3668644083E-01],
	[3.2540000000E+04, 2.4267366585E+01, 5.2045298101E+00, 8.7586865801E+00, 2.8775298465E+00, 9.3671721613E-01],
	[3.2545000000E+04, 2.4273639882E+01, 5.2045347253E+00, 8.7630811913E+00, 2.8780937350E+00, 9.3674797574E-01],
	[3.2550000000E+04, 2.4279913837E+01, 5.2045396398E+00, 8.7674773314E+00, 2.8786574970E+00, 9.3677871969E-01],
	[3.2555000000E+04, 2.4286188449E+01, 5.2045445535E+00, 8.7718750006E+00, 2.8792211327E+00, 9.3680944797E-01],
	[3.2560000000E+04, 2.4292463719E+01, 5.2045494665E+00, 8.7762741992E+00, 2.8797846420E+00, 9.3684016061E-01],
	[3.2565000000E+04, 2.4298739647E+01, 5.2045543788E+00, 8.7806749275E+00, 2.8803480249E+00, 9.3687085759E-01],
	[3.2570000000E+04, 2.4305016232E+01, 5.2045592902E+00, 8.7850771859E+00, 2.8809112814E+00, 9.3690153894E-01],
	[3.2575000000E+04, 2.4311293474E+01, 5.2045642010E+00, 8.7894809746E+00, 2.8814744115E+00, 9.3693220465E-01],
	[3.2580000000E+04, 2.4317571374E+01, 5.2045691110E+00, 8.7938862939E+00, 2.8820374152E+00, 9.3696285474E-01],
	[3.2585000000E+04, 2.4323849931E+01, 5.2045740202E+00, 8.7982931441E+00, 2.8826002925E+00, 9.3699348921E-01],
	[3.2590000000E+04, 2.4330129146E+01, 5.2045789287E+00, 8.8027015255E+00, 2.8831630433E+00, 9.3702410807E-01],
	[3.2595000000E+04, 2.4336409017E+01, 5.2045838365E+00, 8.8071114384E+00, 2.8837256677E+00, 9.3705471133E-01],
	[3.2600000000E+04, 2.4342689547E+01, 5.2045887435E+00, 8.8115228831E+00, 2.8842881657E+00, 9.3708529900E-01],
	[3.2605000000E+04, 2.4348970733E+01, 5.2045936497E+00, 8.8159358599E+00, 2.8848505372E+00, 9.3711587108E-01],
	[3.2610000000E+04, 2.4355252577E+01, 5.2045985552E+00, 8.8203503691E+00, 2.8854127823E+00, 9.3714642758E-01],
	[3.2615000000E+04, 2.4361535077E+01, 5.2046034600E+00, 8.8247664109E+00, 2.8859749009E+00, 9.3717696850E-01],
	[3.2620000000E+04, 2.4367818235E+01, 5.2046083640E+00, 8.8291839858E+00, 2.8865368930E+00, 9.3720749387E-01],
	[3.2625000000E+04, 2.4374102050E+01, 5.2046132672E+00, 8.8336030939E+00, 2.8870987587E+00, 9.3723800367E-01],
	[3.2630000000E+04, 2.4380386523E+01, 5.2046181698E+00, 8.8380237357E+00, 2.8876604979E+00, 9.3726849793E-01],
	[3.2635000000E+04, 2.4386671652E+01, 5.2046230715E+00, 8.8424459113E+00, 2.8882221107E+00, 9.3729897664E-01],
	[3.2640000000E+04, 2.4392957438E+01, 5.2046279725E+00, 8.8468696210E+00, 2.8887835969E+00, 9.3732943982E-01],
	[3.2645000000E+04, 2.4399243881E+01, 5.2046328728E+00, 8.8512948653E+00, 2.8893449567E+00, 9.3735988747E-01],
	[3.2650000000E+04, 2.4405530982E+01, 5.2046377723E+00, 8.8557216443E+00, 2.8899061900E+00, 9.3739031961E-01],
	[3.2655000000E+04, 2.4411818739E+01, 5.2046426711E+00, 8.8601499584E+00, 2.8904672967E+00, 9.3742073623E-01],
	[3.2660000000E+04, 2.4418107153E+01, 5.2046475692E+00, 8.8645798078E+00, 2.8910282770E+00, 9.3745113734E-01],
	[3.2665000000E+04, 2.4424396224E+01, 5.2046524665E+00, 8.8690111929E+00, 2.8915891308E+00, 9.3748152296E-01],
	[3.2670000000E+04, 2.4430685952E+01, 5.2046573630E+00, 8.8734441139E+00, 2.8921498580E+00, 9.3751189309E-01],
	[3.2675000000E+04, 2.4436976336E+01, 5.2046622588E+00, 8.8778785712E+00, 2.8927104587E+00, 9.3754224773E-01],
	[3.2680000000E+04, 2.4443267378E+01, 5.2046671539E+00, 8.8823145650E+00, 2.8932709329E+00, 9.3757258690E-01],
	[3.2685000000E+04, 2.4449559076E+01, 5.2046720482E+00, 8.8867520957E+00, 2.8938312805E+00, 9.3760291061E-01],
	[3.2690000000E+04, 2.4455851431E+01, 5.2046769418E+00, 8.8911911635E+00, 2.8943915017E+00, 9.3763321885E-01],
	[3.2695000000E+04, 2.4462144442E+01, 5.2046818346E+00, 8.8956317688E+00, 2.8949515962E+00, 9.3766351164E-01],
	[3.2700000000E+04, 2.4468438110E+01, 5.2046867267E+00, 8.9000739118E+00, 2.8955115642E+00, 9.3769378899E-01],
	[3.2705000000E+04, 2.4474732435E+01, 5.2046916180E+00, 8.9045175928E+00, 2.8960714057E+00, 9.3772405090E-01],
	[3.2710000000E+04, 2.4481027416E+01, 5.2046965086E+00, 8.9089628122E+00, 2.8966311206E+00, 9.3775429738E-01],
	[3.2715000000E+04, 2.4487323054E+01, 5.2047013985E+00, 8.9134095702E+00, 2.8971907090E+00, 9.3778452843E-01],
	[3.2720000000E+04, 2.4493619349E+01, 5.2047062876E+00, 8.9178578671E+00, 2.8977501708E+00, 9.3781474407E-01],
	[3.2725000000E+04, 2.4499916300E+01, 5.2047111759E+00, 8.9223077032E+00, 2.8983095060E+00, 9.3784494431E-01],
	[3.2730000000E+04, 2.4506213907E+01, 5.2047160636E+00, 8.9267590789E+00, 2.8988687146E+00, 9.3787512914E-01],
	[3.2735000000E+04, 2.4512512171E+01, 5.2047209504E+00, 8.9312119943E+00, 2.8994277966E+00, 9.3790529858E-01],
	[3.2740000000E+04, 2.4518811091E+01, 5.2047258366E+00, 8.9356664499E+00, 2.8999867521E+00, 9.3793545264E-01],
	[3.2745000000E+04, 2.4525110667E+01, 5.2047307220E+00, 8.9401224459E+00, 2.9005455810E+00, 9.3796559132E-01],
	[3.2750000000E+04, 2.4531410900E+01, 5.2047356067E+00, 8.9445799826E+00, 2.9011042832E+00, 9.3799571463E-01],
	[3.2755000000E+04, 2.4537711790E+01, 5.2047404906E+00, 8.9490390602E+00, 2.9016628589E+00, 9.3802582257E-01],
	[3.2760000000E+04, 2.4544013335E+01, 5.2047453737E+00, 8.9534996792E+00, 2.9022213080E+00, 9.3805591516E-01],
	[3.2765000000E+04, 2.4550315537E+01, 5.2047502562E+00, 8.9579618398E+00, 2.9027796304E+00, 9.3808599241E-01],
	[3.2770000000E+04, 2.4556618394E+01, 5.2047551379E+00, 8.9624255423E+00, 2.9033378263E+00, 9.3811605431E-01],
	[3.2775000000E+04, 2.4562921909E+01, 5.2047600188E+00, 8.9668907870E+00, 2.9038958955E+00, 9.3814610088E-01],
	[3.2780000000E+04, 2.4569226079E+01, 5.2047648991E+00, 8.9713575741E+00, 2.9044538381E+00, 9.3817613213E-01],
	[3.2785000000E+04, 2.4575530905E+01, 5.2047697785E+00, 8.9758259041E+00, 2.9050116540E+00, 9.3820614806E-01],
	[3.2790000000E+04, 2.4581836387E+01, 5.2047746573E+00, 8.9802957771E+00, 2.9055693434E+00, 9.3823614867E-01],
	[3.2795000000E+04, 2.4588142526E+01, 5.2047795353E+00, 8.9847671935E+00, 2.9061269061E+00, 9.3826613399E-01],
	[3.2800000000E+04, 2.4594449320E+01, 5.2047844125E+00, 8.9892401536E+00, 2.9066843421E+00, 9.3829610401E-01],
	[3.2805000000E+04, 2.4600756770E+01, 5.2047892890E+00, 8.9937146576E+00, 2.9072416515E+00, 9.3832605874E-01],
	[3.2810000000E+04, 2.4607064877E+01, 5.2047941648E+00, 8.9981907060E+00, 2.9077988343E+00, 9.3835599820E-01],
	[3.2815000000E+04, 2.4613373639E+01, 5.2047990399E+00, 9.0026682989E+00, 2.9083558904E+00, 9.3838592238E-01],
	[3.2820000000E+04, 2.4619683057E+01, 5.2048039142E+00, 9.0071474366E+00, 2.9089128198E+00, 9.3841583129E-01],
	[3.2825000000E+04, 2.4625993131E+01, 5.2048087877E+00, 9.0116281196E+00, 2.9094696226E+00, 9.3844572495E-01],
	[3.2830000000E+04, 2.4632303861E+01, 5.2048136606E+00, 9.0161103479E+00, 2.9100262987E+00, 9.3847560335E-01],
	[3.2835000000E+04, 2.4638615246E+01, 5.2048185327E+00, 9.0205941221E+00, 2.9105828482E+00, 9.3850546652E-01],
	[3.2840000000E+04, 2.4644927288E+01, 5.2048234040E+00, 9.0250794423E+00, 2.9111392709E+00, 9.3853531445E-01],
	[3.2845000000E+04, 2.4651239985E+01, 5.2048282746E+00, 9.0295663088E+00, 2.9116955670E+00, 9.3856514715E-01],
	[3.2850000000E+04, 2.4657553338E+01, 5.2048331445E+00, 9.0340547220E+00, 2.9122517364E+00, 9.3859496463E-01],
	[3.2855000000E+04, 2.4663867346E+01, 5.2048380137E+00, 9.0385446822E+00, 2.9128077791E+00, 9.3862476690E-01],
	[3.2860000000E+04, 2.4670182010E+01, 5.2048428821E+00, 9.0430361896E+00, 2.9133636952E+00, 9.3865455396E-01],
	[3.2865000000E+04, 2.4676497330E+01, 5.2048477497E+00, 9.0475292445E+00, 2.9139194845E+00, 9.3868432583E-01],
	[3.2870000000E+04, 2.4682813305E+01, 5.2048526167E+00, 9.0520238473E+00, 2.9144751472E+00, 9.3871408250E-01],
	[3.2875000000E+04, 2.4689129936E+01, 5.2048574829E+00, 9.0565199982E+00, 2.9150306831E+00, 9.3874382399E-01],
	[3.2880000000E+04, 2.4695447222E+01, 5.2048623483E+00, 9.0610176976E+00, 2.9155860923E+00, 9.3877355031E-01],
	[3.2885000000E+04, 2.4701765164E+01, 5.2048672131E+00, 9.0655169456E+00, 2.9161413749E+00, 9.3880326146E-01],
	[3.2890000000E+04, 2.4708083761E+01, 5.2048720771E+00, 9.0700177427E+00, 2.9166965307E+00, 9.3883295745E-01],
	[3.2895000000E+04, 2.4714403013E+01, 5.2048769403E+00, 9.0745200892E+00, 2.9172515598E+00, 9.3886263829E-01],
	[3.2900000000E+04, 2.4720722921E+01, 5.2048818028E+00, 9.0790239852E+00, 2.9178064621E+00, 9.3889230398E-01],
	[3.2905000000E+04, 2.4727043484E+01, 5.2048866646E+00, 9.0835294312E+00, 2.9183612378E+00, 9.3892195453E-01],
	[3.2910000000E+04, 2.4733364703E+01, 5.2048915257E+00, 9.0880364274E+00, 2.9189158867E+00, 9.3895158995E-01],
	[3.2915000000E+04, 2.4739686577E+01, 5.2048963860E+00, 9.0925449741E+00, 2.9194704089E+00, 9.3898121025E-01],
	[3.2920000000E+04, 2.4746028233E+01, 5.2049039121E+00, 9.0970550716E+00, 2.9200259100E+00, 9.3901081544E-01],
	[3.2925000000E+04, 2.4752371918E+01, 5.2049116275E+00, 9.1015667203E+00, 2.9205813638E+00, 9.3904040552E-01],
	[3.2930000000E+04, 2.4758716265E+01, 5.2049193418E+00, 9.1060799203E+00, 2.9211366915E+00, 9.3906998049E-01],
	[3.2935000000E+04, 2.4765061275E+01, 5.2049270549E+00, 9.1105946721E+00, 2.9216918930E+00, 9.3909954038E-01],
	[3.2940000000E+04, 2.4771406947E+01, 5.2049347669E+00, 9.1151109758E+00, 2.9222469683E+00, 9.3912908518E-01],
	[3.2945000000E+04, 2.4777753282E+01, 5.2049424777E+00, 9.1196288319E+00, 2.9228019175E+00, 9.3915861490E-01],
	[3.2950000000E+04, 2.4784100280E+01, 5.2049501873E+00, 9.1241482405E+00, 2.9233567404E+00, 9.3918812955E-01],
	[3.2955000000E+04, 2.4790447939E+01, 5.2049578958E+00, 9.1286692021E+00, 2.9239114372E+00, 9.3921762913E-01],
	[3.2960000000E+04, 2.4796796261E+01, 5.2049656031E+00, 9.1331917168E+00, 2.9244660078E+00, 9.3924711367E-01],
	[3.2965000000E+04, 2.4803145246E+01, 5.2049733093E+00, 9.1377157851E+00, 2.9250204522E+00, 9.3927658315E-01],
	[3.2970000000E+04, 2.4809494893E+01, 5.2049810143E+00, 9.1422414071E+00, 2.9255747704E+00, 9.3930603760E-01],
	[3.2975000000E+04, 2.4815845202E+01, 5.2049887182E+00, 9.1467685832E+00, 2.9261289624E+00, 9.3933547701E-01],
	[3.2980000000E+04, 2.4822196173E+01, 5.2049964209E+00, 9.1512973137E+00, 2.9266830283E+00, 9.3936490139E-01],
	[3.2985000000E+04, 2.4828547806E+01, 5.2050041224E+00, 9.1558275989E+00, 2.9272369679E+00, 9.3939431076E-01],
	[3.2990000000E+04, 2.4834900102E+01, 5.2050118228E+00, 9.1603594390E+00, 2.9277907813E+00, 9.3942370512E-01],
	[3.2995000000E+04, 2.4841253060E+01, 5.2050195220E+00, 9.1648928345E+00, 2.9283444685E+00, 9.3945308447E-01],
	[3.3000000000E+04, 2.4847606680E+01, 5.2050272201E+00, 9.1694277855E+00, 2.9288980295E+00, 9.3948244883E-01],
	[3.3005000000E+04, 2.4853960962E+01, 5.2050349170E+00, 9.1739642923E+00, 2.9294514643E+00, 9.3951179821E-01],
	[3.3010000000E+04, 2.4860315906E+01, 5.2050426128E+00, 9.1785023554E+00, 2.9300047728E+00, 9.3954113260E-01],
	[3.3015000000E+04, 2.4866671512E+01, 5.2050503074E+00, 9.1830419749E+00, 2.9305579551E+00, 9.3957045202E-01],
	[3.3020000000E+04, 2.4873027780E+01, 5.2050580008E+00, 9.1875831512E+00, 2.9311110113E+00, 9.3959975647E-01],
	[3.3025000000E+04, 2.4879384710E+01, 5.2050656931E+00, 9.1921258846E+00, 2.9316639411E+00, 9.3962904596E-01],
	[3.3030000000E+04, 2.4885742302E+01, 5.2050733843E+00, 9.1966701753E+00, 2.9322167448E+00, 9.3965832051E-01],
	[3.3035000000E+04, 2.4892100556E+01, 5.2050810743E+00, 9.2012160236E+00, 2.9327694222E+00, 9.3968758011E-01],
	[3.3040000000E+04, 2.4898459472E+01, 5.2050887631E+00, 9.2057634300E+00, 2.9333219734E+00, 9.3971682478E-01],
	[3.3045000000E+04, 2.4904819050E+01, 5.2050964508E+00, 9.2103123945E+00, 2.9338743984E+00, 9.3974605451E-01],
	[3.3050000000E+04, 2.4911179289E+01, 5.2051041373E+00, 9.2148629177E+00, 2.9344266971E+00, 9.3977526933E-01],
	[3.3055000000E+04, 2.4917540190E+01, 5.2051118227E+00, 9.2194149996E+00, 2.9349788696E+00, 9.3980446924E-01],
	[3.3060000000E+04, 2.4923901753E+01, 5.2051195070E+00, 9.2239686408E+00, 2.9355309158E+00, 9.3983365424E-01],
	[3.3065000000E+04, 2.4930263978E+01, 5.2051271900E+00, 9.2285238414E+00, 2.9360828358E+00, 9.3986282434E-01],
	[3.3070000000E+04, 2.4936626864E+01, 5.2051348720E+00, 9.2330806017E+00, 2.9366346295E+00, 9.3989197955E-01],
	[3.3075000000E+04, 2.4942990412E+01, 5.2051425528E+00, 9.2376389220E+00, 2.9371862970E+00, 9.3992111988E-01],
	[3.3080000000E+04, 2.4949354622E+01, 5.2051502324E+00, 9.2421988027E+00, 2.9377378383E+00, 9.3995024533E-01],
	[3.3085000000E+04, 2.4955719493E+01, 5.2051579109E+00, 9.2467602441E+00, 2.9382892532E+00, 9.3997935591E-01],
	[3.3090000000E+04, 2.4962085026E+01, 5.2051655882E+00, 9.2513232463E+00, 2.9388405420E+00, 9.4000845164E-01],
	[3.3095000000E+04, 2.4968451221E+01, 5.2051732644E+00, 9.2558878098E+00, 2.9393917044E+00, 9.4003753251E-01],
	[3.3100000000E+04, 2.4974818076E+01, 5.2051809394E+00, 9.2604539349E+00, 2.9399427406E+00, 9.4006659853E-01],
	[3.3105000000E+04, 2.4981185594E+01, 5.2051886133E+00, 9.2650216217E+00, 2.9404936506E+00, 9.4009564972E-01],
	[3.3110000000E+04, 2.4987553773E+01, 5.2051962861E+00, 9.2695908707E+00, 2.9410444342E+00, 9.4012468607E-01],
	[3.3115000000E+04, 2.4993922613E+01, 5.2052039577E+00, 9.2741616822E+00, 2.9415950916E+00, 9.4015370761E-01],
	[3.3120000000E+04, 2.5000292114E+01, 5.2052116281E+00, 9.2787340563E+00, 2.9421456228E+00, 9.4018271433E-01],
	[3.3125000000E+04, 2.5006662277E+01, 5.2052192974E+00, 9.2833079934E+00, 2.9426960276E+00, 9.4021170623E-01],
	[3.3130000000E+04, 2.5013033101E+01, 5.2052269656E+00, 9.2878834939E+00, 2.9432463062E+00, 9.4024068334E-01],
	[3.3135000000E+04, 2.5019404587E+01, 5.2052346326E+00, 9.2924605580E+00, 2.9437964585E+00, 9.4026964566E-01],
	[3.3140000000E+04, 2.5025776733E+01, 5.2052422985E+00, 9.2970391860E+00, 2.9443464846E+00, 9.4029859319E-01],
	[3.3145000000E+04, 2.5032149541E+01, 5.2052499632E+00, 9.3016193782E+00, 2.9448963843E+00, 9.4032752594E-01],
	[3.3150000000E+04, 2.5038523010E+01, 5.2052576268E+00, 9.3062011350E+00, 2.9454461578E+00, 9.4035644392E-01],
	[3.3155000000E+04, 2.5044897141E+01, 5.2052652892E+00, 9.3107844565E+00, 2.9459958050E+00, 9.4038534714E-01],
	[3.3160000000E+04, 2.5051271932E+01, 5.2052729505E+00, 9.3153693432E+00, 2.9465453259E+00, 9.4041423560E-01],
	[3.3165000000E+04, 2.5057647385E+01, 5.2052806106E+00, 9.3199557952E+00, 2.9470947205E+00, 9.4044310931E-01],
	[3.3170000000E+04, 2.5064023498E+01, 5.2052882696E+00, 9.3245438130E+00, 2.9476439888E+00, 9.4047196829E-01],
	[3.3175000000E+04, 2.5070400273E+01, 5.2052959275E+00, 9.3291333967E+00, 2.9481931308E+00, 9.4050081253E-01],
	[3.3180000000E+04, 2.5076777708E+01, 5.2053035842E+00, 9.3337245468E+00, 2.9487421466E+00, 9.4052964204E-01],
	[3.3185000000E+04, 2.5083155805E+01, 5.2053112398E+00, 9.3383172634E+00, 2.9492910360E+00, 9.4055845684E-01],
	[3.3190000000E+04, 2.5089534562E+01, 5.2053188942E+00, 9.3429115470E+00, 2.9498397992E+00, 9.4058725692E-01],
	[3.3195000000E+04, 2.5095913981E+01, 5.2053265475E+00, 9.3475073977E+00, 2.9503884361E+00, 9.4061604230E-01],
	[3.3200000000E+04, 2.5102294060E+01, 5.2053341996E+00, 9.3521048159E+00, 2.9509369466E+00, 9.4064481299E-01],
	[3.3205000000E+04, 2.5108674800E+01, 5.2053418506E+00, 9.3567038020E+00, 2.9514853309E+00, 9.4067356898E-01],
	[3.3210000000E+04, 2.5115056201E+01, 5.2053495005E+00, 9.3613043561E+00, 2.9520335889E+00, 9.4070231030E-01],
	[3.3215000000E+04, 2.5121438263E+01, 5.2053571492E+00, 9.3659064786E+00, 2.9525817205E+00, 9.4073103694E-01],
	[3.3220000000E+04, 2.5127820985E+01, 5.2053647968E+00, 9.3705101697E+00, 2.9531297259E+00, 9.4075974892E-01],
	[3.3225000000E+04, 2.5134204368E+01, 5.2053724432E+00, 9.3751154299E+00, 2.9536776050E+00, 9.4078844624E-01],
	[3.3230000000E+04, 2.5140588412E+01, 5.2053800885E+00, 9.3797222594E+00, 2.9542253577E+00, 9.4081712890E-01],
	[3.3235000000E+04, 2.5146973117E+01, 5.2053877327E+00, 9.3843306584E+00, 2.9547729842E+00, 9.4084579693E-01],
	[3.3240000000E+04, 2.5153358482E+01, 5.2053953757E+00, 9.3889406273E+00, 2.9553204843E+00, 9.4087445031E-01],
	[3.3245000000E+04, 2.5159744508E+01, 5.2054030176E+00, 9.3935521663E+00, 2.9558678582E+00, 9.4090308907E-01],
	[3.3250000000E+04, 2.5166131194E+01, 5.2054106584E+00, 9.3981652759E+00, 2.9564151057E+00, 9.4093171321E-01],
	[3.3255000000E+04, 2.5172518541E+01, 5.2054182980E+00, 9.4027799562E+00, 2.9569622269E+00, 9.4096032273E-01],
	[3.3260000000E+04, 2.5178906548E+01, 5.2054259365E+00, 9.4073962076E+00, 2.9575092218E+00, 9.4098891765E-01],
	[3.3265000000E+04, 2.5185295216E+01, 5.2054335738E+00, 9.4120140304E+00, 2.9580560904E+00, 9.4101749797E-01],
	[3.3270000000E+04, 2.5191684544E+01, 5.2054412100E+00, 9.4166334248E+00, 2.9586028327E+00, 9.4104606370E-01],
	[3.3275000000E+04, 2.5198074533E+01, 5.2054488451E+00, 9.4212543912E+00, 2.9591494487E+00, 9.4107461484E-01],
	[3.3280000000E+04, 2.5204465182E+01, 5.2054564790E+00, 9.4258769298E+00, 2.9596959383E+00, 9.4110315141E-01],
	[3.3285000000E+04, 2.5210856491E+01, 5.2054641118E+00, 9.4305010410E+00, 2.9602423017E+00, 9.4113167340E-01],
	[3.3290000000E+04, 2.5217248461E+01, 5.2054717434E+00, 9.4351267251E+00, 2.9607885387E+00, 9.4116018084E-01],
	[3.3295000000E+04, 2.5223641091E+01, 5.2054793740E+00, 9.4397539823E+00, 2.9613346494E+00, 9.4118867372E-01],
	[3.3300000000E+04, 2.5230034381E+01, 5.2054870033E+00, 9.4443828130E+00, 2.9618806338E+00, 9.4121715206E-01],
	[3.3305000000E+04, 2.5236428332E+01, 5.2054946316E+00, 9.4490132175E+00, 2.9624264919E+00, 9.4124561586E-01],
	[3.3310000000E+04, 2.5242822942E+01, 5.2055022587E+00, 9.4536451960E+00, 2.9629722236E+00, 9.4127406512E-01],
	[3.3315000000E+04, 2.5249218213E+01, 5.2055098847E+00, 9.4582787488E+00, 2.9635178291E+00, 9.4130249986E-01],
	[3.3320000000E+04, 2.5255614144E+01, 5.2055175096E+00, 9.4629138763E+00, 2.9640633082E+00, 9.4133092009E-01],
	[3.3325000000E+04, 2.5262010735E+01, 5.2055251333E+00, 9.4675505788E+00, 2.9646086610E+00, 9.4135932581E-01],
	[3.3330000000E+04, 2.5268407986E+01, 5.2055327559E+00, 9.4721888565E+00, 2.9651538875E+00, 9.4138771702E-01],
	[3.3335000000E+04, 2.5274805898E+01, 5.2055403773E+00, 9.4768287097E+00, 2.9656989876E+00, 9.4141609374E-01],
	[3.3340000000E+04, 2.5281204469E+01, 5.2055479976E+00, 9.4814701388E+00, 2.9662439615E+00, 9.4144445597E-01],
	[3.3345000000E+04, 2.5287603700E+01, 5.2055556168E+00, 9.4861131440E+00, 2.9667888090E+00, 9.4147280373E-01],
	[3.3350000000E+04, 2.5294003591E+01, 5.2055632349E+00, 9.4907577257E+00, 2.9673335302E+00, 9.4150113701E-01],
	[3.3355000000E+04, 2.5300404142E+01, 5.2055708518E+00, 9.4954038841E+00, 2.9678781251E+00, 9.4152945583E-01],
	[3.3360000000E+04, 2.5306805353E+01, 5.2055784676E+00, 9.5000516195E+00, 2.9684225936E+00, 9.4155776019E-01],
	[3.3365000000E+04, 2.5313207224E+01, 5.2055860823E+00, 9.5047009323E+00, 2.9689669359E+00, 9.4158605010E-01],
	[3.3370000000E+04, 2.5319609754E+01, 5.2055936958E+00, 9.5093518227E+00, 2.9695111518E+00, 9.4161432557E-01],
	[3.3375000000E+04, 2.5326012945E+01, 5.2056013082E+00, 9.5140042911E+00, 2.9700552414E+00, 9.4164258660E-01],
	[3.3380000000E+04, 2.5332416795E+01, 5.2056089195E+00, 9.5186583377E+00, 2.9705992046E+00, 9.4167083321E-01],
	[3.3385000000E+04, 2.5338821305E+01, 5.2056165297E+00, 9.5233139628E+00, 2.9711430416E+00, 9.4169906539E-01],
	[3.3390000000E+04, 2.5345226474E+01, 5.2056241387E+00, 9.5279711667E+00, 2.9716867522E+00, 9.4172728317E-01],
	[3.3395000000E+04, 2.5351632303E+01, 5.2056317466E+00, 9.5326299498E+00, 2.9722303365E+00, 9.4175548654E-01],
	[3.3400000000E+04, 2.5358038792E+01, 5.2056393534E+00, 9.5372903123E+00, 2.9727737945E+00, 9.4178367551E-01],
	[3.3405000000E+04, 2.5364445941E+01, 5.2056469590E+00, 9.5419522546E+00, 2.9733171261E+00, 9.4181185010E-01],
	[3.3410000000E+04, 2.5370853749E+01, 5.2056545635E+00, 9.5466157768E+00, 2.9738603315E+00, 9.4184001030E-01],
	[3.3415000000E+04, 2.5377262216E+01, 5.2056621669E+00, 9.5512808794E+00, 2.9744034105E+00, 9.4186815612E-01],
	[3.3420000000E+04, 2.5383671343E+01, 5.2056697692E+00, 9.5559475626E+00, 2.9749463632E+00, 9.4189628758E-01],
	[3.3425000000E+04, 2.5390081130E+01, 5.2056773703E+00, 9.5606158267E+00, 2.9754891896E+00, 9.4192440468E-01],
	[3.3430000000E+04, 2.5396491576E+01, 5.2056849703E+00, 9.5652856720E+00, 2.9760318896E+00, 9.4195250742E-01],
	[3.3435000000E+04, 2.5402902682E+01, 5.2056925692E+00, 9.5699570989E+00, 2.9765744634E+00, 9.4198059582E-01],
	[3.3440000000E+04, 2.5409314446E+01, 5.2057001669E+00, 9.5746301075E+00, 2.9771169108E+00, 9.4200866988E-01],
	[3.3445000000E+04, 2.5415726871E+01, 5.2057077636E+00, 9.5793046983E+00, 2.9776592319E+00, 9.4203672962E-01],
	[3.3450000000E+04, 2.5422159274E+01, 5.2057180327E+00, 9.5839808715E+00, 2.9782025669E+00, 9.4206477502E-01],
	[3.3455000000E+04, 2.5428593255E+01, 5.2057284266E+00, 9.5886586274E+00, 2.9787458300E+00, 9.4209280612E-01],
	[3.3460000000E+04, 2.5435027904E+01, 5.2057388189E+00, 9.5933379663E+00, 2.9792889672E+00, 9.4212082290E-01],
	[3.3465000000E+04, 2.5441463218E+01, 5.2057492097E+00, 9.5980188886E+00, 2.9798319788E+00, 9.4214882539E-01],
	[3.3470000000E+04, 2.5447899199E+01, 5.2057595990E+00, 9.6027013944E+00, 2.9803748645E+00, 9.4217681358E-01],
	[3.3475000000E+04, 2.5454335846E+01, 5.2057699867E+00, 9.6073854842E+00, 2.9809176245E+00, 9.4220478748E-01],
	[3.3480000000E+04, 2.5460773160E+01, 5.2057803729E+00, 9.6120711581E+00, 2.9814602587E+00, 9.4223274711E-01],
	[3.3485000000E+04, 2.5467211140E+01, 5.2057907576E+00, 9.6167584166E+00, 2.9820027672E+00, 9.4226069247E-01],
	[3.3490000000E+04, 2.5473649786E+01, 5.2058011407E+00, 9.6214472598E+00, 2.9825451499E+00, 9.4228862356E-01],
	[3.3495000000E+04, 2.5480089099E+01, 5.2058115223E+00, 9.6261376882E+00, 2.9830874068E+00, 9.4231654040E-01],
	[3.3500000000E+04, 2.5486529078E+01, 5.2058219024E+00, 9.6308297020E+00, 2.9836295379E+00, 9.4234444299E-01],
	[3.3505000000E+04, 2.5492969723E+01, 5.2058322810E+00, 9.6355233014E+00, 2.9841715433E+00, 9.4237233133E-01],
	[3.3510000000E+04, 2.5499411034E+01, 5.2058426580E+00, 9.6402184869E+00, 2.9847134229E+00, 9.4240020545E-01],
	[3.3515000000E+04, 2.5505853011E+01, 5.2058530335E+00, 9.6449152586E+00, 2.9852551768E+00, 9.4242806533E-01],
	[3.3520000000E+04, 2.5512295654E+01, 5.2058634075E+00, 9.6496136170E+00, 2.9857968049E+00, 9.4245591100E-01],
	[3.3525000000E+04, 2.5518738964E+01, 5.2058737799E+00, 9.6543135623E+00, 2.9863383072E+00, 9.4248374246E-01],
	[3.3530000000E+04, 2.5525182939E+01, 5.2058841509E+00, 9.6590150947E+00, 2.9868796838E+00, 9.4251155971E-01],
	[3.3535000000E+04, 2.5531627581E+01, 5.2058945203E+00, 9.6637182146E+00, 2.9874209346E+00, 9.4253936277E-01],
	[3.3540000000E+04, 2.5538072888E+01, 5.2059048881E+00, 9.6684229224E+00, 2.9879620596E+00, 9.4256715163E-01],
	[3.3545000000E+04, 2.5544518861E+01, 5.2059152545E+00, 9.6731292182E+00, 2.9885030589E+00, 9.4259492632E-01],
	[3.3550000000E+04, 2.5550965501E+01, 5.2059256193E+00, 9.6778371024E+00, 2.9890439324E+00, 9.4262268683E-01],
	[3.3555000000E+04, 2.5557412806E+01, 5.2059359826E+00, 9.6825465753E+00, 2.9895846802E+00, 9.4265043317E-01],
	[3.3560000000E+04, 2.5563860777E+01, 5.2059463444E+00, 9.6872576372E+00, 2.9901253022E+00, 9.4267816536E-01],
	[3.3565000000E+04, 2.5570309414E+01, 5.2059567046E+00, 9.6919702884E+00, 2.9906657985E+00, 9.4270588339E-01],
	[3.3570000000E+04, 2.5576758716E+01, 5.2059670633E+00, 9.6966845292E+00, 2.9912061690E+00, 9.4273358728E-01],
	[3.3575000000E+04, 2.5583208685E+01, 5.2059774206E+00, 9.7014003598E+00, 2.9917464137E+00, 9.4276127703E-01],
	[3.3580000000E+04, 2.5589659319E+01, 5.2059877762E+00, 9.7061177807E+00, 2.9922865327E+00, 9.4278895265E-01],
	[3.3585000000E+04, 2.5596110619E+01, 5.2059981304E+00, 9.7108367920E+00, 2.9928265260E+00, 9.4281661414E-01],
	[3.3590000000E+04, 2.5602562584E+01, 5.2060084830E+00, 9.7155573941E+00, 2.9933663935E+00, 9.4284426153E-01],
	[3.3595000000E+04, 2.5609015216E+01, 5.2060188342E+00, 9.7202795873E+00, 2.9939061352E+00, 9.4287189480E-01],
	[3.3600000000E+04, 2.5615468512E+01, 5.2060291838E+00, 9.7250033719E+00, 2.9944457512E+00, 9.4289951397E-01],
	[3.3605000000E+04, 2.5621922475E+01, 5.2060395319E+00, 9.7297287481E+00, 2.9949852415E+00, 9.4292711906E-01],
	[3.3610000000E+04, 2.5628377103E+01, 5.2060498784E+00, 9.7344557163E+00, 2.9955246060E+00, 9.4295471005E-01],
	[3.3615000000E+04, 2.5634832396E+01, 5.2060602235E+00, 9.7391842768E+00, 2.9960638448E+00, 9.4298228697E-01],
	[3.3620000000E+04, 2.5641288355E+01, 5.2060705670E+00, 9.7439144299E+00, 2.9966029578E+00, 9.4300984982E-01],
	[3.3625000000E+04, 2.5647744980E+01, 5.2060809090E+00, 9.7486461759E+00, 2.9971419451E+00, 9.4303739860E-01],
	[3.3630000000E+04, 2.5654202269E+01, 5.2060912495E+00, 9.7533795150E+00, 2.9976808067E+00, 9.4306493333E-01],
	[3.3635000000E+04, 2.5660660225E+01, 5.2061015885E+00, 9.7581144476E+00, 2.9982195425E+00, 9.4309245401E-01],
	[3.3640000000E+04, 2.5667118845E+01, 5.2061119259E+00, 9.7628509740E+00, 2.9987581526E+00, 9.4311996065E-01],
	[3.3645000000E+04, 2.5673578131E+01, 5.2061222619E+00, 9.7675890945E+00, 2.9992966369E+00, 9.4314745325E-01],
	[3.3650000000E+04, 2.5680038083E+01, 5.2061325963E+00, 9.7723288093E+00, 2.9998349955E+00, 9.4317493183E-01],
	[3.3655000000E+04, 2.5686498699E+01, 5.2061429292E+00, 9.7770701188E+00, 3.0003732284E+00, 9.4320239639E-01],
	[3.3660000000E+04, 2.5692959981E+01, 5.2061532606E+00, 9.7818130232E+00, 3.0009113356E+00, 9.4322984694E-01],
	[3.3665000000E+04, 2.5699421928E+01, 5.2061635905E+00, 9.7865575230E+00, 3.0014493170E+00, 9.4325728348E-01],
	[3.3670000000E+04, 2.5705884540E+01, 5.2061739189E+00, 9.7913036183E+00, 3.0019871727E+00, 9.4328470602E-01],
	[3.3675000000E+04, 2.5712347817E+01, 5.2061842457E+00, 9.7960513095E+00, 3.0025249027E+00, 9.4331211457E-01],
	[3.3680000000E+04, 2.5718811760E+01, 5.2061945711E+00, 9.8008005968E+00, 3.0030625069E+00, 9.4333950913E-01],
	[3.3685000000E+04, 2.5725276368E+01, 5.2062048949E+00, 9.8055514806E+00, 3.0035999855E+00, 9.4336688971E-01],
	[3.3690000000E+04, 2.5731741640E+01, 5.2062152172E+00, 9.8103039612E+00, 3.0041373383E+00, 9.4339425632E-01],
	[3.3695000000E+04, 2.5738207578E+01, 5.2062255380E+00, 9.8150580388E+00, 3.0046745654E+00, 9.4342160896E-01],
	[3.3700000000E+04, 2.5744674181E+01, 5.2062358573E+00, 9.8198137138E+00, 3.0052116668E+00, 9.4344894763E-01],
	[3.3705000000E+04, 2.5751141448E+01, 5.2062461751E+00, 9.8245709865E+00, 3.0057486424E+00, 9.4347627236E-01],
	[3.3710000000E+04, 2.5757609381E+01, 5.2062564914E+00, 9.8293298572E+00, 3.0062854924E+00, 9.4350358313E-01],
	[3.3715000000E+04, 2.5764077978E+01, 5.2062668062E+00, 9.8340903261E+00, 3.0068222167E+00, 9.4353087997E-01],
	[3.3720000000E+04, 2.5770547241E+01, 5.2062771194E+00, 9.8388523935E+00, 3.0073588152E+00, 9.4355816286E-01],
	[3.3725000000E+04, 2.5777017168E+01, 5.2062874312E+00, 9.8436160598E+00, 3.0078952881E+00, 9.4358543183E-01],
	[3.3730000000E+04, 2.5783487760E+01, 5.2062977414E+00, 9.8483813253E+00, 3.0084316352E+00, 9.4361268688E-01],
	[3.3735000000E+04, 2.5789959017E+01, 5.2063080502E+00, 9.8531481903E+00, 3.0089678567E+00, 9.4363992801E-01],
	[3.3740000000E+04, 2.5796430939E+01, 5.2063183574E+00, 9.8579166550E+00, 3.0095039524E+00, 9.4366715524E-01],
	[3.3745000000E+04, 2.5802903525E+01, 5.2063286631E+00, 9.8626867197E+00, 3.0100399225E+00, 9.4369436855E-01],
	[3.3750000000E+04, 2.5809376776E+01, 5.2063389673E+00, 9.8674583848E+00, 3.0105757668E+00, 9.4372156798E-01],
	[3.3755000000E+04, 2.5815850692E+01, 5.2063492700E+00, 9.8722316506E+00, 3.0111114855E+00, 9.4374875351E-01],
	[3.3760000000E+04, 2.5822325273E+01, 5.2063595712E+00, 9.8770065173E+00, 3.0116470785E+00, 9.4377592516E-01],
	[3.3765000000E+04, 2.5828800518E+01, 5.2063698709E+00, 9.8817829853E+00, 3.0121825458E+00, 9.4380308293E-01],
	[3.3770000000E+04, 2.5835276427E+01, 5.2063801691E+00, 9.8865610549E+00, 3.0127178874E+00, 9.4383022684E-01],
	[3.3775000000E+04, 2.5841753001E+01, 5.2063904658E+00, 9.8913407263E+00, 3.0132531034E+00, 9.4385735688E-01],
	[3.3780000000E+04, 2.5848230240E+01, 5.2064007610E+00, 9.8961219998E+00, 3.0137881936E+00, 9.4388447306E-01],
	[3.3785000000E+04, 2.5854708143E+01, 5.2064110547E+00, 9.9009048758E+00, 3.0143231582E+00, 9.4391157539E-01],
	[3.3790000000E+04, 2.5861186711E+01, 5.2064213468E+00, 9.9056893546E+00, 3.0148579971E+00, 9.4393866387E-01],
	[3.3795000000E+04, 2.5867665943E+01, 5.2064316375E+00, 9.9104754364E+00, 3.0153927104E+00, 9.4396573852E-01],
	[3.3800000000E+04, 2.5874145839E+01, 5.2064419267E+00, 9.9152631216E+00, 3.0159272979E+00, 9.4399279934E-01],
	[3.3805000000E+04, 2.5880626400E+01, 5.2064522144E+00, 9.9200524104E+00, 3.0164617598E+00, 9.4401984633E-01],
	[3.3810000000E+04, 2.5887107625E+01, 5.2064625005E+00, 9.9248433032E+00, 3.0169960961E+00, 9.4404687950E-01],
	[3.3815000000E+04, 2.5893589515E+01, 5.2064727852E+00, 9.9296358002E+00, 3.0175303067E+00, 9.4407389886E-01],
	[3.3820000000E+04, 2.5900072069E+01, 5.2064830684E+00, 9.9344299018E+00, 3.0180643916E+00, 9.4410090442E-01],
	[3.3825000000E+04, 2.5906555287E+01, 5.2064933500E+00, 9.9392256083E+00, 3.0185983509E+00, 9.4412789618E-01],
	[3.3830000000E+04, 2.5913039169E+01, 5.2065036302E+00, 9.9440229198E+00, 3.0191321845E+00, 9.4415487414E-01],
	[3.3835000000E+04, 2.5919523715E+01, 5.2065139089E+00, 9.9488218369E+00, 3.0196658925E+00, 9.4418183832E-01],
	[3.3840000000E+04, 2.5926008926E+01, 5.2065241861E+00, 9.9536223597E+00, 3.0201994748E+00, 9.4420878872E-01],
	[3.3845000000E+04, 2.5932494801E+01, 5.2065344617E+00, 9.9584244885E+00, 3.0207329315E+00, 9.4423572535E-01],
	[3.3850000000E+04, 2.5938981340E+01, 5.2065447359E+00, 9.9632282237E+00, 3.0212662626E+00, 9.4426264820E-01],
	[3.3855000000E+04, 2.5945468543E+01, 5.2065550086E+00, 9.9680335655E+00, 3.0217994680E+00, 9.4428955730E-01],
	[3.3860000000E+04, 2.5951956410E+01, 5.2065652798E+00, 9.9728405143E+00, 3.0223325478E+00, 9.4431645265E-01],
	[3.3865000000E+04, 2.5958444940E+01, 5.2065755495E+00, 9.9776490703E+00, 3.0228655019E+00, 9.4434333425E-01],
	[3.3870000000E+04, 2.5964934135E+01, 5.2065858176E+00, 9.9824592339E+00, 3.0233983305E+00, 9.4437020211E-01],
	[3.3875000000E+04, 2.5971423994E+01, 5.2065960843E+00, 9.9872710053E+00, 3.0239310334E+00, 9.4439705623E-01],
	[3.3880000000E+04, 2.5977914517E+01, 5.2066063495E+00, 9.9920843849E+00, 3.0244636107E+00, 9.4442389663E-01],
	[3.3885000000E+04, 2.5984405704E+01, 5.2066166132E+00, 9.9968993729E+00, 3.0249960623E+00, 9.4445072331E-01],
	[3.3890000000E+04, 2.5990897554E+01, 5.2066268755E+00, 1.0001715970E+01, 3.0255283884E+00, 9.4447753627E-01],
	[3.3895000000E+04, 2.5997390069E+01, 5.2066371362E+00, 1.0006534175E+01, 3.0260605888E+00, 9.4450433552E-01],
	[3.3900000000E+04, 2.6003883247E+01, 5.2066473954E+00, 1.0011353991E+01, 3.0265926637E+00, 9.4453112108E-01],
	[3.3905000000E+04, 2.6010377089E+01, 5.2066576531E+00, 1.0016175415E+01, 3.0271246129E+00, 9.4455789293E-01],
	[3.3910000000E+04, 2.6016871595E+01, 5.2066679094E+00, 1.0020998450E+01, 3.0276564365E+00, 9.4458465110E-01],
	[3.3915000000E+04, 2.6023366764E+01, 5.2066781641E+00, 1.0025823095E+01, 3.0281881346E+00, 9.4461139559E-01],
	[3.3920000000E+04, 2.6029862597E+01, 5.2066884174E+00, 1.0030649351E+01, 3.0287197070E+00, 9.4463812640E-01],
	[3.3925000000E+04, 2.6036359094E+01, 5.2066986691E+00, 1.0035477217E+01, 3.0292511538E+00, 9.4466484355E-01],
	[3.3930000000E+04, 2.6042856254E+01, 5.2067089194E+00, 1.0040306695E+01, 3.0297824751E+00, 9.4469154703E-01],
	[3.3935000000E+04, 2.6049354078E+01, 5.2067191682E+00, 1.0045137784E+01, 3.0303136708E+00, 9.4471823686E-01],
	[3.3940000000E+04, 2.6055852566E+01, 5.2067294155E+00, 1.0049970484E+01, 3.0308447409E+00, 9.4474491303E-01],
	[3.3945000000E+04, 2.6062351717E+01, 5.2067396613E+00, 1.0054804797E+01, 3.0313756854E+00, 9.4477157557E-01],
	[3.3950000000E+04, 2.6068851531E+01, 5.2067499056E+00, 1.0059640722E+01, 3.0319065044E+00, 9.4479822446E-01],
	[3.3955000000E+04, 2.6075352009E+01, 5.2067601484E+00, 1.0064478260E+01, 3.0324371978E+00, 9.4482485973E-01],
	[3.3960000000E+04, 2.6081853151E+01, 5.2067703898E+00, 1.0069317411E+01, 3.0329677656E+00, 9.4485148138E-01],
	[3.3965000000E+04, 2.6088354956E+01, 5.2067806296E+00, 1.0074158175E+01, 3.0334982078E+00, 9.4487808941E-01],
	[3.3970000000E+04, 2.6094857424E+01, 5.2067908680E+00, 1.0079000552E+01, 3.0340285245E+00, 9.4490468382E-01],
	[3.3975000000E+04, 2.6101360555E+01, 5.2068011049E+00, 1.0083844543E+01, 3.0345587157E+00, 9.4493126464E-01],
	[3.3980000000E+04, 2.6107864350E+01, 5.2068113403E+00, 1.0088690149E+01, 3.0350887813E+00, 9.4495783186E-01],
	[3.3985000000E+04, 2.6114374206E+01, 5.2068223162E+00, 1.0093537369E+01, 3.0356190465E+00, 9.4498438548E-01],
	[3.3990000000E+04, 2.6120899293E+01, 5.2068352925E+00, 1.0098386204E+01, 3.0361500638E+00, 9.4501092553E-01],
	[3.3995000000E+04, 2.6127425050E+01, 5.2068482669E+00, 1.0103236653E+01, 3.0366809561E+00, 9.4503745199E-01],
	[3.4000000000E+04, 2.6133951478E+01, 5.2068612395E+00, 1.0108088718E+01, 3.0372117233E+00, 9.4506396489E-01],
	[3.4005000000E+04, 2.6140478576E+01, 5.2068742102E+00, 1.0112942399E+01, 3.0377423656E+00, 9.4509046422E-01],
	[3.4010000000E+04, 2.6147006344E+01, 5.2068871790E+00, 1.0117797696E+01, 3.0382728829E+00, 9.4511694999E-01],
	[3.4015000000E+04, 2.6153534782E+01, 5.2069001460E+00, 1.0122654609E+01, 3.0388032751E+00, 9.4514342221E-01],
	[3.4020000000E+04, 2.6160063890E+01, 5.2069131110E+00, 1.0127513138E+01, 3.0393335424E+00, 9.4516988089E-01],
	[3.4025000000E+04, 2.6166593668E+01, 5.2069260742E+00, 1.0132373284E+01, 3.0398636847E+00, 9.4519632603E-01],
	[3.4030000000E+04, 2.6173124116E+01, 5.2069390356E+00, 1.0137235048E+01, 3.0403937020E+00, 9.4522275763E-01],
	[3.4035000000E+04, 2.6179655234E+01, 5.2069519950E+00, 1.0142098429E+01, 3.0409235943E+00, 9.4524917571E-01],
	[3.4040000000E+04, 2.6186187023E+01, 5.2069649526E+00, 1.0146963427E+01, 3.0414533617E+00, 9.4527558028E-01],
	[3.4045000000E+04, 2.6192719481E+01, 5.2069779083E+00, 1.0151830044E+01, 3.0419830040E+00, 9.4530197133E-01],
	[3.4050000000E+04, 2.6199252609E+01, 5.2069908621E+00, 1.0156698279E+01, 3.0425125214E+00, 9.4532834887E-01],
	[3.4055000000E+04, 2.6205786407E+01, 5.2070038141E+00, 1.0161568133E+01, 3.0430419138E+00, 9.4535471292E-01],
	[3.4060000000E+04, 2.6212320875E+01, 5.2070167642E+00, 1.0166439605E+01, 3.0435711813E+00, 9.4538106347E-01],
	[3.4065000000E+04, 2.6218856013E+01, 5.2070297124E+00, 1.0171312697E+01, 3.0441003238E+00, 9.4540740054E-01],
	[3.4070000000E+04, 2.6225391820E+01, 5.2070426588E+00, 1.0176187408E+01, 3.0446293414E+00, 9.4543372413E-01],
	[3.4075000000E+04, 2.6231928298E+01, 5.2070556033E+00, 1.0181063740E+01, 3.0451582340E+00, 9.4546003424E-01],
	[3.4080000000E+04, 2.6238465445E+01, 5.2070685459E+00, 1.0185941691E+01, 3.0456870016E+00, 9.4548633089E-01],
	[3.4085000000E+04, 2.6245003261E+01, 5.2070814867E+00, 1.0190821263E+01, 3.0462156443E+00, 9.4551261408E-01],
	[3.4090000000E+04, 2.6251541748E+01, 5.2070944256E+00, 1.0195702455E+01, 3.0467441621E+00, 9.4553888381E-01],
	[3.4095000000E+04, 2.6258080904E+01, 5.2071073626E+00, 1.0200585269E+01, 3.0472725550E+00, 9.4556514010E-01],
	[3.4100000000E+04, 2.6264620730E+01, 5.2071202978E+00, 1.0205469704E+01, 3.0478008229E+00, 9.4559138295E-01],
	[3.4105000000E+04, 2.6271161225E+01, 5.2071332311E+00, 1.0210355761E+01, 3.0483289659E+00, 9.4561761236E-01],
	[3.4110000000E+04, 2.6277702390E+01, 5.2071461625E+00, 1.0215243439E+01, 3.0488569839E+00, 9.4564382835E-01],
	[3.4115000000E+04, 2.6284244225E+01, 5.2071590921E+00, 1.0220132740E+01, 3.0493848771E+00, 9.4567003092E-01],
	[3.4120000000E+04, 2.6290786729E+01, 5.2071720198E+00, 1.0225023663E+01, 3.0499126453E+00, 9.4569622007E-01],
	[3.4125000000E+04, 2.6297329902E+01, 5.2071849457E+00, 1.0229916209E+01, 3.0504402887E+00, 9.4572239582E-01],
	[3.4130000000E+04, 2.6303873745E+01, 5.2071978696E+00, 1.0234810379E+01, 3.0509678071E+00, 9.4574855816E-01],
	[3.4135000000E+04, 2.6310418257E+01, 5.2072107918E+00, 1.0239706172E+01, 3.0514952006E+00, 9.4577470711E-01],
	[3.4140000000E+04, 2.6316963439E+01, 5.2072237120E+00, 1.0244603588E+01, 3.0520224693E+00, 9.4580084267E-01],
	[3.4145000000E+04, 2.6323509290E+01, 5.2072366304E+00, 1.0249502629E+01, 3.0525496131E+00, 9.4582696486E-01],
	[3.4150000000E+04, 2.6330055811E+01, 5.2072495470E+00, 1.0254403294E+01, 3.0530766319E+00, 9.4585307366E-01],
	[3.4155000000E+04, 2.6336603000E+01, 5.2072624617E+00, 1.0259305583E+01, 3.0536035259E+00, 9.4587916910E-01],
	[3.4160000000E+04, 2.6343150859E+01, 5.2072753745E+00, 1.0264209498E+01, 3.0541302951E+00, 9.4590525118E-01],
	[3.4165000000E+04, 2.6349699388E+01, 5.2072882855E+00, 1.0269115038E+01, 3.0546569393E+00, 9.4593131990E-01],
	[3.4170000000E+04, 2.6356248585E+01, 5.2073011946E+00, 1.0274022203E+01, 3.0551834587E+00, 9.4595737527E-01],
	[3.4175000000E+04, 2.6362798452E+01, 5.2073141018E+00, 1.0278930994E+01, 3.0557098532E+00, 9.4598341730E-01],
	[3.4180000000E+04, 2.6369348987E+01, 5.2073270072E+00, 1.0283841411E+01, 3.0562361229E+00, 9.4600944599E-01],
	[3.4185000000E+04, 2.6375900192E+01, 5.2073399108E+00, 1.0288753455E+01, 3.0567622678E+00, 9.4603546136E-01],
	[3.4190000000E+04, 2.6382452066E+01, 5.2073528125E+00, 1.0293667126E+01, 3.0572882877E+00, 9.4606146340E-01],
	[3.4195000000E+04, 2.6389004610E+01, 5.2073657123E+00, 1.0298582423E+01, 3.0578141829E+00, 9.4608745213E-01],
	[3.4200000000E+04, 2.6395557822E+01, 5.2073786103E+00, 1.0303499348E+01, 3.0583399532E+00, 9.4611342755E-01],
	[3.4205000000E+04, 2.6402111703E+01, 5.2073915064E+00, 1.0308417901E+01, 3.0588655987E+00, 9.4613938966E-01],
	[3.4210000000E+04, 2.6408666253E+01, 5.2074044007E+00, 1.0313338082E+01, 3.0593911193E+00, 9.4616533848E-01],
	[3.4215000000E+04, 2.6415221472E+01, 5.2074172931E+00, 1.0318259890E+01, 3.0599165152E+00, 9.4619127401E-01],
	[3.4220000000E+04, 2.6421777360E+01, 5.2074301837E+00, 1.0323183328E+01, 3.0604417862E+00, 9.4621719626E-01],
	[3.4225000000E+04, 2.6428333917E+01, 5.2074430724E+00, 1.0328108394E+01, 3.0609669324E+00, 9.4624310523E-01],
	[3.4230000000E+04, 2.6434891143E+01, 5.2074559593E+00, 1.0333035089E+01, 3.0614919538E+00, 9.4626900093E-01],
	[3.4235000000E+04, 2.6441449037E+01, 5.2074688443E+00, 1.0337963414E+01, 3.0620168504E+00, 9.4629488337E-01],
	[3.4240000000E+04, 2.6448007601E+01, 5.2074817275E+00, 1.0342893369E+01, 3.0625416222E+00, 9.4632075255E-01],
	[3.4245000000E+04, 2.6454566833E+01, 5.2074946088E+00, 1.0347824954E+01, 3.0630662693E+00, 9.4634660847E-01],
	[3.4250000000E+04, 2.6461126734E+01, 5.2075074882E+00, 1.0352758169E+01, 3.0635907915E+00, 9.4637245116E-01],
	[3.4255000000E+04, 2.6467687303E+01, 5.2075203659E+00, 1.0357693014E+01, 3.0641151890E+00, 9.4639828061E-01],
	[3.4260000000E+04, 2.6474248541E+01, 5.2075332416E+00, 1.0362629491E+01, 3.0646394617E+00, 9.4642409682E-01],
	[3.4265000000E+04, 2.6480810448E+01, 5.2075461156E+00, 1.0367567599E+01, 3.0651636096E+00, 9.4644989982E-01],
	[3.4270000000E+04, 2.6487373024E+01, 5.2075589876E+00, 1.0372507338E+01, 3.0656876328E+00, 9.4647568959E-01],
	[3.4275000000E+04, 2.6493936268E+01, 5.2075718579E+00, 1.0377448710E+01, 3.0662115312E+00, 9.4650146616E-01],
	[3.4280000000E+04, 2.6500500181E+01, 5.2075847263E+00, 1.0382391713E+01, 3.0667353049E+00, 9.4652722952E-01],
	[3.4285000000E+04, 2.6507064762E+01, 5.2075975928E+00, 1.0387336349E+01, 3.0672589538E+00, 9.4655297968E-01],
	[3.4290000000E+04, 2.6513630012E+01, 5.2076104575E+00, 1.0392282618E+01, 3.0677824779E+00, 9.4657871665E-01],
	[3.4295000000E+04, 2.6520195930E+01, 5.2076233204E+00, 1.0397230519E+01, 3.0683058774E+00, 9.4660444043E-01],
	[3.4300000000E+04, 2.6526762517E+01, 5.2076361814E+00, 1.0402180055E+01, 3.0688291521E+00, 9.4663015104E-01],
	[3.4305000000E+04, 2.6533329772E+01, 5.2076490405E+00, 1.0407131223E+01, 3.0693523021E+00, 9.4665584848E-01],
	[3.4310000000E+04, 2.6539897695E+01, 5.2076618979E+00, 1.0412084026E+01, 3.0698753274E+00, 9.4668153275E-01],
	[3.4315000000E+04, 2.6546466287E+01, 5.2076747533E+00, 1.0417038463E+01, 3.0703982279E+00, 9.4670720386E-01],
	[3.4320000000E+04, 2.6553035547E+01, 5.2076876070E+00, 1.0421994535E+01, 3.0709210038E+00, 9.4673286182E-01],
	[3.4325000000E+04, 2.6559605476E+01, 5.2077004588E+00, 1.0426952241E+01, 3.0714436549E+00, 9.4675850663E-01],
	[3.4330000000E+04, 2.6566176073E+01, 5.2077133088E+00, 1.0431911583E+01, 3.0719661814E+00, 9.4678413830E-01],
	[3.4335000000E+04, 2.6572747338E+01, 5.2077261569E+00, 1.0436872560E+01, 3.0724885832E+00, 9.4680975685E-01],
	[3.4340000000E+04, 2.6579319271E+01, 5.2077390032E+00, 1.0441835173E+01, 3.0730108603E+00, 9.4683536226E-01],
	[3.4345000000E+04, 2.6585891872E+01, 5.2077518476E+00, 1.0446799422E+01, 3.0735330127E+00, 9.4686095456E-01],
	[3.4350000000E+04, 2.6592465142E+01, 5.2077646902E+00, 1.0451765307E+01, 3.0740550404E+00, 9.4688653374E-01],
	[3.4355000000E+04, 2.6599039080E+01, 5.2077775310E+00, 1.0456732829E+01, 3.0745769435E+00, 9.4691209982E-01],
	[3.4360000000E+04, 2.6605613685E+01, 5.2077903699E+00, 1.0461701988E+01, 3.0750987219E+00, 9.4693765280E-01],
	[3.4365000000E+04, 2.6612188959E+01, 5.2078032070E+00, 1.0466672785E+01, 3.0756203757E+00, 9.4696319268E-01],
	[3.4370000000E+04, 2.6618764901E+01, 5.2078160423E+00, 1.0471645218E+01, 3.0761419048E+00, 9.4698871948E-01],
	[3.4375000000E+04, 2.6625341511E+01, 5.2078288757E+00, 1.0476619290E+01, 3.0766633093E+00, 9.4701423320E-01],
	[3.4380000000E+04, 2.6631918789E+01, 5.2078417073E+00, 1.0481595000E+01, 3.0771845891E+00, 9.4703973384E-01],
	[3.4385000000E+04, 2.6638496735E+01, 5.2078545370E+00, 1.0486572348E+01, 3.0777057444E+00, 9.4706522142E-01],
	[3.4390000000E+04, 2.6645075348E+01, 5.2078673649E+00, 1.0491551336E+01, 3.0782267750E+00, 9.4709069594E-01],
	[3.4395000000E+04, 2.6651654630E+01, 5.2078801910E+00, 1.0496531962E+01, 3.0787476809E+00, 9.4711615740E-01],
	[3.4400000000E+04, 2.6658234579E+01, 5.2078930153E+00, 1.0501514227E+01, 3.0792684623E+00, 9.4714160582E-01],
	[3.4405000000E+04, 2.6664815197E+01, 5.2079058377E+00, 1.0506498133E+01, 3.0797891191E+00, 9.4716704119E-01],
	[3.4410000000E+04, 2.6671396482E+01, 5.2079186583E+00, 1.0511483678E+01, 3.0803096512E+00, 9.4719246353E-01],
	[3.4415000000E+04, 2.6677978435E+01, 5.2079314771E+00, 1.0516470864E+01, 3.0808300588E+00, 9.4721787285E-01],
	[3.4420000000E+04, 2.6684561055E+01, 5.2079442940E+00, 1.0521459690E+01, 3.0813503418E+00, 9.4724326914E-01],
	[3.4425000000E+04, 2.6691144344E+01, 5.2079571091E+00, 1.0526450157E+01, 3.0818705002E+00, 9.4726865242E-01],
	[3.4430000000E+04, 2.6697728300E+01, 5.2079699223E+00, 1.0531442265E+01, 3.0823905340E+00, 9.4729402268E-01],
	[3.4435000000E+04, 2.6704312923E+01, 5.2079827338E+00, 1.0536436015E+01, 3.0829104433E+00, 9.4731937995E-01],
	[3.4440000000E+04, 2.6710898215E+01, 5.2079955434E+00, 1.0541431406E+01, 3.0834302280E+00, 9.4734472422E-01],
	[3.4445000000E+04, 2.6717484174E+01, 5.2080083512E+00, 1.0546428440E+01, 3.0839498882E+00, 9.4737005551E-01],
	[3.4450000000E+04, 2.6724070800E+01, 5.2080211571E+00, 1.0551427116E+01, 3.0844694238E+00, 9.4739537381E-01],
	[3.4455000000E+04, 2.6730658094E+01, 5.2080339613E+00, 1.0556427434E+01, 3.0849888349E+00, 9.4742067914E-01],
	[3.4460000000E+04, 2.6737246056E+01, 5.2080467636E+00, 1.0561429396E+01, 3.0855081214E+00, 9.4744597150E-01],
	[3.4465000000E+04, 2.6743834685E+01, 5.2080595640E+00, 1.0566433001E+01, 3.0860272834E+00, 9.4747125089E-01],
	[3.4470000000E+04, 2.6750423981E+01, 5.2080723627E+00, 1.0571438250E+01, 3.0865463209E+00, 9.4749651733E-01],
	[3.4475000000E+04, 2.6757013945E+01, 5.2080851595E+00, 1.0576445142E+01, 3.0870652339E+00, 9.4752177083E-01],
	[3.4480000000E+04, 2.6763604576E+01, 5.2080979545E+00, 1.0581453679E+01, 3.0875840223E+00, 9.4754701138E-01],
	[3.4485000000E+04, 2.6770195875E+01, 5.2081107477E+00, 1.0586463860E+01, 3.0881026863E+00, 9.4757223899E-01],
	[3.4490000000E+04, 2.6776787841E+01, 5.2081235390E+00, 1.0591475686E+01, 3.0886212258E+00, 9.4759745367E-01],
	[3.4495000000E+04, 2.6783380474E+01, 5.2081363286E+00, 1.0596489157E+01, 3.0891396408E+00, 9.4762265543E-01],
	[3.4500000000E+04, 2.6789973775E+01, 5.2081491163E+00, 1.0601504273E+01, 3.0896579313E+00, 9.4764784428E-01],
	[3.4505000000E+04, 2.6796567743E+01, 5.2081619022E+00, 1.0606521035E+01, 3.0901760973E+00, 9.4767302021E-01],
	[3.4510000000E+04, 2.6803162378E+01, 5.2081746862E+00, 1.0611539444E+01, 3.0906941389E+00, 9.4769818324E-01],
	[3.4515000000E+04, 2.6809757680E+01, 5.2081874685E+00, 1.0616559498E+01, 3.0912120560E+00, 9.4772333338E-01],
	[3.4520000000E+04, 2.6816353649E+01, 5.2082002489E+00, 1.0621581199E+01, 3.0917298487E+00, 9.4774847062E-01],
	[3.4525000000E+04, 2.6822950286E+01, 5.2082130275E+00, 1.0626604547E+01, 3.0922475169E+00, 9.4777359498E-01],
	[3.4530000000E+04, 2.6829547590E+01, 5.2082258043E+00, 1.0631629542E+01, 3.0927650606E+00, 9.4779870646E-01],
	[3.4535000000E+04, 2.6836162341E+01, 5.2082408714E+00, 1.0636656185E+01, 3.0932835115E+00, 9.4782380508E-01],
	[3.4540000000E+04, 2.6842780673E+01, 5.2082563336E+00, 1.0641684475E+01, 3.0938020171E+00, 9.4784889082E-01],
	[3.4545000000E+04, 2.6849399679E+01, 5.2082717936E+00, 1.0646714414E+01, 3.0943203988E+00, 9.4787396372E-01],
	[3.4550000000E+04, 2.6856019359E+01, 5.2082872514E+00, 1.0651746001E+01, 3.0948386566E+00, 9.4789902376E-01],
	[3.4555000000E+04, 2.6862639713E+01, 5.2083027070E+00, 1.0656779237E+01, 3.0953567905E+00, 9.4792407095E-01],
	[3.4560000000E+04, 2.6869260740E+01, 5.2083181604E+00, 1.0661814122E+01, 3.0958748005E+00, 9.4794910531E-01],
	[3.4565000000E+04, 2.6875882442E+01, 5.2083336117E+00, 1.0666850656E+01, 3.0963926866E+00, 9.4797412684E-01],
	[3.4570000000E+04, 2.6882504817E+01, 5.2083490607E+00, 1.0671888839E+01, 3.0969104488E+00, 9.4799913554E-01],
	[3.4575000000E+04, 2.6889127865E+01, 5.2083645076E+00, 1.0676928673E+01, 3.0974280872E+00, 9.4802413142E-01],
	[3.4580000000E+04, 2.6895751588E+01, 5.2083799522E+00, 1.0681970157E+01, 3.0979456016E+00, 9.4804911449E-01],
	[3.4585000000E+04, 2.6902375984E+01, 5.2083953947E+00, 1.0687013291E+01, 3.0984629922E+00, 9.4807408476E-01],
	[3.4590000000E+04, 2.6909001053E+01, 5.2084108350E+00, 1.0692058076E+01, 3.0989802590E+00, 9.4809904223E-01],
	[3.4595000000E+04, 2.6915626796E+01, 5.2084262731E+00, 1.0697104513E+01, 3.0994974019E+00, 9.4812398690E-01],
	[3.4600000000E+04, 2.6922253213E+01, 5.2084417090E+00, 1.0702152601E+01, 3.1000144210E+00, 9.4814891879E-01],
	[3.4605000000E+04, 2.6928880303E+01, 5.2084571427E+00, 1.0707202340E+01, 3.1005313162E+00, 9.4817383791E-01],
	[3.4610000000E+04, 2.6935508067E+01, 5.2084725743E+00, 1.0712253731E+01, 3.1010480877E+00, 9.4819874424E-01],
	[3.4615000000E+04, 2.6942136504E+01, 5.2084880037E+00, 1.0717306775E+01, 3.1015647353E+00, 9.4822363782E-01],
	[3.4620000000E+04, 2.6948765614E+01, 5.2085034308E+00, 1.0722361472E+01, 3.1020812590E+00, 9.4824851863E-01],
	[3.4625000000E+04, 2.6955395398E+01, 5.2085188558E+00, 1.0727417821E+01, 3.1025976590E+00, 9.4827338669E-01],
	[3.4630000000E+04, 2.6962025856E+01, 5.2085342787E+00, 1.0732475824E+01, 3.1031139352E+00, 9.4829824200E-01],
	[3.4635000000E+04, 2.6968656986E+01, 5.2085496993E+00, 1.0737535480E+01, 3.1036300876E+00, 9.4832308458E-01],
	[3.4640000000E+04, 2.6975288790E+01, 5.2085651178E+00, 1.0742596790E+01, 3.1041461162E+00, 9.4834791442E-01],
	[3.4645000000E+04, 2.6981921268E+01, 5.2085805340E+00, 1.0747659754E+01, 3.1046620211E+00, 9.4837273153E-01],
	[3.4650000000E+04, 2.6988554418E+01, 5.2085959481E+00, 1.0752724373E+01, 3.1051778021E+00, 9.4839753593E-01],
	[3.4655000000E+04, 2.6995188242E+01, 5.2086113601E+00, 1.0757790646E+01, 3.1056934594E+00, 9.4842232761E-01],
	[3.4660000000E+04, 2.7001822739E+01, 5.2086267698E+00, 1.0762858575E+01, 3.1062089930E+00, 9.4844710658E-01],
	[3.4665000000E+04, 2.7008457909E+01, 5.2086421774E+00, 1.0767928158E+01, 3.1067244028E+00, 9.4847187285E-01],
	[3.4670000000E+04, 2.7015093752E+01, 5.2086575828E+00, 1.0772999398E+01, 3.1072396889E+00, 9.4849662643E-01],
	[3.4675000000E+04, 2.7021730268E+01, 5.2086729860E+00, 1.0778072293E+01, 3.1077548512E+00, 9.4852136732E-01],
	[3.4680000000E+04, 2.7028367458E+01, 5.2086883870E+00, 1.0783146845E+01, 3.1082698899E+00, 9.4854609553E-01],
	[3.4685000000E+04, 2.7035005320E+01, 5.2087037859E+00, 1.0788223053E+01, 3.1087848048E+00, 9.4857081107E-01],
	[3.4690000000E+04, 2.7041643856E+01, 5.2087191826E+00, 1.0793300918E+01, 3.1092995960E+00, 9.4859551394E-01],
	[3.4695000000E+04, 2.7048283064E+01, 5.2087345771E+00, 1.0798380440E+01, 3.1098142635E+00, 9.4862020414E-01],
	[3.4700000000E+04, 2.7054922946E+01, 5.2087499694E+00, 1.0803461619E+01, 3.1103288073E+00, 9.4864488169E-01],
	[3.4705000000E+04, 2.7061563500E+01, 5.2087653596E+00, 1.0808544457E+01, 3.1108432274E+00, 9.4866954660E-01],
	[3.4710000000E+04, 2.7068204728E+01, 5.2087807476E+00, 1.0813628952E+01, 3.1113575239E+00, 9.4869419886E-01],
	[3.4715000000E+04, 2.7074846628E+01, 5.2087961334E+00, 1.0818715106E+01, 3.1118716966E+00, 9.4871883848E-01],
	[3.4720000000E+04, 2.7081489201E+01, 5.2088115171E+00, 1.0823802918E+01, 3.1123857458E+00, 9.4874346548E-01],
	[3.4725000000E+04, 2.7088132447E+01, 5.2088268986E+00, 1.0828892390E+01, 3.1128996712E+00, 9.4876807985E-01],
	[3.4730000000E+04, 2.7094776365E+01, 5.2088422779E+00, 1.0833983520E+01, 3.1134134730E+00, 9.4879268161E-01],
	[3.4735000000E+04, 2.7101420957E+01, 5.2088576550E+00, 1.0839076311E+01, 3.1139271512E+00, 9.4881727076E-01],
	[3.4740000000E+04, 2.7108066221E+01, 5.2088730300E+00, 1.0844170761E+01, 3.1144407058E+00, 9.4884184731E-01],
	[3.4745000000E+04, 2.7114712158E+01, 5.2088884028E+00, 1.0849266871E+01, 3.1149541367E+00, 9.4886641126E-01],
	[3.4750000000E+04, 2.7121358767E+01, 5.2089037735E+00, 1.0854364642E+01, 3.1154674440E+00, 9.4889096262E-01],
	[3.4755000000E+04, 2.7128006049E+01, 5.2089191419E+00, 1.0859464073E+01, 3.1159806277E+00, 9.4891550139E-01],
	[3.4760000000E+04, 2.7134654004E+01, 5.2089345083E+00, 1.0864565166E+01, 3.1164936879E+00, 9.4894002759E-01],
	[3.4765000000E+04, 2.7141302632E+01, 5.2089498724E+00, 1.0869667920E+01, 3.1170066244E+00, 9.4896454122E-01],
	[3.4770000000E+04, 2.7147951931E+01, 5.2089652344E+00, 1.0874772336E+01, 3.1175194373E+00, 9.4898904229E-01],
	[3.4775000000E+04, 2.7154601904E+01, 5.2089805942E+00, 1.0879878413E+01, 3.1180321267E+00, 9.4901353080E-01],
	[3.4780000000E+04, 2.7161252549E+01, 5.2089959519E+00, 1.0884986153E+01, 3.1185446925E+00, 9.4903800676E-01],
	[3.4785000000E+04, 2.7167903866E+01, 5.2090113074E+00, 1.0890095556E+01, 3.1190571347E+00, 9.4906247017E-01],
	[3.4790000000E+04, 2.7174555856E+01, 5.2090266607E+00, 1.0895206621E+01, 3.1195694534E+00, 9.4908692105E-01],
	[3.4795000000E+04, 2.7181208519E+01, 5.2090420119E+00, 1.0900319350E+01, 3.1200816486E+00, 9.4911135940E-01],
	[3.4800000000E+04, 2.7187861853E+01, 5.2090573609E+00, 1.0905433742E+01, 3.1205937202E+00, 9.4913578522E-01],
	[3.4805000000E+04, 2.7194515860E+01, 5.2090727078E+00, 1.0910549798E+01, 3.1211056683E+00, 9.4916019852E-01],
	[3.4810000000E+04, 2.7201170540E+01, 5.2090880525E+00, 1.0915667518E+01, 3.1216174929E+00, 9.4918459932E-01],
	[3.4815000000E+04, 2.7207825892E+01, 5.2091033950E+00, 1.0920786902E+01, 3.1221291940E+00, 9.4920898760E-01],
	[3.4820000000E+04, 2.7214481916E+01, 5.2091187354E+00, 1.0925907951E+01, 3.1226407715E+00, 9.4923336339E-01],
	[3.4825000000E+04, 2.7221138612E+01, 5.2091340736E+00, 1.0931030665E+01, 3.1231522256E+00, 9.4925772669E-01],
	[3.4830000000E+04, 2.7227795980E+01, 5.2091494097E+00, 1.0936155045E+01, 3.1236635562E+00, 9.4928207750E-01],
	[3.4835000000E+04, 2.7234454021E+01, 5.2091647436E+00, 1.0941281090E+01, 3.1241747634E+00, 9.4930641583E-01],
	[3.4840000000E+04, 2.7241112734E+01, 5.2091800753E+00, 1.0946408800E+01, 3.1246858470E+00, 9.4933074169E-01],
	[3.4845000000E+04, 2.7247772119E+01, 5.2091954049E+00, 1.0951538178E+01, 3.1251968072E+00, 9.4935505508E-01],
	[3.4850000000E+04, 2.7254432176E+01, 5.2092107324E+00, 1.0956669221E+01, 3.1257076440E+00, 9.4937935602E-01],
	[3.4855000000E+04, 2.7261092905E+01, 5.2092260576E+00, 1.0961801932E+01, 3.1262183573E+00, 9.4940364450E-01],
	[3.4860000000E+04, 2.7267754306E+01, 5.2092413808E+00, 1.0966936309E+01, 3.1267289472E+00, 9.4942792053E-01],
	[3.4865000000E+04, 2.7274416379E+01, 5.2092567018E+00, 1.0972072354E+01, 3.1272394136E+00, 9.4945218413E-01],
	[3.4870000000E+04, 2.7281079125E+01, 5.2092720206E+00, 1.0977210067E+01, 3.1277497566E+00, 9.4947643529E-01],
	[3.4875000000E+04, 2.7287742542E+01, 5.2092873373E+00, 1.0982349447E+01, 3.1282599763E+00, 9.4950067402E-01],
	[3.4880000000E+04, 2.7294406631E+01, 5.2093026518E+00, 1.0987490496E+01, 3.1287700725E+00, 9.4952490033E-01],
	[3.4885000000E+04, 2.7301071392E+01, 5.2093179642E+00, 1.0992633214E+01, 3.1292800454E+00, 9.4954911423E-01],
	[3.4890000000E+04, 2.7307736825E+01, 5.2093332744E+00, 1.0997777601E+01, 3.1297898948E+00, 9.4957331573E-01],
	[3.4895000000E+04, 2.7314402929E+01, 5.2093485825E+00, 1.1002923656E+01, 3.1302996209E+00, 9.4959750482E-01],
	[3.4900000000E+04, 2.7321069706E+01, 5.2093638884E+00, 1.1008071382E+01, 3.1308092237E+00, 9.4962168151E-01],
	[3.4905000000E+04, 2.7327737154E+01, 5.2093791922E+00, 1.1013220777E+01, 3.1313187030E+00, 9.4964584582E-01],
	[3.4910000000E+04, 2.7334405274E+01, 5.2093944938E+00, 1.1018371842E+01, 3.1318280591E+00, 9.4966999775E-01],
	[3.4915000000E+04, 2.7341074066E+01, 5.2094097933E+00, 1.1023524578E+01, 3.1323372918E+00, 9.4969413730E-01],
	[3.4920000000E+04, 2.7347743530E+01, 5.2094250907E+00, 1.1028678984E+01, 3.1328464011E+00, 9.4971826448E-01],
	[3.4925000000E+04, 2.7354413665E+01, 5.2094403859E+00, 1.1033835062E+01, 3.1333553872E+00, 9.4974237930E-01],
	[3.4930000000E+04, 2.7361084472E+01, 5.2094556789E+00, 1.1038992811E+01, 3.1338642499E+00, 9.4976648177E-01],
	[3.4935000000E+04, 2.7367755950E+01, 5.2094709698E+00, 1.1044152231E+01, 3.1343729893E+00, 9.4979057189E-01],
	[3.4940000000E+04, 2.7374428100E+01, 5.2094862586E+00, 1.1049313324E+01, 3.1348816055E+00, 9.4981464966E-01],
	[3.4945000000E+04, 2.7381100922E+01, 5.2095015452E+00, 1.1054476088E+01, 3.1353900984E+00, 9.4983871510E-01],
	[3.4950000000E+04, 2.7387774415E+01, 5.2095168297E+00, 1.1059640525E+01, 3.1358984679E+00, 9.4986276821E-01],
	[3.4955000000E+04, 2.7394448580E+01, 5.2095321120E+00, 1.1064806636E+01, 3.1364067143E+00, 9.4988680899E-01],
	[3.4960000000E+04, 2.7401123416E+01, 5.2095473922E+00, 1.1069974419E+01, 3.1369148373E+00, 9.4991083746E-01],
	[3.4965000000E+04, 2.7407798923E+01, 5.2095626703E+00, 1.1075143876E+01, 3.1374228372E+00, 9.4993485362E-01],
	[3.4970000000E+04, 2.7414475102E+01, 5.2095779462E+00, 1.1080315006E+01, 3.1379307137E+00, 9.4995885747E-01],
	[3.4975000000E+04, 2.7421151953E+01, 5.2095932200E+00, 1.1085487810E+01, 3.1384384671E+00, 9.4998284903E-01],
	[3.4980000000E+04, 2.7427829474E+01, 5.2096084916E+00, 1.1090662289E+01, 3.1389460972E+00, 9.5000682830E-01],
	[3.4985000000E+04, 2.7434507667E+01, 5.2096237611E+00, 1.1095838443E+01, 3.1394536042E+00, 9.5003079528E-01],
	[3.4990000000E+04, 2.7441186532E+01, 5.2096390285E+00, 1.1101016271E+01, 3.1399609879E+00, 9.5005474998E-01],
	[3.4995000000E+04, 2.7447866068E+01, 5.2096542937E+00, 1.1106195775E+01, 3.1404682484E+00, 9.5007869242E-01],
	[3.5000000000E+04, 2.7454546274E+01, 5.2096695568E+00, 1.1111376955E+01, 3.1409753858E+00, 9.5010262258E-01],
	[3.5005000000E+04, 2.7461227153E+01, 5.2096848178E+00, 1.1116563656E+01, 3.1414827071E+00, 9.5012654049E-01],
	[3.5010000000E+04, 2.7467908702E+01, 5.2097000766E+00, 1.1121752037E+01, 3.1419899052E+00, 9.5015044615E-01],
	[3.5015000000E+04, 2.7474590922E+01, 5.2097153333E+00, 1.1126942098E+01, 3.1424969799E+00, 9.5017433956E-01],
	[3.5020000000E+04, 2.7481273814E+01, 5.2097305879E+00, 1.1132133838E+01, 3.1430039314E+00, 9.5019822074E-01],
	[3.5025000000E+04, 2.7487957377E+01, 5.2097458403E+00, 1.1137327259E+01, 3.1435107597E+00, 9.5022208968E-01],
	[3.5030000000E+04, 2.7494641611E+01, 5.2097610906E+00, 1.1142522360E+01, 3.1440174647E+00, 9.5024594639E-01],
	[3.5035000000E+04, 2.7501326515E+01, 5.2097763387E+00, 1.1147719141E+01, 3.1445240464E+00, 9.5026979089E-01],
	[3.5040000000E+04, 2.7508012091E+01, 5.2097915847E+00, 1.1152917604E+01, 3.1450305049E+00, 9.5029362317E-01],
	[3.5045000000E+04, 2.7514698338E+01, 5.2098068286E+00, 1.1158117748E+01, 3.1455368402E+00, 9.5031744325E-01],
	[3.5050000000E+04, 2.7521385256E+01, 5.2098220704E+00, 1.1163319574E+01, 3.1460430522E+00, 9.5034125112E-01],
	[3.5055000000E+04, 2.7528072845E+01, 5.2098373100E+00, 1.1168523082E+01, 3.1465491411E+00, 9.5036504681E-01],
	[3.5060000000E+04, 2.7534761104E+01, 5.2098525475E+00, 1.1173728272E+01, 3.1470551067E+00, 9.5038883030E-01],
	[3.5065000000E+04, 2.7541450035E+01, 5.2098677829E+00, 1.1178935145E+01, 3.1475609492E+00, 9.5041260161E-01],
	[3.5070000000E+04, 2.7548139636E+01, 5.2098830162E+00, 1.1184143701E+01, 3.1480666684E+00, 9.5043636075E-01],
	[3.5075000000E+04, 2.7554829909E+01, 5.2098982473E+00, 1.1189353940E+01, 3.1485722646E+00, 9.5046010773E-01],
	[3.5080000000E+04, 2.7561520852E+01, 5.2099134763E+00, 1.1194565862E+01, 3.1490777375E+00, 9.5048384254E-01],
	[3.5085000000E+04, 2.7568212465E+01, 5.2099287032E+00, 1.1199779468E+01, 3.1495830873E+00, 9.5050756519E-01],
	[3.5090000000E+04, 2.7574917817E+01, 5.2099457005E+00, 1.1204994759E+01, 3.1500891325E+00, 9.5053127570E-01],
	[3.5095000000E+04, 2.7581630202E+01, 5.2099635576E+00, 1.1210211733E+01, 3.1505954532E+00, 9.5055497406E-01],
	[3.5100000000E+04, 2.7588343265E+01, 5.2099814123E+00, 1.1215430393E+01, 3.1511016512E+00, 9.5057866029E-01],
	[3.5105000000E+04, 2.7595057005E+01, 5.2099992645E+00, 1.1220650737E+01, 3.1516077266E+00, 9.5060233439E-01],
	[3.5110000000E+04, 2.7601771422E+01, 5.2100171142E+00, 1.1225872767E+01, 3.1521136793E+00, 9.5062599637E-01],
	[3.5115000000E+04, 2.7608486516E+01, 5.2100349615E+00, 1.1231096483E+01, 3.1526195095E+00, 9.5064964623E-01],
	[3.5120000000E+04, 2.7615202288E+01, 5.2100528062E+00, 1.1236321884E+01, 3.1531252170E+00, 9.5067328398E-01],
	[3.5125000000E+04, 2.7621918736E+01, 5.2100706485E+00, 1.1241548972E+01, 3.1536308020E+00, 9.5069690963E-01],
	[3.5130000000E+04, 2.7628635862E+01, 5.2100884883E+00, 1.1246777746E+01, 3.1541362643E+00, 9.5072052318E-01],
	[3.5135000000E+04, 2.7635353666E+01, 5.2101063256E+00, 1.1252008207E+01, 3.1546416041E+00, 9.5074412464E-01],
	[3.5140000000E+04, 2.7642072146E+01, 5.2101241605E+00, 1.1257240355E+01, 3.1551468214E+00, 9.5076771402E-01],
	[3.5145000000E+04, 2.7648791303E+01, 5.2101419929E+00, 1.1262474191E+01, 3.1556519160E+00, 9.5079129132E-01],
	[3.5150000000E+04, 2.7655511138E+01, 5.2101598228E+00, 1.1267709714E+01, 3.1561568881E+00, 9.5081485654E-01],
	[3.5155000000E+04, 2.7662231649E+01, 5.2101776502E+00, 1.1272946925E+01, 3.1566617377E+00, 9.5083840971E-01],
	[3.5160000000E+04, 2.7668952838E+01, 5.2101954751E+00, 1.1278185825E+01, 3.1571664648E+00, 9.5086195081E-01],
	[3.5165000000E+04, 2.7675674703E+01, 5.2102132976E+00, 1.1283426414E+01, 3.1576710693E+00, 9.5088547986E-01],
	[3.5170000000E+04, 2.7682397246E+01, 5.2102311176E+00, 1.1288668691E+01, 3.1581755514E+00, 9.5090899687E-01],
	[3.5175000000E+04, 2.7689120465E+01, 5.2102489351E+00, 1.1293912658E+01, 3.1586799109E+00, 9.5093250184E-01],
	[3.5180000000E+04, 2.7695844361E+01, 5.2102667502E+00, 1.1299158314E+01, 3.1591841480E+00, 9.5095599478E-01],
	[3.5185000000E+04, 2.7702568935E+01, 5.2102845628E+00, 1.1304405660E+01, 3.1596882626E+00, 9.5097947569E-01],
	[3.5190000000E+04, 2.7709294185E+01, 5.2103023729E+00, 1.1309654697E+01, 3.1601922547E+00, 9.5100294458E-01],
	[3.5195000000E+04, 2.7716020111E+01, 5.2103201805E+00, 1.1314905424E+01, 3.1606961243E+00, 9.5102640145E-01],
	[3.5200000000E+04, 2.7722746715E+01, 5.2103379857E+00, 1.1320157841E+01, 3.1611998715E+00, 9.5104984632E-01],
	[3.5205000000E+04, 2.7729473996E+01, 5.2103557884E+00, 1.1325411950E+01, 3.1617034963E+00, 9.5107327919E-01],
	[3.5210000000E+04, 2.7736201953E+01, 5.2103735886E+00, 1.1330667750E+01, 3.1622069987E+00, 9.5109670007E-01],
	[3.5215000000E+04, 2.7742930587E+01, 5.2103913864E+00, 1.1335925242E+01, 3.1627103786E+00, 9.5112010895E-01],
	[3.5220000000E+04, 2.7749659897E+01, 5.2104091817E+00, 1.1341184426E+01, 3.1632136361E+00, 9.5114350586E-01],
	[3.5225000000E+04, 2.7756389884E+01, 5.2104269746E+00, 1.1346445302E+01, 3.1637167712E+00, 9.5116689079E-01],
	[3.5230000000E+04, 2.7763120548E+01, 5.2104447649E+00, 1.1351707871E+01, 3.1642197840E+00, 9.5119026376E-01],
	[3.5235000000E+04, 2.7769851889E+01, 5.2104625529E+00, 1.1356972133E+01, 3.1647226744E+00, 9.5121362476E-01],
	[3.5240000000E+04, 2.7776583906E+01, 5.2104803383E+00, 1.1362238088E+01, 3.1652254424E+00, 9.5123697380E-01],
	[3.5245000000E+04, 2.7783316599E+01, 5.2104981213E+00, 1.1367505736E+01, 3.1657280880E+00, 9.5126031090E-01],
	[3.5250000000E+04, 2.7790049969E+01, 5.2105159018E+00, 1.1372775079E+01, 3.1662306113E+00, 9.5128363606E-01],
	[3.5255000000E+04, 2.7796784016E+01, 5.2105336799E+00, 1.1378046115E+01, 3.1667330123E+00, 9.5130694927E-01],
	[3.5260000000E+04, 2.7803518739E+01, 5.2105514555E+00, 1.1383318846E+01, 3.1672352909E+00, 9.5133025056E-01],
	[3.5265000000E+04, 2.7810254138E+01, 5.2105692286E+00, 1.1388593272E+01, 3.1677374472E+00, 9.5135353993E-01],
	[3.5270000000E+04, 2.7816990214E+01, 5.2105869993E+00, 1.1393869393E+01, 3.1682394813E+00, 9.5137681738E-01],
	[3.5275000000E+04, 2.7823726966E+01, 5.2106047675E+00, 1.1399147209E+01, 3.1687413930E+00, 9.5140008291E-01],
	[3.5280000000E+04, 2.7830464395E+01, 5.2106225333E+00, 1.1404426721E+01, 3.1692431824E+00, 9.5142333655E-01],
	[3.5285000000E+04, 2.7837202499E+01, 5.2106402966E+00, 1.1409707928E+01, 3.1697448496E+00, 9.5144657828E-01],
	[3.5290000000E+04, 2.7843941281E+01, 5.2106580575E+00, 1.1414990832E+01, 3.1702463945E+00, 9.5146980812E-01],
	[3.5295000000E+04, 2.7850680738E+01, 5.2106758159E+00, 1.1420275433E+01, 3.1707478172E+00, 9.5149302608E-01],
	[3.5300000000E+04, 2.7857420872E+01, 5.2106935718E+00, 1.1425561730E+01, 3.1712491176E+00, 9.5151623216E-01],
	[3.5305000000E+04, 2.7864161681E+01, 5.2107113253E+00, 1.1430849725E+01, 3.1717502958E+00, 9.5153942637E-01],
	[3.5310000000E+04, 2.7870903168E+01, 5.2107290763E+00, 1.1436139417E+01, 3.1722513518E+00, 9.5156260871E-01],
	[3.5315000000E+04, 2.7877645330E+01, 5.2107468249E+00, 1.1441430807E+01, 3.1727522856E+00, 9.5158577919E-01],
	[3.5320000000E+04, 2.7884388168E+01, 5.2107645711E+00, 1.1446723895E+01, 3.1732530971E+00, 9.5160893781E-01],
	[3.5325000000E+04, 2.7891131682E+01, 5.2107823147E+00, 1.1452018682E+01, 3.1737537865E+00, 9.5163208458E-01],
	[3.5330000000E+04, 2.7897875873E+01, 5.2108000560E+00, 1.1457315167E+01, 3.1742543537E+00, 9.5165521950E-01],
	[3.5335000000E+04, 2.7904620739E+01, 5.2108177948E+00, 1.1462613351E+01, 3.1747547987E+00, 9.5167834259E-01],
	[3.5340000000E+04, 2.7911366282E+01, 5.2108355311E+00, 1.1467913234E+01, 3.1752551216E+00, 9.5170145384E-01],
	[3.5345000000E+04, 2.7918112500E+01, 5.2108532650E+00, 1.1473214817E+01, 3.1757553223E+00, 9.5172455326E-01],
	[3.5350000000E+04, 2.7924859395E+01, 5.2108709964E+00, 1.1478518100E+01, 3.1762554009E+00, 9.5174764086E-01],
	[3.5355000000E+04, 2.7931606965E+01, 5.2108887254E+00, 1.1483823083E+01, 3.1767553574E+00, 9.5177071665E-01],
	[3.5360000000E+04, 2.7938355211E+01, 5.2109064519E+00, 1.1489129767E+01, 3.1772551918E+00, 9.5179378062E-01],
	[3.5365000000E+04, 2.7945104133E+01, 5.2109241760E+00, 1.1494438152E+01, 3.1777549040E+00, 9.5181683279E-01],
	[3.5370000000E+04, 2.7951853731E+01, 5.2109418977E+00, 1.1499748237E+01, 3.1782544942E+00, 9.5183987316E-01],
	[3.5375000000E+04, 2.7958604005E+01, 5.2109596169E+00, 1.1505060024E+01, 3.1787539623E+00, 9.5186290174E-01],
	[3.5380000000E+04, 2.7965354955E+01, 5.2109773336E+00, 1.1510373513E+01, 3.1792533083E+00, 9.5188591852E-01],
	[3.5385000000E+04, 2.7972106580E+01, 5.2109950479E+00, 1.1515688704E+01, 3.1797525323E+00, 9.5190892353E-01],
	[3.5390000000E+04, 2.7978858881E+01, 5.2110127598E+00, 1.1521005598E+01, 3.1802516342E+00, 9.5193191675E-01],
	[3.5395000000E+04, 2.7985611858E+01, 5.2110304692E+00, 1.1526324193E+01, 3.1807506141E+00, 9.5195489821E-01],
	[3.5400000000E+04, 2.7992365510E+01, 5.2110481762E+00, 1.1531644492E+01, 3.1812494719E+00, 9.5197786790E-01],
	[3.5405000000E+04, 2.7999119838E+01, 5.2110658808E+00, 1.1536966495E+01, 3.1817482078E+00, 9.5200082583E-01],
	[3.5410000000E+04, 2.8005874842E+01, 5.2110835829E+00, 1.1542290200E+01, 3.1822468216E+00, 9.5202377201E-01],
	[3.5415000000E+04, 2.8012630521E+01, 5.2111012825E+00, 1.1547615610E+01, 3.1827453134E+00, 9.5204670643E-01],
	[3.5420000000E+04, 2.8019386876E+01, 5.2111189798E+00, 1.1552942724E+01, 3.1832436833E+00, 9.5206962912E-01],
	[3.5425000000E+04, 2.8026143907E+01, 5.2111366746E+00, 1.1558271542E+01, 3.1837419312E+00, 9.5209254007E-01],
	[3.5430000000E+04, 2.8032901613E+01, 5.2111543669E+00, 1.1563602065E+01, 3.1842400571E+00, 9.5211543928E-01],
	[3.5435000000E+04, 2.8039659994E+01, 5.2111720568E+00, 1.1568934293E+01, 3.1847380611E+00, 9.5213832677E-01],
	[3.5440000000E+04, 2.8046419051E+01, 5.2111897443E+00, 1.1574268227E+01, 3.1852359432E+00, 9.5216120254E-01],
	[3.5445000000E+04, 2.8053178783E+01, 5.2112074294E+00, 1.1579603866E+01, 3.1857337033E+00, 9.5218406660E-01],
	[3.5450000000E+04, 2.8059939191E+01, 5.2112251120E+00, 1.1584941211E+01, 3.1862313415E+00, 9.5220691895E-01],
	[3.5455000000E+04, 2.8066700274E+01, 5.2112427922E+00, 1.1590280263E+01, 3.1867288578E+00, 9.5222975959E-01],
	[3.5460000000E+04, 2.8073462032E+01, 5.2112604699E+00, 1.1595621021E+01, 3.1872262522E+00, 9.5225258854E-01],
	[3.5465000000E+04, 2.8080224466E+01, 5.2112781452E+00, 1.1600963486E+01, 3.1877235247E+00, 9.5227540579E-01],
	[3.5470000000E+04, 2.8086987575E+01, 5.2112958181E+00, 1.1606307658E+01, 3.1882206754E+00, 9.5229821136E-01],
	[3.5475000000E+04, 2.8093751359E+01, 5.2113134885E+00, 1.1611653538E+01, 3.1887177042E+00, 9.5232100525E-01],
	[3.5480000000E+04, 2.8100515819E+01, 5.2113311566E+00, 1.1617001126E+01, 3.1892146112E+00, 9.5234378747E-01],
	[3.5485000000E+04, 2.8107280953E+01, 5.2113488221E+00, 1.1622350422E+01, 3.1897113963E+00, 9.5236655801E-01],
	[3.5490000000E+04, 2.8114046763E+01, 5.2113664853E+00, 1.1627701426E+01, 3.1902080596E+00, 9.5238931690E-01],
	[3.5495000000E+04, 2.8120813248E+01, 5.2113841460E+00, 1.1633054139E+01, 3.1907046011E+00, 9.5241206412E-01],
	[3.5500000000E+04, 2.8127580408E+01, 5.2114018043E+00, 1.1638408561E+01, 3.1912010208E+00, 9.5243479970E-01],
	[3.5505000000E+04, 2.8134348243E+01, 5.2114194602E+00, 1.1643764693E+01, 3.1916973187E+00, 9.5245752362E-01],
	[3.5510000000E+04, 2.8141116754E+01, 5.2114371137E+00, 1.1649122534E+01, 3.1921934948E+00, 9.5248023591E-01],
	[3.5515000000E+04, 2.8147885939E+01, 5.2114547647E+00, 1.1654482085E+01, 3.1926895492E+00, 9.5250293656E-01],
	[3.5520000000E+04, 2.8154655799E+01, 5.2114724133E+00, 1.1659843346E+01, 3.1931854818E+00, 9.5252562559E-01],
	[3.5525000000E+04, 2.8161426335E+01, 5.2114900595E+00, 1.1665206318E+01, 3.1936812926E+00, 9.5254830299E-01],
	[3.5530000000E+04, 2.8168197545E+01, 5.2115077032E+00, 1.1670571001E+01, 3.1941769818E+00, 9.5257096877E-01],
	[3.5535000000E+04, 2.8174969430E+01, 5.2115253446E+00, 1.1675937395E+01, 3.1946725492E+00, 9.5259362294E-01],
	[3.5540000000E+04, 2.8181741990E+01, 5.2115429835E+00, 1.1681305500E+01, 3.1951679949E+00, 9.5261626550E-01],
	[3.5545000000E+04, 2.8188515225E+01, 5.2115606199E+00, 1.1686675317E+01, 3.1956633189E+00, 9.5263889647E-01],
	[3.5550000000E+04, 2.8195289135E+01, 5.2115782540E+00, 1.1692046847E+01, 3.1961585212E+00, 9.5266151584E-01],
	[3.5555000000E+04, 2.8202063719E+01, 5.2115958856E+00, 1.1697420089E+01, 3.1966536018E+00, 9.5268412362E-01],
	[3.5560000000E+04, 2.8208838979E+01, 5.2116135149E+00, 1.1702795043E+01, 3.1971485608E+00, 9.5270671981E-01],
	[3.5565000000E+04, 2.8215614913E+01, 5.2116311417E+00, 1.1708171710E+01, 3.1976433982E+00, 9.5272930443E-01],
	[3.5570000000E+04, 2.8222391522E+01, 5.2116487661E+00, 1.1713550091E+01, 3.1981381139E+00, 9.5275187748E-01],
	[3.5575000000E+04, 2.8229168805E+01, 5.2116663880E+00, 1.1718930186E+01, 3.1986327079E+00, 9.5277443896E-01],
	[3.5580000000E+04, 2.8235946764E+01, 5.2116840076E+00, 1.1724311994E+01, 3.1991271804E+00, 9.5279698888E-01],
	[3.5585000000E+04, 2.8242725396E+01, 5.2117016247E+00, 1.1729695517E+01, 3.1996215312E+00, 9.5281952724E-01],
	[3.5590000000E+04, 2.8249504704E+01, 5.2117192394E+00, 1.1735080754E+01, 3.2001157605E+00, 9.5284205406E-01],
	[3.5595000000E+04, 2.8256284686E+01, 5.2117368517E+00, 1.1740467706E+01, 3.2006098682E+00, 9.5286456933E-01],
	[3.5600000000E+04, 2.8263065343E+01, 5.2117544616E+00, 1.1745856373E+01, 3.2011038543E+00, 9.5288707307E-01],
	[3.5605000000E+04, 2.8269846674E+01, 5.2117720691E+00, 1.1751246755E+01, 3.2015977189E+00, 9.5290956527E-01],
	[3.5610000000E+04, 2.8276628680E+01, 5.2117896742E+00, 1.1756638854E+01, 3.2020914619E+00, 9.5293204594E-01],
	[3.5615000000E+04, 2.8283411360E+01, 5.2118072768E+00, 1.1762032668E+01, 3.2025850834E+00, 9.5295451510E-01],
	[3.5620000000E+04, 2.8290194715E+01, 5.2118248771E+00, 1.1767428199E+01, 3.2030785834E+00, 9.5297697274E-01],
	[3.5625000000E+04, 2.8296978744E+01, 5.2118424749E+00, 1.1772825446E+01, 3.2035719618E+00, 9.5299941887E-01],
	[3.5630000000E+04, 2.8303763447E+01, 5.2118600703E+00, 1.1778224410E+01, 3.2040652188E+00, 9.5302185349E-01],
	[3.5635000000E+04, 2.8310548825E+01, 5.2118776633E+00, 1.1783625092E+01, 3.2045583543E+00, 9.5304427662E-01],
	[3.5640000000E+04, 2.8317334877E+01, 5.2118952539E+00, 1.1789027491E+01, 3.2050513683E+00, 9.5306668826E-01],
	[3.5645000000E+04, 2.8324121604E+01, 5.2119128421E+00, 1.1794431608E+01, 3.2055442609E+00, 9.5308908841E-01],
	[3.5650000000E+04, 2.8330909005E+01, 5.2119304279E+00, 1.1799837444E+01, 3.2060370320E+00, 9.5311147708E-01],
	[3.5655000000E+04, 2.8337710585E+01, 5.2119498249E+00, 1.1805244998E+01, 3.2065305411E+00, 9.5313385427E-01],
	[3.5660000000E+04, 2.8344518542E+01, 5.2119699843E+00, 1.1810654270E+01, 3.2070242916E+00, 9.5315622000E-01],
	[3.5665000000E+04, 2.8351327180E+01, 5.2119901410E+00, 1.1816065262E+01, 3.2075179212E+00, 9.5317857426E-01],
	[3.5670000000E+04, 2.8358136499E+01, 5.2120102949E+00, 1.1821477973E+01, 3.2080114299E+00, 9.5320091706E-01],
	[3.5675000000E+04, 2.8364946498E+01, 5.2120304460E+00, 1.1826892404E+01, 3.2085048176E+00, 9.5322324841E-01],
	[3.5680000000E+04, 2.8371757178E+01, 5.2120505944E+00, 1.1832308555E+01, 3.2089980845E+00, 9.5324556831E-01],
	[3.5685000000E+04, 2.8378568538E+01, 5.2120707401E+00, 1.1837726426E+01, 3.2094912304E+00, 9.5326787677E-01],
	[3.5690000000E+04, 2.8385380579E+01, 5.2120908830E+00, 1.1843146018E+01, 3.2099842554E+00, 9.5329017380E-01],
	[3.5695000000E+04, 2.8392193301E+01, 5.2121110232E+00, 1.1848567331E+01, 3.2104771595E+00, 9.5331245940E-01],
	[3.5700000000E+04, 2.8399006703E+01, 5.2121311606E+00, 1.1853990365E+01, 3.2109699428E+00, 9.5333473357E-01],
	[3.5705000000E+04, 2.8405820786E+01, 5.2121512953E+00, 1.1859415120E+01, 3.2114626052E+00, 9.5335699633E-01],
	[3.5710000000E+04, 2.8412635549E+01, 5.2121714272E+00, 1.1864841598E+01, 3.2119551467E+00, 9.5337924767E-01],
	[3.5715000000E+04, 2.8419450993E+01, 5.2121915564E+00, 1.1870269797E+01, 3.2124475675E+00, 9.5340148761E-01],
	[3.5720000000E+04, 2.8426267117E+01, 5.2122116829E+00, 1.1875699719E+01, 3.2129398674E+00, 9.5342371614E-01],
	[3.5725000000E+04, 2.8433083922E+01, 5.2122318066E+00, 1.1881131364E+01, 3.2134320465E+00, 9.5344593328E-01],
	[3.5730000000E+04, 2.8439901406E+01, 5.2122519276E+00, 1.1886564732E+01, 3.2139241048E+00, 9.5346813903E-01],
	[3.5735000000E+04, 2.8446719572E+01, 5.2122720458E+00, 1.1891999823E+01, 3.2144160423E+00, 9.5349033340E-01],
	[3.5740000000E+04, 2.8453538417E+01, 5.2122921614E+00, 1.1897436638E+01, 3.2149078590E+00, 9.5351251639E-01],
	[3.5745000000E+04, 2.8460357943E+01, 5.2123122741E+00, 1.1902875177E+01, 3.2153995550E+00, 9.5353468800E-01],
	[3.5750000000E+04, 2.8467178149E+01, 5.2123323842E+00, 1.1908315441E+01, 3.2158911302E+00, 9.5355684825E-01],
	[3.5755000000E+04, 2.8473999035E+01, 5.2123524915E+00, 1.1913757428E+01, 3.2163825847E+00, 9.5357899714E-01],
	[3.5760000000E+04, 2.8480820602E+01, 5.2123725960E+00, 1.1919201141E+01, 3.2168739185E+00, 9.5360113467E-01],
	[3.5765000000E+04, 2.8487642849E+01, 5.2123926979E+00, 1.1924646579E+01, 3.2173651316E+00, 9.5362326085E-01],
	[3.5770000000E+04, 2.8494465776E+01, 5.2124127970E+00, 1.1930093743E+01, 3.2178562239E+00, 9.5364537569E-01],
	[3.5775000000E+04, 2.8501289382E+01, 5.2124328933E+00, 1.1935542632E+01, 3.2183471956E+00, 9.5366747919E-01],
	[3.5780000000E+04, 2.8508113670E+01, 5.2124529870E+00, 1.1940993247E+01, 3.2188380466E+00, 9.5368957136E-01],
	[3.5785000000E+04, 2.8514938637E+01, 5.2124730779E+00, 1.1946445589E+01, 3.2193287770E+00, 9.5371165220E-01],
	[3.5790000000E+04, 2.8521764284E+01, 5.2124931661E+00, 1.1951899658E+01, 3.2198193867E+00, 9.5373372172E-01],
	[3.5795000000E+04, 2.8528590611E+01, 5.2125132515E+00, 1.1957355453E+01, 3.2203098757E+00, 9.5375577992E-01],
	[3.5800000000E+04, 2.8535417618E+01, 5.2125333343E+00, 1.1962812976E+01, 3.2208002442E+00, 9.5377782681E-01],
	[3.5805000000E+04, 2.8542245306E+01, 5.2125534143E+00, 1.1968272227E+01, 3.2212904920E+00, 9.5379986240E-01],
	[3.5810000000E+04, 2.8549073673E+01, 5.2125734915E+00, 1.1973733206E+01, 3.2217806192E+00, 9.5382188669E-01],
	[3.5815000000E+04, 2.8555902720E+01, 5.2125935661E+00, 1.1979195913E+01, 3.2222706259E+00, 9.5384389969E-01],
	[3.5820000000E+04, 2.8562732446E+01, 5.2126136379E+00, 1.1984660348E+01, 3.2227605119E+00, 9.5386590140E-01],
	[3.5825000000E+04, 2.8569562853E+01, 5.2126337070E+00, 1.1990126512E+01, 3.2232502774E+00, 9.5388789183E-01],
	[3.5830000000E+04, 2.8576393940E+01, 5.2126537734E+00, 1.1995594406E+01, 3.2237399224E+00, 9.5390987099E-01],
	[3.5835000000E+04, 2.8583225706E+01, 5.2126738370E+00, 1.2001064029E+01, 3.2242294468E+00, 9.5393183887E-01],
	[3.5840000000E+04, 2.8590058152E+01, 5.2126938979E+00, 1.2006535381E+01, 3.2247188507E+00, 9.5395379549E-01],
	[3.5845000000E+04, 2.8596891278E+01, 5.2127139561E+00, 1.2012008464E+01, 3.2252081341E+00, 9.5397574085E-01],
	[3.5850000000E+04, 2.8603725084E+01, 5.2127340116E+00, 1.2017483278E+01, 3.2256972970E+00, 9.5399767496E-01],
	[3.5855000000E+04, 2.8610559569E+01, 5.2127540644E+00, 1.2022959822E+01, 3.2261863395E+00, 9.5401959782E-01],
	[3.5860000000E+04, 2.8617394734E+01, 5.2127741144E+00, 1.2028438096E+01, 3.2266752614E+00, 9.5404150944E-01],
	[3.5865000000E+04, 2.8624230579E+01, 5.2127941618E+00, 1.2033918103E+01, 3.2271640629E+00, 9.5406340982E-01],
	[3.5870000000E+04, 2.8631067103E+01, 5.2128142064E+00, 1.2039399841E+01, 3.2276527439E+00, 9.5408529898E-01],
	[3.5875000000E+04, 2.8637904307E+01, 5.2128342483E+00, 1.2044883311E+01, 3.2281413045E+00, 9.5410717690E-01],
	[3.5880000000E+04, 2.8644742190E+01, 5.2128542874E+00, 1.2050368513E+01, 3.2286297447E+00, 9.5412904361E-01],
	[3.5885000000E+04, 2.8651580753E+01, 5.2128743239E+00, 1.2055855447E+01, 3.2291180645E+00, 9.5415089911E-01],
	[3.5890000000E+04, 2.8658419995E+01, 5.2128943576E+00, 1.2061344115E+01, 3.2296062639E+00, 9.5417274340E-01],
	[3.5895000000E+04, 2.8665259917E+01, 5.2129143887E+00, 1.2066834515E+01, 3.2300943429E+00, 9.5419457649E-01],
	[3.5900000000E+04, 2.8672100518E+01, 5.2129344170E+00, 1.2072326649E+01, 3.2305823016E+00, 9.5421639838E-01],
	[3.5905000000E+04, 2.8678941799E+01, 5.2129544426E+00, 1.2077820517E+01, 3.2310701399E+00, 9.5423820908E-01],
	[3.5910000000E+04, 2.8685783759E+01, 5.2129744655E+00, 1.2083316119E+01, 3.2315578578E+00, 9.5426000860E-01],
	[3.5915000000E+04, 2.8692626398E+01, 5.2129944857E+00, 1.2088813455E+01, 3.2320454554E+00, 9.5428179694E-01],
	[3.5920000000E+04, 2.8699469717E+01, 5.2130145032E+00, 1.2094312526E+01, 3.2325329327E+00, 9.5430357411E-01],
	[3.5925000000E+04, 2.8706313715E+01, 5.2130345179E+00, 1.2099813332E+01, 3.2330202897E+00, 9.5432534010E-01],
	[3.5930000000E+04, 2.8713158393E+01, 5.2130545300E+00, 1.2105315873E+01, 3.2335075264E+00, 9.5434709494E-01],
	[3.5935000000E+04, 2.8720003749E+01, 5.2130745393E+00, 1.2110820150E+01, 3.2339946429E+00, 9.5436883862E-01],
	[3.5940000000E+04, 2.8726849785E+01, 5.2130945460E+00, 1.2116326163E+01, 3.2344816390E+00, 9.5439057115E-01],
	[3.5945000000E+04, 2.8733696500E+01, 5.2131145499E+00, 1.2121833912E+01, 3.2349685149E+00, 9.5441229253E-01],
	[3.5950000000E+04, 2.8740543895E+01, 5.2131345511E+00, 1.2127343397E+01, 3.2354552706E+00, 9.5443400278E-01],
	[3.5955000000E+04, 2.8747391968E+01, 5.2131545497E+00, 1.2132854619E+01, 3.2359419061E+00, 9.5445570189E-01],
	[3.5960000000E+04, 2.8754240720E+01, 5.2131745455E+00, 1.2138367579E+01, 3.2364284213E+00, 9.5447738988E-01],
	[3.5965000000E+04, 2.8761090152E+01, 5.2131945386E+00, 1.2143882275E+01, 3.2369148164E+00, 9.5449906674E-01],
	[3.5970000000E+04, 2.8767940263E+01, 5.2132145290E+00, 1.2149398710E+01, 3.2374010913E+00, 9.5452073249E-01],
	[3.5975000000E+04, 2.8774791052E+01, 5.2132345167E+00, 1.2154916882E+01, 3.2378872460E+00, 9.5454238712E-01],
	[3.5980000000E+04, 2.8781642521E+01, 5.2132545018E+00, 1.2160436793E+01, 3.2383732805E+00, 9.5456403066E-01],
	[3.5985000000E+04, 2.8788494669E+01, 5.2132744841E+00, 1.2165958443E+01, 3.2388591949E+00, 9.5458566309E-01],
	[3.5990000000E+04, 2.8795347495E+01, 5.2132944637E+00, 1.2171481831E+01, 3.2393449892E+00, 9.5460728443E-01],
	[3.5995000000E+04, 2.8802201001E+01, 5.2133144406E+00, 1.2177006959E+01, 3.2398306633E+00, 9.5462889468E-01],
	[3.6000000000E+04, 2.8809055185E+01, 5.2133344148E+00, 1.2182533826E+01, 3.2403162173E+00, 9.5465049385E-01],
	[3.6005000000E+04, 2.8815910049E+01, 5.2133543863E+00, 1.2188062433E+01, 3.2408016513E+00, 9.5467208194E-01],
	[3.6010000000E+04, 2.8822765591E+01, 5.2133743551E+00, 1.2193592781E+01, 3.2412869652E+00, 9.5469365896E-01],
	[3.6015000000E+04, 2.8829621812E+01, 5.2133943213E+00, 1.2199124869E+01, 3.2417721590E+00, 9.5471522492E-01],
	[3.6020000000E+04, 2.8836478712E+01, 5.2134142847E+00, 1.2204658697E+01, 3.2422572328E+00, 9.5473677981E-01],
	[3.6025000000E+04, 2.8843336291E+01, 5.2134342454E+00, 1.2210194267E+01, 3.2427421865E+00, 9.5475832366E-01],
	[3.6030000000E+04, 2.8850194548E+01, 5.2134542035E+00, 1.2215731578E+01, 3.2432270202E+00, 9.5477985645E-01],
	[3.6035000000E+04, 2.8857053484E+01, 5.2134741588E+00, 1.2221270631E+01, 3.2437117339E+00, 9.5480137821E-01],
	[3.6040000000E+04, 2.8863913099E+01, 5.2134941115E+00, 1.2226811426E+01, 3.2441963276E+00, 9.5482288892E-01],
	[3.6045000000E+04, 2.8870773392E+01, 5.2135140614E+00, 1.2232353963E+01, 3.2446808013E+00, 9.5484438861E-01],
	[3.6050000000E+04, 2.8877634364E+01, 5.2135340087E+00, 1.2237898243E+01, 3.2451651550E+00, 9.5486587727E-01],
	[3.6055000000E+04, 2.8884496015E+01, 5.2135539533E+00, 1.2243444266E+01, 3.2456493888E+00, 9.5488735491E-01],
	[3.6060000000E+04, 2.8891358344E+01, 5.2135738952E+00, 1.2248992031E+01, 3.2461335027E+00, 9.5490882153E-01],
	[3.6065000000E+04, 2.8898221352E+01, 5.2135938344E+00, 1.2254541541E+01, 3.2466174966E+00, 9.5493027715E-01],
	[3.6070000000E+04, 2.8905085038E+01, 5.2136137709E+00, 1.2260092794E+01, 3.2471013706E+00, 9.5495172177E-01],
	[3.6075000000E+04, 2.8911949403E+01, 5.2136337047E+00, 1.2265645792E+01, 3.2475851247E+00, 9.5497315539E-01],
	[3.6080000000E+04, 2.8918814446E+01, 5.2136536359E+00, 1.2271200534E+01, 3.2480687589E+00, 9.5499457802E-01],
	[3.6085000000E+04, 2.8925680168E+01, 5.2136735643E+00, 1.2276757020E+01, 3.2485522733E+00, 9.5501598966E-01],
	[3.6090000000E+04, 2.8932546568E+01, 5.2136934901E+00, 1.2282315252E+01, 3.2490356677E+00, 9.5503739032E-01],
	[3.6095000000E+04, 2.8939413646E+01, 5.2137134132E+00, 1.2287875229E+01, 3.2495189424E+00, 9.5505878001E-01],
	[3.6100000000E+04, 2.8946281403E+01, 5.2137333336E+00, 1.2293436952E+01, 3.2500020972E+00, 9.5508015873E-01],
	[3.6105000000E+04, 2.8953149838E+01, 5.2137532513E+00, 1.2299000421E+01, 3.2504851322E+00, 9.5510152648E-01],
	[3.6110000000E+04, 2.8960018952E+01, 5.2137731664E+00, 1.2304565636E+01, 3.2509680474E+00, 9.5512288328E-01],
	[3.6115000000E+04, 2.8966888744E+01, 5.2137930787E+00, 1.2310132598E+01, 3.2514508428E+00, 9.5514422913E-01],
	[3.6120000000E+04, 2.8973759214E+01, 5.2138129884E+00, 1.2315701307E+01, 3.2519335184E+00, 9.5516556403E-01],
	[3.6125000000E+04, 2.8980630362E+01, 5.2138328954E+00, 1.2321271763E+01, 3.2524160742E+00, 9.5518688800E-01],
	[3.6130000000E+04, 2.8987502189E+01, 5.2138527997E+00, 1.2326843966E+01, 3.2528985103E+00, 9.5520820102E-01],
	[3.6135000000E+04, 2.8994374693E+01, 5.2138727014E+00, 1.2332417917E+01, 3.2533808267E+00, 9.5522950312E-01],
	[3.6140000000E+04, 2.9001247876E+01, 5.2138926003E+00, 1.2337993616E+01, 3.2538630234E+00, 9.5525079430E-01],
	[3.6145000000E+04, 2.9008121737E+01, 5.2139124966E+00, 1.2343571064E+01, 3.2543451003E+00, 9.5527207456E-01],
	[3.6150000000E+04, 2.9014996276E+01, 5.2139323902E+00, 1.2349150261E+01, 3.2548270575E+00, 9.5529334390E-01],
	[3.6155000000E+04, 2.9021871493E+01, 5.2139522812E+00, 1.2354731206E+01, 3.2553088951E+00, 9.5531460235E-01],
	[3.6160000000E+04, 2.9028747388E+01, 5.2139721694E+00, 1.2360313901E+01, 3.2557906130E+00, 9.5533584989E-01],
	[3.6165000000E+04, 2.9035623961E+01, 5.2139920550E+00, 1.2365898346E+01, 3.2562722113E+00, 9.5535708653E-01],
	[3.6170000000E+04, 2.9042501213E+01, 5.2140119379E+00, 1.2371484540E+01, 3.2567536899E+00, 9.5537831229E-01],
	[3.6175000000E+04, 2.9049379142E+01, 5.2140318182E+00, 1.2377072485E+01, 3.2572350489E+00, 9.5539952716E-01],
	[3.6180000000E+04, 2.9056257749E+01, 5.2140516957E+00, 1.2382662180E+01, 3.2577162883E+00, 9.5542073115E-01],
	[3.6185000000E+04, 2.9063137034E+01, 5.2140715706E+00, 1.2388253627E+01, 3.2581974081E+00, 9.5544192428E-01],
	[3.6190000000E+04, 2.9070016996E+01, 5.2140914429E+00, 1.2393846824E+01, 3.2586784083E+00, 9.5546310653E-01],
	[3.6195000000E+04, 2.9076897637E+01, 5.2141113124E+00, 1.2399441773E+01, 3.2591592889E+00, 9.5548427793E-01],
	[3.6200000000E+04, 2.9083778956E+01, 5.2141311793E+00, 1.2405038474E+01, 3.2596400500E+00, 9.5550543847E-01],
	[3.6205000000E+04, 2.9090660952E+01, 5.2141510435E+00, 1.2410636927E+01, 3.2601206916E+00, 9.5552658816E-01],
	[3.6210000000E+04, 2.9097543626E+01, 5.2141709051E+00, 1.2416237132E+01, 3.2606012136E+00, 9.5554772701E-01],
	[3.6215000000E+04, 2.9104426978E+01, 5.2141907640E+00, 1.2421839090E+01, 3.2610816161E+00, 9.5556885502E-01],
	[3.6220000000E+04, 2.9111311007E+01, 5.2142106202E+00, 1.2427442801E+01, 3.2615618991E+00, 9.5558997220E-01],
	[3.6225000000E+04, 2.9118195714E+01, 5.2142304737E+00, 1.2433048266E+01, 3.2620420627E+00, 9.5561107855E-01],
	[3.6230000000E+04, 2.9125098473E+01, 5.2142526341E+00, 1.2438655484E+01, 3.2625232289E+00, 9.5563217407E-01],
	[3.6235000000E+04, 2.9132003524E+01, 5.2142750054E+00, 1.2444264456E+01, 3.2630043800E+00, 9.5565325879E-01],
	[3.6240000000E+04, 2.9138909259E+01, 5.2142973737E+00, 1.2449875182E+01, 3.2634854121E+00, 9.5567433269E-01],
	[3.6245000000E+04, 2.9145815678E+01, 5.2143197390E+00, 1.2455487663E+01, 3.2639663252E+00, 9.5569539579E-01],
	[3.6250000000E+04, 2.9152722781E+01, 5.2143421014E+00, 1.2461101898E+01, 3.2644471194E+00, 9.5571644809E-01],
	[3.6255000000E+04, 2.9159630568E+01, 5.2143644607E+00, 1.2466717889E+01, 3.2649277945E+00, 9.5573748960E-01],
	[3.6260000000E+04, 2.9166539038E+01, 5.2143868170E+00, 1.2472335635E+01, 3.2654083508E+00, 9.5575852032E-01],
	[3.6265000000E+04, 2.9173448193E+01, 5.2144091704E+00, 1.2477955137E+01, 3.2658887880E+00, 9.5577954026E-01],
	[3.6270000000E+04, 2.9180358031E+01, 5.2144315208E+00, 1.2483576396E+01, 3.2663691064E+00, 9.5580054942E-01],
	[3.6275000000E+04, 2.9187268553E+01, 5.2144538682E+00, 1.2489199410E+01, 3.2668493059E+00, 9.5582154782E-01],
	[3.6280000000E+04, 2.9194179759E+01, 5.2144762126E+00, 1.2494824181E+01, 3.2673293864E+00, 9.5584253545E-01],
	[3.6285000000E+04, 2.9201091649E+01, 5.2144985540E+00, 1.2500450710E+01, 3.2678093481E+00, 9.5586351231E-01],
	[3.6290000000E+04, 2.9208004222E+01, 5.2145208924E+00, 1.2506078995E+01, 3.2682891910E+00, 9.5588447843E-01],
	[3.6295000000E+04, 2.9214917479E+01, 5.2145432279E+00, 1.2511709038E+01, 3.2687689149E+00, 9.5590543380E-01],
	[3.6300000000E+04, 2.9221831420E+01, 5.2145655604E+00, 1.2517340840E+01, 3.2692485201E+00, 9.5592637843E-01],
	[3.6305000000E+04, 2.9228746044E+01, 5.2145878899E+00, 1.2522974399E+01, 3.2697280064E+00, 9.5594731232E-01],
	[3.6310000000E+04, 2.9235661352E+01, 5.2146102164E+00, 1.2528609717E+01, 3.2702073739E+00, 9.5596823548E-01],
	[3.6315000000E+04, 2.9242577344E+01, 5.2146325399E+00, 1.2534246794E+01, 3.2706866226E+00, 9.5598914791E-01],
	[3.6320000000E+04, 2.9249494019E+01, 5.2146548605E+00, 1.2539885630E+01, 3.2711657526E+00, 9.5601004963E-01],
	[3.6325000000E+04, 2.9256411377E+01, 5.2146771781E+00, 1.2545526225E+01, 3.2716447637E+00, 9.5603094063E-01],
	[3.6330000000E+04, 2.9263329419E+01, 5.2146994927E+00, 1.2551168580E+01, 3.2721236562E+00, 9.5605182092E-01],
	[3.6335000000E+04, 2.9270248145E+01, 5.2147218043E+00, 1.2556812695E+01, 3.2726024299E+00, 9.5607269051E-01],
	[3.6340000000E+04, 2.9277167554E+01, 5.2147441129E+00, 1.2562458571E+01, 3.2730810848E+00, 9.5609354941E-01],
	[3.6345000000E+04, 2.9284087646E+01, 5.2147664186E+00, 1.2568106207E+01, 3.2735596211E+00, 9.5611439761E-01],
	[3.6350000000E+04, 2.9291008422E+01, 5.2147887213E+00, 1.2573755605E+01, 3.2740380387E+00, 9.5613523512E-01],
	[3.6355000000E+04, 2.9297929881E+01, 5.2148110211E+00, 1.2579406763E+01, 3.2745163376E+00, 9.5615606196E-01],
	[3.6360000000E+04, 2.9304852024E+01, 5.2148333178E+00, 1.2585059683E+01, 3.2749945178E+00, 9.5617687812E-01],
	[3.6365000000E+04, 2.9311774850E+01, 5.2148556116E+00, 1.2590714365E+01, 3.2754725794E+00, 9.5619768362E-01],
	[3.6370000000E+04, 2.9318698359E+01, 5.2148779025E+00, 1.2596370810E+01, 3.2759505224E+00, 9.5621847845E-01],
	[3.6375000000E+04, 2.9325622551E+01, 5.2149001903E+00, 1.2602029017E+01, 3.2764283467E+00, 9.5623926262E-01],
	[3.6380000000E+04, 2.9332547427E+01, 5.2149224752E+00, 1.2607688986E+01, 3.2769060524E+00, 9.5626003615E-01],
	[3.6385000000E+04, 2.9339472986E+01, 5.2149447571E+00, 1.2613350719E+01, 3.2773836396E+00, 9.5628079902E-01],
	[3.6390000000E+04, 2.9346399228E+01, 5.2149670361E+00, 1.2619014215E+01, 3.2778611082E+00, 9.5630155126E-01],
	[3.6395000000E+04, 2.9353326153E+01, 5.2149893121E+00, 1.2624679475E+01, 3.2783384582E+00, 9.5632229286E-01],
	[3.6400000000E+04, 2.9360253761E+01, 5.2150115851E+00, 1.2630346500E+01, 3.2788156896E+00, 9.5634302383E-01],
	[3.6405000000E+04, 2.9367182052E+01, 5.2150338552E+00, 1.2636015288E+01, 3.2792928026E+00, 9.5636374418E-01],
	[3.6410000000E+04, 2.9374111027E+01, 5.2150561222E+00, 1.2641685841E+01, 3.2797697970E+00, 9.5638445391E-01],
	[3.6415000000E+04, 2.9381040684E+01, 5.2150783864E+00, 1.2647358159E+01, 3.2802466729E+00, 9.5640515302E-01],
	[3.6420000000E+04, 2.9387971025E+01, 5.2151006476E+00, 1.2653032243E+01, 3.2807234304E+00, 9.5642584153E-01],
	[3.6425000000E+04, 2.9394902048E+01, 5.2151229058E+00, 1.2658708092E+01, 3.2812000693E+00, 9.5644651944E-01],
	[3.6430000000E+04, 2.9401833755E+01, 5.2151451610E+00, 1.2664385706E+01, 3.2816765898E+00, 9.5646718676E-01],
	[3.6435000000E+04, 2.9408766144E+01, 5.2151674133E+00, 1.2670065087E+01, 3.2821529919E+00, 9.5648784348E-01],
	[3.6440000000E+04, 2.9415699217E+01, 5.2151896626E+00, 1.2675746235E+01, 3.2826292755E+00, 9.5650848962E-01],
	[3.6445000000E+04, 2.9422632972E+01, 5.2152119090E+00, 1.2681429149E+01, 3.2831054408E+00, 9.5652912518E-01],
	[3.6450000000E+04, 2.9429567410E+01, 5.2152341524E+00, 1.2687113831E+01, 3.2835814876E+00, 9.5654975017E-01],
	[3.6455000000E+04, 2.9436502531E+01, 5.2152563929E+00, 1.2692800280E+01, 3.2840574160E+00, 9.5657036459E-01],
	[3.6460000000E+04, 2.9443438335E+01, 5.2152786304E+00, 1.2698488497E+01, 3.2845332261E+00, 9.5659096845E-01],
	[3.6465000000E+04, 2.9450374822E+01, 5.2153008650E+00, 1.2704178481E+01, 3.2850089178E+00, 9.5661156176E-01],
	[3.6470000000E+04, 2.9457311991E+01, 5.2153230965E+00, 1.2709870234E+01, 3.2854844912E+00, 9.5663214451E-01],
	[3.6475000000E+04, 2.9464249843E+01, 5.2153453252E+00, 1.2715563756E+01, 3.2859599463E+00, 9.5665271672E-01],
	[3.6480000000E+04, 2.9471188378E+01, 5.2153675509E+00, 1.2721259047E+01, 3.2864352831E+00, 9.5667327838E-01],
	[3.6485000000E+04, 2.9478127595E+01, 5.2153897736E+00, 1.2726956107E+01, 3.2869105015E+00, 9.5669382952E-01],
	[3.6490000000E+04, 2.9485067495E+01, 5.2154119934E+00, 1.2732654937E+01, 3.2873856017E+00, 9.5671437012E-01],
	[3.6495000000E+04, 2.9492008078E+01, 5.2154342103E+00, 1.2738355536E+01, 3.2878605836E+00, 9.5673490021E-01],
	[3.6500000000E+04, 2.9498949343E+01, 5.2154564242E+00, 1.2744057906E+01, 3.2883354473E+00, 9.5675541978E-01],
	[3.6505000000E+04, 2.9505891291E+01, 5.2154786351E+00, 1.2749762046E+01, 3.2888101928E+00, 9.5677592883E-01],
	[3.6510000000E+04, 2.9512833922E+01, 5.2155008431E+00, 1.2755467957E+01, 3.2892848200E+00, 9.5679642738E-01],
	[3.6515000000E+04, 2.9519777234E+01, 5.2155230481E+00, 1.2761175639E+01, 3.2897593290E+00, 9.5681691543E-01],
	[3.6520000000E+04, 2.9526721230E+01, 5.2155452502E+00, 1.2766885092E+01, 3.2902337199E+00, 9.5683739299E-01],
	[3.6525000000E+04, 2.9533665908E+01, 5.2155674494E+00, 1.2772596317E+01, 3.2907079925E+00, 9.5685786006E-01],
	[3.6530000000E+04, 2.9540611268E+01, 5.2155896456E+00, 1.2778309315E+01, 3.2911821471E+00, 9.5687831664E-01],
	[3.6535000000E+04, 2.9547557311E+01, 5.2156118389E+00, 1.2784024084E+01, 3.2916561834E+00, 9.5689876275E-01],
	[3.6540000000E+04, 2.9554504036E+01, 5.2156340292E+00, 1.2789740627E+01, 3.2921301017E+00, 9.5691919838E-01],
	[3.6545000000E+04, 2.9561451444E+01, 5.2156562166E+00, 1.2795458942E+01, 3.2926039018E+00, 9.5693962355E-01],
	[3.6550000000E+04, 2.9568399534E+01, 5.2156784011E+00, 1.2801179030E+01, 3.2930775838E+00, 9.5696003825E-01],
	[3.6555000000E+04, 2.9575348306E+01, 5.2157005826E+00, 1.2806900892E+01, 3.2935511478E+00, 9.5698044251E-01],
	[3.6560000000E+04, 2.9582297760E+01, 5.2157227611E+00, 1.2812624528E+01, 3.2940245937E+00, 9.5700083631E-01],
	[3.6565000000E+04, 2.9589247897E+01, 5.2157449368E+00, 1.2818349938E+01, 3.2944979215E+00, 9.5702121967E-01],
	[3.6570000000E+04, 2.9596198716E+01, 5.2157671094E+00, 1.2824077123E+01, 3.2949711313E+00, 9.5704159259E-01],
	[3.6575000000E+04, 2.9603150217E+01, 5.2157892792E+00, 1.2829806082E+01, 3.2954442231E+00, 9.5706195507E-01],
	[3.6580000000E+04, 2.9610102400E+01, 5.2158114460E+00, 1.2835536817E+01, 3.2959171969E+00, 9.5708230713E-01],
	[3.6585000000E+04, 2.9617055266E+01, 5.2158336099E+00, 1.2841269326E+01, 3.2963900527E+00, 9.5710264877E-01],
	[3.6590000000E+04, 2.9624008813E+01, 5.2158557708E+00, 1.2847003612E+01, 3.2968627905E+00, 9.5712297999E-01],
	[3.6595000000E+04, 2.9630963043E+01, 5.2158779288E+00, 1.2852739674E+01, 3.2973354104E+00, 9.5714330080E-01],
	[3.6600000000E+04, 2.9637917955E+01, 5.2159000839E+00, 1.2858477512E+01, 3.2978079123E+00, 9.5716361121E-01],
	[3.6605000000E+04, 2.9644873549E+01, 5.2159222361E+00, 1.2864217126E+01, 3.2982802963E+00, 9.5718391122E-01],
	[3.6610000000E+04, 2.9651829825E+01, 5.2159443853E+00, 1.2869958518E+01, 3.2987525624E+00, 9.5720420083E-01],
	[3.6615000000E+04, 2.9658786782E+01, 5.2159665316E+00, 1.2875701687E+01, 3.2992247106E+00, 9.5722448006E-01],
	[3.6620000000E+04, 2.9665744422E+01, 5.2159886749E+00, 1.2881446633E+01, 3.2996967409E+00, 9.5724474890E-01],
	[3.6625000000E+04, 2.9672702744E+01, 5.2160108154E+00, 1.2887193357E+01, 3.3001686533E+00, 9.5726500736E-01],
	[3.6630000000E+04, 2.9679661748E+01, 5.2160329528E+00, 1.2892941860E+01, 3.3006404479E+00, 9.5728525546E-01],
	[3.6635000000E+04, 2.9686621433E+01, 5.2160550874E+00, 1.2898692140E+01, 3.3011121247E+00, 9.5730549319E-01],
	[3.6640000000E+04, 2.9693581801E+01, 5.2160772191E+00, 1.2904444200E+01, 3.3015836836E+00, 9.5732572055E-01],
	[3.6645000000E+04, 2.9700542850E+01, 5.2160993478E+00, 1.2910198039E+01, 3.3020551247E+00, 9.5734593757E-01],
	[3.6650000000E+04, 2.9707504581E+01, 5.2161214736E+00, 1.2915953657E+01, 3.3025264481E+00, 9.5736614423E-01],
	[3.6655000000E+04, 2.9714466994E+01, 5.2161435964E+00, 1.2921711055E+01, 3.3029976536E+00, 9.5738634055E-01],
	[3.6660000000E+04, 2.9721430088E+01, 5.2161657164E+00, 1.2927470233E+01, 3.3034687415E+00, 9.5740652653E-01],
	[3.6665000000E+04, 2.9728393865E+01, 5.2161878334E+00, 1.2933231191E+01, 3.3039397115E+00, 9.5742670218E-01],
	[3.6670000000E+04, 2.9735358323E+01, 5.2162099475E+00, 1.2938993930E+01, 3.3044105639E+00, 9.5744686751E-01],
	[3.6675000000E+04, 2.9742323462E+01, 5.2162320587E+00, 1.2944758449E+01, 3.3048812985E+00, 9.5746702251E-01],
	[3.6680000000E+04, 2.9749289284E+01, 5.2162541669E+00, 1.2950524750E+01, 3.3053519155E+00, 9.5748716720E-01],
	[3.6685000000E+04, 2.9756255787E+01, 5.2162762723E+00, 1.2956292833E+01, 3.3058224147E+00, 9.5750730157E-01],
	[3.6690000000E+04, 2.9763222971E+01, 5.2162983747E+00, 1.2962062697E+01, 3.3062927963E+00, 9.5752742565E-01],
	[3.6695000000E+04, 2.9770190838E+01, 5.2163204742E+00, 1.2967834344E+01, 3.3067630603E+00, 9.5754753942E-01],
	[3.6700000000E+04, 2.9777159385E+01, 5.2163425708E+00, 1.2973607773E+01, 3.3072332066E+00, 9.5756764290E-01],
	[3.6705000000E+04, 2.9784128615E+01, 5.2163646644E+00, 1.2979382985E+01, 3.3077032353E+00, 9.5758773609E-01],
	[3.6710000000E+04, 2.9791098525E+01, 5.2163867552E+00, 1.2985159980E+01, 3.3081731464E+00, 9.5760781900E-01],
	[3.6715000000E+04, 2.9798069117E+01, 5.2164088430E+00, 1.2990938758E+01, 3.3086429400E+00, 9.5762789163E-01],
	[3.6720000000E+04, 2.9805040391E+01, 5.2164309279E+00, 1.2996719320E+01, 3.3091126159E+00, 9.5764795399E-01],
	[3.6725000000E+04, 2.9812012346E+01, 5.2164530099E+00, 1.3002501666E+01, 3.3095821743E+00, 9.5766800609E-01],
	[3.6730000000E+04, 2.9818984983E+01, 5.2164750890E+00, 1.3008285797E+01, 3.3100516152E+00, 9.5768804792E-01],
	[3.6735000000E+04, 2.9825958301E+01, 5.2164971652E+00, 1.3014071712E+01, 3.3105209386E+00, 9.5770807950E-01],
	[3.6740000000E+04, 2.9832932300E+01, 5.2165192385E+00, 1.3019859412E+01, 3.3109901444E+00, 9.5772810084E-01],
	[3.6745000000E+04, 2.9839906980E+01, 5.2165413088E+00, 1.3025648897E+01, 3.3114592328E+00, 9.5774811193E-01],
	[3.6750000000E+04, 2.9846882342E+01, 5.2165633763E+00, 1.3031440168E+01, 3.3119282037E+00, 9.5776811278E-01],
	[3.6755000000E+04, 2.9853858385E+01, 5.2165854408E+00, 1.3037233224E+01, 3.3123970571E+00, 9.5778810339E-01],
	[3.6760000000E+04, 2.9860835109E+01, 5.2166075025E+00, 1.3043028067E+01, 3.3128657931E+00, 9.5780808379E-01],
	[3.6765000000E+04, 2.9867812515E+01, 5.2166295612E+00, 1.3048824696E+01, 3.3133344116E+00, 9.5782805396E-01],
	[3.6770000000E+04, 2.9874790601E+01, 5.2166516170E+00, 1.3054623112E+01, 3.3138029128E+00, 9.5784801391E-01],
	[3.6775000000E+04, 2.9881769369E+01, 5.2166736699E+00, 1.3060423315E+01, 3.3142712966E+00, 9.5786796366E-01],
	[3.6780000000E+04, 2.9888748818E+01, 5.2166957199E+00, 1.3066225305E+01, 3.3147395629E+00, 9.5788790320E-01],
	[3.6785000000E+04, 2.9895728948E+01, 5.2167177670E+00, 1.3072029084E+01, 3.3152077120E+00, 9.5790783254E-01],
	[3.6790000000E+04, 2.9902709759E+01, 5.2167398112E+00, 1.3077834650E+01, 3.3156757436E+00, 9.5792775168E-01],
	[3.6795000000E+04, 2.9909691251E+01, 5.2167618525E+00, 1.3083642004E+01, 3.3161436580E+00, 9.5794766064E-01],
	[3.6800000000E+04, 2.9916673425E+01, 5.2167838909E+00, 1.3089451147E+01, 3.3166114550E+00, 9.5796755942E-01],
	[3.6805000000E+04, 2.9923656279E+01, 5.2168059264E+00, 1.3095262079E+01, 3.3170791348E+00, 9.5798744802E-01],
	[3.6810000000E+04, 2.9930645051E+01, 5.2168286486E+00, 1.3101074801E+01, 3.3175470404E+00, 9.5800732645E-01],
	[3.6815000000E+04, 2.9937648025E+01, 5.2168531475E+00, 1.3106889311E+01, 3.3180157150E+00, 9.5802719471E-01],
	[3.6820000000E+04, 2.9944651686E+01, 5.2168776432E+00, 1.3112705612E+01, 3.3184842726E+00, 9.5804705281E-01],
	[3.6825000000E+04, 2.9951656034E+01, 5.2169021357E+00, 1.3118523703E+01, 3.3189527135E+00, 9.5806690076E-01],
	[3.6830000000E+04, 2.9958661069E+01, 5.2169266249E+00, 1.3124343584E+01, 3.3194210375E+00, 9.5808673856E-01],
	[3.6835000000E+04, 2.9965666791E+01, 5.2169511110E+00, 1.3130165256E+01, 3.3198892448E+00, 9.5810656621E-01],
	[3.6840000000E+04, 2.9972673200E+01, 5.2169755939E+00, 1.3135988719E+01, 3.3203573353E+00, 9.5812638373E-01],
	[3.6845000000E+04, 2.9979680296E+01, 5.2170000735E+00, 1.3141813974E+01, 3.3208253090E+00, 9.5814619111E-01],
	[3.6850000000E+04, 2.9986688080E+01, 5.2170245499E+00, 1.3147641020E+01, 3.3212931660E+00, 9.5816598837E-01],
	[3.6855000000E+04, 2.9993696550E+01, 5.2170490232E+00, 1.3153469858E+01, 3.3217609062E+00, 9.5818577550E-01],
	[3.6860000000E+04, 3.0000705707E+01, 5.2170734932E+00, 1.3159300489E+01, 3.3222285298E+00, 9.5820555252E-01],
	[3.6865000000E+04, 3.0007715551E+01, 5.2170979600E+00, 1.3165132912E+01, 3.3226960366E+00, 9.5822531943E-01],
	[3.6870000000E+04, 3.0014726082E+01, 5.2171224236E+00, 1.3170967128E+01, 3.3231634268E+00, 9.5824507623E-01],
	[3.6875000000E+04, 3.0021737300E+01, 5.2171468841E+00, 1.3176803137E+01, 3.3236307003E+00, 9.5826482293E-01],
	[3.6880000000E+04, 3.0028749204E+01, 5.2171713413E+00, 1.3182640940E+01, 3.3240978572E+00, 9.5828455954E-01],
	[3.6885000000E+04, 3.0035761795E+01, 5.2171957953E+00, 1.3188480537E+01, 3.3245648974E+00, 9.5830428605E-01],
	[3.6890000000E+04, 3.0042775074E+01, 5.2172202461E+00, 1.3194321928E+01, 3.3250318210E+00, 9.5832400248E-01],
	[3.6895000000E+04, 3.0049789039E+01, 5.2172446937E+00, 1.3200165113E+01, 3.3254986280E+00, 9.5834370883E-01],
	[3.6900000000E+04, 3.0056803690E+01, 5.2172691381E+00, 1.3206010093E+01, 3.3259653185E+00, 9.5836340511E-01],
	[3.6905000000E+04, 3.0063819028E+01, 5.2172935794E+00, 1.3211856869E+01, 3.3264318923E+00, 9.5838309131E-01],
	[3.6910000000E+04, 3.0070835053E+01, 5.2173180174E+00, 1.3217705439E+01, 3.3268983497E+00, 9.5840276745E-01],
	[3.6915000000E+04, 3.0077851765E+01, 5.2173424522E+00, 1.3223555805E+01, 3.3273646905E+00, 9.5842243352E-01],
	[3.6920000000E+04, 3.0084869163E+01, 5.2173668838E+00, 1.3229407968E+01, 3.3278309147E+00, 9.5844208954E-01],
	[3.6925000000E+04, 3.0091887248E+01, 5.2173913123E+00, 1.3235261926E+01, 3.3282970225E+00, 9.5846173551E-01],
	[3.6930000000E+04, 3.0098906020E+01, 5.2174157375E+00, 1.3241117681E+01, 3.3287630138E+00, 9.5848137144E-01],
	[3.6935000000E+04, 3.0105925478E+01, 5.2174401596E+00, 1.3246975234E+01, 3.3292288886E+00, 9.5850099732E-01],
	[3.6940000000E+04, 3.0112945622E+01, 5.2174645784E+00, 1.3252834583E+01, 3.3296946470E+00, 9.5852061316E-01],
	[3.6945000000E+04, 3.0119966453E+01, 5.2174889941E+00, 1.3258695730E+01, 3.3301602889E+00, 9.5854021898E-01],
	[3.6950000000E+04, 3.0126987970E+01, 5.2175134066E+00, 1.3264558675E+01, 3.3306258144E+00, 9.5855981477E-01],
	[3.6955000000E+04, 3.0134010174E+01, 5.2175378159E+00, 1.3270423418E+01, 3.3310912236E+00, 9.5857940053E-01],
	[3.6960000000E+04, 3.0141033064E+01, 5.2175622220E+00, 1.3276289959E+01, 3.3315565163E+00, 9.5859897628E-01],
	[3.6965000000E+04, 3.0148056641E+01, 5.2175866249E+00, 1.3282158299E+01, 3.3320216926E+00, 9.5861854202E-01],
	[3.6970000000E+04, 3.0155080904E+01, 5.2176110246E+00, 1.3288028438E+01, 3.3324867526E+00, 9.5863809775E-01],
	[3.6975000000E+04, 3.0162105854E+01, 5.2176354212E+00, 1.3293900377E+01, 3.3329516963E+00, 9.5865764348E-01],
	[3.6980000000E+04, 3.0169131489E+01, 5.2176598145E+00, 1.3299774115E+01, 3.3334165237E+00, 9.5867717922E-01],
	[3.6985000000E+04, 3.0176157811E+01, 5.2176842047E+00, 1.3305649654E+01, 3.3338812347E+00, 9.5869670496E-01],
	[3.6990000000E+04, 3.0183184819E+01, 5.2177085917E+00, 1.3311526992E+01, 3.3343458295E+00, 9.5871622072E-01],
	[3.6995000000E+04, 3.0190212514E+01, 5.2177329755E+00, 1.3317406132E+01, 3.3348103079E+00, 9.5873572649E-01],
	[3.7000000000E+04, 3.0197240894E+01, 5.2177573561E+00, 1.3323287072E+01, 3.3352746702E+00, 9.5875522229E-01],
	[3.7005000000E+04, 3.0204269961E+01, 5.2177817336E+00, 1.3329169813E+01, 3.3357389162E+00, 9.5877470811E-01],
	[3.7010000000E+04, 3.0211299714E+01, 5.2178061078E+00, 1.3335054356E+01, 3.3362030459E+00, 9.5879418397E-01],
	[3.7015000000E+04, 3.0218330153E+01, 5.2178304789E+00, 1.3340940701E+01, 3.3366670595E+00, 9.5881364987E-01],
	[3.7020000000E+04, 3.0225361279E+01, 5.2178548468E+00, 1.3346828848E+01, 3.3371309569E+00, 9.5883310580E-01],
	[3.7025000000E+04, 3.0232393090E+01, 5.2178792116E+00, 1.3352718798E+01, 3.3375947381E+00, 9.5885255179E-01],
	[3.7030000000E+04, 3.0239425587E+01, 5.2179035731E+00, 1.3358610550E+01, 3.3380584031E+00, 9.5887198783E-01],
	[3.7035000000E+04, 3.0246458771E+01, 5.2179279315E+00, 1.3364504105E+01, 3.3385219520E+00, 9.5889141393E-01],
	[3.7040000000E+04, 3.0253492640E+01, 5.2179522867E+00, 1.3370399464E+01, 3.3389853848E+00, 9.5891083009E-01],
	[3.7045000000E+04, 3.0260527195E+01, 5.2179766388E+00, 1.3376296626E+01, 3.3394487015E+00, 9.5893023632E-01],
	[3.7050000000E+04, 3.0267562437E+01, 5.2180009876E+00, 1.3382195593E+01, 3.3399119021E+00, 9.5894963262E-01],
	[3.7055000000E+04, 3.0274598364E+01, 5.2180253333E+00, 1.3388096364E+01, 3.3403749866E+00, 9.5896901900E-01],
	[3.7060000000E+04, 3.0281634977E+01, 5.2180496758E+00, 1.3393998939E+01, 3.3408379551E+00, 9.5898839546E-01],
	[3.7065000000E+04, 3.0288672276E+01, 5.2180740152E+00, 1.3399903319E+01, 3.3413008075E+00, 9.5900776201E-01],
	[3.7070000000E+04, 3.0295710261E+01, 5.2180983513E+00, 1.3405809505E+01, 3.3417635439E+00, 9.5902711865E-01],
	[3.7075000000E+04, 3.0302748932E+01, 5.2181226844E+00, 1.3411717496E+01, 3.3422261643E+00, 9.5904646539E-01],
	[3.7080000000E+04, 3.0309788288E+01, 5.2181470142E+00, 1.3417627293E+01, 3.3426886687E+00, 9.5906580223E-01],
	[3.7085000000E+04, 3.0316828330E+01, 5.2181713409E+00, 1.3423538896E+01, 3.3431510571E+00, 9.5908512918E-01],
	[3.7090000000E+04, 3.0323869058E+01, 5.2181956644E+00, 1.3429452306E+01, 3.3436133296E+00, 9.5910444624E-01],
	[3.7095000000E+04, 3.0330910472E+01, 5.2182199847E+00, 1.3435367522E+01, 3.3440754861E+00, 9.5912375342E-01],
	[3.7100000000E+04, 3.0337952571E+01, 5.2182443019E+00, 1.3441284545E+01, 3.3445375267E+00, 9.5914305072E-01],
	[3.7105000000E+04, 3.0344995357E+01, 5.2182686159E+00, 1.3447203376E+01, 3.3449994514E+00, 9.5916233814E-01],
	[3.7110000000E+04, 3.0352038827E+01, 5.2182929268E+00, 1.3453124015E+01, 3.3454612603E+00, 9.5918161570E-01],
	[3.7115000000E+04, 3.0359082984E+01, 5.2183172344E+00, 1.3459046461E+01, 3.3459229532E+00, 9.5920088340E-01],
	[3.7120000000E+04, 3.0366127825E+01, 5.2183415390E+00, 1.3464970716E+01, 3.3463845303E+00, 9.5922014124E-01],
	[3.7125000000E+04, 3.0373173353E+01, 5.2183658403E+00, 1.3470896780E+01, 3.3468459916E+00, 9.5923938922E-01],
	[3.7130000000E+04, 3.0380219566E+01, 5.2183901385E+00, 1.3476824652E+01, 3.3473073370E+00, 9.5925862736E-01],
	[3.7135000000E+04, 3.0387266465E+01, 5.2184144336E+00, 1.3482754334E+01, 3.3477685667E+00, 9.5927785566E-01],
	[3.7140000000E+04, 3.0394314049E+01, 5.2184387255E+00, 1.3488685825E+01, 3.3482296805E+00, 9.5929707411E-01],
	[3.7145000000E+04, 3.0401362318E+01, 5.2184630142E+00, 1.3494619127E+01, 3.3486906786E+00, 9.5931628273E-01],
	[3.7150000000E+04, 3.0408411273E+01, 5.2184872998E+00, 1.3500554238E+01, 3.3491515609E+00, 9.5933548153E-01],
	[3.7155000000E+04, 3.0415460913E+01, 5.2185115822E+00, 1.3506491160E+01, 3.3496123275E+00, 9.5935467050E-01],
	[3.7160000000E+04, 3.0422511239E+01, 5.2185358615E+00, 1.3512429892E+01, 3.3500729784E+00, 9.5937384965E-01],
	[3.7165000000E+04, 3.0429562250E+01, 5.2185601376E+00, 1.3518370436E+01, 3.3505335135E+00, 9.5939301899E-01],
	[3.7170000000E+04, 3.0436613946E+01, 5.2185844106E+00, 1.3524312791E+01, 3.3509939330E+00, 9.5941217852E-01],
	[3.7175000000E+04, 3.0443666328E+01, 5.2186086804E+00, 1.3530256958E+01, 3.3514542368E+00, 9.5943132825E-01],
	[3.7180000000E+04, 3.0450719395E+01, 5.2186329470E+00, 1.3536202937E+01, 3.3519144250E+00, 9.5945046818E-01],
	[3.7185000000E+04, 3.0457773147E+01, 5.2186572105E+00, 1.3542150728E+01, 3.3523744975E+00, 9.5946959831E-01],
	[3.7190000000E+04, 3.0464827585E+01, 5.2186814709E+00, 1.3548100332E+01, 3.3528344544E+00, 9.5948871866E-01],
	[3.7195000000E+04, 3.0471882708E+01, 5.2187057281E+00, 1.3554051748E+01, 3.3532942957E+00, 9.5950782922E-01],
	[3.7200000000E+04, 3.0478938516E+01, 5.2187299822E+00, 1.3560004978E+01, 3.3537540214E+00, 9.5952693000E-01],
	[3.7205000000E+04, 3.0485995009E+01, 5.2187542331E+00, 1.3565960022E+01, 3.3542136316E+00, 9.5954602101E-01],
	[3.7210000000E+04, 3.0493052187E+01, 5.2187784808E+00, 1.3571916879E+01, 3.3546731262E+00, 9.5956510225E-01],
	[3.7215000000E+04, 3.0500110050E+01, 5.2188027255E+00, 1.3577875551E+01, 3.3551325053E+00, 9.5958417373E-01],
	[3.7220000000E+04, 3.0507168598E+01, 5.2188269669E+00, 1.3583836037E+01, 3.3555917689E+00, 9.5960323545E-01],
	[3.7225000000E+04, 3.0514227832E+01, 5.2188512053E+00, 1.3589798338E+01, 3.3560509169E+00, 9.5962228741E-01],
	[3.7230000000E+04, 3.0521287750E+01, 5.2188754405E+00, 1.3595762454E+01, 3.3565099495E+00, 9.5964132962E-01],
	[3.7235000000E+04, 3.0528348354E+01, 5.2188996725E+00, 1.3601728386E+01, 3.3569688666E+00, 9.5966036209E-01],
	[3.7240000000E+04, 3.0535409642E+01, 5.2189239014E+00, 1.3607696133E+01, 3.3574276683E+00, 9.5967938482E-01],
	[3.7245000000E+04, 3.0542471615E+01, 5.2189481272E+00, 1.3613665696E+01, 3.3578863546E+00, 9.5969839782E-01],
	[3.7250000000E+04, 3.0549534274E+01, 5.2189723498E+00, 1.3619637075E+01, 3.3583449254E+00, 9.5971740109E-01],
	[3.7255000000E+04, 3.0556597617E+01, 5.2189965693E+00, 1.3625610271E+01, 3.3588033808E+00, 9.5973639463E-01],
	[3.7260000000E+04, 3.0563661645E+01, 5.2190207857E+00, 1.3631585285E+01, 3.3592617209E+00, 9.5975537845E-01],
	[3.7265000000E+04, 3.0570726358E+01, 5.2190449989E+00, 1.3637562115E+01, 3.3597199456E+00, 9.5977435256E-01],
	[3.7270000000E+04, 3.0577791756E+01, 5.2190692090E+00, 1.3643540763E+01, 3.3601780550E+00, 9.5979331696E-01],
	[3.7275000000E+04, 3.0584857838E+01, 5.2190934159E+00, 1.3649521229E+01, 3.3606360490E+00, 9.5981227166E-01],
	[3.7280000000E+04, 3.0591924605E+01, 5.2191176197E+00, 1.3655503513E+01, 3.3610939278E+00, 9.5983121665E-01],
	[3.7285000000E+04, 3.0598992058E+01, 5.2191418204E+00, 1.3661487615E+01, 3.3615516912E+00, 9.5985015195E-01],
	[3.7290000000E+04, 3.0606060194E+01, 5.2191660179E+00, 1.3667473537E+01, 3.3620093394E+00, 9.5986907756E-01],
	[3.7295000000E+04, 3.0613129016E+01, 5.2191902123E+00, 1.3673461277E+01, 3.3624668723E+00, 9.5988799349E-01],
	[3.7300000000E+04, 3.0620198522E+01, 5.2192144036E+00, 1.3679450837E+01, 3.3629242899E+00, 9.5990689973E-01],
	[3.7305000000E+04, 3.0627268713E+01, 5.2192385918E+00, 1.3685442217E+01, 3.3633815924E+00, 9.5992579630E-01],
	[3.7310000000E+04, 3.0634339588E+01, 5.2192627768E+00, 1.3691435416E+01, 3.3638387796E+00, 9.5994468320E-01],
	[3.7315000000E+04, 3.0641411148E+01, 5.2192869587E+00, 1.3697430436E+01, 3.3642958517E+00, 9.5996356044E-01],
	[3.7320000000E+04, 3.0648483393E+01, 5.2193111374E+00, 1.3703427277E+01, 3.3647528086E+00, 9.5998242801E-01],
	[3.7325000000E+04, 3.0655556322E+01, 5.2193353131E+00, 1.3709425938E+01, 3.3652096503E+00, 9.6000128593E-01],
	[3.7330000000E+04, 3.0662629935E+01, 5.2193594856E+00, 1.3715426421E+01, 3.3656663769E+00, 9.6002013420E-01],
	[3.7335000000E+04, 3.0669704234E+01, 5.2193836550E+00, 1.3721428726E+01, 3.3661229884E+00, 9.6003897282E-01],
	[3.7340000000E+04, 3.0676779216E+01, 5.2194078212E+00, 1.3727432852E+01, 3.3665794848E+00, 9.6005780181E-01],
	[3.7345000000E+04, 3.0683854883E+01, 5.2194319843E+00, 1.3733438801E+01, 3.3670358661E+00, 9.6007662116E-01],
	[3.7350000000E+04, 3.0690931235E+01, 5.2194561444E+00, 1.3739446572E+01, 3.3674921324E+00, 9.6009543087E-01],
	[3.7355000000E+04, 3.0698008270E+01, 5.2194803012E+00, 1.3745456166E+01, 3.3679482836E+00, 9.6011423097E-01],
	[3.7360000000E+04, 3.0705085991E+01, 5.2195044550E+00, 1.3751467583E+01, 3.3684043198E+00, 9.6013302144E-01],
	[3.7365000000E+04, 3.0712164395E+01, 5.2195286057E+00, 1.3757480823E+01, 3.3688602409E+00, 9.6015180229E-01],
	[3.7370000000E+04, 3.0719243484E+01, 5.2195527532E+00, 1.3763495887E+01, 3.3693160471E+00, 9.6017057354E-01],
	[3.7375000000E+04, 3.0726323257E+01, 5.2195768976E+00, 1.3769512776E+01, 3.3697717383E+00, 9.6018933518E-01],
	[3.7380000000E+04, 3.0733403715E+01, 5.2196010389E+00, 1.3775531488E+01, 3.3702273145E+00, 9.6020808722E-01],
	[3.7385000000E+04, 3.0740484856E+01, 5.2196251770E+00, 1.3781552026E+01, 3.3706827758E+00, 9.6022682966E-01],
	[3.7390000000E+04, 3.0747566682E+01, 5.2196493121E+00, 1.3787574388E+01, 3.3711381222E+00, 9.6024556251E-01],
	[3.7395000000E+04, 3.0754649192E+01, 5.2196734440E+00, 1.3793598575E+01, 3.3715933536E+00, 9.6026428577E-01],
	[3.7400000000E+04, 3.0761732386E+01, 5.2196975729E+00, 1.3799624589E+01, 3.3720484702E+00, 9.6028299946E-01],
	[3.7405000000E+04, 3.0768830445E+01, 5.2197235485E+00, 1.3805652428E+01, 3.3725044145E+00, 9.6030170357E-01],
	[3.7410000000E+04, 3.0775933534E+01, 5.2197500873E+00, 1.3811682093E+01, 3.3729605330E+00, 9.6032039810E-01],
	[3.7415000000E+04, 3.0783037315E+01, 5.2197766227E+00, 1.3817713585E+01, 3.3734165370E+00, 9.6033908307E-01],
	[3.7420000000E+04, 3.0790141785E+01, 5.2198031547E+00, 1.3823746903E+01, 3.3738724267E+00, 9.6035775848E-01],
	[3.7425000000E+04, 3.0797246945E+01, 5.2198296833E+00, 1.3829782049E+01, 3.3743282018E+00, 9.6037642433E-01],
	[3.7430000000E+04, 3.0804352795E+01, 5.2198562084E+00, 1.3835819022E+01, 3.3747838626E+00, 9.6039508063E-01],
	[3.7435000000E+04, 3.0811459336E+01, 5.2198827302E+00, 1.3841857823E+01, 3.3752394091E+00, 9.6041372739E-01],
	[3.7440000000E+04, 3.0818566566E+01, 5.2199092485E+00, 1.3847898453E+01, 3.3756948411E+00, 9.6043236460E-01],
	[3.7445000000E+04, 3.0825674487E+01, 5.2199357634E+00, 1.3853940910E+01, 3.3761501588E+00, 9.6045099227E-01],
	[3.7450000000E+04, 3.0832783097E+01, 5.2199622750E+00, 1.3859985196E+01, 3.3766053622E+00, 9.6046961042E-01],
	[3.7455000000E+04, 3.0839892398E+01, 5.2199887831E+00, 1.3866031311E+01, 3.3770604513E+00, 9.6048821903E-01],
	[3.7460000000E+04, 3.0847002388E+01, 5.2200152878E+00, 1.3872079256E+01, 3.3775154261E+00, 9.6050681813E-01],
	[3.7465000000E+04, 3.0854113068E+01, 5.2200417891E+00, 1.3878129030E+01, 3.3779702866E+00, 9.6052540771E-01],
	[3.7470000000E+04, 3.0861224438E+01, 5.2200682870E+00, 1.3884180634E+01, 3.3784250329E+00, 9.6054398777E-01],
	[3.7475000000E+04, 3.0868336498E+01, 5.2200947815E+00, 1.3890234068E+01, 3.3788796650E+00, 9.6056255833E-01],
	[3.7480000000E+04, 3.0875449248E+01, 5.2201212726E+00, 1.3896289333E+01, 3.3793341828E+00, 9.6058111938E-01],
	[3.7485000000E+04, 3.0882562687E+01, 5.2201477604E+00, 1.3902346428E+01, 3.3797885864E+00, 9.6059967094E-01],
	[3.7490000000E+04, 3.0889676817E+01, 5.2201742447E+00, 1.3908405355E+01, 3.3802428758E+00, 9.6061821301E-01],
	[3.7495000000E+04, 3.0896791636E+01, 5.2202007256E+00, 1.3914466113E+01, 3.3806970511E+00, 9.6063674559E-01],
	[3.7500000000E+04, 3.0903907145E+01, 5.2202272031E+00, 1.3920528703E+01, 3.3811511122E+00, 9.6065526868E-01],
	[3.7505000000E+04, 3.0911023343E+01, 5.2202536772E+00, 1.3926593125E+01, 3.3816050592E+00, 9.6067378230E-01],
	[3.7510000000E+04, 3.0918140231E+01, 5.2202801480E+00, 1.3932659380E+01, 3.3820588921E+00, 9.6069228645E-01],
	[3.7515000000E+04, 3.0925257809E+01, 5.2203066153E+00, 1.3938727467E+01, 3.3825126109E+00, 9.6071078113E-01],
	[3.7520000000E+04, 3.0932376077E+01, 5.2203330792E+00, 1.3944797387E+01, 3.3829662156E+00, 9.6072926634E-01],
	[3.7525000000E+04, 3.0939495034E+01, 5.2203595398E+00, 1.3950869140E+01, 3.3834197062E+00, 9.6074774210E-01],
	[3.7530000000E+04, 3.0946614680E+01, 5.2203859969E+00, 1.3956942728E+01, 3.3838730828E+00, 9.6076620840E-01],
	[3.7535000000E+04, 3.0953735016E+01, 5.2204124507E+00, 1.3963018149E+01, 3.3843263454E+00, 9.6078466526E-01],
	[3.7540000000E+04, 3.0960856042E+01, 5.2204389011E+00, 1.3969095404E+01, 3.3847794940E+00, 9.6080311267E-01],
	[3.7545000000E+04, 3.0967977757E+01, 5.2204653481E+00, 1.3975174494E+01, 3.3852325285E+00, 9.6082155064E-01],
	[3.7550000000E+04, 3.0975100162E+01, 5.2204917917E+00, 1.3981255419E+01, 3.3856854492E+00, 9.6083997918E-01],
	[3.7555000000E+04, 3.0982223256E+01, 5.2205182319E+00, 1.3987338178E+01, 3.3861382558E+00, 9.6085839830E-01],
	[3.7560000000E+04, 3.0989347039E+01, 5.2205446687E+00, 1.3993422774E+01, 3.3865909485E+00, 9.6087680798E-01],
	[3.7565000000E+04, 3.0996471512E+01, 5.2205711022E+00, 1.3999509205E+01, 3.3870435274E+00, 9.6089520825E-01],
	[3.7570000000E+04, 3.1003596675E+01, 5.2205975322E+00, 1.4005597472E+01, 3.3874959923E+00, 9.6091359911E-01],
	[3.7575000000E+04, 3.1010722526E+01, 5.2206239589E+00, 1.4011687576E+01, 3.3879483433E+00, 9.6093198056E-01],
	[3.7580000000E+04, 3.1017849067E+01, 5.2206503822E+00, 1.4017779517E+01, 3.3884005805E+00, 9.6095035260E-01],
	[3.7585000000E+04, 3.1024976297E+01, 5.2206768021E+00, 1.4023873294E+01, 3.3888527038E+00, 9.6096871525E-01],
	[3.7590000000E+04, 3.1032104217E+01, 5.2207032186E+00, 1.4029968909E+01, 3.3893047133E+00, 9.6098706850E-01],
	[3.7595000000E+04, 3.1039232826E+01, 5.2207296318E+00, 1.4036066361E+01, 3.3897566090E+00, 9.6100541236E-01],
	[3.7600000000E+04, 3.1046362124E+01, 5.2207560416E+00, 1.4042165652E+01, 3.3902083909E+00, 9.6102374684E-01],
	[3.7605000000E+04, 3.1053492111E+01, 5.2207824479E+00, 1.4048266780E+01, 3.3906600590E+00, 9.6104207193E-01],
	[3.7610000000E+04, 3.1060622787E+01, 5.2208088510E+00, 1.4054369748E+01, 3.3911116134E+00, 9.6106038766E-01],
	[3.7615000000E+04, 3.1067754153E+01, 5.2208352506E+00, 1.4060474554E+01, 3.3915630540E+00, 9.6107869401E-01],
	[3.7620000000E+04, 3.1074886207E+01, 5.2208616469E+00, 1.4066581199E+01, 3.3920143809E+00, 9.6109699100E-01],
	[3.7625000000E+04, 3.1082018951E+01, 5.2208880398E+00, 1.4072689684E+01, 3.3924655941E+00, 9.6111527863E-01],
	[3.7630000000E+04, 3.1089152384E+01, 5.2209144293E+00, 1.4078800008E+01, 3.3929166936E+00, 9.6113355691E-01],
	[3.7635000000E+04, 3.1096286506E+01, 5.2209408154E+00, 1.4084912173E+01, 3.3933676795E+00, 9.6115182583E-01],
	[3.7640000000E+04, 3.1103421316E+01, 5.2209671982E+00, 1.4091026178E+01, 3.3938185517E+00, 9.6117008541E-01],
	[3.7645000000E+04, 3.1110556816E+01, 5.2209935776E+00, 1.4097142024E+01, 3.3942693103E+00, 9.6118833565E-01],
	[3.7650000000E+04, 3.1117693005E+01, 5.2210199536E+00, 1.4103259711E+01, 3.3947199552E+00, 9.6120657656E-01],
	[3.7655000000E+04, 3.1124829883E+01, 5.2210463263E+00, 1.4109379240E+01, 3.3951704866E+00, 9.6122480813E-01],
	[3.7660000000E+04, 3.1131967450E+01, 5.2210726956E+00, 1.4115500610E+01, 3.3956209044E+00, 9.6124303038E-01],
	[3.7665000000E+04, 3.1139105705E+01, 5.2210990615E+00, 1.4121623822E+01, 3.3960712087E+00, 9.6126124331E-01],
	[3.7670000000E+04, 3.1146244650E+01, 5.2211254240E+00, 1.4127748876E+01, 3.3965213994E+00, 9.6127944692E-01],
	[3.7675000000E+04, 3.1153384283E+01, 5.2211517832E+00, 1.4133875773E+01, 3.3969714766E+00, 9.6129764122E-01],
	[3.7680000000E+04, 3.1160524605E+01, 5.2211781391E+00, 1.4140004513E+01, 3.3974214403E+00, 9.6131582622E-01],
	[3.7685000000E+04, 3.1167665616E+01, 5.2212044915E+00, 1.4146135096E+01, 3.3978712905E+00, 9.6133400192E-01],
	[3.7690000000E+04, 3.1174807316E+01, 5.2212308406E+00, 1.4152267522E+01, 3.3983210272E+00, 9.6135216832E-01],
	[3.7695000000E+04, 3.1181949704E+01, 5.2212571864E+00, 1.4158401793E+01, 3.3987706505E+00, 9.6137032543E-01],
	[3.7700000000E+04, 3.1189092781E+01, 5.2212835287E+00, 1.4164537907E+01, 3.3992201604E+00, 9.6138847325E-01],
	[3.7705000000E+04, 3.1196236547E+01, 5.2213098678E+00, 1.4170675866E+01, 3.3996695568E+00, 9.6140661179E-01],
	[3.7710000000E+04, 3.1203381002E+01, 5.2213362034E+00, 1.4176815670E+01, 3.4001188399E+00, 9.6142474106E-01],
	[3.7715000000E+04, 3.1210526145E+01, 5.2213625357E+00, 1.4182957319E+01, 3.4005680095E+00, 9.6144286105E-01],
	[3.7720000000E+04, 3.1217671976E+01, 5.2213888646E+00, 1.4189100813E+01, 3.4010170659E+00, 9.6146097178E-01],
	[3.7725000000E+04, 3.1224818497E+01, 5.2214151902E+00, 1.4195246153E+01, 3.4014660088E+00, 9.6147907324E-01],
	[3.7730000000E+04, 3.1231965706E+01, 5.2214415124E+00, 1.4201393339E+01, 3.4019148385E+00, 9.6149716545E-01],
	[3.7735000000E+04, 3.1239113603E+01, 5.2214678313E+00, 1.4207542371E+01, 3.4023635549E+00, 9.6151524841E-01],
	[3.7740000000E+04, 3.1246262189E+01, 5.2214941468E+00, 1.4213693250E+01, 3.4028121580E+00, 9.6153332212E-01],
	[3.7745000000E+04, 3.1253411464E+01, 5.2215204590E+00, 1.4219845975E+01, 3.4032606478E+00, 9.6155138658E-01],
	[3.7750000000E+04, 3.1260561427E+01, 5.2215467678E+00, 1.4226000548E+01, 3.4037090243E+00, 9.6156944182E-01],
	[3.7755000000E+04, 3.1267712078E+01, 5.2215730733E+00, 1.4232156969E+01, 3.4041572877E+00, 9.6158748781E-01],
	[3.7760000000E+04, 3.1274863418E+01, 5.2215993754E+00, 1.4238315237E+01, 3.4046054378E+00, 9.6160552458E-01],
	[3.7765000000E+04, 3.1282015446E+01, 5.2216256741E+00, 1.4244475354E+01, 3.4050534748E+00, 9.6162355213E-01],
	[3.7770000000E+04, 3.1289168163E+01, 5.2216519695E+00, 1.4250637319E+01, 3.4055013985E+00, 9.6164157046E-01],
	[3.7775000000E+04, 3.1296321568E+01, 5.2216782616E+00, 1.4256801133E+01, 3.4059492091E+00, 9.6165957958E-01],
	[3.7780000000E+04, 3.1303475661E+01, 5.2217045503E+00, 1.4262966796E+01, 3.4063969066E+00, 9.6167757949E-01],
	[3.7785000000E+04, 3.1310630443E+01, 5.2217308357E+00, 1.4269134308E+01, 3.4068444910E+00, 9.6169557020E-01],
	[3.7790000000E+04, 3.1317785913E+01, 5.2217571177E+00, 1.4275303670E+01, 3.4072919622E+00, 9.6171355170E-01],
	[3.7795000000E+04, 3.1324942071E+01, 5.2217833964E+00, 1.4281474882E+01, 3.4077393204E+00, 9.6173152402E-01],
	[3.7800000000E+04, 3.1332098917E+01, 5.2218096717E+00, 1.4287647944E+01, 3.4081865655E+00, 9.6174948715E-01],
	[3.7805000000E+04, 3.1339256452E+01, 5.2218359437E+00, 1.4293822858E+01, 3.4086336976E+00, 9.6176744109E-01],
	[3.7810000000E+04, 3.1346414675E+01, 5.2218622123E+00, 1.4299999622E+01, 3.4090807166E+00, 9.6178538585E-01],
	[3.7815000000E+04, 3.1353573585E+01, 5.2218884776E+00, 1.4306178237E+01, 3.4095276227E+00, 9.6180332144E-01],
	[3.7820000000E+04, 3.1360733184E+01, 5.2219147396E+00, 1.4312358704E+01, 3.4099744157E+00, 9.6182124787E-01],
	[3.7825000000E+04, 3.1367893472E+01, 5.2219409982E+00, 1.4318541022E+01, 3.4104210958E+00, 9.6183916512E-01],
	[3.7830000000E+04, 3.1375054447E+01, 5.2219672535E+00, 1.4324725193E+01, 3.4108676629E+00, 9.6185707322E-01],
	[3.7835000000E+04, 3.1382216110E+01, 5.2219935054E+00, 1.4330911217E+01, 3.4113141171E+00, 9.6187497217E-01],
	[3.7840000000E+04, 3.1389378461E+01, 5.2220197540E+00, 1.4337099093E+01, 3.4117604584E+00, 9.6189286196E-01],
	[3.7845000000E+04, 3.1396541500E+01, 5.2220459993E+00, 1.4343288822E+01, 3.4122066868E+00, 9.6191074261E-01],
	[3.7850000000E+04, 3.1403705228E+01, 5.2220722413E+00, 1.4349480405E+01, 3.4126528023E+00, 9.6192861412E-01],
	[3.7855000000E+04, 3.1410869643E+01, 5.2220984799E+00, 1.4355673842E+01, 3.4130988049E+00, 9.6194647650E-01],
	[3.7860000000E+04, 3.1418034746E+01, 5.2221247151E+00, 1.4361869132E+01, 3.4135446947E+00, 9.6196432975E-01],
	[3.7865000000E+04, 3.1425200537E+01, 5.2221509471E+00, 1.4368066277E+01, 3.4139904717E+00, 9.6198217387E-01],
	[3.7870000000E+04, 3.1432367016E+01, 5.2221771757E+00, 1.4374265277E+01, 3.4144361359E+00, 9.6200000887E-01],
	[3.7875000000E+04, 3.1439534182E+01, 5.2222034009E+00, 1.4380466131E+01, 3.4148816873E+00, 9.6201783476E-01],
	[3.7880000000E+04, 3.1446702037E+01, 5.2222296229E+00, 1.4386668841E+01, 3.4153271259E+00, 9.6203565153E-01],
	[3.7885000000E+04, 3.1453870579E+01, 5.2222558415E+00, 1.4392873407E+01, 3.4157724518E+00, 9.6205345920E-01],
	[3.7890000000E+04, 3.1461039809E+01, 5.2222820568E+00, 1.4399079828E+01, 3.4162176650E+00, 9.6207125777E-01],
	[3.7895000000E+04, 3.1468209727E+01, 5.2223082687E+00, 1.4405288106E+01, 3.4166627654E+00, 9.6208904724E-01],
	[3.7900000000E+04, 3.1475380333E+01, 5.2223344774E+00, 1.4411498240E+01, 3.4171077532E+00, 9.6210682762E-01],
	[3.7905000000E+04, 3.1482551626E+01, 5.2223606827E+00, 1.4417710231E+01, 3.4175526283E+00, 9.6212459892E-01],
	[3.7910000000E+04, 3.1489723607E+01, 5.2223868847E+00, 1.4423924079E+01, 3.4179973907E+00, 9.6214236114E-01],
	[3.7915000000E+04, 3.1496896276E+01, 5.2224130833E+00, 1.4430139785E+01, 3.4184420405E+00, 9.6216011427E-01],
	[3.7920000000E+04, 3.1504069632E+01, 5.2224392786E+00, 1.4436357348E+01, 3.4188865777E+00, 9.6217785834E-01],
	[3.7925000000E+04, 3.1511243676E+01, 5.2224654707E+00, 1.4442576770E+01, 3.4193310023E+00, 9.6219559334E-01],
	[3.7930000000E+04, 3.1518418407E+01, 5.2224916593E+00, 1.4448798049E+01, 3.4197753143E+00, 9.6221331928E-01],
	[3.7935000000E+04, 3.1525593826E+01, 5.2225178447E+00, 1.4455021188E+01, 3.4202195137E+00, 9.6223103616E-01],
	[3.7940000000E+04, 3.1532769933E+01, 5.2225440268E+00, 1.4461246186E+01, 3.4206636006E+00, 9.6224874399E-01],
	[3.7945000000E+04, 3.1539946727E+01, 5.2225702055E+00, 1.4467473042E+01, 3.4211075750E+00, 9.6226644277E-01],
	[3.7950000000E+04, 3.1547124208E+01, 5.2225963809E+00, 1.4473701759E+01, 3.4215514369E+00, 9.6228413251E-01],
	[3.7955000000E+04, 3.1554302377E+01, 5.2226225530E+00, 1.4479932335E+01, 3.4219951863E+00, 9.6230181321E-01],
	[3.7960000000E+04, 3.1561481234E+01, 5.2226487218E+00, 1.4486164772E+01, 3.4224388232E+00, 9.6231948488E-01],
	[3.7965000000E+04, 3.1568660778E+01, 5.2226748872E+00, 1.4492399069E+01, 3.4228823477E+00, 9.6233714752E-01],
	[3.7970000000E+04, 3.1575841009E+01, 5.2227010494E+00, 1.4498635228E+01, 3.4233257597E+00, 9.6235480114E-01],
	[3.7975000000E+04, 3.1583021927E+01, 5.2227272082E+00, 1.4504873247E+01, 3.4237690594E+00, 9.6237244574E-01],
	[3.7980000000E+04, 3.1590203533E+01, 5.2227533637E+00, 1.4511113128E+01, 3.4242122466E+00, 9.6239008133E-01],
	[3.7985000000E+04, 3.1597385826E+01, 5.2227795159E+00, 1.4517354870E+01, 3.4246553215E+00, 9.6240770791E-01],
	[3.7990000000E+04, 3.1604568807E+01, 5.2228056648E+00, 1.4523598475E+01, 3.4250982841E+00, 9.6242532548E-01],
	[3.7995000000E+04, 3.1611752474E+01, 5.2228318104E+00, 1.4529843942E+01, 3.4255411343E+00, 9.6244293406E-01],
	[3.8000000000E+04, 3.1618936829E+01, 5.2228579527E+00, 1.4536091272E+01, 3.4259838721E+00, 9.6246053364E-01],
	[3.8005000000E+04, 3.1626128160E+01, 5.2228849051E+00, 1.4542340465E+01, 3.4264269216E+00, 9.6247812423E-01],
	[3.8010000000E+04, 3.1633332174E+01, 5.2229134054E+00, 1.4548591521E+01, 3.4268706676E+00, 9.6249570584E-01],
	[3.8015000000E+04, 3.1640536882E+01, 5.2229419021E+00, 1.4554844441E+01, 3.4273143016E+00, 9.6251327847E-01],
	[3.8020000000E+04, 3.1647742282E+01, 5.2229703952E+00, 1.4561099225E+01, 3.4277578238E+00, 9.6253084212E-01],
	[3.8025000000E+04, 3.1654948376E+01, 5.2229988847E+00, 1.4567355873E+01, 3.4282012341E+00, 9.6254839681E-01],
	[3.8030000000E+04, 3.1662155163E+01, 5.2230273706E+00, 1.4573614386E+01, 3.4286445326E+00, 9.6256594253E-01],
	[3.8035000000E+04, 3.1669362642E+01, 5.2230558530E+00, 1.4579874763E+01, 3.4290877193E+00, 9.6258347929E-01],
	[3.8040000000E+04, 3.1676570815E+01, 5.2230843317E+00, 1.4586137006E+01, 3.4295307941E+00, 9.6260100709E-01],
	[3.8045000000E+04, 3.1683779680E+01, 5.2231128069E+00, 1.4592401115E+01, 3.4299737572E+00, 9.6261852594E-01],
	[3.8050000000E+04, 3.1690989238E+01, 5.2231412785E+00, 1.4598667089E+01, 3.4304166086E+00, 9.6263603585E-01],
	[3.8055000000E+04, 3.1698199490E+01, 5.2231697464E+00, 1.4604934929E+01, 3.4308593482E+00, 9.6265353682E-01],
	[3.8060000000E+04, 3.1705410434E+01, 5.2231982108E+00, 1.4611204636E+01, 3.4313019760E+00, 9.6267102885E-01],
	[3.8065000000E+04, 3.1712622071E+01, 5.2232266717E+00, 1.4617476210E+01, 3.4317444922E+00, 9.6268851195E-01],
	[3.8070000000E+04, 3.1719834400E+01, 5.2232551289E+00, 1.4623749650E+01, 3.4321868967E+00, 9.6270598612E-01],
	[3.8075000000E+04, 3.1727047423E+01, 5.2232835825E+00, 1.4630024958E+01, 3.4326291895E+00, 9.6272345137E-01],
	[3.8080000000E+04, 3.1734261138E+01, 5.2233120326E+00, 1.4636302134E+01, 3.4330713707E+00, 9.6274090771E-01],
	[3.8085000000E+04, 3.1741475546E+01, 5.2233404791E+00, 1.4642581178E+01, 3.4335134402E+00, 9.6275835513E-01],
	[3.8090000000E+04, 3.1748690647E+01, 5.2233689220E+00, 1.4648862090E+01, 3.4339553982E+00, 9.6277579365E-01],
	[3.8095000000E+04, 3.1755906440E+01, 5.2233973613E+00, 1.4655144871E+01, 3.4343972445E+00, 9.6279322326E-01],
	[3.8100000000E+04, 3.1763122926E+01, 5.2234257971E+00, 1.4661429520E+01, 3.4348389793E+00, 9.6281064398E-01],
	[3.8105000000E+04, 3.1770340105E+01, 5.2234542293E+00, 1.4667716039E+01, 3.4352806025E+00, 9.6282805581E-01],
	[3.8110000000E+04, 3.1777557976E+01, 5.2234826579E+00, 1.4674004427E+01, 3.4357221142E+00, 9.6284545874E-01],
	[3.8115000000E+04, 3.1784776540E+01, 5.2235110829E+00, 1.4680294686E+01, 3.4361635144E+00, 9.6286285280E-01],
	[3.8120000000E+04, 3.1791995796E+01, 5.2235395044E+00, 1.4686586814E+01, 3.4366048031E+00, 9.6288023797E-01],
	[3.8125000000E+04, 3.1799215745E+01, 5.2235679222E+00, 1.4692880813E+01, 3.4370459803E+00, 9.6289761427E-01],
	[3.8130000000E+04, 3.1806436386E+01, 5.2235963365E+00, 1.4699176683E+01, 3.4374870461E+00, 9.6291498171E-01],
	[3.8135000000E+04, 3.1813657720E+01, 5.2236247473E+00, 1.4705474424E+01, 3.4379280004E+00, 9.6293234028E-01],
	[3.8140000000E+04, 3.1820879747E+01, 5.2236531544E+00, 1.4711774036E+01, 3.4383688433E+00, 9.6294968999E-01],
	[3.8145000000E+04, 3.1828102465E+01, 5.2236815580E+00, 1.4718075520E+01, 3.4388095748E+00, 9.6296703085E-01],
	[3.8150000000E+04, 3.1835325877E+01, 5.2237099581E+00, 1.4724378876E+01, 3.4392501949E+00, 9.6298436285E-01],
	[3.8155000000E+04, 3.1842549980E+01, 5.2237383545E+00, 1.4730684104E+01, 3.4396907037E+00, 9.6300168602E-01],
	[3.8160000000E+04, 3.1849774776E+01, 5.2237667474E+00, 1.4736991205E+01, 3.4401311011E+00, 9.6301900034E-01],
	[3.8165000000E+04, 3.1857000264E+01, 5.2237951367E+00, 1.4743300179E+01, 3.4405713872E+00, 9.6303630583E-01],
	[3.8170000000E+04, 3.1864226445E+01, 5.2238235225E+00, 1.4749611026E+01, 3.4410115620E+00, 9.6305360249E-01],
	[3.8175000000E+04, 3.1871453318E+01, 5.2238519047E+00, 1.4755923747E+01, 3.4414516255E+00, 9.6307089032E-01],
	[3.8180000000E+04, 3.1878680883E+01, 5.2238802833E+00, 1.4762238342E+01, 3.4418915777E+00, 9.6308816933E-01],
	[3.8185000000E+04, 3.1885909140E+01, 5.2239086584E+00, 1.4768554811E+01, 3.4423314187E+00, 9.6310543953E-01],
	[3.8190000000E+04, 3.1893138090E+01, 5.2239370299E+00, 1.4774873155E+01, 3.4427711485E+00, 9.6312270092E-01],
	[3.8195000000E+04, 3.1900367732E+01, 5.2239653979E+00, 1.4781193373E+01, 3.4432107671E+00, 9.6313995350E-01],
	[3.8200000000E+04, 3.1907598066E+01, 5.2239937623E+00, 1.4787515466E+01, 3.4436502744E+00, 9.6315719728E-01],
	[3.8205000000E+04, 3.1914829092E+01, 5.2240221231E+00, 1.4793839435E+01, 3.4440896706E+00, 9.6317443226E-01],
	[3.8210000000E+04, 3.1922060810E+01, 5.2240504804E+00, 1.4800165280E+01, 3.4445289557E+00, 9.6319165845E-01],
	[3.8215000000E+04, 3.1929293220E+01, 5.2240788341E+00, 1.4806493001E+01, 3.4449681296E+00, 9.6320887585E-01],
	[3.8220000000E+04, 3.1936526323E+01, 5.2241071843E+00, 1.4812822598E+01, 3.4454071924E+00, 9.6322608448E-01],
	[3.8225000000E+04, 3.1943760117E+01, 5.2241355309E+00, 1.4819154072E+01, 3.4458461441E+00, 9.6324328432E-01],
	[3.8230000000E+04, 3.1950994604E+01, 5.2241638739E+00, 1.4825487422E+01, 3.4462849847E+00, 9.6326047539E-01],
	[3.8235000000E+04, 3.1958229782E+01, 5.2241922135E+00, 1.4831822651E+01, 3.4467237143E+00, 9.6327765770E-01],
	[3.8240000000E+04, 3.1965465653E+01, 5.2242205494E+00, 1.4838159756E+01, 3.4471623329E+00, 9.6329483124E-01],
	[3.8245000000E+04, 3.1972702215E+01, 5.2242488818E+00, 1.4844498740E+01, 3.4476008404E+00, 9.6331199602E-01],
	[3.8250000000E+04, 3.1979939469E+01, 5.2242772107E+00, 1.4850839602E+01, 3.4480392369E+00, 9.6332915205E-01],
	[3.8255000000E+04, 3.1987177415E+01, 5.2243055360E+00, 1.4857182343E+01, 3.4484775225E+00, 9.6334629933E-01],
	[3.8260000000E+04, 3.1994416053E+01, 5.2243338577E+00, 1.4863526962E+01, 3.4489156971E+00, 9.6336343787E-01],
	[3.8265000000E+04, 3.2001655383E+01, 5.2243621759E+00, 1.4869873461E+01, 3.4493537607E+00, 9.6338056767E-01],
	[3.8270000000E+04, 3.2008895405E+01, 5.2243904906E+00, 1.4876221839E+01, 3.4497917135E+00, 9.6339768873E-01],
	[3.8275000000E+04, 3.2016136119E+01, 5.2244188017E+00, 1.4882572097E+01, 3.4502295553E+00, 9.6341480107E-01],
	[3.8280000000E+04, 3.2023377524E+01, 5.2244471093E+00, 1.4888924234E+01, 3.4506672862E+00, 9.6343190467E-01],
	[3.8285000000E+04, 3.2030619621E+01, 5.2244754133E+00, 1.4895278253E+01, 3.4511049063E+00, 9.6344899956E-01],
	[3.8290000000E+04, 3.2037862410E+01, 5.2245037138E+00, 1.4901634152E+01, 3.4515424156E+00, 9.6346608574E-01],
	[3.8295000000E+04, 3.2045105890E+01, 5.2245320107E+00, 1.4907991932E+01, 3.4519798140E+00, 9.6348316320E-01],
	[3.8300000000E+04, 3.2052350063E+01, 5.2245603041E+00, 1.4914351594E+01, 3.4524171016E+00, 9.6350023196E-01],
	[3.8305000000E+04, 3.2059594927E+01, 5.2245885940E+00, 1.4920713137E+01, 3.4528542785E+00, 9.6351729202E-01],
	[3.8310000000E+04, 3.2066840482E+01, 5.2246168803E+00, 1.4927076562E+01, 3.4532913445E+00, 9.6353434338E-01],
	[3.8315000000E+04, 3.2074086729E+01, 5.2246451631E+00, 1.4933441870E+01, 3.4537282999E+00, 9.6355138605E-01],
	[3.8320000000E+04, 3.2081333668E+01, 5.2246734423E+00, 1.4939809060E+01, 3.4541651445E+00, 9.6356842003E-01],
	[3.8325000000E+04, 3.2088581298E+01, 5.2247017180E+00, 1.4946178133E+01, 3.4546018783E+00, 9.6358544533E-01],
	[3.8330000000E+04, 3.2095829620E+01, 5.2247299902E+00, 1.4952549089E+01, 3.4550385015E+00, 9.6360246196E-01],
	[3.8335000000E+04, 3.2103078633E+01, 5.2247582588E+00, 1.4958921928E+01, 3.4554750141E+00, 9.6361946991E-01],
	[3.8340000000E+04, 3.2110328338E+01, 5.2247865239E+00, 1.4965296652E+01, 3.4559114160E+00, 9.6363646920E-01],
	[3.8345000000E+04, 3.2117578734E+01, 5.2248147855E+00, 1.4971673260E+01, 3.4563477072E+00, 9.6365345982E-01],
	[3.8350000000E+04, 3.2124829822E+01, 5.2248430435E+00, 1.4978051752E+01, 3.4567838879E+00, 9.6367044178E-01],
	[3.8355000000E+04, 3.2132081601E+01, 5.2248712980E+00, 1.4984432129E+01, 3.4572199579E+00, 9.6368741509E-01],
	[3.8360000000E+04, 3.2139334071E+01, 5.2248995490E+00, 1.4990814391E+01, 3.4576559174E+00, 9.6370437975E-01],
	[3.8365000000E+04, 3.2146587233E+01, 5.2249277964E+00, 1.4997198538E+01, 3.4580917664E+00, 9.6372133577E-01],
	[3.8370000000E+04, 3.2153841086E+01, 5.2249560404E+00, 1.5003584571E+01, 3.4585275048E+00, 9.6373828315E-01],
	[3.8375000000E+04, 3.2161095631E+01, 5.2249842808E+00, 1.5009972491E+01, 3.4589631326E+00, 9.6375522190E-01],
	[3.8380000000E+04, 3.2168350867E+01, 5.2250125176E+00, 1.5016362296E+01, 3.4593986500E+00, 9.6377215201E-01],
	[3.8385000000E+04, 3.2175606794E+01, 5.2250407510E+00, 1.5022753988E+01, 3.4598340570E+00, 9.6378907350E-01],
	[3.8390000000E+04, 3.2182863412E+01, 5.2250689808E+00, 1.5029147567E+01, 3.4602693534E+00, 9.6380598637E-01],
	[3.8395000000E+04, 3.2190120722E+01, 5.2250972071E+00, 1.5035543034E+01, 3.4607045395E+00, 9.6382289062E-01],
	[3.8400000000E+04, 3.2197378722E+01, 5.2251254298E+00, 1.5041940387E+01, 3.4611396151E+00, 9.6383978625E-01],
	[3.8405000000E+04, 3.2204637414E+01, 5.2251536491E+00, 1.5048339629E+01, 3.4615745803E+00, 9.6385667328E-01],
	[3.8410000000E+04, 3.2211896797E+01, 5.2251818648E+00, 1.5054740759E+01, 3.4620094352E+00, 9.6387355171E-01],
	[3.8415000000E+04, 3.2219156872E+01, 5.2252100770E+00, 1.5061143778E+01, 3.4624441797E+00, 9.6389042153E-01],
	[3.8420000000E+04, 3.2226417637E+01, 5.2252382857E+00, 1.5067548685E+01, 3.4628788138E+00, 9.6390728276E-01],
	[3.8425000000E+04, 3.2233679093E+01, 5.2252664908E+00, 1.5073955481E+01, 3.4633133377E+00, 9.6392413540E-01],
	[3.8430000000E+04, 3.2240941241E+01, 5.2252946925E+00, 1.5080364167E+01, 3.4637477512E+00, 9.6394097945E-01],
	[3.8435000000E+04, 3.2248204079E+01, 5.2253228906E+00, 1.5086774743E+01, 3.4641820545E+00, 9.6395781491E-01],
	[3.8440000000E+04, 3.2255467608E+01, 5.2253510852E+00, 1.5093187208E+01, 3.4646162475E+00, 9.6397464180E-01],
	[3.8445000000E+04, 3.2262731829E+01, 5.2253792763E+00, 1.5099601564E+01, 3.4650503303E+00, 9.6399146011E-01],
	[3.8450000000E+04, 3.2269996740E+01, 5.2254074639E+00, 1.5106017811E+01, 3.4654843028E+00, 9.6400826986E-01],
	[3.8455000000E+04, 3.2277262343E+01, 5.2254356480E+00, 1.5112435949E+01, 3.4659181652E+00, 9.6402507104E-01],
	[3.8460000000E+04, 3.2284528636E+01, 5.2254638285E+00, 1.5118855978E+01, 3.4663519173E+00, 9.6404186365E-01],
	[3.8465000000E+04, 3.2291795620E+01, 5.2254920056E+00, 1.5125277898E+01, 3.4667855594E+00, 9.6405864771E-01],
	[3.8470000000E+04, 3.2299063295E+01, 5.2255201791E+00, 1.5131701711E+01, 3.4672190912E+00, 9.6407542322E-01],
	[3.8475000000E+04, 3.2306331661E+01, 5.2255483492E+00, 1.5138127416E+01, 3.4676525130E+00, 9.6409219018E-01],
	[3.8480000000E+04, 3.2313600717E+01, 5.2255765157E+00, 1.5144555013E+01, 3.4680858246E+00, 9.6410894859E-01],
	[3.8485000000E+04, 3.2320870465E+01, 5.2256046787E+00, 1.5150984503E+01, 3.4685190262E+00, 9.6412569847E-01],
	[3.8490000000E+04, 3.2328140903E+01, 5.2256328382E+00, 1.5157415887E+01, 3.4689521177E+00, 9.6414243981E-01],
	[3.8495000000E+04, 3.2335412032E+01, 5.2256609942E+00, 1.5163849164E+01, 3.4693850992E+00, 9.6415917261E-01],
	[3.8500000000E+04, 3.2342683851E+01, 5.2256891467E+00, 1.5170284334E+01, 3.4698179707E+00, 9.6417589689E-01],
	[3.8505000000E+04, 3.2349956361E+01, 5.2257172957E+00, 1.5176721399E+01, 3.4702507321E+00, 9.6419261265E-01],
	[3.8510000000E+04, 3.2357229562E+01, 5.2257454411E+00, 1.5183160358E+01, 3.4706833836E+00, 9.6420931989E-01],
	[3.8515000000E+04, 3.2364503454E+01, 5.2257735831E+00, 1.5189601212E+01, 3.4711159251E+00, 9.6422601861E-01],
	[3.8520000000E+04, 3.2371778036E+01, 5.2258017216E+00, 1.5196043961E+01, 3.4715483566E+00, 9.6424270883E-01],
	[3.8525000000E+04, 3.2379053309E+01, 5.2258298566E+00, 1.5202488605E+01, 3.4719806783E+00, 9.6425939054E-01],
	[3.8530000000E+04, 3.2386329272E+01, 5.2258579881E+00, 1.5208935145E+01, 3.4724128900E+00, 9.6427606375E-01],
	[3.8535000000E+04, 3.2393605926E+01, 5.2258861160E+00, 1.5215383581E+01, 3.4728449919E+00, 9.6429272846E-01],
	[3.8540000000E+04, 3.2400883271E+01, 5.2259142405E+00, 1.5221833913E+01, 3.4732769839E+00, 9.6430938468E-01],
	[3.8545000000E+04, 3.2408161306E+01, 5.2259423615E+00, 1.5228286142E+01, 3.4737088660E+00, 9.6432603241E-01],
	[3.8550000000E+04, 3.2415440031E+01, 5.2259704790E+00, 1.5234740267E+01, 3.4741406383E+00, 9.6434267165E-01],
	[3.8555000000E+04, 3.2422719447E+01, 5.2259985930E+00, 1.5241196290E+01, 3.4745723009E+00, 9.6435930242E-01],
	[3.8560000000E+04, 3.2429999553E+01, 5.2260267035E+00, 1.5247654211E+01, 3.4750038536E+00, 9.6437592471E-01],
	[3.8565000000E+04, 3.2437280350E+01, 5.2260548105E+00, 1.5254114029E+01, 3.4754352966E+00, 9.6439253853E-01],
	[3.8570000000E+04, 3.2444561837E+01, 5.2260829140E+00, 1.5260575745E+01, 3.4758666298E+00, 9.6440914388E-01],
	[3.8575000000E+04, 3.2451844014E+01, 5.2261110140E+00, 1.5267039360E+01, 3.4762978533E+00, 9.6442574077E-01],
	[3.8580000000E+04, 3.2459126882E+01, 5.2261391106E+00, 1.5273504874E+01, 3.4767289671E+00, 9.6444232921E-01],
	[3.8585000000E+04, 3.2466410440E+01, 5.2261672036E+00, 1.5279972287E+01, 3.4771599712E+00, 9.6445890918E-01],
	[3.8590000000E+04, 3.2473694688E+01, 5.2261952932E+00, 1.5286441599E+01, 3.4775908657E+00, 9.6447548071E-01],
	[3.8595000000E+04, 3.2480979627E+01, 5.2262233792E+00, 1.5292912810E+01, 3.4780216505E+00, 9.6449204379E-01],
	[3.8600000000E+04, 3.2488265256E+01, 5.2262514618E+00, 1.5299385922E+01, 3.4784523257E+00, 9.6450859844E-01],
	[3.8605000000E+04, 3.2495551575E+01, 5.2262795409E+00, 1.5305860934E+01, 3.4788828913E+00, 9.6452514464E-01],
	[3.8610000000E+04, 3.2502838584E+01, 5.2263076165E+00, 1.5312337847E+01, 3.4793133473E+00, 9.6454168241E-01],
	[3.8615000000E+04, 3.2510126283E+01, 5.2263356886E+00, 1.5318816661E+01, 3.4797436937E+00, 9.6455821176E-01],
	[3.8620000000E+04, 3.2517432416E+01, 5.2263660338E+00, 1.5325297376E+01, 3.4801751433E+00, 9.6457473268E-01],
	[3.8625000000E+04, 3.2524739538E+01, 5.2263964129E+00, 1.5331779993E+01, 3.4806065037E+00, 9.6459124518E-01],
	[3.8630000000E+04, 3.2532047356E+01, 5.2264267882E+00, 1.5338264511E+01, 3.4810377550E+00, 9.6460774926E-01],
	[3.8635000000E+04, 3.2539355869E+01, 5.2264571597E+00, 1.5344750932E+01, 3.4814688971E+00, 9.6462424493E-01],
	[3.8640000000E+04, 3.2546665078E+01, 5.2264875275E+00, 1.5351239255E+01, 3.4818999301E+00, 9.6464073220E-01],
	[3.8645000000E+04, 3.2553974983E+01, 5.2265178916E+00, 1.5357729481E+01, 3.4823308540E+00, 9.6465721107E-01],
	[3.8650000000E+04, 3.2561285584E+01, 5.2265482518E+00, 1.5364221610E+01, 3.4827616688E+00, 9.6467368153E-01],
	[3.8655000000E+04, 3.2568596881E+01, 5.2265786084E+00, 1.5370715643E+01, 3.4831923746E+00, 9.6469014360E-01],
	[3.8660000000E+04, 3.2575908873E+01, 5.2266089612E+00, 1.5377211579E+01, 3.4836229714E+00, 9.6470659729E-01],
	[3.8665000000E+04, 3.2583221561E+01, 5.2266393102E+00, 1.5383709419E+01, 3.4840534591E+00, 9.6472304258E-01],
	[3.8670000000E+04, 3.2590534944E+01, 5.2266696555E+00, 1.5390209164E+01, 3.4844838378E+00, 9.6473947950E-01],
	[3.8675000000E+04, 3.2597849024E+01, 5.2266999970E+00, 1.5396710814E+01, 3.4849141075E+00, 9.6475590804E-01],
	[3.8680000000E+04, 3.2605163798E+01, 5.2267303348E+00, 1.5403214368E+01, 3.4853442683E+00, 9.6477232820E-01],
	[3.8685000000E+04, 3.2612479269E+01, 5.2267606689E+00, 1.5409719828E+01, 3.4857743201E+00, 9.6478874000E-01],
	[3.8690000000E+04, 3.2619795435E+01, 5.2267909992E+00, 1.5416227193E+01, 3.4862042630E+00, 9.6480514344E-01],
	[3.8695000000E+04, 3.2627112296E+01, 5.2268213257E+00, 1.5422736465E+01, 3.4866340971E+00, 9.6482153851E-01],
	[3.8700000000E+04, 3.2634429853E+01, 5.2268516486E+00, 1.5429247642E+01, 3.4870638222E+00, 9.6483792523E-01],
	[3.8705000000E+04, 3.2641748106E+01, 5.2268819676E+00, 1.5435760726E+01, 3.4874934385E+00, 9.6485430360E-01],
	[3.8710000000E+04, 3.2649067054E+01, 5.2269122830E+00, 1.5442275717E+01, 3.4879229459E+00, 9.6487067362E-01],
	[3.8715000000E+04, 3.2656386697E+01, 5.2269425946E+00, 1.5448792615E+01, 3.4883523445E+00, 9.6488703530E-01],
	[3.8720000000E+04, 3.2663707036E+01, 5.2269729024E+00, 1.5455311421E+01, 3.4887816343E+00, 9.6490338864E-01],
	[3.8725000000E+04, 3.2671028070E+01, 5.2270032066E+00, 1.5461832135E+01, 3.4892108154E+00, 9.6491973365E-01],
	[3.8730000000E+04, 3.2678349800E+01, 5.2270335069E+00, 1.5468354756E+01, 3.4896398876E+00, 9.6493607032E-01],
	[3.8735000000E+04, 3.2685672225E+01, 5.2270638036E+00, 1.5474879286E+01, 3.4900688512E+00, 9.6495239867E-01],
	[3.8740000000E+04, 3.2692995345E+01, 5.2270940965E+00, 1.5481405725E+01, 3.4904977060E+00, 9.6496871870E-01],
	[3.8745000000E+04, 3.2700319161E+01, 5.2271243857E+00, 1.5487934073E+01, 3.4909264521E+00, 9.6498503042E-01],
	[3.8750000000E+04, 3.2707643672E+01, 5.2271546711E+00, 1.5494464330E+01, 3.4913550895E+00, 9.6500133382E-01],
	[3.8755000000E+04, 3.2714968878E+01, 5.2271849528E+00, 1.5500996497E+01, 3.4917836183E+00, 9.6501762891E-01],
	[3.8760000000E+04, 3.2722294779E+01, 5.2272152308E+00, 1.5507530574E+01, 3.4922120384E+00, 9.6503391570E-01],
	[3.8765000000E+04, 3.2729621376E+01, 5.2272455051E+00, 1.5514066561E+01, 3.4926403500E+00, 9.6505019419E-01],
	[3.8770000000E+04, 3.2736948667E+01, 5.2272757756E+00, 1.5520604459E+01, 3.4930685529E+00, 9.6506646438E-01],
	[3.8775000000E+04, 3.2744276654E+01, 5.2273060424E+00, 1.5527144267E+01, 3.4934966472E+00, 9.6508272628E-01],
	[3.8780000000E+04, 3.2751605336E+01, 5.2273363055E+00, 1.5533685987E+01, 3.4939246330E+00, 9.6509897990E-01],
	[3.8785000000E+04, 3.2758934713E+01, 5.2273665648E+00, 1.5540229619E+01, 3.4943525102E+00, 9.6511522523E-01],
	[3.8790000000E+04, 3.2766264786E+01, 5.2273968204E+00, 1.5546775162E+01, 3.4947802789E+00, 9.6513146229E-01],
	[3.8795000000E+04, 3.2773595553E+01, 5.2274270723E+00, 1.5553322617E+01, 3.4952079391E+00, 9.6514769107E-01],
	[3.8800000000E+04, 3.2780927015E+01, 5.2274573205E+00, 1.5559871985E+01, 3.4956354908E+00, 9.6516391158E-01],
	[3.8805000000E+04, 3.2788259173E+01, 5.2274875649E+00, 1.5566423266E+01, 3.4960629341E+00, 9.6518012382E-01],
	[3.8810000000E+04, 3.2795592025E+01, 5.2275178056E+00, 1.5572976460E+01, 3.4964902690E+00, 9.6519632781E-01],
	[3.8815000000E+04, 3.2802925572E+01, 5.2275480426E+00, 1.5579531567E+01, 3.4969174954E+00, 9.6521252353E-01],
	[3.8820000000E+04, 3.2810259815E+01, 5.2275782759E+00, 1.5586088588E+01, 3.4973446134E+00, 9.6522871101E-01],
	[3.8825000000E+04, 3.2817594752E+01, 5.2276085055E+00, 1.5592647523E+01, 3.4977716230E+00, 9.6524489023E-01],
	[3.8830000000E+04, 3.2824930384E+01, 5.2276387313E+00, 1.5599208373E+01, 3.4981985243E+00, 9.6526106122E-01],
	[3.8835000000E+04, 3.2832266711E+01, 5.2276689535E+00, 1.5605771137E+01, 3.4986253172E+00, 9.6527722396E-01],
	[3.8840000000E+04, 3.2839603733E+01, 5.2276991719E+00, 1.5612335816E+01, 3.4990520018E+00, 9.6529337846E-01],
	[3.8845000000E+04, 3.2846941450E+01, 5.2277293866E+00, 1.5618902410E+01, 3.4994785782E+00, 9.6530952474E-01],
	[3.8850000000E+04, 3.2854279861E+01, 5.2277595975E+00, 1.5625470920E+01, 3.4999050462E+00, 9.6532566279E-01],
	[3.8855000000E+04, 3.2861618967E+01, 5.2277898048E+00, 1.5632041346E+01, 3.5003314060E+00, 9.6534179261E-01],
	[3.8860000000E+04, 3.2868958768E+01, 5.2278200084E+00, 1.5638613688E+01, 3.5007576575E+00, 9.6535791422E-01],
	[3.8865000000E+04, 3.2876299264E+01, 5.2278502082E+00, 1.5645187946E+01, 3.5011838008E+00, 9.6537402761E-01],
	[3.8870000000E+04, 3.2883640454E+01, 5.2278804044E+00, 1.5651764122E+01, 3.5016098360E+00, 9.6539013279E-01],
	[3.8875000000E+04, 3.2890982340E+01, 5.2279105968E+00, 1.5658342215E+01, 3.5020357629E+00, 9.6540622977E-01],
	[3.8880000000E+04, 3.2898324919E+01, 5.2279407855E+00, 1.5664922225E+01, 3.5024615817E+00, 9.6542231855E-01],
	[3.8885000000E+04, 3.2905668194E+01, 5.2279709705E+00, 1.5671504152E+01, 3.5028872924E+00, 9.6543839912E-01],
	[3.8890000000E+04, 3.2913012163E+01, 5.2280011518E+00, 1.5678087998E+01, 3.5033128949E+00, 9.6545447151E-01],
	[3.8895000000E+04, 3.2920356826E+01, 5.2280313294E+00, 1.5684673763E+01, 3.5037383893E+00, 9.6547053571E-01],
	[3.8900000000E+04, 3.2927702185E+01, 5.2280615033E+00, 1.5691261446E+01, 3.5041637757E+00, 9.6548659172E-01],
	[3.8905000000E+04, 3.2935048237E+01, 5.2280916735E+00, 1.5697851048E+01, 3.5045890540E+00, 9.6550263955E-01],
	[3.8910000000E+04, 3.2942394985E+01, 5.2281218400E+00, 1.5704442569E+01, 3.5050142243E+00, 9.6551867921E-01],
	[3.8915000000E+04, 3.2949742427E+01, 5.2281520027E+00, 1.5711036010E+01, 3.5054392866E+00, 9.6553471069E-01],
	[3.8920000000E+04, 3.2957090563E+01, 5.2281821618E+00, 1.5717631371E+01, 3.5058642408E+00, 9.6555073401E-01],
	[3.8925000000E+04, 3.2964439393E+01, 5.2282123172E+00, 1.5724228653E+01, 3.5062890871E+00, 9.6556674916E-01],
	[3.8930000000E+04, 3.2971788919E+01, 5.2282424689E+00, 1.5730827855E+01, 3.5067138254E+00, 9.6558275616E-01],
	[3.8935000000E+04, 3.2979139138E+01, 5.2282726169E+00, 1.5737428977E+01, 3.5071384558E+00, 9.6559875500E-01],
	[3.8940000000E+04, 3.2986490052E+01, 5.2283027611E+00, 1.5744032021E+01, 3.5075629783E+00, 9.6561474569E-01],
	[3.8945000000E+04, 3.2993841660E+01, 5.2283329017E+00, 1.5750636987E+01, 3.5079873929E+00, 9.6563072824E-01],
	[3.8950000000E+04, 3.3001193963E+01, 5.2283630386E+00, 1.5757243874E+01, 3.5084116997E+00, 9.6564670264E-01],
	[3.8955000000E+04, 3.3008546960E+01, 5.2283931718E+00, 1.5763852684E+01, 3.5088358985E+00, 9.6566266890E-01],
	[3.8960000000E+04, 3.3015900651E+01, 5.2284233013E+00, 1.5770463416E+01, 3.5092599896E+00, 9.6567862704E-01],
	[3.8965000000E+04, 3.3023255037E+01, 5.2284534271E+00, 1.5777076071E+01, 3.5096839728E+00, 9.6569457704E-01],
	[3.8970000000E+04, 3.3030610116E+01, 5.2284835493E+00, 1.5783690649E+01, 3.5101078482E+00, 9.6571051892E-01],
	[3.8975000000E+04, 3.3037965890E+01, 5.2285136677E+00, 1.5790307150E+01, 3.5105316159E+00, 9.6572645268E-01],
	[3.8980000000E+04, 3.3045322358E+01, 5.2285437824E+00, 1.5796925575E+01, 3.5109552758E+00, 9.6574237832E-01],
	[3.8985000000E+04, 3.3052679521E+01, 5.2285738935E+00, 1.5803545924E+01, 3.5113788280E+00, 9.6575829585E-01],
	[3.8990000000E+04, 3.3060037377E+01, 5.2286040008E+00, 1.5810168197E+01, 3.5118022724E+00, 9.6577420527E-01],
	[3.8995000000E+04, 3.3067395927E+01, 5.2286341045E+00, 1.5816792395E+01, 3.5122256092E+00, 9.6579010659E-01],
	[3.9000000000E+04, 3.3074755172E+01, 5.2286642045E+00, 1.5823418518E+01, 3.5126488383E+00, 9.6580599981E-01],
	[3.9005000000E+04, 3.3082115111E+01, 5.2286943008E+00, 1.5830046566E+01, 3.5130719598E+00, 9.6582188494E-01],
	[3.9010000000E+04, 3.3089475744E+01, 5.2287243934E+00, 1.5836676540E+01, 3.5134949736E+00, 9.6583776197E-01],
	[3.9015000000E+04, 3.3096837070E+01, 5.2287544823E+00, 1.5843308440E+01, 3.5139178798E+00, 9.6585363092E-01],
	[3.9020000000E+04, 3.3104199091E+01, 5.2287845676E+00, 1.5849942266E+01, 3.5143406785E+00, 9.6586949179E-01],
	[3.9025000000E+04, 3.3111561806E+01, 5.2288146492E+00, 1.5856578018E+01, 3.5147633695E+00, 9.6588534457E-01],
	[3.9030000000E+04, 3.3118925215E+01, 5.2288447270E+00, 1.5863215698E+01, 3.5151859531E+00, 9.6590118929E-01],
	[3.9035000000E+04, 3.3126289317E+01, 5.2288748013E+00, 1.5869855304E+01, 3.5156084291E+00, 9.6591702593E-01],
	[3.9040000000E+04, 3.3133654114E+01, 5.2289048718E+00, 1.5876496838E+01, 3.5160307976E+00, 9.6593285451E-01],
	[3.9045000000E+04, 3.3141019604E+01, 5.2289349386E+00, 1.5883140300E+01, 3.5164530586E+00, 9.6594867503E-01],
	[3.9050000000E+04, 3.3148385789E+01, 5.2289650018E+00, 1.5889785689E+01, 3.5168752121E+00, 9.6596448749E-01],
	[3.9055000000E+04, 3.3155752667E+01, 5.2289950613E+00, 1.5896433007E+01, 3.5172972582E+00, 9.6598029190E-01],
	[3.9060000000E+04, 3.3163120239E+01, 5.2290251171E+00, 1.5903082254E+01, 3.5177191969E+00, 9.6599608826E-01],
	[3.9065000000E+04, 3.3170488505E+01, 5.2290551693E+00, 1.5909733430E+01, 3.5181410282E+00, 9.6601187658E-01],
	[3.9070000000E+04, 3.3177857464E+01, 5.2290852177E+00, 1.5916386535E+01, 3.5185627520E+00, 9.6602765686E-01],
	[3.9075000000E+04, 3.3185227117E+01, 5.2291152625E+00, 1.5923041570E+01, 3.5189843686E+00, 9.6604342910E-01],
	[3.9080000000E+04, 3.3192597464E+01, 5.2291453037E+00, 1.5929698535E+01, 3.5194058778E+00, 9.6605919331E-01],
	[3.9085000000E+04, 3.3199968505E+01, 5.2291753411E+00, 1.5936357430E+01, 3.5198272796E+00, 9.6607494950E-01],
	[3.9090000000E+04, 3.3207340239E+01, 5.2292053749E+00, 1.5943018256E+01, 3.5202485742E+00, 9.6609069766E-01],
	[3.9095000000E+04, 3.3214712667E+01, 5.2292354050E+00, 1.5949681012E+01, 3.5206697615E+00, 9.6610643780E-01],
	[3.9100000000E+04, 3.3222085789E+01, 5.2292654315E+00, 1.5956345700E+01, 3.5210908415E+00, 9.6612216993E-01],
	[3.9105000000E+04, 3.3229459604E+01, 5.2292954543E+00, 1.5963012319E+01, 3.5215118143E+00, 9.6613789405E-01],
	[3.9110000000E+04, 3.3236834113E+01, 5.2293254734E+00, 1.5969680870E+01, 3.5219326799E+00, 9.6615361016E-01],
	[3.9115000000E+04, 3.3244209316E+01, 5.2293554889E+00, 1.5976351353E+01, 3.5223534382E+00, 9.6616931827E-01],
	[3.9120000000E+04, 3.3251585211E+01, 5.2293855006E+00, 1.5983023769E+01, 3.5227740894E+00, 9.6618501839E-01],
	[3.9125000000E+04, 3.3258961801E+01, 5.2294155088E+00, 1.5989698118E+01, 3.5231946335E+00, 9.6620071051E-01],
	[3.9130000000E+04, 3.3266339084E+01, 5.2294455132E+00, 1.5996374399E+01, 3.5236150704E+00, 9.6621639464E-01],
	[3.9135000000E+04, 3.3273717060E+01, 5.2294755140E+00, 1.6003052614E+01, 3.5240354002E+00, 9.6623207079E-01],
	[3.9140000000E+04, 3.3281095730E+01, 5.2295055112E+00, 1.6009732763E+01, 3.5244556228E+00, 9.6624773896E-01],
	[3.9145000000E+04, 3.3288475093E+01, 5.2295355047E+00, 1.6016414845E+01, 3.5248757385E+00, 9.6626339915E-01],
	[3.9150000000E+04, 3.3295855150E+01, 5.2295654945E+00, 1.6023098862E+01, 3.5252957470E+00, 9.6627905137E-01],
	[3.9155000000E+04, 3.3303235900E+01, 5.2295954806E+00, 1.6029784814E+01, 3.5257156486E+00, 9.6629469562E-01],
	[3.9160000000E+04, 3.3310617343E+01, 5.2296254631E+00, 1.6036472701E+01, 3.5261354431E+00, 9.6631033190E-01],
	[3.9165000000E+04, 3.3317999480E+01, 5.2296554420E+00, 1.6043162523E+01, 3.5265551306E+00, 9.6632596023E-01],
	[3.9170000000E+04, 3.3325382310E+01, 5.2296854172E+00, 1.6049854280E+01, 3.5269747112E+00, 9.6634158061E-01],
	[3.9175000000E+04, 3.3332765833E+01, 5.2297153887E+00, 1.6056547973E+01, 3.5273941848E+00, 9.6635719303E-01],
	[3.9180000000E+04, 3.3340150050E+01, 5.2297453566E+00, 1.6063243603E+01, 3.5278135515E+00, 9.6637279751E-01],
	[3.9185000000E+04, 3.3347534959E+01, 5.2297753209E+00, 1.6069941169E+01, 3.5282328113E+00, 9.6638839404E-01],
	[3.9190000000E+04, 3.3354920562E+01, 5.2298052814E+00, 1.6076640672E+01, 3.5286519641E+00, 9.6640398264E-01],
	[3.9195000000E+04, 3.3362306858E+01, 5.2298352384E+00, 1.6083342112E+01, 3.5290710102E+00, 9.6641956330E-01],
	[3.9200000000E+04, 3.3369693848E+01, 5.2298651917E+00, 1.6090045489E+01, 3.5294899493E+00, 9.6643513603E-01],
	[3.9205000000E+04, 3.3377081530E+01, 5.2298951413E+00, 1.6096750805E+01, 3.5299087817E+00, 9.6645070084E-01],
	[3.9210000000E+04, 3.3384469906E+01, 5.2299250873E+00, 1.6103458058E+01, 3.5303275072E+00, 9.6646625772E-01],
	[3.9215000000E+04, 3.3391858974E+01, 5.2299550296E+00, 1.6110167250E+01, 3.5307461260E+00, 9.6648180669E-01],
	[3.9220000000E+04, 3.3399248736E+01, 5.2299849683E+00, 1.6116878380E+01, 3.5311646380E+00, 9.6649734775E-01],
	[3.9225000000E+04, 3.3406639191E+01, 5.2300149034E+00, 1.6123591450E+01, 3.5315830432E+00, 9.6651288090E-01],
	[3.9230000000E+04, 3.3414030338E+01, 5.2300448348E+00, 1.6130306458E+01, 3.5320013418E+00, 9.6652840614E-01],
	[3.9235000000E+04, 3.3421422179E+01, 5.2300747625E+00, 1.6137023407E+01, 3.5324195336E+00, 9.6654392348E-01],
	[3.9240000000E+04, 3.3428826337E+01, 5.2301061672E+00, 1.6143742295E+01, 3.5328384241E+00, 9.6655943293E-01],
	[3.9245000000E+04, 3.3436237350E+01, 5.2301383522E+00, 1.6150463124E+01, 3.5332576348E+00, 9.6657493449E-01],
	[3.9250000000E+04, 3.3443649062E+01, 5.2301705333E+00, 1.6157185893E+01, 3.5336767393E+00, 9.6659042815E-01],
	[3.9255000000E+04, 3.3451061472E+01, 5.2302027106E+00, 1.6163910603E+01, 3.5340957374E+00, 9.6660591394E-01],
	[3.9260000000E+04, 3.3458474581E+01, 5.2302348839E+00, 1.6170637255E+01, 3.5345146292E+00, 9.6662139185E-01],
	[3.9265000000E+04, 3.3465888388E+01, 5.2302670533E+00, 1.6177365848E+01, 3.5349334148E+00, 9.6663686188E-01],
	[3.9270000000E+04, 3.3473302893E+01, 5.2302992189E+00, 1.6184096382E+01, 3.5353520942E+00, 9.6665232404E-01],
	[3.9275000000E+04, 3.3480718097E+01, 5.2303313805E+00, 1.6190828859E+01, 3.5357706674E+00, 9.6666777833E-01],
	[3.9280000000E+04, 3.3488134000E+01, 5.2303635383E+00, 1.6197563279E+01, 3.5361891343E+00, 9.6668322476E-01],
	[3.9285000000E+04, 3.3495550600E+01, 5.2303956921E+00, 1.6204299641E+01, 3.5366074952E+00, 9.6669866334E-01],
	[3.9290000000E+04, 3.3502967900E+01, 5.2304278421E+00, 1.6211037946E+01, 3.5370257498E+00, 9.6671409406E-01],
	[3.9295000000E+04, 3.3510385897E+01, 5.2304599881E+00, 1.6217778194E+01, 3.5374438984E+00, 9.6672951693E-01],
	[3.9300000000E+04, 3.3517804593E+01, 5.2304921303E+00, 1.6224520387E+01, 3.5378619408E+00, 9.6674493195E-01],
	[3.9305000000E+04, 3.3525223987E+01, 5.2305242686E+00, 1.6231264523E+01, 3.5382798771E+00, 9.6676033914E-01],
	[3.9310000000E+04, 3.3532644079E+01, 5.2305564029E+00, 1.6238010604E+01, 3.5386977074E+00, 9.6677573848E-01],
	[3.9315000000E+04, 3.3540064870E+01, 5.2305885334E+00, 1.6244758629E+01, 3.5391154316E+00, 9.6679113000E-01],
	[3.9320000000E+04, 3.3547486358E+01, 5.2306206600E+00, 1.6251508599E+01, 3.5395330499E+00, 9.6680651368E-01],
	[3.9325000000E+04, 3.3554908545E+01, 5.2306527828E+00, 1.6258260515E+01, 3.5399505621E+00, 9.6682188955E-01],
	[3.9330000000E+04, 3.3562331430E+01, 5.2306849016E+00, 1.6265014376E+01, 3.5403679683E+00, 9.6683725759E-01],
	[3.9335000000E+04, 3.3569755013E+01, 5.2307170165E+00, 1.6271770183E+01, 3.5407852686E+00, 9.6685261781E-01],
	[3.9340000000E+04, 3.3577179295E+01, 5.2307491276E+00, 1.6278527936E+01, 3.5412024629E+00, 9.6686797023E-01],
	[3.9345000000E+04, 3.3584604274E+01, 5.2307812348E+00, 1.6285287636E+01, 3.5416195513E+00, 9.6688331483E-01],
	[3.9350000000E+04, 3.3592029952E+01, 5.2308133381E+00, 1.6292049283E+01, 3.5420365338E+00, 9.6689865163E-01],
	[3.9355000000E+04, 3.3599456327E+01, 5.2308454375E+00, 1.6298812877E+01, 3.5424534105E+00, 9.6691398064E-01],
	[3.9360000000E+04, 3.3606883401E+01, 5.2308775330E+00, 1.6305578418E+01, 3.5428701812E+00, 9.6692930185E-01],
	[3.9365000000E+04, 3.3614311172E+01, 5.2309096247E+00, 1.6312345907E+01, 3.5432868462E+00, 9.6694461526E-01],
	[3.9370000000E+04, 3.3621739642E+01, 5.2309417124E+00, 1.6319115344E+01, 3.5437034053E+00, 9.6695992089E-01],
	[3.9375000000E+04, 3.3629168809E+01, 5.2309737963E+00, 1.6325886729E+01, 3.5441198587E+00, 9.6697521874E-01],
	[3.9380000000E+04, 3.3636598675E+01, 5.2310058763E+00, 1.6332660064E+01, 3.5445362062E+00, 9.6699050881E-01],
	[3.9385000000E+04, 3.3644029238E+01, 5.2310379525E+00, 1.6339435347E+01, 3.5449524480E+00, 9.6700579111E-01],
	[3.9390000000E+04, 3.3651460499E+01, 5.2310700247E+00, 1.6346212580E+01, 3.5453685841E+00, 9.6702106564E-01],
	[3.9395000000E+04, 3.3658892458E+01, 5.2311020931E+00, 1.6352991762E+01, 3.5457846145E+00, 9.6703633240E-01],
	[3.9400000000E+04, 3.3666325115E+01, 5.2311341577E+00, 1.6359772894E+01, 3.5462005391E+00, 9.6705159140E-01],
	[3.9405000000E+04, 3.3673758470E+01, 5.2311662183E+00, 1.6366555977E+01, 3.5466163581E+00, 9.6706684264E-01],
	[3.9410000000E+04, 3.3681192523E+01, 5.2311982751E+00, 1.6373341010E+01, 3.5470320715E+00, 9.6708208613E-01],
	[3.9415000000E+04, 3.3688627273E+01, 5.2312303280E+00, 1.6380127994E+01, 3.5474476792E+00, 9.6709732187E-01],
	[3.9420000000E+04, 3.3696062721E+01, 5.2312623770E+00, 1.6386916929E+01, 3.5478631813E+00, 9.6711254986E-01],
	[3.9425000000E+04, 3.3703498867E+01, 5.2312944222E+00, 1.6393707816E+01, 3.5482785779E+00, 9.6712777012E-01],
	[3.9430000000E+04, 3.3710935710E+01, 5.2313264635E+00, 1.6400500654E+01, 3.5486938688E+00, 9.6714298264E-01],
	[3.9435000000E+04, 3.3718373252E+01, 5.2313585009E+00, 1.6407295445E+01, 3.5491090542E+00, 9.6715818742E-01],
	[3.9440000000E+04, 3.3725811490E+01, 5.2313905345E+00, 1.6414092189E+01, 3.5495241341E+00, 9.6717338448E-01],
	[3.9445000000E+04, 3.3733250427E+01, 5.2314225642E+00, 1.6420890885E+01, 3.5499391085E+00, 9.6718857382E-01],
	[3.9450000000E+04, 3.3740690061E+01, 5.2314545900E+00, 1.6427691534E+01, 3.5503539775E+00, 9.6720375543E-01],
	[3.9455000000E+04, 3.3748130393E+01, 5.2314866120E+00, 1.6434494136E+01, 3.5507687409E+00, 9.6721892933E-01],
	[3.9460000000E+04, 3.3755571422E+01, 5.2315186301E+00, 1.6441298693E+01, 3.5511833989E+00, 9.6723409552E-01],
	[3.9465000000E+04, 3.3763013149E+01, 5.2315506443E+00, 1.6448105203E+01, 3.5515979515E+00, 9.6724925400E-01],
	[3.9470000000E+04, 3.3770455573E+01, 5.2315826547E+00, 1.6454913668E+01, 3.5520123987E+00, 9.6726440478E-01],
	[3.9475000000E+04, 3.3777898695E+01, 5.2316146613E+00, 1.6461724087E+01, 3.5524267405E+00, 9.6727954786E-01],
	[3.9480000000E+04, 3.3785342514E+01, 5.2316466639E+00, 1.6468536462E+01, 3.5528409770E+00, 9.6729468324E-01],
	[3.9485000000E+04, 3.3792787031E+01, 5.2316786628E+00, 1.6475350791E+01, 3.5532551081E+00, 9.6730981094E-01],
	[3.9490000000E+04, 3.3800232245E+01, 5.2317106577E+00, 1.6482167076E+01, 3.5536691339E+00, 9.6732493094E-01],
	[3.9495000000E+04, 3.3807678156E+01, 5.2317426488E+00, 1.6488985318E+01, 3.5540830544E+00, 9.6734004327E-01],
	[3.9500000000E+04, 3.3815124765E+01, 5.2317746361E+00, 1.6495805515E+01, 3.5544968697E+00, 9.6735514792E-01],
	[3.9505000000E+04, 3.3822572072E+01, 5.2318066195E+00, 1.6502627669E+01, 3.5549105797E+00, 9.6737024489E-01],
	[3.9510000000E+04, 3.3830020075E+01, 5.2318385990E+00, 1.6509451780E+01, 3.5553241844E+00, 9.6738533420E-01],
	[3.9515000000E+04, 3.3837468776E+01, 5.2318705747E+00, 1.6516277848E+01, 3.5557376840E+00, 9.6740041584E-01],
	[3.9520000000E+04, 3.3844918174E+01, 5.2319025466E+00, 1.6523105873E+01, 3.5561510783E+00, 9.6741548981E-01],
	[3.9525000000E+04, 3.3852368270E+01, 5.2319345146E+00, 1.6529935857E+01, 3.5565643675E+00, 9.6743055613E-01],
	[3.9530000000E+04, 3.3859819063E+01, 5.2319664787E+00, 1.6536767798E+01, 3.5569775516E+00, 9.6744561480E-01],
	[3.9535000000E+04, 3.3867270553E+01, 5.2319984390E+00, 1.6543601698E+01, 3.5573906305E+00, 9.6746066582E-01],
	[3.9540000000E+04, 3.3874722740E+01, 5.2320303955E+00, 1.6550437556E+01, 3.5578036043E+00, 9.6747570920E-01],
	[3.9545000000E+04, 3.3882175624E+01, 5.2320623481E+00, 1.6557275374E+01, 3.5582164730E+00, 9.6749074493E-01],
	[3.9550000000E+04, 3.3889629206E+01, 5.2320942968E+00, 1.6564115151E+01, 3.5586292367E+00, 9.6750577303E-01],
	[3.9555000000E+04, 3.3897083484E+01, 5.2321262418E+00, 1.6570956888E+01, 3.5590418953E+00, 9.6752079349E-01],
	[3.9560000000E+04, 3.3904538460E+01, 5.2321581828E+00, 1.6577800584E+01, 3.5594544489E+00, 9.6753580633E-01],
	[3.9565000000E+04, 3.3911994133E+01, 5.2321901201E+00, 1.6584646241E+01, 3.5598668975E+00, 9.6755081154E-01],
	[3.9570000000E+04, 3.3919450503E+01, 5.2322220535E+00, 1.6591493859E+01, 3.5602792411E+00, 9.6756580914E-01],
	[3.9575000000E+04, 3.3926907570E+01, 5.2322539830E+00, 1.6598343437E+01, 3.5606914798E+00, 9.6758079911E-01],
	[3.9580000000E+04, 3.3934365333E+01, 5.2322859087E+00, 1.6605194977E+01, 3.5611036135E+00, 9.6759578148E-01],
	[3.9585000000E+04, 3.3941823794E+01, 5.2323178306E+00, 1.6612048478E+01, 3.5615156423E+00, 9.6761075624E-01],
	[3.9590000000E+04, 3.3949282952E+01, 5.2323497486E+00, 1.6618903942E+01, 3.5619275662E+00, 9.6762572339E-01],
	[3.9595000000E+04, 3.3956742807E+01, 5.2323816628E+00, 1.6625761367E+01, 3.5623393853E+00, 9.6764068295E-01],
	[3.9600000000E+04, 3.3964203359E+01, 5.2324135732E+00, 1.6632620755E+01, 3.5627510995E+00, 9.6765563491E-01],
	[3.9605000000E+04, 3.3971664607E+01, 5.2324454797E+00, 1.6639482106E+01, 3.5631627088E+00, 9.6767057929E-01],
	[3.9610000000E+04, 3.3979126553E+01, 5.2324773824E+00, 1.6646345419E+01, 3.5635742134E+00, 9.6768551607E-01],
	[3.9615000000E+04, 3.3986589195E+01, 5.2325092813E+00, 1.6653210697E+01, 3.5639856131E+00, 9.6770044527E-01],
	[3.9620000000E+04, 3.3994052534E+01, 5.2325411764E+00, 1.6660077938E+01, 3.5643969081E+00, 9.6771536690E-01],
	[3.9625000000E+04, 3.4001516570E+01, 5.2325730676E+00, 1.6666947143E+01, 3.5648080984E+00, 9.6773028095E-01],
	[3.9630000000E+04, 3.4008981303E+01, 5.2326049549E+00, 1.6673818312E+01, 3.5652191839E+00, 9.6774518743E-01],
	[3.9635000000E+04, 3.4016446733E+01, 5.2326368385E+00, 1.6680691446E+01, 3.5656301647E+00, 9.6776008634E-01],
	[3.9640000000E+04, 3.4023912859E+01, 5.2326687182E+00, 1.6687566546E+01, 3.5660410408E+00, 9.6777497769E-01],
	[3.9645000000E+04, 3.4031379682E+01, 5.2327005941E+00, 1.6694443610E+01, 3.5664518123E+00, 9.6778986149E-01],
	[3.9650000000E+04, 3.4038847202E+01, 5.2327324662E+00, 1.6701322640E+01, 3.5668624791E+00, 9.6780473773E-01],
	[3.9655000000E+04, 3.4046315418E+01, 5.2327643344E+00, 1.6708203636E+01, 3.5672730413E+00, 9.6781960642E-01],
	[3.9660000000E+04, 3.4053784331E+01, 5.2327961988E+00, 1.6715086599E+01, 3.5676834989E+00, 9.6783446757E-01],
	[3.9665000000E+04, 3.4061253941E+01, 5.2328280594E+00, 1.6721971528E+01, 3.5680938519E+00, 9.6784932117E-01],
	[3.9670000000E+04, 3.4068724247E+01, 5.2328599162E+00, 1.6728858423E+01, 3.5685041004E+00, 9.6786416724E-01],
	[3.9675000000E+04, 3.4076195250E+01, 5.2328917692E+00, 1.6735747286E+01, 3.5689142443E+00, 9.6787900578E-01],
	[3.9680000000E+04, 3.4083666949E+01, 5.2329236183E+00, 1.6742638117E+01, 3.5693242838E+00, 9.6789383678E-01],
	[3.9685000000E+04, 3.4091139345E+01, 5.2329554636E+00, 1.6749530915E+01, 3.5697342187E+00, 9.6790866027E-01],
	[3.9690000000E+04, 3.4098612438E+01, 5.2329873051E+00, 1.6756425682E+01, 3.5701440491E+00, 9.6792347623E-01],
	[3.9695000000E+04, 3.4106086227E+01, 5.2330191428E+00, 1.6763322417E+01, 3.5705537751E+00, 9.6793828467E-01],
	[3.9700000000E+04, 3.4113560712E+01, 5.2330509766E+00, 1.6770221121E+01, 3.5709633967E+00, 9.6795308561E-01],
	[3.9705000000E+04, 3.4121035894E+01, 5.2330828067E+00, 1.6777121793E+01, 3.5713729139E+00, 9.6796787903E-01],
	[3.9710000000E+04, 3.4128511772E+01, 5.2331146329E+00, 1.6784024436E+01, 3.5717823266E+00, 9.6798266495E-01],
	[3.9715000000E+04, 3.4135988347E+01, 5.2331464553E+00, 1.6790929048E+01, 3.5721916350E+00, 9.6799744338E-01],
	[3.9720000000E+04, 3.4143465618E+01, 5.2331782739E+00, 1.6797835630E+01, 3.5726008391E+00, 9.6801221430E-01],
	[3.9725000000E+04, 3.4150943585E+01, 5.2332100887E+00, 1.6804744182E+01, 3.5730099388E+00, 9.6802697773E-01],
	[3.9730000000E+04, 3.4158422249E+01, 5.2332418997E+00, 1.6811654705E+01, 3.5734189343E+00, 9.6804173368E-01],
	[3.9735000000E+04, 3.4165901609E+01, 5.2332737069E+00, 1.6818567199E+01, 3.5738278254E+00, 9.6805648214E-01],
	[3.9740000000E+04, 3.4173381665E+01, 5.2333055103E+00, 1.6825481664E+01, 3.5742366123E+00, 9.6807122313E-01],
	[3.9745000000E+04, 3.4180862418E+01, 5.2333373098E+00, 1.6832398101E+01, 3.5746452949E+00, 9.6808595664E-01],
	[3.9750000000E+04, 3.4188343866E+01, 5.2333691056E+00, 1.6839316510E+01, 3.5750538734E+00, 9.6810068267E-01],
	[3.9755000000E+04, 3.4195826011E+01, 5.2334008975E+00, 1.6846236890E+01, 3.5754623476E+00, 9.6811540125E-01],
	[3.9760000000E+04, 3.4203308852E+01, 5.2334326856E+00, 1.6853159244E+01, 3.5758707177E+00, 9.6813011235E-01],
	[3.9765000000E+04, 3.4210792390E+01, 5.2334644700E+00, 1.6860083570E+01, 3.5762789836E+00, 9.6814481600E-01],
	[3.9770000000E+04, 3.4218276623E+01, 5.2334962505E+00, 1.6867009870E+01, 3.5766871454E+00, 9.6815951220E-01],
	[3.9775000000E+04, 3.4225761553E+01, 5.2335280272E+00, 1.6873938143E+01, 3.5770952030E+00, 9.6817420094E-01],
	[3.9780000000E+04, 3.4233247179E+01, 5.2335598002E+00, 1.6880868389E+01, 3.5775031566E+00, 9.6818888224E-01],
	[3.9785000000E+04, 3.4240733500E+01, 5.2335915693E+00, 1.6887800610E+01, 3.5779110061E+00, 9.6820355609E-01],
	[3.9790000000E+04, 3.4248220518E+01, 5.2336233346E+00, 1.6894734806E+01, 3.5783187515E+00, 9.6821822251E-01],
	[3.9795000000E+04, 3.4255708232E+01, 5.2336550962E+00, 1.6901670976E+01, 3.5787263930E+00, 9.6823288149E-01],
	[3.9800000000E+04, 3.4263196642E+01, 5.2336868539E+00, 1.6908609121E+01, 3.5791339304E+00, 9.6824753304E-01],
	[3.9805000000E+04, 3.4270685748E+01, 5.2337186078E+00, 1.6915549241E+01, 3.5795413638E+00, 9.6826217717E-01],
	[3.9810000000E+04, 3.4278175550E+01, 5.2337503580E+00, 1.6922491337E+01, 3.5799486933E+00, 9.6827681387E-01],
	[3.9815000000E+04, 3.4285666048E+01, 5.2337821043E+00, 1.6929435409E+01, 3.5803559188E+00, 9.6829144316E-01],
	[3.9820000000E+04, 3.4293157241E+01, 5.2338138468E+00, 1.6936381458E+01, 3.5807630405E+00, 9.6830606503E-01],
	[3.9825000000E+04, 3.4300649131E+01, 5.2338455856E+00, 1.6943329483E+01, 3.5811700582E+00, 9.6832067950E-01],
	[3.9830000000E+04, 3.4308141716E+01, 5.2338773206E+00, 1.6950279485E+01, 3.5815769720E+00, 9.6833528658E-01],
	[3.9835000000E+04, 3.4315634998E+01, 5.2339090517E+00, 1.6957231464E+01, 3.5819837820E+00, 9.6834988628E-01],
	[3.9840000000E+04, 3.4323128975E+01, 5.2339407791E+00, 1.6964185421E+01, 3.5823904881E+00, 9.6836447860E-01],
	[3.9845000000E+04, 3.4330623648E+01, 5.2339725027E+00, 1.6971141355E+01, 3.5827970905E+00, 9.6837906356E-01],
	[3.9850000000E+04, 3.4338119017E+01, 5.2340042225E+00, 1.6978099268E+01, 3.5832035890E+00, 9.6839364114E-01],
	[3.9855000000E+04, 3.4345615081E+01, 5.2340359385E+00, 1.6985059159E+01, 3.5836099838E+00, 9.6840821136E-01],
	[3.9860000000E+04, 3.4353111841E+01, 5.2340676508E+00, 1.6992021030E+01, 3.5840162748E+00, 9.6842277422E-01],
	[3.9865000000E+04, 3.4360609297E+01, 5.2340993592E+00, 1.6998984879E+01, 3.5844224621E+00, 9.6843732973E-01],
	[3.9870000000E+04, 3.4368113096E+01, 5.2341317778E+00, 1.7005950708E+01, 3.5848289420E+00, 9.6845187788E-01],
	[3.9875000000E+04, 3.4375629479E+01, 5.2341656948E+00, 1.7012918516E+01, 3.5852361525E+00, 9.6846641868E-01],
	[3.9880000000E+04, 3.4383146563E+01, 5.2341996078E+00, 1.7019888305E+01, 3.5856432596E+00, 9.6848095213E-01],
	[3.9885000000E+04, 3.4390664348E+01, 5.2342335168E+00, 1.7026860073E+01, 3.5860502634E+00, 9.6849547824E-01],
	[3.9890000000E+04, 3.4398182834E+01, 5.2342674217E+00, 1.7033833823E+01, 3.5864571639E+00, 9.6850999701E-01],
	[3.9895000000E+04, 3.4405702022E+01, 5.2343013226E+00, 1.7040809554E+01, 3.5868639611E+00, 9.6852450844E-01],
	[3.9900000000E+04, 3.4413221910E+01, 5.2343352195E+00, 1.7047787266E+01, 3.5872706550E+00, 9.6853901254E-01],
	[3.9905000000E+04, 3.4420742499E+01, 5.2343691123E+00, 1.7054766959E+01, 3.5876772457E+00, 9.6855350931E-01],
	[3.9910000000E+04, 3.4428263789E+01, 5.2344030011E+00, 1.7061748635E+01, 3.5880837331E+00, 9.6856799876E-01],
	[3.9915000000E+04, 3.4435785780E+01, 5.2344368859E+00, 1.7068732293E+01, 3.5884901173E+00, 9.6858248088E-01],
	[3.9920000000E+04, 3.4443308472E+01, 5.2344707667E+00, 1.7075717933E+01, 3.5888963984E+00, 9.6859695568E-01],
	[3.9925000000E+04, 3.4450831865E+01, 5.2345046434E+00, 1.7082705556E+01, 3.5893025762E+00, 9.6861142317E-01],
	[3.9930000000E+04, 3.4458355959E+01, 5.2345385161E+00, 1.7089695163E+01, 3.5897086510E+00, 9.6862588335E-01],
	[3.9935000000E+04, 3.4465880754E+01, 5.2345723848E+00, 1.7096686753E+01, 3.5901146226E+00, 9.6864033622E-01],
	[3.9940000000E+04, 3.4473406249E+01, 5.2346062495E+00, 1.7103680327E+01, 3.5905204911E+00, 9.6865478178E-01],
	[3.9945000000E+04, 3.4480932446E+01, 5.2346401101E+00, 1.7110675885E+01, 3.5909262565E+00, 9.6866922005E-01],
	[3.9950000000E+04, 3.4488459343E+01, 5.2346739667E+00, 1.7117673427E+01, 3.5913319189E+00, 9.6868365101E-01],
	[3.9955000000E+04, 3.4495986941E+01, 5.2347078194E+00, 1.7124672955E+01, 3.5917374782E+00, 9.6869807468E-01],
	[3.9960000000E+04, 3.4503515239E+01, 5.2347416680E+00, 1.7131674467E+01, 3.5921429345E+00, 9.6871249106E-01],
	[3.9965000000E+04, 3.4511044239E+01, 5.2347755125E+00, 1.7138677965E+01, 3.5925482878E+00, 9.6872690015E-01],
	[3.9970000000E+04, 3.4518573939E+01, 5.2348093531E+00, 1.7145683448E+01, 3.5929535382E+00, 9.6874130196E-01],
	[3.9975000000E+04, 3.4526104339E+01, 5.2348431896E+00, 1.7152690918E+01, 3.5933586856E+00, 9.6875569649E-01],
	[3.9980000000E+04, 3.4533635441E+01, 5.2348770222E+00, 1.7159700374E+01, 3.5937637300E+00, 9.6877008375E-01],
	[3.9985000000E+04, 3.4541167243E+01, 5.2349108507E+00, 1.7166711816E+01, 3.5941686716E+00, 9.6878446373E-01],
	[3.9990000000E+04, 3.4548699746E+01, 5.2349446752E+00, 1.7173725246E+01, 3.5945735102E+00, 9.6879883644E-01],
	[3.9995000000E+04, 3.4556232949E+01, 5.2349784957E+00, 1.7180740663E+01, 3.5949782460E+00, 9.6881320188E-01],
	[4.0000000000E+04, 3.4563766853E+01, 5.2350123122E+00, 1.7187758067E+01, 3.5953828790E+00, 9.6882756006E-01],
	[4.0005000000E+04, 3.4571301457E+01, 5.2350461247E+00, 1.7194803562E+01, 3.5957885506E+00, 9.6884191098E-01],
	[4.0010000000E+04, 3.4578836762E+01, 5.2350799332E+00, 1.7201851063E+01, 3.5961941188E+00, 9.6885625465E-01],
	[4.0015000000E+04, 3.4586372767E+01, 5.2351137376E+00, 1.7208900570E+01, 3.5965995837E+00, 9.6887059106E-01],
	[4.0020000000E+04, 3.4593909473E+01, 5.2351475381E+00, 1.7215952085E+01, 3.5970049453E+00, 9.6888492023E-01],
	[4.0025000000E+04, 3.4601446879E+01, 5.2351813346E+00, 1.7223005607E+01, 3.5974102036E+00, 9.6889924215E-01],
	[4.0030000000E+04, 3.4608984986E+01, 5.2352151270E+00, 1.7230061137E+01, 3.5978153586E+00, 9.6891355683E-01],
	[4.0035000000E+04, 3.4616523793E+01, 5.2352489155E+00, 1.7237118674E+01, 3.5982204104E+00, 9.6892786427E-01],
	[4.0040000000E+04, 3.4624063301E+01, 5.2352826999E+00, 1.7244178220E+01, 3.5986253589E+00, 9.6894216447E-01],
	[4.0045000000E+04, 3.4631603509E+01, 5.2353164804E+00, 1.7251239775E+01, 3.5990302042E+00, 9.6895645745E-01],
	[4.0050000000E+04, 3.4639144417E+01, 5.2353502568E+00, 1.7258303338E+01, 3.5994349463E+00, 9.6897074320E-01],
	[4.0055000000E+04, 3.4646686026E+01, 5.2353840293E+00, 1.7265368911E+01, 3.5998395853E+00, 9.6898502172E-01],
	[4.0060000000E+04, 3.4654228334E+01, 5.2354177978E+00, 1.7272436494E+01, 3.6002441211E+00, 9.6899929302E-01],
	[4.0065000000E+04, 3.4661771344E+01, 5.2354515622E+00, 1.7279506086E+01, 3.6006485537E+00, 9.6901355711E-01],
	[4.0070000000E+04, 3.4669315053E+01, 5.2354853227E+00, 1.7286577689E+01, 3.6010528833E+00, 9.6902781398E-01],
	[4.0075000000E+04, 3.4676859463E+01, 5.2355190792E+00, 1.7293651302E+01, 3.6014571098E+00, 9.6904206365E-01],
	[4.0080000000E+04, 3.4684404572E+01, 5.2355528316E+00, 1.7300726926E+01, 3.6018612332E+00, 9.6905630610E-01],
	[4.0085000000E+04, 3.4691950382E+01, 5.2355865801E+00, 1.7307804561E+01, 3.6022652536E+00, 9.6907054136E-01],
	[4.0090000000E+04, 3.4699496893E+01, 5.2356203246E+00, 1.7314884208E+01, 3.6026691710E+00, 9.6908476941E-01],
	[4.0095000000E+04, 3.4707044103E+01, 5.2356540651E+00, 1.7321965867E+01, 3.6030729854E+00, 9.6909899027E-01],
	[4.0100000000E+04, 3.4714592013E+01, 5.2356878016E+00, 1.7329049538E+01, 3.6034766968E+00, 9.6911320394E-01],
	[4.0105000000E+04, 3.4722140624E+01, 5.2357215341E+00, 1.7336135221E+01, 3.6038803052E+00, 9.6912741041E-01],
	[4.0110000000E+04, 3.4729689935E+01, 5.2357552627E+00, 1.7343222917E+01, 3.6042838107E+00, 9.6914160970E-01],
	[4.0115000000E+04, 3.4737239945E+01, 5.2357889872E+00, 1.7350312626E+01, 3.6046872133E+00, 9.6915580181E-01],
	[4.0120000000E+04, 3.4744790656E+01, 5.2358227078E+00, 1.7357404349E+01, 3.6050905130E+00, 9.6916998675E-01],
	[4.0125000000E+04, 3.4752342067E+01, 5.2358564243E+00, 1.7364498086E+01, 3.6054937099E+00, 9.6918416450E-01],
	[4.0130000000E+04, 3.4759894177E+01, 5.2358901369E+00, 1.7371593836E+01, 3.6058968039E+00, 9.6919833509E-01],
	[4.0135000000E+04, 3.4767446988E+01, 5.2359238455E+00, 1.7378691601E+01, 3.6062997950E+00, 9.6921249851E-01],
	[4.0140000000E+04, 3.4775000499E+01, 5.2359575502E+00, 1.7385791381E+01, 3.6067026834E+00, 9.6922665476E-01],
	[4.0145000000E+04, 3.4782554709E+01, 5.2359912508E+00, 1.7392893175E+01, 3.6071054690E+00, 9.6924080385E-01],
	[4.0150000000E+04, 3.4790109619E+01, 5.2360249475E+00, 1.7399996986E+01, 3.6075081518E+00, 9.6925494579E-01],
	[4.0155000000E+04, 3.4797665230E+01, 5.2360586402E+00, 1.7407102811E+01, 3.6079107319E+00, 9.6926908057E-01],
	[4.0160000000E+04, 3.4805221540E+01, 5.2360923289E+00, 1.7414210653E+01, 3.6083132093E+00, 9.6928320820E-01],
	[4.0165000000E+04, 3.4812778550E+01, 5.2361260136E+00, 1.7421320511E+01, 3.6087155840E+00, 9.6929732869E-01],
	[4.0170000000E+04, 3.4820336260E+01, 5.2361596944E+00, 1.7428432386E+01, 3.6091178560E+00, 9.6931144203E-01],
	[4.0175000000E+04, 3.4827894669E+01, 5.2361933711E+00, 1.7435546278E+01, 3.6095200253E+00, 9.6932554823E-01],
	[4.0180000000E+04, 3.4835453778E+01, 5.2362270439E+00, 1.7442662187E+01, 3.6099220921E+00, 9.6933964730E-01],
	[4.0185000000E+04, 3.4843013587E+01, 5.2362607128E+00, 1.7449780114E+01, 3.6103240562E+00, 9.6935373923E-01],
	[4.0190000000E+04, 3.4850574096E+01, 5.2362943776E+00, 1.7456900058E+01, 3.6107259177E+00, 9.6936782403E-01],
	[4.0195000000E+04, 3.4858135305E+01, 5.2363280385E+00, 1.7464022021E+01, 3.6111276767E+00, 9.6938190171E-01],
	[4.0200000000E+04, 3.4865697213E+01, 5.2363616954E+00, 1.7471146003E+01, 3.6115293331E+00, 9.6939597227E-01],
	[4.0205000000E+04, 3.4873259821E+01, 5.2363953484E+00, 1.7478272003E+01, 3.6119308870E+00, 9.6941003571E-01],
	[4.0210000000E+04, 3.4880823128E+01, 5.2364289973E+00, 1.7485400022E+01, 3.6123323384E+00, 9.6942409203E-01],
	[4.0215000000E+04, 3.4888387135E+01, 5.2364626424E+00, 1.7492530062E+01, 3.6127336873E+00, 9.6943814124E-01],
	[4.0220000000E+04, 3.4895951842E+01, 5.2364962834E+00, 1.7499662120E+01, 3.6131349338E+00, 9.6945218335E-01],
	[4.0225000000E+04, 3.4903517248E+01, 5.2365299205E+00, 1.7506796200E+01, 3.6135360778E+00, 9.6946621834E-01],
	[4.0230000000E+04, 3.4911083353E+01, 5.2365635536E+00, 1.7513932299E+01, 3.6139371194E+00, 9.6948024624E-01],
	[4.0235000000E+04, 3.4918650159E+01, 5.2365971827E+00, 1.7521070420E+01, 3.6143380587E+00, 9.6949426704E-01],
	[4.0240000000E+04, 3.4926217663E+01, 5.2366308079E+00, 1.7528210561E+01, 3.6147388955E+00, 9.6950828075E-01],
	[4.0245000000E+04, 3.4933785868E+01, 5.2366644291E+00, 1.7535352724E+01, 3.6151396300E+00, 9.6952228737E-01],
	[4.0250000000E+04, 3.4941354771E+01, 5.2366980464E+00, 1.7542496909E+01, 3.6155402622E+00, 9.6953628690E-01],
	[4.0255000000E+04, 3.4948924374E+01, 5.2367316597E+00, 1.7549643116E+01, 3.6159407921E+00, 9.6955027934E-01],
	[4.0260000000E+04, 3.4956494677E+01, 5.2367652691E+00, 1.7556791346E+01, 3.6163412197E+00, 9.6956426471E-01],
	[4.0265000000E+04, 3.4964065679E+01, 5.2367988744E+00, 1.7563941598E+01, 3.6167415450E+00, 9.6957824300E-01],
	[4.0270000000E+04, 3.4971637380E+01, 5.2368324759E+00, 1.7571093873E+01, 3.6171417681E+00, 9.6959221421E-01],
	[4.0275000000E+04, 3.4979209780E+01, 5.2368660733E+00, 1.7578248171E+01, 3.6175418890E+00, 9.6960617836E-01],
	[4.0280000000E+04, 3.4986782880E+01, 5.2368996669E+00, 1.7585404494E+01, 3.6179419077E+00, 9.6962013544E-01],
	[4.0285000000E+04, 3.4994356679E+01, 5.2369332564E+00, 1.7592562840E+01, 3.6183418242E+00, 9.6963408546E-01],
	[4.0290000000E+04, 3.5001931178E+01, 5.2369668420E+00, 1.7599723211E+01, 3.6187416385E+00, 9.6964802842E-01],
	[4.0295000000E+04, 3.5009506375E+01, 5.2370004237E+00, 1.7606885606E+01, 3.6191413507E+00, 9.6966196433E-01],
	[4.0300000000E+04, 3.5017082272E+01, 5.2370340014E+00, 1.7614050026E+01, 3.6195409608E+00, 9.6967589318E-01],
	[4.0305000000E+04, 3.5024658869E+01, 5.2370675751E+00, 1.7621216472E+01, 3.6199404689E+00, 9.6968981499E-01],
	[4.0310000000E+04, 3.5032236164E+01, 5.2371011449E+00, 1.7628384943E+01, 3.6203398748E+00, 9.6970372975E-01],
	[4.0315000000E+04, 3.5039814158E+01, 5.2371347108E+00, 1.7635555441E+01, 3.6207391787E+00, 9.6971763747E-01],
	[4.0320000000E+04, 3.5047392852E+01, 5.2371682727E+00, 1.7642727964E+01, 3.6211383806E+00, 9.6973153815E-01],
	[4.0325000000E+04, 3.5054972245E+01, 5.2372018307E+00, 1.7649902514E+01, 3.6215374805E+00, 9.6974543180E-01],
	[4.0330000000E+04, 3.5062552336E+01, 5.2372353847E+00, 1.7657079091E+01, 3.6219364784E+00, 9.6975931842E-01],
	[4.0335000000E+04, 3.5070133127E+01, 5.2372689348E+00, 1.7664257696E+01, 3.6223353744E+00, 9.6977319801E-01],
	[4.0340000000E+04, 3.5077714617E+01, 5.2373024809E+00, 1.7671438327E+01, 3.6227341684E+00, 9.6978707057E-01],
	[4.0345000000E+04, 3.5085296806E+01, 5.2373360231E+00, 1.7678620987E+01, 3.6231328605E+00, 9.6980093612E-01],
	[4.0350000000E+04, 3.5092879694E+01, 5.2373695613E+00, 1.7685805675E+01, 3.6235314507E+00, 9.6981479465E-01],
	[4.0355000000E+04, 3.5100463281E+01, 5.2374030956E+00, 1.7692992392E+01, 3.6239299390E+00, 9.6982864616E-01],
	[4.0360000000E+04, 3.5108047567E+01, 5.2374366260E+00, 1.7700181137E+01, 3.6243283255E+00, 9.6984249067E-01],
	[4.0365000000E+04, 3.5115632552E+01, 5.2374701524E+00, 1.7707371911E+01, 3.6247266102E+00, 9.6985632817E-01],
	[4.0370000000E+04, 3.5123218235E+01, 5.2375036749E+00, 1.7714564715E+01, 3.6251247931E+00, 9.6987015867E-01],
	[4.0375000000E+04, 3.5130804618E+01, 5.2375371934E+00, 1.7721759549E+01, 3.6255228741E+00, 9.6988398217E-01],
	[4.0380000000E+04, 3.5138391700E+01, 5.2375707080E+00, 1.7728956413E+01, 3.6259208535E+00, 9.6989779867E-01],
	[4.0385000000E+04, 3.5145979480E+01, 5.2376042187E+00, 1.7736155307E+01, 3.6263187310E+00, 9.6991160819E-01],
	[4.0390000000E+04, 3.5153567959E+01, 5.2376377255E+00, 1.7743356232E+01, 3.6267165069E+00, 9.6992541071E-01],
	[4.0395000000E+04, 3.5161157137E+01, 5.2376712283E+00, 1.7750559188E+01, 3.6271141811E+00, 9.6993920625E-01],
	[4.0400000000E+04, 3.5168747014E+01, 5.2377047272E+00, 1.7757764176E+01, 3.6275117536E+00, 9.6995299480E-01],
	[4.0405000000E+04, 3.5176337590E+01, 5.2377382221E+00, 1.7764971195E+01, 3.6279092244E+00, 9.6996677638E-01],
	[4.0410000000E+04, 3.5183928864E+01, 5.2377717131E+00, 1.7772180247E+01, 3.6283065936E+00, 9.6998055099E-01],
	[4.0415000000E+04, 3.5191520837E+01, 5.2378052002E+00, 1.7779391331E+01, 3.6287038612E+00, 9.6999431862E-01],
	[4.0420000000E+04, 3.5199113509E+01, 5.2378386834E+00, 1.7786604447E+01, 3.6291010272E+00, 9.7000807929E-01],
	[4.0425000000E+04, 3.5206706879E+01, 5.2378721626E+00, 1.7793819597E+01, 3.6294980917E+00, 9.7002183299E-01],
	[4.0430000000E+04, 3.5214300948E+01, 5.2379056379E+00, 1.7801036779E+01, 3.6298950546E+00, 9.7003557973E-01],
	[4.0435000000E+04, 3.5221895716E+01, 5.2379391093E+00, 1.7808255996E+01, 3.6302919160E+00, 9.7004931952E-01],
	[4.0440000000E+04, 3.5229491182E+01, 5.2379725767E+00, 1.7815477246E+01, 3.6306886759E+00, 9.7006305235E-01],
	[4.0445000000E+04, 3.5237087347E+01, 5.2380060402E+00, 1.7822700531E+01, 3.6310853343E+00, 9.7007677823E-01],
	[4.0450000000E+04, 3.5244684210E+01, 5.2380394998E+00, 1.7829925851E+01, 3.6314818912E+00, 9.7009049717E-01],
	[4.0455000000E+04, 3.5252281772E+01, 5.2380729555E+00, 1.7837153205E+01, 3.6318783467E+00, 9.7010420916E-01],
	[4.0460000000E+04, 3.5259880033E+01, 5.2381064073E+00, 1.7844382594E+01, 3.6322747009E+00, 9.7011791421E-01],
	[4.0465000000E+04, 3.5267478991E+01, 5.2381398551E+00, 1.7851614020E+01, 3.6326709536E+00, 9.7013161233E-01],
	[4.0470000000E+04, 3.5275078649E+01, 5.2381732991E+00, 1.7858847481E+01, 3.6330671049E+00, 9.7014530352E-01],
	[4.0475000000E+04, 3.5282679005E+01, 5.2382067391E+00, 1.7866082978E+01, 3.6334631549E+00, 9.7015898777E-01],
	[4.0480000000E+04, 3.5290280059E+01, 5.2382401751E+00, 1.7873320512E+01, 3.6338591036E+00, 9.7017266510E-01],
	[4.0485000000E+04, 3.5297881812E+01, 5.2382736073E+00, 1.7880560083E+01, 3.6342549510E+00, 9.7018633551E-01],
	[4.0490000000E+04, 3.5305484263E+01, 5.2383070356E+00, 1.7887801691E+01, 3.6346506971E+00, 9.7019999900E-01],
	[4.0495000000E+04, 3.5313087412E+01, 5.2383404599E+00, 1.7895045336E+01, 3.6350463419E+00, 9.7021365558E-01],
	[4.0500000000E+04, 3.5320691260E+01, 5.2383738803E+00, 1.7902291020E+01, 3.6354418855E+00, 9.7022730525E-01],
	[4.0505000000E+04, 3.5328295806E+01, 5.2384072969E+00, 1.7909538741E+01, 3.6358373279E+00, 9.7024094800E-01],
	[4.0510000000E+04, 3.5335901051E+01, 5.2384407095E+00, 1.7916788501E+01, 3.6362326691E+00, 9.7025458386E-01],
	[4.0515000000E+04, 3.5343523612E+01, 5.2384761921E+00, 1.7924040300E+01, 3.6366290846E+00, 9.7026821281E-01],
	[4.0520000000E+04, 3.5351147628E+01, 5.2385117643E+00, 1.7931294138E+01, 3.6370254523E+00, 9.7028183487E-01],
	[4.0525000000E+04, 3.5358772347E+01, 5.2385473324E+00, 1.7938550015E+01, 3.6374217192E+00, 9.7029545003E-01],
	[4.0530000000E+04, 3.5366397770E+01, 5.2385828963E+00, 1.7945807932E+01, 3.6378178853E+00, 9.7030905830E-01],
	[4.0535000000E+04, 3.5374023897E+01, 5.2386184561E+00, 1.7953067889E+01, 3.6382139506E+00, 9.7032265968E-01],
	[4.0540000000E+04, 3.5381650727E+01, 5.2386540117E+00, 1.7960329887E+01, 3.6386099151E+00, 9.7033625419E-01],
	[4.0545000000E+04, 3.5389278260E+01, 5.2386895632E+00, 1.7967593925E+01, 3.6390057789E+00, 9.7034984181E-01],
	[4.0550000000E+04, 3.5396906497E+01, 5.2387251106E+00, 1.7974860005E+01, 3.6394015419E+00, 9.7036342255E-01],
	[4.0555000000E+04, 3.5404535438E+01, 5.2387606538E+00, 1.7982128126E+01, 3.6397972042E+00, 9.7037699643E-01],
	[4.0560000000E+04, 3.5412165081E+01, 5.2387961928E+00, 1.7989398288E+01, 3.6401927659E+00, 9.7039056343E-01],
	[4.0565000000E+04, 3.5419795428E+01, 5.2388317278E+00, 1.7996670492E+01, 3.6405882269E+00, 9.7040412357E-01],
	[4.0570000000E+04, 3.5427426479E+01, 5.2388672585E+00, 1.8003944739E+01, 3.6409835872E+00, 9.7041767685E-01],
	[4.0575000000E+04, 3.5435058233E+01, 5.2389027852E+00, 1.8011221029E+01, 3.6413788469E+00, 9.7043122326E-01],
	[4.0580000000E+04, 3.5442690690E+01, 5.2389383077E+00, 1.8018499361E+01, 3.6417740061E+00, 9.7044476283E-01],
	[4.0585000000E+04, 3.5450323851E+01, 5.2389738261E+00, 1.8025779737E+01, 3.6421690646E+00, 9.7045829554E-01],
	[4.0590000000E+04, 3.5457957715E+01, 5.2390093403E+00, 1.8033062156E+01, 3.6425640226E+00, 9.7047182140E-01],
	[4.0595000000E+04, 3.5465592282E+01, 5.2390448504E+00, 1.8040346620E+01, 3.6429588801E+00, 9.7048534042E-01],
	[4.0600000000E+04, 3.5473227552E+01, 5.2390803564E+00, 1.8047633127E+01, 3.6433536370E+00, 9.7049885260E-01],
	[4.0605000000E+04, 3.5480863526E+01, 5.2391158583E+00, 1.8054921679E+01, 3.6437482935E+00, 9.7051235793E-01],
	[4.0610000000E+04, 3.5488500202E+01, 5.2391513560E+00, 1.8062212277E+01, 3.6441428495E+00, 9.7052585644E-01],
	[4.0615000000E+04, 3.5496137582E+01, 5.2391868496E+00, 1.8069504919E+01, 3.6445373050E+00, 9.7053934811E-01],
	[4.0620000000E+04, 3.5503775665E+01, 5.2392223390E+00, 1.8076799607E+01, 3.6449316602E+00, 9.7055283296E-01],
	[4.0625000000E+04, 3.5511414452E+01, 5.2392578243E+00, 1.8084096341E+01, 3.6453259149E+00, 9.7056631099E-01],
	[4.0630000000E+04, 3.5519053941E+01, 5.2392933055E+00, 1.8091395121E+01, 3.6457200693E+00, 9.7057978219E-01],
	[4.0635000000E+04, 3.5526694134E+01, 5.2393287826E+00, 1.8098695947E+01, 3.6461141232E+00, 9.7059324658E-01],
	[4.0640000000E+04, 3.5534335029E+01, 5.2393642556E+00, 1.8105998820E+01, 3.6465080769E+00, 9.7060670415E-01],
	[4.0645000000E+04, 3.5541976628E+01, 5.2393997244E+00, 1.8113303741E+01, 3.6469019302E+00, 9.7062015492E-01],
	[4.0650000000E+04, 3.5549618929E+01, 5.2394351891E+00, 1.8120610709E+01, 3.6472956833E+00, 9.7063359888E-01],
	[4.0655000000E+04, 3.5557261934E+01, 5.2394706497E+00, 1.8127919725E+01, 3.6476893361E+00, 9.7064703603E-01],
	[4.0660000000E+04, 3.5564905641E+01, 5.2395061061E+00, 1.8135230788E+01, 3.6480828886E+00, 9.7066046639E-01],
	[4.0665000000E+04, 3.5572550052E+01, 5.2395415585E+00, 1.8142543901E+01, 3.6484763409E+00, 9.7067388995E-01],
	[4.0670000000E+04, 3.5580195165E+01, 5.2395770067E+00, 1.8149859062E+01, 3.6488696930E+00, 9.7068730672E-01],
	[4.0675000000E+04, 3.5587840982E+01, 5.2396124508E+00, 1.8157176272E+01, 3.6492629449E+00, 9.7070071670E-01],
	[4.0680000000E+04, 3.5595487501E+01, 5.2396478908E+00, 1.8164495532E+01, 3.6496560967E+00, 9.7071411990E-01],
	[4.0685000000E+04, 3.5603134723E+01, 5.2396833266E+00, 1.8171816841E+01, 3.6500491483E+00, 9.7072751631E-01],
	[4.0690000000E+04, 3.5610782648E+01, 5.2397187584E+00, 1.8179140200E+01, 3.6504420998E+00, 9.7074090594E-01],
	[4.0695000000E+04, 3.5618431276E+01, 5.2397541860E+00, 1.8186465610E+01, 3.6508349512E+00, 9.7075428881E-01],
	[4.0700000000E+04, 3.5626080607E+01, 5.2397896095E+00, 1.8193793071E+01, 3.6512277026E+00, 9.7076766490E-01],
	[4.0705000000E+04, 3.5633730640E+01, 5.2398250290E+00, 1.8201122582E+01, 3.6516203538E+00, 9.7078103422E-01],
	[4.0710000000E+04, 3.5641381376E+01, 5.2398604443E+00, 1.8208454145E+01, 3.6520129051E+00, 9.7079439678E-01],
	[4.0715000000E+04, 3.5649032815E+01, 5.2398958555E+00, 1.8215787760E+01, 3.6524053563E+00, 9.7080775257E-01],
	[4.0720000000E+04, 3.5656684957E+01, 5.2399312625E+00, 1.8223123426E+01, 3.6527977076E+00, 9.7082110161E-01],
	[4.0725000000E+04, 3.5664337801E+01, 5.2399666655E+00, 1.8230461145E+01, 3.6531899589E+00, 9.7083444390E-01],
	[4.0730000000E+04, 3.5671991348E+01, 5.2400020644E+00, 1.8237800916E+01, 3.6535821102E+00, 9.7084777944E-01],
	[4.0735000000E+04, 3.5679645598E+01, 5.2400374592E+00, 1.8245142741E+01, 3.6539741617E+00, 9.7086110823E-01],
	[4.0740000000E+04, 3.5687300550E+01, 5.2400728498E+00, 1.8252486619E+01, 3.6543661132E+00, 9.7087443027E-01],
	[4.0745000000E+04, 3.5694956205E+01, 5.2401082364E+00, 1.8259832550E+01, 3.6547579649E+00, 9.7088774558E-01],
	[4.0750000000E+04, 3.5702612563E+01, 5.2401436188E+00, 1.8267180535E+01, 3.6551497167E+00, 9.7090105415E-01],
	[4.0755000000E+04, 3.5710269623E+01, 5.2401789972E+00, 1.8274530575E+01, 3.6555413686E+00, 9.7091435599E-01],
	[4.0760000000E+04, 3.5717927386E+01, 5.2402143714E+00, 1.8281882669E+01, 3.6559329208E+00, 9.7092765110E-01],
	[4.0765000000E+04, 3.5725585851E+01, 5.2402497416E+00, 1.8289236817E+01, 3.6563243732E+00, 9.7094093948E-01],
	[4.0770000000E+04, 3.5733245018E+01, 5.2402851076E+00, 1.8296593022E+01, 3.6567157258E+00, 9.7095422114E-01],
	[4.0775000000E+04, 3.5740904889E+01, 5.2403204695E+00, 1.8303951281E+01, 3.6571069786E+00, 9.7096749609E-01],
	[4.0780000000E+04, 3.5748565461E+01, 5.2403558274E+00, 1.8311311597E+01, 3.6574981318E+00, 9.7098076431E-01],
	[4.0785000000E+04, 3.5756226736E+01, 5.2403911812E+00, 1.8318673968E+01, 3.6578891852E+00, 9.7099402583E-01],
	[4.0790000000E+04, 3.5763888714E+01, 5.2404265308E+00, 1.8326038396E+01, 3.6582801389E+00, 9.7100728063E-01],
	[4.0795000000E+04, 3.5771551394E+01, 5.2404618764E+00, 1.8333404881E+01, 3.6586709930E+00, 9.7102052874E-01],
	[4.0800000000E+04, 3.5779214776E+01, 5.2404972178E+00, 1.8340773424E+01, 3.6590617475E+00, 9.7103377014E-01],
	[4.0805000000E+04, 3.5786878860E+01, 5.2405325552E+00, 1.8348144023E+01, 3.6594524024E+00, 9.7104700484E-01],
	[4.0810000000E+04, 3.5794543647E+01, 5.2405678885E+00, 1.8355516680E+01, 3.6598429576E+00, 9.7106023285E-01],
	[4.0815000000E+04, 3.5802209137E+01, 5.2406032177E+00, 1.8362891396E+01, 3.6602334133E+00, 9.7107345417E-01],
	[4.0820000000E+04, 3.5809875328E+01, 5.2406385428E+00, 1.8370268170E+01, 3.6606237694E+00, 9.7108666880E-01],
	[4.0825000000E+04, 3.5817542222E+01, 5.2406738638E+00, 1.8377647002E+01, 3.6610140261E+00, 9.7109987674E-01],
	[4.0830000000E+04, 3.5825209818E+01, 5.2407091808E+00, 1.8385027894E+01, 3.6614041832E+00, 9.7111307801E-01],
	[4.0835000000E+04, 3.5832878116E+01, 5.2407444936E+00, 1.8392410845E+01, 3.6617942408E+00, 9.7112627260E-01],
	[4.0840000000E+04, 3.5840547117E+01, 5.2407798024E+00, 1.8399795856E+01, 3.6621841990E+00, 9.7113946051E-01],
	[4.0845000000E+04, 3.5848216819E+01, 5.2408151070E+00, 1.8407182927E+01, 3.6625740577E+00, 9.7115264176E-01],
	[4.0850000000E+04, 3.5855887224E+01, 5.2408504076E+00, 1.8414572058E+01, 3.6629638170E+00, 9.7116581634E-01],
	[4.0855000000E+04, 3.5863558331E+01, 5.2408857041E+00, 1.8421963250E+01, 3.6633534770E+00, 9.7117898426E-01],
	[4.0860000000E+04, 3.5871230140E+01, 5.2409209966E+00, 1.8429356503E+01, 3.6637430375E+00, 9.7119214551E-01],
	[4.0865000000E+04, 3.5878902651E+01, 5.2409562849E+00, 1.8436751817E+01, 3.6641324987E+00, 9.7120530011E-01],
	[4.0870000000E+04, 3.5886575864E+01, 5.2409915692E+00, 1.8444149193E+01, 3.6645218606E+00, 9.7121844806E-01],
	[4.0875000000E+04, 3.5894249780E+01, 5.2410268494E+00, 1.8451548631E+01, 3.6649111232E+00, 9.7123158936E-01],
	[4.0880000000E+04, 3.5901924397E+01, 5.2410621255E+00, 1.8458950131E+01, 3.6653002865E+00, 9.7124472401E-01],
	[4.0885000000E+04, 3.5909599716E+01, 5.2410973975E+00, 1.8466353694E+01, 3.6656893505E+00, 9.7125785203E-01],
	[4.0890000000E+04, 3.5917275737E+01, 5.2411326655E+00, 1.8473759320E+01, 3.6660783153E+00, 9.7127097340E-01],
	[4.0895000000E+04, 3.5924952460E+01, 5.2411679293E+00, 1.8481167008E+01, 3.6664671808E+00, 9.7128408814E-01],
	[4.0900000000E+04, 3.5932629886E+01, 5.2412031891E+00, 1.8488576761E+01, 3.6668559472E+00, 9.7129719624E-01],
	[4.0905000000E+04, 3.5940308013E+01, 5.2412384449E+00, 1.8495988577E+01, 3.6672446144E+00, 9.7131029772E-01],
	[4.0910000000E+04, 3.5947986842E+01, 5.2412736965E+00, 1.8503402458E+01, 3.6676331824E+00, 9.7132339257E-01],
	[4.0915000000E+04, 3.5955666373E+01, 5.2413089441E+00, 1.8510818403E+01, 3.6680216514E+00, 9.7133648080E-01],
	[4.0920000000E+04, 3.5963346605E+01, 5.2413441876E+00, 1.8518236413E+01, 3.6684100212E+00, 9.7134956242E-01],
	[4.0925000000E+04, 3.5971027540E+01, 5.2413794271E+00, 1.8525656489E+01, 3.6687982919E+00, 9.7136263742E-01],
	[4.0930000000E+04, 3.5978709176E+01, 5.2414146625E+00, 1.8533078629E+01, 3.6691864636E+00, 9.7137570580E-01],
	[4.0935000000E+04, 3.5986391514E+01, 5.2414498938E+00, 1.8540502836E+01, 3.6695745362E+00, 9.7138876759E-01],
	[4.0940000000E+04, 3.5994074554E+01, 5.2414851210E+00, 1.8547929109E+01, 3.6699625098E+00, 9.7140182276E-01],
	[4.0945000000E+04, 3.6001758296E+01, 5.2415203442E+00, 1.8555357448E+01, 3.6703503844E+00, 9.7141487134E-01],
	[4.0950000000E+04, 3.6009442739E+01, 5.2415555633E+00, 1.8562787854E+01, 3.6707381600E+00, 9.7142791332E-01],
	[4.0955000000E+04, 3.6017127884E+01, 5.2415907784E+00, 1.8570220327E+01, 3.6711258367E+00, 9.7144094871E-01],
	[4.0960000000E+04, 3.6024813731E+01, 5.2416259894E+00, 1.8577654868E+01, 3.6715134144E+00, 9.7145397750E-01],
	[4.0965000000E+04, 3.6032500279E+01, 5.2416611963E+00, 1.8585091476E+01, 3.6719008933E+00, 9.7146699971E-01],
	[4.0970000000E+04, 3.6040187529E+01, 5.2416963992E+00, 1.8592530153E+01, 3.6722882732E+00, 9.7148001534E-01],
	[4.0975000000E+04, 3.6047875481E+01, 5.2417315980E+00, 1.8599970898E+01, 3.6726755543E+00, 9.7149302439E-01],
	[4.0980000000E+04, 3.6055564134E+01, 5.2417667928E+00, 1.8607413712E+01, 3.6730627365E+00, 9.7150602686E-01],
	[4.0985000000E+04, 3.6063253489E+01, 5.2418019835E+00, 1.8614858594E+01, 3.6734498199E+00, 9.7151902275E-01],
	[4.0990000000E+04, 3.6070943545E+01, 5.2418371701E+00, 1.8622305546E+01, 3.6738368046E+00, 9.7153201208E-01],
	[4.0995000000E+04, 3.6078634303E+01, 5.2418723527E+00, 1.8629754568E+01, 3.6742236904E+00, 9.7154499485E-01],
	[4.1000000000E+04, 3.6086325763E+01, 5.2419075312E+00, 1.8637205660E+01, 3.6746104775E+00, 9.7155797105E-01],
	[4.1005000000E+04, 3.6094017923E+01, 5.2419427057E+00, 1.8644658822E+01, 3.6749971658E+00, 9.7157094069E-01],
	[4.1010000000E+04, 3.6101710786E+01, 5.2419778761E+00, 1.8652114055E+01, 3.6753837555E+00, 9.7158390378E-01],
	[4.1015000000E+04, 3.6109404350E+01, 5.2420130425E+00, 1.8659571359E+01, 3.6757702464E+00, 9.7159686031E-01],
	[4.1020000000E+04, 3.6117098615E+01, 5.2420482048E+00, 1.8667030734E+01, 3.6761566387E+00, 9.7160981030E-01],
	[4.1025000000E+04, 3.6124793581E+01, 5.2420833631E+00, 1.8674492181E+01, 3.6765429324E+00, 9.7162275374E-01],
	[4.1030000000E+04, 3.6132489249E+01, 5.2421185173E+00, 1.8681955700E+01, 3.6769291274E+00, 9.7163569064E-01],
	[4.1035000000E+04, 3.6140185619E+01, 5.2421536675E+00, 1.8689421291E+01, 3.6773152238E+00, 9.7164862100E-01],
	[4.1040000000E+04, 3.6147882689E+01, 5.2421888136E+00, 1.8696888955E+01, 3.6777012216E+00, 9.7166154483E-01],
	[4.1045000000E+04, 3.6155580461E+01, 5.2422239557E+00, 1.8704358691E+01, 3.6780871209E+00, 9.7167446212E-01],
	[4.1050000000E+04, 3.6163278935E+01, 5.2422590937E+00, 1.8711830501E+01, 3.6784729217E+00, 9.7168737289E-01],
	[4.1055000000E+04, 3.6170978109E+01, 5.2422942277E+00, 1.8719304384E+01, 3.6788586239E+00, 9.7170027713E-01],
	[4.1060000000E+04, 3.6178677985E+01, 5.2423293576E+00, 1.8726780342E+01, 3.6792442277E+00, 9.7171317486E-01],
	[4.1065000000E+04, 3.6186378562E+01, 5.2423644835E+00, 1.8734258373E+01, 3.6796297330E+00, 9.7172606606E-01],
	[4.1070000000E+04, 3.6194079840E+01, 5.2423996054E+00, 1.8741738480E+01, 3.6800151398E+00, 9.7173895075E-01],
	[4.1075000000E+04, 3.6201781820E+01, 5.2424347232E+00, 1.8749220660E+01, 3.6804004482E+00, 9.7175182893E-01],
	[4.1080000000E+04, 3.6209484500E+01, 5.2424698370E+00, 1.8756704917E+01, 3.6807856582E+00, 9.7176470061E-01],
	[4.1085000000E+04, 3.6217187882E+01, 5.2425049468E+00, 1.8764191248E+01, 3.6811707699E+00, 9.7177756578E-01],
	[4.1090000000E+04, 3.6224891965E+01, 5.2425400525E+00, 1.8771679656E+01, 3.6815557831E+00, 9.7179042445E-01],
	[4.1095000000E+04, 3.6232596749E+01, 5.2425751541E+00, 1.8779170139E+01, 3.6819406981E+00, 9.7180327662E-01],
	[4.1100000000E+04, 3.6240302234E+01, 5.2426102518E+00, 1.8786662700E+01, 3.6823255147E+00, 9.7181612231E-01],
	[4.1105000000E+04, 3.6248008420E+01, 5.2426453454E+00, 1.8794157337E+01, 3.6827102330E+00, 9.7182896150E-01],
	[4.1110000000E+04, 3.6255715307E+01, 5.2426804349E+00, 1.8801654051E+01, 3.6830948531E+00, 9.7184179420E-01],
	[4.1115000000E+04, 3.6263422895E+01, 5.2427155205E+00, 1.8809152842E+01, 3.6834793749E+00, 9.7185462042E-01],
	[4.1120000000E+04, 3.6271131184E+01, 5.2427506020E+00, 1.8816653711E+01, 3.6838637985E+00, 9.7186744017E-01],
	[4.1125000000E+04, 3.6278840174E+01, 5.2427856794E+00, 1.8824156659E+01, 3.6842481239E+00, 9.7188025343E-01],
	[4.1130000000E+04, 3.6286549865E+01, 5.2428207529E+00, 1.8831661685E+01, 3.6846323511E+00, 9.7189306023E-01],
	[4.1135000000E+04, 3.6294260257E+01, 5.2428558223E+00, 1.8839168789E+01, 3.6850164802E+00, 9.7190586055E-01],
	[4.1140000000E+04, 3.6301971350E+01, 5.2428908877E+00, 1.8846677973E+01, 3.6854005111E+00, 9.7191865441E-01],
	[4.1145000000E+04, 3.6309683144E+01, 5.2429259490E+00, 1.8854189236E+01, 3.6857844439E+00, 9.7193144181E-01],
	[4.1150000000E+04, 3.6317395639E+01, 5.2429610064E+00, 1.8861702578E+01, 3.6861682786E+00, 9.7194422275E-01],
	[4.1155000000E+04, 3.6325108834E+01, 5.2429960597E+00, 1.8869218001E+01, 3.6865520153E+00, 9.7195699723E-01],
	[4.1160000000E+04, 3.6332822730E+01, 5.2430311090E+00, 1.8876735504E+01, 3.6869356539E+00, 9.7196976526E-01],
	[4.1165000000E+04, 3.6340546377E+01, 5.2430672669E+00, 1.8884255088E+01, 3.6873198379E+00, 9.7198252684E-01],
	[4.1170000000E+04, 3.6348278921E+01, 5.2431044277E+00, 1.8891776753E+01, 3.6877045066E+00, 9.7199528198E-01],
	[4.1175000000E+04, 3.6356012170E+01, 5.2431415842E+00, 1.8899300499E+01, 3.6880890776E+00, 9.7200803068E-01],
	[4.1180000000E+04, 3.6363746126E+01, 5.2431787365E+00, 1.8906826326E+01, 3.6884735509E+00, 9.7202077294E-01],
	[4.1185000000E+04, 3.6371480787E+01, 5.2432158845E+00, 1.8914354236E+01, 3.6888579265E+00, 9.7203350876E-01],
	[4.1190000000E+04, 3.6379216155E+01, 5.2432530283E+00, 1.8921884228E+01, 3.6892422045E+00, 9.7204623815E-01],
	[4.1195000000E+04, 3.6386952228E+01, 5.2432901679E+00, 1.8929416302E+01, 3.6896263849E+00, 9.7205896112E-01],
	[4.1200000000E+04, 3.6394689007E+01, 5.2433273032E+00, 1.8936950460E+01, 3.6900104677E+00, 9.7207167766E-01],
	[4.1205000000E+04, 3.6402426492E+01, 5.2433644343E+00, 1.8944486701E+01, 3.6903944529E+00, 9.7208438778E-01],
	[4.1210000000E+04, 3.6410164683E+01, 5.2434015611E+00, 1.8952025025E+01, 3.6907783405E+00, 9.7209709148E-01],
	[4.1215000000E+04, 3.6417903580E+01, 5.2434386837E+00, 1.8959565433E+01, 3.6911621306E+00, 9.7210978877E-01],
	[4.1220000000E+04, 3.6425643182E+01, 5.2434758020E+00, 1.8967107926E+01, 3.6915458232E+00, 9.7212247965E-01],
	[4.1225000000E+04, 3.6433383490E+01, 5.2435129161E+00, 1.8974652503E+01, 3.6919294183E+00, 9.7213516412E-01],
	[4.1230000000E+04, 3.6441124504E+01, 5.2435500260E+00, 1.8982199165E+01, 3.6923129160E+00, 9.7214784218E-01],
	[4.1235000000E+04, 3.6448866224E+01, 5.2435871316E+00, 1.8989747912E+01, 3.6926963162E+00, 9.7216051385E-01],
	[4.1240000000E+04, 3.6456608649E+01, 5.2436242330E+00, 1.8997298744E+01, 3.6930796189E+00, 9.7217317912E-01],
	[4.1245000000E+04, 3.6464351780E+01, 5.2436613302E+00, 1.9004851663E+01, 3.6934628243E+00, 9.7218583799E-01],
	[4.1250000000E+04, 3.6472095617E+01, 5.2436984231E+00, 1.9012406667E+01, 3.6938459323E+00, 9.7219849048E-01],
	[4.1255000000E+04, 3.6479840160E+01, 5.2437355118E+00, 1.9019963758E+01, 3.6942289429E+00, 9.7221113658E-01],
	[4.1260000000E+04, 3.6487585408E+01, 5.2437725962E+00, 1.9027522936E+01, 3.6946118562E+00, 9.7222377629E-01],
	[4.1265000000E+04, 3.6495331361E+01, 5.2438096765E+00, 1.9035084201E+01, 3.6949946722E+00, 9.7223640963E-01],
	[4.1270000000E+04, 3.6503078021E+01, 5.2438467524E+00, 1.9042647554E+01, 3.6953773909E+00, 9.7224903659E-01],
	[4.1275000000E+04, 3.6510825385E+01, 5.2438838242E+00, 1.9050212994E+01, 3.6957600124E+00, 9.7226165718E-01],
	[4.1280000000E+04, 3.6518573456E+01, 5.2439208917E+00, 1.9057780523E+01, 3.6961425365E+00, 9.7227427139E-01],
	[4.1285000000E+04, 3.6526322232E+01, 5.2439579550E+00, 1.9065350139E+01, 3.6965249635E+00, 9.7228687925E-01],
	[4.1290000000E+04, 3.6534071713E+01, 5.2439950141E+00, 1.9072921845E+01, 3.6969072932E+00, 9.7229948073E-01],
	[4.1295000000E+04, 3.6541821900E+01, 5.2440320690E+00, 1.9080495639E+01, 3.6972895258E+00, 9.7231207586E-01],
	[4.1300000000E+04, 3.6549572792E+01, 5.2440691196E+00, 1.9088071523E+01, 3.6976716612E+00, 9.7232466464E-01],
	[4.1305000000E+04, 3.6557324390E+01, 5.2441061660E+00, 1.9095649497E+01, 3.6980536995E+00, 9.7233724706E-01],
	[4.1310000000E+04, 3.6565076693E+01, 5.2441432082E+00, 1.9103229561E+01, 3.6984356407E+00, 9.7234982313E-01],
	[4.1315000000E+04, 3.6572829702E+01, 5.2441802462E+00, 1.9110811715E+01, 3.6988174848E+00, 9.7236239286E-01],
	[4.1320000000E+04, 3.6580583416E+01, 5.2442172799E+00, 1.9118395960E+01, 3.6991992318E+00, 9.7237495624E-01],
	[4.1325000000E+04, 3.6588337835E+01, 5.2442543094E+00, 1.9125982296E+01, 3.6995808817E+00, 9.7238751329E-01],
	[4.1330000000E+04, 3.6596092960E+01, 5.2442913347E+00, 1.9133570723E+01, 3.6999624346E+00, 9.7240006400E-01],
	[4.1335000000E+04, 3.6603848790E+01, 5.2443283558E+00, 1.9141161242E+01, 3.7003438906E+00, 9.7241260838E-01],
	[4.1340000000E+04, 3.6611605325E+01, 5.2443653727E+00, 1.9148753852E+01, 3.7007252495E+00, 9.7242514643E-01],
	[4.1345000000E+04, 3.6619362565E+01, 5.2444023853E+00, 1.9156348556E+01, 3.7011065115E+00, 9.7243767815E-01],
	[4.1350000000E+04, 3.6627120511E+01, 5.2444393938E+00, 1.9163945351E+01, 3.7014876765E+00, 9.7245020356E-01],
	[4.1355000000E+04, 3.6634879162E+01, 5.2444763980E+00, 1.9171544240E+01, 3.7018687447E+00, 9.7246272264E-01],
	[4.1360000000E+04, 3.6642638518E+01, 5.2445133980E+00, 1.9179145222E+01, 3.7022497159E+00, 9.7247523541E-01],
	[4.1365000000E+04, 3.6650398579E+01, 5.2445503938E+00, 1.9186748297E+01, 3.7026305903E+00, 9.7248774187E-01],
	[4.1370000000E+04, 3.6658159346E+01, 5.2445873854E+00, 1.9194353467E+01, 3.7030113678E+00, 9.7250024202E-01],
	[4.1375000000E+04, 3.6665920818E+01, 5.2446243728E+00, 1.9201960731E+01, 3.7033920485E+00, 9.7251273587E-01],
	[4.1380000000E+04, 3.6673682994E+01, 5.2446613560E+00, 1.9209570089E+01, 3.7037726324E+00, 9.7252522341E-01],
	[4.1385000000E+04, 3.6681445876E+01, 5.2446983349E+00, 1.9217181542E+01, 3.7041531195E+00, 9.7253770466E-01],
	[4.1390000000E+04, 3.6689209463E+01, 5.2447353097E+00, 1.9224795090E+01, 3.7045335098E+00, 9.7255017961E-01],
	[4.1395000000E+04, 3.6696973755E+01, 5.2447722802E+00, 1.9232410734E+01, 3.7049138034E+00, 9.7256264828E-01],
	[4.1400000000E+04, 3.6704738752E+01, 5.2448092466E+00, 1.9240028474E+01, 3.7052940003E+00, 9.7257511065E-01],
	[4.1405000000E+04, 3.6712504454E+01, 5.2448462087E+00, 1.9247648310E+01, 3.7056741005E+00, 9.7258756674E-01],
	[4.1410000000E+04, 3.6720270861E+01, 5.2448831667E+00, 1.9255270242E+01, 3.7060541040E+00, 9.7260001655E-01],
	[4.1415000000E+04, 3.6728037973E+01, 5.2449201204E+00, 1.9262894272E+01, 3.7064340108E+00, 9.7261246008E-01],
	[4.1420000000E+04, 3.6735805790E+01, 5.2449570700E+00, 1.9270520398E+01, 3.7068138211E+00, 9.7262489734E-01],
	[4.1425000000E+04, 3.6743574312E+01, 5.2449940153E+00, 1.9278148622E+01, 3.7071935347E+00, 9.7263732833E-01],
	[4.1430000000E+04, 3.6751343539E+01, 5.2450309564E+00, 1.9285778944E+01, 3.7075731518E+00, 9.7264975305E-01],
	[4.1435000000E+04, 3.6759113471E+01, 5.2450678934E+00, 1.9293411363E+01, 3.7079526722E+00, 9.7266217150E-01],
	[4.1440000000E+04, 3.6766884107E+01, 5.2451048261E+00, 1.9301045882E+01, 3.7083320962E+00, 9.7267458370E-01],
	[4.1445000000E+04, 3.6774655448E+01, 5.2451417547E+00, 1.9308682499E+01, 3.7087114236E+00, 9.7268698964E-01],
	[4.1450000000E+04, 3.6782427495E+01, 5.2451786790E+00, 1.9316321215E+01, 3.7090906545E+00, 9.7269938932E-01],
	[4.1455000000E+04, 3.6790200246E+01, 5.2452155992E+00, 1.9323962030E+01, 3.7094697890E+00, 9.7271178276E-01],
	[4.1460000000E+04, 3.6797973702E+01, 5.2452525152E+00, 1.9331604946E+01, 3.7098488270E+00, 9.7272416995E-01],
	[4.1465000000E+04, 3.6805747862E+01, 5.2452894269E+00, 1.9339249961E+01, 3.7102277686E+00, 9.7273655089E-01],
	[4.1470000000E+04, 3.6813522727E+01, 5.2453263345E+00, 1.9346897077E+01, 3.7106066137E+00, 9.7274892560E-01],
	[4.1475000000E+04, 3.6821298297E+01, 5.2453632379E+00, 1.9354546293E+01, 3.7109853625E+00, 9.7276129406E-01],
	[4.1480000000E+04, 3.6829074572E+01, 5.2454001371E+00, 1.9362197611E+01, 3.7113640149E+00, 9.7277365630E-01],
	[4.1485000000E+04, 3.6836851551E+01, 5.2454370321E+00, 1.9369851029E+01, 3.7117425710E+00, 9.7278601230E-01],
	[4.1490000000E+04, 3.6844629235E+01, 5.2454739230E+00, 1.9377506550E+01, 3.7121210308E+00, 9.7279836208E-01],
	[4.1495000000E+04, 3.6852407624E+01, 5.2455108096E+00, 1.9385164172E+01, 3.7124993942E+00, 9.7281070564E-01],
	[4.1500000000E+04, 3.6860186717E+01, 5.2455476921E+00, 1.9392823897E+01, 3.7128776614E+00, 9.7282304297E-01],
	[4.1505000000E+04, 3.6867966515E+01, 5.2455845703E+00, 1.9400485725E+01, 3.7132558323E+00, 9.7283537409E-01],
	[4.1510000000E+04, 3.6875747018E+01, 5.2456214444E+00, 1.9408149655E+01, 3.7136339071E+00, 9.7284769900E-01],
	[4.1515000000E+04, 3.6883528225E+01, 5.2456583143E+00, 1.9415815689E+01, 3.7140118855E+00, 9.7286001769E-01],
	[4.1520000000E+04, 3.6891310136E+01, 5.2456951801E+00, 1.9423483826E+01, 3.7143897679E+00, 9.7287233018E-01],
	[4.1525000000E+04, 3.6899092752E+01, 5.2457320416E+00, 1.9431154067E+01, 3.7147675540E+00, 9.7288463647E-01],
	[4.1530000000E+04, 3.6906876073E+01, 5.2457688990E+00, 1.9438826413E+01, 3.7151452440E+00, 9.7289693656E-01],
	[4.1535000000E+04, 3.6914660098E+01, 5.2458057522E+00, 1.9446500863E+01, 3.7155228379E+00, 9.7290923045E-01],
	[4.1540000000E+04, 3.6922444827E+01, 5.2458426012E+00, 1.9454177418E+01, 3.7159003357E+00, 9.7292151815E-01],
	[4.1545000000E+04, 3.6930230261E+01, 5.2458794460E+00, 1.9461856079E+01, 3.7162777374E+00, 9.7293379966E-01],
	[4.1550000000E+04, 3.6938016399E+01, 5.2459162867E+00, 1.9469536844E+01, 3.7166550430E+00, 9.7294607498E-01],
	[4.1555000000E+04, 3.6945803242E+01, 5.2459531232E+00, 1.9477219716E+01, 3.7170322527E+00, 9.7295834412E-01],
	[4.1560000000E+04, 3.6953590789E+01, 5.2459899555E+00, 1.9484904694E+01, 3.7174093663E+00, 9.7297060709E-01],
	[4.1565000000E+04, 3.6961379040E+01, 5.2460267836E+00, 1.9492591779E+01, 3.7177863839E+00, 9.7298286387E-01],
	[4.1570000000E+04, 3.6969167996E+01, 5.2460636076E+00, 1.9500280970E+01, 3.7181633056E+00, 9.7299511449E-01],
	[4.1575000000E+04, 3.6976957656E+01, 5.2461004274E+00, 1.9507972269E+01, 3.7185401313E+00, 9.7300735893E-01],
	[4.1580000000E+04, 3.6984748020E+01, 5.2461372430E+00, 1.9515665675E+01, 3.7189168611E+00, 9.7301959721E-01],
	[4.1585000000E+04, 3.6992539089E+01, 5.2461740545E+00, 1.9523361189E+01, 3.7192934950E+00, 9.7303182932E-01],
	[4.1590000000E+04, 3.7000330861E+01, 5.2462108618E+00, 1.9531058811E+01, 3.7196700330E+00, 9.7304405528E-01],
	[4.1595000000E+04, 3.7008123338E+01, 5.2462476649E+00, 1.9538758541E+01, 3.7200464752E+00, 9.7305627508E-01],
	[4.1600000000E+04, 3.7015916519E+01, 5.2462844639E+00, 1.9546460380E+01, 3.7204228216E+00, 9.7306848873E-01],
	[4.1605000000E+04, 3.7023710405E+01, 5.2463212587E+00, 1.9554164329E+01, 3.7207990721E+00, 9.7308069623E-01],
	[4.1610000000E+04, 3.7031504994E+01, 5.2463580493E+00, 1.9561870387E+01, 3.7211752268E+00, 9.7309289759E-01],
	[4.1615000000E+04, 3.7039300287E+01, 5.2463948358E+00, 1.9569578554E+01, 3.7215512858E+00, 9.7310509280E-01],
	[4.1620000000E+04, 3.7047096285E+01, 5.2464316181E+00, 1.9577288832E+01, 3.7219272491E+00, 9.7311728188E-01],
	[4.1625000000E+04, 3.7054892987E+01, 5.2464683962E+00, 1.9585001220E+01, 3.7223031166E+00, 9.7312946481E-01],
	[4.1630000000E+04, 3.7062690393E+01, 5.2465051702E+00, 1.9592715719E+01, 3.7226788884E+00, 9.7314164162E-01],
	[4.1635000000E+04, 3.7070488503E+01, 5.2465419401E+00, 1.9600432329E+01, 3.7230545646E+00, 9.7315381230E-01],
	[4.1640000000E+04, 3.7078287316E+01, 5.2465787057E+00, 1.9608151050E+01, 3.7234301450E+00, 9.7316597685E-01],
	[4.1645000000E+04, 3.7086086834E+01, 5.2466154672E+00, 1.9615871883E+01, 3.7238056299E+00, 9.7317813528E-01],
	[4.1650000000E+04, 3.7093887056E+01, 5.2466522246E+00, 1.9623594829E+01, 3.7241810192E+00, 9.7319028759E-01],
	[4.1655000000E+04, 3.7101687982E+01, 5.2466889778E+00, 1.9631319886E+01, 3.7245563128E+00, 9.7320243379E-01],
	[4.1660000000E+04, 3.7109489612E+01, 5.2467257269E+00, 1.9639047056E+01, 3.7249315109E+00, 9.7321457387E-01],
	[4.1665000000E+04, 3.7117291945E+01, 5.2467624718E+00, 1.9646776339E+01, 3.7253066135E+00, 9.7322670785E-01],
	[4.1670000000E+04, 3.7125094983E+01, 5.2467992125E+00, 1.9654507736E+01, 3.7256816205E+00, 9.7323883572E-01],
	[4.1675000000E+04, 3.7132898725E+01, 5.2468359491E+00, 1.9662241246E+01, 3.7260565320E+00, 9.7325095749E-01],
	[4.1680000000E+04, 3.7140703170E+01, 5.2468726815E+00, 1.9669976870E+01, 3.7264313481E+00, 9.7326307316E-01],
	[4.1685000000E+04, 3.7148508319E+01, 5.2469094098E+00, 1.9677714608E+01, 3.7268060687E+00, 9.7327518273E-01],
	[4.1690000000E+04, 3.7156314172E+01, 5.2469461340E+00, 1.9685454462E+01, 3.7271806938E+00, 9.7328728621E-01],
	[4.1695000000E+04, 3.7164120729E+01, 5.2469828540E+00, 1.9693196430E+01, 3.7275552236E+00, 9.7329938361E-01],
	[4.1700000000E+04, 3.7171927989E+01, 5.2470195698E+00, 1.9700940513E+01, 3.7279296580E+00, 9.7331147492E-01],
	[4.1705000000E+04, 3.7179735953E+01, 5.2470562816E+00, 1.9708686712E+01, 3.7283039970E+00, 9.7332356014E-01],
	[4.1710000000E+04, 3.7187544621E+01, 5.2470929891E+00, 1.9716435026E+01, 3.7286782406E+00, 9.7333563929E-01],
	[4.1715000000E+04, 3.7195353993E+01, 5.2471296925E+00, 1.9724185458E+01, 3.7290523890E+00, 9.7334771237E-01],
	[4.1720000000E+04, 3.7203164069E+01, 5.2471663918E+00, 1.9731938005E+01, 3.7294264420E+00, 9.7335977937E-01],
	[4.1725000000E+04, 3.7210974848E+01, 5.2472030870E+00, 1.9739692670E+01, 3.7298003998E+00, 9.7337184030E-01],
	[4.1730000000E+04, 3.7218786330E+01, 5.2472397780E+00, 1.9747449451E+01, 3.7301742623E+00, 9.7338389517E-01],
	[4.1735000000E+04, 3.7226598517E+01, 5.2472764648E+00, 1.9755208351E+01, 3.7305480296E+00, 9.7339594397E-01],
	[4.1740000000E+04, 3.7234411407E+01, 5.2473131475E+00, 1.9762969368E+01, 3.7309217017E+00, 9.7340798672E-01],
	[4.1745000000E+04, 3.7242225000E+01, 5.2473498261E+00, 1.9770732503E+01, 3.7312952785E+00, 9.7342002341E-01],
	[4.1750000000E+04, 3.7250039297E+01, 5.2473865006E+00, 1.9778497757E+01, 3.7316687602E+00, 9.7343205406E-01],
	[4.1755000000E+04, 3.7257854298E+01, 5.2474231709E+00, 1.9786265130E+01, 3.7320421468E+00, 9.7344407865E-01],
	[4.1760000000E+04, 3.7265670002E+01, 5.2474598370E+00, 1.9794034622E+01, 3.7324154383E+00, 9.7345609719E-01],
	[4.1765000000E+04, 3.7273486410E+01, 5.2474964991E+00, 1.9801806233E+01, 3.7327886346E+00, 9.7346810970E-01],
	[4.1770000000E+04, 3.7281303521E+01, 5.2475331570E+00, 1.9809579964E+01, 3.7331617359E+00, 9.7348011617E-01],
	[4.1775000000E+04, 3.7289121335E+01, 5.2475698108E+00, 1.9817355815E+01, 3.7335347421E+00, 9.7349211660E-01],
	[4.1780000000E+04, 3.7296939853E+01, 5.2476064604E+00, 1.9825133787E+01, 3.7339076533E+00, 9.7350411100E-01],
	[4.1785000000E+04, 3.7304759075E+01, 5.2476431059E+00, 1.9832913880E+01, 3.7342804695E+00, 9.7351609937E-01],
	[4.1790000000E+04, 3.7312579000E+01, 5.2476797473E+00, 1.9840696093E+01, 3.7346531907E+00, 9.7352808172E-01],
	[4.1795000000E+04, 3.7320399628E+01, 5.2477163846E+00, 1.9848480428E+01, 3.7350258169E+00, 9.7354005804E-01],
	[4.1800000000E+04, 3.7328220959E+01, 5.2477530177E+00, 1.9856266885E+01, 3.7353983482E+00, 9.7355202835E-01],
	[4.1805000000E+04, 3.7336042994E+01, 5.2477896467E+00, 1.9864055464E+01, 3.7357707845E+00, 9.7356399264E-01],
	[4.1810000000E+04, 3.7343865733E+01, 5.2478262716E+00, 1.9871846165E+01, 3.7361431260E+00, 9.7357595092E-01],
	[4.1815000000E+04, 3.7351689174E+01, 5.2478628924E+00, 1.9879638989E+01, 3.7365153726E+00, 9.7358790319E-01],
	[4.1820000000E+04, 3.7359513319E+01, 5.2478995090E+00, 1.9887433937E+01, 3.7368875243E+00, 9.7359984945E-01],
	[4.1825000000E+04, 3.7367338167E+01, 5.2479361215E+00, 1.9895231007E+01, 3.7372595812E+00, 9.7361178971E-01],
	[4.1830000000E+04, 3.7375180715E+01, 5.2479747887E+00, 1.9903030201E+01, 3.7376327575E+00, 9.7362372398E-01],
	[4.1835000000E+04, 3.7383024086E+01, 5.2480134654E+00, 1.9910831519E+01, 3.7380058476E+00, 9.7363565225E-01],
	[4.1840000000E+04, 3.7390868166E+01, 5.2480521379E+00, 1.9918634962E+01, 3.7383788431E+00, 9.7364757452E-01],
	[4.1845000000E+04, 3.7398712954E+01, 5.2480908060E+00, 1.9926440529E+01, 3.7387517442E+00, 9.7365949081E-01],
	[4.1850000000E+04, 3.7406558450E+01, 5.2481294698E+00, 1.9934248221E+01, 3.7391245507E+00, 9.7367140112E-01],
	[4.1855000000E+04, 3.7414404654E+01, 5.2481681293E+00, 1.9942058039E+01, 3.7394972629E+00, 9.7368330544E-01],
	[4.1860000000E+04, 3.7422251567E+01, 5.2482067844E+00, 1.9949869982E+01, 3.7398698806E+00, 9.7369520378E-01],
	[4.1865000000E+04, 3.7430099188E+01, 5.2482454352E+00, 1.9957684051E+01, 3.7402424039E+00, 9.7370709615E-01],
	[4.1870000000E+04, 3.7437947517E+01, 5.2482840816E+00, 1.9965500247E+01, 3.7406148328E+00, 9.7371898254E-01],
	[4.1875000000E+04, 3.7445796555E+01, 5.2483227238E+00, 1.9973318569E+01, 3.7409871674E+00, 9.7373086297E-01],
	[4.1880000000E+04, 3.7453646300E+01, 5.2483613616E+00, 1.9981139018E+01, 3.7413594077E+00, 9.7374273743E-01],
	[4.1885000000E+04, 3.7461496754E+01, 5.2483999950E+00, 1.9988961594E+01, 3.7417315536E+00, 9.7375460593E-01],
	[4.1890000000E+04, 3.7469347915E+01, 5.2484386242E+00, 1.9996786298E+01, 3.7421036052E+00, 9.7376646847E-01],
	[4.1895000000E+04, 3.7477199785E+01, 5.2484772490E+00, 2.0004613130E+01, 3.7424755626E+00, 9.7377832505E-01],
	[4.1900000000E+04, 3.7485052363E+01, 5.2485158695E+00, 2.0012442090E+01, 3.7428474257E+00, 9.7379017568E-01],
	[4.1905000000E+04, 3.7492905649E+01, 5.2485544856E+00, 2.0020273179E+01, 3.7432191946E+00, 9.7380202037E-01],
	[4.1910000000E+04, 3.7500759643E+01, 5.2485930975E+00, 2.0028106396E+01, 3.7435908693E+00, 9.7381385910E-01],
	[4.1915000000E+04, 3.7508614345E+01, 5.2486317050E+00, 2.0035941743E+01, 3.7439624498E+00, 9.7382569190E-01],
	[4.1920000000E+04, 3.7516469755E+01, 5.2486703082E+00, 2.0043779219E+01, 3.7443339362E+00, 9.7383751875E-01],
	[4.1925000000E+04, 3.7524325873E+01, 5.2487089071E+00, 2.0051618825E+01, 3.7447053284E+00, 9.7384933967E-01],
	[4.1930000000E+04, 3.7532182698E+01, 5.2487475016E+00, 2.0059460562E+01, 3.7450766265E+00, 9.7386115466E-01],
	[4.1935000000E+04, 3.7540040232E+01, 5.2487860919E+00, 2.0067304428E+01, 3.7454478305E+00, 9.7387296372E-01],
	[4.1940000000E+04, 3.7547898474E+01, 5.2488246778E+00, 2.0075150426E+01, 3.7458189405E+00, 9.7388476685E-01],
	[4.1945000000E+04, 3.7555757423E+01, 5.2488632594E+00, 2.0082998555E+01, 3.7461899564E+00, 9.7389656406E-01],
	[4.1950000000E+04, 3.7563617081E+01, 5.2489018367E+00, 2.0090848815E+01, 3.7465608783E+00, 9.7390835535E-01],
	[4.1955000000E+04, 3.7571477446E+01, 5.2489404097E+00, 2.0098701207E+01, 3.7469317061E+00, 9.7392014072E-01],
	[4.1960000000E+04, 3.7579338519E+01, 5.2489789784E+00, 2.0106555732E+01, 3.7473024400E+00, 9.7393192019E-01],
	[4.1965000000E+04, 3.7587200300E+01, 5.2490175427E+00, 2.0114412388E+01, 3.7476730800E+00, 9.7394369374E-01],
	[4.1970000000E+04, 3.7595062788E+01, 5.2490561028E+00, 2.0122271178E+01, 3.7480436260E+00, 9.7395546138E-01],
	[4.1975000000E+04, 3.7602925985E+01, 5.2490946585E+00, 2.0130132101E+01, 3.7484140780E+00, 9.7396722313E-01],
	[4.1980000000E+04, 3.7610789889E+01, 5.2491332099E+00, 2.0137995157E+01, 3.7487844362E+00, 9.7397897897E-01],
	[4.1985000000E+04, 3.7618654501E+01, 5.2491717570E+00, 2.0145860346E+01, 3.7491547006E+00, 9.7399072892E-01],
	[4.1990000000E+04, 3.7626519820E+01, 5.2492102998E+00, 2.0153727670E+01, 3.7495248710E+00, 9.7400247297E-01],
	[4.1995000000E+04, 3.7634385847E+01, 5.2492488383E+00, 2.0161597129E+01, 3.7498949477E+00, 9.7401421113E-01],
	[4.2000000000E+04, 3.7642252582E+01, 5.2492873725E+00, 2.0169468722E+01, 3.7502649305E+00, 9.7402594341E-01],
	[4.2005000000E+04, 3.7650120025E+01, 5.2493259024E+00, 2.0177342450E+01, 3.7506348196E+00, 9.7403766981E-01],
	[4.2010000000E+04, 3.7657988175E+01, 5.2493644280E+00, 2.0185218313E+01, 3.7510046149E+00, 9.7404939032E-01],
	[4.2015000000E+04, 3.7665857033E+01, 5.2494029493E+00, 2.0193096312E+01, 3.7513743164E+00, 9.7406110496E-01],
	[4.2020000000E+04, 3.7673726598E+01, 5.2494414663E+00, 2.0200976448E+01, 3.7517439243E+00, 9.7407281372E-01],
	[4.2025000000E+04, 3.7681596871E+01, 5.2494799790E+00, 2.0208858719E+01, 3.7521134384E+00, 9.7408451662E-01],
	[4.2030000000E+04, 3.7689467851E+01, 5.2495184873E+00, 2.0216743127E+01, 3.7524828589E+00, 9.7409621365E-01],
	[4.2035000000E+04, 3.7697339539E+01, 5.2495569914E+00, 2.0224629673E+01, 3.7528521857E+00, 9.7410790481E-01],
	[4.2040000000E+04, 3.7705211934E+01, 5.2495954912E+00, 2.0232518355E+01, 3.7532214189E+00, 9.7411959011E-01],
	[4.2045000000E+04, 3.7713085037E+01, 5.2496339867E+00, 2.0240409175E+01, 3.7535905585E+00, 9.7413126956E-01],
	[4.2050000000E+04, 3.7720958847E+01, 5.2496724779E+00, 2.0248302134E+01, 3.7539596045E+00, 9.7414294315E-01],
	[4.2055000000E+04, 3.7728833365E+01, 5.2497109648E+00, 2.0256197230E+01, 3.7543285570E+00, 9.7415461090E-01],
	[4.2060000000E+04, 3.7736708590E+01, 5.2497494474E+00, 2.0264094465E+01, 3.7546974159E+00, 9.7416627279E-01],
	[4.2065000000E+04, 3.7744584523E+01, 5.2497879257E+00, 2.0271993839E+01, 3.7550661813E+00, 9.7417792884E-01],
	[4.2070000000E+04, 3.7752461163E+01, 5.2498263998E+00, 2.0279895353E+01, 3.7554348532E+00, 9.7418957905E-01],
	[4.2075000000E+04, 3.7760338510E+01, 5.2498648695E+00, 2.0287799006E+01, 3.7558034316E+00, 9.7420122343E-01],
	[4.2080000000E+04, 3.7768216564E+01, 5.2499033349E+00, 2.0295704799E+01, 3.7561719166E+00, 9.7421286197E-01],
	[4.2085000000E+04, 3.7776095326E+01, 5.2499417961E+00, 2.0303612732E+01, 3.7565403082E+00, 9.7422449467E-01],
	[4.2090000000E+04, 3.7783974795E+01, 5.2499802530E+00, 2.0311522805E+01, 3.7569086063E+00, 9.7423612155E-01],
	[4.2095000000E+04, 3.7791854972E+01, 5.2500187055E+00, 2.0319435020E+01, 3.7572768111E+00, 9.7424774261E-01],
	[4.2100000000E+04, 3.7799735855E+01, 5.2500571538E+00, 2.0327349376E+01, 3.7576449225E+00, 9.7425935785E-01],
	[4.2105000000E+04, 3.7807617446E+01, 5.2500955979E+00, 2.0335265873E+01, 3.7580129405E+00, 9.7427096726E-01],
	[4.2110000000E+04, 3.7815499744E+01, 5.2501340376E+00, 2.0343184513E+01, 3.7583808653E+00, 9.7428257086E-01],
	[4.2115000000E+04, 3.7823382749E+01, 5.2501724730E+00, 2.0351105294E+01, 3.7587486967E+00, 9.7429416866E-01],
	[4.2120000000E+04, 3.7831266462E+01, 5.2502109042E+00, 2.0359028218E+01, 3.7591164349E+00, 9.7430576064E-01],
	[4.2125000000E+04, 3.7839150881E+01, 5.2502493311E+00, 2.0366953285E+01, 3.7594840798E+00, 9.7431734682E-01],
	[4.2130000000E+04, 3.7847036008E+01, 5.2502877537E+00, 2.0374880495E+01, 3.7598516315E+00, 9.7432892719E-01],
	[4.2135000000E+04, 3.7854921842E+01, 5.2503261720E+00, 2.0382809848E+01, 3.7602190900E+00, 9.7434050177E-01],
	[4.2140000000E+04, 3.7862808383E+01, 5.2503645861E+00, 2.0390741346E+01, 3.7605864553E+00, 9.7435207055E-01],
	[4.2145000000E+04, 3.7870695630E+01, 5.2504029958E+00, 2.0398674987E+01, 3.7609537274E+00, 9.7436363354E-01],
	[4.2150000000E+04, 3.7878583585E+01, 5.2504414013E+00, 2.0406610773E+01, 3.7613209064E+00, 9.7437519075E-01],
	[4.2155000000E+04, 3.7886472247E+01, 5.2504798025E+00, 2.0414548704E+01, 3.7616879923E+00, 9.7438674216E-01],
	[4.2160000000E+04, 3.7894361616E+01, 5.2505181995E+00, 2.0422488780E+01, 3.7620549851E+00, 9.7439828780E-01],
	[4.2165000000E+04, 3.7902251692E+01, 5.2505565922E+00, 2.0430431001E+01, 3.7624218848E+00, 9.7440982765E-01],
	[4.2170000000E+04, 3.7910142475E+01, 5.2505949806E+00, 2.0438375368E+01, 3.7627886915E+00, 9.7442136173E-01],
	[4.2175000000E+04, 3.7918033965E+01, 5.2506333647E+00, 2.0446321882E+01, 3.7631554051E+00, 9.7443289004E-01],
	[4.2180000000E+04, 3.7925926162E+01, 5.2506717446E+00, 2.0454270541E+01, 3.7635220257E+00, 9.7444441258E-01],
	[4.2185000000E+04, 3.7933819065E+01, 5.2507101202E+00, 2.0462221348E+01, 3.7638885534E+00, 9.7445592935E-01],
	[4.2190000000E+04, 3.7941712676E+01, 5.2507484915E+00, 2.0470174301E+01, 3.7642549881E+00, 9.7446744036E-01],
	[4.2195000000E+04, 3.7949606993E+01, 5.2507868586E+00, 2.0478129402E+01, 3.7646213298E+00, 9.7447894561E-01],
	[4.2200000000E+04, 3.7957502017E+01, 5.2508252213E+00, 2.0486086650E+01, 3.7649875786E+00, 9.7449044511E-01],
	[4.2205000000E+04, 3.7965397748E+01, 5.2508635799E+00, 2.0494046047E+01, 3.7653537345E+00, 9.7450193885E-01],
	[4.2210000000E+04, 3.7973294186E+01, 5.2509019341E+00, 2.0502007592E+01, 3.7657197976E+00, 9.7451342684E-01],
	[4.2215000000E+04, 3.7981191331E+01, 5.2509402841E+00, 2.0509971286E+01, 3.7660857678E+00, 9.7452490908E-01],
	[4.2220000000E+04, 3.7989089182E+01, 5.2509786299E+00, 2.0517937128E+01, 3.7664516451E+00, 9.7453638558E-01],
	[4.2225000000E+04, 3.7996987740E+01, 5.2510169714E+00, 2.0525905121E+01, 3.7668174297E+00, 9.7454785634E-01],
	[4.2230000000E+04, 3.8004887005E+01, 5.2510553086E+00, 2.0533875262E+01, 3.7671831215E+00, 9.7455932137E-01],
	[4.2235000000E+04, 3.8012786976E+01, 5.2510936415E+00, 2.0541847554E+01, 3.7675487205E+00, 9.7457078066E-01],
	[4.2240000000E+04, 3.8020687654E+01, 5.2511319702E+00, 2.0549821996E+01, 3.7679142267E+00, 9.7458223422E-01],
	[4.2245000000E+04, 3.8028589039E+01, 5.2511702947E+00, 2.0557798589E+01, 3.7682796403E+00, 9.7459368205E-01],
	[4.2250000000E+04, 3.8036491130E+01, 5.2512086149E+00, 2.0565777332E+01, 3.7686449611E+00, 9.7460512416E-01],
	[4.2255000000E+04, 3.8044393928E+01, 5.2512469308E+00, 2.0573758227E+01, 3.7690101893E+00, 9.7461656055E-01],
	[4.2260000000E+04, 3.8052297433E+01, 5.2512852425E+00, 2.0581741274E+01, 3.7693753248E+00, 9.7462799122E-01],
	[4.2265000000E+04, 3.8060201644E+01, 5.2513235499E+00, 2.0589726473E+01, 3.7697403677E+00, 9.7463941617E-01],
	[4.2270000000E+04, 3.8068106562E+01, 5.2513618531E+00, 2.0597713823E+01, 3.7701053180E+00, 9.7465083542E-01],
	[4.2275000000E+04, 3.8076012186E+01, 5.2514001520E+00, 2.0605703327E+01, 3.7704701757E+00, 9.7466224896E-01],
	[4.2280000000E+04, 3.8083918517E+01, 5.2514384467E+00, 2.0613694983E+01, 3.7708349408E+00, 9.7467365679E-01],
	[4.2285000000E+04, 3.8091825554E+01, 5.2514767371E+00, 2.0621688793E+01, 3.7711996134E+00, 9.7468505892E-01],
	[4.2290000000E+04, 3.8099733297E+01, 5.2515150233E+00, 2.0629684756E+01, 3.7715641934E+00, 9.7469645535E-01],
	[4.2295000000E+04, 3.8107641748E+01, 5.2515533052E+00, 2.0637682873E+01, 3.7719286810E+00, 9.7470784609E-01],
	[4.2300000000E+04, 3.8115550904E+01, 5.2515915829E+00, 2.0645683145E+01, 3.7722930761E+00, 9.7471923113E-01],
	[4.2305000000E+04, 3.8123460767E+01, 5.2516298563E+00, 2.0653685570E+01, 3.7726573787E+00, 9.7473061049E-01],
	[4.2310000000E+04, 3.8131371336E+01, 5.2516681255E+00, 2.0661690151E+01, 3.7730215889E+00, 9.7474198416E-01],
	[4.2315000000E+04, 3.8139282612E+01, 5.2517063905E+00, 2.0669696887E+01, 3.7733857067E+00, 9.7475335215E-01],
	[4.2320000000E+04, 3.8147194594E+01, 5.2517446512E+00, 2.0677705779E+01, 3.7737497322E+00, 9.7476471446E-01],
	[4.2325000000E+04, 3.8155107282E+01, 5.2517829077E+00, 2.0685716826E+01, 3.7741136652E+00, 9.7477607109E-01],
	[4.2330000000E+04, 3.8163020677E+01, 5.2518211599E+00, 2.0693730029E+01, 3.7744775059E+00, 9.7478742205E-01],
	[4.2335000000E+04, 3.8170934778E+01, 5.2518594079E+00, 2.0701745389E+01, 3.7748412543E+00, 9.7479876734E-01],
	[4.2340000000E+04, 3.8178849585E+01, 5.2518976516E+00, 2.0709762906E+01, 3.7752049104E+00, 9.7481010697E-01],
	[4.2345000000E+04, 3.8186765099E+01, 5.2519358911E+00, 2.0717782580E+01, 3.7755684742E+00, 9.7482144093E-01],
	[4.2350000000E+04, 3.8194681318E+01, 5.2519741264E+00, 2.0725804412E+01, 3.7759319457E+00, 9.7483276923E-01],
	[4.2355000000E+04, 3.8202598244E+01, 5.2520123574E+00, 2.0733828401E+01, 3.7762953251E+00, 9.7484409188E-01],
	[4.2360000000E+04, 3.8210515876E+01, 5.2520505842E+00, 2.0741854548E+01, 3.7766586122E+00, 9.7485540887E-01],
	[4.2365000000E+04, 3.8218434214E+01, 5.2520888068E+00, 2.0749882854E+01, 3.7770218071E+00, 9.7486672021E-01],
	[4.2370000000E+04, 3.8226353259E+01, 5.2521270251E+00, 2.0757913319E+01, 3.7773849099E+00, 9.7487802591E-01],
	[4.2375000000E+04, 3.8234273009E+01, 5.2521652393E+00, 2.0765945943E+01, 3.7777479205E+00, 9.7488932596E-01],
	[4.2380000000E+04, 3.8242193466E+01, 5.2522034491E+00, 2.0773980726E+01, 3.7781108390E+00, 9.7490062037E-01],
	[4.2385000000E+04, 3.8250114628E+01, 5.2522416548E+00, 2.0782017669E+01, 3.7784736654E+00, 9.7491190914E-01],
	[4.2390000000E+04, 3.8258036497E+01, 5.2522798562E+00, 2.0790056772E+01, 3.7788363997E+00, 9.7492319228E-01],
	[4.2395000000E+04, 3.8265959072E+01, 5.2523180534E+00, 2.0798098035E+01, 3.7791990420E+00, 9.7493446978E-01],
	[4.2400000000E+04, 3.8273882353E+01, 5.2523562463E+00, 2.0806141459E+01, 3.7795615922E+00, 9.7494574166E-01],
	[4.2405000000E+04, 3.8281806339E+01, 5.2523944351E+00, 2.0814187044E+01, 3.7799240504E+00, 9.7495700792E-01],
	[4.2410000000E+04, 3.8289731032E+01, 5.2524326196E+00, 2.0822234791E+01, 3.7802864167E+00, 9.7496826855E-01],
	[4.2415000000E+04, 3.8297656431E+01, 5.2524707999E+00, 2.0830284699E+01, 3.7806486909E+00, 9.7497952356E-01],
	[4.2420000000E+04, 3.8305582535E+01, 5.2525089759E+00, 2.0838336770E+01, 3.7810108733E+00, 9.7499077296E-01],
	[4.2425000000E+04, 3.8313509346E+01, 5.2525471478E+00, 2.0846391002E+01, 3.7813729637E+00, 9.7500201675E-01],
	[4.2430000000E+04, 3.8321436862E+01, 5.2525853154E+00, 2.0854447398E+01, 3.7817349622E+00, 9.7501325492E-01],
	[4.2435000000E+04, 3.8329365085E+01, 5.2526234788E+00, 2.0862505956E+01, 3.7820968688E+00, 9.7502448750E-01],
	[4.2440000000E+04, 3.8337294013E+01, 5.2526616380E+00, 2.0870566678E+01, 3.7824586836E+00, 9.7503571447E-01],
	[4.2445000000E+04, 3.8345223647E+01, 5.2526997929E+00, 2.0878629563E+01, 3.7828204065E+00, 9.7504693583E-01],
	[4.2450000000E+04, 3.8353153986E+01, 5.2527379437E+00, 2.0886694613E+01, 3.7831820376E+00, 9.7505815161E-01],
	[4.2455000000E+04, 3.8361085032E+01, 5.2527760902E+00, 2.0894761826E+01, 3.7835435770E+00, 9.7506936179E-01],
	[4.2460000000E+04, 3.8369016783E+01, 5.2528142325E+00, 2.0902831205E+01, 3.7839050246E+00, 9.7508056638E-01],
	[4.2465000000E+04, 3.8376949240E+01, 5.2528523706E+00, 2.0910902748E+01, 3.7842663804E+00, 9.7509176538E-01],
	[4.2470000000E+04, 3.8384882403E+01, 5.2528905045E+00, 2.0918976457E+01, 3.7846276445E+00, 9.7510295880E-01],
	[4.2475000000E+04, 3.8392816272E+01, 5.2529286342E+00, 2.0927052331E+01, 3.7849888169E+00, 9.7511414664E-01],
	[4.2480000000E+04, 3.8400750846E+01, 5.2529667596E+00, 2.0935130371E+01, 3.7853498976E+00, 9.7512532890E-01],
	[4.2485000000E+04, 3.8408686126E+01, 5.2530048809E+00, 2.0943210577E+01, 3.7857108867E+00, 9.7513650559E-01],
	[4.2490000000E+04, 3.8416622111E+01, 5.2530429979E+00, 2.0951292950E+01, 3.7860717842E+00, 9.7514767671E-01],
	[4.2495000000E+04, 3.8424558803E+01, 5.2530811108E+00, 2.0959377490E+01, 3.7864325900E+00, 9.7515884226E-01],
	[4.2500000000E+04, 3.8432501768E+01, 5.2531198843E+00, 2.0967464197E+01, 3.7867937038E+00, 9.7517000224E-01],
	[4.2505000000E+04, 3.8440456848E+01, 5.2531600155E+00, 2.0975553072E+01, 3.7871555447E+00, 9.7518115666E-01],
	[4.2510000000E+04, 3.8448412639E+01, 5.2532001423E+00, 2.0983644115E+01, 3.7875172943E+00, 9.7519230553E-01],
	[4.2515000000E+04, 3.8456369140E+01, 5.2532402646E+00, 2.0991737326E+01, 3.7878789527E+00, 9.7520344884E-01],
	[4.2520000000E+04, 3.8464326352E+01, 5.2532803826E+00, 2.0999832705E+01, 3.7882405197E+00, 9.7521458660E-01],
	[4.2525000000E+04, 3.8472284274E+01, 5.2533204961E+00, 2.1007930253E+01, 3.7886019955E+00, 9.7522571880E-01],
	[4.2530000000E+04, 3.8480242907E+01, 5.2533606053E+00, 2.1016029971E+01, 3.7889633801E+00, 9.7523684547E-01],
	[4.2535000000E+04, 3.8488202250E+01, 5.2534007100E+00, 2.1024131858E+01, 3.7893246735E+00, 9.7524796659E-01],
	[4.2540000000E+04, 3.8496162304E+01, 5.2534408103E+00, 2.1032235914E+01, 3.7896858757E+00, 9.7525908217E-01],
	[4.2545000000E+04, 3.8504123069E+01, 5.2534809062E+00, 2.1040342141E+01, 3.7900469868E+00, 9.7527019221E-01],
	[4.2550000000E+04, 3.8512084543E+01, 5.2535209977E+00, 2.1048450539E+01, 3.7904080068E+00, 9.7528129672E-01],
	[4.2555000000E+04, 3.8520046728E+01, 5.2535610848E+00, 2.1056561107E+01, 3.7907689356E+00, 9.7529239571E-01],
	[4.2560000000E+04, 3.8528009624E+01, 5.2536011675E+00, 2.1064673847E+01, 3.7911297733E+00, 9.7530348916E-01],
	[4.2565000000E+04, 3.8535973230E+01, 5.2536412458E+00, 2.1072788758E+01, 3.7914905200E+00, 9.7531457709E-01],
	[4.2570000000E+04, 3.8543937546E+01, 5.2536813197E+00, 2.1080905841E+01, 3.7918511757E+00, 9.7532565950E-01],
	[4.2575000000E+04, 3.8551902573E+01, 5.2537213892E+00, 2.1089025095E+01, 3.7922117403E+00, 9.7533673639E-01],
	[4.2580000000E+04, 3.8559868310E+01, 5.2537614543E+00, 2.1097146523E+01, 3.7925722139E+00, 9.7534780777E-01],
	[4.2585000000E+04, 3.8567834757E+01, 5.2538015150E+00, 2.1105270123E+01, 3.7929325966E+00, 9.7535887363E-01],
	[4.2590000000E+04, 3.8575801914E+01, 5.2538415713E+00, 2.1113395896E+01, 3.7932928882E+00, 9.7536993398E-01],
	[4.2595000000E+04, 3.8583769782E+01, 5.2538816232E+00, 2.1121523843E+01, 3.7936530890E+00, 9.7538098883E-01],
	[4.2600000000E+04, 3.8591738360E+01, 5.2539216707E+00, 2.1129653963E+01, 3.7940131989E+00, 9.7539203816E-01],
	[4.2605000000E+04, 3.8599707648E+01, 5.2539617138E+00, 2.1137786258E+01, 3.7943732178E+00, 9.7540308200E-01],
	[4.2610000000E+04, 3.8607677646E+01, 5.2540017525E+00, 2.1145920727E+01, 3.7947331459E+00, 9.7541412033E-01],
	[4.2615000000E+04, 3.8615648355E+01, 5.2540417868E+00, 2.1154057370E+01, 3.7950929832E+00, 9.7542515317E-01],
	[4.2620000000E+04, 3.8623619774E+01, 5.2540818168E+00, 2.1162196189E+01, 3.7954527296E+00, 9.7543618051E-01],
	[4.2625000000E+04, 3.8631591902E+01, 5.2541218423E+00, 2.1170337183E+01, 3.7958123852E+00, 9.7544720236E-01],
	[4.2630000000E+04, 3.8639564741E+01, 5.2541618635E+00, 2.1178480353E+01, 3.7961719500E+00, 9.7545821871E-01],
	[4.2635000000E+04, 3.8647538290E+01, 5.2542018802E+00, 2.1186625699E+01, 3.7965314241E+00, 9.7546922958E-01],
	[4.2640000000E+04, 3.8655512549E+01, 5.2542418926E+00, 2.1194773221E+01, 3.7968908075E+00, 9.7548023497E-01],
	[4.2645000000E+04, 3.8663487518E+01, 5.2542819006E+00, 2.1202922920E+01, 3.7972501001E+00, 9.7549123488E-01],
	[4.2650000000E+04, 3.8671463197E+01, 5.2543219042E+00, 2.1211074796E+01, 3.7976093021E+00, 9.7550222930E-01],
	[4.2655000000E+04, 3.8679439587E+01, 5.2543619034E+00, 2.1219228849E+01, 3.7979684134E+00, 9.7551321825E-01],
	[4.2660000000E+04, 3.8687416686E+01, 5.2544018982E+00, 2.1227385080E+01, 3.7983274340E+00, 9.7552420173E-01],
	[4.2665000000E+04, 3.8695394495E+01, 5.2544418887E+00, 2.1235543489E+01, 3.7986863640E+00, 9.7553517973E-01],
	[4.2670000000E+04, 3.8703373014E+01, 5.2544818747E+00, 2.1243704076E+01, 3.7990452035E+00, 9.7554615227E-01],
	[4.2675000000E+04, 3.8711352243E+01, 5.2545218564E+00, 2.1251866842E+01, 3.7994039523E+00, 9.7555711934E-01],
	[4.2680000000E+04, 3.8719332182E+01, 5.2545618337E+00, 2.1260031787E+01, 3.7997626106E+00, 9.7556808095E-01],
	[4.2685000000E+04, 3.8727312831E+01, 5.2546018066E+00, 2.1268198911E+01, 3.8001211783E+00, 9.7557903709E-01],
	[4.2690000000E+04, 3.8735294189E+01, 5.2546417752E+00, 2.1276368215E+01, 3.8004796555E+00, 9.7558998778E-01],
	[4.2695000000E+04, 3.8743276258E+01, 5.2546817394E+00, 2.1284539699E+01, 3.8008380423E+00, 9.7560093302E-01],
	[4.2700000000E+04, 3.8751259036E+01, 5.2547216992E+00, 2.1292713363E+01, 3.8011963385E+00, 9.7561187280E-01],
	[4.2705000000E+04, 3.8759242524E+01, 5.2547616546E+00, 2.1300889208E+01, 3.8015545443E+00, 9.7562280713E-01],
	[4.2710000000E+04, 3.8767226722E+01, 5.2548016056E+00, 2.1309067233E+01, 3.8019126597E+00, 9.7563373601E-01],
	[4.2715000000E+04, 3.8775211630E+01, 5.2548415523E+00, 2.1317247440E+01, 3.8022706847E+00, 9.7564465945E-01],
	[4.2720000000E+04, 3.8783197247E+01, 5.2548814946E+00, 2.1325429828E+01, 3.8026286193E+00, 9.7565557745E-01],
	[4.2725000000E+04, 3.8791183574E+01, 5.2549214325E+00, 2.1333614399E+01, 3.8029864636E+00, 9.7566649001E-01],
	[4.2730000000E+04, 3.8799170611E+01, 5.2549613661E+00, 2.1341801151E+01, 3.8033442175E+00, 9.7567739714E-01],
	[4.2735000000E+04, 3.8807158358E+01, 5.2550012953E+00, 2.1349990086E+01, 3.8037018811E+00, 9.7568829883E-01],
	[4.2740000000E+04, 3.8815146814E+01, 5.2550412201E+00, 2.1358181204E+01, 3.8040594544E+00, 9.7569919508E-01],
	[4.2745000000E+04, 3.8823135980E+01, 5.2550811405E+00, 2.1366374506E+01, 3.8044169374E+00, 9.7571008591E-01],
	[4.2750000000E+04, 3.8831125856E+01, 5.2551210566E+00, 2.1374569990E+01, 3.8047743302E+00, 9.7572097132E-01],
	[4.2755000000E+04, 3.8839116441E+01, 5.2551609684E+00, 2.1382767659E+01, 3.8051316327E+00, 9.7573185130E-01],
	[4.2760000000E+04, 3.8847107735E+01, 5.2552008757E+00, 2.1390967512E+01, 3.8054888451E+00, 9.7574272586E-01],
	[4.2765000000E+04, 3.8855099740E+01, 5.2552407787E+00, 2.1399169549E+01, 3.8058459672E+00, 9.7575359500E-01],
	[4.2770000000E+04, 3.8863092454E+01, 5.2552806773E+00, 2.1407373771E+01, 3.8062029992E+00, 9.7576445873E-01],
	[4.2775000000E+04, 3.8871085877E+01, 5.2553205716E+00, 2.1415580179E+01, 3.8065599411E+00, 9.7577531705E-01],
	[4.2780000000E+04, 3.8879080010E+01, 5.2553604615E+00, 2.1423788771E+01, 3.8069167928E+00, 9.7578616995E-01],
	[4.2785000000E+04, 3.8887074852E+01, 5.2554003471E+00, 2.1431999550E+01, 3.8072735545E+00, 9.7579701745E-01],
	[4.2790000000E+04, 3.8895070404E+01, 5.2554402283E+00, 2.1440212515E+01, 3.8076302261E+00, 9.7580785955E-01],
	[4.2795000000E+04, 3.8903066665E+01, 5.2554801051E+00, 2.1448427666E+01, 3.8079868076E+00, 9.7581869624E-01],
	[4.2800000000E+04, 3.8911063636E+01, 5.2555199776E+00, 2.1456645004E+01, 3.8083432991E+00, 9.7582952754E-01],
	[4.2805000000E+04, 3.8919061316E+01, 5.2555598457E+00, 2.1464864529E+01, 3.8086997006E+00, 9.7584035343E-01],
	[4.2810000000E+04, 3.8927059706E+01, 5.2555997095E+00, 2.1473086242E+01, 3.8090560121E+00, 9.7585117394E-01],
	[4.2815000000E+04, 3.8935058805E+01, 5.2556395689E+00, 2.1481310143E+01, 3.8094122336E+00, 9.7586198905E-01],
	[4.2820000000E+04, 3.8943058613E+01, 5.2556794240E+00, 2.1489536231E+01, 3.8097683652E+00, 9.7587279878E-01],
	[4.2825000000E+04, 3.8951059130E+01, 5.2557192747E+00, 2.1497764508E+01, 3.8101244069E+00, 9.7588360311E-01],
	[4.2830000000E+04, 3.8959060357E+01, 5.2557591210E+00, 2.1505994974E+01, 3.8104803587E+00, 9.7589440207E-01],
	[4.2835000000E+04, 3.8967062293E+01, 5.2557989631E+00, 2.1514227629E+01, 3.8108362206E+00, 9.7590519565E-01],
	[4.2840000000E+04, 3.8975064939E+01, 5.2558388007E+00, 2.1522462473E+01, 3.8111919926E+00, 9.7591598384E-01],
	[4.2845000000E+04, 3.8983068294E+01, 5.2558786340E+00, 2.1530699507E+01, 3.8115476748E+00, 9.7592676667E-01],
	[4.2850000000E+04, 3.8991072358E+01, 5.2559184630E+00, 2.1538938731E+01, 3.8119032672E+00, 9.7593754412E-01],
	[4.2855000000E+04, 3.8999077131E+01, 5.2559582876E+00, 2.1547180145E+01, 3.8122587699E+00, 9.7594831620E-01],
	[4.2860000000E+04, 3.9007082613E+01, 5.2559981079E+00, 2.1555423751E+01, 3.8126141827E+00, 9.7595908291E-01],
	[4.2865000000E+04, 3.9015088804E+01, 5.2560379239E+00, 2.1563669547E+01, 3.8129695058E+00, 9.7596984426E-01],
	[4.2870000000E+04, 3.9023095705E+01, 5.2560777355E+00, 2.1571917534E+01, 3.8133247392E+00, 9.7598060025E-01],
	[4.2875000000E+04, 3.9031103315E+01, 5.2561175427E+00, 2.1580167714E+01, 3.8136798829E+00, 9.7599135088E-01],
	[4.2880000000E+04, 3.9039111634E+01, 5.2561573456E+00, 2.1588420085E+01, 3.8140349370E+00, 9.7600209615E-01],
	[4.2885000000E+04, 3.9047120662E+01, 5.2561971442E+00, 2.1596674648E+01, 3.8143899013E+00, 9.7601283607E-01],
	[4.2890000000E+04, 3.9055130399E+01, 5.2562369384E+00, 2.1604931405E+01, 3.8147447761E+00, 9.7602357064E-01],
	[4.2895000000E+04, 3.9063140845E+01, 5.2562767283E+00, 2.1613190354E+01, 3.8150995612E+00, 9.7603429986E-01],
	[4.2900000000E+04, 3.9071152000E+01, 5.2563165139E+00, 2.1621451497E+01, 3.8154542567E+00, 9.7604502373E-01],
	[4.2905000000E+04, 3.9079163864E+01, 5.2563562951E+00, 2.1629714833E+01, 3.8158088627E+00, 9.7605574227E-01],
	[4.2910000000E+04, 3.9087176437E+01, 5.2563960720E+00, 2.1637980363E+01, 3.8161633791E+00, 9.7606645546E-01],
	[4.2915000000E+04, 3.9095189719E+01, 5.2564358446E+00, 2.1646248088E+01, 3.8165178060E+00, 9.7607716331E-01],
	[4.2920000000E+04, 3.9103203710E+01, 5.2564756128E+00, 2.1654518007E+01, 3.8168721434E+00, 9.7608786583E-01],
	[4.2925000000E+04, 3.9111218410E+01, 5.2565153767E+00, 2.1662790121E+01, 3.8172263913E+00, 9.7609856301E-01],
	[4.2930000000E+04, 3.9119233819E+01, 5.2565551363E+00, 2.1671064431E+01, 3.8175805498E+00, 9.7610925487E-01],
	[4.2935000000E+04, 3.9127249937E+01, 5.2565948915E+00, 2.1679340936E+01, 3.8179346188E+00, 9.7611994140E-01],
	[4.2940000000E+04, 3.9135266764E+01, 5.2566346424E+00, 2.1687619637E+01, 3.8182885984E+00, 9.7613062260E-01],
	[4.2945000000E+04, 3.9143284299E+01, 5.2566743890E+00, 2.1695900534E+01, 3.8186424886E+00, 9.7614129849E-01],
	[4.2950000000E+04, 3.9151302544E+01, 5.2567141312E+00, 2.1704183628E+01, 3.8189962895E+00, 9.7615196905E-01],
	[4.2955000000E+04, 3.9159321497E+01, 5.2567538692E+00, 2.1712468919E+01, 3.8193500010E+00, 9.7616263430E-01],
	[4.2960000000E+04, 3.9167341159E+01, 5.2567936028E+00, 2.1720756407E+01, 3.8197036232E+00, 9.7617329423E-01],
	[4.2965000000E+04, 3.9175361530E+01, 5.2568333320E+00, 2.1729046092E+01, 3.8200571561E+00, 9.7618394886E-01],
	[4.2970000000E+04, 3.9183382609E+01, 5.2568730570E+00, 2.1737337976E+01, 3.8204105997E+00, 9.7619459817E-01],
	[4.2975000000E+04, 3.9191404397E+01, 5.2569127776E+00, 2.1745632058E+01, 3.8207639540E+00, 9.7620524218E-01],
	[4.2980000000E+04, 3.9199426894E+01, 5.2569524939E+00, 2.1753928338E+01, 3.8211172191E+00, 9.7621588089E-01],
	[4.2985000000E+04, 3.9207450100E+01, 5.2569922059E+00, 2.1762226817E+01, 3.8214703950E+00, 9.7622651429E-01],
	[4.2990000000E+04, 3.9215474014E+01, 5.2570319136E+00, 2.1770527496E+01, 3.8218234817E+00, 9.7623714240E-01],
	[4.2995000000E+04, 3.9223498637E+01, 5.2570716169E+00, 2.1778830374E+01, 3.8221764793E+00, 9.7624776521E-01],
	[4.3000000000E+04, 3.9231523969E+01, 5.2571113160E+00, 2.1787135451E+01, 3.8225293876E+00, 9.7625838273E-01],
	[4.3005000000E+04, 3.9239550009E+01, 5.2571510107E+00, 2.1795442729E+01, 3.8228822069E+00, 9.7626899496E-01],
	[4.3010000000E+04, 3.9247576758E+01, 5.2571907011E+00, 2.1803752208E+01, 3.8232349370E+00, 9.7627960191E-01],
	[4.3015000000E+04, 3.9255604215E+01, 5.2572303872E+00, 2.1812063887E+01, 3.8235875781E+00, 9.7629020357E-01],
	[4.3020000000E+04, 3.9263632381E+01, 5.2572700689E+00, 2.1820377768E+01, 3.8239401301E+00, 9.7630079994E-01],
	[4.3025000000E+04, 3.9271661255E+01, 5.2573097464E+00, 2.1828693850E+01, 3.8242925931E+00, 9.7631139104E-01],
	[4.3030000000E+04, 3.9279690838E+01, 5.2573494196E+00, 2.1837012133E+01, 3.8246449670E+00, 9.7632197686E-01],
	[4.3035000000E+04, 3.9287721130E+01, 5.2573890884E+00, 2.1845332619E+01, 3.8249972520E+00, 9.7633255741E-01],
	[4.3040000000E+04, 3.9295752130E+01, 5.2574287529E+00, 2.1853655308E+01, 3.8253494480E+00, 9.7634313269E-01],
	[4.3045000000E+04, 3.9303783838E+01, 5.2574684132E+00, 2.1861980199E+01, 3.8257015550E+00, 9.7635370270E-01],
	[4.3050000000E+04, 3.9311816255E+01, 5.2575080691E+00, 2.1870307293E+01, 3.8260535731E+00, 9.7636426744E-01],
	[4.3055000000E+04, 3.9319849380E+01, 5.2575477207E+00, 2.1878636591E+01, 3.8264055023E+00, 9.7637482692E-01],
	[4.3060000000E+04, 3.9327883214E+01, 5.2575873680E+00, 2.1886968093E+01, 3.8267573426E+00, 9.7638538114E-01],
	[4.3065000000E+04, 3.9335917756E+01, 5.2576270110E+00, 2.1895301799E+01, 3.8271090941E+00, 9.7639593010E-01],
	[4.3070000000E+04, 3.9343953006E+01, 5.2576666497E+00, 2.1903637709E+01, 3.8274607567E+00, 9.7640647381E-01],
	[4.3075000000E+04, 3.9351988965E+01, 5.2577062841E+00, 2.1911975824E+01, 3.8278123305E+00, 9.7641701226E-01],
	[4.3080000000E+04, 3.9360025632E+01, 5.2577459142E+00, 2.1920316144E+01, 3.8281638155E+00, 9.7642754547E-01],
	[4.3085000000E+04, 3.9368063007E+01, 5.2577855400E+00, 2.1928658669E+01, 3.8285152117E+00, 9.7643807343E-01],
	[4.3090000000E+04, 3.9376101091E+01, 5.2578251615E+00, 2.1937003400E+01, 3.8288665192E+00, 9.7644859614E-01],
	[4.3095000000E+04, 3.9384139883E+01, 5.2578647787E+00, 2.1945350337E+01, 3.8292177379E+00, 9.7645911361E-01],
	[4.3100000000E+04, 3.9392179383E+01, 5.2579043915E+00, 2.1953699481E+01, 3.8295688680E+00, 9.7646962584E-01],
	[4.3105000000E+04, 3.9400219591E+01, 5.2579440001E+00, 2.1962050831E+01, 3.8299199093E+00, 9.7648013284E-01],
	[4.3110000000E+04, 3.9408260508E+01, 5.2579836044E+00, 2.1970404389E+01, 3.8302708620E+00, 9.7649063460E-01],
	[4.3115000000E+04, 3.9416302133E+01, 5.2580232045E+00, 2.1978760154E+01, 3.8306217261E+00, 9.7650113113E-01],
	[4.3120000000E+04, 3.9424344465E+01, 5.2580628002E+00, 2.1987118126E+01, 3.8309725015E+00, 9.7651162243E-01],
	[4.3125000000E+04, 3.9432387506E+01, 5.2581023916E+00, 2.1995478307E+01, 3.8313231883E+00, 9.7652210850E-01],
	[4.3130000000E+04, 3.9440431256E+01, 5.2581419787E+00, 2.2003840695E+01, 3.8316737865E+00, 9.7653258936E-01],
	[4.3135000000E+04, 3.9448475713E+01, 5.2581815616E+00, 2.2012205293E+01, 3.8320242962E+00, 9.7654306499E-01],
	[4.3140000000E+04, 3.9456520878E+01, 5.2582211401E+00, 2.2020572100E+01, 3.8323747174E+00, 9.7655353540E-01],
	[4.3145000000E+04, 3.9464566751E+01, 5.2582607144E+00, 2.2028941115E+01, 3.8327250500E+00, 9.7656400060E-01],
	[4.3150000000E+04, 3.9472613333E+01, 5.2583002843E+00, 2.2037312341E+01, 3.8330752942E+00, 9.7657446059E-01],
	[4.3155000000E+04, 3.9480660622E+01, 5.2583398500E+00, 2.2045685777E+01, 3.8334254499E+00, 9.7658491536E-01],
	[4.3160000000E+04, 3.9488708620E+01, 5.2583794114E+00, 2.2054061422E+01, 3.8337755172E+00, 9.7659536493E-01],
	[4.3165000000E+04, 3.9496757325E+01, 5.2584189685E+00, 2.2062439279E+01, 3.8341254960E+00, 9.7660580929E-01],
	[4.3170000000E+04, 3.9504806738E+01, 5.2584585214E+00, 2.2070819347E+01, 3.8344753864E+00, 9.7661624846E-01],
	[4.3175000000E+04, 3.9512856860E+01, 5.2584980699E+00, 2.2079201625E+01, 3.8348251885E+00, 9.7662668242E-01],
	[4.3180000000E+04, 3.9520907689E+01, 5.2585376142E+00, 2.2087586116E+01, 3.8351749022E+00, 9.7663711118E-01],
	[4.3185000000E+04, 3.9528967557E+01, 5.2585781350E+00, 2.2095972818E+01, 3.8355251278E+00, 9.7664753476E-01],
	[4.3190000000E+04, 3.9537036640E+01, 5.2586196526E+00, 2.2104361733E+01, 3.8358758779E+00, 9.7665795314E-01],
	[4.3195000000E+04, 3.9545106436E+01, 5.2586611657E+00, 2.2112752860E+01, 3.8362265400E+00, 9.7666836633E-01],
	[4.3200000000E+04, 3.9553176945E+01, 5.2587026743E+00, 2.2121146200E+01, 3.8365771140E+00, 9.7667877433E-01],
	[4.3205000000E+04, 3.9561248166E+01, 5.2587441784E+00, 2.2129541754E+01, 3.8369276000E+00, 9.7668917715E-01],
	[4.3210000000E+04, 3.9569320100E+01, 5.2587856781E+00, 2.2137939521E+01, 3.8372779980E+00, 9.7669957480E-01],
	[4.3215000000E+04, 3.9577392747E+01, 5.2588271732E+00, 2.2146339502E+01, 3.8376283080E+00, 9.7670996726E-01],
	[4.3220000000E+04, 3.9585466106E+01, 5.2588686640E+00, 2.2154741697E+01, 3.8379785301E+00, 9.7672035455E-01],
	[4.3225000000E+04, 3.9593540178E+01, 5.2589101502E+00, 2.2163146107E+01, 3.8383286642E+00, 9.7673073666E-01],
	[4.3230000000E+04, 3.9601614963E+01, 5.2589516320E+00, 2.2171552732E+01, 3.8386787104E+00, 9.7674111361E-01],
	[4.3235000000E+04, 3.9609690460E+01, 5.2589931093E+00, 2.2179961572E+01, 3.8390286687E+00, 9.7675148538E-01],
	[4.3240000000E+04, 3.9617766670E+01, 5.2590345821E+00, 2.2188372627E+01, 3.8393785392E+00, 9.7676185199E-01],
	[4.3245000000E+04, 3.9625843592E+01, 5.2590760504E+00, 2.2196785898E+01, 3.8397283218E+00, 9.7677221344E-01],
	[4.3250000000E+04, 3.9633921227E+01, 5.2591175143E+00, 2.2205201386E+01, 3.8400780165E+00, 9.7678256973E-01],
	[4.3255000000E+04, 3.9641999575E+01, 5.2591589737E+00, 2.2213619090E+01, 3.8404276235E+00, 9.7679292087E-01],
	[4.3260000000E+04, 3.9650078635E+01, 5.2592004287E+00, 2.2222039011E+01, 3.8407771426E+00, 9.7680326684E-01],
	[4.3265000000E+04, 3.9658158408E+01, 5.2592418792E+00, 2.2230461149E+01, 3.8411265740E+00, 9.7681360767E-01],
	[4.3270000000E+04, 3.9666238893E+01, 5.2592833252E+00, 2.2238885505E+01, 3.8414759177E+00, 9.7682394335E-01],
	[4.3275000000E+04, 3.9674320091E+01, 5.2593247668E+00, 2.2247312078E+01, 3.8418251736E+00, 9.7683427388E-01],
	[4.3280000000E+04, 3.9682402001E+01, 5.2593662039E+00, 2.2255740870E+01, 3.8421743419E+00, 9.7684459927E-01],
	[4.3285000000E+04, 3.9690484623E+01, 5.2594076365E+00, 2.2264171880E+01, 3.8425234225E+00, 9.7685491952E-01],
	[4.3290000000E+04, 3.9698567958E+01, 5.2594490647E+00, 2.2272605109E+01, 3.8428724154E+00, 9.7686523462E-01],
	[4.3295000000E+04, 3.9706652005E+01, 5.2594904885E+00, 2.2281040558E+01, 3.8432213207E+00, 9.7687554460E-01],
	[4.3300000000E+04, 3.9714736765E+01, 5.2595319077E+00, 2.2289478225E+01, 3.8435701383E+00, 9.7688584944E-01],
	[4.3305000000E+04, 3.9722822237E+01, 5.2595733225E+00, 2.2297918113E+01, 3.8439188684E+00, 9.7689614914E-01],
	[4.3310000000E+04, 3.9730908421E+01, 5.2596147329E+00, 2.2306360220E+01, 3.8442675109E+00, 9.7690644372E-01],
	[4.3315000000E+04, 3.9738995318E+01, 5.2596561388E+00, 2.2314804548E+01, 3.8446160659E+00, 9.7691673318E-01],
	[4.3320000000E+04, 3.9747082927E+01, 5.2596975403E+00, 2.2323251097E+01, 3.8449645334E+00, 9.7692701751E-01],
	[4.3325000000E+04, 3.9755171248E+01, 5.2597389373E+00, 2.2331699867E+01, 3.8453129133E+00, 9.7693729673E-01],
	[4.3330000000E+04, 3.9763260281E+01, 5.2597803298E+00, 2.2340150859E+01, 3.8456612058E+00, 9.7694757082E-01],
	[4.3335000000E+04, 3.9771350027E+01, 5.2598217179E+00, 2.2348604072E+01, 3.8460094108E+00, 9.7695783980E-01],
	[4.3340000000E+04, 3.9779440485E+01, 5.2598631015E+00, 2.2357059507E+01, 3.8463575284E+00, 9.7696810367E-01],
	[4.3345000000E+04, 3.9787531655E+01, 5.2599044807E+00, 2.2365517165E+01, 3.8467055585E+00, 9.7697836243E-01],
	[4.3350000000E+04, 3.9795623537E+01, 5.2599458555E+00, 2.2373977045E+01, 3.8470535013E+00, 9.7698861608E-01],
	[4.3355000000E+04, 3.9803716132E+01, 5.2599872258E+00, 2.2382439149E+01, 3.8474013567E+00, 9.7699886463E-01],
	[4.3360000000E+04, 3.9811809438E+01, 5.2600285917E+00, 2.2390903476E+01, 3.8477491248E+00, 9.7700910808E-01],
	[4.3365000000E+04, 3.9819903457E+01, 5.2600699531E+00, 2.2399370027E+01, 3.8480968055E+00, 9.7701934643E-01],
	[4.3370000000E+04, 3.9827998188E+01, 5.2601113100E+00, 2.2407838801E+01, 3.8484443989E+00, 9.7702957968E-01],
	[4.3375000000E+04, 3.9836093630E+01, 5.2601526626E+00, 2.2416309800E+01, 3.8487919051E+00, 9.7703980784E-01],
	[4.3380000000E+04, 3.9844189785E+01, 5.2601940107E+00, 2.2424783024E+01, 3.8491393239E+00, 9.7705003090E-01],
	[4.3385000000E+04, 3.9852286652E+01, 5.2602353543E+00, 2.2433258473E+01, 3.8494866556E+00, 9.7706024888E-01],
	[4.3390000000E+04, 3.9860384231E+01, 5.2602766935E+00, 2.2441736148E+01, 3.8498339000E+00, 9.7707046178E-01],
	[4.3395000000E+04, 3.9868482522E+01, 5.2603180283E+00, 2.2450216048E+01, 3.8501810572E+00, 9.7708066959E-01],
	[4.3400000000E+04, 3.9876581525E+01, 5.2603593586E+00, 2.2458698174E+01, 3.8505281273E+00, 9.7709087232E-01],
	[4.3405000000E+04, 3.9884681240E+01, 5.2604006845E+00, 2.2467182526E+01, 3.8508751102E+00, 9.7710106997E-01],
	[4.3410000000E+04, 3.9892781667E+01, 5.2604420060E+00, 2.2475669105E+01, 3.8512220059E+00, 9.7711126255E-01],
	[4.3415000000E+04, 3.9900882805E+01, 5.2604833230E+00, 2.2484157911E+01, 3.8515688146E+00, 9.7712145005E-01],
	[4.3420000000E+04, 3.9908984656E+01, 5.2605246356E+00, 2.2492648945E+01, 3.8519155362E+00, 9.7713163249E-01],
	[4.3425000000E+04, 3.9917087219E+01, 5.2605659437E+00, 2.2501142206E+01, 3.8522621707E+00, 9.7714180985E-01],
	[4.3430000000E+04, 3.9925190493E+01, 5.2606072474E+00, 2.2509637695E+01, 3.8526087182E+00, 9.7715198216E-01],
	[4.3435000000E+04, 3.9933294479E+01, 5.2606485467E+00, 2.2518135412E+01, 3.8529551786E+00, 9.7716214940E-01],
	[4.3440000000E+04, 3.9941399177E+01, 5.2606898416E+00, 2.2526635358E+01, 3.8533015521E+00, 9.7717231158E-01],
	[4.3445000000E+04, 3.9949504587E+01, 5.2607311320E+00, 2.2535137533E+01, 3.8536478385E+00, 9.7718246870E-01],
	[4.3450000000E+04, 3.9957610709E+01, 5.2607724181E+00, 2.2543641938E+01, 3.8539940380E+00, 9.7719262077E-01],
	[4.3455000000E+04, 3.9965717542E+01, 5.2608136996E+00, 2.2552148572E+01, 3.8543401506E+00, 9.7720276779E-01],
	[4.3460000000E+04, 3.9973825087E+01, 5.2608549768E+00, 2.2560657436E+01, 3.8546861763E+00, 9.7721290976E-01],
	[4.3465000000E+04, 3.9981933344E+01, 5.2608962495E+00, 2.2569168530E+01, 3.8550321151E+00, 9.7722304669E-01],
	[4.3470000000E+04, 3.9990042313E+01, 5.2609375178E+00, 2.2577681855E+01, 3.8553779670E+00, 9.7723317857E-01],
	[4.3475000000E+04, 3.9998151993E+01, 5.2609787817E+00, 2.2586197410E+01, 3.8557237320E+00, 9.7724330541E-01],
	[4.3480000000E+04, 4.0006262385E+01, 5.2610200412E+00, 2.2594715198E+01, 3.8560694103E+00, 9.7725342721E-01],
	[4.3485000000E+04, 4.0014373489E+01, 5.2610612962E+00, 2.2603235216E+01, 3.8564150017E+00, 9.7726354398E-01],
	[4.3490000000E+04, 4.0022485304E+01, 5.2611025468E+00, 2.2611757467E+01, 3.8567605064E+00, 9.7727365571E-01],
	[4.3495000000E+04, 4.0030597831E+01, 5.2611437930E+00, 2.2620281950E+01, 3.8571059243E+00, 9.7728376241E-01],
	[4.3500000000E+04, 4.0038711069E+01, 5.2611850348E+00, 2.2628808665E+01, 3.8574512554E+00, 9.7729386408E-01],
	[4.3505000000E+04, 4.0046825019E+01, 5.2612262722E+00, 2.2637337613E+01, 3.8577964999E+00, 9.7730396073E-01],
	[4.3510000000E+04, 4.0054939681E+01, 5.2612675052E+00, 2.2645868795E+01, 3.8581416576E+00, 9.7731405236E-01],
	[4.3515000000E+04, 4.0063055054E+01, 5.2613087337E+00, 2.2654402210E+01, 3.8584867287E+00, 9.7732413897E-01],
	[4.3520000000E+04, 4.0071171139E+01, 5.2613499578E+00, 2.2662937859E+01, 3.8588317131E+00, 9.7733422056E-01],
	[4.3525000000E+04, 4.0079287935E+01, 5.2613911775E+00, 2.2671475742E+01, 3.8591766109E+00, 9.7734429713E-01],
	[4.3530000000E+04, 4.0087405442E+01, 5.2614323928E+00, 2.2680015860E+01, 3.8595214221E+00, 9.7735436869E-01],
	[4.3535000000E+04, 4.0095523661E+01, 5.2614736037E+00, 2.2688558213E+01, 3.8598661467E+00, 9.7736443525E-01],
	[4.3540000000E+04, 4.0103642592E+01, 5.2615148102E+00, 2.2697102801E+01, 3.8602107847E+00, 9.7737449679E-01],
	[4.3545000000E+04, 4.0111762234E+01, 5.2615560123E+00, 2.2705649624E+01, 3.8605553362E+00, 9.7738455333E-01],
	[4.3550000000E+04, 4.0119882587E+01, 5.2615972099E+00, 2.2714198683E+01, 3.8608998012E+00, 9.7739460487E-01],
	[4.3555000000E+04, 4.0128003652E+01, 5.2616384032E+00, 2.2722749979E+01, 3.8612441797E+00, 9.7740465142E-01],
	[4.3560000000E+04, 4.0136125428E+01, 5.2616795920E+00, 2.2731303511E+01, 3.8615884717E+00, 9.7741469296E-01],
	[4.3565000000E+04, 4.0144247915E+01, 5.2617207765E+00, 2.2739859280E+01, 3.8619326772E+00, 9.7742472951E-01],
	[4.3570000000E+04, 4.0152371114E+01, 5.2617619565E+00, 2.2748417286E+01, 3.8622767963E+00, 9.7743476107E-01],
	[4.3575000000E+04, 4.0160495024E+01, 5.2618031321E+00, 2.2756977529E+01, 3.8626208291E+00, 9.7744478764E-01],
	[4.3580000000E+04, 4.0168619645E+01, 5.2618443034E+00, 2.2765540010E+01, 3.8629647754E+00, 9.7745480923E-01],
	[4.3585000000E+04, 4.0176744977E+01, 5.2618854702E+00, 2.2774104730E+01, 3.8633086353E+00, 9.7746482583E-01],
	[4.3590000000E+04, 4.0184871021E+01, 5.2619266326E+00, 2.2782671688E+01, 3.8636524089E+00, 9.7747483745E-01],
	[4.3595000000E+04, 4.0192997776E+01, 5.2619677906E+00, 2.2791240885E+01, 3.8639960962E+00, 9.7748484410E-01],
	[4.3600000000E+04, 4.0201125242E+01, 5.2620089443E+00, 2.2799812321E+01, 3.8643396972E+00, 9.7749484577E-01],
	[4.3605000000E+04, 4.0209253420E+01, 5.2620500935E+00, 2.2808385996E+01, 3.8646832119E+00, 9.7750484246E-01],
	[4.3610000000E+04, 4.0217382308E+01, 5.2620912384E+00, 2.2816961911E+01, 3.8650266403E+00, 9.7751483419E-01],
	[4.3615000000E+04, 4.0225511908E+01, 5.2621323788E+00, 2.2825540066E+01, 3.8653699825E+00, 9.7752482094E-01],
	[4.3620000000E+04, 4.0233642219E+01, 5.2621735148E+00, 2.2834120462E+01, 3.8657132385E+00, 9.7753480274E-01],
	[4.3625000000E+04, 4.0241773241E+01, 5.2622146465E+00, 2.2842703099E+01, 3.8660564083E+00, 9.7754477957E-01],
	[4.3630000000E+04, 4.0249904974E+01, 5.2622557738E+00, 2.2851287976E+01, 3.8663994919E+00, 9.7755475144E-01],
	[4.3635000000E+04, 4.0258037418E+01, 5.2622968966E+00, 2.2859875095E+01, 3.8667424894E+00, 9.7756471835E-01],
	[4.3640000000E+04, 4.0266170573E+01, 5.2623380151E+00, 2.2868464456E+01, 3.8670854007E+00, 9.7757468031E-01],
	[4.3645000000E+04, 4.0274304439E+01, 5.2623791292E+00, 2.2877056059E+01, 3.8674282260E+00, 9.7758463732E-01],
	[4.3650000000E+04, 4.0282439016E+01, 5.2624202389E+00, 2.2885649904E+01, 3.8677709651E+00, 9.7759458937E-01],
	[4.3655000000E+04, 4.0290574305E+01, 5.2624613442E+00, 2.2894245993E+01, 3.8681136182E+00, 9.7760453649E-01],
	[4.3660000000E+04, 4.0298710304E+01, 5.2625024452E+00, 2.2902844324E+01, 3.8684561853E+00, 9.7761447865E-01],
	[4.3665000000E+04, 4.0306847014E+01, 5.2625435417E+00, 2.2911444898E+01, 3.8687986663E+00, 9.7762441588E-01],
	[4.3670000000E+04, 4.0314984435E+01, 5.2625846339E+00, 2.2920047717E+01, 3.8691410613E+00, 9.7763434816E-01],
	[4.3675000000E+04, 4.0323122567E+01, 5.2626257216E+00, 2.2928652779E+01, 3.8694833704E+00, 9.7764427551E-01],
	[4.3680000000E+04, 4.0331261410E+01, 5.2626668050E+00, 2.2937260086E+01, 3.8698255935E+00, 9.7765419793E-01],
	[4.3685000000E+04, 4.0339400963E+01, 5.2627078840E+00, 2.2945869637E+01, 3.8701677307E+00, 9.7766411542E-01],
	[4.3690000000E+04, 4.0347541228E+01, 5.2627489587E+00, 2.2954481434E+01, 3.8705097819E+00, 9.7767402797E-01],
	[4.3695000000E+04, 4.0355682203E+01, 5.2627900289E+00, 2.2963095475E+01, 3.8708517473E+00, 9.7768393560E-01],
	[4.3700000000E+04, 4.0363823890E+01, 5.2628310948E+00, 2.2971711763E+01, 3.8711936268E+00, 9.7769383831E-01],
	[4.3705000000E+04, 4.0371966287E+01, 5.2628721563E+00, 2.2980330297E+01, 3.8715354205E+00, 9.7770373610E-01],
	[4.3710000000E+04, 4.0380109394E+01, 5.2629132134E+00, 2.2988951077E+01, 3.8718771283E+00, 9.7771362897E-01],
	[4.3715000000E+04, 4.0388253213E+01, 5.2629542661E+00, 2.2997574103E+01, 3.8722187504E+00, 9.7772351692E-01],
	[4.3720000000E+04, 4.0396397742E+01, 5.2629953145E+00, 2.3006199377E+01, 3.8725602866E+00, 9.7773339996E-01],
	[4.3725000000E+04, 4.0404542982E+01, 5.2630363585E+00, 2.3014826898E+01, 3.8729017371E+00, 9.7774327809E-01],
	[4.3730000000E+04, 4.0412688933E+01, 5.2630773981E+00, 2.3023456667E+01, 3.8732431019E+00, 9.7775315131E-01],
	[4.3735000000E+04, 4.0420835594E+01, 5.2631184333E+00, 2.3032088683E+01, 3.8735843809E+00, 9.7776301963E-01],
	[4.3740000000E+04, 4.0428982967E+01, 5.2631594642E+00, 2.3040722948E+01, 3.8739255743E+00, 9.7777288305E-01],
	[4.3745000000E+04, 4.0437131049E+01, 5.2632004907E+00, 2.3049359462E+01, 3.8742666820E+00, 9.7778274156E-01],
	[4.3750000000E+04, 4.0445279843E+01, 5.2632415128E+00, 2.3057998224E+01, 3.8746077040E+00, 9.7779259518E-01],
	[4.3755000000E+04, 4.0453429347E+01, 5.2632825306E+00, 2.3066639236E+01, 3.8749486404E+00, 9.7780244390E-01],
	[4.3760000000E+04, 4.0461579561E+01, 5.2633235440E+00, 2.3075282498E+01, 3.8752894912E+00, 9.7781228773E-01],
	[4.3765000000E+04, 4.0469730486E+01, 5.2633645530E+00, 2.3083928009E+01, 3.8756302564E+00, 9.7782212668E-01],
	[4.3770000000E+04, 4.0477882122E+01, 5.2634055577E+00, 2.3092575771E+01, 3.8759709361E+00, 9.7783196073E-01],
	[4.3775000000E+04, 4.0486034468E+01, 5.2634465580E+00, 2.3101225784E+01, 3.8763115302E+00, 9.7784178990E-01],
	[4.3780000000E+04, 4.0494187525E+01, 5.2634875540E+00, 2.3109878047E+01, 3.8766520388E+00, 9.7785161419E-01],
	[4.3785000000E+04, 4.0502341292E+01, 5.2635285455E+00, 2.3118532562E+01, 3.8769924619E+00, 9.7786143360E-01],
	[4.3790000000E+04, 4.0510495770E+01, 5.2635695327E+00, 2.3127189328E+01, 3.8773327995E+00, 9.7787124813E-01],
	[4.3795000000E+04, 4.0518650958E+01, 5.2636105156E+00, 2.3135848346E+01, 3.8776730517E+00, 9.7788105779E-01],
	[4.3800000000E+04, 4.0526806856E+01, 5.2636514941E+00, 2.3144509617E+01, 3.8780132184E+00, 9.7789086258E-01],
	[4.3805000000E+04, 4.0534963465E+01, 5.2636924682E+00, 2.3153173140E+01, 3.8783532997E+00, 9.7790066250E-01],
	[4.3810000000E+04, 4.0543120785E+01, 5.2637334380E+00, 2.3161838916E+01, 3.8786932957E+00, 9.7791045755E-01],
	[4.3815000000E+04, 4.0551278814E+01, 5.2637744034E+00, 2.3170506945E+01, 3.8790332063E+00, 9.7792024774E-01],
	[4.3820000000E+04, 4.0559437554E+01, 5.2638153645E+00, 2.3179177228E+01, 3.8793730315E+00, 9.7793003307E-01],
	[4.3825000000E+04, 4.0567597005E+01, 5.2638563212E+00, 2.3187849765E+01, 3.8797127714E+00, 9.7793981354E-01],
	[4.3830000000E+04, 4.0575757166E+01, 5.2638972736E+00, 2.3196524556E+01, 3.8800524260E+00, 9.7794958915E-01],
	[4.3835000000E+04, 4.0583918037E+01, 5.2639382216E+00, 2.3205201601E+01, 3.8803919953E+00, 9.7795935991E-01],
	[4.3840000000E+04, 4.0592079618E+01, 5.2639791652E+00, 2.3213880902E+01, 3.8807314794E+00, 9.7796912583E-01],
	[4.3845000000E+04, 4.0600241910E+01, 5.2640201045E+00, 2.3222562457E+01, 3.8810708782E+00, 9.7797888689E-01],
	[4.3850000000E+04, 4.0608404911E+01, 5.2640610395E+00, 2.3231246269E+01, 3.8814101918E+00, 9.7798864310E-01],
	[4.3855000000E+04, 4.0616568623E+01, 5.2641019701E+00, 2.3239932336E+01, 3.8817494202E+00, 9.7799839448E-01],
	[4.3860000000E+04, 4.0624733046E+01, 5.2641428963E+00, 2.3248620659E+01, 3.8820885635E+00, 9.7800814101E-01],
	[4.3865000000E+04, 4.0632898178E+01, 5.2641838182E+00, 2.3257311239E+01, 3.8824276215E+00, 9.7801788271E-01],
	[4.3870000000E+04, 4.0641064021E+01, 5.2642247358E+00, 2.3266004076E+01, 3.8827665945E+00, 9.7802761957E-01],
	[4.3875000000E+04, 4.0649230573E+01, 5.2642656490E+00, 2.3274699169E+01, 3.8831054824E+00, 9.7803735160E-01],
	[4.3880000000E+04, 4.0657405495E+01, 5.2643074473E+00, 2.3283396521E+01, 3.8834448390E+00, 9.7804707879E-01],
	[4.3885000000E+04, 4.0665590160E+01, 5.2643502898E+00, 2.3292096130E+01, 3.8837847639E+00, 9.7805680116E-01],
	[4.3890000000E+04, 4.0673775540E+01, 5.2643931278E+00, 2.3300797997E+01, 3.8841246039E+00, 9.7806651871E-01],
	[4.3895000000E+04, 4.0681961635E+01, 5.2644359612E+00, 2.3309502123E+01, 3.8844643590E+00, 9.7807623143E-01],
	[4.3900000000E+04, 4.0690148445E+01, 5.2644787901E+00, 2.3318208508E+01, 3.8848040294E+00, 9.7808593934E-01],
	[4.3905000000E+04, 4.0698335970E+01, 5.2645216145E+00, 2.3326917152E+01, 3.8851436150E+00, 9.7809564242E-01],
	[4.3910000000E+04, 4.0706524209E+01, 5.2645644343E+00, 2.3335628056E+01, 3.8854831159E+00, 9.7810534070E-01],
	[4.3915000000E+04, 4.0714713164E+01, 5.2646072497E+00, 2.3344341219E+01, 3.8858225320E+00, 9.7811503416E-01],
	[4.3920000000E+04, 4.0722902833E+01, 5.2646500605E+00, 2.3353056642E+01, 3.8861618635E+00, 9.7812472281E-01],
	[4.3925000000E+04, 4.0731093217E+01, 5.2646928667E+00, 2.3361774326E+01, 3.8865011102E+00, 9.7813440665E-01],
	[4.3930000000E+04, 4.0739284315E+01, 5.2647356685E+00, 2.3370494271E+01, 3.8868402723E+00, 9.7814408569E-01],
	[4.3935000000E+04, 4.0747476129E+01, 5.2647784657E+00, 2.3379216477E+01, 3.8871793497E+00, 9.7815375993E-01],
	[4.3940000000E+04, 4.0755668657E+01, 5.2648212584E+00, 2.3387940944E+01, 3.8875183426E+00, 9.7816342937E-01],
	[4.3945000000E+04, 4.0763861900E+01, 5.2648640466E+00, 2.3396667673E+01, 3.8878572508E+00, 9.7817309401E-01],
	[4.3950000000E+04, 4.0772055857E+01, 5.2649068303E+00, 2.3405396664E+01, 3.8881960744E+00, 9.7818275386E-01],
	[4.3955000000E+04, 4.0780250529E+01, 5.2649496094E+00, 2.3414127918E+01, 3.8885348135E+00, 9.7819240892E-01],
	[4.3960000000E+04, 4.0788445916E+01, 5.2649923840E+00, 2.3422861434E+01, 3.8888734681E+00, 9.7820205918E-01],
	[4.3965000000E+04, 4.0796642017E+01, 5.2650351541E+00, 2.3431597214E+01, 3.8892120381E+00, 9.7821170467E-01],
	[4.3970000000E+04, 4.0804838833E+01, 5.2650779197E+00, 2.3440335257E+01, 3.8895505237E+00, 9.7822134536E-01],
	[4.3975000000E+04, 4.0813036363E+01, 5.2651206808E+00, 2.3449075563E+01, 3.8898889248E+00, 9.7823098128E-01],
	[4.3980000000E+04, 4.0821234608E+01, 5.2651634373E+00, 2.3457818134E+01, 3.8902272414E+00, 9.7824061242E-01],
	[4.3985000000E+04, 4.0829433568E+01, 5.2652061894E+00, 2.3466562969E+01, 3.8905654736E+00, 9.7825023878E-01],
	[4.3990000000E+04, 4.0837633242E+01, 5.2652489369E+00, 2.3475310069E+01, 3.8909036215E+00, 9.7825986037E-01],
	[4.3995000000E+04, 4.0845833631E+01, 5.2652916799E+00, 2.3484059434E+01, 3.8912416849E+00, 9.7826947719E-01],
	[4.4000000000E+04, 4.0854034734E+01, 5.2653344184E+00, 2.3492811065E+01, 3.8915796640E+00, 9.7827908924E-01],
	[4.4005000000E+04, 4.0862236551E+01, 5.2653771524E+00, 2.3501564961E+01, 3.8919175587E+00, 9.7828869653E-01],
	[4.4010000000E+04, 4.0870439083E+01, 5.2654198819E+00, 2.3510321123E+01, 3.8922553691E+00, 9.7829829905E-01],
	[4.4015000000E+04, 4.0878642330E+01, 5.2654626069E+00, 2.3519079552E+01, 3.8925930952E+00, 9.7830789681E-01],
	[4.4020000000E+04, 4.0886846290E+01, 5.2655053274E+00, 2.3527840247E+01, 3.8929307370E+00, 9.7831748981E-01],
	[4.4025000000E+04, 4.0895050966E+01, 5.2655480434E+00, 2.3536603210E+01, 3.8932682946E+00, 9.7832707806E-01],
	[4.4030000000E+04, 4.0903256355E+01, 5.2655907548E+00, 2.3545368440E+01, 3.8936057680E+00, 9.7833666155E-01],
	[4.4035000000E+04, 4.0911462459E+01, 5.2656334618E+00, 2.3554135937E+01, 3.8939431571E+00, 9.7834624029E-01],
	[4.4040000000E+04, 4.0919669277E+01, 5.2656761643E+00, 2.3562905703E+01, 3.8942804621E+00, 9.7835581429E-01],
	[4.4045000000E+04, 4.0927876810E+01, 5.2657188622E+00, 2.3571677737E+01, 3.8946176829E+00, 9.7836538354E-01],
	[4.4050000000E+04, 4.0936085057E+01, 5.2657615557E+00, 2.3580452039E+01, 3.8949548195E+00, 9.7837494805E-01],
	[4.4055000000E+04, 4.0944294018E+01, 5.2658042446E+00, 2.3589228611E+01, 3.8952918720E+00, 9.7838450782E-01],
	[4.4060000000E+04, 4.0952503693E+01, 5.2658469291E+00, 2.3598007452E+01, 3.8956288404E+00, 9.7839406285E-01],
	[4.4065000000E+04, 4.0960714083E+01, 5.2658896091E+00, 2.3606788563E+01, 3.8959657247E+00, 9.7840361314E-01],
	[4.4070000000E+04, 4.0968925187E+01, 5.2659322845E+00, 2.3615571943E+01, 3.8963025250E+00, 9.7841315871E-01],
	[4.4075000000E+04, 4.0977137005E+01, 5.2659749555E+00, 2.3624357594E+01, 3.8966392412E+00, 9.7842269954E-01],
	[4.4080000000E+04, 4.0985349537E+01, 5.2660176220E+00, 2.3633145516E+01, 3.8969758735E+00, 9.7843223564E-01],
	[4.4085000000E+04, 4.0993562783E+01, 5.2660602840E+00, 2.3641935709E+01, 3.8973124217E+00, 9.7844176703E-01],
	[4.4090000000E+04, 4.1001776744E+01, 5.2661029415E+00, 2.3650728173E+01, 3.8976488859E+00, 9.7845129368E-01],
	[4.4095000000E+04, 4.1009991418E+01, 5.2661455945E+00, 2.3659522908E+01, 3.8979852662E+00, 9.7846081562E-01],
	[4.4100000000E+04, 4.1018206807E+01, 5.2661882430E+00, 2.3668319916E+01, 3.8983215626E+00, 9.7847033284E-01],
	[4.4105000000E+04, 4.1026422910E+01, 5.2662308870E+00, 2.3677119196E+01, 3.8986577750E+00, 9.7847984535E-01],
	[4.4110000000E+04, 4.1034639727E+01, 5.2662735265E+00, 2.3685920749E+01, 3.8989939036E+00, 9.7848935315E-01],
	[4.4115000000E+04, 4.1042857258E+01, 5.2663161615E+00, 2.3694724574E+01, 3.8993299483E+00, 9.7849885623E-01],
	[4.4120000000E+04, 4.1051075502E+01, 5.2663587921E+00, 2.3703530673E+01, 3.8996659091E+00, 9.7850835461E-01],
	[4.4125000000E+04, 4.1059294461E+01, 5.2664014182E+00, 2.3712339046E+01, 3.9000017861E+00, 9.7851784828E-01],
	[4.4130000000E+04, 4.1067514134E+01, 5.2664440398E+00, 2.3721149692E+01, 3.9003375794E+00, 9.7852733725E-01],
	[4.4135000000E+04, 4.1075734521E+01, 5.2664866569E+00, 2.3729962613E+01, 3.9006732888E+00, 9.7853682153E-01],
	[4.4140000000E+04, 4.1083955622E+01, 5.2665292695E+00, 2.3738777808E+01, 3.9010089145E+00, 9.7854630110E-01],
	[4.4145000000E+04, 4.1092177437E+01, 5.2665718776E+00, 2.3747595279E+01, 3.9013444564E+00, 9.7855577598E-01],
	[4.4150000000E+04, 4.1100399965E+01, 5.2666144813E+00, 2.3756415024E+01, 3.9016799147E+00, 9.7856524617E-01],
	[4.4155000000E+04, 4.1108623208E+01, 5.2666570804E+00, 2.3765237046E+01, 3.9020152892E+00, 9.7857471167E-01],
	[4.4160000000E+04, 4.1116847165E+01, 5.2666996751E+00, 2.3774061343E+01, 3.9023505801E+00, 9.7858417249E-01],
	[4.4165000000E+04, 4.1125071835E+01, 5.2667422653E+00, 2.3782887916E+01, 3.9026857873E+00, 9.7859362862E-01],
	[4.4170000000E+04, 4.1133297219E+01, 5.2667848511E+00, 2.3791716766E+01, 3.9030209109E+00, 9.7860308007E-01],
	[4.4175000000E+04, 4.1141523317E+01, 5.2668274323E+00, 2.3800547893E+01, 3.9033559508E+00, 9.7861252684E-01],
	[4.4180000000E+04, 4.1149750129E+01, 5.2668700091E+00, 2.3809381297E+01, 3.9036909072E+00, 9.7862196893E-01],
	[4.4185000000E+04, 4.1157977654E+01, 5.2669125814E+00, 2.3818216979E+01, 3.9040257800E+00, 9.7863140635E-01],
	[4.4190000000E+04, 4.1166205894E+01, 5.2669551493E+00, 2.3827054939E+01, 3.9043605693E+00, 9.7864083909E-01],
	[4.4195000000E+04, 4.1174434847E+01, 5.2669977126E+00, 2.3835895177E+01, 3.9046952751E+00, 9.7865026717E-01],
	[4.4200000000E+04, 4.1182664513E+01, 5.2670402715E+00, 2.3844737693E+01, 3.9050298973E+00, 9.7865969058E-01],
	[4.4205000000E+04, 4.1190894894E+01, 5.2670828260E+00, 2.3853582488E+01, 3.9053644361E+00, 9.7866910933E-01],
	[4.4210000000E+04, 4.1199125988E+01, 5.2671253759E+00, 2.3862429563E+01, 3.9056988914E+00, 9.7867852342E-01],
	[4.4215000000E+04, 4.1207357796E+01, 5.2671679214E+00, 2.3871278917E+01, 3.9060332633E+00, 9.7868793285E-01],
	[4.4220000000E+04, 4.1215590317E+01, 5.2672104624E+00, 2.3880130551E+01, 3.9063675517E+00, 9.7869733762E-01],
	[4.4225000000E+04, 4.1223823553E+01, 5.2672529990E+00, 2.3888984465E+01, 3.9067017568E+00, 9.7870673774E-01],
	[4.4230000000E+04, 4.1232057501E+01, 5.2672955311E+00, 2.3897840660E+01, 3.9070358785E+00, 9.7871613320E-01],
	[4.4235000000E+04, 4.1240292164E+01, 5.2673380587E+00, 2.3906699136E+01, 3.9073699168E+00, 9.7872552402E-01],
	[4.4240000000E+04, 4.1248527540E+01, 5.2673805819E+00, 2.3915559893E+01, 3.9077038718E+00, 9.7873491019E-01],
	[4.4245000000E+04, 4.1256763629E+01, 5.2674231006E+00, 2.3924422931E+01, 3.9080377435E+00, 9.7874429172E-01],
	[4.4250000000E+04, 4.1265000432E+01, 5.2674656148E+00, 2.3933288251E+01, 3.9083715319E+00, 9.7875366861E-01],
	[4.4255000000E+04, 4.1273237948E+01, 5.2675081246E+00, 2.3942155854E+01, 3.9087052371E+00, 9.7876304086E-01],
	[4.4260000000E+04, 4.1281476179E+01, 5.2675506299E+00, 2.3951025739E+01, 3.9090388590E+00, 9.7877240847E-01],
	[4.4265000000E+04, 4.1289715122E+01, 5.2675931308E+00, 2.3959897907E+01, 3.9093723977E+00, 9.7878177145E-01],
	[4.4270000000E+04, 4.1297954779E+01, 5.2676356272E+00, 2.3968772358E+01, 3.9097058531E+00, 9.7879112980E-01],
	[4.4275000000E+04, 4.1306195149E+01, 5.2676781191E+00, 2.3977649092E+01, 3.9100392254E+00, 9.7880048352E-01],
	[4.4280000000E+04, 4.1314436233E+01, 5.2677206066E+00, 2.3986528110E+01, 3.9103725146E+00, 9.7880983261E-01],
	[4.4285000000E+04, 4.1322678030E+01, 5.2677630896E+00, 2.3995409413E+01, 3.9107057206E+00, 9.7881917708E-01],
	[4.4290000000E+04, 4.1330920541E+01, 5.2678055682E+00, 2.4004293000E+01, 3.9110388435E+00, 9.7882851693E-01],
	[4.4295000000E+04, 4.1339163765E+01, 5.2678480423E+00, 2.4013178872E+01, 3.9113718833E+00, 9.7883785216E-01],
	[4.4300000000E+04, 4.1347407702E+01, 5.2678905120E+00, 2.4022067029E+01, 3.9117048400E+00, 9.7884718278E-01],
	[4.4305000000E+04, 4.1355652353E+01, 5.2679329772E+00, 2.4030957471E+01, 3.9120377136E+00, 9.7885650878E-01],
	[4.4310000000E+04, 4.1363897717E+01, 5.2679754380E+00, 2.4039850199E+01, 3.9123705043E+00, 9.7886583017E-01],
	[4.4315000000E+04, 4.1372143794E+01, 5.2680178944E+00, 2.4048745214E+01, 3.9127032119E+00, 9.7887514695E-01],
	[4.4320000000E+04, 4.1380390585E+01, 5.2680603462E+00, 2.4057642514E+01, 3.9130358366E+00, 9.7888445913E-01],
	[4.4325000000E+04, 4.1388638088E+01, 5.2681027937E+00, 2.4066542102E+01, 3.9133683782E+00, 9.7889376670E-01],
	[4.4330000000E+04, 4.1396886305E+01, 5.2681452367E+00, 2.4075443977E+01, 3.9137008370E+00, 9.7890306967E-01],
	[4.4335000000E+04, 4.1405135236E+01, 5.2681876752E+00, 2.4084348139E+01, 3.9140332128E+00, 9.7891236805E-01],
	[4.4340000000E+04, 4.1413384879E+01, 5.2682301093E+00, 2.4093254589E+01, 3.9143655057E+00, 9.7892166183E-01],
	[4.4345000000E+04, 4.1421635236E+01, 5.2682725389E+00, 2.4102163327E+01, 3.9146977157E+00, 9.7893095101E-01],
	[4.4350000000E+04, 4.1429886305E+01, 5.2683149642E+00, 2.4111074354E+01, 3.9150298429E+00, 9.7894023560E-01],
	[4.4355000000E+04, 4.1438138088E+01, 5.2683573849E+00, 2.4119987669E+01, 3.9153618872E+00, 9.7894951561E-01],
	[4.4360000000E+04, 4.1446390584E+01, 5.2683998013E+00, 2.4128903274E+01, 3.9156938487E+00, 9.7895879103E-01],
	[4.4365000000E+04, 4.1454643794E+01, 5.2684422131E+00, 2.4137821168E+01, 3.9160257275E+00, 9.7896806187E-01],
	[4.4370000000E+04, 4.1462897716E+01, 5.2684846206E+00, 2.4146741351E+01, 3.9163575234E+00, 9.7897732813E-01],
	[4.4375000000E+04, 4.1471152351E+01, 5.2685270236E+00, 2.4155663825E+01, 3.9166892366E+00, 9.7898658980E-01],
	[4.4380000000E+04, 4.1479407699E+01, 5.2685694222E+00, 2.4164588589E+01, 3.9170208671E+00, 9.7899584691E-01],
	[4.4385000000E+04, 4.1487663761E+01, 5.2686118163E+00, 2.4173515644E+01, 3.9173524148E+00, 9.7900509944E-01],
	[4.4390000000E+04, 4.1495920535E+01, 5.2686542061E+00, 2.4182444990E+01, 3.9176838799E+00, 9.7901434739E-01],
	[4.4395000000E+04, 4.1504178023E+01, 5.2686965913E+00, 2.4191376628E+01, 3.9180152623E+00, 9.7902359078E-01],
	[4.4400000000E+04, 4.1512436223E+01, 5.2687389722E+00, 2.4200310557E+01, 3.9183465621E+00, 9.7903282961E-01],
	[4.4405000000E+04, 4.1520695136E+01, 5.2687813486E+00, 2.4209246778E+01, 3.9186777792E+00, 9.7904206387E-01],
	[4.4410000000E+04, 4.1528954762E+01, 5.2688237206E+00, 2.4218185292E+01, 3.9190089138E+00, 9.7905129357E-01],
	[4.4415000000E+04, 4.1537215102E+01, 5.2688660881E+00, 2.4227126098E+01, 3.9193399657E+00, 9.7906051871E-01],
	[4.4420000000E+04, 4.1545476154E+01, 5.2689084512E+00, 2.4236069197E+01, 3.9196709351E+00, 9.7906973930E-01],
	[4.4425000000E+04, 4.1553737919E+01, 5.2689508099E+00, 2.4245014590E+01, 3.9200018220E+00, 9.7907895533E-01],
	[4.4430000000E+04, 4.1562000396E+01, 5.2689931642E+00, 2.4253962277E+01, 3.9203326263E+00, 9.7908816682E-01],
	[4.4435000000E+04, 4.1570263587E+01, 5.2690355141E+00, 2.4262912257E+01, 3.9206633482E+00, 9.7909737375E-01],
	[4.4440000000E+04, 4.1578527490E+01, 5.2690778595E+00, 2.4271864532E+01, 3.9209939875E+00, 9.7910657614E-01],
	[4.4445000000E+04, 4.1586792107E+01, 5.2691202005E+00, 2.4280819102E+01, 3.9213245445E+00, 9.7911577399E-01],
	[4.4450000000E+04, 4.1595057436E+01, 5.2691625370E+00, 2.4289775967E+01, 3.9216550189E+00, 9.7912496729E-01],
	[4.4455000000E+04, 4.1603323478E+01, 5.2692048692E+00, 2.4298735127E+01, 3.9219854110E+00, 9.7913415606E-01],
	[4.4460000000E+04, 4.1611590232E+01, 5.2692471969E+00, 2.4307696583E+01, 3.9223157207E+00, 9.7914334029E-01],
	[4.4465000000E+04, 4.1619857699E+01, 5.2692895202E+00, 2.4316660334E+01, 3.9226459480E+00, 9.7915251998E-01],
	[4.4470000000E+04, 4.1628125879E+01, 5.2693318391E+00, 2.4325626383E+01, 3.9229760930E+00, 9.7916169515E-01],
	[4.4475000000E+04, 4.1636394772E+01, 5.2693741536E+00, 2.4334594727E+01, 3.9233061557E+00, 9.7917086579E-01],
	[4.4480000000E+04, 4.1644664377E+01, 5.2694164636E+00, 2.4343565369E+01, 3.9236361360E+00, 9.7918003190E-01],
	[4.4485000000E+04, 4.1652934695E+01, 5.2694587693E+00, 2.4352538309E+01, 3.9239660341E+00, 9.7918919349E-01],
	[4.4490000000E+04, 4.1661205726E+01, 5.2695010705E+00, 2.4361513545E+01, 3.9242958499E+00, 9.7919835056E-01],
	[4.4495000000E+04, 4.1669477469E+01, 5.2695433673E+00, 2.4370491080E+01, 3.9246255835E+00, 9.7920750311E-01],
	[4.4500000000E+04, 4.1677749925E+01, 5.2695856597E+00, 2.4379470914E+01, 3.9249552348E+00, 9.7921665114E-01],
	[4.4505000000E+04, 4.1686023094E+01, 5.2696279477E+00, 2.4388453045E+01, 3.9252848040E+00, 9.7922579466E-01],
	[4.4510000000E+04, 4.1694296975E+01, 5.2696702313E+00, 2.4397437476E+01, 3.9256142910E+00, 9.7923493367E-01],
	[4.4515000000E+04, 4.1702571568E+01, 5.2697125104E+00, 2.4406424207E+01, 3.9259436958E+00, 9.7924406818E-01],
	[4.4520000000E+04, 4.1710846874E+01, 5.2697547852E+00, 2.4415413236E+01, 3.9262730185E+00, 9.7925319817E-01],
	[4.4525000000E+04, 4.1719122893E+01, 5.2697970555E+00, 2.4424404566E+01, 3.9266022591E+00, 9.7926232366E-01],
	[4.4530000000E+04, 4.1727399624E+01, 5.2698393215E+00, 2.4433398197E+01, 3.9269314176E+00, 9.7927144465E-01],
	[4.4535000000E+04, 4.1735677067E+01, 5.2698815830E+00, 2.4442394127E+01, 3.9272604940E+00, 9.7928056115E-01],
	[4.4540000000E+04, 4.1743955223E+01, 5.2699238401E+00, 2.4451392359E+01, 3.9275894884E+00, 9.7928967314E-01],
	[4.4545000000E+04, 4.1752234092E+01, 5.2699660928E+00, 2.4460392892E+01, 3.9279184008E+00, 9.7929878065E-01],
	[4.4550000000E+04, 4.1760513673E+01, 5.2700083412E+00, 2.4469395727E+01, 3.9282472311E+00, 9.7930788366E-01],
	[4.4555000000E+04, 4.1768793966E+01, 5.2700505851E+00, 2.4478400864E+01, 3.9285759795E+00, 9.7931698218E-01],
	[4.4560000000E+04, 4.1777074971E+01, 5.2700928246E+00, 2.4487408303E+01, 3.9289046459E+00, 9.7932607622E-01],
	[4.4565000000E+04, 4.1785356689E+01, 5.2701350597E+00, 2.4496418044E+01, 3.9292332304E+00, 9.7933516577E-01],
	[4.4570000000E+04, 4.1793639120E+01, 5.2701772904E+00, 2.4505430089E+01, 3.9295617330E+00, 9.7934425084E-01],
	[4.4575000000E+04, 4.1801922262E+01, 5.2702195167E+00, 2.4514444437E+01, 3.9298901536E+00, 9.7935333143E-01],
	[4.4580000000E+04, 4.1810206117E+01, 5.2702617386E+00, 2.4523461088E+01, 3.9302184924E+00, 9.7936240755E-01],
	[4.4585000000E+04, 4.1818493738E+01, 5.2703043061E+00, 2.4532480044E+01, 3.9305469709E+00, 9.7937147919E-01],
	[4.4590000000E+04, 4.1826795560E+01, 5.2703484143E+00, 2.4541501303E+01, 3.9308763464E+00, 9.7938054637E-01],
	[4.4595000000E+04, 4.1835098098E+01, 5.2703925180E+00, 2.4550524868E+01, 3.9312056402E+00, 9.7938960907E-01],
	[4.4600000000E+04, 4.1843401353E+01, 5.2704366171E+00, 2.4559550737E+01, 3.9315348524E+00, 9.7939866731E-01],
	[4.4605000000E+04, 4.1851705326E+01, 5.2704807116E+00, 2.4568578911E+01, 3.9318639831E+00, 9.7940772108E-01],
	[4.4610000000E+04, 4.1860010015E+01, 5.2705248015E+00, 2.4577609391E+01, 3.9321930322E+00, 9.7941677039E-01],
	[4.4615000000E+04, 4.1868315421E+01, 5.2705688869E+00, 2.4586642177E+01, 3.9325219997E+00, 9.7942581524E-01],
	[4.4620000000E+04, 4.1876621543E+01, 5.2706129676E+00, 2.4595677270E+01, 3.9328508858E+00, 9.7943485564E-01],
	[4.4625000000E+04, 4.1884928383E+01, 5.2706570439E+00, 2.4604714668E+01, 3.9331796903E+00, 9.7944389158E-01],
	[4.4630000000E+04, 4.1893235940E+01, 5.2707011155E+00, 2.4613754374E+01, 3.9335084134E+00, 9.7945292307E-01],
	[4.4635000000E+04, 4.1901544213E+01, 5.2707451826E+00, 2.4622796387E+01, 3.9338370550E+00, 9.7946195011E-01],
	[4.4640000000E+04, 4.1909853203E+01, 5.2707892451E+00, 2.4631840708E+01, 3.9341656152E+00, 9.7947097270E-01],
	[4.4645000000E+04, 4.1918162910E+01, 5.2708333030E+00, 2.4640887336E+01, 3.9344940940E+00, 9.7947999085E-01],
	[4.4650000000E+04, 4.1926473333E+01, 5.2708773564E+00, 2.4649936273E+01, 3.9348224914E+00, 9.7948900456E-01],
	[4.4655000000E+04, 4.1934784474E+01, 5.2709214052E+00, 2.4658987518E+01, 3.9351508074E+00, 9.7949801383E-01],
	[4.4660000000E+04, 4.1943096331E+01, 5.2709654495E+00, 2.4668041072E+01, 3.9354790421E+00, 9.7950701866E-01],
	[4.4665000000E+04, 4.1951408904E+01, 5.2710094892E+00, 2.4677096936E+01, 3.9358071955E+00, 9.7951601906E-01],
	[4.4670000000E+04, 4.1959722195E+01, 5.2710535243E+00, 2.4686155109E+01, 3.9361352675E+00, 9.7952501502E-01],
	[4.4675000000E+04, 4.1968036202E+01, 5.2710975548E+00, 2.4695215592E+01, 3.9364632583E+00, 9.7953400656E-01],
	[4.4680000000E+04, 4.1976350925E+01, 5.2711415808E+00, 2.4704278385E+01, 3.9367911678E+00, 9.7954299367E-01],
	[4.4685000000E+04, 4.1984666366E+01, 5.2711856023E+00, 2.4713343488E+01, 3.9371189961E+00, 9.7955197635E-01],
	[4.4690000000E+04, 4.1992982522E+01, 5.2712296192E+00, 2.4722410903E+01, 3.9374467431E+00, 9.7956095461E-01],
	[4.4695000000E+04, 4.2001299396E+01, 5.2712736315E+00, 2.4731480628E+01, 3.9377744090E+00, 9.7956992845E-01],
	[4.4700000000E+04, 4.2009616986E+01, 5.2713176393E+00, 2.4740552666E+01, 3.9381019937E+00, 9.7957889788E-01],
	[4.4705000000E+04, 4.2017935292E+01, 5.2713616425E+00, 2.4749627015E+01, 3.9384294972E+00, 9.7958786289E-01],
	[4.4710000000E+04, 4.2026254316E+01, 5.2714056412E+00, 2.4758703676E+01, 3.9387569196E+00, 9.7959682349E-01],
	[4.4715000000E+04, 4.2034574055E+01, 5.2714496353E+00, 2.4767782650E+01, 3.9390842609E+00, 9.7960577967E-01],
	[4.4720000000E+04, 4.2042894511E+01, 5.2714936248E+00, 2.4776863936E+01, 3.9394115211E+00, 9.7961473145E-01],
	[4.4725000000E+04, 4.2051215684E+01, 5.2715376098E+00, 2.4785947536E+01, 3.9397387002E+00, 9.7962367883E-01],
	[4.4730000000E+04, 4.2059537573E+01, 5.2715815903E+00, 2.4795033450E+01, 3.9400657982E+00, 9.7963262180E-01],
	[4.4735000000E+04, 4.2067860178E+01, 5.2716255662E+00, 2.4804121677E+01, 3.9403928153E+00, 9.7964156037E-01],
	[4.4740000000E+04, 4.2076183500E+01, 5.2716695376E+00, 2.4813212218E+01, 3.9407197513E+00, 9.7965049455E-01],
	[4.4745000000E+04, 4.2084507538E+01, 5.2717135044E+00, 2.4822305074E+01, 3.9410466064E+00, 9.7965942433E-01],
	[4.4750000000E+04, 4.2092832293E+01, 5.2717574666E+00, 2.4831400245E+01, 3.9413733804E+00, 9.7966834971E-01],
	[4.4755000000E+04, 4.2101157764E+01, 5.2718014244E+00, 2.4840497731E+01, 3.9417000736E+00, 9.7967727071E-01],
	[4.4760000000E+04, 4.2109483951E+01, 5.2718453775E+00, 2.4849597532E+01, 3.9420266858E+00, 9.7968618732E-01],
	[4.4765000000E+04, 4.2117810855E+01, 5.2718893262E+00, 2.4858699649E+01, 3.9423532171E+00, 9.7969509954E-01],
	[4.4770000000E+04, 4.2126138475E+01, 5.2719332703E+00, 2.4867804083E+01, 3.9426796675E+00, 9.7970400738E-01],
	[4.4775000000E+04, 4.2134466811E+01, 5.2719772098E+00, 2.4876910832E+01, 3.9430060371E+00, 9.7971291084E-01],
	[4.4780000000E+04, 4.2142795864E+01, 5.2720211448E+00, 2.4886019899E+01, 3.9433323258E+00, 9.7972180992E-01],
	[4.4785000000E+04, 4.2151125632E+01, 5.2720650753E+00, 2.4895131283E+01, 3.9436585338E+00, 9.7973070462E-01],
	[4.4790000000E+04, 4.2159456117E+01, 5.2721090012E+00, 2.4904244984E+01, 3.9439846609E+00, 9.7973959495E-01],
	[4.4795000000E+04, 4.2167787318E+01, 5.2721529226E+00, 2.4913361003E+01, 3.9443107072E+00, 9.7974848091E-01],
	[4.4800000000E+04, 4.2176119236E+01, 5.2721968395E+00, 2.4922479341E+01, 3.9446366728E+00, 9.7975736250E-01],
	[4.4805000000E+04, 4.2184451869E+01, 5.2722407518E+00, 2.4931599996E+01, 3.9449625577E+00, 9.7976623973E-01],
	[4.4810000000E+04, 4.2192785219E+01, 5.2722846596E+00, 2.4940722971E+01, 3.9452883618E+00, 9.7977511259E-01],
	[4.4815000000E+04, 4.2201119285E+01, 5.2723285629E+00, 2.4949848265E+01, 3.9456140853E+00, 9.7978398109E-01],
	[4.4820000000E+04, 4.2209454067E+01, 5.2723724616E+00, 2.4958975878E+01, 3.9459397281E+00, 9.7979284523E-01],
	[4.4825000000E+04, 4.2217789565E+01, 5.2724163558E+00, 2.4968105811E+01, 3.9462652902E+00, 9.7980170502E-01],
	[4.4830000000E+04, 4.2226125779E+01, 5.2724602455E+00, 2.4977238064E+01, 3.9465907717E+00, 9.7981056045E-01],
	[4.4835000000E+04, 4.2234462709E+01, 5.2725041306E+00, 2.4986372637E+01, 3.9469161726E+00, 9.7981941153E-01],
	[4.4840000000E+04, 4.2242800356E+01, 5.2725480112E+00, 2.4995509532E+01, 3.9472414929E+00, 9.7982825826E-01],
	[4.4845000000E+04, 4.2251138718E+01, 5.2725918873E+00, 2.5004648747E+01, 3.9475667327E+00, 9.7983710065E-01],
	[4.4850000000E+04, 4.2259477796E+01, 5.2726357588E+00, 2.5013790284E+01, 3.9478918919E+00, 9.7984593869E-01],
	[4.4855000000E+04, 4.2267817590E+01, 5.2726796258E+00, 2.5022934143E+01, 3.9482169706E+00, 9.7985477238E-01],
	[4.4860000000E+04, 4.2276158101E+01, 5.2727234883E+00, 2.5032080323E+01, 3.9485419688E+00, 9.7986360174E-01],
	[4.4865000000E+04, 4.2284499327E+01, 5.2727673463E+00, 2.5041228827E+01, 3.9488668865E+00, 9.7987242676E-01],
	[4.4870000000E+04, 4.2292841269E+01, 5.2728111998E+00, 2.5050379652E+01, 3.9491917237E+00, 9.7988124745E-01],
	[4.4875000000E+04, 4.2301183927E+01, 5.2728550487E+00, 2.5059532802E+01, 3.9495164805E+00, 9.7989006380E-01],
	[4.4880000000E+04, 4.2309527301E+01, 5.2728988931E+00, 2.5068688274E+01, 3.9498411569E+00, 9.7989887583E-01],
	[4.4885000000E+04, 4.2317871391E+01, 5.2729427330E+00, 2.5077846070E+01, 3.9501657529E+00, 9.7990768353E-01],
	[4.4890000000E+04, 4.2326216197E+01, 5.2729865684E+00, 2.5087006191E+01, 3.9504902685E+00, 9.7991648690E-01],
	[4.4895000000E+04, 4.2334561718E+01, 5.2730303992E+00, 2.5096168635E+01, 3.9508147038E+00, 9.7992528595E-01],
	[4.4900000000E+04, 4.2342907956E+01, 5.2730742256E+00, 2.5105333405E+01, 3.9511390587E+00, 9.7993408068E-01],
	[4.4905000000E+04, 4.2351254909E+01, 5.2731180474E+00, 2.5114500499E+01, 3.9514633334E+00, 9.7994287109E-01],
	[4.4910000000E+04, 4.2359602578E+01, 5.2731618647E+00, 2.5123669919E+01, 3.9517875277E+00, 9.7995165719E-01],
	[4.4915000000E+04, 4.2367950963E+01, 5.2732056775E+00, 2.5132841665E+01, 3.9521116417E+00, 9.7996043897E-01],
	[4.4920000000E+04, 4.2376300063E+01, 5.2732494858E+00, 2.5142015737E+01, 3.9524356756E+00, 9.7996921644E-01],
	[4.4925000000E+04, 4.2384649880E+01, 5.2732932895E+00, 2.5151192135E+01, 3.9527596291E+00, 9.7997798961E-01],
	[4.4930000000E+04, 4.2393000411E+01, 5.2733370888E+00, 2.5160370860E+01, 3.9530835025E+00, 9.7998675847E-01],
	[4.4935000000E+04, 4.2401351659E+01, 5.2733808835E+00, 2.5169551912E+01, 3.9534072957E+00, 9.7999552302E-01],
	[4.4940000000E+04, 4.2409703623E+01, 5.2734246738E+00, 2.5178735292E+01, 3.9537310087E+00, 9.8000428328E-01],
	[4.4945000000E+04, 4.2418056302E+01, 5.2734684595E+00, 2.5187920999E+01, 3.9540546416E+00, 9.8001303924E-01],
	[4.4950000000E+04, 4.2426409696E+01, 5.2735122407E+00, 2.5197109034E+01, 3.9543781944E+00, 9.8002179090E-01],
	[4.4955000000E+04, 4.2434763806E+01, 5.2735560174E+00, 2.5206299398E+01, 3.9547016671E+00, 9.8003053826E-01],
	[4.4960000000E+04, 4.2443118632E+01, 5.2735997896E+00, 2.5215492090E+01, 3.9550250596E+00, 9.8003928134E-01],
	[4.4965000000E+04, 4.2451474174E+01, 5.2736435573E+00, 2.5224687111E+01, 3.9553483722E+00, 9.8004802013E-01],
	[4.4970000000E+04, 4.2459830431E+01, 5.2736873205E+00, 2.5233884462E+01, 3.9556716046E+00, 9.8005675463E-01],
	[4.4975000000E+04, 4.2468187403E+01, 5.2737310792E+00, 2.5243084142E+01, 3.9559947571E+00, 9.8006548484E-01],
	[4.4980000000E+04, 4.2476545092E+01, 5.2737748334E+00, 2.5252286153E+01, 3.9563178296E+00, 9.8007421078E-01],
	[4.4985000000E+04, 4.2484903495E+01, 5.2738185831E+00, 2.5261490494E+01, 3.9566408221E+00, 9.8008293243E-01],
	[4.4990000000E+04, 4.2493262614E+01, 5.2738623283E+00, 2.5270697165E+01, 3.9569637346E+00, 9.8009164981E-01],
	[4.4995000000E+04, 4.2501622449E+01, 5.2739060690E+00, 2.5279906168E+01, 3.9572865672E+00, 9.8010036291E-01],
	[4.5000000000E+04, 4.2509982999E+01, 5.2739498052E+00, 2.5289117502E+01, 3.9576093199E+00, 9.8010907174E-01],
	[4.5005000000E+04, 4.2518344265E+01, 5.2739935369E+00, 2.5298350408E+01, 3.9579324636E+00, 9.8011777631E-01],
	[4.5010000000E+04, 4.2526706246E+01, 5.2740372641E+00, 2.5307585658E+01, 3.9582555273E+00, 9.8012647660E-01],
	[4.5015000000E+04, 4.2535068942E+01, 5.2740809869E+00, 2.5316823252E+01, 3.9585785108E+00, 9.8013517263E-01],
	[4.5020000000E+04, 4.2543432354E+01, 5.2741247051E+00, 2.5326063191E+01, 3.9589014143E+00, 9.8014386440E-01],
	[4.5025000000E+04, 4.2551796481E+01, 5.2741684188E+00, 2.5335305474E+01, 3.9592242377E+00, 9.8015255190E-01],
	[4.5030000000E+04, 4.2560161323E+01, 5.2742121280E+00, 2.5344550103E+01, 3.9595469811E+00, 9.8016123515E-01],
	[4.5035000000E+04, 4.2568526881E+01, 5.2742558328E+00, 2.5353797078E+01, 3.9598696445E+00, 9.8016991415E-01],
	[4.5040000000E+04, 4.2576893154E+01, 5.2742995330E+00, 2.5363046398E+01, 3.9601922279E+00, 9.8017858889E-01],
	[4.5045000000E+04, 4.2585260143E+01, 5.2743432288E+00, 2.5372298065E+01, 3.9605147313E+00, 9.8018725937E-01],
	[4.5050000000E+04, 4.2593627846E+01, 5.2743869201E+00, 2.5381552078E+01, 3.9608371548E+00, 9.8019592562E-01],
	[4.5055000000E+04, 4.2601996265E+01, 5.2744306069E+00, 2.5390808439E+01, 3.9611594983E+00, 9.8020458761E-01],
	[4.5060000000E+04, 4.2610365399E+01, 5.2744742892E+00, 2.5400067146E+01, 3.9614817620E+00, 9.8021324536E-01],
	[4.5065000000E+04, 4.2618735249E+01, 5.2745179670E+00, 2.5409328202E+01, 3.9618039458E+00, 9.8022189887E-01],
	[4.5070000000E+04, 4.2627105813E+01, 5.2745616403E+00, 2.5418591605E+01, 3.9621260497E+00, 9.8023054815E-01],
	[4.5075000000E+04, 4.2635477093E+01, 5.2746053092E+00, 2.5427857356E+01, 3.9624480738E+00, 9.8023919318E-01],
	[4.5080000000E+04, 4.2643849088E+01, 5.2746489735E+00, 2.5437125456E+01, 3.9627700181E+00, 9.8024783398E-01],
	[4.5085000000E+04, 4.2652221798E+01, 5.2746926334E+00, 2.5446395905E+01, 3.9630918825E+00, 9.8025647055E-01],
	[4.5090000000E+04, 4.2660595224E+01, 5.2747362888E+00, 2.5455668704E+01, 3.9634136672E+00, 9.8026510289E-01],
	[4.5095000000E+04, 4.2668969364E+01, 5.2747799398E+00, 2.5464943852E+01, 3.9637353722E+00, 9.8027373101E-01],
	[4.5100000000E+04, 4.2677344219E+01, 5.2748235862E+00, 2.5474221349E+01, 3.9640569974E+00, 9.8028235489E-01],
	[4.5105000000E+04, 4.2685719790E+01, 5.2748672282E+00, 2.5483501198E+01, 3.9643785429E+00, 9.8029097456E-01],
	[4.5110000000E+04, 4.2694096076E+01, 5.2749108657E+00, 2.5492783397E+01, 3.9647000087E+00, 9.8029959001E-01],
	[4.5115000000E+04, 4.2702473076E+01, 5.2749544987E+00, 2.5502067946E+01, 3.9650213948E+00, 9.8030820124E-01],
	[4.5120000000E+04, 4.2710850792E+01, 5.2749981273E+00, 2.5511354847E+01, 3.9653427013E+00, 9.8031680825E-01],
	[4.5125000000E+04, 4.2719229223E+01, 5.2750417513E+00, 2.5520644100E+01, 3.9656639282E+00, 9.8032541105E-01],
	[4.5130000000E+04, 4.2727608368E+01, 5.2750853709E+00, 2.5529935705E+01, 3.9659850754E+00, 9.8033400965E-01],
	[4.5135000000E+04, 4.2735988229E+01, 5.2751289861E+00, 2.5539229662E+01, 3.9663061431E+00, 9.8034260403E-01],
	[4.5140000000E+04, 4.2744368804E+01, 5.2751725967E+00, 2.5548525971E+01, 3.9666271312E+00, 9.8035119421E-01],
	[4.5145000000E+04, 4.2752750095E+01, 5.2752162029E+00, 2.5557824634E+01, 3.9669480397E+00, 9.8035978018E-01],
	[4.5150000000E+04, 4.2761132100E+01, 5.2752598046E+00, 2.5567125650E+01, 3.9672688688E+00, 9.8036836196E-01],
	[4.5155000000E+04, 4.2769514821E+01, 5.2753034019E+00, 2.5576429019E+01, 3.9675896183E+00, 9.8037693953E-01],
	[4.5160000000E+04, 4.2777898256E+01, 5.2753469947E+00, 2.5585734743E+01, 3.9679102883E+00, 9.8038551291E-01],
	[4.5165000000E+04, 4.2786282406E+01, 5.2753905830E+00, 2.5595042821E+01, 3.9682308789E+00, 9.8039408209E-01],
	[4.5170000000E+04, 4.2794667271E+01, 5.2754341668E+00, 2.5604353253E+01, 3.9685513901E+00, 9.8040264708E-01],
	[4.5175000000E+04, 4.2803052850E+01, 5.2754777462E+00, 2.5613666040E+01, 3.9688718218E+00, 9.8041120788E-01],
	[4.5180000000E+04, 4.2811439145E+01, 5.2755213211E+00, 2.5622981183E+01, 3.9691921741E+00, 9.8041976449E-01],
	[4.5185000000E+04, 4.2819826154E+01, 5.2755648916E+00, 2.5632298682E+01, 3.9695124471E+00, 9.8042831691E-01],
	[4.5190000000E+04, 4.2828213878E+01, 5.2756084576E+00, 2.5641618536E+01, 3.9698326407E+00, 9.8043686515E-01],
	[4.5195000000E+04, 4.2836602317E+01, 5.2756520191E+00, 2.5650940747E+01, 3.9701527550E+00, 9.8044540921E-01],
	[4.5200000000E+04, 4.2844991471E+01, 5.2756955762E+00, 2.5660265314E+01, 3.9704727899E+00, 9.8045394908E-01],
	[4.5205000000E+04, 4.2853381339E+01, 5.2757391288E+00, 2.5669592238E+01, 3.9707927456E+00, 9.8046248478E-01],
	[4.5210000000E+04, 4.2861771922E+01, 5.2757826770E+00, 2.5678921520E+01, 3.9711126220E+00, 9.8047101629E-01],
	[4.5215000000E+04, 4.2870163220E+01, 5.2758262207E+00, 2.5688253159E+01, 3.9714324191E+00, 9.8047954364E-01],
	[4.5220000000E+04, 4.2878555232E+01, 5.2758697600E+00, 2.5697587156E+01, 3.9717521370E+00, 9.8048806681E-01],
	[4.5225000000E+04, 4.2886947959E+01, 5.2759132948E+00, 2.5706923512E+01, 3.9720717757E+00, 9.8049658581E-01],
	[4.5230000000E+04, 4.2895341400E+01, 5.2759568251E+00, 2.5716262226E+01, 3.9723913353E+00, 9.8050510064E-01],
	[4.5235000000E+04, 4.2903735556E+01, 5.2760003510E+00, 2.5725603299E+01, 3.9727108156E+00, 9.8051361130E-01],
	[4.5240000000E+04, 4.2912130427E+01, 5.2760438724E+00, 2.5734946732E+01, 3.9730302168E+00, 9.8052211780E-01],
	[4.5245000000E+04, 4.2920526013E+01, 5.2760873894E+00, 2.5744292524E+01, 3.9733495389E+00, 9.8053062014E-01],
	[4.5250000000E+04, 4.2928922312E+01, 5.2761309020E+00, 2.5753640676E+01, 3.9736687819E+00, 9.8053911832E-01],
	[4.5255000000E+04, 4.2937319327E+01, 5.2761744101E+00, 2.5762991189E+01, 3.9739879458E+00, 9.8054761234E-01],
	[4.5260000000E+04, 4.2945717056E+01, 5.2762179137E+00, 2.5772344062E+01, 3.9743070306E+00, 9.8055610220E-01],
	[4.5265000000E+04, 4.2954115499E+01, 5.2762614129E+00, 2.5781699296E+01, 3.9746260364E+00, 9.8056458791E-01],
	[4.5270000000E+04, 4.2962514657E+01, 5.2763049077E+00, 2.5791056892E+01, 3.9749449632E+00, 9.8057306946E-01],
	[4.5275000000E+04, 4.2970914529E+01, 5.2763483980E+00, 2.5800416849E+01, 3.9752638109E+00, 9.8058154687E-01],
	[4.5280000000E+04, 4.2979315116E+01, 5.2763918838E+00, 2.5809779168E+01, 3.9755825797E+00, 9.8059002013E-01],
	[4.5285000000E+04, 4.2987716417E+01, 5.2764353652E+00, 2.5819143850E+01, 3.9759012696E+00, 9.8059848924E-01],
	[4.5290000000E+04, 4.2996118433E+01, 5.2764788422E+00, 2.5828510894E+01, 3.9762198805E+00, 9.8060695421E-01],
	[4.5295000000E+04, 4.3004521163E+01, 5.2765223147E+00, 2.5837880301E+01, 3.9765384125E+00, 9.8061541503E-01],
	[4.5300000000E+04, 4.3012924607E+01, 5.2765657828E+00, 2.5847252072E+01, 3.9768568656E+00, 9.8062387172E-01],
	[4.5305000000E+04, 4.3021339227E+01, 5.2766104256E+00, 2.5856626206E+01, 3.9771759991E+00, 9.8063232426E-01],
	[4.5310000000E+04, 4.3029760550E+01, 5.2766557385E+00, 2.5866002705E+01, 3.9774954883E+00, 9.8064077267E-01],
	[4.5315000000E+04, 4.3038182592E+01, 5.2767010468E+00, 2.5875381567E+01, 3.9778148989E+00, 9.8064921695E-01],
	[4.5320000000E+04, 4.3046605353E+01, 5.2767463504E+00, 2.5884762795E+01, 3.9781342309E+00, 9.8065765710E-01],
	[4.5325000000E+04, 4.3055028833E+01, 5.2767916495E+00, 2.5894146387E+01, 3.9784534842E+00, 9.8066609311E-01],
	[4.5330000000E+04, 4.3063453032E+01, 5.2768369439E+00, 2.5903532345E+01, 3.9787726590E+00, 9.8067452500E-01],
	[4.5335000000E+04, 4.3071877950E+01, 5.2768822337E+00, 2.5912920668E+01, 3.9790917552E+00, 9.8068295276E-01],
	[4.5340000000E+04, 4.3080303586E+01, 5.2769275190E+00, 2.5922311358E+01, 3.9794107728E+00, 9.8069137640E-01],
	[4.5345000000E+04, 4.3088729941E+01, 5.2769727996E+00, 2.5931704413E+01, 3.9797297120E+00, 9.8069979592E-01],
	[4.5350000000E+04, 4.3097157016E+01, 5.2770180756E+00, 2.5941099836E+01, 3.9800485726E+00, 9.8070821131E-01],
	[4.5355000000E+04, 4.3105584809E+01, 5.2770633470E+00, 2.5950497625E+01, 3.9803673547E+00, 9.8071662259E-01],
	[4.5360000000E+04, 4.3114013320E+01, 5.2771086138E+00, 2.5959897782E+01, 3.9806860583E+00, 9.8072502976E-01],
	[4.5365000000E+04, 4.3122442551E+01, 5.2771538760E+00, 2.5969300307E+01, 3.9810046836E+00, 9.8073343281E-01],
	[4.5370000000E+04, 4.3130872500E+01, 5.2771991336E+00, 2.5978705199E+01, 3.9813232303E+00, 9.8074183175E-01],
	[4.5375000000E+04, 4.3139303168E+01, 5.2772443867E+00, 2.5988112460E+01, 3.9816416987E+00, 9.8075022658E-01],
	[4.5380000000E+04, 4.3147734554E+01, 5.2772896351E+00, 2.5997522090E+01, 3.9819600887E+00, 9.8075861730E-01],
	[4.5385000000E+04, 4.3156166660E+01, 5.2773348789E+00, 2.6006934089E+01, 3.9822784004E+00, 9.8076700392E-01],
	[4.5390000000E+04, 4.3164599484E+01, 5.2773801181E+00, 2.6016348457E+01, 3.9825966336E+00, 9.8077538643E-01],
	[4.5395000000E+04, 4.3173033026E+01, 5.2774253527E+00, 2.6025765195E+01, 3.9829147886E+00, 9.8078376484E-01],
	[4.5400000000E+04, 4.3181467287E+01, 5.2774705828E+00, 2.6035184303E+01, 3.9832328653E+00, 9.8079213916E-01],
	[4.5405000000E+04, 4.3189902267E+01, 5.2775158082E+00, 2.6044605781E+01, 3.9835508637E+00, 9.8080050937E-01],
	[4.5410000000E+04, 4.3198337966E+01, 5.2775610290E+00, 2.6054029630E+01, 3.9838687838E+00, 9.8080887549E-01],
	[4.5415000000E+04, 4.3206774382E+01, 5.2776062453E+00, 2.6063455850E+01, 3.9841866257E+00, 9.8081723752E-01],
	[4.5420000000E+04, 4.3215211518E+01, 5.2776514569E+00, 2.6072884441E+01, 3.9845043894E+00, 9.8082559546E-01],
	[4.5425000000E+04, 4.3223649372E+01, 5.2776966640E+00, 2.6082315404E+01, 3.9848220749E+00, 9.8083394931E-01],
	[4.5430000000E+04, 4.3232087945E+01, 5.2777418665E+00, 2.6091748739E+01, 3.9851396822E+00, 9.8084229907E-01],
	[4.5435000000E+04, 4.3240527236E+01, 5.2777870644E+00, 2.6101184447E+01, 3.9854572114E+00, 9.8085064474E-01],
	[4.5440000000E+04, 4.3248967245E+01, 5.2778322577E+00, 2.6110622527E+01, 3.9857746624E+00, 9.8085898634E-01],
	[4.5445000000E+04, 4.3257407973E+01, 5.2778774464E+00, 2.6120062981E+01, 3.9860920353E+00, 9.8086732385E-01],
	[4.5450000000E+04, 4.3265849420E+01, 5.2779226306E+00, 2.6129505807E+01, 3.9864093301E+00, 9.8087565728E-01],
	[4.5455000000E+04, 4.3274291585E+01, 5.2779678101E+00, 2.6138951008E+01, 3.9867265468E+00, 9.8088398664E-01],
	[4.5460000000E+04, 4.3282734468E+01, 5.2780129851E+00, 2.6148398583E+01, 3.9870436855E+00, 9.8089231192E-01],
	[4.5465000000E+04, 4.3291178070E+01, 5.2780581555E+00, 2.6157848531E+01, 3.9873607462E+00, 9.8090063313E-01],
	[4.5470000000E+04, 4.3299622390E+01, 5.2781033213E+00, 2.6167300855E+01, 3.9876777288E+00, 9.8090895027E-01],
	[4.5475000000E+04, 4.3308067428E+01, 5.2781484825E+00, 2.6176755554E+01, 3.9879946335E+00, 9.8091726334E-01],
	[4.5480000000E+04, 4.3316513185E+01, 5.2781936392E+00, 2.6186212628E+01, 3.9883114602E+00, 9.8092557234E-01],
	[4.5485000000E+04, 4.3324959660E+01, 5.2782387912E+00, 2.6195672078E+01, 3.9886282089E+00, 9.8093387728E-01],
	[4.5490000000E+04, 4.3333406854E+01, 5.2782839387E+00, 2.6205133904E+01, 3.9889448798E+00, 9.8094217816E-01],
	[4.5495000000E+04, 4.3341854765E+01, 5.2783290816E+00, 2.6214598106E+01, 3.9892614727E+00, 9.8095047497E-01],
	[4.5500000000E+04, 4.3350303395E+01, 5.2783742200E+00, 2.6224064686E+01, 3.9895779877E+00, 9.8095876773E-01],
	[4.5505000000E+04, 4.3358752743E+01, 5.2784193538E+00, 2.6233533642E+01, 3.9898944249E+00, 9.8096705643E-01],
	[4.5510000000E+04, 4.3367202810E+01, 5.2784644830E+00, 2.6243004976E+01, 3.9902107842E+00, 9.8097534108E-01],
	[4.5515000000E+04, 4.3375653595E+01, 5.2785096076E+00, 2.6252478687E+01, 3.9905270657E+00, 9.8098362167E-01],
	[4.5520000000E+04, 4.3384105097E+01, 5.2785547276E+00, 2.6261954777E+01, 3.9908432694E+00, 9.8099189822E-01],
	[4.5525000000E+04, 4.3392557319E+01, 5.2785998431E+00, 2.6271433245E+01, 3.9911593953E+00, 9.8100017071E-01],
	[4.5530000000E+04, 4.3401010258E+01, 5.2786449540E+00, 2.6280914091E+01, 3.9914754434E+00, 9.8100843916E-01],
	[4.5535000000E+04, 4.3409463915E+01, 5.2786900604E+00, 2.6290397317E+01, 3.9917914138E+00, 9.8101670357E-01],
	[4.5540000000E+04, 4.3417918291E+01, 5.2787351622E+00, 2.6299882922E+01, 3.9921073065E+00, 9.8102496393E-01],
	[4.5545000000E+04, 4.3426373384E+01, 5.2787802594E+00, 2.6309370907E+01, 3.9924231215E+00, 9.8103322025E-01],
	[4.5550000000E+04, 4.3434829196E+01, 5.2788253520E+00, 2.6318861272E+01, 3.9927388588E+00, 9.8104147254E-01],
	[4.5555000000E+04, 4.3443285726E+01, 5.2788704401E+00, 2.6328354018E+01, 3.9930545185E+00, 9.8104972079E-01],
	[4.5560000000E+04, 4.3451742973E+01, 5.2789155236E+00, 2.6337849144E+01, 3.9933701005E+00, 9.8105796500E-01],
	[4.5565000000E+04, 4.3460200939E+01, 5.2789606026E+00, 2.6347346652E+01, 3.9936856049E+00, 9.8106620519E-01],
	[4.5570000000E+04, 4.3468659623E+01, 5.2790056770E+00, 2.6356846541E+01, 3.9940010317E+00, 9.8107444134E-01],
	[4.5575000000E+04, 4.3477119025E+01, 5.2790507468E+00, 2.6366348811E+01, 3.9943163809E+00, 9.8108267346E-01],
	[4.5580000000E+04, 4.3485579145E+01, 5.2790958121E+00, 2.6375853464E+01, 3.9946316526E+00, 9.8109090156E-01],
	[4.5585000000E+04, 4.3494039982E+01, 5.2791408728E+00, 2.6385360499E+01, 3.9949468467E+00, 9.8109912564E-01],
	[4.5590000000E+04, 4.3502501538E+01, 5.2791859290E+00, 2.6394869917E+01, 3.9952619633E+00, 9.8110734569E-01],
	[4.5595000000E+04, 4.3510963812E+01, 5.2792309806E+00, 2.6404381719E+01, 3.9955770024E+00, 9.8111556172E-01],
	[4.5600000000E+04, 4.3519426804E+01, 5.2792760276E+00, 2.6413895903E+01, 3.9958919641E+00, 9.8112377374E-01],
	[4.5605000000E+04, 4.3527890513E+01, 5.2793210701E+00, 2.6423412472E+01, 3.9962068483E+00, 9.8113198174E-01],
	[4.5610000000E+04, 4.3536354940E+01, 5.2793661080E+00, 2.6432931424E+01, 3.9965216551E+00, 9.8114018572E-01],
	[4.5615000000E+04, 4.3544820086E+01, 5.2794111414E+00, 2.6442452761E+01, 3.9968363844E+00, 9.8114838570E-01],
	[4.5620000000E+04, 4.3553285949E+01, 5.2794561703E+00, 2.6451976483E+01, 3.9971510364E+00, 9.8115658166E-01],
	[4.5625000000E+04, 4.3561752529E+01, 5.2795011945E+00, 2.6461502590E+01, 3.9974656110E+00, 9.8116477362E-01],
	[4.5630000000E+04, 4.3570219828E+01, 5.2795462143E+00, 2.6471031082E+01, 3.9977801083E+00, 9.8117296157E-01],
	[4.5635000000E+04, 4.3578687845E+01, 5.2795912295E+00, 2.6480561961E+01, 3.9980945282E+00, 9.8118114552E-01],
	[4.5640000000E+04, 4.3587156579E+01, 5.2796362401E+00, 2.6490095225E+01, 3.9984088708E+00, 9.8118932546E-01],
	[4.5645000000E+04, 4.3595626031E+01, 5.2796812462E+00, 2.6499630876E+01, 3.9987231362E+00, 9.8119750141E-01],
	[4.5650000000E+04, 4.3604096201E+01, 5.2797262477E+00, 2.6509168913E+01, 3.9990373242E+00, 9.8120567336E-01],
	[4.5655000000E+04, 4.3612567088E+01, 5.2797712447E+00, 2.6518709338E+01, 3.9993514351E+00, 9.8121384131E-01],
	[4.5660000000E+04, 4.3621038693E+01, 5.2798162372E+00, 2.6528252151E+01, 3.9996654686E+00, 9.8122200527E-01],
	[4.5665000000E+04, 4.3629511016E+01, 5.2798612251E+00, 2.6537797351E+01, 3.9999794250E+00, 9.8123016524E-01],
	[4.5670000000E+04, 4.3637984056E+01, 5.2799062084E+00, 2.6547344939E+01, 4.0002933043E+00, 9.8123832122E-01],
	[4.5675000000E+04, 4.3646457815E+01, 5.2799511873E+00, 2.6556894916E+01, 4.0006071063E+00, 9.8124647321E-01],
	[4.5680000000E+04, 4.3654932290E+01, 5.2799961616E+00, 2.6566447281E+01, 4.0009208312E+00, 9.8125462122E-01],
	[4.5685000000E+04, 4.3663407484E+01, 5.2800411313E+00, 2.6576002036E+01, 4.0012344790E+00, 9.8126276524E-01],
	[4.5690000000E+04, 4.3671883395E+01, 5.2800860965E+00, 2.6585559180E+01, 4.0015480497E+00, 9.8127090528E-01],
	[4.5695000000E+04, 4.3680360023E+01, 5.2801310572E+00, 2.6595118715E+01, 4.0018615433E+00, 9.8127904135E-01],
	[4.5700000000E+04, 4.3688837369E+01, 5.2801760133E+00, 2.6604680639E+01, 4.0021749598E+00, 9.8128717343E-01],
	[4.5705000000E+04, 4.3697315433E+01, 5.2802209649E+00, 2.6614244954E+01, 4.0024882993E+00, 9.8129530154E-01],
	[4.5710000000E+04, 4.3705794214E+01, 5.2802659120E+00, 2.6623811659E+01, 4.0028015618E+00, 9.8130342568E-01],
	[4.5715000000E+04, 4.3714273713E+01, 5.2803108545E+00, 2.6633380756E+01, 4.0031147473E+00, 9.8131154584E-01],
	[4.5720000000E+04, 4.3722753929E+01, 5.2803557925E+00, 2.6642952244E+01, 4.0034278558E+00, 9.8131966204E-01],
	[4.5725000000E+04, 4.3731234862E+01, 5.2804007260E+00, 2.6652526125E+01, 4.0037408873E+00, 9.8132777427E-01],
	[4.5730000000E+04, 4.3739716513E+01, 5.2804456549E+00, 2.6662102397E+01, 4.0040538419E+00, 9.8133588253E-01],
	[4.5735000000E+04, 4.3748198882E+01, 5.2804905793E+00, 2.6671681062E+01, 4.0043667196E+00, 9.8134398683E-01],
	[4.5740000000E+04, 4.3756681968E+01, 5.2805354992E+00, 2.6681262120E+01, 4.0046795204E+00, 9.8135208717E-01],
	[4.5745000000E+04, 4.3765165771E+01, 5.2805804145E+00, 2.6690845571E+01, 4.0049922444E+00, 9.8136018355E-01],
	[4.5750000000E+04, 4.3773650292E+01, 5.2806253253E+00, 2.6700431415E+01, 4.0053048914E+00, 9.8136827597E-01],
	[4.5755000000E+04, 4.3782135530E+01, 5.2806702316E+00, 2.6710019653E+01, 4.0056174617E+00, 9.8137636444E-01],
	[4.5760000000E+04, 4.3790621485E+01, 5.2807151334E+00, 2.6719610286E+01, 4.0059299551E+00, 9.8138444896E-01],
	[4.5765000000E+04, 4.3799108158E+01, 5.2807600306E+00, 2.6729203313E+01, 4.0062423717E+00, 9.8139252952E-01],
	[4.5770000000E+04, 4.3807595548E+01, 5.2808049234E+00, 2.6738798735E+01, 4.0065547116E+00, 9.8140060614E-01],
	[4.5775000000E+04, 4.3816083655E+01, 5.2808498116E+00, 2.6748396552E+01, 4.0068669747E+00, 9.8140867881E-01],
	[4.5780000000E+04, 4.3824572479E+01, 5.2808946952E+00, 2.6757996765E+01, 4.0071791611E+00, 9.8141674753E-01],
	[4.5785000000E+04, 4.3833062021E+01, 5.2809395744E+00, 2.6767599373E+01, 4.0074912707E+00, 9.8142481231E-01],
	[4.5790000000E+04, 4.3841552280E+01, 5.2809844490E+00, 2.6777204378E+01, 4.0078033037E+00, 9.8143287315E-01],
	[4.5795000000E+04, 4.3850043257E+01, 5.2810293191E+00, 2.6786811780E+01, 4.0081152600E+00, 9.8144093005E-01],
	[4.5800000000E+04, 4.3858534950E+01, 5.2810741847E+00, 2.6796421578E+01, 4.0084271397E+00, 9.8144898301E-01],
	[4.5805000000E+04, 4.3867027361E+01, 5.2811190458E+00, 2.6806033773E+01, 4.0087389427E+00, 9.8145703204E-01],
	[4.5810000000E+04, 4.3875520488E+01, 5.2811639024E+00, 2.6815648366E+01, 4.0090506691E+00, 9.8146507714E-01],
	[4.5815000000E+04, 4.3884014333E+01, 5.2812087545E+00, 2.6825265357E+01, 4.0093623190E+00, 9.8147311830E-01],
	[4.5820000000E+04, 4.3892508896E+01, 5.2812536020E+00, 2.6834884746E+01, 4.0096738922E+00, 9.8148115554E-01],
	[4.5825000000E+04, 4.3901004175E+01, 5.2812984450E+00, 2.6844506534E+01, 4.0099853890E+00, 9.8148918885E-01],
	[4.5830000000E+04, 4.3909500171E+01, 5.2813432835E+00, 2.6854130721E+01, 4.0102968092E+00, 9.8149721823E-01],
	[4.5835000000E+04, 4.3917996884E+01, 5.2813881175E+00, 2.6863757307E+01, 4.0106081528E+00, 9.8150524370E-01],
	[4.5840000000E+04, 4.3926494315E+01, 5.2814329470E+00, 2.6873386292E+01, 4.0109194200E+00, 9.8151326524E-01],
	[4.5845000000E+04, 4.3934992462E+01, 5.2814777720E+00, 2.6883017677E+01, 4.0112306108E+00, 9.8152128286E-01],
	[4.5850000000E+04, 4.3943491327E+01, 5.2815225925E+00, 2.6892651463E+01, 4.0115417251E+00, 9.8152929657E-01],
	[4.5855000000E+04, 4.3951990908E+01, 5.2815674085E+00, 2.6902287649E+01, 4.0118527630E+00, 9.8153730636E-01],
	[4.5860000000E+04, 4.3960491207E+01, 5.2816122199E+00, 2.6911926236E+01, 4.0121637244E+00, 9.8154531223E-01],
	[4.5865000000E+04, 4.3968992222E+01, 5.2816570269E+00, 2.6921567225E+01, 4.0124746095E+00, 9.8155331420E-01],
	[4.5870000000E+04, 4.3977493955E+01, 5.2817018293E+00, 2.6931210615E+01, 4.0127854182E+00, 9.8156131226E-01],
	[4.5875000000E+04, 4.3985996404E+01, 5.2817466273E+00, 2.6940856407E+01, 4.0130961506E+00, 9.8156930641E-01],
	[4.5880000000E+04, 4.3994499570E+01, 5.2817914207E+00, 2.6950504601E+01, 4.0134068067E+00, 9.8157729666E-01],
	[4.5885000000E+04, 4.4003003453E+01, 5.2818362097E+00, 2.6960155198E+01, 4.0137173865E+00, 9.8158528300E-01],
	[4.5890000000E+04, 4.4011508053E+01, 5.2818809941E+00, 2.6969808197E+01, 4.0140278899E+00, 9.8159326545E-01],
	[4.5895000000E+04, 4.4020013370E+01, 5.2819257741E+00, 2.6979463600E+01, 4.0143383172E+00, 9.8160124399E-01],
	[4.5900000000E+04, 4.4028519404E+01, 5.2819705495E+00, 2.6989121407E+01, 4.0146486681E+00, 9.8160921864E-01],
	[4.5905000000E+04, 4.4037026155E+01, 5.2820153205E+00, 2.6998781617E+01, 4.0149589429E+00, 9.8161718940E-01],
	[4.5910000000E+04, 4.4045533622E+01, 5.2820600869E+00, 2.7008444232E+01, 4.0152691415E+00, 9.8162515626E-01],
	[4.5915000000E+04, 4.4054041806E+01, 5.2821048489E+00, 2.7018109252E+01, 4.0155792639E+00, 9.8163311923E-01],
	[4.5920000000E+04, 4.4062550707E+01, 5.2821496064E+00, 2.7027776676E+01, 4.0158893101E+00, 9.8164107831E-01],
	[4.5925000000E+04, 4.4071060325E+01, 5.2821943593E+00, 2.7037446506E+01, 4.0161992802E+00, 9.8164903351E-01],
	[4.5930000000E+04, 4.4079570659E+01, 5.2822391078E+00, 2.7047118741E+01, 4.0165091742E+00, 9.8165698482E-01],
	[4.5935000000E+04, 4.4088081710E+01, 5.2822838518E+00, 2.7056793382E+01, 4.0168189921E+00, 9.8166493225E-01],
	[4.5940000000E+04, 4.4096593478E+01, 5.2823285913E+00, 2.7066470430E+01, 4.0171287339E+00, 9.8167287579E-01],
	[4.5945000000E+04, 4.4105105963E+01, 5.2823733263E+00, 2.7076149884E+01, 4.0174383996E+00, 9.8168081546E-01],
	[4.5950000000E+04, 4.4113619164E+01, 5.2824180568E+00, 2.7085831745E+01, 4.0177479893E+00, 9.8168875126E-01],
	[4.5955000000E+04, 4.4122133082E+01, 5.2824627828E+00, 2.7095516014E+01, 4.0180575030E+00, 9.8169668317E-01],
	[4.5960000000E+04, 4.4130647716E+01, 5.2825075044E+00, 2.7105202690E+01, 4.0183669407E+00, 9.8170461122E-01],
	[4.5965000000E+04, 4.4139163068E+01, 5.2825522214E+00, 2.7114891774E+01, 4.0186763025E+00, 9.8171253539E-01],
	[4.5970000000E+04, 4.4147679135E+01, 5.2825969340E+00, 2.7124583267E+01, 4.0189855883E+00, 9.8172045570E-01],
	[4.5975000000E+04, 4.4156195920E+01, 5.2826416421E+00, 2.7134277168E+01, 4.0192947981E+00, 9.8172837214E-01],
	[4.5980000000E+04, 4.4164713421E+01, 5.2826863457E+00, 2.7143973478E+01, 4.0196039321E+00, 9.8173628472E-01],
	[4.5985000000E+04, 4.4173231638E+01, 5.2827310448E+00, 2.7153672197E+01, 4.0199129901E+00, 9.8174419343E-01],
	[4.5990000000E+04, 4.4181750572E+01, 5.2827757394E+00, 2.7163373326E+01, 4.0202219723E+00, 9.8175209828E-01],
	[4.5995000000E+04, 4.4190270222E+01, 5.2828204295E+00, 2.7173076865E+01, 4.0205308786E+00, 9.8175999927E-01],
	[4.6000000000E+04, 4.4198790589E+01, 5.2828651152E+00, 2.7182782815E+01, 4.0208397091E+00, 9.8176789641E-01],
	[4.6005000000E+04, 4.4207311673E+01, 5.2829097964E+00, 2.7192491175E+01, 4.0211484638E+00, 9.8177578969E-01],
	[4.6010000000E+04, 4.4215833473E+01, 5.2829544731E+00, 2.7202201946E+01, 4.0214571427E+00, 9.8178367912E-01],
	[4.6015000000E+04, 4.4224355989E+01, 5.2829991454E+00, 2.7211915128E+01, 4.0217657458E+00, 9.8179156470E-01],
	[4.6020000000E+04, 4.4232879222E+01, 5.2830438131E+00, 2.7221630723E+01, 4.0220742732E+00, 9.8179944643E-01],
	[4.6025000000E+04, 4.4241403171E+01, 5.2830884764E+00, 2.7231348729E+01, 4.0223827248E+00, 9.8180732432E-01],
	[4.6030000000E+04, 4.4249927836E+01, 5.2831331352E+00, 2.7241069147E+01, 4.0226911008E+00, 9.8181519836E-01],
	[4.6035000000E+04, 4.4258465973E+01, 5.2831791983E+00, 2.7250791978E+01, 4.0230003232E+00, 9.8182306855E-01],
	[4.6040000000E+04, 4.4267008499E+01, 5.2832256620E+00, 2.7260517223E+01, 4.0233097356E+00, 9.8183093491E-01],
	[4.6045000000E+04, 4.4275551747E+01, 5.2832721212E+00, 2.7270244880E+01, 4.0236190724E+00, 9.8183879743E-01],
	[4.6050000000E+04, 4.4284095716E+01, 5.2833185757E+00, 2.7279974951E+01, 4.0239283337E+00, 9.8184665611E-01],
	[4.6055000000E+04, 4.4292640405E+01, 5.2833650256E+00, 2.7289707437E+01, 4.0242375197E+00, 9.8185451095E-01],
	[4.6060000000E+04, 4.4301185815E+01, 5.2834114708E+00, 2.7299442336E+01, 4.0245466302E+00, 9.8186236197E-01],
	[4.6065000000E+04, 4.4309731946E+01, 5.2834579114E+00, 2.7309179651E+01, 4.0248556653E+00, 9.8187020915E-01],
	[4.6070000000E+04, 4.4318278798E+01, 5.2835043474E+00, 2.7318919380E+01, 4.0251646250E+00, 9.8187805250E-01],
	[4.6075000000E+04, 4.4326826370E+01, 5.2835507787E+00, 2.7328661525E+01, 4.0254735094E+00, 9.8188589203E-01],
	[4.6080000000E+04, 4.4335374664E+01, 5.2835972054E+00, 2.7338406086E+01, 4.0257823184E+00, 9.8189372774E-01],
	[4.6085000000E+04, 4.4343923678E+01, 5.2836436275E+00, 2.7348153062E+01, 4.0260910521E+00, 9.8190155962E-01],
	[4.6090000000E+04, 4.4352473413E+01, 5.2836900450E+00, 2.7357902455E+01, 4.0263997105E+00, 9.8190938768E-01],
	[4.6095000000E+04, 4.4361023868E+01, 5.2837364578E+00, 2.7367654265E+01, 4.0267082936E+00, 9.8191721192E-01],
	[4.6100000000E+04, 4.4369575044E+01, 5.2837828660E+00, 2.7377408492E+01, 4.0270168015E+00, 9.8192503234E-01],
	[4.6105000000E+04, 4.4378126941E+01, 5.2838292696E+00, 2.7387165136E+01, 4.0273252341E+00, 9.8193284895E-01],
	[4.6110000000E+04, 4.4386679559E+01, 5.2838756685E+00, 2.7396924198E+01, 4.0276335915E+00, 9.8194066175E-01],
	[4.6115000000E+04, 4.4395232897E+01, 5.2839220628E+00, 2.7406685678E+01, 4.0279418737E+00, 9.8194847074E-01],
	[4.6120000000E+04, 4.4403786956E+01, 5.2839684525E+00, 2.7416449576E+01, 4.0282500807E+00, 9.8195627592E-01],
	[4.6125000000E+04, 4.4412341735E+01, 5.2840148376E+00, 2.7426215893E+01, 4.0285582126E+00, 9.8196407729E-01],
	[4.6130000000E+04, 4.4420897235E+01, 5.2840612181E+00, 2.7435984629E+01, 4.0288662693E+00, 9.8197187485E-01],
	[4.6135000000E+04, 4.4429453456E+01, 5.2841075939E+00, 2.7445755785E+01, 4.0291742510E+00, 9.8197966862E-01],
	[4.6140000000E+04, 4.4438010397E+01, 5.2841539651E+00, 2.7455529361E+01, 4.0294821575E+00, 9.8198745858E-01],
	[4.6145000000E+04, 4.4446568059E+01, 5.2842003317E+00, 2.7465305356E+01, 4.0297899889E+00, 9.8199524474E-01],
	[4.6150000000E+04, 4.4455126441E+01, 5.2842466937E+00, 2.7475083772E+01, 4.0300977453E+00, 9.8200302711E-01],
	[4.6155000000E+04, 4.4463685544E+01, 5.2842930511E+00, 2.7484864609E+01, 4.0304054267E+00, 9.8201080568E-01],
	[4.6160000000E+04, 4.4472245367E+01, 5.2843394038E+00, 2.7494647866E+01, 4.0307130330E+00, 9.8201858046E-01],
	[4.6165000000E+04, 4.4480805910E+01, 5.2843857520E+00, 2.7504433546E+01, 4.0310205643E+00, 9.8202635145E-01],
	[4.6170000000E+04, 4.4489367175E+01, 5.2844320955E+00, 2.7514221647E+01, 4.0313280207E+00, 9.8203411865E-01],
	[4.6175000000E+04, 4.4497929159E+01, 5.2844784344E+00, 2.7524012170E+01, 4.0316354021E+00, 9.8204188207E-01],
	[4.6180000000E+04, 4.4506491864E+01, 5.2845247687E+00, 2.7533805116E+01, 4.0319427085E+00, 9.8204964169E-01],
	[4.6185000000E+04, 4.4515055289E+01, 5.2845710984E+00, 2.7543600484E+01, 4.0322499401E+00, 9.8205739754E-01],
	[4.6190000000E+04, 4.4523619435E+01, 5.2846174235E+00, 2.7553398275E+01, 4.0325570968E+00, 9.8206514960E-01],
	[4.6195000000E+04, 4.4532184301E+01, 5.2846637440E+00, 2.7563198490E+01, 4.0328641785E+00, 9.8207289789E-01],
	[4.6200000000E+04, 4.4540749888E+01, 5.2847100598E+00, 2.7573001129E+01, 4.0331711855E+00, 9.8208064240E-01],
	[4.6205000000E+04, 4.4549316194E+01, 5.2847563711E+00, 2.7582806192E+01, 4.0334781176E+00, 9.8208838313E-01],
	[4.6210000000E+04, 4.4557883221E+01, 5.2848026778E+00, 2.7592613679E+01, 4.0337849748E+00, 9.8209612009E-01],
	[4.6215000000E+04, 4.4566450969E+01, 5.2848489798E+00, 2.7602423592E+01, 4.0340917573E+00, 9.8210385328E-01],
	[4.6220000000E+04, 4.4575019436E+01, 5.2848952773E+00, 2.7612235929E+01, 4.0343984650E+00, 9.8211158270E-01],
	[4.6225000000E+04, 4.4583588624E+01, 5.2849415701E+00, 2.7622050692E+01, 4.0347050980E+00, 9.8211930836E-01],
	[4.6230000000E+04, 4.4592158532E+01, 5.2849878584E+00, 2.7631867880E+01, 4.0350116562E+00, 9.8212703025E-01],
	[4.6235000000E+04, 4.4600729161E+01, 5.2850341420E+00, 2.7641687495E+01, 4.0353181397E+00, 9.8213474837E-01],
	[4.6240000000E+04, 4.4609300509E+01, 5.2850804210E+00, 2.7651509537E+01, 4.0356245485E+00, 9.8214246273E-01],
	[4.6245000000E+04, 4.4617872578E+01, 5.2851266955E+00, 2.7661334005E+01, 4.0359308826E+00, 9.8215017334E-01],
	[4.6250000000E+04, 4.4626445367E+01, 5.2851729653E+00, 2.7671160900E+01, 4.0362371421E+00, 9.8215788019E-01],
	[4.6255000000E+04, 4.4635018876E+01, 5.2852192306E+00, 2.7680990223E+01, 4.0365433270E+00, 9.8216558328E-01],
	[4.6260000000E+04, 4.4643593105E+01, 5.2852654912E+00, 2.7690821973E+01, 4.0368494372E+00, 9.8217328262E-01],
	[4.6265000000E+04, 4.4652168054E+01, 5.2853117473E+00, 2.7700656152E+01, 4.0371554728E+00, 9.8218097821E-01],
	[4.6270000000E+04, 4.4660743724E+01, 5.2853579988E+00, 2.7710492759E+01, 4.0374614339E+00, 9.8218867005E-01],
	[4.6275000000E+04, 4.4669320113E+01, 5.2854042456E+00, 2.7720331796E+01, 4.0377673204E+00, 9.8219635814E-01],
	[4.6280000000E+04, 4.4677897223E+01, 5.2854504879E+00, 2.7730173261E+01, 4.0380731324E+00, 9.8220404249E-01],
	[4.6285000000E+04, 4.4686475053E+01, 5.2854967256E+00, 2.7740017156E+01, 4.0383788699E+00, 9.8221172309E-01],
	[4.6290000000E+04, 4.4695053602E+01, 5.2855429587E+00, 2.7749863481E+01, 4.0386845329E+00, 9.8221939995E-01],
	[4.6295000000E+04, 4.4703632872E+01, 5.2855891872E+00, 2.7759712236E+01, 4.0389901214E+00, 9.8222707307E-01],
	[4.6300000000E+04, 4.4712212862E+01, 5.2856354111E+00, 2.7769563421E+01, 4.0392956354E+00, 9.8223474246E-01],
	[4.6305000000E+04, 4.4720793571E+01, 5.2856816305E+00, 2.7779417037E+01, 4.0396010750E+00, 9.8224240811E-01],
	[4.6310000000E+04, 4.4729375001E+01, 5.2857278452E+00, 2.7789273085E+01, 4.0399064403E+00, 9.8225007002E-01],
	[4.6315000000E+04, 4.4737957150E+01, 5.2857740554E+00, 2.7799131564E+01, 4.0402117311E+00, 9.8225772821E-01],
	[4.6320000000E+04, 4.4746540020E+01, 5.2858202610E+00, 2.7808992475E+01, 4.0405169475E+00, 9.8226538266E-01],
	[4.6325000000E+04, 4.4755123609E+01, 5.2858664620E+00, 2.7818855818E+01, 4.0408220896E+00, 9.8227303339E-01],
	[4.6330000000E+04, 4.4763707919E+01, 5.2859126584E+00, 2.7828721594E+01, 4.0411271574E+00, 9.8228068039E-01],
	[4.6335000000E+04, 4.4772292948E+01, 5.2859588502E+00, 2.7838589803E+01, 4.0414321508E+00, 9.8228832367E-01],
	[4.6340000000E+04, 4.4780878697E+01, 5.2860050374E+00, 2.7848460445E+01, 4.0417370700E+00, 9.8229596322E-01],
	[4.6345000000E+04, 4.4789465166E+01, 5.2860512201E+00, 2.7858333520E+01, 4.0420419149E+00, 9.8230359906E-01],
	[4.6350000000E+04, 4.4798052354E+01, 5.2860973982E+00, 2.7868209029E+01, 4.0423466855E+00, 9.8231123118E-01],
	[4.6355000000E+04, 4.4806640263E+01, 5.2861435717E+00, 2.7878086973E+01, 4.0426513819E+00, 9.8231885958E-01],
	[4.6360000000E+04, 4.4815228891E+01, 5.2861897407E+00, 2.7887967351E+01, 4.0429560041E+00, 9.8232648427E-01],
	[4.6365000000E+04, 4.4823818239E+01, 5.2862359050E+00, 2.7897850164E+01, 4.0432605521E+00, 9.8233410525E-01],
	[4.6370000000E+04, 4.4832408307E+01, 5.2862820648E+00, 2.7907735413E+01, 4.0435650259E+00, 9.8234172251E-01],
	[4.6375000000E+04, 4.4840999094E+01, 5.2863282200E+00, 2.7917623097E+01, 4.0438694256E+00, 9.8234933607E-01],
	[4.6380000000E+04, 4.4849590602E+01, 5.2863743707E+00, 2.7927513217E+01, 4.0441737511E+00, 9.8235694593E-01],
	[4.6385000000E+04, 4.4858182829E+01, 5.2864205167E+00, 2.7937405773E+01, 4.0444780026E+00, 9.8236455208E-01],
	[4.6390000000E+04, 4.4866775775E+01, 5.2864666582E+00, 2.7947300766E+01, 4.0447821799E+00, 9.8237215452E-01],
	[4.6395000000E+04, 4.4875369442E+01, 5.2865127951E+00, 2.7957198195E+01, 4.0450862832E+00, 9.8237975327E-01],
	[4.6400000000E+04, 4.4883963828E+01, 5.2865589275E+00, 2.7967098062E+01, 4.0453903124E+00, 9.8238734832E-01],
	[4.6405000000E+04, 4.4892558933E+01, 5.2866050553E+00, 2.7977000367E+01, 4.0456942676E+00, 9.8239493967E-01],
	[4.6410000000E+04, 4.4901154759E+01, 5.2866511785E+00, 2.7986905109E+01, 4.0459981488E+00, 9.8240252733E-01],
	[4.6415000000E+04, 4.4909751303E+01, 5.2866972972E+00, 2.7996812290E+01, 4.0463019560E+00, 9.8241011130E-01],
	[4.6420000000E+04, 4.4918348568E+01, 5.2867434112E+00, 2.8006721910E+01, 4.0466056892E+00, 9.8241769157E-01],
	[4.6425000000E+04, 4.4926946552E+01, 5.2867895208E+00, 2.8016633968E+01, 4.0469093485E+00, 9.8242526816E-01],
	[4.6430000000E+04, 4.4935545255E+01, 5.2868356257E+00, 2.8026548466E+01, 4.0472129338E+00, 9.8243284106E-01],
	[4.6435000000E+04, 4.4944144678E+01, 5.2868817261E+00, 2.8036465403E+01, 4.0475164452E+00, 9.8244041028E-01],
	[4.6440000000E+04, 4.4952744821E+01, 5.2869278220E+00, 2.8046384781E+01, 4.0478198828E+00, 9.8244797581E-01],
	[4.6445000000E+04, 4.4961345683E+01, 5.2869739132E+00, 2.8056306598E+01, 4.0481232464E+00, 9.8245553767E-01],
	[4.6450000000E+04, 4.4969947264E+01, 5.2870199999E+00, 2.8066230857E+01, 4.0484265362E+00, 9.8246309584E-01],
	[4.6455000000E+04, 4.4978549565E+01, 5.2870660821E+00, 2.8076157556E+01, 4.0487297522E+00, 9.8247065034E-01],
	[4.6460000000E+04, 4.4987152586E+01, 5.2871121597E+00, 2.8086086697E+01, 4.0490328944E+00, 9.8247820116E-01],
	[4.6465000000E+04, 4.4995756326E+01, 5.2871582327E+00, 2.8096018279E+01, 4.0493359628E+00, 9.8248574832E-01],
	[4.6470000000E+04, 4.5004360785E+01, 5.2872043012E+00, 2.8105952303E+01, 4.0496389574E+00, 9.8249329180E-01],
	[4.6475000000E+04, 4.5012965964E+01, 5.2872503651E+00, 2.8115888770E+01, 4.0499418782E+00, 9.8250083161E-01],
	[4.6480000000E+04, 4.5021571862E+01, 5.2872964245E+00, 2.8125827679E+01, 4.0502447254E+00, 9.8250836775E-01],
	[4.6485000000E+04, 4.5030178479E+01, 5.2873424793E+00, 2.8135769031E+01, 4.0505474988E+00, 9.8251590023E-01],
	[4.6490000000E+04, 4.5038785816E+01, 5.2873885296E+00, 2.8145712827E+01, 4.0508501985E+00, 9.8252342905E-01],
	[4.6495000000E+04, 4.5047393872E+01, 5.2874345753E+00, 2.8155659066E+01, 4.0511528246E+00, 9.8253095420E-01],
	[4.6500000000E+04, 4.5056002647E+01, 5.2874806165E+00, 2.8165607750E+01, 4.0514553770E+00, 9.8253847570E-01],
	[4.6505000000E+04, 4.5064612142E+01, 5.2875266531E+00, 2.8175558878E+01, 4.0517578557E+00, 9.8254599354E-01],
	[4.6510000000E+04, 4.5073222356E+01, 5.2875726852E+00, 2.8185512450E+01, 4.0520602609E+00, 9.8255350773E-01],
	[4.6515000000E+04, 4.5081833289E+01, 5.2876187127E+00, 2.8195468467E+01, 4.0523625925E+00, 9.8256101826E-01],
	[4.6520000000E+04, 4.5090444941E+01, 5.2876647357E+00, 2.8205426930E+01, 4.0526648505E+00, 9.8256852514E-01],
	[4.6525000000E+04, 4.5099057313E+01, 5.2877107541E+00, 2.8215387839E+01, 4.0529670349E+00, 9.8257602837E-01],
	[4.6530000000E+04, 4.5107670404E+01, 5.2877567680E+00, 2.8225351193E+01, 4.0532691458E+00, 9.8258352795E-01],
	[4.6535000000E+04, 4.5116284214E+01, 5.2878027773E+00, 2.8235316994E+01, 4.0535711832E+00, 9.8259102389E-01],
	[4.6540000000E+04, 4.5124898743E+01, 5.2878487821E+00, 2.8245285242E+01, 4.0538731472E+00, 9.8259851618E-01],
	[4.6545000000E+04, 4.5133513992E+01, 5.2878947824E+00, 2.8255255937E+01, 4.0541750376E+00, 9.8260600484E-01],
	[4.6550000000E+04, 4.5142129959E+01, 5.2879407781E+00, 2.8265229079E+01, 4.0544768546E+00, 9.8261348985E-01],
	[4.6555000000E+04, 4.5150746646E+01, 5.2879867693E+00, 2.8275204669E+01, 4.0547785982E+00, 9.8262097122E-01],
	[4.6560000000E+04, 4.5159364051E+01, 5.2880327559E+00, 2.8285182707E+01, 4.0550802683E+00, 9.8262844896E-01],
	[4.6565000000E+04, 4.5167982176E+01, 5.2880787380E+00, 2.8295163193E+01, 4.0553818651E+00, 9.8263592307E-01],
	[4.6570000000E+04, 4.5176601020E+01, 5.2881247155E+00, 2.8305146128E+01, 4.0556833885E+00, 9.8264339354E-01],
	[4.6575000000E+04, 4.5185220583E+01, 5.2881706886E+00, 2.8315131513E+01, 4.0559848385E+00, 9.8265086039E-01],
	[4.6580000000E+04, 4.5193840865E+01, 5.2882166571E+00, 2.8325119346E+01, 4.0562862152E+00, 9.8265832360E-01],
	[4.6585000000E+04, 4.5202461866E+01, 5.2882626210E+00, 2.8335109630E+01, 4.0565875186E+00, 9.8266578319E-01],
	[4.6590000000E+04, 4.5211083586E+01, 5.2883085804E+00, 2.8345102363E+01, 4.0568887487E+00, 9.8267323916E-01],
	[4.6595000000E+04, 4.5219706024E+01, 5.2883545353E+00, 2.8355097547E+01, 4.0571899055E+00, 9.8268069150E-01],
	[4.6600000000E+04, 4.5228329182E+01, 5.2884004857E+00, 2.8365095182E+01, 4.0574909891E+00, 9.8268814023E-01],
	[4.6605000000E+04, 4.5236953059E+01, 5.2884464315E+00, 2.8375095268E+01, 4.0577919994E+00, 9.8269558533E-01],
	[4.6610000000E+04, 4.5245577655E+01, 5.2884923728E+00, 2.8385097805E+01, 4.0580929366E+00, 9.8270302682E-01],
	[4.6615000000E+04, 4.5254202969E+01, 5.2885383095E+00, 2.8395102794E+01, 4.0583938005E+00, 9.8271046470E-01],
	[4.6620000000E+04, 4.5262829003E+01, 5.2885842418E+00, 2.8405110235E+01, 4.0586945913E+00, 9.8271789896E-01],
	[4.6625000000E+04, 4.5271455755E+01, 5.2886301695E+00, 2.8415120129E+01, 4.0589953089E+00, 9.8272532961E-01],
	[4.6630000000E+04, 4.5280083227E+01, 5.2886760927E+00, 2.8425132475E+01, 4.0592959534E+00, 9.8273275665E-01],
	[4.6635000000E+04, 4.5288711417E+01, 5.2887220113E+00, 2.8435147275E+01, 4.0595965248E+00, 9.8274018009E-01],
	[4.6640000000E+04, 4.5297340326E+01, 5.2887679255E+00, 2.8445164528E+01, 4.0598970230E+00, 9.8274759992E-01],
	[4.6645000000E+04, 4.5305969953E+01, 5.2888138351E+00, 2.8455184235E+01, 4.0601974482E+00, 9.8275501615E-01],
	[4.6650000000E+04, 4.5314600300E+01, 5.2888597402E+00, 2.8465206396E+01, 4.0604978004E+00, 9.8276242878E-01],
	[4.6655000000E+04, 4.5323231365E+01, 5.2889056407E+00, 2.8475231011E+01, 4.0607980795E+00, 9.8276983781E-01],
	[4.6660000000E+04, 4.5331863149E+01, 5.2889515368E+00, 2.8485258082E+01, 4.0610982856E+00, 9.8277724324E-01],
	[4.6665000000E+04, 4.5340495652E+01, 5.2889974283E+00, 2.8495287607E+01, 4.0613984187E+00, 9.8278464508E-01],
	[4.6670000000E+04, 4.5349128874E+01, 5.2890433153E+00, 2.8505319588E+01, 4.0616984788E+00, 9.8279204332E-01],
	[4.6675000000E+04, 4.5357762814E+01, 5.2890891978E+00, 2.8515354025E+01, 4.0619984660E+00, 9.8279943797E-01],
	[4.6680000000E+04, 4.5366397473E+01, 5.2891350758E+00, 2.8525390918E+01, 4.0622983803E+00, 9.8280682903E-01],
	[4.6685000000E+04, 4.5375032850E+01, 5.2891809492E+00, 2.8535430268E+01, 4.0625982216E+00, 9.8281421651E-01],
	[4.6690000000E+04, 4.5383668947E+01, 5.2892268182E+00, 2.8545472074E+01, 4.0628979901E+00, 9.8282160040E-01],
	[4.6695000000E+04, 4.5392305761E+01, 5.2892726826E+00, 2.8555516337E+01, 4.0631976856E+00, 9.8282898071E-01],
	[4.6700000000E+04, 4.5400943295E+01, 5.2893185425E+00, 2.8565563059E+01, 4.0634973083E+00, 9.8283635743E-01],
	[4.6705000000E+04, 4.5409581547E+01, 5.2893643979E+00, 2.8575612238E+01, 4.0637968582E+00, 9.8284373058E-01],
	[4.6710000000E+04, 4.5418220518E+01, 5.2894102488E+00, 2.8585663875E+01, 4.0640963353E+00, 9.8285110014E-01],
	[4.6715000000E+04, 4.5426860207E+01, 5.2894560952E+00, 2.8595717970E+01, 4.0643957395E+00, 9.8285846614E-01],
	[4.6720000000E+04, 4.5435500615E+01, 5.2895019370E+00, 2.8605774525E+01, 4.0646950710E+00, 9.8286582855E-01],
	[4.6725000000E+04, 4.5444141741E+01, 5.2895477744E+00, 2.8615833539E+01, 4.0649943298E+00, 9.8287318740E-01],
	[4.6730000000E+04, 4.5452783586E+01, 5.2895936073E+00, 2.8625895012E+01, 4.0652935158E+00, 9.8288054268E-01],
	[4.6735000000E+04, 4.5461426149E+01, 5.2896394356E+00, 2.8635958945E+01, 4.0655926291E+00, 9.8288789438E-01],
	[4.6740000000E+04, 4.5470069431E+01, 5.2896852594E+00, 2.8646025339E+01, 4.0658916696E+00, 9.8289524252E-01],
	[4.6745000000E+04, 4.5478713431E+01, 5.2897310788E+00, 2.8656094193E+01, 4.0661906376E+00, 9.8290258710E-01],
	[4.6750000000E+04, 4.5487358150E+01, 5.2897768936E+00, 2.8666165508E+01, 4.0664895328E+00, 9.8290992812E-01],
	[4.6755000000E+04, 4.5496003587E+01, 5.2898227039E+00, 2.8676239284E+01, 4.0667883554E+00, 9.8291726557E-01],
	[4.6760000000E+04, 4.5504649742E+01, 5.2898685098E+00, 2.8686315522E+01, 4.0670871054E+00, 9.8292459947E-01],
	[4.6765000000E+04, 4.5513296616E+01, 5.2899143111E+00, 2.8696394222E+01, 4.0673857828E+00, 9.8293192980E-01],
	[4.6770000000E+04, 4.5521944209E+01, 5.2899601079E+00, 2.8706475384E+01, 4.0676843877E+00, 9.8293925659E-01],
	[4.6775000000E+04, 4.5530601851E+01, 5.2900069102E+00, 2.8716559008E+01, 4.0679835916E+00, 9.8294657982E-01],
	[4.6780000000E+04, 4.5539267288E+01, 5.2900544731E+00, 2.8726645096E+01, 4.0682832323E+00, 9.8295389950E-01],
	[4.6785000000E+04, 4.5547933448E+01, 5.2901020314E+00, 2.8736733646E+01, 4.0685828005E+00, 9.8296121563E-01],
	[4.6790000000E+04, 4.5556600330E+01, 5.2901495850E+00, 2.8746824661E+01, 4.0688822964E+00, 9.8296852821E-01],
	[4.6795000000E+04, 4.5565267936E+01, 5.2901971340E+00, 2.8756918139E+01, 4.0691817199E+00, 9.8297583725E-01],
	[4.6800000000E+04, 4.5573936263E+01, 5.2902446784E+00, 2.8767014082E+01, 4.0694810712E+00, 9.8298314275E-01],
	[4.6805000000E+04, 4.5582605314E+01, 5.2902922180E+00, 2.8777112489E+01, 4.0697803502E+00, 9.8299044470E-01],
	[4.6810000000E+04, 4.5591275088E+01, 5.2903397531E+00, 2.8787213361E+01, 4.0700795569E+00, 9.8299774312E-01],
	[4.6815000000E+04, 4.5599945584E+01, 5.2903872835E+00, 2.8797316699E+01, 4.0703786913E+00, 9.8300503800E-01],
	[4.6820000000E+04, 4.5608616803E+01, 5.2904348092E+00, 2.8807422502E+01, 4.0706777536E+00, 9.8301232934E-01],
	[4.6825000000E+04, 4.5617288744E+01, 5.2904823303E+00, 2.8817530771E+01, 4.0709767436E+00, 9.8301961715E-01],
	[4.6830000000E+04, 4.5625961408E+01, 5.2905298467E+00, 2.8827641506E+01, 4.0712756614E+00, 9.8302690142E-01],
	[4.6835000000E+04, 4.5634634795E+01, 5.2905773585E+00, 2.8837754708E+01, 4.0715745071E+00, 9.8303418217E-01],
	[4.6840000000E+04, 4.5643308905E+01, 5.2906248657E+00, 2.8847870377E+01, 4.0718732806E+00, 9.8304145939E-01],
	[4.6845000000E+04, 4.5651983737E+01, 5.2906723682E+00, 2.8857988514E+01, 4.0721719820E+00, 9.8304873308E-01],
	[4.6850000000E+04, 4.5660659291E+01, 5.2907198660E+00, 2.8868109118E+01, 4.0724706113E+00, 9.8305600325E-01],
	[4.6855000000E+04, 4.5669335568E+01, 5.2907673592E+00, 2.8878232190E+01, 4.0727691685E+00, 9.8306326989E-01],
	[4.6860000000E+04, 4.5678012568E+01, 5.2908148478E+00, 2.8888357730E+01, 4.0730676536E+00, 9.8307053302E-01],
	[4.6865000000E+04, 4.5686690291E+01, 5.2908623317E+00, 2.8898485739E+01, 4.0733660667E+00, 9.8307779263E-01],
	[4.6870000000E+04, 4.5695368735E+01, 5.2909098110E+00, 2.8908616217E+01, 4.0736644077E+00, 9.8308504872E-01],
	[4.6875000000E+04, 4.5704047903E+01, 5.2909572857E+00, 2.8918749165E+01, 4.0739626767E+00, 9.8309230129E-01],
	[4.6880000000E+04, 4.5712727793E+01, 5.2910047557E+00, 2.8928884582E+01, 4.0742608737E+00, 9.8309955035E-01],
	[4.6885000000E+04, 4.5721408405E+01, 5.2910522211E+00, 2.8939022469E+01, 4.0745589988E+00, 9.8310679591E-01],
	[4.6890000000E+04, 4.5730089740E+01, 5.2910996818E+00, 2.8949162827E+01, 4.0748570519E+00, 9.8311403795E-01],
	[4.6895000000E+04, 4.5738771797E+01, 5.2911471379E+00, 2.8959305655E+01, 4.0751550331E+00, 9.8312127649E-01],
	[4.6900000000E+04, 4.5747454576E+01, 5.2911945894E+00, 2.8969450954E+01, 4.0754529424E+00, 9.8312851152E-01],
	[4.6905000000E+04, 4.5756138078E+01, 5.2912420362E+00, 2.8979598725E+01, 4.0757507797E+00, 9.8313574304E-01],
	[4.6910000000E+04, 4.5764822303E+01, 5.2912894785E+00, 2.8989748968E+01, 4.0760485452E+00, 9.8314297107E-01],
	[4.6915000000E+04, 4.5773507250E+01, 5.2913369160E+00, 2.8999901682E+01, 4.0763462388E+00, 9.8315019560E-01],
	[4.6920000000E+04, 4.5782192919E+01, 5.2913843490E+00, 2.9010056869E+01, 4.0766438607E+00, 9.8315741663E-01],
	[4.6925000000E+04, 4.5790879310E+01, 5.2914317773E+00, 2.9020214529E+01, 4.0769414106E+00, 9.8316463416E-01],
	[4.6930000000E+04, 4.5799566424E+01, 5.2914792010E+00, 2.9030374661E+01, 4.0772388888E+00, 9.8317184820E-01],
	[4.6935000000E+04, 4.5808254260E+01, 5.2915266201E+00, 2.9040537267E+01, 4.0775362952E+00, 9.8317905875E-01],
	[4.6940000000E+04, 4.5816942818E+01, 5.2915740345E+00, 2.9050702347E+01, 4.0778336299E+00, 9.8318626580E-01],
	[4.6945000000E+04, 4.5825632099E+01, 5.2916214443E+00, 2.9060869901E+01, 4.0781308928E+00, 9.8319346937E-01],
	[4.6950000000E+04, 4.5834322102E+01, 5.2916688495E+00, 2.9071039930E+01, 4.0784280840E+00, 9.8320066946E-01],
	[4.6955000000E+04, 4.5843012827E+01, 5.2917162501E+00, 2.9081212433E+01, 4.0787252035E+00, 9.8320786606E-01],
	[4.6960000000E+04, 4.5851704274E+01, 5.2917636460E+00, 2.9091387411E+01, 4.0790222514E+00, 9.8321505917E-01],
	[4.6965000000E+04, 4.5860396444E+01, 5.2918110373E+00, 2.9101564865E+01, 4.0793192275E+00, 9.8322224881E-01],
	[4.6970000000E+04, 4.5869089336E+01, 5.2918584240E+00, 2.9111744794E+01, 4.0796161320E+00, 9.8322943497E-01],
	[4.6975000000E+04, 4.5877782950E+01, 5.2919058061E+00, 2.9121927200E+01, 4.0799129650E+00, 9.8323661765E-01],
	[4.6980000000E+04, 4.5886477286E+01, 5.2919531835E+00, 2.9132112082E+01, 4.0802097263E+00, 9.8324379685E-01],
	[4.6985000000E+04, 4.5895172344E+01, 5.2920005564E+00, 2.9142299441E+01, 4.0805064160E+00, 9.8325097259E-01],
	[4.6990000000E+04, 4.5903868124E+01, 5.2920479246E+00, 2.9152489277E+01, 4.0808030342E+00, 9.8325814485E-01],
	[4.6995000000E+04, 4.5912564626E+01, 5.2920952882E+00, 2.9162681590E+01, 4.0810995808E+00, 9.8326531364E-01],
	[4.7000000000E+04, 4.5921261851E+01, 5.2921426472E+00, 2.9172876382E+01, 4.0813960559E+00, 9.8327247896E-01],
	[4.7005000000E+04, 4.5929959798E+01, 5.2921900016E+00, 2.9183073651E+01, 4.0816924595E+00, 9.8327964082E-01],
	[4.7010000000E+04, 4.5938658466E+01, 5.2922373514E+00, 2.9193273399E+01, 4.0819887916E+00, 9.8328679922E-01],
	[4.7015000000E+04, 4.5947357857E+01, 5.2922846965E+00, 2.9203475626E+01, 4.0822850522E+00, 9.8329395415E-01],
	[4.7020000000E+04, 4.5956057969E+01, 5.2923320371E+00, 2.9213680332E+01, 4.0825812414E+00, 9.8330110563E-01],
	[4.7025000000E+04, 4.5964758804E+01, 5.2923793730E+00, 2.9223887517E+01, 4.0828773592E+00, 9.8330825364E-01],
	[4.7030000000E+04, 4.5973460361E+01, 5.2924267043E+00, 2.9234097183E+01, 4.0831734056E+00, 9.8331539820E-01],
	[4.7035000000E+04, 4.5982162639E+01, 5.2924740310E+00, 2.9244309328E+01, 4.0834693806E+00, 9.8332253931E-01],
	[4.7040000000E+04, 4.5990865640E+01, 5.2925213531E+00, 2.9254523954E+01, 4.0837652842E+00, 9.8332967697E-01],
	[4.7045000000E+04, 4.5999569362E+01, 5.2925686706E+00, 2.9264741061E+01, 4.0840611165E+00, 9.8333681117E-01],
	[4.7050000000E+04, 4.6008273807E+01, 5.2926159835E+00, 2.9274960649E+01, 4.0843568774E+00, 9.8334394192E-01],
	[4.7055000000E+04, 4.6016978973E+01, 5.2926632918E+00, 2.9285182719E+01, 4.0846525671E+00, 9.8335106923E-01],
	[4.7060000000E+04, 4.6025684861E+01, 5.2927105955E+00, 2.9295407270E+01, 4.0849481854E+00, 9.8335819310E-01],
	[4.7065000000E+04, 4.6034391471E+01, 5.2927578946E+00, 2.9305634304E+01, 4.0852437325E+00, 9.8336531352E-01],
	[4.7070000000E+04, 4.6043098803E+01, 5.2928051891E+00, 2.9315863820E+01, 4.0855392084E+00, 9.8337243050E-01],
	[4.7075000000E+04, 4.6051806857E+01, 5.2928524789E+00, 2.9326095819E+01, 4.0858346130E+00, 9.8337954404E-01],
	[4.7080000000E+04, 4.6060515632E+01, 5.2928997642E+00, 2.9336330302E+01, 4.0861299464E+00, 9.8338665414E-01],
	[4.7085000000E+04, 4.6069225130E+01, 5.2929470449E+00, 2.9346567268E+01, 4.0864252086E+00, 9.8339376081E-01],
	[4.7090000000E+04, 4.6077935349E+01, 5.2929943210E+00, 2.9356806718E+01, 4.0867203996E+00, 9.8340086404E-01],
	[4.7095000000E+04, 4.6086646289E+01, 5.2930415925E+00, 2.9367048652E+01, 4.0870155195E+00, 9.8340796384E-01],
	[4.7100000000E+04, 4.6095357952E+01, 5.2930888594E+00, 2.9377293070E+01, 4.0873105682E+00, 9.8341506022E-01],
	[4.7105000000E+04, 4.6104070336E+01, 5.2931361217E+00, 2.9387539974E+01, 4.0876055459E+00, 9.8342215316E-01],
	[4.7110000000E+04, 4.6112783442E+01, 5.2931833794E+00, 2.9397789363E+01, 4.0879004524E+00, 9.8342924268E-01],
	[4.7115000000E+04, 4.6121497270E+01, 5.2932306325E+00, 2.9408041237E+01, 4.0881952879E+00, 9.8343632878E-01],
	[4.7120000000E+04, 4.6130211820E+01, 5.2932778810E+00, 2.9418295598E+01, 4.0884900523E+00, 9.8344341145E-01],
	[4.7125000000E+04, 4.6138927091E+01, 5.2933251249E+00, 2.9428552444E+01, 4.0887847457E+00, 9.8345049070E-01],
	[4.7130000000E+04, 4.6147643083E+01, 5.2933723642E+00, 2.9438811778E+01, 4.0890793681E+00, 9.8345756653E-01],
	[4.7135000000E+04, 4.6156359798E+01, 5.2934195990E+00, 2.9449073598E+01, 4.0893739194E+00, 9.8346463895E-01],
	[4.7140000000E+04, 4.6165077234E+01, 5.2934668291E+00, 2.9459337905E+01, 4.0896683998E+00, 9.8347170795E-01],
	[4.7145000000E+04, 4.6173795391E+01, 5.2935140547E+00, 2.9469604701E+01, 4.0899628092E+00, 9.8347877354E-01],
	[4.7150000000E+04, 4.6182514270E+01, 5.2935612756E+00, 2.9479873984E+01, 4.0902571477E+00, 9.8348583572E-01],
	[4.7155000000E+04, 4.6191233871E+01, 5.2936084920E+00, 2.9490145755E+01, 4.0905514153E+00, 9.8349289449E-01],
	[4.7160000000E+04, 4.6199954193E+01, 5.2936557038E+00, 2.9500420015E+01, 4.0908456120E+00, 9.8349994985E-01],
	[4.7165000000E+04, 4.6208675237E+01, 5.2937029111E+00, 2.9510696765E+01, 4.0911397378E+00, 9.8350700180E-01],
	[4.7170000000E+04, 4.6217397002E+01, 5.2937501137E+00, 2.9520976003E+01, 4.0914337927E+00, 9.8351405036E-01],
	[4.7175000000E+04, 4.6226119489E+01, 5.2937973118E+00, 2.9531257731E+01, 4.0917277768E+00, 9.8352109551E-01],
	[4.7180000000E+04, 4.6234842697E+01, 5.2938445052E+00, 2.9541541949E+01, 4.0920216901E+00, 9.8352813726E-01],
	[4.7185000000E+04, 4.6243566627E+01, 5.2938916941E+00, 2.9551828658E+01, 4.0923155326E+00, 9.8353517561E-01],
	[4.7190000000E+04, 4.6252291278E+01, 5.2939388784E+00, 2.9562117857E+01, 4.0926093043E+00, 9.8354221056E-01],
	[4.7195000000E+04, 4.6261016651E+01, 5.2939860582E+00, 2.9572409547E+01, 4.0929030052E+00, 9.8354924212E-01],
	[4.7200000000E+04, 4.6269742745E+01, 5.2940332333E+00, 2.9582703728E+01, 4.0931966354E+00, 9.8355627029E-01],
	[4.7205000000E+04, 4.6278469560E+01, 5.2940804039E+00, 2.9593000401E+01, 4.0934901948E+00, 9.8356329507E-01],
	[4.7210000000E+04, 4.6287197097E+01, 5.2941275699E+00, 2.9603299567E+01, 4.0937836836E+00, 9.8357031646E-01],
	[4.7215000000E+04, 4.6295925355E+01, 5.2941747313E+00, 2.9613601224E+01, 4.0940771016E+00, 9.8357733446E-01],
	[4.7220000000E+04, 4.6304654335E+01, 5.2942218882E+00, 2.9623905375E+01, 4.0943704490E+00, 9.8358434908E-01],
	[4.7225000000E+04, 4.6313384036E+01, 5.2942690405E+00, 2.9634212018E+01, 4.0946637258E+00, 9.8359136031E-01],
	[4.7230000000E+04, 4.6322114458E+01, 5.2943161882E+00, 2.9644521155E+01, 4.0949569319E+00, 9.8359836817E-01],
	[4.7235000000E+04, 4.6330845601E+01, 5.2943633313E+00, 2.9654832785E+01, 4.0952500674E+00, 9.8360537264E-01],
	[4.7240000000E+04, 4.6339577466E+01, 5.2944104699E+00, 2.9665146910E+01, 4.0955431324E+00, 9.8361237374E-01],
	[4.7245000000E+04, 4.6348310052E+01, 5.2944576039E+00, 2.9675463529E+01, 4.0958361267E+00, 9.8361937146E-01],
	[4.7250000000E+04, 4.6357043359E+01, 5.2945047333E+00, 2.9685782643E+01, 4.0961290505E+00, 9.8362636580E-01],
	[4.7255000000E+04, 4.6365777387E+01, 5.2945518582E+00, 2.9696104251E+01, 4.0964219038E+00, 9.8363335677E-01],
	[4.7260000000E+04, 4.6374512137E+01, 5.2945989785E+00, 2.9706428356E+01, 4.0967146866E+00, 9.8364034438E-01],
	[4.7265000000E+04, 4.6383247608E+01, 5.2946460942E+00, 2.9716754956E+01, 4.0970073989E+00, 9.8364732861E-01],
	[4.7270000000E+04, 4.6391983800E+01, 5.2946932054E+00, 2.9727084052E+01, 4.0973000407E+00, 9.8365430948E-01],
	[4.7275000000E+04, 4.6400720713E+01, 5.2947403120E+00, 2.9737415644E+01, 4.0975926120E+00, 9.8366128698E-01],
	[4.7280000000E+04, 4.6409458347E+01, 5.2947874140E+00, 2.9747749734E+01, 4.0978851129E+00, 9.8366826112E-01],
	[4.7285000000E+04, 4.6418196702E+01, 5.2948345115E+00, 2.9758086320E+01, 4.0981775434E+00, 9.8367523190E-01],
	[4.7290000000E+04, 4.6426935779E+01, 5.2948816044E+00, 2.9768425404E+01, 4.0984699035E+00, 9.8368219932E-01],
	[4.7295000000E+04, 4.6435675576E+01, 5.2949286928E+00, 2.9778766986E+01, 4.0987621932E+00, 9.8368916339E-01],
	[4.7300000000E+04, 4.6444416095E+01, 5.2949757766E+00, 2.9789111065E+01, 4.0990544126E+00, 9.8369612409E-01],
	[4.7305000000E+04, 4.6453157335E+01, 5.2950228558E+00, 2.9799457644E+01, 4.0993465616E+00, 9.8370308145E-01],
	[4.7310000000E+04, 4.6461899296E+01, 5.2950699305E+00, 2.9809806721E+01, 4.0996386404E+00, 9.8371003545E-01],
	[4.7315000000E+04, 4.6470641977E+01, 5.2951170006E+00, 2.9820158297E+01, 4.0999306488E+00, 9.8371698610E-01],
	[4.7320000000E+04, 4.6479385380E+01, 5.2951640662E+00, 2.9830512373E+01, 4.1002225869E+00, 9.8372393340E-01],
	[4.7325000000E+04, 4.6488129504E+01, 5.2952111272E+00, 2.9840868949E+01, 4.1005144548E+00, 9.8373087736E-01],
	[4.7330000000E+04, 4.6496874349E+01, 5.2952581837E+00, 2.9851228024E+01, 4.1008062524E+00, 9.8373781797E-01],
	[4.7335000000E+04, 4.6505619915E+01, 5.2953052356E+00, 2.9861589601E+01, 4.1010979798E+00, 9.8374475524E-01],
	[4.7340000000E+04, 4.6514366201E+01, 5.2953522829E+00, 2.9871953678E+01, 4.1013896370E+00, 9.8375168917E-01],
	[4.7345000000E+04, 4.6523113209E+01, 5.2953993257E+00, 2.9882320256E+01, 4.1016812241E+00, 9.8375861976E-01],
	[4.7350000000E+04, 4.6531860937E+01, 5.2954463640E+00, 2.9892689336E+01, 4.1019727409E+00, 9.8376554702E-01],
	[4.7355000000E+04, 4.6540609387E+01, 5.2954933977E+00, 2.9903060918E+01, 4.1022641876E+00, 9.8377247094E-01],
	[4.7360000000E+04, 4.6549358557E+01, 5.2955404269E+00, 2.9913435002E+01, 4.1025555642E+00, 9.8377939152E-01],
	[4.7365000000E+04, 4.6558108448E+01, 5.2955874515E+00, 2.9923811588E+01, 4.1028468707E+00, 9.8378630877E-01],
	[4.7370000000E+04, 4.6566859060E+01, 5.2956344715E+00, 2.9934190677E+01, 4.1031381071E+00, 9.8379322270E-01],
	[4.7375000000E+04, 4.6575610393E+01, 5.2956814871E+00, 2.9944572270E+01, 4.1034292734E+00, 9.8380013329E-01],
	[4.7380000000E+04, 4.6584362446E+01, 5.2957284980E+00, 2.9954956366E+01, 4.1037203697E+00, 9.8380704056E-01],
	[4.7385000000E+04, 4.6593115221E+01, 5.2957755045E+00, 2.9965342966E+01, 4.1040113960E+00, 9.8381394450E-01],
	[4.7390000000E+04, 4.6601868716E+01, 5.2958225064E+00, 2.9975732071E+01, 4.1043023522E+00, 9.8382084513E-01],
	[4.7395000000E+04, 4.6610622932E+01, 5.2958695037E+00, 2.9986123679E+01, 4.1045932385E+00, 9.8382774243E-01],
	[4.7400000000E+04, 4.6619377869E+01, 5.2959164965E+00, 2.9996517793E+01, 4.1048840548E+00, 9.8383463641E-01],
	[4.7405000000E+04, 4.6628133526E+01, 5.2959634848E+00, 3.0006914412E+01, 4.1051748011E+00, 9.8384152708E-01],
	[4.7410000000E+04, 4.6636889904E+01, 5.2960104685E+00, 3.0017313537E+01, 4.1054654775E+00, 9.8384841443E-01],
	[4.7415000000E+04, 4.6645647003E+01, 5.2960574477E+00, 3.0027715167E+01, 4.1057560840E+00, 9.8385529846E-01],
	[4.7420000000E+04, 4.6654404822E+01, 5.2961044224E+00, 3.0038119304E+01, 4.1060466206E+00, 9.8386217919E-01],
	[4.7425000000E+04, 4.6663163362E+01, 5.2961513925E+00, 3.0048525948E+01, 4.1063370873E+00, 9.8386905660E-01],
	[4.7430000000E+04, 4.6671922623E+01, 5.2961983581E+00, 3.0058935098E+01, 4.1066274841E+00, 9.8387593071E-01],
	[4.7435000000E+04, 4.6680682605E+01, 5.2962453191E+00, 3.0069346756E+01, 4.1069178112E+00, 9.8388280151E-01],
	[4.7440000000E+04, 4.6689443307E+01, 5.2962922756E+00, 3.0079760921E+01, 4.1072080684E+00, 9.8388966901E-01],
	[4.7445000000E+04, 4.6698204729E+01, 5.2963392276E+00, 3.0090177595E+01, 4.1074982558E+00, 9.8389653321E-01],
	[4.7450000000E+04, 4.6706966872E+01, 5.2963861750E+00, 3.0100596776E+01, 4.1077883734E+00, 9.8390339410E-01],
	[4.7455000000E+04, 4.6715729736E+01, 5.2964331180E+00, 3.0111018467E+01, 4.1080784213E+00, 9.8391025170E-01],
	[4.7460000000E+04, 4.6724493320E+01, 5.2964800564E+00, 3.0121442666E+01, 4.1083683994E+00, 9.8391710600E-01],
	[4.7465000000E+04, 4.6733257625E+01, 5.2965269902E+00, 3.0131869375E+01, 4.1086583078E+00, 9.8392395700E-01],
	[4.7470000000E+04, 4.6742022650E+01, 5.2965739195E+00, 3.0142298593E+01, 4.1089481465E+00, 9.8393080471E-01],
	[4.7475000000E+04, 4.6750788396E+01, 5.2966208444E+00, 3.0152730321E+01, 4.1092379155E+00, 9.8393764913E-01],
	[4.7480000000E+04, 4.6759554862E+01, 5.2966677646E+00, 3.0163164560E+01, 4.1095276149E+00, 9.8394449026E-01],
	[4.7485000000E+04, 4.6768322049E+01, 5.2967146804E+00, 3.0173601309E+01, 4.1098172446E+00, 9.8395132810E-01],
	[4.7490000000E+04, 4.6777089956E+01, 5.2967615916E+00, 3.0184040569E+01, 4.1101068047E+00, 9.8395816265E-01],
	[4.7495000000E+04, 4.6785858584E+01, 5.2968084983E+00, 3.0194482341E+01, 4.1103962951E+00, 9.8396499392E-01],
	[4.7500000000E+04, 4.6794627932E+01, 5.2968554005E+00, 3.0204926625E+01, 4.1106857160E+00, 9.8397182191E-01],
	[4.7505000000E+04, 4.6803398000E+01, 5.2969022982E+00, 3.0215373420E+01, 4.1109750674E+00, 9.8397864662E-01],
	[4.7510000000E+04, 4.6812168789E+01, 5.2969491913E+00, 3.0225822728E+01, 4.1112643491E+00, 9.8398546805E-01],
	[4.7515000000E+04, 4.6820940298E+01, 5.2969960799E+00, 3.0236274549E+01, 4.1115535614E+00, 9.8399228620E-01],
	[4.7520000000E+04, 4.6829712527E+01, 5.2970429640E+00, 3.0246728882E+01, 4.1118427041E+00, 9.8399910108E-01],
	[4.7525000000E+04, 4.6838485477E+01, 5.2970898436E+00, 3.0257185729E+01, 4.1121317774E+00, 9.8400591268E-01],
	[4.7530000000E+04, 4.6847275125E+01, 5.2971384129E+00, 3.0267645090E+01, 4.1124219254E+00, 9.8401272102E-01],
	[4.7535000000E+04, 4.6856065903E+01, 5.2971870206E+00, 3.0278106965E+01, 4.1127120332E+00, 9.8401952608E-01],
	[4.7540000000E+04, 4.6864857406E+01, 5.2972356235E+00, 3.0288571354E+01, 4.1130020716E+00, 9.8402632787E-01],
	[4.7545000000E+04, 4.6873649633E+01, 5.2972842218E+00, 3.0299038258E+01, 4.1132920408E+00, 9.8403312640E-01],
	[4.7550000000E+04, 4.6882442585E+01, 5.2973328154E+00, 3.0309507677E+01, 4.1135819408E+00, 9.8403992166E-01],
	[4.7555000000E+04, 4.6891236262E+01, 5.2973814044E+00, 3.0319979612E+01, 4.1138717715E+00, 9.8404671366E-01],
	[4.7560000000E+04, 4.6900030663E+01, 5.2974299887E+00, 3.0330454062E+01, 4.1141615329E+00, 9.8405350241E-01],
	[4.7565000000E+04, 4.6908825789E+01, 5.2974785683E+00, 3.0340931029E+01, 4.1144512252E+00, 9.8406028789E-01],
	[4.7570000000E+04, 4.6917621640E+01, 5.2975271433E+00, 3.0351410512E+01, 4.1147408483E+00, 9.8406707011E-01],
	[4.7575000000E+04, 4.6926418215E+01, 5.2975757136E+00, 3.0361892512E+01, 4.1150304023E+00, 9.8407384908E-01],
	[4.7580000000E+04, 4.6935215515E+01, 5.2976242793E+00, 3.0372377029E+01, 4.1153198871E+00, 9.8408062480E-01],
	[4.7585000000E+04, 4.6944013539E+01, 5.2976728403E+00, 3.0382864063E+01, 4.1156093028E+00, 9.8408739726E-01],
	[4.7590000000E+04, 4.6952812288E+01, 5.2977213966E+00, 3.0393353615E+01, 4.1158986493E+00, 9.8409416647E-01],
	[4.7595000000E+04, 4.6961611761E+01, 5.2977699483E+00, 3.0403845686E+01, 4.1161879268E+00, 9.8410093244E-01],
	[4.7600000000E+04, 4.6970411959E+01, 5.2978184953E+00, 3.0414340274E+01, 4.1164771353E+00, 9.8410769516E-01],
	[4.7605000000E+04, 4.6979212881E+01, 5.2978670377E+00, 3.0424837382E+01, 4.1167662746E+00, 9.8411445463E-01],
	[4.7610000000E+04, 4.6988014528E+01, 5.2979155754E+00, 3.0435337009E+01, 4.1170553450E+00, 9.8412121086E-01],
	[4.7615000000E+04, 4.6996816899E+01, 5.2979641085E+00, 3.0445839155E+01, 4.1173443464E+00, 9.8412796385E-01],
	[4.7620000000E+04, 4.7005619995E+01, 5.2980126369E+00, 3.0456343822E+01, 4.1176332787E+00, 9.8413471360E-01],
	[4.7625000000E+04, 4.7014423815E+01, 5.2980611607E+00, 3.0466851008E+01, 4.1179221421E+00, 9.8414146011E-01],
	[4.7630000000E+04, 4.7023228359E+01, 5.2981096798E+00, 3.0477360715E+01, 4.1182109365E+00, 9.8414820338E-01],
	[4.7635000000E+04, 4.7032033628E+01, 5.2981581943E+00, 3.0487872943E+01, 4.1184996620E+00, 9.8415494341E-01],
	[4.7640000000E+04, 4.7040839621E+01, 5.2982067041E+00, 3.0498387692E+01, 4.1187883186E+00, 9.8416168022E-01],
	[4.7645000000E+04, 4.7049646338E+01, 5.2982552093E+00, 3.0508904962E+01, 4.1190769063E+00, 9.8416841378E-01],
	[4.7650000000E+04, 4.7058453780E+01, 5.2983037098E+00, 3.0519424755E+01, 4.1193654252E+00, 9.8417514412E-01],
	[4.7655000000E+04, 4.7067261946E+01, 5.2983522057E+00, 3.0529947070E+01, 4.1196538751E+00, 9.8418187123E-01],
	[4.7660000000E+04, 4.7076070837E+01, 5.2984006969E+00, 3.0540471907E+01, 4.1199422563E+00, 9.8418859511E-01],
	[4.7665000000E+04, 4.7084880451E+01, 5.2984491835E+00, 3.0550999267E+01, 4.1202305686E+00, 9.8419531576E-01],
	[4.7670000000E+04, 4.7093690790E+01, 5.2984976655E+00, 3.0561529151E+01, 4.1205188121E+00, 9.8420203319E-01],
	[4.7675000000E+04, 4.7102501854E+01, 5.2985461428E+00, 3.0572061558E+01, 4.1208069868E+00, 9.8420874740E-01],
	[4.7680000000E+04, 4.7111313641E+01, 5.2985946155E+00, 3.0582596489E+01, 4.1210950928E+00, 9.8421545838E-01],
	[4.7685000000E+04, 4.7120126153E+01, 5.2986430835E+00, 3.0593133944E+01, 4.1213831300E+00, 9.8422216615E-01],
	[4.7690000000E+04, 4.7128939389E+01, 5.2986915469E+00, 3.0603673924E+01, 4.1216710985E+00, 9.8422887069E-01],
	[4.7695000000E+04, 4.7137753349E+01, 5.2987400056E+00, 3.0614216429E+01, 4.1219589983E+00, 9.8423557202E-01],
	[4.7700000000E+04, 4.7146568033E+01, 5.2987884597E+00, 3.0624761459E+01, 4.1222468294E+00, 9.8424227014E-01],
	[4.7705000000E+04, 4.7155383441E+01, 5.2988369092E+00, 3.0635309015E+01, 4.1225345919E+00, 9.8424896504E-01],
	[4.7710000000E+04, 4.7164199574E+01, 5.2988853541E+00, 3.0645859096E+01, 4.1228222857E+00, 9.8425565672E-01],
	[4.7715000000E+04, 4.7173016430E+01, 5.2989337943E+00, 3.0656411704E+01, 4.1231099109E+00, 9.8426234520E-01],
	[4.7720000000E+04, 4.7181834011E+01, 5.2989822299E+00, 3.0666966839E+01, 4.1233974674E+00, 9.8426903047E-01],
	[4.7725000000E+04, 4.7190652316E+01, 5.2990306608E+00, 3.0677524501E+01, 4.1236849554E+00, 9.8427571253E-01],
	[4.7730000000E+04, 4.7199471345E+01, 5.2990790871E+00, 3.0688084690E+01, 4.1239723748E+00, 9.8428239139E-01],
	[4.7735000000E+04, 4.7208291098E+01, 5.2991275088E+00, 3.0698647406E+01, 4.1242597256E+00, 9.8428906704E-01],
	[4.7740000000E+04, 4.7217111575E+01, 5.2991759259E+00, 3.0709212651E+01, 4.1245470079E+00, 9.8429573948E-01],
	[4.7745000000E+04, 4.7225932776E+01, 5.2992243383E+00, 3.0719780424E+01, 4.1248342217E+00, 9.8430240873E-01],
	[4.7750000000E+04, 4.7234754701E+01, 5.2992727461E+00, 3.0730350726E+01, 4.1251213670E+00, 9.8430907478E-01],
	[4.7755000000E+04, 4.7243577350E+01, 5.2993211493E+00, 3.0740923557E+01, 4.1254084438E+00, 9.8431573763E-01],
	[4.7760000000E+04, 4.7252400722E+01, 5.2993695478E+00, 3.0751498917E+01, 4.1256954522E+00, 9.8432239728E-01],
	[4.7765000000E+04, 4.7261224819E+01, 5.2994179418E+00, 3.0762076806E+01, 4.1259823921E+00, 9.8432905374E-01],
	[4.7770000000E+04, 4.7270049640E+01, 5.2994663311E+00, 3.0772657226E+01, 4.1262692636E+00, 9.8433570701E-01],
	[4.7775000000E+04, 4.7278875185E+01, 5.2995147158E+00, 3.0783240177E+01, 4.1265560667E+00, 9.8434235708E-01],
	[4.7780000000E+04, 4.7287701454E+01, 5.2995630958E+00, 3.0793825658E+01, 4.1268428014E+00, 9.8434900397E-01],
	[4.7785000000E+04, 4.7296528446E+01, 5.2996114713E+00, 3.0804413670E+01, 4.1271294678E+00, 9.8435564766E-01],
	[4.7790000000E+04, 4.7305356163E+01, 5.2996598421E+00, 3.0815004213E+01, 4.1274160658E+00, 9.8436228817E-01],
	[4.7795000000E+04, 4.7314184603E+01, 5.2997082083E+00, 3.0825597288E+01, 4.1277025955E+00, 9.8436892549E-01],
	[4.7800000000E+04, 4.7323013767E+01, 5.2997565698E+00, 3.0836192896E+01, 4.1279890568E+00, 9.8437555963E-01],
	[4.7805000000E+04, 4.7331843655E+01, 5.2998049268E+00, 3.0846791035E+01, 4.1282754499E+00, 9.8438219059E-01],
	[4.7810000000E+04, 4.7340674267E+01, 5.2998532792E+00, 3.0857391708E+01, 4.1285617747E+00, 9.8438881837E-01],
	[4.7815000000E+04, 4.7349505602E+01, 5.2999016269E+00, 3.0867994914E+01, 4.1288480313E+00, 9.8439544297E-01],
	[4.7820000000E+04, 4.7358337661E+01, 5.2999499700E+00, 3.0878600653E+01, 4.1291342196E+00, 9.8440206439E-01],
	[4.7825000000E+04, 4.7367170444E+01, 5.2999983085E+00, 3.0889208926E+01, 4.1294203397E+00, 9.8440868263E-01],
	[4.7830000000E+04, 4.7376003951E+01, 5.3000466424E+00, 3.0899819733E+01, 4.1297063916E+00, 9.8441529770E-01],
	[4.7835000000E+04, 4.7384838182E+01, 5.3000949717E+00, 3.0910433074E+01, 4.1299923754E+00, 9.8442190960E-01],
	[4.7840000000E+04, 4.7393673136E+01, 5.3001432963E+00, 3.0921048950E+01, 4.1302782909E+00, 9.8442851833E-01],
	[4.7845000000E+04, 4.7402508814E+01, 5.3001916164E+00, 3.0931667362E+01, 4.1305641384E+00, 9.8443512388E-01],
	[4.7850000000E+04, 4.7411345215E+01, 5.3002399318E+00, 3.0942288309E+01, 4.1308499177E+00, 9.8444172627E-01],
	[4.7855000000E+04, 4.7420182341E+01, 5.3002882427E+00, 3.0952911791E+01, 4.1311356289E+00, 9.8444832549E-01],
	[4.7860000000E+04, 4.7429020190E+01, 5.3003365489E+00, 3.0963537810E+01, 4.1314212721E+00, 9.8445492155E-01],
	[4.7865000000E+04, 4.7437858762E+01, 5.3003848506E+00, 3.0974166366E+01, 4.1317068472E+00, 9.8446151445E-01],
	[4.7870000000E+04, 4.7446698058E+01, 5.3004331476E+00, 3.0984797458E+01, 4.1319923542E+00, 9.8446810418E-01],
	[4.7875000000E+04, 4.7455538078E+01, 5.3004814400E+00, 3.0995431087E+01, 4.1322777932E+00, 9.8447469075E-01],
	[4.7880000000E+04, 4.7464378821E+01, 5.3005297278E+00, 3.1006067254E+01, 4.1325631642E+00, 9.8448127417E-01],
	[4.7885000000E+04, 4.7473220288E+01, 5.3005780110E+00, 3.1016705959E+01, 4.1328484672E+00, 9.8448785442E-01],
	[4.7890000000E+04, 4.7482062478E+01, 5.3006262896E+00, 3.1027347202E+01, 4.1331337022E+00, 9.8449443153E-01],
	[4.7895000000E+04, 4.7490905392E+01, 5.3006745636E+00, 3.1037990984E+01, 4.1334188693E+00, 9.8450100547E-01],
	[4.7900000000E+04, 4.7499749030E+01, 5.3007228331E+00, 3.1048637305E+01, 4.1337039685E+00, 9.8450757627E-01],
	[4.7905000000E+04, 4.7508593391E+01, 5.3007710979E+00, 3.1059286164E+01, 4.1339889997E+00, 9.8451414391E-01],
	[4.7910000000E+04, 4.7517438475E+01, 5.3008193581E+00, 3.1069937564E+01, 4.1342739631E+00, 9.8452070841E-01],
	[4.7915000000E+04, 4.7526284283E+01, 5.3008676137E+00, 3.1080591503E+01, 4.1345588586E+00, 9.8452726976E-01],
	[4.7920000000E+04, 4.7535130814E+01, 5.3009158647E+00, 3.1091247982E+01, 4.1348436862E+00, 9.8453382796E-01],
	[4.7925000000E+04, 4.7543978069E+01, 5.3009641111E+00, 3.1101907003E+01, 4.1351284460E+00, 9.8454038302E-01],
	[4.7930000000E+04, 4.7552826047E+01, 5.3010123530E+00, 3.1112568564E+01, 4.1354131379E+00, 9.8454693494E-01],
	[4.7935000000E+04, 4.7561674749E+01, 5.3010605902E+00, 3.1123232666E+01, 4.1356977621E+00, 9.8455348371E-01],
	[4.7940000000E+04, 4.7570524174E+01, 5.3011088229E+00, 3.1133899310E+01, 4.1359823185E+00, 9.8456002934E-01],
	[4.7945000000E+04, 4.7579374322E+01, 5.3011570509E+00, 3.1144568496E+01, 4.1362668071E+00, 9.8456657184E-01],
	[4.7950000000E+04, 4.7588225194E+01, 5.3012052744E+00, 3.1155240224E+01, 4.1365512280E+00, 9.8457311120E-01],
	[4.7955000000E+04, 4.7597076789E+01, 5.3012534932E+00, 3.1165914495E+01, 4.1368355811E+00, 9.8457964742E-01],
	[4.7960000000E+04, 4.7605929107E+01, 5.3013017075E+00, 3.1176591308E+01, 4.1371198666E+00, 9.8458618052E-01],
	[4.7965000000E+04, 4.7614782149E+01, 5.3013499172E+00, 3.1187270666E+01, 4.1374040843E+00, 9.8459271047E-01],
	[4.7970000000E+04, 4.7623635913E+01, 5.3013981223E+00, 3.1197952566E+01, 4.1376882344E+00, 9.8459923730E-01],
	[4.7975000000E+04, 4.7632490402E+01, 5.3014463229E+00, 3.1208637011E+01, 4.1379723168E+00, 9.8460576100E-01],
	[4.7980000000E+04, 4.7641345613E+01, 5.3014945188E+00, 3.1219324000E+01, 4.1382563317E+00, 9.8461228158E-01],
	[4.7985000000E+04, 4.7650201548E+01, 5.3015427102E+00, 3.1230013534E+01, 4.1385402788E+00, 9.8461879903E-01],
	[4.7990000000E+04, 4.7659058205E+01, 5.3015908969E+00, 3.1240705613E+01, 4.1388241584E+00, 9.8462531335E-01],
	[4.7995000000E+04, 4.7667915586E+01, 5.3016390791E+00, 3.1251400237E+01, 4.1391079705E+00, 9.8463182455E-01],
	[4.8000000000E+04, 4.7676773691E+01, 5.3016872567E+00, 3.1262097407E+01, 4.1393917149E+00, 9.8463833263E-01],
	[4.8005000000E+04, 4.7685632518E+01, 5.3017354298E+00, 3.1272797122E+01, 4.1396753918E+00, 9.8464483759E-01],
	[4.8010000000E+04, 4.7694492069E+01, 5.3017835982E+00, 3.1283499385E+01, 4.1399590012E+00, 9.8465133943E-01],
	[4.8015000000E+04, 4.7703352342E+01, 5.3018317621E+00, 3.1294204194E+01, 4.1402425432E+00, 9.8465783816E-01],
	[4.8020000000E+04, 4.7712213339E+01, 5.3018799214E+00, 3.1304911550E+01, 4.1405260176E+00, 9.8466433377E-01],
	[4.8025000000E+04, 4.7721075059E+01, 5.3019280761E+00, 3.1315621453E+01, 4.1408094245E+00, 9.8467082627E-01],
	[4.8030000000E+04, 4.7729937502E+01, 5.3019762262E+00, 3.1326333904E+01, 4.1410927640E+00, 9.8467731566E-01],
	[4.8035000000E+04, 4.7738800668E+01, 5.3020243718E+00, 3.1337048904E+01, 4.1413760361E+00, 9.8468380194E-01],
	[4.8040000000E+04, 4.7747664557E+01, 5.3020725128E+00, 3.1347766451E+01, 4.1416592408E+00, 9.8469028511E-01],
	[4.8045000000E+04, 4.7756529169E+01, 5.3021206492E+00, 3.1358486548E+01, 4.1419423781E+00, 9.8469676517E-01],
	[4.8050000000E+04, 4.7765394505E+01, 5.3021687810E+00, 3.1369209193E+01, 4.1422254480E+00, 9.8470324213E-01],
	[4.8055000000E+04, 4.7774260563E+01, 5.3022169083E+00, 3.1379934388E+01, 4.1425084506E+00, 9.8470971598E-01],
	[4.8060000000E+04, 4.7783127344E+01, 5.3022650310E+00, 3.1390662133E+01, 4.1427913858E+00, 9.8471618673E-01],
	[4.8065000000E+04, 4.7791994848E+01, 5.3023131491E+00, 3.1401392428E+01, 4.1430742537E+00, 9.8472265439E-01],
	[4.8070000000E+04, 4.7800863075E+01, 5.3023612627E+00, 3.1412125273E+01, 4.1433570544E+00, 9.8472911894E-01],
	[4.8075000000E+04, 4.7809732025E+01, 5.3024093717E+00, 3.1422860669E+01, 4.1436397877E+00, 9.8473558039E-01],
	[4.8080000000E+04, 4.7818601698E+01, 5.3024574761E+00, 3.1433598617E+01, 4.1439224538E+00, 9.8474203875E-01],
	[4.8085000000E+04, 4.7827472094E+01, 5.3025055760E+00, 3.1444339116E+01, 4.1442050527E+00, 9.8474849402E-01],
	[4.8090000000E+04, 4.7836343213E+01, 5.3025536713E+00, 3.1455082166E+01, 4.1444875843E+00, 9.8475494619E-01],
	[4.8095000000E+04, 4.7845215055E+01, 5.3026017620E+00, 3.1465827769E+01, 4.1447700487E+00, 9.8476139527E-01],
	[4.8100000000E+04, 4.7854087619E+01, 5.3026498482E+00, 3.1476575924E+01, 4.1450524460E+00, 9.8476784126E-01],
	[4.8105000000E+04, 4.7862960906E+01, 5.3026979298E+00, 3.1487326633E+01, 4.1453347760E+00, 9.8477428416E-01],
	[4.8110000000E+04, 4.7871834917E+01, 5.3027460068E+00, 3.1498079894E+01, 4.1456170390E+00, 9.8478072398E-01],
	[4.8115000000E+04, 4.7880709650E+01, 5.3027940793E+00, 3.1508835709E+01, 4.1458992348E+00, 9.8478716071E-01],
	[4.8120000000E+04, 4.7889585105E+01, 5.3028421473E+00, 3.1519594078E+01, 4.1461813635E+00, 9.8479359436E-01],
	[4.8125000000E+04, 4.7898461284E+01, 5.3028902106E+00, 3.1530355000E+01, 4.1464634251E+00, 9.8480002492E-01],
	[4.8130000000E+04, 4.7907338185E+01, 5.3029382694E+00, 3.1541118478E+01, 4.1467454196E+00, 9.8480645241E-01],
	[4.8135000000E+04, 4.7916215809E+01, 5.3029863237E+00, 3.1551884510E+01, 4.1470273471E+00, 9.8481287682E-01],
	[4.8140000000E+04, 4.7925094156E+01, 5.3030343734E+00, 3.1562653098E+01, 4.1473092075E+00, 9.8481929815E-01],
	[4.8145000000E+04, 4.7933973226E+01, 5.3030824185E+00, 3.1573424241E+01, 4.1475910010E+00, 9.8482571640E-01],
	[4.8150000000E+04, 4.7942853018E+01, 5.3031304591E+00, 3.1584197940E+01, 4.1478727274E+00, 9.8483213158E-01],
	[4.8155000000E+04, 4.7951733533E+01, 5.3031784952E+00, 3.1594974196E+01, 4.1481543868E+00, 9.8483854369E-01],
	[4.8160000000E+04, 4.7960614770E+01, 5.3032265266E+00, 3.1605753008E+01, 4.1484359793E+00, 9.8484495273E-01],
	[4.8165000000E+04, 4.7969496730E+01, 5.3032745536E+00, 3.1616534377E+01, 4.1487175049E+00, 9.8485135869E-01],
	[4.8170000000E+04, 4.7978379413E+01, 5.3033225760E+00, 3.1627318303E+01, 4.1489989635E+00, 9.8485776159E-01],
	[4.8175000000E+04, 4.7987262819E+01, 5.3033705938E+00, 3.1638104787E+01, 4.1492803552E+00, 9.8486416143E-01],
	[4.8180000000E+04, 4.7996146947E+01, 5.3034186071E+00, 3.1648893829E+01, 4.1495616801E+00, 9.8487055820E-01],
	[4.8185000000E+04, 4.8005031797E+01, 5.3034666158E+00, 3.1659685429E+01, 4.1498429380E+00, 9.8487695190E-01],
	[4.8190000000E+04, 4.8013917371E+01, 5.3035146200E+00, 3.1670479587E+01, 4.1501241291E+00, 9.8488334255E-01],
	[4.8195000000E+04, 4.8022803666E+01, 5.3035626196E+00, 3.1681276305E+01, 4.1504052534E+00, 9.8488973013E-01],
	[4.8200000000E+04, 4.8031690685E+01, 5.3036106147E+00, 3.1692075582E+01, 4.1506863109E+00, 9.8489611466E-01],
	[4.8205000000E+04, 4.8040578426E+01, 5.3036586053E+00, 3.1702877419E+01, 4.1509673016E+00, 9.8490249612E-01],
	[4.8210000000E+04, 4.8049466889E+01, 5.3037065913E+00, 3.1713681816E+01, 4.1512482255E+00, 9.8490887454E-01],
	[4.8215000000E+04, 4.8058356075E+01, 5.3037545728E+00, 3.1724488773E+01, 4.1515290827E+00, 9.8491524990E-01],
	[4.8220000000E+04, 4.8067245983E+01, 5.3038025497E+00, 3.1735298290E+01, 4.1518098731E+00, 9.8492162220E-01],
	[4.8225000000E+04, 4.8076136614E+01, 5.3038505221E+00, 3.1746110369E+01, 4.1520905968E+00, 9.8492799146E-01],
	[4.8230000000E+04, 4.8085027967E+01, 5.3038984899E+00, 3.1756925009E+01, 4.1523712537E+00, 9.8493435767E-01],
	[4.8235000000E+04, 4.8093920042E+01, 5.3039464532E+00, 3.1767742211E+01, 4.1526518441E+00, 9.8494072083E-01],
	[4.8240000000E+04, 4.8102812840E+01, 5.3039944120E+00, 3.1778561975E+01, 4.1529323677E+00, 9.8494708094E-01],
	[4.8245000000E+04, 4.8111706361E+01, 5.3040423662E+00, 3.1789384301E+01, 4.1532128247E+00, 9.8495343801E-01],
	[4.8250000000E+04, 4.8120600603E+01, 5.3040903159E+00, 3.1800209190E+01, 4.1534932151E+00, 9.8495979203E-01],
	[4.8255000000E+04, 4.8129495569E+01, 5.3041382611E+00, 3.1811036643E+01, 4.1537735388E+00, 9.8496614302E-01],
	[4.8260000000E+04, 4.8138391256E+01, 5.3041862017E+00, 3.1821866658E+01, 4.1540537960E+00, 9.8497249096E-01],
	[4.8265000000E+04, 4.8147287666E+01, 5.3042341378E+00, 3.1832699237E+01, 4.1543339866E+00, 9.8497883587E-01],
	[4.8270000000E+04, 4.8156184798E+01, 5.3042820694E+00, 3.1843534381E+01, 4.1546141107E+00, 9.8498517774E-01],
	[4.8275000000E+04, 4.8165082652E+01, 5.3043299964E+00, 3.1854372088E+01, 4.1548941682E+00, 9.8499151657E-01],
	[4.8280000000E+04, 4.8173981229E+01, 5.3043779189E+00, 3.1865212361E+01, 4.1551741592E+00, 9.8499785237E-01],
	[4.8285000000E+04, 4.8182880528E+01, 5.3044258369E+00, 3.1876055199E+01, 4.1554540837E+00, 9.8500418514E-01],
	[4.8290000000E+04, 4.8191780549E+01, 5.3044737503E+00, 3.1886900602E+01, 4.1557339417E+00, 9.8501051488E-01],
	[4.8295000000E+04, 4.8200696953E+01, 5.3045232867E+00, 3.1897748571E+01, 4.1560148488E+00, 9.8501684159E-01],
	[4.8300000000E+04, 4.8209614782E+01, 5.3045728910E+00, 3.1908599106E+01, 4.1562957392E+00, 9.8502316527E-01],
	[4.8305000000E+04, 4.8218533338E+01, 5.3046224906E+00, 3.1919452208E+01, 4.1565765633E+00, 9.8502948593E-01],
	[4.8310000000E+04, 4.8227452620E+01, 5.3046720855E+00, 3.1930307876E+01, 4.1568573212E+00, 9.8503580356E-01],
	[4.8315000000E+04, 4.8236372628E+01, 5.3047216758E+00, 3.1941166112E+01, 4.1571380128E+00, 9.8504211817E-01],
	[4.8320000000E+04, 4.8245293364E+01, 5.3047712614E+00, 3.1952026915E+01, 4.1574186382E+00, 9.8504842975E-01],
	[4.8325000000E+04, 4.8254214825E+01, 5.3048208423E+00, 3.1962890286E+01, 4.1576991974E+00, 9.8505473832E-01],
	[4.8330000000E+04, 4.8263137013E+01, 5.3048704186E+00, 3.1973756225E+01, 4.1579796903E+00, 9.8506104387E-01],
	[4.8335000000E+04, 4.8272059928E+01, 5.3049199902E+00, 3.1984624732E+01, 4.1582601171E+00, 9.8506734640E-01],
	[4.8340000000E+04, 4.8280983569E+01, 5.3049695571E+00, 3.1995495809E+01, 4.1585404777E+00, 9.8507364592E-01],
	[4.8345000000E+04, 4.8289907936E+01, 5.3050191194E+00, 3.2006369455E+01, 4.1588207721E+00, 9.8507994242E-01],
	[4.8350000000E+04, 4.8298833030E+01, 5.3050686770E+00, 3.2017245670E+01, 4.1591010005E+00, 9.8508623591E-01],
	[4.8355000000E+04, 4.8307758850E+01, 5.3051182300E+00, 3.2028124455E+01, 4.1593811627E+00, 9.8509252639E-01],
	[4.8360000000E+04, 4.8316685397E+01, 5.3051677783E+00, 3.2039005811E+01, 4.1596612588E+00, 9.8509881387E-01],
	[4.8365000000E+04, 4.8325612669E+01, 5.3052173219E+00, 3.2049889736E+01, 4.1599412889E+00, 9.8510509833E-01],
	[4.8370000000E+04, 4.8334540669E+01, 5.3052668609E+00, 3.2060776233E+01, 4.1602212529E+00, 9.8511137979E-01],
	[4.8375000000E+04, 4.8343469394E+01, 5.3053163952E+00, 3.2071665302E+01, 4.1605011508E+00, 9.8511765824E-01],
	[4.8380000000E+04, 4.8352398846E+01, 5.3053659248E+00, 3.2082556941E+01, 4.1607809828E+00, 9.8512393369E-01],
	[4.8385000000E+04, 4.8361329024E+01, 5.3054154498E+00, 3.2093451153E+01, 4.1610607487E+00, 9.8513020615E-01],
	[4.8390000000E+04, 4.8370259929E+01, 5.3054649702E+00, 3.2104347937E+01, 4.1613404487E+00, 9.8513647560E-01],
	[4.8395000000E+04, 4.8379191560E+01, 5.3055144859E+00, 3.2115247294E+01, 4.1616200827E+00, 9.8514274205E-01],
	[4.8400000000E+04, 4.8388123916E+01, 5.3055639969E+00, 3.2126149223E+01, 4.1618996507E+00, 9.8514900550E-01],
	[4.8405000000E+04, 4.8397057000E+01, 5.3056135033E+00, 3.2137053726E+01, 4.1621791528E+00, 9.8515526596E-01],
	[4.8410000000E+04, 4.8405990809E+01, 5.3056630050E+00, 3.2147960803E+01, 4.1624585891E+00, 9.8516152343E-01],
	[4.8415000000E+04, 4.8414925345E+01, 5.3057125021E+00, 3.2158870453E+01, 4.1627379594E+00, 9.8516777791E-01],
	[4.8420000000E+04, 4.8423860606E+01, 5.3057619945E+00, 3.2169782678E+01, 4.1630172638E+00, 9.8517402939E-01],
	[4.8425000000E+04, 4.8432796594E+01, 5.3058114823E+00, 3.2180697478E+01, 4.1632965024E+00, 9.8518027789E-01],
	[4.8430000000E+04, 4.8441733308E+01, 5.3058609654E+00, 3.2191614852E+01, 4.1635756752E+00, 9.8518652340E-01],
	[4.8435000000E+04, 4.8450670749E+01, 5.3059104439E+00, 3.2202534802E+01, 4.1638547821E+00, 9.8519276592E-01],
	[4.8440000000E+04, 4.8459608915E+01, 5.3059599178E+00, 3.2213457328E+01, 4.1641338233E+00, 9.8519900546E-01],
	[4.8445000000E+04, 4.8468547807E+01, 5.3060093870E+00, 3.2224382429E+01, 4.1644127986E+00, 9.8520524201E-01],
	[4.8450000000E+04, 4.8477487426E+01, 5.3060588515E+00, 3.2235310107E+01, 4.1646917082E+00, 9.8521147559E-01],
	[4.8455000000E+04, 4.8486427771E+01, 5.3061083114E+00, 3.2246240362E+01, 4.1649705521E+00, 9.8521770618E-01],
	[4.8460000000E+04, 4.8495368841E+01, 5.3061577667E+00, 3.2257173194E+01, 4.1652493302E+00, 9.8522393380E-01],
	[4.8465000000E+04, 4.8504310638E+01, 5.3062072173E+00, 3.2268108603E+01, 4.1655280427E+00, 9.8523015844E-01],
	[4.8470000000E+04, 4.8513253161E+01, 5.3062566633E+00, 3.2279046590E+01, 4.1658066894E+00, 9.8523638010E-01],
	[4.8475000000E+04, 4.8522196409E+01, 5.3063061047E+00, 3.2289987155E+01, 4.1660852705E+00, 9.8524259879E-01],
	[4.8480000000E+04, 4.8531140384E+01, 5.3063555414E+00, 3.2300930298E+01, 4.1663637859E+00, 9.8524881451E-01],
	[4.8485000000E+04, 4.8540085085E+01, 5.3064049734E+00, 3.2311876020E+01, 4.1666422356E+00, 9.8525502726E-01],
	[4.8490000000E+04, 4.8549030511E+01, 5.3064544009E+00, 3.2322824322E+01, 4.1669206198E+00, 9.8526123704E-01],
	[4.8495000000E+04, 4.8557976664E+01, 5.3065038237E+00, 3.2333775202E+01, 4.1671989384E+00, 9.8526744385E-01],
	[4.8500000000E+04, 4.8566923542E+01, 5.3065532418E+00, 3.2344728663E+01, 4.1674771913E+00, 9.8527364770E-01],
	[4.8505000000E+04, 4.8575871147E+01, 5.3066026553E+00, 3.2355684704E+01, 4.1677553788E+00, 9.8527984858E-01],
	[4.8510000000E+04, 4.8584819477E+01, 5.3066520642E+00, 3.2366643325E+01, 4.1680335006E+00, 9.8528604650E-01],
	[4.8515000000E+04, 4.8593768533E+01, 5.3067014685E+00, 3.2377604527E+01, 4.1683115570E+00, 9.8529224145E-01],
	[4.8520000000E+04, 4.8602718315E+01, 5.3067508681E+00, 3.2388568310E+01, 4.1685895478E+00, 9.8529843345E-01],
	[4.8525000000E+04, 4.8611668823E+01, 5.3068002631E+00, 3.2399534675E+01, 4.1688674732E+00, 9.8530462249E-01],
	[4.8530000000E+04, 4.8620620057E+01, 5.3068496535E+00, 3.2410503621E+01, 4.1691453331E+00, 9.8531080857E-01],
	[4.8535000000E+04, 4.8629572016E+01, 5.3068990392E+00, 3.2421475150E+01, 4.1694231275E+00, 9.8531699170E-01],
	[4.8540000000E+04, 4.8638524702E+01, 5.3069484203E+00, 3.2432449261E+01, 4.1697008565E+00, 9.8532317188E-01],
	[4.8545000000E+04, 4.8647478113E+01, 5.3069977968E+00, 3.2443425955E+01, 4.1699785201E+00, 9.8532934910E-01],
	[4.8550000000E+04, 4.8656432250E+01, 5.3070471687E+00, 3.2454405232E+01, 4.1702561182E+00, 9.8533552337E-01],
	[4.8555000000E+04, 4.8665387112E+01, 5.3070965359E+00, 3.2465387093E+01, 4.1705336510E+00, 9.8534169469E-01],
	[4.8560000000E+04, 4.8674342701E+01, 5.3071458985E+00, 3.2476371538E+01, 4.1708111185E+00, 9.8534786306E-01],
	[4.8565000000E+04, 4.8683299015E+01, 5.3071952565E+00, 3.2487358566E+01, 4.1710885206E+00, 9.8535402849E-01],
	[4.8570000000E+04, 4.8692256055E+01, 5.3072446099E+00, 3.2498348180E+01, 4.1713658573E+00, 9.8536019098E-01],
	[4.8575000000E+04, 4.8701213820E+01, 5.3072939586E+00, 3.2509340378E+01, 4.1716431288E+00, 9.8536635052E-01],
	[4.8580000000E+04, 4.8710172311E+01, 5.3073433027E+00, 3.2520335162E+01, 4.1719203350E+00, 9.8537250712E-01],
	[4.8585000000E+04, 4.8719131528E+01, 5.3073926422E+00, 3.2531332531E+01, 4.1721974759E+00, 9.8537866078E-01],
	[4.8590000000E+04, 4.8728091470E+01, 5.3074419771E+00, 3.2542332486E+01, 4.1724745515E+00, 9.8538481150E-01],
	[4.8595000000E+04, 4.8737052138E+01, 5.3074913074E+00, 3.2553335028E+01, 4.1727515619E+00, 9.8539095928E-01],
	[4.8600000000E+04, 4.8746013532E+01, 5.3075406330E+00, 3.2564340156E+01, 4.1730285071E+00, 9.8539710413E-01],
	[4.8605000000E+04, 4.8754975651E+01, 5.3075899541E+00, 3.2575347871E+01, 4.1733053871E+00, 9.8540324604E-01],
	[4.8610000000E+04, 4.8763938496E+01, 5.3076392705E+00, 3.2586358173E+01, 4.1735822019E+00, 9.8540938503E-01],
	[4.8615000000E+04, 4.8772902067E+01, 5.3076885823E+00, 3.2597371063E+01, 4.1738589516E+00, 9.8541552108E-01],
	[4.8620000000E+04, 4.8781866362E+01, 5.3077378895E+00, 3.2608386541E+01, 4.1741356361E+00, 9.8542165420E-01],
	[4.8625000000E+04, 4.8790831384E+01, 5.3077871921E+00, 3.2619404608E+01, 4.1744122555E+00, 9.8542778440E-01],
	[4.8630000000E+04, 4.8799797131E+01, 5.3078364900E+00, 3.2630425263E+01, 4.1746888098E+00, 9.8543391167E-01],
	[4.8635000000E+04, 4.8808763603E+01, 5.3078857834E+00, 3.2641448507E+01, 4.1749652990E+00, 9.8544003601E-01],
	[4.8640000000E+04, 4.8817730801E+01, 5.3079350721E+00, 3.2652474340E+01, 4.1752417231E+00, 9.8544615743E-01],
	[4.8645000000E+04, 4.8826698725E+01, 5.3079843563E+00, 3.2663502763E+01, 4.1755180822E+00, 9.8545227593E-01],
	[4.8650000000E+04, 4.8835667374E+01, 5.3080336358E+00, 3.2674533776E+01, 4.1757943762E+00, 9.8545839151E-01],
	[4.8655000000E+04, 4.8844636748E+01, 5.3080829107E+00, 3.2685567380E+01, 4.1760706052E+00, 9.8546450417E-01],
	[4.8660000000E+04, 4.8853606848E+01, 5.3081321810E+00, 3.2696603574E+01, 4.1763467692E+00, 9.8547061391E-01],
	[4.8665000000E+04, 4.8862577673E+01, 5.3081814467E+00, 3.2707642359E+01, 4.1766228682E+00, 9.8547672074E-01],
	[4.8670000000E+04, 4.8871549223E+01, 5.3082307078E+00, 3.2718683736E+01, 4.1768989023E+00, 9.8548282465E-01],
	[4.8675000000E+04, 4.8880521499E+01, 5.3082799643E+00, 3.2729727704E+01, 4.1771748714E+00, 9.8548892565E-01],
	[4.8680000000E+04, 4.8889494500E+01, 5.3083292162E+00, 3.2740774265E+01, 4.1774507756E+00, 9.8549502374E-01],
	[4.8685000000E+04, 4.8898468227E+01, 5.3083784635E+00, 3.2751823418E+01, 4.1777266149E+00, 9.8550111892E-01],
	[4.8690000000E+04, 4.8907442679E+01, 5.3084277062E+00, 3.2762875163E+01, 4.1780023893E+00, 9.8550721120E-01],
	[4.8695000000E+04, 4.8916417856E+01, 5.3084769443E+00, 3.2773929502E+01, 4.1782780989E+00, 9.8551330056E-01],
	[4.8700000000E+04, 4.8925393758E+01, 5.3085261778E+00, 3.2784986434E+01, 4.1785537435E+00, 9.8551938702E-01],
	[4.8705000000E+04, 4.8934370386E+01, 5.3085754067E+00, 3.2796045960E+01, 4.1788293234E+00, 9.8552547058E-01],
	[4.8710000000E+04, 4.8943347739E+01, 5.3086246310E+00, 3.2807108081E+01, 4.1791048384E+00, 9.8553155124E-01],
	[4.8715000000E+04, 4.8952325817E+01, 5.3086738507E+00, 3.2818172795E+01, 4.1793802886E+00, 9.8553762899E-01],
	[4.8720000000E+04, 4.8961304621E+01, 5.3087230659E+00, 3.2829240105E+01, 4.1796556740E+00, 9.8554370385E-01],
	[4.8725000000E+04, 4.8970284149E+01, 5.3087722764E+00, 3.2840310009E+01, 4.1799309947E+00, 9.8554977581E-01],
	[4.8730000000E+04, 4.8979264403E+01, 5.3088214823E+00, 3.2851382510E+01, 4.1802062506E+00, 9.8555584487E-01],
	[4.8735000000E+04, 4.8988245382E+01, 5.3088706836E+00, 3.2862457606E+01, 4.1804814418E+00, 9.8556191104E-01],
	[4.8740000000E+04, 4.8997227086E+01, 5.3089198804E+00, 3.2873535298E+01, 4.1807565683E+00, 9.8556797431E-01],
	[4.8745000000E+04, 4.9006209516E+01, 5.3089690725E+00, 3.2884615587E+01, 4.1810316301E+00, 9.8557403470E-01],
	[4.8750000000E+04, 4.9015192670E+01, 5.3090182601E+00, 3.2895698472E+01, 4.1813066272E+00, 9.8558009219E-01],
	[4.8755000000E+04, 4.9024176550E+01, 5.3090674431E+00, 3.2906783955E+01, 4.1815815597E+00, 9.8558614680E-01],
	[4.8760000000E+04, 4.9033161155E+01, 5.3091166214E+00, 3.2917872036E+01, 4.1818564275E+00, 9.8559219852E-01],
	[4.8765000000E+04, 4.9042146484E+01, 5.3091657952E+00, 3.2928962714E+01, 4.1821312308E+00, 9.8559824735E-01],
	[4.8770000000E+04, 4.9051132539E+01, 5.3092149644E+00, 3.2940055990E+01, 4.1824059694E+00, 9.8560429330E-01],
	[4.8775000000E+04, 4.9060119319E+01, 5.3092641291E+00, 3.2951151866E+01, 4.1826806434E+00, 9.8561033637E-01],
	[4.8780000000E+04, 4.9069106824E+01, 5.3093132891E+00, 3.2962250340E+01, 4.1829552528E+00, 9.8561637656E-01],
	[4.8785000000E+04, 4.9078095054E+01, 5.3093624446E+00, 3.2973351413E+01, 4.1832297978E+00, 9.8562241386E-01],
	[4.8790000000E+04, 4.9087084009E+01, 5.3094115954E+00, 3.2984455086E+01, 4.1835042781E+00, 9.8562844829E-01],
	[4.8795000000E+04, 4.9096073689E+01, 5.3094607417E+00, 3.2995561359E+01, 4.1837786940E+00, 9.8563447985E-01],
	[4.8800000000E+04, 4.9105064094E+01, 5.3095098834E+00, 3.3006670232E+01, 4.1840530454E+00, 9.8564050853E-01],
	[4.8805000000E+04, 4.9114055224E+01, 5.3095590206E+00, 3.3017781706E+01, 4.1843273323E+00, 9.8564653433E-01],
	[4.8810000000E+04, 4.9123047078E+01, 5.3096081531E+00, 3.3028895781E+01, 4.1846015547E+00, 9.8565255726E-01],
	[4.8815000000E+04, 4.9132039658E+01, 5.3096572811E+00, 3.3040012457E+01, 4.1848757127E+00, 9.8565857733E-01],
	[4.8820000000E+04, 4.9141032963E+01, 5.3097064045E+00, 3.3051131734E+01, 4.1851498063E+00, 9.8566459452E-01],
	[4.8825000000E+04, 4.9150026992E+01, 5.3097555233E+00, 3.3062253614E+01, 4.1854238355E+00, 9.8567060885E-01],
	[4.8830000000E+04, 4.9159021747E+01, 5.3098046376E+00, 3.3073378096E+01, 4.1856978003E+00, 9.8567662031E-01],
	[4.8835000000E+04, 4.9168017226E+01, 5.3098537472E+00, 3.3084505181E+01, 4.1859717007E+00, 9.8568262891E-01],
	[4.8840000000E+04, 4.9177013430E+01, 5.3099028523E+00, 3.3095634869E+01, 4.1862455368E+00, 9.8568863465E-01],
	[4.8845000000E+04, 4.9186010359E+01, 5.3099519528E+00, 3.3106767160E+01, 4.1865193085E+00, 9.8569463752E-01],
	[4.8850000000E+04, 4.9195008013E+01, 5.3100010488E+00, 3.3117902055E+01, 4.1867930159E+00, 9.8570063753E-01],
	[4.8855000000E+04, 4.9204006392E+01, 5.3100501402E+00, 3.3129039554E+01, 4.1870666591E+00, 9.8570663469E-01],
	[4.8860000000E+04, 4.9213005495E+01, 5.3100992270E+00, 3.3140179658E+01, 4.1873402379E+00, 9.8571262899E-01],
	[4.8865000000E+04, 4.9222005323E+01, 5.3101483092E+00, 3.3151322366E+01, 4.1876137525E+00, 9.8571862043E-01],
	[4.8870000000E+04, 4.9231005876E+01, 5.3101973869E+00, 3.3162467679E+01, 4.1878872029E+00, 9.8572460902E-01],
	[4.8875000000E+04, 4.9240007154E+01, 5.3102464600E+00, 3.3173615598E+01, 4.1881605890E+00, 9.8573059476E-01],
	[4.8880000000E+04, 4.9249009156E+01, 5.3102955285E+00, 3.3184766122E+01, 4.1884339109E+00, 9.8573657765E-01],
	[4.8885000000E+04, 4.9258011883E+01, 5.3103445925E+00, 3.3195919253E+01, 4.1887071687E+00, 9.8574255769E-01],
	[4.8890000000E+04, 4.9267015335E+01, 5.3103936519E+00, 3.3207074990E+01, 4.1889803622E+00, 9.8574853488E-01],
	[4.8895000000E+04, 4.9276019511E+01, 5.3104427068E+00, 3.3218233333E+01, 4.1892534916E+00, 9.8575450922E-01],
	[4.8900000000E+04, 4.9285024412E+01, 5.3104917570E+00, 3.3229394284E+01, 4.1895265569E+00, 9.8576048072E-01],
	[4.8905000000E+04, 4.9294030038E+01, 5.3105408028E+00, 3.3240557843E+01, 4.1897995581E+00, 9.8576644938E-01],
	[4.8910000000E+04, 4.9303036388E+01, 5.3105898439E+00, 3.3251724009E+01, 4.1900724951E+00, 9.8577241519E-01],
	[4.8915000000E+04, 4.9312043463E+01, 5.3106388805E+00, 3.3262892783E+01, 4.1903453681E+00, 9.8577837816E-01],
	[4.8920000000E+04, 4.9321051262E+01, 5.3106879126E+00, 3.3274064166E+01, 4.1906181770E+00, 9.8578433830E-01],
	[4.8925000000E+04, 4.9330059787E+01, 5.3107369400E+00, 3.3285238158E+01, 4.1908909219E+00, 9.8579029560E-01],
	[4.8930000000E+04, 4.9339069035E+01, 5.3107859630E+00, 3.3296414759E+01, 4.1911636027E+00, 9.8579625006E-01],
	[4.8935000000E+04, 4.9348079008E+01, 5.3108349813E+00, 3.3307593969E+01, 4.1914362195E+00, 9.8580220169E-01],
	[4.8940000000E+04, 4.9357089706E+01, 5.3108839951E+00, 3.3318775790E+01, 4.1917087724E+00, 9.8580815048E-01],
	[4.8945000000E+04, 4.9366101128E+01, 5.3109330044E+00, 3.3329960220E+01, 4.1919812613E+00, 9.8581409645E-01],
	[4.8950000000E+04, 4.9375113275E+01, 5.3109820091E+00, 3.3341147261E+01, 4.1922536862E+00, 9.8582003958E-01],
	[4.8955000000E+04, 4.9384126146E+01, 5.3110310092E+00, 3.3352336913E+01, 4.1925260471E+00, 9.8582597989E-01],
	[4.8960000000E+04, 4.9393139742E+01, 5.3110800048E+00, 3.3363529176E+01, 4.1927983442E+00, 9.8583191737E-01],
	[4.8965000000E+04, 4.9402154062E+01, 5.3111289959E+00, 3.3374724051E+01, 4.1930705773E+00, 9.8583785202E-01],
	[4.8970000000E+04, 4.9411169107E+01, 5.3111779824E+00, 3.3385921538E+01, 4.1933427466E+00, 9.8584378385E-01],
	[4.8975000000E+04, 4.9420184876E+01, 5.3112269643E+00, 3.3397121637E+01, 4.1936148520E+00, 9.8584971286E-01],
	[4.8980000000E+04, 4.9429201369E+01, 5.3112759417E+00, 3.3408324349E+01, 4.1938868936E+00, 9.8585563905E-01],
	[4.8985000000E+04, 4.9438218587E+01, 5.3113249145E+00, 3.3419529673E+01, 4.1941588713E+00, 9.8586156241E-01],
	[4.8990000000E+04, 4.9447236529E+01, 5.3113738828E+00, 3.3430737611E+01, 4.1944307852E+00, 9.8586748296E-01],
	[4.8995000000E+04, 4.9456255196E+01, 5.3114228466E+00, 3.3441948163E+01, 4.1947026353E+00, 9.8587340070E-01],
	[4.9000000000E+04, 4.9465274587E+01, 5.3114718058E+00, 3.3453161328E+01, 4.1949744217E+00, 9.8587931562E-01],
	[4.9005000000E+04, 4.9474294702E+01, 5.3115207605E+00, 3.3464377108E+01, 4.1952461442E+00, 9.8588522772E-01],
	[4.9010000000E+04, 4.9483315541E+01, 5.3115697106E+00, 3.3475595503E+01, 4.1955178031E+00, 9.8589113701E-01],
	[4.9015000000E+04, 4.9492337105E+01, 5.3116186562E+00, 3.3486816512E+01, 4.1957893982E+00, 9.8589704350E-01],
	[4.9020000000E+04, 4.9501359393E+01, 5.3116675972E+00, 3.3498040137E+01, 4.1960609296E+00, 9.8590294717E-01],
	[4.9025000000E+04, 4.9510382405E+01, 5.3117165337E+00, 3.3509266378E+01, 4.1963323973E+00, 9.8590884804E-01],
	[4.9030000000E+04, 4.9519406142E+01, 5.3117654656E+00, 3.3520495234E+01, 4.1966038014E+00, 9.8591474610E-01],
	[4.9035000000E+04, 4.9528430603E+01, 5.3118143931E+00, 3.3531726707E+01, 4.1968751417E+00, 9.8592064135E-01],
	[4.9040000000E+04, 4.9537455788E+01, 5.3118633159E+00, 3.3542960797E+01, 4.1971464185E+00, 9.8592653381E-01],
	[4.9045000000E+04, 4.9546481697E+01, 5.3119122343E+00, 3.3554197504E+01, 4.1974176317E+00, 9.8593242346E-01],
	[4.9050000000E+04, 4.9555508330E+01, 5.3119611481E+00, 3.3565436828E+01, 4.1976887812E+00, 9.8593831031E-01],
	[4.9055000000E+04, 4.9564535688E+01, 5.3120100573E+00, 3.3576678770E+01, 4.1979598672E+00, 9.8594419436E-01],
	[4.9060000000E+04, 4.9573563770E+01, 5.3120589621E+00, 3.3587923330E+01, 4.1982308896E+00, 9.8595007562E-01],
	[4.9065000000E+04, 4.9582592576E+01, 5.3121078623E+00, 3.3599170508E+01, 4.1985018484E+00, 9.8595595408E-01],
	[4.9070000000E+04, 4.9591629879E+01, 5.3121575498E+00, 3.3610420306E+01, 4.1987732942E+00, 9.8596182974E-01],
	[4.9075000000E+04, 4.9600676468E+01, 5.3122081045E+00, 3.3621672722E+01, 4.1990452825E+00, 9.8596770262E-01],
	[4.9080000000E+04, 4.9609723785E+01, 5.3122586546E+00, 3.3632927758E+01, 4.1993172075E+00, 9.8597357270E-01],
	[4.9085000000E+04, 4.9618771831E+01, 5.3123092000E+00, 3.3644185413E+01, 4.1995890692E+00, 9.8597943999E-01],
	[4.9090000000E+04, 4.9627820605E+01, 5.3123597407E+00, 3.3655445689E+01, 4.1998608674E+00, 9.8598530450E-01],
	[4.9095000000E+04, 4.9636870107E+01, 5.3124102767E+00, 3.3666708585E+01, 4.2001326024E+00, 9.8599116621E-01],
	[4.9100000000E+04, 4.9645920338E+01, 5.3124608081E+00, 3.3677974102E+01, 4.2004042741E+00, 9.8599702515E-01],
	[4.9105000000E+04, 4.9654971297E+01, 5.3125113348E+00, 3.3689242241E+01, 4.2006758825E+00, 9.8600288129E-01],
	[4.9110000000E+04, 4.9664022984E+01, 5.3125618569E+00, 3.3700513001E+01, 4.2009474276E+00, 9.8600873466E-01],
	[4.9115000000E+04, 4.9673075400E+01, 5.3126123742E+00, 3.3711786382E+01, 4.2012189094E+00, 9.8601458525E-01],
	[4.9120000000E+04, 4.9682128544E+01, 5.3126628870E+00, 3.3723062386E+01, 4.2014903281E+00, 9.8602043305E-01],
	[4.9125000000E+04, 4.9691182416E+01, 5.3127133950E+00, 3.3734341012E+01, 4.2017616835E+00, 9.8602627808E-01],
	[4.9130000000E+04, 4.9700237016E+01, 5.3127638984E+00, 3.3745622262E+01, 4.2020329757E+00, 9.8603212033E-01],
	[4.9135000000E+04, 4.9709292344E+01, 5.3128143972E+00, 3.3756906134E+01, 4.2023042048E+00, 9.8603795981E-01],
	[4.9140000000E+04, 4.9718348401E+01, 5.3128648913E+00, 3.3768192630E+01, 4.2025753706E+00, 9.8604379651E-01],
	[4.9145000000E+04, 4.9727405186E+01, 5.3129153807E+00, 3.3779481750E+01, 4.2028464734E+00, 9.8604963044E-01],
	[4.9150000000E+04, 4.9736462699E+01, 5.3129658655E+00, 3.3790773495E+01, 4.2031175130E+00, 9.8605546161E-01],
	[4.9155000000E+04, 4.9745520940E+01, 5.3130163456E+00, 3.3802067864E+01, 4.2033884895E+00, 9.8606129000E-01],
	[4.9160000000E+04, 4.9754579909E+01, 5.3130668210E+00, 3.3813364857E+01, 4.2036594029E+00, 9.8606711562E-01],
	[4.9165000000E+04, 4.9763639606E+01, 5.3131172918E+00, 3.3824664477E+01, 4.2039302533E+00, 9.8607293848E-01],
	[4.9170000000E+04, 4.9772700032E+01, 5.3131677580E+00, 3.3835966721E+01, 4.2042010405E+00, 9.8607875858E-01],
	[4.9175000000E+04, 4.9781761185E+01, 5.3132182195E+00, 3.3847271592E+01, 4.2044717648E+00, 9.8608457591E-01],
	[4.9180000000E+04, 4.9790823067E+01, 5.3132686763E+00, 3.3858579089E+01, 4.2047424260E+00, 9.8609039048E-01],
	[4.9185000000E+04, 4.9799885677E+01, 5.3133191285E+00, 3.3869889213E+01, 4.2050130242E+00, 9.8609620228E-01],
	[4.9190000000E+04, 4.9808949014E+01, 5.3133695761E+00, 3.3881201963E+01, 4.2052835595E+00, 9.8610201133E-01],
	[4.9195000000E+04, 4.9818013080E+01, 5.3134200190E+00, 3.3892517341E+01, 4.2055540317E+00, 9.8610781763E-01],
	[4.9200000000E+04, 4.9827077874E+01, 5.3134704572E+00, 3.3903835347E+01, 4.2058244410E+00, 9.8611362116E-01],
	[4.9205000000E+04, 4.9836143395E+01, 5.3135208908E+00, 3.3915155981E+01, 4.2060947874E+00, 9.8611942195E-01],
	[4.9210000000E+04, 4.9845209645E+01, 5.3135713198E+00, 3.3926479243E+01, 4.2063650709E+00, 9.8612521998E-01],
	[4.9215000000E+04, 4.9854276623E+01, 5.3136217441E+00, 3.3937805134E+01, 4.2066352915E+00, 9.8613101526E-01],
	[4.9220000000E+04, 4.9863344328E+01, 5.3136721638E+00, 3.3949133654E+01, 4.2069054492E+00, 9.8613680779E-01],
	[4.9225000000E+04, 4.9872412762E+01, 5.3137225788E+00, 3.3960464803E+01, 4.2071755440E+00, 9.8614259757E-01],
	[4.9230000000E+04, 4.9881481923E+01, 5.3137729892E+00, 3.3971798582E+01, 4.2074455760E+00, 9.8614838460E-01],
	[4.9235000000E+04, 4.9890551813E+01, 5.3138233949E+00, 3.3983134991E+01, 4.2077155451E+00, 9.8615416889E-01],
	[4.9240000000E+04, 4.9899622430E+01, 5.3138737961E+00, 3.3994474031E+01, 4.2079854515E+00, 9.8615995043E-01],
	[4.9245000000E+04, 4.9908693775E+01, 5.3139241925E+00, 3.4005815701E+01, 4.2082552951E+00, 9.8616572923E-01],
	[4.9250000000E+04, 4.9917765848E+01, 5.3139745843E+00, 3.4017160003E+01, 4.2085250758E+00, 9.8617150529E-01],
	[4.9255000000E+04, 4.9926838649E+01, 5.3140249715E+00, 3.4028506936E+01, 4.2087947939E+00, 9.8617727861E-01],
	[4.9260000000E+04, 4.9935912177E+01, 5.3140753541E+00, 3.4039856500E+01, 4.2090644491E+00, 9.8618304919E-01],
	[4.9265000000E+04, 4.9944986434E+01, 5.3141257320E+00, 3.4051208697E+01, 4.2093340417E+00, 9.8618881704E-01],
	[4.9270000000E+04, 4.9954061418E+01, 5.3141761053E+00, 3.4062563526E+01, 4.2096035716E+00, 9.8619458215E-01],
	[4.9275000000E+04, 4.9963137130E+01, 5.3142264739E+00, 3.4073920989E+01, 4.2098730387E+00, 9.8620034453E-01],
	[4.9280000000E+04, 4.9972213569E+01, 5.3142768379E+00, 3.4085281084E+01, 4.2101424432E+00, 9.8620610417E-01],
	[4.9285000000E+04, 4.9981290737E+01, 5.3143271973E+00, 3.4096643813E+01, 4.2104117851E+00, 9.8621186108E-01],
	[4.9290000000E+04, 4.9990368632E+01, 5.3143775520E+00, 3.4108009176E+01, 4.2106810643E+00, 9.8621761527E-01],
	[4.9295000000E+04, 4.9999447255E+01, 5.3144279022E+00, 3.4119377172E+01, 4.2109502809E+00, 9.8622336672E-01],
	[4.9300000000E+04, 5.0008526605E+01, 5.3144782476E+00, 3.4130747804E+01, 4.2112194349E+00, 9.8622911545E-01],
	[4.9305000000E+04, 5.0017606684E+01, 5.3145285885E+00, 3.4142121070E+01, 4.2114885263E+00, 9.8623486145E-01],
	[4.9310000000E+04, 5.0026687490E+01, 5.3145789247E+00, 3.4153496972E+01, 4.2117575552E+00, 9.8624060473E-01],
	[4.9315000000E+04, 5.0035769023E+01, 5.3146292563E+00, 3.4164875509E+01, 4.2120265215E+00, 9.8624634529E-01],
	[4.9320000000E+04, 5.0044851284E+01, 5.3146795833E+00, 3.4176256682E+01, 4.2122954253E+00, 9.8625208313E-01],
	[4.9325000000E+04, 5.0053934273E+01, 5.3147299057E+00, 3.4187640491E+01, 4.2125642666E+00, 9.8625781825E-01],
	[4.9330000000E+04, 5.0063017989E+01, 5.3147802234E+00, 3.4199026937E+01, 4.2128330453E+00, 9.8626355065E-01],
	[4.9335000000E+04, 5.0072102433E+01, 5.3148305365E+00, 3.4210416020E+01, 4.2131017616E+00, 9.8626928033E-01],
	[4.9340000000E+04, 5.0081187605E+01, 5.3148808450E+00, 3.4221807740E+01, 4.2133704155E+00, 9.8627500730E-01],
	[4.9345000000E+04, 5.0090273504E+01, 5.3149311488E+00, 3.4233202098E+01, 4.2136390069E+00, 9.8628073156E-01],
	[4.9350000000E+04, 5.0099360131E+01, 5.3149814481E+00, 3.4244599094E+01, 4.2139075358E+00, 9.8628645310E-01],
	[4.9355000000E+04, 5.0108447485E+01, 5.3150317427E+00, 3.4255998728E+01, 4.2141760024E+00, 9.8629217193E-01],
	[4.9360000000E+04, 5.0117535567E+01, 5.3150820327E+00, 3.4267401001E+01, 4.2144444066E+00, 9.8629788806E-01],
	[4.9365000000E+04, 5.0126624376E+01, 5.3151323181E+00, 3.4278805913E+01, 4.2147127484E+00, 9.8630360147E-01],
	[4.9370000000E+04, 5.0135713913E+01, 5.3151825988E+00, 3.4290213464E+01, 4.2149810278E+00, 9.8630931218E-01],
	[4.9375000000E+04, 5.0144804177E+01, 5.3152328750E+00, 3.4301623655E+01, 4.2152492450E+00, 9.8631502019E-01],
	[4.9380000000E+04, 5.0153895168E+01, 5.3152831465E+00, 3.4313036485E+01, 4.2155173997E+00, 9.8632072549E-01],
	[4.9385000000E+04, 5.0162986887E+01, 5.3153334134E+00, 3.4324451957E+01, 4.2157854922E+00, 9.8632642809E-01],
	[4.9390000000E+04, 5.0172079334E+01, 5.3153836757E+00, 3.4335870069E+01, 4.2160535224E+00, 9.8633212799E-01],
	[4.9395000000E+04, 5.0181172508E+01, 5.3154339334E+00, 3.4347290822E+01, 4.2163214904E+00, 9.8633782519E-01],
	[4.9400000000E+04, 5.0190266409E+01, 5.3154841865E+00, 3.4358714216E+01, 4.2165893961E+00, 9.8634351969E-01],
	[4.9405000000E+04, 5.0199361037E+01, 5.3155344349E+00, 3.4370140252E+01, 4.2168572395E+00, 9.8634921150E-01],
	[4.9410000000E+04, 5.0208456393E+01, 5.3155846788E+00, 3.4381568931E+01, 4.2171250208E+00, 9.8635490061E-01],
	[4.9415000000E+04, 5.0217552477E+01, 5.3156349180E+00, 3.4393000251E+01, 4.2173927398E+00, 9.8636058703E-01],
	[4.9420000000E+04, 5.0226649287E+01, 5.3156851527E+00, 3.4404434215E+01, 4.2176603967E+00, 9.8636627076E-01],
	[4.9425000000E+04, 5.0235746825E+01, 5.3157353827E+00, 3.4415870821E+01, 4.2179279914E+00, 9.8637195180E-01],
	[4.9430000000E+04, 5.0244845090E+01, 5.3157856081E+00, 3.4427310071E+01, 4.2181955239E+00, 9.8637763015E-01],
	[4.9435000000E+04, 5.0253944083E+01, 5.3158358290E+00, 3.4438751965E+01, 4.2184629944E+00, 9.8638330581E-01],
	[4.9440000000E+04, 5.0263043803E+01, 5.3158860452E+00, 3.4450196503E+01, 4.2187304027E+00, 9.8638897878E-01],
	[4.9445000000E+04, 5.0272144250E+01, 5.3159362568E+00, 3.4461643686E+01, 4.2189977489E+00, 9.8639464907E-01],
	[4.9450000000E+04, 5.0281245424E+01, 5.3159864638E+00, 3.4473093513E+01, 4.2192650331E+00, 9.8640031668E-01],
	[4.9455000000E+04, 5.0290347325E+01, 5.3160366662E+00, 3.4484545986E+01, 4.2195322551E+00, 9.8640598161E-01],
	[4.9460000000E+04, 5.0299449954E+01, 5.3160868640E+00, 3.4496001104E+01, 4.2197994152E+00, 9.8641164385E-01],
	[4.9465000000E+04, 5.0308553310E+01, 5.3161370572E+00, 3.4507458868E+01, 4.2200665132E+00, 9.8641730342E-01],
	[4.9470000000E+04, 5.0317657393E+01, 5.3161872458E+00, 3.4518919278E+01, 4.2203335492E+00, 9.8642296031E-01],
	[4.9475000000E+04, 5.0326762203E+01, 5.3162374298E+00, 3.4530382335E+01, 4.2206005233E+00, 9.8642861452E-01],
	[4.9480000000E+04, 5.0335867740E+01, 5.3162876092E+00, 3.4541848038E+01, 4.2208674353E+00, 9.8643426606E-01],
	[4.9485000000E+04, 5.0344974005E+01, 5.3163377840E+00, 3.4553316389E+01, 4.2211342854E+00, 9.8643991493E-01],
	[4.9490000000E+04, 5.0354080996E+01, 5.3163879542E+00, 3.4564787388E+01, 4.2214010736E+00, 9.8644556112E-01],
	[4.9495000000E+04, 5.0363188715E+01, 5.3164381199E+00, 3.4576261034E+01, 4.2216677999E+00, 9.8645120465E-01],
	[4.9500000000E+04, 5.0372297160E+01, 5.3164882809E+00, 3.4587737329E+01, 4.2219344642E+00, 9.8645684551E-01],
	[4.9505000000E+04, 5.0381406333E+01, 5.3165384373E+00, 3.4599216272E+01, 4.2222010667E+00, 9.8646248369E-01],
	[4.9510000000E+04, 5.0390516233E+01, 5.3165885892E+00, 3.4610697864E+01, 4.2224676073E+00, 9.8646811922E-01],
	[4.9515000000E+04, 5.0399626860E+01, 5.3166387364E+00, 3.4622182106E+01, 4.2227340860E+00, 9.8647375208E-01],
	[4.9520000000E+04, 5.0408738214E+01, 5.3166888791E+00, 3.4633668997E+01, 4.2230005029E+00, 9.8647938227E-01],
	[4.9525000000E+04, 5.0417850295E+01, 5.3167390171E+00, 3.4645158538E+01, 4.2232668580E+00, 9.8648500981E-01],
	[4.9530000000E+04, 5.0426963102E+01, 5.3167891506E+00, 3.4656650729E+01, 4.2235331513E+00, 9.8649063468E-01],
	[4.9535000000E+04, 5.0436076637E+01, 5.3168392795E+00, 3.4668145572E+01, 4.2237993828E+00, 9.8649625689E-01],
	[4.9540000000E+04, 5.0445190899E+01, 5.3168894038E+00, 3.4679643065E+01, 4.2240655526E+00, 9.8650187645E-01],
	[4.9545000000E+04, 5.0454305888E+01, 5.3169395235E+00, 3.4691143209E+01, 4.2243316606E+00, 9.8650749336E-01],
	[4.9550000000E+04, 5.0463421603E+01, 5.3169896387E+00, 3.4702646006E+01, 4.2245977069E+00, 9.8651310760E-01],
	[4.9555000000E+04, 5.0472538046E+01, 5.3170397492E+00, 3.4714151454E+01, 4.2248636914E+00, 9.8651871920E-01],
	[4.9560000000E+04, 5.0481655215E+01, 5.3170898552E+00, 3.4725659555E+01, 4.2251296143E+00, 9.8652432814E-01],
	[4.9565000000E+04, 5.0490773111E+01, 5.3171399565E+00, 3.4737170308E+01, 4.2253954755E+00, 9.8652993444E-01],
	[4.9570000000E+04, 5.0499891735E+01, 5.3171900533E+00, 3.4748683715E+01, 4.2256612750E+00, 9.8653553808E-01],
	[4.9575000000E+04, 5.0509011085E+01, 5.3172401456E+00, 3.4760199775E+01, 4.2259270129E+00, 9.8654113908E-01],
	[4.9580000000E+04, 5.0518131161E+01, 5.3172902332E+00, 3.4771718488E+01, 4.2261926892E+00, 9.8654673743E-01],
	[4.9585000000E+04, 5.0527251965E+01, 5.3173403163E+00, 3.4783239856E+01, 4.2264583039E+00, 9.8655233314E-01],
	[4.9590000000E+04, 5.0536373496E+01, 5.3173903947E+00, 3.4794763878E+01, 4.2267238570E+00, 9.8655792620E-01],
	[4.9595000000E+04, 5.0545495753E+01, 5.3174404686E+00, 3.4806290555E+01, 4.2269893485E+00, 9.8656351662E-01],
	[4.9600000000E+04, 5.0554618737E+01, 5.3174905380E+00, 3.4817819888E+01, 4.2272547784E+00, 9.8656910441E-01],
	[4.9605000000E+04, 5.0563742448E+01, 5.3175406027E+00, 3.4829351875E+01, 4.2275201468E+00, 9.8657468955E-01],
	[4.9610000000E+04, 5.0572866885E+01, 5.3175906629E+00, 3.4840886519E+01, 4.2277854537E+00, 9.8658027206E-01],
	[4.9615000000E+04, 5.0581992049E+01, 5.3176407185E+00, 3.4852423819E+01, 4.2280506991E+00, 9.8658585193E-01],
	[4.9620000000E+04, 5.0591117940E+01, 5.3176907695E+00, 3.4863963775E+01, 4.2283158830E+00, 9.8659142917E-01],
	[4.9625000000E+04, 5.0600244558E+01, 5.3177408160E+00, 3.4875506388E+01, 4.2285810054E+00, 9.8659700377E-01],
	[4.9630000000E+04, 5.0609371902E+01, 5.3177908579E+00, 3.4887051658E+01, 4.2288460663E+00, 9.8660257574E-01],
	[4.9635000000E+04, 5.0618499973E+01, 5.3178408952E+00, 3.4898599586E+01, 4.2291110659E+00, 9.8660814508E-01],
	[4.9640000000E+04, 5.0627628771E+01, 5.3178909279E+00, 3.4910150172E+01, 4.2293760040E+00, 9.8661371180E-01],
	[4.9645000000E+04, 5.0636758295E+01, 5.3179409561E+00, 3.4921703416E+01, 4.2296408807E+00, 9.8661927588E-01],
	[4.9650000000E+04, 5.0645888546E+01, 5.3179909797E+00, 3.4933259318E+01, 4.2299056961E+00, 9.8662483734E-01],
	[4.9655000000E+04, 5.0655019523E+01, 5.3180409988E+00, 3.4944817880E+01, 4.2301704500E+00, 9.8663039618E-01],
	[4.9660000000E+04, 5.0664151227E+01, 5.3180910132E+00, 3.4956379101E+01, 4.2304351426E+00, 9.8663595239E-01],
	[4.9665000000E+04, 5.0673283658E+01, 5.3181410232E+00, 3.4967942981E+01, 4.2306997739E+00, 9.8664150598E-01],
	[4.9670000000E+04, 5.0682416815E+01, 5.3181910285E+00, 3.4979509521E+01, 4.2309643439E+00, 9.8664705695E-01],
	[4.9675000000E+04, 5.0691550699E+01, 5.3182410293E+00, 3.4991078722E+01, 4.2312288526E+00, 9.8665260531E-01],
	[4.9680000000E+04, 5.0700685309E+01, 5.3182910255E+00, 3.5002650583E+01, 4.2314933000E+00, 9.8665815104E-01],
	[4.9685000000E+04, 5.0709820646E+01, 5.3183410172E+00, 3.5014225105E+01, 4.2317576861E+00, 9.8666369416E-01],
	[4.9690000000E+04, 5.0718956709E+01, 5.3183910043E+00, 3.5025802289E+01, 4.2320220110E+00, 9.8666923466E-01],
	[4.9695000000E+04, 5.0728093499E+01, 5.3184409868E+00, 3.5037382134E+01, 4.2322862747E+00, 9.8667477256E-01],
	[4.9700000000E+04, 5.0737231015E+01, 5.3184909648E+00, 3.5048964642E+01, 4.2325504771E+00, 9.8668030784E-01],
	[4.9705000000E+04, 5.0746369257E+01, 5.3185409382E+00, 3.5060549811E+01, 4.2328146184E+00, 9.8668584050E-01],
	[4.9710000000E+04, 5.0755508227E+01, 5.3185909071E+00, 3.5072137643E+01, 4.2330786984E+00, 9.8669137056E-01],
	[4.9715000000E+04, 5.0764647922E+01, 5.3186408714E+00, 3.5083728139E+01, 4.2333427173E+00, 9.8669689802E-01],
	[4.9720000000E+04, 5.0773788344E+01, 5.3186908311E+00, 3.5095321298E+01, 4.2336066751E+00, 9.8670242286E-01],
	[4.9725000000E+04, 5.0782929492E+01, 5.3187407863E+00, 3.5106917120E+01, 4.2338705718E+00, 9.8670794511E-01],
	[4.9730000000E+04, 5.0792071367E+01, 5.3187907370E+00, 3.5118515607E+01, 4.2341344073E+00, 9.8671346474E-01],
	[4.9735000000E+04, 5.0801213968E+01, 5.3188406831E+00, 3.5130116758E+01, 4.2343981818E+00, 9.8671898178E-01],
	[4.9740000000E+04, 5.0810357295E+01, 5.3188906246E+00, 3.5141720573E+01, 4.2346618951E+00, 9.8672449622E-01],
	[4.9745000000E+04, 5.0819501349E+01, 5.3189405616E+00, 3.5153327054E+01, 4.2349255475E+00, 9.8673000806E-01],
	[4.9750000000E+04, 5.0828646129E+01, 5.3189904940E+00, 3.5164936201E+01, 4.2351891387E+00, 9.8673551730E-01],
	[4.9755000000E+04, 5.0837791635E+01, 5.3190404219E+00, 3.5176548013E+01, 4.2354526690E+00, 9.8674102394E-01],
	[4.9760000000E+04, 5.0846937867E+01, 5.3190903453E+00, 3.5188162491E+01, 4.2357161382E+00, 9.8674652799E-01],
	[4.9765000000E+04, 5.0856084826E+01, 5.3191402640E+00, 3.5199779636E+01, 4.2359795465E+00, 9.8675202944E-01],
	[4.9770000000E+04, 5.0865232511E+01, 5.3191901783E+00, 3.5211399447E+01, 4.2362428938E+00, 9.8675752831E-01],
	[4.9775000000E+04, 5.0874380922E+01, 5.3192400880E+00, 3.5223021926E+01, 4.2365061801E+00, 9.8676302458E-01],
	[4.9780000000E+04, 5.0883530060E+01, 5.3192899931E+00, 3.5234647072E+01, 4.2367694055E+00, 9.8676851826E-01],
	[4.9785000000E+04, 5.0892679924E+01, 5.3193398938E+00, 3.5246274887E+01, 4.2370325700E+00, 9.8677400936E-01],
	[4.9790000000E+04, 5.0901830514E+01, 5.3193897898E+00, 3.5257905369E+01, 4.2372956736E+00, 9.8677949787E-01],
	[4.9795000000E+04, 5.0910981830E+01, 5.3194396813E+00, 3.5269538520E+01, 4.2375587163E+00, 9.8678498379E-01],
	[4.9800000000E+04, 5.0920133872E+01, 5.3194895683E+00, 3.5281174340E+01, 4.2378216981E+00, 9.8679046713E-01],
	[4.9805000000E+04, 5.0929286640E+01, 5.3195394508E+00, 3.5292812829E+01, 4.2380846191E+00, 9.8679594789E-01],
	[4.9810000000E+04, 5.0938440135E+01, 5.3195893287E+00, 3.5304453987E+01, 4.2383474792E+00, 9.8680142607E-01],
	[4.9815000000E+04, 5.0947594355E+01, 5.3196392020E+00, 3.5316097816E+01, 4.2386102786E+00, 9.8680690167E-01],
	[4.9820000000E+04, 5.0956749302E+01, 5.3196890709E+00, 3.5327744315E+01, 4.2388730171E+00, 9.8681237469E-01],
	[4.9825000000E+04, 5.0965904975E+01, 5.3197389352E+00, 3.5339393484E+01, 4.2391356948E+00, 9.8681784513E-01],
	[4.9830000000E+04, 5.0975061373E+01, 5.3197887949E+00, 3.5351045324E+01, 4.2393983118E+00, 9.8682331300E-01],
	[4.9835000000E+04, 5.0984218498E+01, 5.3198386501E+00, 3.5362699836E+01, 4.2396608680E+00, 9.8682877830E-01],
	[4.9840000000E+04, 5.0993376349E+01, 5.3198885008E+00, 3.5374357019E+01, 4.2399233635E+00, 9.8683424102E-01],
	[4.9845000000E+04, 5.1002534926E+01, 5.3199383470E+00, 3.5386016875E+01, 4.2401857983E+00, 9.8683970117E-01],
	[4.9850000000E+04, 5.1011694229E+01, 5.3199881886E+00, 3.5397679402E+01, 4.2404481724E+00, 9.8684515876E-01],
	[4.9855000000E+04, 5.1020854258E+01, 5.3200380256E+00, 3.5409344603E+01, 4.2407104858E+00, 9.8685061377E-01],
	[4.9860000000E+04, 5.1030023033E+01, 5.3200886587E+00, 3.5421012476E+01, 4.2409733026E+00, 9.8685606622E-01],
	[4.9865000000E+04, 5.1039200831E+01, 5.3201401150E+00, 3.5432683023E+01, 4.2412366422E+00, 9.8686151610E-01],
	[4.9870000000E+04, 5.1048379359E+01, 5.3201915665E+00, 3.5444356243E+01, 4.2414999213E+00, 9.8686696342E-01],
	[4.9875000000E+04, 5.1057558617E+01, 5.3202430135E+00, 3.5456032138E+01, 4.2417631399E+00, 9.8687240817E-01],
	[4.9880000000E+04, 5.1066738606E+01, 5.3202944558E+00, 3.5467710707E+01, 4.2420262980E+00, 9.8687785037E-01],
	[4.9885000000E+04, 5.1075919324E+01, 5.3203458934E+00, 3.5479391950E+01, 4.2422893956E+00, 9.8688329000E-01],
	[4.9890000000E+04, 5.1085100773E+01, 5.3203973263E+00, 3.5491075869E+01, 4.2425524328E+00, 9.8688872708E-01],
	[4.9895000000E+04, 5.1094282952E+01, 5.3204487546E+00, 3.5502762463E+01, 4.2428154096E+00, 9.8689416159E-01],
	[4.9900000000E+04, 5.1103465861E+01, 5.3205001783E+00, 3.5514451733E+01, 4.2430783259E+00, 9.8689959356E-01],
	[4.9905000000E+04, 5.1112649500E+01, 5.3205515973E+00, 3.5526143679E+01, 4.2433411818E+00, 9.8690502297E-01],
	[4.9910000000E+04, 5.1121833869E+01, 5.3206030116E+00, 3.5537838302E+01, 4.2436039774E+00, 9.8691044982E-01],
	[4.9915000000E+04, 5.1131018968E+01, 5.3206544213E+00, 3.5549535601E+01, 4.2438667125E+00, 9.8691587413E-01],
	[4.9920000000E+04, 5.1140204797E+01, 5.3207058263E+00, 3.5561235577E+01, 4.2441293874E+00, 9.8692129588E-01],
	[4.9925000000E+04, 5.1149391356E+01, 5.3207572267E+00, 3.5572938231E+01, 4.2443920018E+00, 9.8692671509E-01],
	[4.9930000000E+04, 5.1158578645E+01, 5.3208086224E+00, 3.5584643563E+01, 4.2446545560E+00, 9.8693213174E-01],
	[4.9935000000E+04, 5.1167766664E+01, 5.3208600135E+00, 3.5596351573E+01, 4.2449170499E+00, 9.8693754586E-01],
	[4.9940000000E+04, 5.1176955413E+01, 5.3209113999E+00, 3.5608062262E+01, 4.2451794835E+00, 9.8694295742E-01],
	[4.9945000000E+04, 5.1186144892E+01, 5.3209627817E+00, 3.5619775629E+01, 4.2454418568E+00, 9.8694836644E-01],
	[4.9950000000E+04, 5.1195335100E+01, 5.3210141589E+00, 3.5631491676E+01, 4.2457041699E+00, 9.8695377292E-01],
	[4.9955000000E+04, 5.1204526039E+01, 5.3210655313E+00, 3.5643210402E+01, 4.2459664227E+00, 9.8695917686E-01],
	[4.9960000000E+04, 5.1213717708E+01, 5.3211168992E+00, 3.5654931808E+01, 4.2462286153E+00, 9.8696457826E-01],
	[4.9965000000E+04, 5.1222910106E+01, 5.3211682624E+00, 3.5666655894E+01, 4.2464907478E+00, 9.8696997711E-01],
	[4.9970000000E+04, 5.1232103235E+01, 5.3212196209E+00, 3.5678382661E+01, 4.2467528200E+00, 9.8697537343E-01],
	[4.9975000000E+04, 5.1241297093E+01, 5.3212709748E+00, 3.5690112109E+01, 4.2470148321E+00, 9.8698076721E-01],
	[4.9980000000E+04, 5.1250491681E+01, 5.3213223241E+00, 3.5701844238E+01, 4.2472767840E+00, 9.8698615846E-01],
	[4.9985000000E+04, 5.1259686999E+01, 5.3213736687E+00, 3.5713579049E+01, 4.2475386758E+00, 9.8699154717E-01],
	[4.9990000000E+04, 5.1268883047E+01, 5.3214250087E+00, 3.5725316542E+01, 4.2478005075E+00, 9.8699693335E-01],
	[4.9995000000E+04, 5.1278079824E+01, 5.3214763441E+00, 3.5737056717E+01, 4.2480622791E+00, 9.8700231700E-01],
	[5.0000000000E+04, 5.1287277331E+01, 5.3215276748E+00, 3.5748799574E+01, 4.2483239906E+00, 9.8700769812E-01],
	[5.0005000000E+04, 5.1296475568E+01, 5.3215790008E+00, 3.5760554599E+01, 4.2485857760E+00, 9.8701307671E-01],
	[5.0010000000E+04, 5.1305674535E+01, 5.3216303223E+00, 3.5772312313E+01, 4.2488475012E+00, 9.8701845277E-01],
	[5.0015000000E+04, 5.1314874232E+01, 5.3216816391E+00, 3.5784072715E+01, 4.2491091663E+00, 9.8702382630E-01],
	[5.0020000000E+04, 5.1324074658E+01, 5.3217329512E+00, 3.5795835808E+01, 4.2493707713E+00, 9.8702919731E-01],
	[5.0025000000E+04, 5