import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

lung_ICRP110_MFP = np.array([
	[5.0000000000E+03, 4.8701717732E+00, 2.2111913338E+01, 6.2047065820E-02, 6.1097231871E-02, 3.4456017826E-01],
	[5.0050000000E+03, 4.8757337890E+00, 2.2098519976E+01, 6.2233747762E-02, 6.1279010302E-02, 3.4481828937E-01],
	[5.0100000000E+03, 4.8812965937E+00, 2.2085148087E+01, 6.2420803497E-02, 6.1461141807E-02, 3.4507610429E-01],
	[5.0150000000E+03, 4.8868601867E+00, 2.2071797616E+01, 6.2608233398E-02, 6.1643626689E-02, 3.4533362374E-01],
	[5.0200000000E+03, 4.8924245673E+00, 2.2058468507E+01, 6.2796037835E-02, 6.1826465252E-02, 3.4559084844E-01],
	[5.0250000000E+03, 4.8979897349E+00, 2.2045160705E+01, 6.2984217181E-02, 6.2009657799E-02, 3.4584777911E-01],
	[5.0300000000E+03, 4.9035556886E+00, 2.2031874154E+01, 6.3172771810E-02, 6.2193204633E-02, 3.4610441647E-01],
	[5.0350000000E+03, 4.9091224280E+00, 2.2018608800E+01, 6.3361702091E-02, 6.2377106056E-02, 3.4636076122E-01],
	[5.0400000000E+03, 4.9146899522E+00, 2.2005364588E+01, 6.3551008399E-02, 6.2561362372E-02, 3.4661681408E-01],
	[5.0450000000E+03, 4.9202582607E+00, 2.1992141463E+01, 6.3740691105E-02, 6.2745973882E-02, 3.4687257576E-01],
	[5.0500000000E+03, 4.9258273528E+00, 2.1978939370E+01, 6.3930750581E-02, 6.2930940889E-02, 3.4712804696E-01],
	[5.0550000000E+03, 4.9313972278E+00, 2.1965758257E+01, 6.4121187199E-02, 6.3116263695E-02, 3.4738322837E-01],
	[5.0600000000E+03, 4.9369678850E+00, 2.1952598067E+01, 6.4312001331E-02, 6.3301942602E-02, 3.4763812071E-01],
	[5.0650000000E+03, 4.9425393238E+00, 2.1939458748E+01, 6.4503193350E-02, 6.3487977911E-02, 3.4789272467E-01],
	[5.0700000000E+03, 4.9481115435E+00, 2.1926340247E+01, 6.4694763628E-02, 6.3674369924E-02, 3.4814704093E-01],
	[5.0750000000E+03, 4.9536845434E+00, 2.1913242508E+01, 6.4886712537E-02, 6.3861118943E-02, 3.4840107020E-01],
	[5.0800000000E+03, 4.9592583230E+00, 2.1900165480E+01, 6.5079040449E-02, 6.4048225268E-02, 3.4865481317E-01],
	[5.0850000000E+03, 4.9648697018E+00, 2.1887329196E+01, 6.5271747735E-02, 6.4235697260E-02, 3.4890827051E-01],
	[5.0900000000E+03, 4.9704854819E+00, 2.1874534380E+01, 6.5464834769E-02, 6.4423528021E-02, 3.4916144292E-01],
	[5.0950000000E+03, 4.9761020909E+00, 2.1861759596E+01, 6.5658301922E-02, 6.4611717073E-02, 3.4941433107E-01],
	[5.1000000000E+03, 4.9817195280E+00, 2.1849004791E+01, 6.5852149567E-02, 6.4800264717E-02, 3.4966693564E-01],
	[5.1050000000E+03, 4.9873377928E+00, 2.1836269915E+01, 6.6046378075E-02, 6.4989171255E-02, 3.4991925731E-01],
	[5.1100000000E+03, 4.9929568843E+00, 2.1823554918E+01, 6.6240987818E-02, 6.5178436986E-02, 3.5017129676E-01],
	[5.1150000000E+03, 4.9985768020E+00, 2.1810859749E+01, 6.6435979170E-02, 6.5368062211E-02, 3.5042305465E-01],
	[5.1200000000E+03, 5.0041975451E+00, 2.1798184358E+01, 6.6631352500E-02, 6.5558047230E-02, 3.5067453166E-01],
	[5.1250000000E+03, 5.0098191130E+00, 2.1785528695E+01, 6.6827108183E-02, 6.5748392344E-02, 3.5092572845E-01],
	[5.1300000000E+03, 5.0154415050E+00, 2.1772892709E+01, 6.7023246589E-02, 6.5939097851E-02, 3.5117664568E-01],
	[5.1350000000E+03, 5.0210647203E+00, 2.1760276352E+01, 6.7219768091E-02, 6.6130164052E-02, 3.5142728402E-01],
	[5.1400000000E+03, 5.0266887584E+00, 2.1747679573E+01, 6.7416673061E-02, 6.6321591247E-02, 3.5167764412E-01],
	[5.1450000000E+03, 5.0323136186E+00, 2.1735102324E+01, 6.7613961871E-02, 6.6513379734E-02, 3.5192772665E-01],
	[5.1500000000E+03, 5.0379393001E+00, 2.1722544555E+01, 6.7811634893E-02, 6.6705529812E-02, 3.5217753225E-01],
	[5.1550000000E+03, 5.0435658023E+00, 2.1710006216E+01, 6.8009692499E-02, 6.6898041781E-02, 3.5242706158E-01],
	[5.1600000000E+03, 5.0491931245E+00, 2.1697487260E+01, 6.8208135061E-02, 6.7090915940E-02, 3.5267631530E-01],
	[5.1650000000E+03, 5.0548430123E+00, 2.1685116258E+01, 6.8406962951E-02, 6.7284157678E-02, 3.5292529403E-01],
	[5.1700000000E+03, 5.0605112729E+00, 2.1672867758E+01, 6.8606176541E-02, 6.7477766368E-02, 3.5317399844E-01],
	[5.1750000000E+03, 5.0661804011E+00, 2.1660638006E+01, 6.8805776203E-02, 6.7671738227E-02, 3.5342242916E-01],
	[5.1800000000E+03, 5.0718503962E+00, 2.1648426956E+01, 6.9005762309E-02, 6.7866073553E-02, 3.5367058684E-01],
	[5.1850000000E+03, 5.0775212577E+00, 2.1636234561E+01, 6.9206135232E-02, 6.8060772645E-02, 3.5391847211E-01],
	[5.1900000000E+03, 5.0831929847E+00, 2.1624060774E+01, 6.9406895342E-02, 6.8255835801E-02, 3.5416608561E-01],
	[5.1950000000E+03, 5.0888655766E+00, 2.1611905550E+01, 6.9608043012E-02, 6.8451263319E-02, 3.5441342797E-01],
	[5.2000000000E+03, 5.0945390326E+00, 2.1599768841E+01, 6.9809578614E-02, 6.8647055497E-02, 3.5466049982E-01],
	[5.2050000000E+03, 5.1002133521E+00, 2.1587650603E+01, 7.0011502520E-02, 6.8843212632E-02, 3.5490730180E-01],
	[5.2100000000E+03, 5.1058885343E+00, 2.1575550789E+01, 7.0213815102E-02, 6.9039735021E-02, 3.5515383452E-01],
	[5.2150000000E+03, 5.1115645786E+00, 2.1563469354E+01, 7.0416516732E-02, 6.9236622963E-02, 3.5540009862E-01],
	[5.2200000000E+03, 5.1172414843E+00, 2.1551406252E+01, 7.0619607782E-02, 6.9433876753E-02, 3.5564609471E-01],
	[5.2250000000E+03, 5.1229192506E+00, 2.1539361438E+01, 7.0823088623E-02, 6.9631496690E-02, 3.5589182342E-01],
	[5.2300000000E+03, 5.1285978770E+00, 2.1527334867E+01, 7.1026959628E-02, 6.9829483069E-02, 3.5613728537E-01],
	[5.2350000000E+03, 5.1342773626E+00, 2.1515326493E+01, 7.1231221169E-02, 7.0027836187E-02, 3.5638248116E-01],
	[5.2400000000E+03, 5.1399577068E+00, 2.1503336272E+01, 7.1435873618E-02, 7.0226556340E-02, 3.5662741142E-01],
	[5.2450000000E+03, 5.1456389089E+00, 2.1491364159E+01, 7.1640917345E-02, 7.0425643825E-02, 3.5687207675E-01],
	[5.2500000000E+03, 5.1513565555E+00, 2.1479618298E+01, 7.1846352725E-02, 7.0625107877E-02, 3.5711647777E-01],
	[5.2550000000E+03, 5.1570776646E+00, 2.1467904986E+01, 7.2052180127E-02, 7.0824940579E-02, 3.5736061508E-01],
	[5.2600000000E+03, 5.1627996776E+00, 2.1456209192E+01, 7.2258399925E-02, 7.1025141587E-02, 3.5760448928E-01],
	[5.2650000000E+03, 5.1685225937E+00, 2.1444530874E+01, 7.2465012490E-02, 7.1225711195E-02, 3.5784810099E-01],
	[5.2700000000E+03, 5.1742464124E+00, 2.1432869988E+01, 7.2672018194E-02, 7.1426649701E-02, 3.5809145079E-01],
	[5.2750000000E+03, 5.1799711328E+00, 2.1421226492E+01, 7.2879417408E-02, 7.1627957400E-02, 3.5833453930E-01],
	[5.2800000000E+03, 5.1856967543E+00, 2.1409600344E+01, 7.3087210506E-02, 7.1829634586E-02, 3.5857736709E-01],
	[5.2850000000E+03, 5.1914232761E+00, 2.1397991501E+01, 7.3295397858E-02, 7.2031681555E-02, 3.5881993478E-01],
	[5.2900000000E+03, 5.1971506976E+00, 2.1386399921E+01, 7.3503979836E-02, 7.2234098603E-02, 3.5906224296E-01],
	[5.2950000000E+03, 5.2028790179E+00, 2.1374825563E+01, 7.3712956813E-02, 7.2436886023E-02, 3.5930429220E-01],
	[5.3000000000E+03, 5.2086082365E+00, 2.1363268385E+01, 7.3922329160E-02, 7.2640044111E-02, 3.5954608311E-01],
	[5.3050000000E+03, 5.2143383526E+00, 2.1351728344E+01, 7.4132097250E-02, 7.2843573160E-02, 3.5978761626E-01],
	[5.3100000000E+03, 5.2200693655E+00, 2.1340205400E+01, 7.4342261453E-02, 7.3047473465E-02, 3.6002889225E-01],
	[5.3150000000E+03, 5.2258012745E+00, 2.1328699510E+01, 7.4552822142E-02, 7.3251745321E-02, 3.6026991165E-01],
	[5.3200000000E+03, 5.2315340789E+00, 2.1317210635E+01, 7.4763779688E-02, 7.3456389020E-02, 3.6051067505E-01],
	[5.3250000000E+03, 5.2372677779E+00, 2.1305738732E+01, 7.4975134464E-02, 7.3661404857E-02, 3.6075118306E-01],
	[5.3300000000E+03, 5.2430040121E+00, 2.1294293284E+01, 7.5186886841E-02, 7.3866793565E-02, 3.6099143641E-01],
	[5.3350000000E+03, 5.2487765230E+00, 2.1283069707E+01, 7.5399037191E-02, 7.4072564531E-02, 3.6123143579E-01],
	[5.3400000000E+03, 5.2545499730E+00, 2.1271862552E+01, 7.5611585886E-02, 7.4278708603E-02, 3.6147118184E-01],
	[5.3450000000E+03, 5.2603243613E+00, 2.1260671778E+01, 7.5824533298E-02, 7.4485226074E-02, 3.6171067524E-01],
	[5.3500000000E+03, 5.2660996872E+00, 2.1249497347E+01, 7.6037879798E-02, 7.4692117238E-02, 3.6194991663E-01],
	[5.3550000000E+03, 5.2718759500E+00, 2.1238339220E+01, 7.6251625758E-02, 7.4899382387E-02, 3.6218890667E-01],
	[5.3600000000E+03, 5.2776531490E+00, 2.1227197357E+01, 7.6465771551E-02, 7.5107021814E-02, 3.6242764602E-01],
	[5.3650000000E+03, 5.2834312834E+00, 2.1216071719E+01, 7.6680317547E-02, 7.5315035811E-02, 3.6266613531E-01],
	[5.3700000000E+03, 5.2892103525E+00, 2.1204962269E+01, 7.6895264118E-02, 7.5523424672E-02, 3.6290437521E-01],
	[5.3750000000E+03, 5.2949903556E+00, 2.1193868967E+01, 7.7110611637E-02, 7.5732188689E-02, 3.6314236635E-01],
	[5.3800000000E+03, 5.3007712920E+00, 2.1182791774E+01, 7.7326360476E-02, 7.5941328153E-02, 3.6338010937E-01],
	[5.3850000000E+03, 5.3065531609E+00, 2.1171730654E+01, 7.7542511005E-02, 7.6150843357E-02, 3.6361760491E-01],
	[5.3900000000E+03, 5.3123359618E+00, 2.1160685566E+01, 7.7759063596E-02, 7.6360734592E-02, 3.6385485362E-01],
	[5.3950000000E+03, 5.3181196937E+00, 2.1149656474E+01, 7.7976018622E-02, 7.6571002150E-02, 3.6409185612E-01],
	[5.4000000000E+03, 5.3239043561E+00, 2.1138643339E+01, 7.8193376454E-02, 7.6781646322E-02, 3.6432861305E-01],
	[5.4050000000E+03, 5.3296899481E+00, 2.1127646124E+01, 7.8411137464E-02, 7.6992667399E-02, 3.6456512504E-01],
	[5.4100000000E+03, 5.3354764692E+00, 2.1116664791E+01, 7.8629302023E-02, 7.7204065673E-02, 3.6480139270E-01],
	[5.4150000000E+03, 5.3412639185E+00, 2.1105699301E+01, 7.8847870504E-02, 7.7415841433E-02, 3.6503741668E-01],
	[5.4200000000E+03, 5.3470840212E+00, 2.1094931926E+01, 7.9066843277E-02, 7.7628004126E-02, 3.6527319759E-01],
	[5.4250000000E+03, 5.3529092593E+00, 2.1084203883E+01, 7.9286220715E-02, 7.7840546175E-02, 3.6550873605E-01],
	[5.4300000000E+03, 5.3587354685E+00, 2.1073491172E+01, 7.9506003190E-02, 7.8053466673E-02, 3.6574403268E-01],
	[5.4350000000E+03, 5.3645626479E+00, 2.1062793756E+01, 7.9726191073E-02, 7.8266765910E-02, 3.6597908809E-01],
	[5.4400000000E+03, 5.3703907967E+00, 2.1052111599E+01, 7.9946784735E-02, 7.8480444177E-02, 3.6621390291E-01],
	[5.4450000000E+03, 5.3762199144E+00, 2.1041444666E+01, 8.0167784549E-02, 7.8694501764E-02, 3.6644847773E-01],
	[5.4500000000E+03, 5.3820500001E+00, 2.1030792922E+01, 8.0389190886E-02, 7.8908938961E-02, 3.6668281317E-01],
	[5.4550000000E+03, 5.3878810531E+00, 2.1020156329E+01, 8.0611004118E-02, 7.9123756057E-02, 3.6691690983E-01],
	[5.4600000000E+03, 5.3937130728E+00, 2.1009534854E+01, 8.0833224616E-02, 7.9338953342E-02, 3.6715076832E-01],
	[5.4650000000E+03, 5.3995460583E+00, 2.0998928461E+01, 8.1055852752E-02, 7.9554531105E-02, 3.6738438924E-01],
	[5.4700000000E+03, 5.4053800089E+00, 2.0988337115E+01, 8.1278888899E-02, 7.9770489636E-02, 3.6761777319E-01],
	[5.4750000000E+03, 5.4112149240E+00, 2.0977760780E+01, 8.1502333426E-02, 7.9986829224E-02, 3.6785092077E-01],
	[5.4800000000E+03, 5.4170508027E+00, 2.0967199421E+01, 8.1727136425E-02, 8.0204464816E-02, 3.6808383257E-01],
	[5.4850000000E+03, 5.4228876445E+00, 2.0956653005E+01, 8.1953119250E-02, 8.0423224101E-02, 3.6831650919E-01],
	[5.4900000000E+03, 5.4287254485E+00, 2.0946121495E+01, 8.2179519471E-02, 8.0642372668E-02, 3.6854895121E-01],
	[5.4950000000E+03, 5.4345642140E+00, 2.0935604858E+01, 8.2406337475E-02, 8.0861910818E-02, 3.6878115923E-01],
	[5.5000000000E+03, 5.4404039404E+00, 2.0925103059E+01, 8.2633573649E-02, 8.1081838851E-02, 3.6901313383E-01],
	[5.5050000000E+03, 5.4462601690E+00, 2.0914704768E+01, 8.2861228382E-02, 8.1302161873E-02, 3.6924487560E-01],
	[5.5100000000E+03, 5.4521365987E+00, 2.0904430613E+01, 8.3089302061E-02, 8.1522881387E-02, 3.6947638511E-01],
	[5.5150000000E+03, 5.4580140302E+00, 2.0894170818E+01, 8.3317795073E-02, 8.1743991781E-02, 3.6970766296E-01],
	[5.5200000000E+03, 5.4638924628E+00, 2.0883925348E+01, 8.3546707806E-02, 8.1965493356E-02, 3.6993870971E-01],
	[5.5250000000E+03, 5.4697718958E+00, 2.0873694172E+01, 8.3776040649E-02, 8.2187386413E-02, 3.7016952594E-01],
	[5.5300000000E+03, 5.4756523284E+00, 2.0863477257E+01, 8.4005793987E-02, 8.2409671252E-02, 3.7040011223E-01],
	[5.5350000000E+03, 5.4815337600E+00, 2.0853274568E+01, 8.4235968210E-02, 8.2632348175E-02, 3.7063046915E-01],
	[5.5400000000E+03, 5.4874161897E+00, 2.0843086075E+01, 8.4466563704E-02, 8.2855417481E-02, 3.7086059726E-01],
	[5.5450000000E+03, 5.4932996169E+00, 2.0832911744E+01, 8.4697580858E-02, 8.3078879470E-02, 3.7109049715E-01],
	[5.5500000000E+03, 5.4991840408E+00, 2.0822751543E+01, 8.4929020059E-02, 8.3302734442E-02, 3.7132016936E-01],
	[5.5550000000E+03, 5.5050694607E+00, 2.0812605440E+01, 8.5160881694E-02, 8.3526982697E-02, 3.7154961447E-01],
	[5.5600000000E+03, 5.5109558758E+00, 2.0802473402E+01, 8.5393166151E-02, 8.3751624534E-02, 3.7177883304E-01],
	[5.5650000000E+03, 5.5168432855E+00, 2.0792355398E+01, 8.5625873819E-02, 8.3976660252E-02, 3.7200782562E-01],
	[5.5700000000E+03, 5.5227316889E+00, 2.0782251395E+01, 8.5859005084E-02, 8.4202090150E-02, 3.7223659277E-01],
	[5.5750000000E+03, 5.5286210855E+00, 2.0772161361E+01, 8.6092560334E-02, 8.4427914528E-02, 3.7246513506E-01],
	[5.5800000000E+03, 5.5345114744E+00, 2.0762085265E+01, 8.6326539957E-02, 8.4654133683E-02, 3.7269345303E-01],
	[5.5850000000E+03, 5.5404028550E+00, 2.0752023074E+01, 8.6560944341E-02, 8.4880747915E-02, 3.7292154723E-01],
	[5.5900000000E+03, 5.5462952264E+00, 2.0741974758E+01, 8.6795773872E-02, 8.5107757521E-02, 3.7314941822E-01],
	[5.5950000000E+03, 5.5522131287E+00, 2.0732079390E+01, 8.7031028940E-02, 8.5335170954E-02, 3.7337706654E-01],
	[5.6000000000E+03, 5.5581411412E+00, 2.0722249024E+01, 8.7266709931E-02, 8.5562983458E-02, 3.7360449273E-01],
	[5.6050000000E+03, 5.5640701841E+00, 2.0712432086E+01, 8.7502817233E-02, 8.5791192327E-02, 3.7383169735E-01],
	[5.6100000000E+03, 5.5700002564E+00, 2.0702628546E+01, 8.7739351234E-02, 8.6019797857E-02, 3.7405868094E-01],
	[5.6150000000E+03, 5.5759313575E+00, 2.0692838374E+01, 8.7976312321E-02, 8.6248800348E-02, 3.7428544402E-01],
	[5.6200000000E+03, 5.5818634867E+00, 2.0683061539E+01, 8.8213700883E-02, 8.6478200095E-02, 3.7451198715E-01],
	[5.6250000000E+03, 5.5877966432E+00, 2.0673298012E+01, 8.8451517306E-02, 8.6707997398E-02, 3.7473831086E-01],
	[5.6300000000E+03, 5.5937308263E+00, 2.0663547762E+01, 8.8689761979E-02, 8.6938192552E-02, 3.7496441568E-01],
	[5.6350000000E+03, 5.5996660352E+00, 2.0653810761E+01, 8.8928435288E-02, 8.7168785856E-02, 3.7519030215E-01],
	[5.6400000000E+03, 5.6056022692E+00, 2.0644086977E+01, 8.9167537623E-02, 8.7399777605E-02, 3.7541597079E-01],
	[5.6450000000E+03, 5.6115395276E+00, 2.0634376382E+01, 8.9407069370E-02, 8.7631168096E-02, 3.7564142213E-01],
	[5.6500000000E+03, 5.6174778097E+00, 2.0624678945E+01, 8.9647030918E-02, 8.7862957626E-02, 3.7586665679E-01],
	[5.6550000000E+03, 5.6234171147E+00, 2.0614994638E+01, 8.9887422653E-02, 8.8095146490E-02, 3.7609167538E-01],
	[5.6600000000E+03, 5.6293574418E+00, 2.0605323431E+01, 9.0128244964E-02, 8.8327734986E-02, 3.7631647848E-01],
	[5.6650000000E+03, 5.6352987905E+00, 2.0595665295E+01, 9.0369498238E-02, 8.8560723408E-02, 3.7654106667E-01],
	[5.6700000000E+03, 5.6412411598E+00, 2.0586020200E+01, 9.0611182862E-02, 8.8794112052E-02, 3.7676544054E-01],
	[5.6750000000E+03, 5.6471845492E+00, 2.0576388118E+01, 9.0853299226E-02, 8.9027901213E-02, 3.7698960066E-01],
	[5.6800000000E+03, 5.6531289579E+00, 2.0566769020E+01, 9.1095847716E-02, 8.9262091187E-02, 3.7721354760E-01],
	[5.6850000000E+03, 5.6590980107E+00, 2.0557296097E+01, 9.1338828719E-02, 8.9496690703E-02, 3.7743728195E-01],
	[5.6900000000E+03, 5.6650769789E+00, 2.0547885792E+01, 9.1582242625E-02, 8.9731694870E-02, 3.7766080426E-01],
	[5.6950000000E+03, 5.6710570041E+00, 2.0538488055E+01, 9.1826089820E-02, 8.9967100832E-02, 3.7788411511E-01],
	[5.7000000000E+03, 5.6770380856E+00, 2.0529102858E+01, 9.2070370691E-02, 9.0202908884E-02, 3.7810721506E-01],
	[5.7050000000E+03, 5.6830202225E+00, 2.0519730172E+01, 9.2315085628E-02, 9.0439119320E-02, 3.7833010469E-01],
	[5.7100000000E+03, 5.6890034142E+00, 2.0510369971E+01, 9.2560235017E-02, 9.0675732436E-02, 3.7855278454E-01],
	[5.7150000000E+03, 5.6949876599E+00, 2.0501022227E+01, 9.2805819246E-02, 9.0912748526E-02, 3.7877525518E-01],
	[5.7200000000E+03, 5.7009729588E+00, 2.0491686912E+01, 9.3051838703E-02, 9.1150167883E-02, 3.7899751717E-01],
	[5.7250000000E+03, 5.7069593104E+00, 2.0482363999E+01, 9.3298293776E-02, 9.1387990802E-02, 3.7921957106E-01],
	[5.7300000000E+03, 5.7129467137E+00, 2.0473053461E+01, 9.3545184852E-02, 9.1626217575E-02, 3.7944141741E-01],
	[5.7350000000E+03, 5.7189351681E+00, 2.0463755271E+01, 9.3792566433E-02, 9.1864900410E-02, 3.7966305677E-01],
	[5.7400000000E+03, 5.7249246729E+00, 2.0454469400E+01, 9.4040446735E-02, 9.2104047096E-02, 3.7988448969E-01],
	[5.7450000000E+03, 5.7309152273E+00, 2.0445195824E+01, 9.4288764787E-02, 9.2343599059E-02, 3.8010571671E-01],
	[5.7500000000E+03, 5.7369068305E+00, 2.0435934513E+01, 9.4537520978E-02, 9.2583556594E-02, 3.8032673839E-01],
	[5.7550000000E+03, 5.7428994819E+00, 2.0426685443E+01, 9.4786715699E-02, 9.2823919994E-02, 3.8054755527E-01],
	[5.7600000000E+03, 5.7488931808E+00, 2.0417448585E+01, 9.5036349336E-02, 9.3064689554E-02, 3.8076816788E-01],
	[5.7650000000E+03, 5.7548879263E+00, 2.0408223913E+01, 9.5286422281E-02, 9.3305865565E-02, 3.8098857677E-01],
	[5.7700000000E+03, 5.7608837179E+00, 2.0399011400E+01, 9.5536934922E-02, 9.3547448322E-02, 3.8120878248E-01],
	[5.7750000000E+03, 5.7668941807E+00, 2.0389887587E+01, 9.5787887648E-02, 9.3789443342E-02, 3.8142878554E-01],
	[5.7800000000E+03, 5.7729234317E+00, 2.0380875207E+01, 9.6039280849E-02, 9.4031852558E-02, 3.8164858649E-01],
	[5.7850000000E+03, 5.7789537646E+00, 2.0371874598E+01, 9.6291114912E-02, 9.4274669498E-02, 3.8186818585E-01],
	[5.7900000000E+03, 5.7849851789E+00, 2.0362885735E+01, 9.6543390229E-02, 9.4517894455E-02, 3.8208758416E-01],
	[5.7950000000E+03, 5.7910176737E+00, 2.0353908592E+01, 9.6796107187E-02, 9.4761527723E-02, 3.8230678195E-01],
	[5.8000000000E+03, 5.7970512482E+00, 2.0344943144E+01, 9.7049266177E-02, 9.5005569593E-02, 3.8252577975E-01],
	[5.8050000000E+03, 5.8030859018E+00, 2.0335989365E+01, 9.7302867586E-02, 9.5250020359E-02, 3.8274457807E-01],
	[5.8100000000E+03, 5.8091216338E+00, 2.0327047231E+01, 9.7556911805E-02, 9.5494880311E-02, 3.8296317744E-01],
	[5.8150000000E+03, 5.8151584433E+00, 2.0318116716E+01, 9.7811399222E-02, 9.5740149742E-02, 3.8318157839E-01],
	[5.8200000000E+03, 5.8211963296E+00, 2.0309197795E+01, 9.8066330226E-02, 9.5985828945E-02, 3.8339978142E-01],
	[5.8250000000E+03, 5.8272352921E+00, 2.0300290442E+01, 9.8321705208E-02, 9.6231918209E-02, 3.8361778706E-01],
	[5.8300000000E+03, 5.8332753299E+00, 2.0291394634E+01, 9.8577524555E-02, 9.6478417827E-02, 3.8383559582E-01],
	[5.8350000000E+03, 5.8393164424E+00, 2.0282510346E+01, 9.8833788658E-02, 9.6725328090E-02, 3.8405320822E-01],
	[5.8400000000E+03, 5.8453586288E+00, 2.0273637552E+01, 9.9090497905E-02, 9.6972649288E-02, 3.8427062477E-01],
	[5.8450000000E+03, 5.8514018883E+00, 2.0264776227E+01, 9.9347652686E-02, 9.7220381712E-02, 3.8448784598E-01],
	[5.8500000000E+03, 5.8574462204E+00, 2.0255926348E+01, 9.9605253389E-02, 9.7468525653E-02, 3.8470487235E-01],
	[5.8550000000E+03, 5.8634916242E+00, 2.0247087890E+01, 9.9863300404E-02, 9.7717081401E-02, 3.8492170439E-01],
	[5.8600000000E+03, 5.8695380989E+00, 2.0238260827E+01, 1.0012179412E-01, 9.7966049246E-02, 3.8513834261E-01],
	[5.8650000000E+03, 5.8755856440E+00, 2.0229445137E+01, 1.0038073493E-01, 9.8215429478E-02, 3.8535478751E-01],
	[5.8700000000E+03, 5.8816598666E+00, 2.0220784235E+01, 1.0064012321E-01, 9.8465232965E-02, 3.8557103959E-01],
	[5.8750000000E+03, 5.8877397884E+00, 2.0212160135E+01, 1.0089995937E-01, 9.8715451411E-02, 3.8578709935E-01],
	[5.8800000000E+03, 5.8938208148E+00, 2.0203547045E+01, 1.0116024378E-01, 9.8966083214E-02, 3.8600296728E-01],
	[5.8850000000E+03, 5.8999029451E+00, 2.0194944942E+01, 1.0142097684E-01, 9.9217128665E-02, 3.8621864389E-01],
	[5.8900000000E+03, 5.9059861786E+00, 2.0186353802E+01, 1.0168215894E-01, 9.9468588053E-02, 3.8643412967E-01],
	[5.8950000000E+03, 5.9120705145E+00, 2.0177773602E+01, 1.0194379046E-01, 9.9720461667E-02, 3.8664942511E-01],
	[5.9000000000E+03, 5.9181559521E+00, 2.0169204319E+01, 1.0220587179E-01, 9.9972749796E-02, 3.8686453069E-01],
	[5.9050000000E+03, 5.9242424907E+00, 2.0160645929E+01, 1.0246840334E-01, 1.0022545273E-01, 3.8707944692E-01],
	[5.9100000000E+03, 5.9303301295E+00, 2.0152098410E+01, 1.0273138547E-01, 1.0047857075E-01, 3.8729417427E-01],
	[5.9150000000E+03, 5.9364188678E+00, 2.0143561739E+01, 1.0299481859E-01, 1.0073210416E-01, 3.8750871323E-01],
	[5.9200000000E+03, 5.9425087048E+00, 2.0135035893E+01, 1.0325870307E-01, 1.0098605323E-01, 3.8772306430E-01],
	[5.9250000000E+03, 5.9485996399E+00, 2.0126520848E+01, 1.0352303932E-01, 1.0124041826E-01, 3.8793722793E-01],
	[5.9300000000E+03, 5.9546916723E+00, 2.0118016582E+01, 1.0378782772E-01, 1.0149519953E-01, 3.8815120463E-01],
	[5.9350000000E+03, 5.9607848013E+00, 2.0109523073E+01, 1.0405306866E-01, 1.0175039733E-01, 3.8836499487E-01],
	[5.9400000000E+03, 5.9668790262E+00, 2.0101040298E+01, 1.0431876253E-01, 1.0200601196E-01, 3.8857859912E-01],
	[5.9450000000E+03, 5.9729743461E+00, 2.0092568234E+01, 1.0458490971E-01, 1.0226204369E-01, 3.8879201787E-01],
	[5.9500000000E+03, 5.9790707605E+00, 2.0084106858E+01, 1.0485151060E-01, 1.0251849281E-01, 3.8900525157E-01],
	[5.9550000000E+03, 5.9851682686E+00, 2.0075656149E+01, 1.0511856559E-01, 1.0277535961E-01, 3.8921830060E-01],
	[5.9600000000E+03, 5.9912668696E+00, 2.0067216083E+01, 1.0538607506E-01, 1.0303264437E-01, 3.8943116533E-01],
	[5.9650000000E+03, 5.9973945120E+00, 2.0058942961E+01, 1.0565403941E-01, 1.0329035982E-01, 3.8964384630E-01],
	[5.9700000000E+03, 6.0035243943E+00, 2.0050686403E+01, 1.0592245903E-01, 1.0354849441E-01, 3.8985634402E-01],
	[5.9750000000E+03, 6.0096554022E+00, 2.0042440151E+01, 1.0619133429E-01, 1.0380704793E-01, 3.9006865900E-01],
	[5.9800000000E+03, 6.0157875350E+00, 2.0034204184E+01, 1.0646066560E-01, 1.0406602066E-01, 3.9028079177E-01],
	[5.9850000000E+03, 6.0219207921E+00, 2.0025978481E+01, 1.0673045334E-01, 1.0432541289E-01, 3.9049274284E-01],
	[5.9900000000E+03, 6.0280551726E+00, 2.0017763020E+01, 1.0700069791E-01, 1.0458522490E-01, 3.9070451271E-01],
	[5.9950000000E+03, 6.0341906759E+00, 2.0009557780E+01, 1.0727139968E-01, 1.0484545699E-01, 3.9091610189E-01],
	[6.0000000000E+03, 6.0403273011E+00, 2.0001362739E+01, 1.0754255905E-01, 1.0510610944E-01, 3.9112751090E-01],
	[6.0050000000E+03, 6.0464650477E+00, 1.9993177877E+01, 1.0781549058E-01, 1.0536843771E-01, 3.9133874023E-01],
	[6.0100000000E+03, 6.0526039148E+00, 1.9985003172E+01, 1.0808888609E-01, 1.0563119206E-01, 3.9154979039E-01],
	[6.0150000000E+03, 6.0587439017E+00, 1.9976838604E+01, 1.0836274598E-01, 1.0589437276E-01, 3.9176066189E-01],
	[6.0200000000E+03, 6.0648850077E+00, 1.9968684151E+01, 1.0863707065E-01, 1.0615798011E-01, 3.9197135521E-01],
	[6.0250000000E+03, 6.0710272321E+00, 1.9960539792E+01, 1.0891186049E-01, 1.0642201440E-01, 3.9218187086E-01],
	[6.0300000000E+03, 6.0771705741E+00, 1.9952405508E+01, 1.0918711591E-01, 1.0668647593E-01, 3.9239220934E-01],
	[6.0350000000E+03, 6.0833150330E+00, 1.9944281275E+01, 1.0946283731E-01, 1.0695136498E-01, 3.9260237114E-01],
	[6.0400000000E+03, 6.0894606081E+00, 1.9936167075E+01, 1.0973902508E-01, 1.0721668185E-01, 3.9281235676E-01],
	[6.0450000000E+03, 6.0956072987E+00, 1.9928062887E+01, 1.1001567963E-01, 1.0748242684E-01, 3.9302216667E-01],
	[6.0500000000E+03, 6.1017551041E+00, 1.9919968689E+01, 1.1029280136E-01, 1.0774860023E-01, 3.9323180139E-01],
	[6.0550000000E+03, 6.1079040235E+00, 1.9911884461E+01, 1.1057039067E-01, 1.0801520231E-01, 3.9344126138E-01],
	[6.0600000000E+03, 6.1140756819E+00, 1.9903930594E+01, 1.1084844796E-01, 1.0828224372E-01, 3.9365054714E-01],
	[6.0650000000E+03, 6.1202548885E+00, 1.9896022099E+01, 1.1112697362E-01, 1.0854971756E-01, 3.9385965915E-01],
	[6.0700000000E+03, 6.1264352404E+00, 1.9888123260E+01, 1.1140596806E-01, 1.0881762109E-01, 3.9406859790E-01],
	[6.0750000000E+03, 6.1326167367E+00, 1.9880234056E+01, 1.1168543168E-01, 1.0908595457E-01, 3.9427736386E-01],
	[6.0800000000E+03, 6.1387993769E+00, 1.9872354468E+01, 1.1196536487E-01, 1.0935471832E-01, 3.9448595752E-01],
	[6.0850000000E+03, 6.1449831602E+00, 1.9864484477E+01, 1.1224576804E-01, 1.0962391261E-01, 3.9469437935E-01],
	[6.0900000000E+03, 6.1511680857E+00, 1.9856624063E+01, 1.1252664159E-01, 1.0989353774E-01, 3.9490262983E-01],
	[6.0950000000E+03, 6.1573541529E+00, 1.9848773207E+01, 1.1280798592E-01, 1.1016359399E-01, 3.9511070943E-01],
	[6.1000000000E+03, 6.1635413610E+00, 1.9840931888E+01, 1.1308980143E-01, 1.1043408166E-01, 3.9531861863E-01],
	[6.1050000000E+03, 6.1697297093E+00, 1.9833100088E+01, 1.1337208851E-01, 1.1070500104E-01, 3.9552635790E-01],
	[6.1100000000E+03, 6.1759191969E+00, 1.9825277787E+01, 1.1365484757E-01, 1.1097635242E-01, 3.9573392770E-01],
	[6.1150000000E+03, 6.1821098233E+00, 1.9817464966E+01, 1.1393807901E-01, 1.1124813608E-01, 3.9594132851E-01],
	[6.1200000000E+03, 6.1883015877E+00, 1.9809661606E+01, 1.1422178323E-01, 1.1152035231E-01, 3.9614856079E-01],
	[6.1250000000E+03, 6.1944944894E+00, 1.9801867688E+01, 1.1450596063E-01, 1.1179300141E-01, 3.9635562500E-01],
	[6.1300000000E+03, 6.2006885276E+00, 1.9794083192E+01, 1.1479061160E-01, 1.1206608367E-01, 3.9656252161E-01],
	[6.1350000000E+03, 6.2068837016E+00, 1.9786308100E+01, 1.1507573655E-01, 1.1233959936E-01, 3.9676925109E-01],
	[6.1400000000E+03, 6.2130800108E+00, 1.9778542392E+01, 1.1536133588E-01, 1.1261354878E-01, 3.9697581388E-01],
	[6.1450000000E+03, 6.2192774543E+00, 1.9770786049E+01, 1.1564740999E-01, 1.1288793221E-01, 3.9718221046E-01],
	[6.1500000000E+03, 6.2254760316E+00, 1.9763039053E+01, 1.1593395928E-01, 1.1316274996E-01, 3.9738844127E-01],
	[6.1550000000E+03, 6.2316831189E+00, 1.9755342176E+01, 1.1622098415E-01, 1.1343800608E-01, 3.9759450678E-01],
	[6.1600000000E+03, 6.2379110694E+00, 1.9747763445E+01, 1.1650848500E-01, 1.1371370728E-01, 3.9780040743E-01],
	[6.1650000000E+03, 6.2441401835E+00, 1.9740193767E+01, 1.1679646222E-01, 1.1398984375E-01, 3.9800614368E-01],
	[6.1700000000E+03, 6.2503704604E+00, 1.9732633124E+01, 1.1708491623E-01, 1.1426641579E-01, 3.9821171598E-01],
	[6.1750000000E+03, 6.2566018993E+00, 1.9725081497E+01, 1.1737384742E-01, 1.1454342367E-01, 3.9841712477E-01],
	[6.1800000000E+03, 6.2628344996E+00, 1.9717538870E+01, 1.1766325618E-01, 1.1482086770E-01, 3.9862237052E-01],
	[6.1850000000E+03, 6.2690682606E+00, 1.9710005223E+01, 1.1795314293E-01, 1.1509874815E-01, 3.9882745366E-01],
	[6.1900000000E+03, 6.2753031814E+00, 1.9702480538E+01, 1.1824350806E-01, 1.1537706531E-01, 3.9903237464E-01],
	[6.1950000000E+03, 6.2815392615E+00, 1.9694964799E+01, 1.1853435196E-01, 1.1565581947E-01, 3.9923713390E-01],
	[6.2000000000E+03, 6.2877765000E+00, 1.9687457987E+01, 1.1882567505E-01, 1.1593501092E-01, 3.9944173189E-01],
	[6.2050000000E+03, 6.2940148964E+00, 1.9679960083E+01, 1.1911747772E-01, 1.1621463993E-01, 3.9964616904E-01],
	[6.2100000000E+03, 6.3002544497E+00, 1.9672471072E+01, 1.1940976037E-01, 1.1649470680E-01, 3.9985044580E-01],
	[6.2150000000E+03, 6.3064951594E+00, 1.9664990934E+01, 1.1970252340E-01, 1.1677521181E-01, 4.0005456260E-01],
	[6.2200000000E+03, 6.3127370246E+00, 1.9657519652E+01, 1.1999576722E-01, 1.1705615524E-01, 4.0025851988E-01],
	[6.2250000000E+03, 6.3189800448E+00, 1.9650057209E+01, 1.2028949221E-01, 1.1733753738E-01, 4.0046231808E-01],
	[6.2300000000E+03, 6.3252242191E+00, 1.9642603587E+01, 1.2058369879E-01, 1.1761935852E-01, 4.0066595762E-01],
	[6.2350000000E+03, 6.3314695469E+00, 1.9635158768E+01, 1.2087838735E-01, 1.1790161894E-01, 4.0086943894E-01],
	[6.2400000000E+03, 6.3377160275E+00, 1.9627722736E+01, 1.2117355829E-01, 1.1818431893E-01, 4.0107276248E-01],
	[6.2450000000E+03, 6.3439636601E+00, 1.9620295472E+01, 1.2146921202E-01, 1.1846745876E-01, 4.0127592865E-01],
	[6.2500000000E+03, 6.3502124440E+00, 1.9612876960E+01, 1.2176534893E-01, 1.1875103872E-01, 4.0147893789E-01],
	[6.2550000000E+03, 6.3564743906E+00, 1.9605533150E+01, 1.2206196943E-01, 1.1903506574E-01, 4.0168179063E-01],
	[6.2600000000E+03, 6.3627516501E+00, 1.9598275554E+01, 1.2235907391E-01, 1.1931954137E-01, 4.0188448729E-01],
	[6.2650000000E+03, 6.3690300895E+00, 1.9591026436E+01, 1.2265666277E-01, 1.1960445809E-01, 4.0208702829E-01],
	[6.2700000000E+03, 6.3753097080E+00, 1.9583785779E+01, 1.2295473642E-01, 1.1988981618E-01, 4.0228941406E-01],
	[6.2750000000E+03, 6.3815905048E+00, 1.9576553566E+01, 1.2325329525E-01, 1.2017561594E-01, 4.0249164502E-01],
	[6.2800000000E+03, 6.3878724794E+00, 1.9569329782E+01, 1.2355233967E-01, 1.2046185765E-01, 4.0269372159E-01],
	[6.2850000000E+03, 6.3941556309E+00, 1.9562114409E+01, 1.2385187007E-01, 1.2074854158E-01, 4.0289564418E-01],
	[6.2900000000E+03, 6.4004399586E+00, 1.9554907432E+01, 1.2415188687E-01, 1.2103566802E-01, 4.0309741322E-01],
	[6.2950000000E+03, 6.4067254618E+00, 1.9547708832E+01, 1.2445239044E-01, 1.2132323726E-01, 4.0329902912E-01],
	[6.3000000000E+03, 6.4130121398E+00, 1.9540518596E+01, 1.2475338121E-01, 1.2161124956E-01, 4.0350049229E-01],
	[6.3050000000E+03, 6.4192999919E+00, 1.9533336705E+01, 1.2505485956E-01, 1.2189970523E-01, 4.0370180315E-01],
	[6.3100000000E+03, 6.4255890174E+00, 1.9526163144E+01, 1.2535682590E-01, 1.2218860453E-01, 4.0390296212E-01],
	[6.3150000000E+03, 6.4318792156E+00, 1.9518997896E+01, 1.2565928063E-01, 1.2247794775E-01, 4.0410396959E-01],
	[6.3200000000E+03, 6.4381705857E+00, 1.9511840945E+01, 1.2596222415E-01, 1.2276773518E-01, 4.0430482598E-01],
	[6.3250000000E+03, 6.4444631271E+00, 1.9504692275E+01, 1.2626565685E-01, 1.2305796708E-01, 4.0450553171E-01],
	[6.3300000000E+03, 6.4507568390E+00, 1.9497551870E+01, 1.2656957915E-01, 1.2334864375E-01, 4.0470608717E-01],
	[6.3350000000E+03, 6.4570517208E+00, 1.9490419714E+01, 1.2687399143E-01, 1.2363976545E-01, 4.0490649277E-01],
	[6.3400000000E+03, 6.4633477717E+00, 1.9483295791E+01, 1.2717889411E-01, 1.2393133249E-01, 4.0510674892E-01],
	[6.3450000000E+03, 6.4696449910E+00, 1.9476180085E+01, 1.2748428758E-01, 1.2422334512E-01, 4.0530685602E-01],
	[6.3500000000E+03, 6.4759433780E+00, 1.9469072579E+01, 1.2779017224E-01, 1.2451580364E-01, 4.0550681447E-01],
	[6.3550000000E+03, 6.4822511825E+00, 1.9462018339E+01, 1.2809654849E-01, 1.2480871323E-01, 4.0570662467E-01],
	[6.3600000000E+03, 6.4885771300E+00, 1.9455064786E+01, 1.2840341673E-01, 1.2510207944E-01, 4.0590628702E-01],
	[6.3650000000E+03, 6.4949042723E+00, 1.9448119178E+01, 1.2871077736E-01, 1.2539589248E-01, 4.0610580193E-01],
	[6.3700000000E+03, 6.5012326088E+00, 1.9441181500E+01, 1.2901863079E-01, 1.2569015264E-01, 4.0630516978E-01],
	[6.3750000000E+03, 6.5075621387E+00, 1.9434251739E+01, 1.2932697741E-01, 1.2598486020E-01, 4.0650439098E-01],
	[6.3800000000E+03, 6.5138928613E+00, 1.9427329877E+01, 1.2963581763E-01, 1.2628001543E-01, 4.0670346591E-01],
	[6.3850000000E+03, 6.5202247759E+00, 1.9420415900E+01, 1.2994515184E-01, 1.2657561861E-01, 4.0690239498E-01],
	[6.3900000000E+03, 6.5265578819E+00, 1.9413509793E+01, 1.3025498045E-01, 1.2687167003E-01, 4.0710117856E-01],
	[6.3950000000E+03, 6.5328921784E+00, 1.9406611541E+01, 1.3056530385E-01, 1.2716816995E-01, 4.0729981707E-01],
	[6.4000000000E+03, 6.5392276648E+00, 1.9399721129E+01, 1.3087612245E-01, 1.2746511866E-01, 4.0749831088E-01],
	[6.4050000000E+03, 6.5455643404E+00, 1.9392838541E+01, 1.3118743664E-01, 1.2776251644E-01, 4.0769666038E-01],
	[6.4100000000E+03, 6.5519022045E+00, 1.9385963763E+01, 1.3149924684E-01, 1.2806036356E-01, 4.0789486597E-01],
	[6.4150000000E+03, 6.5582412564E+00, 1.9379096779E+01, 1.3181155343E-01, 1.2835866031E-01, 4.0809292802E-01],
	[6.4200000000E+03, 6.5645814953E+00, 1.9372237576E+01, 1.3212435682E-01, 1.2865740695E-01, 4.0829084692E-01],
	[6.4250000000E+03, 6.5709229206E+00, 1.9365386137E+01, 1.3243765741E-01, 1.2895660376E-01, 4.0848862307E-01],
	[6.4300000000E+03, 6.5772655315E+00, 1.9358542448E+01, 1.3275145559E-01, 1.2925625103E-01, 4.0868625683E-01],
	[6.4350000000E+03, 6.5836093275E+00, 1.9351706495E+01, 1.3306575178E-01, 1.2955634902E-01, 4.0888374860E-01],
	[6.4400000000E+03, 6.5899543077E+00, 1.9344878263E+01, 1.3338054637E-01, 1.2985689802E-01, 4.0908109875E-01],
	[6.4450000000E+03, 6.5963004714E+00, 1.9338057736E+01, 1.3369583976E-01, 1.3015789830E-01, 4.0927830766E-01],
	[6.4500000000E+03, 6.6026478180E+00, 1.9331244900E+01, 1.3401163236E-01, 1.3045935013E-01, 4.0947537571E-01],
	[6.4550000000E+03, 6.6089963468E+00, 1.9324439741E+01, 1.3432792455E-01, 1.3076125380E-01, 4.0967230328E-01],
	[6.4600000000E+03, 6.6153671983E+00, 1.9317757235E+01, 1.3464471675E-01, 1.3106362316E-01, 4.0986909075E-01],
	[6.4650000000E+03, 6.6217423821E+00, 1.9311099195E+01, 1.3496200936E-01, 1.3136644703E-01, 4.1006573849E-01],
	[6.4700000000E+03, 6.6281187739E+00, 1.9304448595E+01, 1.3527980276E-01, 1.3166972367E-01, 4.1026224687E-01],
	[6.4750000000E+03, 6.6344963730E+00, 1.9297805420E+01, 1.3559809738E-01, 1.3197345336E-01, 4.1045861627E-01],
	[6.4800000000E+03, 6.6408751786E+00, 1.9291169656E+01, 1.3591689360E-01, 1.3227763638E-01, 4.1065484706E-01],
	[6.4850000000E+03, 6.6472551901E+00, 1.9284541289E+01, 1.3623620671E-01, 1.3258228709E-01, 4.1085093961E-01],
	[6.4900000000E+03, 6.6536364067E+00, 1.9277920306E+01, 1.3655602488E-01, 1.3288739419E-01, 4.1104689430E-01],
	[6.4950000000E+03, 6.6600188278E+00, 1.9271306693E+01, 1.3687634593E-01, 1.3319295549E-01, 4.1124271148E-01],
	[6.5000000000E+03, 6.6664024526E+00, 1.9264700435E+01, 1.3719717025E-01, 1.3349897129E-01, 4.1143839152E-01],
	[6.5050000000E+03, 6.6727872805E+00, 1.9258101519E+01, 1.3751849826E-01, 1.3380544184E-01, 4.1163393480E-01],
	[6.5100000000E+03, 6.6791733107E+00, 1.9251509931E+01, 1.3784033035E-01, 1.3411236743E-01, 4.1182934168E-01],
	[6.5150000000E+03, 6.6855605426E+00, 1.9244925657E+01, 1.3816266692E-01, 1.3441974833E-01, 4.1202461252E-01],
	[6.5200000000E+03, 6.6919489755E+00, 1.9238348684E+01, 1.3848550838E-01, 1.3472758480E-01, 4.1221974772E-01],
	[6.5250000000E+03, 6.6983386086E+00, 1.9231778998E+01, 1.3880885512E-01, 1.3503587713E-01, 4.1241474786E-01],
	[6.5300000000E+03, 6.7047294412E+00, 1.9225216584E+01, 1.3913270754E-01, 1.3534462559E-01, 4.1260961336E-01],
	[6.5350000000E+03, 6.7111214728E+00, 1.9218661431E+01, 1.3945706605E-01, 1.3565383044E-01, 4.1280434458E-01],
	[6.5400000000E+03, 6.7175147025E+00, 1.9212113523E+01, 1.3978193104E-01, 1.3596349196E-01, 4.1299894192E-01],
	[6.5450000000E+03, 6.7239091298E+00, 1.9205572848E+01, 1.4010730293E-01, 1.3627361043E-01, 4.1319340574E-01],
	[6.5500000000E+03, 6.7303047538E+00, 1.9199039392E+01, 1.4043318210E-01, 1.3658418611E-01, 4.1338773642E-01],
	[6.5550000000E+03, 6.7367015739E+00, 1.9192513142E+01, 1.4075956896E-01, 1.3689521928E-01, 4.1358193434E-01],
	[6.5600000000E+03, 6.7431015884E+00, 1.9186004942E+01, 1.4108646390E-01, 1.3720671158E-01, 4.1377599986E-01],
	[6.5650000000E+03, 6.7495241145E+00, 1.9179619544E+01, 1.4141386734E-01, 1.3751867672E-01, 4.1396993336E-01],
	[6.5700000000E+03, 6.7559478612E+00, 1.9173241131E+01, 1.4174177968E-01, 1.3783110027E-01, 4.1416373521E-01],
	[6.5750000000E+03, 6.7623728278E+00, 1.9166869688E+01, 1.4207020130E-01, 1.3814398252E-01, 4.1435740578E-01],
	[6.5800000000E+03, 6.7687990136E+00, 1.9160505204E+01, 1.4239913262E-01, 1.3845732372E-01, 4.1455094543E-01],
	[6.5850000000E+03, 6.7752264179E+00, 1.9154147665E+01, 1.4272857403E-01, 1.3877112416E-01, 4.1474435453E-01],
	[6.5900000000E+03, 6.7816550399E+00, 1.9147797058E+01, 1.4305852594E-01, 1.3908538410E-01, 4.1493763346E-01],
	[6.5950000000E+03, 6.7880848791E+00, 1.9141453372E+01, 1.4338898874E-01, 1.3940010381E-01, 4.1513078256E-01],
	[6.6000000000E+03, 6.7945159346E+00, 1.9135116592E+01, 1.4371996285E-01, 1.3971528357E-01, 4.1532380221E-01],
	[6.6050000000E+03, 6.8009482059E+00, 1.9128786706E+01, 1.4405144865E-01, 1.4003092363E-01, 4.1551669277E-01],
	[6.6100000000E+03, 6.8073816922E+00, 1.9122463702E+01, 1.4438344655E-01, 1.4034702428E-01, 4.1570945460E-01],
	[6.6150000000E+03, 6.8138163928E+00, 1.9116147567E+01, 1.4471595695E-01, 1.4066358578E-01, 4.1590208807E-01],
	[6.6200000000E+03, 6.8202523071E+00, 1.9109838288E+01, 1.4504898025E-01, 1.4098060839E-01, 4.1609459352E-01],
	[6.6250000000E+03, 6.8266894344E+00, 1.9103535852E+01, 1.4538251685E-01, 1.4129809240E-01, 4.1628697132E-01],
	[6.6300000000E+03, 6.8331277739E+00, 1.9097240248E+01, 1.4571656716E-01, 1.4161603806E-01, 4.1647922183E-01],
	[6.6350000000E+03, 6.8395673250E+00, 1.9090951461E+01, 1.4605113157E-01, 1.4193444564E-01, 4.1667134540E-01],
	[6.6400000000E+03, 6.8460080870E+00, 1.9084669481E+01, 1.4638621049E-01, 1.4225331541E-01, 4.1686334239E-01],
	[6.6450000000E+03, 6.8524500592E+00, 1.9078394294E+01, 1.4672180431E-01, 1.4257264765E-01, 4.1705521315E-01],
	[6.6500000000E+03, 6.8588932410E+00, 1.9072125888E+01, 1.4705791344E-01, 1.4289244261E-01, 4.1724695804E-01],
	[6.6550000000E+03, 6.8653376316E+00, 1.9065864251E+01, 1.4739453828E-01, 1.4321270057E-01, 4.1743857740E-01],
	[6.6600000000E+03, 6.8717832303E+00, 1.9059609369E+01, 1.4773167923E-01, 1.4353342179E-01, 4.1763007159E-01],
	[6.6650000000E+03, 6.8782300366E+00, 1.9053361232E+01, 1.4806933669E-01, 1.4385460653E-01, 4.1782144096E-01],
	[6.6700000000E+03, 6.8846996361E+00, 1.9047236892E+01, 1.4840751106E-01, 1.4417627125E-01, 4.1801268586E-01],
	[6.6750000000E+03, 6.8911712320E+00, 1.9041123256E+01, 1.4874620274E-01, 1.4449840072E-01, 4.1820380664E-01],
	[6.6800000000E+03, 6.8976440585E+00, 1.9035016159E+01, 1.4908541214E-01, 1.4482099464E-01, 4.1839480364E-01],
	[6.6850000000E+03, 6.9041181150E+00, 1.9028915587E+01, 1.4942513965E-01, 1.4514405328E-01, 4.1858567720E-01],
	[6.6900000000E+03, 6.9105934007E+00, 1.9022821530E+01, 1.4976538568E-01, 1.4546757690E-01, 4.1877642769E-01],
	[6.6950000000E+03, 6.9170699150E+00, 1.9016733974E+01, 1.5010615062E-01, 1.4579156577E-01, 4.1896705543E-01],
	[6.7000000000E+03, 6.9235476571E+00, 1.9010652910E+01, 1.5044743489E-01, 1.4611602016E-01, 4.1915756077E-01],
	[6.7050000000E+03, 6.9300266265E+00, 1.9004578324E+01, 1.5078923887E-01, 1.4644094033E-01, 4.1934794406E-01],
	[6.7100000000E+03, 6.9365068223E+00, 1.8998510205E+01, 1.5113156297E-01, 1.4676632654E-01, 4.1953820563E-01],
	[6.7150000000E+03, 6.9429882440E+00, 1.8992448542E+01, 1.5147440759E-01, 1.4709217906E-01, 4.1972834583E-01],
	[6.7200000000E+03, 6.9494708909E+00, 1.8986393322E+01, 1.5181777314E-01, 1.4741849815E-01, 4.1991836500E-01],
	[6.7250000000E+03, 6.9559547622E+00, 1.8980344535E+01, 1.5216166001E-01, 1.4774528409E-01, 4.2010826347E-01],
	[6.7300000000E+03, 6.9624398573E+00, 1.8974302168E+01, 1.5250606860E-01, 1.4807253712E-01, 4.2029804158E-01],
	[6.7350000000E+03, 6.9689261755E+00, 1.8968266210E+01, 1.5285099933E-01, 1.4840025752E-01, 4.2048769967E-01],
	[6.7400000000E+03, 6.9754137162E+00, 1.8962236649E+01, 1.5319645257E-01, 1.4872844556E-01, 4.2067723807E-01],
	[6.7450000000E+03, 6.9819024786E+00, 1.8956213474E+01, 1.5354242875E-01, 1.4905710149E-01, 4.2086665712E-01],
	[6.7500000000E+03, 6.9883924621E+00, 1.8950196673E+01, 1.5388892826E-01, 1.4938622557E-01, 4.2105595716E-01],
	[6.7550000000E+03, 6.9948836660E+00, 1.8944186235E+01, 1.5423595149E-01, 1.4971581807E-01, 4.2124513851E-01],
	[6.7600000000E+03, 7.0013760896E+00, 1.8938182149E+01, 1.5458349886E-01, 1.5004587926E-01, 4.2143420150E-01],
	[6.7650000000E+03, 7.0078697323E+00, 1.8932184403E+01, 1.5493157076E-01, 1.5037640939E-01, 4.2162314648E-01],
	[6.7700000000E+03, 7.0143645934E+00, 1.8926192985E+01, 1.5528016760E-01, 1.5070740873E-01, 4.2181197376E-01],
	[6.7750000000E+03, 7.0208714838E+00, 1.8920266630E+01, 1.5562928977E-01, 1.5103888629E-01, 4.2200068368E-01],
	[6.7800000000E+03, 7.0273901763E+00, 1.8914403878E+01, 1.5597893768E-01, 1.5137084222E-01, 4.2218927657E-01],
	[6.7850000000E+03, 7.0339101091E+00, 1.8908547262E+01, 1.5632911172E-01, 1.5170326826E-01, 4.2237775275E-01],
	[6.7900000000E+03, 7.0404312814E+00, 1.8902696772E+01, 1.5667981231E-01, 1.5203616469E-01, 4.2256611256E-01],
	[6.7950000000E+03, 7.0469536926E+00, 1.8896852397E+01, 1.5703103983E-01, 1.5236953176E-01, 4.2275435630E-01],
	[6.8000000000E+03, 7.0534773419E+00, 1.8891014126E+01, 1.5738279470E-01, 1.5270336973E-01, 4.2294248432E-01],
	[6.8050000000E+03, 7.0600022288E+00, 1.8885181948E+01, 1.5773507731E-01, 1.5303767887E-01, 4.2313049694E-01],
	[6.8100000000E+03, 7.0665283525E+00, 1.8879355852E+01, 1.5808788806E-01, 1.5337245942E-01, 4.2331839447E-01],
	[6.8150000000E+03, 7.0730557124E+00, 1.8873535828E+01, 1.5844122736E-01, 1.5370771167E-01, 4.2350617724E-01],
	[6.8200000000E+03, 7.0795843077E+00, 1.8867721864E+01, 1.5879509561E-01, 1.5404343586E-01, 4.2369384557E-01],
	[6.8250000000E+03, 7.0861141379E+00, 1.8861913950E+01, 1.5914949320E-01, 1.5437963225E-01, 4.2388139979E-01],
	[6.8300000000E+03, 7.0926452022E+00, 1.8856112075E+01, 1.5950442054E-01, 1.5471630111E-01, 4.2406884021E-01],
	[6.8350000000E+03, 7.0991774999E+00, 1.8850316229E+01, 1.5985987804E-01, 1.5505344269E-01, 4.2425616715E-01],
	[6.8400000000E+03, 7.1057110305E+00, 1.8844526400E+01, 1.6021586608E-01, 1.5539105726E-01, 4.2444338092E-01],
	[6.8450000000E+03, 7.1122457932E+00, 1.8838742579E+01, 1.6057238508E-01, 1.5572914507E-01, 4.2463048186E-01],
	[6.8500000000E+03, 7.1187817874E+00, 1.8832964754E+01, 1.6092943543E-01, 1.5606770637E-01, 4.2481747027E-01],
	[6.8550000000E+03, 7.1253190124E+00, 1.8827192915E+01, 1.6128701754E-01, 1.5640674144E-01, 4.2500434646E-01],
	[6.8600000000E+03, 7.1318574675E+00, 1.8821427052E+01, 1.6164513181E-01, 1.5674625053E-01, 4.2519111076E-01],
	[6.8650000000E+03, 7.1383971521E+00, 1.8815667154E+01, 1.6200377863E-01, 1.5708623389E-01, 4.2537776347E-01],
	[6.8700000000E+03, 7.1449380655E+00, 1.8809913209E+01, 1.6236295842E-01, 1.5742669179E-01, 4.2556430491E-01],
	[6.8750000000E+03, 7.1514802070E+00, 1.8804165209E+01, 1.6272267156E-01, 1.5776762448E-01, 4.2575073540E-01],
	[6.8800000000E+03, 7.1580235760E+00, 1.8798423142E+01, 1.6308291847E-01, 1.5810903221E-01, 4.2593705524E-01],
	[6.8850000000E+03, 7.1645824606E+00, 1.8792764885E+01, 1.6344369954E-01, 1.5845092778E-01, 4.2612326474E-01],
	[6.8900000000E+03, 7.1711487084E+00, 1.8787145762E+01, 1.6380501517E-01, 1.5879330438E-01, 4.2630936422E-01],
	[6.8950000000E+03, 7.1777162042E+00, 1.8781532394E+01, 1.6416686578E-01, 1.5913615693E-01, 4.2649535398E-01],
	[6.9000000000E+03, 7.1842849473E+00, 1.8775924771E+01, 1.6452925175E-01, 1.5947948568E-01, 4.2668123433E-01],
	[6.9050000000E+03, 7.1908549371E+00, 1.8770322882E+01, 1.6489217348E-01, 1.5982329089E-01, 4.2686700558E-01],
	[6.9100000000E+03, 7.1974261729E+00, 1.8764726717E+01, 1.6525563139E-01, 1.6016757282E-01, 4.2705266803E-01],
	[6.9150000000E+03, 7.2039986540E+00, 1.8759136267E+01, 1.6561962588E-01, 1.6051233172E-01, 4.2723822200E-01],
	[6.9200000000E+03, 7.2105723798E+00, 1.8753551521E+01, 1.6598415733E-01, 1.6085756785E-01, 4.2742366778E-01],
	[6.9250000000E+03, 7.2171473496E+00, 1.8747972470E+01, 1.6634922616E-01, 1.6120328146E-01, 4.2760900569E-01],
	[6.9300000000E+03, 7.2237235628E+00, 1.8742399104E+01, 1.6671483277E-01, 1.6154947282E-01, 4.2779423602E-01],
	[6.9350000000E+03, 7.2303010187E+00, 1.8736831413E+01, 1.6708097755E-01, 1.6189614217E-01, 4.2797935908E-01],
	[6.9400000000E+03, 7.2368797165E+00, 1.8731269386E+01, 1.6744766092E-01, 1.6224328976E-01, 4.2816437516E-01],
	[6.9450000000E+03, 7.2434596558E+00, 1.8725713015E+01, 1.6781488326E-01, 1.6259091586E-01, 4.2834928458E-01],
	[6.9500000000E+03, 7.2500408357E+00, 1.8720162288E+01, 1.6818264499E-01, 1.6293902072E-01, 4.2853408763E-01],
	[6.9550000000E+03, 7.2566232557E+00, 1.8714617198E+01, 1.6855094650E-01, 1.6328760459E-01, 4.2871878461E-01],
	[6.9600000000E+03, 7.2632069150E+00, 1.8709077733E+01, 1.6891978819E-01, 1.6363666773E-01, 4.2890337583E-01],
	[6.9650000000E+03, 7.2697918131E+00, 1.8703543883E+01, 1.6928917047E-01, 1.6398621039E-01, 4.2908786157E-01],
	[6.9700000000E+03, 7.2763779493E+00, 1.8698015641E+01, 1.6965909374E-01, 1.6433623281E-01, 4.2927224214E-01],
	[6.9750000000E+03, 7.2829653229E+00, 1.8692492994E+01, 1.7002955840E-01, 1.6468673527E-01, 4.2945651783E-01],
	[6.9800000000E+03, 7.2895539332E+00, 1.8686975935E+01, 1.7040056485E-01, 1.6503771800E-01, 4.2964068894E-01],
	[6.9850000000E+03, 7.2961437797E+00, 1.8681464453E+01, 1.7077211349E-01, 1.6538918126E-01, 4.2982475577E-01],
	[6.9900000000E+03, 7.3027348616E+00, 1.8675958538E+01, 1.7114420472E-01, 1.6574112531E-01, 4.3000871861E-01],
	[6.9950000000E+03, 7.3093377598E+00, 1.8670516086E+01, 1.7151683895E-01, 1.6609356043E-01, 4.3019257775E-01],
	[7.0000000000E+03, 7.3159507908E+00, 1.8665127682E+01, 1.7189001658E-01, 1.6644648538E-01, 4.3037633349E-01],
	[7.0050000000E+03, 7.3225650767E+00, 1.8659744679E+01, 1.7226751945E-01, 1.6680343737E-01, 4.3055998612E-01],
	[7.0100000000E+03, 7.3291806166E+00, 1.8654367068E+01, 1.7264558043E-01, 1.6716088358E-01, 4.3074353593E-01],
	[7.0150000000E+03, 7.3357974099E+00, 1.8648994839E+01, 1.7302419992E-01, 1.6751882428E-01, 4.3092698322E-01],
	[7.0200000000E+03, 7.3424154560E+00, 1.8643627984E+01, 1.7340337837E-01, 1.6787725974E-01, 4.3111032827E-01],
	[7.0250000000E+03, 7.3490347542E+00, 1.8638266492E+01, 1.7378311618E-01, 1.6823619023E-01, 4.3129357138E-01],
	[7.0300000000E+03, 7.3556553039E+00, 1.8632910355E+01, 1.7416341379E-01, 1.6859561601E-01, 4.3147671283E-01],
	[7.0350000000E+03, 7.3622771043E+00, 1.8627559564E+01, 1.7454427162E-01, 1.6895553736E-01, 4.3165975291E-01],
	[7.0400000000E+03, 7.3689001550E+00, 1.8622214110E+01, 1.7492569010E-01, 1.6931595453E-01, 4.3184269190E-01],
	[7.0450000000E+03, 7.3755244551E+00, 1.8616873983E+01, 1.7530766964E-01, 1.6967686779E-01, 4.3202553017E-01],
	[7.0500000000E+03, 7.3821500041E+00, 1.8611539174E+01, 1.7569021068E-01, 1.7003827742E-01, 4.3220826803E-01],
	[7.0550000000E+03, 7.3887768013E+00, 1.8606209675E+01, 1.7607331364E-01, 1.7040018367E-01, 4.3239090576E-01],
	[7.0600000000E+03, 7.3954048460E+00, 1.8600885476E+01, 1.7645697895E-01, 1.7076258681E-01, 4.3257344363E-01],
	[7.0650000000E+03, 7.4020341376E+00, 1.8595566568E+01, 1.7684120702E-01, 1.7112548711E-01, 4.3275588193E-01],
	[7.0700000000E+03, 7.4086646755E+00, 1.8590252943E+01, 1.7722599828E-01, 1.7148888483E-01, 4.3293822093E-01],
	[7.0750000000E+03, 7.4152964590E+00, 1.8584944591E+01, 1.7761135316E-01, 1.7185278024E-01, 4.3312046090E-01],
	[7.0800000000E+03, 7.4219294875E+00, 1.8579641503E+01, 1.7799727208E-01, 1.7221717359E-01, 4.3330260211E-01],
	[7.0850000000E+03, 7.4285637602E+00, 1.8574343670E+01, 1.7838375547E-01, 1.7258206517E-01, 4.3348464484E-01],
	[7.0900000000E+03, 7.4351992767E+00, 1.8569051084E+01, 1.7877080375E-01, 1.7294745522E-01, 4.3366658936E-01],
	[7.0950000000E+03, 7.4418360361E+00, 1.8563763736E+01, 1.7915841734E-01, 1.7331334401E-01, 4.3384843594E-01],
	[7.1000000000E+03, 7.4484740380E+00, 1.8558481616E+01, 1.7954659668E-01, 1.7367973181E-01, 4.3403018484E-01],
	[7.1050000000E+03, 7.4551138504E+00, 1.8553207817E+01, 1.7993534218E-01, 1.7404661946E-01, 4.3421183635E-01],
	[7.1100000000E+03, 7.4617730557E+00, 1.8548038047E+01, 1.8032465427E-01, 1.7441402531E-01, 4.3439339073E-01],
	[7.1150000000E+03, 7.4684335217E+00, 1.8542873350E+01, 1.8071453338E-01, 1.7478193108E-01, 4.3457484825E-01],
	[7.1200000000E+03, 7.4750952476E+00, 1.8537713717E+01, 1.8110497992E-01, 1.7515033705E-01, 4.3475620917E-01],
	[7.1250000000E+03, 7.4817582329E+00, 1.8532559141E+01, 1.8149599433E-01, 1.7551924348E-01, 4.3493747376E-01],
	[7.1300000000E+03, 7.4884224770E+00, 1.8527409613E+01, 1.8188757703E-01, 1.7588865062E-01, 4.3511864230E-01],
	[7.1350000000E+03, 7.4950879791E+00, 1.8522265124E+01, 1.8227972844E-01, 1.7625855874E-01, 4.3529971504E-01],
	[7.1400000000E+03, 7.5017547386E+00, 1.8517125666E+01, 1.8267244899E-01, 1.7662896811E-01, 4.3548069225E-01],
	[7.1450000000E+03, 7.5084227550E+00, 1.8511991230E+01, 1.8306573911E-01, 1.7699987898E-01, 4.3566157420E-01],
	[7.1500000000E+03, 7.5150920274E+00, 1.8506861808E+01, 1.8345959921E-01, 1.7737129162E-01, 4.3584236116E-01],
	[7.1550000000E+03, 7.5217625554E+00, 1.8501737391E+01, 1.8385402973E-01, 1.7774320628E-01, 4.3602305337E-01],
	[7.1600000000E+03, 7.5284343382E+00, 1.8496617972E+01, 1.8424903108E-01, 1.7811562323E-01, 4.3620365111E-01],
	[7.1650000000E+03, 7.5351073752E+00, 1.8491503542E+01, 1.8464460370E-01, 1.7848854273E-01, 4.3638415464E-01],
	[7.1700000000E+03, 7.5417816658E+00, 1.8486394092E+01, 1.8504074801E-01, 1.7886196503E-01, 4.3656456423E-01],
	[7.1750000000E+03, 7.5484572094E+00, 1.8481289614E+01, 1.8543746443E-01, 1.7923589041E-01, 4.3674488012E-01],
	[7.1800000000E+03, 7.5551340052E+00, 1.8476190101E+01, 1.8583475339E-01, 1.7961031911E-01, 4.3692510259E-01],
	[7.1850000000E+03, 7.5618120527E+00, 1.8471095542E+01, 1.8623261531E-01, 1.7998525140E-01, 4.3710523189E-01],
	[7.1900000000E+03, 7.5684913512E+00, 1.8466005931E+01, 1.8663105062E-01, 1.8036068753E-01, 4.3728526828E-01],
	[7.1950000000E+03, 7.5751719002E+00, 1.8460921260E+01, 1.8703005974E-01, 1.8073662778E-01, 4.3746521203E-01],
	[7.2000000000E+03, 7.5818536988E+00, 1.8455841519E+01, 1.8742964310E-01, 1.8111307238E-01, 4.3764506338E-01],
	[7.2050000000E+03, 7.5885367466E+00, 1.8450766700E+01, 1.8782980113E-01, 1.8149002161E-01, 4.3782482260E-01],
	[7.2100000000E+03, 7.5952210429E+00, 1.8445696797E+01, 1.8823053424E-01, 1.8186747571E-01, 4.3800448994E-01],
	[7.2150000000E+03, 7.6019065871E+00, 1.8440631799E+01, 1.8863184287E-01, 1.8224543496E-01, 4.3818406566E-01],
	[7.2200000000E+03, 7.6085961665E+00, 1.8435586798E+01, 1.8903372743E-01, 1.8262390269E-01, 4.3836355002E-01],
	[7.2250000000E+03, 7.6153022348E+00, 1.8430629100E+01, 1.8943618836E-01, 1.8300289302E-01, 4.3854294327E-01],
	[7.2300000000E+03, 7.6220095682E+00, 1.8425676163E+01, 1.8983922608E-01, 1.8338238940E-01, 4.3872224566E-01],
	[7.2350000000E+03, 7.6287181663E+00, 1.8420727979E+01, 1.9024284101E-01, 1.8376239208E-01, 4.3890145746E-01],
	[7.2400000000E+03, 7.6354280282E+00, 1.8415784542E+01, 1.9064703358E-01, 1.8414290133E-01, 4.3908057890E-01],
	[7.2450000000E+03, 7.6421391534E+00, 1.8410845843E+01, 1.9105180422E-01, 1.8452391740E-01, 4.3925961025E-01],
	[7.2500000000E+03, 7.6488515413E+00, 1.8405911874E+01, 1.9145715334E-01, 1.8490544055E-01, 4.3943855176E-01],
	[7.2550000000E+03, 7.6555651912E+00, 1.8400982627E+01, 1.9186308138E-01, 1.8528747102E-01, 4.3961740368E-01],
	[7.2600000000E+03, 7.6622801024E+00, 1.8396058095E+01, 1.9226958876E-01, 1.8567000909E-01, 4.3979616627E-01],
	[7.2650000000E+03, 7.6689962745E+00, 1.8391138270E+01, 1.9267667590E-01, 1.8605305500E-01, 4.3997483976E-01],
	[7.2700000000E+03, 7.6757137066E+00, 1.8386223144E+01, 1.9308434324E-01, 1.8643660901E-01, 4.4015342441E-01],
	[7.2750000000E+03, 7.6824323982E+00, 1.8381312710E+01, 1.9349259119E-01, 1.8682067138E-01, 4.4033192048E-01],
	[7.2800000000E+03, 7.6891523487E+00, 1.8376406960E+01, 1.9390142018E-01, 1.8720524235E-01, 4.4051032821E-01],
	[7.2850000000E+03, 7.6958735574E+00, 1.8371505885E+01, 1.9431083064E-01, 1.8759032219E-01, 4.4068864785E-01],
	[7.2900000000E+03, 7.7025960238E+00, 1.8366609479E+01, 1.9472082299E-01, 1.8797591115E-01, 4.4086687964E-01],
	[7.2950000000E+03, 7.7093197471E+00, 1.8361717734E+01, 1.9513139766E-01, 1.8836200948E-01, 4.4104502384E-01],
	[7.3000000000E+03, 7.7160447267E+00, 1.8356830642E+01, 1.9554255507E-01, 1.8874861744E-01, 4.4122308069E-01],
	[7.3050000000E+03, 7.7227709621E+00, 1.8351948196E+01, 1.9595429565E-01, 1.8913573527E-01, 4.4140105044E-01],
	[7.3100000000E+03, 7.7294984526E+00, 1.8347070388E+01, 1.9636661982E-01, 1.8952336324E-01, 4.4157893333E-01],
	[7.3150000000E+03, 7.7362271975E+00, 1.8342197210E+01, 1.9677952801E-01, 1.8991150159E-01, 4.4175672961E-01],
	[7.3200000000E+03, 7.7429571963E+00, 1.8337328655E+01, 1.9719302065E-01, 1.9030015059E-01, 4.4193443952E-01],
	[7.3250000000E+03, 7.7496884484E+00, 1.8332464715E+01, 1.9760709815E-01, 1.9068931047E-01, 4.4211206331E-01],
	[7.3300000000E+03, 7.7564209530E+00, 1.8327605383E+01, 1.9802176095E-01, 1.9107898149E-01, 4.4228960123E-01],
	[7.3350000000E+03, 7.7631547096E+00, 1.8322750651E+01, 1.9843700947E-01, 1.9146916391E-01, 4.4246705351E-01],
	[7.3400000000E+03, 7.7699055001E+00, 1.8317985486E+01, 1.9885284414E-01, 1.9185987692E-01, 4.4264442039E-01],
	[7.3450000000E+03, 7.7766591048E+00, 1.8313233121E+01, 1.9926926537E-01, 1.9225110382E-01, 4.4282170213E-01],
	[7.3500000000E+03, 7.7834139779E+00, 1.8308485223E+01, 1.9968627361E-01, 1.9264284301E-01, 4.4299889896E-01],
	[7.3550000000E+03, 7.7901701188E+00, 1.8303741783E+01, 2.0010386927E-01, 1.9303509474E-01, 4.4317601112E-01],
	[7.3600000000E+03, 7.7969275268E+00, 1.8299002794E+01, 2.0052205277E-01, 1.9342785926E-01, 4.4335303885E-01],
	[7.3650000000E+03, 7.8036862013E+00, 1.8294268249E+01, 2.0094082455E-01, 1.9382113683E-01, 4.4352998240E-01],
	[7.3700000000E+03, 7.8104461417E+00, 1.8289538141E+01, 2.0136018503E-01, 1.9421492770E-01, 4.4370684200E-01],
	[7.3750000000E+03, 7.8172073474E+00, 1.8284812463E+01, 2.0178013463E-01, 1.9460923210E-01, 4.4388361789E-01],
	[7.3800000000E+03, 7.8239698177E+00, 1.8280091207E+01, 2.0220067379E-01, 1.9500405030E-01, 4.4406031032E-01],
	[7.3850000000E+03, 7.8307335520E+00, 1.8275374367E+01, 2.0262180292E-01, 1.9539938255E-01, 4.4423691951E-01],
	[7.3900000000E+03, 7.8374985498E+00, 1.8270661935E+01, 2.0304352245E-01, 1.9579522909E-01, 4.4441344571E-01],
	[7.3950000000E+03, 7.8442648104E+00, 1.8265953904E+01, 2.0346583281E-01, 1.9619159017E-01, 4.4458988915E-01],
	[7.4000000000E+03, 7.8510323331E+00, 1.8261250267E+01, 2.0388873443E-01, 1.9658846604E-01, 4.4476625008E-01],
	[7.4050000000E+03, 7.8578011175E+00, 1.8256551018E+01, 2.0431222772E-01, 1.9698585695E-01, 4.4494252872E-01],
	[7.4100000000E+03, 7.8645711627E+00, 1.8251856148E+01, 2.0473631312E-01, 1.9738376315E-01, 4.4511872532E-01],
	[7.4150000000E+03, 7.8713424683E+00, 1.8247165652E+01, 2.0516099105E-01, 1.9778218488E-01, 4.4529484010E-01],
	[7.4200000000E+03, 7.8781150335E+00, 1.8242479521E+01, 2.0558626193E-01, 1.9818112239E-01, 4.4547087331E-01],
	[7.4250000000E+03, 7.8848888579E+00, 1.8237797749E+01, 2.0601212620E-01, 1.9858057594E-01, 4.4564682517E-01],
	[7.4300000000E+03, 7.8916639408E+00, 1.8233120330E+01, 2.0643858427E-01, 1.9898054576E-01, 4.4582269593E-01],
	[7.4350000000E+03, 7.8984402815E+00, 1.8228447255E+01, 2.0686563658E-01, 1.9938103211E-01, 4.4599848581E-01],
	[7.4400000000E+03, 7.9052178795E+00, 1.8223778518E+01, 2.0729328355E-01, 1.9978203522E-01, 4.4617419504E-01],
	[7.4450000000E+03, 7.9119967341E+00, 1.8219114113E+01, 2.0772152560E-01, 2.0018355536E-01, 4.4634982387E-01],
	[7.4500000000E+03, 7.9187768447E+00, 1.8214454031E+01, 2.0815036316E-01, 2.0058559275E-01, 4.4652537252E-01],
	[7.4550000000E+03, 7.9255630745E+00, 1.8209824383E+01, 2.0857979667E-01, 2.0098815397E-01, 4.4670084123E-01],
	[7.4600000000E+03, 7.9323623262E+00, 1.8205262102E+01, 2.0900982653E-01, 2.0139124828E-01, 4.4687623022E-01],
	[7.4650000000E+03, 7.9391628495E+00, 1.8200704020E+01, 2.0944045318E-01, 2.0179486073E-01, 4.4705153972E-01],
	[7.4700000000E+03, 7.9459646436E+00, 1.8196150130E+01, 2.0987167705E-01, 2.0219899158E-01, 4.4722676997E-01],
	[7.4750000000E+03, 7.9527677081E+00, 1.8191600426E+01, 2.1030349856E-01, 2.0260364106E-01, 4.4740192120E-01],
	[7.4800000000E+03, 7.9595720422E+00, 1.8187054900E+01, 2.1073591813E-01, 2.0300880941E-01, 4.4757699363E-01],
	[7.4850000000E+03, 7.9663776454E+00, 1.8182513546E+01, 2.1116893620E-01, 2.0341449690E-01, 4.4775198750E-01],
	[7.4900000000E+03, 7.9731845171E+00, 1.8177976357E+01, 2.1160255319E-01, 2.0382070375E-01, 4.4792690302E-01],
	[7.4950000000E+03, 7.9799926566E+00, 1.8173443328E+01, 2.1203676952E-01, 2.0422743021E-01, 4.4810174044E-01],
	[7.5000000000E+03, 7.9868020634E+00, 1.8168914450E+01, 2.1247158562E-01, 2.0463467653E-01, 4.4827649998E-01],
	[7.5050000000E+03, 7.9936127368E+00, 1.8164389719E+01, 2.1290700191E-01, 2.0504244295E-01, 4.4845118186E-01],
	[7.5100000000E+03, 8.0004246762E+00, 1.8159869127E+01, 2.1334301883E-01, 2.0545072972E-01, 4.4862578631E-01],
	[7.5150000000E+03, 8.0072378811E+00, 1.8155352667E+01, 2.1377963680E-01, 2.0585953706E-01, 4.4880031357E-01],
	[7.5200000000E+03, 8.0140523508E+00, 1.8150840333E+01, 2.1421685625E-01, 2.0626886524E-01, 4.4897476384E-01],
	[7.5250000000E+03, 8.0208680846E+00, 1.8146332119E+01, 2.1465467759E-01, 2.0667871448E-01, 4.4914913737E-01],
	[7.5300000000E+03, 8.0276850821E+00, 1.8141828018E+01, 2.1509310126E-01, 2.0708908504E-01, 4.4932343437E-01],
	[7.5350000000E+03, 8.0345033425E+00, 1.8137328024E+01, 2.1553212769E-01, 2.0749997715E-01, 4.4949765510E-01],
	[7.5400000000E+03, 8.0413228654E+00, 1.8132832130E+01, 2.1597175729E-01, 2.0791139105E-01, 4.4967179974E-01],
	[7.5450000000E+03, 8.0481436500E+00, 1.8128340329E+01, 2.1641199050E-01, 2.0832332699E-01, 4.4984586850E-01],
	[7.5500000000E+03, 8.0549656958E+00, 1.8123852616E+01, 2.1685282774E-01, 2.0873578521E-01, 4.5001986159E-01],
	[7.5550000000E+03, 8.0617890022E+00, 1.8119368984E+01, 2.1729426943E-01, 2.0914876594E-01, 4.5019377920E-01],
	[7.5600000000E+03, 8.0686135686E+00, 1.8114889426E+01, 2.1773631602E-01, 2.0956226943E-01, 4.5036762154E-01],
	[7.5650000000E+03, 8.0754393943E+00, 1.8110413936E+01, 2.1817896791E-01, 2.0997629591E-01, 4.5054138881E-01],
	[7.5700000000E+03, 8.0822664789E+00, 1.8105942508E+01, 2.1862222554E-01, 2.1039084564E-01, 4.5071508121E-01],
	[7.5750000000E+03, 8.0890995039E+00, 1.8101500237E+01, 2.1906608933E-01, 2.1080592542E-01, 4.5088869895E-01],
	[7.5800000000E+03, 8.0959450254E+00, 1.8097122143E+01, 2.1951055971E-01, 2.1122154481E-01, 4.5106224222E-01],
	[7.5850000000E+03, 8.1027918204E+00, 1.8092747995E+01, 2.1995563710E-01, 2.1163768829E-01, 4.5123571122E-01],
	[7.5900000000E+03, 8.1096398880E+00, 1.8088377785E+01, 2.2040132194E-01, 2.1205435612E-01, 4.5140910615E-01],
	[7.5950000000E+03, 8.1164892279E+00, 1.8084011508E+01, 2.2084761464E-01, 2.1247154854E-01, 4.5158242722E-01],
	[7.6000000000E+03, 8.1233398393E+00, 1.8079649157E+01, 2.2129451564E-01, 2.1288926577E-01, 4.5175567461E-01],
	[7.6050000000E+03, 8.1301917217E+00, 1.8075290727E+01, 2.2174202535E-01, 2.1330750805E-01, 4.5192884854E-01],
	[7.6100000000E+03, 8.1370448744E+00, 1.8070936210E+01, 2.2219014422E-01, 2.1372627564E-01, 4.5210194919E-01],
	[7.6150000000E+03, 8.1438992969E+00, 1.8066585602E+01, 2.2263887266E-01, 2.1414556875E-01, 4.5227497677E-01],
	[7.6200000000E+03, 8.1507549886E+00, 1.8062238896E+01, 2.2308821109E-01, 2.1456538764E-01, 4.5244793147E-01],
	[7.6250000000E+03, 8.1576119488E+00, 1.8057896086E+01, 2.2353815996E-01, 2.1498573254E-01, 4.5262081349E-01],
	[7.6300000000E+03, 8.1644701770E+00, 1.8053557166E+01, 2.2398871967E-01, 2.1540660368E-01, 4.5279362303E-01],
	[7.6350000000E+03, 8.1713296725E+00, 1.8049222129E+01, 2.2443989066E-01, 2.1582800130E-01, 4.5296636028E-01],
	[7.6400000000E+03, 8.1781904349E+00, 1.8044890971E+01, 2.2489167336E-01, 2.1624992563E-01, 4.5313902544E-01],
	[7.6450000000E+03, 8.1850524634E+00, 1.8040563685E+01, 2.2534406819E-01, 2.1667237692E-01, 4.5331161871E-01],
	[7.6500000000E+03, 8.1919157575E+00, 1.8036240264E+01, 2.2579707558E-01, 2.1709535540E-01, 4.5348414027E-01],
	[7.6550000000E+03, 8.1987803166E+00, 1.8031920704E+01, 2.2625069596E-01, 2.1751886130E-01, 4.5365659034E-01],
	[7.6600000000E+03, 8.2056461401E+00, 1.8027604997E+01, 2.2670492974E-01, 2.1794289486E-01, 4.5382896909E-01],
	[7.6650000000E+03, 8.2125132274E+00, 1.8023293138E+01, 2.2715977736E-01, 2.1836745631E-01, 4.5400127672E-01],
	[7.6700000000E+03, 8.2193815779E+00, 1.8018985122E+01, 2.2761523925E-01, 2.1879254589E-01, 4.5417351344E-01],
	[7.6750000000E+03, 8.2262511910E+00, 1.8014680941E+01, 2.2807131582E-01, 2.1921816383E-01, 4.5434567942E-01],
	[7.6800000000E+03, 8.2331220662E+00, 1.8010380591E+01, 2.2852800752E-01, 2.1964431036E-01, 4.5451777487E-01],
	[7.6850000000E+03, 8.2399942028E+00, 1.8006084065E+01, 2.2898531476E-01, 2.2007098573E-01, 4.5468979998E-01],
	[7.6900000000E+03, 8.2468676002E+00, 1.8001791358E+01, 2.2944323796E-01, 2.2049819015E-01, 4.5486175494E-01],
	[7.6950000000E+03, 8.2537422579E+00, 1.7997502463E+01, 2.2990177757E-01, 2.2092592387E-01, 4.5503363994E-01],
	[7.7000000000E+03, 8.2606320015E+00, 1.7993291468E+01, 2.3036093400E-01, 2.2135420826E-01, 4.5520545518E-01],
	[7.7050000000E+03, 8.2675243933E+00, 1.7989091552E+01, 2.3082070768E-01, 2.2178302466E-01, 4.5537720084E-01],
	[7.7100000000E+03, 8.2744180590E+00, 1.7984895339E+01, 2.3128109903E-01, 2.2221237120E-01, 4.5554887712E-01],
	[7.7150000000E+03, 8.2813129980E+00, 1.7980702825E+01, 2.3174210849E-01, 2.2264224812E-01, 4.5572048421E-01],
	[7.7200000000E+03, 8.2882092099E+00, 1.7976514003E+01, 2.3220373648E-01, 2.2307265565E-01, 4.5589202229E-01],
	[7.7250000000E+03, 8.2951066939E+00, 1.7972328868E+01, 2.3266598343E-01, 2.2350359402E-01, 4.5606349157E-01],
	[7.7300000000E+03, 8.3020054495E+00, 1.7968147415E+01, 2.3312884976E-01, 2.2393506346E-01, 4.5623489222E-01],
	[7.7350000000E+03, 8.3089054762E+00, 1.7963969637E+01, 2.3359233590E-01, 2.2436706420E-01, 4.5640622444E-01],
	[7.7400000000E+03, 8.3158067732E+00, 1.7959795529E+01, 2.3405644228E-01, 2.2479959648E-01, 4.5657748842E-01],
	[7.7450000000E+03, 8.3227093401E+00, 1.7955625086E+01, 2.3452116932E-01, 2.2523266053E-01, 4.5674868435E-01],
	[7.7500000000E+03, 8.3296131763E+00, 1.7951458302E+01, 2.3498651746E-01, 2.2566625657E-01, 4.5691981241E-01],
	[7.7550000000E+03, 8.3365182811E+00, 1.7947295171E+01, 2.3545248711E-01, 2.2610038483E-01, 4.5709087280E-01],
	[7.7600000000E+03, 8.3434246539E+00, 1.7943135689E+01, 2.3591907870E-01, 2.2653504555E-01, 4.5726186569E-01],
	[7.7650000000E+03, 8.3503322943E+00, 1.7938979848E+01, 2.3638629267E-01, 2.2697023896E-01, 4.5743279129E-01],
	[7.7700000000E+03, 8.3572412016E+00, 1.7934827644E+01, 2.3685412943E-01, 2.2740596527E-01, 4.5760364977E-01],
	[7.7750000000E+03, 8.3641513752E+00, 1.7930679072E+01, 2.3732258942E-01, 2.2784222473E-01, 4.5777444132E-01],
	[7.7800000000E+03, 8.3710628146E+00, 1.7926534125E+01, 2.3779167306E-01, 2.2827901756E-01, 4.5794516614E-01],
	[7.7850000000E+03, 8.3779755191E+00, 1.7922392798E+01, 2.3826138078E-01, 2.2871634399E-01, 4.5811582440E-01],
	[7.7900000000E+03, 8.3848894882E+00, 1.7918255086E+01, 2.3873171301E-01, 2.2915420425E-01, 4.5828641629E-01],
	[7.7950000000E+03, 8.3918047213E+00, 1.7914120984E+01, 2.3920267017E-01, 2.2959259856E-01, 4.5845694201E-01],
	[7.8000000000E+03, 8.3987212179E+00, 1.7909990485E+01, 2.3967425269E-01, 2.3003152715E-01, 4.5862740172E-01],
	[7.8050000000E+03, 8.4056389772E+00, 1.7905863585E+01, 2.4014646099E-01, 2.3047099025E-01, 4.5879779563E-01],
	[7.8100000000E+03, 8.4125579989E+00, 1.7901740277E+01, 2.4061929551E-01, 2.3091098808E-01, 4.5896812391E-01],
	[7.8150000000E+03, 8.4194782822E+00, 1.7897620557E+01, 2.4109275666E-01, 2.3135152088E-01, 4.5913838674E-01],
	[7.8200000000E+03, 8.4264017419E+00, 1.7893514717E+01, 2.4156684489E-01, 2.3179259204E-01, 4.5930858432E-01],
	[7.8250000000E+03, 8.4333390286E+00, 1.7889479925E+01, 2.4204156061E-01, 2.3223421953E-01, 4.5947871683E-01],
	[7.8300000000E+03, 8.4402775898E+00, 1.7885448620E+01, 2.4251690425E-01, 2.3267638282E-01, 4.5964878444E-01],
	[7.8350000000E+03, 8.4472174250E+00, 1.7881420795E+01, 2.4299287624E-01, 2.3311908213E-01, 4.5981878735E-01],
	[7.8400000000E+03, 8.4541585334E+00, 1.7877396447E+01, 2.4346947700E-01, 2.3356231768E-01, 4.5998872574E-01],
	[7.8450000000E+03, 8.4611009147E+00, 1.7873375569E+01, 2.4394670697E-01, 2.3400608971E-01, 4.6015859979E-01],
	[7.8500000000E+03, 8.4680445681E+00, 1.7869358156E+01, 2.4442456657E-01, 2.3445039843E-01, 4.6032840968E-01],
	[7.8550000000E+03, 8.4749894931E+00, 1.7865344204E+01, 2.4490305622E-01, 2.3489524407E-01, 4.6049815559E-01],
	[7.8600000000E+03, 8.4819356892E+00, 1.7861333706E+01, 2.4538217636E-01, 2.3534062686E-01, 4.6066783771E-01],
	[7.8650000000E+03, 8.4888831557E+00, 1.7857326659E+01, 2.4586192740E-01, 2.3578654702E-01, 4.6083745621E-01],
	[7.8700000000E+03, 8.4958318921E+00, 1.7853323056E+01, 2.4634230979E-01, 2.3623300476E-01, 4.6100701129E-01],
	[7.8750000000E+03, 8.5027818978E+00, 1.7849322892E+01, 2.4682332394E-01, 2.3668000033E-01, 4.6117650311E-01],
	[7.8800000000E+03, 8.5097331722E+00, 1.7845326163E+01, 2.4730497028E-01, 2.3712753393E-01, 4.6134593187E-01],
	[7.8850000000E+03, 8.5166857148E+00, 1.7841332864E+01, 2.4778724925E-01, 2.3757560580E-01, 4.6151529774E-01],
	[7.8900000000E+03, 8.5236395250E+00, 1.7837342988E+01, 2.4827016126E-01, 2.3802421614E-01, 4.6168460089E-01],
	[7.8950000000E+03, 8.5305946022E+00, 1.7833356531E+01, 2.4875370674E-01, 2.3847336520E-01, 4.6185384152E-01],
	[7.9000000000E+03, 8.5375509458E+00, 1.7829373489E+01, 2.4923788613E-01, 2.3892305318E-01, 4.6202301981E-01],
	[7.9050000000E+03, 8.5445085553E+00, 1.7825393855E+01, 2.4972269984E-01, 2.3937328031E-01, 4.6219213592E-01],
	[7.9100000000E+03, 8.5514674300E+00, 1.7821417625E+01, 2.5020814831E-01, 2.3982404681E-01, 4.6236119004E-01],
	[7.9150000000E+03, 8.5584275695E+00, 1.7817444794E+01, 2.5069423196E-01, 2.4027535291E-01, 4.6253018235E-01],
	[7.9200000000E+03, 8.5653889732E+00, 1.7813475357E+01, 2.5118095122E-01, 2.4072719881E-01, 4.6269911303E-01],
	[7.9250000000E+03, 8.5723516405E+00, 1.7809509308E+01, 2.5166830652E-01, 2.4117958475E-01, 4.6286798225E-01],
	[7.9300000000E+03, 8.5793155707E+00, 1.7805546643E+01, 2.5215629829E-01, 2.4163251094E-01, 4.6303679020E-01],
	[7.9350000000E+03, 8.5862807635E+00, 1.7801587356E+01, 2.5264492694E-01, 2.4208597760E-01, 4.6320553705E-01],
	[7.9400000000E+03, 8.5932472181E+00, 1.7797631443E+01, 2.5313419292E-01, 2.4253998496E-01, 4.6337422298E-01],
	[7.9450000000E+03, 8.6002149340E+00, 1.7793678899E+01, 2.5362409664E-01, 2.4299453322E-01, 4.6354284816E-01],
	[7.9500000000E+03, 8.6071970697E+00, 1.7789800708E+01, 2.5411463854E-01, 2.4344964644E-01, 4.6371141278E-01],
	[7.9550000000E+03, 8.6141810818E+00, 1.7785929051E+01, 2.5460581904E-01, 2.4390530225E-01, 4.6387991701E-01],
	[7.9600000000E+03, 8.6211663671E+00, 1.7782060668E+01, 2.5509763857E-01, 2.4436149979E-01, 4.6404836102E-01],
	[7.9650000000E+03, 8.6281529252E+00, 1.7778195555E+01, 2.5559009756E-01, 2.4481823927E-01, 4.6421674500E-01],
	[7.9700000000E+03, 8.6351407554E+00, 1.7774333707E+01, 2.5608319643E-01, 2.4527552091E-01, 4.6438506911E-01],
	[7.9750000000E+03, 8.6421298572E+00, 1.7770475119E+01, 2.5657693561E-01, 2.4573334494E-01, 4.6455333354E-01],
	[7.9800000000E+03, 8.6491202300E+00, 1.7766619787E+01, 2.5707131553E-01, 2.4619171156E-01, 4.6472153846E-01],
	[7.9850000000E+03, 8.6561118732E+00, 1.7762767704E+01, 2.5756633661E-01, 2.4665062100E-01, 4.6488968404E-01],
	[7.9900000000E+03, 8.6631047863E+00, 1.7758918868E+01, 2.5806199929E-01, 2.4711007347E-01, 4.6505777045E-01],
	[7.9950000000E+03, 8.6700989688E+00, 1.7755073272E+01, 2.5855830399E-01, 2.4757006919E-01, 4.6522579783E-01],
	[8.0000000000E+03, 8.6770944199E+00, 1.7751230913E+01, 2.5905525114E-01, 2.4803060837E-01, 4.6539376634E-01],
	[8.0050000000E+03, 8.6840911393E+00, 1.7747391785E+01, 2.5955535492E-01, 2.4849399530E-01, 4.6556167613E-01],
	[8.0100000000E+03, 8.6910891262E+00, 1.7743555884E+01, 2.6005611014E-01, 2.4895793301E-01, 4.6572952734E-01],
	[8.0150000000E+03, 8.6980883803E+00, 1.7739723205E+01, 2.6055751724E-01, 2.4942242173E-01, 4.6589732013E-01],
	[8.0200000000E+03, 8.7050889008E+00, 1.7735893744E+01, 2.6105957666E-01, 2.4988746167E-01, 4.6606505464E-01],
	[8.0250000000E+03, 8.7120906873E+00, 1.7732067494E+01, 2.6156228885E-01, 2.5035305307E-01, 4.6623273103E-01],
	[8.0300000000E+03, 8.7190937391E+00, 1.7728244453E+01, 2.6206565423E-01, 2.5081919615E-01, 4.6640034945E-01],
	[8.0350000000E+03, 8.7260980558E+00, 1.7724424615E+01, 2.6256967325E-01, 2.5128589111E-01, 4.6656791004E-01],
	[8.0400000000E+03, 8.7331036367E+00, 1.7720607976E+01, 2.6307434636E-01, 2.5175313820E-01, 4.6673541295E-01],
	[8.0450000000E+03, 8.7401104813E+00, 1.7716794530E+01, 2.6357967398E-01, 2.5222093762E-01, 4.6690285833E-01],
	[8.0500000000E+03, 8.7471185891E+00, 1.7712984273E+01, 2.6408565656E-01, 2.5268928960E-01, 4.6707024633E-01],
	[8.0550000000E+03, 8.7541279594E+00, 1.7709177202E+01, 2.6459229453E-01, 2.5315819436E-01, 4.6723757710E-01],
	[8.0600000000E+03, 8.7611385918E+00, 1.7705373310E+01, 2.6509958835E-01, 2.5362765212E-01, 4.6740485078E-01],
	[8.0650000000E+03, 8.7681504857E+00, 1.7701572593E+01, 2.6560753844E-01, 2.5409766309E-01, 4.6757206753E-01],
	[8.0700000000E+03, 8.7751636405E+00, 1.7697775047E+01, 2.6611614525E-01, 2.5456822750E-01, 4.6773922748E-01],
	[8.0750000000E+03, 8.7821830037E+00, 1.7694007245E+01, 2.6662540922E-01, 2.5503935526E-01, 4.6790633080E-01],
	[8.0800000000E+03, 8.7892118915E+00, 1.7690286898E+01, 2.6713533078E-01, 2.5551105319E-01, 4.6807337761E-01],
	[8.0850000000E+03, 8.7962420514E+00, 1.7686569633E+01, 2.6764591037E-01, 2.5598330537E-01, 4.6824036808E-01],
	[8.0900000000E+03, 8.8032734829E+00, 1.7682855447E+01, 2.6815714845E-01, 2.5645611203E-01, 4.6840730235E-01],
	[8.0950000000E+03, 8.8103061856E+00, 1.7679144336E+01, 2.6866904543E-01, 2.5692947339E-01, 4.6857418056E-01],
	[8.1000000000E+03, 8.8173401587E+00, 1.7675436294E+01, 2.6918160178E-01, 2.5740338965E-01, 4.6874100286E-01],
	[8.1050000000E+03, 8.8243754019E+00, 1.7671731317E+01, 2.6969481792E-01, 2.5787786105E-01, 4.6890776940E-01],
	[8.1100000000E+03, 8.8314119144E+00, 1.7668029401E+01, 2.7020869429E-01, 2.5835288780E-01, 4.6907448032E-01],
	[8.1150000000E+03, 8.8384496958E+00, 1.7664330541E+01, 2.7072323134E-01, 2.5882847011E-01, 4.6924113577E-01],
	[8.1200000000E+03, 8.8454887455E+00, 1.7660634733E+01, 2.7123842950E-01, 2.5930460820E-01, 4.6940773590E-01],
	[8.1250000000E+03, 8.8525290630E+00, 1.7656941973E+01, 2.7175428921E-01, 2.5978130229E-01, 4.6957428084E-01],
	[8.1300000000E+03, 8.8595706476E+00, 1.7653252256E+01, 2.7227081092E-01, 2.6025855260E-01, 4.6974077075E-01],
	[8.1350000000E+03, 8.8666134989E+00, 1.7649565578E+01, 2.7278799507E-01, 2.6073635933E-01, 4.6990720576E-01],
	[8.1400000000E+03, 8.8736576163E+00, 1.7645881934E+01, 2.7330584208E-01, 2.6121472271E-01, 4.7007358603E-01],
	[8.1450000000E+03, 8.8807029993E+00, 1.7642201321E+01, 2.7382435241E-01, 2.6169364296E-01, 4.7023991170E-01],
	[8.1500000000E+03, 8.8877496472E+00, 1.7638523733E+01, 2.7434352650E-01, 2.6217312027E-01, 4.7040618291E-01],
	[8.1550000000E+03, 8.8947975596E+00, 1.7634849166E+01, 2.7486336478E-01, 2.6265315488E-01, 4.7057239981E-01],
	[8.1600000000E+03, 8.9018467359E+00, 1.7631177617E+01, 2.7538386769E-01, 2.6313374699E-01, 4.7073856254E-01],
	[8.1650000000E+03, 8.9088971756E+00, 1.7627509080E+01, 2.7590503568E-01, 2.6361489683E-01, 4.7090467124E-01],
	[8.1700000000E+03, 8.9159488781E+00, 1.7623843552E+01, 2.7642686918E-01, 2.6409660459E-01, 4.7107072607E-01],
	[8.1750000000E+03, 8.9230018428E+00, 1.7620181028E+01, 2.7694936863E-01, 2.6457887050E-01, 4.7123672715E-01],
	[8.1800000000E+03, 8.9300560692E+00, 1.7616521504E+01, 2.7747253448E-01, 2.6506169476E-01, 4.7140267464E-01],
	[8.1850000000E+03, 8.9371115568E+00, 1.7612864975E+01, 2.7799636716E-01, 2.6554507760E-01, 4.7156856867E-01],
	[8.1900000000E+03, 8.9441683050E+00, 1.7609211437E+01, 2.7852086711E-01, 2.6602901922E-01, 4.7173440940E-01],
	[8.1950000000E+03, 8.9512263133E+00, 1.7605560887E+01, 2.7904603478E-01, 2.6651351984E-01, 4.7190019696E-01],
	[8.2000000000E+03, 8.9582855811E+00, 1.7601913319E+01, 2.7957187061E-01, 2.6699857966E-01, 4.7206593150E-01],
	[8.2050000000E+03, 8.9653509860E+00, 1.7598294577E+01, 2.8009837503E-01, 2.6748420922E-01, 4.7223161315E-01],
	[8.2100000000E+03, 8.9724255669E+00, 1.7594720668E+01, 2.8062554848E-01, 2.6797041524E-01, 4.7239724206E-01],
	[8.2150000000E+03, 8.9795014181E+00, 1.7591149661E+01, 2.8115339141E-01, 2.6845718127E-01, 4.7256281838E-01],
	[8.2200000000E+03, 8.9865785390E+00, 1.7587581551E+01, 2.8168190425E-01, 2.6894450752E-01, 4.7272834224E-01],
	[8.2250000000E+03, 8.9936569291E+00, 1.7584016333E+01, 2.8221108745E-01, 2.6943239420E-01, 4.7289381378E-01],
	[8.2300000000E+03, 9.0007365878E+00, 1.7580454004E+01, 2.8274094144E-01, 2.6992084152E-01, 4.7305923316E-01],
	[8.2350000000E+03, 9.0078175146E+00, 1.7576894560E+01, 2.8327146667E-01, 2.7040984969E-01, 4.7322460050E-01],
	[8.2400000000E+03, 9.0148997090E+00, 1.7573337996E+01, 2.8380266358E-01, 2.7089941893E-01, 4.7338991595E-01],
	[8.2450000000E+03, 9.0219831704E+00, 1.7569784309E+01, 2.8433453260E-01, 2.7138954943E-01, 4.7355517965E-01],
	[8.2500000000E+03, 9.0290678982E+00, 1.7566233494E+01, 2.8486707418E-01, 2.7188024141E-01, 4.7372039174E-01],
	[8.2550000000E+03, 9.0361538920E+00, 1.7562685547E+01, 2.8540028876E-01, 2.7237149508E-01, 4.7388555236E-01],
	[8.2600000000E+03, 9.0432411511E+00, 1.7559140465E+01, 2.8593417677E-01, 2.7286331065E-01, 4.7405066166E-01],
	[8.2650000000E+03, 9.0503296751E+00, 1.7555598242E+01, 2.8646873866E-01, 2.7335568832E-01, 4.7421571976E-01],
	[8.2700000000E+03, 9.0574194634E+00, 1.7552058876E+01, 2.8700397487E-01, 2.7384862830E-01, 4.7438072682E-01],
	[8.2750000000E+03, 9.0645105154E+00, 1.7548522363E+01, 2.8753988584E-01, 2.7434213080E-01, 4.7454568297E-01],
	[8.2800000000E+03, 9.0716028307E+00, 1.7544988697E+01, 2.8807647201E-01, 2.7483619603E-01, 4.7471058836E-01],
	[8.2850000000E+03, 9.0786964086E+00, 1.7541457875E+01, 2.8861373382E-01, 2.7533082419E-01, 4.7487544311E-01],
	[8.2900000000E+03, 9.0857912487E+00, 1.7537929894E+01, 2.8915167171E-01, 2.7582601549E-01, 4.7504024738E-01],
	[8.2950000000E+03, 9.0928873505E+00, 1.7534404749E+01, 2.8969028611E-01, 2.7632177013E-01, 4.7520500129E-01],
	[8.3000000000E+03, 9.0999847132E+00, 1.7530882435E+01, 2.9022957748E-01, 2.7681808833E-01, 4.7536970499E-01],
	[8.3050000000E+03, 9.1070833366E+00, 1.7527362950E+01, 2.9076954626E-01, 2.7731497028E-01, 4.7553435863E-01],
	[8.3100000000E+03, 9.1141832199E+00, 1.7523846290E+01, 2.9131019287E-01, 2.7781241620E-01, 4.7569896232E-01],
	[8.3150000000E+03, 9.1212843627E+00, 1.7520332449E+01, 2.9185151777E-01, 2.7831042628E-01, 4.7586351623E-01],
	[8.3200000000E+03, 9.1283867644E+00, 1.7516821425E+01, 2.9239352139E-01, 2.7880900074E-01, 4.7602802048E-01],
	[8.3250000000E+03, 9.1354904246E+00, 1.7513313213E+01, 2.9293620417E-01, 2.7930813977E-01, 4.7619247520E-01],
	[8.3300000000E+03, 9.1425953426E+00, 1.7509807809E+01, 2.9347956656E-01, 2.7980784358E-01, 4.7635688055E-01],
	[8.3350000000E+03, 9.1497015179E+00, 1.7506305210E+01, 2.9402360900E-01, 2.8030811237E-01, 4.7652123666E-01],
	[8.3400000000E+03, 9.1568209502E+00, 1.7502868134E+01, 2.9456833192E-01, 2.8080897378E-01, 4.7668554366E-01],
	[8.3450000000E+03, 9.1639420247E+00, 1.7499435747E+01, 2.9511373576E-01, 2.8131040160E-01, 4.7684980170E-01],
	[8.3500000000E+03, 9.1710643667E+00, 1.7496006089E+01, 2.9565982098E-01, 2.8181239519E-01, 4.7701401091E-01],
	[8.3550000000E+03, 9.1781879757E+00, 1.7492579156E+01, 2.9620658800E-01, 2.8231495475E-01, 4.7717817142E-01],
	[8.3600000000E+03, 9.1853128512E+00, 1.7489154943E+01, 2.9675403727E-01, 2.8281808047E-01, 4.7734228338E-01],
	[8.3650000000E+03, 9.1924389926E+00, 1.7485733447E+01, 2.9730216923E-01, 2.8332177257E-01, 4.7750634693E-01],
	[8.3700000000E+03, 9.1995663995E+00, 1.7482314665E+01, 2.9785098433E-01, 2.8382603125E-01, 4.7767036219E-01],
	[8.3750000000E+03, 9.2066950713E+00, 1.7478898592E+01, 2.9840048299E-01, 2.8433085670E-01, 4.7783432931E-01],
	[8.3800000000E+03, 9.2138250074E+00, 1.7475485225E+01, 2.9895066566E-01, 2.8483624913E-01, 4.7799824842E-01],
	[8.3850000000E+03, 9.2209562073E+00, 1.7472074560E+01, 2.9950153279E-01, 2.8534220874E-01, 4.7816211966E-01],
	[8.3900000000E+03, 9.2280886705E+00, 1.7468666593E+01, 3.0005308482E-01, 2.8584873572E-01, 4.7832594317E-01],
	[8.3950000000E+03, 9.2352223965E+00, 1.7465261321E+01, 3.0060532217E-01, 2.8635583029E-01, 4.7848971907E-01],
	[8.4000000000E+03, 9.2423573847E+00, 1.7461858740E+01, 3.0115824530E-01, 2.8686349263E-01, 4.7865344752E-01],
	[8.4050000000E+03, 9.2494936346E+00, 1.7458458845E+01, 3.0171185465E-01, 2.8737172295E-01, 4.7881712864E-01],
	[8.4100000000E+03, 9.2566311457E+00, 1.7455061634E+01, 3.0226615066E-01, 2.8788052145E-01, 4.7898076256E-01],
	[8.4150000000E+03, 9.2637699175E+00, 1.7451667102E+01, 3.0282113376E-01, 2.8838988833E-01, 4.7914434944E-01],
	[8.4200000000E+03, 9.2709099494E+00, 1.7448275247E+01, 3.0337680441E-01, 2.8889982378E-01, 4.7930788937E-01],
	[8.4250000000E+03, 9.2780512408E+00, 1.7444886063E+01, 3.0393316303E-01, 2.8941032800E-01, 4.7947138248E-01],
	[8.4300000000E+03, 9.2851937914E+00, 1.7441499548E+01, 3.0449021008E-01, 2.8992140120E-01, 4.7963482887E-01],
	[8.4350000000E+03, 9.2923376005E+00, 1.7438115698E+01, 3.0504794598E-01, 2.9043304356E-01, 4.7979822866E-01],
	[8.4400000000E+03, 9.2994826676E+00, 1.7434734509E+01, 3.0560637119E-01, 2.9094525529E-01, 4.7996158195E-01],
	[8.4450000000E+03, 9.3066289922E+00, 1.7431355978E+01, 3.0616548615E-01, 2.9145803658E-01, 4.8012488886E-01],
	[8.4500000000E+03, 9.3137765738E+00, 1.7427980101E+01, 3.0672529129E-01, 2.9197138763E-01, 4.8028814950E-01],
	[8.4550000000E+03, 9.3209254119E+00, 1.7424606873E+01, 3.0728578706E-01, 2.9248530863E-01, 4.8045136398E-01],
	[8.4600000000E+03, 9.3280755059E+00, 1.7421236292E+01, 3.0784697389E-01, 2.9299979979E-01, 4.8061453242E-01],
	[8.4650000000E+03, 9.3352268553E+00, 1.7417868354E+01, 3.0840885224E-01, 2.9351486129E-01, 4.8077765491E-01],
	[8.4700000000E+03, 9.3423810469E+00, 1.7414511259E+01, 3.0897142253E-01, 2.9403049724E-01, 4.8094073157E-01],
	[8.4750000000E+03, 9.3495468615E+00, 1.7411210315E+01, 3.0953468522E-01, 2.9454672956E-01, 4.8110376252E-01],
	[8.4800000000E+03, 9.3567139412E+00, 1.7407911944E+01, 3.1009864073E-01, 2.9506353299E-01, 4.8126674786E-01],
	[8.4850000000E+03, 9.3638822855E+00, 1.7404616141E+01, 3.1066328952E-01, 2.9558090773E-01, 4.8142968770E-01],
	[8.4900000000E+03, 9.3710518939E+00, 1.7401322903E+01, 3.1122884138E-01, 2.9609904344E-01, 4.8159258216E-01],
	[8.4950000000E+03, 9.3782227658E+00, 1.7398032226E+01, 3.1179510052E-01, 2.9661776270E-01, 4.8175543134E-01],
	[8.5000000000E+03, 9.3853949007E+00, 1.7394744108E+01, 3.1236205501E-01, 2.9713705445E-01, 4.8191823536E-01],
	[8.5050000000E+03, 9.3925682981E+00, 1.7391458544E+01, 3.1292970528E-01, 2.9765691891E-01, 4.8208099432E-01],
	[8.5100000000E+03, 9.3997429575E+00, 1.7388175531E+01, 3.1349805177E-01, 2.9817735626E-01, 4.8224370833E-01],
	[8.5150000000E+03, 9.4069188783E+00, 1.7384895065E+01, 3.1406709494E-01, 2.9869836669E-01, 4.8240637750E-01],
	[8.5200000000E+03, 9.4140960601E+00, 1.7381617144E+01, 3.1463683521E-01, 2.9921995041E-01, 4.8256900195E-01],
	[8.5250000000E+03, 9.4212745023E+00, 1.7378341763E+01, 3.1520727304E-01, 2.9974210759E-01, 4.8273158178E-01],
	[8.5300000000E+03, 9.4284542044E+00, 1.7375068920E+01, 3.1577840886E-01, 3.0026483844E-01, 4.8289411710E-01],
	[8.5350000000E+03, 9.4356351659E+00, 1.7371798610E+01, 3.1635024312E-01, 3.0078814315E-01, 4.8305660802E-01],
	[8.5400000000E+03, 9.4428173862E+00, 1.7368530830E+01, 3.1692277626E-01, 3.0131202191E-01, 4.8321905465E-01],
	[8.5450000000E+03, 9.4500008649E+00, 1.7365265577E+01, 3.1749600873E-01, 3.0183647491E-01, 4.8338145710E-01],
	[8.5500000000E+03, 9.4571856014E+00, 1.7362002848E+01, 3.1806994096E-01, 3.0236150234E-01, 4.8354381547E-01],
	[8.5550000000E+03, 9.4643715953E+00, 1.7358742638E+01, 3.1864457340E-01, 3.0288710439E-01, 4.8370612989E-01],
	[8.5600000000E+03, 9.4715588459E+00, 1.7355484945E+01, 3.1921990649E-01, 3.0341328126E-01, 4.8386840044E-01],
	[8.5650000000E+03, 9.4787473529E+00, 1.7352229766E+01, 3.1979594067E-01, 3.0394003313E-01, 4.8403062726E-01],
	[8.5700000000E+03, 9.4859371156E+00, 1.7348977095E+01, 3.2037267639E-01, 3.0446736019E-01, 4.8419281043E-01],
	[8.5750000000E+03, 9.4931281335E+00, 1.7345726932E+01, 3.2095011409E-01, 3.0499526263E-01, 4.8435495007E-01],
	[8.5800000000E+03, 9.5003204063E+00, 1.7342479271E+01, 3.2152825422E-01, 3.0552374065E-01, 4.8451704630E-01],
	[8.5850000000E+03, 9.5075139332E+00, 1.7339234110E+01, 3.2210709720E-01, 3.0605279443E-01, 4.8467909921E-01],
	[8.5900000000E+03, 9.5147087139E+00, 1.7335991445E+01, 3.2268664350E-01, 3.0658242415E-01, 4.8484110891E-01],
	[8.5950000000E+03, 9.5219047478E+00, 1.7332751272E+01, 3.2326689355E-01, 3.0711263002E-01, 4.8500307552E-01],
	[8.6000000000E+03, 9.5291020344E+00, 1.7329513589E+01, 3.2384784779E-01, 3.0764341220E-01, 4.8516499914E-01],
	[8.6050000000E+03, 9.5363005731E+00, 1.7326278393E+01, 3.2442950666E-01, 3.0817477090E-01, 4.8532687988E-01],
	[8.6100000000E+03, 9.5435103239E+00, 1.7323096546E+01, 3.2501187062E-01, 3.0870673288E-01, 4.8548871785E-01],
	[8.6150000000E+03, 9.5507229052E+00, 1.7319925141E+01, 3.2559494009E-01, 3.0923927610E-01, 4.8565051315E-01],
	[8.6200000000E+03, 9.5579367480E+00, 1.7316756156E+01, 3.2617871553E-01, 3.0977239658E-01, 4.8581226589E-01],
	[8.6250000000E+03, 9.5651518516E+00, 1.7313589588E+01, 3.2676319738E-01, 3.1030609449E-01, 4.8597397618E-01],
	[8.6300000000E+03, 9.5723682155E+00, 1.7310425434E+01, 3.2734838608E-01, 3.1084037004E-01, 4.8613564413E-01],
	[8.6350000000E+03, 9.5795858393E+00, 1.7307263690E+01, 3.2793428208E-01, 3.1137522341E-01, 4.8629726985E-01],
	[8.6400000000E+03, 9.5868047224E+00, 1.7304104354E+01, 3.2852088581E-01, 3.1191065477E-01, 4.8645885343E-01],
	[8.6450000000E+03, 9.5940248643E+00, 1.7300947421E+01, 3.2910819772E-01, 3.1244666433E-01, 4.8662039499E-01],
	[8.6500000000E+03, 9.6012462646E+00, 1.7297792889E+01, 3.2969621825E-01, 3.1298325225E-01, 4.8678189464E-01],
	[8.6550000000E+03, 9.6084689226E+00, 1.7294640755E+01, 3.3028494785E-01, 3.1352041873E-01, 4.8694335248E-01],
	[8.6600000000E+03, 9.6156928380E+00, 1.7291491016E+01, 3.3087438696E-01, 3.1405816395E-01, 4.8710476862E-01],
	[8.6650000000E+03, 9.6229180101E+00, 1.7288343667E+01, 3.3146453602E-01, 3.1459648810E-01, 4.8726614316E-01],
	[8.6700000000E+03, 9.6301444386E+00, 1.7285198706E+01, 3.3205539547E-01, 3.1513539135E-01, 4.8742747622E-01],
	[8.6750000000E+03, 9.6373721228E+00, 1.7282056131E+01, 3.3264696576E-01, 3.1567487390E-01, 4.8758876790E-01],
	[8.6800000000E+03, 9.6446010623E+00, 1.7278915937E+01, 3.3323924733E-01, 3.1621493592E-01, 4.8775001830E-01],
	[8.6850000000E+03, 9.6518312565E+00, 1.7275778121E+01, 3.3383224063E-01, 3.1675557760E-01, 4.8791122753E-01],
	[8.6900000000E+03, 9.6590627050E+00, 1.7272642680E+01, 3.3442594610E-01, 3.1729679911E-01, 4.8807239570E-01],
	[8.6950000000E+03, 9.6662954073E+00, 1.7269509612E+01, 3.3502036417E-01, 3.1783860065E-01, 4.8823352291E-01],
	[8.7000000000E+03, 9.6735293628E+00, 1.7266378913E+01, 3.3561549530E-01, 3.1838098240E-01, 4.8839460928E-01],
	[8.7050000000E+03, 9.6807645711E+00, 1.7263250579E+01, 3.3621133992E-01, 3.1892394452E-01, 4.8855565490E-01],
	[8.7100000000E+03, 9.6880010316E+00, 1.7260124608E+01, 3.3680789849E-01, 3.1946748721E-01, 4.8871665988E-01],
	[8.7150000000E+03, 9.6952387438E+00, 1.7257000996E+01, 3.3740517144E-01, 3.2001161065E-01, 4.8887762433E-01],
	[8.7200000000E+03, 9.7024777074E+00, 1.7253879741E+01, 3.3800315921E-01, 3.2055631502E-01, 4.8903854835E-01],
	[8.7250000000E+03, 9.7097179216E+00, 1.7250760840E+01, 3.3860186226E-01, 3.2110160048E-01, 4.8919943205E-01],
	[8.7300000000E+03, 9.7169593861E+00, 1.7247644288E+01, 3.3920128102E-01, 3.2164746724E-01, 4.8936027554E-01],
	[8.7350000000E+03, 9.7242021003E+00, 1.7244530083E+01, 3.3980141593E-01, 3.2219391546E-01, 4.8952107892E-01],
	[8.7400000000E+03, 9.7314460638E+00, 1.7241418222E+01, 3.4040226745E-01, 3.2274094532E-01, 4.8968184229E-01],
	[8.7450000000E+03, 9.7386930066E+00, 1.7238317458E+01, 3.4100383601E-01, 3.2328856200E-01, 4.8984256576E-01],
	[8.7500000000E+03, 9.7459505711E+00, 1.7235266393E+01, 3.4160612205E-01, 3.2383678777E-01, 4.9000324944E-01],
	[8.7550000000E+03, 9.7532093936E+00, 1.7232217611E+01, 3.4220912603E-01, 3.2438559590E-01, 4.9016389344E-01],
	[8.7600000000E+03, 9.7604694735E+00, 1.7229171108E+01, 3.4281284838E-01, 3.2493498659E-01, 4.9032449784E-01],
	[8.7650000000E+03, 9.7677308103E+00, 1.7226126882E+01, 3.4341728954E-01, 3.2548495999E-01, 4.9048506277E-01],
	[8.7700000000E+03, 9.7749934036E+00, 1.7223084929E+01, 3.4402244997E-01, 3.2603551629E-01, 4.9064558832E-01],
	[8.7750000000E+03, 9.7822572528E+00, 1.7220045247E+01, 3.4462833010E-01, 3.2658665567E-01, 4.9080607461E-01],
	[8.7800000000E+03, 9.7895223574E+00, 1.7217007832E+01, 3.4523493038E-01, 3.2713837831E-01, 4.9096652173E-01],
	[8.7850000000E+03, 9.7967887169E+00, 1.7213972682E+01, 3.4584225125E-01, 3.2769068437E-01, 4.9112692979E-01],
	[8.7900000000E+03, 9.8040563308E+00, 1.7210939794E+01, 3.4645029315E-01, 3.2824357403E-01, 4.9128729890E-01],
	[8.7950000000E+03, 9.8113251987E+00, 1.7207909164E+01, 3.4705905653E-01, 3.2879704748E-01, 4.9144762915E-01],
	[8.8000000000E+03, 9.8185953201E+00, 1.7204880790E+01, 3.4766854183E-01, 3.2935110489E-01, 4.9160792066E-01],
	[8.8050000000E+03, 9.8258666943E+00, 1.7201854668E+01, 3.4827874950E-01, 3.2990574642E-01, 4.9176817353E-01],
	[8.8100000000E+03, 9.8331393210E+00, 1.7198830796E+01, 3.4888967998E-01, 3.3046097227E-01, 4.9192838786E-01],
	[8.8150000000E+03, 9.8404131997E+00, 1.7195809171E+01, 3.4950133370E-01, 3.3101678259E-01, 4.9208856376E-01],
	[8.8200000000E+03, 9.8476883298E+00, 1.7192789790E+01, 3.5011371113E-01, 3.3157317756E-01, 4.9224870132E-01],
	[8.8250000000E+03, 9.8549647109E+00, 1.7189772650E+01, 3.5072681269E-01, 3.3213015737E-01, 4.9240880067E-01],
	[8.8300000000E+03, 9.8622423424E+00, 1.7186757747E+01, 3.5134063884E-01, 3.3268772217E-01, 4.9256886187E-01],
	[8.8350000000E+03, 9.8695212239E+00, 1.7183745080E+01, 3.5195519001E-01, 3.3324587215E-01, 4.9272888502E-01],
	[8.8400000000E+03, 9.8768013549E+00, 1.7180734645E+01, 3.5257046665E-01, 3.3380460748E-01, 4.9288887020E-01],
	[8.8450000000E+03, 9.8840827349E+00, 1.7177726439E+01, 3.5318646921E-01, 3.3436392833E-01, 4.9304881747E-01],
	[8.8500000000E+03, 9.8913653634E+00, 1.7174720459E+01, 3.5380319813E-01, 3.3492383486E-01, 4.9320872694E-01],
	[8.8550000000E+03, 9.8986492398E+00, 1.7171716703E+01, 3.5442065385E-01, 3.3548432726E-01, 4.9336859868E-01],
	[8.8600000000E+03, 9.9059343638E+00, 1.7168715167E+01, 3.5503883681E-01, 3.3604540569E-01, 4.9352843277E-01],
	[8.8650000000E+03, 9.9132207348E+00, 1.7165715849E+01, 3.5565774747E-01, 3.3660707032E-01, 4.9368822929E-01],
	[8.8700000000E+03, 9.9205083524E+00, 1.7162718745E+01, 3.5627738625E-01, 3.3716932133E-01, 4.9384798834E-01],
	[8.8750000000E+03, 9.9277972160E+00, 1.7159723853E+01, 3.5689775362E-01, 3.3773215889E-01, 4.9400770997E-01],
	[8.8800000000E+03, 9.9350873251E+00, 1.7156731171E+01, 3.5751885000E-01, 3.3829558316E-01, 4.9416739430E-01],
	[8.8850000000E+03, 9.9423786998E+00, 1.7153740797E+01, 3.5814067585E-01, 3.3885959437E-01, 4.9432704138E-01],
	[8.8900000000E+03, 9.9496819694E+00, 1.7150805991E+01, 3.5876323161E-01, 3.3942422594E-01, 4.9448665130E-01],
	[8.8950000000E+03, 9.9569864927E+00, 1.7147873337E+01, 3.5938651772E-01, 3.3998944491E-01, 4.9464622416E-01],
	[8.9000000000E+03, 9.9642922693E+00, 1.7144942832E+01, 3.6001053463E-01, 3.4055525147E-01, 4.9480576002E-01],
	[8.9050000000E+03, 9.9715992986E+00, 1.7142014473E+01, 3.6063528277E-01, 3.4112164579E-01, 4.9496525896E-01],
	[8.9100000000E+03, 9.9789075802E+00, 1.7139088258E+01, 3.6126076261E-01, 3.4168862802E-01, 4.9512472108E-01],
	[8.9150000000E+03, 9.9862171136E+00, 1.7136164183E+01, 3.6188697457E-01, 3.4225619834E-01, 4.9528414645E-01],
	[8.9200000000E+03, 9.9935278983E+00, 1.7133242246E+01, 3.6251391910E-01, 3.4282435691E-01, 4.9544353516E-01],
	[8.9250000000E+03, 1.0000839934E+01, 1.7130322445E+01, 3.6314159665E-01, 3.4339310391E-01, 4.9560288728E-01],
	[8.9300000000E+03, 1.0008153220E+01, 1.7127404776E+01, 3.6377000766E-01, 3.4396243950E-01, 4.9576220289E-01],
	[8.9350000000E+03, 1.0015467755E+01, 1.7124489237E+01, 3.6439915257E-01, 3.4453236384E-01, 4.9592148209E-01],
	[8.9400000000E+03, 1.0022783540E+01, 1.7121575824E+01, 3.6502903183E-01, 3.4510287711E-01, 4.9608072494E-01],
	[8.9450000000E+03, 1.0030100574E+01, 1.7118664536E+01, 3.6565964589E-01, 3.4567397946E-01, 4.9623993153E-01],
	[8.9500000000E+03, 1.0037418856E+01, 1.7115755370E+01, 3.6629099518E-01, 3.4624567107E-01, 4.9639910195E-01],
	[8.9550000000E+03, 1.0044738386E+01, 1.7112848322E+01, 3.6692308015E-01, 3.4681795209E-01, 4.9655823626E-01],
	[8.9600000000E+03, 1.0052059164E+01, 1.7109943390E+01, 3.6755590125E-01, 3.4739082270E-01, 4.9671733456E-01],
	[8.9650000000E+03, 1.0059381188E+01, 1.7107040571E+01, 3.6818945892E-01, 3.4796428306E-01, 4.9687639693E-01],
	[8.9700000000E+03, 1.0066704459E+01, 1.7104139863E+01, 3.6882375360E-01, 3.4853833333E-01, 4.9703542344E-01],
	[8.9750000000E+03, 1.0074028976E+01, 1.7101241263E+01, 3.6945878574E-01, 3.4911297367E-01, 4.9719441417E-01],
	[8.9800000000E+03, 1.0081354739E+01, 1.7098344769E+01, 3.7009455578E-01, 3.4968820425E-01, 4.9735336922E-01],
	[8.9850000000E+03, 1.0088681746E+01, 1.7095450376E+01, 3.7073106416E-01, 3.5026402524E-01, 4.9751228865E-01],
	[8.9900000000E+03, 1.0096009998E+01, 1.7092558084E+01, 3.7136831134E-01, 3.5084043678E-01, 4.9767117255E-01],
	[8.9950000000E+03, 1.0103339494E+01, 1.7089667888E+01, 3.7200629775E-01, 3.5141743906E-01, 4.9783002100E-01],
	[9.0000000000E+03, 1.0110670233E+01, 1.7086779787E+01, 3.7264502384E-01, 3.5199503222E-01, 4.9798883409E-01],
	[9.0050000000E+03, 1.0118002216E+01, 1.7083893778E+01, 3.7328834868E-01, 3.5257665876E-01, 4.9814761188E-01],
	[9.0100000000E+03, 1.0125335441E+01, 1.7081009857E+01, 3.7393242519E-01, 3.5315888540E-01, 4.9830635446E-01],
	[9.0150000000E+03, 1.0132669908E+01, 1.7078128023E+01, 3.7457725383E-01, 3.5374171229E-01, 4.9846506192E-01],
	[9.0200000000E+03, 1.0140005617E+01, 1.7075248273E+01, 3.7522283504E-01, 3.5432513962E-01, 4.9862373433E-01],
	[9.0250000000E+03, 1.0147342567E+01, 1.7072370604E+01, 3.7586916929E-01, 3.5490916755E-01, 4.9878237177E-01],
	[9.0300000000E+03, 1.0154684821E+01, 1.7069515131E+01, 3.7651625704E-01, 3.5549380995E-01, 4.9894097433E-01],
	[9.0350000000E+03, 1.0162034552E+01, 1.7066692556E+01, 3.7716409875E-01, 3.5607907444E-01, 4.9909954208E-01],
	[9.0400000000E+03, 1.0169385532E+01, 1.7063872010E+01, 3.7781269488E-01, 3.5666494023E-01, 4.9925807511E-01],
	[9.0450000000E+03, 1.0176737761E+01, 1.7061053489E+01, 3.7846204588E-01, 3.5725140748E-01, 4.9941657349E-01],
	[9.0500000000E+03, 1.0184091238E+01, 1.7058236991E+01, 3.7911215221E-01, 3.5783847636E-01, 4.9957503731E-01],
	[9.0550000000E+03, 1.0191445962E+01, 1.7055422513E+01, 3.7976301434E-01, 3.5842614704E-01, 4.9973346664E-01],
	[9.0600000000E+03, 1.0198801934E+01, 1.7052610053E+01, 3.8041463272E-01, 3.5901441968E-01, 4.9989186157E-01],
	[9.0650000000E+03, 1.0206159151E+01, 1.7049799608E+01, 3.8106700781E-01, 3.5960329445E-01, 5.0005022217E-01],
	[9.0700000000E+03, 1.0213517615E+01, 1.7046991175E+01, 3.8172014007E-01, 3.6019277151E-01, 5.0020854853E-01],
	[9.0750000000E+03, 1.0220877325E+01, 1.7044184753E+01, 3.8237402995E-01, 3.6078285103E-01, 5.0036684072E-01],
	[9.0800000000E+03, 1.0228238279E+01, 1.7041380338E+01, 3.8302867793E-01, 3.6137353317E-01, 5.0052509883E-01],
	[9.0850000000E+03, 1.0235600478E+01, 1.7038577927E+01, 3.8368408445E-01, 3.6196481810E-01, 5.0068332294E-01],
	[9.0900000000E+03, 1.0242963921E+01, 1.7035777520E+01, 3.8434024997E-01, 3.6255670597E-01, 5.0084151312E-01],
	[9.0950000000E+03, 1.0250328608E+01, 1.7032979112E+01, 3.8499717496E-01, 3.6314919696E-01, 5.0099966946E-01],
	[9.1000000000E+03, 1.0257694538E+01, 1.7030182701E+01, 3.8565485988E-01, 3.6374229121E-01, 5.0115779203E-01],
	[9.1050000000E+03, 1.0265061711E+01, 1.7027388285E+01, 3.8631330517E-01, 3.6433598891E-01, 5.0131588092E-01],
	[9.1100000000E+03, 1.0272430126E+01, 1.7024595861E+01, 3.8697251131E-01, 3.6493029020E-01, 5.0147393621E-01],
	[9.1150000000E+03, 1.0279799783E+01, 1.7021805427E+01, 3.8763247875E-01, 3.6552519526E-01, 5.0163195797E-01],
	[9.1200000000E+03, 1.0287170681E+01, 1.7019016981E+01, 3.8829320795E-01, 3.6612070423E-01, 5.0178994628E-01],
	[9.1250000000E+03, 1.0294542820E+01, 1.7016230519E+01, 3.8895469937E-01, 3.6671681729E-01, 5.0194790123E-01],
	[9.1300000000E+03, 1.0301916200E+01, 1.7013446039E+01, 3.8961695346E-01, 3.6731353459E-01, 5.0210582289E-01],
	[9.1350000000E+03, 1.0309290819E+01, 1.7010663540E+01, 3.9027997070E-01, 3.6791085629E-01, 5.0226371134E-01],
	[9.1400000000E+03, 1.0316666678E+01, 1.7007883017E+01, 3.9094375153E-01, 3.6850878255E-01, 5.0242156667E-01],
	[9.1450000000E+03, 1.0324043776E+01, 1.7005104469E+01, 3.9160829641E-01, 3.6910731354E-01, 5.0257938895E-01],
	[9.1500000000E+03, 1.0331422112E+01, 1.7002327894E+01, 3.9227360582E-01, 3.6970644940E-01, 5.0273717826E-01],
	[9.1550000000E+03, 1.0338801686E+01, 1.6999553288E+01, 3.9293968019E-01, 3.7030619031E-01, 5.0289493469E-01],
	[9.1600000000E+03, 1.0346182498E+01, 1.6996780650E+01, 3.9360652000E-01, 3.7090653641E-01, 5.0305265830E-01],
	[9.1650000000E+03, 1.0353564546E+01, 1.6994009976E+01, 3.9427412571E-01, 3.7150748786E-01, 5.0321034919E-01],
	[9.1700000000E+03, 1.0360947832E+01, 1.6991241265E+01, 3.9494249776E-01, 3.7210904483E-01, 5.0336800742E-01],
	[9.1750000000E+03, 1.0368335641E+01, 1.6988490427E+01, 3.9561163663E-01, 3.7271121937E-01, 5.0352563308E-01],
	[9.1800000000E+03, 1.0375731462E+01, 1.6985774285E+01, 3.9628154277E-01, 3.7331402440E-01, 5.0368322625E-01],
	[9.1850000000E+03, 1.0383128526E+01, 1.6983060056E+01, 3.9695221665E-01, 3.7391743562E-01, 5.0384078701E-01],
	[9.1900000000E+03, 1.0390526835E+01, 1.6980347737E+01, 3.9762365871E-01, 3.7452145318E-01, 5.0399831543E-01],
	[9.1950000000E+03, 1.0397926386E+01, 1.6977637327E+01, 3.9829586942E-01, 3.7512607724E-01, 5.0415581160E-01],
	[9.2000000000E+03, 1.0405327180E+01, 1.6974928822E+01, 3.9896884924E-01, 3.7573130795E-01, 5.0431327560E-01],
	[9.2050000000E+03, 1.0412729217E+01, 1.6972222221E+01, 3.9964259863E-01, 3.7633714549E-01, 5.0447070749E-01],
	[9.2100000000E+03, 1.0420132495E+01, 1.6969517521E+01, 4.0031711805E-01, 3.7694358998E-01, 5.0462810737E-01],
	[9.2150000000E+03, 1.0427537014E+01, 1.6966814719E+01, 4.0099240796E-01, 3.7755064160E-01, 5.0478547531E-01],
	[9.2200000000E+03, 1.0434942774E+01, 1.6964113813E+01, 4.0166846882E-01, 3.7815830050E-01, 5.0494281139E-01],
	[9.2250000000E+03, 1.0442349775E+01, 1.6961414802E+01, 4.0234530108E-01, 3.7876656683E-01, 5.0510011566E-01],
	[9.2300000000E+03, 1.0449758015E+01, 1.6958717682E+01, 4.0302290521E-01, 3.7937544074E-01, 5.0525738818E-01],
	[9.2350000000E+03, 1.0457167495E+01, 1.6956022451E+01, 4.0370128167E-01, 3.7998492239E-01, 5.0541462902E-01],
	[9.2400000000E+03, 1.0464578213E+01, 1.6953329107E+01, 4.0438043091E-01, 3.8059501194E-01, 5.0557183822E-01],
	[9.2450000000E+03, 1.0471990170E+01, 1.6950637647E+01, 4.0506035340E-01, 3.8120570952E-01, 5.0572901585E-01],
	[9.2500000000E+03, 1.0479403365E+01, 1.6947948070E+01, 4.0574104959E-01, 3.8181701531E-01, 5.0588616198E-01],
	[9.2550000000E+03, 1.0486817798E+01, 1.6945260373E+01, 4.0642251996E-01, 3.8242892943E-01, 5.0604327665E-01],
	[9.2600000000E+03, 1.0494233468E+01, 1.6942574553E+01, 4.0710476494E-01, 3.8304145206E-01, 5.0620035994E-01],
	[9.2650000000E+03, 1.0501650374E+01, 1.6939890608E+01, 4.0778778502E-01, 3.8365458334E-01, 5.0635741190E-01],
	[9.2700000000E+03, 1.0509068517E+01, 1.6937208536E+01, 4.0847158063E-01, 3.8426832342E-01, 5.0651443258E-01],
	[9.2750000000E+03, 1.0516487895E+01, 1.6934528335E+01, 4.0915615226E-01, 3.8488267245E-01, 5.0667142206E-01],
	[9.2800000000E+03, 1.0523908509E+01, 1.6931850002E+01, 4.0984150034E-01, 3.8549763058E-01, 5.0682838039E-01],
	[9.2850000000E+03, 1.0531330357E+01, 1.6929173535E+01, 4.1052762536E-01, 3.8611319797E-01, 5.0698530762E-01],
	[9.2900000000E+03, 1.0538753440E+01, 1.6926498931E+01, 4.1121452775E-01, 3.8672937475E-01, 5.0714220383E-01],
	[9.2950000000E+03, 1.0546177756E+01, 1.6923826189E+01, 4.1190220799E-01, 3.8734616108E-01, 5.0729906906E-01],
	[9.3000000000E+03, 1.0553603306E+01, 1.6921155306E+01, 4.1259066654E-01, 3.8796355711E-01, 5.0745590339E-01],
	[9.3050000000E+03, 1.0561030089E+01, 1.6918486280E+01, 4.1327990385E-01, 3.8858156298E-01, 5.0761270686E-01],
	[9.3100000000E+03, 1.0568458104E+01, 1.6915819108E+01, 4.1396992039E-01, 3.8920017885E-01, 5.0776947954E-01],
	[9.3150000000E+03, 1.0575887351E+01, 1.6913153788E+01, 4.1466071661E-01, 3.8981940486E-01, 5.0792622149E-01],
	[9.3200000000E+03, 1.0583317830E+01, 1.6910490318E+01, 4.1535229297E-01, 3.9043924115E-01, 5.0808293277E-01],
	[9.3250000000E+03, 1.0590757326E+01, 1.6907865461E+01, 4.1604464994E-01, 3.9105971816E-01, 5.0823961344E-01],
	[9.3300000000E+03, 1.0598200115E+01, 1.6905252119E+01, 4.1673778798E-01, 3.9168081393E-01, 5.0839626355E-01],
	[9.3350000000E+03, 1.0605644142E+01, 1.6902640581E+01, 4.1743170754E-01, 3.9230252065E-01, 5.0855288317E-01],
	[9.3400000000E+03, 1.0613089408E+01, 1.6900030845E+01, 4.1812640908E-01, 3.9292483844E-01, 5.0870947236E-01],
	[9.3450000000E+03, 1.0620535912E+01, 1.6897422908E+01, 4.1882189307E-01, 3.9354776747E-01, 5.0886603117E-01],
	[9.3500000000E+03, 1.0627983653E+01, 1.6894816768E+01, 4.1951815997E-01, 3.9417130787E-01, 5.0902255967E-01],
	[9.3550000000E+03, 1.0635432631E+01, 1.6892212423E+01, 4.2021521023E-01, 3.9479545979E-01, 5.0917905791E-01],
	[9.3600000000E+03, 1.0642882846E+01, 1.6889609870E+01, 4.2091304431E-01, 3.9542022338E-01, 5.0933552596E-01],
	[9.3650000000E+03, 1.0650334296E+01, 1.6887009108E+01, 4.2161166269E-01, 3.9604559877E-01, 5.0949196387E-01],
	[9.3700000000E+03, 1.0657786982E+01, 1.6884410135E+01, 4.2231106581E-01, 3.9667158612E-01, 5.0964837171E-01],
	[9.3750000000E+03, 1.0665240904E+01, 1.6881812947E+01, 4.2301125413E-01, 3.9729818556E-01, 5.0980474953E-01],
	[9.3800000000E+03, 1.0672696059E+01, 1.6879217544E+01, 4.2371222813E-01, 3.9792539725E-01, 5.0996109740E-01],
	[9.3850000000E+03, 1.0680152450E+01, 1.6876623922E+01, 4.2441398825E-01, 3.9855322132E-01, 5.1011741537E-01],
	[9.3900000000E+03, 1.0687610073E+01, 1.6874032080E+01, 4.2511653496E-01, 3.9918165791E-01, 5.1027370350E-01],
	[9.3950000000E+03, 1.0695068930E+01, 1.6871442016E+01, 4.2581986872E-01, 3.9981070716E-01, 5.1042996185E-01],
	[9.4000000000E+03, 1.0702529020E+01, 1.6868853727E+01, 4.2652398998E-01, 4.0044036923E-01, 5.1058619048E-01],
	[9.4050000000E+03, 1.0709990343E+01, 1.6866267211E+01, 4.2722889922E-01, 4.0107064425E-01, 5.1074238945E-01],
	[9.4100000000E+03, 1.0717452897E+01, 1.6863682466E+01, 4.2793459688E-01, 4.0170153235E-01, 5.1089855883E-01],
	[9.4150000000E+03, 1.0724916682E+01, 1.6861099490E+01, 4.2864108344E-01, 4.0233303369E-01, 5.1105469866E-01],
	[9.4200000000E+03, 1.0732381699E+01, 1.6858518280E+01, 4.2934835934E-01, 4.0296514840E-01, 5.1121080901E-01],
	[9.4250000000E+03, 1.0739847946E+01, 1.6855938835E+01, 4.3005642506E-01, 4.0359787661E-01, 5.1136688994E-01],
	[9.4300000000E+03, 1.0747315424E+01, 1.6853361152E+01, 4.3076528104E-01, 4.0423121848E-01, 5.1152294151E-01],
	[9.4350000000E+03, 1.0754784131E+01, 1.6850785230E+01, 4.3147492776E-01, 4.0486517414E-01, 5.1167896377E-01],
	[9.4400000000E+03, 1.0762254067E+01, 1.6848211066E+01, 4.3218536568E-01, 4.0549974372E-01, 5.1183495679E-01],
	[9.4450000000E+03, 1.0769725232E+01, 1.6845638658E+01, 4.3289659524E-01, 4.0613492737E-01, 5.1199092063E-01],
	[9.4500000000E+03, 1.0777197626E+01, 1.6843068003E+01, 4.3360861692E-01, 4.0677072522E-01, 5.1214685534E-01],
	[9.4550000000E+03, 1.0784671247E+01, 1.6840499101E+01, 4.3432143118E-01, 4.0740713742E-01, 5.1230276099E-01],
	[9.4600000000E+03, 1.0792146096E+01, 1.6837931948E+01, 4.3503503847E-01, 4.0804416409E-01, 5.1245863763E-01],
	[9.4650000000E+03, 1.0799622171E+01, 1.6835366542E+01, 4.3574943925E-01, 4.0868180537E-01, 5.1261448532E-01],
	[9.4700000000E+03, 1.0807099474E+01, 1.6832802882E+01, 4.3646463399E-01, 4.0932006141E-01, 5.1277030412E-01],
	[9.4750000000E+03, 1.0814585504E+01, 1.6830275551E+01, 4.3718062315E-01, 4.0995896363E-01, 5.1292609410E-01],
	[9.4800000000E+03, 1.0822074885E+01, 1.6827759687E+01, 4.3789740719E-01, 4.1059848990E-01, 5.1308185531E-01],
	[9.4850000000E+03, 1.0829565499E+01, 1.6825245525E+01, 4.3861498657E-01, 4.1123863155E-01, 5.1323758780E-01],
	[9.4900000000E+03, 1.0837057346E+01, 1.6822733064E+01, 4.3933355112E-01, 4.1187955516E-01, 5.1339329165E-01],
	[9.4950000000E+03, 1.0844550425E+01, 1.6820222301E+01, 4.4005302201E-01, 4.1252119109E-01, 5.1354896690E-01],
	[9.5000000000E+03, 1.0852044737E+01, 1.6817713235E+01, 4.4077329053E-01, 4.1316344352E-01, 5.1370461363E-01],
	[9.5050000000E+03, 1.0859540280E+01, 1.6815205862E+01, 4.4149435715E-01, 4.1380631258E-01, 5.1386023188E-01],
	[9.5100000000E+03, 1.0867037055E+01, 1.6812700182E+01, 4.4221622233E-01, 4.1444979842E-01, 5.1401582171E-01],
	[9.5150000000E+03, 1.0874535060E+01, 1.6810196192E+01, 4.4293888653E-01, 4.1509390116E-01, 5.1417138319E-01],
	[9.5200000000E+03, 1.0882034296E+01, 1.6807693890E+01, 4.4366235022E-01, 4.1573862094E-01, 5.1432691638E-01],
	[9.5250000000E+03, 1.0889534761E+01, 1.6805193274E+01, 4.4438661386E-01, 4.1638395789E-01, 5.1448242132E-01],
	[9.5300000000E+03, 1.0897036456E+01, 1.6802694342E+01, 4.4511167790E-01, 4.1702991214E-01, 5.1463789809E-01],
	[9.5350000000E+03, 1.0904539380E+01, 1.6800197092E+01, 4.4583754282E-01, 4.1767648383E-01, 5.1479334675E-01],
	[9.5400000000E+03, 1.0912043532E+01, 1.6797701522E+01, 4.4656420907E-01, 4.1832367309E-01, 5.1494876734E-01],
	[9.5450000000E+03, 1.0919548913E+01, 1.6795207630E+01, 4.4729167712E-01, 4.1897148006E-01, 5.1510415993E-01],
	[9.5500000000E+03, 1.0927055521E+01, 1.6792715414E+01, 4.4801994742E-01, 4.1961990485E-01, 5.1525952459E-01],
	[9.5550000000E+03, 1.0934563356E+01, 1.6790224872E+01, 4.4874902045E-01, 4.2026894761E-01, 5.1541486136E-01],
	[9.5600000000E+03, 1.0942072419E+01, 1.6787736003E+01, 4.4947889666E-01, 4.2091860847E-01, 5.1557017031E-01],
	[9.5650000000E+03, 1.0949582707E+01, 1.6785248803E+01, 4.5020957652E-01, 4.2156888755E-01, 5.1572545149E-01],
	[9.5700000000E+03, 1.0957094221E+01, 1.6782763271E+01, 4.5094106048E-01, 4.2221978498E-01, 5.1588070497E-01],
	[9.5750000000E+03, 1.0964606961E+01, 1.6780279405E+01, 4.5167334902E-01, 4.2287130090E-01, 5.1603593080E-01],
	[9.5800000000E+03, 1.0972120926E+01, 1.6777797204E+01, 4.5240644259E-01, 4.2352343544E-01, 5.1619112905E-01],
	[9.5850000000E+03, 1.0979636115E+01, 1.6775316664E+01, 4.5314034166E-01, 4.2417618871E-01, 5.1634629977E-01],
	[9.5900000000E+03, 1.0987152529E+01, 1.6772837784E+01, 4.5387504669E-01, 4.2482956086E-01, 5.1650144302E-01],
	[9.5950000000E+03, 1.0994670166E+01, 1.6770360563E+01, 4.5461055813E-01, 4.2548355201E-01, 5.1665655886E-01],
	[9.6000000000E+03, 1.1002189026E+01, 1.6767884998E+01, 4.5534687647E-01, 4.2613816229E-01, 5.1681164734E-01],
	[9.6050000000E+03, 1.1009709109E+01, 1.6765411086E+01, 4.5608400215E-01, 4.2679339182E-01, 5.1696670848E-01],
	[9.6100000000E+03, 1.1017230415E+01, 1.6762938827E+01, 4.5682193564E-01, 4.2744924073E-01, 5.1712174234E-01],
	[9.6150000000E+03, 1.1024752943E+01, 1.6760468219E+01, 4.5756067740E-01, 4.2810570915E-01, 5.1727674896E-01],
	[9.6200000000E+03, 1.1032276692E+01, 1.6757999258E+01, 4.5830022789E-01, 4.2876279720E-01, 5.1743172838E-01],
	[9.6250000000E+03, 1.1039804344E+01, 1.6755544023E+01, 4.5904058759E-01, 4.2942051701E-01, 5.1758668064E-01],
	[9.6300000000E+03, 1.1047339934E+01, 1.6753120628E+01, 4.5978175694E-01, 4.3007888684E-01, 5.1774160578E-01],
	[9.6350000000E+03, 1.1054876752E+01, 1.6750698842E+01, 4.6052373642E-01, 4.3073787692E-01, 5.1789650386E-01],
	[9.6400000000E+03, 1.1062414797E+01, 1.6748278662E+01, 4.6126652649E-01, 4.3139748735E-01, 5.1805137490E-01],
	[9.6450000000E+03, 1.1069954070E+01, 1.6745860086E+01, 4.6201012760E-01, 4.3205771827E-01, 5.1820621896E-01],
	[9.6500000000E+03, 1.1077494570E+01, 1.6743443113E+01, 4.6275454023E-01, 4.3271856979E-01, 5.1836103608E-01],
	[9.6550000000E+03, 1.1085036296E+01, 1.6741027740E+01, 4.6349976483E-01, 4.3338004206E-01, 5.1851582629E-01],
	[9.6600000000E+03, 1.1092579248E+01, 1.6738613966E+01, 4.6424580187E-01, 4.3404213518E-01, 5.1867058965E-01],
	[9.6650000000E+03, 1.1100123425E+01, 1.6736201789E+01, 4.6499265181E-01, 4.3470484928E-01, 5.1882532619E-01],
	[9.6700000000E+03, 1.1107668828E+01, 1.6733791207E+01, 4.6574031511E-01, 4.3536818448E-01, 5.1898003596E-01],
	[9.6750000000E+03, 1.1115215455E+01, 1.6731382218E+01, 4.6648879224E-01, 4.3603214091E-01, 5.1913471900E-01],
	[9.6800000000E+03, 1.1122763306E+01, 1.6728974820E+01, 4.6723808366E-01, 4.3669671869E-01, 5.1928937536E-01],
	[9.6850000000E+03, 1.1130312381E+01, 1.6726569011E+01, 4.6798818983E-01, 4.3736191794E-01, 5.1944400507E-01],
	[9.6900000000E+03, 1.1137862680E+01, 1.6724164790E+01, 4.6873911122E-01, 4.3802773878E-01, 5.1959860818E-01],
	[9.6950000000E+03, 1.1145414201E+01, 1.6721762154E+01, 4.6949084829E-01, 4.3869418134E-01, 5.1975318473E-01],
	[9.7000000000E+03, 1.1152966945E+01, 1.6719361102E+01, 4.7024340150E-01, 4.3936124573E-01, 5.1990773477E-01],
	[9.7050000000E+03, 1.1160520911E+01, 1.6716961632E+01, 4.7099677131E-01, 4.4002893207E-01, 5.2006225833E-01],
	[9.7100000000E+03, 1.1168076098E+01, 1.6714563742E+01, 4.7175095819E-01, 4.4069724048E-01, 5.2021675547E-01],
	[9.7150000000E+03, 1.1175632507E+01, 1.6712167429E+01, 4.7250596260E-01, 4.4136617109E-01, 5.2037122622E-01],
	[9.7200000000E+03, 1.1183190136E+01, 1.6709772694E+01, 4.7326178501E-01, 4.4203572401E-01, 5.2052567062E-01],
	[9.7250000000E+03, 1.1190748986E+01, 1.6707379532E+01, 4.7401842588E-01, 4.4270589937E-01, 5.2068008872E-01],
	[9.7300000000E+03, 1.1198309055E+01, 1.6704987943E+01, 4.7477588566E-01, 4.4337669727E-01, 5.2083448057E-01],
	[9.7350000000E+03, 1.1205870344E+01, 1.6702597925E+01, 4.7553416483E-01, 4.4404811783E-01, 5.2098884620E-01],
	[9.7400000000E+03, 1.1213432852E+01, 1.6700209476E+01, 4.7629326385E-01, 4.4472016119E-01, 5.2114318566E-01],
	[9.7450000000E+03, 1.1220996579E+01, 1.6697822594E+01, 4.7705318317E-01, 4.4539282744E-01, 5.2129749898E-01],
	[9.7500000000E+03, 1.1228561523E+01, 1.6695437277E+01, 4.7781392328E-01, 4.4606611671E-01, 5.2145178623E-01],
	[9.7550000000E+03, 1.1236127686E+01, 1.6693053524E+01, 4.7857548461E-01, 4.4674002912E-01, 5.2160604742E-01],
	[9.7600000000E+03, 1.1243695066E+01, 1.6690671332E+01, 4.7933786765E-01, 4.4741456477E-01, 5.2176028262E-01],
	[9.7650000000E+03, 1.1251263662E+01, 1.6688290700E+01, 4.8010107286E-01, 4.4808972379E-01, 5.2191449186E-01],
	[9.7700000000E+03, 1.1258833475E+01, 1.6685911625E+01, 4.8086510069E-01, 4.4876550630E-01, 5.2206867518E-01],
	[9.7750000000E+03, 1.1266404504E+01, 1.6683534107E+01, 4.8162995161E-01, 4.4944191240E-01, 5.2222283263E-01],
	[9.7800000000E+03, 1.1273979502E+01, 1.6681170247E+01, 4.8239562608E-01, 4.5011895541E-01, 5.2237696425E-01],
	[9.7850000000E+03, 1.1281562136E+01, 1.6678836125E+01, 4.8316212458E-01, 4.5079665316E-01, 5.2253107008E-01],
	[9.7900000000E+03, 1.1289145991E+01, 1.6676503521E+01, 4.8392944755E-01, 4.5147497507E-01, 5.2268515017E-01],
	[9.7950000000E+03, 1.1296731069E+01, 1.6674172434E+01, 4.8469759547E-01, 4.5215392127E-01, 5.2283920456E-01],
	[9.8000000000E+03, 1.1304317368E+01, 1.6671842862E+01, 4.8546656879E-01, 4.5283349187E-01, 5.2299323329E-01],
	[9.8050000000E+03, 1.1311904888E+01, 1.6669514804E+01, 4.8623636799E-01, 4.5351368698E-01, 5.2314723641E-01],
	[9.8100000000E+03, 1.1319493629E+01, 1.6667188257E+01, 4.8700699353E-01, 4.5419450671E-01, 5.2330121396E-01],
	[9.8150000000E+03, 1.1327083590E+01, 1.6664863220E+01, 4.8777844586E-01, 4.5487595117E-01, 5.2345516597E-01],
	[9.8200000000E+03, 1.1334674771E+01, 1.6662539692E+01, 4.8855072545E-01, 4.5555802048E-01, 5.2360909250E-01],
	[9.8250000000E+03, 1.1342267171E+01, 1.6660217670E+01, 4.8932383278E-01, 4.5624071475E-01, 5.2376299359E-01],
	[9.8300000000E+03, 1.1349860791E+01, 1.6657897153E+01, 4.9009776829E-01, 4.5692403409E-01, 5.2391686927E-01],
	[9.8350000000E+03, 1.1357455629E+01, 1.6655578139E+01, 4.9087253245E-01, 4.5760797861E-01, 5.2407071960E-01],
	[9.8400000000E+03, 1.1365051685E+01, 1.6653260626E+01, 4.9164812573E-01, 4.5829254842E-01, 5.2422454461E-01],
	[9.8450000000E+03, 1.1372648958E+01, 1.6650944612E+01, 4.9242454859E-01, 4.5897774363E-01, 5.2437834436E-01],
	[9.8500000000E+03, 1.1380247449E+01, 1.6648630096E+01, 4.9320180150E-01, 4.5966356435E-01, 5.2453211887E-01],
	[9.8550000000E+03, 1.1387847157E+01, 1.6646317077E+01, 4.9397988492E-01, 4.6035001069E-01, 5.2468586820E-01],
	[9.8600000000E+03, 1.1395448081E+01, 1.6644005552E+01, 4.9475879930E-01, 4.6103708276E-01, 5.2483959238E-01],
	[9.8650000000E+03, 1.1403050221E+01, 1.6641695519E+01, 4.9553854513E-01, 4.6172478066E-01, 5.2499329147E-01],
	[9.8700000000E+03, 1.1410653577E+01, 1.6639386977E+01, 4.9631912285E-01, 4.6241310451E-01, 5.2514696550E-01],
	[9.8750000000E+03, 1.1418258148E+01, 1.6637079925E+01, 4.9710053294E-01, 4.6310205441E-01, 5.2530061451E-01],
	[9.8800000000E+03, 1.1425863934E+01, 1.6634774359E+01, 4.9788277585E-01, 4.6379163046E-01, 5.2545423855E-01],
	[9.8850000000E+03, 1.1433470934E+01, 1.6632470280E+01, 4.9866585206E-01, 4.6448183279E-01, 5.2560783767E-01],
	[9.8900000000E+03, 1.1441079148E+01, 1.6630167685E+01, 4.9944976202E-01, 4.6517266149E-01, 5.2576141190E-01],
	[9.8950000000E+03, 1.1448688575E+01, 1.6627866572E+01, 5.0023450620E-01, 4.6586411666E-01, 5.2591496129E-01],
	[9.9000000000E+03, 1.1456299215E+01, 1.6625566939E+01, 5.0102008506E-01, 4.6655619842E-01, 5.2606848588E-01],
	[9.9050000000E+03, 1.1463911068E+01, 1.6623268786E+01, 5.0180649907E-01, 4.6724890687E-01, 5.2622198572E-01],
	[9.9100000000E+03, 1.1471524134E+01, 1.6620972110E+01, 5.0259374869E-01, 4.6794224211E-01, 5.2637546084E-01],
	[9.9150000000E+03, 1.1479138411E+01, 1.6618676909E+01, 5.0338183439E-01, 4.6863620425E-01, 5.2652891129E-01],
	[9.9200000000E+03, 1.1486753899E+01, 1.6616383182E+01, 5.0417075663E-01, 4.6933079339E-01, 5.2668233712E-01],
	[9.9250000000E+03, 1.1494370599E+01, 1.6614090928E+01, 5.0496051587E-01, 4.7002600964E-01, 5.2683573836E-01],
	[9.9300000000E+03, 1.1501988509E+01, 1.6611800144E+01, 5.0575111257E-01, 4.7072185310E-01, 5.2698911506E-01],
	[9.9350000000E+03, 1.1509607629E+01, 1.6609510828E+01, 5.0654254721E-01, 4.7141832387E-01, 5.2714246727E-01],
	[9.9400000000E+03, 1.1517235273E+01, 1.6607254320E+01, 5.0733482025E-01, 4.7211545967E-01, 5.2729579501E-01],
	[9.9450000000E+03, 1.1524865782E+01, 1.6605006309E+01, 5.0812793214E-01, 4.7281323168E-01, 5.2744909835E-01],
	[9.9500000000E+03, 1.1532497506E+01, 1.6602759732E+01, 5.0892188336E-01, 4.7351163154E-01, 5.2760237732E-01],
	[9.9550000000E+03, 1.1540130447E+01, 1.6600514587E+01, 5.0971667437E-01, 4.7421065937E-01, 5.2775563196E-01],
	[9.9600000000E+03, 1.1547764602E+01, 1.6598270873E+01, 5.1051230562E-01, 4.7491031525E-01, 5.2790886239E-01],
	[9.9650000000E+03, 1.1555399973E+01, 1.6596028588E+01, 5.1130877760E-01, 4.7561059930E-01, 5.2806206875E-01],
	[9.9700000000E+03, 1.1563036558E+01, 1.6593787731E+01, 5.1210609076E-01, 4.7631151161E-01, 5.2821525106E-01],
	[9.9750000000E+03, 1.1570674358E+01, 1.6591548299E+01, 5.1290424556E-01, 4.7701305228E-01, 5.2836840936E-01],
	[9.9800000000E+03, 1.1578313371E+01, 1.6589310292E+01, 5.1370324247E-01, 4.7771522141E-01, 5.2852154366E-01],
	[9.9850000000E+03, 1.1585953597E+01, 1.6587073707E+01, 5.1450308195E-01, 4.7841801911E-01, 5.2867465398E-01],
	[9.9900000000E+03, 1.1593595037E+01, 1.6584838544E+01, 5.1530376447E-01, 4.7912144546E-01, 5.2882774036E-01],
	[9.9950000000E+03, 1.1601237689E+01, 1.6582604799E+01, 5.1610529050E-01, 4.7982550058E-01, 5.2898080281E-01],
	[1.0000000000E+04, 1.1608881553E+01, 1.6580372473E+01, 5.1690766049E-01, 4.8053018455E-01, 5.2913384136E-01],
	[1.0005000000E+04, 1.1616526628E+01, 1.6578141562E+01, 5.1771433041E-01, 4.8123848322E-01, 5.2928685603E-01],
	[1.0010000000E+04, 1.1624172915E+01, 1.6575912067E+01, 5.1852185434E-01, 4.8194741778E-01, 5.2943984685E-01],
	[1.0015000000E+04, 1.1631820413E+01, 1.6573683984E+01, 5.1933023274E-01, 4.8265698833E-01, 5.2959281383E-01],
	[1.0020000000E+04, 1.1639469121E+01, 1.6571457312E+01, 5.2013946610E-01, 4.8336719497E-01, 5.2974575700E-01],
	[1.0025000000E+04, 1.1647119039E+01, 1.6569232051E+01, 5.2094955488E-01, 4.8407803781E-01, 5.2989867639E-01],
	[1.0030000000E+04, 1.1654770167E+01, 1.6567008197E+01, 5.2176049958E-01, 4.8478951695E-01, 5.3005157201E-01],
	[1.0035000000E+04, 1.1662422504E+01, 1.6564785750E+01, 5.2257230065E-01, 4.8550163249E-01, 5.3020444390E-01],
	[1.0040000000E+04, 1.1670076049E+01, 1.6562564708E+01, 5.2338495858E-01, 4.8621438452E-01, 5.3035729207E-01],
	[1.0045000000E+04, 1.1677730804E+01, 1.6560345070E+01, 5.2419847384E-01, 4.8692777314E-01, 5.3051011655E-01],
	[1.0050000000E+04, 1.1685386766E+01, 1.6558126833E+01, 5.2501284691E-01, 4.8764179846E-01, 5.3066291736E-01],
	[1.0055000000E+04, 1.1693043935E+01, 1.6555909996E+01, 5.2582807827E-01, 4.8835646057E-01, 5.3081569453E-01],
	[1.0060000000E+04, 1.1700702312E+01, 1.6553694559E+01, 5.2664416838E-01, 4.8907175958E-01, 5.3096844808E-01],
	[1.0065000000E+04, 1.1708361895E+01, 1.6551480518E+01, 5.2746111773E-01, 4.8978769557E-01, 5.3112117803E-01],
	[1.0070000000E+04, 1.1716022685E+01, 1.6549267873E+01, 5.2827892679E-01, 4.9050426864E-01, 5.3127388441E-01],
	[1.0075000000E+04, 1.1723684681E+01, 1.6547056621E+01, 5.2909759603E-01, 4.9122147890E-01, 5.3142656723E-01],
	[1.0080000000E+04, 1.1731347882E+01, 1.6544846762E+01, 5.2991712594E-01, 4.9193932643E-01, 5.3157922654E-01],
	[1.0085000000E+04, 1.1739012288E+01, 1.6542638294E+01, 5.3073751698E-01, 4.9265781134E-01, 5.3173186234E-01],
	[1.0090000000E+04, 1.1746677899E+01, 1.6540431215E+01, 5.3155876963E-01, 4.9337693372E-01, 5.3188447466E-01],
	[1.0095000000E+04, 1.1754344714E+01, 1.6538225524E+01, 5.3238088438E-01, 4.9409669367E-01, 5.3203706352E-01],
	[1.0100000000E+04, 1.1762020206E+01, 1.6536051621E+01, 5.3320386169E-01, 4.9481713172E-01, 5.3218962896E-01],
	[1.0105000000E+04, 1.1769698491E+01, 1.6533885516E+01, 5.3402770204E-01, 4.9553821632E-01, 5.3234217099E-01],
	[1.0110000000E+04, 1.1777377986E+01, 1.6531720766E+01, 5.3485240591E-01, 4.9625993902E-01, 5.3249468963E-01],
	[1.0115000000E+04, 1.1785058692E+01, 1.6529557369E+01, 5.3567797376E-01, 4.9698229991E-01, 5.3264718492E-01],
	[1.0120000000E+04, 1.1792740607E+01, 1.6527395325E+01, 5.3650440609E-01, 4.9770529908E-01, 5.3279965687E-01],
	[1.0125000000E+04, 1.1800423731E+01, 1.6525234631E+01, 5.3733170336E-01, 4.9842893664E-01, 5.3295210551E-01],
	[1.0130000000E+04, 1.1808108063E+01, 1.6523075286E+01, 5.3815986606E-01, 4.9915321266E-01, 5.3310453086E-01],
	[1.0135000000E+04, 1.1815793605E+01, 1.6520917289E+01, 5.3898889465E-01, 4.9987812726E-01, 5.3325693295E-01],
	[1.0140000000E+04, 1.1823480354E+01, 1.6518760638E+01, 5.3981878961E-01, 5.0060368050E-01, 5.3340931180E-01],
	[1.0145000000E+04, 1.1831168310E+01, 1.6516605331E+01, 5.4064955142E-01, 5.0132987250E-01, 5.3356166743E-01],
	[1.0150000000E+04, 1.1838857474E+01, 1.6514451367E+01, 5.4148118055E-01, 5.0205670334E-01, 5.3371399987E-01],
	[1.0155000000E+04, 1.1846547845E+01, 1.6512298745E+01, 5.4231367749E-01, 5.0278417311E-01, 5.3386630914E-01],
	[1.0160000000E+04, 1.1854239421E+01, 1.6510147462E+01, 5.4314704270E-01, 5.0351228190E-01, 5.3401859527E-01],
	[1.0165000000E+04, 1.1861932204E+01, 1.6507997518E+01, 5.4398127666E-01, 5.0424102980E-01, 5.3417085828E-01],
	[1.0170000000E+04, 1.1869626192E+01, 1.6505848912E+01, 5.4481637985E-01, 5.0497041691E-01, 5.3432309819E-01],
	[1.0175000000E+04, 1.1877321386E+01, 1.6503701640E+01, 5.4565235275E-01, 5.0570044330E-01, 5.3447531503E-01],
	[1.0180000000E+04, 1.1885017784E+01, 1.6501555703E+01, 5.4648919583E-01, 5.0643110908E-01, 5.3462750882E-01],
	[1.0185000000E+04, 1.1892715386E+01, 1.6499411098E+01, 5.4732690957E-01, 5.0716241432E-01, 5.3477967959E-01],
	[1.0190000000E+04, 1.1900414192E+01, 1.6497267825E+01, 5.4816549444E-01, 5.0789435912E-01, 5.3493182737E-01],
	[1.0195000000E+04, 1.1908114202E+01, 1.6495125881E+01, 5.4900495093E-01, 5.0862694356E-01, 5.3508395216E-01],
	[1.0200000000E+04, 1.1915815414E+01, 1.6492985265E+01, 5.4984527950E-01, 5.0936016773E-01, 5.3523605401E-01],
	[1.0205000000E+04, 1.1923517830E+01, 1.6490845976E+01, 5.5068648063E-01, 5.1009403173E-01, 5.3538813293E-01],
	[1.0210000000E+04, 1.1931221448E+01, 1.6488708012E+01, 5.5152855480E-01, 5.1082853562E-01, 5.3554018894E-01],
	[1.0215000000E+04, 1.1938926267E+01, 1.6486571372E+01, 5.5237150249E-01, 5.1156367951E-01, 5.3569222208E-01],
	[1.0220000000E+04, 1.1946632288E+01, 1.6484436053E+01, 5.5321532417E-01, 5.1229946347E-01, 5.3584423236E-01],
	[1.0225000000E+04, 1.1954339511E+01, 1.6482302056E+01, 5.5406002031E-01, 5.1303588760E-01, 5.3599621982E-01],
	[1.0230000000E+04, 1.1962047933E+01, 1.6480169378E+01, 5.5490559141E-01, 5.1377295197E-01, 5.3614818447E-01],
	[1.0235000000E+04, 1.1969757557E+01, 1.6478038018E+01, 5.5575203792E-01, 5.1451065667E-01, 5.3630012633E-01],
	[1.0240000000E+04, 1.1977468380E+01, 1.6475907974E+01, 5.5659936034E-01, 5.1524900178E-01, 5.3645204544E-01],
	[1.0245000000E+04, 1.1985180402E+01, 1.6473779246E+01, 5.5744755912E-01, 5.1598798739E-01, 5.3660394182E-01],
	[1.0250000000E+04, 1.1992893624E+01, 1.6471651830E+01, 5.5829663476E-01, 5.1672761359E-01, 5.3675581549E-01],
	[1.0255000000E+04, 1.2000608044E+01, 1.6469525727E+01, 5.5914658773E-01, 5.1746788044E-01, 5.3690766648E-01],
	[1.0260000000E+04, 1.2008326659E+01, 1.6467412285E+01, 5.5999741850E-01, 5.1820880487E-01, 5.3705949481E-01],
	[1.0265000000E+04, 1.2016052864E+01, 1.6465324338E+01, 5.6084912756E-01, 5.1895040616E-01, 5.3721130050E-01],
	[1.0270000000E+04, 1.2023780275E+01, 1.6463237673E+01, 5.6170171537E-01, 5.1969264862E-01, 5.3736308359E-01],
	[1.0275000000E+04, 1.2031508891E+01, 1.6461152287E+01, 5.6255518241E-01, 5.2043553233E-01, 5.3751484409E-01],
	[1.0280000000E+04, 1.2039238710E+01, 1.6459068180E+01, 5.6340952917E-01, 5.2117905738E-01, 5.3766658202E-01],
	[1.0285000000E+04, 1.2046969734E+01, 1.6456985350E+01, 5.6426475612E-01, 5.2192322385E-01, 5.3781829742E-01],
	[1.0290000000E+04, 1.2054701960E+01, 1.6454903795E+01, 5.6512086373E-01, 5.2266803182E-01, 5.3796999031E-01],
	[1.0295000000E+04, 1.2062435390E+01, 1.6452823515E+01, 5.6597785248E-01, 5.2341348136E-01, 5.3812166071E-01],
	[1.0300000000E+04, 1.2070170023E+01, 1.6450744508E+01, 5.6683572285E-01, 5.2415957256E-01, 5.3827330865E-01],
	[1.0305000000E+04, 1.2077905857E+01, 1.6448666772E+01, 5.6769447531E-01, 5.2490630549E-01, 5.3842493414E-01],
	[1.0310000000E+04, 1.2085642894E+01, 1.6446590307E+01, 5.6855411035E-01, 5.2565368025E-01, 5.3857653723E-01],
	[1.0315000000E+04, 1.2093381131E+01, 1.6444515110E+01, 5.6941462844E-01, 5.2640169689E-01, 5.3872811792E-01],
	[1.0320000000E+04, 1.2101120570E+01, 1.6442441180E+01, 5.7027603005E-01, 5.2715035551E-01, 5.3887967626E-01],
	[1.0325000000E+04, 1.2108861210E+01, 1.6440368516E+01, 5.7113831567E-01, 5.2789965618E-01, 5.3903121225E-01],
	[1.0330000000E+04, 1.2116603049E+01, 1.6438297117E+01, 5.7200148576E-01, 5.2864959897E-01, 5.3918272592E-01],
	[1.0335000000E+04, 1.2124346089E+01, 1.6436226981E+01, 5.7286554082E-01, 5.2940018397E-01, 5.3933421731E-01],
	[1.0340000000E+04, 1.2132090327E+01, 1.6434158107E+01, 5.7373048130E-01, 5.3015141125E-01, 5.3948568643E-01],
	[1.0345000000E+04, 1.2139835765E+01, 1.6432090493E+01, 5.7459630770E-01, 5.3090328088E-01, 5.3963713330E-01],
	[1.0350000000E+04, 1.2147582402E+01, 1.6430024139E+01, 5.7546302049E-01, 5.3165579295E-01, 5.3978855797E-01],
	[1.0355000000E+04, 1.2155330237E+01, 1.6427959041E+01, 5.7633062014E-01, 5.3240894752E-01, 5.3993996044E-01],
	[1.0360000000E+04, 1.2163079269E+01, 1.6425895201E+01, 5.7719910713E-01, 5.3316274468E-01, 5.4009134074E-01],
	[1.0365000000E+04, 1.2170829500E+01, 1.6423832615E+01, 5.7806848194E-01, 5.3391718449E-01, 5.4024269890E-01],
	[1.0370000000E+04, 1.2178580927E+01, 1.6421771282E+01, 5.7893874505E-01, 5.3467226703E-01, 5.4039403495E-01],
	[1.0375000000E+04, 1.2186333551E+01, 1.6419711202E+01, 5.7980989694E-01, 5.3542799238E-01, 5.4054534890E-01],
	[1.0380000000E+04, 1.2194087371E+01, 1.6417652373E+01, 5.8068193807E-01, 5.3618436060E-01, 5.4069664079E-01],
	[1.0385000000E+04, 1.2201842387E+01, 1.6415594793E+01, 5.8155486893E-01, 5.3694137177E-01, 5.4084791063E-01],
	[1.0390000000E+04, 1.2209598598E+01, 1.6413538461E+01, 5.8242869000E-01, 5.3769902596E-01, 5.4099915846E-01],
	[1.0395000000E+04, 1.2217356005E+01, 1.6411483376E+01, 5.8330340175E-01, 5.3845732325E-01, 5.4115038429E-01],
	[1.0400000000E+04, 1.2225114606E+01, 1.6409429537E+01, 5.8417900467E-01, 5.3921626370E-01, 5.4130158815E-01],
	[1.0405000000E+04, 1.2232874402E+01, 1.6407376941E+01, 5.8505549921E-01, 5.3997584739E-01, 5.4145277008E-01],
	[1.0410000000E+04, 1.2240635392E+01, 1.6405325588E+01, 5.8593288588E-01, 5.4073607438E-01, 5.4160393008E-01],
	[1.0415000000E+04, 1.2248397575E+01, 1.6403275476E+01, 5.8681116513E-01, 5.4149694475E-01, 5.4175506820E-01],
	[1.0420000000E+04, 1.2256160951E+01, 1.6401226605E+01, 5.8769033746E-01, 5.4225845857E-01, 5.4190618444E-01],
	[1.0425000000E+04, 1.2263928340E+01, 1.6399188920E+01, 5.8857040333E-01, 5.4302063234E-01, 5.4205727884E-01],
	[1.0430000000E+04, 1.2271703831E+01, 1.6397176813E+01, 5.8945136323E-01, 5.4378349012E-01, 5.4220835143E-01],
	[1.0435000000E+04, 1.2279480521E+01, 1.6395165917E+01, 5.9033321763E-01, 5.4454699182E-01, 5.4235940222E-01],
	[1.0440000000E+04, 1.2287258411E+01, 1.6393156231E+01, 5.9121596701E-01, 5.4531113753E-01, 5.4251043124E-01],
	[1.0445000000E+04, 1.2295037500E+01, 1.6391147754E+01, 5.9209961184E-01, 5.4607592730E-01, 5.4266143853E-01],
	[1.0450000000E+04, 1.2302817787E+01, 1.6389140483E+01, 5.9298415261E-01, 5.4684136121E-01, 5.4281242409E-01],
	[1.0455000000E+04, 1.2310599272E+01, 1.6387134419E+01, 5.9386958980E-01, 5.4760743933E-01, 5.4296338796E-01],
	[1.0460000000E+04, 1.2318381955E+01, 1.6385129558E+01, 5.9475592387E-01, 5.4837416171E-01, 5.4311433017E-01],
	[1.0465000000E+04, 1.2326165835E+01, 1.6383125902E+01, 5.9564315531E-01, 5.4914152844E-01, 5.4326525074E-01],
	[1.0470000000E+04, 1.2333950912E+01, 1.6381123447E+01, 5.9653128459E-01, 5.4990953956E-01, 5.4341614968E-01],
	[1.0475000000E+04, 1.2341737186E+01, 1.6379122192E+01, 5.9742031220E-01, 5.5067819516E-01, 5.4356702704E-01],
	[1.0480000000E+04, 1.2349524656E+01, 1.6377122137E+01, 5.9831023861E-01, 5.5144749529E-01, 5.4371788283E-01],
	[1.0485000000E+04, 1.2357313321E+01, 1.6375123280E+01, 5.9920106430E-01, 5.5221744002E-01, 5.4386871708E-01],
	[1.0490000000E+04, 1.2365103182E+01, 1.6373125620E+01, 6.0009278974E-01, 5.5298802942E-01, 5.4401952982E-01],
	[1.0495000000E+04, 1.2372894238E+01, 1.6371129155E+01, 6.0098541542E-01, 5.5375926355E-01, 5.4417032106E-01],
	[1.0500000000E+04, 1.2380686489E+01, 1.6369133885E+01, 6.0187894181E-01, 5.5453114247E-01, 5.4432109084E-01],
	[1.0505000000E+04, 1.2388479933E+01, 1.6367139807E+01, 6.0277336938E-01, 5.5530366625E-01, 5.4447183918E-01],
	[1.0510000000E+04, 1.2396274572E+01, 1.6365146921E+01, 6.0366869863E-01, 5.5607683495E-01, 5.4462256611E-01],
	[1.0515000000E+04, 1.2404070404E+01, 1.6363155226E+01, 6.0456493002E-01, 5.5685064863E-01, 5.4477327164E-01],
	[1.0520000000E+04, 1.2411867429E+01, 1.6361164719E+01, 6.0546206403E-01, 5.5762510736E-01, 5.4492395582E-01],
	[1.0525000000E+04, 1.2419665647E+01, 1.6359175400E+01, 6.0636010115E-01, 5.5840021119E-01, 5.4507461865E-01],
	[1.0530000000E+04, 1.2427465057E+01, 1.6357187268E+01, 6.0725904184E-01, 5.5917596019E-01, 5.4522526018E-01],
	[1.0535000000E+04, 1.2435265659E+01, 1.6355200321E+01, 6.0815888659E-01, 5.5995235442E-01, 5.4537588041E-01],
	[1.0540000000E+04, 1.2443067452E+01, 1.6353214558E+01, 6.0905963588E-01, 5.6072939394E-01, 5.4552647939E-01],
	[1.0545000000E+04, 1.2450870437E+01, 1.6351229978E+01, 6.0996129017E-01, 5.6150707881E-01, 5.4567705712E-01],
	[1.0550000000E+04, 1.2458674612E+01, 1.6349246579E+01, 6.1086384996E-01, 5.6228540909E-01, 5.4582761365E-01],
	[1.0555000000E+04, 1.2466479978E+01, 1.6347264360E+01, 6.1176731572E-01, 5.6306438483E-01, 5.4597814899E-01],
	[1.0560000000E+04, 1.2474286534E+01, 1.6345283321E+01, 6.1267168793E-01, 5.6384400611E-01, 5.4612866317E-01],
	[1.0565000000E+04, 1.2482094279E+01, 1.6343303459E+01, 6.1357696706E-01, 5.6462427297E-01, 5.4627915622E-01],
	[1.0570000000E+04, 1.2489903214E+01, 1.6341324773E+01, 6.1448315359E-01, 5.6540518547E-01, 5.4642962816E-01],
	[1.0575000000E+04, 1.2497713337E+01, 1.6339347263E+01, 6.1539024801E-01, 5.6618674368E-01, 5.4658007901E-01],
	[1.0580000000E+04, 1.2505524649E+01, 1.6337370926E+01, 6.1629825078E-01, 5.6696894764E-01, 5.4673050881E-01],
	[1.0585000000E+04, 1.2513337149E+01, 1.6335395762E+01, 6.1720716239E-01, 5.6775179742E-01, 5.4688091758E-01],
	[1.0590000000E+04, 1.2521150837E+01, 1.6333421770E+01, 6.1811698332E-01, 5.6853529308E-01, 5.4703130534E-01],
	[1.0595000000E+04, 1.2528973053E+01, 1.6331473069E+01, 6.1902771405E-01, 5.6931947912E-01, 5.4718167212E-01],
	[1.0600000000E+04, 1.2536799191E+01, 1.6329534483E+01, 6.1993935504E-01, 5.7010432794E-01, 5.4733201794E-01],
	[1.0605000000E+04, 1.2544626524E+01, 1.6327597042E+01, 6.2085190679E-01, 5.7088982309E-01, 5.4748234283E-01],
	[1.0610000000E+04, 1.2552455051E+01, 1.6325660744E+01, 6.2176536977E-01, 5.7167596462E-01, 5.4763264683E-01],
	[1.0615000000E+04, 1.2560284771E+01, 1.6323725588E+01, 6.2267974445E-01, 5.7246275259E-01, 5.4778292994E-01],
	[1.0620000000E+04, 1.2568115685E+01, 1.6321791572E+01, 6.2359503132E-01, 5.7325018706E-01, 5.4793319220E-01],
	[1.0625000000E+04, 1.2575947792E+01, 1.6319858695E+01, 6.2451123086E-01, 5.7403826808E-01, 5.4808343363E-01],
	[1.0630000000E+04, 1.2583781091E+01, 1.6317926957E+01, 6.2542834353E-01, 5.7482699570E-01, 5.4823365427E-01],
	[1.0635000000E+04, 1.2591615582E+01, 1.6315996355E+01, 6.2634636983E-01, 5.7561636998E-01, 5.4838385413E-01],
	[1.0640000000E+04, 1.2599451265E+01, 1.6314066889E+01, 6.2726531023E-01, 5.7640639096E-01, 5.4853403324E-01],
	[1.0645000000E+04, 1.2607288139E+01, 1.6312138558E+01, 6.2818516521E-01, 5.7719705871E-01, 5.4868419162E-01],
	[1.0650000000E+04, 1.2615126204E+01, 1.6310211360E+01, 6.2910593525E-01, 5.7798837328E-01, 5.4883432923E-01],
	[1.0655000000E+04, 1.2622965460E+01, 1.6308285294E+01, 6.3002762082E-01, 5.7878033470E-01, 5.4898444608E-01],
	[1.0660000000E+04, 1.2630805906E+01, 1.6306360358E+01, 6.3095022240E-01, 5.7957294305E-01, 5.4913454216E-01],
	[1.0665000000E+04, 1.2638647542E+01, 1.6304436553E+01, 6.3187374048E-01, 5.8036619836E-01, 5.4928461748E-01],
	[1.0670000000E+04, 1.2646490367E+01, 1.6302513876E+01, 6.3279817552E-01, 5.8116010070E-01, 5.4943467205E-01],
	[1.0675000000E+04, 1.2654334381E+01, 1.6300592327E+01, 6.3372352802E-01, 5.8195465009E-01, 5.4958470587E-01],
	[1.0680000000E+04, 1.2662179584E+01, 1.6298671903E+01, 6.3464979845E-01, 5.8274984661E-01, 5.4973471895E-01],
	[1.0685000000E+04, 1.2670025976E+01, 1.6296752605E+01, 6.3557698728E-01, 5.8354569030E-01, 5.4988471129E-01],
	[1.0690000000E+04, 1.2677873555E+01, 1.6294834430E+01, 6.3650509500E-01, 5.8434218120E-01, 5.5003468290E-01],
	[1.0695000000E+04, 1.2685722322E+01, 1.6292917378E+01, 6.3743412208E-01, 5.8513931936E-01, 5.5018463379E-01],
	[1.0700000000E+04, 1.2693572276E+01, 1.6291001448E+01, 6.3836406901E-01, 5.8593710484E-01, 5.5033456397E-01],
	[1.0705000000E+04, 1.2701423417E+01, 1.6289086637E+01, 6.3929493626E-01, 5.8673553767E-01, 5.5048447344E-01],
	[1.0710000000E+04, 1.2709275744E+01, 1.6287172946E+01, 6.4022672431E-01, 5.8753461791E-01, 5.5063436220E-01],
	[1.0715000000E+04, 1.2717129257E+01, 1.6285260372E+01, 6.4115943364E-01, 5.8833434560E-01, 5.5078423026E-01],
	[1.0720000000E+04, 1.2724983956E+01, 1.6283348916E+01, 6.4209306473E-01, 5.8913472080E-01, 5.5093407764E-01],
	[1.0725000000E+04, 1.2732839841E+01, 1.6281438574E+01, 6.4302761806E-01, 5.8993574353E-01, 5.5108390433E-01],
	[1.0730000000E+04, 1.2740696910E+01, 1.6279529347E+01, 6.4396309410E-01, 5.9073741386E-01, 5.5123371034E-01],
	[1.0735000000E+04, 1.2748555164E+01, 1.6277621234E+01, 6.4489949334E-01, 5.9153973182E-01, 5.5138349568E-01],
	[1.0740000000E+04, 1.2756414602E+01, 1.6275714232E+01, 6.4583681626E-01, 5.9234269746E-01, 5.5153326035E-01],
	[1.0745000000E+04, 1.2764275224E+01, 1.6273808341E+01, 6.4677506332E-01, 5.9314631083E-01, 5.5168300437E-01],
	[1.0750000000E+04, 1.2772137030E+01, 1.6271903560E+01, 6.4771423502E-01, 5.9395057196E-01, 5.5183272773E-01],
	[1.0755000000E+04, 1.2780000018E+01, 1.6269999887E+01, 6.4865433183E-01, 5.9475548090E-01, 5.5198243045E-01],
	[1.0760000000E+04, 1.2787864189E+01, 1.6268097322E+01, 6.4959535423E-01, 5.9556103769E-01, 5.5213211254E-01],
	[1.0765000000E+04, 1.2795736081E+01, 1.6266215897E+01, 6.5053730270E-01, 5.9636728351E-01, 5.5228177398E-01],
	[1.0770000000E+04, 1.2803613040E+01, 1.6264347440E+01, 6.5148017772E-01, 5.9717420192E-01, 5.5243141481E-01],
	[1.0775000000E+04, 1.2811491188E+01, 1.6262480065E+01, 6.5242397977E-01, 5.9798176860E-01, 5.5258103502E-01],
	[1.0780000000E+04, 1.2819370525E+01, 1.6260613770E+01, 6.5336870932E-01, 5.9878998362E-01, 5.5273063461E-01],
	[1.0785000000E+04, 1.2827251051E+01, 1.6258748555E+01, 6.5431436686E-01, 5.9959884700E-01, 5.5288021360E-01],
	[1.0790000000E+04, 1.2835132766E+01, 1.6256884419E+01, 6.5526095287E-01, 6.0040835880E-01, 5.5302977199E-01],
	[1.0795000000E+04, 1.2843015668E+01, 1.6255021359E+01, 6.5620846782E-01, 6.0121851905E-01, 5.5317930979E-01],
	[1.0800000000E+04, 1.2850899759E+01, 1.6253159376E+01, 6.5715691219E-01, 6.0202932779E-01, 5.5332882701E-01],
	[1.0805000000E+04, 1.2858785036E+01, 1.6251298467E+01, 6.5810628647E-01, 6.0284078505E-01, 5.5347832365E-01],
	[1.0810000000E+04, 1.2866671501E+01, 1.6249438633E+01, 6.5905659112E-01, 6.0365289089E-01, 5.5362779971E-01],
	[1.0815000000E+04, 1.2874559152E+01, 1.6247579871E+01, 6.6000782664E-01, 6.0446564534E-01, 5.5377725522E-01],
	[1.0820000000E+04, 1.2882447990E+01, 1.6245722181E+01, 6.6095999350E-01, 6.0527904844E-01, 5.5392669017E-01],
	[1.0825000000E+04, 1.2890338013E+01, 1.6243865561E+01, 6.6191309218E-01, 6.0609310022E-01, 5.5407610457E-01],
	[1.0830000000E+04, 1.2898229222E+01, 1.6242010010E+01, 6.6286712317E-01, 6.0690780073E-01, 5.5422549842E-01],
	[1.0835000000E+04, 1.2906121616E+01, 1.6240155528E+01, 6.6382208692E-01, 6.0772315000E-01, 5.5437487174E-01],
	[1.0840000000E+04, 1.2914015194E+01, 1.6238302114E+01, 6.6477798394E-01, 6.0853914806E-01, 5.5452422453E-01],
	[1.0845000000E+04, 1.2921909957E+01, 1.6236449765E+01, 6.6573481470E-01, 6.0935579496E-01, 5.5467355681E-01],
	[1.0850000000E+04, 1.2929805904E+01, 1.6234598481E+01, 6.6669257967E-01, 6.1017309073E-01, 5.5482286856E-01],
	[1.0855000000E+04, 1.2937703035E+01, 1.6232748261E+01, 6.6765127934E-01, 6.1099103541E-01, 5.5497215981E-01],
	[1.0860000000E+04, 1.2945601349E+01, 1.6230899104E+01, 6.6861091419E-01, 6.1180962902E-01, 5.5512143056E-01],
	[1.0865000000E+04, 1.2953500846E+01, 1.6229051008E+01, 6.6957148469E-01, 6.1262887161E-01, 5.5527068082E-01],
	[1.0870000000E+04, 1.2961401525E+01, 1.6227203973E+01, 6.7053299133E-01, 6.1344876322E-01, 5.5541991059E-01],
	[1.0875000000E+04, 1.2969303387E+01, 1.6225357998E+01, 6.7149543458E-01, 6.1426930386E-01, 5.5556911989E-01],
	[1.0880000000E+04, 1.2977206430E+01, 1.6223513081E+01, 6.7245881492E-01, 6.1509049358E-01, 5.5571830871E-01],
	[1.0885000000E+04, 1.2985110655E+01, 1.6221669221E+01, 6.7342313285E-01, 6.1591233242E-01, 5.5586747707E-01],
	[1.0890000000E+04, 1.2993016061E+01, 1.6219826417E+01, 6.7438838882E-01, 6.1673482039E-01, 5.5601662498E-01],
	[1.0895000000E+04, 1.3000922648E+01, 1.6217984669E+01, 6.7535458333E-01, 6.1755795754E-01, 5.5616575244E-01],
	[1.0900000000E+04, 1.3008830415E+01, 1.6216143974E+01, 6.7632171685E-01, 6.1838174390E-01, 5.5631485945E-01],
	[1.0905000000E+04, 1.3016739362E+01, 1.6214304333E+01, 6.7728978987E-01, 6.1920617949E-01, 5.5646394604E-01],
	[1.0910000000E+04, 1.3024649489E+01, 1.6212465743E+01, 6.7825880285E-01, 6.2003126436E-01, 5.5661301219E-01],
	[1.0915000000E+04, 1.3032560794E+01, 1.6210628204E+01, 6.7922875629E-01, 6.2085699852E-01, 5.5676205793E-01],
	[1.0920000000E+04, 1.3040473279E+01, 1.6208791715E+01, 6.8019965067E-01, 6.2168338201E-01, 5.5691108326E-01],
	[1.0925000000E+04, 1.3048386942E+01, 1.6206956274E+01, 6.8117148645E-01, 6.2251041486E-01, 5.5706008818E-01],
	[1.0930000000E+04, 1.3056301784E+01, 1.6205121881E+01, 6.8214426413E-01, 6.2333809710E-01, 5.5720907271E-01],
	[1.0935000000E+04, 1.3064217803E+01, 1.6203288534E+01, 6.8311798418E-01, 6.2416642876E-01, 5.5735803685E-01],
	[1.0940000000E+04, 1.3072145525E+01, 1.6201486312E+01, 6.8409264708E-01, 6.2499547868E-01, 5.5750698060E-01],
	[1.0945000000E+04, 1.3080074676E+01, 1.6199685807E+01, 6.8506825331E-01, 6.2582517998E-01, 5.5765590399E-01],
	[1.0950000000E+04, 1.3088005011E+01, 1.6197886324E+01, 6.8604480335E-01, 6.2665553111E-01, 5.5780480701E-01],
	[1.0955000000E+04, 1.3095936531E+01, 1.6196087863E+01, 6.8702229769E-01, 6.2748653209E-01, 5.5795368967E-01],
	[1.0960000000E+04, 1.3103869235E+01, 1.6194290422E+01, 6.8800073680E-01, 6.2831818294E-01, 5.5810255198E-01],
	[1.0965000000E+04, 1.3111803122E+01, 1.6192494000E+01, 6.8898012116E-01, 6.2915048371E-01, 5.5825139395E-01],
	[1.0970000000E+04, 1.3119738193E+01, 1.6190698596E+01, 6.8996045125E-01, 6.2998343440E-01, 5.5840021559E-01],
	[1.0975000000E+04, 1.3127674447E+01, 1.6188904209E+01, 6.9094172755E-01, 6.3081703505E-01, 5.5854901690E-01],
	[1.0980000000E+04, 1.3135611884E+01, 1.6187110838E+01, 6.9192395054E-01, 6.3165128569E-01, 5.5869779789E-01],
	[1.0985000000E+04, 1.3143550503E+01, 1.6185318482E+01, 6.9290712071E-01, 6.3248618634E-01, 5.5884655857E-01],
	[1.0990000000E+04, 1.3151490304E+01, 1.6183527140E+01, 6.9389123852E-01, 6.3332173702E-01, 5.5899529895E-01],
	[1.0995000000E+04, 1.3159431286E+01, 1.6181736812E+01, 6.9487630447E-01, 6.3415793777E-01, 5.5914401903E-01],
	[1.1000000000E+04, 1.3167373450E+01, 1.6179947494E+01, 6.9586231904E-01, 6.3499478859E-01, 5.5929271883E-01],
	[1.1005000000E+04, 1.3175316794E+01, 1.6178159188E+01, 6.9684928269E-01, 6.3583228952E-01, 5.5944139835E-01],
	[1.1010000000E+04, 1.3183261319E+01, 1.6176371892E+01, 6.9783719592E-01, 6.3667044059E-01, 5.5959005759E-01],
	[1.1015000000E+04, 1.3191207024E+01, 1.6174585604E+01, 6.9882605920E-01, 6.3750924180E-01, 5.5973869658E-01],
	[1.1020000000E+04, 1.3199153909E+01, 1.6172800325E+01, 6.9981587301E-01, 6.3834869319E-01, 5.5988731531E-01],
	[1.1025000000E+04, 1.3207101973E+01, 1.6171016052E+01, 7.0080663784E-01, 6.3918879478E-01, 5.6003591379E-01],
	[1.1030000000E+04, 1.3215051216E+01, 1.6169232784E+01, 7.0179835416E-01, 6.4002954659E-01, 5.6018449203E-01],
	[1.1035000000E+04, 1.3223001638E+01, 1.6167450522E+01, 7.0279102245E-01, 6.4087094863E-01, 5.6033305005E-01],
	[1.1040000000E+04, 1.3230953239E+01, 1.6165669263E+01, 7.0378464320E-01, 6.4171300094E-01, 5.6048158784E-01],
	[1.1045000000E+04, 1.3238906017E+01, 1.6163889007E+01, 7.0477921688E-01, 6.4255570353E-01, 5.6063010541E-01],
	[1.1050000000E+04, 1.3246859973E+01, 1.6162109752E+01, 7.0577474398E-01, 6.4339905641E-01, 5.6077860278E-01],
	[1.1055000000E+04, 1.3254815106E+01, 1.6160331498E+01, 7.0677122498E-01, 6.4424305962E-01, 5.6092707996E-01],
	[1.1060000000E+04, 1.3262771416E+01, 1.6158554244E+01, 7.0776866035E-01, 6.4508771317E-01, 5.6107553694E-01],
	[1.1065000000E+04, 1.3270728902E+01, 1.6156777988E+01, 7.0876705057E-01, 6.4593301707E-01, 5.6122397374E-01],
	[1.1070000000E+04, 1.3278687565E+01, 1.6155002730E+01, 7.0976639614E-01, 6.4677897135E-01, 5.6137239037E-01],
	[1.1075000000E+04, 1.3286647403E+01, 1.6153228469E+01, 7.1076669752E-01, 6.4762557602E-01, 5.6152078684E-01],
	[1.1080000000E+04, 1.3294608417E+01, 1.6151455203E+01, 7.1176795520E-01, 6.4847283110E-01, 5.6166916315E-01],
	[1.1085000000E+04, 1.3302570606E+01, 1.6149682931E+01, 7.1277016966E-01, 6.4932073661E-01, 5.6181751931E-01],
	[1.1090000000E+04, 1.3310533970E+01, 1.6147911653E+01, 7.1377334138E-01, 6.5016929257E-01, 5.6196585533E-01],
	[1.1095000000E+04, 1.3318498508E+01, 1.6146141368E+01, 7.1477747083E-01, 6.5101849898E-01, 5.6211417122E-01],
	[1.1100000000E+04, 1.3326464220E+01, 1.6144372074E+01, 7.1578255851E-01, 6.5186835586E-01, 5.6226246699E-01],
	[1.1105000000E+04, 1.3334431106E+01, 1.6142603771E+01, 7.1678860489E-01, 6.5271886324E-01, 5.6241074264E-01],
	[1.1110000000E+04, 1.3342399166E+01, 1.6140836457E+01, 7.1779561045E-01, 6.5357002112E-01, 5.6255899819E-01],
	[1.1115000000E+04, 1.3350376955E+01, 1.6139092960E+01, 7.1880357568E-01, 6.5442188761E-01, 5.6270723365E-01],
	[1.1120000000E+04, 1.3358358489E+01, 1.6137357276E+01, 7.1981250104E-01, 6.5527442236E-01, 5.6285544901E-01],
	[1.1125000000E+04, 1.3366341204E+01, 1.6135622558E+01, 7.2082238703E-01, 6.5612760798E-01, 5.6300364430E-01],
	[1.1130000000E+04, 1.3374325099E+01, 1.6133888806E+01, 7.2183323413E-01, 6.5698144451E-01, 5.6315181951E-01],
	[1.1135000000E+04, 1.3382310174E+01, 1.6132156020E+01, 7.2284504281E-01, 6.5783593195E-01, 5.6329997466E-01],
	[1.1140000000E+04, 1.3390296429E+01, 1.6130424197E+01, 7.2385781356E-01, 6.5869107031E-01, 5.6344810976E-01],
	[1.1145000000E+04, 1.3398283862E+01, 1.6128693337E+01, 7.2487154685E-01, 6.5954685961E-01, 5.6359622481E-01],
	[1.1150000000E+04, 1.3406272475E+01, 1.6126963439E+01, 7.2588624318E-01, 6.6040329986E-01, 5.6374431983E-01],
	[1.1155000000E+04, 1.3414262265E+01, 1.6125234501E+01, 7.2690190301E-01, 6.6126039107E-01, 5.6389239481E-01],
	[1.1160000000E+04, 1.3422253234E+01, 1.6123506524E+01, 7.2791852683E-01, 6.6211813326E-01, 5.6404044978E-01],
	[1.1165000000E+04, 1.3430245381E+01, 1.6121779506E+01, 7.2893611512E-01, 6.6297652643E-01, 5.6418848474E-01],
	[1.1170000000E+04, 1.3438238704E+01, 1.6120053446E+01, 7.2995466837E-01, 6.6383557059E-01, 5.6433649970E-01],
	[1.1175000000E+04, 1.3446233205E+01, 1.6118328344E+01, 7.3097418704E-01, 6.6469526575E-01, 5.6448449467E-01],
	[1.1180000000E+04, 1.3454228883E+01, 1.6116604197E+01, 7.3199467163E-01, 6.6555561193E-01, 5.6463246965E-01],
	[1.1185000000E+04, 1.3462225736E+01, 1.6114881006E+01, 7.3302272485E-01, 6.6642206615E-01, 5.6478042465E-01],
	[1.1190000000E+04, 1.3470223766E+01, 1.6113158768E+01, 7.3405218237E-01, 6.6728953064E-01, 5.6492835970E-01],
	[1.1195000000E+04, 1.3478222971E+01, 1.6111437485E+01, 7.3508262376E-01, 6.6815765745E-01, 5.6507627478E-01],
	[1.1200000000E+04, 1.3486223352E+01, 1.6109717153E+01, 7.3611404954E-01, 6.6902644657E-01, 5.6522416992E-01],
	[1.1205000000E+04, 1.3494224907E+01, 1.6107997773E+01, 7.3714646019E-01, 6.6989589803E-01, 5.6537204511E-01],
	[1.1210000000E+04, 1.3502227637E+01, 1.6106279343E+01, 7.3817985621E-01, 6.7076601184E-01, 5.6551990038E-01],
	[1.1215000000E+04, 1.3510231541E+01, 1.6104561863E+01, 7.3921423810E-01, 6.7163678801E-01, 5.6566773573E-01],
	[1.1220000000E+04, 1.3518236619E+01, 1.6102845332E+01, 7.4024960637E-01, 6.7250822654E-01, 5.6581555116E-01],
	[1.1225000000E+04, 1.3526242870E+01, 1.6101129748E+01, 7.4128596151E-01, 6.7338032745E-01, 5.6596334669E-01],
	[1.1230000000E+04, 1.3534250294E+01, 1.6099415111E+01, 7.4232330402E-01, 6.7425309075E-01, 5.6611112233E-01],
	[1.1235000000E+04, 1.3542258891E+01, 1.6097701419E+01, 7.4336163440E-01, 6.7512651644E-01, 5.6625887808E-01],
	[1.1240000000E+04, 1.3550268661E+01, 1.6095988672E+01, 7.4440095314E-01, 6.7600060454E-01, 5.6640661396E-01],
	[1.1245000000E+04, 1.3558279603E+01, 1.6094276869E+01, 7.4544126075E-01, 6.7687535505E-01, 5.6655432997E-01],
	[1.1250000000E+04, 1.3566291716E+01, 1.6092566009E+01, 7.4648255773E-01, 6.7775076799E-01, 5.6670202612E-01],
	[1.1255000000E+04, 1.3574305001E+01, 1.6090856091E+01, 7.4752484457E-01, 6.7862684335E-01, 5.6684970243E-01],
	[1.1260000000E+04, 1.3582319456E+01, 1.6089147114E+01, 7.4856812177E-01, 6.7950358115E-01, 5.6699735890E-01],
	[1.1265000000E+04, 1.3590335083E+01, 1.6087439077E+01, 7.4961238984E-01, 6.8038098139E-01, 5.6714499553E-01],
	[1.1270000000E+04, 1.3598351880E+01, 1.6085731979E+01, 7.5065764927E-01, 6.8125904408E-01, 5.6729261235E-01],
	[1.1275000000E+04, 1.3606369846E+01, 1.6084025820E+01, 7.5170390056E-01, 6.8213776923E-01, 5.6744020936E-01],
	[1.1280000000E+04, 1.3614388983E+01, 1.6082320597E+01, 7.5275114421E-01, 6.8301715683E-01, 5.6758778656E-01],
	[1.1285000000E+04, 1.3622409288E+01, 1.6080616311E+01, 7.5379938071E-01, 6.8389720690E-01, 5.6773534398E-01],
	[1.1290000000E+04, 1.3630430763E+01, 1.6078912961E+01, 7.5484861058E-01, 6.8477791944E-01, 5.6788288160E-01],
	[1.1295000000E+04, 1.3638464824E+01, 1.6077238985E+01, 7.5589883430E-01, 6.8565937503E-01, 5.6803039942E-01],
	[1.1300000000E+04, 1.3646500125E+01, 1.6075566082E+01, 7.5695005239E-01, 6.8654149391E-01, 5.6817789741E-01],
	[1.1305000000E+04, 1.3654536603E+01, 1.6073894092E+01, 7.5800226532E-01, 6.8742427562E-01, 5.6832537557E-01],
	[1.1310000000E+04, 1.3662574256E+01, 1.6072223016E+01, 7.5905547362E-01, 6.8830772018E-01, 5.6847283388E-01],
	[1.1315000000E+04, 1.3670613085E+01, 1.6070552852E+01, 7.6010967776E-01, 6.8919182758E-01, 5.6862027236E-01],
	[1.1320000000E+04, 1.3678653090E+01, 1.6068883600E+01, 7.6116487827E-01, 6.9007659783E-01, 5.6876769099E-01],
	[1.1325000000E+04, 1.3686694269E+01, 1.6067215258E+01, 7.6222107562E-01, 6.9096203092E-01, 5.6891508976E-01],
	[1.1330000000E+04, 1.3694736623E+01, 1.6065547825E+01, 7.6327827033E-01, 6.9184812687E-01, 5.6906246869E-01],
	[1.1335000000E+04, 1.3702780151E+01, 1.6063881301E+01, 7.6433646289E-01, 6.9273488567E-01, 5.6920982775E-01],
	[1.1340000000E+04, 1.3710824853E+01, 1.6062215684E+01, 7.6539565381E-01, 6.9362230732E-01, 5.6935716694E-01],
	[1.1345000000E+04, 1.3718870729E+01, 1.6060550975E+01, 7.6645584357E-01, 6.9451039182E-01, 5.6950448627E-01],
	[1.1350000000E+04, 1.3726917778E+01, 1.6058887171E+01, 7.6751703269E-01, 6.9539913918E-01, 5.6965178572E-01],
	[1.1355000000E+04, 1.3734965999E+01, 1.6057224273E+01, 7.6857922166E-01, 6.9628854939E-01, 5.6979906530E-01],
	[1.1360000000E+04, 1.3743015394E+01, 1.6055562279E+01, 7.6964241098E-01, 6.9717862245E-01, 5.6994632500E-01],
	[1.1365000000E+04, 1.3751065960E+01, 1.6053901187E+01, 7.7070660114E-01, 6.9806935836E-01, 5.7009356480E-01],
	[1.1370000000E+04, 1.3759117698E+01, 1.6052240999E+01, 7.7177179266E-01, 6.9896075712E-01, 5.7024078472E-01],
	[1.1375000000E+04, 1.3767170607E+01, 1.6050581711E+01, 7.7283798603E-01, 6.9985281873E-01, 5.7038798474E-01],
	[1.1380000000E+04, 1.3775224688E+01, 1.6048923325E+01, 7.7390518175E-01, 7.0074554318E-01, 5.7053516487E-01],
	[1.1385000000E+04, 1.3783279940E+01, 1.6047265838E+01, 7.7497338031E-01, 7.0163893046E-01, 5.7068232509E-01],
	[1.1390000000E+04, 1.3791336362E+01, 1.6045609250E+01, 7.7604258223E-01, 7.0253298059E-01, 5.7082946541E-01],
	[1.1395000000E+04, 1.3799393954E+01, 1.6043953560E+01, 7.7711278799E-01, 7.0342769355E-01, 5.7097658581E-01],
	[1.1400000000E+04, 1.3807452715E+01, 1.6042298766E+01, 7.7818399810E-01, 7.0432306933E-01, 5.7112368630E-01],
	[1.1405000000E+04, 1.3815512646E+01, 1.6040644870E+01, 7.7925621306E-01, 7.0521910794E-01, 5.7127076687E-01],
	[1.1410000000E+04, 1.3823573747E+01, 1.6038991868E+01, 7.8032943337E-01, 7.0611580936E-01, 5.7141782751E-01],
	[1.1415000000E+04, 1.3831636016E+01, 1.6037339761E+01, 7.8140365952E-01, 7.0701317360E-01, 5.7156486823E-01],
	[1.1420000000E+04, 1.3839699453E+01, 1.6035688547E+01, 7.8247889203E-01, 7.0791120064E-01, 5.7171188902E-01],
	[1.1425000000E+04, 1.3847764058E+01, 1.6034038226E+01, 7.8355513138E-01, 7.0880989048E-01, 5.7185888988E-01],
	[1.1430000000E+04, 1.3855829831E+01, 1.6032388797E+01, 7.8463237808E-01, 7.0970924311E-01, 5.7200587080E-01],
	[1.1435000000E+04, 1.3863896772E+01, 1.6030740259E+01, 7.8571063262E-01, 7.1060925853E-01, 5.7215283177E-01],
	[1.1440000000E+04, 1.3871964879E+01, 1.6029092611E+01, 7.8678989552E-01, 7.1150993672E-01, 5.7229977280E-01],
	[1.1445000000E+04, 1.3880034153E+01, 1.6027445852E+01, 7.8787016726E-01, 7.1241127768E-01, 5.7244669388E-01],
	[1.1450000000E+04, 1.3888104593E+01, 1.6025799982E+01, 7.8895144836E-01, 7.1331328139E-01, 5.7259359500E-01],
	[1.1455000000E+04, 1.3896176200E+01, 1.6024154999E+01, 7.9003373930E-01, 7.1421594786E-01, 5.7274047617E-01],
	[1.1460000000E+04, 1.3904248972E+01, 1.6022510902E+01, 7.9111704058E-01, 7.1511927706E-01, 5.7288733737E-01],
	[1.1465000000E+04, 1.3912322909E+01, 1.6020867692E+01, 7.9220135272E-01, 7.1602326899E-01, 5.7303417862E-01],
	[1.1470000000E+04, 1.3920398011E+01, 1.6019225366E+01, 7.9328667621E-01, 7.1692792364E-01, 5.7318099989E-01],
	[1.1475000000E+04, 1.3928481900E+01, 1.6017601665E+01, 7.9437301154E-01, 7.1783329687E-01, 5.7332780119E-01],
	[1.1480000000E+04, 1.3936571181E+01, 1.6015988654E+01, 7.9546035923E-01, 7.1873936404E-01, 5.7347458252E-01],
	[1.1485000000E+04, 1.3944661634E+01, 1.6014376508E+01, 7.9654871977E-01, 7.1964609427E-01, 5.7362134387E-01],
	[1.1490000000E+04, 1.3952753259E+01, 1.6012765226E+01, 7.9763809365E-01, 7.2055348754E-01, 5.7376808524E-01],
	[1.1495000000E+04, 1.3960846055E+01, 1.6011154807E+01, 7.9872848139E-01, 7.2146154385E-01, 5.7391480662E-01],
	[1.1500000000E+04, 1.3968940024E+01, 1.6009545250E+01, 7.9981988347E-01, 7.2237026319E-01, 5.7406150801E-01],
	[1.1505000000E+04, 1.3977035163E+01, 1.6007936555E+01, 8.0091230041E-01, 7.2327964553E-01, 5.7420818941E-01],
	[1.1510000000E+04, 1.3985131474E+01, 1.6006328720E+01, 8.0200573270E-01, 7.2418969087E-01, 5.7435485082E-01],
	[1.1515000000E+04, 1.3993228955E+01, 1.6004721745E+01, 8.0310018084E-01, 7.2510039919E-01, 5.7450149223E-01],
	[1.1520000000E+04, 1.4001327606E+01, 1.6003115628E+01, 8.0419564534E-01, 7.2601177048E-01, 5.7464811363E-01],
	[1.1525000000E+04, 1.4009427426E+01, 1.6001510370E+01, 8.0529212669E-01, 7.2692380473E-01, 5.7479471503E-01],
	[1.1530000000E+04, 1.4017528417E+01, 1.5999905969E+01, 8.0638962539E-01, 7.2783650191E-01, 5.7494129642E-01],
	[1.1535000000E+04, 1.4025630576E+01, 1.5998302424E+01, 8.0748814195E-01, 7.2874986201E-01, 5.7508785780E-01],
	[1.1540000000E+04, 1.4033733904E+01, 1.5996699734E+01, 8.0858767686E-01, 7.2966388503E-01, 5.7523439916E-01],
	[1.1545000000E+04, 1.4041838401E+01, 1.5995097900E+01, 8.0968823062E-01, 7.3057857093E-01, 5.7538092050E-01],
	[1.1550000000E+04, 1.4049944066E+01, 1.5993496919E+01, 8.1078980375E-01, 7.3149391971E-01, 5.7552742183E-01],
	[1.1555000000E+04, 1.4058050898E+01, 1.5991896791E+01, 8.1189239673E-01, 7.3240993134E-01, 5.7567390313E-01],
	[1.1560000000E+04, 1.4066158898E+01, 1.5990297516E+01, 8.1299601007E-01, 7.3332660581E-01, 5.7582036440E-01],
	[1.1565000000E+04, 1.4074268065E+01, 1.5988699092E+01, 8.1410064426E-01, 7.3424394310E-01, 5.7596680564E-01],
	[1.1570000000E+04, 1.4082378399E+01, 1.5987101518E+01, 8.1520629982E-01, 7.3516194319E-01, 5.7611322685E-01],
	[1.1575000000E+04, 1.4090489899E+01, 1.5985504795E+01, 8.1631297724E-01, 7.3608060606E-01, 5.7625962802E-01],
	[1.1580000000E+04, 1.4098602566E+01, 1.5983908920E+01, 8.1742067702E-01, 7.3699993170E-01, 5.7640600915E-01],
	[1.1585000000E+04, 1.4106716398E+01, 1.5982313893E+01, 8.1852939965E-01, 7.3791992008E-01, 5.7655237024E-01],
	[1.1590000000E+04, 1.4114831395E+01, 1.5980719714E+01, 8.1963914566E-01, 7.3884057118E-01, 5.7669871128E-01],
	[1.1595000000E+04, 1.4122947558E+01, 1.5979126381E+01, 8.2074991552E-01, 7.3976188498E-01, 5.7684503228E-01],
	[1.1600000000E+04, 1.4131064885E+01, 1.5977533894E+01, 8.2186170975E-01, 7.4068386146E-01, 5.7699133323E-01],
	[1.1605000000E+04, 1.4139183377E+01, 1.5975942252E+01, 8.2297452885E-01, 7.4160650060E-01, 5.7713761412E-01],
	[1.1610000000E+04, 1.4147303033E+01, 1.5974351454E+01, 8.2408837331E-01, 7.4252980237E-01, 5.7728387496E-01],
	[1.1615000000E+04, 1.4155423853E+01, 1.5972761499E+01, 8.2520324364E-01, 7.4345376676E-01, 5.7743011573E-01],
	[1.1620000000E+04, 1.4163545836E+01, 1.5971172386E+01, 8.2631914034E-01, 7.4437839374E-01, 5.7757633645E-01],
	[1.1625000000E+04, 1.4171668982E+01, 1.5969584116E+01, 8.2743606390E-01, 7.4530368328E-01, 5.7772253710E-01],
	[1.1630000000E+04, 1.4179793291E+01, 1.5967996686E+01, 8.2855401484E-01, 7.4622963536E-01, 5.7786871769E-01],
	[1.1635000000E+04, 1.4187918762E+01, 1.5966410096E+01, 8.2967299365E-01, 7.4715624996E-01, 5.7801487820E-01],
	[1.1640000000E+04, 1.4196045396E+01, 1.5964824345E+01, 8.3079300084E-01, 7.4808352706E-01, 5.7816101864E-01],
	[1.1645000000E+04, 1.4204173191E+01, 1.5963239433E+01, 8.3191403690E-01, 7.4901146662E-01, 5.7830713901E-01],
	[1.1650000000E+04, 1.4212302147E+01, 1.5961655358E+01, 8.3303610233E-01, 7.4994006862E-01, 5.7845323930E-01],
	[1.1655000000E+04, 1.4220432265E+01, 1.5960072120E+01, 8.3415919764E-01, 7.5086933304E-01, 5.7859931951E-01],
	[1.1660000000E+04, 1.4228572183E+01, 1.5958508509E+01, 8.3528332333E-01, 7.5179932567E-01, 5.7874537964E-01],
	[1.1665000000E+04, 1.4236716837E+01, 1.5956953483E+01, 8.3640847989E-01, 7.5273000819E-01, 5.7889141969E-01],
	[1.1670000000E+04, 1.4244862661E+01, 1.5955399275E+01, 8.3753466784E-01, 7.5366135343E-01, 5.7903743964E-01],
	[1.1675000000E+04, 1.4253009652E+01, 1.5953845883E+01, 8.3866188767E-01, 7.5459336138E-01, 5.7918343951E-01],
	[1.1680000000E+04, 1.4261157812E+01, 1.5952293308E+01, 8.3979013988E-01, 7.5552603200E-01, 5.7932941928E-01],
	[1.1685000000E+04, 1.4269307140E+01, 1.5950741549E+01, 8.4091942498E-01, 7.5645936527E-01, 5.7947537897E-01],
	[1.1690000000E+04, 1.4277457636E+01, 1.5949190604E+01, 8.4204974347E-01, 7.5739336115E-01, 5.7962131855E-01],
	[1.1695000000E+04, 1.4285609298E+01, 1.5947640473E+01, 8.4318109584E-01, 7.5832801962E-01, 5.7976723804E-01],
	[1.1700000000E+04, 1.4293762127E+01, 1.5946091155E+01, 8.4431348260E-01, 7.5926334065E-01, 5.7991313742E-01],
	[1.1705000000E+04, 1.4301916123E+01, 1.5944542650E+01, 8.4544690425E-01, 7.6019932420E-01, 5.8005901670E-01],
	[1.1710000000E+04, 1.4310071285E+01, 1.5942994956E+01, 8.4658136129E-01, 7.6113597026E-01, 5.8020487588E-01],
	[1.1715000000E+04, 1.4318227613E+01, 1.5941448073E+01, 8.4771685423E-01, 7.6207327878E-01, 5.8035071495E-01],
	[1.1720000000E+04, 1.4326385106E+01, 1.5939902000E+01, 8.4885338356E-01, 7.6301124974E-01, 5.8049653391E-01],
	[1.1725000000E+04, 1.4334543765E+01, 1.5938356736E+01, 8.4999094979E-01, 7.6394988310E-01, 5.8064233275E-01],
	[1.1730000000E+04, 1.4342703588E+01, 1.5936812281E+01, 8.5112955342E-01, 7.6488917884E-01, 5.8078811149E-01],
	[1.1735000000E+04, 1.4350864576E+01, 1.5935268634E+01, 8.5226919495E-01, 7.6582913692E-01, 5.8093387010E-01],
	[1.1740000000E+04, 1.4359026727E+01, 1.5933725793E+01, 8.5340987488E-01, 7.6676975730E-01, 5.8107960860E-01],
	[1.1745000000E+04, 1.4367190043E+01, 1.5932183759E+01, 8.5455159371E-01, 7.6771103996E-01, 5.8122532698E-01],
	[1.1750000000E+04, 1.4375354522E+01, 1.5930642531E+01, 8.5569435195E-01, 7.6865298486E-01, 5.8137102524E-01],
	[1.1755000000E+04, 1.4383520165E+01, 1.5929102107E+01, 8.5683815010E-01, 7.6959559197E-01, 5.8151670337E-01],
	[1.1760000000E+04, 1.4391686970E+01, 1.5927562487E+01, 8.5798298866E-01, 7.7053886125E-01, 5.8166236138E-01],
	[1.1765000000E+04, 1.4399854938E+01, 1.5926023670E+01, 8.5912886812E-01, 7.7148279266E-01, 5.8180799926E-01],
	[1.1770000000E+04, 1.4408024068E+01, 1.5924485655E+01, 8.6027578900E-01, 7.7242738618E-01, 5.8195361701E-01],
	[1.1775000000E+04, 1.4416194360E+01, 1.5922948443E+01, 8.6142375180E-01, 7.7337264176E-01, 5.8209921463E-01],
	[1.1780000000E+04, 1.4424365813E+01, 1.5921412031E+01, 8.6257275701E-01, 7.7431855936E-01, 5.8224479211E-01],
	[1.1785000000E+04, 1.4432538428E+01, 1.5919876419E+01, 8.6372280514E-01, 7.7526513896E-01, 5.8239034946E-01],
	[1.1790000000E+04, 1.4440712203E+01, 1.5918341607E+01, 8.6487389669E-01, 7.7621238052E-01, 5.8253588668E-01],
	[1.1795000000E+04, 1.4448887139E+01, 1.5916807593E+01, 8.6602603216E-01, 7.7716028399E-01, 5.8268140375E-01],
	[1.1800000000E+04, 1.4457063236E+01, 1.5915274377E+01, 8.6717921206E-01, 7.7810884934E-01, 5.8282690069E-01],
	[1.1805000000E+04, 1.4465240492E+01, 1.5913741958E+01, 8.6833343688E-01, 7.7905807652E-01, 5.8297237748E-01],
	[1.1810000000E+04, 1.4473418908E+01, 1.5912210336E+01, 8.6948870713E-01, 7.8000796551E-01, 5.8311783413E-01],
	[1.1815000000E+04, 1.4481598483E+01, 1.5910679509E+01, 8.7064502332E-01, 7.8095851626E-01, 5.8326327063E-01],
	[1.1820000000E+04, 1.4489779217E+01, 1.5909149478E+01, 8.7180238593E-01, 7.8190972873E-01, 5.8340868699E-01],
	[1.1825000000E+04, 1.4497961109E+01, 1.5907620240E+01, 8.7296079548E-01, 7.8286160288E-01, 5.8355408320E-01],
	[1.1830000000E+04, 1.4506144160E+01, 1.5906091796E+01, 8.7412025247E-01, 7.8381413867E-01, 5.8369945926E-01],
	[1.1835000000E+04, 1.4514328369E+01, 1.5904564144E+01, 8.7528075740E-01, 7.8476733606E-01, 5.8384481517E-01],
	[1.1840000000E+04, 1.4522513735E+01, 1.5903037284E+01, 8.7644231077E-01, 7.8572119500E-01, 5.8399015092E-01],
	[1.1845000000E+04, 1.4530702485E+01, 1.5901515744E+01, 8.7760491308E-01, 7.8667573307E-01, 5.8413546652E-01],
	[1.1850000000E+04, 1.4538902746E+01, 1.5900016038E+01, 8.7876856484E-01, 7.8763101471E-01, 5.8428076197E-01],
	[1.1855000000E+04, 1.4547104174E+01, 1.5898517107E+01, 8.7993326655E-01, 7.8858695820E-01, 5.8442603725E-01],
	[1.1860000000E+04, 1.4555306766E+01, 1.5897018949E+01, 8.8109901871E-01, 7.8954356348E-01, 5.8457129238E-01],
	[1.1865000000E+04, 1.4563510523E+01, 1.5895521563E+01, 8.8226582183E-01, 7.9050083051E-01, 5.8471652735E-01],
	[1.1870000000E+04, 1.4571715445E+01, 1.5894024949E+01, 8.8343367640E-01, 7.9145875926E-01, 5.8486174216E-01],
	[1.1875000000E+04, 1.4579921531E+01, 1.5892529106E+01, 8.8460258292E-01, 7.9241734967E-01, 5.8500693681E-01],
	[1.1880000000E+04, 1.4588128781E+01, 1.5891034034E+01, 8.8577254191E-01, 7.9337660171E-01, 5.8515211129E-01],
	[1.1885000000E+04, 1.4596337195E+01, 1.5889539731E+01, 8.8694355386E-01, 7.9433651533E-01, 5.8529726560E-01],
	[1.1890000000E+04, 1.4604546771E+01, 1.5888046198E+01, 8.8811561928E-01, 7.9529709048E-01, 5.8544239975E-01],
	[1.1895000000E+04, 1.4612757511E+01, 1.5886553432E+01, 8.8928873866E-01, 7.9625832711E-01, 5.8558751373E-01],
	[1.1900000000E+04, 1.4620969413E+01, 1.5885061434E+01, 8.9046291252E-01, 7.9722022519E-01, 5.8573260755E-01],
	[1.1905000000E+04, 1.4629182478E+01, 1.5883570203E+01, 8.9163814135E-01, 7.9818278466E-01, 5.8587768117E-01],
	[1.1910000000E+04, 1.4637396704E+01, 1.5882079738E+01, 8.9281442565E-01, 7.9914600548E-01, 5.8602273458E-01],
	[1.1915000000E+04, 1.4645612092E+01, 1.5880590038E+01, 8.9399176594E-01, 8.0010988760E-01, 5.8616776777E-01],
	[1.1920000000E+04, 1.4653828642E+01, 1.5879101103E+01, 8.9517016270E-01, 8.0107443097E-01, 5.8631278072E-01],
	[1.1925000000E+04, 1.4662046352E+01, 1.5877612932E+01, 8.9634961645E-01, 8.0203963554E-01, 5.8645777343E-01],
	[1.1930000000E+04, 1.4670265223E+01, 1.5876125524E+01, 8.9753012769E-01, 8.0300550127E-01, 5.8660274588E-01],
	[1.1935000000E+04, 1.4678485254E+01, 1.5874638878E+01, 8.9871169691E-01, 8.0397202810E-01, 5.8674769806E-01],
	[1.1940000000E+04, 1.4686706446E+01, 1.5873152995E+01, 8.9989432463E-01, 8.0493921599E-01, 5.8689262996E-01],
	[1.1945000000E+04, 1.4694928797E+01, 1.5871667872E+01, 9.0107801134E-01, 8.0590706489E-01, 5.8703754157E-01],
	[1.1950000000E+04, 1.4703152307E+01, 1.5870183510E+01, 9.0226275755E-01, 8.0687557474E-01, 5.8718243288E-01],
	[1.1955000000E+04, 1.4711376976E+01, 1.5868699907E+01, 9.0344856376E-01, 8.0784474549E-01, 5.8732730388E-01],
	[1.1960000000E+04, 1.4719602804E+01, 1.5867217064E+01, 9.0463543048E-01, 8.0881457710E-01, 5.8747215456E-01],
	[1.1965000000E+04, 1.4727829791E+01, 1.5865734979E+01, 9.0582335820E-01, 8.0978506951E-01, 5.8761698490E-01],
	[1.1970000000E+04, 1.4736057935E+01, 1.5864253651E+01, 9.0701234743E-01, 8.1075622266E-01, 5.8776179490E-01],
	[1.1975000000E+04, 1.4744287238E+01, 1.5862773080E+01, 9.0820239867E-01, 8.1172803651E-01, 5.8790658454E-01],
	[1.1980000000E+04, 1.4752517697E+01, 1.5861293265E+01, 9.0939351243E-01, 8.1270051101E-01, 5.8805135382E-01],
	[1.1985000000E+04, 1.4760749314E+01, 1.5859814206E+01, 9.1058568921E-01, 8.1367364609E-01, 5.8819610272E-01],
	[1.1990000000E+04, 1.4768982088E+01, 1.5858335902E+01, 9.1177892951E-01, 8.1464744170E-01, 5.8834083123E-01],
	[1.1995000000E+04, 1.4777216018E+01, 1.5856858351E+01, 9.1297323383E-01, 8.1562189780E-01, 5.8848553935E-01],
	[1.2000000000E+04, 1.4785451104E+01, 1.5855381554E+01, 9.1416860268E-01, 8.1659701432E-01, 5.8863022706E-01],
	[1.2005000000E+04, 1.4793687346E+01, 1.5853905510E+01, 9.1536503657E-01, 8.1757279120E-01, 5.8877489434E-01],
	[1.2010000000E+04, 1.4801924744E+01, 1.5852430217E+01, 9.1656253598E-01, 8.1854922840E-01, 5.8891954120E-01],
	[1.2015000000E+04, 1.4810163297E+01, 1.5850955676E+01, 9.1776110143E-01, 8.1952632586E-01, 5.8906416761E-01],
	[1.2020000000E+04, 1.4818403004E+01, 1.5849481886E+01, 9.1896073343E-01, 8.2050408352E-01, 5.8920877358E-01],
	[1.2025000000E+04, 1.4826643867E+01, 1.5848008845E+01, 9.2016143247E-01, 8.2148250132E-01, 5.8935335908E-01],
	[1.2030000000E+04, 1.4834885883E+01, 1.5846536553E+01, 9.2136319905E-01, 8.2246157920E-01, 5.8949792411E-01],
	[1.2035000000E+04, 1.4843129600E+01, 1.5845066050E+01, 9.2256603368E-01, 8.2344132161E-01, 5.8964246866E-01],
	[1.2040000000E+04, 1.4851386878E+01, 1.5843619882E+01, 9.2376993687E-01, 8.2442182609E-01, 5.8978699272E-01],
	[1.2045000000E+04, 1.4859645318E+01, 1.5842174446E+01, 9.2497490911E-01, 8.2540299092E-01, 5.8993149628E-01],
	[1.2050000000E+04, 1.4867904920E+01, 1.5840729743E+01, 9.2618095092E-01, 8.2638481604E-01, 5.9007597932E-01],
	[1.2055000000E+04, 1.4876165684E+01, 1.5839285770E+01, 9.2738806279E-01, 8.2736730137E-01, 5.9022044183E-01],
	[1.2060000000E+04, 1.4884427609E+01, 1.5837842528E+01, 9.2859624522E-01, 8.2835044687E-01, 5.9036488382E-01],
	[1.2065000000E+04, 1.4892690696E+01, 1.5836400015E+01, 9.2980549873E-01, 8.2933425247E-01, 5.9050930525E-01],
	[1.2070000000E+04, 1.4900954943E+01, 1.5834958231E+01, 9.3101582381E-01, 8.3031871812E-01, 5.9065370614E-01],
	[1.2075000000E+04, 1.4909220350E+01, 1.5833517176E+01, 9.3222722096E-01, 8.3130384374E-01, 5.9079808646E-01],
	[1.2080000000E+04, 1.4917486917E+01, 1.5832076848E+01, 9.3343969070E-01, 8.3228962929E-01, 5.9094244621E-01],
	[1.2085000000E+04, 1.4925754644E+01, 1.5830637248E+01, 9.3465323352E-01, 8.3327607470E-01, 5.9108678537E-01],
	[1.2090000000E+04, 1.4934023531E+01, 1.5829198373E+01, 9.3586784993E-01, 8.3426317991E-01, 5.9123110393E-01],
	[1.2095000000E+04, 1.4942293577E+01, 1.5827760224E+01, 9.3708354043E-01, 8.3525094485E-01, 5.9137540190E-01],
	[1.2100000000E+04, 1.4950564781E+01, 1.5826322801E+01, 9.3830030553E-01, 8.3623936947E-01, 5.9151967924E-01],
	[1.2105000000E+04, 1.4958837144E+01, 1.5824886101E+01, 9.3951814572E-01, 8.3722845369E-01, 5.9166393596E-01],
	[1.2110000000E+04, 1.4967110665E+01, 1.5823450125E+01, 9.4073706152E-01, 8.3821819746E-01, 5.9180817205E-01],
	[1.2115000000E+04, 1.4975385344E+01, 1.5822014872E+01, 9.4195705343E-01, 8.3920860071E-01, 5.9195238750E-01],
	[1.2120000000E+04, 1.4983661181E+01, 1.5820580342E+01, 9.4317812194E-01, 8.4019966337E-01, 5.9209658228E-01],
	[1.2125000000E+04, 1.4991938175E+01, 1.5819146533E+01, 9.4440026757E-01, 8.4119138539E-01, 5.9224075641E-01],
	[1.2130000000E+04, 1.5000216325E+01, 1.5817713445E+01, 9.4562349081E-01, 8.4218376669E-01, 5.9238490986E-01],
	[1.2135000000E+04, 1.5008495632E+01, 1.5816281078E+01, 9.4684779218E-01, 8.4317680722E-01, 5.9252904263E-01],
	[1.2140000000E+04, 1.5016776096E+01, 1.5814849430E+01, 9.4807317217E-01, 8.4417050689E-01, 5.9267315470E-01],
	[1.2145000000E+04, 1.5025057715E+01, 1.5813418501E+01, 9.4929963129E-01, 8.4516486565E-01, 5.9281724607E-01],
	[1.2150000000E+04, 1.5033340491E+01, 1.5811988290E+01, 9.5052717005E-01, 8.4615988343E-01, 5.9296131673E-01],
	[1.2155000000E+04, 1.5041624421E+01, 1.5810558798E+01, 9.5175578894E-01, 8.4715556016E-01, 5.9310536666E-01],
	[1.2160000000E+04, 1.5049909506E+01, 1.5809130022E+01, 9.5298548847E-01, 8.4815189578E-01, 5.9324939586E-01],
	[1.2165000000E+04, 1.5058195747E+01, 1.5807701963E+01, 9.5421626914E-01, 8.4914889021E-01, 5.9339340432E-01],
	[1.2170000000E+04, 1.5066483141E+01, 1.5806274619E+01, 9.5544813147E-01, 8.5014654338E-01, 5.9353739203E-01],
	[1.2175000000E+04, 1.5074771690E+01, 1.5804847991E+01, 9.5668107595E-01, 8.5114485523E-01, 5.9368135898E-01],
	[1.2180000000E+04, 1.5083061392E+01, 1.5803422077E+01, 9.5791510308E-01, 8.5214382568E-01, 5.9382530516E-01],
	[1.2185000000E+04, 1.5091352248E+01, 1.5801996877E+01, 9.5915021338E-01, 8.5314345467E-01, 5.9396923056E-01],
	[1.2190000000E+04, 1.5099644257E+01, 1.5800572390E+01, 9.6038640734E-01, 8.5414374212E-01, 5.9411313517E-01],
	[1.2195000000E+04, 1.5107937419E+01, 1.5799148615E+01, 9.6162368547E-01, 8.5514468796E-01, 5.9425701898E-01],
	[1.2200000000E+04, 1.5116231733E+01, 1.5797725553E+01, 9.6286204827E-01, 8.5614629213E-01, 5.9440088198E-01],
	[1.2205000000E+04, 1.5124527200E+01, 1.5796303201E+01, 9.6410149625E-01, 8.5714855454E-01, 5.9454472416E-01],
	[1.2210000000E+04, 1.5132823818E+01, 1.5794881560E+01, 9.6534202991E-01, 8.5815147513E-01, 5.9468854552E-01],
	[1.2215000000E+04, 1.5141121588E+01, 1.5793460629E+01, 9.6658364976E-01, 8.5915505383E-01, 5.9483234604E-01],
	[1.2220000000E+04, 1.5149420509E+01, 1.5792040408E+01, 9.6782635630E-01, 8.6015929055E-01, 5.9497612571E-01],
	[1.2225000000E+04, 1.5157720582E+01, 1.5790620895E+01, 9.6907015003E-01, 8.6116418522E-01, 5.9511988454E-01],
	[1.2230000000E+04, 1.5166025716E+01, 1.5789209048E+01, 9.7031503146E-01, 8.6216977117E-01, 5.9526362249E-01],
	[1.2235000000E+04, 1.5174341423E+01, 1.5787814656E+01, 9.7156100110E-01, 8.6317609561E-01, 5.9540733958E-01],
	[1.2240000000E+04, 1.5182658290E+01, 1.5786420956E+01, 9.7280805944E-01, 8.6418307823E-01, 5.9555103578E-01],
	[1.2245000000E+04, 1.5190976315E+01, 1.5785027949E+01, 9.7405620699E-01, 8.6519071896E-01, 5.9569471109E-01],
	[1.2250000000E+04, 1.5199295499E+01, 1.5783635633E+01, 9.7530544426E-01, 8.6619901772E-01, 5.9583836550E-01],
	[1.2255000000E+04, 1.5207615842E+01, 1.5782244007E+01, 9.7655577175E-01, 8.6720797443E-01, 5.9598199900E-01],
	[1.2260000000E+04, 1.5215937342E+01, 1.5780853073E+01, 9.7780718996E-01, 8.6821758902E-01, 5.9612561158E-01],
	[1.2265000000E+04, 1.5224260000E+01, 1.5779462827E+01, 9.7905969941E-01, 8.6922786142E-01, 5.9626920324E-01],
	[1.2270000000E+04, 1.5232583815E+01, 1.5778073271E+01, 9.8031330059E-01, 8.7023879155E-01, 5.9641277396E-01],
	[1.2275000000E+04, 1.5240908787E+01, 1.5776684404E+01, 9.8156799401E-01, 8.7125037932E-01, 5.9655632373E-01],
	[1.2280000000E+04, 1.5249234916E+01, 1.5775296224E+01, 9.8282378017E-01, 8.7226262466E-01, 5.9669985255E-01],
	[1.2285000000E+04, 1.5257562201E+01, 1.5773908731E+01, 9.8408065958E-01, 8.7327552750E-01, 5.9684336041E-01],
	[1.2290000000E+04, 1.5265890642E+01, 1.5772521925E+01, 9.8533863274E-01, 8.7428908775E-01, 5.9698684729E-01],
	[1.2295000000E+04, 1.5274220239E+01, 1.5771135804E+01, 9.8659770016E-01, 8.7530330534E-01, 5.9713031319E-01],
	[1.2300000000E+04, 1.5282550992E+01, 1.5769750370E+01, 9.8785786234E-01, 8.7631818018E-01, 5.9727375811E-01],
	[1.2305000000E+04, 1.5290882899E+01, 1.5768365619E+01, 9.8911911978E-01, 8.7733371219E-01, 5.9741718202E-01],
	[1.2310000000E+04, 1.5299215962E+01, 1.5766981553E+01, 9.9038147300E-01, 8.7834990131E-01, 5.9756058493E-01],
	[1.2315000000E+04, 1.5307550179E+01, 1.5765598170E+01, 9.9164492249E-01, 8.7936674743E-01, 5.9770396682E-01],
	[1.2320000000E+04, 1.5315885550E+01, 1.5764215471E+01, 9.9290946877E-01, 8.8038425049E-01, 5.9784732769E-01],
	[1.2325000000E+04, 1.5324222075E+01, 1.5762833453E+01, 9.9417511233E-01, 8.8140241040E-01, 5.9799066753E-01],
	[1.2330000000E+04, 1.5332559753E+01, 1.5761452117E+01, 9.9544185368E-01, 8.8242122707E-01, 5.9813398632E-01],
	[1.2335000000E+04, 1.5340898585E+01, 1.5760071462E+01, 9.9670969332E-01, 8.8344070043E-01, 5.9827728407E-01],
	[1.2340000000E+04, 1.5349238570E+01, 1.5758691488E+01, 9.9797863177E-01, 8.8446083040E-01, 5.9842056075E-01],
	[1.2345000000E+04, 1.5357579707E+01, 1.5757312193E+01, 9.9924866952E-01, 8.8548161688E-01, 5.9856381637E-01],
	[1.2350000000E+04, 1.5365921997E+01, 1.5755933577E+01, 1.0005198071E+00, 8.8650305980E-01, 5.9870705091E-01],
	[1.2355000000E+04, 1.5374265439E+01, 1.5754555640E+01, 1.0017920450E+00, 8.8752515907E-01, 5.9885026437E-01],
	[1.2360000000E+04, 1.5382610033E+01, 1.5753178381E+01, 1.0030653836E+00, 8.8854791461E-01, 5.9899345673E-01],
	[1.2365000000E+04, 1.5390955778E+01, 1.5751801800E+01, 1.0043398237E+00, 8.8957132632E-01, 5.9913662799E-01],
	[1.2370000000E+04, 1.5399302674E+01, 1.5750425895E+01, 1.0056153655E+00, 8.9059539413E-01, 5.9927977815E-01],
	[1.2375000000E+04, 1.5407650721E+01, 1.5749050666E+01, 1.0068920097E+00, 8.9162011795E-01, 5.9942290718E-01],
	[1.2380000000E+04, 1.5415999919E+01, 1.5747676113E+01, 1.0081697567E+00, 8.9264549769E-01, 5.9956601509E-01],
	[1.2385000000E+04, 1.5424350266E+01, 1.5746302234E+01, 1.0094486071E+00, 8.9367153326E-01, 5.9970910187E-01],
	[1.2390000000E+04, 1.5432701764E+01, 1.5744929030E+01, 1.0107285613E+00, 8.9469822458E-01, 5.9985216750E-01],
	[1.2395000000E+04, 1.5441054411E+01, 1.5743556500E+01, 1.0120096199E+00, 8.9572557156E-01, 5.9999521198E-01],
	[1.2400000000E+04, 1.5449408208E+01, 1.5742184643E+01, 1.0132917833E+00, 8.9675357411E-01, 6.0013823530E-01],
	[1.2405000000E+04, 1.5457763153E+01, 1.5740813459E+01, 1.0145750521E+00, 8.9778223214E-01, 6.0028123745E-01],
	[1.2410000000E+04, 1.5466119248E+01, 1.5739442946E+01, 1.0158594268E+00, 8.9881154557E-01, 6.0042421843E-01],
	[1.2415000000E+04, 1.5474476490E+01, 1.5738073105E+01, 1.0171449079E+00, 8.9984151429E-01, 6.0056717823E-01],
	[1.2420000000E+04, 1.5482834881E+01, 1.5736703934E+01, 1.0184314958E+00, 9.0087213823E-01, 6.0071011683E-01],
	[1.2425000000E+04, 1.5491194419E+01, 1.5735335433E+01, 1.0197191911E+00, 9.0190341730E-01, 6.0085303423E-01],
	[1.2430000000E+04, 1.5499567759E+01, 1.5733988631E+01, 1.0210079943E+00, 9.0293546358E-01, 6.0099593042E-01],
	[1.2435000000E+04, 1.5507943341E+01, 1.5732644291E+01, 1.0222979059E+00, 9.0396817490E-01, 6.0113880540E-01],
	[1.2440000000E+04, 1.5516320080E+01, 1.5731300606E+01, 1.0235889264E+00, 9.0500154154E-01, 6.0128165916E-01],
	[1.2445000000E+04, 1.5524697975E+01, 1.5729957576E+01, 1.0248810564E+00, 9.0603556340E-01, 6.0142449168E-01],
	[1.2450000000E+04, 1.5533077025E+01, 1.5728615200E+01, 1.0261742962E+00, 9.0707024040E-01, 6.0156730296E-01],
	[1.2455000000E+04, 1.5541457230E+01, 1.5727273477E+01, 1.0274686464E+00, 9.0810557245E-01, 6.0171009300E-01],
	[1.2460000000E+04, 1.5549838590E+01, 1.5725932408E+01, 1.0287641076E+00, 9.0914155945E-01, 6.0185286178E-01],
	[1.2465000000E+04, 1.5558221105E+01, 1.5724591990E+01, 1.0300606802E+00, 9.1017820130E-01, 6.0199560929E-01],
	[1.2470000000E+04, 1.5566604775E+01, 1.5723252225E+01, 1.0313583648E+00, 9.1121549792E-01, 6.0213833554E-01],
	[1.2475000000E+04, 1.5574989598E+01, 1.5721913110E+01, 1.0326571618E+00, 9.1225344921E-01, 6.0228104050E-01],
	[1.2480000000E+04, 1.5583375575E+01, 1.5720574647E+01, 1.0339570717E+00, 9.1329205508E-01, 6.0242372418E-01],
	[1.2485000000E+04, 1.5591762705E+01, 1.5719236833E+01, 1.0352580951E+00, 9.1433131543E-01, 6.0256638667E-01],
	[1.2490000000E+04, 1.5600150989E+01, 1.5717899668E+01, 1.0365602324E+00, 9.1537123016E-01, 6.0270902810E-01],
	[1.2495000000E+04, 1.5608540425E+01, 1.5716563153E+01, 1.0378634842E+00, 9.1641179919E-01, 6.0285164846E-01],
	[1.2500000000E+04, 1.5616931014E+01, 1.5715227286E+01, 1.0391678510E+00, 9.1745302240E-01, 6.0299424773E-01],
	[1.2505000000E+04, 1.5625322755E+01, 1.5713892066E+01, 1.0404756084E+00, 9.1849667271E-01, 6.0313682589E-01],
	[1.2510000000E+04, 1.5633715648E+01, 1.5712557494E+01, 1.0417844868E+00, 9.1954098002E-01, 6.0327938294E-01],
	[1.2515000000E+04, 1.5642109693E+01, 1.5711223568E+01, 1.0430944866E+00, 9.2058594424E-01, 6.0342191885E-01],
	[1.2520000000E+04, 1.5650504889E+01, 1.5709890288E+01, 1.0444056084E+00, 9.2163156528E-01, 6.0356443362E-01],
	[1.2525000000E+04, 1.5658901236E+01, 1.5708557654E+01, 1.0457178526E+00, 9.2267784304E-01, 6.0370692723E-01],
	[1.2530000000E+04, 1.5667298733E+01, 1.5707225665E+01, 1.0470312199E+00, 9.2372477741E-01, 6.0384939966E-01],
	[1.2535000000E+04, 1.5675697381E+01, 1.5705894319E+01, 1.0483457106E+00, 9.2477236830E-01, 6.0399185091E-01],
	[1.2540000000E+04, 1.5684097179E+01, 1.5704563618E+01, 1.0496613253E+00, 9.2582061562E-01, 6.0413428095E-01],
	[1.2545000000E+04, 1.5692498127E+01, 1.5703233560E+01, 1.0509780646E+00, 9.2686951925E-01, 6.0427668977E-01],
	[1.2550000000E+04, 1.5700900224E+01, 1.5701904144E+01, 1.0522959289E+00, 9.2791907911E-01, 6.0441907737E-01],
	[1.2555000000E+04, 1.5709303471E+01, 1.5700575370E+01, 1.0536149187E+00, 9.2896929509E-01, 6.0456144372E-01],
	[1.2560000000E+04, 1.5717707866E+01, 1.5699247238E+01, 1.0549350346E+00, 9.3002016708E-01, 6.0470378881E-01],
	[1.2565000000E+04, 1.5726113410E+01, 1.5697919747E+01, 1.0562562770E+00, 9.3107169500E-01, 6.0484611263E-01],
	[1.2570000000E+04, 1.5734520103E+01, 1.5696592895E+01, 1.0575786465E+00, 9.3212387874E-01, 6.0498841516E-01],
	[1.2575000000E+04, 1.5742927943E+01, 1.5695266684E+01, 1.0589021436E+00, 9.3317671819E-01, 6.0513069639E-01],
	[1.2580000000E+04, 1.5751336931E+01, 1.5693941112E+01, 1.0602267688E+00, 9.3423021325E-01, 6.0527295631E-01],
	[1.2585000000E+04, 1.5759747066E+01, 1.5692616179E+01, 1.0615525226E+00, 9.3528436382E-01, 6.0541519490E-01],
	[1.2590000000E+04, 1.5768158349E+01, 1.5691291883E+01, 1.0628794055E+00, 9.3633916980E-01, 6.0555741215E-01],
	[1.2595000000E+04, 1.5776570778E+01, 1.5689968226E+01, 1.0642074180E+00, 9.3739463108E-01, 6.0569960804E-01],
	[1.2600000000E+04, 1.5784984354E+01, 1.5688645205E+01, 1.0655365607E+00, 9.3845074756E-01, 6.0584178256E-01],
	[1.2605000000E+04, 1.5793399076E+01, 1.5687322820E+01, 1.0668668340E+00, 9.3950751913E-01, 6.0598393570E-01],
	[1.2610000000E+04, 1.5801814944E+01, 1.5686001072E+01, 1.0681982385E+00, 9.4056494569E-01, 6.0612606744E-01],
	[1.2615000000E+04, 1.5810231957E+01, 1.5684679958E+01, 1.0695307746E+00, 9.4162302713E-01, 6.0626817778E-01],
	[1.2620000000E+04, 1.5818650116E+01, 1.5683359480E+01, 1.0708644430E+00, 9.4268176335E-01, 6.0641026669E-01],
	[1.2625000000E+04, 1.5827069420E+01, 1.5682039635E+01, 1.0721992440E+00, 9.4374115424E-01, 6.0655233416E-01],
	[1.2630000000E+04, 1.5835503150E+01, 1.5680740725E+01, 1.0735351783E+00, 9.4480132067E-01, 6.0669438018E-01],
	[1.2635000000E+04, 1.5843939275E+01, 1.5679444333E+01, 1.0748722462E+00, 9.4586215334E-01, 6.0683640474E-01],
	[1.2640000000E+04, 1.5852376554E+01, 1.5678148561E+01, 1.0762104484E+00, 9.4692364086E-01, 6.0697840782E-01],
	[1.2645000000E+04, 1.5860814987E+01, 1.5676853409E+01, 1.0775497854E+00, 9.4798578312E-01, 6.0712038941E-01],
	[1.2650000000E+04, 1.5869254572E+01, 1.5675558876E+01, 1.0788902576E+00, 9.4904858001E-01, 6.0726234950E-01],
	[1.2655000000E+04, 1.5877695311E+01, 1.5674264961E+01, 1.0802318655E+00, 9.5011203144E-01, 6.0740428807E-01],
	[1.2660000000E+04, 1.5886137202E+01, 1.5672971664E+01, 1.0815746097E+00, 9.5117613727E-01, 6.0754620510E-01],
	[1.2665000000E+04, 1.5894580246E+01, 1.5671678984E+01, 1.0829184908E+00, 9.5224089742E-01, 6.0768810060E-01],
	[1.2670000000E+04, 1.5903024442E+01, 1.5670386921E+01, 1.0842635091E+00, 9.5330631177E-01, 6.0782997453E-01],
	[1.2675000000E+04, 1.5911469789E+01, 1.5669095475E+01, 1.0856096652E+00, 9.5437238020E-01, 6.0797182690E-01],
	[1.2680000000E+04, 1.5919916288E+01, 1.5667804644E+01, 1.0869569597E+00, 9.5543910262E-01, 6.0811365768E-01],
	[1.2685000000E+04, 1.5928363938E+01, 1.5666514428E+01, 1.0883053930E+00, 9.5650647890E-01, 6.0825546686E-01],
	[1.2690000000E+04, 1.5936812738E+01, 1.5665224827E+01, 1.0896549656E+00, 9.5757450894E-01, 6.0839725443E-01],
	[1.2695000000E+04, 1.5945262690E+01, 1.5663935840E+01, 1.0910056781E+00, 9.5864319263E-01, 6.0853902038E-01],
	[1.2700000000E+04, 1.5953713791E+01, 1.5662647466E+01, 1.0923575310E+00, 9.5971252985E-01, 6.0868076470E-01],
	[1.2705000000E+04, 1.5962166043E+01, 1.5661359706E+01, 1.0937105248E+00, 9.6078252049E-01, 6.0882248736E-01],
	[1.2710000000E+04, 1.5970619444E+01, 1.5660072558E+01, 1.0950646599E+00, 9.6185316443E-01, 6.0896418836E-01],
	[1.2715000000E+04, 1.5979073995E+01, 1.5658786022E+01, 1.0964199370E+00, 9.6292446158E-01, 6.0910586769E-01],
	[1.2720000000E+04, 1.5987529694E+01, 1.5657500098E+01, 1.0977763564E+00, 9.6399641180E-01, 6.0924752533E-01],
	[1.2725000000E+04, 1.5995986543E+01, 1.5656214784E+01, 1.0991339188E+00, 9.6506901499E-01, 6.0938916126E-01],
	[1.2730000000E+04, 1.6004444539E+01, 1.5654930081E+01, 1.1004926247E+00, 9.6614227103E-01, 6.0953077549E-01],
	[1.2735000000E+04, 1.6012903684E+01, 1.5653645988E+01, 1.1018524745E+00, 9.6721617981E-01, 6.0967236798E-01],
	[1.2740000000E+04, 1.6021363977E+01, 1.5652362504E+01, 1.1032134688E+00, 9.6829074121E-01, 6.0981393874E-01],
	[1.2745000000E+04, 1.6029825418E+01, 1.5651079629E+01, 1.1045756080E+00, 9.6936595511E-01, 6.0995548774E-01],
	[1.2750000000E+04, 1.6038288005E+01, 1.5649797362E+01, 1.1059388927E+00, 9.7044182141E-01, 6.1009701498E-01],
	[1.2755000000E+04, 1.6046751740E+01, 1.5648515703E+01, 1.1073033235E+00, 9.7151833997E-01, 6.1023852044E-01],
	[1.2760000000E+04, 1.6055216622E+01, 1.5647234651E+01, 1.1086689007E+00, 9.7259551069E-01, 6.1038000411E-01],
	[1.2765000000E+04, 1.6063682649E+01, 1.5645954206E+01, 1.1100356250E+00, 9.7367333345E-01, 6.1052146598E-01],
	[1.2770000000E+04, 1.6072149823E+01, 1.5644674367E+01, 1.1114034968E+00, 9.7475180812E-01, 6.1066290603E-01],
	[1.2775000000E+04, 1.6080618143E+01, 1.5643395133E+01, 1.1127725167E+00, 9.7583093460E-01, 6.1080432425E-01],
	[1.2780000000E+04, 1.6089087608E+01, 1.5642116505E+01, 1.1141426851E+00, 9.7691071276E-01, 6.1094572063E-01],
	[1.2785000000E+04, 1.6097558219E+01, 1.5640838481E+01, 1.1155140026E+00, 9.7799114248E-01, 6.1108709515E-01],
	[1.2790000000E+04, 1.6106029974E+01, 1.5639561061E+01, 1.1168864697E+00, 9.7907222364E-01, 6.1122844781E-01],
	[1.2795000000E+04, 1.6114502875E+01, 1.5638284245E+01, 1.1182600869E+00, 9.8015395612E-01, 6.1136977860E-01],
	[1.2800000000E+04, 1.6122976919E+01, 1.5637008032E+01, 1.1196348548E+00, 9.8123633980E-01, 6.1151108749E-01],
	[1.2805000000E+04, 1.6131452108E+01, 1.5635732422E+01, 1.1210107737E+00, 9.8231937457E-01, 6.1165237447E-01],
	[1.2810000000E+04, 1.6139928440E+01, 1.5634457413E+01, 1.1223878443E+00, 9.8340306029E-01, 6.1179363954E-01],
	[1.2815000000E+04, 1.6148405916E+01, 1.5633183006E+01, 1.1237660670E+00, 9.8448739684E-01, 6.1193488269E-01],
	[1.2820000000E+04, 1.6156884535E+01, 1.5631909200E+01, 1.1251454424E+00, 9.8557238411E-01, 6.1207610389E-01],
	[1.2825000000E+04, 1.6165364296E+01, 1.5630635994E+01, 1.1265259709E+00, 9.8665802197E-01, 6.1221730314E-01],
	[1.2830000000E+04, 1.6173849315E+01, 1.5629369128E+01, 1.1279076532E+00, 9.8774434856E-01, 6.1235848042E-01],
	[1.2835000000E+04, 1.6182346946E+01, 1.5628118846E+01, 1.1292904896E+00, 9.8883143246E-01, 6.1249963573E-01],
	[1.2840000000E+04, 1.6190845729E+01, 1.5626869152E+01, 1.1306744808E+00, 9.8991916712E-01, 6.1264076904E-01],
	[1.2845000000E+04, 1.6199345665E+01, 1.5625620044E+01, 1.1320596272E+00, 9.9100755241E-01, 6.1278188036E-01],
	[1.2850000000E+04, 1.6207846752E+01, 1.5624371522E+01, 1.1334459293E+00, 9.9209658821E-01, 6.1292296966E-01],
	[1.2855000000E+04, 1.6216348991E+01, 1.5623123585E+01, 1.1348333877E+00, 9.9318627439E-01, 6.1306403693E-01],
	[1.2860000000E+04, 1.6224852380E+01, 1.5621876234E+01, 1.1362220028E+00, 9.9427661082E-01, 6.1320508217E-01],
	[1.2865000000E+04, 1.6233356921E+01, 1.5620629466E+01, 1.1376117752E+00, 9.9536759739E-01, 6.1334610535E-01],
	[1.2870000000E+04, 1.6241862612E+01, 1.5619383283E+01, 1.1390027054E+00, 9.9645923396E-01, 6.1348710647E-01],
	[1.2875000000E+04, 1.6250369453E+01, 1.5618137683E+01, 1.1403947940E+00, 9.9755152042E-01, 6.1362808552E-01],
	[1.2880000000E+04, 1.6258877445E+01, 1.5616892666E+01, 1.1417880413E+00, 9.9864445662E-01, 6.1376904248E-01],
	[1.2885000000E+04, 1.6267386586E+01, 1.5615648231E+01, 1.1431824479E+00, 9.9973804245E-01, 6.1390997735E-01],
	[1.2890000000E+04, 1.6275896876E+01, 1.5614404378E+01, 1.1445780144E+00, 1.0008322778E+00, 6.1405089010E-01],
	[1.2895000000E+04, 1.6284408316E+01, 1.5613161107E+01, 1.1459747412E+00, 1.0019271625E+00, 6.1419178073E-01],
	[1.2900000000E+04, 1.6292920904E+01, 1.5611918417E+01, 1.1473726290E+00, 1.0030226964E+00, 6.1433264923E-01],
	[1.2905000000E+04, 1.6301434641E+01, 1.5610676307E+01, 1.1487716780E+00, 1.0041188795E+00, 6.1447349558E-01],
	[1.2910000000E+04, 1.6309949526E+01, 1.5609434777E+01, 1.1501718890E+00, 1.0052157115E+00, 6.1461431978E-01],
	[1.2915000000E+04, 1.6318465559E+01, 1.5608193826E+01, 1.1515732624E+00, 1.0063131924E+00, 6.1475512180E-01],
	[1.2920000000E+04, 1.6326982739E+01, 1.5606953454E+01, 1.1529757987E+00, 1.0074113220E+00, 6.1489590164E-01],
	[1.2925000000E+04, 1.6335501067E+01, 1.5605713661E+01, 1.1543794984E+00, 1.0085101002E+00, 6.1503665929E-01],
	[1.2930000000E+04, 1.6344020542E+01, 1.5604474446E+01, 1.1557843621E+00, 1.0096095269E+00, 6.1517739474E-01],
	[1.2935000000E+04, 1.6352541164E+01, 1.5603235808E+01, 1.1571903902E+00, 1.0107096019E+00, 6.1531810797E-01],
	[1.2940000000E+04, 1.6361062932E+01, 1.5601997747E+01, 1.1585975833E+00, 1.0118103251E+00, 6.1545879897E-01],
	[1.2945000000E+04, 1.6369585847E+01, 1.5600760262E+01, 1.1600059419E+00, 1.0129116964E+00, 6.1559946773E-01],
	[1.2950000000E+04, 1.6378109907E+01, 1.5599523354E+01, 1.1614154665E+00, 1.0140137156E+00, 6.1574011424E-01],
	[1.2955000000E+04, 1.6386635113E+01, 1.5598287021E+01, 1.1628261575E+00, 1.0151163826E+00, 6.1588073849E-01],
	[1.2960000000E+04, 1.6395161464E+01, 1.5597051263E+01, 1.1642380157E+00, 1.0162196973E+00, 6.1602134047E-01],
	[1.2965000000E+04, 1.6403688961E+01, 1.5595816080E+01, 1.1656510413E+00, 1.0173236595E+00, 6.1616192016E-01],
	[1.2970000000E+04, 1.6412217602E+01, 1.5594581470E+01, 1.1670652350E+00, 1.0184282691E+00, 6.1630247755E-01],
	[1.2975000000E+04, 1.6420747387E+01, 1.5593347434E+01, 1.1684805972E+00, 1.0195335260E+00, 6.1644301263E-01],
	[1.2980000000E+04, 1.6429278317E+01, 1.5592113972E+01, 1.1698971286E+00, 1.0206394300E+00, 6.1658352540E-01],
	[1.2985000000E+04, 1.6437810391E+01, 1.5590881081E+01, 1.1713148295E+00, 1.0217459809E+00, 6.1672401583E-01],
	[1.2990000000E+04, 1.6446343608E+01, 1.5589648763E+01, 1.1727337005E+00, 1.0228531788E+00, 6.1686448392E-01],
	[1.2995000000E+04, 1.6454877968E+01, 1.5588417016E+01, 1.1741537421E+00, 1.0239610234E+00, 6.1700492965E-01],
	[1.3000000000E+04, 1.6463413472E+01, 1.5587185841E+01, 1.1755749549E+00, 1.0250695145E+00, 6.1714535303E-01],
	[1.3005000000E+04, 1.6471950118E+01, 1.5585955236E+01, 1.1769973393E+00, 1.0261786521E+00, 6.1728575402E-01],
	[1.3010000000E+04, 1.6480487907E+01, 1.5584725201E+01, 1.1784208959E+00, 1.0272884360E+00, 6.1742613263E-01],
	[1.3015000000E+04, 1.6489026838E+01, 1.5583495736E+01, 1.1798456251E+00, 1.0283988661E+00, 6.1756648883E-01],
	[1.3020000000E+04, 1.6497566911E+01, 1.5582266840E+01, 1.1812715275E+00, 1.0295099422E+00, 6.1770682263E-01],
	[1.3025000000E+04, 1.6506108125E+01, 1.5581038513E+01, 1.1826986036E+00, 1.0306216642E+00, 6.1784713401E-01],
	[1.3030000000E+04, 1.6514650481E+01, 1.5579810754E+01, 1.1841268539E+00, 1.0317340320E+00, 6.1798742295E-01],
	[1.3035000000E+04, 1.6523193978E+01, 1.5578583563E+01, 1.1855562790E+00, 1.0328470453E+00, 6.1812768946E-01],
	[1.3040000000E+04, 1.6531754594E+01, 1.5577377345E+01, 1.1869868793E+00, 1.0339608566E+00, 6.1826793353E-01],
	[1.3045000000E+04, 1.6540317040E+01, 1.5576172550E+01, 1.1884186553E+00, 1.0350753202E+00, 6.1840815520E-01],
	[1.3050000000E+04, 1.6548880637E+01, 1.5574968309E+01, 1.1898516076E+00, 1.0361904296E+00, 6.1854835443E-01],
	[1.3055000000E+04, 1.6557445385E+01, 1.5573764623E+01, 1.1912857367E+00, 1.0373061846E+00, 6.1868853122E-01],
	[1.3060000000E+04, 1.6566011283E+01, 1.5572561492E+01, 1.1927210430E+00, 1.0384225850E+00, 6.1882868554E-01],
	[1.3065000000E+04, 1.6574578332E+01, 1.5571358913E+01, 1.1941575272E+00, 1.0395396308E+00, 6.1896881737E-01],
	[1.3070000000E+04, 1.6583146530E+01, 1.5570156887E+01, 1.1955951897E+00, 1.0406573219E+00, 6.1910892669E-01],
	[1.3075000000E+04, 1.6591715878E+01, 1.5568955414E+01, 1.1970340310E+00, 1.0417756579E+00, 6.1924901349E-01],
	[1.3080000000E+04, 1.6600286375E+01, 1.5567754493E+01, 1.1984740517E+00, 1.0428946389E+00, 6.1938907774E-01],
	[1.3085000000E+04, 1.6608858022E+01, 1.5566554124E+01, 1.1999152522E+00, 1.0440142646E+00, 6.1952911943E-01],
	[1.3090000000E+04, 1.6617430817E+01, 1.5565354305E+01, 1.2013576331E+00, 1.0451345350E+00, 6.1966913853E-01],
	[1.3095000000E+04, 1.6626004760E+01, 1.5564155038E+01, 1.2028011949E+00, 1.0462554499E+00, 6.1980913502E-01],
	[1.3100000000E+04, 1.6634579852E+01, 1.5562956320E+01, 1.2042459381E+00, 1.0473770090E+00, 6.1994910890E-01],
	[1.3105000000E+04, 1.6643156091E+01, 1.5561758152E+01, 1.2056918632E+00, 1.0484992124E+00, 6.2008906013E-01],
	[1.3110000000E+04, 1.6651733478E+01, 1.5560560533E+01, 1.2071389708E+00, 1.0496220598E+00, 6.2022898870E-01],
	[1.3115000000E+04, 1.6660312013E+01, 1.5559363464E+01, 1.2085872613E+00, 1.0507455512E+00, 6.2036889459E-01],
	[1.3120000000E+04, 1.6668891694E+01, 1.5558166942E+01, 1.2100367352E+00, 1.0518696863E+00, 6.2050877778E-01],
	[1.3125000000E+04, 1.6677472522E+01, 1.5556970968E+01, 1.2114873932E+00, 1.0529944649E+00, 6.2064863825E-01],
	[1.3130000000E+04, 1.6686054497E+01, 1.5555775542E+01, 1.2129392356E+00, 1.0541198871E+00, 6.2078847599E-01],
	[1.3135000000E+04, 1.6694637618E+01, 1.5554580663E+01, 1.2143922630E+00, 1.0552459525E+00, 6.2092829096E-01],
	[1.3140000000E+04, 1.6703221884E+01, 1.5553386330E+01, 1.2158464759E+00, 1.0563726612E+00, 6.2106808317E-01],
	[1.3145000000E+04, 1.6711807297E+01, 1.5552192543E+01, 1.2173018749E+00, 1.0575000128E+00, 6.2120785257E-01],
	[1.3150000000E+04, 1.6720393854E+01, 1.5550999302E+01, 1.2187584604E+00, 1.0586280073E+00, 6.2134759917E-01],
	[1.3155000000E+04, 1.6728981557E+01, 1.5549806606E+01, 1.2202162329E+00, 1.0597566445E+00, 6.2148732293E-01],
	[1.3160000000E+04, 1.6737570405E+01, 1.5548614454E+01, 1.2216751930E+00, 1.0608859243E+00, 6.2162702384E-01],
	[1.3165000000E+04, 1.6746160396E+01, 1.5547422847E+01, 1.2231353413E+00, 1.0620158466E+00, 6.2176670188E-01],
	[1.3170000000E+04, 1.6754751533E+01, 1.5546231784E+01, 1.2245966781E+00, 1.0631464110E+00, 6.2190635703E-01],
	[1.3175000000E+04, 1.6763343813E+01, 1.5545041263E+01, 1.2260592040E+00, 1.0642776176E+00, 6.2204598927E-01],
	[1.3180000000E+04, 1.6771937236E+01, 1.5543851286E+01, 1.2275229196E+00, 1.0654094662E+00, 6.2218559859E-01],
	[1.3185000000E+04, 1.6780531803E+01, 1.5542661851E+01, 1.2289878253E+00, 1.0665419566E+00, 6.2232518496E-01],
	[1.3190000000E+04, 1.6789127513E+01, 1.5541472958E+01, 1.2304539216E+00, 1.0676750886E+00, 6.2246474838E-01],
	[1.3195000000E+04, 1.6797724366E+01, 1.5540284607E+01, 1.2319212092E+00, 1.0688088622E+00, 6.2260428880E-01],
	[1.3200000000E+04, 1.6806322362E+01, 1.5539096796E+01, 1.2333896884E+00, 1.0699432771E+00, 6.2274380623E-01],
	[1.3205000000E+04, 1.6814921499E+01, 1.5537909526E+01, 1.2348593598E+00, 1.0710783332E+00, 6.2288330064E-01],
	[1.3210000000E+04, 1.6823521779E+01, 1.5536722796E+01, 1.2363302239E+00, 1.0722140304E+00, 6.2302277202E-01],
	[1.3215000000E+04, 1.6832123200E+01, 1.5535536606E+01, 1.2378022813E+00, 1.0733503684E+00, 6.2316222033E-01],
	[1.3220000000E+04, 1.6840725763E+01, 1.5534350955E+01, 1.2392755324E+00, 1.0744873472E+00, 6.2330164558E-01],
	[1.3225000000E+04, 1.6849329466E+01, 1.5533165843E+01, 1.2407499778E+00, 1.0756249666E+00, 6.2344104773E-01],
	[1.3230000000E+04, 1.6857934311E+01, 1.5531981269E+01, 1.2422256179E+00, 1.0767632264E+00, 6.2358042677E-01],
	[1.3235000000E+04, 1.6866540296E+01, 1.5530797234E+01, 1.2437024534E+00, 1.0779021265E+00, 6.2371978268E-01],
	[1.3240000000E+04, 1.6875147421E+01, 1.5529613735E+01, 1.2451804846E+00, 1.0790416667E+00, 6.2385911544E-01],
	[1.3245000000E+04, 1.6883755686E+01, 1.5528430774E+01, 1.2466597122E+00, 1.0801818469E+00, 6.2399842504E-01],
	[1.3250000000E+04, 1.6892382650E+01, 1.5527268957E+01, 1.2481401366E+00, 1.0813228387E+00, 6.2413771146E-01],
	[1.3255000000E+04, 1.6901010951E+01, 1.5526107886E+01, 1.2496217583E+00, 1.0824644727E+00, 6.2427697467E-01],
	[1.3260000000E+04, 1.6909640404E+01, 1.5524947340E+01, 1.2511045779E+00, 1.0836067467E+00, 6.2441621467E-01],
	[1.3265000000E+04, 1.6918271006E+01, 1.5523787318E+01, 1.2525885959E+00, 1.0847496607E+00, 6.2455543142E-01],
	[1.3270000000E+04, 1.6926902759E+01, 1.5522627820E+01, 1.2540738128E+00, 1.0858932145E+00, 6.2469462492E-01],
	[1.3275000000E+04, 1.6935535661E+01, 1.5521468846E+01, 1.2555602290E+00, 1.0870374079E+00, 6.2483379515E-01],
	[1.3280000000E+04, 1.6944169713E+01, 1.5520310394E+01, 1.2570478452E+00, 1.0881822408E+00, 6.2497294209E-01],
	[1.3285000000E+04, 1.6952804914E+01, 1.5519152465E+01, 1.2585366619E+00, 1.0893277129E+00, 6.2511206571E-01],
	[1.3290000000E+04, 1.6961441264E+01, 1.5517995057E+01, 1.2600266795E+00, 1.0904738242E+00, 6.2525116601E-01],
	[1.3295000000E+04, 1.6970078762E+01, 1.5516838172E+01, 1.2615178985E+00, 1.0916205745E+00, 6.2539024296E-01],
	[1.3300000000E+04, 1.6978717409E+01, 1.5515681807E+01, 1.2630103195E+00, 1.0927679637E+00, 6.2552929655E-01],
	[1.3305000000E+04, 1.6987357204E+01, 1.5514525964E+01, 1.2645039431E+00, 1.0939159915E+00, 6.2566832676E-01],
	[1.3310000000E+04, 1.6995998146E+01, 1.5513370641E+01, 1.2659987696E+00, 1.0950646578E+00, 6.2580733356E-01],
	[1.3315000000E+04, 1.7004640236E+01, 1.5512215837E+01, 1.2674947997E+00, 1.0962139624E+00, 6.2594631696E-01],
	[1.3320000000E+04, 1.7013283474E+01, 1.5511061553E+01, 1.2689920338E+00, 1.0973639052E+00, 6.2608527691E-01],
	[1.3325000000E+04, 1.7021927858E+01, 1.5509907788E+01, 1.2704904725E+00, 1.0985144861E+00, 6.2622421342E-01],
	[1.3330000000E+04, 1.7030573389E+01, 1.5508754542E+01, 1.2719901162E+00, 1.0996657048E+00, 6.2636312645E-01],
	[1.3335000000E+04, 1.7039220066E+01, 1.5507601814E+01, 1.2734909656E+00, 1.1008175612E+00, 6.2650201600E-01],
	[1.3340000000E+04, 1.7047867889E+01, 1.5506449604E+01, 1.2749930210E+00, 1.1019700551E+00, 6.2664088205E-01],
	[1.3345000000E+04, 1.7056516858E+01, 1.5505297911E+01, 1.2764962830E+00, 1.1031231864E+00, 6.2677972457E-01],
	[1.3350000000E+04, 1.7065166972E+01, 1.5504146735E+01, 1.2780007522E+00, 1.1042769549E+00, 6.2691854355E-01],
	[1.3355000000E+04, 1.7073818232E+01, 1.5502996076E+01, 1.2795064290E+00, 1.1054313604E+00, 6.2705733897E-01],
	[1.3360000000E+04, 1.7082470637E+01, 1.5501845932E+01, 1.2810133140E+00, 1.1065864028E+00, 6.2719611082E-01],
	[1.3365000000E+04, 1.7091124187E+01, 1.5500696304E+01, 1.2825214077E+00, 1.1077420819E+00, 6.2733485908E-01],
	[1.3370000000E+04, 1.7099778880E+01, 1.5499547192E+01, 1.2840307106E+00, 1.1088983975E+00, 6.2747358373E-01],
	[1.3375000000E+04, 1.7108434719E+01, 1.5498398594E+01, 1.2855412232E+00, 1.1100553495E+00, 6.2761228475E-01],
	[1.3380000000E+04, 1.7117091700E+01, 1.5497250511E+01, 1.2870529460E+00, 1.1112129378E+00, 6.2775096213E-01],
	[1.3385000000E+04, 1.7125749826E+01, 1.5496102941E+01, 1.2885658795E+00, 1.1123711620E+00, 6.2788961585E-01],
	[1.3390000000E+04, 1.7134409095E+01, 1.5494955885E+01, 1.2900800243E+00, 1.1135300221E+00, 6.2802824589E-01],
	[1.3395000000E+04, 1.7143069507E+01, 1.5493809342E+01, 1.2915953809E+00, 1.1146895179E+00, 6.2816685223E-01],
	[1.3400000000E+04, 1.7151731061E+01, 1.5492663312E+01, 1.2931119497E+00, 1.1158496493E+00, 6.2830543486E-01],
	[1.3405000000E+04, 1.7160393759E+01, 1.5491517794E+01, 1.2946297314E+00, 1.1170104160E+00, 6.2844399376E-01],
	[1.3410000000E+04, 1.7169057598E+01, 1.5490372788E+01, 1.2961487263E+00, 1.1181718179E+00, 6.2858252891E-01],
	[1.3415000000E+04, 1.7177722579E+01, 1.5489228294E+01, 1.2976689351E+00, 1.1193338549E+00, 6.2872104030E-01],
	[1.3420000000E+04, 1.7186388702E+01, 1.5488084310E+01, 1.2991903583E+00, 1.1204965266E+00, 6.2885952791E-01],
	[1.3425000000E+04, 1.7195055967E+01, 1.5486940837E+01, 1.3007129963E+00, 1.1216598331E+00, 6.2899799172E-01],
	[1.3430000000E+04, 1.7203724372E+01, 1.5485797874E+01, 1.3022368497E+00, 1.1228237741E+00, 6.2913643171E-01],
	[1.3435000000E+04, 1.7212393918E+01, 1.5484655421E+01, 1.3037619190E+00, 1.1239883494E+00, 6.2927484787E-01],
	[1.3440000000E+04, 1.7221064605E+01, 1.5483513477E+01, 1.3052882047E+00, 1.1251535589E+00, 6.2941324019E-01],
	[1.3445000000E+04, 1.7229736432E+01, 1.5482372042E+01, 1.3068157073E+00, 1.1263194024E+00, 6.2955160863E-01],
	[1.3450000000E+04, 1.7238409400E+01, 1.5481231116E+01, 1.3083444274E+00, 1.1274858797E+00, 6.2968995320E-01],
	[1.3455000000E+04, 1.7247083507E+01, 1.5480090698E+01, 1.3098743655E+00, 1.1286529906E+00, 6.2982827387E-01],
	[1.3460000000E+04, 1.7255765234E+01, 1.5478957803E+01, 1.3114055220E+00, 1.1298208002E+00, 6.2996657062E-01],
	[1.3465000000E+04, 1.7264460471E+01, 1.5477838791E+01, 1.3129378975E+00, 1.1309893678E+00, 6.3010484343E-01],
	[1.3470000000E+04, 1.7273156858E+01, 1.5476720276E+01, 1.3144714925E+00, 1.1321585692E+00, 6.3024309230E-01],
	[1.3475000000E+04, 1.7281854396E+01, 1.5475602256E+01, 1.3160063075E+00, 1.1333284042E+00, 6.3038131720E-01],
	[1.3480000000E+04, 1.7290553085E+01, 1.5474484732E+01, 1.3175423431E+00, 1.1344988726E+00, 6.3051951812E-01],
	[1.3485000000E+04, 1.7299252923E+01, 1.5473367702E+01, 1.3190795997E+00, 1.1356699743E+00, 6.3065769504E-01],
	[1.3490000000E+04, 1.7307953912E+01, 1.5472251168E+01, 1.3206180779E+00, 1.1368417091E+00, 6.3079584795E-01],
	[1.3495000000E+04, 1.7316656050E+01, 1.5471135128E+01, 1.3221577781E+00, 1.1380140767E+00, 6.3093397682E-01],
	[1.3500000000E+04, 1.7325359337E+01, 1.5470019581E+01, 1.3236987010E+00, 1.1391870771E+00, 6.3107208164E-01],
	[1.3505000000E+04, 1.7334063773E+01, 1.5468904529E+01, 1.3252408470E+00, 1.1403607100E+00, 6.3121016240E-01],
	[1.3510000000E+04, 1.7342769358E+01, 1.5467789969E+01, 1.3267842166E+00, 1.1415349753E+00, 6.3134821907E-01],
	[1.3515000000E+04, 1.7351476091E+01, 1.5466675902E+01, 1.3283288104E+00, 1.1427098728E+00, 6.3148625165E-01],
	[1.3520000000E+04, 1.7360183972E+01, 1.5465562327E+01, 1.3298746288E+00, 1.1438854023E+00, 6.3162426011E-01],
	[1.3525000000E+04, 1.7368893001E+01, 1.5464449244E+01, 1.3314216725E+00, 1.1450615637E+00, 6.3176224445E-01],
	[1.3530000000E+04, 1.7377603178E+01, 1.5463336652E+01, 1.3329699418E+00, 1.1462383567E+00, 6.3190020463E-01],
	[1.3535000000E+04, 1.7386314502E+01, 1.5462224552E+01, 1.3345194373E+00, 1.1474157812E+00, 6.3203814065E-01],
	[1.3540000000E+04, 1.7395026973E+01, 1.5461112942E+01, 1.3360701596E+00, 1.1485938370E+00, 6.3217605250E-01],
	[1.3545000000E+04, 1.7403740591E+01, 1.5460001823E+01, 1.3376221091E+00, 1.1497725239E+00, 6.3231394014E-01],
	[1.3550000000E+04, 1.7412455356E+01, 1.5458891193E+01, 1.3391752864E+00, 1.1509518418E+00, 6.3245180358E-01],
	[1.3555000000E+04, 1.7421171267E+01, 1.5457781053E+01, 1.3407296919E+00, 1.1521317905E+00, 6.3258964278E-01],
	[1.3560000000E+04, 1.7429888323E+01, 1.5456671403E+01, 1.3422853263E+00, 1.1533123697E+00, 6.3272745775E-01],
	[1.3565000000E+04, 1.7438606526E+01, 1.5455562240E+01, 1.3438421900E+00, 1.1544935793E+00, 6.3286524845E-01],
	[1.3570000000E+04, 1.7447325873E+01, 1.5454453566E+01, 1.3454002835E+00, 1.1556754191E+00, 6.3300301487E-01],
	[1.3575000000E+04, 1.7456046366E+01, 1.5453345380E+01, 1.3469596073E+00, 1.1568578890E+00, 6.3314075701E-01],
	[1.3580000000E+04, 1.7464768004E+01, 1.5452237682E+01, 1.3485201620E+00, 1.1580409888E+00, 6.3327847483E-01],
	[1.3585000000E+04, 1.7473490787E+01, 1.5451130471E+01, 1.3500819481E+00, 1.1592247182E+00, 6.3341616833E-01],
	[1.3590000000E+04, 1.7482214713E+01, 1.5450023746E+01, 1.3516449660E+00, 1.1604090771E+00, 6.3355383749E-01],
	[1.3595000000E+04, 1.7490939784E+01, 1.5448917508E+01, 1.3532092164E+00, 1.1615940653E+00, 6.3369148230E-01],
	[1.3600000000E+04, 1.7499665999E+01, 1.5447811755E+01, 1.3547746997E+00, 1.1627796826E+00, 6.3382910273E-01],
	[1.3605000000E+04, 1.7508393357E+01, 1.5446706488E+01, 1.3563414165E+00, 1.1639659289E+00, 6.3396669877E-01],
	[1.3610000000E+04, 1.7517121858E+01, 1.5445601707E+01, 1.3579093672E+00, 1.1651528039E+00, 6.3410427042E-01],
	[1.3615000000E+04, 1.7525851503E+01, 1.5444497410E+01, 1.3594785524E+00, 1.1663403075E+00, 6.3424181764E-01],
	[1.3620000000E+04, 1.7534582290E+01, 1.5443393597E+01, 1.3610489726E+00, 1.1675284395E+00, 6.3437934043E-01],
	[1.3625000000E+04, 1.7543314219E+01, 1.5442290269E+01, 1.3626206282E+00, 1.1687171997E+00, 6.3451683876E-01],
	[1.3630000000E+04, 1.7552047291E+01, 1.5441187424E+01, 1.3641935200E+00, 1.1699065878E+00, 6.3465431264E-01],
	[1.3635000000E+04, 1.7560781505E+01, 1.5440085062E+01, 1.3657676482E+00, 1.1710966038E+00, 6.3479176202E-01],
	[1.3640000000E+04, 1.7569516860E+01, 1.5438983183E+01, 1.3673430135E+00, 1.1722872475E+00, 6.3492918692E-01],
	[1.3645000000E+04, 1.7578253356E+01, 1.5437881787E+01, 1.3689196164E+00, 1.1734785186E+00, 6.3506658730E-01],
	[1.3650000000E+04, 1.7586990994E+01, 1.5436780873E+01, 1.3704974574E+00, 1.1746704169E+00, 6.3520396315E-01],
	[1.3655000000E+04, 1.7595729773E+01, 1.5435680440E+01, 1.3720765370E+00, 1.1758629423E+00, 6.3534131445E-01],
	[1.3660000000E+04, 1.7604469692E+01, 1.5434580488E+01, 1.3736568558E+00, 1.1770560946E+00, 6.3547864120E-01],
	[1.3665000000E+04, 1.7613210751E+01, 1.5433481018E+01, 1.3752384141E+00, 1.1782498736E+00, 6.3561594337E-01],
	[1.3670000000E+04, 1.7621952951E+01, 1.5432382028E+01, 1.3768212127E+00, 1.1794442790E+00, 6.3575322095E-01],
	[1.3675000000E+04, 1.7630696528E+01, 1.5431283757E+01, 1.3784052519E+00, 1.1806393133E+00, 6.3589047393E-01],
	[1.3680000000E+04, 1.7639460967E+01, 1.5430205697E+01, 1.3799905323E+00, 1.1818351780E+00, 6.3602770229E-01],
	[1.3685000000E+04, 1.7648226559E+01, 1.5429128107E+01, 1.3815770544E+00, 1.1830316693E+00, 6.3616490600E-01],
	[1.3690000000E+04, 1.7656993301E+01, 1.5428050986E+01, 1.3831648187E+00, 1.1842287870E+00, 6.3630208507E-01],
	[1.3695000000E+04, 1.7665761195E+01, 1.5426974333E+01, 1.3847578393E+00, 1.1854294722E+00, 6.3643923947E-01],
	[1.3700000000E+04, 1.7674530240E+01, 1.5425898149E+01, 1.3863586655E+00, 1.1866355895E+00, 6.3657636919E-01],
	[1.3705000000E+04, 1.7683300435E+01, 1.5424822432E+01, 1.3879607560E+00, 1.1878423435E+00, 6.3671347421E-01],
	[1.3710000000E+04, 1.7692071781E+01, 1.5423747182E+01, 1.3895641113E+00, 1.1890497339E+00, 6.3685055452E-01],
	[1.3715000000E+04, 1.7700844277E+01, 1.5422672400E+01, 1.3911687319E+00, 1.1902577605E+00, 6.3698761011E-01],
	[1.3720000000E+04, 1.7709617922E+01, 1.5421598084E+01, 1.3927746185E+00, 1.1914664231E+00, 6.3712464095E-01],
	[1.3725000000E+04, 1.7718392718E+01, 1.5420524234E+01, 1.3943817714E+00, 1.1926757215E+00, 6.3726164703E-01],
	[1.3730000000E+04, 1.7727168662E+01, 1.5419450850E+01, 1.3959901913E+00, 1.1938856555E+00, 6.3739862834E-01],
	[1.3735000000E+04, 1.7735945756E+01, 1.5418377932E+01, 1.3975998787E+00, 1.1950962250E+00, 6.3753558486E-01],
	[1.3740000000E+04, 1.7744723998E+01, 1.5417305479E+01, 1.3992108341E+00, 1.1963074297E+00, 6.3767251658E-01],
	[1.3745000000E+04, 1.7753503389E+01, 1.5416233491E+01, 1.4008230581E+00, 1.1975192695E+00, 6.3780942348E-01],
	[1.3750000000E+04, 1.7762283929E+01, 1.5415161966E+01, 1.4024365511E+00, 1.1987317440E+00, 6.3794630555E-01],
	[1.3755000000E+04, 1.7771065616E+01, 1.5414090906E+01, 1.4040513138E+00, 1.1999448533E+00, 6.3808316278E-01],
	[1.3760000000E+04, 1.7779848451E+01, 1.5413020310E+01, 1.4056673467E+00, 1.2011585970E+00, 6.3821999514E-01],
	[1.3765000000E+04, 1.7788632433E+01, 1.5411950177E+01, 1.4072846502E+00, 1.2023729749E+00, 6.3835680262E-01],
	[1.3770000000E+04, 1.7797417562E+01, 1.5410880507E+01, 1.4089032250E+00, 1.2035879869E+00, 6.3849358521E-01],
	[1.3775000000E+04, 1.7806203839E+01, 1.5409811299E+01, 1.4105230716E+00, 1.2048036327E+00, 6.3863034290E-01],
	[1.3780000000E+04, 1.7814991262E+01, 1.5408742553E+01, 1.4121441904E+00, 1.2060199122E+00, 6.3876707566E-01],
	[1.3785000000E+04, 1.7823779831E+01, 1.5407674270E+01, 1.4137665821E+00, 1.2072368252E+00, 6.3890378349E-01],
	[1.3790000000E+04, 1.7832569547E+01, 1.5406606447E+01, 1.4153902472E+00, 1.2084543714E+00, 6.3904046637E-01],
	[1.3795000000E+04, 1.7841360408E+01, 1.5405539086E+01, 1.4170151862E+00, 1.2096725507E+00, 6.3917712429E-01],
	[1.3800000000E+04, 1.7850152415E+01, 1.5404472186E+01, 1.4186413997E+00, 1.2108913628E+00, 6.3931375722E-01],
	[1.3805000000E+04, 1.7858945567E+01, 1.5403405745E+01, 1.4202688881E+00, 1.2121108076E+00, 6.3945036516E-01],
	[1.3810000000E+04, 1.7867739864E+01, 1.5402339765E+01, 1.4218976521E+00, 1.2133308849E+00, 6.3958694810E-01],
	[1.3815000000E+04, 1.7876535306E+01, 1.5401274245E+01, 1.4235276921E+00, 1.2145515944E+00, 6.3972350600E-01],
	[1.3820000000E+04, 1.7885331893E+01, 1.5400209183E+01, 1.4251590087E+00, 1.2157729360E+00, 6.3986003888E-01],
	[1.3825000000E+04, 1.7894129624E+01, 1.5399144581E+01, 1.4267916025E+00, 1.2169949094E+00, 6.3999654670E-01],
	[1.3830000000E+04, 1.7902928499E+01, 1.5398080437E+01, 1.4284254739E+00, 1.2182175145E+00, 6.4013302945E-01],
	[1.3835000000E+04, 1.7911728517E+01, 1.5397016751E+01, 1.4300606235E+00, 1.2194407510E+00, 6.4026948712E-01],
	[1.3840000000E+04, 1.7920529679E+01, 1.5395953523E+01, 1.4316970518E+00, 1.2206646187E+00, 6.4040591970E-01],
	[1.3845000000E+04, 1.7929331984E+01, 1.5394890752E+01, 1.4333347594E+00, 1.2218891175E+00, 6.4054232717E-01],
	[1.3850000000E+04, 1.7938135432E+01, 1.5393828439E+01, 1.4349737468E+00, 1.2231142472E+00, 6.4067870951E-01],
	[1.3855000000E+04, 1.7946940023E+01, 1.5392766582E+01, 1.4366140146E+00, 1.2243400074E+00, 6.4081506672E-01],
	[1.3860000000E+04, 1.7955745756E+01, 1.5391705181E+01, 1.4382555633E+00, 1.2255663981E+00, 6.4095139877E-01],
	[1.3865000000E+04, 1.7964552631E+01, 1.5390644237E+01, 1.4398983933E+00, 1.2267934190E+00, 6.4108770566E-01],
	[1.3870000000E+04, 1.7973360648E+01, 1.5389583748E+01, 1.4415425054E+00, 1.2280210700E+00, 6.4122398737E-01],
	[1.3875000000E+04, 1.7982169807E+01, 1.5388523714E+01, 1.4431878999E+00, 1.2292493507E+00, 6.4136024388E-01],
	[1.3880000000E+04, 1.7990980107E+01, 1.5387464136E+01, 1.4448345774E+00, 1.2304782610E+00, 6.4149647518E-01],
	[1.3885000000E+04, 1.7999791548E+01, 1.5386405011E+01, 1.4464825385E+00, 1.2317078007E+00, 6.4163268126E-01],
	[1.3890000000E+04, 1.8008604130E+01, 1.5385346341E+01, 1.4481317837E+00, 1.2329379696E+00, 6.4176886211E-01],
	[1.3895000000E+04, 1.8017417852E+01, 1.5384288125E+01, 1.4497823136E+00, 1.2341687675E+00, 6.4190501770E-01],
	[1.3900000000E+04, 1.8026253431E+01, 1.5383249575E+01, 1.4514341286E+00, 1.2354004154E+00, 6.4204114803E-01],
	[1.3905000000E+04, 1.8035090534E+01, 1.5382211813E+01, 1.4530872293E+00, 1.2366326965E+00, 6.4217725308E-01],
	[1.3910000000E+04, 1.8043928790E+01, 1.5381174494E+01, 1.4547416163E+00, 1.2378656067E+00, 6.4231333284E-01],
	[1.3915000000E+04, 1.8052768198E+01, 1.5380137617E+01, 1.4563972900E+00, 1.2390991457E+00, 6.4244938729E-01],
	[1.3920000000E+04, 1.8061608759E+01, 1.5379101183E+01, 1.4580542511E+00, 1.2403333135E+00, 6.4258541642E-01],
	[1.3925000000E+04, 1.8070450472E+01, 1.5378065192E+01, 1.4597125000E+00, 1.2415681097E+00, 6.4272142021E-01],
	[1.3930000000E+04, 1.8079293336E+01, 1.5377029641E+01, 1.4613720373E+00, 1.2428035342E+00, 6.4285739866E-01],
	[1.3935000000E+04, 1.8088137352E+01, 1.5375994532E+01, 1.4630328635E+00, 1.2440395867E+00, 6.4299335175E-01],
	[1.3940000000E+04, 1.8096982520E+01, 1.5374959865E+01, 1.4646949792E+00, 1.2452762670E+00, 6.4312927946E-01],
	[1.3945000000E+04, 1.8105828838E+01, 1.5373925637E+01, 1.4663583849E+00, 1.2465135750E+00, 6.4326518178E-01],
	[1.3950000000E+04, 1.8114676307E+01, 1.5372891850E+01, 1.4680230811E+00, 1.2477515104E+00, 6.4340105870E-01],
	[1.3955000000E+04, 1.8123524926E+01, 1.5371858503E+01, 1.4696890684E+00, 1.2489900729E+00, 6.4353691020E-01],
	[1.3960000000E+04, 1.8132374696E+01, 1.5370825596E+01, 1.4713563474E+00, 1.2502292625E+00, 6.4367273627E-01],
	[1.3965000000E+04, 1.8141225615E+01, 1.5369793128E+01, 1.4730249184E+00, 1.2514690788E+00, 6.4380853690E-01],
	[1.3970000000E+04, 1.8150077685E+01, 1.5368761098E+01, 1.4746947822E+00, 1.2527095217E+00, 6.4394431207E-01],
	[1.3975000000E+04, 1.8158930903E+01, 1.5367729508E+01, 1.4763659391E+00, 1.2539505909E+00, 6.4408006176E-01],
	[1.3980000000E+04, 1.8167785271E+01, 1.5366698355E+01, 1.4780383899E+00, 1.2551922863E+00, 6.4421578598E-01],
	[1.3985000000E+04, 1.8176640788E+01, 1.5365667641E+01, 1.4797121349E+00, 1.2564346076E+00, 6.4435148470E-01],
	[1.3990000000E+04, 1.8185497453E+01, 1.5364637363E+01, 1.4813871747E+00, 1.2576775546E+00, 6.4448715790E-01],
	[1.3995000000E+04, 1.8194355266E+01, 1.5363607524E+01, 1.4830635100E+00, 1.2589211271E+00, 6.4462280558E-01],
	[1.4000000000E+04, 1.8203214228E+01, 1.5362578121E+01, 1.4847411411E+00, 1.2601653248E+00, 6.4475842772E-01],
	[1.4005000000E+04, 1.8212074338E+01, 1.5361549154E+01, 1.4864200687E+00, 1.2614101476E+00, 6.4489402432E-01],
	[1.4010000000E+04, 1.8220935595E+01, 1.5360520624E+01, 1.4881002932E+00, 1.2626555953E+00, 6.4502959534E-01],
	[1.4015000000E+04, 1.8229797999E+01, 1.5359492529E+01, 1.4897818153E+00, 1.2639016676E+00, 6.4516514079E-01],
	[1.4020000000E+04, 1.8238661551E+01, 1.5358464870E+01, 1.4914646354E+00, 1.2651483642E+00, 6.4530066065E-01],
	[1.4025000000E+04, 1.8247526249E+01, 1.5357437646E+01, 1.4931487541E+00, 1.2663956851E+00, 6.4543615490E-01],
	[1.4030000000E+04, 1.8256392094E+01, 1.5356410857E+01, 1.4948341720E+00, 1.2676436300E+00, 6.4557162353E-01],
	[1.4035000000E+04, 1.8265259085E+01, 1.5355384503E+01, 1.4965208895E+00, 1.2688921986E+00, 6.4570706654E-01],
	[1.4040000000E+04, 1.8274127222E+01, 1.5354358582E+01, 1.4982089072E+00, 1.2701413907E+00, 6.4584248390E-01],
	[1.4045000000E+04, 1.8282996504E+01, 1.5353333096E+01, 1.4998982256E+00, 1.2713912062E+00, 6.4597787560E-01],
	[1.4050000000E+04, 1.8291866933E+01, 1.5352308043E+01, 1.5015888453E+00, 1.2726416447E+00, 6.4611324163E-01],
	[1.4055000000E+04, 1.8300738506E+01, 1.5351283423E+01, 1.5032807669E+00, 1.2738927061E+00, 6.4624858198E-01],
	[1.4060000000E+04, 1.8309611225E+01, 1.5350259235E+01, 1.5049739908E+00, 1.2751443902E+00, 6.4638389663E-01],
	[1.4065000000E+04, 1.8318485088E+01, 1.5349235481E+01, 1.5066685175E+00, 1.2763966967E+00, 6.4651918557E-01],
	[1.4070000000E+04, 1.8327360095E+01, 1.5348212158E+01, 1.5083643477E+00, 1.2776496255E+00, 6.4665444879E-01],
	[1.4075000000E+04, 1.8336236247E+01, 1.5347189267E+01, 1.5100614819E+00, 1.2789031762E+00, 6.4678968628E-01],
	[1.4080000000E+04, 1.8345113543E+01, 1.5346166807E+01, 1.5117599206E+00, 1.2801573487E+00, 6.4692489801E-01],
	[1.4085000000E+04, 1.8353991982E+01, 1.5345144779E+01, 1.5134596643E+00, 1.2814121427E+00, 6.4706008396E-01],
	[1.4090000000E+04, 1.8362871565E+01, 1.5344123181E+01, 1.5151607135E+00, 1.2826675581E+00, 6.4719524408E-01],
	[1.4095000000E+04, 1.8371752291E+01, 1.5343102014E+01, 1.5168630689E+00, 1.2839235946E+00, 6.4733037835E-01],
	[1.4100000000E+04, 1.8380634160E+01, 1.5342081277E+01, 1.5185667310E+00, 1.2851802519E+00, 6.4746548676E-01],
	[1.4105000000E+04, 1.8389517171E+01, 1.5341060970E+01, 1.5202717002E+00, 1.2864375299E+00, 6.4760056928E-01],
	[1.4110000000E+04, 1.8398401325E+01, 1.5340041092E+01, 1.5219779772E+00, 1.2876954284E+00, 6.4773562589E-01],
	[1.4115000000E+04, 1.8407286621E+01, 1.5339021643E+01, 1.5236855624E+00, 1.2889539470E+00, 6.4787065659E-01],
	[1.4120000000E+04, 1.8416178481E+01, 1.5338007297E+01, 1.5253944564E+00, 1.2902131453E+00, 6.4800566133E-01],
	[1.4125000000E+04, 1.8425088291E+01, 1.5337007856E+01, 1.5271046598E+00, 1.2914731488E+00, 6.4814064012E-01],
	[1.4130000000E+04, 1.8433999257E+01, 1.5336008833E+01, 1.5288161730E+00, 1.2927337726E+00, 6.4827559293E-01],
	[1.4135000000E+04, 1.8442911377E+01, 1.5335010230E+01, 1.5305289967E+00, 1.2939950165E+00, 6.4841051973E-01],
	[1.4140000000E+04, 1.8451824652E+01, 1.5334012044E+01, 1.5322431313E+00, 1.2952568803E+00, 6.4854542051E-01],
	[1.4145000000E+04, 1.8460739080E+01, 1.5333014276E+01, 1.5339585774E+00, 1.2965193636E+00, 6.4868029526E-01],
	[1.4150000000E+04, 1.8469654663E+01, 1.5332016926E+01, 1.5356753355E+00, 1.2977824664E+00, 6.4881514395E-01],
	[1.4155000000E+04, 1.8478571399E+01, 1.5331019993E+01, 1.5373934062E+00, 1.2990461884E+00, 6.4894996656E-01],
	[1.4160000000E+04, 1.8487489289E+01, 1.5330023476E+01, 1.5391127900E+00, 1.3003105293E+00, 6.4908476308E-01],
	[1.4165000000E+04, 1.8496408332E+01, 1.5329027377E+01, 1.5408334874E+00, 1.3015754890E+00, 6.4921953348E-01],
	[1.4170000000E+04, 1.8505328528E+01, 1.5328031693E+01, 1.5425554990E+00, 1.3028410672E+00, 6.4935427775E-01],
	[1.4175000000E+04, 1.8514249876E+01, 1.5327036426E+01, 1.5442788254E+00, 1.3041072636E+00, 6.4948899587E-01],
	[1.4180000000E+04, 1.8523172377E+01, 1.5326041574E+01, 1.5460034670E+00, 1.3053740781E+00, 6.4962368782E-01],
	[1.4185000000E+04, 1.8532096030E+01, 1.5325047137E+01, 1.5477294244E+00, 1.3066415104E+00, 6.4975835358E-01],
	[1.4190000000E+04, 1.8541020835E+01, 1.5324053115E+01, 1.5494566981E+00, 1.3079095602E+00, 6.4989299314E-01],
	[1.4195000000E+04, 1.8549946791E+01, 1.5323059508E+01, 1.5511852886E+00, 1.3091782275E+00, 6.5002760646E-01],
	[1.4200000000E+04, 1.8558873899E+01, 1.5322066315E+01, 1.5529151966E+00, 1.3104475118E+00, 6.5016219354E-01],
	[1.4205000000E+04, 1.8567802157E+01, 1.5321073537E+01, 1.5546464226E+00, 1.3117174131E+00, 6.5029675436E-01],
	[1.4210000000E+04, 1.8576731567E+01, 1.5320081171E+01, 1.5563789670E+00, 1.3129879310E+00, 6.5043128890E-01],
	[1.4215000000E+04, 1.8585662127E+01, 1.5319089220E+01, 1.5581128305E+00, 1.3142590653E+00, 6.5056579713E-01],
	[1.4220000000E+04, 1.8594593838E+01, 1.5318097681E+01, 1.5598480135E+00, 1.3155308159E+00, 6.5070027905E-01],
	[1.4225000000E+04, 1.8603526698E+01, 1.5317106555E+01, 1.5615845166E+00, 1.3168031824E+00, 6.5083473463E-01],
	[1.4230000000E+04, 1.8612460708E+01, 1.5316115841E+01, 1.5633223403E+00, 1.3180761646E+00, 6.5096916385E-01],
	[1.4235000000E+04, 1.8621395868E+01, 1.5315125540E+01, 1.5650614852E+00, 1.3193497624E+00, 6.5110356670E-01],
	[1.4240000000E+04, 1.8630332177E+01, 1.5314135650E+01, 1.5668019519E+00, 1.3206239754E+00, 6.5123794316E-01],
	[1.4245000000E+04, 1.8639269636E+01, 1.5313146172E+01, 1.5685437407E+00, 1.3218988034E+00, 6.5137229321E-01],
	[1.4250000000E+04, 1.8648208243E+01, 1.5312157105E+01, 1.5702868524E+00, 1.3231742463E+00, 6.5150661683E-01],
	[1.4255000000E+04, 1.8657147998E+01, 1.5311168449E+01, 1.5720312874E+00, 1.3244503037E+00, 6.5164091400E-01],
	[1.4260000000E+04, 1.8666088902E+01, 1.5310180203E+01, 1.5737770463E+00, 1.3257269754E+00, 6.5177518471E-01],
	[1.4265000000E+04, 1.8675030953E+01, 1.5309192367E+01, 1.5755241296E+00, 1.3270042613E+00, 6.5190942893E-01],
	[1.4270000000E+04, 1.8683974153E+01, 1.5308204942E+01, 1.5772725378E+00, 1.3282821610E+00, 6.5204364665E-01],
	[1.4275000000E+04, 1.8692918500E+01, 1.5307217925E+01, 1.5790222715E+00, 1.3295606743E+00, 6.5217783786E-01],
	[1.4280000000E+04, 1.8701863994E+01, 1.5306231319E+01, 1.5807733313E+00, 1.3308398010E+00, 6.5231200252E-01],
	[1.4285000000E+04, 1.8710810635E+01, 1.5305245121E+01, 1.5825257175E+00, 1.3321195409E+00, 6.5244614063E-01],
	[1.4290000000E+04, 1.8719758423E+01, 1.5304259332E+01, 1.5842794309E+00, 1.3333998936E+00, 6.5258025217E-01],
	[1.4295000000E+04, 1.8728707358E+01, 1.5303273951E+01, 1.5860344720E+00, 1.3346808591E+00, 6.5271433712E-01],
	[1.4300000000E+04, 1.8737657438E+01, 1.5302288978E+01, 1.5877908412E+00, 1.3359624370E+00, 6.5284839545E-01],
	[1.4305000000E+04, 1.8746608665E+01, 1.5301304412E+01, 1.5895485391E+00, 1.3372446270E+00, 6.5298242716E-01],
	[1.4310000000E+04, 1.8755561037E+01, 1.5300320255E+01, 1.5913075663E+00, 1.3385274291E+00, 6.5311643223E-01],
	[1.4315000000E+04, 1.8764514555E+01, 1.5299336504E+01, 1.5930679232E+00, 1.3398108428E+00, 6.5325041063E-01],
	[1.4320000000E+04, 1.8773469218E+01, 1.5298353160E+01, 1.5948296105E+00, 1.3410948680E+00, 6.5338436235E-01],
	[1.4325000000E+04, 1.8782425026E+01, 1.5297370222E+01, 1.5965926287E+00, 1.3423795045E+00, 6.5351828738E-01],
	[1.4330000000E+04, 1.8791381979E+01, 1.5296387691E+01, 1.5983569783E+00, 1.3436647520E+00, 6.5365218569E-01],
	[1.4335000000E+04, 1.8800340076E+01, 1.5295405565E+01, 1.6001226598E+00, 1.3449506102E+00, 6.5378605726E-01],
	[1.4340000000E+04, 1.8809299317E+01, 1.5294423845E+01, 1.6018896739E+00, 1.3462370790E+00, 6.5391990209E-01],
	[1.4345000000E+04, 1.8818259703E+01, 1.5293442531E+01, 1.6036580209E+00, 1.3475241580E+00, 6.5405372014E-01],
	[1.4350000000E+04, 1.8827239593E+01, 1.5292476352E+01, 1.6054277015E+00, 1.3488120559E+00, 6.5418751142E-01],
	[1.4355000000E+04, 1.8836225659E+01, 1.5291514598E+01, 1.6071987162E+00, 1.3501006214E+00, 6.5432127588E-01],
	[1.4360000000E+04, 1.8845212881E+01, 1.5290553238E+01, 1.6089710656E+00, 1.3513897973E+00, 6.5445501353E-01],
	[1.4365000000E+04, 1.8854201261E+01, 1.5289592274E+01, 1.6107447501E+00, 1.3526795833E+00, 6.5458872434E-01],
	[1.4370000000E+04, 1.8863190798E+01, 1.5288631705E+01, 1.6125197704E+00, 1.3539699792E+00, 6.5472240829E-01],
	[1.4375000000E+04, 1.8872181491E+01, 1.5287671530E+01, 1.6142961269E+00, 1.3552609848E+00, 6.5485606537E-01],
	[1.4380000000E+04, 1.8881173340E+01, 1.5286711749E+01, 1.6160738202E+00, 1.3565525997E+00, 6.5498969556E-01],
	[1.4385000000E+04, 1.8890166346E+01, 1.5285752362E+01, 1.6178528509E+00, 1.3578448239E+00, 6.5512329884E-01],
	[1.4390000000E+04, 1.8899160507E+01, 1.5284793369E+01, 1.6196332194E+00, 1.3591376569E+00, 6.5525687520E-01],
	[1.4395000000E+04, 1.8908155824E+01, 1.5283834768E+01, 1.6214149264E+00, 1.3604310986E+00, 6.5539042461E-01],
	[1.4400000000E+04, 1.8917152296E+01, 1.5282876561E+01, 1.6231979723E+00, 1.3617251488E+00, 6.5552394706E-01],
	[1.4405000000E+04, 1.8926149923E+01, 1.5281918747E+01, 1.6249823577E+00, 1.3630198071E+00, 6.5565744254E-01],
	[1.4410000000E+04, 1.8935148705E+01, 1.5280961325E+01, 1.6267680832E+00, 1.3643150734E+00, 6.5579091103E-01],
	[1.4415000000E+04, 1.8944148642E+01, 1.5280004295E+01, 1.6285551492E+00, 1.3656109474E+00, 6.5592435250E-01],
	[1.4420000000E+04, 1.8953149733E+01, 1.5279047657E+01, 1.6303435564E+00, 1.3669074288E+00, 6.5605776695E-01],
	[1.4425000000E+04, 1.8962151978E+01, 1.5278091411E+01, 1.6321333052E+00, 1.3682045174E+00, 6.5619115435E-01],
	[1.4430000000E+04, 1.8971155376E+01, 1.5277135555E+01, 1.6339243961E+00, 1.3695022130E+00, 6.5632451469E-01],
	[1.4435000000E+04, 1.8980159928E+01, 1.5276180091E+01, 1.6357168299E+00, 1.3708005153E+00, 6.5645784795E-01],
	[1.4440000000E+04, 1.8989165634E+01, 1.5275225017E+01, 1.6375106069E+00, 1.3720994240E+00, 6.5659115412E-01],
	[1.4445000000E+04, 1.8998172492E+01, 1.5274270334E+01, 1.6393057277E+00, 1.3733989390E+00, 6.5672443317E-01],
	[1.4450000000E+04, 1.9007180504E+01, 1.5273316040E+01, 1.6411021928E+00, 1.3746990599E+00, 6.5685768509E-01],
	[1.4455000000E+04, 1.9016189667E+01, 1.5272362137E+01, 1.6429000029E+00, 1.3759997865E+00, 6.5699090987E-01],
	[1.4460000000E+04, 1.9025199984E+01, 1.5271408622E+01, 1.6446991583E+00, 1.3773011186E+00, 6.5712410749E-01],
	[1.4465000000E+04, 1.9034211452E+01, 1.5270455497E+01, 1.6464996598E+00, 1.3786030559E+00, 6.5725727792E-01],
	[1.4470000000E+04, 1.9043224072E+01, 1.5269502761E+01, 1.6483015078E+00, 1.3799055981E+00, 6.5739042116E-01],
	[1.4475000000E+04, 1.9052237843E+01, 1.5268550413E+01, 1.6501047028E+00, 1.3812087451E+00, 6.5752353719E-01],
	[1.4480000000E+04, 1.9061252766E+01, 1.5267598454E+01, 1.6519092454E+00, 1.3825124966E+00, 6.5765662599E-01],
	[1.4485000000E+04, 1.9070268839E+01, 1.5266646883E+01, 1.6537151361E+00, 1.3838168522E+00, 6.5778968754E-01],
	[1.4490000000E+04, 1.9079286064E+01, 1.5265695699E+01, 1.6555223755E+00, 1.3851218118E+00, 6.5792272182E-01],
	[1.4495000000E+04, 1.9088304439E+01, 1.5264744903E+01, 1.6573309641E+00, 1.3864273751E+00, 6.5805572883E-01],
	[1.4500000000E+04, 1.9097323964E+01, 1.5263794493E+01, 1.6591409025E+00, 1.3877335419E+00, 6.5818870855E-01],
	[1.4505000000E+04, 1.9106344639E+01, 1.5262844471E+01, 1.6609521911E+00, 1.3890403119E+00, 6.5832166095E-01],
	[1.4510000000E+04, 1.9115366464E+01, 1.5261894835E+01, 1.6627648306E+00, 1.3903476848E+00, 6.5845458602E-01],
	[1.4515000000E+04, 1.9124389439E+01, 1.5260945585E+01, 1.6645788214E+00, 1.3916556604E+00, 6.5858748375E-01],
	[1.4520000000E+04, 1.9133413563E+01, 1.5259996722E+01, 1.6663941642E+00, 1.3929642385E+00, 6.5872035411E-01],
	[1.4525000000E+04, 1.9142438835E+01, 1.5259048244E+01, 1.6682108594E+00, 1.3942734188E+00, 6.5885319710E-01],
	[1.4530000000E+04, 1.9151465257E+01, 1.5258100151E+01, 1.6700289076E+00, 1.3955832010E+00, 6.5898601269E-01],
	[1.4535000000E+04, 1.9160492827E+01, 1.5257152443E+01, 1.6718483093E+00, 1.3968935848E+00, 6.5911880087E-01],
	[1.4540000000E+04, 1.9169521546E+01, 1.5256205120E+01, 1.6736690651E+00, 1.3982045701E+00, 6.5925156163E-01],
	[1.4545000000E+04, 1.9178551412E+01, 1.5255258182E+01, 1.6754911755E+00, 1.3995161566E+00, 6.5938429494E-01],
	[1.4550000000E+04, 1.9187582426E+01, 1.5254311628E+01, 1.6773146410E+00, 1.4008283439E+00, 6.5951700080E-01],
	[1.4555000000E+04, 1.9196614588E+01, 1.5253365458E+01, 1.6791394623E+00, 1.4021411319E+00, 6.5964967918E-01],
	[1.4560000000E+04, 1.9205647897E+01, 1.5252419671E+01, 1.6809656397E+00, 1.4034545204E+00, 6.5978233007E-01],
	[1.4565000000E+04, 1.9214682353E+01, 1.5251474268E+01, 1.6827931740E+00, 1.4047685089E+00, 6.5991495345E-01],
	[1.4570000000E+04, 1.9223717956E+01, 1.5250529248E+01, 1.6846220655E+00, 1.4060830974E+00, 6.6004754931E-01],
	[1.4575000000E+04, 1.9232754705E+01, 1.5249584611E+01, 1.6864523149E+00, 1.4073982854E+00, 6.6018011762E-01],
	[1.4580000000E+04, 1.9241807204E+01, 1.5248651286E+01, 1.6882839227E+00, 1.4087142444E+00, 6.6031265839E-01],
	[1.4585000000E+04, 1.9250870804E+01, 1.5247725779E+01, 1.6901168894E+00, 1.4100309200E+00, 6.6044517158E-01],
	[1.4590000000E+04, 1.9259935565E+01, 1.5246800647E+01, 1.6919512156E+00, 1.4113481954E+00, 6.6057765719E-01],
	[1.4595000000E+04, 1.9269001486E+01, 1.5245875887E+01, 1.6937869018E+00, 1.4126660702E+00, 6.6071011519E-01],
	[1.4600000000E+04, 1.9278068567E+01, 1.5244951500E+01, 1.6956239485E+00, 1.4139845442E+00, 6.6084254557E-01],
	[1.4605000000E+04, 1.9287136808E+01, 1.5244027486E+01, 1.6974623564E+00, 1.4153036171E+00, 6.6097494832E-01],
	[1.4610000000E+04, 1.9296206208E+01, 1.5243103843E+01, 1.6993021259E+00, 1.4166232888E+00, 6.6110732342E-01],
	[1.4615000000E+04, 1.9305276768E+01, 1.5242180573E+01, 1.7011432575E+00, 1.4179435588E+00, 6.6123967085E-01],
	[1.4620000000E+04, 1.9314348487E+01, 1.5241257675E+01, 1.7029857519E+00, 1.4192644271E+00, 6.6137199060E-01],
	[1.4625000000E+04, 1.9323421364E+01, 1.5240335148E+01, 1.7048296095E+00, 1.4205858932E+00, 6.6150428266E-01],
	[1.4630000000E+04, 1.9332495399E+01, 1.5239412992E+01, 1.7066748309E+00, 1.4219079570E+00, 6.6163654700E-01],
	[1.4635000000E+04, 1.9341570593E+01, 1.5238491207E+01, 1.7085214167E+00, 1.4232306182E+00, 6.6176878361E-01],
	[1.4640000000E+04, 1.9350646945E+01, 1.5237569793E+01, 1.7103693673E+00, 1.4245538765E+00, 6.6190099248E-01],
	[1.4645000000E+04, 1.9359724455E+01, 1.5236648748E+01, 1.7122186834E+00, 1.4258777317E+00, 6.6203317358E-01],
	[1.4650000000E+04, 1.9368803122E+01, 1.5235728074E+01, 1.7140693654E+00, 1.4272021835E+00, 6.6216532692E-01],
	[1.4655000000E+04, 1.9377882946E+01, 1.5234807770E+01, 1.7159214139E+00, 1.4285272316E+00, 6.6229745246E-01],
	[1.4660000000E+04, 1.9386963928E+01, 1.5233887835E+01, 1.7177748294E+00, 1.4298528758E+00, 6.6242955019E-01],
	[1.4665000000E+04, 1.9396046066E+01, 1.5232968270E+01, 1.7196296125E+00, 1.4311791158E+00, 6.6256162011E-01],
	[1.4670000000E+04, 1.9405129360E+01, 1.5232049073E+01, 1.7214857638E+00, 1.4325059513E+00, 6.6269366219E-01],
	[1.4675000000E+04, 1.9414213811E+01, 1.5231130245E+01, 1.7233432837E+00, 1.4338333821E+00, 6.6282567641E-01],
	[1.4680000000E+04, 1.9423299418E+01, 1.5230211786E+01, 1.7252021728E+00, 1.4351614080E+00, 6.6295766277E-01],
	[1.4685000000E+04, 1.9432386180E+01, 1.5229293694E+01, 1.7270624316E+00, 1.4364900286E+00, 6.6308962124E-01],
	[1.4690000000E+04, 1.9441474098E+01, 1.5228375971E+01, 1.7289240608E+00, 1.4378192437E+00, 6.6322155182E-01],
	[1.4695000000E+04, 1.9450563172E+01, 1.5227458615E+01, 1.7307870608E+00, 1.4391490530E+00, 6.6335345449E-01],
	[1.4700000000E+04, 1.9459653400E+01, 1.5226541626E+01, 1.7326514321E+00, 1.4404794562E+00, 6.6348532922E-01],
	[1.4705000000E+04, 1.9468744783E+01, 1.5225625005E+01, 1.7345171753E+00, 1.4418104532E+00, 6.6361717601E-01],
	[1.4710000000E+04, 1.9477837321E+01, 1.5224708750E+01, 1.7363842910E+00, 1.4431420436E+00, 6.6374899485E-01],
	[1.4715000000E+04, 1.9486931013E+01, 1.5223792862E+01, 1.7382527797E+00, 1.4444742271E+00, 6.6388078571E-01],
	[1.4720000000E+04, 1.9496025859E+01, 1.5222877340E+01, 1.7401226419E+00, 1.4458070035E+00, 6.6401254858E-01],
	[1.4725000000E+04, 1.9505121858E+01, 1.5221962183E+01, 1.7419938782E+00, 1.4471403725E+00, 6.6414428344E-01],
	[1.4730000000E+04, 1.9514219012E+01, 1.5221047393E+01, 1.7438664891E+00, 1.4484743339E+00, 6.6427599029E-01],
	[1.4735000000E+04, 1.9523317318E+01, 1.5220132968E+01, 1.7457404751E+00, 1.4498088874E+00, 6.6440766911E-01],
	[1.4740000000E+04, 1.9532416778E+01, 1.5219218908E+01, 1.7476158369E+00, 1.4511440327E+00, 6.6453931987E-01],
	[1.4745000000E+04, 1.9541517390E+01, 1.5218305213E+01, 1.7494925749E+00, 1.4524797695E+00, 6.6467094257E-01],
	[1.4750000000E+04, 1.9550619155E+01, 1.5217391883E+01, 1.7513706896E+00, 1.4538160977E+00, 6.6480253720E-01],
	[1.4755000000E+04, 1.9559722072E+01, 1.5216478917E+01, 1.7532501817E+00, 1.4551530168E+00, 6.6493410373E-01],
	[1.4760000000E+04, 1.9568826142E+01, 1.5215566315E+01, 1.7551310516E+00, 1.4564905266E+00, 6.6506564215E-01],
	[1.4765000000E+04, 1.9577931363E+01, 1.5214654076E+01, 1.7570133000E+00, 1.4578286269E+00, 6.6519715245E-01],
	[1.4770000000E+04, 1.9587037735E+01, 1.5213742202E+01, 1.7588969273E+00, 1.4591673174E+00, 6.6532863462E-01],
	[1.4775000000E+04, 1.9596145259E+01, 1.5212830690E+01, 1.7607819340E+00, 1.4605065979E+00, 6.6546008863E-01],
	[1.4780000000E+04, 1.9605253935E+01, 1.5211919542E+01, 1.7626683208E+00, 1.4618464680E+00, 6.6559151447E-01],
	[1.4785000000E+04, 1.9614363761E+01, 1.5211008756E+01, 1.7645560882E+00, 1.4631869274E+00, 6.6572291213E-01],
	[1.4790000000E+04, 1.9623474737E+01, 1.5210098333E+01, 1.7664452367E+00, 1.4645279760E+00, 6.6585428160E-01],
	[1.4795000000E+04, 1.9632586864E+01, 1.5209188272E+01, 1.7683357668E+00, 1.4658696134E+00, 6.6598562286E-01],
	[1.4800000000E+04, 1.9641700141E+01, 1.5208278573E+01, 1.7702276791E+00, 1.4672118393E+00, 6.6611693589E-01],
	[1.4805000000E+04, 1.9650814568E+01, 1.5207369235E+01, 1.7721209742E+00, 1.4685546535E+00, 6.6624822068E-01],
	[1.4810000000E+04, 1.9659930145E+01, 1.5206460259E+01, 1.7740156525E+00, 1.4698980558E+00, 6.6637947722E-01],
	[1.4815000000E+04, 1.9669063874E+01, 1.5205563537E+01, 1.7759117147E+00, 1.4712422522E+00, 6.6651070549E-01],
	[1.4820000000E+04, 1.9678207492E+01, 1.5204673272E+01, 1.7778091612E+00, 1.4725871428E+00, 6.6664190548E-01],
	[1.4825000000E+04, 1.9687352275E+01, 1.5203783359E+01, 1.7797079926E+00, 1.4739326216E+00, 6.6677307717E-01],
	[1.4830000000E+04, 1.9696498221E+01, 1.5202893799E+01, 1.7816082094E+00, 1.4752786882E+00, 6.6690422055E-01],
	[1.4835000000E+04, 1.9705645330E+01, 1.5202004591E+01, 1.7835098123E+00, 1.4766253423E+00, 6.6703533560E-01],
	[1.4840000000E+04, 1.9714793604E+01, 1.5201115734E+01, 1.7854128016E+00, 1.4779725837E+00, 6.6716642231E-01],
	[1.4845000000E+04, 1.9723943040E+01, 1.5200227228E+01, 1.7873171781E+00, 1.4793204122E+00, 6.6729748067E-01],
	[1.4850000000E+04, 1.9733093639E+01, 1.5199339074E+01, 1.7892229421E+00, 1.4806688274E+00, 6.6742851066E-01],
	[1.4855000000E+04, 1.9742245401E+01, 1.5198451270E+01, 1.7911300943E+00, 1.4820178290E+00, 6.6755951227E-01],
	[1.4860000000E+04, 1.9751398325E+01, 1.5197563818E+01, 1.7930386352E+00, 1.4833674168E+00, 6.6769048548E-01],
	[1.4865000000E+04, 1.9760552411E+01, 1.5196676715E+01, 1.7949485653E+00, 1.4847175905E+00, 6.6782143028E-01],
	[1.4870000000E+04, 1.9769707659E+01, 1.5195789963E+01, 1.7968598852E+00, 1.4860683499E+00, 6.6795234665E-01],
	[1.4875000000E+04, 1.9778864069E+01, 1.5194903560E+01, 1.7987725954E+00, 1.4874196946E+00, 6.6808323459E-01],
	[1.4880000000E+04, 1.9788021640E+01, 1.5194017507E+01, 1.8006866965E+00, 1.4887716243E+00, 6.6821409407E-01],
	[1.4885000000E+04, 1.9797180373E+01, 1.5193131803E+01, 1.8026021890E+00, 1.4901241389E+00, 6.6834492509E-01],
	[1.4890000000E+04, 1.9806340266E+01, 1.5192246449E+01, 1.8045190734E+00, 1.4914772380E+00, 6.6847572762E-01],
	[1.4895000000E+04, 1.9815501320E+01, 1.5191361443E+01, 1.8064373503E+00, 1.4928309213E+00, 6.6860650166E-01],
	[1.4900000000E+04, 1.9824663535E+01, 1.5190476786E+01, 1.8083570203E+00, 1.4941851886E+00, 6.6873724719E-01],
	[1.4905000000E+04, 1.9833826909E+01, 1.5189592477E+01, 1.8102780838E+00, 1.4955400395E+00, 6.6886796420E-01],
	[1.4910000000E+04, 1.9842991444E+01, 1.5188708516E+01, 1.8122005414E+00, 1.4968954739E+00, 6.6899865267E-01],
	[1.4915000000E+04, 1.9852157138E+01, 1.5187824903E+01, 1.8141243937E+00, 1.4982514913E+00, 6.6912931260E-01],
	[1.4920000000E+04, 1.9861323992E+01, 1.5186941637E+01, 1.8160496412E+00, 1.4996080916E+00, 6.6925994395E-01],
	[1.4925000000E+04, 1.9870492005E+01, 1.5186058719E+01, 1.8179762844E+00, 1.5009652745E+00, 6.6939054673E-01],
	[1.4930000000E+04, 1.9879661178E+01, 1.5185176148E+01, 1.8199043239E+00, 1.5023230396E+00, 6.6952112092E-01],
	[1.4935000000E+04, 1.9888831508E+01, 1.5184293923E+01, 1.8218337603E+00, 1.5036813867E+00, 6.6965166651E-01],
	[1.4940000000E+04, 1.9898002998E+01, 1.5183412046E+01, 1.8237645940E+00, 1.5050403156E+00, 6.6978218347E-01],
	[1.4945000000E+04, 1.9907175645E+01, 1.5182530514E+01, 1.8256968256E+00, 1.5063998259E+00, 6.6991267180E-01],
	[1.4950000000E+04, 1.9916349451E+01, 1.5181649328E+01, 1.8276304556E+00, 1.5077599173E+00, 6.7004313149E-01],
	[1.4955000000E+04, 1.9925524414E+01, 1.5180768489E+01, 1.8295654847E+00, 1.5091205895E+00, 6.7017356252E-01],
	[1.4960000000E+04, 1.9934700535E+01, 1.5179887994E+01, 1.8315019133E+00, 1.5104818424E+00, 6.7030396487E-01],
	[1.4965000000E+04, 1.9943877814E+01, 1.5179007845E+01, 1.8334397420E+00, 1.5118436755E+00, 6.7043433854E-01],
	[1.4970000000E+04, 1.9953056249E+01, 1.5178128041E+01, 1.8353789713E+00, 1.5132060887E+00, 6.7056468351E-01],
	[1.4975000000E+04, 1.9962235841E+01, 1.5177248582E+01, 1.8373196017E+00, 1.5145690816E+00, 6.7069499976E-01],
	[1.4980000000E+04, 1.9971416590E+01, 1.5176369468E+01, 1.8392616339E+00, 1.5159326539E+00, 6.7082528729E-01],
	[1.4985000000E+04, 1.9980598495E+01, 1.5175490697E+01, 1.8412050683E+00, 1.5172968054E+00, 6.7095554608E-01],
	[1.4990000000E+04, 1.9989781556E+01, 1.5174612271E+01, 1.8431499055E+00, 1.5186615357E+00, 6.7108577611E-01],
	[1.4995000000E+04, 1.9998965773E+01, 1.5173734188E+01, 1.8450961461E+00, 1.5200268446E+00, 6.7121597738E-01],
	[1.5000000000E+04, 2.0008151146E+01, 1.5172856449E+01, 1.8470437905E+00, 1.5213927319E+00, 6.7134614987E-01],
	[1.5005000000E+04, 2.0017337674E+01, 1.5171979053E+01, 1.8489986551E+00, 1.5227631416E+00, 6.7147629357E-01],
	[1.5010000000E+04, 2.0026525357E+01, 1.5171102001E+01, 1.8509549352E+00, 1.5241341338E+00, 6.7160640845E-01],
	[1.5015000000E+04, 2.0035714196E+01, 1.5170225291E+01, 1.8529126312E+00, 1.5255057080E+00, 6.7173649452E-01],
	[1.5020000000E+04, 2.0044904188E+01, 1.5169348923E+01, 1.8548717439E+00, 1.5268778640E+00, 6.7186655176E-01],
	[1.5025000000E+04, 2.0054095336E+01, 1.5168472898E+01, 1.8568322736E+00, 1.5282506015E+00, 6.7199658015E-01],
	[1.5030000000E+04, 2.0063287637E+01, 1.5167597215E+01, 1.8587942210E+00, 1.5296239202E+00, 6.7212657968E-01],
	[1.5035000000E+04, 2.0072481092E+01, 1.5166721874E+01, 1.8607575867E+00, 1.5309978198E+00, 6.7225655034E-01],
	[1.5040000000E+04, 2.0081675701E+01, 1.5165846874E+01, 1.8627223710E+00, 1.5323723000E+00, 6.7238649212E-01],
	[1.5045000000E+04, 2.0090871464E+01, 1.5164972216E+01, 1.8646885748E+00, 1.5337473606E+00, 6.7251640499E-01],
	[1.5050000000E+04, 2.0100068380E+01, 1.5164097898E+01, 1.8666561983E+00, 1.5351230011E+00, 6.7264628896E-01],
	[1.5055000000E+04, 2.0109292633E+01, 1.5163241055E+01, 1.8686252424E+00, 1.5364995503E+00, 6.7277614400E-01],
	[1.5060000000E+04, 2.0118518831E+01, 1.5162385054E+01, 1.8705957073E+00, 1.5378766896E+00, 6.7290597008E-01],
	[1.5065000000E+04, 2.0127746198E+01, 1.5161529384E+01, 1.8725675939E+00, 1.5392544090E+00, 6.7303576718E-01],
	[1.5070000000E+04, 2.0136974732E+01, 1.5160674047E+01, 1.8745409024E+00, 1.5406327083E+00, 6.7316553528E-01],
	[1.5075000000E+04, 2.0146204435E+01, 1.5159819041E+01, 1.8765156337E+00, 1.5420115871E+00, 6.7329527437E-01],
	[1.5080000000E+04, 2.0155435305E+01, 1.5158964368E+01, 1.8784917881E+00, 1.5433910453E+00, 6.7342498443E-01],
	[1.5085000000E+04, 2.0164667342E+01, 1.5158110026E+01, 1.8804693662E+00, 1.5447710823E+00, 6.7355466545E-01],
	[1.5090000000E+04, 2.0173900546E+01, 1.5157256015E+01, 1.8824483686E+00, 1.5461516981E+00, 6.7368431740E-01],
	[1.5095000000E+04, 2.0183134917E+01, 1.5156402335E+01, 1.8844287959E+00, 1.5475328923E+00, 6.7381394027E-01],
	[1.5100000000E+04, 2.0192370454E+01, 1.5155548986E+01, 1.8864106486E+00, 1.5489146645E+00, 6.7394353405E-01],
	[1.5105000000E+04, 2.0201607158E+01, 1.5154695968E+01, 1.8883939272E+00, 1.5502970146E+00, 6.7407309871E-01],
	[1.5110000000E+04, 2.0210845028E+01, 1.5153843280E+01, 1.8903786323E+00, 1.5516799421E+00, 6.7420263424E-01],
	[1.5115000000E+04, 2.0220084064E+01, 1.5152990921E+01, 1.8923647644E+00, 1.5530634469E+00, 6.7433214062E-01],
	[1.5120000000E+04, 2.0229324266E+01, 1.5152138893E+01, 1.8943523241E+00, 1.5544475286E+00, 6.7446161784E-01],
	[1.5125000000E+04, 2.0238565633E+01, 1.5151287194E+01, 1.8963413120E+00, 1.5558321869E+00, 6.7459106588E-01],
	[1.5130000000E+04, 2.0247808165E+01, 1.5150435825E+01, 1.8983317286E+00, 1.5572174215E+00, 6.7472048472E-01],
	[1.5135000000E+04, 2.0257051862E+01, 1.5149584785E+01, 1.9003235745E+00, 1.5586032322E+00, 6.7484987435E-01],
	[1.5140000000E+04, 2.0266296723E+01, 1.5148734074E+01, 1.9023168502E+00, 1.5599896186E+00, 6.7497923475E-01],
	[1.5145000000E+04, 2.0275542749E+01, 1.5147883691E+01, 1.9043115562E+00, 1.5613765804E+00, 6.7510856590E-01],
	[1.5150000000E+04, 2.0284789940E+01, 1.5147033637E+01, 1.9063076931E+00, 1.5627641174E+00, 6.7523786778E-01],
	[1.5155000000E+04, 2.0294038294E+01, 1.5146183911E+01, 1.9083052615E+00, 1.5641522292E+00, 6.7536714039E-01],
	[1.5160000000E+04, 2.0303287812E+01, 1.5145334512E+01, 1.9103042619E+00, 1.5655409156E+00, 6.7549638370E-01],
	[1.5165000000E+04, 2.0312538493E+01, 1.5144485442E+01, 1.9123046949E+00, 1.5669301762E+00, 6.7562559770E-01],
	[1.5170000000E+04, 2.0321790338E+01, 1.5143636699E+01, 1.9143065610E+00, 1.5683200108E+00, 6.7575478237E-01],
	[1.5175000000E+04, 2.0331043346E+01, 1.5142788283E+01, 1.9163098608E+00, 1.5697104190E+00, 6.7588393769E-01],
	[1.5180000000E+04, 2.0340297516E+01, 1.5141940195E+01, 1.9183145949E+00, 1.5711014005E+00, 6.7601306366E-01],
	[1.5185000000E+04, 2.0349552849E+01, 1.5141092433E+01, 1.9203207637E+00, 1.5724929552E+00, 6.7614216024E-01],
	[1.5190000000E+04, 2.0358809345E+01, 1.5140244997E+01, 1.9223283678E+00, 1.5738850825E+00, 6.7627122743E-01],
	[1.5195000000E+04, 2.0368067002E+01, 1.5139397888E+01, 1.9243374078E+00, 1.5752777823E+00, 6.7640026521E-01],
	[1.5200000000E+04, 2.0377325821E+01, 1.5138551105E+01, 1.9263478843E+00, 1.5766710543E+00, 6.7652927357E-01],
	[1.5205000000E+04, 2.0386585802E+01, 1.5137704648E+01, 1.9283597977E+00, 1.5780648981E+00, 6.7665825248E-01],
	[1.5210000000E+04, 2.0395846944E+01, 1.5136858517E+01, 1.9303731487E+00, 1.5794593135E+00, 6.7678720194E-01],
	[1.5215000000E+04, 2.0405109248E+01, 1.5136012710E+01, 1.9323879378E+00, 1.5808543002E+00, 6.7691612192E-01],
	[1.5220000000E+04, 2.0414372712E+01, 1.5135167229E+01, 1.9344041655E+00, 1.5822498577E+00, 6.7704501241E-01],
	[1.5225000000E+04, 2.0423637336E+01, 1.5134322073E+01, 1.9364218324E+00, 1.5836459859E+00, 6.7717387339E-01],
	[1.5230000000E+04, 2.0432903122E+01, 1.5133477242E+01, 1.9384409391E+00, 1.5850426845E+00, 6.7730270485E-01],
	[1.5235000000E+04, 2.0442170067E+01, 1.5132632735E+01, 1.9404614861E+00, 1.5864399531E+00, 6.7743150678E-01],
	[1.5240000000E+04, 2.0451438172E+01, 1.5131788552E+01, 1.9424834740E+00, 1.5878377914E+00, 6.7756027915E-01],
	[1.5245000000E+04, 2.0460707437E+01, 1.5130944693E+01, 1.9445069033E+00, 1.5892361992E+00, 6.7768902195E-01],
	[1.5250000000E+04, 2.0469977862E+01, 1.5130101158E+01, 1.9465317745E+00, 1.5906351761E+00, 6.7781773516E-01],
	[1.5255000000E+04, 2.0479249446E+01, 1.5129257947E+01, 1.9485580883E+00, 1.5920347218E+00, 6.7794641877E-01],
	[1.5260000000E+04, 2.0488522188E+01, 1.5128415058E+01, 1.9505858451E+00, 1.5934348361E+00, 6.7807507277E-01],
	[1.5265000000E+04, 2.0497796090E+01, 1.5127572493E+01, 1.9526150456E+00, 1.5948355185E+00, 6.7820369714E-01],
	[1.5270000000E+04, 2.0507071150E+01, 1.5126730251E+01, 1.9546456902E+00, 1.5962367689E+00, 6.7833229185E-01],
	[1.5275000000E+04, 2.0516347368E+01, 1.5125888331E+01, 1.9566777796E+00, 1.5976385869E+00, 6.7846085691E-01],
	[1.5280000000E+04, 2.0525624745E+01, 1.5125046734E+01, 1.9587113142E+00, 1.5990409721E+00, 6.7858939228E-01],
	[1.5285000000E+04, 2.0534903279E+01, 1.5124205459E+01, 1.9607462947E+00, 1.6004439244E+00, 6.7871789796E-01],
	[1.5290000000E+04, 2.0544182971E+01, 1.5123364505E+01, 1.9627827216E+00, 1.6018474434E+00, 6.7884637393E-01],
	[1.5295000000E+04, 2.0553478345E+01, 1.5122532780E+01, 1.9648205954E+00, 1.6032517172E+00, 6.7897482017E-01],
	[1.5300000000E+04, 2.0562788632E+01, 1.5121709796E+01, 1.9668599168E+00, 1.6046567362E+00, 6.7910323667E-01],
	[1.5305000000E+04, 2.0572100092E+01, 1.5120887125E+01, 1.9689006861E+00, 1.6060623219E+00, 6.7923162342E-01],
	[1.5310000000E+04, 2.0581412726E+01, 1.5120064769E+01, 1.9709429041E+00, 1.6074684742E+00, 6.7935998039E-01],
	[1.5315000000E+04, 2.0590726532E+01, 1.5119242725E+01, 1.9729865713E+00, 1.6088751927E+00, 6.7948830758E-01],
	[1.5320000000E+04, 2.0600041510E+01, 1.5118420994E+01, 1.9750316881E+00, 1.6102824770E+00, 6.7961660496E-01],
	[1.5325000000E+04, 2.0609357661E+01, 1.5117599577E+01, 1.9770782552E+00, 1.6116903269E+00, 6.7974487252E-01],
	[1.5330000000E+04, 2.0618674984E+01, 1.5116778471E+01, 1.9791262731E+00, 1.6130987421E+00, 6.7987311026E-01],
	[1.5335000000E+04, 2.0627993478E+01, 1.5115957678E+01, 1.9811757425E+00, 1.6145077222E+00, 6.8000131814E-01],
	[1.5340000000E+04, 2.0637313144E+01, 1.5115137198E+01, 1.9832266637E+00, 1.6159172670E+00, 6.8012949617E-01],
	[1.5345000000E+04, 2.0646633982E+01, 1.5114317029E+01, 1.9852790374E+00, 1.6173273761E+00, 6.8025764431E-01],
	[1.5350000000E+04, 2.0655955990E+01, 1.5113497172E+01, 1.9873328641E+00, 1.6187380492E+00, 6.8038576256E-01],
	[1.5355000000E+04, 2.0665279170E+01, 1.5112677626E+01, 1.9893881444E+00, 1.6201492860E+00, 6.8051385090E-01],
	[1.5360000000E+04, 2.0674603520E+01, 1.5111858391E+01, 1.9914448789E+00, 1.6215610863E+00, 6.8064190932E-01],
	[1.5365000000E+04, 2.0683929040E+01, 1.5111039468E+01, 1.9935030681E+00, 1.6229734496E+00, 6.8076993780E-01],
	[1.5370000000E+04, 2.0693255731E+01, 1.5110220855E+01, 1.9955627125E+00, 1.6243863758E+00, 6.8089793633E-01],
	[1.5375000000E+04, 2.0702583592E+01, 1.5109402553E+01, 1.9976238127E+00, 1.6257998644E+00, 6.8102590489E-01],
	[1.5380000000E+04, 2.0711912622E+01, 1.5108584561E+01, 1.9996863692E+00, 1.6272139151E+00, 6.8115384346E-01],
	[1.5385000000E+04, 2.0721242822E+01, 1.5107766880E+01, 2.0017503827E+00, 1.6286285278E+00, 6.8128175204E-01],
	[1.5390000000E+04, 2.0730574191E+01, 1.5106949508E+01, 2.0038158536E+00, 1.6300437019E+00, 6.8140963061E-01],
	[1.5395000000E+04, 2.0739906729E+01, 1.5106132446E+01, 2.0058827825E+00, 1.6314594373E+00, 6.8153747915E-01],
	[1.5400000000E+04, 2.0749240435E+01, 1.5105315694E+01, 2.0079511700E+00, 1.6328757336E+00, 6.8166529764E-01],
	[1.5405000000E+04, 2.0758575311E+01, 1.5104499251E+01, 2.0100210167E+00, 1.6342925905E+00, 6.8179308608E-01],
	[1.5410000000E+04, 2.0767911354E+01, 1.5103683116E+01, 2.0120923230E+00, 1.6357100077E+00, 6.8192084445E-01],
	[1.5415000000E+04, 2.0777248566E+01, 1.5102867291E+01, 2.0141650895E+00, 1.6371279849E+00, 6.8204857273E-01],
	[1.5420000000E+04, 2.0786586945E+01, 1.5102051775E+01, 2.0162393168E+00, 1.6385465218E+00, 6.8217627091E-01],
	[1.5425000000E+04, 2.0795926492E+01, 1.5101236566E+01, 2.0183150055E+00, 1.6399656179E+00, 6.8230393898E-01],
	[1.5430000000E+04, 2.0805267206E+01, 1.5100421666E+01, 2.0203921560E+00, 1.6413852732E+00, 6.8243157691E-01],
	[1.5435000000E+04, 2.0814609088E+01, 1.5099607074E+01, 2.0224707690E+00, 1.6428054871E+00, 6.8255918471E-01],
	[1.5440000000E+04, 2.0823952136E+01, 1.5098792790E+01, 2.0245508450E+00, 1.6442262595E+00, 6.8268676234E-01],
	[1.5445000000E+04, 2.0833296351E+01, 1.5097978813E+01, 2.0266323846E+00, 1.6456475899E+00, 6.8281430980E-01],
	[1.5450000000E+04, 2.0842641733E+01, 1.5097165144E+01, 2.0287153883E+00, 1.6470694781E+00, 6.8294182707E-01],
	[1.5455000000E+04, 2.0851988281E+01, 1.5096351781E+01, 2.0307998566E+00, 1.6484919238E+00, 6.8306931414E-01],
	[1.5460000000E+04, 2.0861335994E+01, 1.5095538726E+01, 2.0328857901E+00, 1.6499149265E+00, 6.8319677100E-01],
	[1.5465000000E+04, 2.0870684874E+01, 1.5094725977E+01, 2.0349731894E+00, 1.6513384862E+00, 6.8332419762E-01],
	[1.5470000000E+04, 2.0880034919E+01, 1.5093913535E+01, 2.0370620551E+00, 1.6527626023E+00, 6.8345159400E-01],
	[1.5475000000E+04, 2.0889386129E+01, 1.5093101399E+01, 2.0391523876E+00, 1.6541872746E+00, 6.8357896012E-01],
	[1.5480000000E+04, 2.0898738504E+01, 1.5092289569E+01, 2.0412441876E+00, 1.6556125028E+00, 6.8370629597E-01],
	[1.5485000000E+04, 2.0908092044E+01, 1.5091478044E+01, 2.0433374555E+00, 1.6570382865E+00, 6.8383360153E-01],
	[1.5490000000E+04, 2.0917446749E+01, 1.5090666826E+01, 2.0454321920E+00, 1.6584646255E+00, 6.8396087679E-01],
	[1.5495000000E+04, 2.0926802618E+01, 1.5089855913E+01, 2.0475283976E+00, 1.6598915194E+00, 6.8408812174E-01],
	[1.5500000000E+04, 2.0936159651E+01, 1.5089045305E+01, 2.0496260728E+00, 1.6613189679E+00, 6.8421533635E-01],
	[1.5505000000E+04, 2.0945517848E+01, 1.5088235002E+01, 2.0517252182E+00, 1.6627469706E+00, 6.8434252062E-01],
	[1.5510000000E+04, 2.0954877209E+01, 1.5087425003E+01, 2.0538258344E+00, 1.6641755274E+00, 6.8446967454E-01],
	[1.5515000000E+04, 2.0964237733E+01, 1.5086615310E+01, 2.0559279220E+00, 1.6656046377E+00, 6.8459679808E-01],
	[1.5520000000E+04, 2.0973599420E+01, 1.5085805920E+01, 2.0580314813E+00, 1.6670343014E+00, 6.8472389124E-01],
	[1.5525000000E+04, 2.0982962270E+01, 1.5084996835E+01, 2.0601365132E+00, 1.6684645180E+00, 6.8485095400E-01],
	[1.5530000000E+04, 2.0992326283E+01, 1.5084188053E+01, 2.0622430179E+00, 1.6698952874E+00, 6.8497798634E-01],
	[1.5535000000E+04, 2.1001691459E+01, 1.5083379576E+01, 2.0643509963E+00, 1.6713266091E+00, 6.8510498826E-01],
	[1.5540000000E+04, 2.1011065978E+01, 1.5082576109E+01, 2.0664604487E+00, 1.6727585925E+00, 6.8523195974E-01],
	[1.5545000000E+04, 2.1020463092E+01, 1.5081785265E+01, 2.0685713757E+00, 1.6741914158E+00, 6.8535890077E-01],
	[1.5550000000E+04, 2.1029861384E+01, 1.5080994717E+01, 2.0706837780E+00, 1.6756247915E+00, 6.8548581132E-01],
	[1.5555000000E+04, 2.1039260855E+01, 1.5080204464E+01, 2.0727976560E+00, 1.6770587194E+00, 6.8561269140E-01],
	[1.5560000000E+04, 2.1048661504E+01, 1.5079414507E+01, 2.0749130103E+00, 1.6784931991E+00, 6.8573954098E-01],
	[1.5565000000E+04, 2.1058063331E+01, 1.5078624845E+01, 2.0770298415E+00, 1.6799282303E+00, 6.8586636005E-01],
	[1.5570000000E+04, 2.1067466336E+01, 1.5077835478E+01, 2.0791481501E+00, 1.6813638127E+00, 6.8599314860E-01],
	[1.5575000000E+04, 2.1076870519E+01, 1.5077046405E+01, 2.0812679366E+00, 1.6827999460E+00, 6.8611990661E-01],
	[1.5580000000E+04, 2.1086275879E+01, 1.5076257628E+01, 2.0833892017E+00, 1.6842366298E+00, 6.8624663407E-01],
	[1.5585000000E+04, 2.1095682416E+01, 1.5075469144E+01, 2.0855119459E+00, 1.6856738639E+00, 6.8637333097E-01],
	[1.5590000000E+04, 2.1105090129E+01, 1.5074680955E+01, 2.0876361697E+00, 1.6871116478E+00, 6.8649999729E-01],
	[1.5595000000E+04, 2.1114499020E+01, 1.5073893060E+01, 2.0897618737E+00, 1.6885499813E+00, 6.8662663303E-01],
	[1.5600000000E+04, 2.1123909087E+01, 1.5073105458E+01, 2.0918890584E+00, 1.6899888641E+00, 6.8675323816E-01],
	[1.5605000000E+04, 2.1133320330E+01, 1.5072318150E+01, 2.0940177245E+00, 1.6914282958E+00, 6.8687981267E-01],
	[1.5610000000E+04, 2.1142732749E+01, 1.5071531135E+01, 2.0961478724E+00, 1.6928682760E+00, 6.8700635656E-01],
	[1.5615000000E+04, 2.1152146344E+01, 1.5070744413E+01, 2.0982795027E+00, 1.6943088046E+00, 6.8713286980E-01],
	[1.5620000000E+04, 2.1161561114E+01, 1.5069957985E+01, 2.1004126160E+00, 1.6957498811E+00, 6.8725935238E-01],
	[1.5625000000E+04, 2.1170977060E+01, 1.5069171849E+01, 2.1025472128E+00, 1.6971915052E+00, 6.8738580430E-01],
	[1.5630000000E+04, 2.1180394180E+01, 1.5068386005E+01, 2.1046832936E+00, 1.6986336767E+00, 6.8751222553E-01],
	[1.5635000000E+04, 2.1189812476E+01, 1.5067600454E+01, 2.1068208591E+00, 1.7000763951E+00, 6.8763861607E-01],
	[1.5640000000E+04, 2.1199231946E+01, 1.5066815195E+01, 2.1089599098E+00, 1.7015196601E+00, 6.8776497590E-01],
	[1.5645000000E+04, 2.1208652590E+01, 1.5066030228E+01, 2.1111004463E+00, 1.7029634715E+00, 6.8789130501E-01],
	[1.5650000000E+04, 2.1218074409E+01, 1.5065245552E+01, 2.1132424690E+00, 1.7044078288E+00, 6.8801760338E-01],
	[1.5655000000E+04, 2.1227497401E+01, 1.5064461168E+01, 2.1153859786E+00, 1.7058527318E+00, 6.8814387100E-01],
	[1.5660000000E+04, 2.1236921567E+01, 1.5063677076E+01, 2.1175309756E+00, 1.7072981802E+00, 6.8827010786E-01],
	[1.5665000000E+04, 2.1246346907E+01, 1.5062893274E+01, 2.1196774606E+00, 1.7087441735E+00, 6.8839631395E-01],
	[1.5670000000E+04, 2.1255773420E+01, 1.5062109763E+01, 2.1218254341E+00, 1.7101907116E+00, 6.8852248925E-01],
	[1.5675000000E+04, 2.1265201105E+01, 1.5061326543E+01, 2.1239748966E+00, 1.7116377939E+00, 6.8864863375E-01],
	[1.5680000000E+04, 2.1274629964E+01, 1.5060543614E+01, 2.1261258488E+00, 1.7130854203E+00, 6.8877474744E-01],
	[1.5685000000E+04, 2.1284059995E+01, 1.5059760975E+01, 2.1282782912E+00, 1.7145335904E+00, 6.8890083031E-01],
	[1.5690000000E+04, 2.1293491198E+01, 1.5058978626E+01, 2.1304322243E+00, 1.7159823039E+00, 6.8902688233E-01],
	[1.5695000000E+04, 2.1302923573E+01, 1.5058196566E+01, 2.1325876487E+00, 1.7174315604E+00, 6.8915290351E-01],
	[1.5700000000E+04, 2.1312357121E+01, 1.5057414797E+01, 2.1347445650E+00, 1.7188813595E+00, 6.8927889382E-01],
	[1.5705000000E+04, 2.1321791839E+01, 1.5056633317E+01, 2.1369029737E+00, 1.7203317011E+00, 6.8940485325E-01],
	[1.5710000000E+04, 2.1331227730E+01, 1.5055852126E+01, 2.1390628753E+00, 1.7217825847E+00, 6.8953078180E-01],
	[1.5715000000E+04, 2.1340664791E+01, 1.5055071225E+01, 2.1412242704E+00, 1.7232340100E+00, 6.8965667944E-01],
	[1.5720000000E+04, 2.1350103023E+01, 1.5054290612E+01, 2.1433871597E+00, 1.7246859767E+00, 6.8978254617E-01],
	[1.5725000000E+04, 2.1359542426E+01, 1.5053510288E+01, 2.1455515435E+00, 1.7261384844E+00, 6.8990838198E-01],
	[1.5730000000E+04, 2.1368983000E+01, 1.5052730253E+01, 2.1477174226E+00, 1.7275915328E+00, 6.9003418684E-01],
	[1.5735000000E+04, 2.1378424743E+01, 1.5051950506E+01, 2.1498847974E+00, 1.7290451216E+00, 6.9015996075E-01],
	[1.5740000000E+04, 2.1387867657E+01, 1.5051171046E+01, 2.1520536685E+00, 1.7304992505E+00, 6.9028570370E-01],
	[1.5745000000E+04, 2.1397311741E+01, 1.5050391875E+01, 2.1542240364E+00, 1.7319539190E+00, 6.9041141567E-01],
	[1.5750000000E+04, 2.1406756994E+01, 1.5049612992E+01, 2.1563959018E+00, 1.7334091270E+00, 6.9053709666E-01],
	[1.5755000000E+04, 2.1416203416E+01, 1.5048834396E+01, 2.1585692651E+00, 1.7348648740E+00, 6.9066274664E-01],
	[1.5760000000E+04, 2.1425651008E+01, 1.5048056087E+01, 2.1607441269E+00, 1.7363211597E+00, 6.9078836560E-01],
	[1.5765000000E+04, 2.1435099768E+01, 1.5047278066E+01, 2.1629204879E+00, 1.7377779838E+00, 6.9091395355E-01],
	[1.5770000000E+04, 2.1444549698E+01, 1.5046500331E+01, 2.1650983484E+00, 1.7392353459E+00, 6.9103951045E-01],
	[1.5775000000E+04, 2.1454000795E+01, 1.5045722883E+01, 2.1672777092E+00, 1.7406932457E+00, 6.9116503630E-01],
	[1.5780000000E+04, 2.1463453061E+01, 1.5044945722E+01, 2.1694585707E+00, 1.7421516829E+00, 6.9129053109E-01],
	[1.5785000000E+04, 2.1472906495E+01, 1.5044168847E+01, 2.1716409334E+00, 1.7436106572E+00, 6.9141599481E-01],
	[1.5790000000E+04, 2.1482368720E+01, 1.5043396380E+01, 2.1738247981E+00, 1.7450702739E+00, 6.9154142744E-01],
	[1.5795000000E+04, 2.1491855457E+01, 1.5042636810E+01, 2.1760101652E+00, 1.7465307514E+00, 6.9166682897E-01],
	[1.5800000000E+04, 2.1501343378E+01, 1.5041877518E+01, 2.1781970352E+00, 1.7479917661E+00, 6.9179219939E-01],
	[1.5805000000E+04, 2.1510832485E+01, 1.5041118505E+01, 2.1803854088E+00, 1.7494533176E+00, 6.9191753868E-01],
	[1.5810000000E+04, 2.1520322775E+01, 1.5040359770E+01, 2.1825752864E+00, 1.7509154056E+00, 6.9204284684E-01],
	[1.5815000000E+04, 2.1529814250E+01, 1.5039601313E+01, 2.1847666687E+00, 1.7523780298E+00, 6.9216812386E-01],
	[1.5820000000E+04, 2.1539306908E+01, 1.5038843135E+01, 2.1869595562E+00, 1.7538411898E+00, 6.9229336971E-01],
	[1.5825000000E+04, 2.1548800751E+01, 1.5038085234E+01, 2.1891539494E+00, 1.7553048854E+00, 6.9241858440E-01],
	[1.5830000000E+04, 2.1558295776E+01, 1.5037327611E+01, 2.1913498489E+00, 1.7567691160E+00, 6.9254376790E-01],
	[1.5835000000E+04, 2.1567791985E+01, 1.5036570265E+01, 2.1935472553E+00, 1.7582338815E+00, 6.9266892020E-01],
	[1.5840000000E+04, 2.1577289377E+01, 1.5035813196E+01, 2.1957461692E+00, 1.7596991815E+00, 6.9279404130E-01],
	[1.5845000000E+04, 2.1586787952E+01, 1.5035056405E+01, 2.1979465910E+00, 1.7611650156E+00, 6.9291913119E-01],
	[1.5850000000E+04, 2.1596287709E+01, 1.5034299890E+01, 2.2001485213E+00, 1.7626313835E+00, 6.9304418984E-01],
	[1.5855000000E+04, 2.1605788649E+01, 1.5033543652E+01, 2.2023519607E+00, 1.7640982849E+00, 6.9316921725E-01],
	[1.5860000000E+04, 2.1615290770E+01, 1.5032787691E+01, 2.2045569098E+00, 1.7655657195E+00, 6.9329421340E-01],
	[1.5865000000E+04, 2.1624794074E+01, 1.5032032005E+01, 2.2067633691E+00, 1.7670336868E+00, 6.9341917829E-01],
	[1.5870000000E+04, 2.1634298559E+01, 1.5031276596E+01, 2.2089713391E+00, 1.7685021865E+00, 6.9354411191E-01],
	[1.5875000000E+04, 2.1643804226E+01, 1.5030521463E+01, 2.2111808204E+00, 1.7699712184E+00, 6.9366901424E-01],
	[1.5880000000E+04, 2.1653311073E+01, 1.5029766605E+01, 2.2133918137E+00, 1.7714407821E+00, 6.9379388526E-01],
	[1.5885000000E+04, 2.1662819102E+01, 1.5029012023E+01, 2.2156043193E+00, 1.7729108771E+00, 6.9391872498E-01],
	[1.5890000000E+04, 2.1672328311E+01, 1.5028257717E+01, 2.2178183380E+00, 1.7743815033E+00, 6.9404353337E-01],
	[1.5895000000E+04, 2.1681838701E+01, 1.5027503685E+01, 2.2200338701E+00, 1.7758526602E+00, 6.9416831043E-01],
	[1.5900000000E+04, 2.1691350271E+01, 1.5026749929E+01, 2.2222509164E+00, 1.7773243475E+00, 6.9429305614E-01],
	[1.5905000000E+04, 2.1700863022E+01, 1.5025996447E+01, 2.2244694774E+00, 1.7787965649E+00, 6.9441777050E-01],
	[1.5910000000E+04, 2.1710376952E+01, 1.5025243240E+01, 2.2266895535E+00, 1.7802693120E+00, 6.9454245349E-01],
	[1.5915000000E+04, 2.1719892061E+01, 1.5024490307E+01, 2.2289111454E+00, 1.7817425886E+00, 6.9466710509E-01],
	[1.5920000000E+04, 2.1729408350E+01, 1.5023737648E+01, 2.2311342537E+00, 1.7832163941E+00, 6.9479172531E-01],
	[1.5925000000E+04, 2.1738925819E+01, 1.5022985264E+01, 2.2333588788E+00, 1.7846907283E+00, 6.9491631412E-01],
	[1.5930000000E+04, 2.1748444466E+01, 1.5022233153E+01, 2.2355850214E+00, 1.7861655909E+00, 6.9504087152E-01],
	[1.5935000000E+04, 2.1757964292E+01, 1.5021481316E+01, 2.2378126819E+00, 1.7876409816E+00, 6.9516539750E-01],
	[1.5940000000E+04, 2.1767485296E+01, 1.5020729753E+01, 2.2400418611E+00, 1.7891168998E+00, 6.9528989204E-01],
	[1.5945000000E+04, 2.1777007479E+01, 1.5019978462E+01, 2.2422725593E+00, 1.7905933454E+00, 6.9541435513E-01],
	[1.5950000000E+04, 2.1786530839E+01, 1.5019227445E+01, 2.2445047772E+00, 1.7920703180E+00, 6.9553878676E-01],
	[1.5955000000E+04, 2.1796055378E+01, 1.5018476701E+01, 2.2467385153E+00, 1.7935478173E+00, 6.9566318693E-01],
	[1.5960000000E+04, 2.1805581094E+01, 1.5017726230E+01, 2.2489737743E+00, 1.7950258428E+00, 6.9578755561E-01],
	[1.5965000000E+04, 2.1815107987E+01, 1.5016976031E+01, 2.2512105545E+00, 1.7965043942E+00, 6.9591189281E-01],
	[1.5970000000E+04, 2.1824636058E+01, 1.5016226104E+01, 2.2534488567E+00, 1.7979834713E+00, 6.9603619849E-01],
	[1.5975000000E+04, 2.1834165305E+01, 1.5015476450E+01, 2.2556886813E+00, 1.7994630736E+00, 6.9616047265E-01],
	[1.5980000000E+04, 2.1843695730E+01, 1.5014727068E+01, 2.2579300289E+00, 1.8009432009E+00, 6.9628471526E-01],
	[1.5985000000E+04, 2.1853227330E+01, 1.5013977957E+01, 2.2601729001E+00, 1.8024238527E+00, 6.9640892632E-01],
	[1.5990000000E+04, 2.1862760107E+01, 1.5013229118E+01, 2.2624172954E+00, 1.8039050287E+00, 6.9653310581E-01],
	[1.5995000000E+04, 2.1872294060E+01, 1.5012480551E+01, 2.2646632154E+00, 1.8053867286E+00, 6.9665725372E-01],
	[1.6000000000E+04, 2.1881829189E+01, 1.5011732255E+01, 2.2669106606E+00, 1.8068689520E+00, 6.9678137003E-01],
	[1.6005000000E+04, 2.1891365493E+01, 1.5010984230E+01, 2.2691596316E+00, 1.8083516986E+00, 6.9690545473E-01],
	[1.6010000000E+04, 2.1900902973E+01, 1.5010236475E+01, 2.2714101290E+00, 1.8098349681E+00, 6.9702950780E-01],
	[1.6015000000E+04, 2.1910441628E+01, 1.5009488992E+01, 2.2736621533E+00, 1.8113187600E+00, 6.9715352924E-01],
	[1.6020000000E+04, 2.1919981458E+01, 1.5008741779E+01, 2.2759157051E+00, 1.8128030740E+00, 6.9727751903E-01],
	[1.6025000000E+04, 2.1929522462E+01, 1.5007994837E+01, 2.2781707849E+00, 1.8142879099E+00, 6.9740147715E-01],
	[1.6030000000E+04, 2.1939064641E+01, 1.5007248164E+01, 2.2804273933E+00, 1.8157732671E+00, 6.9752540359E-01],
	[1.6035000000E+04, 2.1948607995E+01, 1.5006501762E+01, 2.2826855308E+00, 1.8172591455E+00, 6.9764929834E-01],
	[1.6040000000E+04, 2.1958152522E+01, 1.5005755629E+01, 2.2849451980E+00, 1.8187455446E+00, 6.9777316138E-01],
	[1.6045000000E+04, 2.1967711502E+01, 1.5005016522E+01, 2.2872063955E+00, 1.8202326547E+00, 6.9789699270E-01],
	[1.6050000000E+04, 2.1977290720E+01, 1.5004287371E+01, 2.2894691238E+00, 1.8217205591E+00, 6.9802079229E-01],
	[1.6055000000E+04, 2.1986871129E+01, 1.5003558483E+01, 2.2917333834E+00, 1.8232089844E+00, 6.9814456014E-01],
	[1.6060000000E+04, 2.1996452730E+01, 1.5002829857E+01, 2.2939991750E+00, 1.8246979302E+00, 6.9826829622E-01],
	[1.6065000000E+04, 2.2006035522E+01, 1.5002101493E+01, 2.2962664991E+00, 1.8261873962E+00, 6.9839200053E-01],
	[1.6070000000E+04, 2.2015619504E+01, 1.5001373391E+01, 2.2985353563E+00, 1.8276773821E+00, 6.9851567305E-01],
	[1.6075000000E+04, 2.2025204677E+01, 1.5000645551E+01, 2.3008057470E+00, 1.8291678875E+00, 6.9863931378E-01],
	[1.6080000000E+04, 2.2034791040E+01, 1.4999917973E+01, 2.3030776719E+00, 1.8306589120E+00, 6.9876292269E-01],
	[1.6085000000E+04, 2.2044378594E+01, 1.4999190656E+01, 2.3053511315E+00, 1.8321504553E+00, 6.9888649977E-01],
	[1.6090000000E+04, 2.2053967337E+01, 1.4998463600E+01, 2.3076261264E+00, 1.8336425171E+00, 6.9901004502E-01],
	[1.6095000000E+04, 2.2063557270E+01, 1.4997736806E+01, 2.3099026571E+00, 1.8351350969E+00, 6.9913355841E-01],
	[1.6100000000E+04, 2.2073148393E+01, 1.4997010272E+01, 2.3121807243E+00, 1.8366281945E+00, 6.9925703994E-01],
	[1.6105000000E+04, 2.2082740704E+01, 1.4996284000E+01, 2.3144603283E+00, 1.8381218095E+00, 6.9938048959E-01],
	[1.6110000000E+04, 2.2092334205E+01, 1.4995557987E+01, 2.3167414699E+00, 1.8396159416E+00, 6.9950390734E-01],
	[1.6115000000E+04, 2.2101928894E+01, 1.4994832236E+01, 2.3190241495E+00, 1.8411105903E+00, 6.9962729319E-01],
	[1.6120000000E+04, 2.2111524772E+01, 1.4994106744E+01, 2.3213083678E+00, 1.8426057553E+00, 6.9975064713E-01],
	[1.6125000000E+04, 2.2121121838E+01, 1.4993381513E+01, 2.3235941253E+00, 1.8441014364E+00, 6.9987396913E-01],
	[1.6130000000E+04, 2.2130720093E+01, 1.4992656542E+01, 2.3258814225E+00, 1.8455976331E+00, 6.9999725919E-01],
	[1.6135000000E+04, 2.2140319535E+01, 1.4991931830E+01, 2.3281702600E+00, 1.8470943450E+00, 7.0012051729E-01],
	[1.6140000000E+04, 2.2149920165E+01, 1.4991207378E+01, 2.3304606383E+00, 1.8485915719E+00, 7.0024374343E-01],
	[1.6145000000E+04, 2.2159521982E+01, 1.4990483185E+01, 2.3327525581E+00, 1.8500893134E+00, 7.0036693758E-01],
	[1.6150000000E+04, 2.2169124987E+01, 1.4989759251E+01, 2.3350460198E+00, 1.8515875690E+00, 7.0049009974E-01],
	[1.6155000000E+04, 2.2178729178E+01, 1.4989035577E+01, 2.3373410241E+00, 1.8530863386E+00, 7.0061322989E-01],
	[1.6160000000E+04, 2.2188334557E+01, 1.4988312161E+01, 2.3396375714E+00, 1.8545856216E+00, 7.0073632802E-01],
	[1.6165000000E+04, 2.2197941121E+01, 1.4987589004E+01, 2.3419356624E+00, 1.8560854178E+00, 7.0085939411E-01],
	[1.6170000000E+04, 2.2207548873E+01, 1.4986866106E+01, 2.3442352976E+00, 1.8575857268E+00, 7.0098242816E-01],
	[1.6175000000E+04, 2.2217157810E+01, 1.4986143466E+01, 2.3465364776E+00, 1.8590865483E+00, 7.0110543015E-01],
	[1.6180000000E+04, 2.2226767933E+01, 1.4985421084E+01, 2.3488392029E+00, 1.8605878818E+00, 7.0122840008E-01],
	[1.6185000000E+04, 2.2236379242E+01, 1.4984698960E+01, 2.3511434741E+00, 1.8620897271E+00, 7.0135133791E-01],
	[1.6190000000E+04, 2.2245991737E+01, 1.4983977094E+01, 2.3534492917E+00, 1.8635920837E+00, 7.0147424366E-01],
	[1.6195000000E+04, 2.2255605416E+01, 1.4983255485E+01, 2.3557566563E+00, 1.8650949514E+00, 7.0159711729E-01],
	[1.6200000000E+04, 2.2265220281E+01, 1.4982534134E+01, 2.3580655685E+00, 1.8665983297E+00, 7.0171995881E-01],
	[1.6205000000E+04, 2.2274836330E+01, 1.4981813041E+01, 2.3603760287E+00, 1.8681022183E+00, 7.0184276819E-01],
	[1.6210000000E+04, 2.2284453564E+01, 1.4981092204E+01, 2.3626880377E+00, 1.8696066169E+00, 7.0196554542E-01],
	[1.6215000000E+04, 2.2294071983E+01, 1.4980371625E+01, 2.3650015959E+00, 1.8711115251E+00, 7.0208829050E-01],
	[1.6220000000E+04, 2.2303691585E+01, 1.4979651302E+01, 2.3673167039E+00, 1.8726169425E+00, 7.0221100341E-01],
	[1.6225000000E+04, 2.2313312371E+01, 1.4978931236E+01, 2.3696333622E+00, 1.8741228688E+00, 7.0233368414E-01],
	[1.6230000000E+04, 2.2322934342E+01, 1.4978211426E+01, 2.3719515714E+00, 1.8756293036E+00, 7.0245633267E-01],
	[1.6235000000E+04, 2.2332557495E+01, 1.4977491873E+01, 2.3742713321E+00, 1.8771362465E+00, 7.0257894900E-01],
	[1.6240000000E+04, 2.2342181832E+01, 1.4976772576E+01, 2.3765926448E+00, 1.8786436973E+00, 7.0270153310E-01],
	[1.6245000000E+04, 2.2351807352E+01, 1.4976053535E+01, 2.3789155101E+00, 1.8801516555E+00, 7.0282408498E-01],
	[1.6250000000E+04, 2.2361434055E+01, 1.4975334749E+01, 2.3812399286E+00, 1.8816601207E+00, 7.0294660461E-01],
	[1.6255000000E+04, 2.2371061940E+01, 1.4974616219E+01, 2.3835659007E+00, 1.8831690927E+00, 7.0306909199E-01],
	[1.6260000000E+04, 2.2380691008E+01, 1.4973897945E+01, 2.3858934271E+00, 1.8846785711E+00, 7.0319154710E-01],
	[1.6265000000E+04, 2.2390321258E+01, 1.4973179926E+01, 2.3882225084E+00, 1.8861885555E+00, 7.0331396994E-01],
	[1.6270000000E+04, 2.2399952689E+01, 1.4972462162E+01, 2.3905531450E+00, 1.8876990455E+00, 7.0343636048E-01],
	[1.6275000000E+04, 2.2409585303E+01, 1.4971744653E+01, 2.3928853375E+00, 1.8892100408E+00, 7.0355871872E-01],
	[1.6280000000E+04, 2.2419219098E+01, 1.4971027398E+01, 2.3952190865E+00, 1.8907215410E+00, 7.0368104464E-01],
	[1.6285000000E+04, 2.2428854075E+01, 1.4970310399E+01, 2.3975543926E+00, 1.8922335457E+00, 7.0380333824E-01],
	[1.6290000000E+04, 2.2438490232E+01, 1.4969593654E+01, 2.3998912563E+00, 1.8937460547E+00, 7.0392559950E-01],
	[1.6295000000E+04, 2.2448127570E+01, 1.4968877162E+01, 2.4022296782E+00, 1.8952590675E+00, 7.0404782841E-01],
	[1.6300000000E+04, 2.2457766089E+01, 1.4968160926E+01, 2.4045696588E+00, 1.8967725837E+00, 7.0417002496E-01],
	[1.6305000000E+04, 2.2467431312E+01, 1.4967457175E+01, 2.4069111987E+00, 1.8982869821E+00, 7.0429218914E-01],
	[1.6310000000E+04, 2.2477105933E+01, 1.4966757603E+01, 2.4092542984E+00, 1.8998020060E+00, 7.0441432093E-01],
	[1.6315000000E+04, 2.2486781752E+01, 1.4966058279E+01, 2.4115989586E+00, 1.9013175336E+00, 7.0453642032E-01],
	[1.6320000000E+04, 2.2496458770E+01, 1.4965359201E+01, 2.4139451797E+00, 1.9028335645E+00, 7.0465848731E-01],
	[1.6325000000E+04, 2.2506136986E+01, 1.4964660370E+01, 2.4162929623E+00, 1.9043500984E+00, 7.0478052187E-01],
	[1.6330000000E+04, 2.2515816400E+01, 1.4963961786E+01, 2.4186423071E+00, 1.9058671348E+00, 7.0490252401E-01],
	[1.6335000000E+04, 2.2525497012E+01, 1.4963263448E+01, 2.4209932144E+00, 1.9073846734E+00, 7.0502449370E-01],
	[1.6340000000E+04, 2.2535178821E+01, 1.4962565356E+01, 2.4233456850E+00, 1.9089027138E+00, 7.0514643093E-01],
	[1.6345000000E+04, 2.2544861828E+01, 1.4961867511E+01, 2.4256997194E+00, 1.9104212557E+00, 7.0526833571E-01],
	[1.6350000000E+04, 2.2554546032E+01, 1.4961169912E+01, 2.4280553180E+00, 1.9119402987E+00, 7.0539020800E-01],
	[1.6355000000E+04, 2.2564231432E+01, 1.4960472558E+01, 2.4304124816E+00, 1.9134598425E+00, 7.0551204780E-01],
	[1.6360000000E+04, 2.2573918030E+01, 1.4959775450E+01, 2.4327712105E+00, 1.9149798866E+00, 7.0563385511E-01],
	[1.6365000000E+04, 2.2583605823E+01, 1.4959078588E+01, 2.4351315055E+00, 1.9165004308E+00, 7.0575562990E-01],
	[1.6370000000E+04, 2.2593294813E+01, 1.4958381970E+01, 2.4374933671E+00, 1.9180214746E+00, 7.0587737218E-01],
	[1.6375000000E+04, 2.2602984999E+01, 1.4957685598E+01, 2.4398567957E+00, 1.9195430177E+00, 7.0599908191E-01],
	[1.6380000000E+04, 2.2612676381E+01, 1.4956989471E+01, 2.4422217921E+00, 1.9210650597E+00, 7.0612075911E-01],
	[1.6385000000E+04, 2.2622368959E+01, 1.4956293589E+01, 2.4445883566E+00, 1.9225876003E+00, 7.0624240375E-01],
	[1.6390000000E+04, 2.2632062731E+01, 1.4955597952E+01, 2.4469564900E+00, 1.9241106391E+00, 7.0636401582E-01],
	[1.6395000000E+04, 2.2641757699E+01, 1.4954902559E+01, 2.4493261927E+00, 1.9256341758E+00, 7.0648559531E-01],
	[1.6400000000E+04, 2.2651453862E+01, 1.4954207410E+01, 2.4516974654E+00, 1.9271582099E+00, 7.0660714221E-01],
	[1.6405000000E+04, 2.2661151220E+01, 1.4953512506E+01, 2.4540703085E+00, 1.9286827410E+00, 7.0672865651E-01],
	[1.6410000000E+04, 2.2670849772E+01, 1.4952817846E+01, 2.4564447227E+00, 1.9302077690E+00, 7.0685013820E-01],
	[1.6415000000E+04, 2.2680549518E+01, 1.4952123429E+01, 2.4588207084E+00, 1.9317332933E+00, 7.0697158727E-01],
	[1.6420000000E+04, 2.2690250459E+01, 1.4951429257E+01, 2.4611982663E+00, 1.9332593135E+00, 7.0709300371E-01],
	[1.6425000000E+04, 2.2699952593E+01, 1.4950735327E+01, 2.4635773970E+00, 1.9347858295E+00, 7.0721438750E-01],
	[1.6430000000E+04, 2.2709655921E+01, 1.4950041642E+01, 2.4659581009E+00, 1.9363128406E+00, 7.0733573863E-01],
	[1.6435000000E+04, 2.2719360442E+01, 1.4949348199E+01, 2.4683403786E+00, 1.9378403467E+00, 7.0745705710E-01],
	[1.6440000000E+04, 2.2729066157E+01, 1.4948655000E+01, 2.4707242307E+00, 1.9393683473E+00, 7.0757834290E-01],
	[1.6445000000E+04, 2.2738773064E+01, 1.4947962043E+01, 2.4731096578E+00, 1.9408968421E+00, 7.0769959600E-01],
	[1.6450000000E+04, 2.2748481164E+01, 1.4947269329E+01, 2.4754966604E+00, 1.9424258306E+00, 7.0782081641E-01],
	[1.6455000000E+04, 2.2758190457E+01, 1.4946576858E+01, 2.4778852391E+00, 1.9439553126E+00, 7.0794200411E-01],
	[1.6460000000E+04, 2.2767900942E+01, 1.4945884630E+01, 2.4802753944E+00, 1.9454852877E+00, 7.0806315909E-01],
	[1.6465000000E+04, 2.2777612620E+01, 1.4945192643E+01, 2.4826671269E+00, 1.9470157554E+00, 7.0818428134E-01],
	[1.6470000000E+04, 2.2787325489E+01, 1.4944500899E+01, 2.4850604371E+00, 1.9485467154E+00, 7.0830537084E-01],
	[1.6475000000E+04, 2.2797039550E+01, 1.4943809397E+01, 2.4874553257E+00, 1.9500781674E+00, 7.0842642760E-01],
	[1.6480000000E+04, 2.2806754802E+01, 1.4943118136E+01, 2.4898517931E+00, 1.9516101110E+00, 7.0854745160E-01],
	[1.6485000000E+04, 2.2816471245E+01, 1.4942427117E+01, 2.4922498400E+00, 1.9531425457E+00, 7.0866844282E-01],
	[1.6490000000E+04, 2.2826188880E+01, 1.4941736340E+01, 2.4946494668E+00, 1.9546754713E+00, 7.0878940126E-01],
	[1.6495000000E+04, 2.2835907705E+01, 1.4941045804E+01, 2.4970506742E+00, 1.9562088874E+00, 7.0891032690E-01],
	[1.6500000000E+04, 2.2845627722E+01, 1.4940355509E+01, 2.4994534628E+00, 1.9577427935E+00, 7.0903121975E-01],
	[1.6505000000E+04, 2.2855348928E+01, 1.4939665455E+01, 2.5018578330E+00, 1.9592771894E+00, 7.0915207978E-01],
	[1.6510000000E+04, 2.2865071325E+01, 1.4938975643E+01, 2.5042637854E+00, 1.9608120747E+00, 7.0927290698E-01],
	[1.6515000000E+04, 2.2874794911E+01, 1.4938286070E+01, 2.5066713206E+00, 1.9623474489E+00, 7.0939370135E-01],
	[1.6520000000E+04, 2.2884519687E+01, 1.4937596739E+01, 2.5090804392E+00, 1.9638833117E+00, 7.0951446287E-01],
	[1.6525000000E+04, 2.2894245653E+01, 1.4936907647E+01, 2.5114911417E+00, 1.9654196627E+00, 7.0963519154E-01],
	[1.6530000000E+04, 2.2903972808E+01, 1.4936218796E+01, 2.5139034287E+00, 1.9669565017E+00, 7.0975588734E-01],
	[1.6535000000E+04, 2.2913701153E+01, 1.4935530186E+01, 2.5163173007E+00, 1.9684938281E+00, 7.0987655027E-01],
	[1.6540000000E+04, 2.2923430686E+01, 1.4934841815E+01, 2.5187327583E+00, 1.9700316416E+00, 7.0999718031E-01],
	[1.6545000000E+04, 2.2933161408E+01, 1.4934153683E+01, 2.5211498021E+00, 1.9715699419E+00, 7.1011777746E-01],
	[1.6550000000E+04, 2.2942893318E+01, 1.4933465792E+01, 2.5235684325E+00, 1.9731087285E+00, 7.1023834170E-01],
	[1.6555000000E+04, 2.2952626417E+01, 1.4932778140E+01, 2.5259886503E+00, 1.9746480011E+00, 7.1035887302E-01],
	[1.6560000000E+04, 2.2962360703E+01, 1.4932090727E+01, 2.5284104559E+00, 1.9761877594E+00, 7.1047937142E-01],
	[1.6565000000E+04, 2.2972105710E+01, 1.4931407864E+01, 2.5308338499E+00, 1.9777281492E+00, 7.1059983688E-01],
	[1.6570000000E+04, 2.2981877514E+01, 1.4930736813E+01, 2.5332588328E+00, 1.9792694175E+00, 7.1072026939E-01],
	[1.6575000000E+04, 2.2991650525E+01, 1.4930065994E+01, 2.5356854053E+00, 1.9808111717E+00, 7.1084066895E-01],
	[1.6580000000E+04, 2.3001424743E+01, 1.4929395408E+01, 2.5381135678E+00, 1.9823534113E+00, 7.1096103555E-01],
	[1.6585000000E+04, 2.3011200167E+01, 1.4928725054E+01, 2.5405433210E+00, 1.9838961360E+00, 7.1108136916E-01],
	[1.6590000000E+04, 2.3020976797E+01, 1.4928054932E+01, 2.5429746654E+00, 1.9854393454E+00, 7.1120166980E-01],
	[1.6595000000E+04, 2.3030754633E+01, 1.4927385043E+01, 2.5454076015E+00, 1.9869830391E+00, 7.1132193743E-01],
	[1.6600000000E+04, 2.3040533674E+01, 1.4926715385E+01, 2.5478421300E+00, 1.9885272168E+00, 7.1144217206E-01],
	[1.6605000000E+04, 2.3050313920E+01, 1.4926045959E+01, 2.5502782513E+00, 1.9900718781E+00, 7.1156237368E-01],
	[1.6610000000E+04, 2.3060095372E+01, 1.4925376764E+01, 2.5527159661E+00, 1.9916170225E+00, 7.1168254227E-01],
	[1.6615000000E+04, 2.3069878028E+01, 1.4924707801E+01, 2.5551552749E+00, 1.9931626498E+00, 7.1180267783E-01],
	[1.6620000000E+04, 2.3079661890E+01, 1.4924039069E+01, 2.5575961783E+00, 1.9947087596E+00, 7.1192278034E-01],
	[1.6625000000E+04, 2.3089446955E+01, 1.4923370568E+01, 2.5600386767E+00, 1.9962553514E+00, 7.1204284980E-01],
	[1.6630000000E+04, 2.3099233225E+01, 1.4922702298E+01, 2.5624827709E+00, 1.9978024249E+00, 7.1216288620E-01],
	[1.6635000000E+04, 2.3109020699E+01, 1.4922034259E+01, 2.5649284613E+00, 1.9993499798E+00, 7.1228288952E-01],
	[1.6640000000E+04, 2.3118809377E+01, 1.4921366451E+01, 2.5673757485E+00, 2.0008980156E+00, 7.1240285976E-01],
	[1.6645000000E+04, 2.3128599258E+01, 1.4920698873E+01, 2.5698246331E+00, 2.0024465319E+00, 7.1252279691E-01],
	[1.6650000000E+04, 2.3138390343E+01, 1.4920031526E+01, 2.5722751157E+00, 2.0039955285E+00, 7.1264270096E-01],
	[1.6655000000E+04, 2.3148182631E+01, 1.4919364408E+01, 2.5747271967E+00, 2.0055450049E+00, 7.1276257190E-01],
	[1.6660000000E+04, 2.3157976122E+01, 1.4918697521E+01, 2.5771808767E+00, 2.0070949607E+00, 7.1288240972E-01],
	[1.6665000000E+04, 2.3167770816E+01, 1.4918030864E+01, 2.5796361564E+00, 2.0086453956E+00, 7.1300221441E-01],
	[1.6670000000E+04, 2.3177566712E+01, 1.4917364436E+01, 2.5820930363E+00, 2.0101963092E+00, 7.1312198596E-01],
	[1.6675000000E+04, 2.3187363811E+01, 1.4916698238E+01, 2.5845515168E+00, 2.0117477011E+00, 7.1324172436E-01],
	[1.6680000000E+04, 2.3197162112E+01, 1.4916032270E+01, 2.5870115987E+00, 2.0132995710E+00, 7.1336142961E-01],
	[1.6685000000E+04, 2.3206961615E+01, 1.4915366530E+01, 2.5894732825E+00, 2.0148519183E+00, 7.1348110169E-01],
	[1.6690000000E+04, 2.3216762319E+01, 1.4914701020E+01, 2.5919365686E+00, 2.0164047429E+00, 7.1360074059E-01],
	[1.6695000000E+04, 2.3226564225E+01, 1.4914035739E+01, 2.5944014578E+00, 2.0179580443E+00, 7.1372034631E-01],
	[1.6700000000E+04, 2.3236367332E+01, 1.4913370687E+01, 2.5968679504E+00, 2.0195118220E+00, 7.1383991884E-01],
	[1.6705000000E+04, 2.3246171640E+01, 1.4912705864E+01, 2.5993360472E+00, 2.0210660758E+00, 7.1395945816E-01],
	[1.6710000000E+04, 2.3255977149E+01, 1.4912041269E+01, 2.6018057487E+00, 2.0226208053E+00, 7.1407896427E-01],
	[1.6715000000E+04, 2.3265783859E+01, 1.4911376903E+01, 2.6042770553E+00, 2.0241760100E+00, 7.1419843716E-01],
	[1.6720000000E+04, 2.3275591769E+01, 1.4910712765E+01, 2.6067499678E+00, 2.0257316897E+00, 7.1431787682E-01],
	[1.6725000000E+04, 2.3285400880E+01, 1.4910048855E+01, 2.6092244866E+00, 2.0272878438E+00, 7.1443728324E-01],
	[1.6730000000E+04, 2.3295211190E+01, 1.4909385173E+01, 2.6117006123E+00, 2.0288444721E+00, 7.1455665641E-01],
	[1.6735000000E+04, 2.3305022700E+01, 1.4908721719E+01, 2.6141783455E+00, 2.0304015742E+00, 7.1467599633E-01],
	[1.6740000000E+04, 2.3314835410E+01, 1.4908058492E+01, 2.6166576867E+00, 2.0319591496E+00, 7.1479530298E-01],
	[1.6745000000E+04, 2.3324649319E+01, 1.4907395493E+01, 2.6191386365E+00, 2.0335171980E+00, 7.1491457635E-01],
	[1.6750000000E+04, 2.3334464427E+01, 1.4906732722E+01, 2.6216211954E+00, 2.0350757190E+00, 7.1503381644E-01],
	[1.6755000000E+04, 2.3344280734E+01, 1.4906070178E+01, 2.6241053641E+00, 2.0366347123E+00, 7.1515302324E-01],
	[1.6760000000E+04, 2.3354098240E+01, 1.4905407861E+01, 2.6265911430E+00, 2.0381941774E+00, 7.1527219674E-01],
	[1.6765000000E+04, 2.3363916945E+01, 1.4904745771E+01, 2.6290785328E+00, 2.0397541140E+00, 7.1539133693E-01],
	[1.6770000000E+04, 2.3373736848E+01, 1.4904083908E+01, 2.6315675340E+00, 2.0413145217E+00, 7.1551044380E-01],
	[1.6775000000E+04, 2.3383557948E+01, 1.4903422271E+01, 2.6340581472E+00, 2.0428754000E+00, 7.1562951734E-01],
	[1.6780000000E+04, 2.3393380247E+01, 1.4902760861E+01, 2.6365503728E+00, 2.0444367487E+00, 7.1574855755E-01],
	[1.6785000000E+04, 2.3403203744E+01, 1.4902099677E+01, 2.6390442116E+00, 2.0459985673E+00, 7.1586756441E-01],
	[1.6790000000E+04, 2.3413028437E+01, 1.4901438720E+01, 2.6415396640E+00, 2.0475608555E+00, 7.1598653792E-01],
	[1.6795000000E+04, 2.3422854329E+01, 1.4900777989E+01, 2.6440367306E+00, 2.0491236128E+00, 7.1610547807E-01],
	[1.6800000000E+04, 2.3432681417E+01, 1.4900117484E+01, 2.6465354120E+00, 2.0506868389E+00, 7.1622438485E-01],
	[1.6805000000E+04, 2.3442509702E+01, 1.4899457204E+01, 2.6490357087E+00, 2.0522505335E+00, 7.1634325825E-01],
	[1.6810000000E+04, 2.3452339183E+01, 1.4898797150E+01, 2.6515376213E+00, 2.0538146960E+00, 7.1646209826E-01],
	[1.6815000000E+04, 2.3462169861E+01, 1.4898137322E+01, 2.6540411504E+00, 2.0553793262E+00, 7.1658090488E-01],
	[1.6820000000E+04, 2.3472001736E+01, 1.4897477719E+01, 2.6565462965E+00, 2.0569444236E+00, 7.1669967809E-01],
	[1.6825000000E+04, 2.3481834806E+01, 1.4896818341E+01, 2.6590530602E+00, 2.0585099879E+00, 7.1681841789E-01],
	[1.6830000000E+04, 2.3491669072E+01, 1.4896159189E+01, 2.6615614420E+00, 2.0600760186E+00, 7.1693712428E-01],
	[1.6835000000E+04, 2.3501538940E+01, 1.4895514952E+01, 2.6640714425E+00, 2.0616430617E+00, 7.1705579722E-01],
	[1.6840000000E+04, 2.3511412183E+01, 1.4894871857E+01, 2.6665830623E+00, 2.0632106061E+00, 7.1717443672E-01],
	[1.6845000000E+04, 2.3521286641E+01, 1.4894228981E+01, 2.6690963019E+00, 2.0647786172E+00, 7.1729304277E-01],
	[1.6850000000E+04, 2.3531162314E+01, 1.4893586323E+01, 2.6716111619E+00, 2.0663470946E+00, 7.1741161535E-01],
	[1.6855000000E+04, 2.3541039201E+01, 1.4892943884E+01, 2.6741276428E+00, 2.0679160380E+00, 7.1753015445E-01],
	[1.6860000000E+04, 2.3550917303E+01, 1.4892301663E+01, 2.6766457453E+00, 2.0694854469E+00, 7.1764866006E-01],
	[1.6865000000E+04, 2.3560796619E+01, 1.4891659660E+01, 2.6791654698E+00, 2.0710553210E+00, 7.1776713217E-01],
	[1.6870000000E+04, 2.3570677148E+01, 1.4891017875E+01, 2.6816868170E+00, 2.0726256599E+00, 7.1788557078E-01],
	[1.6875000000E+04, 2.3580558892E+01, 1.4890376308E+01, 2.6842097874E+00, 2.0741964631E+00, 7.1800397586E-01],
	[1.6880000000E+04, 2.3590441849E+01, 1.4889734959E+01, 2.6867343815E+00, 2.0757677304E+00, 7.1812234742E-01],
	[1.6885000000E+04, 2.3600326019E+01, 1.4889093827E+01, 2.6892606000E+00, 2.0773394613E+00, 7.1824068543E-01],
	[1.6890000000E+04, 2.3610211402E+01, 1.4888452912E+01, 2.6917884433E+00, 2.0789116555E+00, 7.1835898990E-01],
	[1.6895000000E+04, 2.3620097998E+01, 1.4887812215E+01, 2.6943179121E+00, 2.0804843124E+00, 7.1847726080E-01],
	[1.6900000000E+04, 2.3629985807E+01, 1.4887171735E+01, 2.6968490069E+00, 2.0820574319E+00, 7.1859549814E-01],
	[1.6905000000E+04, 2.3639874828E+01, 1.4886531472E+01, 2.6993817283E+00, 2.0836310134E+00, 7.1871370189E-01],
	[1.6910000000E+04, 2.3649765061E+01, 1.4885891426E+01, 2.7019160768E+00, 2.0852050566E+00, 7.1883187205E-01],
	[1.6915000000E+04, 2.3659656507E+01, 1.4885251596E+01, 2.7044520530E+00, 2.0867795612E+00, 7.1895000861E-01],
	[1.6920000000E+04, 2.3669549164E+01, 1.4884611983E+01, 2.7069896575E+00, 2.0883545266E+00, 7.1906811156E-01],
	[1.6925000000E+04, 2.3679443033E+01, 1.4883972587E+01, 2.7095288908E+00, 2.0899299526E+00, 7.1918618089E-01],
	[1.6930000000E+04, 2.3689338113E+01, 1.4883333407E+01, 2.7120697535E+00, 2.0915058387E+00, 7.1930421658E-01],
	[1.6935000000E+04, 2.3699234404E+01, 1.4882694443E+01, 2.7146122461E+00, 2.0930821845E+00, 7.1942221864E-01],
	[1.6940000000E+04, 2.3709131906E+01, 1.4882055695E+01, 2.7171563693E+00, 2.0946589897E+00, 7.1954018704E-01],
	[1.6945000000E+04, 2.3719030619E+01, 1.4881417163E+01, 2.7197021235E+00, 2.0962362539E+00, 7.1965812179E-01],
	[1.6950000000E+04, 2.3728930543E+01, 1.4880778847E+01, 2.7222495094E+00, 2.0978139767E+00, 7.1977602286E-01],
	[1.6955000000E+04, 2.3738831677E+01, 1.4880140746E+01, 2.7247985274E+00, 2.0993921577E+00, 7.1989389025E-01],
	[1.6960000000E+04, 2.3748734021E+01, 1.4879502861E+01, 2.7273491783E+00, 2.1009707965E+00, 7.2001172395E-01],
	[1.6965000000E+04, 2.3758637575E+01, 1.4878865192E+01, 2.7299014624E+00, 2.1025498927E+00, 7.2012952395E-01],
	[1.6970000000E+04, 2.3768542338E+01, 1.4878227737E+01, 2.7324553804E+00, 2.1041294459E+00, 7.2024729024E-01],
	[1.6975000000E+04, 2.3778448311E+01, 1.4877590498E+01, 2.7350109329E+00, 2.1057094558E+00, 7.2036502281E-01],
	[1.6980000000E+04, 2.3788355494E+01, 1.4876953473E+01, 2.7375681204E+00, 2.1072899219E+00, 7.2048272164E-01],
	[1.6985000000E+04, 2.3798263885E+01, 1.4876316664E+01, 2.7401269435E+00, 2.1088708438E+00, 7.2060038674E-01],
	[1.6990000000E+04, 2.3808173486E+01, 1.4875680069E+01, 2.7426874027E+00, 2.1104522213E+00, 7.2071801810E-01],
	[1.6995000000E+04, 2.3818084295E+01, 1.4875043688E+01, 2.7452494986E+00, 2.1120340538E+00, 7.2083561569E-01],
	[1.7000000000E+04, 2.3827996312E+01, 1.4874407522E+01, 2.7478132317E+00, 2.1136163410E+00, 7.2095317951E-01],
	[1.7005000000E+04, 2.3837909538E+01, 1.4873771571E+01, 2.7503786027E+00, 2.1151990825E+00, 7.2107070956E-01],
	[1.7010000000E+04, 2.3847823972E+01, 1.4873135833E+01, 2.7529456121E+00, 2.1167822779E+00, 7.2118820582E-01],
	[1.7015000000E+04, 2.3857739613E+01, 1.4872500310E+01, 2.7555142604E+00, 2.1183659268E+00, 7.2130566828E-01],
	[1.7020000000E+04, 2.3867656462E+01, 1.4871865000E+01, 2.7580845483E+00, 2.1199500288E+00, 7.2142309694E-01],
	[1.7025000000E+04, 2.3877574519E+01, 1.4871229904E+01, 2.7606564762E+00, 2.1215345835E+00, 7.2154049178E-01],
	[1.7030000000E+04, 2.3887493783E+01, 1.4870595022E+01, 2.7632300448E+00, 2.1231195906E+00, 7.2165785280E-01],
	[1.7035000000E+04, 2.3897414254E+01, 1.4869960353E+01, 2.7658052546E+00, 2.1247050496E+00, 7.2177517998E-01],
	[1.7040000000E+04, 2.3907335931E+01, 1.4869325897E+01, 2.7683821061E+00, 2.1262909602E+00, 7.2189247332E-01],
	[1.7045000000E+04, 2.3917258815E+01, 1.4868691655E+01, 2.7709606000E+00, 2.1278773220E+00, 7.2200973281E-01],
	[1.7050000000E+04, 2.3927182906E+01, 1.4868057626E+01, 2.7735407367E+00, 2.1294641345E+00, 7.2212695844E-01],
	[1.7055000000E+04, 2.3937108203E+01, 1.4867423809E+01, 2.7761225170E+00, 2.1310513973E+00, 7.2224415019E-01],
	[1.7060000000E+04, 2.3947034706E+01, 1.4866790206E+01, 2.7787059412E+00, 2.1326391102E+00, 7.2236130807E-01],
	[1.7065000000E+04, 2.3956962414E+01, 1.4866156815E+01, 2.7812910100E+00, 2.1342272726E+00, 7.2247843205E-01],
	[1.7070000000E+04, 2.3966891328E+01, 1.4865523636E+01, 2.7838777240E+00, 2.1358158842E+00, 7.2259552214E-01],
	[1.7075000000E+04, 2.3976821447E+01, 1.4864890670E+01, 2.7864660837E+00, 2.1374049446E+00, 7.2271257832E-01],
	[1.7080000000E+04, 2.3986752772E+01, 1.4864257917E+01, 2.7890560896E+00, 2.1389944534E+00, 7.2282960058E-01],
	[1.7085000000E+04, 2.3996685301E+01, 1.4863625375E+01, 2.7916477424E+00, 2.1405844102E+00, 7.2294658892E-01],
	[1.7090000000E+04, 2.4006619035E+01, 1.4862993045E+01, 2.7942410426E+00, 2.1421748147E+00, 7.2306354333E-01],
	[1.7095000000E+04, 2.4016553974E+01, 1.4862360928E+01, 2.7968359907E+00, 2.1437656663E+00, 7.2318046379E-01],
	[1.7100000000E+04, 2.4026490117E+01, 1.4861729022E+01, 2.7994325874E+00, 2.1453569648E+00, 7.2329735030E-01],
	[1.7105000000E+04, 2.4036456050E+01, 1.4861108868E+01, 2.8020308332E+00, 2.1469491786E+00, 7.2341420285E-01],
	[1.7110000000E+04, 2.4046432634E+01, 1.4860492728E+01, 2.8046307286E+00, 2.1485419944E+00, 7.2353102143E-01],
	[1.7115000000E+04, 2.4056410442E+01, 1.4859876794E+01, 2.8072322742E+00, 2.1501352573E+00, 7.2364780603E-01],
	[1.7120000000E+04, 2.4066389475E+01, 1.4859261065E+01, 2.8098354706E+00, 2.1517289669E+00, 7.2376455664E-01],
	[1.7125000000E+04, 2.4076369731E+01, 1.4858645542E+01, 2.8124403184E+00, 2.1533231228E+00, 7.2388127326E-01],
	[1.7130000000E+04, 2.4086351210E+01, 1.4858030223E+01, 2.8150468180E+00, 2.1549177245E+00, 7.2399795587E-01],
	[1.7135000000E+04, 2.4096333913E+01, 1.4857415110E+01, 2.8176549701E+00, 2.1565127718E+00, 7.2411460447E-01],
	[1.7140000000E+04, 2.4106317839E+01, 1.4856800201E+01, 2.8202647753E+00, 2.1581082642E+00, 7.2423121905E-01],
	[1.7145000000E+04, 2.4116302987E+01, 1.4856185498E+01, 2.8228762341E+00, 2.1597042013E+00, 7.2434779959E-01],
	[1.7150000000E+04, 2.4126289359E+01, 1.4855570999E+01, 2.8254893470E+00, 2.1613005827E+00, 7.2446434610E-01],
	[1.7155000000E+04, 2.4136276952E+01, 1.4854956704E+01, 2.8281041146E+00, 2.1628974080E+00, 7.2458085856E-01],
	[1.7160000000E+04, 2.4146265768E+01, 1.4854342614E+01, 2.8307205376E+00, 2.1644946768E+00, 7.2469733696E-01],
	[1.7165000000E+04, 2.4156255806E+01, 1.4853728729E+01, 2.8333386164E+00, 2.1660923888E+00, 7.2481378130E-01],
	[1.7170000000E+04, 2.4166247065E+01, 1.4853115047E+01, 2.8359583516E+00, 2.1676905435E+00, 7.2493019157E-01],
	[1.7175000000E+04, 2.4176239547E+01, 1.4852501569E+01, 2.8385797438E+00, 2.1692891405E+00, 7.2504656776E-01],
	[1.7180000000E+04, 2.4186233249E+01, 1.4851888296E+01, 2.8412027935E+00, 2.1708881795E+00, 7.2516290985E-01],
	[1.7185000000E+04, 2.4196228173E+01, 1.4851275226E+01, 2.8438275013E+00, 2.1724876600E+00, 7.2527921785E-01],
	[1.7190000000E+04, 2.4206224318E+01, 1.4850662360E+01, 2.8464538678E+00, 2.1740875817E+00, 7.2539549174E-01],
	[1.7195000000E+04, 2.4216221683E+01, 1.4850049697E+01, 2.8490818936E+00, 2.1756879441E+00, 7.2551173152E-01],
	[1.7200000000E+04, 2.4226220269E+01, 1.4849437238E+01, 2.8517115791E+00, 2.1772887468E+00, 7.2562793717E-01],
	[1.7205000000E+04, 2.4236220076E+01, 1.4848824981E+01, 2.8543429250E+00, 2.1788899895E+00, 7.2574410869E-01],
	[1.7210000000E+04, 2.4246221102E+01, 1.4848212929E+01, 2.8569759318E+00, 2.1804916718E+00, 7.2586024607E-01],
	[1.7215000000E+04, 2.4256223349E+01, 1.4847601079E+01, 2.8596106002E+00, 2.1820937932E+00, 7.2597634931E-01],
	[1.7220000000E+04, 2.4266226815E+01, 1.4846989432E+01, 2.8622469305E+00, 2.1836963534E+00, 7.2609241839E-01],
	[1.7225000000E+04, 2.4276231501E+01, 1.4846377987E+01, 2.8648849235E+00, 2.1852993519E+00, 7.2620845331E-01],
	[1.7230000000E+04, 2.4286237406E+01, 1.4845766746E+01, 2.8675245797E+00, 2.1869027883E+00, 7.2632445405E-01],
	[1.7235000000E+04, 2.4296244530E+01, 1.4845155706E+01, 2.8701658996E+00, 2.1885066624E+00, 7.2644042062E-01],
	[1.7240000000E+04, 2.4306252873E+01, 1.4844544870E+01, 2.8728088839E+00, 2.1901109736E+00, 7.2655635299E-01],
	[1.7245000000E+04, 2.4316262435E+01, 1.4843934235E+01, 2.8754535330E+00, 2.1917157215E+00, 7.2667225118E-01],
	[1.7250000000E+04, 2.4326273215E+01, 1.4843323803E+01, 2.8780998475E+00, 2.1933209059E+00, 7.2678811515E-01],
	[1.7255000000E+04, 2.4336285214E+01, 1.4842713572E+01, 2.8807478281E+00, 2.1949265261E+00, 7.2690394492E-01],
	[1.7260000000E+04, 2.4346298431E+01, 1.4842103544E+01, 2.8833974752E+00, 2.1965325820E+00, 7.2701974047E-01],
	[1.7265000000E+04, 2.4356312865E+01, 1.4841493717E+01, 2.8860487895E+00, 2.1981390730E+00, 7.2713550179E-01],
	[1.7270000000E+04, 2.4366328518E+01, 1.4840884092E+01, 2.8887017714E+00, 2.1997459987E+00, 7.2725122888E-01],
	[1.7275000000E+04, 2.4376345387E+01, 1.4840274668E+01, 2.8913564217E+00, 2.2013533589E+00, 7.2736692172E-01],
	[1.7280000000E+04, 2.4386363474E+01, 1.4839665446E+01, 2.8940127407E+00, 2.2029611530E+00, 7.2748258031E-01],
	[1.7285000000E+04, 2.4396382779E+01, 1.4839056425E+01, 2.8966707291E+00, 2.2045693806E+00, 7.2759820465E-01],
	[1.7290000000E+04, 2.4406403300E+01, 1.4838447605E+01, 2.8993303875E+00, 2.2061780414E+00, 7.2771379472E-01],
	[1.7295000000E+04, 2.4416425037E+01, 1.4837838986E+01, 2.9019917164E+00, 2.2077871350E+00, 7.2782935051E-01],
	[1.7300000000E+04, 2.4426447991E+01, 1.4837230568E+01, 2.9046547164E+00, 2.2093966609E+00, 7.2794487203E-01],
	[1.7305000000E+04, 2.4436472162E+01, 1.4836622351E+01, 2.9073193880E+00, 2.2110066188E+00, 7.2806035926E-01],
	[1.7310000000E+04, 2.4446497548E+01, 1.4836014334E+01, 2.9099857319E+00, 2.2126170082E+00, 7.2817581219E-01],
	[1.7315000000E+04, 2.4456524150E+01, 1.4835406518E+01, 2.9126537485E+00, 2.2142278288E+00, 7.2829123081E-01],
	[1.7320000000E+04, 2.4466551968E+01, 1.4834798903E+01, 2.9153234385E+00, 2.2158390801E+00, 7.2840661513E-01],
	[1.7325000000E+04, 2.4476581002E+01, 1.4834191487E+01, 2.9179948023E+00, 2.2174507618E+00, 7.2852196513E-01],
	[1.7330000000E+04, 2.4486611250E+01, 1.4833584272E+01, 2.9206678407E+00, 2.2190628734E+00, 7.2863728080E-01],
	[1.7335000000E+04, 2.4496642714E+01, 1.4832977257E+01, 2.9233425541E+00, 2.2206754145E+00, 7.2875256214E-01],
	[1.7340000000E+04, 2.4506675392E+01, 1.4832370441E+01, 2.9260189430E+00, 2.2222883848E+00, 7.2886780913E-01],
	[1.7345000000E+04, 2.4516709286E+01, 1.4831763825E+01, 2.9286970082E+00, 2.2239017838E+00, 7.2898302178E-01],
	[1.7350000000E+04, 2.4526744393E+01, 1.4831157409E+01, 2.9313767500E+00, 2.2255156112E+00, 7.2909820008E-01],
	[1.7355000000E+04, 2.4536780715E+01, 1.4830551193E+01, 2.9340581692E+00, 2.2271298665E+00, 7.2921334401E-01],
	[1.7360000000E+04, 2.4546818251E+01, 1.4829945176E+01, 2.9367412662E+00, 2.2287445493E+00, 7.2932845357E-01],
	[1.7365000000E+04, 2.4556857000E+01, 1.4829339358E+01, 2.9394260417E+00, 2.2303596592E+00, 7.2944352876E-01],
	[1.7370000000E+04, 2.4566896963E+01, 1.4828733739E+01, 2.9421124961E+00, 2.2319751959E+00, 7.2955856956E-01],
	[1.7375000000E+04, 2.4576938140E+01, 1.4828128320E+01, 2.9448006301E+00, 2.2335911588E+00, 7.2967357597E-01],
	[1.7380000000E+04, 2.4587007792E+01, 1.4827533519E+01, 2.9474904442E+00, 2.2352080098E+00, 7.2978854798E-01],
	[1.7385000000E+04, 2.4597090888E+01, 1.4826943581E+01, 2.9501819390E+00, 2.2368254946E+00, 7.2990348559E-01],
	[1.7390000000E+04, 2.4607175219E+01, 1.4826353836E+01, 2.9528751150E+00, 2.2384434060E+00, 7.3001838878E-01],
	[1.7395000000E+04, 2.4617260783E+01, 1.4825764284E+01, 2.9555699728E+00, 2.2400617436E+00, 7.3013325756E-01],
	[1.7400000000E+04, 2.4627347580E+01, 1.4825174925E+01, 2.9582665131E+00, 2.2416805070E+00, 7.3024809191E-01],
	[1.7405000000E+04, 2.4637435610E+01, 1.4824585759E+01, 2.9609647362E+00, 2.2432996958E+00, 7.3036289182E-01],
	[1.7410000000E+04, 2.4647524873E+01, 1.4823996785E+01, 2.9636646429E+00, 2.2449193096E+00, 7.3047765730E-01],
	[1.7415000000E+04, 2.4657615370E+01, 1.4823408004E+01, 2.9663662336E+00, 2.2465393479E+00, 7.3059238833E-01],
	[1.7420000000E+04, 2.4667707098E+01, 1.4822819415E+01, 2.9690695090E+00, 2.2481598105E+00, 7.3070708490E-01],
	[1.7425000000E+04, 2.4677800059E+01, 1.4822231018E+01, 2.9717744696E+00, 2.2497806968E+00, 7.3082174701E-01],
	[1.7430000000E+04, 2.4687894252E+01, 1.4821642814E+01, 2.9744811160E+00, 2.2514020065E+00, 7.3093637466E-01],
	[1.7435000000E+04, 2.4697989677E+01, 1.4821054802E+01, 2.9771894487E+00, 2.2530237392E+00, 7.3105096783E-01],
	[1.7440000000E+04, 2.4708086334E+01, 1.4820466981E+01, 2.9798994682E+00, 2.2546458944E+00, 7.3116552652E-01],
	[1.7445000000E+04, 2.4718184222E+01, 1.4819879353E+01, 2.9826111753E+00, 2.2562684718E+00, 7.3128005072E-01],
	[1.7450000000E+04, 2.4728283341E+01, 1.4819291916E+01, 2.9853245704E+00, 2.2578914710E+00, 7.3139454043E-01],
	[1.7455000000E+04, 2.4738383692E+01, 1.4818704670E+01, 2.9880396540E+00, 2.2595148915E+00, 7.3150899563E-01],
	[1.7460000000E+04, 2.4748485274E+01, 1.4818117616E+01, 2.9907564269E+00, 2.2611387329E+00, 7.3162341633E-01],
	[1.7465000000E+04, 2.4758588086E+01, 1.4817530754E+01, 2.9934748894E+00, 2.2627629949E+00, 7.3173780252E-01],
	[1.7470000000E+04, 2.4768692129E+01, 1.4816944083E+01, 2.9961950423E+00, 2.2643876770E+00, 7.3185215418E-01],
	[1.7475000000E+04, 2.4778797402E+01, 1.4816357602E+01, 2.9989168860E+00, 2.2660127788E+00, 7.3196647132E-01],
	[1.7480000000E+04, 2.4788903905E+01, 1.4815771313E+01, 3.0016404211E+00, 2.2676382999E+00, 7.3208075392E-01],
	[1.7485000000E+04, 2.4799011638E+01, 1.4815185215E+01, 3.0043656482E+00, 2.2692642400E+00, 7.3219500198E-01],
	[1.7490000000E+04, 2.4809120601E+01, 1.4814599307E+01, 3.0070925679E+00, 2.2708905985E+00, 7.3230921550E-01],
	[1.7495000000E+04, 2.4819230793E+01, 1.4814013590E+01, 3.0098211806E+00, 2.2725173752E+00, 7.3242339446E-01],
	[1.7500000000E+04, 2.4829342214E+01, 1.4813428064E+01, 3.0125514871E+00, 2.2741445696E+00, 7.3253753886E-01],
	[1.7505000000E+04, 2.4839454865E+01, 1.4812842728E+01, 3.0153057163E+00, 2.2757848434E+00, 7.3265164870E-01],
	[1.7510000000E+04, 2.4849568745E+01, 1.4812257582E+01, 3.0180616744E+00, 2.2774255438E+00, 7.3276572396E-01],
	[1.7515000000E+04, 2.4859683853E+01, 1.4811672626E+01, 3.0208193621E+00, 2.2790666705E+00, 7.3287976465E-01],
	[1.7520000000E+04, 2.4869800189E+01, 1.4811087861E+01, 3.0235787799E+00, 2.2807082229E+00, 7.3299377075E-01],
	[1.7525000000E+04, 2.4879917754E+01, 1.4810503285E+01, 3.0263399285E+00, 2.2823502007E+00, 7.3310774226E-01],
	[1.7530000000E+04, 2.4890036547E+01, 1.4809918899E+01, 3.0291028084E+00, 2.2839926034E+00, 7.3322167917E-01],
	[1.7535000000E+04, 2.4900156568E+01, 1.4809334703E+01, 3.0318674203E+00, 2.2856354306E+00, 7.3333558148E-01],
	[1.7540000000E+04, 2.4910277817E+01, 1.4808750697E+01, 3.0346337646E+00, 2.2872786819E+00, 7.3344944918E-01],
	[1.7545000000E+04, 2.4920400293E+01, 1.4808166880E+01, 3.0374018421E+00, 2.2889223570E+00, 7.3356328227E-01],
	[1.7550000000E+04, 2.4930523997E+01, 1.4807583252E+01, 3.0401716532E+00, 2.2905664553E+00, 7.3367708073E-01],
	[1.7555000000E+04, 2.4940648927E+01, 1.4806999813E+01, 3.0429431987E+00, 2.2922109764E+00, 7.3379084457E-01],
	[1.7560000000E+04, 2.4950775084E+01, 1.4806416564E+01, 3.0457164790E+00, 2.2938559200E+00, 7.3390457377E-01],
	[1.7565000000E+04, 2.4960902468E+01, 1.4805833504E+01, 3.0484914948E+00, 2.2955012857E+00, 7.3401826833E-01],
	[1.7570000000E+04, 2.4971031079E+01, 1.4805250633E+01, 3.0512682466E+00, 2.2971470729E+00, 7.3413192825E-01],
	[1.7575000000E+04, 2.4981160916E+01, 1.4804667950E+01, 3.0540467351E+00, 2.2987932813E+00, 7.3424555351E-01],
	[1.7580000000E+04, 2.4991291978E+01, 1.4804085456E+01, 3.0568269608E+00, 2.3004399105E+00, 7.3435914412E-01],
	[1.7585000000E+04, 2.5001424267E+01, 1.4803503151E+01, 3.0596089243E+00, 2.3020869600E+00, 7.3447270007E-01],
	[1.7590000000E+04, 2.5011557781E+01, 1.4802921034E+01, 3.0623926263E+00, 2.3037344295E+00, 7.3458622134E-01],
	[1.7595000000E+04, 2.5021692521E+01, 1.4802339105E+01, 3.0651780672E+00, 2.3053823184E+00, 7.3469970794E-01],
	[1.7600000000E+04, 2.5031828486E+01, 1.4801757365E+01, 3.0679652478E+00, 2.3070306265E+00, 7.3481315986E-01],
	[1.7605000000E+04, 2.5041965677E+01, 1.4801175812E+01, 3.0707541685E+00, 2.3086793532E+00, 7.3492657710E-01],
	[1.7610000000E+04, 2.5052104092E+01, 1.4800594448E+01, 3.0735448300E+00, 2.3103284982E+00, 7.3503995964E-01],
	[1.7615000000E+04, 2.5062243731E+01, 1.4800013272E+01, 3.0763372329E+00, 2.3119780611E+00, 7.3515330748E-01],
	[1.7620000000E+04, 2.5072384596E+01, 1.4799432283E+01, 3.0791313778E+00, 2.3136280413E+00, 7.3526662062E-01],
	[1.7625000000E+04, 2.5082526684E+01, 1.4798851482E+01, 3.0819272652E+00, 2.3152784386E+00, 7.3537989905E-01],
	[1.7630000000E+04, 2.5092669997E+01, 1.4798270868E+01, 3.0847248957E+00, 2.3169292524E+00, 7.3549314277E-01],
	[1.7635000000E+04, 2.5102814533E+01, 1.4797690442E+01, 3.0875242699E+00, 2.3185804824E+00, 7.3560635177E-01],
	[1.7640000000E+04, 2.5112960293E+01, 1.4797110203E+01, 3.0903253885E+00, 2.3202321281E+00, 7.3571952604E-01],
	[1.7645000000E+04, 2.5123107277E+01, 1.4796530152E+01, 3.0931282520E+00, 2.3218841891E+00, 7.3583266558E-01],
	[1.7650000000E+04, 2.5133255484E+01, 1.4795950287E+01, 3.0959328610E+00, 2.3235366650E+00, 7.3594577038E-01],
	[1.7655000000E+04, 2.5143404914E+01, 1.4795370610E+01, 3.0987392161E+00, 2.3251895554E+00, 7.3605884057E-01],
	[1.7660000000E+04, 2.5153585854E+01, 1.4794802152E+01, 3.1015473179E+00, 2.3268433919E+00, 7.3617187624E-01],
	[1.7665000000E+04, 2.5163778520E+01, 1.4794237696E+01, 3.1043571669E+00, 2.3284978277E+00, 7.3628487740E-01],
	[1.7670000000E+04, 2.5173972430E+01, 1.4793673421E+01, 3.1071687638E+00, 2.3301526782E+00, 7.3639784403E-01],
	[1.7675000000E+04, 2.5184167584E+01, 1.4793109328E+01, 3.1099821092E+00, 2.3318079431E+00, 7.3651077612E-01],
	[1.7680000000E+04, 2.5194363982E+01, 1.4792545415E+01, 3.1127972036E+00, 2.3334636220E+00, 7.3662367368E-01],
	[1.7685000000E+04, 2.5204561622E+01, 1.4791981684E+01, 3.1156140476E+00, 2.3351197144E+00, 7.3673653669E-01],
	[1.7690000000E+04, 2.5214760506E+01, 1.4791418133E+01, 3.1184326419E+00, 2.3367762199E+00, 7.3684936515E-01],
	[1.7695000000E+04, 2.5224960633E+01, 1.4790854763E+01, 3.1212529870E+00, 2.3384331381E+00, 7.3696215905E-01],
	[1.7700000000E+04, 2.5235162002E+01, 1.4790291573E+01, 3.1240750835E+00, 2.3400904686E+00, 7.3707491838E-01],
	[1.7705000000E+04, 2.5245364614E+01, 1.4789728564E+01, 3.1268989320E+00, 2.3417482109E+00, 7.3718764315E-01],
	[1.7710000000E+04, 2.5255568469E+01, 1.4789165736E+01, 3.1297245331E+00, 2.3434063646E+00, 7.3730033333E-01],
	[1.7715000000E+04, 2.5265773565E+01, 1.4788603087E+01, 3.1325518874E+00, 2.3450649294E+00, 7.3741298894E-01],
	[1.7720000000E+04, 2.5275979903E+01, 1.4788040619E+01, 3.1353809954E+00, 2.3467239048E+00, 7.3752560995E-01],
	[1.7725000000E+04, 2.5286187483E+01, 1.4787478331E+01, 3.1382118579E+00, 2.3483832903E+00, 7.3763819636E-01],
	[1.7730000000E+04, 2.5296396305E+01, 1.4786916223E+01, 3.1410444752E+00, 2.3500430855E+00, 7.3775074817E-01],
	[1.7735000000E+04, 2.5306606368E+01, 1.4786354295E+01, 3.1438788482E+00, 2.3517032901E+00, 7.3786326538E-01],
	[1.7740000000E+04, 2.5316817672E+01, 1.4785792547E+01, 3.1467149772E+00, 2.3533639036E+00, 7.3797574797E-01],
	[1.7745000000E+04, 2.5327030216E+01, 1.4785230978E+01, 3.1495528630E+00, 2.3550249255E+00, 7.3808819594E-01],
	[1.7750000000E+04, 2.5337244002E+01, 1.4784669589E+01, 3.1523925061E+00, 2.3566863555E+00, 7.3820060928E-01],
	[1.7755000000E+04, 2.5347459028E+01, 1.4784108379E+01, 3.1552339072E+00, 2.3583481932E+00, 7.3831298798E-01],
	[1.7760000000E+04, 2.5357675295E+01, 1.4783547348E+01, 3.1580770667E+00, 2.3600104380E+00, 7.3842533205E-01],
	[1.7765000000E+04, 2.5367892801E+01, 1.4782986497E+01, 3.1609219853E+00, 2.3616730897E+00, 7.3853764148E-01],
	[1.7770000000E+04, 2.5378111548E+01, 1.4782425825E+01, 3.1637686637E+00, 2.3633361477E+00, 7.3864991625E-01],
	[1.7775000000E+04, 2.5388331534E+01, 1.4781865331E+01, 3.1666171023E+00, 2.3649996116E+00, 7.3876215637E-01],
	[1.7780000000E+04, 2.5398552759E+01, 1.4781305017E+01, 3.1694673017E+00, 2.3666634811E+00, 7.3887436182E-01],
	[1.7785000000E+04, 2.5408775224E+01, 1.4780744881E+01, 3.1723192627E+00, 2.3683277557E+00, 7.3898653261E-01],
	[1.7790000000E+04, 2.5418998929E+01, 1.4780184925E+01, 3.1751729856E+00, 2.3699924349E+00, 7.3909866872E-01],
	[1.7795000000E+04, 2.5429223872E+01, 1.4779625146E+01, 3.1780284713E+00, 2.3716575184E+00, 7.3921077015E-01],
	[1.7800000000E+04, 2.5439450053E+01, 1.4779065546E+01, 3.1808857201E+00, 2.3733230057E+00, 7.3932283690E-01],
	[1.7805000000E+04, 2.5449677474E+01, 1.4778506125E+01, 3.1837447328E+00, 2.3749888964E+00, 7.3943486895E-01],
	[1.7810000000E+04, 2.5459906133E+01, 1.4777946881E+01, 3.1866055100E+00, 2.3766551901E+00, 7.3954686631E-01],
	[1.7815000000E+04, 2.5470136029E+01, 1.4777387816E+01, 3.1894680521E+00, 2.3783218863E+00, 7.3965882896E-01],
	[1.7820000000E+04, 2.5480367164E+01, 1.4776828929E+01, 3.1923323598E+00, 2.3799889847E+00, 7.3977075690E-01],
	[1.7825000000E+04, 2.5490599537E+01, 1.4776270220E+01, 3.1951984337E+00, 2.3816564847E+00, 7.3988265014E-01],
	[1.7830000000E+04, 2.5500833147E+01, 1.4775711688E+01, 3.1980662744E+00, 2.3833243861E+00, 7.3999450865E-01],
	[1.7835000000E+04, 2.5511067994E+01, 1.4775153335E+01, 3.2009358825E+00, 2.3849926882E+00, 7.4010633243E-01],
	[1.7840000000E+04, 2.5521304079E+01, 1.4774595159E+01, 3.2038072586E+00, 2.3866613909E+00, 7.4021812149E-01],
	[1.7845000000E+04, 2.5531541400E+01, 1.4774037160E+01, 3.2066804032E+00, 2.3883304935E+00, 7.4032987581E-01],
	[1.7850000000E+04, 2.5541779958E+01, 1.4773479339E+01, 3.2095553170E+00, 2.3899999957E+00, 7.4044159538E-01],
	[1.7855000000E+04, 2.5552019753E+01, 1.4772921695E+01, 3.2124320005E+00, 2.3916698970E+00, 7.4055328021E-01],
	[1.7860000000E+04, 2.5562260784E+01, 1.4772364228E+01, 3.2153104544E+00, 2.3933401971E+00, 7.4066493029E-01],
	[1.7865000000E+04, 2.5572503052E+01, 1.4771806939E+01, 3.2181906792E+00, 2.3950108954E+00, 7.4077654561E-01],
	[1.7870000000E+04, 2.5582746555E+01, 1.4771249826E+01, 3.2210726755E+00, 2.3966819917E+00, 7.4088812617E-01],
	[1.7875000000E+04, 2.5592991294E+01, 1.4770692890E+01, 3.2239564440E+00, 2.3983534854E+00, 7.4099967195E-01],
	[1.7880000000E+04, 2.5603237269E+01, 1.4770136131E+01, 3.2268419851E+00, 2.4000253761E+00, 7.4111118297E-01],
	[1.7885000000E+04, 2.5613484479E+01, 1.4769579548E+01, 3.2297292995E+00, 2.4016976634E+00, 7.4122265920E-01],
	[1.7890000000E+04, 2.5623732924E+01, 1.4769023142E+01, 3.2326183879E+00, 2.4033703469E+00, 7.4133410065E-01],
	[1.7895000000E+04, 2.5633982604E+01, 1.4768466913E+01, 3.2355092507E+00, 2.4050434261E+00, 7.4144550731E-01],
	[1.7900000000E+04, 2.5644233519E+01, 1.4767910860E+01, 3.2384018886E+00, 2.4067169006E+00, 7.4155687918E-01],
	[1.7905000000E+04, 2.5654485669E+01, 1.4767354983E+01, 3.2412963021E+00, 2.4083907700E+00, 7.4166821625E-01],
	[1.7910000000E+04, 2.5664739053E+01, 1.4766799282E+01, 3.2441924920E+00, 2.4100650339E+00, 7.4177951851E-01],
	[1.7915000000E+04, 2.5674993671E+01, 1.4766243757E+01, 3.2470904586E+00, 2.4117396918E+00, 7.4189078596E-01],
	[1.7920000000E+04, 2.5685249523E+01, 1.4765688409E+01, 3.2499902028E+00, 2.4134147433E+00, 7.4200201860E-01],
	[1.7925000000E+04, 2.5695506609E+01, 1.4765133235E+01, 3.2528917249E+00, 2.4150901880E+00, 7.4211321641E-01],
	[1.7930000000E+04, 2.5705764929E+01, 1.4764578238E+01, 3.2557950257E+00, 2.4167660254E+00, 7.4222437940E-01],
	[1.7935000000E+04, 2.5716024482E+01, 1.4764023416E+01, 3.2587001057E+00, 2.4184422552E+00, 7.4233550756E-01],
	[1.7940000000E+04, 2.5726285268E+01, 1.4763468770E+01, 3.2616069655E+00, 2.4201188768E+00, 7.4244660089E-01],
	[1.7945000000E+04, 2.5736584787E+01, 1.4762927391E+01, 3.2645156058E+00, 2.4217965743E+00, 7.4255765938E-01],
	[1.7950000000E+04, 2.5746889987E+01, 1.4762387727E+01, 3.2674260270E+00, 2.4234747451E+00, 7.4266868302E-01],
	[1.7955000000E+04, 2.5757196440E+01, 1.4761848233E+01, 3.2703382298E+00, 2.4251533082E+00, 7.4277967181E-01],
	[1.7960000000E+04, 2.5767504148E+01, 1.4761308909E+01, 3.2732522148E+00, 2.4268322631E+00, 7.4289062575E-01],
	[1.7965000000E+04, 2.5777813110E+01, 1.4760769755E+01, 3.2761679826E+00, 2.4285116094E+00, 7.4300154483E-01],
	[1.7970000000E+04, 2.5788123326E+01, 1.4760230771E+01, 3.2790855338E+00, 2.4301913467E+00, 7.4311242904E-01],
	[1.7975000000E+04, 2.5798434795E+01, 1.4759691956E+01, 3.2820048689E+00, 2.4318714745E+00, 7.4322327839E-01],
	[1.7980000000E+04, 2.5808747518E+01, 1.4759153311E+01, 3.2849259886E+00, 2.4335519924E+00, 7.4333409286E-01],
	[1.7985000000E+04, 2.5819061494E+01, 1.4758614835E+01, 3.2878488934E+00, 2.4352329000E+00, 7.4344487246E-01],
	[1.7990000000E+04, 2.5829376724E+01, 1.4758076529E+01, 3.2907735840E+00, 2.4369141969E+00, 7.4355561717E-01],
	[1.7995000000E+04, 2.5839693206E+01, 1.4757538392E+01, 3.2937000609E+00, 2.4385958826E+00, 7.4366632699E-01],
	[1.8000000000E+04, 2.5850010941E+01, 1.4757000423E+01, 3.2966283247E+00, 2.4402779567E+00, 7.4377700193E-01],
	[1.8005000000E+04, 2.5860329928E+01, 1.4756462624E+01, 3.2995583761E+00, 2.4419604187E+00, 7.4388764196E-01],
	[1.8010000000E+04, 2.5870650168E+01, 1.4755924994E+01, 3.3024902156E+00, 2.4436432683E+00, 7.4399824710E-01],
	[1.8015000000E+04, 2.5880971660E+01, 1.4755387533E+01, 3.3054238437E+00, 2.4453265051E+00, 7.4410881733E-01],
	[1.8020000000E+04, 2.5891294403E+01, 1.4754850240E+01, 3.3083592612E+00, 2.4470101285E+00, 7.4421935265E-01],
	[1.8025000000E+04, 2.5901618399E+01, 1.4754313116E+01, 3.3112964686E+00, 2.4486941381E+00, 7.4432985306E-01],
	[1.8030000000E+04, 2.5911943646E+01, 1.4753776161E+01, 3.3142354664E+00, 2.4503785336E+00, 7.4444031854E-01],
	[1.8035000000E+04, 2.5922270144E+01, 1.4753239374E+01, 3.3171762553E+00, 2.4520633145E+00, 7.4455074911E-01],
	[1.8040000000E+04, 2.5932597893E+01, 1.4752702755E+01, 3.3201188359E+00, 2.4537484804E+00, 7.4466114474E-01],
	[1.8045000000E+04, 2.5942926894E+01, 1.4752166304E+01, 3.3230632088E+00, 2.4554340308E+00, 7.4477150545E-01],
	[1.8050000000E+04, 2.5953257145E+01, 1.4751630022E+01, 3.3260093745E+00, 2.4571199653E+00, 7.4488183122E-01],
	[1.8055000000E+04, 2.5963588646E+01, 1.4751093908E+01, 3.3289573337E+00, 2.4588062835E+00, 7.4499212204E-01],
	[1.8060000000E+04, 2.5973921398E+01, 1.4750557961E+01, 3.3319070869E+00, 2.4604929849E+00, 7.4510237793E-01],
	[1.8065000000E+04, 2.5984255400E+01, 1.4750022182E+01, 3.3348586348E+00, 2.4621800692E+00, 7.4521259886E-01],
	[1.8070000000E+04, 2.5994590652E+01, 1.4749486571E+01, 3.3378119779E+00, 2.4638675358E+00, 7.4532278484E-01],
	[1.8075000000E+04, 2.6004927154E+01, 1.4748951128E+01, 3.3407671168E+00, 2.4655553844E+00, 7.4543293587E-01],
	[1.8080000000E+04, 2.6015264905E+01, 1.4748415852E+01, 3.3437240521E+00, 2.4672436146E+00, 7.4554305193E-01],
	[1.8085000000E+04, 2.6025603906E+01, 1.4747880744E+01, 3.3466827845E+00, 2.4689322258E+00, 7.4565313303E-01],
	[1.8090000000E+04, 2.6035944156E+01, 1.4747345803E+01, 3.3496433144E+00, 2.4706212177E+00, 7.4576317916E-01],
	[1.8095000000E+04, 2.6046285655E+01, 1.4746811029E+01, 3.3526056426E+00, 2.4723105899E+00, 7.4587319031E-01],
	[1.8100000000E+04, 2.6056628402E+01, 1.4746276423E+01, 3.3555697695E+00, 2.4740003418E+00, 7.4598316649E-01],
	[1.8105000000E+04, 2.6066972399E+01, 1.4745741983E+01, 3.3585356958E+00, 2.4756904731E+00, 7.4609310768E-01],
	[1.8110000000E+04, 2.6077317643E+01, 1.4745207710E+01, 3.3615034221E+00, 2.4773809834E+00, 7.4620301389E-01],
	[1.8115000000E+04, 2.6087664136E+01, 1.4744673604E+01, 3.3644729490E+00, 2.4790718722E+00, 7.4631288511E-01],
	[1.8120000000E+04, 2.6098011877E+01, 1.4744139665E+01, 3.3674442770E+00, 2.4807631390E+00, 7.4642272134E-01],
	[1.8125000000E+04, 2.6108360866E+01, 1.4743605893E+01, 3.3704174068E+00, 2.4824547835E+00, 7.4653252257E-01],
	[1.8130000000E+04, 2.6118711102E+01, 1.4743072287E+01, 3.3733923390E+00, 2.4841468053E+00, 7.4664228880E-01],
	[1.8135000000E+04, 2.6129062586E+01, 1.4742538847E+01, 3.3763690741E+00, 2.4858392038E+00, 7.4675202002E-01],
	[1.8140000000E+04, 2.6139415317E+01, 1.4742005574E+01, 3.3793476127E+00, 2.4875319786E+00, 7.4686171623E-01],
	[1.8145000000E+04, 2.6149769295E+01, 1.4741472467E+01, 3.3823279555E+00, 2.4892251294E+00, 7.4697137743E-01],
	[1.8150000000E+04, 2.6160124519E+01, 1.4740939527E+01, 3.3853101030E+00, 2.4909186557E+00, 7.4708100362E-01],
	[1.8155000000E+04, 2.6170480991E+01, 1.4740406752E+01, 3.3882940558E+00, 2.4926125570E+00, 7.4719059478E-01],
	[1.8160000000E+04, 2.6180838709E+01, 1.4739874143E+01, 3.3912798146E+00, 2.4943068330E+00, 7.4730015093E-01],
	[1.8165000000E+04, 2.6191197673E+01, 1.4739341700E+01, 3.3942673798E+00, 2.4960014831E+00, 7.4740967204E-01],
	[1.8170000000E+04, 2.6201557883E+01, 1.4738809423E+01, 3.3972567522E+00, 2.4976965070E+00, 7.4751915812E-01],
	[1.8175000000E+04, 2.6211919340E+01, 1.4738277312E+01, 3.4002479323E+00, 2.4993919043E+00, 7.4762860917E-01],
	[1.8180000000E+04, 2.6222282042E+01, 1.4737745366E+01, 3.4032409206E+00, 2.5010876744E+00, 7.4773802518E-01],
	[1.8185000000E+04, 2.6232645989E+01, 1.4737213586E+01, 3.4062357178E+00, 2.5027838170E+00, 7.4784740615E-01],
	[1.8190000000E+04, 2.6243011182E+01, 1.4736681971E+01, 3.4092323245E+00, 2.5044803316E+00, 7.4795675207E-01],
	[1.8195000000E+04, 2.6253377619E+01, 1.4736150521E+01, 3.4122307413E+00, 2.5061772178E+00, 7.4806606295E-01],
	[1.8200000000E+04, 2.6263745302E+01, 1.4735619236E+01, 3.4152309688E+00, 2.5078744752E+00, 7.4817533877E-01],
	[1.8205000000E+04, 2.6274114230E+01, 1.4735088117E+01, 3.4182330075E+00, 2.5095721033E+00, 7.4828457954E-01],
	[1.8210000000E+04, 2.6284484402E+01, 1.4734557162E+01, 3.4212368581E+00, 2.5112701016E+00, 7.4839378525E-01],
	[1.8215000000E+04, 2.6294855818E+01, 1.4734026373E+01, 3.4242425211E+00, 2.5129684699E+00, 7.4850295589E-01],
	[1.8220000000E+04, 2.6305228478E+01, 1.4733495748E+01, 3.4272499972E+00, 2.5146672076E+00, 7.4861209147E-01],
	[1.8225000000E+04, 2.6315602383E+01, 1.4732965288E+01, 3.4302592869E+00, 2.5163663142E+00, 7.4872119198E-01],
	[1.8230000000E+04, 2.6325983166E+01, 1.4732436880E+01, 3.4332703908E+00, 2.5180658961E+00, 7.4883025742E-01],
	[1.8235000000E+04, 2.6336402654E+01, 1.4731921173E+01, 3.4362833096E+00, 2.5197665561E+00, 7.4893928778E-01],
	[1.8240000000E+04, 2.6346823407E+01, 1.4731405626E+01, 3.4392980438E+00, 2.5214675854E+00, 7.4904828306E-01],
	[1.8245000000E+04, 2.6357245425E+01, 1.4730890238E+01, 3.4423145940E+00, 2.5231689837E+00, 7.4915724326E-01],
	[1.8250000000E+04, 2.6367668709E+01, 1.4730375010E+01, 3.4453329608E+00, 2.5248707505E+00, 7.4926616838E-01],
	[1.8255000000E+04, 2.6378093258E+01, 1.4729859940E+01, 3.4483531448E+00, 2.5265728853E+00, 7.4937505840E-01],
	[1.8260000000E+04, 2.6388519071E+01, 1.4729345030E+01, 3.4513751466E+00, 2.5282753879E+00, 7.4948391334E-01],
	[1.8265000000E+04, 2.6398946149E+01, 1.4728830279E+01, 3.4543989669E+00, 2.5299782576E+00, 7.4959273318E-01],
	[1.8270000000E+04, 2.6409374492E+01, 1.4728315686E+01, 3.4574246061E+00, 2.5316814942E+00, 7.4970151792E-01],
	[1.8275000000E+04, 2.6419804099E+01, 1.4727801253E+01, 3.4604520649E+00, 2.5333850971E+00, 7.4981026756E-01],
	[1.8280000000E+04, 2.6430234970E+01, 1.4727286978E+01, 3.4634813438E+00, 2.5350890659E+00, 7.4991898210E-01],
	[1.8285000000E+04, 2.6440667104E+01, 1.4726772861E+01, 3.4665124436E+00, 2.5367934002E+00, 7.5002766153E-01],
	[1.8290000000E+04, 2.6451100503E+01, 1.4726258903E+01, 3.4695453647E+00, 2.5384980996E+00, 7.5013630584E-01],
	[1.8295000000E+04, 2.6461535164E+01, 1.4725745104E+01, 3.4725801078E+00, 2.5402031635E+00, 7.5024491505E-01],
	[1.8300000000E+04, 2.6471971090E+01, 1.4725231463E+01, 3.4756166734E+00, 2.5419085917E+00, 7.5035348914E-01],
	[1.8305000000E+04, 2.6482408278E+01, 1.4724717980E+01, 3.4786550622E+00, 2.5436143836E+00, 7.5046202811E-01],
	[1.8310000000E+04, 2.6492846729E+01, 1.4724204655E+01, 3.4816952747E+00, 2.5453205388E+00, 7.5057053196E-01],
	[1.8315000000E+04, 2.6503286443E+01, 1.4723691488E+01, 3.4847373116E+00, 2.5470270569E+00, 7.5067900069E-01],
	[1.8320000000E+04, 2.6513727419E+01, 1.4723178479E+01, 3.4877811734E+00, 2.5487339374E+00, 7.5078743428E-01],
	[1.8325000000E+04, 2.6524169658E+01, 1.4722665628E+01, 3.4908268607E+00, 2.5504411800E+00, 7.5089583275E-01],
	[1.8330000000E+04, 2.6534613158E+01, 1.4722152935E+01, 3.4938743742E+00, 2.5521487841E+00, 7.5100419608E-01],
	[1.8335000000E+04, 2.6545057921E+01, 1.4721640400E+01, 3.4969237143E+00, 2.5538567493E+00, 7.5111252428E-01],
	[1.8340000000E+04, 2.6555503946E+01, 1.4721128022E+01, 3.4999748818E+00, 2.5555650753E+00, 7.5122081734E-01],
	[1.8345000000E+04, 2.6565951232E+01, 1.4720615802E+01, 3.5030278772E+00, 2.5572737615E+00, 7.5132907526E-01],
	[1.8350000000E+04, 2.6576399779E+01, 1.4720103739E+01, 3.5060827012E+00, 2.5589828076E+00, 7.5143729804E-01],
	[1.8355000000E+04, 2.6586849587E+01, 1.4719591833E+01, 3.5091393542E+00, 2.5606922130E+00, 7.5154548566E-01],
	[1.8360000000E+04, 2.6597300657E+01, 1.4719080084E+01, 3.5121978369E+00, 2.5624019775E+00, 7.5165363814E-01],
	[1.8365000000E+04, 2.6607752987E+01, 1.4718568493E+01, 3.5152581499E+00, 2.5641121004E+00, 7.5176175547E-01],
	[1.8370000000E+04, 2.6618206578E+01, 1.4718057059E+01, 3.5183202938E+00, 2.5658225814E+00, 7.5186983764E-01],
	[1.8375000000E+04, 2.6628661429E+01, 1.4717545781E+01, 3.5213842691E+00, 2.5675334201E+00, 7.5197788466E-01],
	[1.8380000000E+04, 2.6639117541E+01, 1.4717034661E+01, 3.5244500766E+00, 2.5692446160E+00, 7.5208589652E-01],
	[1.8385000000E+04, 2.6649574912E+01, 1.4716523697E+01, 3.5275177167E+00, 2.5709561687E+00, 7.5219387321E-01],
	[1.8390000000E+04, 2.6660033544E+01, 1.4716012890E+01, 3.5305871901E+00, 2.5726680777E+00, 7.5230181474E-01],
	[1.8395000000E+04, 2.6670493435E+01, 1.4715502240E+01, 3.5336584973E+00, 2.5743803427E+00, 7.5240972111E-01],
	[1.8400000000E+04, 2.6680954585E+01, 1.4714991746E+01, 3.5367316391E+00, 2.5760929631E+00, 7.5251759230E-01],
	[1.8405000000E+04, 2.6691416995E+01, 1.4714481408E+01, 3.5398066158E+00, 2.5778059385E+00, 7.5262542832E-01],
	[1.8410000000E+04, 2.6701880664E+01, 1.4713971227E+01, 3.5428834282E+00, 2.5795192686E+00, 7.5273322917E-01],
	[1.8415000000E+04, 2.6712345591E+01, 1.4713461202E+01, 3.5459620769E+00, 2.5812329528E+00, 7.5284099485E-01],
	[1.8420000000E+04, 2.6722811778E+01, 1.4712951333E+01, 3.5490425624E+00, 2.5829469907E+00, 7.5294872534E-01],
	[1.8425000000E+04, 2.6733279223E+01, 1.4712441620E+01, 3.5521248853E+00, 2.5846613819E+00, 7.5305642066E-01],
	[1.8430000000E+04, 2.6743747926E+01, 1.4711932063E+01, 3.5552090463E+00, 2.5863761260E+00, 7.5316408079E-01],
	[1.8435000000E+04, 2.6754217887E+01, 1.4711422662E+01, 3.5582950458E+00, 2.5880912225E+00, 7.5327170573E-01],
	[1.8440000000E+04, 2.6764689106E+01, 1.4710913417E+01, 3.5613828846E+00, 2.5898066709E+00, 7.5337929537E-01],
	[1.8445000000E+04, 2.6775161583E+01, 1.4710404328E+01, 3.5644725633E+00, 2.5915224709E+00, 7.5348684962E-01],
	[1.8450000000E+04, 2.6785635317E+01, 1.4709895394E+01, 3.5675640823E+00, 2.5932386220E+00, 7.5359436847E-01],
	[1.8455000000E+04, 2.6796110309E+01, 1.4709386615E+01, 3.5706574424E+00, 2.5949551238E+00, 7.5370185194E-01],
	[1.8460000000E+04, 2.6806586558E+01, 1.4708877992E+01, 3.5737526440E+00, 2.5966719758E+00, 7.5380930002E-01],
	[1.8465000000E+04, 2.6817064064E+01, 1.4708369524E+01, 3.5768496879E+00, 2.5983891775E+00, 7.5391671271E-01],
	[1.8470000000E+04, 2.6827542827E+01, 1.4707861212E+01, 3.5799485745E+00, 2.6001067287E+00, 7.5402409001E-01],
	[1.8475000000E+04, 2.6838022846E+01, 1.4707353055E+01, 3.5830493045E+00, 2.6018246287E+00, 7.5413143193E-01],
	[1.8480000000E+04, 2.6848504122E+01, 1.4706845052E+01, 3.5861518786E+00, 2.6035428772E+00, 7.5423873847E-01],
	[1.8485000000E+04, 2.6858986654E+01, 1.4706337205E+01, 3.5892562972E+00, 2.6052614737E+00, 7.5434600962E-01],
	[1.8490000000E+04, 2.6869470442E+01, 1.4705829512E+01, 3.5923625610E+00, 2.6069804179E+00, 7.5445324539E-01],
	[1.8495000000E+04, 2.6879955486E+01, 1.4705321975E+01, 3.5954706705E+00, 2.6086997092E+00, 7.5456044578E-01],
	[1.8500000000E+04, 2.6890441785E+01, 1.4704814592E+01, 3.5985806265E+00, 2.6104193472E+00, 7.5466761080E-01],
	[1.8505000000E+04, 2.6900929340E+01, 1.4704307364E+01, 3.6016924294E+00, 2.6121393315E+00, 7.5477474044E-01],
	[1.8510000000E+04, 2.6911418151E+01, 1.4703800290E+01, 3.6048060798E+00, 2.6138596616E+00, 7.5488183470E-01],
	[1.8515000000E+04, 2.6921908216E+01, 1.4703293370E+01, 3.6079215785E+00, 2.6155803371E+00, 7.5498889358E-01],
	[1.8520000000E+04, 2.6932399536E+01, 1.4702786605E+01, 3.6110389258E+00, 2.6173013577E+00, 7.5509591710E-01],
	[1.8525000000E+04, 2.6942911469E+01, 1.4702286212E+01, 3.6141581226E+00, 2.6190231029E+00, 7.5520290524E-01],
	[1.8530000000E+04, 2.6953449585E+01, 1.4701793971E+01, 3.6172791692E+00, 2.6207456828E+00, 7.5530985801E-01],
	[1.8535000000E+04, 2.6963988978E+01, 1.4701301879E+01, 3.6204020665E+00, 2.6224686081E+00, 7.5541677542E-01],
	[1.8540000000E+04, 2.6974529647E+01, 1.4700809936E+01, 3.6235268148E+00, 2.6241918784E+00, 7.5552365746E-01],
	[1.8545000000E+04, 2.6985071594E+01, 1.4700318143E+01, 3.6266534149E+00, 2.6259154932E+00, 7.5563050413E-01],
	[1.8550000000E+04, 2.6995614816E+01, 1.4699826498E+01, 3.6297818674E+00, 2.6276394520E+00, 7.5573731544E-01],
	[1.8555000000E+04, 2.7006159315E+01, 1.4699335002E+01, 3.6329121727E+00, 2.6293637546E+00, 7.5584409138E-01],
	[1.8560000000E+04, 2.7016705089E+01, 1.4698843656E+01, 3.6360443316E+00, 2.6310884003E+00, 7.5595083197E-01],
	[1.8565000000E+04, 2.7027252140E+01, 1.4698352458E+01, 3.6391783446E+00, 2.6328133889E+00, 7.5605753719E-01],
	[1.8570000000E+04, 2.7037800466E+01, 1.4697861408E+01, 3.6423142123E+00, 2.6345387197E+00, 7.5616420706E-01],
	[1.8575000000E+04, 2.7048350067E+01, 1.4697370508E+01, 3.6454519354E+00, 2.6362643925E+00, 7.5627084157E-01],
	[1.8580000000E+04, 2.7058900944E+01, 1.4696879755E+01, 3.6485915143E+00, 2.6379904067E+00, 7.5637744073E-01],
	[1.8585000000E+04, 2.7069453096E+01, 1.4696389151E+01, 3.6517329498E+00, 2.6397167620E+00, 7.5648400453E-01],
	[1.8590000000E+04, 2.7080006522E+01, 1.4695898696E+01, 3.6548762423E+00, 2.6414434578E+00, 7.5659053299E-01],
	[1.8595000000E+04, 2.7090561224E+01, 1.4695408389E+01, 3.6580213926E+00, 2.6431704938E+00, 7.5669702609E-01],
	[1.8600000000E+04, 2.7101117199E+01, 1.4694918230E+01, 3.6611684011E+00, 2.6448978695E+00, 7.5680348385E-01],
	[1.8605000000E+04, 2.7111674449E+01, 1.4694428219E+01, 3.6643172686E+00, 2.6466255844E+00, 7.5690990626E-01],
	[1.8610000000E+04, 2.7122232974E+01, 1.4693938356E+01, 3.6674679955E+00, 2.6483536382E+00, 7.5701629332E-01],
	[1.8615000000E+04, 2.7132792772E+01, 1.4693448641E+01, 3.6706205825E+00, 2.6500820304E+00, 7.5712264505E-01],
	[1.8620000000E+04, 2.7143353843E+01, 1.4692959074E+01, 3.6737750302E+00, 2.6518107605E+00, 7.5722896143E-01],
	[1.8625000000E+04, 2.7153916189E+01, 1.4692469654E+01, 3.6769313392E+00, 2.6535398281E+00, 7.5733524248E-01],
	[1.8630000000E+04, 2.7164479807E+01, 1.4691980382E+01, 3.6800895101E+00, 2.6552692328E+00, 7.5744148819E-01],
	[1.8635000000E+04, 2.7175044699E+01, 1.4691491258E+01, 3.6832495434E+00, 2.6569989741E+00, 7.5754769856E-01],
	[1.8640000000E+04, 2.7185610864E+01, 1.4691002282E+01, 3.6864114398E+00, 2.6587290516E+00, 7.5765387360E-01],
	[1.8645000000E+04, 2.7196178301E+01, 1.4690513452E+01, 3.6895751999E+00, 2.6604594649E+00, 7.5776001330E-01],
	[1.8650000000E+04, 2.7206747011E+01, 1.4690024770E+01, 3.6927408242E+00, 2.6621902134E+00, 7.5786611768E-01],
	[1.8655000000E+04, 2.7217316994E+01, 1.4689536236E+01, 3.6959083134E+00, 2.6639212969E+00, 7.5797218673E-01],
	[1.8660000000E+04, 2.7227888248E+01, 1.4689047848E+01, 3.6990776681E+00, 2.6656527147E+00, 7.5807822046E-01],
	[1.8665000000E+04, 2.7238460775E+01, 1.4688559608E+01, 3.7022488888E+00, 2.6673844666E+00, 7.5818421886E-01],
	[1.8670000000E+04, 2.7249034574E+01, 1.4688071514E+01, 3.7054219762E+00, 2.6691165520E+00, 7.5829018194E-01],
	[1.8675000000E+04, 2.7259609644E+01, 1.4687583568E+01, 3.7085969308E+00, 2.6708489705E+00, 7.5839610970E-01],
	[1.8680000000E+04, 2.7270185986E+01, 1.4687095768E+01, 3.7117737532E+00, 2.6725817217E+00, 7.5850200214E-01],
	[1.8685000000E+04, 2.7280763599E+01, 1.4686608115E+01, 3.7149524441E+00, 2.6743148051E+00, 7.5860785927E-01],
	[1.8690000000E+04, 2.7291342483E+01, 1.4686120608E+01, 3.7181330041E+00, 2.6760482204E+00, 7.5871368108E-01],
	[1.8695000000E+04, 2.7301922638E+01, 1.4685633249E+01, 3.7213154336E+00, 2.6777819669E+00, 7.5881946758E-01],
	[1.8700000000E+04, 2.7312504063E+01, 1.4685146035E+01, 3.7244997334E+00, 2.6795160444E+00, 7.5892521878E-01],
	[1.8705000000E+04, 2.7323086760E+01, 1.4684658969E+01, 3.7276859041E+00, 2.6812504523E+00, 7.5903093466E-01],
	[1.8710000000E+04, 2.7333670726E+01, 1.4684172048E+01, 3.7308741286E+00, 2.6829852846E+00, 7.5913661524E-01],
	[1.8715000000E+04, 2.7344255963E+01, 1.4683685274E+01, 3.7340645799E+00, 2.6847206298E+00, 7.5924226052E-01],
	[1.8720000000E+04, 2.7354842469E+01, 1.4683198646E+01, 3.7372569046E+00, 2.6864563043E+00, 7.5934787049E-01],
	[1.8725000000E+04, 2.7365430246E+01, 1.4682712164E+01, 3.7404511034E+00, 2.6881923078E+00, 7.5945344517E-01],
	[1.8730000000E+04, 2.7376019292E+01, 1.4682225828E+01, 3.7436471768E+00, 2.6899286397E+00, 7.5955898455E-01],
	[1.8735000000E+04, 2.7386609607E+01, 1.4681739638E+01, 3.7468451255E+00, 2.6916652995E+00, 7.5966448863E-01],
	[1.8740000000E+04, 2.7397201192E+01, 1.4681253593E+01, 3.7500449500E+00, 2.6934022870E+00, 7.5976995742E-01],
	[1.8745000000E+04, 2.7407794046E+01, 1.4680767695E+01, 3.7532466509E+00, 2.6951396016E+00, 7.5987539093E-01],
	[1.8750000000E+04, 2.7418388168E+01, 1.4680281942E+01, 3.7564502288E+00, 2.6968772429E+00, 7.5998078914E-01],
	[1.8755000000E+04, 2.7428983559E+01, 1.4679796335E+01, 3.7596556844E+00, 2.6986152104E+00, 7.6008615207E-01],
	[1.8760000000E+04, 2.7439580219E+01, 1.4679310873E+01, 3.7628630182E+00, 2.7003535037E+00, 7.6019147972E-01],
	[1.8765000000E+04, 2.7450178147E+01, 1.4678825556E+01, 3.7660722308E+00, 2.7020921224E+00, 7.6029677208E-01],
	[1.8770000000E+04, 2.7460777343E+01, 1.4678340385E+01, 3.7692833229E+00, 2.7038310660E+00, 7.6040202917E-01],
	[1.8775000000E+04, 2.7471377807E+01, 1.4677855360E+01, 3.7724962949E+00, 2.7055703341E+00, 7.6050725098E-01],
	[1.8780000000E+04, 2.7481979539E+01, 1.4677370479E+01, 3.7757111476E+00, 2.7073099262E+00, 7.6061243752E-01],
	[1.8785000000E+04, 2.7492582538E+01, 1.4676885743E+01, 3.7789278815E+00, 2.7090498420E+00, 7.6071758878E-01],
	[1.8790000000E+04, 2.7503186804E+01, 1.4676401153E+01, 3.7821464972E+00, 2.7107900808E+00, 7.6082270478E-01],
	[1.8795000000E+04, 2.7513792338E+01, 1.4675916707E+01, 3.7853669954E+00, 2.7125306424E+00, 7.6092778551E-01],
	[1.8800000000E+04, 2.7524399139E+01, 1.4675432407E+01, 3.7885893765E+00, 2.7142715262E+00, 7.6103283097E-01],
	[1.8805000000E+04, 2.7535007206E+01, 1.4674948251E+01, 3.7918136413E+00, 2.7160127319E+00, 7.6113784118E-01],
	[1.8810000000E+04, 2.7545616540E+01, 1.4674464239E+01, 3.7950397902E+00, 2.7177542590E+00, 7.6124281612E-01],
	[1.8815000000E+04, 2.7556227141E+01, 1.4673980372E+01, 3.7982678240E+00, 2.7194961069E+00, 7.6134775581E-01],
	[1.8820000000E+04, 2.7566839008E+01, 1.4673496650E+01, 3.8014977432E+00, 2.7212382754E+00, 7.6145266024E-01],
	[1.8825000000E+04, 2.7577488470E+01, 1.4673024268E+01, 3.8047295483E+00, 2.7229815037E+00, 7.6155752943E-01],
	[1.8830000000E+04, 2.7588148367E+01, 1.4672554844E+01, 3.8079632401E+00, 2.7247252395E+00, 7.6166236336E-01],
	[1.8835000000E+04, 2.7598809552E+01, 1.4672085560E+01, 3.8111988191E+00, 2.7264692963E+00, 7.6176716204E-01],
	[1.8840000000E+04, 2.7609472026E+01, 1.4671616416E+01, 3.8144362859E+00, 2.7282136736E+00, 7.6187192549E-01],
	[1.8845000000E+04, 2.7620135788E+01, 1.4671147411E+01, 3.8176756411E+00, 2.7299583710E+00, 7.6197665369E-01],
	[1.8850000000E+04, 2.7630800838E+01, 1.4670678546E+01, 3.8209168852E+00, 2.7317033881E+00, 7.6208134665E-01],
	[1.8855000000E+04, 2.7641467176E+01, 1.4670209820E+01, 3.8241600190E+00, 2.7334487244E+00, 7.6218600437E-01],
	[1.8860000000E+04, 2.7652134801E+01, 1.4669741233E+01, 3.8274050430E+00, 2.7351943794E+00, 7.6229062686E-01],
	[1.8865000000E+04, 2.7662803715E+01, 1.4669272785E+01, 3.8306519577E+00, 2.7369403528E+00, 7.6239521412E-01],
	[1.8870000000E+04, 2.7673473916E+01, 1.4668804476E+01, 3.8339007639E+00, 2.7386866441E+00, 7.6249976615E-01],
	[1.8875000000E+04, 2.7684145404E+01, 1.4668336307E+01, 3.8371514620E+00, 2.7404332529E+00, 7.6260428296E-01],
	[1.8880000000E+04, 2.7694818179E+01, 1.4667868276E+01, 3.8404040528E+00, 2.7421801786E+00, 7.6270876454E-01],
	[1.8885000000E+04, 2.7705492240E+01, 1.4667400384E+01, 3.8436585367E+00, 2.7439274209E+00, 7.6281321091E-01],
	[1.8890000000E+04, 2.7716167589E+01, 1.4666932631E+01, 3.8469149144E+00, 2.7456749794E+00, 7.6291762205E-01],
	[1.8895000000E+04, 2.7726844224E+01, 1.4666465017E+01, 3.8501731865E+00, 2.7474228535E+00, 7.6302199798E-01],
	[1.8900000000E+04, 2.7737522145E+01, 1.4665997541E+01, 3.8534333536E+00, 2.7491710429E+00, 7.6312633870E-01],
	[1.8905000000E+04, 2.7748201352E+01, 1.4665530204E+01, 3.8566954163E+00, 2.7509195470E+00, 7.6323064421E-01],
	[1.8910000000E+04, 2.7758881845E+01, 1.4665063006E+01, 3.8599593751E+00, 2.7526683655E+00, 7.6333491451E-01],
	[1.8915000000E+04, 2.7769563624E+01, 1.4664595945E+01, 3.8632252308E+00, 2.7544174980E+00, 7.6343914961E-01],
	[1.8920000000E+04, 2.7780246688E+01, 1.4664129023E+01, 3.8664929838E+00, 2.7561669438E+00, 7.6354334951E-01],
	[1.8925000000E+04, 2.7790931038E+01, 1.4663662240E+01, 3.8697626348E+00, 2.7579167028E+00, 7.6364751421E-01],
	[1.8930000000E+04, 2.7801616673E+01, 1.4663195594E+01, 3.8730341843E+00, 2.7596667743E+00, 7.6375164372E-01],
	[1.8935000000E+04, 2.7812303593E+01, 1.4662729087E+01, 3.8763076331E+00, 2.7614171579E+00, 7.6385573803E-01],
	[1.8940000000E+04, 2.7822991797E+01, 1.4662262717E+01, 3.8795829816E+00, 2.7631678532E+00, 7.6395979716E-01],
	[1.8945000000E+04, 2.7833681287E+01, 1.4661796486E+01, 3.8828602306E+00, 2.7649188598E+00, 7.6406382110E-01],
	[1.8950000000E+04, 2.7844372060E+01, 1.4661330392E+01, 3.8861393804E+00, 2.7666701772E+00, 7.6416780985E-01],
	[1.8955000000E+04, 2.7855064118E+01, 1.4660864436E+01, 3.8894204319E+00, 2.7684218050E+00, 7.6427176343E-01],
	[1.8960000000E+04, 2.7865757460E+01, 1.4660398618E+01, 3.8927033855E+00, 2.7701737427E+00, 7.6437568182E-01],
	[1.8965000000E+04, 2.7876452086E+01, 1.4659932937E+01, 3.8959882420E+00, 2.7719259899E+00, 7.6447956505E-01],
	[1.8970000000E+04, 2.7887147995E+01, 1.4659467394E+01, 3.8992750017E+00, 2.7736785461E+00, 7.6458341310E-01],
	[1.8975000000E+04, 2.7897845188E+01, 1.4659001989E+01, 3.9025636655E+00, 2.7754314109E+00, 7.6468722598E-01],
	[1.8980000000E+04, 2.7908543665E+01, 1.4658536721E+01, 3.9058542338E+00, 2.7771845839E+00, 7.6479100370E-01],
	[1.8985000000E+04, 2.7919243424E+01, 1.4658071590E+01, 3.9091467074E+00, 2.7789380646E+00, 7.6489474626E-01],
	[1.8990000000E+04, 2.7929944466E+01, 1.4657606596E+01, 3.9124410866E+00, 2.7806918525E+00, 7.6499845365E-01],
	[1.8995000000E+04, 2.7940646791E+01, 1.4657141740E+01, 3.9157373723E+00, 2.7824459473E+00, 7.6510212589E-01],
	[1.9000000000E+04, 2.7951350399E+01, 1.4656677020E+01, 3.9190355649E+00, 2.7842003484E+00, 7.6520576298E-01],
	[1.9005000000E+04, 2.7962055289E+01, 1.4656212438E+01, 3.9223356651E+00, 2.7859550555E+00, 7.6530936492E-01],
	[1.9010000000E+04, 2.7972761461E+01, 1.4655747993E+01, 3.9256376735E+00, 2.7877100681E+00, 7.6541293171E-01],
	[1.9015000000E+04, 2.7983468916E+01, 1.4655283684E+01, 3.9289415906E+00, 2.7894653857E+00, 7.6551646336E-01],
	[1.9020000000E+04, 2.7994177652E+01, 1.4654819512E+01, 3.9322474171E+00, 2.7912210079E+00, 7.6561995987E-01],
	[1.9025000000E+04, 2.8004887670E+01, 1.4654355477E+01, 3.9355551536E+00, 2.7929769343E+00, 7.6572342124E-01],
	[1.9030000000E+04, 2.8015598969E+01, 1.4653891579E+01, 3.9388648006E+00, 2.7947331644E+00, 7.6582684747E-01],
	[1.9035000000E+04, 2.8026311550E+01, 1.4653427817E+01, 3.9421763588E+00, 2.7964896977E+00, 7.6593023858E-01],
	[1.9040000000E+04, 2.8037025411E+01, 1.4652964191E+01, 3.9454898288E+00, 2.7982465339E+00, 7.6603359456E-01],
	[1.9045000000E+04, 2.8047740554E+01, 1.4652500702E+01, 3.9488052111E+00, 2.8000036725E+00, 7.6613691541E-01],
	[1.9050000000E+04, 2.8058456977E+01, 1.4652037349E+01, 3.9521225065E+00, 2.8017611130E+00, 7.6624020114E-01],
	[1.9055000000E+04, 2.8069174681E+01, 1.4651574133E+01, 3.9554417153E+00, 2.8035188550E+00, 7.6634345176E-01],
	[1.9060000000E+04, 2.8079893665E+01, 1.4651111052E+01, 3.9587628384E+00, 2.8052768981E+00, 7.6644666726E-01],
	[1.9065000000E+04, 2.8090613930E+01, 1.4650648108E+01, 3.9620858762E+00, 2.8070352418E+00, 7.6654984765E-01],
	[1.9070000000E+04, 2.8101335474E+01, 1.4650185300E+01, 3.9654108294E+00, 2.8087938856E+00, 7.6665299293E-01],
	[1.9075000000E+04, 2.8112058299E+01, 1.4649722628E+01, 3.9687376986E+00, 2.8105528292E+00, 7.6675610311E-01],
	[1.9080000000E+04, 2.8122782403E+01, 1.4649260091E+01, 3.9720664843E+00, 2.8123120720E+00, 7.6685917818E-01],
	[1.9085000000E+04, 2.8133507786E+01, 1.4648797691E+01, 3.9753971872E+00, 2.8140716137E+00, 7.6696221816E-01],
	[1.9090000000E+04, 2.8144234449E+01, 1.4648335426E+01, 3.9787298078E+00, 2.8158314537E+00, 7.6706522305E-01],
	[1.9095000000E+04, 2.8154962390E+01, 1.4647873297E+01, 3.9820643469E+00, 2.8175915917E+00, 7.6716819284E-01],
	[1.9100000000E+04, 2.8165691611E+01, 1.4647411303E+01, 3.9854008048E+00, 2.8193520272E+00, 7.6727112754E-01],
	[1.9105000000E+04, 2.8176422110E+01, 1.4646949445E+01, 3.9887391824E+00, 2.8211127597E+00, 7.6737402717E-01],
	[1.9110000000E+04, 2.8187153888E+01, 1.4646487722E+01, 3.9920794801E+00, 2.8228737889E+00, 7.6747689171E-01],
	[1.9115000000E+04, 2.8197886945E+01, 1.4646026134E+01, 3.9954216986E+00, 2.8246351142E+00, 7.6757972117E-01],
	[1.9120000000E+04, 2.8208621279E+01, 1.4645564682E+01, 3.9987658385E+00, 2.8263967352E+00, 7.6768251556E-01],
	[1.9125000000E+04, 2.8219366246E+01, 1.4645106133E+01, 4.0021119004E+00, 2.8281588486E+00, 7.6778527488E-01],
	[1.9130000000E+04, 2.8230149843E+01, 1.4644658763E+01, 4.0054598848E+00, 2.8299220451E+00, 7.6788799914E-01],
	[1.9135000000E+04, 2.8240934741E+01, 1.4644211524E+01, 4.0088097923E+00, 2.8316855377E+00, 7.6799068833E-01],
	[1.9140000000E+04, 2.8251720940E+01, 1.4643764416E+01, 4.0121616237E+00, 2.8334493262E+00, 7.6809334246E-01],
	[1.9145000000E+04, 2.8262508439E+01, 1.4643317438E+01, 4.0155153794E+00, 2.8352134101E+00, 7.6819596153E-01],
	[1.9150000000E+04, 2.8273297239E+01, 1.4642870590E+01, 4.0188710601E+00, 2.8369777889E+00, 7.6829854556E-01],
	[1.9155000000E+04, 2.8284087339E+01, 1.4642423872E+01, 4.0222286664E+00, 2.8387424621E+00, 7.6840109453E-01],
	[1.9160000000E+04, 2.8294878739E+01, 1.4641977285E+01, 4.0255881988E+00, 2.8405074294E+00, 7.6850360846E-01],
	[1.9165000000E+04, 2.8305671440E+01, 1.4641530828E+01, 4.0289496580E+00, 2.8422726903E+00, 7.6860608735E-01],
	[1.9170000000E+04, 2.8316465440E+01, 1.4641084501E+01, 4.0323130446E+00, 2.8440382443E+00, 7.6870853120E-01],
	[1.9175000000E+04, 2.8327260739E+01, 1.4640638304E+01, 4.0356783592E+00, 2.8458040911E+00, 7.6881094001E-01],
	[1.9180000000E+04, 2.8338057338E+01, 1.4640192237E+01, 4.0390456023E+00, 2.8475702301E+00, 7.6891331380E-01],
	[1.9185000000E+04, 2.8348855236E+01, 1.4639746299E+01, 4.0424147746E+00, 2.8493366609E+00, 7.6901565256E-01],
	[1.9190000000E+04, 2.8359654434E+01, 1.4639300492E+01, 4.0457858767E+00, 2.8511033831E+00, 7.6911795628E-01],
	[1.9195000000E+04, 2.8370454930E+01, 1.4638854814E+01, 4.0491589092E+00, 2.8528703962E+00, 7.6922022488E-01],
	[1.9200000000E+04, 2.8381256724E+01, 1.4638409266E+01, 4.0525338726E+00, 2.8546376998E+00, 7.6932245836E-01],
	[1.9205000000E+04, 2.8392059818E+01, 1.4637963847E+01, 4.0559107676E+00, 2.8564052934E+00, 7.6942465671E-01],
	[1.9210000000E+04, 2.8402864209E+01, 1.4637518558E+01, 4.0592895948E+00, 2.8581731766E+00, 7.6952681992E-01],
	[1.9215000000E+04, 2.8413669899E+01, 1.4637073399E+01, 4.0626703548E+00, 2.8599413490E+00, 7.6962894800E-01],
	[1.9220000000E+04, 2.8424476886E+01, 1.4636628368E+01, 4.0660530482E+00, 2.8617098101E+00, 7.6973104094E-01],
	[1.9225000000E+04, 2.8435285171E+01, 1.4636183467E+01, 4.0694376755E+00, 2.8634785595E+00, 7.6983309874E-01],
	[1.9230000000E+04, 2.8446094754E+01, 1.4635738696E+01, 4.0728242375E+00, 2.8652475966E+00, 7.6993512140E-01],
	[1.9235000000E+04, 2.8456905635E+01, 1.4635294053E+01, 4.0762127346E+00, 2.8670169212E+00, 7.7003710891E-01],
	[1.9240000000E+04, 2.8467717812E+01, 1.4634849539E+01, 4.0796031675E+00, 2.8687865327E+00, 7.7013906128E-01],
	[1.9245000000E+04, 2.8478531286E+01, 1.4634405155E+01, 4.0829955367E+00, 2.8705564306E+00, 7.7024097850E-01],
	[1.9250000000E+04, 2.8489346058E+01, 1.4633960899E+01, 4.0863898430E+00, 2.8723266146E+00, 7.7034286056E-01],
	[1.9255000000E+04, 2.8500162126E+01, 1.4633516772E+01, 4.0897860869E+00, 2.8740970842E+00, 7.7044470748E-01],
	[1.9260000000E+04, 2.8510979490E+01, 1.4633072774E+01, 4.0931842689E+00, 2.8758678389E+00, 7.7054651923E-01],
	[1.9265000000E+04, 2.8521798151E+01, 1.4632628905E+01, 4.0965843897E+00, 2.8776388784E+00, 7.7064829583E-01],
	[1.9270000000E+04, 2.8532618108E+01, 1.4632185164E+01, 4.0999864500E+00, 2.8794102021E+00, 7.7075003727E-01],
	[1.9275000000E+04, 2.8543439361E+01, 1.4631741552E+01, 4.1033904502E+00, 2.8811818096E+00, 7.7085174355E-01],
	[1.9280000000E+04, 2.8554261909E+01, 1.4631298069E+01, 4.1067963910E+00, 2.8829537005E+00, 7.7095341467E-01],
	[1.9285000000E+04, 2.8565085753E+01, 1.4630854714E+01, 4.1102042730E+00, 2.8847258743E+00, 7.7105505062E-01],
	[1.9290000000E+04, 2.8575910893E+01, 1.4630411487E+01, 4.1136140968E+00, 2.8864983307E+00, 7.7115665140E-01],
	[1.9295000000E+04, 2.8586737327E+01, 1.4629968388E+01, 4.1170258630E+00, 2.8882710690E+00, 7.7125821701E-01],
	[1.9300000000E+04, 2.8597565057E+01, 1.4629525418E+01, 4.1204395722E+00, 2.8900440889E+00, 7.7135974745E-01],
	[1.9305000000E+04, 2.8608394082E+01, 1.4629082576E+01, 4.1238552250E+00, 2.8918173900E+00, 7.7146124272E-01],
	[1.9310000000E+04, 2.8619224401E+01, 1.4628639862E+01, 4.1272728220E+00, 2.8935909718E+00, 7.7156270282E-01],
	[1.9315000000E+04, 2.8630056015E+01, 1.4628197276E+01, 4.1306923638E+00, 2.8953648339E+00, 7.7166412773E-01],
	[1.9320000000E+04, 2.8640888923E+01, 1.4627754818E+01, 4.1341138510E+00, 2.8971389757E+00, 7.7176551747E-01],
	[1.9325000000E+04, 2.8651723125E+01, 1.4627312487E+01, 4.1375372842E+00, 2.8989133969E+00, 7.7186687203E-01],
	[1.9330000000E+04, 2.8662558621E+01, 1.4626870285E+01, 4.1409626640E+00, 2.9006880971E+00, 7.7196819141E-01],
	[1.9335000000E+04, 2.8673395411E+01, 1.4626428210E+01, 4.1443899911E+00, 2.9024630757E+00, 7.7206947560E-01],
	[1.9340000000E+04, 2.8684233495E+01, 1.4625986263E+01, 4.1478192659E+00, 2.9042383324E+00, 7.7217072461E-01],
	[1.9345000000E+04, 2.8695072872E+01, 1.4625544444E+01, 4.1512504892E+00, 2.9060138666E+00, 7.7227193843E-01],
	[1.9350000000E+04, 2.8705913542E+01, 1.4625102752E+01, 4.1546836614E+00, 2.9077896780E+00, 7.7237311706E-01],
	[1.9355000000E+04, 2.8716755505E+01, 1.4624661188E+01, 4.1581187833E+00, 2.9095657661E+00, 7.7247426050E-01],
	[1.9360000000E+04, 2.8727598761E+01, 1.4624219750E+01, 4.1615558554E+00, 2.9113421304E+00, 7.7257536875E-01],
	[1.9365000000E+04, 2.8738443310E+01, 1.4623778441E+01, 4.1649948783E+00, 2.9131187706E+00, 7.7267644180E-01],
	[1.9370000000E+04, 2.8749289151E+01, 1.4623337258E+01, 4.1684358527E+00, 2.9148956861E+00, 7.7277747966E-01],
	[1.9375000000E+04, 2.8760136285E+01, 1.4622896203E+01, 4.1718787790E+00, 2.9166728765E+00, 7.7287848233E-01],
	[1.9380000000E+04, 2.8770984711E+01, 1.4622455275E+01, 4.1753236580E+00, 2.9184503414E+00, 7.7297944980E-01],
	[1.9385000000E+04, 2.8781834428E+01, 1.4622014473E+01, 4.1787704902E+00, 2.9202280803E+00, 7.7308038207E-01],
	[1.9390000000E+04, 2.8792685438E+01, 1.4621573799E+01, 4.1822192763E+00, 2.9220060928E+00, 7.7318127913E-01],
	[1.9395000000E+04, 2.8803537739E+01, 1.4621133252E+01, 4.1856700167E+00, 2.9237843784E+00, 7.7328214100E-01],
	[1.9400000000E+04, 2.8814391332E+01, 1.4620692831E+01, 4.1891227122E+00, 2.9255629367E+00, 7.7338296766E-01],
	[1.9405000000E+04, 2.8825246216E+01, 1.4620252537E+01, 4.1925773634E+00, 2.9273417673E+00, 7.7348375912E-01],
	[1.9410000000E+04, 2.8836102390E+01, 1.4619812370E+01, 4.1960339707E+00, 2.9291208697E+00, 7.7358451537E-01],
	[1.9415000000E+04, 2.8846959856E+01, 1.4619372330E+01, 4.1994925350E+00, 2.9309002434E+00, 7.7368523642E-01],
	[1.9420000000E+04, 2.8857818613E+01, 1.4618932416E+01, 4.2029530566E+00, 2.9326798880E+00, 7.7378592225E-01],
	[1.9425000000E+04, 2.8868678660E+01, 1.4618492629E+01, 4.2064155363E+00, 2.9344598031E+00, 7.7388657288E-01],
	[1.9430000000E+04, 2.8879539997E+01, 1.4618052968E+01, 4.2098799746E+00, 2.9362399881E+00, 7.7398718830E-01],
	[1.9435000000E+04, 2.8890432648E+01, 1.4617621961E+01, 4.2133463722E+00, 2.9380210978E+00, 7.7408776850E-01],
	[1.9440000000E+04, 2.8901344526E+01, 1.4617196166E+01, 4.2168147296E+00, 2.9398028691E+00, 7.7418831349E-01],
	[1.9445000000E+04, 2.8912257716E+01, 1.4616770493E+01, 4.2202850475E+00, 2.9415849109E+00, 7.7428882327E-01],
	[1.9450000000E+04, 2.8923172220E+01, 1.4616344942E+01, 4.2237573264E+00, 2.9433672229E+00, 7.7438929783E-01],
	[1.9455000000E+04, 2.8934088038E+01, 1.4615919512E+01, 4.2272315670E+00, 2.9451498046E+00, 7.7448973718E-01],
	[1.9460000000E+04, 2.8945005168E+01, 1.4615494205E+01, 4.2307077699E+00, 2.9469326556E+00, 7.7459014130E-01],
	[1.9465000000E+04, 2.8955923612E+01, 1.4615069019E+01, 4.2341859356E+00, 2.9487157755E+00, 7.7469051021E-01],
	[1.9470000000E+04, 2.8966843368E+01, 1.4614643954E+01, 4.2376660647E+00, 2.9504991637E+00, 7.7479084390E-01],
	[1.9475000000E+04, 2.8977764436E+01, 1.4614219011E+01, 4.2411481580E+00, 2.9522828198E+00, 7.7489114237E-01],
	[1.9480000000E+04, 2.8988686817E+01, 1.4613794190E+01, 4.2446322159E+00, 2.9540667435E+00, 7.7499140562E-01],
	[1.9485000000E+04, 2.8999610510E+01, 1.4613369489E+01, 4.2481182390E+00, 2.9558509342E+00, 7.7509163365E-01],
	[1.9490000000E+04, 2.9010535516E+01, 1.4612944911E+01, 4.2516062281E+00, 2.9576353915E+00, 7.7519182646E-01],
	[1.9495000000E+04, 2.9021461833E+01, 1.4612520453E+01, 4.2550961836E+00, 2.9594201149E+00, 7.7529198404E-01],
	[1.9500000000E+04, 2.9032389461E+01, 1.4612096116E+01, 4.2585881062E+00, 2.9612051041E+00, 7.7539210639E-01],
	[1.9505000000E+04, 2.9043318401E+01, 1.4611671901E+01, 4.2620819964E+00, 2.9629903585E+00, 7.7549219352E-01],
	[1.9510000000E+04, 2.9054248653E+01, 1.4611247807E+01, 4.2655778550E+00, 2.9647758778E+00, 7.7559224543E-01],
	[1.9515000000E+04, 2.9065180215E+01, 1.4610823833E+01, 4.2690756824E+00, 2.9665616615E+00, 7.7569226210E-01],
	[1.9520000000E+04, 2.9076113089E+01, 1.4610399981E+01, 4.2725754793E+00, 2.9683477091E+00, 7.7579224356E-01],
	[1.9525000000E+04, 2.9087047273E+01, 1.4609976249E+01, 4.2760772463E+00, 2.9701340202E+00, 7.7589218978E-01],
	[1.9530000000E+04, 2.9097982768E+01, 1.4609552639E+01, 4.2795809840E+00, 2.9719205943E+00, 7.7599210077E-01],
	[1.9535000000E+04, 2.9108919573E+01, 1.4609129149E+01, 4.2830866930E+00, 2.9737074310E+00, 7.7609197653E-01],
	[1.9540000000E+04, 2.9119857688E+01, 1.4608705779E+01, 4.2865943739E+00, 2.9754945299E+00, 7.7619181707E-01],
	[1.9545000000E+04, 2.9130797114E+01, 1.4608282530E+01, 4.2901040273E+00, 2.9772818906E+00, 7.7629162237E-01],
	[1.9550000000E+04, 2.9141737849E+01, 1.4607859402E+01, 4.2936156538E+00, 2.9790695124E+00, 7.7639139244E-01],
	[1.9555000000E+04, 2.9152679894E+01, 1.4607436394E+01, 4.2971292540E+00, 2.9808573951E+00, 7.7649112728E-01],
	[1.9560000000E+04, 2.9163623248E+01, 1.4607013507E+01, 4.3006448285E+00, 2.9826455382E+00, 7.7659082689E-01],
	[1.9565000000E+04, 2.9174567912E+01, 1.4606590739E+01, 4.3041623779E+00, 2.9844339413E+00, 7.7669049126E-01],
	[1.9570000000E+04, 2.9185513885E+01, 1.4606168092E+01, 4.3076819029E+00, 2.9862226038E+00, 7.7679012040E-01],
	[1.9575000000E+04, 2.9196461167E+01, 1.4605745566E+01, 4.3112034039E+00, 2.9880115253E+00, 7.7688971431E-01],
	[1.9580000000E+04, 2.9207409758E+01, 1.4605323159E+01, 4.3147268817E+00, 2.9898007055E+00, 7.7698927298E-01],
	[1.9585000000E+04, 2.9218359657E+01, 1.4604900873E+01, 4.3182523368E+00, 2.9915901438E+00, 7.7708879642E-01],
	[1.9590000000E+04, 2.9229310865E+01, 1.4604478706E+01, 4.3217797698E+00, 2.9933798398E+00, 7.7718828463E-01],
	[1.9595000000E+04, 2.9240263381E+01, 1.4604056660E+01, 4.3253091814E+00, 2.9951697931E+00, 7.7728773759E-01],
	[1.9600000000E+04, 2.9251217205E+01, 1.4603634733E+01, 4.3288405721E+00, 2.9969600032E+00, 7.7738715533E-01],
	[1.9605000000E+04, 2.9262172337E+01, 1.4603212926E+01, 4.3323739425E+00, 2.9987504697E+00, 7.7748653783E-01],
	[1.9610000000E+04, 2.9273128777E+01, 1.4602791239E+01, 4.3359092932E+00, 3.0005411921E+00, 7.7758588509E-01],
	[1.9615000000E+04, 2.9284086524E+01, 1.4602369671E+01, 4.3394466250E+00, 3.0023321700E+00, 7.7768519711E-01],
	[1.9620000000E+04, 2.9295045579E+01, 1.4601948223E+01, 4.3429859382E+00, 3.0041234030E+00, 7.7778447390E-01],
	[1.9625000000E+04, 2.9306005940E+01, 1.4601526895E+01, 4.3465272336E+00, 3.0059148905E+00, 7.7788371545E-01],
	[1.9630000000E+04, 2.9316967609E+01, 1.4601105686E+01, 4.3500705117E+00, 3.0077066322E+00, 7.7798292177E-01],
	[1.9635000000E+04, 2.9327930585E+01, 1.4600684597E+01, 4.3536157733E+00, 3.0094986276E+00, 7.7808209285E-01],
	[1.9640000000E+04, 2.9338894867E+01, 1.4600263627E+01, 4.3571630187E+00, 3.0112908763E+00, 7.7818122869E-01],
	[1.9645000000E+04, 2.9349860456E+01, 1.4599842776E+01, 4.3607122487E+00, 3.0130833778E+00, 7.7828032929E-01],
	[1.9650000000E+04, 2.9360827351E+01, 1.4599422044E+01, 4.3642634639E+00, 3.0148761316E+00, 7.7837939466E-01],
	[1.9655000000E+04, 2.9371795553E+01, 1.4599001432E+01, 4.3678166649E+00, 3.0166691374E+00, 7.7847842479E-01],
	[1.9660000000E+04, 2.9382765060E+01, 1.4598580939E+01, 4.3713718522E+00, 3.0184623947E+00, 7.7857741969E-01],
	[1.9665000000E+04, 2.9393735873E+01, 1.4598160564E+01, 4.3749290265E+00, 3.0202559030E+00, 7.7867637934E-01],
	[1.9670000000E+04, 2.9404707992E+01, 1.4597740309E+01, 4.3784881884E+00, 3.0220496619E+00, 7.7877530376E-01],
	[1.9675000000E+04, 2.9415681416E+01, 1.4597320173E+01, 4.3820493385E+00, 3.0238436709E+00, 7.7887419294E-01],
	[1.9680000000E+04, 2.9426656145E+01, 1.4596900155E+01, 4.3856124773E+00, 3.0256379297E+00, 7.7897304689E-01],
	[1.9685000000E+04, 2.9437632179E+01, 1.4596480256E+01, 4.3891776056E+00, 3.0274324376E+00, 7.7907186560E-01],
	[1.9690000000E+04, 2.9448609519E+01, 1.4596060476E+01, 4.3927447238E+00, 3.0292271945E+00, 7.7917064907E-01],
	[1.9695000000E+04, 2.9459588163E+01, 1.4595640815E+01, 4.3963138327E+00, 3.0310221996E+00, 7.7926939730E-01],
	[1.9700000000E+04, 2.9470568111E+01, 1.4595221272E+01, 4.3998849327E+00, 3.0328174527E+00, 7.7936811030E-01],
	[1.9705000000E+04, 2.9481549364E+01, 1.4594801848E+01, 4.4034580245E+00, 3.0346129533E+00, 7.7946678807E-01],
	[1.9710000000E+04, 2.9492531921E+01, 1.4594382542E+01, 4.4070331088E+00, 3.0364087009E+00, 7.7956543059E-01],
	[1.9715000000E+04, 2.9503515782E+01, 1.4593963355E+01, 4.4106101860E+00, 3.0382046951E+00, 7.7966403788E-01],
	[1.9720000000E+04, 2.9514500947E+01, 1.4593544286E+01, 4.4141892569E+00, 3.0400009355E+00, 7.7976260994E-01],
	[1.9725000000E+04, 2.9525487416E+01, 1.4593125335E+01, 4.4177703220E+00, 3.0417974215E+00, 7.7986114676E-01],
	[1.9730000000E+04, 2.9536475188E+01, 1.4592706502E+01, 4.4213533819E+00, 3.0435941528E+00, 7.7995964835E-01],
	[1.9735000000E+04, 2.9547464263E+01, 1.4592287788E+01, 4.4249384373E+00, 3.0453911289E+00, 7.8005811470E-01],
	[1.9740000000E+04, 2.9558454642E+01, 1.4591869191E+01, 4.4285254886E+00, 3.0471883493E+00, 7.8015654582E-01],
	[1.9745000000E+04, 2.9569449322E+01, 1.4591451531E+01, 4.4321145366E+00, 3.0489858813E+00, 7.8025494171E-01],
	[1.9750000000E+04, 2.9580491515E+01, 1.4591046593E+01, 4.4357055819E+00, 3.0507846994E+00, 7.8035330236E-01],
	[1.9755000000E+04, 2.9591535035E+01, 1.4590641769E+01, 4.4392986250E+00, 3.0525837626E+00, 7.8045162778E-01],
	[1.9760000000E+04, 2.9602579882E+01, 1.4590237058E+01, 4.4428936665E+00, 3.0543830702E+00, 7.8054991797E-01],
	[1.9765000000E+04, 2.9613626055E+01, 1.4589832461E+01, 4.4464907071E+00, 3.0561826221E+00, 7.8064817293E-01],
	[1.9770000000E+04, 2.9624673554E+01, 1.4589427978E+01, 4.4500897474E+00, 3.0579824175E+00, 7.8074639265E-01],
	[1.9775000000E+04, 2.9635722380E+01, 1.4589023608E+01, 4.4536907879E+00, 3.0597824563E+00, 7.8084457715E-01],
	[1.9780000000E+04, 2.9646772531E+01, 1.4588619351E+01, 4.4572938292E+00, 3.0615827378E+00, 7.8094272641E-01],
	[1.9785000000E+04, 2.9657824008E+01, 1.4588215208E+01, 4.4608988721E+00, 3.0633832616E+00, 7.8104084045E-01],
	[1.9790000000E+04, 2.9668876811E+01, 1.4587811179E+01, 4.4645059170E+00, 3.0651840274E+00, 7.8113891926E-01],
	[1.9795000000E+04, 2.9679930939E+01, 1.4587407262E+01, 4.4681149646E+00, 3.0669850346E+00, 7.8123696284E-01],
	[1.9800000000E+04, 2.9690986392E+01, 1.4587003459E+01, 4.4717260154E+00, 3.0687862828E+00, 7.8133497119E-01],
	[1.9805000000E+04, 2.9702043171E+01, 1.4586599768E+01, 4.4753390702E+00, 3.0705877716E+00, 7.8143294432E-01],
	[1.9810000000E+04, 2.9713101274E+01, 1.4586196191E+01, 4.4789541294E+00, 3.0723895005E+00, 7.8153088222E-01],
	[1.9815000000E+04, 2.9724160702E+01, 1.4585792727E+01, 4.4825711937E+00, 3.0741914691E+00, 7.8162878489E-01],
	[1.9820000000E+04, 2.9735221455E+01, 1.4585389376E+01, 4.4861902638E+00, 3.0759936770E+00, 7.8172665234E-01],
	[1.9825000000E+04, 2.9746283531E+01, 1.4584986138E+01, 4.4898113401E+00, 3.0777961236E+00, 7.8182448457E-01],
	[1.9830000000E+04, 2.9757346932E+01, 1.4584583012E+01, 4.4934344233E+00, 3.0795988086E+00, 7.8192228158E-01],
	[1.9835000000E+04, 2.9768411657E+01, 1.4584179999E+01, 4.4970595141E+00, 3.0814017315E+00, 7.8202004336E-01],
	[1.9840000000E+04, 2.9779477706E+01, 1.4583777099E+01, 4.5006866129E+00, 3.0832048919E+00, 7.8211776992E-01],
	[1.9845000000E+04, 2.9790545079E+01, 1.4583374312E+01, 4.5043157205E+00, 3.0850082892E+00, 7.8221546126E-01],
	[1.9850000000E+04, 2.9801613775E+01, 1.4582971637E+01, 4.5079468374E+00, 3.0868119232E+00, 7.8231311739E-01],
	[1.9855000000E+04, 2.9812683794E+01, 1.4582569075E+01, 4.5115799643E+00, 3.0886157933E+00, 7.8241073829E-01],
	[1.9860000000E+04, 2.9823755136E+01, 1.4582166625E+01, 4.5152151016E+00, 3.0904198991E+00, 7.8250832398E-01],
	[1.9865000000E+04, 2.9834827801E+01, 1.4581764288E+01, 4.5188522501E+00, 3.0922242401E+00, 7.8260587445E-01],
	[1.9870000000E+04, 2.9845901790E+01, 1.4581362063E+01, 4.5224914104E+00, 3.0940288159E+00, 7.8270338971E-01],
	[1.9875000000E+04, 2.9856977100E+01, 1.4580959950E+01, 4.5261325830E+00, 3.0958336261E+00, 7.8280086975E-01],
	[1.9880000000E+04, 2.9868053733E+01, 1.4580557950E+01, 4.5297757685E+00, 3.0976386702E+00, 7.8289831458E-01],
	[1.9885000000E+04, 2.9879131689E+01, 1.4580156062E+01, 4.5334209676E+00, 3.0994439478E+00, 7.8299572420E-01],
	[1.9890000000E+04, 2.9890210966E+01, 1.4579754285E+01, 4.5370681809E+00, 3.1012494584E+00, 7.8309309861E-01],
	[1.9895000000E+04, 2.9901291565E+01, 1.4579352621E+01, 4.5407174089E+00, 3.1030552015E+00, 7.8319043780E-01],
	[1.9900000000E+04, 2.9912373486E+01, 1.4578951069E+01, 4.5443686523E+00, 3.1048611769E+00, 7.8328774179E-01],
	[1.9905000000E+04, 2.9923456729E+01, 1.4578549629E+01, 4.5480219117E+00, 3.1066673839E+00, 7.8338501057E-01],
	[1.9910000000E+04, 2.9934541293E+01, 1.4578148301E+01, 4.5516771877E+00, 3.1084738221E+00, 7.8348224414E-01],
	[1.9915000000E+04, 2.9945627178E+01, 1.4577747084E+01, 4.5553344808E+00, 3.1102804912E+00, 7.8357944251E-01],
	[1.9920000000E+04, 2.9956714384E+01, 1.4577345979E+01, 4.5589937918E+00, 3.1120873907E+00, 7.8367660568E-01],
	[1.9925000000E+04, 2.9967802911E+01, 1.4576944986E+01, 4.5626551211E+00, 3.1138945200E+00, 7.8377373364E-01],
	[1.9930000000E+04, 2.9978892759E+01, 1.4576544105E+01, 4.5663184694E+00, 3.1157018789E+00, 7.8387082639E-01],
	[1.9935000000E+04, 2.9989983927E+01, 1.4576143335E+01, 4.5699838374E+00, 3.1175094668E+00, 7.8396788393E-01],
	[1.9940000000E+04, 3.0001076415E+01, 1.4575742677E+01, 4.5736512255E+00, 3.1193172832E+00, 7.8406490628E-01],
	[1.9945000000E+04, 3.0012170224E+01, 1.4575342130E+01, 4.5773206345E+00, 3.1211253279E+00, 7.8416189341E-01],
	[1.9950000000E+04, 3.0023265353E+01, 1.4574941694E+01, 4.5809920649E+00, 3.1229336002E+00, 7.8425884534E-01],
	[1.9955000000E+04, 3.0034361801E+01, 1.4574541370E+01, 4.5846655173E+00, 3.1247420998E+00, 7.8435576207E-01],
	[1.9960000000E+04, 3.0045459569E+01, 1.4574141158E+01, 4.5883409923E+00, 3.1265508262E+00, 7.8445264359E-01],
	[1.9965000000E+04, 3.0056558657E+01, 1.4573741056E+01, 4.5920184906E+00, 3.1283597790E+00, 7.8454948990E-01],
	[1.9970000000E+04, 3.0067659063E+01, 1.4573341066E+01, 4.5956980127E+00, 3.1301689577E+00, 7.8464630101E-01],
	[1.9975000000E+04, 3.0078760789E+01, 1.4572941186E+01, 4.5993795593E+00, 3.1319783619E+00, 7.8474307692E-01],
	[1.9980000000E+04, 3.0089863834E+01, 1.4572541418E+01, 4.6030631309E+00, 3.1337879911E+00, 7.8483981762E-01],
	[1.9985000000E+04, 3.0100968198E+01, 1.4572141761E+01, 4.6067487282E+00, 3.1355978450E+00, 7.8493652311E-01],
	[1.9990000000E+04, 3.0112073880E+01, 1.4571742214E+01, 4.6104363518E+00, 3.1374079230E+00, 7.8503319341E-01],
	[1.9995000000E+04, 3.0123180881E+01, 1.4571342779E+01, 4.6141260022E+00, 3.1392182247E+00, 7.8512982849E-01],
	[2.0000000000E+04, 3.0134289199E+01, 1.4570943454E+01, 4.6178176801E+00, 3.1410287497E+00, 7.8522642838E-01],
	[2.0005000000E+04, 3.0145398836E+01, 1.4570544240E+01, 4.6215166776E+00, 3.1428419447E+00, 7.8532299306E-01],
	[2.0010000000E+04, 3.0156509791E+01, 1.4570145137E+01, 4.6252177113E+00, 3.1446553633E+00, 7.8541952254E-01],
	[2.0015000000E+04, 3.0167622064E+01, 1.4569746145E+01, 4.6289207816E+00, 3.1464690051E+00, 7.8551601682E-01],
	[2.0020000000E+04, 3.0178735654E+01, 1.4569347263E+01, 4.6326258893E+00, 3.1482828696E+00, 7.8561247589E-01],
	[2.0025000000E+04, 3.0189850561E+01, 1.4568948491E+01, 4.6363330350E+00, 3.1500969564E+00, 7.8570889977E-01],
	[2.0030000000E+04, 3.0200966786E+01, 1.4568549830E+01, 4.6400422191E+00, 3.1519112651E+00, 7.8580528844E-01],
	[2.0035000000E+04, 3.0212084328E+01, 1.4568151280E+01, 4.6437534424E+00, 3.1537257952E+00, 7.8590164191E-01],
	[2.0040000000E+04, 3.0223203186E+01, 1.4567752840E+01, 4.6474667055E+00, 3.1555405462E+00, 7.8599796019E-01],
	[2.0045000000E+04, 3.0234323361E+01, 1.4567354510E+01, 4.6511820090E+00, 3.1573555177E+00, 7.8609424326E-01],
	[2.0050000000E+04, 3.0245444853E+01, 1.4566956290E+01, 4.6548993534E+00, 3.1591707093E+00, 7.8619049113E-01],
	[2.0055000000E+04, 3.0256567661E+01, 1.4566558181E+01, 4.6586187394E+00, 3.1609861206E+00, 7.8628670381E-01],
	[2.0060000000E+04, 3.0267691786E+01, 1.4566160181E+01, 4.6623401677E+00, 3.1628017509E+00, 7.8638288129E-01],
	[2.0065000000E+04, 3.0278841797E+01, 1.4565768753E+01, 4.6660636387E+00, 3.1646181735E+00, 7.8647902357E-01],
	[2.0070000000E+04, 3.0290018879E+01, 1.4565384199E+01, 4.6697891532E+00, 3.1664354164E+00, 7.8657513066E-01],
	[2.0075000000E+04, 3.0301197302E+01, 1.4564999752E+01, 4.6735167117E+00, 3.1682528792E+00, 7.8667120255E-01],
	[2.0080000000E+04, 3.0312377064E+01, 1.4564615410E+01, 4.6772463149E+00, 3.1700705614E+00, 7.8676723924E-01],
	[2.0085000000E+04, 3.0323558167E+01, 1.4564231175E+01, 4.6809779633E+00, 3.1718884627E+00, 7.8686324075E-01],
	[2.0090000000E+04, 3.0334740609E+01, 1.4563847045E+01, 4.6847116576E+00, 3.1737065824E+00, 7.8695920705E-01],
	[2.0095000000E+04, 3.0345924390E+01, 1.4563463020E+01, 4.6884473983E+00, 3.1755249203E+00, 7.8705513817E-01],
	[2.0100000000E+04, 3.0357109511E+01, 1.4563079102E+01, 4.6921851862E+00, 3.1773434758E+00, 7.8715103409E-01],
	[2.0105000000E+04, 3.0368295971E+01, 1.4562695289E+01, 4.6959250218E+00, 3.1791622486E+00, 7.8724689483E-01],
	[2.0110000000E+04, 3.0379483770E+01, 1.4562311581E+01, 4.6996669057E+00, 3.1809812381E+00, 7.8734272037E-01],
	[2.0115000000E+04, 3.0390672908E+01, 1.4561927979E+01, 4.7034108385E+00, 3.1828004439E+00, 7.8743851072E-01],
	[2.0120000000E+04, 3.0401863384E+01, 1.4561544483E+01, 4.7071568208E+00, 3.1846198657E+00, 7.8753426589E-01],
	[2.0125000000E+04, 3.0413055199E+01, 1.4561161092E+01, 4.7109048533E+00, 3.1864395028E+00, 7.8762998587E-01],
	[2.0130000000E+04, 3.0424248352E+01, 1.4560777806E+01, 4.7146549365E+00, 3.1882593550E+00, 7.8772567066E-01],
	[2.0135000000E+04, 3.0435442843E+01, 1.4560394625E+01, 4.7184070712E+00, 3.1900794217E+00, 7.8782132027E-01],
	[2.0140000000E+04, 3.0446638672E+01, 1.4560011550E+01, 4.7221612578E+00, 3.1918997026E+00, 7.8791693469E-01],
	[2.0145000000E+04, 3.0457835839E+01, 1.4559628580E+01, 4.7259174969E+00, 3.1937201971E+00, 7.8801251393E-01],
	[2.0150000000E+04, 3.0469034343E+01, 1.4559245715E+01, 4.7296757893E+00, 3.1955409048E+00, 7.8810805799E-01],
	[2.0155000000E+04, 3.0480234185E+01, 1.4558862955E+01, 4.7334361355E+00, 3.1973618254E+00, 7.8820356686E-01],
	[2.0160000000E+04, 3.0491435364E+01, 1.4558480300E+01, 4.7371985362E+00, 3.1991829582E+00, 7.8829904056E-01],
	[2.0165000000E+04, 3.0502637880E+01, 1.4558097750E+01, 4.7409629918E+00, 3.2010043030E+00, 7.8839447908E-01],
	[2.0170000000E+04, 3.0513841733E+01, 1.4557715305E+01, 4.7447295031E+00, 3.2028258592E+00, 7.8848988242E-01],
	[2.0175000000E+04, 3.0525046923E+01, 1.4557332965E+01, 4.7484980707E+00, 3.2046476264E+00, 7.8858525058E-01],
	[2.0180000000E+04, 3.0536253449E+01, 1.4556950729E+01, 4.7522686952E+00, 3.2064696042E+00, 7.8868058357E-01],
	[2.0185000000E+04, 3.0547461312E+01, 1.4556568598E+01, 4.7560413771E+00, 3.2082917921E+00, 7.8877588138E-01],
	[2.0190000000E+04, 3.0558670510E+01, 1.4556186572E+01, 4.7598161171E+00, 3.2101141897E+00, 7.8887114402E-01],
	[2.0195000000E+04, 3.0569881045E+01, 1.4555804651E+01, 4.7635929158E+00, 3.2119367966E+00, 7.8896637149E-01],
	[2.0200000000E+04, 3.0581092916E+01, 1.4555422834E+01, 4.7673717739E+00, 3.2137596122E+00, 7.8906156379E-01],
	[2.0205000000E+04, 3.0592306122E+01, 1.4555041122E+01, 4.7711526918E+00, 3.2155826362E+00, 7.8915672092E-01],
	[2.0210000000E+04, 3.0603520664E+01, 1.4554659514E+01, 4.7749356703E+00, 3.2174058681E+00, 7.8925184289E-01],
	[2.0215000000E+04, 3.0614736542E+01, 1.4554278010E+01, 4.7787207100E+00, 3.2192293074E+00, 7.8934692968E-01],
	[2.0220000000E+04, 3.0625953754E+01, 1.4553896611E+01, 4.7825078114E+00, 3.2210529538E+00, 7.8944198132E-01],
	[2.0225000000E+04, 3.0637172302E+01, 1.4553515316E+01, 4.7862969752E+00, 3.2228768068E+00, 7.8953699779E-01],
	[2.0230000000E+04, 3.0648392184E+01, 1.4553134125E+01, 4.7900882020E+00, 3.2247008659E+00, 7.8963197909E-01],
	[2.0235000000E+04, 3.0659613401E+01, 1.4552753039E+01, 4.7938814924E+00, 3.2265251307E+00, 7.8972692524E-01],
	[2.0240000000E+04, 3.0670835952E+01, 1.4552372056E+01, 4.7976768470E+00, 3.2283496008E+00, 7.8982183623E-01],
	[2.0245000000E+04, 3.0682059838E+01, 1.4551991178E+01, 4.8014742664E+00, 3.2301742757E+00, 7.8991671206E-01],
	[2.0250000000E+04, 3.0693285058E+01, 1.4551610404E+01, 4.8052737512E+00, 3.2319991549E+00, 7.9001155273E-01],
	[2.0255000000E+04, 3.0704511612E+01, 1.4551229733E+01, 4.8090753021E+00, 3.2338242381E+00, 7.9010635825E-01],
	[2.0260000000E+04, 3.0715739500E+01, 1.4550849167E+01, 4.8128789197E+00, 3.2356495248E+00, 7.9020112862E-01],
	[2.0265000000E+04, 3.0726968721E+01, 1.4550468705E+01, 4.8166846045E+00, 3.2374750145E+00, 7.9029586384E-01],
	[2.0270000000E+04, 3.0738199276E+01, 1.4550088346E+01, 4.8204923572E+00, 3.2393007068E+00, 7.9039056390E-01],
	[2.0275000000E+04, 3.0749431164E+01, 1.4549708091E+01, 4.8243021784E+00, 3.2411266012E+00, 7.9048522882E-01],
	[2.0280000000E+04, 3.0760664385E+01, 1.4549327940E+01, 4.8281140687E+00, 3.2429526974E+00, 7.9057985860E-01],
	[2.0285000000E+04, 3.0771898939E+01, 1.4548947892E+01, 4.8319280287E+00, 3.2447789949E+00, 7.9067445322E-01],
	[2.0290000000E+04, 3.0783134826E+01, 1.4548567948E+01, 4.8357440590E+00, 3.2466054932E+00, 7.9076901271E-01],
	[2.0295000000E+04, 3.0794372046E+01, 1.4548188107E+01, 4.8395621603E+00, 3.2484321918E+00, 7.9086353706E-01],
	[2.0300000000E+04, 3.0805610598E+01, 1.4547808370E+01, 4.8433823331E+00, 3.2502590904E+00, 7.9095802626E-01],
	[2.0305000000E+04, 3.0816850482E+01, 1.4547428737E+01, 4.8472045781E+00, 3.2520861886E+00, 7.9105248033E-01],
	[2.0310000000E+04, 3.0828091698E+01, 1.4547049207E+01, 4.8510288959E+00, 3.2539134858E+00, 7.9114689926E-01],
	[2.0315000000E+04, 3.0839334247E+01, 1.4546669780E+01, 4.8548552871E+00, 3.2557409816E+00, 7.9124128306E-01],
	[2.0320000000E+04, 3.0850578127E+01, 1.4546290456E+01, 4.8586837522E+00, 3.2575686756E+00, 7.9133563173E-01],
	[2.0325000000E+04, 3.0861823338E+01, 1.4545911236E+01, 4.8625142920E+00, 3.2593965673E+00, 7.9142994527E-01],
	[2.0330000000E+04, 3.0873069881E+01, 1.4545532118E+01, 4.8663469070E+00, 3.2612246563E+00, 7.9152422368E-01],
	[2.0335000000E+04, 3.0884317756E+01, 1.4545153104E+01, 4.8701815978E+00, 3.2630529422E+00, 7.9161846696E-01],
	[2.0340000000E+04, 3.0895566961E+01, 1.4544774193E+01, 4.8740183651E+00, 3.2648814245E+00, 7.9171267512E-01],
	[2.0345000000E+04, 3.0906817498E+01, 1.4544395385E+01, 4.8778572095E+00, 3.2667101027E+00, 7.9180684815E-01],
	[2.0350000000E+04, 3.0918069365E+01, 1.4544016680E+01, 4.8816981315E+00, 3.2685389765E+00, 7.9190098607E-01],
	[2.0355000000E+04, 3.0929322562E+01, 1.4543638077E+01, 4.8855411319E+00, 3.2703680454E+00, 7.9199508887E-01],
	[2.0360000000E+04, 3.0940577090E+01, 1.4543259578E+01, 4.8893862111E+00, 3.2721973089E+00, 7.9208915655E-01],
	[2.0365000000E+04, 3.0951832949E+01, 1.4542881181E+01, 4.8932333698E+00, 3.2740267666E+00, 7.9218318912E-01],
	[2.0370000000E+04, 3.0963090137E+01, 1.4542502887E+01, 4.8970826087E+00, 3.2758564181E+00, 7.9227718657E-01],
	[2.0375000000E+04, 3.0974348655E+01, 1.4542124696E+01, 4.9009339283E+00, 3.2776862629E+00, 7.9237114892E-01],
	[2.0380000000E+04, 3.0985608503E+01, 1.4541746608E+01, 4.9047873292E+00, 3.2795163005E+00, 7.9246507616E-01],
	[2.0385000000E+04, 3.0996869681E+01, 1.4541368622E+01, 4.9086428121E+00, 3.2813465307E+00, 7.9255896829E-01],
	[2.0390000000E+04, 3.1008177733E+01, 1.4541002363E+01, 4.9125003776E+00, 3.2831780560E+00, 7.9265282532E-01],
	[2.0395000000E+04, 3.1019492628E+01, 1.4540637605E+01, 4.9163600263E+00, 3.2850099079E+00, 7.9274664725E-01],
	[2.0400000000E+04, 3.1030808877E+01, 1.4540272946E+01, 4.9202217588E+00, 3.2868419529E+00, 7.9284043408E-01],
	[2.0405000000E+04, 3.1042126478E+01, 1.4539908384E+01, 4.9240855757E+00, 3.2886741907E+00, 7.9293418581E-01],
	[2.0410000000E+04, 3.1053445434E+01, 1.4539543922E+01, 4.9279514776E+00, 3.2905066208E+00, 7.9302790245E-01],
	[2.0415000000E+04, 3.1064765742E+01, 1.4539179557E+01, 4.9318194651E+00, 3.2923392428E+00, 7.9312158399E-01],
	[2.0420000000E+04, 3.1076087404E+01, 1.4538815292E+01, 4.9356895389E+00, 3.2941720562E+00, 7.9321523045E-01],
	[2.0425000000E+04, 3.1087410418E+01, 1.4538451124E+01, 4.9395616996E+00, 3.2960050606E+00, 7.9330884182E-01],
	[2.0430000000E+04, 3.1098734785E+01, 1.4538087055E+01, 4.9434359478E+00, 3.2978382555E+00, 7.9340241810E-01],
	[2.0435000000E+04, 3.1110060505E+01, 1.4537723083E+01, 4.9473122840E+00, 3.2996716406E+00, 7.9349595930E-01],
	[2.0440000000E+04, 3.1121387577E+01, 1.4537359210E+01, 4.9511907089E+00, 3.3015052153E+00, 7.9358946542E-01],
	[2.0445000000E+04, 3.1132716001E+01, 1.4536995436E+01, 4.9550712232E+00, 3.3033389792E+00, 7.9368293647E-01],
	[2.0450000000E+04, 3.1144045777E+01, 1.4536631759E+01, 4.9589538274E+00, 3.3051729319E+00, 7.9377637243E-01],
	[2.0455000000E+04, 3.1155376905E+01, 1.4536268180E+01, 4.9628385221E+00, 3.3070070730E+00, 7.9386977333E-01],
	[2.0460000000E+04, 3.1166709384E+01, 1.4535904699E+01, 4.9667253080E+00, 3.3088414020E+00, 7.9396313915E-01],
	[2.0465000000E+04, 3.1178043215E+01, 1.4535541316E+01, 4.9706141857E+00, 3.3106759184E+00, 7.9405646991E-01],
	[2.0470000000E+04, 3.1189378398E+01, 1.4535178031E+01, 4.9745051557E+00, 3.3125106219E+00, 7.9414976560E-01],
	[2.0475000000E+04, 3.1200714931E+01, 1.4534814844E+01, 4.9783982188E+00, 3.3143455119E+00, 7.9424302622E-01],
	[2.0480000000E+04, 3.1212052816E+01, 1.4534451754E+01, 4.9822933754E+00, 3.3161805882E+00, 7.9433625179E-01],
	[2.0485000000E+04, 3.1223392051E+01, 1.4534088762E+01, 4.9861906263E+00, 3.3180158501E+00, 7.9442944230E-01],
	[2.0490000000E+04, 3.1234732637E+01, 1.4533725868E+01, 4.9900899720E+00, 3.3198512973E+00, 7.9452259775E-01],
	[2.0495000000E+04, 3.1246074573E+01, 1.4533363071E+01, 4.9939914131E+00, 3.3216869293E+00, 7.9461571815E-01],
	[2.0500000000E+04, 3.1257417860E+01, 1.4533000372E+01, 4.9978949503E+00, 3.3235227457E+00, 7.9470880351E-01],
	[2.0505000000E+04, 3.1268762497E+01, 1.4532637771E+01, 5.0018005842E+00, 3.3253587461E+00, 7.9480185381E-01],
	[2.0510000000E+04, 3.1280108484E+01, 1.4532275267E+01, 5.0057083154E+00, 3.3271949300E+00, 7.9489486907E-01],
	[2.0515000000E+04, 3.1291455820E+01, 1.4531912860E+01, 5.0096181444E+00, 3.3290312970E+00, 7.9498784929E-01],
	[2.0520000000E+04, 3.1302804507E+01, 1.4531550550E+01, 5.0135300720E+00, 3.3308678466E+00, 7.9508079447E-01],
	[2.0525000000E+04, 3.1314154542E+01, 1.4531188338E+01, 5.0174440987E+00, 3.3327045784E+00, 7.9517370461E-01],
	[2.0530000000E+04, 3.1325505927E+01, 1.4530826224E+01, 5.0213602252E+00, 3.3345414920E+00, 7.9526657972E-01],
	[2.0535000000E+04, 3.1336858662E+01, 1.4530464206E+01, 5.0252784520E+00, 3.3363785869E+00, 7.9535941980E-01],
	[2.0540000000E+04, 3.1348212745E+01, 1.4530102286E+01, 5.0291987798E+00, 3.3382158626E+00, 7.9545222485E-01],
	[2.0545000000E+04, 3.1359568177E+01, 1.4529740462E+01, 5.0331212091E+00, 3.3400533189E+00, 7.9554499488E-01],
	[2.0550000000E+04, 3.1370924957E+01, 1.4529378736E+01, 5.0370457407E+00, 3.3418909551E+00, 7.9563772989E-01],
	[2.0555000000E+04, 3.1382283086E+01, 1.4529017107E+01, 5.0409723750E+00, 3.3437287709E+00, 7.9573042987E-01],
	[2.0560000000E+04, 3.1393642563E+01, 1.4528655574E+01, 5.0449011128E+00, 3.3455667658E+00, 7.9582309484E-01],
	[2.0565000000E+04, 3.1405003389E+01, 1.4528294139E+01, 5.0488319546E+00, 3.3474049394E+00, 7.9591572480E-01],
	[2.0570000000E+04, 3.1416365562E+01, 1.4527932800E+01, 5.0527649011E+00, 3.3492432912E+00, 7.9600831974E-01],
	[2.0575000000E+04, 3.1427729083E+01, 1.4527571558E+01, 5.0566999528E+00, 3.3510818209E+00, 7.9610087968E-01],
	[2.0580000000E+04, 3.1439093952E+01, 1.4527210413E+01, 5.0606371105E+00, 3.3529205279E+00, 7.9619340462E-01],
	[2.0585000000E+04, 3.1450460168E+01, 1.4526849365E+01, 5.0645763746E+00, 3.3547594119E+00, 7.9628589455E-01],
	[2.0590000000E+04, 3.1461827731E+01, 1.4526488413E+01, 5.0685177458E+00, 3.3565984724E+00, 7.9637834949E-01],
	[2.0595000000E+04, 3.1473196642E+01, 1.4526127558E+01, 5.0724612247E+00, 3.3584377089E+00, 7.9647076943E-01],
	[2.0600000000E+04, 3.1484566900E+01, 1.4525766800E+01, 5.0764068120E+00, 3.3602771210E+00, 7.9656315438E-01],
	[2.0605000000E+04, 3.1495938504E+01, 1.4525406138E+01, 5.0803545082E+00, 3.3621167084E+00, 7.9665550434E-01],
	[2.0610000000E+04, 3.1507311455E+01, 1.4525045572E+01, 5.0843043139E+00, 3.3639564704E+00, 7.9674781931E-01],
	[2.0615000000E+04, 3.1518685752E+01, 1.4524685103E+01, 5.0882562299E+00, 3.3657964068E+00, 7.9684009925E-01],
	[2.0620000000E+04, 3.1530061396E+01, 1.4524324730E+01, 5.0922102566E+00, 3.3676365171E+00, 7.9693234408E-01],
	[2.0625000000E+04, 3.1541438385E+01, 1.4523964454E+01, 5.0961663947E+00, 3.3694768008E+00, 7.9702455381E-01],
	[2.0630000000E+04, 3.1552816721E+01, 1.4523604274E+01, 5.1001246449E+00, 3.3713172574E+00, 7.9711672845E-01],
	[2.0635000000E+04, 3.1564196403E+01, 1.4523244190E+01, 5.1040850076E+00, 3.3731578867E+00, 7.9720886800E-01],
	[2.0640000000E+04, 3.1575577430E+01, 1.4522884202E+01, 5.1080474837E+00, 3.3749986880E+00, 7.9730097247E-01],
	[2.0645000000E+04, 3.1586959802E+01, 1.4522524310E+01, 5.1120120735E+00, 3.3768396611E+00, 7.9739304187E-01],
	[2.0650000000E+04, 3.1598343520E+01, 1.4522164514E+01, 5.1159787779E+00, 3.3786808054E+00, 7.9748507621E-01],
	[2.0655000000E+04, 3.1609728583E+01, 1.4521804815E+01, 5.1199475973E+00, 3.3805221204E+00, 7.9757707550E-01],
	[2.0660000000E+04, 3.1621114991E+01, 1.4521445211E+01, 5.1239185325E+00, 3.3823636059E+00, 7.9766903973E-01],
	[2.0665000000E+04, 3.1632502743E+01, 1.4521085703E+01, 5.1278915839E+00, 3.3842052613E+00, 7.9776096893E-01],
	[2.0670000000E+04, 3.1643891840E+01, 1.4520726292E+01, 5.1318667523E+00, 3.3860470862E+00, 7.9785286309E-01],
	[2.0675000000E+04, 3.1655282282E+01, 1.4520366976E+01, 5.1358440382E+00, 3.3878890801E+00, 7.9794472223E-01],
	[2.0680000000E+04, 3.1666674068E+01, 1.4520007755E+01, 5.1398234423E+00, 3.3897312427E+00, 7.9803654636E-01],
	[2.0685000000E+04, 3.1678067198E+01, 1.4519648631E+01, 5.1438049652E+00, 3.3915735734E+00, 7.9812833547E-01],
	[2.0690000000E+04, 3.1689461672E+01, 1.4519289602E+01, 5.1477886074E+00, 3.3934160719E+00, 7.9822008958E-01],
	[2.0695000000E+04, 3.1700857490E+01, 1.4518930669E+01, 5.1517743697E+00, 3.3952587377E+00, 7.9831180870E-01],
	[2.0700000000E+04, 3.1712254651E+01, 1.4518571831E+01, 5.1557622525E+00, 3.3971015704E+00, 7.9840349283E-01],
	[2.0705000000E+04, 3.1723653156E+01, 1.4518213089E+01, 5.1597522566E+00, 3.3989445695E+00, 7.9849514198E-01],
	[2.0710000000E+04, 3.1735053004E+01, 1.4517854442E+01, 5.1637443826E+00, 3.4007877346E+00, 7.9858675616E-01],
	[2.0715000000E+04, 3.1746467461E+01, 1.4517499182E+01, 5.1677386310E+00, 3.4026313984E+00, 7.9867833538E-01],
	[2.0720000000E+04, 3.1757921718E+01, 1.4517153552E+01, 5.1717350024E+00, 3.4044761943E+00, 7.9876987965E-01],
	[2.0725000000E+04, 3.1769377343E+01, 1.4516808014E+01, 5.1757334976E+00, 3.4063211569E+00, 7.9886138896E-01],
	[2.0730000000E+04, 3.1780834335E+01, 1.4516462568E+01, 5.1797341171E+00, 3.4081662859E+00, 7.9895286334E-01],
	[2.0735000000E+04, 3.1792292694E+01, 1.4516117213E+01, 5.1837368614E+00, 3.4100115809E+00, 7.9904430278E-01],
	[2.0740000000E+04, 3.1803752421E+01, 1.4515771949E+01, 5.1877417314E+00, 3.4118570413E+00, 7.9913570730E-01],
	[2.0745000000E+04, 3.1815213514E+01, 1.4515426777E+01, 5.1917487274E+00, 3.4137026668E+00, 7.9922707691E-01],
	[2.0750000000E+04, 3.1826675974E+01, 1.4515081697E+01, 5.1957578502E+00, 3.4155484569E+00, 7.9931841160E-01],
	[2.0755000000E+04, 3.1838139800E+01, 1.4514736707E+01, 5.1997691004E+00, 3.4173944112E+00, 7.9940971139E-01],
	[2.0760000000E+04, 3.1849604993E+01, 1.4514391809E+01, 5.2037824786E+00, 3.4192405292E+00, 7.9950097629E-01],
	[2.0765000000E+04, 3.1861071552E+01, 1.4514047002E+01, 5.2077979854E+00, 3.4210868106E+00, 7.9959220631E-01],
	[2.0770000000E+04, 3.1872539477E+01, 1.4513702287E+01, 5.2118156214E+00, 3.4229332549E+00, 7.9968340145E-01],
	[2.0775000000E+04, 3.1884008768E+01, 1.4513357662E+01, 5.2158353873E+00, 3.4247798616E+00, 7.9977456172E-01],
	[2.0780000000E+04, 3.1895479424E+01, 1.4513013129E+01, 5.2198572836E+00, 3.4266266303E+00, 7.9986568712E-01],
	[2.0785000000E+04, 3.1906951446E+01, 1.4512668687E+01, 5.2238813109E+00, 3.4284735606E+00, 7.9995677768E-01],
	[2.0790000000E+04, 3.1918424834E+01, 1.4512324335E+01, 5.2279074700E+00, 3.4303206520E+00, 8.0004783338E-01],
	[2.0795000000E+04, 3.1929899586E+01, 1.4511980075E+01, 5.2319357613E+00, 3.4321679041E+00, 8.0013885425E-01],
	[2.0800000000E+04, 3.1941375704E+01, 1.4511635906E+01, 5.2359661856E+00, 3.4340153166E+00, 8.0022984029E-01],
	[2.0805000000E+04, 3.1952853186E+01, 1.4511291827E+01, 5.2399987434E+00, 3.4358628888E+00, 8.0032079151E-01],
	[2.0810000000E+04, 3.1964332034E+01, 1.4510947840E+01, 5.2440334353E+00, 3.4377106205E+00, 8.0041170792E-01],
	[2.0815000000E+04, 3.1975812245E+01, 1.4510603943E+01, 5.2480702620E+00, 3.4395585111E+00, 8.0050258951E-01],
	[2.0820000000E+04, 3.1987293821E+01, 1.4510260137E+01, 5.2521092240E+00, 3.4414065603E+00, 8.0059343631E-01],
	[2.0825000000E+04, 3.1998776762E+01, 1.4509916421E+01, 5.2561503220E+00, 3.4432547676E+00, 8.0068424832E-01],
	[2.0830000000E+04, 3.2010261066E+01, 1.4509572797E+01, 5.2601935567E+00, 3.4451031325E+00, 8.0077502555E-01],
	[2.0835000000E+04, 3.2021746734E+01, 1.4509229263E+01, 5.2642389285E+00, 3.4469516547E+00, 8.0086576800E-01],
	[2.0840000000E+04, 3.2033233766E+01, 1.4508885819E+01, 5.2682864382E+00, 3.4488003337E+00, 8.0095647569E-01],
	[2.0845000000E+04, 3.2044722162E+01, 1.4508542466E+01, 5.2723360863E+00, 3.4506491690E+00, 8.0104714861E-01],
	[2.0850000000E+04, 3.2056211920E+01, 1.4508199203E+01, 5.2763878735E+00, 3.4524981603E+00, 8.0113778679E-01],
	[2.0855000000E+04, 3.2067703043E+01, 1.4507856031E+01, 5.2804418004E+00, 3.4543473071E+00, 8.0122839023E-01],
	[2.0860000000E+04, 3.2079195528E+01, 1.4507512950E+01, 5.2844978675E+00, 3.4561966089E+00, 8.0131895893E-01],
	[2.0865000000E+04, 3.2090689376E+01, 1.4507169958E+01, 5.2885560756E+00, 3.4580460654E+00, 8.0140949290E-01],
	[2.0870000000E+04, 3.2102184586E+01, 1.4506827057E+01, 5.2926164252E+00, 3.4598956761E+00, 8.0149999216E-01],
	[2.0875000000E+04, 3.2113681159E+01, 1.4506484246E+01, 5.2966789169E+00, 3.4617454406E+00, 8.0159045671E-01],
	[2.0880000000E+04, 3.2125179095E+01, 1.4506141525E+01, 5.3007435514E+00, 3.4635953583E+00, 8.0168088655E-01],
	[2.0885000000E+04, 3.2136678393E+01, 1.4505798895E+01, 5.3048103293E+00, 3.4654454290E+00, 8.0177128170E-01],
	[2.0890000000E+04, 3.2148179053E+01, 1.4505456354E+01, 5.3088792511E+00, 3.4672956522E+00, 8.0186164217E-01],
	[2.0895000000E+04, 3.2159681074E+01, 1.4505113904E+01, 5.3129503176E+00, 3.4691460274E+00, 8.0195196795E-01],
	[2.0900000000E+04, 3.2171184458E+01, 1.4504771544E+01, 5.3170235292E+00, 3.4709965542E+00, 8.0204225907E-01],
	[2.0905000000E+04, 3.2182689203E+01, 1.4504429273E+01, 5.3210988867E+00, 3.4728472321E+00, 8.0213251553E-01],
	[2.0910000000E+04, 3.2194195309E+01, 1.4504087093E+01, 5.3251763906E+00, 3.4746980608E+00, 8.0222273733E-01],
	[2.0915000000E+04, 3.2205702777E+01, 1.4503745002E+01, 5.3292560416E+00, 3.4765490398E+00, 8.0231292449E-01],
	[2.0920000000E+04, 3.2217211606E+01, 1.4503403001E+01, 5.3333378403E+00, 3.4784001687E+00, 8.0240307701E-01],
	[2.0925000000E+04, 3.2228721795E+01, 1.4503061090E+01, 5.3374217873E+00, 3.4802514470E+00, 8.0249319490E-01],
	[2.0930000000E+04, 3.2240233346E+01, 1.4502719269E+01, 5.3415078832E+00, 3.4821028743E+00, 8.0258327817E-01],
	[2.0935000000E+04, 3.2251746257E+01, 1.4502377538E+01, 5.3455961286E+00, 3.4839544501E+00, 8.0267332683E-01],
	[2.0940000000E+04, 3.2263260528E+01, 1.4502035896E+01, 5.3496865242E+00, 3.4858061742E+00, 8.0276334088E-01],
	[2.0945000000E+04, 3.2274776160E+01, 1.4501694344E+01, 5.3537790705E+00, 3.4876580459E+00, 8.0285332034E-01],
	[2.0950000000E+04, 3.2286293151E+01, 1.4501352881E+01, 5.3578737682E+00, 3.4895100649E+00, 8.0294326521E-01],
	[2.0955000000E+04, 3.2297811503E+01, 1.4501011508E+01, 5.3619706178E+00, 3.4913622307E+00, 8.0303317550E-01],
	[2.0960000000E+04, 3.2309331214E+01, 1.4500670224E+01, 5.3660696201E+00, 3.4932145430E+00, 8.0312305122E-01],
	[2.0965000000E+04, 3.2320852285E+01, 1.4500329030E+01, 5.3701707756E+00, 3.4950670012E+00, 8.0321289237E-01],
	[2.0970000000E+04, 3.2332374716E+01, 1.4499987925E+01, 5.3742740850E+00, 3.4969196050E+00, 8.0330269897E-01],
	[2.0975000000E+04, 3.2343898505E+01, 1.4499646910E+01, 5.3783795488E+00, 3.4987723539E+00, 8.0339247103E-01],
	[2.0980000000E+04, 3.2355423654E+01, 1.4499305983E+01, 5.3824871676E+00, 3.5006252475E+00, 8.0348220854E-01],
	[2.0985000000E+04, 3.2366950162E+01, 1.4498965147E+01, 5.3865969422E+00, 3.5024782853E+00, 8.0357191153E-01],
	[2.0990000000E+04, 3.2378478028E+01, 1.4498624399E+01, 5.3907088731E+00, 3.5043314670E+00, 8.0366157999E-01],
	[2.0995000000E+04, 3.2390007253E+01, 1.4498283740E+01, 5.3948229608E+00, 3.5061847920E+00, 8.0375121394E-01],
	[2.1000000000E+04, 3.2401537836E+01, 1.4497943171E+01, 5.3989392061E+00, 3.5080382600E+00, 8.0384081338E-01],
	[2.1005000000E+04, 3.2413069778E+01, 1.4497602690E+01, 5.4030576096E+00, 3.5098918706E+00, 8.0393037833E-01],
	[2.1010000000E+04, 3.2424603078E+01, 1.4497262299E+01, 5.4071781718E+00, 3.5117456232E+00, 8.0401990879E-01],
	[2.1015000000E+04, 3.2436137736E+01, 1.4496921997E+01, 5.4113008934E+00, 3.5135995175E+00, 8.0410940476E-01],
	[2.1020000000E+04, 3.2447673751E+01, 1.4496581783E+01, 5.4154257750E+00, 3.5154535530E+00, 8.0419886627E-01],
	[2.1025000000E+04, 3.2459211125E+01, 1.4496241659E+01, 5.4195528173E+00, 3.5173077294E+00, 8.0428829331E-01],
	[2.1030000000E+04, 3.2470749855E+01, 1.4495901623E+01, 5.4236820207E+00, 3.5191620461E+00, 8.0437768590E-01],
	[2.1035000000E+04, 3.2482289943E+01, 1.4495561676E+01, 5.4278133860E+00, 3.5210165027E+00, 8.0446704404E-01],
	[2.1040000000E+04, 3.2493831389E+01, 1.4495221818E+01, 5.4319469138E+00, 3.5228710989E+00, 8.0455636774E-01],
	[2.1045000000E+04, 3.2505374191E+01, 1.4494882049E+01, 5.4360826047E+00, 3.5247258341E+00, 8.0464565701E-01],
	[2.1050000000E+04, 3.2516947907E+01, 1.4494549493E+01, 5.4402204592E+00, 3.5265814774E+00, 8.0473491186E-01],
	[2.1055000000E+04, 3.2528545847E+01, 1.4494222530E+01, 5.4443604781E+00, 3.5284378554E+00, 8.0482413230E-01],
	[2.1060000000E+04, 3.2540145168E+01, 1.4493895653E+01, 5.4485026619E+00, 3.5302943733E+00, 8.0491331833E-01],
	[2.1065000000E+04, 3.2551745870E+01, 1.4493568860E+01, 5.4526470112E+00, 3.5321510307E+00, 8.0500246996E-01],
	[2.1070000000E+04, 3.2563347953E+01, 1.4493242153E+01, 5.4567935267E+00, 3.5340078272E+00, 8.0509158721E-01],
	[2.1075000000E+04, 3.2574951417E+01, 1.4492915530E+01, 5.4609422090E+00, 3.5358647623E+00, 8.0518067007E-01],
	[2.1080000000E+04, 3.2586556262E+01, 1.4492588992E+01, 5.4650930587E+00, 3.5377218356E+00, 8.0526971857E-01],
	[2.1085000000E+04, 3.2598162487E+01, 1.4492262539E+01, 5.4692460764E+00, 3.5395790467E+00, 8.0535873270E-01],
	[2.1090000000E+04, 3.2609770092E+01, 1.4491936171E+01, 5.4734012627E+00, 3.5414363952E+00, 8.0544771248E-01],
	[2.1095000000E+04, 3.2621379078E+01, 1.4491609887E+01, 5.4775586183E+00, 3.5432938806E+00, 8.0553665791E-01],
	[2.1100000000E+04, 3.2632989444E+01, 1.4491283688E+01, 5.4817181437E+00, 3.5451515025E+00, 8.0562556901E-01],
	[2.1105000000E+04, 3.2644601189E+01, 1.4490957574E+01, 5.4858798396E+00, 3.5470092605E+00, 8.0571444577E-01],
	[2.1110000000E+04, 3.2656214315E+01, 1.4490631544E+01, 5.4900437066E+00, 3.5488671542E+00, 8.0580328822E-01],
	[2.1115000000E+04, 3.2667828820E+01, 1.4490305599E+01, 5.4942097454E+00, 3.5507251830E+00, 8.0589209635E-01],
	[2.1120000000E+04, 3.2679444704E+01, 1.4489979738E+01, 5.4983779564E+00, 3.5525833466E+00, 8.0598087018E-01],
	[2.1125000000E+04, 3.2691061967E+01, 1.4489653962E+01, 5.5025483404E+00, 3.5544416446E+00, 8.0606960972E-01],
	[2.1130000000E+04, 3.2702680610E+01, 1.4489328270E+01, 5.5067208980E+00, 3.5563000765E+00, 8.0615831497E-01],
	[2.1135000000E+04, 3.2714300631E+01, 1.4489002662E+01, 5.5108956297E+00, 3.5581586420E+00, 8.0624698594E-01],
	[2.1140000000E+04, 3.2725922031E+01, 1.4488677139E+01, 5.5150725363E+00, 3.5600173405E+00, 8.0633562264E-01],
	[2.1145000000E+04, 3.2737544810E+01, 1.4488351700E+01, 5.5192516183E+00, 3.5618761716E+00, 8.0642422508E-01],
	[2.1150000000E+04, 3.2749168967E+01, 1.4488026346E+01, 5.5234328763E+00, 3.5637351350E+00, 8.0651279327E-01],
	[2.1155000000E+04, 3.2760794502E+01, 1.4487701076E+01, 5.5276163109E+00, 3.5655942301E+00, 8.0660132722E-01],
	[2.1160000000E+04, 3.2772421416E+01, 1.4487375889E+01, 5.5318019228E+00, 3.5674534567E+00, 8.0668982693E-01],
	[2.1165000000E+04, 3.2784049707E+01, 1.4487050787E+01, 5.5359897126E+00, 3.5693128141E+00, 8.0677829242E-01],
	[2.1170000000E+04, 3.2795679376E+01, 1.4486725769E+01, 5.5401796809E+00, 3.5711723021E+00, 8.0686672368E-01],
	[2.1175000000E+04, 3.2807310423E+01, 1.4486400835E+01, 5.5443718283E+00, 3.5730319201E+00, 8.0695512074E-01],
	[2.1180000000E+04, 3.2818942847E+01, 1.4486075985E+01, 5.5485661555E+00, 3.5748916678E+00, 8.0704348360E-01],
	[2.1185000000E+04, 3.2830576648E+01, 1.4485751220E+01, 5.5527626630E+00, 3.5767515447E+00, 8.0713181227E-01],
	[2.1190000000E+04, 3.2842211826E+01, 1.4485426537E+01, 5.5569613515E+00, 3.5786115505E+00, 8.0722010675E-01],
	[2.1195000000E+04, 3.2853848382E+01, 1.4485101939E+01, 5.5611622215E+00, 3.5804716846E+00, 8.0730836706E-01],
	[2.1200000000E+04, 3.2865486314E+01, 1.4484777425E+01, 5.5653652738E+00, 3.5823319466E+00, 8.0739659320E-01],
	[2.1205000000E+04, 3.2877125623E+01, 1.4484452994E+01, 5.5695705089E+00, 3.5841923362E+00, 8.0748478519E-01],
	[2.1210000000E+04, 3.2888766308E+01, 1.4484128648E+01, 5.5737779274E+00, 3.5860528528E+00, 8.0757294302E-01],
	[2.1215000000E+04, 3.2900408369E+01, 1.4483804385E+01, 5.5779875300E+00, 3.5879134962E+00, 8.0766106672E-01],
	[2.1220000000E+04, 3.2912051807E+01, 1.4483480205E+01, 5.5821993172E+00, 3.5897742657E+00, 8.0774915629E-01],
	[2.1225000000E+04, 3.2923696621E+01, 1.4483156109E+01, 5.5864132898E+00, 3.5916351611E+00, 8.0783721173E-01],
	[2.1230000000E+04, 3.2935342810E+01, 1.4482832097E+01, 5.5906294482E+00, 3.5934961819E+00, 8.0792523306E-01],
	[2.1235000000E+04, 3.2946990375E+01, 1.4482508169E+01, 5.5948477932E+00, 3.5953573276E+00, 8.0801322028E-01],
	[2.1240000000E+04, 3.2958639315E+01, 1.4482184323E+01, 5.5990683253E+00, 3.5972185979E+00, 8.0810117341E-01],
	[2.1245000000E+04, 3.2970289631E+01, 1.4481860562E+01, 5.6032910452E+00, 3.5990799922E+00, 8.0818909245E-01],
	[2.1250000000E+04, 3.2981941322E+01, 1.4481536884E+01, 5.6075159535E+00, 3.6009415103E+00, 8.0827697742E-01],
	[2.1255000000E+04, 3.2993594388E+01, 1.4481213289E+01, 5.6117430508E+00, 3.6028031516E+00, 8.0836482831E-01],
	[2.1260000000E+04, 3.3005248829E+01, 1.4480889777E+01, 5.6159723376E+00, 3.6046649158E+00, 8.0845264514E-01],
	[2.1265000000E+04, 3.3016904645E+01, 1.4480566349E+01, 5.6202038147E+00, 3.6065268023E+00, 8.0854042792E-01],
	[2.1270000000E+04, 3.3028561835E+01, 1.4480243004E+01, 5.6244374827E+00, 3.6083888108E+00, 8.0862817665E-01],
	[2.1275000000E+04, 3.3040220399E+01, 1.4479919742E+01, 5.6286733421E+00, 3.6102509409E+00, 8.0871589135E-01],
	[2.1280000000E+04, 3.3051880338E+01, 1.4479596564E+01, 5.6329113936E+00, 3.6121131921E+00, 8.0880357202E-01],
	[2.1285000000E+04, 3.3063541650E+01, 1.4479273468E+01, 5.6371516378E+00, 3.6139755641E+00, 8.0889121868E-01],
	[2.1290000000E+04, 3.3075204337E+01, 1.4478950456E+01, 5.6413940754E+00, 3.6158380563E+00, 8.0897883131E-01],
	[2.1295000000E+04, 3.3086868397E+01, 1.4478627527E+01, 5.6456387068E+00, 3.6177006683E+00, 8.0906640988E-01],
	[2.1300000000E+04, 3.3098533831E+01, 1.4478304680E+01, 5.6498855329E+00, 3.6195633998E+00, 8.0915395440E-01],
	[2.1305000000E+04, 3.3110200638E+01, 1.4477981917E+01, 5.6541345541E+00, 3.6214262503E+00, 8.0924146485E-01],
	[2.1310000000E+04, 3.3121868818E+01, 1.4477659237E+01, 5.6583857710E+00, 3.6232892194E+00, 8.0932894126E-01],
	[2.1315000000E+04, 3.3133538372E+01, 1.4477336639E+01, 5.6626391844E+00, 3.6251523066E+00, 8.0941638361E-01],
	[2.1320000000E+04, 3.3145209298E+01, 1.4477014125E+01, 5.6668947949E+00, 3.6270155115E+00, 8.0950379192E-01],
	[2.1325000000E+04, 3.3156881597E+01, 1.4476691693E+01, 5.6711526030E+00, 3.6288788338E+00, 8.0959116618E-01],
	[2.1330000000E+04, 3.3168555269E+01, 1.4476369344E+01, 5.6754126093E+00, 3.6307422730E+00, 8.0967850640E-01],
	[2.1335000000E+04, 3.3180230313E+01, 1.4476047077E+01, 5.6796748145E+00, 3.6326058286E+00, 8.0976581258E-01],
	[2.1340000000E+04, 3.3191906729E+01, 1.4475724894E+01, 5.6839392192E+00, 3.6344695002E+00, 8.0985308472E-01],
	[2.1345000000E+04, 3.3203584518E+01, 1.4475402793E+01, 5.6882058241E+00, 3.6363332875E+00, 8.0994032283E-01],
	[2.1350000000E+04, 3.3215263678E+01, 1.4475080774E+01, 5.6924746296E+00, 3.6381971899E+00, 8.1002752691E-01],
	[2.1355000000E+04, 3.3226944210E+01, 1.4474758839E+01, 5.6967456366E+00, 3.6400612071E+00, 8.1011469696E-01],
	[2.1360000000E+04, 3.3238626114E+01, 1.4474436985E+01, 5.7010188455E+00, 3.6419253386E+00, 8.1020183298E-01],
	[2.1365000000E+04, 3.3250309389E+01, 1.4474115215E+01, 5.7052942570E+00, 3.6437895841E+00, 8.1028893499E-01],
	[2.1370000000E+04, 3.3261994036E+01, 1.4473793526E+01, 5.7095718717E+00, 3.6456539430E+00, 8.1037600297E-01],
	[2.1375000000E+04, 3.3273680054E+01, 1.4473471920E+01, 5.7138516902E+00, 3.6475184150E+00, 8.1046303694E-01],
	[2.1380000000E+04, 3.3285367443E+01, 1.4473150397E+01, 5.7181337132E+00, 3.6493829997E+00, 8.1055003690E-01],
	[2.1385000000E+04, 3.3297056202E+01, 1.4472828956E+01, 5.7224179412E+00, 3.6512476966E+00, 8.1063700285E-01],
	[2.1390000000E+04, 3.3308788709E+01, 1.4472517522E+01, 5.7267043749E+00, 3.6531136473E+00, 8.1072393479E-01],
	[2.1395000000E+04, 3.3320533346E+01, 1.4472208682E+01, 5.7309930149E+00, 3.6549800008E+00, 8.1081083272E-01],
	[2.1400000000E+04, 3.3332279379E+01, 1.4471899921E+01, 5.7352838619E+00, 3.6568464675E+00, 8.1089769666E-01],
	[2.1405000000E+04, 3.3344026807E+01, 1.4471591239E+01, 5.7395769164E+00, 3.6587130468E+00, 8.1098452660E-01],
	[2.1410000000E+04, 3.3355775630E+01, 1.4471282635E+01, 5.7438721790E+00, 3.6605797384E+00, 8.1107132255E-01],
	[2.1415000000E+04, 3.3367525848E+01, 1.4470974110E+01, 5.7481696504E+00, 3.6624465419E+00, 8.1115808450E-01],
	[2.1420000000E+04, 3.3379277460E+01, 1.4470665664E+01, 5.7524693312E+00, 3.6643134569E+00, 8.1124481247E-01],
	[2.1425000000E+04, 3.3391030467E+01, 1.4470357296E+01, 5.7567712220E+00, 3.6661804828E+00, 8.1133150645E-01],
	[2.1430000000E+04, 3.3402784868E+01, 1.4470049006E+01, 5.7610753235E+00, 3.6680476194E+00, 8.1141816646E-01],
	[2.1435000000E+04, 3.3414540663E+01, 1.4469740796E+01, 5.7653816362E+00, 3.6699148661E+00, 8.1150479248E-01],
	[2.1440000000E+04, 3.3426297853E+01, 1.4469432663E+01, 5.7696901607E+00, 3.6717822226E+00, 8.1159138453E-01],
	[2.1445000000E+04, 3.3438056436E+01, 1.4469124609E+01, 5.7740008978E+00, 3.6736496884E+00, 8.1167794261E-01],
	[2.1450000000E+04, 3.3449816413E+01, 1.4468816634E+01, 5.7783138479E+00, 3.6755172632E+00, 8.1176446672E-01],
	[2.1455000000E+04, 3.3461577784E+01, 1.4468508737E+01, 5.7826290118E+00, 3.6773849464E+00, 8.1185095687E-01],
	[2.1460000000E+04, 3.3473340548E+01, 1.4468200918E+01, 5.7869463900E+00, 3.6792527377E+00, 8.1193741306E-01],
	[2.1465000000E+04, 3.3485104705E+01, 1.4467893177E+01, 5.7912659832E+00, 3.6811206367E+00, 8.1202383529E-01],
	[2.1470000000E+04, 3.3496870255E+01, 1.4467585514E+01, 5.7955877920E+00, 3.6829886429E+00, 8.1211022356E-01],
	[2.1475000000E+04, 3.3508637198E+01, 1.4467277930E+01, 5.7999118169E+00, 3.6848567559E+00, 8.1219657789E-01],
	[2.1480000000E+04, 3.3520405534E+01, 1.4466970424E+01, 5.8042380587E+00, 3.6867249753E+00, 8.1228289826E-01],
	[2.1485000000E+04, 3.3532175262E+01, 1.4466662996E+01, 5.8085665179E+00, 3.6885933006E+00, 8.1236918470E-01],
	[2.1490000000E+04, 3.3543946383E+01, 1.4466355646E+01, 5.8128971952E+00, 3.6904617316E+00, 8.1245543719E-01],
	[2.1495000000E+04, 3.3555718896E+01, 1.4466048374E+01, 5.8172300911E+00, 3.6923302676E+00, 8.1254165575E-01],
	[2.1500000000E+04, 3.3567492801E+01, 1.4465741180E+01, 5.8215652064E+00, 3.6941989084E+00, 8.1262784037E-01],
	[2.1505000000E+04, 3.3579268098E+01, 1.4465434064E+01, 5.8259025415E+00, 3.6960676535E+00, 8.1271399107E-01],
	[2.1510000000E+04, 3.3591044787E+01, 1.4465127026E+01, 5.8302420972E+00, 3.6979365024E+00, 8.1280010784E-01],
	[2.1515000000E+04, 3.3602822868E+01, 1.4464820066E+01, 5.8345838740E+00, 3.6998054548E+00, 8.1288619069E-01],
	[2.1520000000E+04, 3.3614602340E+01, 1.4464513183E+01, 5.8389278726E+00, 3.7016745102E+00, 8.1297223961E-01],
	[2.1525000000E+04, 3.3626383203E+01, 1.4464206379E+01, 5.8432740936E+00, 3.7035436682E+00, 8.1305825463E-01],
	[2.1530000000E+04, 3.3638165457E+01, 1.4463899652E+01, 5.8476225376E+00, 3.7054129285E+00, 8.1314423573E-01],
	[2.1535000000E+04, 3.3649949103E+01, 1.4463593003E+01, 5.8519732053E+00, 3.7072822905E+00, 8.1323018293E-01],
	[2.1540000000E+04, 3.3661734139E+01, 1.4463286432E+01, 5.8563260971E+00, 3.7091517539E+00, 8.1331609622E-01],
	[2.1545000000E+04, 3.3673520566E+01, 1.4462979938E+01, 5.8606812139E+00, 3.7110213182E+00, 8.1340197561E-01],
	[2.1550000000E+04, 3.3685308384E+01, 1.4462673522E+01, 5.8650385561E+00, 3.7128909830E+00, 8.1348782110E-01],
	[2.1555000000E+04, 3.3697097591E+01, 1.4462367183E+01, 5.8693981244E+00, 3.7147607479E+00, 8.1357363271E-01],
	[2.1560000000E+04, 3.3708888189E+01, 1.4462060922E+01, 5.8737599195E+00, 3.7166306126E+00, 8.1365941042E-01],
	[2.1565000000E+04, 3.3720680177E+01, 1.4461754739E+01, 5.8781239419E+00, 3.7185005765E+00, 8.1374515425E-01],
	[2.1570000000E+04, 3.3732473555E+01, 1.4461448633E+01, 5.8824901922E+00, 3.7203706392E+00, 8.1383086420E-01],
	[2.1575000000E+04, 3.3744268323E+01, 1.4461142604E+01, 5.8868586712E+00, 3.7222408003E+00, 8.1391654027E-01],
	[2.1580000000E+04, 3.3756064480E+01, 1.4460836653E+01, 5.8912293793E+00, 3.7241110595E+00, 8.1400218247E-01],
	[2.1585000000E+04, 3.3767862027E+01, 1.4460530779E+01, 5.8956023173E+00, 3.7259814163E+00, 8.1408779080E-01],
	[2.1590000000E+04, 3.3779660963E+01, 1.4460224982E+01, 5.8999774857E+00, 3.7278518702E+00, 8.1417336526E-01],
	[2.1595000000E+04, 3.3791461288E+01, 1.4459919263E+01, 5.9043548852E+00, 3.7297224209E+00, 8.1425890587E-01],
	[2.1600000000E+04, 3.3803263001E+01, 1.4459613621E+01, 5.9087345163E+00, 3.7315930680E+00, 8.1434441261E-01],
	[2.1605000000E+04, 3.3815066104E+01, 1.4459308056E+01, 5.9131163797E+00, 3.7334638109E+00, 8.1442988551E-01],
	[2.1610000000E+04, 3.3826870595E+01, 1.4459002569E+01, 5.9175004761E+00, 3.7353346494E+00, 8.1451532455E-01],
	[2.1615000000E+04, 3.3838676475E+01, 1.4458697158E+01, 5.9218868060E+00, 3.7372055830E+00, 8.1460072975E-01],
	[2.1620000000E+04, 3.3850483743E+01, 1.4458391824E+01, 5.9262753701E+00, 3.7390766112E+00, 8.1468610110E-01],
	[2.1625000000E+04, 3.3862292399E+01, 1.4458086568E+01, 5.9306661689E+00, 3.7409477337E+00, 8.1477143862E-01],
	[2.1630000000E+04, 3.3874102443E+01, 1.4457781389E+01, 5.9350592031E+00, 3.7428189500E+00, 8.1485674231E-01],
	[2.1635000000E+04, 3.3885913875E+01, 1.4457476286E+01, 5.9394544734E+00, 3.7446902597E+00, 8.1494201217E-01],
	[2.1640000000E+04, 3.3897726695E+01, 1.4457171261E+01, 5.9438519802E+00, 3.7465616625E+00, 8.1502724820E-01],
	[2.1645000000E+04, 3.3909540902E+01, 1.4456866312E+01, 5.9482517244E+00, 3.7484331578E+00, 8.1511245041E-01],
	[2.1650000000E+04, 3.3921356497E+01, 1.4456561440E+01, 5.9526537064E+00, 3.7503047453E+00, 8.1519761880E-01],
	[2.1655000000E+04, 3.3933173478E+01, 1.4456256645E+01, 5.9570579269E+00, 3.7521764246E+00, 8.1528275339E-01],
	[2.1660000000E+04, 3.3944991847E+01, 1.4455951927E+01, 5.9614643866E+00, 3.7540481952E+00, 8.1536785416E-01],
	[2.1665000000E+04, 3.3956811603E+01, 1.4455647286E+01, 5.9658730859E+00, 3.7559200567E+00, 8.1545292113E-01],
	[2.1670000000E+04, 3.3968632745E+01, 1.4455342721E+01, 5.9702840256E+00, 3.7577920087E+00, 8.1553795431E-01],
	[2.1675000000E+04, 3.3980455274E+01, 1.4455038233E+01, 5.9746972063E+00, 3.7596640509E+00, 8.1562295368E-01],
	[2.1680000000E+04, 3.3992279189E+01, 1.4454733822E+01, 5.9791126286E+00, 3.7615361827E+00, 8.1570791927E-01],
	[2.1685000000E+04, 3.4004104491E+01, 1.4454429487E+01, 5.9835302931E+00, 3.7634084037E+00, 8.1579285107E-01],
	[2.1690000000E+04, 3.4015931178E+01, 1.4454125229E+01, 5.9879502005E+00, 3.7652807136E+00, 8.1587774908E-01],
	[2.1695000000E+04, 3.4027759252E+01, 1.4453821048E+01, 5.9923723513E+00, 3.7671531120E+00, 8.1596261332E-01],
	[2.1700000000E+04, 3.4039588711E+01, 1.4453516943E+01, 5.9967967462E+00, 3.7690255983E+00, 8.1604744379E-01],
	[2.1705000000E+04, 3.4051419556E+01, 1.4453212914E+01, 6.0012233857E+00, 3.7708981723E+00, 8.1613224048E-01],
	[2.1710000000E+04, 3.4063251786E+01, 1.4452908962E+01, 6.0056522706E+00, 3.7727708334E+00, 8.1621700341E-01],
	[2.1715000000E+04, 3.4075085402E+01, 1.4452605086E+01, 6.0100834015E+00, 3.7746435813E+00, 8.1630173258E-01],
	[2.1720000000E+04, 3.4086920403E+01, 1.4452301286E+01, 6.0145167788E+00, 3.7765164156E+00, 8.1638642800E-01],
	[2.1725000000E+04, 3.4098756789E+01, 1.4451997563E+01, 6.0189524034E+00, 3.7783893358E+00, 8.1647108966E-01],
	[2.1730000000E+04, 3.4110594560E+01, 1.4451693916E+01, 6.0233902758E+00, 3.7802623415E+00, 8.1655571758E-01],
	[2.1735000000E+04, 3.4122484359E+01, 1.4451401871E+01, 6.0278303965E+00, 3.7821368440E+00, 8.1664031175E-01],
	[2.1740000000E+04, 3.4134378760E+01, 1.4451110624E+01, 6.0322727663E+00, 3.7840115222E+00, 8.1672487218E-01],
	[2.1745000000E+04, 3.4146274571E+01, 1.4450819451E+01, 6.0367173858E+00, 3.7858862869E+00, 8.1680939889E-01],
	[2.1750000000E+04, 3.4158171791E+01, 1.4450528351E+01, 6.0411642556E+00, 3.7877611378E+00, 8.1689389186E-01],
	[2.1755000000E+04, 3.4170070419E+01, 1.4450237323E+01, 6.0456133762E+00, 3.7896360742E+00, 8.1697835111E-01],
	[2.1760000000E+04, 3.4181970457E+01, 1.4449946368E+01, 6.0500647484E+00, 3.7915110960E+00, 8.1706277664E-01],
	[2.1765000000E+04, 3.4193871904E+01, 1.4449655486E+01, 6.0545183727E+00, 3.7933862025E+00, 8.1714716845E-01],
	[2.1770000000E+04, 3.4205774759E+01, 1.4449364676E+01, 6.0589742498E+00, 3.7952613935E+00, 8.1723152656E-01],
	[2.1775000000E+04, 3.4217679023E+01, 1.4449073939E+01, 6.0634323802E+00, 3.7971366685E+00, 8.1731585095E-01],
	[2.1780000000E+04, 3.4229584695E+01, 1.4448783274E+01, 6.0678927647E+00, 3.7990120271E+00, 8.1740014165E-01],
	[2.1785000000E+04, 3.4241491775E+01, 1.4448492683E+01, 6.0723554037E+00, 3.8008874689E+00, 8.1748439865E-01],
	[2.1790000000E+04, 3.4253400263E+01, 1.4448202163E+01, 6.0768202981E+00, 3.8027629934E+00, 8.1756862196E-01],
	[2.1795000000E+04, 3.4265310159E+01, 1.4447911717E+01, 6.0812874482E+00, 3.8046386004E+00, 8.1765281158E-01],
	[2.1800000000E+04, 3.4277221463E+01, 1.4447621342E+01, 6.0857568549E+00, 3.8065142892E+00, 8.1773696752E-01],
	[2.1805000000E+04, 3.4289134174E+01, 1.4447331040E+01, 6.0902285187E+00, 3.8083900596E+00, 8.1782108978E-01],
	[2.1810000000E+04, 3.4301048293E+01, 1.4447040811E+01, 6.0947024402E+00, 3.8102659112E+00, 8.1790517837E-01],
	[2.1815000000E+04, 3.4312963819E+01, 1.4446750654E+01, 6.0991786200E+00, 3.8121418434E+00, 8.1798923330E-01],
	[2.1820000000E+04, 3.4324880752E+01, 1.4446460569E+01, 6.1036570588E+00, 3.8140178560E+00, 8.1807325456E-01],
	[2.1825000000E+04, 3.4336799092E+01, 1.4446170556E+01, 6.1081377572E+00, 3.8158939484E+00, 8.1815724216E-01],
	[2.1830000000E+04, 3.4348718838E+01, 1.4445880616E+01, 6.1126207158E+00, 3.8177701204E+00, 8.1824119610E-01],
	[2.1835000000E+04, 3.4360639992E+01, 1.4445590748E+01, 6.1171059353E+00, 3.8196463714E+00, 8.1832511640E-01],
	[2.1840000000E+04, 3.4372562551E+01, 1.4445300952E+01, 6.1215934161E+00, 3.8215227011E+00, 8.1840900306E-01],
	[2.1845000000E+04, 3.4384486517E+01, 1.4445011228E+01, 6.1260831591E+00, 3.8233991090E+00, 8.1849285608E-01],
	[2.1850000000E+04, 3.4396411890E+01, 1.4444721576E+01, 6.1305751648E+00, 3.8252755947E+00, 8.1857667546E-01],
	[2.1855000000E+04, 3.4408338668E+01, 1.4444431997E+01, 6.1350694337E+00, 3.8271521579E+00, 8.1866046122E-01],
	[2.1860000000E+04, 3.4420266852E+01, 1.4444142489E+01, 6.1395659666E+00, 3.8290287981E+00, 8.1874421335E-01],
	[2.1865000000E+04, 3.4432196441E+01, 1.4443853054E+01, 6.1440647641E+00, 3.8309055149E+00, 8.1882793186E-01],
	[2.1870000000E+04, 3.4444127437E+01, 1.4443563690E+01, 6.1485658267E+00, 3.8327823079E+00, 8.1891161676E-01],
	[2.1875000000E+04, 3.4456059837E+01, 1.4443274399E+01, 6.1530691551E+00, 3.8346591767E+00, 8.1899526805E-01],
	[2.1880000000E+04, 3.4467993643E+01, 1.4442985179E+01, 6.1575747500E+00, 3.8365361209E+00, 8.1907888574E-01],
	[2.1885000000E+04, 3.4479928854E+01, 1.4442696031E+01, 6.1620826118E+00, 3.8384131400E+00, 8.1916246983E-01],
	[2.1890000000E+04, 3.4491865469E+01, 1.4442406955E+01, 6.1665927414E+00, 3.8402902337E+00, 8.1924602032E-01],
	[2.1895000000E+04, 3.4503803490E+01, 1.4442117951E+01, 6.1711051392E+00, 3.8421674016E+00, 8.1932953723E-01],
	[2.1900000000E+04, 3.4515742915E+01, 1.4441829019E+01, 6.1756198059E+00, 3.8440446432E+00, 8.1941302055E-01],
	[2.1905000000E+04, 3.4527683744E+01, 1.4441540158E+01, 6.1801367422E+00, 3.8459219581E+00, 8.1949647030E-01],
	[2.1910000000E+04, 3.4539625978E+01, 1.4441251369E+01, 6.1846559486E+00, 3.8477993460E+00, 8.1957988647E-01],
	[2.1915000000E+04, 3.4551569616E+01, 1.4440962652E+01, 6.1891774257E+00, 3.8496768063E+00, 8.1966326908E-01],
	[2.1920000000E+04, 3.4563514657E+01, 1.4440674006E+01, 6.1937011743E+00, 3.8515543388E+00, 8.1974661812E-01],
	[2.1925000000E+04, 3.4575461103E+01, 1.4440385432E+01, 6.1982271949E+00, 3.8534319429E+00, 8.1982993360E-01],
	[2.1930000000E+04, 3.4587408952E+01, 1.4440096930E+01, 6.2027554881E+00, 3.8553096184E+00, 8.1991321554E-01],
	[2.1935000000E+04, 3.4599358205E+01, 1.4439808499E+01, 6.2072860545E+00, 3.8571873647E+00, 8.1999646392E-01],
	[2.1940000000E+04, 3.4611308861E+01, 1.4439520139E+01, 6.2118188948E+00, 3.8590651815E+00, 8.2007967877E-01],
	[2.1945000000E+04, 3.4623260920E+01, 1.4439231851E+01, 6.2163540096E+00, 3.8609430684E+00, 8.2016286008E-01],
	[2.1950000000E+04, 3.4635214382E+01, 1.4438943635E+01, 6.2208913996E+00, 3.8628210249E+00, 8.2024600785E-01],
	[2.1955000000E+04, 3.4647169247E+01, 1.4438655490E+01, 6.2254310652E+00, 3.8646990506E+00, 8.2032912210E-01],
	[2.1960000000E+04, 3.4659125515E+01, 1.4438367416E+01, 6.2299730073E+00, 3.8665771452E+00, 8.2041220284E-01],
	[2.1965000000E+04, 3.4671083186E+01, 1.4438079413E+01, 6.2345172263E+00, 3.8684553082E+00, 8.2049525005E-01],
	[2.1970000000E+04, 3.4683042258E+01, 1.4437791482E+01, 6.2390637229E+00, 3.8703335393E+00, 8.2057826376E-01],
	[2.1975000000E+04, 3.4695002733E+01, 1.4437503622E+01, 6.2436124977E+00, 3.8722118380E+00, 8.2066124396E-01],
	[2.1980000000E+04, 3.4706964611E+01, 1.4437215834E+01, 6.2481635514E+00, 3.8740902038E+00, 8.2074419066E-01],
	[2.1985000000E+04, 3.4718927890E+01, 1.4436928116E+01, 6.2527168846E+00, 3.8759686365E+00, 8.2082710388E-01],
	[2.1990000000E+04, 3.4730892571E+01, 1.4436640470E+01, 6.2572724978E+00, 3.8778471356E+00, 8.2090998360E-01],
	[2.1995000000E+04, 3.4742858653E+01, 1.4436352895E+01, 6.2618303918E+00, 3.8797257006E+00, 8.2099282984E-01],
	[2.2000000000E+04, 3.4754826137E+01, 1.4436065390E+01, 6.2663905670E+00, 3.8816043313E+00, 8.2107564260E-01],
	[2.2005000000E+04, 3.4766795023E+01, 1.4435777957E+01, 6.2709530243E+00, 3.8834830271E+00, 8.2115842189E-01],
	[2.2010000000E+04, 3.4778765309E+01, 1.4435490595E+01, 6.2755177641E+00, 3.8853617877E+00, 8.2124116772E-01],
	[2.2015000000E+04, 3.4790736997E+01, 1.4435203304E+01, 6.2800847871E+00, 3.8872406126E+00, 8.2132388008E-01],
	[2.2020000000E+04, 3.4802710085E+01, 1.4434916084E+01, 6.2846540940E+00, 3.8891195015E+00, 8.2140655899E-01],
	[2.2025000000E+04, 3.4814684574E+01, 1.4434628935E+01, 6.2892256852E+00, 3.8909984540E+00, 8.2148920445E-01],
	[2.2030000000E+04, 3.4826660464E+01, 1.4434341857E+01, 6.2937995616E+00, 3.8928774696E+00, 8.2157181647E-01],
	[2.2035000000E+04, 3.4838637754E+01, 1.4434054849E+01, 6.2983757236E+00, 3.8947565479E+00, 8.2165439505E-01],
	[2.2040000000E+04, 3.4850616444E+01, 1.4433767913E+01, 6.3029541720E+00, 3.8966356886E+00, 8.2173694019E-01],
	[2.2045000000E+04, 3.4862596534E+01, 1.4433481047E+01, 6.3075349072E+00, 3.8985148912E+00, 8.2181945191E-01],
	[2.2050000000E+04, 3.4874578025E+01, 1.4433194252E+01, 6.3121179300E+00, 3.9003941553E+00, 8.2190193021E-01],
	[2.2055000000E+04, 3.4886560915E+01, 1.4432907528E+01, 6.3167032410E+00, 3.9022734806E+00, 8.2198437509E-01],
	[2.2060000000E+04, 3.4898545205E+01, 1.4432620874E+01, 6.3212908408E+00, 3.9041528665E+00, 8.2206678656E-01],
	[2.2065000000E+04, 3.4910530894E+01, 1.4432334291E+01, 6.3258807300E+00, 3.9060323128E+00, 8.2214916463E-01],
	[2.2070000000E+04, 3.4922517983E+01, 1.4432047779E+01, 6.3304729093E+00, 3.9079118190E+00, 8.2223150930E-01],
	[2.2075000000E+04, 3.4934506470E+01, 1.4431761337E+01, 6.3350673792E+00, 3.9097913846E+00, 8.2231382057E-01],
	[2.2080000000E+04, 3.4946496357E+01, 1.4431474966E+01, 6.3396641404E+00, 3.9116710094E+00, 8.2239609846E-01],
	[2.2085000000E+04, 3.4958540854E+01, 1.4431200431E+01, 6.3442631935E+00, 3.9135522250E+00, 8.2247834297E-01],
	[2.2090000000E+04, 3.4970588135E+01, 1.4430926264E+01, 6.3488645391E+00, 3.9154335402E+00, 8.2256055410E-01],
	[2.2095000000E+04, 3.4982636840E+01, 1.4430652165E+01, 6.3534681779E+00, 3.9173149156E+00, 8.2264273186E-01],
	[2.2100000000E+04, 3.4994686968E+01, 1.4430378133E+01, 6.3580741105E+00, 3.9191963507E+00, 8.2272487626E-01],
	[2.2105000000E+04, 3.5006738520E+01, 1.4430104168E+01, 6.3626823375E+00, 3.9210778451E+00, 8.2280698730E-01],
	[2.2110000000E+04, 3.5018791496E+01, 1.4429830270E+01, 6.3672928594E+00, 3.9229593984E+00, 8.2288906499E-01],
	[2.2115000000E+04, 3.5030845894E+01, 1.4429556439E+01, 6.3719056770E+00, 3.9248410102E+00, 8.2297110933E-01],
	[2.2120000000E+04, 3.5042901715E+01, 1.4429282675E+01, 6.3765207909E+00, 3.9267226801E+00, 8.2305312033E-01],
	[2.2125000000E+04, 3.5054958959E+01, 1.4429008979E+01, 6.3811382017E+00, 3.9286044076E+00, 8.2313509800E-01],
	[2.2130000000E+04, 3.5067017626E+01, 1.4428735349E+01, 6.3857579100E+00, 3.9304861925E+00, 8.2321704234E-01],
	[2.2135000000E+04, 3.5079077715E+01, 1.4428461787E+01, 6.3903799164E+00, 3.9323680343E+00, 8.2329895335E-01],
	[2.2140000000E+04, 3.5091139226E+01, 1.4428188291E+01, 6.3950042215E+00, 3.9342499325E+00, 8.2338083105E-01],
	[2.2145000000E+04, 3.5103202160E+01, 1.4427914863E+01, 6.3996308261E+00, 3.9361318869E+00, 8.2346267544E-01],
	[2.2150000000E+04, 3.5115266516E+01, 1.4427641501E+01, 6.4042597306E+00, 3.9380138969E+00, 8.2354448652E-01],
	[2.2155000000E+04, 3.5127332294E+01, 1.4427368206E+01, 6.4088909358E+00, 3.9398959622E+00, 8.2362626430E-01],
	[2.2160000000E+04, 3.5139399493E+01, 1.4427094978E+01, 6.4135244422E+00, 3.9417780823E+00, 8.2370800879E-01],
	[2.2165000000E+04, 3.5151468114E+01, 1.4426821817E+01, 6.4181602504E+00, 3.9436602570E+00, 8.2378972000E-01],
	[2.2170000000E+04, 3.5163538156E+01, 1.4426548723E+01, 6.4227983612E+00, 3.9455424857E+00, 8.2387139792E-01],
	[2.2175000000E+04, 3.5175609620E+01, 1.4426275695E+01, 6.4274387751E+00, 3.9474247682E+00, 8.2395304257E-01],
	[2.2180000000E+04, 3.5187682504E+01, 1.4426002734E+01, 6.4320814927E+00, 3.9493071039E+00, 8.2403465395E-01],
	[2.2185000000E+04, 3.5199756810E+01, 1.4425729840E+01, 6.4367265146E+00, 3.9511894924E+00, 8.2411623207E-01],
	[2.2190000000E+04, 3.5211832537E+01, 1.4425457013E+01, 6.4413738416E+00, 3.9530719335E+00, 8.2419777693E-01],
	[2.2195000000E+04, 3.5223909684E+01, 1.4425184252E+01, 6.4460234741E+00, 3.9549544266E+00, 8.2427928854E-01],
	[2.2200000000E+04, 3.5235988251E+01, 1.4424911557E+01, 6.4506754129E+00, 3.9568369714E+00, 8.2436076690E-01],
	[2.2205000000E+04, 3.5248068239E+01, 1.4424638930E+01, 6.4553296585E+00, 3.9587195674E+00, 8.2444221203E-01],
	[2.2210000000E+04, 3.5260149648E+01, 1.4424366368E+01, 6.4599862116E+00, 3.9606022144E+00, 8.2452362393E-01],
	[2.2215000000E+04, 3.5272232476E+01, 1.4424093874E+01, 6.4646450728E+00, 3.9624849118E+00, 8.2460500260E-01],
	[2.2220000000E+04, 3.5284316724E+01, 1.4423821445E+01, 6.4693062427E+00, 3.9643676593E+00, 8.2468634805E-01],
	[2.2225000000E+04, 3.5296402392E+01, 1.4423549084E+01, 6.4739697220E+00, 3.9662504564E+00, 8.2476766029E-01],
	[2.2230000000E+04, 3.5308489479E+01, 1.4423276788E+01, 6.4786355112E+00, 3.9681333028E+00, 8.2484893932E-01],
	[2.2235000000E+04, 3.5320577986E+01, 1.4423004559E+01, 6.4833036110E+00, 3.9700161982E+00, 8.2493018515E-01],
	[2.2240000000E+04, 3.5332667912E+01, 1.4422732397E+01, 6.4879740220E+00, 3.9718991419E+00, 8.2501139778E-01],
	[2.2245000000E+04, 3.5344759258E+01, 1.4422460300E+01, 6.4926467448E+00, 3.9737821338E+00, 8.2509257723E-01],
	[2.2250000000E+04, 3.5356852022E+01, 1.4422188270E+01, 6.4973217801E+00, 3.9756651733E+00, 8.2517372350E-01],
	[2.2255000000E+04, 3.5368946205E+01, 1.4421916306E+01, 6.5019991285E+00, 3.9775482602E+00, 8.2525483659E-01],
	[2.2260000000E+04, 3.5381041807E+01, 1.4421644409E+01, 6.5066787906E+00, 3.9794313939E+00, 8.2533591651E-01],
	[2.2265000000E+04, 3.5393138827E+01, 1.4421372577E+01, 6.5113607670E+00, 3.9813145740E+00, 8.2541696327E-01],
	[2.2270000000E+04, 3.5405237266E+01, 1.4421100812E+01, 6.5160450583E+00, 3.9831978003E+00, 8.2549797687E-01],
	[2.2275000000E+04, 3.5417337123E+01, 1.4420829113E+01, 6.5207316653E+00, 3.9850810723E+00, 8.2557895732E-01],
	[2.2280000000E+04, 3.5429438398E+01, 1.4420557480E+01, 6.5254205884E+00, 3.9869643895E+00, 8.2565990463E-01],
	[2.2285000000E+04, 3.5441541090E+01, 1.4420285913E+01, 6.5301118283E+00, 3.9888477516E+00, 8.2574081880E-01],
	[2.2290000000E+04, 3.5453645201E+01, 1.4420014412E+01, 6.5348053857E+00, 3.9907311583E+00, 8.2582169984E-01],
	[2.2295000000E+04, 3.5465750729E+01, 1.4419742977E+01, 6.5395012612E+00, 3.9926146090E+00, 8.2590254775E-01],
	[2.2300000000E+04, 3.5477857675E+01, 1.4419471608E+01, 6.5441994553E+00, 3.9944981034E+00, 8.2598336255E-01],
	[2.2305000000E+04, 3.5489966038E+01, 1.4419200305E+01, 6.5488999687E+00, 3.9963816411E+00, 8.2606414423E-01],
	[2.2310000000E+04, 3.5502075818E+01, 1.4418929068E+01, 6.5536028021E+00, 3.9982652217E+00, 8.2614489281E-01],
	[2.2315000000E+04, 3.5514187015E+01, 1.4418657897E+01, 6.5583079561E+00, 4.0001488449E+00, 8.2622560830E-01],
	[2.2320000000E+04, 3.5526299629E+01, 1.4418386792E+01, 6.5630154312E+00, 4.0020325101E+00, 8.2630629068E-01],
	[2.2325000000E+04, 3.5538413659E+01, 1.4418115752E+01, 6.5677252281E+00, 4.0039162170E+00, 8.2638693999E-01],
	[2.2330000000E+04, 3.5550529107E+01, 1.4417844778E+01, 6.5724373475E+00, 4.0057999653E+00, 8.2646755621E-01],
	[2.2335000000E+04, 3.5562645970E+01, 1.4417573870E+01, 6.5771517899E+00, 4.0076837545E+00, 8.2654813937E-01],
	[2.2340000000E+04, 3.5574764250E+01, 1.4417303028E+01, 6.5818685560E+00, 4.0095675842E+00, 8.2662868945E-01],
	[2.2345000000E+04, 3.5586883946E+01, 1.4417032251E+01, 6.5865876464E+00, 4.0114514540E+00, 8.2670920648E-01],
	[2.2350000000E+04, 3.5599005058E+01, 1.4416761541E+01, 6.5913090617E+00, 4.0133353636E+00, 8.2678969045E-01],
	[2.2355000000E+04, 3.5611127585E+01, 1.4416490895E+01, 6.5960328026E+00, 4.0152193125E+00, 8.2687014138E-01],
	[2.2360000000E+04, 3.5623251529E+01, 1.4416220316E+01, 6.6007588696E+00, 4.0171033003E+00, 8.2695055927E-01],
	[2.2365000000E+04, 3.5635376887E+01, 1.4415949802E+01, 6.6055154972E+00, 4.0189977785E+00, 8.2703094413E-01],
	[2.2370000000E+04, 3.5647503661E+01, 1.4415679353E+01, 6.6102790853E+00, 4.0208939987E+00, 8.2711129596E-01],
	[2.2375000000E+04, 3.5659631851E+01, 1.4415408970E+01, 6.6150450411E+00, 4.0227902593E+00, 8.2719161477E-01],
	[2.2380000000E+04, 3.5671761455E+01, 1.4415138653E+01, 6.6198133652E+00, 4.0246865598E+00, 8.2727190057E-01],
	[2.2385000000E+04, 3.5683892474E+01, 1.4414868400E+01, 6.6245840583E+00, 4.0265828999E+00, 8.2735215336E-01],
	[2.2390000000E+04, 3.5696024908E+01, 1.4414598214E+01, 6.6293571210E+00, 4.0284792790E+00, 8.2743237316E-01],
	[2.2395000000E+04, 3.5708158756E+01, 1.4414328093E+01, 6.6341325540E+00, 4.0303756970E+00, 8.2751255996E-01],
	[2.2400000000E+04, 3.5720294019E+01, 1.4414058037E+01, 6.6389103579E+00, 4.0322721532E+00, 8.2759271377E-01],
	[2.2405000000E+04, 3.5732430696E+01, 1.4413788046E+01, 6.6436905334E+00, 4.0341686474E+00, 8.2767283461E-01],
	[2.2410000000E+04, 3.5744568788E+01, 1.4413518121E+01, 6.6484730811E+00, 4.0360651791E+00, 8.2775292247E-01],
	[2.2415000000E+04, 3.5756708293E+01, 1.4413248261E+01, 6.6532580016E+00, 4.0379617479E+00, 8.2783297737E-01],
	[2.2420000000E+04, 3.5768849212E+01, 1.4412978466E+01, 6.6580452957E+00, 4.0398583534E+00, 8.2791299931E-01],
	[2.2425000000E+04, 3.5780991545E+01, 1.4412708736E+01, 6.6628349639E+00, 4.0417549953E+00, 8.2799298830E-01],
	[2.2430000000E+04, 3.5793135291E+01, 1.4412439072E+01, 6.6676270070E+00, 4.0436516731E+00, 8.2807294434E-01],
	[2.2435000000E+04, 3.5805280451E+01, 1.4412169473E+01, 6.6724214254E+00, 4.0455483864E+00, 8.2815286744E-01],
	[2.2440000000E+04, 3.5817475876E+01, 1.4411910435E+01, 6.6772182200E+00, 4.0474465864E+00, 8.2823275762E-01],
	[2.2445000000E+04, 3.5829679205E+01, 1.4411652848E+01, 6.6820173913E+00, 4.0493450155E+00, 8.2831261487E-01],
	[2.2450000000E+04, 3.5841883974E+01, 1.4411395324E+01, 6.6868189400E+00, 4.0512434811E+00, 8.2839243920E-01],
	[2.2455000000E+04, 3.5854090180E+01, 1.4411137861E+01, 6.6916228667E+00, 4.0531419830E+00, 8.2847223062E-01],
	[2.2460000000E+04, 3.5866297824E+01, 1.4410880461E+01, 6.6964291721E+00, 4.0550405206E+00, 8.2855198914E-01],
	[2.2465000000E+04, 3.5878506906E+01, 1.4410623122E+01, 6.7012378569E+00, 4.0569390936E+00, 8.2863171476E-01],
	[2.2470000000E+04, 3.5890717425E+01, 1.4410365845E+01, 6.7060489216E+00, 4.0588377016E+00, 8.2871140749E-01],
	[2.2475000000E+04, 3.5902929382E+01, 1.4410108630E+01, 6.7108623669E+00, 4.0607363442E+00, 8.2879106734E-01],
	[2.2480000000E+04, 3.5915142776E+01, 1.4409851477E+01, 6.7156781935E+00, 4.0626350210E+00, 8.2887069431E-01],
	[2.2485000000E+04, 3.5927357608E+01, 1.4409594386E+01, 6.7204964020E+00, 4.0645337315E+00, 8.2895028842E-01],
	[2.2490000000E+04, 3.5939573876E+01, 1.4409337356E+01, 6.7253169930E+00, 4.0664324754E+00, 8.2902984966E-01],
	[2.2495000000E+04, 3.5951791581E+01, 1.4409080388E+01, 6.7301399673E+00, 4.0683312524E+00, 8.2910937805E-01],
	[2.2500000000E+04, 3.5964010723E+01, 1.4408823482E+01, 6.7349653254E+00, 4.0702300618E+00, 8.2918887359E-01],
	[2.2505000000E+04, 3.5976231302E+01, 1.4408566637E+01, 6.7397930680E+00, 4.0721289035E+00, 8.2926833629E-01],
	[2.2510000000E+04, 3.5988453316E+01, 1.4408309854E+01, 6.7446231957E+00, 4.0740277770E+00, 8.2934776616E-01],
	[2.2515000000E+04, 3.6000676768E+01, 1.4408053133E+01, 6.7494557093E+00, 4.0759266819E+00, 8.2942716320E-01],
	[2.2520000000E+04, 3.6012901655E+01, 1.4407796473E+01, 6.7542906093E+00, 4.0778256177E+00, 8.2950652742E-01],
	[2.2525000000E+04, 3.6025127978E+01, 1.4407539875E+01, 6.7591278963E+00, 4.0797245842E+00, 8.2958585882E-01],
	[2.2530000000E+04, 3.6037355737E+01, 1.4407283338E+01, 6.7639675712E+00, 4.0816235808E+00, 8.2966515743E-01],
	[2.2535000000E+04, 3.6049584931E+01, 1.4407026863E+01, 6.7688096343E+00, 4.0835226072E+00, 8.2974442323E-01],
	[2.2540000000E+04, 3.6061815561E+01, 1.4406770449E+01, 6.7736540865E+00, 4.0854216631E+00, 8.2982365625E-01],
	[2.2545000000E+04, 3.6074047627E+01, 1.4406514097E+01, 6.7785009284E+00, 4.0873207479E+00, 8.2990285648E-01],
	[2.2550000000E+04, 3.6086281127E+01, 1.4406257806E+01, 6.7833501606E+00, 4.0892198613E+00, 8.2998202393E-01],
	[2.2555000000E+04, 3.6098516063E+01, 1.4406001577E+01, 6.7882017838E+00, 4.0911190030E+00, 8.3006115862E-01],
	[2.2560000000E+04, 3.6110752433E+01, 1.4405745408E+01, 6.7930557986E+00, 4.0930181724E+00, 8.3014026054E-01],
	[2.2565000000E+04, 3.6122990238E+01, 1.4405489302E+01, 6.7979122056E+00, 4.0949173693E+00, 8.3021932971E-01],
	[2.2570000000E+04, 3.6135229478E+01, 1.4405233256E+01, 6.8027710056E+00, 4.0968165932E+00, 8.3029836613E-01],
	[2.2575000000E+04, 3.6147470152E+01, 1.4404977272E+01, 6.8076321991E+00, 4.0987158437E+00, 8.3037736981E-01],
	[2.2580000000E+04, 3.6159712261E+01, 1.4404721349E+01, 6.8124957868E+00, 4.1006151204E+00, 8.3045634076E-01],
	[2.2585000000E+04, 3.6171955804E+01, 1.4404465487E+01, 6.8173617694E+00, 4.1025144230E+00, 8.3053527898E-01],
	[2.2590000000E+04, 3.6184200780E+01, 1.4404209686E+01, 6.8222301475E+00, 4.1044137510E+00, 8.3061418447E-01],
	[2.2595000000E+04, 3.6196447191E+01, 1.4403953947E+01, 6.8271009217E+00, 4.1063131040E+00, 8.3069305725E-01],
	[2.2600000000E+04, 3.6208695035E+01, 1.4403698268E+01, 6.8319740927E+00, 4.1082124817E+00, 8.3077189731E-01],
	[2.2605000000E+04, 3.6220944313E+01, 1.4403442651E+01, 6.8368496611E+00, 4.1101118836E+00, 8.3085070467E-01],
	[2.2610000000E+04, 3.6233195024E+01, 1.4403187095E+01, 6.8417276277E+00, 4.1120113093E+00, 8.3092947933E-01],
	[2.2615000000E+04, 3.6245447168E+01, 1.4402931600E+01, 6.8466079929E+00, 4.1139107585E+00, 8.3100822129E-01],
	[2.2620000000E+04, 3.6257700746E+01, 1.4402676166E+01, 6.8514907576E+00, 4.1158102308E+00, 8.3108693055E-01],
	[2.2625000000E+04, 3.6269955756E+01, 1.4402420792E+01, 6.8563759223E+00, 4.1177097257E+00, 8.3116560714E-01],
	[2.2630000000E+04, 3.6282212200E+01, 1.4402165480E+01, 6.8612634876E+00, 4.1196092429E+00, 8.3124425104E-01],
	[2.2635000000E+04, 3.6294470076E+01, 1.4401910229E+01, 6.8661534543E+00, 4.1215087820E+00, 8.3132286227E-01],
	[2.2640000000E+04, 3.6306729384E+01, 1.4401655038E+01, 6.8710458229E+00, 4.1234083425E+00, 8.3140144083E-01],
	[2.2645000000E+04, 3.6318990125E+01, 1.4401399909E+01, 6.8759405942E+00, 4.1253079242E+00, 8.3147998673E-01],
	[2.2650000000E+04, 3.6331252298E+01, 1.4401144840E+01, 6.8808377687E+00, 4.1272075265E+00, 8.3155849997E-01],
	[2.2655000000E+04, 3.6343515903E+01, 1.4400889832E+01, 6.8857373472E+00, 4.1291071491E+00, 8.3163698055E-01],
	[2.2660000000E+04, 3.6355780940E+01, 1.4400634885E+01, 6.8906393302E+00, 4.1310067916E+00, 8.3171542849E-01],
	[2.2665000000E+04, 3.6368047408E+01, 1.4400379999E+01, 6.8955437184E+00, 4.1329064537E+00, 8.3179384379E-01],
	[2.2670000000E+04, 3.6380315309E+01, 1.4400125173E+01, 6.9004505125E+00, 4.1348061348E+00, 8.3187222646E-01],
	[2.2675000000E+04, 3.6392584640E+01, 1.4399870409E+01, 6.9053597131E+00, 4.1367058347E+00, 8.3195057650E-01],
	[2.2680000000E+04, 3.6404855403E+01, 1.4399615704E+01, 6.9102713209E+00, 4.1386055529E+00, 8.3202889391E-01],
	[2.2685000000E+04, 3.6417127598E+01, 1.4399361061E+01, 6.9151853364E+00, 4.1405052890E+00, 8.3210717870E-01],
	[2.2690000000E+04, 3.6429401223E+01, 1.4399106478E+01, 6.9201017604E+00, 4.1424050427E+00, 8.3218543088E-01],
	[2.2695000000E+04, 3.6441676279E+01, 1.4398851956E+01, 6.9250205935E+00, 4.1443048135E+00, 8.3226365046E-01],
	[2.2700000000E+04, 3.6453952766E+01, 1.4398597494E+01, 6.9299418364E+00, 4.1462046011E+00, 8.3234183743E-01],
	[2.2705000000E+04, 3.6466230683E+01, 1.4398343093E+01, 6.9348654896E+00, 4.1481044050E+00, 8.3241999181E-01],
	[2.2710000000E+04, 3.6478510031E+01, 1.4398088752E+01, 6.9397915539E+00, 4.1500042249E+00, 8.3249811361E-01],
	[2.2715000000E+04, 3.6490790809E+01, 1.4397834472E+01, 6.9447200298E+00, 4.1519040604E+00, 8.3257620281E-01],
	[2.2720000000E+04, 3.6503073017E+01, 1.4397580252E+01, 6.9496509181E+00, 4.1538039111E+00, 8.3265425944E-01],
	[2.2725000000E+04, 3.6515356655E+01, 1.4397326093E+01, 6.9545842194E+00, 4.1557037766E+00, 8.3273228350E-01],
	[2.2730000000E+04, 3.6527641723E+01, 1.4397071994E+01, 6.9595199343E+00, 4.1576036565E+00, 8.3281027499E-01],
	[2.2735000000E+04, 3.6539928221E+01, 1.4396817955E+01, 6.9644580636E+00, 4.1595035504E+00, 8.3288823393E-01],
	[2.2740000000E+04, 3.6552216148E+01, 1.4396563977E+01, 6.9693986077E+00, 4.1614034579E+00, 8.3296616031E-01],
	[2.2745000000E+04, 3.6564505505E+01, 1.4396310059E+01, 6.9743415674E+00, 4.1633033787E+00, 8.3304405414E-01],
	[2.2750000000E+04, 3.6576796291E+01, 1.4396056201E+01, 6.9792869433E+00, 4.1652033123E+00, 8.3312191543E-01],
	[2.2755000000E+04, 3.6589088505E+01, 1.4395802404E+01, 6.9842347362E+00, 4.1671032584E+00, 8.3319974418E-01],
	[2.2760000000E+04, 3.6601382149E+01, 1.4395548667E+01, 6.9891849465E+00, 4.1690032165E+00, 8.3327754040E-01],
	[2.2765000000E+04, 3.6613677222E+01, 1.4395294990E+01, 6.9941375750E+00, 4.1709031863E+00, 8.3335530410E-01],
	[2.2770000000E+04, 3.6625973723E+01, 1.4395041373E+01, 6.9990926223E+00, 4.1728031673E+00, 8.3343303528E-01],
	[2.2775000000E+04, 3.6638271653E+01, 1.4394787817E+01, 7.0040500891E+00, 4.1747031593E+00, 8.3351073395E-01],
	[2.2780000000E+04, 3.6650571011E+01, 1.4394534320E+01, 7.0090099761E+00, 4.1766031617E+00, 8.3358840011E-01],
	[2.2785000000E+04, 3.6662871797E+01, 1.4394280884E+01, 7.0139722837E+00, 4.1785031743E+00, 8.3366603377E-01],
	[2.2790000000E+04, 3.6675174012E+01, 1.4394027507E+01, 7.0189370128E+00, 4.1804031966E+00, 8.3374363494E-01],
	[2.2795000000E+04, 3.6687477654E+01, 1.4393774191E+01, 7.0239041640E+00, 4.1823032282E+00, 8.3382120362E-01],
	[2.2800000000E+04, 3.6699818986E+01, 1.4393528505E+01, 7.0288737379E+00, 4.1842043799E+00, 8.3389873981E-01],
	[2.2805000000E+04, 3.6712181587E+01, 1.4393287014E+01, 7.0338457351E+00, 4.1861061493E+00, 8.3397624354E-01],
	[2.2810000000E+04, 3.6724545639E+01, 1.4393045581E+01, 7.0388201563E+00, 4.1880079291E+00, 8.3405371479E-01],
	[2.2815000000E+04, 3.6736911145E+01, 1.4392804204E+01, 7.0437970022E+00, 4.1899097190E+00, 8.3413115358E-01],
	[2.2820000000E+04, 3.6749278103E+01, 1.4392562884E+01, 7.0487762734E+00, 4.1918115186E+00, 8.3420855991E-01],
	[2.2825000000E+04, 3.6761646514E+01, 1.4392321621E+01, 7.0537579706E+00, 4.1937133274E+00, 8.3428593379E-01],
	[2.2830000000E+04, 3.6774016377E+01, 1.4392080414E+01, 7.0587420943E+00, 4.1956151452E+00, 8.3436327523E-01],
	[2.2835000000E+04, 3.6786387692E+01, 1.4391839265E+01, 7.0637286453E+00, 4.1975169715E+00, 8.3444058422E-01],
	[2.2840000000E+04, 3.6798760459E+01, 1.4391598173E+01, 7.0687176242E+00, 4.1994188059E+00, 8.3451786079E-01],
	[2.2845000000E+04, 3.6811134678E+01, 1.4391357137E+01, 7.0737090317E+00, 4.2013206481E+00, 8.3459510493E-01],
	[2.2850000000E+04, 3.6823510348E+01, 1.4391116158E+01, 7.0787028684E+00, 4.2032224976E+00, 8.3467231665E-01],
	[2.2855000000E+04, 3.6835887470E+01, 1.4390875236E+01, 7.0836991349E+00, 4.2051243541E+00, 8.3474949595E-01],
	[2.2860000000E+04, 3.6848266044E+01, 1.4390634371E+01, 7.0886978319E+00, 4.2070262171E+00, 8.3482664285E-01],
	[2.2865000000E+04, 3.6860646068E+01, 1.4390393562E+01, 7.0936989600E+00, 4.2089280864E+00, 8.3490375735E-01],
	[2.2870000000E+04, 3.6873027544E+01, 1.4390152810E+01, 7.0987025199E+00, 4.2108299615E+00, 8.3498083945E-01],
	[2.2875000000E+04, 3.6885410471E+01, 1.4389912115E+01, 7.1037085123E+00, 4.2127318420E+00, 8.3505788916E-01],
	[2.2880000000E+04, 3.6897794848E+01, 1.4389671476E+01, 7.1087169378E+00, 4.2146337275E+00, 8.3513490650E-01],
	[2.2885000000E+04, 3.6910180676E+01, 1.4389430894E+01, 7.1137277970E+00, 4.2165356177E+00, 8.3521189145E-01],
	[2.2890000000E+04, 3.6922567955E+01, 1.4389190369E+01, 7.1187410906E+00, 4.2184375121E+00, 8.3528884404E-01],
	[2.2895000000E+04, 3.6934956684E+01, 1.4388949900E+01, 7.1237568193E+00, 4.2203394105E+00, 8.3536576426E-01],
	[2.2900000000E+04, 3.6947346863E+01, 1.4388709487E+01, 7.1287749836E+00, 4.2222413123E+00, 8.3544265213E-01],
	[2.2905000000E+04, 3.6959738492E+01, 1.4388469131E+01, 7.1337955843E+00, 4.2241432173E+00, 8.3551950765E-01],
	[2.2910000000E+04, 3.6972131571E+01, 1.4388228832E+01, 7.1388186219E+00, 4.2260451249E+00, 8.3559633083E-01],
	[2.2915000000E+04, 3.6984526100E+01, 1.4387988589E+01, 7.1438440972E+00, 4.2279470349E+00, 8.3567312167E-01],
	[2.2920000000E+04, 3.6996922079E+01, 1.4387748402E+01, 7.1488720108E+00, 4.2298489469E+00, 8.3574988017E-01],
	[2.2925000000E+04, 3.7009319507E+01, 1.4387508272E+01, 7.1539023633E+00, 4.2317508604E+00, 8.3582660636E-01],
	[2.2930000000E+04, 3.7021718384E+01, 1.4387268198E+01, 7.1589351554E+00, 4.2336527752E+00, 8.3590330022E-01],
	[2.2935000000E+04, 3.7034118710E+01, 1.4387028181E+01, 7.1639703878E+00, 4.2355546907E+00, 8.3597996178E-01],
	[2.2940000000E+04, 3.7046520486E+01, 1.4386788220E+01, 7.1690080610E+00, 4.2374566066E+00, 8.3605659103E-01],
	[2.2945000000E+04, 3.7058923710E+01, 1.4386548315E+01, 7.1740481757E+00, 4.2393585226E+00, 8.3613318799E-01],
	[2.2950000000E+04, 3.7071328383E+01, 1.4386308466E+01, 7.1790907326E+00, 4.2412604383E+00, 8.3620975265E-01],
	[2.2955000000E+04, 3.7083734505E+01, 1.4386068674E+01, 7.1841357324E+00, 4.2431623532E+00, 8.3628628503E-01],
	[2.2960000000E+04, 3.7096142075E+01, 1.4385828938E+01, 7.1891831757E+00, 4.2450642670E+00, 8.3636278513E-01],
	[2.2965000000E+04, 3.7108551094E+01, 1.4385589258E+01, 7.1942330630E+00, 4.2469661793E+00, 8.3643925296E-01],
	[2.2970000000E+04, 3.7120961560E+01, 1.4385349634E+01, 7.1992853952E+00, 4.2488680897E+00, 8.3651568852E-01],
	[2.2975000000E+04, 3.7133373475E+01, 1.4385110067E+01, 7.2043401728E+00, 4.2507699979E+00, 8.3659209183E-01],
	[2.2980000000E+04, 3.7145786837E+01, 1.4384870555E+01, 7.2093973964E+00, 4.2526719034E+00, 8.3666846288E-01],
	[2.2985000000E+04, 3.7158201648E+01, 1.4384631100E+01, 7.2144570668E+00, 4.2545738059E+00, 8.3674480169E-01],
	[2.2990000000E+04, 3.7170617905E+01, 1.4384391700E+01, 7.2195191846E+00, 4.2564757050E+00, 8.3682110827E-01],
	[2.2995000000E+04, 3.7183035611E+01, 1.4384152357E+01, 7.2245837504E+00, 4.2583776003E+00, 8.3689738261E-01],
	[2.3000000000E+04, 3.7195454763E+01, 1.4383913070E+01, 7.2296507649E+00, 4.2602794914E+00, 8.3697362472E-01],
	[2.3005000000E+04, 3.7207875363E+01, 1.4383673839E+01, 7.2347202287E+00, 4.2621813780E+00, 8.3704983462E-01],
	[2.3010000000E+04, 3.7220297409E+01, 1.4383434663E+01, 7.2397921425E+00, 4.2640832597E+00, 8.3712601231E-01],
	[2.3015000000E+04, 3.7232720903E+01, 1.4383195544E+01, 7.2448665069E+00, 4.2659851360E+00, 8.3720215780E-01],
	[2.3020000000E+04, 3.7245145843E+01, 1.4382956481E+01, 7.2499433226E+00, 4.2678870066E+00, 8.3727827109E-01],
	[2.3025000000E+04, 3.7257572229E+01, 1.4382717473E+01, 7.2550225902E+00, 4.2697888712E+00, 8.3735435218E-01],
	[2.3030000000E+04, 3.7270000062E+01, 1.4382478521E+01, 7.2601043104E+00, 4.2716907293E+00, 8.3743040110E-01],
	[2.3035000000E+04, 3.7282429342E+01, 1.4382239626E+01, 7.2651884838E+00, 4.2735925806E+00, 8.3750641783E-01],
	[2.3040000000E+04, 3.7294860067E+01, 1.4382000786E+01, 7.2702751111E+00, 4.2754944246E+00, 8.3758240240E-01],
	[2.3045000000E+04, 3.7307292238E+01, 1.4381762001E+01, 7.2753641930E+00, 4.2773962611E+00, 8.3765835480E-01],
	[2.3050000000E+04, 3.7319725855E+01, 1.4381523273E+01, 7.2804557300E+00, 4.2792980895E+00, 8.3773427505E-01],
	[2.3055000000E+04, 3.7332160918E+01, 1.4381284600E+01, 7.2855497228E+00, 4.2811999096E+00, 8.3781016315E-01],
	[2.3060000000E+04, 3.7344597427E+01, 1.4381045983E+01, 7.2906461721E+00, 4.2831017210E+00, 8.3788601910E-01],
	[2.3065000000E+04, 3.7357035380E+01, 1.4380807422E+01, 7.2957450786E+00, 4.2850035233E+00, 8.3796184293E-01],
	[2.3070000000E+04, 3.7369474779E+01, 1.4380568916E+01, 7.3008464428E+00, 4.2869053160E+00, 8.3803763462E-01],
	[2.3075000000E+04, 3.7381915623E+01, 1.4380330466E+01, 7.3059502654E+00, 4.2888070989E+00, 8.3811339419E-01],
	[2.3080000000E+04, 3.7394357912E+01, 1.4380092072E+01, 7.3110565472E+00, 4.2907088716E+00, 8.3818912165E-01],
	[2.3085000000E+04, 3.7406801646E+01, 1.4379853733E+01, 7.3161652886E+00, 4.2926106336E+00, 8.3826481699E-01],
	[2.3090000000E+04, 3.7419246825E+01, 1.4379615450E+01, 7.3212764905E+00, 4.2945123846E+00, 8.3834048024E-01],
	[2.3095000000E+04, 3.7431693448E+01, 1.4379377222E+01, 7.3263901533E+00, 4.2964141242E+00, 8.3841611140E-01],
	[2.3100000000E+04, 3.7444141515E+01, 1.4379139050E+01, 7.3315062779E+00, 4.2983158520E+00, 8.3849171047E-01],
	[2.3105000000E+04, 3.7456591027E+01, 1.4378900933E+01, 7.3366248648E+00, 4.3002175677E+00, 8.3856727746E-01],
	[2.3110000000E+04, 3.7469041982E+01, 1.4378662872E+01, 7.3417459146E+00, 4.3021192708E+00, 8.3864281237E-01],
	[2.3115000000E+04, 3.7481494382E+01, 1.4378424866E+01, 7.3468694281E+00, 4.3040209611E+00, 8.3871831522E-01],
	[2.3120000000E+04, 3.7493948225E+01, 1.4378186916E+01, 7.3519954059E+00, 4.3059226381E+00, 8.3879378602E-01],
	[2.3125000000E+04, 3.7506403512E+01, 1.4377949021E+01, 7.3571238486E+00, 4.3078243014E+00, 8.3886922476E-01],
	[2.3130000000E+04, 3.7518860243E+01, 1.4377711181E+01, 7.3622547569E+00, 4.3097259507E+00, 8.3894463146E-01],
	[2.3135000000E+04, 3.7531318416E+01, 1.4377473397E+01, 7.3673881314E+00, 4.3116275856E+00, 8.3902000612E-01],
	[2.3140000000E+04, 3.7543778033E+01, 1.4377235668E+01, 7.3725239728E+00, 4.3135292057E+00, 8.3909534876E-01],
	[2.3145000000E+04, 3.7556239093E+01, 1.4376997995E+01, 7.3776622818E+00, 4.3154308107E+00, 8.3917065937E-01],
	[2.3150000000E+04, 3.7568701596E+01, 1.4376760376E+01, 7.3828030589E+00, 4.3173324001E+00, 8.3924593796E-01],
	[2.3155000000E+04, 3.7581165542E+01, 1.4376522813E+01, 7.3879463049E+00, 4.3192339736E+00, 8.3932118455E-01],
	[2.3160000000E+04, 3.7593630931E+01, 1.4376285305E+01, 7.3930920203E+00, 4.3211355308E+00, 8.3939639913E-01],
	[2.3165000000E+04, 3.7606111817E+01, 1.4376050704E+01, 7.3982402059E+00, 4.3230375149E+00, 8.3947158173E-01],
	[2.3170000000E+04, 3.7618636963E+01, 1.4375824838E+01, 7.4033908623E+00, 4.3249408341E+00, 8.3954673233E-01],
	[2.3175000000E+04, 3.7631163576E+01, 1.4375599025E+01, 7.4085439901E+00, 4.3268441383E+00, 8.3962185096E-01],
	[2.3180000000E+04, 3.7643691656E+01, 1.4375373264E+01, 7.4136995901E+00, 4.3287474269E+00, 8.3969693762E-01],
	[2.3185000000E+04, 3.7656221204E+01, 1.4375147555E+01, 7.4188576627E+00, 4.3306506997E+00, 8.3977199231E-01],
	[2.3190000000E+04, 3.7668752219E+01, 1.4374921898E+01, 7.4240182088E+00, 4.3325539562E+00, 8.3984701504E-01],
	[2.3195000000E+04, 3.7681284701E+01, 1.4374696294E+01, 7.4291812289E+00, 4.3344571961E+00, 8.3992200583E-01],
	[2.3200000000E+04, 3.7693818651E+01, 1.4374470741E+01, 7.4343467237E+00, 4.3363604191E+00, 8.3999696467E-01],
	[2.3205000000E+04, 3.7706354067E+01, 1.4374245241E+01, 7.4395146938E+00, 4.3382636247E+00, 8.4007189158E-01],
	[2.3210000000E+04, 3.7718890949E+01, 1.4374019793E+01, 7.4446851399E+00, 4.3401668125E+00, 8.4014678655E-01],
	[2.3215000000E+04, 3.7731429299E+01, 1.4373794397E+01, 7.4498580627E+00, 4.3420699823E+00, 8.4022164961E-01],
	[2.3220000000E+04, 3.7743969115E+01, 1.4373569054E+01, 7.4550334628E+00, 4.3439731336E+00, 8.4029648076E-01],
	[2.3225000000E+04, 3.7756510397E+01, 1.4373343762E+01, 7.4602113408E+00, 4.3458762660E+00, 8.4037128000E-01],
	[2.3230000000E+04, 3.7769053145E+01, 1.4373118522E+01, 7.4653916974E+00, 4.3477793792E+00, 8.4044604734E-01],
	[2.3235000000E+04, 3.7781597359E+01, 1.4372893334E+01, 7.4705745333E+00, 4.3496824728E+00, 8.4052078279E-01],
	[2.3240000000E+04, 3.7794143039E+01, 1.4372668198E+01, 7.4757598491E+00, 4.3515855465E+00, 8.4059548635E-01],
	[2.3245000000E+04, 3.7806690184E+01, 1.4372443115E+01, 7.4809476454E+00, 4.3534885998E+00, 8.4067015804E-01],
	[2.3250000000E+04, 3.7819238795E+01, 1.4372218083E+01, 7.4861379230E+00, 4.3553916323E+00, 8.4074479787E-01],
	[2.3255000000E+04, 3.7831788872E+01, 1.4371993103E+01, 7.4913306824E+00, 4.3572946438E+00, 8.4081940583E-01],
	[2.3260000000E+04, 3.7844340414E+01, 1.4371768175E+01, 7.4965259243E+00, 4.3591976339E+00, 8.4089398194E-01],
	[2.3265000000E+04, 3.7856893421E+01, 1.4371543298E+01, 7.5017236494E+00, 4.3611006021E+00, 8.4096852620E-01],
	[2.3270000000E+04, 3.7869447892E+01, 1.4371318474E+01, 7.5069238583E+00, 4.3630035481E+00, 8.4104303862E-01],
	[2.3275000000E+04, 3.7882003829E+01, 1.4371093701E+01, 7.5121265516E+00, 4.3649064716E+00, 8.4111751921E-01],
	[2.3280000000E+04, 3.7894561230E+01, 1.4370868981E+01, 7.5173317301E+00, 4.3668093721E+00, 8.4119196798E-01],
	[2.3285000000E+04, 3.7907120096E+01, 1.4370644312E+01, 7.5225393943E+00, 4.3687122492E+00, 8.4126638493E-01],
	[2.3290000000E+04, 3.7919680426E+01, 1.4370419694E+01, 7.5277495449E+00, 4.3706151027E+00, 8.4134077008E-01],
	[2.3295000000E+04, 3.7932242221E+01, 1.4370195129E+01, 7.5329621827E+00, 4.3725179322E+00, 8.4141512342E-01],
	[2.3300000000E+04, 3.7944805480E+01, 1.4369970615E+01, 7.5381773081E+00, 4.3744207372E+00, 8.4148944497E-01],
	[2.3305000000E+04, 3.7957370202E+01, 1.4369746153E+01, 7.5433949219E+00, 4.3763235175E+00, 8.4156373473E-01],
	[2.3310000000E+04, 3.7969936388E+01, 1.4369521742E+01, 7.5486150247E+00, 4.3782262725E+00, 8.4163799272E-01],
	[2.3315000000E+04, 3.7982504039E+01, 1.4369297384E+01, 7.5538376172E+00, 4.3801290020E+00, 8.4171221894E-01],
	[2.3320000000E+04, 3.7995073152E+01, 1.4369073076E+01, 7.5590627001E+00, 4.3820317057E+00, 8.4178641339E-01],
	[2.3325000000E+04, 3.8007643729E+01, 1.4368848821E+01, 7.5642902739E+00, 4.3839343830E+00, 8.4186057609E-01],
	[2.3330000000E+04, 3.8020215769E+01, 1.4368624617E+01, 7.5695203393E+00, 4.3858370337E+00, 8.4193470704E-01],
	[2.3335000000E+04, 3.8032789272E+01, 1.4368400464E+01, 7.5747528971E+00, 4.3877396574E+00, 8.4200880625E-01],
	[2.3340000000E+04, 3.8045364239E+01, 1.4368176363E+01, 7.5799879477E+00, 4.3896422537E+00, 8.4208287373E-01],
	[2.3345000000E+04, 3.8057940668E+01, 1.4367952313E+01, 7.5852254920E+00, 4.3915448223E+00, 8.4215690949E-01],
	[2.3350000000E+04, 3.8070518559E+01, 1.4367728315E+01, 7.5904655305E+00, 4.3934473628E+00, 8.4223091353E-01],
	[2.3355000000E+04, 3.8083097914E+01, 1.4367504369E+01, 7.5957080639E+00, 4.3953498747E+00, 8.4230488586E-01],
	[2.3360000000E+04, 3.8095678730E+01, 1.4367280474E+01, 7.6009530928E+00, 4.3972523578E+00, 8.4237882649E-01],
	[2.3365000000E+04, 3.8108261009E+01, 1.4367056630E+01, 7.6062006179E+00, 4.3991548117E+00, 8.4245273543E-01],
	[2.3370000000E+04, 3.8120844750E+01, 1.4366832837E+01, 7.6114506399E+00, 4.4010572360E+00, 8.4252661268E-01],
	[2.3375000000E+04, 3.8133429953E+01, 1.4366609096E+01, 7.6167031593E+00, 4.4029596304E+00, 8.4260045825E-01],
	[2.3380000000E+04, 3.8146016618E+01, 1.4366385407E+01, 7.6219581769E+00, 4.4048619944E+00, 8.4267427215E-01],
	[2.3385000000E+04, 3.8158604744E+01, 1.4366161768E+01, 7.6272156934E+00, 4.4067643277E+00, 8.4274805440E-01],
	[2.3390000000E+04, 3.8171194332E+01, 1.4365938181E+01, 7.6324757092E+00, 4.4086666300E+00, 8.4282180498E-01],
	[2.3395000000E+04, 3.8183785381E+01, 1.4365714645E+01, 7.6377382252E+00, 4.4105689008E+00, 8.4289552393E-01],
	[2.3400000000E+04, 3.8196377892E+01, 1.4365491161E+01, 7.6430032419E+00, 4.4124711398E+00, 8.4296921123E-01],
	[2.3405000000E+04, 3.8208971863E+01, 1.4365267728E+01, 7.6482707601E+00, 4.4143733467E+00, 8.4304286690E-01],
	[2.3410000000E+04, 3.8221567296E+01, 1.4365044345E+01, 7.6535407803E+00, 4.4162755211E+00, 8.4311649095E-01],
	[2.3415000000E+04, 3.8234164189E+01, 1.4364821014E+01, 7.6588133032E+00, 4.4181776626E+00, 8.4319008338E-01],
	[2.3420000000E+04, 3.8246762543E+01, 1.4364597735E+01, 7.6640883295E+00, 4.4200797708E+00, 8.4326364421E-01],
	[2.3425000000E+04, 3.8259362358E+01, 1.4364374506E+01, 7.6693658598E+00, 4.4219818454E+00, 8.4333717344E-01],
	[2.3430000000E+04, 3.8271963633E+01, 1.4364151328E+01, 7.6746458948E+00, 4.4238838860E+00, 8.4341067108E-01],
	[2.3435000000E+04, 3.8284566368E+01, 1.4363928202E+01, 7.6799284351E+00, 4.4257858922E+00, 8.4348413713E-01],
	[2.3440000000E+04, 3.8297170563E+01, 1.4363705126E+01, 7.6852134814E+00, 4.4276878638E+00, 8.4355757161E-01],
	[2.3445000000E+04, 3.8309776218E+01, 1.4363482102E+01, 7.6905010344E+00, 4.4295898002E+00, 8.4363097453E-01],
	[2.3450000000E+04, 3.8322383333E+01, 1.4363259129E+01, 7.6957910946E+00, 4.4314917012E+00, 8.4370434588E-01],
	[2.3455000000E+04, 3.8334991908E+01, 1.4363036206E+01, 7.7010836627E+00, 4.4333935664E+00, 8.4377768568E-01],
	[2.3460000000E+04, 3.8347601942E+01, 1.4362813335E+01, 7.7063787394E+00, 4.4352953954E+00, 8.4385099394E-01],
	[2.3465000000E+04, 3.8360213436E+01, 1.4362590515E+01, 7.7116763254E+00, 4.4371971879E+00, 8.4392427066E-01],
	[2.3470000000E+04, 3.8372826388E+01, 1.4362367745E+01, 7.7169764213E+00, 4.4390989434E+00, 8.4399751586E-01],
	[2.3475000000E+04, 3.8385440800E+01, 1.4362145027E+01, 7.7222790277E+00, 4.4410006617E+00, 8.4407072954E-01],
	[2.3480000000E+04, 3.8398056671E+01, 1.4361922359E+01, 7.7275841453E+00, 4.4429023424E+00, 8.4414391170E-01],
	[2.3485000000E+04, 3.8410674001E+01, 1.4361699742E+01, 7.7328917747E+00, 4.4448039851E+00, 8.4421706237E-01],
	[2.3490000000E+04, 3.8423292789E+01, 1.4361477176E+01, 7.7382019167E+00, 4.4467055894E+00, 8.4429018154E-01],
	[2.3495000000E+04, 3.8435913036E+01, 1.4361254661E+01, 7.7435145718E+00, 4.4486071550E+00, 8.4436326922E-01],
	[2.3500000000E+04, 3.8448534742E+01, 1.4361032196E+01, 7.7488297407E+00, 4.4505086815E+00, 8.4443632542E-01],
	[2.3505000000E+04, 3.8461157905E+01, 1.4360809783E+01, 7.7541474241E+00, 4.4524101685E+00, 8.4450935015E-01],
	[2.3510000000E+04, 3.8473782527E+01, 1.4360587420E+01, 7.7594676226E+00, 4.4543116158E+00, 8.4458234342E-01],
	[2.3515000000E+04, 3.8486408606E+01, 1.4360365108E+01, 7.7647903369E+00, 4.4562130229E+00, 8.4465530524E-01],
	[2.3520000000E+04, 3.8499036144E+01, 1.4360142846E+01, 7.7701155676E+00, 4.4581143894E+00, 8.4472823561E-01],
	[2.3525000000E+04, 3.8511665139E+01, 1.4359920636E+01, 7.7754433154E+00, 4.4600157151E+00, 8.4480113454E-01],
	[2.3530000000E+04, 3.8524295592E+01, 1.4359698476E+01, 7.7807735809E+00, 4.4619169994E+00, 8.4487400204E-01],
	[2.3535000000E+04, 3.8536927502E+01, 1.4359476366E+01, 7.7861063647E+00, 4.4638182422E+00, 8.4494683812E-01],
	[2.3540000000E+04, 3.8549599281E+01, 1.4359261876E+01, 7.7914416676E+00, 4.4657206906E+00, 8.4501964279E-01],
	[2.3545000000E+04, 3.8562291783E+01, 1.4359051228E+01, 7.7967794902E+00, 4.4676237236E+00, 8.4509241605E-01],
	[2.3550000000E+04, 3.8574985768E+01, 1.4358840626E+01, 7.8021198332E+00, 4.4695267162E+00, 8.4516515791E-01],
	[2.3555000000E+04, 3.8587681236E+01, 1.4358630073E+01, 7.8074626971E+00, 4.4714296681E+00, 8.4523786839E-01],
	[2.3560000000E+04, 3.8600378186E+01, 1.4358419568E+01, 7.8128080826E+00, 4.4733325789E+00, 8.4531054748E-01],
	[2.3565000000E+04, 3.8613076618E+01, 1.4358209110E+01, 7.8181559905E+00, 4.4752354482E+00, 8.4538319521E-01],
	[2.3570000000E+04, 3.8625776532E+01, 1.4357998700E+01, 7.8235064213E+00, 4.4771382757E+00, 8.4545581157E-01],
	[2.3575000000E+04, 3.8638477928E+01, 1.4357788338E+01, 7.8288593758E+00, 4.4790410611E+00, 8.4552839657E-01],
	[2.3580000000E+04, 3.8651180806E+01, 1.4357578023E+01, 7.8342148544E+00, 4.4809438038E+00, 8.4560095022E-01],
	[2.3585000000E+04, 3.8663885166E+01, 1.4357367756E+01, 7.8395728580E+00, 4.4828465037E+00, 8.4567347254E-01],
	[2.3590000000E+04, 3.8676591006E+01, 1.4357157537E+01, 7.8449333872E+00, 4.4847491603E+00, 8.4574596353E-01],
	[2.3595000000E+04, 3.8689298329E+01, 1.4356947365E+01, 7.8502964426E+00, 4.4866517733E+00, 8.4581842319E-01],
	[2.3600000000E+04, 3.8702007132E+01, 1.4356737241E+01, 7.8556620248E+00, 4.4885543423E+00, 8.4589085154E-01],
	[2.3605000000E+04, 3.8714717417E+01, 1.4356527165E+01, 7.8610301346E+00, 4.4904568670E+00, 8.4596324858E-01],
	[2.3610000000E+04, 3.8727429182E+01, 1.4356317136E+01, 7.8664007725E+00, 4.4923593470E+00, 8.4603561433E-01],
	[2.3615000000E+04, 3.8740142428E+01, 1.4356107154E+01, 7.8717739393E+00, 4.4942617819E+00, 8.4610794879E-01],
	[2.3620000000E+04, 3.8752857155E+01, 1.4355897221E+01, 7.8771496356E+00, 4.4961641715E+00, 8.4618025196E-01],
	[2.3625000000E+04, 3.8765573362E+01, 1.4355687334E+01, 7.8825278620E+00, 4.4980665152E+00, 8.4625252387E-01],
	[2.3630000000E+04, 3.8778291050E+01, 1.4355477495E+01, 7.8879086192E+00, 4.4999688128E+00, 8.4632476451E-01],
	[2.3635000000E+04, 3.8791010218E+01, 1.4355267704E+01, 7.8932919078E+00, 4.5018710640E+00, 8.4639697389E-01],
	[2.3640000000E+04, 3.8803730866E+01, 1.4355057960E+01, 7.8986777286E+00, 4.5037732683E+00, 8.4646915203E-01],
	[2.3645000000E+04, 3.8816452993E+01, 1.4354848264E+01, 7.9040660821E+00, 4.5056754254E+00, 8.4654129893E-01],
	[2.3650000000E+04, 3.8829176601E+01, 1.4354638615E+01, 7.9094569690E+00, 4.5075775350E+00, 8.4661341460E-01],
	[2.3655000000E+04, 3.8841901688E+01, 1.4354429013E+01, 7.9148503900E+00, 4.5094795966E+00, 8.4668549904E-01],
	[2.3660000000E+04, 3.8854628255E+01, 1.4354219458E+01, 7.9202463457E+00, 4.5113816100E+00, 8.4675755228E-01],
	[2.3665000000E+04, 3.8867356301E+01, 1.4354009951E+01, 7.9256448367E+00, 4.5132835748E+00, 8.4682957431E-01],
	[2.3670000000E+04, 3.8880085826E+01, 1.4353800492E+01, 7.9310458638E+00, 4.5151854905E+00, 8.4690156514E-01],
	[2.3675000000E+04, 3.8892816831E+01, 1.4353591079E+01, 7.9364494275E+00, 4.5170873570E+00, 8.4697352479E-01],
	[2.3680000000E+04, 3.8905549314E+01, 1.4353381714E+01, 7.9418555286E+00, 4.5189891738E+00, 8.4704545325E-01],
	[2.3685000000E+04, 3.8918283276E+01, 1.4353172396E+01, 7.9472641677E+00, 4.5208909405E+00, 8.4711735055E-01],
	[2.3690000000E+04, 3.8931018717E+01, 1.4352963126E+01, 7.9526753454E+00, 4.5227926568E+00, 8.4718921668E-01],
	[2.3695000000E+04, 3.8943755636E+01, 1.4352753902E+01, 7.9580890624E+00, 4.5246943224E+00, 8.4726105166E-01],
	[2.3700000000E+04, 3.8956494034E+01, 1.4352544726E+01, 7.9635053193E+00, 4.5265959368E+00, 8.4733285550E-01],
	[2.3705000000E+04, 3.8969233910E+01, 1.4352335597E+01, 7.9689241168E+00, 4.5284974998E+00, 8.4740462820E-01],
	[2.3710000000E+04, 3.8981975264E+01, 1.4352126515E+01, 7.9743454556E+00, 4.5303990110E+00, 8.4747636977E-01],
	[2.3715000000E+04, 3.8994718096E+01, 1.4351917480E+01, 7.9797693363E+00, 4.5323004700E+00, 8.4754808022E-01],
	[2.3720000000E+04, 3.9007462406E+01, 1.4351708492E+01, 7.9851957596E+00, 4.5342018765E+00, 8.4761975956E-01],
	[2.3725000000E+04, 3.9020208193E+01, 1.4351499552E+01, 7.9906247261E+00, 4.5361032301E+00, 8.4769140780E-01],
	[2.3730000000E+04, 3.9032955458E+01, 1.4351290658E+01, 7.9960562364E+00, 4.5380045305E+00, 8.4776302494E-01],
	[2.3735000000E+04, 3.9045704201E+01, 1.4351081812E+01, 8.0014902913E+00, 4.5399057773E+00, 8.4783461101E-01],
	[2.3740000000E+04, 3.9058454420E+01, 1.4350873012E+01, 8.0069268914E+00, 4.5418069701E+00, 8.4790616599E-01],
	[2.3745000000E+04, 3.9071206117E+01, 1.4350664260E+01, 8.0123660372E+00, 4.5437081087E+00, 8.4797768991E-01],
	[2.3750000000E+04, 3.9083959291E+01, 1.4350455555E+01, 8.0178077296E+00, 4.5456091926E+00, 8.4804918277E-01],
	[2.3755000000E+04, 3.9096713941E+01, 1.4350246896E+01, 8.0232519691E+00, 4.5475102215E+00, 8.4812064457E-01],
	[2.3760000000E+04, 3.9109470068E+01, 1.4350038285E+01, 8.0286987564E+00, 4.5494111951E+00, 8.4819207534E-01],
	[2.3765000000E+04, 3.9122227672E+01, 1.4349829720E+01, 8.0341480922E+00, 4.5513121129E+00, 8.4826347507E-01],
	[2.3770000000E+04, 3.9134986752E+01, 1.4349621202E+01, 8.0395999771E+00, 4.5532129748E+00, 8.4833484378E-01],
	[2.3775000000E+04, 3.9147747309E+01, 1.4349412731E+01, 8.0450544117E+00, 4.5551137802E+00, 8.4840618148E-01],
	[2.3780000000E+04, 3.9160509341E+01, 1.4349204308E+01, 8.0505113967E+00, 4.5570145288E+00, 8.4847748817E-01],
	[2.3785000000E+04, 3.9173272850E+01, 1.4348995930E+01, 8.0559709328E+00, 4.5589152204E+00, 8.4854876386E-01],
	[2.3790000000E+04, 3.9186037835E+01, 1.4348787600E+01, 8.0614330207E+00, 4.5608158545E+00, 8.4862000856E-01],
	[2.3795000000E+04, 3.9198804295E+01, 1.4348579317E+01, 8.0668976609E+00, 4.5627164307E+00, 8.4869122228E-01],
	[2.3800000000E+04, 3.9211572231E+01, 1.4348371080E+01, 8.0723648541E+00, 4.5646169489E+00, 8.4876240503E-01],
	[2.3805000000E+04, 3.9224341642E+01, 1.4348162890E+01, 8.0778346010E+00, 4.5665174085E+00, 8.4883355681E-01],
	[2.3810000000E+04, 3.9237112528E+01, 1.4347954747E+01, 8.0833069023E+00, 4.5684178092E+00, 8.4890467764E-01],
	[2.3815000000E+04, 3.9249884890E+01, 1.4347746650E+01, 8.0887817586E+00, 4.5703181508E+00, 8.4897576752E-01],
	[2.3820000000E+04, 3.9262658727E+01, 1.4347538601E+01, 8.0942591705E+00, 4.5722184327E+00, 8.4904682645E-01],
	[2.3825000000E+04, 3.9275434038E+01, 1.4347330598E+01, 8.0997391387E+00, 4.5741186548E+00, 8.4911785445E-01],
	[2.3830000000E+04, 3.9288210824E+01, 1.4347122641E+01, 8.1052216639E+00, 4.5760188166E+00, 8.4918885152E-01],
	[2.3835000000E+04, 3.9300989085E+01, 1.4346914731E+01, 8.1107067466E+00, 4.5779189178E+00, 8.4925981767E-01],
	[2.3840000000E+04, 3.9313768821E+01, 1.4346706868E+01, 8.1161943877E+00, 4.5798189581E+00, 8.4933075290E-01],
	[2.3845000000E+04, 3.9326550030E+01, 1.4346499052E+01, 8.1216845877E+00, 4.5817189370E+00, 8.4940165722E-01],
	[2.3850000000E+04, 3.9339332714E+01, 1.4346291282E+01, 8.1271773473E+00, 4.5836188543E+00, 8.4947253065E-01],
	[2.3855000000E+04, 3.9352116872E+01, 1.4346083558E+01, 8.1326726670E+00, 4.5855187095E+00, 8.4954337318E-01],
	[2.3860000000E+04, 3.9364902504E+01, 1.4345875882E+01, 8.1381705477E+00, 4.5874185024E+00, 8.4961418483E-01],
	[2.3865000000E+04, 3.9377689609E+01, 1.4345668251E+01, 8.1436709900E+00, 4.5893182327E+00, 8.4968496560E-01],
	[2.3870000000E+04, 3.9390478189E+01, 1.4345460667E+01, 8.1491739944E+00, 4.5912178998E+00, 8.4975571549E-01],
	[2.3875000000E+04, 3.9403268241E+01, 1.4345253130E+01, 8.1546795617E+00, 4.5931175036E+00, 8.4982643453E-01],
	[2.3880000000E+04, 3.9416059767E+01, 1.4345045639E+01, 8.1601876925E+00, 4.5950170436E+00, 8.4989712271E-01],
	[2.3885000000E+04, 3.9428852767E+01, 1.4344838195E+01, 8.1656983874E+00, 4.5969165196E+00, 8.4996778003E-01],
	[2.3890000000E+04, 3.9441647239E+01, 1.4344630797E+01, 8.1712116472E+00, 4.5988159311E+00, 8.5003840652E-01],
	[2.3895000000E+04, 3.9454443184E+01, 1.4344423445E+01, 8.1767274725E+00, 4.6007152778E+00, 8.5010900217E-01],
	[2.3900000000E+04, 3.9467240602E+01, 1.4344216140E+01, 8.1822458638E+00, 4.6026145593E+00, 8.5017956700E-01],
	[2.3905000000E+04, 3.9480039493E+01, 1.4344008881E+01, 8.1877668220E+00, 4.6045137754E+00, 8.5025010100E-01],
	[2.3910000000E+04, 3.9492839856E+01, 1.4343801668E+01, 8.1932903476E+00, 4.6064129257E+00, 8.5032060420E-01],
	[2.3915000000E+04, 3.9505641692E+01, 1.4343594502E+01, 8.1988164413E+00, 4.6083120098E+00, 8.5039107658E-01],
	[2.3920000000E+04, 3.9518496720E+01, 1.4343397283E+01, 8.2043451038E+00, 4.6102127541E+00, 8.5046151818E-01],
	[2.3925000000E+04, 3.9531359995E+01, 1.4343201400E+01, 8.2098763356E+00, 4.6121136591E+00, 8.5053192898E-01],
	[2.3930000000E+04, 3.9544224768E+01, 1.4343005560E+01, 8.2154101375E+00, 4.6140144993E+00, 8.5060230900E-01],
	[2.3935000000E+04, 3.9557091038E+01, 1.4342809764E+01, 8.2209465102E+00, 4.6159152742E+00, 8.5067265824E-01],
	[2.3940000000E+04, 3.9569958806E+01, 1.4342614012E+01, 8.2264854542E+00, 4.6178159835E+00, 8.5074297672E-01],
	[2.3945000000E+04, 3.9582828072E+01, 1.4342418303E+01, 8.2320269702E+00, 4.6197166269E+00, 8.5081326443E-01],
	[2.3950000000E+04, 3.9595698834E+01, 1.4342222638E+01, 8.2375710589E+00, 4.6216172040E+00, 8.5088352140E-01],
	[2.3955000000E+04, 3.9608571094E+01, 1.4342027016E+01, 8.2431177210E+00, 4.6235177146E+00, 8.5095374761E-01],
	[2.3960000000E+04, 3.9621444850E+01, 1.4341831438E+01, 8.2486669570E+00, 4.6254181582E+00, 8.5102394310E-01],
	[2.3965000000E+04, 3.9634320103E+01, 1.4341635903E+01, 8.2542187677E+00, 4.6273185345E+00, 8.5109410785E-01],
	[2.3970000000E+04, 3.9647196853E+01, 1.4341440412E+01, 8.2597731537E+00, 4.6292188432E+00, 8.5116424188E-01],
	[2.3975000000E+04, 3.9660075099E+01, 1.4341244964E+01, 8.2653301157E+00, 4.6311190838E+00, 8.5123434519E-01],
	[2.3980000000E+04, 3.9672954841E+01, 1.4341049559E+01, 8.2708896543E+00, 4.6330192562E+00, 8.5130441780E-01],
	[2.3985000000E+04, 3.9685836080E+01, 1.4340854198E+01, 8.2764517701E+00, 4.6349193599E+00, 8.5137445971E-01],
	[2.3990000000E+04, 3.9698718815E+01, 1.4340658881E+01, 8.2820164639E+00, 4.6368193946E+00, 8.5144447092E-01],
	[2.3995000000E+04, 3.9711603045E+01, 1.4340463606E+01, 8.2875837363E+00, 4.6387193599E+00, 8.5151445145E-01],
	[2.4000000000E+04, 3.9724488772E+01, 1.4340268375E+01, 8.2931535879E+00, 4.6406192556E+00, 8.5158440131E-01],
	[2.4005000000E+04, 3.9737375994E+01, 1.4340073188E+01, 8.2987260194E+00, 4.6425190812E+00, 8.5165432049E-01],
	[2.4010000000E+04, 3.9750264711E+01, 1.4339878043E+01, 8.3043010314E+00, 4.6444188364E+00, 8.5172420902E-01],
	[2.4015000000E+04, 3.9763154924E+01, 1.4339682942E+01, 8.3098786247E+00, 4.6463185209E+00, 8.5179406689E-01],
	[2.4020000000E+04, 3.9776046632E+01, 1.4339487884E+01, 8.3154587998E+00, 4.6482181344E+00, 8.5186389411E-01],
	[2.4025000000E+04, 3.9788939836E+01, 1.4339292870E+01, 8.3210415574E+00, 4.6501176764E+00, 8.5193369070E-01],
	[2.4030000000E+04, 3.9801834534E+01, 1.4339097899E+01, 8.3266268982E+00, 4.6520171467E+00, 8.5200345666E-01],
	[2.4035000000E+04, 3.9814730727E+01, 1.4338902971E+01, 8.3322148229E+00, 4.6539165449E+00, 8.5207319199E-01],
	[2.4040000000E+04, 3.9827628415E+01, 1.4338708086E+01, 8.3378053320E+00, 4.6558158707E+00, 8.5214289671E-01],
	[2.4045000000E+04, 3.9840527597E+01, 1.4338513244E+01, 8.3433984263E+00, 4.6577151237E+00, 8.5221257082E-01],
	[2.4050000000E+04, 3.9853428274E+01, 1.4338318445E+01, 8.3489941064E+00, 4.6596143036E+00, 8.5228221433E-01],
	[2.4055000000E+04, 3.9866330444E+01, 1.4338123690E+01, 8.3545923729E+00, 4.6615134101E+00, 8.5235182725E-01],
	[2.4060000000E+04, 3.9879234110E+01, 1.4337928978E+01, 8.3601932265E+00, 4.6634124428E+00, 8.5242140958E-01],
	[2.4065000000E+04, 3.9892139269E+01, 1.4337734308E+01, 8.3657966679E+00, 4.6653114013E+00, 8.5249096134E-01],
	[2.4070000000E+04, 3.9905045921E+01, 1.4337539682E+01, 8.3714026977E+00, 4.6672102854E+00, 8.5256048253E-01],
	[2.4075000000E+04, 3.9917954068E+01, 1.4337345099E+01, 8.3770113166E+00, 4.6691090947E+00, 8.5262997317E-01],
	[2.4080000000E+04, 3.9930863708E+01, 1.4337150559E+01, 8.3826225253E+00, 4.6710078288E+00, 8.5269943324E-01],
	[2.4085000000E+04, 3.9943774842E+01, 1.4336956062E+01, 8.3882363243E+00, 4.6729064875E+00, 8.5276886278E-01],
	[2.4090000000E+04, 3.9956687469E+01, 1.4336761608E+01, 8.3938527144E+00, 4.6748050703E+00, 8.5283826177E-01],
	[2.4095000000E+04, 3.9969601589E+01, 1.4336567197E+01, 8.3994716962E+00, 4.6767035770E+00, 8.5290763024E-01],
	[2.4100000000E+04, 3.9982517202E+01, 1.4336372829E+01, 8.4050932703E+00, 4.6786020072E+00, 8.5297696819E-01],
	[2.4105000000E+04, 3.9995434308E+01, 1.4336178504E+01, 8.4107174375E+00, 4.6805003605E+00, 8.5304627562E-01],
	[2.4110000000E+04, 4.0008352907E+01, 1.4335984222E+01, 8.4163441983E+00, 4.6823986367E+00, 8.5311555255E-01],
	[2.4115000000E+04, 4.0021272998E+01, 1.4335789983E+01, 8.4219735535E+00, 4.6842968353E+00, 8.5318479898E-01],
	[2.4120000000E+04, 4.0034194582E+01, 1.4335595787E+01, 8.4276055036E+00, 4.6861949561E+00, 8.5325401492E-01],
	[2.4125000000E+04, 4.0047117658E+01, 1.4335401633E+01, 8.4332400494E+00, 4.6880929987E+00, 8.5332320038E-01],
	[2.4130000000E+04, 4.0060042226E+01, 1.4335207523E+01, 8.4388771915E+00, 4.6899909628E+00, 8.5339235537E-01],
	[2.4135000000E+04, 4.0072968287E+01, 1.4335013455E+01, 8.4445169305E+00, 4.6918888480E+00, 8.5346147989E-01],
	[2.4140000000E+04, 4.0085895839E+01, 1.4334819430E+01, 8.4501592672E+00, 4.6937866541E+00, 8.5353057395E-01],
	[2.4145000000E+04, 4.0098824883E+01, 1.4334625448E+01, 8.4558042021E+00, 4.6956843806E+00, 8.5359963757E-01],
	[2.4150000000E+04, 4.0111755419E+01, 1.4334431509E+01, 8.4614517360E+00, 4.6975820272E+00, 8.5366867074E-01],
	[2.4155000000E+04, 4.0124687446E+01, 1.4334237613E+01, 8.4671018694E+00, 4.6994795936E+00, 8.5373767348E-01],
	[2.4160000000E+04, 4.0137620965E+01, 1.4334043759E+01, 8.4727546031E+00, 4.7013770795E+00, 8.5380664579E-01],
	[2.4165000000E+04, 4.0150555975E+01, 1.4333849948E+01, 8.4784099377E+00, 4.7032744845E+00, 8.5387558769E-01],
	[2.4170000000E+04, 4.0163492476E+01, 1.4333656180E+01, 8.4840678738E+00, 4.7051718082E+00, 8.5394449918E-01],
	[2.4175000000E+04, 4.0176430468E+01, 1.4333462454E+01, 8.4897284121E+00, 4.7070690505E+00, 8.5401338026E-01],
	[2.4180000000E+04, 4.0189369951E+01, 1.4333268771E+01, 8.4953915533E+00, 4.7089662108E+00, 8.5408223096E-01],
	[2.4185000000E+04, 4.0202310925E+01, 1.4333075131E+01, 8.5010572980E+00, 4.7108632889E+00, 8.5415105127E-01],
	[2.4190000000E+04, 4.0215253389E+01, 1.4332881533E+01, 8.5067256470E+00, 4.7127602845E+00, 8.5421984120E-01],
	[2.4195000000E+04, 4.0228197343E+01, 1.4332687978E+01, 8.5123966007E+00, 4.7146571972E+00, 8.5428860076E-01],
	[2.4200000000E+04, 4.0241142788E+01, 1.4332494466E+01, 8.5180701599E+00, 4.7165540267E+00, 8.5435732996E-01],
	[2.4205000000E+04, 4.0254089723E+01, 1.4332300996E+01, 8.5237463253E+00, 4.7184507726E+00, 8.5442602882E-01],
	[2.4210000000E+04, 4.0267038148E+01, 1.4332107569E+01, 8.5294250975E+00, 4.7203474346E+00, 8.5449469732E-01],
	[2.4215000000E+04, 4.0279988063E+01, 1.4331914184E+01, 8.5351064772E+00, 4.7222440124E+00, 8.5456333549E-01],
	[2.4220000000E+04, 4.0292939468E+01, 1.4331720842E+01, 8.5407904649E+00, 4.7241405056E+00, 8.5463194334E-01],
	[2.4225000000E+04, 4.0305892362E+01, 1.4331527543E+01, 8.5464770615E+00, 4.7260369140E+00, 8.5470052086E-01],
	[2.4230000000E+04, 4.0318846746E+01, 1.4331334285E+01, 8.5521662675E+00, 4.7279332371E+00, 8.5476906807E-01],
	[2.4235000000E+04, 4.0331802619E+01, 1.4331141071E+01, 8.5578580836E+00, 4.7298294747E+00, 8.5483758498E-01],
	[2.4240000000E+04, 4.0344759981E+01, 1.4330947899E+01, 8.5635525104E+00, 4.7317256263E+00, 8.5490607159E-01],
	[2.4245000000E+04, 4.0357718833E+01, 1.4330754769E+01, 8.5692495486E+00, 4.7336216918E+00, 8.5497452792E-01],
	[2.4250000000E+04, 4.0370679173E+01, 1.4330561682E+01, 8.5749491989E+00, 4.7355176707E+00, 8.5504295397E-01],
	[2.4255000000E+04, 4.0383641002E+01, 1.4330368637E+01, 8.5806514620E+00, 4.7374135627E+00, 8.5511134975E-01],
	[2.4260000000E+04, 4.0396604320E+01, 1.4330175634E+01, 8.5863563384E+00, 4.7393093675E+00, 8.5517971526E-01],
	[2.4265000000E+04, 4.0409569126E+01, 1.4329982674E+01, 8.5920638288E+00, 4.7412050848E+00, 8.5524805053E-01],
	[2.4270000000E+04, 4.0422535421E+01, 1.4329789756E+01, 8.5977739340E+00, 4.7431007142E+00, 8.5531635555E-01],
	[2.4275000000E+04, 4.0435503204E+01, 1.4329596881E+01, 8.6034866545E+00, 4.7449962553E+00, 8.5538463033E-01],
	[2.4280000000E+04, 4.0448472475E+01, 1.4329404048E+01, 8.6092019910E+00, 4.7468917080E+00, 8.5545287488E-01],
	[2.4285000000E+04, 4.0461443234E+01, 1.4329211257E+01, 8.6149199441E+00, 4.7487870717E+00, 8.5552108921E-01],
	[2.4290000000E+04, 4.0474415480E+01, 1.4329018509E+01, 8.6206405146E+00, 4.7506823463E+00, 8.5558927333E-01],
	[2.4295000000E+04, 4.0487389215E+01, 1.4328825802E+01, 8.6263637031E+00, 4.7525775313E+00, 8.5565742725E-01],
	[2.4300000000E+04, 4.0500364437E+01, 1.4328633138E+01, 8.6320895102E+00, 4.7544726264E+00, 8.5572555097E-01],
	[2.4305000000E+04, 4.0513393501E+01, 1.4328450253E+01, 8.6378179366E+00, 4.7563694259E+00, 8.5579364451E-01],
	[2.4310000000E+04, 4.0526431022E+01, 1.4328268699E+01, 8.6435489829E+00, 4.7582663751E+00, 8.5586170787E-01],
	[2.4315000000E+04, 4.0539470055E+01, 1.4328087184E+01, 8.6492826499E+00, 4.7601632357E+00, 8.5592974105E-01],
	[2.4320000000E+04, 4.0552510601E+01, 1.4327905709E+01, 8.6550189381E+00, 4.7620600075E+00, 8.5599774408E-01],
	[2.4325000000E+04, 4.0565552660E+01, 1.4327724274E+01, 8.6607578483E+00, 4.7639566901E+00, 8.5606571695E-01],
	[2.4330000000E+04, 4.0578596231E+01, 1.4327542878E+01, 8.6664993810E+00, 4.7658532832E+00, 8.5613365968E-01],
	[2.4335000000E+04, 4.0591641315E+01, 1.4327361522E+01, 8.6722435370E+00, 4.7677497865E+00, 8.5620157227E-01],
	[2.4340000000E+04, 4.0604687912E+01, 1.4327180206E+01, 8.6779903169E+00, 4.7696461995E+00, 8.5626945474E-01],
	[2.4345000000E+04, 4.0617736020E+01, 1.4326998929E+01, 8.6837397214E+00, 4.7715425222E+00, 8.5633730708E-01],
	[2.4350000000E+04, 4.0630785641E+01, 1.4326817691E+01, 8.6894917510E+00, 4.7734387539E+00, 8.5640512931E-01],
	[2.4355000000E+04, 4.0643836774E+01, 1.4326636493E+01, 8.6952464066E+00, 4.7753348946E+00, 8.5647292145E-01],
	[2.4360000000E+04, 4.0656889418E+01, 1.4326455335E+01, 8.7010036886E+00, 4.7772309437E+00, 8.5654068348E-01],
	[2.4365000000E+04, 4.0669943574E+01, 1.4326274216E+01, 8.7067635979E+00, 4.7791269011E+00, 8.5660841544E-01],
	[2.4370000000E+04, 4.0682999242E+01, 1.4326093136E+01, 8.7125261350E+00, 4.7810227663E+00, 8.5667611731E-01],
	[2.4375000000E+04, 4.0696056421E+01, 1.4325912096E+01, 8.7182913006E+00, 4.7829185391E+00, 8.5674378912E-01],
	[2.4380000000E+04, 4.0709115112E+01, 1.4325731095E+01, 8.7240590954E+00, 4.7848142191E+00, 8.5681143087E-01],
	[2.4385000000E+04, 4.0722175313E+01, 1.4325550134E+01, 8.7298295199E+00, 4.7867098060E+00, 8.5687904257E-01],
	[2.4390000000E+04, 4.0735237026E+01, 1.4325369212E+01, 8.7356025750E+00, 4.7886052994E+00, 8.5694662423E-01],
	[2.4395000000E+04, 4.0748300249E+01, 1.4325188329E+01, 8.7413782612E+00, 4.7905006991E+00, 8.5701417585E-01],
	[2.4400000000E+04, 4.0761364984E+01, 1.4325007486E+01, 8.7471565792E+00, 4.7923960047E+00, 8.5708169744E-01],
	[2.4405000000E+04, 4.0774431228E+01, 1.4324826682E+01, 8.7529375297E+00, 4.7942912159E+00, 8.5714918902E-01],
	[2.4410000000E+04, 4.0787498984E+01, 1.4324645918E+01, 8.7587211132E+00, 4.7961863323E+00, 8.5721665060E-01],
	[2.4415000000E+04, 4.0800568249E+01, 1.4324465192E+01, 8.7645073306E+00, 4.7980813537E+00, 8.5728408217E-01],
	[2.4420000000E+04, 4.0813639025E+01, 1.4324284506E+01, 8.7702961823E+00, 4.7999762797E+00, 8.5735148375E-01],
	[2.4425000000E+04, 4.0826711311E+01, 1.4324103860E+01, 8.7760876692E+00, 4.8018711100E+00, 8.5741885535E-01],
	[2.4430000000E+04, 4.0839785107E+01, 1.4323923252E+01, 8.7818817917E+00, 4.8037658443E+00, 8.5748619698E-01],
	[2.4435000000E+04, 4.0852860413E+01, 1.4323742684E+01, 8.7876785507E+00, 4.8056604822E+00, 8.5755350864E-01],
	[2.4440000000E+04, 4.0865937228E+01, 1.4323562155E+01, 8.7934779468E+00, 4.8075550234E+00, 8.5762079034E-01],
	[2.4445000000E+04, 4.0879015553E+01, 1.4323381665E+01, 8.7992799806E+00, 4.8094494676E+00, 8.5768804210E-01],
	[2.4450000000E+04, 4.0892095387E+01, 1.4323201215E+01, 8.8050846527E+00, 4.8113438145E+00, 8.5775526392E-01],
	[2.4455000000E+04, 4.0905176730E+01, 1.4323020803E+01, 8.8108919639E+00, 4.8132380637E+00, 8.5782245581E-01],
	[2.4460000000E+04, 4.0918259583E+01, 1.4322840431E+01, 8.8167019148E+00, 4.8151322149E+00, 8.5788961778E-01],
	[2.4465000000E+04, 4.0931343944E+01, 1.4322660098E+01, 8.8225145060E+00, 4.8170262679E+00, 8.5795674983E-01],
	[2.4470000000E+04, 4.0944429815E+01, 1.4322479804E+01, 8.8283297382E+00, 4.8189202222E+00, 8.5802385199E-01],
	[2.4475000000E+04, 4.0957517194E+01, 1.4322299549E+01, 8.8341476122E+00, 4.8208140776E+00, 8.5809092424E-01],
	[2.4480000000E+04, 4.0970606082E+01, 1.4322119333E+01, 8.8399681284E+00, 4.8227078337E+00, 8.5815796661E-01],
	[2.4485000000E+04, 4.0983696478E+01, 1.4321939156E+01, 8.8457912876E+00, 4.8246014902E+00, 8.5822497911E-01],
	[2.4490000000E+04, 4.0996788383E+01, 1.4321759018E+01, 8.8516170905E+00, 4.8264950468E+00, 8.5829196173E-01],
	[2.4495000000E+04, 4.1009881795E+01, 1.4321578920E+01, 8.8574455377E+00, 4.8283885031E+00, 8.5835891450E-01],
	[2.4500000000E+04, 4.1022976716E+01, 1.4321398860E+01, 8.8632766298E+00, 4.8302818590E+00, 8.5842583741E-01],
	[2.4505000000E+04, 4.1036073145E+01, 1.4321218839E+01, 8.8691103676E+00, 4.8321751139E+00, 8.5849273048E-01],
	[2.4510000000E+04, 4.1049171081E+01, 1.4321038858E+01, 8.8749467516E+00, 4.8340682676E+00, 8.5855959372E-01],
	[2.4515000000E+04, 4.1062270525E+01, 1.4320858915E+01, 8.8807857826E+00, 4.8359613199E+00, 8.5862642713E-01],
	[2.4520000000E+04, 4.1075371477E+01, 1.4320679011E+01, 8.8866274612E+00, 4.8378542702E+00, 8.5869323073E-01],
	[2.4525000000E+04, 4.1088473936E+01, 1.4320499147E+01, 8.8924717880E+00, 4.8397471185E+00, 8.5876000452E-01],
	[2.4530000000E+04, 4.1101577902E+01, 1.4320319321E+01, 8.8983187638E+00, 4.8416398642E+00, 8.5882674851E-01],
	[2.4535000000E+04, 4.1114683376E+01, 1.4320139534E+01, 8.9041683891E+00, 4.8435325071E+00, 8.5889346272E-01],
	[2.4540000000E+04, 4.1127790356E+01, 1.4319959786E+01, 8.9100206646E+00, 4.8454250470E+00, 8.5896014714E-01],
	[2.4545000000E+04, 4.1140898843E+01, 1.4319780077E+01, 8.9158755911E+00, 4.8473174833E+00, 8.5902680179E-01],
	[2.4550000000E+04, 4.1154008837E+01, 1.4319600406E+01, 8.9217331691E+00, 4.8492098160E+00, 8.5909342668E-01],
	[2.4555000000E+04, 4.1167120337E+01, 1.4319420775E+01, 8.9275933993E+00, 4.8511020445E+00, 8.5916002182E-01],
	[2.4560000000E+04, 4.1180233344E+01, 1.4319241182E+01, 8.9334562824E+00, 4.8529941687E+00, 8.5922658721E-01],
	[2.4565000000E+04, 4.1193347858E+01, 1.4319061628E+01, 8.9393218190E+00, 4.8548861881E+00, 8.5929312287E-01],
	[2.4570000000E+04, 4.1206463877E+01, 1.4318882113E+01, 8.9451900098E+00, 4.8567781025E+00, 8.5935962880E-01],
	[2.4575000000E+04, 4.1219581402E+01, 1.4318702637E+01, 8.9510608554E+00, 4.8586699116E+00, 8.5942610501E-01],
	[2.4580000000E+04, 4.1232700434E+01, 1.4318523200E+01, 8.9569343566E+00, 4.8605616150E+00, 8.5949255151E-01],
	[2.4585000000E+04, 4.1245820971E+01, 1.4318343801E+01, 8.9628105139E+00, 4.8624532123E+00, 8.5955896831E-01],
	[2.4590000000E+04, 4.1258943014E+01, 1.4318164441E+01, 8.9686893280E+00, 4.8643447034E+00, 8.5962535542E-01],
	[2.4595000000E+04, 4.1272066562E+01, 1.4317985119E+01, 8.9745707996E+00, 4.8662360879E+00, 8.5969171285E-01],
	[2.4600000000E+04, 4.1285191616E+01, 1.4317805837E+01, 8.9804549294E+00, 4.8681273654E+00, 8.5975804061E-01],
	[2.4605000000E+04, 4.1298318175E+01, 1.4317626593E+01, 8.9863417180E+00, 4.8700185357E+00, 8.5982433870E-01],
	[2.4610000000E+04, 4.1311446239E+01, 1.4317447388E+01, 8.9922311660E+00, 4.8719095984E+00, 8.5989060714E-01],
	[2.4615000000E+04, 4.1324575808E+01, 1.4317268221E+01, 8.9981232741E+00, 4.8738005532E+00, 8.5995684593E-01],
	[2.4620000000E+04, 4.1337706881E+01, 1.4317089093E+01, 9.0040180431E+00, 4.8756913998E+00, 8.6002305509E-01],
	[2.4625000000E+04, 4.1350839460E+01, 1.4316910004E+01, 9.0099154734E+00, 4.8775821379E+00, 8.6008923462E-01],
	[2.4630000000E+04, 4.1363973543E+01, 1.4316730953E+01, 9.0158155659E+00, 4.8794727671E+00, 8.6015538453E-01],
	[2.4635000000E+04, 4.1377109131E+01, 1.4316551941E+01, 9.0217183211E+00, 4.8813632872E+00, 8.6022150483E-01],
	[2.4640000000E+04, 4.1390246223E+01, 1.4316372967E+01, 9.0276237397E+00, 4.8832536978E+00, 8.6028759553E-01],
	[2.4645000000E+04, 4.1403384819E+01, 1.4316194032E+01, 9.0335318224E+00, 4.8851439986E+00, 8.6035365663E-01],
	[2.4650000000E+04, 4.1416524919E+01, 1.4316015135E+01, 9.0394425699E+00, 4.8870341894E+00, 8.6041968816E-01],
	[2.4655000000E+04, 4.1429666523E+01, 1.4315836277E+01, 9.0453559827E+00, 4.8889242697E+00, 8.6048569011E-01],
	[2.4660000000E+04, 4.1442809631E+01, 1.4315657458E+01, 9.0512720616E+00, 4.8908142392E+00, 8.6055166250E-01],
	[2.4665000000E+04, 4.1455954242E+01, 1.4315478677E+01, 9.0571908073E+00, 4.8927040978E+00, 8.6061760533E-01],
	[2.4670000000E+04, 4.1469100357E+01, 1.4315299934E+01, 9.0631122203E+00, 4.8945938450E+00, 8.6068351862E-01],
	[2.4675000000E+04, 4.1482247975E+01, 1.4315121230E+01, 9.0690363013E+00, 4.8964834805E+00, 8.6074940237E-01],
	[2.4680000000E+04, 4.1495397097E+01, 1.4314942564E+01, 9.0749630510E+00, 4.8983730040E+00, 8.6081525659E-01],
	[2.4685000000E+04, 4.1508547721E+01, 1.4314763937E+01, 9.0808924701E+00, 4.9002624152E+00, 8.6088108130E-01],
	[2.4690000000E+04, 4.1521699849E+01, 1.4314585348E+01, 9.0868245592E+00, 4.9021517138E+00, 8.6094687649E-01],
	[2.4695000000E+04, 4.1534892066E+01, 1.4314413770E+01, 9.0927593189E+00, 4.9040422557E+00, 8.6101264219E-01],
	[2.4700000000E+04, 4.1548107360E+01, 1.4314246121E+01, 9.0986967500E+00, 4.9059334437E+00, 8.6107837839E-01],
	[2.4705000000E+04, 4.1561324182E+01, 1.4314078509E+01, 9.1046368531E+00, 4.9078245206E+00, 8.6114408512E-01],
	[2.4710000000E+04, 4.1574542532E+01, 1.4313910933E+01, 9.1105796289E+00, 4.9097154859E+00, 8.6120976237E-01],
	[2.4715000000E+04, 4.1587762411E+01, 1.4313743392E+01, 9.1165250779E+00, 4.9116063394E+00, 8.6127541015E-01],
	[2.4720000000E+04, 4.1600983818E+01, 1.4313575887E+01, 9.1224732009E+00, 4.9134970807E+00, 8.6134102849E-01],
	[2.4725000000E+04, 4.1614206753E+01, 1.4313408419E+01, 9.1284239986E+00, 4.9153877095E+00, 8.6140661737E-01],
	[2.4730000000E+04, 4.1627431216E+01, 1.4313240985E+01, 9.1343774715E+00, 4.9172782255E+00, 8.6147217683E-01],
	[2.4735000000E+04, 4.1640657206E+01, 1.4313073588E+01, 9.1403336205E+00, 4.9191686285E+00, 8.6153770685E-01],
	[2.4740000000E+04, 4.1653884725E+01, 1.4312906227E+01, 9.1462924460E+00, 4.9210589180E+00, 8.6160320746E-01],
	[2.4745000000E+04, 4.1667113771E+01, 1.4312738901E+01, 9.1522539488E+00, 4.9229490938E+00, 8.6166867866E-01],
	[2.4750000000E+04, 4.1680344344E+01, 1.4312571611E+01, 9.1582181295E+00, 4.9248391556E+00, 8.6173412047E-01],
	[2.4755000000E+04, 4.1693576444E+01, 1.4312404357E+01, 9.1641849888E+00, 4.9267291031E+00, 8.6179953288E-01],
	[2.4760000000E+04, 4.1706810072E+01, 1.4312237139E+01, 9.1701545274E+00, 4.9286189359E+00, 8.6186491591E-01],
	[2.4765000000E+04, 4.1720045227E+01, 1.4312069956E+01, 9.1761267459E+00, 4.9305086538E+00, 8.6193026958E-01],
	[2.4770000000E+04, 4.1733281908E+01, 1.4311902809E+01, 9.1821016449E+00, 4.9323982564E+00, 8.6199559388E-01],
	[2.4775000000E+04, 4.1746520117E+01, 1.4311735698E+01, 9.1880792252E+00, 4.9342877434E+00, 8.6206088883E-01],
	[2.4780000000E+04, 4.1759759851E+01, 1.4311568622E+01, 9.1940594874E+00, 4.9361771145E+00, 8.6212615444E-01],
	[2.4785000000E+04, 4.1773001113E+01, 1.4311401582E+01, 9.2000424322E+00, 4.9380663695E+00, 8.6219139071E-01],
	[2.4790000000E+04, 4.1786243900E+01, 1.4311234578E+01, 9.2060280601E+00, 4.9399555079E+00, 8.6225659766E-01],
	[2.4795000000E+04, 4.1799488214E+01, 1.4311067609E+01, 9.2120163720E+00, 4.9418445295E+00, 8.6232177529E-01],
	[2.4800000000E+04, 4.1812734054E+01, 1.4310900676E+01, 9.2180073683E+00, 4.9437334340E+00, 8.6238692362E-01],
	[2.4805000000E+04, 4.1825981420E+01, 1.4310733778E+01, 9.2240010499E+00, 4.9456222211E+00, 8.6245204266E-01],
	[2.4810000000E+04, 4.1839230312E+01, 1.4310566916E+01, 9.2299974173E+00, 4.9475108904E+00, 8.6251713240E-01],
	[2.4815000000E+04, 4.1852480729E+01, 1.4310400090E+01, 9.2359964713E+00, 4.9493994417E+00, 8.6258219287E-01],
	[2.4820000000E+04, 4.1865732672E+01, 1.4310233299E+01, 9.2419982124E+00, 4.9512878746E+00, 8.6264722408E-01],
	[2.4825000000E+04, 4.1878986141E+01, 1.4310066544E+01, 9.2480026413E+00, 4.9531761889E+00, 8.6271222602E-01],
	[2.4830000000E+04, 4.1892241134E+01, 1.4309899824E+01, 9.2540097588E+00, 4.9550643842E+00, 8.6277719872E-01],
	[2.4835000000E+04, 4.1905497653E+01, 1.4309733140E+01, 9.2600195654E+00, 4.9569524602E+00, 8.6284214217E-01],
	[2.4840000000E+04, 4.1918755697E+01, 1.4309566491E+01, 9.2660320618E+00, 4.9588404166E+00, 8.6290705640E-01],
	[2.4845000000E+04, 4.1932015266E+01, 1.4309399878E+01, 9.2720472488E+00, 4.9607282532E+00, 8.6297194140E-01],
	[2.4850000000E+04, 4.1945276359E+01, 1.4309233300E+01, 9.2780651268E+00, 4.9626159695E+00, 8.6303679720E-01],
	[2.4855000000E+04, 4.1958538977E+01, 1.4309066758E+01, 9.2840856967E+00, 4.9645035654E+00, 8.6310162379E-01],
	[2.4860000000E+04, 4.1971803120E+01, 1.4308900251E+01, 9.2901089590E+00, 4.9663910404E+00, 8.6316642119E-01],
	[2.4865000000E+04, 4.1985068787E+01, 1.4308733779E+01, 9.2961349145E+00, 4.9682783944E+00, 8.6323118940E-01],
	[2.4870000000E+04, 4.1998335978E+01, 1.4308567343E+01, 9.3021635637E+00, 4.9701656269E+00, 8.6329592845E-01],
	[2.4875000000E+04, 4.2011604693E+01, 1.4308400943E+01, 9.3081949074E+00, 4.9720527377E+00, 8.6336063833E-01],
	[2.4880000000E+04, 4.2024874932E+01, 1.4308234577E+01, 9.3142289461E+00, 4.9739397264E+00, 8.6342531905E-01],
	[2.4885000000E+04, 4.2038146695E+01, 1.4308068248E+01, 9.3202656807E+00, 4.9758265928E+00, 8.6348997063E-01],
	[2.4890000000E+04, 4.2051419982E+01, 1.4307901953E+01, 9.3263051117E+00, 4.9777133366E+00, 8.6355459308E-01],
	[2.4895000000E+04, 4.2064694792E+01, 1.4307735694E+01, 9.3323472397E+00, 4.9795999575E+00, 8.6361918639E-01],
	[2.4900000000E+04, 4.2077971126E+01, 1.4307569470E+01, 9.3383920656E+00, 4.9814864551E+00, 8.6368375060E-01],
	[2.4905000000E+04, 4.2091248983E+01, 1.4307403281E+01, 9.3444395898E+00, 4.9833728291E+00, 8.6374828569E-01],
	[2.4910000000E+04, 4.2104528364E+01, 1.4307237128E+01, 9.3504898131E+00, 4.9852590793E+00, 8.6381279169E-01],
	[2.4915000000E+04, 4.2117809267E+01, 1.4307071010E+01, 9.3565427361E+00, 4.9871452053E+00, 8.6387726860E-01],
	[2.4920000000E+04, 4.2131091693E+01, 1.4306904927E+01, 9.3625983595E+00, 4.9890312069E+00, 8.6394171643E-01],
	[2.4925000000E+04, 4.2144375642E+01, 1.4306738879E+01, 9.3686566840E+00, 4.9909170837E+00, 8.6400613520E-01],
	[2.4930000000E+04, 4.2157661114E+01, 1.4306572867E+01, 9.3747177102E+00, 4.9928028355E+00, 8.6407052490E-01],
	[2.4935000000E+04, 4.2170948108E+01, 1.4306406890E+01, 9.3807814388E+00, 4.9946884618E+00, 8.6413488556E-01],
	[2.4940000000E+04, 4.2184236625E+01, 1.4306240948E+01, 9.3868478704E+00, 4.9965739625E+00, 8.6419921717E-01],
	[2.4945000000E+04, 4.2197526664E+01, 1.4306075041E+01, 9.3929170057E+00, 4.9984593372E+00, 8.6426351976E-01],
	[2.4950000000E+04, 4.2210818225E+01, 1.4305909170E+01, 9.3989888454E+00, 5.0003445857E+00, 8.6432779332E-01],
	[2.4955000000E+04, 4.2224111308E+01, 1.4305743334E+01, 9.4050633901E+00, 5.0022297075E+00, 8.6439203788E-01],
	[2.4960000000E+04, 4.2237405913E+01, 1.4305577532E+01, 9.4111406405E+00, 5.0041147025E+00, 8.6445625343E-01],
	[2.4965000000E+04, 4.2250702039E+01, 1.4305411766E+01, 9.4172205972E+00, 5.0059995703E+00, 8.6452044004E-01],
	[2.4970000000E+04, 4.2263999687E+01, 1.4305246035E+01, 9.4233032610E+00, 5.0078843106E+00, 8.6458459779E-01],
	[2.4975000000E+04, 4.2277298857E+01, 1.4305080339E+01, 9.4293886324E+00, 5.0097689231E+00, 8.6464872669E-01],
	[2.4980000000E+04, 4.2290599548E+01, 1.4304914679E+01, 9.4354767121E+00, 5.0116534076E+00, 8.6471282675E-01],
	[2.4985000000E+04, 4.2303901760E+01, 1.4304749053E+01, 9.4415675008E+00, 5.0135377636E+00, 8.6477689797E-01],
	[2.4990000000E+04, 4.2317205494E+01, 1.4304583462E+01, 9.4476609992E+00, 5.0154219910E+00, 8.6484094037E-01],
	[2.4995000000E+04, 4.2330510748E+01, 1.4304417907E+01, 9.4537572079E+00, 5.0173060893E+00, 8.6490495396E-01],
	[2.5000000000E+04, 4.2343817523E+01, 1.4304252386E+01, 9.4598561275E+00, 5.0191900584E+00, 8.6496893875E-01],
	[2.5005000000E+04, 4.2357125819E+01, 1.4304086901E+01, 9.4659721311E+00, 5.0210779417E+00, 8.6503289473E-01],
	[2.5010000000E+04, 4.2370435636E+01, 1.4303921450E+01, 9.4720908630E+00, 5.0229656953E+00, 8.6509682193E-01],
	[2.5015000000E+04, 4.2383746973E+01, 1.4303756034E+01, 9.4782123239E+00, 5.0248533188E+00, 8.6516072035E-01],
	[2.5020000000E+04, 4.2397059830E+01, 1.4303590654E+01, 9.4843365145E+00, 5.0267408120E+00, 8.6522459001E-01],
	[2.5025000000E+04, 4.2410374207E+01, 1.4303425308E+01, 9.4904634356E+00, 5.0286281745E+00, 8.6528843090E-01],
	[2.5030000000E+04, 4.2423690104E+01, 1.4303259998E+01, 9.4965930876E+00, 5.0305154061E+00, 8.6535224304E-01],
	[2.5035000000E+04, 4.2437007522E+01, 1.4303094722E+01, 9.5027254714E+00, 5.0324025065E+00, 8.6541602644E-01],
	[2.5040000000E+04, 4.2450326459E+01, 1.4302929481E+01, 9.5088605876E+00, 5.0342894753E+00, 8.6547978110E-01],
	[2.5045000000E+04, 4.2463646916E+01, 1.4302764275E+01, 9.5149984369E+00, 5.0361763123E+00, 8.6554350704E-01],
	[2.5050000000E+04, 4.2476968892E+01, 1.4302599104E+01, 9.5211390198E+00, 5.0380630172E+00, 8.6560720427E-01],
	[2.5055000000E+04, 4.2490292388E+01, 1.4302433968E+01, 9.5272823372E+00, 5.0399495896E+00, 8.6567087279E-01],
	[2.5060000000E+04, 4.2503617402E+01, 1.4302268866E+01, 9.5334283896E+00, 5.0418360293E+00, 8.6573451261E-01],
	[2.5065000000E+04, 4.2516943937E+01, 1.4302103800E+01, 9.5395771778E+00, 5.0437223359E+00, 8.6579812375E-01],
	[2.5070000000E+04, 4.2530271990E+01, 1.4301938768E+01, 9.5457287024E+00, 5.0456085092E+00, 8.6586170620E-01],
	[2.5075000000E+04, 4.2543601562E+01, 1.4301773771E+01, 9.5518829641E+00, 5.0474945489E+00, 8.6592525999E-01],
	[2.5080000000E+04, 4.2556932652E+01, 1.4301608809E+01, 9.5580399635E+00, 5.0493804546E+00, 8.6598878512E-01],
	[2.5085000000E+04, 4.2570265262E+01, 1.4301443882E+01, 9.5641997014E+00, 5.0512662261E+00, 8.6605228159E-01],
	[2.5090000000E+04, 4.2583607931E+01, 1.4301280496E+01, 9.5703621783E+00, 5.0531521714E+00, 8.6611574942E-01],
	[2.5095000000E+04, 4.2597004262E+01, 1.4301126334E+01, 9.5765273950E+00, 5.0550398646E+00, 8.6617918862E-01],
	[2.5100000000E+04, 4.2610402137E+01, 1.4300972204E+01, 9.5826953522E+00, 5.0569274251E+00, 8.6624259920E-01],
	[2.5105000000E+04, 4.2623801556E+01, 1.4300818107E+01, 9.5888660504E+00, 5.0588148524E+00, 8.6630598116E-01],
	[2.5110000000E+04, 4.2637202520E+01, 1.4300664042E+01, 9.5950394905E+00, 5.0607021464E+00, 8.6636933452E-01],
	[2.5115000000E+04, 4.2650605027E+01, 1.4300510009E+01, 9.6012156729E+00, 5.0625893067E+00, 8.6643265928E-01],
	[2.5120000000E+04, 4.2664009078E+01, 1.4300356009E+01, 9.6073945985E+00, 5.0644763330E+00, 8.6649595545E-01],
	[2.5125000000E+04, 4.2677414672E+01, 1.4300202041E+01, 9.6135762679E+00, 5.0663632250E+00, 8.6655922304E-01],
	[2.5130000000E+04, 4.2690821810E+01, 1.4300048105E+01, 9.6197606818E+00, 5.0682499824E+00, 8.6662246207E-01],
	[2.5135000000E+04, 4.2704230491E+01, 1.4299894202E+01, 9.6259478407E+00, 5.0701366049E+00, 8.6668567253E-01],
	[2.5140000000E+04, 4.2717640716E+01, 1.4299740331E+01, 9.6321377455E+00, 5.0720230923E+00, 8.6674885445E-01],
	[2.5145000000E+04, 4.2731052483E+01, 1.4299586492E+01, 9.6383303967E+00, 5.0739094442E+00, 8.6681200782E-01],
	[2.5150000000E+04, 4.2744465793E+01, 1.4299432685E+01, 9.6445257951E+00, 5.0757956603E+00, 8.6687513266E-01],
	[2.5155000000E+04, 4.2757880647E+01, 1.4299278911E+01, 9.6507239413E+00, 5.0776817404E+00, 8.6693822898E-01],
	[2.5160000000E+04, 4.2771297042E+01, 1.4299125169E+01, 9.6569248360E+00, 5.0795676841E+00, 8.6700129679E-01],
	[2.5165000000E+04, 4.2784714981E+01, 1.4298971459E+01, 9.6631284799E+00, 5.0814534912E+00, 8.6706433609E-01],
	[2.5170000000E+04, 4.2798134461E+01, 1.4298817781E+01, 9.6693348735E+00, 5.0833391613E+00, 8.6712734689E-01],
	[2.5175000000E+04, 4.2811555485E+01, 1.4298664135E+01, 9.6755440177E+00, 5.0852246942E+00, 8.6719032922E-01],
	[2.5180000000E+04, 4.2824978050E+01, 1.4298510522E+01, 9.6817559130E+00, 5.0871100895E+00, 8.6725328306E-01],
	[2.5185000000E+04, 4.2838402157E+01, 1.4298356941E+01, 9.6879705602E+00, 5.0889953470E+00, 8.6731620844E-01],
	[2.5190000000E+04, 4.2851827806E+01, 1.4298203391E+01, 9.6941879599E+00, 5.0908804664E+00, 8.6737910536E-01],
	[2.5195000000E+04, 4.2865254997E+01, 1.4298049874E+01, 9.7004081128E+00, 5.0927654474E+00, 8.6744197383E-01],
	[2.5200000000E+04, 4.2878683729E+01, 1.4297896390E+01, 9.7066310195E+00, 5.0946502896E+00, 8.6750481386E-01],
	[2.5205000000E+04, 4.2892114003E+01, 1.4297742937E+01, 9.7128566808E+00, 5.0965349929E+00, 8.6756762546E-01],
	[2.5210000000E+04, 4.2905545819E+01, 1.4297589516E+01, 9.7190850972E+00, 5.0984195568E+00, 8.6763040864E-01],
	[2.5215000000E+04, 4.2918979175E+01, 1.4297436127E+01, 9.7253162695E+00, 5.1003039812E+00, 8.6769316341E-01],
	[2.5220000000E+04, 4.2932414073E+01, 1.4297282771E+01, 9.7315501984E+00, 5.1021882657E+00, 8.6775588978E-01],
	[2.5225000000E+04, 4.2945850512E+01, 1.4297129446E+01, 9.7377868845E+00, 5.1040724100E+00, 8.6781858775E-01],
	[2.5230000000E+04, 4.2959288492E+01, 1.4296976154E+01, 9.7440263284E+00, 5.1059564139E+00, 8.6788125734E-01],
	[2.5235000000E+04, 4.2972728012E+01, 1.4296822893E+01, 9.7502685309E+00, 5.1078402770E+00, 8.6794389856E-01],
	[2.5240000000E+04, 4.2986169073E+01, 1.4296669665E+01, 9.7565134926E+00, 5.1097239990E+00, 8.6800651142E-01],
	[2.5245000000E+04, 4.2999611674E+01, 1.4296516468E+01, 9.7627612143E+00, 5.1116075797E+00, 8.6806909591E-01],
	[2.5250000000E+04, 4.3013055816E+01, 1.4296363304E+01, 9.7690116965E+00, 5.1134910188E+00, 8.6813165207E-01],
	[2.5255000000E+04, 4.3026501498E+01, 1.4296210171E+01, 9.7752649399E+00, 5.1153743159E+00, 8.6819417988E-01],
	[2.5260000000E+04, 4.3039948720E+01, 1.4296057070E+01, 9.7815209453E+00, 5.1172574709E+00, 8.6825667937E-01],
	[2.5265000000E+04, 4.3053397482E+01, 1.4295904002E+01, 9.7877797132E+00, 5.1191404833E+00, 8.6831915055E-01],
	[2.5270000000E+04, 4.3066847784E+01, 1.4295750965E+01, 9.7940412444E+00, 5.1210233529E+00, 8.6838159341E-01],
	[2.5275000000E+04, 4.3080299625E+01, 1.4295597960E+01, 9.8003055395E+00, 5.1229060795E+00, 8.6844400798E-01],
	[2.5280000000E+04, 4.3093753007E+01, 1.4295444987E+01, 9.8065725992E+00, 5.1247886627E+00, 8.6850639425E-01],
	[2.5285000000E+04, 4.3107207927E+01, 1.4295292046E+01, 9.8128424242E+00, 5.1266711022E+00, 8.6856875225E-01],
	[2.5290000000E+04, 4.3120664387E+01, 1.4295139137E+01, 9.8191150151E+00, 5.1285533977E+00, 8.6863108197E-01],
	[2.5295000000E+04, 4.3134122386E+01, 1.4294986260E+01, 9.8253903726E+00, 5.1304355490E+00, 8.6869338344E-01],
	[2.5300000000E+04, 4.3147581924E+01, 1.4294833414E+01, 9.8316684974E+00, 5.1323175558E+00, 8.6875565665E-01],
	[2.5305000000E+04, 4.3161043001E+01, 1.4294680601E+01, 9.8379493902E+00, 5.1341994178E+00, 8.6881790162E-01],
	[2.5310000000E+04, 4.3174505617E+01, 1.4294527819E+01, 9.8442330516E+00, 5.1360811346E+00, 8.6888011836E-01],
	[2.5315000000E+04, 4.3187969772E+01, 1.4294375069E+01, 9.8505194823E+00, 5.1379627061E+00, 8.6894230688E-01],
	[2.5320000000E+04, 4.3201435465E+01, 1.4294222351E+01, 9.8568086830E+00, 5.1398441318E+00, 8.6900446718E-01],
	[2.5325000000E+04, 4.3214902697E+01, 1.4294069664E+01, 9.8631006543E+00, 5.1417254116E+00, 8.6906659928E-01],
	[2.5330000000E+04, 4.3228371466E+01, 1.4293917010E+01, 9.8693953970E+00, 5.1436065452E+00, 8.6912870319E-01],
	[2.5335000000E+04, 4.3241841774E+01, 1.4293764387E+01, 9.8756929116E+00, 5.1454875321E+00, 8.6919077891E-01],
	[2.5340000000E+04, 4.3255313620E+01, 1.4293611796E+01, 9.8819931989E+00, 5.1473683723E+00, 8.6925282645E-01],
	[2.5345000000E+04, 4.3268787004E+01, 1.4293459236E+01, 9.8882962595E+00, 5.1492490653E+00, 8.6931484583E-01],
	[2.5350000000E+04, 4.3282261926E+01, 1.4293306709E+01, 9.8946020942E+00, 5.1511296109E+00, 8.6937683705E-01],
	[2.5355000000E+04, 4.3295738386E+01, 1.4293154213E+01, 9.9009107035E+00, 5.1530100088E+00, 8.6943880012E-01],
	[2.5360000000E+04, 4.3309216382E+01, 1.4293001748E+01, 9.9072220882E+00, 5.1548902587E+00, 8.6950073506E-01],
	[2.5365000000E+04, 4.3322695917E+01, 1.4292849316E+01, 9.9135362488E+00, 5.1567703604E+00, 8.6956264187E-01],
	[2.5370000000E+04, 4.3336176988E+01, 1.4292696915E+01, 9.9198531862E+00, 5.1586503135E+00, 8.6962452056E-01],
	[2.5375000000E+04, 4.3349659597E+01, 1.4292544546E+01, 9.9261729010E+00, 5.1605301177E+00, 8.6968637114E-01],
	[2.5380000000E+04, 4.3363143743E+01, 1.4292392208E+01, 9.9324953937E+00, 5.1624097729E+00, 8.6974819363E-01],
	[2.5385000000E+04, 4.3376629425E+01, 1.4292239902E+01, 9.9388206652E+00, 5.1642892786E+00, 8.6980998802E-01],
	[2.5390000000E+04, 4.3390116645E+01, 1.4292087628E+01, 9.9451487161E+00, 5.1661686346E+00, 8.6987175434E-01],
	[2.5395000000E+04, 4.3403605401E+01, 1.4291935385E+01, 9.9514795470E+00, 5.1680478407E+00, 8.6993349258E-01],
	[2.5400000000E+04, 4.3417095693E+01, 1.4291783174E+01, 9.9578131587E+00, 5.1699268964E+00, 8.6999520276E-01],
	[2.5405000000E+04, 4.3430587522E+01, 1.4291630994E+01, 9.9641495518E+00, 5.1718058016E+00, 8.7005688490E-01],
	[2.5410000000E+04, 4.3444080887E+01, 1.4291478846E+01, 9.9704887269E+00, 5.1736845560E+00, 8.7011853899E-01],
	[2.5415000000E+04, 4.3457575789E+01, 1.4291326730E+01, 9.9768306848E+00, 5.1755631593E+00, 8.7018016504E-01],
	[2.5420000000E+04, 4.3471072226E+01, 1.4291174645E+01, 9.9831754261E+00, 5.1774416111E+00, 8.7024176308E-01],
	[2.5425000000E+04, 4.3484570199E+01, 1.4291022592E+01, 9.9895229515E+00, 5.1793199113E+00, 8.7030333310E-01],
	[2.5430000000E+04, 4.3498069708E+01, 1.4290870570E+01, 9.9958732616E+00, 5.1811980595E+00, 8.7036487513E-01],
	[2.5435000000E+04, 4.3511570752E+01, 1.4290718580E+01, 1.0002226357E+01, 5.1830760555E+00, 8.7042638915E-01],
	[2.5440000000E+04, 4.3525073332E+01, 1.4290566621E+01, 1.0008582239E+01, 5.1849538989E+00, 8.7048787520E-01],
	[2.5445000000E+04, 4.3538577448E+01, 1.4290414693E+01, 1.0014940907E+01, 5.1868315895E+00, 8.7054933327E-01],
	[2.5450000000E+04, 4.3552083098E+01, 1.4290262797E+01, 1.0021302363E+01, 5.1887091270E+00, 8.7061076337E-01],
	[2.5455000000E+04, 4.3565590284E+01, 1.4290110933E+01, 1.0027666607E+01, 5.1905865111E+00, 8.7067216552E-01],
	[2.5460000000E+04, 4.3579099005E+01, 1.4289959100E+01, 1.0034033640E+01, 5.1924637415E+00, 8.7073353973E-01],
	[2.5465000000E+04, 4.3592609260E+01, 1.4289807298E+01, 1.0040403463E+01, 5.1943408180E+00, 8.7079488600E-01],
	[2.5470000000E+04, 4.3606121050E+01, 1.4289655528E+01, 1.0046776075E+01, 5.1962177403E+00, 8.7085620435E-01],
	[2.5475000000E+04, 4.3619634375E+01, 1.4289503789E+01, 1.0053151478E+01, 5.1980945080E+00, 8.7091749478E-01],
	[2.5480000000E+04, 4.3633149234E+01, 1.4289352082E+01, 1.0059529673E+01, 5.1999711210E+00, 8.7097875730E-01],
	[2.5485000000E+04, 4.3646665628E+01, 1.4289200406E+01, 1.0065910660E+01, 5.2018475789E+00, 8.7103999193E-01],
	[2.5490000000E+04, 4.3660183556E+01, 1.4289048761E+01, 1.0072294440E+01, 5.2037238814E+00, 8.7110119867E-01],
	[2.5495000000E+04, 4.3673724818E+01, 1.4288900932E+01, 1.0078681013E+01, 5.2056008403E+00, 8.7116237753E-01],
	[2.5500000000E+04, 4.3687306373E+01, 1.4288759859E+01, 1.0085070381E+01, 5.2074790878E+00, 8.7122352852E-01],
	[2.5505000000E+04, 4.3700889488E+01, 1.4288618814E+01, 1.0091462543E+01, 5.2093571815E+00, 8.7128465166E-01],
	[2.5510000000E+04, 4.3714474162E+01, 1.4288477798E+01, 1.0097857501E+01, 5.2112351210E+00, 8.7134574695E-01],
	[2.5515000000E+04, 4.3728060395E+01, 1.4288336812E+01, 1.0104255255E+01, 5.2131129060E+00, 8.7140681440E-01],
	[2.5520000000E+04, 4.3741648188E+01, 1.4288195854E+01, 1.0110655806E+01, 5.2149905363E+00, 8.7146785403E-01],
	[2.5525000000E+04, 4.3755237540E+01, 1.4288054925E+01, 1.0117059155E+01, 5.2168680117E+00, 8.7152886583E-01],
	[2.5530000000E+04, 4.3768828450E+01, 1.4287914026E+01, 1.0123465301E+01, 5.2187453317E+00, 8.7158984983E-01],
	[2.5535000000E+04, 4.3782420920E+01, 1.4287773155E+01, 1.0129874247E+01, 5.2206224961E+00, 8.7165080603E-01],
	[2.5540000000E+04, 4.3796014948E+01, 1.4287632314E+01, 1.0136285992E+01, 5.2224995048E+00, 8.7171173444E-01],
	[2.5545000000E+04, 4.3809610534E+01, 1.4287491501E+01, 1.0142700537E+01, 5.2243763573E+00, 8.7177263507E-01],
	[2.5550000000E+04, 4.3823207679E+01, 1.4287350717E+01, 1.0149117884E+01, 5.2262530534E+00, 8.7183350793E-01],
	[2.5555000000E+04, 4.3836806382E+01, 1.4287209962E+01, 1.0155538032E+01, 5.2281295928E+00, 8.7189435303E-01],
	[2.5560000000E+04, 4.3850406643E+01, 1.4287069236E+01, 1.0161960982E+01, 5.2300059753E+00, 8.7195517038E-01],
	[2.5565000000E+04, 4.3864008463E+01, 1.4286928539E+01, 1.0168386735E+01, 5.2318822005E+00, 8.7201595999E-01],
	[2.5570000000E+04, 4.3877611840E+01, 1.4286787871E+01, 1.0174815292E+01, 5.2337582682E+00, 8.7207672186E-01],
	[2.5575000000E+04, 4.3891216775E+01, 1.4286647232E+01, 1.0181246653E+01, 5.2356341782E+00, 8.7213745602E-01],
	[2.5580000000E+04, 4.3904823267E+01, 1.4286506622E+01, 1.0187680819E+01, 5.2375099301E+00, 8.7219816247E-01],
	[2.5585000000E+04, 4.3918431317E+01, 1.4286366040E+01, 1.0194117790E+01, 5.2393855236E+00, 8.7225884122E-01],
	[2.5590000000E+04, 4.3932040925E+01, 1.4286225488E+01, 1.0200557568E+01, 5.2412609585E+00, 8.7231949227E-01],
	[2.5595000000E+04, 4.3945652089E+01, 1.4286084964E+01, 1.0207000153E+01, 5.2431362346E+00, 8.7238011565E-01],
	[2.5600000000E+04, 4.3959264811E+01, 1.4285944469E+01, 1.0213445546E+01, 5.2450113514E+00, 8.7244071135E-01],
	[2.5605000000E+04, 4.3972879090E+01, 1.4285804003E+01, 1.0219893747E+01, 5.2468863089E+00, 8.7250127939E-01],
	[2.5610000000E+04, 4.3986494926E+01, 1.4285663566E+01, 1.0226344757E+01, 5.2487611066E+00, 8.7256181979E-01],
	[2.5615000000E+04, 4.4000112318E+01, 1.4285523157E+01, 1.0232798576E+01, 5.2506357443E+00, 8.7262233253E-01],
	[2.5620000000E+04, 4.4013731267E+01, 1.4285382778E+01, 1.0239255206E+01, 5.2525102217E+00, 8.7268281765E-01],
	[2.5625000000E+04, 4.4027351773E+01, 1.4285242427E+01, 1.0245714647E+01, 5.2543845386E+00, 8.7274327515E-01],
	[2.5630000000E+04, 4.4040973835E+01, 1.4285102104E+01, 1.0252176899E+01, 5.2562586947E+00, 8.7280370503E-01],
	[2.5635000000E+04, 4.4054597453E+01, 1.4284961811E+01, 1.0258641964E+01, 5.2581326897E+00, 8.7286410731E-01],
	[2.5640000000E+04, 4.4068222627E+01, 1.4284821546E+01, 1.0265109842E+01, 5.2600065233E+00, 8.7292448200E-01],
	[2.5645000000E+04, 4.4081849358E+01, 1.4284681310E+01, 1.0271580534E+01, 5.2618801953E+00, 8.7298482910E-01],
	[2.5650000000E+04, 4.4095477644E+01, 1.4284541103E+01, 1.0278054040E+01, 5.2637537054E+00, 8.7304514864E-01],
	[2.5655000000E+04, 4.4109107486E+01, 1.4284400925E+01, 1.0284530361E+01, 5.2656270533E+00, 8.7310544061E-01],
	[2.5660000000E+04, 4.4122738883E+01, 1.4284260775E+01, 1.0291009498E+01, 5.2675002387E+00, 8.7316570503E-01],
	[2.5665000000E+04, 4.4136371836E+01, 1.4284120654E+01, 1.0297491452E+01, 5.2693732614E+00, 8.7322594190E-01],
	[2.5670000000E+04, 4.4150006345E+01, 1.4283980561E+01, 1.0303976222E+01, 5.2712461211E+00, 8.7328615125E-01],
	[2.5675000000E+04, 4.4163642408E+01, 1.4283840497E+01, 1.0310463810E+01, 5.2731188175E+00, 8.7334633307E-01],
	[2.5680000000E+04, 4.4177280027E+01, 1.4283700462E+01, 1.0316954217E+01, 5.2749913504E+00, 8.7340648737E-01],
	[2.5685000000E+04, 4.4190919201E+01, 1.4283560455E+01, 1.0323447442E+01, 5.2768637195E+00, 8.7346661418E-01],
	[2.5690000000E+04, 4.4204559929E+01, 1.4283420478E+01, 1.0329943488E+01, 5.2787359244E+00, 8.7352671349E-01],
	[2.5695000000E+04, 4.4218202213E+01, 1.4283280528E+01, 1.0336442354E+01, 5.2806079650E+00, 8.7358678532E-01],
	[2.5700000000E+04, 4.4231846051E+01, 1.4283140607E+01, 1.0342944041E+01, 5.2824798409E+00, 8.7364682967E-01],
	[2.5705000000E+04, 4.4245491443E+01, 1.4283000715E+01, 1.0349448550E+01, 5.2843515520E+00, 8.7370684656E-01],
	[2.5710000000E+04, 4.4259138390E+01, 1.4282860852E+01, 1.0355955881E+01, 5.2862230978E+00, 8.7376683600E-01],
	[2.5715000000E+04, 4.4272786891E+01, 1.4282721017E+01, 1.0362466035E+01, 5.2880944782E+00, 8.7382679800E-01],
	[2.5720000000E+04, 4.4286436946E+01, 1.4282581210E+01, 1.0368979014E+01, 5.2899656929E+00, 8.7388673256E-01],
	[2.5725000000E+04, 4.4300088555E+01, 1.4282441432E+01, 1.0375494817E+01, 5.2918367416E+00, 8.7394663970E-01],
	[2.5730000000E+04, 4.4313741719E+01, 1.4282301683E+01, 1.0382013445E+01, 5.2937076240E+00, 8.7400651943E-01],
	[2.5735000000E+04, 4.4327396435E+01, 1.4282161962E+01, 1.0388534898E+01, 5.2955783400E+00, 8.7406637175E-01],
	[2.5740000000E+04, 4.4341052706E+01, 1.4282022270E+01, 1.0395059179E+01, 5.2974488891E+00, 8.7412619668E-01],
	[2.5745000000E+04, 4.4354710530E+01, 1.4281882606E+01, 1.0401586286E+01, 5.2993192711E+00, 8.7418599423E-01],
	[2.5750000000E+04, 4.4368369907E+01, 1.4281742971E+01, 1.0408116222E+01, 5.3011894858E+00, 8.7424576440E-01],
	[2.5755000000E+04, 4.4382030837E+01, 1.4281603364E+01, 1.0414648986E+01, 5.3030595329E+00, 8.7430550722E-01],
	[2.5760000000E+04, 4.4395693321E+01, 1.4281463786E+01, 1.0421184579E+01, 5.3049294121E+00, 8.7436522267E-01],
	[2.5765000000E+04, 4.4409357357E+01, 1.4281324236E+01, 1.0427723002E+01, 5.3067991231E+00, 8.7442491079E-01],
	[2.5770000000E+04, 4.4423022947E+01, 1.4281184714E+01, 1.0434264256E+01, 5.3086686658E+00, 8.7448457157E-01],
	[2.5775000000E+04, 4.4436690089E+01, 1.4281045221E+01, 1.0440808341E+01, 5.3105380398E+00, 8.7454420503E-01],
	[2.5780000000E+04, 4.4450358784E+01, 1.4280905756E+01, 1.0447355257E+01, 5.3124072448E+00, 8.7460381118E-01],
	[2.5785000000E+04, 4.4464029031E+01, 1.4280766320E+01, 1.0453905007E+01, 5.3142762806E+00, 8.7466339002E-01],
	[2.5790000000E+04, 4.4477700831E+01, 1.4280626912E+01, 1.0460457590E+01, 5.3161451469E+00, 8.7472294157E-01],
	[2.5795000000E+04, 4.4491374182E+01, 1.4280487533E+01, 1.0467013006E+01, 5.3180138435E+00, 8.7478246584E-01],
	[2.5800000000E+04, 4.4505049086E+01, 1.4280348182E+01, 1.0473571257E+01, 5.3198823700E+00, 8.7484196283E-01],
	[2.5805000000E+04, 4.4518725542E+01, 1.4280208859E+01, 1.0480132344E+01, 5.3217507263E+00, 8.7490143257E-01],
	[2.5810000000E+04, 4.4532403550E+01, 1.4280069565E+01, 1.0486696266E+01, 5.3236189120E+00, 8.7496087505E-01],
	[2.5815000000E+04, 4.4546083110E+01, 1.4279930299E+01, 1.0493263026E+01, 5.3254869268E+00, 8.7502029029E-01],
	[2.5820000000E+04, 4.4559764221E+01, 1.4279791061E+01, 1.0499832622E+01, 5.3273547706E+00, 8.7507967829E-01],
	[2.5825000000E+04, 4.4573446884E+01, 1.4279651851E+01, 1.0506405057E+01, 5.3292224431E+00, 8.7513903908E-01],
	[2.5830000000E+04, 4.4587131098E+01, 1.4279512670E+01, 1.0512980330E+01, 5.3310899439E+00, 8.7519837265E-01],
	[2.5835000000E+04, 4.4600816863E+01, 1.4279373518E+01, 1.0519558442E+01, 5.3329572729E+00, 8.7525767902E-01],
	[2.5840000000E+04, 4.4614504179E+01, 1.4279234393E+01, 1.0526139395E+01, 5.3348244297E+00, 8.7531695820E-01],
	[2.5845000000E+04, 4.4628193047E+01, 1.4279095297E+01, 1.0532723188E+01, 5.3366914141E+00, 8.7537621019E-01],
	[2.5850000000E+04, 4.4641883465E+01, 1.4278956229E+01, 1.0539309823E+01, 5.3385582258E+00, 8.7543543502E-01],
	[2.5855000000E+04, 4.4655575434E+01, 1.4278817189E+01, 1.0545899299E+01, 5.3404248646E+00, 8.7549463268E-01],
	[2.5860000000E+04, 4.4669268954E+01, 1.4278678178E+01, 1.0552491618E+01, 5.3422913301E+00, 8.7555380319E-01],
	[2.5865000000E+04, 4.4682964024E+01, 1.4278539194E+01, 1.0559086781E+01, 5.3441576222E+00, 8.7561294656E-01],
	[2.5870000000E+04, 4.4696660644E+01, 1.4278400239E+01, 1.0565684788E+01, 5.3460237406E+00, 8.7567206280E-01],
	[2.5875000000E+04, 4.4710358815E+01, 1.4278261313E+01, 1.0572285640E+01, 5.3478896850E+00, 8.7573115192E-01],
	[2.5880000000E+04, 4.4724058536E+01, 1.4278122414E+01, 1.0578889336E+01, 5.3497554551E+00, 8.7579021393E-01],
	[2.5885000000E+04, 4.4737759807E+01, 1.4277983543E+01, 1.0585495880E+01, 5.3516210506E+00, 8.7584924883E-01],
	[2.5890000000E+04, 4.4751462628E+01, 1.4277844701E+01, 1.0592105269E+01, 5.3534864714E+00, 8.7590825665E-01],
	[2.5895000000E+04, 4.4765166998E+01, 1.4277705887E+01, 1.0598717507E+01, 5.3553517172E+00, 8.7596723739E-01],
	[2.5900000000E+04, 4.4778872918E+01, 1.4277567101E+01, 1.0605332592E+01, 5.3572167876E+00, 8.7602619105E-01],
	[2.5905000000E+04, 4.4792597213E+01, 1.4277431223E+01, 1.0611950526E+01, 5.3590823290E+00, 8.7608511766E-01],
	[2.5910000000E+04, 4.4806366571E+01, 1.4277302816E+01, 1.0618571310E+01, 5.3609493675E+00, 8.7614401721E-01],
	[2.5915000000E+04, 4.4820137503E+01, 1.4277174435E+01, 1.0625194944E+01, 5.3628162322E+00, 8.7620288973E-01],
	[2.5920000000E+04, 4.4833910011E+01, 1.4277046080E+01, 1.0631821428E+01, 5.3646829228E+00, 8.7626173522E-01],
	[2.5925000000E+04, 4.4847684092E+01, 1.4276917750E+01, 1.0638450764E+01, 5.3665494391E+00, 8.7632055369E-01],
	[2.5930000000E+04, 4.4861459748E+01, 1.4276789447E+01, 1.0645082953E+01, 5.3684157807E+00, 8.7637934514E-01],
	[2.5935000000E+04, 4.4875236978E+01, 1.4276661170E+01, 1.0651717994E+01, 5.3702819475E+00, 8.7643810960E-01],
	[2.5940000000E+04, 4.4889015781E+01, 1.4276532918E+01, 1.0658355889E+01, 5.3721479392E+00, 8.7649684707E-01],
	[2.5945000000E+04, 4.4902796159E+01, 1.4276404692E+01, 1.0664996637E+01, 5.3740137555E+00, 8.7655555757E-01],
	[2.5950000000E+04, 4.4916578111E+01, 1.4276276493E+01, 1.0671640241E+01, 5.3758793961E+00, 8.7661424109E-01],
	[2.5955000000E+04, 4.4930361636E+01, 1.4276148319E+01, 1.0678286701E+01, 5.3777448608E+00, 8.7667289766E-01],
	[2.5960000000E+04, 4.4944146734E+01, 1.4276020170E+01, 1.0684936016E+01, 5.3796101494E+00, 8.7673152728E-01],
	[2.5965000000E+04, 4.4957933406E+01, 1.4275892048E+01, 1.0691588188E+01, 5.3814752615E+00, 8.7679012996E-01],
	[2.5970000000E+04, 4.4971721651E+01, 1.4275763952E+01, 1.0698243219E+01, 5.3833401969E+00, 8.7684870571E-01],
	[2.5975000000E+04, 4.4985511470E+01, 1.4275635881E+01, 1.0704901107E+01, 5.3852049554E+00, 8.7690725454E-01],
	[2.5980000000E+04, 4.4999302861E+01, 1.4275507836E+01, 1.0711561854E+01, 5.3870695367E+00, 8.7696577647E-01],
	[2.5985000000E+04, 4.5013095825E+01, 1.4275379817E+01, 1.0718225461E+01, 5.3889339405E+00, 8.7702427151E-01],
	[2.5990000000E+04, 4.5026890362E+01, 1.4275251824E+01, 1.0724891928E+01, 5.3907981666E+00, 8.7708273965E-01],
	[2.5995000000E+04, 4.5040686472E+01, 1.4275123856E+01, 1.0731561256E+01, 5.3926622147E+00, 8.7714118092E-01],
	[2.6000000000E+04, 4.5054484154E+01, 1.4274995914E+01, 1.0738233446E+01, 5.3945260846E+00, 8.7719959533E-01],
	[2.6005000000E+04, 4.5068283409E+01, 1.4274867998E+01, 1.0744908498E+01, 5.3963897760E+00, 8.7725798287E-01],
	[2.6010000000E+04, 4.5082084236E+01, 1.4274740108E+01, 1.0751586413E+01, 5.3982532886E+00, 8.7731634358E-01],
	[2.6015000000E+04, 4.5095886635E+01, 1.4274612243E+01, 1.0758267191E+01, 5.4001166222E+00, 8.7737467744E-01],
	[2.6020000000E+04, 4.5109690606E+01, 1.4274484405E+01, 1.0764950834E+01, 5.4019797765E+00, 8.7743298449E-01],
	[2.6025000000E+04, 4.5123496148E+01, 1.4274356591E+01, 1.0771637342E+01, 5.4038427513E+00, 8.7749126472E-01],
	[2.6030000000E+04, 4.5137303263E+01, 1.4274228804E+01, 1.0778326716E+01, 5.4057055463E+00, 8.7754951814E-01],
	[2.6035000000E+04, 4.5151111949E+01, 1.4274101042E+01, 1.0785018956E+01, 5.4075681613E+00, 8.7760774477E-01],
	[2.6040000000E+04, 4.5164922207E+01, 1.4273973306E+01, 1.0791714063E+01, 5.4094305960E+00, 8.7766594461E-01],
	[2.6045000000E+04, 4.5178734037E+01, 1.4273845596E+01, 1.0798412038E+01, 5.4112928501E+00, 8.7772411769E-01],
	[2.6050000000E+04, 4.5192547437E+01, 1.4273717911E+01, 1.0805112881E+01, 5.4131549234E+00, 8.7778226400E-01],
	[2.6055000000E+04, 4.5206362409E+01, 1.4273590252E+01, 1.0811816594E+01, 5.4150168157E+00, 8.7784038355E-01],
	[2.6060000000E+04, 4.5220178952E+01, 1.4273462618E+01, 1.0818523176E+01, 5.4168785266E+00, 8.7789847637E-01],
	[2.6065000000E+04, 4.5233997065E+01, 1.4273335011E+01, 1.0825232628E+01, 5.4187400559E+00, 8.7795654245E-01],
	[2.6070000000E+04, 4.5247816750E+01, 1.4273207428E+01, 1.0831944952E+01, 5.4206014035E+00, 8.7801458181E-01],
	[2.6075000000E+04, 4.5261638005E+01, 1.4273079872E+01, 1.0838660147E+01, 5.4224625689E+00, 8.7807259444E-01],
	[2.6080000000E+04, 4.5275460830E+01, 1.4272952341E+01, 1.0845378215E+01, 5.4243235520E+00, 8.7813058032E-01],
	[2.6085000000E+04, 4.5289285227E+01, 1.4272824835E+01, 1.0852099156E+01, 5.4261843525E+00, 8.7818853948E-01],
	[2.6090000000E+04, 4.5303111193E+01, 1.4272697355E+01, 1.0858822970E+01, 5.4280449701E+00, 8.7824647190E-01],
	[2.6095000000E+04, 4.5316938730E+01, 1.4272569901E+01, 1.0865549660E+01, 5.4299054046E+00, 8.7830437761E-01],
	[2.6100000000E+04, 4.5330767836E+01, 1.4272442472E+01, 1.0872279224E+01, 5.4317656558E+00, 8.7836225661E-01],
	[2.6105000000E+04, 4.5344598513E+01, 1.4272315069E+01, 1.0879011664E+01, 5.4336257234E+00, 8.7842010890E-01],
	[2.6110000000E+04, 4.5358430759E+01, 1.4272187691E+01, 1.0885746981E+01, 5.4354856071E+00, 8.7847793451E-01],
	[2.6115000000E+04, 4.5372264575E+01, 1.4272060339E+01, 1.0892485175E+01, 5.4373453066E+00, 8.7853573343E-01],
	[2.6120000000E+04, 4.5386099961E+01, 1.4271933013E+01, 1.0899226247E+01, 5.4392048218E+00, 8.7859350568E-01],
	[2.6125000000E+04, 4.5399936916E+01, 1.4271805712E+01, 1.0905970197E+01, 5.4410641524E+00, 8.7865125126E-01],
	[2.6130000000E+04, 4.5413775440E+01, 1.4271678436E+01, 1.0912717027E+01, 5.4429232981E+00, 8.7870897018E-01],
	[2.6135000000E+04, 4.5427615534E+01, 1.4271551186E+01, 1.0919466736E+01, 5.4447822587E+00, 8.7876666246E-01],
	[2.6140000000E+04, 4.5441457197E+01, 1.4271423961E+01, 1.0926219326E+01, 5.4466410339E+00, 8.7882432810E-01],
	[2.6145000000E+04, 4.5455300428E+01, 1.4271296762E+01, 1.0932974797E+01, 5.4484996234E+00, 8.7888196710E-01],
	[2.6150000000E+04, 4.5469145229E+01, 1.4271169588E+01, 1.0939733151E+01, 5.4503580271E+00, 8.7893957948E-01],
	[2.6155000000E+04, 4.5482991598E+01, 1.4271042440E+01, 1.0946494386E+01, 5.4522162447E+00, 8.7899716525E-01],
	[2.6160000000E+04, 4.5496839536E+01, 1.4270915317E+01, 1.0953258505E+01, 5.4540742758E+00, 8.7905472441E-01],
	[2.6165000000E+04, 4.5510689042E+01, 1.4270788220E+01, 1.0960025509E+01, 5.4559321203E+00, 8.7911225698E-01],
	[2.6170000000E+04, 4.5524540117E+01, 1.4270661148E+01, 1.0966795396E+01, 5.4577897779E+00, 8.7916976296E-01],
	[2.6175000000E+04, 4.5538392759E+01, 1.4270534101E+01, 1.0973568169E+01, 5.4596472484E+00, 8.7922724236E-01],
	[2.6180000000E+04, 4.5552246970E+01, 1.4270407080E+01, 1.0980343828E+01, 5.4615045315E+00, 8.7928469519E-01],
	[2.6185000000E+04, 4.5566102749E+01, 1.4270280084E+01, 1.0987122374E+01, 5.4633616270E+00, 8.7934212146E-01],
	[2.6190000000E+04, 4.5579960096E+01, 1.4270153114E+01, 1.0993903807E+01, 5.4652185345E+00, 8.7939952118E-01],
	[2.6195000000E+04, 4.5593819010E+01, 1.4270026169E+01, 1.1000688128E+01, 5.4670752540E+00, 8.7945689435E-01],
	[2.6200000000E+04, 4.5607679493E+01, 1.4269899249E+01, 1.1007475338E+01, 5.4689317850E+00, 8.7951424099E-01],
	[2.6205000000E+04, 4.5621541542E+01, 1.4269772355E+01, 1.1014265437E+01, 5.4707881274E+00, 8.7957156110E-01],
	[2.6210000000E+04, 4.5635405159E+01, 1.4269645486E+01, 1.1021058426E+01, 5.4726442809E+00, 8.7962885469E-01],
	[2.6215000000E+04, 4.5649270343E+01, 1.4269518642E+01, 1.1027854306E+01, 5.4745002453E+00, 8.7968612178E-01],
	[2.6220000000E+04, 4.5663137095E+01, 1.4269391824E+01, 1.1034653077E+01, 5.4763560203E+00, 8.7974336237E-01],
	[2.6225000000E+04, 4.5677005413E+01, 1.4269265031E+01, 1.1041454740E+01, 5.4782116056E+00, 8.7980057646E-01],
	[2.6230000000E+04, 4.5690875298E+01, 1.4269138263E+01, 1.1048259296E+01, 5.4800670011E+00, 8.7985776408E-01],
	[2.6235000000E+04, 4.5704746750E+01, 1.4269011520E+01, 1.1055066746E+01, 5.4819222064E+00, 8.7991492522E-01],
	[2.6240000000E+04, 4.5718619769E+01, 1.4268884803E+01, 1.1061877090E+01, 5.4837772214E+00, 8.7997205989E-01],
	[2.6245000000E+04, 4.5732494354E+01, 1.4268758111E+01, 1.1068690328E+01, 5.4856320458E+00, 8.8002916811E-01],
	[2.6250000000E+04, 4.5746370505E+01, 1.4268631444E+01, 1.1075506462E+01, 5.4874866792E+00, 8.8008624989E-01],
	[2.6255000000E+04, 4.5760248223E+01, 1.4268504803E+01, 1.1082325492E+01, 5.4893411216E+00, 8.8014330522E-01],
	[2.6260000000E+04, 4.5774127507E+01, 1.4268378187E+01, 1.1089147419E+01, 5.4911953726E+00, 8.8020033413E-01],
	[2.6265000000E+04, 4.5788008357E+01, 1.4268251596E+01, 1.1095972243E+01, 5.4930494320E+00, 8.8025733662E-01],
	[2.6270000000E+04, 4.5801890773E+01, 1.4268125030E+01, 1.1102799966E+01, 5.4949032995E+00, 8.8031431270E-01],
	[2.6275000000E+04, 4.5815774755E+01, 1.4267998490E+01, 1.1109630587E+01, 5.4967569749E+00, 8.8037126237E-01],
	[2.6280000000E+04, 4.5829660302E+01, 1.4267871974E+01, 1.1116464108E+01, 5.4986104580E+00, 8.8042818566E-01],
	[2.6285000000E+04, 4.5843547415E+01, 1.4267745484E+01, 1.1123300530E+01, 5.5004637485E+00, 8.8048508255E-01],
	[2.6290000000E+04, 4.5857436093E+01, 1.4267619019E+01, 1.1130139852E+01, 5.5023168461E+00, 8.8054195308E-01],
	[2.6295000000E+04, 4.5871326337E+01, 1.4267492579E+01, 1.1136982075E+01, 5.5041697507E+00, 8.8059879723E-01],
	[2.6300000000E+04, 4.5885218146E+01, 1.4267366165E+01, 1.1143827201E+01, 5.5060224619E+00, 8.8065561503E-01],
	[2.6305000000E+04, 4.5899111520E+01, 1.4267239775E+01, 1.1150675230E+01, 5.5078749795E+00, 8.8071240648E-01],
	[2.6310000000E+04, 4.5913006458E+01, 1.4267113411E+01, 1.1157526163E+01, 5.5097273034E+00, 8.8076917159E-01],
	[2.6315000000E+04, 4.5926902962E+01, 1.4266987072E+01, 1.1164379999E+01, 5.5115794331E+00, 8.8082591037E-01],
	[2.6320000000E+04, 4.5940801030E+01, 1.4266860758E+01, 1.1171236741E+01, 5.5134313686E+00, 8.8088262283E-01],
	[2.6325000000E+04, 4.5954753341E+01, 1.4266743356E+01, 1.1178096388E+01, 5.5152851965E+00, 8.8093930898E-01],
	[2.6330000000E+04, 4.5968714671E+01, 1.4266627232E+01, 1.1184958942E+01, 5.5171391261E+00, 8.8099596882E-01],
	[2.6335000000E+04, 4.5982677591E+01, 1.4266511131E+01, 1.1191824402E+01, 5.5189928630E+00, 8.8105260237E-01],
	[2.6340000000E+04, 4.5996642100E+01, 1.4266395053E+01, 1.1198692771E+01, 5.5208464068E+00, 8.8110920964E-01],
	[2.6345000000E+04, 4.6010608197E+01, 1.4266278997E+01, 1.1205564047E+01, 5.5226997573E+00, 8.8116579062E-01],
	[2.6350000000E+04, 4.6024575884E+01, 1.4266162965E+01, 1.1212438233E+01, 5.5245529143E+00, 8.8122234534E-01],
	[2.6355000000E+04, 4.6038545160E+01, 1.4266046956E+01, 1.1219315328E+01, 5.5264058776E+00, 8.8127887380E-01],
	[2.6360000000E+04, 4.6052516025E+01, 1.4265930969E+01, 1.1226195334E+01, 5.5282586468E+00, 8.8133537601E-01],
	[2.6365000000E+04, 4.6066488478E+01, 1.4265815006E+01, 1.1233078251E+01, 5.5301112218E+00, 8.8139185199E-01],
	[2.6370000000E+04, 4.6080462520E+01, 1.4265699065E+01, 1.1239964079E+01, 5.5319636023E+00, 8.8144830173E-01],
	[2.6375000000E+04, 4.6094438150E+01, 1.4265583148E+01, 1.1246852820E+01, 5.5338157881E+00, 8.8150472524E-01],
	[2.6380000000E+04, 4.6108415368E+01, 1.4265467253E+01, 1.1253744474E+01, 5.5356677789E+00, 8.8156112255E-01],
	[2.6385000000E+04, 4.6122394175E+01, 1.4265351381E+01, 1.1260639042E+01, 5.5375195745E+00, 8.8161749365E-01],
	[2.6390000000E+04, 4.6136374569E+01, 1.4265235532E+01, 1.1267536524E+01, 5.5393711747E+00, 8.8167383855E-01],
	[2.6395000000E+04, 4.6150356552E+01, 1.4265119706E+01, 1.1274436922E+01, 5.5412225791E+00, 8.8173015727E-01],
	[2.6400000000E+04, 4.6164340122E+01, 1.4265003903E+01, 1.1281340235E+01, 5.5430737876E+00, 8.8178644982E-01],
	[2.6405000000E+04, 4.6178325280E+01, 1.4264888123E+01, 1.1288246464E+01, 5.5449247999E+00, 8.8184271619E-01],
	[2.6410000000E+04, 4.6192312026E+01, 1.4264772366E+01, 1.1295155611E+01, 5.5467756158E+00, 8.8189895641E-01],
	[2.6415000000E+04, 4.6206300359E+01, 1.4264656631E+01, 1.1302067676E+01, 5.5486262351E+00, 8.8195517047E-01],
	[2.6420000000E+04, 4.6220290279E+01, 1.4264540919E+01, 1.1308982659E+01, 5.5504766574E+00, 8.8201135840E-01],
	[2.6425000000E+04, 4.6234281786E+01, 1.4264425231E+01, 1.1315900561E+01, 5.5523268826E+00, 8.8206752019E-01],
	[2.6430000000E+04, 4.6248274881E+01, 1.4264309565E+01, 1.1322821384E+01, 5.5541769104E+00, 8.8212365587E-01],
	[2.6435000000E+04, 4.6262269562E+01, 1.4264193921E+01, 1.1329745127E+01, 5.5560267406E+00, 8.8217976543E-01],
	[2.6440000000E+04, 4.6276265830E+01, 1.4264078301E+01, 1.1336671791E+01, 5.5578763730E+00, 8.8223584888E-01],
	[2.6445000000E+04, 4.6290263685E+01, 1.4263962703E+01, 1.1343601377E+01, 5.5597258073E+00, 8.8229190624E-01],
	[2.6450000000E+04, 4.6304263127E+01, 1.4263847129E+01, 1.1350533885E+01, 5.5615750432E+00, 8.8234793752E-01],
	[2.6455000000E+04, 4.6318264155E+01, 1.4263731577E+01, 1.1357469317E+01, 5.5634240805E+00, 8.8240394272E-01],
	[2.6460000000E+04, 4.6332266769E+01, 1.4263616047E+01, 1.1364407673E+01, 5.5652729191E+00, 8.8245992185E-01],
	[2.6465000000E+04, 4.6346270970E+01, 1.4263500541E+01, 1.1371348953E+01, 5.5671215586E+00, 8.8251587493E-01],
	[2.6470000000E+04, 4.6360276757E+01, 1.4263385057E+01, 1.1378293159E+01, 5.5689699988E+00, 8.8257180195E-01],
	[2.6475000000E+04, 4.6374284129E+01, 1.4263269596E+01, 1.1385240290E+01, 5.5708182395E+00, 8.8262770294E-01],
	[2.6480000000E+04, 4.6388293088E+01, 1.4263154158E+01, 1.1392190349E+01, 5.5726662804E+00, 8.8268357789E-01],
	[2.6485000000E+04, 4.6402303632E+01, 1.4263038742E+01, 1.1399143334E+01, 5.5745141214E+00, 8.8273942683E-01],
	[2.6490000000E+04, 4.6416315762E+01, 1.4262923349E+01, 1.1406099248E+01, 5.5763617621E+00, 8.8279524975E-01],
	[2.6495000000E+04, 4.6430329478E+01, 1.4262807979E+01, 1.1413058091E+01, 5.5782092023E+00, 8.8285104667E-01],
	[2.6500000000E+04, 4.6444344778E+01, 1.4262692632E+01, 1.1420019862E+01, 5.5800564418E+00, 8.8290681760E-01],
	[2.6505000000E+04, 4.6458361664E+01, 1.4262577307E+01, 1.1426984564E+01, 5.5819034804E+00, 8.8296256254E-01],
	[2.6510000000E+04, 4.6472380136E+01, 1.4262462005E+01, 1.1433952197E+01, 5.5837503178E+00, 8.8301828150E-01],
	[2.6515000000E+04, 4.6486400192E+01, 1.4262346726E+01, 1.1440922761E+01, 5.5855969538E+00, 8.8307397451E-01],
	[2.6520000000E+04, 4.6500421833E+01, 1.4262231469E+01, 1.1447896257E+01, 5.5874433881E+00, 8.8312964155E-01],
	[2.6525000000E+04, 4.6514445059E+01, 1.4262116235E+01, 1.1454872686E+01, 5.5892896206E+00, 8.8318528265E-01],
	[2.6530000000E+04, 4.6528469870E+01, 1.4262001024E+01, 1.1461852048E+01, 5.5911356509E+00, 8.8324089781E-01],
	[2.6535000000E+04, 4.6542496265E+01, 1.4261885835E+01, 1.1468834344E+01, 5.5929814789E+00, 8.8329648704E-01],
	[2.6540000000E+04, 4.6556524244E+01, 1.4261770669E+01, 1.1475819576E+01, 5.5948271043E+00, 8.8335205035E-01],
	[2.6545000000E+04, 4.6570553808E+01, 1.4261655526E+01, 1.1482807742E+01, 5.5966725269E+00, 8.8340758775E-01],
	[2.6550000000E+04, 4.6584584956E+01, 1.4261540405E+01, 1.1489798845E+01, 5.5985177464E+00, 8.8346309925E-01],
	[2.6555000000E+04, 4.6598617689E+01, 1.4261425307E+01, 1.1496792885E+01, 5.6003627626E+00, 8.8351858485E-01],
	[2.6560000000E+04, 4.6612652005E+01, 1.4261310231E+01, 1.1503789862E+01, 5.6022075753E+00, 8.8357404458E-01],
	[2.6565000000E+04, 4.6626687905E+01, 1.4261195178E+01, 1.1510789778E+01, 5.6040521842E+00, 8.8362947843E-01],
	[2.6570000000E+04, 4.6640725388E+01, 1.4261080147E+01, 1.1517792632E+01, 5.6058965891E+00, 8.8368488642E-01],
	[2.6575000000E+04, 4.6654764456E+01, 1.4260965140E+01, 1.1524798426E+01, 5.6077407899E+00, 8.8374026856E-01],
	[2.6580000000E+04, 4.6668805106E+01, 1.4260850154E+01, 1.1531807160E+01, 5.6095847861E+00, 8.8379562484E-01],
	[2.6585000000E+04, 4.6682847340E+01, 1.4260735191E+01, 1.1538818835E+01, 5.6114285777E+00, 8.8385095530E-01],
	[2.6590000000E+04, 4.6696891158E+01, 1.4260620251E+01, 1.1545833452E+01, 5.6132721643E+00, 8.8390625993E-01],
	[2.6595000000E+04, 4.6710936558E+01, 1.4260505334E+01, 1.1552851011E+01, 5.6151155458E+00, 8.8396153874E-01],
	[2.6600000000E+04, 4.6724983542E+01, 1.4260390438E+01, 1.1559871513E+01, 5.6169587219E+00, 8.8401679174E-01],
	[2.6605000000E+04, 4.6739032108E+01, 1.4260275566E+01, 1.1566894959E+01, 5.6188016924E+00, 8.8407201894E-01],
	[2.6610000000E+04, 4.6753082257E+01, 1.4260160716E+01, 1.1573921348E+01, 5.6206444570E+00, 8.8412722036E-01],
	[2.6615000000E+04, 4.6767133989E+01, 1.4260045888E+01, 1.1580950683E+01, 5.6224870155E+00, 8.8418239599E-01],
	[2.6620000000E+04, 4.6781187303E+01, 1.4259931083E+01, 1.1587982964E+01, 5.6243293678E+00, 8.8423754586E-01],
	[2.6625000000E+04, 4.6795242199E+01, 1.4259816300E+01, 1.1595018191E+01, 5.6261715134E+00, 8.8429266996E-01],
	[2.6630000000E+04, 4.6809298678E+01, 1.4259701540E+01, 1.1602056365E+01, 5.6280134523E+00, 8.8434776832E-01],
	[2.6635000000E+04, 4.6823356739E+01, 1.4259586802E+01, 1.1609097486E+01, 5.6298551842E+00, 8.8440284093E-01],
	[2.6640000000E+04, 4.6837416383E+01, 1.4259472087E+01, 1.1616141557E+01, 5.6316967089E+00, 8.8445788781E-01],
	[2.6645000000E+04, 4.6851477608E+01, 1.4259357394E+01, 1.1623188576E+01, 5.6335380261E+00, 8.8451290896E-01],
	[2.6650000000E+04, 4.6865540414E+01, 1.4259242724E+01, 1.1630238545E+01, 5.6353791356E+00, 8.8456790441E-01],
	[2.6655000000E+04, 4.6879604803E+01, 1.4259128076E+01, 1.1637291464E+01, 5.6372200372E+00, 8.8462287414E-01],
	[2.6660000000E+04, 4.6893670773E+01, 1.4259013450E+01, 1.1644347334E+01, 5.6390607306E+00, 8.8467781818E-01],
	[2.6665000000E+04, 4.6907738325E+01, 1.4258898847E+01, 1.1651406157E+01, 5.6409012157E+00, 8.8473273654E-01],
	[2.6670000000E+04, 4.6921807457E+01, 1.4258784267E+01, 1.1658467931E+01, 5.6427414921E+00, 8.8478762922E-01],
	[2.6675000000E+04, 4.6935878172E+01, 1.4258669708E+01, 1.1665532659E+01, 5.6445815597E+00, 8.8484249624E-01],
	[2.6680000000E+04, 4.6949950467E+01, 1.4258555173E+01, 1.1672600341E+01, 5.6464214182E+00, 8.8489733759E-01],
	[2.6685000000E+04, 4.6964024343E+01, 1.4258440659E+01, 1.1679670977E+01, 5.6482610674E+00, 8.8495215330E-01],
	[2.6690000000E+04, 4.6978099800E+01, 1.4258326168E+01, 1.1686744569E+01, 5.6501005071E+00, 8.8500694337E-01],
	[2.6695000000E+04, 4.6992176838E+01, 1.4258211699E+01, 1.1693821116E+01, 5.6519397371E+00, 8.8506170781E-01],
	[2.6700000000E+04, 4.7006255456E+01, 1.4258097253E+01, 1.1700900620E+01, 5.6537787570E+00, 8.8511644664E-01],
	[2.6705000000E+04, 4.7020335655E+01, 1.4257982829E+01, 1.1707983081E+01, 5.6556175668E+00, 8.8517115985E-01],
	[2.6710000000E+04, 4.7034417434E+01, 1.4257868427E+01, 1.1715068500E+01, 5.6574561661E+00, 8.8522584746E-01],
	[2.6715000000E+04, 4.7048500794E+01, 1.4257754048E+01, 1.1722156878E+01, 5.6592945547E+00, 8.8528050948E-01],
	[2.6720000000E+04, 4.7062585733E+01, 1.4257639691E+01, 1.1729248215E+01, 5.6611327325E+00, 8.8533514592E-01],
	[2.6725000000E+04, 4.7076672253E+01, 1.4257525356E+01, 1.1736342511E+01, 5.6629706991E+00, 8.8538975679E-01],
	[2.6730000000E+04, 4.7090760352E+01, 1.4257411044E+01, 1.1743439769E+01, 5.6648084544E+00, 8.8544434209E-01],
	[2.6735000000E+04, 4.7104850032E+01, 1.4257296753E+01, 1.1750539988E+01, 5.6666459982E+00, 8.8549890184E-01],
	[2.6740000000E+04, 4.7118941291E+01, 1.4257182486E+01, 1.1757643168E+01, 5.6684833301E+00, 8.8555343605E-01],
	[2.6745000000E+04, 4.7133041981E+01, 1.4257069547E+01, 1.1764749312E+01, 5.6703207703E+00, 8.8560794473E-01],
	[2.6750000000E+04, 4.7147196290E+01, 1.4256965287E+01, 1.1771858419E+01, 5.6721601220E+00, 8.8566242788E-01],
	[2.6755000000E+04, 4.7161352202E+01, 1.4256861047E+01, 1.1778970490E+01, 5.6739992635E+00, 8.8571688551E-01],
	[2.6760000000E+04, 4.7175509718E+01, 1.4256756827E+01, 1.1786085525E+01, 5.6758381944E+00, 8.8577131764E-01],
	[2.6765000000E+04, 4.7189668838E+01, 1.4256652628E+01, 1.1793203526E+01, 5.6776769147E+00, 8.8582572427E-01],
	[2.6770000000E+04, 4.7203829561E+01, 1.4256548448E+01, 1.1800324493E+01, 5.6795154240E+00, 8.8588010542E-01],
	[2.6775000000E+04, 4.7217991889E+01, 1.4256444289E+01, 1.1807448427E+01, 5.6813537221E+00, 8.8593446109E-01],
	[2.6780000000E+04, 4.7232155819E+01, 1.4256340151E+01, 1.1814575328E+01, 5.6831918089E+00, 8.8598879130E-01],
	[2.6785000000E+04, 4.7246321353E+01, 1.4256236032E+01, 1.1821705198E+01, 5.6850296841E+00, 8.8604309604E-01],
	[2.6790000000E+04, 4.7260488490E+01, 1.4256131934E+01, 1.1828838036E+01, 5.6868673474E+00, 8.8609737534E-01],
	[2.6795000000E+04, 4.7274657230E+01, 1.4256027855E+01, 1.1835973844E+01, 5.6887047987E+00, 8.8615162920E-01],
	[2.6800000000E+04, 4.7288827573E+01, 1.4255923797E+01, 1.1843112621E+01, 5.6905420378E+00, 8.8620585763E-01],
	[2.6805000000E+04, 4.7302999519E+01, 1.4255819760E+01, 1.1850254370E+01, 5.6923790643E+00, 8.8626006064E-01],
	[2.6810000000E+04, 4.7317173067E+01, 1.4255715742E+01, 1.1857399090E+01, 5.6942158781E+00, 8.8631423824E-01],
	[2.6815000000E+04, 4.7331348218E+01, 1.4255611744E+01, 1.1864546783E+01, 5.6960524789E+00, 8.8636839044E-01],
	[2.6820000000E+04, 4.7345524972E+01, 1.4255507767E+01, 1.1871697448E+01, 5.6978888666E+00, 8.8642251725E-01],
	[2.6825000000E+04, 4.7359703328E+01, 1.4255403810E+01, 1.1878851087E+01, 5.6997250409E+00, 8.8647661868E-01],
	[2.6830000000E+04, 4.7373883286E+01, 1.4255299873E+01, 1.1886007700E+01, 5.7015610016E+00, 8.8653069474E-01],
	[2.6835000000E+04, 4.7388064846E+01, 1.4255195956E+01, 1.1893167288E+01, 5.7033967485E+00, 8.8658474543E-01],
	[2.6840000000E+04, 4.7402248009E+01, 1.4255092059E+01, 1.1900329851E+01, 5.7052322813E+00, 8.8663877078E-01],
	[2.6845000000E+04, 4.7416432773E+01, 1.4254988182E+01, 1.1907495391E+01, 5.7070675998E+00, 8.8669277078E-01],
	[2.6850000000E+04, 4.7430619139E+01, 1.4254884326E+01, 1.1914663908E+01, 5.7089027039E+00, 8.8674674545E-01],
	[2.6855000000E+04, 4.7444807106E+01, 1.4254780489E+01, 1.1921835403E+01, 5.7107375932E+00, 8.8680069479E-01],
	[2.6860000000E+04, 4.7458996675E+01, 1.4254676673E+01, 1.1929009875E+01, 5.7125722676E+00, 8.8685461882E-01],
	[2.6865000000E+04, 4.7473187846E+01, 1.4254572876E+01, 1.1936187327E+01, 5.7144067268E+00, 8.8690851755E-01],
	[2.6870000000E+04, 4.7487380618E+01, 1.4254469100E+01, 1.1943367759E+01, 5.7162409706E+00, 8.8696239098E-01],
	[2.6875000000E+04, 4.7501574991E+01, 1.4254365344E+01, 1.1950551171E+01, 5.7180749989E+00, 8.8701623913E-01],
	[2.6880000000E+04, 4.7515770965E+01, 1.4254261608E+01, 1.1957737564E+01, 5.7199088113E+00, 8.8707006200E-01],
	[2.6885000000E+04, 4.7529968540E+01, 1.4254157891E+01, 1.1964926938E+01, 5.7217424077E+00, 8.8712385961E-01],
	[2.6890000000E+04, 4.7544167716E+01, 1.4254054195E+01, 1.1972119296E+01, 5.7235757878E+00, 8.8717763196E-01],
	[2.6895000000E+04, 4.7558368493E+01, 1.4253950519E+01, 1.1979314636E+01, 5.7254089514E+00, 8.8723137907E-01],
	[2.6900000000E+04, 4.7572570870E+01, 1.4253846863E+01, 1.1986512960E+01, 5.7272418984E+00, 8.8728510094E-01],
	[2.6905000000E+04, 4.7586774847E+01, 1.4253743227E+01, 1.1993714268E+01, 5.7290746284E+00, 8.8733879758E-01],
	[2.6910000000E+04, 4.7600980425E+01, 1.4253639611E+01, 1.2000918562E+01, 5.7309071413E+00, 8.8739246901E-01],
	[2.6915000000E+04, 4.7615187604E+01, 1.4253536015E+01, 1.2008125841E+01, 5.7327394368E+00, 8.8744611522E-01],
	[2.6920000000E+04, 4.7629396382E+01, 1.4253432439E+01, 1.2015336107E+01, 5.7345715148E+00, 8.8749973624E-01],
	[2.6925000000E+04, 4.7643606760E+01, 1.4253328883E+01, 1.2022549360E+01, 5.7364033749E+00, 8.8755333207E-01],
	[2.6930000000E+04, 4.7657818739E+01, 1.4253225347E+01, 1.2029765601E+01, 5.7382350171E+00, 8.8760690273E-01],
	[2.6935000000E+04, 4.7672032317E+01, 1.4253121831E+01, 1.2036984831E+01, 5.7400664410E+00, 8.8766044821E-01],
	[2.6940000000E+04, 4.7686247495E+01, 1.4253018335E+01, 1.2044207050E+01, 5.7418976465E+00, 8.8771396854E-01],
	[2.6945000000E+04, 4.7700464272E+01, 1.4252914859E+01, 1.2051432258E+01, 5.7437286333E+00, 8.8776746372E-01],
	[2.6950000000E+04, 4.7714682649E+01, 1.4252811403E+01, 1.2058660457E+01, 5.7455594013E+00, 8.8782093375E-01],
	[2.6955000000E+04, 4.7728902625E+01, 1.4252707966E+01, 1.2065891648E+01, 5.7473899502E+00, 8.8787437866E-01],
	[2.6960000000E+04, 4.7743124200E+01, 1.4252604550E+01, 1.2073125830E+01, 5.7492202797E+00, 8.8792779845E-01],
	[2.6965000000E+04, 4.7757347374E+01, 1.4252501154E+01, 1.2080363006E+01, 5.7510503897E+00, 8.8798119312E-01],
	[2.6970000000E+04, 4.7771572147E+01, 1.4252397777E+01, 1.2087603174E+01, 5.7528802800E+00, 8.8803456270E-01],
	[2.6975000000E+04, 4.7785798519E+01, 1.4252294421E+01, 1.2094846336E+01, 5.7547099503E+00, 8.8808790719E-01],
	[2.6980000000E+04, 4.7800026490E+01, 1.4252191084E+01, 1.2102092494E+01, 5.7565394005E+00, 8.8814122659E-01],
	[2.6985000000E+04, 4.7814256060E+01, 1.4252087767E+01, 1.2109341646E+01, 5.7583686302E+00, 8.8819452092E-01],
	[2.6990000000E+04, 4.7828487227E+01, 1.4251984471E+01, 1.2116593795E+01, 5.7601976394E+00, 8.8824779019E-01],
	[2.6995000000E+04, 4.7842719994E+01, 1.4251881194E+01, 1.2123848940E+01, 5.7620264277E+00, 8.8830103441E-01],
	[2.7000000000E+04, 4.7856954358E+01, 1.4251777936E+01, 1.2131107082E+01, 5.7638549950E+00, 8.8835425359E-01],
	[2.7005000000E+04, 4.7871190321E+01, 1.4251674699E+01, 1.2138368223E+01, 5.7656833410E+00, 8.8840744773E-01],
	[2.7010000000E+04, 4.7885427882E+01, 1.4251571482E+01, 1.2145632363E+01, 5.7675114656E+00, 8.8846061686E-01],
	[2.7015000000E+04, 4.7899667040E+01, 1.4251468284E+01, 1.2152899502E+01, 5.7693393685E+00, 8.8851376097E-01],
	[2.7020000000E+04, 4.7913907797E+01, 1.4251365107E+01, 1.2160169641E+01, 5.7711670495E+00, 8.8856688007E-01],
	[2.7025000000E+04, 4.7928150151E+01, 1.4251261949E+01, 1.2167442781E+01, 5.7729945084E+00, 8.8861997418E-01],
	[2.7030000000E+04, 4.7942394102E+01, 1.4251158811E+01, 1.2174718922E+01, 5.7748217450E+00, 8.8867304331E-01],
	[2.7035000000E+04, 4.7956639651E+01, 1.4251055693E+01, 1.2181998066E+01, 5.7766487590E+00, 8.8872608747E-01],
	[2.7040000000E+04, 4.7970886798E+01, 1.4250952594E+01, 1.2189280212E+01, 5.7784755503E+00, 8.8877910666E-01],
	[2.7045000000E+04, 4.7985135541E+01, 1.4250849516E+01, 1.2196565362E+01, 5.7803021187E+00, 8.8883210090E-01],
	[2.7050000000E+04, 4.7999385882E+01, 1.4250746457E+01, 1.2203853516E+01, 5.7821284638E+00, 8.8888507019E-01],
	[2.7055000000E+04, 4.8013637820E+01, 1.4250643418E+01, 1.2211144675E+01, 5.7839545856E+00, 8.8893801455E-01],
	[2.7060000000E+04, 4.8027891354E+01, 1.4250540399E+01, 1.2218438840E+01, 5.7857804838E+00, 8.8899093399E-01],
	[2.7065000000E+04, 4.8042146486E+01, 1.4250437399E+01, 1.2225736011E+01, 5.7876061582E+00, 8.8904382850E-01],
	[2.7070000000E+04, 4.8056403214E+01, 1.4250334420E+01, 1.2233036189E+01, 5.7894316085E+00, 8.8909669812E-01],
	[2.7075000000E+04, 4.8070661538E+01, 1.4250231460E+01, 1.2240339375E+01, 5.7912568347E+00, 8.8914954284E-01],
	[2.7080000000E+04, 4.8084921459E+01, 1.4250128520E+01, 1.2247645569E+01, 5.7930818363E+00, 8.8920236267E-01],
	[2.7085000000E+04, 4.8099182976E+01, 1.4250025600E+01, 1.2254954771E+01, 5.7949066134E+00, 8.8925515763E-01],
	[2.7090000000E+04, 4.8113446089E+01, 1.4249922699E+01, 1.2262266984E+01, 5.7967311655E+00, 8.8930792772E-01],
	[2.7095000000E+04, 4.8127710798E+01, 1.4249819818E+01, 1.2269582207E+01, 5.7985554926E+00, 8.8936067296E-01],
	[2.7100000000E+04, 4.8141977104E+01, 1.4249716957E+01, 1.2276900441E+01, 5.8003795944E+00, 8.8941339335E-01],
	[2.7105000000E+04, 4.8156245005E+01, 1.4249614115E+01, 1.2284221687E+01, 5.8022034707E+00, 8.8946608890E-01],
	[2.7110000000E+04, 4.8170514502E+01, 1.4249511294E+01, 1.2291545945E+01, 5.8040271213E+00, 8.8951875963E-01],
	[2.7115000000E+04, 4.8184785594E+01, 1.4249408492E+01, 1.2298873216E+01, 5.8058505460E+00, 8.8957140554E-01],
	[2.7120000000E+04, 4.8199058282E+01, 1.4249305709E+01, 1.2306203501E+01, 5.8076737445E+00, 8.8962402664E-01],
	[2.7125000000E+04, 4.8213332565E+01, 1.4249202947E+01, 1.2313536800E+01, 5.8094967168E+00, 8.8967662295E-01],
	[2.7130000000E+04, 4.8227608443E+01, 1.4249100204E+01, 1.2320873115E+01, 5.8113194624E+00, 8.8972919447E-01],
	[2.7135000000E+04, 4.8241885917E+01, 1.4248997480E+01, 1.2328212445E+01, 5.8131419813E+00, 8.8978174121E-01],
	[2.7140000000E+04, 4.8256164985E+01, 1.4248894777E+01, 1.2335554792E+01, 5.8149642733E+00, 8.8983426318E-01],
	[2.7145000000E+04, 4.8270445649E+01, 1.4248792093E+01, 1.2342900157E+01, 5.8167863381E+00, 8.8988676040E-01],
	[2.7150000000E+04, 4.8284727907E+01, 1.4248689429E+01, 1.2350248539E+01, 5.8186081755E+00, 8.8993923287E-01],
	[2.7155000000E+04, 4.8299011760E+01, 1.4248586784E+01, 1.2357599939E+01, 5.8204297853E+00, 8.8999168059E-01],
	[2.7160000000E+04, 4.8313297207E+01, 1.4248484159E+01, 1.2364954359E+01, 5.8222511673E+00, 8.9004410358E-01],
	[2.7165000000E+04, 4.8327584249E+01, 1.4248381554E+01, 1.2372311799E+01, 5.8240723213E+00, 8.9009650185E-01],
	[2.7170000000E+04, 4.8341872885E+01, 1.4248278968E+01, 1.2379672259E+01, 5.8258932471E+00, 8.9014887540E-01],
	[2.7175000000E+04, 4.8356164406E+01, 1.4248176613E+01, 1.2387035740E+01, 5.8277139986E+00, 8.9020122424E-01],
	[2.7180000000E+04, 4.8370515891E+01, 1.4248083856E+01, 1.2394402244E+01, 5.8295369726E+00, 8.9025354839E-01],
	[2.7185000000E+04, 4.8384868993E+01, 1.4247991116E+01, 1.2401771770E+01, 5.8313597200E+00, 8.9030584785E-01],
	[2.7190000000E+04, 4.8399223714E+01, 1.4247898394E+01, 1.2409144320E+01, 5.8331822405E+00, 8.9035812263E-01],
	[2.7195000000E+04, 4.8413580054E+01, 1.4247805689E+01, 1.2416519893E+01, 5.8350045339E+00, 8.9041037274E-01],
	[2.7200000000E+04, 4.8427938011E+01, 1.4247713002E+01, 1.2423898491E+01, 5.8368266001E+00, 8.9046259819E-01],
	[2.7205000000E+04, 4.8442297586E+01, 1.4247620333E+01, 1.2431280115E+01, 5.8386484387E+00, 8.9051479898E-01],
	[2.7210000000E+04, 4.8456658778E+01, 1.4247527681E+01, 1.2438664765E+01, 5.8404700497E+00, 8.9056697513E-01],
	[2.7215000000E+04, 4.8471021589E+01, 1.4247435047E+01, 1.2446052441E+01, 5.8422914328E+00, 8.9061912664E-01],
	[2.7220000000E+04, 4.8485386017E+01, 1.4247342431E+01, 1.2453443145E+01, 5.8441125878E+00, 8.9067125353E-01],
	[2.7225000000E+04, 4.8499752062E+01, 1.4247249832E+01, 1.2460836877E+01, 5.8459335145E+00, 8.9072335580E-01],
	[2.7230000000E+04, 4.8514119724E+01, 1.4247157251E+01, 1.2468233638E+01, 5.8477542127E+00, 8.9077543346E-01],
	[2.7235000000E+04, 4.8528489004E+01, 1.4247064688E+01, 1.2475633428E+01, 5.8495746822E+00, 8.9082748653E-01],
	[2.7240000000E+04, 4.8542859901E+01, 1.4246972142E+01, 1.2483036248E+01, 5.8513949227E+00, 8.9087951500E-01],
	[2.7245000000E+04, 4.8557232415E+01, 1.4246879613E+01, 1.2490442100E+01, 5.8532149341E+00, 8.9093151889E-01],
	[2.7250000000E+04, 4.8571606545E+01, 1.4246787102E+01, 1.2497850983E+01, 5.8550347163E+00, 8.9098349820E-01],
	[2.7255000000E+04, 4.8585982292E+01, 1.4246694609E+01, 1.2505262898E+01, 5.8568542688E+00, 8.9103545296E-01],
	[2.7260000000E+04, 4.8600359656E+01, 1.4246602133E+01, 1.2512677845E+01, 5.8586735917E+00, 8.9108738315E-01],
	[2.7265000000E+04, 4.8614738636E+01, 1.4246509675E+01, 1.2520095827E+01, 5.8604926846E+00, 8.9113928881E-01],
	[2.7270000000E+04, 4.8629119233E+01, 1.4246417235E+01, 1.2527516843E+01, 5.8623115473E+00, 8.9119116992E-01],
	[2.7275000000E+04, 4.8643501446E+01, 1.4246324812E+01, 1.2534940893E+01, 5.8641301798E+00, 8.9124302651E-01],
	[2.7280000000E+04, 4.8657885275E+01, 1.4246232406E+01, 1.2542367980E+01, 5.8659485816E+00, 8.9129485858E-01],
	[2.7285000000E+04, 4.8672270720E+01, 1.4246140018E+01, 1.2549798102E+01, 5.8677667527E+00, 8.9134666613E-01],
	[2.7290000000E+04, 4.8686657781E+01, 1.4246047648E+01, 1.2557231262E+01, 5.8695846929E+00, 8.9139844919E-01],
	[2.7295000000E+04, 4.8701046458E+01, 1.4245955295E+01, 1.2564667459E+01, 5.8714024019E+00, 8.9145020776E-01],
	[2.7300000000E+04, 4.8715436751E+01, 1.4245862960E+01, 1.2572106695E+01, 5.8732198796E+00, 8.9150194184E-01],
	[2.7305000000E+04, 4.8729828659E+01, 1.4245770642E+01, 1.2579548969E+01, 5.8750371257E+00, 8.9155365144E-01],
	[2.7310000000E+04, 4.8744222182E+01, 1.4245678342E+01, 1.2586994284E+01, 5.8768541400E+00, 8.9160533659E-01],
	[2.7315000000E+04, 4.8758617321E+01, 1.4245586059E+01, 1.2594442639E+01, 5.8786709224E+00, 8.9165699727E-01],
	[2.7320000000E+04, 4.8773014075E+01, 1.4245493793E+01, 1.2601894035E+01, 5.8804874726E+00, 8.9170863351E-01],
	[2.7325000000E+04, 4.8787412444E+01, 1.4245401545E+01, 1.2609348472E+01, 5.8823037904E+00, 8.9176024531E-01],
	[2.7330000000E+04, 4.8801812428E+01, 1.4245309315E+01, 1.2616805952E+01, 5.8841198757E+00, 8.9181183269E-01],
	[2.7335000000E+04, 4.8816214027E+01, 1.4245217102E+01, 1.2624266476E+01, 5.8859357282E+00, 8.9186339564E-01],
	[2.7340000000E+04, 4.8830617241E+01, 1.4245124907E+01, 1.2631730043E+01, 5.8877513477E+00, 8.9191493418E-01],
	[2.7345000000E+04, 4.8845022070E+01, 1.4245032729E+01, 1.2639196654E+01, 5.8895667340E+00, 8.9196644832E-01],
	[2.7350000000E+04, 4.8859428513E+01, 1.4244940568E+01, 1.2646666311E+01, 5.8913818870E+00, 8.9201793807E-01],
	[2.7355000000E+04, 4.8873836570E+01, 1.4244848425E+01, 1.2654139014E+01, 5.8931968065E+00, 8.9206940343E-01],
	[2.7360000000E+04, 4.8888246242E+01, 1.4244756299E+01, 1.2661614763E+01, 5.8950114921E+00, 8.9212084442E-01],
	[2.7365000000E+04, 4.8902657528E+01, 1.4244664191E+01, 1.2669093560E+01, 5.8968259438E+00, 8.9217226104E-01],
	[2.7370000000E+04, 4.8917070427E+01, 1.4244572100E+01, 1.2676575404E+01, 5.8986401613E+00, 8.9222365331E-01],
	[2.7375000000E+04, 4.8931484941E+01, 1.4244480027E+01, 1.2684060297E+01, 5.9004541445E+00, 8.9227502122E-01],
	[2.7380000000E+04, 4.8945901069E+01, 1.4244387971E+01, 1.2691548240E+01, 5.9022678931E+00, 8.9232636480E-01],
	[2.7385000000E+04, 4.8960318811E+01, 1.4244295932E+01, 1.2699039232E+01, 5.9040814069E+00, 8.9237768406E-01],
	[2.7390000000E+04, 4.8974738166E+01, 1.4244203911E+01, 1.2706534875E+01, 5.9058950313E+00, 8.9242897899E-01],
	[2.7395000000E+04, 4.8989159134E+01, 1.4244111907E+01, 1.2714034022E+01, 5.9077085180E+00, 8.9248024961E-01],
	[2.7400000000E+04, 4.9003581717E+01, 1.4244019920E+01, 1.2721536223E+01, 5.9095217692E+00, 8.9253149592E-01],
	[2.7405000000E+04, 4.9018005912E+01, 1.4243927951E+01, 1.2729041479E+01, 5.9113347849E+00, 8.9258271795E-01],
	[2.7410000000E+04, 4.9032431720E+01, 1.4243836000E+01, 1.2736549790E+01, 5.9131475648E+00, 8.9263391569E-01],
	[2.7415000000E+04, 4.9046859142E+01, 1.4243744065E+01, 1.2744061158E+01, 5.9149601087E+00, 8.9268508916E-01],
	[2.7420000000E+04, 4.9061288176E+01, 1.4243652148E+01, 1.2751575583E+01, 5.9167724164E+00, 8.9273623836E-01],
	[2.7425000000E+04, 4.9075718824E+01, 1.4243560249E+01, 1.2759093065E+01, 5.9185844878E+00, 8.9278736330E-01],
	[2.7430000000E+04, 4.9090151084E+01, 1.4243468367E+01, 1.2766613606E+01, 5.9203963225E+00, 8.9283846400E-01],
	[2.7435000000E+04, 4.9104584956E+01, 1.4243376502E+01, 1.2774137205E+01, 5.9222079205E+00, 8.9288954046E-01],
	[2.7440000000E+04, 4.9119020441E+01, 1.4243284654E+01, 1.2781663864E+01, 5.9240192815E+00, 8.9294059269E-01],
	[2.7445000000E+04, 4.9133457539E+01, 1.4243192824E+01, 1.2789193584E+01, 5.9258304054E+00, 8.9299162070E-01],
	[2.7450000000E+04, 4.9147896248E+01, 1.4243101011E+01, 1.2796726365E+01, 5.9276412918E+00, 8.9304262451E-01],
	[2.7455000000E+04, 4.9162336570E+01, 1.4243009215E+01, 1.2804262207E+01, 5.9294519408E+00, 8.9309360411E-01],
	[2.7460000000E+04, 4.9176778504E+01, 1.4242917437E+01, 1.2811801112E+01, 5.9312623519E+00, 8.9314455951E-01],
	[2.7465000000E+04, 4.9191222050E+01, 1.4242825676E+01, 1.2819343080E+01, 5.9330725251E+00, 8.9319549074E-01],
	[2.7470000000E+04, 4.9205667208E+01, 1.4242733932E+01, 1.2826888112E+01, 5.9348824602E+00, 8.9324639779E-01],
	[2.7475000000E+04, 4.9220113977E+01, 1.4242642206E+01, 1.2834436208E+01, 5.9366921569E+00, 8.9329728067E-01],
	[2.7480000000E+04, 4.9234562358E+01, 1.4242550496E+01, 1.2841987369E+01, 5.9385016151E+00, 8.9334813940E-01],
	[2.7485000000E+04, 4.9249012350E+01, 1.4242458805E+01, 1.2849541596E+01, 5.9403108345E+00, 8.9339897399E-01],
	[2.7490000000E+04, 4.9263463954E+01, 1.4242367130E+01, 1.2857098890E+01, 5.9421198151E+00, 8.9344978444E-01],
	[2.7495000000E+04, 4.9277917168E+01, 1.4242275473E+01, 1.2864659251E+01, 5.9439285565E+00, 8.9350057076E-01],
	[2.7500000000E+04, 4.9292371994E+01, 1.4242183832E+01, 1.2872222680E+01, 5.9457370586E+00, 8.9355133296E-01],
	[2.7505000000E+04, 4.9306828431E+01, 1.4242092210E+01, 1.2879789177E+01, 5.9475453212E+00, 8.9360207105E-01],
	[2.7510000000E+04, 4.9321286479E+01, 1.4242000604E+01, 1.2887358744E+01, 5.9493533440E+00, 8.9365278504E-01],
	[2.7515000000E+04, 4.9335746138E+01, 1.4241909016E+01, 1.2894931381E+01, 5.9511611270E+00, 8.9370347494E-01],
	[2.7520000000E+04, 4.9350207407E+01, 1.4241817445E+01, 1.2902507088E+01, 5.9529686699E+00, 8.9375414076E-01],
	[2.7525000000E+04, 4.9364670287E+01, 1.4241725891E+01, 1.2910085866E+01, 5.9547759725E+00, 8.9380478250E-01],
	[2.7530000000E+04, 4.9379134778E+01, 1.4241634354E+01, 1.2917667717E+01, 5.9565830347E+00, 8.9385540019E-01],
	[2.7535000000E+04, 4.9393600878E+01, 1.4241542834E+01, 1.2925252640E+01, 5.9583898562E+00, 8.9390599382E-01],
	[2.7540000000E+04, 4.9408068589E+01, 1.4241451332E+01, 1.2932840637E+01, 5.9601964368E+00, 8.9395656340E-01],
	[2.7545000000E+04, 4.9422537910E+01, 1.4241359847E+01, 1.2940431708E+01, 5.9620027764E+00, 8.9400710895E-01],
	[2.7550000000E+04, 4.9437008841E+01, 1.4241268379E+01, 1.2948025853E+01, 5.9638088747E+00, 8.9405763047E-01],
	[2.7555000000E+04, 4.9451481382E+01, 1.4241176928E+01, 1.2955623074E+01, 5.9656147316E+00, 8.9410812798E-01],
	[2.7560000000E+04, 4.9465955533E+01, 1.4241085495E+01, 1.2963223371E+01, 5.9674203469E+00, 8.9415860148E-01],
	[2.7565000000E+04, 4.9480431293E+01, 1.4240994079E+01, 1.2970826745E+01, 5.9692257203E+00, 8.9420905098E-01],
	[2.7570000000E+04, 4.9494908663E+01, 1.4240902679E+01, 1.2978433197E+01, 5.9710308518E+00, 8.9425947649E-01],
	[2.7575000000E+04, 4.9509387642E+01, 1.4240811297E+01, 1.2986042726E+01, 5.9728357410E+00, 8.9430987802E-01],
	[2.7580000000E+04, 4.9523868230E+01, 1.4240719933E+01, 1.2993655335E+01, 5.9746403879E+00, 8.9436025558E-01],
	[2.7585000000E+04, 4.9538350428E+01, 1.4240628585E+01, 1.3001271023E+01, 5.9764447922E+00, 8.9441060918E-01],
	[2.7590000000E+04, 4.9552834235E+01, 1.4240537254E+01, 1.3008889791E+01, 5.9782489537E+00, 8.9446093883E-01],
	[2.7595000000E+04, 4.9567319651E+01, 1.4240445941E+01, 1.3016511640E+01, 5.9800528722E+00, 8.9451124453E-01],
	[2.7600000000E+04, 4.9581806675E+01, 1.4240354644E+01, 1.3024136571E+01, 5.9818565476E+00, 8.9456152630E-01],
	[2.7605000000E+04, 4.9596295309E+01, 1.4240263365E+01, 1.3031764584E+01, 5.9836599797E+00, 8.9461178415E-01],
	[2.7610000000E+04, 4.9610785551E+01, 1.4240172103E+01, 1.3039395680E+01, 5.9854631682E+00, 8.9466201808E-01],
	[2.7615000000E+04, 4.9625308650E+01, 1.4240085917E+01, 1.3047029860E+01, 5.9872674621E+00, 8.9471222811E-01],
	[2.7620000000E+04, 4.9639861550E+01, 1.4240004306E+01, 1.3054667124E+01, 5.9890727300E+00, 8.9476241424E-01],
	[2.7625000000E+04, 4.9654416083E+01, 1.4239922711E+01, 1.3062307473E+01, 5.9908777560E+00, 8.9481257649E-01],
	[2.7630000000E+04, 4.9668972247E+01, 1.4239841131E+01, 1.3069950908E+01, 5.9926825398E+00, 8.9486271485E-01],
	[2.7635000000E+04, 4.9683530044E+01, 1.4239759566E+01, 1.3077597429E+01, 5.9944870813E+00, 8.9491282935E-01],
	[2.7640000000E+04, 4.9698089472E+01, 1.4239678016E+01, 1.3085247038E+01, 5.9962913803E+00, 8.9496291999E-01],
	[2.7645000000E+04, 4.9712650533E+01, 1.4239596482E+01, 1.3092899734E+01, 5.9980954365E+00, 8.9501298678E-01],
	[2.7650000000E+04, 4.9727213225E+01, 1.4239514963E+01, 1.3100555518E+01, 5.9998992499E+00, 8.9506302974E-01],
	[2.7655000000E+04, 4.9741777549E+01, 1.4239433459E+01, 1.3108214392E+01, 6.0017028202E+00, 8.9511304886E-01],
	[2.7660000000E+04, 4.9756343504E+01, 1.4239351970E+01, 1.3115876356E+01, 6.0035061472E+00, 8.9516304416E-01],
	[2.7665000000E+04, 4.9770911091E+01, 1.4239270496E+01, 1.3123541410E+01, 6.0053092308E+00, 8.9521301564E-01],
	[2.7670000000E+04, 4.9785480309E+01, 1.4239189038E+01, 1.3131209556E+01, 6.0071120707E+00, 8.9526296333E-01],
	[2.7675000000E+04, 4.9800051158E+01, 1.4239107595E+01, 1.3138880793E+01, 6.0089146667E+00, 8.9531288722E-01],
	[2.7680000000E+04, 4.9814623638E+01, 1.4239026167E+01, 1.3146555123E+01, 6.0107170188E+00, 8.9536278733E-01],
	[2.7685000000E+04, 4.9829197750E+01, 1.4238944754E+01, 1.3154232546E+01, 6.0125191267E+00, 8.9541266366E-01],
	[2.7690000000E+04, 4.9843773492E+01, 1.4238863356E+01, 1.3161913064E+01, 6.0143209901E+00, 8.9546251623E-01],
	[2.7695000000E+04, 4.9858350865E+01, 1.4238781974E+01, 1.3169596675E+01, 6.0161226090E+00, 8.9551234505E-01],
	[2.7700000000E+04, 4.9872929868E+01, 1.4238700607E+01, 1.3177283383E+01, 6.0179239831E+00, 8.9556215011E-01],
	[2.7705000000E+04, 4.9887510502E+01, 1.4238619254E+01, 1.3184973186E+01, 6.0197251123E+00, 8.9561193144E-01],
	[2.7710000000E+04, 4.9902092767E+01, 1.4238537917E+01, 1.3192666086E+01, 6.0215259963E+00, 8.9566168905E-01],
	[2.7715000000E+04, 4.9916676661E+01, 1.4238456595E+01, 1.3200362083E+01, 6.0233266350E+00, 8.9571142293E-01],
	[2.7720000000E+04, 4.9931262186E+01, 1.4238375289E+01, 1.3208061179E+01, 6.0251270282E+00, 8.9576113311E-01],
	[2.7725000000E+04, 4.9945849341E+01, 1.4238293997E+01, 1.3215763373E+01, 6.0269271757E+00, 8.9581081959E-01],
	[2.7730000000E+04, 4.9960438126E+01, 1.4238212720E+01, 1.3223468667E+01, 6.0287270774E+00, 8.9586048238E-01],
	[2.7735000000E+04, 4.9975028541E+01, 1.4238131459E+01, 1.3231177061E+01, 6.0305267330E+00, 8.9591012148E-01],
	[2.7740000000E+04, 4.9989620586E+01, 1.4238050213E+01, 1.3238888555E+01, 6.0323261423E+00, 8.9595973692E-01],
	[2.7745000000E+04, 5.0004214260E+01, 1.4237968982E+01, 1.3246603152E+01, 6.0341253052E+00, 8.9600932869E-01],
	[2.7750000000E+04, 5.0018809563E+01, 1.4237887765E+01, 1.3254320850E+01, 6.0359242215E+00, 8.9605889682E-01],
	[2.7755000000E+04, 5.0033406496E+01, 1.4237806564E+01, 1.3262041651E+01, 6.0377228910E+00, 8.9610844130E-01],
	[2.7760000000E+04, 5.0048005059E+01, 1.4237725379E+01, 1.3269765556E+01, 6.0395213135E+00, 8.9615796215E-01],
	[2.7765000000E+04, 5.0062605250E+01, 1.4237644208E+01, 1.3277492566E+01, 6.0413194889E+00, 8.9620745937E-01],
	[2.7770000000E+04, 5.0077207071E+01, 1.4237563052E+01, 1.3285222680E+01, 6.0431174169E+00, 8.9625693298E-01],
	[2.7775000000E+04, 5.0091810520E+01, 1.4237481911E+01, 1.3292955900E+01, 6.0449150974E+00, 8.9630638298E-01],
	[2.7780000000E+04, 5.0106415599E+01, 1.4237400786E+01, 1.3300692226E+01, 6.0467125302E+00, 8.9635580939E-01],
	[2.7785000000E+04, 5.0121022306E+01, 1.4237319675E+01, 1.3308431659E+01, 6.0485097150E+00, 8.9640521222E-01],
	[2.7790000000E+04, 5.0135630642E+01, 1.4237238580E+01, 1.3316174200E+01, 6.0503066519E+00, 8.9645459146E-01],
	[2.7795000000E+04, 5.0150240606E+01, 1.4237157499E+01, 1.3323919849E+01, 6.0521033404E+00, 8.9650394714E-01],
	[2.7800000000E+04, 5.0164852199E+01, 1.4237076434E+01, 1.3331668607E+01, 6.0538997805E+00, 8.9655327927E-01],
	[2.7805000000E+04, 5.0179465420E+01, 1.4236995384E+01, 1.3339420476E+01, 6.0556959720E+00, 8.9660258784E-01],
	[2.7810000000E+04, 5.0194080269E+01, 1.4236914348E+01, 1.3347175454E+01, 6.0574919147E+00, 8.9665187288E-01],
	[2.7815000000E+04, 5.0208696746E+01, 1.4236833328E+01, 1.3354933544E+01, 6.0592876084E+00, 8.9670113439E-01],
	[2.7820000000E+04, 5.0223314851E+01, 1.4236752323E+01, 1.3362694746E+01, 6.0610830529E+00, 8.9675037237E-01],
	[2.7825000000E+04, 5.0237934584E+01, 1.4236671332E+01, 1.3370459060E+01, 6.0628782481E+00, 8.9679958685E-01],
	[2.7830000000E+04, 5.0252555945E+01, 1.4236590357E+01, 1.3378226487E+01, 6.0646731938E+00, 8.9684877783E-01],
	[2.7835000000E+04, 5.0267178933E+01, 1.4236509397E+01, 1.3385997028E+01, 6.0664678898E+00, 8.9689794531E-01],
	[2.7840000000E+04, 5.0281803549E+01, 1.4236428452E+01, 1.3393770684E+01, 6.0682623358E+00, 8.9694708932E-01],
	[2.7845000000E+04, 5.0296429792E+01, 1.4236347522E+01, 1.3401547455E+01, 6.0700565319E+00, 8.9699620985E-01],
	[2.7850000000E+04, 5.0311057662E+01, 1.4236266606E+01, 1.3409327342E+01, 6.0718504776E+00, 8.9704530692E-01],
	[2.7855000000E+04, 5.0325687160E+01, 1.4236185706E+01, 1.3417110346E+01, 6.0736441730E+00, 8.9709438054E-01],
	[2.7860000000E+04, 5.0340318285E+01, 1.4236104821E+01, 1.3424896467E+01, 6.0754376177E+00, 8.9714343071E-01],
	[2.7865000000E+04, 5.0354951036E+01, 1.4236023951E+01, 1.3432685706E+01, 6.0772308117E+00, 8.9719245745E-01],
	[2.7870000000E+04, 5.0369585415E+01, 1.4235943095E+01, 1.3440478064E+01, 6.0790237547E+00, 8.9724146077E-01],
	[2.7875000000E+04, 5.0384221420E+01, 1.4235862255E+01, 1.3448273541E+01, 6.0808164465E+00, 8.9729044067E-01],
	[2.7880000000E+04, 5.0398859052E+01, 1.4235781430E+01, 1.3456072138E+01, 6.0826088870E+00, 8.9733939716E-01],
	[2.7885000000E+04, 5.0413498310E+01, 1.4235700619E+01, 1.3463873856E+01, 6.0844010761E+00, 8.9738833026E-01],
	[2.7890000000E+04, 5.0428139195E+01, 1.4235619824E+01, 1.3471678695E+01, 6.0861930134E+00, 8.9743723998E-01],
	[2.7895000000E+04, 5.0442781706E+01, 1.4235539043E+01, 1.3479486657E+01, 6.0879846989E+00, 8.9748612631E-01],
	[2.7900000000E+04, 5.0457425843E+01, 1.4235458277E+01, 1.3487297741E+01, 6.0897761324E+00, 8.9753498928E-01],
	[2.7905000000E+04, 5.0472071606E+01, 1.4235377527E+01, 1.3495111949E+01, 6.0915673137E+00, 8.9758382889E-01],
	[2.7910000000E+04, 5.0486718996E+01, 1.4235296791E+01, 1.3502929282E+01, 6.0933582426E+00, 8.9763264516E-01],
	[2.7915000000E+04, 5.0501368011E+01, 1.4235216070E+01, 1.3510749739E+01, 6.0951489189E+00, 8.9768143808E-01],
	[2.7920000000E+04, 5.0516018651E+01, 1.4235135364E+01, 1.3518573321E+01, 6.0969393425E+00, 8.9773020768E-01],
	[2.7925000000E+04, 5.0530670918E+01, 1.4235054673E+01, 1.3526400030E+01, 6.0987295131E+00, 8.9777895395E-01],
	[2.7930000000E+04, 5.0545324810E+01, 1.4234973997E+01, 1.3534229866E+01, 6.1005194307E+00, 8.9782767692E-01],
	[2.7935000000E+04, 5.0559980327E+01, 1.4234893336E+01, 1.3542062830E+01, 6.1023090950E+00, 8.9787637659E-01],
	[2.7940000000E+04, 5.0574637470E+01, 1.4234812690E+01, 1.3549898922E+01, 6.1040985058E+00, 8.9792505296E-01],
	[2.7945000000E+04, 5.0589296237E+01, 1.4234732058E+01, 1.3557738142E+01, 6.1058876631E+00, 8.9797370606E-01],
	[2.7950000000E+04, 5.0603956630E+01, 1.4234651442E+01, 1.3565580493E+01, 6.1076765665E+00, 8.9802233588E-01],
	[2.7955000000E+04, 5.0618618648E+01, 1.4234570840E+01, 1.3573425974E+01, 6.1094652160E+00, 8.9807094244E-01],
	[2.7960000000E+04, 5.0633282291E+01, 1.4234490253E+01, 1.3581274586E+01, 6.1112536113E+00, 8.9811952575E-01],
	[2.7965000000E+04, 5.0647947558E+01, 1.4234409681E+01, 1.3589126330E+01, 6.1130417523E+00, 8.9816808581E-01],
	[2.7970000000E+04, 5.0662614450E+01, 1.4234329124E+01, 1.3596981207E+01, 6.1148296388E+00, 8.9821662264E-01],
	[2.7975000000E+04, 5.0677282966E+01, 1.4234248582E+01, 1.3604839216E+01, 6.1166172706E+00, 8.9826513625E-01],
	[2.7980000000E+04, 5.0691953107E+01, 1.4234168054E+01, 1.3612700359E+01, 6.1184046476E+00, 8.9831362665E-01],
	[2.7985000000E+04, 5.0706624873E+01, 1.4234087542E+01, 1.3620564637E+01, 6.1201917695E+00, 8.9836209384E-01],
	[2.7990000000E+04, 5.0721298262E+01, 1.4234007044E+01, 1.3628432051E+01, 6.1219786363E+00, 8.9841053783E-01],
	[2.7995000000E+04, 5.0735973275E+01, 1.4233926561E+01, 1.3636302600E+01, 6.1237652477E+00, 8.9845895864E-01],
	[2.8000000000E+04, 5.0750649913E+01, 1.4233846093E+01, 1.3644176285E+01, 6.1255516035E+00, 8.9850735627E-01],
	[2.8005000000E+04, 5.0765328174E+01, 1.4233765640E+01, 1.3652053108E+01, 6.1273377037E+00, 8.9855573074E-01],
	[2.8010000000E+04, 5.0780008059E+01, 1.4233685202E+01, 1.3659933069E+01, 6.1291235479E+00, 8.9860408205E-01],
	[2.8015000000E+04, 5.0794689568E+01, 1.4233604778E+01, 1.3667816169E+01, 6.1309091361E+00, 8.9865241022E-01],
	[2.8020000000E+04, 5.0809372700E+01, 1.4233524369E+01, 1.3675702408E+01, 6.1326944680E+00, 8.9870071525E-01],
	[2.8025000000E+04, 5.0824057455E+01, 1.4233443975E+01, 1.3683591787E+01, 6.1344795436E+00, 8.9874899714E-01],
	[2.8030000000E+04, 5.0838743834E+01, 1.4233363596E+01, 1.3691484306E+01, 6.1362643626E+00, 8.9879725593E-01],
	[2.8035000000E+04, 5.0853431836E+01, 1.4233283232E+01, 1.3699379967E+01, 6.1380489248E+00, 8.9884549160E-01],
	[2.8040000000E+04, 5.0868121461E+01, 1.4233202882E+01, 1.3707278771E+01, 6.1398332301E+00, 8.9889370417E-01],
	[2.8045000000E+04, 5.0882812709E+01, 1.4233122547E+01, 1.3715180717E+01, 6.1416172783E+00, 8.9894189366E-01],
	[2.8050000000E+04, 5.0897505580E+01, 1.4233042227E+01, 1.3723085806E+01, 6.1434010692E+00, 8.9899006007E-01],
	[2.8055000000E+04, 5.0912200074E+01, 1.4232961922E+01, 1.3730994040E+01, 6.1451846027E+00, 8.9903820340E-01],
	[2.8060000000E+04, 5.0926932980E+01, 1.4232887506E+01, 1.3738905418E+01, 6.1469695103E+00, 8.9908632368E-01],
	[2.8065000000E+04, 5.0941689927E+01, 1.4232816681E+01, 1.3746819942E+01, 6.1487551554E+00, 8.9913442091E-01],
	[2.8070000000E+04, 5.0956448520E+01, 1.4232745868E+01, 1.3754737613E+01, 6.1505405446E+00, 8.9918249509E-01],
	[2.8075000000E+04, 5.0971208758E+01, 1.4232675068E+01, 1.3762658430E+01, 6.1523256778E+00, 8.9923054624E-01],
	[2.8080000000E+04, 5.0985970643E+01, 1.4232604281E+01, 1.3770582395E+01, 6.1541105548E+00, 8.9927857438E-01],
	[2.8085000000E+04, 5.1000734174E+01, 1.4232533507E+01, 1.3778509508E+01, 6.1558951754E+00, 8.9932657950E-01],
	[2.8090000000E+04, 5.1015499350E+01, 1.4232462746E+01, 1.3786439770E+01, 6.1576795395E+00, 8.9937456161E-01],
	[2.8095000000E+04, 5.1030266172E+01, 1.4232391998E+01, 1.3794373182E+01, 6.1594636469E+00, 8.9942252074E-01],
	[2.8100000000E+04, 5.1045034639E+01, 1.4232321263E+01, 1.3802309744E+01, 6.1612474974E+00, 8.9947045688E-01],
	[2.8105000000E+04, 5.1059804752E+01, 1.4232250541E+01, 1.3810249457E+01, 6.1630310909E+00, 8.9951837005E-01],
	[2.8110000000E+04, 5.1074576509E+01, 1.4232179832E+01, 1.3818192322E+01, 6.1648144272E+00, 8.9956626026E-01],
	[2.8115000000E+04, 5.1089349912E+01, 1.4232109135E+01, 1.3826138340E+01, 6.1665975060E+00, 8.9961412751E-01],
	[2.8120000000E+04, 5.1104124960E+01, 1.4232038452E+01, 1.3834087511E+01, 6.1683803274E+00, 8.9966197181E-01],
	[2.8125000000E+04, 5.1118901653E+01, 1.4231967782E+01, 1.3842039835E+01, 6.1701628910E+00, 8.9970979319E-01],
	[2.8130000000E+04, 5.1133679991E+01, 1.4231897124E+01, 1.3849995314E+01, 6.1719451967E+00, 8.9975759163E-01],
	[2.8135000000E+04, 5.1148459973E+01, 1.4231826480E+01, 1.3857953948E+01, 6.1737272444E+00, 8.9980536717E-01],
	[2.8140000000E+04, 5.1163241600E+01, 1.4231755848E+01, 1.3865915738E+01, 6.1755090339E+00, 8.9985311979E-01],
	[2.8145000000E+04, 5.1178024871E+01, 1.4231685229E+01, 1.3873880685E+01, 6.1772905649E+00, 8.9990084952E-01],
	[2.8150000000E+04, 5.1192809787E+01, 1.4231614623E+01, 1.3881848788E+01, 6.1790718374E+00, 8.9994855637E-01],
	[2.8155000000E+04, 5.1207596346E+01, 1.4231544030E+01, 1.3889820050E+01, 6.1808528512E+00, 8.9999624034E-01],
	[2.8160000000E+04, 5.1222384550E+01, 1.4231473450E+01, 1.3897794471E+01, 6.1826336061E+00, 9.0004390144E-01],
	[2.8165000000E+04, 5.1237174399E+01, 1.4231402883E+01, 1.3905772050E+01, 6.1844141019E+00, 9.0009153968E-01],
	[2.8170000000E+04, 5.1251965890E+01, 1.4231332328E+01, 1.3913752790E+01, 6.1861943385E+00, 9.0013915508E-01],
	[2.8175000000E+04, 5.1266759026E+01, 1.4231261787E+01, 1.3921736691E+01, 6.1879743157E+00, 9.0018674763E-01],
	[2.8180000000E+04, 5.1281553806E+01, 1.4231191258E+01, 1.3929723752E+01, 6.1897540333E+00, 9.0023431735E-01],
	[2.8185000000E+04, 5.1296350229E+01, 1.4231120742E+01, 1.3937713976E+01, 6.1915334912E+00, 9.0028186425E-01],
	[2.8190000000E+04, 5.1311148295E+01, 1.4231050240E+01, 1.3945707363E+01, 6.1933126892E+00, 9.0032938834E-01],
	[2.8195000000E+04, 5.1325948005E+01, 1.4230979749E+01, 1.3953703913E+01, 6.1950916271E+00, 9.0037688962E-01],
	[2.8200000000E+04, 5.1340749358E+01, 1.4230909272E+01, 1.3961703628E+01, 6.1968703048E+00, 9.0042436811E-01],
	[2.8205000000E+04, 5.1355552355E+01, 1.4230838808E+01, 1.3969706507E+01, 6.1986487222E+00, 9.0047182380E-01],
	[2.8210000000E+04, 5.1370356994E+01, 1.4230768356E+01, 1.3977712552E+01, 6.2004268789E+00, 9.0051925672E-01],
	[2.8215000000E+04, 5.1385163276E+01, 1.4230697918E+01, 1.3985721763E+01, 6.2022047750E+00, 9.0056666687E-01],
	[2.8220000000E+04, 5.1399971201E+01, 1.4230627492E+01, 1.3993734141E+01, 6.2039824101E+00, 9.0061405426E-01],
	[2.8225000000E+04, 5.1414780769E+01, 1.4230557079E+01, 1.4001749686E+01, 6.2057597842E+00, 9.0066141889E-01],
	[2.8230000000E+04, 5.1429591980E+01, 1.4230486678E+01, 1.4009768400E+01, 6.2075368971E+00, 9.0070876078E-01],
	[2.8235000000E+04, 5.1444404833E+01, 1.4230416291E+01, 1.4017790283E+01, 6.2093137486E+00, 9.0075607994E-01],
	[2.8240000000E+04, 5.1459219328E+01, 1.4230345916E+01, 1.4025815335E+01, 6.2110903385E+00, 9.0080337637E-01],
	[2.8245000000E+04, 5.1474035466E+01, 1.4230275555E+01, 1.4033843558E+01, 6.2128666668E+00, 9.0085065008E-01],
	[2.8250000000E+04, 5.1488853245E+01, 1.4230205206E+01, 1.4041874952E+01, 6.2146427331E+00, 9.0089790109E-01],
	[2.8255000000E+04, 5.1503672667E+01, 1.4230134870E+01, 1.4049909517E+01, 6.2164185375E+00, 9.0094512939E-01],
	[2.8260000000E+04, 5.1518493731E+01, 1.4230064546E+01, 1.4057947255E+01, 6.2181940796E+00, 9.0099233501E-01],
	[2.8265000000E+04, 5.1533316437E+01, 1.4229994236E+01, 1.4065988167E+01, 6.2199693593E+00, 9.0103951794E-01],
	[2.8270000000E+04, 5.1548140784E+01, 1.4229923938E+01, 1.4074032252E+01, 6.2217443766E+00, 9.0108667821E-01],
	[2.8275000000E+04, 5.1562966773E+01, 1.4229853653E+01, 1.4082079511E+01, 6.2235191311E+00, 9.0113381580E-01],
	[2.8280000000E+04, 5.1577794404E+01, 1.4229783380E+01, 1.4090129946E+01, 6.2252936228E+00, 9.0118093075E-01],
	[2.8285000000E+04, 5.1592623675E+01, 1.4229713121E+01, 1.4098183556E+01, 6.2270678515E+00, 9.0122802304E-01],
	[2.8290000000E+04, 5.1607454589E+01, 1.4229642874E+01, 1.4106240343E+01, 6.2288418169E+00, 9.0127509270E-01],
	[2.8295000000E+04, 5.1622287143E+01, 1.4229572640E+01, 1.4114300308E+01, 6.2306155191E+00, 9.0132213973E-01],
	[2.8300000000E+04, 5.1637121339E+01, 1.4229502419E+01, 1.4122363450E+01, 6.2323889578E+00, 9.0136916415E-01],
	[2.8305000000E+04, 5.1651957175E+01, 1.4229432210E+01, 1.4130429771E+01, 6.2341621327E+00, 9.0141616595E-01],
	[2.8310000000E+04, 5.1666794653E+01, 1.4229362015E+01, 1.4138499271E+01, 6.2359350439E+00, 9.0146314515E-01],
	[2.8315000000E+04, 5.1681633771E+01, 1.4229291832E+01, 1.4146571952E+01, 6.2377076911E+00, 9.0151010175E-01],
	[2.8320000000E+04, 5.1696474529E+01, 1.4229221662E+01, 1.4154647813E+01, 6.2394800741E+00, 9.0155703578E-01],
	[2.8325000000E+04, 5.1711316929E+01, 1.4229151504E+01, 1.4162726855E+01, 6.2412521928E+00, 9.0160394723E-01],
	[2.8330000000E+04, 5.1726160969E+01, 1.4229081359E+01, 1.4170809080E+01, 6.2430240471E+00, 9.0165083611E-01],
	[2.8335000000E+04, 5.1741006649E+01, 1.4229011227E+01, 1.4178894487E+01, 6.2447956367E+00, 9.0169770243E-01],
	[2.8340000000E+04, 5.1755853969E+01, 1.4228941108E+01, 1.4186983078E+01, 6.2465669615E+00, 9.0174454621E-01],
	[2.8345000000E+04, 5.1770702929E+01, 1.4228871001E+01, 1.4195074853E+01, 6.2483380214E+00, 9.0179136745E-01],
	[2.8350000000E+04, 5.1785553530E+01, 1.4228800907E+01, 1.4203169813E+01, 6.2501088162E+00, 9.0183816616E-01],
	[2.8355000000E+04, 5.1800405770E+01, 1.4228730826E+01, 1.4211267958E+01, 6.2518793457E+00, 9.0188494234E-01],
	[2.8360000000E+04, 5.1815259650E+01, 1.4228660758E+01, 1.4219369289E+01, 6.2536496097E+00, 9.0193169602E-01],
	[2.8365000000E+04, 5.1830115170E+01, 1.4228590702E+01, 1.4227473808E+01, 6.2554196082E+00, 9.0197842719E-01],
	[2.8370000000E+04, 5.1844972329E+01, 1.4228520659E+01, 1.4235581514E+01, 6.2571893410E+00, 9.0202513586E-01],
	[2.8375000000E+04, 5.1859831128E+01, 1.4228450628E+01, 1.4243692409E+01, 6.2589588078E+00, 9.0207182205E-01],
	[2.8380000000E+04, 5.1874691566E+01, 1.4228380611E+01, 1.4251806492E+01, 6.2607280086E+00, 9.0211848577E-01],
	[2.8385000000E+04, 5.1889553644E+01, 1.4228310606E+01, 1.4259923765E+01, 6.2624969431E+00, 9.0216512701E-01],
	[2.8390000000E+04, 5.1904417360E+01, 1.4228240613E+01, 1.4268044229E+01, 6.2642656113E+00, 9.0221174580E-01],
	[2.8395000000E+04, 5.1919282716E+01, 1.4228170633E+01, 1.4276167883E+01, 6.2660340129E+00, 9.0225834214E-01],
	[2.8400000000E+04, 5.1934149711E+01, 1.4228100666E+01, 1.4284294729E+01, 6.2678021478E+00, 9.0230491604E-01],
	[2.8405000000E+04, 5.1949018344E+01, 1.4228030712E+01, 1.4292424768E+01, 6.2695700159E+00, 9.0235146750E-01],
	[2.8410000000E+04, 5.1963888616E+01, 1.4227960770E+01, 1.4300558000E+01, 6.2713376170E+00, 9.0239799654E-01],
	[2.8415000000E+04, 5.1978760527E+01, 1.4227890841E+01, 1.4308694426E+01, 6.2731049508E+00, 9.0244450317E-01],
	[2.8420000000E+04, 5.1993634076E+01, 1.4227820925E+01, 1.4316834046E+01, 6.2748720174E+00, 9.0249098740E-01],
	[2.8425000000E+04, 5.2008509263E+01, 1.4227751021E+01, 1.4324976862E+01, 6.2766388165E+00, 9.0253744923E-01],
	[2.8430000000E+04, 5.2023386089E+01, 1.4227681130E+01, 1.4333122873E+01, 6.2784053479E+00, 9.0258388867E-01],
	[2.8435000000E+04, 5.2038264553E+01, 1.4227611251E+01, 1.4341272081E+01, 6.2801716116E+00, 9.0263030573E-01],
	[2.8440000000E+04, 5.2053144655E+01, 1.4227541385E+01, 1.4349424486E+01, 6.2819376073E+00, 9.0267670043E-01],
	[2.8445000000E+04, 5.2068026395E+01, 1.4227471532E+01, 1.4357580089E+01, 6.2837033348E+00, 9.0272307276E-01],
	[2.8450000000E+04, 5.2082909773E+01, 1.4227401692E+01, 1.4365738891E+01, 6.2854687942E+00, 9.0276942275E-01],
	[2.8455000000E+04, 5.2097794788E+01, 1.4227331864E+01, 1.4373900892E+01, 6.2872339851E+00, 9.0281575039E-01],
	[2.8460000000E+04, 5.2112681442E+01, 1.4227262048E+01, 1.4382066094E+01, 6.2889989074E+00, 9.0286205570E-01],
	[2.8465000000E+04, 5.2127569732E+01, 1.4227192245E+01, 1.4390234496E+01, 6.2907635610E+00, 9.0290833869E-01],
	[2.8470000000E+04, 5.2142459660E+01, 1.4227122455E+01, 1.4398406099E+01, 6.2925279457E+00, 9.0295459936E-01],
	[2.8475000000E+04, 5.2157351226E+01, 1.4227052678E+01, 1.4406580905E+01, 6.2942920613E+00, 9.0300083773E-01],
	[2.8480000000E+04, 5.2172244428E+01, 1.4226982913E+01, 1.4414758913E+01, 6.2960559078E+00, 9.0304705380E-01],
	[2.8485000000E+04, 5.2187139268E+01, 1.4226913160E+01, 1.4422940125E+01, 6.2978194849E+00, 9.0309324758E-01],
	[2.8490000000E+04, 5.2202035745E+01, 1.4226843420E+01, 1.4431124541E+01, 6.2995827925E+00, 9.0313941909E-01],
	[2.8495000000E+04, 5.2216933858E+01, 1.4226773693E+01, 1.4439312162E+01, 6.3013458304E+00, 9.0318556832E-01],
	[2.8500000000E+04, 5.2231833609E+01, 1.4226703978E+01, 1.4447502989E+01, 6.3031085986E+00, 9.0323169530E-01],
	[2.8505000000E+04, 5.2246734996E+01, 1.4226634276E+01, 1.4455697022E+01, 6.3048710967E+00, 9.0327780002E-01],
	[2.8510000000E+04, 5.2261654878E+01, 1.4226567243E+01, 1.4463894261E+01, 6.3066340923E+00, 9.0332388250E-01],
	[2.8515000000E+04, 5.2276618499E+01, 1.4226506853E+01, 1.4472094709E+01, 6.3083987350E+00, 9.0336994275E-01],
	[2.8520000000E+04, 5.2291583779E+01, 1.4226446474E+01, 1.4480298364E+01, 6.3101631093E+00, 9.0341598077E-01],
	[2.8525000000E+04, 5.2306550718E+01, 1.4226386105E+01, 1.4488505229E+01, 6.3119272151E+00, 9.0346199658E-01],
	[2.8530000000E+04, 5.2321519317E+01, 1.4226325748E+01, 1.4496715304E+01, 6.3136910522E+00, 9.0350799018E-01],
	[2.8535000000E+04, 5.2336489576E+01, 1.4226265401E+01, 1.4504928589E+01, 6.3154546205E+00, 9.0355396159E-01],
	[2.8540000000E+04, 5.2351461494E+01, 1.4226205065E+01, 1.4513145085E+01, 6.3172179198E+00, 9.0359991081E-01],
	[2.8545000000E+04, 5.2366435070E+01, 1.4226144740E+01, 1.4521364793E+01, 6.3189809500E+00, 9.0364583784E-01],
	[2.8550000000E+04, 5.2381410306E+01, 1.4226084426E+01, 1.4529587713E+01, 6.3207437109E+00, 9.0369174271E-01],
	[2.8555000000E+04, 5.2396387201E+01, 1.4226024122E+01, 1.4537813846E+01, 6.3225062023E+00, 9.0373762542E-01],
	[2.8560000000E+04, 5.2411365755E+01, 1.4225963829E+01, 1.4546043194E+01, 6.3242684242E+00, 9.0378348598E-01],
	[2.8565000000E+04, 5.2426345967E+01, 1.4225903548E+01, 1.4554275756E+01, 6.3260303763E+00, 9.0382932439E-01],
	[2.8570000000E+04, 5.2441327838E+01, 1.4225843277E+01, 1.4562511533E+01, 6.3277920585E+00, 9.0387514068E-01],
	[2.8575000000E+04, 5.2456311368E+01, 1.4225783016E+01, 1.4570750526E+01, 6.3295534706E+00, 9.0392093483E-01],
	[2.8580000000E+04, 5.2471296556E+01, 1.4225722767E+01, 1.4578992736E+01, 6.3313146126E+00, 9.0396670688E-01],
	[2.8585000000E+04, 5.2486283402E+01, 1.4225662528E+01, 1.4587238163E+01, 6.3330754842E+00, 9.0401245681E-01],
	[2.8590000000E+04, 5.2501271907E+01, 1.4225602300E+01, 1.4595486808E+01, 6.3348360854E+00, 9.0405818465E-01],
	[2.8595000000E+04, 5.2516262069E+01, 1.4225542083E+01, 1.4603738672E+01, 6.3365964158E+00, 9.0410389040E-01],
	[2.8600000000E+04, 5.2531253890E+01, 1.4225481877E+01, 1.4611993755E+01, 6.3383564755E+00, 9.0414957408E-01],
	[2.8605000000E+04, 5.2546247368E+01, 1.4225421681E+01, 1.4620252058E+01, 6.3401162642E+00, 9.0419523568E-01],
	[2.8610000000E+04, 5.2561242504E+01, 1.4225361497E+01, 1.4628513583E+01, 6.3418757818E+00, 9.0424087523E-01],
	[2.8615000000E+04, 5.2576239298E+01, 1.4225301323E+01, 1.4636778328E+01, 6.3436350282E+00, 9.0428649272E-01],
	[2.8620000000E+04, 5.2591237749E+01, 1.4225241160E+01, 1.4645046296E+01, 6.3453940031E+00, 9.0433208817E-01],
	[2.8625000000E+04, 5.2606237858E+01, 1.4225181007E+01, 1.4653317487E+01, 6.3471527066E+00, 9.0437766159E-01],
	[2.8630000000E+04, 5.2621239624E+01, 1.4225120865E+01, 1.4661591901E+01, 6.3489111383E+00, 9.0442321298E-01],
	[2.8635000000E+04, 5.2636243048E+01, 1.4225060734E+01, 1.4669869539E+01, 6.3506692981E+00, 9.0446874236E-01],
	[2.8640000000E+04, 5.2651248128E+01, 1.4225000614E+01, 1.4678150403E+01, 6.3524271860E+00, 9.0451424973E-01],
	[2.8645000000E+04, 5.2666254866E+01, 1.4224940505E+01, 1.4686434492E+01, 6.3541848017E+00, 9.0455973511E-01],
	[2.8650000000E+04, 5.2681263260E+01, 1.4224880406E+01, 1.4694721807E+01, 6.3559421452E+00, 9.0460519850E-01],
	[2.8655000000E+04, 5.2696273312E+01, 1.4224820318E+01, 1.4703012349E+01, 6.3576992161E+00, 9.0465063991E-01],
	[2.8660000000E+04, 5.2711285020E+01, 1.4224760241E+01, 1.4711306119E+01, 6.3594560145E+00, 9.0469605935E-01],
	[2.8665000000E+04, 5.2726298384E+01, 1.4224700175E+01, 1.4719603118E+01, 6.3612125402E+00, 9.0474145683E-01],
	[2.8670000000E+04, 5.2741313405E+01, 1.4224640119E+01, 1.4727903345E+01, 6.3629687930E+00, 9.0478683237E-01],
	[2.8675000000E+04, 5.2756330083E+01, 1.4224580074E+01, 1.4736206803E+01, 6.3647247727E+00, 9.0483218596E-01],
	[2.8680000000E+04, 5.2771348417E+01, 1.4224520040E+01, 1.4744513490E+01, 6.3664804793E+00, 9.0487751762E-01],
	[2.8685000000E+04, 5.2786368407E+01, 1.4224460016E+01, 1.4752823409E+01, 6.3682359125E+00, 9.0492282735E-01],
	[2.8690000000E+04, 5.2801390053E+01, 1.4224400003E+01, 1.4761136560E+01, 6.3699910722E+00, 9.0496811517E-01],
	[2.8695000000E+04, 5.2816413354E+01, 1.4224340001E+01, 1.4769452943E+01, 6.3717459584E+00, 9.0501338109E-01],
	[2.8700000000E+04, 5.2831438312E+01, 1.4224280010E+01, 1.4777772560E+01, 6.3735005707E+00, 9.0505862511E-01],
	[2.8705000000E+04, 5.2846464926E+01, 1.4224220029E+01, 1.4786095411E+01, 6.3752549092E+00, 9.0510384725E-01],
	[2.8710000000E+04, 5.2861493195E+01, 1.4224160059E+01, 1.4794421496E+01, 6.3770089735E+00, 9.0514904750E-01],
	[2.8715000000E+04, 5.2876523120E+01, 1.4224100100E+01, 1.4802750816E+01, 6.3787627637E+00, 9.0519422589E-01],
	[2.8720000000E+04, 5.2891554700E+01, 1.4224040151E+01, 1.4811083373E+01, 6.3805162795E+00, 9.0523938243E-01],
	[2.8725000000E+04, 5.2906587936E+01, 1.4223980213E+01, 1.4819419166E+01, 6.3822695209E+00, 9.0528451711E-01],
	[2.8730000000E+04, 5.2921622826E+01, 1.4223920286E+01, 1.4827758197E+01, 6.3840224875E+00, 9.0532962995E-01],
	[2.8735000000E+04, 5.2936659372E+01, 1.4223860369E+01, 1.4836100465E+01, 6.3857751794E+00, 9.0537472096E-01],
	[2.8740000000E+04, 5.2951697573E+01, 1.4223800463E+01, 1.4844445973E+01, 6.3875275964E+00, 9.0541979015E-01],
	[2.8745000000E+04, 5.2966737429E+01, 1.4223740568E+01, 1.4852794720E+01, 6.3892797383E+00, 9.0546483752E-01],
	[2.8750000000E+04, 5.2981778939E+01, 1.4223680683E+01, 1.4861146707E+01, 6.3910316049E+00, 9.0550986309E-01],
	[2.8755000000E+04, 5.2996822104E+01, 1.4223620810E+01, 1.4869501935E+01, 6.3927831962E+00, 9.0555486687E-01],
	[2.8760000000E+04, 5.3011866924E+01, 1.4223560946E+01, 1.4877860404E+01, 6.3945345120E+00, 9.0559984886E-01],
	[2.8765000000E+04, 5.3026913399E+01, 1.4223501094E+01, 1.4886222116E+01, 6.3962855521E+00, 9.0564480908E-01],
	[2.8770000000E+04, 5.3041961527E+01, 1.4223441252E+01, 1.4894587071E+01, 6.3980363164E+00, 9.0568974753E-01],
	[2.8775000000E+04, 5.3057011310E+01, 1.4223381421E+01, 1.4902955269E+01, 6.3997868048E+00, 9.0573466422E-01],
	[2.8780000000E+04, 5.3072062747E+01, 1.4223321600E+01, 1.4911326712E+01, 6.4015370171E+00, 9.0577955916E-01],
	[2.8785000000E+04, 5.3087115839E+01, 1.4223261790E+01, 1.4919701399E+01, 6.4032869531E+00, 9.0582443236E-01],
	[2.8790000000E+04, 5.3102170584E+01, 1.4223201991E+01, 1.4928079333E+01, 6.4050366128E+00, 9.0586928384E-01],
	[2.8795000000E+04, 5.3117226983E+01, 1.4223142202E+01, 1.4936460513E+01, 6.4067859960E+00, 9.0591411359E-01],
	[2.8800000000E+04, 5.3132285035E+01, 1.4223082424E+01, 1.4944844939E+01, 6.4085351025E+00, 9.0595892164E-01],
	[2.8805000000E+04, 5.3147344742E+01, 1.4223022656E+01, 1.4953232614E+01, 6.4102839322E+00, 9.0600370798E-01],
	[2.8810000000E+04, 5.3162406102E+01, 1.4222962900E+01, 1.4961623537E+01, 6.4120324849E+00, 9.0604847262E-01],
	[2.8815000000E+04, 5.3177469115E+01, 1.4222903153E+01, 1.4970017710E+01, 6.4137807606E+00, 9.0609321559E-01],
	[2.8820000000E+04, 5.3192533781E+01, 1.4222843418E+01, 1.4978415132E+01, 6.4155287590E+00, 9.0613793688E-01],
	[2.8825000000E+04, 5.3207600101E+01, 1.4222783693E+01, 1.4986815804E+01, 6.4172764801E+00, 9.0618263650E-01],
	[2.8830000000E+04, 5.3222668074E+01, 1.4222723979E+01, 1.4995219728E+01, 6.4190239237E+00, 9.0622731447E-01],
	[2.8835000000E+04, 5.3237737700E+01, 1.4222664275E+01, 1.5003626904E+01, 6.4207710896E+00, 9.0627197079E-01],
	[2.8840000000E+04, 5.3252808979E+01, 1.4222604582E+01, 1.5012037333E+01, 6.4225179777E+00, 9.0631660548E-01],
	[2.8845000000E+04, 5.3267881911E+01, 1.4222544899E+01, 1.5020451015E+01, 6.4242645878E+00, 9.0636121853E-01],
	[2.8850000000E+04, 5.3282956495E+01, 1.4222485227E+01, 1.5028867951E+01, 6.4260109199E+00, 9.0640580997E-01],
	[2.8855000000E+04, 5.3298032732E+01, 1.4222425566E+01, 1.5037288141E+01, 6.4277569738E+00, 9.0645037980E-01],
	[2.8860000000E+04, 5.3313110621E+01, 1.4222365915E+01, 1.5045711587E+01, 6.4295027493E+00, 9.0649492803E-01],
	[2.8865000000E+04, 5.3328190163E+01, 1.4222306275E+01, 1.5054138290E+01, 6.4312482464E+00, 9.0653945466E-01],
	[2.8870000000E+04, 5.3343271357E+01, 1.4222246645E+01, 1.5062568248E+01, 6.4329934647E+00, 9.0658395972E-01],
	[2.8875000000E+04, 5.3358354203E+01, 1.4222187026E+01, 1.5071001465E+01, 6.4347384044E+00, 9.0662844320E-01],
	[2.8880000000E+04, 5.3373438701E+01, 1.4222127418E+01, 1.5079437939E+01, 6.4364830650E+00, 9.0667290512E-01],
	[2.8885000000E+04, 5.3388524851E+01, 1.4222067820E+01, 1.5087877673E+01, 6.4382274467E+00, 9.0671734548E-01],
	[2.8890000000E+04, 5.3403612653E+01, 1.4222008232E+01, 1.5096320666E+01, 6.4399715491E+00, 9.0676176430E-01],
	[2.8895000000E+04, 5.3418702107E+01, 1.4221948656E+01, 1.5104766919E+01, 6.4417153722E+00, 9.0680616159E-01],
	[2.8900000000E+04, 5.3433793213E+01, 1.4221889089E+01, 1.5113216434E+01, 6.4434589158E+00, 9.0685053735E-01],
	[2.8905000000E+04, 5.3448885970E+01, 1.4221829534E+01, 1.5121669209E+01, 6.4452021799E+00, 9.0689489159E-01],
	[2.8910000000E+04, 5.3463980378E+01, 1.4221769989E+01, 1.5130125248E+01, 6.4469451641E+00, 9.0693922432E-01],
	[2.8915000000E+04, 5.3479076438E+01, 1.4221710454E+01, 1.5138584549E+01, 6.4486878685E+00, 9.0698353556E-01],
	[2.8920000000E+04, 5.3494174148E+01, 1.4221650930E+01, 1.5147047114E+01, 6.4504302928E+00, 9.0702782530E-01],
	[2.8925000000E+04, 5.3509273510E+01, 1.4221591417E+01, 1.5155512943E+01, 6.4521724370E+00, 9.0707209357E-01],
	[2.8930000000E+04, 5.3524374523E+01, 1.4221531914E+01, 1.5163982038E+01, 6.4539143009E+00, 9.0711634037E-01],
	[2.8935000000E+04, 5.3539477187E+01, 1.4221472421E+01, 1.5172454398E+01, 6.4556558843E+00, 9.0716056570E-01],
	[2.8940000000E+04, 5.3554581502E+01, 1.4221412939E+01, 1.5180930025E+01, 6.4573971872E+00, 9.0720476959E-01],
	[2.8945000000E+04, 5.3569687467E+01, 1.4221353468E+01, 1.5189408919E+01, 6.4591382093E+00, 9.0724895203E-01],
	[2.8950000000E+04, 5.3584795083E+01, 1.4221294007E+01, 1.5197891081E+01, 6.4608789506E+00, 9.0729311303E-01],
	[2.8955000000E+04, 5.3599904350E+01, 1.4221234557E+01, 1.5206376512E+01, 6.4626194109E+00, 9.0733725262E-01],
	[2.8960000000E+04, 5.3615015267E+01, 1.4221175117E+01, 1.5214865211E+01, 6.4643595901E+00, 9.0738137079E-01],
	[2.8965000000E+04, 5.3630127834E+01, 1.4221115688E+01, 1.5223357181E+01, 6.4660994880E+00, 9.0742546755E-01],
	[2.8970000000E+04, 5.3645271178E+01, 1.4221060798E+01, 1.5231852422E+01, 6.4678404646E+00, 9.0746954292E-01],
	[2.8975000000E+04, 5.3660445766E+01, 1.4221010516E+01, 1.5240350933E+01, 6.4695825424E+00, 9.0751359690E-01],
	[2.8980000000E+04, 5.3675622027E+01, 1.4220960242E+01, 1.5248852717E+01, 6.4713243406E+00, 9.0755762951E-01],
	[2.8985000000E+04, 5.3690799961E+01, 1.4220909978E+01, 1.5257357774E+01, 6.4730658589E+00, 9.0760164074E-01],
	[2.8990000000E+04, 5.3705979568E+01, 1.4220859722E+01, 1.5265866104E+01, 6.4748070973E+00, 9.0764563062E-01],
	[2.8995000000E+04, 5.3721160847E+01, 1.4220809476E+01, 1.5274377708E+01, 6.4765480557E+00, 9.0768959915E-01],
	[2.9000000000E+04, 5.3736343799E+01, 1.4220759238E+01, 1.5282892587E+01, 6.4782887338E+00, 9.0773354633E-01],
	[2.9005000000E+04, 5.3751528423E+01, 1.4220709009E+01, 1.5291410741E+01, 6.4800291316E+00, 9.0777747219E-01],
	[2.9010000000E+04, 5.3766714720E+01, 1.4220658788E+01, 1.5299932172E+01, 6.4817692489E+00, 9.0782137673E-01],
	[2.9015000000E+04, 5.3781902689E+01, 1.4220608577E+01, 1.5308456880E+01, 6.4835090856E+00, 9.0786525995E-01],
	[2.9020000000E+04, 5.3797092330E+01, 1.4220558374E+01, 1.5316984865E+01, 6.4852486416E+00, 9.0790912187E-01],
	[2.9025000000E+04, 5.3812283643E+01, 1.4220508181E+01, 1.5325516128E+01, 6.4869879167E+00, 9.0795296250E-01],
	[2.9030000000E+04, 5.3827476628E+01, 1.4220457996E+01, 1.5334050671E+01, 6.4887269107E+00, 9.0799678184E-01],
	[2.9035000000E+04, 5.3842671284E+01, 1.4220407819E+01, 1.5342588493E+01, 6.4904656236E+00, 9.0804057991E-01],
	[2.9040000000E+04, 5.3857867613E+01, 1.4220357652E+01, 1.5351129596E+01, 6.4922040553E+00, 9.0808435671E-01],
	[2.9045000000E+04, 5.3873065613E+01, 1.4220307494E+01, 1.5359673979E+01, 6.4939422055E+00, 9.0812811226E-01],
	[2.9050000000E+04, 5.3888265285E+01, 1.4220257344E+01, 1.5368221645E+01, 6.4956800742E+00, 9.0817184656E-01],
	[2.9055000000E+04, 5.3903466628E+01, 1.4220207203E+01, 1.5376772592E+01, 6.4974176612E+00, 9.0821555962E-01],
	[2.9060000000E+04, 5.3918669642E+01, 1.4220157071E+01, 1.5385326823E+01, 6.4991549663E+00, 9.0825925145E-01],
	[2.9065000000E+04, 5.3933874327E+01, 1.4220106948E+01, 1.5393884338E+01, 6.5008919895E+00, 9.0830292207E-01],
	[2.9070000000E+04, 5.3949080684E+01, 1.4220056833E+01, 1.5402445138E+01, 6.5026287307E+00, 9.0834657147E-01],
	[2.9075000000E+04, 5.3964288712E+01, 1.4220006728E+01, 1.5411009222E+01, 6.5043651896E+00, 9.0839019968E-01],
	[2.9080000000E+04, 5.3979498410E+01, 1.4219956631E+01, 1.5419576593E+01, 6.5061013662E+00, 9.0843380670E-01],
	[2.9085000000E+04, 5.3994709780E+01, 1.4219906543E+01, 1.5428147250E+01, 6.5078372603E+00, 9.0847739253E-01],
	[2.9090000000E+04, 5.4009922820E+01, 1.4219856463E+01, 1.5436721195E+01, 6.5095728717E+00, 9.0852095719E-01],
	[2.9095000000E+04, 5.4025137530E+01, 1.4219806393E+01, 1.5445298427E+01, 6.5113082005E+00, 9.0856450069E-01],
	[2.9100000000E+04, 5.4040353911E+01, 1.4219756331E+01, 1.5453878948E+01, 6.5130432463E+00, 9.0860802304E-01],
	[2.9105000000E+04, 5.4055571963E+01, 1.4219706278E+01, 1.5462462759E+01, 6.5147780092E+00, 9.0865152424E-01],
	[2.9110000000E+04, 5.4070791684E+01, 1.4219656234E+01, 1.5471049860E+01, 6.5165124889E+00, 9.0869500431E-01],
	[2.9115000000E+04, 5.4086013076E+01, 1.4219606199E+01, 1.5479640251E+01, 6.5182466853E+00, 9.0873846325E-01],
	[2.9120000000E+04, 5.4101236138E+01, 1.4219556172E+01, 1.5488233934E+01, 6.5199805983E+00, 9.0878190108E-01],
	[2.9125000000E+04, 5.4116460870E+01, 1.4219506154E+01, 1.5496830909E+01, 6.5217142278E+00, 9.0882531779E-01],
	[2.9130000000E+04, 5.4131687272E+01, 1.4219456145E+01, 1.5505431177E+01, 6.5234475736E+00, 9.0886871342E-01],
	[2.9135000000E+04, 5.4146915343E+01, 1.4219406145E+01, 1.5514034739E+01, 6.5251806357E+00, 9.0891208795E-01],
	[2.9140000000E+04, 5.4162145084E+01, 1.4219356153E+01, 1.5522641595E+01, 6.5269134138E+00, 9.0895544141E-01],
	[2.9145000000E+04, 5.4177376495E+01, 1.4219306170E+01, 1.5531251746E+01, 6.5286459078E+00, 9.0899877380E-01],
	[2.9150000000E+04, 5.4192609575E+01, 1.4219256196E+01, 1.5539865192E+01, 6.5303781177E+00, 9.0904208512E-01],
	[2.9155000000E+04, 5.4207844325E+01, 1.4219206231E+01, 1.5548481935E+01, 6.5321100433E+00, 9.0908537540E-01],
	[2.9160000000E+04, 5.4223080743E+01, 1.4219156274E+01, 1.5557101975E+01, 6.5338416844E+00, 9.0912864464E-01],
	[2.9165000000E+04, 5.4238318831E+01, 1.4219106326E+01, 1.5565725313E+01, 6.5355730409E+00, 9.0917189284E-01],
	[2.9170000000E+04, 5.4253558588E+01, 1.4219056387E+01, 1.5574351949E+01, 6.5373041127E+00, 9.0921512001E-01],
	[2.9175000000E+04, 5.4268800014E+01, 1.4219006457E+01, 1.5582981884E+01, 6.5390348997E+00, 9.0925832617E-01],
	[2.9180000000E+04, 5.4284043108E+01, 1.4218956535E+01, 1.5591615119E+01, 6.5407654018E+00, 9.0930151132E-01],
	[2.9185000000E+04, 5.4299287872E+01, 1.4218906622E+01, 1.5600251654E+01, 6.5424956187E+00, 9.0934467547E-01],
	[2.9190000000E+04, 5.4314534304E+01, 1.4218856718E+01, 1.5608891491E+01, 6.5442255504E+00, 9.0938781863E-01],
	[2.9195000000E+04, 5.4329782404E+01, 1.4218806822E+01, 1.5617534630E+01, 6.5459551968E+00, 9.0943094080E-01],
	[2.9200000000E+04, 5.4345032173E+01, 1.4218756936E+01, 1.5626181071E+01, 6.5476845577E+00, 9.0947404200E-01],
	[2.9205000000E+04, 5.4360283610E+01, 1.4218707058E+01, 1.5634830815E+01, 6.5494136330E+00, 9.0951712224E-01],
	[2.9210000000E+04, 5.4375536715E+01, 1.4218657188E+01, 1.5643483864E+01, 6.5511424225E+00, 9.0956018152E-01],
	[2.9215000000E+04, 5.4390791489E+01, 1.4218607328E+01, 1.5652140217E+01, 6.5528709262E+00, 9.0960321985E-01],
	[2.9220000000E+04, 5.4406047930E+01, 1.4218557476E+01, 1.5660799876E+01, 6.5545991440E+00, 9.0964623724E-01],
	[2.9225000000E+04, 5.4421306039E+01, 1.4218507633E+01, 1.5669462840E+01, 6.5563270756E+00, 9.0968923371E-01],
	[2.9230000000E+04, 5.4436565817E+01, 1.4218457798E+01, 1.5678129112E+01, 6.5580547209E+00, 9.0973220924E-01],
	[2.9235000000E+04, 5.4451827261E+01, 1.4218407972E+01, 1.5686798691E+01, 6.5597820799E+00, 9.0977516387E-01],
	[2.9240000000E+04, 5.4467090374E+01, 1.4218358155E+01, 1.5695471578E+01, 6.5615091524E+00, 9.0981809759E-01],
	[2.9245000000E+04, 5.4482355154E+01, 1.4218308347E+01, 1.5704147774E+01, 6.5632359383E+00, 9.0986101041E-01],
	[2.9250000000E+04, 5.4497621601E+01, 1.4218258547E+01, 1.5712827279E+01, 6.5649624374E+00, 9.0990390235E-01],
	[2.9255000000E+04, 5.4512889715E+01, 1.4218208756E+01, 1.5721510095E+01, 6.5666886497E+00, 9.0994677341E-01],
	[2.9260000000E+04, 5.4528159497E+01, 1.4218158973E+01, 1.5730196222E+01, 6.5684145749E+00, 9.0998962359E-01],
	[2.9265000000E+04, 5.4543430946E+01, 1.4218109200E+01, 1.5738885660E+01, 6.5701402131E+00, 9.1003245292E-01],
	[2.9270000000E+04, 5.4558704061E+01, 1.4218059435E+01, 1.5747578410E+01, 6.5718655639E+00, 9.1007526139E-01],
	[2.9275000000E+04, 5.4573978844E+01, 1.4218009678E+01, 1.5756274474E+01, 6.5735906274E+00, 9.1011804901E-01],
	[2.9280000000E+04, 5.4589255293E+01, 1.4217959931E+01, 1.5764973851E+01, 6.5753154034E+00, 9.1016081581E-01],
	[2.9285000000E+04, 5.4604533409E+01, 1.4217910192E+01, 1.5773676543E+01, 6.5770398918E+00, 9.1020356177E-01],
	[2.9290000000E+04, 5.4619813192E+01, 1.4217860461E+01, 1.5782382550E+01, 6.5787640924E+00, 9.1024628691E-01],
	[2.9295000000E+04, 5.4635094641E+01, 1.4217810740E+01, 1.5791091873E+01, 6.5804880052E+00, 9.1028899125E-01],
	[2.9300000000E+04, 5.4650377756E+01, 1.4217761027E+01, 1.5799804512E+01, 6.5822116299E+00, 9.1033167478E-01],
	[2.9305000000E+04, 5.4665662538E+01, 1.4217711322E+01, 1.5808520469E+01, 6.5839349665E+00, 9.1037433752E-01],
	[2.9310000000E+04, 5.4680948985E+01, 1.4217661627E+01, 1.5817239743E+01, 6.5856580149E+00, 9.1041697948E-01],
	[2.9315000000E+04, 5.4696237099E+01, 1.4217611940E+01, 1.5825962336E+01, 6.5873807749E+00, 9.1045960066E-01],
	[2.9320000000E+04, 5.4711526879E+01, 1.4217562261E+01, 1.5834688248E+01, 6.5891032464E+00, 9.1050220107E-01],
	[2.9325000000E+04, 5.4726818324E+01, 1.4217512591E+01, 1.5843417480E+01, 6.5908254293E+00, 9.1054478073E-01],
	[2.9330000000E+04, 5.4742111436E+01, 1.4217462930E+01, 1.5852150033E+01, 6.5925473234E+00, 9.1058733964E-01],
	[2.9335000000E+04, 5.4757406213E+01, 1.4217413278E+01, 1.5860885907E+01, 6.5942689286E+00, 9.1062987781E-01],
	[2.9340000000E+04, 5.4772702655E+01, 1.4217363634E+01, 1.5869625104E+01, 6.5959902449E+00, 9.1067239524E-01],
	[2.9345000000E+04, 5.4788000763E+01, 1.4217313999E+01, 1.5878367623E+01, 6.5977112721E+00, 9.1071489195E-01],
	[2.9350000000E+04, 5.4803300536E+01, 1.4217264372E+01, 1.5887113465E+01, 6.5994320100E+00, 9.1075736795E-01],
	[2.9355000000E+04, 5.4818601974E+01, 1.4217214754E+01, 1.5895862632E+01, 6.6011524586E+00, 9.1079982324E-01],
	[2.9360000000E+04, 5.4833905078E+01, 1.4217165145E+01, 1.5904615123E+01, 6.6028726176E+00, 9.1084225784E-01],
	[2.9365000000E+04, 5.4849209846E+01, 1.4217115544E+01, 1.5913370940E+01, 6.6045924871E+00, 9.1088467174E-01],
	[2.9370000000E+04, 5.4864516280E+01, 1.4217065952E+01, 1.5922130084E+01, 6.6063120669E+00, 9.1092706497E-01],
	[2.9375000000E+04, 5.4879824378E+01, 1.4217016369E+01, 1.5930892554E+01, 6.6080313568E+00, 9.1096943752E-01],
	[2.9380000000E+04, 5.4895134141E+01, 1.4216966794E+01, 1.5939658352E+01, 6.6097503567E+00, 9.1101178942E-01],
	[2.9385000000E+04, 5.4910445569E+01, 1.4216917228E+01, 1.5948427478E+01, 6.6114690666E+00, 9.1105412065E-01],
	[2.9390000000E+04, 5.4925758661E+01, 1.4216867670E+01, 1.5957199933E+01, 6.6131874862E+00, 9.1109643125E-01],
	[2.9395000000E+04, 5.4941073417E+01, 1.4216818121E+01, 1.5965975718E+01, 6.6149056155E+00, 9.1113872121E-01],
	[2.9400000000E+04, 5.4956389838E+01, 1.4216768580E+01, 1.5974754834E+01, 6.6166234543E+00, 9.1118099054E-01],
	[2.9405000000E+04, 5.4971707923E+01, 1.4216719049E+01, 1.5983537280E+01, 6.6183410026E+00, 9.1122323925E-01],
	[2.9410000000E+04, 5.4987027672E+01, 1.4216669525E+01, 1.5992323059E+01, 6.6200582602E+00, 9.1126546735E-01],
	[2.9415000000E+04, 5.5002349085E+01, 1.4216620011E+01, 1.6001112169E+01, 6.6217752270E+00, 9.1130767485E-01],
	[2.9420000000E+04, 5.5017672162E+01, 1.4216570505E+01, 1.6009904613E+01, 6.6234919028E+00, 9.1134986176E-01],
	[2.9425000000E+04, 5.5032996903E+01, 1.4216521007E+01, 1.6018700391E+01, 6.6252082876E+00, 9.1139202808E-01],
	[2.9430000000E+04, 5.5048323307E+01, 1.4216471518E+01, 1.6027499504E+01, 6.6269243812E+00, 9.1143417383E-01],
	[2.9435000000E+04, 5.5063664740E+01, 1.4216424089E+01, 1.6036301952E+01, 6.6286408231E+00, 9.1147629902E-01],
	[2.9440000000E+04, 5.5079052936E+01, 1.4216383587E+01, 1.6045107736E+01, 6.6303591324E+00, 9.1151840364E-01],
	[2.9445000000E+04, 5.5094442819E+01, 1.4216343092E+01, 1.6053916856E+01, 6.6320771522E+00, 9.1156048772E-01],
	[2.9450000000E+04, 5.5109834387E+01, 1.4216302603E+01, 1.6062729314E+01, 6.6337948823E+00, 9.1160255126E-01],
	[2.9455000000E+04, 5.5125227642E+01, 1.4216262122E+01, 1.6071545110E+01, 6.6355123226E+00, 9.1164459426E-01],
	[2.9460000000E+04, 5.5140622582E+01, 1.4216221648E+01, 1.6080364245E+01, 6.6372294730E+00, 9.1168661674E-01],
	[2.9465000000E+04, 5.5156019207E+01, 1.4216181180E+01, 1.6089186719E+01, 6.6389463333E+00, 9.1172861871E-01],
	[2.9470000000E+04, 5.5171417519E+01, 1.4216140720E+01, 1.6098012533E+01, 6.6406629034E+00, 9.1177060018E-01],
	[2.9475000000E+04, 5.5186817515E+01, 1.4216100267E+01, 1.6106841688E+01, 6.6423791833E+00, 9.1181256114E-01],
	[2.9480000000E+04, 5.5202219197E+01, 1.4216059820E+01, 1.6115674185E+01, 6.6440951728E+00, 9.1185450162E-01],
	[2.9485000000E+04, 5.5217622565E+01, 1.4216019381E+01, 1.6124510024E+01, 6.6458108717E+00, 9.1189642162E-01],
	[2.9490000000E+04, 5.5233027617E+01, 1.4215978948E+01, 1.6133349206E+01, 6.6475262800E+00, 9.1193832115E-01],
	[2.9495000000E+04, 5.5248434354E+01, 1.4215938523E+01, 1.6142191732E+01, 6.6492413975E+00, 9.1198020022E-01],
	[2.9500000000E+04, 5.5263842777E+01, 1.4215898104E+01, 1.6151037602E+01, 6.6509562242E+00, 9.1202205884E-01],
	[2.9505000000E+04, 5.5279252884E+01, 1.4215857693E+01, 1.6159886817E+01, 6.6526707598E+00, 9.1206389702E-01],
	[2.9510000000E+04, 5.5294664676E+01, 1.4215817288E+01, 1.6168739377E+01, 6.6543850044E+00, 9.1210571475E-01],
	[2.9515000000E+04, 5.5310078153E+01, 1.4215776891E+01, 1.6177595285E+01, 6.6560989577E+00, 9.1214751207E-01],
	[2.9520000000E+04, 5.5325493314E+01, 1.4215736500E+01, 1.6186454539E+01, 6.6578126197E+00, 9.1218928896E-01],
	[2.9525000000E+04, 5.5340910159E+01, 1.4215696116E+01, 1.6195317141E+01, 6.6595259902E+00, 9.1223104545E-01],
	[2.9530000000E+04, 5.5356328689E+01, 1.4215655740E+01, 1.6204183092E+01, 6.6612390691E+00, 9.1227278154E-01],
	[2.9535000000E+04, 5.5371748903E+01, 1.4215615370E+01, 1.6213052392E+01, 6.6629518564E+00, 9.1231449723E-01],
	[2.9540000000E+04, 5.5387170802E+01, 1.4215575007E+01, 1.6221925041E+01, 6.6646643518E+00, 9.1235619255E-01],
	[2.9545000000E+04, 5.5402594384E+01, 1.4215534651E+01, 1.6230801042E+01, 6.6663765553E+00, 9.1239786749E-01],
	[2.9550000000E+04, 5.5418019650E+01, 1.4215494302E+01, 1.6239680394E+01, 6.6680884668E+00, 9.1243952206E-01],
	[2.9555000000E+04, 5.5433446600E+01, 1.4215453960E+01, 1.6248563097E+01, 6.6698000861E+00, 9.1248115628E-01],
	[2.9560000000E+04, 5.5448875234E+01, 1.4215413625E+01, 1.6257449154E+01, 6.6715114131E+00, 9.1252277016E-01],
	[2.9565000000E+04, 5.5464305552E+01, 1.4215373297E+01, 1.6266338564E+01, 6.6732224477E+00, 9.1256436369E-01],
	[2.9570000000E+04, 5.5479737552E+01, 1.4215332976E+01, 1.6275231328E+01, 6.6749331898E+00, 9.1260593690E-01],
	[2.9575000000E+04, 5.5495171237E+01, 1.4215292661E+01, 1.6284127446E+01, 6.6766436393E+00, 9.1264748978E-01],
	[2.9580000000E+04, 5.5510606604E+01, 1.4215252354E+01, 1.6293026921E+01, 6.6783537961E+00, 9.1268902236E-01],
	[2.9585000000E+04, 5.5526043655E+01, 1.4215212053E+01, 1.6301929751E+01, 6.6800636600E+00, 9.1273053463E-01],
	[2.9590000000E+04, 5.5541482389E+01, 1.4215171760E+01, 1.6310835938E+01, 6.6817732309E+00, 9.1277202660E-01],
	[2.9595000000E+04, 5.5556922806E+01, 1.4215131473E+01, 1.6319745483E+01, 6.6834825088E+00, 9.1281349829E-01],
	[2.9600000000E+04, 5.5572364906E+01, 1.4215091194E+01, 1.6328658386E+01, 6.6851914934E+00, 9.1285494971E-01],
	[2.9605000000E+04, 5.5587808689E+01, 1.4215050921E+01, 1.6337574648E+01, 6.6869001848E+00, 9.1289638086E-01],
	[2.9610000000E+04, 5.5603254155E+01, 1.4215010655E+01, 1.6346494270E+01, 6.6886085827E+00, 9.1293779174E-01],
	[2.9615000000E+04, 5.5618701303E+01, 1.4214970396E+01, 1.6355417252E+01, 6.6903166871E+00, 9.1297918238E-01],
	[2.9620000000E+04, 5.5634150133E+01, 1.4214930144E+01, 1.6364343596E+01, 6.6920244979E+00, 9.1302055278E-01],
	[2.9625000000E+04, 5.5649600646E+01, 1.4214889899E+01, 1.6373273301E+01, 6.6937320148E+00, 9.1306190294E-01],
	[2.9630000000E+04, 5.5665052842E+01, 1.4214849661E+01, 1.6382206368E+01, 6.6954392379E+00, 9.1310323288E-01],
	[2.9635000000E+04, 5.5680506719E+01, 1.4214809430E+01, 1.6391142799E+01, 6.6971461670E+00, 9.1314454261E-01],
	[2.9640000000E+04, 5.5695962279E+01, 1.4214769205E+01, 1.6400082593E+01, 6.6988528021E+00, 9.1318583213E-01],
	[2.9645000000E+04, 5.5711419521E+01, 1.4214728988E+01, 1.6409025752E+01, 6.7005591428E+00, 9.1322710145E-01],
	[2.9650000000E+04, 5.5726878444E+01, 1.4214688777E+01, 1.6417972277E+01, 6.7022651893E+00, 9.1326835059E-01],
	[2.9655000000E+04, 5.5742339049E+01, 1.4214648574E+01, 1.6426922167E+01, 6.7039709413E+00, 9.1330957954E-01],
	[2.9660000000E+04, 5.5757801337E+01, 1.4214608377E+01, 1.6435875424E+01, 6.7056763988E+00, 9.1335078833E-01],
	[2.9665000000E+04, 5.5773265305E+01, 1.4214568187E+01, 1.6444832048E+01, 6.7073815616E+00, 9.1339197695E-01],
	[2.9670000000E+04, 5.5788730955E+01, 1.4214528004E+01, 1.6453792040E+01, 6.7090864296E+00, 9.1343314542E-01],
	[2.9675000000E+04, 5.5804198287E+01, 1.4214487828E+01, 1.6462755401E+01, 6.7107910028E+00, 9.1347429375E-01],
	[2.9680000000E+04, 5.5819667300E+01, 1.4214447658E+01, 1.6471722132E+01, 6.7124952809E+00, 9.1351542194E-01],
	[2.9685000000E+04, 5.5835137994E+01, 1.4214407496E+01, 1.6480692232E+01, 6.7141992640E+00, 9.1355653001E-01],
	[2.9690000000E+04, 5.5850610369E+01, 1.4214367341E+01, 1.6489665704E+01, 6.7159029518E+00, 9.1359761796E-01],
	[2.9695000000E+04, 5.5866084426E+01, 1.4214327192E+01, 1.6498642547E+01, 6.7176063443E+00, 9.1363868580E-01],
	[2.9700000000E+04, 5.5881560163E+01, 1.4214287050E+01, 1.6507622762E+01, 6.7193094413E+00, 9.1367973354E-01],
	[2.9705000000E+04, 5.5897037581E+01, 1.4214246915E+01, 1.6516606350E+01, 6.7210122428E+00, 9.1372076118E-01],
	[2.9710000000E+04, 5.5912516679E+01, 1.4214206787E+01, 1.6525593312E+01, 6.7227147486E+00, 9.1376176875E-01],
	[2.9715000000E+04, 5.5927997459E+01, 1.4214166666E+01, 1.6534583648E+01, 6.7244169586E+00, 9.1380275625E-01],
	[2.9720000000E+04, 5.5943479918E+01, 1.4214126552E+01, 1.6543577359E+01, 6.7261188728E+00, 9.1384372368E-01],
	[2.9725000000E+04, 5.5958964058E+01, 1.4214086444E+01, 1.6552574446E+01, 6.7278204910E+00, 9.1388467105E-01],
	[2.9730000000E+04, 5.5974449879E+01, 1.4214046344E+01, 1.6561574909E+01, 6.7295218130E+00, 9.1392559838E-01],
	[2.9735000000E+04, 5.5989937380E+01, 1.4214006250E+01, 1.6570578749E+01, 6.7312228389E+00, 9.1396650567E-01],
	[2.9740000000E+04, 5.6005426560E+01, 1.4213966163E+01, 1.6579585967E+01, 6.7329235684E+00, 9.1400739293E-01],
	[2.9745000000E+04, 5.6020917421E+01, 1.4213926083E+01, 1.6588596564E+01, 6.7346240015E+00, 9.1404826017E-01],
	[2.9750000000E+04, 5.6036409962E+01, 1.4213886010E+01, 1.6597610540E+01, 6.7363241380E+00, 9.1408910740E-01],
	[2.9755000000E+04, 5.6051904182E+01, 1.4213845944E+01, 1.6606627895E+01, 6.7380239779E+00, 9.1412993463E-01],
	[2.9760000000E+04, 5.6067400082E+01, 1.4213805884E+01, 1.6615648632E+01, 6.7397235211E+00, 9.1417074187E-01],
	[2.9765000000E+04, 5.6082897662E+01, 1.4213765832E+01, 1.6624672749E+01, 6.7414227673E+00, 9.1421152912E-01],
	[2.9770000000E+04, 5.6098396921E+01, 1.4213725786E+01, 1.6633700249E+01, 6.7431217166E+00, 9.1425229639E-01],
	[2.9775000000E+04, 5.6113897860E+01, 1.4213685747E+01, 1.6642731131E+01, 6.7448203688E+00, 9.1429304370E-01],
	[2.9780000000E+04, 5.6129400478E+01, 1.4213645715E+01, 1.6651765397E+01, 6.7465187239E+00, 9.1433377105E-01],
	[2.9785000000E+04, 5.6144904775E+01, 1.4213605690E+01, 1.6660803046E+01, 6.7482167816E+00, 9.1437447846E-01],
	[2.9790000000E+04, 5.6160410751E+01, 1.4213565671E+01, 1.6669844081E+01, 6.7499145419E+00, 9.1441516592E-01],
	[2.9795000000E+04, 5.6175918407E+01, 1.4213525660E+01, 1.6678888501E+01, 6.7516120047E+00, 9.1445583345E-01],
	[2.9800000000E+04, 5.6191427741E+01, 1.4213485655E+01, 1.6687936307E+01, 6.7533091699E+00, 9.1449648106E-01],
	[2.9805000000E+04, 5.6206938754E+01, 1.4213445657E+01, 1.6696987500E+01, 6.7550060373E+00, 9.1453710875E-01],
	[2.9810000000E+04, 5.6222451445E+01, 1.4213405666E+01, 1.6706042081E+01, 6.7567026069E+00, 9.1457771655E-01],
	[2.9815000000E+04, 5.6237965816E+01, 1.4213365681E+01, 1.6715100050E+01, 6.7583988786E+00, 9.1461830444E-01],
	[2.9820000000E+04, 5.6253481864E+01, 1.4213325704E+01, 1.6724161408E+01, 6.7600948522E+00, 9.1465887245E-01],
	[2.9825000000E+04, 5.6268999592E+01, 1.4213285733E+01, 1.6733226156E+01, 6.7617905277E+00, 9.1469942058E-01],
	[2.9830000000E+04, 5.6284518997E+01, 1.4213245769E+01, 1.6742294293E+01, 6.7634859049E+00, 9.1473994885E-01],
	[2.9835000000E+04, 5.6300040081E+01, 1.4213205812E+01, 1.6751365823E+01, 6.7651809837E+00, 9.1478045725E-01],
	[2.9840000000E+04, 5.6315562842E+01, 1.4213165862E+01, 1.6760440743E+01, 6.7668757641E+00, 9.1482094580E-01],
	[2.9845000000E+04, 5.6331087282E+01, 1.4213125919E+01, 1.6769519057E+01, 6.7685702459E+00, 9.1486141451E-01],
	[2.9850000000E+04, 5.6346613400E+01, 1.4213085982E+01, 1.6778600763E+01, 6.7702644289E+00, 9.1490186339E-01],
	[2.9855000000E+04, 5.6362141195E+01, 1.4213046052E+01, 1.6787685863E+01, 6.7719583133E+00, 9.1494229244E-01],
	[2.9860000000E+04, 5.6377670668E+01, 1.4213006129E+01, 1.6796774358E+01, 6.7736518987E+00, 9.1498270168E-01],
	[2.9865000000E+04, 5.6393201819E+01, 1.4212966213E+01, 1.6805866248E+01, 6.7753451851E+00, 9.1502309111E-01],
	[2.9870000000E+04, 5.6408734647E+01, 1.4212926303E+01, 1.6814961534E+01, 6.7770381724E+00, 9.1506346074E-01],
	[2.9875000000E+04, 5.6424269153E+01, 1.4212886401E+01, 1.6824060217E+01, 6.7787308605E+00, 9.1510381059E-01],
	[2.9880000000E+04, 5.6439805336E+01, 1.4212846505E+01, 1.6833162297E+01, 6.7804232492E+00, 9.1514414065E-01],
	[2.9885000000E+04, 5.6455343196E+01, 1.4212806616E+01, 1.6842267775E+01, 6.7821153386E+00, 9.1518445095E-01],
	[2.9890000000E+04, 5.6470882734E+01, 1.4212766734E+01, 1.6851376652E+01, 6.7838071284E+00, 9.1522474148E-01],
	[2.9895000000E+04, 5.6486423948E+01, 1.4212726858E+01, 1.6860488929E+01, 6.7854986186E+00, 9.1526501226E-01],
	[2.9900000000E+04, 5.6501966839E+01, 1.4212686989E+01, 1.6869604605E+01, 6.7871898091E+00, 9.1530526329E-01],
	[2.9905000000E+04, 5.6517511407E+01, 1.4212647127E+01, 1.6878723683E+01, 6.7888806997E+00, 9.1534549459E-01],
	[2.9910000000E+04, 5.6533084391E+01, 1.4212611324E+01, 1.6887846162E+01, 6.7905726011E+00, 9.1538570617E-01],
	[2.9915000000E+04, 5.6548690502E+01, 1.4212580288E+01, 1.6896972043E+01, 6.7922657446E+00, 9.1542589803E-01],
	[2.9920000000E+04, 5.6564298311E+01, 1.4212549259E+01, 1.6906101327E+01, 6.7939585899E+00, 9.1546607017E-01],
	[2.9925000000E+04, 5.6579907820E+01, 1.4212518234E+01, 1.6915234015E+01, 6.7956511368E+00, 9.1550622262E-01],
	[2.9930000000E+04, 5.6595519027E+01, 1.4212487215E+01, 1.6924370107E+01, 6.7973433853E+00, 9.1554635538E-01],
	[2.9935000000E+04, 5.6611131932E+01, 1.4212456200E+01, 1.6933509604E+01, 6.7990353353E+00, 9.1558646846E-01],
	[2.9940000000E+04, 5.6626746536E+01, 1.4212425191E+01, 1.6942652507E+01, 6.8007269866E+00, 9.1562656186E-01],
	[2.9945000000E+04, 5.6642362839E+01, 1.4212394188E+01, 1.6951798816E+01, 6.8024183391E+00, 9.1566663560E-01],
	[2.9950000000E+04, 5.6657980839E+01, 1.4212363189E+01, 1.6960948532E+01, 6.8041093928E+00, 9.1570668969E-01],
	[2.9955000000E+04, 5.6673600538E+01, 1.4212332196E+01, 1.6970101657E+01, 6.8058001476E+00, 9.1574672413E-01],
	[2.9960000000E+04, 5.6689221935E+01, 1.4212301208E+01, 1.6979258189E+01, 6.8074906033E+00, 9.1578673893E-01],
	[2.9965000000E+04, 5.6704845030E+01, 1.4212270226E+01, 1.6988418132E+01, 6.8091807598E+00, 9.1582673411E-01],
	[2.9970000000E+04, 5.6720469822E+01, 1.4212239248E+01, 1.6997581483E+01, 6.8108706171E+00, 9.1586670966E-01],
	[2.9975000000E+04, 5.6736096313E+01, 1.4212208276E+01, 1.7006748246E+01, 6.8125601750E+00, 9.1590666561E-01],
	[2.9980000000E+04, 5.6751724501E+01, 1.4212177309E+01, 1.7015918420E+01, 6.8142494334E+00, 9.1594660195E-01],
	[2.9985000000E+04, 5.6767354386E+01, 1.4212146347E+01, 1.7025092006E+01, 6.8159383923E+00, 9.1598651871E-01],
	[2.9990000000E+04, 5.6782985969E+01, 1.4212115391E+01, 1.7034269005E+01, 6.8176270515E+00, 9.1602641587E-01],
	[2.9995000000E+04, 5.6798619249E+01, 1.4212084439E+01, 1.7043449417E+01, 6.8193154110E+00, 9.1606629347E-01],
	[3.0000000000E+04, 5.6814254227E+01, 1.4212053493E+01, 1.7052633243E+01, 6.8210034705E+00, 9.1610615150E-01],
	[3.0005000000E+04, 5.6829890902E+01, 1.4212022552E+01, 1.7061877409E+01, 6.8227003326E+00, 9.1614598997E-01],
	[3.0010000000E+04, 5.6845529274E+01, 1.4211991617E+01, 1.7071125041E+01, 6.8243968922E+00, 9.1618580890E-01],
	[3.0015000000E+04, 5.6861169342E+01, 1.4211960686E+01, 1.7080376142E+01, 6.8260931493E+00, 9.1622560828E-01],
	[3.0020000000E+04, 5.6876811108E+01, 1.4211929761E+01, 1.7089630712E+01, 6.8277891039E+00, 9.1626538814E-01],
	[3.0025000000E+04, 5.6892454570E+01, 1.4211898841E+01, 1.7098888752E+01, 6.8294847557E+00, 9.1630514848E-01],
	[3.0030000000E+04, 5.6908099730E+01, 1.4211867926E+01, 1.7108150262E+01, 6.8311801047E+00, 9.1634488930E-01],
	[3.0035000000E+04, 5.6923746585E+01, 1.4211837017E+01, 1.7117415243E+01, 6.8328751507E+00, 9.1638461062E-01],
	[3.0040000000E+04, 5.6939395137E+01, 1.4211806113E+01, 1.7126683696E+01, 6.8345698938E+00, 9.1642431245E-01],
	[3.0045000000E+04, 5.6955045386E+01, 1.4211775213E+01, 1.7135955621E+01, 6.8362643337E+00, 9.1646399479E-01],
	[3.0050000000E+04, 5.6970697331E+01, 1.4211744319E+01, 1.7145231020E+01, 6.8379584704E+00, 9.1650365766E-01],
	[3.0055000000E+04, 5.6986350971E+01, 1.4211713431E+01, 1.7154509893E+01, 6.8396523038E+00, 9.1654330106E-01],
	[3.0060000000E+04, 5.7002006308E+01, 1.4211682547E+01, 1.7163792240E+01, 6.8413458337E+00, 9.1658292500E-01],
	[3.0065000000E+04, 5.7017663341E+01, 1.4211651669E+01, 1.7173078063E+01, 6.8430390602E+00, 9.1662252949E-01],
	[3.0070000000E+04, 5.7033322070E+01, 1.4211620796E+01, 1.7182367362E+01, 6.8447319830E+00, 9.1666211454E-01],
	[3.0075000000E+04, 5.7048982495E+01, 1.4211589928E+01, 1.7191660137E+01, 6.8464246020E+00, 9.1670168016E-01],
	[3.0080000000E+04, 5.7064644615E+01, 1.4211559065E+01, 1.7200956391E+01, 6.8481169173E+00, 9.1674122636E-01],
	[3.0085000000E+04, 5.7080308431E+01, 1.4211528208E+01, 1.7210256122E+01, 6.8498089286E+00, 9.1678075315E-01],
	[3.0090000000E+04, 5.7095973942E+01, 1.4211497356E+01, 1.7219559333E+01, 6.8515006358E+00, 9.1682026053E-01],
	[3.0095000000E+04, 5.7111641149E+01, 1.4211466508E+01, 1.7228866023E+01, 6.8531920390E+00, 9.1685974851E-01],
	[3.0100000000E+04, 5.7127310051E+01, 1.4211435666E+01, 1.7238176194E+01, 6.8548831379E+00, 9.1689921711E-01],
	[3.0105000000E+04, 5.7142980648E+01, 1.4211404830E+01, 1.7247489846E+01, 6.8565739324E+00, 9.1693866634E-01],
	[3.0110000000E+04, 5.7158652941E+01, 1.4211373998E+01, 1.7256806980E+01, 6.8582644226E+00, 9.1697809621E-01],
	[3.0115000000E+04, 5.7174326928E+01, 1.4211343172E+01, 1.7266127597E+01, 6.8599546082E+00, 9.1701750676E-01],
	[3.0120000000E+04, 5.7190002610E+01, 1.4211312351E+01, 1.7275451697E+01, 6.8616444892E+00, 9.1705689799E-01],
	[3.0125000000E+04, 5.7205679987E+01, 1.4211281535E+01, 1.7284779281E+01, 6.8633340654E+00, 9.1709626990E-01],
	[3.0130000000E+04, 5.7221359059E+01, 1.4211250724E+01, 1.7294110349E+01, 6.8650233368E+00, 9.1713562251E-01],
	[3.0135000000E+04, 5.7237039825E+01, 1.4211219918E+01, 1.7303444904E+01, 6.8667123033E+00, 9.1717495581E-01],
	[3.0140000000E+04, 5.7252722286E+01, 1.4211189118E+01, 1.7312782944E+01, 6.8684009648E+00, 9.1721426983E-01],
	[3.0145000000E+04, 5.7268406441E+01, 1.4211158323E+01, 1.7322124472E+01, 6.8700893211E+00, 9.1725356457E-01],
	[3.0150000000E+04, 5.7284092291E+01, 1.4211127532E+01, 1.7331469487E+01, 6.8717773722E+00, 9.1729284003E-01],
	[3.0155000000E+04, 5.7299779835E+01, 1.4211096748E+01, 1.7340817991E+01, 6.8734651180E+00, 9.1733209622E-01],
	[3.0160000000E+04, 5.7315469073E+01, 1.4211065968E+01, 1.7350169984E+01, 6.8751525584E+00, 9.1737133316E-01],
	[3.0165000000E+04, 5.7331160004E+01, 1.4211035193E+01, 1.7359525466E+01, 6.8768396932E+00, 9.1741055084E-01],
	[3.0170000000E+04, 5.7346852630E+01, 1.4211004424E+01, 1.7368884440E+01, 6.8785265225E+00, 9.1744974928E-01],
	[3.0175000000E+04, 5.7362546950E+01, 1.4210973660E+01, 1.7378246904E+01, 6.8802130460E+00, 9.1748892849E-01],
	[3.0180000000E+04, 5.7378242963E+01, 1.4210942900E+01, 1.7387612861E+01, 6.8818992637E+00, 9.1752808847E-01],
	[3.0185000000E+04, 5.7393940670E+01, 1.4210912147E+01, 1.7396982310E+01, 6.8835851755E+00, 9.1756722923E-01],
	[3.0190000000E+04, 5.7409640070E+01, 1.4210881398E+01, 1.7406355253E+01, 6.8852707813E+00, 9.1760635078E-01],
	[3.0195000000E+04, 5.7425341164E+01, 1.4210850654E+01, 1.7415731690E+01, 6.8869560810E+00, 9.1764545312E-01],
	[3.0200000000E+04, 5.7441043951E+01, 1.4210819916E+01, 1.7425111621E+01, 6.8886410745E+00, 9.1768453627E-01],
	[3.0205000000E+04, 5.7456748432E+01, 1.4210789182E+01, 1.7434495049E+01, 6.8903257617E+00, 9.1772360023E-01],
	[3.0210000000E+04, 5.7472454605E+01, 1.4210758454E+01, 1.7443881973E+01, 6.8920101425E+00, 9.1776264501E-01],
	[3.0215000000E+04, 5.7488162472E+01, 1.4210727731E+01, 1.7453272394E+01, 6.8936942168E+00, 9.1780167062E-01],
	[3.0220000000E+04, 5.7503872032E+01, 1.4210697013E+01, 1.7462666312E+01, 6.8953779845E+00, 9.1784067707E-01],
	[3.0225000000E+04, 5.7519583284E+01, 1.4210666301E+01, 1.7472063730E+01, 6.8970614456E+00, 9.1787966435E-01],
	[3.0230000000E+04, 5.7535296229E+01, 1.4210635593E+01, 1.7481464646E+01, 6.8987445999E+00, 9.1791863249E-01],
	[3.0235000000E+04, 5.7551010867E+01, 1.4210604891E+01, 1.7490869063E+01, 6.9004274473E+00, 9.1795758149E-01],
	[3.0240000000E+04, 5.7566727197E+01, 1.4210574194E+01, 1.7500276980E+01, 6.9021099877E+00, 9.1799651136E-01],
	[3.0245000000E+04, 5.7582445220E+01, 1.4210543501E+01, 1.7509688398E+01, 6.9037922211E+00, 9.1803542210E-01],
	[3.0250000000E+04, 5.7598164935E+01, 1.4210512814E+01, 1.7519103319E+01, 6.9054741473E+00, 9.1807431373E-01],
	[3.0255000000E+04, 5.7613886342E+01, 1.4210482133E+01, 1.7528521743E+01, 6.9071557663E+00, 9.1811318625E-01],
	[3.0260000000E+04, 5.7629609442E+01, 1.4210451456E+01, 1.7537943670E+01, 6.9088370779E+00, 9.1815203967E-01],
	[3.0265000000E+04, 5.7645334233E+01, 1.4210420784E+01, 1.7547369101E+01, 6.9105180821E+00, 9.1819087399E-01],
	[3.0270000000E+04, 5.7661060717E+01, 1.4210390118E+01, 1.7556798038E+01, 6.9121987788E+00, 9.1822968923E-01],
	[3.0275000000E+04, 5.7676788892E+01, 1.4210359457E+01, 1.7566230480E+01, 6.9138791678E+00, 9.1826848539E-01],
	[3.0280000000E+04, 5.7692518760E+01, 1.4210328800E+01, 1.7575666429E+01, 6.9155592491E+00, 9.1830726249E-01],
	[3.0285000000E+04, 5.7708250318E+01, 1.4210298149E+01, 1.7585105885E+01, 6.9172390226E+00, 9.1834602052E-01],
	[3.0290000000E+04, 5.7723983569E+01, 1.4210267503E+01, 1.7594548848E+01, 6.9189184881E+00, 9.1838475950E-01],
	[3.0295000000E+04, 5.7739718511E+01, 1.4210236863E+01, 1.7603995321E+01, 6.9205976457E+00, 9.1842347943E-01],
	[3.0300000000E+04, 5.7755455144E+01, 1.4210206227E+01, 1.7613445303E+01, 6.9222764951E+00, 9.1846218033E-01],
	[3.0305000000E+04, 5.7771193468E+01, 1.4210175596E+01, 1.7622898795E+01, 6.9239550364E+00, 9.1850086220E-01],
	[3.0310000000E+04, 5.7786933484E+01, 1.4210144971E+01, 1.7632355797E+01, 6.9256332694E+00, 9.1853952505E-01],
	[3.0315000000E+04, 5.7802675191E+01, 1.4210114351E+01, 1.7641816312E+01, 6.9273111940E+00, 9.1857816888E-01],
	[3.0320000000E+04, 5.7818418589E+01, 1.4210083735E+01, 1.7651280338E+01, 6.9289888102E+00, 9.1861679371E-01],
	[3.0325000000E+04, 5.7834163677E+01, 1.4210053125E+01, 1.7660747878E+01, 6.9306661177E+00, 9.1865539954E-01],
	[3.0330000000E+04, 5.7849910457E+01, 1.4210022520E+01, 1.7670218931E+01, 6.9323431167E+00, 9.1869398639E-01],
	[3.0335000000E+04, 5.7865658927E+01, 1.4209991921E+01, 1.7679693499E+01, 6.9340198068E+00, 9.1873255425E-01],
	[3.0340000000E+04, 5.7881409088E+01, 1.4209961326E+01, 1.7689171581E+01, 6.9356961882E+00, 9.1877110314E-01],
	[3.0345000000E+04, 5.7897160939E+01, 1.4209930736E+01, 1.7698653180E+01, 6.9373722606E+00, 9.1880963306E-01],
	[3.0350000000E+04, 5.7912914481E+01, 1.4209900152E+01, 1.7708138295E+01, 6.9390480240E+00, 9.1884814403E-01],
	[3.0355000000E+04, 5.7928669713E+01, 1.4209869572E+01, 1.7717626928E+01, 6.9407234782E+00, 9.1888663604E-01],
	[3.0360000000E+04, 5.7944426635E+01, 1.4209838998E+01, 1.7727119079E+01, 6.9423986233E+00, 9.1892510912E-01],
	[3.0365000000E+04, 5.7960185247E+01, 1.4209808429E+01, 1.7736614748E+01, 6.9440734591E+00, 9.1896356326E-01],
	[3.0370000000E+04, 5.7975945549E+01, 1.4209777864E+01, 1.7746113937E+01, 6.9457479854E+00, 9.1900199848E-01],
	[3.0375000000E+04, 5.7991707542E+01, 1.4209747305E+01, 1.7755616646E+01, 6.9474222023E+00, 9.1904041477E-01],
	[3.0380000000E+04, 5.8007471224E+01, 1.4209716752E+01, 1.7765122876E+01, 6.9490961097E+00, 9.1907881217E-01],
	[3.0385000000E+04, 5.8023236595E+01, 1.4209686203E+01, 1.7774632628E+01, 6.9507697073E+00, 9.1911719065E-01],
	[3.0390000000E+04, 5.8039013176E+01, 1.4209657086E+01, 1.7784145902E+01, 6.9524434734E+00, 9.1915555025E-01],
	[3.0395000000E+04, 5.8054839637E+01, 1.4209635194E+01, 1.7793662699E+01, 6.9541193506E+00, 9.1919389096E-01],
	[3.0400000000E+04, 5.8070667808E+01, 1.4209613305E+01, 1.7803183020E+01, 6.9557949198E+00, 9.1923221279E-01],
	[3.0405000000E+04, 5.8086497691E+01, 1.4209591421E+01, 1.7812706866E+01, 6.9574701808E+00, 9.1927051576E-01],
	[3.0410000000E+04, 5.8102329285E+01, 1.4209569539E+01, 1.7822234237E+01, 6.9591451336E+00, 9.1930879986E-01],
	[3.0415000000E+04, 5.8118162590E+01, 1.4209547662E+01, 1.7831765133E+01, 6.9608197780E+00, 9.1934706511E-01],
	[3.0420000000E+04, 5.8133997606E+01, 1.4209525788E+01, 1.7841299557E+01, 6.9624941140E+00, 9.1938531152E-01],
	[3.0425000000E+04, 5.8149834333E+01, 1.4209503918E+01, 1.7850837508E+01, 6.9641681415E+00, 9.1942353908E-01],
	[3.0430000000E+04, 5.8165672771E+01, 1.4209482051E+01, 1.7860378987E+01, 6.9658418605E+00, 9.1946174782E-01],
	[3.0435000000E+04, 5.8181512919E+01, 1.4209460188E+01, 1.7869923996E+01, 6.9675152707E+00, 9.1949993774E-01],
	[3.0440000000E+04, 5.8197354778E+01, 1.4209438329E+01, 1.7879472533E+01, 6.9691883721E+00, 9.1953810885E-01],
	[3.0445000000E+04, 5.8213198348E+01, 1.4209416473E+01, 1.7889024601E+01, 6.9708611647E+00, 9.1957626115E-01],
	[3.0450000000E+04, 5.8229043628E+01, 1.4209394621E+01, 1.7898580201E+01, 6.9725336483E+00, 9.1961439465E-01],
	[3.0455000000E+04, 5.8244890618E+01, 1.4209372773E+01, 1.7908139332E+01, 6.9742058229E+00, 9.1965250936E-01],
	[3.0460000000E+04, 5.8260739318E+01, 1.4209350928E+01, 1.7917701995E+01, 6.9758776883E+00, 9.1969060530E-01],
	[3.0465000000E+04, 5.8276589728E+01, 1.4209329087E+01, 1.7927268192E+01, 6.9775492445E+00, 9.1972868246E-01],
	[3.0470000000E+04, 5.8292441849E+01, 1.4209307249E+01, 1.7936837923E+01, 6.9792204915E+00, 9.1976674086E-01],
	[3.0475000000E+04, 5.8308295679E+01, 1.4209285415E+01, 1.7946411188E+01, 6.9808914290E+00, 9.1980478050E-01],
	[3.0480000000E+04, 5.8324151219E+01, 1.4209263585E+01, 1.7955987989E+01, 6.9825620570E+00, 9.1984280139E-01],
	[3.0485000000E+04, 5.8340008469E+01, 1.4209241758E+01, 1.7965568326E+01, 6.9842323754E+00, 9.1988080354E-01],
	[3.0490000000E+04, 5.8355867428E+01, 1.4209219935E+01, 1.7975152200E+01, 6.9859023842E+00, 9.1991878696E-01],
	[3.0495000000E+04, 5.8371728097E+01, 1.4209198115E+01, 1.7984739611E+01, 6.9875720833E+00, 9.1995675166E-01],
	[3.0500000000E+04, 5.8387590476E+01, 1.4209176299E+01, 1.7994330561E+01, 6.9892414725E+00, 9.1999469763E-01],
	[3.0505000000E+04, 5.8403454563E+01, 1.4209154487E+01, 1.8003925049E+01, 6.9909105517E+00, 9.2003262490E-01],
	[3.0510000000E+04, 5.8419320360E+01, 1.4209132678E+01, 1.8013523078E+01, 6.9925793210E+00, 9.2007053348E-01],
	[3.0515000000E+04, 5.8435187866E+01, 1.4209110873E+01, 1.8023124647E+01, 6.9942477802E+00, 9.2010842335E-01],
	[3.0520000000E+04, 5.8451057081E+01, 1.4209089072E+01, 1.8032729757E+01, 6.9959159292E+00, 9.2014629455E-01],
	[3.0525000000E+04, 5.8466928005E+01, 1.4209067274E+01, 1.8042338409E+01, 6.9975837679E+00, 9.2018414707E-01],
	[3.0530000000E+04, 5.8482800638E+01, 1.4209045479E+01, 1.8051950604E+01, 6.9992512962E+00, 9.2022198092E-01],
	[3.0535000000E+04, 5.8498674980E+01, 1.4209023689E+01, 1.8061566342E+01, 7.0009185141E+00, 9.2025979611E-01],
	[3.0540000000E+04, 5.8514551030E+01, 1.4209001902E+01, 1.8071185625E+01, 7.0025854215E+00, 9.2029759265E-01],
	[3.0545000000E+04, 5.8530428789E+01, 1.4208980118E+01, 1.8080808452E+01, 7.0042520183E+00, 9.2033537055E-01],
	[3.0550000000E+04, 5.8546308256E+01, 1.4208958338E+01, 1.8090434824E+01, 7.0059183044E+00, 9.2037312981E-01],
	[3.0555000000E+04, 5.8562189432E+01, 1.4208936562E+01, 1.8100064743E+01, 7.0075842796E+00, 9.2041087045E-01],
	[3.0560000000E+04, 5.8578072316E+01, 1.4208914789E+01, 1.8109698209E+01, 7.0092499440E+00, 9.2044859246E-01],
	[3.0565000000E+04, 5.8593956908E+01, 1.4208893020E+01, 1.8119335223E+01, 7.0109152975E+00, 9.2048629587E-01],
	[3.0570000000E+04, 5.8609843208E+01, 1.4208871255E+01, 1.8128975785E+01, 7.0125803399E+00, 9.2052398067E-01],
	[3.0575000000E+04, 5.8625731216E+01, 1.4208849493E+01, 1.8138619897E+01, 7.0142450712E+00, 9.2056164687E-01],
	[3.0580000000E+04, 5.8641620932E+01, 1.4208827734E+01, 1.8148267558E+01, 7.0159094912E+00, 9.2059929449E-01],
	[3.0585000000E+04, 5.8657512356E+01, 1.4208805980E+01, 1.8157918770E+01, 7.0175736000E+00, 9.2063692354E-01],
	[3.0590000000E+04, 5.8673405488E+01, 1.4208784229E+01, 1.8167573533E+01, 7.0192373974E+00, 9.2067453401E-01],
	[3.0595000000E+04, 5.8689300327E+01, 1.4208762481E+01, 1.8177231848E+01, 7.0209008833E+00, 9.2071212592E-01],
	[3.0600000000E+04, 5.8705196874E+01, 1.4208740737E+01, 1.8186893716E+01, 7.0225640577E+00, 9.2074969927E-01],
	[3.0605000000E+04, 5.8721095128E+01, 1.4208718997E+01, 1.8196559138E+01, 7.0242269204E+00, 9.2078725408E-01],
	[3.0610000000E+04, 5.8736995089E+01, 1.4208697260E+01, 1.8206228114E+01, 7.0258894714E+00, 9.2082479035E-01],
	[3.0615000000E+04, 5.8752896758E+01, 1.4208675527E+01, 1.8215900644E+01, 7.0275517106E+00, 9.2086230809E-01],
	[3.0620000000E+04, 5.8768800134E+01, 1.4208653797E+01, 1.8225576731E+01, 7.0292136380E+00, 9.2089980731E-01],
	[3.0625000000E+04, 5.8784705216E+01, 1.4208632071E+01, 1.8235256374E+01, 7.0308752533E+00, 9.2093728802E-01],
	[3.0630000000E+04, 5.8800612006E+01, 1.4208610348E+01, 1.8244939574E+01, 7.0325365566E+00, 9.2097475022E-01],
	[3.0635000000E+04, 5.8816520503E+01, 1.4208588630E+01, 1.8254626332E+01, 7.0341975478E+00, 9.2101219392E-01],
	[3.0640000000E+04, 5.8832430706E+01, 1.4208566914E+01, 1.8264316649E+01, 7.0358582268E+00, 9.2104961913E-01],
	[3.0645000000E+04, 5.8848342616E+01, 1.4208545203E+01, 1.8274010525E+01, 7.0375185934E+00, 9.2108702587E-01],
	[3.0650000000E+04, 5.8864256232E+01, 1.4208523494E+01, 1.8283707961E+01, 7.0391786477E+00, 9.2112441413E-01],
	[3.0655000000E+04, 5.8880171555E+01, 1.4208501790E+01, 1.8293408957E+01, 7.0408383895E+00, 9.2116178392E-01],
	[3.0660000000E+04, 5.8896088585E+01, 1.4208480089E+01, 1.8303113516E+01, 7.0424978188E+00, 9.2119913526E-01],
	[3.0665000000E+04, 5.8912007320E+01, 1.4208458391E+01, 1.8312821636E+01, 7.0441569354E+00, 9.2123646815E-01],
	[3.0670000000E+04, 5.8927927762E+01, 1.4208436697E+01, 1.8322533319E+01, 7.0458157394E+00, 9.2127378260E-01],
	[3.0675000000E+04, 5.8943849910E+01, 1.4208415007E+01, 1.8332248567E+01, 7.0474742305E+00, 9.2131107862E-01],
	[3.0680000000E+04, 5.8959773763E+01, 1.4208393320E+01, 1.8341967378E+01, 7.0491324088E+00, 9.2134835621E-01],
	[3.0685000000E+04, 5.8975699323E+01, 1.4208371637E+01, 1.8351689755E+01, 7.0507902741E+00, 9.2138561539E-01],
	[3.0690000000E+04, 5.8991626589E+01, 1.4208349958E+01, 1.8361415697E+01, 7.0524478263E+00, 9.2142285616E-01],
	[3.0695000000E+04, 5.9007555560E+01, 1.4208328282E+01, 1.8371145206E+01, 7.0541050655E+00, 9.2146007853E-01],
	[3.0700000000E+04, 5.9023486236E+01, 1.4208306609E+01, 1.8380878283E+01, 7.0557619914E+00, 9.2149728251E-01],
	[3.0705000000E+04, 5.9039418619E+01, 1.4208284940E+01, 1.8390614927E+01, 7.0574186041E+00, 9.2153446811E-01],
	[3.0710000000E+04, 5.9055352706E+01, 1.4208263275E+01, 1.8400355140E+01, 7.0590749034E+00, 9.2157163533E-01],
	[3.0715000000E+04, 5.9071288499E+01, 1.4208241613E+01, 1.8410098923E+01, 7.0607308893E+00, 9.2160878418E-01],
	[3.0720000000E+04, 5.9087225998E+01, 1.4208219955E+01, 1.8419846276E+01, 7.0623865616E+00, 9.2164591468E-01],
	[3.0725000000E+04, 5.9103165201E+01, 1.4208198300E+01, 1.8429597199E+01, 7.0640419204E+00, 9.2168302682E-01],
	[3.0730000000E+04, 5.9119106109E+01, 1.4208176649E+01, 1.8439351695E+01, 7.0656969654E+00, 9.2172012063E-01],
	[3.0735000000E+04, 5.9135048722E+01, 1.4208155002E+01, 1.8449109763E+01, 7.0673516967E+00, 9.2175719610E-01],
	[3.0740000000E+04, 5.9150993041E+01, 1.4208133357E+01, 1.8458871403E+01, 7.0690061142E+00, 9.2179425324E-01],
	[3.0745000000E+04, 5.9166939063E+01, 1.4208111717E+01, 1.8468636618E+01, 7.0706602177E+00, 9.2183129206E-01],
	[3.0750000000E+04, 5.9182886791E+01, 1.4208090080E+01, 1.8478405408E+01, 7.0723140073E+00, 9.2186831258E-01],
	[3.0755000000E+04, 5.9198836223E+01, 1.4208068447E+01, 1.8488177772E+01, 7.0739674827E+00, 9.2190531479E-01],
	[3.0760000000E+04, 5.9214787359E+01, 1.4208046817E+01, 1.8497953713E+01, 7.0756206440E+00, 9.2194229871E-01],
	[3.0765000000E+04, 5.9230740200E+01, 1.4208025191E+01, 1.8507733230E+01, 7.0772734911E+00, 9.2197926435E-01],
	[3.0770000000E+04, 5.9246694745E+01, 1.4208003568E+01, 1.8517516325E+01, 7.0789260239E+00, 9.2201621170E-01],
	[3.0775000000E+04, 5.9262650995E+01, 1.4207981949E+01, 1.8527302998E+01, 7.0805782422E+00, 9.2205314079E-01],
	[3.0780000000E+04, 5.9278608948E+01, 1.4207960333E+01, 1.8537093250E+01, 7.0822301461E+00, 9.2209005162E-01],
	[3.0785000000E+04, 5.9294568605E+01, 1.4207938721E+01, 1.8546887081E+01, 7.0838817354E+00, 9.2212694420E-01],
	[3.0790000000E+04, 5.9310529967E+01, 1.4207917113E+01, 1.8556684493E+01, 7.0855330101E+00, 9.2216381853E-01],
	[3.0795000000E+04, 5.9326493032E+01, 1.4207895508E+01, 1.8566485486E+01, 7.0871839701E+00, 9.2220067463E-01],
	[3.0800000000E+04, 5.9342457800E+01, 1.4207873906E+01, 1.8576290061E+01, 7.0888346154E+00, 9.2223751250E-01],
	[3.0805000000E+04, 5.9358424273E+01, 1.4207852308E+01, 1.8586098218E+01, 7.0904849457E+00, 9.2227433214E-01],
	[3.0810000000E+04, 5.9374392449E+01, 1.4207830714E+01, 1.8595909959E+01, 7.0921349611E+00, 9.2231113358E-01],
	[3.0815000000E+04, 5.9390362328E+01, 1.4207809123E+01, 1.8605725284E+01, 7.0937846615E+00, 9.2234791682E-01],
	[3.0820000000E+04, 5.9406333910E+01, 1.4207787536E+01, 1.8615544193E+01, 7.0954340468E+00, 9.2238468185E-01],
	[3.0825000000E+04, 5.9422307196E+01, 1.4207765952E+01, 1.8625366688E+01, 7.0970831169E+00, 9.2242142871E-01],
	[3.0830000000E+04, 5.9438282185E+01, 1.4207744372E+01, 1.8635192769E+01, 7.0987318718E+00, 9.2245815738E-01],
	[3.0835000000E+04, 5.9454258877E+01, 1.4207722795E+01, 1.8645022436E+01, 7.1003803113E+00, 9.2249486788E-01],
	[3.0840000000E+04, 5.9470237272E+01, 1.4207701222E+01, 1.8654855692E+01, 7.1020284355E+00, 9.2253156022E-01],
	[3.0845000000E+04, 5.9486217370E+01, 1.4207679652E+01, 1.8664692536E+01, 7.1036762442E+00, 9.2256823441E-01],
	[3.0850000000E+04, 5.9502199170E+01, 1.4207658086E+01, 1.8674532969E+01, 7.1053237373E+00, 9.2260489045E-01],
	[3.0855000000E+04, 5.9518182673E+01, 1.4207636524E+01, 1.8684376991E+01, 7.1069709148E+00, 9.2264152836E-01],
	[3.0860000000E+04, 5.9534167879E+01, 1.4207614965E+01, 1.8694224605E+01, 7.1086177765E+00, 9.2267814813E-01],
	[3.0865000000E+04, 5.9550154787E+01, 1.4207593409E+01, 1.8704075809E+01, 7.1102643225E+00, 9.2271474978E-01],
	[3.0870000000E+04, 5.9566143398E+01, 1.4207571857E+01, 1.8713930606E+01, 7.1119105527E+00, 9.2275133332E-01],
	[3.0875000000E+04, 5.9582133711E+01, 1.4207550309E+01, 1.8723788995E+01, 7.1135564669E+00, 9.2278789876E-01],
	[3.0880000000E+04, 5.9598144015E+01, 1.4207531478E+01, 1.8733650977E+01, 7.1152030064E+00, 9.2282444610E-01],
	[3.0885000000E+04, 5.9614194878E+01, 1.4207518413E+01, 1.8743516554E+01, 7.1168512303E+00, 9.2286097535E-01],
	[3.0890000000E+04, 5.9630247464E+01, 1.4207505350E+01, 1.8753385726E+01, 7.1184991398E+00, 9.2289748652E-01],
	[3.0895000000E+04, 5.9646301773E+01, 1.4207492290E+01, 1.8763258493E+01, 7.1201467349E+00, 9.2293397962E-01],
	[3.0900000000E+04, 5.9662357806E+01, 1.4207479232E+01, 1.8773134857E+01, 7.1217940155E+00, 9.2297045465E-01],
	[3.0905000000E+04, 5.9678415562E+01, 1.4207466176E+01, 1.8783014817E+01, 7.1234409815E+00, 9.2300691163E-01],
	[3.0910000000E+04, 5.9694475041E+01, 1.4207453122E+01, 1.8792898376E+01, 7.1250876329E+00, 9.2304335056E-01],
	[3.0915000000E+04, 5.9710536243E+01, 1.4207440070E+01, 1.8802785533E+01, 7.1267339696E+00, 9.2307977146E-01],
	[3.0920000000E+04, 5.9726599167E+01, 1.4207427020E+01, 1.8812676289E+01, 7.1283799914E+00, 9.2311617432E-01],
	[3.0925000000E+04, 5.9742663815E+01, 1.4207413972E+01, 1.8822570645E+01, 7.1300256984E+00, 9.2315255916E-01],
	[3.0930000000E+04, 5.9758730185E+01, 1.4207400927E+01, 1.8832468602E+01, 7.1316710905E+00, 9.2318892598E-01],
	[3.0935000000E+04, 5.9774798278E+01, 1.4207387883E+01, 1.8842370161E+01, 7.1333161675E+00, 9.2322527480E-01],
	[3.0940000000E+04, 5.9790868094E+01, 1.4207374842E+01, 1.8852275321E+01, 7.1349609295E+00, 9.2326160562E-01],
	[3.0945000000E+04, 5.9806939632E+01, 1.4207361803E+01, 1.8862184085E+01, 7.1366053762E+00, 9.2329791846E-01],
	[3.0950000000E+04, 5.9823012892E+01, 1.4207348766E+01, 1.8872096452E+01, 7.1382495078E+00, 9.2333421331E-01],
	[3.0955000000E+04, 5.9839087875E+01, 1.4207335731E+01, 1.8882012423E+01, 7.1398933240E+00, 9.2337049018E-01],
	[3.0960000000E+04, 5.9855164579E+01, 1.4207322698E+01, 1.8891931999E+01, 7.1415368248E+00, 9.2340674910E-01],
	[3.0965000000E+04, 5.9871243006E+01, 1.4207309668E+01, 1.8901855181E+01, 7.1431800102E+00, 9.2344299005E-01],
	[3.0970000000E+04, 5.9887323155E+01, 1.4207296639E+01, 1.8911781970E+01, 7.1448228800E+00, 9.2347921306E-01],
	[3.0975000000E+04, 5.9903405025E+01, 1.4207283612E+01, 1.8921712366E+01, 7.1464654342E+00, 9.2351541813E-01],
	[3.0980000000E+04, 5.9919488618E+01, 1.4207270588E+01, 1.8931646370E+01, 7.1481076728E+00, 9.2355160526E-01],
	[3.0985000000E+04, 5.9935573932E+01, 1.4207257566E+01, 1.8941583983E+01, 7.1497495956E+00, 9.2358777447E-01],
	[3.0990000000E+04, 5.9951660967E+01, 1.4207244546E+01, 1.8951525205E+01, 7.1513912025E+00, 9.2362392577E-01],
	[3.0995000000E+04, 5.9967749724E+01, 1.4207231528E+01, 1.8961470037E+01, 7.1530324936E+00, 9.2366005916E-01],
	[3.1000000000E+04, 5.9983840203E+01, 1.4207218512E+01, 1.8971418480E+01, 7.1546734687E+00, 9.2369617465E-01],
	[3.1005000000E+04, 5.9999932402E+01, 1.4207205498E+01, 1.8981370535E+01, 7.1563141277E+00, 9.2373227225E-01],
	[3.1010000000E+04, 6.0016026323E+01, 1.4207192486E+01, 1.8991326202E+01, 7.1579544707E+00, 9.2376835196E-01],
	[3.1015000000E+04, 6.0032121966E+01, 1.4207179477E+01, 1.9001285482E+01, 7.1595944974E+00, 9.2380441381E-01],
	[3.1020000000E+04, 6.0048219329E+01, 1.4207166469E+01, 1.9011248375E+01, 7.1612342079E+00, 9.2384045778E-01],
	[3.1025000000E+04, 6.0064318413E+01, 1.4207153464E+01, 1.9021214884E+01, 7.1628736021E+00, 9.2387648390E-01],
	[3.1030000000E+04, 6.0080419218E+01, 1.4207140461E+01, 1.9031185007E+01, 7.1645126799E+00, 9.2391249217E-01],
	[3.1035000000E+04, 6.0096521743E+01, 1.4207127460E+01, 1.9041158747E+01, 7.1661514412E+00, 9.2394848260E-01],
	[3.1040000000E+04, 6.0112625990E+01, 1.4207114461E+01, 1.9051136103E+01, 7.1677898859E+00, 9.2398445519E-01],
	[3.1045000000E+04, 6.0128731956E+01, 1.4207101464E+01, 1.9061117077E+01, 7.1694280141E+00, 9.2402040996E-01],
	[3.1050000000E+04, 6.0144839644E+01, 1.4207088469E+01, 1.9071101669E+01, 7.1710658255E+00, 9.2405634691E-01],
	[3.1055000000E+04, 6.0160949051E+01, 1.4207075476E+01, 1.9081089879E+01, 7.1727033203E+00, 9.2409226606E-01],
	[3.1060000000E+04, 6.0177060179E+01, 1.4207062486E+01, 1.9091081710E+01, 7.1743404981E+00, 9.2412816740E-01],
	[3.1065000000E+04, 6.0193173028E+01, 1.4207049497E+01, 1.9101077160E+01, 7.1759773591E+00, 9.2416405096E-01],
	[3.1070000000E+04, 6.0209287596E+01, 1.4207036511E+01, 1.9111076232E+01, 7.1776139031E+00, 9.2419991672E-01],
	[3.1075000000E+04, 6.0225403884E+01, 1.4207023526E+01, 1.9121078926E+01, 7.1792501301E+00, 9.2423576472E-01],
	[3.1080000000E+04, 6.0241521892E+01, 1.4207010544E+01, 1.9131085242E+01, 7.1808860400E+00, 9.2427159495E-01],
	[3.1085000000E+04, 6.0257641620E+01, 1.4206997564E+01, 1.9141095181E+01, 7.1825216327E+00, 9.2430740741E-01],
	[3.1090000000E+04, 6.0273763068E+01, 1.4206984586E+01, 1.9151108744E+01, 7.1841569082E+00, 9.2434320213E-01],
	[3.1095000000E+04, 6.0289886235E+01, 1.4206971610E+01, 1.9161125932E+01, 7.1857918663E+00, 9.2437897911E-01],
	[3.1100000000E+04, 6.0306011122E+01, 1.4206958636E+01, 1.9171146745E+01, 7.1874265071E+00, 9.2441473835E-01],
	[3.1105000000E+04, 6.0322137728E+01, 1.4206945665E+01, 1.9181171185E+01, 7.1890608304E+00, 9.2445047987E-01],
	[3.1110000000E+04, 6.0338266054E+01, 1.4206932695E+01, 1.9191199251E+01, 7.1906948362E+00, 9.2448620366E-01],
	[3.1115000000E+04, 6.0354396099E+01, 1.4206919728E+01, 1.9201230945E+01, 7.1923285244E+00, 9.2452190975E-01],
	[3.1120000000E+04, 6.0370527863E+01, 1.4206906762E+01, 1.9211266267E+01, 7.1939618950E+00, 9.2455759814E-01],
	[3.1125000000E+04, 6.0386661346E+01, 1.4206893799E+01, 1.9221305219E+01, 7.1955949478E+00, 9.2459326884E-01],
	[3.1130000000E+04, 6.0402796548E+01, 1.4206880838E+01, 1.9231347800E+01, 7.1972276828E+00, 9.2462892185E-01],
	[3.1135000000E+04, 6.0418933469E+01, 1.4206867878E+01, 1.9241394012E+01, 7.1988601000E+00, 9.2466455718E-01],
	[3.1140000000E+04, 6.0435072109E+01, 1.4206854921E+01, 1.9251443855E+01, 7.2004921992E+00, 9.2470017485E-01],
	[3.1145000000E+04, 6.0451212467E+01, 1.4206841966E+01, 1.9261497330E+01, 7.2021239805E+00, 9.2473577486E-01],
	[3.1150000000E+04, 6.0467354544E+01, 1.4206829014E+01, 1.9271554437E+01, 7.2037554436E+00, 9.2477135722E-01],
	[3.1155000000E+04, 6.0483498340E+01, 1.4206816063E+01, 1.9281615178E+01, 7.2053865887E+00, 9.2480692193E-01],
	[3.1160000000E+04, 6.0499643854E+01, 1.4206803114E+01, 1.9291679553E+01, 7.2070174155E+00, 9.2484246901E-01],
	[3.1165000000E+04, 6.0515791086E+01, 1.4206790168E+01, 1.9301747563E+01, 7.2086479240E+00, 9.2487799846E-01],
	[3.1170000000E+04, 6.0531940036E+01, 1.4206777223E+01, 1.9311819209E+01, 7.2102781143E+00, 9.2491351029E-01],
	[3.1175000000E+04, 6.0548090705E+01, 1.4206764281E+01, 1.9321894491E+01, 7.2119079861E+00, 9.2494900452E-01],
	[3.1180000000E+04, 6.0564243092E+01, 1.4206751340E+01, 1.9331973410E+01, 7.2135375395E+00, 9.2498448114E-01],
	[3.1185000000E+04, 6.0580397196E+01, 1.4206738402E+01, 1.9342055967E+01, 7.2151667743E+00, 9.2501994017E-01],
	[3.1190000000E+04, 6.0596553019E+01, 1.4206725466E+01, 1.9352142163E+01, 7.2167956905E+00, 9.2505538161E-01],
	[3.1195000000E+04, 6.0612710559E+01, 1.4206712532E+01, 1.9362231997E+01, 7.2184242880E+00, 9.2509080548E-01],
	[3.1200000000E+04, 6.0628869817E+01, 1.4206699600E+01, 1.9372325472E+01, 7.2200525669E+00, 9.2512621177E-01],
	[3.1205000000E+04, 6.0645030793E+01, 1.4206686670E+01, 1.9382422587E+01, 7.2216805269E+00, 9.2516160051E-01],
	[3.1210000000E+04, 6.0661193486E+01, 1.4206673742E+01, 1.9392523344E+01, 7.2233081680E+00, 9.2519697170E-01],
	[3.1215000000E+04, 6.0677357896E+01, 1.4206660816E+01, 1.9402627743E+01, 7.2249354902E+00, 9.2523232534E-01],
	[3.1220000000E+04, 6.0693524024E+01, 1.4206647893E+01, 1.9412735785E+01, 7.2265624934E+00, 9.2526766144E-01],
	[3.1225000000E+04, 6.0709691869E+01, 1.4206634971E+01, 1.9422847471E+01, 7.2281891776E+00, 9.2530298002E-01],
	[3.1230000000E+04, 6.0725861431E+01, 1.4206622052E+01, 1.9432962801E+01, 7.2298155426E+00, 9.2533828108E-01],
	[3.1235000000E+04, 6.0742032710E+01, 1.4206609134E+01, 1.9443081776E+01, 7.2314415884E+00, 9.2537356463E-01],
	[3.1240000000E+04, 6.0758205706E+01, 1.4206596219E+01, 1.9453204396E+01, 7.2330673150E+00, 9.2540883067E-01],
	[3.1245000000E+04, 6.0774380419E+01, 1.4206583306E+01, 1.9463330664E+01, 7.2346927222E+00, 9.2544407923E-01],
	[3.1250000000E+04, 6.0790556848E+01, 1.4206570395E+01, 1.9473460578E+01, 7.2363178101E+00, 9.2547931029E-01],
	[3.1255000000E+04, 6.0806734995E+01, 1.4206557485E+01, 1.9483594141E+01, 7.2379425785E+00, 9.2551452388E-01],
	[3.1260000000E+04, 6.0822914857E+01, 1.4206544578E+01, 1.9493731352E+01, 7.2395670273E+00, 9.2554972000E-01],
	[3.1265000000E+04, 6.0839096437E+01, 1.4206531673E+01, 1.9503872213E+01, 7.2411911566E+00, 9.2558489866E-01],
	[3.1270000000E+04, 6.0855279732E+01, 1.4206518771E+01, 1.9514016724E+01, 7.2428149663E+00, 9.2562005986E-01],
	[3.1275000000E+04, 6.0871464744E+01, 1.4206505870E+01, 1.9524164886E+01, 7.2444384562E+00, 9.2565520362E-01],
	[3.1280000000E+04, 6.0887651473E+01, 1.4206492971E+01, 1.9534316699E+01, 7.2460616264E+00, 9.2569032995E-01],
	[3.1285000000E+04, 6.0903839917E+01, 1.4206480074E+01, 1.9544472165E+01, 7.2476844767E+00, 9.2572543884E-01],
	[3.1290000000E+04, 6.0920030077E+01, 1.4206467180E+01, 1.9554631284E+01, 7.2493070071E+00, 9.2576053032E-01],
	[3.1295000000E+04, 6.0936221953E+01, 1.4206454287E+01, 1.9564794057E+01, 7.2509292175E+00, 9.2579560438E-01],
	[3.1300000000E+04, 6.0952415545E+01, 1.4206441397E+01, 1.9574960484E+01, 7.2525511080E+00, 9.2583066105E-01],
	[3.1305000000E+04, 6.0968610853E+01, 1.4206428509E+01, 1.9585130567E+01, 7.2541726783E+00, 9.2586570031E-01],
	[3.1310000000E+04, 6.0984807876E+01, 1.4206415622E+01, 1.9595304305E+01, 7.2557939285E+00, 9.2590072219E-01],
	[3.1315000000E+04, 6.1001006615E+01, 1.4206402738E+01, 1.9605481701E+01, 7.2574148584E+00, 9.2593572670E-01],
	[3.1320000000E+04, 6.1017207070E+01, 1.4206389856E+01, 1.9615662754E+01, 7.2590354681E+00, 9.2597071383E-01],
	[3.1325000000E+04, 6.1033409239E+01, 1.4206376976E+01, 1.9625847465E+01, 7.2606557574E+00, 9.2600568360E-01],
	[3.1330000000E+04, 6.1049613124E+01, 1.4206364098E+01, 1.9636035835E+01, 7.2622757263E+00, 9.2604063601E-01],
	[3.1335000000E+04, 6.1065818724E+01, 1.4206351222E+01, 1.9646227864E+01, 7.2638953748E+00, 9.2607557109E-01],
	[3.1340000000E+04, 6.1082026040E+01, 1.4206338348E+01, 1.9656423554E+01, 7.2655147027E+00, 9.2611048882E-01],
	[3.1345000000E+04, 6.1098235070E+01, 1.4206325476E+01, 1.9666622905E+01, 7.2671337100E+00, 9.2614538923E-01],
	[3.1350000000E+04, 6.1114445815E+01, 1.4206312606E+01, 1.9676825918E+01, 7.2687523967E+00, 9.2618027231E-01],
	[3.1355000000E+04, 6.1130658275E+01, 1.4206299739E+01, 1.9687032594E+01, 7.2703707627E+00, 9.2621513809E-01],
	[3.1360000000E+04, 6.1146872450E+01, 1.4206286873E+01, 1.9697242933E+01, 7.2719888079E+00, 9.2624998656E-01],
	[3.1365000000E+04, 6.1163088339E+01, 1.4206274010E+01, 1.9707456936E+01, 7.2736065322E+00, 9.2628481773E-01],
	[3.1370000000E+04, 6.1179305943E+01, 1.4206261148E+01, 1.9717674603E+01, 7.2752239356E+00, 9.2631963162E-01],
	[3.1375000000E+04, 6.1195525261E+01, 1.4206248289E+01, 1.9727895936E+01, 7.2768410181E+00, 9.2635442822E-01],
	[3.1380000000E+04, 6.1211797200E+01, 1.4206242912E+01, 1.9738120936E+01, 7.2784604630E+00, 9.2638920756E-01],
	[3.1385000000E+04, 6.1228076524E+01, 1.4206238367E+01, 1.9748349602E+01, 7.2800798864E+00, 9.2642396964E-01],
	[3.1390000000E+04, 6.1244357583E+01, 1.4206233822E+01, 1.9758581936E+01, 7.2816989904E+00, 9.2645871446E-01],
	[3.1395000000E+04, 6.1260640377E+01, 1.4206229279E+01, 1.9768817938E+01, 7.2833177749E+00, 9.2649344203E-01],
	[3.1400000000E+04, 6.1276924906E+01, 1.4206224735E+01, 1.9779057610E+01, 7.2849362399E+00, 9.2652815237E-01],
	[3.1405000000E+04, 6.1293211170E+01, 1.4206220193E+01, 1.9789300951E+01, 7.2865543853E+00, 9.2656284548E-01],
	[3.1410000000E+04, 6.1309499169E+01, 1.4206215651E+01, 1.9799547963E+01, 7.2881722111E+00, 9.2659752136E-01],
	[3.1415000000E+04, 6.1325788903E+01, 1.4206211111E+01, 1.9809798647E+01, 7.2897897173E+00, 9.2663218004E-01],
	[3.1420000000E+04, 6.1342080371E+01, 1.4206206570E+01, 1.9820053002E+01, 7.2914069036E+00, 9.2666682151E-01],
	[3.1425000000E+04, 6.1358373574E+01, 1.4206202031E+01, 1.9830311030E+01, 7.2930237701E+00, 9.2670144578E-01],
	[3.1430000000E+04, 6.1374668511E+01, 1.4206197492E+01, 1.9840572732E+01, 7.2946403168E+00, 9.2673605287E-01],
	[3.1435000000E+04, 6.1390965183E+01, 1.4206192954E+01, 1.9850838108E+01, 7.2962565435E+00, 9.2677064277E-01],
	[3.1440000000E+04, 6.1407263589E+01, 1.4206188417E+01, 1.9861107158E+01, 7.2978724503E+00, 9.2680521551E-01],
	[3.1445000000E+04, 6.1423563729E+01, 1.4206183880E+01, 1.9871379885E+01, 7.2994880369E+00, 9.2683977108E-01],
	[3.1450000000E+04, 6.1439865603E+01, 1.4206179344E+01, 1.9881656288E+01, 7.3011033035E+00, 9.2687430950E-01],
	[3.1455000000E+04, 6.1456169211E+01, 1.4206174809E+01, 1.9891936368E+01, 7.3027182499E+00, 9.2690883077E-01],
	[3.1460000000E+04, 6.1472474553E+01, 1.4206170275E+01, 1.9902220126E+01, 7.3043328760E+00, 9.2694333490E-01],
	[3.1465000000E+04, 6.1488781629E+01, 1.4206165741E+01, 1.9912507563E+01, 7.3059471819E+00, 9.2697782190E-01],
	[3.1470000000E+04, 6.1505090439E+01, 1.4206161208E+01, 1.9922798679E+01, 7.3075611674E+00, 9.2701229178E-01],
	[3.1475000000E+04, 6.1521400982E+01, 1.4206156676E+01, 1.9933093475E+01, 7.3091748325E+00, 9.2704674455E-01],
	[3.1480000000E+04, 6.1537713259E+01, 1.4206152145E+01, 1.9943391952E+01, 7.3107881771E+00, 9.2708118021E-01],
	[3.1485000000E+04, 6.1554027269E+01, 1.4206147614E+01, 1.9953694110E+01, 7.3124012012E+00, 9.2711559877E-01],
	[3.1490000000E+04, 6.1570343012E+01, 1.4206143084E+01, 1.9963999951E+01, 7.3140139047E+00, 9.2715000025E-01],
	[3.1495000000E+04, 6.1586660489E+01, 1.4206138554E+01, 1.9974309475E+01, 7.3156262876E+00, 9.2718438465E-01],
	[3.1500000000E+04, 6.1602979699E+01, 1.4206134026E+01, 1.9984622682E+01, 7.3172383498E+00, 9.2721875197E-01],
	[3.1505000000E+04, 6.1619300642E+01, 1.4206129498E+01, 1.9994939574E+01, 7.3188500912E+00, 9.2725310223E-01],
	[3.1510000000E+04, 6.1635623318E+01, 1.4206124971E+01, 2.0005260151E+01, 7.3204615118E+00, 9.2728743544E-01],
	[3.1515000000E+04, 6.1651947727E+01, 1.4206120444E+01, 2.0015584414E+01, 7.3220726115E+00, 9.2732175160E-01],
	[3.1520000000E+04, 6.1668273869E+01, 1.4206115918E+01, 2.0025912364E+01, 7.3236833903E+00, 9.2735605072E-01],
	[3.1525000000E+04, 6.1684601743E+01, 1.4206111393E+01, 2.0036244001E+01, 7.3252938480E+00, 9.2739033280E-01],
	[3.1530000000E+04, 6.1700931351E+01, 1.4206106869E+01, 2.0046579326E+01, 7.3269039848E+00, 9.2742459787E-01],
	[3.1535000000E+04, 6.1717262690E+01, 1.4206102345E+01, 2.0056918340E+01, 7.3285138004E+00, 9.2745884592E-01],
	[3.1540000000E+04, 6.1733595762E+01, 1.4206097822E+01, 2.0067261044E+01, 7.3301232949E+00, 9.2749307697E-01],
	[3.1545000000E+04, 6.1749930567E+01, 1.4206093300E+01, 2.0077607438E+01, 7.3317324681E+00, 9.2752729102E-01],
	[3.1550000000E+04, 6.1766267104E+01, 1.4206088779E+01, 2.0087957522E+01, 7.3333413201E+00, 9.2756148808E-01],
	[3.1555000000E+04, 6.1782605372E+01, 1.4206084258E+01, 2.0098311299E+01, 7.3349498508E+00, 9.2759566816E-01],
	[3.1560000000E+04, 6.1798945373E+01, 1.4206079738E+01, 2.0108668768E+01, 7.3365580600E+00, 9.2762983126E-01],
	[3.1565000000E+04, 6.1815287106E+01, 1.4206075219E+01, 2.0119029931E+01, 7.3381659478E+00, 9.2766397740E-01],
	[3.1570000000E+04, 6.1831630571E+01, 1.4206070700E+01, 2.0129394787E+01, 7.3397735141E+00, 9.2769810659E-01],
	[3.1575000000E+04, 6.1847975768E+01, 1.4206066182E+01, 2.0139763338E+01, 7.3413807589E+00, 9.2773221883E-01],
	[3.1580000000E+04, 6.1864322696E+01, 1.4206061665E+01, 2.0150135584E+01, 7.3429876820E+00, 9.2776631413E-01],
	[3.1585000000E+04, 6.1880671356E+01, 1.4206057149E+01, 2.0160511527E+01, 7.3445942835E+00, 9.2780039249E-01],
	[3.1590000000E+04, 6.1897021748E+01, 1.4206052633E+01, 2.0170891166E+01, 7.3462005632E+00, 9.2783445394E-01],
	[3.1595000000E+04, 6.1913373871E+01, 1.4206048118E+01, 2.0181274503E+01, 7.3478065212E+00, 9.2786849847E-01],
	[3.1600000000E+04, 6.1929727725E+01, 1.4206043604E+01, 2.0191661539E+01, 7.3494121573E+00, 9.2790252609E-01],
	[3.1605000000E+04, 6.1946083311E+01, 1.4206039090E+01, 2.0202052273E+01, 7.3510174715E+00, 9.2793653681E-01],
	[3.1610000000E+04, 6.1962440628E+01, 1.4206034578E+01, 2.0212446707E+01, 7.3526224638E+00, 9.2797053065E-01],
	[3.1615000000E+04, 6.1978799676E+01, 1.4206030065E+01, 2.0222844842E+01, 7.3542271341E+00, 9.2800450760E-01],
	[3.1620000000E+04, 6.1995160455E+01, 1.4206025554E+01, 2.0233246678E+01, 7.3558314823E+00, 9.2803846768E-01],
	[3.1625000000E+04, 6.2011522964E+01, 1.4206021043E+01, 2.0243652216E+01, 7.3574355084E+00, 9.2807241089E-01],
	[3.1630000000E+04, 6.2027887205E+01, 1.4206016533E+01, 2.0254061457E+01, 7.3590392124E+00, 9.2810633725E-01],
	[3.1635000000E+04, 6.2044253176E+01, 1.4206012024E+01, 2.0264474401E+01, 7.3606425941E+00, 9.2814024676E-01],
	[3.1640000000E+04, 6.2060620878E+01, 1.4206007516E+01, 2.0274891049E+01, 7.3622456536E+00, 9.2817413943E-01],
	[3.1645000000E+04, 6.2076990311E+01, 1.4206003008E+01, 2.0285311402E+01, 7.3638483907E+00, 9.2820801526E-01],
	[3.1650000000E+04, 6.2093361474E+01, 1.4205998501E+01, 2.0295735461E+01, 7.3654508054E+00, 9.2824187428E-01],
	[3.1655000000E+04, 6.2109734367E+01, 1.4205993994E+01, 2.0306163227E+01, 7.3670528978E+00, 9.2827571647E-01],
	[3.1660000000E+04, 6.2126108991E+01, 1.4205989488E+01, 2.0316594699E+01, 7.3686546676E+00, 9.2830954186E-01],
	[3.1665000000E+04, 6.2142485345E+01, 1.4205984983E+01, 2.0327029879E+01, 7.3702561149E+00, 9.2834335045E-01],
	[3.1670000000E+04, 6.2158863428E+01, 1.4205980479E+01, 2.0337468768E+01, 7.3718572395E+00, 9.2837714225E-01],
	[3.1675000000E+04, 6.2175243242E+01, 1.4205975976E+01, 2.0347911366E+01, 7.3734580416E+00, 9.2841091727E-01],
	[3.1680000000E+04, 6.2191624786E+01, 1.4205971473E+01, 2.0358357674E+01, 7.3750585209E+00, 9.2844467551E-01],
	[3.1685000000E+04, 6.2208008060E+01, 1.4205966971E+01, 2.0368807693E+01, 7.3766586775E+00, 9.2847841699E-01],
	[3.1690000000E+04, 6.2224393063E+01, 1.4205962469E+01, 2.0379261423E+01, 7.3782585113E+00, 9.2851214171E-01],
	[3.1695000000E+04, 6.2240779796E+01, 1.4205957968E+01, 2.0389718866E+01, 7.3798580222E+00, 9.2854584968E-01],
	[3.1700000000E+04, 6.2257168258E+01, 1.4205953468E+01, 2.0400180021E+01, 7.3814572102E+00, 9.2857954091E-01],
	[3.1705000000E+04, 6.2273558450E+01, 1.4205948969E+01, 2.0410644890E+01, 7.3830560752E+00, 9.2861321540E-01],
	[3.1710000000E+04, 6.2289950372E+01, 1.4205944471E+01, 2.0421113474E+01, 7.3846546172E+00, 9.2864687318E-01],
	[3.1715000000E+04, 6.2306344022E+01, 1.4205939973E+01, 2.0431585773E+01, 7.3862528361E+00, 9.2868051423E-01],
	[3.1720000000E+04, 6.2322739402E+01, 1.4205935476E+01, 2.0442061787E+01, 7.3878507320E+00, 9.2871413858E-01],
	[3.1725000000E+04, 6.2339136511E+01, 1.4205930979E+01, 2.0452541518E+01, 7.3894483046E+00, 9.2874774622E-01],
	[3.1730000000E+04, 6.2355535349E+01, 1.4205926483E+01, 2.0463024967E+01, 7.3910455540E+00, 9.2878133718E-01],
	[3.1735000000E+04, 6.2371935916E+01, 1.4205921988E+01, 2.0473512133E+01, 7.3926424802E+00, 9.2881491145E-01],
	[3.1740000000E+04, 6.2388338211E+01, 1.4205917494E+01, 2.0484003019E+01, 7.3942390830E+00, 9.2884846905E-01],
	[3.1745000000E+04, 6.2404742236E+01, 1.4205913000E+01, 2.0494497624E+01, 7.3958353624E+00, 9.2888200998E-01],
	[3.1750000000E+04, 6.2421147989E+01, 1.4205908508E+01, 2.0504995949E+01, 7.3974313184E+00, 9.2891553425E-01],
	[3.1755000000E+04, 6.2437555470E+01, 1.4205904015E+01, 2.0515497995E+01, 7.3990269509E+00, 9.2894904187E-01],
	[3.1760000000E+04, 6.2453964680E+01, 1.4205899524E+01, 2.0526003763E+01, 7.4006222599E+00, 9.2898253285E-01],
	[3.1765000000E+04, 6.2470375619E+01, 1.4205895033E+01, 2.0536513253E+01, 7.4022172453E+00, 9.2901600719E-01],
	[3.1770000000E+04, 6.2486788285E+01, 1.4205890543E+01, 2.0547026467E+01, 7.4038119070E+00, 9.2904946491E-01],
	[3.1775000000E+04, 6.2503202680E+01, 1.4205886054E+01, 2.0557543404E+01, 7.4054062451E+00, 9.2908290602E-01],
	[3.1780000000E+04, 6.2519618803E+01, 1.4205881565E+01, 2.0568064067E+01, 7.4070002594E+00, 9.2911633051E-01],
	[3.1785000000E+04, 6.2536036654E+01, 1.4205877077E+01, 2.0578588454E+01, 7.4085939500E+00, 9.2914973840E-01],
	[3.1790000000E+04, 6.2552456233E+01, 1.4205872590E+01, 2.0589116568E+01, 7.4101873167E+00, 9.2918312970E-01],
	[3.1795000000E+04, 6.2568877540E+01, 1.4205868103E+01, 2.0599648408E+01, 7.4117803595E+00, 9.2921650442E-01],
	[3.1800000000E+04, 6.2585300574E+01, 1.4205863617E+01, 2.0610183976E+01, 7.4133730784E+00, 9.2924986256E-01],
	[3.1805000000E+04, 6.2601725336E+01, 1.4205859132E+01, 2.0620723273E+01, 7.4149654733E+00, 9.2928320413E-01],
	[3.1810000000E+04, 6.2618151826E+01, 1.4205854648E+01, 2.0631266298E+01, 7.4165575442E+00, 9.2931652914E-01],
	[3.1815000000E+04, 6.2634580043E+01, 1.4205850164E+01, 2.0641813053E+01, 7.4181492910E+00, 9.2934983760E-01],
	[3.1820000000E+04, 6.2651009988E+01, 1.4205845681E+01, 2.0652363539E+01, 7.4197407136E+00, 9.2938312952E-01],
	[3.1825000000E+04, 6.2667441660E+01, 1.4205841199E+01, 2.0662917756E+01, 7.4213318121E+00, 9.2941640490E-01],
	[3.1830000000E+04, 6.2683875059E+01, 1.4205836717E+01, 2.0673475704E+01, 7.4229225863E+00, 9.2944966376E-01],
	[3.1835000000E+04, 6.2700310185E+01, 1.4205832237E+01, 2.0684037386E+01, 7.4245130363E+00, 9.2948290609E-01],
	[3.1840000000E+04, 6.2716747038E+01, 1.4205827756E+01, 2.0694602801E+01, 7.4261031619E+00, 9.2951613192E-01],
	[3.1845000000E+04, 6.2733185619E+01, 1.4205823277E+01, 2.0705171950E+01, 7.4276929631E+00, 9.2954934125E-01],
	[3.1850000000E+04, 6.2749625926E+01, 1.4205818798E+01, 2.0715744834E+01, 7.4292824399E+00, 9.2958253408E-01],
	[3.1855000000E+04, 6.2766067959E+01, 1.4205814320E+01, 2.0726321454E+01, 7.4308715923E+00, 9.2961571042E-01],
	[3.1860000000E+04, 6.2782511720E+01, 1.4205809843E+01, 2.0736901810E+01, 7.4324604201E+00, 9.2964887029E-01],
	[3.1865000000E+04, 6.2798957207E+01, 1.4205805366E+01, 2.0747485903E+01, 7.4340489233E+00, 9.2968201369E-01],
	[3.1870000000E+04, 6.2815404420E+01, 1.4205800890E+01, 2.0758073734E+01, 7.4356371019E+00, 9.2971514063E-01],
	[3.1875000000E+04, 6.2831853360E+01, 1.4205796415E+01, 2.0768665303E+01, 7.4372249559E+00, 9.2974825112E-01],
	[3.1880000000E+04, 6.2848304026E+01, 1.4205791940E+01, 2.0779260612E+01, 7.4388124851E+00, 9.2978134516E-01],
	[3.1885000000E+04, 6.2864805639E+01, 1.4205794634E+01, 2.0789859661E+01, 7.4404023452E+00, 9.2981442277E-01],
	[3.1890000000E+04, 6.2881315740E+01, 1.4205798308E+01, 2.0800462451E+01, 7.4419922458E+00, 9.2984748395E-01],
	[3.1895000000E+04, 6.2897827587E+01, 1.4205801982E+01, 2.0811068982E+01, 7.4435818233E+00, 9.2988052871E-01],
	[3.1900000000E+04, 6.2914341180E+01, 1.4205805656E+01, 2.0821679255E+01, 7.4451710775E+00, 9.2991355705E-01],
	[3.1905000000E+04, 6.2930856521E+01, 1.4205809329E+01, 2.0832293271E+01, 7.4467600085E+00, 9.2994656900E-01],
	[3.1910000000E+04, 6.2947373607E+01, 1.4205813001E+01, 2.0842911031E+01, 7.4483486162E+00, 9.2997956455E-01],
	[3.1915000000E+04, 6.2963892440E+01, 1.4205816673E+01, 2.0853532535E+01, 7.4499369005E+00, 9.3001254371E-01],
	[3.1920000000E+04, 6.2980413019E+01, 1.4205820344E+01, 2.0864157785E+01, 7.4515248615E+00, 9.3004550650E-01],
	[3.1925000000E+04, 6.2996935344E+01, 1.4205824015E+01, 2.0874786780E+01, 7.4531124989E+00, 9.3007845291E-01],
	[3.1930000000E+04, 6.3013459415E+01, 1.4205827685E+01, 2.0885419522E+01, 7.4546998129E+00, 9.3011138296E-01],
	[3.1935000000E+04, 6.3029985231E+01, 1.4205831354E+01, 2.0896056011E+01, 7.4562868034E+00, 9.3014429666E-01],
	[3.1940000000E+04, 6.3046512794E+01, 1.4205835023E+01, 2.0906696248E+01, 7.4578734702E+00, 9.3017719401E-01],
	[3.1945000000E+04, 6.3063042102E+01, 1.4205838691E+01, 2.0917340235E+01, 7.4594598134E+00, 9.3021007501E-01],
	[3.1950000000E+04, 6.3079573156E+01, 1.4205842359E+01, 2.0927987970E+01, 7.4610458329E+00, 9.3024293969E-01],
	[3.1955000000E+04, 6.3096105956E+01, 1.4205846026E+01, 2.0938639456E+01, 7.4626315287E+00, 9.3027578803E-01],
	[3.1960000000E+04, 6.3112640501E+01, 1.4205849693E+01, 2.0949294693E+01, 7.4642169008E+00, 9.3030862005E-01],
	[3.1965000000E+04, 6.3129176791E+01, 1.4205853359E+01, 2.0959953682E+01, 7.4658019490E+00, 9.3034143576E-01],
	[3.1970000000E+04, 6.3145714827E+01, 1.4205857024E+01, 2.0970616423E+01, 7.4673866733E+00, 9.3037423517E-01],
	[3.1975000000E+04, 6.3162254607E+01, 1.4205860689E+01, 2.0981282917E+01, 7.4689710737E+00, 9.3040701827E-01],
	[3.1980000000E+04, 6.3178796133E+01, 1.4205864353E+01, 2.0991953165E+01, 7.4705551502E+00, 9.3043978509E-01],
	[3.1985000000E+04, 6.3195339404E+01, 1.4205868017E+01, 2.1002627168E+01, 7.4721389026E+00, 9.3047253561E-01],
	[3.1990000000E+04, 6.3211884420E+01, 1.4205871680E+01, 2.1013304927E+01, 7.4737223311E+00, 9.3050526986E-01],
	[3.1995000000E+04, 6.3228431181E+01, 1.4205875343E+01, 2.1023986441E+01, 7.4753054354E+00, 9.3053798785E-01],
	[3.2000000000E+04, 6.3244979686E+01, 1.4205879005E+01, 2.1034671713E+01, 7.4768882155E+00, 9.3057068956E-01],
	[3.2005000000E+04, 6.3261529936E+01, 1.4205882666E+01, 2.1045360742E+01, 7.4784706715E+00, 9.3060337502E-01],
	[3.2010000000E+04, 6.3278081931E+01, 1.4205886327E+01, 2.1056053529E+01, 7.4800528033E+00, 9.3063604424E-01],
	[3.2015000000E+04, 6.3294635670E+01, 1.4205889988E+01, 2.1066750075E+01, 7.4816346108E+00, 9.3066869721E-01],
	[3.2020000000E+04, 6.3311191153E+01, 1.4205893647E+01, 2.1077450381E+01, 7.4832160939E+00, 9.3070133394E-01],
	[3.2025000000E+04, 6.3327748381E+01, 1.4205897307E+01, 2.1088154448E+01, 7.4847972527E+00, 9.3073395445E-01],
	[3.2030000000E+04, 6.3344307353E+01, 1.4205900965E+01, 2.1098862276E+01, 7.4863780871E+00, 9.3076655874E-01],
	[3.2035000000E+04, 6.3360868069E+01, 1.4205904623E+01, 2.1109573866E+01, 7.4879585971E+00, 9.3079914682E-01],
	[3.2040000000E+04, 6.3377430529E+01, 1.4205908281E+01, 2.1120289218E+01, 7.4895387825E+00, 9.3083171869E-01],
	[3.2045000000E+04, 6.3393994733E+01, 1.4205911938E+01, 2.1131008334E+01, 7.4911186434E+00, 9.3086427436E-01],
	[3.2050000000E+04, 6.3410560681E+01, 1.4205915594E+01, 2.1141731215E+01, 7.4926981798E+00, 9.3089681384E-01],
	[3.2055000000E+04, 6.3427128373E+01, 1.4205919250E+01, 2.1152457860E+01, 7.4942773914E+00, 9.3092933714E-01],
	[3.2060000000E+04, 6.3443697808E+01, 1.4205922905E+01, 2.1163188271E+01, 7.4958562785E+00, 9.3096184426E-01],
	[3.2065000000E+04, 6.3460268987E+01, 1.4205926559E+01, 2.1173922448E+01, 7.4974348408E+00, 9.3099433521E-01],
	[3.2070000000E+04, 6.3476841909E+01, 1.4205930213E+01, 2.1184660392E+01, 7.4990130783E+00, 9.3102681000E-01],
	[3.2075000000E+04, 6.3493416575E+01, 1.4205933867E+01, 2.1195402105E+01, 7.5005909911E+00, 9.3105926863E-01],
	[3.2080000000E+04, 6.3509992984E+01, 1.4205937520E+01, 2.1206147585E+01, 7.5021685790E+00, 9.3109171111E-01],
	[3.2085000000E+04, 6.3526571137E+01, 1.4205941172E+01, 2.1216896836E+01, 7.5037458420E+00, 9.3112413745E-01],
	[3.2090000000E+04, 6.3543151032E+01, 1.4205944824E+01, 2.1227649856E+01, 7.5053227801E+00, 9.3115654766E-01],
	[3.2095000000E+04, 6.3559732671E+01, 1.4205948475E+01, 2.1238406647E+01, 7.5068993932E+00, 9.3118894175E-01],
	[3.2100000000E+04, 6.3576316053E+01, 1.4205952126E+01, 2.1249167209E+01, 7.5084756813E+00, 9.3122131971E-01],
	[3.2105000000E+04, 6.3592901177E+01, 1.4205955776E+01, 2.1259931544E+01, 7.5100516444E+00, 9.3125368156E-01],
	[3.2110000000E+04, 6.3609488044E+01, 1.4205959425E+01, 2.1270699652E+01, 7.5116272823E+00, 9.3128602731E-01],
	[3.2115000000E+04, 6.3626076654E+01, 1.4205963074E+01, 2.1281471534E+01, 7.5132025951E+00, 9.3131835695E-01],
	[3.2120000000E+04, 6.3642667007E+01, 1.4205966723E+01, 2.1292247189E+01, 7.5147775827E+00, 9.3135067051E-01],
	[3.2125000000E+04, 6.3659259102E+01, 1.4205970370E+01, 2.1303026621E+01, 7.5163522451E+00, 9.3138296799E-01],
	[3.2130000000E+04, 6.3675852940E+01, 1.4205974018E+01, 2.1313809828E+01, 7.5179265822E+00, 9.3141524938E-01],
	[3.2135000000E+04, 6.3692448520E+01, 1.4205977664E+01, 2.1324596811E+01, 7.5195005941E+00, 9.3144751471E-01],
	[3.2140000000E+04, 6.3709045842E+01, 1.4205981310E+01, 2.1335387573E+01, 7.5210742805E+00, 9.3147976398E-01],
	[3.2145000000E+04, 6.3725644906E+01, 1.4205984956E+01, 2.1346182112E+01, 7.5226476416E+00, 9.3151199720E-01],
	[3.2150000000E+04, 6.3742245713E+01, 1.4205988601E+01, 2.1356980430E+01, 7.5242206772E+00, 9.3154421436E-01],
	[3.2155000000E+04, 6.3758848261E+01, 1.4205992245E+01, 2.1367782528E+01, 7.5257933874E+00, 9.3157641549E-01],
	[3.2160000000E+04, 6.3775452551E+01, 1.4205995889E+01, 2.1378588406E+01, 7.5273657721E+00, 9.3160860058E-01],
	[3.2165000000E+04, 6.3792058584E+01, 1.4205999532E+01, 2.1389398065E+01, 7.5289378311E+00, 9.3164076965E-01],
	[3.2170000000E+04, 6.3808666357E+01, 1.4206003175E+01, 2.1400211506E+01, 7.5305095646E+00, 9.3167292270E-01],
	[3.2175000000E+04, 6.3825275873E+01, 1.4206006817E+01, 2.1411028729E+01, 7.5320809725E+00, 9.3170505974E-01],
	[3.2180000000E+04, 6.3841887130E+01, 1.4206010459E+01, 2.1421849736E+01, 7.5336520547E+00, 9.3173718077E-01],
	[3.2185000000E+04, 6.3858500129E+01, 1.4206014100E+01, 2.1432674526E+01, 7.5352228112E+00, 9.3176928581E-01],
	[3.2190000000E+04, 6.3875114869E+01, 1.4206017740E+01, 2.1443503102E+01, 7.5367932419E+00, 9.3180137486E-01],
	[3.2195000000E+04, 6.3891731350E+01, 1.4206021380E+01, 2.1454335463E+01, 7.5383633468E+00, 9.3183344793E-01],
	[3.2200000000E+04, 6.3908349572E+01, 1.4206025019E+01, 2.1465171610E+01, 7.5399331258E+00, 9.3186550502E-01],
	[3.2205000000E+04, 6.3924969536E+01, 1.4206028658E+01, 2.1476011544E+01, 7.5415025790E+00, 9.3189754614E-01],
	[3.2210000000E+04, 6.3941591241E+01, 1.4206032296E+01, 2.1486855265E+01, 7.5430717063E+00, 9.3192957131E-01],
	[3.2215000000E+04, 6.3958214686E+01, 1.4206035934E+01, 2.1497702776E+01, 7.5446405076E+00, 9.3196158052E-01],
	[3.2220000000E+04, 6.3974839873E+01, 1.4206039571E+01, 2.1508554075E+01, 7.5462089829E+00, 9.3199357378E-01],
	[3.2225000000E+04, 6.3991466800E+01, 1.4206043207E+01, 2.1519409164E+01, 7.5477771322E+00, 9.3202555111E-01],
	[3.2230000000E+04, 6.4008095468E+01, 1.4206046843E+01, 2.1530268043E+01, 7.5493449554E+00, 9.3205751250E-01],
	[3.2235000000E+04, 6.4024725876E+01, 1.4206050479E+01, 2.1541130714E+01, 7.5509124525E+00, 9.3208945797E-01],
	[3.2240000000E+04, 6.4041358025E+01, 1.4206054114E+01, 2.1551997177E+01, 7.5524796235E+00, 9.3212138752E-01],
	[3.2245000000E+04, 6.4057991915E+01, 1.4206057748E+01, 2.1562867433E+01, 7.5540464682E+00, 9.3215330117E-01],
	[3.2250000000E+04, 6.4074627544E+01, 1.4206061381E+01, 2.1573741483E+01, 7.5556129867E+00, 9.3218519891E-01],
	[3.2255000000E+04, 6.4091264914E+01, 1.4206065015E+01, 2.1584619326E+01, 7.5571791790E+00, 9.3221708075E-01],
	[3.2260000000E+04, 6.4107904024E+01, 1.4206068647E+01, 2.1595500965E+01, 7.5587450449E+00, 9.3224894671E-01],
	[3.2265000000E+04, 6.4124544875E+01, 1.4206072279E+01, 2.1606386399E+01, 7.5603105845E+00, 9.3228079679E-01],
	[3.2270000000E+04, 6.4141187465E+01, 1.4206075911E+01, 2.1617275630E+01, 7.5618757977E+00, 9.3231263099E-01],
	[3.2275000000E+04, 6.4157831795E+01, 1.4206079541E+01, 2.1628168658E+01, 7.5634406845E+00, 9.3234444933E-01],
	[3.2280000000E+04, 6.4174477865E+01, 1.4206083172E+01, 2.1639065484E+01, 7.5650052448E+00, 9.3237625181E-01],
	[3.2285000000E+04, 6.4191125674E+01, 1.4206086801E+01, 2.1649966109E+01, 7.5665694786E+00, 9.3240803844E-01],
	[3.2290000000E+04, 6.4207775223E+01, 1.4206090431E+01, 2.1660870533E+01, 7.5681333859E+00, 9.3243980922E-01],
	[3.2295000000E+04, 6.4224426512E+01, 1.4206094059E+01, 2.1671778757E+01, 7.5696969666E+00, 9.3247156417E-01],
	[3.2300000000E+04, 6.4241079540E+01, 1.4206097687E+01, 2.1682690783E+01, 7.5712602207E+00, 9.3250330328E-01],
	[3.2305000000E+04, 6.4257734308E+01, 1.4206101315E+01, 2.1693606609E+01, 7.5728231482E+00, 9.3253502657E-01],
	[3.2310000000E+04, 6.4274390815E+01, 1.4206104942E+01, 2.1704526238E+01, 7.5743857490E+00, 9.3256673405E-01],
	[3.2315000000E+04, 6.4291049061E+01, 1.4206108568E+01, 2.1715449671E+01, 7.5759480230E+00, 9.3259842572E-01],
	[3.2320000000E+04, 6.4307709046E+01, 1.4206112194E+01, 2.1726376907E+01, 7.5775099703E+00, 9.3263010159E-01],
	[3.2325000000E+04, 6.4324370770E+01, 1.4206115819E+01, 2.1737307947E+01, 7.5790715908E+00, 9.3266176166E-01],
	[3.2330000000E+04, 6.4341034233E+01, 1.4206119444E+01, 2.1748242793E+01, 7.5806328844E+00, 9.3269340595E-01],
	[3.2335000000E+04, 6.4357699435E+01, 1.4206123068E+01, 2.1759181445E+01, 7.5821938512E+00, 9.3272503446E-01],
	[3.2340000000E+04, 6.4374366376E+01, 1.4206126692E+01, 2.1770123904E+01, 7.5837544911E+00, 9.3275664720E-01],
	[3.2345000000E+04, 6.4391035055E+01, 1.4206130315E+01, 2.1781070170E+01, 7.5853148040E+00, 9.3278824417E-01],
	[3.2350000000E+04, 6.4407705473E+01, 1.4206133937E+01, 2.1792020244E+01, 7.5868747900E+00, 9.3281982539E-01],
	[3.2355000000E+04, 6.4424377629E+01, 1.4206137559E+01, 2.1802974127E+01, 7.5884344489E+00, 9.3285139086E-01],
	[3.2360000000E+04, 6.4441051524E+01, 1.4206141180E+01, 2.1813931820E+01, 7.5899937808E+00, 9.3288294058E-01],
	[3.2365000000E+04, 6.4457727157E+01, 1.4206144801E+01, 2.1824893324E+01, 7.5915527857E+00, 9.3291447457E-01],
	[3.2370000000E+04, 6.4474404528E+01, 1.4206148421E+01, 2.1835858638E+01, 7.5931114633E+00, 9.3294599283E-01],
	[3.2375000000E+04, 6.4491083638E+01, 1.4206152041E+01, 2.1846827765E+01, 7.5946698139E+00, 9.3297749537E-01],
	[3.2380000000E+04, 6.4507764485E+01, 1.4206155660E+01, 2.1857800704E+01, 7.5962278372E+00, 9.3300898219E-01],
	[3.2385000000E+04, 6.4524447071E+01, 1.4206159279E+01, 2.1868777456E+01, 7.5977855333E+00, 9.3304045331E-01],
	[3.2390000000E+04, 6.4541131394E+01, 1.4206162897E+01, 2.1879758023E+01, 7.5993429021E+00, 9.3307190873E-01],
	[3.2395000000E+04, 6.4557830333E+01, 1.4206168373E+01, 2.1890742404E+01, 7.6009006544E+00, 9.3310334846E-01],
	[3.2400000000E+04, 6.4574573492E+01, 1.4206179980E+01, 2.1901730601E+01, 7.6024604243E+00, 9.3313477251E-01],
	[3.2405000000E+04, 6.4591318408E+01, 1.4206191585E+01, 2.1912723779E+01, 7.6040200087E+00, 9.3316618087E-01],
	[3.2410000000E+04, 6.4608065083E+01, 1.4206203188E+01, 2.1923724090E+01, 7.6055796663E+00, 9.3319757357E-01],
	[3.2415000000E+04, 6.4624813515E+01, 1.4206214789E+01, 2.1934728223E+01, 7.6071389979E+00, 9.3322895060E-01],
	[3.2420000000E+04, 6.4641563704E+01, 1.4206226389E+01, 2.1945736179E+01, 7.6086980036E+00, 9.3326031198E-01],
	[3.2425000000E+04, 6.4658315651E+01, 1.4206237986E+01, 2.1956747958E+01, 7.6102566832E+00, 9.3329165771E-01],
	[3.2430000000E+04, 6.4675069355E+01, 1.4206249582E+01, 2.1967763561E+01, 7.6118150367E+00, 9.3332298781E-01],
	[3.2435000000E+04, 6.4691824816E+01, 1.4206261177E+01, 2.1978782989E+01, 7.6133730642E+00, 9.3335430226E-01],
	[3.2440000000E+04, 6.4708582035E+01, 1.4206272769E+01, 2.1989806242E+01, 7.6149307655E+00, 9.3338560109E-01],
	[3.2445000000E+04, 6.4725341010E+01, 1.4206284360E+01, 2.2000833322E+01, 7.6164881406E+00, 9.3341688431E-01],
	[3.2450000000E+04, 6.4742101743E+01, 1.4206295948E+01, 2.2011864228E+01, 7.6180451895E+00, 9.3344815191E-01],
	[3.2455000000E+04, 6.4758864232E+01, 1.4206307536E+01, 2.2022898962E+01, 7.6196019122E+00, 9.3347940390E-01],
	[3.2460000000E+04, 6.4775628478E+01, 1.4206319121E+01, 2.2033937525E+01, 7.6211583086E+00, 9.3351064030E-01],
	[3.2465000000E+04, 6.4792394481E+01, 1.4206330704E+01, 2.2044979917E+01, 7.6227143788E+00, 9.3354186111E-01],
	[3.2470000000E+04, 6.4809162240E+01, 1.4206342286E+01, 2.2056026138E+01, 7.6242701225E+00, 9.3357306634E-01],
	[3.2475000000E+04, 6.4825931756E+01, 1.4206353866E+01, 2.2067076191E+01, 7.6258255399E+00, 9.3360425599E-01],
	[3.2480000000E+04, 6.4842703029E+01, 1.4206365444E+01, 2.2078130075E+01, 7.6273806309E+00, 9.3363543007E-01],
	[3.2485000000E+04, 6.4859476057E+01, 1.4206377021E+01, 2.2089187790E+01, 7.6289353955E+00, 9.3366658860E-01],
	[3.2490000000E+04, 6.4876250842E+01, 1.4206388595E+01, 2.2100249339E+01, 7.6304898335E+00, 9.3369773157E-01],
	[3.2495000000E+04, 6.4893027383E+01, 1.4206400168E+01, 2.2111314721E+01, 7.6320439451E+00, 9.3372885899E-01],
	[3.2500000000E+04, 6.4909805681E+01, 1.4206411739E+01, 2.2122383938E+01, 7.6335977301E+00, 9.3375997088E-01],
	[3.2505000000E+04, 6.4926585734E+01, 1.4206423309E+01, 2.2133456990E+01, 7.6351511885E+00, 9.3379106723E-01],
	[3.2510000000E+04, 6.4943367543E+01, 1.4206434876E+01, 2.2144533877E+01, 7.6367043204E+00, 9.3382214806E-01],
	[3.2515000000E+04, 6.4960151108E+01, 1.4206446442E+01, 2.2155614602E+01, 7.6382571256E+00, 9.3385321338E-01],
	[3.2520000000E+04, 6.4976936429E+01, 1.4206458006E+01, 2.2166699163E+01, 7.6398096041E+00, 9.3388426318E-01],
	[3.2525000000E+04, 6.4993723505E+01, 1.4206469569E+01, 2.2177787562E+01, 7.6413617559E+00, 9.3391529748E-01],
	[3.2530000000E+04, 6.5010512337E+01, 1.4206481129E+01, 2.2188879801E+01, 7.6429135810E+00, 9.3394631629E-01],
	[3.2535000000E+04, 6.5027302925E+01, 1.4206492688E+01, 2.2199975878E+01, 7.6444650793E+00, 9.3397731961E-01],
	[3.2540000000E+04, 6.5044095267E+01, 1.4206504245E+01, 2.2211075796E+01, 7.6460162508E+00, 9.3400830745E-01],
	[3.2545000000E+04, 6.5060889366E+01, 1.4206515800E+01, 2.2222179555E+01, 7.6475670954E+00, 9.3403927982E-01],
	[3.2550000000E+04, 6.5077685219E+01, 1.4206527353E+01, 2.2233287156E+01, 7.6491176132E+00, 9.3407023672E-01],
	[3.2555000000E+04, 6.5094482827E+01, 1.4206538905E+01, 2.2244398599E+01, 7.6506678041E+00, 9.3410117816E-01],
	[3.2560000000E+04, 6.5111282191E+01, 1.4206550455E+01, 2.2255513885E+01, 7.6522176681E+00, 9.3413210415E-01],
	[3.2565000000E+04, 6.5128083309E+01, 1.4206562003E+01, 2.2266633015E+01, 7.6537672051E+00, 9.3416301470E-01],
	[3.2570000000E+04, 6.5144886183E+01, 1.4206573550E+01, 2.2277755990E+01, 7.6553164151E+00, 9.3419390981E-01],
	[3.2575000000E+04, 6.5161690811E+01, 1.4206585094E+01, 2.2288882810E+01, 7.6568652981E+00, 9.3422478949E-01],
	[3.2580000000E+04, 6.5178497194E+01, 1.4206596637E+01, 2.2300013477E+01, 7.6584138540E+00, 9.3425565375E-01],
	[3.2585000000E+04, 6.5195305332E+01, 1.4206608178E+01, 2.2311147990E+01, 7.6599620828E+00, 9.3428650260E-01],
	[3.2590000000E+04, 6.5212115224E+01, 1.4206619717E+01, 2.2322286351E+01, 7.6615099845E+00, 9.3431733604E-01],
	[3.2595000000E+04, 6.5228926870E+01, 1.4206631255E+01, 2.2333428560E+01, 7.6630575591E+00, 9.3434815408E-01],
	[3.2600000000E+04, 6.5245740271E+01, 1.4206642791E+01, 2.2344574618E+01, 7.6646048065E+00, 9.3437895672E-01],
	[3.2605000000E+04, 6.5262555426E+01, 1.4206654325E+01, 2.2355724526E+01, 7.6661517266E+00, 9.3440974398E-01],
	[3.2610000000E+04, 6.5279372336E+01, 1.4206665857E+01, 2.2366878285E+01, 7.6676983196E+00, 9.3444051587E-01],
	[3.2615000000E+04, 6.5296190999E+01, 1.4206677388E+01, 2.2378035895E+01, 7.6692445852E+00, 9.3447127238E-01],
	[3.2620000000E+04, 6.5313011417E+01, 1.4206688916E+01, 2.2389197357E+01, 7.6707905236E+00, 9.3450201353E-01],
	[3.2625000000E+04, 6.5329833588E+01, 1.4206700443E+01, 2.2400362672E+01, 7.6723361346E+00, 9.3453273932E-01],
	[3.2630000000E+04, 6.5346657513E+01, 1.4206711969E+01, 2.2411531840E+01, 7.6738814182E+00, 9.3456344977E-01],
	[3.2635000000E+04, 6.5363483192E+01, 1.4206723492E+01, 2.2422704863E+01, 7.6754263745E+00, 9.3459414487E-01],
	[3.2640000000E+04, 6.5380310625E+01, 1.4206735014E+01, 2.2433881741E+01, 7.6769710033E+00, 9.3462482464E-01],
	[3.2645000000E+04, 6.5397139811E+01, 1.4206746534E+01, 2.2445062474E+01, 7.6785153047E+00, 9.3465548908E-01],
	[3.2650000000E+04, 6.5413970751E+01, 1.4206758052E+01, 2.2456247064E+01, 7.6800592786E+00, 9.3468613820E-01],
	[3.2655000000E+04, 6.5430803444E+01, 1.4206769569E+01, 2.2467435511E+01, 7.6816029250E+00, 9.3471677201E-01],
	[3.2660000000E+04, 6.5447637891E+01, 1.4206781083E+01, 2.2478627816E+01, 7.6831462438E+00, 9.3474739052E-01],
	[3.2665000000E+04, 6.5464474091E+01, 1.4206792596E+01, 2.2489823979E+01, 7.6846892351E+00, 9.3477799373E-01],
	[3.2670000000E+04, 6.5481312044E+01, 1.4206804108E+01, 2.2501024002E+01, 7.6862318988E+00, 9.3480858165E-01],
	[3.2675000000E+04, 6.5498151750E+01, 1.4206815617E+01, 2.2512227886E+01, 7.6877742348E+00, 9.3483915428E-01],
	[3.2680000000E+04, 6.5514993209E+01, 1.4206827125E+01, 2.2523435630E+01, 7.6893162432E+00, 9.3486971164E-01],
	[3.2685000000E+04, 6.5531836421E+01, 1.4206838631E+01, 2.2534647236E+01, 7.6908579239E+00, 9.3490025373E-01],
	[3.2690000000E+04, 6.5548681386E+01, 1.4206850135E+01, 2.2545862704E+01, 7.6923992768E+00, 9.3493078056E-01],
	[3.2695000000E+04, 6.5565528103E+01, 1.4206861638E+01, 2.2557082035E+01, 7.6939403021E+00, 9.3496129214E-01],
	[3.2700000000E+04, 6.5582376573E+01, 1.4206873138E+01, 2.2568305230E+01, 7.6954809995E+00, 9.3499178847E-01],
	[3.2705000000E+04, 6.5599226796E+01, 1.4206884637E+01, 2.2579532290E+01, 7.6970213692E+00, 9.3502226956E-01],
	[3.2710000000E+04, 6.5616078771E+01, 1.4206896134E+01, 2.2590763215E+01, 7.6985614110E+00, 9.3505273542E-01],
	[3.2715000000E+04, 6.5632932499E+01, 1.4206907630E+01, 2.2601998006E+01, 7.7001011250E+00, 9.3508318605E-01],
	[3.2720000000E+04, 6.5649787979E+01, 1.4206919124E+01, 2.2613236664E+01, 7.7016405111E+00, 9.3511362147E-01],
	[3.2725000000E+04, 6.5666645211E+01, 1.4206930616E+01, 2.2624479189E+01, 7.7031795693E+00, 9.3514404168E-01],
	[3.2730000000E+04, 6.5683504195E+01, 1.4206942106E+01, 2.2635725583E+01, 7.7047182995E+00, 9.3517444669E-01],
	[3.2735000000E+04, 6.5700364931E+01, 1.4206953594E+01, 2.2646975846E+01, 7.7062567017E+00, 9.3520483650E-01],
	[3.2740000000E+04, 6.5717227419E+01, 1.4206965081E+01, 2.2658229978E+01, 7.7077947760E+00, 9.3523521112E-01],
	[3.2745000000E+04, 6.5734091659E+01, 1.4206976566E+01, 2.2669487981E+01, 7.7093325222E+00, 9.3526557056E-01],
	[3.2750000000E+04, 6.5750957651E+01, 1.4206988049E+01, 2.2680749855E+01, 7.7108699404E+00, 9.3529591483E-01],
	[3.2755000000E+04, 6.5767825395E+01, 1.4206999531E+01, 2.2692015602E+01, 7.7124070305E+00, 9.3532624393E-01],
	[3.2760000000E+04, 6.5784694890E+01, 1.4207011011E+01, 2.2703285221E+01, 7.7139437925E+00, 9.3535655788E-01],
	[3.2765000000E+04, 6.5801566137E+01, 1.4207022489E+01, 2.2714558713E+01, 7.7154802264E+00, 9.3538685667E-01],
	[3.2770000000E+04, 6.5818439135E+01, 1.4207033965E+01, 2.2725836080E+01, 7.7170163321E+00, 9.3541714032E-01],
	[3.2775000000E+04, 6.5835313885E+01, 1.4207045439E+01, 2.2737117321E+01, 7.7185521097E+00, 9.3544740883E-01],
	[3.2780000000E+04, 6.5852190386E+01, 1.4207056912E+01, 2.2748402438E+01, 7.7200875590E+00, 9.3547766222E-01],
	[3.2785000000E+04, 6.5869068638E+01, 1.4207068383E+01, 2.2759691432E+01, 7.7216226800E+00, 9.3550790048E-01],
	[3.2790000000E+04, 6.5885948641E+01, 1.4207079853E+01, 2.2770984303E+01, 7.7231574728E+00, 9.3553812363E-01],
	[3.2795000000E+04, 6.5902830395E+01, 1.4207091320E+01, 2.2782281051E+01, 7.7246919374E+00, 9.3556833167E-01],
	[3.2800000000E+04, 6.5919713900E+01, 1.4207102786E+01, 2.2793581679E+01, 7.7262260736E+00, 9.3559852461E-01],
	[3.2805000000E+04, 6.5936599156E+01, 1.4207114250E+01, 2.2804886185E+01, 7.7277598814E+00, 9.3562870245E-01],
	[3.2810000000E+04, 6.5953486163E+01, 1.4207125712E+01, 2.2816194572E+01, 7.7292933609E+00, 9.3565886521E-01],
	[3.2815000000E+04, 6.5970374920E+01, 1.4207137173E+01, 2.2827506839E+01, 7.7308265120E+00, 9.3568901290E-01],
	[3.2820000000E+04, 6.5987265428E+01, 1.4207148632E+01, 2.2838822989E+01, 7.7323593347E+00, 9.3571914551E-01],
	[3.2825000000E+04, 6.6004157687E+01, 1.4207160089E+01, 2.2850143020E+01, 7.7338918289E+00, 9.3574926306E-01],
	[3.2830000000E+04, 6.6021051696E+01, 1.4207171545E+01, 2.2861466935E+01, 7.7354239946E+00, 9.3577936555E-01],
	[3.2835000000E+04, 6.6037947455E+01, 1.4207182998E+01, 2.2872794733E+01, 7.7369558319E+00, 9.3580945300E-01],
	[3.2840000000E+04, 6.6054844964E+01, 1.4207194450E+01, 2.2884126416E+01, 7.7384873406E+00, 9.3583952540E-01],
	[3.2845000000E+04, 6.6071744224E+01, 1.4207205900E+01, 2.2895461984E+01, 7.7400185208E+00, 9.3586958277E-01],
	[3.2850000000E+04, 6.6088645234E+01, 1.4207217349E+01, 2.2906801438E+01, 7.7415493724E+00, 9.3589962511E-01],
	[3.2855000000E+04, 6.6105547994E+01, 1.4207228796E+01, 2.2918144779E+01, 7.7430798954E+00, 9.3592965243E-01],
	[3.2860000000E+04, 6.6122452503E+01, 1.4207240241E+01, 2.2929492008E+01, 7.7446100898E+00, 9.3595966474E-01],
	[3.2865000000E+04, 6.6139358763E+01, 1.4207251684E+01, 2.2940843124E+01, 7.7461399555E+00, 9.3598966205E-01],
	[3.2870000000E+04, 6.6156266772E+01, 1.4207263125E+01, 2.2952198130E+01, 7.7476694926E+00, 9.3601964435E-01],
	[3.2875000000E+04, 6.6173176531E+01, 1.4207274565E+01, 2.2963557025E+01, 7.7491987010E+00, 9.3604961167E-01],
	[3.2880000000E+04, 6.6190088040E+01, 1.4207286003E+01, 2.2974919811E+01, 7.7507275806E+00, 9.3607956401E-01],
	[3.2885000000E+04, 6.6207001298E+01, 1.4207297440E+01, 2.2986286488E+01, 7.7522561315E+00, 9.3610950136E-01],
	[3.2890000000E+04, 6.6223916305E+01, 1.4207308874E+01, 2.2997657057E+01, 7.7537843537E+00, 9.3613942375E-01],
	[3.2895000000E+04, 6.6240833062E+01, 1.4207320307E+01, 2.3009031518E+01, 7.7553122470E+00, 9.3616933118E-01],
	[3.2900000000E+04, 6.6257751568E+01, 1.4207331738E+01, 2.3020409873E+01, 7.7568398116E+00, 9.3619922366E-01],
	[3.2905000000E+04, 6.6274671823E+01, 1.4207343168E+01, 2.3031792123E+01, 7.7583670472E+00, 9.3622910119E-01],
	[3.2910000000E+04, 6.6291593827E+01, 1.4207354596E+01, 2.3043178267E+01, 7.7598939541E+00, 9.3625896378E-01],
	[3.2915000000E+04, 6.6308517580E+01, 1.4207366022E+01, 2.3054568306E+01, 7.7614205320E+00, 9.3628881144E-01],
	[3.2920000000E+04, 6.6325494165E+01, 1.4207384758E+01, 2.3065962242E+01, 7.7629496640E+00, 9.3631864417E-01],
	[3.2925000000E+04, 6.6342476166E+01, 1.4207404014E+01, 2.3077360075E+01, 7.7644786744E+00, 9.3634846199E-01],
	[3.2930000000E+04, 6.6359459936E+01, 1.4207423267E+01, 2.3088761806E+01, 7.7660073575E+00, 9.3637826489E-01],
	[3.2935000000E+04, 6.6376445474E+01, 1.4207442518E+01, 2.3100167436E+01, 7.7675357132E+00, 9.3640805290E-01],
	[3.2940000000E+04, 6.6393432780E+01, 1.4207461765E+01, 2.3111576965E+01, 7.7690637415E+00, 9.3643782601E-01],
	[3.2945000000E+04, 6.6410421854E+01, 1.4207481010E+01, 2.3122990394E+01, 7.7705914423E+00, 9.3646758423E-01],
	[3.2950000000E+04, 6.6427412697E+01, 1.4207500251E+01, 2.3134407724E+01, 7.7721188156E+00, 9.3649732757E-01],
	[3.2955000000E+04, 6.6444405307E+01, 1.4207519490E+01, 2.3145828955E+01, 7.7736458614E+00, 9.3652705604E-01],
	[3.2960000000E+04, 6.6461399686E+01, 1.4207538726E+01, 2.3157254089E+01, 7.7751725797E+00, 9.3655676964E-01],
	[3.2965000000E+04, 6.6478395832E+01, 1.4207557959E+01, 2.3168683125E+01, 7.7766989705E+00, 9.3658646838E-01],
	[3.2970000000E+04, 6.6495393745E+01, 1.4207577189E+01, 2.3180116066E+01, 7.7782250337E+00, 9.3661615227E-01],
	[3.2975000000E+04, 6.6512393427E+01, 1.4207596416E+01, 2.3191552911E+01, 7.7797507693E+00, 9.3664582132E-01],
	[3.2980000000E+04, 6.6529394876E+01, 1.4207615640E+01, 2.3202993661E+01, 7.7812761772E+00, 9.3667547553E-01],
	[3.2985000000E+04, 6.6546398092E+01, 1.4207634862E+01, 2.3214438317E+01, 7.7828012576E+00, 9.3670511491E-01],
	[3.2990000000E+04, 6.6563403076E+01, 1.4207654080E+01, 2.3225886880E+01, 7.7843260102E+00, 9.3673473947E-01],
	[3.2995000000E+04, 6.6580409827E+01, 1.4207673296E+01, 2.3237339350E+01, 7.7858504352E+00, 9.3676434921E-01],
	[3.3000000000E+04, 6.6597418346E+01, 1.4207692508E+01, 2.3248795729E+01, 7.7873745325E+00, 9.3679394415E-01],
	[3.3005000000E+04, 6.6614428631E+01, 1.4207711718E+01, 2.3260256016E+01, 7.7888983021E+00, 9.3682352429E-01],
	[3.3010000000E+04, 6.6631440684E+01, 1.4207730925E+01, 2.3271720214E+01, 7.7904217439E+00, 9.3685308963E-01],
	[3.3015000000E+04, 6.6648454503E+01, 1.4207750129E+01, 2.3283188321E+01, 7.7919448579E+00, 9.3688264019E-01],
	[3.3020000000E+04, 6.6665470090E+01, 1.4207769330E+01, 2.3294660340E+01, 7.7934676441E+00, 9.3691217597E-01],
	[3.3025000000E+04, 6.6682487443E+01, 1.4207788529E+01, 2.3306136271E+01, 7.7949901026E+00, 9.3694169698E-01],
	[3.3030000000E+04, 6.6699506563E+01, 1.4207807724E+01, 2.3317616114E+01, 7.7965122332E+00, 9.3697120322E-01],
	[3.3035000000E+04, 6.6716527449E+01, 1.4207826917E+01, 2.3329099871E+01, 7.7980340359E+00, 9.3700069471E-01],
	[3.3040000000E+04, 6.6733550102E+01, 1.4207846106E+01, 2.3340587542E+01, 7.7995555107E+00, 9.3703017145E-01],
	[3.3045000000E+04, 6.6750574521E+01, 1.4207865293E+01, 2.3352079127E+01, 7.8010766577E+00, 9.3705963345E-01],
	[3.3050000000E+04, 6.6767600707E+01, 1.4207884477E+01, 2.3363574629E+01, 7.8025974767E+00, 9.3708908072E-01],
	[3.3055000000E+04, 6.6784628659E+01, 1.4207903658E+01, 2.3375074046E+01, 7.8041179678E+00, 9.3711851325E-01],
	[3.3060000000E+04, 6.6801658378E+01, 1.4207922836E+01, 2.3386577381E+01, 7.8056381309E+00, 9.3714793107E-01],
	[3.3065000000E+04, 6.6818689862E+01, 1.4207942012E+01, 2.3398084634E+01, 7.8071579661E+00, 9.3717733418E-01],
	[3.3070000000E+04, 6.6835723113E+01, 1.4207961184E+01, 2.3409595805E+01, 7.8086774732E+00, 9.3720672258E-01],
	[3.3075000000E+04, 6.6852758129E+01, 1.4207980354E+01, 2.3421110895E+01, 7.8101966523E+00, 9.3723609628E-01],
	[3.3080000000E+04, 6.6869794911E+01, 1.4207999520E+01, 2.3432629906E+01, 7.8117155034E+00, 9.3726545529E-01],
	[3.3085000000E+04, 6.6886833459E+01, 1.4208018684E+01, 2.3444152837E+01, 7.8132340264E+00, 9.3729479962E-01],
	[3.3090000000E+04, 6.6903873773E+01, 1.4208037845E+01, 2.3455679690E+01, 7.8147522213E+00, 9.3732412927E-01],
	[3.3095000000E+04, 6.6920915853E+01, 1.4208057003E+01, 2.3467210465E+01, 7.8162700881E+00, 9.3735344425E-01],
	[3.3100000000E+04, 6.6937959698E+01, 1.4208076158E+01, 2.3478745163E+01, 7.8177876268E+00, 9.3738274457E-01],
	[3.3105000000E+04, 6.6955005308E+01, 1.4208095310E+01, 2.3490283785E+01, 7.8193048373E+00, 9.3741203024E-01],
	[3.3110000000E+04, 6.6972052684E+01, 1.4208114460E+01, 2.3501826331E+01, 7.8208217197E+00, 9.3744130126E-01],
	[3.3115000000E+04, 6.6989101825E+01, 1.4208133607E+01, 2.3513372803E+01, 7.8223382739E+00, 9.3747055764E-01],
	[3.3120000000E+04, 6.7006152731E+01, 1.4208152750E+01, 2.3524923201E+01, 7.8238544999E+00, 9.3749979939E-01],
	[3.3125000000E+04, 6.7023205402E+01, 1.4208171891E+01, 2.3536477525E+01, 7.8253703976E+00, 9.3752902652E-01],
	[3.3130000000E+04, 6.7040259838E+01, 1.4208191029E+01, 2.3548035777E+01, 7.8268859671E+00, 9.3755823902E-01],
	[3.3135000000E+04, 6.7057316040E+01, 1.4208210164E+01, 2.3559597957E+01, 7.8284012084E+00, 9.3758743692E-01],
	[3.3140000000E+04, 6.7074374006E+01, 1.4208229297E+01, 2.3571164066E+01, 7.8299161213E+00, 9.3761662021E-01],
	[3.3145000000E+04, 6.7091433737E+01, 1.4208248426E+01, 2.3582734104E+01, 7.8314307060E+00, 9.3764578891E-01],
	[3.3150000000E+04, 6.7108495232E+01, 1.4208267552E+01, 2.3594308073E+01, 7.8329449623E+00, 9.3767494302E-01],
	[3.3155000000E+04, 6.7125558493E+01, 1.4208286676E+01, 2.3605885973E+01, 7.8344588903E+00, 9.3770408255E-01],
	[3.3160000000E+04, 6.7142623517E+01, 1.4208305797E+01, 2.3617467805E+01, 7.8359724900E+00, 9.3773320750E-01],
	[3.3165000000E+04, 6.7159690307E+01, 1.4208324915E+01, 2.3629053570E+01, 7.8374857613E+00, 9.3776231789E-01],
	[3.3170000000E+04, 6.7176758860E+01, 1.4208344030E+01, 2.3640643268E+01, 7.8389987041E+00, 9.3779141372E-01],
	[3.3175000000E+04, 6.7193829178E+01, 1.4208363142E+01, 2.3652236901E+01, 7.8405113186E+00, 9.3782049500E-01],
	[3.3180000000E+04, 6.7210901260E+01, 1.4208382252E+01, 2.3663834468E+01, 7.8420236046E+00, 9.3784956173E-01],
	[3.3185000000E+04, 6.7227975106E+01, 1.4208401358E+01, 2.3675435970E+01, 7.8435355622E+00, 9.3787861392E-01],
	[3.3190000000E+04, 6.7245050716E+01, 1.4208420462E+01, 2.3687041409E+01, 7.8450471913E+00, 9.3790765159E-01],
	[3.3195000000E+04, 6.7262128090E+01, 1.4208439563E+01, 2.3698650785E+01, 7.8465584919E+00, 9.3793667473E-01],
	[3.3200000000E+04, 6.7279207228E+01, 1.4208458661E+01, 2.3710264099E+01, 7.8480694640E+00, 9.3796568336E-01],
	[3.3205000000E+04, 6.7296288130E+01, 1.4208477756E+01, 2.3721881352E+01, 7.8495801076E+00, 9.3799467747E-01],
	[3.3210000000E+04, 6.7313370795E+01, 1.4208496848E+01, 2.3733502544E+01, 7.8510904227E+00, 9.3802365709E-01],
	[3.3215000000E+04, 6.7330455224E+01, 1.4208515938E+01, 2.3745127676E+01, 7.8526004092E+00, 9.3805262221E-01],
	[3.3220000000E+04, 6.7347541417E+01, 1.4208535024E+01, 2.3756756748E+01, 7.8541100671E+00, 9.3808157285E-01],
	[3.3225000000E+04, 6.7364629373E+01, 1.4208554108E+01, 2.3768389763E+01, 7.8556193964E+00, 9.3811050901E-01],
	[3.3230000000E+04, 6.7381719092E+01, 1.4208573189E+01, 2.3780026719E+01, 7.8571283972E+00, 9.3813943070E-01],
	[3.3235000000E+04, 6.7398810575E+01, 1.4208592267E+01, 2.3791667619E+01, 7.8586370693E+00, 9.3816833792E-01],
	[3.3240000000E+04, 6.7415903821E+01, 1.4208611342E+01, 2.3803312462E+01, 7.8601454127E+00, 9.3819723068E-01],
	[3.3245000000E+04, 6.7432998830E+01, 1.4208630415E+01, 2.3814961250E+01, 7.8616534275E+00, 9.3822610900E-01],
	[3.3250000000E+04, 6.7450095602E+01, 1.4208649484E+01, 2.3826613983E+01, 7.8631611137E+00, 9.3825497287E-01],
	[3.3255000000E+04, 6.7467194136E+01, 1.4208668551E+01, 2.3838270662E+01, 7.8646684711E+00, 9.3828382230E-01],
	[3.3260000000E+04, 6.7484294434E+01, 1.4208687615E+01, 2.3849931288E+01, 7.8661754998E+00, 9.3831265731E-01],
	[3.3265000000E+04, 6.7501396495E+01, 1.4208706676E+01, 2.3861595861E+01, 7.8676821998E+00, 9.3834147790E-01],
	[3.3270000000E+04, 6.7518500318E+01, 1.4208725734E+01, 2.3873264382E+01, 7.8691885711E+00, 9.3837028407E-01],
	[3.3275000000E+04, 6.7535605904E+01, 1.4208744789E+01, 2.3884936853E+01, 7.8706946135E+00, 9.3839907584E-01],
	[3.3280000000E+04, 6.7552713252E+01, 1.4208763842E+01, 2.3896613273E+01, 7.8722003273E+00, 9.3842785321E-01],
	[3.3285000000E+04, 6.7569822363E+01, 1.4208782892E+01, 2.3908293643E+01, 7.8737057122E+00, 9.3845661619E-01],
	[3.3290000000E+04, 6.7586933236E+01, 1.4208801938E+01, 2.3919977965E+01, 7.8752107683E+00, 9.3848536478E-01],
	[3.3295000000E+04, 6.7604045871E+01, 1.4208820982E+01, 2.3931666239E+01, 7.8767154956E+00, 9.3851409899E-01],
	[3.3300000000E+04, 6.7621160269E+01, 1.4208840023E+01, 2.3943358465E+01, 7.8782198941E+00, 9.3854281884E-01],
	[3.3305000000E+04, 6.7638276428E+01, 1.4208859062E+01, 2.3955054645E+01, 7.8797239637E+00, 9.3857152432E-01],
	[3.3310000000E+04, 6.7655394350E+01, 1.4208878097E+01, 2.3966754778E+01, 7.8812277044E+00, 9.3860021545E-01],
	[3.3315000000E+04, 6.7672514034E+01, 1.4208897130E+01, 2.3978458867E+01, 7.8827311163E+00, 9.3862889223E-01],
	[3.3320000000E+04, 6.7689635479E+01, 1.4208916160E+01, 2.3990166911E+01, 7.8842341992E+00, 9.3865755467E-01],
	[3.3325000000E+04, 6.7706758687E+01, 1.4208935187E+01, 2.4001878912E+01, 7.8857369533E+00, 9.3868620277E-01],
	[3.3330000000E+04, 6.7723883656E+01, 1.4208954211E+01, 2.4013594870E+01, 7.8872393784E+00, 9.3871483655E-01],
	[3.3335000000E+04, 6.7741010386E+01, 1.4208973232E+01, 2.4025314786E+01, 7.8887414745E+00, 9.3874345601E-01],
	[3.3340000000E+04, 6.7758138878E+01, 1.4208992251E+01, 2.4037038660E+01, 7.8902432417E+00, 9.3877206115E-01],
	[3.3345000000E+04, 6.7775269132E+01, 1.4209011267E+01, 2.4048766493E+01, 7.8917446800E+00, 9.3880065200E-01],
	[3.3350000000E+04, 6.7792401147E+01, 1.4209030279E+01, 2.4060498287E+01, 7.8932457892E+00, 9.3882922854E-01],
	[3.3355000000E+04, 6.7809534923E+01, 1.4209049289E+01, 2.4072234042E+01, 7.8947465694E+00, 9.3885779080E-01],
	[3.3360000000E+04, 6.7826670460E+01, 1.4209068297E+01, 2.4083973758E+01, 7.8962470207E+00, 9.3888633877E-01],
	[3.3365000000E+04, 6.7843807759E+01, 1.4209087301E+01, 2.4095717436E+01, 7.8977471428E+00, 9.3891487247E-01],
	[3.3370000000E+04, 6.7860946818E+01, 1.4209106303E+01, 2.4107465077E+01, 7.8992469360E+00, 9.3894339190E-01],
	[3.3375000000E+04, 6.7878087639E+01, 1.4209125301E+01, 2.4119216683E+01, 7.9007464001E+00, 9.3897189707E-01],
	[3.3380000000E+04, 6.7895230220E+01, 1.4209144297E+01, 2.4130972252E+01, 7.9022455351E+00, 9.3900038798E-01],
	[3.3385000000E+04, 6.7912374562E+01, 1.4209163290E+01, 2.4142731787E+01, 7.9037443410E+00, 9.3902886465E-01],
	[3.3390000000E+04, 6.7929520665E+01, 1.4209182281E+01, 2.4154495288E+01, 7.9052428178E+00, 9.3905732708E-01],
	[3.3395000000E+04, 6.7946668528E+01, 1.4209201268E+01, 2.4166262756E+01, 7.9067409655E+00, 9.3908577527E-01],
	[3.3400000000E+04, 6.7963818152E+01, 1.4209220253E+01, 2.4178034191E+01, 7.9082387840E+00, 9.3911420925E-01],
	[3.3405000000E+04, 6.7980969537E+01, 1.4209239235E+01, 2.4189809595E+01, 7.9097362735E+00, 9.3914262900E-01],
	[3.3410000000E+04, 6.7998122682E+01, 1.4209258214E+01, 2.4201588967E+01, 7.9112334337E+00, 9.3917103454E-01],
	[3.3415000000E+04, 6.8015277587E+01, 1.4209277190E+01, 2.4213372310E+01, 7.9127302648E+00, 9.3919942589E-01],
	[3.3420000000E+04, 6.8032434252E+01, 1.4209296163E+01, 2.4225159622E+01, 7.9142267667E+00, 9.3922780303E-01],
	[3.3425000000E+04, 6.8049592677E+01, 1.4209315134E+01, 2.4236950906E+01, 7.9157229394E+00, 9.3925616599E-01],
	[3.3430000000E+04, 6.8066752863E+01, 1.4209334102E+01, 2.4248746162E+01, 7.9172187829E+00, 9.3928451476E-01],
	[3.3435000000E+04, 6.8083914808E+01, 1.4209353067E+01, 2.4260545391E+01, 7.9187142972E+00, 9.3931284937E-01],
	[3.3440000000E+04, 6.8101078513E+01, 1.4209372029E+01, 2.4272348593E+01, 7.9202094822E+00, 9.3934116980E-01],
	[3.3445000000E+04, 6.8118243978E+01, 1.4209390988E+01, 2.4284155769E+01, 7.9217043380E+00, 9.3936947608E-01],
	[3.3450000000E+04, 6.8135462857E+01, 1.4209417281E+01, 2.4295966920E+01, 7.9232018441E+00, 9.3939776820E-01],
	[3.3455000000E+04, 6.8152685953E+01, 1.4209443916E+01, 2.4307782047E+01, 7.9246991630E+00, 9.3942604618E-01],
	[3.3460000000E+04, 6.8169910828E+01, 1.4209470547E+01, 2.4319601150E+01, 7.9261961541E+00, 9.3945431002E-01],
	[3.3465000000E+04, 6.8187137481E+01, 1.4209497175E+01, 2.4331424230E+01, 7.9276928174E+00, 9.3948255973E-01],
	[3.3470000000E+04, 6.8204365913E+01, 1.4209523798E+01, 2.4343251288E+01, 7.9291891530E+00, 9.3951079532E-01],
	[3.3475000000E+04, 6.8221596124E+01, 1.4209550418E+01, 2.4355082325E+01, 7.9306851607E+00, 9.3953901679E-01],
	[3.3480000000E+04, 6.8238828112E+01, 1.4209577033E+01, 2.4366917341E+01, 7.9321808406E+00, 9.3956722415E-01],
	[3.3485000000E+04, 6.8256061880E+01, 1.4209603645E+01, 2.4378756338E+01, 7.9336761926E+00, 9.3959541741E-01],
	[3.3490000000E+04, 6.8273297425E+01, 1.4209630253E+01, 2.4390599315E+01, 7.9351712169E+00, 9.3962359658E-01],
	[3.3495000000E+04, 6.8290534749E+01, 1.4209656857E+01, 2.4402446274E+01, 7.9366659132E+00, 9.3965176166E-01],
	[3.3500000000E+04, 6.8307773851E+01, 1.4209683457E+01, 2.4414297215E+01, 7.9381602817E+00, 9.3967991265E-01],
	[3.3505000000E+04, 6.8325014731E+01, 1.4209710053E+01, 2.4426152139E+01, 7.9396543223E+00, 9.3970804958E-01],
	[3.3510000000E+04, 6.8342257388E+01, 1.4209736645E+01, 2.4438011047E+01, 7.9411480350E+00, 9.3973617244E-01],
	[3.3515000000E+04, 6.8359501824E+01, 1.4209763233E+01, 2.4449873940E+01, 7.9426414198E+00, 9.3976428124E-01],
	[3.3520000000E+04, 6.8376748037E+01, 1.4209789817E+01, 2.4461740818E+01, 7.9441344767E+00, 9.3979237600E-01],
	[3.3525000000E+04, 6.8393996028E+01, 1.4209816398E+01, 2.4473611682E+01, 7.9456272056E+00, 9.3982045670E-01],
	[3.3530000000E+04, 6.8411245797E+01, 1.4209842974E+01, 2.4485486533E+01, 7.9471196066E+00, 9.3984852338E-01],
	[3.3535000000E+04, 6.8428497343E+01, 1.4209869546E+01, 2.4497365371E+01, 7.9486116796E+00, 9.3987657602E-01],
	[3.3540000000E+04, 6.8445750667E+01, 1.4209896115E+01, 2.4509248198E+01, 7.9501034247E+00, 9.3990461464E-01],
	[3.3545000000E+04, 6.8463005768E+01, 1.4209922680E+01, 2.4521135014E+01, 7.9515948418E+00, 9.3993263924E-01],
	[3.3550000000E+04, 6.8480262646E+01, 1.4209949241E+01, 2.4533025819E+01, 7.9530859309E+00, 9.3996064984E-01],
	[3.3555000000E+04, 6.8497521301E+01, 1.4209975797E+01, 2.4544920615E+01, 7.9545766920E+00, 9.3998864644E-01],
	[3.3560000000E+04, 6.8514781734E+01, 1.4210002350E+01, 2.4556819402E+01, 7.9560671251E+00, 9.4001662904E-01],
	[3.3565000000E+04, 6.8532043944E+01, 1.4210028899E+01, 2.4568722182E+01, 7.9575572301E+00, 9.4004459766E-01],
	[3.3570000000E+04, 6.8549307930E+01, 1.4210055445E+01, 2.4580628954E+01, 7.9590470072E+00, 9.4007255230E-01],
	[3.3575000000E+04, 6.8566573694E+01, 1.4210081986E+01, 2.4592539719E+01, 7.9605364561E+00, 9.4010049297E-01],
	[3.3580000000E+04, 6.8583841234E+01, 1.4210108523E+01, 2.4604454479E+01, 7.9620255771E+00, 9.4012841967E-01],
	[3.3585000000E+04, 6.8601110551E+01, 1.4210135057E+01, 2.4616373234E+01, 7.9635143699E+00, 9.4015633241E-01],
	[3.3590000000E+04, 6.8618381644E+01, 1.4210161586E+01, 2.4628295985E+01, 7.9650028347E+00, 9.4018423121E-01],
	[3.3595000000E+04, 6.8635654514E+01, 1.4210188112E+01, 2.4640222732E+01, 7.9664909714E+00, 9.4021211606E-01],
	[3.3600000000E+04, 6.8652929161E+01, 1.4210214634E+01, 2.4652153476E+01, 7.9679787801E+00, 9.4023998698E-01],
	[3.3605000000E+04, 6.8670205584E+01, 1.4210241151E+01, 2.4664088218E+01, 7.9694662606E+00, 9.4026784397E-01],
	[3.3610000000E+04, 6.8687483783E+01, 1.4210267665E+01, 2.4676026959E+01, 7.9709534129E+00, 9.4029568704E-01],
	[3.3615000000E+04, 6.8704763758E+01, 1.4210294175E+01, 2.4687969699E+01, 7.9724402372E+00, 9.4032351619E-01],
	[3.3620000000E+04, 6.8722045510E+01, 1.4210320682E+01, 2.4699916439E+01, 7.9739267333E+00, 9.4035133144E-01],
	[3.3625000000E+04, 6.8739329038E+01, 1.4210347184E+01, 2.4711867181E+01, 7.9754129013E+00, 9.4037913279E-01],
	[3.3630000000E+04, 6.8756614341E+01, 1.4210373682E+01, 2.4723821924E+01, 7.9768987412E+00, 9.4040692024E-01],
	[3.3635000000E+04, 6.8773901421E+01, 1.4210400177E+01, 2.4735780669E+01, 7.9783842528E+00, 9.4043469381E-01],
	[3.3640000000E+04, 6.8791190276E+01, 1.4210426667E+01, 2.4747743418E+01, 7.9798694363E+00, 9.4046245351E-01],
	[3.3645000000E+04, 6.8808480907E+01, 1.4210453154E+01, 2.4759710171E+01, 7.9813542916E+00, 9.4049019933E-01],
	[3.3650000000E+04, 6.8825773314E+01, 1.4210479637E+01, 2.4771680928E+01, 7.9828388187E+00, 9.4051793129E-01],
	[3.3655000000E+04, 6.8843067496E+01, 1.4210506116E+01, 2.4783655690E+01, 7.9843230177E+00, 9.4054564939E-01],
	[3.3660000000E+04, 6.8860363454E+01, 1.4210532591E+01, 2.4795634459E+01, 7.9858068884E+00, 9.4057335364E-01],
	[3.3665000000E+04, 6.8877661187E+01, 1.4210559062E+01, 2.4807617235E+01, 7.9872904309E+00, 9.4060104405E-01],
	[3.3670000000E+04, 6.8894960695E+01, 1.4210585529E+01, 2.4819604018E+01, 7.9887736451E+00, 9.4062872062E-01],
	[3.3675000000E+04, 6.8912261979E+01, 1.4210611993E+01, 2.4831594809E+01, 7.9902565311E+00, 9.4065638336E-01],
	[3.3680000000E+04, 6.8929565038E+01, 1.4210638452E+01, 2.4843589610E+01, 7.9917390889E+00, 9.4068403227E-01],
	[3.3685000000E+04, 6.8946869872E+01, 1.4210664908E+01, 2.4855588421E+01, 7.9932213185E+00, 9.4071166736E-01],
	[3.3690000000E+04, 6.8964176480E+01, 1.4210691360E+01, 2.4867591242E+01, 7.9947032197E+00, 9.4073928865E-01],
	[3.3695000000E+04, 6.8981484864E+01, 1.4210717808E+01, 2.4879598074E+01, 7.9961847927E+00, 9.4076689612E-01],
	[3.3700000000E+04, 6.8998795023E+01, 1.4210744252E+01, 2.4891608919E+01, 7.9976660374E+00, 9.4079448980E-01],
	[3.3705000000E+04, 6.9016106956E+01, 1.4210770692E+01, 2.4903623776E+01, 7.9991469539E+00, 9.4082206968E-01],
	[3.3710000000E+04, 6.9033420664E+01, 1.4210797128E+01, 2.4915642647E+01, 8.0006275420E+00, 9.4084963578E-01],
	[3.3715000000E+04, 6.9050736147E+01, 1.4210823561E+01, 2.4927665533E+01, 8.0021078018E+00, 9.4087718810E-01],
	[3.3720000000E+04, 6.9068053404E+01, 1.4210849989E+01, 2.4939692433E+01, 8.0035877334E+00, 9.4090472664E-01],
	[3.3725000000E+04, 6.9085372436E+01, 1.4210876414E+01, 2.4951723349E+01, 8.0050673366E+00, 9.4093225141E-01],
	[3.3730000000E+04, 6.9102693241E+01, 1.4210902835E+01, 2.4963758282E+01, 8.0065466115E+00, 9.4095976242E-01],
	[3.3735000000E+04, 6.9120015822E+01, 1.4210929251E+01, 2.4975797232E+01, 8.0080255580E+00, 9.4098725968E-01],
	[3.3740000000E+04, 6.9137340176E+01, 1.4210955665E+01, 2.4987840200E+01, 8.0095041762E+00, 9.4101474319E-01],
	[3.3745000000E+04, 6.9154666304E+01, 1.4210982074E+01, 2.4999887186E+01, 8.0109824661E+00, 9.4104221296E-01],
	[3.3750000000E+04, 6.9171994207E+01, 1.4211008479E+01, 2.5011938193E+01, 8.0124604276E+00, 9.4106966899E-01],
	[3.3755000000E+04, 6.9189323883E+01, 1.4211034881E+01, 2.5023993219E+01, 8.0139380608E+00, 9.4109711129E-01],
	[3.3760000000E+04, 6.9206655333E+01, 1.4211061278E+01, 2.5036052267E+01, 8.0154153655E+00, 9.4112453987E-01],
	[3.3765000000E+04, 6.9223988557E+01, 1.4211087672E+01, 2.5048115336E+01, 8.0168923419E+00, 9.4115195473E-01],
	[3.3770000000E+04, 6.9241323555E+01, 1.4211114062E+01, 2.5060182428E+01, 8.0183689900E+00, 9.4117935588E-01],
	[3.3775000000E+04, 6.9258660326E+01, 1.4211140448E+01, 2.5072253543E+01, 8.0198453096E+00, 9.4120674333E-01],
	[3.3780000000E+04, 6.9275998871E+01, 1.4211166830E+01, 2.5084328682E+01, 8.0213213008E+00, 9.4123411708E-01],
	[3.3785000000E+04, 6.9293339190E+01, 1.4211193208E+01, 2.5096407846E+01, 8.0227969637E+00, 9.4126147714E-01],
	[3.3790000000E+04, 6.9310681281E+01, 1.4211219583E+01, 2.5108491036E+01, 8.0242722981E+00, 9.4128882351E-01],
	[3.3795000000E+04, 6.9328025146E+01, 1.4211245953E+01, 2.5120578251E+01, 8.0257473041E+00, 9.4131615621E-01],
	[3.3800000000E+04, 6.9345370784E+01, 1.4211272320E+01, 2.5132669494E+01, 8.0272219817E+00, 9.4134347523E-01],
	[3.3805000000E+04, 6.9362718196E+01, 1.4211298683E+01, 2.5144764764E+01, 8.0286963309E+00, 9.4137078059E-01],
	[3.3810000000E+04, 6.9380067380E+01, 1.4211325042E+01, 2.5156864062E+01, 8.0301703516E+00, 9.4139807229E-01],
	[3.3815000000E+04, 6.9397418337E+01, 1.4211351397E+01, 2.5168967390E+01, 8.0316440439E+00, 9.4142535033E-01],
	[3.3820000000E+04, 6.9414771067E+01, 1.4211377749E+01, 2.5181074748E+01, 8.0331174078E+00, 9.4145261473E-01],
	[3.3825000000E+04, 6.9432125570E+01, 1.4211404096E+01, 2.5193186137E+01, 8.0345904432E+00, 9.4147986549E-01],
	[3.3830000000E+04, 6.9449481846E+01, 1.4211430440E+01, 2.5205301556E+01, 8.0360631501E+00, 9.4150710261E-01],
	[3.3835000000E+04, 6.9466839894E+01, 1.4211456780E+01, 2.5217421009E+01, 8.0375355286E+00, 9.4153432611E-01],
	[3.3840000000E+04, 6.9484199715E+01, 1.4211483116E+01, 2.5229544494E+01, 8.0390075786E+00, 9.4156153599E-01],
	[3.3845000000E+04, 6.9501561309E+01, 1.4211509448E+01, 2.5241672012E+01, 8.0404793001E+00, 9.4158873225E-01],
	[3.3850000000E+04, 6.9518924674E+01, 1.4211535776E+01, 2.5253803565E+01, 8.0419506932E+00, 9.4161591490E-01],
	[3.3855000000E+04, 6.9536289812E+01, 1.4211562101E+01, 2.5265939154E+01, 8.0434217578E+00, 9.4164308396E-01],
	[3.3860000000E+04, 6.9553656723E+01, 1.4211588421E+01, 2.5278078778E+01, 8.0448924939E+00, 9.4167023941E-01],
	[3.3865000000E+04, 6.9571025405E+01, 1.4211614738E+01, 2.5290222439E+01, 8.0463629015E+00, 9.4169738128E-01],
	[3.3870000000E+04, 6.9588395860E+01, 1.4211641051E+01, 2.5302370137E+01, 8.0478329806E+00, 9.4172450957E-01],
	[3.3875000000E+04, 6.9605768086E+01, 1.4211667360E+01, 2.5314521873E+01, 8.0493027312E+00, 9.4175162428E-01],
	[3.3880000000E+04, 6.9623142085E+01, 1.4211693665E+01, 2.5326677649E+01, 8.0507721533E+00, 9.4177872542E-01],
	[3.3885000000E+04, 6.9640517855E+01, 1.4211719967E+01, 2.5338837463E+01, 8.0522412468E+00, 9.4180581299E-01],
	[3.3890000000E+04, 6.9657895397E+01, 1.4211746265E+01, 2.5351001319E+01, 8.0537100119E+00, 9.4183288701E-01],
	[3.3895000000E+04, 6.9675274711E+01, 1.4211772558E+01, 2.5363169215E+01, 8.0551784484E+00, 9.4185994748E-01],
	[3.3900000000E+04, 6.9692655796E+01, 1.4211798848E+01, 2.5375341153E+01, 8.0566465564E+00, 9.4188699440E-01],
	[3.3905000000E+04, 6.9710038653E+01, 1.4211825134E+01, 2.5387517134E+01, 8.0581143359E+00, 9.4191402779E-01],
	[3.3910000000E+04, 6.9727423281E+01, 1.4211851417E+01, 2.5399697158E+01, 8.0595817869E+00, 9.4194104764E-01],
	[3.3915000000E+04, 6.9744809680E+01, 1.4211877695E+01, 2.5411881226E+01, 8.0610489093E+00, 9.4196805397E-01],
	[3.3920000000E+04, 6.9762197851E+01, 1.4211903970E+01, 2.5424069339E+01, 8.0625157032E+00, 9.4199504679E-01],
	[3.3925000000E+04, 6.9779587793E+01, 1.4211930241E+01, 2.5436261498E+01, 8.0639821685E+00, 9.4202202609E-01],
	[3.3930000000E+04, 6.9796979506E+01, 1.4211956508E+01, 2.5448457703E+01, 8.0654483053E+00, 9.4204899188E-01],
	[3.3935000000E+04, 6.9814372990E+01, 1.4211982771E+01, 2.5460657955E+01, 8.0669141135E+00, 9.4207594417E-01],
	[3.3940000000E+04, 6.9831768245E+01, 1.4212009030E+01, 2.5472862255E+01, 8.0683795932E+00, 9.4210288298E-01],
	[3.3945000000E+04, 6.9849165271E+01, 1.4212035286E+01, 2.5485070604E+01, 8.0698447443E+00, 9.4212980829E-01],
	[3.3950000000E+04, 6.9866564068E+01, 1.4212061537E+01, 2.5497283001E+01, 8.0713095668E+00, 9.4215672012E-01],
	[3.3955000000E+04, 6.9883964635E+01, 1.4212087785E+01, 2.5509499449E+01, 8.0727740608E+00, 9.4218361848E-01],
	[3.3960000000E+04, 6.9901366973E+01, 1.4212114029E+01, 2.5521719948E+01, 8.0742382262E+00, 9.4221050338E-01],
	[3.3965000000E+04, 6.9918771082E+01, 1.4212140270E+01, 2.5533944498E+01, 8.0757020630E+00, 9.4223737481E-01],
	[3.3970000000E+04, 6.9936176961E+01, 1.4212166506E+01, 2.5546173101E+01, 8.0771655713E+00, 9.4226423279E-01],
	[3.3975000000E+04, 6.9953584610E+01, 1.4212192739E+01, 2.5558405756E+01, 8.0786287510E+00, 9.4229107732E-01],
	[3.3980000000E+04, 6.9970994030E+01, 1.4212218968E+01, 2.5570642465E+01, 8.0800916021E+00, 9.4231790841E-01],
	[3.3985000000E+04, 6.9988419668E+01, 1.4212247230E+01, 2.5582883229E+01, 8.0815549759E+00, 9.4234472606E-01],
	[3.3990000000E+04, 7.0005886071E+01, 1.4212280985E+01, 2.5595128048E+01, 8.0830203194E+00, 9.4237153028E-01],
	[3.3995000000E+04, 7.0023354263E+01, 1.4212314735E+01, 2.5607376924E+01, 8.0844853356E+00, 9.4239832108E-01],
	[3.4000000000E+04, 7.0040824244E+01, 1.4212348480E+01, 2.5619629856E+01, 8.0859500248E+00, 9.4242509847E-01],
	[3.4005000000E+04, 7.0058296014E+01, 1.4212382220E+01, 2.5631886845E+01, 8.0874143868E+00, 9.4245186244E-01],
	[3.4010000000E+04, 7.0075769572E+01, 1.4212415955E+01, 2.5644147893E+01, 8.0888784216E+00, 9.4247861302E-01],
	[3.4015000000E+04, 7.0093244919E+01, 1.4212449685E+01, 2.5656412999E+01, 8.0903421293E+00, 9.4250535019E-01],
	[3.4020000000E+04, 7.0110722054E+01, 1.4212483411E+01, 2.5668682166E+01, 8.0918055099E+00, 9.4253207398E-01],
	[3.4025000000E+04, 7.0128200977E+01, 1.4212517131E+01, 2.5680955393E+01, 8.0932685633E+00, 9.4255878438E-01],
	[3.4030000000E+04, 7.0145681689E+01, 1.4212550847E+01, 2.5693232681E+01, 8.0947312895E+00, 9.4258548140E-01],
	[3.4035000000E+04, 7.0163164189E+01, 1.4212584558E+01, 2.5705514031E+01, 8.0961936886E+00, 9.4261216505E-01],
	[3.4040000000E+04, 7.0180648477E+01, 1.4212618264E+01, 2.5717799444E+01, 8.0976557605E+00, 9.4263883534E-01],
	[3.4045000000E+04, 7.0198134553E+01, 1.4212651965E+01, 2.5730088920E+01, 8.0991175052E+00, 9.4266549227E-01],
	[3.4050000000E+04, 7.0215622417E+01, 1.4212685661E+01, 2.5742382461E+01, 8.1005789228E+00, 9.4269213585E-01],
	[3.4055000000E+04, 7.0233112069E+01, 1.4212719353E+01, 2.5754680066E+01, 8.1020400133E+00, 9.4271876608E-01],
	[3.4060000000E+04, 7.0250603508E+01, 1.4212753039E+01, 2.5766981738E+01, 8.1035007765E+00, 9.4274538297E-01],
	[3.4065000000E+04, 7.0268096735E+01, 1.4212786721E+01, 2.5779287475E+01, 8.1049612126E+00, 9.4277198653E-01],
	[3.4070000000E+04, 7.0285591750E+01, 1.4212820398E+01, 2.5791597280E+01, 8.1064213215E+00, 9.4279857676E-01],
	[3.4075000000E+04, 7.0303088553E+01, 1.4212854070E+01, 2.5803911153E+01, 8.1078811032E+00, 9.4282515367E-01],
	[3.4080000000E+04, 7.0320587143E+01, 1.4212887737E+01, 2.5816229095E+01, 8.1093405578E+00, 9.4285171727E-01],
	[3.4085000000E+04, 7.0338087520E+01, 1.4212921399E+01, 2.5828551106E+01, 8.1107996851E+00, 9.4287826756E-01],
	[3.4090000000E+04, 7.0355589685E+01, 1.4212955056E+01, 2.5840877187E+01, 8.1122584853E+00, 9.4290480456E-01],
	[3.4095000000E+04, 7.0373093637E+01, 1.4212988709E+01, 2.5853207339E+01, 8.1137169583E+00, 9.4293132825E-01],
	[3.4100000000E+04, 7.0390599376E+01, 1.4213022356E+01, 2.5865541563E+01, 8.1151751042E+00, 9.4295783866E-01],
	[3.4105000000E+04, 7.0408106902E+01, 1.4213055999E+01, 2.5877879859E+01, 8.1166329228E+00, 9.4298433579E-01],
	[3.4110000000E+04, 7.0425616215E+01, 1.4213089637E+01, 2.5890222229E+01, 8.1180904143E+00, 9.4301081964E-01],
	[3.4115000000E+04, 7.0443127315E+01, 1.4213123270E+01, 2.5902568672E+01, 8.1195475785E+00, 9.4303729023E-01],
	[3.4120000000E+04, 7.0460640202E+01, 1.4213156898E+01, 2.5914919190E+01, 8.1210044156E+00, 9.4306374755E-01],
	[3.4125000000E+04, 7.0478154875E+01, 1.4213190522E+01, 2.5927273783E+01, 8.1224609255E+00, 9.4309019161E-01],
	[3.4130000000E+04, 7.0495671335E+01, 1.4213224140E+01, 2.5939632453E+01, 8.1239171082E+00, 9.4311662243E-01],
	[3.4135000000E+04, 7.0513189582E+01, 1.4213257754E+01, 2.5951995199E+01, 8.1253729638E+00, 9.4314304000E-01],
	[3.4140000000E+04, 7.0530709616E+01, 1.4213291363E+01, 2.5964362024E+01, 8.1268284921E+00, 9.4316944434E-01],
	[3.4145000000E+04, 7.0548231435E+01, 1.4213324967E+01, 2.5976732926E+01, 8.1282836932E+00, 9.4319583545E-01],
	[3.4150000000E+04, 7.0565755041E+01, 1.4213358566E+01, 2.5989107908E+01, 8.1297385672E+00, 9.4322221333E-01],
	[3.4155000000E+04, 7.0583280434E+01, 1.4213392160E+01, 2.6001486969E+01, 8.1311931140E+00, 9.4324857800E-01],
	[3.4160000000E+04, 7.0600807612E+01, 1.4213425750E+01, 2.6013870111E+01, 8.1326473335E+00, 9.4327492945E-01],
	[3.4165000000E+04, 7.0618336577E+01, 1.4213459335E+01, 2.6026257335E+01, 8.1341012259E+00, 9.4330126770E-01],
	[3.4170000000E+04, 7.0635867328E+01, 1.4213492914E+01, 2.6038648641E+01, 8.1355547911E+00, 9.4332759275E-01],
	[3.4175000000E+04, 7.0653399864E+01, 1.4213526489E+01, 2.6051044029E+01, 8.1370080291E+00, 9.4335390461E-01],
	[3.4180000000E+04, 7.0670934187E+01, 1.4213560060E+01, 2.6063443502E+01, 8.1384609400E+00, 9.4338020329E-01],
	[3.4185000000E+04, 7.0688470295E+01, 1.4213593625E+01, 2.6075847058E+01, 8.1399135236E+00, 9.4340648879E-01],
	[3.4190000000E+04, 7.0706008189E+01, 1.4213627185E+01, 2.6088254700E+01, 8.1413657800E+00, 9.4343276111E-01],
	[3.4195000000E+04, 7.0723547869E+01, 1.4213660741E+01, 2.6100666427E+01, 8.1428177093E+00, 9.4345902027E-01],
	[3.4200000000E+04, 7.0741089334E+01, 1.4213694292E+01, 2.6113082242E+01, 8.1442693113E+00, 9.4348526627E-01],
	[3.4205000000E+04, 7.0758632585E+01, 1.4213727838E+01, 2.6125502143E+01, 8.1457205862E+00, 9.4351149911E-01],
	[3.4210000000E+04, 7.0776177621E+01, 1.4213761379E+01, 2.6137926133E+01, 8.1471715339E+00, 9.4353771881E-01],
	[3.4215000000E+04, 7.0793724442E+01, 1.4213794915E+01, 2.6150354211E+01, 8.1486221544E+00, 9.4356392537E-01],
	[3.4220000000E+04, 7.0811273049E+01, 1.4213828447E+01, 2.6162786379E+01, 8.1500724477E+00, 9.4359011879E-01],
	[3.4225000000E+04, 7.0828823441E+01, 1.4213861974E+01, 2.6175222638E+01, 8.1515224139E+00, 9.4361629909E-01],
	[3.4230000000E+04, 7.0846375618E+01, 1.4213895496E+01, 2.6187662987E+01, 8.1529720528E+00, 9.4364246626E-01],
	[3.4235000000E+04, 7.0863929580E+01, 1.4213929013E+01, 2.6200107428E+01, 8.1544213646E+00, 9.4366862032E-01],
	[3.4240000000E+04, 7.0881485327E+01, 1.4213962525E+01, 2.6212555962E+01, 8.1558703492E+00, 9.4369476128E-01],
	[3.4245000000E+04, 7.0899042858E+01, 1.4213996032E+01, 2.6225008590E+01, 8.1573190066E+00, 9.4372088913E-01],
	[3.4250000000E+04, 7.0916602175E+01, 1.4214029535E+01, 2.6237465311E+01, 8.1587673368E+00, 9.4374700388E-01],
	[3.4255000000E+04, 7.0934163276E+01, 1.4214063033E+01, 2.6249926127E+01, 8.1602153399E+00, 9.4377310555E-01],
	[3.4260000000E+04, 7.0951726162E+01, 1.4214096526E+01, 2.6262391039E+01, 8.1616630158E+00, 9.4379919413E-01],
	[3.4265000000E+04, 7.0969290832E+01, 1.4214130014E+01, 2.6274860047E+01, 8.1631103645E+00, 9.4382526964E-01],
	[3.4270000000E+04, 7.0986857287E+01, 1.4214163497E+01, 2.6287333152E+01, 8.1645573860E+00, 9.4385133208E-01],
	[3.4275000000E+04, 7.1004425526E+01, 1.4214196976E+01, 2.6299810355E+01, 8.1660040804E+00, 9.4387738145E-01],
	[3.4280000000E+04, 7.1021995549E+01, 1.4214230450E+01, 2.6312291656E+01, 8.1674504476E+00, 9.4390341777E-01],
	[3.4285000000E+04, 7.1039567357E+01, 1.4214263919E+01, 2.6324777057E+01, 8.1688964876E+00, 9.4392944103E-01],
	[3.4290000000E+04, 7.1057140948E+01, 1.4214297383E+01, 2.6337266558E+01, 8.1703422005E+00, 9.4395545126E-01],
	[3.4295000000E+04, 7.1074716324E+01, 1.4214330842E+01, 2.6349760159E+01, 8.1717875862E+00, 9.4398144844E-01],
	[3.4300000000E+04, 7.1092293484E+01, 1.4214364297E+01, 2.6362257863E+01, 8.1732326448E+00, 9.4400743259E-01],
	[3.4305000000E+04, 7.1109872427E+01, 1.4214397747E+01, 2.6374759668E+01, 8.1746773762E+00, 9.4403340372E-01],
	[3.4310000000E+04, 7.1127453155E+01, 1.4214431192E+01, 2.6387265576E+01, 8.1761217804E+00, 9.4405936183E-01],
	[3.4315000000E+04, 7.1145035666E+01, 1.4214464632E+01, 2.6399775589E+01, 8.1775658575E+00, 9.4408530693E-01],
	[3.4320000000E+04, 7.1162619961E+01, 1.4214498067E+01, 2.6412289705E+01, 8.1790096075E+00, 9.4411123902E-01],
	[3.4325000000E+04, 7.1180206039E+01, 1.4214531498E+01, 2.6424807928E+01, 8.1804530303E+00, 9.4413715811E-01],
	[3.4330000000E+04, 7.1197793901E+01, 1.4214564924E+01, 2.6437330256E+01, 8.1818961260E+00, 9.4416306421E-01],
	[3.4335000000E+04, 7.1215383546E+01, 1.4214598345E+01, 2.6449856691E+01, 8.1833388945E+00, 9.4418895732E-01],
	[3.4340000000E+04, 7.1232974975E+01, 1.4214631761E+01, 2.6462387233E+01, 8.1847813359E+00, 9.4421483746E-01],
	[3.4345000000E+04, 7.1250568187E+01, 1.4214665172E+01, 2.6474921884E+01, 8.1862234502E+00, 9.4424070462E-01],
	[3.4350000000E+04, 7.1268163182E+01, 1.4214698579E+01, 2.6487460643E+01, 8.1876652373E+00, 9.4426655881E-01],
	[3.4355000000E+04, 7.1285759960E+01, 1.4214731981E+01, 2.6500003513E+01, 8.1891066973E+00, 9.4429240004E-01],
	[3.4360000000E+04, 7.1303358522E+01, 1.4214765378E+01, 2.6512550493E+01, 8.1905478302E+00, 9.4431822832E-01],
	[3.4365000000E+04, 7.1320958866E+01, 1.4214798770E+01, 2.6525101584E+01, 8.1919886359E+00, 9.4434404365E-01],
	[3.4370000000E+04, 7.1338560993E+01, 1.4214832158E+01, 2.6537656787E+01, 8.1934291146E+00, 9.4436984603E-01],
	[3.4375000000E+04, 7.1356164903E+01, 1.4214865541E+01, 2.6550216103E+01, 8.1948692661E+00, 9.4439563548E-01],
	[3.4380000000E+04, 7.1373770595E+01, 1.4214898919E+01, 2.6562779533E+01, 8.1963090905E+00, 9.4442141201E-01],
	[3.4385000000E+04, 7.1391378071E+01, 1.4214932292E+01, 2.6575347076E+01, 8.1977485879E+00, 9.4444717561E-01],
	[3.4390000000E+04, 7.1408987328E+01, 1.4214965660E+01, 2.6587918735E+01, 8.1991877581E+00, 9.4447292629E-01],
	[3.4395000000E+04, 7.1426598369E+01, 1.4214999024E+01, 2.6600494510E+01, 8.2006266012E+00, 9.4449866407E-01],
	[3.4400000000E+04, 7.1444211191E+01, 1.4215032383E+01, 2.6613074401E+01, 8.2020651172E+00, 9.4452438894E-01],
	[3.4405000000E+04, 7.1461825796E+01, 1.4215065737E+01, 2.6625658409E+01, 8.2035033062E+00, 9.4455010092E-01],
	[3.4410000000E+04, 7.1479442183E+01, 1.4215099086E+01, 2.6638246535E+01, 8.2049411680E+00, 9.4457580000E-01],
	[3.4415000000E+04, 7.1497060353E+01, 1.4215132431E+01, 2.6650838780E+01, 8.2063787028E+00, 9.4460148620E-01],
	[3.4420000000E+04, 7.1514680304E+01, 1.4215165771E+01, 2.6663435144E+01, 8.2078159105E+00, 9.4462715953E-01],
	[3.4425000000E+04, 7.1532302038E+01, 1.4215199106E+01, 2.6676035629E+01, 8.2092527911E+00, 9.4465281998E-01],
	[3.4430000000E+04, 7.1549925553E+01, 1.4215232436E+01, 2.6688640235E+01, 8.2106893447E+00, 9.4467846757E-01],
	[3.4435000000E+04, 7.1567550850E+01, 1.4215265762E+01, 2.6701248962E+01, 8.2121255712E+00, 9.4470410230E-01],
	[3.4440000000E+04, 7.1585177929E+01, 1.4215299083E+01, 2.6713861812E+01, 8.2135614707E+00, 9.4472972417E-01],
	[3.4445000000E+04, 7.1602806790E+01, 1.4215332399E+01, 2.6726478785E+01, 8.2149970430E+00, 9.4475533321E-01],
	[3.4450000000E+04, 7.1620437432E+01, 1.4215365710E+01, 2.6739099882E+01, 8.2164322884E+00, 9.4478092940E-01],
	[3.4455000000E+04, 7.1638069856E+01, 1.4215399016E+01, 2.6751725104E+01, 8.2178672067E+00, 9.4480651276E-01],
	[3.4460000000E+04, 7.1655704061E+01, 1.4215432318E+01, 2.6764354451E+01, 8.2193017980E+00, 9.4483208329E-01],
	[3.4465000000E+04, 7.1673340048E+01, 1.4215465615E+01, 2.6776987924E+01, 8.2207360622E+00, 9.4485764101E-01],
	[3.4470000000E+04, 7.1690977816E+01, 1.4215498907E+01, 2.6789625525E+01, 8.2221699994E+00, 9.4488318591E-01],
	[3.4475000000E+04, 7.1708617365E+01, 1.4215532195E+01, 2.6802267253E+01, 8.2236036096E+00, 9.4490871800E-01],
	[3.4480000000E+04, 7.1726258695E+01, 1.4215565478E+01, 2.6814913110E+01, 8.2250368928E+00, 9.4493423729E-01],
	[3.4485000000E+04, 7.1743901806E+01, 1.4215598755E+01, 2.6827563095E+01, 8.2264698489E+00, 9.4495974379E-01],
	[3.4490000000E+04, 7.1761546699E+01, 1.4215632029E+01, 2.6840217211E+01, 8.2279024781E+00, 9.4498523750E-01],
	[3.4495000000E+04, 7.1779193372E+01, 1.4215665297E+01, 2.6852875458E+01, 8.2293347802E+00, 9.4501071843E-01],
	[3.4500000000E+04, 7.1796841826E+01, 1.4215698561E+01, 2.6865537835E+01, 8.2307667554E+00, 9.4503618658E-01],
	[3.4505000000E+04, 7.1814492061E+01, 1.4215731820E+01, 2.6878204345E+01, 8.2321984036E+00, 9.4506164197E-01],
	[3.4510000000E+04, 7.1832144076E+01, 1.4215765074E+01, 2.6890874989E+01, 8.2336297248E+00, 9.4508708459E-01],
	[3.4515000000E+04, 7.1849797872E+01, 1.4215798324E+01, 2.6903549765E+01, 8.2350607190E+00, 9.4511251446E-01],
	[3.4520000000E+04, 7.1867453449E+01, 1.4215831569E+01, 2.6916228676E+01, 8.2364913862E+00, 9.4513793157E-01],
	[3.4525000000E+04, 7.1885110806E+01, 1.4215864809E+01, 2.6928911723E+01, 8.2379217265E+00, 9.4516333595E-01],
	[3.4530000000E+04, 7.1902769943E+01, 1.4215898044E+01, 2.6941598905E+01, 8.2393517399E+00, 9.4518872759E-01],
	[3.4535000000E+04, 7.1920475833E+01, 1.4215937572E+01, 2.6954290224E+01, 8.2407841327E+00, 9.4521410649E-01],
	[3.4540000000E+04, 7.1938191313E+01, 1.4215978185E+01, 2.6966985680E+01, 8.2422166690E+00, 9.4523947268E-01],
	[3.4545000000E+04, 7.1955908591E+01, 1.4216018792E+01, 2.6979685275E+01, 8.2436488797E+00, 9.4526482614E-01],
	[3.4550000000E+04, 7.1973627668E+01, 1.4216059394E+01, 2.6992389009E+01, 8.2450807648E+00, 9.4529016690E-01],
	[3.4555000000E+04, 7.1991348543E+01, 1.4216099990E+01, 2.7005096882E+01, 8.2465123244E+00, 9.4531549494E-01],
	[3.4560000000E+04, 7.2009071216E+01, 1.4216140580E+01, 2.7017808896E+01, 8.2479435585E+00, 9.4534081030E-01],
	[3.4565000000E+04, 7.2026795687E+01, 1.4216181165E+01, 2.7030525050E+01, 8.2493744671E+00, 9.4536611295E-01],
	[3.4570000000E+04, 7.2044521957E+01, 1.4216221744E+01, 2.7043245347E+01, 8.2508050501E+00, 9.4539140293E-01],
	[3.4575000000E+04, 7.2062250024E+01, 1.4216262316E+01, 2.7055969787E+01, 8.2522353077E+00, 9.4541668022E-01],
	[3.4580000000E+04, 7.2079979889E+01, 1.4216302884E+01, 2.7068698370E+01, 8.2536652397E+00, 9.4544194484E-01],
	[3.4585000000E+04, 7.2097711552E+01, 1.4216343445E+01, 2.7081431097E+01, 8.2550948463E+00, 9.4546719680E-01],
	[3.4590000000E+04, 7.2115445013E+01, 1.4216384001E+01, 2.7094167969E+01, 8.2565241273E+00, 9.4549243609E-01],
	[3.4595000000E+04, 7.2133180271E+01, 1.4216424551E+01, 2.7106908986E+01, 8.2579530829E+00, 9.4551766273E-01],
	[3.4600000000E+04, 7.2150917327E+01, 1.4216465095E+01, 2.7119654150E+01, 8.2593817130E+00, 9.4554287673E-01],
	[3.4605000000E+04, 7.2168656181E+01, 1.4216505633E+01, 2.7132403462E+01, 8.2608100176E+00, 9.4556807808E-01],
	[3.4610000000E+04, 7.2186396832E+01, 1.4216546166E+01, 2.7145156921E+01, 8.2622379968E+00, 9.4559326680E-01],
	[3.4615000000E+04, 7.2204139280E+01, 1.4216586693E+01, 2.7157914528E+01, 8.2636656505E+00, 9.4561844289E-01],
	[3.4620000000E+04, 7.2221883526E+01, 1.4216627214E+01, 2.7170676286E+01, 8.2650929788E+00, 9.4564360636E-01],
	[3.4625000000E+04, 7.2239629568E+01, 1.4216667730E+01, 2.7183442193E+01, 8.2665199816E+00, 9.4566875721E-01],
	[3.4630000000E+04, 7.2257377408E+01, 1.4216708240E+01, 2.7196212251E+01, 8.2679466590E+00, 9.4569389546E-01],
	[3.4635000000E+04, 7.2275127045E+01, 1.4216748744E+01, 2.7208986461E+01, 8.2693730110E+00, 9.4571902110E-01],
	[3.4640000000E+04, 7.2292878479E+01, 1.4216789242E+01, 2.7221764824E+01, 8.2707990375E+00, 9.4574413414E-01],
	[3.4645000000E+04, 7.2310631710E+01, 1.4216829735E+01, 2.7234547339E+01, 8.2722247387E+00, 9.4576923460E-01],
	[3.4650000000E+04, 7.2328386737E+01, 1.4216870221E+01, 2.7247334009E+01, 8.2736501144E+00, 9.4579432247E-01],
	[3.4655000000E+04, 7.2346143562E+01, 1.4216910703E+01, 2.7260124833E+01, 8.2750751647E+00, 9.4581939777E-01],
	[3.4660000000E+04, 7.2363902182E+01, 1.4216951178E+01, 2.7272919812E+01, 8.2764998897E+00, 9.4584446049E-01],
	[3.4665000000E+04, 7.2381662600E+01, 1.4216991648E+01, 2.7285718948E+01, 8.2779242893E+00, 9.4586951065E-01],
	[3.4670000000E+04, 7.2399424814E+01, 1.4217032112E+01, 2.7298522241E+01, 8.2793483635E+00, 9.4589454825E-01],
	[3.4675000000E+04, 7.2417188824E+01, 1.4217072570E+01, 2.7311329691E+01, 8.2807721123E+00, 9.4591957330E-01],
	[3.4680000000E+04, 7.2434954631E+01, 1.4217113022E+01, 2.7324141300E+01, 8.2821955358E+00, 9.4594458581E-01],
	[3.4685000000E+04, 7.2452722234E+01, 1.4217153469E+01, 2.7336957067E+01, 8.2836186339E+00, 9.4596958577E-01],
	[3.4690000000E+04, 7.2470491633E+01, 1.4217193910E+01, 2.7349776995E+01, 8.2850414067E+00, 9.4599457321E-01],
	[3.4695000000E+04, 7.2488262829E+01, 1.4217234346E+01, 2.7362601083E+01, 8.2864638542E+00, 9.4601954812E-01],
	[3.4700000000E+04, 7.2506035820E+01, 1.4217274775E+01, 2.7375429333E+01, 8.2878859764E+00, 9.4604451050E-01],
	[3.4705000000E+04, 7.2523810607E+01, 1.4217315199E+01, 2.7388261745E+01, 8.2893077732E+00, 9.4606946038E-01],
	[3.4710000000E+04, 7.2541587190E+01, 1.4217355618E+01, 2.7401098320E+01, 8.2907292447E+00, 9.4609439775E-01],
	[3.4715000000E+04, 7.2559365569E+01, 1.4217396030E+01, 2.7413939058E+01, 8.2921503910E+00, 9.4611932261E-01],
	[3.4720000000E+04, 7.2577145744E+01, 1.4217436437E+01, 2.7426783961E+01, 8.2935712119E+00, 9.4614423499E-01],
	[3.4725000000E+04, 7.2594927714E+01, 1.4217476838E+01, 2.7439633029E+01, 8.2949917076E+00, 9.4616913487E-01],
	[3.4730000000E+04, 7.2612711480E+01, 1.4217517233E+01, 2.7452486263E+01, 8.2964118780E+00, 9.4619402227E-01],
	[3.4735000000E+04, 7.2630497042E+01, 1.4217557623E+01, 2.7465343664E+01, 8.2978317231E+00, 9.4621889720E-01],
	[3.4740000000E+04, 7.2648284398E+01, 1.4217598007E+01, 2.7478205232E+01, 8.2992512430E+00, 9.4624375966E-01],
	[3.4745000000E+04, 7.2666073551E+01, 1.4217638386E+01, 2.7491070968E+01, 8.3006704377E+00, 9.4626860966E-01],
	[3.4750000000E+04, 7.2683864498E+01, 1.4217678758E+01, 2.7503940873E+01, 8.3020893071E+00, 9.4629344720E-01],
	[3.4755000000E+04, 7.2701657240E+01, 1.4217719125E+01, 2.7516814947E+01, 8.3035078513E+00, 9.4631827229E-01],
	[3.4760000000E+04, 7.2719451778E+01, 1.4217759486E+01, 2.7529693192E+01, 8.3049260703E+00, 9.4634308494E-01],
	[3.4765000000E+04, 7.2737248111E+01, 1.4217799842E+01, 2.7542575608E+01, 8.3063439640E+00, 9.4636788515E-01],
	[3.4770000000E+04, 7.2755046239E+01, 1.4217840192E+01, 2.7555462196E+01, 8.3077615326E+00, 9.4639267293E-01],
	[3.4775000000E+04, 7.2772846161E+01, 1.4217880536E+01, 2.7568352957E+01, 8.3091787760E+00, 9.4641744829E-01],
	[3.4780000000E+04, 7.2790647878E+01, 1.4217920874E+01, 2.7581247891E+01, 8.3105956942E+00, 9.4644221123E-01],
	[3.4785000000E+04, 7.2808451390E+01, 1.4217961207E+01, 2.7594146999E+01, 8.3120122873E+00, 9.4646696175E-01],
	[3.4790000000E+04, 7.2826256697E+01, 1.4218001534E+01, 2.7607050282E+01, 8.3134285552E+00, 9.4649169987E-01],
	[3.4795000000E+04, 7.2844063798E+01, 1.4218041856E+01, 2.7619957741E+01, 8.3148444979E+00, 9.4651642560E-01],
	[3.4800000000E+04, 7.2861872694E+01, 1.4218082172E+01, 2.7632869376E+01, 8.3162601156E+00, 9.4654113893E-01],
	[3.4805000000E+04, 7.2879683384E+01, 1.4218122482E+01, 2.7645785189E+01, 8.3176754080E+00, 9.4656583987E-01],
	[3.4810000000E+04, 7.2897495869E+01, 1.4218162786E+01, 2.7658705179E+01, 8.3190903754E+00, 9.4659052843E-01],
	[3.4815000000E+04, 7.2915310147E+01, 1.4218203085E+01, 2.7671629348E+01, 8.3205050177E+00, 9.4661520463E-01],
	[3.4820000000E+04, 7.2933126220E+01, 1.4218243378E+01, 2.7684557696E+01, 8.3219193349E+00, 9.4663986845E-01],
	[3.4825000000E+04, 7.2950944087E+01, 1.4218283665E+01, 2.7697490224E+01, 8.3233333270E+00, 9.4666451991E-01],
	[3.4830000000E+04, 7.2968763748E+01, 1.4218323947E+01, 2.7710426933E+01, 8.3247469940E+00, 9.4668915902E-01],
	[3.4835000000E+04, 7.2986585203E+01, 1.4218364223E+01, 2.7723367824E+01, 8.3261603359E+00, 9.4671378578E-01],
	[3.4840000000E+04, 7.3004408452E+01, 1.4218404493E+01, 2.7736312897E+01, 8.3275733528E+00, 9.4673840020E-01],
	[3.4845000000E+04, 7.3022233495E+01, 1.4218444758E+01, 2.7749262154E+01, 8.3289860447E+00, 9.4676300229E-01],
	[3.4850000000E+04, 7.3040060331E+01, 1.4218485017E+01, 2.7762215594E+01, 8.3303984115E+00, 9.4678759204E-01],
	[3.4855000000E+04, 7.3057888961E+01, 1.4218525271E+01, 2.7775173219E+01, 8.3318104533E+00, 9.4681216947E-01],
	[3.4860000000E+04, 7.3075719385E+01, 1.4218565518E+01, 2.7788135029E+01, 8.3332221701E+00, 9.4683673459E-01],
	[3.4865000000E+04, 7.3093551602E+01, 1.4218605760E+01, 2.7801101026E+01, 8.3346335619E+00, 9.4686128739E-01],
	[3.4870000000E+04, 7.3111385612E+01, 1.4218645997E+01, 2.7814071209E+01, 8.3360446287E+00, 9.4688582790E-01],
	[3.4875000000E+04, 7.3129221416E+01, 1.4218686228E+01, 2.7827045580E+01, 8.3374553706E+00, 9.4691035610E-01],
	[3.4880000000E+04, 7.3147059013E+01, 1.4218726453E+01, 2.7840024140E+01, 8.3388657875E+00, 9.4693487201E-01],
	[3.4885000000E+04, 7.3164898403E+01, 1.4218766672E+01, 2.7853006888E+01, 8.3402758794E+00, 9.4695937564E-01],
	[3.4890000000E+04, 7.3182739587E+01, 1.4218806886E+01, 2.7865993826E+01, 8.3416856464E+00, 9.4698386699E-01],
	[3.4895000000E+04, 7.3200582563E+01, 1.4218847094E+01, 2.7878984955E+01, 8.3430950884E+00, 9.4700834607E-01],
	[3.4900000000E+04, 7.3218427332E+01, 1.4218887297E+01, 2.7891980276E+01, 8.3445042055E+00, 9.4703281289E-01],
	[3.4905000000E+04, 7.3236273894E+01, 1.4218927494E+01, 2.7904979789E+01, 8.3459129978E+00, 9.4705726744E-01],
	[3.4910000000E+04, 7.3254122249E+01, 1.4218967685E+01, 2.7917983494E+01, 8.3473214651E+00, 9.4708170974E-01],
	[3.4915000000E+04, 7.3271972397E+01, 1.4219007870E+01, 2.7930991393E+01, 8.3487296076E+00, 9.4710613980E-01],
	[3.4920000000E+04, 7.3289824337E+01, 1.4219048050E+01, 2.7944003487E+01, 8.3501374251E+00, 9.4713055761E-01],
	[3.4925000000E+04, 7.3307678070E+01, 1.4219088225E+01, 2.7957019775E+01, 8.3515449179E+00, 9.4715496319E-01],
	[3.4930000000E+04, 7.3325533596E+01, 1.4219128393E+01, 2.7970040260E+01, 8.3529520857E+00, 9.4717935655E-01],
	[3.4935000000E+04, 7.3343390913E+01, 1.4219168556E+01, 2.7983064941E+01, 8.3543589288E+00, 9.4720373768E-01],
	[3.4940000000E+04, 7.3361250024E+01, 1.4219208714E+01, 2.7996093820E+01, 8.3557654470E+00, 9.4722810659E-01],
	[3.4945000000E+04, 7.3379110926E+01, 1.4219248866E+01, 2.8009126896E+01, 8.3571716404E+00, 9.4725246330E-01],
	[3.4950000000E+04, 7.3396973621E+01, 1.4219289012E+01, 2.8022164172E+01, 8.3585775090E+00, 9.4727680781E-01],
	[3.4955000000E+04, 7.3414838107E+01, 1.4219329152E+01, 2.8035205647E+01, 8.3599830528E+00, 9.4730114012E-01],
	[3.4960000000E+04, 7.3432704386E+01, 1.4219369287E+01, 2.8048251323E+01, 8.3613882719E+00, 9.4732546024E-01],
	[3.4965000000E+04, 7.3450572457E+01, 1.4219409416E+01, 2.8061301200E+01, 8.3627931661E+00, 9.4734976817E-01],
	[3.4970000000E+04, 7.3468442319E+01, 1.4219449540E+01, 2.8074355278E+01, 8.3641977357E+00, 9.4737406393E-01],
	[3.4975000000E+04, 7.3486313973E+01, 1.4219489658E+01, 2.8087413560E+01, 8.3656019805E+00, 9.4739834752E-01],
	[3.4980000000E+04, 7.3504187420E+01, 1.4219529770E+01, 2.8100476045E+01, 8.3670059006E+00, 9.4742261894E-01],
	[3.4985000000E+04, 7.3522062657E+01, 1.4219569877E+01, 2.8113542734E+01, 8.3684094960E+00, 9.4744687821E-01],
	[3.4990000000E+04, 7.3539939686E+01, 1.4219609978E+01, 2.8126613627E+01, 8.3698127666E+00, 9.4747112533E-01],
	[3.4995000000E+04, 7.3557818507E+01, 1.4219650074E+01, 2.8139688727E+01, 8.3712157126E+00, 9.4749536029E-01],
	[3.5000000000E+04, 7.3575699119E+01, 1.4219690164E+01, 2.8152768033E+01, 8.3726183340E+00, 9.4751958312E-01],
	[3.5005000000E+04, 7.3593581523E+01, 1.4219730248E+01, 2.8165865218E+01, 8.3740218392E+00, 9.4754379382E-01],
	[3.5010000000E+04, 7.3611465718E+01, 1.4219770327E+01, 2.8178966622E+01, 8.3754250193E+00, 9.4756799239E-01],
	[3.5015000000E+04, 7.3629351704E+01, 1.4219810400E+01, 2.8192072247E+01, 8.3768278743E+00, 9.4759217884E-01],
	[3.5020000000E+04, 7.3647239481E+01, 1.4219850467E+01, 2.8205182091E+01, 8.3782304043E+00, 9.4761635318E-01],
	[3.5025000000E+04, 7.3665129049E+01, 1.4219890529E+01, 2.8218296157E+01, 8.3796326092E+00, 9.4764051541E-01],
	[3.5030000000E+04, 7.3683020408E+01, 1.4219930585E+01, 2.8231414444E+01, 8.3810344890E+00, 9.4766466553E-01],
	[3.5035000000E+04, 7.3700913558E+01, 1.4219970636E+01, 2.8244536954E+01, 8.3824360438E+00, 9.4768880357E-01],
	[3.5040000000E+04, 7.3718808499E+01, 1.4220010681E+01, 2.8257663688E+01, 8.3838372735E+00, 9.4771292951E-01],
	[3.5045000000E+04, 7.3736705230E+01, 1.4220050720E+01, 2.8270794646E+01, 8.3852381783E+00, 9.4773704337E-01],
	[3.5050000000E+04, 7.3754603752E+01, 1.4220090754E+01, 2.8283929829E+01, 8.3866387580E+00, 9.4776114516E-01],
	[3.5055000000E+04, 7.3772504065E+01, 1.4220130782E+01, 2.8297069237E+01, 8.3880390128E+00, 9.4778523487E-01],
	[3.5060000000E+04, 7.3790406168E+01, 1.4220170805E+01, 2.8310212872E+01, 8.3894389426E+00, 9.4780931252E-01],
	[3.5065000000E+04, 7.3808310062E+01, 1.4220210822E+01, 2.8323360734E+01, 8.3908385474E+00, 9.4783337812E-01],
	[3.5070000000E+04, 7.3826215746E+01, 1.4220250834E+01, 2.8336512824E+01, 8.3922378273E+00, 9.4785743166E-01],
	[3.5075000000E+04, 7.3844123220E+01, 1.4220290839E+01, 2.8349669143E+01, 8.3936367822E+00, 9.4788147316E-01],
	[3.5080000000E+04, 7.3862032485E+01, 1.4220330840E+01, 2.8362829692E+01, 8.3950354123E+00, 9.4790550262E-01],
	[3.5085000000E+04, 7.3879943539E+01, 1.4220370834E+01, 2.8375994470E+01, 8.3964337174E+00, 9.4792952005E-01],
	[3.5090000000E+04, 7.3897891438E+01, 1.4220415694E+01, 2.8389163480E+01, 8.3978338489E+00, 9.4795352545E-01],
	[3.5095000000E+04, 7.3915858194E+01, 1.4220462917E+01, 2.8402336721E+01, 8.3992347033E+00, 9.4797751883E-01],
	[3.5100000000E+04, 7.3933826758E+01, 1.4220510133E+01, 2.8415514195E+01, 8.4006352341E+00, 9.4800150020E-01],
	[3.5105000000E+04, 7.3951797130E+01, 1.4220557342E+01, 2.8428695902E+01, 8.4020354414E+00, 9.4802546957E-01],
	[3.5110000000E+04, 7.3969769310E+01, 1.4220604545E+01, 2.8441881843E+01, 8.4034353252E+00, 9.4804942693E-01],
	[3.5115000000E+04, 7.3987743297E+01, 1.4220651742E+01, 2.8455072019E+01, 8.4048348856E+00, 9.4807337230E-01],
	[3.5120000000E+04, 7.4005719091E+01, 1.4220698932E+01, 2.8468266430E+01, 8.4062341224E+00, 9.4809730568E-01],
	[3.5125000000E+04, 7.4023696693E+01, 1.4220746115E+01, 2.8481465078E+01, 8.4076330358E+00, 9.4812122707E-01],
	[3.5130000000E+04, 7.4041676102E+01, 1.4220793292E+01, 2.8494667963E+01, 8.4090316258E+00, 9.4814513650E-01],
	[3.5135000000E+04, 7.4059657319E+01, 1.4220840462E+01, 2.8507875085E+01, 8.4104298923E+00, 9.4816903395E-01],
	[3.5140000000E+04, 7.4077640342E+01, 1.4220887626E+01, 2.8521086446E+01, 8.4118278355E+00, 9.4819291944E-01],
	[3.5145000000E+04, 7.4095625173E+01, 1.4220934783E+01, 2.8534302047E+01, 8.4132254552E+00, 9.4821679298E-01],
	[3.5150000000E+04, 7.4113611811E+01, 1.4220981933E+01, 2.8547521887E+01, 8.4146227516E+00, 9.4824065456E-01],
	[3.5155000000E+04, 7.4131600255E+01, 1.4221029077E+01, 2.8560745969E+01, 8.4160197246E+00, 9.4826450420E-01],
	[3.5160000000E+04, 7.4149590507E+01, 1.4221076215E+01, 2.8573974291E+01, 8.4174163742E+00, 9.4828834190E-01],
	[3.5165000000E+04, 7.4167582565E+01, 1.4221123345E+01, 2.8587206856E+01, 8.4188127005E+00, 9.4831216767E-01],
	[3.5170000000E+04, 7.4185576430E+01, 1.4221170470E+01, 2.8600443665E+01, 8.4202087035E+00, 9.4833598151E-01],
	[3.5175000000E+04, 7.4203572102E+01, 1.4221217588E+01, 2.8613684717E+01, 8.4216043832E+00, 9.4835978344E-01],
	[3.5180000000E+04, 7.4221569580E+01, 1.4221264699E+01, 2.8626930013E+01, 8.4229997396E+00, 9.4838357345E-01],
	[3.5185000000E+04, 7.4239568865E+01, 1.4221311803E+01, 2.8640179555E+01, 8.4243947727E+00, 9.4840735156E-01],
	[3.5190000000E+04, 7.4257569956E+01, 1.4221358902E+01, 2.8653433344E+01, 8.4257894826E+00, 9.4843111776E-01],
	[3.5195000000E+04, 7.4275572853E+01, 1.4221405993E+01, 2.8666691379E+01, 8.4271838692E+00, 9.4845487208E-01],
	[3.5200000000E+04, 7.4293577557E+01, 1.4221453078E+01, 2.8679953661E+01, 8.4285779325E+00, 9.4847861450E-01],
	[3.5205000000E+04, 7.4311584066E+01, 1.4221500157E+01, 2.8693220192E+01, 8.4299716727E+00, 9.4850234504E-01],
	[3.5210000000E+04, 7.4329592382E+01, 1.4221547229E+01, 2.8706490972E+01, 8.4313650897E+00, 9.4852606371E-01],
	[3.5215000000E+04, 7.4347602504E+01, 1.4221594294E+01, 2.8719766002E+01, 8.4327581835E+00, 9.4854977051E-01],
	[3.5220000000E+04, 7.4365614432E+01, 1.4221641353E+01, 2.8733045283E+01, 8.4341509541E+00, 9.4857346544E-01],
	[3.5225000000E+04, 7.4383628166E+01, 1.4221688406E+01, 2.8746328815E+01, 8.4355434016E+00, 9.4859714852E-01],
	[3.5230000000E+04, 7.4401643706E+01, 1.4221735452E+01, 2.8759616599E+01, 8.4369355259E+00, 9.4862081975E-01],
	[3.5235000000E+04, 7.4419661051E+01, 1.4221782491E+01, 2.8772908636E+01, 8.4383273271E+00, 9.4864447914E-01],
	[3.5240000000E+04, 7.4437680202E+01, 1.4221829524E+01, 2.8786204927E+01, 8.4397188052E+00, 9.4866812669E-01],
	[3.5245000000E+04, 7.4455701158E+01, 1.4221876550E+01, 2.8799505472E+01, 8.4411099602E+00, 9.4869176240E-01],
	[3.5250000000E+04, 7.4473723920E+01, 1.4221923570E+01, 2.8812810273E+01, 8.4425007922E+00, 9.4871538629E-01],
	[3.5255000000E+04, 7.4491748488E+01, 1.4221970584E+01, 2.8826119329E+01, 8.4438913011E+00, 9.4873899836E-01],
	[3.5260000000E+04, 7.4509774861E+01, 1.4222017591E+01, 2.8839432642E+01, 8.4452814869E+00, 9.4876259862E-01],
	[3.5265000000E+04, 7.4527803039E+01, 1.4222064591E+01, 2.8852750213E+01, 8.4466713498E+00, 9.4878618708E-01],
	[3.5270000000E+04, 7.4545833022E+01, 1.4222111585E+01, 2.8866072041E+01, 8.4480608896E+00, 9.4880976373E-01],
	[3.5275000000E+04, 7.4563864810E+01, 1.4222158572E+01, 2.8879398129E+01, 8.4494501064E+00, 9.4883332859E-01],
	[3.5280000000E+04, 7.4581898404E+01, 1.4222205553E+01, 2.8892728476E+01, 8.4508390003E+00, 9.4885688166E-01],
	[3.5285000000E+04, 7.4599933802E+01, 1.4222252527E+01, 2.8906063084E+01, 8.4522275712E+00, 9.4888042294E-01],
	[3.5290000000E+04, 7.4617971006E+01, 1.4222299495E+01, 2.8919401953E+01, 8.4536158192E+00, 9.4890395246E-01],
	[3.5295000000E+04, 7.4636010014E+01, 1.4222346456E+01, 2.8932745084E+01, 8.4550037442E+00, 9.4892747020E-01],
	[3.5300000000E+04, 7.4654050827E+01, 1.4222393411E+01, 2.8946092478E+01, 8.4563913464E+00, 9.4895097618E-01],
	[3.5305000000E+04, 7.4672093444E+01, 1.4222440359E+01, 2.8959444136E+01, 8.4577786256E+00, 9.4897447041E-01],
	[3.5310000000E+04, 7.4690137867E+01, 1.4222487301E+01, 2.8972800057E+01, 8.4591655820E+00, 9.4899795288E-01],
	[3.5315000000E+04, 7.4708184093E+01, 1.4222534236E+01, 2.8986160244E+01, 8.4605522156E+00, 9.4902142361E-01],
	[3.5320000000E+04, 7.4726232124E+01, 1.4222581165E+01, 2.8999524696E+01, 8.4619385263E+00, 9.4904488259E-01],
	[3.5325000000E+04, 7.4744281960E+01, 1.4222628088E+01, 2.9012893415E+01, 8.4633245141E+00, 9.4906832984E-01],
	[3.5330000000E+04, 7.4762333600E+01, 1.4222675004E+01, 2.9026266401E+01, 8.4647101792E+00, 9.4909176536E-01],
	[3.5335000000E+04, 7.4780387044E+01, 1.4222721913E+01, 2.9039643656E+01, 8.4660955215E+00, 9.4911518915E-01],
	[3.5340000000E+04, 7.4798442292E+01, 1.4222768816E+01, 2.9053025179E+01, 8.4674805410E+00, 9.4913860123E-01],
	[3.5345000000E+04, 7.4816499344E+01, 1.4222815712E+01, 2.9066410971E+01, 8.4688652378E+00, 9.4916200159E-01],
	[3.5350000000E+04, 7.4834558201E+01, 1.4222862602E+01, 2.9079801034E+01, 8.4702496118E+00, 9.4918539024E-01],
	[3.5355000000E+04, 7.4852618861E+01, 1.4222909486E+01, 2.9093195368E+01, 8.4716336631E+00, 9.4920876720E-01],
	[3.5360000000E+04, 7.4870681325E+01, 1.4222956363E+01, 2.9106593974E+01, 8.4730173918E+00, 9.4923213245E-01],
	[3.5365000000E+04, 7.4888745593E+01, 1.4223003233E+01, 2.9119996853E+01, 8.4744007977E+00, 9.4925548602E-01],
	[3.5370000000E+04, 7.4906811664E+01, 1.4223050097E+01, 2.9133404004E+01, 8.4757838810E+00, 9.4927882790E-01],
	[3.5375000000E+04, 7.4924879540E+01, 1.4223096955E+01, 2.9146815430E+01, 8.4771666416E+00, 9.4930215810E-01],
	[3.5380000000E+04, 7.4942949218E+01, 1.4223143806E+01, 2.9160231131E+01, 8.4785490796E+00, 9.4932547663E-01],
	[3.5385000000E+04, 7.4961020700E+01, 1.4223190650E+01, 2.9173651107E+01, 8.4799311950E+00, 9.4934878349E-01],
	[3.5390000000E+04, 7.4979093986E+01, 1.4223237489E+01, 2.9187075360E+01, 8.4813129879E+00, 9.4937207869E-01],
	[3.5395000000E+04, 7.4997169075E+01, 1.4223284320E+01, 2.9200503890E+01, 8.4826944581E+00, 9.4939536222E-01],
	[3.5400000000E+04, 7.5015245967E+01, 1.4223331146E+01, 2.9213936698E+01, 8.4840756058E+00, 9.4941863411E-01],
	[3.5405000000E+04, 7.5033324662E+01, 1.4223377964E+01, 2.9227373784E+01, 8.4854564310E+00, 9.4944189435E-01],
	[3.5410000000E+04, 7.5051405161E+01, 1.4223424777E+01, 2.9240815150E+01, 8.4868369336E+00, 9.4946514295E-01],
	[3.5415000000E+04, 7.5069487462E+01, 1.4223471582E+01, 2.9254260796E+01, 8.4882171137E+00, 9.4948837992E-01],
	[3.5420000000E+04, 7.5087571567E+01, 1.4223518382E+01, 2.9267710723E+01, 8.4895969714E+00, 9.4951160526E-01],
	[3.5425000000E+04, 7.5105657474E+01, 1.4223565175E+01, 2.9281164931E+01, 8.4909765066E+00, 9.4953481897E-01],
	[3.5430000000E+04, 7.5123745184E+01, 1.4223611961E+01, 2.9294623422E+01, 8.4923557194E+00, 9.4955802107E-01],
	[3.5435000000E+04, 7.5141834697E+01, 1.4223658741E+01, 2.9308086196E+01, 8.4937346097E+00, 9.4958121155E-01],
	[3.5440000000E+04, 7.5159926012E+01, 1.4223705515E+01, 2.9321553254E+01, 8.4951131777E+00, 9.4960439043E-01],
	[3.5445000000E+04, 7.5178019130E+01, 1.4223752282E+01, 2.9335024597E+01, 8.4964914232E+00, 9.4962755770E-01],
	[3.5450000000E+04, 7.5196114051E+01, 1.4223799043E+01, 2.9348500225E+01, 8.4978693464E+00, 9.4965071338E-01],
	[3.5455000000E+04, 7.5214210774E+01, 1.4223845797E+01, 2.9361980140E+01, 8.4992469472E+00, 9.4967385747E-01],
	[3.5460000000E+04, 7.5232309299E+01, 1.4223892545E+01, 2.9375464341E+01, 8.5006242257E+00, 9.4969698998E-01],
	[3.5465000000E+04, 7.5250409627E+01, 1.4223939287E+01, 2.9388952830E+01, 8.5020011819E+00, 9.4972011090E-01],
	[3.5470000000E+04, 7.5268511757E+01, 1.4223986022E+01, 2.9402445608E+01, 8.5033778159E+00, 9.4974322026E-01],
	[3.5475000000E+04, 7.5286615689E+01, 1.4224032750E+01, 2.9415942675E+01, 8.5047541275E+00, 9.4976631804E-01],
	[3.5480000000E+04, 7.5304721423E+01, 1.4224079472E+01, 2.9429444032E+01, 8.5061301169E+00, 9.4978940427E-01],
	[3.5485000000E+04, 7.5322828959E+01, 1.4224126188E+01, 2.9442949680E+01, 8.5075057841E+00, 9.4981247893E-01],
	[3.5490000000E+04, 7.5340938296E+01, 1.4224172897E+01, 2.9456459619E+01, 8.5088811290E+00, 9.4983554205E-01],
	[3.5495000000E+04, 7.5359049436E+01, 1.4224219600E+01, 2.9469973850E+01, 8.5102561518E+00, 9.4985859362E-01],
	[3.5500000000E+04, 7.5377162378E+01, 1.4224266296E+01, 2.9483492375E+01, 8.5116308523E+00, 9.4988163365E-01],
	[3.5505000000E+04, 7.5395277121E+01, 1.4224312986E+01, 2.9497015193E+01, 8.5130052308E+00, 9.4990466215E-01],
	[3.5510000000E+04, 7.5413393666E+01, 1.4224359670E+01, 2.9510542306E+01, 8.5143792871E+00, 9.4992767912E-01],
	[3.5515000000E+04, 7.5431512012E+01, 1.4224406347E+01, 2.9524073714E+01, 8.5157530213E+00, 9.4995068456E-01],
	[3.5520000000E+04, 7.5449632160E+01, 1.4224453018E+01, 2.9537609418E+01, 8.5171264334E+00, 9.4997367849E-01],
	[3.5525000000E+04, 7.5467754109E+01, 1.4224499682E+01, 2.9551149420E+01, 8.5184995234E+00, 9.4999666091E-01],
	[3.5530000000E+04, 7.5485877859E+01, 1.4224546340E+01, 2.9564693718E+01, 8.5198722913E+00, 9.5001963182E-01],
	[3.5535000000E+04, 7.5504003411E+01, 1.4224592991E+01, 2.9578242315E+01, 8.5212447373E+00, 9.5004259123E-01],
	[3.5540000000E+04, 7.5522130764E+01, 1.4224639636E+01, 2.9591795211E+01, 8.5226168612E+00, 9.5006553915E-01],
	[3.5545000000E+04, 7.5540259918E+01, 1.4224686275E+01, 2.9605352407E+01, 8.5239886631E+00, 9.5008847557E-01],
	[3.5550000000E+04, 7.5558390872E+01, 1.4224732907E+01, 2.9618913904E+01, 8.5253601431E+00, 9.5011140052E-01],
	[3.5555000000E+04, 7.5576523628E+01, 1.4224779533E+01, 2.9632479702E+01, 8.5267313011E+00, 9.5013431398E-01],
	[3.5560000000E+04, 7.5594658185E+01, 1.4224826153E+01, 2.9646049802E+01, 8.5281021372E+00, 9.5015721598E-01],
	[3.5565000000E+04, 7.5612794543E+01, 1.4224872766E+01, 2.9659624205E+01, 8.5294726513E+00, 9.5018010650E-01],
	[3.5570000000E+04, 7.5630932701E+01, 1.4224919372E+01, 2.9673202911E+01, 8.5308428436E+00, 9.5020298557E-01],
	[3.5575000000E+04, 7.5649072660E+01, 1.4224965973E+01, 2.9686785922E+01, 8.5322127140E+00, 9.5022585317E-01],
	[3.5580000000E+04, 7.5667214419E+01, 1.4225012566E+01, 2.9700373238E+01, 8.5335822626E+00, 9.5024870933E-01],
	[3.5585000000E+04, 7.5685357979E+01, 1.4225059154E+01, 2.9713964861E+01, 8.5349514893E+00, 9.5027155405E-01],
	[3.5590000000E+04, 7.5703503339E+01, 1.4225105735E+01, 2.9727560789E+01, 8.5363203942E+00, 9.5029438732E-01],
	[3.5595000000E+04, 7.5721650500E+01, 1.4225152310E+01, 2.9741161026E+01, 8.5376889774E+00, 9.5031720917E-01],
	[3.5600000000E+04, 7.5739799461E+01, 1.4225198878E+01, 2.9754765570E+01, 8.5390572388E+00, 9.5034001958E-01],
	[3.5605000000E+04, 7.5757950222E+01, 1.4225245440E+01, 2.9768374423E+01, 8.5404251784E+00, 9.5036281857E-01],
	[3.5610000000E+04, 7.5776102783E+01, 1.4225291995E+01, 2.9781987586E+01, 8.5417927963E+00, 9.5038560615E-01],
	[3.5615000000E+04, 7.5794257145E+01, 1.4225338544E+01, 2.9795605060E+01, 8.5431600925E+00, 9.5040838231E-01],
	[3.5620000000E+04, 7.5812413306E+01, 1.4225385087E+01, 2.9809226845E+01, 8.5445270670E+00, 9.5043114707E-01],
	[3.5625000000E+04, 7.5830571267E+01, 1.4225431623E+01, 2.9822852941E+01, 8.5458937199E+00, 9.5045390043E-01],
	[3.5630000000E+04, 7.5848731028E+01, 1.4225478153E+01, 2.9836483351E+01, 8.5472600512E+00, 9.5047664240E-01],
	[3.5635000000E+04, 7.5866892589E+01, 1.4225524677E+01, 2.9850118074E+01, 8.5486260608E+00, 9.5049937298E-01],
	[3.5640000000E+04, 7.5885055949E+01, 1.4225571194E+01, 2.9863757111E+01, 8.5499917488E+00, 9.5052209217E-01],
	[3.5645000000E+04, 7.5903221109E+01, 1.4225617705E+01, 2.9877400464E+01, 8.5513571153E+00, 9.5054479999E-01],
	[3.5650000000E+04, 7.5921388069E+01, 1.4225664210E+01, 2.9891048132E+01, 8.5527221602E+00, 9.5056749644E-01],
	[3.5655000000E+04, 7.5939593060E+01, 1.4225715687E+01, 2.9904700116E+01, 8.5540891437E+00, 9.5059018152E-01],
	[3.5660000000E+04, 7.5957815150E+01, 1.4225769258E+01, 2.9918356418E+01, 8.5554567602E+00, 9.5061285524E-01],
	[3.5665000000E+04, 7.5976039057E+01, 1.4225822821E+01, 2.9932017038E+01, 8.5568240565E+00, 9.5063551760E-01],
	[3.5670000000E+04, 7.5994264780E+01, 1.4225876377E+01, 2.9945681977E+01, 8.5581910326E+00, 9.5065816862E-01],
	[3.5675000000E+04, 7.6012492320E+01, 1.4225929926E+01, 2.9959351235E+01, 8.5595576885E+00, 9.5068080829E-01],
	[3.5680000000E+04, 7.6030721676E+01, 1.4225983468E+01, 2.9973024814E+01, 8.5609240243E+00, 9.5070343662E-01],
	[3.5685000000E+04, 7.6048952849E+01, 1.4226037002E+01, 2.9986702714E+01, 8.5622900399E+00, 9.5072605362E-01],
	[3.5690000000E+04, 7.6067185838E+01, 1.4226090529E+01, 3.0000384935E+01, 8.5636557355E+00, 9.5074865930E-01],
	[3.5695000000E+04, 7.6085420644E+01, 1.4226144049E+01, 3.0014071479E+01, 8.5650211109E+00, 9.5077125365E-01],
	[3.5700000000E+04, 7.6103657266E+01, 1.4226197561E+01, 3.0027762347E+01, 8.5663861663E+00, 9.5079383669E-01],
	[3.5705000000E+04, 7.6121895704E+01, 1.4226251066E+01, 3.0041457539E+01, 8.5677509017E+00, 9.5081640841E-01],
	[3.5710000000E+04, 7.6140135958E+01, 1.4226304564E+01, 3.0055157055E+01, 8.5691153170E+00, 9.5083896884E-01],
	[3.5715000000E+04, 7.6158378028E+01, 1.4226358054E+01, 3.0068860898E+01, 8.5704794123E+00, 9.5086151796E-01],
	[3.5720000000E+04, 7.6176621915E+01, 1.4226411537E+01, 3.0082569066E+01, 8.5718431877E+00, 9.5088405579E-01],
	[3.5725000000E+04, 7.6194867617E+01, 1.4226465013E+01, 3.0096281562E+01, 8.5732066431E+00, 9.5090658233E-01],
	[3.5730000000E+04, 7.6213115134E+01, 1.4226518482E+01, 3.0109998386E+01, 8.5745697785E+00, 9.5092909759E-01],
	[3.5735000000E+04, 7.6231364468E+01, 1.4226571943E+01, 3.0123719538E+01, 8.5759325941E+00, 9.5095160157E-01],
	[3.5740000000E+04, 7.6249615617E+01, 1.4226625397E+01, 3.0137445020E+01, 8.5772950898E+00, 9.5097409429E-01],
	[3.5745000000E+04, 7.6267868582E+01, 1.4226678844E+01, 3.0151174832E+01, 8.5786572656E+00, 9.5099657573E-01],
	[3.5750000000E+04, 7.6286123363E+01, 1.4226732283E+01, 3.0164908975E+01, 8.5800191215E+00, 9.5101904592E-01],
	[3.5755000000E+04, 7.6304379958E+01, 1.4226785716E+01, 3.0178647450E+01, 8.5813806577E+00, 9.5104150485E-01],
	[3.5760000000E+04, 7.6322638369E+01, 1.4226839141E+01, 3.0192390257E+01, 8.5827418740E+00, 9.5106395254E-01],
	[3.5765000000E+04, 7.6340898596E+01, 1.4226892558E+01, 3.0206137397E+01, 8.5841027706E+00, 9.5108638898E-01],
	[3.5770000000E+04, 7.6359160638E+01, 1.4226945969E+01, 3.0219888872E+01, 8.5854633474E+00, 9.5110881419E-01],
	[3.5775000000E+04, 7.6377424494E+01, 1.4226999372E+01, 3.0233644681E+01, 8.5868236045E+00, 9.5113122816E-01],
	[3.5780000000E+04, 7.6395690166E+01, 1.4227052768E+01, 3.0247404826E+01, 8.5881835419E+00, 9.5115363090E-01],
	[3.5785000000E+04, 7.6413957653E+01, 1.4227106156E+01, 3.0261169307E+01, 8.5895431596E+00, 9.5117602243E-01],
	[3.5790000000E+04, 7.6432226955E+01, 1.4227159538E+01, 3.0274938125E+01, 8.5909024576E+00, 9.5119840274E-01],
	[3.5795000000E+04, 7.6450498072E+01, 1.4227212912E+01, 3.0288711280E+01, 8.5922614360E+00, 9.5122077184E-01],
	[3.5800000000E+04, 7.6468771003E+01, 1.4227266279E+01, 3.0302488775E+01, 8.5936200948E+00, 9.5124312974E-01],
	[3.5805000000E+04, 7.6487045750E+01, 1.4227319638E+01, 3.0316270608E+01, 8.5949784340E+00, 9.5126547644E-01],
	[3.5810000000E+04, 7.6505322310E+01, 1.4227372991E+01, 3.0330056782E+01, 8.5963364536E+00, 9.5128781194E-01],
	[3.5815000000E+04, 7.6523600686E+01, 1.4227426336E+01, 3.0343847296E+01, 8.5976941537E+00, 9.5131013626E-01],
	[3.5820000000E+04, 7.6541880876E+01, 1.4227479674E+01, 3.0357642153E+01, 8.5990515342E+00, 9.5133244940E-01],
	[3.5825000000E+04, 7.6560162880E+01, 1.4227533004E+01, 3.0371441351E+01, 8.6004085953E+00, 9.5135475136E-01],
	[3.5830000000E+04, 7.6578446699E+01, 1.4227586328E+01, 3.0385244893E+01, 8.6017653369E+00, 9.5137704215E-01],
	[3.5835000000E+04, 7.6596732332E+01, 1.4227639644E+01, 3.0399052778E+01, 8.6031217590E+00, 9.5139932178E-01],
	[3.5840000000E+04, 7.6615019779E+01, 1.4227692953E+01, 3.0412865008E+01, 8.6044778617E+00, 9.5142159024E-01],
	[3.5845000000E+04, 7.6633309040E+01, 1.4227746254E+01, 3.0426681583E+01, 8.6058336450E+00, 9.5144384756E-01],
	[3.5850000000E+04, 7.6651600115E+01, 1.4227799549E+01, 3.0440502505E+01, 8.6071891089E+00, 9.5146609372E-01],
	[3.5855000000E+04, 7.6669893005E+01, 1.4227852836E+01, 3.0454327773E+01, 8.6085442535E+00, 9.5148832875E-01],
	[3.5860000000E+04, 7.6688187708E+01, 1.4227906116E+01, 3.0468157389E+01, 8.6098990787E+00, 9.5151055263E-01],
	[3.5865000000E+04, 7.6706484225E+01, 1.4227959388E+01, 3.0481991354E+01, 8.6112535846E+00, 9.5153276539E-01],
	[3.5870000000E+04, 7.6724782555E+01, 1.4228012654E+01, 3.0495829668E+01, 8.6126077712E+00, 9.5155496702E-01],
	[3.5875000000E+04, 7.6743082700E+01, 1.4228065912E+01, 3.0509672331E+01, 8.6139616386E+00, 9.5157715753E-01],
	[3.5880000000E+04, 7.6761384658E+01, 1.4228119163E+01, 3.0523519346E+01, 8.6153151867E+00, 9.5159933692E-01],
	[3.5885000000E+04, 7.6779688430E+01, 1.4228172407E+01, 3.0537370712E+01, 8.6166684156E+00, 9.5162150521E-01],
	[3.5890000000E+04, 7.6797994015E+01, 1.4228225644E+01, 3.0551226430E+01, 8.6180213254E+00, 9.5164366239E-01],
	[3.5895000000E+04, 7.6816301413E+01, 1.4228278873E+01, 3.0565086501E+01, 8.6193739159E+00, 9.5166580847E-01],
	[3.5900000000E+04, 7.6834610625E+01, 1.4228332095E+01, 3.0578950925E+01, 8.6207261873E+00, 9.5168794346E-01],
	[3.5905000000E+04, 7.6852921650E+01, 1.4228385310E+01, 3.0592819705E+01, 8.6220781396E+00, 9.5171006737E-01],
	[3.5910000000E+04, 7.6871234488E+01, 1.4228438518E+01, 3.0606692839E+01, 8.6234297728E+00, 9.5173218019E-01],
	[3.5915000000E+04, 7.6889549140E+01, 1.4228491719E+01, 3.0620570330E+01, 8.6247810870E+00, 9.5175428194E-01],
	[3.5920000000E+04, 7.6907865604E+01, 1.4228544912E+01, 3.0634452177E+01, 8.6261320821E+00, 9.5177637262E-01],
	[3.5925000000E+04, 7.6926183881E+01, 1.4228598098E+01, 3.0648338382E+01, 8.6274827582E+00, 9.5179845224E-01],
	[3.5930000000E+04, 7.6944503971E+01, 1.4228651277E+01, 3.0662228945E+01, 8.6288331152E+00, 9.5182052079E-01],
	[3.5935000000E+04, 7.6962825874E+01, 1.4228704449E+01, 3.0676123867E+01, 8.6301831534E+00, 9.5184257830E-01],
	[3.5940000000E+04, 7.6981149590E+01, 1.4228757613E+01, 3.0690023149E+01, 8.6315328725E+00, 9.5186462475E-01],
	[3.5945000000E+04, 7.6999475119E+01, 1.4228810771E+01, 3.0703926792E+01, 8.6328822728E+00, 9.5188666016E-01],
	[3.5950000000E+04, 7.7017802460E+01, 1.4228863921E+01, 3.0717834796E+01, 8.6342313542E+00, 9.5190868454E-01],
	[3.5955000000E+04, 7.7036131613E+01, 1.4228917064E+01, 3.0731747162E+01, 8.6355801166E+00, 9.5193069789E-01],
	[3.5960000000E+04, 7.7054462579E+01, 1.4228970199E+01, 3.0745663891E+01, 8.6369285603E+00, 9.5195270021E-01],
	[3.5965000000E+04, 7.7072795357E+01, 1.4229023328E+01, 3.0759584983E+01, 8.6382766851E+00, 9.5197469151E-01],
	[3.5970000000E+04, 7.7091129948E+01, 1.4229076449E+01, 3.0773510440E+01, 8.6396244911E+00, 9.5199667180E-01],
	[3.5975000000E+04, 7.7109466351E+01, 1.4229129564E+01, 3.0787440262E+01, 8.6409719784E+00, 9.5201864107E-01],
	[3.5980000000E+04, 7.7127804566E+01, 1.4229182671E+01, 3.0801374450E+01, 8.6423191469E+00, 9.5204059935E-01],
	[3.5985000000E+04, 7.7146144593E+01, 1.4229235770E+01, 3.0815313005E+01, 8.6436659967E+00, 9.5206254663E-01],
	[3.5990000000E+04, 7.7164486432E+01, 1.4229288863E+01, 3.0829255927E+01, 8.6450125278E+00, 9.5208448291E-01],
	[3.5995000000E+04, 7.7182830083E+01, 1.4229341948E+01, 3.0843203217E+01, 8.6463587403E+00, 9.5210640821E-01],
	[3.6000000000E+04, 7.7201175546E+01, 1.4229395027E+01, 3.0857154876E+01, 8.6477046341E+00, 9.5212832253E-01],
	[3.6005000000E+04, 7.7219522821E+01, 1.4229448098E+01, 3.0871110905E+01, 8.6490502093E+00, 9.5215022588E-01],
	[3.6010000000E+04, 7.7237871907E+01, 1.4229501162E+01, 3.0885071304E+01, 8.6503954659E+00, 9.5217211825E-01],
	[3.6015000000E+04, 7.7256222805E+01, 1.4229554219E+01, 3.0899036075E+01, 8.6517404039E+00, 9.5219399966E-01],
	[3.6020000000E+04, 7.7274575515E+01, 1.4229607268E+01, 3.0913005217E+01, 8.6530850234E+00, 9.5221587011E-01],
	[3.6025000000E+04, 7.7292930036E+01, 1.4229660311E+01, 3.0926978733E+01, 8.6544293244E+00, 9.5223772961E-01],
	[3.6030000000E+04, 7.7311286369E+01, 1.4229713346E+01, 3.0940956621E+01, 8.6557733069E+00, 9.5225957816E-01],
	[3.6035000000E+04, 7.7329644512E+01, 1.4229766374E+01, 3.0954938884E+01, 8.6571169709E+00, 9.5228141577E-01],
	[3.6040000000E+04, 7.7348004468E+01, 1.4229819395E+01, 3.0968925523E+01, 8.6584603165E+00, 9.5230324245E-01],
	[3.6045000000E+04, 7.7366366234E+01, 1.4229872409E+01, 3.0982916536E+01, 8.6598033437E+00, 9.5232505819E-01],
	[3.6050000000E+04, 7.7384729812E+01, 1.4229925415E+01, 3.0996911927E+01, 8.6611460525E+00, 9.5234686301E-01],
	[3.6055000000E+04, 7.7403095200E+01, 1.4229978415E+01, 3.1010911694E+01, 8.6624884429E+00, 9.5236865690E-01],
	[3.6060000000E+04, 7.7421462400E+01, 1.4230031407E+01, 3.1024915840E+01, 8.6638305150E+00, 9.5239043989E-01],
	[3.6065000000E+04, 7.7439831410E+01, 1.4230084392E+01, 3.1038924365E+01, 8.6651722688E+00, 9.5241221196E-01],
	[3.6070000000E+04, 7.7458202232E+01, 1.4230137371E+01, 3.1052937269E+01, 8.6665137044E+00, 9.5243397314E-01],
	[3.6075000000E+04, 7.7476574864E+01, 1.4230190341E+01, 3.1066954554E+01, 8.6678548216E+00, 9.5245572341E-01],
	[3.6080000000E+04, 7.7494949307E+01, 1.4230243305E+01, 3.1080976219E+01, 8.6691956207E+00, 9.5247746280E-01],
	[3.6085000000E+04, 7.7513325560E+01, 1.4230296262E+01, 3.1095002267E+01, 8.6705361016E+00, 9.5249919129E-01],
	[3.6090000000E+04, 7.7531703624E+01, 1.4230349211E+01, 3.1109032697E+01, 8.6718762643E+00, 9.5252090891E-01],
	[3.6095000000E+04, 7.7550083499E+01, 1.4230402154E+01, 3.1123067510E+01, 8.6732161088E+00, 9.5254261565E-01],
	[3.6100000000E+04, 7.7568465184E+01, 1.4230455089E+01, 3.1137106708E+01, 8.6745556352E+00, 9.5256431153E-01],
	[3.6105000000E+04, 7.7586848679E+01, 1.4230508017E+01, 3.1151150291E+01, 8.6758948436E+00, 9.5258599653E-01],
	[3.6110000000E+04, 7.7605233984E+01, 1.4230560938E+01, 3.1165198259E+01, 8.6772337338E+00, 9.5260767068E-01],
	[3.6115000000E+04, 7.7623621100E+01, 1.4230613852E+01, 3.1179250614E+01, 8.6785723061E+00, 9.5262933398E-01],
	[3.6120000000E+04, 7.7642010026E+01, 1.4230666758E+01, 3.1193307356E+01, 8.6799105603E+00, 9.5265098643E-01],
	[3.6125000000E+04, 7.7660400762E+01, 1.4230719658E+01, 3.1207368486E+01, 8.6812484965E+00, 9.5267262804E-01],
	[3.6130000000E+04, 7.7678793308E+01, 1.4230772550E+01, 3.1221434004E+01, 8.6825861148E+00, 9.5269425881E-01],
	[3.6135000000E+04, 7.7697187664E+01, 1.4230825436E+01, 3.1235503912E+01, 8.6839234151E+00, 9.5271587875E-01],
	[3.6140000000E+04, 7.7715583829E+01, 1.4230878314E+01, 3.1249578211E+01, 8.6852603976E+00, 9.5273748787E-01],
	[3.6145000000E+04, 7.7733981805E+01, 1.4230931185E+01, 3.1263656900E+01, 8.6865970622E+00, 9.5275908617E-01],
	[3.6150000000E+04, 7.7752381590E+01, 1.4230984049E+01, 3.1277739981E+01, 8.6879334089E+00, 9.5278067365E-01],
	[3.6155000000E+04, 7.7770783184E+01, 1.4231036905E+01, 3.1291827455E+01, 8.6892694378E+00, 9.5280225032E-01],
	[3.6160000000E+04, 7.7789186589E+01, 1.4231089755E+01, 3.1305919322E+01, 8.6906051489E+00, 9.5282381619E-01],
	[3.6165000000E+04, 7.7807591802E+01, 1.4231142598E+01, 3.1320015583E+01, 8.6919405423E+00, 9.5284537127E-01],
	[3.6170000000E+04, 7.7825998825E+01, 1.4231195433E+01, 3.1334116238E+01, 8.6932756179E+00, 9.5286691555E-01],
	[3.6175000000E+04, 7.7844407658E+01, 1.4231248262E+01, 3.1348221290E+01, 8.6946103758E+00, 9.5288844905E-01],
	[3.6180000000E+04, 7.7862818300E+01, 1.4231301083E+01, 3.1362330737E+01, 8.6959448160E+00, 9.5290997176E-01],
	[3.6185000000E+04, 7.7881230750E+01, 1.4231353897E+01, 3.1376444582E+01, 8.6972789386E+00, 9.5293148370E-01],
	[3.6190000000E+04, 7.7899645010E+01, 1.4231406704E+01, 3.1390562825E+01, 8.6986127435E+00, 9.5295298487E-01],
	[3.6195000000E+04, 7.7918061079E+01, 1.4231459504E+01, 3.1404685466E+01, 8.6999462309E+00, 9.5297447528E-01],
	[3.6200000000E+04, 7.7936478957E+01, 1.4231512297E+01, 3.1418812507E+01, 8.7012794006E+00, 9.5299595492E-01],
	[3.6205000000E+04, 7.7954898644E+01, 1.4231565083E+01, 3.1432943947E+01, 8.7026122529E+00, 9.5301742382E-01],
	[3.6210000000E+04, 7.7973320140E+01, 1.4231617862E+01, 3.1447079789E+01, 8.7039447876E+00, 9.5303888197E-01],
	[3.6215000000E+04, 7.7991743444E+01, 1.4231670633E+01, 3.1461220032E+01, 8.7052770048E+00, 9.5306032937E-01],
	[3.6220000000E+04, 7.8010168557E+01, 1.4231723398E+01, 3.1475364678E+01, 8.7066089046E+00, 9.5308176604E-01],
	[3.6225000000E+04, 7.8028595479E+01, 1.4231776155E+01, 3.1489513727E+01, 8.7079404869E+00, 9.5310319198E-01],
	[3.6230000000E+04, 7.8047070818E+01, 1.4231835240E+01, 3.1503667180E+01, 8.7092747044E+00, 9.5312460719E-01],
	[3.6235000000E+04, 7.8065552298E+01, 1.4231894903E+01, 3.1517825038E+01, 8.7106088790E+00, 9.5314601168E-01],
	[3.6240000000E+04, 7.8084035603E+01, 1.4231954558E+01, 3.1531987301E+01, 8.7119427376E+00, 9.5316740546E-01],
	[3.6245000000E+04, 7.8102520734E+01, 1.4232014205E+01, 3.1546153970E+01, 8.7132762800E+00, 9.5318878853E-01],
	[3.6250000000E+04, 7.8121007690E+01, 1.4232073845E+01, 3.1560325046E+01, 8.7146095063E+00, 9.5321016089E-01],
	[3.6255000000E+04, 7.8139496471E+01, 1.4232133476E+01, 3.1574500530E+01, 8.7159424166E+00, 9.5323152256E-01],
	[3.6260000000E+04, 7.8157987078E+01, 1.4232193099E+01, 3.1588680423E+01, 8.7172750108E+00, 9.5325287354E-01],
	[3.6265000000E+04, 7.8176479509E+01, 1.4232252715E+01, 3.1602864725E+01, 8.7186072891E+00, 9.5327421382E-01],
	[3.6270000000E+04, 7.8194973765E+01, 1.4232312322E+01, 3.1617053437E+01, 8.7199392514E+00, 9.5329554343E-01],
	[3.6275000000E+04, 7.8213469847E+01, 1.4232371922E+01, 3.1631246559E+01, 8.7212708977E+00, 9.5331686236E-01],
	[3.6280000000E+04, 7.8231967753E+01, 1.4232431513E+01, 3.1645444093E+01, 8.7226022282E+00, 9.5333817063E-01],
	[3.6285000000E+04, 7.8250467484E+01, 1.4232491097E+01, 3.1659646040E+01, 8.7239332427E+00, 9.5335946822E-01],
	[3.6290000000E+04, 7.8268969040E+01, 1.4232550672E+01, 3.1673852400E+01, 8.7252639414E+00, 9.5338075516E-01],
	[3.6295000000E+04, 7.8287472420E+01, 1.4232610240E+01, 3.1688063173E+01, 8.7265943243E+00, 9.5340203145E-01],
	[3.6300000000E+04, 7.8305977625E+01, 1.4232669799E+01, 3.1702278361E+01, 8.7279243913E+00, 9.5342329708E-01],
	[3.6305000000E+04, 7.8324484655E+01, 1.4232729351E+01, 3.1716497965E+01, 8.7292541426E+00, 9.5344455208E-01],
	[3.6310000000E+04, 7.8342993509E+01, 1.4232788895E+01, 3.1730721984E+01, 8.7305835782E+00, 9.5346579644E-01],
	[3.6315000000E+04, 7.8361504187E+01, 1.4232848431E+01, 3.1744950421E+01, 8.7319126980E+00, 9.5348703016E-01],
	[3.6320000000E+04, 7.8380016690E+01, 1.4232907959E+01, 3.1759183275E+01, 8.7332415022E+00, 9.5350825326E-01],
	[3.6325000000E+04, 7.8398531017E+01, 1.4232967478E+01, 3.1773420548E+01, 8.7345699907E+00, 9.5352946574E-01],
	[3.6330000000E+04, 7.8417047168E+01, 1.4233026990E+01, 3.1787662240E+01, 8.7358981636E+00, 9.5355066761E-01],
	[3.6335000000E+04, 7.8435565143E+01, 1.4233086494E+01, 3.1801908351E+01, 8.7372260209E+00, 9.5357185886E-01],
	[3.6340000000E+04, 7.8454084942E+01, 1.4233145990E+01, 3.1816158884E+01, 8.7385535626E+00, 9.5359303951E-01],
	[3.6345000000E+04, 7.8472606565E+01, 1.4233205479E+01, 3.1830413838E+01, 8.7398807887E+00, 9.5361420956E-01],
	[3.6350000000E+04, 7.8491130012E+01, 1.4233264959E+01, 3.1844673214E+01, 8.7412076994E+00, 9.5363536902E-01],
	[3.6355000000E+04, 7.8509655283E+01, 1.4233324431E+01, 3.1858937013E+01, 8.7425342946E+00, 9.5365651790E-01],
	[3.6360000000E+04, 7.8528182378E+01, 1.4233383895E+01, 3.1873205236E+01, 8.7438605743E+00, 9.5367765619E-01],
	[3.6365000000E+04, 7.8546711296E+01, 1.4233443352E+01, 3.1887477883E+01, 8.7451865386E+00, 9.5369878390E-01],
	[3.6370000000E+04, 7.8565242038E+01, 1.4233502800E+01, 3.1901754956E+01, 8.7465121875E+00, 9.5371990104E-01],
	[3.6375000000E+04, 7.8583774603E+01, 1.4233562241E+01, 3.1916036455E+01, 8.7478375211E+00, 9.5374100762E-01],
	[3.6380000000E+04, 7.8602308992E+01, 1.4233621674E+01, 3.1930322380E+01, 8.7491625393E+00, 9.5376210364E-01],
	[3.6385000000E+04, 7.8620845204E+01, 1.4233681098E+01, 3.1944612733E+01, 8.7504872422E+00, 9.5378318910E-01],
	[3.6390000000E+04, 7.8639383239E+01, 1.4233740515E+01, 3.1958907515E+01, 8.7518116298E+00, 9.5380426402E-01],
	[3.6395000000E+04, 7.8657923098E+01, 1.4233799924E+01, 3.1973206725E+01, 8.7531357022E+00, 9.5382532839E-01],
	[3.6400000000E+04, 7.8676464780E+01, 1.4233859325E+01, 3.1987510366E+01, 8.7544594593E+00, 9.5384638222E-01],
	[3.6405000000E+04, 7.8695008284E+01, 1.4233918718E+01, 3.2001818437E+01, 8.7557829013E+00, 9.5386742552E-01],
	[3.6410000000E+04, 7.8713553612E+01, 1.4233978103E+01, 3.2016130939E+01, 8.7571060281E+00, 9.5388845830E-01],
	[3.6415000000E+04, 7.8732100763E+01, 1.4234037480E+01, 3.2030447874E+01, 8.7584288398E+00, 9.5390948055E-01],
	[3.6420000000E+04, 7.8750649737E+01, 1.4234096850E+01, 3.2044769241E+01, 8.7597513364E+00, 9.5393049229E-01],
	[3.6425000000E+04, 7.8769200533E+01, 1.4234156211E+01, 3.2059095042E+01, 8.7610735179E+00, 9.5395149351E-01],
	[3.6430000000E+04, 7.8787753153E+01, 1.4234215565E+01, 3.2073425278E+01, 8.7623953844E+00, 9.5397248424E-01],
	[3.6435000000E+04, 7.8806307594E+01, 1.4234274910E+01, 3.2087759949E+01, 8.7637169359E+00, 9.5399346446E-01],
	[3.6440000000E+04, 7.8824863859E+01, 1.4234334248E+01, 3.2102099055E+01, 8.7650381724E+00, 9.5401443419E-01],
	[3.6445000000E+04, 7.8843421946E+01, 1.4234393578E+01, 3.2116442599E+01, 8.7663590939E+00, 9.5403539343E-01],
	[3.6450000000E+04, 7.8861981855E+01, 1.4234452900E+01, 3.2130790580E+01, 8.7676797006E+00, 9.5405634218E-01],
	[3.6455000000E+04, 7.8880543587E+01, 1.4234512214E+01, 3.2145142999E+01, 8.7689999923E+00, 9.5407728046E-01],
	[3.6460000000E+04, 7.8899107141E+01, 1.4234571520E+01, 3.2159499857E+01, 8.7703199692E+00, 9.5409820827E-01],
	[3.6465000000E+04, 7.8917672518E+01, 1.4234630818E+01, 3.2173861155E+01, 8.7716396313E+00, 9.5411912561E-01],
	[3.6470000000E+04, 7.8936239716E+01, 1.4234690109E+01, 3.2188226894E+01, 8.7729589785E+00, 9.5414003249E-01],
	[3.6475000000E+04, 7.8954808737E+01, 1.4234749391E+01, 3.2202597073E+01, 8.7742780110E+00, 9.5416092892E-01],
	[3.6480000000E+04, 7.8973379580E+01, 1.4234808666E+01, 3.2216971695E+01, 8.7755967288E+00, 9.5418181489E-01],
	[3.6485000000E+04, 7.8991952244E+01, 1.4234867933E+01, 3.2231350760E+01, 8.7769151318E+00, 9.5420269042E-01],
	[3.6490000000E+04, 7.9010526731E+01, 1.4234927192E+01, 3.2245734268E+01, 8.7782332202E+00, 9.5422355551E-01],
	[3.6495000000E+04, 7.9029103039E+01, 1.4234986443E+01, 3.2260122221E+01, 8.7795509940E+00, 9.5424441017E-01],
	[3.6500000000E+04, 7.9047681169E+01, 1.4235045686E+01, 3.2274514618E+01, 8.7808684531E+00, 9.5426525440E-01],
	[3.6505000000E+04, 7.9066261121E+01, 1.4235104921E+01, 3.2288911462E+01, 8.7821855976E+00, 9.5428608820E-01],
	[3.6510000000E+04, 7.9084842894E+01, 1.4235164149E+01, 3.2303312752E+01, 8.7835024276E+00, 9.5430691159E-01],
	[3.6515000000E+04, 7.9103426489E+01, 1.4235223368E+01, 3.2317718490E+01, 8.7848189431E+00, 9.5432772457E-01],
	[3.6520000000E+04, 7.9122011905E+01, 1.4235282580E+01, 3.2332128675E+01, 8.7861351441E+00, 9.5434852714E-01],
	[3.6525000000E+04, 7.9140599143E+01, 1.4235341784E+01, 3.2346543310E+01, 8.7874510306E+00, 9.5436931931E-01],
	[3.6530000000E+04, 7.9159188202E+01, 1.4235400980E+01, 3.2360962394E+01, 8.7887666027E+00, 9.5439010109E-01],
	[3.6535000000E+04, 7.9177779082E+01, 1.4235460168E+01, 3.2375385929E+01, 8.7900818604E+00, 9.5441087247E-01],
	[3.6540000000E+04, 7.9196371783E+01, 1.4235519348E+01, 3.2389813915E+01, 8.7913968037E+00, 9.5443163348E-01],
	[3.6545000000E+04, 7.9214966306E+01, 1.4235578520E+01, 3.2404246353E+01, 8.7927114327E+00, 9.5445238410E-01],
	[3.6550000000E+04, 7.9233562649E+01, 1.4235637685E+01, 3.2418683244E+01, 8.7940257474E+00, 9.5447312435E-01],
	[3.6555000000E+04, 7.9252160814E+01, 1.4235696842E+01, 3.2433124588E+01, 8.7953397478E+00, 9.5449385423E-01],
	[3.6560000000E+04, 7.9270760799E+01, 1.4235755991E+01, 3.2447570387E+01, 8.7966534340E+00, 9.5451457375E-01],
	[3.6565000000E+04, 7.9289362605E+01, 1.4235815132E+01, 3.2462020641E+01, 8.7979668059E+00, 9.5453528291E-01],
	[3.6570000000E+04, 7.9307966232E+01, 1.4235874265E+01, 3.2476475350E+01, 8.7992798637E+00, 9.5455598172E-01],
	[3.6575000000E+04, 7.9326571680E+01, 1.4235933390E+01, 3.2490934516E+01, 8.8005926074E+00, 9.5457667018E-01],
	[3.6580000000E+04, 7.9345178948E+01, 1.4235992508E+01, 3.2505398139E+01, 8.8019050369E+00, 9.5459734830E-01],
	[3.6585000000E+04, 7.9363788037E+01, 1.4236051617E+01, 3.2519866220E+01, 8.8032171524E+00, 9.5461801609E-01],
	[3.6590000000E+04, 7.9382398946E+01, 1.4236110719E+01, 3.2534338761E+01, 8.8045289538E+00, 9.5463867355E-01],
	[3.6595000000E+04, 7.9401011675E+01, 1.4236169813E+01, 3.2548815760E+01, 8.8058404411E+00, 9.5465932068E-01],
	[3.6600000000E+04, 7.9419626225E+01, 1.4236228899E+01, 3.2563297221E+01, 8.8071516145E+00, 9.5467995750E-01],
	[3.6605000000E+04, 7.9438242596E+01, 1.4236287978E+01, 3.2577783142E+01, 8.8084624740E+00, 9.5470058400E-01],
	[3.6610000000E+04, 7.9456860786E+01, 1.4236347048E+01, 3.2592273525E+01, 8.8097730195E+00, 9.5472120019E-01],
	[3.6615000000E+04, 7.9475480796E+01, 1.4236406111E+01, 3.2606768371E+01, 8.8110832511E+00, 9.5474180608E-01],
	[3.6620000000E+04, 7.9494102627E+01, 1.4236465166E+01, 3.2621267680E+01, 8.8123931688E+00, 9.5476240167E-01],
	[3.6625000000E+04, 7.9512726277E+01, 1.4236524213E+01, 3.2635771454E+01, 8.8137027728E+00, 9.5478298698E-01],
	[3.6630000000E+04, 7.9531351748E+01, 1.4236583252E+01, 3.2650279692E+01, 8.8150120629E+00, 9.5480356199E-01],
	[3.6635000000E+04, 7.9549979038E+01, 1.4236642284E+01, 3.2664792397E+01, 8.8163210393E+00, 9.5482412673E-01],
	[3.6640000000E+04, 7.9568608148E+01, 1.4236701307E+01, 3.2679309567E+01, 8.8176297019E+00, 9.5484468119E-01],
	[3.6645000000E+04, 7.9587239077E+01, 1.4236760323E+01, 3.2693831205E+01, 8.8189380508E+00, 9.5486522538E-01],
	[3.6650000000E+04, 7.9605871827E+01, 1.4236819331E+01, 3.2708357311E+01, 8.8202460861E+00, 9.5488575930E-01],
	[3.6655000000E+04, 7.9624506395E+01, 1.4236878331E+01, 3.2722887886E+01, 8.8215538078E+00, 9.5490628297E-01],
	[3.6660000000E+04, 7.9643142784E+01, 1.4236937324E+01, 3.2737422930E+01, 8.8228612158E+00, 9.5492679638E-01],
	[3.6665000000E+04, 7.9661780991E+01, 1.4236996308E+01, 3.2751962445E+01, 8.8241683102E+00, 9.5494729955E-01],
	[3.6670000000E+04, 7.9680421018E+01, 1.4237055285E+01, 3.2766506430E+01, 8.8254750912E+00, 9.5496779247E-01],
	[3.6675000000E+04, 7.9699062865E+01, 1.4237114254E+01, 3.2781054888E+01, 8.8267815586E+00, 9.5498827515E-01],
	[3.6680000000E+04, 7.9717706530E+01, 1.4237173216E+01, 3.2795607818E+01, 8.8280877125E+00, 9.5500874761E-01],
	[3.6685000000E+04, 7.9736352015E+01, 1.4237232169E+01, 3.2810165221E+01, 8.8293935531E+00, 9.5502920983E-01],
	[3.6690000000E+04, 7.9754999318E+01, 1.4237291115E+01, 3.2824727099E+01, 8.8306990802E+00, 9.5504966184E-01],
	[3.6695000000E+04, 7.9773648441E+01, 1.4237350052E+01, 3.2839293451E+01, 8.8320042939E+00, 9.5507010363E-01],
	[3.6700000000E+04, 7.9792299382E+01, 1.4237408983E+01, 3.2853864279E+01, 8.8333091943E+00, 9.5509053521E-01],
	[3.6705000000E+04, 7.9810952143E+01, 1.4237467905E+01, 3.2868439584E+01, 8.8346137814E+00, 9.5511095658E-01],
	[3.6710000000E+04, 7.9829606722E+01, 1.4237526819E+01, 3.2883019365E+01, 8.8359180552E+00, 9.5513136776E-01],
	[3.6715000000E+04, 7.9848263120E+01, 1.4237585726E+01, 3.2897603625E+01, 8.8372220157E+00, 9.5515176874E-01],
	[3.6720000000E+04, 7.9866921336E+01, 1.4237644625E+01, 3.2912192363E+01, 8.8385256631E+00, 9.5517215954E-01],
	[3.6725000000E+04, 7.9885581371E+01, 1.4237703516E+01, 3.2926785581E+01, 8.8398289972E+00, 9.5519254015E-01],
	[3.6730000000E+04, 7.9904243225E+01, 1.4237762400E+01, 3.2941383279E+01, 8.8411320183E+00, 9.5521291058E-01],
	[3.6735000000E+04, 7.9922906896E+01, 1.4237821275E+01, 3.2955985458E+01, 8.8424347262E+00, 9.5523327084E-01],
	[3.6740000000E+04, 7.9941572387E+01, 1.4237880143E+01, 3.2970592119E+01, 8.8437371210E+00, 9.5525362094E-01],
	[3.6745000000E+04, 7.9960239695E+01, 1.4237939003E+01, 3.2985203262E+01, 8.8450392029E+00, 9.5527396087E-01],
	[3.6750000000E+04, 7.9978908822E+01, 1.4237997855E+01, 3.2999818889E+01, 8.8463409716E+00, 9.5529429065E-01],
	[3.6755000000E+04, 7.9997579767E+01, 1.4238056700E+01, 3.3014439000E+01, 8.8476424275E+00, 9.5531461027E-01],
	[3.6760000000E+04, 8.0016252530E+01, 1.4238115537E+01, 3.3029063595E+01, 8.8489435703E+00, 9.5533491975E-01],
	[3.6765000000E+04, 8.0034927111E+01, 1.4238174366E+01, 3.3043692676E+01, 8.8502444003E+00, 9.5535521910E-01],
	[3.6770000000E+04, 8.0053603510E+01, 1.4238233187E+01, 3.3058326244E+01, 8.8515449174E+00, 9.5537550830E-01],
	[3.6775000000E+04, 8.0072281726E+01, 1.4238292001E+01, 3.3072964298E+01, 8.8528451216E+00, 9.5539578738E-01],
	[3.6780000000E+04, 8.0090961761E+01, 1.4238350806E+01, 3.3087606841E+01, 8.8541450131E+00, 9.5541605634E-01],
	[3.6785000000E+04, 8.0109643613E+01, 1.4238409604E+01, 3.3102253872E+01, 8.8554445917E+00, 9.5543631517E-01],
	[3.6790000000E+04, 8.0128327283E+01, 1.4238468395E+01, 3.3116905392E+01, 8.8567438576E+00, 9.5545656390E-01],
	[3.6795000000E+04, 8.0147012770E+01, 1.4238527177E+01, 3.3131561403E+01, 8.8580428108E+00, 9.5547680251E-01],
	[3.6800000000E+04, 8.0165700075E+01, 1.4238585952E+01, 3.3146221905E+01, 8.8593414514E+00, 9.5549703103E-01],
	[3.6805000000E+04, 8.0184389198E+01, 1.4238644719E+01, 3.3160886898E+01, 8.8606397793E+00, 9.5551724945E-01],
	[3.6810000000E+04, 8.0203094186E+01, 1.4238705368E+01, 3.3175556384E+01, 8.8619386979E+00, 9.5553745778E-01],
	[3.6815000000E+04, 8.0221837263E+01, 1.4238770884E+01, 3.3190230363E+01, 8.8632396365E+00, 9.5555765602E-01],
	[3.6820000000E+04, 8.0240582174E+01, 1.4238836393E+01, 3.3204908836E+01, 8.8645402636E+00, 9.5557784418E-01],
	[3.6825000000E+04, 8.0259328919E+01, 1.4238901892E+01, 3.3219591803E+01, 8.8658405793E+00, 9.5559802227E-01],
	[3.6830000000E+04, 8.0278077498E+01, 1.4238967384E+01, 3.3234279267E+01, 8.8671405838E+00, 9.5561819028E-01],
	[3.6835000000E+04, 8.0296827910E+01, 1.4239032866E+01, 3.3248971226E+01, 8.8684402769E+00, 9.5563834824E-01],
	[3.6840000000E+04, 8.0315580156E+01, 1.4239098340E+01, 3.3263667683E+01, 8.8697396588E+00, 9.5565849613E-01],
	[3.6845000000E+04, 8.0334334235E+01, 1.4239163805E+01, 3.3278368637E+01, 8.8710387295E+00, 9.5567863397E-01],
	[3.6850000000E+04, 8.0353090148E+01, 1.4239229262E+01, 3.3293074090E+01, 8.8723374890E+00, 9.5569876176E-01],
	[3.6855000000E+04, 8.0371847894E+01, 1.4239294710E+01, 3.3307784043E+01, 8.8736359373E+00, 9.5571887951E-01],
	[3.6860000000E+04, 8.0390607473E+01, 1.4239360150E+01, 3.3322498495E+01, 8.8749340746E+00, 9.5573898723E-01],
	[3.6865000000E+04, 8.0409368886E+01, 1.4239425581E+01, 3.3337217449E+01, 8.8762319007E+00, 9.5575908491E-01],
	[3.6870000000E+04, 8.0428132132E+01, 1.4239491003E+01, 3.3351940904E+01, 8.8775294157E+00, 9.5577917256E-01],
	[3.6875000000E+04, 8.0446897211E+01, 1.4239556417E+01, 3.3366668861E+01, 8.8788266198E+00, 9.5579925019E-01],
	[3.6880000000E+04, 8.0465664123E+01, 1.4239621823E+01, 3.3381401322E+01, 8.8801235129E+00, 9.5581931781E-01],
	[3.6885000000E+04, 8.0484432868E+01, 1.4239687219E+01, 3.3396138286E+01, 8.8814200950E+00, 9.5583937541E-01],
	[3.6890000000E+04, 8.0503203446E+01, 1.4239752607E+01, 3.3410879756E+01, 8.8827163662E+00, 9.5585942301E-01],
	[3.6895000000E+04, 8.0521975856E+01, 1.4239817987E+01, 3.3425625730E+01, 8.8840123265E+00, 9.5587946060E-01],
	[3.6900000000E+04, 8.0540750100E+01, 1.4239883358E+01, 3.3440376211E+01, 8.8853079760E+00, 9.5589948820E-01],
	[3.6905000000E+04, 8.0559526176E+01, 1.4239948721E+01, 3.3455131199E+01, 8.8866033146E+00, 9.5591950580E-01],
	[3.6910000000E+04, 8.0578304085E+01, 1.4240014075E+01, 3.3469890695E+01, 8.8878983425E+00, 9.5593951342E-01],
	[3.6915000000E+04, 8.0597083826E+01, 1.4240079420E+01, 3.3484654699E+01, 8.8891930597E+00, 9.5595951105E-01],
	[3.6920000000E+04, 8.0615865400E+01, 1.4240144757E+01, 3.3499423213E+01, 8.8904874661E+00, 9.5597949870E-01],
	[3.6925000000E+04, 8.0634648806E+01, 1.4240210085E+01, 3.3514196236E+01, 8.8917815618E+00, 9.5599947638E-01],
	[3.6930000000E+04, 8.0653434045E+01, 1.4240275405E+01, 3.3528973771E+01, 8.8930753469E+00, 9.5601944409E-01],
	[3.6935000000E+04, 8.0672221116E+01, 1.4240340716E+01, 3.3543755817E+01, 8.8943688214E+00, 9.5603940184E-01],
	[3.6940000000E+04, 8.0691010019E+01, 1.4240406019E+01, 3.3558542375E+01, 8.8956619854E+00, 9.5605934963E-01],
	[3.6945000000E+04, 8.0709800754E+01, 1.4240471313E+01, 3.3573333447E+01, 8.8969548388E+00, 9.5607928747E-01],
	[3.6950000000E+04, 8.0728593321E+01, 1.4240536598E+01, 3.3588129032E+01, 8.8982473816E+00, 9.5609921536E-01],
	[3.6955000000E+04, 8.0747387720E+01, 1.4240601875E+01, 3.3602929132E+01, 8.8995396141E+00, 9.5611913330E-01],
	[3.6960000000E+04, 8.0766183951E+01, 1.4240667144E+01, 3.3617733748E+01, 8.9008315361E+00, 9.5613904131E-01],
	[3.6965000000E+04, 8.0784982014E+01, 1.4240732404E+01, 3.3632542879E+01, 8.9021231476E+00, 9.5615893938E-01],
	[3.6970000000E+04, 8.0803781909E+01, 1.4240797655E+01, 3.3647356528E+01, 8.9034144489E+00, 9.5617882752E-01],
	[3.6975000000E+04, 8.0822583636E+01, 1.4240862898E+01, 3.3662174694E+01, 8.9047054398E+00, 9.5619870573E-01],
	[3.6980000000E+04, 8.0841387194E+01, 1.4240928133E+01, 3.3676997379E+01, 8.9059961204E+00, 9.5621857403E-01],
	[3.6985000000E+04, 8.0860192584E+01, 1.4240993359E+01, 3.3691824583E+01, 8.9072864907E+00, 9.5623843241E-01],
	[3.6990000000E+04, 8.0878999805E+01, 1.4241058576E+01, 3.3706656307E+01, 8.9085765508E+00, 9.5625828088E-01],
	[3.6995000000E+04, 8.0897808858E+01, 1.4241123785E+01, 3.3721492552E+01, 8.9098663008E+00, 9.5627811945E-01],
	[3.7000000000E+04, 8.0916619742E+01, 1.4241188985E+01, 3.3736333318E+01, 8.9111557406E+00, 9.5629794812E-01],
	[3.7005000000E+04, 8.0935432457E+01, 1.4241254177E+01, 3.3751178607E+01, 8.9124448702E+00, 9.5631776689E-01],
	[3.7010000000E+04, 8.0954247004E+01, 1.4241319360E+01, 3.3766028419E+01, 8.9137336898E+00, 9.5633757577E-01],
	[3.7015000000E+04, 8.0973063382E+01, 1.4241384535E+01, 3.3780882754E+01, 8.9150221993E+00, 9.5635737477E-01],
	[3.7020000000E+04, 8.0991881590E+01, 1.4241449702E+01, 3.3795741614E+01, 8.9163103989E+00, 9.5637716388E-01],
	[3.7025000000E+04, 8.1010701630E+01, 1.4241514859E+01, 3.3810605000E+01, 8.9175982884E+00, 9.5639694312E-01],
	[3.7030000000E+04, 8.1029523501E+01, 1.4241580009E+01, 3.3825472912E+01, 8.9188858680E+00, 9.5641671249E-01],
	[3.7035000000E+04, 8.1048347203E+01, 1.4241645149E+01, 3.3840345350E+01, 8.9201731377E+00, 9.5643647199E-01],
	[3.7040000000E+04, 8.1067172735E+01, 1.4241710282E+01, 3.3855222316E+01, 8.9214600976E+00, 9.5645622163E-01],
	[3.7045000000E+04, 8.1086000099E+01, 1.4241775406E+01, 3.3870103811E+01, 8.9227467476E+00, 9.5647596142E-01],
	[3.7050000000E+04, 8.1104829293E+01, 1.4241840521E+01, 3.3884989835E+01, 8.9240330878E+00, 9.5649569135E-01],
	[3.7055000000E+04, 8.1123660317E+01, 1.4241905628E+01, 3.3899880389E+01, 8.9253191182E+00, 9.5651541144E-01],
	[3.7060000000E+04, 8.1142493172E+01, 1.4241970726E+01, 3.3914775473E+01, 8.9266048389E+00, 9.5653512169E-01],
	[3.7065000000E+04, 8.1161327858E+01, 1.4242035816E+01, 3.3929675089E+01, 8.9278902500E+00, 9.5655482210E-01],
	[3.7070000000E+04, 8.1180164374E+01, 1.4242100897E+01, 3.3944579238E+01, 8.9291753513E+00, 9.5657451267E-01],
	[3.7075000000E+04, 8.1199002720E+01, 1.4242165970E+01, 3.3959487919E+01, 8.9304601431E+00, 9.5659419342E-01],
	[3.7080000000E+04, 8.1217842897E+01, 1.4242231035E+01, 3.3974401134E+01, 8.9317446253E+00, 9.5661386435E-01],
	[3.7085000000E+04, 8.1236684904E+01, 1.4242296091E+01, 3.3989318884E+01, 8.9330287979E+00, 9.5663352546E-01],
	[3.7090000000E+04, 8.1255528741E+01, 1.4242361138E+01, 3.4004241169E+01, 8.9343126610E+00, 9.5665317676E-01],
	[3.7095000000E+04, 8.1274374408E+01, 1.4242426177E+01, 3.4019167990E+01, 8.9355962147E+00, 9.5667281825E-01],
	[3.7100000000E+04, 8.1293221905E+01, 1.4242491208E+01, 3.4034099348E+01, 8.9368794589E+00, 9.5669244994E-01],
	[3.7105000000E+04, 8.1312071232E+01, 1.4242556230E+01, 3.4049035244E+01, 8.9381623937E+00, 9.5671207183E-01],
	[3.7110000000E+04, 8.1330922389E+01, 1.4242621243E+01, 3.4063975678E+01, 8.9394450191E+00, 9.5673168393E-01],
	[3.7115000000E+04, 8.1349775375E+01, 1.4242686249E+01, 3.4078920651E+01, 8.9407273352E+00, 9.5675128624E-01],
	[3.7120000000E+04, 8.1368630191E+01, 1.4242751245E+01, 3.4093870164E+01, 8.9420093420E+00, 9.5677087876E-01],
	[3.7125000000E+04, 8.1387486837E+01, 1.4242816233E+01, 3.4108824218E+01, 8.9432910396E+00, 9.5679046151E-01],
	[3.7130000000E+04, 8.1406345313E+01, 1.4242881213E+01, 3.4123782813E+01, 8.9445724279E+00, 9.5681003448E-01],
	[3.7135000000E+04, 8.1425205618E+01, 1.4242946185E+01, 3.4138745950E+01, 8.9458535071E+00, 9.5682959769E-01],
	[3.7140000000E+04, 8.1444067752E+01, 1.4243011147E+01, 3.4153713631E+01, 8.9471342771E+00, 9.5684915113E-01],
	[3.7145000000E+04, 8.1462931716E+01, 1.4243076102E+01, 3.4168685855E+01, 8.9484147380E+00, 9.5686869482E-01],
	[3.7150000000E+04, 8.1481797509E+01, 1.4243141048E+01, 3.4183662624E+01, 8.9496948898E+00, 9.5688822875E-01],
	[3.7155000000E+04, 8.1500665132E+01, 1.4243205985E+01, 3.4198643938E+01, 8.9509747326E+00, 9.5690775293E-01],
	[3.7160000000E+04, 8.1519534583E+01, 1.4243270914E+01, 3.4213629798E+01, 8.9522542664E+00, 9.5692726736E-01],
	[3.7165000000E+04, 8.1538405864E+01, 1.4243335835E+01, 3.4228620205E+01, 8.9535334912E+00, 9.5694677206E-01],
	[3.7170000000E+04, 8.1557278973E+01, 1.4243400747E+01, 3.4243615159E+01, 8.9548124071E+00, 9.5696626702E-01],
	[3.7175000000E+04, 8.1576153912E+01, 1.4243465651E+01, 3.4258614662E+01, 8.9560910141E+00, 9.5698575225E-01],
	[3.7180000000E+04, 8.1595030679E+01, 1.4243530546E+01, 3.4273618714E+01, 8.9573693122E+00, 9.5700522776E-01],
	[3.7185000000E+04, 8.1613909276E+01, 1.4243595433E+01, 3.4288627316E+01, 8.9586473016E+00, 9.5702469355E-01],
	[3.7190000000E+04, 8.1632789701E+01, 1.4243660312E+01, 3.4303640468E+01, 8.9599249821E+00, 9.5704414962E-01],
	[3.7195000000E+04, 8.1651671954E+01, 1.4243725182E+01, 3.4318658172E+01, 8.9612023539E+00, 9.5706359598E-01],
	[3.7200000000E+04, 8.1670556037E+01, 1.4243790043E+01, 3.4333680428E+01, 8.9624794171E+00, 9.5708303264E-01],
	[3.7205000000E+04, 8.1689441948E+01, 1.4243854897E+01, 3.4348707237E+01, 8.9637561715E+00, 9.5710245959E-01],
	[3.7210000000E+04, 8.1708329687E+01, 1.4243919741E+01, 3.4363738600E+01, 8.9650326173E+00, 9.5712187686E-01],
	[3.7215000000E+04, 8.1727219255E+01, 1.4243984578E+01, 3.4378774517E+01, 8.9663087545E+00, 9.5714128443E-01],
	[3.7220000000E+04, 8.1746110651E+01, 1.4244049406E+01, 3.4393814990E+01, 8.9675845832E+00, 9.5716068231E-01],
	[3.7225000000E+04, 8.1765003875E+01, 1.4244114225E+01, 3.4408860018E+01, 8.9688601033E+00, 9.5718007051E-01],
	[3.7230000000E+04, 8.1783898928E+01, 1.4244179036E+01, 3.4423909604E+01, 8.9701353150E+00, 9.5719944904E-01],
	[3.7235000000E+04, 8.1802795808E+01, 1.4244243839E+01, 3.4438963746E+01, 8.9714102182E+00, 9.5721881790E-01],
	[3.7240000000E+04, 8.1821694517E+01, 1.4244308633E+01, 3.4454022448E+01, 8.9726848130E+00, 9.5723817708E-01],
	[3.7245000000E+04, 8.1840595054E+01, 1.4244373419E+01, 3.4469085708E+01, 8.9739590995E+00, 9.5725752661E-01],
	[3.7250000000E+04, 8.1859497419E+01, 1.4244438197E+01, 3.4484153528E+01, 8.9752330776E+00, 9.5727686648E-01],
	[3.7255000000E+04, 8.1878401611E+01, 1.4244502966E+01, 3.4499225909E+01, 8.9765067474E+00, 9.5729619670E-01],
	[3.7260000000E+04, 8.1897307631E+01, 1.4244567727E+01, 3.4514302851E+01, 8.9777801090E+00, 9.5731551727E-01],
	[3.7265000000E+04, 8.1916215480E+01, 1.4244632479E+01, 3.4529384355E+01, 8.9790531623E+00, 9.5733482820E-01],
	[3.7270000000E+04, 8.1935125155E+01, 1.4244697223E+01, 3.4544470422E+01, 8.9803259075E+00, 9.5735412950E-01],
	[3.7275000000E+04, 8.1954036659E+01, 1.4244761958E+01, 3.4559561053E+01, 8.9815983445E+00, 9.5737342116E-01],
	[3.7280000000E+04, 8.1972949989E+01, 1.4244826686E+01, 3.4574656248E+01, 8.9828704734E+00, 9.5739270319E-01],
	[3.7285000000E+04, 8.1991865148E+01, 1.4244891404E+01, 3.4589756009E+01, 8.9841422942E+00, 9.5741197560E-01],
	[3.7290000000E+04, 8.2010782133E+01, 1.4244956115E+01, 3.4604860335E+01, 8.9854138071E+00, 9.5743123839E-01],
	[3.7295000000E+04, 8.2029700946E+01, 1.4245020817E+01, 3.4619969229E+01, 8.9866850119E+00, 9.5745049157E-01],
	[3.7300000000E+04, 8.2048621586E+01, 1.4245085510E+01, 3.4635082690E+01, 8.9879559088E+00, 9.5746973514E-01],
	[3.7305000000E+04, 8.2067544054E+01, 1.4245150195E+01, 3.4650200719E+01, 8.9892264977E+00, 9.5748896911E-01],
	[3.7310000000E+04, 8.2086468348E+01, 1.4245214872E+01, 3.4665323317E+01, 8.9904967788E+00, 9.5750819347E-01],
	[3.7315000000E+04, 8.2105394470E+01, 1.4245279541E+01, 3.4680450485E+01, 8.9917667520E+00, 9.5752740825E-01],
	[3.7320000000E+04, 8.2124322418E+01, 1.4245344201E+01, 3.4695582223E+01, 8.9930364175E+00, 9.5754661344E-01],
	[3.7325000000E+04, 8.2143252193E+01, 1.4245408853E+01, 3.4710718533E+01, 8.9943057751E+00, 9.5756580904E-01],
	[3.7330000000E+04, 8.2162183796E+01, 1.4245473496E+01, 3.4725859415E+01, 8.9955748251E+00, 9.5758499506E-01],
	[3.7335000000E+04, 8.2181117225E+01, 1.4245538131E+01, 3.4741004870E+01, 8.9968435674E+00, 9.5760417151E-01],
	[3.7340000000E+04, 8.2200052480E+01, 1.4245602758E+01, 3.4756154899E+01, 8.9981120020E+00, 9.5762333839E-01],
	[3.7345000000E+04, 8.2218989562E+01, 1.4245667376E+01, 3.4771309502E+01, 8.9993801290E+00, 9.5764249570E-01],
	[3.7350000000E+04, 8.2237928471E+01, 1.4245731986E+01, 3.4786468680E+01, 9.0006479484E+00, 9.5766164346E-01],
	[3.7355000000E+04, 8.2256869207E+01, 1.4245796587E+01, 3.4801632434E+01, 9.0019154603E+00, 9.5768078166E-01],
	[3.7360000000E+04, 8.2275811768E+01, 1.4245861181E+01, 3.4816800765E+01, 9.0031826647E+00, 9.5769991031E-01],
	[3.7365000000E+04, 8.2294756156E+01, 1.4245925766E+01, 3.4831973674E+01, 9.0044495617E+00, 9.5771902942E-01],
	[3.7370000000E+04, 8.2313702371E+01, 1.4245990342E+01, 3.4847151161E+01, 9.0057161512E+00, 9.5773813898E-01],
	[3.7375000000E+04, 8.2332650411E+01, 1.4246054910E+01, 3.4862333226E+01, 9.0069824334E+00, 9.5775723901E-01],
	[3.7380000000E+04, 8.2351600278E+01, 1.4246119470E+01, 3.4877519872E+01, 9.0082484082E+00, 9.5777632951E-01],
	[3.7385000000E+04, 8.2370551971E+01, 1.4246184022E+01, 3.4892711098E+01, 9.0095140757E+00, 9.5779541048E-01],
	[3.7390000000E+04, 8.2389505490E+01, 1.4246248565E+01, 3.4907906905E+01, 9.0107794360E+00, 9.5781448193E-01],
	[3.7395000000E+04, 8.2408460834E+01, 1.4246313100E+01, 3.4923107295E+01, 9.0120444890E+00, 9.5783354387E-01],
	[3.7400000000E+04, 8.2427418005E+01, 1.4246377626E+01, 3.4938312267E+01, 9.0133092348E+00, 9.5785259629E-01],
	[3.7405000000E+04, 8.2446415040E+01, 1.4246447208E+01, 3.4953521823E+01, 9.0145761556E+00, 9.5787163921E-01],
	[3.7410000000E+04, 8.2465425562E+01, 1.4246518331E+01, 3.4968735964E+01, 9.0158435302E+00, 9.5789067263E-01],
	[3.7415000000E+04, 8.2484437927E+01, 1.4246589444E+01, 3.4983954690E+01, 9.0171105989E+00, 9.5790969655E-01],
	[3.7420000000E+04, 8.2503452134E+01, 1.4246660549E+01, 3.4999178001E+01, 9.0183773617E+00, 9.5792871098E-01],
	[3.7425000000E+04, 8.2522468182E+01, 1.4246731645E+01, 3.5014405899E+01, 9.0196438185E+00, 9.5794771592E-01],
	[3.7430000000E+04, 8.2541486072E+01, 1.4246802731E+01, 3.5029638385E+01, 9.0209099695E+00, 9.5796671138E-01],
	[3.7435000000E+04, 8.2560505804E+01, 1.4246873808E+01, 3.5044875459E+01, 9.0221758146E+00, 9.5798569736E-01],
	[3.7440000000E+04, 8.2579527377E+01, 1.4246944876E+01, 3.5060117122E+01, 9.0234413540E+00, 9.5800467387E-01],
	[3.7445000000E+04, 8.2598550792E+01, 1.4247015935E+01, 3.5075363375E+01, 9.0247065876E+00, 9.5802364091E-01],
	[3.7450000000E+04, 8.2617576048E+01, 1.4247086985E+01, 3.5090614218E+01, 9.0259715155E+00, 9.5804259849E-01],
	[3.7455000000E+04, 8.2636603146E+01, 1.4247158026E+01, 3.5105869653E+01, 9.0272361377E+00, 9.5806154661E-01],
	[3.7460000000E+04, 8.2655632085E+01, 1.4247229058E+01, 3.5121129680E+01, 9.0285004543E+00, 9.5808048527E-01],
	[3.7465000000E+04, 8.2674662865E+01, 1.4247300080E+01, 3.5136394299E+01, 9.0297644653E+00, 9.5809941449E-01],
	[3.7470000000E+04, 8.2693695486E+01, 1.4247371093E+01, 3.5151663513E+01, 9.0310281708E+00, 9.5811833427E-01],
	[3.7475000000E+04, 8.2712729949E+01, 1.4247442098E+01, 3.5166937320E+01, 9.0322915707E+00, 9.5813724461E-01],
	[3.7480000000E+04, 8.2731766252E+01, 1.4247513093E+01, 3.5182215723E+01, 9.0335546652E+00, 9.5815614551E-01],
	[3.7485000000E+04, 8.2750804396E+01, 1.4247584079E+01, 3.5197498722E+01, 9.0348174542E+00, 9.5817503698E-01],
	[3.7490000000E+04, 8.2769844382E+01, 1.4247655056E+01, 3.5212786317E+01, 9.0360799378E+00, 9.5819391903E-01],
	[3.7495000000E+04, 8.2788886208E+01, 1.4247726023E+01, 3.5228078510E+01, 9.0373421161E+00, 9.5821279166E-01],
	[3.7500000000E+04, 8.2807929875E+01, 1.4247796982E+01, 3.5243375301E+01, 9.0386039891E+00, 9.5823165488E-01],
	[3.7505000000E+04, 8.2826975382E+01, 1.4247867932E+01, 3.5258676691E+01, 9.0398655567E+00, 9.5825050868E-01],
	[3.7510000000E+04, 8.2846022731E+01, 1.4247938872E+01, 3.5273982681E+01, 9.0411268191E+00, 9.5826935308E-01],
	[3.7515000000E+04, 8.2865071919E+01, 1.4248009803E+01, 3.5289293271E+01, 9.0423877764E+00, 9.5828818808E-01],
	[3.7520000000E+04, 8.2884122948E+01, 1.4248080726E+01, 3.5304608463E+01, 9.0436484284E+00, 9.5830701369E-01],
	[3.7525000000E+04, 8.2903175818E+01, 1.4248151639E+01, 3.5319928257E+01, 9.0449087754E+00, 9.5832582990E-01],
	[3.7530000000E+04, 8.2922230528E+01, 1.4248222543E+01, 3.5335252653E+01, 9.0461688172E+00, 9.5834463673E-01],
	[3.7535000000E+04, 8.2941287078E+01, 1.4248293438E+01, 3.5350581654E+01, 9.0474285540E+00, 9.5836343418E-01],
	[3.7540000000E+04, 8.2960345469E+01, 1.4248364324E+01, 3.5365915258E+01, 9.0486879858E+00, 9.5838222225E-01],
	[3.7545000000E+04, 8.2979405700E+01, 1.4248435200E+01, 3.5381253468E+01, 9.0499471127E+00, 9.5840100095E-01],
	[3.7550000000E+04, 8.2998467770E+01, 1.4248506068E+01, 3.5396596284E+01, 9.0512059346E+00, 9.5841977029E-01],
	[3.7555000000E+04, 8.3017531681E+01, 1.4248576927E+01, 3.5411943706E+01, 9.0524644516E+00, 9.5843853026E-01],
	[3.7560000000E+04, 8.3036597432E+01, 1.4248647776E+01, 3.5427295736E+01, 9.0537226638E+00, 9.5845728088E-01],
	[3.7565000000E+04, 8.3055665023E+01, 1.4248718617E+01, 3.5442652374E+01, 9.0549805712E+00, 9.5847602214E-01],
	[3.7570000000E+04, 8.3074734453E+01, 1.4248789448E+01, 3.5458013621E+01, 9.0562381738E+00, 9.5849475406E-01],
	[3.7575000000E+04, 8.3093805723E+01, 1.4248860270E+01, 3.5473379477E+01, 9.0574954717E+00, 9.5851347663E-01],
	[3.7580000000E+04, 8.3112878833E+01, 1.4248931084E+01, 3.5488749945E+01, 9.0587524649E+00, 9.5853218987E-01],
	[3.7585000000E+04, 8.3131953782E+01, 1.4249001888E+01, 3.5504125023E+01, 9.0600091534E+00, 9.5855089378E-01],
	[3.7590000000E+04, 8.3151030571E+01, 1.4249072683E+01, 3.5519504714E+01, 9.0612655373E+00, 9.5856958835E-01],
	[3.7595000000E+04, 8.3170109200E+01, 1.4249143469E+01, 3.5534889017E+01, 9.0625216167E+00, 9.5858827361E-01],
	[3.7600000000E+04, 8.3189189668E+01, 1.4249214246E+01, 3.5550277934E+01, 9.0637773915E+00, 9.5860694955E-01],
	[3.7605000000E+04, 8.3208271975E+01, 1.4249285014E+01, 3.5565671466E+01, 9.0650328619E+00, 9.5862561617E-01],
	[3.7610000000E+04, 8.3227356122E+01, 1.4249355772E+01, 3.5581069612E+01, 9.0662880278E+00, 9.5864427348E-01],
	[3.7615000000E+04, 8.3246442107E+01, 1.4249426522E+01, 3.5596472375E+01, 9.0675428893E+00, 9.5866292149E-01],
	[3.7620000000E+04, 8.3265529932E+01, 1.4249497263E+01, 3.5611879754E+01, 9.0687974464E+00, 9.5868156020E-01],
	[3.7625000000E+04, 8.3284619596E+01, 1.4249567995E+01, 3.5627291750E+01, 9.0700516992E+00, 9.5870018962E-01],
	[3.7630000000E+04, 8.3303711099E+01, 1.4249638717E+01, 3.5642708365E+01, 9.0713056477E+00, 9.5871880975E-01],
	[3.7635000000E+04, 8.3322804441E+01, 1.4249709431E+01, 3.5658129599E+01, 9.0725592920E+00, 9.5873742059E-01],
	[3.7640000000E+04, 8.3341899622E+01, 1.4249780135E+01, 3.5673555452E+01, 9.0738126320E+00, 9.5875602216E-01],
	[3.7645000000E+04, 8.3360996641E+01, 1.4249850831E+01, 3.5688985926E+01, 9.0750656679E+00, 9.5877461445E-01],
	[3.7650000000E+04, 8.3380095500E+01, 1.4249921517E+01, 3.5704421022E+01, 9.0763183997E+00, 9.5879319746E-01],
	[3.7655000000E+04, 8.3399196197E+01, 1.4249992195E+01, 3.5719860739E+01, 9.0775708274E+00, 9.5881177122E-01],
	[3.7660000000E+04, 8.3418298732E+01, 1.4250062863E+01, 3.5735305079E+01, 9.0788229510E+00, 9.5883033571E-01],
	[3.7665000000E+04, 8.3437403106E+01, 1.4250133523E+01, 3.5750754043E+01, 9.0800747706E+00, 9.5884889095E-01],
	[3.7670000000E+04, 8.3456509319E+01, 1.4250204173E+01, 3.5766207631E+01, 9.0813262863E+00, 9.5886743693E-01],
	[3.7675000000E+04, 8.3475617370E+01, 1.4250274814E+01, 3.5781665844E+01, 9.0825774980E+00, 9.5888597367E-01],
	[3.7680000000E+04, 8.3494727259E+01, 1.4250345447E+01, 3.5797128683E+01, 9.0838284059E+00, 9.5890450117E-01],
	[3.7685000000E+04, 8.3513838987E+01, 1.4250416070E+01, 3.5812596149E+01, 9.0850790099E+00, 9.5892301943E-01],
	[3.7690000000E+04, 8.3532952553E+01, 1.4250486684E+01, 3.5828068242E+01, 9.0863293101E+00, 9.5894152847E-01],
	[3.7695000000E+04, 8.3552067957E+01, 1.4250557289E+01, 3.5843544964E+01, 9.0875793066E+00, 9.5896002827E-01],
	[3.7700000000E+04, 8.3571185199E+01, 1.4250627886E+01, 3.5859026314E+01, 9.0888289993E+00, 9.5897851885E-01],
	[3.7705000000E+04, 8.3590304279E+01, 1.4250698473E+01, 3.5874512294E+01, 9.0900783884E+00, 9.5899700021E-01],
	[3.7710000000E+04, 8.3609425197E+01, 1.4250769051E+01, 3.5890002905E+01, 9.0913274738E+00, 9.5901547237E-01],
	[3.7715000000E+04, 8.3628547953E+01, 1.4250839620E+01, 3.5905498147E+01, 9.0925762556E+00, 9.5903393531E-01],
	[3.7720000000E+04, 8.3647672546E+01, 1.4250910180E+01, 3.5920998021E+01, 9.0938247338E+00, 9.5905238905E-01],
	[3.7725000000E+04, 8.3666798978E+01, 1.4250980732E+01, 3.5936502528E+01, 9.0950729086E+00, 9.5907083359E-01],
	[3.7730000000E+04, 8.3685927247E+01, 1.4251051274E+01, 3.5952011668E+01, 9.0963207799E+00, 9.5908926894E-01],
	[3.7735000000E+04, 8.3705057353E+01, 1.4251121807E+01, 3.5967525443E+01, 9.0975683477E+00, 9.5910769510E-01],
	[3.7740000000E+04, 8.3724189297E+01, 1.4251192331E+01, 3.5983043853E+01, 9.0988156121E+00, 9.5912611208E-01],
	[3.7745000000E+04, 8.3743323079E+01, 1.4251262846E+01, 3.5998566899E+01, 9.1000625732E+00, 9.5914451988E-01],
	[3.7750000000E+04, 8.3762458698E+01, 1.4251333352E+01, 3.6014094582E+01, 9.1013092310E+00, 9.5916291850E-01],
	[3.7755000000E+04, 8.3781596154E+01, 1.4251403850E+01, 3.6029626902E+01, 9.1025555855E+00, 9.5918130795E-01],
	[3.7760000000E+04, 8.3800735448E+01, 1.4251474338E+01, 3.6045163860E+01, 9.1038016368E+00, 9.5919968824E-01],
	[3.7765000000E+04, 8.3819876579E+01, 1.4251544817E+01, 3.6060705457E+01, 9.1050473849E+00, 9.5921805937E-01],
	[3.7770000000E+04, 8.3839019547E+01, 1.4251615287E+01, 3.6076251694E+01, 9.1062928299E+00, 9.5923642135E-01],
	[3.7775000000E+04, 8.3858164352E+01, 1.4251685749E+01, 3.6091802571E+01, 9.1075379717E+00, 9.5925477417E-01],
	[3.7780000000E+04, 8.3877310994E+01, 1.4251756201E+01, 3.6107358090E+01, 9.1087828105E+00, 9.5927311785E-01],
	[3.7785000000E+04, 8.3896459473E+01, 1.4251826644E+01, 3.6122918251E+01, 9.1100273463E+00, 9.5929145239E-01],
	[3.7790000000E+04, 8.3915609788E+01, 1.4251897079E+01, 3.6138483054E+01, 9.1112715790E+00, 9.5930977779E-01],
	[3.7795000000E+04, 8.3934761941E+01, 1.4251967504E+01, 3.6154052501E+01, 9.1125155089E+00, 9.5932809406E-01],
	[3.7800000000E+04, 8.3953915930E+01, 1.4252037920E+01, 3.6169626593E+01, 9.1137591358E+00, 9.5934640120E-01],
	[3.7805000000E+04, 8.3973071756E+01, 1.4252108328E+01, 3.6185205330E+01, 9.1150024599E+00, 9.5936469922E-01],
	[3.7810000000E+04, 8.3992229419E+01, 1.4252178726E+01, 3.6200788712E+01, 9.1162454812E+00, 9.5938298813E-01],
	[3.7815000000E+04, 8.4011388918E+01, 1.4252249116E+01, 3.6216376741E+01, 9.1174881997E+00, 9.5940126792E-01],
	[3.7820000000E+04, 8.4030550253E+01, 1.4252319496E+01, 3.6231969418E+01, 9.1187306155E+00, 9.5941953861E-01],
	[3.7825000000E+04, 8.4049713425E+01, 1.4252389868E+01, 3.6247566743E+01, 9.1199727286E+00, 9.5943780019E-01],
	[3.7830000000E+04, 8.4068878434E+01, 1.4252460231E+01, 3.6263168717E+01, 9.1212145391E+00, 9.5945605268E-01],
	[3.7835000000E+04, 8.4088045278E+01, 1.4252530584E+01, 3.6278775340E+01, 9.1224560469E+00, 9.5947429607E-01],
	[3.7840000000E+04, 8.4107213959E+01, 1.4252600929E+01, 3.6294386615E+01, 9.1236972522E+00, 9.5949253037E-01],
	[3.7845000000E+04, 8.4126384476E+01, 1.4252671265E+01, 3.6310002540E+01, 9.1249381549E+00, 9.5951075559E-01],
	[3.7850000000E+04, 8.4145556829E+01, 1.4252741592E+01, 3.6325623118E+01, 9.1261787552E+00, 9.5952897173E-01],
	[3.7855000000E+04, 8.4164731018E+01, 1.4252811910E+01, 3.6341248348E+01, 9.1274190531E+00, 9.5954717880E-01],
	[3.7860000000E+04, 8.4183907042E+01, 1.4252882219E+01, 3.6356878232E+01, 9.1286590485E+00, 9.5956537680E-01],
	[3.7865000000E+04, 8.4203084903E+01, 1.4252952519E+01, 3.6372512770E+01, 9.1298987416E+00, 9.5958356573E-01],
	[3.7870000000E+04, 8.4222264600E+01, 1.4253022810E+01, 3.6388151964E+01, 9.1311381324E+00, 9.5960174561E-01],
	[3.7875000000E+04, 8.4241446132E+01, 1.4253093092E+01, 3.6403795813E+01, 9.1323772209E+00, 9.5961991642E-01],
	[3.7880000000E+04, 8.4260629500E+01, 1.4253163365E+01, 3.6419444319E+01, 9.1336160072E+00, 9.5963807819E-01],
	[3.7885000000E+04, 8.4279814703E+01, 1.4253233629E+01, 3.6435097483E+01, 9.1348544913E+00, 9.5965623092E-01],
	[3.7890000000E+04, 8.4299001742E+01, 1.4253303885E+01, 3.6450755304E+01, 9.1360926733E+00, 9.5967437460E-01],
	[3.7895000000E+04, 8.4318190617E+01, 1.4253374131E+01, 3.6466417785E+01, 9.1373305532E+00, 9.5969250925E-01],
	[3.7900000000E+04, 8.4337381326E+01, 1.4253444369E+01, 3.6482084926E+01, 9.1385681310E+00, 9.5971063486E-01],
	[3.7905000000E+04, 8.4356573872E+01, 1.4253514597E+01, 3.6497756727E+01, 9.1398054068E+00, 9.5972875145E-01],
	[3.7910000000E+04, 8.4375768252E+01, 1.4253584817E+01, 3.6513433189E+01, 9.1410423806E+00, 9.5974685902E-01],
	[3.7915000000E+04, 8.4394964468E+01, 1.4253655028E+01, 3.6529114314E+01, 9.1422790525E+00, 9.5976495757E-01],
	[3.7920000000E+04, 8.4414162518E+01, 1.4253725230E+01, 3.6544800101E+01, 9.1435154225E+00, 9.5978304711E-01],
	[3.7925000000E+04, 8.4433362404E+01, 1.4253795423E+01, 3.6560490552E+01, 9.1447514906E+00, 9.5980112764E-01],
	[3.7930000000E+04, 8.4452564125E+01, 1.4253865607E+01, 3.6576185667E+01, 9.1459872570E+00, 9.5981919917E-01],
	[3.7935000000E+04, 8.4471767681E+01, 1.4253935782E+01, 3.6591885447E+01, 9.1472227216E+00, 9.5983726170E-01],
	[3.7940000000E+04, 8.4490973071E+01, 1.4254005948E+01, 3.6607589894E+01, 9.1484578845E+00, 9.5985531523E-01],
	[3.7945000000E+04, 8.4510180297E+01, 1.4254076105E+01, 3.6623299007E+01, 9.1496927457E+00, 9.5987335978E-01],
	[3.7950000000E+04, 8.4529389357E+01, 1.4254146254E+01, 3.6639012787E+01, 9.1509273053E+00, 9.5989139535E-01],
	[3.7955000000E+04, 8.4548600252E+01, 1.4254216393E+01, 3.6654731236E+01, 9.1521615632E+00, 9.5990942193E-01],
	[3.7960000000E+04, 8.4567812981E+01, 1.4254286524E+01, 3.6670454354E+01, 9.1533955197E+00, 9.5992743954E-01],
	[3.7965000000E+04, 8.4587027545E+01, 1.4254356646E+01, 3.6686182141E+01, 9.1546291746E+00, 9.5994544818E-01],
	[3.7970000000E+04, 8.4606243943E+01, 1.4254426759E+01, 3.6701914599E+01, 9.1558625281E+00, 9.5996344786E-01],
	[3.7975000000E+04, 8.4625462176E+01, 1.4254496863E+01, 3.6717651729E+01, 9.1570955801E+00, 9.5998143858E-01],
	[3.7980000000E+04, 8.4644682243E+01, 1.4254566958E+01, 3.6733393530E+01, 9.1583283308E+00, 9.5999942034E-01],
	[3.7985000000E+04, 8.4663904145E+01, 1.4254637044E+01, 3.6749140005E+01, 9.1595607802E+00, 9.6001739315E-01],
	[3.7990000000E+04, 8.4683127880E+01, 1.4254707121E+01, 3.6764891153E+01, 9.1607929282E+00, 9.6003535702E-01],
	[3.7995000000E+04, 8.4702353450E+01, 1.4254777190E+01, 3.6780646975E+01, 9.1620247750E+00, 9.6005331194E-01],
	[3.8000000000E+04, 8.4721580854E+01, 1.4254847249E+01, 3.6796407473E+01, 9.1632563206E+00, 9.6007125793E-01],
	[3.8005000000E+04, 8.4740826959E+01, 1.4254919524E+01, 3.6812172646E+01, 9.1644886816E+00, 9.6008919499E-01],
	[3.8010000000E+04, 8.4760107080E+01, 1.4254996031E+01, 3.6827942496E+01, 9.1657228716E+00, 9.6010712312E-01],
	[3.8015000000E+04, 8.4779389050E+01, 1.4255072529E+01, 3.6843717024E+01, 9.1669567616E+00, 9.6012504232E-01],
	[3.8020000000E+04, 8.4798672870E+01, 1.4255149016E+01, 3.6859496230E+01, 9.1681903515E+00, 9.6014295261E-01],
	[3.8025000000E+04, 8.4817958539E+01, 1.4255225494E+01, 3.6875280115E+01, 9.1694236415E+00, 9.6016085399E-01],
	[3.8030000000E+04, 8.4837246058E+01, 1.4255301963E+01, 3.6891068680E+01, 9.1706566316E+00, 9.6017874646E-01],
	[3.8035000000E+04, 8.4856535426E+01, 1.4255378422E+01, 3.6906861925E+01, 9.1718893218E+00, 9.6019663003E-01],
	[3.8040000000E+04, 8.4875826644E+01, 1.4255454871E+01, 3.6922659852E+01, 9.1731217122E+00, 9.6021450470E-01],
	[3.8045000000E+04, 8.4895119711E+01, 1.4255531310E+01, 3.6938462461E+01, 9.1743538027E+00, 9.6023237047E-01],
	[3.8050000000E+04, 8.4914414627E+01, 1.4255607740E+01, 3.6954269752E+01, 9.1755855936E+00, 9.6025022735E-01],
	[3.8055000000E+04, 8.4933711393E+01, 1.4255684161E+01, 3.6970081728E+01, 9.1768170847E+00, 9.6026807535E-01],
	[3.8060000000E+04, 8.4953010007E+01, 1.4255760571E+01, 3.6985898387E+01, 9.1780482762E+00, 9.6028591447E-01],
	[3.8065000000E+04, 8.4972310471E+01, 1.4255836972E+01, 3.7001719732E+01, 9.1792791681E+00, 9.6030374472E-01],
	[3.8070000000E+04, 8.4991612783E+01, 1.4255913364E+01, 3.7017545763E+01, 9.1805097604E+00, 9.6032156610E-01],
	[3.8075000000E+04, 8.5010916945E+01, 1.4255989745E+01, 3.7033376481E+01, 9.1817400532E+00, 9.6033937861E-01],
	[3.8080000000E+04, 8.5030222955E+01, 1.4256066117E+01, 3.7049211886E+01, 9.1829700465E+00, 9.6035718225E-01],
	[3.8085000000E+04, 8.5049530814E+01, 1.4256142480E+01, 3.7065051980E+01, 9.1841997403E+00, 9.6037497705E-01],
	[3.8090000000E+04, 8.5068840522E+01, 1.4256218833E+01, 3.7080896762E+01, 9.1854291347E+00, 9.6039276299E-01],
	[3.8095000000E+04, 8.5088152078E+01, 1.4256295176E+01, 3.7096746234E+01, 9.1866582298E+00, 9.6041054008E-01],
	[3.8100000000E+04, 8.5107465483E+01, 1.4256371510E+01, 3.7112600397E+01, 9.1878870256E+00, 9.6042830834E-01],
	[3.8105000000E+04, 8.5126780736E+01, 1.4256447834E+01, 3.7128459252E+01, 9.1891155221E+00, 9.6044606775E-01],
	[3.8110000000E+04, 8.5146097838E+01, 1.4256524148E+01, 3.7144322798E+01, 9.1903437194E+00, 9.6046381834E-01],
	[3.8115000000E+04, 8.5165416789E+01, 1.4256600453E+01, 3.7160191037E+01, 9.1915716175E+00, 9.6048156009E-01],
	[3.8120000000E+04, 8.5184737587E+01, 1.4256676749E+01, 3.7176063970E+01, 9.1927992164E+00, 9.6049929302E-01],
	[3.8125000000E+04, 8.5204060234E+01, 1.4256753034E+01, 3.7191941598E+01, 9.1940265163E+00, 9.6051701714E-01],
	[3.8130000000E+04, 8.5223384729E+01, 1.4256829310E+01, 3.7207823920E+01, 9.1952535171E+00, 9.6053473244E-01],
	[3.8135000000E+04, 8.5242711073E+01, 1.4256905577E+01, 3.7223710939E+01, 9.1964802189E+00, 9.6055243893E-01],
	[3.8140000000E+04, 8.5262039264E+01, 1.4256981834E+01, 3.7239602655E+01, 9.1977066217E+00, 9.6057013661E-01],
	[3.8145000000E+04, 8.5281369303E+01, 1.4257058081E+01, 3.7255499067E+01, 9.1989327256E+00, 9.6058782550E-01],
	[3.8150000000E+04, 8.5300701190E+01, 1.4257134319E+01, 3.7271400179E+01, 9.2001585307E+00, 9.6060550559E-01],
	[3.8155000000E+04, 8.5320034925E+01, 1.4257210547E+01, 3.7287305989E+01, 9.2013840369E+00, 9.6062317689E-01],
	[3.8160000000E+04, 8.5339370508E+01, 1.4257286765E+01, 3.7303216499E+01, 9.2026092443E+00, 9.6064083941E-01],
	[3.8165000000E+04, 8.5358707939E+01, 1.4257362974E+01, 3.7319131710E+01, 9.2038341529E+00, 9.6065849314E-01],
	[3.8170000000E+04, 8.5378047217E+01, 1.4257439174E+01, 3.7335051622E+01, 9.2050587629E+00, 9.6067613810E-01],
	[3.8175000000E+04, 8.5397388343E+01, 1.4257515363E+01, 3.7350976237E+01, 9.2062830742E+00, 9.6069377429E-01],
	[3.8180000000E+04, 8.5416731316E+01, 1.4257591544E+01, 3.7366905554E+01, 9.2075070869E+00, 9.6071140171E-01],
	[3.8185000000E+04, 8.5436076137E+01, 1.4257667714E+01, 3.7382839575E+01, 9.2087308010E+00, 9.6072902037E-01],
	[3.8190000000E+04, 8.5455422805E+01, 1.4257743875E+01, 3.7398778300E+01, 9.2099542165E+00, 9.6074663027E-01],
	[3.8195000000E+04, 8.5474771320E+01, 1.4257820027E+01, 3.7414721731E+01, 9.2111773336E+00, 9.6076423142E-01],
	[3.8200000000E+04, 8.5494121683E+01, 1.4257896169E+01, 3.7430669868E+01, 9.2124001523E+00, 9.6078182382E-01],
	[3.8205000000E+04, 8.5513473893E+01, 1.4257972301E+01, 3.7446622711E+01, 9.2136226725E+00, 9.6079940747E-01],
	[3.8210000000E+04, 8.5532827950E+01, 1.4258048424E+01, 3.7462580262E+01, 9.2148448944E+00, 9.6081698239E-01],
	[3.8215000000E+04, 8.5552183855E+01, 1.4258124538E+01, 3.7478542522E+01, 9.2160668180E+00, 9.6083454857E-01],
	[3.8220000000E+04, 8.5571541606E+01, 1.4258200641E+01, 3.7494509490E+01, 9.2172884433E+00, 9.6085210603E-01],
	[3.8225000000E+04, 8.5590901204E+01, 1.4258276736E+01, 3.7510481169E+01, 9.2185097704E+00, 9.6086965476E-01],
	[3.8230000000E+04, 8.5610262649E+01, 1.4258352820E+01, 3.7526457558E+01, 9.2197307994E+00, 9.6088719477E-01],
	[3.8235000000E+04, 8.5629625941E+01, 1.4258428895E+01, 3.7542438658E+01, 9.2209515302E+00, 9.6090472606E-01],
	[3.8240000000E+04, 8.5648991079E+01, 1.4258504961E+01, 3.7558424471E+01, 9.2221719629E+00, 9.6092224865E-01],
	[3.8245000000E+04, 8.5668358065E+01, 1.4258581017E+01, 3.7574414997E+01, 9.2233920975E+00, 9.6093976252E-01],
	[3.8250000000E+04, 8.5687726897E+01, 1.4258657063E+01, 3.7590410236E+01, 9.2246119342E+00, 9.6095726770E-01],
	[3.8255000000E+04, 8.5707097575E+01, 1.4258733100E+01, 3.7606410190E+01, 9.2258314729E+00, 9.6097476418E-01],
	[3.8260000000E+04, 8.5726470100E+01, 1.4258809128E+01, 3.7622414859E+01, 9.2270507137E+00, 9.6099225197E-01],
	[3.8265000000E+04, 8.5745844471E+01, 1.4258885146E+01, 3.7638424245E+01, 9.2282696566E+00, 9.6100973107E-01],
	[3.8270000000E+04, 8.5765220689E+01, 1.4258961154E+01, 3.7654438347E+01, 9.2294883017E+00, 9.6102720148E-01],
	[3.8275000000E+04, 8.5784598753E+01, 1.4259037153E+01, 3.7670457166E+01, 9.2307066491E+00, 9.6104466322E-01],
	[3.8280000000E+04, 8.5803978663E+01, 1.4259113142E+01, 3.7686480705E+01, 9.2319246986E+00, 9.6106211629E-01],
	[3.8285000000E+04, 8.5823360419E+01, 1.4259189122E+01, 3.7702508962E+01, 9.2331424506E+00, 9.6107956069E-01],
	[3.8290000000E+04, 8.5842744022E+01, 1.4259265092E+01, 3.7718541939E+01, 9.2343599048E+00, 9.6109699642E-01],
	[3.8295000000E+04, 8.5862129470E+01, 1.4259341053E+01, 3.7734579637E+01, 9.2355770615E+00, 9.6111442349E-01],
	[3.8300000000E+04, 8.5881516765E+01, 1.4259417005E+01, 3.7750622056E+01, 9.2367939206E+00, 9.6113184191E-01],
	[3.8305000000E+04, 8.5900905905E+01, 1.4259492946E+01, 3.7766669197E+01, 9.2380104822E+00, 9.6114925168E-01],
	[3.8310000000E+04, 8.5920296891E+01, 1.4259568879E+01, 3.7782721062E+01, 9.2392267463E+00, 9.6116665281E-01],
	[3.8315000000E+04, 8.5939689723E+01, 1.4259644801E+01, 3.7798777650E+01, 9.2404427130E+00, 9.6118404529E-01],
	[3.8320000000E+04, 8.5959084401E+01, 1.4259720714E+01, 3.7814838963E+01, 9.2416583824E+00, 9.6120142914E-01],
	[3.8325000000E+04, 8.5978480924E+01, 1.4259796618E+01, 3.7830905001E+01, 9.2428737544E+00, 9.6121880435E-01],
	[3.8330000000E+04, 8.5997879293E+01, 1.4259872512E+01, 3.7846975765E+01, 9.2440888291E+00, 9.6123617094E-01],
	[3.8335000000E+04, 8.6017279507E+01, 1.4259948397E+01, 3.7863051257E+01, 9.2453036065E+00, 9.6125352891E-01],
	[3.8340000000E+04, 8.6036681567E+01, 1.4260024272E+01, 3.7879131475E+01, 9.2465180868E+00, 9.6127087825E-01],
	[3.8345000000E+04, 8.6056085472E+01, 1.4260100138E+01, 3.7895216423E+01, 9.2477322699E+00, 9.6128821899E-01],
	[3.8350000000E+04, 8.6075491223E+01, 1.4260175995E+01, 3.7911306099E+01, 9.2489461559E+00, 9.6130555112E-01],
	[3.8355000000E+04, 8.6094898818E+01, 1.4260251841E+01, 3.7927400505E+01, 9.2501597449E+00, 9.6132287464E-01],
	[3.8360000000E+04, 8.6114308259E+01, 1.4260327679E+01, 3.7943499642E+01, 9.2513730368E+00, 9.6134018957E-01],
	[3.8365000000E+04, 8.6133719545E+01, 1.4260403506E+01, 3.7959603511E+01, 9.2525860318E+00, 9.6135749590E-01],
	[3.8370000000E+04, 8.6153132676E+01, 1.4260479325E+01, 3.7975712112E+01, 9.2537987298E+00, 9.6137479364E-01],
	[3.8375000000E+04, 8.6172547652E+01, 1.4260555134E+01, 3.7991825445E+01, 9.2550111310E+00, 9.6139208279E-01],
	[3.8380000000E+04, 8.6191964473E+01, 1.4260630933E+01, 3.8007943513E+01, 9.2562232353E+00, 9.6140936337E-01],
	[3.8385000000E+04, 8.6211383139E+01, 1.4260706723E+01, 3.8024066315E+01, 9.2574350428E+00, 9.6142663537E-01],
	[3.8390000000E+04, 8.6230803650E+01, 1.4260782503E+01, 3.8040193853E+01, 9.2586465536E+00, 9.6144389879E-01],
	[3.8395000000E+04, 8.6250226005E+01, 1.4260858274E+01, 3.8056326127E+01, 9.2598577677E+00, 9.6146115365E-01],
	[3.8400000000E+04, 8.6269650205E+01, 1.4260934036E+01, 3.8072463138E+01, 9.2610686851E+00, 9.6147839994E-01],
	[3.8405000000E+04, 8.6289076250E+01, 1.4261009788E+01, 3.8088604886E+01, 9.2622793059E+00, 9.6149563768E-01],
	[3.8410000000E+04, 8.6308504139E+01, 1.4261085531E+01, 3.8104751373E+01, 9.2634896301E+00, 9.6151286685E-01],
	[3.8415000000E+04, 8.6327933872E+01, 1.4261161264E+01, 3.8120902599E+01, 9.2646996579E+00, 9.6153008748E-01],
	[3.8420000000E+04, 8.6347365450E+01, 1.4261236987E+01, 3.8137058565E+01, 9.2659093891E+00, 9.6154729956E-01],
	[3.8425000000E+04, 8.6366798872E+01, 1.4261312702E+01, 3.8153219272E+01, 9.2671188239E+00, 9.6156450310E-01],
	[3.8430000000E+04, 8.6386234139E+01, 1.4261388406E+01, 3.8169384720E+01, 9.2683279624E+00, 9.6158169809E-01],
	[3.8435000000E+04, 8.6405671250E+01, 1.4261464102E+01, 3.8185554911E+01, 9.2695368044E+00, 9.6159888456E-01],
	[3.8440000000E+04, 8.6425110205E+01, 1.4261539788E+01, 3.8201729845E+01, 9.2707453502E+00, 9.6161606249E-01],
	[3.8445000000E+04, 8.6444551004E+01, 1.4261615464E+01, 3.8217909522E+01, 9.2719535998E+00, 9.6163323190E-01],
	[3.8450000000E+04, 8.6463993647E+01, 1.4261691131E+01, 3.8234093944E+01, 9.2731615532E+00, 9.6165039278E-01],
	[3.8455000000E+04, 8.6483438134E+01, 1.4261766789E+01, 3.8250283112E+01, 9.2743692104E+00, 9.6166754515E-01],
	[3.8460000000E+04, 8.6502884464E+01, 1.4261842437E+01, 3.8266477026E+01, 9.2755765714E+00, 9.6168468900E-01],
	[3.8465000000E+04, 8.6522332639E+01, 1.4261918076E+01, 3.8282675687E+01, 9.2767836365E+00, 9.6170182435E-01],
	[3.8470000000E+04, 8.6541782657E+01, 1.4261993705E+01, 3.8298879096E+01, 9.2779904055E+00, 9.6171895119E-01],
	[3.8475000000E+04, 8.6561234520E+01, 1.4262069325E+01, 3.8315087253E+01, 9.2791968785E+00, 9.6173606953E-01],
	[3.8480000000E+04, 8.6580688225E+01, 1.4262144935E+01, 3.8331300159E+01, 9.2804030556E+00, 9.6175317937E-01],
	[3.8485000000E+04, 8.6600143774E+01, 1.4262220536E+01, 3.8347517815E+01, 9.2816089368E+00, 9.6177028072E-01],
	[3.8490000000E+04, 8.6619601167E+01, 1.4262296128E+01, 3.8363740223E+01, 9.2828145222E+00, 9.6178737359E-01],
	[3.8495000000E+04, 8.6639060403E+01, 1.4262371710E+01, 3.8379967381E+01, 9.2840198118E+00, 9.6180445797E-01],
	[3.8500000000E+04, 8.6658521483E+01, 1.4262447283E+01, 3.8396199293E+01, 9.2852248056E+00, 9.6182153387E-01],
	[3.8505000000E+04, 8.6677984406E+01, 1.4262522846E+01, 3.8412435957E+01, 9.2864295038E+00, 9.6183860130E-01],
	[3.8510000000E+04, 8.6697449172E+01, 1.4262598400E+01, 3.8428677375E+01, 9.2876339063E+00, 9.6185566025E-01],
	[3.8515000000E+04, 8.6716915781E+01, 1.4262673944E+01, 3.8444923548E+01, 9.2888380132E+00, 9.6187271074E-01],
	[3.8520000000E+04, 8.6736384233E+01, 1.4262749479E+01, 3.8461174477E+01, 9.2900418245E+00, 9.6188975277E-01],
	[3.8525000000E+04, 8.6755854528E+01, 1.4262825005E+01, 3.8477430161E+01, 9.2912453403E+00, 9.6190678633E-01],
	[3.8530000000E+04, 8.6775326667E+01, 1.4262900522E+01, 3.8493690603E+01, 9.2924485607E+00, 9.6192381145E-01],
	[3.8535000000E+04, 8.6794800648E+01, 1.4262976028E+01, 3.8509955802E+01, 9.2936514856E+00, 9.6194082811E-01],
	[3.8540000000E+04, 8.6814276472E+01, 1.4263051526E+01, 3.8526225760E+01, 9.2948541151E+00, 9.6195783633E-01],
	[3.8545000000E+04, 8.6833754139E+01, 1.4263127014E+01, 3.8542500478E+01, 9.2960564493E+00, 9.6197483611E-01],
	[3.8550000000E+04, 8.6853233648E+01, 1.4263202493E+01, 3.8558779955E+01, 9.2972584883E+00, 9.6199182745E-01],
	[3.8555000000E+04, 8.6872715001E+01, 1.4263277962E+01, 3.8575064193E+01, 9.2984602320E+00, 9.6200881035E-01],
	[3.8560000000E+04, 8.6892198195E+01, 1.4263353422E+01, 3.8591353193E+01, 9.2996616805E+00, 9.6202578483E-01],
	[3.8565000000E+04, 8.6911683233E+01, 1.4263428873E+01, 3.8607646956E+01, 9.3008628338E+00, 9.6204275089E-01],
	[3.8570000000E+04, 8.6931170112E+01, 1.4263504314E+01, 3.8623945481E+01, 9.3020636921E+00, 9.6205970852E-01],
	[3.8575000000E+04, 8.6950658835E+01, 1.4263579746E+01, 3.8640248771E+01, 9.3032642553E+00, 9.6207665774E-01],
	[3.8580000000E+04, 8.6970149399E+01, 1.4263655168E+01, 3.8656556825E+01, 9.3044645235E+00, 9.6209359855E-01],
	[3.8585000000E+04, 8.6989641806E+01, 1.4263730581E+01, 3.8672869645E+01, 9.3056644968E+00, 9.6211053094E-01],
	[3.8590000000E+04, 8.7009136055E+01, 1.4263805985E+01, 3.8689187231E+01, 9.3068641751E+00, 9.6212745494E-01],
	[3.8595000000E+04, 8.7028632146E+01, 1.4263881379E+01, 3.8705509584E+01, 9.3080635586E+00, 9.6214437054E-01],
	[3.8600000000E+04, 8.7048130079E+01, 1.4263956764E+01, 3.8721836705E+01, 9.3092626472E+00, 9.6216127774E-01],
	[3.8605000000E+04, 8.7067629854E+01, 1.4264032139E+01, 3.8738168595E+01, 9.3104614411E+00, 9.6217817655E-01],
	[3.8610000000E+04, 8.7087131471E+01, 1.4264107506E+01, 3.8754505254E+01, 9.3116599403E+00, 9.6219506698E-01],
	[3.8615000000E+04, 8.7106634930E+01, 1.4264182862E+01, 3.8770846683E+01, 9.3128581447E+00, 9.6221194902E-01],
	[3.8620000000E+04, 8.7126187825E+01, 1.4264264428E+01, 3.8787192883E+01, 9.3140592495E+00, 9.6222882269E-01],
	[3.8625000000E+04, 8.7145743363E+01, 1.4264346086E+01, 3.8803543855E+01, 9.3152601135E+00, 9.6224568798E-01],
	[3.8630000000E+04, 8.7165300758E+01, 1.4264427733E+01, 3.8819899599E+01, 9.3164606838E+00, 9.6226254490E-01],
	[3.8635000000E+04, 8.7184860009E+01, 1.4264509371E+01, 3.8836260117E+01, 9.3176609607E+00, 9.6227939346E-01],
	[3.8640000000E+04, 8.7204421118E+01, 1.4264590999E+01, 3.8852625408E+01, 9.3188609441E+00, 9.6229623365E-01],
	[3.8645000000E+04, 8.7223984084E+01, 1.4264672616E+01, 3.8868995475E+01, 9.3200606340E+00, 9.6231306549E-01],
	[3.8650000000E+04, 8.7243548907E+01, 1.4264754224E+01, 3.8885370317E+01, 9.3212600306E+00, 9.6232988898E-01],
	[3.8655000000E+04, 8.7263115586E+01, 1.4264835821E+01, 3.8901749935E+01, 9.3224591338E+00, 9.6234670412E-01],
	[3.8660000000E+04, 8.7282684122E+01, 1.4264917408E+01, 3.8918134330E+01, 9.3236579438E+00, 9.6236351091E-01],
	[3.8665000000E+04, 8.7302254515E+01, 1.4264998985E+01, 3.8934523504E+01, 9.3248564605E+00, 9.6238030936E-01],
	[3.8670000000E+04, 8.7321826764E+01, 1.4265080552E+01, 3.8950917456E+01, 9.3260546840E+00, 9.6239709948E-01],
	[3.8675000000E+04, 8.7341400870E+01, 1.4265162109E+01, 3.8967316187E+01, 9.3272526144E+00, 9.6241388127E-01],
	[3.8680000000E+04, 8.7360976833E+01, 1.4265243656E+01, 3.8983719699E+01, 9.3284502516E+00, 9.6243065473E-01],
	[3.8685000000E+04, 8.7380554652E+01, 1.4265325193E+01, 3.9000127991E+01, 9.3296475958E+00, 9.6244741987E-01],
	[3.8690000000E+04, 8.7400134327E+01, 1.4265406720E+01, 3.9016541066E+01, 9.3308446470E+00, 9.6246417668E-01],
	[3.8695000000E+04, 8.7419715858E+01, 1.4265488236E+01, 3.9032958923E+01, 9.3320414052E+00, 9.6248092519E-01],
	[3.8700000000E+04, 8.7439299246E+01, 1.4265569743E+01, 3.9049381563E+01, 9.3332378706E+00, 9.6249766538E-01],
	[3.8705000000E+04, 8.7458884489E+01, 1.4265651239E+01, 3.9065808988E+01, 9.3344340430E+00, 9.6251439727E-01],
	[3.8710000000E+04, 8.7478471589E+01, 1.4265732726E+01, 3.9082241197E+01, 9.3356299226E+00, 9.6253112085E-01],
	[3.8715000000E+04, 8.7498060545E+01, 1.4265814202E+01, 3.9098678192E+01, 9.3368255095E+00, 9.6254783614E-01],
	[3.8720000000E+04, 8.7517651357E+01, 1.4265895669E+01, 3.9115119973E+01, 9.3380208036E+00, 9.6256454313E-01],
	[3.8725000000E+04, 8.7537244025E+01, 1.4265977125E+01, 3.9131566542E+01, 9.3392158050E+00, 9.6258124184E-01],
	[3.8730000000E+04, 8.7556838548E+01, 1.4266058571E+01, 3.9148017898E+01, 9.3404105138E+00, 9.6259793226E-01],
	[3.8735000000E+04, 8.7576434927E+01, 1.4266140007E+01, 3.9164474043E+01, 9.3416049300E+00, 9.6261461440E-01],
	[3.8740000000E+04, 8.7596033162E+01, 1.4266221434E+01, 3.9180934978E+01, 9.3427990537E+00, 9.6263128826E-01],
	[3.8745000000E+04, 8.7615633253E+01, 1.4266302850E+01, 3.9197400703E+01, 9.3439928848E+00, 9.6264795385E-01],
	[3.8750000000E+04, 8.7635235199E+01, 1.4266384256E+01, 3.9213871219E+01, 9.3451864236E+00, 9.6266461117E-01],
	[3.8755000000E+04, 8.7654839001E+01, 1.4266465652E+01, 3.9230346527E+01, 9.3463796699E+00, 9.6268126022E-01],
	[3.8760000000E+04, 8.7674444658E+01, 1.4266547038E+01, 3.9246826627E+01, 9.3475726238E+00, 9.6269790102E-01],
	[3.8765000000E+04, 8.7694052170E+01, 1.4266628414E+01, 3.9263311521E+01, 9.3487652855E+00, 9.6271453356E-01],
	[3.8770000000E+04, 8.7713661538E+01, 1.4266709780E+01, 3.9279801209E+01, 9.3499576549E+00, 9.6273115785E-01],
	[3.8775000000E+04, 8.7733272761E+01, 1.4266791136E+01, 3.9296295692E+01, 9.3511497321E+00, 9.6274777389E-01],
	[3.8780000000E+04, 8.7752885840E+01, 1.4266872482E+01, 3.9312794971E+01, 9.3523415171E+00, 9.6276438169E-01],
	[3.8785000000E+04, 8.7772500773E+01, 1.4266953817E+01, 3.9329299046E+01, 9.3535330100E+00, 9.6278098126E-01],
	[3.8790000000E+04, 8.7792117562E+01, 1.4267035143E+01, 3.9345807919E+01, 9.3547242108E+00, 9.6279757258E-01],
	[3.8795000000E+04, 8.7811736205E+01, 1.4267116459E+01, 3.9362321589E+01, 9.3559151196E+00, 9.6281415568E-01],
	[3.8800000000E+04, 8.7831356703E+01, 1.4267197765E+01, 3.9378840059E+01, 9.3571057364E+00, 9.6283073055E-01],
	[3.8805000000E+04, 8.7850979057E+01, 1.4267279061E+01, 3.9395363327E+01, 9.3582960613E+00, 9.6284729719E-01],
	[3.8810000000E+04, 8.7870603265E+01, 1.4267360346E+01, 3.9411891397E+01, 9.3594860943E+00, 9.6286385562E-01],
	[3.8815000000E+04, 8.7890229328E+01, 1.4267441622E+01, 3.9428424267E+01, 9.3606758354E+00, 9.6288040584E-01],
	[3.8820000000E+04, 8.7909857245E+01, 1.4267522888E+01, 3.9444961939E+01, 9.3618652848E+00, 9.6289694785E-01],
	[3.8825000000E+04, 8.7929487017E+01, 1.4267604144E+01, 3.9461504414E+01, 9.3630544424E+00, 9.6291348165E-01],
	[3.8830000000E+04, 8.7949118644E+01, 1.4267685390E+01, 3.9478051693E+01, 9.3642433084E+00, 9.6293000725E-01],
	[3.8835000000E+04, 8.7968752125E+01, 1.4267766625E+01, 3.9494603775E+01, 9.3654318827E+00, 9.6294652465E-01],
	[3.8840000000E+04, 8.7988387461E+01, 1.4267847851E+01, 3.9511160663E+01, 9.3666201653E+00, 9.6296303386E-01],
	[3.8845000000E+04, 8.8008024650E+01, 1.4267929067E+01, 3.9527722356E+01, 9.3678081565E+00, 9.6297953489E-01],
	[3.8850000000E+04, 8.8027663695E+01, 1.4268010273E+01, 3.9544288856E+01, 9.3689958561E+00, 9.6299602772E-01],
	[3.8855000000E+04, 8.8047304593E+01, 1.4268091468E+01, 3.9560860164E+01, 9.3701832643E+00, 9.6301251238E-01],
	[3.8860000000E+04, 8.8066947346E+01, 1.4268172654E+01, 3.9577436279E+01, 9.3713703810E+00, 9.6302898886E-01],
	[3.8865000000E+04, 8.8086591953E+01, 1.4268253830E+01, 3.9594017203E+01, 9.3725572064E+00, 9.6304545717E-01],
	[3.8870000000E+04, 8.8106238413E+01, 1.4268334996E+01, 3.9610602937E+01, 9.3737437405E+00, 9.6306191732E-01],
	[3.8875000000E+04, 8.8125886728E+01, 1.4268416152E+01, 3.9627193482E+01, 9.3749299833E+00, 9.6307836930E-01],
	[3.8880000000E+04, 8.8145536897E+01, 1.4268497298E+01, 3.9643788837E+01, 9.3761159349E+00, 9.6309481312E-01],
	[3.8885000000E+04, 8.8165188919E+01, 1.4268578433E+01, 3.9660389005E+01, 9.3773015953E+00, 9.6311124879E-01],
	[3.8890000000E+04, 8.8184842796E+01, 1.4268659559E+01, 3.9676993985E+01, 9.3784869646E+00, 9.6312767630E-01],
	[3.8895000000E+04, 8.8204498526E+01, 1.4268740675E+01, 3.9693603779E+01, 9.3796720429E+00, 9.6314409567E-01],
	[3.8900000000E+04, 8.8224156109E+01, 1.4268821781E+01, 3.9710218387E+01, 9.3808568300E+00, 9.6316050690E-01],
	[3.8905000000E+04, 8.8243815547E+01, 1.4268902877E+01, 3.9726837810E+01, 9.3820413263E+00, 9.6317690998E-01],
	[3.8910000000E+04, 8.8263476837E+01, 1.4268983964E+01, 3.9743462050E+01, 9.3832255315E+00, 9.6319330494E-01],
	[3.8915000000E+04, 8.8283139982E+01, 1.4269065040E+01, 3.9760091105E+01, 9.3844094459E+00, 9.6320969176E-01],
	[3.8920000000E+04, 8.8302804980E+01, 1.4269146106E+01, 3.9776724979E+01, 9.3855930695E+00, 9.6322607046E-01],
	[3.8925000000E+04, 8.8322471831E+01, 1.4269227162E+01, 3.9793363670E+01, 9.3867764022E+00, 9.6324244104E-01],
	[3.8930000000E+04, 8.8342140535E+01, 1.4269308208E+01, 3.9810007180E+01, 9.3879594443E+00, 9.6325880350E-01],
	[3.8935000000E+04, 8.8361811093E+01, 1.4269389245E+01, 3.9826655510E+01, 9.3891421956E+00, 9.6327515785E-01],
	[3.8940000000E+04, 8.8381483503E+01, 1.4269470271E+01, 3.9843308661E+01, 9.3903246563E+00, 9.6329150409E-01],
	[3.8945000000E+04, 8.8401157767E+01, 1.4269551287E+01, 3.9859966633E+01, 9.3915068263E+00, 9.6330784222E-01],
	[3.8950000000E+04, 8.8420833884E+01, 1.4269632294E+01, 3.9876629426E+01, 9.3926887059E+00, 9.6332417226E-01],
	[3.8955000000E+04, 8.8440511854E+01, 1.4269713290E+01, 3.9893297043E+01, 9.3938702949E+00, 9.6334049419E-01],
	[3.8960000000E+04, 8.8460191676E+01, 1.4269794277E+01, 3.9909969483E+01, 9.3950515935E+00, 9.6335680804E-01],
	[3.8965000000E+04, 8.8479873352E+01, 1.4269875254E+01, 3.9926646748E+01, 9.3962326016E+00, 9.6337311380E-01],
	[3.8970000000E+04, 8.8499556880E+01, 1.4269956221E+01, 3.9943328838E+01, 9.3974133194E+00, 9.6338941147E-01],
	[3.8975000000E+04, 8.8519242261E+01, 1.4270037177E+01, 3.9960015754E+01, 9.3985937469E+00, 9.6340570106E-01],
	[3.8980000000E+04, 8.8538929495E+01, 1.4270118124E+01, 3.9976707496E+01, 9.3997738842E+00, 9.6342198258E-01],
	[3.8985000000E+04, 8.8558618581E+01, 1.4270199061E+01, 3.9993404066E+01, 9.4009537312E+00, 9.6343825603E-01],
	[3.8990000000E+04, 8.8578309520E+01, 1.4270279988E+01, 4.0010105465E+01, 9.4021332880E+00, 9.6345452141E-01],
	[3.8995000000E+04, 8.8598002311E+01, 1.4270360905E+01, 4.0026811692E+01, 9.4033125548E+00, 9.6347077873E-01],
	[3.9000000000E+04, 8.8617696955E+01, 1.4270441813E+01, 4.0043522749E+01, 9.4044915315E+00, 9.6348702799E-01],
	[3.9005000000E+04, 8.8637393451E+01, 1.4270522710E+01, 4.0060238637E+01, 9.4056702181E+00, 9.6350326919E-01],
	[3.9010000000E+04, 8.8657091799E+01, 1.4270603597E+01, 4.0076959356E+01, 9.4068486148E+00, 9.6351950234E-01],
	[3.9015000000E+04, 8.8676791999E+01, 1.4270684475E+01, 4.0093684907E+01, 9.4080267215E+00, 9.6353572745E-01],
	[3.9020000000E+04, 8.8696494052E+01, 1.4270765342E+01, 4.0110415291E+01, 9.4092045384E+00, 9.6355194452E-01],
	[3.9025000000E+04, 8.8716197957E+01, 1.4270846200E+01, 4.0127150509E+01, 9.4103820655E+00, 9.6356815355E-01],
	[3.9030000000E+04, 8.8735903713E+01, 1.4270927048E+01, 4.0143890562E+01, 9.4115593027E+00, 9.6358435454E-01],
	[3.9035000000E+04, 8.8755611322E+01, 1.4271007886E+01, 4.0160635449E+01, 9.4127362503E+00, 9.6360054750E-01],
	[3.9040000000E+04, 8.8775320782E+01, 1.4271088714E+01, 4.0177385173E+01, 9.4139129081E+00, 9.6361673244E-01],
	[3.9045000000E+04, 8.8795032095E+01, 1.4271169532E+01, 4.0194139733E+01, 9.4150892764E+00, 9.6363290936E-01],
	[3.9050000000E+04, 8.8814745259E+01, 1.4271250340E+01, 4.0210899131E+01, 9.4162653550E+00, 9.6364907826E-01],
	[3.9055000000E+04, 8.8834460275E+01, 1.4271331138E+01, 4.0227663368E+01, 9.4174411441E+00, 9.6366523915E-01],
	[3.9060000000E+04, 8.8854177142E+01, 1.4271411927E+01, 4.0244432443E+01, 9.4186166437E+00, 9.6368139203E-01],
	[3.9065000000E+04, 8.8873895861E+01, 1.4271492705E+01, 4.0261206358E+01, 9.4197918539E+00, 9.6369753691E-01],
	[3.9070000000E+04, 8.8893616432E+01, 1.4271573474E+01, 4.0277985114E+01, 9.4209667747E+00, 9.6371367378E-01],
	[3.9075000000E+04, 8.8913338854E+01, 1.4271654233E+01, 4.0294768712E+01, 9.4221414062E+00, 9.6372980266E-01],
	[3.9080000000E+04, 8.8933063127E+01, 1.4271734982E+01, 4.0311557152E+01, 9.4233157483E+00, 9.6374592355E-01],
	[3.9085000000E+04, 8.8952789252E+01, 1.4271815721E+01, 4.0328350434E+01, 9.4244898012E+00, 9.6376203644E-01],
	[3.9090000000E+04, 8.8972517228E+01, 1.4271896450E+01, 4.0345148561E+01, 9.4256635649E+00, 9.6377814136E-01],
	[3.9095000000E+04, 8.8992247055E+01, 1.4271977169E+01, 4.0361951532E+01, 9.4268370395E+00, 9.6379423829E-01],
	[3.9100000000E+04, 8.9011978733E+01, 1.4272057878E+01, 4.0378759348E+01, 9.4280102250E+00, 9.6381032725E-01],
	[3.9105000000E+04, 8.9031712262E+01, 1.4272138578E+01, 4.0395572011E+01, 9.4291831214E+00, 9.6382640824E-01],
	[3.9110000000E+04, 8.9051447642E+01, 1.4272219268E+01, 4.0412389520E+01, 9.4303557288E+00, 9.6384248126E-01],
	[3.9115000000E+04, 8.9071184874E+01, 1.4272299947E+01, 4.0429211877E+01, 9.4315280473E+00, 9.6385854632E-01],
	[3.9120000000E+04, 8.9090923956E+01, 1.4272380617E+01, 4.0446039083E+01, 9.4327000769E+00, 9.6387460342E-01],
	[3.9125000000E+04, 8.9110664889E+01, 1.4272461278E+01, 4.0462871138E+01, 9.4338718176E+00, 9.6389065257E-01],
	[3.9130000000E+04, 8.9130407673E+01, 1.4272541928E+01, 4.0479708042E+01, 9.4350432695E+00, 9.6390669376E-01],
	[3.9135000000E+04, 8.9150152307E+01, 1.4272622568E+01, 4.0496549798E+01, 9.4362144326E+00, 9.6392272701E-01],
	[3.9140000000E+04, 8.9169898792E+01, 1.4272703199E+01, 4.0513396405E+01, 9.4373853071E+00, 9.6393875232E-01],
	[3.9145000000E+04, 8.9189647128E+01, 1.4272783820E+01, 4.0530247864E+01, 9.4385558929E+00, 9.6395476968E-01],
	[3.9150000000E+04, 8.9209397314E+01, 1.4272864430E+01, 4.0547104177E+01, 9.4397261901E+00, 9.6397077912E-01],
	[3.9155000000E+04, 8.9229149350E+01, 1.4272945032E+01, 4.0563965343E+01, 9.4408961987E+00, 9.6398678062E-01],
	[3.9160000000E+04, 8.9248903237E+01, 1.4273025623E+01, 4.0580831364E+01, 9.4420659188E+00, 9.6400277420E-01],
	[3.9165000000E+04, 8.9268658974E+01, 1.4273106204E+01, 4.0597702240E+01, 9.4432353504E+00, 9.6401875986E-01],
	[3.9170000000E+04, 8.9288416562E+01, 1.4273186776E+01, 4.0614577973E+01, 9.4444044937E+00, 9.6403473760E-01],
	[3.9175000000E+04, 8.9308175999E+01, 1.4273267337E+01, 4.0631458563E+01, 9.4455733486E+00, 9.6405070743E-01],
	[3.9180000000E+04, 8.9327937287E+01, 1.4273347889E+01, 4.0648344010E+01, 9.4467419151E+00, 9.6406666934E-01],
	[3.9185000000E+04, 8.9347700425E+01, 1.4273428431E+01, 4.0665234316E+01, 9.4479101934E+00, 9.6408262336E-01],
	[3.9190000000E+04, 8.9367465413E+01, 1.4273508964E+01, 4.0682129481E+01, 9.4490781835E+00, 9.6409856947E-01],
	[3.9195000000E+04, 8.9387232251E+01, 1.4273589486E+01, 4.0699029506E+01, 9.4502458854E+00, 9.6411450768E-01],
	[3.9200000000E+04, 8.9407000938E+01, 1.4273669999E+01, 4.0715934393E+01, 9.4514132992E+00, 9.6413043801E-01],
	[3.9205000000E+04, 8.9426771476E+01, 1.4273750501E+01, 4.0732844140E+01, 9.4525804249E+00, 9.6414636044E-01],
	[3.9210000000E+04, 8.9446543863E+01, 1.4273830994E+01, 4.0749758751E+01, 9.4537472627E+00, 9.6416227499E-01],
	[3.9215000000E+04, 8.9466318100E+01, 1.4273911478E+01, 4.0766678224E+01, 9.4549138124E+00, 9.6417818166E-01],
	[3.9220000000E+04, 8.9486094186E+01, 1.4273991951E+01, 4.0783602561E+01, 9.4560800742E+00, 9.6419408046E-01],
	[3.9225000000E+04, 8.9505872122E+01, 1.4274072414E+01, 4.0800531763E+01, 9.4572460482E+00, 9.6420997138E-01],
	[3.9230000000E+04, 8.9525651908E+01, 1.4274152868E+01, 4.0817465831E+01, 9.4584117343E+00, 9.6422585443E-01],
	[3.9235000000E+04, 8.9545433543E+01, 1.4274233312E+01, 4.0834404765E+01, 9.4595771327E+00, 9.6424172963E-01],
	[3.9240000000E+04, 8.9565248206E+01, 1.4274317786E+01, 4.0851348566E+01, 9.4607443656E+00, 9.6425759696E-01],
	[3.9245000000E+04, 8.9585081247E+01, 1.4274404388E+01, 4.0868297235E+01, 9.4619124357E+00, 9.6427345643E-01],
	[3.9250000000E+04, 8.9604916153E+01, 1.4274490980E+01, 4.0885250773E+01, 9.4630802192E+00, 9.6428930806E-01],
	[3.9255000000E+04, 8.9624752923E+01, 1.4274577562E+01, 4.0902209180E+01, 9.4642477160E+00, 9.6430515184E-01],
	[3.9260000000E+04, 8.9644591556E+01, 1.4274664133E+01, 4.0919172457E+01, 9.4654149261E+00, 9.6432098777E-01],
	[3.9265000000E+04, 8.9664432054E+01, 1.4274750694E+01, 4.0936140605E+01, 9.4665818498E+00, 9.6433681587E-01],
	[3.9270000000E+04, 8.9684274416E+01, 1.4274837244E+01, 4.0953113625E+01, 9.4677484869E+00, 9.6435263613E-01],
	[3.9275000000E+04, 8.9704118642E+01, 1.4274923783E+01, 4.0970091517E+01, 9.4689148376E+00, 9.6436844856E-01],
	[3.9280000000E+04, 8.9723964732E+01, 1.4275010313E+01, 4.0987074283E+01, 9.4700809018E+00, 9.6438425317E-01],
	[3.9285000000E+04, 8.9743812686E+01, 1.4275096831E+01, 4.1004061922E+01, 9.4712466797E+00, 9.6440004995E-01],
	[3.9290000000E+04, 8.9763662503E+01, 1.4275183339E+01, 4.1021054437E+01, 9.4724121713E+00, 9.6441583892E-01],
	[3.9295000000E+04, 8.9783514184E+01, 1.4275269837E+01, 4.1038051827E+01, 9.4735773767E+00, 9.6443162007E-01],
	[3.9300000000E+04, 8.9803367729E+01, 1.4275356324E+01, 4.1055054094E+01, 9.4747422958E+00, 9.6444739341E-01],
	[3.9305000000E+04, 8.9823223137E+01, 1.4275442801E+01, 4.1072061237E+01, 9.4759069288E+00, 9.6446315894E-01],
	[3.9310000000E+04, 8.9843080409E+01, 1.4275529267E+01, 4.1089073259E+01, 9.4770712756E+00, 9.6447891668E-01],
	[3.9315000000E+04, 8.9862939545E+01, 1.4275615723E+01, 4.1106090160E+01, 9.4782353364E+00, 9.6449466661E-01],
	[3.9320000000E+04, 8.9882800543E+01, 1.4275702168E+01, 4.1123111940E+01, 9.4793991112E+00, 9.6451040876E-01],
	[3.9325000000E+04, 8.9902663405E+01, 1.4275788603E+01, 4.1140138600E+01, 9.4805626000E+00, 9.6452614311E-01],
	[3.9330000000E+04, 8.9922528131E+01, 1.4275875028E+01, 4.1157170141E+01, 9.4817258029E+00, 9.6454186968E-01],
	[3.9335000000E+04, 8.9942394719E+01, 1.4275961441E+01, 4.1174206564E+01, 9.4828887199E+00, 9.6455758846E-01],
	[3.9340000000E+04, 8.9962263171E+01, 1.4276047845E+01, 4.1191247870E+01, 9.4840513512E+00, 9.6457329947E-01],
	[3.9345000000E+04, 8.9982133485E+01, 1.4276134238E+01, 4.1208294059E+01, 9.4852136966E+00, 9.6458900271E-01],
	[3.9350000000E+04, 9.0002005663E+01, 1.4276220620E+01, 4.1225345133E+01, 9.4863757564E+00, 9.6460469818E-01],
	[3.9355000000E+04, 9.0021879704E+01, 1.4276306993E+01, 4.1242401091E+01, 9.4875375304E+00, 9.6462038588E-01],
	[3.9360000000E+04, 9.0041755608E+01, 1.4276393354E+01, 4.1259461935E+01, 9.4886990189E+00, 9.6463606582E-01],
	[3.9365000000E+04, 9.0061633374E+01, 1.4276479705E+01, 4.1276527666E+01, 9.4898602218E+00, 9.6465173801E-01],
	[3.9370000000E+04, 9.0081513003E+01, 1.4276566046E+01, 4.1293598284E+01, 9.4910211391E+00, 9.6466740244E-01],
	[3.9375000000E+04, 9.0101394495E+01, 1.4276652376E+01, 4.1310673790E+01, 9.4921817710E+00, 9.6468305913E-01],
	[3.9380000000E+04, 9.0121277850E+01, 1.4276738696E+01, 4.1327754184E+01, 9.4933421175E+00, 9.6469870807E-01],
	[3.9385000000E+04, 9.0141163067E+01, 1.4276825006E+01, 4.1344839469E+01, 9.4945021786E+00, 9.6471434927E-01],
	[3.9390000000E+04, 9.0161050146E+01, 1.4276911305E+01, 4.1361929643E+01, 9.4956619544E+00, 9.6472998274E-01],
	[3.9395000000E+04, 9.0180939089E+01, 1.4276997593E+01, 4.1379024709E+01, 9.4968214450E+00, 9.6474560847E-01],
	[3.9400000000E+04, 9.0200829893E+01, 1.4277083871E+01, 4.1396124667E+01, 9.4979806503E+00, 9.6476122647E-01],
	[3.9405000000E+04, 9.0220722560E+01, 1.4277170139E+01, 4.1413229518E+01, 9.4991395704E+00, 9.6477683676E-01],
	[3.9410000000E+04, 9.0240617089E+01, 1.4277256396E+01, 4.1430339262E+01, 9.5002982054E+00, 9.6479243932E-01],
	[3.9415000000E+04, 9.0260513480E+01, 1.4277342643E+01, 4.1447453901E+01, 9.5014565554E+00, 9.6480803417E-01],
	[3.9420000000E+04, 9.0280411734E+01, 1.4277428879E+01, 4.1464573434E+01, 9.5026146203E+00, 9.6482362130E-01],
	[3.9425000000E+04, 9.0300311849E+01, 1.4277515105E+01, 4.1481697863E+01, 9.5037724002E+00, 9.6483920073E-01],
	[3.9430000000E+04, 9.0320213827E+01, 1.4277601321E+01, 4.1498827189E+01, 9.5049298953E+00, 9.6485477245E-01],
	[3.9435000000E+04, 9.0340117667E+01, 1.4277687526E+01, 4.1515961413E+01, 9.5060871054E+00, 9.6487033648E-01],
	[3.9440000000E+04, 9.0360023368E+01, 1.4277773721E+01, 4.1533100534E+01, 9.5072440308E+00, 9.6488589281E-01],
	[3.9445000000E+04, 9.0379930931E+01, 1.4277859905E+01, 4.1550244555E+01, 9.5084006714E+00, 9.6490144145E-01],
	[3.9450000000E+04, 9.0399840357E+01, 1.4277946079E+01, 4.1567393475E+01, 9.5095570272E+00, 9.6491698240E-01],
	[3.9455000000E+04, 9.0419751643E+01, 1.4278032243E+01, 4.1584547296E+01, 9.5107130984E+00, 9.6493251567E-01],
	[3.9460000000E+04, 9.0439664792E+01, 1.4278118396E+01, 4.1601706018E+01, 9.5118688850E+00, 9.6494804126E-01],
	[3.9465000000E+04, 9.0459579802E+01, 1.4278204539E+01, 4.1618869642E+01, 9.5130243870E+00, 9.6496355918E-01],
	[3.9470000000E+04, 9.0479496673E+01, 1.4278290671E+01, 4.1636038169E+01, 9.5141796044E+00, 9.6497906943E-01],
	[3.9475000000E+04, 9.0499415407E+01, 1.4278376793E+01, 4.1653211599E+01, 9.5153345374E+00, 9.6499457201E-01],
	[3.9480000000E+04, 9.0519336001E+01, 1.4278462905E+01, 4.1670389934E+01, 9.5164891860E+00, 9.6501006693E-01],
	[3.9485000000E+04, 9.0539258457E+01, 1.4278549006E+01, 4.1687573174E+01, 9.5176435502E+00, 9.6502555418E-01],
	[3.9490000000E+04, 9.0559182774E+01, 1.4278635097E+01, 4.1704761320E+01, 9.5187976301E+00, 9.6504103379E-01],
	[3.9495000000E+04, 9.0579108952E+01, 1.4278721177E+01, 4.1721954373E+01, 9.5199514257E+00, 9.6505650574E-01],
	[3.9500000000E+04, 9.0599036992E+01, 1.4278807247E+01, 4.1739152333E+01, 9.5211049371E+00, 9.6507197005E-01],
	[3.9505000000E+04, 9.0618966892E+01, 1.4278893307E+01, 4.1756355202E+01, 9.5222581644E+00, 9.6508742672E-01],
	[3.9510000000E+04, 9.0638898654E+01, 1.4278979356E+01, 4.1773562980E+01, 9.5234111075E+00, 9.6510287575E-01],
	[3.9515000000E+04, 9.0658832277E+01, 1.4279065395E+01, 4.1790775667E+01, 9.5245637665E+00, 9.6511831714E-01],
	[3.9520000000E+04, 9.0678767760E+01, 1.4279151424E+01, 4.1807993265E+01, 9.5257161416E+00, 9.6513375091E-01],
	[3.9525000000E+04, 9.0698705104E+01, 1.4279237442E+01, 4.1825215775E+01, 9.5268682326E+00, 9.6514917705E-01],
	[3.9530000000E+04, 9.0718644310E+01, 1.4279323450E+01, 4.1842443197E+01, 9.5280200398E+00, 9.6516459557E-01],
	[3.9535000000E+04, 9.0738585376E+01, 1.4279409447E+01, 4.1859675531E+01, 9.5291715630E+00, 9.6518000647E-01],
	[3.9540000000E+04, 9.0758528302E+01, 1.4279495435E+01, 4.1876912780E+01, 9.5303228025E+00, 9.6519540975E-01],
	[3.9545000000E+04, 9.0778473089E+01, 1.4279581411E+01, 4.1894154943E+01, 9.5314737582E+00, 9.6521080543E-01],
	[3.9550000000E+04, 9.0798419737E+01, 1.4279667378E+01, 4.1911402021E+01, 9.5326244302E+00, 9.6522619350E-01],
	[3.9555000000E+04, 9.0818368245E+01, 1.4279753334E+01, 4.1928654015E+01, 9.5337748185E+00, 9.6524157397E-01],
	[3.9560000000E+04, 9.0838318614E+01, 1.4279839280E+01, 4.1945910926E+01, 9.5349249232E+00, 9.6525694685E-01],
	[3.9565000000E+04, 9.0858270843E+01, 1.4279925215E+01, 4.1963172755E+01, 9.5360747443E+00, 9.6527231213E-01],
	[3.9570000000E+04, 9.0878224932E+01, 1.4280011140E+01, 4.1980439502E+01, 9.5372242819E+00, 9.6528766982E-01],
	[3.9575000000E+04, 9.0898180881E+01, 1.4280097055E+01, 4.1997711169E+01, 9.5383735361E+00, 9.6530301993E-01],
	[3.9580000000E+04, 9.0918138691E+01, 1.4280182959E+01, 4.2014987755E+01, 9.5395225068E+00, 9.6531836245E-01],
	[3.9585000000E+04, 9.0938098361E+01, 1.4280268853E+01, 4.2032269262E+01, 9.5406711942E+00, 9.6533369740E-01],
	[3.9590000000E+04, 9.0958059891E+01, 1.4280354737E+01, 4.2049555691E+01, 9.5418195983E+00, 9.6534902477E-01],
	[3.9595000000E+04, 9.0978023281E+01, 1.4280440610E+01, 4.2066847042E+01, 9.5429677191E+00, 9.6536434458E-01],
	[3.9600000000E+04, 9.0997988530E+01, 1.4280526473E+01, 4.2084143316E+01, 9.5441155567E+00, 9.6537965682E-01],
	[3.9605000000E+04, 9.1017955640E+01, 1.4280612326E+01, 4.2101444513E+01, 9.5452631111E+00, 9.6539496150E-01],
	[3.9610000000E+04, 9.1037924609E+01, 1.4280698168E+01, 4.2118750636E+01, 9.5464103825E+00, 9.6541025863E-01],
	[3.9615000000E+04, 9.1057895438E+01, 1.4280784000E+01, 4.2136061684E+01, 9.5475573707E+00, 9.6542554820E-01],
	[3.9620000000E+04, 9.1077868127E+01, 1.4280869822E+01, 4.2153377658E+01, 9.5487040760E+00, 9.6544083022E-01],
	[3.9625000000E+04, 9.1097842676E+01, 1.4280955634E+01, 4.2170698559E+01, 9.5498504983E+00, 9.6545610470E-01],
	[3.9630000000E+04, 9.1117819084E+01, 1.4281041435E+01, 4.2188024388E+01, 9.5509966377E+00, 9.6547137164E-01],
	[3.9635000000E+04, 9.1137797351E+01, 1.4281127226E+01, 4.2205355145E+01, 9.5521424942E+00, 9.6548663104E-01],
	[3.9640000000E+04, 9.1157777478E+01, 1.4281213006E+01, 4.2222690832E+01, 9.5532880680E+00, 9.6550188291E-01],
	[3.9645000000E+04, 9.1177759465E+01, 1.4281298776E+01, 4.2240031448E+01, 9.5544333590E+00, 9.6551712725E-01],
	[3.9650000000E+04, 9.1197743310E+01, 1.4281384536E+01, 4.2257376996E+01, 9.5555783673E+00, 9.6553236406E-01],
	[3.9655000000E+04, 9.1217729015E+01, 1.4281470286E+01, 4.2274727475E+01, 9.5567230929E+00, 9.6554759336E-01],
	[3.9660000000E+04, 9.1237716579E+01, 1.4281556025E+01, 4.2292082887E+01, 9.5578675359E+00, 9.6556281514E-01],
	[3.9665000000E+04, 9.1257706002E+01, 1.4281641754E+01, 4.2309443232E+01, 9.5590116964E+00, 9.6557802941E-01],
	[3.9670000000E+04, 9.1277697285E+01, 1.4281727473E+01, 4.2326808511E+01, 9.5601555744E+00, 9.6559323617E-01],
	[3.9675000000E+04, 9.1297690426E+01, 1.4281813181E+01, 4.2344178724E+01, 9.5612991700E+00, 9.6560843542E-01],
	[3.9680000000E+04, 9.1317685426E+01, 1.4281898880E+01, 4.2361553874E+01, 9.5624424831E+00, 9.6562362718E-01],
	[3.9685000000E+04, 9.1337682285E+01, 1.4281984567E+01, 4.2378933959E+01, 9.5635855139E+00, 9.6563881144E-01],
	[3.9690000000E+04, 9.1357681003E+01, 1.4282070245E+01, 4.2396318982E+01, 9.5647282624E+00, 9.6565398820E-01],
	[3.9695000000E+04, 9.1377681580E+01, 1.4282155912E+01, 4.2413708942E+01, 9.5658707287E+00, 9.6566915748E-01],
	[3.9700000000E+04, 9.1397684015E+01, 1.4282241569E+01, 4.2431103841E+01, 9.5670129128E+00, 9.6568431928E-01],
	[3.9705000000E+04, 9.1417688309E+01, 1.4282327216E+01, 4.2448503680E+01, 9.5681548147E+00, 9.6569947359E-01],
	[3.9710000000E+04, 9.1437694462E+01, 1.4282412853E+01, 4.2465908459E+01, 9.5692964345E+00, 9.6571462043E-01],
	[3.9715000000E+04, 9.1457702473E+01, 1.4282498479E+01, 4.2483318178E+01, 9.5704377723E+00, 9.6572975980E-01],
	[3.9720000000E+04, 9.1477712342E+01, 1.4282584095E+01, 4.2500732840E+01, 9.5715788281E+00, 9.6574489170E-01],
	[3.9725000000E+04, 9.1497724070E+01, 1.4282669701E+01, 4.2518152444E+01, 9.5727196020E+00, 9.6576001613E-01],
	[3.9730000000E+04, 9.1517737657E+01, 1.4282755296E+01, 4.2535576991E+01, 9.5738600940E+00, 9.6577513311E-01],
	[3.9735000000E+04, 9.1537753101E+01, 1.4282840881E+01, 4.2553006483E+01, 9.5750003042E+00, 9.6579024263E-01],
	[3.9740000000E+04, 9.1557770404E+01, 1.4282926456E+01, 4.2570440919E+01, 9.5761402325E+00, 9.6580534469E-01],
	[3.9745000000E+04, 9.1577789565E+01, 1.4283012021E+01, 4.2587880302E+01, 9.5772798792E+00, 9.6582043931E-01],
	[3.9750000000E+04, 9.1597810584E+01, 1.4283097575E+01, 4.2605324630E+01, 9.5784192441E+00, 9.6583552649E-01],
	[3.9755000000E+04, 9.1617833461E+01, 1.4283183119E+01, 4.2622773906E+01, 9.5795583275E+00, 9.6585060623E-01],
	[3.9760000000E+04, 9.1637858196E+01, 1.4283268653E+01, 4.2640228130E+01, 9.5806971292E+00, 9.6586567853E-01],
	[3.9765000000E+04, 9.1657884788E+01, 1.4283354177E+01, 4.2657687302E+01, 9.5818356495E+00, 9.6588074339E-01],
	[3.9770000000E+04, 9.1677913239E+01, 1.4283439690E+01, 4.2675151425E+01, 9.5829738882E+00, 9.6589580084E-01],
	[3.9775000000E+04, 9.1697943548E+01, 1.4283525193E+01, 4.2692620497E+01, 9.5841118456E+00, 9.6591085085E-01],
	[3.9780000000E+04, 9.1717975714E+01, 1.4283610686E+01, 4.2710094521E+01, 9.5852495215E+00, 9.6592589345E-01],
	[3.9785000000E+04, 9.1738009738E+01, 1.4283696169E+01, 4.2727573496E+01, 9.5863869162E+00, 9.6594092863E-01],
	[3.9790000000E+04, 9.1758045619E+01, 1.4283781642E+01, 4.2745057424E+01, 9.5875240295E+00, 9.6595595640E-01],
	[3.9795000000E+04, 9.1778083358E+01, 1.4283867104E+01, 4.2762546306E+01, 9.5886608617E+00, 9.6597097676E-01],
	[3.9800000000E+04, 9.1798122954E+01, 1.4283952556E+01, 4.2780040142E+01, 9.5897974127E+00, 9.6598598972E-01],
	[3.9805000000E+04, 9.1818164408E+01, 1.4284037998E+01, 4.2797538933E+01, 9.5909336826E+00, 9.6600099528E-01],
	[3.9810000000E+04, 9.1838207719E+01, 1.4284123429E+01, 4.2815042680E+01, 9.5920696714E+00, 9.6601599344E-01],
	[3.9815000000E+04, 9.1858252888E+01, 1.4284208851E+01, 4.2832551383E+01, 9.5932053792E+00, 9.6603098422E-01],
	[3.9820000000E+04, 9.1878299914E+01, 1.4284294262E+01, 4.2850065044E+01, 9.5943408060E+00, 9.6604596760E-01],
	[3.9825000000E+04, 9.1898348796E+01, 1.4284379663E+01, 4.2867583663E+01, 9.5954759519E+00, 9.6606094360E-01],
	[3.9830000000E+04, 9.1918399536E+01, 1.4284465054E+01, 4.2885107241E+01, 9.5966108170E+00, 9.6607591224E-01],
	[3.9835000000E+04, 9.1938452133E+01, 1.4284550434E+01, 4.2902635778E+01, 9.5977454013E+00, 9.6609087352E-01],
	[3.9840000000E+04, 9.1958506587E+01, 1.4284635804E+01, 4.2920169276E+01, 9.5988797048E+00, 9.6610582745E-01],
	[3.9845000000E+04, 9.1978562898E+01, 1.4284721165E+01, 4.2937707735E+01, 9.6000137276E+00, 9.6612077403E-01],
	[3.9850000000E+04, 9.1998621066E+01, 1.4284806515E+01, 4.2955251157E+01, 9.6011474698E+00, 9.6613571326E-01],
	[3.9855000000E+04, 9.2018681091E+01, 1.4284891854E+01, 4.2972799541E+01, 9.6022809314E+00, 9.6615064515E-01],
	[3.9860000000E+04, 9.2038742972E+01, 1.4284977184E+01, 4.2990352888E+01, 9.6034141124E+00, 9.6616556971E-01],
	[3.9865000000E+04, 9.2058806710E+01, 1.4285062503E+01, 4.3007911200E+01, 9.6045470129E+00, 9.6618048693E-01],
	[3.9870000000E+04, 9.2078887454E+01, 1.4285149758E+01, 4.3025474478E+01, 9.6056806777E+00, 9.6619539682E-01],
	[3.9875000000E+04, 9.2099001943E+01, 1.4285241098E+01, 4.3043042721E+01, 9.6068162613E+00, 9.6621029937E-01],
	[3.9880000000E+04, 9.2119118304E+01, 1.4285332426E+01, 4.3060615931E+01, 9.6079515653E+00, 9.6622519461E-01],
	[3.9885000000E+04, 9.2139236535E+01, 1.4285423744E+01, 4.3078194108E+01, 9.6090865900E+00, 9.6624008252E-01],
	[3.9890000000E+04, 9.2159356638E+01, 1.4285515051E+01, 4.3095777254E+01, 9.6102213353E+00, 9.6625496312E-01],
	[3.9895000000E+04, 9.2179478612E+01, 1.4285606347E+01, 4.3113365369E+01, 9.6113558012E+00, 9.6626983640E-01],
	[3.9900000000E+04, 9.2199602456E+01, 1.4285697632E+01, 4.3130958453E+01, 9.6124899879E+00, 9.6628470237E-01],
	[3.9905000000E+04, 9.2219728171E+01, 1.4285788907E+01, 4.3148556509E+01, 9.6136238954E+00, 9.6629956104E-01],
	[3.9910000000E+04, 9.2239855757E+01, 1.4285880170E+01, 4.3166159535E+01, 9.6147575237E+00, 9.6631441240E-01],
	[3.9915000000E+04, 9.2259985214E+01, 1.4285971423E+01, 4.3183767534E+01, 9.6158908729E+00, 9.6632925646E-01],
	[3.9920000000E+04, 9.2280116541E+01, 1.4286062665E+01, 4.3201380506E+01, 9.6170239431E+00, 9.6634409322E-01],
	[3.9925000000E+04, 9.2300249739E+01, 1.4286153895E+01, 4.3218998451E+01, 9.6181567342E+00, 9.6635892269E-01],
	[3.9930000000E+04, 9.2320384808E+01, 1.4286245116E+01, 4.3236621372E+01, 9.6192892464E+00, 9.6637374487E-01],
	[3.9935000000E+04, 9.2340521747E+01, 1.4286336325E+01, 4.3254249267E+01, 9.6204214796E+00, 9.6638855977E-01],
	[3.9940000000E+04, 9.2360660556E+01, 1.4286427523E+01, 4.3271882138E+01, 9.6215534341E+00, 9.6640336738E-01],
	[3.9945000000E+04, 9.2380801236E+01, 1.4286518711E+01, 4.3289519987E+01, 9.6226851097E+00, 9.6641816771E-01],
	[3.9950000000E+04, 9.2400943786E+01, 1.4286609888E+01, 4.3307162813E+01, 9.6238165065E+00, 9.6643296077E-01],
	[3.9955000000E+04, 9.2421088206E+01, 1.4286701054E+01, 4.3324810617E+01, 9.6249476247E+00, 9.6644774656E-01],
	[3.9960000000E+04, 9.2441234496E+01, 1.4286792209E+01, 4.3342463401E+01, 9.6260784642E+00, 9.6646252507E-01],
	[3.9965000000E+04, 9.2461382656E+01, 1.4286883353E+01, 4.3360121164E+01, 9.6272090251E+00, 9.6647729632E-01],
	[3.9970000000E+04, 9.2481532687E+01, 1.4286974486E+01, 4.3377783909E+01, 9.6283393075E+00, 9.6649206031E-01],
	[3.9975000000E+04, 9.2501684587E+01, 1.4287065609E+01, 4.3395451634E+01, 9.6294693114E+00, 9.6650681704E-01],
	[3.9980000000E+04, 9.2521838357E+01, 1.4287156721E+01, 4.3413124343E+01, 9.6305990368E+00, 9.6652156652E-01],
	[3.9985000000E+04, 9.2541993997E+01, 1.4287247822E+01, 4.3430802034E+01, 9.6317284839E+00, 9.6653630874E-01],
	[3.9990000000E+04, 9.2562151507E+01, 1.4287338912E+01, 4.3448484709E+01, 9.6328576526E+00, 9.6655104372E-01],
	[3.9995000000E+04, 9.2582310887E+01, 1.4287429992E+01, 4.3466172369E+01, 9.6339865430E+00, 9.6656577145E-01],
	[4.0000000000E+04, 9.2602472136E+01, 1.4287521060E+01, 4.3483865015E+01, 9.6351151552E+00, 9.6658049194E-01],
	[4.0005000000E+04, 9.2622635255E+01, 1.4287612118E+01, 4.3501629717E+01, 9.6362467803E+00, 9.6659520520E-01],
	[4.0010000000E+04, 9.2642800244E+01, 1.4287703165E+01, 4.3519399453E+01, 9.6373781258E+00, 9.6660991122E-01],
	[4.0015000000E+04, 9.2662967101E+01, 1.4287794201E+01, 4.3537174223E+01, 9.6385091916E+00, 9.6662461001E-01],
	[4.0020000000E+04, 9.2683135829E+01, 1.4287885227E+01, 4.3554954028E+01, 9.6396399778E+00, 9.6663930157E-01],
	[4.0025000000E+04, 9.2703306426E+01, 1.4287976241E+01, 4.3572738870E+01, 9.6407704845E+00, 9.6665398591E-01],
	[4.0030000000E+04, 9.2723478892E+01, 1.4288067245E+01, 4.3590528748E+01, 9.6419007118E+00, 9.6666866303E-01],
	[4.0035000000E+04, 9.2743653227E+01, 1.4288158238E+01, 4.3608323663E+01, 9.6430306596E+00, 9.6668333294E-01],
	[4.0040000000E+04, 9.2763829431E+01, 1.4288249220E+01, 4.3626123617E+01, 9.6441603281E+00, 9.6669799563E-01],
	[4.0045000000E+04, 9.2784007505E+01, 1.4288340192E+01, 4.3643928610E+01, 9.6452897173E+00, 9.6671265111E-01],
	[4.0050000000E+04, 9.2804187447E+01, 1.4288431152E+01, 4.3661738643E+01, 9.6464188273E+00, 9.6672729938E-01],
	[4.0055000000E+04, 9.2824369259E+01, 1.4288522102E+01, 4.3679553716E+01, 9.6475476580E+00, 9.6674194046E-01],
	[4.0060000000E+04, 9.2844552940E+01, 1.4288613041E+01, 4.3697373831E+01, 9.6486762096E+00, 9.6675657433E-01],
	[4.0065000000E+04, 9.2864738489E+01, 1.4288703970E+01, 4.3715198988E+01, 9.6498044821E+00, 9.6677120101E-01],
	[4.0070000000E+04, 9.2884925907E+01, 1.4288794887E+01, 4.3733029189E+01, 9.6509324755E+00, 9.6678582049E-01],
	[4.0075000000E+04, 9.2905115194E+01, 1.4288885794E+01, 4.3750864433E+01, 9.6520601900E+00, 9.6680043279E-01],
	[4.0080000000E+04, 9.2925306350E+01, 1.4288976690E+01, 4.3768704722E+01, 9.6531876255E+00, 9.6681503790E-01],
	[4.0085000000E+04, 9.2945499375E+01, 1.4289067576E+01, 4.3786550056E+01, 9.6543147821E+00, 9.6682963583E-01],
	[4.0090000000E+04, 9.2965694268E+01, 1.4289158450E+01, 4.3804400437E+01, 9.6554416599E+00, 9.6684422659E-01],
	[4.0095000000E+04, 9.2985891029E+01, 1.4289249314E+01, 4.3822255865E+01, 9.6565682589E+00, 9.6685881016E-01],
	[4.0100000000E+04, 9.3006089659E+01, 1.4289340167E+01, 4.3840116340E+01, 9.6576945792E+00, 9.6687338657E-01],
	[4.0105000000E+04, 9.3026290157E+01, 1.4289431009E+01, 4.3857981864E+01, 9.6588206208E+00, 9.6688795581E-01],
	[4.0110000000E+04, 9.3046492524E+01, 1.4289521841E+01, 4.3875852438E+01, 9.6599463838E+00, 9.6690251789E-01],
	[4.0115000000E+04, 9.3066696759E+01, 1.4289612662E+01, 4.3893728062E+01, 9.6610718682E+00, 9.6691707280E-01],
	[4.0120000000E+04, 9.3086902862E+01, 1.4289703472E+01, 4.3911608737E+01, 9.6621970741E+00, 9.6693162056E-01],
	[4.0125000000E+04, 9.3107110834E+01, 1.4289794271E+01, 4.3929494464E+01, 9.6633220015E+00, 9.6694616116E-01],
	[4.0130000000E+04, 9.3127320673E+01, 1.4289885060E+01, 4.3947385243E+01, 9.6644466505E+00, 9.6696069462E-01],
	[4.0135000000E+04, 9.3147532381E+01, 1.4289975837E+01, 4.3965281076E+01, 9.6655710211E+00, 9.6697522092E-01],
	[4.0140000000E+04, 9.3167745956E+01, 1.4290066605E+01, 4.3983181964E+01, 9.6666951135E+00, 9.6698974009E-01],
	[4.0145000000E+04, 9.3187961399E+01, 1.4290157361E+01, 4.4001087906E+01, 9.6678189276E+00, 9.6700425211E-01],
	[4.0150000000E+04, 9.3208178711E+01, 1.4290248107E+01, 4.4018998904E+01, 9.6689424634E+00, 9.6701875700E-01],
	[4.0155000000E+04, 9.3228397890E+01, 1.4290338841E+01, 4.4036914958E+01, 9.6700657211E+00, 9.6703325475E-01],
	[4.0160000000E+04, 9.3248618937E+01, 1.4290429566E+01, 4.4054836071E+01, 9.6711887008E+00, 9.6704774538E-01],
	[4.0165000000E+04, 9.3268841851E+01, 1.4290520279E+01, 4.4072762241E+01, 9.6723114023E+00, 9.6706222888E-01],
	[4.0170000000E+04, 9.3289066633E+01, 1.4290610982E+01, 4.4090693470E+01, 9.6734338259E+00, 9.6707670526E-01],
	[4.0175000000E+04, 9.3309293283E+01, 1.4290701674E+01, 4.4108629759E+01, 9.6745559716E+00, 9.6709117452E-01],
	[4.0180000000E+04, 9.3329521800E+01, 1.4290792355E+01, 4.4126571109E+01, 9.6756778393E+00, 9.6710563666E-01],
	[4.0185000000E+04, 9.3349752185E+01, 1.4290883026E+01, 4.4144517520E+01, 9.6767994292E+00, 9.6712009169E-01],
	[4.0190000000E+04, 9.3369984437E+01, 1.4290973686E+01, 4.4162468993E+01, 9.6779207414E+00, 9.6713453962E-01],
	[4.0195000000E+04, 9.3390218556E+01, 1.4291064335E+01, 4.4180425530E+01, 9.6790417758E+00, 9.6714898043E-01],
	[4.0200000000E+04, 9.3410454542E+01, 1.4291154974E+01, 4.4198387130E+01, 9.6801625325E+00, 9.6716341415E-01],
	[4.0205000000E+04, 9.3430692396E+01, 1.4291245602E+01, 4.4216353795E+01, 9.6812830116E+00, 9.6717784077E-01],
	[4.0210000000E+04, 9.3450932117E+01, 1.4291336219E+01, 4.4234325525E+01, 9.6824032131E+00, 9.6719226029E-01],
	[4.0215000000E+04, 9.3471173705E+01, 1.4291426825E+01, 4.4252302321E+01, 9.6835231371E+00, 9.6720667273E-01],
	[4.0220000000E+04, 9.3491417160E+01, 1.4291517421E+01, 4.4270284184E+01, 9.6846427837E+00, 9.6722107807E-01],
	[4.0225000000E+04, 9.3511662482E+01, 1.4291608006E+01, 4.4288271115E+01, 9.6857621528E+00, 9.6723547634E-01],
	[4.0230000000E+04, 9.3531909671E+01, 1.4291698580E+01, 4.4306263115E+01, 9.6868812446E+00, 9.6724986752E-01],
	[4.0235000000E+04, 9.3552158727E+01, 1.4291789144E+01, 4.4324260184E+01, 9.6880000590E+00, 9.6726425162E-01],
	[4.0240000000E+04, 9.3572409649E+01, 1.4291879697E+01, 4.4342262323E+01, 9.6891185962E+00, 9.6727862865E-01],
	[4.0245000000E+04, 9.3592662438E+01, 1.4291970239E+01, 4.4360269533E+01, 9.6902368563E+00, 9.6729299862E-01],
	[4.0250000000E+04, 9.3612917094E+01, 1.4292060771E+01, 4.4378281815E+01, 9.6913548391E+00, 9.6730736151E-01],
	[4.0255000000E+04, 9.3633173617E+01, 1.4292151292E+01, 4.4396299170E+01, 9.6924725449E+00, 9.6732171734E-01],
	[4.0260000000E+04, 9.3653432006E+01, 1.4292241802E+01, 4.4414321597E+01, 9.6935899736E+00, 9.6733606611E-01],
	[4.0265000000E+04, 9.3673692261E+01, 1.4292332302E+01, 4.4432349099E+01, 9.6947071253E+00, 9.6735040783E-01],
	[4.0270000000E+04, 9.3693954383E+01, 1.4292422791E+01, 4.4450381676E+01, 9.6958240001E+00, 9.6736474249E-01],
	[4.0275000000E+04, 9.3714218371E+01, 1.4292513269E+01, 4.4468419329E+01, 9.6969405980E+00, 9.6737907011E-01],
	[4.0280000000E+04, 9.3734484226E+01, 1.4292603737E+01, 4.4486462058E+01, 9.6980569191E+00, 9.6739339067E-01],
	[4.0285000000E+04, 9.3754751947E+01, 1.4292694194E+01, 4.4504509865E+01, 9.6991729634E+00, 9.6740770420E-01],
	[4.0290000000E+04, 9.3775021534E+01, 1.4292784641E+01, 4.4522562750E+01, 9.7002887310E+00, 9.6742201069E-01],
	[4.0295000000E+04, 9.3795292987E+01, 1.4292875076E+01, 4.4540620713E+01, 9.7014042219E+00, 9.6743631014E-01],
	[4.0300000000E+04, 9.3815566306E+01, 1.4292965501E+01, 4.4558683757E+01, 9.7025194362E+00, 9.6745060256E-01],
	[4.0305000000E+04, 9.3835841491E+01, 1.4293055916E+01, 4.4576751881E+01, 9.7036343740E+00, 9.6746488795E-01],
	[4.0310000000E+04, 9.3856118543E+01, 1.4293146320E+01, 4.4594825086E+01, 9.7047490352E+00, 9.6747916632E-01],
	[4.0315000000E+04, 9.3876397460E+01, 1.4293236713E+01, 4.4612903373E+01, 9.7058634199E+00, 9.6749343766E-01],
	[4.0320000000E+04, 9.3896678242E+01, 1.4293327095E+01, 4.4630986744E+01, 9.7069775283E+00, 9.6750770199E-01],
	[4.0325000000E+04, 9.3916960891E+01, 1.4293417467E+01, 4.4649075198E+01, 9.7080913603E+00, 9.6752195931E-01],
	[4.0330000000E+04, 9.3937245405E+01, 1.4293507828E+01, 4.4667168736E+01, 9.7092049160E+00, 9.6753620961E-01],
	[4.0335000000E+04, 9.3957531785E+01, 1.4293598179E+01, 4.4685267360E+01, 9.7103181954E+00, 9.6755045290E-01],
	[4.0340000000E+04, 9.3977820031E+01, 1.4293688519E+01, 4.4703371070E+01, 9.7114311987E+00, 9.6756468919E-01],
	[4.0345000000E+04, 9.3998110142E+01, 1.4293778848E+01, 4.4721479867E+01, 9.7125439258E+00, 9.6757891848E-01],
	[4.0350000000E+04, 9.4018402118E+01, 1.4293869167E+01, 4.4739593752E+01, 9.7136563769E+00, 9.6759314078E-01],
	[4.0355000000E+04, 9.4038695960E+01, 1.4293959475E+01, 4.4757712725E+01, 9.7147685519E+00, 9.6760735608E-01],
	[4.0360000000E+04, 9.4058991668E+01, 1.4294049772E+01, 4.4775836787E+01, 9.7158804509E+00, 9.6762156439E-01],
	[4.0365000000E+04, 9.4079289240E+01, 1.4294140059E+01, 4.4793965940E+01, 9.7169920740E+00, 9.6763576571E-01],
	[4.0370000000E+04, 9.4099588678E+01, 1.4294230336E+01, 4.4812100183E+01, 9.7181034213E+00, 9.6764996005E-01],
	[4.0375000000E+04, 9.4119889981E+01, 1.4294320601E+01, 4.4830239519E+01, 9.7192144927E+00, 9.6766414741E-01],
	[4.0380000000E+04, 9.4140193149E+01, 1.4294410856E+01, 4.4848383946E+01, 9.7203252883E+00, 9.6767832780E-01],
	[4.0385000000E+04, 9.4160498182E+01, 1.4294501101E+01, 4.4866533467E+01, 9.7214358083E+00, 9.6769250121E-01],
	[4.0390000000E+04, 9.4180805080E+01, 1.4294591335E+01, 4.4884688082E+01, 9.7225460526E+00, 9.6770666765E-01],
	[4.0395000000E+04, 9.4201113843E+01, 1.4294681558E+01, 4.4902847792E+01, 9.7236560212E+00, 9.6772082713E-01],
	[4.0400000000E+04, 9.4221424471E+01, 1.4294771770E+01, 4.4921012598E+01, 9.7247657144E+00, 9.6773497964E-01],
	[4.0405000000E+04, 9.4241736964E+01, 1.4294861972E+01, 4.4939182500E+01, 9.7258751320E+00, 9.6774912520E-01],
	[4.0410000000E+04, 9.4262051322E+01, 1.4294952164E+01, 4.4957357499E+01, 9.7269842742E+00, 9.6776326380E-01],
	[4.0415000000E+04, 9.4282367544E+01, 1.4295042345E+01, 4.4975537597E+01, 9.7280931409E+00, 9.6777739545E-01],
	[4.0420000000E+04, 9.4302685630E+01, 1.4295132515E+01, 4.4993722793E+01, 9.7292017324E+00, 9.6779152015E-01],
	[4.0425000000E+04, 9.4323005582E+01, 1.4295222675E+01, 4.5011913089E+01, 9.7303100486E+00, 9.6780563790E-01],
	[4.0430000000E+04, 9.4343327398E+01, 1.4295312824E+01, 4.5030108486E+01, 9.7314180895E+00, 9.6781974871E-01],
	[4.0435000000E+04, 9.4363651078E+01, 1.4295402962E+01, 4.5048308984E+01, 9.7325258553E+00, 9.6783385259E-01],
	[4.0440000000E+04, 9.4383976623E+01, 1.4295493090E+01, 4.5066514584E+01, 9.7336333459E+00, 9.6784794953E-01],
	[4.0445000000E+04, 9.4404304032E+01, 1.4295583208E+01, 4.5084725286E+01, 9.7347405615E+00, 9.6786203954E-01],
	[4.0450000000E+04, 9.4424633305E+01, 1.4295673314E+01, 4.5102941093E+01, 9.7358475020E+00, 9.6787612262E-01],
	[4.0455000000E+04, 9.4444964443E+01, 1.4295763411E+01, 4.5121162004E+01, 9.7369541676E+00, 9.6789019878E-01],
	[4.0460000000E+04, 9.4465297444E+01, 1.4295853496E+01, 4.5139388020E+01, 9.7380605583E+00, 9.6790426802E-01],
	[4.0465000000E+04, 9.4485632310E+01, 1.4295943571E+01, 4.5157619142E+01, 9.7391666741E+00, 9.6791833034E-01],
	[4.0470000000E+04, 9.4505969040E+01, 1.4296033636E+01, 4.5175855371E+01, 9.7402725152E+00, 9.6793238575E-01],
	[4.0475000000E+04, 9.4526307634E+01, 1.4296123690E+01, 4.5194096708E+01, 9.7413780814E+00, 9.6794643424E-01],
	[4.0480000000E+04, 9.4546648092E+01, 1.4296213733E+01, 4.5212343153E+01, 9.7424833730E+00, 9.6796047583E-01],
	[4.0485000000E+04, 9.4566990413E+01, 1.4296303766E+01, 4.5230594708E+01, 9.7435883900E+00, 9.6797451052E-01],
	[4.0490000000E+04, 9.4587334598E+01, 1.4296393788E+01, 4.5248851372E+01, 9.7446931323E+00, 9.6798853830E-01],
	[4.0495000000E+04, 9.4607680648E+01, 1.4296483800E+01, 4.5267113148E+01, 9.7457976002E+00, 9.6800255919E-01],
	[4.0500000000E+04, 9.4628028560E+01, 1.4296573801E+01, 4.5285380035E+01, 9.7469017935E+00, 9.6801657319E-01],
	[4.0505000000E+04, 9.4648378337E+01, 1.4296663792E+01, 4.5303652034E+01, 9.7480057124E+00, 9.6803058030E-01],
	[4.0510000000E+04, 9.4668729977E+01, 1.4296753772E+01, 4.5321929147E+01, 9.7491093570E+00, 9.6804458052E-01],
	[4.0515000000E+04, 9.4689128101E+01, 1.4296849397E+01, 4.5340211374E+01, 9.7502158304E+00, 9.6805857386E-01],
	[4.0520000000E+04, 9.4709530120E+01, 1.4296945266E+01, 4.5358498715E+01, 9.7513221706E+00, 9.6807256032E-01],
	[4.0525000000E+04, 9.4729934016E+01, 1.4297041123E+01, 4.5376791173E+01, 9.7524282375E+00, 9.6808653990E-01],
	[4.0530000000E+04, 9.4750339790E+01, 1.4297136970E+01, 4.5395088746E+01, 9.7535340310E+00, 9.6810051262E-01],
	[4.0535000000E+04, 9.4770747441E+01, 1.4297232805E+01, 4.5413391437E+01, 9.7546395512E+00, 9.6811447846E-01],
	[4.0540000000E+04, 9.4791156970E+01, 1.4297328629E+01, 4.5431699246E+01, 9.7557447982E+00, 9.6812843744E-01],
	[4.0545000000E+04, 9.4811568376E+01, 1.4297424442E+01, 4.5450012174E+01, 9.7568497720E+00, 9.6814238955E-01],
	[4.0550000000E+04, 9.4831981660E+01, 1.4297520244E+01, 4.5468330222E+01, 9.7579544726E+00, 9.6815633481E-01],
	[4.0555000000E+04, 9.4852396821E+01, 1.4297616034E+01, 4.5486653390E+01, 9.7590589003E+00, 9.6817027322E-01],
	[4.0560000000E+04, 9.4872813859E+01, 1.4297711814E+01, 4.5504981679E+01, 9.7601630549E+00, 9.6818420477E-01],
	[4.0565000000E+04, 9.4893232775E+01, 1.4297807582E+01, 4.5523315090E+01, 9.7612669365E+00, 9.6819812947E-01],
	[4.0570000000E+04, 9.4913653568E+01, 1.4297903339E+01, 4.5541653624E+01, 9.7623705452E+00, 9.6821204733E-01],
	[4.0575000000E+04, 9.4934076238E+01, 1.4297999085E+01, 4.5559997282E+01, 9.7634738811E+00, 9.6822595835E-01],
	[4.0580000000E+04, 9.4954500785E+01, 1.4298094820E+01, 4.5578346064E+01, 9.7645769442E+00, 9.6823986253E-01],
	[4.0585000000E+04, 9.4974927209E+01, 1.4298190543E+01, 4.5596699971E+01, 9.7656797345E+00, 9.6825375988E-01],
	[4.0590000000E+04, 9.4995355509E+01, 1.4298286256E+01, 4.5615059004E+01, 9.7667822521E+00, 9.6826765039E-01],
	[4.0595000000E+04, 9.5015785687E+01, 1.4298381957E+01, 4.5633423165E+01, 9.7678844971E+00, 9.6828153408E-01],
	[4.0600000000E+04, 9.5036217742E+01, 1.4298477647E+01, 4.5651792452E+01, 9.7689864696E+00, 9.6829541095E-01],
	[4.0605000000E+04, 9.5056651673E+01, 1.4298573326E+01, 4.5670166869E+01, 9.7700881694E+00, 9.6830928099E-01],
	[4.0610000000E+04, 9.5077087481E+01, 1.4298668994E+01, 4.5688546414E+01, 9.7711895968E+00, 9.6832314422E-01],
	[4.0615000000E+04, 9.5097525166E+01, 1.4298764651E+01, 4.5706931090E+01, 9.7722907518E+00, 9.6833700063E-01],
	[4.0620000000E+04, 9.5117964727E+01, 1.4298860296E+01, 4.5725320896E+01, 9.7733916344E+00, 9.6835085024E-01],
	[4.0625000000E+04, 9.5138406165E+01, 1.4298955931E+01, 4.5743715834E+01, 9.7744922447E+00, 9.6836469304E-01],
	[4.0630000000E+04, 9.5158849479E+01, 1.4299051554E+01, 4.5762115904E+01, 9.7755925827E+00, 9.6837852903E-01],
	[4.0635000000E+04, 9.5179294670E+01, 1.4299147166E+01, 4.5780521108E+01, 9.7766926485E+00, 9.6839235823E-01],
	[4.0640000000E+04, 9.5199741737E+01, 1.4299242768E+01, 4.5798931445E+01, 9.7777924422E+00, 9.6840618062E-01],
	[4.0645000000E+04, 9.5220190680E+01, 1.4299338358E+01, 4.5817346918E+01, 9.7788919637E+00, 9.6841999623E-01],
	[4.0650000000E+04, 9.5240641500E+01, 1.4299433936E+01, 4.5835767526E+01, 9.7799912132E+00, 9.6843380505E-01],
	[4.0655000000E+04, 9.5261094195E+01, 1.4299529504E+01, 4.5854193270E+01, 9.7810901907E+00, 9.6844760708E-01],
	[4.0660000000E+04, 9.5281548767E+01, 1.4299625061E+01, 4.5872624152E+01, 9.7821888963E+00, 9.6846140233E-01],
	[4.0665000000E+04, 9.5302005215E+01, 1.4299720606E+01, 4.5891060172E+01, 9.7832873300E+00, 9.6847519080E-01],
	[4.0670000000E+04, 9.5322463539E+01, 1.4299816141E+01, 4.5909501330E+01, 9.7843854918E+00, 9.6848897249E-01],
	[4.0675000000E+04, 9.5342923739E+01, 1.4299911664E+01, 4.5927947628E+01, 9.7854833819E+00, 9.6850274742E-01],
	[4.0680000000E+04, 9.5363385814E+01, 1.4300007176E+01, 4.5946399067E+01, 9.7865810002E+00, 9.6851651557E-01],
	[4.0685000000E+04, 9.5383849766E+01, 1.4300102677E+01, 4.5964855647E+01, 9.7876783469E+00, 9.6853027696E-01],
	[4.0690000000E+04, 9.5404315593E+01, 1.4300198167E+01, 4.5983317368E+01, 9.7887754219E+00, 9.6854403159E-01],
	[4.0695000000E+04, 9.5424783296E+01, 1.4300293646E+01, 4.6001784233E+01, 9.7898722254E+00, 9.6855777946E-01],
	[4.0700000000E+04, 9.5445252875E+01, 1.4300389114E+01, 4.6020256241E+01, 9.7909687574E+00, 9.6857152057E-01],
	[4.0705000000E+04, 9.5465724329E+01, 1.4300484571E+01, 4.6038733394E+01, 9.7920650179E+00, 9.6858525493E-01],
	[4.0710000000E+04, 9.5486197659E+01, 1.4300580016E+01, 4.6057215691E+01, 9.7931610070E+00, 9.6859898255E-01],
	[4.0715000000E+04, 9.5506672864E+01, 1.4300675451E+01, 4.6075703135E+01, 9.7942567248E+00, 9.6861270342E-01],
	[4.0720000000E+04, 9.5527149944E+01, 1.4300770874E+01, 4.6094195726E+01, 9.7953521712E+00, 9.6862641755E-01],
	[4.0725000000E+04, 9.5547628900E+01, 1.4300866287E+01, 4.6112693464E+01, 9.7964473465E+00, 9.6864012494E-01],
	[4.0730000000E+04, 9.5568109732E+01, 1.4300961688E+01, 4.6131196351E+01, 9.7975422505E+00, 9.6865382560E-01],
	[4.0735000000E+04, 9.5588592438E+01, 1.4301057078E+01, 4.6149704386E+01, 9.7986368834E+00, 9.6866751953E-01],
	[4.0740000000E+04, 9.5609077020E+01, 1.4301152457E+01, 4.6168217572E+01, 9.7997312452E+00, 9.6868120673E-01],
	[4.0745000000E+04, 9.5629563476E+01, 1.4301247825E+01, 4.6186735909E+01, 9.8008253360E+00, 9.6869488720E-01],
	[4.0750000000E+04, 9.5650051808E+01, 1.4301343182E+01, 4.6205259397E+01, 9.8019191559E+00, 9.6870856096E-01],
	[4.0755000000E+04, 9.5670542015E+01, 1.4301438528E+01, 4.6223788038E+01, 9.8030127048E+00, 9.6872222800E-01],
	[4.0760000000E+04, 9.5691034097E+01, 1.4301533863E+01, 4.6242321832E+01, 9.8041059828E+00, 9.6873588832E-01],
	[4.0765000000E+04, 9.5711528054E+01, 1.4301629187E+01, 4.6260860780E+01, 9.8051989901E+00, 9.6874954194E-01],
	[4.0770000000E+04, 9.5732023885E+01, 1.4301724500E+01, 4.6279404882E+01, 9.8062917265E+00, 9.6876318884E-01],
	[4.0775000000E+04, 9.5752521591E+01, 1.4301819802E+01, 4.6297954141E+01, 9.8073841923E+00, 9.6877682905E-01],
	[4.0780000000E+04, 9.5773021172E+01, 1.4301915092E+01, 4.6316508555E+01, 9.8084763875E+00, 9.6879046256E-01],
	[4.0785000000E+04, 9.5793522628E+01, 1.4302010372E+01, 4.6335068127E+01, 9.8095683120E+00, 9.6880408936E-01],
	[4.0790000000E+04, 9.5814025958E+01, 1.4302105640E+01, 4.6353632857E+01, 9.8106599660E+00, 9.6881770948E-01],
	[4.0795000000E+04, 9.5834531163E+01, 1.4302200898E+01, 4.6372202746E+01, 9.8117513496E+00, 9.6883132291E-01],
	[4.0800000000E+04, 9.5855038242E+01, 1.4302296145E+01, 4.6390777794E+01, 9.8128424627E+00, 9.6884492965E-01],
	[4.0805000000E+04, 9.5875547196E+01, 1.4302391380E+01, 4.6409358003E+01, 9.8139333054E+00, 9.6885852971E-01],
	[4.0810000000E+04, 9.5896058024E+01, 1.4302486604E+01, 4.6427943373E+01, 9.8150238778E+00, 9.6887212308E-01],
	[4.0815000000E+04, 9.5916570726E+01, 1.4302581818E+01, 4.6446533905E+01, 9.8161141799E+00, 9.6888570979E-01],
	[4.0820000000E+04, 9.5937085303E+01, 1.4302677020E+01, 4.6465129599E+01, 9.8172042118E+00, 9.6889928982E-01],
	[4.0825000000E+04, 9.5957601753E+01, 1.4302772211E+01, 4.6483730458E+01, 9.8182939736E+00, 9.6891286318E-01],
	[4.0830000000E+04, 9.5978120078E+01, 1.4302867392E+01, 4.6502336480E+01, 9.8193834653E+00, 9.6892642988E-01],
	[4.0835000000E+04, 9.5998640277E+01, 1.4302962561E+01, 4.6520947668E+01, 9.8204726869E+00, 9.6893998991E-01],
	[4.0840000000E+04, 9.6019162350E+01, 1.4303057719E+01, 4.6539564022E+01, 9.8215616385E+00, 9.6895354329E-01],
	[4.0845000000E+04, 9.6039686297E+01, 1.4303152867E+01, 4.6558185543E+01, 9.8226503202E+00, 9.6896709001E-01],
	[4.0850000000E+04, 9.6060212118E+01, 1.4303248003E+01, 4.6576812231E+01, 9.8237387319E+00, 9.6898063007E-01],
	[4.0855000000E+04, 9.6080739812E+01, 1.4303343128E+01, 4.6595444088E+01, 9.8248268739E+00, 9.6899416350E-01],
	[4.0860000000E+04, 9.6101269381E+01, 1.4303438242E+01, 4.6614081114E+01, 9.8259147461E+00, 9.6900769027E-01],
	[4.0865000000E+04, 9.6121800823E+01, 1.4303533346E+01, 4.6632723310E+01, 9.8270023485E+00, 9.6902121040E-01],
	[4.0870000000E+04, 9.6142334138E+01, 1.4303628438E+01, 4.6651370677E+01, 9.8280896813E+00, 9.6903472390E-01],
	[4.0875000000E+04, 9.6162869328E+01, 1.4303723519E+01, 4.6670023215E+01, 9.8291767445E+00, 9.6904823076E-01],
	[4.0880000000E+04, 9.6183406391E+01, 1.4303818589E+01, 4.6688680926E+01, 9.8302635381E+00, 9.6906173099E-01],
	[4.0885000000E+04, 9.6203945327E+01, 1.4303913648E+01, 4.6707343810E+01, 9.8313500622E+00, 9.6907522459E-01],
	[4.0890000000E+04, 9.6224486137E+01, 1.4304008697E+01, 4.6726011868E+01, 9.8324363168E+00, 9.6908871157E-01],
	[4.0895000000E+04, 9.6245028820E+01, 1.4304103734E+01, 4.6744685101E+01, 9.8335223021E+00, 9.6910219193E-01],
	[4.0900000000E+04, 9.6265573376E+01, 1.4304198760E+01, 4.6763363509E+01, 9.8346080180E+00, 9.6911566567E-01],
	[4.0905000000E+04, 9.6286119806E+01, 1.4304293775E+01, 4.6782047094E+01, 9.8356934646E+00, 9.6912913279E-01],
	[4.0910000000E+04, 9.6306668109E+01, 1.4304388780E+01, 4.6800735856E+01, 9.8367786420E+00, 9.6914259330E-01],
	[4.0915000000E+04, 9.6327218285E+01, 1.4304483773E+01, 4.6819429796E+01, 9.8378635502E+00, 9.6915604721E-01],
	[4.0920000000E+04, 9.6347770334E+01, 1.4304578755E+01, 4.6838128915E+01, 9.8389481892E+00, 9.6916949451E-01],
	[4.0925000000E+04, 9.6368324256E+01, 1.4304673727E+01, 4.6856833213E+01, 9.8400325593E+00, 9.6918293522E-01],
	[4.0930000000E+04, 9.6388880051E+01, 1.4304768687E+01, 4.6875542692E+01, 9.8411166602E+00, 9.6919636932E-01],
	[4.0935000000E+04, 9.6409437719E+01, 1.4304863636E+01, 4.6894257352E+01, 9.8422004923E+00, 9.6920979683E-01],
	[4.0940000000E+04, 9.6429997260E+01, 1.4304958575E+01, 4.6912977195E+01, 9.8432840554E+00, 9.6922321775E-01],
	[4.0945000000E+04, 9.6450558674E+01, 1.4305053502E+01, 4.6931702220E+01, 9.8443673497E+00, 9.6923663209E-01],
	[4.0950000000E+04, 9.6471121960E+01, 1.4305148419E+01, 4.6950432428E+01, 9.8454503751E+00, 9.6925003984E-01],
	[4.0955000000E+04, 9.6491687119E+01, 1.4305243324E+01, 4.6969167821E+01, 9.8465331319E+00, 9.6926344101E-01],
	[4.0960000000E+04, 9.6512254151E+01, 1.4305338219E+01, 4.6987908399E+01, 9.8476156199E+00, 9.6927683561E-01],
	[4.0965000000E+04, 9.6532823055E+01, 1.4305433103E+01, 4.7006654163E+01, 9.8486978393E+00, 9.6929022363E-01],
	[4.0970000000E+04, 9.6553393832E+01, 1.4305527975E+01, 4.7025405114E+01, 9.8497797901E+00, 9.6930360508E-01],
	[4.0975000000E+04, 9.6573966481E+01, 1.4305622837E+01, 4.7044161253E+01, 9.8508614724E+00, 9.6931697996E-01],
	[4.0980000000E+04, 9.6594541002E+01, 1.4305717688E+01, 4.7062922580E+01, 9.8519428863E+00, 9.6933034829E-01],
	[4.0985000000E+04, 9.6615117396E+01, 1.4305812528E+01, 4.7081689096E+01, 9.8530240317E+00, 9.6934371005E-01],
	[4.0990000000E+04, 9.6635695662E+01, 1.4305907357E+01, 4.7100460803E+01, 9.8541049088E+00, 9.6935706525E-01],
	[4.0995000000E+04, 9.6656275801E+01, 1.4306002175E+01, 4.7119237700E+01, 9.8551855175E+00, 9.6937041391E-01],
	[4.1000000000E+04, 9.6676857811E+01, 1.4306096982E+01, 4.7138019789E+01, 9.8562658580E+00, 9.6938375601E-01],
	[4.1005000000E+04, 9.6697441694E+01, 1.4306191778E+01, 4.7156807070E+01, 9.8573459303E+00, 9.6939709157E-01],
	[4.1010000000E+04, 9.6718027448E+01, 1.4306286563E+01, 4.7175599544E+01, 9.8584257345E+00, 9.6941042059E-01],
	[4.1015000000E+04, 9.6738615075E+01, 1.4306381337E+01, 4.7194397213E+01, 9.8595052705E+00, 9.6942374306E-01],
	[4.1020000000E+04, 9.6759204573E+01, 1.4306476101E+01, 4.7213200076E+01, 9.8605845386E+00, 9.6943705900E-01],
	[4.1025000000E+04, 9.6779795943E+01, 1.4306570853E+01, 4.7232008135E+01, 9.8616635386E+00, 9.6945036841E-01],
	[4.1030000000E+04, 9.6800389185E+01, 1.4306665594E+01, 4.7250821390E+01, 9.8627422708E+00, 9.6946367129E-01],
	[4.1035000000E+04, 9.6820984299E+01, 1.4306760325E+01, 4.7269639843E+01, 9.8638207351E+00, 9.6947696764E-01],
	[4.1040000000E+04, 9.6841581285E+01, 1.4306855045E+01, 4.7288463493E+01, 9.8648989315E+00, 9.6949025748E-01],
	[4.1045000000E+04, 9.6862180142E+01, 1.4306949753E+01, 4.7307292342E+01, 9.8659768602E+00, 9.6950354079E-01],
	[4.1050000000E+04, 9.6882780871E+01, 1.4307044451E+01, 4.7326126392E+01, 9.8670545212E+00, 9.6951681759E-01],
	[4.1055000000E+04, 9.6903383471E+01, 1.4307139138E+01, 4.7344965641E+01, 9.8681319146E+00, 9.6953008787E-01],
	[4.1060000000E+04, 9.6923987942E+01, 1.4307233814E+01, 4.7363810092E+01, 9.8692090403E+00, 9.6954335165E-01],
	[4.1065000000E+04, 9.6944594286E+01, 1.4307328479E+01, 4.7382659744E+01, 9.8702858985E+00, 9.6955660892E-01],
	[4.1070000000E+04, 9.6965202500E+01, 1.4307423134E+01, 4.7401514600E+01, 9.8713624893E+00, 9.6956985969E-01],
	[4.1075000000E+04, 9.6985812586E+01, 1.4307517777E+01, 4.7420374659E+01, 9.8724388126E+00, 9.6958310396E-01],
	[4.1080000000E+04, 9.7006424542E+01, 1.4307612409E+01, 4.7439239923E+01, 9.8735148685E+00, 9.6959634174E-01],
	[4.1085000000E+04, 9.7027038371E+01, 1.4307707031E+01, 4.7458110392E+01, 9.8745906571E+00, 9.6960957302E-01],
	[4.1090000000E+04, 9.7047654070E+01, 1.4307801641E+01, 4.7476986067E+01, 9.8756661784E+00, 9.6962279782E-01],
	[4.1095000000E+04, 9.7068271640E+01, 1.4307896241E+01, 4.7495866949E+01, 9.8767414326E+00, 9.6963601613E-01],
	[4.1100000000E+04, 9.7088891081E+01, 1.4307990830E+01, 4.7514753038E+01, 9.8778164196E+00, 9.6964922796E-01],
	[4.1105000000E+04, 9.7109512393E+01, 1.4308085408E+01, 4.7533644336E+01, 9.8788911394E+00, 9.6966243331E-01],
	[4.1110000000E+04, 9.7130135576E+01, 1.4308179975E+01, 4.7552540843E+01, 9.8799655923E+00, 9.6967563219E-01],
	[4.1115000000E+04, 9.7150760630E+01, 1.4308274531E+01, 4.7571442560E+01, 9.8810397781E+00, 9.6968882459E-01],
	[4.1120000000E+04, 9.7171387555E+01, 1.4308369077E+01, 4.7590349489E+01, 9.8821136970E+00, 9.6970201053E-01],
	[4.1125000000E+04, 9.7192016350E+01, 1.4308463611E+01, 4.7609261628E+01, 9.8831873491E+00, 9.6971519001E-01],
	[4.1130000000E+04, 9.7212647016E+01, 1.4308558135E+01, 4.7628178980E+01, 9.8842607343E+00, 9.6972836302E-01],
	[4.1135000000E+04, 9.7233279552E+01, 1.4308652648E+01, 4.7647101546E+01, 9.8853338527E+00, 9.6974152957E-01],
	[4.1140000000E+04, 9.7253913959E+01, 1.4308747150E+01, 4.7666029325E+01, 9.8864067044E+00, 9.6975468967E-01],
	[4.1145000000E+04, 9.7274550237E+01, 1.4308841641E+01, 4.7684962320E+01, 9.8874792895E+00, 9.6976784332E-01],
	[4.1150000000E+04, 9.7295188384E+01, 1.4308936121E+01, 4.7703900530E+01, 9.8885516080E+00, 9.6978099052E-01],
	[4.1155000000E+04, 9.7315828403E+01, 1.4309030590E+01, 4.7722843956E+01, 9.8896236599E+00, 9.6979413128E-01],
	[4.1160000000E+04, 9.7336470291E+01, 1.4309125049E+01, 4.7741792600E+01, 9.8906954453E+00, 9.6980726560E-01],
	[4.1165000000E+04, 9.7357138383E+01, 1.4309222533E+01, 4.7760746462E+01, 9.8917686665E+00, 9.6982039347E-01],
	[4.1170000000E+04, 9.7377830381E+01, 1.4309322754E+01, 4.7779705543E+01, 9.8928431628E+00, 9.6983351492E-01],
	[4.1175000000E+04, 9.7398524264E+01, 1.4309422964E+01, 4.7798669843E+01, 9.8939173936E+00, 9.6984662993E-01],
	[4.1180000000E+04, 9.7419220030E+01, 1.4309523162E+01, 4.7817639364E+01, 9.8949913588E+00, 9.6985973852E-01],
	[4.1185000000E+04, 9.7439917680E+01, 1.4309623349E+01, 4.7836614106E+01, 9.8960650586E+00, 9.6987284068E-01],
	[4.1190000000E+04, 9.7460617215E+01, 1.4309723525E+01, 4.7855594070E+01, 9.8971384930E+00, 9.6988593642E-01],
	[4.1195000000E+04, 9.7481318633E+01, 1.4309823689E+01, 4.7874579257E+01, 9.8982116620E+00, 9.6989902575E-01],
	[4.1200000000E+04, 9.7502021935E+01, 1.4309923841E+01, 4.7893569668E+01, 9.8992845658E+00, 9.6991210866E-01],
	[4.1205000000E+04, 9.7522727121E+01, 1.4310023983E+01, 4.7912565303E+01, 9.9003572043E+00, 9.6992518516E-01],
	[4.1210000000E+04, 9.7543434191E+01, 1.4310124112E+01, 4.7931566164E+01, 9.9014295777E+00, 9.6993825525E-01],
	[4.1215000000E+04, 9.7564143145E+01, 1.4310224230E+01, 4.7950572251E+01, 9.9025016859E+00, 9.6995131894E-01],
	[4.1220000000E+04, 9.7584853982E+01, 1.4310324337E+01, 4.7969583564E+01, 9.9035735291E+00, 9.6996437623E-01],
	[4.1225000000E+04, 9.7605566703E+01, 1.4310424433E+01, 4.7988600105E+01, 9.9046451072E+00, 9.6997742712E-01],
	[4.1230000000E+04, 9.7626281307E+01, 1.4310524516E+01, 4.8007621875E+01, 9.9057164205E+00, 9.6999047162E-01],
	[4.1235000000E+04, 9.7646997795E+01, 1.4310624589E+01, 4.8026648874E+01, 9.9067874688E+00, 9.7000350973E-01],
	[4.1240000000E+04, 9.7667716166E+01, 1.4310724650E+01, 4.8045681103E+01, 9.9078582522E+00, 9.7001654145E-01],
	[4.1245000000E+04, 9.7688436421E+01, 1.4310824700E+01, 4.8064718563E+01, 9.9089287709E+00, 9.7002956678E-01],
	[4.1250000000E+04, 9.7709158559E+01, 1.4310924738E+01, 4.8083761255E+01, 9.9099990248E+00, 9.7004258574E-01],
	[4.1255000000E+04, 9.7729882580E+01, 1.4311024764E+01, 4.8102809179E+01, 9.9110690141E+00, 9.7005559832E-01],
	[4.1260000000E+04, 9.7750608484E+01, 1.4311124780E+01, 4.8121862337E+01, 9.9121387387E+00, 9.7006860453E-01],
	[4.1265000000E+04, 9.7771336272E+01, 1.4311224784E+01, 4.8140920729E+01, 9.9132081988E+00, 9.7008160436E-01],
	[4.1270000000E+04, 9.7792065943E+01, 1.4311324776E+01, 4.8159984355E+01, 9.9142773943E+00, 9.7009459783E-01],
	[4.1275000000E+04, 9.7812797496E+01, 1.4311424757E+01, 4.8179053217E+01, 9.9153463254E+00, 9.7010758494E-01],
	[4.1280000000E+04, 9.7833530933E+01, 1.4311524727E+01, 4.8198127316E+01, 9.9164149921E+00, 9.7012056568E-01],
	[4.1285000000E+04, 9.7854266252E+01, 1.4311624685E+01, 4.8217206652E+01, 9.9174833944E+00, 9.7013354007E-01],
	[4.1290000000E+04, 9.7875003455E+01, 1.4311724632E+01, 4.8236291227E+01, 9.9185515324E+00, 9.7014650811E-01],
	[4.1295000000E+04, 9.7895742540E+01, 1.4311824567E+01, 4.8255381040E+01, 9.9196194062E+00, 9.7015946979E-01],
	[4.1300000000E+04, 9.7916483508E+01, 1.4311924491E+01, 4.8274476093E+01, 9.9206870158E+00, 9.7017242513E-01],
	[4.1305000000E+04, 9.7937226359E+01, 1.4312024404E+01, 4.8293576386E+01, 9.9217543613E+00, 9.7018537413E-01],
	[4.1310000000E+04, 9.7957971092E+01, 1.4312124305E+01, 4.8312681921E+01, 9.9228214427E+00, 9.7019831678E-01],
	[4.1315000000E+04, 9.7978717708E+01, 1.4312224195E+01, 4.8331792698E+01, 9.9238882601E+00, 9.7021125310E-01],
	[4.1320000000E+04, 9.7999466206E+01, 1.4312324074E+01, 4.8350908718E+01, 9.9249548134E+00, 9.7022418309E-01],
	[4.1325000000E+04, 9.8020216587E+01, 1.4312423941E+01, 4.8370029981E+01, 9.9260211029E+00, 9.7023710674E-01],
	[4.1330000000E+04, 9.8040968850E+01, 1.4312523796E+01, 4.8389156489E+01, 9.9270871286E+00, 9.7025002407E-01],
	[4.1335000000E+04, 9.8061722996E+01, 1.4312623641E+01, 4.8408288243E+01, 9.9281528904E+00, 9.7026293508E-01],
	[4.1340000000E+04, 9.8082479023E+01, 1.4312723474E+01, 4.8427425243E+01, 9.9292183885E+00, 9.7027583976E-01],
	[4.1345000000E+04, 9.8103236934E+01, 1.4312823295E+01, 4.8446567489E+01, 9.9302836229E+00, 9.7028873813E-01],
	[4.1350000000E+04, 9.8123996726E+01, 1.4312923105E+01, 4.8465714984E+01, 9.9313485936E+00, 9.7030163019E-01],
	[4.1355000000E+04, 9.8144758400E+01, 1.4313022904E+01, 4.8484867726E+01, 9.9324133008E+00, 9.7031451594E-01],
	[4.1360000000E+04, 9.8165521957E+01, 1.4313122691E+01, 4.8504025719E+01, 9.9334777444E+00, 9.7032739538E-01],
	[4.1365000000E+04, 9.8186287395E+01, 1.4313222467E+01, 4.8523188961E+01, 9.9345419246E+00, 9.7034026851E-01],
	[4.1370000000E+04, 9.8207054715E+01, 1.4313322232E+01, 4.8542357454E+01, 9.9356058413E+00, 9.7035313535E-01],
	[4.1375000000E+04, 9.8227823918E+01, 1.4313421985E+01, 4.8561531200E+01, 9.9366694947E+00, 9.7036599589E-01],
	[4.1380000000E+04, 9.8248595002E+01, 1.4313521727E+01, 4.8580710197E+01, 9.9377328848E+00, 9.7037885014E-01],
	[4.1385000000E+04, 9.8269367968E+01, 1.4313621458E+01, 4.8599894449E+01, 9.9387960117E+00, 9.7039169809E-01],
	[4.1390000000E+04, 9.8290142815E+01, 1.4313721177E+01, 4.8619083954E+01, 9.9398588753E+00, 9.7040453976E-01],
	[4.1395000000E+04, 9.8310919544E+01, 1.4313820885E+01, 4.8638278714E+01, 9.9409214758E+00, 9.7041737515E-01],
	[4.1400000000E+04, 9.8331698155E+01, 1.4313920582E+01, 4.8657478730E+01, 9.9419838132E+00, 9.7043020426E-01],
	[4.1405000000E+04, 9.8352478648E+01, 1.4314020267E+01, 4.8676684003E+01, 9.9430458876E+00, 9.7044302709E-01],
	[4.1410000000E+04, 9.8373261022E+01, 1.4314119941E+01, 4.8695894533E+01, 9.9441076990E+00, 9.7045584365E-01],
	[4.1415000000E+04, 9.8394045277E+01, 1.4314219603E+01, 4.8715110321E+01, 9.9451692475E+00, 9.7046865394E-01],
	[4.1420000000E+04, 9.8414831414E+01, 1.4314319255E+01, 4.8734331368E+01, 9.9462305331E+00, 9.7048145796E-01],
	[4.1425000000E+04, 9.8435619432E+01, 1.4314418894E+01, 4.8753557675E+01, 9.9472915559E+00, 9.7049425572E-01],
	[4.1430000000E+04, 9.8456409331E+01, 1.4314518523E+01, 4.8772789243E+01, 9.9483523159E+00, 9.7050704722E-01],
	[4.1435000000E+04, 9.8477201112E+01, 1.4314618140E+01, 4.8792026072E+01, 9.9494128133E+00, 9.7051983246E-01],
	[4.1440000000E+04, 9.8497994773E+01, 1.4314717746E+01, 4.8811268163E+01, 9.9504730480E+00, 9.7053261145E-01],
	[4.1445000000E+04, 9.8518790316E+01, 1.4314817341E+01, 4.8830515517E+01, 9.9515330201E+00, 9.7054538419E-01],
	[4.1450000000E+04, 9.8539587740E+01, 1.4314916924E+01, 4.8849768136E+01, 9.9525927297E+00, 9.7055815068E-01],
	[4.1455000000E+04, 9.8560387044E+01, 1.4315016496E+01, 4.8869026018E+01, 9.9536521768E+00, 9.7057091093E-01],
	[4.1460000000E+04, 9.8581188230E+01, 1.4315116056E+01, 4.8888289166E+01, 9.9547113615E+00, 9.7058366494E-01],
	[4.1465000000E+04, 9.8601991297E+01, 1.4315215606E+01, 4.8907557581E+01, 9.9557702838E+00, 9.7059641272E-01],
	[4.1470000000E+04, 9.8622796244E+01, 1.4315315143E+01, 4.8926831262E+01, 9.9568289438E+00, 9.7060915426E-01],
	[4.1475000000E+04, 9.8643603072E+01, 1.4315414670E+01, 4.8946110211E+01, 9.9578873415E+00, 9.7062188957E-01],
	[4.1480000000E+04, 9.8664411781E+01, 1.4315514185E+01, 4.8965394429E+01, 9.9589454771E+00, 9.7063461865E-01],
	[4.1485000000E+04, 9.8685222370E+01, 1.4315613689E+01, 4.8984683916E+01, 9.9600033505E+00, 9.7064734151E-01],
	[4.1490000000E+04, 9.8706034840E+01, 1.4315713182E+01, 4.9003978674E+01, 9.9610609618E+00, 9.7066005815E-01],
	[4.1495000000E+04, 9.8726849191E+01, 1.4315812664E+01, 4.9023278702E+01, 9.9621183110E+00, 9.7067276857E-01],
	[4.1500000000E+04, 9.8747665422E+01, 1.4315912134E+01, 4.9042584003E+01, 9.9631753983E+00, 9.7068547278E-01],
	[4.1505000000E+04, 9.8768483533E+01, 1.4316011593E+01, 4.9061894576E+01, 9.9642322237E+00, 9.7069817078E-01],
	[4.1510000000E+04, 9.8789303525E+01, 1.4316111040E+01, 4.9081210422E+01, 9.9652887871E+00, 9.7071086258E-01],
	[4.1515000000E+04, 9.8810125397E+01, 1.4316210477E+01, 4.9100531543E+01, 9.9663450888E+00, 9.7072354817E-01],
	[4.1520000000E+04, 9.8830949150E+01, 1.4316309902E+01, 4.9119857939E+01, 9.9674011287E+00, 9.7073622756E-01],
	[4.1525000000E+04, 9.8851774782E+01, 1.4316409315E+01, 4.9139189611E+01, 9.9684569069E+00, 9.7074890075E-01],
	[4.1530000000E+04, 9.8872602295E+01, 1.4316508718E+01, 4.9158526559E+01, 9.9695124235E+00, 9.7076156775E-01],
	[4.1535000000E+04, 9.8893431687E+01, 1.4316608109E+01, 4.9177868785E+01, 9.9705676785E+00, 9.7077422856E-01],
	[4.1540000000E+04, 9.8914262960E+01, 1.4316707489E+01, 4.9197216289E+01, 9.9716226719E+00, 9.7078688318E-01],
	[4.1545000000E+04, 9.8935096113E+01, 1.4316806857E+01, 4.9216569072E+01, 9.9726774038E+00, 9.7079953162E-01],
	[4.1550000000E+04, 9.8955931145E+01, 1.4316906215E+01, 4.9235927136E+01, 9.9737318743E+00, 9.7081217388E-01],
	[4.1555000000E+04, 9.8976768058E+01, 1.4317005561E+01, 4.9255290479E+01, 9.9747860835E+00, 9.7082480996E-01],
	[4.1560000000E+04, 9.8997606850E+01, 1.4317104896E+01, 4.9274659105E+01, 9.9758400313E+00, 9.7083743987E-01],
	[4.1565000000E+04, 9.9018447522E+01, 1.4317204219E+01, 4.9294033012E+01, 9.9768937179E+00, 9.7085006361E-01],
	[4.1570000000E+04, 9.9039290074E+01, 1.4317303531E+01, 4.9313412203E+01, 9.9779471432E+00, 9.7086268118E-01],
	[4.1575000000E+04, 9.9060134505E+01, 1.4317402832E+01, 4.9332796677E+01, 9.9790003074E+00, 9.7087529259E-01],
	[4.1580000000E+04, 9.9080980816E+01, 1.4317502122E+01, 4.9352186437E+01, 9.9800532106E+00, 9.7088789784E-01],
	[4.1585000000E+04, 9.9101829006E+01, 1.4317601401E+01, 4.9371581482E+01, 9.9811058526E+00, 9.7090049693E-01],
	[4.1590000000E+04, 9.9122679076E+01, 1.4317700668E+01, 4.9390981813E+01, 9.9821582337E+00, 9.7091308986E-01],
	[4.1595000000E+04, 9.9143531025E+01, 1.4317799924E+01, 4.9410387431E+01, 9.9832103539E+00, 9.7092567665E-01],
	[4.1600000000E+04, 9.9164384854E+01, 1.4317899169E+01, 4.9429798337E+01, 9.9842622132E+00, 9.7093825729E-01],
	[4.1605000000E+04, 9.9185240561E+01, 1.4317998402E+01, 4.9449214532E+01, 9.9853138116E+00, 9.7095083178E-01],
	[4.1610000000E+04, 9.9206098148E+01, 1.4318097625E+01, 4.9468636017E+01, 9.9863651494E+00, 9.7096340013E-01],
	[4.1615000000E+04, 9.9226957614E+01, 1.4318196836E+01, 4.9488062791E+01, 9.9874162264E+00, 9.7097596235E-01],
	[4.1620000000E+04, 9.9247818960E+01, 1.4318296036E+01, 4.9507494857E+01, 9.9884670427E+00, 9.7098851843E-01],
	[4.1625000000E+04, 9.9268682184E+01, 1.4318395224E+01, 4.9526932215E+01, 9.9895175985E+00, 9.7100106838E-01],
	[4.1630000000E+04, 9.9289547287E+01, 1.4318494402E+01, 4.9546374866E+01, 9.9905678937E+00, 9.7101361221E-01],
	[4.1635000000E+04, 9.9310414270E+01, 1.4318593568E+01, 4.9565822810E+01, 9.9916179284E+00, 9.7102614991E-01],
	[4.1640000000E+04, 9.9331283131E+01, 1.4318692723E+01, 4.9585276049E+01, 9.9926677028E+00, 9.7103868148E-01],
	[4.1645000000E+04, 9.9352153871E+01, 1.4318791867E+01, 4.9604734582E+01, 9.9937172167E+00, 9.7105120695E-01],
	[4.1650000000E+04, 9.9373026490E+01, 1.4318890999E+01, 4.9624198412E+01, 9.9947664703E+00, 9.7106372629E-01],
	[4.1655000000E+04, 9.9393900987E+01, 1.4318990120E+01, 4.9643667538E+01, 9.9958154637E+00, 9.7107623953E-01],
	[4.1660000000E+04, 9.9414777363E+01, 1.4319089230E+01, 4.9663141962E+01, 9.9968641968E+00, 9.7108874665E-01],
	[4.1665000000E+04, 9.9435655618E+01, 1.4319188329E+01, 4.9682621685E+01, 9.9979126698E+00, 9.7110124768E-01],
	[4.1670000000E+04, 9.9456535751E+01, 1.4319287417E+01, 4.9702106706E+01, 9.9989608827E+00, 9.7111374260E-01],
	[4.1675000000E+04, 9.9477417763E+01, 1.4319386493E+01, 4.9721597028E+01, 1.0000008836E+01, 9.7112623142E-01],
	[4.1680000000E+04, 9.9498301653E+01, 1.4319485559E+01, 4.9741092650E+01, 1.0001056528E+01, 9.7113871415E-01],
	[4.1685000000E+04, 9.9519187422E+01, 1.4319584613E+01, 4.9760593574E+01, 1.0002103961E+01, 9.7115119079E-01],
	[4.1690000000E+04, 9.9540075069E+01, 1.4319683656E+01, 4.9780099801E+01, 1.0003151135E+01, 9.7116366134E-01],
	[4.1695000000E+04, 9.9560964594E+01, 1.4319782687E+01, 4.9799611330E+01, 1.0004198048E+01, 9.7117612581E-01],
	[4.1700000000E+04, 9.9581855997E+01, 1.4319881708E+01, 4.9819128164E+01, 1.0005244701E+01, 9.7118858419E-01],
	[4.1705000000E+04, 9.9602749279E+01, 1.4319980717E+01, 4.9838650302E+01, 1.0006291095E+01, 9.7120103649E-01],
	[4.1710000000E+04, 9.9623644438E+01, 1.4320079715E+01, 4.9858177746E+01, 1.0007337229E+01, 9.7121348272E-01],
	[4.1715000000E+04, 9.9644541476E+01, 1.4320178702E+01, 4.9877710497E+01, 1.0008383104E+01, 9.7122592288E-01],
	[4.1720000000E+04, 9.9665440392E+01, 1.4320277678E+01, 4.9897248554E+01, 1.0009428719E+01, 9.7123835697E-01],
	[4.1725000000E+04, 9.9686341185E+01, 1.4320376643E+01, 4.9916791920E+01, 1.0010474074E+01, 9.7125078500E-01],
	[4.1730000000E+04, 9.9707243857E+01, 1.4320475596E+01, 4.9936340595E+01, 1.0011519171E+01, 9.7126320696E-01],
	[4.1735000000E+04, 9.9728148406E+01, 1.4320574538E+01, 4.9955894579E+01, 1.0012564007E+01, 9.7127562286E-01],
	[4.1740000000E+04, 9.9749054833E+01, 1.4320673469E+01, 4.9975453873E+01, 1.0013608585E+01, 9.7128803271E-01],
	[4.1745000000E+04, 9.9769963137E+01, 1.4320772389E+01, 4.9995018479E+01, 1.0014652903E+01, 9.7130043651E-01],
	[4.1750000000E+04, 9.9790873320E+01, 1.4320871298E+01, 5.0014588397E+01, 1.0015696962E+01, 9.7131283425E-01],
	[4.1755000000E+04, 9.9811785380E+01, 1.4320970195E+01, 5.0034163628E+01, 1.0016740762E+01, 9.7132522596E-01],
	[4.1760000000E+04, 9.9832699317E+01, 1.4321069082E+01, 5.0053744173E+01, 1.0017784302E+01, 9.7133761161E-01],
	[4.1765000000E+04, 9.9853615132E+01, 1.4321167957E+01, 5.0073330032E+01, 1.0018827584E+01, 9.7134999123E-01],
	[4.1770000000E+04, 9.9874532824E+01, 1.4321266821E+01, 5.0092921206E+01, 1.0019870607E+01, 9.7136236482E-01],
	[4.1775000000E+04, 9.9895452394E+01, 1.4321365674E+01, 5.0112517696E+01, 1.0020913371E+01, 9.7137473237E-01],
	[4.1780000000E+04, 9.9916373841E+01, 1.4321464516E+01, 5.0132119503E+01, 1.0021955876E+01, 9.7138709389E-01],
	[4.1785000000E+04, 9.9937297165E+01, 1.4321563347E+01, 5.0151726628E+01, 1.0022998122E+01, 9.7139944939E-01],
	[4.1790000000E+04, 9.9958222367E+01, 1.4321662166E+01, 5.0171339072E+01, 1.0024040109E+01, 9.7141179886E-01],
	[4.1795000000E+04, 9.9979149445E+01, 1.4321760975E+01, 5.0190956834E+01, 1.0025081838E+01, 9.7142414232E-01],
	[4.1800000000E+04, 1.0000007840E+02, 1.4321859772E+01, 5.0210579917E+01, 1.0026123308E+01, 9.7143647975E-01],
	[4.1805000000E+04, 1.0002100923E+02, 1.4321958558E+01, 5.0230208321E+01, 1.0027164519E+01, 9.7144881118E-01],
	[4.1810000000E+04, 1.0004194194E+02, 1.4322057333E+01, 5.0249842046E+01, 1.0028205472E+01, 9.7146113659E-01],
	[4.1815000000E+04, 1.0006287653E+02, 1.4322156097E+01, 5.0269481094E+01, 1.0029246166E+01, 9.7147345600E-01],
	[4.1820000000E+04, 1.0008381299E+02, 1.4322254849E+01, 5.0289125465E+01, 1.0030286602E+01, 9.7148576940E-01],
	[4.1825000000E+04, 1.0010475133E+02, 1.4322353591E+01, 5.0308775161E+01, 1.0031326780E+01, 9.7149807681E-01],
	[4.1830000000E+04, 1.0012573732E+02, 1.4322457945E+01, 5.0328430181E+01, 1.0032369918E+01, 9.7151037822E-01],
	[4.1835000000E+04, 1.0014672550E+02, 1.4322562326E+01, 5.0348090527E+01, 1.0033412821E+01, 9.7152267363E-01],
	[4.1840000000E+04, 1.0016771557E+02, 1.4322666696E+01, 5.0367756200E+01, 1.0034455466E+01, 9.7153496305E-01],
	[4.1845000000E+04, 1.0018870754E+02, 1.4322771053E+01, 5.0387427200E+01, 1.0035497853E+01, 9.7154724649E-01],
	[4.1850000000E+04, 1.0020970139E+02, 1.4322875399E+01, 5.0407103528E+01, 1.0036539984E+01, 9.7155952394E-01],
	[4.1855000000E+04, 1.0023069714E+02, 1.4322979733E+01, 5.0426785185E+01, 1.0037581857E+01, 9.7157179541E-01],
	[4.1860000000E+04, 1.0025169477E+02, 1.4323084055E+01, 5.0446472172E+01, 1.0038623472E+01, 9.7158406091E-01],
	[4.1865000000E+04, 1.0027269430E+02, 1.4323188366E+01, 5.0466164490E+01, 1.0039664831E+01, 9.7159632043E-01],
	[4.1870000000E+04, 1.0029369571E+02, 1.4323292665E+01, 5.0485862138E+01, 1.0040705932E+01, 9.7160857398E-01],
	[4.1875000000E+04, 1.0031469902E+02, 1.4323396952E+01, 5.0505565119E+01, 1.0041746776E+01, 9.7162082156E-01],
	[4.1880000000E+04, 1.0033570421E+02, 1.4323501228E+01, 5.0525273433E+01, 1.0042787364E+01, 9.7163306318E-01],
	[4.1885000000E+04, 1.0035671130E+02, 1.4323605492E+01, 5.0544987081E+01, 1.0043827694E+01, 9.7164529883E-01],
	[4.1890000000E+04, 1.0037772027E+02, 1.4323709744E+01, 5.0564706064E+01, 1.0044867767E+01, 9.7165752853E-01],
	[4.1895000000E+04, 1.0039873114E+02, 1.4323813984E+01, 5.0584430382E+01, 1.0045907584E+01, 9.7166975227E-01],
	[4.1900000000E+04, 1.0041974389E+02, 1.4323918213E+01, 5.0604160036E+01, 1.0046947144E+01, 9.7168197006E-01],
	[4.1905000000E+04, 1.0044075853E+02, 1.4324022430E+01, 5.0623895027E+01, 1.0047986446E+01, 9.7169418191E-01],
	[4.1910000000E+04, 1.0046177507E+02, 1.4324126636E+01, 5.0643635356E+01, 1.0049025493E+01, 9.7170638781E-01],
	[4.1915000000E+04, 1.0048279349E+02, 1.4324230830E+01, 5.0663381023E+01, 1.0050064282E+01, 9.7171858776E-01],
	[4.1920000000E+04, 1.0050381380E+02, 1.4324335012E+01, 5.0683132030E+01, 1.0051102815E+01, 9.7173078178E-01],
	[4.1925000000E+04, 1.0052483601E+02, 1.4324439182E+01, 5.0702888377E+01, 1.0052141092E+01, 9.7174296986E-01],
	[4.1930000000E+04, 1.0054586010E+02, 1.4324543341E+01, 5.0722650065E+01, 1.0053179112E+01, 9.7175515201E-01],
	[4.1935000000E+04, 1.0056688608E+02, 1.4324647488E+01, 5.0742417096E+01, 1.0054216875E+01, 9.7176732823E-01],
	[4.1940000000E+04, 1.0058791395E+02, 1.4324751624E+01, 5.0762189468E+01, 1.0055254383E+01, 9.7177949853E-01],
	[4.1945000000E+04, 1.0060894371E+02, 1.4324855747E+01, 5.0781967185E+01, 1.0056291634E+01, 9.7179166290E-01],
	[4.1950000000E+04, 1.0062997536E+02, 1.4324959860E+01, 5.0801750245E+01, 1.0057328628E+01, 9.7180382135E-01],
	[4.1955000000E+04, 1.0065100890E+02, 1.4325063960E+01, 5.0821538651E+01, 1.0058365367E+01, 9.7181597389E-01],
	[4.1960000000E+04, 1.0067204432E+02, 1.4325168049E+01, 5.0841332402E+01, 1.0059401849E+01, 9.7182812052E-01],
	[4.1965000000E+04, 1.0069308164E+02, 1.4325272126E+01, 5.0861131500E+01, 1.0060438075E+01, 9.7184026123E-01],
	[4.1970000000E+04, 1.0071412084E+02, 1.4325376192E+01, 5.0880935946E+01, 1.0061474046E+01, 9.7185239604E-01],
	[4.1975000000E+04, 1.0073516194E+02, 1.4325480246E+01, 5.0900745740E+01, 1.0062509760E+01, 9.7186452494E-01],
	[4.1980000000E+04, 1.0075620492E+02, 1.4325584288E+01, 5.0920560883E+01, 1.0063545218E+01, 9.7187664795E-01],
	[4.1985000000E+04, 1.0077724979E+02, 1.4325688319E+01, 5.0940381376E+01, 1.0064580421E+01, 9.7188876506E-01],
	[4.1990000000E+04, 1.0079829655E+02, 1.4325792338E+01, 5.0960207219E+01, 1.0065615367E+01, 9.7190087627E-01],
	[4.1995000000E+04, 1.0081934520E+02, 1.4325896345E+01, 5.0980038415E+01, 1.0066650058E+01, 9.7191298160E-01],
	[4.2000000000E+04, 1.0084039574E+02, 1.4326000341E+01, 5.0999874962E+01, 1.0067684493E+01, 9.7192508103E-01],
	[4.2005000000E+04, 1.0086144817E+02, 1.4326104325E+01, 5.1019716863E+01, 1.0068718673E+01, 9.7193717459E-01],
	[4.2010000000E+04, 1.0088250248E+02, 1.4326208297E+01, 5.1039564117E+01, 1.0069752597E+01, 9.7194926226E-01],
	[4.2015000000E+04, 1.0090355869E+02, 1.4326312258E+01, 5.1059416727E+01, 1.0070786266E+01, 9.7196134405E-01],
	[4.2020000000E+04, 1.0092461678E+02, 1.4326416208E+01, 5.1079274692E+01, 1.0071819679E+01, 9.7197341997E-01],
	[4.2025000000E+04, 1.0094567676E+02, 1.4326520145E+01, 5.1099138013E+01, 1.0072852836E+01, 9.7198549002E-01],
	[4.2030000000E+04, 1.0096673863E+02, 1.4326624071E+01, 5.1119006691E+01, 1.0073885738E+01, 9.7199755420E-01],
	[4.2035000000E+04, 1.0098780238E+02, 1.4326727986E+01, 5.1138880728E+01, 1.0074918385E+01, 9.7200961252E-01],
	[4.2040000000E+04, 1.0100886803E+02, 1.4326831889E+01, 5.1158760123E+01, 1.0075950777E+01, 9.7202166497E-01],
	[4.2045000000E+04, 1.0102993556E+02, 1.4326935780E+01, 5.1178644878E+01, 1.0076982913E+01, 9.7203371157E-01],
	[4.2050000000E+04, 1.0105100498E+02, 1.4327039660E+01, 5.1198534993E+01, 1.0078014795E+01, 9.7204575231E-01],
	[4.2055000000E+04, 1.0107207629E+02, 1.4327143528E+01, 5.1218430469E+01, 1.0079046421E+01, 9.7205778720E-01],
	[4.2060000000E+04, 1.0109314949E+02, 1.4327247384E+01, 5.1238331307E+01, 1.0080077792E+01, 9.7206981624E-01],
	[4.2065000000E+04, 1.0111422457E+02, 1.4327351229E+01, 5.1258237509E+01, 1.0081108909E+01, 9.7208183943E-01],
	[4.2070000000E+04, 1.0113530155E+02, 1.4327455062E+01, 5.1278149073E+01, 1.0082139770E+01, 9.7209385679E-01],
	[4.2075000000E+04, 1.0115638041E+02, 1.4327558884E+01, 5.1298066002E+01, 1.0083170376E+01, 9.7210586830E-01],
	[4.2080000000E+04, 1.0117746116E+02, 1.4327662694E+01, 5.1317988297E+01, 1.0084200728E+01, 9.7211787398E-01],
	[4.2085000000E+04, 1.0119854379E+02, 1.4327766492E+01, 5.1337915957E+01, 1.0085230825E+01, 9.7212987382E-01],
	[4.2090000000E+04, 1.0121962832E+02, 1.4327870279E+01, 5.1357848985E+01, 1.0086260667E+01, 9.7214186783E-01],
	[4.2095000000E+04, 1.0124071473E+02, 1.4327974055E+01, 5.1377787380E+01, 1.0087290255E+01, 9.7215385602E-01],
	[4.2100000000E+04, 1.0126180303E+02, 1.4328077819E+01, 5.1397731143E+01, 1.0088319588E+01, 9.7216583839E-01],
	[4.2105000000E+04, 1.0128289321E+02, 1.4328181571E+01, 5.1417680276E+01, 1.0089348667E+01, 9.7217781493E-01],
	[4.2110000000E+04, 1.0130398529E+02, 1.4328285311E+01, 5.1437634778E+01, 1.0090377491E+01, 9.7218978566E-01],
	[4.2115000000E+04, 1.0132507925E+02, 1.4328389040E+01, 5.1457594652E+01, 1.0091406060E+01, 9.7220175057E-01],
	[4.2120000000E+04, 1.0134617510E+02, 1.4328492758E+01, 5.1477559897E+01, 1.0092434376E+01, 9.7221370967E-01],
	[4.2125000000E+04, 1.0136727283E+02, 1.4328596464E+01, 5.1497530515E+01, 1.0093462437E+01, 9.7222566297E-01],
	[4.2130000000E+04, 1.0138837246E+02, 1.4328700158E+01, 5.1517506506E+01, 1.0094490243E+01, 9.7223761046E-01],
	[4.2135000000E+04, 1.0140947397E+02, 1.4328803841E+01, 5.1537487871E+01, 1.0095517796E+01, 9.7224955215E-01],
	[4.2140000000E+04, 1.0143057736E+02, 1.4328907512E+01, 5.1557474612E+01, 1.0096545094E+01, 9.7226148804E-01],
	[4.2145000000E+04, 1.0145168265E+02, 1.4329011172E+01, 5.1577466727E+01, 1.0097572139E+01, 9.7227341814E-01],
	[4.2150000000E+04, 1.0147278982E+02, 1.4329114820E+01, 5.1597464220E+01, 1.0098598929E+01, 9.7228534245E-01],
	[4.2155000000E+04, 1.0149389888E+02, 1.4329218457E+01, 5.1617467089E+01, 1.0099625466E+01, 9.7229726096E-01],
	[4.2160000000E+04, 1.0151500982E+02, 1.4329322082E+01, 5.1637475337E+01, 1.0100651748E+01, 9.7230917369E-01],
	[4.2165000000E+04, 1.0153612265E+02, 1.4329425696E+01, 5.1657488964E+01, 1.0101677777E+01, 9.7232108064E-01],
	[4.2170000000E+04, 1.0155723737E+02, 1.4329529298E+01, 5.1677507970E+01, 1.0102703551E+01, 9.7233298182E-01],
	[4.2175000000E+04, 1.0157835398E+02, 1.4329632888E+01, 5.1697532357E+01, 1.0103729073E+01, 9.7234487721E-01],
	[4.2180000000E+04, 1.0159947247E+02, 1.4329736467E+01, 5.1717562126E+01, 1.0104754340E+01, 9.7235676683E-01],
	[4.2185000000E+04, 1.0162059285E+02, 1.4329840035E+01, 5.1737597276E+01, 1.0105779354E+01, 9.7236865069E-01],
	[4.2190000000E+04, 1.0164171511E+02, 1.4329943590E+01, 5.1757637810E+01, 1.0106804114E+01, 9.7238052877E-01],
	[4.2195000000E+04, 1.0166283927E+02, 1.4330047135E+01, 5.1777683727E+01, 1.0107828621E+01, 9.7239240110E-01],
	[4.2200000000E+04, 1.0168396530E+02, 1.4330150668E+01, 5.1797735029E+01, 1.0108852874E+01, 9.7240426766E-01],
	[4.2205000000E+04, 1.0170509323E+02, 1.4330254189E+01, 5.1817791717E+01, 1.0109876874E+01, 9.7241612847E-01],
	[4.2210000000E+04, 1.0172622304E+02, 1.4330357699E+01, 5.1837853790E+01, 1.0110900620E+01, 9.7242798352E-01],
	[4.2215000000E+04, 1.0174735474E+02, 1.4330461197E+01, 5.1857921251E+01, 1.0111924113E+01, 9.7243983283E-01],
	[4.2220000000E+04, 1.0176848832E+02, 1.4330564684E+01, 5.1877994099E+01, 1.0112947353E+01, 9.7245167638E-01],
	[4.2225000000E+04, 1.0178962379E+02, 1.4330668159E+01, 5.1898072336E+01, 1.0113970340E+01, 9.7246351420E-01],
	[4.2230000000E+04, 1.0181076115E+02, 1.4330771623E+01, 5.1918155962E+01, 1.0114993074E+01, 9.7247534627E-01],
	[4.2235000000E+04, 1.0183190039E+02, 1.4330875075E+01, 5.1938244979E+01, 1.0116015554E+01, 9.7248717260E-01],
	[4.2240000000E+04, 1.0185304151E+02, 1.4330978516E+01, 5.1958339387E+01, 1.0117037782E+01, 9.7249899320E-01],
	[4.2245000000E+04, 1.0187418453E+02, 1.4331081945E+01, 5.1978439186E+01, 1.0118059756E+01, 9.7251080806E-01],
	[4.2250000000E+04, 1.0189532943E+02, 1.4331185363E+01, 5.1998544379E+01, 1.0119081478E+01, 9.7252261720E-01],
	[4.2255000000E+04, 1.0191647621E+02, 1.4331288770E+01, 5.2018654964E+01, 1.0120102947E+01, 9.7253442062E-01],
	[4.2260000000E+04, 1.0193762488E+02, 1.4331392164E+01, 5.2038770944E+01, 1.0121124163E+01, 9.7254621831E-01],
	[4.2265000000E+04, 1.0195877544E+02, 1.4331495548E+01, 5.2058892319E+01, 1.0122145126E+01, 9.7255801028E-01],
	[4.2270000000E+04, 1.0197992788E+02, 1.4331598919E+01, 5.2079019090E+01, 1.0123165837E+01, 9.7256979653E-01],
	[4.2275000000E+04, 1.0200108221E+02, 1.4331702280E+01, 5.2099151258E+01, 1.0124186295E+01, 9.7258157708E-01],
	[4.2280000000E+04, 1.0202223843E+02, 1.4331805629E+01, 5.2119288823E+01, 1.0125206501E+01, 9.7259335191E-01],
	[4.2285000000E+04, 1.0204339652E+02, 1.4331908966E+01, 5.2139431787E+01, 1.0126226453E+01, 9.7260512104E-01],
	[4.2290000000E+04, 1.0206455651E+02, 1.4332012292E+01, 5.2159580149E+01, 1.0127246154E+01, 9.7261688446E-01],
	[4.2295000000E+04, 1.0208571838E+02, 1.4332115607E+01, 5.2179733912E+01, 1.0128265602E+01, 9.7262864219E-01],
	[4.2300000000E+04, 1.0210688213E+02, 1.4332218910E+01, 5.2199893075E+01, 1.0129284798E+01, 9.7264039421E-01],
	[4.2305000000E+04, 1.0212804777E+02, 1.4332322201E+01, 5.2220057640E+01, 1.0130303741E+01, 9.7265214055E-01],
	[4.2310000000E+04, 1.0214921530E+02, 1.4332425481E+01, 5.2240227607E+01, 1.0131322433E+01, 9.7266388119E-01],
	[4.2315000000E+04, 1.0217038471E+02, 1.4332528750E+01, 5.2260402978E+01, 1.0132340872E+01, 9.7267561614E-01],
	[4.2320000000E+04, 1.0219155601E+02, 1.4332632007E+01, 5.2280583752E+01, 1.0133359059E+01, 9.7268734541E-01],
	[4.2325000000E+04, 1.0221272919E+02, 1.4332735253E+01, 5.2300769931E+01, 1.0134376994E+01, 9.7269906900E-01],
	[4.2330000000E+04, 1.0223390425E+02, 1.4332838487E+01, 5.2320961516E+01, 1.0135394677E+01, 9.7271078691E-01],
	[4.2335000000E+04, 1.0225508121E+02, 1.4332941710E+01, 5.2341158507E+01, 1.0136412108E+01, 9.7272249915E-01],
	[4.2340000000E+04, 1.0227626004E+02, 1.4333044921E+01, 5.2361360905E+01, 1.0137429287E+01, 9.7273420571E-01],
	[4.2345000000E+04, 1.0229744076E+02, 1.4333148121E+01, 5.2381568711E+01, 1.0138446214E+01, 9.7274590660E-01],
	[4.2350000000E+04, 1.0231862337E+02, 1.4333251309E+01, 5.2401781926E+01, 1.0139462889E+01, 9.7275760183E-01],
	[4.2355000000E+04, 1.0233980786E+02, 1.4333354486E+01, 5.2422000551E+01, 1.0140479313E+01, 9.7276929140E-01],
	[4.2360000000E+04, 1.0236099423E+02, 1.4333457652E+01, 5.2442224586E+01, 1.0141495485E+01, 9.7278097531E-01],
	[4.2365000000E+04, 1.0238218249E+02, 1.4333560806E+01, 5.2462454033E+01, 1.0142511406E+01, 9.7279265356E-01],
	[4.2370000000E+04, 1.0240337264E+02, 1.4333663949E+01, 5.2482688891E+01, 1.0143527075E+01, 9.7280432615E-01],
	[4.2375000000E+04, 1.0242456467E+02, 1.4333767080E+01, 5.2502929162E+01, 1.0144542492E+01, 9.7281599310E-01],
	[4.2380000000E+04, 1.0244575858E+02, 1.4333870200E+01, 5.2523174847E+01, 1.0145557658E+01, 9.7282765440E-01],
	[4.2385000000E+04, 1.0246695438E+02, 1.4333973308E+01, 5.2543425947E+01, 1.0146572573E+01, 9.7283931005E-01],
	[4.2390000000E+04, 1.0248815206E+02, 1.4334076405E+01, 5.2563682461E+01, 1.0147587236E+01, 9.7285096007E-01],
	[4.2395000000E+04, 1.0250935162E+02, 1.4334179491E+01, 5.2583944392E+01, 1.0148601648E+01, 9.7286260445E-01],
	[4.2400000000E+04, 1.0253055307E+02, 1.4334282565E+01, 5.2604211740E+01, 1.0149615809E+01, 9.7287424319E-01],
	[4.2405000000E+04, 1.0255175641E+02, 1.4334385628E+01, 5.2624484505E+01, 1.0150629718E+01, 9.7288587630E-01],
	[4.2410000000E+04, 1.0257296163E+02, 1.4334488679E+01, 5.2644762689E+01, 1.0151643377E+01, 9.7289750378E-01],
	[4.2415000000E+04, 1.0259416873E+02, 1.4334591719E+01, 5.2665046292E+01, 1.0152656784E+01, 9.7290912564E-01],
	[4.2420000000E+04, 1.0261537772E+02, 1.4334694748E+01, 5.2685335316E+01, 1.0153669941E+01, 9.7292074188E-01],
	[4.2425000000E+04, 1.0263658859E+02, 1.4334797765E+01, 5.2705629760E+01, 1.0154682846E+01, 9.7293235249E-01],
	[4.2430000000E+04, 1.0265780134E+02, 1.4334900771E+01, 5.2725929626E+01, 1.0155695501E+01, 9.7294395749E-01],
	[4.2435000000E+04, 1.0267901598E+02, 1.4335003765E+01, 5.2746234914E+01, 1.0156707905E+01, 9.7295555688E-01],
	[4.2440000000E+04, 1.0270023250E+02, 1.4335106748E+01, 5.2766545626E+01, 1.0157720058E+01, 9.7296715066E-01],
	[4.2445000000E+04, 1.0272145091E+02, 1.4335209719E+01, 5.2786861762E+01, 1.0158731960E+01, 9.7297873883E-01],
	[4.2450000000E+04, 1.0274267120E+02, 1.4335312680E+01, 5.2807183323E+01, 1.0159743612E+01, 9.7299032139E-01],
	[4.2455000000E+04, 1.0276389337E+02, 1.4335415628E+01, 5.2827510310E+01, 1.0160755013E+01, 9.7300189836E-01],
	[4.2460000000E+04, 1.0278511743E+02, 1.4335518566E+01, 5.2847842724E+01, 1.0161766163E+01, 9.7301346973E-01],
	[4.2465000000E+04, 1.0280634337E+02, 1.4335621492E+01, 5.2868180565E+01, 1.0162777063E+01, 9.7302503550E-01],
	[4.2470000000E+04, 1.0282757119E+02, 1.4335724406E+01, 5.2888523834E+01, 1.0163787713E+01, 9.7303659569E-01],
	[4.2475000000E+04, 1.0284880090E+02, 1.4335827310E+01, 5.2908872532E+01, 1.0164798112E+01, 9.7304815028E-01],
	[4.2480000000E+04, 1.0287003249E+02, 1.4335930202E+01, 5.2929226660E+01, 1.0165808261E+01, 9.7305969929E-01],
	[4.2485000000E+04, 1.0289126597E+02, 1.4336033082E+01, 5.2949586218E+01, 1.0166818160E+01, 9.7307124272E-01],
	[4.2490000000E+04, 1.0291250132E+02, 1.4336135951E+01, 5.2969951208E+01, 1.0167827808E+01, 9.7308278057E-01],
	[4.2495000000E+04, 1.0293373856E+02, 1.4336238809E+01, 5.2990321630E+01, 1.0168837207E+01, 9.7309431285E-01],
	[4.2500000000E+04, 1.0295499270E+02, 1.4336343473E+01, 5.3010697486E+01, 1.0169847416E+01, 9.7310583955E-01],
	[4.2505000000E+04, 1.0297627949E+02, 1.4336451850E+01, 5.3031078775E+01, 1.0170859550E+01, 9.7311736068E-01],
	[4.2510000000E+04, 1.0299756818E+02, 1.4336560215E+01, 5.3051465499E+01, 1.0171871435E+01, 9.7312887624E-01],
	[4.2515000000E+04, 1.0301885876E+02, 1.4336668568E+01, 5.3071857658E+01, 1.0172883071E+01, 9.7314038624E-01],
	[4.2520000000E+04, 1.0304015124E+02, 1.4336776910E+01, 5.3092255253E+01, 1.0173894458E+01, 9.7315189068E-01],
	[4.2525000000E+04, 1.0306144562E+02, 1.4336885239E+01, 5.3112658286E+01, 1.0174905595E+01, 9.7316338957E-01],
	[4.2530000000E+04, 1.0308274189E+02, 1.4336993556E+01, 5.3133066757E+01, 1.0175916483E+01, 9.7317488290E-01],
	[4.2535000000E+04, 1.0310404006E+02, 1.4337101862E+01, 5.3153480666E+01, 1.0176927122E+01, 9.7318637068E-01],
	[4.2540000000E+04, 1.0312534013E+02, 1.4337210155E+01, 5.3173900015E+01, 1.0177937513E+01, 9.7319785291E-01],
	[4.2545000000E+04, 1.0314664209E+02, 1.4337318437E+01, 5.3194324804E+01, 1.0178947654E+01, 9.7320932959E-01],
	[4.2550000000E+04, 1.0316794595E+02, 1.4337426706E+01, 5.3214755035E+01, 1.0179957547E+01, 9.7322080074E-01],
	[4.2555000000E+04, 1.0318925170E+02, 1.4337534964E+01, 5.3235190707E+01, 1.0180967190E+01, 9.7323226634E-01],
	[4.2560000000E+04, 1.0321055935E+02, 1.4337643210E+01, 5.3255631822E+01, 1.0181976585E+01, 9.7324372641E-01],
	[4.2565000000E+04, 1.0323186889E+02, 1.4337751444E+01, 5.3276078381E+01, 1.0182985732E+01, 9.7325518094E-01],
	[4.2570000000E+04, 1.0325318034E+02, 1.4337859666E+01, 5.3296530384E+01, 1.0183994629E+01, 9.7326662995E-01],
	[4.2575000000E+04, 1.0327449367E+02, 1.4337967876E+01, 5.3316987832E+01, 1.0185003279E+01, 9.7327807343E-01],
	[4.2580000000E+04, 1.0329580891E+02, 1.4338076075E+01, 5.3337450726E+01, 1.0186011679E+01, 9.7328951138E-01],
	[4.2585000000E+04, 1.0331712604E+02, 1.4338184261E+01, 5.3357919067E+01, 1.0187019831E+01, 9.7330094381E-01],
	[4.2590000000E+04, 1.0333844506E+02, 1.4338292435E+01, 5.3378392856E+01, 1.0188027735E+01, 9.7331237072E-01],
	[4.2595000000E+04, 1.0335976598E+02, 1.4338400598E+01, 5.3398872093E+01, 1.0189035390E+01, 9.7332379212E-01],
	[4.2600000000E+04, 1.0338108880E+02, 1.4338508749E+01, 5.3419356779E+01, 1.0190042797E+01, 9.7333520800E-01],
	[4.2605000000E+04, 1.0340241351E+02, 1.4338616888E+01, 5.3439846916E+01, 1.0191049956E+01, 9.7334661836E-01],
	[4.2610000000E+04, 1.0342374011E+02, 1.4338725015E+01, 5.3460342503E+01, 1.0192056867E+01, 9.7335802322E-01],
	[4.2615000000E+04, 1.0344506862E+02, 1.4338833130E+01, 5.3480843542E+01, 1.0193063529E+01, 9.7336942257E-01],
	[4.2620000000E+04, 1.0346639901E+02, 1.4338941233E+01, 5.3501350033E+01, 1.0194069944E+01, 9.7338081641E-01],
	[4.2625000000E+04, 1.0348773131E+02, 1.4339049325E+01, 5.3521861978E+01, 1.0195076110E+01, 9.7339220475E-01],
	[4.2630000000E+04, 1.0350906549E+02, 1.4339157404E+01, 5.3542379376E+01, 1.0196082029E+01, 9.7340358760E-01],
	[4.2635000000E+04, 1.0353040158E+02, 1.4339265472E+01, 5.3562902230E+01, 1.0197087699E+01, 9.7341496494E-01],
	[4.2640000000E+04, 1.0355173956E+02, 1.4339373528E+01, 5.3583430539E+01, 1.0198093122E+01, 9.7342633680E-01],
	[4.2645000000E+04, 1.0357307943E+02, 1.4339481571E+01, 5.3603964305E+01, 1.0199098297E+01, 9.7343770316E-01],
	[4.2650000000E+04, 1.0359442120E+02, 1.4339589604E+01, 5.3624503528E+01, 1.0200103224E+01, 9.7344906403E-01],
	[4.2655000000E+04, 1.0361576486E+02, 1.4339697624E+01, 5.3645048210E+01, 1.0201107904E+01, 9.7346041942E-01],
	[4.2660000000E+04, 1.0363711042E+02, 1.4339805632E+01, 5.3665598350E+01, 1.0202112336E+01, 9.7347176933E-01],
	[4.2665000000E+04, 1.0365845787E+02, 1.4339913629E+01, 5.3686153950E+01, 1.0203116520E+01, 9.7348311375E-01],
	[4.2670000000E+04, 1.0367980722E+02, 1.4340021613E+01, 5.3706715011E+01, 1.0204120457E+01, 9.7349445270E-01],
	[4.2675000000E+04, 1.0370115847E+02, 1.4340129586E+01, 5.3727281532E+01, 1.0205124146E+01, 9.7350578617E-01],
	[4.2680000000E+04, 1.0372251160E+02, 1.4340237547E+01, 5.3747853517E+01, 1.0206127588E+01, 9.7351711417E-01],
	[4.2685000000E+04, 1.0374386664E+02, 1.4340345497E+01, 5.3768430964E+01, 1.0207130783E+01, 9.7352843670E-01],
	[4.2690000000E+04, 1.0376522356E+02, 1.4340453434E+01, 5.3789013875E+01, 1.0208133730E+01, 9.7353975376E-01],
	[4.2695000000E+04, 1.0378658238E+02, 1.4340561360E+01, 5.3809602250E+01, 1.0209136430E+01, 9.7355106536E-01],
	[4.2700000000E+04, 1.0380794310E+02, 1.4340669273E+01, 5.3830196091E+01, 1.0210138883E+01, 9.7356237149E-01],
	[4.2705000000E+04, 1.0382930571E+02, 1.4340777175E+01, 5.3850795398E+01, 1.0211141089E+01, 9.7357367217E-01],
	[4.2710000000E+04, 1.0385067022E+02, 1.4340885065E+01, 5.3871400173E+01, 1.0212143048E+01, 9.7358496739E-01],
	[4.2715000000E+04, 1.0387203662E+02, 1.4340992943E+01, 5.3892010415E+01, 1.0213144760E+01, 9.7359625716E-01],
	[4.2720000000E+04, 1.0389340491E+02, 1.4341100810E+01, 5.3912626126E+01, 1.0214146225E+01, 9.7360754147E-01],
	[4.2725000000E+04, 1.0391477510E+02, 1.4341208665E+01, 5.3933247306E+01, 1.0215147442E+01, 9.7361882034E-01],
	[4.2730000000E+04, 1.0393614718E+02, 1.4341316507E+01, 5.3953873956E+01, 1.0216148413E+01, 9.7363009376E-01],
	[4.2735000000E+04, 1.0395752115E+02, 1.4341424338E+01, 5.3974506078E+01, 1.0217149138E+01, 9.7364136173E-01],
	[4.2740000000E+04, 1.0397889703E+02, 1.4341532158E+01, 5.3995143671E+01, 1.0218149615E+01, 9.7365262427E-01],
	[4.2745000000E+04, 1.0400027479E+02, 1.4341639965E+01, 5.4015786738E+01, 1.0219149846E+01, 9.7366388137E-01],
	[4.2750000000E+04, 1.0402165445E+02, 1.4341747761E+01, 5.4036435277E+01, 1.0220149831E+01, 9.7367513303E-01],
	[4.2755000000E+04, 1.0404303600E+02, 1.4341855544E+01, 5.4057089291E+01, 1.0221149568E+01, 9.7368637926E-01],
	[4.2760000000E+04, 1.0406441945E+02, 1.4341963316E+01, 5.4077748781E+01, 1.0222149059E+01, 9.7369762006E-01],
	[4.2765000000E+04, 1.0408580479E+02, 1.4342071077E+01, 5.4098413746E+01, 1.0223148304E+01, 9.7370885544E-01],
	[4.2770000000E+04, 1.0410719202E+02, 1.4342178825E+01, 5.4119084188E+01, 1.0224147303E+01, 9.7372008539E-01],
	[4.2775000000E+04, 1.0412858115E+02, 1.4342286562E+01, 5.4139760107E+01, 1.0225146055E+01, 9.7373130991E-01],
	[4.2780000000E+04, 1.0414997217E+02, 1.4342394287E+01, 5.4160441505E+01, 1.0226144560E+01, 9.7374252902E-01],
	[4.2785000000E+04, 1.0417136508E+02, 1.4342502000E+01, 5.4181128382E+01, 1.0227142820E+01, 9.7375374271E-01],
	[4.2790000000E+04, 1.0419275989E+02, 1.4342609701E+01, 5.4201820739E+01, 1.0228140833E+01, 9.7376495099E-01],
	[4.2795000000E+04, 1.0421415659E+02, 1.4342717390E+01, 5.4222518577E+01, 1.0229138601E+01, 9.7377615385E-01],
	[4.2800000000E+04, 1.0423555519E+02, 1.4342825068E+01, 5.4243221896E+01, 1.0230136122E+01, 9.7378735131E-01],
	[4.2805000000E+04, 1.0425695567E+02, 1.4342932734E+01, 5.4263930698E+01, 1.0231133397E+01, 9.7379854336E-01],
	[4.2810000000E+04, 1.0427835806E+02, 1.4343040388E+01, 5.4284644984E+01, 1.0232130426E+01, 9.7380973001E-01],
	[4.2815000000E+04, 1.0429976233E+02, 1.4343148031E+01, 5.4305364753E+01, 1.0233127210E+01, 9.7382091125E-01],
	[4.2820000000E+04, 1.0432116850E+02, 1.4343255662E+01, 5.4326090007E+01, 1.0234123747E+01, 9.7383208710E-01],
	[4.2825000000E+04, 1.0434257656E+02, 1.4343363280E+01, 5.4346820746E+01, 1.0235120039E+01, 9.7384325755E-01],
	[4.2830000000E+04, 1.0436398651E+02, 1.4343470888E+01, 5.4367556973E+01, 1.0236116085E+01, 9.7385442261E-01],
	[4.2835000000E+04, 1.0438539836E+02, 1.4343578483E+01, 5.4388298686E+01, 1.0237111886E+01, 9.7386558228E-01],
	[4.2840000000E+04, 1.0440681210E+02, 1.4343686067E+01, 5.4409045888E+01, 1.0238107440E+01, 9.7387673656E-01],
	[4.2845000000E+04, 1.0442822773E+02, 1.4343793639E+01, 5.4429798578E+01, 1.0239102750E+01, 9.7388788546E-01],
	[4.2850000000E+04, 1.0444964526E+02, 1.4343901199E+01, 5.4450556758E+01, 1.0240097813E+01, 9.7389902898E-01],
	[4.2855000000E+04, 1.0447106468E+02, 1.4344008747E+01, 5.4471320429E+01, 1.0241092632E+01, 9.7391016711E-01],
	[4.2860000000E+04, 1.0449248599E+02, 1.4344116284E+01, 5.4492089591E+01, 1.0242087205E+01, 9.7392129987E-01],
	[4.2865000000E+04, 1.0451390920E+02, 1.4344223809E+01, 5.4512864245E+01, 1.0243081532E+01, 9.7393242725E-01],
	[4.2870000000E+04, 1.0453533429E+02, 1.4344331322E+01, 5.4533644393E+01, 1.0244075615E+01, 9.7394354926E-01],
	[4.2875000000E+04, 1.0455676128E+02, 1.4344438824E+01, 5.4554430034E+01, 1.0245069452E+01, 9.7395466591E-01],
	[4.2880000000E+04, 1.0457819017E+02, 1.4344546313E+01, 5.4575221169E+01, 1.0246063044E+01, 9.7396577718E-01],
	[4.2885000000E+04, 1.0459962094E+02, 1.4344653791E+01, 5.4596017800E+01, 1.0247056391E+01, 9.7397688310E-01],
	[4.2890000000E+04, 1.0462105361E+02, 1.4344761258E+01, 5.4616819927E+01, 1.0248049493E+01, 9.7398798365E-01],
	[4.2895000000E+04, 1.0464248817E+02, 1.4344868712E+01, 5.4637627551E+01, 1.0249042350E+01, 9.7399907884E-01],
	[4.2900000000E+04, 1.0466392462E+02, 1.4344976155E+01, 5.4658440673E+01, 1.0250034961E+01, 9.7401016868E-01],
	[4.2905000000E+04, 1.0468536297E+02, 1.4345083586E+01, 5.4679259294E+01, 1.0251027329E+01, 9.7402125317E-01],
	[4.2910000000E+04, 1.0470680320E+02, 1.4345191006E+01, 5.4700083414E+01, 1.0252019451E+01, 9.7403233230E-01],
	[4.2915000000E+04, 1.0472824533E+02, 1.4345298413E+01, 5.4720913034E+01, 1.0253011328E+01, 9.7404340609E-01],
	[4.2920000000E+04, 1.0474968935E+02, 1.4345405809E+01, 5.4741748156E+01, 1.0254002961E+01, 9.7405447453E-01],
	[4.2925000000E+04, 1.0477113527E+02, 1.4345513194E+01, 5.4762588779E+01, 1.0254994349E+01, 9.7406553763E-01],
	[4.2930000000E+04, 1.0479258307E+02, 1.4345620566E+01, 5.4783434905E+01, 1.0255985493E+01, 9.7407659539E-01],
	[4.2935000000E+04, 1.0481403277E+02, 1.4345727927E+01, 5.4804286534E+01, 1.0256976392E+01, 9.7408764781E-01],
	[4.2940000000E+04, 1.0483548436E+02, 1.4345835276E+01, 5.4825143668E+01, 1.0257967046E+01, 9.7409869489E-01],
	[4.2945000000E+04, 1.0485693784E+02, 1.4345942614E+01, 5.4846006307E+01, 1.0258957456E+01, 9.7410973665E-01],
	[4.2950000000E+04, 1.0487839321E+02, 1.4346049940E+01, 5.4866874452E+01, 1.0259947622E+01, 9.7412077307E-01],
	[4.2955000000E+04, 1.0489985048E+02, 1.4346157254E+01, 5.4887748103E+01, 1.0260937543E+01, 9.7413180417E-01],
	[4.2960000000E+04, 1.0492130963E+02, 1.4346264556E+01, 5.4908627263E+01, 1.0261927220E+01, 9.7414282995E-01],
	[4.2965000000E+04, 1.0494277068E+02, 1.4346371847E+01, 5.4929511930E+01, 1.0262916653E+01, 9.7415385040E-01],
	[4.2970000000E+04, 1.0496423362E+02, 1.4346479126E+01, 5.4950402107E+01, 1.0263905842E+01, 9.7416486554E-01],
	[4.2975000000E+04, 1.0498569845E+02, 1.4346586393E+01, 5.4971297793E+01, 1.0264894787E+01, 9.7417587535E-01],
	[4.2980000000E+04, 1.0500716517E+02, 1.4346693649E+01, 5.4992198991E+01, 1.0265883488E+01, 9.7418687986E-01],
	[4.2985000000E+04, 1.0502863379E+02, 1.4346800893E+01, 5.5013105700E+01, 1.0266871944E+01, 9.7419787905E-01],
	[4.2990000000E+04, 1.0505010429E+02, 1.4346908125E+01, 5.5034017921E+01, 1.0267860157E+01, 9.7420887294E-01],
	[4.2995000000E+04, 1.0507157669E+02, 1.4347015346E+01, 5.5054935656E+01, 1.0268848126E+01, 9.7421986152E-01],
	[4.3000000000E+04, 1.0509305098E+02, 1.4347122555E+01, 5.5075858905E+01, 1.0269835851E+01, 9.7423084480E-01],
	[4.3005000000E+04, 1.0511452716E+02, 1.4347229752E+01, 5.5096787668E+01, 1.0270823332E+01, 9.7424182277E-01],
	[4.3010000000E+04, 1.0513600523E+02, 1.4347336938E+01, 5.5117721947E+01, 1.0271810570E+01, 9.7425279545E-01],
	[4.3015000000E+04, 1.0515748519E+02, 1.4347444112E+01, 5.5138661743E+01, 1.0272797564E+01, 9.7426376284E-01],
	[4.3020000000E+04, 1.0517896704E+02, 1.4347551275E+01, 5.5159607056E+01, 1.0273784315E+01, 9.7427472493E-01],
	[4.3025000000E+04, 1.0520045079E+02, 1.4347658425E+01, 5.5180557887E+01, 1.0274770821E+01, 9.7428568173E-01],
	[4.3030000000E+04, 1.0522193642E+02, 1.4347765564E+01, 5.5201514237E+01, 1.0275757085E+01, 9.7429663325E-01],
	[4.3035000000E+04, 1.0524342395E+02, 1.4347872692E+01, 5.5222476107E+01, 1.0276743105E+01, 9.7430757948E-01],
	[4.3040000000E+04, 1.0526491336E+02, 1.4347979807E+01, 5.5243443497E+01, 1.0277728882E+01, 9.7431852043E-01],
	[4.3045000000E+04, 1.0528640467E+02, 1.4348086912E+01, 5.5264416409E+01, 1.0278714415E+01, 9.7432945610E-01],
	[4.3050000000E+04, 1.0530789787E+02, 1.4348194004E+01, 5.5285394842E+01, 1.0279699705E+01, 9.7434038649E-01],
	[4.3055000000E+04, 1.0532939296E+02, 1.4348301085E+01, 5.5306378799E+01, 1.0280684752E+01, 9.7435131161E-01],
	[4.3060000000E+04, 1.0535088994E+02, 1.4348408154E+01, 5.5327368280E+01, 1.0281669556E+01, 9.7436223146E-01],
	[4.3065000000E+04, 1.0537238881E+02, 1.4348515212E+01, 5.5348363285E+01, 1.0282654117E+01, 9.7437314604E-01],
	[4.3070000000E+04, 1.0539388957E+02, 1.4348622258E+01, 5.5369363815E+01, 1.0283638434E+01, 9.7438405535E-01],
	[4.3075000000E+04, 1.0541539222E+02, 1.4348729292E+01, 5.5390369872E+01, 1.0284622509E+01, 9.7439495940E-01],
	[4.3080000000E+04, 1.0543689676E+02, 1.4348836315E+01, 5.5411381455E+01, 1.0285606341E+01, 9.7440585819E-01],
	[4.3085000000E+04, 1.0545840319E+02, 1.4348943326E+01, 5.5432398567E+01, 1.0286589930E+01, 9.7441675172E-01],
	[4.3090000000E+04, 1.0547991151E+02, 1.4349050325E+01, 5.5453421207E+01, 1.0287573276E+01, 9.7442764000E-01],
	[4.3095000000E+04, 1.0550142173E+02, 1.4349157313E+01, 5.5474449377E+01, 1.0288556379E+01, 9.7443852302E-01],
	[4.3100000000E+04, 1.0552293383E+02, 1.4349264289E+01, 5.5495483077E+01, 1.0289539240E+01, 9.7444940079E-01],
	[4.3105000000E+04, 1.0554444782E+02, 1.4349371254E+01, 5.5516522307E+01, 1.0290521858E+01, 9.7446027332E-01],
	[4.3110000000E+04, 1.0556596370E+02, 1.4349478207E+01, 5.5537567070E+01, 1.0291504234E+01, 9.7447114060E-01],
	[4.3115000000E+04, 1.0558748148E+02, 1.4349585148E+01, 5.5558617366E+01, 1.0292486367E+01, 9.7448200264E-01],
	[4.3120000000E+04, 1.0560900114E+02, 1.4349692078E+01, 5.5579673195E+01, 1.0293468258E+01, 9.7449285943E-01],
	[4.3125000000E+04, 1.0563052269E+02, 1.4349798996E+01, 5.5600734558E+01, 1.0294449906E+01, 9.7450371099E-01],
	[4.3130000000E+04, 1.0565204614E+02, 1.4349905903E+01, 5.5621801457E+01, 1.0295431312E+01, 9.7451455732E-01],
	[4.3135000000E+04, 1.0567357147E+02, 1.4350012798E+01, 5.5642873891E+01, 1.0296412475E+01, 9.7452539842E-01],
	[4.3140000000E+04, 1.0569509869E+02, 1.4350119681E+01, 5.5663951862E+01, 1.0297393396E+01, 9.7453623428E-01],
	[4.3145000000E+04, 1.0571662780E+02, 1.4350226553E+01, 5.5685035371E+01, 1.0298374076E+01, 9.7454706492E-01],
	[4.3150000000E+04, 1.0573815881E+02, 1.4350333413E+01, 5.5706124418E+01, 1.0299354513E+01, 9.7455789033E-01],
	[4.3155000000E+04, 1.0575969170E+02, 1.4350440262E+01, 5.5727219005E+01, 1.0300334708E+01, 9.7456871053E-01],
	[4.3160000000E+04, 1.0578122648E+02, 1.4350547099E+01, 5.5748319131E+01, 1.0301314660E+01, 9.7457952550E-01],
	[4.3165000000E+04, 1.0580276315E+02, 1.4350653924E+01, 5.5769424798E+01, 1.0302294371E+01, 9.7459033526E-01],
	[4.3170000000E+04, 1.0582430171E+02, 1.4350760738E+01, 5.5790536007E+01, 1.0303273841E+01, 9.7460113981E-01],
	[4.3175000000E+04, 1.0584584216E+02, 1.4350867541E+01, 5.5811652758E+01, 1.0304253068E+01, 9.7461193914E-01],
	[4.3180000000E+04, 1.0586738450E+02, 1.4350974331E+01, 5.5832775053E+01, 1.0305232053E+01, 9.7462273327E-01],
	[4.3185000000E+04, 1.0588895123E+02, 1.4351083795E+01, 5.5853902891E+01, 1.0306212395E+01, 9.7463352219E-01],
	[4.3190000000E+04, 1.0591054283E+02, 1.4351195987E+01, 5.5875036275E+01, 1.0307194126E+01, 9.7464430591E-01],
	[4.3195000000E+04, 1.0593213632E+02, 1.4351308167E+01, 5.5896175204E+01, 1.0308175616E+01, 9.7465508442E-01],
	[4.3200000000E+04, 1.0595373172E+02, 1.4351420335E+01, 5.5917319680E+01, 1.0309156865E+01, 9.7466585774E-01],
	[4.3205000000E+04, 1.0597532903E+02, 1.4351532490E+01, 5.5938469703E+01, 1.0310137873E+01, 9.7467662587E-01],
	[4.3210000000E+04, 1.0599692823E+02, 1.4351644634E+01, 5.5959625274E+01, 1.0311118641E+01, 9.7468738880E-01],
	[4.3215000000E+04, 1.0601852934E+02, 1.4351756765E+01, 5.5980786394E+01, 1.0312099167E+01, 9.7469814654E-01],
	[4.3220000000E+04, 1.0604013235E+02, 1.4351868885E+01, 5.6001953064E+01, 1.0313079453E+01, 9.7470889910E-01],
	[4.3225000000E+04, 1.0606173726E+02, 1.4351980992E+01, 5.6023125284E+01, 1.0314059499E+01, 9.7471964647E-01],
	[4.3230000000E+04, 1.0608334408E+02, 1.4352093087E+01, 5.6044303056E+01, 1.0315039304E+01, 9.7473038865E-01],
	[4.3235000000E+04, 1.0610495279E+02, 1.4352205170E+01, 5.6065486379E+01, 1.0316018868E+01, 9.7474112566E-01],
	[4.3240000000E+04, 1.0612656341E+02, 1.4352317241E+01, 5.6086675256E+01, 1.0316998192E+01, 9.7475185750E-01],
	[4.3245000000E+04, 1.0614817593E+02, 1.4352429300E+01, 5.6107869687E+01, 1.0317977275E+01, 9.7476258415E-01],
	[4.3250000000E+04, 1.0616979035E+02, 1.4352541346E+01, 5.6129069672E+01, 1.0318956118E+01, 9.7477330564E-01],
	[4.3255000000E+04, 1.0619140667E+02, 1.4352653381E+01, 5.6150275213E+01, 1.0319934721E+01, 9.7478402196E-01],
	[4.3260000000E+04, 1.0621302490E+02, 1.4352765404E+01, 5.6171486310E+01, 1.0320913083E+01, 9.7479473311E-01],
	[4.3265000000E+04, 1.0623464503E+02, 1.4352877414E+01, 5.6192702964E+01, 1.0321891205E+01, 9.7480543910E-01],
	[4.3270000000E+04, 1.0625626706E+02, 1.4352989413E+01, 5.6213925176E+01, 1.0322869087E+01, 9.7481613992E-01],
	[4.3275000000E+04, 1.0627789099E+02, 1.4353101399E+01, 5.6235152947E+01, 1.0323846729E+01, 9.7482683559E-01],
	[4.3280000000E+04, 1.0629951682E+02, 1.4353213374E+01, 5.6256386277E+01, 1.0324824131E+01, 9.7483752610E-01],
	[4.3285000000E+04, 1.0632114455E+02, 1.4353325336E+01, 5.6277625167E+01, 1.0325801293E+01, 9.7484821146E-01],
	[4.3290000000E+04, 1.0634277419E+02, 1.4353437286E+01, 5.6298869619E+01, 1.0326778215E+01, 9.7485889167E-01],
	[4.3295000000E+04, 1.0636440572E+02, 1.4353549224E+01, 5.6320119632E+01, 1.0327754898E+01, 9.7486956673E-01],
	[4.3300000000E+04, 1.0638603916E+02, 1.4353661151E+01, 5.6341375208E+01, 1.0328731340E+01, 9.7488023665E-01],
	[4.3305000000E+04, 1.0640767450E+02, 1.4353773065E+01, 5.6362636348E+01, 1.0329707543E+01, 9.7489090142E-01],
	[4.3310000000E+04, 1.0642931174E+02, 1.4353884967E+01, 5.6383903052E+01, 1.0330683506E+01, 9.7490156105E-01],
	[4.3315000000E+04, 1.0645095088E+02, 1.4353996857E+01, 5.6405175322E+01, 1.0331659229E+01, 9.7491221555E-01],
	[4.3320000000E+04, 1.0647259193E+02, 1.4354108735E+01, 5.6426453157E+01, 1.0332634713E+01, 9.7492286491E-01],
	[4.3325000000E+04, 1.0649423487E+02, 1.4354220600E+01, 5.6447736559E+01, 1.0333609957E+01, 9.7493350913E-01],
	[4.3330000000E+04, 1.0651587972E+02, 1.4354332454E+01, 5.6469025529E+01, 1.0334584962E+01, 9.7494414823E-01],
	[4.3335000000E+04, 1.0653752646E+02, 1.4354444296E+01, 5.6490320067E+01, 1.0335559727E+01, 9.7495478220E-01],
	[4.3340000000E+04, 1.0655917511E+02, 1.4354556126E+01, 5.6511620175E+01, 1.0336534253E+01, 9.7496541105E-01],
	[4.3345000000E+04, 1.0658082566E+02, 1.4354667944E+01, 5.6532925852E+01, 1.0337508540E+01, 9.7497603477E-01],
	[4.3350000000E+04, 1.0660247811E+02, 1.4354779749E+01, 5.6554237101E+01, 1.0338482587E+01, 9.7498665338E-01],
	[4.3355000000E+04, 1.0662413246E+02, 1.4354891543E+01, 5.6575553921E+01, 1.0339456396E+01, 9.7499726686E-01],
	[4.3360000000E+04, 1.0664578871E+02, 1.4355003325E+01, 5.6596876313E+01, 1.0340429965E+01, 9.7500787524E-01],
	[4.3365000000E+04, 1.0666744686E+02, 1.4355115094E+01, 5.6618204279E+01, 1.0341403295E+01, 9.7501847850E-01],
	[4.3370000000E+04, 1.0668910691E+02, 1.4355226852E+01, 5.6639537819E+01, 1.0342376386E+01, 9.7502907665E-01],
	[4.3375000000E+04, 1.0671076886E+02, 1.4355338598E+01, 5.6660876934E+01, 1.0343349238E+01, 9.7503966970E-01],
	[4.3380000000E+04, 1.0673243271E+02, 1.4355450331E+01, 5.6682221625E+01, 1.0344321851E+01, 9.7505025764E-01],
	[4.3385000000E+04, 1.0675409847E+02, 1.4355562053E+01, 5.6703571892E+01, 1.0345294225E+01, 9.7506084049E-01],
	[4.3390000000E+04, 1.0677576612E+02, 1.4355673763E+01, 5.6724927737E+01, 1.0346266361E+01, 9.7507141823E-01],
	[4.3395000000E+04, 1.0679743567E+02, 1.4355785460E+01, 5.6746289159E+01, 1.0347238258E+01, 9.7508199088E-01],
	[4.3400000000E+04, 1.0681910713E+02, 1.4355897146E+01, 5.6767656161E+01, 1.0348209916E+01, 9.7509255843E-01],
	[4.3405000000E+04, 1.0684078048E+02, 1.4356008820E+01, 5.6789028743E+01, 1.0349181335E+01, 9.7510312090E-01],
	[4.3410000000E+04, 1.0686245574E+02, 1.4356120481E+01, 5.6810406905E+01, 1.0350152516E+01, 9.7511367828E-01],
	[4.3415000000E+04, 1.0688413289E+02, 1.4356232131E+01, 5.6831790649E+01, 1.0351123458E+01, 9.7512423057E-01],
	[4.3420000000E+04, 1.0690581195E+02, 1.4356343768E+01, 5.6853179975E+01, 1.0352094162E+01, 9.7513477777E-01],
	[4.3425000000E+04, 1.0692749290E+02, 1.4356455394E+01, 5.6874574884E+01, 1.0353064628E+01, 9.7514531990E-01],
	[4.3430000000E+04, 1.0694917576E+02, 1.4356567008E+01, 5.6895975377E+01, 1.0354034855E+01, 9.7515585695E-01],
	[4.3435000000E+04, 1.0697086051E+02, 1.4356678609E+01, 5.6917381454E+01, 1.0355004844E+01, 9.7516638893E-01],
	[4.3440000000E+04, 1.0699254717E+02, 1.4356790199E+01, 5.6938793117E+01, 1.0355974594E+01, 9.7517691583E-01],
	[4.3445000000E+04, 1.0701423572E+02, 1.4356901777E+01, 5.6960210367E+01, 1.0356944107E+01, 9.7518743766E-01],
	[4.3450000000E+04, 1.0703592618E+02, 1.4357013343E+01, 5.6981633203E+01, 1.0357913381E+01, 9.7519795443E-01],
	[4.3455000000E+04, 1.0705761853E+02, 1.4357124896E+01, 5.7003061628E+01, 1.0358882417E+01, 9.7520846613E-01],
	[4.3460000000E+04, 1.0707931279E+02, 1.4357236438E+01, 5.7024495641E+01, 1.0359851215E+01, 9.7521897276E-01],
	[4.3465000000E+04, 1.0710100894E+02, 1.4357347968E+01, 5.7045935244E+01, 1.0360819776E+01, 9.7522947434E-01],
	[4.3470000000E+04, 1.0712270699E+02, 1.4357459486E+01, 5.7067380437E+01, 1.0361788098E+01, 9.7523997086E-01],
	[4.3475000000E+04, 1.0714440695E+02, 1.4357570992E+01, 5.7088831222E+01, 1.0362756182E+01, 9.7525046233E-01],
	[4.3480000000E+04, 1.0716610880E+02, 1.4357682486E+01, 5.7110287598E+01, 1.0363724029E+01, 9.7526094875E-01],
	[4.3485000000E+04, 1.0718781255E+02, 1.4357793968E+01, 5.7131749567E+01, 1.0364691638E+01, 9.7527143011E-01],
	[4.3490000000E+04, 1.0720951820E+02, 1.4357905438E+01, 5.7153217130E+01, 1.0365659009E+01, 9.7528190643E-01],
	[4.3495000000E+04, 1.0723122575E+02, 1.4358016896E+01, 5.7174690287E+01, 1.0366626143E+01, 9.7529237771E-01],
	[4.3500000000E+04, 1.0725293520E+02, 1.4358128342E+01, 5.7196169040E+01, 1.0367593039E+01, 9.7530284394E-01],
	[4.3505000000E+04, 1.0727464655E+02, 1.4358239776E+01, 5.7217653389E+01, 1.0368559698E+01, 9.7531330514E-01],
	[4.3510000000E+04, 1.0729635980E+02, 1.4358351199E+01, 5.7239143334E+01, 1.0369526119E+01, 9.7532376130E-01],
	[4.3515000000E+04, 1.0731807494E+02, 1.4358462609E+01, 5.7260638878E+01, 1.0370492303E+01, 9.7533421243E-01],
	[4.3520000000E+04, 1.0733979199E+02, 1.4358574008E+01, 5.7282140019E+01, 1.0371458249E+01, 9.7534465852E-01],
	[4.3525000000E+04, 1.0736151094E+02, 1.4358685394E+01, 5.7303646761E+01, 1.0372423958E+01, 9.7535509959E-01],
	[4.3530000000E+04, 1.0738323178E+02, 1.4358796769E+01, 5.7325159102E+01, 1.0373389430E+01, 9.7536553563E-01],
	[4.3535000000E+04, 1.0740495452E+02, 1.4358908131E+01, 5.7346677044E+01, 1.0374354665E+01, 9.7537596665E-01],
	[4.3540000000E+04, 1.0742667917E+02, 1.4359019482E+01, 5.7368200588E+01, 1.0375319662E+01, 9.7538639264E-01],
	[4.3545000000E+04, 1.0744840571E+02, 1.4359130821E+01, 5.7389729735E+01, 1.0376284423E+01, 9.7539681362E-01],
	[4.3550000000E+04, 1.0747013415E+02, 1.4359242147E+01, 5.7411264485E+01, 1.0377248946E+01, 9.7540722958E-01],
	[4.3555000000E+04, 1.0749186448E+02, 1.4359353462E+01, 5.7432804839E+01, 1.0378213233E+01, 9.7541764053E-01],
	[4.3560000000E+04, 1.0751359672E+02, 1.4359464765E+01, 5.7454350798E+01, 1.0379177282E+01, 9.7542804647E-01],
	[4.3565000000E+04, 1.0753533086E+02, 1.4359576057E+01, 5.7475902364E+01, 1.0380141095E+01, 9.7543844741E-01],
	[4.3570000000E+04, 1.0755706689E+02, 1.4359687336E+01, 5.7497459535E+01, 1.0381104671E+01, 9.7544884333E-01],
	[4.3575000000E+04, 1.0757880482E+02, 1.4359798603E+01, 5.7519022315E+01, 1.0382068011E+01, 9.7545923426E-01],
	[4.3580000000E+04, 1.0760054466E+02, 1.4359909858E+01, 5.7540590702E+01, 1.0383031113E+01, 9.7546962018E-01],
	[4.3585000000E+04, 1.0762228638E+02, 1.4360021102E+01, 5.7562164699E+01, 1.0383993979E+01, 9.7548000111E-01],
	[4.3590000000E+04, 1.0764403001E+02, 1.4360132333E+01, 5.7583744305E+01, 1.0384956609E+01, 9.7549037704E-01],
	[4.3595000000E+04, 1.0766577554E+02, 1.4360243553E+01, 5.7605329523E+01, 1.0385919002E+01, 9.7550074798E-01],
	[4.3600000000E+04, 1.0768752296E+02, 1.4360354761E+01, 5.7626920351E+01, 1.0386881158E+01, 9.7551111393E-01],
	[4.3605000000E+04, 1.0770927229E+02, 1.4360465957E+01, 5.7648516793E+01, 1.0387843078E+01, 9.7552147489E-01],
	[4.3610000000E+04, 1.0773102351E+02, 1.4360577141E+01, 5.7670118847E+01, 1.0388804762E+01, 9.7553183087E-01],
	[4.3615000000E+04, 1.0775277662E+02, 1.4360688313E+01, 5.7691726515E+01, 1.0389766210E+01, 9.7554218186E-01],
	[4.3620000000E+04, 1.0777453164E+02, 1.4360799473E+01, 5.7713339798E+01, 1.0390727421E+01, 9.7555252788E-01],
	[4.3625000000E+04, 1.0779628856E+02, 1.4360910622E+01, 5.7734958697E+01, 1.0391688396E+01, 9.7556286892E-01],
	[4.3630000000E+04, 1.0781804737E+02, 1.4361021758E+01, 5.7756583212E+01, 1.0392649135E+01, 9.7557320499E-01],
	[4.3635000000E+04, 1.0783980808E+02, 1.4361132883E+01, 5.7778213345E+01, 1.0393609638E+01, 9.7558353608E-01],
	[4.3640000000E+04, 1.0786157069E+02, 1.4361243995E+01, 5.7799849095E+01, 1.0394569905E+01, 9.7559386220E-01],
	[4.3645000000E+04, 1.0788333519E+02, 1.4361355096E+01, 5.7821490464E+01, 1.0395529936E+01, 9.7560418336E-01],
	[4.3650000000E+04, 1.0790510160E+02, 1.4361466185E+01, 5.7843137453E+01, 1.0396489731E+01, 9.7561449956E-01],
	[4.3655000000E+04, 1.0792686990E+02, 1.4361577262E+01, 5.7864790063E+01, 1.0397449290E+01, 9.7562481079E-01],
	[4.3660000000E+04, 1.0794864010E+02, 1.4361688328E+01, 5.7886448294E+01, 1.0398408614E+01, 9.7563511706E-01],
	[4.3665000000E+04, 1.0797041219E+02, 1.4361799381E+01, 5.7908112147E+01, 1.0399367702E+01, 9.7564541838E-01],
	[4.3670000000E+04, 1.0799218619E+02, 1.4361910423E+01, 5.7929781623E+01, 1.0400326554E+01, 9.7565571474E-01],
	[4.3675000000E+04, 1.0801396208E+02, 1.4362021452E+01, 5.7951456722E+01, 1.0401285170E+01, 9.7566600615E-01],
	[4.3680000000E+04, 1.0803573987E+02, 1.4362132470E+01, 5.7973137446E+01, 1.0402243551E+01, 9.7567629262E-01],
	[4.3685000000E+04, 1.0805751955E+02, 1.4362243476E+01, 5.7994823796E+01, 1.0403201697E+01, 9.7568657414E-01],
	[4.3690000000E+04, 1.0807930114E+02, 1.4362354470E+01, 5.8016515772E+01, 1.0404159607E+01, 9.7569685071E-01],
	[4.3695000000E+04, 1.0810108462E+02, 1.4362465453E+01, 5.8038213374E+01, 1.0405117281E+01, 9.7570712234E-01],
	[4.3700000000E+04, 1.0812287000E+02, 1.4362576423E+01, 5.8059916605E+01, 1.0406074721E+01, 9.7571738904E-01],
	[4.3705000000E+04, 1.0814465727E+02, 1.4362687382E+01, 5.8081625464E+01, 1.0407031925E+01, 9.7572765080E-01],
	[4.3710000000E+04, 1.0816644644E+02, 1.4362798328E+01, 5.8103339953E+01, 1.0407988893E+01, 9.7573790762E-01],
	[4.3715000000E+04, 1.0818823751E+02, 1.4362909263E+01, 5.8125060072E+01, 1.0408945627E+01, 9.7574815952E-01],
	[4.3720000000E+04, 1.0821003048E+02, 1.4363020186E+01, 5.8146785822E+01, 1.0409902126E+01, 9.7575840648E-01],
	[4.3725000000E+04, 1.0823182534E+02, 1.4363131098E+01, 5.8168517204E+01, 1.0410858389E+01, 9.7576864853E-01],
	[4.3730000000E+04, 1.0825362210E+02, 1.4363241997E+01, 5.8190254219E+01, 1.0411814418E+01, 9.7577888564E-01],
	[4.3735000000E+04, 1.0827542076E+02, 1.4363352885E+01, 5.8211996867E+01, 1.0412770211E+01, 9.7578911784E-01],
	[4.3740000000E+04, 1.0829722131E+02, 1.4363463761E+01, 5.8233745149E+01, 1.0413725770E+01, 9.7579934512E-01],
	[4.3745000000E+04, 1.0831902377E+02, 1.4363574625E+01, 5.8255499067E+01, 1.0414681094E+01, 9.7580956749E-01],
	[4.3750000000E+04, 1.0834082811E+02, 1.4363685477E+01, 5.8277258621E+01, 1.0415636183E+01, 9.7581978494E-01],
	[4.3755000000E+04, 1.0836263436E+02, 1.4363796317E+01, 5.8299023811E+01, 1.0416591037E+01, 9.7582999748E-01],
	[4.3760000000E+04, 1.0838444250E+02, 1.4363907146E+01, 5.8320794639E+01, 1.0417545657E+01, 9.7584020512E-01],
	[4.3765000000E+04, 1.0840625253E+02, 1.4364017963E+01, 5.8342571106E+01, 1.0418500042E+01, 9.7585040785E-01],
	[4.3770000000E+04, 1.0842806447E+02, 1.4364128768E+01, 5.8364353212E+01, 1.0419454193E+01, 9.7586060567E-01],
	[4.3775000000E+04, 1.0844987830E+02, 1.4364239561E+01, 5.8386140957E+01, 1.0420408109E+01, 9.7587079860E-01],
	[4.3780000000E+04, 1.0847169402E+02, 1.4364350342E+01, 5.8407934344E+01, 1.0421361790E+01, 9.7588098663E-01],
	[4.3785000000E+04, 1.0849351165E+02, 1.4364461112E+01, 5.8429733372E+01, 1.0422315238E+01, 9.7589116976E-01],
	[4.3790000000E+04, 1.0851533116E+02, 1.4364571869E+01, 5.8451538043E+01, 1.0423268450E+01, 9.7590134800E-01],
	[4.3795000000E+04, 1.0853715258E+02, 1.4364682615E+01, 5.8473348357E+01, 1.0424221429E+01, 9.7591152136E-01],
	[4.3800000000E+04, 1.0855897589E+02, 1.4364793349E+01, 5.8495164315E+01, 1.0425174174E+01, 9.7592168982E-01],
	[4.3805000000E+04, 1.0858080110E+02, 1.4364904072E+01, 5.8516985918E+01, 1.0426126684E+01, 9.7593185340E-01],
	[4.3810000000E+04, 1.0860262820E+02, 1.4365014782E+01, 5.8538813167E+01, 1.0427078960E+01, 9.7594201210E-01],
	[4.3815000000E+04, 1.0862445720E+02, 1.4365125481E+01, 5.8560646063E+01, 1.0428031002E+01, 9.7595216592E-01],
	[4.3820000000E+04, 1.0864628809E+02, 1.4365236168E+01, 5.8582484606E+01, 1.0428982811E+01, 9.7596231486E-01],
	[4.3825000000E+04, 1.0866812089E+02, 1.4365346844E+01, 5.8604328797E+01, 1.0429934385E+01, 9.7597245893E-01],
	[4.3830000000E+04, 1.0868995557E+02, 1.4365457507E+01, 5.8626178637E+01, 1.0430885725E+01, 9.7598259812E-01],
	[4.3835000000E+04, 1.0871179216E+02, 1.4365568159E+01, 5.8648034127E+01, 1.0431836832E+01, 9.7599273245E-01],
	[4.3840000000E+04, 1.0873363063E+02, 1.4365678799E+01, 5.8669895267E+01, 1.0432787705E+01, 9.7600286191E-01],
	[4.3845000000E+04, 1.0875547101E+02, 1.4365789427E+01, 5.8691762059E+01, 1.0433738344E+01, 9.7601298650E-01],
	[4.3850000000E+04, 1.0877731328E+02, 1.4365900043E+01, 5.8713634503E+01, 1.0434688749E+01, 9.7602310623E-01],
	[4.3855000000E+04, 1.0879915744E+02, 1.4366010648E+01, 5.8735512601E+01, 1.0435638921E+01, 9.7603322111E-01],
	[4.3860000000E+04, 1.0882100350E+02, 1.4366121241E+01, 5.8757396352E+01, 1.0436588859E+01, 9.7604333112E-01],
	[4.3865000000E+04, 1.0884285146E+02, 1.4366231822E+01, 5.8779285758E+01, 1.0437538564E+01, 9.7605343629E-01],
	[4.3870000000E+04, 1.0886470131E+02, 1.4366342392E+01, 5.8801180819E+01, 1.0438488036E+01, 9.7606353660E-01],
	[4.3875000000E+04, 1.0888655306E+02, 1.4366452949E+01, 5.8823081537E+01, 1.0439437274E+01, 9.7607363206E-01],
	[4.3880000000E+04, 1.0890842742E+02, 1.4366565932E+01, 5.8844987912E+01, 1.0440387756E+01, 9.7608372267E-01],
	[4.3885000000E+04, 1.0893032812E+02, 1.4366681775E+01, 5.8866899945E+01, 1.0441339747E+01, 9.7609380844E-01],
	[4.3890000000E+04, 1.0895223072E+02, 1.4366797607E+01, 5.8888817637E+01, 1.0442291505E+01, 9.7610388937E-01],
	[4.3895000000E+04, 1.0897413523E+02, 1.4366913426E+01, 5.8910740988E+01, 1.0443243031E+01, 9.7611396547E-01],
	[4.3900000000E+04, 1.0899604165E+02, 1.4367029233E+01, 5.8932670000E+01, 1.0444194324E+01, 9.7612403672E-01],
	[4.3905000000E+04, 1.0901794998E+02, 1.4367145027E+01, 5.8954604673E+01, 1.0445145385E+01, 9.7613410314E-01],
	[4.3910000000E+04, 1.0903986022E+02, 1.4367260810E+01, 5.8976545008E+01, 1.0446096214E+01, 9.7614416473E-01],
	[4.3915000000E+04, 1.0906177236E+02, 1.4367376580E+01, 5.8998491006E+01, 1.0447046810E+01, 9.7615422149E-01],
	[4.3920000000E+04, 1.0908368642E+02, 1.4367492337E+01, 5.9020442668E+01, 1.0447997174E+01, 9.7616427342E-01],
	[4.3925000000E+04, 1.0910560238E+02, 1.4367608083E+01, 5.9042399994E+01, 1.0448947305E+01, 9.7617432053E-01],
	[4.3930000000E+04, 1.0912752025E+02, 1.4367723816E+01, 5.9064362985E+01, 1.0449897205E+01, 9.7618436282E-01],
	[4.3935000000E+04, 1.0914944002E+02, 1.4367839537E+01, 5.9086331643E+01, 1.0450846872E+01, 9.7619440029E-01],
	[4.3940000000E+04, 1.0917136170E+02, 1.4367955246E+01, 5.9108305967E+01, 1.0451796308E+01, 9.7620443295E-01],
	[4.3945000000E+04, 1.0919328530E+02, 1.4368070943E+01, 5.9130285960E+01, 1.0452745511E+01, 9.7621446079E-01],
	[4.3950000000E+04, 1.0921521079E+02, 1.4368186627E+01, 5.9152271620E+01, 1.0453694482E+01, 9.7622448382E-01],
	[4.3955000000E+04, 1.0923713820E+02, 1.4368302299E+01, 5.9174262951E+01, 1.0454643222E+01, 9.7623450204E-01],
	[4.3960000000E+04, 1.0925906752E+02, 1.4368417959E+01, 5.9196259951E+01, 1.0455591730E+01, 9.7624451545E-01],
	[4.3965000000E+04, 1.0928099874E+02, 1.4368533607E+01, 5.9218262623E+01, 1.0456540006E+01, 9.7625452407E-01],
	[4.3970000000E+04, 1.0930293187E+02, 1.4368649242E+01, 5.9240270966E+01, 1.0457488050E+01, 9.7626452788E-01],
	[4.3975000000E+04, 1.0932486690E+02, 1.4368764866E+01, 5.9262284982E+01, 1.0458435862E+01, 9.7627452689E-01],
	[4.3980000000E+04, 1.0934680384E+02, 1.4368880477E+01, 5.9284304672E+01, 1.0459383443E+01, 9.7628452110E-01],
	[4.3985000000E+04, 1.0936874270E+02, 1.4368996075E+01, 5.9306330035E+01, 1.0460330793E+01, 9.7629451053E-01],
	[4.3990000000E+04, 1.0939068345E+02, 1.4369111662E+01, 5.9328361074E+01, 1.0461277910E+01, 9.7630449516E-01],
	[4.3995000000E+04, 1.0941262612E+02, 1.4369227236E+01, 5.9350397789E+01, 1.0462224797E+01, 9.7631447500E-01],
	[4.4000000000E+04, 1.0943457069E+02, 1.4369342799E+01, 5.9372440181E+01, 1.0463171452E+01, 9.7632445006E-01],
	[4.4005000000E+04, 1.0945651717E+02, 1.4369458349E+01, 5.9394488250E+01, 1.0464117876E+01, 9.7633442033E-01],
	[4.4010000000E+04, 1.0947846556E+02, 1.4369573886E+01, 5.9416541997E+01, 1.0465064068E+01, 9.7634438583E-01],
	[4.4015000000E+04, 1.0950041585E+02, 1.4369689412E+01, 5.9438601424E+01, 1.0466010029E+01, 9.7635434654E-01],
	[4.4020000000E+04, 1.0952236805E+02, 1.4369804925E+01, 5.9460666530E+01, 1.0466955759E+01, 9.7636430248E-01],
	[4.4025000000E+04, 1.0954432216E+02, 1.4369920427E+01, 5.9482737318E+01, 1.0467901258E+01, 9.7637425365E-01],
	[4.4030000000E+04, 1.0956627817E+02, 1.4370035916E+01, 5.9504813787E+01, 1.0468846526E+01, 9.7638420004E-01],
	[4.4035000000E+04, 1.0958823609E+02, 1.4370151393E+01, 5.9526895939E+01, 1.0469791563E+01, 9.7639414167E-01],
	[4.4040000000E+04, 1.0961019592E+02, 1.4370266857E+01, 5.9548983773E+01, 1.0470736369E+01, 9.7640407853E-01],
	[4.4045000000E+04, 1.0963215765E+02, 1.4370382310E+01, 5.9571077292E+01, 1.0471680944E+01, 9.7641401063E-01],
	[4.4050000000E+04, 1.0965412129E+02, 1.4370497750E+01, 5.9593176496E+01, 1.0472625288E+01, 9.7642393796E-01],
	[4.4055000000E+04, 1.0967608684E+02, 1.4370613178E+01, 5.9615281386E+01, 1.0473569402E+01, 9.7643386054E-01],
	[4.4060000000E+04, 1.0969805429E+02, 1.4370728594E+01, 5.9637391962E+01, 1.0474513285E+01, 9.7644377836E-01],
	[4.4065000000E+04, 1.0972002365E+02, 1.4370843998E+01, 5.9659508225E+01, 1.0475456937E+01, 9.7645369143E-01],
	[4.4070000000E+04, 1.0974199492E+02, 1.4370959389E+01, 5.9681630177E+01, 1.0476400358E+01, 9.7646359975E-01],
	[4.4075000000E+04, 1.0976396809E+02, 1.4371074769E+01, 5.9703757817E+01, 1.0477343549E+01, 9.7647350332E-01],
	[4.4080000000E+04, 1.0978594317E+02, 1.4371190136E+01, 5.9725891148E+01, 1.0478286510E+01, 9.7648340215E-01],
	[4.4085000000E+04, 1.0980792015E+02, 1.4371305491E+01, 5.9748030168E+01, 1.0479229240E+01, 9.7649329623E-01],
	[4.4090000000E+04, 1.0982989905E+02, 1.4371420834E+01, 5.9770174881E+01, 1.0480171739E+01, 9.7650318557E-01],
	[4.4095000000E+04, 1.0985187984E+02, 1.4371536165E+01, 5.9792325285E+01, 1.0481114008E+01, 9.7651307018E-01],
	[4.4100000000E+04, 1.0987386255E+02, 1.4371651484E+01, 5.9814481383E+01, 1.0482056047E+01, 9.7652295004E-01],
	[4.4105000000E+04, 1.0989584716E+02, 1.4371766790E+01, 5.9836643175E+01, 1.0482997856E+01, 9.7653282518E-01],
	[4.4110000000E+04, 1.0991783367E+02, 1.4371882085E+01, 5.9858810661E+01, 1.0483939435E+01, 9.7654269558E-01],
	[4.4115000000E+04, 1.0993982209E+02, 1.4371997367E+01, 5.9880983843E+01, 1.0484880783E+01, 9.7655256126E-01],
	[4.4120000000E+04, 1.0996181242E+02, 1.4372112637E+01, 5.9903162721E+01, 1.0485821902E+01, 9.7656242221E-01],
	[4.4125000000E+04, 1.0998380465E+02, 1.4372227895E+01, 5.9925347296E+01, 1.0486762790E+01, 9.7657227844E-01],
	[4.4130000000E+04, 1.1000579879E+02, 1.4372343141E+01, 5.9947537569E+01, 1.0487703449E+01, 9.7658212994E-01],
	[4.4135000000E+04, 1.1002779484E+02, 1.4372458374E+01, 5.9969733541E+01, 1.0488643877E+01, 9.7659197673E-01],
	[4.4140000000E+04, 1.1004979279E+02, 1.4372573596E+01, 5.9991935213E+01, 1.0489584076E+01, 9.7660181880E-01],
	[4.4145000000E+04, 1.1007179264E+02, 1.4372688805E+01, 6.0014142585E+01, 1.0490524045E+01, 9.7661165616E-01],
	[4.4150000000E+04, 1.1009379440E+02, 1.4372804003E+01, 6.0036355658E+01, 1.0491463784E+01, 9.7662148881E-01],
	[4.4155000000E+04, 1.1011579807E+02, 1.4372919188E+01, 6.0058574433E+01, 1.0492403294E+01, 9.7663131675E-01],
	[4.4160000000E+04, 1.1013780364E+02, 1.4373034361E+01, 6.0080798911E+01, 1.0493342574E+01, 9.7664113999E-01],
	[4.4165000000E+04, 1.1015981112E+02, 1.4373149522E+01, 6.0103029093E+01, 1.0494281624E+01, 9.7665095852E-01],
	[4.4170000000E+04, 1.1018182051E+02, 1.4373264671E+01, 6.0125264979E+01, 1.0495220445E+01, 9.7666077235E-01],
	[4.4175000000E+04, 1.1020383179E+02, 1.4373379807E+01, 6.0147506571E+01, 1.0496159037E+01, 9.7667058148E-01],
	[4.4180000000E+04, 1.1022584499E+02, 1.4373494932E+01, 6.0169753869E+01, 1.0497097399E+01, 9.7668038592E-01],
	[4.4185000000E+04, 1.1024786009E+02, 1.4373610045E+01, 6.0192006873E+01, 1.0498035532E+01, 9.7669018566E-01],
	[4.4190000000E+04, 1.1026987709E+02, 1.4373725145E+01, 6.0214265586E+01, 1.0498973435E+01, 9.7669998072E-01],
	[4.4195000000E+04, 1.1029189600E+02, 1.4373840233E+01, 6.0236530007E+01, 1.0499911110E+01, 9.7670977108E-01],
	[4.4200000000E+04, 1.1031391681E+02, 1.4373955309E+01, 6.0258800137E+01, 1.0500848555E+01, 9.7671955676E-01],
	[4.4205000000E+04, 1.1033593953E+02, 1.4374070373E+01, 6.0281075978E+01, 1.0501785771E+01, 9.7672933776E-01],
	[4.4210000000E+04, 1.1035796416E+02, 1.4374185425E+01, 6.0303357529E+01, 1.0502722758E+01, 9.7673911407E-01],
	[4.4215000000E+04, 1.1037999069E+02, 1.4374300465E+01, 6.0325644793E+01, 1.0503659516E+01, 9.7674888571E-01],
	[4.4220000000E+04, 1.1040201912E+02, 1.4374415493E+01, 6.0347937769E+01, 1.0504596045E+01, 9.7675865267E-01],
	[4.4225000000E+04, 1.1042404946E+02, 1.4374530509E+01, 6.0370236459E+01, 1.0505532345E+01, 9.7676841496E-01],
	[4.4230000000E+04, 1.1044608170E+02, 1.4374645513E+01, 6.0392540862E+01, 1.0506468416E+01, 9.7677817257E-01],
	[4.4235000000E+04, 1.1046811585E+02, 1.4374760504E+01, 6.0414850982E+01, 1.0507404259E+01, 9.7678792552E-01],
	[4.4240000000E+04, 1.1049015191E+02, 1.4374875484E+01, 6.0437166816E+01, 1.0508339872E+01, 9.7679767381E-01],
	[4.4245000000E+04, 1.1051218986E+02, 1.4374990451E+01, 6.0459488368E+01, 1.0509275258E+01, 9.7680741742E-01],
	[4.4250000000E+04, 1.1053422973E+02, 1.4375105407E+01, 6.0481815637E+01, 1.0510210414E+01, 9.7681715638E-01],
	[4.4255000000E+04, 1.1055627149E+02, 1.4375220350E+01, 6.0504148625E+01, 1.0511145342E+01, 9.7682689068E-01],
	[4.4260000000E+04, 1.1057831516E+02, 1.4375335281E+01, 6.0526487332E+01, 1.0512080042E+01, 9.7683662033E-01],
	[4.4265000000E+04, 1.1060036074E+02, 1.4375450200E+01, 6.0548831759E+01, 1.0513014513E+01, 9.7684634532E-01],
	[4.4270000000E+04, 1.1062240822E+02, 1.4375565107E+01, 6.0571181906E+01, 1.0513948755E+01, 9.7685606566E-01],
	[4.4275000000E+04, 1.1064445760E+02, 1.4375680002E+01, 6.0593537776E+01, 1.0514882769E+01, 9.7686578135E-01],
	[4.4280000000E+04, 1.1066650889E+02, 1.4375794885E+01, 6.0615899368E+01, 1.0515816555E+01, 9.7687549239E-01],
	[4.4285000000E+04, 1.1068856209E+02, 1.4375909756E+01, 6.0638266683E+01, 1.0516750113E+01, 9.7688519879E-01],
	[4.4290000000E+04, 1.1071061718E+02, 1.4376024615E+01, 6.0660639722E+01, 1.0517683443E+01, 9.7689490055E-01],
	[4.4295000000E+04, 1.1073267418E+02, 1.4376139462E+01, 6.0683018486E+01, 1.0518616544E+01, 9.7690459767E-01],
	[4.4300000000E+04, 1.1075473309E+02, 1.4376254297E+01, 6.0705402976E+01, 1.0519549418E+01, 9.7691429016E-01],
	[4.4305000000E+04, 1.1077679390E+02, 1.4376369119E+01, 6.0727793192E+01, 1.0520482063E+01, 9.7692397801E-01],
	[4.4310000000E+04, 1.1079885661E+02, 1.4376483930E+01, 6.0750189136E+01, 1.0521414481E+01, 9.7693366123E-01],
	[4.4315000000E+04, 1.1082092123E+02, 1.4376598729E+01, 6.0772590808E+01, 1.0522346670E+01, 9.7694333982E-01],
	[4.4320000000E+04, 1.1084298775E+02, 1.4376713515E+01, 6.0794998209E+01, 1.0523278632E+01, 9.7695301379E-01],
	[4.4325000000E+04, 1.1086505617E+02, 1.4376828290E+01, 6.0817411340E+01, 1.0524210366E+01, 9.7696268313E-01],
	[4.4330000000E+04, 1.1088712650E+02, 1.4376943053E+01, 6.0839830201E+01, 1.0525141873E+01, 9.7697234785E-01],
	[4.4335000000E+04, 1.1090919873E+02, 1.4377057803E+01, 6.0862254794E+01, 1.0526073151E+01, 9.7698200795E-01],
	[4.4340000000E+04, 1.1093127287E+02, 1.4377172542E+01, 6.0884685119E+01, 1.0527004202E+01, 9.7699166344E-01],
	[4.4345000000E+04, 1.1095334891E+02, 1.4377287268E+01, 6.0907121178E+01, 1.0527935026E+01, 9.7700131431E-01],
	[4.4350000000E+04, 1.1097542685E+02, 1.4377401983E+01, 6.0929562970E+01, 1.0528865622E+01, 9.7701096057E-01],
	[4.4355000000E+04, 1.1099750670E+02, 1.4377516685E+01, 6.0952010497E+01, 1.0529795990E+01, 9.7702060222E-01],
	[4.4360000000E+04, 1.1101958845E+02, 1.4377631375E+01, 6.0974463759E+01, 1.0530726131E+01, 9.7703023926E-01],
	[4.4365000000E+04, 1.1104167210E+02, 1.4377746054E+01, 6.0996922758E+01, 1.0531656045E+01, 9.7703987170E-01],
	[4.4370000000E+04, 1.1106375766E+02, 1.4377860720E+01, 6.1019387494E+01, 1.0532585731E+01, 9.7704949954E-01],
	[4.4375000000E+04, 1.1108584512E+02, 1.4377975375E+01, 6.1041857968E+01, 1.0533515191E+01, 9.7705912277E-01],
	[4.4380000000E+04, 1.1110793448E+02, 1.4378090017E+01, 6.1064334181E+01, 1.0534444423E+01, 9.7706874142E-01],
	[4.4385000000E+04, 1.1113002575E+02, 1.4378204647E+01, 6.1086816133E+01, 1.0535373428E+01, 9.7707835546E-01],
	[4.4390000000E+04, 1.1115211892E+02, 1.4378319266E+01, 6.1109303826E+01, 1.0536302206E+01, 9.7708796492E-01],
	[4.4395000000E+04, 1.1117421399E+02, 1.4378433872E+01, 6.1131797261E+01, 1.0537230757E+01, 9.7709756979E-01],
	[4.4400000000E+04, 1.1119631096E+02, 1.4378548467E+01, 6.1154296437E+01, 1.0538159081E+01, 9.7710717007E-01],
	[4.4405000000E+04, 1.1121840984E+02, 1.4378663049E+01, 6.1176801356E+01, 1.0539087178E+01, 9.7711676576E-01],
	[4.4410000000E+04, 1.1124051062E+02, 1.4378777620E+01, 6.1199312019E+01, 1.0540015048E+01, 9.7712635687E-01],
	[4.4415000000E+04, 1.1126261331E+02, 1.4378892178E+01, 6.1221828426E+01, 1.0540942691E+01, 9.7713594341E-01],
	[4.4420000000E+04, 1.1128471790E+02, 1.4379006724E+01, 6.1244350579E+01, 1.0541870108E+01, 9.7714552536E-01],
	[4.4425000000E+04, 1.1130682439E+02, 1.4379121259E+01, 6.1266878478E+01, 1.0542797298E+01, 9.7715510274E-01],
	[4.4430000000E+04, 1.1132893278E+02, 1.4379235781E+01, 6.1289412124E+01, 1.0543724262E+01, 9.7716467555E-01],
	[4.4435000000E+04, 1.1135104307E+02, 1.4379350292E+01, 6.1311951518E+01, 1.0544650999E+01, 9.7717424379E-01],
	[4.4440000000E+04, 1.1137315527E+02, 1.4379464791E+01, 6.1334496661E+01, 1.0545577509E+01, 9.7718380746E-01],
	[4.4445000000E+04, 1.1139526937E+02, 1.4379579277E+01, 6.1357047552E+01, 1.0546503793E+01, 9.7719336657E-01],
	[4.4450000000E+04, 1.1141738538E+02, 1.4379693752E+01, 6.1379604195E+01, 1.0547429850E+01, 9.7720292111E-01],
	[4.4455000000E+04, 1.1143950328E+02, 1.4379808214E+01, 6.1402166588E+01, 1.0548355682E+01, 9.7721247110E-01],
	[4.4460000000E+04, 1.1146162309E+02, 1.4379922665E+01, 6.1424734733E+01, 1.0549281287E+01, 9.7722201653E-01],
	[4.4465000000E+04, 1.1148374480E+02, 1.4380037104E+01, 6.1447308631E+01, 1.0550206665E+01, 9.7723155740E-01],
	[4.4470000000E+04, 1.1150586841E+02, 1.4380151531E+01, 6.1469888282E+01, 1.0551131818E+01, 9.7724109372E-01],
	[4.4475000000E+04, 1.1152799393E+02, 1.4380265945E+01, 6.1492473688E+01, 1.0552056744E+01, 9.7725062549E-01],
	[4.4480000000E+04, 1.1155012135E+02, 1.4380380348E+01, 6.1515064849E+01, 1.0552981445E+01, 9.7726015271E-01],
	[4.4485000000E+04, 1.1157225067E+02, 1.4380494739E+01, 6.1537661766E+01, 1.0553905919E+01, 9.7726967538E-01],
	[4.4490000000E+04, 1.1159438189E+02, 1.4380609118E+01, 6.1560264440E+01, 1.0554830167E+01, 9.7727919352E-01],
	[4.4495000000E+04, 1.1161651501E+02, 1.4380723485E+01, 6.1582872871E+01, 1.0555754190E+01, 9.7728870711E-01],
	[4.4500000000E+04, 1.1163865004E+02, 1.4380837840E+01, 6.1605487061E+01, 1.0556677986E+01, 9.7729821616E-01],
	[4.4505000000E+04, 1.1166078697E+02, 1.4380952183E+01, 6.1628107010E+01, 1.0557601557E+01, 9.7730772068E-01],
	[4.4510000000E+04, 1.1168292580E+02, 1.4381066515E+01, 6.1650732719E+01, 1.0558524902E+01, 9.7731722067E-01],
	[4.4515000000E+04, 1.1170506653E+02, 1.4381180834E+01, 6.1673364190E+01, 1.0559448022E+01, 9.7732671612E-01],
	[4.4520000000E+04, 1.1172720916E+02, 1.4381295141E+01, 6.1696001421E+01, 1.0560370916E+01, 9.7733620705E-01],
	[4.4525000000E+04, 1.1174935370E+02, 1.4381409437E+01, 6.1718644416E+01, 1.0561293584E+01, 9.7734569345E-01],
	[4.4530000000E+04, 1.1177150013E+02, 1.4381523720E+01, 6.1741293174E+01, 1.0562216027E+01, 9.7735517532E-01],
	[4.4535000000E+04, 1.1179364847E+02, 1.4381637992E+01, 6.1763947695E+01, 1.0563138244E+01, 9.7736465268E-01],
	[4.4540000000E+04, 1.1181579871E+02, 1.4381752251E+01, 6.1786607982E+01, 1.0564060236E+01, 9.7737412552E-01],
	[4.4545000000E+04, 1.1183795085E+02, 1.4381866499E+01, 6.1809274035E+01, 1.0564982003E+01, 9.7738359384E-01],
	[4.4550000000E+04, 1.1186010490E+02, 1.4381980735E+01, 6.1831945855E+01, 1.0565903544E+01, 9.7739305765E-01],
	[4.4555000000E+04, 1.1188226084E+02, 1.4382094959E+01, 6.1854623441E+01, 1.0566824860E+01, 9.7740251694E-01],
	[4.4560000000E+04, 1.1190441869E+02, 1.4382209171E+01, 6.1877306797E+01, 1.0567745951E+01, 9.7741197173E-01],
	[4.4565000000E+04, 1.1192657844E+02, 1.4382323371E+01, 6.1899995921E+01, 1.0568666817E+01, 9.7742142201E-01],
	[4.4570000000E+04, 1.1194874008E+02, 1.4382437559E+01, 6.1922690815E+01, 1.0569587457E+01, 9.7743086779E-01],
	[4.4575000000E+04, 1.1197090364E+02, 1.4382551735E+01, 6.1945391480E+01, 1.0570507873E+01, 9.7744030906E-01],
	[4.4580000000E+04, 1.1199306909E+02, 1.4382665900E+01, 6.1968097916E+01, 1.0571428064E+01, 9.7744974584E-01],
	[4.4585000000E+04, 1.1201524472E+02, 1.4382781012E+01, 6.1990810125E+01, 1.0572348622E+01, 9.7745917812E-01],
	[4.4590000000E+04, 1.1203745880E+02, 1.4382900350E+01, 6.2013528107E+01, 1.0573271571E+01, 9.7746860590E-01],
	[4.4595000000E+04, 1.1205967479E+02, 1.4383019675E+01, 6.2036251863E+01, 1.0574194295E+01, 9.7747802919E-01],
	[4.4600000000E+04, 1.1208189270E+02, 1.4383138988E+01, 6.2058981394E+01, 1.0575116796E+01, 9.7748744800E-01],
	[4.4605000000E+04, 1.1210411252E+02, 1.4383258288E+01, 6.2081716700E+01, 1.0576039072E+01, 9.7749686231E-01],
	[4.4610000000E+04, 1.1212633425E+02, 1.4383377576E+01, 6.2104457783E+01, 1.0576961124E+01, 9.7750627214E-01],
	[4.4615000000E+04, 1.1214855790E+02, 1.4383496852E+01, 6.2127204643E+01, 1.0577882953E+01, 9.7751567749E-01],
	[4.4620000000E+04, 1.1217078346E+02, 1.4383616116E+01, 6.2149957281E+01, 1.0578804557E+01, 9.7752507836E-01],
	[4.4625000000E+04, 1.1219301094E+02, 1.4383735367E+01, 6.2172715699E+01, 1.0579725937E+01, 9.7753447475E-01],
	[4.4630000000E+04, 1.1221524033E+02, 1.4383854605E+01, 6.2195479895E+01, 1.0580647094E+01, 9.7754386667E-01],
	[4.4635000000E+04, 1.1223747163E+02, 1.4383973831E+01, 6.2218249873E+01, 1.0581568027E+01, 9.7755325411E-01],
	[4.4640000000E+04, 1.1225970485E+02, 1.4384093045E+01, 6.2241025632E+01, 1.0582488736E+01, 9.7756263709E-01],
	[4.4645000000E+04, 1.1228193998E+02, 1.4384212247E+01, 6.2263807173E+01, 1.0583409221E+01, 9.7757201559E-01],
	[4.4650000000E+04, 1.1230417702E+02, 1.4384331436E+01, 6.2286594497E+01, 1.0584329483E+01, 9.7758138963E-01],
	[4.4655000000E+04, 1.1232641598E+02, 1.4384450613E+01, 6.2309387605E+01, 1.0585249521E+01, 9.7759075921E-01],
	[4.4660000000E+04, 1.1234865685E+02, 1.4384569777E+01, 6.2332186497E+01, 1.0586169335E+01, 9.7760012433E-01],
	[4.4665000000E+04, 1.1237089963E+02, 1.4384688929E+01, 6.2354991175E+01, 1.0587088926E+01, 9.7760948499E-01],
	[4.4670000000E+04, 1.1239314432E+02, 1.4384808069E+01, 6.2377801640E+01, 1.0588008294E+01, 9.7761884119E-01],
	[4.4675000000E+04, 1.1241539093E+02, 1.4384927197E+01, 6.2400617891E+01, 1.0588927439E+01, 9.7762819294E-01],
	[4.4680000000E+04, 1.1243763945E+02, 1.4385046312E+01, 6.2423439930E+01, 1.0589846360E+01, 9.7763754024E-01],
	[4.4685000000E+04, 1.1245988989E+02, 1.4385165414E+01, 6.2446267758E+01, 1.0590765057E+01, 9.7764688309E-01],
	[4.4690000000E+04, 1.1248214223E+02, 1.4385284505E+01, 6.2469101376E+01, 1.0591683532E+01, 9.7765622149E-01],
	[4.4695000000E+04, 1.1250439649E+02, 1.4385403583E+01, 6.2491940784E+01, 1.0592601784E+01, 9.7766555545E-01],
	[4.4700000000E+04, 1.1252665267E+02, 1.4385522648E+01, 6.2514785983E+01, 1.0593519812E+01, 9.7767488497E-01],
	[4.4705000000E+04, 1.1254891075E+02, 1.4385641702E+01, 6.2537636975E+01, 1.0594437617E+01, 9.7768421005E-01],
	[4.4710000000E+04, 1.1257117075E+02, 1.4385760743E+01, 6.2560493759E+01, 1.0595355200E+01, 9.7769353069E-01],
	[4.4715000000E+04, 1.1259343266E+02, 1.4385879772E+01, 6.2583356336E+01, 1.0596272559E+01, 9.7770284690E-01],
	[4.4720000000E+04, 1.1261569648E+02, 1.4385998788E+01, 6.2606224709E+01, 1.0597189696E+01, 9.7771215868E-01],
	[4.4725000000E+04, 1.1263796222E+02, 1.4386117792E+01, 6.2629098876E+01, 1.0598106610E+01, 9.7772146603E-01],
	[4.4730000000E+04, 1.1266022987E+02, 1.4386236784E+01, 6.2651978840E+01, 1.0599023301E+01, 9.7773076895E-01],
	[4.4735000000E+04, 1.1268249943E+02, 1.4386355763E+01, 6.2674864601E+01, 1.0599939769E+01, 9.7774006745E-01],
	[4.4740000000E+04, 1.1270477090E+02, 1.4386474730E+01, 6.2697756159E+01, 1.0600856015E+01, 9.7774936152E-01],
	[4.4745000000E+04, 1.1272704428E+02, 1.4386593685E+01, 6.2720653516E+01, 1.0601772038E+01, 9.7775865117E-01],
	[4.4750000000E+04, 1.1274931958E+02, 1.4386712628E+01, 6.2743556672E+01, 1.0602687839E+01, 9.7776793641E-01],
	[4.4755000000E+04, 1.1277159679E+02, 1.4386831558E+01, 6.2766465629E+01, 1.0603603417E+01, 9.7777721723E-01],
	[4.4760000000E+04, 1.1279387591E+02, 1.4386950476E+01, 6.2789380386E+01, 1.0604518772E+01, 9.7778649364E-01],
	[4.4765000000E+04, 1.1281615695E+02, 1.4387069381E+01, 6.2812300946E+01, 1.0605433906E+01, 9.7779576564E-01],
	[4.4770000000E+04, 1.1283843989E+02, 1.4387188274E+01, 6.2835227308E+01, 1.0606348817E+01, 9.7780503323E-01],
	[4.4775000000E+04, 1.1286072475E+02, 1.4387307155E+01, 6.2858159474E+01, 1.0607263506E+01, 9.7781429642E-01],
	[4.4780000000E+04, 1.1288301152E+02, 1.4387426024E+01, 6.2881097444E+01, 1.0608177972E+01, 9.7782355520E-01],
	[4.4785000000E+04, 1.1290530020E+02, 1.4387544881E+01, 6.2904041219E+01, 1.0609092217E+01, 9.7783280958E-01],
	[4.4790000000E+04, 1.1292759080E+02, 1.4387663725E+01, 6.2926990800E+01, 1.0610006239E+01, 9.7784205956E-01],
	[4.4795000000E+04, 1.1294988330E+02, 1.4387782557E+01, 6.2949946187E+01, 1.0610920039E+01, 9.7785130515E-01],
	[4.4800000000E+04, 1.1297217772E+02, 1.4387901376E+01, 6.2972907383E+01, 1.0611833618E+01, 9.7786054634E-01],
	[4.4805000000E+04, 1.1299447405E+02, 1.4388020183E+01, 6.2995874387E+01, 1.0612746974E+01, 9.7786978315E-01],
	[4.4810000000E+04, 1.1301677229E+02, 1.4388138978E+01, 6.3018847200E+01, 1.0613660108E+01, 9.7787901556E-01],
	[4.4815000000E+04, 1.1303907244E+02, 1.4388257761E+01, 6.3041825823E+01, 1.0614573021E+01, 9.7788824359E-01],
	[4.4820000000E+04, 1.1306137451E+02, 1.4388376532E+01, 6.3064810257E+01, 1.0615485712E+01, 9.7789746723E-01],
	[4.4825000000E+04, 1.1308367848E+02, 1.4388495290E+01, 6.3087800503E+01, 1.0616398181E+01, 9.7790668649E-01],
	[4.4830000000E+04, 1.1310598437E+02, 1.4388614036E+01, 6.3110796561E+01, 1.0617310429E+01, 9.7791590137E-01],
	[4.4835000000E+04, 1.1312829217E+02, 1.4388732769E+01, 6.3133798432E+01, 1.0618222455E+01, 9.7792511188E-01],
	[4.4840000000E+04, 1.1315060188E+02, 1.4388851491E+01, 6.3156806118E+01, 1.0619134259E+01, 9.7793431801E-01],
	[4.4845000000E+04, 1.1317291350E+02, 1.4388970200E+01, 6.3179819619E+01, 1.0620045842E+01, 9.7794351977E-01],
	[4.4850000000E+04, 1.1319522703E+02, 1.4389088897E+01, 6.3202838935E+01, 1.0620957204E+01, 9.7795271716E-01],
	[4.4855000000E+04, 1.1321754248E+02, 1.4389207581E+01, 6.3225864068E+01, 1.0621868344E+01, 9.7796191018E-01],
	[4.4860000000E+04, 1.1323985983E+02, 1.4389326254E+01, 6.3248895019E+01, 1.0622779262E+01, 9.7797109883E-01],
	[4.4865000000E+04, 1.1326217910E+02, 1.4389444914E+01, 6.3271931787E+01, 1.0623689960E+01, 9.7798028313E-01],
	[4.4870000000E+04, 1.1328450028E+02, 1.4389563562E+01, 6.3294974375E+01, 1.0624600436E+01, 9.7798946306E-01],
	[4.4875000000E+04, 1.1330682336E+02, 1.4389682197E+01, 6.3318022783E+01, 1.0625510691E+01, 9.7799863864E-01],
	[4.4880000000E+04, 1.1332914836E+02, 1.4389800821E+01, 6.3341077012E+01, 1.0626420725E+01, 9.7800780986E-01],
	[4.4885000000E+04, 1.1335147527E+02, 1.4389919432E+01, 6.3364137062E+01, 1.0627330538E+01, 9.7801697672E-01],
	[4.4890000000E+04, 1.1337380410E+02, 1.4390038031E+01, 6.3387202934E+01, 1.0628240130E+01, 9.7802613924E-01],
	[4.4895000000E+04, 1.1339613483E+02, 1.4390156618E+01, 6.3410274629E+01, 1.0629149501E+01, 9.7803529740E-01],
	[4.4900000000E+04, 1.1341846747E+02, 1.4390275192E+01, 6.3433352149E+01, 1.0630058651E+01, 9.7804445122E-01],
	[4.4905000000E+04, 1.1344080202E+02, 1.4390393754E+01, 6.3456435493E+01, 1.0630967581E+01, 9.7805360070E-01],
	[4.4910000000E+04, 1.1346313849E+02, 1.4390512304E+01, 6.3479524663E+01, 1.0631876289E+01, 9.7806274584E-01],
	[4.4915000000E+04, 1.1348547686E+02, 1.4390630842E+01, 6.3502619660E+01, 1.0632784777E+01, 9.7807188663E-01],
	[4.4920000000E+04, 1.1350781715E+02, 1.4390749368E+01, 6.3525720483E+01, 1.0633693044E+01, 9.7808102309E-01],
	[4.4925000000E+04, 1.1353015934E+02, 1.4390867881E+01, 6.3548827135E+01, 1.0634601091E+01, 9.7809015522E-01],
	[4.4930000000E+04, 1.1355250345E+02, 1.4390986382E+01, 6.3571939616E+01, 1.0635508917E+01, 9.7809928301E-01],
	[4.4935000000E+04, 1.1357484947E+02, 1.4391104871E+01, 6.3595057926E+01, 1.0636416522E+01, 9.7810840647E-01],
	[4.4940000000E+04, 1.1359719740E+02, 1.4391223348E+01, 6.3618182067E+01, 1.0637323907E+01, 9.7811752561E-01],
	[4.4945000000E+04, 1.1361954723E+02, 1.4391341812E+01, 6.3641312040E+01, 1.0638231072E+01, 9.7812664042E-01],
	[4.4950000000E+04, 1.1364189898E+02, 1.4391460265E+01, 6.3664447844E+01, 1.0639138016E+01, 9.7813575091E-01],
	[4.4955000000E+04, 1.1366425264E+02, 1.4391578705E+01, 6.3687589482E+01, 1.0640044740E+01, 9.7814485708E-01],
	[4.4960000000E+04, 1.1368660821E+02, 1.4391697133E+01, 6.3710736953E+01, 1.0640951244E+01, 9.7815395893E-01],
	[4.4965000000E+04, 1.1370896569E+02, 1.4391815548E+01, 6.3733890259E+01, 1.0641857527E+01, 9.7816305646E-01],
	[4.4970000000E+04, 1.1373132508E+02, 1.4391933952E+01, 6.3757049401E+01, 1.0642763591E+01, 9.7817214968E-01],
	[4.4975000000E+04, 1.1375368637E+02, 1.4392052343E+01, 6.3780214379E+01, 1.0643669434E+01, 9.7818123859E-01],
	[4.4980000000E+04, 1.1377604958E+02, 1.4392170723E+01, 6.3803385194E+01, 1.0644575058E+01, 9.7819032320E-01],
	[4.4985000000E+04, 1.1379841470E+02, 1.4392289089E+01, 6.3826561847E+01, 1.0645480461E+01, 9.7819940349E-01],
	[4.4990000000E+04, 1.1382078173E+02, 1.4392407444E+01, 6.3849744339E+01, 1.0646385644E+01, 9.7820847948E-01],
	[4.4995000000E+04, 1.1384315067E+02, 1.4392525787E+01, 6.3872932670E+01, 1.0647290608E+01, 9.7821755117E-01],
	[4.5000000000E+04, 1.1386552152E+02, 1.4392644117E+01, 6.3896126842E+01, 1.0648195352E+01, 9.7822661857E-01],
	[4.5005000000E+04, 1.1388789427E+02, 1.4392762436E+01, 6.3919377674E+01, 1.0649101287E+01, 9.7823568166E-01],
	[4.5010000000E+04, 1.1391026894E+02, 1.4392880742E+01, 6.3942634380E+01, 1.0650007001E+01, 9.7824474046E-01],
	[4.5015000000E+04, 1.1393264552E+02, 1.4392999036E+01, 6.3965896960E+01, 1.0650912495E+01, 9.7825379497E-01],
	[4.5020000000E+04, 1.1395502401E+02, 1.4393117317E+01, 6.3989165415E+01, 1.0651817769E+01, 9.7826284519E-01],
	[4.5025000000E+04, 1.1397740440E+02, 1.4393235587E+01, 6.4012439746E+01, 1.0652722822E+01, 9.7827189112E-01],
	[4.5030000000E+04, 1.1399978671E+02, 1.4393353844E+01, 6.4035719954E+01, 1.0653627656E+01, 9.7828093276E-01],
	[4.5035000000E+04, 1.1402217093E+02, 1.4393472090E+01, 6.4059006040E+01, 1.0654532269E+01, 9.7828997013E-01],
	[4.5040000000E+04, 1.1404455705E+02, 1.4393590323E+01, 6.4082298004E+01, 1.0655436662E+01, 9.7829900321E-01],
	[4.5045000000E+04, 1.1406694508E+02, 1.4393708544E+01, 6.4105595847E+01, 1.0656340835E+01, 9.7830803201E-01],
	[4.5050000000E+04, 1.1408933503E+02, 1.4393826752E+01, 6.4128899570E+01, 1.0657244788E+01, 9.7831705654E-01],
	[4.5055000000E+04, 1.1411172688E+02, 1.4393944949E+01, 6.4152209174E+01, 1.0658148522E+01, 9.7832607680E-01],
	[4.5060000000E+04, 1.1413412064E+02, 1.4394063134E+01, 6.4175524660E+01, 1.0659052035E+01, 9.7833509278E-01],
	[4.5065000000E+04, 1.1415651631E+02, 1.4394181306E+01, 6.4198846028E+01, 1.0659955329E+01, 9.7834410450E-01],
	[4.5070000000E+04, 1.1417891390E+02, 1.4394299466E+01, 6.4222173280E+01, 1.0660858403E+01, 9.7835311195E-01],
	[4.5075000000E+04, 1.1420131338E+02, 1.4394417614E+01, 6.4245506416E+01, 1.0661761257E+01, 9.7836211513E-01],
	[4.5080000000E+04, 1.1422371478E+02, 1.4394535750E+01, 6.4268845437E+01, 1.0662663892E+01, 9.7837111405E-01],
	[4.5085000000E+04, 1.1424611809E+02, 1.4394653874E+01, 6.4292190344E+01, 1.0663566307E+01, 9.7838010872E-01],
	[4.5090000000E+04, 1.1426852331E+02, 1.4394771986E+01, 6.4315541138E+01, 1.0664468503E+01, 9.7838909912E-01],
	[4.5095000000E+04, 1.1429093043E+02, 1.4394890085E+01, 6.4338897819E+01, 1.0665370479E+01, 9.7839808528E-01],
	[4.5100000000E+04, 1.1431333947E+02, 1.4395008173E+01, 6.4362260388E+01, 1.0666272235E+01, 9.7840706718E-01],
	[4.5105000000E+04, 1.1433575041E+02, 1.4395126248E+01, 6.4385628847E+01, 1.0667173773E+01, 9.7841604482E-01],
	[4.5110000000E+04, 1.1435816326E+02, 1.4395244311E+01, 6.4409003196E+01, 1.0668075091E+01, 9.7842501823E-01],
	[4.5115000000E+04, 1.1438057802E+02, 1.4395362362E+01, 6.4432383436E+01, 1.0668976190E+01, 9.7843398738E-01],
	[4.5120000000E+04, 1.1440299469E+02, 1.4395480401E+01, 6.4455769567E+01, 1.0669877070E+01, 9.7844295229E-01],
	[4.5125000000E+04, 1.1442541327E+02, 1.4395598428E+01, 6.4479161591E+01, 1.0670777730E+01, 9.7845191296E-01],
	[4.5130000000E+04, 1.1444783375E+02, 1.4395716443E+01, 6.4502559508E+01, 1.0671678172E+01, 9.7846086940E-01],
	[4.5135000000E+04, 1.1447025615E+02, 1.4395834446E+01, 6.4525963320E+01, 1.0672578394E+01, 9.7846982159E-01],
	[4.5140000000E+04, 1.1449268045E+02, 1.4395952436E+01, 6.4549373026E+01, 1.0673478398E+01, 9.7847876956E-01],
	[4.5145000000E+04, 1.1451510666E+02, 1.4396070415E+01, 6.4572788628E+01, 1.0674378183E+01, 9.7848771329E-01],
	[4.5150000000E+04, 1.1453753478E+02, 1.4396188381E+01, 6.4596210127E+01, 1.0675277749E+01, 9.7849665279E-01],
	[4.5155000000E+04, 1.1455996481E+02, 1.4396306335E+01, 6.4619637524E+01, 1.0676177096E+01, 9.7850558806E-01],
	[4.5160000000E+04, 1.1458239675E+02, 1.4396424277E+01, 6.4643070819E+01, 1.0677076224E+01, 9.7851451911E-01],
	[4.5165000000E+04, 1.1460483059E+02, 1.4396542207E+01, 6.4666510013E+01, 1.0677975133E+01, 9.7852344594E-01],
	[4.5170000000E+04, 1.1462726634E+02, 1.4396660125E+01, 6.4689955107E+01, 1.0678873824E+01, 9.7853236854E-01],
	[4.5175000000E+04, 1.1464970400E+02, 1.4396778031E+01, 6.4713406101E+01, 1.0679772297E+01, 9.7854128692E-01],
	[4.5180000000E+04, 1.1467214357E+02, 1.4396895925E+01, 6.4736862998E+01, 1.0680670551E+01, 9.7855020109E-01],
	[4.5185000000E+04, 1.1469458505E+02, 1.4397013807E+01, 6.4760325797E+01, 1.0681568586E+01, 9.7855911104E-01],
	[4.5190000000E+04, 1.1471702843E+02, 1.4397131676E+01, 6.4783794499E+01, 1.0682466403E+01, 9.7856801678E-01],
	[4.5195000000E+04, 1.1473947373E+02, 1.4397249534E+01, 6.4807269106E+01, 1.0683364002E+01, 9.7857691830E-01],
	[4.5200000000E+04, 1.1476192093E+02, 1.4397367379E+01, 6.4830749617E+01, 1.0684261382E+01, 9.7858581562E-01],
	[4.5205000000E+04, 1.1478437004E+02, 1.4397485213E+01, 6.4854236034E+01, 1.0685158544E+01, 9.7859470873E-01],
	[4.5210000000E+04, 1.1480682105E+02, 1.4397603034E+01, 6.4877728358E+01, 1.0686055488E+01, 9.7860359763E-01],
	[4.5215000000E+04, 1.1482927398E+02, 1.4397720843E+01, 6.4901226590E+01, 1.0686952214E+01, 9.7861248233E-01],
	[4.5220000000E+04, 1.1485172881E+02, 1.4397838641E+01, 6.4924730729E+01, 1.0687848722E+01, 9.7862136283E-01],
	[4.5225000000E+04, 1.1487418555E+02, 1.4397956426E+01, 6.4948240778E+01, 1.0688745011E+01, 9.7863023913E-01],
	[4.5230000000E+04, 1.1489664419E+02, 1.4398074199E+01, 6.4971756737E+01, 1.0689641083E+01, 9.7863911123E-01],
	[4.5235000000E+04, 1.1491910475E+02, 1.4398191960E+01, 6.4995278607E+01, 1.0690536937E+01, 9.7864797914E-01],
	[4.5240000000E+04, 1.1494156721E+02, 1.4398309709E+01, 6.5018806388E+01, 1.0691432573E+01, 9.7865684285E-01],
	[4.5245000000E+04, 1.1496403158E+02, 1.4398427446E+01, 6.5042340081E+01, 1.0692327991E+01, 9.7866570238E-01],
	[4.5250000000E+04, 1.1498649785E+02, 1.4398545171E+01, 6.5065879688E+01, 1.0693223191E+01, 9.7867455771E-01],
	[4.5255000000E+04, 1.1500896604E+02, 1.4398662884E+01, 6.5089425210E+01, 1.0694118174E+01, 9.7868340886E-01],
	[4.5260000000E+04, 1.1503143613E+02, 1.4398780584E+01, 6.5112976646E+01, 1.0695012939E+01, 9.7869225582E-01],
	[4.5265000000E+04, 1.1505390812E+02, 1.4398898273E+01, 6.5136533998E+01, 1.0695907486E+01, 9.7870109860E-01],
	[4.5270000000E+04, 1.1507638203E+02, 1.4399015950E+01, 6.5160097266E+01, 1.0696801816E+01, 9.7870993720E-01],
	[4.5275000000E+04, 1.1509885784E+02, 1.4399133615E+01, 6.5183666452E+01, 1.0697695929E+01, 9.7871877162E-01],
	[4.5280000000E+04, 1.1512133556E+02, 1.4399251267E+01, 6.5207241556E+01, 1.0698589824E+01, 9.7872760186E-01],
	[4.5285000000E+04, 1.1514381519E+02, 1.4399368908E+01, 6.5230822580E+01, 1.0699483501E+01, 9.7873642792E-01],
	[4.5290000000E+04, 1.1516629672E+02, 1.4399486536E+01, 6.5254409523E+01, 1.0700376962E+01, 9.7874524982E-01],
	[4.5295000000E+04, 1.1518878016E+02, 1.4399604153E+01, 6.5278002387E+01, 1.0701270205E+01, 9.7875406754E-01],
	[4.5300000000E+04, 1.1521126551E+02, 1.4399721758E+01, 6.5301601173E+01, 1.0702163230E+01, 9.7876288110E-01],
	[4.5305000000E+04, 1.1523378112E+02, 1.4399842585E+01, 6.5325205881E+01, 1.0703058071E+01, 9.7877169049E-01],
	[4.5310000000E+04, 1.1525631489E+02, 1.4399965251E+01, 6.5348816512E+01, 1.0703953858E+01, 9.7878049571E-01],
	[4.5315000000E+04, 1.1527885057E+02, 1.4400087905E+01, 6.5372433068E+01, 1.0704849428E+01, 9.7878929677E-01],
	[4.5320000000E+04, 1.1530138817E+02, 1.4400210547E+01, 6.5396055548E+01, 1.0705744781E+01, 9.7879809367E-01],
	[4.5325000000E+04, 1.1532392769E+02, 1.4400333175E+01, 6.5419683954E+01, 1.0706639919E+01, 9.7880688641E-01],
	[4.5330000000E+04, 1.1534646913E+02, 1.4400455792E+01, 6.5443318287E+01, 1.0707534839E+01, 9.7881567500E-01],
	[4.5335000000E+04, 1.1536901249E+02, 1.4400578396E+01, 6.5466958547E+01, 1.0708429544E+01, 9.7882445943E-01],
	[4.5340000000E+04, 1.1539155777E+02, 1.4400700987E+01, 6.5490604736E+01, 1.0709324032E+01, 9.7883323971E-01],
	[4.5345000000E+04, 1.1541410497E+02, 1.4400823566E+01, 6.5514256853E+01, 1.0710218304E+01, 9.7884201584E-01],
	[4.5350000000E+04, 1.1543665408E+02, 1.4400946132E+01, 6.5537914901E+01, 1.0711112360E+01, 9.7885078782E-01],
	[4.5355000000E+04, 1.1545920512E+02, 1.4401068686E+01, 6.5561578879E+01, 1.0712006200E+01, 9.7885955565E-01],
	[4.5360000000E+04, 1.1548175807E+02, 1.4401191228E+01, 6.5585248789E+01, 1.0712899824E+01, 9.7886831934E-01],
	[4.5365000000E+04, 1.1550431294E+02, 1.4401313757E+01, 6.5608924631E+01, 1.0713793231E+01, 9.7887707889E-01],
	[4.5370000000E+04, 1.1552686973E+02, 1.4401436273E+01, 6.5632606407E+01, 1.0714686423E+01, 9.7888583429E-01],
	[4.5375000000E+04, 1.1554942844E+02, 1.4401558777E+01, 6.5656294116E+01, 1.0715579399E+01, 9.7889458556E-01],
	[4.5380000000E+04, 1.1557198907E+02, 1.4401681269E+01, 6.5679987761E+01, 1.0716472160E+01, 9.7890333269E-01],
	[4.5385000000E+04, 1.1559455162E+02, 1.4401803748E+01, 6.5703687341E+01, 1.0717364704E+01, 9.7891207569E-01],
	[4.5390000000E+04, 1.1561711608E+02, 1.4401926215E+01, 6.5727392858E+01, 1.0718257033E+01, 9.7892081456E-01],
	[4.5395000000E+04, 1.1563968246E+02, 1.4402048669E+01, 6.5751104312E+01, 1.0719149146E+01, 9.7892954929E-01],
	[4.5400000000E+04, 1.1566225077E+02, 1.4402171111E+01, 6.5774821704E+01, 1.0720041043E+01, 9.7893827990E-01],
	[4.5405000000E+04, 1.1568482099E+02, 1.4402293541E+01, 6.5798545036E+01, 1.0720932725E+01, 9.7894700638E-01],
	[4.5410000000E+04, 1.1570739313E+02, 1.4402415958E+01, 6.5822274307E+01, 1.0721824191E+01, 9.7895572874E-01],
	[4.5415000000E+04, 1.1572996718E+02, 1.4402538362E+01, 6.5846009519E+01, 1.0722715442E+01, 9.7896444698E-01],
	[4.5420000000E+04, 1.1575254316E+02, 1.4402660754E+01, 6.5869750673E+01, 1.0723606478E+01, 9.7897316109E-01],
	[4.5425000000E+04, 1.1577512105E+02, 1.4402783134E+01, 6.5893497769E+01, 1.0724497298E+01, 9.7898187109E-01],
	[4.5430000000E+04, 1.1579770086E+02, 1.4402905501E+01, 6.5917250809E+01, 1.0725387903E+01, 9.7899057697E-01],
	[4.5435000000E+04, 1.1582028259E+02, 1.4403027856E+01, 6.5941009792E+01, 1.0726278293E+01, 9.7899927874E-01],
	[4.5440000000E+04, 1.1584286624E+02, 1.4403150198E+01, 6.5964774720E+01, 1.0727168467E+01, 9.7900797640E-01],
	[4.5445000000E+04, 1.1586545180E+02, 1.4403272528E+01, 6.5988545594E+01, 1.0728058427E+01, 9.7901666994E-01],
	[4.5450000000E+04, 1.1588803929E+02, 1.4403394846E+01, 6.6012322415E+01, 1.0728948171E+01, 9.7902535938E-01],
	[4.5455000000E+04, 1.1591062869E+02, 1.4403517151E+01, 6.6036105183E+01, 1.0729837701E+01, 9.7903404472E-01],
	[4.5460000000E+04, 1.1593322001E+02, 1.4403639444E+01, 6.6059893899E+01, 1.0730727015E+01, 9.7904272595E-01],
	[4.5465000000E+04, 1.1595581324E+02, 1.4403761724E+01, 6.6083688565E+01, 1.0731616115E+01, 9.7905140307E-01],
	[4.5470000000E+04, 1.1597840840E+02, 1.4403883992E+01, 6.6107489180E+01, 1.0732504999E+01, 9.7906007610E-01],
	[4.5475000000E+04, 1.1600100547E+02, 1.4404006247E+01, 6.6131295746E+01, 1.0733393669E+01, 9.7906874503E-01],
	[4.5480000000E+04, 1.1602360446E+02, 1.4404128490E+01, 6.6155108263E+01, 1.0734282124E+01, 9.7907740987E-01],
	[4.5485000000E+04, 1.1604620537E+02, 1.4404250721E+01, 6.6178926733E+01, 1.0735170365E+01, 9.7908607061E-01],
	[4.5490000000E+04, 1.1606880819E+02, 1.4404372939E+01, 6.6202751156E+01, 1.0736058391E+01, 9.7909472726E-01],
	[4.5495000000E+04, 1.1609141293E+02, 1.4404495145E+01, 6.6226581533E+01, 1.0736946202E+01, 9.7910337982E-01],
	[4.5500000000E+04, 1.1611401959E+02, 1.4404617339E+01, 6.6250417865E+01, 1.0737833799E+01, 9.7911202829E-01],
	[4.5505000000E+04, 1.1613662817E+02, 1.4404739520E+01, 6.6274260153E+01, 1.0738721181E+01, 9.7912067268E-01],
	[4.5510000000E+04, 1.1615923867E+02, 1.4404861688E+01, 6.6298108397E+01, 1.0739608349E+01, 9.7912931298E-01],
	[4.5515000000E+04, 1.1618185108E+02, 1.4404983845E+01, 6.6321962599E+01, 1.0740495302E+01, 9.7913794920E-01],
	[4.5520000000E+04, 1.1620446541E+02, 1.4405105989E+01, 6.6345822758E+01, 1.0741382042E+01, 9.7914658135E-01],
	[4.5525000000E+04, 1.1622708165E+02, 1.4405228120E+01, 6.6369688877E+01, 1.0742268567E+01, 9.7915520941E-01],
	[4.5530000000E+04, 1.1624969982E+02, 1.4405350239E+01, 6.6393560956E+01, 1.0743154877E+01, 9.7916383340E-01],
	[4.5535000000E+04, 1.1627231990E+02, 1.4405472346E+01, 6.6417438996E+01, 1.0744040974E+01, 9.7917245332E-01],
	[4.5540000000E+04, 1.1629494190E+02, 1.4405594441E+01, 6.6441322997E+01, 1.0744926857E+01, 9.7918106916E-01],
	[4.5545000000E+04, 1.1631756581E+02, 1.4405716523E+01, 6.6465212960E+01, 1.0745812525E+01, 9.7918968094E-01],
	[4.5550000000E+04, 1.1634019164E+02, 1.4405838592E+01, 6.6489108887E+01, 1.0746697980E+01, 9.7919828864E-01],
	[4.5555000000E+04, 1.1636281939E+02, 1.4405960650E+01, 6.6513010777E+01, 1.0747583220E+01, 9.7920689229E-01],
	[4.5560000000E+04, 1.1638544906E+02, 1.4406082695E+01, 6.6536918633E+01, 1.0748468247E+01, 9.7921549187E-01],
	[4.5565000000E+04, 1.1640808064E+02, 1.4406204727E+01, 6.6560832454E+01, 1.0749353060E+01, 9.7922408739E-01],
	[4.5570000000E+04, 1.1643071414E+02, 1.4406326748E+01, 6.6584752242E+01, 1.0750237659E+01, 9.7923267884E-01],
	[4.5575000000E+04, 1.1645334955E+02, 1.4406448756E+01, 6.6608677997E+01, 1.0751122045E+01, 9.7924126625E-01],
	[4.5580000000E+04, 1.1647598688E+02, 1.4406570751E+01, 6.6632609720E+01, 1.0752006216E+01, 9.7924984959E-01],
	[4.5585000000E+04, 1.1649862613E+02, 1.4406692734E+01, 6.6656547412E+01, 1.0752890175E+01, 9.7925842889E-01],
	[4.5590000000E+04, 1.1652126730E+02, 1.4406814705E+01, 6.6680491075E+01, 1.0753773919E+01, 9.7926700413E-01],
	[4.5595000000E+04, 1.1654391038E+02, 1.4406936664E+01, 6.6704440708E+01, 1.0754657450E+01, 9.7927557532E-01],
	[4.5600000000E+04, 1.1656655538E+02, 1.4407058610E+01, 6.6728396312E+01, 1.0755540768E+01, 9.7928414247E-01],
	[4.5605000000E+04, 1.1658920229E+02, 1.4407180544E+01, 6.6752357889E+01, 1.0756423872E+01, 9.7929270557E-01],
	[4.5610000000E+04, 1.1661185113E+02, 1.4407302465E+01, 6.6776325439E+01, 1.0757306763E+01, 9.7930126463E-01],
	[4.5615000000E+04, 1.1663450187E+02, 1.4407424374E+01, 6.6800298963E+01, 1.0758189441E+01, 9.7930981964E-01],
	[4.5620000000E+04, 1.1665715454E+02, 1.4407546271E+01, 6.6824278462E+01, 1.0759071906E+01, 9.7931837062E-01],
	[4.5625000000E+04, 1.1667980912E+02, 1.4407668156E+01, 6.6848263936E+01, 1.0759954157E+01, 9.7932691756E-01],
	[4.5630000000E+04, 1.1670246561E+02, 1.4407790028E+01, 6.6872255388E+01, 1.0760836195E+01, 9.7933546046E-01],
	[4.5635000000E+04, 1.1672512403E+02, 1.4407911888E+01, 6.6896252816E+01, 1.0761718020E+01, 9.7934399934E-01],
	[4.5640000000E+04, 1.1674778436E+02, 1.4408033735E+01, 6.6920256223E+01, 1.0762599633E+01, 9.7935253418E-01],
	[4.5645000000E+04, 1.1677044660E+02, 1.4408155570E+01, 6.6944265609E+01, 1.0763481032E+01, 9.7936106499E-01],
	[4.5650000000E+04, 1.1679311076E+02, 1.4408277393E+01, 6.6968280974E+01, 1.0764362218E+01, 9.7936959177E-01],
	[4.5655000000E+04, 1.1681577684E+02, 1.4408399204E+01, 6.6992302320E+01, 1.0765243192E+01, 9.7937811453E-01],
	[4.5660000000E+04, 1.1683844483E+02, 1.4408521002E+01, 6.7016329648E+01, 1.0766123952E+01, 9.7938663327E-01],
	[4.5665000000E+04, 1.1686111474E+02, 1.4408642788E+01, 6.7040362958E+01, 1.0767004500E+01, 9.7939514799E-01],
	[4.5670000000E+04, 1.1688378656E+02, 1.4408764562E+01, 6.7064402252E+01, 1.0767884836E+01, 9.7940365868E-01],
	[4.5675000000E+04, 1.1690646030E+02, 1.4408886323E+01, 6.7088447529E+01, 1.0768764958E+01, 9.7941216536E-01],
	[4.5680000000E+04, 1.1692913596E+02, 1.4409008072E+01, 6.7112498792E+01, 1.0769644868E+01, 9.7942066803E-01],
	[4.5685000000E+04, 1.1695181353E+02, 1.4409129809E+01, 6.7136556040E+01, 1.0770524566E+01, 9.7942916668E-01],
	[4.5690000000E+04, 1.1697449302E+02, 1.4409251534E+01, 6.7160619274E+01, 1.0771404051E+01, 9.7943766132E-01],
	[4.5695000000E+04, 1.1699717442E+02, 1.4409373246E+01, 6.7184688496E+01, 1.0772283324E+01, 9.7944615195E-01],
	[4.5700000000E+04, 1.1701985774E+02, 1.4409494946E+01, 6.7208763706E+01, 1.0773162384E+01, 9.7945463858E-01],
	[4.5705000000E+04, 1.1704254297E+02, 1.4409616633E+01, 6.7232844905E+01, 1.0774041232E+01, 9.7946312120E-01],
	[4.5710000000E+04, 1.1706523012E+02, 1.4409738309E+01, 6.7256932094E+01, 1.0774919868E+01, 9.7947159981E-01],
	[4.5715000000E+04, 1.1708791918E+02, 1.4409859972E+01, 6.7281025274E+01, 1.0775798291E+01, 9.7948007443E-01],
	[4.5720000000E+04, 1.1711061016E+02, 1.4409981622E+01, 6.7305124445E+01, 1.0776676503E+01, 9.7948854505E-01],
	[4.5725000000E+04, 1.1713330306E+02, 1.4410103261E+01, 6.7329229608E+01, 1.0777554502E+01, 9.7949701167E-01],
	[4.5730000000E+04, 1.1715599787E+02, 1.4410224887E+01, 6.7353340765E+01, 1.0778432289E+01, 9.7950547429E-01],
	[4.5735000000E+04, 1.1717869459E+02, 1.4410346501E+01, 6.7377457916E+01, 1.0779309865E+01, 9.7951393292E-01],
	[4.5740000000E+04, 1.1720139324E+02, 1.4410468103E+01, 6.7401581061E+01, 1.0780187228E+01, 9.7952238757E-01],
	[4.5745000000E+04, 1.1722409379E+02, 1.4410589692E+01, 6.7425710203E+01, 1.0781064379E+01, 9.7953083822E-01],
	[4.5750000000E+04, 1.1724679626E+02, 1.4410711269E+01, 6.7449845341E+01, 1.0781941319E+01, 9.7953928488E-01],
	[4.5755000000E+04, 1.1726950065E+02, 1.4410832834E+01, 6.7473986476E+01, 1.0782818047E+01, 9.7954772756E-01],
	[4.5760000000E+04, 1.1729220695E+02, 1.4410954387E+01, 6.7498133609E+01, 1.0783694563E+01, 9.7955616626E-01],
	[4.5765000000E+04, 1.1731491516E+02, 1.4411075927E+01, 6.7522286742E+01, 1.0784570868E+01, 9.7956460098E-01],
	[4.5770000000E+04, 1.1733762529E+02, 1.4411197455E+01, 6.7546445874E+01, 1.0785446961E+01, 9.7957303172E-01],
	[4.5775000000E+04, 1.1736033734E+02, 1.4411318971E+01, 6.7570611007E+01, 1.0786322842E+01, 9.7958145848E-01],
	[4.5780000000E+04, 1.1738305130E+02, 1.4411440475E+01, 6.7594782142E+01, 1.0787198512E+01, 9.7958988126E-01],
	[4.5785000000E+04, 1.1740576717E+02, 1.4411561966E+01, 6.7618959279E+01, 1.0788073970E+01, 9.7959830008E-01],
	[4.5790000000E+04, 1.1742848496E+02, 1.4411683445E+01, 6.7643142419E+01, 1.0788949218E+01, 9.7960671492E-01],
	[4.5795000000E+04, 1.1745120467E+02, 1.4411804912E+01, 6.7667331563E+01, 1.0789824253E+01, 9.7961512579E-01],
	[4.5800000000E+04, 1.1747392628E+02, 1.4411926367E+01, 6.7691526712E+01, 1.0790699078E+01, 9.7962353270E-01],
	[4.5805000000E+04, 1.1749664982E+02, 1.4412047809E+01, 6.7715727867E+01, 1.0791573691E+01, 9.7963193564E-01],
	[4.5810000000E+04, 1.1751937527E+02, 1.4412169239E+01, 6.7739935028E+01, 1.0792448093E+01, 9.7964033462E-01],
	[4.5815000000E+04, 1.1754210263E+02, 1.4412290657E+01, 6.7764148196E+01, 1.0793322284E+01, 9.7964872964E-01],
	[4.5820000000E+04, 1.1756483190E+02, 1.4412412063E+01, 6.7788367373E+01, 1.0794196264E+01, 9.7965712070E-01],
	[4.5825000000E+04, 1.1758756309E+02, 1.4412533456E+01, 6.7812592559E+01, 1.0795070033E+01, 9.7966550780E-01],
	[4.5830000000E+04, 1.1761029620E+02, 1.4412654838E+01, 6.7836823755E+01, 1.0795943591E+01, 9.7967389094E-01],
	[4.5835000000E+04, 1.1763303122E+02, 1.4412776207E+01, 6.7861060961E+01, 1.0796816938E+01, 9.7968227014E-01],
	[4.5840000000E+04, 1.1765576815E+02, 1.4412897564E+01, 6.7885304179E+01, 1.0797690074E+01, 9.7969064538E-01],
	[4.5845000000E+04, 1.1767850700E+02, 1.4413018908E+01, 6.7909553409E+01, 1.0798562999E+01, 9.7969901667E-01],
	[4.5850000000E+04, 1.1770124776E+02, 1.4413140241E+01, 6.7933808653E+01, 1.0799435714E+01, 9.7970738402E-01],
	[4.5855000000E+04, 1.1772399044E+02, 1.4413261561E+01, 6.7958069911E+01, 1.0800308218E+01, 9.7971574742E-01],
	[4.5860000000E+04, 1.1774673503E+02, 1.4413382869E+01, 6.7982337183E+01, 1.0801180511E+01, 9.7972410688E-01],
	[4.5865000000E+04, 1.1776948153E+02, 1.4413504165E+01, 6.8006610471E+01, 1.0802052594E+01, 9.7973246240E-01],
	[4.5870000000E+04, 1.1779222995E+02, 1.4413625448E+01, 6.8030889776E+01, 1.0802924466E+01, 9.7974081398E-01],
	[4.5875000000E+04, 1.1781498028E+02, 1.4413746720E+01, 6.8055175098E+01, 1.0803796127E+01, 9.7974916162E-01],
	[4.5880000000E+04, 1.1783773252E+02, 1.4413867979E+01, 6.8079466438E+01, 1.0804667579E+01, 9.7975750533E-01],
	[4.5885000000E+04, 1.1786048668E+02, 1.4413989226E+01, 6.8103763798E+01, 1.0805538820E+01, 9.7976584510E-01],
	[4.5890000000E+04, 1.1788324275E+02, 1.4414110461E+01, 6.8128067177E+01, 1.0806409850E+01, 9.7977418094E-01],
	[4.5895000000E+04, 1.1790600074E+02, 1.4414231683E+01, 6.8152376577E+01, 1.0807280671E+01, 9.7978251286E-01],
	[4.5900000000E+04, 1.1792876064E+02, 1.4414352894E+01, 6.8176691998E+01, 1.0808151281E+01, 9.7979084085E-01],
	[4.5905000000E+04, 1.1795152245E+02, 1.4414474092E+01, 6.8201013442E+01, 1.0809021681E+01, 9.7979916491E-01],
	[4.5910000000E+04, 1.1797428618E+02, 1.4414595278E+01, 6.8225340909E+01, 1.0809891871E+01, 9.7980748505E-01],
	[4.5915000000E+04, 1.1799705182E+02, 1.4414716452E+01, 6.8249674400E+01, 1.0810761850E+01, 9.7981580126E-01],
	[4.5920000000E+04, 1.1801981937E+02, 1.4414837614E+01, 6.8274013916E+01, 1.0811631620E+01, 9.7982411356E-01],
	[4.5925000000E+04, 1.1804258884E+02, 1.4414958763E+01, 6.8298359458E+01, 1.0812501180E+01, 9.7983242194E-01],
	[4.5930000000E+04, 1.1806536022E+02, 1.4415079900E+01, 6.8322711026E+01, 1.0813370530E+01, 9.7984072641E-01],
	[4.5935000000E+04, 1.1808813352E+02, 1.4415201026E+01, 6.8347068622E+01, 1.0814239670E+01, 9.7984902696E-01],
	[4.5940000000E+04, 1.1811090872E+02, 1.4415322139E+01, 6.8371432246E+01, 1.0815108601E+01, 9.7985732360E-01],
	[4.5945000000E+04, 1.1813368584E+02, 1.4415443240E+01, 6.8395801899E+01, 1.0815977321E+01, 9.7986561633E-01],
	[4.5950000000E+04, 1.1815646488E+02, 1.4415564328E+01, 6.8420177582E+01, 1.0816845832E+01, 9.7987390516E-01],
	[4.5955000000E+04, 1.1817924582E+02, 1.4415685405E+01, 6.8444559295E+01, 1.0817714134E+01, 9.7988219008E-01],
	[4.5960000000E+04, 1.1820202868E+02, 1.4415806469E+01, 6.8468947041E+01, 1.0818582226E+01, 9.7989047110E-01],
	[4.5965000000E+04, 1.1822481345E+02, 1.4415927521E+01, 6.8493340818E+01, 1.0819450108E+01, 9.7989874821E-01],
	[4.5970000000E+04, 1.1824760014E+02, 1.4416048562E+01, 6.8517740629E+01, 1.0820317781E+01, 9.7990702143E-01],
	[4.5975000000E+04, 1.1827038874E+02, 1.4416169590E+01, 6.8542146474E+01, 1.0821185244E+01, 9.7991529075E-01],
	[4.5980000000E+04, 1.1829317925E+02, 1.4416290605E+01, 6.8566558354E+01, 1.0822052499E+01, 9.7992355617E-01],
	[4.5985000000E+04, 1.1831597167E+02, 1.4416411609E+01, 6.8590976269E+01, 1.0822919543E+01, 9.7993181770E-01],
	[4.5990000000E+04, 1.1833876601E+02, 1.4416532600E+01, 6.8615400221E+01, 1.0823786379E+01, 9.7994007534E-01],
	[4.5995000000E+04, 1.1836156226E+02, 1.4416653580E+01, 6.8639830210E+01, 1.0824653005E+01, 9.7994832909E-01],
	[4.6000000000E+04, 1.1838436042E+02, 1.4416774547E+01, 6.8664266238E+01, 1.0825519423E+01, 9.7995657895E-01],
	[4.6005000000E+04, 1.1840716050E+02, 1.4416895502E+01, 6.8688708305E+01, 1.0826385631E+01, 9.7996482493E-01],
	[4.6010000000E+04, 1.1842996248E+02, 1.4417016445E+01, 6.8713156412E+01, 1.0827251630E+01, 9.7997306702E-01],
	[4.6015000000E+04, 1.1845276638E+02, 1.4417137376E+01, 6.8737610559E+01, 1.0828117420E+01, 9.7998130523E-01],
	[4.6020000000E+04, 1.1847557220E+02, 1.4417258295E+01, 6.8762070748E+01, 1.0828983002E+01, 9.7998953956E-01],
	[4.6025000000E+04, 1.1849837992E+02, 1.4417379201E+01, 6.8786536979E+01, 1.0829848374E+01, 9.7999777002E-01],
	[4.6030000000E+04, 1.1852118956E+02, 1.4417500096E+01, 6.8811009254E+01, 1.0830713538E+01, 9.8000599660E-01],
	[4.6035000000E+04, 1.1854403566E+02, 1.4417624842E+01, 6.8835487573E+01, 1.0831580962E+01, 9.8001421930E-01],
	[4.6040000000E+04, 1.1856689362E+02, 1.4417750688E+01, 6.8859971936E+01, 1.0832448888E+01, 9.8002243814E-01],
	[4.6045000000E+04, 1.1858975351E+02, 1.4417876522E+01, 6.8884462346E+01, 1.0833316607E+01, 9.8003065310E-01],
	[4.6050000000E+04, 1.1861261533E+02, 1.4418002342E+01, 6.8908958802E+01, 1.0834184117E+01, 9.8003886420E-01],
	[4.6055000000E+04, 1.1863547907E+02, 1.4418128151E+01, 6.8933461305E+01, 1.0835051420E+01, 9.8004707143E-01],
	[4.6060000000E+04, 1.1865834473E+02, 1.4418253946E+01, 6.8957969857E+01, 1.0835918514E+01, 9.8005527480E-01],
	[4.6065000000E+04, 1.1868121232E+02, 1.4418379730E+01, 6.8982484458E+01, 1.0836785400E+01, 9.8006347430E-01],
	[4.6070000000E+04, 1.1870408183E+02, 1.4418505500E+01, 6.9007005108E+01, 1.0837652078E+01, 9.8007166995E-01],
	[4.6075000000E+04, 1.1872695327E+02, 1.4418631258E+01, 6.9031531810E+01, 1.0838518549E+01, 9.8007986174E-01],
	[4.6080000000E+04, 1.1874982663E+02, 1.4418757004E+01, 6.9056064563E+01, 1.0839384812E+01, 9.8008804967E-01],
	[4.6085000000E+04, 1.1877270192E+02, 1.4418882737E+01, 6.9080603368E+01, 1.0840250867E+01, 9.8009623375E-01],
	[4.6090000000E+04, 1.1879557913E+02, 1.4419008457E+01, 6.9105148227E+01, 1.0841116714E+01, 9.8010441397E-01],
	[4.6095000000E+04, 1.1881845826E+02, 1.4419134165E+01, 6.9129699140E+01, 1.0841982354E+01, 9.8011259035E-01],
	[4.6100000000E+04, 1.1884133932E+02, 1.4419259860E+01, 6.9154256108E+01, 1.0842847786E+01, 9.8012076288E-01],
	[4.6105000000E+04, 1.1886422230E+02, 1.4419385543E+01, 6.9178819132E+01, 1.0843713010E+01, 9.8012893156E-01],
	[4.6110000000E+04, 1.1888710721E+02, 1.4419511213E+01, 6.9203388212E+01, 1.0844578027E+01, 9.8013709640E-01],
	[4.6115000000E+04, 1.1890999404E+02, 1.4419636871E+01, 6.9227963349E+01, 1.0845442837E+01, 9.8014525739E-01],
	[4.6120000000E+04, 1.1893288279E+02, 1.4419762516E+01, 6.9252544545E+01, 1.0846307439E+01, 9.8015341455E-01],
	[4.6125000000E+04, 1.1895577347E+02, 1.4419888149E+01, 6.9277131800E+01, 1.0847171834E+01, 9.8016156787E-01],
	[4.6130000000E+04, 1.1897866607E+02, 1.4420013769E+01, 6.9301725115E+01, 1.0848036022E+01, 9.8016971735E-01],
	[4.6135000000E+04, 1.1900156059E+02, 1.4420139376E+01, 6.9326324491E+01, 1.0848900002E+01, 9.8017786300E-01],
	[4.6140000000E+04, 1.1902445704E+02, 1.4420264971E+01, 6.9350929929E+01, 1.0849763776E+01, 9.8018600481E-01],
	[4.6145000000E+04, 1.1904735541E+02, 1.4420390554E+01, 6.9375541428E+01, 1.0850627342E+01, 9.8019414280E-01],
	[4.6150000000E+04, 1.1907025571E+02, 1.4420516124E+01, 6.9400158992E+01, 1.0851490701E+01, 9.8020227695E-01],
	[4.6155000000E+04, 1.1909315793E+02, 1.4420641682E+01, 6.9424782619E+01, 1.0852353853E+01, 9.8021040728E-01],
	[4.6160000000E+04, 1.1911606207E+02, 1.4420767227E+01, 6.9449412311E+01, 1.0853216799E+01, 9.8021853379E-01],
	[4.6165000000E+04, 1.1913896813E+02, 1.4420892759E+01, 6.9474048069E+01, 1.0854079537E+01, 9.8022665647E-01],
	[4.6170000000E+04, 1.1916187612E+02, 1.4421018279E+01, 6.9498689894E+01, 1.0854942068E+01, 9.8023477534E-01],
	[4.6175000000E+04, 1.1918478604E+02, 1.4421143787E+01, 6.9523337786E+01, 1.0855804393E+01, 9.8024289038E-01],
	[4.6180000000E+04, 1.1920769787E+02, 1.4421269282E+01, 6.9547991747E+01, 1.0856666511E+01, 9.8025100161E-01],
	[4.6185000000E+04, 1.1923061163E+02, 1.4421394764E+01, 6.9572651776E+01, 1.0857528422E+01, 9.8025910902E-01],
	[4.6190000000E+04, 1.1925352731E+02, 1.4421520234E+01, 6.9597317876E+01, 1.0858390127E+01, 9.8026721262E-01],
	[4.6195000000E+04, 1.1927644492E+02, 1.4421645692E+01, 6.9621990046E+01, 1.0859251625E+01, 9.8027531241E-01],
	[4.6200000000E+04, 1.1929936445E+02, 1.4421771137E+01, 6.9646668288E+01, 1.0860112916E+01, 9.8028340840E-01],
	[4.6205000000E+04, 1.1932228590E+02, 1.4421896570E+01, 6.9671352603E+01, 1.0860974001E+01, 9.8029150057E-01],
	[4.6210000000E+04, 1.1934520927E+02, 1.4422021990E+01, 6.9696042991E+01, 1.0861834880E+01, 9.8029958894E-01],
	[4.6215000000E+04, 1.1936813457E+02, 1.4422147397E+01, 6.9720739453E+01, 1.0862695552E+01, 9.8030767351E-01],
	[4.6220000000E+04, 1.1939106179E+02, 1.4422272792E+01, 6.9745441990E+01, 1.0863556018E+01, 9.8031575427E-01],
	[4.6225000000E+04, 1.1941399093E+02, 1.4422398175E+01, 6.9770150602E+01, 1.0864416278E+01, 9.8032383124E-01],
	[4.6230000000E+04, 1.1943692200E+02, 1.4422523545E+01, 6.9794865292E+01, 1.0865276332E+01, 9.8033190441E-01],
	[4.6235000000E+04, 1.1945985499E+02, 1.4422648903E+01, 6.9819586059E+01, 1.0866136179E+01, 9.8033997379E-01],
	[4.6240000000E+04, 1.1948278990E+02, 1.4422774248E+01, 6.9844312904E+01, 1.0866995820E+01, 9.8034803937E-01],
	[4.6245000000E+04, 1.1950572673E+02, 1.4422899581E+01, 6.9869045829E+01, 1.0867855255E+01, 9.8035610116E-01],
	[4.6250000000E+04, 1.1952866549E+02, 1.4423024901E+01, 6.9893784833E+01, 1.0868714485E+01, 9.8036415916E-01],
	[4.6255000000E+04, 1.1955160617E+02, 1.4423150209E+01, 6.9918529919E+01, 1.0869573508E+01, 9.8037221337E-01],
	[4.6260000000E+04, 1.1957454877E+02, 1.4423275505E+01, 6.9943281086E+01, 1.0870432325E+01, 9.8038026380E-01],
	[4.6265000000E+04, 1.1959749329E+02, 1.4423400788E+01, 6.9968038335E+01, 1.0871290937E+01, 9.8038831045E-01],
	[4.6270000000E+04, 1.1962043974E+02, 1.4423526058E+01, 6.9992801668E+01, 1.0872149343E+01, 9.8039635331E-01],
	[4.6275000000E+04, 1.1964338811E+02, 1.4423651316E+01, 7.0017571086E+01, 1.0873007543E+01, 9.8040439240E-01],
	[4.6280000000E+04, 1.1966633840E+02, 1.4423776562E+01, 7.0042346588E+01, 1.0873865537E+01, 9.8041242771E-01],
	[4.6285000000E+04, 1.1968929062E+02, 1.4423901795E+01, 7.0067128176E+01, 1.0874723326E+01, 9.8042045924E-01],
	[4.6290000000E+04, 1.1971224475E+02, 1.4424027016E+01, 7.0091915850E+01, 1.0875580909E+01, 9.8042848700E-01],
	[4.6295000000E+04, 1.1973520081E+02, 1.4424152224E+01, 7.0116709613E+01, 1.0876438287E+01, 9.8043651098E-01],
	[4.6300000000E+04, 1.1975815879E+02, 1.4424277420E+01, 7.0141509463E+01, 1.0877295459E+01, 9.8044453120E-01],
	[4.6305000000E+04, 1.1978111869E+02, 1.4424402603E+01, 7.0166315403E+01, 1.0878152426E+01, 9.8045254765E-01],
	[4.6310000000E+04, 1.1980408052E+02, 1.4424527774E+01, 7.0191127433E+01, 1.0879009187E+01, 9.8046056033E-01],
	[4.6315000000E+04, 1.1982704426E+02, 1.4424652933E+01, 7.0215945554E+01, 1.0879865743E+01, 9.8046856925E-01],
	[4.6320000000E+04, 1.1985000993E+02, 1.4424778079E+01, 7.0240769766E+01, 1.0880722094E+01, 9.8047657441E-01],
	[4.6325000000E+04, 1.1987297752E+02, 1.4424903213E+01, 7.0265600071E+01, 1.0881578240E+01, 9.8048457581E-01],
	[4.6330000000E+04, 1.1989594704E+02, 1.4425028334E+01, 7.0290436470E+01, 1.0882434180E+01, 9.8049257345E-01],
	[4.6335000000E+04, 1.1991891847E+02, 1.4425153443E+01, 7.0315278962E+01, 1.0883289916E+01, 9.8050056733E-01],
	[4.6340000000E+04, 1.1994189183E+02, 1.4425278540E+01, 7.0340127550E+01, 1.0884145446E+01, 9.8050855746E-01],
	[4.6345000000E+04, 1.1996486710E+02, 1.4425403624E+01, 7.0364982233E+01, 1.0885000771E+01, 9.8051654383E-01],
	[4.6350000000E+04, 1.1998784430E+02, 1.4425528695E+01, 7.0389843014E+01, 1.0885855892E+01, 9.8052452646E-01],
	[4.6355000000E+04, 1.2001082342E+02, 1.4425653755E+01, 7.0414709892E+01, 1.0886710807E+01, 9.8053250534E-01],
	[4.6360000000E+04, 1.2003380447E+02, 1.4425778801E+01, 7.0439582868E+01, 1.0887565518E+01, 9.8054048047E-01],
	[4.6365000000E+04, 1.2005678743E+02, 1.4425903836E+01, 7.0464461943E+01, 1.0888420024E+01, 9.8054845186E-01],
	[4.6370000000E+04, 1.2007977232E+02, 1.4426028858E+01, 7.0489347119E+01, 1.0889274325E+01, 9.8055641950E-01],
	[4.6375000000E+04, 1.2010275912E+02, 1.4426153867E+01, 7.0514238396E+01, 1.0890128422E+01, 9.8056438341E-01],
	[4.6380000000E+04, 1.2012574785E+02, 1.4426278865E+01, 7.0539135774E+01, 1.0890982314E+01, 9.8057234357E-01],
	[4.6385000000E+04, 1.2014873850E+02, 1.4426403850E+01, 7.0564039255E+01, 1.0891836001E+01, 9.8058030000E-01],
	[4.6390000000E+04, 1.2017173107E+02, 1.4426528822E+01, 7.0588948839E+01, 1.0892689484E+01, 9.8058825270E-01],
	[4.6395000000E+04, 1.2019472557E+02, 1.4426653782E+01, 7.0613864528E+01, 1.0893542762E+01, 9.8059620166E-01],
	[4.6400000000E+04, 1.2021772198E+02, 1.4426778730E+01, 7.0638786321E+01, 1.0894395836E+01, 9.8060414689E-01],
	[4.6405000000E+04, 1.2024072032E+02, 1.4426903665E+01, 7.0663714221E+01, 1.0895248706E+01, 9.8061208839E-01],
	[4.6410000000E+04, 1.2026372057E+02, 1.4427028588E+01, 7.0688648227E+01, 1.0896101371E+01, 9.8062002616E-01],
	[4.6415000000E+04, 1.2028672275E+02, 1.4427153499E+01, 7.0713588341E+01, 1.0896953833E+01, 9.8062796021E-01],
	[4.6420000000E+04, 1.2030972685E+02, 1.4427278397E+01, 7.0738534564E+01, 1.0897806089E+01, 9.8063589054E-01],
	[4.6425000000E+04, 1.2033273287E+02, 1.4427403283E+01, 7.0763486896E+01, 1.0898658142E+01, 9.8064381714E-01],
	[4.6430000000E+04, 1.2035574081E+02, 1.4427528156E+01, 7.0788445337E+01, 1.0899509991E+01, 9.8065174003E-01],
	[4.6435000000E+04, 1.2037875067E+02, 1.4427653017E+01, 7.0813409890E+01, 1.0900361636E+01, 9.8065965919E-01],
	[4.6440000000E+04, 1.2040176245E+02, 1.4427777866E+01, 7.0838380555E+01, 1.0901213076E+01, 9.8066757465E-01],
	[4.6445000000E+04, 1.2042477615E+02, 1.4427902702E+01, 7.0863357332E+01, 1.0902064313E+01, 9.8067548638E-01],
	[4.6450000000E+04, 1.2044779178E+02, 1.4428027526E+01, 7.0888340223E+01, 1.0902915346E+01, 9.8068339441E-01],
	[4.6455000000E+04, 1.2047080932E+02, 1.4428152338E+01, 7.0913329228E+01, 1.0903766175E+01, 9.8069129873E-01],
	[4.6460000000E+04, 1.2049382878E+02, 1.4428277137E+01, 7.0938324348E+01, 1.0904616800E+01, 9.8069919934E-01],
	[4.6465000000E+04, 1.2051685017E+02, 1.4428401924E+01, 7.0963325584E+01, 1.0905467221E+01, 9.8070709624E-01],
	[4.6470000000E+04, 1.2053987348E+02, 1.4428526699E+01, 7.0988332937E+01, 1.0906317439E+01, 9.8071498944E-01],
	[4.6475000000E+04, 1.2056289870E+02, 1.4428651461E+01, 7.1013346408E+01, 1.0907167454E+01, 9.8072287894E-01],
	[4.6480000000E+04, 1.2058592585E+02, 1.4428776211E+01, 7.1038365997E+01, 1.0908017264E+01, 9.8073076474E-01],
	[4.6485000000E+04, 1.2060895492E+02, 1.4428900948E+01, 7.1063391705E+01, 1.0908866871E+01, 9.8073864684E-01],
	[4.6490000000E+04, 1.2063198590E+02, 1.4429025674E+01, 7.1088423534E+01, 1.0909716275E+01, 9.8074652524E-01],
	[4.6495000000E+04, 1.2065501881E+02, 1.4429150387E+01, 7.1113461483E+01, 1.0910565475E+01, 9.8075439995E-01],
	[4.6500000000E+04, 1.2067805364E+02, 1.4429275087E+01, 7.1138505555E+01, 1.0911414472E+01, 9.8076227096E-01],
	[4.6505000000E+04, 1.2070109039E+02, 1.4429399775E+01, 7.1163555749E+01, 1.0912263266E+01, 9.8077013829E-01],
	[4.6510000000E+04, 1.2072412906E+02, 1.4429524451E+01, 7.1188612067E+01, 1.0913111856E+01, 9.8077800193E-01],
	[4.6515000000E+04, 1.2074716965E+02, 1.4429649115E+01, 7.1213674509E+01, 1.0913960243E+01, 9.8078586188E-01],
	[4.6520000000E+04, 1.2077021216E+02, 1.4429773766E+01, 7.1238743076E+01, 1.0914808427E+01, 9.8079371814E-01],
	[4.6525000000E+04, 1.2079325659E+02, 1.4429898405E+01, 7.1263817769E+01, 1.0915656408E+01, 9.8080157073E-01],
	[4.6530000000E+04, 1.2081630294E+02, 1.4430023032E+01, 7.1288898589E+01, 1.0916504186E+01, 9.8080941963E-01],
	[4.6535000000E+04, 1.2083935121E+02, 1.4430147646E+01, 7.1313985537E+01, 1.0917351761E+01, 9.8081726485E-01],
	[4.6540000000E+04, 1.2086240139E+02, 1.4430272248E+01, 7.1339078613E+01, 1.0918199133E+01, 9.8082510640E-01],
	[4.6545000000E+04, 1.2088545350E+02, 1.4430396838E+01, 7.1364177819E+01, 1.0919046302E+01, 9.8083294427E-01],
	[4.6550000000E+04, 1.2090850753E+02, 1.4430521415E+01, 7.1389283155E+01, 1.0919893269E+01, 9.8084077847E-01],
	[4.6555000000E+04, 1.2093156348E+02, 1.4430645980E+01, 7.1414394622E+01, 1.0920740032E+01, 9.8084860900E-01],
	[4.6560000000E+04, 1.2095462135E+02, 1.4430770533E+01, 7.1439512220E+01, 1.0921586593E+01, 9.8085643585E-01],
	[4.6565000000E+04, 1.2097768114E+02, 1.4430895073E+01, 7.1464635952E+01, 1.0922432951E+01, 9.8086425904E-01],
	[4.6570000000E+04, 1.2100074285E+02, 1.4431019601E+01, 7.1489765817E+01, 1.0923279107E+01, 9.8087207857E-01],
	[4.6575000000E+04, 1.2102380647E+02, 1.4431144117E+01, 7.1514901817E+01, 1.0924125060E+01, 9.8087989443E-01],
	[4.6580000000E+04, 1.2104687202E+02, 1.4431268621E+01, 7.1540043951E+01, 1.0924970810E+01, 9.8088770663E-01],
	[4.6585000000E+04, 1.2106993949E+02, 1.4431393112E+01, 7.1565192222E+01, 1.0925816358E+01, 9.8089551516E-01],
	[4.6590000000E+04, 1.2109300887E+02, 1.4431517591E+01, 7.1590346630E+01, 1.0926661704E+01, 9.8090332005E-01],
	[4.6595000000E+04, 1.2111608018E+02, 1.4431642058E+01, 7.1615507175E+01, 1.0927506847E+01, 9.8091112127E-01],
	[4.6600000000E+04, 1.2113915340E+02, 1.4431766512E+01, 7.1640673859E+01, 1.0928351788E+01, 9.8091891884E-01],
	[4.6605000000E+04, 1.2116222855E+02, 1.4431890954E+01, 7.1665846683E+01, 1.0929196526E+01, 9.8092671276E-01],
	[4.6610000000E+04, 1.2118530561E+02, 1.4432015384E+01, 7.1691025647E+01, 1.0930041063E+01, 9.8093450303E-01],
	[4.6615000000E+04, 1.2120838459E+02, 1.4432139802E+01, 7.1716210752E+01, 1.0930885397E+01, 9.8094228965E-01],
	[4.6620000000E+04, 1.2123146549E+02, 1.4432264207E+01, 7.1741401999E+01, 1.0931729529E+01, 9.8095007262E-01],
	[4.6625000000E+04, 1.2125454832E+02, 1.4432388600E+01, 7.1766599388E+01, 1.0932573459E+01, 9.8095785195E-01],
	[4.6630000000E+04, 1.2127763306E+02, 1.4432512981E+01, 7.1791802921E+01, 1.0933417188E+01, 9.8096562764E-01],
	[4.6635000000E+04, 1.2130071971E+02, 1.4432637349E+01, 7.1817012599E+01, 1.0934260714E+01, 9.8097339968E-01],
	[4.6640000000E+04, 1.2132380829E+02, 1.4432761706E+01, 7.1842228422E+01, 1.0935104038E+01, 9.8098116809E-01],
	[4.6645000000E+04, 1.2134689879E+02, 1.4432886050E+01, 7.1867450391E+01, 1.0935947161E+01, 9.8098893286E-01],
	[4.6650000000E+04, 1.2136999121E+02, 1.4433010381E+01, 7.1892678507E+01, 1.0936790082E+01, 9.8099669399E-01],
	[4.6655000000E+04, 1.2139308554E+02, 1.4433134701E+01, 7.1917912771E+01, 1.0937632801E+01, 9.8100445149E-01],
	[4.6660000000E+04, 1.2141618179E+02, 1.4433259008E+01, 7.1943153184E+01, 1.0938475318E+01, 9.8101220536E-01],
	[4.6665000000E+04, 1.2143927997E+02, 1.4433383303E+01, 7.1968399746E+01, 1.0939317634E+01, 9.8101995560E-01],
	[4.6670000000E+04, 1.2146238006E+02, 1.4433507586E+01, 7.1993652458E+01, 1.0940159748E+01, 9.8102770222E-01],
	[4.6675000000E+04, 1.2148548207E+02, 1.4433631856E+01, 7.2018911321E+01, 1.0941001661E+01, 9.8103544520E-01],
	[4.6680000000E+04, 1.2150858600E+02, 1.4433756115E+01, 7.2044176337E+01, 1.0941843372E+01, 9.8104318457E-01],
	[4.6685000000E+04, 1.2153169184E+02, 1.4433880361E+01, 7.2069447505E+01, 1.0942684882E+01, 9.8105092031E-01],
	[4.6690000000E+04, 1.2155479961E+02, 1.4434004595E+01, 7.2094724827E+01, 1.0943526190E+01, 9.8105865243E-01],
	[4.6695000000E+04, 1.2157790929E+02, 1.4434128816E+01, 7.2120008304E+01, 1.0944367297E+01, 9.8106638094E-01],
	[4.6700000000E+04, 1.2160102089E+02, 1.4434253025E+01, 7.2145297935E+01, 1.0945208203E+01, 9.8107410583E-01],
	[4.6705000000E+04, 1.2162413441E+02, 1.4434377222E+01, 7.2170593723E+01, 1.0946048908E+01, 9.8108182710E-01],
	[4.6710000000E+04, 1.2164724985E+02, 1.4434501407E+01, 7.2195895668E+01, 1.0946889411E+01, 9.8108954476E-01],
	[4.6715000000E+04, 1.2167036721E+02, 1.4434625580E+01, 7.2221203771E+01, 1.0947729714E+01, 9.8109725881E-01],
	[4.6720000000E+04, 1.2169348649E+02, 1.4434749740E+01, 7.2246518033E+01, 1.0948569815E+01, 9.8110496926E-01],
	[4.6725000000E+04, 1.2171660768E+02, 1.4434873889E+01, 7.2271838454E+01, 1.0949409716E+01, 9.8111267609E-01],
	[4.6730000000E+04, 1.2173973079E+02, 1.4434998025E+01, 7.2297165036E+01, 1.0950249415E+01, 9.8112037932E-01],
	[4.6735000000E+04, 1.2176285582E+02, 1.4435122148E+01, 7.2322497778E+01, 1.0951088914E+01, 9.8112807895E-01],
	[4.6740000000E+04, 1.2178598277E+02, 1.4435246260E+01, 7.2347836683E+01, 1.0951928212E+01, 9.8113577498E-01],
	[4.6745000000E+04, 1.2180911164E+02, 1.4435370359E+01, 7.2373181751E+01, 1.0952767308E+01, 9.8114346741E-01],
	[4.6750000000E+04, 1.2183224242E+02, 1.4435494446E+01, 7.2398532982E+01, 1.0953606205E+01, 9.8115115624E-01],
	[4.6755000000E+04, 1.2185537512E+02, 1.4435618521E+01, 7.2423890378E+01, 1.0954444900E+01, 9.8115884148E-01],
	[4.6760000000E+04, 1.2187850974E+02, 1.4435742584E+01, 7.2449253940E+01, 1.0955283395E+01, 9.8116652312E-01],
	[4.6765000000E+04, 1.2190164628E+02, 1.4435866635E+01, 7.2474623667E+01, 1.0956121690E+01, 9.8117420117E-01],
	[4.6770000000E+04, 1.2192478474E+02, 1.4435990673E+01, 7.2499999562E+01, 1.0956959783E+01, 9.8118187563E-01],
	[4.6775000000E+04, 1.2194795037E+02, 1.4436117469E+01, 7.2525381625E+01, 1.0957799476E+01, 9.8118954651E-01],
	[4.6780000000E+04, 1.2197113706E+02, 1.4436246351E+01, 7.2550769856E+01, 1.0958640333E+01, 9.8119721379E-01],
	[4.6785000000E+04, 1.2199432569E+02, 1.4436375220E+01, 7.2576164257E+01, 1.0959480990E+01, 9.8120487750E-01],
	[4.6790000000E+04, 1.2201751624E+02, 1.4436504077E+01, 7.2601564829E+01, 1.0960321447E+01, 9.8121253762E-01],
	[4.6795000000E+04, 1.2204070873E+02, 1.4436632921E+01, 7.2626971571E+01, 1.0961161704E+01, 9.8122019416E-01],
	[4.6800000000E+04, 1.2206390314E+02, 1.4436761753E+01, 7.2652384486E+01, 1.0962001762E+01, 9.8122784713E-01],
	[4.6805000000E+04, 1.2208709948E+02, 1.4436890571E+01, 7.2677803574E+01, 1.0962841619E+01, 9.8123549651E-01],
	[4.6810000000E+04, 1.2211029776E+02, 1.4437019378E+01, 7.2703228836E+01, 1.0963681277E+01, 9.8124314233E-01],
	[4.6815000000E+04, 1.2213349796E+02, 1.4437148172E+01, 7.2728660272E+01, 1.0964520736E+01, 9.8125078457E-01],
	[4.6820000000E+04, 1.2215670009E+02, 1.4437276953E+01, 7.2754097884E+01, 1.0965359995E+01, 9.8125842324E-01],
	[4.6825000000E+04, 1.2217990415E+02, 1.4437405721E+01, 7.2779541672E+01, 1.0966199054E+01, 9.8126605834E-01],
	[4.6830000000E+04, 1.2220311015E+02, 1.4437534477E+01, 7.2804991637E+01, 1.0967037914E+01, 9.8127368987E-01],
	[4.6835000000E+04, 1.2222631807E+02, 1.4437663220E+01, 7.2830447780E+01, 1.0967876574E+01, 9.8128131784E-01],
	[4.6840000000E+04, 1.2224952792E+02, 1.4437791951E+01, 7.2855910102E+01, 1.0968715036E+01, 9.8128894224E-01],
	[4.6845000000E+04, 1.2227273969E+02, 1.4437920669E+01, 7.2881378604E+01, 1.0969553298E+01, 9.8129656308E-01],
	[4.6850000000E+04, 1.2229595340E+02, 1.4438049375E+01, 7.2906853286E+01, 1.0970391360E+01, 9.8130418037E-01],
	[4.6855000000E+04, 1.2231916904E+02, 1.4438178068E+01, 7.2932334149E+01, 1.0971229224E+01, 9.8131179409E-01],
	[4.6860000000E+04, 1.2234238661E+02, 1.4438306748E+01, 7.2957821195E+01, 1.0972066888E+01, 9.8131940426E-01],
	[4.6865000000E+04, 1.2236560610E+02, 1.4438435416E+01, 7.2983314424E+01, 1.0972904353E+01, 9.8132701088E-01],
	[4.6870000000E+04, 1.2238882753E+02, 1.4438564071E+01, 7.3008813836E+01, 1.0973741619E+01, 9.8133461395E-01],
	[4.6875000000E+04, 1.2241205088E+02, 1.4438692714E+01, 7.3034319434E+01, 1.0974578686E+01, 9.8134221346E-01],
	[4.6880000000E+04, 1.2243527616E+02, 1.4438821344E+01, 7.3059831216E+01, 1.0975415555E+01, 9.8134980943E-01],
	[4.6885000000E+04, 1.2245850337E+02, 1.4438949961E+01, 7.3085349186E+01, 1.0976252224E+01, 9.8135740184E-01],
	[4.6890000000E+04, 1.2248173251E+02, 1.4439078566E+01, 7.3110873342E+01, 1.0977088695E+01, 9.8136499072E-01],
	[4.6895000000E+04, 1.2250496358E+02, 1.4439207158E+01, 7.3136403686E+01, 1.0977924966E+01, 9.8137257605E-01],
	[4.6900000000E+04, 1.2252819658E+02, 1.4439335738E+01, 7.3161940220E+01, 1.0978761040E+01, 9.8138015784E-01],
	[4.6905000000E+04, 1.2255143150E+02, 1.4439464305E+01, 7.3187482943E+01, 1.0979596914E+01, 9.8138773610E-01],
	[4.6910000000E+04, 1.2257466836E+02, 1.4439592860E+01, 7.3213031857E+01, 1.0980432590E+01, 9.8139531081E-01],
	[4.6915000000E+04, 1.2259790714E+02, 1.4439721402E+01, 7.3238586962E+01, 1.0981268067E+01, 9.8140288199E-01],
	[4.6920000000E+04, 1.2262114785E+02, 1.4439849932E+01, 7.3264148259E+01, 1.0982103345E+01, 9.8141044964E-01],
	[4.6925000000E+04, 1.2264439049E+02, 1.4439978449E+01, 7.3289715749E+01, 1.0982938426E+01, 9.8141801375E-01],
	[4.6930000000E+04, 1.2266763506E+02, 1.4440106953E+01, 7.3315289434E+01, 1.0983773307E+01, 9.8142557434E-01],
	[4.6935000000E+04, 1.2269088156E+02, 1.4440235445E+01, 7.3340869313E+01, 1.0984607991E+01, 9.8143313140E-01],
	[4.6940000000E+04, 1.2271412999E+02, 1.4440363924E+01, 7.3366455388E+01, 1.0985442476E+01, 9.8144068493E-01],
	[4.6945000000E+04, 1.2273738034E+02, 1.4440492391E+01, 7.3392047659E+01, 1.0986276763E+01, 9.8144823494E-01],
	[4.6950000000E+04, 1.2276063262E+02, 1.4440620845E+01, 7.3417646127E+01, 1.0987110852E+01, 9.8145578142E-01],
	[4.6955000000E+04, 1.2278388683E+02, 1.4440749287E+01, 7.3443250794E+01, 1.0987944742E+01, 9.8146332439E-01],
	[4.6960000000E+04, 1.2280714297E+02, 1.4440877716E+01, 7.3468861659E+01, 1.0988778434E+01, 9.8147086384E-01],
	[4.6965000000E+04, 1.2283040104E+02, 1.4441006133E+01, 7.3494478725E+01, 1.0989611929E+01, 9.8147839977E-01],
	[4.6970000000E+04, 1.2285366103E+02, 1.4441134537E+01, 7.3520101991E+01, 1.0990445225E+01, 9.8148593218E-01],
	[4.6975000000E+04, 1.2287692296E+02, 1.4441262929E+01, 7.3545731458E+01, 1.0991278323E+01, 9.8149346108E-01],
	[4.6980000000E+04, 1.2290018681E+02, 1.4441391308E+01, 7.3571367128E+01, 1.0992111224E+01, 9.8150098648E-01],
	[4.6985000000E+04, 1.2292345259E+02, 1.4441519674E+01, 7.3597009001E+01, 1.0992943927E+01, 9.8150850836E-01],
	[4.6990000000E+04, 1.2294672029E+02, 1.4441648028E+01, 7.3622657078E+01, 1.0993776431E+01, 9.8151602673E-01],
	[4.6995000000E+04, 1.2296998993E+02, 1.4441776370E+01, 7.3648311360E+01, 1.0994608738E+01, 9.8152354160E-01],
	[4.7000000000E+04, 1.2299326149E+02, 1.4441904699E+01, 7.3673971847E+01, 1.0995440848E+01, 9.8153105297E-01],
	[4.7005000000E+04, 1.2301653498E+02, 1.4442033016E+01, 7.3699638541E+01, 1.0996272760E+01, 9.8153856084E-01],
	[4.7010000000E+04, 1.2303981040E+02, 1.4442161320E+01, 7.3725311443E+01, 1.0997104474E+01, 9.8154606520E-01],
	[4.7015000000E+04, 1.2306308774E+02, 1.4442289611E+01, 7.3750990552E+01, 1.0997935990E+01, 9.8155356607E-01],
	[4.7020000000E+04, 1.2308636702E+02, 1.4442417890E+01, 7.3776675871E+01, 1.0998767310E+01, 9.8156106344E-01],
	[4.7025000000E+04, 1.2310964822E+02, 1.4442546156E+01, 7.3802367400E+01, 1.0999598431E+01, 9.8156855731E-01],
	[4.7030000000E+04, 1.2313293135E+02, 1.4442674410E+01, 7.3828065139E+01, 1.1000429356E+01, 9.8157604770E-01],
	[4.7035000000E+04, 1.2315621640E+02, 1.4442802652E+01, 7.3853769090E+01, 1.1001260083E+01, 9.8158353459E-01],
	[4.7040000000E+04, 1.2317950339E+02, 1.4442930881E+01, 7.3879479253E+01, 1.1002090612E+01, 9.8159101799E-01],
	[4.7045000000E+04, 1.2320279230E+02, 1.4443059097E+01, 7.3905195629E+01, 1.1002920945E+01, 9.8159849791E-01],
	[4.7050000000E+04, 1.2322608313E+02, 1.4443187301E+01, 7.3930918220E+01, 1.1003751080E+01, 9.8160597434E-01],
	[4.7055000000E+04, 1.2324937590E+02, 1.4443315493E+01, 7.3956647025E+01, 1.1004581018E+01, 9.8161344729E-01],
	[4.7060000000E+04, 1.2327267059E+02, 1.4443443672E+01, 7.3982382046E+01, 1.1005410760E+01, 9.8162091676E-01],
	[4.7065000000E+04, 1.2329596721E+02, 1.4443571839E+01, 7.4008123284E+01, 1.1006240304E+01, 9.8162838275E-01],
	[4.7070000000E+04, 1.2331926576E+02, 1.4443699993E+01, 7.4033870739E+01, 1.1007069651E+01, 9.8163584526E-01],
	[4.7075000000E+04, 1.2334256623E+02, 1.4443828134E+01, 7.4059624413E+01, 1.1007898801E+01, 9.8164330429E-01],
	[4.7080000000E+04, 1.2336586864E+02, 1.4443956263E+01, 7.4085384306E+01, 1.1008727754E+01, 9.8165075985E-01],
	[4.7085000000E+04, 1.2338917296E+02, 1.4444084380E+01, 7.4111150418E+01, 1.1009556511E+01, 9.8165821194E-01],
	[4.7090000000E+04, 1.2341247922E+02, 1.4444212484E+01, 7.4136922752E+01, 1.1010385071E+01, 9.8166566056E-01],
	[4.7095000000E+04, 1.2343578740E+02, 1.4444340576E+01, 7.4162701307E+01, 1.1011213434E+01, 9.8167310571E-01],
	[4.7100000000E+04, 1.2345909751E+02, 1.4444468655E+01, 7.4188486084E+01, 1.1012041600E+01, 9.8168054739E-01],
	[4.7105000000E+04, 1.2348240955E+02, 1.4444596722E+01, 7.4214277085E+01, 1.1012869570E+01, 9.8168798561E-01],
	[4.7110000000E+04, 1.2350572351E+02, 1.4444724776E+01, 7.4240074310E+01, 1.1013697343E+01, 9.8169542036E-01],
	[4.7115000000E+04, 1.2352903940E+02, 1.4444852818E+01, 7.4265877760E+01, 1.1014524920E+01, 9.8170285166E-01],
	[4.7120000000E+04, 1.2355235722E+02, 1.4444980848E+01, 7.4291687436E+01, 1.1015352300E+01, 9.8171027949E-01],
	[4.7125000000E+04, 1.2357567696E+02, 1.4445108865E+01, 7.4317503339E+01, 1.1016179484E+01, 9.8171770387E-01],
	[4.7130000000E+04, 1.2359899863E+02, 1.4445236869E+01, 7.4343325469E+01, 1.1017006472E+01, 9.8172512479E-01],
	[4.7135000000E+04, 1.2362232223E+02, 1.4445364861E+01, 7.4369153827E+01, 1.1017833263E+01, 9.8173254226E-01],
	[4.7140000000E+04, 1.2364564775E+02, 1.4445492841E+01, 7.4394988415E+01, 1.1018659858E+01, 9.8173995628E-01],
	[4.7145000000E+04, 1.2366897520E+02, 1.4445620808E+01, 7.4420829232E+01, 1.1019486257E+01, 9.8174736684E-01],
	[4.7150000000E+04, 1.2369230458E+02, 1.4445748763E+01, 7.4446676281E+01, 1.1020312459E+01, 9.8175477396E-01],
	[4.7155000000E+04, 1.2371563588E+02, 1.4445876706E+01, 7.4472529561E+01, 1.1021138466E+01, 9.8176217763E-01],
	[4.7160000000E+04, 1.2373896911E+02, 1.4446004635E+01, 7.4498389074E+01, 1.1021964276E+01, 9.8176957786E-01],
	[4.7165000000E+04, 1.2376230426E+02, 1.4446132553E+01, 7.4524254820E+01, 1.1022789891E+01, 9.8177697464E-01],
	[4.7170000000E+04, 1.2378564134E+02, 1.4446260458E+01, 7.4550126801E+01, 1.1023615309E+01, 9.8178436798E-01],
	[4.7175000000E+04, 1.2380898035E+02, 1.4446388351E+01, 7.4576005016E+01, 1.1024440532E+01, 9.8179175788E-01],
	[4.7180000000E+04, 1.2383232129E+02, 1.4446516231E+01, 7.4601889468E+01, 1.1025265559E+01, 9.8179914435E-01],
	[4.7185000000E+04, 1.2385566415E+02, 1.4446644099E+01, 7.4627780156E+01, 1.1026090390E+01, 9.8180652738E-01],
	[4.7190000000E+04, 1.2387900893E+02, 1.4446771954E+01, 7.4653677082E+01, 1.1026915025E+01, 9.8181390698E-01],
	[4.7195000000E+04, 1.2390235564E+02, 1.4446899797E+01, 7.4679580246E+01, 1.1027739465E+01, 9.8182128314E-01],
	[4.7200000000E+04, 1.2392570428E+02, 1.4447027627E+01, 7.4705489650E+01, 1.1028563709E+01, 9.8182865588E-01],
	[4.7205000000E+04, 1.2394905485E+02, 1.4447155446E+01, 7.4731405294E+01, 1.1029387757E+01, 9.8183602519E-01],
	[4.7210000000E+04, 1.2397240734E+02, 1.4447283251E+01, 7.4757327178E+01, 1.1030211610E+01, 9.8184339107E-01],
	[4.7215000000E+04, 1.2399576175E+02, 1.4447411045E+01, 7.4783255305E+01, 1.1031035268E+01, 9.8185075352E-01],
	[4.7220000000E+04, 1.2401911810E+02, 1.4447538826E+01, 7.4809189674E+01, 1.1031858730E+01, 9.8185811256E-01],
	[4.7225000000E+04, 1.2404247636E+02, 1.4447666594E+01, 7.4835130287E+01, 1.1032681996E+01, 9.8186546817E-01],
	[4.7230000000E+04, 1.2406583656E+02, 1.4447794350E+01, 7.4861077144E+01, 1.1033505068E+01, 9.8187282036E-01],
	[4.7235000000E+04, 1.2408919868E+02, 1.4447922094E+01, 7.4887030246E+01, 1.1034327944E+01, 9.8188016914E-01],
	[4.7240000000E+04, 1.2411256272E+02, 1.4448049825E+01, 7.4912989594E+01, 1.1035150624E+01, 9.8188751450E-01],
	[4.7245000000E+04, 1.2413592869E+02, 1.4448177544E+01, 7.4938955189E+01, 1.1035973110E+01, 9.8189485645E-01],
	[4.7250000000E+04, 1.2415929659E+02, 1.4448305251E+01, 7.4964927032E+01, 1.1036795401E+01, 9.8190219498E-01],
	[4.7255000000E+04, 1.2418266641E+02, 1.4448432945E+01, 7.4990905123E+01, 1.1037617496E+01, 9.8190953011E-01],
	[4.7260000000E+04, 1.2420603815E+02, 1.4448560627E+01, 7.5016889463E+01, 1.1038439396E+01, 9.8191686182E-01],
	[4.7265000000E+04, 1.2422941183E+02, 1.4448688296E+01, 7.5042880054E+01, 1.1039261102E+01, 9.8192419013E-01],
	[4.7270000000E+04, 1.2425278742E+02, 1.4448815953E+01, 7.5068876896E+01, 1.1040082612E+01, 9.8193151504E-01],
	[4.7275000000E+04, 1.2427616495E+02, 1.4448943598E+01, 7.5094879990E+01, 1.1040903928E+01, 9.8193883655E-01],
	[4.7280000000E+04, 1.2429954440E+02, 1.4449071230E+01, 7.5120889337E+01, 1.1041725049E+01, 9.8194615465E-01],
	[4.7285000000E+04, 1.2432292577E+02, 1.4449198850E+01, 7.5146904937E+01, 1.1042545975E+01, 9.8195346935E-01],
	[4.7290000000E+04, 1.2434630907E+02, 1.4449326458E+01, 7.5172926791E+01, 1.1043366706E+01, 9.8196078066E-01],
	[4.7295000000E+04, 1.2436969429E+02, 1.4449454053E+01, 7.5198954901E+01, 1.1044187243E+01, 9.8196808857E-01],
	[4.7300000000E+04, 1.2439308144E+02, 1.4449581636E+01, 7.5224989267E+01, 1.1045007585E+01, 9.8197539309E-01],
	[4.7305000000E+04, 1.2441647052E+02, 1.4449709206E+01, 7.5251029890E+01, 1.1045827733E+01, 9.8198269421E-01],
	[4.7310000000E+04, 1.2443986151E+02, 1.4449836764E+01, 7.5277076770E+01, 1.1046647686E+01, 9.8198999195E-01],
	[4.7315000000E+04, 1.2446325444E+02, 1.4449964310E+01, 7.5303129910E+01, 1.1047467445E+01, 9.8199728630E-01],
	[4.7320000000E+04, 1.2448664929E+02, 1.4450091844E+01, 7.5329189308E+01, 1.1048287009E+01, 9.8200457726E-01],
	[4.7325000000E+04, 1.2451004606E+02, 1.4450219365E+01, 7.5355254967E+01, 1.1049106379E+01, 9.8201186483E-01],
	[4.7330000000E+04, 1.2453344476E+02, 1.4450346873E+01, 7.5381326888E+01, 1.1049925554E+01, 9.8201914903E-01],
	[4.7335000000E+04, 1.2455684538E+02, 1.4450474370E+01, 7.5407405070E+01, 1.1050744536E+01, 9.8202642984E-01],
	[4.7340000000E+04, 1.2458024793E+02, 1.4450601854E+01, 7.5433489515E+01, 1.1051563323E+01, 9.8203370727E-01],
	[4.7345000000E+04, 1.2460365240E+02, 1.4450729325E+01, 7.5459580224E+01, 1.1052381916E+01, 9.8204098133E-01],
	[4.7350000000E+04, 1.2462705880E+02, 1.4450856785E+01, 7.5485677197E+01, 1.1053200315E+01, 9.8204825201E-01],
	[4.7355000000E+04, 1.2465046712E+02, 1.4450984232E+01, 7.5511780435E+01, 1.1054018519E+01, 9.8205551932E-01],
	[4.7360000000E+04, 1.2467387737E+02, 1.4451111666E+01, 7.5537889940E+01, 1.1054836530E+01, 9.8206278325E-01],
	[4.7365000000E+04, 1.2469728954E+02, 1.4451239089E+01, 7.5564005712E+01, 1.1055654347E+01, 9.8207004382E-01],
	[4.7370000000E+04, 1.2472070364E+02, 1.4451366499E+01, 7.5590127752E+01, 1.1056471970E+01, 9.8207730102E-01],
	[4.7375000000E+04, 1.2474411966E+02, 1.4451493896E+01, 7.5616256060E+01, 1.1057289399E+01, 9.8208455485E-01],
	[4.7380000000E+04, 1.2476753760E+02, 1.4451621282E+01, 7.5642390638E+01, 1.1058106635E+01, 9.8209180531E-01],
	[4.7385000000E+04, 1.2479095747E+02, 1.4451748655E+01, 7.5668531486E+01, 1.1058923676E+01, 9.8209905241E-01],
	[4.7390000000E+04, 1.2481437927E+02, 1.4451876016E+01, 7.5694678606E+01, 1.1059740524E+01, 9.8210629615E-01],
	[4.7395000000E+04, 1.2483780298E+02, 1.4452003364E+01, 7.5720831998E+01, 1.1060557179E+01, 9.8211353654E-01],
	[4.7400000000E+04, 1.2486122863E+02, 1.4452130700E+01, 7.5746991662E+01, 1.1061373639E+01, 9.8212077356E-01],
	[4.7405000000E+04, 1.2488465619E+02, 1.4452258024E+01, 7.5773157601E+01, 1.1062189907E+01, 9.8212800723E-01],
	[4.7410000000E+04, 1.2490808568E+02, 1.4452385336E+01, 7.5799329814E+01, 1.1063005980E+01, 9.8213523754E-01],
	[4.7415000000E+04, 1.2493151710E+02, 1.4452512635E+01, 7.5825508302E+01, 1.1063821861E+01, 9.8214246451E-01],
	[4.7420000000E+04, 1.2495495043E+02, 1.4452639922E+01, 7.5851693067E+01, 1.1064637547E+01, 9.8214968812E-01],
	[4.7425000000E+04, 1.2497838570E+02, 1.4452767196E+01, 7.5877884109E+01, 1.1065453041E+01, 9.8215690838E-01],
	[4.7430000000E+04, 1.2500182288E+02, 1.4452894458E+01, 7.5904081429E+01, 1.1066268341E+01, 9.8216412530E-01],
	[4.7435000000E+04, 1.2502526199E+02, 1.4453021708E+01, 7.5930285028E+01, 1.1067083448E+01, 9.8217133887E-01],
	[4.7440000000E+04, 1.2504870303E+02, 1.4453148946E+01, 7.5956494906E+01, 1.1067898362E+01, 9.8217854910E-01],
	[4.7445000000E+04, 1.2507214598E+02, 1.4453276172E+01, 7.5982711065E+01, 1.1068713083E+01, 9.8218575599E-01],
	[4.7450000000E+04, 1.2509559086E+02, 1.4453403385E+01, 7.6008933505E+01, 1.1069527611E+01, 9.8219295953E-01],
	[4.7455000000E+04, 1.2511903767E+02, 1.4453530586E+01, 7.6035162228E+01, 1.1070341945E+01, 9.8220015974E-01],
	[4.7460000000E+04, 1.2514248640E+02, 1.4453657774E+01, 7.6061397233E+01, 1.1071156087E+01, 9.8220735662E-01],
	[4.7465000000E+04, 1.2516593705E+02, 1.4453784950E+01, 7.6087638522E+01, 1.1071970036E+01, 9.8221455016E-01],
	[4.7470000000E+04, 1.2518938963E+02, 1.4453912114E+01, 7.6113886097E+01, 1.1072783792E+01, 9.8222174036E-01],
	[4.7475000000E+04, 1.2521284413E+02, 1.4454039266E+01, 7.6140139956E+01, 1.1073597355E+01, 9.8222892724E-01],
	[4.7480000000E+04, 1.2523630055E+02, 1.4454166406E+01, 7.6166400102E+01, 1.1074410725E+01, 9.8223611079E-01],
	[4.7485000000E+04, 1.2525975890E+02, 1.4454293533E+01, 7.6192666535E+01, 1.1075223903E+01, 9.8224329101E-01],
	[4.7490000000E+04, 1.2528321917E+02, 1.4454420648E+01, 7.6218939257E+01, 1.1076036888E+01, 9.8225046790E-01],
	[4.7495000000E+04, 1.2530668136E+02, 1.4454547750E+01, 7.6245218267E+01, 1.1076849680E+01, 9.8225764147E-01],
	[4.7500000000E+04, 1.2533014548E+02, 1.4454674841E+01, 7.6271503567E+01, 1.1077662280E+01, 9.8226481172E-01],
	[4.7505000000E+04, 1.2535361151E+02, 1.4454801919E+01, 7.6297795158E+01, 1.1078474687E+01, 9.8227197865E-01],
	[4.7510000000E+04, 1.2537707948E+02, 1.4454928985E+01, 7.6324093040E+01, 1.1079286902E+01, 9.8227914226E-01],
	[4.7515000000E+04, 1.2540054936E+02, 1.4455056038E+01, 7.6350397214E+01, 1.1080098924E+01, 9.8228630256E-01],
	[4.7520000000E+04, 1.2542402117E+02, 1.4455183080E+01, 7.6376707682E+01, 1.1080910754E+01, 9.8229345954E-01],
	[4.7525000000E+04, 1.2544749491E+02, 1.4455310109E+01, 7.6403024443E+01, 1.1081722392E+01, 9.8230061321E-01],
	[4.7530000000E+04, 1.2547101376E+02, 1.4455441771E+01, 7.6429347499E+01, 1.1082536905E+01, 9.8230776356E-01],
	[4.7535000000E+04, 1.2549453564E+02, 1.4455573538E+01, 7.6455676851E+01, 1.1083351303E+01, 9.8231491061E-01],
	[4.7540000000E+04, 1.2551805946E+02, 1.4455705293E+01, 7.6482012500E+01, 1.1084165510E+01, 9.8232205435E-01],
	[4.7545000000E+04, 1.2554158521E+02, 1.4455837035E+01, 7.6508354446E+01, 1.1084979526E+01, 9.8232919478E-01],
	[4.7550000000E+04, 1.2556511290E+02, 1.4455968764E+01, 7.6534702690E+01, 1.1085793349E+01, 9.8233633191E-01],
	[4.7555000000E+04, 1.2558864252E+02, 1.4456100480E+01, 7.6561057233E+01, 1.1086606981E+01, 9.8234346574E-01],
	[4.7560000000E+04, 1.2561217408E+02, 1.4456232184E+01, 7.6587418075E+01, 1.1087420422E+01, 9.8235059627E-01],
	[4.7565000000E+04, 1.2563570757E+02, 1.4456363875E+01, 7.6613785219E+01, 1.1088233671E+01, 9.8235772349E-01],
	[4.7570000000E+04, 1.2565924299E+02, 1.4456495554E+01, 7.6640158664E+01, 1.1089046728E+01, 9.8236484742E-01],
	[4.7575000000E+04, 1.2568278035E+02, 1.4456627220E+01, 7.6666538412E+01, 1.1089859595E+01, 9.8237196806E-01],
	[4.7580000000E+04, 1.2570631965E+02, 1.4456758873E+01, 7.6692924463E+01, 1.1090672269E+01, 9.8237908540E-01],
	[4.7585000000E+04, 1.2572986088E+02, 1.4456890514E+01, 7.6719316817E+01, 1.1091484753E+01, 9.8238619946E-01],
	[4.7590000000E+04, 1.2575340404E+02, 1.4457022142E+01, 7.6745715477E+01, 1.1092297045E+01, 9.8239331022E-01],
	[4.7595000000E+04, 1.2577694914E+02, 1.4457153758E+01, 7.6772120443E+01, 1.1093109146E+01, 9.8240041769E-01],
	[4.7600000000E+04, 1.2580049617E+02, 1.4457285360E+01, 7.6798531715E+01, 1.1093921056E+01, 9.8240752188E-01],
	[4.7605000000E+04, 1.2582404514E+02, 1.4457416951E+01, 7.6824949295E+01, 1.1094732775E+01, 9.8241462278E-01],
	[4.7610000000E+04, 1.2584759604E+02, 1.4457548528E+01, 7.6851373183E+01, 1.1095544303E+01, 9.8242172040E-01],
	[4.7615000000E+04, 1.2587114887E+02, 1.4457680093E+01, 7.6877803380E+01, 1.1096355640E+01, 9.8242881473E-01],
	[4.7620000000E+04, 1.2589470364E+02, 1.4457811645E+01, 7.6904239887E+01, 1.1097166786E+01, 9.8243590579E-01],
	[4.7625000000E+04, 1.2591826035E+02, 1.4457943185E+01, 7.6930682705E+01, 1.1097977741E+01, 9.8244299356E-01],
	[4.7630000000E+04, 1.2594181898E+02, 1.4458074712E+01, 7.6957131834E+01, 1.1098788505E+01, 9.8245007806E-01],
	[4.7635000000E+04, 1.2596537956E+02, 1.4458206227E+01, 7.6983587276E+01, 1.1099599078E+01, 9.8245715929E-01],
	[4.7640000000E+04, 1.2598894206E+02, 1.4458337729E+01, 7.7010049032E+01, 1.1100409461E+01, 9.8246423724E-01],
	[4.7645000000E+04, 1.2601250650E+02, 1.4458469218E+01, 7.7036517101E+01, 1.1101219653E+01, 9.8247131191E-01],
	[4.7650000000E+04, 1.2603607287E+02, 1.4458600694E+01, 7.7062991486E+01, 1.1102029654E+01, 9.8247838332E-01],
	[4.7655000000E+04, 1.2605964118E+02, 1.4458732159E+01, 7.7089472186E+01, 1.1102839465E+01, 9.8248545145E-01],
	[4.7660000000E+04, 1.2608321142E+02, 1.4458863610E+01, 7.7115959204E+01, 1.1103649085E+01, 9.8249251632E-01],
	[4.7665000000E+04, 1.2610678360E+02, 1.4458995049E+01, 7.7142452539E+01, 1.1104458515E+01, 9.8249957792E-01],
	[4.7670000000E+04, 1.2613035771E+02, 1.4459126475E+01, 7.7168952192E+01, 1.1105267754E+01, 9.8250663626E-01],
	[4.7675000000E+04, 1.2615393375E+02, 1.4459257889E+01, 7.7195458164E+01, 1.1106076803E+01, 9.8251369134E-01],
	[4.7680000000E+04, 1.2617751173E+02, 1.4459389290E+01, 7.7221970457E+01, 1.1106885662E+01, 9.8252074315E-01],
	[4.7685000000E+04, 1.2620109164E+02, 1.4459520679E+01, 7.7248489070E+01, 1.1107694330E+01, 9.8252779170E-01],
	[4.7690000000E+04, 1.2622467348E+02, 1.4459652054E+01, 7.7275014006E+01, 1.1108502808E+01, 9.8253483699E-01],
	[4.7695000000E+04, 1.2624825726E+02, 1.4459783418E+01, 7.7301545263E+01, 1.1109311096E+01, 9.8254187903E-01],
	[4.7700000000E+04, 1.2627184297E+02, 1.4459914769E+01, 7.7328082845E+01, 1.1110119194E+01, 9.8254891781E-01],
	[4.7705000000E+04, 1.2629543061E+02, 1.4460046107E+01, 7.7354626751E+01, 1.1110927101E+01, 9.8255595334E-01],
	[4.7710000000E+04, 1.2631902019E+02, 1.4460177432E+01, 7.7381176981E+01, 1.1111734819E+01, 9.8256298562E-01],
	[4.7715000000E+04, 1.2634261170E+02, 1.4460308746E+01, 7.7407733538E+01, 1.1112542346E+01, 9.8257001464E-01],
	[4.7720000000E+04, 1.2636620514E+02, 1.4460440046E+01, 7.7434296422E+01, 1.1113349684E+01, 9.8257704042E-01],
	[4.7725000000E+04, 1.2638980052E+02, 1.4460571334E+01, 7.7460865633E+01, 1.1114156832E+01, 9.8258406295E-01],
	[4.7730000000E+04, 1.2641339783E+02, 1.4460702609E+01, 7.7487441173E+01, 1.1114963790E+01, 9.8259108223E-01],
	[4.7735000000E+04, 1.2643699707E+02, 1.4460833872E+01, 7.7514023042E+01, 1.1115770558E+01, 9.8259809827E-01],
	[4.7740000000E+04, 1.2646059825E+02, 1.4460965122E+01, 7.7540611242E+01, 1.1116577137E+01, 9.8260511107E-01],
	[4.7745000000E+04, 1.2648420136E+02, 1.4461096360E+01, 7.7567205772E+01, 1.1117383525E+01, 9.8261212062E-01],
	[4.7750000000E+04, 1.2650780640E+02, 1.4461227585E+01, 7.7593806635E+01, 1.1118189724E+01, 9.8261912694E-01],
	[4.7755000000E+04, 1.2653141337E+02, 1.4461358798E+01, 7.7620413830E+01, 1.1118995734E+01, 9.8262613002E-01],
	[4.7760000000E+04, 1.2655502228E+02, 1.4461489998E+01, 7.7647027359E+01, 1.1119801554E+01, 9.8263312986E-01],
	[4.7765000000E+04, 1.2657863312E+02, 1.4461621185E+01, 7.7673647222E+01, 1.1120607184E+01, 9.8264012647E-01],
	[4.7770000000E+04, 1.2660224590E+02, 1.4461752360E+01, 7.7700273420E+01, 1.1121412626E+01, 9.8264711984E-01],
	[4.7775000000E+04, 1.2662586061E+02, 1.4461883523E+01, 7.7726905955E+01, 1.1122217877E+01, 9.8265410998E-01],
	[4.7780000000E+04, 1.2664947725E+02, 1.4462014673E+01, 7.7753544826E+01, 1.1123022940E+01, 9.8266109690E-01],
	[4.7785000000E+04, 1.2667309582E+02, 1.4462145810E+01, 7.7780190035E+01, 1.1123827813E+01, 9.8266808058E-01],
	[4.7790000000E+04, 1.2669671632E+02, 1.4462276935E+01, 7.7806841583E+01, 1.1124632497E+01, 9.8267506104E-01],
	[4.7795000000E+04, 1.2672033876E+02, 1.4462408047E+01, 7.7833499471E+01, 1.1125436991E+01, 9.8268203827E-01],
	[4.7800000000E+04, 1.2674396313E+02, 1.4462539147E+01, 7.7860163698E+01, 1.1126241297E+01, 9.8268901228E-01],
	[4.7805000000E+04, 1.2676758943E+02, 1.4462670234E+01, 7.7886834267E+01, 1.1127045413E+01, 9.8269598306E-01],
	[4.7810000000E+04, 1.2679121767E+02, 1.4462801309E+01, 7.7913511178E+01, 1.1127849341E+01, 9.8270295063E-01],
	[4.7815000000E+04, 1.2681484784E+02, 1.4462932371E+01, 7.7940194432E+01, 1.1128653079E+01, 9.8270991497E-01],
	[4.7820000000E+04, 1.2683847994E+02, 1.4463063421E+01, 7.7966884030E+01, 1.1129456629E+01, 9.8271687610E-01],
	[4.7825000000E+04, 1.2686211397E+02, 1.4463194458E+01, 7.7993579972E+01, 1.1130259989E+01, 9.8272383401E-01],
	[4.7830000000E+04, 1.2688574993E+02, 1.4463325483E+01, 7.8020282259E+01, 1.1131063161E+01, 9.8273078871E-01],
	[4.7835000000E+04, 1.2690938783E+02, 1.4463456495E+01, 7.8046990893E+01, 1.1131866144E+01, 9.8273774020E-01],
	[4.7840000000E+04, 1.2693302766E+02, 1.4463587494E+01, 7.8073705874E+01, 1.1132668939E+01, 9.8274468847E-01],
	[4.7845000000E+04, 1.2695666942E+02, 1.4463718482E+01, 7.8100427202E+01, 1.1133471544E+01, 9.8275163353E-01],
	[4.7850000000E+04, 1.2698031312E+02, 1.4463849456E+01, 7.8127154880E+01, 1.1134273961E+01, 9.8275857539E-01],
	[4.7855000000E+04, 1.2700395874E+02, 1.4463980418E+01, 7.8153888907E+01, 1.1135076190E+01, 9.8276551404E-01],
	[4.7860000000E+04, 1.2702760630E+02, 1.4464111368E+01, 7.8180629284E+01, 1.1135878230E+01, 9.8277244949E-01],
	[4.7865000000E+04, 1.2705125579E+02, 1.4464242305E+01, 7.8207376013E+01, 1.1136680081E+01, 9.8277938173E-01],
	[4.7870000000E+04, 1.2707490721E+02, 1.4464373230E+01, 7.8234129094E+01, 1.1137481744E+01, 9.8278631077E-01],
	[4.7875000000E+04, 1.2709856057E+02, 1.4464504142E+01, 7.8260888528E+01, 1.1138283219E+01, 9.8279323661E-01],
	[4.7880000000E+04, 1.2712221585E+02, 1.4464635042E+01, 7.8287654316E+01, 1.1139084505E+01, 9.8280015925E-01],
	[4.7885000000E+04, 1.2714587307E+02, 1.4464765929E+01, 7.8314426458E+01, 1.1139885603E+01, 9.8280707869E-01],
	[4.7890000000E+04, 1.2716953222E+02, 1.4464896804E+01, 7.8341204956E+01, 1.1140686513E+01, 9.8281399494E-01],
	[4.7895000000E+04, 1.2719319330E+02, 1.4465027666E+01, 7.8367989810E+01, 1.1141487234E+01, 9.8282090800E-01],
	[4.7900000000E+04, 1.2721685631E+02, 1.4465158516E+01, 7.8394781022E+01, 1.1142287768E+01, 9.8282781786E-01],
	[4.7905000000E+04, 1.2724052126E+02, 1.4465289353E+01, 7.8421578591E+01, 1.1143088113E+01, 9.8283472453E-01],
	[4.7910000000E+04, 1.2726418813E+02, 1.4465420178E+01, 7.8448382520E+01, 1.1143888270E+01, 9.8284162801E-01],
	[4.7915000000E+04, 1.2728785694E+02, 1.4465550990E+01, 7.8475192808E+01, 1.1144688240E+01, 9.8284852831E-01],
	[4.7920000000E+04, 1.2731152768E+02, 1.4465681790E+01, 7.8502009457E+01, 1.1145488021E+01, 9.8285542541E-01],
	[4.7925000000E+04, 1.2733520035E+02, 1.4465812577E+01, 7.8528832467E+01, 1.1146287615E+01, 9.8286231934E-01],
	[4.7930000000E+04, 1.2735887495E+02, 1.4465943352E+01, 7.8555661839E+01, 1.1147087020E+01, 9.8286921008E-01],
	[4.7935000000E+04, 1.2738255149E+02, 1.4466074115E+01, 7.8582497575E+01, 1.1147886238E+01, 9.8287609764E-01],
	[4.7940000000E+04, 1.2740622995E+02, 1.4466204865E+01, 7.8609339675E+01, 1.1148685268E+01, 9.8288298202E-01],
	[4.7945000000E+04, 1.2742991035E+02, 1.4466335602E+01, 7.8636188139E+01, 1.1149484111E+01, 9.8288986322E-01],
	[4.7950000000E+04, 1.2745359268E+02, 1.4466466327E+01, 7.8663042969E+01, 1.1150282766E+01, 9.8289674124E-01],
	[4.7955000000E+04, 1.2747727693E+02, 1.4466597040E+01, 7.8689904165E+01, 1.1151081233E+01, 9.8290361609E-01],
	[4.7960000000E+04, 1.2750096312E+02, 1.4466727740E+01, 7.8716771729E+01, 1.1151879513E+01, 9.8291048777E-01],
	[4.7965000000E+04, 1.2752465124E+02, 1.4466858428E+01, 7.8743645661E+01, 1.1152677605E+01, 9.8291735627E-01],
	[4.7970000000E+04, 1.2754834130E+02, 1.4466989103E+01, 7.8770525962E+01, 1.1153475510E+01, 9.8292422160E-01],
	[4.7975000000E+04, 1.2757203328E+02, 1.4467119766E+01, 7.8797412633E+01, 1.1154273227E+01, 9.8293108377E-01],
	[4.7980000000E+04, 1.2759572719E+02, 1.4467250417E+01, 7.8824305674E+01, 1.1155070757E+01, 9.8293794276E-01],
	[4.7985000000E+04, 1.2761942304E+02, 1.4467381055E+01, 7.8851205088E+01, 1.1155868100E+01, 9.8294479859E-01],
	[4.7990000000E+04, 1.2764312082E+02, 1.4467511680E+01, 7.8878110873E+01, 1.1156665256E+01, 9.8295165126E-01],
	[4.7995000000E+04, 1.2766682052E+02, 1.4467642294E+01, 7.8905023032E+01, 1.1157462224E+01, 9.8295850076E-01],
	[4.8000000000E+04, 1.2769052216E+02, 1.4467772894E+01, 7.8931941565E+01, 1.1158259006E+01, 9.8296534711E-01],
	[4.8005000000E+04, 1.2771422573E+02, 1.4467903483E+01, 7.8958866472E+01, 1.1159055600E+01, 9.8297219029E-01],
	[4.8010000000E+04, 1.2773793123E+02, 1.4468034058E+01, 7.8985797756E+01, 1.1159852007E+01, 9.8297903031E-01],
	[4.8015000000E+04, 1.2776163866E+02, 1.4468164622E+01, 7.9012735416E+01, 1.1160648227E+01, 9.8298586718E-01],
	[4.8020000000E+04, 1.2778534802E+02, 1.4468295173E+01, 7.9039679454E+01, 1.1161444260E+01, 9.8299270089E-01],
	[4.8025000000E+04, 1.2780905931E+02, 1.4468425712E+01, 7.9066629870E+01, 1.1162240107E+01, 9.8299953145E-01],
	[4.8030000000E+04, 1.2783277253E+02, 1.4468556238E+01, 7.9093586665E+01, 1.1163035766E+01, 9.8300635886E-01],
	[4.8035000000E+04, 1.2785648768E+02, 1.4468686752E+01, 7.9120549840E+01, 1.1163831239E+01, 9.8301318312E-01],
	[4.8040000000E+04, 1.2788020477E+02, 1.4468817253E+01, 7.9147519396E+01, 1.1164626525E+01, 9.8302000423E-01],
	[4.8045000000E+04, 1.2790392378E+02, 1.4468947742E+01, 7.9174495333E+01, 1.1165421624E+01, 9.8302682219E-01],
	[4.8050000000E+04, 1.2792764472E+02, 1.4469078219E+01, 7.9201477654E+01, 1.1166216537E+01, 9.8303363701E-01],
	[4.8055000000E+04, 1.2795136760E+02, 1.4469208683E+01, 7.9228466357E+01, 1.1167011263E+01, 9.8304044868E-01],
	[4.8060000000E+04, 1.2797509240E+02, 1.4469339135E+01, 7.9255461445E+01, 1.1167805803E+01, 9.8304725721E-01],
	[4.8065000000E+04, 1.2799881914E+02, 1.4469469574E+01, 7.9282462918E+01, 1.1168600156E+01, 9.8305406260E-01],
	[4.8070000000E+04, 1.2802254780E+02, 1.4469600001E+01, 7.9309470776E+01, 1.1169394322E+01, 9.8306086485E-01],
	[4.8075000000E+04, 1.2804627839E+02, 1.4469730416E+01, 7.9336485022E+01, 1.1170188303E+01, 9.8306766396E-01],
	[4.8080000000E+04, 1.2807001092E+02, 1.4469860818E+01, 7.9363505655E+01, 1.1170982097E+01, 9.8307445994E-01],
	[4.8085000000E+04, 1.2809374537E+02, 1.4469991208E+01, 7.9390532677E+01, 1.1171775704E+01, 9.8308125278E-01],
	[4.8090000000E+04, 1.2811748176E+02, 1.4470121585E+01, 7.9417566087E+01, 1.1172569126E+01, 9.8308804249E-01],
	[4.8095000000E+04, 1.2814122008E+02, 1.4470251950E+01, 7.9444605888E+01, 1.1173362361E+01, 9.8309482906E-01],
	[4.8100000000E+04, 1.2816496032E+02, 1.4470382303E+01, 7.9471652080E+01, 1.1174155410E+01, 9.8310161251E-01],
	[4.8105000000E+04, 1.2818870250E+02, 1.4470512643E+01, 7.9498704664E+01, 1.1174948273E+01, 9.8310839283E-01],
	[4.8110000000E+04, 1.2821244660E+02, 1.4470642971E+01, 7.9525763640E+01, 1.1175740950E+01, 9.8311517002E-01],
	[4.8115000000E+04, 1.2823619263E+02, 1.4470773287E+01, 7.9552829010E+01, 1.1176533441E+01, 9.8312194408E-01],
	[4.8120000000E+04, 1.2825994060E+02, 1.4470903590E+01, 7.9579900775E+01, 1.1177325746E+01, 9.8312871502E-01],
	[4.8125000000E+04, 1.2828369049E+02, 1.4471033881E+01, 7.9606978934E+01, 1.1178117865E+01, 9.8313548284E-01],
	[4.8130000000E+04, 1.2830744232E+02, 1.4471164160E+01, 7.9634063490E+01, 1.1178909798E+01, 9.8314224754E-01],
	[4.8135000000E+04, 1.2833119607E+02, 1.4471294426E+01, 7.9661154442E+01, 1.1179701545E+01, 9.8314900912E-01],
	[4.8140000000E+04, 1.2835495175E+02, 1.4471424680E+01, 7.9688251792E+01, 1.1180493107E+01, 9.8315576758E-01],
	[4.8145000000E+04, 1.2837870937E+02, 1.4471554921E+01, 7.9715355541E+01, 1.1181284483E+01, 9.8316252293E-01],
	[4.8150000000E+04, 1.2840246891E+02, 1.4471685150E+01, 7.9742465689E+01, 1.1182075673E+01, 9.8316927516E-01],
	[4.8155000000E+04, 1.2842623038E+02, 1.4471815367E+01, 7.9769582238E+01, 1.1182866678E+01, 9.8317602428E-01],
	[4.8160000000E+04, 1.2844999378E+02, 1.4471945571E+01, 7.9796705187E+01, 1.1183657497E+01, 9.8318277028E-01],
	[4.8165000000E+04, 1.2847375911E+02, 1.4472075763E+01, 7.9823834539E+01, 1.1184448131E+01, 9.8318951318E-01],
	[4.8170000000E+04, 1.2849752637E+02, 1.4472205943E+01, 7.9850970293E+01, 1.1185238579E+01, 9.8319625297E-01],
	[4.8175000000E+04, 1.2852129556E+02, 1.4472336110E+01, 7.9878112451E+01, 1.1186028842E+01, 9.8320298965E-01],
	[4.8180000000E+04, 1.2854506668E+02, 1.4472466265E+01, 7.9905261014E+01, 1.1186818920E+01, 9.8320972322E-01],
	[4.8185000000E+04, 1.2856883973E+02, 1.4472596408E+01, 7.9932415982E+01, 1.1187608812E+01, 9.8321645369E-01],
	[4.8190000000E+04, 1.2859261470E+02, 1.4472726538E+01, 7.9959577356E+01, 1.1188398519E+01, 9.8322318106E-01],
	[4.8195000000E+04, 1.2861639161E+02, 1.4472856656E+01, 7.9986745137E+01, 1.1189188041E+01, 9.8322990533E-01],
	[4.8200000000E+04, 1.2864017044E+02, 1.4472986762E+01, 8.0013919326E+01, 1.1189977377E+01, 9.8323662650E-01],
	[4.8205000000E+04, 1.2866395121E+02, 1.4473116855E+01, 8.0041099924E+01, 1.1190766529E+01, 9.8324334458E-01],
	[4.8210000000E+04, 1.2868773390E+02, 1.4473246936E+01, 8.0068286931E+01, 1.1191555495E+01, 9.8325005955E-01],
	[4.8215000000E+04, 1.2871151852E+02, 1.4473377005E+01, 8.0095480349E+01, 1.1192344277E+01, 9.8325677143E-01],
	[4.8220000000E+04, 1.2873530507E+02, 1.4473507061E+01, 8.0122680177E+01, 1.1193132873E+01, 9.8326348022E-01],
	[4.8225000000E+04, 1.2875909355E+02, 1.4473637105E+01, 8.0149886419E+01, 1.1193921285E+01, 9.8327018592E-01],
	[4.8230000000E+04, 1.2878288396E+02, 1.4473767137E+01, 8.0177099073E+01, 1.1194709512E+01, 9.8327688853E-01],
	[4.8235000000E+04, 1.2880667630E+02, 1.4473897157E+01, 8.0204318140E+01, 1.1195497554E+01, 9.8328358805E-01],
	[4.8240000000E+04, 1.2883047056E+02, 1.4474027164E+01, 8.0231543623E+01, 1.1196285411E+01, 9.8329028448E-01],
	[4.8245000000E+04, 1.2885426676E+02, 1.4474157158E+01, 8.0258775521E+01, 1.1197073083E+01, 9.8329697783E-01],
	[4.8250000000E+04, 1.2887806488E+02, 1.4474287141E+01, 8.0286013835E+01, 1.1197860571E+01, 9.8330366809E-01],
	[4.8255000000E+04, 1.2890186493E+02, 1.4474417111E+01, 8.0313258567E+01, 1.1198647874E+01, 9.8331035527E-01],
	[4.8260000000E+04, 1.2892566692E+02, 1.4474547069E+01, 8.0340509716E+01, 1.1199434993E+01, 9.8331703938E-01],
	[4.8265000000E+04, 1.2894947082E+02, 1.4474677015E+01, 8.0367767284E+01, 1.1200221927E+01, 9.8332372040E-01],
	[4.8270000000E+04, 1.2897327666E+02, 1.4474806948E+01, 8.0395031273E+01, 1.1201008677E+01, 9.8333039834E-01],
	[4.8275000000E+04, 1.2899708443E+02, 1.4474936869E+01, 8.0422301681E+01, 1.1201795242E+01, 9.8333707321E-01],
	[4.8280000000E+04, 1.2902089412E+02, 1.4475066778E+01, 8.0449578511E+01, 1.1202581623E+01, 9.8334374500E-01],
	[4.8285000000E+04, 1.2904470574E+02, 1.4475196674E+01, 8.0476861764E+01, 1.1203367820E+01, 9.8335041373E-01],
	[4.8290000000E+04, 1.2906851930E+02, 1.4475326558E+01, 8.0504151439E+01, 1.1204153832E+01, 9.8335707937E-01],
	[4.8295000000E+04, 1.2909237707E+02, 1.4475460891E+01, 8.0531447538E+01, 1.1204942652E+01, 9.8336374195E-01],
	[4.8300000000E+04, 1.2911623867E+02, 1.4475595410E+01, 8.0558750063E+01, 1.1205731421E+01, 9.8337040147E-01],
	[4.8305000000E+04, 1.2914010221E+02, 1.4475729917E+01, 8.0586059012E+01, 1.1206520006E+01, 9.8337705791E-01],
	[4.8310000000E+04, 1.2916396768E+02, 1.4475864410E+01, 8.0613374389E+01, 1.1207308408E+01, 9.8338371129E-01],
	[4.8315000000E+04, 1.2918783510E+02, 1.4475998891E+01, 8.0640696192E+01, 1.1208096626E+01, 9.8339036161E-01],
	[4.8320000000E+04, 1.2921170446E+02, 1.4476133360E+01, 8.0668024424E+01, 1.1208884661E+01, 9.8339700886E-01],
	[4.8325000000E+04, 1.2923557576E+02, 1.4476267816E+01, 8.0695359085E+01, 1.1209672512E+01, 9.8340365305E-01],
	[4.8330000000E+04, 1.2925944900E+02, 1.4476402259E+01, 8.0722700176E+01, 1.1210460180E+01, 9.8341029419E-01],
	[4.8335000000E+04, 1.2928332417E+02, 1.4476536689E+01, 8.0750047697E+01, 1.1211247664E+01, 9.8341693226E-01],
	[4.8340000000E+04, 1.2930720129E+02, 1.4476671107E+01, 8.0777401650E+01, 1.1212034965E+01, 9.8342356728E-01],
	[4.8345000000E+04, 1.2933108035E+02, 1.4476805512E+01, 8.0804762035E+01, 1.1212822082E+01, 9.8343019925E-01],
	[4.8350000000E+04, 1.2935496134E+02, 1.4476939904E+01, 8.0832128854E+01, 1.1213609016E+01, 9.8343682816E-01],
	[4.8355000000E+04, 1.2937884428E+02, 1.4477074284E+01, 8.0859502107E+01, 1.1214395767E+01, 9.8344345402E-01],
	[4.8360000000E+04, 1.2940272915E+02, 1.4477208651E+01, 8.0886881794E+01, 1.1215182335E+01, 9.8345007683E-01],
	[4.8365000000E+04, 1.2942661597E+02, 1.4477343006E+01, 8.0914267918E+01, 1.1215968719E+01, 9.8345669660E-01],
	[4.8370000000E+04, 1.2945050472E+02, 1.4477477347E+01, 8.0941660478E+01, 1.1216754921E+01, 9.8346331331E-01],
	[4.8375000000E+04, 1.2947439542E+02, 1.4477611677E+01, 8.0969059475E+01, 1.1217540939E+01, 9.8346992698E-01],
	[4.8380000000E+04, 1.2949828805E+02, 1.4477745993E+01, 8.0996464911E+01, 1.1218326774E+01, 9.8347653761E-01],
	[4.8385000000E+04, 1.2952218262E+02, 1.4477880297E+01, 8.1023876786E+01, 1.1219112427E+01, 9.8348314519E-01],
	[4.8390000000E+04, 1.2954607913E+02, 1.4478014588E+01, 8.1051295101E+01, 1.1219897896E+01, 9.8348974974E-01],
	[4.8395000000E+04, 1.2956997758E+02, 1.4478148867E+01, 8.1078719857E+01, 1.1220683183E+01, 9.8349635124E-01],
	[4.8400000000E+04, 1.2959387797E+02, 1.4478283133E+01, 8.1106151055E+01, 1.1221468287E+01, 9.8350294971E-01],
	[4.8405000000E+04, 1.2961778030E+02, 1.4478417386E+01, 8.1133588695E+01, 1.1222253208E+01, 9.8350954514E-01],
	[4.8410000000E+04, 1.2964168456E+02, 1.4478551627E+01, 8.1161032779E+01, 1.1223037946E+01, 9.8351613753E-01],
	[4.8415000000E+04, 1.2966559077E+02, 1.4478685855E+01, 8.1188483307E+01, 1.1223822502E+01, 9.8352272690E-01],
	[4.8420000000E+04, 1.2968949891E+02, 1.4478820071E+01, 8.1215940280E+01, 1.1224606875E+01, 9.8352931323E-01],
	[4.8425000000E+04, 1.2971340900E+02, 1.4478954274E+01, 8.1243403699E+01, 1.1225391066E+01, 9.8353589653E-01],
	[4.8430000000E+04, 1.2973732102E+02, 1.4479088464E+01, 8.1270873564E+01, 1.1226175074E+01, 9.8354247680E-01],
	[4.8435000000E+04, 1.2976123498E+02, 1.4479222642E+01, 8.1298349878E+01, 1.1226958899E+01, 9.8354905405E-01],
	[4.8440000000E+04, 1.2978515088E+02, 1.4479356807E+01, 8.1325832640E+01, 1.1227742542E+01, 9.8355562827E-01],
	[4.8445000000E+04, 1.2980906872E+02, 1.4479490959E+01, 8.1353321851E+01, 1.1228526003E+01, 9.8356219946E-01],
	[4.8450000000E+04, 1.2983298850E+02, 1.4479625099E+01, 8.1380817512E+01, 1.1229309282E+01, 9.8356876764E-01],
	[4.8455000000E+04, 1.2985691021E+02, 1.4479759227E+01, 8.1408319625E+01, 1.1230092378E+01, 9.8357533279E-01],
	[4.8460000000E+04, 1.2988083387E+02, 1.4479893341E+01, 8.1435828189E+01, 1.1230875292E+01, 9.8358189492E-01],
	[4.8465000000E+04, 1.2990475946E+02, 1.4480027443E+01, 8.1463343206E+01, 1.1231658024E+01, 9.8358845404E-01],
	[4.8470000000E+04, 1.2992868699E+02, 1.4480161533E+01, 8.1490864676E+01, 1.1232440573E+01, 9.8359501014E-01],
	[4.8475000000E+04, 1.2995261646E+02, 1.4480295610E+01, 8.1518392601E+01, 1.1233222941E+01, 9.8360156322E-01],
	[4.8480000000E+04, 1.2997654787E+02, 1.4480429674E+01, 8.1545926982E+01, 1.1234005127E+01, 9.8360811329E-01],
	[4.8485000000E+04, 1.3000048122E+02, 1.4480563726E+01, 8.1573467818E+01, 1.1234787130E+01, 9.8361466035E-01],
	[4.8490000000E+04, 1.3002441650E+02, 1.4480697765E+01, 8.1601015111E+01, 1.1235568952E+01, 9.8362120440E-01],
	[4.8495000000E+04, 1.3004835373E+02, 1.4480831792E+01, 8.1628568862E+01, 1.1236350592E+01, 9.8362774544E-01],
	[4.8500000000E+04, 1.3007229289E+02, 1.4480965806E+01, 8.1656129072E+01, 1.1237132050E+01, 9.8363428348E-01],
	[4.8505000000E+04, 1.3009623399E+02, 1.4481099807E+01, 8.1683695741E+01, 1.1237913326E+01, 9.8364081850E-01],
	[4.8510000000E+04, 1.3012017703E+02, 1.4481233796E+01, 8.1711268871E+01, 1.1238694420E+01, 9.8364735053E-01],
	[4.8515000000E+04, 1.3014412200E+02, 1.4481367772E+01, 8.1738848461E+01, 1.1239475333E+01, 9.8365387955E-01],
	[4.8520000000E+04, 1.3016806892E+02, 1.4481501736E+01, 8.1766434514E+01, 1.1240256064E+01, 9.8366040557E-01],
	[4.8525000000E+04, 1.3019201777E+02, 1.4481635687E+01, 8.1794027030E+01, 1.1241036614E+01, 9.8366692858E-01],
	[4.8530000000E+04, 1.3021596856E+02, 1.4481769626E+01, 8.1821626009E+01, 1.1241816982E+01, 9.8367344861E-01],
	[4.8535000000E+04, 1.3023992129E+02, 1.4481903552E+01, 8.1849231453E+01, 1.1242597168E+01, 9.8367996563E-01],
	[4.8540000000E+04, 1.3026387595E+02, 1.4482037465E+01, 8.1876843362E+01, 1.1243377173E+01, 9.8368647966E-01],
	[4.8545000000E+04, 1.3028783256E+02, 1.4482171366E+01, 8.1904461738E+01, 1.1244156997E+01, 9.8369299070E-01],
	[4.8550000000E+04, 1.3031179110E+02, 1.4482305255E+01, 8.1932086581E+01, 1.1244936639E+01, 9.8369949874E-01],
	[4.8555000000E+04, 1.3033575158E+02, 1.4482439130E+01, 8.1959717891E+01, 1.1245716100E+01, 9.8370600379E-01],
	[4.8560000000E+04, 1.3035971399E+02, 1.4482572994E+01, 8.1987355671E+01, 1.1246495380E+01, 9.8371250586E-01],
	[4.8565000000E+04, 1.3038367835E+02, 1.4482706844E+01, 8.2014999920E+01, 1.1247274479E+01, 9.8371900493E-01],
	[4.8570000000E+04, 1.3040764464E+02, 1.4482840683E+01, 8.2042650640E+01, 1.1248053396E+01, 9.8372550103E-01],
	[4.8575000000E+04, 1.3043161287E+02, 1.4482974508E+01, 8.2070307831E+01, 1.1248832132E+01, 9.8373199413E-01],
	[4.8580000000E+04, 1.3045558304E+02, 1.4483108321E+01, 8.2097971494E+01, 1.1249610688E+01, 9.8373848426E-01],
	[4.8585000000E+04, 1.3047955514E+02, 1.4483242122E+01, 8.2125641630E+01, 1.1250389062E+01, 9.8374497140E-01],
	[4.8590000000E+04, 1.3050352918E+02, 1.4483375910E+01, 8.2153318240E+01, 1.1251167255E+01, 9.8375145556E-01],
	[4.8595000000E+04, 1.3052750516E+02, 1.4483509685E+01, 8.2181001325E+01, 1.1251945268E+01, 9.8375793674E-01],
	[4.8600000000E+04, 1.3055148308E+02, 1.4483643448E+01, 8.2208690885E+01, 1.1252723099E+01, 9.8376441495E-01],
	[4.8605000000E+04, 1.3057546294E+02, 1.4483777199E+01, 8.2236386922E+01, 1.1253500750E+01, 9.8377089018E-01],
	[4.8610000000E+04, 1.3059944473E+02, 1.4483910937E+01, 8.2264089436E+01, 1.1254278220E+01, 9.8377736244E-01],
	[4.8615000000E+04, 1.3062342846E+02, 1.4484044662E+01, 8.2291798429E+01, 1.1255055509E+01, 9.8378383172E-01],
	[4.8620000000E+04, 1.3064741412E+02, 1.4484178375E+01, 8.2319513900E+01, 1.1255832618E+01, 9.8379029803E-01],
	[4.8625000000E+04, 1.3067140173E+02, 1.4484312075E+01, 8.2347235851E+01, 1.1256609546E+01, 9.8379676138E-01],
	[4.8630000000E+04, 1.3069539127E+02, 1.4484445763E+01, 8.2374964283E+01, 1.1257386293E+01, 9.8380322175E-01],
	[4.8635000000E+04, 1.3071938274E+02, 1.4484579439E+01, 8.2402699196E+01, 1.1258162860E+01, 9.8380967916E-01],
	[4.8640000000E+04, 1.3074337616E+02, 1.4484713101E+01, 8.2430440592E+01, 1.1258939246E+01, 9.8381613361E-01],
	[4.8645000000E+04, 1.3076737151E+02, 1.4484846752E+01, 8.2458188470E+01, 1.1259715452E+01, 9.8382258509E-01],
	[4.8650000000E+04, 1.3079136880E+02, 1.4484980390E+01, 8.2485942833E+01, 1.1260491478E+01, 9.8382903361E-01],
	[4.8655000000E+04, 1.3081536802E+02, 1.4485114015E+01, 8.2513703681E+01, 1.1261267323E+01, 9.8383547917E-01],
	[4.8660000000E+04, 1.3083936919E+02, 1.4485247628E+01, 8.2541471015E+01, 1.1262042988E+01, 9.8384192177E-01],
	[4.8665000000E+04, 1.3086337229E+02, 1.4485381228E+01, 8.2569244835E+01, 1.1262818473E+01, 9.8384836141E-01],
	[4.8670000000E+04, 1.3088737732E+02, 1.4485514816E+01, 8.2597025142E+01, 1.1263593777E+01, 9.8385479810E-01],
	[4.8675000000E+04, 1.3091138429E+02, 1.4485648391E+01, 8.2624811938E+01, 1.1264368902E+01, 9.8386123183E-01],
	[4.8680000000E+04, 1.3093539320E+02, 1.4485781954E+01, 8.2652605223E+01, 1.1265143846E+01, 9.8386766261E-01],
	[4.8685000000E+04, 1.3095940405E+02, 1.4485915505E+01, 8.2680404998E+01, 1.1265918610E+01, 9.8387409044E-01],
	[4.8690000000E+04, 1.3098341683E+02, 1.4486049042E+01, 8.2708211264E+01, 1.1266693195E+01, 9.8388051532E-01],
	[4.8695000000E+04, 1.3100743155E+02, 1.4486182568E+01, 8.2736024022E+01, 1.1267467599E+01, 9.8388693725E-01],
	[4.8700000000E+04, 1.3103144821E+02, 1.4486316081E+01, 8.2763843272E+01, 1.1268241824E+01, 9.8389335623E-01],
	[4.8705000000E+04, 1.3105546680E+02, 1.4486449581E+01, 8.2791669015E+01, 1.1269015868E+01, 9.8389977227E-01],
	[4.8710000000E+04, 1.3107948733E+02, 1.4486583069E+01, 8.2819501253E+01, 1.1269789733E+01, 9.8390618536E-01],
	[4.8715000000E+04, 1.3110350979E+02, 1.4486716545E+01, 8.2847339985E+01, 1.1270563418E+01, 9.8391259552E-01],
	[4.8720000000E+04, 1.3112753419E+02, 1.4486850008E+01, 8.2875185214E+01, 1.1271336923E+01, 9.8391900273E-01],
	[4.8725000000E+04, 1.3115156053E+02, 1.4486983458E+01, 8.2903036940E+01, 1.1272110249E+01, 9.8392540700E-01],
	[4.8730000000E+04, 1.3117558881E+02, 1.4487116896E+01, 8.2930895163E+01, 1.1272883395E+01, 9.8393180833E-01],
	[4.8735000000E+04, 1.3119961902E+02, 1.4487250322E+01, 8.2958759884E+01, 1.1273656362E+01, 9.8393820673E-01],
	[4.8740000000E+04, 1.3122365116E+02, 1.4487383735E+01, 8.2986631105E+01, 1.1274429149E+01, 9.8394460219E-01],
	[4.8745000000E+04, 1.3124768524E+02, 1.4487517136E+01, 8.3014508826E+01, 1.1275201757E+01, 9.8395099472E-01],
	[4.8750000000E+04, 1.3127172126E+02, 1.4487650524E+01, 8.3042393048E+01, 1.1275974185E+01, 9.8395738432E-01],
	[4.8755000000E+04, 1.3129575922E+02, 1.4487783900E+01, 8.3070283772E+01, 1.1276746434E+01, 9.8396377098E-01],
	[4.8760000000E+04, 1.3131979911E+02, 1.4487917263E+01, 8.3098180998E+01, 1.1277518503E+01, 9.8397015472E-01],
	[4.8765000000E+04, 1.3134384093E+02, 1.4488050614E+01, 8.3126084729E+01, 1.1278290393E+01, 9.8397653553E-01],
	[4.8770000000E+04, 1.3136788470E+02, 1.4488183953E+01, 8.3153994963E+01, 1.1279062104E+01, 9.8398291342E-01],
	[4.8775000000E+04, 1.3139193039E+02, 1.4488317279E+01, 8.3181911703E+01, 1.1279833636E+01, 9.8398928838E-01],
	[4.8780000000E+04, 1.3141597803E+02, 1.4488450592E+01, 8.3209834949E+01, 1.1280604989E+01, 9.8399566041E-01],
	[4.8785000000E+04, 1.3144002760E+02, 1.4488583894E+01, 8.3237764702E+01, 1.1281376163E+01, 9.8400202953E-01],
	[4.8790000000E+04, 1.3146407910E+02, 1.4488717182E+01, 8.3265700962E+01, 1.1282147157E+01, 9.8400839572E-01],
	[4.8795000000E+04, 1.3148813255E+02, 1.4488850459E+01, 8.3293643731E+01, 1.1282917973E+01, 9.8401475900E-01],
	[4.8800000000E+04, 1.3151218792E+02, 1.4488983722E+01, 8.3321593010E+01, 1.1283688610E+01, 9.8402111936E-01],
	[4.8805000000E+04, 1.3153624524E+02, 1.4489116974E+01, 8.3349548799E+01, 1.1284459067E+01, 9.8402747681E-01],
	[4.8810000000E+04, 1.3156030448E+02, 1.4489250213E+01, 8.3377511100E+01, 1.1285229346E+01, 9.8403383134E-01],
	[4.8815000000E+04, 1.3158436567E+02, 1.4489383439E+01, 8.3405479912E+01, 1.1285999447E+01, 9.8404018295E-01],
	[4.8820000000E+04, 1.3160842879E+02, 1.4489516654E+01, 8.3433455237E+01, 1.1286769368E+01, 9.8404653166E-01],
	[4.8825000000E+04, 1.3163249384E+02, 1.4489649855E+01, 8.3461437076E+01, 1.1287539111E+01, 9.8405287746E-01],
	[4.8830000000E+04, 1.3165656083E+02, 1.4489783045E+01, 8.3489425430E+01, 1.1288308675E+01, 9.8405922035E-01],
	[4.8835000000E+04, 1.3168062976E+02, 1.4489916222E+01, 8.3517420298E+01, 1.1289078061E+01, 9.8406556033E-01],
	[4.8840000000E+04, 1.3170470062E+02, 1.4490049386E+01, 8.3545421684E+01, 1.1289847268E+01, 9.8407189741E-01],
	[4.8845000000E+04, 1.3172877341E+02, 1.4490182538E+01, 8.3573429586E+01, 1.1290616296E+01, 9.8407823158E-01],
	[4.8850000000E+04, 1.3175284814E+02, 1.4490315678E+01, 8.3601444006E+01, 1.1291385146E+01, 9.8408456286E-01],
	[4.8855000000E+04, 1.3177692481E+02, 1.4490448805E+01, 8.3629464946E+01, 1.1292153818E+01, 9.8409089123E-01],
	[4.8860000000E+04, 1.3180100341E+02, 1.4490581920E+01, 8.3657492404E+01, 1.1292922311E+01, 9.8409721670E-01],
	[4.8865000000E+04, 1.3182508395E+02, 1.4490715023E+01, 8.3685526384E+01, 1.1293690626E+01, 9.8410353928E-01],
	[4.8870000000E+04, 1.3184916642E+02, 1.4490848113E+01, 8.3713566884E+01, 1.1294458763E+01, 9.8410985895E-01],
	[4.8875000000E+04, 1.3187325083E+02, 1.4490981190E+01, 8.3741613907E+01, 1.1295226721E+01, 9.8411617574E-01],
	[4.8880000000E+04, 1.3189733717E+02, 1.4491114256E+01, 8.3769667453E+01, 1.1295994502E+01, 9.8412248963E-01],
	[4.8885000000E+04, 1.3192142545E+02, 1.4491247309E+01, 8.3797727523E+01, 1.1296762104E+01, 9.8412880063E-01],
	[4.8890000000E+04, 1.3194551566E+02, 1.4491380349E+01, 8.3825794118E+01, 1.1297529528E+01, 9.8413510874E-01],
	[4.8895000000E+04, 1.3196960781E+02, 1.4491513377E+01, 8.3853867238E+01, 1.1298296774E+01, 9.8414141396E-01],
	[4.8900000000E+04, 1.3199370189E+02, 1.4491646393E+01, 8.3881946885E+01, 1.1299063842E+01, 9.8414771629E-01],
	[4.8905000000E+04, 1.3201779790E+02, 1.4491779396E+01, 8.3910033059E+01, 1.1299830733E+01, 9.8415401574E-01],
	[4.8910000000E+04, 1.3204189585E+02, 1.4491912387E+01, 8.3938125761E+01, 1.1300597445E+01, 9.8416031230E-01],
	[4.8915000000E+04, 1.3206599574E+02, 1.4492045366E+01, 8.3966224992E+01, 1.1301363980E+01, 9.8416660598E-01],
	[4.8920000000E+04, 1.3209009756E+02, 1.4492178332E+01, 8.3994330753E+01, 1.1302130336E+01, 9.8417289678E-01],
	[4.8925000000E+04, 1.3211420131E+02, 1.4492311286E+01, 8.4022443045E+01, 1.1302896515E+01, 9.8417918470E-01],
	[4.8930000000E+04, 1.3213830700E+02, 1.4492444228E+01, 8.4050561868E+01, 1.1303662517E+01, 9.8418546974E-01],
	[4.8935000000E+04, 1.3216241463E+02, 1.4492577157E+01, 8.4078687224E+01, 1.1304428341E+01, 9.8419175190E-01],
	[4.8940000000E+04, 1.3218652419E+02, 1.4492710074E+01, 8.4106819113E+01, 1.1305193987E+01, 9.8419803119E-01],
	[4.8945000000E+04, 1.3221063568E+02, 1.4492842978E+01, 8.4134957536E+01, 1.1305959455E+01, 9.8420430761E-01],
	[4.8950000000E+04, 1.3223474911E+02, 1.4492975870E+01, 8.4163102494E+01, 1.1306724746E+01, 9.8421058115E-01],
	[4.8955000000E+04, 1.3225886447E+02, 1.4493108750E+01, 8.4191253988E+01, 1.1307489860E+01, 9.8421685182E-01],
	[4.8960000000E+04, 1.3228298176E+02, 1.4493241617E+01, 8.4219412018E+01, 1.1308254796E+01, 9.8422311962E-01],
	[4.8965000000E+04, 1.3230710099E+02, 1.4493374472E+01, 8.4247576586E+01, 1.1309019555E+01, 9.8422938455E-01],
	[4.8970000000E+04, 1.3233122216E+02, 1.4493507315E+01, 8.4275747692E+01, 1.1309784137E+01, 9.8423564662E-01],
	[4.8975000000E+04, 1.3235534526E+02, 1.4493640145E+01, 8.4303925338E+01, 1.1310548541E+01, 9.8424190582E-01],
	[4.8980000000E+04, 1.3237947029E+02, 1.4493772963E+01, 8.4332109523E+01, 1.1311312768E+01, 9.8424816216E-01],
	[4.8985000000E+04, 1.3240359726E+02, 1.4493905769E+01, 8.4360300250E+01, 1.1312076819E+01, 9.8425441564E-01],
	[4.8990000000E+04, 1.3242772616E+02, 1.4494038562E+01, 8.4388497518E+01, 1.1312840691E+01, 9.8426066625E-01],
	[4.8995000000E+04, 1.3245185699E+02, 1.4494171343E+01, 8.4416701328E+01, 1.1313604387E+01, 9.8426691401E-01],
	[4.9000000000E+04, 1.3247598976E+02, 1.4494304112E+01, 8.4444911683E+01, 1.1314367906E+01, 9.8427315890E-01],
	[4.9005000000E+04, 1.3250012446E+02, 1.4494436868E+01, 8.4473128581E+01, 1.1315131248E+01, 9.8427940095E-01],
	[4.9010000000E+04, 1.3252426110E+02, 1.4494569612E+01, 8.4501352025E+01, 1.1315894413E+01, 9.8428564013E-01],
	[4.9015000000E+04, 1.3254839967E+02, 1.4494702344E+01, 8.4529582014E+01, 1.1316657401E+01, 9.8429187647E-01],
	[4.9020000000E+04, 1.3257254017E+02, 1.4494835063E+01, 8.4557818550E+01, 1.1317420212E+01, 9.8429810995E-01],
	[4.9025000000E+04, 1.3259668261E+02, 1.4494967770E+01, 8.4586061635E+01, 1.1318182847E+01, 9.8430434058E-01],
	[4.9030000000E+04, 1.3262082698E+02, 1.4495100465E+01, 8.4614311267E+01, 1.1318945304E+01, 9.8431056836E-01],
	[4.9035000000E+04, 1.3264497329E+02, 1.4495233147E+01, 8.4642567449E+01, 1.1319707585E+01, 9.8431679330E-01],
	[4.9040000000E+04, 1.3266912153E+02, 1.4495365817E+01, 8.4670830181E+01, 1.1320469690E+01, 9.8432301539E-01],
	[4.9045000000E+04, 1.3269327170E+02, 1.4495498475E+01, 8.4699099465E+01, 1.1321231618E+01, 9.8432923463E-01],
	[4.9050000000E+04, 1.3271742381E+02, 1.4495631120E+01, 8.4727375300E+01, 1.1321993369E+01, 9.8433545103E-01],
	[4.9055000000E+04, 1.3274157785E+02, 1.4495763753E+01, 8.4755657688E+01, 1.1322754944E+01, 9.8434166459E-01],
	[4.9060000000E+04, 1.3276573382E+02, 1.4495896374E+01, 8.4783946629E+01, 1.1323516342E+01, 9.8434787531E-01],
	[4.9065000000E+04, 1.3278989172E+02, 1.4496028983E+01, 8.4812242125E+01, 1.1324277564E+01, 9.8435408319E-01],
	[4.9070000000E+04, 1.3281407254E+02, 1.4496163749E+01, 8.4840544177E+01, 1.1325040087E+01, 9.8436028824E-01],
	[4.9075000000E+04, 1.3283827837E+02, 1.4496300892E+01, 8.4868852784E+01, 1.1325804059E+01, 9.8436649044E-01],
	[4.9080000000E+04, 1.3286248616E+02, 1.4496438022E+01, 8.4897167949E+01, 1.1326567856E+01, 9.8437268982E-01],
	[4.9085000000E+04, 1.3288669589E+02, 1.4496575139E+01, 8.4925489671E+01, 1.1327331476E+01, 9.8437888636E-01],
	[4.9090000000E+04, 1.3291090756E+02, 1.4496712243E+01, 8.4953817953E+01, 1.1328094921E+01, 9.8438508007E-01],
	[4.9095000000E+04, 1.3293512118E+02, 1.4496849335E+01, 8.4982152793E+01, 1.1328858191E+01, 9.8439127095E-01],
	[4.9100000000E+04, 1.3295933674E+02, 1.4496986415E+01, 8.5010494195E+01, 1.1329621284E+01, 9.8439745900E-01],
	[4.9105000000E+04, 1.3298355425E+02, 1.4497123481E+01, 8.5038842157E+01, 1.1330384202E+01, 9.8440364422E-01],
	[4.9110000000E+04, 1.3300777370E+02, 1.4497260535E+01, 8.5067196682E+01, 1.1331146944E+01, 9.8440982662E-01],
	[4.9115000000E+04, 1.3303199510E+02, 1.4497397577E+01, 8.5095557769E+01, 1.1331909511E+01, 9.8441600619E-01],
	[4.9120000000E+04, 1.3305621844E+02, 1.4497534605E+01, 8.5123925421E+01, 1.1332671902E+01, 9.8442218295E-01],
	[4.9125000000E+04, 1.3308044373E+02, 1.4497671621E+01, 8.5152299637E+01, 1.1333434117E+01, 9.8442835688E-01],
	[4.9130000000E+04, 1.3310467096E+02, 1.4497808625E+01, 8.5180680418E+01, 1.1334196157E+01, 9.8443452799E-01],
	[4.9135000000E+04, 1.3312890013E+02, 1.4497945615E+01, 8.5209067766E+01, 1.1334958022E+01, 9.8444069628E-01],
	[4.9140000000E+04, 1.3315313125E+02, 1.4498082594E+01, 8.5237461681E+01, 1.1335719712E+01, 9.8444686176E-01],
	[4.9145000000E+04, 1.3317736432E+02, 1.4498219559E+01, 8.5265862164E+01, 1.1336481226E+01, 9.8445302442E-01],
	[4.9150000000E+04, 1.3320159933E+02, 1.4498356512E+01, 8.5294269217E+01, 1.1337242565E+01, 9.8445918426E-01],
	[4.9155000000E+04, 1.3322583628E+02, 1.4498493452E+01, 8.5322682839E+01, 1.1338003728E+01, 9.8446534130E-01],
	[4.9160000000E+04, 1.3325007517E+02, 1.4498630379E+01, 8.5351103031E+01, 1.1338764717E+01, 9.8447149552E-01],
	[4.9165000000E+04, 1.3327431601E+02, 1.4498767294E+01, 8.5379529795E+01, 1.1339525531E+01, 9.8447764694E-01],
	[4.9170000000E+04, 1.3329855880E+02, 1.4498904197E+01, 8.5407963131E+01, 1.1340286169E+01, 9.8448379554E-01],
	[4.9175000000E+04, 1.3332280353E+02, 1.4499041086E+01, 8.5436403041E+01, 1.1341046632E+01, 9.8448994134E-01],
	[4.9180000000E+04, 1.3334705020E+02, 1.4499177963E+01, 8.5464849524E+01, 1.1341806921E+01, 9.8449608434E-01],
	[4.9185000000E+04, 1.3337129882E+02, 1.4499314828E+01, 8.5493302583E+01, 1.1342567034E+01, 9.8450222453E-01],
	[4.9190000000E+04, 1.3339554938E+02, 1.4499451679E+01, 8.5521762217E+01, 1.1343326973E+01, 9.8450836191E-01],
	[4.9195000000E+04, 1.3341980188E+02, 1.4499588518E+01, 8.5550228427E+01, 1.1344086737E+01, 9.8451449650E-01],
	[4.9200000000E+04, 1.3344405633E+02, 1.4499725345E+01, 8.5578701216E+01, 1.1344846326E+01, 9.8452062829E-01],
	[4.9205000000E+04, 1.3346831272E+02, 1.4499862159E+01, 8.5607180582E+01, 1.1345605741E+01, 9.8452675728E-01],
	[4.9210000000E+04, 1.3349257106E+02, 1.4499998960E+01, 8.5635666527E+01, 1.1346364980E+01, 9.8453288347E-01],
	[4.9215000000E+04, 1.3351683133E+02, 1.4500135749E+01, 8.5664159053E+01, 1.1347124045E+01, 9.8453900687E-01],
	[4.9220000000E+04, 1.3354109356E+02, 1.4500272525E+01, 8.5692658159E+01, 1.1347882936E+01, 9.8454512748E-01],
	[4.9225000000E+04, 1.3356535772E+02, 1.4500409288E+01, 8.5721163847E+01, 1.1348641652E+01, 9.8455124529E-01],
	[4.9230000000E+04, 1.3358962383E+02, 1.4500546039E+01, 8.5749676117E+01, 1.1349400193E+01, 9.8455736031E-01],
	[4.9235000000E+04, 1.3361389189E+02, 1.4500682777E+01, 8.5778194971E+01, 1.1350158560E+01, 9.8456347255E-01],
	[4.9240000000E+04, 1.3363816189E+02, 1.4500819503E+01, 8.5806720409E+01, 1.1350916753E+01, 9.8456958199E-01],
	[4.9245000000E+04, 1.3366243383E+02, 1.4500956216E+01, 8.5835252432E+01, 1.1351674771E+01, 9.8457568865E-01],
	[4.9250000000E+04, 1.3368670771E+02, 1.4501092917E+01, 8.5863791041E+01, 1.1352432615E+01, 9.8458179252E-01],
	[4.9255000000E+04, 1.3371098354E+02, 1.4501229605E+01, 8.5892336237E+01, 1.1353190285E+01, 9.8458789361E-01],
	[4.9260000000E+04, 1.3373526131E+02, 1.4501366280E+01, 8.5920888020E+01, 1.1353947781E+01, 9.8459399192E-01],
	[4.9265000000E+04, 1.3375954102E+02, 1.4501502943E+01, 8.5949446392E+01, 1.1354705102E+01, 9.8460008745E-01],
	[4.9270000000E+04, 1.3378382268E+02, 1.4501639593E+01, 8.5978011353E+01, 1.1355462249E+01, 9.8460618020E-01],
	[4.9275000000E+04, 1.3380810628E+02, 1.4501776230E+01, 8.6006582905E+01, 1.1356219223E+01, 9.8461227017E-01],
	[4.9280000000E+04, 1.3383239182E+02, 1.4501912855E+01, 8.6035161047E+01, 1.1356976022E+01, 9.8461835737E-01],
	[4.9285000000E+04, 1.3385667931E+02, 1.4502049468E+01, 8.6063745781E+01, 1.1357732647E+01, 9.8462444179E-01],
	[4.9290000000E+04, 1.3388096874E+02, 1.4502186068E+01, 8.6092337108E+01, 1.1358489099E+01, 9.8463052343E-01],
	[4.9295000000E+04, 1.3390526011E+02, 1.4502322655E+01, 8.6120935029E+01, 1.1359245376E+01, 9.8463660231E-01],
	[4.9300000000E+04, 1.3392955343E+02, 1.4502459230E+01, 8.6149539544E+01, 1.1360001480E+01, 9.8464267841E-01],
	[4.9305000000E+04, 1.3395384869E+02, 1.4502595792E+01, 8.6178150654E+01, 1.1360757409E+01, 9.8464875175E-01],
	[4.9310000000E+04, 1.3397814589E+02, 1.4502732341E+01, 8.6206768360E+01, 1.1361513166E+01, 9.8465482232E-01],
	[4.9315000000E+04, 1.3400244504E+02, 1.4502868878E+01, 8.6235392664E+01, 1.1362268748E+01, 9.8466089012E-01],
	[4.9320000000E+04, 1.3402674612E+02, 1.4503005403E+01, 8.6264023565E+01, 1.1363024157E+01, 9.8466695516E-01],
	[4.9325000000E+04, 1.3405104915E+02, 1.4503141915E+01, 8.6292661065E+01, 1.1363779392E+01, 9.8467301743E-01],
	[4.9330000000E+04, 1.3407535413E+02, 1.4503278414E+01, 8.6321305164E+01, 1.1364534454E+01, 9.8467907694E-01],
	[4.9335000000E+04, 1.3409966104E+02, 1.4503414901E+01, 8.6349955864E+01, 1.1365289342E+01, 9.8468513369E-01],
	[4.9340000000E+04, 1.3412396990E+02, 1.4503551375E+01, 8.6378613165E+01, 1.1366044056E+01, 9.8469118769E-01],
	[4.9345000000E+04, 1.3414828070E+02, 1.4503687837E+01, 8.6407277068E+01, 1.1366798598E+01, 9.8469723892E-01],
	[4.9350000000E+04, 1.3417259345E+02, 1.4503824286E+01, 8.6435947574E+01, 1.1367552966E+01, 9.8470328740E-01],
	[4.9355000000E+04, 1.3419690813E+02, 1.4503960723E+01, 8.6464624683E+01, 1.1368307160E+01, 9.8470933312E-01],
	[4.9360000000E+04, 1.3422122476E+02, 1.4504097147E+01, 8.6493308398E+01, 1.1369061182E+01, 9.8471537609E-01],
	[4.9365000000E+04, 1.3424554333E+02, 1.4504233558E+01, 8.6521998718E+01, 1.1369815030E+01, 9.8472141631E-01],
	[4.9370000000E+04, 1.3426986385E+02, 1.4504369957E+01, 8.6550695644E+01, 1.1370568705E+01, 9.8472745378E-01],
	[4.9375000000E+04, 1.3429418630E+02, 1.4504506344E+01, 8.6579399177E+01, 1.1371322206E+01, 9.8473348850E-01],
	[4.9380000000E+04, 1.3431851070E+02, 1.4504642718E+01, 8.6608109319E+01, 1.1372075535E+01, 9.8473952047E-01],
	[4.9385000000E+04, 1.3434283704E+02, 1.4504779079E+01, 8.6636826069E+01, 1.1372828691E+01, 9.8474554970E-01],
	[4.9390000000E+04, 1.3436716533E+02, 1.4504915428E+01, 8.6665549429E+01, 1.1373581674E+01, 9.8475157618E-01],
	[4.9395000000E+04, 1.3439149555E+02, 1.4505051765E+01, 8.6694279399E+01, 1.1374334483E+01, 9.8475759992E-01],
	[4.9400000000E+04, 1.3441582772E+02, 1.4505188089E+01, 8.6723015981E+01, 1.1375087120E+01, 9.8476362092E-01],
	[4.9405000000E+04, 1.3444016183E+02, 1.4505324400E+01, 8.6751759176E+01, 1.1375839584E+01, 9.8476963917E-01],
	[4.9410000000E+04, 1.3446449788E+02, 1.4505460699E+01, 8.6780508983E+01, 1.1376591876E+01, 9.8477565469E-01],
	[4.9415000000E+04, 1.3448883587E+02, 1.4505596985E+01, 8.6809265405E+01, 1.1377343994E+01, 9.8478166747E-01],
	[4.9420000000E+04, 1.3451317581E+02, 1.4505733259E+01, 8.6838028441E+01, 1.1378095940E+01, 9.8478767751E-01],
	[4.9425000000E+04, 1.3453751769E+02, 1.4505869520E+01, 8.6866798093E+01, 1.1378847713E+01, 9.8479368482E-01],
	[4.9430000000E+04, 1.3456186151E+02, 1.4506005769E+01, 8.6895574361E+01, 1.1379599313E+01, 9.8479968940E-01],
	[4.9435000000E+04, 1.3458620727E+02, 1.4506142005E+01, 8.6924357247E+01, 1.1380350741E+01, 9.8480569124E-01],
	[4.9440000000E+04, 1.3461055497E+02, 1.4506278229E+01, 8.6953146752E+01, 1.1381101997E+01, 9.8481169036E-01],
	[4.9445000000E+04, 1.3463490462E+02, 1.4506414441E+01, 8.6981942875E+01, 1.1381853080E+01, 9.8481768674E-01],
	[4.9450000000E+04, 1.3465925620E+02, 1.4506550639E+01, 8.7010745618E+01, 1.1382603990E+01, 9.8482368040E-01],
	[4.9455000000E+04, 1.3468360973E+02, 1.4506686826E+01, 8.7039554982E+01, 1.1383354729E+01, 9.8482967133E-01],
	[4.9460000000E+04, 1.3470796520E+02, 1.4506823000E+01, 8.7068370968E+01, 1.1384105294E+01, 9.8483565953E-01],
	[4.9465000000E+04, 1.3473232261E+02, 1.4506959161E+01, 8.7097193576E+01, 1.1384855688E+01, 9.8484164502E-01],
	[4.9470000000E+04, 1.3475668197E+02, 1.4507095310E+01, 8.7126022807E+01, 1.1385605909E+01, 9.8484762778E-01],
	[4.9475000000E+04, 1.3478104326E+02, 1.4507231446E+01, 8.7154858663E+01, 1.1386355958E+01, 9.8485360782E-01],
	[4.9480000000E+04, 1.3480540650E+02, 1.4507367570E+01, 8.7183701144E+01, 1.1387105835E+01, 9.8485958514E-01],
	[4.9485000000E+04, 1.3482977168E+02, 1.4507503681E+01, 8.7212550250E+01, 1.1387855540E+01, 9.8486555974E-01],
	[4.9490000000E+04, 1.3485413880E+02, 1.4507639780E+01, 8.7241405984E+01, 1.1388605073E+01, 9.8487153163E-01],
	[4.9495000000E+04, 1.3487850786E+02, 1.4507775867E+01, 8.7270268345E+01, 1.1389354434E+01, 9.8487750080E-01],
	[4.9500000000E+04, 1.3490287886E+02, 1.4507911941E+01, 8.7299137334E+01, 1.1390103623E+01, 9.8488346726E-01],
	[4.9505000000E+04, 1.3492725180E+02, 1.4508048002E+01, 8.7328012953E+01, 1.1390852640E+01, 9.8488943101E-01],
	[4.9510000000E+04, 1.3495162669E+02, 1.4508184052E+01, 8.7356895202E+01, 1.1391601485E+01, 9.8489539205E-01],
	[4.9515000000E+04, 1.3497600351E+02, 1.4508320088E+01, 8.7385784082E+01, 1.1392350158E+01, 9.8490135038E-01],
	[4.9520000000E+04, 1.3500038228E+02, 1.4508456112E+01, 8.7414679594E+01, 1.1393098659E+01, 9.8490730600E-01],
	[4.9525000000E+04, 1.3502476299E+02, 1.4508592124E+01, 8.7443581739E+01, 1.1393846989E+01, 9.8491325891E-01],
	[4.9530000000E+04, 1.3504914564E+02, 1.4508728123E+01, 8.7472490517E+01, 1.1394595147E+01, 9.8491920912E-01],
	[4.9535000000E+04, 1.3507353023E+02, 1.4508864110E+01, 8.7501405929E+01, 1.1395343134E+01, 9.8492515663E-01],
	[4.9540000000E+04, 1.3509791676E+02, 1.4509000084E+01, 8.7530327977E+01, 1.1396090948E+01, 9.8493110143E-01],
	[4.9545000000E+04, 1.3512230523E+02, 1.4509136046E+01, 8.7559256661E+01, 1.1396838592E+01, 9.8493704353E-01],
	[4.9550000000E+04, 1.3514669565E+02, 1.4509271996E+01, 8.7588191982E+01, 1.1397586063E+01, 9.8494298294E-01],
	[4.9555000000E+04, 1.3517108800E+02, 1.4509407933E+01, 8.7617133941E+01, 1.1398333364E+01, 9.8494891964E-01],
	[4.9560000000E+04, 1.3519548230E+02, 1.4509543857E+01, 8.7646082538E+01, 1.1399080493E+01, 9.8495485365E-01],
	[4.9565000000E+04, 1.3521987853E+02, 1.4509679769E+01, 8.7675037775E+01, 1.1399827450E+01, 9.8496078497E-01],
	[4.9570000000E+04, 1.3524427671E+02, 1.4509815669E+01, 8.7703999652E+01, 1.1400574237E+01, 9.8496671359E-01],
	[4.9575000000E+04, 1.3526867683E+02, 1.4509951556E+01, 8.7732968171E+01, 1.1401320852E+01, 9.8497263952E-01],
	[4.9580000000E+04, 1.3529307888E+02, 1.4510087431E+01, 8.7761943332E+01, 1.1402067296E+01, 9.8497856275E-01],
	[4.9585000000E+04, 1.3531748288E+02, 1.4510223293E+01, 8.7790925135E+01, 1.1402813568E+01, 9.8498448330E-01],
	[4.9590000000E+04, 1.3534188882E+02, 1.4510359143E+01, 8.7819913583E+01, 1.1403559670E+01, 9.8499040116E-01],
	[4.9595000000E+04, 1.3536629670E+02, 1.4510494981E+01, 8.7848908675E+01, 1.1404305600E+01, 9.8499631634E-01],
	[4.9600000000E+04, 1.3539070652E+02, 1.4510630806E+01, 8.7877910412E+01, 1.1405051360E+01, 9.8500222883E-01],
	[4.9605000000E+04, 1.3541511828E+02, 1.4510766619E+01, 8.7906918796E+01, 1.1405796948E+01, 9.8500813863E-01],
	[4.9610000000E+04, 1.3543953198E+02, 1.4510902419E+01, 8.7935933827E+01, 1.1406542365E+01, 9.8501404575E-01],
	[4.9615000000E+04, 1.3546394762E+02, 1.4511038207E+01, 8.7964955506E+01, 1.1407287612E+01, 9.8501995020E-01],
	[4.9620000000E+04, 1.3548836521E+02, 1.4511173982E+01, 8.7993983834E+01, 1.1408032688E+01, 9.8502585196E-01],
	[4.9625000000E+04, 1.3551278473E+02, 1.4511309745E+01, 8.8023018812E+01, 1.1408777593E+01, 9.8503175104E-01],
	[4.9630000000E+04, 1.3553720619E+02, 1.4511445496E+01, 8.8052060440E+01, 1.1409522327E+01, 9.8503764745E-01],
	[4.9635000000E+04, 1.3556162959E+02, 1.4511581234E+01, 8.8081108720E+01, 1.1410266890E+01, 9.8504354118E-01],
	[4.9640000000E+04, 1.3558605494E+02, 1.4511716960E+01, 8.8110163652E+01, 1.1411011283E+01, 9.8504943224E-01],
	[4.9645000000E+04, 1.3561048222E+02, 1.4511852673E+01, 8.8139225238E+01, 1.1411755505E+01, 9.8505532063E-01],
	[4.9650000000E+04, 1.3563491144E+02, 1.4511988374E+01, 8.8168293477E+01, 1.1412499557E+01, 9.8506120634E-01],
	[4.9655000000E+04, 1.3565934261E+02, 1.4512124063E+01, 8.8197368371E+01, 1.1413243438E+01, 9.8506708939E-01],
	[4.9660000000E+04, 1.3568377571E+02, 1.4512259739E+01, 8.8226449921E+01, 1.1413987149E+01, 9.8507296977E-01],
	[4.9665000000E+04, 1.3570821075E+02, 1.4512395403E+01, 8.8255538127E+01, 1.1414730689E+01, 9.8507884748E-01],
	[4.9670000000E+04, 1.3573264774E+02, 1.4512531054E+01, 8.8284632991E+01, 1.1415474059E+01, 9.8508472252E-01],
	[4.9675000000E+04, 1.3575708666E+02, 1.4512666694E+01, 8.8313734513E+01, 1.1416217258E+01, 9.8509059490E-01],
	[4.9680000000E+04, 1.3578152752E+02, 1.4512802320E+01, 8.8342842695E+01, 1.1416960288E+01, 9.8509646462E-01],
	[4.9685000000E+04, 1.3580597032E+02, 1.4512937935E+01, 8.8371957536E+01, 1.1417703147E+01, 9.8510233167E-01],
	[4.9690000000E+04, 1.3583041507E+02, 1.4513073536E+01, 8.8401079038E+01, 1.1418445835E+01, 9.8510819607E-01],
	[4.9695000000E+04, 1.3585486175E+02, 1.4513209126E+01, 8.8430207202E+01, 1.1419188354E+01, 9.8511405781E-01],
	[4.9700000000E+04, 1.3587931037E+02, 1.4513344703E+01, 8.8459342028E+01, 1.1419930703E+01, 9.8511991689E-01],
	[4.9705000000E+04, 1.3590376093E+02, 1.4513480268E+01, 8.8488483518E+01, 1.1420672881E+01, 9.8512577331E-01],
	[4.9710000000E+04, 1.3592821343E+02, 1.4513615820E+01, 8.8517631672E+01, 1.1421414889E+01, 9.8513162708E-01],
	[4.9715000000E+04, 1.3595266787E+02, 1.4513751360E+01, 8.8546786491E+01, 1.1422156728E+01, 9.8513747820E-01],
	[4.9720000000E+04, 1.3597712426E+02, 1.4513886888E+01, 8.8575947975E+01, 1.1422898396E+01, 9.8514332667E-01],
	[4.9725000000E+04, 1.3600158257E+02, 1.4514022403E+01, 8.8605116127E+01, 1.1423639895E+01, 9.8514917248E-01],
	[4.9730000000E+04, 1.3602604283E+02, 1.4514157906E+01, 8.8634290947E+01, 1.1424381224E+01, 9.8515501565E-01],
	[4.9735000000E+04, 1.3605050503E+02, 1.4514293397E+01, 8.8663472435E+01, 1.1425122383E+01, 9.8516085617E-01],
	[4.9740000000E+04, 1.3607496917E+02, 1.4514428875E+01, 8.8692660592E+01, 1.1425863372E+01, 9.8516669404E-01],
	[4.9745000000E+04, 1.3609943525E+02, 1.4514564341E+01, 8.8721855419E+01, 1.1426604192E+01, 9.8517252927E-01],
	[4.9750000000E+04, 1.3612390326E+02, 1.4514699795E+01, 8.8751056918E+01, 1.1427344842E+01, 9.8517836186E-01],
	[4.9755000000E+04, 1.3614837322E+02, 1.4514835236E+01, 8.8780265088E+01, 1.1428085322E+01, 9.8518419180E-01],
	[4.9760000000E+04, 1.3617284511E+02, 1.4514970665E+01, 8.8809479931E+01, 1.1428825633E+01, 9.8519001911E-01],
	[4.9765000000E+04, 1.3619731895E+02, 1.4515106081E+01, 8.8838701448E+01, 1.1429565774E+01, 9.8519584377E-01],
	[4.9770000000E+04, 1.3622179472E+02, 1.4515241485E+01, 8.8867929639E+01, 1.1430305746E+01, 9.8520166580E-01],
	[4.9775000000E+04, 1.3624627243E+02, 1.4515376877E+01, 8.8897164506E+01, 1.1431045549E+01, 9.8520748519E-01],
	[4.9780000000E+04, 1.3627075209E+02, 1.4515512257E+01, 8.8926406049E+01, 1.1431785182E+01, 9.8521330194E-01],
	[4.9785000000E+04, 1.3629523368E+02, 1.4515647624E+01, 8.8955654269E+01, 1.1432524646E+01, 9.8521911607E-01],
	[4.9790000000E+04, 1.3631971721E+02, 1.4515782978E+01, 8.8984909166E+01, 1.1433263940E+01, 9.8522492756E-01],
	[4.9795000000E+04, 1.3634420267E+02, 1.4515918321E+01, 8.9014170743E+01, 1.1434003065E+01, 9.8523073641E-01],
	[4.9800000000E+04, 1.3636869008E+02, 1.4516053651E+01, 8.9043438999E+01, 1.1434742021E+01, 9.8523654264E-01],
	[4.9805000000E+04, 1.3639317943E+02, 1.4516188969E+01, 8.9072713935E+01, 1.1435480808E+01, 9.8524234625E-01],
	[4.9810000000E+04, 1.3641767071E+02, 1.4516324274E+01, 8.9101995553E+01, 1.1436219426E+01, 9.8524814722E-01],
	[4.9815000000E+04, 1.3644216393E+02, 1.4516459568E+01, 8.9131283853E+01, 1.1436957875E+01, 9.8525394557E-01],
	[4.9820000000E+04, 1.3646665910E+02, 1.4516594849E+01, 8.9160578836E+01, 1.1437696155E+01, 9.8525974130E-01],
	[4.9825000000E+04, 1.3649115620E+02, 1.4516730117E+01, 8.9189880502E+01, 1.1438434266E+01, 9.8526553440E-01],
	[4.9830000000E+04, 1.3651565524E+02, 1.4516865373E+01, 8.9219188854E+01, 1.1439172207E+01, 9.8527132488E-01],
	[4.9835000000E+04, 1.3654015621E+02, 1.4517000617E+01, 8.9248503891E+01, 1.1439909981E+01, 9.8527711275E-01],
	[4.9840000000E+04, 1.3656465913E+02, 1.4517135849E+01, 8.9277825614E+01, 1.1440647585E+01, 9.8528289799E-01],
	[4.9845000000E+04, 1.3658916399E+02, 1.4517271068E+01, 8.9307154025E+01, 1.1441385020E+01, 9.8528868062E-01],
	[4.9850000000E+04, 1.3661367078E+02, 1.4517406275E+01, 8.9336489123E+01, 1.1442122287E+01, 9.8529446063E-01],
	[4.9855000000E+04, 1.3663817951E+02, 1.4517541470E+01, 8.9365830911E+01, 1.1442859385E+01, 9.8530023803E-01],
	[4.9860000000E+04, 1.3666271179E+02, 1.4517678845E+01, 8.9395179389E+01, 1.1443597829E+01, 9.8530601281E-01],
	[4.9865000000E+04, 1.3668726838E+02, 1.4517818476E+01, 8.9424534557E+01, 1.1444337670E+01, 9.8531178499E-01],
	[4.9870000000E+04, 1.3671182691E+02, 1.4517958094E+01, 8.9453896417E+01, 1.1445077343E+01, 9.8531755455E-01],
	[4.9875000000E+04, 1.3673638740E+02, 1.4518097700E+01, 8.9483264969E+01, 1.1445816848E+01, 9.8532332150E-01],
	[4.9880000000E+04, 1.3676094983E+02, 1.4518237293E+01, 8.9512640214E+01, 1.1446556184E+01, 9.8532908585E-01],
	[4.9885000000E+04, 1.3678551421E+02, 1.4518376873E+01, 8.9542022154E+01, 1.1447295353E+01, 9.8533484759E-01],
	[4.9890000000E+04, 1.3681008054E+02, 1.4518516441E+01, 8.9571410788E+01, 1.1448034353E+01, 9.8534060673E-01],
	[4.9895000000E+04, 1.3683464882E+02, 1.4518655995E+01, 8.9600806118E+01, 1.1448773186E+01, 9.8534636326E-01],
	[4.9900000000E+04, 1.3685921906E+02, 1.4518795538E+01, 8.9630208145E+01, 1.1449511850E+01, 9.8535211720E-01],
	[4.9905000000E+04, 1.3688379124E+02, 1.4518935067E+01, 8.9659616869E+01, 1.1450250347E+01, 9.8535786853E-01],
	[4.9910000000E+04, 1.3690836537E+02, 1.4519074584E+01, 8.9689032292E+01, 1.1450988676E+01, 9.8536361726E-01],
	[4.9915000000E+04, 1.3693294144E+02, 1.4519214089E+01, 8.9718454414E+01, 1.1451726837E+01, 9.8536936339E-01],
	[4.9920000000E+04, 1.3695751947E+02, 1.4519353581E+01, 8.9747883236E+01, 1.1452464830E+01, 9.8537510693E-01],
	[4.9925000000E+04, 1.3698209945E+02, 1.4519493060E+01, 8.9777318759E+01, 1.1453202656E+01, 9.8538084787E-01],
	[4.9930000000E+04, 1.3700668138E+02, 1.4519632526E+01, 8.9806760983E+01, 1.1453940314E+01, 9.8538658622E-01],
	[4.9935000000E+04, 1.3703126525E+02, 1.4519771980E+01, 8.9836209910E+01, 1.1454677804E+01, 9.8539232198E-01],
	[4.9940000000E+04, 1.3705585108E+02, 1.4519911421E+01, 8.9865665541E+01, 1.1455415127E+01, 9.8539805514E-01],
	[4.9945000000E+04, 1.3708043885E+02, 1.4520050850E+01, 8.9895127876E+01, 1.1456152282E+01, 9.8540378572E-01],
	[4.9950000000E+04, 1.3710502857E+02, 1.4520190266E+01, 8.9924596916E+01, 1.1456889269E+01, 9.8540951370E-01],
	[4.9955000000E+04, 1.3712962025E+02, 1.4520329669E+01, 8.9954072663E+01, 1.1457626089E+01, 9.8541523910E-01],
	[4.9960000000E+04, 1.3715421387E+02, 1.4520469060E+01, 8.9983555116E+01, 1.1458362742E+01, 9.8542096191E-01],
	[4.9965000000E+04, 1.3717880944E+02, 1.4520608438E+01, 9.0013044277E+01, 1.1459099228E+01, 9.8542668213E-01],
	[4.9970000000E+04, 1.3720340695E+02, 1.4520747804E+01, 9.0042540146E+01, 1.1459835546E+01, 9.8543239977E-01],
	[4.9975000000E+04, 1.3722800642E+02, 1.4520887157E+01, 9.0072042725E+01, 1.1460571697E+01, 9.8543811483E-01],
	[4.9980000000E+04, 1.3725260784E+02, 1.4521026497E+01, 9.0101552014E+01, 1.1461307680E+01, 9.8544382731E-01],
	[4.9985000000E+04, 1.3727721120E+02, 1.4521165825E+01, 9.0131068015E+01, 1.1462043497E+01, 9.8544953720E-01],
	[4.9990000000E+04, 1.3730181652E+02, 1.4521305140E+01, 9.0160590727E+01, 1.1462779146E+01, 9.8545524452E-01],
	[4.9995000000E+04, 1.3732642378E+02, 1.4521444442E+01, 9.0190120152E+01, 1.1463514628E+01, 9.8546094926E-01],
	[5.0000000000E+04, 1.3735103299E+02, 1.4521583732E+01, 9.0219656291E+01, 1.1464249944E+01, 9.8546665142E-01],
	[5.0005000000E+04, 1.3737564415E+02, 1.4521723009E+01, 9.0249231723E+01, 1.1464985618E+01, 9.8547235100E-01],
	[5.0010000000E+04, 1.3740025726E+02, 1.4521862274E+01, 9.0278813890E+01, 1.1465721124E+01, 9.8547804801E-01],
	[5.0015000000E+04, 1.3742487231E+02, 1.4522001526E+01, 9.0308402791E+01, 1.1466456464E+01, 9.8548374245E-01],
	[5.0020000000E+04, 1.3744948932E+02, 1.4522140766E+01, 9.0337998428E+01, 1.1467191636E+01, 9.8548943432E-01],
	[5.0025000000E+04, 1.3747410827E+0