import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

blood_ICRP110_MFP = np.array([
	[5.0000000000E+03, 1.7561766886E+00, 7.9792300288E+00, 2.2668251432E-02, 2.2316792406E-02, 3.4413433452E-01],
	[5.0050000000E+03, 1.7581836431E+00, 7.9743983043E+00, 2.2736532952E-02, 2.2383257516E-02, 3.4439181931E-01],
	[5.0100000000E+03, 1.7601908837E+00, 7.9695743257E+00, 2.2804951446E-02, 2.2449851913E-02, 3.4464900858E-01],
	[5.0150000000E+03, 1.7621984102E+00, 7.9647580729E+00, 2.2873507049E-02, 2.2516575710E-02, 3.4490590299E-01],
	[5.0200000000E+03, 1.7642062224E+00, 7.9599495258E+00, 2.2942199899E-02, 2.2583429018E-02, 3.4516250319E-01],
	[5.0250000000E+03, 1.7662143200E+00, 7.9551486644E+00, 2.3011030133E-02, 2.2650411948E-02, 3.4541880986E-01],
	[5.0300000000E+03, 1.7682227028E+00, 7.9503554688E+00, 2.3079997888E-02, 2.2717524611E-02, 3.4567482364E-01],
	[5.0350000000E+03, 1.7702313705E+00, 7.9455699192E+00, 2.3149103301E-02, 2.2784767118E-02, 3.4593054519E-01],
	[5.0400000000E+03, 1.7722403229E+00, 7.9407919958E+00, 2.3218346509E-02, 2.2852139580E-02, 3.4618597517E-01],
	[5.0450000000E+03, 1.7742495598E+00, 7.9360216789E+00, 2.3287727648E-02, 2.2919642109E-02, 3.4644111422E-01],
	[5.0500000000E+03, 1.7762590809E+00, 7.9312589489E+00, 2.3357246855E-02, 2.2987274816E-02, 3.4669596299E-01],
	[5.0550000000E+03, 1.7782688860E+00, 7.9265037862E+00, 2.3426904268E-02, 2.3055037810E-02, 3.4695052212E-01],
	[5.0600000000E+03, 1.7802789748E+00, 7.9217561713E+00, 2.3496700024E-02, 2.3122931204E-02, 3.4720479227E-01],
	[5.0650000000E+03, 1.7822893471E+00, 7.9170160848E+00, 2.3566634259E-02, 2.3190955108E-02, 3.4745877406E-01],
	[5.0700000000E+03, 1.7843000026E+00, 7.9122835074E+00, 2.3636707110E-02, 2.3259109632E-02, 3.4771246814E-01],
	[5.0750000000E+03, 1.7863109412E+00, 7.9075584197E+00, 2.3706918714E-02, 2.3327394887E-02, 3.4796587515E-01],
	[5.0800000000E+03, 1.7883221625E+00, 7.9028408025E+00, 2.3777269209E-02, 2.3395810984E-02, 3.4821899571E-01],
	[5.0850000000E+03, 1.7903469451E+00, 7.8982099019E+00, 2.3847758730E-02, 2.3464361013E-02, 3.4847183047E-01],
	[5.0900000000E+03, 1.7923733167E+00, 7.8935939479E+00, 2.3918387415E-02, 2.3533042424E-02, 3.4872438005E-01],
	[5.0950000000E+03, 1.7943999888E+00, 7.8889852197E+00, 2.3989155402E-02, 2.3601855038E-02, 3.4897664508E-01],
	[5.1000000000E+03, 1.7964269612E+00, 7.8843836989E+00, 2.4060062826E-02, 2.3670798966E-02, 3.4922862619E-01],
	[5.1050000000E+03, 1.7984542337E+00, 7.8797893673E+00, 2.4131109824E-02, 2.3739874319E-02, 3.4948032399E-01],
	[5.1100000000E+03, 1.8004818060E+00, 7.8752022066E+00, 2.4202296535E-02, 2.3809081206E-02, 3.4973173911E-01],
	[5.1150000000E+03, 1.8025096779E+00, 7.8706221986E+00, 2.4273623094E-02, 2.3878419738E-02, 3.4998287218E-01],
	[5.1200000000E+03, 1.8045378491E+00, 7.8660493251E+00, 2.4345089638E-02, 2.3947890025E-02, 3.5023372380E-01],
	[5.1250000000E+03, 1.8065663194E+00, 7.8614835681E+00, 2.4416696305E-02, 2.4017492178E-02, 3.5048429459E-01],
	[5.1300000000E+03, 1.8085950885E+00, 7.8569249096E+00, 2.4488443230E-02, 2.4087226306E-02, 3.5073458517E-01],
	[5.1350000000E+03, 1.8106241562E+00, 7.8523733317E+00, 2.4560330552E-02, 2.4157092520E-02, 3.5098459615E-01],
	[5.1400000000E+03, 1.8126535222E+00, 7.8478288164E+00, 2.4632358407E-02, 2.4227090929E-02, 3.5123432813E-01],
	[5.1450000000E+03, 1.8146831863E+00, 7.8432913461E+00, 2.4704526932E-02, 2.4297221643E-02, 3.5148378173E-01],
	[5.1500000000E+03, 1.8167131483E+00, 7.8387609028E+00, 2.4776836264E-02, 2.4367484772E-02, 3.5173295754E-01],
	[5.1550000000E+03, 1.8187434078E+00, 7.8342374689E+00, 2.4849286540E-02, 2.4437880426E-02, 3.5198185629E-01],
	[5.1600000000E+03, 1.8207739647E+00, 7.8297210268E+00, 2.4921877896E-02, 2.4508408714E-02, 3.5223047870E-01],
	[5.1650000000E+03, 1.8228126607E+00, 7.8252578787E+00, 2.4994610470E-02, 2.4579071630E-02, 3.5247882550E-01],
	[5.1700000000E+03, 1.8248579839E+00, 7.8208388581E+00, 2.5067484398E-02, 2.4649868939E-02, 3.5272689737E-01],
	[5.1750000000E+03, 1.8269036216E+00, 7.8164266011E+00, 2.5140499818E-02, 2.4720799243E-02, 3.5297469500E-01],
	[5.1800000000E+03, 1.8289495735E+00, 7.8120210907E+00, 2.5213656865E-02, 2.4791862651E-02, 3.5322221910E-01],
	[5.1850000000E+03, 1.8309958396E+00, 7.8076223101E+00, 2.5286955678E-02, 2.4863059273E-02, 3.5346947034E-01],
	[5.1900000000E+03, 1.8330424194E+00, 7.8032302426E+00, 2.5360396393E-02, 2.4934389217E-02, 3.5371644943E-01],
	[5.1950000000E+03, 1.8350893127E+00, 7.7988448714E+00, 2.5433979147E-02, 2.5005852593E-02, 3.5396315703E-01],
	[5.2000000000E+03, 1.8371365194E+00, 7.7944661800E+00, 2.5507704076E-02, 2.5077449511E-02, 3.5420959385E-01],
	[5.2050000000E+03, 1.8391840390E+00, 7.7900941518E+00, 2.5581571318E-02, 2.5149180080E-02, 3.5445576054E-01],
	[5.2100000000E+03, 1.8412318714E+00, 7.7857287701E+00, 2.5655581010E-02, 2.5221044408E-02, 3.5470165780E-01],
	[5.2150000000E+03, 1.8432800164E+00, 7.7813700186E+00, 2.5729733288E-02, 2.5293042606E-02, 3.5494728629E-01],
	[5.2200000000E+03, 1.8453284736E+00, 7.7770178809E+00, 2.5804028289E-02, 2.5365174782E-02, 3.5519264670E-01],
	[5.2250000000E+03, 1.8473772429E+00, 7.7726723405E+00, 2.5878466151E-02, 2.5437441045E-02, 3.5543773967E-01],
	[5.2300000000E+03, 1.8494263239E+00, 7.7683333812E+00, 2.5953047009E-02, 2.5509841505E-02, 3.5568256589E-01],
	[5.2350000000E+03, 1.8514757164E+00, 7.7640009868E+00, 2.6027771002E-02, 2.5582376269E-02, 3.5592712602E-01],
	[5.2400000000E+03, 1.8535254202E+00, 7.7596751410E+00, 2.6102638265E-02, 2.5655045446E-02, 3.5617142072E-01],
	[5.2450000000E+03, 1.8555754350E+00, 7.7553558278E+00, 2.6177648936E-02, 2.5727849146E-02, 3.5641545064E-01],
	[5.2500000000E+03, 1.8576385930E+00, 7.7511179984E+00, 2.6252803151E-02, 2.5800790784E-02, 3.5665921645E-01],
	[5.2550000000E+03, 1.8597030012E+00, 7.7468919019E+00, 2.6328101048E-02, 2.5873867429E-02, 3.5690271880E-01],
	[5.2600000000E+03, 1.8617677370E+00, 7.7426721253E+00, 2.6403542763E-02, 2.5947078955E-02, 3.5714595834E-01],
	[5.2650000000E+03, 1.8638328001E+00, 7.7384586533E+00, 2.6479128433E-02, 2.6020425469E-02, 3.5738893571E-01],
	[5.2700000000E+03, 1.8658981904E+00, 7.7342514705E+00, 2.6554858195E-02, 2.6093907080E-02, 3.5763165158E-01],
	[5.2750000000E+03, 1.8679639075E+00, 7.7300505615E+00, 2.6630732186E-02, 2.6167523898E-02, 3.5787410657E-01],
	[5.2800000000E+03, 1.8700299512E+00, 7.7258559110E+00, 2.6706750543E-02, 2.6241276030E-02, 3.5811630134E-01],
	[5.2850000000E+03, 1.8720963212E+00, 7.7216675038E+00, 2.6782913402E-02, 2.6315163584E-02, 3.5835823652E-01],
	[5.2900000000E+03, 1.8741630173E+00, 7.7174853247E+00, 2.6859220901E-02, 2.6389186669E-02, 3.5859991275E-01],
	[5.2950000000E+03, 1.8762300392E+00, 7.7133093585E+00, 2.6935673176E-02, 2.6463345393E-02, 3.5884133066E-01],
	[5.3000000000E+03, 1.8782973867E+00, 7.7091395903E+00, 2.7012270364E-02, 2.6537639864E-02, 3.5908249089E-01],
	[5.3050000000E+03, 1.8803650594E+00, 7.7049760049E+00, 2.7089012602E-02, 2.6612070190E-02, 3.5932339407E-01],
	[5.3100000000E+03, 1.8824330572E+00, 7.7008185874E+00, 2.7165900026E-02, 2.6686636480E-02, 3.5956404082E-01],
	[5.3150000000E+03, 1.8845013798E+00, 7.6966673228E+00, 2.7242932775E-02, 2.6761338841E-02, 3.5980443178E-01],
	[5.3200000000E+03, 1.8865700270E+00, 7.6925221963E+00, 2.7320110984E-02, 2.6836177381E-02, 3.6004456755E-01],
	[5.3250000000E+03, 1.8886389984E+00, 7.6883831930E+00, 2.7397434790E-02, 2.6911152208E-02, 3.6028444878E-01],
	[5.3300000000E+03, 1.8907088856E+00, 7.6842537273E+00, 2.7474904331E-02, 2.6986263592E-02, 3.6052407606E-01],
	[5.3350000000E+03, 1.8927918544E+00, 7.6802041613E+00, 2.7552519742E-02, 2.7061515004E-02, 3.6076345003E-01],
	[5.3400000000E+03, 1.8948751636E+00, 7.6761605199E+00, 2.7630281162E-02, 2.7136903058E-02, 3.6100257129E-01],
	[5.3450000000E+03, 1.8969588128E+00, 7.6721227889E+00, 2.7708188726E-02, 2.7212427863E-02, 3.6124144045E-01],
	[5.3500000000E+03, 1.8990428018E+00, 7.6680909541E+00, 2.7786242572E-02, 2.7288089525E-02, 3.6148005813E-01],
	[5.3550000000E+03, 1.9011271303E+00, 7.6640650015E+00, 2.7864442836E-02, 2.7363888153E-02, 3.6171842494E-01],
	[5.3600000000E+03, 1.9032117980E+00, 7.6600449170E+00, 2.7942789656E-02, 2.7439823853E-02, 3.6195654147E-01],
	[5.3650000000E+03, 1.9052968048E+00, 7.6560306865E+00, 2.8021283167E-02, 2.7515896734E-02, 3.6219440834E-01],
	[5.3700000000E+03, 1.9073821502E+00, 7.6520222962E+00, 2.8099923507E-02, 2.7592106903E-02, 3.6243202613E-01],
	[5.3750000000E+03, 1.9094678341E+00, 7.6480197320E+00, 2.8178710814E-02, 2.7668454466E-02, 3.6266939546E-01],
	[5.3800000000E+03, 1.9115538562E+00, 7.6440229801E+00, 2.8257645222E-02, 2.7744939532E-02, 3.6290651692E-01],
	[5.3850000000E+03, 1.9136402163E+00, 7.6400320267E+00, 2.8336726870E-02, 2.7821562207E-02, 3.6314339110E-01],
	[5.3900000000E+03, 1.9157269140E+00, 7.6360468580E+00, 2.8415955895E-02, 2.7898322598E-02, 3.6338001859E-01],
	[5.3950000000E+03, 1.9178139492E+00, 7.6320674602E+00, 2.8495332432E-02, 2.7975220813E-02, 3.6361639999E-01],
	[5.4000000000E+03, 1.9199013215E+00, 7.6280938196E+00, 2.8574856619E-02, 2.8052256958E-02, 3.6385253588E-01],
	[5.4050000000E+03, 1.9219890307E+00, 7.6241259227E+00, 2.8654528593E-02, 2.8129431140E-02, 3.6408842684E-01],
	[5.4100000000E+03, 1.9240770766E+00, 7.6201637558E+00, 2.8734348491E-02, 2.8206743466E-02, 3.6432407347E-01],
	[5.4150000000E+03, 1.9261654589E+00, 7.6162073053E+00, 2.8814316448E-02, 2.8284194043E-02, 3.6455947635E-01],
	[5.4200000000E+03, 1.9282656155E+00, 7.6123221941E+00, 2.8894432603E-02, 2.8361786362E-02, 3.6479463605E-01],
	[5.4250000000E+03, 1.9303676253E+00, 7.6084512559E+00, 2.8974697092E-02, 2.8439517622E-02, 3.6502955315E-01],
	[5.4300000000E+03, 1.9324699870E+00, 7.6045858494E+00, 2.9055110051E-02, 2.8517387486E-02, 3.6526422823E-01],
	[5.4350000000E+03, 1.9345727002E+00, 7.6007259617E+00, 2.9135671619E-02, 2.8595396060E-02, 3.6549866186E-01],
	[5.4400000000E+03, 1.9366757646E+00, 7.5968715798E+00, 2.9216381930E-02, 2.8673543452E-02, 3.6573285461E-01],
	[5.4450000000E+03, 1.9387791801E+00, 7.5930226908E+00, 2.9297241123E-02, 2.8751829768E-02, 3.6596680706E-01],
	[5.4500000000E+03, 1.9408829462E+00, 7.5891792818E+00, 2.9378249333E-02, 2.8830255113E-02, 3.6620051976E-01],
	[5.4550000000E+03, 1.9429870629E+00, 7.5853413401E+00, 2.9459406699E-02, 2.8908819596E-02, 3.6643399329E-01],
	[5.4600000000E+03, 1.9450915298E+00, 7.5815088528E+00, 2.9540713356E-02, 2.8987523320E-02, 3.6666722821E-01],
	[5.4650000000E+03, 1.9471963466E+00, 7.5776818071E+00, 2.9622169441E-02, 2.9066366394E-02, 3.6690022510E-01],
	[5.4700000000E+03, 1.9493015131E+00, 7.5738601905E+00, 2.9703775092E-02, 2.9145348923E-02, 3.6713298466E-01],
	[5.4750000000E+03, 1.9514070291E+00, 7.5700439902E+00, 2.9785530445E-02, 2.9224471013E-02, 3.6736550750E-01],
	[5.4800000000E+03, 1.9535128942E+00, 7.5662331937E+00, 2.9867783026E-02, 2.9304067171E-02, 3.6759779427E-01],
	[5.4850000000E+03, 1.9556191082E+00, 7.5624277884E+00, 2.9950467496E-02, 2.9384074403E-02, 3.6782984558E-01],
	[5.4900000000E+03, 1.9577256709E+00, 7.5586277617E+00, 3.0033304972E-02, 2.9464224208E-02, 3.6806166206E-01],
	[5.4950000000E+03, 1.9598325820E+00, 7.5548331011E+00, 3.0116295599E-02, 2.9544516697E-02, 3.6829324433E-01],
	[5.5000000000E+03, 1.9619398412E+00, 7.5510437942E+00, 3.0199439518E-02, 2.9624951980E-02, 3.6852459301E-01],
	[5.5050000000E+03, 1.9640530512E+00, 7.5472917621E+00, 3.0282736872E-02, 2.9705531945E-02, 3.6875570870E-01],
	[5.5100000000E+03, 1.9661735454E+00, 7.5435844310E+00, 3.0366187803E-02, 2.9786257145E-02, 3.6898659204E-01],
	[5.5150000000E+03, 1.9682944026E+00, 7.5398822812E+00, 3.0449792455E-02, 2.9867125506E-02, 3.6921724362E-01],
	[5.5200000000E+03, 1.9704156225E+00, 7.5361853008E+00, 3.0533550970E-02, 2.9948137137E-02, 3.6944766406E-01],
	[5.5250000000E+03, 1.9725372047E+00, 7.5324934778E+00, 3.0617463491E-02, 3.0029292150E-02, 3.6967785396E-01],
	[5.5300000000E+03, 1.9746591491E+00, 7.5288068004E+00, 3.0701530160E-02, 3.0110590654E-02, 3.6990781392E-01],
	[5.5350000000E+03, 1.9767814553E+00, 7.5251252568E+00, 3.0785751120E-02, 3.0192032761E-02, 3.7013754456E-01],
	[5.5400000000E+03, 1.9789041232E+00, 7.5214488352E+00, 3.0870126515E-02, 3.0273618579E-02, 3.7036704646E-01],
	[5.5450000000E+03, 1.9810271523E+00, 7.5177775239E+00, 3.0954656485E-02, 3.0355348219E-02, 3.7059632023E-01],
	[5.5500000000E+03, 1.9831505426E+00, 7.5141113112E+00, 3.1039341175E-02, 3.0437221791E-02, 3.7082536645E-01],
	[5.5550000000E+03, 1.9852742937E+00, 7.5104501853E+00, 3.1124180727E-02, 3.0519239406E-02, 3.7105418573E-01],
	[5.5600000000E+03, 1.9873984053E+00, 7.5067941347E+00, 3.1209175283E-02, 3.0601401172E-02, 3.7128277866E-01],
	[5.5650000000E+03, 1.9895228771E+00, 7.5031431479E+00, 3.1294324986E-02, 3.0683707200E-02, 3.7151114581E-01],
	[5.5700000000E+03, 1.9916477090E+00, 7.4994972131E+00, 3.1379629980E-02, 3.0766157600E-02, 3.7173928778E-01],
	[5.5750000000E+03, 1.9937729007E+00, 7.4958563190E+00, 3.1465090406E-02, 3.0848752481E-02, 3.7196720516E-01],
	[5.5800000000E+03, 1.9958984518E+00, 7.4922204540E+00, 3.1550706407E-02, 3.0931491953E-02, 3.7219489852E-01],
	[5.5850000000E+03, 1.9980243622E+00, 7.4885896067E+00, 3.1636478127E-02, 3.1014376126E-02, 3.7242236844E-01],
	[5.5900000000E+03, 2.0001506316E+00, 7.4849637657E+00, 3.1722405707E-02, 3.1097405108E-02, 3.7264961550E-01],
	[5.5950000000E+03, 2.0022861057E+00, 7.4813929925E+00, 3.1808489290E-02, 3.1180582024E-02, 3.7287664029E-01],
	[5.6000000000E+03, 2.0044252261E+00, 7.4778456299E+00, 3.1894729020E-02, 3.1263905116E-02, 3.7310344336E-01],
	[5.6050000000E+03, 2.0065647196E+00, 7.4743031129E+00, 3.1981125039E-02, 3.1347373381E-02, 3.7333002529E-01],
	[5.6100000000E+03, 2.0087045860E+00, 7.4707654306E+00, 3.2067677489E-02, 3.1430986928E-02, 3.7355638665E-01],
	[5.6150000000E+03, 2.0108448250E+00, 7.4672325722E+00, 3.2154386513E-02, 3.1514745868E-02, 3.7378252801E-01],
	[5.6200000000E+03, 2.0129854365E+00, 7.4637045266E+00, 3.2241252254E-02, 3.1598650309E-02, 3.7400844993E-01],
	[5.6250000000E+03, 2.0151264200E+00, 7.4601812832E+00, 3.2328274855E-02, 3.1682700360E-02, 3.7423415298E-01],
	[5.6300000000E+03, 2.0172677753E+00, 7.4566628311E+00, 3.2415454458E-02, 3.1766896131E-02, 3.7445963771E-01],
	[5.6350000000E+03, 2.0194095023E+00, 7.4531491596E+00, 3.2502791207E-02, 3.1851237730E-02, 3.7468490469E-01],
	[5.6400000000E+03, 2.0215516005E+00, 7.4496402578E+00, 3.2590285243E-02, 3.1935725266E-02, 3.7490995447E-01],
	[5.6450000000E+03, 2.0236940698E+00, 7.4461361152E+00, 3.2677936709E-02, 3.2020358848E-02, 3.7513478760E-01],
	[5.6500000000E+03, 2.0258369098E+00, 7.4426367211E+00, 3.2765745749E-02, 3.2105138585E-02, 3.7535940465E-01],
	[5.6550000000E+03, 2.0279801204E+00, 7.4391420648E+00, 3.2853712505E-02, 3.2190064586E-02, 3.7558380615E-01],
	[5.6600000000E+03, 2.0301237012E+00, 7.4356521357E+00, 3.2941837119E-02, 3.2275136959E-02, 3.7580799267E-01],
	[5.6650000000E+03, 2.0322676519E+00, 7.4321669234E+00, 3.3030119735E-02, 3.2360355813E-02, 3.7603196474E-01],
	[5.6700000000E+03, 2.0344119724E+00, 7.4286864171E+00, 3.3118560495E-02, 3.2445721256E-02, 3.7625572290E-01],
	[5.6750000000E+03, 2.0365566624E+00, 7.4252106066E+00, 3.3207159542E-02, 3.2531233397E-02, 3.7647926772E-01],
	[5.6800000000E+03, 2.0387017216E+00, 7.4217394812E+00, 3.3295917018E-02, 3.2616892343E-02, 3.7670259971E-01],
	[5.6850000000E+03, 2.0408556650E+00, 7.4183209807E+00, 3.3384833067E-02, 3.2702701322E-02, 3.7692571943E-01],
	[5.6900000000E+03, 2.0430131841E+00, 7.4149250302E+00, 3.3473907830E-02, 3.2788658525E-02, 3.7714862741E-01],
	[5.6950000000E+03, 2.0451710860E+00, 7.4115336152E+00, 3.3563141451E-02, 3.2874762895E-02, 3.7737132418E-01],
	[5.7000000000E+03, 2.0473293704E+00, 7.4081467255E+00, 3.3652534073E-02, 3.2961014539E-02, 3.7759381029E-01],
	[5.7050000000E+03, 2.0494880370E+00, 7.4047643511E+00, 3.3742085838E-02, 3.3047413567E-02, 3.7781608625E-01],
	[5.7100000000E+03, 2.0516470857E+00, 7.4013864821E+00, 3.3831796889E-02, 3.3133960086E-02, 3.7803815260E-01],
	[5.7150000000E+03, 2.0538065160E+00, 7.3980131085E+00, 3.3921667368E-02, 3.3220654205E-02, 3.7826000987E-01],
	[5.7200000000E+03, 2.0559663279E+00, 7.3946442205E+00, 3.4011697419E-02, 3.3307496030E-02, 3.7848165858E-01],
	[5.7250000000E+03, 2.0581265209E+00, 7.3912798081E+00, 3.4101887184E-02, 3.3394485671E-02, 3.7870309926E-01],
	[5.7300000000E+03, 2.0602870948E+00, 7.3879198615E+00, 3.4192236805E-02, 3.3481623234E-02, 3.7892433242E-01],
	[5.7350000000E+03, 2.0624480494E+00, 7.3845643709E+00, 3.4282766488E-02, 3.3568928063E-02, 3.7914535860E-01],
	[5.7400000000E+03, 2.0646093844E+00, 7.3812133265E+00, 3.4373479278E-02, 3.3656403043E-02, 3.7936617830E-01],
	[5.7450000000E+03, 2.0667710995E+00, 7.3778667186E+00, 3.4464352569E-02, 3.3744026470E-02, 3.7958679204E-01],
	[5.7500000000E+03, 2.0689331945E+00, 7.3745245373E+00, 3.4555386506E-02, 3.3831798452E-02, 3.7980720035E-01],
	[5.7550000000E+03, 2.0710956690E+00, 7.3711867731E+00, 3.4646581231E-02, 3.3919719097E-02, 3.8002740372E-01],
	[5.7600000000E+03, 2.0732585229E+00, 7.3678534162E+00, 3.4737936889E-02, 3.4007788513E-02, 3.8024740262E-01],
	[5.7650000000E+03, 2.0754217559E+00, 7.3645244571E+00, 3.4829453621E-02, 3.4096006807E-02, 3.8046719731E-01],
	[5.7700000000E+03, 2.0775853677E+00, 7.3611998861E+00, 3.4921131572E-02, 3.4184374087E-02, 3.8068678832E-01],
	[5.7750000000E+03, 2.0797542688E+00, 7.3579072491E+00, 3.5012970885E-02, 3.4272892391E-02, 3.8090617624E-01],
	[5.7800000000E+03, 2.0819299427E+00, 7.3546547282E+00, 3.5104971703E-02, 3.4361562435E-02, 3.8112536163E-01],
	[5.7850000000E+03, 2.0841060084E+00, 7.3514064556E+00, 3.5197134169E-02, 3.4450381824E-02, 3.8134434506E-01],
	[5.7900000000E+03, 2.0862824657E+00, 7.3481624221E+00, 3.5289458426E-02, 3.4539350666E-02, 3.8156312710E-01],
	[5.7950000000E+03, 2.0884593143E+00, 7.3449226184E+00, 3.5381944619E-02, 3.4628469068E-02, 3.8178170832E-01],
	[5.8000000000E+03, 2.0906365538E+00, 7.3416870355E+00, 3.5474592889E-02, 3.4717737138E-02, 3.8200008926E-01],
	[5.8050000000E+03, 2.0928141841E+00, 7.3384556642E+00, 3.5567403381E-02, 3.4807154983E-02, 3.8221827050E-01],
	[5.8100000000E+03, 2.0949922049E+00, 7.3352284953E+00, 3.5660376238E-02, 3.4896722710E-02, 3.8243625260E-01],
	[5.8150000000E+03, 2.0971706159E+00, 7.3320055199E+00, 3.5753511602E-02, 3.4986440427E-02, 3.8265403610E-01],
	[5.8200000000E+03, 2.0993494168E+00, 7.3287867288E+00, 3.5846809618E-02, 3.5076308240E-02, 3.8287162156E-01],
	[5.8250000000E+03, 2.1015286074E+00, 7.3255721131E+00, 3.5940270429E-02, 3.5166326256E-02, 3.8308900954E-01],
	[5.8300000000E+03, 2.1037081874E+00, 7.3223616637E+00, 3.6033894177E-02, 3.5256494583E-02, 3.8330620058E-01],
	[5.8350000000E+03, 2.1058881565E+00, 7.3191553717E+00, 3.6127681007E-02, 3.5346813327E-02, 3.8352319523E-01],
	[5.8400000000E+03, 2.1080685146E+00, 7.3159532281E+00, 3.6221631061E-02, 3.5437282594E-02, 3.8373999403E-01],
	[5.8450000000E+03, 2.1102492612E+00, 7.3127552241E+00, 3.6315744483E-02, 3.5527902493E-02, 3.8395659754E-01],
	[5.8500000000E+03, 2.1124303962E+00, 7.3095613508E+00, 3.6410021416E-02, 3.5618673128E-02, 3.8417300629E-01],
	[5.8550000000E+03, 2.1146119193E+00, 7.3063715992E+00, 3.6504462003E-02, 3.5709594607E-02, 3.8438922082E-01],
	[5.8600000000E+03, 2.1167938302E+00, 7.3031859606E+00, 3.6599066389E-02, 3.5800667035E-02, 3.8460524167E-01],
	[5.8650000000E+03, 2.1189761287E+00, 7.3000044261E+00, 3.6693834715E-02, 3.5891890521E-02, 3.8482106937E-01],
	[5.8700000000E+03, 2.1211680422E+00, 7.2968786048E+00, 3.6788767125E-02, 3.5983269080E-02, 3.8503670446E-01],
	[5.8750000000E+03, 2.1233620112E+00, 7.2937660388E+00, 3.6883863763E-02, 3.6074799644E-02, 3.8525214748E-01],
	[5.8800000000E+03, 2.1255563803E+00, 7.2906574468E+00, 3.6979124772E-02, 3.6166481622E-02, 3.8546739894E-01],
	[5.8850000000E+03, 2.1277511490E+00, 7.2875528201E+00, 3.7074550296E-02, 3.6258315119E-02, 3.8568245938E-01],
	[5.8900000000E+03, 2.1299463171E+00, 7.2844521505E+00, 3.7170140477E-02, 3.6350300242E-02, 3.8589732933E-01],
	[5.8950000000E+03, 2.1321418844E+00, 7.2813554295E+00, 3.7265895458E-02, 3.6442437096E-02, 3.8611200930E-01],
	[5.9000000000E+03, 2.1343378506E+00, 7.2782626487E+00, 3.7361815384E-02, 3.6534725787E-02, 3.8632649983E-01],
	[5.9050000000E+03, 2.1365342154E+00, 7.2751737998E+00, 3.7457900398E-02, 3.6627166423E-02, 3.8654080142E-01],
	[5.9100000000E+03, 2.1387309786E+00, 7.2720888744E+00, 3.7554150642E-02, 3.6719759107E-02, 3.8675491461E-01],
	[5.9150000000E+03, 2.1409281398E+00, 7.2690078644E+00, 3.7650566261E-02, 3.6812503947E-02, 3.8696883990E-01],
	[5.9200000000E+03, 2.1431256990E+00, 7.2659307613E+00, 3.7747147397E-02, 3.6905401048E-02, 3.8718257782E-01],
	[5.9250000000E+03, 2.1453236556E+00, 7.2628575570E+00, 3.7843894194E-02, 3.6998450515E-02, 3.8739612887E-01],
	[5.9300000000E+03, 2.1475220096E+00, 7.2597882433E+00, 3.7940806795E-02, 3.7091652454E-02, 3.8760949357E-01],
	[5.9350000000E+03, 2.1497207606E+00, 7.2567228118E+00, 3.8037885344E-02, 3.7185006971E-02, 3.8782267242E-01],
	[5.9400000000E+03, 2.1519199084E+00, 7.2536612545E+00, 3.8135129984E-02, 3.7278514171E-02, 3.8803566594E-01],
	[5.9450000000E+03, 2.1541194527E+00, 7.2506035632E+00, 3.8232540858E-02, 3.7372174159E-02, 3.8824847463E-01],
	[5.9500000000E+03, 2.1563193933E+00, 7.2475497298E+00, 3.8330118109E-02, 3.7465987041E-02, 3.8846109899E-01],
	[5.9550000000E+03, 2.1585197299E+00, 7.2444997462E+00, 3.8427861881E-02, 3.7559952921E-02, 3.8867353952E-01],
	[5.9600000000E+03, 2.1607204622E+00, 7.2414536042E+00, 3.8525772317E-02, 3.7654071905E-02, 3.8888579674E-01],
	[5.9650000000E+03, 2.1629316598E+00, 7.2384675434E+00, 3.8623849561E-02, 3.7748348695E-02, 3.8909787112E-01],
	[5.9700000000E+03, 2.1651436664E+00, 7.2354874544E+00, 3.8722093756E-02, 3.7842779020E-02, 3.8930976318E-01],
	[5.9750000000E+03, 2.1673560806E+00, 7.2325110856E+00, 3.8820505045E-02, 3.7937362802E-02, 3.8952147341E-01],
	[5.9800000000E+03, 2.1695689020E+00, 7.2295384293E+00, 3.8919083572E-02, 3.8032100146E-02, 3.8973300230E-01],
	[5.9850000000E+03, 2.1717821303E+00, 7.2265694777E+00, 3.9017829479E-02, 3.8126991158E-02, 3.8994435034E-01],
	[5.9900000000E+03, 2.1739957655E+00, 7.2236042231E+00, 3.9116742911E-02, 3.8222035941E-02, 3.9015551803E-01],
	[5.9950000000E+03, 2.1762098071E+00, 7.2206426579E+00, 3.9215824011E-02, 3.8317234602E-02, 3.9036650585E-01],
	[6.0000000000E+03, 2.1784242548E+00, 7.2176847744E+00, 3.9315072921E-02, 3.8412587244E-02, 3.9057731429E-01],
	[6.0050000000E+03, 2.1806391086E+00, 7.2147305648E+00, 3.9414958736E-02, 3.8508541602E-02, 3.9078794383E-01],
	[6.0100000000E+03, 2.1828543680E+00, 7.2117800217E+00, 3.9515014645E-02, 3.8604651979E-02, 3.9099839496E-01],
	[6.0150000000E+03, 2.1850700328E+00, 7.2088331375E+00, 3.9615240795E-02, 3.8700918484E-02, 3.9120866815E-01],
	[6.0200000000E+03, 2.1872861027E+00, 7.2058899045E+00, 3.9715637333E-02, 3.8797341223E-02, 3.9141876390E-01],
	[6.0250000000E+03, 2.1895025776E+00, 7.2029503152E+00, 3.9816204407E-02, 3.8893920304E-02, 3.9162868268E-01],
	[6.0300000000E+03, 2.1917194570E+00, 7.2000143620E+00, 3.9916942163E-02, 3.8990655834E-02, 3.9183842496E-01],
	[6.0350000000E+03, 2.1939367409E+00, 7.1970820376E+00, 4.0017850749E-02, 3.9087547920E-02, 3.9204799122E-01],
	[6.0400000000E+03, 2.1961544288E+00, 7.1941533343E+00, 4.0118930312E-02, 3.9184596669E-02, 3.9225738194E-01],
	[6.0450000000E+03, 2.1983725206E+00, 7.1912282447E+00, 4.0220180998E-02, 3.9281802189E-02, 3.9246659758E-01],
	[6.0500000000E+03, 2.2005910159E+00, 7.1883067614E+00, 4.0321602956E-02, 3.9379164585E-02, 3.9267563862E-01],
	[6.0550000000E+03, 2.2028099146E+00, 7.1853888770E+00, 4.0423196332E-02, 3.9476683965E-02, 3.9288450553E-01],
	[6.0600000000E+03, 2.2050370055E+00, 7.1825179116E+00, 4.0524961274E-02, 3.9574364260E-02, 3.9309319877E-01],
	[6.0650000000E+03, 2.2072668171E+00, 7.1796632839E+00, 4.0626897929E-02, 3.9672202919E-02, 3.9330171881E-01],
	[6.0700000000E+03, 2.2094970433E+00, 7.1768121418E+00, 4.0729006443E-02, 3.9770198923E-02, 3.9351006611E-01],
	[6.0750000000E+03, 2.2117276839E+00, 7.1739644780E+00, 4.0831286965E-02, 3.9868352376E-02, 3.9371824114E-01],
	[6.0800000000E+03, 2.2139587384E+00, 7.1711202856E+00, 4.0933739640E-02, 3.9966663386E-02, 3.9392624435E-01],
	[6.0850000000E+03, 2.2161902068E+00, 7.1682795574E+00, 4.1036364618E-02, 4.0065132060E-02, 3.9413407621E-01],
	[6.0900000000E+03, 2.2184220887E+00, 7.1654422863E+00, 4.1139162044E-02, 4.0163758503E-02, 3.9434173718E-01],
	[6.0950000000E+03, 2.2206543838E+00, 7.1626084654E+00, 4.1242132066E-02, 4.0262542823E-02, 3.9454922771E-01],
	[6.1000000000E+03, 2.2228870919E+00, 7.1597780876E+00, 4.1345274831E-02, 4.0361485124E-02, 3.9475654825E-01],
	[6.1050000000E+03, 2.2251202128E+00, 7.1569511460E+00, 4.1448590486E-02, 4.0460585515E-02, 3.9496369927E-01],
	[6.1100000000E+03, 2.2273537461E+00, 7.1541276334E+00, 4.1552079179E-02, 4.0559844099E-02, 3.9517068120E-01],
	[6.1150000000E+03, 2.2295876916E+00, 7.1513075430E+00, 4.1655741057E-02, 4.0659260985E-02, 3.9537749451E-01],
	[6.1200000000E+03, 2.2318220491E+00, 7.1484908679E+00, 4.1759576266E-02, 4.0758836276E-02, 3.9558413964E-01],
	[6.1250000000E+03, 2.2340568182E+00, 7.1456776010E+00, 4.1863584955E-02, 4.0858570081E-02, 3.9579061704E-01],
	[6.1300000000E+03, 2.2362919988E+00, 7.1428677356E+00, 4.1967767271E-02, 4.0958462503E-02, 3.9599692715E-01],
	[6.1350000000E+03, 2.2385275906E+00, 7.1400612647E+00, 4.2072123359E-02, 4.1058513649E-02, 3.9620307043E-01],
	[6.1400000000E+03, 2.2407635932E+00, 7.1372581814E+00, 4.2176653369E-02, 4.1158723625E-02, 3.9640904731E-01],
	[6.1450000000E+03, 2.2430000065E+00, 7.1344584790E+00, 4.2281357447E-02, 4.1259092536E-02, 3.9661485823E-01],
	[6.1500000000E+03, 2.2452368302E+00, 7.1316621506E+00, 4.2386235741E-02, 4.1359620487E-02, 3.9682050364E-01],
	[6.1550000000E+03, 2.2474767198E+00, 7.1288838698E+00, 4.2491288397E-02, 4.1460308984E-02, 3.9702598397E-01],
	[6.1600000000E+03, 2.2497241227E+00, 7.1261481188E+00, 4.2596515563E-02, 4.1561160500E-02, 3.9723129967E-01],
	[6.1650000000E+03, 2.2519719468E+00, 7.1234156360E+00, 4.2701917386E-02, 4.1662171413E-02, 3.9743645116E-01],
	[6.1700000000E+03, 2.2542201917E+00, 7.1206864150E+00, 4.2807494013E-02, 4.1763341829E-02, 3.9764143889E-01],
	[6.1750000000E+03, 2.2564688572E+00, 7.1179604491E+00, 4.2913245592E-02, 4.1864671852E-02, 3.9784626328E-01],
	[6.1800000000E+03, 2.2587179431E+00, 7.1152377319E+00, 4.3019172270E-02, 4.1966161588E-02, 3.9805092477E-01],
	[6.1850000000E+03, 2.2609674491E+00, 7.1125182569E+00, 4.3125274194E-02, 4.2067811142E-02, 3.9825542379E-01],
	[6.1900000000E+03, 2.2632173749E+00, 7.1098020175E+00, 4.3231551512E-02, 4.2169620618E-02, 3.9845976077E-01],
	[6.1950000000E+03, 2.2654677203E+00, 7.1070890074E+00, 4.3338004370E-02, 4.2271590123E-02, 3.9866393613E-01],
	[6.2000000000E+03, 2.2677184850E+00, 7.1043792201E+00, 4.3444632917E-02, 4.2373719760E-02, 3.9886795030E-01],
	[6.2050000000E+03, 2.2699696687E+00, 7.1016726492E+00, 4.3551437299E-02, 4.2476009635E-02, 3.9907180372E-01],
	[6.2100000000E+03, 2.2722212712E+00, 7.0989692882E+00, 4.3658417663E-02, 4.2578459851E-02, 3.9927549679E-01],
	[6.2150000000E+03, 2.2744732923E+00, 7.0962691308E+00, 4.3765574157E-02, 4.2681070515E-02, 3.9947902994E-01],
	[6.2200000000E+03, 2.2767257317E+00, 7.0935721706E+00, 4.3872906928E-02, 4.2783841729E-02, 3.9968240361E-01],
	[6.2250000000E+03, 2.2789785890E+00, 7.0908784013E+00, 4.3980416124E-02, 4.2886773599E-02, 3.9988561819E-01],
	[6.2300000000E+03, 2.2812318642E+00, 7.0881878164E+00, 4.4088101891E-02, 4.2989866229E-02, 4.0008867412E-01],
	[6.2350000000E+03, 2.2834855568E+00, 7.0855004098E+00, 4.4195964378E-02, 4.3093119722E-02, 4.0029157181E-01],
	[6.2400000000E+03, 2.2857396666E+00, 7.0828161751E+00, 4.4304003730E-02, 4.3196534185E-02, 4.0049431167E-01],
	[6.2450000000E+03, 2.2879941935E+00, 7.0801351061E+00, 4.4412220097E-02, 4.3300109719E-02, 4.0069689412E-01],
	[6.2500000000E+03, 2.2902491370E+00, 7.0774571964E+00, 4.4520613624E-02, 4.3403846430E-02, 4.0089931958E-01],
	[6.2550000000E+03, 2.2925088194E+00, 7.0748061853E+00, 4.4629184460E-02, 4.3507746876E-02, 4.0110158846E-01],
	[6.2600000000E+03, 2.2947740141E+00, 7.0721862161E+00, 4.4737932751E-02, 4.3611811626E-02, 4.0130370115E-01],
	[6.2650000000E+03, 2.2970396359E+00, 7.0695693078E+00, 4.4846858645E-02, 4.3716037906E-02, 4.0150565809E-01],
	[6.2700000000E+03, 2.2993056844E+00, 7.0669554543E+00, 4.4955962290E-02, 4.3820425820E-02, 4.0170745967E-01],
	[6.2750000000E+03, 2.3015721594E+00, 7.0643446497E+00, 4.5065243832E-02, 4.3924975471E-02, 4.0190910630E-01],
	[6.2800000000E+03, 2.3038390606E+00, 7.0617368880E+00, 4.5174703419E-02, 4.4029686963E-02, 4.0211059838E-01],
	[6.2850000000E+03, 2.3061063877E+00, 7.0591321632E+00, 4.5284341198E-02, 4.4134560399E-02, 4.0231193633E-01],
	[6.2900000000E+03, 2.3083741405E+00, 7.0565304693E+00, 4.5394157317E-02, 4.4239595884E-02, 4.0251312054E-01],
	[6.2950000000E+03, 2.3106423187E+00, 7.0539318005E+00, 4.5504151922E-02, 4.4344793521E-02, 4.0271415142E-01],
	[6.3000000000E+03, 2.3129109221E+00, 7.0513361508E+00, 4.5614325162E-02, 4.4450153412E-02, 4.0291502936E-01],
	[6.3050000000E+03, 2.3151799505E+00, 7.0487435143E+00, 4.5724677184E-02, 4.4555675662E-02, 4.0311575477E-01],
	[6.3100000000E+03, 2.3174494034E+00, 7.0461538851E+00, 4.5835208134E-02, 4.4661360373E-02, 4.0331632811E-01],
	[6.3150000000E+03, 2.3197192808E+00, 7.0435672574E+00, 4.5945918161E-02, 4.4767207649E-02, 4.0351675002E-01],
	[6.3200000000E+03, 2.3219895823E+00, 7.0409836253E+00, 4.6056807411E-02, 4.4873217592E-02, 4.0371702094E-01],
	[6.3250000000E+03, 2.3242603078E+00, 7.0384029830E+00, 4.6167876033E-02, 4.4979390306E-02, 4.0391714130E-01],
	[6.3300000000E+03, 2.3265314568E+00, 7.0358253246E+00, 4.6279124173E-02, 4.5085725894E-02, 4.0411711152E-01],
	[6.3350000000E+03, 2.3288030292E+00, 7.0332506444E+00, 4.6390551978E-02, 4.5192224457E-02, 4.0431693203E-01],
	[6.3400000000E+03, 2.3310750247E+00, 7.0306789366E+00, 4.6502159597E-02, 4.5298886100E-02, 4.0451660326E-01],
	[6.3450000000E+03, 2.3333474431E+00, 7.0281101953E+00, 4.6613947176E-02, 4.5405710924E-02, 4.0471612563E-01],
	[6.3500000000E+03, 2.3356202841E+00, 7.0255444149E+00, 4.6725914863E-02, 4.5512699032E-02, 4.0491549956E-01],
	[6.3550000000E+03, 2.3378965146E+00, 7.0229978194E+00, 4.6838062806E-02, 4.5619852342E-02, 4.0511472547E-01],
	[6.3600000000E+03, 2.3401792725E+00, 7.0204874805E+00, 4.6950391151E-02, 4.5727172897E-02, 4.0531380378E-01],
	[6.3650000000E+03, 2.3424624627E+00, 7.0179800106E+00, 4.7062900046E-02, 4.5834657087E-02, 4.0551273490E-01],
	[6.3700000000E+03, 2.3447460850E+00, 7.0154754042E+00, 4.7175589639E-02, 4.5942305013E-02, 4.0571151926E-01],
	[6.3750000000E+03, 2.3470301392E+00, 7.0129736557E+00, 4.7288460076E-02, 4.6050116777E-02, 4.0591015727E-01],
	[6.3800000000E+03, 2.3493146251E+00, 7.0104747598E+00, 4.7401511506E-02, 4.6158092483E-02, 4.0610864935E-01],
	[6.3850000000E+03, 2.3515995422E+00, 7.0079787108E+00, 4.7514744075E-02, 4.6266232231E-02, 4.0630699590E-01],
	[6.3900000000E+03, 2.3538848905E+00, 7.0054855033E+00, 4.7628157931E-02, 4.6374536124E-02, 4.0650519733E-01],
	[6.3950000000E+03, 2.3561706695E+00, 7.0029951319E+00, 4.7741753222E-02, 4.6483004264E-02, 4.0670325406E-01],
	[6.4000000000E+03, 2.3584568792E+00, 7.0005075912E+00, 4.7855530095E-02, 4.6591636753E-02, 4.0690116649E-01],
	[6.4050000000E+03, 2.3607435192E+00, 6.9980228756E+00, 4.7969488696E-02, 4.6700433692E-02, 4.0709893504E-01],
	[6.4100000000E+03, 2.3630305892E+00, 6.9955409798E+00, 4.8083629175E-02, 4.6809395183E-02, 4.0729656010E-01],
	[6.4150000000E+03, 2.3653180891E+00, 6.9930618984E+00, 4.8197951678E-02, 4.6918521329E-02, 4.0749404208E-01],
	[6.4200000000E+03, 2.3676060185E+00, 6.9905856261E+00, 4.8312456352E-02, 4.7027812229E-02, 4.0769138139E-01],
	[6.4250000000E+03, 2.3698943772E+00, 6.9881121573E+00, 4.8427143345E-02, 4.7137267987E-02, 4.0788857843E-01],
	[6.4300000000E+03, 2.3721831650E+00, 6.9856414869E+00, 4.8542012804E-02, 4.7246888703E-02, 4.0808563359E-01],
	[6.4350000000E+03, 2.3744723816E+00, 6.9831736094E+00, 4.8657064878E-02, 4.7356674478E-02, 4.0828254728E-01],
	[6.4400000000E+03, 2.3767620267E+00, 6.9807085196E+00, 4.8772299712E-02, 4.7466625414E-02, 4.0847931990E-01],
	[6.4450000000E+03, 2.3790521002E+00, 6.9782462121E+00, 4.8887717455E-02, 4.7576741611E-02, 4.0867595184E-01],
	[6.4500000000E+03, 2.3813426016E+00, 6.9757866816E+00, 4.9003318255E-02, 4.7687023172E-02, 4.0887244349E-01],
	[6.4550000000E+03, 2.3836335309E+00, 6.9733299228E+00, 4.9119102258E-02, 4.7797470196E-02, 4.0906879526E-01],
	[6.4600000000E+03, 2.3859324860E+00, 6.9709173362E+00, 4.9235069612E-02, 4.7908087804E-02, 4.0926500754E-01],
	[6.4650000000E+03, 2.3882330012E+00, 6.9685135670E+00, 4.9351220464E-02, 4.8018871860E-02, 4.0946108071E-01],
	[6.4700000000E+03, 2.3905339534E+00, 6.9661124841E+00, 4.9467554963E-02, 4.8129821726E-02, 4.0965701518E-01],
	[6.4750000000E+03, 2.3928353425E+00, 6.9637140823E+00, 4.9584073255E-02, 4.8240937502E-02, 4.0985281132E-01],
	[6.4800000000E+03, 2.3951371681E+00, 6.9613183567E+00, 4.9700775487E-02, 4.8352219290E-02, 4.1004846953E-01],
	[6.4850000000E+03, 2.3974394300E+00, 6.9589253022E+00, 4.9817664570E-02, 4.8463669803E-02, 4.1024399020E-01],
	[6.4900000000E+03, 2.3997421280E+00, 6.9565349137E+00, 4.9934738380E-02, 4.8575286993E-02, 4.1043937370E-01],
	[6.4950000000E+03, 2.4020452617E+00, 6.9541471863E+00, 5.0051996587E-02, 4.8687070509E-02, 4.1063462044E-01],
	[6.5000000000E+03, 2.4043488310E+00, 6.9517621149E+00, 5.0169439338E-02, 4.8799020449E-02, 4.1082973078E-01],
	[6.5050000000E+03, 2.4066528356E+00, 6.9493796945E+00, 5.0287066780E-02, 4.8911136915E-02, 4.1102470512E-01],
	[6.5100000000E+03, 2.4089572752E+00, 6.9469999202E+00, 5.0404879061E-02, 4.9023420006E-02, 4.1121954383E-01],
	[6.5150000000E+03, 2.4112621496E+00, 6.9446227870E+00, 5.0522876328E-02, 4.9135869823E-02, 4.1141424729E-01],
	[6.5200000000E+03, 2.4135674585E+00, 6.9422482898E+00, 5.0641058730E-02, 4.9248486465E-02, 4.1160881589E-01],
	[6.5250000000E+03, 2.4158732017E+00, 6.9398764239E+00, 5.0759426413E-02, 4.9361270034E-02, 4.1180325001E-01],
	[6.5300000000E+03, 2.4181793789E+00, 6.9375071843E+00, 5.0877979525E-02, 4.9474220628E-02, 4.1199755001E-01],
	[6.5350000000E+03, 2.4204859899E+00, 6.9351405659E+00, 5.0996718213E-02, 4.9587338347E-02, 4.1219171627E-01],
	[6.5400000000E+03, 2.4227930345E+00, 6.9327765641E+00, 5.1115642626E-02, 4.9700623290E-02, 4.1238574918E-01],
	[6.5450000000E+03, 2.4251005123E+00, 6.9304151737E+00, 5.1234752910E-02, 4.9814075559E-02, 4.1257964910E-01],
	[6.5500000000E+03, 2.4274084231E+00, 6.9280563901E+00, 5.1354049213E-02, 4.9927695251E-02, 4.1277341640E-01],
	[6.5550000000E+03, 2.4297167667E+00, 6.9257002082E+00, 5.1473531683E-02, 5.0041482467E-02, 4.1296705146E-01],
	[6.5600000000E+03, 2.4320262608E+00, 6.9233505341E+00, 5.1593200467E-02, 5.0155437816E-02, 4.1316055465E-01],
	[6.5650000000E+03, 2.4343438437E+00, 6.9210450934E+00, 5.1713055713E-02, 5.0269566353E-02, 4.1335392634E-01],
	[6.5700000000E+03, 2.4366618681E+00, 6.9187421748E+00, 5.1833097568E-02, 5.0383862755E-02, 4.1354716689E-01],
	[6.5750000000E+03, 2.4389803339E+00, 6.9164417735E+00, 5.1953326180E-02, 5.0498327122E-02, 4.1374027667E-01],
	[6.5800000000E+03, 2.4412992407E+00, 6.9141438849E+00, 5.2073741697E-02, 5.0612959553E-02, 4.1393325605E-01],
	[6.5850000000E+03, 2.4436185884E+00, 6.9118485043E+00, 5.2194344265E-02, 5.0727760148E-02, 4.1412610539E-01],
	[6.5900000000E+03, 2.4459383766E+00, 6.9095556271E+00, 5.2315134033E-02, 5.0842729005E-02, 4.1431882506E-01],
	[6.5950000000E+03, 2.4482586051E+00, 6.9072652487E+00, 5.2436111147E-02, 5.0957866223E-02, 4.1451141542E-01],
	[6.6000000000E+03, 2.4505792736E+00, 6.9049773644E+00, 5.2557275757E-02, 5.1073171900E-02, 4.1470387684E-01],
	[6.6050000000E+03, 2.4529003820E+00, 6.9026919696E+00, 5.2678628008E-02, 5.1188646137E-02, 4.1489620966E-01],
	[6.6100000000E+03, 2.4552219300E+00, 6.9004090598E+00, 5.2800168050E-02, 5.1304289030E-02, 4.1508841426E-01],
	[6.6150000000E+03, 2.4575439172E+00, 6.8981286304E+00, 5.2921896028E-02, 5.1420100680E-02, 4.1528049098E-01],
	[6.6200000000E+03, 2.4598663436E+00, 6.8958506767E+00, 5.3043812092E-02, 5.1536081184E-02, 4.1547244020E-01],
	[6.6250000000E+03, 2.4621892087E+00, 6.8935751944E+00, 5.3165916388E-02, 5.1652230640E-02, 4.1566426226E-01],
	[6.6300000000E+03, 2.4645125124E+00, 6.8913021787E+00, 5.3288209063E-02, 5.1768549148E-02, 4.1585595751E-01],
	[6.6350000000E+03, 2.4668362545E+00, 6.8890316252E+00, 5.3410690267E-02, 5.1885036804E-02, 4.1604752633E-01],
	[6.6400000000E+03, 2.4691604346E+00, 6.8867635294E+00, 5.3533360146E-02, 5.2001693708E-02, 4.1623896905E-01],
	[6.6450000000E+03, 2.4714850525E+00, 6.8844978867E+00, 5.3656218848E-02, 5.2118519957E-02, 4.1643028604E-01],
	[6.6500000000E+03, 2.4738101080E+00, 6.8822346926E+00, 5.3779266520E-02, 5.2235515649E-02, 4.1662147763E-01],
	[6.6550000000E+03, 2.4761356008E+00, 6.8799739428E+00, 5.3902503310E-02, 5.2352680882E-02, 4.1681254419E-01],
	[6.6600000000E+03, 2.4784615307E+00, 6.8777156326E+00, 5.4025929365E-02, 5.2470015754E-02, 4.1700348607E-01],
	[6.6650000000E+03, 2.4807878975E+00, 6.8754597577E+00, 5.4149544834E-02, 5.2587520363E-02, 4.1719430360E-01],
	[6.6700000000E+03, 2.4831224485E+00, 6.8732484828E+00, 5.4273349864E-02, 5.2705200775E-02, 4.1738499715E-01],
	[6.6750000000E+03, 2.4854577195E+00, 6.8710410698E+00, 5.4397344602E-02, 5.2823051375E-02, 4.1757556705E-01],
	[6.6800000000E+03, 2.4877934357E+00, 6.8688360177E+00, 5.4521529196E-02, 5.2941072050E-02, 4.1776601365E-01],
	[6.6850000000E+03, 2.4901295968E+00, 6.8666333224E+00, 5.4645903794E-02, 5.3059262897E-02, 4.1795633730E-01],
	[6.6900000000E+03, 2.4924662025E+00, 6.8644329795E+00, 5.4770468543E-02, 5.3177624014E-02, 4.1814653834E-01],
	[6.6950000000E+03, 2.4948032526E+00, 6.8622349848E+00, 5.4895223591E-02, 5.3296155497E-02, 4.1833661711E-01],
	[6.7000000000E+03, 2.4971407468E+00, 6.8600393340E+00, 5.5020169085E-02, 5.3414857445E-02, 4.1852657395E-01],
	[6.7050000000E+03, 2.4994786850E+00, 6.8578460229E+00, 5.5145305174E-02, 5.3533729953E-02, 4.1871640922E-01],
	[6.7100000000E+03, 2.5018170668E+00, 6.8556550472E+00, 5.5270632004E-02, 5.3652773120E-02, 4.1890612324E-01],
	[6.7150000000E+03, 2.5041558921E+00, 6.8534664027E+00, 5.5396149724E-02, 5.3771987042E-02, 4.1909571635E-01],
	[6.7200000000E+03, 2.5064951605E+00, 6.8512800852E+00, 5.5521858481E-02, 5.3891371816E-02, 4.1928518890E-01],
	[6.7250000000E+03, 2.5088348718E+00, 6.8490960906E+00, 5.5647758422E-02, 5.4010927539E-02, 4.1947454122E-01],
	[6.7300000000E+03, 2.5111750258E+00, 6.8469144145E+00, 5.5773849696E-02, 5.4130654307E-02, 4.1966377364E-01],
	[6.7350000000E+03, 2.5135156222E+00, 6.8447350528E+00, 5.5900132450E-02, 5.4250552218E-02, 4.1985288651E-01],
	[6.7400000000E+03, 2.5158566608E+00, 6.8425580014E+00, 5.6026606831E-02, 5.4370621367E-02, 4.2004188016E-01],
	[6.7450000000E+03, 2.5181981414E+00, 6.8403832561E+00, 5.6153272988E-02, 5.4490861851E-02, 4.2023075491E-01],
	[6.7500000000E+03, 2.5205400636E+00, 6.8382108128E+00, 5.6280131067E-02, 5.4611273767E-02, 4.2041951111E-01],
	[6.7550000000E+03, 2.5228824273E+00, 6.8360406672E+00, 5.6407181218E-02, 5.4731857210E-02, 4.2060814908E-01],
	[6.7600000000E+03, 2.5252252322E+00, 6.8338728153E+00, 5.6534423586E-02, 5.4852612277E-02, 4.2079666917E-01],
	[6.7650000000E+03, 2.5275684781E+00, 6.8317072530E+00, 5.6661858320E-02, 5.4973539064E-02, 4.2098507168E-01],
	[6.7700000000E+03, 2.5299121647E+00, 6.8295439761E+00, 5.6789485568E-02, 5.5094637666E-02, 4.2117335697E-01],
	[6.7750000000E+03, 2.5322601691E+00, 6.8274041457E+00, 5.6917305478E-02, 5.5215911408E-02, 4.2136152534E-01],
	[6.7800000000E+03, 2.5346124098E+00, 6.8252872364E+00, 5.7045318196E-02, 5.5337360347E-02, 4.2154957714E-01],
	[6.7850000000E+03, 2.5369650991E+00, 6.8231725432E+00, 5.7173523871E-02, 5.5458981436E-02, 4.2173751269E-01],
	[6.7900000000E+03, 2.5393182368E+00, 6.8210600623E+00, 5.7301922650E-02, 5.5580774770E-02, 4.2192533231E-01],
	[6.7950000000E+03, 2.5416718225E+00, 6.8189497897E+00, 5.7430514681E-02, 5.5702740446E-02, 4.2211303633E-01],
	[6.8000000000E+03, 2.5440258560E+00, 6.8168417215E+00, 5.7559300111E-02, 5.5824878558E-02, 4.2230062507E-01],
	[6.8050000000E+03, 2.5463803370E+00, 6.8147358538E+00, 5.7688279089E-02, 5.5947189202E-02, 4.2248809886E-01],
	[6.8100000000E+03, 2.5487352654E+00, 6.8126321826E+00, 5.7817451762E-02, 5.6069672475E-02, 4.2267545801E-01],
	[6.8150000000E+03, 2.5510906409E+00, 6.8105307041E+00, 5.7946818278E-02, 5.6192328470E-02, 4.2286270286E-01],
	[6.8200000000E+03, 2.5534464633E+00, 6.8084314143E+00, 5.8076378784E-02, 5.6315157284E-02, 4.2304983372E-01],
	[6.8250000000E+03, 2.5558027322E+00, 6.8063343095E+00, 5.8206133429E-02, 5.6438159011E-02, 4.2323685090E-01],
	[6.8300000000E+03, 2.5581594475E+00, 6.8042393856E+00, 5.8336082359E-02, 5.6561333747E-02, 4.2342375474E-01],
	[6.8350000000E+03, 2.5605166089E+00, 6.8021466389E+00, 5.8466225723E-02, 5.6684681586E-02, 4.2361054554E-01],
	[6.8400000000E+03, 2.5628742162E+00, 6.8000560655E+00, 5.8596563667E-02, 5.6808202624E-02, 4.2379722363E-01],
	[6.8450000000E+03, 2.5652322691E+00, 6.7979676615E+00, 5.8727096341E-02, 5.6931896955E-02, 4.2398378932E-01],
	[6.8500000000E+03, 2.5675907674E+00, 6.7958814232E+00, 5.8857823892E-02, 5.7055764673E-02, 4.2417024293E-01],
	[6.8550000000E+03, 2.5699497108E+00, 6.7937973466E+00, 5.8988746467E-02, 5.7179805874E-02, 4.2435658477E-01],
	[6.8600000000E+03, 2.5723090992E+00, 6.7917154281E+00, 5.9119864214E-02, 5.7304020653E-02, 4.2454281516E-01],
	[6.8650000000E+03, 2.5746689322E+00, 6.7896356637E+00, 5.9251177281E-02, 5.7428409102E-02, 4.2472893440E-01],
	[6.8700000000E+03, 2.5770292096E+00, 6.7875580496E+00, 5.9382685815E-02, 5.7552971318E-02, 4.2491494282E-01],
	[6.8750000000E+03, 2.5793899313E+00, 6.7854825822E+00, 5.9514389965E-02, 5.7677707393E-02, 4.2510084073E-01],
	[6.8800000000E+03, 2.5817510969E+00, 6.7834092576E+00, 5.9646289878E-02, 5.7802617422E-02, 4.2528662843E-01],
	[6.8850000000E+03, 2.5841178260E+00, 6.7813661398E+00, 5.9778385702E-02, 5.7927706121E-02, 4.2547230623E-01],
	[6.8900000000E+03, 2.5864871975E+00, 6.7793371294E+00, 5.9910677584E-02, 5.8052970980E-02, 4.2565787445E-01],
	[6.8950000000E+03, 2.5888570204E+00, 6.7773101974E+00, 6.0043165672E-02, 5.8178410122E-02, 4.2584333340E-01],
	[6.9000000000E+03, 2.5912272943E+00, 6.7752853400E+00, 6.0175850114E-02, 5.8304023642E-02, 4.2602868337E-01],
	[6.9050000000E+03, 2.5935980191E+00, 6.7732625537E+00, 6.0308731058E-02, 5.8429811634E-02, 4.2621392469E-01],
	[6.9100000000E+03, 2.5959691944E+00, 6.7712418349E+00, 6.0441808652E-02, 5.8555774190E-02, 4.2639905765E-01],
	[6.9150000000E+03, 2.5983408201E+00, 6.7692231799E+00, 6.0575083043E-02, 5.8681911406E-02, 4.2658408256E-01],
	[6.9200000000E+03, 2.6007128959E+00, 6.7672065852E+00, 6.0708554379E-02, 5.8808223373E-02, 4.2676899972E-01],
	[6.9250000000E+03, 2.6030854215E+00, 6.7651920471E+00, 6.0842222807E-02, 5.8934710187E-02, 4.2695380945E-01],
	[6.9300000000E+03, 2.6054583967E+00, 6.7631795620E+00, 6.0976088476E-02, 5.9061371940E-02, 4.2713851204E-01],
	[6.9350000000E+03, 2.6078318214E+00, 6.7611691265E+00, 6.1110151534E-02, 5.9188208725E-02, 4.2732310780E-01],
	[6.9400000000E+03, 2.6102056951E+00, 6.7591607370E+00, 6.1244412127E-02, 5.9315220637E-02, 4.2750759702E-01],
	[6.9450000000E+03, 2.6125800178E+00, 6.7571543898E+00, 6.1378870404E-02, 5.9442407767E-02, 4.2769198001E-01],
	[6.9500000000E+03, 2.6149547891E+00, 6.7551500815E+00, 6.1513526513E-02, 5.9569770209E-02, 4.2787625708E-01],
	[6.9550000000E+03, 2.6173300089E+00, 6.7531478084E+00, 6.1648380602E-02, 5.9697308057E-02, 4.2806042851E-01],
	[6.9600000000E+03, 2.6197056769E+00, 6.7511475672E+00, 6.1783432817E-02, 5.9825021402E-02, 4.2824449461E-01],
	[6.9650000000E+03, 2.6220817928E+00, 6.7491493542E+00, 6.1918683307E-02, 5.9952910337E-02, 4.2842845568E-01],
	[6.9700000000E+03, 2.6244583564E+00, 6.7471531659E+00, 6.2054132220E-02, 6.0080974956E-02, 4.2861231201E-01],
	[6.9750000000E+03, 2.6268353675E+00, 6.7451589990E+00, 6.2189779704E-02, 6.0209215350E-02, 4.2879606391E-01],
	[6.9800000000E+03, 2.6292128258E+00, 6.7431668497E+00, 6.2325625906E-02, 6.0337631613E-02, 4.2897971166E-01],
	[6.9850000000E+03, 2.6315907311E+00, 6.7411767148E+00, 6.2461670974E-02, 6.0466223836E-02, 4.2916325557E-01],
	[6.9900000000E+03, 2.6339690832E+00, 6.7391885906E+00, 6.2597915056E-02, 6.0594992112E-02, 4.2934669592E-01],
	[6.9950000000E+03, 2.6363516697E+00, 6.7372233443E+00, 6.2734358300E-02, 6.0723940238E-02, 4.2953003302E-01],
	[7.0000000000E+03, 2.6387378879E+00, 6.7352775827E+00, 6.2871000853E-02, 6.0853067749E-02, 4.2971326715E-01],
	[7.0050000000E+03, 2.6411245598E+00, 6.7333337718E+00, 6.3009219422E-02, 6.0983661115E-02, 4.2989639861E-01],
	[7.0100000000E+03, 2.6435116852E+00, 6.7313919082E+00, 6.3147642661E-02, 6.1114435426E-02, 4.3007942768E-01],
	[7.0150000000E+03, 2.6458992637E+00, 6.7294519886E+00, 6.3286270724E-02, 6.1245390779E-02, 4.3026235468E-01],
	[7.0200000000E+03, 2.6482872952E+00, 6.7275140097E+00, 6.3425103770E-02, 6.1376527273E-02, 4.3044517987E-01],
	[7.0250000000E+03, 2.6506757794E+00, 6.7255779681E+00, 6.3564141953E-02, 6.1507845006E-02, 4.3062790355E-01],
	[7.0300000000E+03, 2.6530647161E+00, 6.7236438606E+00, 6.3703385430E-02, 6.1639344074E-02, 4.3081052602E-01],
	[7.0350000000E+03, 2.6554541050E+00, 6.7217116838E+00, 6.3842834357E-02, 6.1771024576E-02, 4.3099304756E-01],
	[7.0400000000E+03, 2.6578439459E+00, 6.7197814344E+00, 6.3982488890E-02, 6.1902886609E-02, 4.3117546845E-01],
	[7.0450000000E+03, 2.6602342387E+00, 6.7178531092E+00, 6.4122349186E-02, 6.2034930271E-02, 4.3135778899E-01],
	[7.0500000000E+03, 2.6626249829E+00, 6.7159267048E+00, 6.4262415401E-02, 6.2167155659E-02, 4.3154000947E-01],
	[7.0550000000E+03, 2.6650161785E+00, 6.7140022181E+00, 6.4402687690E-02, 6.2299562869E-02, 4.3172213016E-01],
	[7.0600000000E+03, 2.6674078252E+00, 6.7120796456E+00, 6.4543166211E-02, 6.2432152000E-02, 4.3190415136E-01],
	[7.0650000000E+03, 2.6697999227E+00, 6.7101589842E+00, 6.4683851119E-02, 6.2564923148E-02, 4.3208607334E-01],
	[7.0700000000E+03, 2.6721924708E+00, 6.7082402306E+00, 6.4824742570E-02, 6.2697876410E-02, 4.3226789640E-01],
	[7.0750000000E+03, 2.6745854692E+00, 6.7063233816E+00, 6.4965840722E-02, 6.2831011883E-02, 4.3244962081E-01],
	[7.0800000000E+03, 2.6769789178E+00, 6.7044084339E+00, 6.5107145730E-02, 6.2964329663E-02, 4.3263124686E-01],
	[7.0850000000E+03, 2.6793728163E+00, 6.7024953843E+00, 6.3657325846E-02, 6.1608483387E-02, 4.3281277483E-01],
	[7.0900000000E+03, 2.6817671645E+00, 6.7005842297E+00, 6.3794969523E-02, 6.1738508318E-02, 4.3299420501E-01],
	[7.0950000000E+03, 2.6841619621E+00, 6.6986749667E+00, 6.3932812999E-02, 6.1868709747E-02, 4.3317553767E-01],
	[7.1000000000E+03, 2.6865572089E+00, 6.6967675921E+00, 6.4070856420E-02, 6.1999087766E-02, 4.3335677309E-01],
	[7.1050000000E+03, 2.6889531082E+00, 6.6948632205E+00, 6.4209099936E-02, 6.2129642672E-02, 4.3353791156E-01],
	[7.1100000000E+03, 2.6913559477E+00, 6.6929963467E+00, 6.4347543692E-02, 6.2260380908E-02, 4.3371895335E-01],
	[7.1150000000E+03, 2.6937592431E+00, 6.6911313054E+00, 6.4486187839E-02, 6.2391296056E-02, 4.3389989874E-01],
	[7.1200000000E+03, 2.6961629939E+00, 6.6892680934E+00, 6.4625032522E-02, 6.2522388208E-02, 4.3408074801E-01],
	[7.1250000000E+03, 2.6985672000E+00, 6.6874067076E+00, 6.4764077890E-02, 6.2653657455E-02, 4.3426150143E-01],
	[7.1300000000E+03, 2.7009718611E+00, 6.6855471451E+00, 6.4903324091E-02, 6.2785103889E-02, 4.3444215929E-01],
	[7.1350000000E+03, 2.7033769770E+00, 6.6836894027E+00, 6.5042771273E-02, 6.2916727600E-02, 4.3462272186E-01],
	[7.1400000000E+03, 2.7057825475E+00, 6.6818334773E+00, 6.5182419583E-02, 6.3048528679E-02, 4.3480318941E-01],
	[7.1450000000E+03, 2.7081885724E+00, 6.6799793660E+00, 6.5322269169E-02, 6.3180507219E-02, 4.3498356223E-01],
	[7.1500000000E+03, 2.7105950513E+00, 6.6781270656E+00, 6.5462320178E-02, 6.3312663310E-02, 4.3516384057E-01],
	[7.1550000000E+03, 2.7130019842E+00, 6.6762765732E+00, 6.5602572760E-02, 6.3444997042E-02, 4.3534402472E-01],
	[7.1600000000E+03, 2.7154093706E+00, 6.6744278858E+00, 6.5743027061E-02, 6.3577508506E-02, 4.3552411496E-01],
	[7.1650000000E+03, 2.7178172105E+00, 6.6725810002E+00, 6.5883683229E-02, 6.3710197794E-02, 4.3570411154E-01],
	[7.1700000000E+03, 2.7202255036E+00, 6.6707359135E+00, 6.6024541412E-02, 6.3843064995E-02, 4.3588401476E-01],
	[7.1750000000E+03, 2.7226342496E+00, 6.6688926228E+00, 6.6165601759E-02, 6.3976110201E-02, 4.3606382486E-01],
	[7.1800000000E+03, 2.7250434483E+00, 6.6670511249E+00, 6.6306864416E-02, 6.4109333501E-02, 4.3624354214E-01],
	[7.1850000000E+03, 2.7274530995E+00, 6.6652114169E+00, 6.6448329532E-02, 6.4242734986E-02, 4.3642316685E-01],
	[7.1900000000E+03, 2.7298632030E+00, 6.6633734958E+00, 6.6589997254E-02, 6.4376314746E-02, 4.3660269927E-01],
	[7.1950000000E+03, 2.7322737585E+00, 6.6615373587E+00, 6.6731867730E-02, 6.4510072871E-02, 4.3678213966E-01],
	[7.2000000000E+03, 2.7346847659E+00, 6.6597030025E+00, 6.6873941108E-02, 6.4644009452E-02, 4.3696148830E-01],
	[7.2050000000E+03, 2.7370962247E+00, 6.6578704244E+00, 6.7016217536E-02, 6.4778124577E-02, 4.3714074545E-01],
	[7.2100000000E+03, 2.7395081350E+00, 6.6560396213E+00, 6.7158697162E-02, 6.4912418337E-02, 4.3731991138E-01],
	[7.2150000000E+03, 2.7419204963E+00, 6.6542105903E+00, 6.7301380134E-02, 6.5046890822E-02, 4.3749898636E-01],
	[7.2200000000E+03, 2.7443343046E+00, 6.6523887697E+00, 6.7444266599E-02, 6.5181543206E-02, 4.3767797065E-01],
	[7.2250000000E+03, 2.7467540093E+00, 6.6505984153E+00, 6.7587356705E-02, 6.5316380444E-02, 4.3785686452E-01],
	[7.2300000000E+03, 2.7491741713E+00, 6.6488097808E+00, 6.7730650601E-02, 6.5451396725E-02, 4.3803566824E-01],
	[7.2350000000E+03, 2.7515947903E+00, 6.6470228634E+00, 6.7874148433E-02, 6.5586592137E-02, 4.3821438206E-01],
	[7.2400000000E+03, 2.7540158662E+00, 6.6452376602E+00, 6.8017850350E-02, 6.5721966769E-02, 4.3839300626E-01],
	[7.2450000000E+03, 2.7564373987E+00, 6.6434541684E+00, 6.8161756500E-02, 6.5857520712E-02, 4.3857154109E-01],
	[7.2500000000E+03, 2.7588593876E+00, 6.6416723852E+00, 6.8305867030E-02, 6.5993254055E-02, 4.3874998682E-01],
	[7.2550000000E+03, 2.7612818327E+00, 6.6398923078E+00, 6.8450182089E-02, 6.6129166886E-02, 4.3892834371E-01],
	[7.2600000000E+03, 2.7637047336E+00, 6.6381139333E+00, 6.8594701824E-02, 6.6265259294E-02, 4.3910661203E-01],
	[7.2650000000E+03, 2.7661280903E+00, 6.6363372590E+00, 6.8739426384E-02, 6.6401531369E-02, 4.3928479204E-01],
	[7.2700000000E+03, 2.7685519025E+00, 6.6345622821E+00, 6.8884355915E-02, 6.6537983199E-02, 4.3946288399E-01],
	[7.2750000000E+03, 2.7709761699E+00, 6.6327889998E+00, 6.9029490566E-02, 6.6674614874E-02, 4.3964088815E-01],
	[7.2800000000E+03, 2.7734008923E+00, 6.6310174093E+00, 6.9174830485E-02, 6.6811426481E-02, 4.3981880477E-01],
	[7.2850000000E+03, 2.7758260695E+00, 6.6292475078E+00, 6.9320375820E-02, 6.6948418110E-02, 4.3999663408E-01],
	[7.2900000000E+03, 2.7782517013E+00, 6.6274792926E+00, 6.9466126718E-02, 6.7085589848E-02, 4.4017437636E-01],
	[7.2950000000E+03, 2.7806777874E+00, 6.6257127608E+00, 6.9612083327E-02, 6.7222941785E-02, 4.4035203180E-01],
	[7.3000000000E+03, 2.7831043276E+00, 6.6239479099E+00, 6.9758245796E-02, 6.7360474008E-02, 4.4052960065E-01],
	[7.3050000000E+03, 2.7855313217E+00, 6.6221847369E+00, 6.9904614272E-02, 6.7498186606E-02, 4.4070708315E-01],
	[7.3100000000E+03, 2.7879587694E+00, 6.6204232392E+00, 7.0051188904E-02, 6.7636079666E-02, 4.4088447953E-01],
	[7.3150000000E+03, 2.7903866706E+00, 6.6186634140E+00, 7.0197969838E-02, 6.7774153278E-02, 4.4106179003E-01],
	[7.3200000000E+03, 2.7928150250E+00, 6.6169052585E+00, 7.0344957223E-02, 6.7912407527E-02, 4.4123901490E-01],
	[7.3250000000E+03, 2.7952438324E+00, 6.6151487702E+00, 7.0492151207E-02, 6.8050842503E-02, 4.4141615435E-01],
	[7.3300000000E+03, 2.7976730926E+00, 6.6133939462E+00, 7.0639551938E-02, 6.8189458293E-02, 4.4159320864E-01],
	[7.3350000000E+03, 2.8001028052E+00, 6.6116407839E+00, 7.0787159564E-02, 6.8328254984E-02, 4.4177017799E-01],
	[7.3400000000E+03, 2.8025386028E+00, 6.6099199002E+00, 7.0934974232E-02, 6.8467239312E-02, 4.4194706264E-01],
	[7.3450000000E+03, 2.8049754105E+00, 6.6082036333E+00, 7.1082996090E-02, 6.8606405414E-02, 4.4212386282E-01],
	[7.3500000000E+03, 2.8074126765E+00, 6.6064889795E+00, 7.1231225287E-02, 6.8745752731E-02, 4.4230057878E-01],
	[7.3550000000E+03, 2.8098504007E+00, 6.6047759363E+00, 7.1379661970E-02, 6.8885281348E-02, 4.4247721073E-01],
	[7.3600000000E+03, 2.8122885828E+00, 6.6030645009E+00, 7.1528306288E-02, 6.9024991354E-02, 4.4265375892E-01],
	[7.3650000000E+03, 2.8147272227E+00, 6.6013546708E+00, 7.1677158388E-02, 6.9164882836E-02, 4.4283022358E-01],
	[7.3700000000E+03, 2.8171663200E+00, 6.5996464433E+00, 7.1826218418E-02, 6.9304955880E-02, 4.4300660493E-01],
	[7.3750000000E+03, 2.8196058746E+00, 6.5979398160E+00, 7.1975486526E-02, 6.9445210574E-02, 4.4318290322E-01],
	[7.3800000000E+03, 2.8220458862E+00, 6.5962347862E+00, 7.2124962859E-02, 6.9585647005E-02, 4.4335911866E-01],
	[7.3850000000E+03, 2.8244863546E+00, 6.5945313513E+00, 7.2274647567E-02, 6.9726265259E-02, 4.4353525150E-01],
	[7.3900000000E+03, 2.8269272796E+00, 6.5928295088E+00, 7.2424540797E-02, 6.9867065423E-02, 4.4371130196E-01],
	[7.3950000000E+03, 2.8293686610E+00, 6.5911292561E+00, 7.2574642697E-02, 7.0008047584E-02, 4.4388727027E-01],
	[7.4000000000E+03, 2.8318104985E+00, 6.5894305907E+00, 7.2724953414E-02, 7.0149211828E-02, 4.4406315666E-01],
	[7.4050000000E+03, 2.8342527919E+00, 6.5877335100E+00, 7.2875473097E-02, 7.0290558242E-02, 4.4423896135E-01],
	[7.4100000000E+03, 2.8366955411E+00, 6.5860380114E+00, 7.3026201894E-02, 7.0432086911E-02, 4.4441468459E-01],
	[7.4150000000E+03, 2.8391387457E+00, 6.5843440924E+00, 7.3177139953E-02, 7.0573797923E-02, 4.4459032658E-01],
	[7.4200000000E+03, 2.8415824055E+00, 6.5826517505E+00, 7.3328287421E-02, 7.0715691363E-02, 4.4476588757E-01],
	[7.4250000000E+03, 2.8440265204E+00, 6.5809609831E+00, 7.3479644447E-02, 7.0857767317E-02, 4.4494136777E-01],
	[7.4300000000E+03, 2.8464710901E+00, 6.5792717877E+00, 7.3631211178E-02, 7.1000025871E-02, 4.4511676742E-01],
	[7.4350000000E+03, 2.8489161143E+00, 6.5775841619E+00, 7.3782987763E-02, 7.1142467111E-02, 4.4529208674E-01],
	[7.4400000000E+03, 2.8513615930E+00, 6.5758981030E+00, 7.3934974349E-02, 7.1285091123E-02, 4.4546732595E-01],
	[7.4450000000E+03, 2.8538075257E+00, 6.5742136087E+00, 7.4087171085E-02, 7.1427897991E-02, 4.4564248528E-01],
	[7.4500000000E+03, 2.8562539124E+00, 6.5725306763E+00, 7.4239578118E-02, 7.1570887803E-02, 4.4581756495E-01],
	[7.4550000000E+03, 2.8587024866E+00, 6.5708587131E+00, 7.4392195597E-02, 7.1714062854E-02, 4.4599256519E-01],
	[7.4600000000E+03, 2.8611557087E+00, 6.5692110267E+00, 7.4545023669E-02, 7.1857426398E-02, 4.4616748622E-01],
	[7.4650000000E+03, 2.8636093903E+00, 6.5675648570E+00, 7.4698062482E-02, 7.2000973192E-02, 4.4634232826E-01],
	[7.4700000000E+03, 2.8660635312E+00, 6.5659202016E+00, 7.4851312185E-02, 7.2144703321E-02, 4.4651709154E-01],
	[7.4750000000E+03, 2.8685181310E+00, 6.5642770581E+00, 7.5004772925E-02, 7.2288616870E-02, 4.4669177628E-01],
	[7.4800000000E+03, 2.8709731896E+00, 6.5626354242E+00, 7.5158444851E-02, 7.2432713925E-02, 4.4686638270E-01],
	[7.4850000000E+03, 2.8734287068E+00, 6.5609952973E+00, 7.5312328110E-02, 7.2576994569E-02, 4.4704091102E-01],
	[7.4900000000E+03, 2.8758846822E+00, 6.5593566752E+00, 7.5466422850E-02, 7.2721458889E-02, 4.4721536146E-01],
	[7.4950000000E+03, 2.8783411158E+00, 6.5577195555E+00, 7.5620729220E-02, 7.2866106969E-02, 4.4738973424E-01],
	[7.5000000000E+03, 2.8807980073E+00, 6.5560839357E+00, 7.5775247368E-02, 7.3010938894E-02, 4.4756402958E-01],
	[7.5050000000E+03, 2.8832553565E+00, 6.5544498135E+00, 7.5929977440E-02, 7.3155954748E-02, 4.4773824771E-01],
	[7.5100000000E+03, 2.8857131631E+00, 6.5528171866E+00, 7.6084919586E-02, 7.3301154615E-02, 4.4791238883E-01],
	[7.5150000000E+03, 2.8881714270E+00, 6.5511860525E+00, 7.6240073954E-02, 7.3446538581E-02, 4.4808645317E-01],
	[7.5200000000E+03, 2.8906301478E+00, 6.5495564089E+00, 7.6395440691E-02, 7.3592106730E-02, 4.4826044096E-01],
	[7.5250000000E+03, 2.8930893255E+00, 6.5479282535E+00, 7.6551019946E-02, 7.3737859145E-02, 4.4843435239E-01],
	[7.5300000000E+03, 2.8955489597E+00, 6.5463015839E+00, 7.6706811866E-02, 7.3883795911E-02, 4.4860818770E-01],
	[7.5350000000E+03, 2.8980090503E+00, 6.5446763977E+00, 7.6862816599E-02, 7.4029917112E-02, 4.4878194710E-01],
	[7.5400000000E+03, 2.9004695971E+00, 6.5430526927E+00, 7.7019034294E-02, 7.4176222832E-02, 4.4895563080E-01],
	[7.5450000000E+03, 2.9029305997E+00, 6.5414304665E+00, 7.7175465099E-02, 7.4322713154E-02, 4.4912923903E-01],
	[7.5500000000E+03, 2.9053920581E+00, 6.5398097168E+00, 7.7332109161E-02, 7.4469388162E-02, 4.4930277199E-01],
	[7.5550000000E+03, 2.9078539720E+00, 6.5381904412E+00, 7.7488966630E-02, 7.4616247940E-02, 4.4947622990E-01],
	[7.5600000000E+03, 2.9103163411E+00, 6.5365726375E+00, 7.7646037651E-02, 7.4763292571E-02, 4.4964961299E-01],
	[7.5650000000E+03, 2.9127791652E+00, 6.5349563033E+00, 7.7803322375E-02, 7.4910522139E-02, 4.4982292145E-01],
	[7.5700000000E+03, 2.9152424442E+00, 6.5333414364E+00, 7.7960820948E-02, 7.5057936727E-02, 4.4999615552E-01],
	[7.5750000000E+03, 2.9177078448E+00, 6.5317370773E+00, 7.8118533520E-02, 7.5205538724E-02, 4.5016931539E-01],
	[7.5800000000E+03, 2.9201777007E+00, 6.5301558434E+00, 7.8276460237E-02, 7.5353331471E-02, 4.5034240128E-01],
	[7.5850000000E+03, 2.9226480167E+00, 6.5285760346E+00, 7.8434601248E-02, 7.5501309540E-02, 4.5051541341E-01],
	[7.5900000000E+03, 2.9251187926E+00, 6.5269976487E+00, 7.8592956701E-02, 7.5649473014E-02, 4.5068835199E-01],
	[7.5950000000E+03, 2.9275900279E+00, 6.5254206834E+00, 7.8751526744E-02, 7.5797821975E-02, 4.5086121723E-01],
	[7.6000000000E+03, 2.9300617227E+00, 6.5238451366E+00, 7.8910311526E-02, 7.5946356506E-02, 4.5103400935E-01],
	[7.6050000000E+03, 2.9325338766E+00, 6.5222710060E+00, 7.9069311193E-02, 7.6095076690E-02, 4.5120672855E-01],
	[7.6100000000E+03, 2.9350064895E+00, 6.5206982894E+00, 7.9228525895E-02, 7.6243982610E-02, 4.5137937504E-01],
	[7.6150000000E+03, 2.9374795611E+00, 6.5191269847E+00, 7.9387955780E-02, 7.6393074349E-02, 4.5155194904E-01],
	[7.6200000000E+03, 2.9399530911E+00, 6.5175570896E+00, 7.9547600994E-02, 7.6542351988E-02, 4.5172445075E-01],
	[7.6250000000E+03, 2.9424270795E+00, 6.5159886020E+00, 7.9707461687E-02, 7.6691815611E-02, 4.5189688039E-01],
	[7.6300000000E+03, 2.9449015260E+00, 6.5144215197E+00, 7.9867538007E-02, 7.6841465299E-02, 4.5206923816E-01],
	[7.6350000000E+03, 2.9473764303E+00, 6.5128558405E+00, 8.0027830102E-02, 7.6991301134E-02, 4.5224152428E-01],
	[7.6400000000E+03, 2.9498517922E+00, 6.5112915621E+00, 8.0188338119E-02, 7.7141323199E-02, 4.5241373895E-01],
	[7.6450000000E+03, 2.9523276116E+00, 6.5097286826E+00, 8.0349062207E-02, 7.7291531576E-02, 4.5258588238E-01],
	[7.6500000000E+03, 2.9548038882E+00, 6.5081671996E+00, 8.0510002514E-02, 7.7441926346E-02, 4.5275795478E-01],
	[7.6550000000E+03, 2.9572806218E+00, 6.5066071110E+00, 8.0671159188E-02, 7.7592507592E-02, 4.5292995636E-01],
	[7.6600000000E+03, 2.9597578121E+00, 6.5050484148E+00, 8.0832532378E-02, 7.7743275394E-02, 4.5310188732E-01],
	[7.6650000000E+03, 2.9622354591E+00, 6.5034911086E+00, 8.0994122230E-02, 7.7894229835E-02, 4.5327374787E-01],
	[7.6700000000E+03, 2.9647135624E+00, 6.5019351904E+00, 8.1155928894E-02, 7.8045370995E-02, 4.5344553822E-01],
	[7.6750000000E+03, 2.9671921218E+00, 6.5003806581E+00, 8.1317952517E-02, 7.8196698957E-02, 4.5361725857E-01],
	[7.6800000000E+03, 2.9696711372E+00, 6.4988275095E+00, 8.1480193248E-02, 7.8348213801E-02, 4.5378890913E-01],
	[7.6850000000E+03, 2.9721506083E+00, 6.4972757424E+00, 8.1642651235E-02, 7.8499915609E-02, 4.5396049010E-01],
	[7.6900000000E+03, 2.9746305348E+00, 6.4957253548E+00, 8.1805326625E-02, 7.8651804461E-02, 4.5413200169E-01],
	[7.6950000000E+03, 2.9771109167E+00, 6.4941763445E+00, 8.1968219567E-02, 7.8803880439E-02, 4.5430344411E-01],
	[7.7000000000E+03, 2.9795966687E+00, 6.4926553991E+00, 8.2131330209E-02, 7.8956151021E-02, 4.5447481756E-01],
	[7.7050000000E+03, 2.9820833693E+00, 6.4911384484E+00, 8.2294658700E-02, 7.9108609677E-02, 4.5464612224E-01],
	[7.7100000000E+03, 2.9845705300E+00, 6.4896228358E+00, 8.2458205186E-02, 7.9261255753E-02, 4.5481735835E-01],
	[7.7150000000E+03, 2.9870581507E+00, 6.4881085594E+00, 8.2621969817E-02, 7.9414089331E-02, 4.5498852610E-01],
	[7.7200000000E+03, 2.9895462312E+00, 6.4865956169E+00, 8.2785952740E-02, 7.9567110492E-02, 4.5515962570E-01],
	[7.7250000000E+03, 2.9920347711E+00, 6.4850840066E+00, 8.2950154104E-02, 7.9720319316E-02, 4.5533065734E-01],
	[7.7300000000E+03, 2.9945237704E+00, 6.4835737262E+00, 8.3114574057E-02, 7.9873715883E-02, 4.5550162123E-01],
	[7.7350000000E+03, 2.9970132287E+00, 6.4820647737E+00, 8.3279212747E-02, 8.0027300274E-02, 4.5567251756E-01],
	[7.7400000000E+03, 2.9995031459E+00, 6.4805571472E+00, 8.3444070322E-02, 8.0181072568E-02, 4.5584334650E-01],
	[7.7450000000E+03, 3.0019935218E+00, 6.4790508446E+00, 8.3609146930E-02, 8.0335032846E-02, 4.5601410824E-01],
	[7.7500000000E+03, 3.0044843561E+00, 6.4775458639E+00, 8.3774442719E-02, 8.0489181188E-02, 4.5618480295E-01],
	[7.7550000000E+03, 3.0069756486E+00, 6.4760422031E+00, 8.3939957838E-02, 8.0643517674E-02, 4.5635543081E-01],
	[7.7600000000E+03, 3.0094673992E+00, 6.4745398602E+00, 8.4105692434E-02, 8.0798042383E-02, 4.5652599201E-01],
	[7.7650000000E+03, 3.0119596076E+00, 6.4730388332E+00, 8.4271646657E-02, 8.0952755396E-02, 4.5669648672E-01],
	[7.7700000000E+03, 3.0144522737E+00, 6.4715391200E+00, 8.4437820653E-02, 8.1107656791E-02, 4.5686691512E-01],
	[7.7750000000E+03, 3.0169453971E+00, 6.4700407187E+00, 8.4604214571E-02, 8.1262746649E-02, 4.5703727739E-01],
	[7.7800000000E+03, 3.0194389777E+00, 6.4685436273E+00, 8.4770828560E-02, 8.1418025048E-02, 4.5720757370E-01],
	[7.7850000000E+03, 3.0219330153E+00, 6.4670478439E+00, 8.4937662767E-02, 8.1573492068E-02, 4.5737780423E-01],
	[7.7900000000E+03, 3.0244275096E+00, 6.4655533663E+00, 8.5104717340E-02, 8.1729147787E-02, 4.5754796917E-01],
	[7.7950000000E+03, 3.0269224605E+00, 6.4640601927E+00, 8.5271992428E-02, 8.1884992286E-02, 4.5771806868E-01],
	[7.8000000000E+03, 3.0294178678E+00, 6.4625683211E+00, 8.5439488180E-02, 8.2041025643E-02, 4.5788810294E-01],
	[7.8050000000E+03, 3.0319137311E+00, 6.4610777494E+00, 8.5607204742E-02, 8.2197247936E-02, 4.5805807213E-01],
	[7.8100000000E+03, 3.0344100505E+00, 6.4595884759E+00, 8.5775142264E-02, 8.2353659245E-02, 4.5822797643E-01],
	[7.8150000000E+03, 3.0369068255E+00, 6.4581004984E+00, 8.5943300893E-02, 8.2510259648E-02, 4.5839781601E-01],
	[7.8200000000E+03, 3.0394047358E+00, 6.4566175239E+00, 8.6111680778E-02, 8.2667050334E-02, 4.5856759104E-01],
	[7.8250000000E+03, 3.0419075614E+00, 6.4551601433E+00, 8.6280282066E-02, 8.2824037586E-02, 4.5873730171E-01],
	[7.8300000000E+03, 3.0444108473E+00, 6.4537040222E+00, 8.6449104907E-02, 8.2981214222E-02, 4.5890694818E-01],
	[7.8350000000E+03, 3.0469145932E+00, 6.4522491589E+00, 8.6618149448E-02, 8.3138580319E-02, 4.5907653063E-01],
	[7.8400000000E+03, 3.0494187990E+00, 6.4507955513E+00, 8.6787415837E-02, 8.3296135957E-02, 4.5924604924E-01],
	[7.8450000000E+03, 3.0519234644E+00, 6.4493431977E+00, 8.6956904223E-02, 8.3453881214E-02, 4.5941550417E-01],
	[7.8500000000E+03, 3.0544285893E+00, 6.4478920961E+00, 8.7126614753E-02, 8.3611816167E-02, 4.5958489561E-01],
	[7.8550000000E+03, 3.0569341733E+00, 6.4464422447E+00, 8.7296547577E-02, 8.3769940895E-02, 4.5975422372E-01],
	[7.8600000000E+03, 3.0594402164E+00, 6.4449936415E+00, 8.7466702842E-02, 8.3928255475E-02, 4.5992348868E-01],
	[7.8650000000E+03, 3.0619467182E+00, 6.4435462848E+00, 8.7637080696E-02, 8.4086759986E-02, 4.6009269067E-01],
	[7.8700000000E+03, 3.0644536787E+00, 6.4421001726E+00, 8.7807681288E-02, 8.4245454505E-02, 4.6026182984E-01],
	[7.8750000000E+03, 3.0669610975E+00, 6.4406553031E+00, 8.7978504765E-02, 8.4404339109E-02, 4.6043090639E-01],
	[7.8800000000E+03, 3.0694689745E+00, 6.4392116745E+00, 8.8149551277E-02, 8.4563413876E-02, 4.6059992047E-01],
	[7.8850000000E+03, 3.0719773095E+00, 6.4377692849E+00, 8.8320820971E-02, 8.4722678884E-02, 4.6076887226E-01],
	[7.8900000000E+03, 3.0744861023E+00, 6.4363281324E+00, 8.8492313995E-02, 8.4882134209E-02, 4.6093776194E-01],
	[7.8950000000E+03, 3.0769953526E+00, 6.4348882152E+00, 8.8664030498E-02, 8.5041779928E-02, 4.6110658966E-01],
	[7.9000000000E+03, 3.0795050602E+00, 6.4334495314E+00, 8.8835970628E-02, 8.5201616120E-02, 4.6127535561E-01],
	[7.9050000000E+03, 3.0820152250E+00, 6.4320120793E+00, 8.9008134533E-02, 8.5361642859E-02, 4.6144405996E-01],
	[7.9100000000E+03, 3.0845258468E+00, 6.4305758569E+00, 8.9180522361E-02, 8.5521860225E-02, 4.6161270287E-01],
	[7.9150000000E+03, 3.0870369252E+00, 6.4291408626E+00, 8.9353134262E-02, 8.5682268292E-02, 4.6178128452E-01],
	[7.9200000000E+03, 3.0895484602E+00, 6.4277070943E+00, 8.9525970381E-02, 8.5842867138E-02, 4.6194980507E-01],
	[7.9250000000E+03, 3.0920604516E+00, 6.4262745504E+00, 8.9699030869E-02, 8.6003656840E-02, 4.6211826469E-01],
	[7.9300000000E+03, 3.0945728990E+00, 6.4248432290E+00, 8.9872315874E-02, 8.6164637472E-02, 4.6228666356E-01],
	[7.9350000000E+03, 3.0970858024E+00, 6.4234131282E+00, 9.0045825542E-02, 8.6325809113E-02, 4.6245500184E-01],
	[7.9400000000E+03, 3.0995991614E+00, 6.4219842463E+00, 9.0219560024E-02, 8.6487171838E-02, 4.6262327971E-01],
	[7.9450000000E+03, 3.1021129760E+00, 6.4205565815E+00, 9.0393519466E-02, 8.6648725722E-02, 4.6279149732E-01],
	[7.9500000000E+03, 3.1046319080E+00, 6.4191556977E+00, 9.0567704018E-02, 8.6810479164E-02, 4.6295965485E-01],
	[7.9550000000E+03, 3.1071515134E+00, 6.4177571709E+00, 9.0742113828E-02, 8.6972424353E-02, 4.6312775248E-01],
	[7.9600000000E+03, 3.1096715785E+00, 6.4163598272E+00, 9.0916749043E-02, 8.7134560985E-02, 4.6329579035E-01],
	[7.9650000000E+03, 3.1121921032E+00, 6.4149636649E+00, 9.1091609812E-02, 8.7296889136E-02, 4.6346376865E-01],
	[7.9700000000E+03, 3.1147130872E+00, 6.4135686823E+00, 9.1266696284E-02, 8.7459408882E-02, 4.6363168754E-01],
	[7.9750000000E+03, 3.1172345303E+00, 6.4121748777E+00, 9.1442008606E-02, 8.7622120298E-02, 4.6379954719E-01],
	[7.9800000000E+03, 3.1197564323E+00, 6.4107822492E+00, 9.1617546927E-02, 8.7785023461E-02, 4.6396734776E-01],
	[7.9850000000E+03, 3.1222787930E+00, 6.4093907952E+00, 9.1793311395E-02, 8.7948118444E-02, 4.6413508942E-01],
	[7.9900000000E+03, 3.1248016123E+00, 6.4080005140E+00, 9.1969302158E-02, 8.8111405325E-02, 4.6430277233E-01],
	[7.9950000000E+03, 3.1273248898E+00, 6.4066114038E+00, 9.2145519365E-02, 8.8274884177E-02, 4.6447039668E-01],
	[8.0000000000E+03, 3.1298486254E+00, 6.4052234629E+00, 9.2321963164E-02, 8.8438555076E-02, 4.6463796261E-01],
	[8.0050000000E+03, 3.1323728189E+00, 6.4038366896E+00, 9.2499504087E-02, 8.8603216701E-02, 4.6480547029E-01],
	[8.0100000000E+03, 3.1348974701E+00, 6.4024510821E+00, 9.2677274694E-02, 8.8768072891E-02, 4.6497291990E-01],
	[8.0150000000E+03, 3.1374225788E+00, 6.4010666389E+00, 9.2855275135E-02, 8.8933123725E-02, 4.6514031159E-01],
	[8.0200000000E+03, 3.1399481447E+00, 6.3996833581E+00, 9.3033505564E-02, 8.9098369279E-02, 4.6530764553E-01],
	[8.0250000000E+03, 3.1424741678E+00, 6.3983012382E+00, 9.3211966132E-02, 8.9263809630E-02, 4.6547492189E-01],
	[8.0300000000E+03, 3.1450006477E+00, 6.3969202773E+00, 9.3390656993E-02, 8.9429444855E-02, 4.6564214082E-01],
	[8.0350000000E+03, 3.1475275843E+00, 6.3955404737E+00, 9.3569578297E-02, 8.9595275031E-02, 4.6580930251E-01],
	[8.0400000000E+03, 3.1500549774E+00, 6.3941618259E+00, 9.3748730199E-02, 8.9761300235E-02, 4.6597640710E-01],
	[8.0450000000E+03, 3.1525828267E+00, 6.3927843321E+00, 9.3928112849E-02, 8.9927520543E-02, 4.6614345476E-01],
	[8.0500000000E+03, 3.1551111321E+00, 6.3914079906E+00, 9.4107726401E-02, 9.0093936031E-02, 4.6631044565E-01],
	[8.0550000000E+03, 3.1576398934E+00, 6.3900327998E+00, 9.4287571006E-02, 9.0260546777E-02, 4.6647737995E-01],
	[8.0600000000E+03, 3.1601691104E+00, 6.3886587579E+00, 9.4467646817E-02, 9.0427352856E-02, 4.6664425781E-01],
	[8.0650000000E+03, 3.1626987828E+00, 6.3872858634E+00, 9.4647953986E-02, 9.0594354345E-02, 4.6681107939E-01],
	[8.0700000000E+03, 3.1652289105E+00, 6.3859141144E+00, 9.4828492666E-02, 9.0761551319E-02, 4.6697784486E-01],
	[8.0750000000E+03, 3.1677612445E+00, 6.3845530829E+00, 9.5009263009E-02, 9.0928947240E-02, 4.6714455438E-01],
	[8.0800000000E+03, 3.1702969585E+00, 6.3832091482E+00, 9.5190265166E-02, 9.1096544484E-02, 4.6731120812E-01],
	[8.0850000000E+03, 3.1728331316E+00, 6.3818663276E+00, 9.5371499292E-02, 9.1264337499E-02, 4.6747780623E-01],
	[8.0900000000E+03, 3.1753697639E+00, 6.3805246194E+00, 9.5552965537E-02, 9.1432326360E-02, 4.6764434887E-01],
	[8.0950000000E+03, 3.1779068549E+00, 6.3791840220E+00, 9.5734664055E-02, 9.1600511143E-02, 4.6781083621E-01],
	[8.1000000000E+03, 3.1804444047E+00, 6.3778445338E+00, 9.5916594997E-02, 9.1768891923E-02, 4.6797726842E-01],
	[8.1050000000E+03, 3.1829824128E+00, 6.3765061531E+00, 9.6098758516E-02, 9.1937468776E-02, 4.6814364564E-01],
	[8.1100000000E+03, 3.1855208792E+00, 6.3751688785E+00, 9.6281154764E-02, 9.2106241777E-02, 4.6830996804E-01],
	[8.1150000000E+03, 3.1880598037E+00, 6.3738327083E+00, 9.6463783895E-02, 9.2275211002E-02, 4.6847623579E-01],
	[8.1200000000E+03, 3.1905991860E+00, 6.3724976408E+00, 9.6646646059E-02, 9.2444376525E-02, 4.6864244904E-01],
	[8.1250000000E+03, 3.1931390259E+00, 6.3711636746E+00, 9.6829741409E-02, 9.2613738422E-02, 4.6880860796E-01],
	[8.1300000000E+03, 3.1956793233E+00, 6.3698308080E+00, 9.7013070099E-02, 9.2783296767E-02, 4.6897471269E-01],
	[8.1350000000E+03, 3.1982200780E+00, 6.3684990395E+00, 9.7196632280E-02, 9.2953051636E-02, 4.6914076341E-01],
	[8.1400000000E+03, 3.2007612897E+00, 6.3671683675E+00, 9.7380428104E-02, 9.3123003103E-02, 4.6930676027E-01],
	[8.1450000000E+03, 3.2033029582E+00, 6.3658387903E+00, 9.7564457724E-02, 9.3293151243E-02, 4.6947270344E-01],
	[8.1500000000E+03, 3.2058450834E+00, 6.3645103065E+00, 9.7748721293E-02, 9.3463496130E-02, 4.6963859304E-01],
	[8.1550000000E+03, 3.2083876651E+00, 6.3631829144E+00, 9.7933218962E-02, 9.3634037838E-02, 4.6980442922E-01],
	[8.1600000000E+03, 3.2109307030E+00, 6.3618566125E+00, 9.8117950885E-02, 9.3804776442E-02, 4.6997021211E-01],
	[8.1650000000E+03, 3.2134741969E+00, 6.3605313993E+00, 9.8302917213E-02, 9.3975712016E-02, 4.7013594185E-01],
	[8.1700000000E+03, 3.2160181467E+00, 6.3592072731E+00, 9.8488118099E-02, 9.4146844634E-02, 4.7030161857E-01],
	[8.1750000000E+03, 3.2185625522E+00, 6.3578842324E+00, 9.8673553695E-02, 9.4318174370E-02, 4.7046724242E-01],
	[8.1800000000E+03, 3.2211074132E+00, 6.3565622757E+00, 9.8859224155E-02, 9.4489701297E-02, 4.7063281351E-01],
	[8.1850000000E+03, 3.2236527294E+00, 6.3552414014E+00, 9.9045129629E-02, 9.4661425489E-02, 4.7079833200E-01],
	[8.1900000000E+03, 3.2261985007E+00, 6.3539216080E+00, 9.9231270272E-02, 9.4833347021E-02, 4.7096379801E-01],
	[8.1950000000E+03, 3.2287447269E+00, 6.3526028939E+00, 9.9417646234E-02, 9.5005465965E-02, 4.7112921168E-01],
	[8.2000000000E+03, 3.2312914077E+00, 6.3512852575E+00, 9.9604257669E-02, 9.5177782394E-02, 4.7129457315E-01],
	[8.2050000000E+03, 3.2338402689E+00, 6.3499780120E+00, 9.9791104729E-02, 9.5350299983E-02, 4.7145988254E-01],
	[8.2100000000E+03, 3.2363923855E+00, 6.3486869266E+00, 9.9978187566E-02, 9.5523021082E-02, 4.7162513999E-01],
	[8.2150000000E+03, 3.2389449607E+00, 6.3473968894E+00, 1.0016550633E-01, 9.5695939945E-02, 4.7179034565E-01],
	[8.2200000000E+03, 3.2414979941E+00, 6.3461078991E+00, 1.0035306118E-01, 9.5869056645E-02, 4.7195549963E-01],
	[8.2250000000E+03, 3.2440514856E+00, 6.3448199541E+00, 1.0054085227E-01, 9.6042371256E-02, 4.7212060208E-01],
	[8.2300000000E+03, 3.2466054349E+00, 6.3435330530E+00, 1.0072887974E-01, 9.6215883849E-02, 4.7228565313E-01],
	[8.2350000000E+03, 3.2491598420E+00, 6.3422471943E+00, 1.0091714375E-01, 9.6389594498E-02, 4.7245065291E-01],
	[8.2400000000E+03, 3.2517147065E+00, 6.3409623764E+00, 1.0110564445E-01, 9.6563503275E-02, 4.7261560155E-01],
	[8.2450000000E+03, 3.2542700283E+00, 6.3396785980E+00, 1.0129438200E-01, 9.6737610253E-02, 4.7278049919E-01],
	[8.2500000000E+03, 3.2568258072E+00, 6.3383958576E+00, 1.0148335654E-01, 9.6911915504E-02, 4.7294534597E-01],
	[8.2550000000E+03, 3.2593820430E+00, 6.3371141536E+00, 1.0167256824E-01, 9.7086419100E-02, 4.7311014201E-01],
	[8.2600000000E+03, 3.2619387356E+00, 6.3358334847E+00, 1.0186201724E-01, 9.7261121115E-02, 4.7327488744E-01],
	[8.2650000000E+03, 3.2644958846E+00, 6.3345538493E+00, 1.0205170369E-01, 9.7436021619E-02, 4.7343958241E-01],
	[8.2700000000E+03, 3.2670534899E+00, 6.3332752460E+00, 1.0224162774E-01, 9.7611120686E-02, 4.7360422703E-01],
	[8.2750000000E+03, 3.2696115514E+00, 6.3319976734E+00, 1.0243178956E-01, 9.7786418386E-02, 4.7376882145E-01],
	[8.2800000000E+03, 3.2721700688E+00, 6.3307211300E+00, 1.0262218929E-01, 9.7961914791E-02, 4.7393336580E-01],
	[8.2850000000E+03, 3.2747290419E+00, 6.3294456143E+00, 1.0281282708E-01, 9.8137609974E-02, 4.7409786020E-01],
	[8.2900000000E+03, 3.2772884705E+00, 6.3281711250E+00, 1.0300370309E-01, 9.8313504005E-02, 4.7426230480E-01],
	[8.2950000000E+03, 3.2798483545E+00, 6.3268976605E+00, 1.0319481748E-01, 9.8489596956E-02, 4.7442669972E-01],
	[8.3000000000E+03, 3.2824086937E+00, 6.3256252194E+00, 1.0338617038E-01, 9.8665888898E-02, 4.7459104508E-01],
	[8.3050000000E+03, 3.2849694878E+00, 6.3243538002E+00, 1.0357776195E-01, 9.8842379903E-02, 4.7475534104E-01],
	[8.3100000000E+03, 3.2875307366E+00, 6.3230834017E+00, 1.0376959236E-01, 9.9019070041E-02, 4.7491958771E-01],
	[8.3150000000E+03, 3.2900924401E+00, 6.3218140222E+00, 1.0396166174E-01, 9.9195959384E-02, 4.7508378522E-01],
	[8.3200000000E+03, 3.2926545979E+00, 6.3205456604E+00, 1.0415397026E-01, 9.9373048002E-02, 4.7524793371E-01],
	[8.3250000000E+03, 3.2952172099E+00, 6.3192783149E+00, 1.0434651806E-01, 9.9550335966E-02, 4.7541203331E-01],
	[8.3300000000E+03, 3.2977802759E+00, 6.3180119842E+00, 1.0453930529E-01, 9.9727823346E-02, 4.7557608415E-01],
	[8.3350000000E+03, 3.3003437956E+00, 6.3167466669E+00, 1.0473233212E-01, 9.9905510214E-02, 4.7574008636E-01],
	[8.3400000000E+03, 3.3029120131E+00, 6.3155049769E+00, 1.0492559869E-01, 1.0008340622E-01, 4.7590404006E-01],
	[8.3450000000E+03, 3.3054808205E+00, 6.3142649801E+00, 1.0511910515E-01, 1.0026150220E-01, 4.7606794540E-01],
	[8.3500000000E+03, 3.3080500852E+00, 6.3130259692E+00, 1.0531285166E-01, 1.0043979795E-01, 4.7623180249E-01],
	[8.3550000000E+03, 3.3106198072E+00, 6.3117879429E+00, 1.0550683838E-01, 1.0061829352E-01, 4.7639561147E-01],
	[8.3600000000E+03, 3.3131899862E+00, 6.3105508999E+00, 1.0570106544E-01, 1.0079698900E-01, 4.7655937248E-01],
	[8.3650000000E+03, 3.3157606220E+00, 6.3093148387E+00, 1.0589553301E-01, 1.0097588444E-01, 4.7672308563E-01],
	[8.3700000000E+03, 3.3183317144E+00, 6.3080797580E+00, 1.0609024123E-01, 1.0115497992E-01, 4.7688675105E-01],
	[8.3750000000E+03, 3.3209032633E+00, 6.3068456565E+00, 1.0628519027E-01, 1.0133427551E-01, 4.7705036889E-01],
	[8.3800000000E+03, 3.3234752684E+00, 6.3056125327E+00, 1.0648038027E-01, 1.0151377128E-01, 4.7721393926E-01],
	[8.3850000000E+03, 3.3260477296E+00, 6.3043803854E+00, 1.0667581138E-01, 1.0169346729E-01, 4.7737746229E-01],
	[8.3900000000E+03, 3.3286206467E+00, 6.3031492131E+00, 1.0687148376E-01, 1.0187336362E-01, 4.7754093812E-01],
	[8.3950000000E+03, 3.3311940194E+00, 6.3019190146E+00, 1.0706739757E-01, 1.0205346034E-01, 4.7770436687E-01],
	[8.4000000000E+03, 3.3337678476E+00, 6.3006897884E+00, 1.0726355294E-01, 1.0223375752E-01, 4.7786774867E-01],
	[8.4050000000E+03, 3.3363421311E+00, 6.2994615332E+00, 1.0745995004E-01, 1.0241425522E-01, 4.7803108365E-01],
	[8.4100000000E+03, 3.3389168697E+00, 6.2982342477E+00, 1.0765658902E-01, 1.0259495351E-01, 4.7819437194E-01],
	[8.4150000000E+03, 3.3414920633E+00, 6.2970079305E+00, 1.0785347003E-01, 1.0277585247E-01, 4.7835761366E-01],
	[8.4200000000E+03, 3.3440677115E+00, 6.2957825804E+00, 1.0805059322E-01, 1.0295695216E-01, 4.7852080895E-01],
	[8.4250000000E+03, 3.3466438143E+00, 6.2945581959E+00, 1.0824795875E-01, 1.0313825264E-01, 4.7868395793E-01],
	[8.4300000000E+03, 3.3492203714E+00, 6.2933347757E+00, 1.0844556677E-01, 1.0331975400E-01, 4.7884706073E-01],
	[8.4350000000E+03, 3.3517973827E+00, 6.2921123185E+00, 1.0864341743E-01, 1.0350145629E-01, 4.7901011748E-01],
	[8.4400000000E+03, 3.3543748479E+00, 6.2908908230E+00, 1.0884151088E-01, 1.0368335959E-01, 4.7917312830E-01],
	[8.4450000000E+03, 3.3569527670E+00, 6.2896702878E+00, 1.0903984728E-01, 1.0386546396E-01, 4.7933609332E-01],
	[8.4500000000E+03, 3.3595311396E+00, 6.2884507116E+00, 1.0923842678E-01, 1.0404776947E-01, 4.7949901267E-01],
	[8.4550000000E+03, 3.3621099656E+00, 6.2872320931E+00, 1.0943724953E-01, 1.0423027620E-01, 4.7966188648E-01],
	[8.4600000000E+03, 3.3646892448E+00, 6.2860144310E+00, 1.0963631568E-01, 1.0441298419E-01, 4.7982471487E-01],
	[8.4650000000E+03, 3.3672689770E+00, 6.2847977240E+00, 1.0983562539E-01, 1.0459589354E-01, 4.7998749797E-01],
	[8.4700000000E+03, 3.3698497233E+00, 6.2835849300E+00, 1.1003517881E-01, 1.0477900566E-01, 4.8015023591E-01],
	[8.4750000000E+03, 3.3724345878E+00, 6.2823923949E+00, 1.1023497610E-01, 1.0496232821E-01, 4.8031292881E-01],
	[8.4800000000E+03, 3.3750199087E+00, 6.2812007892E+00, 1.1043501739E-01, 1.0514585237E-01, 4.8047557680E-01],
	[8.4850000000E+03, 3.3776056859E+00, 6.2800101118E+00, 1.1063530286E-01, 1.0532957820E-01, 4.8063818001E-01],
	[8.4900000000E+03, 3.3801919192E+00, 6.2788203613E+00, 1.1083606776E-01, 1.0551371886E-01, 4.8080073856E-01],
	[8.4950000000E+03, 3.3827786083E+00, 6.2776315364E+00, 1.1103709193E-01, 1.0569807468E-01, 4.8096325258E-01],
	[8.5000000000E+03, 3.3853657531E+00, 6.2764436360E+00, 1.1123836160E-01, 1.0588263311E-01, 4.8112572219E-01],
	[8.5050000000E+03, 3.3879533534E+00, 6.2752566587E+00, 1.1143987693E-01, 1.0606739422E-01, 4.8128814752E-01],
	[8.5100000000E+03, 3.3905414090E+00, 6.2740706033E+00, 1.1164163806E-01, 1.0625235808E-01, 4.8145052870E-01],
	[8.5150000000E+03, 3.3931299198E+00, 6.2728854685E+00, 1.1184364516E-01, 1.0643752475E-01, 4.8161286585E-01],
	[8.5200000000E+03, 3.3957188854E+00, 6.2717012531E+00, 1.1204589838E-01, 1.0662289431E-01, 4.8177515909E-01],
	[8.5250000000E+03, 3.3983083059E+00, 6.2705179558E+00, 1.1224839787E-01, 1.0680846681E-01, 4.8193740856E-01],
	[8.5300000000E+03, 3.4008981809E+00, 6.2693355754E+00, 1.1245114379E-01, 1.0699424234E-01, 4.8209961438E-01],
	[8.5350000000E+03, 3.4034885102E+00, 6.2681541106E+00, 1.1265413628E-01, 1.0718022094E-01, 4.8226177667E-01],
	[8.5400000000E+03, 3.4060792938E+00, 6.2669735602E+00, 1.1285737551E-01, 1.0736640270E-01, 4.8242389555E-01],
	[8.5450000000E+03, 3.4086705313E+00, 6.2657939229E+00, 1.1306086163E-01, 1.0755278768E-01, 4.8258597114E-01],
	[8.5500000000E+03, 3.4112622227E+00, 6.2646151975E+00, 1.1326459479E-01, 1.0773937595E-01, 4.8274800355E-01],
	[8.5550000000E+03, 3.4138543676E+00, 6.2634373828E+00, 1.1346857515E-01, 1.0792616756E-01, 4.8290999286E-01],
	[8.5600000000E+03, 3.4164469661E+00, 6.2622604775E+00, 1.1367280287E-01, 1.0811316260E-01, 4.8307193918E-01],
	[8.5650000000E+03, 3.4190400178E+00, 6.2610844804E+00, 1.1387727808E-01, 1.0830036112E-01, 4.8323384262E-01],
	[8.5700000000E+03, 3.4216335225E+00, 6.2599093903E+00, 1.1408200096E-01, 1.0848776320E-01, 4.8339570327E-01],
	[8.5750000000E+03, 3.4242274802E+00, 6.2587352059E+00, 1.1428697165E-01, 1.0867536889E-01, 4.8355752125E-01],
	[8.5800000000E+03, 3.4268218905E+00, 6.2575619260E+00, 1.1449219031E-01, 1.0886317826E-01, 4.8371929665E-01],
	[8.5850000000E+03, 3.4294167534E+00, 6.2563895494E+00, 1.1469765709E-01, 1.0905119139E-01, 4.8388102957E-01],
	[8.5900000000E+03, 3.4320120686E+00, 6.2552180748E+00, 1.1490337215E-01, 1.0923940834E-01, 4.8404272012E-01],
	[8.5950000000E+03, 3.4346078360E+00, 6.2540475011E+00, 1.1510933564E-01, 1.0942782916E-01, 4.8420436840E-01],
	[8.6000000000E+03, 3.4372040553E+00, 6.2528778271E+00, 1.1531554771E-01, 1.0961645394E-01, 4.8436597451E-01],
	[8.6050000000E+03, 3.4398007264E+00, 6.2517090514E+00, 1.1552200852E-01, 1.0980528273E-01, 4.8452753856E-01],
	[8.6100000000E+03, 3.4424013688E+00, 6.2505595339E+00, 1.1572871823E-01, 1.0999432487E-01, 4.8468906063E-01],
	[8.6150000000E+03, 3.4450030208E+00, 6.2494137866E+00, 1.1593567699E-01, 1.1018357269E-01, 4.8485054085E-01],
	[8.6200000000E+03, 3.4476051278E+00, 6.2482689140E+00, 1.1614288495E-01, 1.1037302477E-01, 4.8501197930E-01],
	[8.6250000000E+03, 3.4502076897E+00, 6.2471249148E+00, 1.1635034226E-01, 1.1056268120E-01, 4.8517337609E-01],
	[8.6300000000E+03, 3.4528107061E+00, 6.2459817878E+00, 1.1655804909E-01, 1.1075254203E-01, 4.8533473132E-01],
	[8.6350000000E+03, 3.4554141771E+00, 6.2448395320E+00, 1.1676600558E-01, 1.1094260733E-01, 4.8549604509E-01],
	[8.6400000000E+03, 3.4580181023E+00, 6.2436981461E+00, 1.1697421189E-01, 1.1113287716E-01, 4.8565731751E-01],
	[8.6450000000E+03, 3.4606224816E+00, 6.2425576290E+00, 1.1718266817E-01, 1.1132335160E-01, 4.8581854867E-01],
	[8.6500000000E+03, 3.4632273149E+00, 6.2414179794E+00, 1.1739137458E-01, 1.1151403070E-01, 4.8597973867E-01],
	[8.6550000000E+03, 3.4658326018E+00, 6.2402791963E+00, 1.1760033128E-01, 1.1170491452E-01, 4.8614088762E-01],
	[8.6600000000E+03, 3.4684383423E+00, 6.2391412785E+00, 1.1780953841E-01, 1.1189600314E-01, 4.8630199562E-01],
	[8.6650000000E+03, 3.4710445362E+00, 6.2380042248E+00, 1.1801899613E-01, 1.1208729662E-01, 4.8646306277E-01],
	[8.6700000000E+03, 3.4736511832E+00, 6.2368680341E+00, 1.1822870460E-01, 1.1227879502E-01, 4.8662408916E-01],
	[8.6750000000E+03, 3.4762582832E+00, 6.2357327052E+00, 1.1843866397E-01, 1.1247049840E-01, 4.8678507491E-01],
	[8.6800000000E+03, 3.4788658361E+00, 6.2345982370E+00, 1.1864887439E-01, 1.1266240684E-01, 4.8694602010E-01],
	[8.6850000000E+03, 3.4814738415E+00, 6.2334646283E+00, 1.1885933602E-01, 1.1285452039E-01, 4.8710692485E-01],
	[8.6900000000E+03, 3.4840822994E+00, 6.2323318780E+00, 1.1907004901E-01, 1.1304683911E-01, 4.8726778925E-01],
	[8.6950000000E+03, 3.4866912096E+00, 6.2311999849E+00, 1.1928101352E-01, 1.1323936308E-01, 4.8742861339E-01],
	[8.7000000000E+03, 3.4893005719E+00, 6.2300689479E+00, 1.1949222970E-01, 1.1343209235E-01, 4.8758939739E-01],
	[8.7050000000E+03, 3.4919103861E+00, 6.2289387659E+00, 1.1970369771E-01, 1.1362502699E-01, 4.8775014135E-01],
	[8.7100000000E+03, 3.4945206520E+00, 6.2278094377E+00, 1.1991541770E-01, 1.1381816707E-01, 4.8791084535E-01],
	[8.7150000000E+03, 3.4971313694E+00, 6.2266809621E+00, 1.2012738982E-01, 1.1401151263E-01, 4.8807150950E-01],
	[8.7200000000E+03, 3.4997425382E+00, 6.2255533382E+00, 1.2033961423E-01, 1.1420506376E-01, 4.8823213391E-01],
	[8.7250000000E+03, 3.5023541582E+00, 6.2244265646E+00, 1.2055209108E-01, 1.1439882050E-01, 4.8839271867E-01],
	[8.7300000000E+03, 3.5049662291E+00, 6.2233006403E+00, 1.2076482053E-01, 1.1459278293E-01, 4.8855326388E-01],
	[8.7350000000E+03, 3.5075787509E+00, 6.2221755642E+00, 1.2097780273E-01, 1.1478695111E-01, 4.8871376964E-01],
	[8.7400000000E+03, 3.5101917234E+00, 6.2210513352E+00, 1.2119103784E-01, 1.1498132509E-01, 4.8887423605E-01],
	[8.7450000000E+03, 3.5128057575E+00, 6.2199311142E+00, 1.2140452601E-01, 1.1517590669E-01, 4.8903466322E-01],
	[8.7500000000E+03, 3.5154235528E+00, 6.2188288442E+00, 1.2161826740E-01, 1.1537070368E-01, 4.8919505123E-01],
	[8.7550000000E+03, 3.5180418018E+00, 6.2177273992E+00, 1.2183226215E-01, 1.1556570673E-01, 4.8935540019E-01],
	[8.7600000000E+03, 3.5206605043E+00, 6.2166267778E+00, 1.2204651043E-01, 1.1576091591E-01, 4.8951571020E-01],
	[8.7650000000E+03, 3.5232796601E+00, 6.2155269792E+00, 1.2226101238E-01, 1.1595633128E-01, 4.8967598136E-01],
	[8.7700000000E+03, 3.5258992691E+00, 6.2144280022E+00, 1.2247576817E-01, 1.1615195289E-01, 4.8983621376E-01],
	[8.7750000000E+03, 3.5285193311E+00, 6.2133298456E+00, 1.2269077795E-01, 1.1634778081E-01, 4.8999640751E-01],
	[8.7800000000E+03, 3.5311398458E+00, 6.2122325086E+00, 1.2290604187E-01, 1.1654381511E-01, 4.9015656271E-01],
	[8.7850000000E+03, 3.5337608132E+00, 6.2111359899E+00, 1.2312156008E-01, 1.1674005583E-01, 4.9031667945E-01],
	[8.7900000000E+03, 3.5363822330E+00, 6.2100402885E+00, 1.2333733274E-01, 1.1693650306E-01, 4.9047675783E-01],
	[8.7950000000E+03, 3.5390041050E+00, 6.2089454033E+00, 1.2355336001E-01, 1.1713315684E-01, 4.9063679796E-01],
	[8.8000000000E+03, 3.5416264291E+00, 6.2078513332E+00, 1.2376964204E-01, 1.1733001723E-01, 4.9079679992E-01],
	[8.8050000000E+03, 3.5442492052E+00, 6.2067580772E+00, 1.2398617898E-01, 1.1752708431E-01, 4.9095676383E-01],
	[8.8100000000E+03, 3.5468724329E+00, 6.2056656343E+00, 1.2420297099E-01, 1.1772435812E-01, 4.9111668977E-01],
	[8.8150000000E+03, 3.5494961122E+00, 6.2045740032E+00, 1.2442001822E-01, 1.1792183874E-01, 4.9127657785E-01],
	[8.8200000000E+03, 3.5521202428E+00, 6.2034831831E+00, 1.2463732083E-01, 1.1811952622E-01, 4.9143642816E-01],
	[8.8250000000E+03, 3.5547448246E+00, 6.2023931727E+00, 1.2485487897E-01, 1.1831742062E-01, 4.9159624081E-01],
	[8.8300000000E+03, 3.5573698574E+00, 6.2013039712E+00, 1.2507269280E-01, 1.1851552200E-01, 4.9175601589E-01],
	[8.8350000000E+03, 3.5599953410E+00, 6.2002155773E+00, 1.2529076246E-01, 1.1871383043E-01, 4.9191575349E-01],
	[8.8400000000E+03, 3.5626212753E+00, 6.1991279900E+00, 1.2550908813E-01, 1.1891234597E-01, 4.9207545373E-01],
	[8.8450000000E+03, 3.5652476601E+00, 6.1980412084E+00, 1.2572766994E-01, 1.1911106866E-01, 4.9223511669E-01],
	[8.8500000000E+03, 3.5678744951E+00, 6.1969552313E+00, 1.2594650805E-01, 1.1930999858E-01, 4.9239474248E-01],
	[8.8550000000E+03, 3.5705017803E+00, 6.1958700577E+00, 1.2616560263E-01, 1.1950913579E-01, 4.9255433118E-01],
	[8.8600000000E+03, 3.5731295154E+00, 6.1947856865E+00, 1.2638495381E-01, 1.1970848034E-01, 4.9271388291E-01],
	[8.8650000000E+03, 3.5757577002E+00, 6.1937021167E+00, 1.2660456177E-01, 1.1990803229E-01, 4.9287339776E-01],
	[8.8700000000E+03, 3.5783863347E+00, 6.1926193473E+00, 1.2682442664E-01, 1.2010779171E-01, 4.9303287582E-01],
	[8.8750000000E+03, 3.5810154185E+00, 6.1915373772E+00, 1.2704454859E-01, 1.2030775865E-01, 4.9319231719E-01],
	[8.8800000000E+03, 3.5836449516E+00, 6.1904562053E+00, 1.2726492778E-01, 1.2050793318E-01, 4.9335172198E-01],
	[8.8850000000E+03, 3.5862749410E+00, 6.1893758679E+00, 1.2748556434E-01, 1.2070831537E-01, 4.9351109027E-01],
	[8.8900000000E+03, 3.5889091392E+00, 6.1883156129E+00, 1.2770645845E-01, 1.2090891689E-01, 4.9367042217E-01],
	[8.8950000000E+03, 3.5915437895E+00, 6.1872561355E+00, 1.2792761025E-01, 1.2110972623E-01, 4.9382971777E-01],
	[8.9000000000E+03, 3.5941788917E+00, 6.1861974347E+00, 1.2814901990E-01, 1.2131074347E-01, 4.9398897718E-01],
	[8.9050000000E+03, 3.5968144457E+00, 6.1851395095E+00, 1.2837068756E-01, 1.2151196864E-01, 4.9414820048E-01],
	[8.9100000000E+03, 3.5994504512E+00, 6.1840823590E+00, 1.2859261337E-01, 1.2171340183E-01, 4.9430738778E-01],
	[8.9150000000E+03, 3.6020869082E+00, 6.1830259820E+00, 1.2881479750E-01, 1.2191504307E-01, 4.9446653917E-01],
	[8.9200000000E+03, 3.6047238164E+00, 6.1819703777E+00, 1.2903724009E-01, 1.2211689244E-01, 4.9462565475E-01],
	[8.9250000000E+03, 3.6073611756E+00, 6.1809155449E+00, 1.2925994130E-01, 1.2231894999E-01, 4.9478473460E-01],
	[8.9300000000E+03, 3.6099989858E+00, 6.1798614828E+00, 1.2948290129E-01, 1.2252121577E-01, 4.9494377879E-01],
	[8.9350000000E+03, 3.6126372466E+00, 6.1788081903E+00, 1.2970612021E-01, 1.2272368986E-01, 4.9510278741E-01],
	[8.9400000000E+03, 3.6152759580E+00, 6.1777556664E+00, 1.2992959822E-01, 1.2292637229E-01, 4.9526176052E-01],
	[8.9450000000E+03, 3.6179151197E+00, 6.1767039101E+00, 1.3015333546E-01, 1.2312926314E-01, 4.9542069821E-01],
	[8.9500000000E+03, 3.6205547315E+00, 6.1756529205E+00, 1.3037733210E-01, 1.2333236247E-01, 4.9557960054E-01],
	[8.9550000000E+03, 3.6231947934E+00, 6.1746026966E+00, 1.3060158829E-01, 1.2353567032E-01, 4.9573846761E-01],
	[8.9600000000E+03, 3.6258353051E+00, 6.1735532373E+00, 1.3082610419E-01, 1.2373918675E-01, 4.9589729948E-01],
	[8.9650000000E+03, 3.6284762665E+00, 6.1725045418E+00, 1.3105087994E-01, 1.2394291183E-01, 4.9605609624E-01],
	[8.9700000000E+03, 3.6311176773E+00, 6.1714566089E+00, 1.3127591570E-01, 1.2414684562E-01, 4.9621485795E-01],
	[8.9750000000E+03, 3.6337595375E+00, 6.1704094378E+00, 1.3150121163E-01, 1.2435098816E-01, 4.9637358470E-01],
	[8.9800000000E+03, 3.6364018468E+00, 6.1693630274E+00, 1.3172676788E-01, 1.2455533951E-01, 4.9653227657E-01],
	[8.9850000000E+03, 3.6390446050E+00, 6.1683173768E+00, 1.3195258461E-01, 1.2475989974E-01, 4.9669093362E-01],
	[8.9900000000E+03, 3.6416878120E+00, 6.1672724850E+00, 1.3217866197E-01, 1.2496466890E-01, 4.9684955594E-01],
	[8.9950000000E+03, 3.6443314676E+00, 6.1662283511E+00, 1.3240500012E-01, 1.2516964704E-01, 4.9700814360E-01],
	[9.0000000000E+03, 3.6469755717E+00, 6.1651849740E+00, 1.3263159921E-01, 1.2537483423E-01, 4.9716669668E-01],
	[9.0050000000E+03, 3.6496201240E+00, 6.1641423528E+00, 1.3285979932E-01, 1.2558142766E-01, 4.9732521526E-01],
	[9.0100000000E+03, 3.6522651245E+00, 6.1631004865E+00, 1.3308826451E-01, 1.2578823332E-01, 4.9748369941E-01],
	[9.0150000000E+03, 3.6549105728E+00, 6.1620593742E+00, 1.3331699493E-01, 1.2599525126E-01, 4.9764214921E-01],
	[9.0200000000E+03, 3.6575564689E+00, 6.1610190149E+00, 1.3354599074E-01, 1.2620248154E-01, 4.9780056473E-01],
	[9.0250000000E+03, 3.6602028125E+00, 6.1599794076E+00, 1.3377525210E-01, 1.2640992422E-01, 4.9795894606E-01],
	[9.0300000000E+03, 3.6628510361E+00, 6.1589478245E+00, 1.3400477918E-01, 1.2661758415E-01, 4.9811729326E-01],
	[9.0350000000E+03, 3.6655019064E+00, 6.1579281350E+00, 1.3423457212E-01, 1.2682546399E-01, 4.9827560642E-01],
	[9.0400000000E+03, 3.6681532269E+00, 6.1569091783E+00, 1.3446463110E-01, 1.2703355647E-01, 4.9843388561E-01],
	[9.0450000000E+03, 3.6708049976E+00, 6.1558909536E+00, 1.3469495626E-01, 1.2724186165E-01, 4.9859213091E-01],
	[9.0500000000E+03, 3.6734572182E+00, 6.1548734598E+00, 1.3492554778E-01, 1.2745037959E-01, 4.9875034238E-01],
	[9.0550000000E+03, 3.6761098886E+00, 6.1538566960E+00, 1.3515640580E-01, 1.2765911036E-01, 4.9890852012E-01],
	[9.0600000000E+03, 3.6787630086E+00, 6.1528406614E+00, 1.3538753049E-01, 1.2786805400E-01, 4.9906666420E-01],
	[9.0650000000E+03, 3.6814165780E+00, 6.1518253549E+00, 1.3561892201E-01, 1.2807721057E-01, 4.9922477468E-01],
	[9.0700000000E+03, 3.6840705967E+00, 6.1508107757E+00, 1.3585058052E-01, 1.2828658014E-01, 4.9938285165E-01],
	[9.0750000000E+03, 3.6867250645E+00, 6.1497969228E+00, 1.3608250618E-01, 1.2849616276E-01, 4.9954089519E-01],
	[9.0800000000E+03, 3.6893799812E+00, 6.1487837954E+00, 1.3631469914E-01, 1.2870595849E-01, 4.9969890536E-01],
	[9.0850000000E+03, 3.6920353466E+00, 6.1477713924E+00, 1.3654715956E-01, 1.2891596738E-01, 4.9985688226E-01],
	[9.0900000000E+03, 3.6946911606E+00, 6.1467597131E+00, 1.3677988762E-01, 1.2912618949E-01, 5.0001482594E-01],
	[9.0950000000E+03, 3.6973474231E+00, 6.1457487564E+00, 1.3701288346E-01, 1.2933662488E-01, 5.0017273649E-01],
	[9.1000000000E+03, 3.7000041337E+00, 6.1447385214E+00, 1.3724614724E-01, 1.2954727361E-01, 5.0033061398E-01],
	[9.1050000000E+03, 3.7026612924E+00, 6.1437290073E+00, 1.3747967913E-01, 1.2975813573E-01, 5.0048845849E-01],
	[9.1100000000E+03, 3.7053188991E+00, 6.1427202132E+00, 1.3771347928E-01, 1.2996921130E-01, 5.0064627010E-01],
	[9.1150000000E+03, 3.7079769534E+00, 6.1417121381E+00, 1.3794754785E-01, 1.3018050037E-01, 5.0080404887E-01],
	[9.1200000000E+03, 3.7106354553E+00, 6.1407047811E+00, 1.3818188501E-01, 1.3039200301E-01, 5.0096179489E-01],
	[9.1250000000E+03, 3.7132944045E+00, 6.1396981413E+00, 1.3841649092E-01, 1.3060371926E-01, 5.0111950824E-01],
	[9.1300000000E+03, 3.7159538010E+00, 6.1386922179E+00, 1.3865136572E-01, 1.3081564919E-01, 5.0127718898E-01],
	[9.1350000000E+03, 3.7186136446E+00, 6.1376870098E+00, 1.3888650959E-01, 1.3102779285E-01, 5.0143483719E-01],
	[9.1400000000E+03, 3.7212739350E+00, 6.1366825163E+00, 1.3912192268E-01, 1.3124015029E-01, 5.0159245296E-01],
	[9.1450000000E+03, 3.7239346721E+00, 6.1356787363E+00, 1.3935760515E-01, 1.3145272158E-01, 5.0175003634E-01],
	[9.1500000000E+03, 3.7265958557E+00, 6.1346756691E+00, 1.3959355716E-01, 1.3166550676E-01, 5.0190758743E-01],
	[9.1550000000E+03, 3.7292574857E+00, 6.1336733138E+00, 1.3982977887E-01, 1.3187850589E-01, 5.0206510629E-01],
	[9.1600000000E+03, 3.7319195619E+00, 6.1326716693E+00, 1.4006627045E-01, 1.3209171904E-01, 5.0222259300E-01],
	[9.1650000000E+03, 3.7345820841E+00, 6.1316707349E+00, 1.4030303204E-01, 1.3230514624E-01, 5.0238004764E-01],
	[9.1700000000E+03, 3.7372450522E+00, 6.1306705096E+00, 1.4054006381E-01, 1.3251878757E-01, 5.0253747028E-01],
	[9.1750000000E+03, 3.7399096218E+00, 6.1296767433E+00, 1.4077736593E-01, 1.3273264721E-01, 5.0269486099E-01],
	[9.1800000000E+03, 3.7425770193E+00, 6.1286955157E+00, 1.4101493854E-01, 1.3294672969E-01, 5.0285221986E-01],
	[9.1850000000E+03, 3.7452448651E+00, 6.1277149794E+00, 1.4125278181E-01, 1.3316102652E-01, 5.0300954695E-01],
	[9.1900000000E+03, 3.7479131593E+00, 6.1267351334E+00, 1.4149089590E-01, 1.3337553775E-01, 5.0316684235E-01],
	[9.1950000000E+03, 3.7505819016E+00, 6.1257559770E+00, 1.4172928097E-01, 1.3359026345E-01, 5.0332410612E-01],
	[9.2000000000E+03, 3.7532510919E+00, 6.1247775092E+00, 1.4196793718E-01, 1.3380520367E-01, 5.0348133835E-01],
	[9.2050000000E+03, 3.7559207299E+00, 6.1237997292E+00, 1.4220686468E-01, 1.3402035846E-01, 5.0363853910E-01],
	[9.2100000000E+03, 3.7585908156E+00, 6.1228226362E+00, 1.4244606364E-01, 1.3423572787E-01, 5.0379570846E-01],
	[9.2150000000E+03, 3.7612613487E+00, 6.1218462292E+00, 1.4268553422E-01, 1.3445131197E-01, 5.0395284649E-01],
	[9.2200000000E+03, 3.7639323292E+00, 6.1208705075E+00, 1.4292527658E-01, 1.3466711080E-01, 5.0410995328E-01],
	[9.2250000000E+03, 3.7666037567E+00, 6.1198954701E+00, 1.4316529087E-01, 1.3488312442E-01, 5.0426702889E-01],
	[9.2300000000E+03, 3.7692756312E+00, 6.1189211163E+00, 1.4340557726E-01, 1.3509935288E-01, 5.0442407341E-01],
	[9.2350000000E+03, 3.7719479525E+00, 6.1179474451E+00, 1.4364613591E-01, 1.3531579624E-01, 5.0458108691E-01],
	[9.2400000000E+03, 3.7746207204E+00, 6.1169744558E+00, 1.4388696697E-01, 1.3553245454E-01, 5.0473806946E-01],
	[9.2450000000E+03, 3.7772939347E+00, 6.1160021475E+00, 1.4412807060E-01, 1.3574932785E-01, 5.0489502114E-01],
	[9.2500000000E+03, 3.7799675953E+00, 6.1150305193E+00, 1.4436944698E-01, 1.3596641621E-01, 5.0505194202E-01],
	[9.2550000000E+03, 3.7826417021E+00, 6.1140595704E+00, 1.4461109625E-01, 1.3618371968E-01, 5.0520883218E-01],
	[9.2600000000E+03, 3.7853162548E+00, 6.1130892999E+00, 1.4485301857E-01, 1.3640123832E-01, 5.0536569169E-01],
	[9.2650000000E+03, 3.7879912532E+00, 6.1121197071E+00, 1.4509521411E-01, 1.3661897216E-01, 5.0552252062E-01],
	[9.2700000000E+03, 3.7906666973E+00, 6.1111507910E+00, 1.4533768302E-01, 1.3683692128E-01, 5.0567931906E-01],
	[9.2750000000E+03, 3.7933425869E+00, 6.1101825509E+00, 1.4558042547E-01, 1.3705508571E-01, 5.0583608708E-01],
	[9.2800000000E+03, 3.7960189217E+00, 6.1092149859E+00, 1.4582344161E-01, 1.3727346552E-01, 5.0599282475E-01],
	[9.2850000000E+03, 3.7986957017E+00, 6.1082480951E+00, 1.4606673160E-01, 1.3749206075E-01, 5.0614953214E-01],
	[9.2900000000E+03, 3.8013729266E+00, 6.1072818778E+00, 1.4631029561E-01, 1.3771087145E-01, 5.0630620931E-01],
	[9.2950000000E+03, 3.8040505963E+00, 6.1063163331E+00, 1.4655413380E-01, 1.3792989769E-01, 5.0646285632E-01],
	[9.3000000000E+03, 3.8067287106E+00, 6.1053514602E+00, 1.4679824631E-01, 1.3814913950E-01, 5.0661947323E-01],
	[9.3050000000E+03, 3.8094072693E+00, 6.1043872582E+00, 1.4704263332E-01, 1.3836859695E-01, 5.0677606008E-01],
	[9.3100000000E+03, 3.8120862724E+00, 6.1034237264E+00, 1.4728729499E-01, 1.3858827008E-01, 5.0693261694E-01],
	[9.3150000000E+03, 3.8147657196E+00, 6.1024608638E+00, 1.4753223146E-01, 1.3880815894E-01, 5.0708914386E-01],
	[9.3200000000E+03, 3.8174456107E+00, 6.1014986697E+00, 1.4777744291E-01, 1.3902826359E-01, 5.0724564091E-01],
	[9.3250000000E+03, 3.8201286739E+00, 6.1005504228E+00, 1.4802292949E-01, 1.3924859463E-01, 5.0740210813E-01],
	[9.3300000000E+03, 3.8228129036E+00, 6.0996063356E+00, 1.4826869137E-01, 1.3946914440E-01, 5.0755854560E-01],
	[9.3350000000E+03, 3.8254975797E+00, 6.0986629001E+00, 1.4851472870E-01, 1.3968991018E-01, 5.0771495335E-01],
	[9.3400000000E+03, 3.8281827021E+00, 6.0977201157E+00, 1.4876104164E-01, 1.3991089203E-01, 5.0787133145E-01],
	[9.3450000000E+03, 3.8308682707E+00, 6.0967779814E+00, 1.4900763035E-01, 1.4013209000E-01, 5.0802767996E-01],
	[9.3500000000E+03, 3.8335542852E+00, 6.0958364966E+00, 1.4925449499E-01, 1.4035350413E-01, 5.0818399893E-01],
	[9.3550000000E+03, 3.8362407455E+00, 6.0948956603E+00, 1.4950163573E-01, 1.4057513448E-01, 5.0834028843E-01],
	[9.3600000000E+03, 3.8389276515E+00, 6.0939554719E+00, 1.4974905271E-01, 1.4079698109E-01, 5.0849654850E-01],
	[9.3650000000E+03, 3.8416150029E+00, 6.0930159305E+00, 1.4999674611E-01, 1.4101904403E-01, 5.0865277921E-01],
	[9.3700000000E+03, 3.8443027997E+00, 6.0920770353E+00, 1.5024471609E-01, 1.4124132333E-01, 5.0880898061E-01],
	[9.3750000000E+03, 3.8469910416E+00, 6.0911387855E+00, 1.5049296279E-01, 1.4146381905E-01, 5.0896515275E-01],
	[9.3800000000E+03, 3.8496797285E+00, 6.0902011804E+00, 1.5074148638E-01, 1.4168653124E-01, 5.0912129571E-01],
	[9.3850000000E+03, 3.8523688602E+00, 6.0892642192E+00, 1.5099028703E-01, 1.4190945995E-01, 5.0927740952E-01],
	[9.3900000000E+03, 3.8550584365E+00, 6.0883279010E+00, 1.5123936489E-01, 1.4213260523E-01, 5.0943349426E-01],
	[9.3950000000E+03, 3.8577484574E+00, 6.0873922252E+00, 1.5148872012E-01, 1.4235596712E-01, 5.0958954997E-01],
	[9.4000000000E+03, 3.8604389225E+00, 6.0864571908E+00, 1.5173835288E-01, 1.4257954568E-01, 5.0974557672E-01],
	[9.4050000000E+03, 3.8631298319E+00, 6.0855227972E+00, 1.5198826333E-01, 1.4280334096E-01, 5.0990157455E-01],
	[9.4100000000E+03, 3.8658211852E+00, 6.0845890436E+00, 1.5223845163E-01, 1.4302735300E-01, 5.1005754353E-01],
	[9.4150000000E+03, 3.8685129824E+00, 6.0836559291E+00, 1.5248891794E-01, 1.4325158186E-01, 5.1021348372E-01],
	[9.4200000000E+03, 3.8712052232E+00, 6.0827234530E+00, 1.5273966243E-01, 1.4347602758E-01, 5.1036939517E-01],
	[9.4250000000E+03, 3.8738979076E+00, 6.0817916146E+00, 1.5299068525E-01, 1.4370069022E-01, 5.1052527793E-01],
	[9.4300000000E+03, 3.8765910353E+00, 6.0808604130E+00, 1.5324198655E-01, 1.4392556981E-01, 5.1068113207E-01],
	[9.4350000000E+03, 3.8792846062E+00, 6.0799298475E+00, 1.5349356651E-01, 1.4415066642E-01, 5.1083695765E-01],
	[9.4400000000E+03, 3.8819786202E+00, 6.0789999173E+00, 1.5374542528E-01, 1.4437598009E-01, 5.1099275471E-01],
	[9.4450000000E+03, 3.8846730770E+00, 6.0780706216E+00, 1.5399756302E-01, 1.4460151086E-01, 5.1114852331E-01],
	[9.4500000000E+03, 3.8873679765E+00, 6.0771419597E+00, 1.5424997989E-01, 1.4482725878E-01, 5.1130426352E-01],
	[9.4550000000E+03, 3.8900633186E+00, 6.0762139308E+00, 1.5450267605E-01, 1.4505322391E-01, 5.1145997538E-01],
	[9.4600000000E+03, 3.8927591030E+00, 6.0752865342E+00, 1.5475565167E-01, 1.4527940629E-01, 5.1161565897E-01],
	[9.4650000000E+03, 3.8954553297E+00, 6.0743597690E+00, 1.5500890689E-01, 1.4550580597E-01, 5.1177131432E-01],
	[9.4700000000E+03, 3.8981519984E+00, 6.0734336345E+00, 1.5526244189E-01, 1.4573242300E-01, 5.1192694150E-01],
	[9.4750000000E+03, 3.9008517289E+00, 6.0725206153E+00, 1.5551625681E-01, 1.4595926830E-01, 5.1208254057E-01],
	[9.4800000000E+03, 3.9035526430E+00, 6.0716117366E+00, 1.5577035183E-01, 1.4618633417E-01, 5.1223811158E-01],
	[9.4850000000E+03, 3.9062540015E+00, 6.0707034731E+00, 1.5602472710E-01, 1.4641361762E-01, 5.1239365459E-01],
	[9.4900000000E+03, 3.9089558043E+00, 6.0697958240E+00, 1.5627944928E-01, 1.4664117722E-01, 5.1254916966E-01],
	[9.4950000000E+03, 3.9116580513E+00, 6.0688887886E+00, 1.5653449067E-01, 1.4686898848E-01, 5.1270465684E-01],
	[9.5000000000E+03, 3.9143607422E+00, 6.0679823661E+00, 1.5678981311E-01, 1.4709701770E-01, 5.1286011619E-01],
	[9.5050000000E+03, 3.9170638769E+00, 6.0670765559E+00, 1.5704541677E-01, 1.4732526492E-01, 5.1301554777E-01],
	[9.5100000000E+03, 3.9197674553E+00, 6.0661713571E+00, 1.5730130179E-01, 1.4755373020E-01, 5.1317095162E-01],
	[9.5150000000E+03, 3.9224714771E+00, 6.0652667691E+00, 1.5755746835E-01, 1.4778241357E-01, 5.1332632782E-01],
	[9.5200000000E+03, 3.9251759423E+00, 6.0643627910E+00, 1.5781391660E-01, 1.4801131509E-01, 5.1348167642E-01],
	[9.5250000000E+03, 3.9278808507E+00, 6.0634594223E+00, 1.5807064670E-01, 1.4824043480E-01, 5.1363699747E-01],
	[9.5300000000E+03, 3.9305862020E+00, 6.0625566621E+00, 1.5832765881E-01, 1.4846977275E-01, 5.1379229102E-01],
	[9.5350000000E+03, 3.9332919962E+00, 6.0616545097E+00, 1.5858495310E-01, 1.4869932899E-01, 5.1394755715E-01],
	[9.5400000000E+03, 3.9359982331E+00, 6.0607529644E+00, 1.5884252972E-01, 1.4892910356E-01, 5.1410279590E-01],
	[9.5450000000E+03, 3.9387049125E+00, 6.0598520255E+00, 1.5910038884E-01, 1.4915909650E-01, 5.1425800732E-01],
	[9.5500000000E+03, 3.9414120343E+00, 6.0589516922E+00, 1.5935853061E-01, 1.4938930787E-01, 5.1441319149E-01],
	[9.5550000000E+03, 3.9441195983E+00, 6.0580519638E+00, 1.5961695520E-01, 1.4961973770E-01, 5.1456834844E-01],
	[9.5600000000E+03, 3.9468276043E+00, 6.0571528397E+00, 1.5987566277E-01, 1.4985038605E-01, 5.1472347825E-01],
	[9.5650000000E+03, 3.9495360523E+00, 6.0562543190E+00, 1.6013465347E-01, 1.5008125296E-01, 5.1487858096E-01],
	[9.5700000000E+03, 3.9522449419E+00, 6.0553564010E+00, 1.6039392747E-01, 1.5031233848E-01, 5.1503365664E-01],
	[9.5750000000E+03, 3.9549542731E+00, 6.0544590851E+00, 1.6065348493E-01, 1.5054364265E-01, 5.1518870534E-01],
	[9.5800000000E+03, 3.9576640458E+00, 6.0535623705E+00, 1.6091332601E-01, 1.5077516551E-01, 5.1534372711E-01],
	[9.5850000000E+03, 3.9603742597E+00, 6.0526662565E+00, 1.6117345087E-01, 1.5100690712E-01, 5.1549872201E-01],
	[9.5900000000E+03, 3.9630849147E+00, 6.0517707423E+00, 1.6143385966E-01, 1.5123886751E-01, 5.1565369011E-01],
	[9.5950000000E+03, 3.9657960106E+00, 6.0508758274E+00, 1.6169455256E-01, 1.5147104673E-01, 5.1580863145E-01],
	[9.6000000000E+03, 3.9685075473E+00, 6.0499815109E+00, 1.6195552972E-01, 1.5170344483E-01, 5.1596354609E-01],
	[9.6050000000E+03, 3.9712195247E+00, 6.0490877921E+00, 1.6221679131E-01, 1.5193606185E-01, 5.1611843409E-01],
	[9.6100000000E+03, 3.9739319425E+00, 6.0481946704E+00, 1.6247833747E-01, 1.5216889783E-01, 5.1627329551E-01],
	[9.6150000000E+03, 3.9766448006E+00, 6.0473021450E+00, 1.6274016838E-01, 1.5240195282E-01, 5.1642813040E-01],
	[9.6200000000E+03, 3.9793580988E+00, 6.0464102153E+00, 1.6300228420E-01, 1.5263522687E-01, 5.1658293881E-01],
	[9.6250000000E+03, 3.9820727704E+00, 6.0455232382E+00, 1.6326468507E-01, 1.5286872417E-01, 5.1673772082E-01],
	[9.6300000000E+03, 3.9847902186E+00, 6.0446477503E+00, 1.6352737118E-01, 1.5310245108E-01, 5.1689247646E-01],
	[9.6350000000E+03, 3.9875081092E+00, 6.0437728435E+00, 1.6379034267E-01, 1.5333639725E-01, 5.1704720582E-01],
	[9.6400000000E+03, 3.9902264421E+00, 6.0428985171E+00, 1.6405359970E-01, 1.5357056272E-01, 5.1720190907E-01],
	[9.6450000000E+03, 3.9929452172E+00, 6.0420247705E+00, 1.6431714245E-01, 1.5380494755E-01, 5.1735658632E-01],
	[9.6500000000E+03, 3.9956644342E+00, 6.0411516030E+00, 1.6458097106E-01, 1.5403955176E-01, 5.1751123759E-01],
	[9.6550000000E+03, 3.9983840930E+00, 6.0402790139E+00, 1.6484508570E-01, 1.5427437542E-01, 5.1766586292E-01],
	[9.6600000000E+03, 4.0011041935E+00, 6.0394070025E+00, 1.6510948654E-01, 1.5450941855E-01, 5.1782046235E-01],
	[9.6650000000E+03, 4.0038247354E+00, 6.0385355681E+00, 1.6537417372E-01, 1.5474468121E-01, 5.1797503590E-01],
	[9.6700000000E+03, 4.0065457187E+00, 6.0376647100E+00, 1.6563914741E-01, 1.5498016344E-01, 5.1812958361E-01],
	[9.6750000000E+03, 4.0092671432E+00, 6.0367944276E+00, 1.6590440777E-01, 1.5521586527E-01, 5.1828410552E-01],
	[9.6800000000E+03, 4.0119890087E+00, 6.0359247202E+00, 1.6616995497E-01, 1.5545178676E-01, 5.1843860167E-01],
	[9.6850000000E+03, 4.0147113150E+00, 6.0350555872E+00, 1.6643578916E-01, 1.5568792794E-01, 5.1859307208E-01],
	[9.6900000000E+03, 4.0174340621E+00, 6.0341870277E+00, 1.6670191051E-01, 1.5592428885E-01, 5.1874751679E-01],
	[9.6950000000E+03, 4.0201572497E+00, 6.0333190412E+00, 1.6696831917E-01, 1.5616086955E-01, 5.1890193584E-01],
	[9.7000000000E+03, 4.0228808778E+00, 6.0324516270E+00, 1.6723501530E-01, 1.5639767007E-01, 5.1905632926E-01],
	[9.7050000000E+03, 4.0256049460E+00, 6.0315847845E+00, 1.6750199907E-01, 1.5663469045E-01, 5.1921069708E-01],
	[9.7100000000E+03, 4.0283294544E+00, 6.0307185128E+00, 1.6776927064E-01, 1.5687193073E-01, 5.1936503935E-01],
	[9.7150000000E+03, 4.0310544027E+00, 6.0298528115E+00, 1.6803683016E-01, 1.5710939096E-01, 5.1951935609E-01],
	[9.7200000000E+03, 4.0337797907E+00, 6.0289876798E+00, 1.6830467781E-01, 1.5734707119E-01, 5.1967364734E-01],
	[9.7250000000E+03, 4.0365056184E+00, 6.0281231170E+00, 1.6857281373E-01, 1.5758497144E-01, 5.1982791314E-01],
	[9.7300000000E+03, 4.0392318855E+00, 6.0272591224E+00, 1.6884123810E-01, 1.5782309176E-01, 5.1998215352E-01],
	[9.7350000000E+03, 4.0419585920E+00, 6.0263956955E+00, 1.6910995106E-01, 1.5806143220E-01, 5.2013636851E-01],
	[9.7400000000E+03, 4.0446857376E+00, 6.0255328355E+00, 1.6937895279E-01, 1.5829999279E-01, 5.2029055816E-01],
	[9.7450000000E+03, 4.0474133222E+00, 6.0246705419E+00, 1.6964824344E-01, 1.5853877357E-01, 5.2044472248E-01],
	[9.7500000000E+03, 4.0501413456E+00, 6.0238088138E+00, 1.6991782317E-01, 1.5877777459E-01, 5.2059886153E-01],
	[9.7550000000E+03, 4.0528698078E+00, 6.0229476507E+00, 1.7018769214E-01, 1.5901699588E-01, 5.2075297533E-01],
	[9.7600000000E+03, 4.0555987085E+00, 6.0220870519E+00, 1.7045785052E-01, 1.5925643750E-01, 5.2090706393E-01],
	[9.7650000000E+03, 4.0583280475E+00, 6.0212270167E+00, 1.7072829847E-01, 1.5949609947E-01, 5.2106112734E-01],
	[9.7700000000E+03, 4.0610578248E+00, 6.0203675445E+00, 1.7099903614E-01, 1.5973598183E-01, 5.2121516562E-01],
	[9.7750000000E+03, 4.0637880402E+00, 6.0195086347E+00, 1.7127006371E-01, 1.5997608464E-01, 5.2136917879E-01],
	[9.7800000000E+03, 4.0665196476E+00, 6.0186546509E+00, 1.7154138131E-01, 1.6021641250E-01, 5.2152316689E-01],
	[9.7850000000E+03, 4.0692539177E+00, 6.0178113908E+00, 1.7181298913E-01, 1.6045697158E-01, 5.2167712995E-01],
	[9.7900000000E+03, 4.0719886281E+00, 6.0169686795E+00, 1.7208488732E-01, 1.6069775130E-01, 5.2183106802E-01],
	[9.7950000000E+03, 4.0747237786E+00, 6.0161265164E+00, 1.7235707604E-01, 1.6093875170E-01, 5.2198498112E-01],
	[9.8000000000E+03, 4.0774593691E+00, 6.0152849009E+00, 1.7262955545E-01, 1.6117997281E-01, 5.2213886928E-01],
	[9.8050000000E+03, 4.0801953994E+00, 6.0144438324E+00, 1.7290232571E-01, 1.6142141469E-01, 5.2229273256E-01],
	[9.8100000000E+03, 4.0829318693E+00, 6.0136033101E+00, 1.7317538699E-01, 1.6166307735E-01, 5.2244657097E-01],
	[9.8150000000E+03, 4.0856687787E+00, 6.0127633335E+00, 1.7344873944E-01, 1.6190496086E-01, 5.2260038456E-01],
	[9.8200000000E+03, 4.0884061274E+00, 6.0119239019E+00, 1.7372238323E-01, 1.6214706523E-01, 5.2275417336E-01],
	[9.8250000000E+03, 4.0911439153E+00, 6.0110850148E+00, 1.7399631851E-01, 1.6238939052E-01, 5.2290793740E-01],
	[9.8300000000E+03, 4.0938821422E+00, 6.0102466714E+00, 1.7427054545E-01, 1.6263193677E-01, 5.2306167672E-01],
	[9.8350000000E+03, 4.0966208080E+00, 6.0094088711E+00, 1.7454506420E-01, 1.6287470400E-01, 5.2321539136E-01],
	[9.8400000000E+03, 4.0993599126E+00, 6.0085716134E+00, 1.7481987494E-01, 1.6311769226E-01, 5.2336908135E-01],
	[9.8450000000E+03, 4.1020994557E+00, 6.0077348975E+00, 1.7509497782E-01, 1.6336090159E-01, 5.2352274672E-01],
	[9.8500000000E+03, 4.1048394372E+00, 6.0068987230E+00, 1.7537037299E-01, 1.6360433203E-01, 5.2367638752E-01],
	[9.8550000000E+03, 4.1075798570E+00, 6.0060630890E+00, 1.7564606063E-01, 1.6384798361E-01, 5.2383000377E-01],
	[9.8600000000E+03, 4.1103207149E+00, 6.0052279951E+00, 1.7592204089E-01, 1.6409185638E-01, 5.2398359551E-01],
	[9.8650000000E+03, 4.1130620108E+00, 6.0043934406E+00, 1.7619831393E-01, 1.6433595036E-01, 5.2413716278E-01],
	[9.8700000000E+03, 4.1158037445E+00, 6.0035594248E+00, 1.7647487992E-01, 1.6458026560E-01, 5.2429070561E-01],
	[9.8750000000E+03, 4.1185459158E+00, 6.0027259472E+00, 1.7675173901E-01, 1.6482480214E-01, 5.2444422404E-01],
	[9.8800000000E+03, 4.1212885247E+00, 6.0018930071E+00, 1.7702889137E-01, 1.6506956001E-01, 5.2459771810E-01],
	[9.8850000000E+03, 4.1240315709E+00, 6.0010606039E+00, 1.7730633716E-01, 1.6531453926E-01, 5.2475118782E-01],
	[9.8900000000E+03, 4.1267750543E+00, 6.0002287371E+00, 1.7758407653E-01, 1.6555973991E-01, 5.2490463325E-01],
	[9.8950000000E+03, 4.1295189747E+00, 5.9993974059E+00, 1.7786210966E-01, 1.6580516200E-01, 5.2505805442E-01],
	[9.9000000000E+03, 4.1322633321E+00, 5.9985666097E+00, 1.7814043669E-01, 1.6605080558E-01, 5.2521145136E-01],
	[9.9050000000E+03, 4.1350081262E+00, 5.9977363481E+00, 1.7841905780E-01, 1.6629667068E-01, 5.2536482411E-01],
	[9.9100000000E+03, 4.1377533569E+00, 5.9969066202E+00, 1.7869797314E-01, 1.6654275733E-01, 5.2551817270E-01],
	[9.9150000000E+03, 4.1404990241E+00, 5.9960774256E+00, 1.7897718287E-01, 1.6678906558E-01, 5.2567149717E-01],
	[9.9200000000E+03, 4.1432451275E+00, 5.9952487636E+00, 1.7925668715E-01, 1.6703559545E-01, 5.2582479756E-01],
	[9.9250000000E+03, 4.1459916671E+00, 5.9944206336E+00, 1.7953648615E-01, 1.6728234699E-01, 5.2597807390E-01],
	[9.9300000000E+03, 4.1487386427E+00, 5.9935930350E+00, 1.7981658003E-01, 1.6752932022E-01, 5.2613132622E-01],
	[9.9350000000E+03, 4.1514860541E+00, 5.9927659672E+00, 1.8009696894E-01, 1.6777651520E-01, 5.2628455456E-01],
	[9.9400000000E+03, 4.1542364264E+00, 5.9919507230E+00, 1.8037765305E-01, 1.6802394496E-01, 5.2643775896E-01],
	[9.9450000000E+03, 4.1569878052E+00, 5.9911385424E+00, 1.8065863252E-01, 1.6827159953E-01, 5.2659093945E-01],
	[9.9500000000E+03, 4.1597396220E+00, 5.9903268799E+00, 1.8093990751E-01, 1.6851947603E-01, 5.2674409607E-01],
	[9.9550000000E+03, 4.1624918766E+00, 5.9895157351E+00, 1.8122147818E-01, 1.6876757449E-01, 5.2689722885E-01],
	[9.9600000000E+03, 4.1652445687E+00, 5.9887051074E+00, 1.8150334469E-01, 1.6901589495E-01, 5.2705033782E-01],
	[9.9650000000E+03, 4.1679976984E+00, 5.9878949962E+00, 1.8178550721E-01, 1.6926443744E-01, 5.2720342303E-01],
	[9.9700000000E+03, 4.1707512654E+00, 5.9870854008E+00, 1.8206796589E-01, 1.6951320200E-01, 5.2735648451E-01],
	[9.9750000000E+03, 4.1735052696E+00, 5.9862763207E+00, 1.8235072090E-01, 1.6976218866E-01, 5.2750952230E-01],
	[9.9800000000E+03, 4.1762597108E+00, 5.9854677553E+00, 1.8263377239E-01, 1.7001139746E-01, 5.2766253642E-01],
	[9.9850000000E+03, 4.1790145889E+00, 5.9846597040E+00, 1.8291712053E-01, 1.7026082844E-01, 5.2781552692E-01],
	[9.9900000000E+03, 4.1817699038E+00, 5.9838521663E+00, 1.8320076548E-01, 1.7051048162E-01, 5.2796849383E-01],
	[9.9950000000E+03, 4.1845256552E+00, 5.9830451416E+00, 1.8348470740E-01, 1.7076035705E-01, 5.2812143718E-01],
	[1.0000000000E+04, 4.1872818430E+00, 5.9822386292E+00, 1.8376894645E-01, 1.7101045475E-01, 5.2827435702E-01],
	[1.0005000000E+04, 4.1900384672E+00, 5.9814326286E+00, 1.8405464882E-01, 1.7126178434E-01, 5.2842725338E-01],
	[1.0010000000E+04, 4.1927955275E+00, 5.9806271392E+00, 1.8434065169E-01, 1.7151333856E-01, 5.2858012628E-01],
	[1.0015000000E+04, 4.1955530237E+00, 5.9798221604E+00, 1.8462695522E-01, 1.7176511746E-01, 5.2873297578E-01],
	[1.0020000000E+04, 4.1983109558E+00, 5.9790176917E+00, 1.8491355958E-01, 1.7201712106E-01, 5.2888580190E-01],
	[1.0025000000E+04, 4.2010693236E+00, 5.9782137325E+00, 1.8520046492E-01, 1.7226934941E-01, 5.2903860468E-01],
	[1.0030000000E+04, 4.2038281270E+00, 5.9774102822E+00, 1.8548767142E-01, 1.7252180254E-01, 5.2919138416E-01],
	[1.0035000000E+04, 4.2065873657E+00, 5.9766073401E+00, 1.8577517924E-01, 1.7277448048E-01, 5.2934414037E-01],
	[1.0040000000E+04, 4.2093470397E+00, 5.9758049059E+00, 1.8606298855E-01, 1.7302738327E-01, 5.2949687334E-01],
	[1.0045000000E+04, 4.2121071487E+00, 5.9750029788E+00, 1.8635109950E-01, 1.7328051094E-01, 5.2964958312E-01],
	[1.0050000000E+04, 4.2148676927E+00, 5.9742015583E+00, 1.8663951227E-01, 1.7353386353E-01, 5.2980226974E-01],
	[1.0055000000E+04, 4.2176286716E+00, 5.9734006439E+00, 1.8692822701E-01, 1.7378744107E-01, 5.2995493323E-01],
	[1.0060000000E+04, 4.2203900850E+00, 5.9726002349E+00, 1.8721724390E-01, 1.7404124360E-01, 5.3010757363E-01],
	[1.0065000000E+04, 4.2231519330E+00, 5.9718003308E+00, 1.8750656310E-01, 1.7429527115E-01, 5.3026019097E-01],
	[1.0070000000E+04, 4.2259142153E+00, 5.9710009310E+00, 1.8779618477E-01, 1.7454952375E-01, 5.3041278530E-01],
	[1.0075000000E+04, 4.2286769319E+00, 5.9702020350E+00, 1.8808610908E-01, 1.7480400144E-01, 5.3056535664E-01],
	[1.0080000000E+04, 4.2314400825E+00, 5.9694036422E+00, 1.8837633619E-01, 1.7505870425E-01, 5.3071790503E-01],
	[1.0085000000E+04, 4.2342036670E+00, 5.9686057519E+00, 1.8866686626E-01, 1.7531363222E-01, 5.3087043052E-01],
	[1.0090000000E+04, 4.2369676853E+00, 5.9678083638E+00, 1.8895769947E-01, 1.7556878537E-01, 5.3102293312E-01],
	[1.0095000000E+04, 4.2397321372E+00, 5.9670114771E+00, 1.8924883598E-01, 1.7582416375E-01, 5.3117541289E-01],
	[1.0100000000E+04, 4.2424996027E+00, 5.9662260447E+00, 1.8954027594E-01, 1.7607978136E-01, 5.3132786985E-01],
	[1.0105000000E+04, 4.2452680504E+00, 5.9654434234E+00, 1.8983201954E-01, 1.7633562731E-01, 5.3148030405E-01],
	[1.0110000000E+04, 4.2480369337E+00, 5.9646612918E+00, 1.9012406692E-01, 1.7659169866E-01, 5.3163271551E-01],
	[1.0115000000E+04, 4.2508062526E+00, 5.9638796494E+00, 1.9041641826E-01, 1.7684799545E-01, 5.3178510427E-01],
	[1.0120000000E+04, 4.2535760069E+00, 5.9630984956E+00, 1.9070907372E-01, 1.7710451771E-01, 5.3193747038E-01],
	[1.0125000000E+04, 4.2563461965E+00, 5.9623178299E+00, 1.9100203347E-01, 1.7736126547E-01, 5.3208981386E-01],
	[1.0130000000E+04, 4.2591168212E+00, 5.9615376518E+00, 1.9129529767E-01, 1.7761823878E-01, 5.3224213475E-01],
	[1.0135000000E+04, 4.2618878809E+00, 5.9607579607E+00, 1.9158886648E-01, 1.7787543765E-01, 5.3239443308E-01],
	[1.0140000000E+04, 4.2646593755E+00, 5.9599787560E+00, 1.9188274007E-01, 1.7813286213E-01, 5.3254670890E-01],
	[1.0145000000E+04, 4.2674313047E+00, 5.9592000372E+00, 1.9217691861E-01, 1.7839051224E-01, 5.3269896224E-01],
	[1.0150000000E+04, 4.2702036684E+00, 5.9584218038E+00, 1.9247140226E-01, 1.7864838801E-01, 5.3285119314E-01],
	[1.0155000000E+04, 4.2729764666E+00, 5.9576440552E+00, 1.9276619118E-01, 1.7890648948E-01, 5.3300340162E-01],
	[1.0160000000E+04, 4.2757496989E+00, 5.9568667910E+00, 1.9306128554E-01, 1.7916481669E-01, 5.3315558773E-01],
	[1.0165000000E+04, 4.2785233654E+00, 5.9560900104E+00, 1.9335668551E-01, 1.7942336965E-01, 5.3330775150E-01],
	[1.0170000000E+04, 4.2812974659E+00, 5.9553137131E+00, 1.9365239125E-01, 1.7968214840E-01, 5.3345989297E-01],
	[1.0175000000E+04, 4.2840720001E+00, 5.9545378985E+00, 1.9394840292E-01, 1.7994115298E-01, 5.3361201218E-01],
	[1.0180000000E+04, 4.2868469681E+00, 5.9537625659E+00, 1.9424472069E-01, 1.8020038341E-01, 5.3376410915E-01],
	[1.0185000000E+04, 4.2896223695E+00, 5.9529877150E+00, 1.9454134472E-01, 1.8045983973E-01, 5.3391618393E-01],
	[1.0190000000E+04, 4.2923982043E+00, 5.9522133452E+00, 1.9483827518E-01, 1.8071952196E-01, 5.3406823656E-01],
	[1.0195000000E+04, 4.2951744724E+00, 5.9514394559E+00, 1.9513551224E-01, 1.8097943014E-01, 5.3422026706E-01],
	[1.0200000000E+04, 4.2979511735E+00, 5.9506660465E+00, 1.9543305606E-01, 1.8123956430E-01, 5.3437227548E-01],
	[1.0205000000E+04, 4.3007283076E+00, 5.9498931167E+00, 1.9573090680E-01, 1.8149992446E-01, 5.3452426185E-01],
	[1.0210000000E+04, 4.3035058744E+00, 5.9491206657E+00, 1.9602906463E-01, 1.8176051066E-01, 5.3467622620E-01],
	[1.0215000000E+04, 4.3062838739E+00, 5.9483486932E+00, 1.9632752971E-01, 1.8202132293E-01, 5.3482816858E-01],
	[1.0220000000E+04, 4.3090623060E+00, 5.9475771985E+00, 1.9662630221E-01, 1.8228236130E-01, 5.3498008902E-01],
	[1.0225000000E+04, 4.3118411703E+00, 5.9468061812E+00, 1.9692538230E-01, 1.8254362579E-01, 5.3513198755E-01],
	[1.0230000000E+04, 4.3146204669E+00, 5.9460356407E+00, 1.9722477013E-01, 1.8280511644E-01, 5.3528386421E-01],
	[1.0235000000E+04, 4.3174001956E+00, 5.9452655765E+00, 1.9752446588E-01, 1.8306683328E-01, 5.3543571905E-01],
	[1.0240000000E+04, 4.3201803562E+00, 5.9444959880E+00, 1.9782446971E-01, 1.8332877633E-01, 5.3558755208E-01],
	[1.0245000000E+04, 4.3229609486E+00, 5.9437268748E+00, 1.9812478178E-01, 1.8359094563E-01, 5.3573936335E-01],
	[1.0250000000E+04, 4.3257419726E+00, 5.9429582362E+00, 1.9842540226E-01, 1.8385334120E-01, 5.3589115291E-01],
	[1.0255000000E+04, 4.3285234282E+00, 5.9421900719E+00, 1.9872633131E-01, 1.8411596307E-01, 5.3604292077E-01],
	[1.0260000000E+04, 4.3313063529E+00, 5.9414264713E+00, 1.9902756910E-01, 1.8437881710E-01, 5.3619466698E-01],
	[1.0265000000E+04, 4.3340919234E+00, 5.9406720589E+00, 1.9932911580E-01, 1.8464190995E-01, 5.3634639158E-01],
	[1.0270000000E+04, 4.3368779276E+00, 5.9399181096E+00, 1.9963097156E-01, 1.8490522928E-01, 5.3649809459E-01],
	[1.0275000000E+04, 4.3396643653E+00, 5.9391646229E+00, 1.9993313656E-01, 1.8516877512E-01, 5.3664977607E-01],
	[1.0280000000E+04, 4.3424512364E+00, 5.9384115983E+00, 2.0023561096E-01, 1.8543254750E-01, 5.3680143604E-01],
	[1.0285000000E+04, 4.3452385407E+00, 5.9376590352E+00, 2.0053839492E-01, 1.8569654644E-01, 5.3695307453E-01],
	[1.0290000000E+04, 4.3480262782E+00, 5.9369069333E+00, 2.0084148861E-01, 1.8596077198E-01, 5.3710469160E-01],
	[1.0295000000E+04, 4.3508144485E+00, 5.9361552918E+00, 2.0114489220E-01, 1.8622522413E-01, 5.3725628726E-01],
	[1.0300000000E+04, 4.3536030517E+00, 5.9354041105E+00, 2.0144860584E-01, 1.8648990294E-01, 5.3740786156E-01],
	[1.0305000000E+04, 4.3563920875E+00, 5.9346533887E+00, 2.0175262971E-01, 1.8675480842E-01, 5.3755941448E-01],
	[1.0310000000E+04, 4.3591815558E+00, 5.9339031259E+00, 2.0205696396E-01, 1.8701994061E-01, 5.3771094600E-01],
	[1.0315000000E+04, 4.3619714565E+00, 5.9331533217E+00, 2.0236160877E-01, 1.8728529952E-01, 5.3786245614E-01],
	[1.0320000000E+04, 4.3647617895E+00, 5.9324039755E+00, 2.0266656430E-01, 1.8755088520E-01, 5.3801394491E-01],
	[1.0325000000E+04, 4.3675525545E+00, 5.9316550869E+00, 2.0297183072E-01, 1.8781669766E-01, 5.3816541234E-01],
	[1.0330000000E+04, 4.3703437515E+00, 5.9309066552E+00, 2.0327740818E-01, 1.8808273694E-01, 5.3831685842E-01],
	[1.0335000000E+04, 4.3731353802E+00, 5.9301586802E+00, 2.0358329686E-01, 1.8834900305E-01, 5.3846828319E-01],
	[1.0340000000E+04, 4.3759274407E+00, 5.9294111612E+00, 2.0388949692E-01, 1.8861549603E-01, 5.3861968664E-01],
	[1.0345000000E+04, 4.3787199326E+00, 5.9286640977E+00, 2.0419600853E-01, 1.8888221591E-01, 5.3877106881E-01],
	[1.0350000000E+04, 4.3815128560E+00, 5.9279174892E+00, 2.0450283184E-01, 1.8914916270E-01, 5.3892242969E-01],
	[1.0355000000E+04, 4.3843062105E+00, 5.9271713354E+00, 2.0480996703E-01, 1.8941633644E-01, 5.3907376930E-01],
	[1.0360000000E+04, 4.3870999962E+00, 5.9264256355E+00, 2.0511741426E-01, 1.8968373715E-01, 5.3922508766E-01],
	[1.0365000000E+04, 4.3898942128E+00, 5.9256803892E+00, 2.0542517370E-01, 1.8995136486E-01, 5.3937638479E-01],
	[1.0370000000E+04, 4.3926888602E+00, 5.9249355960E+00, 2.0573324550E-01, 1.9021921959E-01, 5.3952766069E-01],
	[1.0375000000E+04, 4.3954839383E+00, 5.9241912554E+00, 2.0604162985E-01, 1.9048730138E-01, 5.3967891538E-01],
	[1.0380000000E+04, 4.3982794469E+00, 5.9234473668E+00, 2.0635032689E-01, 1.9075561023E-01, 5.3983014888E-01],
	[1.0385000000E+04, 4.4010753859E+00, 5.9227039298E+00, 2.0665933680E-01, 1.9102414619E-01, 5.3998136120E-01],
	[1.0390000000E+04, 4.4038717552E+00, 5.9219609439E+00, 2.0696865974E-01, 1.9129290928E-01, 5.4013255235E-01],
	[1.0395000000E+04, 4.4066685546E+00, 5.9212184086E+00, 2.0727829588E-01, 1.9156189951E-01, 5.4028372235E-01],
	[1.0400000000E+04, 4.4094657839E+00, 5.9204763234E+00, 2.0758824538E-01, 1.9183111692E-01, 5.4043487122E-01],
	[1.0405000000E+04, 4.4122634430E+00, 5.9197346878E+00, 2.0789850841E-01, 1.9210056153E-01, 5.4058599896E-01],
	[1.0410000000E+04, 4.4150615319E+00, 5.9189935014E+00, 2.0820908512E-01, 1.9237023337E-01, 5.4073710559E-01],
	[1.0415000000E+04, 4.4178600502E+00, 5.9182527636E+00, 2.0851997570E-01, 1.9264013246E-01, 5.4088819114E-01],
	[1.0420000000E+04, 4.4206589980E+00, 5.9175124739E+00, 2.0883118030E-01, 1.9291025882E-01, 5.4103925560E-01],
	[1.0425000000E+04, 4.4234593550E+00, 5.9167762172E+00, 2.0914269909E-01, 1.9318061817E-01, 5.4119029900E-01],
	[1.0430000000E+04, 4.4262625420E+00, 5.9160491801E+00, 2.0945453223E-01, 1.9345121884E-01, 5.4134132134E-01],
	[1.0435000000E+04, 4.4290661606E+00, 5.9153225807E+00, 2.0976667988E-01, 1.9372204695E-01, 5.4149232266E-01],
	[1.0440000000E+04, 4.4318702108E+00, 5.9145964185E+00, 2.1007914223E-01, 1.9399310253E-01, 5.4164330295E-01],
	[1.0445000000E+04, 4.4346746923E+00, 5.9138706932E+00, 2.1039191942E-01, 1.9426438559E-01, 5.4179426224E-01],
	[1.0450000000E+04, 4.4374796051E+00, 5.9131454041E+00, 2.1070501162E-01, 1.9453589618E-01, 5.4194520054E-01],
	[1.0455000000E+04, 4.4402849489E+00, 5.9124205508E+00, 2.1101841901E-01, 1.9480763430E-01, 5.4209611786E-01],
	[1.0460000000E+04, 4.4430907236E+00, 5.9116961329E+00, 2.1133214173E-01, 1.9507959998E-01, 5.4224701422E-01],
	[1.0465000000E+04, 4.4458969292E+00, 5.9109721500E+00, 2.1164617997E-01, 1.9535179324E-01, 5.4239788963E-01],
	[1.0470000000E+04, 4.4487035654E+00, 5.9102486014E+00, 2.1196053389E-01, 1.9562421412E-01, 5.4254874412E-01],
	[1.0475000000E+04, 4.4515106322E+00, 5.9095254868E+00, 2.1227520364E-01, 1.9589686262E-01, 5.4269957768E-01],
	[1.0480000000E+04, 4.4543181293E+00, 5.9088028057E+00, 2.1259018940E-01, 1.9616973878E-01, 5.4285039035E-01],
	[1.0485000000E+04, 4.4571260566E+00, 5.9080805576E+00, 2.1290549133E-01, 1.9644284262E-01, 5.4300118212E-01],
	[1.0490000000E+04, 4.4599344141E+00, 5.9073587420E+00, 2.1322110960E-01, 1.9671617416E-01, 5.4315195303E-01],
	[1.0495000000E+04, 4.4627432015E+00, 5.9066373586E+00, 2.1353704437E-01, 1.9698973341E-01, 5.4330270308E-01],
	[1.0500000000E+04, 4.4655524188E+00, 5.9059164067E+00, 2.1385329581E-01, 1.9726352042E-01, 5.4345343228E-01],
	[1.0505000000E+04, 4.4683620657E+00, 5.9051958861E+00, 2.1416986408E-01, 1.9753753519E-01, 5.4360414066E-01],
	[1.0510000000E+04, 4.4711721422E+00, 5.9044757961E+00, 2.1448674934E-01, 1.9781177774E-01, 5.4375482823E-01],
	[1.0515000000E+04, 4.4739826481E+00, 5.9037561364E+00, 2.1480395177E-01, 1.9808624811E-01, 5.4390549500E-01],
	[1.0520000000E+04, 4.4767935833E+00, 5.9030369065E+00, 2.1512147153E-01, 1.9836094631E-01, 5.4405614099E-01],
	[1.0525000000E+04, 4.4796049475E+00, 5.9023181058E+00, 2.1543930879E-01, 1.9863587237E-01, 5.4420676621E-01],
	[1.0530000000E+04, 4.4824167408E+00, 5.9015997341E+00, 2.1575746370E-01, 1.9891102630E-01, 5.4435737068E-01],
	[1.0535000000E+04, 4.4852289630E+00, 5.9008817907E+00, 2.1607593643E-01, 1.9918640812E-01, 5.4450795441E-01],
	[1.0540000000E+04, 4.4880416138E+00, 5.9001642753E+00, 2.1639472716E-01, 1.9946201787E-01, 5.4465851743E-01],
	[1.0545000000E+04, 4.4908546932E+00, 5.8994471873E+00, 2.1671383604E-01, 1.9973785555E-01, 5.4480905973E-01],
	[1.0550000000E+04, 4.4936682011E+00, 5.8987305264E+00, 2.1703326324E-01, 2.0001392119E-01, 5.4495958135E-01],
	[1.0555000000E+04, 4.4964821373E+00, 5.8980142920E+00, 2.1735300893E-01, 2.0029021482E-01, 5.4511008229E-01],
	[1.0560000000E+04, 4.4992965016E+00, 5.8972984838E+00, 2.1767307327E-01, 2.0056673644E-01, 5.4526056257E-01],
	[1.0565000000E+04, 4.5021112940E+00, 5.8965831012E+00, 2.1799345643E-01, 2.0084348609E-01, 5.4541102220E-01],
	[1.0570000000E+04, 4.5049265142E+00, 5.8958681438E+00, 2.1831415856E-01, 2.0112046378E-01, 5.4556146121E-01],
	[1.0575000000E+04, 4.5077421622E+00, 5.8951536111E+00, 2.1863517985E-01, 2.0139766953E-01, 5.4571187960E-01],
	[1.0580000000E+04, 4.5105582379E+00, 5.8944395028E+00, 2.1895652045E-01, 2.0167510336E-01, 5.4586227739E-01],
	[1.0585000000E+04, 4.5133747409E+00, 5.8937258183E+00, 2.1927818053E-01, 2.0195276530E-01, 5.4601265460E-01],
	[1.0590000000E+04, 4.5161916714E+00, 5.8930125571E+00, 2.1960016025E-01, 2.0223065535E-01, 5.4616301124E-01],
	[1.0595000000E+04, 4.5190115874E+00, 5.8923084137E+00, 2.1992245978E-01, 2.0250878896E-01, 5.4631334733E-01],
	[1.0600000000E+04, 4.5218328840E+00, 5.8916079177E+00, 2.2024507929E-01, 2.0278715654E-01, 5.4646366289E-01],
	[1.0605000000E+04, 4.5246546102E+00, 5.8909078353E+00, 2.2056801893E-01, 2.0306575240E-01, 5.4661395792E-01],
	[1.0610000000E+04, 4.5274767659E+00, 5.8902081660E+00, 2.2089127888E-01, 2.0334457657E-01, 5.4676423244E-01],
	[1.0615000000E+04, 4.5302993510E+00, 5.8895089094E+00, 2.2121485931E-01, 2.0362362905E-01, 5.4691448647E-01],
	[1.0620000000E+04, 4.5331223654E+00, 5.8888100651E+00, 2.2153876037E-01, 2.0390290987E-01, 5.4706472003E-01],
	[1.0625000000E+04, 4.5359458088E+00, 5.8881116325E+00, 2.2186298223E-01, 2.0418241905E-01, 5.4721493313E-01],
	[1.0630000000E+04, 4.5387696812E+00, 5.8874136113E+00, 2.2218752506E-01, 2.0446215661E-01, 5.4736512579E-01],
	[1.0635000000E+04, 4.5415939825E+00, 5.8867160011E+00, 2.2251238902E-01, 2.0474212256E-01, 5.4751529802E-01],
	[1.0640000000E+04, 4.5444187124E+00, 5.8860188014E+00, 2.2283757429E-01, 2.0502231693E-01, 5.4766544983E-01],
	[1.0645000000E+04, 4.5472438709E+00, 5.8853220117E+00, 2.2316308101E-01, 2.0530273972E-01, 5.4781558125E-01],
	[1.0650000000E+04, 4.5500694578E+00, 5.8846256317E+00, 2.2348890937E-01, 2.0558339097E-01, 5.4796569229E-01],
	[1.0655000000E+04, 4.5528954730E+00, 5.8839296609E+00, 2.2381505952E-01, 2.0586427069E-01, 5.4811578297E-01],
	[1.0660000000E+04, 4.5557219164E+00, 5.8832340988E+00, 2.2414153163E-01, 2.0614537890E-01, 5.4826585329E-01],
	[1.0665000000E+04, 4.5585487878E+00, 5.8825389451E+00, 2.2446832587E-01, 2.0642671561E-01, 5.4841590328E-01],
	[1.0670000000E+04, 4.5613760870E+00, 5.8818441993E+00, 2.2479544240E-01, 2.0670828084E-01, 5.4856593295E-01],
	[1.0675000000E+04, 4.5642038140E+00, 5.8811498610E+00, 2.2512288139E-01, 2.0699007461E-01, 5.4871594232E-01],
	[1.0680000000E+04, 4.5670319686E+00, 5.8804559297E+00, 2.2545064300E-01, 2.0727209694E-01, 5.4886593141E-01],
	[1.0685000000E+04, 4.5698605506E+00, 5.8797624051E+00, 2.2577872740E-01, 2.0755434784E-01, 5.4901590022E-01],
	[1.0690000000E+04, 4.5726895600E+00, 5.8790692866E+00, 2.2610713475E-01, 2.0783682733E-01, 5.4916584879E-01],
	[1.0695000000E+04, 4.5755189966E+00, 5.8783765739E+00, 2.2643586522E-01, 2.0811953544E-01, 5.4931577711E-01],
	[1.0700000000E+04, 4.5783488602E+00, 5.8776842665E+00, 2.2676491898E-01, 2.0840247216E-01, 5.4946568521E-01],
	[1.0705000000E+04, 4.5811791508E+00, 5.8769923641E+00, 2.2709429619E-01, 2.0868563753E-01, 5.4961557310E-01],
	[1.0710000000E+04, 4.5840098682E+00, 5.8763008661E+00, 2.2742399702E-01, 2.0896903156E-01, 5.4976544080E-01],
	[1.0715000000E+04, 4.5868410122E+00, 5.8756097722E+00, 2.2775402162E-01, 2.0925265426E-01, 5.4991528833E-01],
	[1.0720000000E+04, 4.5896725828E+00, 5.8749190819E+00, 2.2808437018E-01, 2.0953650566E-01, 5.5006511570E-01],
	[1.0725000000E+04, 4.5925045797E+00, 5.8742287949E+00, 2.2841504285E-01, 2.0982058576E-01, 5.5021492293E-01],
	[1.0730000000E+04, 4.5953370029E+00, 5.8735389106E+00, 2.2874603979E-01, 2.1010489458E-01, 5.5036471004E-01],
	[1.0735000000E+04, 4.5981698522E+00, 5.8728494287E+00, 2.2907736118E-01, 2.1038943214E-01, 5.5051447703E-01],
	[1.0740000000E+04, 4.6010031275E+00, 5.8721603487E+00, 2.2940900718E-01, 2.1067419846E-01, 5.5066422393E-01],
	[1.0745000000E+04, 4.6038368286E+00, 5.8714716702E+00, 2.2974097796E-01, 2.1095919354E-01, 5.5081395075E-01],
	[1.0750000000E+04, 4.6066709555E+00, 5.8707833929E+00, 2.3007327368E-01, 2.1124441741E-01, 5.5096365751E-01],
	[1.0755000000E+04, 4.6095055080E+00, 5.8700955162E+00, 2.3040589450E-01, 2.1152987008E-01, 5.5111334422E-01],
	[1.0760000000E+04, 4.6123404859E+00, 5.8694080398E+00, 2.3073884060E-01, 2.1181555157E-01, 5.5126301091E-01],
	[1.0765000000E+04, 4.6151781743E+00, 5.8687281859E+00, 2.3107211214E-01, 2.1210147614E-01, 5.5141265758E-01],
	[1.0770000000E+04, 4.6180176454E+00, 5.8680530084E+00, 2.3140570928E-01, 2.1238763811E-01, 5.5156228426E-01],
	[1.0775000000E+04, 4.6208575444E+00, 5.8673782219E+00, 2.3173963218E-01, 2.1267402904E-01, 5.5171189095E-01],
	[1.0780000000E+04, 4.6236978711E+00, 5.8667038261E+00, 2.3207388103E-01, 2.1296064895E-01, 5.5186147768E-01],
	[1.0785000000E+04, 4.6265386253E+00, 5.8660298204E+00, 2.3240845597E-01, 2.1324749785E-01, 5.5201104447E-01],
	[1.0790000000E+04, 4.6293798070E+00, 5.8653562045E+00, 2.3274335719E-01, 2.1353457577E-01, 5.5216059132E-01],
	[1.0795000000E+04, 4.6322214159E+00, 5.8646829779E+00, 2.3307858483E-01, 2.1382188271E-01, 5.5231011826E-01],
	[1.0800000000E+04, 4.6350634521E+00, 5.8640101404E+00, 2.3341413907E-01, 2.1410941868E-01, 5.5245962530E-01],
	[1.0805000000E+04, 4.6379059152E+00, 5.8633376914E+00, 2.3375002008E-01, 2.1439718371E-01, 5.5260911246E-01],
	[1.0810000000E+04, 4.6407488053E+00, 5.8626656306E+00, 2.3408622801E-01, 2.1468517780E-01, 5.5275857975E-01],
	[1.0815000000E+04, 4.6435921221E+00, 5.8619939575E+00, 2.3442276304E-01, 2.1497340098E-01, 5.5290802720E-01],
	[1.0820000000E+04, 4.6464358655E+00, 5.8613226718E+00, 2.3475962533E-01, 2.1526185324E-01, 5.5305745481E-01],
	[1.0825000000E+04, 4.6492800354E+00, 5.8606517730E+00, 2.3509681505E-01, 2.1555053462E-01, 5.5320686261E-01],
	[1.0830000000E+04, 4.6521246317E+00, 5.8599812608E+00, 2.3543433236E-01, 2.1583944511E-01, 5.5335625060E-01],
	[1.0835000000E+04, 4.6549696543E+00, 5.8593111347E+00, 2.3577217743E-01, 2.1612858473E-01, 5.5350561882E-01],
	[1.0840000000E+04, 4.6578151029E+00, 5.8586413944E+00, 2.3611035042E-01, 2.1641795350E-01, 5.5365496727E-01],
	[1.0845000000E+04, 4.6606609775E+00, 5.8579720395E+00, 2.3644885150E-01, 2.1670755143E-01, 5.5380429596E-01],
	[1.0850000000E+04, 4.6635072779E+00, 5.8573030695E+00, 2.3678768084E-01, 2.1699737853E-01, 5.5395360493E-01],
	[1.0855000000E+04, 4.6663540040E+00, 5.8566344840E+00, 2.3712683860E-01, 2.1728743481E-01, 5.5410289418E-01],
	[1.0860000000E+04, 4.6692011557E+00, 5.8559662827E+00, 2.3746632494E-01, 2.1757772029E-01, 5.5425216373E-01],
	[1.0865000000E+04, 4.6720487328E+00, 5.8552984652E+00, 2.3780614004E-01, 2.1786823498E-01, 5.5440141359E-01],
	[1.0870000000E+04, 4.6748967352E+00, 5.8546310310E+00, 2.3814628406E-01, 2.1815897889E-01, 5.5455064379E-01],
	[1.0875000000E+04, 4.6777451628E+00, 5.8539639797E+00, 2.3848675716E-01, 2.1844995203E-01, 5.5469985435E-01],
	[1.0880000000E+04, 4.6805940155E+00, 5.8532973111E+00, 2.3882755951E-01, 2.1874115441E-01, 5.5484904526E-01],
	[1.0885000000E+04, 4.6834432930E+00, 5.8526310246E+00, 2.3916869127E-01, 2.1903258605E-01, 5.5499821657E-01],
	[1.0890000000E+04, 4.6862929953E+00, 5.8519651199E+00, 2.3951015262E-01, 2.1932424696E-01, 5.5514736827E-01],
	[1.0895000000E+04, 4.6891431222E+00, 5.8512995966E+00, 2.3985194371E-01, 2.1961613715E-01, 5.5529650039E-01],
	[1.0900000000E+04, 4.6919936737E+00, 5.8506344543E+00, 2.4019406472E-01, 2.1990825662E-01, 5.5544561295E-01],
	[1.0905000000E+04, 4.6948446495E+00, 5.8499696926E+00, 2.4053651581E-01, 2.2020060540E-01, 5.5559470595E-01],
	[1.0910000000E+04, 4.6976960496E+00, 5.8493053110E+00, 2.4087929714E-01, 2.2049318349E-01, 5.5574377943E-01],
	[1.0915000000E+04, 4.7005478738E+00, 5.8486413093E+00, 2.4122240888E-01, 2.2078599089E-01, 5.5589283339E-01],
	[1.0920000000E+04, 4.7034001220E+00, 5.8479776871E+00, 2.4156585120E-01, 2.2107902764E-01, 5.5604186786E-01],
	[1.0925000000E+04, 4.7062527940E+00, 5.8473144438E+00, 2.4190962426E-01, 2.2137229372E-01, 5.5619088284E-01],
	[1.0930000000E+04, 4.7091058898E+00, 5.8466515792E+00, 2.4225372823E-01, 2.2166578916E-01, 5.5633987831E-01],
	[1.0935000000E+04, 4.7119594092E+00, 5.8459890929E+00, 2.4259816328E-01, 2.2195951397E-01, 5.5648885426E-01],
	[1.0940000000E+04, 4.7148170403E+00, 5.8453378305E+00, 2.4294292956E-01, 2.2225349202E-01, 5.5663781069E-01],
	[1.0945000000E+04, 4.7176751828E+00, 5.8446871884E+00, 2.4328802725E-01, 2.2254770012E-01, 5.5678674761E-01],
	[1.0950000000E+04, 4.7205337512E+00, 5.8440369157E+00, 2.4363345651E-01, 2.2284213772E-01, 5.5693566500E-01],
	[1.0955000000E+04, 4.7233927456E+00, 5.8433870123E+00, 2.4397921751E-01, 2.2313680484E-01, 5.5708456289E-01],
	[1.0960000000E+04, 4.7262521658E+00, 5.8427374776E+00, 2.4432531042E-01, 2.2343170149E-01, 5.5723344126E-01],
	[1.0965000000E+04, 4.7291120116E+00, 5.8420883114E+00, 2.4467173539E-01, 2.2372682766E-01, 5.5738230011E-01],
	[1.0970000000E+04, 4.7319722829E+00, 5.8414395131E+00, 2.4501849260E-01, 2.2402218339E-01, 5.5753113946E-01],
	[1.0975000000E+04, 4.7348329796E+00, 5.8407910825E+00, 2.4536558221E-01, 2.2431776866E-01, 5.5767995929E-01],
	[1.0980000000E+04, 4.7376941016E+00, 5.8401430192E+00, 2.4571300438E-01, 2.2461358350E-01, 5.5782875961E-01],
	[1.0985000000E+04, 4.7405556487E+00, 5.8394953228E+00, 2.4606075929E-01, 2.2490962791E-01, 5.5797754042E-01],
	[1.0990000000E+04, 4.7434176209E+00, 5.8388479929E+00, 2.4640884710E-01, 2.2520590190E-01, 5.5812630173E-01],
	[1.0995000000E+04, 4.7462800178E+00, 5.8382010292E+00, 2.4675726797E-01, 2.2550240548E-01, 5.5827504352E-01],
	[1.1000000000E+04, 4.7491428396E+00, 5.8375544312E+00, 2.4710602208E-01, 2.2579913865E-01, 5.5842376582E-01],
	[1.1005000000E+04, 4.7520060859E+00, 5.8369081987E+00, 2.4745510958E-01, 2.2609610143E-01, 5.5857246860E-01],
	[1.1010000000E+04, 4.7548697567E+00, 5.8362623311E+00, 2.4780453064E-01, 2.2639329383E-01, 5.5872115189E-01],
	[1.1015000000E+04, 4.7577338519E+00, 5.8356168283E+00, 2.4815428543E-01, 2.2669071584E-01, 5.5886981567E-01],
	[1.1020000000E+04, 4.7605983713E+00, 5.8349716897E+00, 2.4850437412E-01, 2.2698836749E-01, 5.5901845995E-01],
	[1.1025000000E+04, 4.7634633147E+00, 5.8343269151E+00, 2.4885479687E-01, 2.2728624878E-01, 5.5916708474E-01],
	[1.1030000000E+04, 4.7663286822E+00, 5.8336825040E+00, 2.4920555385E-01, 2.2758435971E-01, 5.5931569002E-01],
	[1.1035000000E+04, 4.7691944734E+00, 5.8330384560E+00, 2.4955664521E-01, 2.2788270029E-01, 5.5946427581E-01],
	[1.1040000000E+04, 4.7720606884E+00, 5.8323947709E+00, 2.4990807114E-01, 2.2818127053E-01, 5.5961284211E-01],
	[1.1045000000E+04, 4.7749273269E+00, 5.8317514483E+00, 2.5025983179E-01, 2.2848007044E-01, 5.5976138891E-01],
	[1.1050000000E+04, 4.7777943889E+00, 5.8311084877E+00, 2.5061192733E-01, 2.2877910003E-01, 5.5990991622E-01],
	[1.1055000000E+04, 4.7806618742E+00, 5.8304658888E+00, 2.5096435793E-01, 2.2907835929E-01, 5.6005842404E-01],
	[1.1060000000E+04, 4.7835297827E+00, 5.8298236512E+00, 2.5131712375E-01, 2.2937784825E-01, 5.6020691238E-01],
	[1.1065000000E+04, 4.7863981142E+00, 5.8291817746E+00, 2.5167022496E-01, 2.2967756690E-01, 5.6035538122E-01],
	[1.1070000000E+04, 4.7892668687E+00, 5.8285402587E+00, 2.5202366172E-01, 2.2997751524E-01, 5.6050383058E-01],
	[1.1075000000E+04, 4.7921360459E+00, 5.8278991029E+00, 2.5237743421E-01, 2.3027769330E-01, 5.6065226046E-01],
	[1.1080000000E+04, 4.7950056458E+00, 5.8272583071E+00, 2.5273154258E-01, 2.3057810107E-01, 5.6080067086E-01],
	[1.1085000000E+04, 4.7978756683E+00, 5.8266178708E+00, 2.5308598701E-01, 2.3087873856E-01, 5.6094906177E-01],
	[1.1090000000E+04, 4.8007461132E+00, 5.8259777936E+00, 2.5344076765E-01, 2.3117960578E-01, 5.6109743321E-01],
	[1.1095000000E+04, 4.8036169804E+00, 5.8253380752E+00, 2.5379588468E-01, 2.3148070273E-01, 5.6124578517E-01],
	[1.1100000000E+04, 4.8064882697E+00, 5.8246987152E+00, 2.5415133826E-01, 2.3178202941E-01, 5.6139411766E-01],
	[1.1105000000E+04, 4.8093599810E+00, 5.8240597132E+00, 2.5450712855E-01, 2.3208358584E-01, 5.6154243067E-01],
	[1.1110000000E+04, 4.8122321143E+00, 5.8234210690E+00, 2.5486325573E-01, 2.3238537201E-01, 5.6169072421E-01],
	[1.1115000000E+04, 4.8151076752E+00, 5.8227910151E+00, 2.5521971996E-01, 2.3268740811E-01, 5.6183899829E-01],
	[1.1120000000E+04, 4.8179845615E+00, 5.8221637798E+00, 2.5557652141E-01, 2.3298968011E-01, 5.6198725290E-01],
	[1.1125000000E+04, 4.8208618722E+00, 5.8215368940E+00, 2.5593366023E-01, 2.3329218199E-01, 5.6213548804E-01],
	[1.1130000000E+04, 4.8237396072E+00, 5.8209103574E+00, 2.5629113660E-01, 2.3359491375E-01, 5.6228370372E-01],
	[1.1135000000E+04, 4.8266177664E+00, 5.8202841696E+00, 2.5664895069E-01, 2.3389787540E-01, 5.6243189994E-01],
	[1.1140000000E+04, 4.8294963496E+00, 5.8196583301E+00, 2.5700710266E-01, 2.3420106695E-01, 5.6258007670E-01],
	[1.1145000000E+04, 4.8323753567E+00, 5.8190328388E+00, 2.5736559267E-01, 2.3450448840E-01, 5.6272823400E-01],
	[1.1150000000E+04, 4.8352547876E+00, 5.8184076952E+00, 2.5772442089E-01, 2.3480813975E-01, 5.6287637185E-01],
	[1.1155000000E+04, 4.8381346421E+00, 5.8177828990E+00, 2.5808358750E-01, 2.3511202101E-01, 5.6302449025E-01],
	[1.1160000000E+04, 4.8410149202E+00, 5.8171584498E+00, 2.5844309264E-01, 2.3541613218E-01, 5.6317258919E-01],
	[1.1165000000E+04, 4.8438956217E+00, 5.8165343473E+00, 2.5880293650E-01, 2.3572047327E-01, 5.6332066869E-01],
	[1.1170000000E+04, 4.8467767464E+00, 5.8159105911E+00, 2.5916311923E-01, 2.3602504427E-01, 5.6346872874E-01],
	[1.1175000000E+04, 4.8496582943E+00, 5.8152871810E+00, 2.5952364101E-01, 2.3632984520E-01, 5.6361676935E-01],
	[1.1180000000E+04, 4.8525402653E+00, 5.8146641165E+00, 2.5988450199E-01, 2.3663487606E-01, 5.6376479052E-01],
	[1.1185000000E+04, 4.8554226591E+00, 5.8140413973E+00, 2.6024825579E-01, 2.3694225342E-01, 5.6391279225E-01],
	[1.1190000000E+04, 4.8583054756E+00, 5.8134190230E+00, 2.6061251836E-01, 2.3725000012E-01, 5.6406077455E-01],
	[1.1195000000E+04, 4.8611887148E+00, 5.8127969934E+00, 2.6097712707E-01, 2.3755798119E-01, 5.6420873740E-01],
	[1.1200000000E+04, 4.8640723766E+00, 5.8121753080E+00, 2.6134208211E-01, 2.3786619662E-01, 5.6435668083E-01],
	[1.1205000000E+04, 4.8669564607E+00, 5.8115539665E+00, 2.6170738363E-01, 2.3817464644E-01, 5.6450460483E-01],
	[1.1210000000E+04, 4.8698409670E+00, 5.8109329686E+00, 2.6207303183E-01, 2.3848333063E-01, 5.6465250940E-01],
	[1.1215000000E+04, 4.8727258955E+00, 5.8103123140E+00, 2.6243902686E-01, 2.3879224921E-01, 5.6480039455E-01],
	[1.1220000000E+04, 4.8756112460E+00, 5.8096920022E+00, 2.6280536891E-01, 2.3910140218E-01, 5.6494826028E-01],
	[1.1225000000E+04, 4.8784970184E+00, 5.8090720330E+00, 2.6317205814E-01, 2.3941078954E-01, 5.6509610658E-01],
	[1.1230000000E+04, 4.8813832125E+00, 5.8084524060E+00, 2.6353909473E-01, 2.3972041129E-01, 5.6524393347E-01],
	[1.1235000000E+04, 4.8842698283E+00, 5.8078331209E+00, 2.6390647886E-01, 2.4003026745E-01, 5.6539174095E-01],
	[1.1240000000E+04, 4.8871568655E+00, 5.8072141773E+00, 2.6427421069E-01, 2.4034035801E-01, 5.6553952901E-01],
	[1.1245000000E+04, 4.8900443242E+00, 5.8065955749E+00, 2.6464229040E-01, 2.4065068298E-01, 5.6568729767E-01],
	[1.1250000000E+04, 4.8929322040E+00, 5.8059773133E+00, 2.6501071816E-01, 2.4096124236E-01, 5.6583504692E-01],
	[1.1255000000E+04, 4.8958205050E+00, 5.8053593923E+00, 2.6537949415E-01, 2.4127203616E-01, 5.6598277677E-01],
	[1.1260000000E+04, 4.8987092270E+00, 5.8047418114E+00, 2.6574861853E-01, 2.4158306437E-01, 5.6613048722E-01],
	[1.1265000000E+04, 4.9015983699E+00, 5.8041245703E+00, 2.6611809149E-01, 2.4189432700E-01, 5.6627817827E-01],
	[1.1270000000E+04, 4.9044879335E+00, 5.8035076688E+00, 2.6648791320E-01, 2.4220582406E-01, 5.6642584992E-01],
	[1.1275000000E+04, 4.9073779177E+00, 5.8028911064E+00, 2.6685808382E-01, 2.4251755554E-01, 5.6657350218E-01],
	[1.1280000000E+04, 4.9102683224E+00, 5.8022748828E+00, 2.6722860353E-01, 2.4282952145E-01, 5.6672113506E-01],
	[1.1285000000E+04, 4.9131591475E+00, 5.8016589977E+00, 2.6759947251E-01, 2.4314172178E-01, 5.6686874855E-01],
	[1.1290000000E+04, 4.9160503928E+00, 5.8010434507E+00, 2.6797069093E-01, 2.4345415655E-01, 5.6701634265E-01],
	[1.1295000000E+04, 4.9189460786E+00, 5.8004385006E+00, 2.6834225896E-01, 2.4376685375E-01, 5.6716391738E-01],
	[1.1300000000E+04, 4.9218422097E+00, 5.7998339382E+00, 2.6871417677E-01, 2.4407978566E-01, 5.6731147272E-01],
	[1.1305000000E+04, 4.9247387636E+00, 5.7992297063E+00, 2.6908644454E-01, 2.4439295213E-01, 5.6745900870E-01],
	[1.1310000000E+04, 4.9276357402E+00, 5.7986258044E+00, 2.6945906245E-01, 2.4470635316E-01, 5.6760652530E-01],
	[1.1315000000E+04, 4.9305331394E+00, 5.7980222323E+00, 2.6983203066E-01, 2.4501998876E-01, 5.6775402253E-01],
	[1.1320000000E+04, 4.9334309610E+00, 5.7974189896E+00, 2.7020534934E-01, 2.4533385892E-01, 5.6790150040E-01],
	[1.1325000000E+04, 4.9363292050E+00, 5.7968160760E+00, 2.7057901868E-01, 2.4564796365E-01, 5.6804895890E-01],
	[1.1330000000E+04, 4.9392278712E+00, 5.7962134913E+00, 2.7095303885E-01, 2.4596230296E-01, 5.6819639805E-01],
	[1.1335000000E+04, 4.9421269595E+00, 5.7956112350E+00, 2.7132741001E-01, 2.4627687683E-01, 5.6834381784E-01],
	[1.1340000000E+04, 4.9450264697E+00, 5.7950093068E+00, 2.7170213234E-01, 2.4659168527E-01, 5.6849121828E-01],
	[1.1345000000E+04, 4.9479264018E+00, 5.7944077064E+00, 2.7207720602E-01, 2.4690672828E-01, 5.6863859937E-01],
	[1.1350000000E+04, 4.9508267555E+00, 5.7938064336E+00, 2.7245263122E-01, 2.4722200586E-01, 5.6878596112E-01],
	[1.1355000000E+04, 4.9537275309E+00, 5.7932054879E+00, 2.7282840811E-01, 2.4753751801E-01, 5.6893330352E-01],
	[1.1360000000E+04, 4.9566287277E+00, 5.7926048690E+00, 2.7320453687E-01, 2.4785326474E-01, 5.6908062658E-01],
	[1.1365000000E+04, 4.9595303459E+00, 5.7920045767E+00, 2.7358101766E-01, 2.4816924604E-01, 5.6922793030E-01],
	[1.1370000000E+04, 4.9624323853E+00, 5.7914046106E+00, 2.7395785067E-01, 2.4848546191E-01, 5.6937521470E-01],
	[1.1375000000E+04, 4.9653348458E+00, 5.7908049704E+00, 2.7433503606E-01, 2.4880191235E-01, 5.6952247976E-01],
	[1.1380000000E+04, 4.9682377272E+00, 5.7902056557E+00, 2.7471257401E-01, 2.4911859737E-01, 5.6966972550E-01],
	[1.1385000000E+04, 4.9711410295E+00, 5.7896066663E+00, 2.7509046469E-01, 2.4943551695E-01, 5.6981695191E-01],
	[1.1390000000E+04, 4.9740447525E+00, 5.7890080018E+00, 2.7546870828E-01, 2.4975267110E-01, 5.6996415901E-01],
	[1.1395000000E+04, 4.9769488960E+00, 5.7884096620E+00, 2.7584730495E-01, 2.5007005983E-01, 5.7011134679E-01],
	[1.1400000000E+04, 4.9798534601E+00, 5.7878116464E+00, 2.7622625487E-01, 2.5038768312E-01, 5.7025851526E-01],
	[1.1405000000E+04, 4.9827584445E+00, 5.7872139548E+00, 2.7660555822E-01, 2.5070554098E-01, 5.7040566441E-01],
	[1.1410000000E+04, 4.9856638491E+00, 5.7866165868E+00, 2.7698521517E-01, 2.5102363340E-01, 5.7055279427E-01],
	[1.1415000000E+04, 4.9885696738E+00, 5.7860195422E+00, 2.7736522589E-01, 2.5134196039E-01, 5.7069990482E-01],
	[1.1420000000E+04, 4.9914759185E+00, 5.7854228206E+00, 2.7774559056E-01, 2.5166052194E-01, 5.7084699608E-01],
	[1.1425000000E+04, 4.9943825831E+00, 5.7848264217E+00, 2.7812630935E-01, 2.5197931805E-01, 5.7099406804E-01],
	[1.1430000000E+04, 4.9972896674E+00, 5.7842303452E+00, 2.7850738243E-01, 2.5229834872E-01, 5.7114112071E-01],
	[1.1435000000E+04, 5.0001971712E+00, 5.7836345908E+00, 2.7888880998E-01, 2.5261761394E-01, 5.7128815409E-01],
	[1.1440000000E+04, 5.0031050946E+00, 5.7830391581E+00, 2.7927059217E-01, 2.5293711372E-01, 5.7143516819E-01],
	[1.1445000000E+04, 5.0060134373E+00, 5.7824440469E+00, 2.7965272918E-01, 2.5325684805E-01, 5.7158216301E-01],
	[1.1450000000E+04, 5.0089221993E+00, 5.7818492568E+00, 2.8003522117E-01, 2.5357681693E-01, 5.7172913856E-01],
	[1.1455000000E+04, 5.0118313804E+00, 5.7812547875E+00, 2.8041806833E-01, 2.5389702036E-01, 5.7187609483E-01],
	[1.1460000000E+04, 5.0147409805E+00, 5.7806606387E+00, 2.8080127082E-01, 2.5421745833E-01, 5.7202303184E-01],
	[1.1465000000E+04, 5.0176509994E+00, 5.7800668102E+00, 2.8118482882E-01, 2.5453813084E-01, 5.7216994958E-01],
	[1.1470000000E+04, 5.0205614371E+00, 5.7794733015E+00, 2.8156874250E-01, 2.5485903788E-01, 5.7231684806E-01],
	[1.1475000000E+04, 5.0234749832E+00, 5.7788865133E+00, 2.8195301204E-01, 2.5518019889E-01, 5.7246372729E-01],
	[1.1480000000E+04, 5.0263904394E+00, 5.7783035827E+00, 2.8233763761E-01, 2.5550160528E-01, 5.7261058726E-01],
	[1.1485000000E+04, 5.0293063169E+00, 5.7777209648E+00, 2.8272261938E-01, 2.5582324633E-01, 5.7275742799E-01],
	[1.1490000000E+04, 5.0322226158E+00, 5.7771386591E+00, 2.8310795752E-01, 2.5614512203E-01, 5.7290424947E-01],
	[1.1495000000E+04, 5.0351393358E+00, 5.7765566654E+00, 2.8349365222E-01, 2.5646723238E-01, 5.7305105171E-01],
	[1.1500000000E+04, 5.0380564768E+00, 5.7759749835E+00, 2.8387970365E-01, 2.5678957738E-01, 5.7319783471E-01],
	[1.1505000000E+04, 5.0409740388E+00, 5.7753936129E+00, 2.8426611197E-01, 2.5711215703E-01, 5.7334459848E-01],
	[1.1510000000E+04, 5.0438920216E+00, 5.7748125534E+00, 2.8465287736E-01, 2.5743497131E-01, 5.7349134303E-01],
	[1.1515000000E+04, 5.0468104250E+00, 5.7742318046E+00, 2.8503999999E-01, 2.5775802022E-01, 5.7363806834E-01],
	[1.1520000000E+04, 5.0497292490E+00, 5.7736513664E+00, 2.8542748005E-01, 2.5808130376E-01, 5.7378477442E-01],
	[1.1525000000E+04, 5.0526484934E+00, 5.7730712383E+00, 2.8581531770E-01, 2.5840482193E-01, 5.7393146123E-01],
	[1.1530000000E+04, 5.0555681581E+00, 5.7724914201E+00, 2.8620351311E-01, 2.5872857472E-01, 5.7407812877E-01],
	[1.1535000000E+04, 5.0584882430E+00, 5.7719119115E+00, 2.8659206646E-01, 2.5905256212E-01, 5.7422477703E-01],
	[1.1540000000E+04, 5.0614087480E+00, 5.7713327122E+00, 2.8698097793E-01, 2.5937678414E-01, 5.7437140600E-01],
	[1.1545000000E+04, 5.0643296729E+00, 5.7707538219E+00, 2.8737024768E-01, 2.5970124076E-01, 5.7451801569E-01],
	[1.1550000000E+04, 5.0672510176E+00, 5.7701752402E+00, 2.8775987590E-01, 2.6002593198E-01, 5.7466460607E-01],
	[1.1555000000E+04, 5.0701727821E+00, 5.7695969670E+00, 2.8814986275E-01, 2.6035085779E-01, 5.7481117714E-01],
	[1.1560000000E+04, 5.0730949661E+00, 5.7690190018E+00, 2.8854020840E-01, 2.6067601819E-01, 5.7495772890E-01],
	[1.1565000000E+04, 5.0760175695E+00, 5.7684413444E+00, 2.8893091304E-01, 2.6100141317E-01, 5.7510426134E-01],
	[1.1570000000E+04, 5.0789405923E+00, 5.7678639945E+00, 2.8932197684E-01, 2.6132704273E-01, 5.7525077444E-01],
	[1.1575000000E+04, 5.0818640343E+00, 5.7672869518E+00, 2.8971339996E-01, 2.6165290687E-01, 5.7539726821E-01],
	[1.1580000000E+04, 5.0847878954E+00, 5.7667102160E+00, 2.9010518259E-01, 2.6197900556E-01, 5.7554374263E-01],
	[1.1585000000E+04, 5.0877121755E+00, 5.7661337868E+00, 2.9049732490E-01, 2.6230533881E-01, 5.7569019771E-01],
	[1.1590000000E+04, 5.0906368744E+00, 5.7655576639E+00, 2.9088982705E-01, 2.6263190662E-01, 5.7583663342E-01],
	[1.1595000000E+04, 5.0935619920E+00, 5.7649818470E+00, 2.9128268924E-01, 2.6295870897E-01, 5.7598304977E-01],
	[1.1600000000E+04, 5.0964875283E+00, 5.7644063359E+00, 2.9167591161E-01, 2.6328574586E-01, 5.7612944674E-01],
	[1.1605000000E+04, 5.0994134830E+00, 5.7638311302E+00, 2.9206949437E-01, 2.6361301727E-01, 5.7627582434E-01],
	[1.1610000000E+04, 5.1023398561E+00, 5.7632562296E+00, 2.9246343766E-01, 2.6394052321E-01, 5.7642218254E-01],
	[1.1615000000E+04, 5.1052666475E+00, 5.7626816338E+00, 2.9285774168E-01, 2.6426826367E-01, 5.7656852135E-01],
	[1.1620000000E+04, 5.1081938570E+00, 5.7621073426E+00, 2.9325240659E-01, 2.6459623863E-01, 5.7671484076E-01],
	[1.1625000000E+04, 5.1111214845E+00, 5.7615333557E+00, 2.9364743257E-01, 2.6492444810E-01, 5.7686114077E-01],
	[1.1630000000E+04, 5.1140495298E+00, 5.7609596727E+00, 2.9404281979E-01, 2.6525289206E-01, 5.7700742135E-01],
	[1.1635000000E+04, 5.1169779930E+00, 5.7603862934E+00, 2.9443856843E-01, 2.6558157050E-01, 5.7715368252E-01],
	[1.1640000000E+04, 5.1199068738E+00, 5.7598132175E+00, 2.9483467865E-01, 2.6591048342E-01, 5.7729992425E-01],
	[1.1645000000E+04, 5.1228361721E+00, 5.7592404446E+00, 2.9523115064E-01, 2.6623963081E-01, 5.7744614655E-01],
	[1.1650000000E+04, 5.1257658878E+00, 5.7586679746E+00, 2.9562798456E-01, 2.6656901266E-01, 5.7759234941E-01],
	[1.1655000000E+04, 5.1286960208E+00, 5.7580958071E+00, 2.9602518060E-01, 2.6689862896E-01, 5.7773853282E-01],
	[1.1660000000E+04, 5.1316296260E+00, 5.7575307231E+00, 2.9642273891E-01, 2.6722850260E-01, 5.7788469677E-01],
	[1.1665000000E+04, 5.1345649130E+00, 5.7569687376E+00, 2.9682065969E-01, 2.6755862024E-01, 5.7803084126E-01],
	[1.1670000000E+04, 5.1375006201E+00, 5.7564070477E+00, 2.9721894310E-01, 2.6788897245E-01, 5.7817696628E-01],
	[1.1675000000E+04, 5.1404367470E+00, 5.7558456531E+00, 2.9761758932E-01, 2.6821955921E-01, 5.7832307182E-01],
	[1.1680000000E+04, 5.1433732936E+00, 5.7552845537E+00, 2.9801659851E-01, 2.6855038051E-01, 5.7846915788E-01],
	[1.1685000000E+04, 5.1463102600E+00, 5.7547237491E+00, 2.9841597086E-01, 2.6888143635E-01, 5.7861522446E-01],
	[1.1690000000E+04, 5.1492476458E+00, 5.7541632390E+00, 2.9881570654E-01, 2.6921272671E-01, 5.7876127153E-01],
	[1.1695000000E+04, 5.1521854511E+00, 5.7536030231E+00, 2.9921580572E-01, 2.6954425159E-01, 5.7890729910E-01],
	[1.1700000000E+04, 5.1551236756E+00, 5.7530431012E+00, 2.9961626858E-01, 2.6987601097E-01, 5.7905330717E-01],
	[1.1705000000E+04, 5.1580623194E+00, 5.7524834730E+00, 3.0001709529E-01, 2.7020800485E-01, 5.7919929572E-01],
	[1.1710000000E+04, 5.1610013822E+00, 5.7519241382E+00, 3.0041828602E-01, 2.7054023322E-01, 5.7934526474E-01],
	[1.1715000000E+04, 5.1639408639E+00, 5.7513650965E+00, 3.0081984094E-01, 2.7087269606E-01, 5.7949121424E-01],
	[1.1720000000E+04, 5.1668807644E+00, 5.7508063477E+00, 3.0122176024E-01, 2.7120539337E-01, 5.7963714421E-01],
	[1.1725000000E+04, 5.1698210837E+00, 5.7502478915E+00, 3.0162404409E-01, 2.7153832513E-01, 5.7978305463E-01],
	[1.1730000000E+04, 5.1727618215E+00, 5.7496897275E+00, 3.0202669266E-01, 2.7187149134E-01, 5.7992894550E-01],
	[1.1735000000E+04, 5.1757029778E+00, 5.7491318556E+00, 3.0242970611E-01, 2.7220489199E-01, 5.8007481683E-01],
	[1.1740000000E+04, 5.1786445524E+00, 5.7485742754E+00, 3.0283308464E-01, 2.7253852705E-01, 5.8022066859E-01],
	[1.1745000000E+04, 5.1815865453E+00, 5.7480169866E+00, 3.0323682841E-01, 2.7287239653E-01, 5.8036650079E-01],
	[1.1750000000E+04, 5.1845289562E+00, 5.7474599891E+00, 3.0364093759E-01, 2.7320650041E-01, 5.8051231341E-01],
	[1.1755000000E+04, 5.1874717851E+00, 5.7469032824E+00, 3.0404541237E-01, 2.7354083867E-01, 5.8065810646E-01],
	[1.1760000000E+04, 5.1904150319E+00, 5.7463468664E+00, 3.0445025291E-01, 2.7387541132E-01, 5.8080387992E-01],
	[1.1765000000E+04, 5.1933586965E+00, 5.7457907408E+00, 3.0485545938E-01, 2.7421021833E-01, 5.8094963379E-01],
	[1.1770000000E+04, 5.1963027787E+00, 5.7452349052E+00, 3.0526103197E-01, 2.7454525970E-01, 5.8109536807E-01],
	[1.1775000000E+04, 5.1992472783E+00, 5.7446793594E+00, 3.0566697085E-01, 2.7488053541E-01, 5.8124108274E-01],
	[1.1780000000E+04, 5.2021921954E+00, 5.7441241032E+00, 3.0607327618E-01, 2.7521604545E-01, 5.8138677781E-01],
	[1.1785000000E+04, 5.2051375298E+00, 5.7435691363E+00, 3.0647994815E-01, 2.7555178980E-01, 5.8153245326E-01],
	[1.1790000000E+04, 5.2080832813E+00, 5.7430144583E+00, 3.0688698693E-01, 2.7588776847E-01, 5.8167810908E-01],
	[1.1795000000E+04, 5.2110294499E+00, 5.7424600690E+00, 3.0729439269E-01, 2.7622398142E-01, 5.8182374529E-01],
	[1.1800000000E+04, 5.2139760353E+00, 5.7419059682E+00, 3.0770216561E-01, 2.7656042866E-01, 5.8196936186E-01],
	[1.1805000000E+04, 5.2169230376E+00, 5.7413521556E+00, 3.0811030585E-01, 2.7689711016E-01, 5.8211495879E-01],
	[1.1810000000E+04, 5.2198704566E+00, 5.7407986309E+00, 3.0851881360E-01, 2.7723402592E-01, 5.8226053608E-01],
	[1.1815000000E+04, 5.2228182921E+00, 5.7402453937E+00, 3.0892768904E-01, 2.7757117591E-01, 5.8240609372E-01],
	[1.1820000000E+04, 5.2257665441E+00, 5.7396924440E+00, 3.0933693232E-01, 2.7790856014E-01, 5.8255163170E-01],
	[1.1825000000E+04, 5.2287152124E+00, 5.7391397813E+00, 3.0974654363E-01, 2.7824617858E-01, 5.8269715003E-01],
	[1.1830000000E+04, 5.2316642970E+00, 5.7385874055E+00, 3.1015652314E-01, 2.7858403122E-01, 5.8284264868E-01],
	[1.1835000000E+04, 5.2346137976E+00, 5.7380353162E+00, 3.1056687103E-01, 2.7892211805E-01, 5.8298812766E-01],
	[1.1840000000E+04, 5.2375637142E+00, 5.7374835131E+00, 3.1097758747E-01, 2.7926043904E-01, 5.8313358697E-01],
	[1.1845000000E+04, 5.2405148355E+00, 5.7369336307E+00, 3.1138867263E-01, 2.7959900033E-01, 5.8327902659E-01],
	[1.1850000000E+04, 5.2434700416E+00, 5.7363916300E+00, 3.1180012669E-01, 2.7993782433E-01, 5.8342444652E-01],
	[1.1855000000E+04, 5.2464256664E+00, 5.7358499091E+00, 3.1221194982E-01, 2.8027688261E-01, 5.8356984676E-01],
	[1.1860000000E+04, 5.2493817099E+00, 5.7353084677E+00, 3.1262414220E-01, 2.8061617514E-01, 5.8371522730E-01],
	[1.1865000000E+04, 5.2523381719E+00, 5.7347673057E+00, 3.1303670400E-01, 2.8095570192E-01, 5.8386058813E-01],
	[1.1870000000E+04, 5.2552950524E+00, 5.7342264227E+00, 3.1344963539E-01, 2.8129546293E-01, 5.8400592925E-01],
	[1.1875000000E+04, 5.2582523511E+00, 5.7336858185E+00, 3.1386293656E-01, 2.8163545815E-01, 5.8415125065E-01],
	[1.1880000000E+04, 5.2612100680E+00, 5.7331454928E+00, 3.1427660766E-01, 2.8197568757E-01, 5.8429655233E-01],
	[1.1885000000E+04, 5.2641682030E+00, 5.7326054453E+00, 3.1469064888E-01, 2.8231615118E-01, 5.8444183428E-01],
	[1.1890000000E+04, 5.2671267560E+00, 5.7320656758E+00, 3.1510506040E-01, 2.8265684896E-01, 5.8458709650E-01],
	[1.1895000000E+04, 5.2700857268E+00, 5.7315261840E+00, 3.1551984238E-01, 2.8299778089E-01, 5.8473233898E-01],
	[1.1900000000E+04, 5.2730451153E+00, 5.7309869697E+00, 3.1593499500E-01, 2.8333894696E-01, 5.8487756172E-01],
	[1.1905000000E+04, 5.2760049214E+00, 5.7304480327E+00, 3.1635051844E-01, 2.8368034715E-01, 5.8502276471E-01],
	[1.1910000000E+04, 5.2789651450E+00, 5.7299093725E+00, 3.1676641287E-01, 2.8402198146E-01, 5.8516794794E-01],
	[1.1915000000E+04, 5.2819257859E+00, 5.7293709891E+00, 3.1718267845E-01, 2.8436384985E-01, 5.8531311142E-01],
	[1.1920000000E+04, 5.2848868442E+00, 5.7288328821E+00, 3.1759931538E-01, 2.8470595232E-01, 5.8545825513E-01],
	[1.1925000000E+04, 5.2878483195E+00, 5.7282950513E+00, 3.1801632382E-01, 2.8504828884E-01, 5.8560337907E-01],
	[1.1930000000E+04, 5.2908102119E+00, 5.7277574964E+00, 3.1843370394E-01, 2.8539085941E-01, 5.8574848324E-01],
	[1.1935000000E+04, 5.2937725212E+00, 5.7272202171E+00, 3.1885145592E-01, 2.8573366401E-01, 5.8589356762E-01],
	[1.1940000000E+04, 5.2967352472E+00, 5.7266832133E+00, 3.1926957994E-01, 2.8607670261E-01, 5.8603863222E-01],
	[1.1945000000E+04, 5.2996983900E+00, 5.7261464846E+00, 3.1968807617E-01, 2.8641997521E-01, 5.8618367704E-01],
	[1.1950000000E+04, 5.3026619493E+00, 5.7256100308E+00, 3.2010694478E-01, 2.8676348178E-01, 5.8632870205E-01],
	[1.1955000000E+04, 5.3056259250E+00, 5.7250738516E+00, 3.2052618595E-01, 2.8710722231E-01, 5.8647370727E-01],
	[1.1960000000E+04, 5.3085903171E+00, 5.7245379468E+00, 3.2094579985E-01, 2.8745119678E-01, 5.8661869268E-01],
	[1.1965000000E+04, 5.3115551253E+00, 5.7240023162E+00, 3.2136578666E-01, 2.8779540517E-01, 5.8676365828E-01],
	[1.1970000000E+04, 5.3145203497E+00, 5.7234669594E+00, 3.2178614654E-01, 2.8813984747E-01, 5.8690860407E-01],
	[1.1975000000E+04, 5.3174859900E+00, 5.7229318762E+00, 3.2220687969E-01, 2.8848452365E-01, 5.8705353004E-01],
	[1.1980000000E+04, 5.3204520463E+00, 5.7223970664E+00, 3.2262798626E-01, 2.8882943371E-01, 5.8719843618E-01],
	[1.1985000000E+04, 5.3234185182E+00, 5.7218625298E+00, 3.2304946644E-01, 2.8917457762E-01, 5.8734332250E-01],
	[1.1990000000E+04, 5.3263854058E+00, 5.7213282659E+00, 3.2347132039E-01, 2.8951995536E-01, 5.8748818898E-01],
	[1.1995000000E+04, 5.3293527089E+00, 5.7207942747E+00, 3.2389354830E-01, 2.8986556691E-01, 5.8763303562E-01],
	[1.2000000000E+04, 5.3323204274E+00, 5.7202605558E+00, 3.2431615033E-01, 2.9021141226E-01, 5.8777786242E-01],
	[1.2005000000E+04, 5.3352885612E+00, 5.7197271090E+00, 3.2473912667E-01, 2.9055749139E-01, 5.8792266936E-01],
	[1.2010000000E+04, 5.3382571102E+00, 5.7191939341E+00, 3.2516247748E-01, 2.9090380428E-01, 5.8806745646E-01],
	[1.2015000000E+04, 5.3412260742E+00, 5.7186610307E+00, 3.2558620294E-01, 2.9125035090E-01, 5.8821222370E-01],
	[1.2020000000E+04, 5.3441954532E+00, 5.7181283987E+00, 3.2601030323E-01, 2.9159713125E-01, 5.8835697108E-01],
	[1.2025000000E+04, 5.3471652470E+00, 5.7175960378E+00, 3.2643477851E-01, 2.9194414529E-01, 5.8850169859E-01],
	[1.2030000000E+04, 5.3501354555E+00, 5.7170639478E+00, 3.2685962897E-01, 2.9229139302E-01, 5.8864640623E-01],
	[1.2035000000E+04, 5.3531062726E+00, 5.7165325036E+00, 3.2728485478E-01, 2.9263887597E-01, 5.8879109399E-01],
	[1.2040000000E+04, 5.3560819088E+00, 5.7160098459E+00, 3.2771045611E-01, 2.9298662813E-01, 5.8893576187E-01],
	[1.2045000000E+04, 5.3590579625E+00, 5.7154874529E+00, 3.2813643314E-01, 2.9333461405E-01, 5.8908040987E-01],
	[1.2050000000E+04, 5.3620344337E+00, 5.7149653245E+00, 3.2856278604E-01, 2.9368283373E-01, 5.8922503798E-01],
	[1.2055000000E+04, 5.3650113223E+00, 5.7144434603E+00, 3.2898951499E-01, 2.9403128714E-01, 5.8936964619E-01],
	[1.2060000000E+04, 5.3679886281E+00, 5.7139218602E+00, 3.2941662015E-01, 2.9437997426E-01, 5.8951423451E-01],
	[1.2065000000E+04, 5.3709663509E+00, 5.7134005239E+00, 3.2984410171E-01, 2.9472889508E-01, 5.8965880292E-01],
	[1.2070000000E+04, 5.3739444908E+00, 5.7128794511E+00, 3.3027195985E-01, 2.9507804956E-01, 5.8980335143E-01],
	[1.2075000000E+04, 5.3769230476E+00, 5.7123586416E+00, 3.3070019472E-01, 2.9542743770E-01, 5.8994788003E-01],
	[1.2080000000E+04, 5.3799020211E+00, 5.7118380952E+00, 3.3112880651E-01, 2.9577705946E-01, 5.9009238869E-01],
	[1.2085000000E+04, 5.3828814113E+00, 5.7113178116E+00, 3.3155779540E-01, 2.9612691484E-01, 5.9023687736E-01],
	[1.2090000000E+04, 5.3858612180E+00, 5.7107977906E+00, 3.3198716156E-01, 2.9647700380E-01, 5.9038134602E-01],
	[1.2095000000E+04, 5.3888414411E+00, 5.7102780319E+00, 3.3241690516E-01, 2.9682732633E-01, 5.9052579466E-01],
	[1.2100000000E+04, 5.3918220805E+00, 5.7097585353E+00, 3.3284702637E-01, 2.9717788240E-01, 5.9067022328E-01],
	[1.2105000000E+04, 5.3948031362E+00, 5.7092393005E+00, 3.3327752538E-01, 2.9752867200E-01, 5.9081463186E-01],
	[1.2110000000E+04, 5.3977846079E+00, 5.7087203274E+00, 3.3370840235E-01, 2.9787969510E-01, 5.9095902039E-01],
	[1.2115000000E+04, 5.4007664956E+00, 5.7082016157E+00, 3.3413965746E-01, 2.9823095168E-01, 5.9110338886E-01],
	[1.2120000000E+04, 5.4037487991E+00, 5.7076831651E+00, 3.3457129089E-01, 2.9858244172E-01, 5.9124773725E-01],
	[1.2125000000E+04, 5.4067315184E+00, 5.7071649754E+00, 3.3500330281E-01, 2.9893416519E-01, 5.9139206556E-01],
	[1.2130000000E+04, 5.4097146533E+00, 5.7066470463E+00, 3.3543569339E-01, 2.9928612208E-01, 5.9153637378E-01],
	[1.2135000000E+04, 5.4126982037E+00, 5.7061293777E+00, 3.3586846281E-01, 2.9963831236E-01, 5.9168066188E-01],
	[1.2140000000E+04, 5.4156821695E+00, 5.7056119692E+00, 3.3630161125E-01, 2.9999073601E-01, 5.9182492988E-01],
	[1.2145000000E+04, 5.4186665506E+00, 5.7050948207E+00, 3.3673513887E-01, 3.0034339301E-01, 5.9196917774E-01],
	[1.2150000000E+04, 5.4216513469E+00, 5.7045779319E+00, 3.3716904586E-01, 3.0069628333E-01, 5.9211340546E-01],
	[1.2155000000E+04, 5.4246365582E+00, 5.7040613026E+00, 3.3760333239E-01, 3.0104940695E-01, 5.9225761304E-01],
	[1.2160000000E+04, 5.4276221845E+00, 5.7035449325E+00, 3.3803799862E-01, 3.0140276384E-01, 5.9240180045E-01],
	[1.2165000000E+04, 5.4306082256E+00, 5.7030288214E+00, 3.3847304475E-01, 3.0175635399E-01, 5.9254596769E-01],
	[1.2170000000E+04, 5.4335946814E+00, 5.7025129691E+00, 3.3890847093E-01, 3.0211017737E-01, 5.9269011475E-01],
	[1.2175000000E+04, 5.4365815518E+00, 5.7019973752E+00, 3.3934427735E-01, 3.0246423396E-01, 5.9283424161E-01],
	[1.2180000000E+04, 5.4395688368E+00, 5.7014820397E+00, 3.3978046419E-01, 3.0281852373E-01, 5.9297834827E-01],
	[1.2185000000E+04, 5.4425565361E+00, 5.7009669622E+00, 3.4021703161E-01, 3.0317304666E-01, 5.9312243472E-01],
	[1.2190000000E+04, 5.4455446497E+00, 5.7004521426E+00, 3.4065397979E-01, 3.0352780273E-01, 5.9326650094E-01],
	[1.2195000000E+04, 5.4485331774E+00, 5.6999375805E+00, 3.4109130890E-01, 3.0388279190E-01, 5.9341054692E-01],
	[1.2200000000E+04, 5.4515221192E+00, 5.6994232758E+00, 3.4152901912E-01, 3.0423801416E-01, 5.9355457266E-01],
	[1.2205000000E+04, 5.4545114749E+00, 5.6989092282E+00, 3.4196711063E-01, 3.0459346948E-01, 5.9369857813E-01],
	[1.2210000000E+04, 5.4575012445E+00, 5.6983954374E+00, 3.4240558360E-01, 3.0494915784E-01, 5.9384256334E-01],
	[1.2215000000E+04, 5.4604914277E+00, 5.6978819034E+00, 3.4284443820E-01, 3.0530507922E-01, 5.9398652827E-01],
	[1.2220000000E+04, 5.4634820246E+00, 5.6973686257E+00, 3.4328367461E-01, 3.0566123357E-01, 5.9413047291E-01],
	[1.2225000000E+04, 5.4664730349E+00, 5.6968556042E+00, 3.4372329301E-01, 3.0601762089E-01, 5.9427439725E-01],
	[1.2230000000E+04, 5.4694658496E+00, 5.6963453517E+00, 3.4416329356E-01, 3.0637425278E-01, 5.9441830128E-01],
	[1.2235000000E+04, 5.4724624287E+00, 5.6958414023E+00, 3.4460367645E-01, 3.0673114570E-01, 5.9456218499E-01],
	[1.2240000000E+04, 5.4754594242E+00, 5.6953377034E+00, 3.4504444184E-01, 3.0708827165E-01, 5.9470604836E-01],
	[1.2245000000E+04, 5.4784568360E+00, 5.6948342547E+00, 3.4548558992E-01, 3.0744563063E-01, 5.9484989140E-01],
	[1.2250000000E+04, 5.4814546640E+00, 5.6943310560E+00, 3.4592712085E-01, 3.0780322259E-01, 5.9499371408E-01],
	[1.2255000000E+04, 5.4844529081E+00, 5.6938281071E+00, 3.4636903482E-01, 3.0816104752E-01, 5.9513751640E-01],
	[1.2260000000E+04, 5.4874515681E+00, 5.6933254078E+00, 3.4681133199E-01, 3.0851910539E-01, 5.9528129835E-01],
	[1.2265000000E+04, 5.4904506439E+00, 5.6928229577E+00, 3.4725401254E-01, 3.0887739617E-01, 5.9542505991E-01],
	[1.2270000000E+04, 5.4934501355E+00, 5.6923207568E+00, 3.4769707665E-01, 3.0923591984E-01, 5.9556880108E-01],
	[1.2275000000E+04, 5.4964500427E+00, 5.6918188048E+00, 3.4814052450E-01, 3.0959467637E-01, 5.9571252185E-01],
	[1.2280000000E+04, 5.4994503653E+00, 5.6913171014E+00, 3.4858435625E-01, 3.0995366573E-01, 5.9585622220E-01],
	[1.2285000000E+04, 5.5024511034E+00, 5.6908156465E+00, 3.4902857208E-01, 3.1031288790E-01, 5.9599990213E-01],
	[1.2290000000E+04, 5.5054522568E+00, 5.6903144398E+00, 3.4947317216E-01, 3.1067234286E-01, 5.9614356162E-01],
	[1.2295000000E+04, 5.5084538253E+00, 5.6898134810E+00, 3.4991815668E-01, 3.1103203056E-01, 5.9628720067E-01],
	[1.2300000000E+04, 5.5114558089E+00, 5.6893127700E+00, 3.5036352580E-01, 3.1139195099E-01, 5.9643081927E-01],
	[1.2305000000E+04, 5.5144582074E+00, 5.6888123065E+00, 3.5080927970E-01, 3.1175210413E-01, 5.9657441740E-01],
	[1.2310000000E+04, 5.5174610207E+00, 5.6883120904E+00, 3.5125541856E-01, 3.1211248993E-01, 5.9671799506E-01],
	[1.2315000000E+04, 5.5204642488E+00, 5.6878121213E+00, 3.5170194255E-01, 3.1247310838E-01, 5.9686155223E-01],
	[1.2320000000E+04, 5.5234678915E+00, 5.6873123991E+00, 3.5214885185E-01, 3.1283395944E-01, 5.9700508891E-01],
	[1.2325000000E+04, 5.5264719487E+00, 5.6868129236E+00, 3.5259614662E-01, 3.1319504309E-01, 5.9714860508E-01],
	[1.2330000000E+04, 5.5294764203E+00, 5.6863136945E+00, 3.5304382705E-01, 3.1355635931E-01, 5.9729210075E-01],
	[1.2335000000E+04, 5.5324813062E+00, 5.6858147116E+00, 3.5349189331E-01, 3.1391790805E-01, 5.9743557588E-01],
	[1.2340000000E+04, 5.5354866062E+00, 5.6853159746E+00, 3.5394034557E-01, 3.1427968930E-01, 5.9757903049E-01],
	[1.2345000000E+04, 5.5384923203E+00, 5.6848174835E+00, 3.5438918402E-01, 3.1464170303E-01, 5.9772246455E-01],
	[1.2350000000E+04, 5.5414984483E+00, 5.6843192378E+00, 3.5483840882E-01, 3.1500394920E-01, 5.9786587805E-01],
	[1.2355000000E+04, 5.5445049902E+00, 5.6838212375E+00, 3.5528802014E-01, 3.1536642779E-01, 5.9800927100E-01],
	[1.2360000000E+04, 5.5475119458E+00, 5.6833234823E+00, 3.5573801818E-01, 3.1572913877E-01, 5.9815264337E-01],
	[1.2365000000E+04, 5.5505193150E+00, 5.6828259720E+00, 3.5618840309E-01, 3.1609208210E-01, 5.9829599516E-01],
	[1.2370000000E+04, 5.5535270977E+00, 5.6823287063E+00, 3.5663917506E-01, 3.1645525777E-01, 5.9843932635E-01],
	[1.2375000000E+04, 5.5565352938E+00, 5.6818316851E+00, 3.5709033425E-01, 3.1681866574E-01, 5.9858263695E-01],
	[1.2380000000E+04, 5.5595439032E+00, 5.6813349081E+00, 3.5754188086E-01, 3.1718230598E-01, 5.9872592693E-01],
	[1.2385000000E+04, 5.5625529258E+00, 5.6808383751E+00, 3.5799381504E-01, 3.1754617847E-01, 5.9886919630E-01],
	[1.2390000000E+04, 5.5655623614E+00, 5.6803420859E+00, 3.5844613697E-01, 3.1791028316E-01, 5.9901244503E-01],
	[1.2395000000E+04, 5.5685722100E+00, 5.6798460402E+00, 3.5889884684E-01, 3.1827462004E-01, 5.9915567312E-01],
	[1.2400000000E+04, 5.5715824714E+00, 5.6793502379E+00, 3.5935194481E-01, 3.1863918906E-01, 5.9929888057E-01],
	[1.2405000000E+04, 5.5745931456E+00, 5.6788546788E+00, 3.5980543106E-01, 3.1900399021E-01, 5.9944206735E-01],
	[1.2410000000E+04, 5.5776042324E+00, 5.6783593625E+00, 3.6025930576E-01, 3.1936902345E-01, 5.9958523347E-01],
	[1.2415000000E+04, 5.5806157317E+00, 5.6778642890E+00, 3.6071356909E-01, 3.1973428875E-01, 5.9972837891E-01],
	[1.2420000000E+04, 5.5836276434E+00, 5.6773694579E+00, 3.6116822123E-01, 3.2009978608E-01, 5.9987150366E-01],
	[1.2425000000E+04, 5.5866399674E+00, 5.6768748691E+00, 3.6162326235E-01, 3.2046551541E-01, 6.0001460772E-01],
	[1.2430000000E+04, 5.5896572114E+00, 5.6763881180E+00, 3.6207869262E-01, 3.2083151581E-01, 6.0015769107E-01],
	[1.2435000000E+04, 5.5926752578E+00, 5.6759022565E+00, 3.6253451222E-01, 3.2119775168E-01, 6.0030075371E-01],
	[1.2440000000E+04, 5.5956937195E+00, 5.6754166319E+00, 3.6299072133E-01, 3.2156421961E-01, 6.0044379562E-01],
	[1.2445000000E+04, 5.5987125963E+00, 5.6749312439E+00, 3.6344732012E-01, 3.2193091958E-01, 6.0058681680E-01],
	[1.2450000000E+04, 5.6017318882E+00, 5.6744460925E+00, 3.6390430876E-01, 3.2229785155E-01, 6.0072981724E-01],
	[1.2455000000E+04, 5.6047515950E+00, 5.6739611772E+00, 3.6436168743E-01, 3.2266501550E-01, 6.0087279692E-01],
	[1.2460000000E+04, 5.6077717167E+00, 5.6734764981E+00, 3.6481945631E-01, 3.2303241139E-01, 6.0101575585E-01],
	[1.2465000000E+04, 5.6107922532E+00, 5.6729920547E+00, 3.6527761557E-01, 3.2340003919E-01, 6.0115869400E-01],
	[1.2470000000E+04, 5.6138132042E+00, 5.6725078470E+00, 3.6573616538E-01, 3.2376789888E-01, 6.0130161138E-01],
	[1.2475000000E+04, 5.6168345697E+00, 5.6720238747E+00, 3.6619510592E-01, 3.2413599041E-01, 6.0144450797E-01],
	[1.2480000000E+04, 5.6198563497E+00, 5.6715401376E+00, 3.6665443737E-01, 3.2450431375E-01, 6.0158738376E-01],
	[1.2485000000E+04, 5.6228785439E+00, 5.6710566355E+00, 3.6711415990E-01, 3.2487286888E-01, 6.0173023875E-01],
	[1.2490000000E+04, 5.6259011524E+00, 5.6705733681E+00, 3.6757427369E-01, 3.2524165575E-01, 6.0187307292E-01],
	[1.2495000000E+04, 5.6289241749E+00, 5.6700903354E+00, 3.6803477891E-01, 3.2561067435E-01, 6.0201588627E-01],
	[1.2500000000E+04, 5.6319476113E+00, 5.6696075370E+00, 3.6849567573E-01, 3.2597992462E-01, 6.0215867879E-01],
	[1.2505000000E+04, 5.6349714617E+00, 5.6691249728E+00, 3.6895765480E-01, 3.2634994675E-01, 6.0230145046E-01],
	[1.2510000000E+04, 5.6379957258E+00, 5.6686426426E+00, 3.6942002731E-01, 3.2672020140E-01, 6.0244420128E-01],
	[1.2515000000E+04, 5.6410204035E+00, 5.6681605461E+00, 3.6988279344E-01, 3.2709068854E-01, 6.0258693125E-01],
	[1.2520000000E+04, 5.6440454947E+00, 5.6676786832E+00, 3.7034595336E-01, 3.2746140814E-01, 6.0272964034E-01],
	[1.2525000000E+04, 5.6470709994E+00, 5.6671970535E+00, 3.7080950725E-01, 3.2783236016E-01, 6.0287232856E-01],
	[1.2530000000E+04, 5.6500969174E+00, 5.6667156571E+00, 3.7127345529E-01, 3.2820354457E-01, 6.0301499590E-01],
	[1.2535000000E+04, 5.6531232485E+00, 5.6662344935E+00, 3.7173779766E-01, 3.2857496134E-01, 6.0315764234E-01],
	[1.2540000000E+04, 5.6561499928E+00, 5.6657535627E+00, 3.7220253453E-01, 3.2894661043E-01, 6.0330026788E-01],
	[1.2545000000E+04, 5.6591771501E+00, 5.6652728644E+00, 3.7266766607E-01, 3.2931849180E-01, 6.0344287250E-01],
	[1.2550000000E+04, 5.6622047202E+00, 5.6647923984E+00, 3.7313319247E-01, 3.2969060543E-01, 6.0358545621E-01],
	[1.2555000000E+04, 5.6652327031E+00, 5.6643121645E+00, 3.7359911390E-01, 3.3006295128E-01, 6.0372801899E-01],
	[1.2560000000E+04, 5.6682610987E+00, 5.6638321625E+00, 3.7406543054E-01, 3.3043552931E-01, 6.0387056083E-01],
	[1.2565000000E+04, 5.6712899069E+00, 5.6633523922E+00, 3.7453214256E-01, 3.3080833950E-01, 6.0401308172E-01],
	[1.2570000000E+04, 5.6743191274E+00, 5.6628728534E+00, 3.7499925015E-01, 3.3118138180E-01, 6.0415558167E-01],
	[1.2575000000E+04, 5.6773487604E+00, 5.6623935459E+00, 3.7546675347E-01, 3.3155465617E-01, 6.0429806064E-01],
	[1.2580000000E+04, 5.6803788055E+00, 5.6619144694E+00, 3.7593465271E-01, 3.3192816260E-01, 6.0444051865E-01],
	[1.2585000000E+04, 5.6834092628E+00, 5.6614356239E+00, 3.7640294804E-01, 3.3230190103E-01, 6.0458295568E-01],
	[1.2590000000E+04, 5.6864401321E+00, 5.6609570090E+00, 3.7687163964E-01, 3.3267587144E-01, 6.0472537172E-01],
	[1.2595000000E+04, 5.6894714133E+00, 5.6604786247E+00, 3.7734072769E-01, 3.3305007378E-01, 6.0486776676E-01],
	[1.2600000000E+04, 5.6925031063E+00, 5.6600004705E+00, 3.7781021235E-01, 3.3342450803E-01, 6.0501014080E-01],
	[1.2605000000E+04, 5.6955352110E+00, 5.6595225465E+00, 3.7828009382E-01, 3.3379917414E-01, 6.0515249382E-01],
	[1.2610000000E+04, 5.6985677273E+00, 5.6590448523E+00, 3.7875037226E-01, 3.3417407209E-01, 6.0529482583E-01],
	[1.2615000000E+04, 5.7016006550E+00, 5.6585673878E+00, 3.7922104785E-01, 3.3454920183E-01, 6.0543713681E-01],
	[1.2620000000E+04, 5.7046339942E+00, 5.6580901528E+00, 3.7969212078E-01, 3.3492456333E-01, 6.0557942689E-01],
	[1.2625000000E+04, 5.7076677446E+00, 5.6576131470E+00, 3.8016359121E-01, 3.3530015655E-01, 6.0572169608E-01],
	[1.2630000000E+04, 5.7107066441E+00, 5.6571437040E+00, 3.8063545932E-01, 3.3567602364E-01, 6.0586394437E-01],
	[1.2635000000E+04, 5.7137464009E+00, 5.6566751710E+00, 3.8110772529E-01, 3.3605212650E-01, 6.0600617172E-01],
	[1.2640000000E+04, 5.7167865720E+00, 5.6562068621E+00, 3.8158038930E-01, 3.3642846113E-01, 6.0614837812E-01],
	[1.2645000000E+04, 5.7198271575E+00, 5.6557387772E+00, 3.8205345152E-01, 3.3680502752E-01, 6.0629056357E-01],
	[1.2650000000E+04, 5.7228681572E+00, 5.6552709161E+00, 3.8252691214E-01, 3.3718182562E-01, 6.0643272802E-01],
	[1.2655000000E+04, 5.7259095709E+00, 5.6548032786E+00, 3.8300077132E-01, 3.3755885540E-01, 6.0657487148E-01],
	[1.2660000000E+04, 5.7289513986E+00, 5.6543358644E+00, 3.8347502924E-01, 3.3793611681E-01, 6.0671699391E-01],
	[1.2665000000E+04, 5.7319936402E+00, 5.6538686734E+00, 3.8394968609E-01, 3.3831360982E-01, 6.0685909531E-01],
	[1.2670000000E+04, 5.7350362955E+00, 5.6534017054E+00, 3.8442474203E-01, 3.3869133440E-01, 6.0700117565E-01],
	[1.2675000000E+04, 5.7380793645E+00, 5.6529349602E+00, 3.8490019725E-01, 3.3906929050E-01, 6.0714323491E-01],
	[1.2680000000E+04, 5.7411228470E+00, 5.6524684376E+00, 3.8537605192E-01, 3.3944747809E-01, 6.0728527308E-01],
	[1.2685000000E+04, 5.7441667430E+00, 5.6520021373E+00, 3.8585230622E-01, 3.3982589712E-01, 6.0742729013E-01],
	[1.2690000000E+04, 5.7472110523E+00, 5.6515360593E+00, 3.8632896032E-01, 3.4020454757E-01, 6.0756928605E-01],
	[1.2695000000E+04, 5.7502557748E+00, 5.6510702033E+00, 3.8680601441E-01, 3.4058342939E-01, 6.0771126083E-01],
	[1.2700000000E+04, 5.7533009104E+00, 5.6506045691E+00, 3.8728346865E-01, 3.4096254255E-01, 6.0785321443E-01],
	[1.2705000000E+04, 5.7563464590E+00, 5.6501391566E+00, 3.8776132324E-01, 3.4134188700E-01, 6.0799514685E-01],
	[1.2710000000E+04, 5.7593924206E+00, 5.6496739655E+00, 3.8823957833E-01, 3.4172146270E-01, 6.0813705806E-01],
	[1.2715000000E+04, 5.7624387949E+00, 5.6492089956E+00, 3.8871823412E-01, 3.4210126963E-01, 6.0827894806E-01],
	[1.2720000000E+04, 5.7654855819E+00, 5.6487442468E+00, 3.8919729077E-01, 3.4248130773E-01, 6.0842081681E-01],
	[1.2725000000E+04, 5.7685327816E+00, 5.6482797188E+00, 3.8967674847E-01, 3.4286157697E-01, 6.0856266430E-01],
	[1.2730000000E+04, 5.7715803936E+00, 5.6478154115E+00, 3.9015660739E-01, 3.4324207732E-01, 6.0870449052E-01],
	[1.2735000000E+04, 5.7746284181E+00, 5.6473513247E+00, 3.9063686771E-01, 3.4362280872E-01, 6.0884629544E-01],
	[1.2740000000E+04, 5.7776768548E+00, 5.6468874582E+00, 3.9111752960E-01, 3.4400377115E-01, 6.0898807905E-01],
	[1.2745000000E+04, 5.7807257037E+00, 5.6464238118E+00, 3.9159859324E-01, 3.4438496456E-01, 6.0912984133E-01],
	[1.2750000000E+04, 5.7837749647E+00, 5.6459603852E+00, 3.9208005882E-01, 3.4476638890E-01, 6.0927158226E-01],
	[1.2755000000E+04, 5.7868246375E+00, 5.6454971784E+00, 3.9256192650E-01, 3.4514804415E-01, 6.0941330183E-01],
	[1.2760000000E+04, 5.7898747223E+00, 5.6450341911E+00, 3.9304419646E-01, 3.4552993026E-01, 6.0955500001E-01],
	[1.2765000000E+04, 5.7929252187E+00, 5.6445714232E+00, 3.9352686889E-01, 3.4591204719E-01, 6.0969667679E-01],
	[1.2770000000E+04, 5.7959761268E+00, 5.6441088743E+00, 3.9400994395E-01, 3.4629439491E-01, 6.0983833215E-01],
	[1.2775000000E+04, 5.7990274464E+00, 5.6436465445E+00, 3.9449342183E-01, 3.4667697336E-01, 6.0997996607E-01],
	[1.2780000000E+04, 5.8020791775E+00, 5.6431844334E+00, 3.9497730269E-01, 3.4705978250E-01, 6.1012157854E-01],
	[1.2785000000E+04, 5.8051313198E+00, 5.6427225409E+00, 3.9546158673E-01, 3.4744282231E-01, 6.1026316953E-01],
	[1.2790000000E+04, 5.8081838734E+00, 5.6422608667E+00, 3.9594627411E-01, 3.4782609273E-01, 6.1040473904E-01],
	[1.2795000000E+04, 5.8112368380E+00, 5.6417994108E+00, 3.9643136501E-01, 3.4820959373E-01, 6.1054628704E-01],
	[1.2800000000E+04, 5.8142902137E+00, 5.6413381729E+00, 3.9691685962E-01, 3.4859332526E-01, 6.1068781351E-01],
	[1.2805000000E+04, 5.8173440002E+00, 5.6408771528E+00, 3.9740275810E-01, 3.4897728728E-01, 6.1082931844E-01],
	[1.2810000000E+04, 5.8203981975E+00, 5.6404163503E+00, 3.9788906064E-01, 3.4936147975E-01, 6.1097080180E-01],
	[1.2815000000E+04, 5.8234528056E+00, 5.6399557653E+00, 3.9837576740E-01, 3.4974590263E-01, 6.1111226359E-01],
	[1.2820000000E+04, 5.8265078241E+00, 5.6394953975E+00, 3.9886287858E-01, 3.5013055587E-01, 6.1125370379E-01],
	[1.2825000000E+04, 5.8295632532E+00, 5.6390352468E+00, 3.9935039434E-01, 3.5051543944E-01, 6.1139512237E-01],
	[1.2830000000E+04, 5.8326205617E+00, 5.6385773864E+00, 3.9983831486E-01, 3.5090056664E-01, 6.1153651932E-01],
	[1.2835000000E+04, 5.8356823769E+00, 5.6381255181E+00, 4.0032664032E-01, 3.5128596139E-01, 6.1167789463E-01],
	[1.2840000000E+04, 5.8387446060E+00, 5.6376738620E+00, 4.0081537090E-01, 3.5167158652E-01, 6.1181924827E-01],
	[1.2845000000E+04, 5.8418072487E+00, 5.6372224179E+00, 4.0130450677E-01, 3.5205744199E-01, 6.1196058023E-01],
	[1.2850000000E+04, 5.8448703051E+00, 5.6367711857E+00, 4.0179404812E-01, 3.5244352776E-01, 6.1210189049E-01],
	[1.2855000000E+04, 5.8479337750E+00, 5.6363201650E+00, 4.0228399511E-01, 3.5282984379E-01, 6.1224317903E-01],
	[1.2860000000E+04, 5.8509976582E+00, 5.6358693559E+00, 4.0277434793E-01, 3.5321639002E-01, 6.1238444584E-01],
	[1.2865000000E+04, 5.8540619548E+00, 5.6354187580E+00, 4.0326510675E-01, 3.5360316643E-01, 6.1252569090E-01],
	[1.2870000000E+04, 5.8571266646E+00, 5.6349683712E+00, 4.0375627175E-01, 3.5399017296E-01, 6.1266691419E-01],
	[1.2875000000E+04, 5.8601917874E+00, 5.6345181953E+00, 4.0424784311E-01, 3.5437740957E-01, 6.1280811570E-01],
	[1.2880000000E+04, 5.8632573233E+00, 5.6340682302E+00, 4.0473982100E-01, 3.5476487622E-01, 6.1294929541E-01],
	[1.2885000000E+04, 5.8663232720E+00, 5.6336184756E+00, 4.0523220560E-01, 3.5515257286E-01, 6.1309045329E-01],
	[1.2890000000E+04, 5.8693896335E+00, 5.6331689314E+00, 4.0572499709E-01, 3.5554049946E-01, 6.1323158935E-01],
	[1.2895000000E+04, 5.8724564076E+00, 5.6327195974E+00, 4.0621819565E-01, 3.5592865596E-01, 6.1337270355E-01],
	[1.2900000000E+04, 5.8755235943E+00, 5.6322704734E+00, 4.0671180145E-01, 3.5631704232E-01, 6.1351379588E-01],
	[1.2905000000E+04, 5.8785911935E+00, 5.6318215592E+00, 4.0720581468E-01, 3.5670565851E-01, 6.1365486632E-01],
	[1.2910000000E+04, 5.8816592051E+00, 5.6313728547E+00, 4.0770023550E-01, 3.5709450446E-01, 6.1379591486E-01],
	[1.2915000000E+04, 5.8847276288E+00, 5.6309243597E+00, 4.0819506409E-01, 3.5748358015E-01, 6.1393694149E-01],
	[1.2920000000E+04, 5.8877964648E+00, 5.6304760740E+00, 4.0869030064E-01, 3.5787288552E-01, 6.1407794617E-01],
	[1.2925000000E+04, 5.8908657128E+00, 5.6300279974E+00, 4.0918594531E-01, 3.5826242054E-01, 6.1421892891E-01],
	[1.2930000000E+04, 5.8939353727E+00, 5.6295801297E+00, 4.0968199830E-01, 3.5865218514E-01, 6.1435988967E-01],
	[1.2935000000E+04, 5.8970054444E+00, 5.6291324708E+00, 4.1017845976E-01, 3.5904217930E-01, 6.1450082845E-01],
	[1.2940000000E+04, 5.9000759279E+00, 5.6286850205E+00, 4.1067532989E-01, 3.5943240296E-01, 6.1464174522E-01],
	[1.2945000000E+04, 5.9031468230E+00, 5.6282377785E+00, 4.1117260886E-01, 3.5982285608E-01, 6.1478263998E-01],
	[1.2950000000E+04, 5.9062181296E+00, 5.6277907448E+00, 4.1167029684E-01, 3.6021353861E-01, 6.1492351269E-01],
	[1.2955000000E+04, 5.9092898477E+00, 5.6273439192E+00, 4.1216839402E-01, 3.6060445051E-01, 6.1506436336E-01],
	[1.2960000000E+04, 5.9123619771E+00, 5.6268973015E+00, 4.1266690057E-01, 3.6099559174E-01, 6.1520519196E-01],
	[1.2965000000E+04, 5.9154345176E+00, 5.6264508914E+00, 4.1316581666E-01, 3.6138696223E-01, 6.1534599847E-01],
	[1.2970000000E+04, 5.9185074693E+00, 5.6260046889E+00, 4.1366514248E-01, 3.6177856196E-01, 6.1548678288E-01],
	[1.2975000000E+04, 5.9215808320E+00, 5.6255586937E+00, 4.1416487821E-01, 3.6217039087E-01, 6.1562754517E-01],
	[1.2980000000E+04, 5.9246546056E+00, 5.6251129056E+00, 4.1466502401E-01, 3.6256244892E-01, 6.1576828533E-01],
	[1.2985000000E+04, 5.9277287900E+00, 5.6246673246E+00, 4.1516558007E-01, 3.6295473605E-01, 6.1590900333E-01],
	[1.2990000000E+04, 5.9308033851E+00, 5.6242219504E+00, 4.1566654657E-01, 3.6334725223E-01, 6.1604969917E-01],
	[1.2995000000E+04, 5.9338783908E+00, 5.6237767828E+00, 4.1616792368E-01, 3.6373999741E-01, 6.1619037283E-01],
	[1.3000000000E+04, 5.9369538070E+00, 5.6233318217E+00, 4.1666971157E-01, 3.6413297153E-01, 6.1633102428E-01],
	[1.3005000000E+04, 5.9400296335E+00, 5.6228870669E+00, 4.1717191044E-01, 3.6452617455E-01, 6.1647165353E-01],
	[1.3010000000E+04, 5.9431058703E+00, 5.6224425182E+00, 4.1767452045E-01, 3.6491960643E-01, 6.1661226053E-01],
	[1.3015000000E+04, 5.9461825174E+00, 5.6219981755E+00, 4.1817754178E-01, 3.6531326712E-01, 6.1675284529E-01],
	[1.3020000000E+04, 5.9492595744E+00, 5.6215540385E+00, 4.1868097461E-01, 3.6570715656E-01, 6.1689340779E-01],
	[1.3025000000E+04, 5.9523370415E+00, 5.6211101071E+00, 4.1918481911E-01, 3.6610127472E-01, 6.1703394801E-01],
	[1.3030000000E+04, 5.9554149184E+00, 5.6206663811E+00, 4.1968907548E-01, 3.6649562153E-01, 6.1717446593E-01],
	[1.3035000000E+04, 5.9584932052E+00, 5.6202228604E+00, 4.2019374387E-01, 3.6689019697E-01, 6.1731496154E-01],
	[1.3040000000E+04, 5.9615776131E+00, 5.6197869175E+00, 4.2069882447E-01, 3.6728505414E-01, 6.1745543482E-01],
	[1.3045000000E+04, 5.9646626773E+00, 5.6193514889E+00, 4.2120431746E-01, 3.6768014228E-01, 6.1759588576E-01],
	[1.3050000000E+04, 5.9677481547E+00, 5.6189162609E+00, 4.2171022301E-01, 3.6807545909E-01, 6.1773631433E-01],
	[1.3055000000E+04, 5.9708340454E+00, 5.6184812333E+00, 4.2221654130E-01, 3.6847100452E-01, 6.1787672053E-01],
	[1.3060000000E+04, 5.9739203493E+00, 5.6180464059E+00, 4.2272327251E-01, 3.6886677853E-01, 6.1801710434E-01],
	[1.3065000000E+04, 5.9770070661E+00, 5.6176117786E+00, 4.2323041682E-01, 3.6926278105E-01, 6.1815746575E-01],
	[1.3070000000E+04, 5.9800941959E+00, 5.6171773512E+00, 4.2373797441E-01, 3.6965901205E-01, 6.1829780473E-01],
	[1.3075000000E+04, 5.9831817385E+00, 5.6167431235E+00, 4.2424594544E-01, 3.7005547148E-01, 6.1843812127E-01],
	[1.3080000000E+04, 5.9862696938E+00, 5.6163090954E+00, 4.2475433010E-01, 3.7045215928E-01, 6.1857841536E-01],
	[1.3085000000E+04, 5.9893580617E+00, 5.6158752668E+00, 4.2526312857E-01, 3.7084907541E-01, 6.1871868697E-01],
	[1.3090000000E+04, 5.9924468421E+00, 5.6154416373E+00, 4.2577234102E-01, 3.7124621982E-01, 6.1885893610E-01],
	[1.3095000000E+04, 5.9955360350E+00, 5.6150082069E+00, 4.2628196764E-01, 3.7164359245E-01, 6.1899916274E-01],
	[1.3100000000E+04, 5.9986256401E+00, 5.6145749754E+00, 4.2679200859E-01, 3.7204119327E-01, 6.1913936685E-01],
	[1.3105000000E+04, 6.0017156575E+00, 5.6141419427E+00, 4.2730246406E-01, 3.7243902221E-01, 6.1927954843E-01],
	[1.3110000000E+04, 6.0048060869E+00, 5.6137091085E+00, 4.2781333422E-01, 3.7283707923E-01, 6.1941970746E-01],
	[1.3115000000E+04, 6.0078969284E+00, 5.6132764727E+00, 4.2832461926E-01, 3.7323536428E-01, 6.1955984393E-01],
	[1.3120000000E+04, 6.0109881817E+00, 5.6128440351E+00, 4.2883631934E-01, 3.7363387730E-01, 6.1969995783E-01],
	[1.3125000000E+04, 6.0140798469E+00, 5.6124117956E+00, 4.2934843466E-01, 3.7403261825E-01, 6.1984004912E-01],
	[1.3130000000E+04, 6.0171719237E+00, 5.6119797540E+00, 4.2986096537E-01, 3.7443158708E-01, 6.1998011781E-01],
	[1.3135000000E+04, 6.0202644121E+00, 5.6115479102E+00, 4.3037391167E-01, 3.7483078374E-01, 6.2012016388E-01],
	[1.3140000000E+04, 6.0233573120E+00, 5.6111162639E+00, 4.3088727373E-01, 3.7523020817E-01, 6.2026018730E-01],
	[1.3145000000E+04, 6.0264506233E+00, 5.6106848150E+00, 4.3140105172E-01, 3.7562986033E-01, 6.2040018807E-01],
	[1.3150000000E+04, 6.0295443459E+00, 5.6102535633E+00, 4.3191524583E-01, 3.7602974015E-01, 6.2054016617E-01],
	[1.3155000000E+04, 6.0326384796E+00, 5.6098225087E+00, 4.3242985623E-01, 3.7642984760E-01, 6.2068012158E-01],
	[1.3160000000E+04, 6.0357330245E+00, 5.6093916510E+00, 4.3294488310E-01, 3.7683018262E-01, 6.2082005429E-01],
	[1.3165000000E+04, 6.0388279803E+00, 5.6089609901E+00, 4.3346032662E-01, 3.7723074516E-01, 6.2095996429E-01],
	[1.3170000000E+04, 6.0419233470E+00, 5.6085305257E+00, 4.3397618697E-01, 3.7763153516E-01, 6.2109985155E-01],
	[1.3175000000E+04, 6.0450191245E+00, 5.6081002577E+00, 4.3449246431E-01, 3.7803255258E-01, 6.2123971607E-01],
	[1.3180000000E+04, 6.0481153126E+00, 5.6076701860E+00, 4.3500915884E-01, 3.7843379736E-01, 6.2137955783E-01],
	[1.3185000000E+04, 6.0512119113E+00, 5.6072403104E+00, 4.3552627073E-01, 3.7883526946E-01, 6.2151937681E-01],
	[1.3190000000E+04, 6.0543089205E+00, 5.6068106307E+00, 4.3604380015E-01, 3.7923696880E-01, 6.2165917300E-01],
	[1.3195000000E+04, 6.0574063401E+00, 5.6063811468E+00, 4.3656174729E-01, 3.7963889536E-01, 6.2179894638E-01],
	[1.3200000000E+04, 6.0605041699E+00, 5.6059518584E+00, 4.3708011231E-01, 3.8004104907E-01, 6.2193869694E-01],
	[1.3205000000E+04, 6.0636024100E+00, 5.6055227655E+00, 4.3759889541E-01, 3.8044342987E-01, 6.2207842467E-01],
	[1.3210000000E+04, 6.0667010600E+00, 5.6050938679E+00, 4.3811809675E-01, 3.8084603773E-01, 6.2221812954E-01],
	[1.3215000000E+04, 6.0698001201E+00, 5.6046651653E+00, 4.3863771652E-01, 3.8124887258E-01, 6.2235781155E-01],
	[1.3220000000E+04, 6.0728995900E+00, 5.6042366577E+00, 4.3915775489E-01, 3.8165193437E-01, 6.2249747068E-01],
	[1.3225000000E+04, 6.0759994696E+00, 5.6038083449E+00, 4.3967821204E-01, 3.8205522304E-01, 6.2263710692E-01],
	[1.3230000000E+04, 6.0790997590E+00, 5.6033802267E+00, 4.4019908814E-01, 3.8245873855E-01, 6.2277672024E-01],
	[1.3235000000E+04, 6.0822004579E+00, 5.6029523029E+00, 4.4072038338E-01, 3.8286248084E-01, 6.2291631064E-01],
	[1.3240000000E+04, 6.0853015662E+00, 5.6025245735E+00, 4.4124209794E-01, 3.8326644985E-01, 6.2305587810E-01],
	[1.3245000000E+04, 6.0884030840E+00, 5.6020970382E+00, 4.4176423199E-01, 3.8367064554E-01, 6.2319542261E-01],
	[1.3250000000E+04, 6.0915112926E+00, 5.6016771432E+00, 4.4228678570E-01, 3.8407512782E-01, 6.2333494415E-01],
	[1.3255000000E+04, 6.0946199816E+00, 5.6012575179E+00, 4.4280975926E-01, 3.8447983752E-01, 6.2347444270E-01],
	[1.3260000000E+04, 6.0977290838E+00, 5.6008380822E+00, 4.4333315284E-01, 3.8488477394E-01, 6.2361391826E-01],
	[1.3265000000E+04, 6.1008385990E+00, 5.6004188360E+00, 4.4385696663E-01, 3.8528993703E-01, 6.2375337080E-01],
	[1.3270000000E+04, 6.1039485272E+00, 5.5999997792E+00, 4.4438120080E-01, 3.8569532673E-01, 6.2389280032E-01],
	[1.3275000000E+04, 6.1070588682E+00, 5.5995809116E+00, 4.4490585552E-01, 3.8610094299E-01, 6.2403220680E-01],
	[1.3280000000E+04, 6.1101696219E+00, 5.5991622330E+00, 4.4543093098E-01, 3.8650678576E-01, 6.2417159022E-01],
	[1.3285000000E+04, 6.1132807882E+00, 5.5987437433E+00, 4.4595642735E-01, 3.8691285497E-01, 6.2431095057E-01],
	[1.3290000000E+04, 6.1163923671E+00, 5.5983254424E+00, 4.4648234481E-01, 3.8731915058E-01, 6.2445028784E-01],
	[1.3295000000E+04, 6.1195043584E+00, 5.5979073300E+00, 4.4700868355E-01, 3.8772567253E-01, 6.2458960201E-01],
	[1.3300000000E+04, 6.1226167621E+00, 5.5974894061E+00, 4.4753544372E-01, 3.8813242076E-01, 6.2472889306E-01],
	[1.3305000000E+04, 6.1257295780E+00, 5.5970716704E+00, 4.4806262553E-01, 3.8853939522E-01, 6.2486816099E-01],
	[1.3310000000E+04, 6.1288428060E+00, 5.5966541229E+00, 4.4859022913E-01, 3.8894659585E-01, 6.2500740578E-01],
	[1.3315000000E+04, 6.1319564460E+00, 5.5962367633E+00, 4.4911825472E-01, 3.8935402260E-01, 6.2514662741E-01],
	[1.3320000000E+04, 6.1350704980E+00, 5.5958195915E+00, 4.4964670246E-01, 3.8976167541E-01, 6.2528582587E-01],
	[1.3325000000E+04, 6.1381849618E+00, 5.5954026073E+00, 4.5017557254E-01, 3.9016955423E-01, 6.2542500115E-01],
	[1.3330000000E+04, 6.1412998373E+00, 5.5949858107E+00, 4.5070486513E-01, 3.9057765900E-01, 6.2556415323E-01],
	[1.3335000000E+04, 6.1444151245E+00, 5.5945692014E+00, 4.5123458041E-01, 3.9098598966E-01, 6.2570328209E-01],
	[1.3340000000E+04, 6.1475308232E+00, 5.5941527792E+00, 4.5176471857E-01, 3.9139454616E-01, 6.2584238773E-01],
	[1.3345000000E+04, 6.1506469333E+00, 5.5937365441E+00, 4.5229527977E-01, 3.9180332844E-01, 6.2598147014E-01],
	[1.3350000000E+04, 6.1537634548E+00, 5.5933204959E+00, 4.5282626419E-01, 3.9221233644E-01, 6.2612052928E-01],
	[1.3355000000E+04, 6.1568803875E+00, 5.5929046344E+00, 4.5335767202E-01, 3.9262157011E-01, 6.2625956516E-01],
	[1.3360000000E+04, 6.1599977313E+00, 5.5924889595E+00, 4.5388950343E-01, 3.9303102939E-01, 6.2639857776E-01],
	[1.3365000000E+04, 6.1631154861E+00, 5.5920734709E+00, 4.5442175860E-01, 3.9344071422E-01, 6.2653756706E-01],
	[1.3370000000E+04, 6.1662336519E+00, 5.5916581687E+00, 4.5495443771E-01, 3.9385062455E-01, 6.2667653305E-01],
	[1.3375000000E+04, 6.1693522285E+00, 5.5912430525E+00, 4.5548754093E-01, 3.9426076032E-01, 6.2681547571E-01],
	[1.3380000000E+04, 6.1724712159E+00, 5.5908281223E+00, 4.5602106844E-01, 3.9467112147E-01, 6.2695439504E-01],
	[1.3385000000E+04, 6.1755906138E+00, 5.5904133779E+00, 4.5655502042E-01, 3.9508170794E-01, 6.2709329102E-01],
	[1.3390000000E+04, 6.1787104224E+00, 5.5899988192E+00, 4.5708939706E-01, 3.9549251967E-01, 6.2723216363E-01],
	[1.3395000000E+04, 6.1818306413E+00, 5.5895844459E+00, 4.5762419852E-01, 3.9590355662E-01, 6.2737101286E-01],
	[1.3400000000E+04, 6.1849512706E+00, 5.5891702580E+00, 4.5815942498E-01, 3.9631481871E-01, 6.2750983870E-01],
	[1.3405000000E+04, 6.1880723101E+00, 5.5887562553E+00, 4.5869507663E-01, 3.9672630589E-01, 6.2764864114E-01],
	[1.3410000000E+04, 6.1911937598E+00, 5.5883424376E+00, 4.5923115364E-01, 3.9713801811E-01, 6.2778742015E-01],
	[1.3415000000E+04, 6.1943156195E+00, 5.5879288048E+00, 4.5976765618E-01, 3.9754995529E-01, 6.2792617573E-01],
	[1.3420000000E+04, 6.1974378891E+00, 5.5875153568E+00, 4.6030458445E-01, 3.9796211740E-01, 6.2806490787E-01],
	[1.3425000000E+04, 6.2005605686E+00, 5.5871020933E+00, 4.6084193861E-01, 3.9837450436E-01, 6.2820361654E-01],
	[1.3430000000E+04, 6.2036836578E+00, 5.5866890143E+00, 4.6137971884E-01, 3.9878711612E-01, 6.2834230174E-01],
	[1.3435000000E+04, 6.2068071566E+00, 5.5862761196E+00, 4.6191792532E-01, 3.9919995261E-01, 6.2848096345E-01],
	[1.3440000000E+04, 6.2099310650E+00, 5.5858634090E+00, 4.6245655823E-01, 3.9961301379E-01, 6.2861960166E-01],
	[1.3445000000E+04, 6.2130553829E+00, 5.5854508823E+00, 4.6299561774E-01, 4.0002629958E-01, 6.2875821636E-01],
	[1.3450000000E+04, 6.2161801101E+00, 5.5850385396E+00, 4.6353510405E-01, 4.0043980993E-01, 6.2889680752E-01],
	[1.3455000000E+04, 6.2193052465E+00, 5.5846263805E+00, 4.6407501731E-01, 4.0085354478E-01, 6.2903537515E-01],
	[1.3460000000E+04, 6.2224331125E+00, 5.5842169401E+00, 4.6461535772E-01, 4.0126752682E-01, 6.2917391922E-01],
	[1.3465000000E+04, 6.2255658163E+00, 5.5838125164E+00, 4.6515612544E-01, 4.0168177676E-01, 6.2931243973E-01],
	[1.3470000000E+04, 6.2286989334E+00, 5.5834082721E+00, 4.6569732066E-01, 4.0209625125E-01, 6.2945093665E-01],
	[1.3475000000E+04, 6.2318324637E+00, 5.5830042071E+00, 4.6623894356E-01, 4.0251095022E-01, 6.2958940998E-01],
	[1.3480000000E+04, 6.2349664069E+00, 5.5826003212E+00, 4.6678099431E-01, 4.0292587362E-01, 6.2972785970E-01],
	[1.3485000000E+04, 6.2381007631E+00, 5.5821966143E+00, 4.6732347309E-01, 4.0334102138E-01, 6.2986628580E-01],
	[1.3490000000E+04, 6.2412355321E+00, 5.5817930863E+00, 4.6786638008E-01, 4.0375639345E-01, 6.3000468826E-01],
	[1.3495000000E+04, 6.2443707139E+00, 5.5813897369E+00, 4.6840971546E-01, 4.0417198977E-01, 6.3014306708E-01],
	[1.3500000000E+04, 6.2475063083E+00, 5.5809865661E+00, 4.6895347941E-01, 4.0458781027E-01, 6.3028142224E-01],
	[1.3505000000E+04, 6.2506423152E+00, 5.5805835736E+00, 4.6949767209E-01, 4.0500385489E-01, 6.3041975373E-01],
	[1.3510000000E+04, 6.2537787346E+00, 5.5801807595E+00, 4.7004229371E-01, 4.0542012358E-01, 6.3055806152E-01],
	[1.3515000000E+04, 6.2569155663E+00, 5.5797781234E+00, 4.7058734442E-01, 4.0583661627E-01, 6.3069634562E-01],
	[1.3520000000E+04, 6.2600528103E+00, 5.5793756653E+00, 4.7113282440E-01, 4.0625333290E-01, 6.3083460601E-01],
	[1.3525000000E+04, 6.2631904664E+00, 5.5789733851E+00, 4.7167873385E-01, 4.0667027341E-01, 6.3097284267E-01],
	[1.3530000000E+04, 6.2663285345E+00, 5.5785712825E+00, 4.7222507293E-01, 4.0708743774E-01, 6.3111105559E-01],
	[1.3535000000E+04, 6.2694670147E+00, 5.5781693574E+00, 4.7277184182E-01, 4.0750482582E-01, 6.3124924476E-01],
	[1.3540000000E+04, 6.2726059066E+00, 5.5777676098E+00, 4.7331904071E-01, 4.0792243760E-01, 6.3138741017E-01],
	[1.3545000000E+04, 6.2757452103E+00, 5.5773660393E+00, 4.7386666976E-01, 4.0834027301E-01, 6.3152555180E-01],
	[1.3550000000E+04, 6.2788849257E+00, 5.5769646460E+00, 4.7441472916E-01, 4.0875833199E-01, 6.3166366964E-01],
	[1.3555000000E+04, 6.2820250526E+00, 5.5765634297E+00, 4.7496321908E-01, 4.0917661448E-01, 6.3180176368E-01],
	[1.3560000000E+04, 6.2851655910E+00, 5.5761623901E+00, 4.7551213971E-01, 4.0959512041E-01, 6.3193983390E-01],
	[1.3565000000E+04, 6.2883065408E+00, 5.5757615273E+00, 4.7606149122E-01, 4.1001384973E-01, 6.3207788030E-01],
	[1.3570000000E+04, 6.2914479018E+00, 5.5753608409E+00, 4.7661127380E-01, 4.1043280237E-01, 6.3221590285E-01],
	[1.3575000000E+04, 6.2945896740E+00, 5.5749603310E+00, 4.7716148761E-01, 4.1085197827E-01, 6.3235390155E-01],
	[1.3580000000E+04, 6.2977318572E+00, 5.5745599973E+00, 4.7771213283E-01, 4.1127137736E-01, 6.3249187638E-01],
	[1.3585000000E+04, 6.3008744514E+00, 5.5741598397E+00, 4.7826320965E-01, 4.1169099959E-01, 6.3262982734E-01],
	[1.3590000000E+04, 6.3040174565E+00, 5.5737598581E+00, 4.7881471825E-01, 4.1211084488E-01, 6.3276775440E-01],
	[1.3595000000E+04, 6.3071608724E+00, 5.5733600523E+00, 4.7936665879E-01, 4.1253091318E-01, 6.3290565756E-01],
	[1.3600000000E+04, 6.3103046989E+00, 5.5729604221E+00, 4.7991903147E-01, 4.1295120443E-01, 6.3304353681E-01],
	[1.3605000000E+04, 6.3134489360E+00, 5.5725609675E+00, 4.8047183645E-01, 4.1337171855E-01, 6.3318139212E-01],
	[1.3610000000E+04, 6.3165935837E+00, 5.5721616883E+00, 4.8102507392E-01, 4.1379245548E-01, 6.3331922350E-01],
	[1.3615000000E+04, 6.3197386417E+00, 5.5717625843E+00, 4.8157874405E-01, 4.1421341517E-01, 6.3345703091E-01],
	[1.3620000000E+04, 6.3228841099E+00, 5.5713636555E+00, 4.8213284703E-01, 4.1463459754E-01, 6.3359481437E-01],
	[1.3625000000E+04, 6.3260299884E+00, 5.5709649016E+00, 4.8268738303E-01, 4.1505600254E-01, 6.3373257384E-01],
	[1.3630000000E+04, 6.3291762770E+00, 5.5705663226E+00, 4.8324235223E-01, 4.1547763009E-01, 6.3387030928E-01],
	[1.3635000000E+04, 6.3323229756E+00, 5.5701679182E+00, 4.8379775480E-01, 4.1589948014E-01, 6.3400802065E-01],
	[1.3640000000E+04, 6.3354700840E+00, 5.5697696884E+00, 4.8435359093E-01, 4.1632155262E-01, 6.3414570793E-01],
	[1.3645000000E+04, 6.3386176023E+00, 5.5693716330E+00, 4.8490986080E-01, 4.1674384746E-01, 6.3428337111E-01],
	[1.3650000000E+04, 6.3417655303E+00, 5.5689737518E+00, 4.8546656457E-01, 4.1716636460E-01, 6.3442101016E-01],
	[1.3655000000E+04, 6.3449138679E+00, 5.5685760448E+00, 4.8602370244E-01, 4.1758910397E-01, 6.3455862506E-01],
	[1.3660000000E+04, 6.3480626150E+00, 5.5681785118E+00, 4.8658127458E-01, 4.1801206552E-01, 6.3469621579E-01],
	[1.3665000000E+04, 6.3512117716E+00, 5.5677811526E+00, 4.8713928117E-01, 4.1843524917E-01, 6.3483378234E-01],
	[1.3670000000E+04, 6.3543613374E+00, 5.5673839672E+00, 4.8769772238E-01, 4.1885865485E-01, 6.3497132468E-01],
	[1.3675000000E+04, 6.3575113979E+00, 5.5669870415E+00, 4.8825659839E-01, 4.1928228338E-01, 6.3510884279E-01],
	[1.3680000000E+04, 6.3606689334E+00, 5.5665974201E+00, 4.8881590939E-01, 4.1970620511E-01, 6.3524633665E-01],
	[1.3685000000E+04, 6.3638268825E+00, 5.5662079683E+00, 4.8937565555E-01, 4.2013034892E-01, 6.3538380625E-01],
	[1.3690000000E+04, 6.3669852449E+00, 5.5658186861E+00, 4.8993583705E-01, 4.2055471475E-01, 6.3552125157E-01],
	[1.3695000000E+04, 6.3701440207E+00, 5.5654295731E+00, 4.9049796899E-01, 4.2098041847E-01, 6.3565867258E-01],
	[1.3700000000E+04, 6.3733032096E+00, 5.5650406295E+00, 4.9106301368E-01, 4.2140816764E-01, 6.3579606926E-01],
	[1.3705000000E+04, 6.3764628117E+00, 5.5646518549E+00, 4.9162850200E-01, 4.2183614276E-01, 6.3593344161E-01],
	[1.3710000000E+04, 6.3796228268E+00, 5.5642632492E+00, 4.9219443415E-01, 4.2226434376E-01, 6.3607078958E-01],
	[1.3715000000E+04, 6.3827832549E+00, 5.5638748124E+00, 4.9276081031E-01, 4.2269277057E-01, 6.3620811318E-01],
	[1.3720000000E+04, 6.3859440958E+00, 5.5634865443E+00, 4.9332763066E-01, 4.2312142311E-01, 6.3634541237E-01],
	[1.3725000000E+04, 6.3891053494E+00, 5.5630984447E+00, 4.9389489538E-01, 4.2355030134E-01, 6.3648268714E-01],
	[1.3730000000E+04, 6.3922670157E+00, 5.5627105135E+00, 4.9446260467E-01, 4.2397940517E-01, 6.3661993747E-01],
	[1.3735000000E+04, 6.3954290945E+00, 5.5623227506E+00, 4.9503075871E-01, 4.2440873454E-01, 6.3675716334E-01],
	[1.3740000000E+04, 6.3985915857E+00, 5.5619351559E+00, 4.9559935768E-01, 4.2483828939E-01, 6.3689436473E-01],
	[1.3745000000E+04, 6.4017544893E+00, 5.5615477292E+00, 4.9616840177E-01, 4.2526806965E-01, 6.3703154163E-01],
	[1.3750000000E+04, 6.4049178052E+00, 5.5611604703E+00, 4.9673789116E-01, 4.2569807525E-01, 6.3716869400E-01],
	[1.3755000000E+04, 6.4080815332E+00, 5.5607733792E+00, 4.9730782605E-01, 4.2612830611E-01, 6.3730582184E-01],
	[1.3760000000E+04, 6.4112456732E+00, 5.5603864558E+00, 4.9787820661E-01, 4.2655876219E-01, 6.3744292512E-01],
	[1.3765000000E+04, 6.4144102253E+00, 5.5599996998E+00, 4.9844903303E-01, 4.2698944340E-01, 6.3758000382E-01],
	[1.3770000000E+04, 6.4175751892E+00, 5.5596131111E+00, 4.9902030549E-01, 4.2742034967E-01, 6.3771705794E-01],
	[1.3775000000E+04, 6.4207405649E+00, 5.5592266897E+00, 4.9959202419E-01, 4.2785148095E-01, 6.3785408743E-01],
	[1.3780000000E+04, 6.4239063522E+00, 5.5588404353E+00, 5.0016418931E-01, 4.2828283716E-01, 6.3799109230E-01],
	[1.3785000000E+04, 6.4270725512E+00, 5.5584543479E+00, 5.0073680103E-01, 4.2871441823E-01, 6.3812807252E-01],
	[1.3790000000E+04, 6.4302391616E+00, 5.5580684273E+00, 5.0130985954E-01, 4.2914622409E-01, 6.3826502806E-01],
	[1.3795000000E+04, 6.4334061834E+00, 5.5576826734E+00, 5.0188336502E-01, 4.2957825468E-01, 6.3840195892E-01],
	[1.3800000000E+04, 6.4365736165E+00, 5.5572970860E+00, 5.0245731766E-01, 4.3001050993E-01, 6.3853886507E-01],
	[1.3805000000E+04, 6.4397414608E+00, 5.5569116650E+00, 5.0303171765E-01, 4.3044298976E-01, 6.3867574649E-01],
	[1.3810000000E+04, 6.4429097162E+00, 5.5565264104E+00, 5.0360656516E-01, 4.3087569412E-01, 6.3881260317E-01],
	[1.3815000000E+04, 6.4460783826E+00, 5.5561413219E+00, 5.0418186039E-01, 4.3130862292E-01, 6.3894943509E-01],
	[1.3820000000E+04, 6.4492474600E+00, 5.5557563994E+00, 5.0475760353E-01, 4.3174177610E-01, 6.3908624222E-01],
	[1.3825000000E+04, 6.4524169481E+00, 5.5553716428E+00, 5.0533379475E-01, 4.3217515359E-01, 6.3922302455E-01],
	[1.3830000000E+04, 6.4555868470E+00, 5.5549870519E+00, 5.0591043424E-01, 4.3260875532E-01, 6.3935978206E-01],
	[1.3835000000E+04, 6.4587571565E+00, 5.5546026267E+00, 5.0648752219E-01, 4.3304258121E-01, 6.3949651474E-01],
	[1.3840000000E+04, 6.4619278765E+00, 5.5542183670E+00, 5.0706505879E-01, 4.3347663121E-01, 6.3963322255E-01],
	[1.3845000000E+04, 6.4650990070E+00, 5.5538342726E+00, 5.0764304421E-01, 4.3391090524E-01, 6.3976990550E-01],
	[1.3850000000E+04, 6.4682705478E+00, 5.5534503435E+00, 5.0822147865E-01, 4.3434540322E-01, 6.3990656354E-01],
	[1.3855000000E+04, 6.4714424988E+00, 5.5530665795E+00, 5.0880036229E-01, 4.3478012510E-01, 6.4004319668E-01],
	[1.3860000000E+04, 6.4746148600E+00, 5.5526829805E+00, 5.0937969531E-01, 4.3521507079E-01, 6.4017980488E-01],
	[1.3865000000E+04, 6.4777876313E+00, 5.5522995463E+00, 5.0995947791E-01, 4.3565024023E-01, 6.4031638814E-01],
	[1.3870000000E+04, 6.4809608125E+00, 5.5519162768E+00, 5.1053971026E-01, 4.3608563334E-01, 6.4045294643E-01],
	[1.3875000000E+04, 6.4841344036E+00, 5.5515331719E+00, 5.1112039256E-01, 4.3652125006E-01, 6.4058947973E-01],
	[1.3880000000E+04, 6.4873084044E+00, 5.5511502314E+00, 5.1170152498E-01, 4.3695709031E-01, 6.4072598803E-01],
	[1.3885000000E+04, 6.4904828149E+00, 5.5507674553E+00, 5.1228310772E-01, 4.3739315402E-01, 6.4086247131E-01],
	[1.3890000000E+04, 6.4936576350E+00, 5.5503848434E+00, 5.1286514096E-01, 4.3782944112E-01, 6.4099892955E-01],
	[1.3895000000E+04, 6.4968328646E+00, 5.5500023955E+00, 5.1344762489E-01, 4.3826595154E-01, 6.4113536273E-01],
	[1.3900000000E+04, 6.5000159298E+00, 5.5496270549E+00, 5.1403055968E-01, 4.3870276242E-01, 6.4127177083E-01],
	[1.3905000000E+04, 6.5031995422E+00, 5.5492519993E+00, 5.1461394553E-01, 4.3913979812E-01, 6.4140815384E-01],
	[1.3910000000E+04, 6.5063835685E+00, 5.5488771039E+00, 5.1519778263E-01, 4.3957705718E-01, 6.4154451173E-01],
	[1.3915000000E+04, 6.5095680085E+00, 5.5485023685E+00, 5.1578207115E-01, 4.4001453953E-01, 6.4168084450E-01],
	[1.3920000000E+04, 6.5127528623E+00, 5.5481277930E+00, 5.1636681129E-01, 4.4045224509E-01, 6.4181715211E-01],
	[1.3925000000E+04, 6.5159381296E+00, 5.5477533774E+00, 5.1695200323E-01, 4.4089017380E-01, 6.4195343456E-01],
	[1.3930000000E+04, 6.5191238105E+00, 5.5473791214E+00, 5.1753764715E-01, 4.4132832558E-01, 6.4208969183E-01],
	[1.3935000000E+04, 6.5223099047E+00, 5.5470050249E+00, 5.1812374325E-01, 4.4176670036E-01, 6.4222592389E-01],
	[1.3940000000E+04, 6.5254964123E+00, 5.5466310879E+00, 5.1871029170E-01, 4.4220529806E-01, 6.4236213073E-01],
	[1.3945000000E+04, 6.5286833331E+00, 5.5462573101E+00, 5.1929729269E-01, 4.4264411862E-01, 6.4249831234E-01],
	[1.3950000000E+04, 6.5318706670E+00, 5.5458836916E+00, 5.1988474641E-01, 4.4308316196E-01, 6.4263446869E-01],
	[1.3955000000E+04, 6.5350584139E+00, 5.5455102321E+00, 5.2047265305E-01, 4.4352242801E-01, 6.4277059976E-01],
	[1.3960000000E+04, 6.5382465737E+00, 5.5451369314E+00, 5.2106101279E-01, 4.4396191669E-01, 6.4290670555E-01],
	[1.3965000000E+04, 6.5414351464E+00, 5.5447637896E+00, 5.2164982581E-01, 4.4440162794E-01, 6.4304278602E-01],
	[1.3970000000E+04, 6.5446241319E+00, 5.5443908065E+00, 5.2223909230E-01, 4.4484156167E-01, 6.4317884117E-01],
	[1.3975000000E+04, 6.5478135299E+00, 5.5440179819E+00, 5.2282881246E-01, 4.4528171782E-01, 6.4331487097E-01],
	[1.3980000000E+04, 6.5510033406E+00, 5.5436453157E+00, 5.2341898645E-01, 4.4572209630E-01, 6.4345087542E-01],
	[1.3985000000E+04, 6.5541935637E+00, 5.5432728079E+00, 5.2400961447E-01, 4.4616269706E-01, 6.4358685448E-01],
	[1.3990000000E+04, 6.5573841991E+00, 5.5429004582E+00, 5.2460069671E-01, 4.4660352001E-01, 6.4372280815E-01],
	[1.3995000000E+04, 6.5605752469E+00, 5.5425282665E+00, 5.2519223335E-01, 4.4704456507E-01, 6.4385873640E-01],
	[1.4000000000E+04, 6.5637667068E+00, 5.5421562328E+00, 5.2578422458E-01, 4.4748583219E-01, 6.4399463922E-01],
	[1.4005000000E+04, 6.5669585788E+00, 5.5417843569E+00, 5.2637667058E-01, 4.4792732127E-01, 6.4413051659E-01],
	[1.4010000000E+04, 6.5701508627E+00, 5.5414126386E+00, 5.2696957154E-01, 4.4836903224E-01, 6.4426636849E-01],
	[1.4015000000E+04, 6.5733435586E+00, 5.5410410780E+00, 5.2756292764E-01, 4.4881096504E-01, 6.4440219492E-01],
	[1.4020000000E+04, 6.5765366663E+00, 5.5406696747E+00, 5.2815673907E-01, 4.4925311959E-01, 6.4453799584E-01],
	[1.4025000000E+04, 6.5797301857E+00, 5.5402984288E+00, 5.2875100602E-01, 4.4969549580E-01, 6.4467377124E-01],
	[1.4030000000E+04, 6.5829241167E+00, 5.5399273401E+00, 5.2934572867E-01, 4.5013809361E-01, 6.4480952110E-01],
	[1.4035000000E+04, 6.5861184592E+00, 5.5395564084E+00, 5.2994090721E-01, 4.5058091294E-01, 6.4494524542E-01],
	[1.4040000000E+04, 6.5893132132E+00, 5.5391856337E+00, 5.3053654182E-01, 4.5102395372E-01, 6.4508094416E-01],
	[1.4045000000E+04, 6.5925083785E+00, 5.5388150158E+00, 5.3113263269E-01, 4.5146721587E-01, 6.4521661732E-01],
	[1.4050000000E+04, 6.5957039550E+00, 5.5384445545E+00, 5.3172918001E-01, 4.5191069931E-01, 6.4535226487E-01],
	[1.4055000000E+04, 6.5988999427E+00, 5.5380742499E+00, 5.3232618396E-01, 4.5235440396E-01, 6.4548788680E-01],
	[1.4060000000E+04, 6.6020963414E+00, 5.5377041018E+00, 5.3292364472E-01, 4.5279832976E-01, 6.4562348309E-01],
	[1.4065000000E+04, 6.6052931511E+00, 5.5373341099E+00, 5.3352156250E-01, 4.5324247663E-01, 6.4575905373E-01],
	[1.4070000000E+04, 6.6084903716E+00, 5.5369642743E+00, 5.3411993746E-01, 4.5368684449E-01, 6.4589459869E-01],
	[1.4075000000E+04, 6.6116880030E+00, 5.5365945948E+00, 5.3471876979E-01, 4.5413143325E-01, 6.4603011797E-01],
	[1.4080000000E+04, 6.6148860450E+00, 5.5362250712E+00, 5.3531805969E-01, 4.5457624286E-01, 6.4616561154E-01],
	[1.4085000000E+04, 6.6180844975E+00, 5.5358557035E+00, 5.3591780733E-01, 4.5502127322E-01, 6.4630107938E-01],
	[1.4090000000E+04, 6.6212833606E+00, 5.5354864915E+00, 5.3651801291E-01, 4.5546652427E-01, 6.4643652149E-01],
	[1.4095000000E+04, 6.6244826341E+00, 5.5351174351E+00, 5.3711867661E-01, 4.5591199593E-01, 6.4657193784E-01],
	[1.4100000000E+04, 6.6276823179E+00, 5.5347485342E+00, 5.3771979861E-01, 4.5635768811E-01, 6.4670732842E-01],
	[1.4105000000E+04, 6.6308824119E+00, 5.5343797887E+00, 5.3832137911E-01, 4.5680360074E-01, 6.4684269320E-01],
	[1.4110000000E+04, 6.6340829161E+00, 5.5340111984E+00, 5.3892341828E-01, 4.5724973375E-01, 6.4697803218E-01],
	[1.4115000000E+04, 6.6372838302E+00, 5.5336427633E+00, 5.3952591632E-01, 4.5769608706E-01, 6.4711334534E-01],
	[1.4120000000E+04, 6.6404870989E+00, 5.5332761722E+00, 5.4012887341E-01, 4.5814268142E-01, 6.4724863266E-01],
	[1.4125000000E+04, 6.6436968067E+00, 5.5329149684E+00, 5.4073228973E-01, 4.5858956066E-01, 6.4738389411E-01],
	[1.4130000000E+04, 6.6469069291E+00, 5.5325539160E+00, 5.4133616547E-01, 4.5903666023E-01, 6.4751912970E-01],
	[1.4135000000E+04, 6.6501174660E+00, 5.5321930149E+00, 5.4194050083E-01, 4.5948398007E-01, 6.4765433940E-01],
	[1.4140000000E+04, 6.6533284174E+00, 5.5318322650E+00, 5.4254529597E-01, 4.5993152009E-01, 6.4778952319E-01],
	[1.4145000000E+04, 6.6565397831E+00, 5.5314716661E+00, 5.4315055110E-01, 4.6037928020E-01, 6.4792468105E-01],
	[1.4150000000E+04, 6.6597515631E+00, 5.5311112182E+00, 5.4375626639E-01, 4.6082726035E-01, 6.4805981298E-01],
	[1.4155000000E+04, 6.6629637572E+00, 5.5307509210E+00, 5.4436244204E-01, 4.6127546044E-01, 6.4819491895E-01],
	[1.4160000000E+04, 6.6661763654E+00, 5.5303907746E+00, 5.4496907823E-01, 4.6172388040E-01, 6.4832999895E-01],
	[1.4165000000E+04, 6.6693893875E+00, 5.5300307788E+00, 5.4557617514E-01, 4.6217252014E-01, 6.4846505296E-01],
	[1.4170000000E+04, 6.6726028235E+00, 5.5296709334E+00, 5.4618373296E-01, 4.6262137960E-01, 6.4860008097E-01],
	[1.4175000000E+04, 6.6758166734E+00, 5.5293112384E+00, 5.4679175187E-01, 4.6307045869E-01, 6.4873508295E-01],
	[1.4180000000E+04, 6.6790309369E+00, 5.5289516936E+00, 5.4740023208E-01, 4.6351975734E-01, 6.4887005890E-01],
	[1.4185000000E+04, 6.6822456140E+00, 5.5285922989E+00, 5.4800917375E-01, 4.6396927546E-01, 6.4900500880E-01],
	[1.4190000000E+04, 6.6854607046E+00, 5.5282330543E+00, 5.4861857707E-01, 4.6441901297E-01, 6.4913993262E-01],
	[1.4195000000E+04, 6.6886762087E+00, 5.5278739596E+00, 5.4922844224E-01, 4.6486896980E-01, 6.4927483036E-01],
	[1.4200000000E+04, 6.6918921260E+00, 5.5275150146E+00, 5.4983876944E-01, 4.6531914587E-01, 6.4940970200E-01],
	[1.4205000000E+04, 6.6951084566E+00, 5.5271562193E+00, 5.5044955885E-01, 4.6576954109E-01, 6.4954454752E-01],
	[1.4210000000E+04, 6.6983252004E+00, 5.5267975735E+00, 5.5106081066E-01, 4.6622015539E-01, 6.4967936691E-01],
	[1.4215000000E+04, 6.7015423572E+00, 5.5264390772E+00, 5.5167252506E-01, 4.6667098869E-01, 6.4981416014E-01],
	[1.4220000000E+04, 6.7047599269E+00, 5.5260807302E+00, 5.5228470223E-01, 4.6712204091E-01, 6.4994892721E-01],
	[1.4225000000E+04, 6.7079779095E+00, 5.5257225323E+00, 5.5289734236E-01, 4.6757331196E-01, 6.5008366810E-01],
	[1.4230000000E+04, 6.7111963049E+00, 5.5253644836E+00, 5.5351044564E-01, 4.6802480177E-01, 6.5021838279E-01],
	[1.4235000000E+04, 6.7144151129E+00, 5.5250065839E+00, 5.5412401225E-01, 4.6847651025E-01, 6.5035307126E-01],
	[1.4240000000E+04, 6.7176343335E+00, 5.5246488330E+00, 5.5473804237E-01, 4.6892843733E-01, 6.5048773351E-01],
	[1.4245000000E+04, 6.7208539667E+00, 5.5242912308E+00, 5.5535253620E-01, 4.6938058293E-01, 6.5062236951E-01],
	[1.4250000000E+04, 6.7240740122E+00, 5.5239337773E+00, 5.5596749393E-01, 4.6983294696E-01, 6.5075697925E-01],
	[1.4255000000E+04, 6.7272944700E+00, 5.5235764723E+00, 5.5658291572E-01, 4.7028552934E-01, 6.5089156272E-01],
	[1.4260000000E+04, 6.7305153401E+00, 5.5232193157E+00, 5.5719880179E-01, 4.7073833000E-01, 6.5102611989E-01],
	[1.4265000000E+04, 6.7337366223E+00, 5.5228623074E+00, 5.5781515230E-01, 4.7119134884E-01, 6.5116065075E-01],
	[1.4270000000E+04, 6.7369583165E+00, 5.5225054473E+00, 5.5843196744E-01, 4.7164458580E-01, 6.5129515529E-01],
	[1.4275000000E+04, 6.7401804227E+00, 5.5221487352E+00, 5.5904924741E-01, 4.7209804078E-01, 6.5142963348E-01],
	[1.4280000000E+04, 6.7434029407E+00, 5.5217921711E+00, 5.5966699239E-01, 4.7255171371E-01, 6.5156408533E-01],
	[1.4285000000E+04, 6.7466258705E+00, 5.5214357548E+00, 5.6028520256E-01, 4.7300560451E-01, 6.5169851080E-01],
	[1.4290000000E+04, 6.7498492119E+00, 5.5210794863E+00, 5.6090387812E-01, 4.7345971308E-01, 6.5183290989E-01],
	[1.4295000000E+04, 6.7530729649E+00, 5.5207233654E+00, 5.6152301924E-01, 4.7391403936E-01, 6.5196728257E-01],
	[1.4300000000E+04, 6.7562971294E+00, 5.5203673919E+00, 5.6214262611E-01, 4.7436858325E-01, 6.5210162884E-01],
	[1.4305000000E+04, 6.7595217053E+00, 5.5200115658E+00, 5.6276269893E-01, 4.7482334468E-01, 6.5223594867E-01],
	[1.4310000000E+04, 6.7627466925E+00, 5.5196558871E+00, 5.6338323787E-01, 4.7527832357E-01, 6.5237024206E-01],
	[1.4315000000E+04, 6.7659720909E+00, 5.5193003554E+00, 5.6400424313E-01, 4.7573351982E-01, 6.5250450898E-01],
	[1.4320000000E+04, 6.7691979005E+00, 5.5189449709E+00, 5.6462571489E-01, 4.7618893336E-01, 6.5263874942E-01],
	[1.4325000000E+04, 6.7724241210E+00, 5.5185897332E+00, 5.6524765333E-01, 4.7664456411E-01, 6.5277296337E-01],
	[1.4330000000E+04, 6.7756507525E+00, 5.5182346424E+00, 5.6587005864E-01, 4.7710041197E-01, 6.5290715081E-01],
	[1.4335000000E+04, 6.7788777949E+00, 5.5178796983E+00, 5.6649293102E-01, 4.7755647688E-01, 6.5304131173E-01],
	[1.4340000000E+04, 6.7821052480E+00, 5.5175249008E+00, 5.6711627063E-01, 4.7801275874E-01, 6.5317544610E-01],
	[1.4345000000E+04, 6.7853331117E+00, 5.5171702498E+00, 5.6774007768E-01, 4.7846925748E-01, 6.5330955392E-01],
	[1.4350000000E+04, 6.7885679752E+00, 5.5168210700E+00, 5.6836435235E-01, 4.7892604592E-01, 6.5344363517E-01],
	[1.4355000000E+04, 6.7918050548E+00, 5.5164734890E+00, 5.6898909483E-01, 4.7938307127E-01, 6.5357768983E-01],
	[1.4360000000E+04, 6.7950425498E+00, 5.5161260510E+00, 5.6961430529E-01, 4.7984031352E-01, 6.5371171790E-01],
	[1.4365000000E+04, 6.7982804601E+00, 5.5157787558E+00, 5.7023998393E-01, 4.8029777260E-01, 6.5384571935E-01],
	[1.4370000000E+04, 6.8015187858E+00, 5.5154316033E+00, 5.7086613094E-01, 4.8075544842E-01, 6.5397969417E-01],
	[1.4375000000E+04, 6.8047575266E+00, 5.5150845935E+00, 5.7149274650E-01, 4.8121334090E-01, 6.5411364234E-01],
	[1.4380000000E+04, 6.8079966825E+00, 5.5147377261E+00, 5.7211983079E-01, 4.8167144995E-01, 6.5424756385E-01],
	[1.4385000000E+04, 6.8112362534E+00, 5.5143910011E+00, 5.7274738401E-01, 4.8212977550E-01, 6.5438145869E-01],
	[1.4390000000E+04, 6.8144762393E+00, 5.5140444184E+00, 5.7337540634E-01, 4.8258831745E-01, 6.5451532683E-01],
	[1.4395000000E+04, 6.8177166399E+00, 5.5136979779E+00, 5.7400389797E-01, 4.8304707573E-01, 6.5464916827E-01],
	[1.4400000000E+04, 6.8209574553E+00, 5.5133516795E+00, 5.7463285908E-01, 4.8350605024E-01, 6.5478298300E-01],
	[1.4405000000E+04, 6.8241986853E+00, 5.5130055230E+00, 5.7526228986E-01, 4.8396524091E-01, 6.5491677098E-01],
	[1.4410000000E+04, 6.8274403299E+00, 5.5126595083E+00, 5.7589219049E-01, 4.8442464764E-01, 6.5505053222E-01],
	[1.4415000000E+04, 6.8306823889E+00, 5.5123136354E+00, 5.7652256117E-01, 4.8488427036E-01, 6.5518426669E-01],
	[1.4420000000E+04, 6.8339248623E+00, 5.5119679042E+00, 5.7715340208E-01, 4.8534410897E-01, 6.5531797438E-01],
	[1.4425000000E+04, 6.8371677500E+00, 5.5116223145E+00, 5.7778471340E-01, 4.8580416340E-01, 6.5545165528E-01],
	[1.4430000000E+04, 6.8404110518E+00, 5.5112768662E+00, 5.7841649533E-01, 4.8626443356E-01, 6.5558530937E-01],
	[1.4435000000E+04, 6.8436547678E+00, 5.5109315592E+00, 5.7904874805E-01, 4.8672491936E-01, 6.5571893664E-01],
	[1.4440000000E+04, 6.8468988977E+00, 5.5105863934E+00, 5.7968147174E-01, 4.8718562072E-01, 6.5585253707E-01],
	[1.4445000000E+04, 6.8501434416E+00, 5.5102413687E+00, 5.8031466660E-01, 4.8764653755E-01, 6.5598611065E-01],
	[1.4450000000E+04, 6.8533883993E+00, 5.5098964851E+00, 5.8094833280E-01, 4.8810766976E-01, 6.5611965736E-01],
	[1.4455000000E+04, 6.8566337707E+00, 5.5095517423E+00, 5.8158247055E-01, 4.8856901728E-01, 6.5625317720E-01],
	[1.4460000000E+04, 6.8598795557E+00, 5.5092071403E+00, 5.8221708001E-01, 4.8903058000E-01, 6.5638667013E-01],
	[1.4465000000E+04, 6.8631257543E+00, 5.5088626790E+00, 5.8285216138E-01, 4.8949235786E-01, 6.5652013616E-01],
	[1.4470000000E+04, 6.8663723664E+00, 5.5085183582E+00, 5.8348771485E-01, 4.8995435075E-01, 6.5665357526E-01],
	[1.4475000000E+04, 6.8696193918E+00, 5.5081741780E+00, 5.8412374061E-01, 4.9041655860E-01, 6.5678698742E-01],
	[1.4480000000E+04, 6.8728668306E+00, 5.5078301381E+00, 5.8476023883E-01, 4.9087898132E-01, 6.5692037263E-01],
	[1.4485000000E+04, 6.8761146825E+00, 5.5074862384E+00, 5.8539720971E-01, 4.9134161882E-01, 6.5705373087E-01],
	[1.4490000000E+04, 6.8793629475E+00, 5.5071424789E+00, 5.8603465343E-01, 4.9180447101E-01, 6.5718706213E-01],
	[1.4495000000E+04, 6.8826116255E+00, 5.5067988594E+00, 5.8667257018E-01, 4.9226753781E-01, 6.5732036639E-01],
	[1.4500000000E+04, 6.8858607164E+00, 5.5064553799E+00, 5.8731096014E-01, 4.9273081912E-01, 6.5745364365E-01],
	[1.4505000000E+04, 6.8891102202E+00, 5.5061120402E+00, 5.8794982351E-01, 4.9319431487E-01, 6.5758689388E-01],
	[1.4510000000E+04, 6.8923601367E+00, 5.5057688402E+00, 5.8858916047E-01, 4.9365802497E-01, 6.5772011707E-01],
	[1.4515000000E+04, 6.8956104658E+00, 5.5054257799E+00, 5.8922897120E-01, 4.9412194932E-01, 6.5785331321E-01],
	[1.4520000000E+04, 6.8988612076E+00, 5.5050828591E+00, 5.8986925590E-01, 4.9458608785E-01, 6.5798648228E-01],
	[1.4525000000E+04, 6.9021123617E+00, 5.5047400777E+00, 5.9051001475E-01, 4.9505044045E-01, 6.5811962427E-01],
	[1.4530000000E+04, 6.9053639283E+00, 5.5043974356E+00, 5.9115124794E-01, 4.9551500705E-01, 6.5825273916E-01],
	[1.4535000000E+04, 6.9086159072E+00, 5.5040549327E+00, 5.9179295564E-01, 4.9597978755E-01, 6.5838582695E-01],
	[1.4540000000E+04, 6.9118682982E+00, 5.5037125689E+00, 5.9243513806E-01, 4.9644478187E-01, 6.5851888762E-01],
	[1.4545000000E+04, 6.9151211014E+00, 5.5033703441E+00, 5.9307779538E-01, 4.9690998992E-01, 6.5865192114E-01],
	[1.4550000000E+04, 6.9183743166E+00, 5.5030282582E+00, 5.9372092778E-01, 4.9737541162E-01, 6.5878492752E-01],
	[1.4555000000E+04, 6.9216279437E+00, 5.5026863111E+00, 5.9436453545E-01, 4.9784104686E-01, 6.5891790673E-01],
	[1.4560000000E+04, 6.9248819827E+00, 5.5023445027E+00, 5.9500861858E-01, 4.9830689556E-01, 6.5905085877E-01],
	[1.4565000000E+04, 6.9281364334E+00, 5.5020028328E+00, 5.9565317735E-01, 4.9877295764E-01, 6.5918378361E-01],
	[1.4570000000E+04, 6.9313912958E+00, 5.5016613014E+00, 5.9629821195E-01, 4.9923923301E-01, 6.5931668123E-01],
	[1.4575000000E+04, 6.9346465698E+00, 5.5013199084E+00, 5.9694372257E-01, 4.9970572157E-01, 6.5944955159E-01],
	[1.4580000000E+04, 6.9379074979E+00, 5.5009826047E+00, 5.9758970940E-01, 5.0017248315E-01, 6.5958239469E-01],
	[1.4585000000E+04, 6.9411724118E+00, 5.5006481272E+00, 5.9823617262E-01, 5.0063949879E-01, 6.5971521050E-01],
	[1.4590000000E+04, 6.9444377423E+00, 5.5003137846E+00, 5.9888311241E-01, 5.0110672766E-01, 6.5984799900E-01],
	[1.4595000000E+04, 6.9477034893E+00, 5.4999795770E+00, 5.9953052897E-01, 5.0157416968E-01, 6.5998076017E-01],
	[1.4600000000E+04, 6.9509696527E+00, 5.4996455041E+00, 6.0017842249E-01, 5.0204182475E-01, 6.6011349401E-01],
	[1.4605000000E+04, 6.9542362324E+00, 5.4993115659E+00, 6.0082679314E-01, 5.0250969279E-01, 6.6024620047E-01],
	[1.4610000000E+04, 6.9575032283E+00, 5.4989777622E+00, 6.0147564112E-01, 5.0297777370E-01, 6.6037887956E-01],
	[1.4615000000E+04, 6.9607706403E+00, 5.4986440931E+00, 6.0212496661E-01, 5.0344606740E-01, 6.6051153125E-01],
	[1.4620000000E+04, 6.9640384683E+00, 5.4983105582E+00, 6.0277476981E-01, 5.0391457380E-01, 6.6064415552E-01],
	[1.4625000000E+04, 6.9673067123E+00, 5.4979771577E+00, 6.0342505089E-01, 5.0438329280E-01, 6.6077675236E-01],
	[1.4630000000E+04, 6.9705753721E+00, 5.4976438913E+00, 6.0407581004E-01, 5.0485222432E-01, 6.6090932174E-01],
	[1.4635000000E+04, 6.9738444477E+00, 5.4973107590E+00, 6.0472704745E-01, 5.0532136826E-01, 6.6104186365E-01],
	[1.4640000000E+04, 6.9771139390E+00, 5.4969777607E+00, 6.0537876332E-01, 5.0579072454E-01, 6.6117437807E-01],
	[1.4645000000E+04, 6.9803838458E+00, 5.4966448963E+00, 6.0603095781E-01, 5.0626029306E-01, 6.6130686498E-01],
	[1.4650000000E+04, 6.9836541682E+00, 5.4963121656E+00, 6.0668363113E-01, 5.0673007374E-01, 6.6143932436E-01],
	[1.4655000000E+04, 6.9869249059E+00, 5.4959795686E+00, 6.0733678346E-01, 5.0720006648E-01, 6.6157175620E-01],
	[1.4660000000E+04, 6.9901960590E+00, 5.4956471051E+00, 6.0799041498E-01, 5.0767027119E-01, 6.6170416048E-01],
	[1.4665000000E+04, 6.9934676273E+00, 5.4953147751E+00, 6.0864452589E-01, 5.0814068778E-01, 6.6183653718E-01],
	[1.4670000000E+04, 6.9967396107E+00, 5.4949825785E+00, 6.0929911636E-01, 5.0861131617E-01, 6.6196888627E-01],
	[1.4675000000E+04, 7.0000120092E+00, 5.4946505152E+00, 6.0995418659E-01, 5.0908215625E-01, 6.6210120775E-01],
	[1.4680000000E+04, 7.0032848227E+00, 5.4943185851E+00, 6.1060973677E-01, 5.0955320794E-01, 6.6223350160E-01],
	[1.4685000000E+04, 7.0065580510E+00, 5.4939867880E+00, 6.1126576708E-01, 5.1002447114E-01, 6.6236576780E-01],
	[1.4690000000E+04, 7.0098316941E+00, 5.4936551239E+00, 6.1192227770E-01, 5.1049594577E-01, 6.6249800632E-01],
	[1.4695000000E+04, 7.0131057519E+00, 5.4933235927E+00, 6.1257926883E-01, 5.1096763173E-01, 6.6263021716E-01],
	[1.4700000000E+04, 7.0163802244E+00, 5.4929921943E+00, 6.1323674065E-01, 5.1143952894E-01, 6.6276240029E-01],
	[1.4705000000E+04, 7.0196551113E+00, 5.4926609286E+00, 6.1389469335E-01, 5.1191163729E-01, 6.6289455570E-01],
	[1.4710000000E+04, 7.0229304127E+00, 5.4923297954E+00, 6.1455312712E-01, 5.1238395669E-01, 6.6302668337E-01],
	[1.4715000000E+04, 7.0262061284E+00, 5.4919987947E+00, 6.1521204214E-01, 5.1285648706E-01, 6.6315878328E-01],
	[1.4720000000E+04, 7.0294822584E+00, 5.4916679264E+00, 6.1587143860E-01, 5.1332922830E-01, 6.6329085542E-01],
	[1.4725000000E+04, 7.0327588025E+00, 5.4913371905E+00, 6.1653131668E-01, 5.1380218032E-01, 6.6342289976E-01],
	[1.4730000000E+04, 7.0360357607E+00, 5.4910065867E+00, 6.1719167658E-01, 5.1427534302E-01, 6.6355491629E-01],
	[1.4735000000E+04, 7.0393131329E+00, 5.4906761150E+00, 6.1785251849E-01, 5.1474871632E-01, 6.6368690499E-01],
	[1.4740000000E+04, 7.0425909190E+00, 5.4903457753E+00, 6.1851384258E-01, 5.1522230012E-01, 6.6381886585E-01],
	[1.4745000000E+04, 7.0458691189E+00, 5.4900155675E+00, 6.1917564904E-01, 5.1569609432E-01, 6.6395079884E-01],
	[1.4750000000E+04, 7.0491477326E+00, 5.4896854915E+00, 6.1983793807E-01, 5.1617009884E-01, 6.6408270395E-01],
	[1.4755000000E+04, 7.0524267598E+00, 5.4893555472E+00, 6.2050070985E-01, 5.1664431357E-01, 6.6421458117E-01],
	[1.4760000000E+04, 7.0557062007E+00, 5.4890257345E+00, 6.2116396457E-01, 5.1711873844E-01, 6.6434643047E-01],
	[1.4765000000E+04, 7.0589860549E+00, 5.4886960533E+00, 6.2182770241E-01, 5.1759337333E-01, 6.6447825183E-01],
	[1.4770000000E+04, 7.0622663226E+00, 5.4883665036E+00, 6.2249192357E-01, 5.1806821817E-01, 6.6461004525E-01],
	[1.4775000000E+04, 7.0655470035E+00, 5.4880370851E+00, 6.2315662822E-01, 5.1854327285E-01, 6.6474181070E-01],
	[1.4780000000E+04, 7.0688280977E+00, 5.4877077979E+00, 6.2382181656E-01, 5.1901853728E-01, 6.6487354817E-01],
	[1.4785000000E+04, 7.0721096049E+00, 5.4873786418E+00, 6.2448748877E-01, 5.1949401136E-01, 6.6500525763E-01],
	[1.4790000000E+04, 7.0753915252E+00, 5.4870496168E+00, 6.2515364504E-01, 5.1996969501E-01, 6.6513693908E-01],
	[1.4795000000E+04, 7.0786738584E+00, 5.4867207226E+00, 6.2582028556E-01, 5.2044558813E-01, 6.6526859249E-01],
	[1.4800000000E+04, 7.0819566044E+00, 5.4863919594E+00, 6.2648741051E-01, 5.2092169062E-01, 6.6540021785E-01],
	[1.4805000000E+04, 7.0852397633E+00, 5.4860633268E+00, 6.2715502009E-01, 5.2139800240E-01, 6.6553181514E-01],
	[1.4810000000E+04, 7.0885233347E+00, 5.4857348249E+00, 6.2782311447E-01, 5.2187452335E-01, 6.6566338434E-01],
	[1.4815000000E+04, 7.0918134259E+00, 5.4854107526E+00, 6.2849169386E-01, 5.2235132551E-01, 6.6579492544E-01],
	[1.4820000000E+04, 7.0951070686E+00, 5.4850890148E+00, 6.2916075842E-01, 5.2282837395E-01, 6.6592643842E-01],
	[1.4825000000E+04, 7.0984011291E+00, 5.4847674044E+00, 6.2983030836E-01, 5.2330563160E-01, 6.6605792326E-01],
	[1.4830000000E+04, 7.1016956074E+00, 5.4844459213E+00, 6.3050034385E-01, 5.2378309839E-01, 6.6618937995E-01],
	[1.4835000000E+04, 7.1049905033E+00, 5.4841245654E+00, 6.3117086509E-01, 5.2426077420E-01, 6.6632080847E-01],
	[1.4840000000E+04, 7.1082858169E+00, 5.4838033366E+00, 6.3184187227E-01, 5.2473865895E-01, 6.6645220881E-01],
	[1.4845000000E+04, 7.1115815480E+00, 5.4834822349E+00, 6.3251336556E-01, 5.2521675255E-01, 6.6658358093E-01],
	[1.4850000000E+04, 7.1148776965E+00, 5.4831612600E+00, 6.3318534516E-01, 5.2569505489E-01, 6.6671492484E-01],
	[1.4855000000E+04, 7.1181742623E+00, 5.4828404120E+00, 6.3385781126E-01, 5.2617356588E-01, 6.6684624051E-01],
	[1.4860000000E+04, 7.1214712453E+00, 5.4825196907E+00, 6.3453076403E-01, 5.2665228543E-01, 6.6697752793E-01],
	[1.4865000000E+04, 7.1247686456E+00, 5.4821990961E+00, 6.3520420368E-01, 5.2713121343E-01, 6.6710878707E-01],
	[1.4870000000E+04, 7.1280664629E+00, 5.4818786280E+00, 6.3587813039E-01, 5.2761034980E-01, 6.6724001793E-01],
	[1.4875000000E+04, 7.1313646972E+00, 5.4815582864E+00, 6.3655254433E-01, 5.2808969444E-01, 6.6737122049E-01],
	[1.4880000000E+04, 7.1346633483E+00, 5.4812380712E+00, 6.3722744571E-01, 5.2856924725E-01, 6.6750239472E-01],
	[1.4885000000E+04, 7.1379624163E+00, 5.4809179822E+00, 6.3790283471E-01, 5.2904900813E-01, 6.6763354062E-01],
	[1.4890000000E+04, 7.1412619010E+00, 5.4805980195E+00, 6.3857871152E-01, 5.2952897700E-01, 6.6776465817E-01],
	[1.4895000000E+04, 7.1445618024E+00, 5.4802781828E+00, 6.3925507632E-01, 5.3000915375E-01, 6.6789574735E-01],
	[1.4900000000E+04, 7.1478621203E+00, 5.4799584721E+00, 6.3993192930E-01, 5.3048953828E-01, 6.6802680814E-01],
	[1.4905000000E+04, 7.1511628546E+00, 5.4796388873E+00, 6.4060927064E-01, 5.3097013050E-01, 6.6815784053E-01],
	[1.4910000000E+04, 7.1544640053E+00, 5.4793194284E+00, 6.4128710055E-01, 5.3145093031E-01, 6.6828884451E-01],
	[1.4915000000E+04, 7.1577655723E+00, 5.4790000952E+00, 6.4196541919E-01, 5.3193193762E-01, 6.6841982004E-01],
	[1.4920000000E+04, 7.1610675555E+00, 5.4786808876E+00, 6.4264422677E-01, 5.3241315233E-01, 6.6855076713E-01],
	[1.4925000000E+04, 7.1643699548E+00, 5.4783618055E+00, 6.4332352347E-01, 5.3289457434E-01, 6.6868168576E-01],
	[1.4930000000E+04, 7.1676727702E+00, 5.4780428489E+00, 6.4400330947E-01, 5.3337620356E-01, 6.6881257589E-01],
	[1.4935000000E+04, 7.1709760014E+00, 5.4777240177E+00, 6.4468358496E-01, 5.3385803988E-01, 6.6894343754E-01],
	[1.4940000000E+04, 7.1742796486E+00, 5.4774053117E+00, 6.4536435014E-01, 5.3434008320E-01, 6.6907427066E-01],
	[1.4945000000E+04, 7.1775837115E+00, 5.4770867309E+00, 6.4604560518E-01, 5.3482233344E-01, 6.6920507526E-01],
	[1.4950000000E+04, 7.1808881900E+00, 5.4767682752E+00, 6.4672735028E-01, 5.3530479050E-01, 6.6933585131E-01],
	[1.4955000000E+04, 7.1841930842E+00, 5.4764499445E+00, 6.4740958562E-01, 5.3578745427E-01, 6.6946659879E-01],
	[1.4960000000E+04, 7.1874983938E+00, 5.4761317387E+00, 6.4809231139E-01, 5.3627032465E-01, 6.6959731770E-01],
	[1.4965000000E+04, 7.1908041189E+00, 5.4758136577E+00, 6.4877552778E-01, 5.3675340155E-01, 6.6972800801E-01],
	[1.4970000000E+04, 7.1941102593E+00, 5.4754957015E+00, 6.4945923497E-01, 5.3723668488E-01, 6.6985866972E-01],
	[1.4975000000E+04, 7.1974168149E+00, 5.4751778698E+00, 6.5014343316E-01, 5.3772017453E-01, 6.6998930280E-01],
	[1.4980000000E+04, 7.2007237857E+00, 5.4748601627E+00, 6.5082812252E-01, 5.3820387040E-01, 6.7011990723E-01],
	[1.4985000000E+04, 7.2040311716E+00, 5.4745425801E+00, 6.5151330326E-01, 5.3868777239E-01, 6.7025048301E-01],
	[1.4990000000E+04, 7.2073389725E+00, 5.4742251218E+00, 6.5219897555E-01, 5.3917188041E-01, 6.7038103011E-01],
	[1.4995000000E+04, 7.2106471882E+00, 5.4739077878E+00, 6.5288513958E-01, 5.3965619436E-01, 6.7051154853E-01],
	[1.5000000000E+04, 7.2139558188E+00, 5.4735905780E+00, 6.5357179555E-01, 5.4014071414E-01, 6.7064203824E-01],
	[1.5005000000E+04, 7.2172648641E+00, 5.4732734923E+00, 6.5426097898E-01, 5.4062682938E-01, 6.7077249923E-01],
	[1.5010000000E+04, 7.2205743240E+00, 5.4729565305E+00, 6.5495065839E-01, 5.4111315190E-01, 6.7090293149E-01],
	[1.5015000000E+04, 7.2238841985E+00, 5.4726396927E+00, 6.5564083396E-01, 5.4159968160E-01, 6.7103333499E-01],
	[1.5020000000E+04, 7.2271944874E+00, 5.4723229787E+00, 6.5633150588E-01, 5.4208641836E-01, 6.7116370973E-01],
	[1.5025000000E+04, 7.2305051907E+00, 5.4720063885E+00, 6.5702267434E-01, 5.4257336211E-01, 6.7129405568E-01],
	[1.5030000000E+04, 7.2338163083E+00, 5.4716899219E+00, 6.5771433954E-01, 5.4306051272E-01, 6.7142437284E-01],
	[1.5035000000E+04, 7.2371278402E+00, 5.4713735788E+00, 6.5840650166E-01, 5.4354787011E-01, 6.7155466118E-01],
	[1.5040000000E+04, 7.2404397861E+00, 5.4710573592E+00, 6.5909916090E-01, 5.4403543417E-01, 6.7168492070E-01],
	[1.5045000000E+04, 7.2437521461E+00, 5.4707412630E+00, 6.5979231744E-01, 5.4452320481E-01, 6.7181515137E-01],
	[1.5050000000E+04, 7.2470649200E+00, 5.4704252900E+00, 6.6048597147E-01, 5.4501118192E-01, 6.7194535318E-01],
	[1.5055000000E+04, 7.2503875178E+00, 5.4701156344E+00, 6.6118012319E-01, 5.4549948026E-01, 6.7207552612E-01],
	[1.5060000000E+04, 7.2537108138E+00, 5.4698062827E+00, 6.6187477279E-01, 5.4598798861E-01, 6.7220567017E-01],
	[1.5065000000E+04, 7.2570345292E+00, 5.4694970511E+00, 6.6256992046E-01, 5.4647670347E-01, 6.7233578532E-01],
	[1.5070000000E+04, 7.2603586639E+00, 5.4691879396E+00, 6.6326556639E-01, 5.4696562475E-01, 6.7246587154E-01],
	[1.5075000000E+04, 7.2636832177E+00, 5.4688789482E+00, 6.6396171077E-01, 5.4745475233E-01, 6.7259592883E-01],
	[1.5080000000E+04, 7.2670081906E+00, 5.4685700766E+00, 6.6465835378E-01, 5.4794408612E-01, 6.7272595717E-01],
	[1.5085000000E+04, 7.2703335825E+00, 5.4682613249E+00, 6.6535549563E-01, 5.4843362602E-01, 6.7285595654E-01],
	[1.5090000000E+04, 7.2736593933E+00, 5.4679526929E+00, 6.6605313650E-01, 5.4892337192E-01, 6.7298592694E-01],
	[1.5095000000E+04, 7.2769856229E+00, 5.4676441806E+00, 6.6675127659E-01, 5.4941332373E-01, 6.7311586833E-01],
	[1.5100000000E+04, 7.2803122713E+00, 5.4673357879E+00, 6.6744991607E-01, 5.4990348134E-01, 6.7324578072E-01],
	[1.5105000000E+04, 7.2836393383E+00, 5.4670275146E+00, 6.6814905515E-01, 5.5039384464E-01, 6.7337566409E-01],
	[1.5110000000E+04, 7.2869668239E+00, 5.4667193608E+00, 6.6884869402E-01, 5.5088441355E-01, 6.7350551841E-01],
	[1.5115000000E+04, 7.2902947280E+00, 5.4664113262E+00, 6.6954883286E-01, 5.5137518796E-01, 6.7363534368E-01],
	[1.5120000000E+04, 7.2936230505E+00, 5.4661034109E+00, 6.7024947187E-01, 5.5186616776E-01, 6.7376513987E-01],
	[1.5125000000E+04, 7.2969517913E+00, 5.4657956147E+00, 6.7095061123E-01, 5.5235735285E-01, 6.7389490699E-01],
	[1.5130000000E+04, 7.3002809503E+00, 5.4654879376E+00, 6.7165225115E-01, 5.5284874314E-01, 6.7402464500E-01],
	[1.5135000000E+04, 7.3036105275E+00, 5.4651803795E+00, 6.7235439180E-01, 5.5334033851E-01, 6.7415435390E-01],
	[1.5140000000E+04, 7.3069405227E+00, 5.4648729402E+00, 6.7305703338E-01, 5.5383213887E-01, 6.7428403367E-01],
	[1.5145000000E+04, 7.3102709358E+00, 5.4645656198E+00, 6.7376017609E-01, 5.5432414411E-01, 6.7441368430E-01],
	[1.5150000000E+04, 7.3136017669E+00, 5.4642584180E+00, 6.7446382011E-01, 5.5481635413E-01, 6.7454330577E-01],
	[1.5155000000E+04, 7.3169330157E+00, 5.4639513349E+00, 6.7516796562E-01, 5.5530876883E-01, 6.7467289807E-01],
	[1.5160000000E+04, 7.3202646823E+00, 5.4636443703E+00, 6.7587261284E-01, 5.5580138811E-01, 6.7480246118E-01],
	[1.5165000000E+04, 7.3235967665E+00, 5.4633375242E+00, 6.7657776193E-01, 5.5629421186E-01, 6.7493199509E-01],
	[1.5170000000E+04, 7.3269292682E+00, 5.4630307965E+00, 6.7728341311E-01, 5.5678723997E-01, 6.7506149978E-01],
	[1.5175000000E+04, 7.3302621874E+00, 5.4627241871E+00, 6.7798956654E-01, 5.5728047235E-01, 6.7519097524E-01],
	[1.5180000000E+04, 7.3335955239E+00, 5.4624176959E+00, 6.7869622244E-01, 5.5777390889E-01, 6.7532042146E-01],
	[1.5185000000E+04, 7.3369292778E+00, 5.4621113228E+00, 6.7940338098E-01, 5.5826754949E-01, 6.7544983841E-01],
	[1.5190000000E+04, 7.3402634488E+00, 5.4618050677E+00, 6.8011104237E-01, 5.5876139405E-01, 6.7557922610E-01],
	[1.5195000000E+04, 7.3435980369E+00, 5.4614989306E+00, 6.8081920678E-01, 5.5925544245E-01, 6.7570858449E-01],
	[1.5200000000E+04, 7.3469330421E+00, 5.4611929114E+00, 6.8152787442E-01, 5.5974969460E-01, 6.7583791358E-01],
	[1.5205000000E+04, 7.3502684642E+00, 5.4608870099E+00, 6.8223704546E-01, 5.6024415039E-01, 6.7596721336E-01],
	[1.5210000000E+04, 7.3536043032E+00, 5.4605812262E+00, 6.8294672011E-01, 5.6073880972E-01, 6.7609648380E-01],
	[1.5215000000E+04, 7.3569405590E+00, 5.4602755600E+00, 6.8365689856E-01, 5.6123367249E-01, 6.7622572490E-01],
	[1.5220000000E+04, 7.3602772314E+00, 5.4599700114E+00, 6.8436758099E-01, 5.6172873858E-01, 6.7635493664E-01],
	[1.5225000000E+04, 7.3636143205E+00, 5.4596645803E+00, 6.8507876759E-01, 5.6222400790E-01, 6.7648411900E-01],
	[1.5230000000E+04, 7.3669518260E+00, 5.4593592665E+00, 6.8579045856E-01, 5.6271948034E-01, 6.7661327198E-01],
	[1.5235000000E+04, 7.3702897480E+00, 5.4590540700E+00, 6.8650265409E-01, 5.6321515579E-01, 6.7674239556E-01],
	[1.5240000000E+04, 7.3736280864E+00, 5.4587489907E+00, 6.8721535437E-01, 5.6371103416E-01, 6.7687148972E-01],
	[1.5245000000E+04, 7.3769668410E+00, 5.4584440286E+00, 6.8792855959E-01, 5.6420711533E-01, 6.7700055445E-01],
	[1.5250000000E+04, 7.3803060118E+00, 5.4581391834E+00, 6.8864226994E-01, 5.6470339920E-01, 6.7712958974E-01],
	[1.5255000000E+04, 7.3836455987E+00, 5.4578344552E+00, 6.8935648562E-01, 5.6519988566E-01, 6.7725859556E-01],
	[1.5260000000E+04, 7.3869856016E+00, 5.4575298439E+00, 6.9007120680E-01, 5.6569657462E-01, 6.7738757192E-01],
	[1.5265000000E+04, 7.3903260204E+00, 5.4572253493E+00, 6.9078643369E-01, 5.6619346596E-01, 6.7751651879E-01],
	[1.5270000000E+04, 7.3936668551E+00, 5.4569209715E+00, 6.9150216648E-01, 5.6669055957E-01, 6.7764543617E-01],
	[1.5275000000E+04, 7.3970081055E+00, 5.4566167103E+00, 6.9221840535E-01, 5.6718785536E-01, 6.7777432403E-01],
	[1.5280000000E+04, 7.4003497716E+00, 5.4563125656E+00, 6.9293515051E-01, 5.6768535322E-01, 6.7790318236E-01],
	[1.5285000000E+04, 7.4036918533E+00, 5.4560085373E+00, 6.9365240213E-01, 5.6818305303E-01, 6.7803201115E-01],
	[1.5290000000E+04, 7.4070343505E+00, 5.4557046254E+00, 6.9437016041E-01, 5.6868095470E-01, 6.7816081039E-01],
	[1.5295000000E+04, 7.4103824875E+00, 5.4554040491E+00, 6.9508842554E-01, 5.6917912399E-01, 6.7828958005E-01],
	[1.5300000000E+04, 7.4137359872E+00, 5.4551066328E+00, 6.9580719771E-01, 5.6967755750E-01, 6.7841832014E-01],
	[1.5305000000E+04, 7.4170899080E+00, 5.4548093298E+00, 6.9652647712E-01, 5.7017619291E-01, 6.7854703063E-01],
	[1.5310000000E+04, 7.4204442499E+00, 5.4545121401E+00, 6.9724626395E-01, 5.7067503011E-01, 6.7867571152E-01],
	[1.5315000000E+04, 7.4237990127E+00, 5.4542150636E+00, 6.9796655840E-01, 5.7117406900E-01, 6.7880436278E-01],
	[1.5320000000E+04, 7.4271541964E+00, 5.4539181003E+00, 6.9868736065E-01, 5.7167330946E-01, 6.7893298440E-01],
	[1.5325000000E+04, 7.4305098008E+00, 5.4536212501E+00, 6.9940867090E-01, 5.7217275139E-01, 6.7906157637E-01],
	[1.5330000000E+04, 7.4338658260E+00, 5.4533245128E+00, 7.0013048934E-01, 5.7267239469E-01, 6.7919013868E-01],
	[1.5335000000E+04, 7.4372222717E+00, 5.4530278885E+00, 7.0085281617E-01, 5.7317223925E-01, 6.7931867132E-01],
	[1.5340000000E+04, 7.4405791380E+00, 5.4527313769E+00, 7.0157565156E-01, 5.7367228495E-01, 6.7944717426E-01],
	[1.5345000000E+04, 7.4439364247E+00, 5.4524349782E+00, 7.0229899572E-01, 5.7417253170E-01, 6.7957564751E-01],
	[1.5350000000E+04, 7.4472941317E+00, 5.4521386921E+00, 7.0302284883E-01, 5.7467297939E-01, 6.7970409103E-01],
	[1.5355000000E+04, 7.4506522591E+00, 5.4518425185E+00, 7.0374721109E-01, 5.7517362791E-01, 6.7983250483E-01],
	[1.5360000000E+04, 7.4540108066E+00, 5.4515464575E+00, 7.0447208268E-01, 5.7567447715E-01, 6.7996088888E-01],
	[1.5365000000E+04, 7.4573697742E+00, 5.4512505089E+00, 7.0519746380E-01, 5.7617552701E-01, 6.8008924317E-01],
	[1.5370000000E+04, 7.4607291619E+00, 5.4509546727E+00, 7.0592335464E-01, 5.7667677737E-01, 6.8021756770E-01],
	[1.5375000000E+04, 7.4640889694E+00, 5.4506589487E+00, 7.0664975540E-01, 5.7717822814E-01, 6.8034586244E-01],
	[1.5380000000E+04, 7.4674491968E+00, 5.4503633369E+00, 7.0737666625E-01, 5.7767987919E-01, 6.8047412739E-01],
	[1.5385000000E+04, 7.4708098440E+00, 5.4500678372E+00, 7.0810408740E-01, 5.7818173043E-01, 6.8060236253E-01],
	[1.5390000000E+04, 7.4741709109E+00, 5.4497724496E+00, 7.0883201903E-01, 5.7868378175E-01, 6.8073056784E-01],
	[1.5395000000E+04, 7.4775323974E+00, 5.4494771739E+00, 7.0956046133E-01, 5.7918603304E-01, 6.8085874333E-01],
	[1.5400000000E+04, 7.4808943033E+00, 5.4491820101E+00, 7.1028941451E-01, 5.7968848419E-01, 6.8098688896E-01],
	[1.5405000000E+04, 7.4842566287E+00, 5.4488869581E+00, 7.1101887874E-01, 5.8019113508E-01, 6.8111500473E-01],
	[1.5410000000E+04, 7.4876193735E+00, 5.4485920178E+00, 7.1174885422E-01, 5.8069398563E-01, 6.8124309063E-01],
	[1.5415000000E+04, 7.4909825375E+00, 5.4482971891E+00, 7.1247934115E-01, 5.8119703570E-01, 6.8137114664E-01],
	[1.5420000000E+04, 7.4943461207E+00, 5.4480024720E+00, 7.1321033970E-01, 5.8170028521E-01, 6.8149917275E-01],
	[1.5425000000E+04, 7.4977101230E+00, 5.4477078664E+00, 7.1394185008E-01, 5.8220373403E-01, 6.8162716895E-01],
	[1.5430000000E+04, 7.5010745443E+00, 5.4474133722E+00, 7.1467387248E-01, 5.8270738206E-01, 6.8175513522E-01],
	[1.5435000000E+04, 7.5044393845E+00, 5.4471189893E+00, 7.1540640708E-01, 5.8321122919E-01, 6.8188307155E-01],
	[1.5440000000E+04, 7.5078046436E+00, 5.4468247177E+00, 7.1613945408E-01, 5.8371527531E-01, 6.8201097794E-01],
	[1.5445000000E+04, 7.5111703214E+00, 5.4465305572E+00, 7.1687301366E-01, 5.8421952031E-01, 6.8213885436E-01],
	[1.5450000000E+04, 7.5145364179E+00, 5.4462365078E+00, 7.1760708603E-01, 5.8472396408E-01, 6.8226670080E-01],
	[1.5455000000E+04, 7.5179029330E+00, 5.4459425695E+00, 7.1834167137E-01, 5.8522860651E-01, 6.8239451724E-01],
	[1.5460000000E+04, 7.5212698666E+00, 5.4456487420E+00, 7.1907676988E-01, 5.8573344750E-01, 6.8252230365E-01],
	[1.5465000000E+04, 7.5246372187E+00, 5.4453550255E+00, 7.1981238174E-01, 5.8623848693E-01, 6.8265006004E-01],
	[1.5470000000E+04, 7.5280049890E+00, 5.4450614197E+00, 7.2054850715E-01, 5.8674372469E-01, 6.8277778637E-01],
	[1.5475000000E+04, 7.5313731777E+00, 5.4447679246E+00, 7.2128514629E-01, 5.8724916068E-01, 6.8290548263E-01],
	[1.5480000000E+04, 7.5347417845E+00, 5.4444745401E+00, 7.2202229937E-01, 5.8775479478E-01, 6.8303314881E-01],
	[1.5485000000E+04, 7.5381108094E+00, 5.4441812662E+00, 7.2275996656E-01, 5.8826062688E-01, 6.8316078489E-01],
	[1.5490000000E+04, 7.5414802523E+00, 5.4438881028E+00, 7.2349814807E-01, 5.8876665688E-01, 6.8328839086E-01],
	[1.5495000000E+04, 7.5448501132E+00, 5.4435950497E+00, 7.2423684408E-01, 5.8927288466E-01, 6.8341596669E-01],
	[1.5500000000E+04, 7.5482203918E+00, 5.4433021070E+00, 7.2497605479E-01, 5.8977931011E-01, 6.8354351238E-01],
	[1.5505000000E+04, 7.5515910883E+00, 5.4430092745E+00, 7.2571578038E-01, 5.9028593312E-01, 6.8367102790E-01],
	[1.5510000000E+04, 7.5549622024E+00, 5.4427165522E+00, 7.2645602105E-01, 5.9079275358E-01, 6.8379851325E-01],
	[1.5515000000E+04, 7.5583337341E+00, 5.4424239399E+00, 7.2719677699E-01, 5.9129977138E-01, 6.8392596840E-01],
	[1.5520000000E+04, 7.5617056834E+00, 5.4421314377E+00, 7.2793804839E-01, 5.9180698641E-01, 6.8405339334E-01],
	[1.5525000000E+04, 7.5650780500E+00, 5.4418390454E+00, 7.2867983545E-01, 5.9231439855E-01, 6.8418078806E-01],
	[1.5530000000E+04, 7.5684508341E+00, 5.4415467630E+00, 7.2942213835E-01, 5.9282200770E-01, 6.8430815254E-01],
	[1.5535000000E+04, 7.5718240353E+00, 5.4412545903E+00, 7.3016495729E-01, 5.9332981375E-01, 6.8443548676E-01],
	[1.5540000000E+04, 7.5752005989E+00, 5.4409642287E+00, 7.3090829245E-01, 5.9383785495E-01, 6.8456279071E-01],
	[1.5545000000E+04, 7.5785852945E+00, 5.4406784296E+00, 7.3165214404E-01, 5.9434619351E-01, 6.8469006437E-01],
	[1.5550000000E+04, 7.5819704132E+00, 5.4403927374E+00, 7.3239651223E-01, 5.9485472901E-01, 6.8481730774E-01],
	[1.5555000000E+04, 7.5853559549E+00, 5.4401071521E+00, 7.3314139723E-01, 5.9536346134E-01, 6.8494452078E-01],
	[1.5560000000E+04, 7.5887419195E+00, 5.4398216736E+00, 7.3388679922E-01, 5.9587239039E-01, 6.8507170349E-01],
	[1.5565000000E+04, 7.5921283070E+00, 5.4395363017E+00, 7.3463271839E-01, 5.9638151604E-01, 6.8519885585E-01],
	[1.5570000000E+04, 7.5955151172E+00, 5.4392510365E+00, 7.3537915495E-01, 5.9689083819E-01, 6.8532597785E-01],
	[1.5575000000E+04, 7.5989023501E+00, 5.4389658778E+00, 7.3612610907E-01, 5.9740035673E-01, 6.8545306947E-01],
	[1.5580000000E+04, 7.6022900056E+00, 5.4386808256E+00, 7.3687358095E-01, 5.9791007153E-01, 6.8558013070E-01],
	[1.5585000000E+04, 7.6056780836E+00, 5.4383958797E+00, 7.3762157079E-01, 5.9841998250E-01, 6.8570716152E-01],
	[1.5590000000E+04, 7.6090665840E+00, 5.4381110402E+00, 7.3837007877E-01, 5.9893008951E-01, 6.8583416191E-01],
	[1.5595000000E+04, 7.6124555068E+00, 5.4378263070E+00, 7.3911910508E-01, 5.9944039246E-01, 6.8596113187E-01],
	[1.5600000000E+04, 7.6158448519E+00, 5.4375416799E+00, 7.3986864992E-01, 5.9995089123E-01, 6.8608807137E-01],
	[1.5605000000E+04, 7.6192346191E+00, 5.4372571589E+00, 7.4061871348E-01, 6.0046158571E-01, 6.8621498040E-01],
	[1.5610000000E+04, 7.6226248084E+00, 5.4369727440E+00, 7.4136929595E-01, 6.0097247579E-01, 6.8634185895E-01],
	[1.5615000000E+04, 7.6260154198E+00, 5.4366884350E+00, 7.4212039753E-01, 6.0148356135E-01, 6.8646870700E-01],
	[1.5620000000E+04, 7.6294064530E+00, 5.4364042319E+00, 7.4287201839E-01, 6.0199484229E-01, 6.8659552454E-01],
	[1.5625000000E+04, 7.6327979082E+00, 5.4361201346E+00, 7.4362415875E-01, 6.0250631848E-01, 6.8672231154E-01],
	[1.5630000000E+04, 7.6361897851E+00, 5.4358361430E+00, 7.4437681878E-01, 6.0301798983E-01, 6.8684906801E-01],
	[1.5635000000E+04, 7.6395820836E+00, 5.4355522572E+00, 7.4512999868E-01, 6.0352985621E-01, 6.8697579392E-01],
	[1.5640000000E+04, 7.6429748038E+00, 5.4352684768E+00, 7.4588369864E-01, 6.0404191751E-01, 6.8710248925E-01],
	[1.5645000000E+04, 7.6463679455E+00, 5.4349848021E+00, 7.4663791885E-01, 6.0455417361E-01, 6.8722915400E-01],
	[1.5650000000E+04, 7.6497615087E+00, 5.4347012327E+00, 7.4739265950E-01, 6.0506662441E-01, 6.8735578814E-01],
	[1.5655000000E+04, 7.6531554932E+00, 5.4344177687E+00, 7.4814792080E-01, 6.0557926980E-01, 6.8748239167E-01],
	[1.5660000000E+04, 7.6565498989E+00, 5.4341344101E+00, 7.4890370292E-01, 6.0609210964E-01, 6.8760896456E-01],
	[1.5665000000E+04, 7.6599447259E+00, 5.4338511566E+00, 7.4966000606E-01, 6.0660514385E-01, 6.8773550681E-01],
	[1.5670000000E+04, 7.6633399740E+00, 5.4335680083E+00, 7.5041683041E-01, 6.0711837229E-01, 6.8786201840E-01],
	[1.5675000000E+04, 7.6667356431E+00, 5.4332849651E+00, 7.5117417617E-01, 6.0763179486E-01, 6.8798849931E-01],
	[1.5680000000E+04, 7.6701317331E+00, 5.4330020269E+00, 7.5193204352E-01, 6.0814541144E-01, 6.8811494954E-01],
	[1.5685000000E+04, 7.6735282440E+00, 5.4327191936E+00, 7.5269043265E-01, 6.0865922191E-01, 6.8824136906E-01],
	[1.5690000000E+04, 7.6769251757E+00, 5.4324364652E+00, 7.5344934377E-01, 6.0917322617E-01, 6.8836775786E-01],
	[1.5695000000E+04, 7.6803225281E+00, 5.4321538416E+00, 7.5420877705E-01, 6.0968742410E-01, 6.8849411593E-01],
	[1.5700000000E+04, 7.6837203011E+00, 5.4318713227E+00, 7.5496873270E-01, 6.1020181558E-01, 6.8862044325E-01],
	[1.5705000000E+04, 7.6871184946E+00, 5.4315889084E+00, 7.5572921091E-01, 6.1071640051E-01, 6.8874673982E-01],
	[1.5710000000E+04, 7.6905171086E+00, 5.4313065987E+00, 7.5649021185E-01, 6.1123117875E-01, 6.8887300560E-01],
	[1.5715000000E+04, 7.6939161430E+00, 5.4310243935E+00, 7.5725173574E-01, 6.1174615021E-01, 6.8899924060E-01],
	[1.5720000000E+04, 7.6973155977E+00, 5.4307422928E+00, 7.5801378276E-01, 6.1226131477E-01, 6.8912544479E-01],
	[1.5725000000E+04, 7.7007154725E+00, 5.4304602964E+00, 7.5877635310E-01, 6.1277667230E-01, 6.8925161816E-01],
	[1.5730000000E+04, 7.7041157675E+00, 5.4301784043E+00, 7.5953944695E-01, 6.1329222270E-01, 6.8937776071E-01],
	[1.5735000000E+04, 7.7075164825E+00, 5.4298966164E+00, 7.6030306451E-01, 6.1380796585E-01, 6.8950387240E-01],
	[1.5740000000E+04, 7.7109176175E+00, 5.4296149326E+00, 7.6106720596E-01, 6.1432390163E-01, 6.8962995324E-01],
	[1.5745000000E+04, 7.7143191724E+00, 5.4293333530E+00, 7.6183187151E-01, 6.1484002993E-01, 6.8975600320E-01],
	[1.5750000000E+04, 7.7177211471E+00, 5.4290518773E+00, 7.6259706133E-01, 6.1535635064E-01, 6.8988202227E-01],
	[1.5755000000E+04, 7.7211235415E+00, 5.4287705055E+00, 7.6336277563E-01, 6.1587286363E-01, 6.9000801044E-01],
	[1.5760000000E+04, 7.7245263555E+00, 5.4284892377E+00, 7.6412901460E-01, 6.1638956880E-01, 6.9013396770E-01],
	[1.5765000000E+04, 7.7279295891E+00, 5.4282080735E+00, 7.6489577842E-01, 6.1690646602E-01, 6.9025989402E-01],
	[1.5770000000E+04, 7.7313332422E+00, 5.4279270132E+00, 7.6566306729E-01, 6.1742355518E-01, 6.9038578941E-01],
	[1.5775000000E+04, 7.7347373146E+00, 5.4276460564E+00, 7.6643088140E-01, 6.1794083617E-01, 6.9051165383E-01],
	[1.5780000000E+04, 7.7381418064E+00, 5.4273652032E+00, 7.6719922095E-01, 6.1845830886E-01, 6.9063748728E-01],
	[1.5785000000E+04, 7.7415467174E+00, 5.4270844536E+00, 7.6796808612E-01, 6.1897597315E-01, 6.9076328975E-01],
	[1.5790000000E+04, 7.7449547938E+00, 5.4268052969E+00, 7.6873747710E-01, 6.1949386589E-01, 6.9088906122E-01],
	[1.5795000000E+04, 7.7483716989E+00, 5.4265308012E+00, 7.6950739410E-01, 6.2001206343E-01, 6.9101480167E-01],
	[1.5800000000E+04, 7.7517890293E+00, 5.4262564063E+00, 7.7027783730E-01, 6.2053045261E-01, 6.9114051110E-01],
	[1.5805000000E+04, 7.7552067849E+00, 5.4259821120E+00, 7.7104880689E-01, 6.2104903332E-01, 6.9126618949E-01],
	[1.5810000000E+04, 7.7586249657E+00, 5.4257079184E+00, 7.7182030306E-01, 6.2156780544E-01, 6.9139183683E-01],
	[1.5815000000E+04, 7.7620435714E+00, 5.4254338253E+00, 7.7259232602E-01, 6.2208676886E-01, 6.9151745310E-01],
	[1.5820000000E+04, 7.7654626021E+00, 5.4251598327E+00, 7.7336487594E-01, 6.2260592344E-01, 6.9164303829E-01],
	[1.5825000000E+04, 7.7688820577E+00, 5.4248859405E+00, 7.7413795302E-01, 6.2312526909E-01, 6.9176859239E-01],
	[1.5830000000E+04, 7.7723019381E+00, 5.4246121487E+00, 7.7491155746E-01, 6.2364480569E-01, 6.9189411538E-01],
	[1.5835000000E+04, 7.7757222431E+00, 5.4243384571E+00, 7.7568568944E-01, 6.2416453311E-01, 6.9201960725E-01],
	[1.5840000000E+04, 7.7791429728E+00, 5.4240648658E+00, 7.7646034916E-01, 6.2468445124E-01, 6.9214506798E-01],
	[1.5845000000E+04, 7.7825641271E+00, 5.4237913746E+00, 7.7723553681E-01, 6.2520455996E-01, 6.9227049757E-01],
	[1.5850000000E+04, 7.7859857058E+00, 5.4235179834E+00, 7.7801125258E-01, 6.2572485916E-01, 6.9239589600E-01],
	[1.5855000000E+04, 7.7894077089E+00, 5.4232446923E+00, 7.7878749667E-01, 6.2624534871E-01, 6.9252126325E-01],
	[1.5860000000E+04, 7.7928301362E+00, 5.4229715011E+00, 7.7956426926E-01, 6.2676602851E-01, 6.9264659932E-01],
	[1.5865000000E+04, 7.7962529878E+00, 5.4226984097E+00, 7.8034157055E-01, 6.2728689843E-01, 6.9277190418E-01],
	[1.5870000000E+04, 7.7996762636E+00, 5.4224254182E+00, 7.8111940073E-01, 6.2780795835E-01, 6.9289717784E-01],
	[1.5875000000E+04, 7.8030999634E+00, 5.4221525264E+00, 7.8189775999E-01, 6.2832920816E-01, 6.9302242026E-01],
	[1.5880000000E+04, 7.8065240872E+00, 5.4218797343E+00, 7.8267664852E-01, 6.2885064775E-01, 6.9314763145E-01],
	[1.5885000000E+04, 7.8099486348E+00, 5.4216070417E+00, 7.8345606653E-01, 6.2937227698E-01, 6.9327281138E-01],
	[1.5890000000E+04, 7.8133736063E+00, 5.4213344487E+00, 7.8423601419E-01, 6.2989409575E-01, 6.9339796005E-01],
	[1.5895000000E+04, 7.8167990015E+00, 5.4210619552E+00, 7.8501649170E-01, 6.3041610393E-01, 6.9352307744E-01],
	[1.5900000000E+04, 7.8202248204E+00, 5.4207895610E+00, 7.8579749926E-01, 6.3093830142E-01, 6.9364816354E-01],
	[1.5905000000E+04, 7.8236510629E+00, 5.4205172662E+00, 7.8657903705E-01, 6.3146068808E-01, 6.9377321834E-01],
	[1.5910000000E+04, 7.8270777288E+00, 5.4202450706E+00, 7.8736110527E-01, 6.3198326380E-01, 6.9389824181E-01],
	[1.5915000000E+04, 7.8305048181E+00, 5.4199729742E+00, 7.8814370411E-01, 6.3250602847E-01, 6.9402323396E-01],
	[1.5920000000E+04, 7.8339323308E+00, 5.4197009769E+00, 7.8892683376E-01, 6.3302898195E-01, 6.9414819477E-01],
	[1.5925000000E+04, 7.8373602667E+00, 5.4194290787E+00, 7.8971049442E-01, 6.3355212415E-01, 6.9427312421E-01],
	[1.5930000000E+04, 7.8407886258E+00, 5.4191572795E+00, 7.9049468627E-01, 6.3407545493E-01, 6.9439802229E-01],
	[1.5935000000E+04, 7.8442174080E+00, 5.4188855792E+00, 7.9127940951E-01, 6.3459897417E-01, 6.9452288899E-01],
	[1.5940000000E+04, 7.8476466132E+00, 5.4186139778E+00, 7.9206466433E-01, 6.3512268177E-01, 6.9464772430E-01],
	[1.5945000000E+04, 7.8510762413E+00, 5.4183424751E+00, 7.9285045093E-01, 6.3564657759E-01, 6.9477252819E-01],
	[1.5950000000E+04, 7.8545062923E+00, 5.4180710712E+00, 7.9363676949E-01, 6.3617066152E-01, 6.9489730067E-01],
	[1.5955000000E+04, 7.8579367660E+00, 5.4177997659E+00, 7.9442362021E-01, 6.3669493345E-01, 6.9502204172E-01],
	[1.5960000000E+04, 7.8613676624E+00, 5.4175285592E+00, 7.9521100328E-01, 6.3721939324E-01, 6.9514675132E-01],
	[1.5965000000E+04, 7.8647989814E+00, 5.4172574511E+00, 7.9599891889E-01, 6.3774404079E-01, 6.9527142947E-01],
	[1.5970000000E+04, 7.8682307229E+00, 5.4169864414E+00, 7.9678736724E-01, 6.3826887596E-01, 6.9539607614E-01],
	[1.5975000000E+04, 7.8716628869E+00, 5.4167155300E+00, 7.9757634851E-01, 6.3879389865E-01, 6.9552069134E-01],
	[1.5980000000E+04, 7.8750954733E+00, 5.4164447170E+00, 7.9836586290E-01, 6.3931910873E-01, 6.9564527504E-01],
	[1.5985000000E+04, 7.8785284819E+00, 5.4161740023E+00, 7.9915591061E-01, 6.3984450608E-01, 6.9576982723E-01],
	[1.5990000000E+04, 7.8819619127E+00, 5.4159033857E+00, 7.9994649182E-01, 6.4037009059E-01, 6.9589434791E-01],
	[1.5995000000E+04, 7.8853957657E+00, 5.4156328673E+00, 8.0073760672E-01, 6.4089586212E-01, 6.9601883705E-01],
	[1.6000000000E+04, 7.8888300407E+00, 5.4153624469E+00, 8.0152925552E-01, 6.4142182057E-01, 6.9614329465E-01],
	[1.6005000000E+04, 7.8922647376E+00, 5.4150921245E+00, 8.0232143839E-01, 6.4194796581E-01, 6.9626772069E-01],
	[1.6010000000E+04, 7.8956998565E+00, 5.4148219000E+00, 8.0311415554E-01, 6.4247429771E-01, 6.9639211517E-01],
	[1.6015000000E+04, 7.8991353971E+00, 5.4145517734E+00, 8.0390740715E-01, 6.4300081617E-01, 6.9651647807E-01],
	[1.6020000000E+04, 7.9025713595E+00, 5.4142817446E+00, 8.0470119343E-01, 6.4352752106E-01, 6.9664080937E-01],
	[1.6025000000E+04, 7.9060077435E+00, 5.4140118135E+00, 8.0549551455E-01, 6.4405441225E-01, 6.9676510907E-01],
	[1.6030000000E+04, 7.9094445491E+00, 5.4137419801E+00, 8.0629037072E-01, 6.4458148963E-01, 6.9688937715E-01],
	[1.6035000000E+04, 7.9128817761E+00, 5.4134722443E+00, 8.0708576212E-01, 6.4510875308E-01, 6.9701361361E-01],
	[1.6040000000E+04, 7.9163194246E+00, 5.4132026059E+00, 8.0788168895E-01, 6.4563620247E-01, 6.9713781842E-01],
	[1.6045000000E+04, 7.9197622814E+00, 5.4129355062E+00, 8.0867815140E-01, 6.4616390434E-01, 6.9726199158E-01],
	[1.6050000000E+04, 7.9232124321E+00, 5.4126720046E+00, 8.0947514967E-01, 6.4669188784E-01, 6.9738613308E-01],
	[1.6055000000E+04, 7.9266630105E+00, 5.4124085979E+00, 8.1027268394E-01, 6.4722005734E-01, 6.9751024289E-01],
	[1.6060000000E+04, 7.9301140164E+00, 5.4121452860E+00, 8.1107075440E-01, 6.4774841272E-01, 6.9763432103E-01],
	[1.6065000000E+04, 7.9335654499E+00, 5.4118820688E+00, 8.1186936126E-01, 6.4827695386E-01, 6.9775836746E-01],
	[1.6070000000E+04, 7.9370173108E+00, 5.4116189464E+00, 8.1266850470E-01, 6.4880568064E-01, 6.9788238217E-01],
	[1.6075000000E+04, 7.9404695990E+00, 5.4113559186E+00, 8.1346818492E-01, 6.4933459294E-01, 6.9800636517E-01],
	[1.6080000000E+04, 7.9439223145E+00, 5.4110929854E+00, 8.1426840210E-01, 6.4986369063E-01, 6.9813031643E-01],
	[1.6085000000E+04, 7.9473754572E+00, 5.4108301467E+00, 8.1506915644E-01, 6.5039297360E-01, 6.9825423594E-01],
	[1.6090000000E+04, 7.9508290270E+00, 5.4105674024E+00, 8.1587044814E-01, 6.5092244172E-01, 6.9837812369E-01],
	[1.6095000000E+04, 7.9542830239E+00, 5.4103047526E+00, 8.1667227738E-01, 6.5145209488E-01, 6.9850197967E-01],
	[1.6100000000E+04, 7.9577374477E+00, 5.4100421970E+00, 8.1747464436E-01, 6.5198193294E-01, 6.9862580387E-01],
	[1.6105000000E+04, 7.9611922983E+00, 5.4097797358E+00, 8.1827754927E-01, 6.5251195579E-01, 6.9874959628E-01],
	[1.6110000000E+04, 7.9646475758E+00, 5.4095173687E+00, 8.1908099230E-01, 6.5304216331E-01, 6.9887335688E-01],
	[1.6115000000E+04, 7.9681032799E+00, 5.4092550958E+00, 8.1988497365E-01, 6.5357255537E-01, 6.9899708566E-01],
	[1.6120000000E+04, 7.9715594107E+00, 5.4089929169E+00, 8.2068949351E-01, 6.5410313186E-01, 6.9912078262E-01],
	[1.6125000000E+04, 7.9750159680E+00, 5.4087308320E+00, 8.2149455206E-01, 6.5463389264E-01, 6.9924444773E-01],
	[1.6130000000E+04, 7.9784729518E+00, 5.4084688411E+00, 8.2230014951E-01, 6.5516483760E-01, 6.9936808099E-01],
	[1.6135000000E+04, 7.9819303620E+00, 5.4082069441E+00, 8.2310628605E-01, 6.5569596661E-01, 6.9949168239E-01],
	[1.6140000000E+04, 7.9853881985E+00, 5.4079451409E+00, 8.2391296186E-01, 6.5622727956E-01, 6.9961525192E-01],
	[1.6145000000E+04, 7.9888464613E+00, 5.4076834315E+00, 8.2472017714E-01, 6.5675877632E-01, 6.9973878956E-01],
	[1.6150000000E+04, 7.9923051502E+00, 5.4074218157E+00, 8.2552793209E-01, 6.5729045676E-01, 6.9986229530E-01],
	[1.6155000000E+04, 7.9957642651E+00, 5.4071602936E+00, 8.2633622690E-01, 6.5782232076E-01, 6.9998576914E-01],
	[1.6160000000E+04, 7.9992238061E+00, 5.4068988651E+00, 8.2714506175E-01, 6.5835436821E-01, 7.0010921105E-01],
	[1.6165000000E+04, 8.0026837729E+00, 5.4066375300E+00, 8.2795443684E-01, 6.5888659898E-01, 7.0023262104E-01],
	[1.6170000000E+04, 8.0061441656E+00, 5.4063762885E+00, 8.2876435237E-01, 6.5941901293E-01, 7.0035599908E-01],
	[1.6175000000E+04, 8.0096049841E+00, 5.4061151403E+00, 8.2957480853E-01, 6.5995160996E-01, 7.0047934517E-01],
	[1.6180000000E+04, 8.0130662282E+00, 5.4058540854E+00, 8.3038580550E-01, 6.6048438994E-01, 7.0060265929E-01],
	[1.6185000000E+04, 8.0165278980E+00, 5.4055931238E+00, 8.3119734349E-01, 6.6101735274E-01, 7.0072594144E-01],
	[1.6190000000E+04, 8.0199899932E+00, 5.4053322553E+00, 8.3200942268E-01, 6.6155049825E-01, 7.0084919161E-01],
	[1.6195000000E+04, 8.0234525139E+00, 5.4050714801E+00, 8.3282204326E-01, 6.6208382633E-01, 7.0097240978E-01],
	[1.6200000000E+04, 8.0269154599E+00, 5.4048107978E+00, 8.3363520544E-01, 6.6261733686E-01, 7.0109559593E-01],
	[1.6205000000E+04, 8.0303788313E+00, 5.4045502086E+00, 8.3444890940E-01, 6.6315102972E-01, 7.0121875007E-01],
	[1.6210000000E+04, 8.0338426278E+00, 5.4042897124E+00, 8.3526315534E-01, 6.6368490479E-01, 7.0134187218E-01],
	[1.6215000000E+04, 8.0373068495E+00, 5.4040293090E+00, 8.3607794345E-01, 6.6421896194E-01, 7.0146496225E-01],
	[1.6220000000E+04, 8.0407714961E+00, 5.4037689985E+00, 8.3689327391E-01, 6.6475320105E-01, 7.0158802027E-01],
	[1.6225000000E+04, 8.0442365678E+00, 5.4035087807E+00, 8.3770914693E-01, 6.6528762199E-01, 7.0171104622E-01],
	[1.6230000000E+04, 8.0477020643E+00, 5.4032486556E+00, 8.3852556270E-01, 6.6582222464E-01, 7.0183404010E-01],
	[1.6235000000E+04, 8.0511679857E+00, 5.4029886232E+00, 8.3934252140E-01, 6.6635700887E-01, 7.0195700190E-01],
	[1.6240000000E+04, 8.0546343318E+00, 5.4027286834E+00, 8.4016002324E-01, 6.6689197457E-01, 7.0207993160E-01],
	[1.6245000000E+04, 8.0581011025E+00, 5.4024688360E+00, 8.4097806840E-01, 6.6742712160E-01, 7.0220282919E-01],
	[1.6250000000E+04, 8.0615682978E+00, 5.4022090812E+00, 8.4179665708E-01, 6.6796244984E-01, 7.0232569467E-01],
	[1.6255000000E+04, 8.0650359176E+00, 5.4019494187E+00, 8.4261578947E-01, 6.6849795917E-01, 7.0244852803E-01],
	[1.6260000000E+04, 8.0685039618E+00, 5.4016898486E+00, 8.4343546577E-01, 6.6903364945E-01, 7.0257132924E-01],
	[1.6265000000E+04, 8.0719724303E+00, 5.4014303707E+00, 8.4425568616E-01, 6.6956952058E-01, 7.0269409831E-01],
	[1.6270000000E+04, 8.0754413231E+00, 5.4011709850E+00, 8.4507645083E-01, 6.7010557241E-01, 7.0281683521E-01],
	[1.6275000000E+04, 8.0789106401E+00, 5.4009116915E+00, 8.4589775999E-01, 6.7064180483E-01, 7.0293953995E-01],
	[1.6280000000E+04, 8.0823803812E+00, 5.4006524901E+00, 8.4671961383E-01, 6.7117821771E-01, 7.0306221251E-01],
	[1.6285000000E+04, 8.0858505463E+00, 5.4003933807E+00, 8.4754201253E-01, 6.7171481093E-01, 7.0318485288E-01],
	[1.6290000000E+04, 8.0893211353E+00, 5.4001343633E+00, 8.4836495629E-01, 6.7225158436E-01, 7.0330746108E-01],
	[1.6295000000E+04, 8.0927921482E+00, 5.3998754378E+00, 8.4918844530E-01, 6.7278853786E-01, 7.0343003713E-01],
	[1.6300000000E+04, 8.0962635849E+00, 5.3996166041E+00, 8.5001247976E-01, 6.7332567133E-01, 7.0355258099E-01],
	[1.6305000000E+04, 8.0997446523E+00, 5.3993622822E+00, 8.5083705986E-01, 6.7386311721E-01, 7.0367509266E-01],
	[1.6310000000E+04, 8.1032291078E+00, 5.3991094702E+00, 8.5166218579E-01, 6.7440078577E-01, 7.0379757213E-01],
	[1.6315000000E+04, 8.1067139936E+00, 5.3988567476E+00, 8.5248785774E-01, 6.7493863436E-01, 7.0392001937E-01],
	[1.6320000000E+04, 8.1101993096E+00, 5.3986041142E+00, 8.5331407592E-01, 6.7547666285E-01, 7.0404243438E-01],
	[1.6325000000E+04, 8.1136850557E+00, 5.3983515700E+00, 8.5414084050E-01, 6.7601487111E-01, 7.0416481715E-01],
	[1.6330000000E+04, 8.1171712318E+00, 5.3980991150E+00, 8.5496815168E-01, 6.7655325902E-01, 7.0428716765E-01],
	[1.6335000000E+04, 8.1206578379E+00, 5.3978467491E+00, 8.5579600966E-01, 6.7709182645E-01, 7.0440948588E-01],
	[1.6340000000E+04, 8.1241448739E+00, 5.3975944722E+00, 8.5662441463E-01, 6.7763057327E-01, 7.0453177183E-01],
	[1.6345000000E+04, 8.1276323396E+00, 5.3973422842E+00, 8.5745336679E-01, 6.7816949936E-01, 7.0465402547E-01],
	[1.6350000000E+04, 8.1311202351E+00, 5.3970901852E+00, 8.5828286631E-01, 6.7870860460E-01, 7.0477624680E-01],
	[1.6355000000E+04, 8.1346085602E+00, 5.3968381750E+00, 8.5911291341E-01, 6.7924788885E-01, 7.0489843580E-01],
	[1.6360000000E+04, 8.1380973149E+00, 5.3965862536E+00, 8.5994350826E-01, 6.7978735199E-01, 7.0502059246E-01],
	[1.6365000000E+04, 8.1415864990E+00, 5.3963344210E+00, 8.6077465107E-01, 6.8032699389E-01, 7.0514271676E-01],
	[1.6370000000E+04, 8.1450761126E+00, 5.3960826770E+00, 8.6160634203E-01, 6.8086681443E-01, 7.0526480870E-01],
	[1.6375000000E+04, 8.1485661554E+00, 5.3958310217E+00, 8.6243858132E-01, 6.8140681348E-01, 7.0538686825E-01],
	[1.6380000000E+04, 8.1520566276E+00, 5.3955794549E+00, 8.6327136915E-01, 6.8194699092E-01, 7.0550889541E-01],
	[1.6385000000E+04, 8.1555475289E+00, 5.3953279766E+00, 8.6410470571E-01, 6.8248734662E-01, 7.0563089017E-01],
	[1.6390000000E+04, 8.1590388593E+00, 5.3950765867E+00, 8.6493859118E-01, 6.8302788044E-01, 7.0575285250E-01],
	[1.6395000000E+04, 8.1625306186E+00, 5.3948252853E+00, 8.6577302577E-01, 6.8356859227E-01, 7.0587478240E-01],
	[1.6400000000E+04, 8.1660228070E+00, 5.3945740722E+00, 8.6660800965E-01, 6.8410948198E-01, 7.0599667985E-01],
	[1.6405000000E+04, 8.1695154242E+00, 5.3943229473E+00, 8.6744354304E-01, 6.8465054943E-01, 7.0611854485E-01],
	[1.6410000000E+04, 8.1730084701E+00, 5.3940719107E+00, 8.6827962612E-01, 6.8519179451E-01, 7.0624037737E-01],
	[1.6415000000E+04, 8.1765019448E+00, 5.3938209622E+00, 8.6911625908E-01, 6.8573321708E-01, 7.0636217740E-01],
	[1.6420000000E+04, 8.1799958481E+00, 5.3935701018E+00, 8.6995344212E-01, 6.8627481703E-01, 7.0648394494E-01],
	[1.6425000000E+04, 8.1834901799E+00, 5.3933193294E+00, 8.7079117543E-01, 6.8681659421E-01, 7.0660567996E-01],
	[1.6430000000E+04, 8.1869849402E+00, 5.3930686450E+00, 8.7162945920E-01, 6.8735854850E-01, 7.0672738246E-01],
	[1.6435000000E+04, 8.1904801289E+00, 5.3928180486E+00, 8.7246829363E-01, 6.8790067979E-01, 7.0684905243E-01],
	[1.6440000000E+04, 8.1939757459E+00, 5.3925675400E+00, 8.7330767891E-01, 6.8844298793E-01, 7.0697068984E-01],
	[1.6445000000E+04, 8.1974717911E+00, 5.3923171192E+00, 8.7414761523E-01, 6.8898547279E-01, 7.0709229469E-01],
	[1.6450000000E+04, 8.2009682645E+00, 5.3920667862E+00, 8.7498810279E-01, 6.8952813427E-01, 7.0721386697E-01],
	[1.6455000000E+04, 8.2044651660E+00, 5.3918165409E+00, 8.7582914177E-01, 6.9007097221E-01, 7.0733540665E-01],
	[1.6460000000E+04, 8.2079624954E+00, 5.3915663832E+00, 8.7667073238E-01, 6.9061398650E-01, 7.0745691374E-01],
	[1.6465000000E+04, 8.2114602528E+00, 5.3913163131E+00, 8.7751287480E-01, 6.9115717701E-01, 7.0757838821E-01],
	[1.6470000000E+04, 8.2149584380E+00, 5.3910663305E+00, 8.7835556923E-01, 6.9170054361E-01, 7.0769983006E-01],
	[1.6475000000E+04, 8.2184570510E+00, 5.3908164353E+00, 8.7919881586E-01, 6.9224408617E-01, 7.0782123927E-01],
	[1.6480000000E+04, 8.2219560917E+00, 5.3905666276E+00, 8.8004261488E-01, 6.9278780457E-01, 7.0794261583E-01],
	[1.6485000000E+04, 8.2254555600E+00, 5.3903169072E+00, 8.8088696650E-01, 6.9333169867E-01, 7.0806395972E-01],
	[1.6490000000E+04, 8.2289554558E+00, 5.3900672742E+00, 8.8173187089E-01, 6.9387576834E-01, 7.0818527094E-01],
	[1.6495000000E+04, 8.2324557791E+00, 5.3898177283E+00, 8.8257732826E-01, 6.9442001346E-01, 7.0830654947E-01],
	[1.6500000000E+04, 8.2359565298E+00, 5.3895682696E+00, 8.8342333879E-01, 6.9496443390E-01, 7.0842779531E-01],
	[1.6505000000E+04, 8.2394577077E+00, 5.3893188981E+00, 8.8426990269E-01, 6.9550902953E-01, 7.0854900842E-01],
	[1.6510000000E+04, 8.2429593129E+00, 5.3890696136E+00, 8.8511702014E-01, 6.9605380022E-01, 7.0867018882E-01],
	[1.6515000000E+04, 8.2464613452E+00, 5.3888204162E+00, 8.8596469133E-01, 6.9659874584E-01, 7.0879133647E-01],
	[1.6520000000E+04, 8.2499638047E+00, 5.3885713057E+00, 8.8681291647E-01, 6.9714386627E-01, 7.0891245138E-01],
	[1.6525000000E+04, 8.2534666910E+00, 5.3883222820E+00, 8.8766169573E-01, 6.9768916136E-01, 7.0903353352E-01],
	[1.6530000000E+04, 8.2569700044E+00, 5.3880733453E+00, 8.8851102933E-01, 6.9823463101E-01, 7.0915458289E-01],
	[1.6535000000E+04, 8.2604737445E+00, 5.3878244953E+00, 8.8936091744E-01, 6.9878027506E-01, 7.0927559948E-01],
	[1.6540000000E+04, 8.2639779114E+00, 5.3875757320E+00, 8.9021136027E-01, 6.9932609340E-01, 7.0939658326E-01],
	[1.6545000000E+04, 8.2674825050E+00, 5.3873270554E+00, 8.9106235800E-01, 6.9987208590E-01, 7.0951753424E-01],
	[1.6550000000E+04, 8.2709875252E+00, 5.3870784654E+00, 8.9191391084E-01, 7.0041825242E-01, 7.0963845239E-01],
	[1.6555000000E+04, 8.2744929720E+00, 5.3868299620E+00, 8.9276601896E-01, 7.0096459284E-01, 7.0975933771E-01],
	[1.6560000000E+04, 8.2779988452E+00, 5.3865815450E+00, 8.9361868258E-01, 7.0151110702E-01, 7.0988019019E-01],
	[1.6565000000E+04, 8.2815085852E+00, 5.3863347720E+00, 8.9447190187E-01, 7.0205784603E-01, 7.1000100980E-01],
	[1.6570000000E+04, 8.2850279959E+00, 5.3860922665E+00, 8.9532567703E-01, 7.0260489629E-01, 7.1012179655E-01],
	[1.6575000000E+04, 8.2885478396E+00, 5.3858498451E+00, 8.9618000826E-01, 7.0315212040E-01, 7.1024255041E-01],
	[1.6580000000E+04, 8.2920681165E+00, 5.3856075077E+00, 8.9703489575E-01, 7.0369951821E-01, 7.1036327138E-01],
	[1.6585000000E+04, 8.2955888263E+00, 5.3853652543E+00, 8.9789033969E-01, 7.0424708960E-01, 7.1048395945E-01],
	[1.6590000000E+04, 8.2991099691E+00, 5.3851230848E+00, 8.9874634028E-01, 7.0479483445E-01, 7.1060461460E-01],
	[1.6595000000E+04, 8.3026315447E+00, 5.3848809991E+00, 8.9960289771E-01, 7.0534275261E-01, 7.1072523682E-01],
	[1.6600000000E+04, 8.3061535530E+00, 5.3846389973E+00, 9.0046001217E-01, 7.0589084397E-01, 7.1084582610E-01],
	[1.6605000000E+04, 8.3096759941E+00, 5.3843970792E+00, 9.0131768386E-01, 7.0643910838E-01, 7.1096638243E-01],
	[1.6610000000E+04, 8.3131988677E+00, 5.3841552448E+00, 9.0217591296E-01, 7.0698754572E-01, 7.1108690580E-01],
	[1.6615000000E+04, 8.3167221739E+00, 5.3839134941E+00, 9.0303469968E-01, 7.0753615587E-01, 7.1120739619E-01],
	[1.6620000000E+04, 8.3202459126E+00, 5.3836718269E+00, 9.0389404421E-01, 7.0808493868E-01, 7.1132785359E-01],
	[1.6625000000E+04, 8.3237700836E+00, 5.3834302433E+00, 9.0475394673E-01, 7.0863389403E-01, 7.1144827800E-01],
	[1.6630000000E+04, 8.3272946870E+00, 5.3831887432E+00, 9.0561440745E-01, 7.0918302179E-01, 7.1156866940E-01],
	[1.6635000000E+04, 8.3308197225E+00, 5.3829473265E+00, 9.0647542656E-01, 7.0973232183E-01, 7.1168902777E-01],
	[1.6640000000E+04, 8.3343451902E+00, 5.3827059931E+00, 9.0733700424E-01, 7.1028179401E-01, 7.1180935312E-01],
	[1.6645000000E+04, 8.3378710900E+00, 5.3824647431E+00, 9.0819914070E-01, 7.1083143821E-01, 7.1192964542E-01],
	[1.6650000000E+04, 8.3413974218E+00, 5.3822235764E+00, 9.0906183612E-01, 7.1138125430E-01, 7.1204990467E-01],
	[1.6655000000E+04, 8.3449241855E+00, 5.3819824928E+00, 9.0992509071E-01, 7.1193124214E-01, 7.1217013085E-01],
	[1.6660000000E+04, 8.3484513811E+00, 5.3817414925E+00, 9.1078890465E-01, 7.1248140161E-01, 7.1229032395E-01],
	[1.6665000000E+04, 8.3519790084E+00, 5.3815005752E+00, 9.1165327813E-01, 7.1303173256E-01, 7.1241048396E-01],
	[1.6670000000E+04, 8.3555070674E+00, 5.3812597410E+00, 9.1251821136E-01, 7.1358223488E-01, 7.1253061088E-01],
	[1.6675000000E+04, 8.3590355580E+00, 5.3810189898E+00, 9.1338370452E-01, 7.1413290843E-01, 7.1265070468E-01],
	[1.6680000000E+04, 8.3625644801E+00, 5.3807783215E+00, 9.1424975780E-01, 7.1468375307E-01, 7.1277076537E-01],
	[1.6685000000E+04, 8.3660938337E+00, 5.3805377361E+00, 9.1511637141E-01, 7.1523476869E-01, 7.1289079292E-01],
	[1.6690000000E+04, 8.3696236187E+00, 5.3802972335E+00, 9.1598354554E-01, 7.1578595514E-01, 7.1301078732E-01],
	[1.6695000000E+04, 8.3731538350E+00, 5.3800568138E+00, 9.1685128037E-01, 7.1633731229E-01, 7.1313074857E-01],
	[1.6700000000E+04, 8.3766844825E+00, 5.3798164767E+00, 9.1771957610E-01, 7.1688884001E-01, 7.1325067666E-01],
	[1.6705000000E+04, 8.3802155612E+00, 5.3795762224E+00, 9.1858843293E-01, 7.1744053818E-01, 7.1337057157E-01],
	[1.6710000000E+04, 8.3837470709E+00, 5.3793360507E+00, 9.1945785105E-01, 7.1799240665E-01, 7.1349043329E-01],
	[1.6715000000E+04, 8.3872790117E+00, 5.3790959615E+00, 9.2032783065E-01, 7.1854444530E-01, 7.1361026181E-01],
	[1.6720000000E+04, 8.3908113833E+00, 5.3788559549E+00, 9.2119837192E-01, 7.1909665400E-01, 7.1373005712E-01],
	[1.6725000000E+04, 8.3943441858E+00, 5.3786160307E+00, 9.2206947507E-01, 7.1964903261E-01, 7.1384981921E-01],
	[1.6730000000E+04, 8.3978774191E+00, 5.3783761889E+00, 9.2294114027E-01, 7.2020158100E-01, 7.1396954807E-01],
	[1.6735000000E+04, 8.4014110831E+00, 5.3781364295E+00, 9.2381336774E-01, 7.2075429904E-01, 7.1408924369E-01],
	[1.6740000000E+04, 8.4049451777E+00, 5.3778967524E+00, 9.2468615765E-01, 7.2130718659E-01, 7.1420890606E-01],
	[1.6745000000E+04, 8.4084797028E+00, 5.3776571576E+00, 9.2555951021E-01, 7.2186024352E-01, 7.1432853516E-01],
	[1.6750000000E+04, 8.4120146584E+00, 5.3774176449E+00, 9.2643342561E-01, 7.2241346971E-01, 7.1444813099E-01],
	[1.6755000000E+04, 8.4155500444E+00, 5.3771782145E+00, 9.2730790403E-01, 7.2296686502E-01, 7.1456769354E-01],
	[1.6760000000E+04, 8.4190858607E+00, 5.3769388661E+00, 9.2818294568E-01, 7.2352042931E-01, 7.1468722279E-01],
	[1.6765000000E+04, 8.4226221073E+00, 5.3766995997E+00, 9.2905855075E-01, 7.2407416245E-01, 7.1480671874E-01],
	[1.6770000000E+04, 8.4261587840E+00, 5.3764604153E+00, 9.2993471943E-01, 7.2462806432E-01, 7.1492618137E-01],
	[1.6775000000E+04, 8.4296958908E+00, 5.3762213129E+00, 9.3081145192E-01, 7.2518213477E-01, 7.1504561067E-01],
	[1.6780000000E+04, 8.4332334276E+00, 5.3759822924E+00, 9.3168874840E-01, 7.2573637367E-01, 7.1516500664E-01],
	[1.6785000000E+04, 8.4367713943E+00, 5.3757433537E+00, 9.3256660908E-01, 7.2629078090E-01, 7.1528436926E-01],
	[1.6790000000E+04, 8.4403097909E+00, 5.3755044967E+00, 9.3344503415E-01, 7.2684535631E-01, 7.1540369852E-01],
	[1.6795000000E+04, 8.4438486173E+00, 5.3752657215E+00, 9.3432402379E-01, 7.2740009978E-01, 7.1552299442E-01],
	[1.6800000000E+04, 8.4473878734E+00, 5.3750270280E+00, 9.3520357821E-01, 7.2795501117E-01, 7.1564225694E-01],
	[1.6805000000E+04, 8.4509275591E+00, 5.3747884161E+00, 9.3608369759E-01, 7.2851009035E-01, 7.1576148606E-01],
	[1.6810000000E+04, 8.4544676744E+00, 5.3745498858E+00, 9.3696438214E-01, 7.2906533718E-01, 7.1588068179E-01],
	[1.6815000000E+04, 8.4580082191E+00, 5.3743114370E+00, 9.3784563204E-01, 7.2962075154E-01, 7.1599984412E-01],
	[1.6820000000E+04, 8.4615491933E+00, 5.3740730697E+00, 9.3872744749E-01, 7.3017633328E-01, 7.1611897302E-01],
	[1.6825000000E+04, 8.4650905968E+00, 5.3738347837E+00, 9.3960982868E-01, 7.3073208227E-01, 7.1623806849E-01],
	[1.6830000000E+04, 8.4686324295E+00, 5.3735965792E+00, 9.4049277581E-01, 7.3128799839E-01, 7.1635713053E-01],
	[1.6835000000E+04, 8.4721871173E+00, 5.3733637632E+00, 9.4137628907E-01, 7.3184427266E-01, 7.1647615912E-01],
	[1.6840000000E+04, 8.4757430216E+00, 5.3731313597E+00, 9.4226036865E-01, 7.3240072625E-01, 7.1659515424E-01],
	[1.6845000000E+04, 8.4792993620E+00, 5.3728990352E+00, 9.4314501475E-01, 7.3295734705E-01, 7.1671411590E-01],
	[1.6850000000E+04, 8.4828561386E+00, 5.3726667897E+00, 9.4403022756E-01, 7.3351413492E-01, 7.1683304408E-01],
	[1.6855000000E+04, 8.4864133511E+00, 5.3724346232E+00, 9.4491600728E-01, 7.3407108973E-01, 7.1695193877E-01],
	[1.6860000000E+04, 8.4899709996E+00, 5.3722025355E+00, 9.4580235409E-01, 7.3462821134E-01, 7.1707079996E-01],
	[1.6865000000E+04, 8.4935290839E+00, 5.3719705267E+00, 9.4668926820E-01, 7.3518549961E-01, 7.1718962765E-01],
	[1.6870000000E+04, 8.4970876041E+00, 5.3717385967E+00, 9.4757674979E-01, 7.3574295442E-01, 7.1730842181E-01],
	[1.6875000000E+04, 8.5006465599E+00, 5.3715067454E+00, 9.4846479906E-01, 7.3630057562E-01, 7.1742718245E-01],
	[1.6880000000E+04, 8.5042059514E+00, 5.3712749728E+00, 9.4935341621E-01, 7.3685836310E-01, 7.1754590954E-01],
	[1.6885000000E+04, 8.5077657785E+00, 5.3710432789E+00, 9.5024260142E-01, 7.3741631670E-01, 7.1766460309E-01],
	[1.6890000000E+04, 8.5113260410E+00, 5.3708116635E+00, 9.5113235490E-01, 7.3797443630E-01, 7.1778326309E-01],
	[1.6895000000E+04, 8.5148867389E+00, 5.3705801267E+00, 9.5202267683E-01, 7.3853272177E-01, 7.1790188951E-01],
	[1.6900000000E+04, 8.5184478722E+00, 5.3703486683E+00, 9.5291356741E-01, 7.3909117296E-01, 7.1802048236E-01],
	[1.6905000000E+04, 8.5220094407E+00, 5.3701172884E+00, 9.5380502683E-01, 7.3964978975E-01, 7.1813904163E-01],
	[1.6910000000E+04, 8.5255714444E+00, 5.3698859869E+00, 9.5469705529E-01, 7.4020857200E-01, 7.1825756729E-01],
	[1.6915000000E+04, 8.5291338833E+00, 5.3696547638E+00, 9.5558965298E-01, 7.4076751957E-01, 7.1837605935E-01],
	[1.6920000000E+04, 8.5326967571E+00, 5.3694236189E+00, 9.5648282010E-01, 7.4132663233E-01, 7.1849451780E-01],
	[1.6925000000E+04, 8.5362600659E+00, 5.3691925523E+00, 9.5737655683E-01, 7.4188591015E-01, 7.1861294262E-01],
	[1.6930000000E+04, 8.5398238096E+00, 5.3689615638E+00, 9.5827086338E-01, 7.4244535289E-01, 7.1873133381E-01],
	[1.6935000000E+04, 8.5433879881E+00, 5.3687306535E+00, 9.5916573993E-01, 7.4300496041E-01, 7.1884969136E-01],
	[1.6940000000E+04, 8.5469526013E+00, 5.3684998213E+00, 9.6006118668E-01, 7.4356473259E-01, 7.1896801525E-01],
	[1.6945000000E+04, 8.5505176492E+00, 5.3682690671E+00, 9.6095720383E-01, 7.4412466928E-01, 7.1908630549E-01],
	[1.6950000000E+04, 8.5540831317E+00, 5.3680383910E+00, 9.6185379156E-01, 7.4468477035E-01, 7.1920456205E-01],
	[1.6955000000E+04, 8.5576490486E+00, 5.3678077927E+00, 9.6275095008E-01, 7.4524503567E-01, 7.1932278493E-01],
	[1.6960000000E+04, 8.5612154000E+00, 5.3675772724E+00, 9.6364867957E-01, 7.4580546510E-01, 7.1944097412E-01],
	[1.6965000000E+04, 8.5647821858E+00, 5.3673468299E+00, 9.6454698024E-01, 7.4636605850E-01, 7.1955912961E-01],
	[1.6970000000E+04, 8.5683494058E+00, 5.3671164652E+00, 9.6544585226E-01, 7.4692681574E-01, 7.1967725139E-01],
	[1.6975000000E+04, 8.5719170600E+00, 5.3668861783E+00, 9.6634529585E-01, 7.4748773668E-01, 7.1979533946E-01],
	[1.6980000000E+04, 8.5754851484E+00, 5.3666559690E+00, 9.6724531118E-01, 7.4804882120E-01, 7.1991339380E-01],
	[1.6985000000E+04, 8.5790536708E+00, 5.3664258374E+00, 9.6814589846E-01, 7.4861006914E-01, 7.2003141441E-01],
	[1.6990000000E+04, 8.5826226272E+00, 5.3661957834E+00, 9.6904705789E-01, 7.4917148038E-01, 7.2014940127E-01],
	[1.6995000000E+04, 8.5861920174E+00, 5.3659658069E+00, 9.6994878964E-01, 7.4973305479E-01, 7.2026735438E-01],
	[1.7000000000E+04, 8.5897618416E+00, 5.3657359080E+00, 9.7085109392E-01, 7.5029479222E-01, 7.2038527372E-01],
	[1.7005000000E+04, 8.5933320994E+00, 5.3655060865E+00, 9.7175397093E-01, 7.5085669253E-01, 7.2050315930E-01],
	[1.7010000000E+04, 8.5969027910E+00, 5.3652763424E+00, 9.7265742085E-01, 7.5141875560E-01, 7.2062101109E-01],
	[1.7015000000E+04, 8.6004739161E+00, 5.3650466757E+00, 9.7356144388E-01, 7.5198098129E-01, 7.2073882910E-01],
	[1.7020000000E+04, 8.6040454748E+00, 5.3648170862E+00, 9.7446604021E-01, 7.5254336946E-01, 7.2085661331E-01],
	[1.7025000000E+04, 8.6076174670E+00, 5.3645875741E+00, 9.7537121005E-01, 7.5310591997E-01, 7.2097436371E-01],
	[1.7030000000E+04, 8.6111898925E+00, 5.3643581391E+00, 9.7627695357E-01, 7.5366863269E-01, 7.2109208030E-01],
	[1.7035000000E+04, 8.6147627513E+00, 5.3641287813E+00, 9.7718327098E-01, 7.5423150748E-01, 7.2120976306E-01],
	[1.7040000000E+04, 8.6183360433E+00, 5.3638995006E+00, 9.7809016247E-01, 7.5479454421E-01, 7.2132741199E-01],
	[1.7045000000E+04, 8.6219097685E+00, 5.3636702970E+00, 9.7899762824E-01, 7.5535774273E-01, 7.2144502708E-01],
	[1.7050000000E+04, 8.6254839268E+00, 5.3634411704E+00, 9.7990566847E-01, 7.5592110292E-01, 7.2156260832E-01],
	[1.7055000000E+04, 8.6290585181E+00, 5.3632121207E+00, 9.8081428336E-01, 7.5648462463E-01, 7.2168015570E-01],
	[1.7060000000E+04, 8.6326335424E+00, 5.3629831480E+00, 9.8172347311E-01, 7.5704830773E-01, 7.2179766921E-01],
	[1.7065000000E+04, 8.6362089994E+00, 5.3627542521E+00, 9.8263323792E-01, 7.5761215208E-01, 7.2191514885E-01],
	[1.7070000000E+04, 8.6397848893E+00, 5.3625254331E+00, 9.8354357796E-01, 7.5817615755E-01, 7.2203259460E-01],
	[1.7075000000E+04, 8.6433612119E+00, 5.3622966908E+00, 9.8445449345E-01, 7.5874032399E-01, 7.2215000646E-01],
	[1.7080000000E+04, 8.6469379671E+00, 5.3620680253E+00, 9.8536598457E-01, 7.5930465127E-01, 7.2226738441E-01],
	[1.7085000000E+04, 8.6505151549E+00, 5.3618394364E+00, 9.8627805151E-01, 7.5986913926E-01, 7.2238472846E-01],
	[1.7090000000E+04, 8.6540927751E+00, 5.3616109242E+00, 9.8719069448E-01, 7.6043378781E-01, 7.2250203859E-01],
	[1.7095000000E+04, 8.6576708278E+00, 5.3613824885E+00, 9.8810391366E-01, 7.6099859680E-01, 7.2261931480E-01],
	[1.7100000000E+04, 8.6612493128E+00, 5.3611541294E+00, 9.8901770925E-01, 7.6156356607E-01, 7.2273655707E-01],
	[1.7105000000E+04, 8.6648385592E+00, 5.3609300155E+00, 9.8993208145E-01, 7.6212885966E-01, 7.2285376539E-01],
	[1.7110000000E+04, 8.6684316519E+00, 5.3607073516E+00, 9.9084703044E-01, 7.6269436787E-01, 7.2297093977E-01],
	[1.7115000000E+04, 8.6720251840E+00, 5.3604847619E+00, 9.9176255643E-01, 7.6326003646E-01, 7.2308808018E-01],
	[1.7120000000E+04, 8.6756191555E+00, 5.3602622466E+00, 9.9267865960E-01, 7.6382586530E-01, 7.2320518663E-01],
	[1.7125000000E+04, 8.6792135663E+00, 5.3600398054E+00, 9.9359534015E-01, 7.6439185425E-01, 7.2332225910E-01],
	[1.7130000000E+04, 8.6828084164E+00, 5.3598174384E+00, 9.9451259828E-01, 7.6495800317E-01, 7.2343929759E-01],
	[1.7135000000E+04, 8.6864037056E+00, 5.3595951455E+00, 9.9543043417E-01, 7.6552431193E-01, 7.2355630208E-01],
	[1.7140000000E+04, 8.6899994340E+00, 5.3593729266E+00, 9.9634884803E-01, 7.6609078039E-01, 7.2367327257E-01],
	[1.7145000000E+04, 8.6935956013E+00, 5.3591507818E+00, 9.9726784005E-01, 7.6665740841E-01, 7.2379020906E-01],
	[1.7150000000E+04, 8.6971922076E+00, 5.3589287110E+00, 9.9818741042E-01, 7.6722419585E-01, 7.2390711153E-01],
	[1.7155000000E+04, 8.7007892528E+00, 5.3587067141E+00, 9.9910755933E-01, 7.6779114258E-01, 7.2402397998E-01],
	[1.7160000000E+04, 8.7043867368E+00, 5.3584847911E+00, 1.0000282870E+00, 7.6835824846E-01, 7.2414081439E-01],
	[1.7165000000E+04, 8.7079846595E+00, 5.3582629420E+00, 1.0009495936E+00, 7.6892551334E-01, 7.2425761476E-01],
	[1.7170000000E+04, 8.7115830208E+00, 5.3580411666E+00, 1.0018714793E+00, 7.6949293710E-01, 7.2437438109E-01],
	[1.7175000000E+04, 8.7151818207E+00, 5.3578194650E+00, 1.0027939443E+00, 7.7006051960E-01, 7.2449111336E-01],
	[1.7180000000E+04, 8.7187810592E+00, 5.3575978370E+00, 1.0037169889E+00, 7.7062826069E-01, 7.2460781156E-01],
	[1.7185000000E+04, 8.7223807360E+00, 5.3573762828E+00, 1.0046406132E+00, 7.7119616023E-01, 7.2472447569E-01],
	[1.7190000000E+04, 8.7259808512E+00, 5.3571548021E+00, 1.0055648173E+00, 7.7176421810E-01, 7.2484110575E-01],
	[1.7195000000E+04, 8.7295814047E+00, 5.3569333950E+00, 1.0064896016E+00, 7.7233243415E-01, 7.2495770172E-01],
	[1.7200000000E+04, 8.7331823964E+00, 5.3567120615E+00, 1.0074149662E+00, 7.7290080825E-01, 7.2507426359E-01],
	[1.7205000000E+04, 8.7367838262E+00, 5.3564908014E+00, 1.0083409112E+00, 7.7346934025E-01, 7.2519079136E-01],
	[1.7210000000E+04, 8.7403856940E+00, 5.3562696147E+00, 1.0092674370E+00, 7.7403803002E-01, 7.2530728502E-01],
	[1.7215000000E+04, 8.7439879999E+00, 5.3560485014E+00, 1.0101945436E+00, 7.7460687741E-01, 7.2542374456E-01],
	[1.7220000000E+04, 8.7475907437E+00, 5.3558274614E+00, 1.0111222313E+00, 7.7517588230E-01, 7.2554016998E-01],
	[1.7225000000E+04, 8.7511939252E+00, 5.3556064948E+00, 1.0120505002E+00, 7.7574504454E-01, 7.2565656126E-01],
	[1.7230000000E+04, 8.7547975446E+00, 5.3553856014E+00, 1.0129793507E+00, 7.7631436399E-01, 7.2577291841E-01],
	[1.7235000000E+04, 8.7584016016E+00, 5.3551647811E+00, 1.0139087827E+00, 7.7688384051E-01, 7.2588924140E-01],
	[1.7240000000E+04, 8.7620060963E+00, 5.3549440341E+00, 1.0148387967E+00, 7.7745347397E-01, 7.2600553024E-01],
	[1.7245000000E+04, 8.7656110285E+00, 5.3547233601E+00, 1.0157693926E+00, 7.7802326423E-01, 7.2612178492E-01],
	[1.7250000000E+04, 8.7692163981E+00, 5.3545027592E+00, 1.0167005708E+00, 7.7859321114E-01, 7.2623800543E-01],
	[1.7255000000E+04, 8.7728222052E+00, 5.3542822313E+00, 1.0176323315E+00, 7.7916331458E-01, 7.2635419176E-01],
	[1.7260000000E+04, 8.7764284495E+00, 5.3540617764E+00, 1.0185646747E+00, 7.7973357439E-01, 7.2647034391E-01],
	[1.7265000000E+04, 8.7800351311E+00, 5.3538413944E+00, 1.0194976008E+00, 7.8030399044E-01, 7.2658646186E-01],
	[1.7270000000E+04, 8.7836422499E+00, 5.3536210853E+00, 1.0204311099E+00, 7.8087456259E-01, 7.2670254561E-01],
	[1.7275000000E+04, 8.7872498058E+00, 5.3534008491E+00, 1.0213652022E+00, 7.8144529071E-01, 7.2681859516E-01],
	[1.7280000000E+04, 8.7908577987E+00, 5.3531806856E+00, 1.0222998780E+00, 7.8201617465E-01, 7.2693461050E-01],
	[1.7285000000E+04, 8.7944662285E+00, 5.3529605949E+00, 1.0232351373E+00, 7.8258721427E-01, 7.2705059161E-01],
	[1.7290000000E+04, 8.7980750952E+00, 5.3527405769E+00, 1.0241709804E+00, 7.8315840943E-01, 7.2716653850E-01],
	[1.7295000000E+04, 8.8016843988E+00, 5.3525206315E+00, 1.0251074075E+00, 7.8372976000E-01, 7.2728245115E-01],
	[1.7300000000E+04, 8.8052941390E+00, 5.3523007587E+00, 1.0260444188E+00, 7.8430126583E-01, 7.2739832955E-01],
	[1.7305000000E+04, 8.8089043159E+00, 5.3520809585E+00, 1.0269820144E+00, 7.8487292678E-01, 7.2751417371E-01],
	[1.7310000000E+04, 8.8125149294E+00, 5.3518612309E+00, 1.0279201946E+00, 7.8544474272E-01, 7.2762998361E-01],
	[1.7315000000E+04, 8.8161259794E+00, 5.3516415757E+00, 1.0288589596E+00, 7.8601671351E-01, 7.2774575925E-01],
	[1.7320000000E+04, 8.8197374658E+00, 5.3514219929E+00, 1.0297983096E+00, 7.8658883900E-01, 7.2786150062E-01],
	[1.7325000000E+04, 8.8233493886E+00, 5.3512024825E+00, 1.0307382447E+00, 7.8716111906E-01, 7.2797720771E-01],
	[1.7330000000E+04, 8.8269617477E+00, 5.3509830445E+00, 1.0316787652E+00, 7.8773355354E-01, 7.2809288052E-01],
	[1.7335000000E+04, 8.8305745430E+00, 5.3507636787E+00, 1.0326198712E+00, 7.8830614230E-01, 7.2820851903E-01],
	[1.7340000000E+04, 8.8341877745E+00, 5.3505443853E+00, 1.0335615629E+00, 7.8887888521E-01, 7.2832412325E-01],
	[1.7345000000E+04, 8.8378014420E+00, 5.3503251640E+00, 1.0345038406E+00, 7.8945178213E-01, 7.2843969316E-01],
	[1.7350000000E+04, 8.8414155455E+00, 5.3501060149E+00, 1.0354467044E+00, 7.9002483291E-01, 7.2855522877E-01],
	[1.7355000000E+04, 8.8450300849E+00, 5.3498869379E+00, 1.0363901545E+00, 7.9059803741E-01, 7.2867073005E-01],
	[1.7360000000E+04, 8.8486450602E+00, 5.3496679329E+00, 1.0373341912E+00, 7.9117139550E-01, 7.2878619701E-01],
	[1.7365000000E+04, 8.8522604712E+00, 5.3494490001E+00, 1.0382788145E+00, 7.9174490703E-01, 7.2890162963E-01],
	[1.7370000000E+04, 8.8558763180E+00, 5.3492301391E+00, 1.0392240248E+00, 7.9231857186E-01, 7.2901702792E-01],
	[1.7375000000E+04, 8.8594926004E+00, 5.3490113502E+00, 1.0401698222E+00, 7.9289238986E-01, 7.2913239186E-01],
	[1.7380000000E+04, 8.8631191746E+00, 5.3487963968E+00, 1.0411162068E+00, 7.9346652269E-01, 7.2924772146E-01],
	[1.7385000000E+04, 8.8667506064E+00, 5.3485831997E+00, 1.0420631790E+00, 7.9404088135E-01, 7.2936301669E-01],
	[1.7390000000E+04, 8.8703824812E+00, 5.3483700724E+00, 1.0430107388E+00, 7.9461539327E-01, 7.2947827756E-01],
	[1.7395000000E+04, 8.8740147989E+00, 5.3481570149E+00, 1.0439588865E+00, 7.9519005833E-01, 7.2959350406E-01],
	[1.7400000000E+04, 8.8776475595E+00, 5.3479440270E+00, 1.0449076223E+00, 7.9576487637E-01, 7.2970869618E-01],
	[1.7405000000E+04, 8.8812807628E+00, 5.3477311089E+00, 1.0458569464E+00, 7.9633984725E-01, 7.2982385391E-01],
	[1.7410000000E+04, 8.8849144088E+00, 5.3475182604E+00, 1.0468068589E+00, 7.9691497084E-01, 7.2993897726E-01],
	[1.7415000000E+04, 8.8885484974E+00, 5.3473054815E+00, 1.0477573600E+00, 7.9749024699E-01, 7.3005406620E-01],
	[1.7420000000E+04, 8.8921830285E+00, 5.3470927721E+00, 1.0487084501E+00, 7.9806567557E-01, 7.3016912075E-01],
	[1.7425000000E+04, 8.8958180021E+00, 5.3468801322E+00, 1.0496601292E+00, 7.9864125644E-01, 7.3028414088E-01],
	[1.7430000000E+04, 8.8994534181E+00, 5.3466675618E+00, 1.0506123975E+00, 7.9921698944E-01, 7.3039912660E-01],
	[1.7435000000E+04, 8.9030892764E+00, 5.3464550608E+00, 1.0515652552E+00, 7.9979287445E-01, 7.3051407790E-01],
	[1.7440000000E+04, 8.9067255769E+00, 5.3462426292E+00, 1.0525187026E+00, 8.0036891132E-01, 7.3062899477E-01],
	[1.7445000000E+04, 8.9103623197E+00, 5.3460302669E+00, 1.0534727398E+00, 8.0094509991E-01, 7.3074387720E-01],
	[1.7450000000E+04, 8.9139995045E+00, 5.3458179739E+00, 1.0544273671E+00, 8.0152144008E-01, 7.3085872519E-01],
	[1.7455000000E+04, 8.9176371313E+00, 5.3456057501E+00, 1.0553825845E+00, 8.0209793168E-01, 7.3097353874E-01],
	[1.7460000000E+04, 8.9212752001E+00, 5.3453935956E+00, 1.0563383924E+00, 8.0267457459E-01, 7.3108831783E-01],
	[1.7465000000E+04, 8.9249137108E+00, 5.3451815102E+00, 1.0572947908E+00, 8.0325136864E-01, 7.3120306246E-01],
	[1.7470000000E+04, 8.9285526633E+00, 5.3449694939E+00, 1.0582517801E+00, 8.0382831372E-01, 7.3131777263E-01],
	[1.7475000000E+04, 8.9321920575E+00, 5.3447575467E+00, 1.0592093604E+00, 8.0440540966E-01, 7.3143244832E-01],
	[1.7480000000E+04, 8.9358318934E+00, 5.3445456686E+00, 1.0601675318E+00, 8.0498265634E-01, 7.3154708954E-01],
	[1.7485000000E+04, 8.9394721709E+00, 5.3443338594E+00, 1.0611262946E+00, 8.0556005361E-01, 7.3166169628E-01],
	[1.7490000000E+04, 8.9431128899E+00, 5.3441221192E+00, 1.0620856490E+00, 8.0613760132E-01, 7.3177626852E-01],
	[1.7495000000E+04, 8.9467540504E+00, 5.3439104479E+00, 1.0630455952E+00, 8.0671529934E-01, 7.3189080627E-01],
	[1.7500000000E+04, 8.9503956522E+00, 5.3436988454E+00, 1.0640061334E+00, 8.0729314753E-01, 7.3200530952E-01],
	[1.7505000000E+04, 8.9540376953E+00, 5.3434873118E+00, 1.0649754300E+00, 8.0787584507E-01, 7.3211977826E-01],
	[1.7510000000E+04, 8.9576801796E+00, 5.3432758470E+00, 1.0659453315E+00, 8.0845869617E-01, 7.3223421249E-01],
	[1.7515000000E+04, 8.9613231051E+00, 5.3430644509E+00, 1.0669158381E+00, 8.0904170070E-01, 7.3234861220E-01],
	[1.7520000000E+04, 8.9649664717E+00, 5.3428531235E+00, 1.0678869501E+00, 8.0962485851E-01, 7.3246297739E-01],
	[1.7525000000E+04, 8.9686102793E+00, 5.3426418648E+00, 1.0688586676E+00, 8.1020816945E-01, 7.3257730804E-01],
	[1.7530000000E+04, 8.9722545278E+00, 5.3424306746E+00, 1.0698309908E+00, 8.1079163338E-01, 7.3269160416E-01],
	[1.7535000000E+04, 8.9758992172E+00, 5.3422195531E+00, 1.0708039199E+00, 8.1137525015E-01, 7.3280586574E-01],
	[1.7540000000E+04, 8.9795443473E+00, 5.3420085001E+00, 1.0717774552E+00, 8.1195901962E-01, 7.3292009277E-01],
	[1.7545000000E+04, 8.9831899182E+00, 5.3417975155E+00, 1.0727515968E+00, 8.1254294164E-01, 7.3303428525E-01],
	[1.7550000000E+04, 8.9868359298E+00, 5.3415865995E+00, 1.0737263450E+00, 8.1312701608E-01, 7.3314844316E-01],
	[1.7555000000E+04, 8.9904823819E+00, 5.3413757518E+00, 1.0747016999E+00, 8.1371124277E-01, 7.3326256652E-01],
	[1.7560000000E+04, 8.9941292745E+00, 5.3411649725E+00, 1.0756776618E+00, 8.1429562158E-01, 7.3337665530E-01],
	[1.7565000000E+04, 8.9977766075E+00, 5.3409542615E+00, 1.0766542308E+00, 8.1488015236E-01, 7.3349070951E-01],
	[1.7570000000E+04, 9.0014243809E+00, 5.3407436188E+00, 1.0776314072E+00, 8.1546483497E-01, 7.3360472914E-01],
	[1.7575000000E+04, 9.0050725946E+00, 5.3405330443E+00, 1.0786091912E+00, 8.1604966926E-01, 7.3371871418E-01],
	[1.7580000000E+04, 9.0087212485E+00, 5.3403225380E+00, 1.0795875829E+00, 8.1663465508E-01, 7.3383266463E-01],
	[1.7585000000E+04, 9.0123703426E+00, 5.3401120999E+00, 1.0805665826E+00, 8.1721979230E-01, 7.3394658048E-01],
	[1.7590000000E+04, 9.0160198767E+00, 5.3399017299E+00, 1.0815461904E+00, 8.1780508075E-01, 7.3406046174E-01],
	[1.7595000000E+04, 9.0196698508E+00, 5.3396914280E+00, 1.0825264067E+00, 8.1839052031E-01, 7.3417430838E-01],
	[1.7600000000E+04, 9.0233202648E+00, 5.3394811941E+00, 1.0835072315E+00, 8.1897611081E-01, 7.3428812041E-01],
	[1.7605000000E+04, 9.0269711187E+00, 5.3392710282E+00, 1.0844886651E+00, 8.1956185212E-01, 7.3440189782E-01],
	[1.7610000000E+04, 9.0306224124E+00, 5.3390609302E+00, 1.0854707077E+00, 8.2014774409E-01, 7.3451564061E-01],
	[1.7615000000E+04, 9.0342741458E+00, 5.3388509002E+00, 1.0864533595E+00, 8.2073378658E-01, 7.3462934877E-01],
	[1.7620000000E+04, 9.0379263188E+00, 5.3386409380E+00, 1.0874366207E+00, 8.2131997943E-01, 7.3474302229E-01],
	[1.7625000000E+04, 9.0415789313E+00, 5.3384310437E+00, 1.0884204915E+00, 8.2190632251E-01, 7.3485666118E-01],
	[1.7630000000E+04, 9.0452319834E+00, 5.3382212171E+00, 1.0894049721E+00, 8.2249281566E-01, 7.3497026542E-01],
	[1.7635000000E+04, 9.0488854749E+00, 5.3380114583E+00, 1.0903900627E+00, 8.2307945873E-01, 7.3508383501E-01],
	[1.7640000000E+04, 9.0525394058E+00, 5.3378017671E+00, 1.0913757635E+00, 8.2366625160E-01, 7.3519736994E-01],
	[1.7645000000E+04, 9.0561937759E+00, 5.3375921437E+00, 1.0923620748E+00, 8.2425319409E-01, 7.3531087022E-01],
	[1.7650000000E+04, 9.0598485852E+00, 5.3373825878E+00, 1.0933489967E+00, 8.2484028608E-01, 7.3542433583E-01],
	[1.7655000000E+04, 9.0635038337E+00, 5.3371730996E+00, 1.0943365294E+00, 8.2542752741E-01, 7.3553776677E-01],
	[1.7660000000E+04, 9.0671704828E+00, 5.3369676641E+00, 1.0953246731E+00, 8.2601510437E-01, 7.3565116304E-01],
	[1.7665000000E+04, 9.0708413723E+00, 5.3367636740E+00, 1.0963134280E+00, 8.2660289541E-01, 7.3576452463E-01],
	[1.7670000000E+04, 9.0745127084E+00, 5.3365597494E+00, 1.0973027945E+00, 8.2719083590E-01, 7.3587785153E-01],
	[1.7675000000E+04, 9.0781844911E+00, 5.3363558903E+00, 1.0982927725E+00, 8.2777892570E-01, 7.3599114375E-01],
	[1.7680000000E+04, 9.0818567203E+00, 5.3361520966E+00, 1.0992833624E+00, 8.2836716467E-01, 7.3610440126E-01],
	[1.7685000000E+04, 9.0855293960E+00, 5.3359483684E+00, 1.1002745643E+00, 8.2895555265E-01, 7.3621762408E-01],
	[1.7690000000E+04, 9.0892025181E+00, 5.3357447055E+00, 1.1012663785E+00, 8.2954408951E-01, 7.3633081220E-01],
	[1.7695000000E+04, 9.0928760864E+00, 5.3355411079E+00, 1.1022588052E+00, 8.3013277510E-01, 7.3644396561E-01],
	[1.7700000000E+04, 9.0965501010E+00, 5.3353375757E+00, 1.1032518445E+00, 8.3072160926E-01, 7.3655708430E-01],
	[1.7705000000E+04, 9.1002245618E+00, 5.3351341086E+00, 1.1042454967E+00, 8.3131059186E-01, 7.3667016827E-01],
	[1.7710000000E+04, 9.1038994686E+00, 5.3349307068E+00, 1.1052397619E+00, 8.3189972274E-01, 7.3678321752E-01],
	[1.7715000000E+04, 9.1075748215E+00, 5.3347273702E+00, 1.1062346405E+00, 8.3248900176E-01, 7.3689623205E-01],
	[1.7720000000E+04, 9.1112506203E+00, 5.3345240986E+00, 1.1072301325E+00, 8.3307842878E-01, 7.3700921184E-01],
	[1.7725000000E+04, 9.1149268650E+00, 5.3343208922E+00, 1.1082262382E+00, 8.3366800364E-01, 7.3712215689E-01],
	[1.7730000000E+04, 9.1186035554E+00, 5.3341177508E+00, 1.1092229578E+00, 8.3425772620E-01, 7.3723506720E-01],
	[1.7735000000E+04, 9.1222806917E+00, 5.3339146745E+00, 1.1102202914E+00, 8.3484759631E-01, 7.3734794277E-01],
	[1.7740000000E+04, 9.1259582735E+00, 5.3337116631E+00, 1.1112182394E+00, 8.3543761382E-01, 7.3746078359E-01],
	[1.7745000000E+04, 9.1296363010E+00, 5.3335087166E+00, 1.1122168019E+00, 8.3602777860E-01, 7.3757358965E-01],
	[1.7750000000E+04, 9.1333147740E+00, 5.3333058350E+00, 1.1132159791E+00, 8.3661809048E-01, 7.3768636095E-01],
	[1.7755000000E+04, 9.1369936924E+00, 5.3331030183E+00, 1.1142157712E+00, 8.3720854933E-01, 7.3779909748E-01],
	[1.7760000000E+04, 9.1406730562E+00, 5.3329002664E+00, 1.1152161784E+00, 8.3779915499E-01, 7.3791179925E-01],
	[1.7765000000E+04, 9.1443528653E+00, 5.3326975793E+00, 1.1162172009E+00, 8.3838990732E-01, 7.3802446624E-01],
	[1.7770000000E+04, 9.1480331196E+00, 5.3324949569E+00, 1.1172188389E+00, 8.3898080617E-01, 7.3813709846E-01],
	[1.7775000000E+04, 9.1517138191E+00, 5.3322923993E+00, 1.1182210927E+00, 8.3957185140E-01, 7.3824969590E-01],
	[1.7780000000E+04, 9.1553949637E+00, 5.3320899063E+00, 1.1192239624E+00, 8.4016304285E-01, 7.3836225855E-01],
	[1.7785000000E+04, 9.1590765533E+00, 5.3318874779E+00, 1.1202274482E+00, 8.4075438038E-01, 7.3847478640E-01],
	[1.7790000000E+04, 9.1627585878E+00, 5.3316851141E+00, 1.1212315504E+00, 8.4134586385E-01, 7.3858727947E-01],
	[1.7795000000E+04, 9.1664410672E+00, 5.3314828148E+00, 1.1222362691E+00, 8.4193749309E-01, 7.3869973773E-01],
	[1.7800000000E+04, 9.1701239914E+00, 5.3312805800E+00, 1.1232416045E+00, 8.4252926798E-01, 7.3881216120E-01],
	[1.7805000000E+04, 9.1738073603E+00, 5.3310784097E+00, 1.1242475569E+00, 8.4312118835E-01, 7.3892454985E-01],
	[1.7810000000E+04, 9.1774911739E+00, 5.3308763039E+00, 1.1252541265E+00, 8.4371325406E-01, 7.3903690369E-01],
	[1.7815000000E+04, 9.1811754321E+00, 5.3306742624E+00, 1.1262613134E+00, 8.4430546496E-01, 7.3914922272E-01],
	[1.7820000000E+04, 9.1848601348E+00, 5.3304722853E+00, 1.1272691179E+00, 8.4489782091E-01, 7.3926150693E-01],
	[1.7825000000E+04, 9.1885452820E+00, 5.3302703725E+00, 1.1282775402E+00, 8.4549032175E-01, 7.3937375631E-01],
	[1.7830000000E+04, 9.1922308735E+00, 5.3300685240E+00, 1.1292865804E+00, 8.4608296734E-01, 7.3948597087E-01],
	[1.7835000000E+04, 9.1959169093E+00, 5.3298667397E+00, 1.1302962388E+00, 8.4667575753E-01, 7.3959815060E-01],
	[1.7840000000E+04, 9.1996033894E+00, 5.3296650196E+00, 1.1313065156E+00, 8.4726869218E-01, 7.3971029549E-01],
	[1.7845000000E+04, 9.2032903136E+00, 5.3294633636E+00, 1.1323174110E+00, 8.4786177112E-01, 7.3982240558E-01],
	[1.7850000000E+04, 9.2069776819E+00, 5.3292617718E+00, 1.1333289251E+00, 8.4845499423E-01, 7.3993448085E-01],
	[1.7855000000E+04, 9.2106654942E+00, 5.3290602441E+00, 1.1343410583E+00, 8.4904836134E-01, 7.4004652132E-01],
	[1.7860000000E+04, 9.2143537505E+00, 5.3288587804E+00, 1.1353538106E+00, 8.4964187231E-01, 7.4015852696E-01],
	[1.7865000000E+04, 9.2180424507E+00, 5.3286573807E+00, 1.1363671824E+00, 8.5023552699E-01, 7.4027049777E-01],
	[1.7870000000E+04, 9.2217315946E+00, 5.3284560450E+00, 1.1373811738E+00, 8.5082932523E-01, 7.4038243375E-01],
	[1.7875000000E+04, 9.2254211823E+00, 5.3282547732E+00, 1.1383957850E+00, 8.5142326689E-01, 7.4049433488E-01],
	[1.7880000000E+04, 9.2291112137E+00, 5.3280535653E+00, 1.1394110162E+00, 8.5201735181E-01, 7.4060620117E-01],
	[1.7885000000E+04, 9.2328016887E+00, 5.3278524213E+00, 1.1404268676E+00, 8.5261157984E-01, 7.4071803260E-01],
	[1.7890000000E+04, 9.2364926071E+00, 5.3276513410E+00, 1.1414433394E+00, 8.5320595085E-01, 7.4082982917E-01],
	[1.7895000000E+04, 9.2401839691E+00, 5.3274503246E+00, 1.1424604319E+00, 8.5380046467E-01, 7.4094159087E-01],
	[1.7900000000E+04, 9.2438757744E+00, 5.3272493719E+00, 1.1434781452E+00, 8.5439512116E-01, 7.4105331769E-01],
	[1.7905000000E+04, 9.2475680230E+00, 5.3270484829E+00, 1.1444964796E+00, 8.5498992018E-01, 7.4116500963E-01],
	[1.7910000000E+04, 9.2512607149E+00, 5.3268476575E+00, 1.1455154352E+00, 8.5558486156E-01, 7.4127666668E-01],
	[1.7915000000E+04, 9.2549538500E+00, 5.3266468958E+00, 1.1465350122E+00, 8.5617994517E-01, 7.4138828884E-01],
	[1.7920000000E+04, 9.2586474281E+00, 5.3264461977E+00, 1.1475552109E+00, 8.5677517085E-01, 7.4149987610E-01],
	[1.7925000000E+04, 9.2623414493E+00, 5.3262455631E+00, 1.1485760315E+00, 8.5737053846E-01, 7.4161142845E-01],
	[1.7930000000E+04, 9.2660359134E+00, 5.3260449920E+00, 1.1495974741E+00, 8.5796604784E-01, 7.4172294588E-01],
	[1.7935000000E+04, 9.2697308205E+00, 5.3258444844E+00, 1.1506195390E+00, 8.5856169885E-01, 7.4183442839E-01],
	[1.7940000000E+04, 9.2734261703E+00, 5.3256440402E+00, 1.1516422263E+00, 8.5915749134E-01, 7.4194587598E-01],
	[1.7945000000E+04, 9.2771355549E+00, 5.3254483888E+00, 1.1526655363E+00, 8.5975366516E-01, 7.4205728863E-01],
	[1.7950000000E+04, 9.2808469942E+00, 5.3252533572E+00, 1.1536894692E+00, 8.6035000903E-01, 7.4216866634E-01],
	[1.7955000000E+04, 9.2845588840E+00, 5.3250583870E+00, 1.1547140252E+00, 8.6094649450E-01, 7.4228000911E-01],
	[1.7960000000E+04, 9.2882712242E+00, 5.3248634783E+00, 1.1557392045E+00, 8.6154312144E-01, 7.4239131692E-01],
	[1.7965000000E+04, 9.2919840148E+00, 5.3246686310E+00, 1.1567650073E+00, 8.6213988968E-01, 7.4250258977E-01],
	[1.7970000000E+04, 9.2956972557E+00, 5.3244738450E+00, 1.1577914338E+00, 8.6273679908E-01, 7.4261382766E-01],
	[1.7975000000E+04, 9.2994109468E+00, 5.3242791203E+00, 1.1588184842E+00, 8.6333384948E-01, 7.4272503058E-01],
	[1.7980000000E+04, 9.3031250880E+00, 5.3240844569E+00, 1.1598461586E+00, 8.6393104075E-01, 7.4283619853E-01],
	[1.7985000000E+04, 9.3068396794E+00, 5.3238898548E+00, 1.1608744574E+00, 8.6452837273E-01, 7.4294733149E-01],
	[1.7990000000E+04, 9.3105547207E+00, 5.3236953138E+00, 1.1619033808E+00, 8.6512584528E-01, 7.4305842946E-01],
	[1.7995000000E+04, 9.3142702120E+00, 5.3235008340E+00, 1.1629329288E+00, 8.6572345823E-01, 7.4316949244E-01],
	[1.8000000000E+04, 9.3179861531E+00, 5.3233064154E+00, 1.1639631018E+00, 8.6632121145E-01, 7.4328052041E-01],
	[1.8005000000E+04, 9.3217025441E+00, 5.3231120578E+00, 1.1649938999E+00, 8.6691910478E-01, 7.4339151338E-01],
	[1.8010000000E+04, 9.3254193848E+00, 5.3229177613E+00, 1.1660253233E+00, 8.6751713808E-01, 7.4350247134E-01],
	[1.8015000000E+04, 9.3291366751E+00, 5.3227235259E+00, 1.1670573723E+00, 8.6811531119E-01, 7.4361339427E-01],
	[1.8020000000E+04, 9.3328544151E+00, 5.3225293514E+00, 1.1680900470E+00, 8.6871362397E-01, 7.4372428219E-01],
	[1.8025000000E+04, 9.3365726045E+00, 5.3223352378E+00, 1.1691233477E+00, 8.6931207627E-01, 7.4383513507E-01],
	[1.8030000000E+04, 9.3402912434E+00, 5.3221411852E+00, 1.1701572745E+00, 8.6991066793E-01, 7.4394595291E-01],
	[1.8035000000E+04, 9.3440103317E+00, 5.3219471935E+00, 1.1711918277E+00, 8.7050939881E-01, 7.4405673572E-01],
	[1.8040000000E+04, 9.3477298693E+00, 5.3217532626E+00, 1.1722270074E+00, 8.7110826875E-01, 7.4416748348E-01],
	[1.8045000000E+04, 9.3514498561E+00, 5.3215593925E+00, 1.1732628139E+00, 8.7170727761E-01, 7.4427819618E-01],
	[1.8050000000E+04, 9.3551702921E+00, 5.3213655831E+00, 1.1742992474E+00, 8.7230642524E-01, 7.4438887383E-01],
	[1.8055000000E+04, 9.3588911772E+00, 5.3211718345E+00, 1.1753363081E+00, 8.7290571149E-01, 7.4449951641E-01],
	[1.8060000000E+04, 9.3626125113E+00, 5.3209781466E+00, 1.1763739961E+00, 8.7350513620E-01, 7.4461012392E-01],
	[1.8065000000E+04, 9.3663342943E+00, 5.3207845194E+00, 1.1774123118E+00, 8.7410469924E-01, 7.4472069635E-01],
	[1.8070000000E+04, 9.3700565263E+00, 5.3205909528E+00, 1.1784512552E+00, 8.7470440044E-01, 7.4483123371E-01],
	[1.8075000000E+04, 9.3737792071E+00, 5.3203974468E+00, 1.1794908266E+00, 8.7530423965E-01, 7.4494173598E-01],
	[1.8080000000E+04, 9.3775023366E+00, 5.3202040014E+00, 1.1805310263E+00, 8.7590421674E-01, 7.4505220315E-01],
	[1.8085000000E+04, 9.3812259148E+00, 5.3200106164E+00, 1.1815718543E+00, 8.7650433154E-01, 7.4516263523E-01],
	[1.8090000000E+04, 9.3849499415E+00, 5.3198172920E+00, 1.1826133110E+00, 8.7710458391E-01, 7.4527303220E-01],
	[1.8095000000E+04, 9.3886744169E+00, 5.3196240280E+00, 1.1836553964E+00, 8.7770497370E-01, 7.4538339407E-01],
	[1.8100000000E+04, 9.3923993407E+00, 5.3194308244E+00, 1.1846981109E+00, 8.7830550075E-01, 7.4549372082E-01],
	[1.8105000000E+04, 9.3961247129E+00, 5.3192376812E+00, 1.1857414547E+00, 8.7890616492E-01, 7.4560401246E-01],
	[1.8110000000E+04, 9.3998505334E+00, 5.3190445983E+00, 1.1867854278E+00, 8.7950696605E-01, 7.4571426897E-01],
	[1.8115000000E+04, 9.4035768022E+00, 5.3188515758E+00, 1.1878300306E+00, 8.8010790400E-01, 7.4582449035E-01],
	[1.8120000000E+04, 9.4073035191E+00, 5.3186586135E+00, 1.1888752632E+00, 8.8070897862E-01, 7.4593467659E-01],
	[1.8125000000E+04, 9.4110306842E+00, 5.3184657114E+00, 1.1899211259E+00, 8.8131018975E-01, 7.4604482770E-01],
	[1.8130000000E+04, 9.4147582973E+00, 5.3182728696E+00, 1.1909676188E+00, 8.8191153724E-01, 7.4615494366E-01],
	[1.8135000000E+04, 9.4184863584E+00, 5.3180800879E+00, 1.1920147422E+00, 8.8251302094E-01, 7.4626502447E-01],
	[1.8140000000E+04, 9.4222148674E+00, 5.3178873663E+00, 1.1930624963E+00, 8.8311464071E-01, 7.4637507012E-01],
	[1.8145000000E+04, 9.4259438243E+00, 5.3176947049E+00, 1.1941108812E+00, 8.8371639639E-01, 7.4648508061E-01],
	[1.8150000000E+04, 9.4296732289E+00, 5.3175021035E+00, 1.1951598972E+00, 8.8431828783E-01, 7.4659505594E-01],
	[1.8155000000E+04, 9.4334030812E+00, 5.3173095621E+00, 1.1962095444E+00, 8.8492031488E-01, 7.4670499610E-01],
	[1.8160000000E+04, 9.4371333811E+00, 5.3171170807E+00, 1.1972598232E+00, 8.8552247739E-01, 7.4681490108E-01],
	[1.8165000000E+04, 9.4408641286E+00, 5.3169246593E+00, 1.1983107336E+00, 8.8612477521E-01, 7.4692477088E-01],
	[1.8170000000E+04, 9.4445953236E+00, 5.3167322977E+00, 1.1993622759E+00, 8.8672720818E-01, 7.4703460550E-01],
	[1.8175000000E+04, 9.4483269660E+00, 5.3165399961E+00, 1.2004144503E+00, 8.8732977616E-01, 7.4714440492E-01],
	[1.8180000000E+04, 9.4520590558E+00, 5.3163477543E+00, 1.2014672570E+00, 8.8793247900E-01, 7.4725416915E-01],
	[1.8185000000E+04, 9.4557915928E+00, 5.3161555723E+00, 1.2025206962E+00, 8.8853531654E-01, 7.4736389819E-01],
	[1.8190000000E+04, 9.4595245771E+00, 5.3159634501E+00, 1.2035747682E+00, 8.8913828863E-01, 7.4747359201E-01],
	[1.8195000000E+04, 9.4632580085E+00, 5.3157713877E+00, 1.2046294730E+00, 8.8974139513E-01, 7.4758325063E-01],
	[1.8200000000E+04, 9.4669918869E+00, 5.3155793849E+00, 1.2056848110E+00, 8.9034463587E-01, 7.4769287403E-01],
	[1.8205000000E+04, 9.4707262124E+00, 5.3153874419E+00, 1.2067407823E+00, 8.9094801072E-01, 7.4780246221E-01],
	[1.8210000000E+04, 9.4744609848E+00, 5.3151955584E+00, 1.2077973871E+00, 8.9155151951E-01, 7.4791201517E-01],
	[1.8215000000E+04, 9.4781962041E+00, 5.3150037346E+00, 1.2088546257E+00, 8.9215516210E-01, 7.4802153290E-01],
	[1.8220000000E+04, 9.4819318702E+00, 5.3148119703E+00, 1.2099124982E+00, 8.9275893833E-01, 7.4813101540E-01],
	[1.8225000000E+04, 9.4856679830E+00, 5.3146202656E+00, 1.2109710048E+00, 8.9336284806E-01, 7.4824046266E-01],
	[1.8230000000E+04, 9.4894065879E+00, 5.3144293022E+00, 1.2120301458E+00, 8.9396692858E-01, 7.4834987468E-01],
	[1.8235000000E+04, 9.4931592369E+00, 5.3142429282E+00, 1.2130899214E+00, 8.9457139147E-01, 7.4845925145E-01],
	[1.8240000000E+04, 9.4969123404E+00, 5.3140566117E+00, 1.2141503317E+00, 8.9517598799E-01, 7.4856859297E-01],
	[1.8245000000E+04, 9.5006658984E+00, 5.3138703529E+00, 1.2152113770E+00, 8.9578071800E-01, 7.4867789923E-01],
	[1.8250000000E+04, 9.5044199108E+00, 5.3136841516E+00, 1.2162730575E+00, 8.9638558134E-01, 7.4878717023E-01],
	[1.8255000000E+04, 9.5081743776E+00, 5.3134980079E+00, 1.2173353733E+00, 8.9699057787E-01, 7.4889640597E-01],
	[1.8260000000E+04, 9.5119292987E+00, 5.3133119216E+00, 1.2183983247E+00, 8.9759570743E-01, 7.4900560644E-01],
	[1.8265000000E+04, 9.5156846740E+00, 5.3131258928E+00, 1.2194619120E+00, 8.9820096986E-01, 7.4911477164E-01],
	[1.8270000000E+04, 9.5194405034E+00, 5.3129399215E+00, 1.2205261352E+00, 8.9880636503E-01, 7.4922390156E-01],
	[1.8275000000E+04, 9.5231967870E+00, 5.3127540075E+00, 1.2215909946E+00, 8.9941189277E-01, 7.4933299620E-01],
	[1.8280000000E+04, 9.5269535246E+00, 5.3125681509E+00, 1.2226564904E+00, 9.0001755294E-01, 7.4944205555E-01],
	[1.8285000000E+04, 9.5307107161E+00, 5.3123823516E+00, 1.2237226228E+00, 9.0062334539E-01, 7.4955107961E-01],
	[1.8290000000E+04, 9.5344683615E+00, 5.3121966096E+00, 1.2247893920E+00, 9.0122926995E-01, 7.4966006837E-01],
	[1.8295000000E+04, 9.5382264607E+00, 5.3120109249E+00, 1.2258567983E+00, 9.0183532649E-01, 7.4976902184E-01],
	[1.8300000000E+04, 9.5419850136E+00, 5.3118252974E+00, 1.2269248417E+00, 9.0244151485E-01, 7.4987794000E-01],
	[1.8305000000E+04, 9.5457440202E+00, 5.3116397271E+00, 1.2279935226E+00, 9.0304783488E-01, 7.4998682286E-01],
	[1.8310000000E+04, 9.5495034804E+00, 5.3114542140E+00, 1.2290628412E+00, 9.0365428642E-01, 7.5009567040E-01],
	[1.8315000000E+04, 9.5532633942E+00, 5.3112687580E+00, 1.2301327975E+00, 9.0426086933E-01, 7.5020448263E-01],
	[1.8320000000E+04, 9.5570237614E+00, 5.3110833591E+00, 1.2312033920E+00, 9.0486758345E-01, 7.5031325954E-01],
	[1.8325000000E+04, 9.5607845820E+00, 5.3108980173E+00, 1.2322746246E+00, 9.0547442863E-01, 7.5042200113E-01],
	[1.8330000000E+04, 9.5645458559E+00, 5.3107127324E+00, 1.2333464958E+00, 9.0608140472E-01, 7.5053070739E-01],
	[1.8335000000E+04, 9.5683075831E+00, 5.3105275046E+00, 1.2344190056E+00, 9.0668851157E-01, 7.5063937832E-01],
	[1.8340000000E+04, 9.5720697634E+00, 5.3103423338E+00, 1.2354921542E+00, 9.0729574903E-01, 7.5074801391E-01],
	[1.8345000000E+04, 9.5758323969E+00, 5.3101572198E+00, 1.2365659419E+00, 9.0790311694E-01, 7.5085661417E-01],
	[1.8350000000E+04, 9.5795954834E+00, 5.3099721628E+00, 1.2376403689E+00, 9.0851061515E-01, 7.5096517908E-01],
	[1.8355000000E+04, 9.5833590229E+00, 5.3097871626E+00, 1.2387154354E+00, 9.0911824351E-01, 7.5107370864E-01],
	[1.8360000000E+04, 9.5871230154E+00, 5.3096022193E+00, 1.2397911416E+00, 9.0972600187E-01, 7.5118220285E-01],
	[1.8365000000E+04, 9.5908874606E+00, 5.3094173328E+00, 1.2408674877E+00, 9.1033389007E-01, 7.5129066171E-01],
	[1.8370000000E+04, 9.5946523587E+00, 5.3092325030E+00, 1.2419444739E+00, 9.1094190797E-01, 7.5139908521E-01],
	[1.8375000000E+04, 9.5984177094E+00, 5.3090477299E+00, 1.2430221003E+00, 9.1155005541E-01, 7.5150747335E-01],
	[1.8380000000E+04, 9.6021835128E+00, 5.3088630136E+00, 1.2441003673E+00, 9.1215833224E-01, 7.5161582612E-01],
	[1.8385000000E+04, 9.6059497687E+00, 5.3086783539E+00, 1.2451792750E+00, 9.1276673830E-01, 7.5172414353E-01],
	[1.8390000000E+04, 9.6097164771E+00, 5.3084937509E+00, 1.2462588236E+00, 9.1337527345E-01, 7.5183242556E-01],
	[1.8395000000E+04, 9.6134836380E+00, 5.3083092044E+00, 1.2473390134E+00, 9.1398393753E-01, 7.5194067221E-01],
	[1.8400000000E+04, 9.6172512512E+00, 5.3081247146E+00, 1.2484198444E+00, 9.1459273039E-01, 7.5204888348E-01],
	[1.8405000000E+04, 9.6210193167E+00, 5.3079402812E+00, 1.2495013171E+00, 9.1520165188E-01, 7.5215705937E-01],
	[1.8410000000E+04, 9.6247878345E+00, 5.3077559044E+00, 1.2505834314E+00, 9.1581070184E-01, 7.5226519988E-01],
	[1.8415000000E+04, 9.6285568044E+00, 5.3075715840E+00, 1.2516661877E+00, 9.1641988013E-01, 7.5237330499E-01],
	[1.8420000000E+04, 9.6323262264E+00, 5.3073873201E+00, 1.2527495862E+00, 9.1702918658E-01, 7.5248137471E-01],
	[1.8425000000E+04, 9.6360961004E+00, 5.3072031126E+00, 1.2538336270E+00, 9.1763862105E-01, 7.5258940903E-01],
	[1.8430000000E+04, 9.6398664263E+00, 5.3070189614E+00, 1.2549183104E+00, 9.1824818339E-01, 7.5269740794E-01],
	[1.8435000000E+04, 9.6436372041E+00, 5.3068348666E+00, 1.2560036365E+00, 9.1885787343E-01, 7.5280537146E-01],
	[1.8440000000E+04, 9.6474084338E+00, 5.3066508281E+00, 1.2570896056E+00, 9.1946769104E-01, 7.5291329957E-01],
	[1.8445000000E+04, 9.6511801152E+00, 5.3064668459E+00, 1.2581762179E+00, 9.2007763606E-01, 7.5302119226E-01],
	[1.8450000000E+04, 9.6549522482E+00, 5.3062829199E+00, 1.2592634736E+00, 9.2068770832E-01, 7.5312904954E-01],
	[1.8455000000E+04, 9.6587248329E+00, 5.3060990502E+00, 1.2603513729E+00, 9.2129790769E-01, 7.5323687141E-01],
	[1.8460000000E+04, 9.6624978691E+00, 5.3059152366E+00, 1.2614399160E+00, 9.2190823401E-01, 7.5334465785E-01],
	[1.8465000000E+04, 9.6662713568E+00, 5.3057314791E+00, 1.2625291031E+00, 9.2251868712E-01, 7.5345240887E-01],
	[1.8470000000E+04, 9.6700452959E+00, 5.3055477778E+00, 1.2636189343E+00, 9.2312926687E-01, 7.5356012446E-01],
	[1.8475000000E+04, 9.6738196863E+00, 5.3053641325E+00, 1.2647094101E+00, 9.2373997311E-01, 7.5366780462E-01],
	[1.8480000000E+04, 9.6775945280E+00, 5.3051805433E+00, 1.2658005304E+00, 9.2435080569E-01, 7.5377544935E-01],
	[1.8485000000E+04, 9.6813698208E+00, 5.3049970101E+00, 1.2668922955E+00, 9.2496176445E-01, 7.5388305864E-01],
	[1.8490000000E+04, 9.6851455649E+00, 5.3048135329E+00, 1.2679847057E+00, 9.2557284925E-01, 7.5399063249E-01],
	[1.8495000000E+04, 9.6889217599E+00, 5.3046301117E+00, 1.2690777611E+00, 9.2618405991E-01, 7.5409817090E-01],
	[1.8500000000E+04, 9.6926984060E+00, 5.3044467463E+00, 1.2701714620E+00, 9.2679539631E-01, 7.5420567386E-01],
	[1.8505000000E+04, 9.6964755030E+00, 5.3042634369E+00, 1.2712658085E+00, 9.2740685827E-01, 7.5431314137E-01],
	[1.8510000000E+04, 9.7002530508E+00, 5.3040801833E+00, 1.2723608008E+00, 9.2801844565E-01, 7.5442057343E-01],
	[1.8515000000E+04, 9.7040310495E+00, 5.3038969855E+00, 1.2734564392E+00, 9.2863015830E-01, 7.5452797004E-01],
	[1.8520000000E+04, 9.7078094988E+00, 5.3037138435E+00, 1.2745527239E+00, 9.2924199605E-01, 7.5463533119E-01],
	[1.8525000000E+04, 9.7115954352E+00, 5.3035330041E+00, 1.2756496551E+00, 9.2985409234E-01, 7.5474265688E-01],
	[1.8530000000E+04, 9.7153908831E+00, 5.3033551106E+00, 1.2767472329E+00, 9.3046648576E-01, 7.5484994710E-01],
	[1.8535000000E+04, 9.7191867897E+00, 5.3031772710E+00, 1.2778454576E+00, 9.3107900446E-01, 7.5495720186E-01],
	[1.8540000000E+04, 9.7229831550E+00, 5.3029994853E+00, 1.2789443294E+00, 9.3169164827E-01, 7.5506442115E-01],
	[1.8545000000E+04, 9.7267799789E+00, 5.3028217536E+00, 1.2800438485E+00, 9.3230441705E-01, 7.5517160497E-01],
	[1.8550000000E+04, 9.7305772613E+00, 5.3026440757E+00, 1.2811440151E+00, 9.3291731063E-01, 7.5527875331E-01],
	[1.8555000000E+04, 9.7343750021E+00, 5.3024664516E+00, 1.2822448294E+00, 9.3353032887E-01, 7.5538586618E-01],
	[1.8560000000E+04, 9.7381732014E+00, 5.3022888814E+00, 1.2833462916E+00, 9.3414347162E-01, 7.5549294356E-01],
	[1.8565000000E+04, 9.7419718589E+00, 5.3021113649E+00, 1.2844484019E+00, 9.3475673872E-01, 7.5559998546E-01],
	[1.8570000000E+04, 9.7457709747E+00, 5.3019339022E+00, 1.2855511605E+00, 9.3537013001E-01, 7.5570699187E-01],
	[1.8575000000E+04, 9.7495705487E+00, 5.3017564931E+00, 1.2866545677E+00, 9.3598364536E-01, 7.5581396275E-01],
	[1.8580000000E+04, 9.7533705807E+00, 5.3015791378E+00, 1.2877586236E+00, 9.3659728459E-01, 7.5592089810E-01],
	[1.8585000000E+04, 9.7571710709E+00, 5.3014018361E+00, 1.2888633284E+00, 9.3721104756E-01, 7.5602779792E-01],
	[1.8590000000E+04, 9.7609720190E+00, 5.3012245881E+00, 1.2899686824E+00, 9.3782493411E-01, 7.5613466222E-01],
	[1.8595000000E+04, 9.7647734250E+00, 5.3010473936E+00, 1.2910746857E+00, 9.3843894410E-01, 7.5624149098E-01],
	[1.8600000000E+04, 9.7685752888E+00, 5.3008702527E+00, 1.2921813386E+00, 9.3905307737E-01, 7.5634828422E-01],
	[1.8605000000E+04, 9.7723776104E+00, 5.3006931653E+00, 1.2932886413E+00, 9.3966733376E-01, 7.5645504193E-01],
	[1.8610000000E+04, 9.7761803897E+00, 5.3005161314E+00, 1.2943965939E+00, 9.4028171312E-01, 7.5656176411E-01],
	[1.8615000000E+04, 9.7799836267E+00, 5.3003391510E+00, 1.2955051967E+00, 9.4089621530E-01, 7.5666845076E-01],
	[1.8620000000E+04, 9.7837873212E+00, 5.3001622240E+00, 1.2966144498E+00, 9.4151084015E-01, 7.5677510188E-01],
	[1.8625000000E+04, 9.7875914732E+00, 5.2999853504E+00, 1.2977243536E+00, 9.4212558751E-01, 7.5688171748E-01],
	[1.8630000000E+04, 9.7913960826E+00, 5.2998085302E+00, 1.2988349081E+00, 9.4274045722E-01, 7.5698829754E-01],
	[1.8635000000E+04, 9.7952011494E+00, 5.2996317634E+00, 1.2999461137E+00, 9.4335544914E-01, 7.5709484207E-01],
	[1.8640000000E+04, 9.7990066736E+00, 5.2994550498E+00, 1.3010579704E+00, 9.4397056311E-01, 7.5720135108E-01],
	[1.8645000000E+04, 9.8028126549E+00, 5.2992783896E+00, 1.3021704786E+00, 9.4458579898E-01, 7.5730782455E-01],
	[1.8650000000E+04, 9.8066190934E+00, 5.2991017826E+00, 1.3032836384E+00, 9.4520115659E-01, 7.5741426250E-01],
	[1.8655000000E+04, 9.8104259889E+00, 5.2989252288E+00, 1.3043974500E+00, 9.4581663579E-01, 7.5752066492E-01],
	[1.8660000000E+04, 9.8142333416E+00, 5.2987487283E+00, 1.3055119136E+00, 9.4643223643E-01, 7.5762703180E-01],
	[1.8665000000E+04, 9.8180411511E+00, 5.2985722808E+00, 1.3066270294E+00, 9.4704795835E-01, 7.5773336316E-01],
	[1.8670000000E+04, 9.8218494176E+00, 5.2983958866E+00, 1.3077427977E+00, 9.4766380140E-01, 7.5783965899E-01],
	[1.8675000000E+04, 9.8256581408E+00, 5.2982195454E+00, 1.3088592186E+00, 9.4827976542E-01, 7.5794591929E-01],
	[1.8680000000E+04, 9.8294673209E+00, 5.2980432573E+00, 1.3099762924E+00, 9.4889585026E-01, 7.5805214407E-01],
	[1.8685000000E+04, 9.8332769576E+00, 5.2978670222E+00, 1.3110940193E+00, 9.4951205577E-01, 7.5815833331E-01],
	[1.8690000000E+04, 9.8370870509E+00, 5.2976908402E+00, 1.3122123994E+00, 9.5012838180E-01, 7.5826448703E-01],
	[1.8695000000E+04, 9.8408976008E+00, 5.2975147111E+00, 1.3133314329E+00, 9.5074482818E-01, 7.5837060522E-01],
	[1.8700000000E+04, 9.8447086072E+00, 5.2973386350E+00, 1.3144511202E+00, 9.5136139476E-01, 7.5847668788E-01],
	[1.8705000000E+04, 9.8485200699E+00, 5.2971626118E+00, 1.3155714613E+00, 9.5197808140E-01, 7.5858273501E-01],
	[1.8710000000E+04, 9.8523319891E+00, 5.2969866415E+00, 1.3166924881E+00, 9.5259490444E-01, 7.5868874662E-01],
	[1.8715000000E+04, 9.8561443645E+00, 5.2968107241E+00, 1.3178142304E+00, 9.5321187928E-01, 7.5879472269E-01],
	[1.8720000000E+04, 9.8599571961E+00, 5.2966348595E+00, 1.3189366274E+00, 9.5382897375E-01, 7.5890066325E-01],
	[1.8725000000E+04, 9.8637704839E+00, 5.2964590477E+00, 1.3200596792E+00, 9.5444618768E-01, 7.5900656827E-01],
	[1.8730000000E+04, 9.8675842278E+00, 5.2962832887E+00, 1.3211833860E+00, 9.5506352093E-01, 7.5911243777E-01],
	[1.8735000000E+04, 9.8713984276E+00, 5.2961075824E+00, 1.3223077482E+00, 9.5568097333E-01, 7.5921827175E-01],
	[1.8740000000E+04, 9.8752130835E+00, 5.2959319289E+00, 1.3234327658E+00, 9.5629854475E-01, 7.5932407020E-01],
	[1.8745000000E+04, 9.8790281952E+00, 5.2957563280E+00, 1.3245584390E+00, 9.5691623501E-01, 7.5942983313E-01],
	[1.8750000000E+04, 9.8828437627E+00, 5.2955807798E+00, 1.3256847682E+00, 9.5753404397E-01, 7.5953556053E-01],
	[1.8755000000E+04, 9.8866597859E+00, 5.2954052842E+00, 1.3268117534E+00, 9.5815197148E-01, 7.5964125241E-01],
	[1.8760000000E+04, 9.8904762649E+00, 5.2952298411E+00, 1.3279393949E+00, 9.5877001737E-01, 7.5974690877E-01],
	[1.8765000000E+04, 9.8942931994E+00, 5.2950544507E+00, 1.3290676929E+00, 9.5938818150E-01, 7.5985252960E-01],
	[1.8770000000E+04, 9.8981105895E+00, 5.2948791128E+00, 1.3301966476E+00, 9.6000646371E-01, 7.5995811491E-01],
	[1.8775000000E+04, 9.9019284350E+00, 5.2947038274E+00, 1.3313262592E+00, 9.6062486384E-01, 7.6006366470E-01],
	[1.8780000000E+04, 9.9057467360E+00, 5.2945285944E+00, 1.3324565279E+00, 9.6124338175E-01, 7.6016917897E-01],
	[1.8785000000E+04, 9.9095654923E+00, 5.2943534139E+00, 1.3335874539E+00, 9.6186201727E-01, 7.6027465772E-01],
	[1.8790000000E+04, 9.9133847039E+00, 5.2941782859E+00, 1.3347190375E+00, 9.6248077025E-01, 7.6038010095E-01],
	[1.8795000000E+04, 9.9172043707E+00, 5.2940032102E+00, 1.3358512788E+00, 9.6309964054E-01, 7.6048550867E-01],
	[1.8800000000E+04, 9.9210244927E+00, 5.2938281869E+00, 1.3369841780E+00, 9.6371862798E-01, 7.6059088086E-01],
	[1.8805000000E+04, 9.9248450697E+00, 5.2936532159E+00, 1.3381177354E+00, 9.6433773242E-01, 7.6069621754E-01],
	[1.8810000000E+04, 9.9286661017E+00, 5.2934782971E+00, 1.3392519511E+00, 9.6495695371E-01, 7.6080151870E-01],
	[1.8815000000E+04, 9.9324875887E+00, 5.2933034307E+00, 1.3403868254E+00, 9.6557629168E-01, 7.6090678434E-01],
	[1.8820000000E+04, 9.9363095305E+00, 5.2931286165E+00, 1.3415223585E+00, 9.6619574619E-01, 7.6101201447E-01],
	[1.8825000000E+04, 9.9401451498E+00, 5.2929579007E+00, 1.3426585505E+00, 9.6681557717E-01, 7.6111720909E-01],
	[1.8830000000E+04, 9.9439845608E+00, 5.2927882543E+00, 1.3437954017E+00, 9.6743559043E-01, 7.6122236819E-01],
	[1.8835000000E+04, 9.9478244347E+00, 5.2926186583E+00, 1.3449329122E+00, 9.6805572041E-01, 7.6132749178E-01],
	[1.8840000000E+04, 9.9516647717E+00, 5.2924491129E+00, 1.3460710824E+00, 9.6867596694E-01, 7.6143257985E-01],
	[1.8845000000E+04, 9.9555055715E+00, 5.2922796178E+00, 1.3472099124E+00, 9.6929632987E-01, 7.6153763242E-01],
	[1.8850000000E+04, 9.9593468342E+00, 5.2921101732E+00, 1.3483494023E+00, 9.6991680904E-01, 7.6164264948E-01],
	[1.8855000000E+04, 9.9631885596E+00, 5.2919407789E+00, 1.3494895525E+00, 9.7053740431E-01, 7.6174763102E-01],
	[1.8860000000E+04, 9.9670307478E+00, 5.2917714349E+00, 1.3506303631E+00, 9.7115811551E-01, 7.6185257706E-01],
	[1.8865000000E+04, 9.9708733985E+00, 5.2916021412E+00, 1.3517718343E+00, 9.7177894250E-01, 7.6195748759E-01],
	[1.8870000000E+04, 9.9747165119E+00, 5.2914328979E+00, 1.3529139663E+00, 9.7239988512E-01, 7.6206236262E-01],
	[1.8875000000E+04, 9.9785600877E+00, 5.2912637047E+00, 1.3540567594E+00, 9.7302094321E-01, 7.6216720214E-01],
	[1.8880000000E+04, 9.9824041260E+00, 5.2910945618E+00, 1.3552002137E+00, 9.7364211662E-01, 7.6227200616E-01],
	[1.8885000000E+04, 9.9862486266E+00, 5.2909254691E+00, 1.3563443294E+00, 9.7426340520E-01, 7.6237677467E-01],
	[1.8890000000E+04, 9.9900935896E+00, 5.2907564266E+00, 1.3574891068E+00, 9.7488480879E-01, 7.6248150768E-01],
	[1.8895000000E+04, 9.9939390147E+00, 5.2905874341E+00, 1.3586345461E+00, 9.7550632723E-01, 7.6258620519E-01],
	[1.8900000000E+04, 9.9977849021E+00, 5.2904184918E+00, 1.3597806474E+00, 9.7612796037E-01, 7.6269086720E-01],
	[1.8905000000E+04, 1.0001631252E+01, 5.2902495996E+00, 1.3609274110E+00, 9.7674970806E-01, 7.6279549372E-01],
	[1.8910000000E+04, 1.0005478063E+01, 5.2900807574E+00, 1.3620748371E+00, 9.7737157015E-01, 7.6290008473E-01],
	[1.8915000000E+04, 1.0009325336E+01, 5.2899119653E+00, 1.3632229258E+00, 9.7799354647E-01, 7.6300464025E-01],
	[1.8920000000E+04, 1.0013173072E+01, 5.2897432231E+00, 1.3643716775E+00, 9.7861563687E-01, 7.6310916027E-01],
	[1.8925000000E+04, 1.0017021269E+01, 5.2895745309E+00, 1.3655210922E+00, 9.7923784120E-01, 7.6321364480E-01],
	[1.8930000000E+04, 1.0020869928E+01, 5.2894058887E+00, 1.3666711703E+00, 9.7986015931E-01, 7.6331809384E-01],
	[1.8935000000E+04, 1.0024719048E+01, 5.2892372964E+00, 1.3678219118E+00, 9.8048259103E-01, 7.6342250738E-01],
	[1.8940000000E+04, 1.0028568631E+01, 5.2890687539E+00, 1.3689733171E+00, 9.8110513622E-01, 7.6352688543E-01],
	[1.8945000000E+04, 1.0032418675E+01, 5.2889002613E+00, 1.3701253863E+00, 9.8172779471E-01, 7.6363122800E-01],
	[1.8950000000E+04, 1.0036269180E+01, 5.2887318186E+00, 1.3712781197E+00, 9.8235056636E-01, 7.6373553508E-01],
	[1.8955000000E+04, 1.0040120147E+01, 5.2885634256E+00, 1.3724315173E+00, 9.8297345101E-01, 7.6383980667E-01],
	[1.8960000000E+04, 1.0043971575E+01, 5.2883950824E+00, 1.3735855795E+00, 9.8359644850E-01, 7.6394404277E-01],
	[1.8965000000E+04, 1.0047823464E+01, 5.2882267890E+00, 1.3747403065E+00, 9.8421955868E-01, 7.6404824340E-01],
	[1.8970000000E+04, 1.0051675815E+01, 5.2880585452E+00, 1.3758956984E+00, 9.8484278140E-01, 7.6415240854E-01],
	[1.8975000000E+04, 1.0055528627E+01, 5.2878903512E+00, 1.3770517555E+00, 9.8546611649E-01, 7.6425653820E-01],
	[1.8980000000E+04, 1.0059381900E+01, 5.2877222068E+00, 1.3782084780E+00, 9.8608956381E-01, 7.6436063238E-01],
	[1.8985000000E+04, 1.0063235634E+01, 5.2875541121E+00, 1.3793658660E+00, 9.8671312320E-01, 7.6446469108E-01],
	[1.8990000000E+04, 1.0067089828E+01, 5.2873860669E+00, 1.3805239198E+00, 9.8733679450E-01, 7.6456871430E-01],
	[1.8995000000E+04, 1.0070944484E+01, 5.2872180714E+00, 1.3816826396E+00, 9.8796057756E-01, 7.6467270206E-01],
	[1.9000000000E+04, 1.0074799601E+01, 5.2870501254E+00, 1.3828420256E+00, 9.8858447223E-01, 7.6477665433E-01],
	[1.9005000000E+04, 1.0078655178E+01, 5.2868822289E+00, 1.3840020780E+00, 9.8920847834E-01, 7.6488057114E-01],
	[1.9010000000E+04, 1.0082511217E+01, 5.2867143819E+00, 1.3851627970E+00, 9.8983259575E-01, 7.6498445247E-01],
	[1.9015000000E+04, 1.0086367715E+01, 5.2865465844E+00, 1.3863241829E+00, 9.9045682430E-01, 7.6508829834E-01],
	[1.9020000000E+04, 1.0090224675E+01, 5.2863788363E+00, 1.3874862357E+00, 9.9108116383E-01, 7.6519210874E-01],
	[1.9025000000E+04, 1.0094082095E+01, 5.2862111376E+00, 1.3886489558E+00, 9.9170561418E-01, 7.6529588367E-01],
	[1.9030000000E+04, 1.0097939975E+01, 5.2860434883E+00, 1.3898123433E+00, 9.9233017522E-01, 7.6539962314E-01],
	[1.9035000000E+04, 1.0101798316E+01, 5.2858758884E+00, 1.3909763985E+00, 9.9295484677E-01, 7.6550332715E-01],
	[1.9040000000E+04, 1.0105657116E+01, 5.2857083378E+00, 1.3921411215E+00, 9.9357962868E-01, 7.6560699570E-01],
	[1.9045000000E+04, 1.0109516378E+01, 5.2855408365E+00, 1.3933065126E+00, 9.9420452080E-01, 7.6571062878E-01],
	[1.9050000000E+04, 1.0113376099E+01, 5.2853733845E+00, 1.3944725719E+00, 9.9482952297E-01, 7.6581422641E-01],
	[1.9055000000E+04, 1.0117236281E+01, 5.2852059818E+00, 1.3956392997E+00, 9.9545463504E-01, 7.6591778859E-01],
	[1.9060000000E+04, 1.0121096922E+01, 5.2850386282E+00, 1.3968066962E+00, 9.9607985685E-01, 7.6602131531E-01],
	[1.9065000000E+04, 1.0124958024E+01, 5.2848713238E+00, 1.3979747616E+00, 9.9670518824E-01, 7.6612480658E-01],
	[1.9070000000E+04, 1.0128819585E+01, 5.2847040687E+00, 1.3991434960E+00, 9.9733062907E-01, 7.6622826240E-01],
	[1.9075000000E+04, 1.0132681606E+01, 5.2845368626E+00, 1.4003128998E+00, 9.9795617917E-01, 7.6633168277E-01],
	[1.9080000000E+04, 1.0136544087E+01, 5.2843697057E+00, 1.4014829730E+00, 9.9858183839E-01, 7.6643506769E-01],
	[1.9085000000E+04, 1.0140407028E+01, 5.2842025978E+00, 1.4026537160E+00, 9.9920760658E-01, 7.6653841717E-01],
	[1.9090000000E+04, 1.0144270429E+01, 5.2840355390E+00, 1.4038251289E+00, 9.9983348357E-01, 7.6664173121E-01],
	[1.9095000000E+04, 1.0148134289E+01, 5.2838685292E+00, 1.4049972119E+00, 1.0004594692E+00, 7.6674500980E-01],
	[1.9100000000E+04, 1.0151998608E+01, 5.2837015685E+00, 1.4061699653E+00, 1.0010855634E+00, 7.6684825296E-01],
	[1.9105000000E+04, 1.0155863387E+01, 5.2835346567E+00, 1.4073433891E+00, 1.0017117659E+00, 7.6695146068E-01],
	[1.9110000000E+04, 1.0159728625E+01, 5.2833677938E+00, 1.4085174838E+00, 1.0023380765E+00, 7.6705463296E-01],
	[1.9115000000E+04, 1.0163594323E+01, 5.2832009799E+00, 1.4096922493E+00, 1.0029644952E+00, 7.6715776982E-01],
	[1.9120000000E+04, 1.0167460480E+01, 5.2830342149E+00, 1.4108676861E+00, 1.0035910218E+00, 7.6726087124E-01],
	[1.9125000000E+04, 1.0171330505E+01, 5.2828684992E+00, 1.4120437942E+00, 1.0042177255E+00, 7.6736393723E-01],
	[1.9130000000E+04, 1.0175214602E+01, 5.2827068246E+00, 1.4132205738E+00, 1.0048448141E+00, 7.6746696779E-01],
	[1.9135000000E+04, 1.0179099166E+01, 5.2825451972E+00, 1.4143980253E+00, 1.0054720107E+00, 7.6756996293E-01],
	[1.9140000000E+04, 1.0182984197E+01, 5.2823836170E+00, 1.4155761487E+00, 1.0060993153E+00, 7.6767292264E-01],
	[1.9145000000E+04, 1.0186869696E+01, 5.2822220839E+00, 1.4167549444E+00, 1.0067267276E+00, 7.6777584694E-01],
	[1.9150000000E+04, 1.0190755662E+01, 5.2820605979E+00, 1.4179344124E+00, 1.0073542475E+00, 7.6787873581E-01],
	[1.9155000000E+04, 1.0194642096E+01, 5.2818991591E+00, 1.4191145530E+00, 1.0079818749E+00, 7.6798158927E-01],
	[1.9160000000E+04, 1.0198528997E+01, 5.2817377673E+00, 1.4202953665E+00, 1.0086096095E+00, 7.6808440731E-01],
	[1.9165000000E+04, 1.0202416365E+01, 5.2815764225E+00, 1.4214768530E+00, 1.0092374513E+00, 7.6818718994E-01],
	[1.9170000000E+04, 1.0206304200E+01, 5.2814151248E+00, 1.4226590127E+00, 1.0098654001E+00, 7.6828993717E-01],
	[1.9175000000E+04, 1.0210192502E+01, 5.2812538740E+00, 1.4238418458E+00, 1.0104934557E+00, 7.6839264898E-01],
	[1.9180000000E+04, 1.0214081272E+01, 5.2810926702E+00, 1.4250253526E+00, 1.0111216180E+00, 7.6849532538E-01],
	[1.9185000000E+04, 1.0217970508E+01, 5.2809315134E+00, 1.4262095332E+00, 1.0117498868E+00, 7.6859796639E-01],
	[1.9190000000E+04, 1.0221860211E+01, 5.2807704034E+00, 1.4273943879E+00, 1.0123782619E+00, 7.6870057199E-01],
	[1.9195000000E+04, 1.0225750380E+01, 5.2806093404E+00, 1.4285799168E+00, 1.0130067433E+00, 7.6880314219E-01],
	[1.9200000000E+04, 1.0229641017E+01, 5.2804483242E+00, 1.4297661202E+00, 1.0136353307E+00, 7.6890567700E-01],
	[1.9205000000E+04, 1.0233532120E+01, 5.2802873548E+00, 1.4309529983E+00, 1.0142640240E+00, 7.6900817641E-01],
	[1.9210000000E+04, 1.0237423690E+01, 5.2801264323E+00, 1.4321405513E+00, 1.0148928230E+00, 7.6911064043E-01],
	[1.9215000000E+04, 1.0241315726E+01, 5.2799655565E+00, 1.4333287794E+00, 1.0155217276E+00, 7.6921306906E-01],
	[1.9220000000E+04, 1.0245208229E+01, 5.2798047275E+00, 1.4345176827E+00, 1.0161507377E+00, 7.6931546230E-01],
	[1.9225000000E+04, 1.0249101198E+01, 5.2796439452E+00, 1.4357072616E+00, 1.0167798530E+00, 7.6941782015E-01],
	[1.9230000000E+04, 1.0252994633E+01, 5.2794832096E+00, 1.4368975162E+00, 1.0174090734E+00, 7.6952014263E-01],
	[1.9235000000E+04, 1.0256888535E+01, 5.2793225207E+00, 1.4380884467E+00, 1.0180383988E+00, 7.6962242972E-01],
	[1.9240000000E+04, 1.0260782903E+01, 5.2791618785E+00, 1.4392800533E+00, 1.0186678290E+00, 7.6972468143E-01],
	[1.9245000000E+04, 1.0264677737E+01, 5.2790012828E+00, 1.4404723363E+00, 1.0192973639E+00, 7.6982689777E-01],
	[1.9250000000E+04, 1.0268573037E+01, 5.2788407338E+00, 1.4416652958E+00, 1.0199270032E+00, 7.6992907874E-01],
	[1.9255000000E+04, 1.0272468803E+01, 5.2786802314E+00, 1.4428589320E+00, 1.0205567469E+00, 7.7003122434E-01],
	[1.9260000000E+04, 1.0276365035E+01, 5.2785197755E+00, 1.4440532452E+00, 1.0211865948E+00, 7.7013333456E-01],
	[1.9265000000E+04, 1.0280261733E+01, 5.2783593661E+00, 1.4452482356E+00, 1.0218165467E+00, 7.7023540943E-01],
	[1.9270000000E+04, 1.0284158897E+01, 5.2781990032E+00, 1.4464439033E+00, 1.0224466025E+00, 7.7033744891E-01],
	[1.9275000000E+04, 1.0288056526E+01, 5.2780386868E+00, 1.4476402486E+00, 1.0230767620E+00, 7.7043945298E-01],
	[1.9280000000E+04, 1.0291954621E+01, 5.2778784169E+00, 1.4488372717E+00, 1.0237070250E+00, 7.7054142162E-01],
	[1.9285000000E+04, 1.0295853182E+01, 5.2777181934E+00, 1.4500349728E+00, 1.0243373915E+00, 7.7064335482E-01],
	[1.9290000000E+04, 1.0299752208E+01, 5.2775580163E+00, 1.4512333521E+00, 1.0249678612E+00, 7.7074525259E-01],
	[1.9295000000E+04, 1.0303651700E+01, 5.2773978855E+00, 1.4524324097E+00, 1.0255984340E+00, 7.7084711492E-01],
	[1.9300000000E+04, 1.0307551657E+01, 5.2772378011E+00, 1.4536321460E+00, 1.0262291098E+00, 7.7094894182E-01],
	[1.9305000000E+04, 1.0311452080E+01, 5.2770777630E+00, 1.4548325612E+00, 1.0268598883E+00, 7.7105073327E-01],
	[1.9310000000E+04, 1.0315352967E+01, 5.2769177712E+00, 1.4560336553E+00, 1.0274907695E+00, 7.7115248927E-01],
	[1.9315000000E+04, 1.0319254320E+01, 5.2767578257E+00, 1.4572354287E+00, 1.0281217531E+00, 7.7125420983E-01],
	[1.9320000000E+04, 1.0323156139E+01, 5.2765979264E+00, 1.4584378815E+00, 1.0287528390E+00, 7.7135589494E-01],
	[1.9325000000E+04, 1.0327058422E+01, 5.2764380734E+00, 1.4596410139E+00, 1.0293840271E+00, 7.7145754460E-01],
	[1.9330000000E+04, 1.0330961170E+01, 5.2762782665E+00, 1.4608448262E+00, 1.0300153172E+00, 7.7155915880E-01],
	[1.9335000000E+04, 1.0334864383E+01, 5.2761185059E+00, 1.4620493186E+00, 1.0306467092E+00, 7.7166073755E-01],
	[1.9340000000E+04, 1.0338768061E+01, 5.2759587913E+00, 1.4632544913E+00, 1.0312782029E+00, 7.7176228084E-01],
	[1.9345000000E+04, 1.0342672204E+01, 5.2757991229E+00, 1.4644603444E+00, 1.0319097980E+00, 7.7186378866E-01],
	[1.9350000000E+04, 1.0346576812E+01, 5.2756395006E+00, 1.4656668782E+00, 1.0325414946E+00, 7.7196526102E-01],
	[1.9355000000E+04, 1.0350481885E+01, 5.2754799243E+00, 1.4668740929E+00, 1.0331732924E+00, 7.7206669792E-01],
	[1.9360000000E+04, 1.0354387422E+01, 5.2753203941E+00, 1.4680819887E+00, 1.0338051913E+00, 7.7216809935E-01],
	[1.9365000000E+04, 1.0358293423E+01, 5.2751609099E+00, 1.4692905658E+00, 1.0344371911E+00, 7.7226946530E-01],
	[1.9370000000E+04, 1.0362199889E+01, 5.2750014717E+00, 1.4704998244E+00, 1.0350692916E+00, 7.7237079579E-01],
	[1.9375000000E+04, 1.0366106820E+01, 5.2748420794E+00, 1.4717097648E+00, 1.0357014927E+00, 7.7247209080E-01],
	[1.9380000000E+04, 1.0370014215E+01, 5.2746827331E+00, 1.4729203870E+00, 1.0363337943E+00, 7.7257335033E-01],
	[1.9385000000E+04, 1.0373922074E+01, 5.2745234327E+00, 1.4741316914E+00, 1.0369661962E+00, 7.7267457438E-01],
	[1.9390000000E+04, 1.0377830398E+01, 5.2743641783E+00, 1.4753436782E+00, 1.0375986982E+00, 7.7277576295E-01],
	[1.9395000000E+04, 1.0381739185E+01, 5.2742049696E+00, 1.4765563475E+00, 1.0382313002E+00, 7.7287691604E-01],
	[1.9400000000E+04, 1.0385648437E+01, 5.2740458069E+00, 1.4777696995E+00, 1.0388640020E+00, 7.7297803364E-01],
	[1.9405000000E+04, 1.0389558153E+01, 5.2738866899E+00, 1.4789837345E+00, 1.0394968035E+00, 7.7307911576E-01],
	[1.9410000000E+04, 1.0393468333E+01, 5.2737276187E+00, 1.4801984527E+00, 1.0401297044E+00, 7.7318016239E-01],
	[1.9415000000E+04, 1.0397378977E+01, 5.2735685933E+00, 1.4814138543E+00, 1.0407627048E+00, 7.7328117352E-01],
	[1.9420000000E+04, 1.0401290084E+01, 5.2734096137E+00, 1.4826299394E+00, 1.0413958043E+00, 7.7338214917E-01],
	[1.9425000000E+04, 1.0405201656E+01, 5.2732506797E+00, 1.4838467084E+00, 1.0420290029E+00, 7.7348308931E-01],
	[1.9430000000E+04, 1.0409113691E+01, 5.2730917915E+00, 1.4850641613E+00, 1.0426623004E+00, 7.7358399396E-01],
	[1.9435000000E+04, 1.0413037145E+01, 5.2729360320E+00, 1.4862822985E+00, 1.0432959272E+00, 7.7368486312E-01],
	[1.9440000000E+04, 1.0416967606E+01, 5.2727821567E+00, 1.4875011201E+00, 1.0439297909E+00, 7.7378569677E-01],
	[1.9445000000E+04, 1.0420898540E+01, 5.2726283254E+00, 1.4887206263E+00, 1.0445637536E+00, 7.7388649492E-01],
	[1.9450000000E+04, 1.0424829946E+01, 5.2724745382E+00, 1.4899408173E+00, 1.0451978153E+00, 7.7398725757E-01],
	[1.9455000000E+04, 1.0428761824E+01, 5.2723207950E+00, 1.4911616934E+00, 1.0458319758E+00, 7.7408798471E-01],
	[1.9460000000E+04, 1.0432694174E+01, 5.2721670958E+00, 1.4923832547E+00, 1.0464662349E+00, 7.7418867634E-01],
	[1.9465000000E+04, 1.0436626996E+01, 5.2720134405E+00, 1.4936055015E+00, 1.0471005924E+00, 7.7428933247E-01],
	[1.9470000000E+04, 1.0440560290E+01, 5.2718598292E+00, 1.4948284339E+00, 1.0477350483E+00, 7.7438995309E-01],
	[1.9475000000E+04, 1.0444494056E+01, 5.2717062618E+00, 1.4960520522E+00, 1.0483696024E+00, 7.7449053819E-01],
	[1.9480000000E+04, 1.0448428294E+01, 5.2715527383E+00, 1.4972763566E+00, 1.0490042544E+00, 7.7459108778E-01],
	[1.9485000000E+04, 1.0452363003E+01, 5.2713992587E+00, 1.4985013472E+00, 1.0496390044E+00, 7.7469160185E-01],
	[1.9490000000E+04, 1.0456298184E+01, 5.2712458229E+00, 1.4997270244E+00, 1.0502738520E+00, 7.7479208041E-01],
	[1.9495000000E+04, 1.0460233836E+01, 5.2710924309E+00, 1.5009533882E+00, 1.0509087971E+00, 7.7489252345E-01],
	[1.9500000000E+04, 1.0464169960E+01, 5.2709390828E+00, 1.5021804390E+00, 1.0515438397E+00, 7.7499293098E-01],
	[1.9505000000E+04, 1.0468106555E+01, 5.2707857784E+00, 1.5034081769E+00, 1.0521789795E+00, 7.7509330298E-01],
	[1.9510000000E+04, 1.0472043622E+01, 5.2706325177E+00, 1.5046366020E+00, 1.0528142163E+00, 7.7519363945E-01],
	[1.9515000000E+04, 1.0475981160E+01, 5.2704793008E+00, 1.5058657148E+00, 1.0534495501E+00, 7.7529394041E-01],
	[1.9520000000E+04, 1.0479919170E+01, 5.2703261276E+00, 1.5070955152E+00, 1.0540849806E+00, 7.7539420584E-01],
	[1.9525000000E+04, 1.0483857650E+01, 5.2701729981E+00, 1.5083260036E+00, 1.0547205078E+00, 7.7549443574E-01],
	[1.9530000000E+04, 1.0487796602E+01, 5.2700199122E+00, 1.5095571802E+00, 1.0553561314E+00, 7.7559463012E-01],
	[1.9535000000E+04, 1.0491736024E+01, 5.2698668700E+00, 1.5107890451E+00, 1.0559918512E+00, 7.7569478897E-01],
	[1.9540000000E+04, 1.0495675918E+01, 5.2697138713E+00, 1.5120215986E+00, 1.0566276673E+00, 7.7579491228E-01],
	[1.9545000000E+04, 1.0499616282E+01, 5.2695609163E+00, 1.5132548408E+00, 1.0572635793E+00, 7.7589500007E-01],
	[1.9550000000E+04, 1.0503557118E+01, 5.2694080048E+00, 1.5144887721E+00, 1.0578995871E+00, 7.7599505233E-01],
	[1.9555000000E+04, 1.0507498424E+01, 5.2692551369E+00, 1.5157233925E+00, 1.0585356907E+00, 7.7609506905E-01],
	[1.9560000000E+04, 1.0511440201E+01, 5.2691023124E+00, 1.5169587023E+00, 1.0591718897E+00, 7.7619505023E-01],
	[1.9565000000E+04, 1.0515382449E+01, 5.2689495315E+00, 1.5181947018E+00, 1.0598081841E+00, 7.7629499588E-01],
	[1.9570000000E+04, 1.0519325167E+01, 5.2687967940E+00, 1.5194313910E+00, 1.0604445737E+00, 7.7639490600E-01],
	[1.9575000000E+04, 1.0523268355E+01, 5.2686441000E+00, 1.5206687703E+00, 1.0610810583E+00, 7.7649478057E-01],
	[1.9580000000E+04, 1.0527212015E+01, 5.2684914494E+00, 1.5219068398E+00, 1.0617176379E+00, 7.7659461961E-01],
	[1.9585000000E+04, 1.0531156144E+01, 5.2683388422E+00, 1.5231455997E+00, 1.0623543122E+00, 7.7669442311E-01],
	[1.9590000000E+04, 1.0535100744E+01, 5.2681862784E+00, 1.5243850503E+00, 1.0629910810E+00, 7.7679419107E-01],
	[1.9595000000E+04, 1.0539045814E+01, 5.2680337579E+00, 1.5256251917E+00, 1.0636279443E+00, 7.7689392348E-01],
	[1.9600000000E+04, 1.0542991355E+01, 5.2678812807E+00, 1.5268660242E+00, 1.0642649019E+00, 7.7699362036E-01],
	[1.9605000000E+04, 1.0546937366E+01, 5.2677288469E+00, 1.5281075480E+00, 1.0649019536E+00, 7.7709328169E-01],
	[1.9610000000E+04, 1.0550883846E+01, 5.2675764563E+00, 1.5293497632E+00, 1.0655390992E+00, 7.7719290747E-01],
	[1.9615000000E+04, 1.0554830797E+01, 5.2674241090E+00, 1.5305926701E+00, 1.0661763386E+00, 7.7729249771E-01],
	[1.9620000000E+04, 1.0558778218E+01, 5.2672718049E+00, 1.5318362689E+00, 1.0668136717E+00, 7.7739205241E-01],
	[1.9625000000E+04, 1.0562726108E+01, 5.2671195440E+00, 1.5330805598E+00, 1.0674510983E+00, 7.7749157156E-01],
	[1.9630000000E+04, 1.0566674469E+01, 5.2669673263E+00, 1.5343255430E+00, 1.0680886182E+00, 7.7759105516E-01],
	[1.9635000000E+04, 1.0570623299E+01, 5.2668151518E+00, 1.5355712187E+00, 1.0687262313E+00, 7.7769050321E-01],
	[1.9640000000E+04, 1.0574572599E+01, 5.2666630204E+00, 1.5368175871E+00, 1.0693639375E+00, 7.7778991572E-01],
	[1.9645000000E+04, 1.0578522368E+01, 5.2665109322E+00, 1.5380646485E+00, 1.0700017364E+00, 7.7788929267E-01],
	[1.9650000000E+04, 1.0582472607E+01, 5.2663588870E+00, 1.5393124030E+00, 1.0706396281E+00, 7.7798863408E-01],
	[1.9655000000E+04, 1.0586423316E+01, 5.2662068849E+00, 1.5405608509E+00, 1.0712776124E+00, 7.7808793993E-01],
	[1.9660000000E+04, 1.0590374494E+01, 5.2660549259E+00, 1.5418099923E+00, 1.0719156891E+00, 7.7818721024E-01],
	[1.9665000000E+04, 1.0594326142E+01, 5.2659030098E+00, 1.5430598274E+00, 1.0725538580E+00, 7.7828644499E-01],
	[1.9670000000E+04, 1.0598278259E+01, 5.2657511368E+00, 1.5443103566E+00, 1.0731921190E+00, 7.7838564419E-01],
	[1.9675000000E+04, 1.0602230845E+01, 5.2655993068E+00, 1.5455615799E+00, 1.0738304719E+00, 7.7848480784E-01],
	[1.9680000000E+04, 1.0606183900E+01, 5.2654475197E+00, 1.5468134976E+00, 1.0744689166E+00, 7.7858393593E-01],
	[1.9685000000E+04, 1.0610137424E+01, 5.2652957755E+00, 1.5480661099E+00, 1.0751074529E+00, 7.7868302847E-01],
	[1.9690000000E+04, 1.0614091418E+01, 5.2651440743E+00, 1.5493194169E+00, 1.0757460807E+00, 7.7878208546E-01],
	[1.9695000000E+04, 1.0618045880E+01, 5.2649924159E+00, 1.5505734190E+00, 1.0763847998E+00, 7.7888110689E-01],
	[1.9700000000E+04, 1.0622000812E+01, 5.2648408004E+00, 1.5518281163E+00, 1.0770236100E+00, 7.7898009277E-01],
	[1.9705000000E+04, 1.0625956212E+01, 5.2646892278E+00, 1.5530835091E+00, 1.0776625113E+00, 7.7907904309E-01],
	[1.9710000000E+04, 1.0629912081E+01, 5.2645376979E+00, 1.5543395974E+00, 1.0783015034E+00, 7.7917795786E-01],
	[1.9715000000E+04, 1.0633868419E+01, 5.2643862109E+00, 1.5555963816E+00, 1.0789405861E+00, 7.7927683707E-01],
	[1.9720000000E+04, 1.0637825226E+01, 5.2642347666E+00, 1.5568538619E+00, 1.0795797595E+00, 7.7937568073E-01],
	[1.9725000000E+04, 1.0641782501E+01, 5.2640833651E+00, 1.5581120384E+00, 1.0802190231E+00, 7.7947448883E-01],
	[1.9730000000E+04, 1.0645740245E+01, 5.2639320063E+00, 1.5593709113E+00, 1.0808583770E+00, 7.7957326137E-01],
	[1.9735000000E+04, 1.0649698457E+01, 5.2637806902E+00, 1.5606304810E+00, 1.0814978210E+00, 7.7967199836E-01],
	[1.9740000000E+04, 1.0653657137E+01, 5.2636294168E+00, 1.5618907475E+00, 1.0821373548E+00, 7.7977069979E-01],
	[1.9745000000E+04, 1.0657617382E+01, 5.2634784819E+00, 1.5631517111E+00, 1.0827770023E+00, 7.7986936567E-01],
	[1.9750000000E+04, 1.0661594976E+01, 5.2633321470E+00, 1.5644133720E+00, 1.0834171068E+00, 7.7996799598E-01],
	[1.9755000000E+04, 1.0665573046E+01, 5.2631858533E+00, 1.5656757304E+00, 1.0840573014E+00, 7.8006659074E-01],
	[1.9760000000E+04, 1.0669551594E+01, 5.2630396006E+00, 1.5669387865E+00, 1.0846975860E+00, 7.8016514995E-01],
	[1.9765000000E+04, 1.0673530619E+01, 5.2628933890E+00, 1.5682025406E+00, 1.0853379605E+00, 7.8026367359E-01],
	[1.9770000000E+04, 1.0677510120E+01, 5.2627472184E+00, 1.5694669927E+00, 1.0859784246E+00, 7.8036216168E-01],
	[1.9775000000E+04, 1.0681490099E+01, 5.2626010889E+00, 1.5707321432E+00, 1.0866189782E+00, 7.8046061422E-01],
	[1.9780000000E+04, 1.0685470554E+01, 5.2624550003E+00, 1.5719979922E+00, 1.0872596212E+00, 7.8055903119E-01],
	[1.9785000000E+04, 1.0689451486E+01, 5.2623089528E+00, 1.5732645400E+00, 1.0879003534E+00, 7.8065741261E-01],
	[1.9790000000E+04, 1.0693432894E+01, 5.2621629462E+00, 1.5745317868E+00, 1.0885411746E+00, 7.8075575847E-01],
	[1.9795000000E+04, 1.0697414779E+01, 5.2620169805E+00, 1.5757997327E+00, 1.0891820847E+00, 7.8085406878E-01],
	[1.9800000000E+04, 1.0701397141E+01, 5.2618710557E+00, 1.5770683780E+00, 1.0898230836E+00, 7.8095234353E-01],
	[1.9805000000E+04, 1.0705379979E+01, 5.2617251718E+00, 1.5783377229E+00, 1.0904641710E+00, 7.8105058272E-01],
	[1.9810000000E+04, 1.0709363293E+01, 5.2615793288E+00, 1.5796077675E+00, 1.0911053469E+00, 7.8114878636E-01],
	[1.9815000000E+04, 1.0713347084E+01, 5.2614335267E+00, 1.5808785122E+00, 1.0917466110E+00, 7.8124695444E-01],
	[1.9820000000E+04, 1.0717331351E+01, 5.2612877653E+00, 1.5821499571E+00, 1.0923879633E+00, 7.8134508697E-01],
	[1.9825000000E+04, 1.0721316094E+01, 5.2611420448E+00, 1.5834221024E+00, 1.0930294035E+00, 7.8144318394E-01],
	[1.9830000000E+04, 1.0725301313E+01, 5.2609963650E+00, 1.5846949483E+00, 1.0936709315E+00, 7.8154124535E-01],
	[1.9835000000E+04, 1.0729287009E+01, 5.2608507261E+00, 1.5859684950E+00, 1.0943125472E+00, 7.8163927121E-01],
	[1.9840000000E+04, 1.0733273180E+01, 5.2607051278E+00, 1.5872427428E+00, 1.0949542504E+00, 7.8173726152E-01],
	[1.9845000000E+04, 1.0737259827E+01, 5.2605595703E+00, 1.5885176918E+00, 1.0955960409E+00, 7.8183521627E-01],
	[1.9850000000E+04, 1.0741246950E+01, 5.2604140534E+00, 1.5897933423E+00, 1.0962379185E+00, 7.8193313547E-01],
	[1.9855000000E+04, 1.0745234549E+01, 5.2602685772E+00, 1.5910696945E+00, 1.0968798832E+00, 7.8203101912E-01],
	[1.9860000000E+04, 1.0749222624E+01, 5.2601231417E+00, 1.5923467485E+00, 1.0975219348E+00, 7.8212886721E-01],
	[1.9865000000E+04, 1.0753211175E+01, 5.2599777468E+00, 1.5936245046E+00, 1.0981640731E+00, 7.8222667975E-01],
	[1.9870000000E+04, 1.0757200201E+01, 5.2598323926E+00, 1.5949029630E+00, 1.0988062980E+00, 7.8232445675E-01],
	[1.9875000000E+04, 1.0761189702E+01, 5.2596870789E+00, 1.5961821239E+00, 1.0994486092E+00, 7.8242219818E-01],
	[1.9880000000E+04, 1.0765179679E+01, 5.2595418057E+00, 1.5974619875E+00, 1.1000910067E+00, 7.8251990407E-01],
	[1.9885000000E+04, 1.0769170132E+01, 5.2593965732E+00, 1.5987425540E+00, 1.1007334903E+00, 7.8261757441E-01],
	[1.9890000000E+04, 1.0773161060E+01, 5.2592513811E+00, 1.6000238237E+00, 1.1013760599E+00, 7.8271520920E-01],
	[1.9895000000E+04, 1.0777152463E+01, 5.2591062295E+00, 1.6013057967E+00, 1.1020187152E+00, 7.8281280845E-01],
	[1.9900000000E+04, 1.0781144341E+01, 5.2589611185E+00, 1.6025884732E+00, 1.1026614561E+00, 7.8291037214E-01],
	[1.9905000000E+04, 1.0785136695E+01, 5.2588160478E+00, 1.6038718534E+00, 1.1033042825E+00, 7.8300790029E-01],
	[1.9910000000E+04, 1.0789129524E+01, 5.2586710176E+00, 1.6051559376E+00, 1.1039471943E+00, 7.8310539289E-01],
	[1.9915000000E+04, 1.0793122828E+01, 5.2585260279E+00, 1.6064407260E+00, 1.1045901912E+00, 7.8320284994E-01],
	[1.9920000000E+04, 1.0797116607E+01, 5.2583810785E+00, 1.6077262188E+00, 1.1052332731E+00, 7.8330027145E-01],
	[1.9925000000E+04, 1.0801110860E+01, 5.2582361695E+00, 1.6090124161E+00, 1.1058764398E+00, 7.8339765741E-01],
	[1.9930000000E+04, 1.0805105589E+01, 5.2580913008E+00, 1.6102993182E+00, 1.1065196913E+00, 7.8349500784E-01],
	[1.9935000000E+04, 1.0809100792E+01, 5.2579464725E+00, 1.6115869253E+00, 1.1071630272E+00, 7.8359232272E-01],
	[1.9940000000E+04, 1.0813096471E+01, 5.2578016845E+00, 1.6128752376E+00, 1.1078064476E+00, 7.8368960205E-01],
	[1.9945000000E+04, 1.0817092623E+01, 5.2576569368E+00, 1.6141642554E+00, 1.1084499522E+00, 7.8378684585E-01],
	[1.9950000000E+04, 1.0821089251E+01, 5.2575122293E+00, 1.6154539787E+00, 1.1090935408E+00, 7.8388405411E-01],
	[1.9955000000E+04, 1.0825086353E+01, 5.2573675621E+00, 1.6167444079E+00, 1.1097372134E+00, 7.8398122682E-01],
	[1.9960000000E+04, 1.0829083929E+01, 5.2572229351E+00, 1.6180355431E+00, 1.1103809697E+00, 7.8407836400E-01],
	[1.9965000000E+04, 1.0833081980E+01, 5.2570783483E+00, 1.6193273846E+00, 1.1110248097E+00, 7.8417546565E-01],
	[1.9970000000E+04, 1.0837080506E+01, 5.2569338017E+00, 1.6206199325E+00, 1.1116687331E+00, 7.8427253175E-01],
	[1.9975000000E+04, 1.0841079505E+01, 5.2567892952E+00, 1.6219131871E+00, 1.1123127397E+00, 7.8436956233E-01],
	[1.9980000000E+04, 1.0845078979E+01, 5.2566448289E+00, 1.6232071485E+00, 1.1129568296E+00, 7.8446655736E-01],
	[1.9985000000E+04, 1.0849078927E+01, 5.2565004027E+00, 1.6245018171E+00, 1.1136010024E+00, 7.8456351687E-01],
	[1.9990000000E+04, 1.0853079350E+01, 5.2563560166E+00, 1.6257971929E+00, 1.1142452580E+00, 7.8466044084E-01],
	[1.9995000000E+04, 1.0857080246E+01, 5.2562116706E+00, 1.6270932762E+00, 1.1148895963E+00, 7.8475732928E-01],
	[2.0000000000E+04, 1.0861081616E+01, 5.2560673646E+00, 1.6283900673E+00, 1.1155340171E+00, 7.8485418220E-01],
	[2.0005000000E+04, 1.0865083460E+01, 5.2559230987E+00, 1.6296896597E+00, 1.1161795023E+00, 7.8495099958E-01],
	[2.0010000000E+04, 1.0869085778E+01, 5.2557788727E+00, 1.6309899632E+00, 1.1168250703E+00, 7.8504778144E-01],
	[2.0015000000E+04, 1.0873088570E+01, 5.2556346868E+00, 1.6322909780E+00, 1.1174707208E+00, 7.8514452777E-01],
	[2.0020000000E+04, 1.0877091836E+01, 5.2554905408E+00, 1.6335927042E+00, 1.1181164537E+00, 7.8524123858E-01],
	[2.0025000000E+04, 1.0881095575E+01, 5.2553464348E+00, 1.6348951422E+00, 1.1187622689E+00, 7.8533791386E-01],
	[2.0030000000E+04, 1.0885099788E+01, 5.2552023687E+00, 1.6361982921E+00, 1.1194081662E+00, 7.8543455363E-01],
	[2.0035000000E+04, 1.0889104474E+01, 5.2550583425E+00, 1.6375021541E+00, 1.1200541454E+00, 7.8553115787E-01],
	[2.0040000000E+04, 1.0893109634E+01, 5.2549143562E+00, 1.6388067284E+00, 1.1207002064E+00, 7.8562772659E-01],
	[2.0045000000E+04, 1.0897115268E+01, 5.2547704097E+00, 1.6401120153E+00, 1.1213463491E+00, 7.8572425979E-01],
	[2.0050000000E+04, 1.0901121374E+01, 5.2546265031E+00, 1.6414180149E+00, 1.1219925732E+00, 7.8582075748E-01],
	[2.0055000000E+04, 1.0905127955E+01, 5.2544826364E+00, 1.6427247275E+00, 1.1226388787E+00, 7.8591721965E-01],
	[2.0060000000E+04, 1.0909135008E+01, 5.2543388094E+00, 1.6440321533E+00, 1.1232852653E+00, 7.8601364631E-01],
	[2.0065000000E+04, 1.0913151515E+01, 5.2541973585E+00, 1.6453402924E+00, 1.1239319351E+00, 7.8611003746E-01],
	[2.0070000000E+04, 1.0917177909E+01, 5.2540583936E+00, 1.6466491452E+00, 1.1245788981E+00, 7.8620639309E-01],
	[2.0075000000E+04, 1.0921204785E+01, 5.2539194670E+00, 1.6479587117E+00, 1.1252259424E+00, 7.8630271322E-01],
	[2.0080000000E+04, 1.0925232143E+01, 5.2537805786E+00, 1.6492689923E+00, 1.1258730680E+00, 7.8639899784E-01],
	[2.0085000000E+04, 1.0929259983E+01, 5.2536417285E+00, 1.6505799871E+00, 1.1265202748E+00, 7.8649524695E-01],
	[2.0090000000E+04, 1.0933288305E+01, 5.2535029166E+00, 1.6518916963E+00, 1.1271675624E+00, 7.8659146055E-01],
	[2.0095000000E+04, 1.0937317109E+01, 5.2533641429E+00, 1.6532041202E+00, 1.1278149309E+00, 7.8668763866E-01],
	[2.0100000000E+04, 1.0941346394E+01, 5.2532254074E+00, 1.6545172590E+00, 1.1284623800E+00, 7.8678378126E-01],
	[2.0105000000E+04, 1.0945376161E+01, 5.2530867101E+00, 1.6558311128E+00, 1.1291099096E+00, 7.8687988836E-01],
	[2.0110000000E+04, 1.0949406409E+01, 5.2529480509E+00, 1.6571456819E+00, 1.1297575195E+00, 7.8697595997E-01],
	[2.0115000000E+04, 1.0953437139E+01, 5.2528094299E+00, 1.6584609665E+00, 1.1304052096E+00, 7.8707199608E-01],
	[2.0120000000E+04, 1.0957468350E+01, 5.2526708469E+00, 1.6597769668E+00, 1.1310529797E+00, 7.8716799669E-01],
	[2.0125000000E+04, 1.0961500043E+01, 5.2525323021E+00, 1.6610936830E+00, 1.1317008297E+00, 7.8726396181E-01],
	[2.0130000000E+04, 1.0965532217E+01, 5.2523937953E+00, 1.6624111153E+00, 1.1323487593E+00, 7.8735989144E-01],
	[2.0135000000E+04, 1.0969564873E+01, 5.2522553266E+00, 1.6637292640E+00, 1.1329967685E+00, 7.8745578558E-01],
	[2.0140000000E+04, 1.0973598010E+01, 5.2521168959E+00, 1.6650481292E+00, 1.1336448571E+00, 7.8755164424E-01],
	[2.0145000000E+04, 1.0977631627E+01, 5.2519785032E+00, 1.6663677112E+00, 1.1342930250E+00, 7.8764746740E-01],
	[2.0150000000E+04, 1.0981665726E+01, 5.2518401485E+00, 1.6676880101E+00, 1.1349412719E+00, 7.8774325509E-01],
	[2.0155000000E+04, 1.0985700306E+01, 5.2517018318E+00, 1.6690090262E+00, 1.1355895978E+00, 7.8783900729E-01],
	[2.0160000000E+04, 1.0989735367E+01, 5.2515635530E+00, 1.6703307597E+00, 1.1362380024E+00, 7.8793472401E-01],
	[2.0165000000E+04, 1.0993770909E+01, 5.2514253122E+00, 1.6716532108E+00, 1.1368864856E+00, 7.8803040525E-01],
	[2.0170000000E+04, 1.0997806931E+01, 5.2512871093E+00, 1.6729763797E+00, 1.1375350473E+00, 7.8812605102E-01],
	[2.0175000000E+04, 1.1001843434E+01, 5.2511489442E+00, 1.6743002666E+00, 1.1381836873E+00, 7.8822166132E-01],
	[2.0180000000E+04, 1.1005880418E+01, 5.2510108171E+00, 1.6756248717E+00, 1.1388324055E+00, 7.8831723614E-01],
	[2.0185000000E+04, 1.1009917883E+01, 5.2508727277E+00, 1.6769501953E+00, 1.1394812016E+00, 7.8841277549E-01],
	[2.0190000000E+04, 1.1013955828E+01, 5.2507346763E+00, 1.6782762376E+00, 1.1401300756E+00, 7.8850827937E-01],
	[2.0195000000E+04, 1.1017994254E+01, 5.2505966626E+00, 1.6796029987E+00, 1.1407790272E+00, 7.8860374779E-01],
	[2.0200000000E+04, 1.1022033161E+01, 5.2504586867E+00, 1.6809304789E+00, 1.1414280564E+00, 7.8869918074E-01],
	[2.0205000000E+04, 1.1026072547E+01, 5.2503207486E+00, 1.6822586783E+00, 1.1420771630E+00, 7.8879457823E-01],
	[2.0210000000E+04, 1.1030112414E+01, 5.2501828482E+00, 1.6835875973E+00, 1.1427263468E+00, 7.8888994026E-01],
	[2.0215000000E+04, 1.1034152761E+01, 5.2500449856E+00, 1.6849172359E+00, 1.1433756076E+00, 7.8898526683E-01],
	[2.0220000000E+04, 1.1038193589E+01, 5.2499071607E+00, 1.6862475945E+00, 1.1440249453E+00, 7.8908055795E-01],
	[2.0225000000E+04, 1.1042234897E+01, 5.2497693735E+00, 1.6875786732E+00, 1.1446743598E+00, 7.8917581362E-01],
	[2.0230000000E+04, 1.1046276684E+01, 5.2496316239E+00, 1.6889104723E+00, 1.1453238509E+00, 7.8927103383E-01],
	[2.0235000000E+04, 1.1050318952E+01, 5.2494939121E+00, 1.6902429918E+00, 1.1459734184E+00, 7.8936621859E-01],
	[2.0240000000E+04, 1.1054361700E+01, 5.2493562378E+00, 1.6915762322E+00, 1.1466230622E+00, 7.8946136791E-01],
	[2.0245000000E+04, 1.1058404928E+01, 5.2492186012E+00, 1.6929101935E+00, 1.1472727822E+00, 7.8955648179E-01],
	[2.0250000000E+04, 1.1062448635E+01, 5.2490810021E+00, 1.6942448760E+00, 1.1479225781E+00, 7.8965156022E-01],
	[2.0255000000E+04, 1.1066492822E+01, 5.2489434407E+00, 1.6955802799E+00, 1.1485724498E+00, 7.8974660321E-01],
	[2.0260000000E+04, 1.1070537489E+01, 5.2488059168E+00, 1.6969164054E+00, 1.1492223972E+00, 7.8984161077E-01],
	[2.0265000000E+04, 1.1074582636E+01, 5.2486684304E+00, 1.6982532527E+00, 1.1498724201E+00, 7.8993658289E-01],
	[2.0270000000E+04, 1.1078628262E+01, 5.2485309816E+00, 1.6995908221E+00, 1.1505225183E+00, 7.9003151958E-01],
	[2.0275000000E+04, 1.1082674368E+01, 5.2483935702E+00, 1.7009291136E+00, 1.1511726918E+00, 7.9012642084E-01],
	[2.0280000000E+04, 1.1086720953E+01, 5.2482561963E+00, 1.7022681276E+00, 1.1518229402E+00, 7.9022128667E-01],
	[2.0285000000E+04, 1.1090768018E+01, 5.2481188599E+00, 1.7036078643E+00, 1.1524732636E+00, 7.9031611707E-01],
	[2.0290000000E+04, 1.1094815562E+01, 5.2479815609E+00, 1.7049483239E+00, 1.1531236617E+00, 7.9041091206E-01],
	[2.0295000000E+04, 1.1098863586E+01, 5.2478442994E+00, 1.7062895065E+00, 1.1537741343E+00, 7.9050567162E-01],
	[2.0300000000E+04, 1.1102912088E+01, 5.2477070752E+00, 1.7076314124E+00, 1.1544246814E+00, 7.9060039576E-01],
	[2.0305000000E+04, 1.1106961070E+01, 5.2475698885E+00, 1.7089740418E+00, 1.1550753028E+00, 7.9069508449E-01],
	[2.0310000000E+04, 1.1111010531E+01, 5.2474327391E+00, 1.7103173949E+00, 1.1557259982E+00, 7.9078973781E-01],
	[2.0315000000E+04, 1.1115060471E+01, 5.2472956270E+00, 1.7116614720E+00, 1.1563767676E+00, 7.9088435572E-01],
	[2.0320000000E+04, 1.1119110890E+01, 5.2471585523E+00, 1.7130062732E+00, 1.1570276108E+00, 7.9097893822E-01],
	[2.0325000000E+04, 1.1123161787E+01, 5.2470215148E+00, 1.7143517987E+00, 1.1576785277E+00, 7.9107348532E-01],
	[2.0330000000E+04, 1.1127213164E+01, 5.2468845147E+00, 1.7156980488E+00, 1.1583295180E+00, 7.9116799701E-01],
	[2.0335000000E+04, 1.1131265020E+01, 5.2467475518E+00, 1.7170450236E+00, 1.1589805817E+00, 7.9126247331E-01],
	[2.0340000000E+04, 1.1135317354E+01, 5.2466106261E+00, 1.7183927235E+00, 1.1596317185E+00, 7.9135691421E-01],
	[2.0345000000E+04, 1.1139370167E+01, 5.2464737377E+00, 1.7197411485E+00, 1.1602829284E+00, 7.9145131972E-01],
	[2.0350000000E+04, 1.1143423458E+01, 5.2463368865E+00, 1.7210902989E+00, 1.1609342111E+00, 7.9154568983E-01],
	[2.0355000000E+04, 1.1147477228E+01, 5.2462000725E+00, 1.7224401749E+00, 1.1615855666E+00, 7.9164002456E-01],
	[2.0360000000E+04, 1.1151531477E+01, 5.2460632957E+00, 1.7237907768E+00, 1.1622369946E+00, 7.9173432390E-01],
	[2.0365000000E+04, 1.1155586204E+01, 5.2459265560E+00, 1.7251421047E+00, 1.1628884950E+00, 7.9182858785E-01],
	[2.0370000000E+04, 1.1159641409E+01, 5.2457898534E+00, 1.7264941588E+00, 1.1635400676E+00, 7.9192281643E-01],
	[2.0375000000E+04, 1.1163697093E+01, 5.2456531880E+00, 1.7278469394E+00, 1.1641917124E+00, 7.9201700963E-01],
	[2.0380000000E+04, 1.1167753255E+01, 5.2455165596E+00, 1.7292004466E+00, 1.1648434290E+00, 7.9211116746E-01],
	[2.0385000000E+04, 1.1171809895E+01, 5.2453799683E+00, 1.7305546808E+00, 1.1654952175E+00, 7.9220528992E-01],
	[2.0390000000E+04, 1.1175883647E+01, 5.2452476173E+00, 1.7319096420E+00, 1.1661474664E+00, 7.9229937701E-01],
	[2.0395000000E+04, 1.1179959891E+01, 5.2451158086E+00, 1.7332653305E+00, 1.1667998344E+00, 7.9239342873E-01],
	[2.0400000000E+04, 1.1184036622E+01, 5.2449840356E+00, 1.7346217465E+00, 1.1674522745E+00, 7.9248744509E-01],
	[2.0405000000E+04, 1.1188113840E+01, 5.2448522982E+00, 1.7359788903E+00, 1.1681047864E+00, 7.9258142609E-01],
	[2.0410000000E+04, 1.1192191544E+01, 5.2447205963E+00, 1.7373367620E+00, 1.1687573700E+00, 7.9267537174E-01],
	[2.0415000000E+04, 1.1196269735E+01, 5.2445889300E+00, 1.7386953618E+00, 1.1694100253E+00, 7.9276928203E-01],
	[2.0420000000E+04, 1.1200348414E+01, 5.2444572993E+00, 1.7400546900E+00, 1.1700627520E+00, 7.9286315697E-01],
	[2.0425000000E+04, 1.1204427578E+01, 5.2443257041E+00, 1.7414147467E+00, 1.1707155499E+00, 7.9295699656E-01],
	[2.0430000000E+04, 1.1208507230E+01, 5.2441941444E+00, 1.7427755323E+00, 1.1713684190E+00, 7.9305080081E-01],
	[2.0435000000E+04, 1.1212587368E+01, 5.2440626202E+00, 1.7441370468E+00, 1.1720213590E+00, 7.9314456972E-01],
	[2.0440000000E+04, 1.1216667992E+01, 5.2439311314E+00, 1.7454992905E+00, 1.1726743699E+00, 7.9323830329E-01],
	[2.0445000000E+04, 1.1220749103E+01, 5.2437996782E+00, 1.7468622637E+00, 1.1733274514E+00, 7.9333200153E-01],
	[2.0450000000E+04, 1.1224830701E+01, 5.2436682603E+00, 1.7482259664E+00, 1.1739806034E+00, 7.9342566444E-01],
	[2.0455000000E+04, 1.1228912784E+01, 5.2435368779E+00, 1.7495903990E+00, 1.1746338257E+00, 7.9351929201E-01],
	[2.0460000000E+04, 1.1232995354E+01, 5.2434055309E+00, 1.7509555616E+00, 1.1752871183E+00, 7.9361288426E-01],
	[2.0465000000E+04, 1.1237078411E+01, 5.2432742193E+00, 1.7523214545E+00, 1.1759404809E+00, 7.9370644119E-01],
	[2.0470000000E+04, 1.1241161953E+01, 5.2431429430E+00, 1.7536880779E+00, 1.1765939133E+00, 7.9379996280E-01],
	[2.0475000000E+04, 1.1245245981E+01, 5.2430117021E+00, 1.7550554319E+00, 1.1772474155E+00, 7.9389344910E-01],
	[2.0480000000E+04, 1.1249330496E+01, 5.2428804965E+00, 1.7564235169E+00, 1.1779009873E+00, 7.9398690008E-01],
	[2.0485000000E+04, 1.1253415496E+01, 5.2427493262E+00, 1.7577923329E+00, 1.1785546285E+00, 7.9408031576E-01],
	[2.0490000000E+04, 1.1257500982E+01, 5.2426181912E+00, 1.7591618802E+00, 1.1792083390E+00, 7.9417369613E-01],
	[2.0495000000E+04, 1.1261586955E+01, 5.2424870915E+00, 1.7605321591E+00, 1.1798621186E+00, 7.9426704120E-01],
	[2.0500000000E+04, 1.1265673413E+01, 5.2423560270E+00, 1.7619031697E+00, 1.1805159671E+00, 7.9436035097E-01],
	[2.0505000000E+04, 1.1269760356E+01, 5.2422249978E+00, 1.7632749123E+00, 1.1811698844E+00, 7.9445362544E-01],
	[2.0510000000E+04, 1.1273847786E+01, 5.2420940038E+00, 1.7646473870E+00, 1.1818238704E+00, 7.9454686462E-01],
	[2.0515000000E+04, 1.1277935701E+01, 5.2419630450E+00, 1.7660205940E+00, 1.1824779249E+00, 7.9464006852E-01],
	[2.0520000000E+04, 1.1282024101E+01, 5.2418321214E+00, 1.7673945337E+00, 1.1831320477E+00, 7.9473323713E-01],
	[2.0525000000E+04, 1.1286112987E+01, 5.2417012330E+00, 1.7687692062E+00, 1.1837862387E+00, 7.9482637045E-01],
	[2.0530000000E+04, 1.1290202358E+01, 5.2415703797E+00, 1.7701446116E+00, 1.1844404978E+00, 7.9491946850E-01],
	[2.0535000000E+04, 1.1294292215E+01, 5.2414395615E+00, 1.7715207503E+00, 1.1850948247E+00, 7.9501253128E-01],
	[2.0540000000E+04, 1.1298382557E+01, 5.2413087785E+00, 1.7728976224E+00, 1.1857492193E+00, 7.9510555878E-01],
	[2.0545000000E+04, 1.1302473384E+01, 5.2411780305E+00, 1.7742752281E+00, 1.1864036815E+00, 7.9519855102E-01],
	[2.0550000000E+04, 1.1306564697E+01, 5.2410473176E+00, 1.7756535677E+00, 1.1870582112E+00, 7.9529150799E-01],
	[2.0555000000E+04, 1.1310656494E+01, 5.2409166398E+00, 1.7770326413E+00, 1.1877128081E+00, 7.9538442971E-01],
	[2.0560000000E+04, 1.1314748777E+01, 5.2407859970E+00, 1.7784124493E+00, 1.1883674721E+00, 7.9547731616E-01],
	[2.0565000000E+04, 1.1318841545E+01, 5.2406553893E+00, 1.7797929917E+00, 1.1890222030E+00, 7.9557016737E-01],
	[2.0570000000E+04, 1.1322934797E+01, 5.2405248165E+00, 1.7811742688E+00, 1.1896770007E+00, 7.9566298332E-01],
	[2.0575000000E+04, 1.1327028535E+01, 5.2403942787E+00, 1.7825562808E+00, 1.1903318651E+00, 7.9575576403E-01],
	[2.0580000000E+04, 1.1331122757E+01, 5.2402637759E+00, 1.7839390279E+00, 1.1909867960E+00, 7.9584850950E-01],
	[2.0585000000E+04, 1.1335217464E+01, 5.2401333081E+00, 1.7853225103E+00, 1.1916417932E+00, 7.9594121973E-01],
	[2.0590000000E+04, 1.1339312655E+01, 5.2400028752E+00, 1.7867067283E+00, 1.1922968566E+00, 7.9603389473E-01],
	[2.0595000000E+04, 1.1343408332E+01, 5.2398724772E+00, 1.7880916821E+00, 1.1929519861E+00, 7.9612653449E-01],
	[2.0600000000E+04, 1.1347504493E+01, 5.2397421141E+00, 1.7894773718E+00, 1.1936071814E+00, 7.9621913900E-01],
	[2.0605000000E+04, 1.1351601138E+01, 5.2396117859E+00, 1.7908637976E+00, 1.1942624424E+00, 7.9631170811E-01],
	[2.0610000000E+04, 1.1355698268E+01, 5.2394814925E+00, 1.7922509599E+00, 1.1949177690E+00, 7.9640424183E-01],
	[2.0615000000E+04, 1.1359795882E+01, 5.2393512340E+00, 1.7936388588E+00, 1.1955731610E+00, 7.9649674014E-01],
	[2.0620000000E+04, 1.1363893981E+01, 5.2392210103E+00, 1.7950274944E+00, 1.1962286182E+00, 7.9658920308E-01],
	[2.0625000000E+04, 1.1367992564E+01, 5.2390908214E+00, 1.7964168671E+00, 1.1968841406E+00, 7.9668163063E-01],
	[2.0630000000E+04, 1.1372091631E+01, 5.2389606673E+00, 1.7978069771E+00, 1.1975397279E+00, 7.9677402281E-01],
	[2.0635000000E+04, 1.1376191182E+01, 5.2388305480E+00, 1.7991978244E+00, 1.1981953800E+00, 7.9686637963E-01],
	[2.0640000000E+04, 1.1380291217E+01, 5.2387004634E+00, 1.8005894095E+00, 1.1988510968E+00, 7.9695870109E-01],
	[2.0645000000E+04, 1.1384391736E+01, 5.2385704136E+00, 1.8019817324E+00, 1.1995068780E+00, 7.9705098721E-01],
	[2.0650000000E+04, 1.1388492740E+01, 5.2384403985E+00, 1.8033747933E+00, 1.2001627236E+00, 7.9714323799E-01],
	[2.0655000000E+04, 1.1392594227E+01, 5.2383104181E+00, 1.8047685926E+00, 1.2008186333E+00, 7.9723545343E-01],
	[2.0660000000E+04, 1.1396696198E+01, 5.2381804724E+00, 1.8061631304E+00, 1.2014746071E+00, 7.9732763356E-01],
	[2.0665000000E+04, 1.1400798653E+01, 5.2380505613E+00, 1.8075584068E+00, 1.2021306448E+00, 7.9741977837E-01],
	[2.0670000000E+04, 1.1404901591E+01, 5.2379206849E+00, 1.8089544223E+00, 1.2027867461E+00, 7.9751188787E-01],
	[2.0675000000E+04, 1.1409005014E+01, 5.2377908432E+00, 1.8103511768E+00, 1.2034429111E+00, 7.9760396207E-01],
	[2.0680000000E+04, 1.1413108920E+01, 5.2376610360E+00, 1.8117486707E+00, 1.2040991394E+00, 7.9769600098E-01],
	[2.0685000000E+04, 1.1417213309E+01, 5.2375312635E+00, 1.8131469041E+00, 1.2047554310E+00, 7.9778800461E-01],
	[2.0690000000E+04, 1.1421318182E+01, 5.2374015255E+00, 1.8145458774E+00, 1.2054117858E+00, 7.9787997297E-01],
	[2.0695000000E+04, 1.1425423538E+01, 5.2372718221E+00, 1.8159455906E+00, 1.2060682034E+00, 7.9797190606E-01],
	[2.0700000000E+04, 1.1429529378E+01, 5.2371421532E+00, 1.8173460440E+00, 1.2067246839E+00, 7.9806380389E-01],
	[2.0705000000E+04, 1.1433635701E+01, 5.2370125189E+00, 1.8187472378E+00, 1.2073812270E+00, 7.9815566647E-01],
	[2.0710000000E+04, 1.1437742507E+01, 5.2368829190E+00, 1.8201491722E+00, 1.2080378326E+00, 7.9824749381E-01],
	[2.0715000000E+04, 1.1441854637E+01, 5.2367545435E+00, 1.8215518475E+00, 1.2086946179E+00, 7.9833928591E-01],
	[2.0720000000E+04, 1.1445981281E+01, 5.2366296494E+00, 1.8229552638E+00, 1.2093518061E+00, 7.9843104279E-01],
	[2.0725000000E+04, 1.1450108418E+01, 5.2365047884E+00, 1.8243594213E+00, 1.2100090570E+00, 7.9852276445E-01],
	[2.0730000000E+04, 1.1454236046E+01, 5.2363799605E+00, 1.8257643204E+00, 1.2106663706E+00, 7.9861445090E-01],
	[2.0735000000E+04, 1.1458364167E+01, 5.2362551656E+00, 1.8271699610E+00, 1.2113237467E+00, 7.9870610215E-01],
	[2.0740000000E+04, 1.1462492779E+01, 5.2361304039E+00, 1.8285763436E+00, 1.2119811850E+00, 7.9879771821E-01],
	[2.0745000000E+04, 1.1466621883E+01, 5.2360056752E+00, 1.8299834683E+00, 1.2126386855E+00, 7.9888929908E-01],
	[2.0750000000E+04, 1.1470751479E+01, 5.2358809795E+00, 1.8313913353E+00, 1.2132962481E+00, 7.9898084477E-01],
	[2.0755000000E+04, 1.1474881567E+01, 5.2357563168E+00, 1.8327999448E+00, 1.2139538725E+00, 7.9907235530E-01],
	[2.0760000000E+04, 1.1479012147E+01, 5.2356316871E+00, 1.8342092971E+00, 1.2146115585E+00, 7.9916383067E-01],
	[2.0765000000E+04, 1.1483143218E+01, 5.2355070904E+00, 1.8356193923E+00, 1.2152693062E+00, 7.9925527088E-01],
	[2.0770000000E+04, 1.1487274780E+01, 5.2353825267E+00, 1.8370302307E+00, 1.2159271152E+00, 7.9934667595E-01],
	[2.0775000000E+04, 1.1491406835E+01, 5.2352579959E+00, 1.8384418124E+00, 1.2165849855E+00, 7.9943804588E-01],
	[2.0780000000E+04, 1.1495539380E+01, 5.2351334980E+00, 1.8398541377E+00, 1.2172429169E+00, 7.9952938069E-01],
	[2.0785000000E+04, 1.1499672417E+01, 5.2350090331E+00, 1.8412672069E+00, 1.2179009092E+00, 7.9962068038E-01],
	[2.0790000000E+04, 1.1503805945E+01, 5.2348846010E+00, 1.8426810200E+00, 1.2185589623E+00, 7.9971194496E-01],
	[2.0795000000E+04, 1.1507939965E+01, 5.2347602019E+00, 1.8440955773E+00, 1.2192170760E+00, 7.9980317443E-01],
	[2.0800000000E+04, 1.1512074476E+01, 5.2346358356E+00, 1.8455108791E+00, 1.2198752502E+00, 7.9989436881E-01],
	[2.0805000000E+04, 1.1516209477E+01, 5.2345115021E+00, 1.8469269255E+00, 1.2205334847E+00, 7.9998552811E-01],
	[2.0810000000E+04, 1.1520344970E+01, 5.2343872015E+00, 1.8483437168E+00, 1.2211917794E+00, 8.0007665233E-01],
	[2.0815000000E+04, 1.1524480954E+01, 5.2342629336E+00, 1.8497612531E+00, 1.2218501342E+00, 8.0016774147E-01],
	[2.0820000000E+04, 1.1528617429E+01, 5.2341386986E+00, 1.8511795347E+00, 1.2225085488E+00, 8.0025879556E-01],
	[2.0825000000E+04, 1.1532754395E+01, 5.2340144963E+00, 1.8525985618E+00, 1.2231670231E+00, 8.0034981460E-01],
	[2.0830000000E+04, 1.1536891852E+01, 5.2338903269E+00, 1.8540183346E+00, 1.2238255569E+00, 8.0044079859E-01],
	[2.0835000000E+04, 1.1541029799E+01, 5.2337661901E+00, 1.8554388533E+00, 1.2244841502E+00, 8.0053174754E-01],
	[2.0840000000E+04, 1.1545168237E+01, 5.2336420861E+00, 1.8568601182E+00, 1.2251428028E+00, 8.0062266147E-01],
	[2.0845000000E+04, 1.1549307166E+01, 5.2335180148E+00, 1.8582821294E+00, 1.2258015144E+00, 8.0071354038E-01],
	[2.0850000000E+04, 1.1553446585E+01, 5.2333939762E+00, 1.8597048871E+00, 1.2264602850E+00, 8.0080438428E-01],
	[2.0855000000E+04, 1.1557586495E+01, 5.2332699703E+00, 1.8611283916E+00, 1.2271191144E+00, 8.0089519317E-01],
	[2.0860000000E+04, 1.1561726896E+01, 5.2331459970E+00, 1.8625526431E+00, 1.2277780024E+00, 8.0098596708E-01],
	[2.0865000000E+04, 1.1565867786E+01, 5.2330220564E+00, 1.8639776417E+00, 1.2284369490E+00, 8.0107670599E-01],
	[2.0870000000E+04, 1.1570009168E+01, 5.2328981485E+00, 1.8654033877E+00, 1.2290959539E+00, 8.0116740993E-01],
	[2.0875000000E+04, 1.1574151039E+01, 5.2327742731E+00, 1.8668298814E+00, 1.2297550169E+00, 8.0125807891E-01],
	[2.0880000000E+04, 1.1578293401E+01, 5.2326504303E+00, 1.8682571229E+00, 1.2304141380E+00, 8.0134871292E-01],
	[2.0885000000E+04, 1.1582436253E+01, 5.2325266202E+00, 1.8696851124E+00, 1.2310733170E+00, 8.0143931198E-01],
	[2.0890000000E+04, 1.1586579595E+01, 5.2324028425E+00, 1.8711138501E+00, 1.2317325537E+00, 8.0152987609E-01],
	[2.0895000000E+04, 1.1590723427E+01, 5.2322790975E+00, 1.8725433364E+00, 1.2323918480E+00, 8.0162040528E-01],
	[2.0900000000E+04, 1.1594867749E+01, 5.2321553849E+00, 1.8739735712E+00, 1.2330511998E+00, 8.0171089953E-01],
	[2.0905000000E+04, 1.1599012561E+01, 5.2320317049E+00, 1.8754045550E+00, 1.2337106088E+00, 8.0180135887E-01],
	[2.0910000000E+04, 1.1603157863E+01, 5.2319080574E+00, 1.8768362879E+00, 1.2343700749E+00, 8.0189178330E-01],
	[2.0915000000E+04, 1.1607303655E+01, 5.2317844424E+00, 1.8782687700E+00, 1.2350295980E+00, 8.0198217283E-01],
	[2.0920000000E+04, 1.1611449936E+01, 5.2316608598E+00, 1.8797020017E+00, 1.2356891779E+00, 8.0207252747E-01],
	[2.0925000000E+04, 1.1615596708E+01, 5.2315373097E+00, 1.8811359831E+00, 1.2363488145E+00, 8.0216284722E-01],
	[2.0930000000E+04, 1.1619743968E+01, 5.2314137920E+00, 1.8825707145E+00, 1.2370085076E+00, 8.0225313210E-01],
	[2.0935000000E+04, 1.1623891719E+01, 5.2312903068E+00, 1.8840061960E+00, 1.2376682570E+00, 8.0234338212E-01],
	[2.0940000000E+04, 1.1628039959E+01, 5.2311668539E+00, 1.8854424278E+00, 1.2383280627E+00, 8.0243359727E-01],
	[2.0945000000E+04, 1.1632188688E+01, 5.2310434335E+00, 1.8868794103E+00, 1.2389879244E+00, 8.0252377758E-01],
	[2.0950000000E+04, 1.1636337907E+01, 5.2309200454E+00, 1.8883171435E+00, 1.2396478420E+00, 8.0261392304E-01],
	[2.0955000000E+04, 1.1640487616E+01, 5.2307966896E+00, 1.8897556278E+00, 1.2403078154E+00, 8.0270403368E-01],
	[2.0960000000E+04, 1.1644637813E+01, 5.2306733662E+00, 1.8911948632E+00, 1.2409678443E+00, 8.0279410949E-01],
	[2.0965000000E+04, 1.1648788500E+01, 5.2305500751E+00, 1.8926348501E+00, 1.2416279288E+00, 8.0288415048E-01],
	[2.0970000000E+04, 1.1652939676E+01, 5.2304268164E+00, 1.8940755886E+00, 1.2422880685E+00, 8.0297415667E-01],
	[2.0975000000E+04, 1.1657091341E+01, 5.2303035899E+00, 1.8955170790E+00, 1.2429482633E+00, 8.0306412806E-01],
	[2.0980000000E+04, 1.1661243495E+01, 5.2301803957E+00, 1.8969593214E+00, 1.2436085132E+00, 8.0315406466E-01],
	[2.0985000000E+04, 1.1665396138E+01, 5.2300572337E+00, 1.8984023161E+00, 1.2442688179E+00, 8.0324396648E-01],
	[2.0990000000E+04, 1.1669549270E+01, 5.2299341040E+00, 1.8998460633E+00, 1.2449291773E+00, 8.0333383354E-01],
	[2.0995000000E+04, 1.1673702891E+01, 5.2298110065E+00, 1.9012905632E+00, 1.2455895912E+00, 8.0342366582E-01],
	[2.1000000000E+04, 1.1677857001E+01, 5.2296879412E+00, 1.9027358160E+00, 1.2462500595E+00, 8.0351346336E-01],
	[2.1005000000E+04, 1.1682011600E+01, 5.2295649081E+00, 1.9041818219E+00, 1.2469105820E+00, 8.0360322614E-01],
	[2.1010000000E+04, 1.1686166687E+01, 5.2294419072E+00, 1.9056285812E+00, 1.2475711586E+00, 8.0369295419E-01],
	[2.1015000000E+04, 1.1690322263E+01, 5.2293189384E+00, 1.9070760940E+00, 1.2482317892E+00, 8.0378264752E-01],
	[2.1020000000E+04, 1.1694478327E+01, 5.2291960018E+00, 1.9085243606E+00, 1.2488924735E+00, 8.0387230612E-01],
	[2.1025000000E+04, 1.1698634880E+01, 5.2290730974E+00, 1.9099733811E+00, 1.2495532114E+00, 8.0396193001E-01],
	[2.1030000000E+04, 1.1702791922E+01, 5.2289502250E+00, 1.9114231558E+00, 1.2502140029E+00, 8.0405151920E-01],
	[2.1035000000E+04, 1.1706949452E+01, 5.2288273847E+00, 1.9128736850E+00, 1.2508748476E+00, 8.0414107370E-01],
	[2.1040000000E+04, 1.1711107470E+01, 5.2287045765E+00, 1.9143249687E+00, 1.2515357455E+00, 8.0423059351E-01],
	[2.1045000000E+04, 1.1715265976E+01, 5.2285818004E+00, 1.9157770073E+00, 1.2521966964E+00, 8.0432007865E-01],
	[2.1050000000E+04, 1.1719435745E+01, 5.2284616317E+00, 1.9172298009E+00, 1.2528579712E+00, 8.0440952912E-01],
	[2.1055000000E+04, 1.1723614337E+01, 5.2283434847E+00, 1.9186833497E+00, 1.2535195088E+00, 8.0449894493E-01],
	[2.1060000000E+04, 1.1727793427E+01, 5.2282253685E+00, 1.9201376540E+00, 1.2541810998E+00, 8.0458832609E-01],
	[2.1065000000E+04, 1.1731973013E+01, 5.2281072829E+00, 1.9215927140E+00, 1.2548427438E+00, 8.0467767261E-01],
	[2.1070000000E+04, 1.1736153097E+01, 5.2279892281E+00, 1.9230485298E+00, 1.2555044409E+00, 8.0476698450E-01],
	[2.1075000000E+04, 1.1740333678E+01, 5.2278712039E+00, 1.9245051018E+00, 1.2561661909E+00, 8.0485626177E-01],
	[2.1080000000E+04, 1.1744514755E+01, 5.2277532104E+00, 1.9259624300E+00, 1.2568279936E+00, 8.0494550442E-01],
	[2.1085000000E+04, 1.1748696330E+01, 5.2276352475E+00, 1.9274205148E+00, 1.2574898489E+00, 8.0503471247E-01],
	[2.1090000000E+04, 1.1752878401E+01, 5.2275173153E+00, 1.9288793563E+00, 1.2581517565E+00, 8.0512388592E-01],
	[2.1095000000E+04, 1.1757060969E+01, 5.2273994136E+00, 1.9303389547E+00, 1.2588137165E+00, 8.0521302478E-01],
	[2.1100000000E+04, 1.1761244034E+01, 5.2272815426E+00, 1.9317993103E+00, 1.2594757285E+00, 8.0530212906E-01],
	[2.1105000000E+04, 1.1765427595E+01, 5.2271637022E+00, 1.9332604233E+00, 1.2601377925E+00, 8.0539119878E-01],
	[2.1110000000E+04, 1.1769611653E+01, 5.2270458923E+00, 1.9347222939E+00, 1.2607999083E+00, 8.0548023393E-01],
	[2.1115000000E+04, 1.1773796207E+01, 5.2269281130E+00, 1.9361849222E+00, 1.2614620758E+00, 8.0556923453E-01],
	[2.1120000000E+04, 1.1777981258E+01, 5.2268103642E+00, 1.9376483086E+00, 1.2621242948E+00, 8.0565820059E-01],
	[2.1125000000E+04, 1.1782166805E+01, 5.2266926460E+00, 1.9391124532E+00, 1.2627865651E+00, 8.0574713211E-01],
	[2.1130000000E+04, 1.1786352849E+01, 5.2265749582E+00, 1.9405773562E+00, 1.2634488867E+00, 8.0583602910E-01],
	[2.1135000000E+04, 1.1790539389E+01, 5.2264573010E+00, 1.9420430179E+00, 1.2641112593E+00, 8.0592489158E-01],
	[2.1140000000E+04, 1.1794726425E+01, 5.2263396742E+00, 1.9435094384E+00, 1.2647736828E+00, 8.0601371955E-01],
	[2.1145000000E+04, 1.1798913958E+01, 5.2262220779E+00, 1.9449766179E+00, 1.2654361571E+00, 8.0610251303E-01],
	[2.1150000000E+04, 1.1803101986E+01, 5.2261045121E+00, 1.9464445568E+00, 1.2660986819E+00, 8.0619127201E-01],
	[2.1155000000E+04, 1.1807290510E+01, 5.2259869766E+00, 1.9479132552E+00, 1.2667612573E+00, 8.0627999651E-01],
	[2.1160000000E+04, 1.1811479531E+01, 5.2258694716E+00, 1.9493827132E+00, 1.2674238829E+00, 8.0636868654E-01],
	[2.1165000000E+04, 1.1815669047E+01, 5.2257519970E+00, 1.9508529312E+00, 1.2680865587E+00, 8.0645734210E-01],
	[2.1170000000E+04, 1.1819859060E+01, 5.2256345528E+00, 1.9523239093E+00, 1.2687492844E+00, 8.0654596321E-01],
	[2.1175000000E+04, 1.1824049568E+01, 5.2255171390E+00, 1.9537956478E+00, 1.2694120601E+00, 8.0663454988E-01],
	[2.1180000000E+04, 1.1828240572E+01, 5.2253997555E+00, 1.9552681468E+00, 1.2700748854E+00, 8.0672310211E-01],
	[2.1185000000E+04, 1.1832432071E+01, 5.2252824024E+00, 1.9567414066E+00, 1.2707377603E+00, 8.0681161991E-01],
	[2.1190000000E+04, 1.1836624067E+01, 5.2251650796E+00, 1.9582154274E+00, 1.2714006846E+00, 8.0690010330E-01],
	[2.1195000000E+04, 1.1840816557E+01, 5.2250477871E+00, 1.9596902093E+00, 1.2720636581E+00, 8.0698855227E-01],
	[2.1200000000E+04, 1.1845009544E+01, 5.2249305249E+00, 1.9611657527E+00, 1.2727266807E+00, 8.0707696685E-01],
	[2.1205000000E+04, 1.1849203026E+01, 5.2248132930E+00, 1.9626420577E+00, 1.2733897523E+00, 8.0716534703E-01],
	[2.1210000000E+04, 1.1853397003E+01, 5.2246960913E+00, 1.9641191245E+00, 1.2740528727E+00, 8.0725369283E-01],
	[2.1215000000E+04, 1.1857591476E+01, 5.2245789200E+00, 1.9655969533E+00, 1.2747160417E+00, 8.0734200426E-01],
	[2.1220000000E+04, 1.1861786443E+01, 5.2244617788E+00, 1.9670755445E+00, 1.2753792592E+00, 8.0743028133E-01],
	[2.1225000000E+04, 1.1865981907E+01, 5.2243446679E+00, 1.9685548980E+00, 1.2760425251E+00, 8.0751852404E-01],
	[2.1230000000E+04, 1.1870177865E+01, 5.2242275872E+00, 1.9700350143E+00, 1.2767058392E+00, 8.0760673240E-01],
	[2.1235000000E+04, 1.1874374318E+01, 5.2241105366E+00, 1.9715158935E+00, 1.2773692013E+00, 8.0769490641E-01],
	[2.1240000000E+04, 1.1878571267E+01, 5.2239935163E+00, 1.9729975357E+00, 1.2780326113E+00, 8.0778304602E-01],
	[2.1245000000E+04, 1.1882768710E+01, 5.2238765261E+00, 1.9744799413E+00, 1.2786960690E+00, 8.0787115124E-01],
	[2.1250000000E+04, 1.1886966649E+01, 5.2237595661E+00, 1.9759631105E+00, 1.2793595744E+00, 8.0795922208E-01],
	[2.1255000000E+04, 1.1891165082E+01, 5.2236426362E+00, 1.9774470433E+00, 1.2800231272E+00, 8.0804725853E-01],
	[2.1260000000E+04, 1.1895364010E+01, 5.2235257364E+00, 1.9789317402E+00, 1.2806867273E+00, 8.0813526060E-01],
	[2.1265000000E+04, 1.1899563433E+01, 5.2234088668E+00, 1.9804172012E+00, 1.2813503745E+00, 8.0822322829E-01],
	[2.1270000000E+04, 1.1903763351E+01, 5.2232920272E+00, 1.9819034265E+00, 1.2820140688E+00, 8.0831116161E-01],
	[2.1275000000E+04, 1.1907963763E+01, 5.2231752177E+00, 1.9833904165E+00, 1.2826778098E+00, 8.0839906055E-01],
	[2.1280000000E+04, 1.1912164670E+01, 5.2230584382E+00, 1.9848781713E+00, 1.2833415976E+00, 8.0848692513E-01],
	[2.1285000000E+04, 1.1916366071E+01, 5.2229416888E+00, 1.9863666911E+00, 1.2840054319E+00, 8.0857475535E-01],
	[2.1290000000E+04, 1.1920567967E+01, 5.2228249695E+00, 1.9878559761E+00, 1.2846693127E+00, 8.0866255121E-01],
	[2.1295000000E+04, 1.1924770358E+01, 5.2227082801E+00, 1.9893460266E+00, 1.2853332396E+00, 8.0875031271E-01],
	[2.1300000000E+04, 1.1928973242E+01, 5.2225916208E+00, 1.9908368428E+00, 1.2859972127E+00, 8.0883803985E-01],
	[2.1305000000E+04, 1.1933176621E+01, 5.2224749914E+00, 1.9923284248E+00, 1.2866612317E+00, 8.0892573265E-01],
	[2.1310000000E+04, 1.1937380495E+01, 5.2223583920E+00, 1.9938207729E+00, 1.2873252965E+00, 8.0901339110E-01],
	[2.1315000000E+04, 1.1941584862E+01, 5.2222418226E+00, 1.9953138873E+00, 1.2879894070E+00, 8.0910101522E-01],
	[2.1320000000E+04, 1.1945789724E+01, 5.2221252831E+00, 1.9968077682E+00, 1.2886535629E+00, 8.0918860499E-01],
	[2.1325000000E+04, 1.1949995080E+01, 5.2220087735E+00, 1.9983024158E+00, 1.2893177642E+00, 8.0927616043E-01],
	[2.1330000000E+04, 1.1954200929E+01, 5.2218922939E+00, 1.9997978304E+00, 1.2899820108E+00, 8.0936368153E-01],
	[2.1335000000E+04, 1.1958407273E+01, 5.2217758441E+00, 2.0012940121E+00, 1.2906463023E+00, 8.0945116831E-01],
	[2.1340000000E+04, 1.1962614110E+01, 5.2216594242E+00, 2.0027909612E+00, 1.2913106388E+00, 8.0953862077E-01],
	[2.1345000000E+04, 1.1966821442E+01, 5.2215430342E+00, 2.0042886779E+00, 1.2919750200E+00, 8.0962603890E-01],
	[2.1350000000E+04, 1.1971029267E+01, 5.2214266741E+00, 2.0057871623E+00, 1.2926394458E+00, 8.0971342273E-01],
	[2.1355000000E+04, 1.1975237586E+01, 5.2213103438E+00, 2.0072864147E+00, 1.2933039160E+00, 8.0980077223E-01],
	[2.1360000000E+04, 1.1979446399E+01, 5.2211940433E+00, 2.0087864354E+00, 1.2939684306E+00, 8.0988808744E-01],
	[2.1365000000E+04, 1.1983655705E+01, 5.2210777726E+00, 2.0102872245E+00, 1.2946329893E+00, 8.0997536833E-01],
	[2.1370000000E+04, 1.1987865505E+01, 5.2209615317E+00, 2.0117887822E+00, 1.2952975920E+00, 8.1006261493E-01],
	[2.1375000000E+04, 1.1992075798E+01, 5.2208453206E+00, 2.0132911088E+00, 1.2959622386E+00, 8.1014982723E-01],
	[2.1380000000E+04, 1.1996286584E+01, 5.2207291393E+00, 2.0147942044E+00, 1.2966269289E+00, 8.1023700523E-01],
	[2.1385000000E+04, 1.2000497865E+01, 5.2206129877E+00, 2.0162980693E+00, 1.2972916627E+00, 8.1032414895E-01],
	[2.1390000000E+04, 1.2004725070E+01, 5.2205004529E+00, 2.0178027037E+00, 1.2979568421E+00, 8.1041125838E-01],
	[2.1395000000E+04, 1.2008956688E+01, 5.2203888557E+00, 2.0193081078E+00, 1.2986221673E+00, 8.1049833354E-01],
	[2.1400000000E+04, 1.2013188808E+01, 5.2202772869E+00, 2.0208142818E+00, 1.2992875364E+00, 8.1058537441E-01],
	[2.1405000000E+04, 1.2017421430E+01, 5.2201657465E+00, 2.0223212260E+00, 1.2999529492E+00, 8.1067238101E-01],
	[2.1410000000E+04, 1.2021654554E+01, 5.2200542346E+00, 2.0238289404E+00, 1.3006184056E+00, 8.1075935335E-01],
	[2.1415000000E+04, 1.2025888180E+01, 5.2199427510E+00, 2.0253374255E+00, 1.3012839055E+00, 8.1084629142E-01],
	[2.1420000000E+04, 1.2030122309E+01, 5.2198312959E+00, 2.0268466813E+00, 1.3019494486E+00, 8.1093319523E-01],
	[2.1425000000E+04, 1.2034356939E+01, 5.2197198692E+00, 2.0283567081E+00, 1.3026150348E+00, 8.1102006478E-01],
	[2.1430000000E+04, 1.2038592072E+01, 5.2196084709E+00, 2.0298675061E+00, 1.3032806641E+00, 8.1110690008E-01],
	[2.1435000000E+04, 1.2042827706E+01, 5.2194971009E+00, 2.0313790755E+00, 1.3039463362E+00, 8.1119370113E-01],
	[2.1440000000E+04, 1.2047063842E+01, 5.2193857593E+00, 2.0328914165E+00, 1.3046120509E+00, 8.1128046794E-01],
	[2.1445000000E+04, 1.2051300480E+01, 5.2192744460E+00, 2.0344045293E+00, 1.3052778082E+00, 8.1136720051E-01],
	[2.1450000000E+04, 1.2055537619E+01, 5.2191631611E+00, 2.0359184142E+00, 1.3059436079E+00, 8.1145389884E-01],
	[2.1455000000E+04, 1.2059775261E+01, 5.2190519044E+00, 2.0374330713E+00, 1.3066094499E+00, 8.1154056294E-01],
	[2.1460000000E+04, 1.2064013403E+01, 5.2189406761E+00, 2.0389485009E+00, 1.3072753339E+00, 8.1162719281E-01],
	[2.1465000000E+04, 1.2068252048E+01, 5.2188294760E+00, 2.0404647032E+00, 1.3079412599E+00, 8.1171378846E-01],
	[2.1470000000E+04, 1.2072491194E+01, 5.2187183042E+00, 2.0419816784E+00, 1.3086072277E+00, 8.1180034989E-01],
	[2.1475000000E+04, 1.2076730841E+01, 5.2186071607E+00, 2.0434994267E+00, 1.3092732371E+00, 8.1188687711E-01],
	[2.1480000000E+04, 1.2080970990E+01, 5.2184960454E+00, 2.0450179484E+00, 1.3099392880E+00, 8.1197337012E-01],
	[2.1485000000E+04, 1.2085211640E+01, 5.2183849583E+00, 2.0465372435E+00, 1.3106053803E+00, 8.1205982892E-01],
	[2.1490000000E+04, 1.2089452791E+01, 5.2182738994E+00, 2.0480573125E+00, 1.3112715138E+00, 8.1214625352E-01],
	[2.1495000000E+04, 1.2093694444E+01, 5.2181628688E+00, 2.0495781553E+00, 1.3119376883E+00, 8.1223264392E-01],
	[2.1500000000E+04, 1.2097936597E+01, 5.2180518663E+00, 2.0510997724E+00, 1.3126039038E+00, 8.1231900013E-01],
	[2.1505000000E+04, 1.2102179252E+01, 5.2179408920E+00, 2.0526221638E+00, 1.3132701600E+00, 8.1240532215E-01],
	[2.1510000000E+04, 1.2106422408E+01, 5.2178299458E+00, 2.0541453299E+00, 1.3139364568E+00, 8.1249160999E-01],
	[2.1515000000E+04, 1.2110666064E+01, 5.2177190278E+00, 2.0556692707E+00, 1.3146027941E+00, 8.1257786365E-01],
	[2.1520000000E+04, 1.2114910222E+01, 5.2176081379E+00, 2.0571939866E+00, 1.3152691717E+00, 8.1266408313E-01],
	[2.1525000000E+04, 1.2119154880E+01, 5.2174972762E+00, 2.0587194777E+00, 1.3159355895E+00, 8.1275026844E-01],
	[2.1530000000E+04, 1.2123400040E+01, 5.2173864425E+00, 2.0602457443E+00, 1.3166020473E+00, 8.1283641959E-01],
	[2.1535000000E+04, 1.2127645700E+01, 5.2172756370E+00, 2.0617727865E+00, 1.3172685449E+00, 8.1292253657E-01],
	[2.1540000000E+04, 1.2131891860E+01, 5.2171648595E+00, 2.0633006047E+00, 1.3179350823E+00, 8.1300861940E-01],
	[2.1545000000E+04, 1.2136138522E+01, 5.2170541100E+00, 2.0648291989E+00, 1.3186016593E+00, 8.1309466808E-01],
	[2.1550000000E+04, 1.2140385683E+01, 5.2169433887E+00, 2.0663585694E+00, 1.3192682757E+00, 8.1318068261E-01],
	[2.1555000000E+04, 1.2144633346E+01, 5.2168326953E+00, 2.0678887165E+00, 1.3199349314E+00, 8.1326666299E-01],
	[2.1560000000E+04, 1.2148881509E+01, 5.2167220300E+00, 2.0694196402E+00, 1.3206016262E+00, 8.1335260924E-01],
	[2.1565000000E+04, 1.2153130172E+01, 5.2166113927E+00, 2.0709513410E+00, 1.3212683600E+00, 8.1343852135E-01],
	[2.1570000000E+04, 1.2157379336E+01, 5.2165007834E+00, 2.0724838188E+00, 1.3219351327E+00, 8.1352439934E-01],
	[2.1575000000E+04, 1.2161628999E+01, 5.2163902020E+00, 2.0740170741E+00, 1.3226019440E+00, 8.1361024320E-01],
	[2.1580000000E+04, 1.2165879164E+01, 5.2162796487E+00, 2.0755511069E+00, 1.3232687939E+00, 8.1369605294E-01],
	[2.1585000000E+04, 1.2170129828E+01, 5.2161691233E+00, 2.0770859176E+00, 1.3239356822E+00, 8.1378182856E-01],
	[2.1590000000E+04, 1.2174380992E+01, 5.2160586258E+00, 2.0786215062E+00, 1.3246026087E+00, 8.1386757008E-01],
	[2.1595000000E+04, 1.2178632657E+01, 5.2159481562E+00, 2.0801578731E+00, 1.3252695733E+00, 8.1395327748E-01],
	[2.1600000000E+04, 1.2182884821E+01, 5.2158377146E+00, 2.0816950184E+00, 1.3259365759E+00, 8.1403895079E-01],
	[2.1605000000E+04, 1.2187137486E+01, 5.2157273009E+00, 2.0832329424E+00, 1.3266036163E+00, 8.1412459000E-01],
	[2.1610000000E+04, 1.2191390650E+01, 5.2156169150E+00, 2.0847716452E+00, 1.3272706943E+00, 8.1421019513E-01],
	[2.1615000000E+04, 1.2195644314E+01, 5.2155065571E+00, 2.0863111271E+00, 1.3279378099E+00, 8.1429576616E-01],
	[2.1620000000E+04, 1.2199898478E+01, 5.2153962269E+00, 2.0878513883E+00, 1.3286049628E+00, 8.1438130311E-01],
	[2.1625000000E+04, 1.2204153141E+01, 5.2152859247E+00, 2.0893924290E+00, 1.3292721530E+00, 8.1446680599E-01],
	[2.1630000000E+04, 1.2208408305E+01, 5.2151756502E+00, 2.0909342495E+00, 1.3299393802E+00, 8.1455227479E-01],
	[2.1635000000E+04, 1.2212663967E+01, 5.2150654036E+00, 2.0924768498E+00, 1.3306066444E+00, 8.1463770953E-01],
	[2.1640000000E+04, 1.2216920130E+01, 5.2149551848E+00, 2.0940202303E+00, 1.3312739453E+00, 8.1472311021E-01],
	[2.1645000000E+04, 1.2221176792E+01, 5.2148449938E+00, 2.0955643912E+00, 1.3319412828E+00, 8.1480847683E-01],
	[2.1650000000E+04, 1.2225433953E+01, 5.2147348306E+00, 2.0971093326E+00, 1.3326086569E+00, 8.1489380939E-01],
	[2.1655000000E+04, 1.2229691614E+01, 5.2146246951E+00, 2.0986550548E+00, 1.3332760672E+00, 8.1497910791E-01],
	[2.1660000000E+04, 1.2233949774E+01, 5.2145145874E+00, 2.1002015580E+00, 1.3339435138E+00, 8.1506437239E-01],
	[2.1665000000E+04, 1.2238208433E+01, 5.2144045074E+00, 2.1017488425E+00, 1.3346109964E+00, 8.1514960283E-01],
	[2.1670000000E+04, 1.2242467591E+01, 5.2142944551E+00, 2.1032969083E+00, 1.3352785149E+00, 8.1523479924E-01],
	[2.1675000000E+04, 1.2246727249E+01, 5.2141844306E+00, 2.1048457558E+00, 1.3359460691E+00, 8.1531996162E-01],
	[2.1680000000E+04, 1.2250987406E+01, 5.2140744337E+00, 2.1063953852E+00, 1.3366136590E+00, 8.1540508998E-01],
	[2.1685000000E+04, 1.2255248062E+01, 5.2139644646E+00, 2.1079457966E+00, 1.3372812843E+00, 8.1549018432E-01],
	[2.1690000000E+04, 1.2259509216E+01, 5.2138545231E+00, 2.1094969902E+00, 1.3379489449E+00, 8.1557524465E-01],
	[2.1695000000E+04, 1.2263770870E+01, 5.2137446092E+00, 2.1110489664E+00, 1.3386166407E+00, 8.1566027098E-01],
	[2.1700000000E+04, 1.2268033022E+01, 5.2136347230E+00, 2.1126017253E+00, 1.3392843715E+00, 8.1574526330E-01],
	[2.1705000000E+04, 1.2272295674E+01, 5.2135248645E+00, 2.1141552671E+00, 1.3399521372E+00, 8.1583022163E-01],
	[2.1710000000E+04, 1.2276558824E+01, 5.2134150335E+00, 2.1157095920E+00, 1.3406199375E+00, 8.1591514596E-01],
	[2.1715000000E+04, 1.2280822473E+01, 5.2133052302E+00, 2.1172647003E+00, 1.3412877725E+00, 8.1600003631E-01],
	[2.1720000000E+04, 1.2285086620E+01, 5.2131954545E+00, 2.1188205921E+00, 1.3419556419E+00, 8.1608489268E-01],
	[2.1725000000E+04, 1.2289351266E+01, 5.2130857063E+00, 2.1203772677E+00, 1.3426235456E+00, 8.1616971508E-01],
	[2.1730000000E+04, 1.2293616410E+01, 5.2129759857E+00, 2.1219347273E+00, 1.3432914834E+00, 8.1625450350E-01],
	[2.1735000000E+04, 1.2297900479E+01, 5.2128704574E+00, 2.1234929711E+00, 1.3439599521E+00, 8.1633925796E-01],
	[2.1740000000E+04, 1.2302186217E+01, 5.2127652179E+00, 2.1250519993E+00, 1.3446284867E+00, 8.1642397846E-01],
	[2.1745000000E+04, 1.2306472462E+01, 5.2126600048E+00, 2.1266118122E+00, 1.3452970558E+00, 8.1650866500E-01],
	[2.1750000000E+04, 1.2310759215E+01, 5.2125548180E+00, 2.1281724098E+00, 1.3459656592E+00, 8.1659331760E-01],
	[2.1755000000E+04, 1.2315046475E+01, 5.2124496575E+00, 2.1297337925E+00, 1.3466342968E+00, 8.1667793625E-01],
	[2.1760000000E+04, 1.2319334242E+01, 5.2123445232E+00, 2.1312959605E+00, 1.3473029684E+00, 8.1676252096E-01],
	[2.1765000000E+04, 1.2323622516E+01, 5.2122394153E+00, 2.1328589140E+00, 1.3479716740E+00, 8.1684707174E-01],
	[2.1770000000E+04, 1.2327911298E+01, 5.2121343336E+00, 2.1344226532E+00, 1.3486404133E+00, 8.1693158860E-01],
	[2.1775000000E+04, 1.2332200587E+01, 5.2120292782E+00, 2.1359871782E+00, 1.3493091862E+00, 8.1701607153E-01],
	[2.1780000000E+04, 1.2336490383E+01, 5.2119242490E+00, 2.1375524894E+00, 1.3499779925E+00, 8.1710052054E-01],
	[2.1785000000E+04, 1.2340780686E+01, 5.2118192460E+00, 2.1391185870E+00, 1.3506468322E+00, 8.1718493564E-01],
	[2.1790000000E+04, 1.2345071495E+01, 5.2117142692E+00, 2.1406854710E+00, 1.3513157050E+00, 8.1726931684E-01],
	[2.1795000000E+04, 1.2349362812E+01, 5.2116093187E+00, 2.1422531419E+00, 1.3519846108E+00, 8.1735366414E-01],
	[2.1800000000E+04, 1.2353654636E+01, 5.2115043943E+00, 2.1438215997E+00, 1.3526535496E+00, 8.1743797754E-01],
	[2.1805000000E+04, 1.2357946966E+01, 5.2113994961E+00, 2.1453908447E+00, 1.3533225210E+00, 8.1752225705E-01],
	[2.1810000000E+04, 1.2362239803E+01, 5.2112946240E+00, 2.1469608771E+00, 1.3539915250E+00, 8.1760650268E-01],
	[2.1815000000E+04, 1.2366533147E+01, 5.2111897781E+00, 2.1485316971E+00, 1.3546605615E+00, 8.1769071443E-01],
	[2.1820000000E+04, 1.2370826998E+01, 5.2110849584E+00, 2.1501033049E+00, 1.3553296303E+00, 8.1777489231E-01],
	[2.1825000000E+04, 1.2375121355E+01, 5.2109801648E+00, 2.1516757008E+00, 1.3559987312E+00, 8.1785903632E-01],
	[2.1830000000E+04, 1.2379416218E+01, 5.2108753972E+00, 2.1532488850E+00, 1.3566678641E+00, 8.1794314647E-01],
	[2.1835000000E+04, 1.2383711588E+01, 5.2107706558E+00, 2.1548228576E+00, 1.3573370289E+00, 8.1802722276E-01],
	[2.1840000000E+04, 1.2388007464E+01, 5.2106659405E+00, 2.1563976189E+00, 1.3580062254E+00, 8.1811126520E-01],
	[2.1845000000E+04, 1.2392303847E+01, 5.2105612512E+00, 2.1579731691E+00, 1.3586754534E+00, 8.1819527380E-01],
	[2.1850000000E+04, 1.2396600736E+01, 5.2104565880E+00, 2.1595495084E+00, 1.3593447129E+00, 8.1827924857E-01],
	[2.1855000000E+04, 1.2400898131E+01, 5.2103519509E+00, 2.1611266370E+00, 1.3600140037E+00, 8.1836318953E-01],
	[2.1860000000E+04, 1.2405196033E+01, 5.2102473398E+00, 2.1627045552E+00, 1.3606833256E+00, 8.1844709669E-01],
	[2.1865000000E+04, 1.2409494440E+01, 5.2101427547E+00, 2.1642832632E+00, 1.3613526784E+00, 8.1853097005E-01],
	[2.1870000000E+04, 1.2413793354E+01, 5.2100381956E+00, 2.1658627610E+00, 1.3620220622E+00, 8.1861480962E-01],
	[2.1875000000E+04, 1.2418092773E+01, 5.2099336625E+00, 2.1674430491E+00, 1.3626914766E+00, 8.1869861540E-01],
	[2.1880000000E+04, 1.2422392699E+01, 5.2098291554E+00, 2.1690241276E+00, 1.3633609216E+00, 8.1878238739E-01],
	[2.1885000000E+04, 1.2426693130E+01, 5.2097246743E+00, 2.1706059967E+00, 1.3640303969E+00, 8.1886612561E-01],
	[2.1890000000E+04, 1.2430994067E+01, 5.2096202191E+00, 2.1721886566E+00, 1.3646999026E+00, 8.1894983005E-01],
	[2.1895000000E+04, 1.2435295510E+01, 5.2095157899E+00, 2.1737721075E+00, 1.3653694384E+00, 8.1903350072E-01],
	[2.1900000000E+04, 1.2439597459E+01, 5.2094113867E+00, 2.1753563497E+00, 1.3660390041E+00, 8.1911713762E-01],
	[2.1905000000E+04, 1.2443899913E+01, 5.2093070093E+00, 2.1769413833E+00, 1.3667085997E+00, 8.1920074076E-01],
	[2.1910000000E+04, 1.2448202873E+01, 5.2092026579E+00, 2.1785272086E+00, 1.3673782249E+00, 8.1928431014E-01],
	[2.1915000000E+04, 1.2452506339E+01, 5.2090983324E+00, 2.1801138258E+00, 1.3680478797E+00, 8.1936784577E-01],
	[2.1920000000E+04, 1.2456810310E+01, 5.2089940327E+00, 2.1817012351E+00, 1.3687175639E+00, 8.1945134765E-01],
	[2.1925000000E+04, 1.2461114787E+01, 5.2088897590E+00, 2.1832894368E+00, 1.3693872774E+00, 8.1953481578E-01],
	[2.1930000000E+04, 1.2465419768E+01, 5.2087855111E+00, 2.1848784309E+00, 1.3700570199E+00, 8.1961825017E-01],
	[2.1935000000E+04, 1.2469725256E+01, 5.2086812890E+00, 2.1864682178E+00, 1.3707267914E+00, 8.1970165083E-01],
	[2.1940000000E+04, 1.2474031248E+01, 5.2085770928E+00, 2.1880587977E+00, 1.3713965918E+00, 8.1978501775E-01],
	[2.1945000000E+04, 1.2478337746E+01, 5.2084729224E+00, 2.1896501707E+00, 1.3720664208E+00, 8.1986835095E-01],
	[2.1950000000E+04, 1.2482644749E+01, 5.2083687779E+00, 2.1912423371E+00, 1.3727362783E+00, 8.1995165042E-01],
	[2.1955000000E+04, 1.2486952257E+01, 5.2082646591E+00, 2.1928352972E+00, 1.3734061643E+00, 8.2003491618E-01],
	[2.1960000000E+04, 1.2491260270E+01, 5.2081605661E+00, 2.1944290510E+00, 1.3740760784E+00, 8.2011814822E-01],
	[2.1965000000E+04, 1.2495568788E+01, 5.2080564989E+00, 2.1960235989E+00, 1.3747460207E+00, 8.2020134656E-01],
	[2.1970000000E+04, 1.2499877811E+01, 5.2079524575E+00, 2.1976189410E+00, 1.3754159909E+00, 8.2028451119E-01],
	[2.1975000000E+04, 1.2504187339E+01, 5.2078484418E+00, 2.1992150775E+00, 1.3760859890E+00, 8.2036764212E-01],
	[2.1980000000E+04, 1.2508497371E+01, 5.2077444519E+00, 2.2008120088E+00, 1.3767560147E+00, 8.2045073935E-01],
	[2.1985000000E+04, 1.2512807909E+01, 5.2076404877E+00, 2.2024097349E+00, 1.3774260679E+00, 8.2053380290E-01],
	[2.1990000000E+04, 1.2517118951E+01, 5.2075365492E+00, 2.2040082561E+00, 1.3780961485E+00, 8.2061683276E-01],
	[2.1995000000E+04, 1.2521430498E+01, 5.2074326364E+00, 2.2056075726E+00, 1.3787662563E+00, 8.2069982894E-01],
	[2.2000000000E+04, 1.2525742549E+01, 5.2073287493E+00, 2.2072076847E+00, 1.3794363913E+00, 8.2078279144E-01],
	[2.2005000000E+04, 1.2530055105E+01, 5.2072248879E+00, 2.2088085925E+00, 1.3801065531E+00, 8.2086572027E-01],
	[2.2010000000E+04, 1.2534368166E+01, 5.2071210521E+00, 2.2104102962E+00, 1.3807767418E+00, 8.2094861544E-01],
	[2.2015000000E+04, 1.2538681731E+01, 5.2070172420E+00, 2.2120127961E+00, 1.3814469572E+00, 8.2103147694E-01],
	[2.2020000000E+04, 1.2542995800E+01, 5.2069134576E+00, 2.2136160924E+00, 1.3821171990E+00, 8.2111430479E-01],
	[2.2025000000E+04, 1.2547310374E+01, 5.2068096988E+00, 2.2152201853E+00, 1.3827874673E+00, 8.2119709898E-01],
	[2.2030000000E+04, 1.2551625452E+01, 5.2067059656E+00, 2.2168250750E+00, 1.3834577617E+00, 8.2127985953E-01],
	[2.2035000000E+04, 1.2555941034E+01, 5.2066022580E+00, 2.2184307617E+00, 1.3841280823E+00, 8.2136258643E-01],
	[2.2040000000E+04, 1.2560257120E+01, 5.2064985760E+00, 2.2200372457E+00, 1.3847984288E+00, 8.2144527970E-01],
	[2.2045000000E+04, 1.2564573711E+01, 5.2063949195E+00, 2.2216445271E+00, 1.3854688011E+00, 8.2152793933E-01],
	[2.2050000000E+04, 1.2568890805E+01, 5.2062912887E+00, 2.2232526061E+00, 1.3861391990E+00, 8.2161056534E-01],
	[2.2055000000E+04, 1.2573208403E+01, 5.2061876834E+00, 2.2248614831E+00, 1.3868096225E+00, 8.2169315772E-01],
	[2.2060000000E+04, 1.2577526506E+01, 5.2060841037E+00, 2.2264711581E+00, 1.3874800713E+00, 8.2177571649E-01],
	[2.2065000000E+04, 1.2581845112E+01, 5.2059805495E+00, 2.2280816315E+00, 1.3881505454E+00, 8.2185824164E-01],
	[2.2070000000E+04, 1.2586164222E+01, 5.2058770208E+00, 2.2296929033E+00, 1.3888210445E+00, 8.2194073318E-01],
	[2.2075000000E+04, 1.2590483836E+01, 5.2057735176E+00, 2.2313049739E+00, 1.3894915686E+00, 8.2202319112E-01],
	[2.2080000000E+04, 1.2594803954E+01, 5.2056700399E+00, 2.2329178435E+00, 1.3901621175E+00, 8.2210561547E-01],
	[2.2085000000E+04, 1.2599143917E+01, 5.2055708389E+00, 2.2345315122E+00, 1.3908332302E+00, 8.2218800622E-01],
	[2.2090000000E+04, 1.2603484888E+01, 5.2054717708E+00, 2.2361459803E+00, 1.3915043820E+00, 8.2227036338E-01],
	[2.2095000000E+04, 1.2607826371E+01, 5.2053727271E+00, 2.2377612480E+00, 1.3921755590E+00, 8.2235268696E-01],
	[2.2100000000E+04, 1.2612168367E+01, 5.2052737077E+00, 2.2393773155E+00, 1.3928467609E+00, 8.2243497696E-01],
	[2.2105000000E+04, 1.2616510875E+01, 5.2051747126E+00, 2.2409941830E+00, 1.3935179878E+00, 8.2251723340E-01],
	[2.2110000000E+04, 1.2620853896E+01, 5.2050757417E+00, 2.2426118508E+00, 1.3941892393E+00, 8.2259945626E-01],
	[2.2115000000E+04, 1.2625197430E+01, 5.2049767951E+00, 2.2442303189E+00, 1.3948605155E+00, 8.2268164556E-01],
	[2.2120000000E+04, 1.2629541476E+01, 5.2048778727E+00, 2.2458495878E+00, 1.3955318161E+00, 8.2276380130E-01],
	[2.2125000000E+04, 1.2633886034E+01, 5.2047789746E+00, 2.2474696575E+00, 1.3962031410E+00, 8.2284592350E-01],
	[2.2130000000E+04, 1.2638231105E+01, 5.2046801007E+00, 2.2490905284E+00, 1.3968744901E+00, 8.2292801214E-01],
	[2.2135000000E+04, 1.2642576687E+01, 5.2045812510E+00, 2.2507122005E+00, 1.3975458631E+00, 8.2301006725E-01],
	[2.2140000000E+04, 1.2646922782E+01, 5.2044824256E+00, 2.2523346741E+00, 1.3982172601E+00, 8.2309208882E-01],
	[2.2145000000E+04, 1.2651269390E+01, 5.2043836243E+00, 2.2539579495E+00, 1.3988886808E+00, 8.2317407686E-01],
	[2.2150000000E+04, 1.2655616509E+01, 5.2042848472E+00, 2.2555820268E+00, 1.3995601251E+00, 8.2325603137E-01],
	[2.2155000000E+04, 1.2659964140E+01, 5.2041860942E+00, 2.2572069063E+00, 1.4002315928E+00, 8.2333795236E-01],
	[2.2160000000E+04, 1.2664312283E+01, 5.2040873655E+00, 2.2588325882E+00, 1.4009030838E+00, 8.2341983984E-01],
	[2.2165000000E+04, 1.2668660939E+01, 5.2039886608E+00, 2.2604590726E+00, 1.4015745980E+00, 8.2350169381E-01],
	[2.2170000000E+04, 1.2673010106E+01, 5.2038899803E+00, 2.2620863599E+00, 1.4022461353E+00, 8.2358351428E-01],
	[2.2175000000E+04, 1.2677359785E+01, 5.2037913240E+00, 2.2637144502E+00, 1.4029176954E+00, 8.2366530124E-01],
	[2.2180000000E+04, 1.2681709975E+01, 5.2036926917E+00, 2.2653433437E+00, 1.4035892782E+00, 8.2374705472E-01],
	[2.2185000000E+04, 1.2686060678E+01, 5.2035940836E+00, 2.2669730406E+00, 1.4042608837E+00, 8.2382877470E-01],
	[2.2190000000E+04, 1.2690411892E+01, 5.2034954995E+00, 2.2686035412E+00, 1.4049325116E+00, 8.2391046121E-01],
	[2.2195000000E+04, 1.2694763617E+01, 5.2033969395E+00, 2.2702348457E+00, 1.4056041618E+00, 8.2399211423E-01],
	[2.2200000000E+04, 1.2699115854E+01, 5.2032984036E+00, 2.2718669543E+00, 1.4062758342E+00, 8.2407373379E-01],
	[2.2205000000E+04, 1.2703468603E+01, 5.2031998917E+00, 2.2734998672E+00, 1.4069475286E+00, 8.2415531988E-01],
	[2.2210000000E+04, 1.2707821863E+01, 5.2031014039E+00, 2.2751335845E+00, 1.4076192449E+00, 8.2423687251E-01],
	[2.2215000000E+04, 1.2712175634E+01, 5.2030029401E+00, 2.2767681067E+00, 1.4082909830E+00, 8.2431839168E-01],
	[2.2220000000E+04, 1.2716529917E+01, 5.2029045003E+00, 2.2784034337E+00, 1.4089627426E+00, 8.2439987741E-01],
	[2.2225000000E+04, 1.2720884711E+01, 5.2028060845E+00, 2.2800395660E+00, 1.4096345238E+00, 8.2448132969E-01],
	[2.2230000000E+04, 1.2725240016E+01, 5.2027076928E+00, 2.2816765036E+00, 1.4103063262E+00, 8.2456274853E-01],
	[2.2235000000E+04, 1.2729595833E+01, 5.2026093250E+00, 2.2833142468E+00, 1.4109781499E+00, 8.2464413394E-01],
	[2.2240000000E+04, 1.2733952160E+01, 5.2025109812E+00, 2.2849527958E+00, 1.4116499946E+00, 8.2472548592E-01],
	[2.2245000000E+04, 1.2738308999E+01, 5.2024126614E+00, 2.2865921508E+00, 1.4123218601E+00, 8.2480680449E-01],
	[2.2250000000E+04, 1.2742666348E+01, 5.2023143655E+00, 2.2882323121E+00, 1.4129937465E+00, 8.2488808963E-01],
	[2.2255000000E+04, 1.2747024209E+01, 5.2022160936E+00, 2.2898732798E+00, 1.4136656534E+00, 8.2496934137E-01],
	[2.2260000000E+04, 1.2751382580E+01, 5.2021178456E+00, 2.2915150541E+00, 1.4143375809E+00, 8.2505055970E-01],
	[2.2265000000E+04, 1.2755741462E+01, 5.2020196215E+00, 2.2931576353E+00, 1.4150095287E+00, 8.2513174464E-01],
	[2.2270000000E+04, 1.2760100855E+01, 5.2019214213E+00, 2.2948010237E+00, 1.4156814966E+00, 8.2521289618E-01],
	[2.2275000000E+04, 1.2764460758E+01, 5.2018232451E+00, 2.2964452193E+00, 1.4163534847E+00, 8.2529401433E-01],
	[2.2280000000E+04, 1.2768821173E+01, 5.2017250927E+00, 2.2980902224E+00, 1.4170254926E+00, 8.2537509911E-01],
	[2.2285000000E+04, 1.2773182097E+01, 5.2016269642E+00, 2.2997360333E+00, 1.4176975203E+00, 8.2545615050E-01],
	[2.2290000000E+04, 1.2777543533E+01, 5.2015288595E+00, 2.3013826521E+00, 1.4183695677E+00, 8.2553716853E-01],
	[2.2295000000E+04, 1.2781905479E+01, 5.2014307787E+00, 2.3030300791E+00, 1.4190416345E+00, 8.2561815320E-01],
	[2.2300000000E+04, 1.2786267935E+01, 5.2013327218E+00, 2.3046783145E+00, 1.4197137207E+00, 8.2569910450E-01],
	[2.2305000000E+04, 1.2790630902E+01, 5.2012346887E+00, 2.3063273584E+00, 1.4203858261E+00, 8.2578002246E-01],
	[2.2310000000E+04, 1.2794994379E+01, 5.2011366794E+00, 2.3079772112E+00, 1.4210579505E+00, 8.2586090707E-01],
	[2.2315000000E+04, 1.2799358366E+01, 5.2010386939E+00, 2.3096278730E+00, 1.4217300939E+00, 8.2594175833E-01],
	[2.2320000000E+04, 1.2803722864E+01, 5.2009407322E+00, 2.3112793440E+00, 1.4224022561E+00, 8.2602257627E-01],
	[2.2325000000E+04, 1.2808087871E+01, 5.2008427943E+00, 2.3129316244E+00, 1.4230744370E+00, 8.2610336087E-01],
	[2.2330000000E+04, 1.2812453389E+01, 5.2007448802E+00, 2.3145847146E+00, 1.4237466363E+00, 8.2618411215E-01],
	[2.2335000000E+04, 1.2816819417E+01, 5.2006469898E+00, 2.3162386146E+00, 1.4244188540E+00, 8.2626483012E-01],
	[2.2340000000E+04, 1.2821185955E+01, 5.2005491232E+00, 2.3178933247E+00, 1.4250910900E+00, 8.2634551477E-01],
	[2.2345000000E+04, 1.2825553002E+01, 5.2004512803E+00, 2.3195488450E+00, 1.4257633440E+00, 8.2642616612E-01],
	[2.2350000000E+04, 1.2829920560E+01, 5.2003534612E+00, 2.3212051760E+00, 1.4264356160E+00, 8.2650678417E-01],
	[2.2355000000E+04, 1.2834288628E+01, 5.2002556658E+00, 2.3228623176E+00, 1.4271079057E+00, 8.2658736893E-01],
	[2.2360000000E+04, 1.2838657205E+01, 5.2001578941E+00, 2.3245202702E+00, 1.4277802132E+00, 8.2666792040E-01],
	[2.2365000000E+04, 1.2843026292E+01, 5.2000601461E+00, 2.3261890640E+00, 1.4284563204E+00, 8.2674843859E-01],
	[2.2370000000E+04, 1.2847395889E+01, 5.1999624217E+00, 2.3278603150E+00, 1.4291330616E+00, 8.2682892350E-01],
	[2.2375000000E+04, 1.2851765995E+01, 5.1998647211E+00, 2.3295323916E+00, 1.4298098210E+00, 8.2690937515E-01],
	[2.2380000000E+04, 1.2856136611E+01, 5.1997670441E+00, 2.3312052941E+00, 1.4304865986E+00, 8.2698979354E-01],
	[2.2385000000E+04, 1.2860507736E+01, 5.1996693908E+00, 2.3328790227E+00, 1.4311633942E+00, 8.2707017867E-01],
	[2.2390000000E+04, 1.2864879371E+01, 5.1995717611E+00, 2.3345535775E+00, 1.4318402075E+00, 8.2715053054E-01],
	[2.2395000000E+04, 1.2869251515E+01, 5.1994741551E+00, 2.3362289589E+00, 1.4325170386E+00, 8.2723084918E-01],
	[2.2400000000E+04, 1.2873624169E+01, 5.1993765726E+00, 2.3379051671E+00, 1.4331938871E+00, 8.2731113458E-01],
	[2.2405000000E+04, 1.2877997332E+01, 5.1992790138E+00, 2.3395822022E+00, 1.4338707531E+00, 8.2739138674E-01],
	[2.2410000000E+04, 1.2882371004E+01, 5.1991814786E+00, 2.3412600645E+00, 1.4345476363E+00, 8.2747160568E-01],
	[2.2415000000E+04, 1.2886745185E+01, 5.1990839670E+00, 2.3429387542E+00, 1.4352245367E+00, 8.2755179140E-01],
	[2.2420000000E+04, 1.2891119876E+01, 5.1989864789E+00, 2.3446182716E+00, 1.4359014540E+00, 8.2763194391E-01],
	[2.2425000000E+04, 1.2895495075E+01, 5.1988890144E+00, 2.3462986168E+00, 1.4365783881E+00, 8.2771206321E-01],
	[2.2430000000E+04, 1.2899870784E+01, 5.1987915735E+00, 2.3479797902E+00, 1.4372553389E+00, 8.2779214931E-01],
	[2.2435000000E+04, 1.2904247001E+01, 5.1986941561E+00, 2.3496617918E+00, 1.4379323063E+00, 8.2787220222E-01],
	[2.2440000000E+04, 1.2908641469E+01, 5.1986005540E+00, 2.3513446219E+00, 1.4386098007E+00, 8.2795222194E-01],
	[2.2445000000E+04, 1.2913038803E+01, 5.1985074764E+00, 2.3530282808E+00, 1.4392873798E+00, 8.2803220848E-01],
	[2.2450000000E+04, 1.2917436656E+01, 5.1984144212E+00, 2.3547127687E+00, 1.4399649759E+00, 8.2811216184E-01],
	[2.2455000000E+04, 1.2921835026E+01, 5.1983213884E+00, 2.3563980857E+00, 1.4406425886E+00, 8.2819208203E-01],
	[2.2460000000E+04, 1.2926233914E+01, 5.1982283780E+00, 2.3580842322E+00, 1.4413202181E+00, 8.2827196906E-01],
	[2.2465000000E+04, 1.2930633319E+01, 5.1981353899E+00, 2.3597712084E+00, 1.4419978640E+00, 8.2835182294E-01],
	[2.2470000000E+04, 1.2935033243E+01, 5.1980424242E+00, 2.3614590143E+00, 1.4426755263E+00, 8.2843164366E-01],
	[2.2475000000E+04, 1.2939433684E+01, 5.1979494808E+00, 2.3631476504E+00, 1.4433532047E+00, 8.2851143125E-01],
	[2.2480000000E+04, 1.2943834643E+01, 5.1978565598E+00, 2.3648371168E+00, 1.4440308993E+00, 8.2859118569E-01],
	[2.2485000000E+04, 1.2948236120E+01, 5.1977636611E+00, 2.3665274137E+00, 1.4447086097E+00, 8.2867090701E-01],
	[2.2490000000E+04, 1.2952638114E+01, 5.1976707847E+00, 2.3682185414E+00, 1.4453863360E+00, 8.2875059520E-01],
	[2.2495000000E+04, 1.2957040625E+01, 5.1975779307E+00, 2.3699105000E+00, 1.4460640779E+00, 8.2883025027E-01],
	[2.2500000000E+04, 1.2961443655E+01, 5.1974850989E+00, 2.3716032899E+00, 1.4467418353E+00, 8.2890987224E-01],
	[2.2505000000E+04, 1.2965847201E+01, 5.1973922894E+00, 2.3732969111E+00, 1.4474196080E+00, 8.2898946109E-01],
	[2.2510000000E+04, 1.2970251265E+01, 5.1972995022E+00, 2.3749913640E+00, 1.4480973960E+00, 8.2906901685E-01],
	[2.2515000000E+04, 1.2974655846E+01, 5.1972067372E+00, 2.3766866488E+00, 1.4487751990E+00, 8.2914853952E-01],
	[2.2520000000E+04, 1.2979060944E+01, 5.1971139945E+00, 2.3783827657E+00, 1.4494530170E+00, 8.2922802911E-01],
	[2.2525000000E+04, 1.2983466559E+01, 5.1970212740E+00, 2.3800797148E+00, 1.4501308498E+00, 8.2930748562E-01],
	[2.2530000000E+04, 1.2987872692E+01, 5.1969285758E+00, 2.3817774966E+00, 1.4508086972E+00, 8.2938690905E-01],
	[2.2535000000E+04, 1.2992279341E+01, 5.1968358998E+00, 2.3834761110E+00, 1.4514865592E+00, 8.2946629942E-01],
	[2.2540000000E+04, 1.2996686508E+01, 5.1967432460E+00, 2.3851755585E+00, 1.4521644355E+00, 8.2954565673E-01],
	[2.2545000000E+04, 1.3001094192E+01, 5.1966506144E+00, 2.3868758391E+00, 1.4528423261E+00, 8.2962498099E-01],
	[2.2550000000E+04, 1.3005502392E+01, 5.1965580050E+00, 2.3885769532E+00, 1.4535202307E+00, 8.2970427221E-01],
	[2.2555000000E+04, 1.3009911109E+01, 5.1964654178E+00, 2.3902789009E+00, 1.4541981493E+00, 8.2978353039E-01],
	[2.2560000000E+04, 1.3014320343E+01, 5.1963728528E+00, 2.3919816825E+00, 1.4548760817E+00, 8.2986275553E-01],
	[2.2565000000E+04, 1.3018730094E+01, 5.1962803099E+00, 2.3936852982E+00, 1.4555540278E+00, 8.2994194765E-01],
	[2.2570000000E+04, 1.3023140362E+01, 5.1961877891E+00, 2.3953897482E+00, 1.4562319874E+00, 8.3002110675E-01],
	[2.2575000000E+04, 1.3027551146E+01, 5.1960952905E+00, 2.3970950327E+00, 1.4569099603E+00, 8.3010023284E-01],
	[2.2580000000E+04, 1.3031962447E+01, 5.1960028141E+00, 2.3988011520E+00, 1.4575879466E+00, 8.3017932593E-01],
	[2.2585000000E+04, 1.3036374264E+01, 5.1959103597E+00, 2.4005081063E+00, 1.4582659459E+00, 8.3025838602E-01],
	[2.2590000000E+04, 1.3040786597E+01, 5.1958179275E+00, 2.4022158958E+00, 1.4589439582E+00, 8.3033741311E-01],
	[2.2595000000E+04, 1.3045199448E+01, 5.1957255174E+00, 2.4039245207E+00, 1.4596219833E+00, 8.3041640722E-01],
	[2.2600000000E+04, 1.3049612814E+01, 5.1956331293E+00, 2.4056339813E+00, 1.4603000212E+00, 8.3049536836E-01],
	[2.2605000000E+04, 1.3054026697E+01, 5.1955407634E+00, 2.4073442777E+00, 1.4609780715E+00, 8.3057429652E-01],
	[2.2610000000E+04, 1.3058441096E+01, 5.1954484195E+00, 2.4090554103E+00, 1.4616561343E+00, 8.3065319172E-01],
	[2.2615000000E+04, 1.3062856011E+01, 5.1953560977E+00, 2.4107673791E+00, 1.4623342093E+00, 8.3073205396E-01],
	[2.2620000000E+04, 1.3067271442E+01, 5.1952637979E+00, 2.4124801845E+00, 1.4630122965E+00, 8.3081088326E-01],
	[2.2625000000E+04, 1.3071687390E+01, 5.1951715201E+00, 2.4141938267E+00, 1.4636903956E+00, 8.3088967960E-01],
	[2.2630000000E+04, 1.3076103853E+01, 5.1950792644E+00, 2.4159083059E+00, 1.4643685066E+00, 8.3096844302E-01],
	[2.2635000000E+04, 1.3080520833E+01, 5.1949870307E+00, 2.4176236223E+00, 1.4650466293E+00, 8.3104717350E-01],
	[2.2640000000E+04, 1.3084938328E+01, 5.1948948190E+00, 2.4193397761E+00, 1.4657247635E+00, 8.3112587106E-01],
	[2.2645000000E+04, 1.3089356339E+01, 5.1948026293E+00, 2.4210567675E+00, 1.4664029092E+00, 8.3120453570E-01],
	[2.2650000000E+04, 1.3093774867E+01, 5.1947104616E+00, 2.4227745969E+00, 1.4670810662E+00, 8.3128316744E-01],
	[2.2655000000E+04, 1.3098193909E+01, 5.1946183159E+00, 2.4244932643E+00, 1.4677592343E+00, 8.3136176627E-01],
	[2.2660000000E+04, 1.3102613468E+01, 5.1945261922E+00, 2.4262127701E+00, 1.4684374134E+00, 8.3144033221E-01],
	[2.2665000000E+04, 1.3107033542E+01, 5.1944340904E+00, 2.4279331145E+00, 1.4691156034E+00, 8.3151886526E-01],
	[2.2670000000E+04, 1.3111454132E+01, 5.1943420105E+00, 2.4296542976E+00, 1.4697938041E+00, 8.3159736544E-01],
	[2.2675000000E+04, 1.3115875238E+01, 5.1942499526E+00, 2.4313763196E+00, 1.4704720154E+00, 8.3167583273E-01],
	[2.2680000000E+04, 1.3120296858E+01, 5.1941579166E+00, 2.4330991810E+00, 1.4711502372E+00, 8.3175426716E-01],
	[2.2685000000E+04, 1.3124718995E+01, 5.1940659026E+00, 2.4348228817E+00, 1.4718284692E+00, 8.3183266873E-01],
	[2.2690000000E+04, 1.3129141646E+01, 5.1939739104E+00, 2.4365474221E+00, 1.4725067115E+00, 8.3191103745E-01],
	[2.2695000000E+04, 1.3133564814E+01, 5.1938819402E+00, 2.4382728024E+00, 1.4731849637E+00, 8.3198937333E-01],
	[2.2700000000E+04, 1.3137988496E+01, 5.1937899918E+00, 2.4399990229E+00, 1.4738632259E+00, 8.3206767636E-01],
	[2.2705000000E+04, 1.3142412694E+01, 5.1936980653E+00, 2.4417260836E+00, 1.4745414978E+00, 8.3214594656E-01],
	[2.2710000000E+04, 1.3146837406E+01, 5.1936061607E+00, 2.4434539849E+00, 1.4752197793E+00, 8.3222418394E-01],
	[2.2715000000E+04, 1.3151262634E+01, 5.1935142779E+00, 2.4451827270E+00, 1.4758980703E+00, 8.3230238851E-01],
	[2.2720000000E+04, 1.3155688377E+01, 5.1934224170E+00, 2.4469123101E+00, 1.4765763706E+00, 8.3238056026E-01],
	[2.2725000000E+04, 1.3160114635E+01, 5.1933305780E+00, 2.4486427344E+00, 1.4772546801E+00, 8.3245869921E-01],
	[2.2730000000E+04, 1.3164541408E+01, 5.1932387607E+00, 2.4503740002E+00, 1.4779329987E+00, 8.3253680537E-01],
	[2.2735000000E+04, 1.3168968696E+01, 5.1931469653E+00, 2.4521061076E+00, 1.4786113262E+00, 8.3261487873E-01],
	[2.2740000000E+04, 1.3173396499E+01, 5.1930551916E+00, 2.4538390569E+00, 1.4792896625E+00, 8.3269291932E-01],
	[2.2745000000E+04, 1.3177824816E+01, 5.1929634398E+00, 2.4555728483E+00, 1.4799680074E+00, 8.3277092713E-01],
	[2.2750000000E+04, 1.3182253648E+01, 5.1928717098E+00, 2.4573074821E+00, 1.4806463608E+00, 8.3284890218E-01],
	[2.2755000000E+04, 1.3186682995E+01, 5.1927800015E+00, 2.4590429585E+00, 1.4813247226E+00, 8.3292684447E-01],
	[2.2760000000E+04, 1.3191112857E+01, 5.1926883150E+00, 2.4607792776E+00, 1.4820030926E+00, 8.3300475400E-01],
	[2.2765000000E+04, 1.3195543233E+01, 5.1925966503E+00, 2.4625164397E+00, 1.4826814707E+00, 8.3308263079E-01],
	[2.2770000000E+04, 1.3199974124E+01, 5.1925050073E+00, 2.4642544451E+00, 1.4833598568E+00, 8.3316047484E-01],
	[2.2775000000E+04, 1.3204405529E+01, 5.1924133861E+00, 2.4659932939E+00, 1.4840382506E+00, 8.3323828617E-01],
	[2.2780000000E+04, 1.3208837449E+01, 5.1923217866E+00, 2.4677329864E+00, 1.4847166522E+00, 8.3331606477E-01],
	[2.2785000000E+04, 1.3213269883E+01, 5.1922302088E+00, 2.4694735229E+00, 1.4853950612E+00, 8.3339381065E-01],
	[2.2790000000E+04, 1.3217702831E+01, 5.1921386527E+00, 2.4712149034E+00, 1.4860734777E+00, 8.3347152383E-01],
	[2.2795000000E+04, 1.3222136294E+01, 5.1920471183E+00, 2.4729571283E+00, 1.4867519014E+00, 8.3354920431E-01],
	[2.2800000000E+04, 1.3226583428E+01, 5.1919583401E+00, 2.4747001977E+00, 1.4874307231E+00, 8.3362685209E-01],
	[2.2805000000E+04, 1.3231038275E+01, 5.1918710772E+00, 2.4764441120E+00, 1.4881097660E+00, 8.3370446719E-01],
	[2.2810000000E+04, 1.3235493645E+01, 5.1917838349E+00, 2.4781888712E+00, 1.4887888166E+00, 8.3378204961E-01],
	[2.2815000000E+04, 1.3239949539E+01, 5.1916966133E+00, 2.4799344757E+00, 1.4894678747E+00, 8.3385959936E-01],
	[2.2820000000E+04, 1.3244405956E+01, 5.1916094122E+00, 2.4816809257E+00, 1.4901469402E+00, 8.3393711645E-01],
	[2.2825000000E+04, 1.3248862896E+01, 5.1915222316E+00, 2.4834282214E+00, 1.4908260129E+00, 8.3401460088E-01],
	[2.2830000000E+04, 1.3253320359E+01, 5.1914350717E+00, 2.4851763629E+00, 1.4915050927E+00, 8.3409205266E-01],
	[2.2835000000E+04, 1.3257778345E+01, 5.1913479322E+00, 2.4869253506E+00, 1.4921841795E+00, 8.3416947180E-01],
	[2.2840000000E+04, 1.3262236854E+01, 5.1912608133E+00, 2.4886751847E+00, 1.4928632731E+00, 8.3424685831E-01],
	[2.2845000000E+04, 1.3266695886E+01, 5.1911737150E+00, 2.4904258653E+00, 1.4935423734E+00, 8.3432421219E-01],
	[2.2850000000E+04, 1.3271155441E+01, 5.1910866372E+00, 2.4921773928E+00, 1.4942214803E+00, 8.3440153345E-01],
	[2.2855000000E+04, 1.3275615519E+01, 5.1909995798E+00, 2.4939297672E+00, 1.4949005936E+00, 8.3447882210E-01],
	[2.2860000000E+04, 1.3280076120E+01, 5.1909125430E+00, 2.4956829889E+00, 1.4955797131E+00, 8.3455607815E-01],
	[2.2865000000E+04, 1.3284537243E+01, 5.1908255267E+00, 2.4974370581E+00, 1.4962588389E+00, 8.3463330160E-01],
	[2.2870000000E+04, 1.3288998889E+01, 5.1907385309E+00, 2.4991919750E+00, 1.4969379706E+00, 8.3471049247E-01],
	[2.2875000000E+04, 1.3293461058E+01, 5.1906515555E+00, 2.5009477398E+00, 1.4976171081E+00, 8.3478765075E-01],
	[2.2880000000E+04, 1.3297923749E+01, 5.1905646006E+00, 2.5027043528E+00, 1.4982962514E+00, 8.3486477646E-01],
	[2.2885000000E+04, 1.3302386963E+01, 5.1904776662E+00, 2.5044618141E+00, 1.4989754004E+00, 8.3494186961E-01],
	[2.2890000000E+04, 1.3306850699E+01, 5.1903907522E+00, 2.5062201240E+00, 1.4996545547E+00, 8.3501893019E-01],
	[2.2895000000E+04, 1.3311314958E+01, 5.1903038586E+00, 2.5079792827E+00, 1.5003337144E+00, 8.3509595823E-01],
	[2.2900000000E+04, 1.3315779739E+01, 5.1902169855E+00, 2.5097392905E+00, 1.5010128793E+00, 8.3517295373E-01],
	[2.2905000000E+04, 1.3320245042E+01, 5.1901301328E+00, 2.5115001475E+00, 1.5016920492E+00, 8.3524991669E-01],
	[2.2910000000E+04, 1.3324710868E+01, 5.1900433005E+00, 2.5132618540E+00, 1.5023712240E+00, 8.3532684712E-01],
	[2.2915000000E+04, 1.3329177216E+01, 5.1899564886E+00, 2.5150244102E+00, 1.5030504036E+00, 8.3540374504E-01],
	[2.2920000000E+04, 1.3333644086E+01, 5.1898696971E+00, 2.5167878163E+00, 1.5037295879E+00, 8.3548061044E-01],
	[2.2925000000E+04, 1.3338111478E+01, 5.1897829259E+00, 2.5185520726E+00, 1.5044087766E+00, 8.3555744334E-01],
	[2.2930000000E+04, 1.3342579392E+01, 5.1896961752E+00, 2.5203171793E+00, 1.5050879697E+00, 8.3563424374E-01],
	[2.2935000000E+04, 1.3347047828E+01, 5.1896094448E+00, 2.5220831365E+00, 1.5057671671E+00, 8.3571101166E-01],
	[2.2940000000E+04, 1.3351516787E+01, 5.1895227348E+00, 2.5238499446E+00, 1.5064463685E+00, 8.3578774709E-01],
	[2.2945000000E+04, 1.3355986267E+01, 5.1894360451E+00, 2.5256176037E+00, 1.5071255739E+00, 8.3586445005E-01],
	[2.2950000000E+04, 1.3360456268E+01, 5.1893493757E+00, 2.5273861141E+00, 1.5078047831E+00, 8.3594112055E-01],
	[2.2955000000E+04, 1.3364926792E+01, 5.1892627267E+00, 2.5291554760E+00, 1.5084839960E+00, 8.3601775859E-01],
	[2.2960000000E+04, 1.3369397837E+01, 5.1891760980E+00, 2.5309256897E+00, 1.5091632124E+00, 8.3609436418E-01],
	[2.2965000000E+04, 1.3373869404E+01, 5.1890894896E+00, 2.5326967552E+00, 1.5098424323E+00, 8.3617093732E-01],
	[2.2970000000E+04, 1.3378341493E+01, 5.1890029015E+00, 2.5344686729E+00, 1.5105216554E+00, 8.3624747804E-01],
	[2.2975000000E+04, 1.3382814103E+01, 5.1889163337E+00, 2.5362414431E+00, 1.5112008817E+00, 8.3632398633E-01],
	[2.2980000000E+04, 1.3387287235E+01, 5.1888297862E+00, 2.5380150658E+00, 1.5118801110E+00, 8.3640046220E-01],
	[2.2985000000E+04, 1.3391760888E+01, 5.1887432589E+00, 2.5397895413E+00, 1.5125593432E+00, 8.3647690566E-01],
	[2.2990000000E+04, 1.3396235063E+01, 5.1886567520E+00, 2.5415648699E+00, 1.5132385781E+00, 8.3655331672E-01],
	[2.2995000000E+04, 1.3400709759E+01, 5.1885702652E+00, 2.5433410518E+00, 1.5139178155E+00, 8.3662969538E-01],
	[2.3000000000E+04, 1.3405184977E+01, 5.1884837987E+00, 2.5451180872E+00, 1.5145970555E+00, 8.3670604166E-01],
	[2.3005000000E+04, 1.3409660715E+01, 5.1883973525E+00, 2.5468959764E+00, 1.5152762978E+00, 8.3678235556E-01],
	[2.3010000000E+04, 1.3414136975E+01, 5.1883109265E+00, 2.5486747194E+00, 1.5159555422E+00, 8.3685863709E-01],
	[2.3015000000E+04, 1.3418613756E+01, 5.1882245206E+00, 2.5504543167E+00, 1.5166347888E+00, 8.3693488625E-01],
	[2.3020000000E+04, 1.3423091058E+01, 5.1881381350E+00, 2.5522347684E+00, 1.5173140372E+00, 8.3701110306E-01],
	[2.3025000000E+04, 1.3427568881E+01, 5.1880517696E+00, 2.5540160746E+00, 1.5179932875E+00, 8.3708728753E-01],
	[2.3030000000E+04, 1.3432047225E+01, 5.1879654244E+00, 2.5557982358E+00, 1.5186725394E+00, 8.3716343966E-01],
	[2.3035000000E+04, 1.3436526090E+01, 5.1878790994E+00, 2.5575812520E+00, 1.5193517928E+00, 8.3723955945E-01],
	[2.3040000000E+04, 1.3441005476E+01, 5.1877927945E+00, 2.5593651235E+00, 1.5200310476E+00, 8.3731564692E-01],
	[2.3045000000E+04, 1.3445485383E+01, 5.1877065098E+00, 2.5611498505E+00, 1.5207103036E+00, 8.3739170207E-01],
	[2.3050000000E+04, 1.3449965811E+01, 5.1876202453E+00, 2.5629354332E+00, 1.5213895607E+00, 8.3746772490E-01],
	[2.3055000000E+04, 1.3454446759E+01, 5.1875340009E+00, 2.5647218719E+00, 1.5220688189E+00, 8.3754371543E-01],
	[2.3060000000E+04, 1.3458928228E+01, 5.1874477766E+00, 2.5665091668E+00, 1.5227480778E+00, 8.3761967365E-01],
	[2.3065000000E+04, 1.3463410218E+01, 5.1873615725E+00, 2.5682973182E+00, 1.5234273375E+00, 8.3769559958E-01],
	[2.3070000000E+04, 1.3467892728E+01, 5.1872753885E+00, 2.5700863261E+00, 1.5241065978E+00, 8.3777149323E-01],
	[2.3075000000E+04, 1.3472375759E+01, 5.1871892245E+00, 2.5718761909E+00, 1.5247858584E+00, 8.3784735459E-01],
	[2.3080000000E+04, 1.3476859310E+01, 5.1871030807E+00, 2.5736669128E+00, 1.5254651194E+00, 8.3792318367E-01],
	[2.3085000000E+04, 1.3481343382E+01, 5.1870169570E+00, 2.5754584920E+00, 1.5261443806E+00, 8.3799898049E-01],
	[2.3090000000E+04, 1.3485827974E+01, 5.1869308534E+00, 2.5772509288E+00, 1.5268236418E+00, 8.3807474504E-01],
	[2.3095000000E+04, 1.3490313086E+01, 5.1868447698E+00, 2.5790442233E+00, 1.5275029029E+00, 8.3815047734E-01],
	[2.3100000000E+04, 1.3494798719E+01, 5.1867587063E+00, 2.5808383757E+00, 1.5281821637E+00, 8.3822617739E-01],
	[2.3105000000E+04, 1.3499284871E+01, 5.1866726628E+00, 2.5826333864E+00, 1.5288614242E+00, 8.3830184519E-01],
	[2.3110000000E+04, 1.3503771544E+01, 5.1865866394E+00, 2.5844292555E+00, 1.5295406842E+00, 8.3837748076E-01],
	[2.3115000000E+04, 1.3508258737E+01, 5.1865006360E+00, 2.5862259832E+00, 1.5302199435E+00, 8.3845308409E-01],
	[2.3120000000E+04, 1.3512746451E+01, 5.1864146527E+00, 2.5880235698E+00, 1.5308992021E+00, 8.3852865521E-01],
	[2.3125000000E+04, 1.3517234684E+01, 5.1863286894E+00, 2.5898220156E+00, 1.5315784598E+00, 8.3860419410E-01],
	[2.3130000000E+04, 1.3521723437E+01, 5.1862427460E+00, 2.5916213206E+00, 1.5322577164E+00, 8.3867970079E-01],
	[2.3135000000E+04, 1.3526212710E+01, 5.1861568227E+00, 2.5934214852E+00, 1.5329369719E+00, 8.3875517527E-01],
	[2.3140000000E+04, 1.3530702503E+01, 5.1860709194E+00, 2.5952225095E+00, 1.5336162261E+00, 8.3883061756E-01],
	[2.3145000000E+04, 1.3535192815E+01, 5.1859850360E+00, 2.5970243939E+00, 1.5342954788E+00, 8.3890602765E-01],
	[2.3150000000E+04, 1.3539683648E+01, 5.1858991727E+00, 2.5988271384E+00, 1.5349747299E+00, 8.3898140556E-01],
	[2.3155000000E+04, 1.3544175000E+01, 5.1858133293E+00, 2.6006307434E+00, 1.5356539794E+00, 8.3905675129E-01],
	[2.3160000000E+04, 1.3548666871E+01, 5.1857275058E+00, 2.6024352091E+00, 1.5363332269E+00, 8.3913206486E-01],
	[2.3165000000E+04, 1.3553164358E+01, 5.1856427321E+00, 2.6042405356E+00, 1.5370126286E+00, 8.3920734625E-01],
	[2.3170000000E+04, 1.3557677886E+01, 5.1855611135E+00, 2.6060467233E+00, 1.5376925036E+00, 8.3928259549E-01],
	[2.3175000000E+04, 1.3562191942E+01, 5.1854795138E+00, 2.6078537723E+00, 1.5383723772E+00, 8.3935781258E-01],
	[2.3180000000E+04, 1.3566706527E+01, 5.1853979329E+00, 2.6096616828E+00, 1.5390522493E+00, 8.3943299753E-01],
	[2.3185000000E+04, 1.3571221640E+01, 5.1853163709E+00, 2.6114704551E+00, 1.5397321197E+00, 8.3950815034E-01],
	[2.3190000000E+04, 1.3575737282E+01, 5.1852348278E+00, 2.6132800895E+00, 1.5404119882E+00, 8.3958327102E-01],
	[2.3195000000E+04, 1.3580253453E+01, 5.1851533036E+00, 2.6150905861E+00, 1.5410918548E+00, 8.3965835957E-01],
	[2.3200000000E+04, 1.3584770152E+01, 5.1850717982E+00, 2.6169019451E+00, 1.5417717193E+00, 8.3973341601E-01],
	[2.3205000000E+04, 1.3589287380E+01, 5.1849903117E+00, 2.6187141668E+00, 1.5424515816E+00, 8.3980844034E-01],
	[2.3210000000E+04, 1.3593805136E+01, 5.1849088440E+00, 2.6205272514E+00, 1.5431314415E+00, 8.3988343256E-01],
	[2.3215000000E+04, 1.3598323420E+01, 5.1848273951E+00, 2.6223411991E+00, 1.5438112989E+00, 8.3995839269E-01],
	[2.3220000000E+04, 1.3602842232E+01, 5.1847459651E+00, 2.6241560102E+00, 1.5444911537E+00, 8.4003332073E-01],
	[2.3225000000E+04, 1.3607361573E+01, 5.1846645538E+00, 2.6259716849E+00, 1.5451710058E+00, 8.4010821668E-01],
	[2.3230000000E+04, 1.3611881442E+01, 5.1845831614E+00, 2.6277882233E+00, 1.5458508550E+00, 8.4018308056E-01],
	[2.3235000000E+04, 1.3616401839E+01, 5.1845017877E+00, 2.6296056258E+00, 1.5465307011E+00, 8.4025791238E-01],
	[2.3240000000E+04, 1.3620922764E+01, 5.1844204329E+00, 2.6314238925E+00, 1.5472105441E+00, 8.4033271213E-01],
	[2.3245000000E+04, 1.3625444217E+01, 5.1843390968E+00, 2.6332430237E+00, 1.5478903838E+00, 8.4040747982E-01],
	[2.3250000000E+04, 1.3629966198E+01, 5.1842577795E+00, 2.6350630196E+00, 1.5485702201E+00, 8.4048221547E-01],
	[2.3255000000E+04, 1.3634488707E+01, 5.1841764809E+00, 2.6368838804E+00, 1.5492500529E+00, 8.4055691907E-01],
	[2.3260000000E+04, 1.3639011743E+01, 5.1840952011E+00, 2.6387056064E+00, 1.5499298819E+00, 8.4063159064E-01],
	[2.3265000000E+04, 1.3643535308E+01, 5.1840139400E+00, 2.6405281977E+00, 1.5506097072E+00, 8.4070623019E-01],
	[2.3270000000E+04, 1.3648059400E+01, 5.1839326977E+00, 2.6423516546E+00, 1.5512895285E+00, 8.4078083771E-01],
	[2.3275000000E+04, 1.3652584020E+01, 5.1838514741E+00, 2.6441759773E+00, 1.5519693457E+00, 8.4085541323E-01],
	[2.3280000000E+04, 1.3657109167E+01, 5.1837702693E+00, 2.6460011661E+00, 1.5526491587E+00, 8.4092995673E-01],
	[2.3285000000E+04, 1.3661634843E+01, 5.1836890831E+00, 2.6478272211E+00, 1.5533289674E+00, 8.4100446824E-01],
	[2.3290000000E+04, 1.3666161045E+01, 5.1836079156E+00, 2.6496541426E+00, 1.5540087716E+00, 8.4107894775E-01],
	[2.3295000000E+04, 1.3670687775E+01, 5.1835267669E+00, 2.6514819309E+00, 1.5546885712E+00, 8.4115339528E-01],
	[2.3300000000E+04, 1.3675215033E+01, 5.1834456368E+00, 2.6533105860E+00, 1.5553683661E+00, 8.4122781083E-01],
	[2.3305000000E+04, 1.3679742818E+01, 5.1833645254E+00, 2.6551401083E+00, 1.5560481561E+00, 8.4130219442E-01],
	[2.3310000000E+04, 1.3684271130E+01, 5.1832834326E+00, 2.6569704980E+00, 1.5567279411E+00, 8.4137654604E-01],
	[2.3315000000E+04, 1.3688799970E+01, 5.1832023586E+00, 2.6588017553E+00, 1.5574077210E+00, 8.4145086570E-01],
	[2.3320000000E+04, 1.3693329336E+01, 5.1831213031E+00, 2.6606338805E+00, 1.5580874956E+00, 8.4152515341E-01],
	[2.3325000000E+04, 1.3697859230E+01, 5.1830402664E+00, 2.6624668737E+00, 1.5587672648E+00, 8.4159940918E-01],
	[2.3330000000E+04, 1.3702389651E+01, 5.1829592482E+00, 2.6643007351E+00, 1.5594470285E+00, 8.4167363302E-01],
	[2.3335000000E+04, 1.3706920600E+01, 5.1828782487E+00, 2.6661354651E+00, 1.5601267865E+00, 8.4174782493E-01],
	[2.3340000000E+04, 1.3711452075E+01, 5.1827972678E+00, 2.6679710638E+00, 1.5608065388E+00, 8.4182198492E-01],
	[2.3345000000E+04, 1.3715984077E+01, 5.1827163055E+00, 2.6698075315E+00, 1.5614862851E+00, 8.4189611299E-01],
	[2.3350000000E+04, 1.3720516606E+01, 5.1826353618E+00, 2.6716448683E+00, 1.5621660254E+00, 8.4197020916E-01],
	[2.3355000000E+04, 1.3725049662E+01, 5.1825544368E+00, 2.6734830746E+00, 1.5628457595E+00, 8.4204427343E-01],
	[2.3360000000E+04, 1.3729583244E+01, 5.1824735303E+00, 2.6753221504E+00, 1.5635254873E+00, 8.4211830581E-01],
	[2.3365000000E+04, 1.3734117354E+01, 5.1823926423E+00, 2.6771620961E+00, 1.5642052087E+00, 8.4219230631E-01],
	[2.3370000000E+04, 1.3738651990E+01, 5.1823117730E+00, 2.6790029119E+00, 1.5648849234E+00, 8.4226627493E-01],
	[2.3375000000E+04, 1.3743187153E+01, 5.1822309222E+00, 2.6808445980E+00, 1.5655646315E+00, 8.4234021168E-01],
	[2.3380000000E+04, 1.3747722842E+01, 5.1821500900E+00, 2.6826871546E+00, 1.5662443328E+00, 8.4241411656E-01],
	[2.3385000000E+04, 1.3752259058E+01, 5.1820692763E+00, 2.6845305819E+00, 1.5669240270E+00, 8.4248798960E-01],
	[2.3390000000E+04, 1.3756795801E+01, 5.1819884811E+00, 2.6863748803E+00, 1.5676037142E+00, 8.4256183078E-01],
	[2.3395000000E+04, 1.3761333069E+01, 5.1819077045E+00, 2.6882200498E+00, 1.5682833942E+00, 8.4263564013E-01],
	[2.3400000000E+04, 1.3765870865E+01, 5.1818269464E+00, 2.6900660907E+00, 1.5689630668E+00, 8.4270941764E-01],
	[2.3405000000E+04, 1.3770409186E+01, 5.1817462068E+00, 2.6919130033E+00, 1.5696427319E+00, 8.4278316333E-01],
	[2.3410000000E+04, 1.3774948034E+01, 5.1816654857E+00, 2.6937607877E+00, 1.5703223894E+00, 8.4285687720E-01],
	[2.3415000000E+04, 1.3779487409E+01, 5.1815847831E+00, 2.6956094443E+00, 1.5710020392E+00, 8.4293055926E-01],
	[2.3420000000E+04, 1.3784027309E+01, 5.1815040990E+00, 2.6974589731E+00, 1.5716816810E+00, 8.4300420952E-01],
	[2.3425000000E+04, 1.3788567736E+01, 5.1814234334E+00, 2.6993093745E+00, 1.5723613149E+00, 8.4307782798E-01],
	[2.3430000000E+04, 1.3793108688E+01, 5.1813427862E+00, 2.7011606487E+00, 1.5730409406E+00, 8.4315141465E-01],
	[2.3435000000E+04, 1.3797650167E+01, 5.1812621575E+00, 2.7030127958E+00, 1.5737205581E+00, 8.4322496955E-01],
	[2.3440000000E+04, 1.3802192171E+01, 5.1811815473E+00, 2.7048658162E+00, 1.5744001672E+00, 8.4329849267E-01],
	[2.3445000000E+04, 1.3806734702E+01, 5.1811009555E+00, 2.7067197100E+00, 1.5750797677E+00, 8.4337198402E-01],
	[2.3450000000E+04, 1.3811277758E+01, 5.1810203822E+00, 2.7085744774E+00, 1.5757593596E+00, 8.4344544362E-01],
	[2.3455000000E+04, 1.3815821341E+01, 5.1809398272E+00, 2.7104301188E+00, 1.5764389427E+00, 8.4351887147E-01],
	[2.3460000000E+04, 1.3820365449E+01, 5.1808592907E+00, 2.7122866342E+00, 1.5771185169E+00, 8.4359226757E-01],
	[2.3465000000E+04, 1.3824910083E+01, 5.1807787727E+00, 2.7141440240E+00, 1.5777980820E+00, 8.4366563194E-01],
	[2.3470000000E+04, 1.3829455242E+01, 5.1806982730E+00, 2.7160022884E+00, 1.5784776380E+00, 8.4373896458E-01],
	[2.3475000000E+04, 1.3834000927E+01, 5.1806177917E+00, 2.7178614275E+00, 1.5791571847E+00, 8.4381226550E-01],
	[2.3480000000E+04, 1.3838547138E+01, 5.1805373288E+00, 2.7197214417E+00, 1.5798367219E+00, 8.4388553471E-01],
	[2.3485000000E+04, 1.3843093874E+01, 5.1804568843E+00, 2.7215823311E+00, 1.5805162496E+00, 8.4395877222E-01],
	[2.3490000000E+04, 1.3847641136E+01, 5.1803764582E+00, 2.7234440959E+00, 1.5811957675E+00, 8.4403197802E-01],
	[2.3495000000E+04, 1.3852188923E+01, 5.1802960504E+00, 2.7253067364E+00, 1.5818752757E+00, 8.4410515214E-01],
	[2.3500000000E+04, 1.3856737235E+01, 5.1802156610E+00, 2.7271702528E+00, 1.5825547739E+00, 8.4417829458E-01],
	[2.3505000000E+04, 1.3861286073E+01, 5.1801352899E+00, 2.7290346454E+00, 1.5832342620E+00, 8.4425140534E-01],
	[2.3510000000E+04, 1.3865835436E+01, 5.1800549372E+00, 2.7308999143E+00, 1.5839137399E+00, 8.4432448444E-01],
	[2.3515000000E+04, 1.3870385325E+01, 5.1799746028E+00, 2.7327660598E+00, 1.5845932075E+00, 8.4439753188E-01],
	[2.3520000000E+04, 1.3874935738E+01, 5.1798942868E+00, 2.7346330821E+00, 1.5852726646E+00, 8.4447054766E-01],
	[2.3525000000E+04, 1.3879486677E+01, 5.1798139890E+00, 2.7365009814E+00, 1.5859521112E+00, 8.4454353181E-01],
	[2.3530000000E+04, 1.3884038140E+01, 5.1797337096E+00, 2.7383697580E+00, 1.5866315470E+00, 8.4461648431E-01],
	[2.3535000000E+04, 1.3888590129E+01, 5.1796534484E+00, 2.7402394121E+00, 1.5873109719E+00, 8.4468940519E-01],
	[2.3540000000E+04, 1.3893156555E+01, 5.1795759390E+00, 2.7421099439E+00, 1.5879908246E+00, 8.4476229445E-01],
	[2.3545000000E+04, 1.3897730484E+01, 5.1794998165E+00, 2.7439813535E+00, 1.5886708866E+00, 8.4483515210E-01],
	[2.3550000000E+04, 1.3902304947E+01, 5.1794237113E+00, 2.7458536414E+00, 1.5893509382E+00, 8.4490797815E-01],
	[2.3555000000E+04, 1.3906879944E+01, 5.1793476233E+00, 2.7477268076E+00, 1.5900309792E+00, 8.4498077259E-01],
	[2.3560000000E+04, 1.3911455475E+01, 5.1792715527E+00, 2.7496008524E+00, 1.5907110096E+00, 8.4505353545E-01],
	[2.3565000000E+04, 1.3916031541E+01, 5.1791954993E+00, 2.7514757761E+00, 1.5913910292E+00, 8.4512626673E-01],
	[2.3570000000E+04, 1.3920608140E+01, 5.1791194631E+00, 2.7533515788E+00, 1.5920710378E+00, 8.4519896644E-01],
	[2.3575000000E+04, 1.3925185273E+01, 5.1790434442E+00, 2.7552282608E+00, 1.5927510354E+00, 8.4527163458E-01],
	[2.3580000000E+04, 1.3929762940E+01, 5.1789674425E+00, 2.7571058222E+00, 1.5934310218E+00, 8.4534427116E-01],
	[2.3585000000E+04, 1.3934341141E+01, 5.1788914580E+00, 2.7589842634E+00, 1.5941109969E+00, 8.4541687619E-01],
	[2.3590000000E+04, 1.3938919875E+01, 5.1788154908E+00, 2.7608635846E+00, 1.5947909606E+00, 8.4548944969E-01],
	[2.3595000000E+04, 1.3943499143E+01, 5.1787395408E+00, 2.7627437859E+00, 1.5954709126E+00, 8.4556199164E-01],
	[2.3600000000E+04, 1.3948078945E+01, 5.1786636080E+00, 2.7646248676E+00, 1.5961508530E+00, 8.4563450208E-01],
	[2.3605000000E+04, 1.3952659280E+01, 5.1785876924E+00, 2.7665068299E+00, 1.5968307816E+00, 8.4570698099E-01],
	[2.3610000000E+04, 1.3957240149E+01, 5.1785117940E+00, 2.7683896731E+00, 1.5975106982E+00, 8.4577942840E-01],
	[2.3615000000E+04, 1.3961821551E+01, 5.1784359127E+00, 2.7702733974E+00, 1.5981906027E+00, 8.4585184430E-01],
	[2.3620000000E+04, 1.3966403487E+01, 5.1783600487E+00, 2.7721580030E+00, 1.5988704951E+00, 8.4592422872E-01],
	[2.3625000000E+04, 1.3970985956E+01, 5.1782842018E+00, 2.7740434900E+00, 1.5995503750E+00, 8.4599658164E-01],
	[2.3630000000E+04, 1.3975568959E+01, 5.1782083720E+00, 2.7759298589E+00, 1.6002302426E+00, 8.4606890309E-01],
	[2.3635000000E+04, 1.3980152495E+01, 5.1781325595E+00, 2.7778171097E+00, 1.6009100975E+00, 8.4614119307E-01],
	[2.3640000000E+04, 1.3984736564E+01, 5.1780567640E+00, 2.7797052426E+00, 1.6015899397E+00, 8.4621345158E-01],
	[2.3645000000E+04, 1.3989321166E+01, 5.1779809857E+00, 2.7815942581E+00, 1.6022697691E+00, 8.4628567865E-01],
	[2.3650000000E+04, 1.3993906301E+01, 5.1779052246E+00, 2.7834841561E+00, 1.6029495855E+00, 8.4635787427E-01],
	[2.3655000000E+04, 1.3998491969E+01, 5.1778294805E+00, 2.7853749370E+00, 1.6036293888E+00, 8.4643003845E-01],
	[2.3660000000E+04, 1.4003078171E+01, 5.1777537536E+00, 2.7872666011E+00, 1.6043091789E+00, 8.4650217120E-01],
	[2.3665000000E+04, 1.4007664905E+01, 5.1776780438E+00, 2.7891591484E+00, 1.6049889557E+00, 8.4657427253E-01],
	[2.3670000000E+04, 1.4012252172E+01, 5.1776023511E+00, 2.7910525793E+00, 1.6056687189E+00, 8.4664634244E-01],
	[2.3675000000E+04, 1.4016839973E+01, 5.1775266755E+00, 2.7929468940E+00, 1.6063484686E+00, 8.4671838096E-01],
	[2.3680000000E+04, 1.4021428306E+01, 5.1774510170E+00, 2.7948420926E+00, 1.6070282045E+00, 8.4679038807E-01],
	[2.3685000000E+04, 1.4026017171E+01, 5.1773753755E+00, 2.7967381755E+00, 1.6077079266E+00, 8.4686236380E-01],
	[2.3690000000E+04, 1.4030606570E+01, 5.1772997511E+00, 2.7986351428E+00, 1.6083876347E+00, 8.4693430814E-01],
	[2.3695000000E+04, 1.4035196501E+01, 5.1772241438E+00, 2.8005329948E+00, 1.6090673287E+00, 8.4700622112E-01],
	[2.3700000000E+04, 1.4039786965E+01, 5.1771485535E+00, 2.8024317317E+00, 1.6097470084E+00, 8.4707810273E-01],
	[2.3705000000E+04, 1.4044377961E+01, 5.1770729803E+00, 2.8043313536E+00, 1.6104266738E+00, 8.4714995298E-01],
	[2.3710000000E+04, 1.4048969490E+01, 5.1769974242E+00, 2.8062318610E+00, 1.6111063247E+00, 8.4722177189E-01],
	[2.3715000000E+04, 1.4053561551E+01, 5.1769218850E+00, 2.8081332539E+00, 1.6117859610E+00, 8.4729355945E-01],
	[2.3720000000E+04, 1.4058154145E+01, 5.1768463629E+00, 2.8100355326E+00, 1.6124655826E+00, 8.4736531569E-01],
	[2.3725000000E+04, 1.4062747271E+01, 5.1767708578E+00, 2.8119386973E+00, 1.6131451892E+00, 8.4743704060E-01],
	[2.3730000000E+04, 1.4067340930E+01, 5.1766953697E+00, 2.8138427483E+00, 1.6138247809E+00, 8.4750873420E-01],
	[2.3735000000E+04, 1.4071935120E+01, 5.1766198987E+00, 2.8157476857E+00, 1.6145043575E+00, 8.4758039649E-01],
	[2.3740000000E+04, 1.4076529843E+01, 5.1765444446E+00, 2.8176535098E+00, 1.6151839188E+00, 8.4765202748E-01],
	[2.3745000000E+04, 1.4081125098E+01, 5.1764690075E+00, 2.8195602208E+00, 1.6158634648E+00, 8.4772362719E-01],
	[2.3750000000E+04, 1.4085720885E+01, 5.1763935874E+00, 2.8214678190E+00, 1.6165429952E+00, 8.4779519561E-01],
	[2.3755000000E+04, 1.4090317205E+01, 5.1763181843E+00, 2.8233763046E+00, 1.6172225101E+00, 8.4786673276E-01],
	[2.3760000000E+04, 1.4094914056E+01, 5.1762427981E+00, 2.8252856777E+00, 1.6179020092E+00, 8.4793823864E-01],
	[2.3765000000E+04, 1.4099511439E+01, 5.1761674289E+00, 2.8271959387E+00, 1.6185814924E+00, 8.4800971327E-01],
	[2.3770000000E+04, 1.4104109354E+01, 5.1760920767E+00, 2.8291070877E+00, 1.6192609596E+00, 8.4808115665E-01],
	[2.3775000000E+04, 1.4108707801E+01, 5.1760167413E+00, 2.8310191249E+00, 1.6199404107E+00, 8.4815256879E-01],
	[2.3780000000E+04, 1.4113306780E+01, 5.1759414230E+00, 2.8329320507E+00, 1.6206198456E+00, 8.4822394970E-01],
	[2.3785000000E+04, 1.4117906291E+01, 5.1758661215E+00, 2.8348458652E+00, 1.6212992640E+00, 8.4829529938E-01],
	[2.3790000000E+04, 1.4122506333E+01, 5.1757908370E+00, 2.8367605686E+00, 1.6219786660E+00, 8.4836661785E-01],
	[2.3795000000E+04, 1.4127106907E+01, 5.1757155694E+00, 2.8386761612E+00, 1.6226580514E+00, 8.4843790511E-01],
	[2.3800000000E+04, 1.4131708012E+01, 5.1756403187E+00, 2.8405926431E+00, 1.6233374200E+00, 8.4850916118E-01],
	[2.3805000000E+04, 1.4136309650E+01, 5.1755650849E+00, 2.8425100147E+00, 1.6240167717E+00, 8.4858038606E-01],
	[2.3810000000E+04, 1.4140911818E+01, 5.1754898681E+00, 2.8444282762E+00, 1.6246961065E+00, 8.4865157975E-01],
	[2.3815000000E+04, 1.4145514518E+01, 5.1754146680E+00, 2.8463474277E+00, 1.6253754241E+00, 8.4872274228E-01],
	[2.3820000000E+04, 1.4150117750E+01, 5.1753394849E+00, 2.8482674695E+00, 1.6260547245E+00, 8.4879387364E-01],
	[2.3825000000E+04, 1.4154721513E+01, 5.1752643187E+00, 2.8501884018E+00, 1.6267340075E+00, 8.4886497384E-01],
	[2.3830000000E+04, 1.4159325807E+01, 5.1751891693E+00, 2.8521102248E+00, 1.6274132730E+00, 8.4893604290E-01],
	[2.3835000000E+04, 1.4163930632E+01, 5.1751140367E+00, 2.8540329389E+00, 1.6280925208E+00, 8.4900708082E-01],
	[2.3840000000E+04, 1.4168535989E+01, 5.1750389210E+00, 2.8559565441E+00, 1.6287717510E+00, 8.4907808760E-01],
	[2.3845000000E+04, 1.4173141877E+01, 5.1749638222E+00, 2.8578810407E+00, 1.6294509633E+00, 8.4914906327E-01],
	[2.3850000000E+04, 1.4177748296E+01, 5.1748887402E+00, 2.8598064290E+00, 1.6301301575E+00, 8.4922000783E-01],
	[2.3855000000E+04, 1.4182355245E+01, 5.1748136750E+00, 2.8617327091E+00, 1.6308093337E+00, 8.4929092128E-01],
	[2.3860000000E+04, 1.4186962726E+01, 5.1747386266E+00, 2.8636598814E+00, 1.6314884916E+00, 8.4936180363E-01],
	[2.3865000000E+04, 1.4191570738E+01, 5.1746635951E+00, 2.8655879459E+00, 1.6321676311E+00, 8.4943265490E-01],
	[2.3870000000E+04, 1.4196179281E+01, 5.1745885804E+00, 2.8675169030E+00, 1.6328467522E+00, 8.4950347509E-01],
	[2.3875000000E+04, 1.4200788355E+01, 5.1745135824E+00, 2.8694467529E+00, 1.6335258546E+00, 8.4957426420E-01],
	[2.3880000000E+04, 1.4205397959E+01, 5.1744386013E+00, 2.8713774958E+00, 1.6342049383E+00, 8.4964502226E-01],
	[2.3885000000E+04, 1.4210008095E+01, 5.1743636369E+00, 2.8733091318E+00, 1.6348840032E+00, 8.4971574927E-01],
	[2.3890000000E+04, 1.4214618761E+01, 5.1742886893E+00, 2.8752416614E+00, 1.6355630490E+00, 8.4978644523E-01],
	[2.3895000000E+04, 1.4219229957E+01, 5.1742137585E+00, 2.8771750846E+00, 1.6362420758E+00, 8.4985711015E-01],
	[2.3900000000E+04, 1.4223841684E+01, 5.1741388444E+00, 2.8791094017E+00, 1.6369210833E+00, 8.4992774405E-01],
	[2.3905000000E+04, 1.4228453942E+01, 5.1740639471E+00, 2.8810446129E+00, 1.6376000714E+00, 8.4999834693E-01],
	[2.3910000000E+04, 1.4233066730E+01, 5.1739890666E+00, 2.8829807184E+00, 1.6382790401E+00, 8.5006891880E-01],
	[2.3915000000E+04, 1.4237680049E+01, 5.1739142027E+00, 2.8849177186E+00, 1.6389579892E+00, 8.5013945967E-01],
	[2.3920000000E+04, 1.4242312614E+01, 5.1738429305E+00, 2.8868556135E+00, 1.6396375256E+00, 8.5020996955E-01],
	[2.3925000000E+04, 1.4246948162E+01, 5.1737721407E+00, 2.8887944034E+00, 1.6403171222E+00, 8.5028044844E-01],
	[2.3930000000E+04, 1.4251584249E+01, 5.1737013667E+00, 2.8907340886E+00, 1.6409966996E+00, 8.5035089636E-01],
	[2.3935000000E+04, 1.4256220875E+01, 5.1736306084E+00, 2.8926746693E+00, 1.6416762578E+00, 8.5042131331E-01],
	[2.3940000000E+04, 1.4260858042E+01, 5.1735598659E+00, 2.8946161456E+00, 1.6423557966E+00, 8.5049169931E-01],
	[2.3945000000E+04, 1.4265495747E+01, 5.1734891391E+00, 2.8965585179E+00, 1.6430353158E+00, 8.5056205436E-01],
	[2.3950000000E+04, 1.4270133992E+01, 5.1734184280E+00, 2.8985017863E+00, 1.6437148154E+00, 8.5063237847E-01],
	[2.3955000000E+04, 1.4274772776E+01, 5.1733477327E+00, 2.9004459511E+00, 1.6443942953E+00, 8.5070267164E-01],
	[2.3960000000E+04, 1.4279412100E+01, 5.1732770531E+00, 2.9023910125E+00, 1.6450737553E+00, 8.5077293390E-01],
	[2.3965000000E+04, 1.4284051963E+01, 5.1732063892E+00, 2.9043369708E+00, 1.6457531952E+00, 8.5084316524E-01],
	[2.3970000000E+04, 1.4288692365E+01, 5.1731357410E+00, 2.9062838260E+00, 1.6464326150E+00, 8.5091336568E-01],
	[2.3975000000E+04, 1.4293333307E+01, 5.1730651085E+00, 2.9082315786E+00, 1.6471120146E+00, 8.5098353522E-01],
	[2.3980000000E+04, 1.4297974787E+01, 5.1729944917E+00, 2.9101802286E+00, 1.6477913938E+00, 8.5105367387E-01],
	[2.3985000000E+04, 1.4302616807E+01, 5.1729238906E+00, 2.9121297764E+00, 1.6484707525E+00, 8.5112378165E-01],
	[2.3990000000E+04, 1.4307259365E+01, 5.1728533052E+00, 2.9140802221E+00, 1.6491500905E+00, 8.5119385856E-01],
	[2.3995000000E+04, 1.4311902463E+01, 5.1727827354E+00, 2.9160315660E+00, 1.6498294078E+00, 8.5126390461E-01],
	[2.4000000000E+04, 1.4316546100E+01, 5.1727121813E+00, 2.9179838083E+00, 1.6505087043E+00, 8.5133391980E-01],
	[2.4005000000E+04, 1.4321190275E+01, 5.1726416429E+00, 2.9199369492E+00, 1.6511879797E+00, 8.5140390415E-01],
	[2.4010000000E+04, 1.4325834989E+01, 5.1725711201E+00, 2.9218909890E+00, 1.6518672341E+00, 8.5147385767E-01],
	[2.4015000000E+04, 1.4330480242E+01, 5.1725006130E+00, 2.9238459279E+00, 1.6525464672E+00, 8.5154378037E-01],
	[2.4020000000E+04, 1.4335126034E+01, 5.1724301215E+00, 2.9258017660E+00, 1.6532256790E+00, 8.5161367225E-01],
	[2.4025000000E+04, 1.4339772364E+01, 5.1723596456E+00, 2.9277585037E+00, 1.6539048693E+00, 8.5168353332E-01],
	[2.4030000000E+04, 1.4344419234E+01, 5.1722891854E+00, 2.9297161411E+00, 1.6545840380E+00, 8.5175336360E-01],
	[2.4035000000E+04, 1.4349066641E+01, 5.1722187408E+00, 2.9316746786E+00, 1.6552631850E+00, 8.5182316308E-01],
	[2.4040000000E+04, 1.4353714587E+01, 5.1721483118E+00, 2.9336341162E+00, 1.6559423101E+00, 8.5189293179E-01],
	[2.4045000000E+04, 1.4358363072E+01, 5.1720778984E+00, 2.9355944542E+00, 1.6566214133E+00, 8.5196266972E-01],
	[2.4050000000E+04, 1.4363012095E+01, 5.1720075006E+00, 2.9375556929E+00, 1.6573004944E+00, 8.5203237689E-01],
	[2.4055000000E+04, 1.4367661657E+01, 5.1719371184E+00, 2.9395178325E+00, 1.6579795532E+00, 8.5210205331E-01],
	[2.4060000000E+04, 1.4372311756E+01, 5.1718667517E+00, 2.9414808732E+00, 1.6586585898E+00, 8.5217169898E-01],
	[2.4065000000E+04, 1.4376962394E+01, 5.1717964007E+00, 2.9434448152E+00, 1.6593376039E+00, 8.5224131392E-01],
	[2.4070000000E+04, 1.4381613571E+01, 5.1717260652E+00, 2.9454096588E+00, 1.6600165954E+00, 8.5231089814E-01],
	[2.4075000000E+04, 1.4386265285E+01, 5.1716557453E+00, 2.9473754042E+00, 1.6606955643E+00, 8.5238045163E-01],
	[2.4080000000E+04, 1.4390917538E+01, 5.1715854410E+00, 2.9493420516E+00, 1.6613745103E+00, 8.5244997442E-01],
	[2.4085000000E+04, 1.4395570329E+01, 5.1715151522E+00, 2.9513096012E+00, 1.6620534334E+00, 8.5251946651E-01],
	[2.4090000000E+04, 1.4400223657E+01, 5.1714448789E+00, 2.9532780532E+00, 1.6627323335E+00, 8.5258892791E-01],
	[2.4095000000E+04, 1.4404877524E+01, 5.1713746212E+00, 2.9552474080E+00, 1.6634112104E+00, 8.5265835863E-01],
	[2.4100000000E+04, 1.4409531929E+01, 5.1713043790E+00, 2.9572176657E+00, 1.6640900640E+00, 8.5272775867E-01],
	[2.4105000000E+04, 1.4414186871E+01, 5.1712341524E+00, 2.9591888265E+00, 1.6647688942E+00, 8.5279712805E-01],
	[2.4110000000E+04, 1.4418842352E+01, 5.1711639412E+00, 2.9611608906E+00, 1.6654477008E+00, 8.5286646678E-01],
	[2.4115000000E+04, 1.4423498370E+01, 5.1710937456E+00, 2.9631338584E+00, 1.6661264838E+00, 8.5293577487E-01],
	[2.4120000000E+04, 1.4428154926E+01, 5.1710235655E+00, 2.9651077299E+00, 1.6668052430E+00, 8.5300505232E-01],
	[2.4125000000E+04, 1.4432812019E+01, 5.1709534009E+00, 2.9670825055E+00, 1.6674839783E+00, 8.5307429914E-01],
	[2.4130000000E+04, 1.4437469651E+01, 5.1708832517E+00, 2.9690581854E+00, 1.6681626896E+00, 8.5314351535E-01],
	[2.4135000000E+04, 1.4442127820E+01, 5.1708131181E+00, 2.9710347698E+00, 1.6688413767E+00, 8.5321270094E-01],
	[2.4140000000E+04, 1.4446786526E+01, 5.1707429999E+00, 2.9730122588E+00, 1.6695200396E+00, 8.5328185594E-01],
	[2.4145000000E+04, 1.4451445770E+01, 5.1706728972E+00, 2.9749906528E+00, 1.6701986782E+00, 8.5335098035E-01],
	[2.4150000000E+04, 1.4456105551E+01, 5.1706028100E+00, 2.9769699520E+00, 1.6708772922E+00, 8.5342007418E-01],
	[2.4155000000E+04, 1.4460765870E+01, 5.1705327382E+00, 2.9789501566E+00, 1.6715558816E+00, 8.5348913743E-01],
	[2.4160000000E+04, 1.4465426726E+01, 5.1704626819E+00, 2.9809312668E+00, 1.6722344463E+00, 8.5355817007E-01],
	[2.4165000000E+04, 1.4470088119E+01, 5.1703926411E+00, 2.9829132828E+00, 1.6729129861E+00, 8.5362717209E-01],
	[2.4170000000E+04, 1.4474750050E+01, 5.1703226156E+00, 2.9848962049E+00, 1.6735915009E+00, 8.5369614352E-01],
	[2.4175000000E+04, 1.4479412518E+01, 5.1702526056E+00, 2.9868800333E+00, 1.6742699906E+00, 8.5376508436E-01],
	[2.4180000000E+04, 1.4484075523E+01, 5.1701826111E+00, 2.9888647683E+00, 1.6749484552E+00, 8.5383399461E-01],
	[2.4185000000E+04, 1.4488739065E+01, 5.1701126319E+00, 2.9908504099E+00, 1.6756268943E+00, 8.5390287429E-01],
	[2.4190000000E+04, 1.4493403144E+01, 5.1700426682E+00, 2.9928369586E+00, 1.6763053081E+00, 8.5397172340E-01],
	[2.4195000000E+04, 1.4498067760E+01, 5.1699727198E+00, 2.9948244144E+00, 1.6769836962E+00, 8.5404054196E-01],
	[2.4200000000E+04, 1.4502732913E+01, 5.1699027869E+00, 2.9968127777E+00, 1.6776620587E+00, 8.5410932997E-01],
	[2.4205000000E+04, 1.4507398603E+01, 5.1698328694E+00, 2.9988020486E+00, 1.6783403953E+00, 8.5417808744E-01],
	[2.4210000000E+04, 1.4512064830E+01, 5.1697629672E+00, 3.0007922274E+00, 1.6790187060E+00, 8.5424681437E-01],
	[2.4215000000E+04, 1.4516731593E+01, 5.1696930804E+00, 3.0027833143E+00, 1.6796969907E+00, 8.5431551078E-01],
	[2.4220000000E+04, 1.4521398894E+01, 5.1696232090E+00, 3.0047753095E+00, 1.6803752492E+00, 8.5438417668E-01],
	[2.4225000000E+04, 1.4526066731E+01, 5.1695533530E+00, 3.0067682133E+00, 1.6810534814E+00, 8.5445281208E-01],
	[2.4230000000E+04, 1.4530735104E+01, 5.1694835123E+00, 3.0087620258E+00, 1.6817316872E+00, 8.5452141698E-01],
	[2.4235000000E+04, 1.4535404015E+01, 5.1694136870E+00, 3.0107567474E+00, 1.6824098665E+00, 8.5458999139E-01],
	[2.4240000000E+04, 1.4540073462E+01, 5.1693438770E+00, 3.0127523782E+00, 1.6830880191E+00, 8.5465853532E-01],
	[2.4245000000E+04, 1.4544743445E+01, 5.1692740824E+00, 3.0147489184E+00, 1.6837661449E+00, 8.5472704878E-01],
	[2.4250000000E+04, 1.4549413965E+01, 5.1692043031E+00, 3.0167463683E+00, 1.6844442439E+00, 8.5479553178E-01],
	[2.4255000000E+04, 1.4554085021E+01, 5.1691345391E+00, 3.0187447282E+00, 1.6851223159E+00, 8.5486398432E-01],
	[2.4260000000E+04, 1.4558756614E+01, 5.1690647905E+00, 3.0207439982E+00, 1.6858003607E+00, 8.5493240643E-01],
	[2.4265000000E+04, 1.4563428743E+01, 5.1689950572E+00, 3.0227441785E+00, 1.6864783783E+00, 8.5500079809E-01],
	[2.4270000000E+04, 1.4568101408E+01, 5.1689253391E+00, 3.0247452694E+00, 1.6871563686E+00, 8.5506915934E-01],
	[2.4275000000E+04, 1.4572774609E+01, 5.1688556364E+00, 3.0267472711E+00, 1.6878343314E+00, 8.5513749016E-01],
	[2.4280000000E+04, 1.4577448347E+01, 5.1687859490E+00, 3.0287501839E+00, 1.6885122666E+00, 8.5520579057E-01],
	[2.4285000000E+04, 1.4582122621E+01, 5.1687162768E+00, 3.0307540079E+00, 1.6891901740E+00, 8.5527406059E-01],
	[2.4290000000E+04, 1.4586797430E+01, 5.1686466200E+00, 3.0327587434E+00, 1.6898680537E+00, 8.5534230021E-01],
	[2.4295000000E+04, 1.4591472776E+01, 5.1685769784E+00, 3.0347643907E+00, 1.6905459054E+00, 8.5541050946E-01],
	[2.4300000000E+04, 1.4596148658E+01, 5.1685073521E+00, 3.0367709499E+00, 1.6912237290E+00, 8.5547868832E-01],
	[2.4305000000E+04, 1.4600844005E+01, 5.1684412561E+00, 3.0387784212E+00, 1.6919021553E+00, 8.5554683683E-01],
	[2.4310000000E+04, 1.4605542407E+01, 5.1683756407E+00, 3.0407868049E+00, 1.6925806377E+00, 8.5561495498E-01],
	[2.4315000000E+04, 1.4610241355E+01, 5.1683100397E+00, 3.0427961013E+00, 1.6932590926E+00, 8.5568304278E-01],
	[2.4320000000E+04, 1.4614940848E+01, 5.1682444530E+00, 3.0448063105E+00, 1.6939375197E+00, 8.5575110024E-01],
	[2.4325000000E+04, 1.4619640885E+01, 5.1681788805E+00, 3.0468174328E+00, 1.6946159190E+00, 8.5581912738E-01],
	[2.4330000000E+04, 1.4624341468E+01, 5.1681133224E+00, 3.0488294683E+00, 1.6952942904E+00, 8.5588712419E-01],
	[2.4335000000E+04, 1.4629042596E+01, 5.1680477786E+00, 3.0508424174E+00, 1.6959726336E+00, 8.5595509070E-01],
	[2.4340000000E+04, 1.4633744269E+01, 5.1679822491E+00, 3.0528562803E+00, 1.6966509488E+00, 8.5602302690E-01],
	[2.4345000000E+04, 1.4638446487E+01, 5.1679167339E+00, 3.0548710571E+00, 1.6973292356E+00, 8.5609093281E-01],
	[2.4350000000E+04, 1.4643149249E+01, 5.1678512330E+00, 3.0568867481E+00, 1.6980074940E+00, 8.5615880843E-01],
	[2.4355000000E+04, 1.4647852556E+01, 5.1677857464E+00, 3.0589033535E+00, 1.6986857238E+00, 8.5622665378E-01],
	[2.4360000000E+04, 1.4652556408E+01, 5.1677202740E+00, 3.0609208736E+00, 1.6993639250E+00, 8.5629446886E-01],
	[2.4365000000E+04, 1.4657260805E+01, 5.1676548159E+00, 3.0629393086E+00, 1.7000420975E+00, 8.5636225369E-01],
	[2.4370000000E+04, 1.4661965747E+01, 5.1675893720E+00, 3.0649586587E+00, 1.7007202411E+00, 8.5643000827E-01],
	[2.4375000000E+04, 1.4666671232E+01, 5.1675239424E+00, 3.0669789241E+00, 1.7013983556E+00, 8.5649773261E-01],
	[2.4380000000E+04, 1.4671377263E+01, 5.1674585271E+00, 3.0690001051E+00, 1.7020764411E+00, 8.5656542672E-01],
	[2.4385000000E+04, 1.4676083838E+01, 5.1673931260E+00, 3.0710222019E+00, 1.7027544973E+00, 8.5663309060E-01],
	[2.4390000000E+04, 1.4680790957E+01, 5.1673277391E+00, 3.0730452146E+00, 1.7034325242E+00, 8.5670072428E-01],
	[2.4395000000E+04, 1.4685498621E+01, 5.1672623665E+00, 3.0750691436E+00, 1.7041105216E+00, 8.5676832775E-01],
	[2.4400000000E+04, 1.4690206829E+01, 5.1671970081E+00, 3.0770939891E+00, 1.7047884894E+00, 8.5683590103E-01],
	[2.4405000000E+04, 1.4694915582E+01, 5.1671316639E+00, 3.0791197512E+00, 1.7054664275E+00, 8.5690344412E-01],
	[2.4410000000E+04, 1.4699624879E+01, 5.1670663339E+00, 3.0811464303E+00, 1.7061443358E+00, 8.5697095704E-01],
	[2.4415000000E+04, 1.4704334720E+01, 5.1670010181E+00, 3.0831740265E+00, 1.7068222142E+00, 8.5703843979E-01],
	[2.4420000000E+04, 1.4709045105E+01, 5.1669357165E+00, 3.0852025401E+00, 1.7075000625E+00, 8.5710589239E-01],
	[2.4425000000E+04, 1.4713756034E+01, 5.1668704292E+00, 3.0872319713E+00, 1.7081778807E+00, 8.5717331483E-01],
	[2.4430000000E+04, 1.4718467507E+01, 5.1668051560E+00, 3.0892623202E+00, 1.7088556686E+00, 8.5724070714E-01],
	[2.4435000000E+04, 1.4723179525E+01, 5.1667398970E+00, 3.0912935873E+00, 1.7095334260E+00, 8.5730806931E-01],
	[2.4440000000E+04, 1.4727892086E+01, 5.1666746521E+00, 3.0933257726E+00, 1.7102111530E+00, 8.5737540137E-01],
	[2.4445000000E+04, 1.4732605191E+01, 5.1666094215E+00, 3.0953588764E+00, 1.7108888494E+00, 8.5744270331E-01],
	[2.4450000000E+04, 1.4737318840E+01, 5.1665442050E+00, 3.0973928989E+00, 1.7115665150E+00, 8.5750997515E-01],
	[2.4455000000E+04, 1.4742033033E+01, 5.1664790026E+00, 3.0994278404E+00, 1.7122441497E+00, 8.5757721690E-01],
	[2.4460000000E+04, 1.4746747769E+01, 5.1664138144E+00, 3.1014637010E+00, 1.7129217535E+00, 8.5764442856E-01],
	[2.4465000000E+04, 1.4751463050E+01, 5.1663486404E+00, 3.1035004811E+00, 1.7135993262E+00, 8.5771161015E-01],
	[2.4470000000E+04, 1.4756178874E+01, 5.1662834805E+00, 3.1055381808E+00, 1.7142768677E+00, 8.5777876167E-01],
	[2.4475000000E+04, 1.4760895241E+01, 5.1662183347E+00, 3.1075768003E+00, 1.7149543778E+00, 8.5784588313E-01],
	[2.4480000000E+04, 1.4765612153E+01, 5.1661532031E+00, 3.1096163399E+00, 1.7156318566E+00, 8.5791297455E-01],
	[2.4485000000E+04, 1.4770329607E+01, 5.1660880855E+00, 3.1116567998E+00, 1.7163093037E+00, 8.5798003593E-01],
	[2.4490000000E+04, 1.4775047605E+01, 5.1660229821E+00, 3.1136981803E+00, 1.7169867192E+00, 8.5804706728E-01],
	[2.4495000000E+04, 1.4779766147E+01, 5.1659578929E+00, 3.1157404815E+00, 1.7176641030E+00, 8.5811406861E-01],
	[2.4500000000E+04, 1.4784485232E+01, 5.1658928177E+00, 3.1177837037E+00, 1.7183414548E+00, 8.5818103992E-01],
	[2.4505000000E+04, 1.4789204860E+01, 5.1658277566E+00, 3.1198278471E+00, 1.7190187746E+00, 8.5824798124E-01],
	[2.4510000000E+04, 1.4793925032E+01, 5.1657627096E+00, 3.1218729120E+00, 1.7196960623E+00, 8.5831489257E-01],
	[2.4515000000E+04, 1.4798645747E+01, 5.1656976767E+00, 3.1239188985E+00, 1.7203733178E+00, 8.5838177391E-01],
	[2.4520000000E+04, 1.4803367005E+01, 5.1656326579E+00, 3.1259658069E+00, 1.7210505409E+00, 8.5844862528E-01],
	[2.4525000000E+04, 1.4808088806E+01, 5.1655676531E+00, 3.1280136375E+00, 1.7217277315E+00, 8.5851544668E-01],
	[2.4530000000E+04, 1.4812811150E+01, 5.1655026624E+00, 3.1300623903E+00, 1.7224048896E+00, 8.5858223813E-01],
	[2.4535000000E+04, 1.4817534038E+01, 5.1654376858E+00, 3.1321120658E+00, 1.7230820150E+00, 8.5864899964E-01],
	[2.4540000000E+04, 1.4822257468E+01, 5.1653727232E+00, 3.1341626640E+00, 1.7237591075E+00, 8.5871573120E-01],
	[2.4545000000E+04, 1.4826981441E+01, 5.1653077747E+00, 3.1362141853E+00, 1.7244361671E+00, 8.5878243285E-01],
	[2.4550000000E+04, 1.4831705957E+01, 5.1652428403E+00, 3.1382666298E+00, 1.7251131937E+00, 8.5884910457E-01],
	[2.4555000000E+04, 1.4836431016E+01, 5.1651779198E+00, 3.1403199978E+00, 1.7257901871E+00, 8.5891574638E-01],
	[2.4560000000E+04, 1.4841156618E+01, 5.1651130134E+00, 3.1423742895E+00, 1.7264671473E+00, 8.5898235830E-01],
	[2.4565000000E+04, 1.4845882763E+01, 5.1650481211E+00, 3.1444295051E+00, 1.7271440740E+00, 8.5904894033E-01],
	[2.4570000000E+04, 1.4850609450E+01, 5.1649832427E+00, 3.1464856449E+00, 1.7278209673E+00, 8.5911549248E-01],
	[2.4575000000E+04, 1.4855336680E+01, 5.1649183784E+00, 3.1485427091E+00, 1.7284978270E+00, 8.5918201475E-01],
	[2.4580000000E+04, 1.4860064453E+01, 5.1648535281E+00, 3.1506006979E+00, 1.7291746529E+00, 8.5924850717E-01],
	[2.4585000000E+04, 1.4864792768E+01, 5.1647886918E+00, 3.1526596115E+00, 1.7298514450E+00, 8.5931496973E-01],
	[2.4590000000E+04, 1.4869521625E+01, 5.1647238695E+00, 3.1547194501E+00, 1.7305282031E+00, 8.5938140245E-01],
	[2.4595000000E+04, 1.4874251025E+01, 5.1646590612E+00, 3.1567802141E+00, 1.7312049272E+00, 8.5944780534E-01],
	[2.4600000000E+04, 1.4878980968E+01, 5.1645942668E+00, 3.1588419036E+00, 1.7318816171E+00, 8.5951417840E-01],
	[2.4605000000E+04, 1.4883711453E+01, 5.1645294865E+00, 3.1609045188E+00, 1.7325582727E+00, 8.5958052165E-01],
	[2.4610000000E+04, 1.4888442480E+01, 5.1644647201E+00, 3.1629680599E+00, 1.7332348939E+00, 8.5964683510E-01],
	[2.4615000000E+04, 1.4893174049E+01, 5.1643999677E+00, 3.1650325273E+00, 1.7339114806E+00, 8.5971311875E-01],
	[2.4620000000E+04, 1.4897906161E+01, 5.1643352292E+00, 3.1670979211E+00, 1.7345880327E+00, 8.5977937261E-01],
	[2.4625000000E+04, 1.4902638815E+01, 5.1642705048E+00, 3.1691642415E+00, 1.7352645500E+00, 8.5984559670E-01],
	[2.4630000000E+04, 1.4907372011E+01, 5.1642057942E+00, 3.1712314889E+00, 1.7359410324E+00, 8.5991179102E-01],
	[2.4635000000E+04, 1.4912105749E+01, 5.1641410976E+00, 3.1732996633E+00, 1.7366174799E+00, 8.5997795559E-01],
	[2.4640000000E+04, 1.4916840029E+01, 5.1640764150E+00, 3.1753687650E+00, 1.7372938923E+00, 8.6004409040E-01],
	[2.4645000000E+04, 1.4921574851E+01, 5.1640117463E+00, 3.1774387943E+00, 1.7379702695E+00, 8.6011019548E-01],
	[2.4650000000E+04, 1.4926310215E+01, 5.1639470915E+00, 3.1795097514E+00, 1.7386466114E+00, 8.6017627083E-01],
	[2.4655000000E+04, 1.4931046121E+01, 5.1638824506E+00, 3.1815816364E+00, 1.7393229178E+00, 8.6024231646E-01],
	[2.4660000000E+04, 1.4935782569E+01, 5.1638178237E+00, 3.1836544498E+00, 1.7399991887E+00, 8.6030833238E-01],
	[2.4665000000E+04, 1.4940519558E+01, 5.1637532106E+00, 3.1857281915E+00, 1.7406754240E+00, 8.6037431860E-01],
	[2.4670000000E+04, 1.4945257089E+01, 5.1636886115E+00, 3.1878028620E+00, 1.7413516235E+00, 8.6044027513E-01],
	[2.4675000000E+04, 1.4949995162E+01, 5.1636240263E+00, 3.1898784613E+00, 1.7420277872E+00, 8.6050620198E-01],
	[2.4680000000E+04, 1.4954733777E+01, 5.1635594549E+00, 3.1919549899E+00, 1.7427039148E+00, 8.6057209916E-01],
	[2.4685000000E+04, 1.4959472933E+01, 5.1634948975E+00, 3.1940324477E+00, 1.7433800064E+00, 8.6063796667E-01],
	[2.4690000000E+04, 1.4964212631E+01, 5.1634303539E+00, 3.1961108352E+00, 1.7440560617E+00, 8.6070380453E-01],
	[2.4695000000E+04, 1.4968966810E+01, 5.1633683409E+00, 3.1981901525E+00, 1.7447325575E+00, 8.6076961275E-01],
	[2.4700000000E+04, 1.4973729323E+01, 5.1633077466E+00, 3.2002703998E+00, 1.7454092837E+00, 8.6083539134E-01],
	[2.4705000000E+04, 1.4978492388E+01, 5.1632471654E+00, 3.2023515774E+00, 1.7460859743E+00, 8.6090114030E-01],
	[2.4710000000E+04, 1.4983256003E+01, 5.1631865971E+00, 3.2044336855E+00, 1.7467626290E+00, 8.6096685965E-01],
	[2.4715000000E+04, 1.4988020169E+01, 5.1631260418E+00, 3.2065167243E+00, 1.7474392478E+00, 8.6103254940E-01],
	[2.4720000000E+04, 1.4992784885E+01, 5.1630654994E+00, 3.2086006941E+00, 1.7481158305E+00, 8.6109820955E-01],
	[2.4725000000E+04, 1.4997550152E+01, 5.1630049700E+00, 3.2106855951E+00, 1.7487923770E+00, 8.6116384012E-01],
	[2.4730000000E+04, 1.5002315970E+01, 5.1629444535E+00, 3.2127714274E+00, 1.7494688873E+00, 8.6122944111E-01],
	[2.4735000000E+04, 1.5007082338E+01, 5.1628839500E+00, 3.2148581914E+00, 1.7501453612E+00, 8.6129501253E-01],
	[2.4740000000E+04, 1.5011849257E+01, 5.1628234594E+00, 3.2169458873E+00, 1.7508217986E+00, 8.6136055440E-01],
	[2.4745000000E+04, 1.5016616726E+01, 5.1627629818E+00, 3.2190345152E+00, 1.7514981993E+00, 8.6142606673E-01],
	[2.4750000000E+04, 1.5021384745E+01, 5.1627025170E+00, 3.2211240755E+00, 1.7521745634E+00, 8.6149154951E-01],
	[2.4755000000E+04, 1.5026153315E+01, 5.1626420652E+00, 3.2232145683E+00, 1.7528508906E+00, 8.6155700277E-01],
	[2.4760000000E+04, 1.5030922435E+01, 5.1625816264E+00, 3.2253059938E+00, 1.7535271808E+00, 8.6162242651E-01],
	[2.4765000000E+04, 1.5035692105E+01, 5.1625212004E+00, 3.2273983524E+00, 1.7542034340E+00, 8.6168782075E-01],
	[2.4770000000E+04, 1.5040462326E+01, 5.1624607873E+00, 3.2294916441E+00, 1.7548796500E+00, 8.6175318548E-01],
	[2.4775000000E+04, 1.5045233096E+01, 5.1624003872E+00, 3.2315858694E+00, 1.7555558288E+00, 8.6181852073E-01],
	[2.4780000000E+04, 1.5050004417E+01, 5.1623399999E+00, 3.2336810283E+00, 1.7562319701E+00, 8.6188382650E-01],
	[2.4785000000E+04, 1.5054776287E+01, 5.1622796255E+00, 3.2357771211E+00, 1.7569080740E+00, 8.6194910281E-01],
	[2.4790000000E+04, 1.5059548708E+01, 5.1622192640E+00, 3.2378741480E+00, 1.7575841402E+00, 8.6201434965E-01],
	[2.4795000000E+04, 1.5064321679E+01, 5.1621589154E+00, 3.2399721092E+00, 1.7582601688E+00, 8.6207956704E-01],
	[2.4800000000E+04, 1.5069095199E+01, 5.1620985796E+00, 3.2420710051E+00, 1.7589361594E+00, 8.6214475500E-01],
	[2.4805000000E+04, 1.5073869270E+01, 5.1620382568E+00, 3.2441708358E+00, 1.7596121122E+00, 8.6220991352E-01],
	[2.4810000000E+04, 1.5078643890E+01, 5.1619779467E+00, 3.2462716015E+00, 1.7602880269E+00, 8.6227504263E-01],
	[2.4815000000E+04, 1.5083419060E+01, 5.1619176496E+00, 3.2483733024E+00, 1.7609639034E+00, 8.6234014232E-01],
	[2.4820000000E+04, 1.5088194780E+01, 5.1618573653E+00, 3.2504759389E+00, 1.7616397417E+00, 8.6240521262E-01],
	[2.4825000000E+04, 1.5092971049E+01, 5.1617970938E+00, 3.2525795110E+00, 1.7623155415E+00, 8.6247025352E-01],
	[2.4830000000E+04, 1.5097747868E+01, 5.1617368352E+00, 3.2546840191E+00, 1.7629913029E+00, 8.6253526505E-01],
	[2.4835000000E+04, 1.5102525236E+01, 5.1616765894E+00, 3.2567894634E+00, 1.7636670257E+00, 8.6260024720E-01],
	[2.4840000000E+04, 1.5107303154E+01, 5.1616163565E+00, 3.2588958441E+00, 1.7643427097E+00, 8.6266519999E-01],
	[2.4845000000E+04, 1.5112081622E+01, 5.1615561363E+00, 3.2610031613E+00, 1.7650183550E+00, 8.6273012343E-01],
	[2.4850000000E+04, 1.5116860639E+01, 5.1614959290E+00, 3.2631114155E+00, 1.7656939613E+00, 8.6279501753E-01],
	[2.4855000000E+04, 1.5121640205E+01, 5.1614357346E+00, 3.2652206067E+00, 1.7663695285E+00, 8.6285988230E-01],
	[2.4860000000E+04, 1.5126420321E+01, 5.1613755529E+00, 3.2673307352E+00, 1.7670450566E+00, 8.6292471775E-01],
	[2.4865000000E+04, 1.5131200986E+01, 5.1613153840E+00, 3.2694418013E+00, 1.7677205455E+00, 8.6298952388E-01],
	[2.4870000000E+04, 1.5135982200E+01, 5.1612552279E+00, 3.2715538051E+00, 1.7683959949E+00, 8.6305430072E-01],
	[2.4875000000E+04, 1.5140763963E+01, 5.1611950846E+00, 3.2736667469E+00, 1.7690714049E+00, 8.6311904826E-01],
	[2.4880000000E+04, 1.5145546275E+01, 5.1611349542E+00, 3.2757806269E+00, 1.7697467753E+00, 8.6318376652E-01],
	[2.4885000000E+04, 1.5150329137E+01, 5.1610748364E+00, 3.2778954453E+00, 1.7704221060E+00, 8.6324845550E-01],
	[2.4890000000E+04, 1.5155112548E+01, 5.1610147315E+00, 3.2800112024E+00, 1.7710973969E+00, 8.6331311523E-01],
	[2.4895000000E+04, 1.5159896507E+01, 5.1609546394E+00, 3.2821278984E+00, 1.7717726479E+00, 8.6337774570E-01],
	[2.4900000000E+04, 1.5164681016E+01, 5.1608945600E+00, 3.2842455335E+00, 1.7724478588E+00, 8.6344234693E-01],
	[2.4905000000E+04, 1.5169466073E+01, 5.1608344933E+00, 3.2863641080E+00, 1.7731230296E+00, 8.6350691893E-01],
	[2.4910000000E+04, 1.5174251679E+01, 5.1607744395E+00, 3.2884836220E+00, 1.7737981602E+00, 8.6357146170E-01],
	[2.4915000000E+04, 1.5179037834E+01, 5.1607143983E+00, 3.2906040759E+00, 1.7744732504E+00, 8.6363597526E-01],
	[2.4920000000E+04, 1.5183824538E+01, 5.1606543700E+00, 3.2927254697E+00, 1.7751483001E+00, 8.6370045962E-01],
	[2.4925000000E+04, 1.5188611791E+01, 5.1605943543E+00, 3.2948478038E+00, 1.7758233093E+00, 8.6376491479E-01],
	[2.4930000000E+04, 1.5193399592E+01, 5.1605343514E+00, 3.2969710784E+00, 1.7764982778E+00, 8.6382934077E-01],
	[2.4935000000E+04, 1.5198187942E+01, 5.1604743613E+00, 3.2990952937E+00, 1.7771732055E+00, 8.6389373758E-01],
	[2.4940000000E+04, 1.5202976840E+01, 5.1604143838E+00, 3.3012204500E+00, 1.7778480923E+00, 8.6395810523E-01],
	[2.4945000000E+04, 1.5207766287E+01, 5.1603544191E+00, 3.3033465474E+00, 1.7785229380E+00, 8.6402244372E-01],
	[2.4950000000E+04, 1.5212556283E+01, 5.1602944671E+00, 3.3054735862E+00, 1.7791977427E+00, 8.6408675307E-01],
	[2.4955000000E+04, 1.5217346827E+01, 5.1602345278E+00, 3.3076015666E+00, 1.7798725062E+00, 8.6415103329E-01],
	[2.4960000000E+04, 1.5222137919E+01, 5.1601746012E+00, 3.3097304889E+00, 1.7805472283E+00, 8.6421528438E-01],
	[2.4965000000E+04, 1.5226929559E+01, 5.1601146873E+00, 3.3118603532E+00, 1.7812219090E+00, 8.6427950637E-01],
	[2.4970000000E+04, 1.5231721748E+01, 5.1600547861E+00, 3.3139911598E+00, 1.7818965482E+00, 8.6434369924E-01],
	[2.4975000000E+04, 1.5236514485E+01, 5.1599948976E+00, 3.3161229090E+00, 1.7825711456E+00, 8.6440786303E-01],
	[2.4980000000E+04, 1.5241307771E+01, 5.1599350218E+00, 3.3182556009E+00, 1.7832457014E+00, 8.6447199773E-01],
	[2.4985000000E+04, 1.5246101604E+01, 5.1598751586E+00, 3.3203892358E+00, 1.7839202152E+00, 8.6453610336E-01],
	[2.4990000000E+04, 1.5250895986E+01, 5.1598153081E+00, 3.3225238139E+00, 1.7845946871E+00, 8.6460017993E-01],
	[2.4995000000E+04, 1.5255690915E+01, 5.1597554703E+00, 3.3246593354E+00, 1.7852691169E+00, 8.6466422744E-01],
	[2.5000000000E+04, 1.5260486393E+01, 5.1596956452E+00, 3.3267958006E+00, 1.7859435045E+00, 8.6472824591E-01],
	[2.5005000000E+04, 1.5265282418E+01, 5.1596358327E+00, 3.3289389267E+00, 1.7866194966E+00, 8.6479223535E-01],
	[2.5010000000E+04, 1.5270078992E+01, 5.1595760328E+00, 3.3310830033E+00, 1.7872954463E+00, 8.6485619577E-01],
	[2.5015000000E+04, 1.5274876113E+01, 5.1595162457E+00, 3.3332280308E+00, 1.7879713536E+00, 8.6492012717E-01],
	[2.5020000000E+04, 1.5279673782E+01, 5.1594564711E+00, 3.3353740092E+00, 1.7886472184E+00, 8.6498402957E-01],
	[2.5025000000E+04, 1.5284471999E+01, 5.1593967092E+00, 3.3375209389E+00, 1.7893230406E+00, 8.6504790298E-01],
	[2.5030000000E+04, 1.5289270764E+01, 5.1593369599E+00, 3.3396688200E+00, 1.7899988201E+00, 8.6511174740E-01],
	[2.5035000000E+04, 1.5294070076E+01, 5.1592772233E+00, 3.3418176529E+00, 1.7906745567E+00, 8.6517556285E-01],
	[2.5040000000E+04, 1.5298869936E+01, 5.1592174992E+00, 3.3439674377E+00, 1.7913502503E+00, 8.6523934934E-01],
	[2.5045000000E+04, 1.5303670344E+01, 5.1591577878E+00, 3.3461181746E+00, 1.7920259009E+00, 8.6530310688E-01],
	[2.5050000000E+04, 1.5308471299E+01, 5.1590980890E+00, 3.3482698639E+00, 1.7927015083E+00, 8.6536683548E-01],
	[2.5055000000E+04, 1.5313272802E+01, 5.1590384028E+00, 3.3504225059E+00, 1.7933770725E+00, 8.6543053514E-01],
	[2.5060000000E+04, 1.5318074852E+01, 5.1589787292E+00, 3.3525761007E+00, 1.7940525932E+00, 8.6549420588E-01],
	[2.5065000000E+04, 1.5322877449E+01, 5.1589190682E+00, 3.3547306486E+00, 1.7947280705E+00, 8.6555784771E-01],
	[2.5070000000E+04, 1.5327680594E+01, 5.1588594198E+00, 3.3568861498E+00, 1.7954035042E+00, 8.6562146064E-01],
	[2.5075000000E+04, 1.5332484286E+01, 5.1587997839E+00, 3.3590426045E+00, 1.7960788942E+00, 8.6568504468E-01],
	[2.5080000000E+04, 1.5337288525E+01, 5.1587401607E+00, 3.3612000130E+00, 1.7967542403E+00, 8.6574859984E-01],
	[2.5085000000E+04, 1.5342093312E+01, 5.1586805500E+00, 3.3633583755E+00, 1.7974295426E+00, 8.6581212612E-01],
	[2.5090000000E+04, 1.5346901729E+01, 5.1586214955E+00, 3.3655176923E+00, 1.7981049092E+00, 8.6587562354E-01],
	[2.5095000000E+04, 1.5351729520E+01, 5.1585657706E+00, 3.3676779635E+00, 1.7987808935E+00, 8.6593909212E-01],
	[2.5100000000E+04, 1.5356557868E+01, 5.1585100575E+00, 3.3698391894E+00, 1.7994568345E+00, 8.6600253185E-01],
	[2.5105000000E+04, 1.5361386772E+01, 5.1584543561E+00, 3.3720013703E+00, 1.8001327319E+00, 8.6606594275E-01],
	[2.5110000000E+04, 1.5366216232E+01, 5.1583986664E+00, 3.3741645063E+00, 1.8008085857E+00, 8.6612932484E-01],
	[2.5115000000E+04, 1.5371046248E+01, 5.1583429883E+00, 3.3763285977E+00, 1.8014843958E+00, 8.6619267811E-01],
	[2.5120000000E+04, 1.5375876821E+01, 5.1582873220E+00, 3.3784936447E+00, 1.8021601620E+00, 8.6625600258E-01],
	[2.5125000000E+04, 1.5380707950E+01, 5.1582316673E+00, 3.3806596476E+00, 1.8028358843E+00, 8.6631929826E-01],
	[2.5130000000E+04, 1.5385539635E+01, 5.1581760243E+00, 3.3828266066E+00, 1.8035115626E+00, 8.6638256517E-01],
	[2.5135000000E+04, 1.5390371877E+01, 5.1581203929E+00, 3.3849945218E+00, 1.8041871966E+00, 8.6644580330E-01],
	[2.5140000000E+04, 1.5395204674E+01, 5.1580647733E+00, 3.3871633937E+00, 1.8048627864E+00, 8.6650901267E-01],
	[2.5145000000E+04, 1.5400038027E+01, 5.1580091653E+00, 3.3893332223E+00, 1.8055383318E+00, 8.6657219330E-01],
	[2.5150000000E+04, 1.5404871937E+01, 5.1579535689E+00, 3.3915040079E+00, 1.8062138328E+00, 8.6663534519E-01],
	[2.5155000000E+04, 1.5409706402E+01, 5.1578979842E+00, 3.3936757507E+00, 1.8068892891E+00, 8.6669846835E-01],
	[2.5160000000E+04, 1.5414541424E+01, 5.1578424112E+00, 3.3958484510E+00, 1.8075647008E+00, 8.6676156279E-01],
	[2.5165000000E+04, 1.5419377001E+01, 5.1577868498E+00, 3.3980221090E+00, 1.8082400677E+00, 8.6682462852E-01],
	[2.5170000000E+04, 1.5424213134E+01, 5.1577313000E+00, 3.4001967250E+00, 1.8089153896E+00, 8.6688766556E-01],
	[2.5175000000E+04, 1.5429049822E+01, 5.1576757618E+00, 3.4023722991E+00, 1.8095906666E+00, 8.6695067391E-01],
	[2.5180000000E+04, 1.5433887067E+01, 5.1576202353E+00, 3.4045488316E+00, 1.8102658984E+00, 8.6701365358E-01],
	[2.5185000000E+04, 1.5438724867E+01, 5.1575647204E+00, 3.4067263227E+00, 1.8109410850E+00, 8.6707660459E-01],
	[2.5190000000E+04, 1.5443563222E+01, 5.1575092172E+00, 3.4089047726E+00, 1.8116162263E+00, 8.6713952694E-01],
	[2.5195000000E+04, 1.5448402133E+01, 5.1574537255E+00, 3.4110841817E+00, 1.8122913222E+00, 8.6720242064E-01],
	[2.5200000000E+04, 1.5453241600E+01, 5.1573982454E+00, 3.4132645501E+00, 1.8129663725E+00, 8.6726528570E-01],
	[2.5205000000E+04, 1.5458081622E+01, 5.1573427770E+00, 3.4154458780E+00, 1.8136413772E+00, 8.6732812215E-01],
	[2.5210000000E+04, 1.5462922200E+01, 5.1572873201E+00, 3.4176281657E+00, 1.8143163361E+00, 8.6739092997E-01],
	[2.5215000000E+04, 1.5467763333E+01, 5.1572318749E+00, 3.4198114134E+00, 1.8149912492E+00, 8.6745370919E-01],
	[2.5220000000E+04, 1.5472605021E+01, 5.1571764412E+00, 3.4219956213E+00, 1.8156661163E+00, 8.6751645982E-01],
	[2.5225000000E+04, 1.5477447265E+01, 5.1571210191E+00, 3.4241807898E+00, 1.8163409374E+00, 8.6757918186E-01],
	[2.5230000000E+04, 1.5482290064E+01, 5.1570656086E+00, 3.4263669189E+00, 1.8170157122E+00, 8.6764187537E-01],
	[2.5235000000E+04, 1.5487133418E+01, 5.1570102097E+00, 3.4285540089E+00, 1.8176904408E+00, 8.6770454043E-01],
	[2.5240000000E+04, 1.5491977327E+01, 5.1569548223E+00, 3.4307420602E+00, 1.8183651231E+00, 8.6776717708E-01],
	[2.5245000000E+04, 1.5496821792E+01, 5.1568994465E+00, 3.4329310728E+00, 1.8190397588E+00, 8.6782978530E-01],
	[2.5250000000E+04, 1.5501666811E+01, 5.1568440823E+00, 3.4351210470E+00, 1.8197143480E+00, 8.6789236512E-01],
	[2.5255000000E+04, 1.5506512385E+01, 5.1567887296E+00, 3.4373119831E+00, 1.8203888904E+00, 8.6795491654E-01],
	[2.5260000000E+04, 1.5511358515E+01, 5.1567333885E+00, 3.4395038813E+00, 1.8210633861E+00, 8.6801743957E-01],
	[2.5265000000E+04, 1.5516205199E+01, 5.1566780589E+00, 3.4416967418E+00, 1.8217378349E+00, 8.6807993421E-01],
	[2.5270000000E+04, 1.5521052438E+01, 5.1566227409E+00, 3.4438905649E+00, 1.8224122366E+00, 8.6814240048E-01],
	[2.5275000000E+04, 1.5525900232E+01, 5.1565674344E+00, 3.4460853507E+00, 1.8230865913E+00, 8.6820483839E-01],
	[2.5280000000E+04, 1.5530748581E+01, 5.1565121394E+00, 3.4482810996E+00, 1.8237608987E+00, 8.6826724794E-01],
	[2.5285000000E+04, 1.5535597484E+01, 5.1564568560E+00, 3.4504778117E+00, 1.8244351588E+00, 8.6832962914E-01],
	[2.5290000000E+04, 1.5540446943E+01, 5.1564015841E+00, 3.4526754873E+00, 1.8251093715E+00, 8.6839198199E-01],
	[2.5295000000E+04, 1.5545296955E+01, 5.1563463237E+00, 3.4548741266E+00, 1.8257835367E+00, 8.6845430652E-01],
	[2.5300000000E+04, 1.5550147523E+01, 5.1562910748E+00, 3.4570737298E+00, 1.8264576542E+00, 8.6851660272E-01],
	[2.5305000000E+04, 1.5554998645E+01, 5.1562358374E+00, 3.4592742972E+00, 1.8271317240E+00, 8.6857887061E-01],
	[2.5310000000E+04, 1.5559850321E+01, 5.1561806116E+00, 3.4614758290E+00, 1.8278057460E+00, 8.6864111019E-01],
	[2.5315000000E+04, 1.5564702552E+01, 5.1561253972E+00, 3.4636783254E+00, 1.8284797200E+00, 8.6870332147E-01],
	[2.5320000000E+04, 1.5569555338E+01, 5.1560701943E+00, 3.4658817867E+00, 1.8291536460E+00, 8.6876550446E-01],
	[2.5325000000E+04, 1.5574408677E+01, 5.1560150029E+00, 3.4680862131E+00, 1.8298275238E+00, 8.6882765918E-01],
	[2.5330000000E+04, 1.5579262571E+01, 5.1559598231E+00, 3.4702916048E+00, 1.8305013534E+00, 8.6888978561E-01],
	[2.5335000000E+04, 1.5584117020E+01, 5.1559046546E+00, 3.4724979621E+00, 1.8311751346E+00, 8.6895188379E-01],
	[2.5340000000E+04, 1.5588972022E+01, 5.1558494977E+00, 3.4747052851E+00, 1.8318488674E+00, 8.6901395371E-01],
	[2.5345000000E+04, 1.5593827579E+01, 5.1557943522E+00, 3.4769135742E+00, 1.8325225516E+00, 8.6907599538E-01],
	[2.5350000000E+04, 1.5598683690E+01, 5.1557392182E+00, 3.4791228296E+00, 1.8331961871E+00, 8.6913800882E-01],
	[2.5355000000E+04, 1.5603540355E+01, 5.1556840957E+00, 3.4813330514E+00, 1.8338697739E+00, 8.6919999402E-01],
	[2.5360000000E+04, 1.5608397573E+01, 5.1556289846E+00, 3.4835442399E+00, 1.8345433117E+00, 8.6926195100E-01],
	[2.5365000000E+04, 1.5613255346E+01, 5.1555738850E+00, 3.4857563954E+00, 1.8352168006E+00, 8.6932387977E-01],
	[2.5370000000E+04, 1.5618113673E+01, 5.1555187968E+00, 3.4879695180E+00, 1.8358902405E+00, 8.6938578034E-01],
	[2.5375000000E+04, 1.5622972554E+01, 5.1554637201E+00, 3.4901836080E+00, 1.8365636311E+00, 8.6944765271E-01],
	[2.5380000000E+04, 1.5627831989E+01, 5.1554086548E+00, 3.4923986657E+00, 1.8372369725E+00, 8.6950949690E-01],
	[2.5385000000E+04, 1.5632691977E+01, 5.1553536010E+00, 3.4946146913E+00, 1.8379102645E+00, 8.6957131291E-01],
	[2.5390000000E+04, 1.5637552520E+01, 5.1552985586E+00, 3.4968316850E+00, 1.8385835070E+00, 8.6963310074E-01],
	[2.5395000000E+04, 1.5642413615E+01, 5.1552435276E+00, 3.4990496470E+00, 1.8392566999E+00, 8.6969486042E-01],
	[2.5400000000E+04, 1.5647275265E+01, 5.1551885080E+00, 3.5012685775E+00, 1.8399298431E+00, 8.6975659195E-01],
	[2.5405000000E+04, 1.5652137468E+01, 5.1551334998E+00, 3.5034884769E+00, 1.8406029365E+00, 8.6981829533E-01],
	[2.5410000000E+04, 1.5657000225E+01, 5.1550785031E+00, 3.5057093452E+00, 1.8412759800E+00, 8.6987997057E-01],
	[2.5415000000E+04, 1.5661863536E+01, 5.1550235177E+00, 3.5079311829E+00, 1.8419489736E+00, 8.6994161770E-01],
	[2.5420000000E+04, 1.5666727399E+01, 5.1549685438E+00, 3.5101539900E+00, 1.8426219170E+00, 8.7000323670E-01],
	[2.5425000000E+04, 1.5671591817E+01, 5.1549135813E+00, 3.5123777669E+00, 1.8432948102E+00, 8.7006482759E-01],
	[2.5430000000E+04, 1.5676456787E+01, 5.1548586301E+00, 3.5146025137E+00, 1.8439676531E+00, 8.7012639039E-01],
	[2.5435000000E+04, 1.5681322312E+01, 5.1548036904E+00, 3.5168282307E+00, 1.8446404456E+00, 8.7018792509E-01],
	[2.5440000000E+04, 1.5686188389E+01, 5.1547487620E+00, 3.5190549181E+00, 1.8453131876E+00, 8.7024943172E-01],
	[2.5445000000E+04, 1.5691055020E+01, 5.1546938450E+00, 3.5212825761E+00, 1.8459858789E+00, 8.7031091027E-01],
	[2.5450000000E+04, 1.5695922203E+01, 5.1546389394E+00, 3.5235112050E+00, 1.8466585196E+00, 8.7037236075E-01],
	[2.5455000000E+04, 1.5700789940E+01, 5.1545840451E+00, 3.5257408051E+00, 1.8473311094E+00, 8.7043378318E-01],
	[2.5460000000E+04, 1.5705658231E+01, 5.1545291623E+00, 3.5279713765E+00, 1.8480036484E+00, 8.7049517756E-01],
	[2.5465000000E+04, 1.5710527074E+01, 5.1544742907E+00, 3.5302029194E+00, 1.8486761363E+00, 8.7055654390E-01],
	[2.5470000000E+04, 1.5715396470E+01, 5.1544194306E+00, 3.5324354342E+00, 1.8493485731E+00, 8.7061788221E-01],
	[2.5475000000E+04, 1.5720266419E+01, 5.1543645818E+00, 3.5346689210E+00, 1.8500209587E+00, 8.7067919251E-01],
	[2.5480000000E+04, 1.5725136921E+01, 5.1543097443E+00, 3.5369033800E+00, 1.8506932929E+00, 8.7074047478E-01],
	[2.5485000000E+04, 1.5730007976E+01, 5.1542549182E+00, 3.5391388116E+00, 1.8513655757E+00, 8.7080172906E-01],
	[2.5490000000E+04, 1.5734879584E+01, 5.1542001034E+00, 3.5413752159E+00, 1.8520378070E+00, 8.7086295534E-01],
	[2.5495000000E+04, 1.5739759616E+01, 5.1541466661E+00, 3.5436125931E+00, 1.8527102723E+00, 8.7092415364E-01],
	[2.5500000000E+04, 1.5744654196E+01, 5.1540956676E+00, 3.5458509436E+00, 1.8533831939E+00, 8.7098532396E-01],
	[2.5505000000E+04, 1.5749549337E+01, 5.1540446796E+00, 3.5480902674E+00, 1.8540560646E+00, 8.7104646631E-01],
	[2.5510000000E+04, 1.5754445041E+01, 5.1539937020E+00, 3.5503305649E+00, 1.8547288841E+00, 8.7110758071E-01],
	[2.5515000000E+04, 1.5759341306E+01, 5.1539427350E+00, 3.5525718364E+00, 1.8554016524E+00, 8.7116866715E-01],
	[2.5520000000E+04, 1.5764238134E+01, 5.1538917784E+00, 3.5548140819E+00, 1.8560743694E+00, 8.7122972565E-01],
	[2.5525000000E+04, 1.5769135523E+01, 5.1538408323E+00, 3.5570573018E+00, 1.8567470349E+00, 8.7129075622E-01],
	[2.5530000000E+04, 1.5774033474E+01, 5.1537898967E+00, 3.5593014963E+00, 1.8574196490E+00, 8.7135175887E-01],
	[2.5535000000E+04, 1.5778931986E+01, 5.1537389716E+00, 3.5615466655E+00, 1.8580922115E+00, 8.7141273361E-01],
	[2.5540000000E+04, 1.5783831060E+01, 5.1536880570E+00, 3.5637928099E+00, 1.8587647222E+00, 8.7147368043E-01],
	[2.5545000000E+04, 1.5788730696E+01, 5.1536371528E+00, 3.5660399295E+00, 1.8594371812E+00, 8.7153459936E-01],
	[2.5550000000E+04, 1.5793630894E+01, 5.1535862591E+00, 3.5682880246E+00, 1.8601095882E+00, 8.7159549041E-01],
	[2.5555000000E+04, 1.5798531652E+01, 5.1535353759E+00, 3.5705370955E+00, 1.8607819432E+00, 8.7165635357E-01],
	[2.5560000000E+04, 1.5803432973E+01, 5.1534845031E+00, 3.5727871423E+00, 1.8614542461E+00, 8.7171718887E-01],
	[2.5565000000E+04, 1.5808334855E+01, 5.1534336408E+00, 3.5750381653E+00, 1.8621264968E+00, 8.7177799630E-01],
	[2.5570000000E+04, 1.5813237298E+01, 5.1533827889E+00, 3.5772901648E+00, 1.8627986952E+00, 8.7183877588E-01],
	[2.5575000000E+04, 1.5818140303E+01, 5.1533319474E+00, 3.5795431409E+00, 1.8634708411E+00, 8.7189952762E-01],
	[2.5580000000E+04, 1.5823043869E+01, 5.1532811164E+00, 3.5817970940E+00, 1.8641429346E+00, 8.7196025153E-01],
	[2.5585000000E+04, 1.5827947996E+01, 5.1532302959E+00, 3.5840520241E+00, 1.8648149754E+00, 8.7202094761E-01],
	[2.5590000000E+04, 1.5832852684E+01, 5.1531794857E+00, 3.5863079317E+00, 1.8654869636E+00, 8.7208161588E-01],
	[2.5595000000E+04, 1.5837757934E+01, 5.1531286860E+00, 3.5885648168E+00, 1.8661588989E+00, 8.7214225634E-01],
	[2.5600000000E+04, 1.5842663744E+01, 5.1530778967E+00, 3.5908226798E+00, 1.8668307813E+00, 8.7220286900E-01],
	[2.5605000000E+04, 1.5847570116E+01, 5.1530271179E+00, 3.5930815208E+00, 1.8675026107E+00, 8.7226345387E-01],
	[2.5610000000E+04, 1.5852477049E+01, 5.1529763494E+00, 3.5953413401E+00, 1.8681743870E+00, 8.7232401097E-01],
	[2.5615000000E+04, 1.5857384543E+01, 5.1529255914E+00, 3.5976021379E+00, 1.8688461101E+00, 8.7238454029E-01],
	[2.5620000000E+04, 1.5862292598E+01, 5.1528748438E+00, 3.5998639145E+00, 1.8695177799E+00, 8.7244504185E-01],
	[2.5625000000E+04, 1.5867201213E+01, 5.1528241065E+00, 3.6021266701E+00, 1.8701893963E+00, 8.7250551566E-01],
	[2.5630000000E+04, 1.5872110390E+01, 5.1527733797E+00, 3.6043904049E+00, 1.8708609592E+00, 8.7256596173E-01],
	[2.5635000000E+04, 1.5877020127E+01, 5.1527226633E+00, 3.6066551191E+00, 1.8715324685E+00, 8.7262638006E-01],
	[2.5640000000E+04, 1.5881930425E+01, 5.1526719572E+00, 3.6089208130E+00, 1.8722039240E+00, 8.7268677067E-01],
	[2.5645000000E+04, 1.5886841284E+01, 5.1526212616E+00, 3.6111874868E+00, 1.8728753258E+00, 8.7274713356E-01],
	[2.5650000000E+04, 1.5891752703E+01, 5.1525705763E+00, 3.6134551408E+00, 1.8735466737E+00, 8.7280746875E-01],
	[2.5655000000E+04, 1.5896664683E+01, 5.1525199014E+00, 3.6157237752E+00, 1.8742179676E+00, 8.7286777623E-01],
	[2.5660000000E+04, 1.5901577224E+01, 5.1524692369E+00, 3.6179933901E+00, 1.8748892074E+00, 8.7292805603E-01],
	[2.5665000000E+04, 1.5906490325E+01, 5.1524185827E+00, 3.6202639859E+00, 1.8755603930E+00, 8.7298830815E-01],
	[2.5670000000E+04, 1.5911403987E+01, 5.1523679389E+00, 3.6225355628E+00, 1.8762315243E+00, 8.7304853260E-01],
	[2.5675000000E+04, 1.5916318209E+01, 5.1523173055E+00, 3.6248081210E+00, 1.8769026012E+00, 8.7310872939E-01],
	[2.5680000000E+04, 1.5921232991E+01, 5.1522666824E+00, 3.6270816607E+00, 1.8775736236E+00, 8.7316889852E-01],
	[2.5685000000E+04, 1.5926148334E+01, 5.1522160697E+00, 3.6293561822E+00, 1.8782445914E+00, 8.7322904001E-01],
	[2.5690000000E+04, 1.5931064237E+01, 5.1521654673E+00, 3.6316316856E+00, 1.8789155046E+00, 8.7328915387E-01],
	[2.5695000000E+04, 1.5935980701E+01, 5.1521148753E+00, 3.6339081714E+00, 1.8795863630E+00, 8.7334924011E-01],
	[2.5700000000E+04, 1.5940897724E+01, 5.1520642936E+00, 3.6361856395E+00, 1.8802571664E+00, 8.7340929873E-01],
	[2.5705000000E+04, 1.5945815308E+01, 5.1520137223E+00, 3.6384640904E+00, 1.8809279150E+00, 8.7346932974E-01],
	[2.5710000000E+04, 1.5950733452E+01, 5.1519631613E+00, 3.6407435242E+00, 1.8815986084E+00, 8.7352933316E-01],
	[2.5715000000E+04, 1.5955652156E+01, 5.1519126106E+00, 3.6430239412E+00, 1.8822692467E+00, 8.7358930899E-01],
	[2.5720000000E+04, 1.5960571420E+01, 5.1518620702E+00, 3.6453053415E+00, 1.8829398297E+00, 8.7364925724E-01],
	[2.5725000000E+04, 1.5965491244E+01, 5.1518115402E+00, 3.6475877255E+00, 1.8836103573E+00, 8.7370917792E-01],
	[2.5730000000E+04, 1.5970411628E+01, 5.1517610204E+00, 3.6498710933E+00, 1.8842808295E+00, 8.7376907104E-01],
	[2.5735000000E+04, 1.5975332572E+01, 5.1517105110E+00, 3.6521554452E+00, 1.8849512461E+00, 8.7382893661E-01],
	[2.5740000000E+04, 1.5980254075E+01, 5.1516600119E+00, 3.6544407814E+00, 1.8856216070E+00, 8.7388877464E-01],
	[2.5745000000E+04, 1.5985176139E+01, 5.1516095231E+00, 3.6567271022E+00, 1.8862919122E+00, 8.7394858514E-01],
	[2.5750000000E+04, 1.5990098762E+01, 5.1515590446E+00, 3.6590144078E+00, 1.8869621615E+00, 8.7400836811E-01],
	[2.5755000000E+04, 1.5995021945E+01, 5.1515085764E+00, 3.6613026984E+00, 1.8876323549E+00, 8.7406812357E-01],
	[2.5760000000E+04, 1.5999945688E+01, 5.1514581184E+00, 3.6635919742E+00, 1.8883024922E+00, 8.7412785153E-01],
	[2.5765000000E+04, 1.6004869990E+01, 5.1514076708E+00, 3.6658822355E+00, 1.8889725734E+00, 8.7418755199E-01],
	[2.5770000000E+04, 1.6009794852E+01, 5.1513572335E+00, 3.6681734826E+00, 1.8896425984E+00, 8.7424722497E-01],
	[2.5775000000E+04, 1.6014720274E+01, 5.1513068064E+00, 3.6704657155E+00, 1.8903125670E+00, 8.7430687047E-01],
	[2.5780000000E+04, 1.6019646255E+01, 5.1512563896E+00, 3.6727589347E+00, 1.8909824791E+00, 8.7436648850E-01],
	[2.5785000000E+04, 1.6024572795E+01, 5.1512059830E+00, 3.6750531402E+00, 1.8916523348E+00, 8.7442607907E-01],
	[2.5790000000E+04, 1.6029499895E+01, 5.1511555868E+00, 3.6773483324E+00, 1.8923221338E+00, 8.7448564220E-01],
	[2.5795000000E+04, 1.6034427554E+01, 5.1511052008E+00, 3.6796445115E+00, 1.8929918761E+00, 8.7454517789E-01],
	[2.5800000000E+04, 1.6039355773E+01, 5.1510548250E+00, 3.6819416776E+00, 1.8936615616E+00, 8.7460468614E-01],
	[2.5805000000E+04, 1.6044284550E+01, 5.1510044596E+00, 3.6842398311E+00, 1.8943311901E+00, 8.7466416698E-01],
	[2.5810000000E+04, 1.6049213887E+01, 5.1509541043E+00, 3.6865389722E+00, 1.8950007616E+00, 8.7472362041E-01],
	[2.5815000000E+04, 1.6054143783E+01, 5.1509037593E+00, 3.6888391011E+00, 1.8956702761E+00, 8.7478304643E-01],
	[2.5820000000E+04, 1.6059074239E+01, 5.1508534246E+00, 3.6911402180E+00, 1.8963397333E+00, 8.7484244507E-01],
	[2.5825000000E+04, 1.6064005253E+01, 5.1508031001E+00, 3.6934423232E+00, 1.8970091332E+00, 8.7490181631E-01],
	[2.5830000000E+04, 1.6068936827E+01, 5.1507527858E+00, 3.6957454168E+00, 1.8976784758E+00, 8.7496116019E-01],
	[2.5835000000E+04, 1.6073868959E+01, 5.1507024818E+00, 3.6980494992E+00, 1.8983477608E+00, 8.7502047670E-01],
	[2.5840000000E+04, 1.6078801650E+01, 5.1506521879E+00, 3.7003545706E+00, 1.8990169882E+00, 8.7507976586E-01],
	[2.5845000000E+04, 1.6083734901E+01, 5.1506019043E+00, 3.7026606311E+00, 1.8996861580E+00, 8.7513902767E-01],
	[2.5850000000E+04, 1.6088668710E+01, 5.1505516310E+00, 3.7049676811E+00, 1.9003552700E+00, 8.7519826215E-01],
	[2.5855000000E+04, 1.6093603078E+01, 5.1505013678E+00, 3.7072757208E+00, 1.9010243241E+00, 8.7525746930E-01],
	[2.5860000000E+04, 1.6098538005E+01, 5.1504511148E+00, 3.7095847503E+00, 1.9016933203E+00, 8.7531664913E-01],
	[2.5865000000E+04, 1.6103473490E+01, 5.1504008721E+00, 3.7118947699E+00, 1.9023622583E+00, 8.7537580166E-01],
	[2.5870000000E+04, 1.6108409534E+01, 5.1503506395E+00, 3.7142057799E+00, 1.9030311382E+00, 8.7543492688E-01],
	[2.5875000000E+04, 1.6113346137E+01, 5.1503004172E+00, 3.7165177805E+00, 1.9036999599E+00, 8.7549402482E-01],
	[2.5880000000E+04, 1.6118283299E+01, 5.1502502050E+00, 3.7188307719E+00, 1.9043687232E+00, 8.7555309548E-01],
	[2.5885000000E+04, 1.6123221019E+01, 5.1502000030E+00, 3.7211447544E+00, 1.9050374281E+00, 8.7561213887E-01],
	[2.5890000000E+04, 1.6128159297E+01, 5.1501498113E+00, 3.7234597281E+00, 1.9057060744E+00, 8.7567115500E-01],
	[2.5895000000E+04, 1.6133098134E+01, 5.1500996297E+00, 3.7257756934E+00, 1.9063746621E+00, 8.7573014388E-01],
	[2.5900000000E+04, 1.6138037529E+01, 5.1500494582E+00, 3.7280926504E+00, 1.9070431911E+00, 8.7578910551E-01],
	[2.5905000000E+04, 1.6142983559E+01, 5.1500003367E+00, 3.7304105994E+00, 1.9077118887E+00, 8.7584803992E-01],
	[2.5910000000E+04, 1.6147945861E+01, 5.1499539128E+00, 3.7327295406E+00, 1.9083811162E+00, 8.7590694710E-01],
	[2.5915000000E+04, 1.6152908730E+01, 5.1499074983E+00, 3.7350494743E+00, 1.9090502854E+00, 8.7596582707E-01],
	[2.5920000000E+04, 1.6157872166E+01, 5.1498610932E+00, 3.7373704006E+00, 1.9097193964E+00, 8.7602467984E-01],
	[2.5925000000E+04, 1.6162836170E+01, 5.1498146974E+00, 3.7396923198E+00, 1.9103884490E+00, 8.7608350542E-01],
	[2.5930000000E+04, 1.6167800741E+01, 5.1497683111E+00, 3.7420152322E+00, 1.9110574430E+00, 8.7614230380E-01],
	[2.5935000000E+04, 1.6172765880E+01, 5.1497219340E+00, 3.7443391380E+00, 1.9117263785E+00, 8.7620107502E-01],
	[2.5940000000E+04, 1.6177731585E+01, 5.1496755664E+00, 3.7466640373E+00, 1.9123952554E+00, 8.7625981907E-01],
	[2.5945000000E+04, 1.6182697858E+01, 5.1496292080E+00, 3.7489899305E+00, 1.9130640734E+00, 8.7631853596E-01],
	[2.5950000000E+04, 1.6187664698E+01, 5.1495828591E+00, 3.7513168178E+00, 1.9137328326E+00, 8.7637722571E-01],
	[2.5955000000E+04, 1.6192632105E+01, 5.1495365195E+00, 3.7536446994E+00, 1.9144015328E+00, 8.7643588832E-01],
	[2.5960000000E+04, 1.6197600079E+01, 5.1494901892E+00, 3.7559735755E+00, 1.9150701740E+00, 8.7649452381E-01],
	[2.5965000000E+04, 1.6202568620E+01, 5.1494438682E+00, 3.7583034464E+00, 1.9157387560E+00, 8.7655313218E-01],
	[2.5970000000E+04, 1.6207537728E+01, 5.1493975566E+00, 3.7606343123E+00, 1.9164072788E+00, 8.7661171344E-01],
	[2.5975000000E+04, 1.6212507403E+01, 5.1493512544E+00, 3.7629661734E+00, 1.9170757423E+00, 8.7667026760E-01],
	[2.5980000000E+04, 1.6217477645E+01, 5.1493049614E+00, 3.7652990300E+00, 1.9177441463E+00, 8.7672879467E-01],
	[2.5985000000E+04, 1.6222448454E+01, 5.1492586778E+00, 3.7676328823E+00, 1.9184124908E+00, 8.7678729467E-01],
	[2.5990000000E+04, 1.6227419829E+01, 5.1492124035E+00, 3.7699677305E+00, 1.9190807757E+00, 8.7684576759E-01],
	[2.5995000000E+04, 1.6232391771E+01, 5.1491661385E+00, 3.7723035749E+00, 1.9197490009E+00, 8.7690421346E-01],
	[2.6000000000E+04, 1.6237364280E+01, 5.1491198829E+00, 3.7746404156E+00, 1.9204171663E+00, 8.7696263227E-01],
	[2.6005000000E+04, 1.6242337355E+01, 5.1490736365E+00, 3.7769782530E+00, 1.9210852718E+00, 8.7702102405E-01],
	[2.6010000000E+04, 1.6247310997E+01, 5.1490273995E+00, 3.7793170873E+00, 1.9217533173E+00, 8.7707938879E-01],
	[2.6015000000E+04, 1.6252285206E+01, 5.1489811717E+00, 3.7816569187E+00, 1.9224213028E+00, 8.7713772651E-01],
	[2.6020000000E+04, 1.6257259981E+01, 5.1489349533E+00, 3.7839977474E+00, 1.9230892280E+00, 8.7719603723E-01],
	[2.6025000000E+04, 1.6262235323E+01, 5.1488887441E+00, 3.7863395736E+00, 1.9237570930E+00, 8.7725432094E-01],
	[2.6030000000E+04, 1.6267211231E+01, 5.1488425442E+00, 3.7886823977E+00, 1.9244248977E+00, 8.7731257765E-01],
	[2.6035000000E+04, 1.6272187705E+01, 5.1487963537E+00, 3.7910262197E+00, 1.9250926419E+00, 8.7737080739E-01],
	[2.6040000000E+04, 1.6277164746E+01, 5.1487501724E+00, 3.7933710400E+00, 1.9257603255E+00, 8.7742901015E-01],
	[2.6045000000E+04, 1.6282142353E+01, 5.1487040004E+00, 3.7957168588E+00, 1.9264279485E+00, 8.7748718595E-01],
	[2.6050000000E+04, 1.6287120526E+01, 5.1486578376E+00, 3.7980636764E+00, 1.9270955108E+00, 8.7754533479E-01],
	[2.6055000000E+04, 1.6292099266E+01, 5.1486116842E+00, 3.8004114929E+00, 1.9277630123E+00, 8.7760345670E-01],
	[2.6060000000E+04, 1.6297078571E+01, 5.1485655400E+00, 3.8027603085E+00, 1.9284304528E+00, 8.7766155166E-01],
	[2.6065000000E+04, 1.6302058443E+01, 5.1485194051E+00, 3.8051101236E+00, 1.9290978323E+00, 8.7771961971E-01],
	[2.6070000000E+04, 1.6307038881E+01, 5.1484732794E+00, 3.8074609384E+00, 1.9297651508E+00, 8.7777766084E-01],
	[2.6075000000E+04, 1.6312019884E+01, 5.1484271630E+00, 3.8098127530E+00, 1.9304324080E+00, 8.7783567506E-01],
	[2.6080000000E+04, 1.6317001454E+01, 5.1483810559E+00, 3.8121655677E+00, 1.9310996040E+00, 8.7789366239E-01],
	[2.6085000000E+04, 1.6321983590E+01, 5.1483349580E+00, 3.8145193828E+00, 1.9317667386E+00, 8.7795162283E-01],
	[2.6090000000E+04, 1.6326966291E+01, 5.1482888693E+00, 3.8168741985E+00, 1.9324338118E+00, 8.7800955640E-01],
	[2.6095000000E+04, 1.6331949559E+01, 5.1482427899E+00, 3.8192300150E+00, 1.9331008233E+00, 8.7806746310E-01],
	[2.6100000000E+04, 1.6336933392E+01, 5.1481967197E+00, 3.8215868326E+00, 1.9337677733E+00, 8.7812534294E-01],
	[2.6105000000E+04, 1.6341917791E+01, 5.1481506588E+00, 3.8239446514E+00, 1.9344346615E+00, 8.7818319594E-01],
	[2.6110000000E+04, 1.6346902756E+01, 5.1481046071E+00, 3.8263034717E+00, 1.9351014878E+00, 8.7824102210E-01],
	[2.6115000000E+04, 1.6351888286E+01, 5.1480585647E+00, 3.8286632938E+00, 1.9357682523E+00, 8.7829882144E-01],
	[2.6120000000E+04, 1.6356874382E+01, 5.1480125314E+00, 3.8310241179E+00, 1.9364349547E+00, 8.7835659395E-01],
	[2.6125000000E+04, 1.6361861044E+01, 5.1479665074E+00, 3.8333859441E+00, 1.9371015950E+00, 8.7841433966E-01],
	[2.6130000000E+04, 1.6366848271E+01, 5.1479204926E+00, 3.8357487729E+00, 1.9377681731E+00, 8.7847205857E-01],
	[2.6135000000E+04, 1.6371836063E+01, 5.1478744870E+00, 3.8381126043E+00, 1.9384346889E+00, 8.7852975070E-01],
	[2.6140000000E+04, 1.6376824421E+01, 5.1478284907E+00, 3.8404774386E+00, 1.9391011424E+00, 8.7858741604E-01],
	[2.6145000000E+04, 1.6381813345E+01, 5.1477825035E+00, 3.8428432760E+00, 1.9397675334E+00, 8.7864505462E-01],
	[2.6150000000E+04, 1.6386802834E+01, 5.1477365256E+00, 3.8452101168E+00, 1.9404338618E+00, 8.7870266644E-01],
	[2.6155000000E+04, 1.6391792888E+01, 5.1476905568E+00, 3.8475779613E+00, 1.9411001275E+00, 8.7876025151E-01],
	[2.6160000000E+04, 1.6396783507E+01, 5.1476445972E+00, 3.8499468095E+00, 1.9417663306E+00, 8.7881780984E-01],
	[2.6165000000E+04, 1.6401774692E+01, 5.1475986469E+00, 3.8523166619E+00, 1.9424324707E+00, 8.7887534144E-01],
	[2.6170000000E+04, 1.6406766442E+01, 5.1475527057E+00, 3.8546875185E+00, 1.9430985480E+00, 8.7893284632E-01],
	[2.6175000000E+04, 1.6411758757E+01, 5.1475067737E+00, 3.8570593797E+00, 1.9437645623E+00, 8.7899032450E-01],
	[2.6180000000E+04, 1.6416751637E+01, 5.1474608509E+00, 3.8594322457E+00, 1.9444305134E+00, 8.7904777597E-01],
	[2.6185000000E+04, 1.6421745082E+01, 5.1474149373E+00, 3.8618061166E+00, 1.9450964013E+00, 8.7910520075E-01],
	[2.6190000000E+04, 1.6426739092E+01, 5.1473690328E+00, 3.8641809928E+00, 1.9457622260E+00, 8.7916259886E-01],
	[2.6195000000E+04, 1.6431733667E+01, 5.1473231376E+00, 3.8665568745E+00, 1.9464279873E+00, 8.7921997029E-01],
	[2.6200000000E+04, 1.6436728807E+01, 5.1472772515E+00, 3.8689337619E+00, 1.9470936851E+00, 8.7927731507E-01],
	[2.6205000000E+04, 1.6441724512E+01, 5.1472313745E+00, 3.8713116552E+00, 1.9477593193E+00, 8.7933463319E-01],
	[2.6210000000E+04, 1.6446720781E+01, 5.1471855067E+00, 3.8736905547E+00, 1.9484248900E+00, 8.7939192467E-01],
	[2.6215000000E+04, 1.6451717616E+01, 5.1471396481E+00, 3.8760704606E+00, 1.9490903968E+00, 8.7944918952E-01],
	[2.6220000000E+04, 1.6456715015E+01, 5.1470937986E+00, 3.8784513731E+00, 1.9497558399E+00, 8.7950642776E-01],
	[2.6225000000E+04, 1.6461712979E+01, 5.1470479583E+00, 3.8808332925E+00, 1.9504212190E+00, 8.7956363938E-01],
	[2.6230000000E+04, 1.6466711508E+01, 5.1470021271E+00, 3.8832162190E+00, 1.9510865341E+00, 8.7962082440E-01],
	[2.6235000000E+04, 1.6471710601E+01, 5.1469563051E+00, 3.8856001528E+00, 1.9517517852E+00, 8.7967798282E-01],
	[2.6240000000E+04, 1.6476710258E+01, 5.1469104922E+00, 3.8879850942E+00, 1.9524169720E+00, 8.7973511467E-01],
	[2.6245000000E+04, 1.6481710481E+01, 5.1468646885E+00, 3.8903710434E+00, 1.9530820946E+00, 8.7979221995E-01],
	[2.6250000000E+04, 1.6486711268E+01, 5.1468188939E+00, 3.8927580006E+00, 1.9537471528E+00, 8.7984929866E-01],
	[2.6255000000E+04, 1.6491712619E+01, 5.1467731084E+00, 3.8951459661E+00, 1.9544121465E+00, 8.7990635083E-01],
	[2.6260000000E+04, 1.6496714534E+01, 5.1467273320E+00, 3.8975349401E+00, 1.9550770757E+00, 8.7996337645E-01],
	[2.6265000000E+04, 1.6501717014E+01, 5.1466815648E+00, 3.8999249228E+00, 1.9557419403E+00, 8.8002037554E-01],
	[2.6270000000E+04, 1.6506720058E+01, 5.1466358066E+00, 3.9023159145E+00, 1.9564067401E+00, 8.8007734810E-01],
	[2.6275000000E+04, 1.6511723667E+01, 5.1465900576E+00, 3.9047079153E+00, 1.9570714752E+00, 8.8013429415E-01],
	[2.6280000000E+04, 1.6516727840E+01, 5.1465443177E+00, 3.9071009256E+00, 1.9577361453E+00, 8.8019121369E-01],
	[2.6285000000E+04, 1.6521732577E+01, 5.1464985869E+00, 3.9094949456E+00, 1.9584007505E+00, 8.8024810673E-01],
	[2.6290000000E+04, 1.6526737878E+01, 5.1464528653E+00, 3.9118899755E+00, 1.9590652905E+00, 8.8030497329E-01],
	[2.6295000000E+04, 1.6531743743E+01, 5.1464071527E+00, 3.9142860155E+00, 1.9597297655E+00, 8.8036181336E-01],
	[2.6300000000E+04, 1.6536750172E+01, 5.1463614492E+00, 3.9166830658E+00, 1.9603941751E+00, 8.8041862696E-01],
	[2.6305000000E+04, 1.6541757165E+01, 5.1463157548E+00, 3.9190811268E+00, 1.9610585194E+00, 8.8047541410E-01],
	[2.6310000000E+04, 1.6546764722E+01, 5.1462700695E+00, 3.9214801986E+00, 1.9617227983E+00, 8.8053217479E-01],
	[2.6315000000E+04, 1.6551772843E+01, 5.1462243933E+00, 3.9238802814E+00, 1.9623870117E+00, 8.8058890903E-01],
	[2.6320000000E+04, 1.6556781528E+01, 5.1461787262E+00, 3.9262813755E+00, 1.9630511594E+00, 8.8064561684E-01],
	[2.6325000000E+04, 1.6561809802E+01, 5.1461362777E+00, 3.9286834812E+00, 1.9637159763E+00, 8.8070229821E-01],
	[2.6330000000E+04, 1.6566841333E+01, 5.1460942904E+00, 3.9310865986E+00, 1.9643808318E+00, 8.8075895317E-01],
	[2.6335000000E+04, 1.6571873437E+01, 5.1460523115E+00, 3.9334907280E+00, 1.9650456223E+00, 8.8081558172E-01],
	[2.6340000000E+04, 1.6576906113E+01, 5.1460103409E+00, 3.9358958697E+00, 1.9657103475E+00, 8.8087218387E-01],
	[2.6345000000E+04, 1.6581939362E+01, 5.1459683785E+00, 3.9383020238E+00, 1.9663750076E+00, 8.8092875963E-01],
	[2.6350000000E+04, 1.6586973183E+01, 5.1459264245E+00, 3.9407091906E+00, 1.9670396023E+00, 8.8098530901E-01],
	[2.6355000000E+04, 1.6592007578E+01, 5.1458844788E+00, 3.9431173703E+00, 1.9677041316E+00, 8.8104183201E-01],
	[2.6360000000E+04, 1.6597042544E+01, 5.1458425413E+00, 3.9455265632E+00, 1.9683685953E+00, 8.8109832865E-01],
	[2.6365000000E+04, 1.6602078084E+01, 5.1458006122E+00, 3.9479367695E+00, 1.9690329935E+00, 8.8115479893E-01],
	[2.6370000000E+04, 1.6607114195E+01, 5.1457586914E+00, 3.9503479894E+00, 1.9696973259E+00, 8.8121124286E-01],
	[2.6375000000E+04, 1.6612150880E+01, 5.1457167788E+00, 3.9527602231E+00, 1.9703615926E+00, 8.8126766046E-01],
	[2.6380000000E+04, 1.6617188136E+01, 5.1456748746E+00, 3.9551734710E+00, 1.9710257935E+00, 8.8132405172E-01],
	[2.6385000000E+04, 1.6622225965E+01, 5.1456329786E+00, 3.9575877332E+00, 1.9716899283E+00, 8.8138041667E-01],
	[2.6390000000E+04, 1.6627264366E+01, 5.1455910909E+00, 3.9600030099E+00, 1.9723539972E+00, 8.8143675530E-01],
	[2.6395000000E+04, 1.6632303340E+01, 5.1455492115E+00, 3.9624193014E+00, 1.9730179999E+00, 8.8149306764E-01],
	[2.6400000000E+04, 1.6637342885E+01, 5.1455073403E+00, 3.9648366080E+00, 1.9736819364E+00, 8.8154935368E-01],
	[2.6405000000E+04, 1.6642383003E+01, 5.1454654775E+00, 3.9672549298E+00, 1.9743458066E+00, 8.8160561343E-01],
	[2.6410000000E+04, 1.6647423693E+01, 5.1454236228E+00, 3.9696742671E+00, 1.9750096104E+00, 8.8166184692E-01],
	[2.6415000000E+04, 1.6652464955E+01, 5.1453817765E+00, 3.9720946201E+00, 1.9756733478E+00, 8.8171805413E-01],
	[2.6420000000E+04, 1.6657506789E+01, 5.1453399384E+00, 3.9745159891E+00, 1.9763370186E+00, 8.8177423509E-01],
	[2.6425000000E+04, 1.6662549195E+01, 5.1452981086E+00, 3.9769383743E+00, 1.9770006227E+00, 8.8183038980E-01],
	[2.6430000000E+04, 1.6667592173E+01, 5.1452562870E+00, 3.9793617759E+00, 1.9776641601E+00, 8.8188651827E-01],
	[2.6435000000E+04, 1.6672635723E+01, 5.1452144737E+00, 3.9817861941E+00, 1.9783276307E+00, 8.8194262051E-01],
	[2.6440000000E+04, 1.6677679845E+01, 5.1451726686E+00, 3.9842116293E+00, 1.9789910344E+00, 8.8199869653E-01],
	[2.6445000000E+04, 1.6682724539E+01, 5.1451308718E+00, 3.9866380815E+00, 1.9796543711E+00, 8.8205474634E-01],
	[2.6450000000E+04, 1.6687769804E+01, 5.1450890832E+00, 3.9890655512E+00, 1.9803176407E+00, 8.8211076994E-01],
	[2.6455000000E+04, 1.6692815641E+01, 5.1450473028E+00, 3.9914940384E+00, 1.9809808431E+00, 8.8216676735E-01],
	[2.6460000000E+04, 1.6697862050E+01, 5.1450055307E+00, 3.9939235434E+00, 1.9816439783E+00, 8.8222273858E-01],
	[2.6465000000E+04, 1.6702909030E+01, 5.1449637668E+00, 3.9963540665E+00, 1.9823070462E+00, 8.8227868363E-01],
	[2.6470000000E+04, 1.6707956582E+01, 5.1449220112E+00, 3.9987856079E+00, 1.9829700466E+00, 8.8233460252E-01],
	[2.6475000000E+04, 1.6713004706E+01, 5.1448802637E+00, 4.0012181678E+00, 1.9836329795E+00, 8.8239049524E-01],
	[2.6480000000E+04, 1.6718053401E+01, 5.1448385245E+00, 4.0036517465E+00, 1.9842958448E+00, 8.8244636182E-01],
	[2.6485000000E+04, 1.6723102668E+01, 5.1447967935E+00, 4.0060863442E+00, 1.9849586424E+00, 8.8250220226E-01],
	[2.6490000000E+04, 1.6728152506E+01, 5.1447550707E+00, 4.0085219611E+00, 1.9856213723E+00, 8.8255801657E-01],
	[2.6495000000E+04, 1.6733202915E+01, 5.1447133562E+00, 4.0109585974E+00, 1.9862840343E+00, 8.8261380476E-01],
	[2.6500000000E+04, 1.6738253896E+01, 5.1446716498E+00, 4.0133962534E+00, 1.9869466284E+00, 8.8266956684E-01],
	[2.6505000000E+04, 1.6743305448E+01, 5.1446299517E+00, 4.0158349294E+00, 1.9876091545E+00, 8.8272530281E-01],
	[2.6510000000E+04, 1.6748357571E+01, 5.1445882617E+00, 4.0182746255E+00, 1.9882716124E+00, 8.8278101269E-01],
	[2.6515000000E+04, 1.6753410266E+01, 5.1445465800E+00, 4.0207153420E+00, 1.9889340021E+00, 8.8283669649E-01],
	[2.6520000000E+04, 1.6758463531E+01, 5.1445049064E+00, 4.0231570792E+00, 1.9895963236E+00, 8.8289235421E-01],
	[2.6525000000E+04, 1.6763517368E+01, 5.1444632411E+00, 4.0255998371E+00, 1.9902585767E+00, 8.8294798587E-01],
	[2.6530000000E+04, 1.6768571776E+01, 5.1444215839E+00, 4.0280436162E+00, 1.9909207613E+00, 8.8300359147E-01],
	[2.6535000000E+04, 1.6773626755E+01, 5.1443799349E+00, 4.0304884166E+00, 1.9915828774E+00, 8.8305917102E-01],
	[2.6540000000E+04, 1.6778682305E+01, 5.1443382942E+00, 4.0329342386E+00, 1.9922449249E+00, 8.8311472453E-01],
	[2.6545000000E+04, 1.6783738426E+01, 5.1442966615E+00, 4.0353810824E+00, 1.9929069037E+00, 8.8317025202E-01],
	[2.6550000000E+04, 1.6788795118E+01, 5.1442550371E+00, 4.0378289481E+00, 1.9935688137E+00, 8.8322575348E-01],
	[2.6555000000E+04, 1.6793852380E+01, 5.1442134209E+00, 4.0402778362E+00, 1.9942306548E+00, 8.8328122893E-01],
	[2.6560000000E+04, 1.6798910214E+01, 5.1441718128E+00, 4.0427277467E+00, 1.9948924270E+00, 8.8333667838E-01],
	[2.6565000000E+04, 1.6803968618E+01, 5.1441302129E+00, 4.0451786800E+00, 1.9955541301E+00, 8.8339210184E-01],
	[2.6570000000E+04, 1.6809027593E+01, 5.1440886211E+00, 4.0476306362E+00, 1.9962157640E+00, 8.8344749932E-01],
	[2.6575000000E+04, 1.6814087139E+01, 5.1440470375E+00, 4.0500836156E+00, 1.9968773288E+00, 8.8350287082E-01],
	[2.6580000000E+04, 1.6819147255E+01, 5.1440054621E+00, 4.0525376184E+00, 1.9975388243E+00, 8.8355821636E-01],
	[2.6585000000E+04, 1.6824207942E+01, 5.1439638948E+00, 4.0549926449E+00, 1.9982002503E+00, 8.8361353594E-01],
	[2.6590000000E+04, 1.6829269200E+01, 5.1439223357E+00, 4.0574486953E+00, 1.9988616069E+00, 8.8366882958E-01],
	[2.6595000000E+04, 1.6834331028E+01, 5.1438807847E+00, 4.0599057698E+00, 1.9995228940E+00, 8.8372409728E-01],
	[2.6600000000E+04, 1.6839393427E+01, 5.1438392419E+00, 4.0623638687E+00, 2.0001841114E+00, 8.8377933905E-01],
	[2.6605000000E+04, 1.6844456396E+01, 5.1437977072E+00, 4.0648229922E+00, 2.0008452591E+00, 8.8383455490E-01],
	[2.6610000000E+04, 1.6849519935E+01, 5.1437561807E+00, 4.0672831405E+00, 2.0015063370E+00, 8.8388974485E-01],
	[2.6615000000E+04, 1.6854584045E+01, 5.1437146623E+00, 4.0697443139E+00, 2.0021673450E+00, 8.8394490889E-01],
	[2.6620000000E+04, 1.6859648725E+01, 5.1436731520E+00, 4.0722065125E+00, 2.0028282831E+00, 8.8400004705E-01],
	[2.6625000000E+04, 1.6864713975E+01, 5.1436316499E+00, 4.0746697367E+00, 2.0034891510E+00, 8.8405515932E-01],
	[2.6630000000E+04, 1.6869779796E+01, 5.1435901558E+00, 4.0771339867E+00, 2.0041499489E+00, 8.8411024572E-01],
	[2.6635000000E+04, 1.6874846187E+01, 5.1435486700E+00, 4.0795992626E+00, 2.0048106765E+00, 8.8416530626E-01],
	[2.6640000000E+04, 1.6879913148E+01, 5.1435071922E+00, 4.0820655648E+00, 2.0054713338E+00, 8.8422034094E-01],
	[2.6645000000E+04, 1.6884980679E+01, 5.1434657225E+00, 4.0845328934E+00, 2.0061319207E+00, 8.8427534979E-01],
	[2.6650000000E+04, 1.6890048780E+01, 5.1434242610E+00, 4.0870012487E+00, 2.0067924372E+00, 8.8433033279E-01],
	[2.6655000000E+04, 1.6895117451E+01, 5.1433828076E+00, 4.0894706310E+00, 2.0074528831E+00, 8.8438528998E-01],
	[2.6660000000E+04, 1.6900186692E+01, 5.1433413623E+00, 4.0919410404E+00, 2.0081132583E+00, 8.8444022134E-01],
	[2.6665000000E+04, 1.6905256503E+01, 5.1432999251E+00, 4.0944124773E+00, 2.0087735629E+00, 8.8449512690E-01],
	[2.6670000000E+04, 1.6910326884E+01, 5.1432584960E+00, 4.0968849417E+00, 2.0094337966E+00, 8.8455000667E-01],
	[2.6675000000E+04, 1.6915397834E+01, 5.1432170750E+00, 4.0993584340E+00, 2.0100939594E+00, 8.8460486064E-01],
	[2.6680000000E+04, 1.6920469355E+01, 5.1431756621E+00, 4.1018329545E+00, 2.0107540513E+00, 8.8465968884E-01],
	[2.6685000000E+04, 1.6925541445E+01, 5.1431342573E+00, 4.1043085032E+00, 2.0114140721E+00, 8.8471449127E-01],
	[2.6690000000E+04, 1.6930614105E+01, 5.1430928606E+00, 4.1067850805E+00, 2.0120740218E+00, 8.8476926794E-01],
	[2.6695000000E+04, 1.6935687334E+01, 5.1430514719E+00, 4.1092626867E+00, 2.0127339002E+00, 8.8482401885E-01],
	[2.6700000000E+04, 1.6940761134E+01, 5.1430100914E+00, 4.1117413218E+00, 2.0133937074E+00, 8.8487874403E-01],
	[2.6705000000E+04, 1.6945835502E+01, 5.1429687189E+00, 4.1142209862E+00, 2.0140534431E+00, 8.8493344348E-01],
	[2.6710000000E+04, 1.6950910441E+01, 5.1429273545E+00, 4.1167016802E+00, 2.0147131074E+00, 8.8498811720E-01],
	[2.6715000000E+04, 1.6955985949E+01, 5.1428859982E+00, 4.1191834038E+00, 2.0153727002E+00, 8.8504276521E-01],
	[2.6720000000E+04, 1.6961062026E+01, 5.1428446500E+00, 4.1216661575E+00, 2.0160322213E+00, 8.8509738752E-01],
	[2.6725000000E+04, 1.6966138673E+01, 5.1428033098E+00, 4.1241499413E+00, 2.0166916707E+00, 8.8515198414E-01],
	[2.6730000000E+04, 1.6971215889E+01, 5.1427619777E+00, 4.1266347556E+00, 2.0173510483E+00, 8.8520655507E-01],
	[2.6735000000E+04, 1.6976293674E+01, 5.1427206536E+00, 4.1291206005E+00, 2.0180103540E+00, 8.8526110032E-01],
	[2.6740000000E+04, 1.6981372029E+01, 5.1426793377E+00, 4.1316074763E+00, 2.0186695878E+00, 8.8531561991E-01],
	[2.6745000000E+04, 1.6986453789E+01, 5.1426385017E+00, 4.1340953833E+00, 2.0193288624E+00, 8.8537011385E-01],
	[2.6750000000E+04, 1.6991554916E+01, 5.1426008004E+00, 4.1365843217E+00, 2.0199888130E+00, 8.8542458214E-01],
	[2.6755000000E+04, 1.6996656621E+01, 5.1425631064E+00, 4.1390742916E+00, 2.0206486922E+00, 8.8547902479E-01],
	[2.6760000000E+04, 1.7001758904E+01, 5.1425254198E+00, 4.1415652934E+00, 2.0213084999E+00, 8.8553344181E-01],
	[2.6765000000E+04, 1.7006861765E+01, 5.1424877404E+00, 4.1440573273E+00, 2.0219682360E+00, 8.8558783322E-01],
	[2.6770000000E+04, 1.7011965204E+01, 5.1424500684E+00, 4.1465503935E+00, 2.0226279005E+00, 8.8564219902E-01],
	[2.6775000000E+04, 1.7017069221E+01, 5.1424124037E+00, 4.1490444922E+00, 2.0232874932E+00, 8.8569653921E-01],
	[2.6780000000E+04, 1.7022173816E+01, 5.1423747463E+00, 4.1515396237E+00, 2.0239470141E+00, 8.8575085382E-01],
	[2.6785000000E+04, 1.7027278988E+01, 5.1423370962E+00, 4.1540357882E+00, 2.0246064631E+00, 8.8580514285E-01],
	[2.6790000000E+04, 1.7032384739E+01, 5.1422994534E+00, 4.1565329860E+00, 2.0252658401E+00, 8.8585940631E-01],
	[2.6795000000E+04, 1.7037491067E+01, 5.1422618179E+00, 4.1590312172E+00, 2.0259251450E+00, 8.8591364421E-01],
	[2.6800000000E+04, 1.7042597972E+01, 5.1422241897E+00, 4.1615304821E+00, 2.0265843778E+00, 8.8596785655E-01],
	[2.6805000000E+04, 1.7047705456E+01, 5.1421865687E+00, 4.1640307810E+00, 2.0272435383E+00, 8.8602204335E-01],
	[2.6810000000E+04, 1.7052813517E+01, 5.1421489551E+00, 4.1665321141E+00, 2.0279026265E+00, 8.8607620462E-01],
	[2.6815000000E+04, 1.7057922155E+01, 5.1421113488E+00, 4.1690344815E+00, 2.0285616424E+00, 8.8613034037E-01],
	[2.6820000000E+04, 1.7063031372E+01, 5.1420737498E+00, 4.1715378836E+00, 2.0292205857E+00, 8.8618445061E-01],
	[2.6825000000E+04, 1.7068141165E+01, 5.1420361580E+00, 4.1740423206E+00, 2.0298794566E+00, 8.8623853534E-01],
	[2.6830000000E+04, 1.7073251536E+01, 5.1419985735E+00, 4.1765477928E+00, 2.0305382547E+00, 8.8629259457E-01],
	[2.6835000000E+04, 1.7078362485E+01, 5.1419609963E+00, 4.1790543002E+00, 2.0311969802E+00, 8.8634662832E-01],
	[2.6840000000E+04, 1.7083474010E+01, 5.1419234264E+00, 4.1815618433E+00, 2.0318556329E+00, 8.8640063660E-01],
	[2.6845000000E+04, 1.7088586113E+01, 5.1418858638E+00, 4.1840704221E+00, 2.0325142126E+00, 8.8645461941E-01],
	[2.6850000000E+04, 1.7093698794E+01, 5.1418483084E+00, 4.1865800370E+00, 2.0331727195E+00, 8.8650857676E-01],
	[2.6855000000E+04, 1.7098812051E+01, 5.1418107603E+00, 4.1890906882E+00, 2.0338311533E+00, 8.8656250867E-01],
	[2.6860000000E+04, 1.7103925886E+01, 5.1417732194E+00, 4.1916023760E+00, 2.0344895139E+00, 8.8661641514E-01],
	[2.6865000000E+04, 1.7109040298E+01, 5.1417356858E+00, 4.1941151004E+00, 2.0351478014E+00, 8.8667029619E-01],
	[2.6870000000E+04, 1.7114155287E+01, 5.1416981595E+00, 4.1966288619E+00, 2.0358060156E+00, 8.8672415181E-01],
	[2.6875000000E+04, 1.7119270853E+01, 5.1416606405E+00, 4.1991436606E+00, 2.0364641565E+00, 8.8677798203E-01],
	[2.6880000000E+04, 1.7124386996E+01, 5.1416231286E+00, 4.2016594967E+00, 2.0371222239E+00, 8.8683178685E-01],
	[2.6885000000E+04, 1.7129503716E+01, 5.1415856241E+00, 4.2041763705E+00, 2.0377802177E+00, 8.8688556628E-01],
	[2.6890000000E+04, 1.7134621013E+01, 5.1415481267E+00, 4.2066942823E+00, 2.0384381380E+00, 8.8693932033E-01],
	[2.6895000000E+04, 1.7139738887E+01, 5.1415106367E+00, 4.2092132322E+00, 2.0390959846E+00, 8.8699304901E-01],
	[2.6900000000E+04, 1.7144857338E+01, 5.1414731538E+00, 4.2117332205E+00, 2.0397537575E+00, 8.8704675233E-01],
	[2.6905000000E+04, 1.7149976365E+01, 5.1414356783E+00, 4.2142542474E+00, 2.0404114565E+00, 8.8710043030E-01],
	[2.6910000000E+04, 1.7155095969E+01, 5.1413982099E+00, 4.2167763131E+00, 2.0410690816E+00, 8.8715408293E-01],
	[2.6915000000E+04, 1.7160216150E+01, 5.1413607488E+00, 4.2192994180E+00, 2.0417266327E+00, 8.8720771023E-01],
	[2.6920000000E+04, 1.7165336908E+01, 5.1413232949E+00, 4.2218235622E+00, 2.0423841098E+00, 8.8726131220E-01],
	[2.6925000000E+04, 1.7170458242E+01, 5.1412858482E+00, 4.2243487460E+00, 2.0430415126E+00, 8.8731488887E-01],
	[2.6930000000E+04, 1.7175580153E+01, 5.1412484088E+00, 4.2268749695E+00, 2.0436988413E+00, 8.8736844023E-01],
	[2.6935000000E+04, 1.7180702641E+01, 5.1412109766E+00, 4.2294022331E+00, 2.0443560956E+00, 8.8742196630E-01],
	[2.6940000000E+04, 1.7185825705E+01, 5.1411735516E+00, 4.2319305370E+00, 2.0450132756E+00, 8.8747546709E-01],
	[2.6945000000E+04, 1.7190949345E+01, 5.1411361338E+00, 4.2344598813E+00, 2.0456703810E+00, 8.8752894260E-01],
	[2.6950000000E+04, 1.7196073562E+01, 5.1410987233E+00, 4.2369902664E+00, 2.0463274119E+00, 8.8758239285E-01],
	[2.6955000000E+04, 1.7201198355E+01, 5.1410613199E+00, 4.2395216925E+00, 2.0469843682E+00, 8.8763581784E-01],
	[2.6960000000E+04, 1.7206323725E+01, 5.1410239238E+00, 4.2420541597E+00, 2.0476412498E+00, 8.8768921760E-01],
	[2.6965000000E+04, 1.7211449671E+01, 5.1409865348E+00, 4.2445876684E+00, 2.0482980566E+00, 8.8774259211E-01],
	[2.6970000000E+04, 1.7216576193E+01, 5.1409491531E+00, 4.2471222188E+00, 2.0489547886E+00, 8.8779594141E-01],
	[2.6975000000E+04, 1.7221703291E+01, 5.1409117786E+00, 4.2496578110E+00, 2.0496114456E+00, 8.8784926548E-01],
	[2.6980000000E+04, 1.7226830966E+01, 5.1408744113E+00, 4.2521944454E+00, 2.0502680276E+00, 8.8790256435E-01],
	[2.6985000000E+04, 1.7231959216E+01, 5.1408370511E+00, 4.2547321222E+00, 2.0509245344E+00, 8.8795583803E-01],
	[2.6990000000E+04, 1.7237088043E+01, 5.1407996982E+00, 4.2572708416E+00, 2.0515809661E+00, 8.8800908652E-01],
	[2.6995000000E+04, 1.7242217446E+01, 5.1407623525E+00, 4.2598106038E+00, 2.0522373226E+00, 8.8806230983E-01],
	[2.7000000000E+04, 1.7247347425E+01, 5.1407250139E+00, 4.2623514091E+00, 2.0528936037E+00, 8.8811550798E-01],
	[2.7005000000E+04, 1.7252477979E+01, 5.1406876825E+00, 4.2648932577E+00, 2.0535498094E+00, 8.8816868097E-01],
	[2.7010000000E+04, 1.7257609110E+01, 5.1406503583E+00, 4.2674361499E+00, 2.0542059396E+00, 8.8822182881E-01],
	[2.7015000000E+04, 1.7262740816E+01, 5.1406130413E+00, 4.2699800858E+00, 2.0548619943E+00, 8.8827495152E-01],
	[2.7020000000E+04, 1.7267873099E+01, 5.1405757315E+00, 4.2725250657E+00, 2.0555179732E+00, 8.8832804909E-01],
	[2.7025000000E+04, 1.7273005957E+01, 5.1405384288E+00, 4.2750710899E+00, 2.0561738765E+00, 8.8838112155E-01],
	[2.7030000000E+04, 1.7278139391E+01, 5.1405011333E+00, 4.2776181586E+00, 2.0568297040E+00, 8.8843416890E-01],
	[2.7035000000E+04, 1.7283273400E+01, 5.1404638450E+00, 4.2801662720E+00, 2.0574854556E+00, 8.8848719116E-01],
	[2.7040000000E+04, 1.7288407986E+01, 5.1404265639E+00, 4.2827154303E+00, 2.0581411312E+00, 8.8854018832E-01],
	[2.7045000000E+04, 1.7293543147E+01, 5.1403892899E+00, 4.2852656338E+00, 2.0587967309E+00, 8.8859316041E-01],
	[2.7050000000E+04, 1.7298678883E+01, 5.1403520230E+00, 4.2878168828E+00, 2.0594522543E+00, 8.8864610742E-01],
	[2.7055000000E+04, 1.7303815195E+01, 5.1403147634E+00, 4.2903691774E+00, 2.0601077017E+00, 8.8869902938E-01],
	[2.7060000000E+04, 1.7308952083E+01, 5.1402775109E+00, 4.2929225178E+00, 2.0607630727E+00, 8.8875192628E-01],
	[2.7065000000E+04, 1.7314089546E+01, 5.1402402655E+00, 4.2954769044E+00, 2.0614183674E+00, 8.8880479815E-01],
	[2.7070000000E+04, 1.7319227584E+01, 5.1402030273E+00, 4.2980323374E+00, 2.0620735857E+00, 8.8885764499E-01],
	[2.7075000000E+04, 1.7324366198E+01, 5.1401657962E+00, 4.3005888169E+00, 2.0627287275E+00, 8.8891046680E-01],
	[2.7080000000E+04, 1.7329505387E+01, 5.1401285723E+00, 4.3031463433E+00, 2.0633837927E+00, 8.8896326361E-01],
	[2.7085000000E+04, 1.7334645151E+01, 5.1400913555E+00, 4.3057049167E+00, 2.0640387813E+00, 8.8901603542E-01],
	[2.7090000000E+04, 1.7339785491E+01, 5.1400541459E+00, 4.3082645375E+00, 2.0646936931E+00, 8.8906878223E-01],
	[2.7095000000E+04, 1.7344926406E+01, 5.1400169434E+00, 4.3108252057E+00, 2.0653485281E+00, 8.8912150406E-01],
	[2.7100000000E+04, 1.7350067896E+01, 5.1399797480E+00, 4.3133869217E+00, 2.0660032863E+00, 8.8917420093E-01],
	[2.7105000000E+04, 1.7355209961E+01, 5.1399425597E+00, 4.3159496858E+00, 2.0666579675E+00, 8.8922687283E-01],
	[2.7110000000E+04, 1.7360352601E+01, 5.1399053786E+00, 4.3185134980E+00, 2.0673125717E+00, 8.8927951977E-01],
	[2.7115000000E+04, 1.7365495817E+01, 5.1398682046E+00, 4.3210783587E+00, 2.0679670987E+00, 8.8933214178E-01],
	[2.7120000000E+04, 1.7370639607E+01, 5.1398310378E+00, 4.3236442681E+00, 2.0686215486E+00, 8.8938473886E-01],
	[2.7125000000E+04, 1.7375783972E+01, 5.1397938780E+00, 4.3262112265E+00, 2.0692759212E+00, 8.8943731101E-01],
	[2.7130000000E+04, 1.7380928912E+01, 5.1397567254E+00, 4.3287792340E+00, 2.0699302165E+00, 8.8948985825E-01],
	[2.7135000000E+04, 1.7386074427E+01, 5.1397195799E+00, 4.3313482909E+00, 2.0705844343E+00, 8.8954238059E-01],
	[2.7140000000E+04, 1.7391220517E+01, 5.1396824415E+00, 4.3339183975E+00, 2.0712385747E+00, 8.8959487803E-01],
	[2.7145000000E+04, 1.7396367182E+01, 5.1396453102E+00, 4.3364895539E+00, 2.0718926375E+00, 8.8964735060E-01],
	[2.7150000000E+04, 1.7401514421E+01, 5.1396081860E+00, 4.3390617605E+00, 2.0725466226E+00, 8.8969979829E-01],
	[2.7155000000E+04, 1.7406662235E+01, 5.1395710690E+00, 4.3416350174E+00, 2.0732005301E+00, 8.8975222111E-01],
	[2.7160000000E+04, 1.7411810624E+01, 5.1395339590E+00, 4.3442093248E+00, 2.0738543597E+00, 8.8980461909E-01],
	[2.7165000000E+04, 1.7416959587E+01, 5.1394968561E+00, 4.3467846831E+00, 2.0745081115E+00, 8.8985699222E-01],
	[2.7170000000E+04, 1.7422109125E+01, 5.1394597603E+00, 4.3493610924E+00, 2.0751617853E+00, 8.8990934051E-01],
	[2.7175000000E+04, 1.7427259704E+01, 5.1394227481E+00, 4.3519385530E+00, 2.0758154002E+00, 8.8996166398E-01],
	[2.7180000000E+04, 1.7432431945E+01, 5.1393892028E+00, 4.3545170652E+00, 2.0764698010E+00, 8.9001396264E-01],
	[2.7185000000E+04, 1.7437604769E+01, 5.1393556639E+00, 4.3570966290E+00, 2.0771241245E+00, 8.9006623650E-01],
	[2.7190000000E+04, 1.7442778176E+01, 5.1393221313E+00, 4.3596772449E+00, 2.0777783704E+00, 8.9011848556E-01],
	[2.7195000000E+04, 1.7447952167E+01, 5.1392886051E+00, 4.3622589130E+00, 2.0784325388E+00, 8.9017070984E-01],
	[2.7200000000E+04, 1.7453126741E+01, 5.1392550853E+00, 4.3648416335E+00, 2.0790866296E+00, 8.9022290934E-01],
	[2.7205000000E+04, 1.7458301898E+01, 5.1392215719E+00, 4.3674254067E+00, 2.0797406426E+00, 8.9027508408E-01],
	[2.7210000000E+04, 1.7463477637E+01, 5.1391880649E+00, 4.3700102328E+00, 2.0803945779E+00, 8.9032723406E-01],
	[2.7215000000E+04, 1.7468653960E+01, 5.1391545642E+00, 4.3725961121E+00, 2.0810484354E+00, 8.9037935930E-01],
	[2.7220000000E+04, 1.7473830866E+01, 5.1391210699E+00, 4.3751830448E+00, 2.0817022150E+00, 8.9043145980E-01],
	[2.7225000000E+04, 1.7479008355E+01, 5.1390875820E+00, 4.3777710312E+00, 2.0823559165E+00, 8.9048353558E-01],
	[2.7230000000E+04, 1.7484186426E+01, 5.1390541005E+00, 4.3803600713E+00, 2.0830095400E+00, 8.9053558665E-01],
	[2.7235000000E+04, 1.7489365081E+01, 5.1390206253E+00, 4.3829501656E+00, 2.0836630853E+00, 8.9058761301E-01],
	[2.7240000000E+04, 1.7494544318E+01, 5.1389871564E+00, 4.3855413142E+00, 2.0843165524E+00, 8.9063961467E-01],
	[2.7245000000E+04, 1.7499724138E+01, 5.1389536940E+00, 4.3881335174E+00, 2.0849699413E+00, 8.9069159165E-01],
	[2.7250000000E+04, 1.7504904541E+01, 5.1389202379E+00, 4.3907267754E+00, 2.0856232517E+00, 8.9074354396E-01],
	[2.7255000000E+04, 1.7510085526E+01, 5.1388867881E+00, 4.3933210884E+00, 2.0862764837E+00, 8.9079547160E-01],
	[2.7260000000E+04, 1.7515267094E+01, 5.1388533447E+00, 4.3959164567E+00, 2.0869296372E+00, 8.9084737458E-01],
	[2.7265000000E+04, 1.7520449245E+01, 5.1388199077E+00, 4.3985128805E+00, 2.0875827121E+00, 8.9089925291E-01],
	[2.7270000000E+04, 1.7525631978E+01, 5.1387864770E+00, 4.4011103600E+00, 2.0882357084E+00, 8.9095110661E-01],
	[2.7275000000E+04, 1.7530815294E+01, 5.1387530527E+00, 4.4037088955E+00, 2.0888886259E+00, 8.9100293567E-01],
	[2.7280000000E+04, 1.7535999192E+01, 5.1387196347E+00, 4.4063084872E+00, 2.0895414645E+00, 8.9105474011E-01],
	[2.7285000000E+04, 1.7541183672E+01, 5.1386862230E+00, 4.4089091354E+00, 2.0901942243E+00, 8.9110651994E-01],
	[2.7290000000E+04, 1.7546368735E+01, 5.1386528177E+00, 4.4115108402E+00, 2.0908469052E+00, 8.9115827516E-01],
	[2.7295000000E+04, 1.7551554381E+01, 5.1386194187E+00, 4.4141136019E+00, 2.0914995070E+00, 8.9121000579E-01],
	[2.7300000000E+04, 1.7556740608E+01, 5.1385860260E+00, 4.4167174208E+00, 2.0921520297E+00, 8.9126171184E-01],
	[2.7305000000E+04, 1.7561927418E+01, 5.1385526397E+00, 4.4193222971E+00, 2.0928044732E+00, 8.9131339330E-01],
	[2.7310000000E+04, 1.7567114810E+01, 5.1385192597E+00, 4.4219282310E+00, 2.0934568375E+00, 8.9136505020E-01],
	[2.7315000000E+04, 1.7572302785E+01, 5.1384858861E+00, 4.4245352228E+00, 2.0941091224E+00, 8.9141668254E-01],
	[2.7320000000E+04, 1.7577491341E+01, 5.1384525187E+00, 4.4271432726E+00, 2.0947613279E+00, 8.9146829033E-01],
	[2.7325000000E+04, 1.7582680479E+01, 5.1384191577E+00, 4.4297523808E+00, 2.0954134540E+00, 8.9151987359E-01],
	[2.7330000000E+04, 1.7587870200E+01, 5.1383858030E+00, 4.4323625475E+00, 2.0960655005E+00, 8.9157143230E-01],
	[2.7335000000E+04, 1.7593060503E+01, 5.1383524546E+00, 4.4349737730E+00, 2.0967174674E+00, 8.9162296650E-01],
	[2.7340000000E+04, 1.7598251387E+01, 5.1383191126E+00, 4.4375860576E+00, 2.0973693545E+00, 8.9167447618E-01],
	[2.7345000000E+04, 1.7603442854E+01, 5.1382857768E+00, 4.4401994014E+00, 2.0980211620E+00, 8.9172596136E-01],
	[2.7350000000E+04, 1.7608634902E+01, 5.1382524474E+00, 4.4428138047E+00, 2.0986728895E+00, 8.9177742204E-01],
	[2.7355000000E+04, 1.7613827532E+01, 5.1382191243E+00, 4.4454292677E+00, 2.0993245372E+00, 8.9182885824E-01],
	[2.7360000000E+04, 1.7619020744E+01, 5.1381858075E+00, 4.4480457907E+00, 2.0999761049E+00, 8.9188026995E-01],
	[2.7365000000E+04, 1.7624214538E+01, 5.1381524969E+00, 4.4506633739E+00, 2.1006275925E+00, 8.9193165720E-01],
	[2.7370000000E+04, 1.7629408914E+01, 5.1381191927E+00, 4.4532820176E+00, 2.1012790000E+00, 8.9198301999E-01],
	[2.7375000000E+04, 1.7634603871E+01, 5.1380858948E+00, 4.4559017219E+00, 2.1019303272E+00, 8.9203435833E-01],
	[2.7380000000E+04, 1.7639799410E+01, 5.1380526032E+00, 4.4585224871E+00, 2.1025815742E+00, 8.9208567223E-01],
	[2.7385000000E+04, 1.7644995530E+01, 5.1380193179E+00, 4.4611443135E+00, 2.1032327409E+00, 8.9213696170E-01],
	[2.7390000000E+04, 1.7650192232E+01, 5.1379860388E+00, 4.4637675664E+00, 2.1038839082E+00, 8.9218822674E-01],
	[2.7395000000E+04, 1.7655389516E+01, 5.1379527661E+00, 4.4663919843E+00, 2.1045350180E+00, 8.9223946737E-01],
	[2.7400000000E+04, 1.7660587381E+01, 5.1379194997E+00, 4.4690174646E+00, 2.1051860471E+00, 8.9229068359E-01],
	[2.7405000000E+04, 1.7665785827E+01, 5.1378862395E+00, 4.4716440074E+00, 2.1058369956E+00, 8.9234187542E-01],
	[2.7410000000E+04, 1.7670984855E+01, 5.1378529856E+00, 4.4742716131E+00, 2.1064878634E+00, 8.9239304286E-01],
	[2.7415000000E+04, 1.7676184464E+01, 5.1378197380E+00, 4.4769002817E+00, 2.1071386504E+00, 8.9244418593E-01],
	[2.7420000000E+04, 1.7681384655E+01, 5.1377864967E+00, 4.4795300137E+00, 2.1077893565E+00, 8.9249530462E-01],
	[2.7425000000E+04, 1.7686585427E+01, 5.1377532616E+00, 4.4821608092E+00, 2.1084399817E+00, 8.9254639896E-01],
	[2.7430000000E+04, 1.7691786780E+01, 5.1377200328E+00, 4.4847926684E+00, 2.1090905259E+00, 8.9259746894E-01],
	[2.7435000000E+04, 1.7696988714E+01, 5.1376868103E+00, 4.4874255916E+00, 2.1097409890E+00, 8.9264851459E-01],
	[2.7440000000E+04, 1.7702191229E+01, 5.1376535941E+00, 4.4900595790E+00, 2.1103913710E+00, 8.9269953590E-01],
	[2.7445000000E+04, 1.7707394326E+01, 5.1376203841E+00, 4.4926946309E+00, 2.1110416717E+00, 8.9275053289E-01],
	[2.7450000000E+04, 1.7712598003E+01, 5.1375871804E+00, 4.4953307475E+00, 2.1116918912E+00, 8.9280150557E-01],
	[2.7455000000E+04, 1.7717802262E+01, 5.1375539830E+00, 4.4979679290E+00, 2.1123420293E+00, 8.9285245394E-01],
	[2.7460000000E+04, 1.7723007101E+01, 5.1375207918E+00, 4.5006061756E+00, 2.1129920859E+00, 8.9290337802E-01],
	[2.7465000000E+04, 1.7728212522E+01, 5.1374876069E+00, 4.5032454876E+00, 2.1136420610E+00, 8.9295427781E-01],
	[2.7470000000E+04, 1.7733418523E+01, 5.1374544282E+00, 4.5058858653E+00, 2.1142919546E+00, 8.9300515332E-01],
	[2.7475000000E+04, 1.7738625106E+01, 5.1374212558E+00, 4.5085273088E+00, 2.1149417665E+00, 8.9305600457E-01],
	[2.7480000000E+04, 1.7743832269E+01, 5.1373880896E+00, 4.5111698185E+00, 2.1155914967E+00, 8.9310683155E-01],
	[2.7485000000E+04, 1.7749040013E+01, 5.1373549297E+00, 4.5138133944E+00, 2.1162411451E+00, 8.9315763429E-01],
	[2.7490000000E+04, 1.7754248337E+01, 5.1373217760E+00, 4.5164580370E+00, 2.1168907116E+00, 8.9320841279E-01],
	[2.7495000000E+04, 1.7759457243E+01, 5.1372886286E+00, 4.5191037463E+00, 2.1175401963E+00, 8.9325916706E-01],
	[2.7500000000E+04, 1.7764666729E+01, 5.1372554874E+00, 4.5217505227E+00, 2.1181895989E+00, 8.9330989710E-01],
	[2.7505000000E+04, 1.7769876795E+01, 5.1372223525E+00, 4.5243983664E+00, 2.1188389194E+00, 8.9336060293E-01],
	[2.7510000000E+04, 1.7775087442E+01, 5.1371892237E+00, 4.5270472775E+00, 2.1194881578E+00, 8.9341128456E-01],
	[2.7515000000E+04, 1.7780298670E+01, 5.1371561013E+00, 4.5296972565E+00, 2.1201373139E+00, 8.9346194200E-01],
	[2.7520000000E+04, 1.7785510478E+01, 5.1371229850E+00, 4.5323483034E+00, 2.1207863878E+00, 8.9351257525E-01],
	[2.7525000000E+04, 1.7790722867E+01, 5.1370898750E+00, 4.5350004185E+00, 2.1214353793E+00, 8.9356318432E-01],
	[2.7530000000E+04, 1.7795935836E+01, 5.1370567712E+00, 4.5376536021E+00, 2.1220842884E+00, 8.9361376923E-01],
	[2.7535000000E+04, 1.7801149386E+01, 5.1370236736E+00, 4.5403078544E+00, 2.1227331150E+00, 8.9366432998E-01],
	[2.7540000000E+04, 1.7806363516E+01, 5.1369905823E+00, 4.5429631756E+00, 2.1233818590E+00, 8.9371486658E-01],
	[2.7545000000E+04, 1.7811578226E+01, 5.1369574972E+00, 4.5456195659E+00, 2.1240305204E+00, 8.9376537905E-01],
	[2.7550000000E+04, 1.7816793516E+01, 5.1369244183E+00, 4.5482770257E+00, 2.1246790991E+00, 8.9381586738E-01],
	[2.7555000000E+04, 1.7822009387E+01, 5.1368913456E+00, 4.5509355551E+00, 2.1253275950E+00, 8.9386633159E-01],
	[2.7560000000E+04, 1.7827225837E+01, 5.1368582791E+00, 4.5535951543E+00, 2.1259760080E+00, 8.9391677170E-01],
	[2.7565000000E+04, 1.7832442868E+01, 5.1368252188E+00, 4.5562558237E+00, 2.1266243382E+00, 8.9396718770E-01],
	[2.7570000000E+04, 1.7837660479E+01, 5.1367921648E+00, 4.5589175634E+00, 2.1272725853E+00, 8.9401757961E-01],
	[2.7575000000E+04, 1.7842878670E+01, 5.1367591169E+00, 4.5615803736E+00, 2.1279207494E+00, 8.9406794744E-01],
	[2.7580000000E+04, 1.7848097441E+01, 5.1367260753E+00, 4.5642442547E+00, 2.1285688304E+00, 8.9411829119E-01],
	[2.7585000000E+04, 1.7853316792E+01, 5.1366930399E+00, 4.5669092068E+00, 2.1292168281E+00, 8.9416861088E-01],
	[2.7590000000E+04, 1.7858536723E+01, 5.1366600106E+00, 4.5695752302E+00, 2.1298647426E+00, 8.9421890651E-01],
	[2.7595000000E+04, 1.7863757234E+01, 5.1366269876E+00, 4.5722423251E+00, 2.1305125738E+00, 8.9426917810E-01],
	[2.7600000000E+04, 1.7868978324E+01, 5.1365939707E+00, 4.5749104918E+00, 2.1311603216E+00, 8.9431942565E-01],
	[2.7605000000E+04, 1.7874199995E+01, 5.1365609601E+00, 4.5775797305E+00, 2.1318079858E+00, 8.9436964917E-01],
	[2.7610000000E+04, 1.7879422245E+01, 5.1365279556E+00, 4.5802500414E+00, 2.1324555666E+00, 8.9441984868E-01],
	[2.7615000000E+04, 1.7884656366E+01, 5.1364967849E+00, 4.5829214247E+00, 2.1331035395E+00, 8.9447002417E-01],
	[2.7620000000E+04, 1.7889901254E+01, 5.1364672677E+00, 4.5855938807E+00, 2.1337518584E+00, 8.9452017567E-01],
	[2.7625000000E+04, 1.7895146730E+01, 5.1364377559E+00, 4.5882674097E+00, 2.1344000942E+00, 8.9457030318E-01],
	[2.7630000000E+04, 1.7900392795E+01, 5.1364082496E+00, 4.5909420118E+00, 2.1350482470E+00, 8.9462040671E-01],
	[2.7635000000E+04, 1.7905639447E+01, 5.1363787489E+00, 4.5936176874E+00, 2.1356963166E+00, 8.9467048626E-01],
	[2.7640000000E+04, 1.7910886688E+01, 5.1363492537E+00, 4.5962944365E+00, 2.1363443031E+00, 8.9472054186E-01],
	[2.7645000000E+04, 1.7916134517E+01, 5.1363197639E+00, 4.5989722596E+00, 2.1369922063E+00, 8.9477057350E-01],
	[2.7650000000E+04, 1.7921382934E+01, 5.1362902797E+00, 4.6016511567E+00, 2.1376400262E+00, 8.9482058120E-01],
	[2.7655000000E+04, 1.7926631939E+01, 5.1362608010E+00, 4.6043311282E+00, 2.1382877627E+00, 8.9487056496E-01],
	[2.7660000000E+04, 1.7931881532E+01, 5.1362313277E+00, 4.6070121743E+00, 2.1389354157E+00, 8.9492052480E-01],
	[2.7665000000E+04, 1.7937131713E+01, 5.1362018600E+00, 4.6096942952E+00, 2.1395829852E+00, 8.9497046073E-01],
	[2.7670000000E+04, 1.7942382483E+01, 5.1361723978E+00, 4.6123774911E+00, 2.1402304710E+00, 8.9502037274E-01],
	[2.7675000000E+04, 1.7947633840E+01, 5.1361429410E+00, 4.6150617623E+00, 2.1408778732E+00, 8.9507026087E-01],
	[2.7680000000E+04, 1.7952885785E+01, 5.1361134897E+00, 4.6177471091E+00, 2.1415251917E+00, 8.9512012510E-01],
	[2.7685000000E+04, 1.7958138317E+01, 5.1360840440E+00, 4.6204335316E+00, 2.1421724263E+00, 8.9516996546E-01],
	[2.7690000000E+04, 1.7963391438E+01, 5.1360546037E+00, 4.6231210301E+00, 2.1428195771E+00, 8.9521978195E-01],
	[2.7695000000E+04, 1.7968645146E+01, 5.1360251689E+00, 4.6258096048E+00, 2.1434666439E+00, 8.9526957458E-01],
	[2.7700000000E+04, 1.7973899442E+01, 5.1359957396E+00, 4.6284992560E+00, 2.1441136267E+00, 8.9531934336E-01],
	[2.7705000000E+04, 1.7979154326E+01, 5.1359663157E+00, 4.6311899839E+00, 2.1447605254E+00, 8.9536908831E-01],
	[2.7710000000E+04, 1.7984409797E+01, 5.1359368974E+00, 4.6338817887E+00, 2.1454073400E+00, 8.9541880942E-01],
	[2.7715000000E+04, 1.7989665856E+01, 5.1359074845E+00, 4.6365746707E+00, 2.1460540704E+00, 8.9546850671E-01],
	[2.7720000000E+04, 1.7994922503E+01, 5.1358780771E+00, 4.6392686301E+00, 2.1467007164E+00, 8.9551818019E-01],
	[2.7725000000E+04, 1.8000179737E+01, 5.1358486752E+00, 4.6419636672E+00, 2.1473472782E+00, 8.9556782986E-01],
	[2.7730000000E+04, 1.8005437558E+01, 5.1358192787E+00, 4.6446597821E+00, 2.1479937555E+00, 8.9561745575E-01],
	[2.7735000000E+04, 1.8010695967E+01, 5.1357898877E+00, 4.6473569752E+00, 2.1486401483E+00, 8.9566705785E-01],
	[2.7740000000E+04, 1.8015954963E+01, 5.1357605022E+00, 4.6500552466E+00, 2.1492864565E+00, 8.9571663617E-01],
	[2.7745000000E+04, 1.8021214547E+01, 5.1357311221E+00, 4.6527545966E+00, 2.1499326802E+00, 8.9576619073E-01],
	[2.7750000000E+04, 1.8026474718E+01, 5.1357017475E+00, 4.6554550254E+00, 2.1505788191E+00, 8.9581572154E-01],
	[2.7755000000E+04, 1.8031735476E+01, 5.1356723783E+00, 4.6581565332E+00, 2.1512248733E+00, 8.9586522860E-01],
	[2.7760000000E+04, 1.8036996821E+01, 5.1356430147E+00, 4.6608591204E+00, 2.1518708427E+00, 8.9591471192E-01],
	[2.7765000000E+04, 1.8042258754E+01, 5.1356136564E+00, 4.6635627871E+00, 2.1525167272E+00, 8.9596417152E-01],
	[2.7770000000E+04, 1.8047521274E+01, 5.1355843037E+00, 4.6662675336E+00, 2.1531625267E+00, 8.9601360740E-01],
	[2.7775000000E+04, 1.8052784381E+01, 5.1355549563E+00, 4.6689733601E+00, 2.1538082412E+00, 8.9606301957E-01],
	[2.7780000000E+04, 1.8058048075E+01, 5.1355256145E+00, 4.6716802668E+00, 2.1544538706E+00, 8.9611240805E-01],
	[2.7785000000E+04, 1.8063312356E+01, 5.1354962780E+00, 4.6743882539E+00, 2.1550994148E+00, 8.9616177283E-01],
	[2.7790000000E+04, 1.8068577224E+01, 5.1354669471E+00, 4.6770973218E+00, 2.1557448739E+00, 8.9621111394E-01],
	[2.7795000000E+04, 1.8073842679E+01, 5.1354376215E+00, 4.6798074707E+00, 2.1563902476E+00, 8.9626043137E-01],
	[2.7800000000E+04, 1.8079108721E+01, 5.1354083014E+00, 4.6825187007E+00, 2.1570355360E+00, 8.9630972515E-01],
	[2.7805000000E+04, 1.8084375349E+01, 5.1353789868E+00, 4.6852310121E+00, 2.1576807389E+00, 8.9635899527E-01],
	[2.7810000000E+04, 1.8089642565E+01, 5.1353496776E+00, 4.6879444052E+00, 2.1583258564E+00, 8.9640824175E-01],
	[2.7815000000E+04, 1.8094910367E+01, 5.1353203738E+00, 4.6906588802E+00, 2.1589708883E+00, 8.9645746461E-01],
	[2.7820000000E+04, 1.8100178756E+01, 5.1352910754E+00, 4.6933744373E+00, 2.1596158346E+00, 8.9650666383E-01],
	[2.7825000000E+04, 1.8105447732E+01, 5.1352617825E+00, 4.6960910768E+00, 2.1602606952E+00, 8.9655583945E-01],
	[2.7830000000E+04, 1.8110717295E+01, 5.1352324950E+00, 4.6988087989E+00, 2.1609054700E+00, 8.9660499146E-01],
	[2.7835000000E+04, 1.8115987444E+01, 5.1352032130E+00, 4.7015276038E+00, 2.1615501590E+00, 8.9665411988E-01],
	[2.7840000000E+04, 1.8121258179E+01, 5.1351739364E+00, 4.7042474917E+00, 2.1621947621E+00, 8.9670322471E-01],
	[2.7845000000E+04, 1.8126529502E+01, 5.1351446652E+00, 4.7069684630E+00, 2.1628392793E+00, 8.9675230597E-01],
	[2.7850000000E+04, 1.8131801410E+01, 5.1351153994E+00, 4.7096905178E+00, 2.1634837105E+00, 8.9680136366E-01],
	[2.7855000000E+04, 1.8137073906E+01, 5.1350861390E+00, 4.7124136564E+00, 2.1641280556E+00, 8.9685039780E-01],
	[2.7860000000E+04, 1.8142346987E+01, 5.1350568841E+00, 4.7151378791E+00, 2.1647723145E+00, 8.9689940839E-01],
	[2.7865000000E+04, 1.8147620655E+01, 5.1350276346E+00, 4.7178631859E+00, 2.1654164872E+00, 8.9694839544E-01],
	[2.7870000000E+04, 1.8152894910E+01, 5.1349983905E+00, 4.7205895773E+00, 2.1660605736E+00, 8.9699735897E-01],
	[2.7875000000E+04, 1.8158169750E+01, 5.1349691518E+00, 4.7233170534E+00, 2.1667045737E+00, 8.9704629898E-01],
	[2.7880000000E+04, 1.8163445177E+01, 5.1349399185E+00, 4.7260456144E+00, 2.1673484874E+00, 8.9709521548E-01],
	[2.7885000000E+04, 1.8168721190E+01, 5.1349106906E+00, 4.7287752606E+00, 2.1679923145E+00, 8.9714410848E-01],
	[2.7890000000E+04, 1.8173997790E+01, 5.1348814681E+00, 4.7315059923E+00, 2.1686360552E+00, 8.9719297800E-01],
	[2.7895000000E+04, 1.8179274975E+01, 5.1348522511E+00, 4.7342378096E+00, 2.1692797092E+00, 8.9724182403E-01],
	[2.7900000000E+04, 1.8184552747E+01, 5.1348230394E+00, 4.7369707128E+00, 2.1699232766E+00, 8.9729064659E-01],
	[2.7905000000E+04, 1.8189831105E+01, 5.1347938331E+00, 4.7397047022E+00, 2.1705667572E+00, 8.9733944570E-01],
	[2.7910000000E+04, 1.8195110048E+01, 5.1347646323E+00, 4.7424397779E+00, 2.1712101511E+00, 8.9738822135E-01],
	[2.7915000000E+04, 1.8200389578E+01, 5.1347354368E+00, 4.7451759403E+00, 2.1718534580E+00, 8.9743697356E-01],
	[2.7920000000E+04, 1.8205669694E+01, 5.1347062467E+00, 4.7479131895E+00, 2.1724966780E+00, 8.9748570234E-01],
	[2.7925000000E+04, 1.8210950395E+01, 5.1346770620E+00, 4.7506515258E+00, 2.1731398111E+00, 8.9753440770E-01],
	[2.7930000000E+04, 1.8216231683E+01, 5.1346478828E+00, 4.7533909494E+00, 2.1737828570E+00, 8.9758308964E-01],
	[2.7935000000E+04, 1.8221513556E+01, 5.1346187089E+00, 4.7561314605E+00, 2.1744258159E+00, 8.9763174819E-01],
	[2.7940000000E+04, 1.8226796015E+01, 5.1345895403E+00, 4.7588730595E+00, 2.1750686875E+00, 8.9768038333E-01],
	[2.7945000000E+04, 1.8232079060E+01, 5.1345603772E+00, 4.7616157465E+00, 2.1757114719E+00, 8.9772899510E-01],
	[2.7950000000E+04, 1.8237362690E+01, 5.1345312195E+00, 4.7643595217E+00, 2.1763541690E+00, 8.9777758349E-01],
	[2.7955000000E+04, 1.8242646906E+01, 5.1345020671E+00, 4.7671043855E+00, 2.1769967787E+00, 8.9782614852E-01],
	[2.7960000000E+04, 1.8247931708E+01, 5.1344729201E+00, 4.7698503379E+00, 2.1776393010E+00, 8.9787469019E-01],
	[2.7965000000E+04, 1.8253217096E+01, 5.1344437785E+00, 4.7725973794E+00, 2.1782817357E+00, 8.9792320851E-01],
	[2.7970000000E+04, 1.8258503068E+01, 5.1344146423E+00, 4.7753455101E+00, 2.1789240828E+00, 8.9797170350E-01],
	[2.7975000000E+04, 1.8263789627E+01, 5.1343855114E+00, 4.7780947302E+00, 2.1795663424E+00, 8.9802017517E-01],
	[2.7980000000E+04, 1.8269076771E+01, 5.1343563859E+00, 4.7808450399E+00, 2.1802085142E+00, 8.9806862352E-01],
	[2.7985000000E+04, 1.8274364500E+01, 5.1343272658E+00, 4.7835964397E+00, 2.1808505982E+00, 8.9811704856E-01],
	[2.7990000000E+04, 1.8279652815E+01, 5.1342981511E+00, 4.7863489295E+00, 2.1814925944E+00, 8.9816545030E-01],
	[2.7995000000E+04, 1.8284941715E+01, 5.1342690417E+00, 4.7891025098E+00, 2.1821345028E+00, 8.9821382876E-01],
	[2.8000000000E+04, 1.8290231200E+01, 5.1342399377E+00, 4.7918571807E+00, 2.1827763231E+00, 8.9826218393E-01],
	[2.8005000000E+04, 1.8295521271E+01, 5.1342108390E+00, 4.7946129424E+00, 2.1834180555E+00, 8.9831051584E-01],
	[2.8010000000E+04, 1.8300811927E+01, 5.1341817457E+00, 4.7973697952E+00, 2.1840596997E+00, 8.9835882449E-01],
	[2.8015000000E+04, 1.8306103168E+01, 5.1341526578E+00, 4.8001277394E+00, 2.1847012558E+00, 8.9840710990E-01],
	[2.8020000000E+04, 1.8311394994E+01, 5.1341235752E+00, 4.8028867752E+00, 2.1853427237E+00, 8.9845537206E-01],
	[2.8025000000E+04, 1.8316687406E+01, 5.1340944980E+00, 4.8056469027E+00, 2.1859841033E+00, 8.9850361099E-01],
	[2.8030000000E+04, 1.8321980402E+01, 5.1340654261E+00, 4.8084081223E+00, 2.1866253946E+00, 8.9855182670E-01],
	[2.8035000000E+04, 1.8327273984E+01, 5.1340363595E+00, 4.8111704342E+00, 2.1872665975E+00, 8.9860001921E-01],
	[2.8040000000E+04, 1.8332568150E+01, 5.1340072984E+00, 4.8139338386E+00, 2.1879077119E+00, 8.9864818851E-01],
	[2.8045000000E+04, 1.8337862901E+01, 5.1339782425E+00, 4.8166983358E+00, 2.1885487378E+00, 8.9869633462E-01],
	[2.8050000000E+04, 1.8343158238E+01, 5.1339491920E+00, 4.8194639259E+00, 2.1891896750E+00, 8.9874445754E-01],
	[2.8055000000E+04, 1.8348454159E+01, 5.1339201469E+00, 4.8222306093E+00, 2.1898305237E+00, 8.9879255730E-01],
	[2.8060000000E+04, 1.8353763960E+01, 5.1338932300E+00, 4.8249983861E+00, 2.1904718594E+00, 8.9884063390E-01],
	[2.8065000000E+04, 1.8359082449E+01, 5.1338676104E+00, 4.8277672567E+00, 2.1911134576E+00, 8.9888868734E-01],
	[2.8070000000E+04, 1.8364401530E+01, 5.1338419956E+00, 4.8305372211E+00, 2.1917549677E+00, 8.9893671764E-01],
	[2.8075000000E+04, 1.8369721205E+01, 5.1338163854E+00, 4.8333082798E+00, 2.1923963897E+00, 8.9898472480E-01],
	[2.8080000000E+04, 1.8375041473E+01, 5.1337907799E+00, 4.8360804328E+00, 2.1930377234E+00, 8.9903270884E-01],
	[2.8085000000E+04, 1.8380362334E+01, 5.1337651791E+00, 4.8388536805E+00, 2.1936789688E+00, 8.9908066977E-01],
	[2.8090000000E+04, 1.8385683788E+01, 5.1337395830E+00, 4.8416280231E+00, 2.1943201259E+00, 8.9912860760E-01],
	[2.8095000000E+04, 1.8391005836E+01, 5.1337139916E+00, 4.8444034608E+00, 2.1949611946E+00, 8.9917652233E-01],
	[2.8100000000E+04, 1.8396328476E+01, 5.1336884048E+00, 4.8471799938E+00, 2.1956021749E+00, 8.9922441397E-01],
	[2.8105000000E+04, 1.8401651710E+01, 5.1336628228E+00, 4.8499576225E+00, 2.1962430666E+00, 8.9927228254E-01],
	[2.8110000000E+04, 1.8406975536E+01, 5.1336372454E+00, 4.8527363469E+00, 2.1968838697E+00, 8.9932012804E-01],
	[2.8115000000E+04, 1.8412299956E+01, 5.1336116727E+00, 4.8555161675E+00, 2.1975245842E+00, 8.9936795049E-01],
	[2.8120000000E+04, 1.8417624968E+01, 5.1335861046E+00, 4.8582970843E+00, 2.1981652099E+00, 8.9941574990E-01],
	[2.8125000000E+04, 1.8422950574E+01, 5.1335605413E+00, 4.8610790977E+00, 2.1988057469E+00, 8.9946352626E-01],
	[2.8130000000E+04, 1.8428276772E+01, 5.1335349826E+00, 4.8638622078E+00, 2.1994461950E+00, 8.9951127960E-01],
	[2.8135000000E+04, 1.8433603563E+01, 5.1335094286E+00, 4.8666464150E+00, 2.2000865542E+00, 8.9955900992E-01],
	[2.8140000000E+04, 1.8438930947E+01, 5.1334838792E+00, 4.8694317194E+00, 2.2007268245E+00, 8.9960671724E-01],
	[2.8145000000E+04, 1.8444258923E+01, 5.1334583345E+00, 4.8722181212E+00, 2.2013670057E+00, 8.9965440156E-01],
	[2.8150000000E+04, 1.8449587492E+01, 5.1334327945E+00, 4.8750056208E+00, 2.2020070978E+00, 8.9970206289E-01],
	[2.8155000000E+04, 1.8454916654E+01, 5.1334072591E+00, 4.8777942184E+00, 2.2026471008E+00, 8.9974970124E-01],
	[2.8160000000E+04, 1.8460246408E+01, 5.1333817284E+00, 4.8805839141E+00, 2.2032870146E+00, 8.9979731663E-01],
	[2.8165000000E+04, 1.8465576755E+01, 5.1333562024E+00, 4.8833747083E+00, 2.2039268391E+00, 8.9984490905E-01],
	[2.8170000000E+04, 1.8470907695E+01, 5.1333306810E+00, 4.8861666011E+00, 2.2045665743E+00, 8.9989247853E-01],
	[2.8175000000E+04, 1.8476239227E+01, 5.1333051643E+00, 4.8889595929E+00, 2.2052062201E+00, 8.9994002507E-01],
	[2.8180000000E+04, 1.8481571351E+01, 5.1332796522E+00, 4.8917536838E+00, 2.2058457764E+00, 8.9998754868E-01],
	[2.8185000000E+04, 1.8486904068E+01, 5.1332541448E+00, 4.8945488740E+00, 2.2064852433E+00, 9.0003504936E-01],
	[2.8190000000E+04, 1.8492237377E+01, 5.1332286420E+00, 4.8973451639E+00, 2.2071246205E+00, 9.0008252714E-01],
	[2.8195000000E+04, 1.8497571279E+01, 5.1332031439E+00, 4.9001425536E+00, 2.2077639081E+00, 9.0012998202E-01],
	[2.8200000000E+04, 1.8502905772E+01, 5.1331776505E+00, 4.9029410434E+00, 2.2084031060E+00, 9.0017741401E-01],
	[2.8205000000E+04, 1.8508240858E+01, 5.1331521616E+00, 4.9057406335E+00, 2.2090422142E+00, 9.0022482312E-01],
	[2.8210000000E+04, 1.8513576537E+01, 5.1331266775E+00, 4.9085413242E+00, 2.2096812325E+00, 9.0027220935E-01],
	[2.8215000000E+04, 1.8518912807E+01, 5.1331011979E+00, 4.9113431157E+00, 2.2103201609E+00, 9.0031957273E-01],
	[2.8220000000E+04, 1.8524249670E+01, 5.1330757230E+00, 4.9141460082E+00, 2.2109589994E+00, 9.0036691325E-01],
	[2.8225000000E+04, 1.8529587124E+01, 5.1330502528E+00, 4.9169500020E+00, 2.2115977479E+00, 9.0041423092E-01],
	[2.8230000000E+04, 1.8534925171E+01, 5.1330247872E+00, 4.9197550973E+00, 2.2122364064E+00, 9.0046152576E-01],
	[2.8235000000E+04, 1.8540263810E+01, 5.1329993262E+00, 4.9225612943E+00, 2.2128749747E+00, 9.0050879777E-01],
	[2.8240000000E+04, 1.8545603041E+01, 5.1329738698E+00, 4.9253685933E+00, 2.2135134528E+00, 9.0055604696E-01],
	[2.8245000000E+04, 1.8550942863E+01, 5.1329484181E+00, 4.9281769945E+00, 2.2141518407E+00, 9.0060327334E-01],
	[2.8250000000E+04, 1.8556283278E+01, 5.1329229711E+00, 4.9309864982E+00, 2.2147901383E+00, 9.0065047693E-01],
	[2.8255000000E+04, 1.8561624284E+01, 5.1328975286E+00, 4.9337971045E+00, 2.2154283455E+00, 9.0069765772E-01],
	[2.8260000000E+04, 1.8566965883E+01, 5.1328720908E+00, 4.9366088138E+00, 2.2160664623E+00, 9.0074481573E-01],
	[2.8265000000E+04, 1.8572308073E+01, 5.1328466576E+00, 4.9394216263E+00, 2.2167044886E+00, 9.0079195096E-01],
	[2.8270000000E+04, 1.8577650854E+01, 5.1328212290E+00, 4.9422355421E+00, 2.2173424244E+00, 9.0083906343E-01],
	[2.8275000000E+04, 1.8582994228E+01, 5.1327958051E+00, 4.9450505616E+00, 2.2179802695E+00, 9.0088615314E-01],
	[2.8280000000E+04, 1.8588338193E+01, 5.1327703857E+00, 4.9478666849E+00, 2.2186180240E+00, 9.0093322011E-01],
	[2.8285000000E+04, 1.8593682750E+01, 5.1327449710E+00, 4.9506839124E+00, 2.2192556878E+00, 9.0098026433E-01],
	[2.8290000000E+04, 1.8599027898E+01, 5.1327195609E+00, 4.9535022442E+00, 2.2198932608E+00, 9.0102728583E-01],
	[2.8295000000E+04, 1.8604373638E+01, 5.1326941555E+00, 4.9563216806E+00, 2.2205307429E+00, 9.0107428461E-01],
	[2.8300000000E+04, 1.8609719969E+01, 5.1326687546E+00, 4.9591422218E+00, 2.2211681342E+00, 9.0112126068E-01],
	[2.8305000000E+04, 1.8615066892E+01, 5.1326433584E+00, 4.9619638681E+00, 2.2218054345E+00, 9.0116821404E-01],
	[2.8310000000E+04, 1.8620414406E+01, 5.1326179667E+00, 4.9647866196E+00, 2.2224426437E+00, 9.0121514471E-01],
	[2.8315000000E+04, 1.8625762512E+01, 5.1325925797E+00, 4.9676104767E+00, 2.2230797619E+00, 9.0126205270E-01],
	[2.8320000000E+04, 1.8631111209E+01, 5.1325671973E+00, 4.9704354396E+00, 2.2237167890E+00, 9.0130893801E-01],
	[2.8325000000E+04, 1.8636460497E+01, 5.1325418195E+00, 4.9732615084E+00, 2.2243537248E+00, 9.0135580065E-01],
	[2.8330000000E+04, 1.8641810377E+01, 5.1325164463E+00, 4.9760886835E+00, 2.2249905694E+00, 9.0140264064E-01],
	[2.8335000000E+04, 1.8647160848E+01, 5.1324910777E+00, 4.9789169651E+00, 2.2256273227E+00, 9.0144945798E-01],
	[2.8340000000E+04, 1.8652511910E+01, 5.1324657137E+00, 4.9817463534E+00, 2.2262639846E+00, 9.0149625268E-01],
	[2.8345000000E+04, 1.8657863563E+01, 5.1324403543E+00, 4.9845768486E+00, 2.2269005550E+00, 9.0154302474E-01],
	[2.8350000000E+04, 1.8663215807E+01, 5.1324149995E+00, 4.9874084510E+00, 2.2275370340E+00, 9.0158977419E-01],
	[2.8355000000E+04, 1.8668568643E+01, 5.1323896493E+00, 4.9902411609E+00, 2.2281734214E+00, 9.0163650102E-01],
	[2.8360000000E+04, 1.8673922069E+01, 5.1323643037E+00, 4.9930749784E+00, 2.2288097172E+00, 9.0168320525E-01],
	[2.8365000000E+04, 1.8679276087E+01, 5.1323389626E+00, 4.9959099038E+00, 2.2294459213E+00, 9.0172988689E-01],
	[2.8370000000E+04, 1.8684630695E+01, 5.1323136262E+00, 4.9987459374E+00, 2.2300820337E+00, 9.0177654594E-01],
	[2.8375000000E+04, 1.8689985894E+01, 5.1322882944E+00, 5.0015830793E+00, 2.2307180544E+00, 9.0182318241E-01],
	[2.8380000000E+04, 1.8695341684E+01, 5.1322629671E+00, 5.0044213298E+00, 2.2313539831E+00, 9.0186979631E-01],
	[2.8385000000E+04, 1.8700698065E+01, 5.1322376445E+00, 5.0072606892E+00, 2.2319898200E+00, 9.0191638766E-01],
	[2.8390000000E+04, 1.8706055037E+01, 5.1322123264E+00, 5.0101011577E+00, 2.2326255649E+00, 9.0196295646E-01],
	[2.8395000000E+04, 1.8711412600E+01, 5.1321870129E+00, 5.0129427354E+00, 2.2332612178E+00, 9.0200950271E-01],
	[2.8400000000E+04, 1.8716770753E+01, 5.1321617040E+00, 5.0157854228E+00, 2.2338967786E+00, 9.0205602644E-01],
	[2.8405000000E+04, 1.8722129497E+01, 5.1321363997E+00, 5.0186292199E+00, 2.2345322473E+00, 9.0210252764E-01],
	[2.8410000000E+04, 1.8727488832E+01, 5.1321110999E+00, 5.0214741271E+00, 2.2351676238E+00, 9.0214900633E-01],
	[2.8415000000E+04, 1.8732848757E+01, 5.1320858047E+00, 5.0243201445E+00, 2.2358029080E+00, 9.0219546251E-01],
	[2.8420000000E+04, 1.8738209273E+01, 5.1320605141E+00, 5.0271672724E+00, 2.2364380999E+00, 9.0224189620E-01],
	[2.8425000000E+04, 1.8743570379E+01, 5.1320352281E+00, 5.0300155111E+00, 2.2370731995E+00, 9.0228830740E-01],
	[2.8430000000E+04, 1.8748932076E+01, 5.1320099467E+00, 5.0328648608E+00, 2.2377082066E+00, 9.0233469613E-01],
	[2.8435000000E+04, 1.8754294364E+01, 5.1319846698E+00, 5.0357153216E+00, 2.2383431213E+00, 9.0238106239E-01],
	[2.8440000000E+04, 1.8759657241E+01, 5.1319593975E+00, 5.0385668940E+00, 2.2389779434E+00, 9.0242740618E-01],
	[2.8445000000E+04, 1.8765020710E+01, 5.1319341297E+00, 5.0414195780E+00, 2.2396126729E+00, 9.0247372753E-01],
	[2.8450000000E+04, 1.8770384768E+01, 5.1319088665E+00, 5.0442733739E+00, 2.2402473097E+00, 9.0252002644E-01],
	[2.8455000000E+04, 1.8775749417E+01, 5.1318836079E+00, 5.0471282820E+00, 2.2408818539E+00, 9.0256630291E-01],
	[2.8460000000E+04, 1.8781114656E+01, 5.1318583539E+00, 5.0499843025E+00, 2.2415163052E+00, 9.0261255696E-01],
	[2.8465000000E+04, 1.8786480485E+01, 5.1318331044E+00, 5.0528414357E+00, 2.2421506638E+00, 9.0265878860E-01],
	[2.8470000000E+04, 1.8791846904E+01, 5.1318078594E+00, 5.0556996817E+00, 2.2427849295E+00, 9.0270499784E-01],
	[2.8475000000E+04, 1.8797213914E+01, 5.1317826191E+00, 5.0585590409E+00, 2.2434191022E+00, 9.0275118467E-01],
	[2.8480000000E+04, 1.8802581514E+01, 5.1317573832E+00, 5.0614195133E+00, 2.2440531819E+00, 9.0279734913E-01],
	[2.8485000000E+04, 1.8807949704E+01, 5.1317321520E+00, 5.0642810994E+00, 2.2446871686E+00, 9.0284349120E-01],
	[2.8490000000E+04, 1.8813318483E+01, 5.1317069253E+00, 5.0671437993E+00, 2.2453210621E+00, 9.0288961090E-01],
	[2.8495000000E+04, 1.8818687853E+01, 5.1316817031E+00, 5.0700076133E+00, 2.2459548625E+00, 9.0293570825E-01],
	[2.8500000000E+04, 1.8824057813E+01, 5.1316564855E+00, 5.0728725415E+00, 2.2465885697E+00, 9.0298178325E-01],
	[2.8505000000E+04, 1.8829428362E+01, 5.1316312724E+00, 5.0757385843E+00, 2.2472221836E+00, 9.0302783590E-01],
	[2.8510000000E+04, 1.8834805596E+01, 5.1316070240E+00, 5.0786057419E+00, 2.2478559751E+00, 9.0307386623E-01],
	[2.8515000000E+04, 1.8840198636E+01, 5.1315851765E+00, 5.0814740145E+00, 2.2484903504E+00, 9.0311987423E-01],
	[2.8520000000E+04, 1.8845592275E+01, 5.1315633330E+00, 5.0843434023E+00, 2.2491246329E+00, 9.0316585991E-01],
	[2.8525000000E+04, 1.8850986512E+01, 5.1315414934E+00, 5.0872139056E+00, 2.2497588226E+00, 9.0321182330E-01],
	[2.8530000000E+04, 1.8856381348E+01, 5.1315196577E+00, 5.0900855246E+00, 2.2503929195E+00, 9.0325776438E-01],
	[2.8535000000E+04, 1.8861776781E+01, 5.1314978259E+00, 5.0929582596E+00, 2.2510269235E+00, 9.0330368319E-01],
	[2.8540000000E+04, 1.8867172813E+01, 5.1314759981E+00, 5.0958321108E+00, 2.2516608346E+00, 9.0334957971E-01],
	[2.8545000000E+04, 1.8872569442E+01, 5.1314541741E+00, 5.0987070784E+00, 2.2522946526E+00, 9.0339545397E-01],
	[2.8550000000E+04, 1.8877966670E+01, 5.1314323541E+00, 5.1015831627E+00, 2.2529283777E+00, 9.0344130596E-01],
	[2.8555000000E+04, 1.8883364495E+01, 5.1314105380E+00, 5.1044603639E+00, 2.2535620096E+00, 9.0348713571E-01],
	[2.8560000000E+04, 1.8888762919E+01, 5.1313887258E+00, 5.1073386822E+00, 2.2541955483E+00, 9.0353294322E-01],
	[2.8565000000E+04, 1.8894161940E+01, 5.1313669175E+00, 5.1102181179E+00, 2.2548289938E+00, 9.0357872849E-01],
	[2.8570000000E+04, 1.8899561559E+01, 5.1313451132E+00, 5.1130986712E+00, 2.2554623461E+00, 9.0362449155E-01],
	[2.8575000000E+04, 1.8904961776E+01, 5.1313233127E+00, 5.1159803424E+00, 2.2560956050E+00, 9.0367023239E-01],
	[2.8580000000E+04, 1.8910362591E+01, 5.1313015161E+00, 5.1188631317E+00, 2.2567287705E+00, 9.0371595103E-01],
	[2.8585000000E+04, 1.8915764003E+01, 5.1312797235E+00, 5.1217470393E+00, 2.2573618426E+00, 9.0376164747E-01],
	[2.8590000000E+04, 1.8921166014E+01, 5.1312579347E+00, 5.1246320655E+00, 2.2579948212E+00, 9.0380732172E-01],
	[2.8595000000E+04, 1.8926568621E+01, 5.1312361499E+00, 5.1275182105E+00, 2.2586277062E+00, 9.0385297380E-01],
	[2.8600000000E+04, 1.8931971827E+01, 5.1312143690E+00, 5.1304054746E+00, 2.2592604976E+00, 9.0389860372E-01],
	[2.8605000000E+04, 1.8937375630E+01, 5.1311925919E+00, 5.1332938579E+00, 2.2598931953E+00, 9.0394421147E-01],
	[2.8610000000E+04, 1.8942780031E+01, 5.1311708188E+00, 5.1361833607E+00, 2.2605257993E+00, 9.0398979708E-01],
	[2.8615000000E+04, 1.8948185029E+01, 5.1311490495E+00, 5.1390739833E+00, 2.2611583096E+00, 9.0403536055E-01],
	[2.8620000000E+04, 1.8953590624E+01, 5.1311272842E+00, 5.1419657259E+00, 2.2617907260E+00, 9.0408090188E-01],
	[2.8625000000E+04, 1.8958996817E+01, 5.1311055227E+00, 5.1448585887E+00, 2.2624230485E+00, 9.0412642110E-01],
	[2.8630000000E+04, 1.8964403608E+01, 5.1310837651E+00, 5.1477525720E+00, 2.2630552771E+00, 9.0417191820E-01],
	[2.8635000000E+04, 1.8969810995E+01, 5.1310620115E+00, 5.1506476759E+00, 2.2636874116E+00, 9.0421739320E-01],
	[2.8640000000E+04, 1.8975218981E+01, 5.1310402617E+00, 5.1535439009E+00, 2.2643194521E+00, 9.0426284611E-01],
	[2.8645000000E+04, 1.8980627563E+01, 5.1310185158E+00, 5.1564412470E+00, 2.2649513986E+00, 9.0430827693E-01],
	[2.8650000000E+04, 1.8986036742E+01, 5.1309967738E+00, 5.1593397145E+00, 2.2655832508E+00, 9.0435368568E-01],
	[2.8655000000E+04, 1.8991446519E+01, 5.1309750357E+00, 5.1622393036E+00, 2.2662150088E+00, 9.0439907236E-01],
	[2.8660000000E+04, 1.8996856893E+01, 5.1309533014E+00, 5.1651400147E+00, 2.2668466726E+00, 9.0444443699E-01],
	[2.8665000000E+04, 1.9002267864E+01, 5.1309315711E+00, 5.1680418479E+00, 2.2674782420E+00, 9.0448977957E-01],
	[2.8670000000E+04, 1.9007679432E+01, 5.1309098446E+00, 5.1709448034E+00, 2.2681097171E+00, 9.0453510011E-01],
	[2.8675000000E+04, 1.9013091598E+01, 5.1308881220E+00, 5.1738488816E+00, 2.2687410977E+00, 9.0458039862E-01],
	[2.8680000000E+04, 1.9018504360E+01, 5.1308664033E+00, 5.1767540826E+00, 2.2693723838E+00, 9.0462567511E-01],
	[2.8685000000E+04, 1.9023917719E+01, 5.1308446885E+00, 5.1796604067E+00, 2.2700035754E+00, 9.0467092959E-01],
	[2.8690000000E+04, 1.9029331675E+01, 5.1308229775E+00, 5.1825678541E+00, 2.2706346724E+00, 9.0471616207E-01],
	[2.8695000000E+04, 1.9034746228E+01, 5.1308012704E+00, 5.1854764250E+00, 2.2712656747E+00, 9.0476137255E-01],
	[2.8700000000E+04, 1.9040161378E+01, 5.1307795672E+00, 5.1883861198E+00, 2.2718965823E+00, 9.0480656106E-01],
	[2.8705000000E+04, 1.9045577125E+01, 5.1307578679E+00, 5.1912969385E+00, 2.2725273952E+00, 9.0485172759E-01],
	[2.8710000000E+04, 1.9050993468E+01, 5.1307361724E+00, 5.1942088816E+00, 2.2731581132E+00, 9.0489687215E-01],
	[2.8715000000E+04, 1.9056410408E+01, 5.1307144808E+00, 5.1971219491E+00, 2.2737887364E+00, 9.0494199477E-01],
	[2.8720000000E+04, 1.9061827945E+01, 5.1306927931E+00, 5.2000361414E+00, 2.2744192646E+00, 9.0498709543E-01],
	[2.8725000000E+04, 1.9067246079E+01, 5.1306711092E+00, 5.2029514586E+00, 2.2750496979E+00, 9.0503217416E-01],
	[2.8730000000E+04, 1.9072664809E+01, 5.1306494292E+00, 5.2058679011E+00, 2.2756800361E+00, 9.0507723096E-01],
	[2.8735000000E+04, 1.9078084136E+01, 5.1306277531E+00, 5.2087854690E+00, 2.2763102793E+00, 9.0512226584E-01],
	[2.8740000000E+04, 1.9083504059E+01, 5.1306060808E+00, 5.2117041627E+00, 2.2769404273E+00, 9.0516727882E-01],
	[2.8745000000E+04, 1.9088924579E+01, 5.1305844124E+00, 5.2146239822E+00, 2.2775704802E+00, 9.0521226989E-01],
	[2.8750000000E+04, 1.9094345695E+01, 5.1305627479E+00, 5.2175449279E+00, 2.2782004377E+00, 9.0525723908E-01],
	[2.8755000000E+04, 1.9099767408E+01, 5.1305410872E+00, 5.2204670000E+00, 2.2788303000E+00, 9.0530218638E-01],
	[2.8760000000E+04, 1.9105189717E+01, 5.1305194304E+00, 5.2233901988E+00, 2.2794600670E+00, 9.0534711181E-01],
	[2.8765000000E+04, 1.9110612622E+01, 5.1304977774E+00, 5.2263145244E+00, 2.2800897385E+00, 9.0539201538E-01],
	[2.8770000000E+04, 1.9116036124E+01, 5.1304761283E+00, 5.2292399772E+00, 2.2807193146E+00, 9.0543689710E-01],
	[2.8775000000E+04, 1.9121460222E+01, 5.1304544830E+00, 5.2321665573E+00, 2.2813487951E+00, 9.0548175697E-01],
	[2.8780000000E+04, 1.9126884917E+01, 5.1304328416E+00, 5.2350942650E+00, 2.2819781801E+00, 9.0552659501E-01],
	[2.8785000000E+04, 1.9132310207E+01, 5.1304112041E+00, 5.2380231005E+00, 2.2826074695E+00, 9.0557141122E-01],
	[2.8790000000E+04, 1.9137736094E+01, 5.1303895704E+00, 5.2409530641E+00, 2.2832366632E+00, 9.0561620562E-01],
	[2.8795000000E+04, 1.9143162577E+01, 5.1303679405E+00, 5.2438841560E+00, 2.2838657612E+00, 9.0566097821E-01],
	[2.8800000000E+04, 1.9148589656E+01, 5.1303463145E+00, 5.2468163764E+00, 2.2844947634E+00, 9.0570572901E-01],
	[2.8805000000E+04, 1.9154017331E+01, 5.1303246923E+00, 5.2497497256E+00, 2.2851236698E+00, 9.0575045801E-01],
	[2.8810000000E+04, 1.9159445602E+01, 5.1303030740E+00, 5.2526842039E+00, 2.2857524803E+00, 9.0579516524E-01],
	[2.8815000000E+04, 1.9164874469E+01, 5.1302814595E+00, 5.2556198113E+00, 2.2863811949E+00, 9.0583985069E-01],
	[2.8820000000E+04, 1.9170303932E+01, 5.1302598489E+00, 5.2585565483E+00, 2.2870098135E+00, 9.0588451439E-01],
	[2.8825000000E+04, 1.9175733991E+01, 5.1302382421E+00, 5.2614944150E+00, 2.2876383361E+00, 9.0592915634E-01],
	[2.8830000000E+04, 1.9181164645E+01, 5.1302166391E+00, 5.2644334117E+00, 2.2882667625E+00, 9.0597377654E-01],
	[2.8835000000E+04, 1.9186595896E+01, 5.1301950400E+00, 5.2673735386E+00, 2.2888950928E+00, 9.0601837501E-01],
	[2.8840000000E+04, 1.9192027742E+01, 5.1301734447E+00, 5.2703147959E+00, 2.2895233270E+00, 9.0606295176E-01],
	[2.8845000000E+04, 1.9197460184E+01, 5.1301518532E+00, 5.2732571840E+00, 2.2901514648E+00, 9.0610750680E-01],
	[2.8850000000E+04, 1.9202893222E+01, 5.1301302656E+00, 5.2762007029E+00, 2.2907795064E+00, 9.0615204013E-01],
	[2.8855000000E+04, 1.9208326855E+01, 5.1301086818E+00, 5.2791453530E+00, 2.2914074516E+00, 9.0619655177E-01],
	[2.8860000000E+04, 1.9213761084E+01, 5.1300871018E+00, 5.2820911345E+00, 2.2920353005E+00, 9.0624104172E-01],
	[2.8865000000E+04, 1.9219195909E+01, 5.1300655257E+00, 5.2850380476E+00, 2.2926630528E+00, 9.0628550999E-01],
	[2.8870000000E+04, 1.9224631329E+01, 5.1300439534E+00, 5.2879860926E+00, 2.2932907087E+00, 9.0632995660E-01],
	[2.8875000000E+04, 1.9230067345E+01, 5.1300223849E+00, 5.2909352697E+00, 2.2939182680E+00, 9.0637438155E-01],
	[2.8880000000E+04, 1.9235503956E+01, 5.1300008203E+00, 5.2938855791E+00, 2.2945457307E+00, 9.0641878486E-01],
	[2.8885000000E+04, 1.9240941163E+01, 5.1299792594E+00, 5.2968370211E+00, 2.2951730967E+00, 9.0646316652E-01],
	[2.8890000000E+04, 1.9246378965E+01, 5.1299577024E+00, 5.2997895960E+00, 2.2958003660E+00, 9.0650752655E-01],
	[2.8895000000E+04, 1.9251817363E+01, 5.1299361493E+00, 5.3027433039E+00, 2.2964275386E+00, 9.0655186497E-01],
	[2.8900000000E+04, 1.9257256356E+01, 5.1299145999E+00, 5.3056981451E+00, 2.2970546143E+00, 9.0659618177E-01],
	[2.8905000000E+04, 1.9262695944E+01, 5.1298930543E+00, 5.3086541198E+00, 2.2976815932E+00, 9.0664047697E-01],
	[2.8910000000E+04, 1.9268136127E+01, 5.1298715126E+00, 5.3116112283E+00, 2.2983084751E+00, 9.0668475058E-01],
	[2.8915000000E+04, 1.9273576906E+01, 5.1298499747E+00, 5.3145694708E+00, 2.2989352601E+00, 9.0672900261E-01],
	[2.8920000000E+04, 1.9279018279E+01, 5.1298284406E+00, 5.3175288476E+00, 2.2995619481E+00, 9.0677323306E-01],
	[2.8925000000E+04, 1.9284460248E+01, 5.1298069103E+00, 5.3204893588E+00, 2.3001885389E+00, 9.0681744195E-01],
	[2.8930000000E+04, 1.9289902812E+01, 5.1297853838E+00, 5.3234510048E+00, 2.3008150327E+00, 9.0686162929E-01],
	[2.8935000000E+04, 1.9295345972E+01, 5.1297638612E+00, 5.3264137857E+00, 2.3014414293E+00, 9.0690579508E-01],
	[2.8940000000E+04, 1.9300789726E+01, 5.1297423423E+00, 5.3293777019E+00, 2.3020677287E+00, 9.0694993933E-01],
	[2.8945000000E+04, 1.9306234075E+01, 5.1297208273E+00, 5.3323427534E+00, 2.3026939307E+00, 9.0699406206E-01],
	[2.8950000000E+04, 1.9311679019E+01, 5.1296993160E+00, 5.3353089407E+00, 2.3033200355E+00, 9.0703816327E-01],
	[2.8955000000E+04, 1.9317124558E+01, 5.1296778086E+00, 5.3382762639E+00, 2.3039460429E+00, 9.0708224297E-01],
	[2.8960000000E+04, 1.9322570692E+01, 5.1296563050E+00, 5.3412447232E+00, 2.3045719528E+00, 9.0712630117E-01],
	[2.8965000000E+04, 1.9328017420E+01, 5.1296348051E+00, 5.3442143189E+00, 2.3051977653E+00, 9.0717033789E-01],
	[2.8970000000E+04, 1.9333475274E+01, 5.1296149462E+00, 5.3471850512E+00, 2.3058239608E+00, 9.0721435312E-01],
	[2.8975000000E+04, 1.9338944421E+01, 5.1295967530E+00, 5.3501569204E+00, 2.3064505473E+00, 9.0725834689E-01],
	[2.8980000000E+04, 1.9344414170E+01, 5.1295785629E+00, 5.3531299267E+00, 2.3070770368E+00, 9.0730231919E-01],
	[2.8985000000E+04, 1.9349884523E+01, 5.1295603761E+00, 5.3561040703E+00, 2.3077034294E+00, 9.0734627004E-01],
	[2.8990000000E+04, 1.9355355479E+01, 5.1295421924E+00, 5.3590793516E+00, 2.3083297250E+00, 9.0739019945E-01],
	[2.8995000000E+04, 1.9360827037E+01, 5.1295240120E+00, 5.3620557706E+00, 2.3089559235E+00, 9.0743410743E-01],
	[2.9000000000E+04, 1.9366299199E+01, 5.1295058348E+00, 5.3650333277E+00, 2.3095820249E+00, 9.0747799398E-01],
	[2.9005000000E+04, 1.9371771963E+01, 5.1294876607E+00, 5.3680120231E+00, 2.3102080292E+00, 9.0752185912E-01],
	[2.9010000000E+04, 1.9377245330E+01, 5.1294694899E+00, 5.3709918570E+00, 2.3108339362E+00, 9.0756570286E-01],
	[2.9015000000E+04, 1.9382719300E+01, 5.1294513222E+00, 5.3739728297E+00, 2.3114597460E+00, 9.0760952520E-01],
	[2.9020000000E+04, 1.9388193873E+01, 5.1294331578E+00, 5.3769549413E+00, 2.3120854584E+00, 9.0765332615E-01],
	[2.9025000000E+04, 1.9393669049E+01, 5.1294149965E+00, 5.3799381923E+00, 2.3127110735E+00, 9.0769710573E-01],
	[2.9030000000E+04, 1.9399144827E+01, 5.1293968385E+00, 5.3829225827E+00, 2.3133365912E+00, 9.0774086394E-01],
	[2.9035000000E+04, 1.9404621207E+01, 5.1293786836E+00, 5.3859081128E+00, 2.3139620114E+00, 9.0778460079E-01],
	[2.9040000000E+04, 1.9410098191E+01, 5.1293605319E+00, 5.3888947829E+00, 2.3145873341E+00, 9.0782831630E-01],
	[2.9045000000E+04, 1.9415575777E+01, 5.1293423834E+00, 5.3918825932E+00, 2.3152125593E+00, 9.0787201046E-01],
	[2.9050000000E+04, 1.9421053965E+01, 5.1293242381E+00, 5.3948715440E+00, 2.3158376868E+00, 9.0791568330E-01],
	[2.9055000000E+04, 1.9426532756E+01, 5.1293060960E+00, 5.3978616354E+00, 2.3164627167E+00, 9.0795933482E-01],
	[2.9060000000E+04, 1.9432012149E+01, 5.1292879570E+00, 5.4008528677E+00, 2.3170876489E+00, 9.0800296502E-01],
	[2.9065000000E+04, 1.9437492145E+01, 5.1292698213E+00, 5.4038452411E+00, 2.3177124833E+00, 9.0804657393E-01],
	[2.9070000000E+04, 1.9442972743E+01, 5.1292516887E+00, 5.4068387560E+00, 2.3183372199E+00, 9.0809016154E-01],
	[2.9075000000E+04, 1.9448453944E+01, 5.1292335593E+00, 5.4098334125E+00, 2.3189618586E+00, 9.0813372787E-01],
	[2.9080000000E+04, 1.9453935747E+01, 5.1292154331E+00, 5.4128292108E+00, 2.3195863994E+00, 9.0817727293E-01],
	[2.9085000000E+04, 1.9459418152E+01, 5.1291973101E+00, 5.4158261512E+00, 2.3202108423E+00, 9.0822079673E-01],
	[2.9090000000E+04, 1.9464901159E+01, 5.1291791903E+00, 5.4188242340E+00, 2.3208351872E+00, 9.0826429927E-01],
	[2.9095000000E+04, 1.9470384768E+01, 5.1291610736E+00, 5.4218234594E+00, 2.3214594340E+00, 9.0830778056E-01],
	[2.9100000000E+04, 1.9475868980E+01, 5.1291429601E+00, 5.4248238276E+00, 2.3220835827E+00, 9.0835124062E-01],
	[2.9105000000E+04, 1.9481353794E+01, 5.1291248498E+00, 5.4278253388E+00, 2.3227076333E+00, 9.0839467946E-01],
	[2.9110000000E+04, 1.9486839210E+01, 5.1291067427E+00, 5.4308279933E+00, 2.3233315857E+00, 9.0843809708E-01],
	[2.9115000000E+04, 1.9492325228E+01, 5.1290886387E+00, 5.4338317914E+00, 2.3239554398E+00, 9.0848149349E-01],
	[2.9120000000E+04, 1.9497811847E+01, 5.1290705379E+00, 5.4368367332E+00, 2.3245791956E+00, 9.0852486871E-01],
	[2.9125000000E+04, 1.9503299069E+01, 5.1290524403E+00, 5.4398428190E+00, 2.3252028531E+00, 9.0856822273E-01],
	[2.9130000000E+04, 1.9508786893E+01, 5.1290343459E+00, 5.4428500491E+00, 2.3258264122E+00, 9.0861155558E-01],
	[2.9135000000E+04, 1.9514275319E+01, 5.1290162546E+00, 5.4458584237E+00, 2.3264498728E+00, 9.0865486728E-01],
	[2.9140000000E+04, 1.9519764346E+01, 5.1289981665E+00, 5.4488679429E+00, 2.3270732350E+00, 9.0869815786E-01],
	[2.9145000000E+04, 1.9525253975E+01, 5.1289800815E+00, 5.4518786072E+00, 2.3276964986E+00, 9.0874142732E-01],
	[2.9150000000E+04, 1.9530744206E+01, 5.1289619998E+00, 5.4548904166E+00, 2.3283196636E+00, 9.0878467566E-01],
	[2.9155000000E+04, 1.9536235039E+01, 5.1289439211E+00, 5.4579033715E+00, 2.3289427300E+00, 9.0882790291E-01],
	[2.9160000000E+04, 1.9541726474E+01, 5.1289258457E+00, 5.4609174720E+00, 2.3295656977E+00, 9.0887110906E-01],
	[2.9165000000E+04, 1.9547218510E+01, 5.1289077734E+00, 5.4639327185E+00, 2.3301885666E+00, 9.0891429412E-01],
	[2.9170000000E+04, 1.9552711148E+01, 5.1288897043E+00, 5.4669491111E+00, 2.3308113368E+00, 9.0895745810E-01],
	[2.9175000000E+04, 1.9558204387E+01, 5.1288716383E+00, 5.4699666501E+00, 2.3314340082E+00, 9.0900060102E-01],
	[2.9180000000E+04, 1.9563698228E+01, 5.1288535755E+00, 5.4729853358E+00, 2.3320565806E+00, 9.0904372287E-01],
	[2.9185000000E+04, 1.9569192671E+01, 5.1288355159E+00, 5.4760051683E+00, 2.3326790542E+00, 9.0908682367E-01],
	[2.9190000000E+04, 1.9574687715E+01, 5.1288174594E+00, 5.4790261479E+00, 2.3333014288E+00, 9.0912990343E-01],
	[2.9195000000E+04, 1.9580183360E+01, 5.1287994061E+00, 5.4820482748E+00, 2.3339237043E+00, 9.0917296215E-01],
	[2.9200000000E+04, 1.9585679607E+01, 5.1287813559E+00, 5.4850715493E+00, 2.3345458808E+00, 9.0921599984E-01],
	[2.9205000000E+04, 1.9591176455E+01, 5.1287633089E+00, 5.4880959717E+00, 2.3351679582E+00, 9.0925901651E-01],
	[2.9210000000E+04, 1.9596673904E+01, 5.1287452650E+00, 5.4911215421E+00, 2.3357899364E+00, 9.0930201217E-01],
	[2.9215000000E+04, 1.9602171955E+01, 5.1287272243E+00, 5.4941482608E+00, 2.3364118154E+00, 9.0934498682E-01],
	[2.9220000000E+04, 1.9607670607E+01, 5.1287091867E+00, 5.4971761280E+00, 2.3370335952E+00, 9.0938794048E-01],
	[2.9225000000E+04, 1.9613169861E+01, 5.1286911523E+00, 5.5002051440E+00, 2.3376552756E+00, 9.0943087315E-01],
	[2.9230000000E+04, 1.9618669715E+01, 5.1286731210E+00, 5.5032353090E+00, 2.3382768567E+00, 9.0947378484E-01],
	[2.9235000000E+04, 1.9624170171E+01, 5.1286550929E+00, 5.5062666233E+00, 2.3388983384E+00, 9.0951667556E-01],
	[2.9240000000E+04, 1.9629671227E+01, 5.1286370679E+00, 5.5092990871E+00, 2.3395197207E+00, 9.0955954532E-01],
	[2.9245000000E+04, 1.9635172885E+01, 5.1286190461E+00, 5.5123327005E+00, 2.3401410034E+00, 9.0960239413E-01],
	[2.9250000000E+04, 1.9640675144E+01, 5.1286010274E+00, 5.5153674640E+00, 2.3407621866E+00, 9.0964522199E-01],
	[2.9255000000E+04, 1.9646178004E+01, 5.1285830119E+00, 5.5184033776E+00, 2.3413832703E+00, 9.0968802891E-01],
	[2.9260000000E+04, 1.9651681464E+01, 5.1285649995E+00, 5.5214404417E+00, 2.3420042543E+00, 9.0973081491E-01],
	[2.9265000000E+04, 1.9657185526E+01, 5.1285469902E+00, 5.5244786565E+00, 2.3426251386E+00, 9.0977357998E-01],
	[2.9270000000E+04, 1.9662690189E+01, 5.1285289841E+00, 5.5275180222E+00, 2.3432459232E+00, 9.0981632414E-01],
	[2.9275000000E+04, 1.9668195452E+01, 5.1285109811E+00, 5.5305585390E+00, 2.3438666080E+00, 9.0985904739E-01],
	[2.9280000000E+04, 1.9673701316E+01, 5.1284929813E+00, 5.5336002073E+00, 2.3444871930E+00, 9.0990174976E-01],
	[2.9285000000E+04, 1.9679207781E+01, 5.1284749846E+00, 5.5366430272E+00, 2.3451076781E+00, 9.0994443123E-01],
	[2.9290000000E+04, 1.9684714847E+01, 5.1284569910E+00, 5.5396869989E+00, 2.3457280633E+00, 9.0998709182E-01],
	[2.9295000000E+04, 1.9690222514E+01, 5.1284390006E+00, 5.5427321228E+00, 2.3463483486E+00, 9.1002973154E-01],
	[2.9300000000E+04, 1.9695730781E+01, 5.1284210133E+00, 5.5457783990E+00, 2.3469685338E+00, 9.1007235040E-01],
	[2.9305000000E+04, 1.9701239648E+01, 5.1284030291E+00, 5.5488258278E+00, 2.3475886190E+00, 9.1011494841E-01],
	[2.9310000000E+04, 1.9706749117E+01, 5.1283850481E+00, 5.5518744094E+00, 2.3482086041E+00, 9.1015752557E-01],
	[2.9315000000E+04, 1.9712259186E+01, 5.1283670701E+00, 5.5549241441E+00, 2.3488284891E+00, 9.1020008190E-01],
	[2.9320000000E+04, 1.9717769855E+01, 5.1283490954E+00, 5.5579750321E+00, 2.3494482738E+00, 9.1024261739E-01],
	[2.9325000000E+04, 1.9723281125E+01, 5.1283311237E+00, 5.5610270736E+00, 2.3500679584E+00, 9.1028513206E-01],
	[2.9330000000E+04, 1.9728792995E+01, 5.1283131552E+00, 5.5640802689E+00, 2.3506875426E+00, 9.1032762592E-01],
	[2.9335000000E+04, 1.9734305466E+01, 5.1282951898E+00, 5.5671346182E+00, 2.3513070265E+00, 9.1037009898E-01],
	[2.9340000000E+04, 1.9739818537E+01, 5.1282772275E+00, 5.5701901218E+00, 2.3519264101E+00, 9.1041255124E-01],
	[2.9345000000E+04, 1.9745332208E+01, 5.1282592684E+00, 5.5732467799E+00, 2.3525456932E+00, 9.1045498272E-01],
	[2.9350000000E+04, 1.9750846480E+01, 5.1282413123E+00, 5.5763045927E+00, 2.3531648759E+00, 9.1049739341E-01],
	[2.9355000000E+04, 1.9756361352E+01, 5.1282233594E+00, 5.5793635605E+00, 2.3537839580E+00, 9.1053978334E-01],
	[2.9360000000E+04, 1.9761876824E+01, 5.1282054097E+00, 5.5824236835E+00, 2.3544029396E+00, 9.1058215250E-01],
	[2.9365000000E+04, 1.9767392896E+01, 5.1281874630E+00, 5.5854849620E+00, 2.3550218206E+00, 9.1062450091E-01],
	[2.9370000000E+04, 1.9772909569E+01, 5.1281695194E+00, 5.5885473961E+00, 2.3556406009E+00, 9.1066682858E-01],
	[2.9375000000E+04, 1.9778426842E+01, 5.1281515790E+00, 5.5916109862E+00, 2.3562592806E+00, 9.1070913551E-01],
	[2.9380000000E+04, 1.9783944714E+01, 5.1281336417E+00, 5.5946757324E+00, 2.3568778595E+00, 9.1075142171E-01],
	[2.9385000000E+04, 1.9789463187E+01, 5.1281157075E+00, 5.5977416350E+00, 2.3574963376E+00, 9.1079368719E-01],
	[2.9390000000E+04, 1.9794982260E+01, 5.1280977764E+00, 5.6008086943E+00, 2.3581147149E+00, 9.1083593196E-01],
	[2.9395000000E+04, 1.9800501932E+01, 5.1280798484E+00, 5.6038769105E+00, 2.3587329913E+00, 9.1087815602E-01],
	[2.9400000000E+04, 1.9806022205E+01, 5.1280619236E+00, 5.6069462838E+00, 2.3593511668E+00, 9.1092035939E-01],
	[2.9405000000E+04, 1.9811543077E+01, 5.1280440018E+00, 5.6100168144E+00, 2.3599692413E+00, 9.1096254208E-01],
	[2.9410000000E+04, 1.9817064550E+01, 5.1280260832E+00, 5.6130885027E+00, 2.3605872149E+00, 9.1100470408E-01],
	[2.9415000000E+04, 1.9822586622E+01, 5.1280081677E+00, 5.6161613487E+00, 2.3612050873E+00, 9.1104684542E-01],
	[2.9420000000E+04, 1.9828109294E+01, 5.1279902552E+00, 5.6192353529E+00, 2.3618228587E+00, 9.1108896610E-01],
	[2.9425000000E+04, 1.9833632566E+01, 5.1279723459E+00, 5.6223105154E+00, 2.3624405290E+00, 9.1113106612E-01],
	[2.9430000000E+04, 1.9839156437E+01, 5.1279544397E+00, 5.6253868364E+00, 2.3630580980E+00, 9.1117314550E-01],
	[2.9435000000E+04, 1.9844685740E+01, 5.1279372782E+00, 5.6284643162E+00, 2.3636757919E+00, 9.1121520425E-01],
	[2.9440000000E+04, 1.9850231951E+01, 5.1279226211E+00, 5.6315429550E+00, 2.3642941478E+00, 9.1125724236E-01],
	[2.9445000000E+04, 1.9855778769E+01, 5.1279079665E+00, 5.6346227531E+00, 2.3649124031E+00, 9.1129925986E-01],
	[2.9450000000E+04, 1.9861326195E+01, 5.1278933145E+00, 5.6377037108E+00, 2.3655305577E+00, 9.1134125675E-01],
	[2.9455000000E+04, 1.9866874228E+01, 5.1278786649E+00, 5.6407858281E+00, 2.3661486116E+00, 9.1138323304E-01],
	[2.9460000000E+04, 1.9872422869E+01, 5.1278640180E+00, 5.6438691055E+00, 2.3667665647E+00, 9.1142518873E-01],
	[2.9465000000E+04, 1.9877972118E+01, 5.1278493735E+00, 5.6469535430E+00, 2.3673844171E+00, 9.1146712384E-01],
	[2.9470000000E+04, 1.9883521975E+01, 5.1278347316E+00, 5.6500391411E+00, 2.3680021686E+00, 9.1150903837E-01],
	[2.9475000000E+04, 1.9889072439E+01, 5.1278200922E+00, 5.6531258998E+00, 2.3686198192E+00, 9.1155093234E-01],
	[2.9480000000E+04, 1.9894623510E+01, 5.1278054553E+00, 5.6562138195E+00, 2.3692373689E+00, 9.1159280575E-01],
	[2.9485000000E+04, 1.9900175189E+01, 5.1277908209E+00, 5.6593029004E+00, 2.3698548176E+00, 9.1163465860E-01],
	[2.9490000000E+04, 1.9905727476E+01, 5.1277761891E+00, 5.6623931426E+00, 2.3704721653E+00, 9.1167649091E-01],
	[2.9495000000E+04, 1.9911280370E+01, 5.1277615598E+00, 5.6654845466E+00, 2.3710894120E+00, 9.1171830269E-01],
	[2.9500000000E+04, 1.9916833871E+01, 5.1277469330E+00, 5.6685771124E+00, 2.3717065575E+00, 9.1176009395E-01],
	[2.9505000000E+04, 1.9922387980E+01, 5.1277323087E+00, 5.6716708403E+00, 2.3723236019E+00, 9.1180186468E-01],
	[2.9510000000E+04, 1.9927942696E+01, 5.1277176870E+00, 5.6747657307E+00, 2.3729405451E+00, 9.1184361491E-01],
	[2.9515000000E+04, 1.9933498019E+01, 5.1277030677E+00, 5.6778617836E+00, 2.3735573871E+00, 9.1188534464E-01],
	[2.9520000000E+04, 1.9939053950E+01, 5.1276884510E+00, 5.6809589994E+00, 2.3741741277E+00, 9.1192705388E-01],
	[2.9525000000E+04, 1.9944610488E+01, 5.1276738368E+00, 5.6840573783E+00, 2.3747907671E+00, 9.1196874263E-01],
	[2.9530000000E+04, 1.9950167633E+01, 5.1276592252E+00, 5.6871569205E+00, 2.3754073051E+00, 9.1201041091E-01],
	[2.9535000000E+04, 1.9955725385E+01, 5.1276446160E+00, 5.6902576263E+00, 2.3760237417E+00, 9.1205205873E-01],
	[2.9540000000E+04, 1.9961283744E+01, 5.1276300093E+00, 5.6933594959E+00, 2.3766400768E+00, 9.1209368609E-01],
	[2.9545000000E+04, 1.9966842710E+01, 5.1276154052E+00, 5.6964625295E+00, 2.3772563104E+00, 9.1213529300E-01],
	[2.9550000000E+04, 1.9972402284E+01, 5.1276008036E+00, 5.6995667274E+00, 2.3778724425E+00, 9.1217687947E-01],
	[2.9555000000E+04, 1.9977962464E+01, 5.1275862045E+00, 5.7026720899E+00, 2.3784884730E+00, 9.1221844550E-01],
	[2.9560000000E+04, 1.9983523251E+01, 5.1275716079E+00, 5.7057786171E+00, 2.3791044019E+00, 9.1225999112E-01],
	[2.9565000000E+04, 1.9989084645E+01, 5.1275570138E+00, 5.7088863093E+00, 2.3797202291E+00, 9.1230151632E-01],
	[2.9570000000E+04, 1.9994646646E+01, 5.1275424222E+00, 5.7119951667E+00, 2.3803359546E+00, 9.1234302111E-01],
	[2.9575000000E+04, 2.0000209254E+01, 5.1275278331E+00, 5.7151051896E+00, 2.3809515783E+00, 9.1238450551E-01],
	[2.9580000000E+04, 2.0005772469E+01, 5.1275132466E+00, 5.7182163783E+00, 2.3815671003E+00, 9.1242596952E-01],
	[2.9585000000E+04, 2.0011336290E+01, 5.1274986625E+00, 5.7213287328E+00, 2.3821825204E+00, 9.1246741315E-01],
	[2.9590000000E+04, 2.0016900718E+01, 5.1274840810E+00, 5.7244422536E+00, 2.3827978386E+00, 9.1250883640E-01],
	[2.9595000000E+04, 2.0022465753E+01, 5.1274695019E+00, 5.7275569409E+00, 2.3834130548E+00, 9.1255023930E-01],
	[2.9600000000E+04, 2.0028031395E+01, 5.1274549254E+00, 5.7306727948E+00, 2.3840281692E+00, 9.1259162184E-01],
	[2.9605000000E+04, 2.0033597643E+01, 5.1274403513E+00, 5.7337898156E+00, 2.3846431815E+00, 9.1263298403E-01],
	[2.9610000000E+04, 2.0039164498E+01, 5.1274257798E+00, 5.7369080035E+00, 2.3852580917E+00, 9.1267432588E-01],
	[2.9615000000E+04, 2.0044731959E+01, 5.1274112108E+00, 5.7400273589E+00, 2.3858728998E+00, 9.1271564741E-01],
	[2.9620000000E+04, 2.0050300027E+01, 5.1273966442E+00, 5.7431478818E+00, 2.3864876058E+00, 9.1275694862E-01],
	[2.9625000000E+04, 2.0055868701E+01, 5.1273820802E+00, 5.7462695727E+00, 2.3871022097E+00, 9.1279822951E-01],
	[2.9630000000E+04, 2.0061437982E+01, 5.1273675187E+00, 5.7493924317E+00, 2.3877167113E+00, 9.1283949010E-01],
	[2.9635000000E+04, 2.0067007869E+01, 5.1273529596E+00, 5.7525164590E+00, 2.3883311106E+00, 9.1288073040E-01],
	[2.9640000000E+04, 2.0072578362E+01, 5.1273384031E+00, 5.7556416548E+00, 2.3889454076E+00, 9.1292195041E-01],
	[2.9645000000E+04, 2.0078149462E+01, 5.1273238491E+00, 5.7587680195E+00, 2.3895596023E+00, 9.1296315015E-01],
	[2.9650000000E+04, 2.0083721168E+01, 5.1273092975E+00, 5.7618955533E+00, 2.3901736946E+00, 9.1300432961E-01],
	[2.9655000000E+04, 2.0089293481E+01, 5.1272947485E+00, 5.7650242564E+00, 2.3907876844E+00, 9.1304548882E-01],
	[2.9660000000E+04, 2.0094866400E+01, 5.1272802019E+00, 5.7681541290E+00, 2.3914015717E+00, 9.1308662777E-01],
	[2.9665000000E+04, 2.0100439924E+01, 5.1272656579E+00, 5.7712851714E+00, 2.3920153566E+00, 9.1312774648E-01],
	[2.9670000000E+04, 2.0106014055E+01, 5.1272511163E+00, 5.7744173838E+00, 2.3926290389E+00, 9.1316884496E-01],
	[2.9675000000E+04, 2.0111588792E+01, 5.1272365772E+00, 5.7775507665E+00, 2.3932426185E+00, 9.1320992321E-01],
	[2.9680000000E+04, 2.0117164136E+01, 5.1272220406E+00, 5.7806853197E+00, 2.3938560956E+00, 9.1325098125E-01],
	[2.9685000000E+04, 2.0122740085E+01, 5.1272075065E+00, 5.7838210436E+00, 2.3944694699E+00, 9.1329201907E-01],
	[2.9690000000E+04, 2.0128316640E+01, 5.1271929749E+00, 5.7869579385E+00, 2.3950827415E+00, 9.1333303670E-01],
	[2.9695000000E+04, 2.0133893801E+01, 5.1271784458E+00, 5.7900960046E+00, 2.3956959104E+00, 9.1337403413E-01],
	[2.9700000000E+04, 2.0139471569E+01, 5.1271639192E+00, 5.7932352422E+00, 2.3963089764E+00, 9.1341501139E-01],
	[2.9705000000E+04, 2.0145049942E+01, 5.1271493950E+00, 5.7963756514E+00, 2.3969219396E+00, 9.1345596846E-01],
	[2.9710000000E+04, 2.0150628920E+01, 5.1271348734E+00, 5.7995172326E+00, 2.3975347999E+00, 9.1349690538E-01],
	[2.9715000000E+04, 2.0156208505E+01, 5.1271203542E+00, 5.8026599860E+00, 2.3981475573E+00, 9.1353782213E-01],
	[2.9720000000E+04, 2.0161788696E+01, 5.1271058375E+00, 5.8058039117E+00, 2.3987602116E+00, 9.1357871874E-01],
	[2.9725000000E+04, 2.0167369492E+01, 5.1270913233E+00, 5.8089490102E+00, 2.3993727630E+00, 9.1361959521E-01],
	[2.9730000000E+04, 2.0172950894E+01, 5.1270768116E+00, 5.8120952815E+00, 2.3999852113E+00, 9.1366045155E-01],
	[2.9735000000E+04, 2.0178532902E+01, 5.1270623023E+00, 5.8152427259E+00, 2.4005975565E+00, 9.1370128777E-01],
	[2.9740000000E+04, 2.0184115515E+01, 5.1270477955E+00, 5.8183913437E+00, 2.4012097986E+00, 9.1374210387E-01],
	[2.9745000000E+04, 2.0189698734E+01, 5.1270332913E+00, 5.8215411351E+00, 2.4018219375E+00, 9.1378289987E-01],
	[2.9750000000E+04, 2.0195282559E+01, 5.1270187895E+00, 5.8246921004E+00, 2.4024339731E+00, 9.1382367577E-01],
	[2.9755000000E+04, 2.0200866989E+01, 5.1270042901E+00, 5.8278442398E+00, 2.4030459056E+00, 9.1386443159E-01],
	[2.9760000000E+04, 2.0206452024E+01, 5.1269897933E+00, 5.8309975534E+00, 2.4036577347E+00, 9.1390516732E-01],
	[2.9765000000E+04, 2.0212037665E+01, 5.1269752989E+00, 5.8341520417E+00, 2.4042694604E+00, 9.1394588299E-01],
	[2.9770000000E+04, 2.0217623912E+01, 5.1269608070E+00, 5.8373077047E+00, 2.4048810828E+00, 9.1398657860E-01],
	[2.9775000000E+04, 2.0223210764E+01, 5.1269463176E+00, 5.8404645428E+00, 2.4054926017E+00, 9.1402725415E-01],
	[2.9780000000E+04, 2.0228798221E+01, 5.1269318306E+00, 5.8436225562E+00, 2.4061040172E+00, 9.1406790966E-01],
	[2.9785000000E+04, 2.0234386283E+01, 5.1269173462E+00, 5.8467817450E+00, 2.4067153292E+00, 9.1410854513E-01],
	[2.9790000000E+04, 2.0239974951E+01, 5.1269028642E+00, 5.8499421097E+00, 2.4073265376E+00, 9.1414916057E-01],
	[2.9795000000E+04, 2.0245564224E+01, 5.1268883846E+00, 5.8531036503E+00, 2.4079376425E+00, 9.1418975600E-01],
	[2.9800000000E+04, 2.0251154103E+01, 5.1268739076E+00, 5.8562663672E+00, 2.4085486437E+00, 9.1423033142E-01],
	[2.9805000000E+04, 2.0256744586E+01, 5.1268594330E+00, 5.8594302606E+00, 2.4091595412E+00, 9.1427088684E-01],
	[2.9810000000E+04, 2.0262335675E+01, 5.1268449608E+00, 5.8625953307E+00, 2.4097703351E+00, 9.1431142226E-01],
	[2.9815000000E+04, 2.0267927368E+01, 5.1268304912E+00, 5.8657615777E+00, 2.4103810252E+00, 9.1435193771E-01],
	[2.9820000000E+04, 2.0273519667E+01, 5.1268160240E+00, 5.8689290020E+00, 2.4109916115E+00, 9.1439243317E-01],
	[2.9825000000E+04, 2.0279112571E+01, 5.1268015593E+00, 5.8720976036E+00, 2.4116020940E+00, 9.1443290868E-01],
	[2.9830000000E+04, 2.0284706080E+01, 5.1267870970E+00, 5.8752673830E+00, 2.4122124726E+00, 9.1447336422E-01],
	[2.9835000000E+04, 2.0290300194E+01, 5.1267726372E+00, 5.8784383402E+00, 2.4128227473E+00, 9.1451379982E-01],
	[2.9840000000E+04, 2.0295894912E+01, 5.1267581799E+00, 5.8816104757E+00, 2.4134329180E+00, 9.1455421547E-01],
	[2.9845000000E+04, 2.0301490236E+01, 5.1267437250E+00, 5.8847837895E+00, 2.4140429848E+00, 9.1459461120E-01],
	[2.9850000000E+04, 2.0307086164E+01, 5.1267292726E+00, 5.8879582819E+00, 2.4146529476E+00, 9.1463498700E-01],
	[2.9855000000E+04, 2.0312682698E+01, 5.1267148227E+00, 5.8911339532E+00, 2.4152628063E+00, 9.1467534289E-01],
	[2.9860000000E+04, 2.0318279836E+01, 5.1267003752E+00, 5.8943108037E+00, 2.4158725609E+00, 9.1471567887E-01],
	[2.9865000000E+04, 2.0323877578E+01, 5.1266859302E+00, 5.8974888334E+00, 2.4164822113E+00, 9.1475599496E-01],
	[2.9870000000E+04, 2.0329475926E+01, 5.1266714876E+00, 5.9006680428E+00, 2.4170917576E+00, 9.1479629116E-01],
	[2.9875000000E+04, 2.0335074878E+01, 5.1266570475E+00, 5.9038484320E+00, 2.4177011996E+00, 9.1483656748E-01],
	[2.9880000000E+04, 2.0340674435E+01, 5.1266426099E+00, 5.9070300013E+00, 2.4183105374E+00, 9.1487682393E-01],
	[2.9885000000E+04, 2.0346274596E+01, 5.1266281747E+00, 5.9102127509E+00, 2.4189197708E+00, 9.1491706052E-01],
	[2.9890000000E+04, 2.0351875362E+01, 5.1266137419E+00, 5.9133966810E+00, 2.4195289000E+00, 9.1495727726E-01],
	[2.9895000000E+04, 2.0357476733E+01, 5.1265993117E+00, 5.9165817919E+00, 2.4201379247E+00, 9.1499747415E-01],
	[2.9900000000E+04, 2.0363078708E+01, 5.1265848838E+00, 5.9197680838E+00, 2.4207468451E+00, 9.1503765121E-01],
	[2.9905000000E+04, 2.0368681287E+01, 5.1265704585E+00, 5.9229555571E+00, 2.4213556610E+00, 9.1507780844E-01],
	[2.9910000000E+04, 2.0374294141E+01, 5.1265575005E+00, 5.9261442118E+00, 2.4219648360E+00, 9.1511794585E-01],
	[2.9915000000E+04, 2.0379918973E+01, 5.1265462668E+00, 5.9293340482E+00, 2.4225744519E+00, 9.1515806345E-01],
	[2.9920000000E+04, 2.0385544416E+01, 5.1265350350E+00, 5.9325250667E+00, 2.4231839640E+00, 9.1519816126E-01],
	[2.9925000000E+04, 2.0391170473E+01, 5.1265238051E+00, 5.9357172673E+00, 2.4237933722E+00, 9.1523823927E-01],
	[2.9930000000E+04, 2.0396797141E+01, 5.1265125771E+00, 5.9389106505E+00, 2.4244026764E+00, 9.1527829750E-01],
	[2.9935000000E+04, 2.0402424422E+01, 5.1265013510E+00, 5.9421052163E+00, 2.4250118766E+00, 9.1531833595E-01],
	[2.9940000000E+04, 2.0408052316E+01, 5.1264901268E+00, 5.9453009651E+00, 2.4256209728E+00, 9.1535835464E-01],
	[2.9945000000E+04, 2.0413680821E+01, 5.1264789045E+00, 5.9484978971E+00, 2.4262299649E+00, 9.1539835357E-01],
	[2.9950000000E+04, 2.0419309939E+01, 5.1264676841E+00, 5.9516960125E+00, 2.4268388528E+00, 9.1543833276E-01],
	[2.9955000000E+04, 2.0424939669E+01, 5.1264564656E+00, 5.9548953115E+00, 2.4274476366E+00, 9.1547829220E-01],
	[2.9960000000E+04, 2.0430570011E+01, 5.1264452490E+00, 5.9580957944E+00, 2.4280563163E+00, 9.1551823192E-01],
	[2.9965000000E+04, 2.0436200965E+01, 5.1264340343E+00, 5.9612974615E+00, 2.4286648916E+00, 9.1555815191E-01],
	[2.9970000000E+04, 2.0441832531E+01, 5.1264228215E+00, 5.9645003130E+00, 2.4292733627E+00, 9.1559805219E-01],
	[2.9975000000E+04, 2.0447464709E+01, 5.1264116106E+00, 5.9677043491E+00, 2.4298817295E+00, 9.1563793277E-01],
	[2.9980000000E+04, 2.0453097500E+01, 5.1264004015E+00, 5.9709095701E+00, 2.4304899919E+00, 9.1567779365E-01],
	[2.9985000000E+04, 2.0458730902E+01, 5.1263891944E+00, 5.9741159761E+00, 2.4310981500E+00, 9.1571763484E-01],
	[2.9990000000E+04, 2.0464364916E+01, 5.1263779892E+00, 5.9773235675E+00, 2.4317062036E+00, 9.1575745636E-01],
	[2.9995000000E+04, 2.0469999542E+01, 5.1263667858E+00, 5.9805323445E+00, 2.4323141528E+00, 9.1579725821E-01],
	[3.0000000000E+04, 2.0475634780E+01, 5.1263555843E+00, 5.9837423073E+00, 2.4329219974E+00, 9.1583704040E-01],
	[3.0005000000E+04, 2.0481270630E+01, 5.1263443848E+00, 5.9869734972E+00, 2.4335330487E+00, 9.1587680293E-01],
	[3.0010000000E+04, 2.0486907091E+01, 5.1263331871E+00, 5.9902058917E+00, 2.4341439947E+00, 9.1591654582E-01],
	[3.0015000000E+04, 2.0492544165E+01, 5.1263219913E+00, 5.9934394909E+00, 2.4347548352E+00, 9.1595626908E-01],
	[3.0020000000E+04, 2.0498181849E+01, 5.1263107974E+00, 5.9966742952E+00, 2.4353655702E+00, 9.1599597271E-01],
	[3.0025000000E+04, 2.0503820146E+01, 5.1262996054E+00, 5.9999103046E+00, 2.4359761997E+00, 9.1603565673E-01],
	[3.0030000000E+04, 2.0509459054E+01, 5.1262884153E+00, 6.0031475196E+00, 2.4365867237E+00, 9.1607532114E-01],
	[3.0035000000E+04, 2.0515098574E+01, 5.1262772271E+00, 6.0063859404E+00, 2.4371971422E+00, 9.1611496595E-01],
	[3.0040000000E+04, 2.0520738706E+01, 5.1262660407E+00, 6.0096255671E+00, 2.4378074550E+00, 9.1615459117E-01],
	[3.0045000000E+04, 2.0526379449E+01, 5.1262548563E+00, 6.0128664000E+00, 2.4384176622E+00, 9.1619419681E-01],
	[3.0050000000E+04, 2.0532020803E+01, 5.1262436737E+00, 6.0161084395E+00, 2.4390277637E+00, 9.1623378287E-01],
	[3.0055000000E+04, 2.0537662769E+01, 5.1262324930E+00, 6.0193516857E+00, 2.4396377594E+00, 9.1627334938E-01],
	[3.0060000000E+04, 2.0543305347E+01, 5.1262213142E+00, 6.0225961388E+00, 2.4402476494E+00, 9.1631289632E-01],
	[3.0065000000E+04, 2.0548948536E+01, 5.1262101373E+00, 6.0258417992E+00, 2.4408574336E+00, 9.1635242372E-01],
	[3.0070000000E+04, 2.0554592336E+01, 5.1261989623E+00, 6.0290886671E+00, 2.4414671120E+00, 9.1639193159E-01],
	[3.0075000000E+04, 2.0560236747E+01, 5.1261877891E+00, 6.0323367427E+00, 2.4420766844E+00, 9.1643141992E-01],
	[3.0080000000E+04, 2.0565881770E+01, 5.1261766178E+00, 6.0355860263E+00, 2.4426861510E+00, 9.1647088874E-01],
	[3.0085000000E+04, 2.0571527404E+01, 5.1261654484E+00, 6.0388365181E+00, 2.4432955116E+00, 9.1651033804E-01],
	[3.0090000000E+04, 2.0577173650E+01, 5.1261542809E+00, 6.0420882183E+00, 2.4439047662E+00, 9.1654976784E-01],
	[3.0095000000E+04, 2.0582820506E+01, 5.1261431153E+00, 6.0453411273E+00, 2.4445139148E+00, 9.1658917815E-01],
	[3.0100000000E+04, 2.0588467974E+01, 5.1261319516E+00, 6.0485952452E+00, 2.4451229573E+00, 9.1662856897E-01],
	[3.0105000000E+04, 2.0594116052E+01, 5.1261207897E+00, 6.0518505724E+00, 2.4457318937E+00, 9.1666794032E-01],
	[3.0110000000E+04, 2.0599764742E+01, 5.1261096297E+00, 6.0551071090E+00, 2.4463407239E+00, 9.1670729220E-01],
	[3.0115000000E+04, 2.0605414043E+01, 5.1260984716E+00, 6.0583648553E+00, 2.4469494480E+00, 9.1674662462E-01],
	[3.0120000000E+04, 2.0611063955E+01, 5.1260873153E+00, 6.0616238116E+00, 2.4475580659E+00, 9.1678593760E-01],
	[3.0125000000E+04, 2.0616714478E+01, 5.1260761610E+00, 6.0648839780E+00, 2.4481665775E+00, 9.1682523113E-01],
	[3.0130000000E+04, 2.0622365612E+01, 5.1260650085E+00, 6.0681453549E+00, 2.4487749828E+00, 9.1686450523E-01],
	[3.0135000000E+04, 2.0628017356E+01, 5.1260538579E+00, 6.0714079425E+00, 2.4493832817E+00, 9.1690375990E-01],
	[3.0140000000E+04, 2.0633669712E+01, 5.1260427091E+00, 6.0746717411E+00, 2.4499914744E+00, 9.1694299517E-01],
	[3.0145000000E+04, 2.0639322678E+01, 5.1260315623E+00, 6.0779367508E+00, 2.4505995606E+00, 9.1698221102E-01],
	[3.0150000000E+04, 2.0644976255E+01, 5.1260204173E+00, 6.0812029720E+00, 2.4512075403E+00, 9.1702140748E-01],
	[3.0155000000E+04, 2.0650630443E+01, 5.1260092741E+00, 6.0844704048E+00, 2.4518154136E+00, 9.1706058456E-01],
	[3.0160000000E+04, 2.0656285242E+01, 5.1259981329E+00, 6.0877390496E+00, 2.4524231804E+00, 9.1709974225E-01],
	[3.0165000000E+04, 2.0661940651E+01, 5.1259869935E+00, 6.0910089066E+00, 2.4530308406E+00, 9.1713888057E-01],
	[3.0170000000E+04, 2.0667596671E+01, 5.1259758560E+00, 6.0942799760E+00, 2.4536383942E+00, 9.1717799953E-01],
	[3.0175000000E+04, 2.0673253302E+01, 5.1259647204E+00, 6.0975522581E+00, 2.4542458412E+00, 9.1721709914E-01],
	[3.0180000000E+04, 2.0678910543E+01, 5.1259535866E+00, 6.1008257531E+00, 2.4548531816E+00, 9.1725617941E-01],
	[3.0185000000E+04, 2.0684568395E+01, 5.1259424547E+00, 6.1041004613E+00, 2.4554604152E+00, 9.1729524034E-01],
	[3.0190000000E+04, 2.0690226857E+01, 5.1259313247E+00, 6.1073763829E+00, 2.4560675421E+00, 9.1733428194E-01],
	[3.0195000000E+04, 2.0695885930E+01, 5.1259201965E+00, 6.1106535181E+00, 2.4566745622E+00, 9.1737330423E-01],
	[3.0200000000E+04, 2.0701545613E+01, 5.1259090702E+00, 6.1139318673E+00, 2.4572814756E+00, 9.1741230721E-01],
	[3.0205000000E+04, 2.0707205907E+01, 5.1258979458E+00, 6.1172114306E+00, 2.4578882820E+00, 9.1745129089E-01],
	[3.0210000000E+04, 2.0712866811E+01, 5.1258868232E+00, 6.1204922084E+00, 2.4584949816E+00, 9.1749025528E-01],
	[3.0215000000E+04, 2.0718528325E+01, 5.1258757025E+00, 6.1237742008E+00, 2.4591015743E+00, 9.1752920038E-01],
	[3.0220000000E+04, 2.0724190449E+01, 5.1258645837E+00, 6.1270574081E+00, 2.4597080600E+00, 9.1756812622E-01],
	[3.0225000000E+04, 2.0729853184E+01, 5.1258534667E+00, 6.1303418306E+00, 2.4603144388E+00, 9.1760703278E-01],
	[3.0230000000E+04, 2.0735516529E+01, 5.1258423516E+00, 6.1336274684E+00, 2.4609207105E+00, 9.1764592010E-01],
	[3.0235000000E+04, 2.0741180485E+01, 5.1258312383E+00, 6.1369143220E+00, 2.4615268751E+00, 9.1768478816E-01],
	[3.0240000000E+04, 2.0746845050E+01, 5.1258201269E+00, 6.1402023914E+00, 2.4621329326E+00, 9.1772363699E-01],
	[3.0245000000E+04, 2.0752510226E+01, 5.1258090174E+00, 6.1434916769E+00, 2.4627388830E+00, 9.1776246659E-01],
	[3.0250000000E+04, 2.0758176011E+01, 5.1257979098E+00, 6.1467821789E+00, 2.4633447263E+00, 9.1780127697E-01],
	[3.0255000000E+04, 2.0763842407E+01, 5.1257868039E+00, 6.1500738975E+00, 2.4639504623E+00, 9.1784006814E-01],
	[3.0260000000E+04, 2.0769509413E+01, 5.1257757000E+00, 6.1533668329E+00, 2.4645560911E+00, 9.1787884011E-01],
	[3.0265000000E+04, 2.0775177029E+01, 5.1257645979E+00, 6.1566609855E+00, 2.4651616126E+00, 9.1791759288E-01],
	[3.0270000000E+04, 2.0780845254E+01, 5.1257534977E+00, 6.1599563555E+00, 2.4657670268E+00, 9.1795632646E-01],
	[3.0275000000E+04, 2.0786514090E+01, 5.1257423993E+00, 6.1632529432E+00, 2.4663723336E+00, 9.1799504088E-01],
	[3.0280000000E+04, 2.0792183535E+01, 5.1257313028E+00, 6.1665507487E+00, 2.4669775331E+00, 9.1803373612E-01],
	[3.0285000000E+04, 2.0797853591E+01, 5.1257202081E+00, 6.1698497723E+00, 2.4675826251E+00, 9.1807241221E-01],
	[3.0290000000E+04, 2.0803524256E+01, 5.1257091153E+00, 6.1731500143E+00, 2.4681876097E+00, 9.1811106914E-01],
	[3.0295000000E+04, 2.0809195531E+01, 5.1256980244E+00, 6.1764514749E+00, 2.4687924868E+00, 9.1814970694E-01],
	[3.0300000000E+04, 2.0814867415E+01, 5.1256869353E+00, 6.1797541544E+00, 2.4693972564E+00, 9.1818832560E-01],
	[3.0305000000E+04, 2.0820539910E+01, 5.1256758481E+00, 6.1830580531E+00, 2.4700019184E+00, 9.1822692514E-01],
	[3.0310000000E+04, 2.0826213014E+01, 5.1256647627E+00, 6.1863631711E+00, 2.4706064728E+00, 9.1826550557E-01],
	[3.0315000000E+04, 2.0831886727E+01, 5.1256536791E+00, 6.1896695087E+00, 2.4712109195E+00, 9.1830406689E-01],
	[3.0320000000E+04, 2.0837561051E+01, 5.1256425974E+00, 6.1929770661E+00, 2.4718152586E+00, 9.1834260912E-01],
	[3.0325000000E+04, 2.0843235983E+01, 5.1256315176E+00, 6.1962858437E+00, 2.4724194900E+00, 9.1838113225E-01],
	[3.0330000000E+04, 2.0848911526E+01, 5.1256204396E+00, 6.1995958416E+00, 2.4730236137E+00, 9.1841963631E-01],
	[3.0335000000E+04, 2.0854587678E+01, 5.1256093635E+00, 6.2029070602E+00, 2.4736276296E+00, 9.1845812130E-01],
	[3.0340000000E+04, 2.0860264439E+01, 5.1255982892E+00, 6.2062194995E+00, 2.4742315377E+00, 9.1849658723E-01],
	[3.0345000000E+04, 2.0865941810E+01, 5.1255872168E+00, 6.2095331600E+00, 2.4748353379E+00, 9.1853503411E-01],
	[3.0350000000E+04, 2.0871619790E+01, 5.1255761462E+00, 6.2128480419E+00, 2.4754390303E+00, 9.1857346194E-01],
	[3.0355000000E+04, 2.0877298379E+01, 5.1255650775E+00, 6.2161641453E+00, 2.4760426148E+00, 9.1861187074E-01],
	[3.0360000000E+04, 2.0882977578E+01, 5.1255540106E+00, 6.2194814706E+00, 2.4766460913E+00, 9.1865026051E-01],
	[3.0365000000E+04, 2.0888657386E+01, 5.1255429455E+00, 6.2228000180E+00, 2.4772494598E+00, 9.1868863127E-01],
	[3.0370000000E+04, 2.0894337803E+01, 5.1255318823E+00, 6.2261197877E+00, 2.4778527203E+00, 9.1872698302E-01],
	[3.0375000000E+04, 2.0900018830E+01, 5.1255208210E+00, 6.2294407800E+00, 2.4784558728E+00, 9.1876531577E-01],
	[3.0380000000E+04, 2.0905700466E+01, 5.1255097615E+00, 6.2327629952E+00, 2.4790589172E+00, 9.1880362953E-01],
	[3.0385000000E+04, 2.0911382710E+01, 5.1254987038E+00, 6.2360864334E+00, 2.4796618535E+00, 9.1884192430E-01],
	[3.0390000000E+04, 2.0917069007E+01, 5.1254881637E+00, 6.2394110950E+00, 2.4802648508E+00, 9.1888020011E-01],
	[3.0395000000E+04, 2.0922773338E+01, 5.1254802354E+00, 6.2427369801E+00, 2.4808685964E+00, 9.1891845695E-01],
	[3.0400000000E+04, 2.0928478286E+01, 5.1254723083E+00, 6.2460640891E+00, 2.4814722345E+00, 9.1895669484E-01],
	[3.0405000000E+04, 2.0934183851E+01, 5.1254643826E+00, 6.2493924222E+00, 2.4820757650E+00, 9.1899491378E-01],
	[3.0410000000E+04, 2.0939890033E+01, 5.1254564582E+00, 6.2527219796E+00, 2.4826791880E+00, 9.1903311379E-01],
	[3.0415000000E+04, 2.0945596832E+01, 5.1254485351E+00, 6.2560527615E+00, 2.4832825032E+00, 9.1907129486E-01],
	[3.0420000000E+04, 2.0951304248E+01, 5.1254406133E+00, 6.2593847683E+00, 2.4838857108E+00, 9.1910945702E-01],
	[3.0425000000E+04, 2.0957012281E+01, 5.1254326928E+00, 6.2627180002E+00, 2.4844888106E+00, 9.1914760027E-01],
	[3.0430000000E+04, 2.0962720930E+01, 5.1254247736E+00, 6.2660524574E+00, 2.4850918027E+00, 9.1918572461E-01],
	[3.0435000000E+04, 2.0968430196E+01, 5.1254168558E+00, 6.2693881401E+00, 2.4856946871E+00, 9.1922383006E-01],
	[3.0440000000E+04, 2.0974140079E+01, 5.1254089392E+00, 6.2727250487E+00, 2.4862974636E+00, 9.1926191663E-01],
	[3.0445000000E+04, 2.0979850578E+01, 5.1254010240E+00, 6.2760631833E+00, 2.4869001322E+00, 9.1929998433E-01],
	[3.0450000000E+04, 2.0985561694E+01, 5.1253931101E+00, 6.2794025442E+00, 2.4875026929E+00, 9.1933803315E-01],
	[3.0455000000E+04, 2.0991273426E+01, 5.1253851975E+00, 6.2827431317E+00, 2.4881051458E+00, 9.1937606312E-01],
	[3.0460000000E+04, 2.0996985776E+01, 5.1253772862E+00, 6.2860849460E+00, 2.4887074906E+00, 9.1941407425E-01],
	[3.0465000000E+04, 2.1002698741E+01, 5.1253693762E+00, 6.2894279874E+00, 2.4893097275E+00, 9.1945206653E-01],
	[3.0470000000E+04, 2.1008412323E+01, 5.1253614676E+00, 6.2927722560E+00, 2.4899118564E+00, 9.1949003998E-01],
	[3.0475000000E+04, 2.1014126522E+01, 5.1253535602E+00, 6.2961177522E+00, 2.4905138772E+00, 9.1952799461E-01],
	[3.0480000000E+04, 2.1019841337E+01, 5.1253456542E+00, 6.2994644763E+00, 2.4911157899E+00, 9.1956593043E-01],
	[3.0485000000E+04, 2.1025556768E+01, 5.1253377494E+00, 6.3028124283E+00, 2.4917175945E+00, 9.1960384744E-01],
	[3.0490000000E+04, 2.1031272816E+01, 5.1253298460E+00, 6.3061616087E+00, 2.4923192909E+00, 9.1964174566E-01],
	[3.0495000000E+04, 2.1036989480E+01, 5.1253219439E+00, 6.3095120176E+00, 2.4929208792E+00, 9.1967962509E-01],
	[3.0500000000E+04, 2.1042706760E+01, 5.1253140430E+00, 6.3128636553E+00, 2.4935223592E+00, 9.1971748575E-01],
	[3.0505000000E+04, 2.1048424656E+01, 5.1253061435E+00, 6.3162165220E+00, 2.4941237310E+00, 9.1975532763E-01],
	[3.0510000000E+04, 2.1054143169E+01, 5.1252982453E+00, 6.3195706180E+00, 2.4947249945E+00, 9.1979315076E-01],
	[3.0515000000E+04, 2.1059862298E+01, 5.1252903484E+00, 6.3229259436E+00, 2.4953261496E+00, 9.1983095514E-01],
	[3.0520000000E+04, 2.1065582043E+01, 5.1252824528E+00, 6.3262824990E+00, 2.4959271964E+00, 9.1986874077E-01],
	[3.0525000000E+04, 2.1071302404E+01, 5.1252745586E+00, 6.3296402844E+00, 2.4965281349E+00, 9.1990650767E-01],
	[3.0530000000E+04, 2.1077023381E+01, 5.1252666656E+00, 6.3329993000E+00, 2.4971289649E+00, 9.1994425585E-01],
	[3.0535000000E+04, 2.1082744974E+01, 5.1252587739E+00, 6.3363595462E+00, 2.4977296864E+00, 9.1998198531E-01],
	[3.0540000000E+04, 2.1088467183E+01, 5.1252508835E+00, 6.3397210232E+00, 2.4983302995E+00, 9.2001969607E-01],
	[3.0545000000E+04, 2.1094190008E+01, 5.1252429945E+00, 6.3430837312E+00, 2.4989308040E+00, 9.2005738812E-01],
	[3.0550000000E+04, 2.1099913449E+01, 5.1252351067E+00, 6.3464476705E+00, 2.4995312000E+00, 9.2009506149E-01],
	[3.0555000000E+04, 2.1105637506E+01, 5.1252272203E+00, 6.3498128413E+00, 2.5001314874E+00, 9.2013271618E-01],
	[3.0560000000E+04, 2.1111362179E+01, 5.1252193351E+00, 6.3531792439E+00, 2.5007316662E+00, 9.2017035220E-01],
	[3.0565000000E+04, 2.1117087468E+01, 5.1252114512E+00, 6.3565468785E+00, 2.5013317364E+00, 9.2020796955E-01],
	[3.0570000000E+04, 2.1122813372E+01, 5.1252035687E+00, 6.3599157454E+00, 2.5019316978E+00, 9.2024556826E-01],
	[3.0575000000E+04, 2.1128539892E+01, 5.1251956874E+00, 6.3632858448E+00, 2.5025315506E+00, 9.2028314832E-01],
	[3.0580000000E+04, 2.1134267028E+01, 5.1251878075E+00, 6.3666571770E+00, 2.5031312946E+00, 9.2032070974E-01],
	[3.0585000000E+04, 2.1139994780E+01, 5.1251799288E+00, 6.3700297422E+00, 2.5037309298E+00, 9.2035825254E-01],
	[3.0590000000E+04, 2.1145723147E+01, 5.1251720515E+00, 6.3734035406E+00, 2.5043304563E+00, 9.2039577671E-01],
	[3.0595000000E+04, 2.1151452130E+01, 5.1251641754E+00, 6.3767785726E+00, 2.5049298739E+00, 9.2043328228E-01],
	[3.0600000000E+04, 2.1157181728E+01, 5.1251563007E+00, 6.3801548383E+00, 2.5055291826E+00, 9.2047076926E-01],
	[3.0605000000E+04, 2.1162911942E+01, 5.1251484272E+00, 6.3835323380E+00, 2.5061283824E+00, 9.2050823763E-01],
	[3.0610000000E+04, 2.1168642771E+01, 5.1251405551E+00, 6.3869110720E+00, 2.5067274732E+00, 9.2054568743E-01],
	[3.0615000000E+04, 2.1174374216E+01, 5.1251326842E+00, 6.3902910405E+00, 2.5073264551E+00, 9.2058311865E-01],
	[3.0620000000E+04, 2.1180106277E+01, 5.1251248147E+00, 6.3936722437E+00, 2.5079253280E+00, 9.2062053131E-01],
	[3.0625000000E+04, 2.1185838952E+01, 5.1251169464E+00, 6.3970546820E+00, 2.5085240919E+00, 9.2065792542E-01],
	[3.0630000000E+04, 2.1191572244E+01, 5.1251090794E+00, 6.4004383555E+00, 2.5091227467E+00, 9.2069530097E-01],
	[3.0635000000E+04, 2.1197306150E+01, 5.1251012138E+00, 6.4038232645E+00, 2.5097212924E+00, 9.2073265799E-01],
	[3.0640000000E+04, 2.1203040672E+01, 5.1250933494E+00, 6.4072094092E+00, 2.5103197290E+00, 9.2076999648E-01],
	[3.0645000000E+04, 2.1208775809E+01, 5.1250854863E+00, 6.4105967900E+00, 2.5109180564E+00, 9.2080731645E-01],
	[3.0650000000E+04, 2.1214511561E+01, 5.1250776245E+00, 6.4139854070E+00, 2.5115162747E+00, 9.2084461791E-01],
	[3.0655000000E+04, 2.1220247929E+01, 5.1250697640E+00, 6.4173752604E+00, 2.5121143837E+00, 9.2088190087E-01],
	[3.0660000000E+04, 2.1225984911E+01, 5.1250619048E+00, 6.4207663507E+00, 2.5127123834E+00, 9.2091916533E-01],
	[3.0665000000E+04, 2.1231722509E+01, 5.1250540469E+00, 6.4241586779E+00, 2.5133102739E+00, 9.2095641131E-01],
	[3.0670000000E+04, 2.1237460722E+01, 5.1250461903E+00, 6.4275522423E+00, 2.5139080551E+00, 9.2099363881E-01],
	[3.0675000000E+04, 2.1243199550E+01, 5.1250383350E+00, 6.4309470443E+00, 2.5145057269E+00, 9.2103084785E-01],
	[3.0680000000E+04, 2.1248938993E+01, 5.1250304810E+00, 6.4343430840E+00, 2.5151032893E+00, 9.2106803843E-01],
	[3.0685000000E+04, 2.1254679051E+01, 5.1250226283E+00, 6.4377403616E+00, 2.5157007423E+00, 9.2110521056E-01],
	[3.0690000000E+04, 2.1260419724E+01, 5.1250147768E+00, 6.4411388775E+00, 2.5162980859E+00, 9.2114236425E-01],
	[3.0695000000E+04, 2.1266161012E+01, 5.1250069267E+00, 6.4445386319E+00, 2.5168953201E+00, 9.2117949951E-01],
	[3.0700000000E+04, 2.1271902915E+01, 5.1249990778E+00, 6.4479396250E+00, 2.5174924447E+00, 9.2121661634E-01],
	[3.0705000000E+04, 2.1277645432E+01, 5.1249912302E+00, 6.4513418571E+00, 2.5180894598E+00, 9.2125371476E-01],
	[3.0710000000E+04, 2.1283388565E+01, 5.1249833840E+00, 6.4547453284E+00, 2.5186863653E+00, 9.2129079478E-01],
	[3.0715000000E+04, 2.1289132312E+01, 5.1249755390E+00, 6.4581500392E+00, 2.5192831612E+00, 9.2132785640E-01],
	[3.0720000000E+04, 2.1294876674E+01, 5.1249676953E+00, 6.4615559897E+00, 2.5198798475E+00, 9.2136489964E-01],
	[3.0725000000E+04, 2.1300621651E+01, 5.1249598529E+00, 6.4649631802E+00, 2.5204764242E+00, 9.2140192449E-01],
	[3.0730000000E+04, 2.1306367242E+01, 5.1249520117E+00, 6.4683716110E+00, 2.5210728911E+00, 9.2143893098E-01],
	[3.0735000000E+04, 2.1312113448E+01, 5.1249441719E+00, 6.4717812822E+00, 2.5216692484E+00, 9.2147591911E-01],
	[3.0740000000E+04, 2.1317860269E+01, 5.1249363334E+00, 6.4751921941E+00, 2.5222654959E+00, 9.2151288888E-01],
	[3.0745000000E+04, 2.1323607704E+01, 5.1249284961E+00, 6.4786043469E+00, 2.5228616336E+00, 9.2154984031E-01],
	[3.0750000000E+04, 2.1329355754E+01, 5.1249206601E+00, 6.4820177410E+00, 2.5234576615E+00, 9.2158677341E-01],
	[3.0755000000E+04, 2.1335104418E+01, 5.1249128254E+00, 6.4854323766E+00, 2.5240535796E+00, 9.2162368819E-01],
	[3.0760000000E+04, 2.1340853697E+01, 5.1249049920E+00, 6.4888482539E+00, 2.5246493879E+00, 9.2166058465E-01],
	[3.0765000000E+04, 2.1346603590E+01, 5.1248971599E+00, 6.4922653731E+00, 2.5252450862E+00, 9.2169746280E-01],
	[3.0770000000E+04, 2.1352354098E+01, 5.1248893291E+00, 6.4956837346E+00, 2.5258406746E+00, 9.2173432265E-01],
	[3.0775000000E+04, 2.1358105220E+01, 5.1248814995E+00, 6.4991033385E+00, 2.5264361530E+00, 9.2177116421E-01],
	[3.0780000000E+04, 2.1363856957E+01, 5.1248736713E+00, 6.5025241851E+00, 2.5270315215E+00, 9.2180798750E-01],
	[3.0785000000E+04, 2.1369609307E+01, 5.1248658443E+00, 6.5059462747E+00, 2.5276267799E+00, 9.2184479251E-01],
	[3.0790000000E+04, 2.1375362272E+01, 5.1248580186E+00, 6.5093696075E+00, 2.5282219283E+00, 9.2188157926E-01],
	[3.0795000000E+04, 2.1381115852E+01, 5.1248501942E+00, 6.5127941838E+00, 2.5288169666E+00, 9.2191834775E-01],
	[3.0800000000E+04, 2.1386870045E+01, 5.1248423710E+00, 6.5162200037E+00, 2.5294118948E+00, 9.2195509800E-01],
	[3.0805000000E+04, 2.1392624853E+01, 5.1248345492E+00, 6.5196470676E+00, 2.5300067129E+00, 9.2199183002E-01],
	[3.0810000000E+04, 2.1398380274E+01, 5.1248267286E+00, 6.5230753758E+00, 2.5306014208E+00, 9.2202854380E-01],
	[3.0815000000E+04, 2.1404136310E+01, 5.1248189093E+00, 6.5265049283E+00, 2.5311960185E+00, 9.2206523937E-01],
	[3.0820000000E+04, 2.1409892960E+01, 5.1248110913E+00, 6.5299357256E+00, 2.5317905059E+00, 9.2210191673E-01],
	[3.0825000000E+04, 2.1415650224E+01, 5.1248032746E+00, 6.5333677678E+00, 2.5323848832E+00, 9.2213857589E-01],
	[3.0830000000E+04, 2.1421408102E+01, 5.1247954591E+00, 6.5368010552E+00, 2.5329791501E+00, 9.2217521686E-01],
	[3.0835000000E+04, 2.1427166594E+01, 5.1247876450E+00, 6.5402355881E+00, 2.5335733067E+00, 9.2221183964E-01],
	[3.0840000000E+04, 2.1432925700E+01, 5.1247798321E+00, 6.5436713666E+00, 2.5341673530E+00, 9.2224844425E-01],
	[3.0845000000E+04, 2.1438685420E+01, 5.1247720205E+00, 6.5471083911E+00, 2.5347612889E+00, 9.2228503069E-01],
	[3.0850000000E+04, 2.1444445753E+01, 5.1247642101E+00, 6.5505466618E+00, 2.5353551145E+00, 9.2232159898E-01],
	[3.0855000000E+04, 2.1450206701E+01, 5.1247564011E+00, 6.5539861790E+00, 2.5359488295E+00, 9.2235814912E-01],
	[3.0860000000E+04, 2.1455968262E+01, 5.1247485933E+00, 6.5574269428E+00, 2.5365424342E+00, 9.2239468113E-01],
	[3.0865000000E+04, 2.1461730437E+01, 5.1247407868E+00, 6.5608689536E+00, 2.5371359283E+00, 9.2243119500E-01],
	[3.0870000000E+04, 2.1467493226E+01, 5.1247329816E+00, 6.5643122115E+00, 2.5377293119E+00, 9.2246769075E-01],
	[3.0875000000E+04, 2.1473256628E+01, 5.1247251776E+00, 6.5677567169E+00, 2.5383225850E+00, 9.2250416839E-01],
	[3.0880000000E+04, 2.1479027257E+01, 5.1247183555E+00, 6.5712024700E+00, 2.5389160806E+00, 9.2254062793E-01],
	[3.0885000000E+04, 2.1484812548E+01, 5.1247136168E+00, 6.5746494711E+00, 2.5395101733E+00, 9.2257706937E-01],
	[3.0890000000E+04, 2.1490598460E+01, 5.1247088790E+00, 6.5780977203E+00, 2.5401041561E+00, 9.2261349273E-01],
	[3.0895000000E+04, 2.1496384993E+01, 5.1247041419E+00, 6.5815472179E+00, 2.5406980289E+00, 9.2264989801E-01],
	[3.0900000000E+04, 2.1502172148E+01, 5.1246994055E+00, 6.5849979642E+00, 2.5412917916E+00, 9.2268628522E-01],
	[3.0905000000E+04, 2.1507959923E+01, 5.1246946700E+00, 6.5884499595E+00, 2.5418854442E+00, 9.2272265437E-01],
	[3.0910000000E+04, 2.1513748321E+01, 5.1246899352E+00, 6.5919032039E+00, 2.5424789868E+00, 9.2275900546E-01],
	[3.0915000000E+04, 2.1519537339E+01, 5.1246852011E+00, 6.5953576978E+00, 2.5430724192E+00, 9.2279533851E-01],
	[3.0920000000E+04, 2.1525326978E+01, 5.1246804679E+00, 6.5988134413E+00, 2.5436657415E+00, 9.2283165352E-01],
	[3.0925000000E+04, 2.1531117239E+01, 5.1246757354E+00, 6.6022704348E+00, 2.5442589536E+00, 9.2286795050E-01],
	[3.0930000000E+04, 2.1536908121E+01, 5.1246710037E+00, 6.6057286785E+00, 2.5448520555E+00, 9.2290422945E-01],
	[3.0935000000E+04, 2.1542699623E+01, 5.1246662727E+00, 6.6091881725E+00, 2.5454450472E+00, 9.2294049039E-01],
	[3.0940000000E+04, 2.1548491747E+01, 5.1246615425E+00, 6.6126489173E+00, 2.5460379285E+00, 9.2297673332E-01],
	[3.0945000000E+04, 2.1554284492E+01, 5.1246568131E+00, 6.6161109130E+00, 2.5466306996E+00, 9.2301295825E-01],
	[3.0950000000E+04, 2.1560077857E+01, 5.1246520845E+00, 6.6195741598E+00, 2.5472233604E+00, 9.2304916518E-01],
	[3.0955000000E+04, 2.1565871844E+01, 5.1246473566E+00, 6.6230386581E+00, 2.5478159108E+00, 9.2308535413E-01],
	[3.0960000000E+04, 2.1571666452E+01, 5.1246426295E+00, 6.6265044080E+00, 2.5484083508E+00, 9.2312152510E-01],
	[3.0965000000E+04, 2.1577461680E+01, 5.1246379032E+00, 6.6299714099E+00, 2.5490006804E+00, 9.2315767810E-01],
	[3.0970000000E+04, 2.1583257529E+01, 5.1246331776E+00, 6.6334396639E+00, 2.5495928996E+00, 9.2319381314E-01],
	[3.0975000000E+04, 2.1589053999E+01, 5.1246284528E+00, 6.6369091704E+00, 2.5501850083E+00, 9.2322993022E-01],
	[3.0980000000E+04, 2.1594851090E+01, 5.1246237288E+00, 6.6403799295E+00, 2.5507770066E+00, 9.2326602936E-01],
	[3.0985000000E+04, 2.1600648801E+01, 5.1246190055E+00, 6.6438519416E+00, 2.5513688943E+00, 9.2330211056E-01],
	[3.0990000000E+04, 2.1606447133E+01, 5.1246142830E+00, 6.6473252068E+00, 2.5519606714E+00, 9.2333817382E-01],
	[3.0995000000E+04, 2.1612246086E+01, 5.1246095613E+00, 6.6507997254E+00, 2.5525523380E+00, 9.2337421916E-01],
	[3.1000000000E+04, 2.1618045659E+01, 5.1246048403E+00, 6.6542754977E+00, 2.5531438940E+00, 9.2341024659E-01],
	[3.1005000000E+04, 2.1623845853E+01, 5.1246001201E+00, 6.6577525239E+00, 2.5537353393E+00, 9.2344625611E-01],
	[3.1010000000E+04, 2.1629646667E+01, 5.1245954007E+00, 6.6612308042E+00, 2.5543266740E+00, 9.2348224772E-01],
	[3.1015000000E+04, 2.1635448102E+01, 5.1245906820E+00, 6.6647103390E+00, 2.5549178980E+00, 9.2351822144E-01],
	[3.1020000000E+04, 2.1641250158E+01, 5.1245859641E+00, 6.6681911284E+00, 2.5555090113E+00, 9.2355417728E-01],
	[3.1025000000E+04, 2.1647052834E+01, 5.1245812469E+00, 6.6716731728E+00, 2.5561000138E+00, 9.2359011524E-01],
	[3.1030000000E+04, 2.1652856130E+01, 5.1245765305E+00, 6.6751564723E+00, 2.5566909056E+00, 9.2362603533E-01],
	[3.1035000000E+04, 2.1658660047E+01, 5.1245718149E+00, 6.6786410272E+00, 2.5572816865E+00, 9.2366193755E-01],
	[3.1040000000E+04, 2.1664464584E+01, 5.1245671001E+00, 6.6821268378E+00, 2.5578723567E+00, 9.2369782193E-01],
	[3.1045000000E+04, 2.1670269741E+01, 5.1245623860E+00, 6.6856139043E+00, 2.5584629160E+00, 9.2373368845E-01],
	[3.1050000000E+04, 2.1676075519E+01, 5.1245576727E+00, 6.6891022269E+00, 2.5590533644E+00, 9.2376953714E-01],
	[3.1055000000E+04, 2.1681881916E+01, 5.1245529601E+00, 6.6925918059E+00, 2.5596437019E+00, 9.2380536799E-01],
	[3.1060000000E+04, 2.1687688935E+01, 5.1245482483E+00, 6.6960826416E+00, 2.5602339285E+00, 9.2384118102E-01],
	[3.1065000000E+04, 2.1693496573E+01, 5.1245435373E+00, 6.6995747342E+00, 2.5608240441E+00, 9.2387697624E-01],
	[3.1070000000E+04, 2.1699304831E+01, 5.1245388270E+00, 6.7030680840E+00, 2.5614140488E+00, 9.2391275364E-01],
	[3.1075000000E+04, 2.1705113710E+01, 5.1245341175E+00, 6.7065626911E+00, 2.5620039424E+00, 9.2394851325E-01],
	[3.1080000000E+04, 2.1710923208E+01, 5.1245294087E+00, 6.7100585559E+00, 2.5625937249E+00, 9.2398425506E-01],
	[3.1085000000E+04, 2.1716733327E+01, 5.1245247008E+00, 6.7135556787E+00, 2.5631833965E+00, 9.2401997909E-01],
	[3.1090000000E+04, 2.1722544065E+01, 5.1245199935E+00, 6.7170540595E+00, 2.5637729569E+00, 9.2405568534E-01],
	[3.1095000000E+04, 2.1728355424E+01, 5.1245152871E+00, 6.7205536988E+00, 2.5643624062E+00, 9.2409137383E-01],
	[3.1100000000E+04, 2.1734167403E+01, 5.1245105814E+00, 6.7240545967E+00, 2.5649517443E+00, 9.2412704455E-01],
	[3.1105000000E+04, 2.1739980001E+01, 5.1245058764E+00, 6.7275567535E+00, 2.5655409713E+00, 9.2416269751E-01],
	[3.1110000000E+04, 2.1745793219E+01, 5.1245011722E+00, 6.7310601695E+00, 2.5661300871E+00, 9.2419833273E-01],
	[3.1115000000E+04, 2.1751607057E+01, 5.1244964688E+00, 6.7345648448E+00, 2.5667190916E+00, 9.2423395021E-01],
	[3.1120000000E+04, 2.1757421515E+01, 5.1244917662E+00, 6.7380707798E+00, 2.5673079849E+00, 9.2426954996E-01],
	[3.1125000000E+04, 2.1763236593E+01, 5.1244870643E+00, 6.7415779747E+00, 2.5678967669E+00, 9.2430513199E-01],
	[3.1130000000E+04, 2.1769052291E+01, 5.1244823631E+00, 6.7450864298E+00, 2.5684854376E+00, 9.2434069630E-01],
	[3.1135000000E+04, 2.1774868608E+01, 5.1244776627E+00, 6.7485961452E+00, 2.5690739970E+00, 9.2437624291E-01],
	[3.1140000000E+04, 2.1780685545E+01, 5.1244729631E+00, 6.7521071213E+00, 2.5696624450E+00, 9.2441177181E-01],
	[3.1145000000E+04, 2.1786503101E+01, 5.1244682642E+00, 6.7556193583E+00, 2.5702507816E+00, 9.2444728303E-01],
	[3.1150000000E+04, 2.1792321277E+01, 5.1244635661E+00, 6.7591328564E+00, 2.5708390069E+00, 9.2448277656E-01],
	[3.1155000000E+04, 2.1798140073E+01, 5.1244588688E+00, 6.7626476159E+00, 2.5714271206E+00, 9.2451825241E-01],
	[3.1160000000E+04, 2.1803959488E+01, 5.1244541722E+00, 6.7661636371E+00, 2.5720151229E+00, 9.2455371060E-01],
	[3.1165000000E+04, 2.1809779523E+01, 5.1244494764E+00, 6.7696809201E+00, 2.5726030138E+00, 9.2458915112E-01],
	[3.1170000000E+04, 2.1815600177E+01, 5.1244447813E+00, 6.7731994653E+00, 2.5731907931E+00, 9.2462457399E-01],
	[3.1175000000E+04, 2.1821421451E+01, 5.1244400870E+00, 6.7767192729E+00, 2.5737784609E+00, 9.2465997922E-01],
	[3.1180000000E+04, 2.1827243344E+01, 5.1244353934E+00, 6.7802403431E+00, 2.5743660171E+00, 9.2469536681E-01],
	[3.1185000000E+04, 2.1833065856E+01, 5.1244307006E+00, 6.7837626762E+00, 2.5749534617E+00, 9.2473073677E-01],
	[3.1190000000E+04, 2.1838888988E+01, 5.1244260086E+00, 6.7872862725E+00, 2.5755407947E+00, 9.2476608910E-01],
	[3.1195000000E+04, 2.1844712739E+01, 5.1244213173E+00, 6.7908111321E+00, 2.5761280160E+00, 9.2480142383E-01],
	[3.1200000000E+04, 2.1850537109E+01, 5.1244166268E+00, 6.7943372554E+00, 2.5767151257E+00, 9.2483674094E-01],
	[3.1205000000E+04, 2.1856362099E+01, 5.1244119370E+00, 6.7978646426E+00, 2.5773021237E+00, 9.2487204046E-01],
	[3.1210000000E+04, 2.1862187707E+01, 5.1244072480E+00, 6.8013932939E+00, 2.5778890099E+00, 9.2490732239E-01],
	[3.1215000000E+04, 2.1868013935E+01, 5.1244025597E+00, 6.8049232095E+00, 2.5784757844E+00, 9.2494258673E-01],
	[3.1220000000E+04, 2.1873840782E+01, 5.1243978722E+00, 6.8084543899E+00, 2.5790624472E+00, 9.2497783350E-01],
	[3.1225000000E+04, 2.1879668249E+01, 5.1243931854E+00, 6.8119868351E+00, 2.5796489981E+00, 9.2501306271E-01],
	[3.1230000000E+04, 2.1885496334E+01, 5.1243884994E+00, 6.8155205454E+00, 2.5802354373E+00, 9.2504827435E-01],
	[3.1235000000E+04, 2.1891325038E+01, 5.1243838142E+00, 6.8190555212E+00, 2.5808217645E+00, 9.2508346844E-01],
	[3.1240000000E+04, 2.1897154361E+01, 5.1243791297E+00, 6.8225917625E+00, 2.5814079799E+00, 9.2511864499E-01],
	[3.1245000000E+04, 2.1902984304E+01, 5.1243744459E+00, 6.8261292698E+00, 2.5819940835E+00, 9.2515380400E-01],
	[3.1250000000E+04, 2.1908814865E+01, 5.1243697630E+00, 6.8296680432E+00, 2.5825800750E+00, 9.2518894549E-01],
	[3.1255000000E+04, 2.1914646045E+01, 5.1243650807E+00, 6.8332080829E+00, 2.5831659547E+00, 9.2522406945E-01],
	[3.1260000000E+04, 2.1920477844E+01, 5.1243603993E+00, 6.8367493893E+00, 2.5837517223E+00, 9.2525917590E-01],
	[3.1265000000E+04, 2.1926310262E+01, 5.1243557185E+00, 6.8402919626E+00, 2.5843373780E+00, 9.2529426485E-01],
	[3.1270000000E+04, 2.1932143298E+01, 5.1243510386E+00, 6.8438358030E+00, 2.5849229217E+00, 9.2532933630E-01],
	[3.1275000000E+04, 2.1937976954E+01, 5.1243463593E+00, 6.8473809108E+00, 2.5855083532E+00, 9.2536439026E-01],
	[3.1280000000E+04, 2.1943811228E+01, 5.1243416809E+00, 6.8509272862E+00, 2.5860936728E+00, 9.2539942674E-01],
	[3.1285000000E+04, 2.1949646121E+01, 5.1243370032E+00, 6.8544749296E+00, 2.5866788802E+00, 9.2543444575E-01],
	[3.1290000000E+04, 2.1955481632E+01, 5.1243323262E+00, 6.8580238410E+00, 2.5872639755E+00, 9.2546944729E-01],
	[3.1295000000E+04, 2.1961317762E+01, 5.1243276500E+00, 6.8615740208E+00, 2.5878489587E+00, 9.2550443137E-01],
	[3.1300000000E+04, 2.1967154511E+01, 5.1243229745E+00, 6.8651254693E+00, 2.5884338297E+00, 9.2553939801E-01],
	[3.1305000000E+04, 2.1972991878E+01, 5.1243182998E+00, 6.8686781866E+00, 2.5890185884E+00, 9.2557434720E-01],
	[3.1310000000E+04, 2.1978829864E+01, 5.1243136258E+00, 6.8722321731E+00, 2.5896032350E+00, 9.2560927895E-01],
	[3.1315000000E+04, 2.1984668468E+01, 5.1243089526E+00, 6.8757874289E+00, 2.5901877694E+00, 9.2564419328E-01],
	[3.1320000000E+04, 2.1990507691E+01, 5.1243042802E+00, 6.8793439544E+00, 2.5907721914E+00, 9.2567909020E-01],
	[3.1325000000E+04, 2.1996347533E+01, 5.1242996085E+00, 6.8829017497E+00, 2.5913565012E+00, 9.2571396970E-01],
	[3.1330000000E+04, 2.2002187992E+01, 5.1242949375E+00, 6.8864608152E+00, 2.5919406986E+00, 9.2574883180E-01],
	[3.1335000000E+04, 2.2008029070E+01, 5.1242902673E+00, 6.8900211510E+00, 2.5925247837E+00, 9.2578367650E-01],
	[3.1340000000E+04, 2.2013870767E+01, 5.1242855978E+00, 6.8935827575E+00, 2.5931087565E+00, 9.2581850382E-01],
	[3.1345000000E+04, 2.2019713081E+01, 5.1242809291E+00, 6.8971456349E+00, 2.5936926168E+00, 9.2585331375E-01],
	[3.1350000000E+04, 2.2025556014E+01, 5.1242762612E+00, 6.9007097834E+00, 2.5942763648E+00, 9.2588810632E-01],
	[3.1355000000E+04, 2.2031399565E+01, 5.1242715940E+00, 6.9042752032E+00, 2.5948600003E+00, 9.2592288152E-01],
	[3.1360000000E+04, 2.2037243735E+01, 5.1242669275E+00, 6.9078418947E+00, 2.5954435233E+00, 9.2595763937E-01],
	[3.1365000000E+04, 2.2043088522E+01, 5.1242622618E+00, 6.9114098581E+00, 2.5960269339E+00, 9.2599237987E-01],
	[3.1370000000E+04, 2.2048933928E+01, 5.1242575968E+00, 6.9149790936E+00, 2.5966102320E+00, 9.2602710303E-01],
	[3.1375000000E+04, 2.2054779952E+01, 5.1242529326E+00, 6.9185496015E+00, 2.5971934175E+00, 9.2606180885E-01],
	[3.1380000000E+04, 2.2060644996E+01, 5.1242509708E+00, 6.9221213820E+00, 2.5977774399E+00, 9.2609649736E-01],
	[3.1385000000E+04, 2.2066512708E+01, 5.1242493091E+00, 6.9256944354E+00, 2.5983614558E+00, 9.2613116854E-01],
	[3.1390000000E+04, 2.2072381045E+01, 5.1242476477E+00, 6.9292687619E+00, 2.5989453597E+00, 9.2616582242E-01],
	[3.1395000000E+04, 2.2078250008E+01, 5.1242459866E+00, 6.9328443617E+00, 2.5995291517E+00, 9.2620045900E-01],
	[3.1400000000E+04, 2.2084119597E+01, 5.1242443257E+00, 6.9364212352E+00, 2.6001128315E+00, 9.2623507828E-01],
	[3.1405000000E+04, 2.2089989811E+01, 5.1242426651E+00, 6.9399993826E+00, 2.6006963994E+00, 9.2626968028E-01],
	[3.1410000000E+04, 2.2095860650E+01, 5.1242410048E+00, 6.9435788041E+00, 2.6012798552E+00, 9.2630426500E-01],
	[3.1415000000E+04, 2.2101732115E+01, 5.1242393447E+00, 6.9471595000E+00, 2.6018631989E+00, 9.2633883245E-01],
	[3.1420000000E+04, 2.2107604205E+01, 5.1242376849E+00, 6.9507414705E+00, 2.6024464304E+00, 9.2637338264E-01],
	[3.1425000000E+04, 2.2113476921E+01, 5.1242360253E+00, 6.9543247159E+00, 2.6030295499E+00, 9.2640791558E-01],
	[3.1430000000E+04, 2.2119350262E+01, 5.1242343661E+00, 6.9579092364E+00, 2.6036125571E+00, 9.2644243127E-01],
	[3.1435000000E+04, 2.2125224229E+01, 5.1242327071E+00, 6.9614950323E+00, 2.6041954522E+00, 9.2647692973E-01],
	[3.1440000000E+04, 2.2131098820E+01, 5.1242310483E+00, 6.9650821038E+00, 2.6047782351E+00, 9.2651141095E-01],
	[3.1445000000E+04, 2.2136974037E+01, 5.1242293898E+00, 6.9686704512E+00, 2.6053609057E+00, 9.2654587495E-01],
	[3.1450000000E+04, 2.2142849879E+01, 5.1242277316E+00, 6.9722600747E+00, 2.6059434641E+00, 9.2658032174E-01],
	[3.1455000000E+04, 2.2148726347E+01, 5.1242260736E+00, 6.9758509746E+00, 2.6065259102E+00, 9.2661475132E-01],
	[3.1460000000E+04, 2.2154603439E+01, 5.1242244160E+00, 6.9794431511E+00, 2.6071082440E+00, 9.2664916371E-01],
	[3.1465000000E+04, 2.2160481157E+01, 5.1242227585E+00, 6.9830366045E+00, 2.6076904655E+00, 9.2668355890E-01],
	[3.1470000000E+04, 2.2166359499E+01, 5.1242211014E+00, 6.9866313350E+00, 2.6082725746E+00, 9.2671793691E-01],
	[3.1475000000E+04, 2.2172238467E+01, 5.1242194445E+00, 6.9902273429E+00, 2.6088545714E+00, 9.2675229775E-01],
	[3.1480000000E+04, 2.2178118060E+01, 5.1242177878E+00, 6.9938246284E+00, 2.6094364558E+00, 9.2678664142E-01],
	[3.1485000000E+04, 2.2183998277E+01, 5.1242161315E+00, 6.9974231918E+00, 2.6100182277E+00, 9.2682096793E-01],
	[3.1490000000E+04, 2.2189879120E+01, 5.1242144753E+00, 7.0010230333E+00, 2.6105998872E+00, 9.2685527729E-01],
	[3.1495000000E+04, 2.2195760587E+01, 5.1242128195E+00, 7.0046241532E+00, 2.6111814343E+00, 9.2688956950E-01],
	[3.1500000000E+04, 2.2201642680E+01, 5.1242111639E+00, 7.0082265517E+00, 2.6117628689E+00, 9.2692384458E-01],
	[3.1505000000E+04, 2.2207525397E+01, 5.1242095086E+00, 7.0118302291E+00, 2.6123441909E+00, 9.2695810254E-01],
	[3.1510000000E+04, 2.2213408739E+01, 5.1242078535E+00, 7.0154351856E+00, 2.6129254004E+00, 9.2699234337E-01],
	[3.1515000000E+04, 2.2219292706E+01, 5.1242061987E+00, 7.0190414215E+00, 2.6135064974E+00, 9.2702656709E-01],
	[3.1520000000E+04, 2.2225177298E+01, 5.1242045442E+00, 7.0226489370E+00, 2.6140874818E+00, 9.2706077371E-01],
	[3.1525000000E+04, 2.2231062514E+01, 5.1242028900E+00, 7.0262577324E+00, 2.6146683536E+00, 9.2709496323E-01],
	[3.1530000000E+04, 2.2236948355E+01, 5.1242012359E+00, 7.0298678079E+00, 2.6152491128E+00, 9.2712913567E-01],
	[3.1535000000E+04, 2.2242834821E+01, 5.1241995822E+00, 7.0334791638E+00, 2.6158297594E+00, 9.2716329103E-01],
	[3.1540000000E+04, 2.2248721911E+01, 5.1241979287E+00, 7.0370918003E+00, 2.6164102932E+00, 9.2719742931E-01],
	[3.1545000000E+04, 2.2254609626E+01, 5.1241962755E+00, 7.0407057177E+00, 2.6169907144E+00, 9.2723155053E-01],
	[3.1550000000E+04, 2.2260497965E+01, 5.1241946226E+00, 7.0443209162E+00, 2.6175710229E+00, 9.2726565469E-01],
	[3.1555000000E+04, 2.2266386929E+01, 5.1241929699E+00, 7.0479373961E+00, 2.6181512186E+00, 9.2729974180E-01],
	[3.1560000000E+04, 2.2272276518E+01, 5.1241913174E+00, 7.0515551576E+00, 2.6187313016E+00, 9.2733381188E-01],
	[3.1565000000E+04, 2.2278166730E+01, 5.1241896653E+00, 7.0551742010E+00, 2.6193112719E+00, 9.2736786492E-01],
	[3.1570000000E+04, 2.2284057568E+01, 5.1241880134E+00, 7.0587945266E+00, 2.6198911293E+00, 9.2740190094E-01],
	[3.1575000000E+04, 2.2289949029E+01, 5.1241863617E+00, 7.0624161345E+00, 2.6204708739E+00, 9.2743591994E-01],
	[3.1580000000E+04, 2.2295841116E+01, 5.1241847103E+00, 7.0660390250E+00, 2.6210505057E+00, 9.2746992193E-01],
	[3.1585000000E+04, 2.2301733826E+01, 5.1241830592E+00, 7.0696631984E+00, 2.6216300246E+00, 9.2750390692E-01],
	[3.1590000000E+04, 2.2307627161E+01, 5.1241814084E+00, 7.0732886549E+00, 2.6222094306E+00, 9.2753787492E-01],
	[3.1595000000E+04, 2.2313521120E+01, 5.1241797578E+00, 7.0769153949E+00, 2.6227887237E+00, 9.2757182593E-01],
	[3.1600000000E+04, 2.2319415703E+01, 5.1241781074E+00, 7.0805434184E+00, 2.6233679039E+00, 9.2760575996E-01],
	[3.1605000000E+04, 2.2325310910E+01, 5.1241764574E+00, 7.0841727258E+00, 2.6239469711E+00, 9.2763967703E-01],
	[3.1610000000E+04, 2.2331206742E+01, 5.1241748076E+00, 7.0878033174E+00, 2.6245259253E+00, 9.2767357713E-01],
	[3.1615000000E+04, 2.2337103197E+01, 5.1241731580E+00, 7.0914351933E+00, 2.6251047666E+00, 9.2770746028E-01],
	[3.1620000000E+04, 2.2343000277E+01, 5.1241715087E+00, 7.0950683539E+00, 2.6256834949E+00, 9.2774132649E-01],
	[3.1625000000E+04, 2.2348897981E+01, 5.1241698597E+00, 7.0987027993E+00, 2.6262621101E+00, 9.2777517576E-01],
	[3.1630000000E+04, 2.2354796309E+01, 5.1241682109E+00, 7.1023385299E+00, 2.6268406122E+00, 9.2780900810E-01],
	[3.1635000000E+04, 2.2360695261E+01, 5.1241665624E+00, 7.1059755458E+00, 2.6274190013E+00, 9.2784282351E-01],
	[3.1640000000E+04, 2.2366594836E+01, 5.1241649142E+00, 7.1096138474E+00, 2.6279972773E+00, 9.2787662202E-01],
	[3.1645000000E+04, 2.2372495036E+01, 5.1241632662E+00, 7.1132534348E+00, 2.6285754402E+00, 9.2791040361E-01],
	[3.1650000000E+04, 2.2378395860E+01, 5.1241616185E+00, 7.1168943084E+00, 2.6291534899E+00, 9.2794416831E-01],
	[3.1655000000E+04, 2.2384297307E+01, 5.1241599710E+00, 7.1205364684E+00, 2.6297314264E+00, 9.2797791612E-01],
	[3.1660000000E+04, 2.2390199379E+01, 5.1241583238E+00, 7.1241799150E+00, 2.6303092498E+00, 9.2801164705E-01],
	[3.1665000000E+04, 2.2396102074E+01, 5.1241566769E+00, 7.1278246485E+00, 2.6308869600E+00, 9.2804536110E-01],
	[3.1670000000E+04, 2.2402005393E+01, 5.1241550302E+00, 7.1314706691E+00, 2.6314645569E+00, 9.2807905828E-01],
	[3.1675000000E+04, 2.2407909335E+01, 5.1241533838E+00, 7.1351179771E+00, 2.6320420406E+00, 9.2811273861E-01],
	[3.1680000000E+04, 2.2413813902E+01, 5.1241517377E+00, 7.1387665727E+00, 2.6326194110E+00, 9.2814640209E-01],
	[3.1685000000E+04, 2.2419719092E+01, 5.1241500918E+00, 7.1424164562E+00, 2.6331966681E+00, 9.2818004872E-01],
	[3.1690000000E+04, 2.2425624905E+01, 5.1241484461E+00, 7.1460676279E+00, 2.6337738120E+00, 9.2821367852E-01],
	[3.1695000000E+04, 2.2431531343E+01, 5.1241468008E+00, 7.1497200879E+00, 2.6343508424E+00, 9.2824729150E-01],
	[3.1700000000E+04, 2.2437438404E+01, 5.1241451556E+00, 7.1533738366E+00, 2.6349277596E+00, 9.2828088765E-01],
	[3.1705000000E+04, 2.2443346088E+01, 5.1241435108E+00, 7.1570288741E+00, 2.6355045634E+00, 9.2831446700E-01],
	[3.1710000000E+04, 2.2449254396E+01, 5.1241418662E+00, 7.1606852008E+00, 2.6360812537E+00, 9.2834802954E-01],
	[3.1715000000E+04, 2.2455163327E+01, 5.1241402219E+00, 7.1643428169E+00, 2.6366578307E+00, 9.2838157528E-01],
	[3.1720000000E+04, 2.2461072882E+01, 5.1241385778E+00, 7.1680017226E+00, 2.6372342942E+00, 9.2841510424E-01],
	[3.1725000000E+04, 2.2466983060E+01, 5.1241369340E+00, 7.1716619182E+00, 2.6378106443E+00, 9.2844861642E-01],
	[3.1730000000E+04, 2.2472893862E+01, 5.1241352904E+00, 7.1753234039E+00, 2.6383868809E+00, 9.2848211183E-01],
	[3.1735000000E+04, 2.2478805287E+01, 5.1241336471E+00, 7.1789861800E+00, 2.6389630040E+00, 9.2851559048E-01],
	[3.1740000000E+04, 2.2484717335E+01, 5.1241320041E+00, 7.1826502468E+00, 2.6395390136E+00, 9.2854905237E-01],
	[3.1745000000E+04, 2.2490630007E+01, 5.1241303613E+00, 7.1863156044E+00, 2.6401149096E+00, 9.2858249751E-01],
	[3.1750000000E+04, 2.2496543302E+01, 5.1241287188E+00, 7.1899822532E+00, 2.6406906921E+00, 9.2861592591E-01],
	[3.1755000000E+04, 2.2502457220E+01, 5.1241270765E+00, 7.1936501934E+00, 2.6412663610E+00, 9.2864933758E-01],
	[3.1760000000E+04, 2.2508371761E+01, 5.1241254345E+00, 7.1973194252E+00, 2.6418419164E+00, 9.2868273253E-01],
	[3.1765000000E+04, 2.2514286925E+01, 5.1241237928E+00, 7.2009899489E+00, 2.6424173581E+00, 9.2871611076E-01],
	[3.1770000000E+04, 2.2520202713E+01, 5.1241221513E+00, 7.2046617648E+00, 2.6429926861E+00, 9.2874947229E-01],
	[3.1775000000E+04, 2.2526119123E+01, 5.1241205101E+00, 7.2083348730E+00, 2.6435679005E+00, 9.2878281711E-01],
	[3.1780000000E+04, 2.2532036157E+01, 5.1241188691E+00, 7.2120092739E+00, 2.6441430013E+00, 9.2881614525E-01],
	[3.1785000000E+04, 2.2537953814E+01, 5.1241172284E+00, 7.2156849676E+00, 2.6447179883E+00, 9.2884945670E-01],
	[3.1790000000E+04, 2.2543872093E+01, 5.1241155879E+00, 7.2193619546E+00, 2.6452928617E+00, 9.2888275147E-01],
	[3.1795000000E+04, 2.2549790996E+01, 5.1241139478E+00, 7.2230402349E+00, 2.6458676212E+00, 9.2891602958E-01],
	[3.1800000000E+04, 2.2555710521E+01, 5.1241123078E+00, 7.2267198088E+00, 2.6464422671E+00, 9.2894929102E-01],
	[3.1805000000E+04, 2.2561630670E+01, 5.1241106682E+00, 7.2304006767E+00, 2.6470167991E+00, 9.2898253582E-01],
	[3.1810000000E+04, 2.2567551441E+01, 5.1241090287E+00, 7.2340828387E+00, 2.6475912174E+00, 9.2901576396E-01],
	[3.1815000000E+04, 2.2573472835E+01, 5.1241073896E+00, 7.2377662951E+00, 2.6481655219E+00, 9.2904897548E-01],
	[3.1820000000E+04, 2.2579394852E+01, 5.1241057507E+00, 7.2414510461E+00, 2.6487397125E+00, 9.2908217036E-01],
	[3.1825000000E+04, 2.2585317492E+01, 5.1241041120E+00, 7.2451370920E+00, 2.6493137892E+00, 9.2911534863E-01],
	[3.1830000000E+04, 2.2591240754E+01, 5.1241024737E+00, 7.2488244331E+00, 2.6498877521E+00, 9.2914851028E-01],
	[3.1835000000E+04, 2.2597164639E+01, 5.1241008355E+00, 7.2525130696E+00, 2.6504616011E+00, 9.2918165533E-01],
	[3.1840000000E+04, 2.2603089147E+01, 5.1240991977E+00, 7.2562030017E+00, 2.6510353362E+00, 9.2921478378E-01],
	[3.1845000000E+04, 2.2609014278E+01, 5.1240975601E+00, 7.2598942298E+00, 2.6516089574E+00, 9.2924789564E-01],
	[3.1850000000E+04, 2.2614940031E+01, 5.1240959227E+00, 7.2635867539E+00, 2.6521824646E+00, 9.2928099092E-01],
	[3.1855000000E+04, 2.2620866406E+01, 5.1240942856E+00, 7.2672805745E+00, 2.6527558578E+00, 9.2931406963E-01],
	[3.1860000000E+04, 2.2626793404E+01, 5.1240926488E+00, 7.2709756918E+00, 2.6533291371E+00, 9.2934713177E-01],
	[3.1865000000E+04, 2.2632721025E+01, 5.1240910122E+00, 7.2746721059E+00, 2.6539023023E+00, 9.2938017736E-01],
	[3.1870000000E+04, 2.2638649268E+01, 5.1240893759E+00, 7.2783698172E+00, 2.6544753536E+00, 9.2941320640E-01],
	[3.1875000000E+04, 2.2644578134E+01, 5.1240877398E+00, 7.2820688259E+00, 2.6550482907E+00, 9.2944621890E-01],
	[3.1880000000E+04, 2.2650507622E+01, 5.1240861040E+00, 7.2857691322E+00, 2.6556211138E+00, 9.2947921486E-01],
	[3.1885000000E+04, 2.2656455521E+01, 5.1240870555E+00, 7.2894707365E+00, 2.6561947625E+00, 9.2951219430E-01],
	[3.1890000000E+04, 2.2662406487E+01, 5.1240883613E+00, 7.2931736389E+00, 2.6567684265E+00, 9.2954515722E-01],
	[3.1895000000E+04, 2.2668358083E+01, 5.1240896668E+00, 7.2968778397E+00, 2.6573419768E+00, 9.2957810364E-01],
	[3.1900000000E+04, 2.2674310308E+01, 5.1240909721E+00, 7.3005833392E+00, 2.6579154137E+00, 9.2961103355E-01],
	[3.1905000000E+04, 2.2680263163E+01, 5.1240922773E+00, 7.3042901376E+00, 2.6584887370E+00, 9.2964394697E-01],
	[3.1910000000E+04, 2.2686216648E+01, 5.1240935822E+00, 7.3079982351E+00, 2.6590619468E+00, 9.2967684390E-01],
	[3.1915000000E+04, 2.2692170762E+01, 5.1240948869E+00, 7.3117076321E+00, 2.6596350429E+00, 9.2970972436E-01],
	[3.1920000000E+04, 2.2698125506E+01, 5.1240961914E+00, 7.3154183287E+00, 2.6602080255E+00, 9.2974258834E-01],
	[3.1925000000E+04, 2.2704080879E+01, 5.1240974957E+00, 7.3191303252E+00, 2.6607808944E+00, 9.2977543587E-01],
	[3.1930000000E+04, 2.2710036882E+01, 5.1240987998E+00, 7.3228436219E+00, 2.6613536497E+00, 9.2980826694E-01],
	[3.1935000000E+04, 2.2715993514E+01, 5.1241001037E+00, 7.3265582190E+00, 2.6619262913E+00, 9.2984108157E-01],
	[3.1940000000E+04, 2.2721950776E+01, 5.1241014074E+00, 7.3302741168E+00, 2.6624988192E+00, 9.2987387975E-01],
	[3.1945000000E+04, 2.2727908668E+01, 5.1241027109E+00, 7.3339913155E+00, 2.6630712335E+00, 9.2990666151E-01],
	[3.1950000000E+04, 2.2733867188E+01, 5.1241040142E+00, 7.3377098153E+00, 2.6636435340E+00, 9.2993942685E-01],
	[3.1955000000E+04, 2.2739826338E+01, 5.1241053173E+00, 7.3414296166E+00, 2.6642157208E+00, 9.2997217577E-01],
	[3.1960000000E+04, 2.2745786118E+01, 5.1241066202E+00, 7.3451507195E+00, 2.6647877938E+00, 9.3000490829E-01],
	[3.1965000000E+04, 2.2751746526E+01, 5.1241079229E+00, 7.3488731244E+00, 2.6653597530E+00, 9.3003762441E-01],
	[3.1970000000E+04, 2.2757707564E+01, 5.1241092253E+00, 7.3525968314E+00, 2.6659315985E+00, 9.3007032414E-01],
	[3.1975000000E+04, 2.2763669231E+01, 5.1241105276E+00, 7.3563218408E+00, 2.6665033302E+00, 9.3010300749E-01],
	[3.1980000000E+04, 2.2769631528E+01, 5.1241118297E+00, 7.3600481529E+00, 2.6670749480E+00, 9.3013567446E-01],
	[3.1985000000E+04, 2.2775594453E+01, 5.1241131315E+00, 7.3637757680E+00, 2.6676464520E+00, 9.3016832507E-01],
	[3.1990000000E+04, 2.2781558008E+01, 5.1241144332E+00, 7.3675046862E+00, 2.6682178421E+00, 9.3020095932E-01],
	[3.1995000000E+04, 2.2787522192E+01, 5.1241157347E+00, 7.3712349078E+00, 2.6687891183E+00, 9.3023357721E-01],
	[3.2000000000E+04, 2.2793487005E+01, 5.1241170359E+00, 7.3749664331E+00, 2.6693602806E+00, 9.3026617877E-01],
	[3.2005000000E+04, 2.2799452446E+01, 5.1241183370E+00, 7.3786992623E+00, 2.6699313291E+00, 9.3029876399E-01],
	[3.2010000000E+04, 2.2805418517E+01, 5.1241196378E+00, 7.3824333957E+00, 2.6705022635E+00, 9.3033133289E-01],
	[3.2015000000E+04, 2.2811385217E+01, 5.1241209385E+00, 7.3861688336E+00, 2.6710730841E+00, 9.3036388547E-01],
	[3.2020000000E+04, 2.2817352546E+01, 5.1241222389E+00, 7.3899055761E+00, 2.6716437906E+00, 9.3039642173E-01],
	[3.2025000000E+04, 2.2823320504E+01, 5.1241235391E+00, 7.3936436235E+00, 2.6722143832E+00, 9.3042894170E-01],
	[3.2030000000E+04, 2.2829289090E+01, 5.1241248392E+00, 7.3973829762E+00, 2.6727848617E+00, 9.3046144537E-01],
	[3.2035000000E+04, 2.2835258306E+01, 5.1241261390E+00, 7.4011236342E+00, 2.6733552263E+00, 9.3049393275E-01],
	[3.2040000000E+04, 2.2841228150E+01, 5.1241274387E+00, 7.4048655979E+00, 2.6739254767E+00, 9.3052640385E-01],
	[3.2045000000E+04, 2.2847198623E+01, 5.1241287381E+00, 7.4086088676E+00, 2.6744956132E+00, 9.3055885869E-01],
	[3.2050000000E+04, 2.2853169725E+01, 5.1241300373E+00, 7.4123534435E+00, 2.6750656355E+00, 9.3059129726E-01],
	[3.2055000000E+04, 2.2859141456E+01, 5.1241313363E+00, 7.4160993258E+00, 2.6756355438E+00, 9.3062371957E-01],
	[3.2060000000E+04, 2.2865113815E+01, 5.1241326352E+00, 7.4198465147E+00, 2.6762053379E+00, 9.3065612564E-01],
	[3.2065000000E+04, 2.2871086803E+01, 5.1241339338E+00, 7.4235950107E+00, 2.6767750179E+00, 9.3068851547E-01],
	[3.2070000000E+04, 2.2877060419E+01, 5.1241352322E+00, 7.4273448138E+00, 2.6773445838E+00, 9.3072088907E-01],
	[3.2075000000E+04, 2.2883034664E+01, 5.1241365304E+00, 7.4310959243E+00, 2.6779140355E+00, 9.3075324645E-01],
	[3.2080000000E+04, 2.2889009538E+01, 5.1241378284E+00, 7.4348483425E+00, 2.6784833730E+00, 9.3078558761E-01],
	[3.2085000000E+04, 2.2894985040E+01, 5.1241391263E+00, 7.4386020687E+00, 2.6790525963E+00, 9.3081791256E-01],
	[3.2090000000E+04, 2.2900961171E+01, 5.1241404239E+00, 7.4423571031E+00, 2.6796217054E+00, 9.3085022131E-01],
	[3.2095000000E+04, 2.2906937930E+01, 5.1241417213E+00, 7.4461134459E+00, 2.6801907003E+00, 9.3088251388E-01],
	[3.2100000000E+04, 2.2912915318E+01, 5.1241430185E+00, 7.4498710974E+00, 2.6807595809E+00, 9.3091479025E-01],
	[3.2105000000E+04, 2.2918893334E+01, 5.1241443155E+00, 7.4536300579E+00, 2.6813283472E+00, 9.3094705046E-01],
	[3.2110000000E+04, 2.2924871978E+01, 5.1241456123E+00, 7.4573903275E+00, 2.6818969993E+00, 9.3097929449E-01],
	[3.2115000000E+04, 2.2930851251E+01, 5.1241469089E+00, 7.4611519066E+00, 2.6824655371E+00, 9.3101152237E-01],
	[3.2120000000E+04, 2.2936831152E+01, 5.1241482053E+00, 7.4649147954E+00, 2.6830339605E+00, 9.3104373410E-01],
	[3.2125000000E+04, 2.2942811681E+01, 5.1241495015E+00, 7.4686789942E+00, 2.6836022696E+00, 9.3107592968E-01],
	[3.2130000000E+04, 2.2948792839E+01, 5.1241507975E+00, 7.4724445031E+00, 2.6841704644E+00, 9.3110810912E-01],
	[3.2135000000E+04, 2.2954774625E+01, 5.1241520933E+00, 7.4762113225E+00, 2.6847385447E+00, 9.3114027244E-01],
	[3.2140000000E+04, 2.2960757039E+01, 5.1241533889E+00, 7.4799794526E+00, 2.6853065107E+00, 9.3117241964E-01],
	[3.2145000000E+04, 2.2966740081E+01, 5.1241546843E+00, 7.4837488937E+00, 2.6858743623E+00, 9.3120455073E-01],
	[3.2150000000E+04, 2.2972723751E+01, 5.1241559795E+00, 7.4875196460E+00, 2.6864420995E+00, 9.3123666571E-01],
	[3.2155000000E+04, 2.2978708049E+01, 5.1241572745E+00, 7.4912917097E+00, 2.6870097223E+00, 9.3126876459E-01],
	[3.2160000000E+04, 2.2984692976E+01, 5.1241585693E+00, 7.4950650851E+00, 2.6875772305E+00, 9.3130084739E-01],
	[3.2165000000E+04, 2.2990678530E+01, 5.1241598639E+00, 7.4988397725E+00, 2.6881446244E+00, 9.3133291411E-01],
	[3.2170000000E+04, 2.2996664713E+01, 5.1241611582E+00, 7.5026157722E+00, 2.6887119037E+00, 9.3136496475E-01],
	[3.2175000000E+04, 2.3002651523E+01, 5.1241624524E+00, 7.5063930842E+00, 2.6892790685E+00, 9.3139699934E-01],
	[3.2180000000E+04, 2.3008638961E+01, 5.1241637464E+00, 7.5101717090E+00, 2.6898461188E+00, 9.3142901786E-01],
	[3.2185000000E+04, 2.3014627027E+01, 5.1241650402E+00, 7.5139516468E+00, 2.6904130546E+00, 9.3146102034E-01],
	[3.2190000000E+04, 2.3020615721E+01, 5.1241663338E+00, 7.5177328977E+00, 2.6909798759E+00, 9.3149300677E-01],
	[3.2195000000E+04, 2.3026605043E+01, 5.1241676272E+00, 7.5215154622E+00, 2.6915465825E+00, 9.3152497718E-01],
	[3.2200000000E+04, 2.3032594993E+01, 5.1241689204E+00, 7.5252993403E+00, 2.6921131746E+00, 9.3155693156E-01],
	[3.2205000000E+04, 2.3038585570E+01, 5.1241702134E+00, 7.5290845325E+00, 2.6926796521E+00, 9.3158886992E-01],
	[3.2210000000E+04, 2.3044576775E+01, 5.1241715061E+00, 7.5328710388E+00, 2.6932460150E+00, 9.3162079227E-01],
	[3.2215000000E+04, 2.3050568608E+01, 5.1241727987E+00, 7.5366588596E+00, 2.6938122632E+00, 9.3165269863E-01],
	[3.2220000000E+04, 2.3056561069E+01, 5.1241740911E+00, 7.5404479952E+00, 2.6943783968E+00, 9.3168458899E-01],
	[3.2225000000E+04, 2.3062554157E+01, 5.1241753833E+00, 7.5442384457E+00, 2.6949444157E+00, 9.3171646336E-01],
	[3.2230000000E+04, 2.3068547873E+01, 5.1241766753E+00, 7.5480302115E+00, 2.6955103200E+00, 9.3174832176E-01],
	[3.2235000000E+04, 2.3074542216E+01, 5.1241779671E+00, 7.5518232927E+00, 2.6960761095E+00, 9.3178016419E-01],
	[3.2240000000E+04, 2.3080537187E+01, 5.1241792587E+00, 7.5556176896E+00, 2.6966417844E+00, 9.3181199066E-01],
	[3.2245000000E+04, 2.3086532786E+01, 5.1241805500E+00, 7.5594134026E+00, 2.6972073445E+00, 9.3184380117E-01],
	[3.2250000000E+04, 2.3092529011E+01, 5.1241818412E+00, 7.5632104317E+00, 2.6977727899E+00, 9.3187559574E-01],
	[3.2255000000E+04, 2.3098525865E+01, 5.1241831322E+00, 7.5670087774E+00, 2.6983381205E+00, 9.3190737437E-01],
	[3.2260000000E+04, 2.3104523346E+01, 5.1241844230E+00, 7.5708084398E+00, 2.6989033363E+00, 9.3193913707E-01],
	[3.2265000000E+04, 2.3110521454E+01, 5.1241857136E+00, 7.5746094192E+00, 2.6994684374E+00, 9.3197088386E-01],
	[3.2270000000E+04, 2.3116520189E+01, 5.1241870040E+00, 7.5784117158E+00, 2.7000334236E+00, 9.3200261472E-01],
	[3.2275000000E+04, 2.3122519552E+01, 5.1241882941E+00, 7.5822153299E+00, 2.7005982951E+00, 9.3203432969E-01],
	[3.2280000000E+04, 2.3128519542E+01, 5.1241895841E+00, 7.5860202617E+00, 2.7011630517E+00, 9.3206602875E-01],
	[3.2285000000E+04, 2.3134520160E+01, 5.1241908739E+00, 7.5898265116E+00, 2.7017276934E+00, 9.3209771193E-01],
	[3.2290000000E+04, 2.3140521404E+01, 5.1241921635E+00, 7.5936340796E+00, 2.7022922203E+00, 9.3212937922E-01],
	[3.2295000000E+04, 2.3146523276E+01, 5.1241934529E+00, 7.5974429662E+00, 2.7028566323E+00, 9.3216103064E-01],
	[3.2300000000E+04, 2.3152525775E+01, 5.1241947421E+00, 7.6012531715E+00, 2.7034209294E+00, 9.3219266619E-01],
	[3.2305000000E+04, 2.3158528901E+01, 5.1241960311E+00, 7.6050646959E+00, 2.7039851116E+00, 9.3222428589E-01],
	[3.2310000000E+04, 2.3164532655E+01, 5.1241973199E+00, 7.6088775394E+00, 2.7045491789E+00, 9.3225588973E-01],
	[3.2315000000E+04, 2.3170537035E+01, 5.1241986084E+00, 7.6126917025E+00, 2.7051131312E+00, 9.3228747773E-01],
	[3.2320000000E+04, 2.3176542042E+01, 5.1241998968E+00, 7.6165071853E+00, 2.7056769686E+00, 9.3231904990E-01],
	[3.2325000000E+04, 2.3182547677E+01, 5.1242011850E+00, 7.6203239881E+00, 2.7062406910E+00, 9.3235060624E-01],
	[3.2330000000E+04, 2.3188553938E+01, 5.1242024730E+00, 7.6241421112E+00, 2.7068042984E+00, 9.3238214677E-01],
	[3.2335000000E+04, 2.3194560826E+01, 5.1242037608E+00, 7.6279615548E+00, 2.7073677908E+00, 9.3241367148E-01],
	[3.2340000000E+04, 2.3200568342E+01, 5.1242050484E+00, 7.6317823192E+00, 2.7079311682E+00, 9.3244518039E-01],
	[3.2345000000E+04, 2.3206576484E+01, 5.1242063358E+00, 7.6356044045E+00, 2.7084944305E+00, 9.3247667351E-01],
	[3.2350000000E+04, 2.3212585253E+01, 5.1242076230E+00, 7.6394278111E+00, 2.7090575779E+00, 9.3250815084E-01],
	[3.2355000000E+04, 2.3218594648E+01, 5.1242089100E+00, 7.6432525393E+00, 2.7096206101E+00, 9.3253961239E-01],
	[3.2360000000E+04, 2.3224604671E+01, 5.1242101968E+00, 7.6470785892E+00, 2.7101835273E+00, 9.3257105817E-01],
	[3.2365000000E+04, 2.3230615320E+01, 5.1242114834E+00, 7.6509059611E+00, 2.7107463294E+00, 9.3260248818E-01],
	[3.2370000000E+04, 2.3236626596E+01, 5.1242127698E+00, 7.6547346552E+00, 2.7113090164E+00, 9.3263390244E-01],
	[3.2375000000E+04, 2.3242638499E+01, 5.1242140560E+00, 7.6585646719E+00, 2.7118715882E+00, 9.3266530096E-01],
	[3.2380000000E+04, 2.3248651029E+01, 5.1242153420E+00, 7.6623960114E+00, 2.7124340449E+00, 9.3269668373E-01],
	[3.2385000000E+04, 2.3254664185E+01, 5.1242166279E+00, 7.6662286739E+00, 2.7129963865E+00, 9.3272805078E-01],
	[3.2390000000E+04, 2.3260677967E+01, 5.1242179135E+00, 7.6700626597E+00, 2.7135586129E+00, 9.3275940210E-01],
	[3.2395000000E+04, 2.3266697030E+01, 5.1242198696E+00, 7.6738979690E+00, 2.7141209757E+00, 9.3279073770E-01],
	[3.2400000000E+04, 2.3272732070E+01, 5.1242240374E+00, 7.6777346020E+00, 2.7146840530E+00, 9.3282205760E-01],
	[3.2405000000E+04, 2.3278767744E+01, 5.1242282046E+00, 7.6815733679E+00, 2.7152471168E+00, 9.3285336179E-01],
	[3.2410000000E+04, 2.3284804052E+01, 5.1242323711E+00, 7.6854157615E+00, 2.7158103534E+00, 9.3288465030E-01],
	[3.2415000000E+04, 2.3290840994E+01, 5.1242365370E+00, 7.6892594825E+00, 2.7163734754E+00, 9.3291592312E-01],
	[3.2420000000E+04, 2.3296878569E+01, 5.1242407022E+00, 7.6931045312E+00, 2.7169364825E+00, 9.3294718027E-01],
	[3.2425000000E+04, 2.3302916779E+01, 5.1242448669E+00, 7.6969509078E+00, 2.7174993749E+00, 9.3297842175E-01],
	[3.2430000000E+04, 2.3308955621E+01, 5.1242490308E+00, 7.7007986124E+00, 2.7180621525E+00, 9.3300964756E-01],
	[3.2435000000E+04, 2.3314995097E+01, 5.1242531942E+00, 7.7046476455E+00, 2.7186248153E+00, 9.3304085773E-01],
	[3.2440000000E+04, 2.3321035207E+01, 5.1242573569E+00, 7.7084980072E+00, 2.7191873632E+00, 9.3307205225E-01],
	[3.2445000000E+04, 2.3327075951E+01, 5.1242615189E+00, 7.7123496979E+00, 2.7197497964E+00, 9.3310323113E-01],
	[3.2450000000E+04, 2.3333117327E+01, 5.1242656803E+00, 7.7162027176E+00, 2.7203121146E+00, 9.3313439439E-01],
	[3.2455000000E+04, 2.3339159338E+01, 5.1242698411E+00, 7.7200570668E+00, 2.7208743181E+00, 9.3316554202E-01],
	[3.2460000000E+04, 2.3345201981E+01, 5.1242740013E+00, 7.7239127456E+00, 2.7214364066E+00, 9.3319667405E-01],
	[3.2465000000E+04, 2.3351245258E+01, 5.1242781608E+00, 7.7277697543E+00, 2.7219983803E+00, 9.3322779046E-01],
	[3.2470000000E+04, 2.3357289169E+01, 5.1242823196E+00, 7.7316280932E+00, 2.7225602390E+00, 9.3325889128E-01],
	[3.2475000000E+04, 2.3363333713E+01, 5.1242864779E+00, 7.7354877625E+00, 2.7231219829E+00, 9.3328997652E-01],
	[3.2480000000E+04, 2.3369378890E+01, 5.1242906355E+00, 7.7393487625E+00, 2.7236836118E+00, 9.3332104617E-01],
	[3.2485000000E+04, 2.3375424700E+01, 5.1242947924E+00, 7.7432110934E+00, 2.7242451257E+00, 9.3335210024E-01],
	[3.2490000000E+04, 2.3381471144E+01, 5.1242989487E+00, 7.7470747554E+00, 2.7248065247E+00, 9.3338313876E-01],
	[3.2495000000E+04, 2.3387518221E+01, 5.1243031044E+00, 7.7509397489E+00, 2.7253678087E+00, 9.3341416171E-01],
	[3.2500000000E+04, 2.3393565931E+01, 5.1243072595E+00, 7.7548060741E+00, 2.7259289778E+00, 9.3344516911E-01],
	[3.2505000000E+04, 2.3399614274E+01, 5.1243114139E+00, 7.7586737312E+00, 2.7264900318E+00, 9.3347616098E-01],
	[3.2510000000E+04, 2.3405663251E+01, 5.1243155677E+00, 7.7625427205E+00, 2.7270509708E+00, 9.3350713731E-01],
	[3.2515000000E+04, 2.3411712860E+01, 5.1243197208E+00, 7.7664130422E+00, 2.7276117948E+00, 9.3353809811E-01],
	[3.2520000000E+04, 2.3417763102E+01, 5.1243238733E+00, 7.7702846966E+00, 2.7281725038E+00, 9.3356904339E-01],
	[3.2525000000E+04, 2.3423813978E+01, 5.1243280252E+00, 7.7741576839E+00, 2.7287330977E+00, 9.3359997317E-01],
	[3.2530000000E+04, 2.3429865487E+01, 5.1243321764E+00, 7.7780320045E+00, 2.7292935765E+00, 9.3363088744E-01],
	[3.2535000000E+04, 2.3435917628E+01, 5.1243363270E+00, 7.7819076585E+00, 2.7298539402E+00, 9.3366178622E-01],
	[3.2540000000E+04, 2.3441970402E+01, 5.1243404770E+00, 7.7857846462E+00, 2.7304141889E+00, 9.3369266951E-01],
	[3.2545000000E+04, 2.3448023810E+01, 5.1243446263E+00, 7.7896629679E+00, 2.7309743224E+00, 9.3372353733E-01],
	[3.2550000000E+04, 2.3454077850E+01, 5.1243487750E+00, 7.7935426238E+00, 2.7315343408E+00, 9.3375438967E-01],
	[3.2555000000E+04, 2.3460132523E+01, 5.1243529231E+00, 7.7974236141E+00, 2.7320942441E+00, 9.3378522655E-01],
	[3.2560000000E+04, 2.3466187829E+01, 5.1243570705E+00, 7.8013059392E+00, 2.7326540322E+00, 9.3381604797E-01],
	[3.2565000000E+04, 2.3472243767E+01, 5.1243612173E+00, 7.8051895992E+00, 2.7332137052E+00, 9.3384685395E-01],
	[3.2570000000E+04, 2.3478300339E+01, 5.1243653635E+00, 7.8090745944E+00, 2.7337732630E+00, 9.3387764449E-01],
	[3.2575000000E+04, 2.3484357543E+01, 5.1243695090E+00, 7.8129609252E+00, 2.7343327056E+00, 9.3390841960E-01],
	[3.2580000000E+04, 2.3490415380E+01, 5.1243736539E+00, 7.8168485916E+00, 2.7348920330E+00, 9.3393917927E-01],
	[3.2585000000E+04, 2.3496473849E+01, 5.1243777982E+00, 7.8207375941E+00, 2.7354512452E+00, 9.3396992353E-01],
	[3.2590000000E+04, 2.3502532951E+01, 5.1243819418E+00, 7.8246279327E+00, 2.7360103421E+00, 9.3400065238E-01],
	[3.2595000000E+04, 2.3508592686E+01, 5.1243860848E+00, 7.8285196079E+00, 2.7365693239E+00, 9.3403136582E-01],
	[3.2600000000E+04, 2.3514653053E+01, 5.1243902272E+00, 7.8324126198E+00, 2.7371281903E+00, 9.3406206386E-01],
	[3.2605000000E+04, 2.3520714053E+01, 5.1243943689E+00, 7.8363069687E+00, 2.7376869415E+00, 9.3409274651E-01],
	[3.2610000000E+04, 2.3526775685E+01, 5.1243985100E+00, 7.8402026548E+00, 2.7382455774E+00, 9.3412341377E-01],
	[3.2615000000E+04, 2.3532837950E+01, 5.1244026505E+00, 7.8440996785E+00, 2.7388040981E+00, 9.3415406566E-01],
	[3.2620000000E+04, 2.3538900847E+01, 5.1244067904E+00, 7.8479980399E+00, 2.7393625034E+00, 9.3418470217E-01],
	[3.2625000000E+04, 2.3544964377E+01, 5.1244109296E+00, 7.8518977393E+00, 2.7399207934E+00, 9.3421532333E-01],
	[3.2630000000E+04, 2.3551028539E+01, 5.1244150681E+00, 7.8557987770E+00, 2.7404789681E+00, 9.3424592912E-01],
	[3.2635000000E+04, 2.3557093333E+01, 5.1244192061E+00, 7.8597011532E+00, 2.7410370274E+00, 9.3427651956E-01],
	[3.2640000000E+04, 2.3563158760E+01, 5.1244233434E+00, 7.8636048682E+00, 2.7415949714E+00, 9.3430709466E-01],
	[3.2645000000E+04, 2.3569224818E+01, 5.1244274801E+00, 7.8675099221E+00, 2.7421528000E+00, 9.3433765443E-01],
	[3.2650000000E+04, 2.3575291510E+01, 5.1244316162E+00, 7.8714163154E+00, 2.7427105132E+00, 9.3436819886E-01],
	[3.2655000000E+04, 2.3581358833E+01, 5.1244357516E+00, 7.8753240482E+00, 2.7432681111E+00, 9.3439872797E-01],
	[3.2660000000E+04, 2.3587426789E+01, 5.1244398864E+00, 7.8792331208E+00, 2.7438255935E+00, 9.3442924177E-01],
	[3.2665000000E+04, 2.3593495376E+01, 5.1244440206E+00, 7.8831435334E+00, 2.7443829605E+00, 9.3445974026E-01],
	[3.2670000000E+04, 2.3599564596E+01, 5.1244481541E+00, 7.8870552863E+00, 2.7449402121E+00, 9.3449022344E-01],
	[3.2675000000E+04, 2.3605634448E+01, 5.1244522870E+00, 7.8909683797E+00, 2.7454973482E+00, 9.3452069134E-01],
	[3.2680000000E+04, 2.3611704932E+01, 5.1244564193E+00, 7.8948828139E+00, 2.7460543689E+00, 9.3455114394E-01],
	[3.2685000000E+04, 2.3617776048E+01, 5.1244605510E+00, 7.8987985892E+00, 2.7466112741E+00, 9.3458158126E-01],
	[3.2690000000E+04, 2.3623847796E+01, 5.1244646820E+00, 7.9027157058E+00, 2.7471680639E+00, 9.3461200331E-01],
	[3.2695000000E+04, 2.3629920176E+01, 5.1244688124E+00, 7.9066341639E+00, 2.7477247381E+00, 9.3464241010E-01],
	[3.2700000000E+04, 2.3635993188E+01, 5.1244729421E+00, 7.9105539639E+00, 2.7482812969E+00, 9.3467280162E-01],
	[3.2705000000E+04, 2.3642066832E+01, 5.1244770713E+00, 7.9144751059E+00, 2.7488377401E+00, 9.3470317789E-01],
	[3.2710000000E+04, 2.3648141108E+01, 5.1244811998E+00, 7.9183975902E+00, 2.7493940678E+00, 9.3473353892E-01],
	[3.2715000000E+04, 2.3654216016E+01, 5.1244853277E+00, 7.9223214171E+00, 2.7499502800E+00, 9.3476388470E-01],
	[3.2720000000E+04, 2.3660291555E+01, 5.1244894549E+00, 7.9262465869E+00, 2.7505063766E+00, 9.3479421526E-01],
	[3.2725000000E+04, 2.3666367726E+01, 5.1244935816E+00, 7.9301730997E+00, 2.7510623577E+00, 9.3482453059E-01],
	[3.2730000000E+04, 2.3672444529E+01, 5.1244977076E+00, 7.9341009558E+00, 2.7516182231E+00, 9.3485483070E-01],
	[3.2735000000E+04, 2.3678521964E+01, 5.1245018329E+00, 7.9380301555E+00, 2.7521739730E+00, 9.3488511560E-01],
	[3.2740000000E+04, 2.3684600031E+01, 5.1245059577E+00, 7.9419606991E+00, 2.7527296073E+00, 9.3491538529E-01],
	[3.2745000000E+04, 2.3690678729E+01, 5.1245100818E+00, 7.9458925867E+00, 2.7532851260E+00, 9.3494563979E-01],
	[3.2750000000E+04, 2.3696758058E+01, 5.1245142053E+00, 7.9498258187E+00, 2.7538405291E+00, 9.3497587910E-01],
	[3.2755000000E+04, 2.3702838020E+01, 5.1245183282E+00, 7.9537603953E+00, 2.7543958165E+00, 9.3500610323E-01],
	[3.2760000000E+04, 2.3708918613E+01, 5.1245224504E+00, 7.9576963167E+00, 2.7549509883E+00, 9.3503631218E-01],
	[3.2765000000E+04, 2.3714999837E+01, 5.1245265720E+00, 7.9616335832E+00, 2.7555060445E+00, 9.3506650596E-01],
	[3.2770000000E+04, 2.3721081693E+01, 5.1245306930E+00, 7.9655721951E+00, 2.7560609849E+00, 9.3509668458E-01],
	[3.2775000000E+04, 2.3727164181E+01, 5.1245348134E+00, 7.9695121526E+00, 2.7566158097E+00, 9.3512684805E-01],
	[3.2780000000E+04, 2.3733247300E+01, 5.1245389331E+00, 7.9734534560E+00, 2.7571705188E+00, 9.3515699636E-01],
	[3.2785000000E+04, 2.3739331050E+01, 5.1245430523E+00, 7.9773961055E+00, 2.7577251122E+00, 9.3518712954E-01],
	[3.2790000000E+04, 2.3745415432E+01, 5.1245471707E+00, 7.9813401014E+00, 2.7582795899E+00, 9.3521724758E-01],
	[3.2795000000E+04, 2.3751500445E+01, 5.1245512886E+00, 7.9852854438E+00, 2.7588339519E+00, 9.3524735050E-01],
	[3.2800000000E+04, 2.3757586089E+01, 5.1245554059E+00, 7.9892321332E+00, 2.7593881981E+00, 9.3527743829E-01],
	[3.2805000000E+04, 2.3763672365E+01, 5.1245595225E+00, 7.9931801697E+00, 2.7599423286E+00, 9.3530751097E-01],
	[3.2810000000E+04, 2.3769759272E+01, 5.1245636385E+00, 7.9971295536E+00, 2.7604963433E+00, 9.3533756855E-01],
	[3.2815000000E+04, 2.3775846810E+01, 5.1245677538E+00, 8.0010802851E+00, 2.7610502423E+00, 9.3536761102E-01],
	[3.2820000000E+04, 2.3781934979E+01, 5.1245718686E+00, 8.0050323646E+00, 2.7616040255E+00, 9.3539763841E-01],
	[3.2825000000E+04, 2.3788023780E+01, 5.1245759827E+00, 8.0089857921E+00, 2.7621576928E+00, 9.3542765071E-01],
	[3.2830000000E+04, 2.3794113212E+01, 5.1245800962E+00, 8.0129405681E+00, 2.7627112444E+00, 9.3545764793E-01],
	[3.2835000000E+04, 2.3800203274E+01, 5.1245842091E+00, 8.0168966927E+00, 2.7632646802E+00, 9.3548763008E-01],
	[3.2840000000E+04, 2.3806293968E+01, 5.1245883213E+00, 8.0208541663E+00, 2.7638180002E+00, 9.3551759717E-01],
	[3.2845000000E+04, 2.3812385293E+01, 5.1245924330E+00, 8.0248129890E+00, 2.7643712043E+00, 9.3554754919E-01],
	[3.2850000000E+04, 2.3818477249E+01, 5.1245965440E+00, 8.0287731611E+00, 2.7649242926E+00, 9.3557748617E-01],
	[3.2855000000E+04, 2.3824569836E+01, 5.1246006544E+00, 8.0327346829E+00, 2.7654772650E+00, 9.3560740811E-01],
	[3.2860000000E+04, 2.3830663054E+01, 5.1246047641E+00, 8.0366975546E+00, 2.7660301215E+00, 9.3563731501E-01],
	[3.2865000000E+04, 2.3836756903E+01, 5.1246088733E+00, 8.0406617765E+00, 2.7665828622E+00, 9.3566720688E-01],
	[3.2870000000E+04, 2.3842851383E+01, 5.1246129818E+00, 8.0446273488E+00, 2.7671354870E+00, 9.3569708373E-01],
	[3.2875000000E+04, 2.3848946494E+01, 5.1246170897E+00, 8.0485942718E+00, 2.7676879959E+00, 9.3572694556E-01],
	[3.2880000000E+04, 2.3855042235E+01, 5.1246211970E+00, 8.0525625458E+00, 2.7682403889E+00, 9.3575679239E-01],
	[3.2885000000E+04, 2.3861138607E+01, 5.1246253036E+00, 8.0565321709E+00, 2.7687926659E+00, 9.3578662421E-01],
	[3.2890000000E+04, 2.3867235610E+01, 5.1246294096E+00, 8.0605031475E+00, 2.7693448271E+00, 9.3581644104E-01],
	[3.2895000000E+04, 2.3873333244E+01, 5.1246335151E+00, 8.0644754757E+00, 2.7698968723E+00, 9.3584624289E-01],
	[3.2900000000E+04, 2.3879431509E+01, 5.1246376199E+00, 8.0684491560E+00, 2.7704488015E+00, 9.3587602975E-01],
	[3.2905000000E+04, 2.3885530404E+01, 5.1246417240E+00, 8.0724241884E+00, 2.7710006148E+00, 9.3590580164E-01],
	[3.2910000000E+04, 2.3891629930E+01, 5.1246458276E+00, 8.0764005733E+00, 2.7715523121E+00, 9.3593555857E-01],
	[3.2915000000E+04, 2.3897730086E+01, 5.1246499305E+00, 8.0803783109E+00, 2.7721038934E+00, 9.3596530053E-01],
	[3.2920000000E+04, 2.3903849329E+01, 5.1246566697E+00, 8.0843574015E+00, 2.7726563790E+00, 9.3599502755E-01],
	[3.2925000000E+04, 2.3909970527E+01, 5.1246635963E+00, 8.0883378453E+00, 2.7732088219E+00, 9.3602473962E-01],
	[3.2930000000E+04, 2.3916092363E+01, 5.1246705217E+00, 8.0923196426E+00, 2.7737611494E+00, 9.3605443675E-01],
	[3.2935000000E+04, 2.3922214836E+01, 5.1246774462E+00, 8.0963027936E+00, 2.7743133615E+00, 9.3608411895E-01],
	[3.2940000000E+04, 2.3928337947E+01, 5.1246843696E+00, 8.1002872986E+00, 2.7748654581E+00, 9.3611378623E-01],
	[3.2945000000E+04, 2.3934461696E+01, 5.1246912920E+00, 8.1042731579E+00, 2.7754174392E+00, 9.3614343859E-01],
	[3.2950000000E+04, 2.3940586082E+01, 5.1246982133E+00, 8.1082603716E+00, 2.7759693048E+00, 9.3617307604E-01],
	[3.2955000000E+04, 2.3946711105E+01, 5.1247051336E+00, 8.1122489401E+00, 2.7765210549E+00, 9.3620269859E-01],
	[3.2960000000E+04, 2.3952836766E+01, 5.1247120528E+00, 8.1162388636E+00, 2.7770726895E+00, 9.3623230624E-01],
	[3.2965000000E+04, 2.3958963065E+01, 5.1247189710E+00, 8.1202301423E+00, 2.7776242086E+00, 9.3626189900E-01],
	[3.2970000000E+04, 2.3965090000E+01, 5.1247258882E+00, 8.1242227765E+00, 2.7781756122E+00, 9.3629147688E-01],
	[3.2975000000E+04, 2.3971217574E+01, 5.1247328043E+00, 8.1282167665E+00, 2.7787269002E+00, 9.3632103989E-01],
	[3.2980000000E+04, 2.3977345784E+01, 5.1247397194E+00, 8.1322121126E+00, 2.7792780727E+00, 9.3635058803E-01],
	[3.2985000000E+04, 2.3983474632E+01, 5.1247466335E+00, 8.1362088148E+00, 2.7798291297E+00, 9.3638012131E-01],
	[3.2990000000E+04, 2.3989604117E+01, 5.1247535465E+00, 8.1402068736E+00, 2.7803800710E+00, 9.3640963973E-01],
	[3.2995000000E+04, 2.3995734239E+01, 5.1247604584E+00, 8.1442062892E+00, 2.7809308968E+00, 9.3643914331E-01],
	[3.3000000000E+04, 2.4001864999E+01, 5.1247673694E+00, 8.1482070618E+00, 2.7814816070E+00, 9.3646863205E-01],
	[3.3005000000E+04, 2.4007996396E+01, 5.1247742793E+00, 8.1522091917E+00, 2.7820322017E+00, 9.3649810596E-01],
	[3.3010000000E+04, 2.4014128430E+01, 5.1247811881E+00, 8.1562126792E+00, 2.7825826807E+00, 9.3652756504E-01],
	[3.3015000000E+04, 2.4020261101E+01, 5.1247880960E+00, 8.1602175244E+00, 2.7831330441E+00, 9.3655700931E-01],
	[3.3020000000E+04, 2.4026394409E+01, 5.1247950027E+00, 8.1642237277E+00, 2.7836832918E+00, 9.3658643876E-01],
	[3.3025000000E+04, 2.4032528354E+01, 5.1248019085E+00, 8.1682312893E+00, 2.7842334240E+00, 9.3661585340E-01],
	[3.3030000000E+04, 2.4038662936E+01, 5.1248088132E+00, 8.1722402094E+00, 2.7847834404E+00, 9.3664525325E-01],
	[3.3035000000E+04, 2.4044798155E+01, 5.1248157169E+00, 8.1762504884E+00, 2.7853333413E+00, 9.3667463831E-01],
	[3.3040000000E+04, 2.4050934011E+01, 5.1248226195E+00, 8.1802621264E+00, 2.7858831264E+00, 9.3670400859E-01],
	[3.3045000000E+04, 2.4057070504E+01, 5.1248295211E+00, 8.1842751237E+00, 2.7864327959E+00, 9.3673336409E-01],
	[3.3050000000E+04, 2.4063207634E+01, 5.1248364217E+00, 8.1882894806E+00, 2.7869823498E+00, 9.3676270482E-01],
	[3.3055000000E+04, 2.4069345401E+01, 5.1248433212E+00, 8.1923051973E+00, 2.7875317879E+00, 9.3679203079E-01],
	[3.3060000000E+04, 2.4075483805E+01, 5.1248502197E+00, 8.1963222741E+00, 2.7880811103E+00, 9.3682134201E-01],
	[3.3065000000E+04, 2.4081622846E+01, 5.1248571172E+00, 8.2003407112E+00, 2.7886303170E+00, 9.3685063847E-01],
	[3.3070000000E+04, 2.4087762523E+01, 5.1248640136E+00, 8.2043605090E+00, 2.7891794080E+00, 9.3687992020E-01],
	[3.3075000000E+04, 2.4093902837E+01, 5.1248709090E+00, 8.2083816675E+00, 2.7897283833E+00, 9.3690918719E-01],
	[3.3080000000E+04, 2.4100043788E+01, 5.1248778034E+00, 8.2124041872E+00, 2.7902772428E+00, 9.3693843945E-01],
	[3.3085000000E+04, 2.4106185375E+01, 5.1248846967E+00, 8.2164280682E+00, 2.7908259866E+00, 9.3696767700E-01],
	[3.3090000000E+04, 2.4112327600E+01, 5.1248915890E+00, 8.2204533108E+00, 2.7913746147E+00, 9.3699689983E-01],
	[3.3095000000E+04, 2.4118470460E+01, 5.1248984803E+00, 8.2244799153E+00, 2.7919231269E+00, 9.3702610795E-01],
	[3.3100000000E+04, 2.4124613958E+01, 5.1249053705E+00, 8.2285078819E+00, 2.7924715234E+00, 9.3705530138E-01],
	[3.3105000000E+04, 2.4130758092E+01, 5.1249122597E+00, 8.2325372108E+00, 2.7930198041E+00, 9.3708448012E-01],
	[3.3110000000E+04, 2.4136902862E+01, 5.1249191479E+00, 8.2365679024E+00, 2.7935679691E+00, 9.3711364417E-01],
	[3.3115000000E+04, 2.4143048269E+01, 5.1249260351E+00, 8.2405999568E+00, 2.7941160182E+00, 9.3714279354E-01],
	[3.3120000000E+04, 2.4149194313E+01, 5.1249329212E+00, 8.2446333744E+00, 2.7946639515E+00, 9.3717192824E-01],
	[3.3125000000E+04, 2.4155340993E+01, 5.1249398063E+00, 8.2486681553E+00, 2.7952117690E+00, 9.3720104828E-01],
	[3.3130000000E+04, 2.4161488310E+01, 5.1249466903E+00, 8.2527042999E+00, 2.7957594707E+00, 9.3723015366E-01],
	[3.3135000000E+04, 2.4167636262E+01, 5.1249535733E+00, 8.2567418084E+00, 2.7963070565E+00, 9.3725924439E-01],
	[3.3140000000E+04, 2.4173784852E+01, 5.1249604553E+00, 8.2607806810E+00, 2.7968545265E+00, 9.3728832048E-01],
	[3.3145000000E+04, 2.4179934077E+01, 5.1249673363E+00, 8.2648209181E+00, 2.7974018806E+00, 9.3731738194E-01],
	[3.3150000000E+04, 2.4186083939E+01, 5.1249742162E+00, 8.2688625197E+00, 2.7979491189E+00, 9.3734642877E-01],
	[3.3155000000E+04, 2.4192234437E+01, 5.1249810951E+00, 8.2729054863E+00, 2.7984962413E+00, 9.3737546097E-01],
	[3.3160000000E+04, 2.4198385571E+01, 5.1249879730E+00, 8.2769498181E+00, 2.7990432478E+00, 9.3740447856E-01],
	[3.3165000000E+04, 2.4204537342E+01, 5.1249948499E+00, 8.2809955153E+00, 2.7995901385E+00, 9.3743348155E-01],
	[3.3170000000E+04, 2.4210689749E+01, 5.1250017257E+00, 8.2850425781E+00, 2.8001369132E+00, 9.3746246993E-01],
	[3.3175000000E+04, 2.4216842792E+01, 5.1250086005E+00, 8.2890910069E+00, 2.8006835721E+00, 9.3749144372E-01],
	[3.3180000000E+04, 2.4222996471E+01, 5.1250154743E+00, 8.2931408018E+00, 2.8012301150E+00, 9.3752040292E-01],
	[3.3185000000E+04, 2.4229150786E+01, 5.1250223470E+00, 8.2971919632E+00, 2.8017765420E+00, 9.3754934755E-01],
	[3.3190000000E+04, 2.4235305737E+01, 5.1250292187E+00, 8.3012444912E+00, 2.8023228531E+00, 9.3757827760E-01],
	[3.3195000000E+04, 2.4241461324E+01, 5.1250360894E+00, 8.3052983863E+00, 2.8028690483E+00, 9.3760719309E-01],
	[3.3200000000E+04, 2.4247617548E+01, 5.1250429591E+00, 8.3093536485E+00, 2.8034151275E+00, 9.3763609402E-01],
	[3.3205000000E+04, 2.4253774407E+01, 5.1250498277E+00, 8.3134102781E+00, 2.8039610907E+00, 9.3766498040E-01],
	[3.3210000000E+04, 2.4259931902E+01, 5.1250566953E+00, 8.3174682755E+00, 2.8045069380E+00, 9.3769385223E-01],
	[3.3215000000E+04, 2.4266090033E+01, 5.1250635619E+00, 8.3215276408E+00, 2.8050526693E+00, 9.3772270953E-01],
	[3.3220000000E+04, 2.4272248800E+01, 5.1250704275E+00, 8.3255883743E+00, 2.8055982847E+00, 9.3775155230E-01],
	[3.3225000000E+04, 2.4278408203E+01, 5.1250772920E+00, 8.3296504763E+00, 2.8061437840E+00, 9.3778038055E-01],
	[3.3230000000E+04, 2.4284568241E+01, 5.1250841556E+00, 8.3337139471E+00, 2.8066891674E+00, 9.3780919428E-01],
	[3.3235000000E+04, 2.4290728916E+01, 5.1250910181E+00, 8.3377787868E+00, 2.8072344348E+00, 9.3783799350E-01],
	[3.3240000000E+04, 2.4296890226E+01, 5.1250978795E+00, 8.3418449957E+00, 2.8077795861E+00, 9.3786677822E-01],
	[3.3245000000E+04, 2.4303052172E+01, 5.1251047400E+00, 8.3459125741E+00, 2.8083246215E+00, 9.3789554845E-01],
	[3.3250000000E+04, 2.4309214754E+01, 5.1251115994E+00, 8.3499815223E+00, 2.8088695408E+00, 9.3792430419E-01],
	[3.3255000000E+04, 2.4315377971E+01, 5.1251184578E+00, 8.3540518404E+00, 2.8094143441E+00, 9.3795304544E-01],
	[3.3260000000E+04, 2.4321541824E+01, 5.1251253152E+00, 8.3581235288E+00, 2.8099590313E+00, 9.3798177223E-01],
	[3.3265000000E+04, 2.4327706312E+01, 5.1251321716E+00, 8.3621965877E+00, 2.8105036025E+00, 9.3801048455E-01],
	[3.3270000000E+04, 2.4333871436E+01, 5.1251390269E+00, 8.3662710174E+00, 2.8110480577E+00, 9.3803918241E-01],
	[3.3275000000E+04, 2.4340037196E+01, 5.1251458812E+00, 8.3703468181E+00, 2.8115923967E+00, 9.3806786581E-01],
	[3.3280000000E+04, 2.4346203591E+01, 5.1251527345E+00, 8.3744239900E+00, 2.8121366198E+00, 9.3809653478E-01],
	[3.3285000000E+04, 2.4352370622E+01, 5.1251595868E+00, 8.3785025335E+00, 2.8126807267E+00, 9.3812518930E-01],
	[3.3290000000E+04, 2.4358538288E+01, 5.1251664381E+00, 8.3825824487E+00, 2.8132247175E+00, 9.3815382939E-01],
	[3.3295000000E+04, 2.4364706590E+01, 5.1251732883E+00, 8.3866637360E+00, 2.8137685923E+00, 9.3818245506E-01],
	[3.3300000000E+04, 2.4370875527E+01, 5.1251801375E+00, 8.3907463955E+00, 2.8143123509E+00, 9.3821106631E-01],
	[3.3305000000E+04, 2.4377045099E+01, 5.1251869857E+00, 8.3948304276E+00, 2.8148559935E+00, 9.3823966315E-01],
	[3.3310000000E+04, 2.4383215307E+01, 5.1251938329E+00, 8.3989158325E+00, 2.8153995199E+00, 9.3826824559E-01],
	[3.3315000000E+04, 2.4389386150E+01, 5.1252006791E+00, 8.4030026104E+00, 2.8159429302E+00, 9.3829681364E-01],
	[3.3320000000E+04, 2.4395557628E+01, 5.1252075242E+00, 8.4070907617E+00, 2.8164862244E+00, 9.3832536729E-01],
	[3.3325000000E+04, 2.4401729742E+01, 5.1252143683E+00, 8.4111802864E+00, 2.8170294024E+00, 9.3835390656E-01],
	[3.3330000000E+04, 2.4407902491E+01, 5.1252212114E+00, 8.4152711850E+00, 2.8175724643E+00, 9.3838243146E-01],
	[3.3335000000E+04, 2.4414075875E+01, 5.1252280535E+00, 8.4193634577E+00, 2.8181154101E+00, 9.3841094199E-01],
	[3.3340000000E+04, 2.4420249894E+01, 5.1252348946E+00, 8.4234571047E+00, 2.8186582397E+00, 9.3843943816E-01],
	[3.3345000000E+04, 2.4426424548E+01, 5.1252417347E+00, 8.4275521263E+00, 2.8192009531E+00, 9.3846791998E-01],
	[3.3350000000E+04, 2.4432599838E+01, 5.1252485737E+00, 8.4316485227E+00, 2.8197435504E+00, 9.3849638745E-01],
	[3.3355000000E+04, 2.4438775762E+01, 5.1252554117E+00, 8.4357462941E+00, 2.8202860314E+00, 9.3852484058E-01],
	[3.3360000000E+04, 2.4444952322E+01, 5.1252622487E+00, 8.4398454410E+00, 2.8208283963E+00, 9.3855327938E-01],
	[3.3365000000E+04, 2.4451129516E+01, 5.1252690847E+00, 8.4439459634E+00, 2.8213706450E+00, 9.3858170385E-01],
	[3.3370000000E+04, 2.4457307346E+01, 5.1252759197E+00, 8.4480478616E+00, 2.8219127775E+00, 9.3861011400E-01],
	[3.3375000000E+04, 2.4463485810E+01, 5.1252827537E+00, 8.4521511360E+00, 2.8224547938E+00, 9.3863850985E-01],
	[3.3380000000E+04, 2.4469664910E+01, 5.1252895866E+00, 8.4562557867E+00, 2.8229966938E+00, 9.3866689138E-01],
	[3.3385000000E+04, 2.4475844644E+01, 5.1252964186E+00, 8.4603618140E+00, 2.8235384777E+00, 9.3869525863E-01],
	[3.3390000000E+04, 2.4482025013E+01, 5.1253032495E+00, 8.4644692182E+00, 2.8240801453E+00, 9.3872361158E-01],
	[3.3395000000E+04, 2.4488206017E+01, 5.1253100794E+00, 8.4685779996E+00, 2.8246216967E+00, 9.3875195025E-01],
	[3.3400000000E+04, 2.4494387656E+01, 5.1253169083E+00, 8.4726881583E+00, 2.8251631319E+00, 9.3878027464E-01],
	[3.3405000000E+04, 2.4500569929E+01, 5.1253237362E+00, 8.4767996946E+00, 2.8257044508E+00, 9.3880858476E-01],
	[3.3410000000E+04, 2.4506752838E+01, 5.1253305630E+00, 8.4809126088E+00, 2.8262456534E+00, 9.3883688062E-01],
	[3.3415000000E+04, 2.4512936381E+01, 5.1253373889E+00, 8.4850269011E+00, 2.8267867398E+00, 9.3886516223E-01],
	[3.3420000000E+04, 2.4519120558E+01, 5.1253442137E+00, 8.4891425719E+00, 2.8273277099E+00, 9.3889342959E-01],
	[3.3425000000E+04, 2.4525305371E+01, 5.1253510376E+00, 8.4932596213E+00, 2.8278685637E+00, 9.3892168271E-01],
	[3.3430000000E+04, 2.4531490818E+01, 5.1253578604E+00, 8.4973780496E+00, 2.8284093013E+00, 9.3894992159E-01],
	[3.3435000000E+04, 2.4537676899E+01, 5.1253646822E+00, 8.5014978570E+00, 2.8289499226E+00, 9.3897814625E-01],
	[3.3440000000E+04, 2.4543863615E+01, 5.1253715030E+00, 8.5056190439E+00, 2.8294904276E+00, 9.3900635669E-01],
	[3.3445000000E+04, 2.4550050966E+01, 5.1253783228E+00, 8.5097416105E+00, 2.8300308163E+00, 9.3903455291E-01],
	[3.3450000000E+04, 2.4556257610E+01, 5.1253877858E+00, 8.5138655569E+00, 2.8305721430E+00, 9.3906273493E-01],
	[3.3455000000E+04, 2.4562465775E+01, 5.1253973722E+00, 8.5179908836E+00, 2.8311134038E+00, 9.3909090275E-01],
	[3.3460000000E+04, 2.4568674582E+01, 5.1254069572E+00, 8.5221175906E+00, 2.8316545488E+00, 9.3911905638E-01],
	[3.3465000000E+04, 2.4574884030E+01, 5.1254165408E+00, 8.5262456784E+00, 2.8321955780E+00, 9.3914719583E-01],
	[3.3470000000E+04, 2.4581094119E+01, 5.1254261229E+00, 8.5303751471E+00, 2.8327364914E+00, 9.3917532109E-01],
	[3.3475000000E+04, 2.4587304850E+01, 5.1254357037E+00, 8.5345059970E+00, 2.8332772891E+00, 9.3920343219E-01],
	[3.3480000000E+04, 2.4593516222E+01, 5.1254452830E+00, 8.5386382283E+00, 2.8338179709E+00, 9.3923152913E-01],
	[3.3485000000E+04, 2.4599728236E+01, 5.1254548610E+00, 8.5427718414E+00, 2.8343585369E+00, 9.3925961190E-01],
	[3.3490000000E+04, 2.4605940890E+01, 5.1254644375E+00, 8.5469068364E+00, 2.8348989872E+00, 9.3928768053E-01],
	[3.3495000000E+04, 2.4612154186E+01, 5.1254740126E+00, 8.5510432136E+00, 2.8354393216E+00, 9.3931573502E-01],
	[3.3500000000E+04, 2.4618368123E+01, 5.1254835863E+00, 8.5551809733E+00, 2.8359795401E+00, 9.3934377537E-01],
	[3.3505000000E+04, 2.4624582701E+01, 5.1254931586E+00, 8.5593201158E+00, 2.8365196429E+00, 9.3937180159E-01],
	[3.3510000000E+04, 2.4630797920E+01, 5.1255027295E+00, 8.5634606412E+00, 2.8370596298E+00, 9.3939981369E-01],
	[3.3515000000E+04, 2.4637013780E+01, 5.1255122990E+00, 8.5676025498E+00, 2.8375995009E+00, 9.3942781168E-01],
	[3.3520000000E+04, 2.4643230281E+01, 5.1255218670E+00, 8.5717458420E+00, 2.8381392561E+00, 9.3945579556E-01],
	[3.3525000000E+04, 2.4649447424E+01, 5.1255314337E+00, 8.5758905178E+00, 2.8386788955E+00, 9.3948376534E-01],
	[3.3530000000E+04, 2.4655665207E+01, 5.1255409989E+00, 8.5800365777E+00, 2.8392184190E+00, 9.3951172103E-01],
	[3.3535000000E+04, 2.4661883631E+01, 5.1255505627E+00, 8.5841840218E+00, 2.8397578266E+00, 9.3953966263E-01],
	[3.3540000000E+04, 2.4668102696E+01, 5.1255601252E+00, 8.5883328505E+00, 2.8402971184E+00, 9.3956759016E-01],
	[3.3545000000E+04, 2.4674322402E+01, 5.1255696862E+00, 8.5924830639E+00, 2.8408362943E+00, 9.3959550361E-01],
	[3.3550000000E+04, 2.4680542749E+01, 5.1255792458E+00, 8.5966346623E+00, 2.8413753544E+00, 9.3962340300E-01],
	[3.3555000000E+04, 2.4686763736E+01, 5.1255888040E+00, 8.6007876460E+00, 2.8419142985E+00, 9.3965128832E-01],
	[3.3560000000E+04, 2.4692985365E+01, 5.1255983608E+00, 8.6049420153E+00, 2.8424531267E+00, 9.3967915960E-01],
	[3.3565000000E+04, 2.4699207634E+01, 5.1256079162E+00, 8.6090977703E+00, 2.8429918391E+00, 9.3970701684E-01],
	[3.3570000000E+04, 2.4705430544E+01, 5.1256174702E+00, 8.6132549113E+00, 2.8435304355E+00, 9.3973486004E-01],
	[3.3575000000E+04, 2.4711654095E+01, 5.1256270227E+00, 8.6174134387E+00, 2.8440689160E+00, 9.3976268920E-01],
	[3.3580000000E+04, 2.4717878286E+01, 5.1256365739E+00, 8.6215733526E+00, 2.8446072806E+00, 9.3979050435E-01],
	[3.3585000000E+04, 2.4724103118E+01, 5.1256461237E+00, 8.6257346533E+00, 2.8451455293E+00, 9.3981830548E-01],
	[3.3590000000E+04, 2.4730328591E+01, 5.1256556721E+00, 8.6298973410E+00, 2.8456836621E+00, 9.3984609260E-01],
	[3.3595000000E+04, 2.4736554704E+01, 5.1256652190E+00, 8.6340614161E+00, 2.8462216789E+00, 9.3987386572E-01],
	[3.3600000000E+04, 2.4742781458E+01, 5.1256747646E+00, 8.6382268788E+00, 2.8467595798E+00, 9.3990162485E-01],
	[3.3605000000E+04, 2.4749008852E+01, 5.1256843087E+00, 8.6423937292E+00, 2.8472973647E+00, 9.3992936999E-01],
	[3.3610000000E+04, 2.4755236887E+01, 5.1256938515E+00, 8.6465619678E+00, 2.8478350337E+00, 9.3995710114E-01],
	[3.3615000000E+04, 2.4761465562E+01, 5.1257033929E+00, 8.6507315947E+00, 2.8483725868E+00, 9.3998481833E-01],
	[3.3620000000E+04, 2.4767694878E+01, 5.1257129328E+00, 8.6549026101E+00, 2.8489100238E+00, 9.4001252155E-01],
	[3.3625000000E+04, 2.4773924834E+01, 5.1257224714E+00, 8.6590750144E+00, 2.8494473450E+00, 9.4004021081E-01],
	[3.3630000000E+04, 2.4780155430E+01, 5.1257320085E+00, 8.6632488079E+00, 2.8499845501E+00, 9.4006788611E-01],
	[3.3635000000E+04, 2.4786386667E+01, 5.1257415443E+00, 8.6674239906E+00, 2.8505216393E+00, 9.4009554747E-01],
	[3.3640000000E+04, 2.4792618544E+01, 5.1257510786E+00, 8.6716005630E+00, 2.8510586125E+00, 9.4012319490E-01],
	[3.3645000000E+04, 2.4798851062E+01, 5.1257606116E+00, 8.6757785253E+00, 2.8515954697E+00, 9.4015082839E-01],
	[3.3650000000E+04, 2.4805084220E+01, 5.1257701431E+00, 8.6799578776E+00, 2.8521322109E+00, 9.4017844796E-01],
	[3.3655000000E+04, 2.4811318018E+01, 5.1257796733E+00, 8.6841386204E+00, 2.8526688361E+00, 9.4020605361E-01],
	[3.3660000000E+04, 2.4817552456E+01, 5.1257892020E+00, 8.6883207537E+00, 2.8532053454E+00, 9.4023364535E-01],
	[3.3665000000E+04, 2.4823787534E+01, 5.1257987294E+00, 8.6925042780E+00, 2.8537417386E+00, 9.4026122319E-01],
	[3.3670000000E+04, 2.4830023253E+01, 5.1258082554E+00, 8.6966891934E+00, 2.8542780158E+00, 9.4028878713E-01],
	[3.3675000000E+04, 2.4836259612E+01, 5.1258177799E+00, 8.7008755001E+00, 2.8548141770E+00, 9.4031633718E-01],
	[3.3680000000E+04, 2.4842496610E+01, 5.1258273031E+00, 8.7050631986E+00, 2.8553502221E+00, 9.4034387335E-01],
	[3.3685000000E+04, 2.4848734249E+01, 5.1258368249E+00, 8.7092522889E+00, 2.8558861513E+00, 9.4037139564E-01],
	[3.3690000000E+04, 2.4854972528E+01, 5.1258463452E+00, 8.7134427714E+00, 2.8564219644E+00, 9.4039890407E-01],
	[3.3695000000E+04, 2.4861211447E+01, 5.1258558642E+00, 8.7176346464E+00, 2.8569576615E+00, 9.4042639864E-01],
	[3.3700000000E+04, 2.4867451006E+01, 5.1258653818E+00, 8.7218279139E+00, 2.8574932426E+00, 9.4045387935E-01],
	[3.3705000000E+04, 2.4873691205E+01, 5.1258748980E+00, 8.7260225745E+00, 2.8580287076E+00, 9.4048134622E-01],
	[3.3710000000E+04, 2.4879932044E+01, 5.1258844128E+00, 8.7302186282E+00, 2.8585640565E+00, 9.4050879924E-01],
	[3.3715000000E+04, 2.4886173522E+01, 5.1258939262E+00, 8.7344160753E+00, 2.8590992894E+00, 9.4053623843E-01],
	[3.3720000000E+04, 2.4892415641E+01, 5.1259034382E+00, 8.7386149161E+00, 2.8596344063E+00, 9.4056366380E-01],
	[3.3725000000E+04, 2.4898658399E+01, 5.1259129488E+00, 8.7428151509E+00, 2.8601694071E+00, 9.4059107535E-01],
	[3.3730000000E+04, 2.4904901797E+01, 5.1259224581E+00, 8.7470167799E+00, 2.8607042918E+00, 9.4061847309E-01],
	[3.3735000000E+04, 2.4911145835E+01, 5.1259319659E+00, 8.7512198033E+00, 2.8612390604E+00, 9.4064585702E-01],
	[3.3740000000E+04, 2.4917390513E+01, 5.1259414724E+00, 8.7554242214E+00, 2.8617737130E+00, 9.4067322715E-01],
	[3.3745000000E+04, 2.4923635830E+01, 5.1259509774E+00, 8.7596300345E+00, 2.8623082495E+00, 9.4070058349E-01],
	[3.3750000000E+04, 2.4929881787E+01, 5.1259604811E+00, 8.7638372429E+00, 2.8628426699E+00, 9.4072792605E-01],
	[3.3755000000E+04, 2.4936128384E+01, 5.1259699833E+00, 8.7680458467E+00, 2.8633769743E+00, 9.4075525483E-01],
	[3.3760000000E+04, 2.4942375620E+01, 5.1259794842E+00, 8.7722558462E+00, 2.8639111625E+00, 9.4078256985E-01],
	[3.3765000000E+04, 2.4948623496E+01, 5.1259889837E+00, 8.7764672418E+00, 2.8644452347E+00, 9.4080987109E-01],
	[3.3770000000E+04, 2.4954872011E+01, 5.1259984818E+00, 8.7806800336E+00, 2.8649791907E+00, 9.4083715859E-01],
	[3.3775000000E+04, 2.4961121166E+01, 5.1260079785E+00, 8.7848942218E+00, 2.8655130306E+00, 9.4086443233E-01],
	[3.3780000000E+04, 2.4967370961E+01, 5.1260174739E+00, 8.7891098069E+00, 2.8660467545E+00, 9.4089169234E-01],
	[3.3785000000E+04, 2.4973621395E+01, 5.1260269678E+00, 8.7933267889E+00, 2.8665803622E+00, 9.4091893860E-01],
	[3.3790000000E+04, 2.4979872468E+01, 5.1260364604E+00, 8.7975451682E+00, 2.8671138538E+00, 9.4094617114E-01],
	[3.3795000000E+04, 2.4986124181E+01, 5.1260459515E+00, 8.8017649451E+00, 2.8676472293E+00, 9.4097338996E-01],
	[3.3800000000E+04, 2.4992376533E+01, 5.1260554413E+00, 8.8059861197E+00, 2.8681804886E+00, 9.4100059507E-01],
	[3.3805000000E+04, 2.4998629525E+01, 5.1260649297E+00, 8.8102086923E+00, 2.8687136318E+00, 9.4102778647E-01],
	[3.3810000000E+04, 2.5004883156E+01, 5.1260744167E+00, 8.8144326632E+00, 2.8692466589E+00, 9.4105496417E-01],
	[3.3815000000E+04, 2.5011137426E+01, 5.1260839023E+00, 8.8186580327E+00, 2.8697795699E+00, 9.4108212818E-01],
	[3.3820000000E+04, 2.5017392336E+01, 5.1260933866E+00, 8.8228848010E+00, 2.8703123647E+00, 9.4110927850E-01],
	[3.3825000000E+04, 2.5023647884E+01, 5.1261028694E+00, 8.8271129683E+00, 2.8708450434E+00, 9.4113641514E-01],
	[3.3830000000E+04, 2.5029904072E+01, 5.1261123509E+00, 8.8313425349E+00, 2.8713776059E+00, 9.4116353811E-01],
	[3.3835000000E+04, 2.5036160900E+01, 5.1261218310E+00, 8.8355735011E+00, 2.8719100523E+00, 9.4119064742E-01],
	[3.3840000000E+04, 2.5042418366E+01, 5.1261313097E+00, 8.8398058671E+00, 2.8724423825E+00, 9.4121774306E-01],
	[3.3845000000E+04, 2.5048676471E+01, 5.1261407870E+00, 8.8440396332E+00, 2.8729745966E+00, 9.4124482506E-01],
	[3.3850000000E+04, 2.5054935216E+01, 5.1261502629E+00, 8.8482747996E+00, 2.8735066945E+00, 9.4127189341E-01],
	[3.3855000000E+04, 2.5061194600E+01, 5.1261597375E+00, 8.8525113666E+00, 2.8740386762E+00, 9.4129894813E-01],
	[3.3860000000E+04, 2.5067454622E+01, 5.1261692107E+00, 8.8567493344E+00, 2.8745705418E+00, 9.4132598922E-01],
	[3.3865000000E+04, 2.5073715284E+01, 5.1261786824E+00, 8.8609887034E+00, 2.8751022912E+00, 9.4135301668E-01],
	[3.3870000000E+04, 2.5079976585E+01, 5.1261881529E+00, 8.8652294737E+00, 2.8756339244E+00, 9.4138003053E-01],
	[3.3875000000E+04, 2.5086238524E+01, 5.1261976219E+00, 8.8694716456E+00, 2.8761654414E+00, 9.4140703077E-01],
	[3.3880000000E+04, 2.5092501103E+01, 5.1262070895E+00, 8.8737152193E+00, 2.8766968423E+00, 9.4143401741E-01],
	[3.3885000000E+04, 2.5098764320E+01, 5.1262165558E+00, 8.8779601952E+00, 2.8772281269E+00, 9.4146099045E-01],
	[3.3890000000E+04, 2.5105028176E+01, 5.1262260207E+00, 8.8822065735E+00, 2.8777592954E+00, 9.4148794991E-01],
	[3.3895000000E+04, 2.5111292672E+01, 5.1262354842E+00, 8.8864543543E+00, 2.8782903477E+00, 9.4151489578E-01],
	[3.3900000000E+04, 2.5117557805E+01, 5.1262449463E+00, 8.8907035381E+00, 2.8788212838E+00, 9.4154182808E-01],
	[3.3905000000E+04, 2.5123823578E+01, 5.1262544071E+00, 8.8949541250E+00, 2.8793521037E+00, 9.4156874681E-01],
	[3.3910000000E+04, 2.5130089990E+01, 5.1262638665E+00, 8.8992061153E+00, 2.8798828074E+00, 9.4159565199E-01],
	[3.3915000000E+04, 2.5136357040E+01, 5.1262733245E+00, 8.9034595093E+00, 2.8804133948E+00, 9.4162254361E-01],
	[3.3920000000E+04, 2.5142624729E+01, 5.1262827811E+00, 8.9077143071E+00, 2.8809438661E+00, 9.4164942168E-01],
	[3.3925000000E+04, 2.5148893056E+01, 5.1262922363E+00, 8.9119705091E+00, 2.8814742212E+00, 9.4167628622E-01],
	[3.3930000000E+04, 2.5155162022E+01, 5.1263016902E+00, 8.9162281156E+00, 2.8820044600E+00, 9.4170313722E-01],
	[3.3935000000E+04, 2.5161431627E+01, 5.1263111427E+00, 8.9204871267E+00, 2.8825345826E+00, 9.4172997470E-01],
	[3.3940000000E+04, 2.5167701871E+01, 5.1263205938E+00, 8.9247475427E+00, 2.8830645890E+00, 9.4175679866E-01],
	[3.3945000000E+04, 2.5173972752E+01, 5.1263300436E+00, 8.9290093640E+00, 2.8835944792E+00, 9.4178360911E-01],
	[3.3950000000E+04, 2.5180244273E+01, 5.1263394920E+00, 8.9332725906E+00, 2.8841242532E+00, 9.4181040606E-01],
	[3.3955000000E+04, 2.5186516432E+01, 5.1263489389E+00, 8.9375372230E+00, 2.8846539109E+00, 9.4183718950E-01],
	[3.3960000000E+04, 2.5192789229E+01, 5.1263583846E+00, 8.9418032613E+00, 2.8851834524E+00, 9.4186395946E-01],
	[3.3965000000E+04, 2.5199062665E+01, 5.1263678288E+00, 8.9460707058E+00, 2.8857128776E+00, 9.4189071594E-01],
	[3.3970000000E+04, 2.5205336739E+01, 5.1263772717E+00, 8.9503395568E+00, 2.8862421866E+00, 9.4191745893E-01],
	[3.3975000000E+04, 2.5211611452E+01, 5.1263867132E+00, 8.9546098145E+00, 2.8867713794E+00, 9.4194418846E-01],
	[3.3980000000E+04, 2.5217886803E+01, 5.1263961533E+00, 8.9588814792E+00, 2.8873004559E+00, 9.4197090453E-01],
	[3.3985000000E+04, 2.5224168010E+01, 5.1264063260E+00, 8.9631545511E+00, 2.8878297175E+00, 9.4199760714E-01],
	[3.3990000000E+04, 2.5230463937E+01, 5.1264184774E+00, 8.9674290305E+00, 2.8883596761E+00, 9.4202429631E-01],
	[3.3995000000E+04, 2.5236760510E+01, 5.1264306270E+00, 8.9717049177E+00, 2.8888895189E+00, 9.4205097203E-01],
	[3.4000000000E+04, 2.5243057728E+01, 5.1264427748E+00, 8.9759822128E+00, 2.8894192461E+00, 9.4207763432E-01],
	[3.4005000000E+04, 2.5249355591E+01, 5.1264549209E+00, 8.9802609162E+00, 2.8899488575E+00, 9.4210428318E-01],
	[3.4010000000E+04, 2.5255654098E+01, 5.1264670652E+00, 8.9845410281E+00, 2.8904783531E+00, 9.4213091861E-01],
	[3.4015000000E+04, 2.5261953251E+01, 5.1264792077E+00, 8.9888225487E+00, 2.8910077330E+00, 9.4215754064E-01],
	[3.4020000000E+04, 2.5268253049E+01, 5.1264913486E+00, 8.9931054784E+00, 2.8915369972E+00, 9.4218414926E-01],
	[3.4025000000E+04, 2.5274553491E+01, 5.1265034876E+00, 8.9973898174E+00, 2.8920661456E+00, 9.4221074448E-01],
	[3.4030000000E+04, 2.5280854578E+01, 5.1265156249E+00, 9.0016755658E+00, 2.8925951783E+00, 9.4223732631E-01],
	[3.4035000000E+04, 2.5287156310E+01, 5.1265277604E+00, 9.0059627241E+00, 2.8931240953E+00, 9.4226389475E-01],
	[3.4040000000E+04, 2.5293458687E+01, 5.1265398942E+00, 9.0102512924E+00, 2.8936528964E+00, 9.4229044981E-01],
	[3.4045000000E+04, 2.5299761709E+01, 5.1265520263E+00, 9.0145412710E+00, 2.8941815819E+00, 9.4231699150E-01],
	[3.4050000000E+04, 2.5306065375E+01, 5.1265641565E+00, 9.0188326602E+00, 2.8947101515E+00, 9.4234351983E-01],
	[3.4055000000E+04, 2.5312369686E+01, 5.1265762851E+00, 9.0231254602E+00, 2.8952386054E+00, 9.4237003479E-01],
	[3.4060000000E+04, 2.5318674641E+01, 5.1265884118E+00, 9.0274196712E+00, 2.8957669436E+00, 9.4239653641E-01],
	[3.4065000000E+04, 2.5324980242E+01, 5.1266005369E+00, 9.0317152936E+00, 2.8962951659E+00, 9.4242302468E-01],
	[3.4070000000E+04, 2.5331286487E+01, 5.1266126601E+00, 9.0360123275E+00, 2.8968232726E+00, 9.4244949962E-01],
	[3.4075000000E+04, 2.5337593376E+01, 5.1266247817E+00, 9.0403107733E+00, 2.8973512634E+00, 9.4247596123E-01],
	[3.4080000000E+04, 2.5343900910E+01, 5.1266369014E+00, 9.0446106312E+00, 2.8978791385E+00, 9.4250240951E-01],
	[3.4085000000E+04, 2.5350209089E+01, 5.1266490195E+00, 9.0489119014E+00, 2.8984068978E+00, 9.4252884447E-01],
	[3.4090000000E+04, 2.5356517912E+01, 5.1266611357E+00, 9.0532145842E+00, 2.8989345413E+00, 9.4255526613E-01],
	[3.4095000000E+04, 2.5362827379E+01, 5.1266732503E+00, 9.0575186798E+00, 2.8994620690E+00, 9.4258167448E-01],
	[3.4100000000E+04, 2.5369137491E+01, 5.1266853630E+00, 9.0618241886E+00, 2.8999894810E+00, 9.4260806954E-01],
	[3.4105000000E+04, 2.5375448247E+01, 5.1266974741E+00, 9.0661311108E+00, 2.9005167771E+00, 9.4263445131E-01],
	[3.4110000000E+04, 2.5381759648E+01, 5.1267095834E+00, 9.0704394465E+00, 2.9010439575E+00, 9.4266081980E-01],
	[3.4115000000E+04, 2.5388071693E+01, 5.1267216909E+00, 9.0747491962E+00, 2.9015710221E+00, 9.4268717502E-01],
	[3.4120000000E+04, 2.5394384382E+01, 5.1267337967E+00, 9.0790603600E+00, 2.9020979710E+00, 9.4271351696E-01],
	[3.4125000000E+04, 2.5400697716E+01, 5.1267459007E+00, 9.0833729382E+00, 2.9026248040E+00, 9.4273984565E-01],
	[3.4130000000E+04, 2.5407011694E+01, 5.1267580030E+00, 9.0876869310E+00, 2.9031515212E+00, 9.4276616108E-01],
	[3.4135000000E+04, 2.5413326316E+01, 5.1267701036E+00, 9.0920023387E+00, 2.9036781226E+00, 9.4279246327E-01],
	[3.4140000000E+04, 2.5419641582E+01, 5.1267822024E+00, 9.0963191616E+00, 2.9042046083E+00, 9.4281875221E-01],
	[3.4145000000E+04, 2.5425957492E+01, 5.1267942995E+00, 9.1006373999E+00, 2.9047309781E+00, 9.4284502792E-01],
	[3.4150000000E+04, 2.5432274047E+01, 5.1268063948E+00, 9.1049570539E+00, 2.9052572322E+00, 9.4287129041E-01],
	[3.4155000000E+04, 2.5438591246E+01, 5.1268184884E+00, 9.1092781238E+00, 2.9057833704E+00, 9.4289753967E-01],
	[3.4160000000E+04, 2.5444909089E+01, 5.1268305802E+00, 9.1136006099E+00, 2.9063093928E+00, 9.4292377573E-01],
	[3.4165000000E+04, 2.5451227575E+01, 5.1268426704E+00, 9.1179245124E+00, 2.9068352995E+00, 9.4294999858E-01],
	[3.4170000000E+04, 2.5457546706E+01, 5.1268547587E+00, 9.1222498316E+00, 2.9073610903E+00, 9.4297620822E-01],
	[3.4175000000E+04, 2.5463866481E+01, 5.1268668453E+00, 9.1265765678E+00, 2.9078867653E+00, 9.4300240467E-01],
	[3.4180000000E+04, 2.5470186900E+01, 5.1268789302E+00, 9.1309047212E+00, 2.9084123245E+00, 9.4302858793E-01],
	[3.4185000000E+04, 2.5476507963E+01, 5.1268910134E+00, 9.1352342920E+00, 2.9089377679E+00, 9.4305475801E-01],
	[3.4190000000E+04, 2.5482829670E+01, 5.1269030948E+00, 9.1395652806E+00, 2.9094630955E+00, 9.4308091492E-01],
	[3.4195000000E+04, 2.5489152020E+01, 5.1269151744E+00, 9.1438976871E+00, 2.9099883072E+00, 9.4310705865E-01],
	[3.4200000000E+04, 2.5495475015E+01, 5.1269272524E+00, 9.1482315119E+00, 2.9105134032E+00, 9.4313318922E-01],
	[3.4205000000E+04, 2.5501798653E+01, 5.1269393286E+00, 9.1525667552E+00, 2.9110383833E+00, 9.4315930664E-01],
	[3.4210000000E+04, 2.5508122935E+01, 5.1269514030E+00, 9.1569034172E+00, 2.9115632476E+00, 9.4318541090E-01],
	[3.4215000000E+04, 2.5514447861E+01, 5.1269634757E+00, 9.1612414982E+00, 2.9120879961E+00, 9.4321150201E-01],
	[3.4220000000E+04, 2.5520773431E+01, 5.1269755467E+00, 9.1655809984E+00, 2.9126126288E+00, 9.4323757999E-01],
	[3.4225000000E+04, 2.5527099644E+01, 5.1269876160E+00, 9.1699219182E+00, 2.9131371456E+00, 9.4326364483E-01],
	[3.4230000000E+04, 2.5533426501E+01, 5.1269996835E+00, 9.1742642577E+00, 2.9136615466E+00, 9.4328969655E-01],
	[3.4235000000E+04, 2.5539754002E+01, 5.1270117493E+00, 9.1786080173E+00, 2.9141858318E+00, 9.4331573515E-01],
	[3.4240000000E+04, 2.5546082146E+01, 5.1270238133E+00, 9.1829531971E+00, 2.9147100012E+00, 9.4334176063E-01],
	[3.4245000000E+04, 2.5552410934E+01, 5.1270358756E+00, 9.1872997975E+00, 2.9152340547E+00, 9.4336777300E-01],
	[3.4250000000E+04, 2.5558740366E+01, 5.1270479362E+00, 9.1916478187E+00, 2.9157579924E+00, 9.4339377228E-01],
	[3.4255000000E+04, 2.5565070441E+01, 5.1270599950E+00, 9.1959972609E+00, 2.9162818143E+00, 9.4341975845E-01],
	[3.4260000000E+04, 2.5571401159E+01, 5.1270720522E+00, 9.2003481244E+00, 2.9168055204E+00, 9.4344573154E-01],
	[3.4265000000E+04, 2.5577732521E+01, 5.1270841075E+00, 9.2047004095E+00, 2.9173291106E+00, 9.4347169154E-01],
	[3.4270000000E+04, 2.5584064527E+01, 5.1270961612E+00, 9.2090541164E+00, 2.9178525850E+00, 9.4349763847E-01],
	[3.4275000000E+04, 2.5590397176E+01, 5.1271082131E+00, 9.2134092454E+00, 2.9183759435E+00, 9.4352357233E-01],
	[3.4280000000E+04, 2.5596730468E+01, 5.1271202633E+00, 9.2177657967E+00, 2.9188991862E+00, 9.4354949312E-01],
	[3.4285000000E+04, 2.5603064404E+01, 5.1271323118E+00, 9.2221237705E+00, 2.9194223131E+00, 9.4357540085E-01],
	[3.4290000000E+04, 2.5609398983E+01, 5.1271443585E+00, 9.2264831673E+00, 2.9199453241E+00, 9.4360129553E-01],
	[3.4295000000E+04, 2.5615734205E+01, 5.1271564035E+00, 9.2308439871E+00, 2.9204682193E+00, 9.4362717716E-01],
	[3.4300000000E+04, 2.5622070071E+01, 5.1271684468E+00, 9.2352062303E+00, 2.9209909987E+00, 9.4365304576E-01],
	[3.4305000000E+04, 2.5628406580E+01, 5.1271804884E+00, 9.2395698970E+00, 2.9215136622E+00, 9.4367890132E-01],
	[3.4310000000E+04, 2.5634743732E+01, 5.1271925282E+00, 9.2439349877E+00, 2.9220362099E+00, 9.4370474385E-01],
	[3.4315000000E+04, 2.5641081527E+01, 5.1272045663E+00, 9.2483015025E+00, 2.9225586417E+00, 9.4373057336E-01],
	[3.4320000000E+04, 2.5647419966E+01, 5.1272166027E+00, 9.2526694416E+00, 2.9230809577E+00, 9.4375638986E-01],
	[3.4325000000E+04, 2.5653759047E+01, 5.1272286373E+00, 9.2570388054E+00, 2.9236031578E+00, 9.4378219335E-01],
	[3.4330000000E+04, 2.5660098772E+01, 5.1272406702E+00, 9.2614095941E+00, 2.9241252421E+00, 9.4380798383E-01],
	[3.4335000000E+04, 2.5666439140E+01, 5.1272527014E+00, 9.2657818079E+00, 2.9246472106E+00, 9.4383376132E-01],
	[3.4340000000E+04, 2.5672780151E+01, 5.1272647309E+00, 9.2701554472E+00, 2.9251690632E+00, 9.4385952582E-01],
	[3.4345000000E+04, 2.5679121805E+01, 5.1272767587E+00, 9.2745305120E+00, 2.9256908000E+00, 9.4388527733E-01],
	[3.4350000000E+04, 2.5685464102E+01, 5.1272887847E+00, 9.2789070029E+00, 2.9262124209E+00, 9.4391101587E-01],
	[3.4355000000E+04, 2.5691807042E+01, 5.1273008090E+00, 9.2832849198E+00, 2.9267339260E+00, 9.4393674143E-01],
	[3.4360000000E+04, 2.5698150625E+01, 5.1273128316E+00, 9.2876642632E+00, 2.9272553152E+00, 9.4396245403E-01],
	[3.4365000000E+04, 2.5704494851E+01, 5.1273248525E+00, 9.2920450333E+00, 2.9277765886E+00, 9.4398815367E-01],
	[3.4370000000E+04, 2.5710839719E+01, 5.1273368716E+00, 9.2964272304E+00, 2.9282977461E+00, 9.4401384036E-01],
	[3.4375000000E+04, 2.5717185231E+01, 5.1273488890E+00, 9.3008108546E+00, 2.9288187878E+00, 9.4403951410E-01],
	[3.4380000000E+04, 2.5723531385E+01, 5.1273609047E+00, 9.3051959063E+00, 2.9293397137E+00, 9.4406517489E-01],
	[3.4385000000E+04, 2.5729878182E+01, 5.1273729187E+00, 9.3095823857E+00, 2.9298605237E+00, 9.4409082276E-01],
	[3.4390000000E+04, 2.5736225622E+01, 5.1273849310E+00, 9.3139702930E+00, 2.9303812178E+00, 9.4411645769E-01],
	[3.4395000000E+04, 2.5742573705E+01, 5.1273969415E+00, 9.3183596286E+00, 2.9309017961E+00, 9.4414207971E-01],
	[3.4400000000E+04, 2.5748922430E+01, 5.1274089504E+00, 9.3227503927E+00, 2.9314222586E+00, 9.4416768881E-01],
	[3.4405000000E+04, 2.5755271799E+01, 5.1274209575E+00, 9.3271425855E+00, 2.9319426052E+00, 9.4419328499E-01],
	[3.4410000000E+04, 2.5761621809E+01, 5.1274329629E+00, 9.3315362073E+00, 2.9324628359E+00, 9.4421886828E-01],
	[3.4415000000E+04, 2.5767972463E+01, 5.1274449666E+00, 9.3359312583E+00, 2.9329829508E+00, 9.4424443867E-01],
	[3.4420000000E+04, 2.5774323759E+01, 5.1274569685E+00, 9.3403277389E+00, 2.9335029498E+00, 9.4426999616E-01],
	[3.4425000000E+04, 2.5780675698E+01, 5.1274689688E+00, 9.3447256492E+00, 2.9340228330E+00, 9.4429554078E-01],
	[3.4430000000E+04, 2.5787028279E+01, 5.1274809673E+00, 9.3491249895E+00, 2.9345426004E+00, 9.4432107251E-01],
	[3.4435000000E+04, 2.5793381502E+01, 5.1274929641E+00, 9.3535257601E+00, 2.9350622519E+00, 9.4434659137E-01],
	[3.4440000000E+04, 2.5799735369E+01, 5.1275049592E+00, 9.3579279612E+00, 2.9355817875E+00, 9.4437209737E-01],
	[3.4445000000E+04, 2.5806089877E+01, 5.1275169526E+00, 9.3623315932E+00, 2.9361012073E+00, 9.4439759050E-01],
	[3.4450000000E+04, 2.5812445028E+01, 5.1275289443E+00, 9.3667366561E+00, 2.9366205113E+00, 9.4442307078E-01],
	[3.4455000000E+04, 2.5818800822E+01, 5.1275409343E+00, 9.3711431504E+00, 2.9371396994E+00, 9.4444853822E-01],
	[3.4460000000E+04, 2.5825157258E+01, 5.1275529225E+00, 9.3755510762E+00, 2.9376587716E+00, 9.4447399281E-01],
	[3.4465000000E+04, 2.5831514336E+01, 5.1275649091E+00, 9.3799604338E+00, 2.9381777280E+00, 9.4449943457E-01],
	[3.4470000000E+04, 2.5837872056E+01, 5.1275768939E+00, 9.3843712235E+00, 2.9386965686E+00, 9.4452486349E-01],
	[3.4475000000E+04, 2.5844230419E+01, 5.1275888771E+00, 9.3887834456E+00, 2.9392152933E+00, 9.4455027960E-01],
	[3.4480000000E+04, 2.5850589424E+01, 5.1276008585E+00, 9.3931971002E+00, 2.9397339022E+00, 9.4457568289E-01],
	[3.4485000000E+04, 2.5856949072E+01, 5.1276128382E+00, 9.3976121876E+00, 2.9402523952E+00, 9.4460107337E-01],
	[3.4490000000E+04, 2.5863309361E+01, 5.1276248162E+00, 9.4020287082E+00, 2.9407707723E+00, 9.4462645104E-01],
	[3.4495000000E+04, 2.5869670293E+01, 5.1276367925E+00, 9.4064466621E+00, 2.9412890336E+00, 9.4465181592E-01],
	[3.4500000000E+04, 2.5876031867E+01, 5.1276487670E+00, 9.4108660496E+00, 2.9418071791E+00, 9.4467716801E-01],
	[3.4505000000E+04, 2.5882394083E+01, 5.1276607399E+00, 9.4152868709E+00, 2.9423252087E+00, 9.4470250731E-01],
	[3.4510000000E+04, 2.5888756941E+01, 5.1276727111E+00, 9.4197091264E+00, 2.9428431225E+00, 9.4472783383E-01],
	[3.4515000000E+04, 2.5895120441E+01, 5.1276846805E+00, 9.4241328163E+00, 2.9433609204E+00, 9.4475314757E-01],
	[3.4520000000E+04, 2.5901484583E+01, 5.1276966483E+00, 9.4285579408E+00, 2.9438786025E+00, 9.4477844856E-01],
	[3.4525000000E+04, 2.5907849368E+01, 5.1277086143E+00, 9.4329845002E+00, 2.9443961688E+00, 9.4480373678E-01],
	[3.4530000000E+04, 2.5914214794E+01, 5.1277205787E+00, 9.4374124947E+00, 2.9449136191E+00, 9.4482901224E-01],
	[3.4535000000E+04, 2.5920597099E+01, 5.1277348087E+00, 9.4418419247E+00, 2.9454319115E+00, 9.4485427496E-01],
	[3.4540000000E+04, 2.5926982867E+01, 5.1277494296E+00, 9.4462727903E+00, 2.9459502544E+00, 9.4487952494E-01],
	[3.4545000000E+04, 2.5933369282E+01, 5.1277640484E+00, 9.4507050918E+00, 2.9464684820E+00, 9.4490476218E-01],
	[3.4550000000E+04, 2.5939756347E+01, 5.1277786652E+00, 9.4551388295E+00, 2.9469865943E+00, 9.4492998669E-01],
	[3.4555000000E+04, 2.5946144059E+01, 5.1277932799E+00, 9.4595740037E+00, 2.9475045912E+00, 9.4495519848E-01],
	[3.4560000000E+04, 2.5952532420E+01, 5.1278078925E+00, 9.4640106145E+00, 2.9480224728E+00, 9.4498039755E-01],
	[3.4565000000E+04, 2.5958921430E+01, 5.1278225030E+00, 9.4684486622E+00, 2.9485402390E+00, 9.4500558391E-01],
	[3.4570000000E+04, 2.5965311088E+01, 5.1278371115E+00, 9.4728881472E+00, 2.9490578899E+00, 9.4503075756E-01],
	[3.4575000000E+04, 2.5971701394E+01, 5.1278517179E+00, 9.4773290696E+00, 2.9495754255E+00, 9.4505591852E-01],
	[3.4580000000E+04, 2.5978092349E+01, 5.1278663222E+00, 9.4817714298E+00, 2.9500928458E+00, 9.4508106679E-01],
	[3.4585000000E+04, 2.5984483952E+01, 5.1278809244E+00, 9.4862152279E+00, 2.9506101507E+00, 9.4510620236E-01],
	[3.4590000000E+04, 2.5990876203E+01, 5.1278955246E+00, 9.4906604642E+00, 2.9511273402E+00, 9.4513132526E-01],
	[3.4595000000E+04, 2.5997269102E+01, 5.1279101227E+00, 9.4951071390E+00, 2.9516444145E+00, 9.4515643549E-01],
	[3.4600000000E+04, 2.6003662650E+01, 5.1279247188E+00, 9.4995552526E+00, 2.9521613734E+00, 9.4518153305E-01],
	[3.4605000000E+04, 2.6010056846E+01, 5.1279393127E+00, 9.5040048052E+00, 2.9526782169E+00, 9.4520661795E-01],
	[3.4610000000E+04, 2.6016451690E+01, 5.1279539047E+00, 9.5084557970E+00, 2.9531949452E+00, 9.4523169019E-01],
	[3.4615000000E+04, 2.6022847182E+01, 5.1279684945E+00, 9.5129082283E+00, 2.9537115581E+00, 9.4525674978E-01],
	[3.4620000000E+04, 2.6029243322E+01, 5.1279830823E+00, 9.5173620994E+00, 2.9542280557E+00, 9.4528179673E-01],
	[3.4625000000E+04, 2.6035640110E+01, 5.1279976680E+00, 9.5218174105E+00, 2.9547444379E+00, 9.4530683105E-01],
	[3.4630000000E+04, 2.6042037546E+01, 5.1280122516E+00, 9.5262741619E+00, 2.9552607048E+00, 9.4533185273E-01],
	[3.4635000000E+04, 2.6048435630E+01, 5.1280268332E+00, 9.5307323538E+00, 2.9557768564E+00, 9.4535686179E-01],
	[3.4640000000E+04, 2.6054834363E+01, 5.1280414127E+00, 9.5351919866E+00, 2.9562928927E+00, 9.4538185824E-01],
	[3.4645000000E+04, 2.6061233743E+01, 5.1280559902E+00, 9.5396530604E+00, 2.9568088137E+00, 9.4540684207E-01],
	[3.4650000000E+04, 2.6067633771E+01, 5.1280705656E+00, 9.5441155754E+00, 2.9573246193E+00, 9.4543181330E-01],
	[3.4655000000E+04, 2.6074034447E+01, 5.1280851389E+00, 9.5485795321E+00, 2.9578403096E+00, 9.4545677193E-01],
	[3.4660000000E+04, 2.6080435771E+01, 5.1280997102E+00, 9.5530449306E+00, 2.9583558846E+00, 9.4548171796E-01],
	[3.4665000000E+04, 2.6086837742E+01, 5.1281142794E+00, 9.5575117711E+00, 2.9588713443E+00, 9.4550665141E-01],
	[3.4670000000E+04, 2.6093240362E+01, 5.1281288465E+00, 9.5619800540E+00, 2.9593866886E+00, 9.4553157228E-01],
	[3.4675000000E+04, 2.6099643629E+01, 5.1281434116E+00, 9.5664497795E+00, 2.9599019176E+00, 9.4555648057E-01],
	[3.4680000000E+04, 2.6106047544E+01, 5.1281579747E+00, 9.5709209479E+00, 2.9604170314E+00, 9.4558137630E-01],
	[3.4685000000E+04, 2.6112452107E+01, 5.1281725356E+00, 9.5753935593E+00, 2.9609320298E+00, 9.4560625946E-01],
	[3.4690000000E+04, 2.6118857318E+01, 5.1281870946E+00, 9.5798676141E+00, 2.9614469129E+00, 9.4563113007E-01],
	[3.4695000000E+04, 2.6125263176E+01, 5.1282016514E+00, 9.5843431125E+00, 2.9619616806E+00, 9.4565598813E-01],
	[3.4700000000E+04, 2.6131669682E+01, 5.1282162062E+00, 9.5888200548E+00, 2.9624763331E+00, 9.4568083365E-01],
	[3.4705000000E+04, 2.6138076835E+01, 5.1282307590E+00, 9.5932984413E+00, 2.9629908703E+00, 9.4570566663E-01],
	[3.4710000000E+04, 2.6144484636E+01, 5.1282453097E+00, 9.5977782721E+00, 2.9635052921E+00, 9.4573048708E-01],
	[3.4715000000E+04, 2.6150893085E+01, 5.1282598583E+00, 9.6022595476E+00, 2.9640195987E+00, 9.4575529501E-01],
	[3.4720000000E+04, 2.6157302181E+01, 5.1282744049E+00, 9.6067422680E+00, 2.9645337899E+00, 9.4578009042E-01],
	[3.4725000000E+04, 2.6163711925E+01, 5.1282889494E+00, 9.6112264335E+00, 2.9650478659E+00, 9.4580487331E-01],
	[3.4730000000E+04, 2.6170122316E+01, 5.1283034919E+00, 9.6157120445E+00, 2.9655618265E+00, 9.4582964370E-01],
	[3.4735000000E+04, 2.6176533354E+01, 5.1283180323E+00, 9.6201991011E+00, 2.9660756719E+00, 9.4585440159E-01],
	[3.4740000000E+04, 2.6182945040E+01, 5.1283325707E+00, 9.6246876037E+00, 2.9665894019E+00, 9.4587914699E-01],
	[3.4745000000E+04, 2.6189357374E+01, 5.1283471070E+00, 9.6291775524E+00, 2.9671030166E+00, 9.4590387990E-01],
	[3.4750000000E+04, 2.6195770355E+01, 5.1283616413E+00, 9.6336689476E+00, 2.9676165161E+00, 9.4592860033E-01],
	[3.4755000000E+04, 2.6202183983E+01, 5.1283761735E+00, 9.6381617895E+00, 2.9681299003E+00, 9.4595330828E-01],
	[3.4760000000E+04, 2.6208598258E+01, 5.1283907037E+00, 9.6426560784E+00, 2.9686431691E+00, 9.4597800377E-01],
	[3.4765000000E+04, 2.6215013181E+01, 5.1284052318E+00, 9.6471518145E+00, 2.9691563227E+00, 9.4600268679E-01],
	[3.4770000000E+04, 2.6221428751E+01, 5.1284197579E+00, 9.6516489980E+00, 2.9696693610E+00, 9.4602735736E-01],
	[3.4775000000E+04, 2.6227844968E+01, 5.1284342819E+00, 9.6561476293E+00, 2.9701822840E+00, 9.4605201547E-01],
	[3.4780000000E+04, 2.6234261832E+01, 5.1284488039E+00, 9.6606477086E+00, 2.9706950918E+00, 9.4607666115E-01],
	[3.4785000000E+04, 2.6240679344E+01, 5.1284633238E+00, 9.6651492361E+00, 2.9712077842E+00, 9.4610129438E-01],
	[3.4790000000E+04, 2.6247097503E+01, 5.1284778417E+00, 9.6696522121E+00, 2.9717203614E+00, 9.4612591519E-01],
	[3.4795000000E+04, 2.6253516309E+01, 5.1284923576E+00, 9.6741566369E+00, 2.9722328233E+00, 9.4615052357E-01],
	[3.4800000000E+04, 2.6259935762E+01, 5.1285068714E+00, 9.6786625107E+00, 2.9727451699E+00, 9.4617511953E-01],
	[3.4805000000E+04, 2.6266355862E+01, 5.1285213831E+00, 9.6831698338E+00, 2.9732574012E+00, 9.4619970308E-01],
	[3.4810000000E+04, 2.6272776609E+01, 5.1285358928E+00, 9.6876786064E+00, 2.9737695173E+00, 9.4622427422E-01],
	[3.4815000000E+04, 2.6279198003E+01, 5.1285504005E+00, 9.6921888288E+00, 2.9742815181E+00, 9.4624883296E-01],
	[3.4820000000E+04, 2.6285620044E+01, 5.1285649061E+00, 9.6967005012E+00, 2.9747934036E+00, 9.4627337931E-01],
	[3.4825000000E+04, 2.6292042732E+01, 5.1285794097E+00, 9.7012136240E+00, 2.9753051739E+00, 9.4629791327E-01],
	[3.4830000000E+04, 2.6298466067E+01, 5.1285939112E+00, 9.7057281972E+00, 2.9758168289E+00, 9.4632243485E-01],
	[3.4835000000E+04, 2.6304890048E+01, 5.1286084108E+00, 9.7102442214E+00, 2.9763283687E+00, 9.4634694406E-01],
	[3.4840000000E+04, 2.6311314677E+01, 5.1286229082E+00, 9.7147616965E+00, 2.9768397931E+00, 9.4637144089E-01],
	[3.4845000000E+04, 2.6317739953E+01, 5.1286374036E+00, 9.7192806230E+00, 2.9773511024E+00, 9.4639592536E-01],
	[3.4850000000E+04, 2.6324165875E+01, 5.1286518970E+00, 9.7238010011E+00, 2.9778622964E+00, 9.4642039748E-01],
	[3.4855000000E+04, 2.6330592444E+01, 5.1286663884E+00, 9.7283228311E+00, 2.9783733751E+00, 9.4644485724E-01],
	[3.4860000000E+04, 2.6337019660E+01, 5.1286808777E+00, 9.7328461131E+00, 2.9788843386E+00, 9.4646930466E-01],
	[3.4865000000E+04, 2.6343447522E+01, 5.1286953649E+00, 9.7373708475E+00, 2.9793951868E+00, 9.4649373974E-01],
	[3.4870000000E+04, 2.6349876032E+01, 5.1287098502E+00, 9.7418970346E+00, 2.9799059198E+00, 9.4651816249E-01],
	[3.4875000000E+04, 2.6356305188E+01, 5.1287243334E+00, 9.7464246744E+00, 2.9804165375E+00, 9.4654257292E-01],
	[3.4880000000E+04, 2.6362734990E+01, 5.1287388145E+00, 9.7509537675E+00, 2.9809270400E+00, 9.4656697102E-01],
	[3.4885000000E+04, 2.6369165440E+01, 5.1287532937E+00, 9.7554843139E+00, 2.9814374273E+00, 9.4659135681E-01],
	[3.4890000000E+04, 2.6375596535E+01, 5.1287677708E+00, 9.7600163139E+00, 2.9819476993E+00, 9.4661573030E-01],
	[3.4895000000E+04, 2.6382028278E+01, 5.1287822458E+00, 9.7645497679E+00, 2.9824578561E+00, 9.4664009148E-01],
	[3.4900000000E+04, 2.6388460667E+01, 5.1287967189E+00, 9.7690846760E+00, 2.9829678977E+00, 9.4666444037E-01],
	[3.4905000000E+04, 2.6394893702E+01, 5.1288111898E+00, 9.7736210385E+00, 2.9834778240E+00, 9.4668877697E-01],
	[3.4910000000E+04, 2.6401327384E+01, 5.1288256588E+00, 9.7781588557E+00, 2.9839876352E+00, 9.4671310128E-01],
	[3.4915000000E+04, 2.6407761713E+01, 5.1288401257E+00, 9.7826981279E+00, 2.9844973311E+00, 9.4673741333E-01],
	[3.4920000000E+04, 2.6414196687E+01, 5.1288545906E+00, 9.7872388552E+00, 2.9850069117E+00, 9.4676171310E-01],
	[3.4925000000E+04, 2.6420632309E+01, 5.1288690535E+00, 9.7917810379E+00, 2.9855163772E+00, 9.4678600061E-01],
	[3.4930000000E+04, 2.6427068576E+01, 5.1288835144E+00, 9.7963246764E+00, 2.9860257274E+00, 9.4681027586E-01],
	[3.4935000000E+04, 2.6433505490E+01, 5.1288979732E+00, 9.8008697708E+00, 2.9865349625E+00, 9.4683453885E-01],
	[3.4940000000E+04, 2.6439943050E+01, 5.1289124299E+00, 9.8054163215E+00, 2.9870440823E+00, 9.4685878961E-01],
	[3.4945000000E+04, 2.6446381257E+01, 5.1289268847E+00, 9.8099643286E+00, 2.9875530869E+00, 9.4688302812E-01],
	[3.4950000000E+04, 2.6452820110E+01, 5.1289413374E+00, 9.8145137924E+00, 2.9880619764E+00, 9.4690725441E-01],
	[3.4955000000E+04, 2.6459259609E+01, 5.1289557881E+00, 9.8190647133E+00, 2.9885707506E+00, 9.4693146846E-01],
	[3.4960000000E+04, 2.6465699754E+01, 5.1289702368E+00, 9.8236170914E+00, 2.9890794096E+00, 9.4695567030E-01],
	[3.4965000000E+04, 2.6472140545E+01, 5.1289846835E+00, 9.8281709269E+00, 2.9895879535E+00, 9.4697985992E-01],
	[3.4970000000E+04, 2.6478581983E+01, 5.1289991281E+00, 9.8327262203E+00, 2.9900963821E+00, 9.4700403733E-01],
	[3.4975000000E+04, 2.6485024067E+01, 5.1290135707E+00, 9.8372829717E+00, 2.9906046956E+00, 9.4702820254E-01],
	[3.4980000000E+04, 2.6491466796E+01, 5.1290280113E+00, 9.8418411813E+00, 2.9911128938E+00, 9.4705235556E-01],
	[3.4985000000E+04, 2.6497910172E+01, 5.1290424498E+00, 9.8464008495E+00, 2.9916209769E+00, 9.4707649638E-01],
	[3.4990000000E+04, 2.6504354194E+01, 5.1290568863E+00, 9.8509619764E+00, 2.9921289448E+00, 9.4710062503E-01],
	[3.4995000000E+04, 2.6510798862E+01, 5.1290713208E+00, 9.8555245624E+00, 2.9926367976E+00, 9.4712474149E-01],
	[3.5000000000E+04, 2.6517244176E+01, 5.1290857533E+00, 9.8600886078E+00, 2.9931445351E+00, 9.4714884579E-01],
	[3.5005000000E+04, 2.6523690136E+01, 5.1291001838E+00, 9.8646585992E+00, 2.9936525707E+00, 9.4717293792E-01],
	[3.5010000000E+04, 2.6530136742E+01, 5.1291146122E+00, 9.8692300541E+00, 2.9941604910E+00, 9.4719701789E-01],
	[3.5015000000E+04, 2.6536583993E+01, 5.1291290387E+00, 9.8738029727E+00, 2.9946682960E+00, 9.4722108571E-01],
	[3.5020000000E+04, 2.6543031891E+01, 5.1291434631E+00, 9.8783773552E+00, 2.9951759856E+00, 9.4724514138E-01],
	[3.5025000000E+04, 2.6549480434E+01, 5.1291578855E+00, 9.8829532018E+00, 2.9956835600E+00, 9.4726918492E-01],
	[3.5030000000E+04, 2.6555929623E+01, 5.1291723058E+00, 9.8875305130E+00, 2.9961910190E+00, 9.4729321632E-01],
	[3.5035000000E+04, 2.6562379458E+01, 5.1291867242E+00, 9.8921092889E+00, 2.9966983627E+00, 9.4731723559E-01],
	[3.5040000000E+04, 2.6568829939E+01, 5.1292011405E+00, 9.8966895297E+00, 2.9972055911E+00, 9.4734124274E-01],
	[3.5045000000E+04, 2.6575281066E+01, 5.1292155548E+00, 9.9012712358E+00, 2.9977127043E+00, 9.4736523778E-01],
	[3.5050000000E+04, 2.6581732838E+01, 5.1292299671E+00, 9.9058544073E+00, 2.9982197021E+00, 9.4738922070E-01],
	[3.5055000000E+04, 2.6588185256E+01, 5.1292443774E+00, 9.9104390446E+00, 2.9987265846E+00, 9.4741319153E-01],
	[3.5060000000E+04, 2.6594638319E+01, 5.1292587857E+00, 9.9150251479E+00, 2.9992333519E+00, 9.4743715026E-01],
	[3.5065000000E+04, 2.6601092029E+01, 5.1292731920E+00, 9.9196127175E+00, 2.9997400039E+00, 9.4746109689E-01],
	[3.5070000000E+04, 2.6607546383E+01, 5.1292875962E+00, 9.9242017536E+00, 3.0002465406E+00, 9.4748503144E-01],
	[3.5075000000E+04, 2.6614001384E+01, 5.1293019984E+00, 9.9287922565E+00, 3.0007529620E+00, 9.4750895392E-01],
	[3.5080000000E+04, 2.6620457030E+01, 5.1293163986E+00, 9.9333842264E+00, 3.0012592682E+00, 9.4753286432E-01],
	[3.5085000000E+04, 2.6626913321E+01, 5.1293307968E+00, 9.9379776637E+00, 3.0017654590E+00, 9.4755676266E-01],
	[3.5090000000E+04, 2.6633382908E+01, 5.1293469465E+00, 9.9425725685E+00, 3.0022722961E+00, 9.4758064894E-01],
	[3.5095000000E+04, 2.6639859299E+01, 5.1293639468E+00, 9.9471689411E+00, 3.0027793887E+00, 9.4760452316E-01],
	[3.5100000000E+04, 2.6646336342E+01, 5.1293809447E+00, 9.9517667818E+00, 3.0032863666E+00, 9.4762838534E-01],
	[3.5105000000E+04, 2.6652814037E+01, 5.1293979403E+00, 9.9563660908E+00, 3.0037932297E+00, 9.4765223547E-01],
	[3.5110000000E+04, 2.6659292383E+01, 5.1294149335E+00, 9.9609668685E+00, 3.0042999780E+00, 9.4767607357E-01],
	[3.5115000000E+04, 2.6665771382E+01, 5.1294319243E+00, 9.9655691150E+00, 3.0048066115E+00, 9.4769989965E-01],
	[3.5120000000E+04, 2.6672251032E+01, 5.1294489128E+00, 9.9701728306E+00, 3.0053131303E+00, 9.4772371370E-01],
	[3.5125000000E+04, 2.6678731334E+01, 5.1294658990E+00, 9.9747780155E+00, 3.0058195343E+00, 9.4774751573E-01],
	[3.5130000000E+04, 2.6685212288E+01, 5.1294828827E+00, 9.9793846701E+00, 3.0063258236E+00, 9.4777130575E-01],
	[3.5135000000E+04, 2.6691693894E+01, 5.1294998641E+00, 9.9839927946E+00, 3.0068319981E+00, 9.4779508377E-01],
	[3.5140000000E+04, 2.6698176151E+01, 5.1295168432E+00, 9.9886023893E+00, 3.0073380579E+00, 9.4781884979E-01],
	[3.5145000000E+04, 2.6704659060E+01, 5.1295338198E+00, 9.9932134544E+00, 3.0078440029E+00, 9.4784260382E-01],
	[3.5150000000E+04, 2.6711142620E+01, 5.1295507942E+00, 9.9978259901E+00, 3.0083498332E+00, 9.4786634587E-01],
	[3.5155000000E+04, 2.6717626832E+01, 5.1295677661E+00, 1.0002439997E+01, 3.0088555487E+00, 9.4789007593E-01],
	[3.5160000000E+04, 2.6724111695E+01, 5.1295847357E+00, 1.0007055475E+01, 3.0093611496E+00, 9.4791379402E-01],
	[3.5165000000E+04, 2.6730597211E+01, 5.1296017030E+00, 1.0011672424E+01, 3.0098666356E+00, 9.4793750015E-01],
	[3.5170000000E+04, 2.6737083377E+01, 5.1296186679E+00, 1.0016290845E+01, 3.0103720070E+00, 9.4796119431E-01],
	[3.5175000000E+04, 2.6743570195E+01, 5.1296356304E+00, 1.0020910738E+01, 3.0108772636E+00, 9.4798487652E-01],
	[3.5180000000E+04, 2.6750057665E+01, 5.1296525906E+00, 1.0025532103E+01, 3.0113824056E+00, 9.4800854678E-01],
	[3.5185000000E+04, 2.6756545786E+01, 5.1296695484E+00, 1.0030154941E+01, 3.0118874328E+00, 9.4803220510E-01],
	[3.5190000000E+04, 2.6763034558E+01, 5.1296865039E+00, 1.0034779251E+01, 3.0123923453E+00, 9.4805585148E-01],
	[3.5195000000E+04, 2.6769523982E+01, 5.1297034570E+00, 1.0039405034E+01, 3.0128971430E+00, 9.4807948593E-01],
	[3.5200000000E+04, 2.6776014057E+01, 5.1297204078E+00, 1.0044032291E+01, 3.0134018261E+00, 9.4810310846E-01],
	[3.5205000000E+04, 2.6782504783E+01, 5.1297373562E+00, 1.0048661021E+01, 3.0139063945E+00, 9.4812671907E-01],
	[3.5210000000E+04, 2.6788996161E+01, 5.1297543023E+00, 1.0053291225E+01, 3.0144108482E+00, 9.4815031777E-01],
	[3.5215000000E+04, 2.6795488190E+01, 5.1297712460E+00, 1.0057922903E+01, 3.0149151872E+00, 9.4817390456E-01],
	[3.5220000000E+04, 2.6801980870E+01, 5.1297881874E+00, 1.0062556056E+01, 3.0154194115E+00, 9.4819747946E-01],
	[3.5225000000E+04, 2.6808474201E+01, 5.1298051264E+00, 1.0067190682E+01, 3.0159235212E+00, 9.4822104246E-01],
	[3.5230000000E+04, 2.6814968184E+01, 5.1298220631E+00, 1.0071826784E+01, 3.0164275161E+00, 9.4824459357E-01],
	[3.5235000000E+04, 2.6821462817E+01, 5.1298389974E+00, 1.0076464361E+01, 3.0169313964E+00, 9.4826813280E-01],
	[3.5240000000E+04, 2.6827958102E+01, 5.1298559294E+00, 1.0081103413E+01, 3.0174351620E+00, 9.4829166016E-01],
	[3.5245000000E+04, 2.6834454038E+01, 5.1298728590E+00, 1.0085743941E+01, 3.0179388130E+00, 9.4831517565E-01],
	[3.5250000000E+04, 2.6840950625E+01, 5.1298897863E+00, 1.0090385944E+01, 3.0184423493E+00, 9.4833867928E-01],
	[3.5255000000E+04, 2.6847447863E+01, 5.1299067112E+00, 1.0095029424E+01, 3.0189457709E+00, 9.4836217105E-01],
	[3.5260000000E+04, 2.6853945752E+01, 5.1299236338E+00, 1.0099674380E+01, 3.0194490779E+00, 9.4838565097E-01],
	[3.5265000000E+04, 2.6860444292E+01, 5.1299405541E+00, 1.0104320812E+01, 3.0199522702E+00, 9.4840911905E-01],
	[3.5270000000E+04, 2.6866943483E+01, 5.1299574720E+00, 1.0108968722E+01, 3.0204553479E+00, 9.4843257529E-01],
	[3.5275000000E+04, 2.6873443325E+01, 5.1299743875E+00, 1.0113618108E+01, 3.0209583109E+00, 9.4845601969E-01],
	[3.5280000000E+04, 2.6879943818E+01, 5.1299913008E+00, 1.0118268972E+01, 3.0214611594E+00, 9.4847945228E-01],
	[3.5285000000E+04, 2.6886444962E+01, 5.1300082116E+00, 1.0122921314E+01, 3.0219638931E+00, 9.4850287304E-01],
	[3.5290000000E+04, 2.6892946756E+01, 5.1300251202E+00, 1.0127575134E+01, 3.0224665123E+00, 9.4852628199E-01],
	[3.5295000000E+04, 2.6899449202E+01, 5.1300420264E+00, 1.0132230432E+01, 3.0229690168E+00, 9.4854967913E-01],
	[3.5300000000E+04, 2.6905952298E+01, 5.1300589302E+00, 1.0136887208E+01, 3.0234714067E+00, 9.4857306447E-01],
	[3.5305000000E+04, 2.6912456045E+01, 5.1300758318E+00, 1.0141545463E+01, 3.0239736821E+00, 9.4859643802E-01],
	[3.5310000000E+04, 2.6918960443E+01, 5.1300927310E+00, 1.0146205197E+01, 3.0244758428E+00, 9.4861979978E-01],
	[3.5315000000E+04, 2.6925465491E+01, 5.1301096278E+00, 1.0150866410E+01, 3.0249778889E+00, 9.4864314975E-01],
	[3.5320000000E+04, 2.6931971190E+01, 5.1301265223E+00, 1.0155529103E+01, 3.0254798203E+00, 9.4866648795E-01],
	[3.5325000000E+04, 2.6938477540E+01, 5.1301434145E+00, 1.0160193275E+01, 3.0259816373E+00, 9.4868981438E-01],
	[3.5330000000E+04, 2.6944984541E+01, 5.1301603043E+00, 1.0164858927E+01, 3.0264833396E+00, 9.4871312904E-01],
	[3.5335000000E+04, 2.6951492192E+01, 5.1301771918E+00, 1.0169526060E+01, 3.0269849273E+00, 9.4873643195E-01],
	[3.5340000000E+04, 2.6958000493E+01, 5.1301940770E+00, 1.0174194673E+01, 3.0274864004E+00, 9.4875972311E-01],
	[3.5345000000E+04, 2.6964509446E+01, 5.1302109599E+00, 1.0178864767E+01, 3.0279877590E+00, 9.4878300251E-01],
	[3.5350000000E+04, 2.6971019048E+01, 5.1302278404E+00, 1.0183536342E+01, 3.0284890030E+00, 9.4880627018E-01],
	[3.5355000000E+04, 2.6977529302E+01, 5.1302447185E+00, 1.0188209398E+01, 3.0289901325E+00, 9.4882952612E-01],
	[3.5360000000E+04, 2.6984040205E+01, 5.1302615944E+00, 1.0192883936E+01, 3.0294911473E+00, 9.4885277033E-01],
	[3.5365000000E+04, 2.6990551759E+01, 5.1302784679E+00, 1.0197559956E+01, 3.0299920477E+00, 9.4887600281E-01],
	[3.5370000000E+04, 2.6997063964E+01, 5.1302953391E+00, 1.0202237457E+01, 3.0304928334E+00, 9.4889922359E-01],
	[3.5375000000E+04, 2.7003576819E+01, 5.1303122079E+00, 1.0206916441E+01, 3.0309935047E+00, 9.4892243265E-01],
	[3.5380000000E+04, 2.7010090324E+01, 5.1303290745E+00, 1.0211596908E+01, 3.0314940613E+00, 9.4894563001E-01],
	[3.5385000000E+04, 2.7016604480E+01, 5.1303459387E+00, 1.0216278858E+01, 3.0319945035E+00, 9.4896881567E-01],
	[3.5390000000E+04, 2.7023119286E+01, 5.1303628005E+00, 1.0220962290E+01, 3.0324948311E+00, 9.4899198965E-01],
	[3.5395000000E+04, 2.7029634742E+01, 5.1303796601E+00, 1.0225647206E+01, 3.0329950442E+00, 9.4901515193E-01],
	[3.5400000000E+04, 2.7036150849E+01, 5.1303965173E+00, 1.0230333606E+01, 3.0334951428E+00, 9.4903830254E-01],
	[3.5405000000E+04, 2.7042667606E+01, 5.1304133722E+00, 1.0235021489E+01, 3.0339951268E+00, 9.4906144148E-01],
	[3.5410000000E+04, 2.7049185013E+01, 5.1304302248E+00, 1.0239710857E+01, 3.0344949964E+00, 9.4908456875E-01],
	[3.5415000000E+04, 2.7055703070E+01, 5.1304470750E+00, 1.0244401709E+01, 3.0349947514E+00, 9.4910768436E-01],
	[3.5420000000E+04, 2.7062221777E+01, 5.1304639229E+00, 1.0249094045E+01, 3.0354943919E+00, 9.4913078832E-01],
	[3.5425000000E+04, 2.7068741135E+01, 5.1304807685E+00, 1.0253787867E+01, 3.0359939180E+00, 9.4915388063E-01],
	[3.5430000000E+04, 2.7075261142E+01, 5.1304976118E+00, 1.0258483174E+01, 3.0364933295E+00, 9.4917696130E-01],
	[3.5435000000E+04, 2.7081781800E+01, 5.1305144528E+00, 1.0263179966E+01, 3.0369926266E+00, 9.4920003033E-01],
	[3.5440000000E+04, 2.7088303107E+01, 5.1305312914E+00, 1.0267878244E+01, 3.0374918092E+00, 9.4922308773E-01],
	[3.5445000000E+04, 2.7094825065E+01, 5.1305481277E+00, 1.0272578008E+01, 3.0379908773E+00, 9.4924613351E-01],
	[3.5450000000E+04, 2.7101347673E+01, 5.1305649617E+00, 1.0277279258E+01, 3.0384898309E+00, 9.4926916767E-01],
	[3.5455000000E+04, 2.7107870930E+01, 5.1305817934E+00, 1.0281981995E+01, 3.0389886701E+00, 9.4929219022E-01],
	[3.5460000000E+04, 2.7114394838E+01, 5.1305986227E+00, 1.0286686218E+01, 3.0394873948E+00, 9.4931520117E-01],
	[3.5465000000E+04, 2.7120919396E+01, 5.1306154498E+00, 1.0291391929E+01, 3.0399860051E+00, 9.4933820051E-01],
	[3.5470000000E+04, 2.7127444603E+01, 5.1306322745E+00, 1.0296099126E+01, 3.0404845009E+00, 9.4936118826E-01],
	[3.5475000000E+04, 2.7133970460E+01, 5.1306490969E+00, 1.0300807811E+01, 3.0409828823E+00, 9.4938416443E-01],
	[3.5480000000E+04, 2.7140496967E+01, 5.1306659170E+00, 1.0305517984E+01, 3.0414811492E+00, 9.4940712902E-01],
	[3.5485000000E+04, 2.7147024124E+01, 5.1306827348E+00, 1.0310229645E+01, 3.0419793017E+00, 9.4943008203E-01],
	[3.5490000000E+04, 2.7153551931E+01, 5.1306995502E+00, 1.0314942795E+01, 3.0424773398E+00, 9.4945302347E-01],
	[3.5495000000E+04, 2.7160080387E+01, 5.1307163634E+00, 1.0319657432E+01, 3.0429752635E+00, 9.4947595335E-01],
	[3.5500000000E+04, 2.7166609493E+01, 5.1307331742E+00, 1.0324373559E+01, 3.0434730727E+00, 9.4949887167E-01],
	[3.5505000000E+04, 2.7173139249E+01, 5.1307499827E+00, 1.0329091175E+01, 3.0439707676E+00, 9.4952177845E-01],
	[3.5510000000E+04, 2.7179669654E+01, 5.1307667889E+00, 1.0333810280E+01, 3.0444683480E+00, 9.4954467368E-01],
	[3.5515000000E+04, 2.7186200710E+01, 5.1307835928E+00, 1.0338530875E+01, 3.0449658140E+00, 9.4956755737E-01],
	[3.5520000000E+04, 2.7192732414E+01, 5.1308003944E+00, 1.0343252959E+01, 3.0454631657E+00, 9.4959042953E-01],
	[3.5525000000E+04, 2.7199264769E+01, 5.1308171937E+00, 1.0347976534E+01, 3.0459604029E+00, 9.4961329016E-01],
	[3.5530000000E+04, 2.7205797772E+01, 5.1308339906E+00, 1.0352701599E+01, 3.0464575258E+00, 9.4963613927E-01],
	[3.5535000000E+04, 2.7212331426E+01, 5.1308507853E+00, 1.0357428155E+01, 3.0469545343E+00, 9.4965897687E-01],
	[3.5540000000E+04, 2.7218865729E+01, 5.1308675777E+00, 1.0362156201E+01, 3.0474514284E+00, 9.4968180296E-01],
	[3.5545000000E+04, 2.7225400681E+01, 5.1308843677E+00, 1.0366885739E+01, 3.0479482082E+00, 9.4970461755E-01],
	[3.5550000000E+04, 2.7231936283E+01, 5.1309011554E+00, 1.0371616768E+01, 3.0484448736E+00, 9.4972742065E-01],
	[3.5555000000E+04, 2.7238472534E+01, 5.1309179409E+00, 1.0376349289E+01, 3.0489414246E+00, 9.4975021226E-01],
	[3.5560000000E+04, 2.7245009435E+01, 5.1309347240E+00, 1.0381083302E+01, 3.0494378613E+00, 9.4977299238E-01],
	[3.5565000000E+04, 2.7251546985E+01, 5.1309515048E+00, 1.0385818807E+01, 3.0499341837E+00, 9.4979576102E-01],
	[3.5570000000E+04, 2.7258085184E+01, 5.1309682833E+00, 1.0390555804E+01, 3.0504303917E+00, 9.4981851820E-01],
	[3.5575000000E+04, 2.7264624033E+01, 5.1309850595E+00, 1.0395294294E+01, 3.0509264854E+00, 9.4984126390E-01],
	[3.5580000000E+04, 2.7271163531E+01, 5.1310018335E+00, 1.0400034277E+01, 3.0514224648E+00, 9.4986399815E-01],
	[3.5585000000E+04, 2.7277703678E+01, 5.1310186051E+00, 1.0404775754E+01, 3.0519183299E+00, 9.4988672095E-01],
	[3.5590000000E+04, 2.7284244475E+01, 5.1310353744E+00, 1.0409518723E+01, 3.0524140806E+00, 9.4990943230E-01],
	[3.5595000000E+04, 2.7290785921E+01, 5.1310521414E+00, 1.0414263187E+01, 3.0529097171E+00, 9.4993213221E-01],
	[3.5600000000E+04, 2.7297328016E+01, 5.1310689061E+00, 1.0419009145E+01, 3.0534052392E+00, 9.4995482068E-01],
	[3.5605000000E+04, 2.7303870760E+01, 5.1310856685E+00, 1.0423756596E+01, 3.0539006471E+00, 9.4997749773E-01],
	[3.5610000000E+04, 2.7310414153E+01, 5.1311024286E+00, 1.0428505543E+01, 3.0543959406E+00, 9.5000016335E-01],
	[3.5615000000E+04, 2.7316958195E+01, 5.1311191864E+00, 1.0433255984E+01, 3.0548911199E+00, 9.5002281756E-01],
	[3.5620000000E+04, 2.7323502887E+01, 5.1311359419E+00, 1.0438007920E+01, 3.0553861849E+00, 9.5004546035E-01],
	[3.5625000000E+04, 2.7330048227E+01, 5.1311526951E+00, 1.0442761352E+01, 3.0558811357E+00, 9.5006809174E-01],
	[3.5630000000E+04, 2.7336594217E+01, 5.1311694460E+00, 1.0447516279E+01, 3.0563759722E+00, 9.5009071173E-01],
	[3.5635000000E+04, 2.7343140855E+01, 5.1311861947E+00, 1.0452272702E+01, 3.0568706944E+00, 9.5011332033E-01],
	[3.5640000000E+04, 2.7349688142E+01, 5.1312029410E+00, 1.0457030621E+01, 3.0573653024E+00, 9.5013591755E-01],
	[3.5645000000E+04, 2.7356236079E+01, 5.1312196850E+00, 1.0461790036E+01, 3.0578597961E+00, 9.5015850338E-01],
	[3.5650000000E+04, 2.7362784664E+01, 5.1312364268E+00, 1.0466550948E+01, 3.0583541756E+00, 9.5018107784E-01],
	[3.5655000000E+04, 2.7369346956E+01, 5.1312549599E+00, 1.0471313357E+01, 3.0588492414E+00, 9.5020364093E-01],
	[3.5660000000E+04, 2.7375915410E+01, 5.1312742472E+00, 1.0476077263E+01, 3.0593445310E+00, 9.5022619266E-01],
	[3.5665000000E+04, 2.7382484519E+01, 5.1312935319E+00, 1.0480842667E+01, 3.0598397069E+00, 9.5024873303E-01],
	[3.5670000000E+04, 2.7389054283E+01, 5.1313128139E+00, 1.0485609568E+01, 3.0603347691E+00, 9.5027126206E-01],
	[3.5675000000E+04, 2.7395624703E+01, 5.1313320933E+00, 1.0490377967E+01, 3.0608297175E+00, 9.5029377974E-01],
	[3.5680000000E+04, 2.7402195777E+01, 5.1313513701E+00, 1.0495147864E+01, 3.0613245521E+00, 9.5031628608E-01],
	[3.5685000000E+04, 2.7408767507E+01, 5.1313706442E+00, 1.0499919260E+01, 3.0618192730E+00, 9.5033878108E-01],
	[3.5690000000E+04, 2.7415339891E+01, 5.1313899157E+00, 1.0504692154E+01, 3.0623138802E+00, 9.5036126476E-01],
	[3.5695000000E+04, 2.7421912931E+01, 5.1314091846E+00, 1.0509466547E+01, 3.0628083737E+00, 9.5038373712E-01],
	[3.5700000000E+04, 2.7428486625E+01, 5.1314284508E+00, 1.0514242440E+01, 3.0633027534E+00, 9.5040619816E-01],
	[3.5705000000E+04, 2.7435060974E+01, 5.1314477145E+00, 1.0519019831E+01, 3.0637970195E+00, 9.5042864789E-01],
	[3.5710000000E+04, 2.7441635979E+01, 5.1314669755E+00, 1.0523798723E+01, 3.0642911718E+00, 9.5045108631E-01],
	[3.5715000000E+04, 2.7448211638E+01, 5.1314862338E+00, 1.0528579115E+01, 3.0647852104E+00, 9.5047351343E-01],
	[3.5720000000E+04, 2.7454787952E+01, 5.1315054896E+00, 1.0533361007E+01, 3.0652791354E+00, 9.5049592926E-01],
	[3.5725000000E+04, 2.7461364920E+01, 5.1315247427E+00, 1.0538144399E+01, 3.0657729467E+00, 9.5051833380E-01],
	[3.5730000000E+04, 2.7467942544E+01, 5.1315439932E+00, 1.0542929292E+01, 3.0662666443E+00, 9.5054072705E-01],
	[3.5735000000E+04, 2.7474520822E+01, 5.1315632411E+00, 1.0547715686E+01, 3.0667602282E+00, 9.5056310902E-01],
	[3.5740000000E+04, 2.7481099755E+01, 5.1315824864E+00, 1.0552503582E+01, 3.0672536984E+00, 9.5058547973E-01],
	[3.5745000000E+04, 2.7487679343E+01, 5.1316017290E+00, 1.0557292979E+01, 3.0677470550E+00, 9.5060783916E-01],
	[3.5750000000E+04, 2.7494259585E+01, 5.1316209690E+00, 1.0562083878E+01, 3.0682402980E+00, 9.5063018733E-01],
	[3.5755000000E+04, 2.7500840482E+01, 5.1316402064E+00, 1.0566876279E+01, 3.0687334273E+00, 9.5065252424E-01],
	[3.5760000000E+04, 2.7507422034E+01, 5.1316594412E+00, 1.0571670182E+01, 3.0692264430E+00, 9.5067484991E-01],
	[3.5765000000E+04, 2.7514004241E+01, 5.1316786734E+00, 1.0576465588E+01, 3.0697193450E+00, 9.5069716432E-01],
	[3.5770000000E+04, 2.7520587101E+01, 5.1316979030E+00, 1.0581262496E+01, 3.0702121334E+00, 9.5071946750E-01],
	[3.5775000000E+04, 2.7527170617E+01, 5.1317171299E+00, 1.0586060908E+01, 3.0707048082E+00, 9.5074175944E-01],
	[3.5780000000E+04, 2.7533754787E+01, 5.1317363542E+00, 1.0590860823E+01, 3.0711973694E+00, 9.5076404015E-01],
	[3.5785000000E+04, 2.7540339611E+01, 5.1317555759E+00, 1.0595662242E+01, 3.0716898170E+00, 9.5078630964E-01],
	[3.5790000000E+04, 2.7546925090E+01, 5.1317747950E+00, 1.0600465165E+01, 3.0721821510E+00, 9.5080856791E-01],
	[3.5795000000E+04, 2.7553511224E+01, 5.1317940115E+00, 1.0605269592E+01, 3.0726743714E+00, 9.5083081497E-01],
	[3.5800000000E+04, 2.7560098011E+01, 5.1318132254E+00, 1.0610075523E+01, 3.0731664782E+00, 9.5085305082E-01],
	[3.5805000000E+04, 2.7566685454E+01, 5.1318324366E+00, 1.0614882959E+01, 3.0736584714E+00, 9.5087527546E-01],
	[3.5810000000E+04, 2.7573273550E+01, 5.1318516453E+00, 1.0619691900E+01, 3.0741503511E+00, 9.5089748891E-01],
	[3.5815000000E+04, 2.7579862301E+01, 5.1318708513E+00, 1.0624502346E+01, 3.0746421172E+00, 9.5091969117E-01],
	[3.5820000000E+04, 2.7586451706E+01, 5.1318900548E+00, 1.0629314297E+01, 3.0751337697E+00, 9.5094188224E-01],
	[3.5825000000E+04, 2.7593041766E+01, 5.1319092556E+00, 1.0634127754E+01, 3.0756253087E+00, 9.5096406213E-01],
	[3.5830000000E+04, 2.7599632479E+01, 5.1319284538E+00, 1.0638942718E+01, 3.0761167341E+00, 9.5098623085E-01],
	[3.5835000000E+04, 2.7606223847E+01, 5.1319476494E+00, 1.0643759187E+01, 3.0766080461E+00, 9.5100838840E-01],
	[3.5840000000E+04, 2.7612815870E+01, 5.1319668424E+00, 1.0648577163E+01, 3.0770992444E+00, 9.5103053478E-01],
	[3.5845000000E+04, 2.7619408546E+01, 5.1319860328E+00, 1.0653396646E+01, 3.0775903293E+00, 9.5105267001E-01],
	[3.5850000000E+04, 2.7626001877E+01, 5.1320052206E+00, 1.0658217635E+01, 3.0780813006E+00, 9.5107479408E-01],
	[3.5855000000E+04, 2.7632595861E+01, 5.1320244058E+00, 1.0663040132E+01, 3.0785721585E+00, 9.5109690700E-01],
	[3.5860000000E+04, 2.7639190500E+01, 5.1320435884E+00, 1.0667864137E+01, 3.0790629028E+00, 9.5111900878E-01],
	[3.5865000000E+04, 2.7645785793E+01, 5.1320627683E+00, 1.0672689649E+01, 3.0795535337E+00, 9.5114109943E-01],
	[3.5870000000E+04, 2.7652381740E+01, 5.1320819457E+00, 1.0677516669E+01, 3.0800440510E+00, 9.5116317894E-01],
	[3.5875000000E+04, 2.7658978341E+01, 5.1321011205E+00, 1.0682345198E+01, 3.0805344549E+00, 9.5118524733E-01],
	[3.5880000000E+04, 2.7665575596E+01, 5.1321202927E+00, 1.0687175235E+01, 3.0810247453E+00, 9.5120730460E-01],
	[3.5885000000E+04, 2.7672173505E+01, 5.1321394622E+00, 1.0692006781E+01, 3.0815149223E+00, 9.5122935075E-01],
	[3.5890000000E+04, 2.7678772067E+01, 5.1321586292E+00, 1.0696839836E+01, 3.0820049858E+00, 9.5125138580E-01],
	[3.5895000000E+04, 2.7685371284E+01, 5.1321777936E+00, 1.0701674401E+01, 3.0824949358E+00, 9.5127340974E-01],
	[3.5900000000E+04, 2.7691971155E+01, 5.1321969554E+00, 1.0706510475E+01, 3.0829847724E+00, 9.5129542258E-01],
	[3.5905000000E+04, 2.7698571679E+01, 5.1322161146E+00, 1.0711348059E+01, 3.0834744956E+00, 9.5131742433E-01],
	[3.5910000000E+04, 2.7705172858E+01, 5.1322352711E+00, 1.0716187153E+01, 3.0839641053E+00, 9.5133941499E-01],
	[3.5915000000E+04, 2.7711774690E+01, 5.1322544251E+00, 1.0721027758E+01, 3.0844536016E+00, 9.5136139457E-01],
	[3.5920000000E+04, 2.7718377176E+01, 5.1322735765E+00, 1.0725869873E+01, 3.0849429845E+00, 9.5138336307E-01],
	[3.5925000000E+04, 2.7724980315E+01, 5.1322927253E+00, 1.0730713499E+01, 3.0854322540E+00, 9.5140532051E-01],
	[3.5930000000E+04, 2.7731584109E+01, 5.1323118715E+00, 1.0735558636E+01, 3.0859214101E+00, 9.5142726687E-01],
	[3.5935000000E+04, 2.7738188556E+01, 5.1323310152E+00, 1.0740405285E+01, 3.0864104528E+00, 9.5144920218E-01],
	[3.5940000000E+04, 2.7744793657E+01, 5.1323501562E+00, 1.0745253445E+01, 3.0868993821E+00, 9.5147112643E-01],
	[3.5945000000E+04, 2.7751399411E+01, 5.1323692946E+00, 1.0750103118E+01, 3.0873881980E+00, 9.5149303963E-01],
	[3.5950000000E+04, 2.7758005819E+01, 5.1323884305E+00, 1.0754954302E+01, 3.0878769006E+00, 9.5151494179E-01],
	[3.5955000000E+04, 2.7764612881E+01, 5.1324075637E+00, 1.0759806999E+01, 3.0883654898E+00, 9.5153683291E-01],
	[3.5960000000E+04, 2.7771220596E+01, 5.1324266944E+00, 1.0764661209E+01, 3.0888539656E+00, 9.5155871300E-01],
	[3.5965000000E+04, 2.7777828965E+01, 5.1324458224E+00, 1.0769516932E+01, 3.0893423282E+00, 9.5158058206E-01],
	[3.5970000000E+04, 2.7784437988E+01, 5.1324649479E+00, 1.0774374168E+01, 3.0898305773E+00, 9.5160244010E-01],
	[3.5975000000E+04, 2.7791047664E+01, 5.1324840708E+00, 1.0779232917E+01, 3.0903187132E+00, 9.5162428712E-01],
	[3.5980000000E+04, 2.7797657993E+01, 5.1325031911E+00, 1.0784093181E+01, 3.0908067357E+00, 9.5164612313E-01],
	[3.5985000000E+04, 2.7804268976E+01, 5.1325223089E+00, 1.0788954958E+01, 3.0912946449E+00, 9.5166794813E-01],
	[3.5990000000E+04, 2.7810880612E+01, 5.1325414240E+00, 1.0793818250E+01, 3.0917824408E+00, 9.5168976214E-01],
	[3.5995000000E+04, 2.7817492901E+01, 5.1325605366E+00, 1.0798683056E+01, 3.0922701233E+00, 9.5171156515E-01],
	[3.6000000000E+04, 2.7824105844E+01, 5.1325796465E+00, 1.0803549377E+01, 3.0927576926E+00, 9.5173335717E-01],
	[3.6005000000E+04, 2.7830719441E+01, 5.1325987539E+00, 1.0808417213E+01, 3.0932451486E+00, 9.5175513820E-01],
	[3.6010000000E+04, 2.7837333690E+01, 5.1326178587E+00, 1.0813286565E+01, 3.0937324914E+00, 9.5177690826E-01],
	[3.6015000000E+04, 2.7843948593E+01, 5.1326369610E+00, 1.0818157432E+01, 3.0942197208E+00, 9.5179866735E-01],
	[3.6020000000E+04, 2.7850564149E+01, 5.1326560606E+00, 1.0823029815E+01, 3.0947068370E+00, 9.5182041547E-01],
	[3.6025000000E+04, 2.7857180359E+01, 5.1326751577E+00, 1.0827903714E+01, 3.0951938400E+00, 9.5184215263E-01],
	[3.6030000000E+04, 2.7863797221E+01, 5.1326942522E+00, 1.0832779129E+01, 3.0956807297E+00, 9.5186387883E-01],
	[3.6035000000E+04, 2.7870414737E+01, 5.1327133441E+00, 1.0837656062E+01, 3.0961675062E+00, 9.5188559408E-01],
	[3.6040000000E+04, 2.7877032906E+01, 5.1327324334E+00, 1.0842534511E+01, 3.0966541694E+00, 9.5190729838E-01],
	[3.6045000000E+04, 2.7883651728E+01, 5.1327515202E+00, 1.0847414477E+01, 3.0971407194E+00, 9.5192899175E-01],
	[3.6050000000E+04, 2.7890271204E+01, 5.1327706044E+00, 1.0852295960E+01, 3.0976271562E+00, 9.5195067417E-01],
	[3.6055000000E+04, 2.7896891332E+01, 5.1327896860E+00, 1.0857178962E+01, 3.0981134798E+00, 9.5197234568E-01],
	[3.6060000000E+04, 2.7903512113E+01, 5.1328087650E+00, 1.0862063481E+01, 3.0985996902E+00, 9.5199400625E-01],
	[3.6065000000E+04, 2.7910133548E+01, 5.1328278414E+00, 1.0866949519E+01, 3.0990857874E+00, 9.5201565591E-01],
	[3.6070000000E+04, 2.7916755635E+01, 5.1328469153E+00, 1.0871837074E+01, 3.0995717714E+00, 9.5203729466E-01],
	[3.6075000000E+04, 2.7923378375E+01, 5.1328659866E+00, 1.0876726149E+01, 3.1000576422E+00, 9.5205892250E-01],
	[3.6080000000E+04, 2.7930001768E+01, 5.1328850554E+00, 1.0881616743E+01, 3.1005433999E+00, 9.5208053943E-01],
	[3.6085000000E+04, 2.7936625815E+01, 5.1329041215E+00, 1.0886508856E+01, 3.1010290444E+00, 9.5210214547E-01],
	[3.6090000000E+04, 2.7943250514E+01, 5.1329231851E+00, 1.0891402488E+01, 3.1015145758E+00, 9.5212374062E-01],
	[3.6095000000E+04, 2.7949875866E+01, 5.1329422461E+00, 1.0896297640E+01, 3.1019999940E+00, 9.5214532489E-01],
	[3.6100000000E+04, 2.7956501871E+01, 5.1329613046E+00, 1.0901194313E+01, 3.1024852991E+00, 9.5216689827E-01],
	[3.6105000000E+04, 2.7963128528E+01, 5.1329803605E+00, 1.0906092505E+01, 3.1029704911E+00, 9.5218846078E-01],
	[3.6110000000E+04, 2.7969755839E+01, 5.1329994138E+00, 1.0910992218E+01, 3.1034555699E+00, 9.5221001242E-01],
	[3.6115000000E+04, 2.7976383802E+01, 5.1330184645E+00, 1.0915893452E+01, 3.1039405357E+00, 9.5223155320E-01],
	[3.6120000000E+04, 2.7983012418E+01, 5.1330375127E+00, 1.0920796207E+01, 3.1044253883E+00, 9.5225308312E-01],
	[3.6125000000E+04, 2.7989641686E+01, 5.1330565583E+00, 1.0925700483E+01, 3.1049101279E+00, 9.5227460218E-01],
	[3.6130000000E+04, 2.7996271608E+01, 5.1330756014E+00, 1.0930606281E+01, 3.1053947543E+00, 9.5229611040E-01],
	[3.6135000000E+04, 2.8002902182E+01, 5.1330946419E+00, 1.0935513601E+01, 3.1058792677E+00, 9.5231760778E-01],
	[3.6140000000E+04, 2.8009533408E+01, 5.1331136798E+00, 1.0940422443E+01, 3.1063636680E+00, 9.5233909432E-01],
	[3.6145000000E+04, 2.8016165288E+01, 5.1331327151E+00, 1.0945332807E+01, 3.1068479553E+00, 9.5236057003E-01],
	[3.6150000000E+04, 2.8022797819E+01, 5.1331517479E+00, 1.0950244694E+01, 3.1073321295E+00, 9.5238203491E-01],
	[3.6155000000E+04, 2.8029431004E+01, 5.1331707782E+00, 1.0955158104E+01, 3.1078161907E+00, 9.5240348898E-01],
	[3.6160000000E+04, 2.8036064841E+01, 5.1331898058E+00, 1.0960073037E+01, 3.1083001388E+00, 9.5242493223E-01],
	[3.6165000000E+04, 2.8042699330E+01, 5.1332088309E+00, 1.0964989493E+01, 3.1087839739E+00, 9.5244636467E-01],
	[3.6170000000E+04, 2.8049334472E+01, 5.1332278535E+00, 1.0969907473E+01, 3.1092676960E+00, 9.5246778631E-01],
	[3.6175000000E+04, 2.8055970266E+01, 5.1332468735E+00, 1.0974826977E+01, 3.1097513051E+00, 9.5248919715E-01],
	[3.6180000000E+04, 2.8062606713E+01, 5.1332658909E+00, 1.0979748005E+01, 3.1102348011E+00, 9.5251059719E-01],
	[3.6185000000E+04, 2.8069243812E+01, 5.1332849058E+00, 1.0984670558E+01, 3.1107181842E+00, 9.5253198645E-01],
	[3.6190000000E+04, 2.8075881564E+01, 5.1333039181E+00, 1.0989594635E+01, 3.1112014543E+00, 9.5255336493E-01],
	[3.6195000000E+04, 2.8082519968E+01, 5.1333229279E+00, 1.0994520238E+01, 3.1116846115E+00, 9.5257473263E-01],
	[3.6200000000E+04, 2.8089159024E+01, 5.1333419351E+00, 1.0999447365E+01, 3.1121676556E+00, 9.5259608956E-01],
	[3.6205000000E+04, 2.8095798732E+01, 5.1333609398E+00, 1.1004376018E+01, 3.1126505868E+00, 9.5261743572E-01],
	[3.6210000000E+04, 2.8102439093E+01, 5.1333799419E+00, 1.1009306197E+01, 3.1131334051E+00, 9.5263877112E-01],
	[3.6215000000E+04, 2.8109080106E+01, 5.1333989414E+00, 1.1014237902E+01, 3.1136161104E+00, 9.5266009577E-01],
	[3.6220000000E+04, 2.8115721771E+01, 5.1334179384E+00, 1.1019171133E+01, 3.1140987028E+00, 9.5268140967E-01],
	[3.6225000000E+04, 2.8122364089E+01, 5.1334369328E+00, 1.1024105891E+01, 3.1145811823E+00, 9.5270271283E-01],
	[3.6230000000E+04, 2.8129023830E+01, 5.1334582084E+00, 1.1029042176E+01, 3.1150645954E+00, 9.5272400525E-01],
	[3.6235000000E+04, 2.8135685782E+01, 5.1334796926E+00, 1.1033979987E+01, 3.1155479930E+00, 9.5274528693E-01],
	[3.6240000000E+04, 2.8142348393E+01, 5.1335011739E+00, 1.1038919326E+01, 3.1160312781E+00, 9.5276655789E-01],
	[3.6245000000E+04, 2.8149011661E+01, 5.1335226523E+00, 1.1043860193E+01, 3.1165144508E+00, 9.5278781813E-01],
	[3.6250000000E+04, 2.8155675588E+01, 5.1335441279E+00, 1.1048802587E+01, 3.1169975110E+00, 9.5280906765E-01],
	[3.6255000000E+04, 2.8162340173E+01, 5.1335656006E+00, 1.1053746510E+01, 3.1174804588E+00, 9.5283030646E-01],
	[3.6260000000E+04, 2.8169005417E+01, 5.1335870704E+00, 1.1058691961E+01, 3.1179632941E+00, 9.5285153456E-01],
	[3.6265000000E+04, 2.8175671318E+01, 5.1336085373E+00, 1.1063638940E+01, 3.1184460171E+00, 9.5287275196E-01],
	[3.6270000000E+04, 2.8182337877E+01, 5.1336300014E+00, 1.1068587449E+01, 3.1189286276E+00, 9.5289395867E-01],
	[3.6275000000E+04, 2.8189005095E+01, 5.1336514626E+00, 1.1073537486E+01, 3.1194111258E+00, 9.5291515469E-01],
	[3.6280000000E+04, 2.8195672971E+01, 5.1336729209E+00, 1.1078489053E+01, 3.1198935115E+00, 9.5293634002E-01],
	[3.6285000000E+04, 2.8202341504E+01, 5.1336943764E+00, 1.1083442150E+01, 3.1203757849E+00, 9.5295751468E-01],
	[3.6290000000E+04, 2.8209010696E+01, 5.1337158290E+00, 1.1088396777E+01, 3.1208579459E+00, 9.5297867866E-01],
	[3.6295000000E+04, 2.8215680545E+01, 5.1337372787E+00, 1.1093352934E+01, 3.1213399945E+00, 9.5299983198E-01],
	[3.6300000000E+04, 2.8222351053E+01, 5.1337587256E+00, 1.1098310621E+01, 3.1218219308E+00, 9.5302097463E-01],
	[3.6305000000E+04, 2.8229022218E+01, 5.1337801696E+00, 1.1103269839E+01, 3.1223037548E+00, 9.5304210663E-01],
	[3.6310000000E+04, 2.8235694042E+01, 5.1338016107E+00, 1.1108230588E+01, 3.1227854664E+00, 9.5306322797E-01],
	[3.6315000000E+04, 2.8242366523E+01, 5.1338230490E+00, 1.1113192868E+01, 3.1232670656E+00, 9.5308433867E-01],
	[3.6320000000E+04, 2.8249039662E+01, 5.1338444844E+00, 1.1118156680E+01, 3.1237485526E+00, 9.5310543873E-01],
	[3.6325000000E+04, 2.8255713459E+01, 5.1338659170E+00, 1.1123122024E+01, 3.1242299272E+00, 9.5312652815E-01],
	[3.6330000000E+04, 2.8262387913E+01, 5.1338873467E+00, 1.1128088899E+01, 3.1247111896E+00, 9.5314760695E-01],
	[3.6335000000E+04, 2.8269063026E+01, 5.1339087735E+00, 1.1133057307E+01, 3.1251923396E+00, 9.5316867512E-01],
	[3.6340000000E+04, 2.8275738796E+01, 5.1339301975E+00, 1.1138027248E+01, 3.1256733774E+00, 9.5318973267E-01],
	[3.6345000000E+04, 2.8282415224E+01, 5.1339516186E+00, 1.1142998721E+01, 3.1261543029E+00, 9.5321077961E-01],
	[3.6350000000E+04, 2.8289092309E+01, 5.1339730369E+00, 1.1147971727E+01, 3.1266351161E+00, 9.5323181594E-01],
	[3.6355000000E+04, 2.8295770052E+01, 5.1339944523E+00, 1.1152946267E+01, 3.1271158171E+00, 9.5325284167E-01],
	[3.6360000000E+04, 2.8302448453E+01, 5.1340158648E+00, 1.1157922340E+01, 3.1275964058E+00, 9.5327385680E-01],
	[3.6365000000E+04, 2.8309127512E+01, 5.1340372745E+00, 1.1162899947E+01, 3.1280768823E+00, 9.5329486134E-01],
	[3.6370000000E+04, 2.8315807228E+01, 5.1340586813E+00, 1.1167879088E+01, 3.1285572466E+00, 9.5331585530E-01],
	[3.6375000000E+04, 2.8322487601E+01, 5.1340800853E+00, 1.1172859764E+01, 3.1290374986E+00, 9.5333683867E-01],
	[3.6380000000E+04, 2.8329168632E+01, 5.1341014865E+00, 1.1177841974E+01, 3.1295176385E+00, 9.5335781147E-01],
	[3.6385000000E+04, 2.8335850321E+01, 5.1341228847E+00, 1.1182825719E+01, 3.1299976661E+00, 9.5337877370E-01],
	[3.6390000000E+04, 2.8342532667E+01, 5.1341442802E+00, 1.1187811000E+01, 3.1304775815E+00, 9.5339972536E-01],
	[3.6395000000E+04, 2.8349215671E+01, 5.1341656727E+00, 1.1192797815E+01, 3.1309573848E+00, 9.5342066646E-01],
	[3.6400000000E+04, 2.8355899332E+01, 5.1341870625E+00, 1.1197786167E+01, 3.1314370759E+00, 9.5344159702E-01],
	[3.6405000000E+04, 2.8362583650E+01, 5.1342084494E+00, 1.1202776054E+01, 3.1319166548E+00, 9.5346251702E-01],
	[3.6410000000E+04, 2.8369268626E+01, 5.1342298334E+00, 1.1207767478E+01, 3.1323961216E+00, 9.5348342648E-01],
	[3.6415000000E+04, 2.8375954259E+01, 5.1342512146E+00, 1.1212760438E+01, 3.1328754762E+00, 9.5350432540E-01],
	[3.6420000000E+04, 2.8382640550E+01, 5.1342725929E+00, 1.1217754934E+01, 3.1333547187E+00, 9.5352521379E-01],
	[3.6425000000E+04, 2.8389327497E+01, 5.1342939684E+00, 1.1222750968E+01, 3.1338338490E+00, 9.5354609166E-01],
	[3.6430000000E+04, 2.8396015102E+01, 5.1343153410E+00, 1.1227748539E+01, 3.1343128672E+00, 9.5356695900E-01],
	[3.6435000000E+04, 2.8402703365E+01, 5.1343367109E+00, 1.1232747647E+01, 3.1347917734E+00, 9.5358781583E-01],
	[3.6440000000E+04, 2.8409392284E+01, 5.1343580778E+00, 1.1237748294E+01, 3.1352705674E+00, 9.5360866215E-01],
	[3.6445000000E+04, 2.8416081861E+01, 5.1343794419E+00, 1.1242750478E+01, 3.1357492493E+00, 9.5362949796E-01],
	[3.6450000000E+04, 2.8422772095E+01, 5.1344008032E+00, 1.1247754201E+01, 3.1362278192E+00, 9.5365032328E-01],
	[3.6455000000E+04, 2.8429462986E+01, 5.1344221616E+00, 1.1252759462E+01, 3.1367062770E+00, 9.5367113810E-01],
	[3.6460000000E+04, 2.8436154534E+01, 5.1344435172E+00, 1.1257766262E+01, 3.1371846227E+00, 9.5369194243E-01],
	[3.6465000000E+04, 2.8442846739E+01, 5.1344648700E+00, 1.1262774601E+01, 3.1376628564E+00, 9.5371273628E-01],
	[3.6470000000E+04, 2.8449539602E+01, 5.1344862199E+00, 1.1267784479E+01, 3.1381409780E+00, 9.5373351965E-01],
	[3.6475000000E+04, 2.8456233121E+01, 5.1345075670E+00, 1.1272795897E+01, 3.1386189876E+00, 9.5375429255E-01],
	[3.6480000000E+04, 2.8462927297E+01, 5.1345289112E+00, 1.1277808855E+01, 3.1390968852E+00, 9.5377505498E-01],
	[3.6485000000E+04, 2.8469622131E+01, 5.1345502526E+00, 1.1282823353E+01, 3.1395746708E+00, 9.5379580695E-01],
	[3.6490000000E+04, 2.8476317621E+01, 5.1345715912E+00, 1.1287839391E+01, 3.1400523444E+00, 9.5381654847E-01],
	[3.6495000000E+04, 2.8483013768E+01, 5.1345929269E+00, 1.1292856970E+01, 3.1405299059E+00, 9.5383727953E-01],
	[3.6500000000E+04, 2.8489710573E+01, 5.1346142598E+00, 1.1297876090E+01, 3.1410073555E+00, 9.5385800015E-01],
	[3.6505000000E+04, 2.8496408034E+01, 5.1346355899E+00, 1.1302896751E+01, 3.1414846931E+00, 9.5387871033E-01],
	[3.6510000000E+04, 2.8503106152E+01, 5.1346569171E+00, 1.1307918954E+01, 3.1419619188E+00, 9.5389941007E-01],
	[3.6515000000E+04, 2.8509804927E+01, 5.1346782415E+00, 1.1312942698E+01, 3.1424390325E+00, 9.5392009939E-01],
	[3.6520000000E+04, 2.8516504358E+01, 5.1346995631E+00, 1.1317967984E+01, 3.1429160342E+00, 9.5394077828E-01],
	[3.6525000000E+04, 2.8523204447E+01, 5.1347208818E+00, 1.1322994813E+01, 3.1433929240E+00, 9.5396144675E-01],
	[3.6530000000E+04, 2.8529905192E+01, 5.1347421977E+00, 1.1328023184E+01, 3.1438697019E+00, 9.5398210481E-01],
	[3.6535000000E+04, 2.8536606594E+01, 5.1347635108E+00, 1.1333053097E+01, 3.1443463679E+00, 9.5400275246E-01],
	[3.6540000000E+04, 2.8543308653E+01, 5.1347848211E+00, 1.1338084554E+01, 3.1448229219E+00, 9.5402338971E-01],
	[3.6545000000E+04, 2.8550011368E+01, 5.1348061285E+00, 1.1343117554E+01, 3.1452993641E+00, 9.5404401657E-01],
	[3.6550000000E+04, 2.8556714740E+01, 5.1348274331E+00, 1.1348152097E+01, 3.1457756944E+00, 9.5406463303E-01],
	[3.6555000000E+04, 2.8563418769E+01, 5.1348487349E+00, 1.1353188184E+01, 3.1462519128E+00, 9.5408523911E-01],
	[3.6560000000E+04, 2.8570123454E+01, 5.1348700338E+00, 1.1358225815E+01, 3.1467280193E+00, 9.5410583481E-01],
	[3.6565000000E+04, 2.8576828796E+01, 5.1348913299E+00, 1.1363264991E+01, 3.1472040140E+00, 9.5412642013E-01],
	[3.6570000000E+04, 2.8583534794E+01, 5.1349126232E+00, 1.1368305711E+01, 3.1476798968E+00, 9.5414699508E-01],
	[3.6575000000E+04, 2.8590241449E+01, 5.1349339137E+00, 1.1373347976E+01, 3.1481556678E+00, 9.5416755967E-01],
	[3.6580000000E+04, 2.8596948760E+01, 5.1349552014E+00, 1.1378391786E+01, 3.1486313270E+00, 9.5418811390E-01],
	[3.6585000000E+04, 2.8603656728E+01, 5.1349764862E+00, 1.1383437141E+01, 3.1491068743E+00, 9.5420865778E-01],
	[3.6590000000E+04, 2.8610365353E+01, 5.1349977682E+00, 1.1388484042E+01, 3.1495823098E+00, 9.5422919130E-01],
	[3.6595000000E+04, 2.8617074634E+01, 5.1350190474E+00, 1.1393532489E+01, 3.1500576336E+00, 9.5424971449E-01],
	[3.6600000000E+04, 2.8623784571E+01, 5.1350403238E+00, 1.1398582482E+01, 3.1505328455E+00, 9.5427022734E-01],
	[3.6605000000E+04, 2.8630495164E+01, 5.1350615973E+00, 1.1403634021E+01, 3.1510079457E+00, 9.5429072985E-01],
	[3.6610000000E+04, 2.8637206414E+01, 5.1350828681E+00, 1.1408687107E+01, 3.1514829341E+00, 9.5431122204E-01],
	[3.6615000000E+04, 2.8643918321E+01, 5.1351041360E+00, 1.1413741740E+01, 3.1519578108E+00, 9.5433170391E-01],
	[3.6620000000E+04, 2.8650630883E+01, 5.1351254011E+00, 1.1418797920E+01, 3.1524325757E+00, 9.5435217546E-01],
	[3.6625000000E+04, 2.8657344102E+01, 5.1351466634E+00, 1.1423855648E+01, 3.1529072289E+00, 9.5437263671E-01],
	[3.6630000000E+04, 2.8664057977E+01, 5.1351679228E+00, 1.1428914923E+01, 3.1533817703E+00, 9.5439308764E-01],
	[3.6635000000E+04, 2.8670772509E+01, 5.1351891795E+00, 1.1433975746E+01, 3.1538562000E+00, 9.5441352828E-01],
	[3.6640000000E+04, 2.8677487696E+01, 5.1352104334E+00, 1.1439038118E+01, 3.1543305181E+00, 9.5443395863E-01],
	[3.6645000000E+04, 2.8684203540E+01, 5.1352316844E+00, 1.1444102038E+01, 3.1548047244E+00, 9.5445437868E-01],
	[3.6650000000E+04, 2.8690920040E+01, 5.1352529326E+00, 1.1449167506E+01, 3.1552788190E+00, 9.5447478845E-01],
	[3.6655000000E+04, 2.8697637196E+01, 5.1352741780E+00, 1.1454234524E+01, 3.1557528020E+00, 9.5449518795E-01],
	[3.6660000000E+04, 2.8704355008E+01, 5.1352954206E+00, 1.1459303091E+01, 3.1562266733E+00, 9.5451557717E-01],
	[3.6665000000E+04, 2.8711073476E+01, 5.1353166604E+00, 1.1464373207E+01, 3.1567004329E+00, 9.5453595612E-01],
	[3.6670000000E+04, 2.8717792601E+01, 5.1353378974E+00, 1.1469444874E+01, 3.1571740809E+00, 9.5455632481E-01],
	[3.6675000000E+04, 2.8724512381E+01, 5.1353591316E+00, 1.1474518090E+01, 3.1576476173E+00, 9.5457668325E-01],
	[3.6680000000E+04, 2.8731232817E+01, 5.1353803630E+00, 1.1479592857E+01, 3.1581210421E+00, 9.5459703143E-01],
	[3.6685000000E+04, 2.8737953910E+01, 5.1354015915E+00, 1.1484669174E+01, 3.1585943552E+00, 9.5461736937E-01],
	[3.6690000000E+04, 2.8744675658E+01, 5.1354228173E+00, 1.1489747042E+01, 3.1590675567E+00, 9.5463769707E-01],
	[3.6695000000E+04, 2.8751398062E+01, 5.1354440402E+00, 1.1494826461E+01, 3.1595406466E+00, 9.5465801453E-01],
	[3.6700000000E+04, 2.8758121122E+01, 5.1354652604E+00, 1.1499907432E+01, 3.1600136250E+00, 9.5467832176E-01],
	[3.6705000000E+04, 2.8764844838E+01, 5.1354864777E+00, 1.1504989954E+01, 3.1604864918E+00, 9.5469861877E-01],
	[3.6710000000E+04, 2.8771569210E+01, 5.1355076923E+00, 1.1510074028E+01, 3.1609592470E+00, 9.5471890556E-01],
	[3.6715000000E+04, 2.8778294237E+01, 5.1355289040E+00, 1.1515159654E+01, 3.1614318907E+00, 9.5473918214E-01],
	[3.6720000000E+04, 2.8785019921E+01, 5.1355501130E+00, 1.1520246833E+01, 3.1619044228E+00, 9.5475944850E-01],
	[3.6725000000E+04, 2.8791746260E+01, 5.1355713191E+00, 1.1525335564E+01, 3.1623768434E+00, 9.5477970467E-01],
	[3.6730000000E+04, 2.8798473255E+01, 5.1355925225E+00, 1.1530425848E+01, 3.1628491525E+00, 9.5479995064E-01],
	[3.6735000000E+04, 2.8805200905E+01, 5.1356137230E+00, 1.1535517686E+01, 3.1633213500E+00, 9.5482018641E-01],
	[3.6740000000E+04, 2.8811929212E+01, 5.1356349208E+00, 1.1540611077E+01, 3.1637934361E+00, 9.5484041200E-01],
	[3.6745000000E+04, 2.8818658174E+01, 5.1356561157E+00, 1.1545706021E+01, 3.1642654107E+00, 9.5486062741E-01],
	[3.6750000000E+04, 2.8825387791E+01, 5.1356773079E+00, 1.1550802520E+01, 3.1647372738E+00, 9.5488083264E-01],
	[3.6755000000E+04, 2.8832118065E+01, 5.1356984972E+00, 1.1555900573E+01, 3.1652090255E+00, 9.5490102770E-01],
	[3.6760000000E+04, 2.8838848994E+01, 5.1357196838E+00, 1.1561000180E+01, 3.1656806656E+00, 9.5492121259E-01],
	[3.6765000000E+04, 2.8845580578E+01, 5.1357408675E+00, 1.1566101342E+01, 3.1661521944E+00, 9.5494138733E-01],
	[3.6770000000E+04, 2.8852312818E+01, 5.1357620485E+00, 1.1571204059E+01, 3.1666236117E+00, 9.5496155191E-01],
	[3.6775000000E+04, 2.8859045714E+01, 5.1357832267E+00, 1.1576308332E+01, 3.1670949176E+00, 9.5498170634E-01],
	[3.6780000000E+04, 2.8865779265E+01, 5.1358044021E+00, 1.1581414160E+01, 3.1675661120E+00, 9.5500185063E-01],
	[3.6785000000E+04, 2.8872513471E+01, 5.1358255747E+00, 1.1586521544E+01, 3.1680371951E+00, 9.5502198478E-01],
	[3.6790000000E+04, 2.8879248333E+01, 5.1358467445E+00, 1.1591630483E+01, 3.1685081668E+00, 9.5504210879E-01],
	[3.6795000000E+04, 2.8885983850E+01, 5.1358679115E+00, 1.1596740980E+01, 3.1689790271E+00, 9.5506222268E-01],
	[3.6800000000E+04, 2.8892720023E+01, 5.1358890758E+00, 1.1601853032E+01, 3.1694497760E+00, 9.5508232645E-01],
	[3.6805000000E+04, 2.8899456851E+01, 5.1359102372E+00, 1.1606966642E+01, 3.1699204136E+00, 9.5510242009E-01],
	[3.6810000000E+04, 2.8906199382E+01, 5.1359320776E+00, 1.1612081809E+01, 3.1703912603E+00, 9.5512250363E-01],
	[3.6815000000E+04, 2.8912955599E+01, 5.1359556745E+00, 1.1617198533E+01, 3.1708628231E+00, 9.5514257706E-01],
	[3.6820000000E+04, 2.8919712477E+01, 5.1359792683E+00, 1.1622316815E+01, 3.1713342750E+00, 9.5516264039E-01],
	[3.6825000000E+04, 2.8926470016E+01, 5.1360028590E+00, 1.1627436655E+01, 3.1718056161E+00, 9.5518269362E-01],
	[3.6830000000E+04, 2.8933228217E+01, 5.1360264466E+00, 1.1632558053E+01, 3.1722768462E+00, 9.5520273676E-01],
	[3.6835000000E+04, 2.8939987079E+01, 5.1360500311E+00, 1.1637681009E+01, 3.1727479654E+00, 9.5522276982E-01],
	[3.6840000000E+04, 2.8946746602E+01, 5.1360736126E+00, 1.1642805524E+01, 3.1732189738E+00, 9.5524279280E-01],
	[3.6845000000E+04, 2.8953506786E+01, 5.1360971909E+00, 1.1647931598E+01, 3.1736898713E+00, 9.5526280570E-01],
	[3.6850000000E+04, 2.8960267632E+01, 5.1361207662E+00, 1.1653059231E+01, 3.1741606580E+00, 9.5528280854E-01],
	[3.6855000000E+04, 2.8967029138E+01, 5.1361443383E+00, 1.1658188424E+01, 3.1746313339E+00, 9.5530280131E-01],
	[3.6860000000E+04, 2.8973791306E+01, 5.1361679074E+00, 1.1663319176E+01, 3.1751018989E+00, 9.5532278402E-01],
	[3.6865000000E+04, 2.8980554134E+01, 5.1361914734E+00, 1.1668451489E+01, 3.1755723531E+00, 9.5534275668E-01],
	[3.6870000000E+04, 2.8987317624E+01, 5.1362150363E+00, 1.1673585361E+01, 3.1760426965E+00, 9.5536271929E-01],
	[3.6875000000E+04, 2.8994081774E+01, 5.1362385961E+00, 1.1678720794E+01, 3.1765129291E+00, 9.5538267186E-01],
	[3.6880000000E+04, 2.9000846586E+01, 5.1362621528E+00, 1.1683857788E+01, 3.1769830509E+00, 9.5540261439E-01],
	[3.6885000000E+04, 2.9007612059E+01, 5.1362857064E+00, 1.1688996343E+01, 3.1774530620E+00, 9.5542254689E-01],
	[3.6890000000E+04, 2.9014378192E+01, 5.1363092570E+00, 1.1694136460E+01, 3.1779229623E+00, 9.5544246936E-01],
	[3.6895000000E+04, 2.9021144986E+01, 5.1363328045E+00, 1.1699278138E+01, 3.1783927519E+00, 9.5546238181E-01],
	[3.6900000000E+04, 2.9027912442E+01, 5.1363563489E+00, 1.1704421377E+01, 3.1788624307E+00, 9.5548228425E-01],
	[3.6905000000E+04, 2.9034680558E+01, 5.1363798902E+00, 1.1709566179E+01, 3.1793319988E+00, 9.5550217667E-01],
	[3.6910000000E+04, 2.9041449335E+01, 5.1364034284E+00, 1.1714712544E+01, 3.1798014562E+00, 9.5552205910E-01],
	[3.6915000000E+04, 2.9048218772E+01, 5.1364269635E+00, 1.1719860470E+01, 3.1802708029E+00, 9.5554193152E-01],
	[3.6920000000E+04, 2.9054988871E+01, 5.1364504956E+00, 1.1725009960E+01, 3.1807400389E+00, 9.5556179394E-01],
	[3.6925000000E+04, 2.9061759630E+01, 5.1364740246E+00, 1.1730161013E+01, 3.1812091642E+00, 9.5558164638E-01],
	[3.6930000000E+04, 2.9068531050E+01, 5.1364975505E+00, 1.1735313629E+01, 3.1816781788E+00, 9.5560148883E-01],
	[3.6935000000E+04, 2.9075303130E+01, 5.1365210733E+00, 1.1740467809E+01, 3.1821470828E+00, 9.5562132131E-01],
	[3.6940000000E+04, 2.9082075872E+01, 5.1365445930E+00, 1.1745623553E+01, 3.1826158761E+00, 9.5564114381E-01],
	[3.6945000000E+04, 2.9088849274E+01, 5.1365681097E+00, 1.1750780861E+01, 3.1830845588E+00, 9.5566095634E-01],
	[3.6950000000E+04, 2.9095623336E+01, 5.1365916233E+00, 1.1755939734E+01, 3.1835531309E+00, 9.5568075891E-01],
	[3.6955000000E+04, 2.9102398059E+01, 5.1366151338E+00, 1.1761100171E+01, 3.1840215924E+00, 9.5570055153E-01],
	[3.6960000000E+04, 2.9109173443E+01, 5.1366386413E+00, 1.1766262173E+01, 3.1844899432E+00, 9.5572033419E-01],
	[3.6965000000E+04, 2.9115949488E+01, 5.1366621457E+00, 1.1771425741E+01, 3.1849581835E+00, 9.5574010690E-01],
	[3.6970000000E+04, 2.9122726192E+01, 5.1366856470E+00, 1.1776590874E+01, 3.1854263132E+00, 9.5575986967E-01],
	[3.6975000000E+04, 2.9129503558E+01, 5.1367091452E+00, 1.1781757572E+01, 3.1858943323E+00, 9.5577962251E-01],
	[3.6980000000E+04, 2.9136281583E+01, 5.1367326404E+00, 1.1786925837E+01, 3.1863622409E+00, 9.5579936542E-01],
	[3.6985000000E+04, 2.9143060270E+01, 5.1367561325E+00, 1.1792095668E+01, 3.1868300389E+00, 9.5581909840E-01],
	[3.6990000000E+04, 2.9149839616E+01, 5.1367796215E+00, 1.1797267066E+01, 3.1872977263E+00, 9.5583882146E-01],
	[3.6995000000E+04, 2.9156619623E+01, 5.1368031075E+00, 1.1802440030E+01, 3.1877653033E+00, 9.5585853461E-01],
	[3.7000000000E+04, 2.9163400291E+01, 5.1368265904E+00, 1.1807614562E+01, 3.1882327697E+00, 9.5587823784E-01],
	[3.7005000000E+04, 2.9170181619E+01, 5.1368500702E+00, 1.1812790660E+01, 3.1887001257E+00, 9.5589793117E-01],
	[3.7010000000E+04, 2.9176963607E+01, 5.1368735470E+00, 1.1817968327E+01, 3.1891673711E+00, 9.5591761461E-01],
	[3.7015000000E+04, 2.9183746255E+01, 5.1368970207E+00, 1.1823147561E+01, 3.1896345061E+00, 9.5593728815E-01],
	[3.7020000000E+04, 2.9190529564E+01, 5.1369204913E+00, 1.1828328364E+01, 3.1901015306E+00, 9.5595695180E-01],
	[3.7025000000E+04, 2.9197313533E+01, 5.1369439589E+00, 1.1833510734E+01, 3.1905684446E+00, 9.5597660556E-01],
	[3.7030000000E+04, 2.9204098162E+01, 5.1369674234E+00, 1.1838694674E+01, 3.1910352482E+00, 9.5599624945E-01],
	[3.7035000000E+04, 2.9210883451E+01, 5.1369908849E+00, 1.1843880182E+01, 3.1915019414E+00, 9.5601588347E-01],
	[3.7040000000E+04, 2.9217669401E+01, 5.1370143433E+00, 1.1849067260E+01, 3.1919685241E+00, 9.5603550762E-01],
	[3.7045000000E+04, 2.9224456010E+01, 5.1370377986E+00, 1.1854255907E+01, 3.1924349965E+00, 9.5605512191E-01],
	[3.7050000000E+04, 2.9231243280E+01, 5.1370612509E+00, 1.1859446123E+01, 3.1929013584E+00, 9.5607472634E-01],
	[3.7055000000E+04, 2.9238031210E+01, 5.1370847001E+00, 1.1864637910E+01, 3.1933676100E+00, 9.5609432092E-01],
	[3.7060000000E+04, 2.9244819800E+01, 5.1371081462E+00, 1.1869831267E+01, 3.1938337511E+00, 9.5611390565E-01],
	[3.7065000000E+04, 2.9251609050E+01, 5.1371315894E+00, 1.1875026194E+01, 3.1942997820E+00, 9.5613348055E-01],
	[3.7070000000E+04, 2.9258398960E+01, 5.1371550294E+00, 1.1880222692E+01, 3.1947657024E+00, 9.5615304560E-01],
	[3.7075000000E+04, 2.9265189530E+01, 5.1371784664E+00, 1.1885420761E+01, 3.1952315125E+00, 9.5617260083E-01],
	[3.7080000000E+04, 2.9271980760E+01, 5.1372019003E+00, 1.1890620402E+01, 3.1956972123E+00, 9.5619214623E-01],
	[3.7085000000E+04, 2.9278772650E+01, 5.1372253312E+00, 1.1895821614E+01, 3.1961628018E+00, 9.5621168182E-01],
	[3.7090000000E+04, 2.9285565200E+01, 5.1372487591E+00, 1.1901024397E+01, 3.1966282810E+00, 9.5623120758E-01],
	[3.7095000000E+04, 2.9292358410E+01, 5.1372721838E+00, 1.1906228753E+01, 3.1970936498E+00, 9.5625072354E-01],
	[3.7100000000E+04, 2.9299152280E+01, 5.1372956056E+00, 1.1911434681E+01, 3.1975589084E+00, 9.5627022970E-01],
	[3.7105000000E+04, 2.9305946809E+01, 5.1373190243E+00, 1.1916642182E+01, 3.1980240568E+00, 9.5628972605E-01],
	[3.7110000000E+04, 2.9312741999E+01, 5.1373424399E+00, 1.1921851255E+01, 3.1984890948E+00, 9.5630921262E-01],
	[3.7115000000E+04, 2.9319537848E+01, 5.1373658525E+00, 1.1927061902E+01, 3.1989540226E+00, 9.5632868939E-01],
	[3.7120000000E+04, 2.9326334357E+01, 5.1373892620E+00, 1.1932274122E+01, 3.1994188402E+00, 9.5634815638E-01],
	[3.7125000000E+04, 2.9333131525E+01, 5.1374126685E+00, 1.1937487915E+01, 3.1998835476E+00, 9.5636761360E-01],
	[3.7130000000E+04, 2.9339929354E+01, 5.1374360720E+00, 1.1942703283E+01, 3.2003481447E+00, 9.5638706104E-01],
	[3.7135000000E+04, 2.9346727842E+01, 5.1374594724E+00, 1.1947920224E+01, 3.2008126317E+00, 9.5640649871E-01],
	[3.7140000000E+04, 2.9353526990E+01, 5.1374828697E+00, 1.1953138740E+01, 3.2012770084E+00, 9.5642592660E-01],
	[3.7145000000E+04, 2.9360326797E+01, 5.1375062641E+00, 1.1958358831E+01, 3.2017412750E+00, 9.5644534471E-01],
	[3.7150000000E+04, 2.9367127264E+01, 5.1375296553E+00, 1.1963580497E+01, 3.2022054314E+00, 9.5646475305E-01],
	[3.7155000000E+04, 2.9373928391E+01, 5.1375530436E+00, 1.1968803738E+01, 3.2026694777E+00, 9.5648415162E-01],
	[3.7160000000E+04, 2.9380730177E+01, 5.1375764288E+00, 1.1974028554E+01, 3.2031334138E+00, 9.5650354042E-01],
	[3.7165000000E+04, 2.9387532623E+01, 5.1375998109E+00, 1.1979254946E+01, 3.2035972398E+00, 9.5652291946E-01],
	[3.7170000000E+04, 2.9394335728E+01, 5.1376231900E+00, 1.1984482914E+01, 3.2040609557E+00, 9.5654228876E-01],
	[3.7175000000E+04, 2.9401139493E+01, 5.1376465661E+00, 1.1989712458E+01, 3.2045245615E+00, 9.5656164830E-01],
	[3.7180000000E+04, 2.9407943917E+01, 5.1376699391E+00, 1.1994943579E+01, 3.2049880572E+00, 9.5658099810E-01],
	[3.7185000000E+04, 2.9414749001E+01, 5.1376933091E+00, 1.2000176277E+01, 3.2054514428E+00, 9.5660033816E-01],
	[3.7190000000E+04, 2.9421554744E+01, 5.1377166761E+00, 1.2005410552E+01, 3.2059147183E+00, 9.5661966849E-01],
	[3.7195000000E+04, 2.9428361147E+01, 5.1377400400E+00, 1.2010646403E+01, 3.2063778838E+00, 9.5663898909E-01],
	[3.7200000000E+04, 2.9435168209E+01, 5.1377634009E+00, 1.2015883833E+01, 3.2068409392E+00, 9.5665829997E-01],
	[3.7205000000E+04, 2.9441975930E+01, 5.1377867588E+00, 1.2021122840E+01, 3.2073038846E+00, 9.5667760113E-01],
	[3.7210000000E+04, 2.9448784311E+01, 5.1378101136E+00, 1.2026363426E+01, 3.2077667200E+00, 9.5669689258E-01],
	[3.7215000000E+04, 2.9455593351E+01, 5.1378334654E+00, 1.2031605590E+01, 3.2082294454E+00, 9.5671617432E-01],
	[3.7220000000E+04, 2.9462403050E+01, 5.1378568142E+00, 1.2036849332E+01, 3.2086920608E+00, 9.5673544636E-01],
	[3.7225000000E+04, 2.9469213409E+01, 5.1378801599E+00, 1.2042094653E+01, 3.2091545662E+00, 9.5675470870E-01],
	[3.7230000000E+04, 2.9476024427E+01, 5.1379035026E+00, 1.2047341554E+01, 3.2096169616E+00, 9.5677396135E-01],
	[3.7235000000E+04, 2.9482836104E+01, 5.1379268423E+00, 1.2052590034E+01, 3.2100792470E+00, 9.5679320431E-01],
	[3.7240000000E+04, 2.9489648440E+01, 5.1379501790E+00, 1.2057840093E+01, 3.2105414226E+00, 9.5681243759E-01],
	[3.7245000000E+04, 2.9496461435E+01, 5.1379735126E+00, 1.2063091732E+01, 3.2110034881E+00, 9.5683166119E-01],
	[3.7250000000E+04, 2.9503275089E+01, 5.1379968432E+00, 1.2068344952E+01, 3.2114654438E+00, 9.5685087512E-01],
	[3.7255000000E+04, 2.9510089403E+01, 5.1380201708E+00, 1.2073599752E+01, 3.2119272895E+00, 9.5687007938E-01],
	[3.7260000000E+04, 2.9516904376E+01, 5.1380434953E+00, 1.2078856133E+01, 3.2123890254E+00, 9.5688927398E-01],
	[3.7265000000E+04, 2.9523720007E+01, 5.1380668168E+00, 1.2084114095E+01, 3.2128506513E+00, 9.5690845893E-01],
	[3.7270000000E+04, 2.9530536298E+01, 5.1380901353E+00, 1.2089373638E+01, 3.2133121674E+00, 9.5692763422E-01],
	[3.7275000000E+04, 2.9537353248E+01, 5.1381134508E+00, 1.2094634762E+01, 3.2137735736E+00, 9.5694679986E-01],
	[3.7280000000E+04, 2.9544170856E+01, 5.1381367633E+00, 1.2099897468E+01, 3.2142348700E+00, 9.5696595587E-01],
	[3.7285000000E+04, 2.9550989124E+01, 5.1381600727E+00, 1.2105161757E+01, 3.2146960566E+00, 9.5698510224E-01],
	[3.7290000000E+04, 2.9557808051E+01, 5.1381833791E+00, 1.2110427627E+01, 3.2151571333E+00, 9.5700423897E-01],
	[3.7295000000E+04, 2.9564627636E+01, 5.1382066825E+00, 1.2115695080E+01, 3.2156181002E+00, 9.5702336608E-01],
	[3.7300000000E+04, 2.9571447880E+01, 5.1382299829E+00, 1.2120964116E+01, 3.2160789573E+00, 9.5704248357E-01],
	[3.7305000000E+04, 2.9578268784E+01, 5.1382532803E+00, 1.2126234735E+01, 3.2165397046E+00, 9.5706159144E-01],
	[3.7310000000E+04, 2.9585090346E+01, 5.1382765746E+00, 1.2131506938E+01, 3.2170003421E+00, 9.5708068970E-01],
	[3.7315000000E+04, 2.9591912567E+01, 5.1382998659E+00, 1.2136780724E+01, 3.2174608699E+00, 9.5709977836E-01],
	[3.7320000000E+04, 2.9598735446E+01, 5.1383231542E+00, 1.2142056094E+01, 3.2179212879E+00, 9.5711885741E-01],
	[3.7325000000E+04, 2.9605558985E+01, 5.1383464395E+00, 1.2147333048E+01, 3.2183815962E+00, 9.5713792687E-01],
	[3.7330000000E+04, 2.9612383182E+01, 5.1383697218E+00, 1.2152611586E+01, 3.2188417947E+00, 9.5715698674E-01],
	[3.7335000000E+04, 2.9619208038E+01, 5.1383930011E+00, 1.2157891709E+01, 3.2193018836E+00, 9.5717603702E-01],
	[3.7340000000E+04, 2.9626033553E+01, 5.1384162774E+00, 1.2163173417E+01, 3.2197618627E+00, 9.5719507772E-01],
	[3.7345000000E+04, 2.9632859726E+01, 5.1384395506E+00, 1.2168456710E+01, 3.2202217322E+00, 9.5721410885E-01],
	[3.7350000000E+04, 2.9639686558E+01, 5.1384628208E+00, 1.2173741589E+01, 3.2206814920E+00, 9.5723313041E-01],
	[3.7355000000E+04, 2.9646514048E+01, 5.1384860881E+00, 1.2179028053E+01, 3.2211411421E+00, 9.5725214240E-01],
	[3.7360000000E+04, 2.9653342197E+01, 5.1385093523E+00, 1.2184316103E+01, 3.2216006826E+00, 9.5727114482E-01],
	[3.7365000000E+04, 2.9660171005E+01, 5.1385326135E+00, 1.2189605740E+01, 3.2220601134E+00, 9.5729013770E-01],
	[3.7370000000E+04, 2.9667000471E+01, 5.1385558717E+00, 1.2194896963E+01, 3.2225194346E+00, 9.5730912102E-01],
	[3.7375000000E+04, 2.9673830596E+01, 5.1385791269E+00, 1.2200189772E+01, 3.2229786462E+00, 9.5732809480E-01],
	[3.7380000000E+04, 2.9680661379E+01, 5.1386023791E+00, 1.2205484169E+01, 3.2234377482E+00, 9.5734705904E-01],
	[3.7385000000E+04, 2.9687492821E+01, 5.1386256283E+00, 1.2210780153E+01, 3.2238967406E+00, 9.5736601374E-01],
	[3.7390000000E+04, 2.9694324921E+01, 5.1386488745E+00, 1.2216077725E+01, 3.2243556234E+00, 9.5738495891E-01],
	[3.7395000000E+04, 2.9701157679E+01, 5.1386721177E+00, 1.2221376884E+01, 3.2248143967E+00, 9.5740389456E-01],
	[3.7400000000E+04, 2.9707991096E+01, 5.1386953578E+00, 1.2226677631E+01, 3.2252730604E+00, 9.5742282069E-01],
	[3.7405000000E+04, 2.9714838814E+01, 5.1387204235E+00, 1.2231979967E+01, 3.2257324958E+00, 9.5744173730E-01],
	[3.7410000000E+04, 2.9721691374E+01, 5.1387460457E+00, 1.2237283891E+01, 3.2261920920E+00, 9.5746064440E-01],
	[3.7415000000E+04, 2.9728544598E+01, 5.1387716647E+00, 1.2242589405E+01, 3.2266515790E+00, 9.5747954200E-01],
	[3.7420000000E+04, 2.9735398485E+01, 5.1387972804E+00, 1.2247896507E+01, 3.2271109569E+00, 9.5749843010E-01],
	[3.7425000000E+04, 2.9742253037E+01, 5.1388228928E+00, 1.2253205199E+01, 3.2275702257E+00, 9.5751730870E-01],
	[3.7430000000E+04, 2.9749108253E+01, 5.1388485019E+00, 1.2258515480E+01, 3.2280293855E+00, 9.5753617781E-01],
	[3.7435000000E+04, 2.9755964133E+01, 5.1388741077E+00, 1.2263827351E+01, 3.2284884362E+00, 9.5755503744E-01],
	[3.7440000000E+04, 2.9762820677E+01, 5.1388997102E+00, 1.2269140813E+01, 3.2289473778E+00, 9.5757388759E-01],
	[3.7445000000E+04, 2.9769677885E+01, 5.1389253094E+00, 1.2274455865E+01, 3.2294062104E+00, 9.5759272827E-01],
	[3.7450000000E+04, 2.9776535757E+01, 5.1389509053E+00, 1.2279772507E+01, 3.2298649340E+00, 9.5761155947E-01],
	[3.7455000000E+04, 2.9783394293E+01, 5.1389764979E+00, 1.2285090741E+01, 3.2303235485E+00, 9.5763038121E-01],
	[3.7460000000E+04, 2.9790253493E+01, 5.1390020873E+00, 1.2290410565E+01, 3.2307820541E+00, 9.5764919349E-01],
	[3.7465000000E+04, 2.9797113357E+01, 5.1390276734E+00, 1.2295731982E+01, 3.2312404506E+00, 9.5766799632E-01],
	[3.7470000000E+04, 2.9803973884E+01, 5.1390532561E+00, 1.2301054990E+01, 3.2316987382E+00, 9.5768678969E-01],
	[3.7475000000E+04, 2.9810835076E+01, 5.1390788356E+00, 1.2306379590E+01, 3.2321569169E+00, 9.5770557363E-01],
	[3.7480000000E+04, 2.9817696931E+01, 5.1391044118E+00, 1.2311705782E+01, 3.2326149865E+00, 9.5772434812E-01],
	[3.7485000000E+04, 2.9824559450E+01, 5.1391299847E+00, 1.2317033567E+01, 3.2330729473E+00, 9.5774311318E-01],
	[3.7490000000E+04, 2.9831422633E+01, 5.1391555544E+00, 1.2322362944E+01, 3.2335307991E+00, 9.5776186881E-01],
	[3.7495000000E+04, 2.9838286480E+01, 5.1391811207E+00, 1.2327693915E+01, 3.2339885420E+00, 9.5778061501E-01],
	[3.7500000000E+04, 2.9845150990E+01, 5.1392066838E+00, 1.2333026479E+01, 3.2344461760E+00, 9.5779935180E-01],
	[3.7505000000E+04, 2.9852016164E+01, 5.1392322436E+00, 1.2338360637E+01, 3.2349037011E+00, 9.5781807917E-01],
	[3.7510000000E+04, 2.9858882002E+01, 5.1392578001E+00, 1.2343696388E+01, 3.2353611173E+00, 9.5783679713E-01],
	[3.7515000000E+04, 2.9865748503E+01, 5.1392833533E+00, 1.2349033734E+01, 3.2358184247E+00, 9.5785550569E-01],
	[3.7520000000E+04, 2.9872615669E+01, 5.1393089032E+00, 1.2354372674E+01, 3.2362756232E+00, 9.5787420484E-01],
	[3.7525000000E+04, 2.9879483497E+01, 5.1393344499E+00, 1.2359713208E+01, 3.2367327129E+00, 9.5789289461E-01],
	[3.7530000000E+04, 2.9886351989E+01, 5.1393599933E+00, 1.2365055338E+01, 3.2371896938E+00, 9.5791157498E-01],
	[3.7535000000E+04, 2.9893221145E+01, 5.1393855334E+00, 1.2370399062E+01, 3.2376465658E+00, 9.5793024597E-01],
	[3.7540000000E+04, 2.9900090965E+01, 5.1394110703E+00, 1.2375744382E+01, 3.2381033291E+00, 9.5794890759E-01],
	[3.7545000000E+04, 2.9906961447E+01, 5.1394366038E+00, 1.2381091298E+01, 3.2385599835E+00, 9.5796755982E-01],
	[3.7550000000E+04, 2.9913832594E+01, 5.1394621341E+00, 1.2386439810E+01, 3.2390165293E+00, 9.5798620269E-01],
	[3.7555000000E+04, 2.9920704404E+01, 5.1394876612E+00, 1.2391789918E+01, 3.2394729662E+00, 9.5800483620E-01],
	[3.7560000000E+04, 2.9927576877E+01, 5.1395131849E+00, 1.2397141622E+01, 3.2399292944E+00, 9.5802346034E-01],
	[3.7565000000E+04, 2.9934450014E+01, 5.1395387054E+00, 1.2402494923E+01, 3.2403855139E+00, 9.5804207513E-01],
	[3.7570000000E+04, 2.9941323814E+01, 5.1395642226E+00, 1.2407849821E+01, 3.2408416246E+00, 9.5806068058E-01],
	[3.7575000000E+04, 2.9948198277E+01, 5.1395897365E+00, 1.2413206317E+01, 3.2412976267E+00, 9.5807927667E-01],
	[3.7580000000E+04, 2.9955073404E+01, 5.1396152472E+00, 1.2418564410E+01, 3.2417535200E+00, 9.5809786343E-01],
	[3.7585000000E+04, 2.9961949194E+01, 5.1396407546E+00, 1.2423924100E+01, 3.2422093047E+00, 9.5811644086E-01],
	[3.7590000000E+04, 2.9968825647E+01, 5.1396662588E+00, 1.2429285389E+01, 3.2426649807E+00, 9.5813500895E-01],
	[3.7595000000E+04, 2.9975702764E+01, 5.1396917596E+00, 1.2434648276E+01, 3.2431205481E+00, 9.5815356773E-01],
	[3.7600000000E+04, 2.9982580544E+01, 5.1397172572E+00, 1.2440012762E+01, 3.2435760068E+00, 9.5817211718E-01],
	[3.7605000000E+04, 2.9989458987E+01, 5.1397427516E+00, 1.2445378847E+01, 3.2440313569E+00, 9.5819065732E-01],
	[3.7610000000E+04, 2.9996338093E+01, 5.1397682427E+00, 1.2450746530E+01, 3.2444865984E+00, 9.5820918815E-01],
	[3.7615000000E+04, 3.0003217863E+01, 5.1397937305E+00, 1.2456115813E+01, 3.2449417313E+00, 9.5822770967E-01],
	[3.7620000000E+04, 3.0010098295E+01, 5.1398192150E+00, 1.2461486696E+01, 3.2453967556E+00, 9.5824622190E-01],
	[3.7625000000E+04, 3.0016979391E+01, 5.1398446963E+00, 1.2466859179E+01, 3.2458516713E+00, 9.5826472483E-01],
	[3.7630000000E+04, 3.0023861150E+01, 5.1398701744E+00, 1.2472233262E+01, 3.2463064784E+00, 9.5828321848E-01],
	[3.7635000000E+04, 3.0030743572E+01, 5.1398956492E+00, 1.2477608945E+01, 3.2467611770E+00, 9.5830170284E-01],
	[3.7640000000E+04, 3.0037626657E+01, 5.1399211207E+00, 1.2482986229E+01, 3.2472157671E+00, 9.5832017792E-01],
	[3.7645000000E+04, 3.0044510405E+01, 5.1399465889E+00, 1.2488365113E+01, 3.2476702487E+00, 9.5833864372E-01],
	[3.7650000000E+04, 3.0051394816E+01, 5.1399720540E+00, 1.2493745599E+01, 3.2481246217E+00, 9.5835710026E-01],
	[3.7655000000E+04, 3.0058279890E+01, 5.1399975157E+00, 1.2499127687E+01, 3.2485788863E+00, 9.5837554753E-01],
	[3.7660000000E+04, 3.0065165627E+01, 5.1400229742E+00, 1.2504511376E+01, 3.2490330423E+00, 9.5839398555E-01],
	[3.7665000000E+04, 3.0072052027E+01, 5.1400484295E+00, 1.2509896667E+01, 3.2494870899E+00, 9.5841241431E-01],
	[3.7670000000E+04, 3.0078939090E+01, 5.1400738814E+00, 1.2515283561E+01, 3.2499410291E+00, 9.5843083382E-01],
	[3.7675000000E+04, 3.0085826815E+01, 5.1400993302E+00, 1.2520672057E+01, 3.2503948598E+00, 9.5844924408E-01],
	[3.7680000000E+04, 3.0092715204E+01, 5.1401247757E+00, 1.2526062156E+01, 3.2508485821E+00, 9.5846764511E-01],
	[3.7685000000E+04, 3.0099604255E+01, 5.1401502179E+00, 1.2531453858E+01, 3.2513021959E+00, 9.5848603690E-01],
	[3.7690000000E+04, 3.0106493969E+01, 5.1401756569E+00, 1.2536847163E+01, 3.2517557014E+00, 9.5850441947E-01],
	[3.7695000000E+04, 3.0113384346E+01, 5.1402010926E+00, 1.2542242072E+01, 3.2522090985E+00, 9.5852279281E-01],
	[3.7700000000E+04, 3.0120275386E+01, 5.1402265251E+00, 1.2547638585E+01, 3.2526623872E+00, 9.5854115693E-01],
	[3.7705000000E+04, 3.0127167089E+01, 5.1402519544E+00, 1.2553036701E+01, 3.2531155675E+00, 9.5855951183E-01],
	[3.7710000000E+04, 3.0134059454E+01, 5.1402773804E+00, 1.2558436423E+01, 3.2535686395E+00, 9.5857785753E-01],
	[3.7715000000E+04, 3.0140952482E+01, 5.1403028031E+00, 1.2563837748E+01, 3.2540216032E+00, 9.5859619402E-01],
	[3.7720000000E+04, 3.0147846172E+01, 5.1403282226E+00, 1.2569240679E+01, 3.2544744585E+00, 9.5861452131E-01],
	[3.7725000000E+04, 3.0154740525E+01, 5.1403536389E+00, 1.2574645215E+01, 3.2549272055E+00, 9.5863283941E-01],
	[3.7730000000E+04, 3.0161635541E+01, 5.1403790519E+00, 1.2580051356E+01, 3.2553798443E+00, 9.5865114832E-01],
	[3.7735000000E+04, 3.0168531219E+01, 5.1404044617E+00, 1.2585459103E+01, 3.2558323747E+00, 9.5866944804E-01],
	[3.7740000000E+04, 3.0175427560E+01, 5.1404298682E+00, 1.2590868456E+01, 3.2562847969E+00, 9.5868773858E-01],
	[3.7745000000E+04, 3.0182324564E+01, 5.1404552715E+00, 1.2596279415E+01, 3.2567371109E+00, 9.5870601995E-01],
	[3.7750000000E+04, 3.0189222230E+01, 5.1404806716E+00, 1.2601691981E+01, 3.2571893166E+00, 9.5872429215E-01],
	[3.7755000000E+04, 3.0196120558E+01, 5.1405060684E+00, 1.2607106153E+01, 3.2576414141E+00, 9.5874255519E-01],
	[3.7760000000E+04, 3.0203019549E+01, 5.1405314620E+00, 1.2612521933E+01, 3.2580934033E+00, 9.5876080906E-01],
	[3.7765000000E+04, 3.0209919203E+01, 5.1405568523E+00, 1.2617939319E+01, 3.2585452844E+00, 9.5877905378E-01],
	[3.7770000000E+04, 3.0216819519E+01, 5.1405822395E+00, 1.2623358314E+01, 3.2589970573E+00, 9.5879728935E-01],
	[3.7775000000E+04, 3.0223720497E+01, 5.1406076233E+00, 1.2628778916E+01, 3.2594487220E+00, 9.5881551578E-01],
	[3.7780000000E+04, 3.0230622137E+01, 5.1406330040E+00, 1.2634201126E+01, 3.2599002785E+00, 9.5883373307E-01],
	[3.7785000000E+04, 3.0237524440E+01, 5.1406583814E+00, 1.2639624944E+01, 3.2603517270E+00, 9.5885194122E-01],
	[3.7790000000E+04, 3.0244427406E+01, 5.1406837556E+00, 1.2645050371E+01, 3.2608030672E+00, 9.5887014024E-01],
	[3.7795000000E+04, 3.0251331033E+01, 5.1407091265E+00, 1.2650477407E+01, 3.2612542994E+00, 9.5888833013E-01],
	[3.7800000000E+04, 3.0258235323E+01, 5.1407344942E+00, 1.2655906052E+01, 3.2617054235E+00, 9.5890651091E-01],
	[3.7805000000E+04, 3.0265140275E+01, 5.1407598587E+00, 1.2661336306E+01, 3.2621564395E+00, 9.5892468257E-01],
	[3.7810000000E+04, 3.0272045890E+01, 5.1407852199E+00, 1.2666768170E+01, 3.2626073474E+00, 9.5894284512E-01],
	[3.7815000000E+04, 3.0278952166E+01, 5.1408105780E+00, 1.2672201644E+01, 3.2630581472E+00, 9.5896099856E-01],
	[3.7820000000E+04, 3.0285859105E+01, 5.1408359328E+00, 1.2677636728E+01, 3.2635088390E+00, 9.5897914291E-01],
	[3.7825000000E+04, 3.0292766706E+01, 5.1408612843E+00, 1.2683073422E+01, 3.2639594228E+00, 9.5899727816E-01],
	[3.7830000000E+04, 3.0299674969E+01, 5.1408866327E+00, 1.2688511727E+01, 3.2644098985E+00, 9.5901540431E-01],
	[3.7835000000E+04, 3.0306583894E+01, 5.1409119778E+00, 1.2693951643E+01, 3.2648602662E+00, 9.5903352139E-01],
	[3.7840000000E+04, 3.0313493481E+01, 5.1409373197E+00, 1.2699393171E+01, 3.2653105260E+00, 9.5905162938E-01],
	[3.7845000000E+04, 3.0320403731E+01, 5.1409626584E+00, 1.2704836310E+01, 3.2657606777E+00, 9.5906972830E-01],
	[3.7850000000E+04, 3.0327314642E+01, 5.1409879938E+00, 1.2710281060E+01, 3.2662107215E+00, 9.5908781814E-01],
	[3.7855000000E+04, 3.0334226215E+01, 5.1410133260E+00, 1.2715727423E+01, 3.2666606574E+00, 9.5910589892E-01],
	[3.7860000000E+04, 3.0341138451E+01, 5.1410386550E+00, 1.2721175398E+01, 3.2671104853E+00, 9.5912397064E-01],
	[3.7865000000E+04, 3.0348051348E+01, 5.1410639808E+00, 1.2726624985E+01, 3.2675602053E+00, 9.5914203330E-01],
	[3.7870000000E+04, 3.0354964907E+01, 5.1410893034E+00, 1.2732076185E+01, 3.2680098174E+00, 9.5916008691E-01],
	[3.7875000000E+04, 3.0361879128E+01, 5.1411146227E+00, 1.2737528998E+01, 3.2684593216E+00, 9.5917813148E-01],
	[3.7880000000E+04, 3.0368794011E+01, 5.1411399389E+00, 1.2742983425E+01, 3.2689087179E+00, 9.5919616700E-01],
	[3.7885000000E+04, 3.0375709556E+01, 5.1411652518E+00, 1.2748439465E+01, 3.2693580063E+00, 9.5921419349E-01],
	[3.7890000000E+04, 3.0382625763E+01, 5.1411905615E+00, 1.2753897119E+01, 3.2698071869E+00, 9.5923221095E-01],
	[3.7895000000E+04, 3.0389542632E+01, 5.1412158680E+00, 1.2759356387E+01, 3.2702562597E+00, 9.5925021938E-01],
	[3.7900000000E+04, 3.0396460162E+01, 5.1412411712E+00, 1.2764817270E+01, 3.2707052246E+00, 9.5926821878E-01],
	[3.7905000000E+04, 3.0403378354E+01, 5.1412664713E+00, 1.2770279767E+01, 3.2711540817E+00, 9.5928620918E-01],
	[3.7910000000E+04, 3.0410297208E+01, 5.1412917681E+00, 1.2775743879E+01, 3.2716028310E+00, 9.5930419055E-01],
	[3.7915000000E+04, 3.0417216724E+01, 5.1413170618E+00, 1.2781209606E+01, 3.2720514726E+00, 9.5932216293E-01],
	[3.7920000000E+04, 3.0424136901E+01, 5.1413423522E+00, 1.2786676949E+01, 3.2725000063E+00, 9.5934012630E-01],
	[3.7925000000E+04, 3.0431057740E+01, 5.1413676394E+00, 1.2792145907E+01, 3.2729484324E+00, 9.5935808067E-01],
	[3.7930000000E+04, 3.0437979241E+01, 5.1413929234E+00, 1.2797616482E+01, 3.2733967506E+00, 9.5937602605E-01],
	[3.7935000000E+04, 3.0444901403E+01, 5.1414182042E+00, 1.2803088672E+01, 3.2738449612E+00, 9.5939396245E-01],
	[3.7940000000E+04, 3.0451824227E+01, 5.1414434818E+00, 1.2808562479E+01, 3.2742930640E+00, 9.5941188986E-01],
	[3.7945000000E+04, 3.0458747713E+01, 5.1414687562E+00, 1.2814037903E+01, 3.2747410592E+00, 9.5942980830E-01],
	[3.7950000000E+04, 3.0465671860E+01, 5.1414940273E+00, 1.2819514944E+01, 3.2751889466E+00, 9.5944771776E-01],
	[3.7955000000E+04, 3.0472596668E+01, 5.1415192953E+00, 1.2824993602E+01, 3.2756367264E+00, 9.5946561825E-01],
	[3.7960000000E+04, 3.0479522138E+01, 5.1415445601E+00, 1.2830473878E+01, 3.2760843985E+00, 9.5948350978E-01],
	[3.7965000000E+04, 3.0486448270E+01, 5.1415698216E+00, 1.2835955771E+01, 3.2765319630E+00, 9.5950139236E-01],
	[3.7970000000E+04, 3.0493375063E+01, 5.1415950800E+00, 1.2841439283E+01, 3.2769794199E+00, 9.5951926598E-01],
	[3.7975000000E+04, 3.0500302517E+01, 5.1416203351E+00, 1.2846924413E+01, 3.2774267691E+00, 9.5953713065E-01],
	[3.7980000000E+04, 3.0507230633E+01, 5.1416455871E+00, 1.2852411161E+01, 3.2778740108E+00, 9.5955498638E-01],
	[3.7985000000E+04, 3.0514159411E+01, 5.1416708358E+00, 1.2857899529E+01, 3.2783211449E+00, 9.5957283317E-01],
	[3.7990000000E+04, 3.0521088849E+01, 5.1416960814E+00, 1.2863389515E+01, 3.2787681714E+00, 9.5959067103E-01],
	[3.7995000000E+04, 3.0528018949E+01, 5.1417213237E+00, 1.2868881121E+01, 3.2792150903E+00, 9.5960849996E-01],
	[3.8000000000E+04, 3.0534949710E+01, 5.1417465629E+00, 1.2874374347E+01, 3.2796619017E+00, 9.5962631997E-01],
	[3.8005000000E+04, 3.0541887172E+01, 5.1417726026E+00, 1.2879869192E+01, 3.2801090023E+00, 9.5964413106E-01],
	[3.8010000000E+04, 3.0548836817E+01, 5.1418001720E+00, 1.2885365658E+01, 3.2805567524E+00, 9.5966193323E-01],
	[3.8015000000E+04, 3.0555787129E+01, 5.1418277379E+00, 1.2890863744E+01, 3.2810043954E+00, 9.5967972649E-01],
	[3.8020000000E+04, 3.0562738108E+01, 5.1418553003E+00, 1.2896363451E+01, 3.2814519313E+00, 9.5969751086E-01],
	[3.8025000000E+04, 3.0569689754E+01, 5.1418828592E+00, 1.2901864778E+01, 3.2818993601E+00, 9.5971528632E-01],
	[3.8030000000E+04, 3.0576642066E+01, 5.1419104147E+00, 1.2907367727E+01, 3.2823466818E+00, 9.5973305288E-01],
	[3.8035000000E+04, 3.0583595046E+01, 5.1419379667E+00, 1.2912872298E+01, 3.2827938964E+00, 9.5975081056E-01],
	[3.8040000000E+04, 3.0590548692E+01, 5.1419655152E+00, 1.2918378490E+01, 3.2832410040E+00, 9.5976855935E-01],
	[3.8045000000E+04, 3.0597503005E+01, 5.1419930602E+00, 1.2923886305E+01, 3.2836880045E+00, 9.5978629927E-01],
	[3.8050000000E+04, 3.0604457985E+01, 5.1420206018E+00, 1.2929395741E+01, 3.2841348980E+00, 9.5980403031E-01],
	[3.8055000000E+04, 3.0611413631E+01, 5.1420481399E+00, 1.2934906800E+01, 3.2845816845E+00, 9.5982175247E-01],
	[3.8060000000E+04, 3.0618369944E+01, 5.1420756745E+00, 1.2940419482E+01, 3.2850283640E+00, 9.5983946578E-01],
	[3.8065000000E+04, 3.0625326924E+01, 5.1421032056E+00, 1.2945933787E+01, 3.2854749366E+00, 9.5985717022E-01],
	[3.8070000000E+04, 3.0632284570E+01, 5.1421307333E+00, 1.2951449716E+01, 3.2859214021E+00, 9.5987486581E-01],
	[3.8075000000E+04, 3.0639242884E+01, 5.1421582575E+00, 1.2956967268E+01, 3.2863677607E+00, 9.5989255255E-01],
	[3.8080000000E+04, 3.0646201863E+01, 5.1421857783E+00, 1.2962486444E+01, 3.2868140124E+00, 9.5991023044E-01],
	[3.8085000000E+04, 3.0653161509E+01, 5.1422132956E+00, 1.2968007244E+01, 3.2872601572E+00, 9.5992789949E-01],
	[3.8090000000E+04, 3.0660121822E+01, 5.1422408094E+00, 1.2973529668E+01, 3.2877061950E+00, 9.5994555970E-01],
	[3.8095000000E+04, 3.0667082802E+01, 5.1422683197E+00, 1.2979053717E+01, 3.2881521259E+00, 9.5996321108E-01],
	[3.8100000000E+04, 3.0674044448E+01, 5.1422958266E+00, 1.2984579392E+01, 3.2885979500E+00, 9.5998085364E-01],
	[3.8105000000E+04, 3.0681006760E+01, 5.1423233300E+00, 1.2990106691E+01, 3.2890436672E+00, 9.5999848738E-01],
	[3.8110000000E+04, 3.0687969739E+01, 5.1423508300E+00, 1.2995635615E+01, 3.2894892776E+00, 9.6001611230E-01],
	[3.8115000000E+04, 3.0694933384E+01, 5.1423783265E+00, 1.3001166166E+01, 3.2899347811E+00, 9.6003372840E-01],
	[3.8120000000E+04, 3.0701897696E+01, 5.1424058195E+00, 1.3006698342E+01, 3.2903801778E+00, 9.6005133570E-01],
	[3.8125000000E+04, 3.0708862674E+01, 5.1424333091E+00, 1.3012232145E+01, 3.2908254676E+00, 9.6006893420E-01],
	[3.8130000000E+04, 3.0715828319E+01, 5.1424607952E+00, 1.3017767574E+01, 3.2912706507E+00, 9.6008652390E-01],
	[3.8135000000E+04, 3.0722794629E+01, 5.1424882779E+00, 1.3023304630E+01, 3.2917157270E+00, 9.6010410481E-01],
	[3.8140000000E+04, 3.0729761606E+01, 5.1425157571E+00, 1.3028843313E+01, 3.2921606966E+00, 9.6012167694E-01],
	[3.8145000000E+04, 3.0736729250E+01, 5.1425432329E+00, 1.3034383623E+01, 3.2926055594E+00, 9.6013924027E-01],
	[3.8150000000E+04, 3.0743697560E+01, 5.1425707052E+00, 1.3039925561E+01, 3.2930503154E+00, 9.6015679483E-01],
	[3.8155000000E+04, 3.0750666536E+01, 5.1425981740E+00, 1.3045469127E+01, 3.2934949648E+00, 9.6017434062E-01],
	[3.8160000000E+04, 3.0757636178E+01, 5.1426256394E+00, 1.3051014321E+01, 3.2939395074E+00, 9.6019187764E-01],
	[3.8165000000E+04, 3.0764606486E+01, 5.1426531014E+00, 1.3056561143E+01, 3.2943839433E+00, 9.6020940590E-01],
	[3.8170000000E+04, 3.0771577461E+01, 5.1426805599E+00, 1.3062109594E+01, 3.2948282726E+00, 9.6022692540E-01],
	[3.8175000000E+04, 3.0778549102E+01, 5.1427080149E+00, 1.3067659674E+01, 3.2952724952E+00, 9.6024443614E-01],
	[3.8180000000E+04, 3.0785521409E+01, 5.1427354665E+00, 1.3073211382E+01, 3.2957166111E+00, 9.6026193814E-01],
	[3.8185000000E+04, 3.0792494382E+01, 5.1427629147E+00, 1.3078764721E+01, 3.2961606204E+00, 9.6027943139E-01],
	[3.8190000000E+04, 3.0799468021E+01, 5.1427903594E+00, 1.3084319689E+01, 3.2966045231E+00, 9.6029691590E-01],
	[3.8195000000E+04, 3.0806442326E+01, 5.1428178006E+00, 1.3089876286E+01, 3.2970483192E+00, 9.6031439168E-01],
	[3.8200000000E+04, 3.0813417297E+01, 5.1428452384E+00, 1.3095434515E+01, 3.2974920087E+00, 9.6033185873E-01],
	[3.8205000000E+04, 3.0820392934E+01, 5.1428726728E+00, 1.3100994373E+01, 3.2979355916E+00, 9.6034931705E-01],
	[3.8210000000E+04, 3.0827369238E+01, 5.1429001037E+00, 1.3106555862E+01, 3.2983790680E+00, 9.6036676665E-01],
	[3.8215000000E+04, 3.0834346207E+01, 5.1429275312E+00, 1.3112118983E+01, 3.2988224378E+00, 9.6038420754E-01],
	[3.8220000000E+04, 3.0841323842E+01, 5.1429549552E+00, 1.3117683734E+01, 3.2992657011E+00, 9.6040163972E-01],
	[3.8225000000E+04, 3.0848302143E+01, 5.1429823758E+00, 1.3123250117E+01, 3.2997088578E+00, 9.6041906319E-01],
	[3.8230000000E+04, 3.0855281110E+01, 5.1430097929E+00, 1.3128818132E+01, 3.3001519081E+00, 9.6043647796E-01],
	[3.8235000000E+04, 3.0862260743E+01, 5.1430372067E+00, 1.3134387779E+01, 3.3005948519E+00, 9.6045388404E-01],
	[3.8240000000E+04, 3.0869241042E+01, 5.1430646169E+00, 1.3139959059E+01, 3.3010376892E+00, 9.6047128142E-01],
	[3.8245000000E+04, 3.0876222006E+01, 5.1430920238E+00, 1.3145531971E+01, 3.3014804200E+00, 9.6048867012E-01],
	[3.8250000000E+04, 3.0883203636E+01, 5.1431194272E+00, 1.3151106515E+01, 3.3019230444E+00, 9.6050605014E-01],
	[3.8255000000E+04, 3.0890185932E+01, 5.1431468271E+00, 1.3156682693E+01, 3.3023655624E+00, 9.6052342148E-01],
	[3.8260000000E+04, 3.0897168894E+01, 5.1431742236E+00, 1.3162260504E+01, 3.3028079740E+00, 9.6054078415E-01],
	[3.8265000000E+04, 3.0904152522E+01, 5.1432016167E+00, 1.3167839949E+01, 3.3032502791E+00, 9.6055813815E-01],
	[3.8270000000E+04, 3.0911136815E+01, 5.1432290064E+00, 1.3173421028E+01, 3.3036924779E+00, 9.6057548349E-01],
	[3.8275000000E+04, 3.0918121774E+01, 5.1432563926E+00, 1.3179003741E+01, 3.3041345703E+00, 9.6059282017E-01],
	[3.8280000000E+04, 3.0925107399E+01, 5.1432837754E+00, 1.3184588088E+01, 3.3045765564E+00, 9.6061014820E-01],
	[3.8285000000E+04, 3.0932093689E+01, 5.1433111548E+00, 1.3190174070E+01, 3.3050184361E+00, 9.6062746758E-01],
	[3.8290000000E+04, 3.0939080645E+01, 5.1433385307E+00, 1.3195761687E+01, 3.3054602095E+00, 9.6064477832E-01],
	[3.8295000000E+04, 3.0946068267E+01, 5.1433659032E+00, 1.3201350940E+01, 3.3059018766E+00, 9.6066208042E-01],
	[3.8300000000E+04, 3.0953056554E+01, 5.1433932723E+00, 1.3206941827E+01, 3.3063434374E+00, 9.6067937388E-01],
	[3.8305000000E+04, 3.0960045506E+01, 5.1434206380E+00, 1.3212534351E+01, 3.3067848919E+00, 9.6069665872E-01],
	[3.8310000000E+04, 3.0967035125E+01, 5.1434480002E+00, 1.3218128511E+01, 3.3072262401E+00, 9.6071393493E-01],
	[3.8315000000E+04, 3.0974025408E+01, 5.1434753590E+00, 1.3223724306E+01, 3.3076674821E+00, 9.6073120253E-01],
	[3.8320000000E+04, 3.0981016357E+01, 5.1435027144E+00, 1.3229321739E+01, 3.3081086179E+00, 9.6074846151E-01],
	[3.8325000000E+04, 3.0988007972E+01, 5.1435300663E+00, 1.3234920808E+01, 3.3085496474E+00, 9.6076571188E-01],
	[3.8330000000E+04, 3.0995000252E+01, 5.1435574148E+00, 1.3240521514E+01, 3.3089905708E+00, 9.6078295364E-01],
	[3.8335000000E+04, 3.1001993197E+01, 5.1435847600E+00, 1.3246123858E+01, 3.3094313879E+00, 9.6080018680E-01],
	[3.8340000000E+04, 3.1008986808E+01, 5.1436121016E+00, 1.3251727839E+01, 3.3098720989E+00, 9.6081741137E-01],
	[3.8345000000E+04, 3.1015981084E+01, 5.1436394399E+00, 1.3257333458E+01, 3.3103127037E+00, 9.6083462735E-01],
	[3.8350000000E+04, 3.1022976026E+01, 5.1436667748E+00, 1.3262940715E+01, 3.3107532024E+00, 9.6085183475E-01],
	[3.8355000000E+04, 3.1029971633E+01, 5.1436941062E+00, 1.3268549611E+01, 3.3111935949E+00, 9.6086903356E-01],
	[3.8360000000E+04, 3.1036967905E+01, 5.1437214342E+00, 1.3274160145E+01, 3.3116338813E+00, 9.6088622379E-01],
	[3.8365000000E+04, 3.1043964842E+01, 5.1437487588E+00, 1.3279772318E+01, 3.3120740616E+00, 9.6090340546E-01],
	[3.8370000000E+04, 3.1050962445E+01, 5.1437760800E+00, 1.3285386131E+01, 3.3125141359E+00, 9.6092057856E-01],
	[3.8375000000E+04, 3.1057960713E+01, 5.1438033977E+00, 1.3291001583E+01, 3.3129541040E+00, 9.6093774309E-01],
	[3.8380000000E+04, 3.1064959646E+01, 5.1438307121E+00, 1.3296618674E+01, 3.3133939661E+00, 9.6095489907E-01],
	[3.8385000000E+04, 3.1071959244E+01, 5.1438580230E+00, 1.3302237406E+01, 3.3138337222E+00, 9.6097204649E-01],
	[3.8390000000E+04, 3.1078959507E+01, 5.1438853305E+00, 1.3307857778E+01, 3.3142733723E+00, 9.6098918537E-01],
	[3.8395000000E+04, 3.1085960436E+01, 5.1439126346E+00, 1.3313479790E+01, 3.3147129163E+00, 9.6100631571E-01],
	[3.8400000000E+04, 3.1092962029E+01, 5.1439399354E+00, 1.3319103443E+01, 3.3151523544E+00, 9.6102343750E-01],
	[3.8405000000E+04, 3.1099964288E+01, 5.1439672326E+00, 1.3324728737E+01, 3.3155916864E+00, 9.6104055077E-01],
	[3.8410000000E+04, 3.1106967212E+01, 5.1439945265E+00, 1.3330355673E+01, 3.3160309125E+00, 9.6105765550E-01],
	[3.8415000000E+04, 3.1113970800E+01, 5.1440218170E+00, 1.3335984250E+01, 3.3164700327E+00, 9.6107475171E-01],
	[3.8420000000E+04, 3.1120975054E+01, 5.1440491041E+00, 1.3341614469E+01, 3.3169090469E+00, 9.6109183940E-01],
	[3.8425000000E+04, 3.1127979973E+01, 5.1440763877E+00, 1.3347246330E+01, 3.3173479552E+00, 9.6110891858E-01],
	[3.8430000000E+04, 3.1134985556E+01, 5.1441036680E+00, 1.3352879833E+01, 3.3177867576E+00, 9.6112598925E-01],
	[3.8435000000E+04, 3.1141991805E+01, 5.1441309448E+00, 1.3358514979E+01, 3.3182254541E+00, 9.6114305141E-01],
	[3.8440000000E+04, 3.1148998719E+01, 5.1441582183E+00, 1.3364151768E+01, 3.3186640448E+00, 9.6116010507E-01],
	[3.8445000000E+04, 3.1156006297E+01, 5.1441854883E+00, 1.3369790200E+01, 3.3191025295E+00, 9.6117715024E-01],
	[3.8450000000E+04, 3.1163014540E+01, 5.1442127550E+00, 1.3375430275E+01, 3.3195409085E+00, 9.6119418691E-01],
	[3.8455000000E+04, 3.1170023448E+01, 5.1442400182E+00, 1.3381071994E+01, 3.3199791816E+00, 9.6121121510E-01],
	[3.8460000000E+04, 3.1177033021E+01, 5.1442672781E+00, 1.3386715357E+01, 3.3204173489E+00, 9.6122823481E-01],
	[3.8465000000E+04, 3.1184043259E+01, 5.1442945345E+00, 1.3392360365E+01, 3.3208554104E+00, 9.6124524604E-01],
	[3.8470000000E+04, 3.1191054162E+01, 5.1443217876E+00, 1.3398007016E+01, 3.3212933661E+00, 9.6126224880E-01],
	[3.8475000000E+04, 3.1198065729E+01, 5.1443490372E+00, 1.3403655313E+01, 3.3217312161E+00, 9.6127924309E-01],
	[3.8480000000E+04, 3.1205077961E+01, 5.1443762835E+00, 1.3409305254E+01, 3.3221689603E+00, 9.6129622892E-01],
	[3.8485000000E+04, 3.1212090858E+01, 5.1444035263E+00, 1.3414956841E+01, 3.3226065988E+00, 9.6131320629E-01],
	[3.8490000000E+04, 3.1219104419E+01, 5.1444307658E+00, 1.3420610073E+01, 3.3230441315E+00, 9.6133017521E-01],
	[3.8495000000E+04, 3.1226118645E+01, 5.1444580018E+00, 1.3426264952E+01, 3.3234815586E+00, 9.6134713568E-01],
	[3.8500000000E+04, 3.1233133536E+01, 5.1444852345E+00, 1.3431921476E+01, 3.3239188800E+00, 9.6136408770E-01],
	[3.8505000000E+04, 3.1240149091E+01, 5.1445124638E+00, 1.3437579646E+01, 3.3243560956E+00, 9.6138103129E-01],
	[3.8510000000E+04, 3.1247165311E+01, 5.1445396897E+00, 1.3443239463E+01, 3.3247932057E+00, 9.6139796645E-01],
	[3.8515000000E+04, 3.1254182195E+01, 5.1445669122E+00, 1.3448900927E+01, 3.3252302101E+00, 9.6141489317E-01],
	[3.8520000000E+04, 3.1261199744E+01, 5.1445941313E+00, 1.3454564038E+01, 3.3256671088E+00, 9.6143181147E-01],
	[3.8525000000E+04, 3.1268217958E+01, 5.1446213470E+00, 1.3460228797E+01, 3.3261039020E+00, 9.6144872135E-01],
	[3.8530000000E+04, 3.1275236836E+01, 5.1446485593E+00, 1.3465895203E+01, 3.3265405895E+00, 9.6146562281E-01],
	[3.8535000000E+04, 3.1282256378E+01, 5.1446757683E+00, 1.3471563257E+01, 3.3269771715E+00, 9.6148251587E-01],
	[3.8540000000E+04, 3.1289276585E+01, 5.1447029738E+00, 1.3477232959E+01, 3.3274136479E+00, 9.6149940055E-01],
	[3.8545000000E+04, 3.1296297457E+01, 5.1447301760E+00, 1.3482904310E+01, 3.3278500188E+00, 9.6151627688E-01],
	[3.8550000000E+04, 3.1303318992E+01, 5.1447573748E+00, 1.3488577309E+01, 3.3282862841E+00, 9.6153314486E-01],
	[3.8555000000E+04, 3.1310341192E+01, 5.1447845702E+00, 1.3494251958E+01, 3.3287224439E+00, 9.6155000450E-01],
	[3.8560000000E+04, 3.1317364057E+01, 5.1448117622E+00, 1.3499928255E+01, 3.3291584982E+00, 9.6156685579E-01],
	[3.8565000000E+04, 3.1324387586E+01, 5.1448389509E+00, 1.3505606202E+01, 3.3295944471E+00, 9.6158369875E-01],
	[3.8570000000E+04, 3.1331411779E+01, 5.1448661361E+00, 1.3511285799E+01, 3.3300302904E+00, 9.6160053337E-01],
	[3.8575000000E+04, 3.1338436636E+01, 5.1448933180E+00, 1.3516967046E+01, 3.3304660283E+00, 9.6161735967E-01],
	[3.8580000000E+04, 3.1345462158E+01, 5.1449204965E+00, 1.3522649943E+01, 3.3309016608E+00, 9.6163417763E-01],
	[3.8585000000E+04, 3.1352488344E+01, 5.1449476716E+00, 1.3528334491E+01, 3.3313371878E+00, 9.6165098728E-01],
	[3.8590000000E+04, 3.1359515194E+01, 5.1449748434E+00, 1.3534020690E+01, 3.3317726094E+00, 9.6166778861E-01],
	[3.8595000000E+04, 3.1366542708E+01, 5.1450020117E+00, 1.3539708540E+01, 3.3322079256E+00, 9.6168458163E-01],
	[3.8600000000E+04, 3.1373570886E+01, 5.1450291767E+00, 1.3545398041E+01, 3.3326431365E+00, 9.6170136634E-01],
	[3.8605000000E+04, 3.1380599729E+01, 5.1450563383E+00, 1.3551089193E+01, 3.3330782419E+00, 9.6171814274E-01],
	[3.8610000000E+04, 3.1387629236E+01, 5.1450834966E+00, 1.3556781998E+01, 3.3335132421E+00, 9.6173491084E-01],
	[3.8615000000E+04, 3.1394659406E+01, 5.1451106515E+00, 1.3562476455E+01, 3.3339481369E+00, 9.6175167064E-01],
	[3.8620000000E+04, 3.1401707250E+01, 5.1451400520E+00, 1.3568172564E+01, 3.3343840627E+00, 9.6176842215E-01],
	[3.8625000000E+04, 3.1408756044E+01, 5.1451694861E+00, 1.3573870326E+01, 3.3348199024E+00, 9.6178516537E-01],
	[3.8630000000E+04, 3.1415805508E+01, 5.1451989165E+00, 1.3579569740E+01, 3.3352556371E+00, 9.6180190031E-01],
	[3.8635000000E+04, 3.1422855641E+01, 5.1452283433E+00, 1.3585270808E+01, 3.3356912670E+00, 9.6181862696E-01],
	[3.8640000000E+04, 3.1429906443E+01, 5.1452577665E+00, 1.3590973530E+01, 3.3361267919E+00, 9.6183534533E-01],
	[3.8645000000E+04, 3.1436957915E+01, 5.1452871860E+00, 1.3596677905E+01, 3.3365622119E+00, 9.6185205543E-01],
	[3.8650000000E+04, 3.1444010057E+01, 5.1453166019E+00, 1.3602383934E+01, 3.3369975271E+00, 9.6186875727E-01],
	[3.8655000000E+04, 3.1451062868E+01, 5.1453460141E+00, 1.3608091618E+01, 3.3374327375E+00, 9.6188545083E-01],
	[3.8660000000E+04, 3.1458116348E+01, 5.1453754227E+00, 1.3613800956E+01, 3.3378678430E+00, 9.6190213614E-01],
	[3.8665000000E+04, 3.1465170498E+01, 5.1454048277E+00, 1.3619511948E+01, 3.3383028436E+00, 9.6191881318E-01],
	[3.8670000000E+04, 3.1472225317E+01, 5.1454342290E+00, 1.3625224596E+01, 3.3387377395E+00, 9.6193548198E-01],
	[3.8675000000E+04, 3.1479280805E+01, 5.1454636267E+00, 1.3630938899E+01, 3.3391725306E+00, 9.6195214252E-01],
	[3.8680000000E+04, 3.1486336963E+01, 5.1454930208E+00, 1.3636654858E+01, 3.3396072169E+00, 9.6196879482E-01],
	[3.8685000000E+04, 3.1493393790E+01, 5.1455224112E+00, 1.3642372473E+01, 3.3400417984E+00, 9.6198543887E-01],
	[3.8690000000E+04, 3.1500451286E+01, 5.1455517980E+00, 1.3648091744E+01, 3.3404762752E+00, 9.6200207469E-01],
	[3.8695000000E+04, 3.1507509452E+01, 5.1455811812E+00, 1.3653812671E+01, 3.3409106473E+00, 9.6201870227E-01],
	[3.8700000000E+04, 3.1514568287E+01, 5.1456105607E+00, 1.3659535254E+01, 3.3413449147E+00, 9.6203532163E-01],
	[3.8705000000E+04, 3.1521627790E+01, 5.1456399366E+00, 1.3665259495E+01, 3.3417790774E+00, 9.6205193276E-01],
	[3.8710000000E+04, 3.1528687964E+01, 5.1456693089E+00, 1.3670985393E+01, 3.3422131354E+00, 9.6206853566E-01],
	[3.8715000000E+04, 3.1535748806E+01, 5.1456986776E+00, 1.3676712948E+01, 3.3426470887E+00, 9.6208513035E-01],
	[3.8720000000E+04, 3.1542810317E+01, 5.1457280426E+00, 1.3682442161E+01, 3.3430809374E+00, 9.6210171682E-01],
	[3.8725000000E+04, 3.1549872498E+01, 5.1457574040E+00, 1.3688173033E+01, 3.3435146814E+00, 9.6211829509E-01],
	[3.8730000000E+04, 3.1556935347E+01, 5.1457867618E+00, 1.3693905562E+01, 3.3439483209E+00, 9.6213486515E-01],
	[3.8735000000E+04, 3.1563998866E+01, 5.1458161160E+00, 1.3699639750E+01, 3.3443818557E+00, 9.6215142700E-01],
	[3.8740000000E+04, 3.1571063053E+01, 5.1458454665E+00, 1.3705375596E+01, 3.3448152860E+00, 9.6216798066E-01],
	[3.8745000000E+04, 3.1578127910E+01, 5.1458748135E+00, 1.3711113102E+01, 3.3452486117E+00, 9.6218452612E-01],
	[3.8750000000E+04, 3.1585193436E+01, 5.1459041568E+00, 1.3716852267E+01, 3.3456818328E+00, 9.6220106340E-01],
	[3.8755000000E+04, 3.1592259630E+01, 5.1459334965E+00, 1.3722593091E+01, 3.3461149494E+00, 9.6221759249E-01],
	[3.8760000000E+04, 3.1599326494E+01, 5.1459628325E+00, 1.3728335575E+01, 3.3465479614E+00, 9.6223411339E-01],
	[3.8765000000E+04, 3.1606394026E+01, 5.1459921650E+00, 1.3734079720E+01, 3.3469808690E+00, 9.6225062612E-01],
	[3.8770000000E+04, 3.1613462228E+01, 5.1460214938E+00, 1.3739825524E+01, 3.3474136721E+00, 9.6226713067E-01],
	[3.8775000000E+04, 3.1620531098E+01, 5.1460508190E+00, 1.3745572990E+01, 3.3478463707E+00, 9.6228362705E-01],
	[3.8780000000E+04, 3.1627600637E+01, 5.1460801406E+00, 1.3751322116E+01, 3.3482789648E+00, 9.6230011527E-01],
	[3.8785000000E+04, 3.1634670845E+01, 5.1461094586E+00, 1.3757072903E+01, 3.3487114545E+00, 9.6231659532E-01],
	[3.8790000000E+04, 3.1641741722E+01, 5.1461387730E+00, 1.3762825352E+01, 3.3491438398E+00, 9.6233306722E-01],
	[3.8795000000E+04, 3.1648813267E+01, 5.1461680838E+00, 1.3768579463E+01, 3.3495761207E+00, 9.6234953096E-01],
	[3.8800000000E+04, 3.1655885481E+01, 5.1461973910E+00, 1.3774335235E+01, 3.3500082971E+00, 9.6236598655E-01],
	[3.8805000000E+04, 3.1662958364E+01, 5.1462266945E+00, 1.3780092670E+01, 3.3504403692E+00, 9.6238243400E-01],
	[3.8810000000E+04, 3.1670031916E+01, 5.1462559944E+00, 1.3785851767E+01, 3.3508723370E+00, 9.6239887330E-01],
	[3.8815000000E+04, 3.1677106137E+01, 5.1462852908E+00, 1.3791612527E+01, 3.3513042003E+00, 9.6241530447E-01],
	[3.8820000000E+04, 3.1684181026E+01, 5.1463145835E+00, 1.3797374950E+01, 3.3517359594E+00, 9.6243172750E-01],
	[3.8825000000E+04, 3.1691256583E+01, 5.1463438726E+00, 1.3803139036E+01, 3.3521676141E+00, 9.6244814239E-01],
	[3.8830000000E+04, 3.1698332810E+01, 5.1463731581E+00, 1.3808904786E+01, 3.3525991645E+00, 9.6246454917E-01],
	[3.8835000000E+04, 3.1705409705E+01, 5.1464024401E+00, 1.3814672199E+01, 3.3530306107E+00, 9.6248094782E-01],
	[3.8840000000E+04, 3.1712487268E+01, 5.1464317184E+00, 1.3820441277E+01, 3.3534619526E+00, 9.6249733835E-01],
	[3.8845000000E+04, 3.1719565500E+01, 5.1464609931E+00, 1.3826212019E+01, 3.3538931902E+00, 9.6251372077E-01],
	[3.8850000000E+04, 3.1726644401E+01, 5.1464902642E+00, 1.3831984426E+01, 3.3543243236E+00, 9.6253009507E-01],
	[3.8855000000E+04, 3.1733723970E+01, 5.1465195317E+00, 1.3837758497E+01, 3.3547553528E+00, 9.6254646127E-01],
	[3.8860000000E+04, 3.1740804207E+01, 5.1465487956E+00, 1.3843534233E+01, 3.3551862778E+00, 9.6256281937E-01],
	[3.8865000000E+04, 3.1747885113E+01, 5.1465780559E+00, 1.3849311635E+01, 3.3556170985E+00, 9.6257916937E-01],
	[3.8870000000E+04, 3.1754966688E+01, 5.1466073126E+00, 1.3855090703E+01, 3.3560478152E+00, 9.6259551127E-01],
	[3.8875000000E+04, 3.1762048931E+01, 5.1466365657E+00, 1.3860871437E+01, 3.3564784276E+00, 9.6261184509E-01],
	[3.8880000000E+04, 3.1769131842E+01, 5.1466658152E+00, 1.3866653836E+01, 3.3569089359E+00, 9.6262817081E-01],
	[3.8885000000E+04, 3.1776215422E+01, 5.1466950612E+00, 1.3872437902E+01, 3.3573393401E+00, 9.6264448846E-01],
	[3.8890000000E+04, 3.1783299670E+01, 5.1467243035E+00, 1.3878223635E+01, 3.3577696402E+00, 9.6266079802E-01],
	[3.8895000000E+04, 3.1790384586E+01, 5.1467535422E+00, 1.3884011035E+01, 3.3581998362E+00, 9.6267709951E-01],
	[3.8900000000E+04, 3.1797470171E+01, 5.1467827774E+00, 1.3889800102E+01, 3.3586299281E+00, 9.6269339293E-01],
	[3.8905000000E+04, 3.1804556424E+01, 5.1468120089E+00, 1.3895590837E+01, 3.3590599160E+00, 9.6270967829E-01],
	[3.8910000000E+04, 3.1811643345E+01, 5.1468412369E+00, 1.3901383239E+01, 3.3594897998E+00, 9.6272595558E-01],
	[3.8915000000E+04, 3.1818730934E+01, 5.1468704612E+00, 1.3907177310E+01, 3.3599195796E+00, 9.6274222481E-01],
	[3.8920000000E+04, 3.1825819192E+01, 5.1468996820E+00, 1.3912973049E+01, 3.3603492554E+00, 9.6275848598E-01],
	[3.8925000000E+04, 3.1832908118E+01, 5.1469288992E+00, 1.3918770456E+01, 3.3607788272E+00, 9.6277473911E-01],
	[3.8930000000E+04, 3.1839997712E+01, 5.1469581128E+00, 1.3924569532E+01, 3.3612082950E+00, 9.6279098418E-01],
	[3.8935000000E+04, 3.1847087974E+01, 5.1469873228E+00, 1.3930370277E+01, 3.3616376589E+00, 9.6280722122E-01],
	[3.8940000000E+04, 3.1854178904E+01, 5.1470165293E+00, 1.3936172692E+01, 3.3620669188E+00, 9.6282345021E-01],
	[3.8945000000E+04, 3.1861270502E+01, 5.1470457321E+00, 1.3941976776E+01, 3.3624960748E+00, 9.6283967118E-01],
	[3.8950000000E+04, 3.1868362768E+01, 5.1470749314E+00, 1.3947782531E+01, 3.3629251268E+00, 9.6285588411E-01],
	[3.8955000000E+04, 3.1875455703E+01, 5.1471041271E+00, 1.3953589955E+01, 3.3633540750E+00, 9.6287208901E-01],
	[3.8960000000E+04, 3.1882549305E+01, 5.1471333192E+00, 1.3959399050E+01, 3.3637829193E+00, 9.6288828589E-01],
	[3.8965000000E+04, 3.1889643576E+01, 5.1471625077E+00, 1.3965209815E+01, 3.3642116597E+00, 9.6290447475E-01],
	[3.8970000000E+04, 3.1896738514E+01, 5.1471916926E+00, 1.3971022252E+01, 3.3646402963E+00, 9.6292065559E-01],
	[3.8975000000E+04, 3.1903834121E+01, 5.1472208740E+00, 1.3976836360E+01, 3.3650688290E+00, 9.6293682842E-01],
	[3.8980000000E+04, 3.1910930395E+01, 5.1472500518E+00, 1.3982652139E+01, 3.3654972579E+00, 9.6295299325E-01],
	[3.8985000000E+04, 3.1918027337E+01, 5.1472792260E+00, 1.3988469590E+01, 3.3659255831E+00, 9.6296915007E-01],
	[3.8990000000E+04, 3.1925124947E+01, 5.1473083966E+00, 1.3994288713E+01, 3.3663538044E+00, 9.6298529890E-01],
	[3.8995000000E+04, 3.1932223225E+01, 5.1473375637E+00, 1.4000109508E+01, 3.3667819220E+00, 9.6300143973E-01],
	[3.9000000000E+04, 3.1939322171E+01, 5.1473667272E+00, 1.4005931976E+01, 3.3672099358E+00, 9.6301757256E-01],
	[3.9005000000E+04, 3.1946421785E+01, 5.1473958871E+00, 1.4011756117E+01, 3.3676378459E+00, 9.6303369741E-01],
	[3.9010000000E+04, 3.1953522066E+01, 5.1474250434E+00, 1.4017581930E+01, 3.3680656523E+00, 9.6304981428E-01],
	[3.9015000000E+04, 3.1960623015E+01, 5.1474541962E+00, 1.4023409417E+01, 3.3684933549E+00, 9.6306592316E-01],
	[3.9020000000E+04, 3.1967724632E+01, 5.1474833454E+00, 1.4029238578E+01, 3.3689209539E+00, 9.6308202407E-01],
	[3.9025000000E+04, 3.1974826917E+01, 5.1475124910E+00, 1.4035069413E+01, 3.3693484493E+00, 9.6309811701E-01],
	[3.9030000000E+04, 3.1981929870E+01, 5.1475416331E+00, 1.4040901921E+01, 3.3697758409E+00, 9.6311420198E-01],
	[3.9035000000E+04, 3.1989033490E+01, 5.1475707716E+00, 1.4046736105E+01, 3.3702031289E+00, 9.6313027899E-01],
	[3.9040000000E+04, 3.1996137777E+01, 5.1475999065E+00, 1.4052571962E+01, 3.3706303134E+00, 9.6314634804E-01],
	[3.9045000000E+04, 3.2003242733E+01, 5.1476290378E+00, 1.4058409495E+01, 3.3710573942E+00, 9.6316240913E-01],
	[3.9050000000E+04, 3.2010348356E+01, 5.1476581656E+00, 1.4064248703E+01, 3.3714843714E+00, 9.6317846227E-01],
	[3.9055000000E+04, 3.2017454647E+01, 5.1476872898E+00, 1.4070089587E+01, 3.3719112450E+00, 9.6319450747E-01],
	[3.9060000000E+04, 3.2024561605E+01, 5.1477164105E+00, 1.4075932146E+01, 3.3723380151E+00, 9.6321054472E-01],
	[3.9065000000E+04, 3.2031669230E+01, 5.1477455276E+00, 1.4081776381E+01, 3.3727646817E+00, 9.6322657402E-01],
	[3.9070000000E+04, 3.2038777524E+01, 5.1477746411E+00, 1.4087622292E+01, 3.3731912447E+00, 9.6324259540E-01],
	[3.9075000000E+04, 3.2045886484E+01, 5.1478037511E+00, 1.4093469880E+01, 3.3736177043E+00, 9.6325860884E-01],
	[3.9080000000E+04, 3.2052996113E+01, 5.1478328575E+00, 1.4099319145E+01, 3.3740440603E+00, 9.6327461435E-01],
	[3.9085000000E+04, 3.2060106408E+01, 5.1478619604E+00, 1.4105170087E+01, 3.3744703129E+00, 9.6329061194E-01],
	[3.9090000000E+04, 3.2067217372E+01, 5.1478910597E+00, 1.4111022706E+01, 3.3748964620E+00, 9.6330660161E-01],
	[3.9095000000E+04, 3.2074329002E+01, 5.1479201554E+00, 1.4116877003E+01, 3.3753225077E+00, 9.6332258336E-01],
	[3.9100000000E+04, 3.2081441300E+01, 5.1479492476E+00, 1.4122732978E+01, 3.3757484499E+00, 9.6333855720E-01],
	[3.9105000000E+04, 3.2088554265E+01, 5.1479783362E+00, 1.4128590631E+01, 3.3761742888E+00, 9.6335452314E-01],
	[3.9110000000E+04, 3.2095667898E+01, 5.1480074213E+00, 1.4134449962E+01, 3.3766000242E+00, 9.6337048117E-01],
	[3.9115000000E+04, 3.2102782198E+01, 5.1480365028E+00, 1.4140310972E+01, 3.3770256563E+00, 9.6338643129E-01],
	[3.9120000000E+04, 3.2109897165E+01, 5.1480655808E+00, 1.4146173660E+01, 3.3774511851E+00, 9.6340237353E-01],
	[3.9125000000E+04, 3.2117012800E+01, 5.1480946552E+00, 1.4152038028E+01, 3.3778766104E+00, 9.6341830787E-01],
	[3.9130000000E+04, 3.2124129101E+01, 5.1481237261E+00, 1.4157904076E+01, 3.3783019325E+00, 9.6343423432E-01],
	[3.9135000000E+04, 3.2131246070E+01, 5.1481527934E+00, 1.4163771803E+01, 3.3787271513E+00, 9.6345015288E-01],
	[3.9140000000E+04, 3.2138363707E+01, 5.1481818572E+00, 1.4169641210E+01, 3.3791522668E+00, 9.6346606357E-01],
	[3.9145000000E+04, 3.2145482010E+01, 5.1482109174E+00, 1.4175512297E+01, 3.3795772790E+00, 9.6348196638E-01],
	[3.9150000000E+04, 3.2152600981E+01, 5.1482399740E+00, 1.4181385065E+01, 3.3800021879E+00, 9.6349786132E-01],
	[3.9155000000E+04, 3.2159720618E+01, 5.1482690272E+00, 1.4187259514E+01, 3.3804269936E+00, 9.6351374839E-01],
	[3.9160000000E+04, 3.2166840923E+01, 5.1482980767E+00, 1.4193135644E+01, 3.3808516961E+00, 9.6352962759E-01],
	[3.9165000000E+04, 3.2173961895E+01, 5.1483271228E+00, 1.4199013455E+01, 3.3812762954E+00, 9.6354549893E-01],
	[3.9170000000E+04, 3.2181083534E+01, 5.1483561652E+00, 1.4204892947E+01, 3.3817007914E+00, 9.6356136242E-01],
	[3.9175000000E+04, 3.2188205840E+01, 5.1483852042E+00, 1.4210774122E+01, 3.3821251844E+00, 9.6357721805E-01],
	[3.9180000000E+04, 3.2195328813E+01, 5.1484142396E+00, 1.4216656978E+01, 3.3825494741E+00, 9.6359306584E-01],
	[3.9185000000E+04, 3.2202452453E+01, 5.1484432715E+00, 1.4222541517E+01, 3.3829736607E+00, 9.6360890578E-01],
	[3.9190000000E+04, 3.2209576760E+01, 5.1484722998E+00, 1.4228427739E+01, 3.3833977442E+00, 9.6362473788E-01],
	[3.9195000000E+04, 3.2216701734E+01, 5.1485013245E+00, 1.4234315643E+01, 3.3838217246E+00, 9.6364056214E-01],
	[3.9200000000E+04, 3.2223827375E+01, 5.1485303458E+00, 1.4240205231E+01, 3.3842456019E+00, 9.6365637857E-01],
	[3.9205000000E+04, 3.2230953683E+01, 5.1485593635E+00, 1.4246096502E+01, 3.3846693761E+00, 9.6367218717E-01],
	[3.9210000000E+04, 3.2238080658E+01, 5.1485883777E+00, 1.4251989457E+01, 3.3850930473E+00, 9.6368798795E-01],
	[3.9215000000E+04, 3.2245208299E+01, 5.1486173883E+00, 1.4257884096E+01, 3.3855166154E+00, 9.6370378090E-01],
	[3.9220000000E+04, 3.2252336608E+01, 5.1486463954E+00, 1.4263780419E+01, 3.3859400805E+00, 9.6371956604E-01],
	[3.9225000000E+04, 3.2259465583E+01, 5.1486753989E+00, 1.4269678426E+01, 3.3863634426E+00, 9.6373534336E-01],
	[3.9230000000E+04, 3.2266595225E+01, 5.1487043990E+00, 1.4275578119E+01, 3.3867867017E+00, 9.6375111288E-01],
	[3.9235000000E+04, 3.2273725534E+01, 5.1487333955E+00, 1.4281479496E+01, 3.3872098579E+00, 9.6376687458E-01],
	[3.9240000000E+04, 3.2280867630E+01, 5.1487638507E+00, 1.4287382558E+01, 3.3876336665E+00, 9.6378262849E-01],
	[3.9245000000E+04, 3.2288016289E+01, 5.1487950768E+00, 1.4293287307E+01, 3.3880577728E+00, 9.6379837460E-01],
	[3.9250000000E+04, 3.2295165619E+01, 5.1488262991E+00, 1.4299193741E+01, 3.3884817764E+00, 9.6381411292E-01],
	[3.9255000000E+04, 3.2302315622E+01, 5.1488575177E+00, 1.4305101861E+01, 3.3889056775E+00, 9.6382984345E-01],
	[3.9260000000E+04, 3.2309466296E+01, 5.1488887324E+00, 1.4311011667E+01, 3.3893294760E+00, 9.6384556619E-01],
	[3.9265000000E+04, 3.2316617643E+01, 5.1489199434E+00, 1.4316923160E+01, 3.3897531719E+00, 9.6386128115E-01],
	[3.9270000000E+04, 3.2323769661E+01, 5.1489511506E+00, 1.4322836340E+01, 3.3901767654E+00, 9.6387698833E-01],
	[3.9275000000E+04, 3.2330922352E+01, 5.1489823540E+00, 1.4328751207E+01, 3.3906002564E+00, 9.6389268774E-01],
	[3.9280000000E+04, 3.2338075714E+01, 5.1490135536E+00, 1.4334667762E+01, 3.3910236448E+00, 9.6390837938E-01],
	[3.9285000000E+04, 3.2345229748E+01, 5.1490447494E+00, 1.4340586004E+01, 3.3914469308E+00, 9.6392406325E-01],
	[3.9290000000E+04, 3.2352384455E+01, 5.1490759415E+00, 1.4346505934E+01, 3.3918701144E+00, 9.6393973936E-01],
	[3.9295000000E+04, 3.2359539833E+01, 5.1491071297E+00, 1.4352427553E+01, 3.3922931955E+00, 9.6395540771E-01],
	[3.9300000000E+04, 3.2366695883E+01, 5.1491383142E+00, 1.4358350860E+01, 3.3927161742E+00, 9.6397106831E-01],
	[3.9305000000E+04, 3.2373852604E+01, 5.1491694949E+00, 1.4364275855E+01, 3.3931390505E+00, 9.6398672116E-01],
	[3.9310000000E+04, 3.2381009998E+01, 5.1492006718E+00, 1.4370202540E+01, 3.3935618244E+00, 9.6400236626E-01],
	[3.9315000000E+04, 3.2388168063E+01, 5.1492318450E+00, 1.4376130914E+01, 3.3939844959E+00, 9.6401800362E-01],
	[3.9320000000E+04, 3.2395326800E+01, 5.1492630144E+00, 1.4382060978E+01, 3.3944070651E+00, 9.6403363324E-01],
	[3.9325000000E+04, 3.2402486209E+01, 5.1492941800E+00, 1.4387992731E+01, 3.3948295319E+00, 9.6404925513E-01],
	[3.9330000000E+04, 3.2409646289E+01, 5.1493253418E+00, 1.4393926174E+01, 3.3952518964E+00, 9.6406486928E-01],
	[3.9335000000E+04, 3.2416807042E+01, 5.1493564999E+00, 1.4399861308E+01, 3.3956741587E+00, 9.6408047571E-01],
	[3.9340000000E+04, 3.2423968465E+01, 5.1493876542E+00, 1.4405798132E+01, 3.3960963186E+00, 9.6409607442E-01],
	[3.9345000000E+04, 3.2431130561E+01, 5.1494188047E+00, 1.4411736648E+01, 3.3965183763E+00, 9.6411166541E-01],
	[3.9350000000E+04, 3.2438293328E+01, 5.1494499514E+00, 1.4417676854E+01, 3.3969403317E+00, 9.6412724869E-01],
	[3.9355000000E+04, 3.2445456767E+01, 5.1494810944E+00, 1.4423618752E+01, 3.3973621849E+00, 9.6414282425E-01],
	[3.9360000000E+04, 3.2452620877E+01, 5.1495122336E+00, 1.4429562341E+01, 3.3977839359E+00, 9.6415839211E-01],
	[3.9365000000E+04, 3.2459785659E+01, 5.1495433691E+00, 1.4435507623E+01, 3.3982055846E+00, 9.6417395226E-01],
	[3.9370000000E+04, 3.2466951112E+01, 5.1495745007E+00, 1.4441454596E+01, 3.3986271312E+00, 9.6418950471E-01],
	[3.9375000000E+04, 3.2474117237E+01, 5.1496056286E+00, 1.4447403263E+01, 3.3990485756E+00, 9.6420504947E-01],
	[3.9380000000E+04, 3.2481284033E+01, 5.1496367528E+00, 1.4453353621E+01, 3.3994699179E+00, 9.6422058654E-01],
	[3.9385000000E+04, 3.2488451501E+01, 5.1496678732E+00, 1.4459305673E+01, 3.3998911580E+00, 9.6423611592E-01],
	[3.9390000000E+04, 3.2495619640E+01, 5.1496989898E+00, 1.4465259418E+01, 3.4003122961E+00, 9.6425163762E-01],
	[3.9395000000E+04, 3.2502788451E+01, 5.1497301026E+00, 1.4471214857E+01, 3.4007333320E+00, 9.6426715164E-01],
	[3.9400000000E+04, 3.2509957933E+01, 5.1497612117E+00, 1.4477171990E+01, 3.4011542658E+00, 9.6428265799E-01],
	[3.9405000000E+04, 3.2517128086E+01, 5.1497923171E+00, 1.4483130816E+01, 3.4015750976E+00, 9.6429815666E-01],
	[3.9410000000E+04, 3.2524298911E+01, 5.1498234187E+00, 1.4489091337E+01, 3.4019958273E+00, 9.6431364766E-01],
	[3.9415000000E+04, 3.2531470407E+01, 5.1498545165E+00, 1.4495053552E+01, 3.4024164550E+00, 9.6432913100E-01],
	[3.9420000000E+04, 3.2538642575E+01, 5.1498856105E+00, 1.4501017463E+01, 3.4028369807E+00, 9.6434460668E-01],
	[3.9425000000E+04, 3.2545815413E+01, 5.1499167009E+00, 1.4506983068E+01, 3.4032574043E+00, 9.6436007471E-01],
	[3.9430000000E+04, 3.2552988923E+01, 5.1499477874E+00, 1.4512950369E+01, 3.4036777260E+00, 9.6437553508E-01],
	[3.9435000000E+04, 3.2560163104E+01, 5.1499788702E+00, 1.4518919366E+01, 3.4040979458E+00, 9.6439098781E-01],
	[3.9440000000E+04, 3.2567337957E+01, 5.1500099493E+00, 1.4524890058E+01, 3.4045180635E+00, 9.6440643289E-01],
	[3.9445000000E+04, 3.2574513480E+01, 5.1500410245E+00, 1.4530862447E+01, 3.4049380794E+00, 9.6442187033E-01],
	[3.9450000000E+04, 3.2581689675E+01, 5.1500720961E+00, 1.4536836532E+01, 3.4053579933E+00, 9.6443730014E-01],
	[3.9455000000E+04, 3.2588866541E+01, 5.1501031639E+00, 1.4542812314E+01, 3.4057778054E+00, 9.6445272231E-01],
	[3.9460000000E+04, 3.2596044078E+01, 5.1501342279E+00, 1.4548789792E+01, 3.4061975155E+00, 9.6446813686E-01],
	[3.9465000000E+04, 3.2603222286E+01, 5.1501652882E+00, 1.4554768969E+01, 3.4066171238E+00, 9.6448354378E-01],
	[3.9470000000E+04, 3.2610401165E+01, 5.1501963448E+00, 1.4560749842E+01, 3.4070366303E+00, 9.6449894308E-01],
	[3.9475000000E+04, 3.2617580716E+01, 5.1502273976E+00, 1.4566732414E+01, 3.4074560349E+00, 9.6451433477E-01],
	[3.9480000000E+04, 3.2624760937E+01, 5.1502584466E+00, 1.4572716683E+01, 3.4078753377E+00, 9.6452971884E-01],
	[3.9485000000E+04, 3.2631941829E+01, 5.1502894919E+00, 1.4578702651E+01, 3.4082945388E+00, 9.6454509530E-01],
	[3.9490000000E+04, 3.2639123393E+01, 5.1503205335E+00, 1.4584690317E+01, 3.4087136380E+00, 9.6456046416E-01],
	[3.9495000000E+04, 3.2646305627E+01, 5.1503515713E+00, 1.4590679683E+01, 3.4091326355E+00, 9.6457582542E-01],
	[3.9500000000E+04, 3.2653488532E+01, 5.1503826054E+00, 1.4596670747E+01, 3.4095515312E+00, 9.6459117908E-01],
	[3.9505000000E+04, 3.2660672108E+01, 5.1504136357E+00, 1.4602663511E+01, 3.4099703253E+00, 9.6460652514E-01],
	[3.9510000000E+04, 3.2667856355E+01, 5.1504446623E+00, 1.4608657974E+01, 3.4103890176E+00, 9.6462186362E-01],
	[3.9515000000E+04, 3.2675041273E+01, 5.1504756852E+00, 1.4614654137E+01, 3.4108076082E+00, 9.6463719451E-01],
	[3.9520000000E+04, 3.2682226862E+01, 5.1505067043E+00, 1.4620652001E+01, 3.4112260971E+00, 9.6465251783E-01],
	[3.9525000000E+04, 3.2689413122E+01, 5.1505377197E+00, 1.4626651565E+01, 3.4116444844E+00, 9.6466783356E-01],
	[3.9530000000E+04, 3.2696600052E+01, 5.1505687313E+00, 1.4632652830E+01, 3.4120627701E+00, 9.6468314172E-01],
	[3.9535000000E+04, 3.2703787654E+01, 5.1505997393E+00, 1.4638655795E+01, 3.4124809541E+00, 9.6469844231E-01],
	[3.9540000000E+04, 3.2710975926E+01, 5.1506307434E+00, 1.4644660462E+01, 3.4128990365E+00, 9.6471373534E-01],
	[3.9545000000E+04, 3.2718164868E+01, 5.1506617439E+00, 1.4650666831E+01, 3.4133170173E+00, 9.6472902080E-01],
	[3.9550000000E+04, 3.2725354482E+01, 5.1506927406E+00, 1.4656674901E+01, 3.4137348966E+00, 9.6474429871E-01],
	[3.9555000000E+04, 3.2732544766E+01, 5.1507237336E+00, 1.4662684673E+01, 3.4141526743E+00, 9.6475956906E-01],
	[3.9560000000E+04, 3.2739735721E+01, 5.1507547228E+00, 1.4668696148E+01, 3.4145703505E+00, 9.6477483186E-01],
	[3.9565000000E+04, 3.2746927346E+01, 5.1507857083E+00, 1.4674709325E+01, 3.4149879251E+00, 9.6479008712E-01],
	[3.9570000000E+04, 3.2754119643E+01, 5.1508166901E+00, 1.4680724205E+01, 3.4154053982E+00, 9.6480533483E-01],
	[3.9575000000E+04, 3.2761312609E+01, 5.1508476682E+00, 1.4686740788E+01, 3.4158227699E+00, 9.6482057501E-01],
	[3.9580000000E+04, 3.2768506247E+01, 5.1508786425E+00, 1.4692759075E+01, 3.4162400401E+00, 9.6483580765E-01],
	[3.9585000000E+04, 3.2775700555E+01, 5.1509096131E+00, 1.4698779065E+01, 3.4166572088E+00, 9.6485103276E-01],
	[3.9590000000E+04, 3.2782895533E+01, 5.1509405800E+00, 1.4704800759E+01, 3.4170742761E+00, 9.6486625035E-01],
	[3.9595000000E+04, 3.2790091182E+01, 5.1509715431E+00, 1.4710824157E+01, 3.4174912420E+00, 9.6488146041E-01],
	[3.9600000000E+04, 3.2797287502E+01, 5.1510025026E+00, 1.4716849260E+01, 3.4179081065E+00, 9.6489666295E-01],
	[3.9605000000E+04, 3.2804484492E+01, 5.1510334583E+00, 1.4722876067E+01, 3.4183248696E+00, 9.6491185798E-01],
	[3.9610000000E+04, 3.2811682152E+01, 5.1510644103E+00, 1.4728904580E+01, 3.4187415314E+00, 9.6492704550E-01],
	[3.9615000000E+04, 3.2818880483E+01, 5.1510953585E+00, 1.4734934797E+01, 3.4191580918E+00, 9.6494222551E-01],
	[3.9620000000E+04, 3.2826079485E+01, 5.1511263031E+00, 1.4740966721E+01, 3.4195745508E+00, 9.6495739801E-01],
	[3.9625000000E+04, 3.2833279156E+01, 5.1511572439E+00, 1.4747000349E+01, 3.4199909086E+00, 9.6497256302E-01],
	[3.9630000000E+04, 3.2840479498E+01, 5.1511881810E+00, 1.4753035684E+01, 3.4204071650E+00, 9.6498772053E-01],
	[3.9635000000E+04, 3.2847680511E+01, 5.1512191144E+00, 1.4759072726E+01, 3.4208233202E+00, 9.6500287055E-01],
	[3.9640000000E+04, 3.2854882194E+01, 5.1512500441E+00, 1.4765111474E+01, 3.4212393741E+00, 9.6501801309E-01],
	[3.9645000000E+04, 3.2862084547E+01, 5.1512809701E+00, 1.4771151928E+01, 3.4216553268E+00, 9.6503314814E-01],
	[3.9650000000E+04, 3.2869287570E+01, 5.1513118923E+00, 1.4777194090E+01, 3.4220711782E+00, 9.6504827571E-01],
	[3.9655000000E+04, 3.2876491264E+01, 5.1513428108E+00, 1.4783237959E+01, 3.4224869285E+00, 9.6506339580E-01],
	[3.9660000000E+04, 3.2883695628E+01, 5.1513737256E+00, 1.4789283536E+01, 3.4229025775E+00, 9.6507850842E-01],
	[3.9665000000E+04, 3.2890900662E+01, 5.1514046368E+00, 1.4795330821E+01, 3.4233181254E+00, 9.6509361357E-01],
	[3.9670000000E+04, 3.2898106366E+01, 5.1514355442E+00, 1.4801379814E+01, 3.4237335721E+00, 9.6510871126E-01],
	[3.9675000000E+04, 3.2905312740E+01, 5.1514664478E+00, 1.4807430515E+01, 3.4241489177E+00, 9.6512380149E-01],
	[3.9680000000E+04, 3.2912519785E+01, 5.1514973478E+00, 1.4813482925E+01, 3.4245641621E+00, 9.6513888427E-01],
	[3.9685000000E+04, 3.2919727500E+01, 5.1515282441E+00, 1.4819537044E+01, 3.4249793055E+00, 9.6515395959E-01],
	[3.9690000000E+04, 3.2926935884E+01, 5.1515591367E+00, 1.4825592872E+01, 3.4253943477E+00, 9.6516902746E-01],
	[3.9695000000E+04, 3.2934144939E+01, 5.1515900255E+00, 1.4831650410E+01, 3.4258092889E+00, 9.6518408788E-01],
	[3.9700000000E+04, 3.2941354664E+01, 5.1516209107E+00, 1.4837709658E+01, 3.4262241291E+00, 9.6519914087E-01],
	[3.9705000000E+04, 3.2948565059E+01, 5.1516517921E+00, 1.4843770615E+01, 3.4266388682E+00, 9.6521418642E-01],
	[3.9710000000E+04, 3.2955776124E+01, 5.1516826699E+00, 1.4849833283E+01, 3.4270535063E+00, 9.6522922453E-01],
	[3.9715000000E+04, 3.2962987859E+01, 5.1517135439E+00, 1.4855897662E+01, 3.4274680433E+00, 9.6524425522E-01],
	[3.9720000000E+04, 3.2970200264E+01, 5.1517444142E+00, 1.4861963751E+01, 3.4278824794E+00, 9.6525927848E-01],
	[3.9725000000E+04, 3.2977413339E+01, 5.1517752809E+00, 1.4868031551E+01, 3.4282968146E+00, 9.6527429432E-01],
	[3.9730000000E+04, 3.2984627084E+01, 5.1518061438E+00, 1.4874101063E+01, 3.4287110488E+00, 9.6528930274E-01],
	[3.9735000000E+04, 3.2991841499E+01, 5.1518370030E+00, 1.4880172287E+01, 3.4291251820E+00, 9.6530430375E-01],
	[3.9740000000E+04, 3.2999056583E+01, 5.1518678586E+00, 1.4886245222E+01, 3.4295392144E+00, 9.6531929734E-01],
	[3.9745000000E+04, 3.3006272338E+01, 5.1518987104E+00, 1.4892319869E+01, 3.4299531458E+00, 9.6533428353E-01],
	[3.9750000000E+04, 3.3013488762E+01, 5.1519295586E+00, 1.4898396229E+01, 3.4303669764E+00, 9.6534926232E-01],
	[3.9755000000E+04, 3.3020705856E+01, 5.1519604030E+00, 1.4904474302E+01, 3.4307807061E+00, 9.6536423372E-01],
	[3.9760000000E+04, 3.3027923620E+01, 5.1519912438E+00, 1.4910554087E+01, 3.4311943350E+00, 9.6537919771E-01],
	[3.9765000000E+04, 3.3035142054E+01, 5.1520220809E+00, 1.4916635586E+01, 3.4316078630E+00, 9.6539415432E-01],
	[3.9770000000E+04, 3.3042361158E+01, 5.1520529142E+00, 1.4922718798E+01, 3.4320212903E+00, 9.6540910354E-01],
	[3.9775000000E+04, 3.3049580931E+01, 5.1520837439E+00, 1.4928803725E+01, 3.4324346167E+00, 9.6542404537E-01],
	[3.9780000000E+04, 3.3056801374E+01, 5.1521145699E+00, 1.4934890365E+01, 3.4328478424E+00, 9.6543897983E-01],
	[3.9785000000E+04, 3.3064022486E+01, 5.1521453922E+00, 1.4940978719E+01, 3.4332609673E+00, 9.6545390692E-01],
	[3.9790000000E+04, 3.3071244269E+01, 5.1521762108E+00, 1.4947068788E+01, 3.4336739915E+00, 9.6546882663E-01],
	[3.9795000000E+04, 3.3078466721E+01, 5.1522070257E+00, 1.4953160572E+01, 3.4340869149E+00, 9.6548373897E-01],
	[3.9800000000E+04, 3.3085689842E+01, 5.1522378370E+00, 1.4959254071E+01, 3.4344997377E+00, 9.6549864395E-01],
	[3.9805000000E+04, 3.3092913633E+01, 5.1522686445E+00, 1.4965349285E+01, 3.4349124598E+00, 9.6551354157E-01],
	[3.9810000000E+04, 3.3100138094E+01, 5.1522994484E+00, 1.4971446215E+01, 3.4353250812E+00, 9.6552843184E-01],
	[3.9815000000E+04, 3.3107363224E+01, 5.1523302486E+00, 1.4977544861E+01, 3.4357376019E+00, 9.6554331475E-01],
	[3.9820000000E+04, 3.3114589024E+01, 5.1523610451E+00, 1.4983645223E+01, 3.4361500221E+00, 9.6555819032E-01],
	[3.9825000000E+04, 3.3121815493E+01, 5.1523918379E+00, 1.4989747301E+01, 3.4365623416E+00, 9.6557305854E-01],
	[3.9830000000E+04, 3.3129042632E+01, 5.1524226270E+00, 1.4995851096E+01, 3.4369745605E+00, 9.6558791942E-01],
	[3.9835000000E+04, 3.3136270440E+01, 5.1524534124E+00, 1.5001956608E+01, 3.4373866788E+00, 9.6560277297E-01],
	[3.9840000000E+04, 3.3143498918E+01, 5.1524841942E+00, 1.5008063838E+01, 3.4377986966E+00, 9.6561761918E-01],
	[3.9845000000E+04, 3.3150728065E+01, 5.1525149723E+00, 1.5014172785E+01, 3.4382106138E+00, 9.6563245806E-01],
	[3.9850000000E+04, 3.3157957882E+01, 5.1525457467E+00, 1.5020283449E+01, 3.4386224305E+00, 9.6564728962E-01],
	[3.9855000000E+04, 3.3165188367E+01, 5.1525765175E+00, 1.5026395832E+01, 3.4390341467E+00, 9.6566211386E-01],
	[3.9860000000E+04, 3.3172419523E+01, 5.1526072845E+00, 1.5032509933E+01, 3.4394457624E+00, 9.6567693078E-01],
	[3.9865000000E+04, 3.3179651347E+01, 5.1526380479E+00, 1.5038625752E+01, 3.4398572776E+00, 9.6569174039E-01],
	[3.9870000000E+04, 3.3186889234E+01, 5.1526695126E+00, 1.5044743290E+01, 3.4402690646E+00, 9.6570654269E-01],
	[3.9875000000E+04, 3.3194139143E+01, 5.1527024570E+00, 1.5050862548E+01, 3.4406815347E+00, 9.6572133768E-01],
	[3.9880000000E+04, 3.3201389727E+01, 5.1527353975E+00, 1.5056983525E+01, 3.4410939047E+00, 9.6573612537E-01],
	[3.9885000000E+04, 3.3208640985E+01, 5.1527683340E+00, 1.5063106221E+01, 3.4415061746E+00, 9.6575090577E-01],
	[3.9890000000E+04, 3.3215892917E+01, 5.1528012667E+00, 1.5069230637E+01, 3.4419183444E+00, 9.6576567887E-01],
	[3.9895000000E+04, 3.3223145524E+01, 5.1528341954E+00, 1.5075356774E+01, 3.4423304141E+00, 9.6578044467E-01],
	[3.9900000000E+04, 3.3230398806E+01, 5.1528671202E+00, 1.5081484631E+01, 3.4427423839E+00, 9.6579520320E-01],
	[3.9905000000E+04, 3.3237652761E+01, 5.1529000411E+00, 1.5087614208E+01, 3.4431542536E+00, 9.6580995444E-01],
	[3.9910000000E+04, 3.3244907391E+01, 5.1529329581E+00, 1.5093745507E+01, 3.4435660233E+00, 9.6582469840E-01],
	[3.9915000000E+04, 3.3252162696E+01, 5.1529658712E+00, 1.5099878527E+01, 3.4439776930E+00, 9.6583943509E-01],
	[3.9920000000E+04, 3.3259418674E+01, 5.1529987803E+00, 1.5106013268E+01, 3.4443892628E+00, 9.6585416450E-01],
	[3.9925000000E+04, 3.3266675327E+01, 5.1530316856E+00, 1.5112149731E+01, 3.4448007327E+00, 9.6586888665E-01],
	[3.9930000000E+04, 3.3273932654E+01, 5.1530645869E+00, 1.5118287916E+01, 3.4452121026E+00, 9.6588360154E-01],
	[3.9935000000E+04, 3.3281190656E+01, 5.1530974844E+00, 1.5124427824E+01, 3.4456233726E+00, 9.6589830916E-01],
	[3.9940000000E+04, 3.3288449331E+01, 5.1531303779E+00, 1.5130569454E+01, 3.4460345427E+00, 9.6591300953E-01],
	[3.9945000000E+04, 3.3295708681E+01, 5.1531632675E+00, 1.5136712806E+01, 3.4464456129E+00, 9.6592770265E-01],
	[3.9950000000E+04, 3.3302968705E+01, 5.1531961532E+00, 1.5142857882E+01, 3.4468565833E+00, 9.6594238852E-01],
	[3.9955000000E+04, 3.3310229403E+01, 5.1532290350E+00, 1.5149004681E+01, 3.4472674538E+00, 9.6595706715E-01],
	[3.9960000000E+04, 3.3317490775E+01, 5.1532619129E+00, 1.5155153204E+01, 3.4476782245E+00, 9.6597173854E-01],
	[3.9965000000E+04, 3.3324752822E+01, 5.1532947869E+00, 1.5161303451E+01, 3.4480888955E+00, 9.6598640269E-01],
	[3.9970000000E+04, 3.3332015542E+01, 5.1533276570E+00, 1.5167455422E+01, 3.4484994666E+00, 9.6600105960E-01],
	[3.9975000000E+04, 3.3339278936E+01, 5.1533605231E+00, 1.5173609118E+01, 3.4489099380E+00, 9.6601570929E-01],
	[3.9980000000E+04, 3.3346543005E+01, 5.1533933854E+00, 1.5179764538E+01, 3.4493203096E+00, 9.6603035176E-01],
	[3.9985000000E+04, 3.3353807747E+01, 5.1534262438E+00, 1.5185921683E+01, 3.4497305814E+00, 9.6604498700E-01],
	[3.9990000000E+04, 3.3361073164E+01, 5.1534590983E+00, 1.5192080553E+01, 3.4501407536E+00, 9.6605961503E-01],
	[3.9995000000E+04, 3.3368339254E+01, 5.1534919489E+00, 1.5198241149E+01, 3.4505508261E+00, 9.6607423584E-01],
	[4.0000000000E+04, 3.3375606019E+01, 5.1535247956E+00, 1.5204403470E+01, 3.4509607989E+00, 9.6608884944E-01],
	[4.0005000000E+04, 3.3382873457E+01, 5.1535576384E+00, 1.5210592728E+01, 3.4513719699E+00, 9.6610345584E-01],
	[4.0010000000E+04, 3.3390141569E+01, 5.1535904773E+00, 1.5216783729E+01, 3.4517830408E+00, 9.6611805504E-01],
	[4.0015000000E+04, 3.3397410356E+01, 5.1536233123E+00, 1.5222976474E+01, 3.4521940114E+00, 9.6613264703E-01],
	[4.0020000000E+04, 3.3404679816E+01, 5.1536561434E+00, 1.5229170963E+01, 3.4526048819E+00, 9.6614723184E-01],
	[4.0025000000E+04, 3.3411949949E+01, 5.1536889706E+00, 1.5235367198E+01, 3.4530156521E+00, 9.6616180945E-01],
	[4.0030000000E+04, 3.3419220757E+01, 5.1537217939E+00, 1.5241565177E+01, 3.4534263222E+00, 9.6617637987E-01],
	[4.0035000000E+04, 3.3426492238E+01, 5.1537546133E+00, 1.5247764901E+01, 3.4538368921E+00, 9.6619094312E-01],
	[4.0040000000E+04, 3.3433764394E+01, 5.1537874289E+00, 1.5253966370E+01, 3.4542473620E+00, 9.6620549918E-01],
	[4.0045000000E+04, 3.3441037223E+01, 5.1538202405E+00, 1.5260169586E+01, 3.4546577317E+00, 9.6622004807E-01],
	[4.0050000000E+04, 3.3448310725E+01, 5.1538530483E+00, 1.5266374547E+01, 3.4550680013E+00, 9.6623458979E-01],
	[4.0055000000E+04, 3.3455584902E+01, 5.1538858522E+00, 1.5272581255E+01, 3.4554781709E+00, 9.6624912434E-01],
	[4.0060000000E+04, 3.3462859752E+01, 5.1539186522E+00, 1.5278789709E+01, 3.4558882403E+00, 9.6626365172E-01],
	[4.0065000000E+04, 3.3470135276E+01, 5.1539514483E+00, 1.5284999910E+01, 3.4562982098E+00, 9.6627817195E-01],
	[4.0070000000E+04, 3.3477411473E+01, 5.1539842405E+00, 1.5291211858E+01, 3.4567080792E+00, 9.6629268502E-01],
	[4.0075000000E+04, 3.3484688344E+01, 5.1540170289E+00, 1.5297425554E+01, 3.4571178487E+00, 9.6630719094E-01],
	[4.0080000000E+04, 3.3491965889E+01, 5.1540498133E+00, 1.5303640997E+01, 3.4575275181E+00, 9.6632168971E-01],
	[4.0085000000E+04, 3.3499244107E+01, 5.1540825939E+00, 1.5309858188E+01, 3.4579370876E+00, 9.6633618133E-01],
	[4.0090000000E+04, 3.3506522999E+01, 5.1541153706E+00, 1.5316077127E+01, 3.4583465572E+00, 9.6635066582E-01],
	[4.0095000000E+04, 3.3513802564E+01, 5.1541481434E+00, 1.5322297815E+01, 3.4587559268E+00, 9.6636514316E-01],
	[4.0100000000E+04, 3.3521082803E+01, 5.1541809124E+00, 1.5328520251E+01, 3.4591651965E+00, 9.6637961338E-01],
	[4.0105000000E+04, 3.3528363716E+01, 5.1542136775E+00, 1.5334744436E+01, 3.4595743663E+00, 9.6639407646E-01],
	[4.0110000000E+04, 3.3535645302E+01, 5.1542464386E+00, 1.5340970371E+01, 3.4599834362E+00, 9.6640853242E-01],
	[4.0115000000E+04, 3.3542927561E+01, 5.1542791960E+00, 1.5347198055E+01, 3.4603924063E+00, 9.6642298126E-01],
	[4.0120000000E+04, 3.3550210494E+01, 5.1543119494E+00, 1.5353427489E+01, 3.4608012765E+00, 9.6643742297E-01],
	[4.0125000000E+04, 3.3557494100E+01, 5.1543446990E+00, 1.5359658673E+01, 3.4612100469E+00, 9.6645185758E-01],
	[4.0130000000E+04, 3.3564778379E+01, 5.1543774447E+00, 1.5365891608E+01, 3.4616187175E+00, 9.6646628507E-01],
	[4.0135000000E+04, 3.3572063332E+01, 5.1544101865E+00, 1.5372126293E+01, 3.4620272884E+00, 9.6648070546E-01],
	[4.0140000000E+04, 3.3579348958E+01, 5.1544429244E+00, 1.5378362729E+01, 3.4624357594E+00, 9.6649511874E-01],
	[4.0145000000E+04, 3.3586635258E+01, 5.1544756585E+00, 1.5384600916E+01, 3.4628441307E+00, 9.6650952493E-01],
	[4.0150000000E+04, 3.3593922231E+01, 5.1545083887E+00, 1.5390840854E+01, 3.4632524023E+00, 9.6652392402E-01],
	[4.0155000000E+04, 3.3601209877E+01, 5.1545411151E+00, 1.5397082545E+01, 3.4636605742E+00, 9.6653831602E-01],
	[4.0160000000E+04, 3.3608498196E+01, 5.1545738375E+00, 1.5403325987E+01, 3.4640686463E+00, 9.6655270093E-01],
	[4.0165000000E+04, 3.3615787189E+01, 5.1546065562E+00, 1.5409571182E+01, 3.4644766188E+00, 9.6656707876E-01],
	[4.0170000000E+04, 3.3623076855E+01, 5.1546392709E+00, 1.5415818129E+01, 3.4648844916E+00, 9.6658144950E-01],
	[4.0175000000E+04, 3.3630367194E+01, 5.1546719818E+00, 1.5422066829E+01, 3.4652922648E+00, 9.6659581318E-01],
	[4.0180000000E+04, 3.3637658206E+01, 5.1547046888E+00, 1.5428317282E+01, 3.4656999384E+00, 9.6661016977E-01],
	[4.0185000000E+04, 3.3644949891E+01, 5.1547373920E+00, 1.5434569488E+01, 3.4661075123E+00, 9.6662451930E-01],
	[4.0190000000E+04, 3.3652242249E+01, 5.1547700913E+00, 1.5440823448E+01, 3.4665149867E+00, 9.6663886177E-01],
	[4.0195000000E+04, 3.3659535281E+01, 5.1548027867E+00, 1.5447079162E+01, 3.4669223615E+00, 9.6665319717E-01],
	[4.0200000000E+04, 3.3666828986E+01, 5.1548354783E+00, 1.5453336630E+01, 3.4673296368E+00, 9.6666752552E-01],
	[4.0205000000E+04, 3.3674123363E+01, 5.1548681660E+00, 1.5459595853E+01, 3.4677368125E+00, 9.6668184681E-01],
	[4.0210000000E+04, 3.3681418414E+01, 5.1549008498E+00, 1.5465856830E+01, 3.4681438887E+00, 9.6669616105E-01],
	[4.0215000000E+04, 3.3688714138E+01, 5.1549335298E+00, 1.5472119562E+01, 3.4685508654E+00, 9.6671046825E-01],
	[4.0220000000E+04, 3.3696010535E+01, 5.1549662060E+00, 1.5478384050E+01, 3.4689577426E+00, 9.6672476840E-01],
	[4.0225000000E+04, 3.3703307604E+01, 5.1549988783E+00, 1.5484650293E+01, 3.4693645204E+00, 9.6673906152E-01],
	[4.0230000000E+04, 3.3710605347E+01, 5.1550315467E+00, 1.5490918292E+01, 3.4697711987E+00, 9.6675334760E-01],
	[4.0235000000E+04, 3.3717903763E+01, 5.1550642113E+00, 1.5497188047E+01, 3.4701777776E+00, 9.6676762665E-01],
	[4.0240000000E+04, 3.3725202851E+01, 5.1550968720E+00, 1.5503459558E+01, 3.4705842571E+00, 9.6678189868E-01],
	[4.0245000000E+04, 3.3732502613E+01, 5.1551295289E+00, 1.5509732826E+01, 3.4709906372E+00, 9.6679616368E-01],
	[4.0250000000E+04, 3.3739803047E+01, 5.1551621819E+00, 1.5516007851E+01, 3.4713969180E+00, 9.6681042166E-01],
	[4.0255000000E+04, 3.3747104154E+01, 5.1551948311E+00, 1.5522284633E+01, 3.4718030993E+00, 9.6682467262E-01],
	[4.0260000000E+04, 3.3754405934E+01, 5.1552274765E+00, 1.5528563172E+01, 3.4722091814E+00, 9.6683891657E-01],
	[4.0265000000E+04, 3.3761708387E+01, 5.1552601180E+00, 1.5534843470E+01, 3.4726151641E+00, 9.6685315352E-01],
	[4.0270000000E+04, 3.3769011512E+01, 5.1552927556E+00, 1.5541125525E+01, 3.4730210476E+00, 9.6686738346E-01],
	[4.0275000000E+04, 3.3776315311E+01, 5.1553253894E+00, 1.5547409339E+01, 3.4734268317E+00, 9.6688160640E-01],
	[4.0280000000E+04, 3.3783619782E+01, 5.1553580193E+00, 1.5553694911E+01, 3.4738325166E+00, 9.6689582234E-01],
	[4.0285000000E+04, 3.3790924925E+01, 5.1553906454E+00, 1.5559982241E+01, 3.4742381023E+00, 9.6691003129E-01],
	[4.0290000000E+04, 3.3798230742E+01, 5.1554232677E+00, 1.5566271331E+01, 3.4746435887E+00, 9.6692423325E-01],
	[4.0295000000E+04, 3.3805537231E+01, 5.1554558861E+00, 1.5572562181E+01, 3.4750489759E+00, 9.6693842822E-01],
	[4.0300000000E+04, 3.3812844393E+01, 5.1554885007E+00, 1.5578854790E+01, 3.4754542640E+00, 9.6695261621E-01],
	[4.0305000000E+04, 3.3820152227E+01, 5.1555211114E+00, 1.5585149159E+01, 3.4758594528E+00, 9.6696679723E-01],
	[4.0310000000E+04, 3.3827460734E+01, 5.1555537184E+00, 1.5591445288E+01, 3.4762645426E+00, 9.6698097126E-01],
	[4.0315000000E+04, 3.3834769914E+01, 5.1555863214E+00, 1.5597743177E+01, 3.4766695331E+00, 9.6699513833E-01],
	[4.0320000000E+04, 3.3842079766E+01, 5.1556189206E+00, 1.5604042828E+01, 3.4770744246E+00, 9.6700929843E-01],
	[4.0325000000E+04, 3.3849390291E+01, 5.1556515160E+00, 1.5610344239E+01, 3.4774792170E+00, 9.6702345157E-01],
	[4.0330000000E+04, 3.3856701488E+01, 5.1556841076E+00, 1.5616647412E+01, 3.4778839103E+00, 9.6703759775E-01],
	[4.0335000000E+04, 3.3864013358E+01, 5.1557166953E+00, 1.5622952346E+01, 3.4782885045E+00, 9.6705173698E-01],
	[4.0340000000E+04, 3.3871325900E+01, 5.1557492792E+00, 1.5629259042E+01, 3.4786929997E+00, 9.6706586925E-01],
	[4.0345000000E+04, 3.3878639114E+01, 5.1557818593E+00, 1.5635567500E+01, 3.4790973959E+00, 9.6707999457E-01],
	[4.0350000000E+04, 3.3885953002E+01, 5.1558144355E+00, 1.5641877720E+01, 3.4795016930E+00, 9.6709411295E-01],
	[4.0355000000E+04, 3.3893267561E+01, 5.1558470079E+00, 1.5648189703E+01, 3.4799058912E+00, 9.6710822439E-01],
	[4.0360000000E+04, 3.3900582793E+01, 5.1558795764E+00, 1.5654503449E+01, 3.4803099904E+00, 9.6712232889E-01],
	[4.0365000000E+04, 3.3907898697E+01, 5.1559121412E+00, 1.5660818958E+01, 3.4807139907E+00, 9.6713642646E-01],
	[4.0370000000E+04, 3.3915215274E+01, 5.1559447021E+00, 1.5667136231E+01, 3.4811178920E+00, 9.6715051710E-01],
	[4.0375000000E+04, 3.3922532523E+01, 5.1559772591E+00, 1.5673455267E+01, 3.4815216944E+00, 9.6716460081E-01],
	[4.0380000000E+04, 3.3929850444E+01, 5.1560098124E+00, 1.5679776068E+01, 3.4819253979E+00, 9.6717867760E-01],
	[4.0385000000E+04, 3.3937169038E+01, 5.1560423618E+00, 1.5686098632E+01, 3.4823290026E+00, 9.6719274748E-01],
	[4.0390000000E+04, 3.3944488303E+01, 5.1560749074E+00, 1.5692422961E+01, 3.4827325083E+00, 9.6720681043E-01],
	[4.0395000000E+04, 3.3951808242E+01, 5.1561074492E+00, 1.5698749055E+01, 3.4831359153E+00, 9.6722086648E-01],
	[4.0400000000E+04, 3.3959128852E+01, 5.1561399872E+00, 1.5705076915E+01, 3.4835392234E+00, 9.6723491562E-01],
	[4.0405000000E+04, 3.3966450134E+01, 5.1561725213E+00, 1.5711406539E+01, 3.4839424327E+00, 9.6724895786E-01],
	[4.0410000000E+04, 3.3973772089E+01, 5.1562050516E+00, 1.5717737929E+01, 3.4843455432E+00, 9.6726299320E-01],
	[4.0415000000E+04, 3.3981094716E+01, 5.1562375781E+00, 1.5724071085E+01, 3.4847485550E+00, 9.6727702164E-01],
	[4.0420000000E+04, 3.3988418015E+01, 5.1562701008E+00, 1.5730406008E+01, 3.4851514680E+00, 9.6729104319E-01],
	[4.0425000000E+04, 3.3995741986E+01, 5.1563026197E+00, 1.5736742696E+01, 3.4855542823E+00, 9.6730505786E-01],
	[4.0430000000E+04, 3.4003066629E+01, 5.1563351347E+00, 1.5743081152E+01, 3.4859569979E+00, 9.6731906563E-01],
	[4.0435000000E+04, 3.4010391944E+01, 5.1563676459E+00, 1.5749421374E+01, 3.4863596148E+00, 9.6733306653E-01],
	[4.0440000000E+04, 3.4017717931E+01, 5.1564001533E+00, 1.5755763364E+01, 3.4867621330E+00, 9.6734706055E-01],
	[4.0445000000E+04, 3.4025044591E+01, 5.1564326569E+00, 1.5762107121E+01, 3.4871645525E+00, 9.6736104770E-01],
	[4.0450000000E+04, 3.4032371922E+01, 5.1564651567E+00, 1.5768452647E+01, 3.4875668734E+00, 9.6737502797E-01],
	[4.0455000000E+04, 3.4039699925E+01, 5.1564976527E+00, 1.5774799940E+01, 3.4879690957E+00, 9.6738900138E-01],
	[4.0460000000E+04, 3.4047028601E+01, 5.1565301449E+00, 1.5781149002E+01, 3.4883712194E+00, 9.6740296793E-01],
	[4.0465000000E+04, 3.4054357948E+01, 5.1565626332E+00, 1.5787499832E+01, 3.4887732445E+00, 9.6741692762E-01],
	[4.0470000000E+04, 3.4061687967E+01, 5.1565951178E+00, 1.5793852431E+01, 3.4891751710E+00, 9.6743088046E-01],
	[4.0475000000E+04, 3.4069018658E+01, 5.1566275985E+00, 1.5800206800E+01, 3.4895769990E+00, 9.6744482644E-01],
	[4.0480000000E+04, 3.4076350021E+01, 5.1566600754E+00, 1.5806562937E+01, 3.4899787285E+00, 9.6745876558E-01],
	[4.0485000000E+04, 3.4083682056E+01, 5.1566925485E+00, 1.5812920845E+01, 3.4903803595E+00, 9.6747269787E-01],
	[4.0490000000E+04, 3.4091014762E+01, 5.1567250178E+00, 1.5819280523E+01, 3.4907818919E+00, 9.6748662333E-01],
	[4.0495000000E+04, 3.4098348141E+01, 5.1567574834E+00, 1.5825641971E+01, 3.4911833259E+00, 9.6750054194E-01],
	[4.0500000000E+04, 3.4105682191E+01, 5.1567899451E+00, 1.5832005189E+01, 3.4915846615E+00, 9.6751445373E-01],
	[4.0505000000E+04, 3.4113016913E+01, 5.1568224030E+00, 1.5838370179E+01, 3.4919858986E+00, 9.6752835868E-01],
	[4.0510000000E+04, 3.4120352307E+01, 5.1568548571E+00, 1.5844736939E+01, 3.4923870373E+00, 9.6754225682E-01],
	[4.0515000000E+04, 3.4127704250E+01, 5.1568893550E+00, 1.5851105471E+01, 3.4927891832E+00, 9.6755614813E-01],
	[4.0520000000E+04, 3.4135057587E+01, 5.1569239414E+00, 1.5857475775E+01, 3.4931912810E+00, 9.6757003262E-01],
	[4.0525000000E+04, 3.4142411601E+01, 5.1569585238E+00, 1.5863847850E+01, 3.4935932808E+00, 9.6758391029E-01],
	[4.0530000000E+04, 3.4149766292E+01, 5.1569931022E+00, 1.5870221698E+01, 3.4939951825E+00, 9.6759778116E-01],
	[4.0535000000E+04, 3.4157121660E+01, 5.1570276765E+00, 1.5876597318E+01, 3.4943969862E+00, 9.6761164522E-01],
	[4.0540000000E+04, 3.4164477704E+01, 5.1570622468E+00, 1.5882974711E+01, 3.4947986919E+00, 9.6762550248E-01],
	[4.0545000000E+04, 3.4171834425E+01, 5.1570968131E+00, 1.5889353877E+01, 3.4952002996E+00, 9.6763935294E-01],
	[4.0550000000E+04, 3.4179191823E+01, 5.1571313754E+00, 1.5895734816E+01, 3.4956018093E+00, 9.6765319660E-01],
	[4.0555000000E+04, 3.4186549897E+01, 5.1571659336E+00, 1.5902117529E+01, 3.4960032211E+00, 9.6766703348E-01],
	[4.0560000000E+04, 3.4193908648E+01, 5.1572004878E+00, 1.5908502016E+01, 3.4964045350E+00, 9.6768086356E-01],
	[4.0565000000E+04, 3.4201268076E+01, 5.1572350379E+00, 1.5914888277E+01, 3.4968057509E+00, 9.6769468686E-01],
	[4.0570000000E+04, 3.4208628180E+01, 5.1572695840E+00, 1.5921276312E+01, 3.4972068690E+00, 9.6770850338E-01],
	[4.0575000000E+04, 3.4215988961E+01, 5.1573041261E+00, 1.5927666122E+01, 3.4976078891E+00, 9.6772231312E-01],
	[4.0580000000E+04, 3.4223350418E+01, 5.1573386642E+00, 1.5934057707E+01, 3.4980088114E+00, 9.6773611609E-01],
	[4.0585000000E+04, 3.4230712552E+01, 5.1573731983E+00, 1.5940451067E+01, 3.4984096359E+00, 9.6774991229E-01],
	[4.0590000000E+04, 3.4238075362E+01, 5.1574077283E+00, 1.5946846202E+01, 3.4988103626E+00, 9.6776370172E-01],
	[4.0595000000E+04, 3.4245438849E+01, 5.1574422543E+00, 1.5953243114E+01, 3.4992109914E+00, 9.6777748439E-01],
	[4.0600000000E+04, 3.4252803012E+01, 5.1574767763E+00, 1.5959641801E+01, 3.4996115225E+00, 9.6779126031E-01],
	[4.0605000000E+04, 3.4260167852E+01, 5.1575112942E+00, 1.5966042265E+01, 3.5000119558E+00, 9.6780502946E-01],
	[4.0610000000E+04, 3.4267533368E+01, 5.1575458082E+00, 1.5972444505E+01, 3.5004122913E+00, 9.6781879187E-01],
	[4.0615000000E+04, 3.4274899561E+01, 5.1575803181E+00, 1.5978848522E+01, 3.5008125292E+00, 9.6783254753E-01],
	[4.0620000000E+04, 3.4282266430E+01, 5.1576148240E+00, 1.5985254316E+01, 3.5012126693E+00, 9.6784629644E-01],
	[4.0625000000E+04, 3.4289633975E+01, 5.1576493259E+00, 1.5991661888E+01, 3.5016127117E+00, 9.6786003862E-01],
	[4.0630000000E+04, 3.4297002196E+01, 5.1576838238E+00, 1.5998071237E+01, 3.5020126564E+00, 9.6787377406E-01],
	[4.0635000000E+04, 3.4304371094E+01, 5.1577183177E+00, 1.6004482364E+01, 3.5024125035E+00, 9.6788750276E-01],
	[4.0640000000E+04, 3.4311740669E+01, 5.1577528075E+00, 1.6010895270E+01, 3.5028122530E+00, 9.6790122474E-01],
	[4.0645000000E+04, 3.4319110919E+01, 5.1577872933E+00, 1.6017309954E+01, 3.5032119048E+00, 9.6791493999E-01],
	[4.0650000000E+04, 3.4326481846E+01, 5.1578217752E+00, 1.6023726417E+01, 3.5036114591E+00, 9.6792864852E-01],
	[4.0655000000E+04, 3.4333853449E+01, 5.1578562530E+00, 1.6030144658E+01, 3.5040109157E+00, 9.6794235033E-01],
	[4.0660000000E+04, 3.4341225728E+01, 5.1578907268E+00, 1.6036564680E+01, 3.5044102748E+00, 9.6795604543E-01],
	[4.0665000000E+04, 3.4348598683E+01, 5.1579251966E+00, 1.6042986480E+01, 3.5048095364E+00, 9.6796973382E-01],
	[4.0670000000E+04, 3.4355972315E+01, 5.1579596624E+00, 1.6049410061E+01, 3.5052087004E+00, 9.6798341550E-01],
	[4.0675000000E+04, 3.4363346623E+01, 5.1579941242E+00, 1.6055835422E+01, 3.5056077669E+00, 9.6799709047E-01],
	[4.0680000000E+04, 3.4370721606E+01, 5.1580285819E+00, 1.6062262563E+01, 3.5060067360E+00, 9.6801075875E-01],
	[4.0685000000E+04, 3.4378097266E+01, 5.1580630357E+00, 1.6068691485E+01, 3.5064056075E+00, 9.6802442033E-01],
	[4.0690000000E+04, 3.4385473602E+01, 5.1580974855E+00, 1.6075122187E+01, 3.5068043816E+00, 9.6803807522E-01],
	[4.0695000000E+04, 3.4392850614E+01, 5.1581319313E+00, 1.6081554671E+01, 3.5072030583E+00, 9.6805172342E-01],
	[4.0700000000E+04, 3.4400228302E+01, 5.1581663730E+00, 1.6087988937E+01, 3.5076016376E+00, 9.6806536493E-01],
	[4.0705000000E+04, 3.4407606666E+01, 5.1582008108E+00, 1.6094424984E+01, 3.5080001194E+00, 9.6807899976E-01],
	[4.0710000000E+04, 3.4414985707E+01, 5.1582352445E+00, 1.6100862814E+01, 3.5083985039E+00, 9.6809262792E-01],
	[4.0715000000E+04, 3.4422365423E+01, 5.1582696743E+00, 1.6107302426E+01, 3.5087967911E+00, 9.6810624940E-01],
	[4.0720000000E+04, 3.4429745815E+01, 5.1583041001E+00, 1.6113743820E+01, 3.5091949809E+00, 9.6811986421E-01],
	[4.0725000000E+04, 3.4437126883E+01, 5.1583385218E+00, 1.6120186997E+01, 3.5095930733E+00, 9.6813347235E-01],
	[4.0730000000E+04, 3.4444508627E+01, 5.1583729396E+00, 1.6126631957E+01, 3.5099910685E+00, 9.6814707383E-01],
	[4.0735000000E+04, 3.4451891046E+01, 5.1584073534E+00, 1.6133078701E+01, 3.5103889664E+00, 9.6816066865E-01],
	[4.0740000000E+04, 3.4459274142E+01, 5.1584417632E+00, 1.6139527229E+01, 3.5107867670E+00, 9.6817425682E-01],
	[4.0745000000E+04, 3.4466657913E+01, 5.1584761690E+00, 1.6145977540E+01, 3.5111844704E+00, 9.6818783833E-01],
	[4.0750000000E+04, 3.4474042361E+01, 5.1585105708E+00, 1.6152429636E+01, 3.5115820765E+00, 9.6820141320E-01],
	[4.0755000000E+04, 3.4481427484E+01, 5.1585449686E+00, 1.6158883516E+01, 3.5119795854E+00, 9.6821498142E-01],
	[4.0760000000E+04, 3.4488813283E+01, 5.1585793624E+00, 1.6165339181E+01, 3.5123769972E+00, 9.6822854299E-01],
	[4.0765000000E+04, 3.4496199758E+01, 5.1586137522E+00, 1.6171796631E+01, 3.5127743118E+00, 9.6824209793E-01],
	[4.0770000000E+04, 3.4503586908E+01, 5.1586481380E+00, 1.6178255867E+01, 3.5131715292E+00, 9.6825564624E-01],
	[4.0775000000E+04, 3.4510974734E+01, 5.1586825199E+00, 1.6184716888E+01, 3.5135686495E+00, 9.6826918792E-01],
	[4.0780000000E+04, 3.4518363236E+01, 5.1587168978E+00, 1.6191179695E+01, 3.5139656726E+00, 9.6828272297E-01],
	[4.0785000000E+04, 3.4525752414E+01, 5.1587512716E+00, 1.6197644288E+01, 3.5143625987E+00, 9.6829625139E-01],
	[4.0790000000E+04, 3.4533142267E+01, 5.1587856415E+00, 1.6204110668E+01, 3.5147594277E+00, 9.6830977320E-01],
	[4.0795000000E+04, 3.4540532796E+01, 5.1588200074E+00, 1.6210578834E+01, 3.5151561596E+00, 9.6832328839E-01],
	[4.0800000000E+04, 3.4547924000E+01, 5.1588543694E+00, 1.6217048787E+01, 3.5155527945E+00, 9.6833679697E-01],
	[4.0805000000E+04, 3.4555315880E+01, 5.1588887273E+00, 1.6223520528E+01, 3.5159493323E+00, 9.6835029894E-01],
	[4.0810000000E+04, 3.4562708436E+01, 5.1589230813E+00, 1.6229994056E+01, 3.5163457732E+00, 9.6836379431E-01],
	[4.0815000000E+04, 3.4570101667E+01, 5.1589574313E+00, 1.6236469371E+01, 3.5167421171E+00, 9.6837728307E-01],
	[4.0820000000E+04, 3.4577495574E+01, 5.1589917773E+00, 1.6242946475E+01, 3.5171383640E+00, 9.6839076524E-01],
	[4.0825000000E+04, 3.4584890156E+01, 5.1590261193E+00, 1.6249425368E+01, 3.5175345139E+00, 9.6840424081E-01],
	[4.0830000000E+04, 3.4592285414E+01, 5.1590604573E+00, 1.6255906049E+01, 3.5179305669E+00, 9.6841770979E-01],
	[4.0835000000E+04, 3.4599681347E+01, 5.1590947914E+00, 1.6262388519E+01, 3.5183265231E+00, 9.6843117219E-01],
	[4.0840000000E+04, 3.4607077955E+01, 5.1591291215E+00, 1.6268872778E+01, 3.5187223823E+00, 9.6844462800E-01],
	[4.0845000000E+04, 3.4614475240E+01, 5.1591634476E+00, 1.6275358826E+01, 3.5191181446E+00, 9.6845807723E-01],
	[4.0850000000E+04, 3.4621873199E+01, 5.1591977698E+00, 1.6281846664E+01, 3.5195138101E+00, 9.6847151989E-01],
	[4.0855000000E+04, 3.4629271834E+01, 5.1592320879E+00, 1.6288336292E+01, 3.5199093788E+00, 9.6848495598E-01],
	[4.0860000000E+04, 3.4636671144E+01, 5.1592664022E+00, 1.6294827711E+01, 3.5203048506E+00, 9.6849838549E-01],
	[4.0865000000E+04, 3.4644071130E+01, 5.1593007124E+00, 1.6301320920E+01, 3.5207002256E+00, 9.6851180844E-01],
	[4.0870000000E+04, 3.4651471791E+01, 5.1593350187E+00, 1.6307815920E+01, 3.5210955039E+00, 9.6852522483E-01],
	[4.0875000000E+04, 3.4658873127E+01, 5.1593693209E+00, 1.6314312711E+01, 3.5214906854E+00, 9.6853863467E-01],
	[4.0880000000E+04, 3.4666275138E+01, 5.1594036193E+00, 1.6320811293E+01, 3.5218857701E+00, 9.6855203794E-01],
	[4.0885000000E+04, 3.4673677825E+01, 5.1594379136E+00, 1.6327311667E+01, 3.5222807582E+00, 9.6856543467E-01],
	[4.0890000000E+04, 3.4681081187E+01, 5.1594722040E+00, 1.6333813833E+01, 3.5226756495E+00, 9.6857882485E-01],
	[4.0895000000E+04, 3.4688485224E+01, 5.1595064905E+00, 1.6340317791E+01, 3.5230704441E+00, 9.6859220849E-01],
	[4.0900000000E+04, 3.4695889937E+01, 5.1595407729E+00, 1.6346823541E+01, 3.5234651421E+00, 9.6860558558E-01],
	[4.0905000000E+04, 3.4703295324E+01, 5.1595750514E+00, 1.6353331085E+01, 3.5238597434E+00, 9.6861895614E-01],
	[4.0910000000E+04, 3.4710701387E+01, 5.1596093260E+00, 1.6359840421E+01, 3.5242542481E+00, 9.6863232017E-01],
	[4.0915000000E+04, 3.4718108125E+01, 5.1596435966E+00, 1.6366351551E+01, 3.5246486562E+00, 9.6864567767E-01],
	[4.0920000000E+04, 3.4725515538E+01, 5.1596778632E+00, 1.6372864474E+01, 3.5250429677E+00, 9.6865902864E-01],
	[4.0925000000E+04, 3.4732923626E+01, 5.1597121258E+00, 1.6379379191E+01, 3.5254371826E+00, 9.6867237310E-01],
	[4.0930000000E+04, 3.4740332389E+01, 5.1597463845E+00, 1.6385895702E+01, 3.5258313010E+00, 9.6868571103E-01],
	[4.0935000000E+04, 3.4747741827E+01, 5.1597806393E+00, 1.6392414007E+01, 3.5262253228E+00, 9.6869904245E-01],
	[4.0940000000E+04, 3.4755151941E+01, 5.1598148901E+00, 1.6398934107E+01, 3.5266192481E+00, 9.6871236736E-01],
	[4.0945000000E+04, 3.4762562729E+01, 5.1598491369E+00, 1.6405456002E+01, 3.5270130769E+00, 9.6872568576E-01],
	[4.0950000000E+04, 3.4769974192E+01, 5.1598833798E+00, 1.6411979693E+01, 3.5274068092E+00, 9.6873899766E-01],
	[4.0955000000E+04, 3.4777386330E+01, 5.1599176187E+00, 1.6418505178E+01, 3.5278004451E+00, 9.6875230305E-01],
	[4.0960000000E+04, 3.4784799143E+01, 5.1599518537E+00, 1.6425032460E+01, 3.5281939845E+00, 9.6876560195E-01],
	[4.0965000000E+04, 3.4792212631E+01, 5.1599860847E+00, 1.6431561537E+01, 3.5285874275E+00, 9.6877889436E-01],
	[4.0970000000E+04, 3.4799626794E+01, 5.1600203118E+00, 1.6438092411E+01, 3.5289807741E+00, 9.6879218028E-01],
	[4.0975000000E+04, 3.4807041632E+01, 5.1600545349E+00, 1.6444625082E+01, 3.5293740243E+00, 9.6880545971E-01],
	[4.0980000000E+04, 3.4814457145E+01, 5.1600887541E+00, 1.6451159549E+01, 3.5297671782E+00, 9.6881873266E-01],
	[4.0985000000E+04, 3.4821873333E+01, 5.1601229693E+00, 1.6457695813E+01, 3.5301602357E+00, 9.6883199913E-01],
	[4.0990000000E+04, 3.4829290195E+01, 5.1601571806E+00, 1.6464233875E+01, 3.5305531969E+00, 9.6884525912E-01],
	[4.0995000000E+04, 3.4836707732E+01, 5.1601913879E+00, 1.6470773735E+01, 3.5309460617E+00, 9.6885851265E-01],
	[4.1000000000E+04, 3.4844125944E+01, 5.1602255913E+00, 1.6477315392E+01, 3.5313388303E+00, 9.6887175970E-01],
	[4.1005000000E+04, 3.4851544831E+01, 5.1602597907E+00, 1.6483858848E+01, 3.5317315026E+00, 9.6888500030E-01],
	[4.1010000000E+04, 3.4858964392E+01, 5.1602939862E+00, 1.6490404102E+01, 3.5321240786E+00, 9.6889823443E-01],
	[4.1015000000E+04, 3.4866384628E+01, 5.1603281778E+00, 1.6496951155E+01, 3.5325165584E+00, 9.6891146210E-01],
	[4.1020000000E+04, 3.4873805539E+01, 5.1603623654E+00, 1.6503500007E+01, 3.5329089420E+00, 9.6892468332E-01],
	[4.1025000000E+04, 3.4881227125E+01, 5.1603965491E+00, 1.6510050658E+01, 3.5333012294E+00, 9.6893789809E-01],
	[4.1030000000E+04, 3.4888649385E+01, 5.1604307288E+00, 1.6516603109E+01, 3.5336934207E+00, 9.6895110641E-01],
	[4.1035000000E+04, 3.4896072320E+01, 5.1604649046E+00, 1.6523157360E+01, 3.5340855157E+00, 9.6896430829E-01],
	[4.1040000000E+04, 3.4903495929E+01, 5.1604990765E+00, 1.6529713410E+01, 3.5344775146E+00, 9.6897750373E-01],
	[4.1045000000E+04, 3.4910920213E+01, 5.1605332444E+00, 1.6536271262E+01, 3.5348694174E+00, 9.6899069274E-01],
	[4.1050000000E+04, 3.4918345172E+01, 5.1605674084E+00, 1.6542830914E+01, 3.5352612241E+00, 9.6900387531E-01],
	[4.1055000000E+04, 3.4925770805E+01, 5.1606015684E+00, 1.6549392367E+01, 3.5356529347E+00, 9.6901705145E-01],
	[4.1060000000E+04, 3.4933197113E+01, 5.1606357245E+00, 1.6555955621E+01, 3.5360445493E+00, 9.6903022117E-01],
	[4.1065000000E+04, 3.4940624095E+01, 5.1606698767E+00, 1.6562520677E+01, 3.5364360678E+00, 9.6904338447E-01],
	[4.1070000000E+04, 3.4948051752E+01, 5.1607040250E+00, 1.6569087534E+01, 3.5368274903E+00, 9.6905654135E-01],
	[4.1075000000E+04, 3.4955480083E+01, 5.1607381693E+00, 1.6575656194E+01, 3.5372188168E+00, 9.6906969181E-01],
	[4.1080000000E+04, 3.4962909088E+01, 5.1607723097E+00, 1.6582226656E+01, 3.5376100472E+00, 9.6908283587E-01],
	[4.1085000000E+04, 3.4970338768E+01, 5.1608064461E+00, 1.6588798920E+01, 3.5380011817E+00, 9.6909597351E-01],
	[4.1090000000E+04, 3.4977769123E+01, 5.1608405787E+00, 1.6595372987E+01, 3.5383922203E+00, 9.6910910476E-01],
	[4.1095000000E+04, 3.4985200152E+01, 5.1608747073E+00, 1.6601948858E+01, 3.5387831629E+00, 9.6912222960E-01],
	[4.1100000000E+04, 3.4992631855E+01, 5.1609088320E+00, 1.6608526532E+01, 3.5391740097E+00, 9.6913534804E-01],
	[4.1105000000E+04, 3.5000064232E+01, 5.1609429527E+00, 1.6615106010E+01, 3.5395647605E+00, 9.6914846010E-01],
	[4.1110000000E+04, 3.5007497284E+01, 5.1609770695E+00, 1.6621687291E+01, 3.5399554154E+00, 9.6916156576E-01],
	[4.1115000000E+04, 3.5014931010E+01, 5.1610111824E+00, 1.6628270377E+01, 3.5403459745E+00, 9.6917466504E-01],
	[4.1120000000E+04, 3.5022365411E+01, 5.1610452914E+00, 1.6634855268E+01, 3.5407364378E+00, 9.6918775793E-01],
	[4.1125000000E+04, 3.5029800485E+01, 5.1610793965E+00, 1.6641441963E+01, 3.5411268052E+00, 9.6920084444E-01],
	[4.1130000000E+04, 3.5037236234E+01, 5.1611134976E+00, 1.6648030463E+01, 3.5415170769E+00, 9.6921392458E-01],
	[4.1135000000E+04, 3.5044672657E+01, 5.1611475948E+00, 1.6654620769E+01, 3.5419072527E+00, 9.6922699835E-01],
	[4.1140000000E+04, 3.5052109755E+01, 5.1611816881E+00, 1.6661212881E+01, 3.5422973328E+00, 9.6924006575E-01],
	[4.1145000000E+04, 3.5059547526E+01, 5.1612157775E+00, 1.6667806798E+01, 3.5426873172E+00, 9.6925312678E-01],
	[4.1150000000E+04, 3.5066985972E+01, 5.1612498630E+00, 1.6674402521E+01, 3.5430772058E+00, 9.6926618146E-01],
	[4.1155000000E+04, 3.5074425091E+01, 5.1612839445E+00, 1.6681000051E+01, 3.5434669988E+00, 9.6927922977E-01],
	[4.1160000000E+04, 3.5081864885E+01, 5.1613180222E+00, 1.6687599388E+01, 3.5438566960E+00, 9.6929227173E-01],
	[4.1165000000E+04, 3.5089314013E+01, 5.1613531943E+00, 1.6694200531E+01, 3.5442469039E+00, 9.6930530734E-01],
	[4.1170000000E+04, 3.5096771658E+01, 5.1613893565E+00, 1.6700803482E+01, 3.5446375651E+00, 9.6931833661E-01],
	[4.1175000000E+04, 3.5104229982E+01, 5.1614255146E+00, 1.6707408241E+01, 3.5450281310E+00, 9.6933135952E-01],
	[4.1180000000E+04, 3.5111688985E+01, 5.1614616685E+00, 1.6714014807E+01, 3.5454186016E+00, 9.6934437610E-01],
	[4.1185000000E+04, 3.5119148666E+01, 5.1614978183E+00, 1.6720623181E+01, 3.5458089768E+00, 9.6935738635E-01],
	[4.1190000000E+04, 3.5126609027E+01, 5.1615339640E+00, 1.6727233364E+01, 3.5461992568E+00, 9.6937039026E-01],
	[4.1195000000E+04, 3.5134070067E+01, 5.1615701055E+00, 1.6733845356E+01, 3.5465894415E+00, 9.6938338783E-01],
	[4.1200000000E+04, 3.5141531786E+01, 5.1616062429E+00, 1.6740459156E+01, 3.5469795309E+00, 9.6939637909E-01],
	[4.1205000000E+04, 3.5148994183E+01, 5.1616423762E+00, 1.6747074765E+01, 3.5473695251E+00, 9.6940936401E-01],
	[4.1210000000E+04, 3.5156457260E+01, 5.1616785053E+00, 1.6753692184E+01, 3.5477594241E+00, 9.6942234262E-01],
	[4.1215000000E+04, 3.5163921015E+01, 5.1617146304E+00, 1.6760311413E+01, 3.5481492279E+00, 9.6943531490E-01],
	[4.1220000000E+04, 3.5171385449E+01, 5.1617507512E+00, 1.6766932452E+01, 3.5485389365E+00, 9.6944828087E-01],
	[4.1225000000E+04, 3.5178850562E+01, 5.1617868680E+00, 1.6773555301E+01, 3.5489285500E+00, 9.6946124053E-01],
	[4.1230000000E+04, 3.5186316354E+01, 5.1618229806E+00, 1.6780179961E+01, 3.5493180684E+00, 9.6947419387E-01],
	[4.1235000000E+04, 3.5193782825E+01, 5.1618590891E+00, 1.6786806431E+01, 3.5497074916E+00, 9.6948714091E-01],
	[4.1240000000E+04, 3.5201249975E+01, 5.1618951935E+00, 1.6793434713E+01, 3.5500968197E+00, 9.6950008165E-01],
	[4.1245000000E+04, 3.5208717803E+01, 5.1619312937E+00, 1.6800064806E+01, 3.5504860527E+00, 9.6951301608E-01],
	[4.1250000000E+04, 3.5216186310E+01, 5.1619673898E+00, 1.6806696710E+01, 3.5508751907E+00, 9.6952594422E-01],
	[4.1255000000E+04, 3.5223655496E+01, 5.1620034818E+00, 1.6813330427E+01, 3.5512642337E+00, 9.6953886606E-01],
	[4.1260000000E+04, 3.5231125360E+01, 5.1620395697E+00, 1.6819965956E+01, 3.5516531816E+00, 9.6955178161E-01],
	[4.1265000000E+04, 3.5238595903E+01, 5.1620756535E+00, 1.6826603297E+01, 3.5520420345E+00, 9.6956469087E-01],
	[4.1270000000E+04, 3.5246067125E+01, 5.1621117331E+00, 1.6833242451E+01, 3.5524307924E+00, 9.6957759385E-01],
	[4.1275000000E+04, 3.5253539025E+01, 5.1621478086E+00, 1.6839883418E+01, 3.5528194554E+00, 9.6959049054E-01],
	[4.1280000000E+04, 3.5261011604E+01, 5.1621838800E+00, 1.6846526199E+01, 3.5532080234E+00, 9.6960338096E-01],
	[4.1285000000E+04, 3.5268484862E+01, 5.1622199473E+00, 1.6853170793E+01, 3.5535964965E+00, 9.6961626510E-01],
	[4.1290000000E+04, 3.5275958798E+01, 5.1622560105E+00, 1.6859817201E+01, 3.5539848747E+00, 9.6962914296E-01],
	[4.1295000000E+04, 3.5283433413E+01, 5.1622920695E+00, 1.6866465423E+01, 3.5543731580E+00, 9.6964201456E-01],
	[4.1300000000E+04, 3.5290908706E+01, 5.1623281245E+00, 1.6873115459E+01, 3.5547613464E+00, 9.6965487989E-01],
	[4.1305000000E+04, 3.5298384678E+01, 5.1623641753E+00, 1.6879767311E+01, 3.5551494400E+00, 9.6966773895E-01],
	[4.1310000000E+04, 3.5305861328E+01, 5.1624002220E+00, 1.6886420977E+01, 3.5555374387E+00, 9.6968059176E-01],
	[4.1315000000E+04, 3.5313338657E+01, 5.1624362646E+00, 1.6893076458E+01, 3.5559253427E+00, 9.6969343831E-01],
	[4.1320000000E+04, 3.5320816664E+01, 5.1624723031E+00, 1.6899733755E+01, 3.5563131518E+00, 9.6970627860E-01],
	[4.1325000000E+04, 3.5328295350E+01, 5.1625083375E+00, 1.6906392868E+01, 3.5567008661E+00, 9.6971911264E-01],
	[4.1330000000E+04, 3.5335774714E+01, 5.1625443678E+00, 1.6913053796E+01, 3.5570884857E+00, 9.6973194043E-01],
	[4.1335000000E+04, 3.5343254756E+01, 5.1625803939E+00, 1.6919716541E+01, 3.5574760106E+00, 9.6974476198E-01],
	[4.1340000000E+04, 3.5350735477E+01, 5.1626164160E+00, 1.6926381103E+01, 3.5578634407E+00, 9.6975757728E-01],
	[4.1345000000E+04, 3.5358216876E+01, 5.1626524340E+00, 1.6933047482E+01, 3.5582507762E+00, 9.6977038635E-01],
	[4.1350000000E+04, 3.5365698954E+01, 5.1626884478E+00, 1.6939715677E+01, 3.5586380169E+00, 9.6978318918E-01],
	[4.1355000000E+04, 3.5373181710E+01, 5.1627244576E+00, 1.6946385691E+01, 3.5590251630E+00, 9.6979598577E-01],
	[4.1360000000E+04, 3.5380665144E+01, 5.1627604632E+00, 1.6953057522E+01, 3.5594122145E+00, 9.6980877614E-01],
	[4.1365000000E+04, 3.5388149256E+01, 5.1627964648E+00, 1.6959731170E+01, 3.5597991713E+00, 9.6982156028E-01],
	[4.1370000000E+04, 3.5395634047E+01, 5.1628324622E+00, 1.6966406638E+01, 3.5601860336E+00, 9.6983433819E-01],
	[4.1375000000E+04, 3.5403119516E+01, 5.1628684556E+00, 1.6973083923E+01, 3.5605728012E+00, 9.6984710989E-01],
	[4.1380000000E+04, 3.5410605663E+01, 5.1629044448E+00, 1.6979763028E+01, 3.5609594743E+00, 9.6985987536E-01],
	[4.1385000000E+04, 3.5418092488E+01, 5.1629404299E+00, 1.6986443951E+01, 3.5613460528E+00, 9.6987263462E-01],
	[4.1390000000E+04, 3.5425579991E+01, 5.1629764110E+00, 1.6993126694E+01, 3.5617325368E+00, 9.6988538767E-01],
	[4.1395000000E+04, 3.5433068173E+01, 5.1630123880E+00, 1.6999811257E+01, 3.5621189263E+00, 9.6989813452E-01],
	[4.1400000000E+04, 3.5440557033E+01, 5.1630483608E+00, 1.7006497640E+01, 3.5625052213E+00, 9.6991087515E-01],
	[4.1405000000E+04, 3.5448046570E+01, 5.1630843296E+00, 1.7013185842E+01, 3.5628914219E+00, 9.6992360959E-01],
	[4.1410000000E+04, 3.5455536786E+01, 5.1631202943E+00, 1.7019875865E+01, 3.5632775279E+00, 9.6993633782E-01],
	[4.1415000000E+04, 3.5463027680E+01, 5.1631562549E+00, 1.7026567709E+01, 3.5636635396E+00, 9.6994905986E-01],
	[4.1420000000E+04, 3.5470519252E+01, 5.1631922114E+00, 1.7033261374E+01, 3.5640494568E+00, 9.6996177570E-01],
	[4.1425000000E+04, 3.5478011502E+01, 5.1632281638E+00, 1.7039956860E+01, 3.5644352797E+00, 9.6997448536E-01],
	[4.1430000000E+04, 3.5485504430E+01, 5.1632641121E+00, 1.7046654168E+01, 3.5648210081E+00, 9.6998718883E-01],
	[4.1435000000E+04, 3.5492998036E+01, 5.1633000563E+00, 1.7053353298E+01, 3.5652066422E+00, 9.6999988611E-01],
	[4.1440000000E+04, 3.5500492320E+01, 5.1633359964E+00, 1.7060054249E+01, 3.5655921820E+00, 9.7001257721E-01],
	[4.1445000000E+04, 3.5507987282E+01, 5.1633719325E+00, 1.7066757024E+01, 3.5659776275E+00, 9.7002526214E-01],
	[4.1450000000E+04, 3.5515482922E+01, 5.1634078645E+00, 1.7073461620E+01, 3.5663629786E+00, 9.7003794089E-01],
	[4.1455000000E+04, 3.5522979239E+01, 5.1634437923E+00, 1.7080168040E+01, 3.5667482355E+00, 9.7005061347E-01],
	[4.1460000000E+04, 3.5530476235E+01, 5.1634797162E+00, 1.7086876283E+01, 3.5671333981E+00, 9.7006327988E-01],
	[4.1465000000E+04, 3.5537973908E+01, 5.1635156359E+00, 1.7093586349E+01, 3.5675184665E+00, 9.7007594012E-01],
	[4.1470000000E+04, 3.5545472259E+01, 5.1635515515E+00, 1.7100298239E+01, 3.5679034406E+00, 9.7008859421E-01],
	[4.1475000000E+04, 3.5552971289E+01, 5.1635874631E+00, 1.7107011954E+01, 3.5682883206E+00, 9.7010124213E-01],
	[4.1480000000E+04, 3.5560470995E+01, 5.1636233705E+00, 1.7113727492E+01, 3.5686731063E+00, 9.7011388389E-01],
	[4.1485000000E+04, 3.5567971380E+01, 5.1636592739E+00, 1.7120444855E+01, 3.5690577979E+00, 9.7012651951E-01],
	[4.1490000000E+04, 3.5575472442E+01, 5.1636951733E+00, 1.7127164043E+01, 3.5694423954E+00, 9.7013914897E-01],
	[4.1495000000E+04, 3.5582974183E+01, 5.1637310685E+00, 1.7133885056E+01, 3.5698268987E+00, 9.7015177228E-01],
	[4.1500000000E+04, 3.5590476600E+01, 5.1637669597E+00, 1.7140607895E+01, 3.5702113079E+00, 9.7016438946E-01],
	[4.1505000000E+04, 3.5597979696E+01, 5.1638028468E+00, 1.7147332559E+01, 3.5705956231E+00, 9.7017700049E-01],
	[4.1510000000E+04, 3.5605483469E+01, 5.1638387298E+00, 1.7154059049E+01, 3.5709798441E+00, 9.7018960538E-01],
	[4.1515000000E+04, 3.5612987920E+01, 5.1638746088E+00, 1.7160787365E+01, 3.5713639711E+00, 9.7020220414E-01],
	[4.1520000000E+04, 3.5620493049E+01, 5.1639104836E+00, 1.7167517508E+01, 3.5717480041E+00, 9.7021479676E-01],
	[4.1525000000E+04, 3.5627998855E+01, 5.1639463544E+00, 1.7174249478E+01, 3.5721319431E+00, 9.7022738326E-01],
	[4.1530000000E+04, 3.5635505338E+01, 5.1639822212E+00, 1.7180983275E+01, 3.5725157881E+00, 9.7023996363E-01],
	[4.1535000000E+04, 3.5643012500E+01, 5.1640180839E+00, 1.7187718899E+01, 3.5728995391E+00, 9.7025253788E-01],
	[4.1540000000E+04, 3.5650520339E+01, 5.1640539425E+00, 1.7194456351E+01, 3.5732831961E+00, 9.7026510600E-01],
	[4.1545000000E+04, 3.5658028855E+01, 5.1640897970E+00, 1.7201195630E+01, 3.5736667592E+00, 9.7027766802E-01],
	[4.1550000000E+04, 3.5665538049E+01, 5.1641256475E+00, 1.7207936738E+01, 3.5740502284E+00, 9.7029022391E-01],
	[4.1555000000E+04, 3.5673047920E+01, 5.1641614939E+00, 1.7214679674E+01, 3.5744336037E+00, 9.7030277370E-01],
	[4.1560000000E+04, 3.5680558469E+01, 5.1641973362E+00, 1.7221424439E+01, 3.5748168852E+00, 9.7031531738E-01],
	[4.1565000000E+04, 3.5688069695E+01, 5.1642331745E+00, 1.7228171033E+01, 3.5752000727E+00, 9.7032785496E-01],
	[4.1570000000E+04, 3.5695581599E+01, 5.1642690087E+00, 1.7234919456E+01, 3.5755831665E+00, 9.7034038643E-01],
	[4.1575000000E+04, 3.5703094180E+01, 5.1643048388E+00, 1.7241669709E+01, 3.5759661664E+00, 9.7035291181E-01],
	[4.1580000000E+04, 3.5710607439E+01, 5.1643406649E+00, 1.7248421791E+01, 3.5763490725E+00, 9.7036543109E-01],
	[4.1585000000E+04, 3.5718121375E+01, 5.1643764870E+00, 1.7255175704E+01, 3.5767318848E+00, 9.7037794428E-01],
	[4.1590000000E+04, 3.5725635988E+01, 5.1644123049E+00, 1.7261931447E+01, 3.5771146034E+00, 9.7039045138E-01],
	[4.1595000000E+04, 3.5733151278E+01, 5.1644481189E+00, 1.7268689020E+01, 3.5774972282E+00, 9.7040295239E-01],
	[4.1600000000E+04, 3.5740667246E+01, 5.1644839287E+00, 1.7275448425E+01, 3.5778797593E+00, 9.7041544732E-01],
	[4.1605000000E+04, 3.5748183891E+01, 5.1645197345E+00, 1.7282209660E+01, 3.5782621967E+00, 9.7042793617E-01],
	[4.1610000000E+04, 3.5755701214E+01, 5.1645555363E+00, 1.7288972728E+01, 3.5786445404E+00, 9.7044041895E-01],
	[4.1615000000E+04, 3.5763219213E+01, 5.1645913340E+00, 1.7295737626E+01, 3.5790267904E+00, 9.7045289565E-01],
	[4.1620000000E+04, 3.5770737890E+01, 5.1646271276E+00, 1.7302504357E+01, 3.5794089468E+00, 9.7046536628E-01],
	[4.1625000000E+04, 3.5778257244E+01, 5.1646629172E+00, 1.7309272921E+01, 3.5797910096E+00, 9.7047783084E-01],
	[4.1630000000E+04, 3.5785777276E+01, 5.1646987028E+00, 1.7316043316E+01, 3.5801729788E+00, 9.7049028933E-01],
	[4.1635000000E+04, 3.5793297984E+01, 5.1647344843E+00, 1.7322815545E+01, 3.5805548543E+00, 9.7050274177E-01],
	[4.1640000000E+04, 3.5800819370E+01, 5.1647702617E+00, 1.7329589607E+01, 3.5809366363E+00, 9.7051518815E-01],
	[4.1645000000E+04, 3.5808341432E+01, 5.1648060351E+00, 1.7336365502E+01, 3.5813183248E+00, 9.7052762847E-01],
	[4.1650000000E+04, 3.5815864172E+01, 5.1648418044E+00, 1.7343143230E+01, 3.5816999197E+00, 9.7054006274E-01],
	[4.1655000000E+04, 3.5823387589E+01, 5.1648775697E+00, 1.7349922793E+01, 3.5820814211E+00, 9.7055249095E-01],
	[4.1660000000E+04, 3.5830911683E+01, 5.1649133310E+00, 1.7356704190E+01, 3.5824628290E+00, 9.7056491313E-01],
	[4.1665000000E+04, 3.5838436454E+01, 5.1649490882E+00, 1.7363487422E+01, 3.5828441435E+00, 9.7057732926E-01],
	[4.1670000000E+04, 3.5845961902E+01, 5.1649848414E+00, 1.7370272488E+01, 3.5832253645E+00, 9.7058973935E-01],
	[4.1675000000E+04, 3.5853488027E+01, 5.1650205905E+00, 1.7377059389E+01, 3.5836064920E+00, 9.7060214340E-01],
	[4.1680000000E+04, 3.5861014829E+01, 5.1650563356E+00, 1.7383848125E+01, 3.5839875262E+00, 9.7061454142E-01],
	[4.1685000000E+04, 3.5868542308E+01, 5.1650920766E+00, 1.7390638698E+01, 3.5843684669E+00, 9.7062693340E-01],
	[4.1690000000E+04, 3.5876070464E+01, 5.1651278136E+00, 1.7397431106E+01, 3.5847493143E+00, 9.7063931936E-01],
	[4.1695000000E+04, 3.5883599297E+01, 5.1651635466E+00, 1.7404225350E+01, 3.5851300683E+00, 9.7065169930E-01],
	[4.1700000000E+04, 3.5891128807E+01, 5.1651992755E+00, 1.7411021430E+01, 3.5855107290E+00, 9.7066407321E-01],
	[4.1705000000E+04, 3.5898658993E+01, 5.1652350004E+00, 1.7417819348E+01, 3.5858912963E+00, 9.7067644110E-01],
	[4.1710000000E+04, 3.5906189857E+01, 5.1652707213E+00, 1.7424619102E+01, 3.5862717704E+00, 9.7068880298E-01],
	[4.1715000000E+04, 3.5913721397E+01, 5.1653064381E+00, 1.7431420693E+01, 3.5866521512E+00, 9.7070115884E-01],
	[4.1720000000E+04, 3.5921253614E+01, 5.1653421509E+00, 1.7438224122E+01, 3.5870324387E+00, 9.7071350869E-01],
	[4.1725000000E+04, 3.5928786508E+01, 5.1653778597E+00, 1.7445029389E+01, 3.5874126330E+00, 9.7072585254E-01],
	[4.1730000000E+04, 3.5936320079E+01, 5.1654135644E+00, 1.7451836494E+01, 3.5877927340E+00, 9.7073819038E-01],
	[4.1735000000E+04, 3.5943854326E+01, 5.1654492651E+00, 1.7458645437E+01, 3.5881727419E+00, 9.7075052223E-01],
	[4.1740000000E+04, 3.5951389250E+01, 5.1654849617E+00, 1.7465456219E+01, 3.5885526565E+00, 9.7076284807E-01],
	[4.1745000000E+04, 3.5958924851E+01, 5.1655206544E+00, 1.7472268840E+01, 3.5889324781E+00, 9.7077516792E-01],
	[4.1750000000E+04, 3.5966461129E+01, 5.1655563430E+00, 1.7479083300E+01, 3.5893122064E+00, 9.7078748178E-01],
	[4.1755000000E+04, 3.5973998083E+01, 5.1655920276E+00, 1.7485899599E+01, 3.5896918416E+00, 9.7079978965E-01],
	[4.1760000000E+04, 3.5981535714E+01, 5.1656277081E+00, 1.7492717738E+01, 3.5900713838E+00, 9.7081209153E-01],
	[4.1765000000E+04, 3.5989074022E+01, 5.1656633846E+00, 1.7499537717E+01, 3.5904508328E+00, 9.7082438744E-01],
	[4.1770000000E+04, 3.5996613006E+01, 5.1656990571E+00, 1.7506359537E+01, 3.5908301888E+00, 9.7083667736E-01],
	[4.1775000000E+04, 3.6004152667E+01, 5.1657347256E+00, 1.7513183196E+01, 3.5912094517E+00, 9.7084896130E-01],
	[4.1780000000E+04, 3.6011693004E+01, 5.1657703901E+00, 1.7520008697E+01, 3.5915886216E+00, 9.7086123928E-01],
	[4.1785000000E+04, 3.6019234018E+01, 5.1658060505E+00, 1.7526836039E+01, 3.5919676985E+00, 9.7087351128E-01],
	[4.1790000000E+04, 3.6026775708E+01, 5.1658417069E+00, 1.7533665222E+01, 3.5923466824E+00, 9.7088577731E-01],
	[4.1795000000E+04, 3.6034318075E+01, 5.1658773593E+00, 1.7540496247E+01, 3.5927255733E+00, 9.7089803739E-01],
	[4.1800000000E+04, 3.6041861119E+01, 5.1659130077E+00, 1.7547329114E+01, 3.5931043713E+00, 9.7091029149E-01],
	[4.1805000000E+04, 3.6049404839E+01, 5.1659486520E+00, 1.7554163823E+01, 3.5934830764E+00, 9.7092253965E-01],
	[4.1810000000E+04, 3.6056949235E+01, 5.1659842924E+00, 1.7561000374E+01, 3.5938616885E+00, 9.7093478184E-01],
	[4.1815000000E+04, 3.6064494308E+01, 5.1660199287E+00, 1.7567838769E+01, 3.5942402077E+00, 9.7094701809E-01],
	[4.1820000000E+04, 3.6072040057E+01, 5.1660555610E+00, 1.7574679006E+01, 3.5946186341E+00, 9.7095924838E-01],
	[4.1825000000E+04, 3.6079586483E+01, 5.1660911893E+00, 1.7581521086E+01, 3.5949969676E+00, 9.7097147273E-01],
	[4.1830000000E+04, 3.6087149875E+01, 5.1661288457E+00, 1.7588365011E+01, 3.5953763543E+00, 9.7098369114E-01],
	[4.1835000000E+04, 3.6094714060E+01, 5.1661665117E+00, 1.7595210779E+01, 3.5957556562E+00, 9.7099590360E-01],
	[4.1840000000E+04, 3.6102278926E+01, 5.1662041735E+00, 1.7602058391E+01, 3.5961348655E+00, 9.7100811013E-01],
	[4.1845000000E+04, 3.6109844473E+01, 5.1662418311E+00, 1.7608907847E+01, 3.5965139824E+00, 9.7102031072E-01],
	[4.1850000000E+04, 3.6117410701E+01, 5.1662794844E+00, 1.7615759148E+01, 3.5968930067E+00, 9.7103250539E-01],
	[4.1855000000E+04, 3.6124977611E+01, 5.1663171335E+00, 1.7622612295E+01, 3.5972719386E+00, 9.7104469412E-01],
	[4.1860000000E+04, 3.6132545202E+01, 5.1663547784E+00, 1.7629467286E+01, 3.5976507780E+00, 9.7105687693E-01],
	[4.1865000000E+04, 3.6140113473E+01, 5.1663924190E+00, 1.7636324123E+01, 3.5980295250E+00, 9.7106905382E-01],
	[4.1870000000E+04, 3.6147682426E+01, 5.1664300554E+00, 1.7643182806E+01, 3.5984081796E+00, 9.7108122479E-01],
	[4.1875000000E+04, 3.6155252060E+01, 5.1664676877E+00, 1.7650043335E+01, 3.5987867418E+00, 9.7109338985E-01],
	[4.1880000000E+04, 3.6162822375E+01, 5.1665053156E+00, 1.7656905710E+01, 3.5991652116E+00, 9.7110554899E-01],
	[4.1885000000E+04, 3.6170393371E+01, 5.1665429394E+00, 1.7663769931E+01, 3.5995435890E+00, 9.7111770222E-01],
	[4.1890000000E+04, 3.6177965049E+01, 5.1665805590E+00, 1.7670636000E+01, 3.5999218742E+00, 9.7112984954E-01],
	[4.1895000000E+04, 3.6185537407E+01, 5.1666181743E+00, 1.7677503916E+01, 3.6003000670E+00, 9.7114199097E-01],
	[4.1900000000E+04, 3.6193110446E+01, 5.1666557855E+00, 1.7684373679E+01, 3.6006781675E+00, 9.7115412649E-01],
	[4.1905000000E+04, 3.6200684166E+01, 5.1666933924E+00, 1.7691245290E+01, 3.6010561757E+00, 9.7116625611E-01],
	[4.1910000000E+04, 3.6208258567E+01, 5.1667309951E+00, 1.7698118749E+01, 3.6014340916E+00, 9.7117837984E-01],
	[4.1915000000E+04, 3.6215833649E+01, 5.1667685936E+00, 1.7704994056E+01, 3.6018119154E+00, 9.7119049767E-01],
	[4.1920000000E+04, 3.6223409412E+01, 5.1668061878E+00, 1.7711871212E+01, 3.6021896469E+00, 9.7120260962E-01],
	[4.1925000000E+04, 3.6230985856E+01, 5.1668437779E+00, 1.7718750216E+01, 3.6025672862E+00, 9.7121471568E-01],
	[4.1930000000E+04, 3.6238562981E+01, 5.1668813638E+00, 1.7725631070E+01, 3.6029448333E+00, 9.7122681586E-01],
	[4.1935000000E+04, 3.6246140787E+01, 5.1669189454E+00, 1.7732513773E+01, 3.6033222882E+00, 9.7123891016E-01],
	[4.1940000000E+04, 3.6253719273E+01, 5.1669565228E+00, 1.7739398326E+01, 3.6036996510E+00, 9.7125099858E-01],
	[4.1945000000E+04, 3.6261298440E+01, 5.1669940961E+00, 1.7746284728E+01, 3.6040769217E+00, 9.7126308113E-01],
	[4.1950000000E+04, 3.6268878289E+01, 5.1670316651E+00, 1.7753172981E+01, 3.6044541003E+00, 9.7127515781E-01],
	[4.1955000000E+04, 3.6276458817E+01, 5.1670692299E+00, 1.7760063084E+01, 3.6048311868E+00, 9.7128722862E-01],
	[4.1960000000E+04, 3.6284040027E+01, 5.1671067906E+00, 1.7766955038E+01, 3.6052081812E+00, 9.7129929357E-01],
	[4.1965000000E+04, 3.6291621917E+01, 5.1671443470E+00, 1.7773848843E+01, 3.6055850836E+00, 9.7131135266E-01],
	[4.1970000000E+04, 3.6299204488E+01, 5.1671818992E+00, 1.7780744500E+01, 3.6059618939E+00, 9.7132340588E-01],
	[4.1975000000E+04, 3.6306787740E+01, 5.1672194472E+00, 1.7787642008E+01, 3.6063386122E+00, 9.7133545326E-01],
	[4.1980000000E+04, 3.6314371673E+01, 5.1672569910E+00, 1.7794541367E+01, 3.6067152386E+00, 9.7134749477E-01],
	[4.1985000000E+04, 3.6321956286E+01, 5.1672945307E+00, 1.7801442579E+01, 3.6070917730E+00, 9.7135953044E-01],
	[4.1990000000E+04, 3.6329541580E+01, 5.1673320661E+00, 1.7808345643E+01, 3.6074682154E+00, 9.7137156027E-01],
	[4.1995000000E+04, 3.6337127554E+01, 5.1673695973E+00, 1.7815250560E+01, 3.6078445659E+00, 9.7138358425E-01],
	[4.2000000000E+04, 3.6344714209E+01, 5.1674071243E+00, 1.7822157330E+01, 3.6082208245E+00, 9.7139560239E-01],
	[4.2005000000E+04, 3.6352301545E+01, 5.1674446472E+00, 1.7829065953E+01, 3.6085969911E+00, 9.7140761469E-01],
	[4.2010000000E+04, 3.6359889561E+01, 5.1674821658E+00, 1.7835976430E+01, 3.6089730660E+00, 9.7141962116E-01],
	[4.2015000000E+04, 3.6367478257E+01, 5.1675196802E+00, 1.7842888761E+01, 3.6093490489E+00, 9.7143162179E-01],
	[4.2020000000E+04, 3.6375067634E+01, 5.1675571905E+00, 1.7849802945E+01, 3.6097249400E+00, 9.7144361660E-01],
	[4.2025000000E+04, 3.6382657692E+01, 5.1675946966E+00, 1.7856718984E+01, 3.6101007394E+00, 9.7145560558E-01],
	[4.2030000000E+04, 3.6390248430E+01, 5.1676321984E+00, 1.7863636877E+01, 3.6104764469E+00, 9.7146758874E-01],
	[4.2035000000E+04, 3.6397839849E+01, 5.1676696961E+00, 1.7870556626E+01, 3.6108520626E+00, 9.7147956608E-01],
	[4.2040000000E+04, 3.6405431948E+01, 5.1677071896E+00, 1.7877478229E+01, 3.6112275866E+00, 9.7149153760E-01],
	[4.2045000000E+04, 3.6413024727E+01, 5.1677446789E+00, 1.7884401688E+01, 3.6116030188E+00, 9.7150350332E-01],
	[4.2050000000E+04, 3.6420618187E+01, 5.1677821641E+00, 1.7891327003E+01, 3.6119783594E+00, 9.7151546322E-01],
	[4.2055000000E+04, 3.6428212328E+01, 5.1678196450E+00, 1.7898254173E+01, 3.6123536082E+00, 9.7152741731E-01],
	[4.2060000000E+04, 3.6435807148E+01, 5.1678571218E+00, 1.7905183200E+01, 3.6127287653E+00, 9.7153936560E-01],
	[4.2065000000E+04, 3.6443402649E+01, 5.1678945943E+00, 1.7912114084E+01, 3.6131038308E+00, 9.7155130808E-01],
	[4.2070000000E+04, 3.6450998830E+01, 5.1679320627E+00, 1.7919046824E+01, 3.6134788047E+00, 9.7156324477E-01],
	[4.2075000000E+04, 3.6458595692E+01, 5.1679695269E+00, 1.7925981421E+01, 3.6138536869E+00, 9.7157517566E-01],
	[4.2080000000E+04, 3.6466193234E+01, 5.1680069870E+00, 1.7932917876E+01, 3.6142284775E+00, 9.7158710077E-01],
	[4.2085000000E+04, 3.6473791456E+01, 5.1680444428E+00, 1.7939856188E+01, 3.6146031765E+00, 9.7159902008E-01],
	[4.2090000000E+04, 3.6481390358E+01, 5.1680818945E+00, 1.7946796359E+01, 3.6149777840E+00, 9.7161093360E-01],
	[4.2095000000E+04, 3.6488989941E+01, 5.1681193420E+00, 1.7953738387E+01, 3.6153522999E+00, 9.7162284134E-01],
	[4.2100000000E+04, 3.6496590204E+01, 5.1681567853E+00, 1.7960682274E+01, 3.6157267243E+00, 9.7163474330E-01],
	[4.2105000000E+04, 3.6504191147E+01, 5.1681942244E+00, 1.7967628020E+01, 3.6161010572E+00, 9.7164663949E-01],
	[4.2110000000E+04, 3.6511792770E+01, 5.1682316594E+00, 1.7974575625E+01, 3.6164752987E+00, 9.7165852990E-01],
	[4.2115000000E+04, 3.6519395073E+01, 5.1682690902E+00, 1.7981525089E+01, 3.6168494486E+00, 9.7167041453E-01],
	[4.2120000000E+04, 3.6526998056E+01, 5.1683065168E+00, 1.7988476412E+01, 3.6172235071E+00, 9.7168229340E-01],
	[4.2125000000E+04, 3.6534601720E+01, 5.1683439393E+00, 1.7995429596E+01, 3.6175974742E+00, 9.7169416651E-01],
	[4.2130000000E+04, 3.6542206063E+01, 5.1683813575E+00, 1.8002384639E+01, 3.6179713498E+00, 9.7170603385E-01],
	[4.2135000000E+04, 3.6549811087E+01, 5.1684187717E+00, 1.8009341543E+01, 3.6183451341E+00, 9.7171789543E-01],
	[4.2140000000E+04, 3.6557416791E+01, 5.1684561816E+00, 1.8016300308E+01, 3.6187188270E+00, 9.7172975125E-01],
	[4.2145000000E+04, 3.6565023174E+01, 5.1684935874E+00, 1.8023260933E+01, 3.6190924286E+00, 9.7174160133E-01],
	[4.2150000000E+04, 3.6572630238E+01, 5.1685309890E+00, 1.8030223420E+01, 3.6194659388E+00, 9.7175344565E-01],
	[4.2155000000E+04, 3.6580237982E+01, 5.1685683864E+00, 1.8037187769E+01, 3.6198393577E+00, 9.7176528422E-01],
	[4.2160000000E+04, 3.6587846405E+01, 5.1686057797E+00, 1.8044153979E+01, 3.6202126854E+00, 9.7177711705E-01],
	[4.2165000000E+04, 3.6595455509E+01, 5.1686431688E+00, 1.8051122051E+01, 3.6205859217E+00, 9.7178894414E-01],
	[4.2170000000E+04, 3.6603065292E+01, 5.1686805538E+00, 1.8058091986E+01, 3.6209590668E+00, 9.7180076549E-01],
	[4.2175000000E+04, 3.6610675756E+01, 5.1687179345E+00, 1.8065063783E+01, 3.6213321207E+00, 9.7181258110E-01],
	[4.2180000000E+04, 3.6618286899E+01, 5.1687553112E+00, 1.8072037443E+01, 3.6217050833E+00, 9.7182439098E-01],
	[4.2185000000E+04, 3.6625898722E+01, 5.1687926836E+00, 1.8079012966E+01, 3.6220779548E+00, 9.7183619513E-01],
	[4.2190000000E+04, 3.6633511225E+01, 5.1688300519E+00, 1.8085990353E+01, 3.6224507351E+00, 9.7184799356E-01],
	[4.2195000000E+04, 3.6641124408E+01, 5.1688674161E+00, 1.8092969603E+01, 3.6228234242E+00, 9.7185978626E-01],
	[4.2200000000E+04, 3.6648738270E+01, 5.1689047761E+00, 1.8099950718E+01, 3.6231960222E+00, 9.7187157324E-01],
	[4.2205000000E+04, 3.6656352813E+01, 5.1689421319E+00, 1.8106933696E+01, 3.6235685291E+00, 9.7188335450E-01],
	[4.2210000000E+04, 3.6663968035E+01, 5.1689794836E+00, 1.8113918539E+01, 3.6239409449E+00, 9.7189513005E-01],
	[4.2215000000E+04, 3.6671583937E+01, 5.1690168311E+00, 1.8120905248E+01, 3.6243132696E+00, 9.7190689988E-01],
	[4.2220000000E+04, 3.6679200518E+01, 5.1690541745E+00, 1.8127893821E+01, 3.6246855032E+00, 9.7191866401E-01],
	[4.2225000000E+04, 3.6686817780E+01, 5.1690915137E+00, 1.8134884259E+01, 3.6250576458E+00, 9.7193042243E-01],
	[4.2230000000E+04, 3.6694435721E+01, 5.1691288488E+00, 1.8141876563E+01, 3.6254296974E+00, 9.7194217515E-01],
	[4.2235000000E+04, 3.6702054341E+01, 5.1691661797E+00, 1.8148870733E+01, 3.6258016580E+00, 9.7195392217E-01],
	[4.2240000000E+04, 3.6709673642E+01, 5.1692035065E+00, 1.8155866770E+01, 3.6261735276E+00, 9.7196566349E-01],
	[4.2245000000E+04, 3.6717293622E+01, 5.1692408291E+00, 1.8162864672E+01, 3.6265453062E+00, 9.7197739912E-01],
	[4.2250000000E+04, 3.6724914281E+01, 5.1692781475E+00, 1.8169864442E+01, 3.6269169940E+00, 9.7198912905E-01],
	[4.2255000000E+04, 3.6732535620E+01, 5.1693154619E+00, 1.8176866079E+01, 3.6272885907E+00, 9.7200085330E-01],
	[4.2260000000E+04, 3.6740157639E+01, 5.1693527720E+00, 1.8183869582E+01, 3.6276600966E+00, 9.7201257186E-01],
	[4.2265000000E+04, 3.6747780337E+01, 5.1693900781E+00, 1.8190874954E+01, 3.6280315116E+00, 9.7202428475E-01],
	[4.2270000000E+04, 3.6755403715E+01, 5.1694273800E+00, 1.8197882193E+01, 3.6284028358E+00, 9.7203599195E-01],
	[4.2275000000E+04, 3.6763027772E+01, 5.1694646777E+00, 1.8204891301E+01, 3.6287740691E+00, 9.7204769347E-01],
	[4.2280000000E+04, 3.6770652509E+01, 5.1695019713E+00, 1.8211902276E+01, 3.6291452115E+00, 9.7205938933E-01],
	[4.2285000000E+04, 3.6778277925E+01, 5.1695392608E+00, 1.8218915121E+01, 3.6295162632E+00, 9.7207107951E-01],
	[4.2290000000E+04, 3.6785904021E+01, 5.1695765461E+00, 1.8225929835E+01, 3.6298872241E+00, 9.7208276403E-01],
	[4.2295000000E+04, 3.6793530796E+01, 5.1696138273E+00, 1.8232946417E+01, 3.6302580942E+00, 9.7209444288E-01],
	[4.2300000000E+04, 3.6801158250E+01, 5.1696511043E+00, 1.8239964870E+01, 3.6306288736E+00, 9.7210611607E-01],
	[4.2305000000E+04, 3.6808786384E+01, 5.1696883772E+00, 1.8246985192E+01, 3.6309995622E+00, 9.7211778360E-01],
	[4.2310000000E+04, 3.6816415197E+01, 5.1697256460E+00, 1.8254007384E+01, 3.6313701601E+00, 9.7212944548E-01],
	[4.2315000000E+04, 3.6824044690E+01, 5.1697629107E+00, 1.8261031446E+01, 3.6317406674E+00, 9.7214110170E-01],
	[4.2320000000E+04, 3.6831674862E+01, 5.1698001712E+00, 1.8268057380E+01, 3.6321110840E+00, 9.7215275228E-01],
	[4.2325000000E+04, 3.6839305713E+01, 5.1698374275E+00, 1.8275085184E+01, 3.6324814099E+00, 9.7216439720E-01],
	[4.2330000000E+04, 3.6846937243E+01, 5.1698746798E+00, 1.8282114859E+01, 3.6328516452E+00, 9.7217603649E-01],
	[4.2335000000E+04, 3.6854569453E+01, 5.1699119279E+00, 1.8289146405E+01, 3.6332217899E+00, 9.7218767013E-01],
	[4.2340000000E+04, 3.6862202342E+01, 5.1699491718E+00, 1.8296179824E+01, 3.6335918440E+00, 9.7219929814E-01],
	[4.2345000000E+04, 3.6869835911E+01, 5.1699864117E+00, 1.8303215114E+01, 3.6339618076E+00, 9.7221092051E-01],
	[4.2350000000E+04, 3.6877470158E+01, 5.1700236474E+00, 1.8310252277E+01, 3.6343316805E+00, 9.7222253725E-01],
	[4.2355000000E+04, 3.6885105085E+01, 5.1700608790E+00, 1.8317291312E+01, 3.6347014630E+00, 9.7223414836E-01],
	[4.2360000000E+04, 3.6892740690E+01, 5.1700981065E+00, 1.8324332220E+01, 3.6350711549E+00, 9.7224575385E-01],
	[4.2365000000E+04, 3.6900376975E+01, 5.1701353298E+00, 1.8331375001E+01, 3.6354407564E+00, 9.7225735371E-01],
	[4.2370000000E+04, 3.6908013939E+01, 5.1701725490E+00, 1.8338419656E+01, 3.6358102674E+00, 9.7226894795E-01],
	[4.2375000000E+04, 3.6915651583E+01, 5.1702097641E+00, 1.8345466184E+01, 3.6361796879E+00, 9.7228053658E-01],
	[4.2380000000E+04, 3.6923289905E+01, 5.1702469750E+00, 1.8352514586E+01, 3.6365490180E+00, 9.7229211959E-01],
	[4.2385000000E+04, 3.6930928906E+01, 5.1702841819E+00, 1.8359564863E+01, 3.6369182577E+00, 9.7230369699E-01],
	[4.2390000000E+04, 3.6938568587E+01, 5.1703213846E+00, 1.8366617014E+01, 3.6372874069E+00, 9.7231526879E-01],
	[4.2395000000E+04, 3.6946208946E+01, 5.1703585832E+00, 1.8373671039E+01, 3.6376564658E+00, 9.7232683497E-01],
	[4.2400000000E+04, 3.6953849985E+01, 5.1703957777E+00, 1.8380726940E+01, 3.6380254344E+00, 9.7233839556E-01],
	[4.2405000000E+04, 3.6961491702E+01, 5.1704329681E+00, 1.8387784716E+01, 3.6383943126E+00, 9.7234995055E-01],
	[4.2410000000E+04, 3.6969134098E+01, 5.1704701543E+00, 1.8394844368E+01, 3.6387631005E+00, 9.7236149994E-01],
	[4.2415000000E+04, 3.6976777174E+01, 5.1705073364E+00, 1.8401905895E+01, 3.6391317981E+00, 9.7237304373E-01],
	[4.2420000000E+04, 3.6984420928E+01, 5.1705445144E+00, 1.8408969299E+01, 3.6395004055E+00, 9.7238458194E-01],
	[4.2425000000E+04, 3.6992065361E+01, 5.1705816883E+00, 1.8416034579E+01, 3.6398689225E+00, 9.7239611456E-01],
	[4.2430000000E+04, 3.6999710473E+01, 5.1706188581E+00, 1.8423101736E+01, 3.6402373494E+00, 9.7240764159E-01],
	[4.2435000000E+04, 3.7007356264E+01, 5.1706560238E+00, 1.8430170770E+01, 3.6406056860E+00, 9.7241916305E-01],
	[4.2440000000E+04, 3.7015002734E+01, 5.1706931853E+00, 1.8437241681E+01, 3.6409739324E+00, 9.7243067892E-01],
	[4.2445000000E+04, 3.7022649883E+01, 5.1707303428E+00, 1.8444314469E+01, 3.6413420886E+00, 9.7244218922E-01],
	[4.2450000000E+04, 3.7030297710E+01, 5.1707674961E+00, 1.8451389136E+01, 3.6417101547E+00, 9.7245369394E-01],
	[4.2455000000E+04, 3.7037946216E+01, 5.1708046454E+00, 1.8458465680E+01, 3.6420781306E+00, 9.7246519310E-01],
	[4.2460000000E+04, 3.7045595402E+01, 5.1708417905E+00, 1.8465544103E+01, 3.6424460165E+00, 9.7247668669E-01],
	[4.2465000000E+04, 3.7053245265E+01, 5.1708789315E+00, 1.8472624404E+01, 3.6428138122E+00, 9.7248817471E-01],
	[4.2470000000E+04, 3.7060895808E+01, 5.1709160684E+00, 1.8479706585E+01, 3.6431815178E+00, 9.7249965718E-01],
	[4.2475000000E+04, 3.7068547029E+01, 5.1709532012E+00, 1.8486790644E+01, 3.6435491334E+00, 9.7251113408E-01],
	[4.2480000000E+04, 3.7076198929E+01, 5.1709903299E+00, 1.8493876584E+01, 3.6439166589E+00, 9.7252260543E-01],
	[4.2485000000E+04, 3.7083851508E+01, 5.1710274545E+00, 1.8500964402E+01, 3.6442840944E+00, 9.7253407123E-01],
	[4.2490000000E+04, 3.7091504765E+01, 5.1710645750E+00, 1.8508054101E+01, 3.6446514400E+00, 9.7254553148E-01],
	[4.2495000000E+04, 3.7099158701E+01, 5.1711016914E+00, 1.8515145680E+01, 3.6450186955E+00, 9.7255698618E-01],
	[4.2500000000E+04, 3.7106818661E+01, 5.1711394599E+00, 1.8522239140E+01, 3.6453862388E+00, 9.7256843534E-01],
	[4.2505000000E+04, 3.7114490255E+01, 5.1711785684E+00, 1.8529334481E+01, 3.6457544660E+00, 9.7257987896E-01],
	[4.2510000000E+04, 3.7122162532E+01, 5.1712176727E+00, 1.8536431702E+01, 3.6461226035E+00, 9.7259131704E-01],
	[4.2515000000E+04, 3.7129835493E+01, 5.1712567726E+00, 1.8543530806E+01, 3.6464906514E+00, 9.7260274959E-01],
	[4.2520000000E+04, 3.7137509137E+01, 5.1712958682E+00, 1.8550631790E+01, 3.6468586096E+00, 9.7261417661E-01],
	[4.2525000000E+04, 3.7145183464E+01, 5.1713349595E+00, 1.8557734657E+01, 3.6472264782E+00, 9.7262559809E-01],
	[4.2530000000E+04, 3.7152858474E+01, 5.1713740465E+00, 1.8564839406E+01, 3.6475942573E+00, 9.7263701405E-01],
	[4.2535000000E+04, 3.7160534168E+01, 5.1714131292E+00, 1.8571946038E+01, 3.6479619467E+00, 9.7264842449E-01],
	[4.2540000000E+04, 3.7168210545E+01, 5.1714522076E+00, 1.8579054552E+01, 3.6483295466E+00, 9.7265982941E-01],
	[4.2545000000E+04, 3.7175887605E+01, 5.1714912817E+00, 1.8586164949E+01, 3.6486970570E+00, 9.7267122881E-01],
	[4.2550000000E+04, 3.7183565349E+01, 5.1715303515E+00, 1.8593277230E+01, 3.6490644778E+00, 9.7268262269E-01],
	[4.2555000000E+04, 3.7191243776E+01, 5.1715694170E+00, 1.8600391394E+01, 3.6494318092E+00, 9.7269401107E-01],
	[4.2560000000E+04, 3.7198922886E+01, 5.1716084783E+00, 1.8607507443E+01, 3.6497990510E+00, 9.7270539394E-01],
	[4.2565000000E+04, 3.7206602679E+01, 5.1716475352E+00, 1.8614625375E+01, 3.6501662034E+00, 9.7271677130E-01],
	[4.2570000000E+04, 3.7214283155E+01, 5.1716865878E+00, 1.8621745192E+01, 3.6505332664E+00, 9.7272814316E-01],
	[4.2575000000E+04, 3.7221964315E+01, 5.1717256362E+00, 1.8628866894E+01, 3.6509002399E+00, 9.7273950951E-01],
	[4.2580000000E+04, 3.7229646157E+01, 5.1717646802E+00, 1.8635990480E+01, 3.6512671240E+00, 9.7275087038E-01],
	[4.2585000000E+04, 3.7237328683E+01, 5.1718037200E+00, 1.8643115952E+01, 3.6516339188E+00, 9.7276222575E-01],
	[4.2590000000E+04, 3.7245011891E+01, 5.1718427555E+00, 1.8650243310E+01, 3.6520006242E+00, 9.7277357562E-01],
	[4.2595000000E+04, 3.7252695783E+01, 5.1718817867E+00, 1.8657372553E+01, 3.6523672402E+00, 9.7278492001E-01],
	[4.2600000000E+04, 3.7260380358E+01, 5.1719208136E+00, 1.8664503682E+01, 3.6527337669E+00, 9.7279625892E-01],
	[4.2605000000E+04, 3.7268065616E+01, 5.1719598362E+00, 1.8671636698E+01, 3.6531002043E+00, 9.7280759234E-01],
	[4.2610000000E+04, 3.7275751557E+01, 5.1719988545E+00, 1.8678771601E+01, 3.6534665525E+00, 9.7281892028E-01],
	[4.2615000000E+04, 3.7283438181E+01, 5.1720378686E+00, 1.8685908390E+01, 3.6538328113E+00, 9.7283024275E-01],
	[4.2620000000E+04, 3.7291125487E+01, 5.1720768783E+00, 1.8693047067E+01, 3.6541989809E+00, 9.7284155975E-01],
	[4.2625000000E+04, 3.7298813477E+01, 5.1721158838E+00, 1.8700187631E+01, 3.6545650613E+00, 9.7285287127E-01],
	[4.2630000000E+04, 3.7306502150E+01, 5.1721548850E+00, 1.8707330083E+01, 3.6549310525E+00, 9.7286417733E-01],
	[4.2635000000E+04, 3.7314191505E+01, 5.1721938819E+00, 1.8714474423E+01, 3.6552969545E+00, 9.7287547792E-01],
	[4.2640000000E+04, 3.7321881544E+01, 5.1722328746E+00, 1.8721620651E+01, 3.6556627673E+00, 9.7288677305E-01],
	[4.2645000000E+04, 3.7329572265E+01, 5.1722718629E+00, 1.8728768768E+01, 3.6560284910E+00, 9.7289806272E-01],
	[4.2650000000E+04, 3.7337263669E+01, 5.1723108470E+00, 1.8735918773E+01, 3.6563941256E+00, 9.7290934693E-01],
	[4.2655000000E+04, 3.7344955756E+01, 5.1723498268E+00, 1.8743070668E+01, 3.6567596710E+00, 9.7292062569E-01],
	[4.2660000000E+04, 3.7352648526E+01, 5.1723888024E+00, 1.8750224453E+01, 3.6571251274E+00, 9.7293189900E-01],
	[4.2665000000E+04, 3.7360341979E+01, 5.1724277736E+00, 1.8757380127E+01, 3.6574904946E+00, 9.7294316687E-01],
	[4.2670000000E+04, 3.7368036114E+01, 5.1724667406E+00, 1.8764537691E+01, 3.6578557729E+00, 9.7295442929E-01],
	[4.2675000000E+04, 3.7375730932E+01, 5.1725057033E+00, 1.8771697145E+01, 3.6582209621E+00, 9.7296568627E-01],
	[4.2680000000E+04, 3.7383426433E+01, 5.1725446618E+00, 1.8778858490E+01, 3.6585860623E+00, 9.7297693781E-01],
	[4.2685000000E+04, 3.7391122616E+01, 5.1725836159E+00, 1.8786021726E+01, 3.6589510734E+00, 9.7298818391E-01],
	[4.2690000000E+04, 3.7398819483E+01, 5.1726225658E+00, 1.8793186852E+01, 3.6593159957E+00, 9.7299942458E-01],
	[4.2695000000E+04, 3.7406517031E+01, 5.1726615115E+00, 1.8800353871E+01, 3.6596808289E+00, 9.7301065982E-01],
	[4.2700000000E+04, 3.7414215263E+01, 5.1727004529E+00, 1.8807522780E+01, 3.6600455733E+00, 9.7302188964E-01],
	[4.2705000000E+04, 3.7421914177E+01, 5.1727393900E+00, 1.8814693582E+01, 3.6604102287E+00, 9.7303311403E-01],
	[4.2710000000E+04, 3.7429613774E+01, 5.1727783228E+00, 1.8821866276E+01, 3.6607747952E+00, 9.7304433300E-01],
	[4.2715000000E+04, 3.7437314053E+01, 5.1728172514E+00, 1.8829040862E+01, 3.6611392729E+00, 9.7305554655E-01],
	[4.2720000000E+04, 3.7445015015E+01, 5.1728561757E+00, 1.8836217342E+01, 3.6615036617E+00, 9.7306675469E-01],
	[4.2725000000E+04, 3.7452716660E+01, 5.1728950957E+00, 1.8843395714E+01, 3.6618679616E+00, 9.7307795741E-01],
	[4.2730000000E+04, 3.7460418987E+01, 5.1729340115E+00, 1.8850575979E+01, 3.6622321728E+00, 9.7308915472E-01],
	[4.2735000000E+04, 3.7468121996E+01, 5.1729729230E+00, 1.8857758138E+01, 3.6625962951E+00, 9.7310034663E-01],
	[4.2740000000E+04, 3.7475825689E+01, 5.1730118303E+00, 1.8864942191E+01, 3.6629603287E+00, 9.7311153313E-01],
	[4.2745000000E+04, 3.7483530063E+01, 5.1730507333E+00, 1.8872128138E+01, 3.6633242735E+00, 9.7312271424E-01],
	[4.2750000000E+04, 3.7491235120E+01, 5.1730896320E+00, 1.8879315980E+01, 3.6636881295E+00, 9.7313388994E-01],
	[4.2755000000E+04, 3.7498940859E+01, 5.1731285265E+00, 1.8886505716E+01, 3.6640518969E+00, 9.7314506025E-01],
	[4.2760000000E+04, 3.7506647281E+01, 5.1731674168E+00, 1.8893697347E+01, 3.6644155756E+00, 9.7315622516E-01],
	[4.2765000000E+04, 3.7514354386E+01, 5.1732063027E+00, 1.8900890874E+01, 3.6647791655E+00, 9.7316738469E-01],
	[4.2770000000E+04, 3.7522062172E+01, 5.1732451845E+00, 1.8908086296E+01, 3.6651426668E+00, 9.7317853883E-01],
	[4.2775000000E+04, 3.7529770641E+01, 5.1732840619E+00, 1.8915283614E+01, 3.6655060795E+00, 9.7318968759E-01],
	[4.2780000000E+04, 3.7537479793E+01, 5.1733229352E+00, 1.8922482827E+01, 3.6658694036E+00, 9.7320083096E-01],
	[4.2785000000E+04, 3.7545189626E+01, 5.1733618041E+00, 1.8929683938E+01, 3.6662326390E+00, 9.7321196896E-01],
	[4.2790000000E+04, 3.7552900142E+01, 5.1734006688E+00, 1.8936886945E+01, 3.6665957859E+00, 9.7322310159E-01],
	[4.2795000000E+04, 3.7560611340E+01, 5.1734395293E+00, 1.8944091848E+01, 3.6669588442E+00, 9.7323422884E-01],
	[4.2800000000E+04, 3.7568323221E+01, 5.1734783855E+00, 1.8951298649E+01, 3.6673218140E+00, 9.7324535072E-01],
	[4.2805000000E+04, 3.7576035784E+01, 5.1735172375E+00, 1.8958507348E+01, 3.6676846952E+00, 9.7325646723E-01],
	[4.2810000000E+04, 3.7583749029E+01, 5.1735560852E+00, 1.8965717944E+01, 3.6680474879E+00, 9.7326757839E-01],
	[4.2815000000E+04, 3.7591462956E+01, 5.1735949287E+00, 1.8972930438E+01, 3.6684101922E+00, 9.7327868418E-01],
	[4.2820000000E+04, 3.7599177565E+01, 5.1736337680E+00, 1.8980144831E+01, 3.6687728080E+00, 9.7328978461E-01],
	[4.2825000000E+04, 3.7606892857E+01, 5.1736726029E+00, 1.8987361122E+01, 3.6691353353E+00, 9.7330087969E-01],
	[4.2830000000E+04, 3.7614608830E+01, 5.1737114337E+00, 1.8994579312E+01, 3.6694977743E+00, 9.7331196941E-01],
	[4.2835000000E+04, 3.7622325486E+01, 5.1737502602E+00, 1.9001799401E+01, 3.6698601248E+00, 9.7332305379E-01],
	[4.2840000000E+04, 3.7630042824E+01, 5.1737890825E+00, 1.9009021389E+01, 3.6702223869E+00, 9.7333413282E-01],
	[4.2845000000E+04, 3.7637760844E+01, 5.1738279005E+00, 1.9016245277E+01, 3.6705845607E+00, 9.7334520651E-01],
	[4.2850000000E+04, 3.7645479546E+01, 5.1738667143E+00, 1.9023471065E+01, 3.6709466461E+00, 9.7335627485E-01],
	[4.2855000000E+04, 3.7653198930E+01, 5.1739055239E+00, 1.9030698754E+01, 3.6713086432E+00, 9.7336733786E-01],
	[4.2860000000E+04, 3.7660918997E+01, 5.1739443292E+00, 1.9037928343E+01, 3.6716705519E+00, 9.7337839554E-01],
	[4.2865000000E+04, 3.7668639745E+01, 5.1739831303E+00, 1.9045159832E+01, 3.6720323724E+00, 9.7338944788E-01],
	[4.2870000000E+04, 3.7676361175E+01, 5.1740219271E+00, 1.9052393223E+01, 3.6723941047E+00, 9.7340049489E-01],
	[4.2875000000E+04, 3.7684083287E+01, 5.1740607197E+00, 1.9059628515E+01, 3.6727557486E+00, 9.7341153658E-01],
	[4.2880000000E+04, 3.7691806081E+01, 5.1740995081E+00, 1.9066865709E+01, 3.6731173044E+00, 9.7342257294E-01],
	[4.2885000000E+04, 3.7699529557E+01, 5.1741382922E+00, 1.9074104804E+01, 3.6734787719E+00, 9.7343360398E-01],
	[4.2890000000E+04, 3.7707253715E+01, 5.1741770722E+00, 1.9081345802E+01, 3.6738401513E+00, 9.7344462971E-01],
	[4.2895000000E+04, 3.7714978555E+01, 5.1742158479E+00, 1.9088588703E+01, 3.6742014424E+00, 9.7345565012E-01],
	[4.2900000000E+04, 3.7722704077E+01, 5.1742546193E+00, 1.9095833505E+01, 3.6745626455E+00, 9.7346666522E-01],
	[4.2905000000E+04, 3.7730430280E+01, 5.1742933865E+00, 1.9103080211E+01, 3.6749237604E+00, 9.7347767500E-01],
	[4.2910000000E+04, 3.7738157166E+01, 5.1743321495E+00, 1.9110328821E+01, 3.6752847871E+00, 9.7348867949E-01],
	[4.2915000000E+04, 3.7745884733E+01, 5.1743709083E+00, 1.9117579334E+01, 3.6756457258E+00, 9.7349967867E-01],
	[4.2920000000E+04, 3.7753612982E+01, 5.1744096629E+00, 1.9124831750E+01, 3.6760065765E+00, 9.7351067254E-01],
	[4.2925000000E+04, 3.7761341913E+01, 5.1744484132E+00, 1.9132086071E+01, 3.6763673390E+00, 9.7352166112E-01],
	[4.2930000000E+04, 3.7769071525E+01, 5.1744871593E+00, 1.9139342296E+01, 3.6767280136E+00, 9.7353264441E-01],
	[4.2935000000E+04, 3.7776801820E+01, 5.1745259012E+00, 1.9146600426E+01, 3.6770886001E+00, 9.7354362240E-01],
	[4.2940000000E+04, 3.7784532796E+01, 5.1745646389E+00, 1.9153860461E+01, 3.6774490986E+00, 9.7355459511E-01],
	[4.2945000000E+04, 3.7792264454E+01, 5.1746033723E+00, 1.9161122401E+01, 3.6778095091E+00, 9.7356556253E-01],
	[4.2950000000E+04, 3.7799996793E+01, 5.1746421015E+00, 1.9168386247E+01, 3.6781698317E+00, 9.7357652466E-01],
	[4.2955000000E+04, 3.7807729814E+01, 5.1746808265E+00, 1.9175651998E+01, 3.6785300664E+00, 9.7358748151E-01],
	[4.2960000000E+04, 3.7815463517E+01, 5.1747195473E+00, 1.9182919656E+01, 3.6788902131E+00, 9.7359843309E-01],
	[4.2965000000E+04, 3.7823197901E+01, 5.1747582639E+00, 1.9190189219E+01, 3.6792502720E+00, 9.7360937939E-01],
	[4.2970000000E+04, 3.7830932967E+01, 5.1747969762E+00, 1.9197460690E+01, 3.6796102430E+00, 9.7362032042E-01],
	[4.2975000000E+04, 3.7838668715E+01, 5.1748356844E+00, 1.9204734067E+01, 3.6799701261E+00, 9.7363125618E-01],
	[4.2980000000E+04, 3.7846405144E+01, 5.1748743883E+00, 1.9212009351E+01, 3.6803299214E+00, 9.7364218667E-01],
	[4.2985000000E+04, 3.7854142255E+01, 5.1749130880E+00, 1.9219286543E+01, 3.6806896288E+00, 9.7365311190E-01],
	[4.2990000000E+04, 3.7861880047E+01, 5.1749517835E+00, 1.9226565643E+01, 3.6810492485E+00, 9.7366403187E-01],
	[4.2995000000E+04, 3.7869618521E+01, 5.1749904748E+00, 1.9233846651E+01, 3.6814087804E+00, 9.7367494658E-01],
	[4.3000000000E+04, 3.7877357676E+01, 5.1750291619E+00, 1.9241129566E+01, 3.6817682245E+00, 9.7368585603E-01],
	[4.3005000000E+04, 3.7885097513E+01, 5.1750678447E+00, 1.9248414391E+01, 3.6821275809E+00, 9.7369676024E-01],
	[4.3010000000E+04, 3.7892838031E+01, 5.1751065234E+00, 1.9255701124E+01, 3.6824868496E+00, 9.7370765919E-01],
	[4.3015000000E+04, 3.7900579230E+01, 5.1751451978E+00, 1.9262989767E+01, 3.6828460305E+00, 9.7371855290E-01],
	[4.3020000000E+04, 3.7908321111E+01, 5.1751838681E+00, 1.9270280318E+01, 3.6832051238E+00, 9.7372944136E-01],
	[4.3025000000E+04, 3.7916063674E+01, 5.1752225341E+00, 1.9277572780E+01, 3.6835641295E+00, 9.7374032458E-01],
	[4.3030000000E+04, 3.7923806918E+01, 5.1752611960E+00, 1.9284867151E+01, 3.6839230475E+00, 9.7375120257E-01],
	[4.3035000000E+04, 3.7931550843E+01, 5.1752998536E+00, 1.9292163433E+01, 3.6842818778E+00, 9.7376207532E-01],
	[4.3040000000E+04, 3.7939295449E+01, 5.1753385070E+00, 1.9299461625E+01, 3.6846406206E+00, 9.7377294283E-01],
	[4.3045000000E+04, 3.7947040737E+01, 5.1753771563E+00, 1.9306761728E+01, 3.6849992758E+00, 9.7378380512E-01],
	[4.3050000000E+04, 3.7954786706E+01, 5.1754158013E+00, 1.9314063742E+01, 3.6853578434E+00, 9.7379466218E-01],
	[4.3055000000E+04, 3.7962533356E+01, 5.1754544421E+00, 1.9321367667E+01, 3.6857163235E+00, 9.7380551402E-01],
	[4.3060000000E+04, 3.7970280688E+01, 5.1754930788E+00, 1.9328673504E+01, 3.6860747161E+00, 9.7381636063E-01],
	[4.3065000000E+04, 3.7978028701E+01, 5.1755317112E+00, 1.9335981253E+01, 3.6864330211E+00, 9.7382720203E-01],
	[4.3070000000E+04, 3.7985777395E+01, 5.1755703394E+00, 1.9343290914E+01, 3.6867912387E+00, 9.7383803821E-01],
	[4.3075000000E+04, 3.7993526770E+01, 5.1756089635E+00, 1.9350602487E+01, 3.6871493688E+00, 9.7384886917E-01],
	[4.3080000000E+04, 3.8001276827E+01, 5.1756475833E+00, 1.9357915974E+01, 3.6875074115E+00, 9.7385969493E-01],
	[4.3085000000E+04, 3.8009027565E+01, 5.1756861990E+00, 1.9365231373E+01, 3.6878653667E+00, 9.7387051548E-01],
	[4.3090000000E+04, 3.8016778983E+01, 5.1757248104E+00, 1.9372548685E+01, 3.6882232345E+00, 9.7388133083E-01],
	[4.3095000000E+04, 3.8024531083E+01, 5.1757634177E+00, 1.9379867911E+01, 3.6885810150E+00, 9.7389214097E-01],
	[4.3100000000E+04, 3.8032283864E+01, 5.1758020208E+00, 1.9387189051E+01, 3.6889387081E+00, 9.7390294592E-01],
	[4.3105000000E+04, 3.8040037326E+01, 5.1758406197E+00, 1.9394512105E+01, 3.6892963138E+00, 9.7391374567E-01],
	[4.3110000000E+04, 3.8047791470E+01, 5.1758792144E+00, 1.9401837073E+01, 3.6896538322E+00, 9.7392454023E-01],
	[4.3115000000E+04, 3.8055546294E+01, 5.1759178049E+00, 1.9409163956E+01, 3.6900112633E+00, 9.7393532960E-01],
	[4.3120000000E+04, 3.8063301799E+01, 5.1759563912E+00, 1.9416492754E+01, 3.6903686072E+00, 9.7394611378E-01],
	[4.3125000000E+04, 3.8071057985E+01, 5.1759949733E+00, 1.9423823467E+01, 3.6907258637E+00, 9.7395689277E-01],
	[4.3130000000E+04, 3.8078814853E+01, 5.1760335513E+00, 1.9431156096E+01, 3.6910830330E+00, 9.7396766659E-01],
	[4.3135000000E+04, 3.8086572401E+01, 5.1760721250E+00, 1.9438490640E+01, 3.6914401151E+00, 9.7397843522E-01],
	[4.3140000000E+04, 3.8094330630E+01, 5.1761106946E+00, 1.9445827101E+01, 3.6917971100E+00, 9.7398919868E-01],
	[4.3145000000E+04, 3.8102089540E+01, 5.1761492600E+00, 1.9453165477E+01, 3.6921540176E+00, 9.7399995696E-01],
	[4.3150000000E+04, 3.8109849131E+01, 5.1761878212E+00, 1.9460505771E+01, 3.6925108382E+00, 9.7401071008E-01],
	[4.3155000000E+04, 3.8117609403E+01, 5.1762263783E+00, 1.9467847981E+01, 3.6928675715E+00, 9.7402145802E-01],
	[4.3160000000E+04, 3.8125370356E+01, 5.1762649311E+00, 1.9475192108E+01, 3.6932242178E+00, 9.7403220081E-01],
	[4.3165000000E+04, 3.8133131990E+01, 5.1763034798E+00, 1.9482538153E+01, 3.6935807769E+00, 9.7404293843E-01],
	[4.3170000000E+04, 3.8140894304E+01, 5.1763420243E+00, 1.9489886116E+01, 3.6939372489E+00, 9.7405367089E-01],
	[4.3175000000E+04, 3.8148657300E+01, 5.1763805646E+00, 1.9497235997E+01, 3.6942936339E+00, 9.7406439819E-01],
	[4.3180000000E+04, 3.8156420976E+01, 5.1764191008E+00, 1.9504587795E+01, 3.6946499318E+00, 9.7407512034E-01],
	[4.3185000000E+04, 3.8164193346E+01, 5.1764586007E+00, 1.9511941513E+01, 3.6950067110E+00, 9.7408583734E-01],
	[4.3190000000E+04, 3.8171974579E+01, 5.1764990842E+00, 1.9519297149E+01, 3.6953639834E+00, 9.7409654919E-01],
	[4.3195000000E+04, 3.8179756497E+01, 5.1765395634E+00, 1.9526654704E+01, 3.6957211690E+00, 9.7410725589E-01],
	[4.3200000000E+04, 3.8187539101E+01, 5.1765800382E+00, 1.9534014179E+01, 3.6960782679E+00, 9.7411795746E-01],
	[4.3205000000E+04, 3.8195322390E+01, 5.1766205087E+00, 1.9541375574E+01, 3.6964352801E+00, 9.7412865388E-01],
	[4.3210000000E+04, 3.8203106364E+01, 5.1766609747E+00, 1.9548738888E+01, 3.6967922056E+00, 9.7413934516E-01],
	[4.3215000000E+04, 3.8210891024E+01, 5.1767014364E+00, 1.9556104122E+01, 3.6971490444E+00, 9.7415003131E-01],
	[4.3220000000E+04, 3.8218676369E+01, 5.1767418938E+00, 1.9563471277E+01, 3.6975057965E+00, 9.7416071233E-01],
	[4.3225000000E+04, 3.8226462400E+01, 5.1767823468E+00, 1.9570840353E+01, 3.6978624620E+00, 9.7417138823E-01],
	[4.3230000000E+04, 3.8234249116E+01, 5.1768227954E+00, 1.9578211350E+01, 3.6982190409E+00, 9.7418205899E-01],
	[4.3235000000E+04, 3.8242036517E+01, 5.1768632396E+00, 1.9585584268E+01, 3.6985755332E+00, 9.7419272463E-01],
	[4.3240000000E+04, 3.8249824604E+01, 5.1769036795E+00, 1.9592959108E+01, 3.6989319389E+00, 9.7420338516E-01],
	[4.3245000000E+04, 3.8257613376E+01, 5.1769441151E+00, 1.9600335870E+01, 3.6992882580E+00, 9.7421404056E-01],
	[4.3250000000E+04, 3.8265402833E+01, 5.1769845462E+00, 1.9607714554E+01, 3.6996444906E+00, 9.7422469085E-01],
	[4.3255000000E+04, 3.8273192975E+01, 5.1770249730E+00, 1.9615095160E+01, 3.7000006367E+00, 9.7423533603E-01],
	[4.3260000000E+04, 3.8280983803E+01, 5.1770653955E+00, 1.9622477689E+01, 3.7003566962E+00, 9.7424597610E-01],
	[4.3265000000E+04, 3.8288775316E+01, 5.1771058136E+00, 1.9629862141E+01, 3.7007126693E+00, 9.7425661106E-01],
	[4.3270000000E+04, 3.8296567513E+01, 5.1771462273E+00, 1.9637248516E+01, 3.7010685559E+00, 9.7426724092E-01],
	[4.3275000000E+04, 3.8304360397E+01, 5.1771866367E+00, 1.9644636815E+01, 3.7014243561E+00, 9.7427786568E-01],
	[4.3280000000E+04, 3.8312153965E+01, 5.1772270418E+00, 1.9652027038E+01, 3.7017800698E+00, 9.7428848534E-01],
	[4.3285000000E+04, 3.8319948218E+01, 5.1772674425E+00, 1.9659419185E+01, 3.7021356972E+00, 9.7429909990E-01],
	[4.3290000000E+04, 3.8327743157E+01, 5.1773078388E+00, 1.9666813256E+01, 3.7024912381E+00, 9.7430970937E-01],
	[4.3295000000E+04, 3.8335538780E+01, 5.1773482308E+00, 1.9674209252E+01, 3.7028466927E+00, 9.7432031375E-01],
	[4.3300000000E+04, 3.8343335089E+01, 5.1773886184E+00, 1.9681607172E+01, 3.7032020609E+00, 9.7433091305E-01],
	[4.3305000000E+04, 3.8351132082E+01, 5.1774290017E+00, 1.9689007018E+01, 3.7035573428E+00, 9.7434150726E-01],
	[4.3310000000E+04, 3.8358929761E+01, 5.1774693806E+00, 1.9696408790E+01, 3.7039125384E+00, 9.7435209639E-01],
	[4.3315000000E+04, 3.8366728125E+01, 5.1775097552E+00, 1.9703812487E+01, 3.7042676477E+00, 9.7436268044E-01],
	[4.3320000000E+04, 3.8374527174E+01, 5.1775501255E+00, 1.9711218110E+01, 3.7046226708E+00, 9.7437325942E-01],
	[4.3325000000E+04, 3.8382326907E+01, 5.1775904914E+00, 1.9718625660E+01, 3.7049776075E+00, 9.7438383332E-01],
	[4.3330000000E+04, 3.8390127326E+01, 5.1776308529E+00, 1.9726035136E+01, 3.7053324581E+00, 9.7439440215E-01],
	[4.3335000000E+04, 3.8397928429E+01, 5.1776712102E+00, 1.9733446539E+01, 3.7056872224E+00, 9.7440496591E-01],
	[4.3340000000E+04, 3.8405730218E+01, 5.1777115630E+00, 1.9740859870E+01, 3.7060419006E+00, 9.7441552461E-01],
	[4.3345000000E+04, 3.8413532691E+01, 5.1777519116E+00, 1.9748275127E+01, 3.7063964926E+00, 9.7442607825E-01],
	[4.3350000000E+04, 3.8421335850E+01, 5.1777922558E+00, 1.9755692313E+01, 3.7067509984E+00, 9.7443662683E-01],
	[4.3355000000E+04, 3.8429139693E+01, 5.1778325956E+00, 1.9763111426E+01, 3.7071054181E+00, 9.7444717035E-01],
	[4.3360000000E+04, 3.8436944221E+01, 5.1778729311E+00, 1.9770532468E+01, 3.7074597517E+00, 9.7445770881E-01],
	[4.3365000000E+04, 3.8444749433E+01, 5.1779132623E+00, 1.9777955438E+01, 3.7078139992E+00, 9.7446824223E-01],
	[4.3370000000E+04, 3.8452555331E+01, 5.1779535892E+00, 1.9785380337E+01, 3.7081681606E+00, 9.7447877060E-01],
	[4.3375000000E+04, 3.8460361913E+01, 5.1779939117E+00, 1.9792807165E+01, 3.7085222359E+00, 9.7448929392E-01],
	[4.3380000000E+04, 3.8468169181E+01, 5.1780342299E+00, 1.9800235923E+01, 3.7088762253E+00, 9.7449981220E-01],
	[4.3385000000E+04, 3.8475977132E+01, 5.1780745437E+00, 1.9807666610E+01, 3.7092301286E+00, 9.7451032544E-01],
	[4.3390000000E+04, 3.8483785769E+01, 5.1781148532E+00, 1.9815099228E+01, 3.7095839459E+00, 9.7452083364E-01],
	[4.3395000000E+04, 3.8491595090E+01, 5.1781551584E+00, 1.9822533775E+01, 3.7099376772E+00, 9.7453133681E-01],
	[4.3400000000E+04, 3.8499405096E+01, 5.1781954592E+00, 1.9829970253E+01, 3.7102913226E+00, 9.7454183494E-01],
	[4.3405000000E+04, 3.8507215787E+01, 5.1782357558E+00, 1.9837408662E+01, 3.7106448821E+00, 9.7455232805E-01],
	[4.3410000000E+04, 3.8515027162E+01, 5.1782760480E+00, 1.9844849001E+01, 3.7109983556E+00, 9.7456281613E-01],
	[4.3415000000E+04, 3.8522839222E+01, 5.1783163358E+00, 1.9852291273E+01, 3.7113517432E+00, 9.7457329919E-01],
	[4.3420000000E+04, 3.8530651967E+01, 5.1783566194E+00, 1.9859735475E+01, 3.7117050450E+00, 9.7458377722E-01],
	[4.3425000000E+04, 3.8538465396E+01, 5.1783968986E+00, 1.9867181610E+01, 3.7120582609E+00, 9.7459425024E-01],
	[4.3430000000E+04, 3.8546279510E+01, 5.1784371735E+00, 1.9874629677E+01, 3.7124113909E+00, 9.7460471824E-01],
	[4.3435000000E+04, 3.8554094308E+01, 5.1784774440E+00, 1.9882079676E+01, 3.7127644352E+00, 9.7461518123E-01],
	[4.3440000000E+04, 3.8561909791E+01, 5.1785177103E+00, 1.9889531608E+01, 3.7131173936E+00, 9.7462563922E-01],
	[4.3445000000E+04, 3.8569725958E+01, 5.1785579722E+00, 1.9896985473E+01, 3.7134702663E+00, 9.7463609219E-01],
	[4.3450000000E+04, 3.8577542810E+01, 5.1785982298E+00, 1.9904441271E+01, 3.7138230531E+00, 9.7464654016E-01],
	[4.3455000000E+04, 3.8585360346E+01, 5.1786384831E+00, 1.9911899003E+01, 3.7141757543E+00, 9.7465698312E-01],
	[4.3460000000E+04, 3.8593178567E+01, 5.1786787321E+00, 1.9919358668E+01, 3.7145283697E+00, 9.7466742109E-01],
	[4.3465000000E+04, 3.8600997472E+01, 5.1787189767E+00, 1.9926820268E+01, 3.7148808995E+00, 9.7467785406E-01],
	[4.3470000000E+04, 3.8608817062E+01, 5.1787592170E+00, 1.9934283802E+01, 3.7152333435E+00, 9.7468828204E-01],
	[4.3475000000E+04, 3.8616637336E+01, 5.1787994530E+00, 1.9941749271E+01, 3.7155857019E+00, 9.7469870503E-01],
	[4.3480000000E+04, 3.8624458295E+01, 5.1788396847E+00, 1.9949216675E+01, 3.7159379746E+00, 9.7470912303E-01],
	[4.3485000000E+04, 3.8632279937E+01, 5.1788799121E+00, 1.9956686014E+01, 3.7162901618E+00, 9.7471953605E-01],
	[4.3490000000E+04, 3.8640102265E+01, 5.1789201352E+00, 1.9964157288E+01, 3.7166422633E+00, 9.7472994408E-01],
	[4.3495000000E+04, 3.8647925276E+01, 5.1789603540E+00, 1.9971630499E+01, 3.7169942792E+00, 9.7474034713E-01],
	[4.3500000000E+04, 3.8655748972E+01, 5.1790005684E+00, 1.9979105645E+01, 3.7173462096E+00, 9.7475074521E-01],
	[4.3505000000E+04, 3.8663573352E+01, 5.1790407786E+00, 1.9986582728E+01, 3.7176980544E+00, 9.7476113831E-01],
	[4.3510000000E+04, 3.8671398416E+01, 5.1790809844E+00, 1.9994061747E+01, 3.7180498137E+00, 9.7477152644E-01],
	[4.3515000000E+04, 3.8679224165E+01, 5.1791211859E+00, 2.0001542703E+01, 3.7184014875E+00, 9.7478190960E-01],
	[4.3520000000E+04, 3.8687050598E+01, 5.1791613831E+00, 2.0009025597E+01, 3.7187530758E+00, 9.7479228779E-01],
	[4.3525000000E+04, 3.8694877715E+01, 5.1792015760E+00, 2.0016510427E+01, 3.7191045786E+00, 9.7480266102E-01],
	[4.3530000000E+04, 3.8702705516E+01, 5.1792417647E+00, 2.0023997196E+01, 3.7194559960E+00, 9.7481302929E-01],
	[4.3535000000E+04, 3.8710534002E+01, 5.1792819490E+00, 2.0031485903E+01, 3.7198073280E+00, 9.7482339261E-01],
	[4.3540000000E+04, 3.8718363172E+01, 5.1793221290E+00, 2.0038976547E+01, 3.7201585745E+00, 9.7483375096E-01],
	[4.3545000000E+04, 3.8726193025E+01, 5.1793623047E+00, 2.0046469131E+01, 3.7205097357E+00, 9.7484410437E-01],
	[4.3550000000E+04, 3.8734023563E+01, 5.1794024761E+00, 2.0053963653E+01, 3.7208608115E+00, 9.7485445282E-01],
	[4.3555000000E+04, 3.8741854785E+01, 5.1794426431E+00, 2.0061460115E+01, 3.7212118019E+00, 9.7486479633E-01],
	[4.3560000000E+04, 3.8749686691E+01, 5.1794828059E+00, 2.0068958515E+01, 3.7215627070E+00, 9.7487513490E-01],
	[4.3565000000E+04, 3.8757519282E+01, 5.1795229644E+00, 2.0076458856E+01, 3.7219135268E+00, 9.7488546852E-01],
	[4.3570000000E+04, 3.8765352556E+01, 5.1795631186E+00, 2.0083961136E+01, 3.7222642614E+00, 9.7489579720E-01],
	[4.3575000000E+04, 3.8773186514E+01, 5.1796032685E+00, 2.0091465357E+01, 3.7226149106E+00, 9.7490612095E-01],
	[4.3580000000E+04, 3.8781021156E+01, 5.1796434142E+00, 2.0098971518E+01, 3.7229654746E+00, 9.7491643976E-01],
	[4.3585000000E+04, 3.8788856483E+01, 5.1796835555E+00, 2.0106479620E+01, 3.7233159534E+00, 9.7492675364E-01],
	[4.3590000000E+04, 3.8796692493E+01, 5.1797236925E+00, 2.0113989663E+01, 3.7236663469E+00, 9.7493706259E-01],
	[4.3595000000E+04, 3.8804529187E+01, 5.1797638252E+00, 2.0121501648E+01, 3.7240166553E+00, 9.7494736662E-01],
	[4.3600000000E+04, 3.8812366565E+01, 5.1798039536E+00, 2.0129015574E+01, 3.7243668785E+00, 9.7495766573E-01],
	[4.3605000000E+04, 3.8820204627E+01, 5.1798440778E+00, 2.0136531442E+01, 3.7247170165E+00, 9.7496795991E-01],
	[4.3610000000E+04, 3.8828043373E+01, 5.1798841976E+00, 2.0144049252E+01, 3.7250670694E+00, 9.7497824918E-01],
	[4.3615000000E+04, 3.8835882803E+01, 5.1799243132E+00, 2.0151569004E+01, 3.7254170372E+00, 9.7498853353E-01],
	[4.3620000000E+04, 3.8843722917E+01, 5.1799644245E+00, 2.0159090700E+01, 3.7257669199E+00, 9.7499881298E-01],
	[4.3625000000E+04, 3.8851563714E+01, 5.1800045315E+00, 2.0166614338E+01, 3.7261167175E+00, 9.7500908751E-01],
	[4.3630000000E+04, 3.8859405195E+01, 5.1800446342E+00, 2.0174139920E+01, 3.7264664300E+00, 9.7501935713E-01],
	[4.3635000000E+04, 3.8867247361E+01, 5.1800847326E+00, 2.0181667445E+01, 3.7268160576E+00, 9.7502962186E-01],
	[4.3640000000E+04, 3.8875090210E+01, 5.1801248267E+00, 2.0189196914E+01, 3.7271656001E+00, 9.7503988168E-01],
	[4.3645000000E+04, 3.8882933742E+01, 5.1801649166E+00, 2.0196728327E+01, 3.7275150576E+00, 9.7505013660E-01],
	[4.3650000000E+04, 3.8890777959E+01, 5.1802050022E+00, 2.0204261685E+01, 3.7278644301E+00, 9.7506038663E-01],
	[4.3655000000E+04, 3.8898622859E+01, 5.1802450835E+00, 2.0211796987E+01, 3.7282137177E+00, 9.7507063176E-01],
	[4.3660000000E+04, 3.8906468443E+01, 5.1802851605E+00, 2.0219334234E+01, 3.7285629203E+00, 9.7508087200E-01],
	[4.3665000000E+04, 3.8914314710E+01, 5.1803252332E+00, 2.0226873427E+01, 3.7289120381E+00, 9.7509110736E-01],
	[4.3670000000E+04, 3.8922161662E+01, 5.1803653016E+00, 2.0234414565E+01, 3.7292610709E+00, 9.7510133783E-01],
	[4.3675000000E+04, 3.8930009297E+01, 5.1804053658E+00, 2.0241957649E+01, 3.7296100188E+00, 9.7511156342E-01],
	[4.3680000000E+04, 3.8937857615E+01, 5.1804454257E+00, 2.0249502679E+01, 3.7299588819E+00, 9.7512178412E-01],
	[4.3685000000E+04, 3.8945706617E+01, 5.1804854813E+00, 2.0257049655E+01, 3.7303076602E+00, 9.7513199996E-01],
	[4.3690000000E+04, 3.8953556303E+01, 5.1805255327E+00, 2.0264598578E+01, 3.7306563536E+00, 9.7514221091E-01],
	[4.3695000000E+04, 3.8961406673E+01, 5.1805655798E+00, 2.0272149448E+01, 3.7310049622E+00, 9.7515241700E-01],
	[4.3700000000E+04, 3.8969257726E+01, 5.1806056226E+00, 2.0279702265E+01, 3.7313534861E+00, 9.7516261821E-01],
	[4.3705000000E+04, 3.8977109462E+01, 5.1806456611E+00, 2.0287257030E+01, 3.7317019252E+00, 9.7517281456E-01],
	[4.3710000000E+04, 3.8984961882E+01, 5.1806856953E+00, 2.0294813742E+01, 3.7320502795E+00, 9.7518300604E-01],
	[4.3715000000E+04, 3.8992814986E+01, 5.1807257253E+00, 2.0302372402E+01, 3.7323985491E+00, 9.7519319266E-01],
	[4.3720000000E+04, 3.9000668773E+01, 5.1807657510E+00, 2.0309933011E+01, 3.7327467340E+00, 9.7520337442E-01],
	[4.3725000000E+04, 3.9008523243E+01, 5.1808057725E+00, 2.0317495568E+01, 3.7330948343E+00, 9.7521355132E-01],
	[4.3730000000E+04, 3.9016378397E+01, 5.1808457897E+00, 2.0325060074E+01, 3.7334428499E+00, 9.7522372336E-01],
	[4.3735000000E+04, 3.9024234234E+01, 5.1808858026E+00, 2.0332626529E+01, 3.7337907808E+00, 9.7523389055E-01],
	[4.3740000000E+04, 3.9032090755E+01, 5.1809258112E+00, 2.0340194934E+01, 3.7341386271E+00, 9.7524405289E-01],
	[4.3745000000E+04, 3.9039947959E+01, 5.1809658156E+00, 2.0347765288E+01, 3.7344863888E+00, 9.7525421038E-01],
	[4.3750000000E+04, 3.9047805847E+01, 5.1810058158E+00, 2.0355337593E+01, 3.7348340659E+00, 9.7526436302E-01],
	[4.3755000000E+04, 3.9055664418E+01, 5.1810458116E+00, 2.0362911847E+01, 3.7351816585E+00, 9.7527451082E-01],
	[4.3760000000E+04, 3.9063523672E+01, 5.1810858032E+00, 2.0370488053E+01, 3.7355291665E+00, 9.7528465378E-01],
	[4.3765000000E+04, 3.9071383609E+01, 5.1811257906E+00, 2.0378066209E+01, 3.7358765900E+00, 9.7529479189E-01],
	[4.3770000000E+04, 3.9079244230E+01, 5.1811657736E+00, 2.0385646316E+01, 3.7362239289E+00, 9.7530492518E-01],
	[4.3775000000E+04, 3.9087105534E+01, 5.1812057525E+00, 2.0393228374E+01, 3.7365711834E+00, 9.7531505362E-01],
	[4.3780000000E+04, 3.9094967522E+01, 5.1812457270E+00, 2.0400812384E+01, 3.7369183535E+00, 9.7532517724E-01],
	[4.3785000000E+04, 3.9102830192E+01, 5.1812856973E+00, 2.0408398346E+01, 3.7372654390E+00, 9.7533529602E-01],
	[4.3790000000E+04, 3.9110693546E+01, 5.1813256634E+00, 2.0415986261E+01, 3.7376124402E+00, 9.7534540998E-01],
	[4.3795000000E+04, 3.9118557583E+01, 5.1813656252E+00, 2.0423576127E+01, 3.7379593569E+00, 9.7535551911E-01],
	[4.3800000000E+04, 3.9126422304E+01, 5.1814055827E+00, 2.0431167947E+01, 3.7383061893E+00, 9.7536562342E-01],
	[4.3805000000E+04, 3.9134287707E+01, 5.1814455360E+00, 2.0438761719E+01, 3.7386529373E+00, 9.7537572291E-01],
	[4.3810000000E+04, 3.9142153794E+01, 5.1814854850E+00, 2.0446357445E+01, 3.7389996009E+00, 9.7538581758E-01],
	[4.3815000000E+04, 3.9150020563E+01, 5.1815254298E+00, 2.0453955125E+01, 3.7393461802E+00, 9.7539590744E-01],
	[4.3820000000E+04, 3.9157888016E+01, 5.1815653704E+00, 2.0461554758E+01, 3.7396926752E+00, 9.7540599248E-01],
	[4.3825000000E+04, 3.9165756152E+01, 5.1816053067E+00, 2.0469156346E+01, 3.7400390859E+00, 9.7541607271E-01],
	[4.3830000000E+04, 3.9173624971E+01, 5.1816452387E+00, 2.0476759888E+01, 3.7403854124E+00, 9.7542614813E-01],
	[4.3835000000E+04, 3.9181494473E+01, 5.1816851665E+00, 2.0484365384E+01, 3.7407316546E+00, 9.7543621875E-01],
	[4.3840000000E+04, 3.9189364658E+01, 5.1817250900E+00, 2.0491972836E+01, 3.7410778125E+00, 9.7544628457E-01],
	[4.3845000000E+04, 3.9197235526E+01, 5.1817650093E+00, 2.0499582243E+01, 3.7414238862E+00, 9.7545634558E-01],
	[4.3850000000E+04, 3.9205107077E+01, 5.1818049244E+00, 2.0507193605E+01, 3.7417698758E+00, 9.7546640179E-01],
	[4.3855000000E+04, 3.9212979311E+01, 5.1818448352E+00, 2.0514806924E+01, 3.7421157812E+00, 9.7547645321E-01],
	[4.3860000000E+04, 3.9220852229E+01, 5.1818847418E+00, 2.0522422198E+01, 3.7424616024E+00, 9.7548649983E-01],
	[4.3865000000E+04, 3.9228725829E+01, 5.1819246441E+00, 2.0530039429E+01, 3.7428073395E+00, 9.7549654167E-01],
	[4.3870000000E+04, 3.9236600111E+01, 5.1819645422E+00, 2.0537658617E+01, 3.7431529925E+00, 9.7550657871E-01],
	[4.3875000000E+04, 3.9244475077E+01, 5.1820044360E+00, 2.0545279761E+01, 3.7434985614E+00, 9.7551661097E-01],
	[4.3880000000E+04, 3.9252358106E+01, 5.1820452032E+00, 2.0552902863E+01, 3.7438445714E+00, 9.7552663844E-01],
	[4.3885000000E+04, 3.9260250522E+01, 5.1820870008E+00, 2.0560527922E+01, 3.7441911167E+00, 9.7553666113E-01],
	[4.3890000000E+04, 3.9268143626E+01, 5.1821287939E+00, 2.0568154939E+01, 3.7445375783E+00, 9.7554667904E-01],
	[4.3895000000E+04, 3.9276037417E+01, 5.1821705826E+00, 2.0575783914E+01, 3.7448839560E+00, 9.7555669217E-01],
	[4.3900000000E+04, 3.9283931895E+01, 5.1822123669E+00, 2.0583414848E+01, 3.7452302500E+00, 9.7556670053E-01],
	[4.3905000000E+04, 3.9291827061E+01, 5.1822541468E+00, 2.0591047740E+01, 3.7455764602E+00, 9.7557670411E-01],
	[4.3910000000E+04, 3.9299722914E+01, 5.1822959222E+00, 2.0598682591E+01, 3.7459225867E+00, 9.7558670292E-01],
	[4.3915000000E+04, 3.9307619455E+01, 5.1823376933E+00, 2.0606319401E+01, 3.7462686294E+00, 9.7559669697E-01],
	[4.3920000000E+04, 3.9315516683E+01, 5.1823794599E+00, 2.0613958170E+01, 3.7466145885E+00, 9.7560668625E-01],
	[4.3925000000E+04, 3.9323414599E+01, 5.1824212221E+00, 2.0621598900E+01, 3.7469604638E+00, 9.7561667077E-01],
	[4.3930000000E+04, 3.9331313201E+01, 5.1824629799E+00, 2.0629241589E+01, 3.7473062555E+00, 9.7562665053E-01],
	[4.3935000000E+04, 3.9339212492E+01, 5.1825047332E+00, 2.0636886239E+01, 3.7476519636E+00, 9.7563662552E-01],
	[4.3940000000E+04, 3.9347112469E+01, 5.1825464822E+00, 2.0644532849E+01, 3.7479975880E+00, 9.7564659577E-01],
	[4.3945000000E+04, 3.9355013134E+01, 5.1825882267E+00, 2.0652181420E+01, 3.7483431289E+00, 9.7565656126E-01],
	[4.3950000000E+04, 3.9362914486E+01, 5.1826299668E+00, 2.0659831952E+01, 3.7486885861E+00, 9.7566652199E-01],
	[4.3955000000E+04, 3.9370816525E+01, 5.1826717025E+00, 2.0667484446E+01, 3.7490339598E+00, 9.7567647798E-01],
	[4.3960000000E+04, 3.9378719251E+01, 5.1827134338E+00, 2.0675138901E+01, 3.7493792500E+00, 9.7568642923E-01],
	[4.3965000000E+04, 3.9386622665E+01, 5.1827551607E+00, 2.0682795318E+01, 3.7497244566E+00, 9.7569637572E-01],
	[4.3970000000E+04, 3.9394526766E+01, 5.1827968832E+00, 2.0690453698E+01, 3.7500695797E+00, 9.7570631748E-01],
	[4.3975000000E+04, 3.9402431553E+01, 5.1828386012E+00, 2.0698114040E+01, 3.7504146194E+00, 9.7571625450E-01],
	[4.3980000000E+04, 3.9410337029E+01, 5.1828803149E+00, 2.0705776345E+01, 3.7507595755E+00, 9.7572618678E-01],
	[4.3985000000E+04, 3.9418243191E+01, 5.1829220241E+00, 2.0713440613E+01, 3.7511044483E+00, 9.7573611432E-01],
	[4.3990000000E+04, 3.9426150040E+01, 5.1829637290E+00, 2.0721106844E+01, 3.7514492376E+00, 9.7574603714E-01],
	[4.3995000000E+04, 3.9434057577E+01, 5.1830054294E+00, 2.0728775039E+01, 3.7517939434E+00, 9.7575595522E-01],
	[4.4000000000E+04, 3.9441965800E+01, 5.1830471255E+00, 2.0736445198E+01, 3.7521385659E+00, 9.7576586857E-01],
	[4.4005000000E+04, 3.9449874711E+01, 5.1830888171E+00, 2.0744117321E+01, 3.7524831051E+00, 9.7577577720E-01],
	[4.4010000000E+04, 3.9457784308E+01, 5.1831305043E+00, 2.0751791409E+01, 3.7528275609E+00, 9.7578568111E-01],
	[4.4015000000E+04, 3.9465694593E+01, 5.1831721872E+00, 2.0759467461E+01, 3.7531719333E+00, 9.7579558030E-01],
	[4.4020000000E+04, 3.9473605565E+01, 5.1832138656E+00, 2.0767145478E+01, 3.7535162224E+00, 9.7580547477E-01],
	[4.4025000000E+04, 3.9481517223E+01, 5.1832555396E+00, 2.0774825461E+01, 3.7538604283E+00, 9.7581536452E-01],
	[4.4030000000E+04, 3.9489429569E+01, 5.1832972093E+00, 2.0782507409E+01, 3.7542045509E+00, 9.7582524956E-01],
	[4.4035000000E+04, 3.9497342601E+01, 5.1833388745E+00, 2.0790191323E+01, 3.7545485902E+00, 9.7583512989E-01],
	[4.4040000000E+04, 3.9505256321E+01, 5.1833805353E+00, 2.0797877204E+01, 3.7548925463E+00, 9.7584500551E-01],
	[4.4045000000E+04, 3.9513170727E+01, 5.1834221918E+00, 2.0805565050E+01, 3.7552364192E+00, 9.7585487642E-01],
	[4.4050000000E+04, 3.9521085820E+01, 5.1834638439E+00, 2.0813254864E+01, 3.7555802089E+00, 9.7586474263E-01],
	[4.4055000000E+04, 3.9529001601E+01, 5.1835054915E+00, 2.0820946644E+01, 3.7559239154E+00, 9.7587460414E-01],
	[4.4060000000E+04, 3.9536918068E+01, 5.1835471348E+00, 2.0828640392E+01, 3.7562675387E+00, 9.7588446095E-01],
	[4.4065000000E+04, 3.9544835221E+01, 5.1835887737E+00, 2.0836336107E+01, 3.7566110790E+00, 9.7589431307E-01],
	[4.4070000000E+04, 3.9552753062E+01, 5.1836304082E+00, 2.0844033790E+01, 3.7569545361E+00, 9.7590416048E-01],
	[4.4075000000E+04, 3.9560671590E+01, 5.1836720383E+00, 2.0851733441E+01, 3.7572979101E+00, 9.7591400321E-01],
	[4.4080000000E+04, 3.9568590804E+01, 5.1837136640E+00, 2.0859435061E+01, 3.7576412010E+00, 9.7592384125E-01],
	[4.4085000000E+04, 3.9576510705E+01, 5.1837552853E+00, 2.0867138649E+01, 3.7579844089E+00, 9.7593367459E-01],
	[4.4090000000E+04, 3.9584431293E+01, 5.1837969022E+00, 2.0874844206E+01, 3.7583275337E+00, 9.7594350326E-01],
	[4.4095000000E+04, 3.9592352567E+01, 5.1838385148E+00, 2.0882551733E+01, 3.7586705756E+00, 9.7595332724E-01],
	[4.4100000000E+04, 3.9600274528E+01, 5.1838801230E+00, 2.0890261229E+01, 3.7590135344E+00, 9.7596314654E-01],
	[4.4105000000E+04, 3.9608197176E+01, 5.1839217267E+00, 2.0897972694E+01, 3.7593564102E+00, 9.7597296116E-01],
	[4.4110000000E+04, 3.9616120511E+01, 5.1839633262E+00, 2.0905686130E+01, 3.7596992031E+00, 9.7598277111E-01],
	[4.4115000000E+04, 3.9624044532E+01, 5.1840049212E+00, 2.0913401536E+01, 3.7600419131E+00, 9.7599257639E-01],
	[4.4120000000E+04, 3.9631969240E+01, 5.1840465118E+00, 2.0921118913E+01, 3.7603845401E+00, 9.7600237699E-01],
	[4.4125000000E+04, 3.9639894634E+01, 5.1840880981E+00, 2.0928838260E+01, 3.7607270842E+00, 9.7601217292E-01],
	[4.4130000000E+04, 3.9647820715E+01, 5.1841296800E+00, 2.0936559579E+01, 3.7610695455E+00, 9.7602196419E-01],
	[4.4135000000E+04, 3.9655747483E+01, 5.1841712575E+00, 2.0944282870E+01, 3.7614119239E+00, 9.7603175080E-01],
	[4.4140000000E+04, 3.9663674937E+01, 5.1842128306E+00, 2.0952008131E+01, 3.7617542194E+00, 9.7604153274E-01],
	[4.4145000000E+04, 3.9671603078E+01, 5.1842543994E+00, 2.0959735365E+01, 3.7620964321E+00, 9.7605131002E-01],
	[4.4150000000E+04, 3.9679531905E+01, 5.1842959637E+00, 2.0967464572E+01, 3.7624385621E+00, 9.7606108265E-01],
	[4.4155000000E+04, 3.9687461419E+01, 5.1843375237E+00, 2.0975195751E+01, 3.7627806092E+00, 9.7607085063E-01],
	[4.4160000000E+04, 3.9695391619E+01, 5.1843790794E+00, 2.0982928902E+01, 3.7631225735E+00, 9.7608061395E-01],
	[4.4165000000E+04, 3.9703322506E+01, 5.1844206306E+00, 2.0990664027E+01, 3.7634644552E+00, 9.7609037262E-01],
	[4.4170000000E+04, 3.9711254079E+01, 5.1844621775E+00, 2.0998401125E+01, 3.7638062541E+00, 9.7610012664E-01],
	[4.4175000000E+04, 3.9719186338E+01, 5.1845037200E+00, 2.1006140197E+01, 3.7641479703E+00, 9.7610987602E-01],
	[4.4180000000E+04, 3.9727119285E+01, 5.1845452582E+00, 2.1013881243E+01, 3.7644896038E+00, 9.7611962076E-01],
	[4.4185000000E+04, 3.9735052917E+01, 5.1845867920E+00, 2.1021624264E+01, 3.7648311546E+00, 9.7612936085E-01],
	[4.4190000000E+04, 3.9742987236E+01, 5.1846283214E+00, 2.1029369258E+01, 3.7651726228E+00, 9.7613909631E-01],
	[4.4195000000E+04, 3.9750922241E+01, 5.1846698465E+00, 2.1037116228E+01, 3.7655140083E+00, 9.7614882713E-01],
	[4.4200000000E+04, 3.9758857932E+01, 5.1847113671E+00, 2.1044865172E+01, 3.7658553113E+00, 9.7615855332E-01],
	[4.4205000000E+04, 3.9766794310E+01, 5.1847528835E+00, 2.1052616092E+01, 3.7661965317E+00, 9.7616827488E-01],
	[4.4210000000E+04, 3.9774731374E+01, 5.1847943954E+00, 2.1060368988E+01, 3.7665376695E+00, 9.7617799181E-01],
	[4.4215000000E+04, 3.9782669125E+01, 5.1848359030E+00, 2.1068123860E+01, 3.7668787247E+00, 9.7618770412E-01],
	[4.4220000000E+04, 3.9790607562E+01, 5.1848774062E+00, 2.1075880707E+01, 3.7672196974E+00, 9.7619741180E-01],
	[4.4225000000E+04, 3.9798546684E+01, 5.1849189051E+00, 2.1083639531E+01, 3.7675605876E+00, 9.7620711486E-01],
	[4.4230000000E+04, 3.9806486494E+01, 5.1849603996E+00, 2.1091400332E+01, 3.7679013953E+00, 9.7621681329E-01],
	[4.4235000000E+04, 3.9814426989E+01, 5.1850018898E+00, 2.1099163111E+01, 3.7682421206E+00, 9.7622650712E-01],
	[4.4240000000E+04, 3.9822368171E+01, 5.1850433756E+00, 2.1106927866E+01, 3.7685827634E+00, 9.7623619632E-01],
	[4.4245000000E+04, 3.9830310038E+01, 5.1850848570E+00, 2.1114694599E+01, 3.7689233237E+00, 9.7624588092E-01],
	[4.4250000000E+04, 3.9838252592E+01, 5.1851263341E+00, 2.1122463310E+01, 3.7692638016E+00, 9.7625556091E-01],
	[4.4255000000E+04, 3.9846195832E+01, 5.1851678069E+00, 2.1130233999E+01, 3.7696041972E+00, 9.7626523629E-01],
	[4.4260000000E+04, 3.9854139759E+01, 5.1852092752E+00, 2.1138006666E+01, 3.7699445104E+00, 9.7627490706E-01],
	[4.4265000000E+04, 3.9862084371E+01, 5.1852507393E+00, 2.1145781312E+01, 3.7702847412E+00, 9.7628457323E-01],
	[4.4270000000E+04, 3.9870029669E+01, 5.1852921989E+00, 2.1153557937E+01, 3.7706248897E+00, 9.7629423480E-01],
	[4.4275000000E+04, 3.9877975654E+01, 5.1853336543E+00, 2.1161336542E+01, 3.7709649558E+00, 9.7630389177E-01],
	[4.4280000000E+04, 3.9885922324E+01, 5.1853751052E+00, 2.1169117126E+01, 3.7713049397E+00, 9.7631354415E-01],
	[4.4285000000E+04, 3.9893869681E+01, 5.1854165519E+00, 2.1176899690E+01, 3.7716448413E+00, 9.7632319193E-01],
	[4.4290000000E+04, 3.9901817723E+01, 5.1854579941E+00, 2.1184684234E+01, 3.7719846606E+00, 9.7633283512E-01],
	[4.4295000000E+04, 3.9909766452E+01, 5.1854994321E+00, 2.1192470758E+01, 3.7723243977E+00, 9.7634247373E-01],
	[4.4300000000E+04, 3.9917715866E+01, 5.1855408656E+00, 2.1200259263E+01, 3.7726640526E+00, 9.7635210774E-01],
	[4.4305000000E+04, 3.9925665967E+01, 5.1855822949E+00, 2.1208049749E+01, 3.7730036252E+00, 9.7636173718E-01],
	[4.4310000000E+04, 3.9933616753E+01, 5.1856237198E+00, 2.1215842216E+01, 3.7733431157E+00, 9.7637136203E-01],
	[4.4315000000E+04, 3.9941568226E+01, 5.1856651403E+00, 2.1223636665E+01, 3.7736825241E+00, 9.7638098230E-01],
	[4.4320000000E+04, 3.9949520384E+01, 5.1857065565E+00, 2.1231433095E+01, 3.7740218503E+00, 9.7639059800E-01],
	[4.4325000000E+04, 3.9957473228E+01, 5.1857479684E+00, 2.1239231508E+01, 3.7743610943E+00, 9.7640020912E-01],
	[4.4330000000E+04, 3.9965426758E+01, 5.1857893759E+00, 2.1247031903E+01, 3.7747002563E+00, 9.7640981566E-01],
	[4.4335000000E+04, 3.9973380974E+01, 5.1858307791E+00, 2.1254834280E+01, 3.7750393362E+00, 9.7641941764E-01],
	[4.4340000000E+04, 3.9981335876E+01, 5.1858721780E+00, 2.1262638641E+01, 3.7753783340E+00, 9.7642901505E-01],
	[4.4345000000E+04, 3.9989291463E+01, 5.1859135725E+00, 2.1270444985E+01, 3.7757172498E+00, 9.7643860790E-01],
	[4.4350000000E+04, 3.9997247736E+01, 5.1859549626E+00, 2.1278253312E+01, 3.7760560836E+00, 9.7644819618E-01],
	[4.4355000000E+04, 4.0005204696E+01, 5.1859963485E+00, 2.1286063623E+01, 3.7763948353E+00, 9.7645777990E-01],
	[4.4360000000E+04, 4.0013162340E+01, 5.1860377300E+00, 2.1293875917E+01, 3.7767335051E+00, 9.7646735906E-01],
	[4.4365000000E+04, 4.0021120671E+01, 5.1860791071E+00, 2.1301690197E+01, 3.7770720929E+00, 9.7647693367E-01],
	[4.4370000000E+04, 4.0029079687E+01, 5.1861204800E+00, 2.1309506461E+01, 3.7774105987E+00, 9.7648650372E-01],
	[4.4375000000E+04, 4.0037039389E+01, 5.1861618485E+00, 2.1317324709E+01, 3.7777490227E+00, 9.7649606922E-01],
	[4.4380000000E+04, 4.0044999777E+01, 5.1862032127E+00, 2.1325144943E+01, 3.7780873647E+00, 9.7650563017E-01],
	[4.4385000000E+04, 4.0052960850E+01, 5.1862445725E+00, 2.1332967162E+01, 3.7784256248E+00, 9.7651518658E-01],
	[4.4390000000E+04, 4.0060922609E+01, 5.1862859280E+00, 2.1340791367E+01, 3.7787638031E+00, 9.7652473844E-01],
	[4.4395000000E+04, 4.0068885054E+01, 5.1863272792E+00, 2.1348617558E+01, 3.7791018995E+00, 9.7653428576E-01],
	[4.4400000000E+04, 4.0076848184E+01, 5.1863686261E+00, 2.1356445735E+01, 3.7794399141E+00, 9.7654382854E-01],
	[4.4405000000E+04, 4.0084812000E+01, 5.1864099686E+00, 2.1364275899E+01, 3.7797778469E+00, 9.7655336678E-01],
	[4.4410000000E+04, 4.0092776501E+01, 5.1864513068E+00, 2.1372108050E+01, 3.7801156979E+00, 9.7656290048E-01],
	[4.4415000000E+04, 4.0100741688E+01, 5.1864926407E+00, 2.1379942187E+01, 3.7804534671E+00, 9.7657242966E-01],
	[4.4420000000E+04, 4.0108707561E+01, 5.1865339702E+00, 2.1387778312E+01, 3.7807911546E+00, 9.7658195430E-01],
	[4.4425000000E+04, 4.0116674119E+01, 5.1865752955E+00, 2.1395616425E+01, 3.7811287603E+00, 9.7659147442E-01],
	[4.4430000000E+04, 4.0124641363E+01, 5.1866166164E+00, 2.1403456526E+01, 3.7814662843E+00, 9.7660099001E-01],
	[4.4435000000E+04, 4.0132609292E+01, 5.1866579330E+00, 2.1411298615E+01, 3.7818037266E+00, 9.7661050107E-01],
	[4.4440000000E+04, 4.0140577906E+01, 5.1866992452E+00, 2.1419142692E+01, 3.7821410873E+00, 9.7662000762E-01],
	[4.4445000000E+04, 4.0148547206E+01, 5.1867405532E+00, 2.1426988758E+01, 3.7824783663E+00, 9.7662950964E-01],
	[4.4450000000E+04, 4.0156517191E+01, 5.1867818568E+00, 2.1434836814E+01, 3.7828155637E+00, 9.7663900715E-01],
	[4.4455000000E+04, 4.0164487862E+01, 5.1868231562E+00, 2.1442686858E+01, 3.7831526794E+00, 9.7664850015E-01],
	[4.4460000000E+04, 4.0172459218E+01, 5.1868644512E+00, 2.1450538892E+01, 3.7834897136E+00, 9.7665798863E-01],
	[4.4465000000E+04, 4.0180431260E+01, 5.1869057419E+00, 2.1458392916E+01, 3.7838266662E+00, 9.7666747260E-01],
	[4.4470000000E+04, 4.0188403987E+01, 5.1869470282E+00, 2.1466248931E+01, 3.7841635372E+00, 9.7667695207E-01],
	[4.4475000000E+04, 4.0196377399E+01, 5.1869883103E+00, 2.1474106935E+01, 3.7845003267E+00, 9.7668642703E-01],
	[4.4480000000E+04, 4.0204351497E+01, 5.1870295880E+00, 2.1481966931E+01, 3.7848370346E+00, 9.7669589749E-01],
	[4.4485000000E+04, 4.0212326280E+01, 5.1870708615E+00, 2.1489828917E+01, 3.7851736611E+00, 9.7670536345E-01],
	[4.4490000000E+04, 4.0220301748E+01, 5.1871121306E+00, 2.1497692895E+01, 3.7855102061E+00, 9.7671482491E-01],
	[4.4495000000E+04, 4.0228277901E+01, 5.1871533954E+00, 2.1505558865E+01, 3.7858466696E+00, 9.7672428187E-01],
	[4.4500000000E+04, 4.0236254740E+01, 5.1871946559E+00, 2.1513426826E+01, 3.7861830517E+00, 9.7673373434E-01],
	[4.4505000000E+04, 4.0244232264E+01, 5.1872359121E+00, 2.1521296779E+01, 3.7865193524E+00, 9.7674318232E-01],
	[4.4510000000E+04, 4.0252210473E+01, 5.1872771640E+00, 2.1529168725E+01, 3.7868555717E+00, 9.7675262581E-01],
	[4.4515000000E+04, 4.0260189367E+01, 5.1873184116E+00, 2.1537042663E+01, 3.7871917096E+00, 9.7676206482E-01],
	[4.4520000000E+04, 4.0268168947E+01, 5.1873596549E+00, 2.1544918595E+01, 3.7875277661E+00, 9.7677149934E-01],
	[4.4525000000E+04, 4.0276149212E+01, 5.1874008939E+00, 2.1552796520E+01, 3.7878637413E+00, 9.7678092938E-01],
	[4.4530000000E+04, 4.0284130161E+01, 5.1874421286E+00, 2.1560676438E+01, 3.7881996352E+00, 9.7679035494E-01],
	[4.4535000000E+04, 4.0292111796E+01, 5.1874833589E+00, 2.1568558350E+01, 3.7885354477E+00, 9.7679977602E-01],
	[4.4540000000E+04, 4.0300094116E+01, 5.1875245850E+00, 2.1576442256E+01, 3.7888711790E+00, 9.7680919263E-01],
	[4.4545000000E+04, 4.0308077121E+01, 5.1875658068E+00, 2.1584328157E+01, 3.7892068290E+00, 9.7681860476E-01],
	[4.4550000000E+04, 4.0316060812E+01, 5.1876070243E+00, 2.1592216052E+01, 3.7895423978E+00, 9.7682801243E-01],
	[4.4555000000E+04, 4.0324045187E+01, 5.1876482374E+00, 2.1600105942E+01, 3.7898778853E+00, 9.7683741562E-01],
	[4.4560000000E+04, 4.0332030247E+01, 5.1876894463E+00, 2.1607997827E+01, 3.7902132917E+00, 9.7684681435E-01],
	[4.4565000000E+04, 4.0340015992E+01, 5.1877306509E+00, 2.1615891708E+01, 3.7905486168E+00, 9.7685620862E-01],
	[4.4570000000E+04, 4.0348002423E+01, 5.1877718512E+00, 2.1623787585E+01, 3.7908838608E+00, 9.7686559843E-01],
	[4.4575000000E+04, 4.0355989538E+01, 5.1878130472E+00, 2.1631685458E+01, 3.7912190236E+00, 9.7687498377E-01],
	[4.4580000000E+04, 4.0363977338E+01, 5.1878542389E+00, 2.1639585327E+01, 3.7915541054E+00, 9.7688436466E-01],
	[4.4585000000E+04, 4.0371968772E+01, 5.1878957715E+00, 2.1647487192E+01, 3.7918893164E+00, 9.7689374110E-01],
	[4.4590000000E+04, 4.0379973912E+01, 5.1879388243E+00, 2.1655391055E+01, 3.7922253758E+00, 9.7690311309E-01],
	[4.4595000000E+04, 4.0387979741E+01, 5.1879818726E+00, 2.1663296914E+01, 3.7925613543E+00, 9.7691248062E-01],
	[4.4600000000E+04, 4.0395986260E+01, 5.1880249165E+00, 2.1671204772E+01, 3.7928972520E+00, 9.7692184371E-01],
	[4.4605000000E+04, 4.0403993469E+01, 5.1880679558E+00, 2.1679114627E+01, 3.7932330688E+00, 9.7693120235E-01],
	[4.4610000000E+04, 4.0412001366E+01, 5.1881109907E+00, 2.1687026479E+01, 3.7935688048E+00, 9.7694055655E-01],
	[4.4615000000E+04, 4.0420009953E+01, 5.1881540212E+00, 2.1694940331E+01, 3.7939044601E+00, 9.7694990631E-01],
	[4.4620000000E+04, 4.0428019230E+01, 5.1881970472E+00, 2.1702856180E+01, 3.7942400345E+00, 9.7695925164E-01],
	[4.4625000000E+04, 4.0436029196E+01, 5.1882400687E+00, 2.1710774029E+01, 3.7945755283E+00, 9.7696859252E-01],
	[4.4630000000E+04, 4.0444039851E+01, 5.1882830857E+00, 2.1718693877E+01, 3.7949109412E+00, 9.7697792897E-01],
	[4.4635000000E+04, 4.0452051195E+01, 5.1883260983E+00, 2.1726615724E+01, 3.7952462735E+00, 9.7698726100E-01],
	[4.4640000000E+04, 4.0460063229E+01, 5.1883691064E+00, 2.1734539571E+01, 3.7955815251E+00, 9.7699658859E-01],
	[4.4645000000E+04, 4.0468075952E+01, 5.1884121101E+00, 2.1742465418E+01, 3.7959166960E+00, 9.7700591176E-01],
	[4.4650000000E+04, 4.0476089364E+01, 5.1884551093E+00, 2.1750393265E+01, 3.7962517863E+00, 9.7701523050E-01],
	[4.4655000000E+04, 4.0484103465E+01, 5.1884981040E+00, 2.1758323113E+01, 3.7965867959E+00, 9.7702454482E-01],
	[4.4660000000E+04, 4.0492118256E+01, 5.1885410943E+00, 2.1766254961E+01, 3.7969217249E+00, 9.7703385472E-01],
	[4.4665000000E+04, 4.0500133736E+01, 5.1885840801E+00, 2.1774188811E+01, 3.7972565733E+00, 9.7704316020E-01],
	[4.4670000000E+04, 4.0508149905E+01, 5.1886270615E+00, 2.1782124662E+01, 3.7975913411E+00, 9.7705246127E-01],
	[4.4675000000E+04, 4.0516166763E+01, 5.1886700384E+00, 2.1790062514E+01, 3.7979260284E+00, 9.7706175792E-01],
	[4.4680000000E+04, 4.0524184310E+01, 5.1887130109E+00, 2.1798002369E+01, 3.7982606351E+00, 9.7707105017E-01],
	[4.4685000000E+04, 4.0532202546E+01, 5.1887559789E+00, 2.1805944225E+01, 3.7985951614E+00, 9.7708033800E-01],
	[4.4690000000E+04, 4.0540221472E+01, 5.1887989425E+00, 2.1813888085E+01, 3.7989296071E+00, 9.7708962143E-01],
	[4.4695000000E+04, 4.0548241086E+01, 5.1888419016E+00, 2.1821833947E+01, 3.7992639723E+00, 9.7709890046E-01],
	[4.4700000000E+04, 4.0556261390E+01, 5.1888848562E+00, 2.1829781812E+01, 3.7995982571E+00, 9.7710817508E-01],
	[4.4705000000E+04, 4.0564282383E+01, 5.1889278064E+00, 2.1837731680E+01, 3.7999324614E+00, 9.7711744531E-01],
	[4.4710000000E+04, 4.0572304064E+01, 5.1889707522E+00, 2.1845683552E+01, 3.8002665854E+00, 9.7712671114E-01],
	[4.4715000000E+04, 4.0580326435E+01, 5.1890136935E+00, 2.1853637428E+01, 3.8006006289E+00, 9.7713597257E-01],
	[4.4720000000E+04, 4.0588349495E+01, 5.1890566304E+00, 2.1861593308E+01, 3.8009345920E+00, 9.7714522961E-01],
	[4.4725000000E+04, 4.0596373243E+01, 5.1890995628E+00, 2.1869551193E+01, 3.8012684748E+00, 9.7715448227E-01],
	[4.4730000000E+04, 4.0604397681E+01, 5.1891424908E+00, 2.1877511082E+01, 3.8016022772E+00, 9.7716373053E-01],
	[4.4735000000E+04, 4.0612422808E+01, 5.1891854143E+00, 2.1885472976E+01, 3.8019359993E+00, 9.7717297441E-01],
	[4.4740000000E+04, 4.0620448623E+01, 5.1892283334E+00, 2.1893436876E+01, 3.8022696411E+00, 9.7718221391E-01],
	[4.4745000000E+04, 4.0628475128E+01, 5.1892712481E+00, 2.1901402781E+01, 3.8026032026E+00, 9.7719144902E-01],
	[4.4750000000E+04, 4.0636502321E+01, 5.1893141583E+00, 2.1909370692E+01, 3.8029366838E+00, 9.7720067976E-01],
	[4.4755000000E+04, 4.0644530203E+01, 5.1893570641E+00, 2.1917340609E+01, 3.8032700848E+00, 9.7720990612E-01],
	[4.4760000000E+04, 4.0652558774E+01, 5.1893999654E+00, 2.1925312533E+01, 3.8036034056E+00, 9.7721912811E-01],
	[4.4765000000E+04, 4.0660588034E+01, 5.1894428623E+00, 2.1933286463E+01, 3.8039366461E+00, 9.7722834572E-01],
	[4.4770000000E+04, 4.0668617983E+01, 5.1894857548E+00, 2.1941262400E+01, 3.8042698065E+00, 9.7723755896E-01],
	[4.4775000000E+04, 4.0676648620E+01, 5.1895286428E+00, 2.1949240345E+01, 3.8046028867E+00, 9.7724676784E-01],
	[4.4780000000E+04, 4.0684679946E+01, 5.1895715264E+00, 2.1957220297E+01, 3.8049358867E+00, 9.7725597236E-01],
	[4.4785000000E+04, 4.0692711961E+01, 5.1896144055E+00, 2.1965202256E+01, 3.8052688066E+00, 9.7726517251E-01],
	[4.4790000000E+04, 4.0700744665E+01, 5.1896572803E+00, 2.1973186224E+01, 3.8056016464E+00, 9.7727436830E-01],
	[4.4795000000E+04, 4.0708778057E+01, 5.1897001506E+00, 2.1981172201E+01, 3.8059344061E+00, 9.7728355973E-01],
	[4.4800000000E+04, 4.0716812139E+01, 5.1897430164E+00, 2.1989160186E+01, 3.8062670857E+00, 9.7729274680E-01],
	[4.4805000000E+04, 4.0724846908E+01, 5.1897858778E+00, 2.1997150180E+01, 3.8065996853E+00, 9.7730192953E-01],
	[4.4810000000E+04, 4.0732882367E+01, 5.1898287348E+00, 2.2005142183E+01, 3.8069322048E+00, 9.7731110790E-01],
	[4.4815000000E+04, 4.0740918514E+01, 5.1898715874E+00, 2.2013136195E+01, 3.8072646443E+00, 9.7732028192E-01],
	[4.4820000000E+04, 4.0748955350E+01, 5.1899144356E+00, 2.2021132218E+01, 3.8075970038E+00, 9.7732945160E-01],
	[4.4825000000E+04, 4.0756992874E+01, 5.1899572793E+00, 2.2029130250E+01, 3.8079292834E+00, 9.7733861693E-01],
	[4.4830000000E+04, 4.0765031087E+01, 5.1900001186E+00, 2.2037130293E+01, 3.8082614830E+00, 9.7734777792E-01],
	[4.4835000000E+04, 4.0773069989E+01, 5.1900429535E+00, 2.2045132346E+01, 3.8085936026E+00, 9.7735693457E-01],
	[4.4840000000E+04, 4.0781109579E+01, 5.1900857839E+00, 2.2053136411E+01, 3.8089256423E+00, 9.7736608688E-01],
	[4.4845000000E+04, 4.0789149858E+01, 5.1901286099E+00, 2.2061142486E+01, 3.8092576021E+00, 9.7737523485E-01],
	[4.4850000000E+04, 4.0797190825E+01, 5.1901714315E+00, 2.2069150573E+01, 3.8095894821E+00, 9.7738437850E-01],
	[4.4855000000E+04, 4.0805232481E+01, 5.1902142487E+00, 2.2077160672E+01, 3.8099212822E+00, 9.7739351781E-01],
	[4.4860000000E+04, 4.0813274825E+01, 5.1902570615E+00, 2.2085172783E+01, 3.8102530024E+00, 9.7740265279E-01],
	[4.4865000000E+04, 4.0821317858E+01, 5.1902998698E+00, 2.2093186906E+01, 3.8105846428E+00, 9.7741178345E-01],
	[4.4870000000E+04, 4.0829361579E+01, 5.1903426738E+00, 2.2101203041E+01, 3.8109162034E+00, 9.7742090978E-01],
	[4.4875000000E+04, 4.0837405989E+01, 5.1903854733E+00, 2.2109221190E+01, 3.8112476842E+00, 9.7743003179E-01],
	[4.4880000000E+04, 4.0845451087E+01, 5.1904282684E+00, 2.2117241351E+01, 3.8115790853E+00, 9.7743914949E-01],
	[4.4885000000E+04, 4.0853496873E+01, 5.1904710591E+00, 2.2125263526E+01, 3.8119104066E+00, 9.7744826286E-01],
	[4.4890000000E+04, 4.0861543348E+01, 5.1905138453E+00, 2.2133287715E+01, 3.8122416482E+00, 9.7745737192E-01],
	[4.4895000000E+04, 4.0869590512E+01, 5.1905566272E+00, 2.2141313918E+01, 3.8125728101E+00, 9.7746647667E-01],
	[4.4900000000E+04, 4.0877638363E+01, 5.1905994046E+00, 2.2149342135E+01, 3.8129038922E+00, 9.7747557710E-01],
	[4.4905000000E+04, 4.0885686903E+01, 5.1906421777E+00, 2.2157372366E+01, 3.8132348948E+00, 9.7748467323E-01],
	[4.4910000000E+04, 4.0893736131E+01, 5.1906849463E+00, 2.2165404613E+01, 3.8135658176E+00, 9.7749376505E-01],
	[4.4915000000E+04, 4.0901786048E+01, 5.1907277105E+00, 2.2173438874E+01, 3.8138966609E+00, 9.7750285257E-01],
	[4.4920000000E+04, 4.0909836653E+01, 5.1907704703E+00, 2.2181475151E+01, 3.8142274245E+00, 9.7751193579E-01],
	[4.4925000000E+04, 4.0917887946E+01, 5.1908132257E+00, 2.2189513443E+01, 3.8145581085E+00, 9.7752101471E-01],
	[4.4930000000E+04, 4.0925939927E+01, 5.1908559767E+00, 2.2197553752E+01, 3.8148887130E+00, 9.7753008933E-01],
	[4.4935000000E+04, 4.0933992597E+01, 5.1908987233E+00, 2.2205596077E+01, 3.8152192379E+00, 9.7753915965E-01],
	[4.4940000000E+04, 4.0942045954E+01, 5.1909414655E+00, 2.2213640418E+01, 3.8155496832E+00, 9.7754822569E-01],
	[4.4945000000E+04, 4.0950100000E+01, 5.1909842033E+00, 2.2221686776E+01, 3.8158800491E+00, 9.7755728743E-01],
	[4.4950000000E+04, 4.0958154734E+01, 5.1910269366E+00, 2.2229735151E+01, 3.8162103355E+00, 9.7756634489E-01],
	[4.4955000000E+04, 4.0966210157E+01, 5.1910696656E+00, 2.2237785543E+01, 3.8165405423E+00, 9.7757539806E-01],
	[4.4960000000E+04, 4.0974266267E+01, 5.1911123902E+00, 2.2245837953E+01, 3.8168706698E+00, 9.7758444694E-01],
	[4.4965000000E+04, 4.0982323066E+01, 5.1911551104E+00, 2.2253892381E+01, 3.8172007178E+00, 9.7759349155E-01],
	[4.4970000000E+04, 4.0990380552E+01, 5.1911978262E+00, 2.2261948827E+01, 3.8175306863E+00, 9.7760253187E-01],
	[4.4975000000E+04, 4.0998438727E+01, 5.1912405375E+00, 2.2270007292E+01, 3.8178605755E+00, 9.7761156792E-01],
	[4.4980000000E+04, 4.1006497590E+01, 5.1912832445E+00, 2.2278067775E+01, 3.8181903853E+00, 9.7762059970E-01],
	[4.4985000000E+04, 4.1014557141E+01, 5.1913259471E+00, 2.2286130277E+01, 3.8185201157E+00, 9.7762962720E-01],
	[4.4990000000E+04, 4.1022617379E+01, 5.1913686453E+00, 2.2294194799E+01, 3.8188497668E+00, 9.7763865043E-01],
	[4.4995000000E+04, 4.1030678306E+01, 5.1914113391E+00, 2.2302261340E+01, 3.8191793386E+00, 9.7764766940E-01],
	[4.5000000000E+04, 4.1038739921E+01, 5.1914540285E+00, 2.2310329901E+01, 3.8195088310E+00, 9.7765668410E-01],
	[4.5005000000E+04, 4.1046802224E+01, 5.1914967135E+00, 2.2318418064E+01, 3.8198387592E+00, 9.7766569453E-01],
	[4.5010000000E+04, 4.1054865215E+01, 5.1915393941E+00, 2.2326508258E+01, 3.8201686079E+00, 9.7767470071E-01],
	[4.5015000000E+04, 4.1062928894E+01, 5.1915820704E+00, 2.2334600483E+01, 3.8204983771E+00, 9.7768370263E-01],
	[4.5020000000E+04, 4.1070993260E+01, 5.1916247422E+00, 2.2342694740E+01, 3.8208280668E+00, 9.7769270029E-01],
	[4.5025000000E+04, 4.1079058315E+01, 5.1916674097E+00, 2.2350791030E+01, 3.8211576770E+00, 9.7770169369E-01],
	[4.5030000000E+04, 4.1087124057E+01, 5.1917100727E+00, 2.2358889352E+01, 3.8214872078E+00, 9.7771068285E-01],
	[4.5035000000E+04, 4.1095190488E+01, 5.1917527314E+00, 2.2366989706E+01, 3.8218166592E+00, 9.7771966775E-01],
	[4.5040000000E+04, 4.1103257606E+01, 5.1917953857E+00, 2.2375092093E+01, 3.8221460312E+00, 9.7772864841E-01],
	[4.5045000000E+04, 4.1111325412E+01, 5.1918380356E+00, 2.2383196514E+01, 3.8224753238E+00, 9.7773762482E-01],
	[4.5050000000E+04, 4.1119393906E+01, 5.1918806812E+00, 2.2391302968E+01, 3.8228045370E+00, 9.7774659699E-01],
	[4.5055000000E+04, 4.1127463088E+01, 5.1919233223E+00, 2.2399411456E+01, 3.8231336709E+00, 9.7775556491E-01],
	[4.5060000000E+04, 4.1135532957E+01, 5.1919659591E+00, 2.2407521978E+01, 3.8234627255E+00, 9.7776452860E-01],
	[4.5065000000E+04, 4.1143603514E+01, 5.1920085915E+00, 2.2415634534E+01, 3.8237917008E+00, 9.7777348805E-01],
	[4.5070000000E+04, 4.1151674759E+01, 5.1920512195E+00, 2.2423749125E+01, 3.8241205968E+00, 9.7778244327E-01],
	[4.5075000000E+04, 4.1159746692E+01, 5.1920938431E+00, 2.2431865751E+01, 3.8244494135E+00, 9.7779139426E-01],
	[4.5080000000E+04, 4.1167819312E+01, 5.1921364623E+00, 2.2439984412E+01, 3.8247781510E+00, 9.7780034101E-01],
	[4.5085000000E+04, 4.1175892620E+01, 5.1921790772E+00, 2.2448105109E+01, 3.8251068093E+00, 9.7780928354E-01],
	[4.5090000000E+04, 4.1183966616E+01, 5.1922216877E+00, 2.2456227842E+01, 3.8254353883E+00, 9.7781822185E-01],
	[4.5095000000E+04, 4.1192041300E+01, 5.1922642938E+00, 2.2464352610E+01, 3.8257638882E+00, 9.7782715593E-01],
	[4.5100000000E+04, 4.1200116671E+01, 5.1923068956E+00, 2.2472479415E+01, 3.8260923089E+00, 9.7783608579E-01],
	[4.5105000000E+04, 4.1208192729E+01, 5.1923494929E+00, 2.2480608257E+01, 3.8264206504E+00, 9.7784501143E-01],
	[4.5110000000E+04, 4.1216269476E+01, 5.1923920859E+00, 2.2488739135E+01, 3.8267489129E+00, 9.7785393285E-01],
	[4.5115000000E+04, 4.1224346910E+01, 5.1924346746E+00, 2.2496872051E+01, 3.8270770962E+00, 9.7786285006E-01],
	[4.5120000000E+04, 4.1232425031E+01, 5.1924772588E+00, 2.2505007004E+01, 3.8274052004E+00, 9.7787176306E-01],
	[4.5125000000E+04, 4.1240503840E+01, 5.1925198387E+00, 2.2513143995E+01, 3.8277332255E+00, 9.7788067185E-01],
	[4.5130000000E+04, 4.1248583337E+01, 5.1925624142E+00, 2.2521283024E+01, 3.8280611716E+00, 9.7788957644E-01],
	[4.5135000000E+04, 4.1256663521E+01, 5.1926049854E+00, 2.2529424092E+01, 3.8283890387E+00, 9.7789847681E-01],
	[4.5140000000E+04, 4.1264744392E+01, 5.1926475522E+00, 2.2537567198E+01, 3.8287168267E+00, 9.7790737299E-01],
	[4.5145000000E+04, 4.1272825952E+01, 5.1926901146E+00, 2.2545712343E+01, 3.8290445358E+00, 9.7791626496E-01],
	[4.5150000000E+04, 4.1280908198E+01, 5.1927326726E+00, 2.2553859527E+01, 3.8293721659E+00, 9.7792515273E-01],
	[4.5155000000E+04, 4.1288991132E+01, 5.1927752263E+00, 2.2562008750E+01, 3.8296997170E+00, 9.7793403631E-01],
	[4.5160000000E+04, 4.1297074753E+01, 5.1928177756E+00, 2.2570160014E+01, 3.8300271892E+00, 9.7794291570E-01],
	[4.5165000000E+04, 4.1305159062E+01, 5.1928603206E+00, 2.2578313317E+01, 3.8303545825E+00, 9.7795179089E-01],
	[4.5170000000E+04, 4.1313244059E+01, 5.1929028612E+00, 2.2586468661E+01, 3.8306818969E+00, 9.7796066189E-01],
	[4.5175000000E+04, 4.1321329742E+01, 5.1929453975E+00, 2.2594626045E+01, 3.8310091324E+00, 9.7796952871E-01],
	[4.5180000000E+04, 4.1329416113E+01, 5.1929879293E+00, 2.2602785471E+01, 3.8313362890E+00, 9.7797839134E-01],
	[4.5185000000E+04, 4.1337503171E+01, 5.1930304569E+00, 2.2610946937E+01, 3.8316633668E+00, 9.7798724979E-01],
	[4.5190000000E+04, 4.1345590917E+01, 5.1930729800E+00, 2.2619110445E+01, 3.8319903658E+00, 9.7799610405E-01],
	[4.5195000000E+04, 4.1353679350E+01, 5.1931154988E+00, 2.2627275995E+01, 3.8323172860E+00, 9.7800495414E-01],
	[4.5200000000E+04, 4.1361768470E+01, 5.1931580133E+00, 2.2635443587E+01, 3.8326441274E+00, 9.7801380005E-01],
	[4.5205000000E+04, 4.1369858278E+01, 5.1932005234E+00, 2.2643613221E+01, 3.8329708900E+00, 9.7802264179E-01],
	[4.5210000000E+04, 4.1377948772E+01, 5.1932430291E+00, 2.2651784897E+01, 3.8332975739E+00, 9.7803147935E-01],
	[4.5215000000E+04, 4.1386039954E+01, 5.1932855305E+00, 2.2659958617E+01, 3.8336241791E+00, 9.7804031275E-01],
	[4.5220000000E+04, 4.1394131824E+01, 5.1933280276E+00, 2.2668134380E+01, 3.8339507056E+00, 9.7804914198E-01],
	[4.5225000000E+04, 4.1402224380E+01, 5.1933705203E+00, 2.2676312186E+01, 3.8342771533E+00, 9.7805796704E-01],
	[4.5230000000E+04, 4.1410317624E+01, 5.1934130086E+00, 2.2684492036E+01, 3.8346035225E+00, 9.7806678794E-01],
	[4.5235000000E+04, 4.1418411554E+01, 5.1934554926E+00, 2.2692673930E+01, 3.8349298129E+00, 9.7807560468E-01],
	[4.5240000000E+04, 4.1426506172E+01, 5.1934979723E+00, 2.2700857868E+01, 3.8352560248E+00, 9.7808441726E-01],
	[4.5245000000E+04, 4.1434601477E+01, 5.1935404476E+00, 2.2709043851E+01, 3.8355821580E+00, 9.7809322568E-01],
	[4.5250000000E+04, 4.1442697469E+01, 5.1935829185E+00, 2.2717231879E+01, 3.8359082127E+00, 9.7810202995E-01],
	[4.5255000000E+04, 4.1450794149E+01, 5.1936253851E+00, 2.2725421952E+01, 3.8362341887E+00, 9.7811083007E-01],
	[4.5260000000E+04, 4.1458891515E+01, 5.1936678474E+00, 2.2733614070E+01, 3.8365600863E+00, 9.7811962604E-01],
	[4.5265000000E+04, 4.1466989568E+01, 5.1937103053E+00, 2.2741808234E+01, 3.8368859053E+00, 9.7812841786E-01],
	[4.5270000000E+04, 4.1475088309E+01, 5.1937527589E+00, 2.2750004444E+01, 3.8372116458E+00, 9.7813720553E-01],
	[4.5275000000E+04, 4.1483187736E+01, 5.1937952081E+00, 2.2758202701E+01, 3.8375373077E+00, 9.7814598906E-01],
	[4.5280000000E+04, 4.1491287851E+01, 5.1938376530E+00, 2.2766403004E+01, 3.8378628913E+00, 9.7815476845E-01],
	[4.5285000000E+04, 4.1499388652E+01, 5.1938800935E+00, 2.2774605354E+01, 3.8381883963E+00, 9.7816354370E-01],
	[4.5290000000E+04, 4.1507490140E+01, 5.1939225298E+00, 2.2782809751E+01, 3.8385138230E+00, 9.7817231482E-01],
	[4.5295000000E+04, 4.1515592316E+01, 5.1939649616E+00, 2.2791016195E+01, 3.8388391712E+00, 9.7818108180E-01],
	[4.5300000000E+04, 4.1523695178E+01, 5.1940073892E+00, 2.2799224687E+01, 3.8391644410E+00, 9.7818984465E-01],
	[4.5305000000E+04, 4.1531808839E+01, 5.1940509757E+00, 2.2807435227E+01, 3.8394903546E+00, 9.7819860336E-01],
	[4.5310000000E+04, 4.1539928976E+01, 5.1940952234E+00, 2.2815647816E+01, 3.8398166031E+00, 9.7820735795E-01],
	[4.5315000000E+04, 4.1548049804E+01, 5.1941394666E+00, 2.2823862453E+01, 3.8401427735E+00, 9.7821610842E-01],
	[4.5320000000E+04, 4.1556171324E+01, 5.1941837053E+00, 2.2832079139E+01, 3.8404688657E+00, 9.7822485476E-01],
	[4.5325000000E+04, 4.1564293535E+01, 5.1942279395E+00, 2.2840297874E+01, 3.8407948798E+00, 9.7823359698E-01],
	[4.5330000000E+04, 4.1572416437E+01, 5.1942721692E+00, 2.2848518658E+01, 3.8411208159E+00, 9.7824233508E-01],
	[4.5335000000E+04, 4.1580540030E+01, 5.1943163944E+00, 2.2856741492E+01, 3.8414466738E+00, 9.7825106906E-01],
	[4.5340000000E+04, 4.1588664315E+01, 5.1943606150E+00, 2.2864966377E+01, 3.8417724538E+00, 9.7825979893E-01],
	[4.5345000000E+04, 4.1596789291E+01, 5.1944048312E+00, 2.2873193311E+01, 3.8420981556E+00, 9.7826852469E-01],
	[4.5350000000E+04, 4.1604914958E+01, 5.1944490429E+00, 2.2881422296E+01, 3.8424237795E+00, 9.7827724633E-01],
	[4.5355000000E+04, 4.1613041316E+01, 5.1944932501E+00, 2.2889653332E+01, 3.8427493254E+00, 9.7828596387E-01],
	[4.5360000000E+04, 4.1621168366E+01, 5.1945374528E+00, 2.2897886419E+01, 3.8430747933E+00, 9.7829467730E-01],
	[4.5365000000E+04, 4.1629296106E+01, 5.1945816510E+00, 2.2906121557E+01, 3.8434001832E+00, 9.7830338663E-01],
	[4.5370000000E+04, 4.1637424538E+01, 5.1946258447E+00, 2.2914358747E+01, 3.8437254952E+00, 9.7831209186E-01],
	[4.5375000000E+04, 4.1645553661E+01, 5.1946700339E+00, 2.2922597989E+01, 3.8440507293E+00, 9.7832079298E-01],
	[4.5380000000E+04, 4.1653683475E+01, 5.1947142186E+00, 2.2930839284E+01, 3.8443758855E+00, 9.7832949001E-01],
	[4.5385000000E+04, 4.1661813980E+01, 5.1947583988E+00, 2.2939082631E+01, 3.8447009638E+00, 9.7833818295E-01],
	[4.5390000000E+04, 4.1669945177E+01, 5.1948025745E+00, 2.2947328030E+01, 3.8450259643E+00, 9.7834687179E-01],
	[4.5395000000E+04, 4.1678077064E+01, 5.1948467458E+00, 2.2955575483E+01, 3.8453508869E+00, 9.7835555654E-01],
	[4.5400000000E+04, 4.1686209642E+01, 5.1948909125E+00, 2.2963824989E+01, 3.8456757317E+00, 9.7836423720E-01],
	[4.5405000000E+04, 4.1694342912E+01, 5.1949350748E+00, 2.2972076549E+01, 3.8460004987E+00, 9.7837291378E-01],
	[4.5410000000E+04, 4.1702476872E+01, 5.1949792325E+00, 2.2980330163E+01, 3.8463251879E+00, 9.7838158627E-01],
	[4.5415000000E+04, 4.1710611524E+01, 5.1950233858E+00, 2.2988585831E+01, 3.8466497993E+00, 9.7839025468E-01],
	[4.5420000000E+04, 4.1718746866E+01, 5.1950675346E+00, 2.2996843554E+01, 3.8469743330E+00, 9.7839891901E-01],
	[4.5425000000E+04, 4.1726882899E+01, 5.1951116789E+00, 2.3005103332E+01, 3.8472987889E+00, 9.7840757926E-01],
	[4.5430000000E+04, 4.1735019623E+01, 5.1951558188E+00, 2.3013365164E+01, 3.8476231672E+00, 9.7841623544E-01],
	[4.5435000000E+04, 4.1743157039E+01, 5.1951999541E+00, 2.3021629052E+01, 3.8479474678E+00, 9.7842488754E-01],
	[4.5440000000E+04, 4.1751295145E+01, 5.1952440850E+00, 2.3029894996E+01, 3.8482716906E+00, 9.7843353558E-01],
	[4.5445000000E+04, 4.1759433942E+01, 5.1952882114E+00, 2.3038162995E+01, 3.8485958359E+00, 9.7844217954E-01],
	[4.5450000000E+04, 4.1767573430E+01, 5.1953323333E+00, 2.3046433051E+01, 3.8489199035E+00, 9.7845081944E-01],
	[4.5455000000E+04, 4.1775713608E+01, 5.1953764507E+00, 2.3054705164E+01, 3.8492438935E+00, 9.7845945527E-01],
	[4.5460000000E+04, 4.1783854478E+01, 5.1954205636E+00, 2.3062979333E+01, 3.8495678059E+00, 9.7846808704E-01],
	[4.5465000000E+04, 4.1791996038E+01, 5.1954646721E+00, 2.3071255559E+01, 3.8498916407E+00, 9.7847671475E-01],
	[4.5470000000E+04, 4.1800138289E+01, 5.1955087761E+00, 2.3079533843E+01, 3.8502153980E+00, 9.7848533840E-01],
	[4.5475000000E+04, 4.1808281231E+01, 5.1955528756E+00, 2.3087814185E+01, 3.8505390778E+00, 9.7849395800E-01],
	[4.5480000000E+04, 4.1816424864E+01, 5.1955969707E+00, 2.3096096584E+01, 3.8508626800E+00, 9.7850257354E-01],
	[4.5485000000E+04, 4.1824569187E+01, 5.1956410612E+00, 2.3104381041E+01, 3.8511862047E+00, 9.7851118503E-01],
	[4.5490000000E+04, 4.1832714201E+01, 5.1956851473E+00, 2.3112667558E+01, 3.8515096520E+00, 9.7851979247E-01],
	[4.5495000000E+04, 4.1840859906E+01, 5.1957292290E+00, 2.3120956132E+01, 3.8518330218E+00, 9.7852839587E-01],
	[4.5500000000E+04, 4.1849006302E+01, 5.1957733061E+00, 2.3129246766E+01, 3.8521563141E+00, 9.7853699522E-01],
	[4.5505000000E+04, 4.1857153388E+01, 5.1958173788E+00, 2.3137539460E+01, 3.8524795291E+00, 9.7854559052E-01],
	[4.5510000000E+04, 4.1865301165E+01, 5.1958614470E+00, 2.3145834213E+01, 3.8528026666E+00, 9.7855418179E-01],
	[4.5515000000E+04, 4.1873449633E+01, 5.1959055108E+00, 2.3154131026E+01, 3.8531257267E+00, 9.7856276901E-01],
	[4.5520000000E+04, 4.1881598791E+01, 5.1959495701E+00, 2.3162429899E+01, 3.8534487095E+00, 9.7857135220E-01],
	[4.5525000000E+04, 4.1889748640E+01, 5.1959936249E+00, 2.3170730833E+01, 3.8537716149E+00, 9.7857993136E-01],
	[4.5530000000E+04, 4.1897899179E+01, 5.1960376752E+00, 2.3179033827E+01, 3.8540944431E+00, 9.7858850648E-01],
	[4.5535000000E+04, 4.1906050409E+01, 5.1960817211E+00, 2.3187338883E+01, 3.8544171939E+00, 9.7859707758E-01],
	[4.5540000000E+04, 4.1914202330E+01, 5.1961257625E+00, 2.3195646000E+01, 3.8547398674E+00, 9.7860564464E-01],
	[4.5545000000E+04, 4.1922354941E+01, 5.1961697995E+00, 2.3203955178E+01, 3.8550624636E+00, 9.7861420768E-01],
	[4.5550000000E+04, 4.1930508242E+01, 5.1962138320E+00, 2.3212266419E+01, 3.8553849826E+00, 9.7862276670E-01],
	[4.5555000000E+04, 4.1938662234E+01, 5.1962578601E+00, 2.3220579722E+01, 3.8557074244E+00, 9.7863132170E-01],
	[4.5560000000E+04, 4.1946816917E+01, 5.1963018836E+00, 2.3228895087E+01, 3.8560297890E+00, 9.7863987267E-01],
	[4.5565000000E+04, 4.1954972290E+01, 5.1963459028E+00, 2.3237212515E+01, 3.8563520763E+00, 9.7864841963E-01],
	[4.5570000000E+04, 4.1963128353E+01, 5.1963899174E+00, 2.3245532006E+01, 3.8566742865E+00, 9.7865696258E-01],
	[4.5575000000E+04, 4.1971285107E+01, 5.1964339277E+00, 2.3253853561E+01, 3.8569964196E+00, 9.7866550151E-01],
	[4.5580000000E+04, 4.1979442552E+01, 5.1964779334E+00, 2.3262177179E+01, 3.8573184755E+00, 9.7867403643E-01],
	[4.5585000000E+04, 4.1987600686E+01, 5.1965219347E+00, 2.3270502861E+01, 3.8576404543E+00, 9.7868256734E-01],
	[4.5590000000E+04, 4.1995759512E+01, 5.1965659316E+00, 2.3278830607E+01, 3.8579623560E+00, 9.7869109425E-01],
	[4.5595000000E+04, 4.2003919027E+01, 5.1966099240E+00, 2.3287160418E+01, 3.8582841806E+00, 9.7869961715E-01],
	[4.5600000000E+04, 4.2012079233E+01, 5.1966539119E+00, 2.3295492293E+01, 3.8586059281E+00, 9.7870813605E-01],
	[4.5605000000E+04, 4.2020240129E+01, 5.1966978954E+00, 2.3303826234E+01, 3.8589275987E+00, 9.7871665096E-01],
	[4.5610000000E+04, 4.2028401716E+01, 5.1967418745E+00, 2.3312162240E+01, 3.8592491922E+00, 9.7872516186E-01],
	[4.5615000000E+04, 4.2036563992E+01, 5.1967858491E+00, 2.3320500312E+01, 3.8595707087E+00, 9.7873366877E-01],
	[4.5620000000E+04, 4.2044726960E+01, 5.1968298192E+00, 2.3328840449E+01, 3.8598921482E+00, 9.7874217168E-01],
	[4.5625000000E+04, 4.2052890617E+01, 5.1968737849E+00, 2.3337182653E+01, 3.8602135107E+00, 9.7875067060E-01],
	[4.5630000000E+04, 4.2061054965E+01, 5.1969177462E+00, 2.3345526923E+01, 3.8605347963E+00, 9.7875916554E-01],
	[4.5635000000E+04, 4.2069220002E+01, 5.1969617030E+00, 2.3353873260E+01, 3.8608560050E+00, 9.7876765648E-01],
	[4.5640000000E+04, 4.2077385730E+01, 5.1970056553E+00, 2.3362221664E+01, 3.8611771368E+00, 9.7877614345E-01],
	[4.5645000000E+04, 4.2085552149E+01, 5.1970496033E+00, 2.3370572135E+01, 3.8614981917E+00, 9.7878462643E-01],
	[4.5650000000E+04, 4.2093719257E+01, 5.1970935467E+00, 2.3378924674E+01, 3.8618191697E+00, 9.7879310542E-01],
	[4.5655000000E+04, 4.2101887056E+01, 5.1971374858E+00, 2.3387279281E+01, 3.8621400709E+00, 9.7880158044E-01],
	[4.5660000000E+04, 4.2110055544E+01, 5.1971814204E+00, 2.3395635956E+01, 3.8624608952E+00, 9.7881005149E-01],
	[4.5665000000E+04, 4.2118224723E+01, 5.1972253505E+00, 2.3403994700E+01, 3.8627816428E+00, 9.7881851856E-01],
	[4.5670000000E+04, 4.2126394592E+01, 5.1972692763E+00, 2.3412355512E+01, 3.8631023135E+00, 9.7882698166E-01],
	[4.5675000000E+04, 4.2134565151E+01, 5.1973131975E+00, 2.3420718394E+01, 3.8634229075E+00, 9.7883544079E-01],
	[4.5680000000E+04, 4.2142736400E+01, 5.1973571144E+00, 2.3429083345E+01, 3.8637434247E+00, 9.7884389595E-01],
	[4.5685000000E+04, 4.2150908339E+01, 5.1974010268E+00, 2.3437450365E+01, 3.8640638652E+00, 9.7885234714E-01],
	[4.5690000000E+04, 4.2159080969E+01, 5.1974449348E+00, 2.3445819455E+01, 3.8643842290E+00, 9.7886079437E-01],
	[4.5695000000E+04, 4.2167254288E+01, 5.1974888383E+00, 2.3454190616E+01, 3.8647045160E+00, 9.7886923764E-01],
	[4.5700000000E+04, 4.2175428297E+01, 5.1975327374E+00, 2.3462563847E+01, 3.8650247264E+00, 9.7887767695E-01],
	[4.5705000000E+04, 4.2183602996E+01, 5.1975766321E+00, 2.3470939148E+01, 3.8653448602E+00, 9.7888611231E-01],
	[4.5710000000E+04, 4.2191778385E+01, 5.1976205224E+00, 2.3479316521E+01, 3.8656649173E+00, 9.7889454370E-01],
	[4.5715000000E+04, 4.2199954465E+01, 5.1976644082E+00, 2.3487695965E+01, 3.8659848977E+00, 9.7890297115E-01],
	[4.5720000000E+04, 4.2208131234E+01, 5.1977082896E+00, 2.3496077481E+01, 3.8663048016E+00, 9.7891139465E-01],
	[4.5725000000E+04, 4.2216308693E+01, 5.1977521665E+00, 2.3504461068E+01, 3.8666246289E+00, 9.7891981419E-01],
	[4.5730000000E+04, 4.2224486841E+01, 5.1977960391E+00, 2.3512846728E+01, 3.8669443796E+00, 9.7892822979E-01],
	[4.5735000000E+04, 4.2232665680E+01, 5.1978399072E+00, 2.3521234460E+01, 3.8672640538E+00, 9.7893664145E-01],
	[4.5740000000E+04, 4.2240845209E+01, 5.1978837708E+00, 2.3529624265E+01, 3.8675836515E+00, 9.7894504916E-01],
	[4.5745000000E+04, 4.2249025427E+01, 5.1979276301E+00, 2.3538016143E+01, 3.8679031726E+00, 9.7895345294E-01],
	[4.5750000000E+04, 4.2257206336E+01, 5.1979714849E+00, 2.3546410094E+01, 3.8682226173E+00, 9.7896185277E-01],
	[4.5755000000E+04, 4.2265387934E+01, 5.1980153353E+00, 2.3554806119E+01, 3.8685419855E+00, 9.7897024867E-01],
	[4.5760000000E+04, 4.2273570222E+01, 5.1980591813E+00, 2.3563204218E+01, 3.8688612773E+00, 9.7897864064E-01],
	[4.5765000000E+04, 4.2281753199E+01, 5.1981030229E+00, 2.3571604391E+01, 3.8691804926E+00, 9.7898702867E-01],
	[4.5770000000E+04, 4.2289936867E+01, 5.1981468600E+00, 2.3580006639E+01, 3.8694996315E+00, 9.7899541278E-01],
	[4.5775000000E+04, 4.2298121224E+01, 5.1981906928E+00, 2.3588410961E+01, 3.8698186940E+00, 9.7900379295E-01],
	[4.5780000000E+04, 4.2306306271E+01, 5.1982345211E+00, 2.3596817358E+01, 3.8701376802E+00, 9.7901216921E-01],
	[4.5785000000E+04, 4.2314492008E+01, 5.1982783450E+00, 2.3605225831E+01, 3.8704565900E+00, 9.7902054153E-01],
	[4.5790000000E+04, 4.2322678434E+01, 5.1983221644E+00, 2.3613636379E+01, 3.8707754234E+00, 9.7902890994E-01],
	[4.5795000000E+04, 4.2330865550E+01, 5.1983659795E+00, 2.3622049003E+01, 3.8710941806E+00, 9.7903727443E-01],
	[4.5800000000E+04, 4.2339053356E+01, 5.1984097902E+00, 2.3630463703E+01, 3.8714128614E+00, 9.7904563500E-01],
	[4.5805000000E+04, 4.2347241851E+01, 5.1984535964E+00, 2.3638880480E+01, 3.8717314660E+00, 9.7905399166E-01],
	[4.5810000000E+04, 4.2355431036E+01, 5.1984973982E+00, 2.3647299333E+01, 3.8720499943E+00, 9.7906234441E-01],
	[4.5815000000E+04, 4.2363620911E+01, 5.1985411956E+00, 2.3655720263E+01, 3.8723684464E+00, 9.7907069324E-01],
	[4.5820000000E+04, 4.2371811475E+01, 5.1985849886E+00, 2.3664143271E+01, 3.8726868222E+00, 9.7907903817E-01],
	[4.5825000000E+04, 4.2380002729E+01, 5.1986287772E+00, 2.3672568357E+01, 3.8730051219E+00, 9.7908737919E-01],
	[4.5830000000E+04, 4.2388194672E+01, 5.1986725614E+00, 2.3680995520E+01, 3.8733233453E+00, 9.7909571630E-01],
	[4.5835000000E+04, 4.2396387305E+01, 5.1987163412E+00, 2.3689424761E+01, 3.8736414926E+00, 9.7910404952E-01],
	[4.5840000000E+04, 4.2404580627E+01, 5.1987601165E+00, 2.3697856081E+01, 3.8739595638E+00, 9.7911237883E-01],
	[4.5845000000E+04, 4.2412774639E+01, 5.1988038875E+00, 2.3706289479E+01, 3.8742775588E+00, 9.7912070425E-01],
	[4.5850000000E+04, 4.2420969340E+01, 5.1988476540E+00, 2.3714724957E+01, 3.8745954778E+00, 9.7912902577E-01],
	[4.5855000000E+04, 4.2429164731E+01, 5.1988914162E+00, 2.3723162514E+01, 3.8749133206E+00, 9.7913734339E-01],
	[4.5860000000E+04, 4.2437360811E+01, 5.1989351739E+00, 2.3731602150E+01, 3.8752310874E+00, 9.7914565713E-01],
	[4.5865000000E+04, 4.2445557581E+01, 5.1989789273E+00, 2.3740043867E+01, 3.8755487781E+00, 9.7915396697E-01],
	[4.5870000000E+04, 4.2453755040E+01, 5.1990226762E+00, 2.3748487663E+01, 3.8758663928E+00, 9.7916227293E-01],
	[4.5875000000E+04, 4.2461953189E+01, 5.1990664208E+00, 2.3756933540E+01, 3.8761839315E+00, 9.7917057501E-01],
	[4.5880000000E+04, 4.2470152027E+01, 5.1991101609E+00, 2.3765381498E+01, 3.8765013941E+00, 9.7917887320E-01],
	[4.5885000000E+04, 4.2478351554E+01, 5.1991538967E+00, 2.3773831537E+01, 3.8768187809E+00, 9.7918716750E-01],
	[4.5890000000E+04, 4.2486551771E+01, 5.1991976280E+00, 2.3782283657E+01, 3.8771360916E+00, 9.7919545793E-01],
	[4.5895000000E+04, 4.2494752676E+01, 5.1992413550E+00, 2.3790737858E+01, 3.8774533264E+00, 9.7920374449E-01],
	[4.5900000000E+04, 4.2502954272E+01, 5.1992850775E+00, 2.3799194142E+01, 3.8777704853E+00, 9.7921202717E-01],
	[4.5905000000E+04, 4.2511156556E+01, 5.1993287957E+00, 2.3807652507E+01, 3.8780875683E+00, 9.7922030597E-01],
	[4.5910000000E+04, 4.2519359530E+01, 5.1993725094E+00, 2.3816112955E+01, 3.8784045755E+00, 9.7922858091E-01],
	[4.5915000000E+04, 4.2527563193E+01, 5.1994162188E+00, 2.3824575486E+01, 3.8787215067E+00, 9.7923685197E-01],
	[4.5920000000E+04, 4.2535767546E+01, 5.1994599238E+00, 2.3833040100E+01, 3.8790383622E+00, 9.7924511917E-01],
	[4.5925000000E+04, 4.2543972587E+01, 5.1995036244E+00, 2.3841506797E+01, 3.8793551418E+00, 9.7925338251E-01],
	[4.5930000000E+04, 4.2552178318E+01, 5.1995473206E+00, 2.3849975577E+01, 3.8796718456E+00, 9.7926164198E-01],
	[4.5935000000E+04, 4.2560384738E+01, 5.1995910124E+00, 2.3858446442E+01, 3.8799884736E+00, 9.7926989760E-01],
	[4.5940000000E+04, 4.2568591847E+01, 5.1996346998E+00, 2.3866919391E+01, 3.8803050258E+00, 9.7927814935E-01],
	[4.5945000000E+04, 4.2576799646E+01, 5.1996783828E+00, 2.3875394424E+01, 3.8806215024E+00, 9.7928639725E-01],
	[4.5950000000E+04, 4.2585008133E+01, 5.1997220615E+00, 2.3883871541E+01, 3.8809379031E+00, 9.7929464130E-01],
	[4.5955000000E+04, 4.2593217310E+01, 5.1997657358E+00, 2.3892350744E+01, 3.8812542282E+00, 9.7930288149E-01],
	[4.5960000000E+04, 4.2601427175E+01, 5.1998094056E+00, 2.3900832032E+01, 3.8815704776E+00, 9.7931111784E-01],
	[4.5965000000E+04, 4.2609637730E+01, 5.1998530711E+00, 2.3909315406E+01, 3.8818866513E+00, 9.7931935034E-01],
	[4.5970000000E+04, 4.2617848974E+01, 5.1998967322E+00, 2.3917800866E+01, 3.8822027494E+00, 9.7932757899E-01],
	[4.5975000000E+04, 4.2626060907E+01, 5.1999403890E+00, 2.3926288411E+01, 3.8825187718E+00, 9.7933580380E-01],
	[4.5980000000E+04, 4.2634273529E+01, 5.1999840413E+00, 2.3934778043E+01, 3.8828347186E+00, 9.7934402476E-01],
	[4.5985000000E+04, 4.2642486840E+01, 5.2000276893E+00, 2.3943269762E+01, 3.8831505898E+00, 9.7935224189E-01],
	[4.5990000000E+04, 4.2650700840E+01, 5.2000713329E+00, 2.3951763568E+01, 3.8834663855E+00, 9.7936045518E-01],
	[4.5995000000E+04, 4.2658915529E+01, 5.2001149721E+00, 2.3960259461E+01, 3.8837821056E+00, 9.7936866464E-01],
	[4.6000000000E+04, 4.2667130907E+01, 5.2001586069E+00, 2.3968757442E+01, 3.8840977501E+00, 9.7937687026E-01],
	[4.6005000000E+04, 4.2675346974E+01, 5.2002022374E+00, 2.3977257511E+01, 3.8844133192E+00, 9.7938507205E-01],
	[4.6010000000E+04, 4.2683563730E+01, 5.2002458634E+00, 2.3985759667E+01, 3.8847288127E+00, 9.7939327001E-01],
	[4.6015000000E+04, 4.2691781175E+01, 5.2002894851E+00, 2.3994263912E+01, 3.8850442308E+00, 9.7940146415E-01],
	[4.6020000000E+04, 4.2699999308E+01, 5.2003331025E+00, 2.4002770246E+01, 3.8853595733E+00, 9.7940965446E-01],
	[4.6025000000E+04, 4.2708218131E+01, 5.2003767154E+00, 2.4011278669E+01, 3.8856748405E+00, 9.7941784094E-01],
	[4.6030000000E+04, 4.2716437643E+01, 5.2004203240E+00, 2.4019789181E+01, 3.8859900322E+00, 9.7942602361E-01],
	[4.6035000000E+04, 4.2724670175E+01, 5.2004653184E+00, 2.4028301783E+01, 3.8863060269E+00, 9.7943420246E-01],
	[4.6040000000E+04, 4.2732906949E+01, 5.2005107083E+00, 2.4036816474E+01, 3.8866221992E+00, 9.7944237749E-01],
	[4.6045000000E+04, 4.2741144417E+01, 5.2005560936E+00, 2.4045333256E+01, 3.8869382962E+00, 9.7945054871E-01],
	[4.6050000000E+04, 4.2749382577E+01, 5.2006014744E+00, 2.4053852128E+01, 3.8872543181E+00, 9.7945871612E-01],
	[4.6055000000E+04, 4.2757621431E+01, 5.2006468507E+00, 2.4062373091E+01, 3.8875702648E+00, 9.7946687971E-01],
	[4.6060000000E+04, 4.2765860978E+01, 5.2006922225E+00, 2.4070896145E+01, 3.8878861364E+00, 9.7947503950E-01],
	[4.6065000000E+04, 4.2774101218E+01, 5.2007375897E+00, 2.4079421290E+01, 3.8882019328E+00, 9.7948319548E-01],
	[4.6070000000E+04, 4.2782342151E+01, 5.2007829524E+00, 2.4087948527E+01, 3.8885176542E+00, 9.7949134765E-01],
	[4.6075000000E+04, 4.2790583777E+01, 5.2008283106E+00, 2.4096477855E+01, 3.8888333005E+00, 9.7949949603E-01],
	[4.6080000000E+04, 4.2798826097E+01, 5.2008736642E+00, 2.4105009276E+01, 3.8891488718E+00, 9.7950764060E-01],
	[4.6085000000E+04, 4.2807069109E+01, 5.2009190133E+00, 2.4113542789E+01, 3.8894643680E+00, 9.7951578137E-01],
	[4.6090000000E+04, 4.2815312815E+01, 5.2009643579E+00, 2.4122078395E+01, 3.8897797891E+00, 9.7952391834E-01],
	[4.6095000000E+04, 4.2823557213E+01, 5.2010096980E+00, 2.4130616093E+01, 3.8900951353E+00, 9.7953205152E-01],
	[4.6100000000E+04, 4.2831802305E+01, 5.2010550335E+00, 2.4139155885E+01, 3.8904104065E+00, 9.7954018090E-01],
	[4.6105000000E+04, 4.2840048090E+01, 5.2011003646E+00, 2.4147697771E+01, 3.8907256027E+00, 9.7954830649E-01],
	[4.6110000000E+04, 4.2848294567E+01, 5.2011456911E+00, 2.4156241751E+01, 3.8910407240E+00, 9.7955642829E-01],
	[4.6115000000E+04, 4.2856541738E+01, 5.2011910131E+00, 2.4164787824E+01, 3.8913557704E+00, 9.7956454630E-01],
	[4.6120000000E+04, 4.2864789601E+01, 5.2012363305E+00, 2.4173335992E+01, 3.8916707418E+00, 9.7957266053E-01],
	[4.6125000000E+04, 4.2873038158E+01, 5.2012816435E+00, 2.4181886255E+01, 3.8919856384E+00, 9.7958077097E-01],
	[4.6130000000E+04, 4.2881287407E+01, 5.2013269519E+00, 2.4190438613E+01, 3.8923004600E+00, 9.7958887763E-01],
	[4.6135000000E+04, 4.2889537349E+01, 5.2013722558E+00, 2.4198993066E+01, 3.8926152069E+00, 9.7959698050E-01],
	[4.6140000000E+04, 4.2897787985E+01, 5.2014175552E+00, 2.4207549614E+01, 3.8929298789E+00, 9.7960507960E-01],
	[4.6145000000E+04, 4.2906039313E+01, 5.2014628501E+00, 2.4216108259E+01, 3.8932444761E+00, 9.7961317492E-01],
	[4.6150000000E+04, 4.2914291334E+01, 5.2015081405E+00, 2.4224668999E+01, 3.8935589984E+00, 9.7962126647E-01],
	[4.6155000000E+04, 4.2922544047E+01, 5.2015534264E+00, 2.4233231836E+01, 3.8938734461E+00, 9.7962935424E-01],
	[4.6160000000E+04, 4.2930797454E+01, 5.2015987077E+00, 2.4241796770E+01, 3.8941878189E+00, 9.7963743824E-01],
	[4.6165000000E+04, 4.2939051553E+01, 5.2016439845E+00, 2.4250363800E+01, 3.8945021170E+00, 9.7964551847E-01],
	[4.6170000000E+04, 4.2947306345E+01, 5.2016892569E+00, 2.4258932928E+01, 3.8948163404E+00, 9.7965359493E-01],
	[4.6175000000E+04, 4.2955561830E+01, 5.2017345247E+00, 2.4267504154E+01, 3.8951304891E+00, 9.7966166763E-01],
	[4.6180000000E+04, 4.2963818008E+01, 5.2017797880E+00, 2.4276077477E+01, 3.8954445631E+00, 9.7966973656E-01],
	[4.6185000000E+04, 4.2972074879E+01, 5.2018250468E+00, 2.4284652898E+01, 3.8957585625E+00, 9.7967780173E-01],
	[4.6190000000E+04, 4.2980332442E+01, 5.2018703011E+00, 2.4293230418E+01, 3.8960724872E+00, 9.7968586314E-01],
	[4.6195000000E+04, 4.2988590698E+01, 5.2019155509E+00, 2.4301810037E+01, 3.8963863372E+00, 9.7969392079E-01],
	[4.6200000000E+04, 4.2996849646E+01, 5.2019607962E+00, 2.4310391754E+01, 3.8967001127E+00, 9.7970197468E-01],
	[4.6205000000E+04, 4.3005109287E+01, 5.2020060370E+00, 2.4318975571E+01, 3.8970138136E+00, 9.7971002482E-01],
	[4.6210000000E+04, 4.3013369621E+01, 5.2020512733E+00, 2.4327561488E+01, 3.8973274399E+00, 9.7971807121E-01],
	[4.6215000000E+04, 4.3021630648E+01, 5.2020965051E+00, 2.4336149504E+01, 3.8976409916E+00, 9.7972611384E-01],
	[4.6220000000E+04, 4.3029892367E+01, 5.2021417324E+00, 2.4344739620E+01, 3.8979544689E+00, 9.7973415273E-01],
	[4.6225000000E+04, 4.3038154779E+01, 5.2021869551E+00, 2.4353331837E+01, 3.8982678716E+00, 9.7974218787E-01],
	[4.6230000000E+04, 4.3046417883E+01, 5.2022321734E+00, 2.4361926154E+01, 3.8985811998E+00, 9.7975021926E-01],
	[4.6235000000E+04, 4.3054681680E+01, 5.2022773872E+00, 2.4370522573E+01, 3.8988944535E+00, 9.7975824691E-01],
	[4.6240000000E+04, 4.3062946169E+01, 5.2023225965E+00, 2.4379121093E+01, 3.8992076328E+00, 9.7976627082E-01],
	[4.6245000000E+04, 4.3071211351E+01, 5.2023678013E+00, 2.4387721714E+01, 3.8995207376E+00, 9.7977429098E-01],
	[4.6250000000E+04, 4.3079477226E+01, 5.2024130016E+00, 2.4396324437E+01, 3.8998337680E+00, 9.7978230741E-01],
	[4.6255000000E+04, 4.3087743793E+01, 5.2024581974E+00, 2.4404929262E+01, 3.9001467241E+00, 9.7979032011E-01],
	[4.6260000000E+04, 4.3096011052E+01, 5.2025033888E+00, 2.4413536190E+01, 3.9004596057E+00, 9.7979832906E-01],
	[4.6265000000E+04, 4.3104279004E+01, 5.2025485756E+00, 2.4422145220E+01, 3.9007724130E+00, 9.7980633429E-01],
	[4.6270000000E+04, 4.3112547648E+01, 5.2025937579E+00, 2.4430756354E+01, 3.9010851459E+00, 9.7981433578E-01],
	[4.6275000000E+04, 4.3120816985E+01, 5.2026389358E+00, 2.4439369590E+01, 3.9013978045E+00, 9.7982233355E-01],
	[4.6280000000E+04, 4.3129087015E+01, 5.2026841091E+00, 2.4447984930E+01, 3.9017103888E+00, 9.7983032759E-01],
	[4.6285000000E+04, 4.3137357736E+01, 5.2027292780E+00, 2.4456602374E+01, 3.9020228988E+00, 9.7983831790E-01],
	[4.6290000000E+04, 4.3145629150E+01, 5.2027744424E+00, 2.4465221922E+01, 3.9023353345E+00, 9.7984630449E-01],
	[4.6295000000E+04, 4.3153901257E+01, 5.2028196023E+00, 2.4473843575E+01, 3.9026476960E+00, 9.7985428736E-01],
	[4.6300000000E+04, 4.3162174055E+01, 5.2028647577E+00, 2.4482467332E+01, 3.9029599832E+00, 9.7986226651E-01],
	[4.6305000000E+04, 4.3170447547E+01, 5.2029099086E+00, 2.4491093195E+01, 3.9032721962E+00, 9.7987024194E-01],
	[4.6310000000E+04, 4.3178721730E+01, 5.2029550551E+00, 2.4499721162E+01, 3.9035843351E+00, 9.7987821366E-01],
	[4.6315000000E+04, 4.3186996606E+01, 5.2030001970E+00, 2.4508351235E+01, 3.9038963997E+00, 9.7988618166E-01],
	[4.6320000000E+04, 4.3195272174E+01, 5.2030453345E+00, 2.4516983414E+01, 3.9042083902E+00, 9.7989414595E-01],
	[4.6325000000E+04, 4.3203548434E+01, 5.2030904675E+00, 2.4525617699E+01, 3.9045203066E+00, 9.7990210653E-01],
	[4.6330000000E+04, 4.3211825386E+01, 5.2031355960E+00, 2.4534254090E+01, 3.9048321488E+00, 9.7991006340E-01],
	[4.6335000000E+04, 4.3220103031E+01, 5.2031807201E+00, 2.4542892589E+01, 3.9051439169E+00, 9.7991801656E-01],
	[4.6340000000E+04, 4.3228381368E+01, 5.2032258396E+00, 2.4551533194E+01, 3.9054556110E+00, 9.7992596602E-01],
	[4.6345000000E+04, 4.3236660397E+01, 5.2032709547E+00, 2.4560175906E+01, 3.9057672310E+00, 9.7993391177E-01],
	[4.6350000000E+04, 4.3244940119E+01, 5.2033160653E+00, 2.4568820726E+01, 3.9060787769E+00, 9.7994185383E-01],
	[4.6355000000E+04, 4.3253220532E+01, 5.2033611715E+00, 2.4577467654E+01, 3.9063902488E+00, 9.7994979218E-01],
	[4.6360000000E+04, 4.3261501638E+01, 5.2034062731E+00, 2.4586116690E+01, 3.9067016467E+00, 9.7995772684E-01],
	[4.6365000000E+04, 4.3269783436E+01, 5.2034513703E+00, 2.4594767834E+01, 3.9070129706E+00, 9.7996565780E-01],
	[4.6370000000E+04, 4.3278065925E+01, 5.2034964630E+00, 2.4603421087E+01, 3.9073242206E+00, 9.7997358507E-01],
	[4.6375000000E+04, 4.3286349107E+01, 5.2035415513E+00, 2.4612076449E+01, 3.9076353965E+00, 9.7998150865E-01],
	[4.6380000000E+04, 4.3294632981E+01, 5.2035866350E+00, 2.4620733920E+01, 3.9079464986E+00, 9.7998942853E-01],
	[4.6385000000E+04, 4.3302917548E+01, 5.2036317144E+00, 2.4629393501E+01, 3.9082575267E+00, 9.7999734473E-01],
	[4.6390000000E+04, 4.3311202806E+01, 5.2036767892E+00, 2.4638055192E+01, 3.9085684810E+00, 9.8000525724E-01],
	[4.6395000000E+04, 4.3319488756E+01, 5.2037218596E+00, 2.4646718993E+01, 3.9088793613E+00, 9.8001316607E-01],
	[4.6400000000E+04, 4.3327775398E+01, 5.2037669255E+00, 2.4655384904E+01, 3.9091901678E+00, 9.8002107121E-01],
	[4.6405000000E+04, 4.3336062732E+01, 5.2038119869E+00, 2.4664052926E+01, 3.9095009005E+00, 9.8002897268E-01],
	[4.6410000000E+04, 4.3344350759E+01, 5.2038570439E+00, 2.4672723059E+01, 3.9098115593E+00, 9.8003687046E-01],
	[4.6415000000E+04, 4.3352639477E+01, 5.2039020964E+00, 2.4681395303E+01, 3.9101221444E+00, 9.8004476457E-01],
	[4.6420000000E+04, 4.3360928887E+01, 5.2039471444E+00, 2.4690069659E+01, 3.9104326556E+00, 9.8005265500E-01],
	[4.6425000000E+04, 4.3369218989E+01, 5.2039921880E+00, 2.4698746126E+01, 3.9107430931E+00, 9.8006054176E-01],
	[4.6430000000E+04, 4.3377509783E+01, 5.2040372271E+00, 2.4707424706E+01, 3.9110534569E+00, 9.8006842485E-01],
	[4.6435000000E+04, 4.3385801269E+01, 5.2040822618E+00, 2.4716105398E+01, 3.9113637469E+00, 9.8007630426E-01],
	[4.6440000000E+04, 4.3394093447E+01, 5.2041272920E+00, 2.4724788203E+01, 3.9116739632E+00, 9.8008418001E-01],
	[4.6445000000E+04, 4.3402386316E+01, 5.2041723177E+00, 2.4733473121E+01, 3.9119841058E+00, 9.8009205210E-01],
	[4.6450000000E+04, 4.3410679878E+01, 5.2042173390E+00, 2.4742160152E+01, 3.9122941747E+00, 9.8009992051E-01],
	[4.6455000000E+04, 4.3418974131E+01, 5.2042623558E+00, 2.4750849297E+01, 3.9126041700E+00, 9.8010778527E-01],
	[4.6460000000E+04, 4.3427269076E+01, 5.2043073682E+00, 2.4759540555E+01, 3.9129140917E+00, 9.8011564637E-01],
	[4.6465000000E+04, 4.3435564713E+01, 5.2043523761E+00, 2.4768233928E+01, 3.9132239397E+00, 9.8012350380E-01],
	[4.6470000000E+04, 4.3443861042E+01, 5.2043973796E+00, 2.4776929415E+01, 3.9135337141E+00, 9.8013135758E-01],
	[4.6475000000E+04, 4.3452158062E+01, 5.2044423786E+00, 2.4785627016E+01, 3.9138434150E+00, 9.8013920771E-01],
	[4.6480000000E+04, 4.3460455774E+01, 5.2044873732E+00, 2.4794326733E+01, 3.9141530423E+00, 9.8014705418E-01],
	[4.6485000000E+04, 4.3468754178E+01, 5.2045323633E+00, 2.4803028565E+01, 3.9144625960E+00, 9.8015489700E-01],
	[4.6490000000E+04, 4.3477053274E+01, 5.2045773489E+00, 2.4811732513E+01, 3.9147720763E+00, 9.8016273617E-01],
	[4.6495000000E+04, 4.3485353061E+01, 5.2046223302E+00, 2.4820438576E+01, 3.9150814830E+00, 9.8017057169E-01],
	[4.6500000000E+04, 4.3493653540E+01, 5.2046673069E+00, 2.4829146756E+01, 3.9153908162E+00, 9.8017840357E-01],
	[4.6505000000E+04, 4.3501954711E+01, 5.2047122792E+00, 2.4837857052E+01, 3.9157000760E+00, 9.8018623180E-01],
	[4.6510000000E+04, 4.3510256573E+01, 5.2047572471E+00, 2.4846569464E+01, 3.9160092623E+00, 9.8019405639E-01],
	[4.6515000000E+04, 4.3518559127E+01, 5.2048022105E+00, 2.4855283994E+01, 3.9163183752E+00, 9.8020187734E-01],
	[4.6520000000E+04, 4.3526862373E+01, 5.2048471695E+00, 2.4864000641E+01, 3.9166274147E+00, 9.8020969465E-01],
	[4.6525000000E+04, 4.3535166310E+01, 5.2048921240E+00, 2.4872719405E+01, 3.9169363808E+00, 9.8021750833E-01],
	[4.6530000000E+04, 4.3543470938E+01, 5.2049370741E+00, 2.4881440288E+01, 3.9172452735E+00, 9.8022531836E-01],
	[4.6535000000E+04, 4.3551776259E+01, 5.2049820198E+00, 2.4890163288E+01, 3.9175540928E+00, 9.8023312477E-01],
	[4.6540000000E+04, 4.3560082271E+01, 5.2050269610E+00, 2.4898888407E+01, 3.9178628388E+00, 9.8024092755E-01],
	[4.6545000000E+04, 4.3568388974E+01, 5.2050718978E+00, 2.4907615645E+01, 3.9181715115E+00, 9.8024872669E-01],
	[4.6550000000E+04, 4.3576696369E+01, 5.2051168301E+00, 2.4916345001E+01, 3.9184801109E+00, 9.8025652221E-01],
	[4.6555000000E+04, 4.3585004455E+01, 5.2051617580E+00, 2.4925076477E+01, 3.9187886371E+00, 9.8026431410E-01],
	[4.6560000000E+04, 4.3593313233E+01, 5.2052066814E+00, 2.4933810073E+01, 3.9190970899E+00, 9.8027210237E-01],
	[4.6565000000E+04, 4.3601622702E+01, 5.2052516005E+00, 2.4942545788E+01, 3.9194054695E+00, 9.8027988701E-01],
	[4.6570000000E+04, 4.3609932863E+01, 5.2052965150E+00, 2.4951283623E+01, 3.9197137759E+00, 9.8028766804E-01],
	[4.6575000000E+04, 4.3618243715E+01, 5.2053414252E+00, 2.4960023579E+01, 3.9200220091E+00, 9.8029544545E-01],
	[4.6580000000E+04, 4.3626555259E+01, 5.2053863309E+00, 2.4968765656E+01, 3.9203301691E+00, 9.8030321924E-01],
	[4.6585000000E+04, 4.3634867494E+01, 5.2054312322E+00, 2.4977509853E+01, 3.9206382559E+00, 9.8031098941E-01],
	[4.6590000000E+04, 4.3643180420E+01, 5.2054761290E+00, 2.4986256172E+01, 3.9209462696E+00, 9.8031875597E-01],
	[4.6595000000E+04, 4.3651494038E+01, 5.2055210215E+00, 2.4995004612E+01, 3.9212542101E+00, 9.8032651893E-01],
	[4.6600000000E+04, 4.3659808347E+01, 5.2055659094E+00, 2.5003755175E+01, 3.9215620775E+00, 9.8033427827E-01],
	[4.6605000000E+04, 4.3668123347E+01, 5.2056107930E+00, 2.5012507859E+01, 3.9218698719E+00, 9.8034203400E-01],
	[4.6610000000E+04, 4.3676439039E+01, 5.2056556721E+00, 2.5021262666E+01, 3.9221775931E+00, 9.8034978613E-01],
	[4.6615000000E+04, 4.3684755422E+01, 5.2057005468E+00, 2.5030019595E+01, 3.9224852413E+00, 9.8035753465E-01],
	[4.6620000000E+04, 4.3693072496E+01, 5.2057454171E+00, 2.5038778648E+01, 3.9227928165E+00, 9.8036527958E-01],
	[4.6625000000E+04, 4.3701390262E+01, 5.2057902830E+00, 2.5047539824E+01, 3.9231003186E+00, 9.8037302090E-01],
	[4.6630000000E+04, 4.3709708719E+01, 5.2058351444E+00, 2.5056303123E+01, 3.9234077477E+00, 9.8038075862E-01],
	[4.6635000000E+04, 4.3718027867E+01, 5.2058800014E+00, 2.5065068546E+01, 3.9237151039E+00, 9.8038849275E-01],
	[4.6640000000E+04, 4.3726347706E+01, 5.2059248540E+00, 2.5073836094E+01, 3.9240223871E+00, 9.8039622328E-01],
	[4.6645000000E+04, 4.3734668236E+01, 5.2059697021E+00, 2.5082605765E+01, 3.9243295973E+00, 9.8040395022E-01],
	[4.6650000000E+04, 4.3742989458E+01, 5.2060145459E+00, 2.5091377562E+01, 3.9246367346E+00, 9.8041167357E-01],
	[4.6655000000E+04, 4.3751311371E+01, 5.2060593852E+00, 2.5100151483E+01, 3.9249437990E+00, 9.8041939333E-01],
	[4.6660000000E+04, 4.3759633975E+01, 5.2061042201E+00, 2.5108927530E+01, 3.9252507905E+00, 9.8042710950E-01],
	[4.6665000000E+04, 4.3767957270E+01, 5.2061490506E+00, 2.5117705703E+01, 3.9255577092E+00, 9.8043482208E-01],
	[4.6670000000E+04, 4.3776281256E+01, 5.2061938767E+00, 2.5126486001E+01, 3.9258645550E+00, 9.8044253108E-01],
	[4.6675000000E+04, 4.3784605933E+01, 5.2062386983E+00, 2.5135268425E+01, 3.9261713279E+00, 9.8045023650E-01],
	[4.6680000000E+04, 4.3792931301E+01, 5.2062835155E+00, 2.5144052976E+01, 3.9264780280E+00, 9.8045793834E-01],
	[4.6685000000E+04, 4.3801257361E+01, 5.2063283284E+00, 2.5152839654E+01, 3.9267846554E+00, 9.8046563660E-01],
	[4.6690000000E+04, 4.3809584111E+01, 5.2063731368E+00, 2.5161628458E+01, 3.9270912099E+00, 9.8047333129E-01],
	[4.6695000000E+04, 4.3817911552E+01, 5.2064179408E+00, 2.5170419390E+01, 3.9273976917E+00, 9.8048102240E-01],
	[4.6700000000E+04, 4.3826239685E+01, 5.2064627403E+00, 2.5179212449E+01, 3.9277041008E+00, 9.8048870993E-01],
	[4.6705000000E+04, 4.3834568508E+01, 5.2065075355E+00, 2.5188007637E+01, 3.9280104371E+00, 9.8049639390E-01],
	[4.6710000000E+04, 4.3842898023E+01, 5.2065523263E+00, 2.5196804952E+01, 3.9283167007E+00, 9.8050407429E-01],
	[4.6715000000E+04, 4.3851228228E+01, 5.2065971126E+00, 2.5205604396E+01, 3.9286228916E+00, 9.8051175112E-01],
	[4.6720000000E+04, 4.3859559124E+01, 5.2066418946E+00, 2.5214405968E+01, 3.9289290099E+00, 9.8051942438E-01],
	[4.6725000000E+04, 4.3867890712E+01, 5.2066866721E+00, 2.5223209670E+01, 3.9292350555E+00, 9.8052709408E-01],
	[4.6730000000E+04, 4.3876222990E+01, 5.2067314452E+00, 2.5232015501E+01, 3.9295410285E+00, 9.8053476022E-01],
	[4.6735000000E+04, 4.3884555959E+01, 5.2067762140E+00, 2.5240823461E+01, 3.9298469289E+00, 9.8054242279E-01],
	[4.6740000000E+04, 4.3892889619E+01, 5.2068209783E+00, 2.5249633552E+01, 3.9301527567E+00, 9.8055008181E-01],
	[4.6745000000E+04, 4.3901223970E+01, 5.2068657382E+00, 2.5258445772E+01, 3.9304585119E+00, 9.8055773727E-01],
	[4.6750000000E+04, 4.3909559011E+01, 5.2069104937E+00, 2.5267260123E+01, 3.9307641945E+00, 9.8056538917E-01],
	[4.6755000000E+04, 4.3917894744E+01, 5.2069552448E+00, 2.5276076605E+01, 3.9310698046E+00, 9.8057303753E-01],
	[4.6760000000E+04, 4.3926231167E+01, 5.2069999915E+00, 2.5284895217E+01, 3.9313753422E+00, 9.8058068233E-01],
	[4.6765000000E+04, 4.3934568281E+01, 5.2070447338E+00, 2.5293715961E+01, 3.9316808073E+00, 9.8058832358E-01],
	[4.6770000000E+04, 4.3942906086E+01, 5.2070894718E+00, 2.5302538837E+01, 3.9319861999E+00, 9.8059596128E-01],
	[4.6775000000E+04, 4.3951253608E+01, 5.2071352021E+00, 2.5311363844E+01, 3.9322921608E+00, 9.8060359544E-01],
	[4.6780000000E+04, 4.3959608663E+01, 5.2071816834E+00, 2.5320190984E+01, 3.9325985349E+00, 9.8061122605E-01],
	[4.6785000000E+04, 4.3967964414E+01, 5.2072281602E+00, 2.5329020256E+01, 3.9329048368E+00, 9.8061885313E-01],
	[4.6790000000E+04, 4.3976320860E+01, 5.2072746324E+00, 2.5337851661E+01, 3.9332110665E+00, 9.8062647666E-01],
	[4.6795000000E+04, 4.3984678001E+01, 5.2073211001E+00, 2.5346685198E+01, 3.9335172239E+00, 9.8063409665E-01],
	[4.6800000000E+04, 4.3993035837E+01, 5.2073675632E+00, 2.5355520869E+01, 3.9338233091E+00, 9.8064171311E-01],
	[4.6805000000E+04, 4.4001394367E+01, 5.2074140217E+00, 2.5364358674E+01, 3.9341293221E+00, 9.8064932603E-01],
	[4.6810000000E+04, 4.4009753593E+01, 5.2074604757E+00, 2.5373198613E+01, 3.9344352630E+00, 9.8065693541E-01],
	[4.6815000000E+04, 4.4018113514E+01, 5.2075069252E+00, 2.5382040685E+01, 3.9347411317E+00, 9.8066454127E-01],
	[4.6820000000E+04, 4.4026474130E+01, 5.2075533701E+00, 2.5390884893E+01, 3.9350469282E+00, 9.8067214359E-01],
	[4.6825000000E+04, 4.4034835440E+01, 5.2075998105E+00, 2.5399731234E+01, 3.9353526527E+00, 9.8067974239E-01],
	[4.6830000000E+04, 4.4043197446E+01, 5.2076462463E+00, 2.5408579711E+01, 3.9356583050E+00, 9.8068733766E-01],
	[4.6835000000E+04, 4.4051560146E+01, 5.2076926776E+00, 2.5417430324E+01, 3.9359638853E+00, 9.8069492941E-01],
	[4.6840000000E+04, 4.4059923542E+01, 5.2077391044E+00, 2.5426283071E+01, 3.9362693935E+00, 9.8070251764E-01],
	[4.6845000000E+04, 4.4068287632E+01, 5.2077855265E+00, 2.5435137955E+01, 3.9365748297E+00, 9.8071010234E-01],
	[4.6850000000E+04, 4.4076652417E+01, 5.2078319442E+00, 2.5443994975E+01, 3.9368801938E+00, 9.8071768353E-01],
	[4.6855000000E+04, 4.4085017897E+01, 5.2078783573E+00, 2.5452854131E+01, 3.9371854859E+00, 9.8072526120E-01],
	[4.6860000000E+04, 4.4093384072E+01, 5.2079247659E+00, 2.5461715424E+01, 3.9374907061E+00, 9.8073283535E-01],
	[4.6865000000E+04, 4.4101750941E+01, 5.2079711699E+00, 2.5470578855E+01, 3.9377958543E+00, 9.8074040599E-01],
	[4.6870000000E+04, 4.4110118505E+01, 5.2080175694E+00, 2.5479444422E+01, 3.9381009305E+00, 9.8074797312E-01],
	[4.6875000000E+04, 4.4118486764E+01, 5.2080639644E+00, 2.5488312127E+01, 3.9384059348E+00, 9.8075553674E-01],
	[4.6880000000E+04, 4.4126855718E+01, 5.2081103548E+00, 2.5497181970E+01, 3.9387108672E+00, 9.8076309685E-01],
	[4.6885000000E+04, 4.4135225367E+01, 5.2081567407E+00, 2.5506053951E+01, 3.9390157277E+00, 9.8077065345E-01],
	[4.6890000000E+04, 4.4143595710E+01, 5.2082031221E+00, 2.5514928071E+01, 3.9393205163E+00, 9.8077820655E-01],
	[4.6895000000E+04, 4.4151966748E+01, 5.2082494989E+00, 2.5523804329E+01, 3.9396252330E+00, 9.8078575615E-01],
	[4.6900000000E+04, 4.4160338480E+01, 5.2082958712E+00, 2.5532682726E+01, 3.9399298779E+00, 9.8079330224E-01],
	[4.6905000000E+04, 4.4168710908E+01, 5.2083422390E+00, 2.5541563263E+01, 3.9402344510E+00, 9.8080084484E-01],
	[4.6910000000E+04, 4.4177084030E+01, 5.2083886022E+00, 2.5550445939E+01, 3.9405389523E+00, 9.8080838394E-01],
	[4.6915000000E+04, 4.4185457846E+01, 5.2084349610E+00, 2.5559330755E+01, 3.9408433818E+00, 9.8081591954E-01],
	[4.6920000000E+04, 4.4193832357E+01, 5.2084813151E+00, 2.5568217712E+01, 3.9411477396E+00, 9.8082345166E-01],
	[4.6925000000E+04, 4.4202207563E+01, 5.2085276648E+00, 2.5577106808E+01, 3.9414520255E+00, 9.8083098027E-01],
	[4.6930000000E+04, 4.4210583463E+01, 5.2085740099E+00, 2.5585998046E+01, 3.9417562398E+00, 9.8083850540E-01],
	[4.6935000000E+04, 4.4218960058E+01, 5.2086203505E+00, 2.5594891425E+01, 3.9420603823E+00, 9.8084602704E-01],
	[4.6940000000E+04, 4.4227337348E+01, 5.2086666866E+00, 2.5603786945E+01, 3.9423644532E+00, 9.8085354519E-01],
	[4.6945000000E+04, 4.4235715332E+01, 5.2087130182E+00, 2.5612684606E+01, 3.9426684524E+00, 9.8086105986E-01],
	[4.6950000000E+04, 4.4244094010E+01, 5.2087593452E+00, 2.5621584410E+01, 3.9429723799E+00, 9.8086857105E-01],
	[4.6955000000E+04, 4.4252473383E+01, 5.2088056677E+00, 2.5630486355E+01, 3.9432762357E+00, 9.8087607875E-01],
	[4.6960000000E+04, 4.4260853451E+01, 5.2088519857E+00, 2.5639390443E+01, 3.9435800200E+00, 9.8088358298E-01],
	[4.6965000000E+04, 4.4269234213E+01, 5.2088982992E+00, 2.5648296674E+01, 3.9438837327E+00, 9.8089108372E-01],
	[4.6970000000E+04, 4.4277615669E+01, 5.2089446081E+00, 2.5657205048E+01, 3.9441873737E+00, 9.8089858099E-01],
	[4.6975000000E+04, 4.4285997820E+01, 5.2089909126E+00, 2.5666115565E+01, 3.9444909432E+00, 9.8090607479E-01],
	[4.6980000000E+04, 4.4294380665E+01, 5.2090372125E+00, 2.5675028226E+01, 3.9447944412E+00, 9.8091356511E-01],
	[4.6985000000E+04, 4.4302764205E+01, 5.2090835079E+00, 2.5683943031E+01, 3.9450978676E+00, 9.8092105197E-01],
	[4.6990000000E+04, 4.4311148439E+01, 5.2091297988E+00, 2.5692859980E+01, 3.9454012225E+00, 9.8092853535E-01],
	[4.6995000000E+04, 4.4319533367E+01, 5.2091760852E+00, 2.5701779074E+01, 3.9457045060E+00, 9.8093601527E-01],
	[4.7000000000E+04, 4.4327918990E+01, 5.2092223670E+00, 2.5710700312E+01, 3.9460077179E+00, 9.8094349172E-01],
	[4.7005000000E+04, 4.4336305307E+01, 5.2092686444E+00, 2.5719623695E+01, 3.9463108584E+00, 9.8095096471E-01],
	[4.7010000000E+04, 4.4344692318E+01, 5.2093149172E+00, 2.5728549224E+01, 3.9466139275E+00, 9.8095843424E-01],
	[4.7015000000E+04, 4.4353080024E+01, 5.2093611855E+00, 2.5737476898E+01, 3.9469169251E+00, 9.8096590031E-01],
	[4.7020000000E+04, 4.4361468424E+01, 5.2094074494E+00, 2.5746406718E+01, 3.9472198514E+00, 9.8097336292E-01],
	[4.7025000000E+04, 4.4369857518E+01, 5.2094537087E+00, 2.5755338685E+01, 3.9475227062E+00, 9.8098082207E-01],
	[4.7030000000E+04, 4.4378247307E+01, 5.2094999635E+00, 2.5764272797E+01, 3.9478254897E+00, 9.8098827777E-01],
	[4.7035000000E+04, 4.4386637790E+01, 5.2095462138E+00, 2.5773209057E+01, 3.9481282019E+00, 9.8099573002E-01],
	[4.7040000000E+04, 4.4395028967E+01, 5.2095924596E+00, 2.5782147464E+01, 3.9484308427E+00, 9.8100317881E-01],
	[4.7045000000E+04, 4.4403420838E+01, 5.2096387009E+00, 2.5791088018E+01, 3.9487334122E+00, 9.8101062416E-01],
	[4.7050000000E+04, 4.4411813403E+01, 5.2096849376E+00, 2.5800030719E+01, 3.9490359104E+00, 9.8101806606E-01],
	[4.7055000000E+04, 4.4420206663E+01, 5.2097311699E+00, 2.5808975569E+01, 3.9493383373E+00, 9.8102550451E-01],
	[4.7060000000E+04, 4.4428600617E+01, 5.2097773977E+00, 2.5817922567E+01, 3.9496406930E+00, 9.8103293952E-01],
	[4.7065000000E+04, 4.4436995264E+01, 5.2098236210E+00, 2.5826871713E+01, 3.9499429775E+00, 9.8104037109E-01],
	[4.7070000000E+04, 4.4445390606E+01, 5.2098698397E+00, 2.5835823008E+01, 3.9502451907E+00, 9.8104779921E-01],
	[4.7075000000E+04, 4.4453786642E+01, 5.2099160540E+00, 2.5844776453E+01, 3.9505473328E+00, 9.8105522390E-01],
	[4.7080000000E+04, 4.4462183373E+01, 5.2099622638E+00, 2.5853732046E+01, 3.9508494036E+00, 9.8106264515E-01],
	[4.7085000000E+04, 4.4470580797E+01, 5.2100084691E+00, 2.5862689789E+01, 3.9511514033E+00, 9.8107006297E-01],
	[4.7090000000E+04, 4.4478978915E+01, 5.2100546699E+00, 2.5871649682E+01, 3.9514533319E+00, 9.8107747735E-01],
	[4.7095000000E+04, 4.4487377728E+01, 5.2101008661E+00, 2.5880611726E+01, 3.9517551893E+00, 9.8108488830E-01],
	[4.7100000000E+04, 4.4495777234E+01, 5.2101470579E+00, 2.5889575920E+01, 3.9520569756E+00, 9.8109229582E-01],
	[4.7105000000E+04, 4.4504177434E+01, 5.2101932452E+00, 2.5898542264E+01, 3.9523586908E+00, 9.8109969992E-01],
	[4.7110000000E+04, 4.4512578329E+01, 5.2102394280E+00, 2.5907510760E+01, 3.9526603350E+00, 9.8110710059E-01],
	[4.7115000000E+04, 4.4520979917E+01, 5.2102856064E+00, 2.5916481407E+01, 3.9529619081E+00, 9.8111449783E-01],
	[4.7120000000E+04, 4.4529382199E+01, 5.2103317802E+00, 2.5925454206E+01, 3.9532634102E+00, 9.8112189165E-01],
	[4.7125000000E+04, 4.4537785176E+01, 5.2103779495E+00, 2.5934429156E+01, 3.9535648412E+00, 9.8112928205E-01],
	[4.7130000000E+04, 4.4546188846E+01, 5.2104241144E+00, 2.5943406259E+01, 3.9538662013E+00, 9.8113666903E-01],
	[4.7135000000E+04, 4.4554593210E+01, 5.2104702747E+00, 2.5952385515E+01, 3.9541674903E+00, 9.8114405259E-01],
	[4.7140000000E+04, 4.4562998268E+01, 5.2105164306E+00, 2.5961366923E+01, 3.9544687084E+00, 9.8115143274E-01],
	[4.7145000000E+04, 4.4571404020E+01, 5.2105625820E+00, 2.5970350484E+01, 3.9547698556E+00, 9.8115880948E-01],
	[4.7150000000E+04, 4.4579810465E+01, 5.2106087289E+00, 2.5979336199E+01, 3.9550709318E+00, 9.8116618280E-01],
	[4.7155000000E+04, 4.4588217605E+01, 5.2106548713E+00, 2.5988324067E+01, 3.9553719372E+00, 9.8117355271E-01],
	[4.7160000000E+04, 4.4596625438E+01, 5.2107010092E+00, 2.5997314089E+01, 3.9556728716E+00, 9.8118091921E-01],
	[4.7165000000E+04, 4.4605033966E+01, 5.2107471426E+00, 2.6006306266E+01, 3.9559737352E+00, 9.8118828231E-01],
	[4.7170000000E+04, 4.4613443187E+01, 5.2107932716E+00, 2.6015300597E+01, 3.9562745279E+00, 9.8119564200E-01],
	[4.7175000000E+04, 4.4621853101E+01, 5.2108393961E+00, 2.6024297083E+01, 3.9565752498E+00, 9.8120299829E-01],
	[4.7180000000E+04, 4.4630263710E+01, 5.2108855161E+00, 2.6033295724E+01, 3.9568759008E+00, 9.8121035117E-01],
	[4.7185000000E+04, 4.4638675012E+01, 5.2109316316E+00, 2.6042296520E+01, 3.9571764811E+00, 9.8121770066E-01],
	[4.7190000000E+04, 4.4647087008E+01, 5.2109777426E+00, 2.6051299472E+01, 3.9574769906E+00, 9.8122504675E-01],
	[4.7195000000E+04, 4.4655499698E+01, 5.2110238492E+00, 2.6060304580E+01, 3.9577774293E+00, 9.8123238944E-01],
	[4.7200000000E+04, 4.4663913081E+01, 5.2110699513E+00, 2.6069311844E+01, 3.9580777973E+00, 9.8123972874E-01],
	[4.7205000000E+04, 4.4672327159E+01, 5.2111160489E+00, 2.6078321265E+01, 3.9583780946E+00, 9.8124706465E-01],
	[4.7210000000E+04, 4.4680741929E+01, 5.2111621420E+00, 2.6087332842E+01, 3.9586783211E+00, 9.8125439716E-01],
	[4.7215000000E+04, 4.4689157394E+01, 5.2112082307E+00, 2.6096346577E+01, 3.9589784770E+00, 9.8126172629E-01],
	[4.7220000000E+04, 4.4697573552E+01, 5.2112543149E+00, 2.6105362469E+01, 3.9592785622E+00, 9.8126905202E-01],
	[4.7225000000E+04, 4.4705990404E+01, 5.2113003946E+00, 2.6114380519E+01, 3.9595785767E+00, 9.8127637438E-01],
	[4.7230000000E+04, 4.4714407949E+01, 5.2113464699E+00, 2.6123400727E+01, 3.9598785206E+00, 9.8128369334E-01],
	[4.7235000000E+04, 4.4722826188E+01, 5.2113925406E+00, 2.6132423092E+01, 3.9601783939E+00, 9.8129100893E-01],
	[4.7240000000E+04, 4.4731245120E+01, 5.2114386070E+00, 2.6141447617E+01, 3.9604781966E+00, 9.8129832114E-01],
	[4.7245000000E+04, 4.4739664746E+01, 5.2114846688E+00, 2.6150474300E+01, 3.9607779287E+00, 9.8130562996E-01],
	[4.7250000000E+04, 4.4748085066E+01, 5.2115307262E+00, 2.6159503143E+01, 3.9610775902E+00, 9.8131293541E-01],
	[4.7255000000E+04, 4.4756506079E+01, 5.2115767791E+00, 2.6168534145E+01, 3.9613771812E+00, 9.8132023749E-01],
	[4.7260000000E+04, 4.4764927785E+01, 5.2116228275E+00, 2.6177567306E+01, 3.9616767017E+00, 9.8132753619E-01],
	[4.7265000000E+04, 4.4773350185E+01, 5.2116688715E+00, 2.6186602628E+01, 3.9619761517E+00, 9.8133483152E-01],
	[4.7270000000E+04, 4.4781773279E+01, 5.2117149110E+00, 2.6195640109E+01, 3.9622755312E+00, 9.8134212348E-01],
	[4.7275000000E+04, 4.4790197066E+01, 5.2117609461E+00, 2.6204679752E+01, 3.9625748402E+00, 9.8134941207E-01],
	[4.7280000000E+04, 4.4798621546E+01, 5.2118069766E+00, 2.6213721555E+01, 3.9628740787E+00, 9.8135669730E-01],
	[4.7285000000E+04, 4.4807046720E+01, 5.2118530028E+00, 2.6222765519E+01, 3.9631732469E+00, 9.8136397916E-01],
	[4.7290000000E+04, 4.4815472587E+01, 5.2118990244E+00, 2.6231811645E+01, 3.9634723446E+00, 9.8137125766E-01],
	[4.7295000000E+04, 4.4823899148E+01, 5.2119450416E+00, 2.6240859932E+01, 3.9637713719E+00, 9.8137853279E-01],
	[4.7300000000E+04, 4.4832326402E+01, 5.2119910544E+00, 2.6249910382E+01, 3.9640703288E+00, 9.8138580457E-01],
	[4.7305000000E+04, 4.4840754349E+01, 5.2120370627E+00, 2.6258962993E+01, 3.9643692154E+00, 9.8139307299E-01],
	[4.7310000000E+04, 4.4849182990E+01, 5.2120830665E+00, 2.6268017767E+01, 3.9646680316E+00, 9.8140033805E-01],
	[4.7315000000E+04, 4.4857612324E+01, 5.2121290659E+00, 2.6277074705E+01, 3.9649667775E+00, 9.8140759976E-01],
	[4.7320000000E+04, 4.4866042352E+01, 5.2121750608E+00, 2.6286133805E+01, 3.9652654531E+00, 9.8141485812E-01],
	[4.7325000000E+04, 4.4874473072E+01, 5.2122210513E+00, 2.6295195068E+01, 3.9655640584E+00, 9.8142211312E-01],
	[4.7330000000E+04, 4.4882904486E+01, 5.2122670373E+00, 2.6304258496E+01, 3.9658625935E+00, 9.8142936478E-01],
	[4.7335000000E+04, 4.4891336593E+01, 5.2123130189E+00, 2.6313324087E+01, 3.9661610582E+00, 9.8143661309E-01],
	[4.7340000000E+04, 4.4899769394E+01, 5.2123589960E+00, 2.6322391843E+01, 3.9664594528E+00, 9.8144385806E-01],
	[4.7345000000E+04, 4.4908202887E+01, 5.2124049686E+00, 2.6331461763E+01, 3.9667577771E+00, 9.8145109968E-01],
	[4.7350000000E+04, 4.4916637074E+01, 5.2124509369E+00, 2.6340533848E+01, 3.9670560312E+00, 9.8145833796E-01],
	[4.7355000000E+04, 4.4925071954E+01, 5.2124969006E+00, 2.6349608098E+01, 3.9673542152E+00, 9.8146557289E-01],
	[4.7360000000E+04, 4.4933507527E+01, 5.2125428599E+00, 2.6358684514E+01, 3.9676523290E+00, 9.8147280449E-01],
	[4.7365000000E+04, 4.4941943794E+01, 5.2125888148E+00, 2.6367763095E+01, 3.9679503726E+00, 9.8148003276E-01],
	[4.7370000000E+04, 4.4950380753E+01, 5.2126347652E+00, 2.6376843842E+01, 3.9682483461E+00, 9.8148725768E-01],
	[4.7375000000E+04, 4.4958818406E+01, 5.2126807112E+00, 2.6385926756E+01, 3.9685462496E+00, 9.8149447928E-01],
	[4.7380000000E+04, 4.4967256752E+01, 5.2127266528E+00, 2.6395011836E+01, 3.9688440829E+00, 9.8150169754E-01],
	[4.7385000000E+04, 4.4975695791E+01, 5.2127725898E+00, 2.6404099083E+01, 3.9691418461E+00, 9.8150891247E-01],
	[4.7390000000E+04, 4.4984135523E+01, 5.2128185225E+00, 2.6413188498E+01, 3.9694395393E+00, 9.8151612408E-01],
	[4.7395000000E+04, 4.4992575948E+01, 5.2128644507E+00, 2.6422280079E+01, 3.9697371625E+00, 9.8152333236E-01],
	[4.7400000000E+04, 4.5001017066E+01, 5.2129103745E+00, 2.6431373829E+01, 3.9700347156E+00, 9.8153053731E-01],
	[4.7405000000E+04, 4.5009458877E+01, 5.2129562938E+00, 2.6440469746E+01, 3.9703321988E+00, 9.8153773894E-01],
	[4.7410000000E+04, 4.5017901381E+01, 5.2130022087E+00, 2.6449567832E+01, 3.9706296119E+00, 9.8154493725E-01],
	[4.7415000000E+04, 4.5026344578E+01, 5.2130481192E+00, 2.6458668086E+01, 3.9709269551E+00, 9.8155213224E-01],
	[4.7420000000E+04, 4.5034788468E+01, 5.2130940252E+00, 2.6467770510E+01, 3.9712242284E+00, 9.8155932392E-01],
	[4.7425000000E+04, 4.5043233051E+01, 5.2131399267E+00, 2.6476875102E+01, 3.9715214317E+00, 9.8156651227E-01],
	[4.7430000000E+04, 4.5051678327E+01, 5.2131858239E+00, 2.6485981864E+01, 3.9718185652E+00, 9.8157369731E-01],
	[4.7435000000E+04, 4.5060124296E+01, 5.2132317166E+00, 2.6495090796E+01, 3.9721156287E+00, 9.8158087904E-01],
	[4.7440000000E+04, 4.5068570958E+01, 5.2132776049E+00, 2.6504201897E+01, 3.9724126224E+00, 9.8158805746E-01],
	[4.7445000000E+04, 4.5077018313E+01, 5.2133234887E+00, 2.6513315169E+01, 3.9727095462E+00, 9.8159523257E-01],
	[4.7450000000E+04, 4.5085466360E+01, 5.2133693681E+00, 2.6522430612E+01, 3.9730064001E+00, 9.8160240437E-01],
	[4.7455000000E+04, 4.5093915101E+01, 5.2134152431E+00, 2.6531548225E+01, 3.9733031843E+00, 9.8160957287E-01],
	[4.7460000000E+04, 4.5102364534E+01, 5.2134611137E+00, 2.6540668010E+01, 3.9735998986E+00, 9.8161673806E-01],
	[4.7465000000E+04, 4.5110814661E+01, 5.2135069798E+00, 2.6549789966E+01, 3.9738965432E+00, 9.8162389995E-01],
	[4.7470000000E+04, 4.5119265480E+01, 5.2135528415E+00, 2.6558914094E+01, 3.9741931180E+00, 9.8163105854E-01],
	[4.7475000000E+04, 4.5127716992E+01, 5.2135986988E+00, 2.6568040394E+01, 3.9744896231E+00, 9.8163821384E-01],
	[4.7480000000E+04, 4.5136169196E+01, 5.2136445516E+00, 2.6577168866E+01, 3.9747860584E+00, 9.8164536583E-01],
	[4.7485000000E+04, 4.5144622094E+01, 5.2136904000E+00, 2.6586299511E+01, 3.9750824240E+00, 9.8165251453E-01],
	[4.7490000000E+04, 4.5153075684E+01, 5.2137362440E+00, 2.6595432329E+01, 3.9753787199E+00, 9.8165965993E-01],
	[4.7495000000E+04, 4.5161529967E+01, 5.2137820836E+00, 2.6604567320E+01, 3.9756749462E+00, 9.8166680205E-01],
	[4.7500000000E+04, 4.5169984942E+01, 5.2138279188E+00, 2.6613704484E+01, 3.9759711028E+00, 9.8167394087E-01],
	[4.7505000000E+04, 4.5178440611E+01, 5.2138737495E+00, 2.6622843823E+01, 3.9762671898E+00, 9.8168107641E-01],
	[4.7510000000E+04, 4.5186896972E+01, 5.2139195758E+00, 2.6631985335E+01, 3.9765632071E+00, 9.8168820865E-01],
	[4.7515000000E+04, 4.5195354025E+01, 5.2139653977E+00, 2.6641129022E+01, 3.9768591549E+00, 9.8169533762E-01],
	[4.7520000000E+04, 4.5203811772E+01, 5.2140112151E+00, 2.6650274883E+01, 3.9771550330E+00, 9.8170246330E-01],
	[4.7525000000E+04, 4.5212270211E+01, 5.2140570282E+00, 2.6659422919E+01, 3.9774508416E+00, 9.8170958570E-01],
	[4.7530000000E+04, 4.5220744801E+01, 5.2141045096E+00, 2.6668573130E+01, 3.9777476738E+00, 9.8171670481E-01],
	[4.7535000000E+04, 4.5229220479E+01, 5.2141520289E+00, 2.6677725517E+01, 3.9780444644E+00, 9.8172382065E-01],
	[4.7540000000E+04, 4.5237696855E+01, 5.2141995436E+00, 2.6686880080E+01, 3.9783411856E+00, 9.8173093322E-01],
	[4.7545000000E+04, 4.5246173927E+01, 5.2142470538E+00, 2.6696036819E+01, 3.9786378374E+00, 9.8173804251E-01],
	[4.7550000000E+04, 4.5254651696E+01, 5.2142945594E+00, 2.6705195734E+01, 3.9789344199E+00, 9.8174514852E-01],
	[4.7555000000E+04, 4.5263130162E+01, 5.2143420604E+00, 2.6714356826E+01, 3.9792309332E+00, 9.8175225127E-01],
	[4.7560000000E+04, 4.5271609325E+01, 5.2143895569E+00, 2.6723520094E+01, 3.9795273771E+00, 9.8175935074E-01],
	[4.7565000000E+04, 4.5280089185E+01, 5.2144370488E+00, 2.6732685540E+01, 3.9798237518E+00, 9.8176644695E-01],
	[4.7570000000E+04, 4.5288569741E+01, 5.2144845362E+00, 2.6741853163E+01, 3.9801200572E+00, 9.8177353989E-01],
	[4.7575000000E+04, 4.5297050994E+01, 5.2145320190E+00, 2.6751022965E+01, 3.9804162933E+00, 9.8178062957E-01],
	[4.7580000000E+04, 4.5305532944E+01, 5.2145794972E+00, 2.6760194944E+01, 3.9807124603E+00, 9.8178771598E-01],
	[4.7585000000E+04, 4.5314015591E+01, 5.2146269709E+00, 2.6769369102E+01, 3.9810085581E+00, 9.8179479914E-01],
	[4.7590000000E+04, 4.5322498934E+01, 5.2146744400E+00, 2.6778545438E+01, 3.9813045867E+00, 9.8180187903E-01],
	[4.7595000000E+04, 4.5330982974E+01, 5.2147219046E+00, 2.6787723953E+01, 3.9816005461E+00, 9.8180895567E-01],
	[4.7600000000E+04, 4.5339467711E+01, 5.2147693646E+00, 2.6796904648E+01, 3.9818964364E+00, 9.8181602905E-01],
	[4.7605000000E+04, 4.5347953144E+01, 5.2148168200E+00, 2.6806087522E+01, 3.9821922575E+00, 9.8182309917E-01],
	[4.7610000000E+04, 4.5356439274E+01, 5.2148642709E+00, 2.6815272575E+01, 3.9824880096E+00, 9.8183016605E-01],
	[4.7615000000E+04, 4.5364926101E+01, 5.2149117173E+00, 2.6824459809E+01, 3.9827836925E+00, 9.8183722967E-01],
	[4.7620000000E+04, 4.5373413624E+01, 5.2149591591E+00, 2.6833649224E+01, 3.9830793064E+00, 9.8184429004E-01],
	[4.7625000000E+04, 4.5381901844E+01, 5.2150065964E+00, 2.6842840819E+01, 3.9833748512E+00, 9.8185134717E-01],
	[4.7630000000E+04, 4.5390390760E+01, 5.2150540291E+00, 2.6852034595E+01, 3.9836703270E+00, 9.8185840105E-01],
	[4.7635000000E+04, 4.5398880373E+01, 5.2151014572E+00, 2.6861230552E+01, 3.9839657338E+00, 9.8186545169E-01],
	[4.7640000000E+04, 4.5407370682E+01, 5.2151488808E+00, 2.6870428690E+01, 3.9842610716E+00, 9.8187249908E-01],
	[4.7645000000E+04, 4.5415861688E+01, 5.2151962999E+00, 2.6879629011E+01, 3.9845563404E+00, 9.8187954324E-01],
	[4.7650000000E+04, 4.5424353391E+01, 5.2152437144E+00, 2.6888831514E+01, 3.9848515402E+00, 9.8188658415E-01],
	[4.7655000000E+04, 4.5432845790E+01, 5.2152911244E+00, 2.6898036199E+01, 3.9851466711E+00, 9.8189362183E-01],
	[4.7660000000E+04, 4.5441338885E+01, 5.2153385299E+00, 2.6907243066E+01, 3.9854417330E+00, 9.8190065627E-01],
	[4.7665000000E+04, 4.5449832677E+01, 5.2153859307E+00, 2.6916452117E+01, 3.9857367261E+00, 9.8190768748E-01],
	[4.7670000000E+04, 4.5458327165E+01, 5.2154333271E+00, 2.6925663351E+01, 3.9860316502E+00, 9.8191471546E-01],
	[4.7675000000E+04, 4.5466822350E+01, 5.2154807189E+00, 2.6934876769E+01, 3.9863265055E+00, 9.8192174021E-01],
	[4.7680000000E+04, 4.5475318232E+01, 5.2155281062E+00, 2.6944092370E+01, 3.9866212919E+00, 9.8192876172E-01],
	[4.7685000000E+04, 4.5483814809E+01, 5.2155754889E+00, 2.6953310155E+01, 3.9869160094E+00, 9.8193578002E-01],
	[4.7690000000E+04, 4.5492312083E+01, 5.2156228671E+00, 2.6962530125E+01, 3.9872106582E+00, 9.8194279508E-01],
	[4.7695000000E+04, 4.5500810054E+01, 5.2156702408E+00, 2.6971752280E+01, 3.9875052381E+00, 9.8194980692E-01],
	[4.7700000000E+04, 4.5509308720E+01, 5.2157176099E+00, 2.6980976619E+01, 3.9877997493E+00, 9.8195681554E-01],
	[4.7705000000E+04, 4.5517808083E+01, 5.2157649745E+00, 2.6990203144E+01, 3.9880941917E+00, 9.8196382094E-01],
	[4.7710000000E+04, 4.5526308143E+01, 5.2158123345E+00, 2.6999431855E+01, 3.9883885653E+00, 9.8197082312E-01],
	[4.7715000000E+04, 4.5534808898E+01, 5.2158596901E+00, 2.7008662751E+01, 3.9886828702E+00, 9.8197782209E-01],
	[4.7720000000E+04, 4.5543310350E+01, 5.2159070411E+00, 2.7017895833E+01, 3.9889771064E+00, 9.8198481784E-01],
	[4.7725000000E+04, 4.5551812499E+01, 5.2159543875E+00, 2.7027131102E+01, 3.9892712739E+00, 9.8199181037E-01],
	[4.7730000000E+04, 4.5560315343E+01, 5.2160017294E+00, 2.7036368558E+01, 3.9895653727E+00, 9.8199879970E-01],
	[4.7735000000E+04, 4.5568818884E+01, 5.2160490668E+00, 2.7045608200E+01, 3.9898594029E+00, 9.8200578581E-01],
	[4.7740000000E+04, 4.5577323121E+01, 5.2160963997E+00, 2.7054850030E+01, 3.9901533644E+00, 9.8201276872E-01],
	[4.7745000000E+04, 4.5585828054E+01, 5.2161437281E+00, 2.7064094047E+01, 3.9904472573E+00, 9.8201974842E-01],
	[4.7750000000E+04, 4.5594333684E+01, 5.2161910519E+00, 2.7073340253E+01, 3.9907410815E+00, 9.8202672491E-01],
	[4.7755000000E+04, 4.5602840009E+01, 5.2162383712E+00, 2.7082588646E+01, 3.9910348372E+00, 9.8203369820E-01],
	[4.7760000000E+04, 4.5611347031E+01, 5.2162856859E+00, 2.7091839228E+01, 3.9913285243E+00, 9.8204066829E-01],
	[4.7765000000E+04, 4.5619854749E+01, 5.2163329962E+00, 2.7101091999E+01, 3.9916221429E+00, 9.8204763518E-01],
	[4.7770000000E+04, 4.5628363163E+01, 5.2163803019E+00, 2.7110346958E+01, 3.9919156929E+00, 9.8205459887E-01],
	[4.7775000000E+04, 4.5636872273E+01, 5.2164276031E+00, 2.7119604107E+01, 3.9922091744E+00, 9.8206155937E-01],
	[4.7780000000E+04, 4.5645382079E+01, 5.2164748998E+00, 2.7128863446E+01, 3.9925025874E+00, 9.8206851667E-01],
	[4.7785000000E+04, 4.5653892582E+01, 5.2165221919E+00, 2.7138124974E+01, 3.9927959319E+00, 9.8207547077E-01],
	[4.7790000000E+04, 4.5662403780E+01, 5.2165694795E+00, 2.7147388693E+01, 3.9930892080E+00, 9.8208242169E-01],
	[4.7795000000E+04, 4.5670915674E+01, 5.2166167627E+00, 2.7156654602E+01, 3.9933824156E+00, 9.8208936941E-01],
	[4.7800000000E+04, 4.5679428265E+01, 5.2166640413E+00, 2.7165922702E+01, 3.9936755548E+00, 9.8209631395E-01],
	[4.7805000000E+04, 4.5687941551E+01, 5.2167113153E+00, 2.7175192992E+01, 3.9939686255E+00, 9.8210325530E-01],
	[4.7810000000E+04, 4.5696455534E+01, 5.2167585849E+00, 2.7184465475E+01, 3.9942616279E+00, 9.8211019347E-01],
	[4.7815000000E+04, 4.5704970212E+01, 5.2168058500E+00, 2.7193740148E+01, 3.9945545619E+00, 9.8211712845E-01],
	[4.7820000000E+04, 4.5713485587E+01, 5.2168531105E+00, 2.7203017014E+01, 3.9948474275E+00, 9.8212406025E-01],
	[4.7825000000E+04, 4.5722001657E+01, 5.2169003665E+00, 2.7212296072E+01, 3.9951402248E+00, 9.8213098887E-01],
	[4.7830000000E+04, 4.5730518423E+01, 5.2169476180E+00, 2.7221577322E+01, 3.9954329538E+00, 9.8213791431E-01],
	[4.7835000000E+04, 4.5739035886E+01, 5.2169948650E+00, 2.7230860765E+01, 3.9957256144E+00, 9.8214483658E-01],
	[4.7840000000E+04, 4.5747554044E+01, 5.2170421075E+00, 2.7240146401E+01, 3.9960182068E+00, 9.8215175567E-01],
	[4.7845000000E+04, 4.5756072898E+01, 5.2170893455E+00, 2.7249434231E+01, 3.9963107309E+00, 9.8215867159E-01],
	[4.7850000000E+04, 4.5764592448E+01, 5.2171365790E+00, 2.7258724254E+01, 3.9966031868E+00, 9.8216558434E-01],
	[4.7855000000E+04, 4.5773112694E+01, 5.2171838079E+00, 2.7268016471E+01, 3.9968955744E+00, 9.8217249392E-01],
	[4.7860000000E+04, 4.5781633635E+01, 5.2172310324E+00, 2.7277310882E+01, 3.9971878938E+00, 9.8217940033E-01],
	[4.7865000000E+04, 4.5790155273E+01, 5.2172782523E+00, 2.7286607488E+01, 3.9974801450E+00, 9.8218630357E-01],
	[4.7870000000E+04, 4.5798677606E+01, 5.2173254678E+00, 2.7295906288E+01, 3.9977723280E+00, 9.8219320365E-01],
	[4.7875000000E+04, 4.5807200635E+01, 5.2173726787E+00, 2.7305207284E+01, 3.9980644429E+00, 9.8220010056E-01],
	[4.7880000000E+04, 4.5815724360E+01, 5.2174198852E+00, 2.7314510475E+01, 3.9983564896E+00, 9.8220699432E-01],
	[4.7885000000E+04, 4.5824248781E+01, 5.2174670871E+00, 2.7323815861E+01, 3.9986484682E+00, 9.8221388491E-01],
	[4.7890000000E+04, 4.5832773897E+01, 5.2175142845E+00, 2.7333123444E+01, 3.9989403787E+00, 9.8222077235E-01],
	[4.7895000000E+04, 4.5841299709E+01, 5.2175614775E+00, 2.7342433222E+01, 3.9992322210E+00, 9.8222765663E-01],
	[4.7900000000E+04, 4.5849826217E+01, 5.2176086659E+00, 2.7351745197E+01, 3.9995239953E+00, 9.8223453776E-01],
	[4.7905000000E+04, 4.5858353420E+01, 5.2176558498E+00, 2.7361059369E+01, 3.9998157016E+00, 9.8224141573E-01],
	[4.7910000000E+04, 4.5866881320E+01, 5.2177030293E+00, 2.7370375738E+01, 4.0001073398E+00, 9.8224829055E-01],
	[4.7915000000E+04, 4.5875409914E+01, 5.2177502042E+00, 2.7379694305E+01, 4.0003989100E+00, 9.8225516222E-01],
	[4.7920000000E+04, 4.5883939205E+01, 5.2177973746E+00, 2.7389015069E+01, 4.0006904122E+00, 9.8226203074E-01],
	[4.7925000000E+04, 4.5892469191E+01, 5.2178445406E+00, 2.7398338031E+01, 4.0009818464E+00, 9.8226889612E-01],
	[4.7930000000E+04, 4.5900999873E+01, 5.2178917021E+00, 2.7407663191E+01, 4.0012732126E+00, 9.8227575835E-01],
	[4.7935000000E+04, 4.5909531250E+01, 5.2179388590E+00, 2.7416990550E+01, 4.0015645109E+00, 9.8228261744E-01],
	[4.7940000000E+04, 4.5918063323E+01, 5.2179860115E+00, 2.7426320108E+01, 4.0018557413E+00, 9.8228947339E-01],
	[4.7945000000E+04, 4.5926596092E+01, 5.2180331595E+00, 2.7435651864E+01, 4.0021469037E+00, 9.8229632620E-01],
	[4.7950000000E+04, 4.5935129556E+01, 5.2180803029E+00, 2.7444985820E+01, 4.0024379982E+00, 9.8230317587E-01],
	[4.7955000000E+04, 4.5943663716E+01, 5.2181274419E+00, 2.7454321976E+01, 4.0027290249E+00, 9.8231002240E-01],
	[4.7960000000E+04, 4.5952198571E+01, 5.2181745765E+00, 2.7463660332E+01, 4.0030199837E+00, 9.8231686580E-01],
	[4.7965000000E+04, 4.5960734122E+01, 5.2182217065E+00, 2.7473000888E+01, 4.0033108746E+00, 9.8232370607E-01],
	[4.7970000000E+04, 4.5969270368E+01, 5.2182688320E+00, 2.7482343644E+01, 4.0036016978E+00, 9.8233054320E-01],
	[4.7975000000E+04, 4.5977807309E+01, 5.2183159531E+00, 2.7491688602E+01, 4.0038924531E+00, 9.8233737721E-01],
	[4.7980000000E+04, 4.5986344947E+01, 5.2183630696E+00, 2.7501035760E+01, 4.0041831406E+00, 9.8234420809E-01],
	[4.7985000000E+04, 4.5994883279E+01, 5.2184101817E+00, 2.7510385120E+01, 4.0044737604E+00, 9.8235103584E-01],
	[4.7990000000E+04, 4.6003422307E+01, 5.2184572893E+00, 2.7519736682E+01, 4.0047643124E+00, 9.8235786046E-01],
	[4.7995000000E+04, 4.6011962031E+01, 5.2185043924E+00, 2.7529090445E+01, 4.0050547966E+00, 9.8236468196E-01],
	[4.8000000000E+04, 4.6020502449E+01, 5.2185514910E+00, 2.7538446411E+01, 4.0053452132E+00, 9.8237150034E-01],
	[4.8005000000E+04, 4.6029043564E+01, 5.2185985852E+00, 2.7547804580E+01, 4.0056355620E+00, 9.8237831561E-01],
	[4.8010000000E+04, 4.6037585373E+01, 5.2186456748E+00, 2.7557164951E+01, 4.0059258432E+00, 9.8238512775E-01],
	[4.8015000000E+04, 4.6046127878E+01, 5.2186927600E+00, 2.7566527525E+01, 4.0062160566E+00, 9.8239193677E-01],
	[4.8020000000E+04, 4.6054671079E+01, 5.2187398407E+00, 2.7575892303E+01, 4.0065062025E+00, 9.8239874269E-01],
	[4.8025000000E+04, 4.6063214974E+01, 5.2187869170E+00, 2.7585259284E+01, 4.0067962807E+00, 9.8240554548E-01],
	[4.8030000000E+04, 4.6071759565E+01, 5.2188339887E+00, 2.7594628470E+01, 4.0070862913E+00, 9.8241234517E-01],
	[4.8035000000E+04, 4.6080304851E+01, 5.2188810560E+00, 2.7603999860E+01, 4.0073762343E+00, 9.8241914175E-01],
	[4.8040000000E+04, 4.6088850833E+01, 5.2189281188E+00, 2.7613373454E+01, 4.0076661097E+00, 9.8242593522E-01],
	[4.8045000000E+04, 4.6097397509E+01, 5.2189751772E+00, 2.7622749253E+01, 4.0079559175E+00, 9.8243272558E-01],
	[4.8050000000E+04, 4.6105944881E+01, 5.2190222310E+00, 2.7632127258E+01, 4.0082456578E+00, 9.8243951283E-01],
	[4.8055000000E+04, 4.6114492949E+01, 5.2190692804E+00, 2.7641507468E+01, 4.0085353306E+00, 9.8244629699E-01],
	[4.8060000000E+04, 4.6123041711E+01, 5.2191163253E+00, 2.7650889883E+01, 4.0088249359E+00, 9.8245307804E-01],
	[4.8065000000E+04, 4.6131591169E+01, 5.2191633658E+00, 2.7660274505E+01, 4.0091144737E+00, 9.8245985599E-01],
	[4.8070000000E+04, 4.6140141321E+01, 5.2192104018E+00, 2.7669661333E+01, 4.0094039440E+00, 9.8246663084E-01],
	[4.8075000000E+04, 4.6148692169E+01, 5.2192574333E+00, 2.7679050367E+01, 4.0096933469E+00, 9.8247340260E-01],
	[4.8080000000E+04, 4.6157243712E+01, 5.2193044603E+00, 2.7688441608E+01, 4.0099826823E+00, 9.8248017126E-01],
	[4.8085000000E+04, 4.6165795951E+01, 5.2193514829E+00, 2.7697835057E+01, 4.0102719503E+00, 9.8248693683E-01],
	[4.8090000000E+04, 4.6174348884E+01, 5.2193985010E+00, 2.7707230713E+01, 4.0105611509E+00, 9.8249369930E-01],
	[4.8095000000E+04, 4.6182902512E+01, 5.2194455146E+00, 2.7716628577E+01, 4.0108502841E+00, 9.8250045869E-01],
	[4.8100000000E+04, 4.6191456836E+01, 5.2194925238E+00, 2.7726028649E+01, 4.0111393499E+00, 9.8250721499E-01],
	[4.8105000000E+04, 4.6200011855E+01, 5.2195395285E+00, 2.7735430929E+01, 4.0114283484E+00, 9.8251396820E-01],
	[4.8110000000E+04, 4.6208567568E+01, 5.2195865288E+00, 2.7744835417E+01, 4.0117172796E+00, 9.8252071832E-01],
	[4.8115000000E+04, 4.6217123977E+01, 5.2196335246E+00, 2.7754242115E+01, 4.0120061434E+00, 9.8252746536E-01],
	[4.8120000000E+04, 4.6225681081E+01, 5.2196805159E+00, 2.7763651022E+01, 4.0122949400E+00, 9.8253420932E-01],
	[4.8125000000E+04, 4.6234238879E+01, 5.2197275028E+00, 2.7773062138E+01, 4.0125836693E+00, 9.8254095020E-01],
	[4.8130000000E+04, 4.6242797373E+01, 5.2197744852E+00, 2.7782475464E+01, 4.0128723313E+00, 9.8254768800E-01],
	[4.8135000000E+04, 4.6251356562E+01, 5.2198214632E+00, 2.7791891000E+01, 4.0131609261E+00, 9.8255442272E-01],
	[4.8140000000E+04, 4.6259916445E+01, 5.2198684367E+00, 2.7801308747E+01, 4.0134494536E+00, 9.8256115437E-01],
	[4.8145000000E+04, 4.6268477024E+01, 5.2199154057E+00, 2.7810728704E+01, 4.0137379139E+00, 9.8256788294E-01],
	[4.8150000000E+04, 4.6277038297E+01, 5.2199623703E+00, 2.7820150872E+01, 4.0140263071E+00, 9.8257460845E-01],
	[4.8155000000E+04, 4.6285600266E+01, 5.2200093305E+00, 2.7829575251E+01, 4.0143146330E+00, 9.8258133088E-01],
	[4.8160000000E+04, 4.6294162929E+01, 5.2200562861E+00, 2.7839001842E+01, 4.0146028919E+00, 9.8258805024E-01],
	[4.8165000000E+04, 4.6302726287E+01, 5.2201032374E+00, 2.7848430644E+01, 4.0148910835E+00, 9.8259476653E-01],
	[4.8170000000E+04, 4.6311290340E+01, 5.2201501842E+00, 2.7857861659E+01, 4.0151792081E+00, 9.8260147976E-01],
	[4.8175000000E+04, 4.6319855088E+01, 5.2201971265E+00, 2.7867294886E+01, 4.0154672655E+00, 9.8260818993E-01],
	[4.8180000000E+04, 4.6328420531E+01, 5.2202440644E+00, 2.7876730325E+01, 4.0157552559E+00, 9.8261489703E-01],
	[4.8185000000E+04, 4.6336986669E+01, 5.2202909978E+00, 2.7886167978E+01, 4.0160431792E+00, 9.8262160107E-01],
	[4.8190000000E+04, 4.6345553501E+01, 5.2203379268E+00, 2.7895607844E+01, 4.0163310355E+00, 9.8262830205E-01],
	[4.8195000000E+04, 4.6354121028E+01, 5.2203848513E+00, 2.7905049923E+01, 4.0166188247E+00, 9.8263499998E-01],
	[4.8200000000E+04, 4.6362689250E+01, 5.2204317714E+00, 2.7914494216E+01, 4.0169065469E+00, 9.8264169484E-01],
	[4.8205000000E+04, 4.6371258167E+01, 5.2204786870E+00, 2.7923940723E+01, 4.0171942021E+00, 9.8264838666E-01],
	[4.8210000000E+04, 4.6379827778E+01, 5.2205255982E+00, 2.7933389445E+01, 4.0174817903E+00, 9.8265507542E-01],
	[4.8215000000E+04, 4.6388398084E+01, 5.2205725050E+00, 2.7942840381E+01, 4.0177693116E+00, 9.8266176113E-01],
	[4.8220000000E+04, 4.6396969085E+01, 5.2206194073E+00, 2.7952293532E+01, 4.0180567659E+00, 9.8266844379E-01],
	[4.8225000000E+04, 4.6405540780E+01, 5.2206663052E+00, 2.7961748899E+01, 4.0183441533E+00, 9.8267512341E-01],
	[4.8230000000E+04, 4.6414113171E+01, 5.2207131986E+00, 2.7971206481E+01, 4.0186314738E+00, 9.8268179997E-01],
	[4.8235000000E+04, 4.6422686255E+01, 5.2207600876E+00, 2.7980666279E+01, 4.0189187274E+00, 9.8268847350E-01],
	[4.8240000000E+04, 4.6431260035E+01, 5.2208069722E+00, 2.7990128293E+01, 4.0192059141E+00, 9.8269514397E-01],
	[4.8245000000E+04, 4.6439834509E+01, 5.2208538523E+00, 2.7999592523E+01, 4.0194930339E+00, 9.8270181141E-01],
	[4.8250000000E+04, 4.6448409678E+01, 5.2209007279E+00, 2.8009058970E+01, 4.0197800870E+00, 9.8270847581E-01],
	[4.8255000000E+04, 4.6456985541E+01, 5.2209475992E+00, 2.8018527634E+01, 4.0200670731E+00, 9.8271513717E-01],
	[4.8260000000E+04, 4.6465562099E+01, 5.2209944660E+00, 2.8027998515E+01, 4.0203539925E+00, 9.8272179550E-01],
	[4.8265000000E+04, 4.6474139351E+01, 5.2210413284E+00, 2.8037471614E+01, 4.0206408451E+00, 9.8272845079E-01],
	[4.8270000000E+04, 4.6482717298E+01, 5.2210881863E+00, 2.8046946931E+01, 4.0209276310E+00, 9.8273510304E-01],
	[4.8275000000E+04, 4.6491295940E+01, 5.2211350398E+00, 2.8056424466E+01, 4.0212143501E+00, 9.8274175227E-01],
	[4.8280000000E+04, 4.6499875276E+01, 5.2211818889E+00, 2.8065904219E+01, 4.0215010024E+00, 9.8274839846E-01],
	[4.8285000000E+04, 4.6508455307E+01, 5.2212287335E+00, 2.8075386191E+01, 4.0217875881E+00, 9.8275504163E-01],
	[4.8290000000E+04, 4.6517036032E+01, 5.2212755737E+00, 2.8084870382E+01, 4.0220741070E+00, 9.8276168176E-01],
	[4.8295000000E+04, 4.6525632607E+01, 5.2213240168E+00, 2.8094356792E+01, 4.0223616264E+00, 9.8276831888E-01],
	[4.8300000000E+04, 4.6534230556E+01, 5.2213725269E+00, 2.8103845422E+01, 4.0226491269E+00, 9.8277495297E-01],
	[4.8305000000E+04, 4.6542829205E+01, 5.2214210325E+00, 2.8113336272E+01, 4.0229365608E+00, 9.8278158404E-01],
	[4.8310000000E+04, 4.6551428551E+01, 5.2214695335E+00, 2.8122829342E+01, 4.0232239283E+00, 9.8278821208E-01],
	[4.8315000000E+04, 4.6560028597E+01, 5.2215180300E+00, 2.8132324632E+01, 4.0235112293E+00, 9.8279483711E-01],
	[4.8320000000E+04, 4.6568629341E+01, 5.2215665218E+00, 2.8141822143E+01, 4.0237984638E+00, 9.8280145912E-01],
	[4.8325000000E+04, 4.6577230783E+01, 5.2216150091E+00, 2.8151321875E+01, 4.0240856319E+00, 9.8280807812E-01],
	[4.8330000000E+04, 4.6585832924E+01, 5.2216634919E+00, 2.8160823829E+01, 4.0243727336E+00, 9.8281469409E-01],
	[4.8335000000E+04, 4.6594435764E+01, 5.2217119701E+00, 2.8170328004E+01, 4.0246597689E+00, 9.8282130706E-01],
	[4.8340000000E+04, 4.6603039302E+01, 5.2217604437E+00, 2.8179834401E+01, 4.0249467378E+00, 9.8282791701E-01],
	[4.8345000000E+04, 4.6611643539E+01, 5.2218089127E+00, 2.8189343020E+01, 4.0252336404E+00, 9.8283452396E-01],
	[4.8350000000E+04, 4.6620248474E+01, 5.2218573772E+00, 2.8198853861E+01, 4.0255204765E+00, 9.8284112789E-01],
	[4.8355000000E+04, 4.6628854108E+01, 5.2219058371E+00, 2.8208366925E+01, 4.0258072464E+00, 9.8284772882E-01],
	[4.8360000000E+04, 4.6637460440E+01, 5.2219542925E+00, 2.8217882213E+01, 4.0260939499E+00, 9.8285432674E-01],
	[4.8365000000E+04, 4.6646067471E+01, 5.2220027433E+00, 2.8227399723E+01, 4.0263805872E+00, 9.8286092165E-01],
	[4.8370000000E+04, 4.6654675200E+01, 5.2220511895E+00, 2.8236919458E+01, 4.0266671582E+00, 9.8286751356E-01],
	[4.8375000000E+04, 4.6663283628E+01, 5.2220996312E+00, 2.8246441416E+01, 4.0269536629E+00, 9.8287410247E-01],
	[4.8380000000E+04, 4.6671892754E+01, 5.2221480683E+00, 2.8255965598E+01, 4.0272401013E+00, 9.8288068838E-01],
	[4.8385000000E+04, 4.6680502578E+01, 5.2221965009E+00, 2.8265492005E+01, 4.0275264735E+00, 9.8288727129E-01],
	[4.8390000000E+04, 4.6689113101E+01, 5.2222449289E+00, 2.8275020637E+01, 4.0278127796E+00, 9.8289385121E-01],
	[4.8395000000E+04, 4.6697724322E+01, 5.2222933524E+00, 2.8284551494E+01, 4.0280990194E+00, 9.8290042812E-01],
	[4.8400000000E+04, 4.6706336242E+01, 5.2223417713E+00, 2.8294084576E+01, 4.0283851930E+00, 9.8290700205E-01],
	[4.8405000000E+04, 4.6714948859E+01, 5.2223901856E+00, 2.8303619883E+01, 4.0286713005E+00, 9.8291357298E-01],
	[4.8410000000E+04, 4.6723562176E+01, 5.2224385954E+00, 2.8313157417E+01, 4.0289573419E+00, 9.8292014092E-01],
	[4.8415000000E+04, 4.6732176190E+01, 5.2224870007E+00, 2.8322697177E+01, 4.0292433171E+00, 9.8292670587E-01],
	[4.8420000000E+04, 4.6740790903E+01, 5.2225354014E+00, 2.8332239163E+01, 4.0295292262E+00, 9.8293326783E-01],
	[4.8425000000E+04, 4.6749406314E+01, 5.2225837976E+00, 2.8341783377E+01, 4.0298150693E+00, 9.8293982680E-01],
	[4.8430000000E+04, 4.6758022423E+01, 5.2226321892E+00, 2.8351329817E+01, 4.0301008462E+00, 9.8294638279E-01],
	[4.8435000000E+04, 4.6766639230E+01, 5.2226805762E+00, 2.8360878485E+01, 4.0303865572E+00, 9.8295293579E-01],
	[4.8440000000E+04, 4.6775256736E+01, 5.2227289587E+00, 2.8370429380E+01, 4.0306722020E+00, 9.8295948581E-01],
	[4.8445000000E+04, 4.6783874940E+01, 5.2227773367E+00, 2.8379982503E+01, 4.0309577809E+00, 9.8296603285E-01],
	[4.8450000000E+04, 4.6792493842E+01, 5.2228257101E+00, 2.8389537855E+01, 4.0312432937E+00, 9.8297257691E-01],
	[4.8455000000E+04, 4.6801113443E+01, 5.2228740790E+00, 2.8399095435E+01, 4.0315287406E+00, 9.8297911799E-01],
	[4.8460000000E+04, 4.6809733741E+01, 5.2229224433E+00, 2.8408655244E+01, 4.0318141215E+00, 9.8298565610E-01],
	[4.8465000000E+04, 4.6818354738E+01, 5.2229708031E+00, 2.8418217282E+01, 4.0320994364E+00, 9.8299219123E-01],
	[4.8470000000E+04, 4.6826976432E+01, 5.2230191583E+00, 2.8427781549E+01, 4.0323846855E+00, 9.8299872339E-01],
	[4.8475000000E+04, 4.6835598825E+01, 5.2230675091E+00, 2.8437348046E+01, 4.0326698686E+00, 9.8300525257E-01],
	[4.8480000000E+04, 4.6844221916E+01, 5.2231158552E+00, 2.8446916773E+01, 4.0329549858E+00, 9.8301177878E-01],
	[4.8485000000E+04, 4.6852845705E+01, 5.2231641969E+00, 2.8456487731E+01, 4.0332400371E+00, 9.8301830202E-01],
	[4.8490000000E+04, 4.6861470192E+01, 5.2232125339E+00, 2.8466060918E+01, 4.0335250225E+00, 9.8302482230E-01],
	[4.8495000000E+04, 4.6870095378E+01, 5.2232608665E+00, 2.8475636337E+01, 4.0338099422E+00, 9.8303133961E-01],
	[4.8500000000E+04, 4.6878721261E+01, 5.2233091945E+00, 2.8485213987E+01, 4.0340947959E+00, 9.8303785395E-01],
	[4.8505000000E+04, 4.6887347842E+01, 5.2233575180E+00, 2.8494793868E+01, 4.0343795839E+00, 9.8304436533E-01],
	[4.8510000000E+04, 4.6895975121E+01, 5.2234058370E+00, 2.8504375981E+01, 4.0346643061E+00, 9.8305087375E-01],
	[4.8515000000E+04, 4.6904603099E+01, 5.2234541514E+00, 2.8513960326E+01, 4.0349489625E+00, 9.8305737920E-01],
	[4.8520000000E+04, 4.6913231774E+01, 5.2235024613E+00, 2.8523546904E+01, 4.0352335531E+00, 9.8306388170E-01],
	[4.8525000000E+04, 4.6921861147E+01, 5.2235507666E+00, 2.8533135714E+01, 4.0355180780E+00, 9.8307038124E-01],
	[4.8530000000E+04, 4.6930491218E+01, 5.2235990674E+00, 2.8542726756E+01, 4.0358025372E+00, 9.8307687782E-01],
	[4.8535000000E+04, 4.6939121987E+01, 5.2236473637E+00, 2.8552320032E+01, 4.0360869307E+00, 9.8308337145E-01],
	[4.8540000000E+04, 4.6947753454E+01, 5.2236956555E+00, 2.8561915542E+01, 4.0363712584E+00, 9.8308986213E-01],
	[4.8545000000E+04, 4.6956385619E+01, 5.2237439427E+00, 2.8571513285E+01, 4.0366555205E+00, 9.8309634985E-01],
	[4.8550000000E+04, 4.6965018482E+01, 5.2237922255E+00, 2.8581113262E+01, 4.0369397170E+00, 9.8310283462E-01],
	[4.8555000000E+04, 4.6973652043E+01, 5.2238405036E+00, 2.8590715473E+01, 4.0372238478E+00, 9.8310931645E-01],
	[4.8560000000E+04, 4.6982286301E+01, 5.2238887773E+00, 2.8600319919E+01, 4.0375079130E+00, 9.8311579532E-01],
	[4.8565000000E+04, 4.6990921258E+01, 5.2239370464E+00, 2.8609926600E+01, 4.0377919126E+00, 9.8312227125E-01],
	[4.8570000000E+04, 4.6999556912E+01, 5.2239853110E+00, 2.8619535516E+01, 4.0380758466E+00, 9.8312874424E-01],
	[4.8575000000E+04, 4.7008193264E+01, 5.2240335711E+00, 2.8629146668E+01, 4.0383597150E+00, 9.8313521428E-01],
	[4.8580000000E+04, 4.7016830314E+01, 5.2240818267E+00, 2.8638760055E+01, 4.0386435179E+00, 9.8314168138E-01],
	[4.8585000000E+04, 4.7025468061E+01, 5.2241300778E+00, 2.8648375678E+01, 4.0389272552E+00, 9.8314814554E-01],
	[4.8590000000E+04, 4.7034106506E+01, 5.2241783243E+00, 2.8657993538E+01, 4.0392109270E+00, 9.8315460676E-01],
	[4.8595000000E+04, 4.7042745649E+01, 5.2242265663E+00, 2.8667613635E+01, 4.0394945333E+00, 9.8316106504E-01],
	[4.8600000000E+04, 4.7051385490E+01, 5.2242748038E+00, 2.8677235968E+01, 4.0397780742E+00, 9.8316752039E-01],
	[4.8605000000E+04, 4.7060026029E+01, 5.2243230368E+00, 2.8686860538E+01, 4.0400615495E+00, 9.8317397280E-01],
	[4.8610000000E+04, 4.7068667265E+01, 5.2243712652E+00, 2.8696487346E+01, 4.0403449595E+00, 9.8318042228E-01],
	[4.8615000000E+04, 4.7077309199E+01, 5.2244194892E+00, 2.8706116392E+01, 4.0406283040E+00, 9.8318686883E-01],
	[4.8620000000E+04, 4.7085951830E+01, 5.2244677086E+00, 2.8715747676E+01, 4.0409115830E+00, 9.8319331245E-01],
	[4.8625000000E+04, 4.7094595160E+01, 5.2245159235E+00, 2.8725381198E+01, 4.0411947967E+00, 9.8319975313E-01],
	[4.8630000000E+04, 4.7103239187E+01, 5.2245641339E+00, 2.8735016959E+01, 4.0414779450E+00, 9.8320619090E-01],
	[4.8635000000E+04, 4.7111883911E+01, 5.2246123398E+00, 2.8744654959E+01, 4.0417610279E+00, 9.8321262573E-01],
	[4.8640000000E+04, 4.7120529333E+01, 5.2246605412E+00, 2.8754295198E+01, 4.0420440455E+00, 9.8321905764E-01],
	[4.8645000000E+04, 4.7129175453E+01, 5.2247087380E+00, 2.8763937676E+01, 4.0423269978E+00, 9.8322548663E-01],
	[4.8650000000E+04, 4.7137822270E+01, 5.2247569304E+00, 2.8773582394E+01, 4.0426098847E+00, 9.8323191270E-01],
	[4.8655000000E+04, 4.7146469785E+01, 5.2248051182E+00, 2.8783229353E+01, 4.0428927064E+00, 9.8323833585E-01],
	[4.8660000000E+04, 4.7155117997E+01, 5.2248533016E+00, 2.8792878552E+01, 4.0431754628E+00, 9.8324475608E-01],
	[4.8665000000E+04, 4.7163766907E+01, 5.2249014804E+00, 2.8802529991E+01, 4.0434581539E+00, 9.8325117339E-01],
	[4.8670000000E+04, 4.7172416515E+01, 5.2249496548E+00, 2.8812183672E+01, 4.0437407798E+00, 9.8325758778E-01],
	[4.8675000000E+04, 4.7181066820E+01, 5.2249978246E+00, 2.8821839593E+01, 4.0440233404E+00, 9.8326399927E-01],
	[4.8680000000E+04, 4.7189717822E+01, 5.2250459899E+00, 2.8831497756E+01, 4.0443058359E+00, 9.8327040783E-01],
	[4.8685000000E+04, 4.7198369522E+01, 5.2250941507E+00, 2.8841158162E+01, 4.0445882661E+00, 9.8327681349E-01],
	[4.8690000000E+04, 4.7207021919E+01, 5.2251423071E+00, 2.8850820809E+01, 4.0448706312E+00, 9.8328321624E-01],
	[4.8695000000E+04, 4.7215675014E+01, 5.2251904589E+00, 2.8860485698E+01, 4.0451529311E+00, 9.8328961608E-01],
	[4.8700000000E+04, 4.7224328806E+01, 5.2252386062E+00, 2.8870152831E+01, 4.0454351659E+00, 9.8329601301E-01],
	[4.8705000000E+04, 4.7232983296E+01, 5.2252867490E+00, 2.8879822206E+01, 4.0457173356E+00, 9.8330240704E-01],
	[4.8710000000E+04, 4.7241638483E+01, 5.2253348873E+00, 2.8889493825E+01, 4.0459994401E+00, 9.8330879816E-01],
	[4.8715000000E+04, 4.7250294367E+01, 5.2253830211E+00, 2.8899167687E+01, 4.0462814796E+00, 9.8331518638E-01],
	[4.8720000000E+04, 4.7258950949E+01, 5.2254311505E+00, 2.8908843793E+01, 4.0465634540E+00, 9.8332157170E-01],
	[4.8725000000E+04, 4.7267608228E+01, 5.2254792753E+00, 2.8918522143E+01, 4.0468453633E+00, 9.8332795412E-01],
	[4.8730000000E+04, 4.7276266204E+01, 5.2255273956E+00, 2.8928202737E+01, 4.0471272077E+00, 9.8333433364E-01],
	[4.8735000000E+04, 4.7284924878E+01, 5.2255755115E+00, 2.8937885577E+01, 4.0474089869E+00, 9.8334071026E-01],
	[4.8740000000E+04, 4.7293584249E+01, 5.2256236228E+00, 2.8947570661E+01, 4.0476907012E+00, 9.8334708399E-01],
	[4.8745000000E+04, 4.7302244317E+01, 5.2256717297E+00, 2.8957257991E+01, 4.0479723505E+00, 9.8335345482E-01],
	[4.8750000000E+04, 4.7310905083E+01, 5.2257198320E+00, 2.8966947566E+01, 4.0482539349E+00, 9.8335982277E-01],
	[4.8755000000E+04, 4.7319566546E+01, 5.2257679299E+00, 2.8976639387E+01, 4.0485354543E+00, 9.8336618782E-01],
	[4.8760000000E+04, 4.7328228706E+01, 5.2258160233E+00, 2.8986333454E+01, 4.0488169087E+00, 9.8337254998E-01],
	[4.8765000000E+04, 4.7336891563E+01, 5.2258641122E+00, 2.8996029768E+01, 4.0490982983E+00, 9.8337890925E-01],
	[4.8770000000E+04, 4.7345555118E+01, 5.2259121966E+00, 2.9005728329E+01, 4.0493796229E+00, 9.8338526564E-01],
	[4.8775000000E+04, 4.7354219369E+01, 5.2259602765E+00, 2.9015429136E+01, 4.0496608827E+00, 9.8339161914E-01],
	[4.8780000000E+04, 4.7362884318E+01, 5.2260083519E+00, 2.9025132191E+01, 4.0499420776E+00, 9.8339796975E-01],
	[4.8785000000E+04, 4.7371549964E+01, 5.2260564229E+00, 2.9034837494E+01, 4.0502232076E+00, 9.8340431749E-01],
	[4.8790000000E+04, 4.7380216307E+01, 5.2261044893E+00, 2.9044545044E+01, 4.0505042728E+00, 9.8341066234E-01],
	[4.8795000000E+04, 4.7388883348E+01, 5.2261525513E+00, 2.9054254843E+01, 4.0507852732E+00, 9.8341700431E-01],
	[4.8800000000E+04, 4.7397551085E+01, 5.2262006088E+00, 2.9063966890E+01, 4.0510662088E+00, 9.8342334341E-01],
	[4.8805000000E+04, 4.7406219520E+01, 5.2262486618E+00, 2.9073681186E+01, 4.0513470797E+00, 9.8342967963E-01],
	[4.8810000000E+04, 4.7414888651E+01, 5.2262967104E+00, 2.9083397730E+01, 4.0516278857E+00, 9.8343601297E-01],
	[4.8815000000E+04, 4.7423558480E+01, 5.2263447544E+00, 2.9093116525E+01, 4.0519086270E+00, 9.8344234344E-01],
	[4.8820000000E+04, 4.7432229006E+01, 5.2263927940E+00, 2.9102837569E+01, 4.0521893036E+00, 9.8344867104E-01],
	[4.8825000000E+04, 4.7440900228E+01, 5.2264408291E+00, 2.9112560863E+01, 4.0524699155E+00, 9.8345499576E-01],
	[4.8830000000E+04, 4.7449572148E+01, 5.2264888597E+00, 2.9122286407E+01, 4.0527504627E+00, 9.8346131762E-01],
	[4.8835000000E+04, 4.7458244765E+01, 5.2265368858E+00, 2.9132014201E+01, 4.0530309452E+00, 9.8346763661E-01],
	[4.8840000000E+04, 4.7466918079E+01, 5.2265849075E+00, 2.9141744247E+01, 4.0533113631E+00, 9.8347395273E-01],
	[4.8845000000E+04, 4.7475592089E+01, 5.2266329247E+00, 2.9151476543E+01, 4.0535917163E+00, 9.8348026599E-01],
	[4.8850000000E+04, 4.7484266797E+01, 5.2266809374E+00, 2.9161211091E+01, 4.0538720049E+00, 9.8348657638E-01],
	[4.8855000000E+04, 4.7492942202E+01, 5.2267289457E+00, 2.9170947891E+01, 4.0541522289E+00, 9.8349288391E-01],
	[4.8860000000E+04, 4.7501618303E+01, 5.2267769494E+00, 2.9180686942E+01, 4.0544323882E+00, 9.8349918858E-01],
	[4.8865000000E+04, 4.7510295102E+01, 5.2268249487E+00, 2.9190428246E+01, 4.0547124831E+00, 9.8350549039E-01],
	[4.8870000000E+04, 4.7518972597E+01, 5.2268729436E+00, 2.9200171802E+01, 4.0549925133E+00, 9.8351178934E-01],
	[4.8875000000E+04, 4.7527650790E+01, 5.2269209339E+00, 2.9209917612E+01, 4.0552724790E+00, 9.8351808543E-01],
	[4.8880000000E+04, 4.7536329679E+01, 5.2269689198E+00, 2.9219665674E+01, 4.0555523802E+00, 9.8352437867E-01],
	[4.8885000000E+04, 4.7545009265E+01, 5.2270169012E+00, 2.9229415990E+01, 4.0558322169E+00, 9.8353066906E-01],
	[4.8890000000E+04, 4.7553689548E+01, 5.2270648782E+00, 2.9239168559E+01, 4.0561119891E+00, 9.8353695659E-01],
	[4.8895000000E+04, 4.7562370527E+01, 5.2271128507E+00, 2.9248923382E+01, 4.0563916969E+00, 9.8354324127E-01],
	[4.8900000000E+04, 4.7571052204E+01, 5.2271608187E+00, 2.9258680460E+01, 4.0566713401E+00, 9.8354952311E-01],
	[4.8905000000E+04, 4.7579734577E+01, 5.2272087823E+00, 2.9268439792E+01, 4.0569509190E+00, 9.8355580209E-01],
	[4.8910000000E+04, 4.7588417647E+01, 5.2272567414E+00, 2.9278201379E+01, 4.0572304334E+00, 9.8356207823E-01],
	[4.8915000000E+04, 4.7597101414E+01, 5.2273046960E+00, 2.9287965221E+01, 4.0575098834E+00, 9.8356835152E-01],
	[4.8920000000E+04, 4.7605785878E+01, 5.2273526462E+00, 2.9297731319E+01, 4.0577892691E+00, 9.8357462197E-01],
	[4.8925000000E+04, 4.7614471038E+01, 5.2274005919E+00, 2.9307499673E+01, 4.0580685903E+00, 9.8358088958E-01],
	[4.8930000000E+04, 4.7623156895E+01, 5.2274485332E+00, 2.9317270282E+01, 4.0583478472E+00, 9.8358715434E-01],
	[4.8935000000E+04, 4.7631843449E+01, 5.2274964699E+00, 2.9327043148E+01, 4.0586270398E+00, 9.8359341627E-01],
	[4.8940000000E+04, 4.7640530699E+01, 5.2275444023E+00, 2.9336818270E+01, 4.0589061681E+00, 9.8359967536E-01],
	[4.8945000000E+04, 4.7649218646E+01, 5.2275923302E+00, 2.9346595649E+01, 4.0591852320E+00, 9.8360593161E-01],
	[4.8950000000E+04, 4.7657907290E+01, 5.2276402536E+00, 2.9356375286E+01, 4.0594642317E+00, 9.8361218502E-01],
	[4.8955000000E+04, 4.7666596630E+01, 5.2276881725E+00, 2.9366157179E+01, 4.0597431671E+00, 9.8361843561E-01],
	[4.8960000000E+04, 4.7675286667E+01, 5.2277360871E+00, 2.9375941331E+01, 4.0600220383E+00, 9.8362468336E-01],
	[4.8965000000E+04, 4.7683977401E+01, 5.2277839971E+00, 2.9385727741E+01, 4.0603008452E+00, 9.8363092827E-01],
	[4.8970000000E+04, 4.7692668831E+01, 5.2278319027E+00, 2.9395516409E+01, 4.0605795879E+00, 9.8363717036E-01],
	[4.8975000000E+04, 4.7701360958E+01, 5.2278798039E+00, 2.9405307335E+01, 4.0608582664E+00, 9.8364340962E-01],
	[4.8980000000E+04, 4.7710053781E+01, 5.2279277006E+00, 2.9415100521E+01, 4.0611368807E+00, 9.8364964606E-01],
	[4.8985000000E+04, 4.7718747301E+01, 5.2279755928E+00, 2.9424895965E+01, 4.0614154309E+00, 9.8365587967E-01],
	[4.8990000000E+04, 4.7727441518E+01, 5.2280234806E+00, 2.9434693670E+01, 4.0616939169E+00, 9.8366211045E-01],
	[4.8995000000E+04, 4.7736136431E+01, 5.2280713640E+00, 2.9444493634E+01, 4.0619723388E+00, 9.8366833841E-01],
	[4.9000000000E+04, 4.7744832040E+01, 5.2281192429E+00, 2.9454295858E+01, 4.0622506966E+00, 9.8367456356E-01],
	[4.9005000000E+04, 4.7753528346E+01, 5.2281671173E+00, 2.9464100342E+01, 4.0625289903E+00, 9.8368078588E-01],
	[4.9010000000E+04, 4.7762225349E+01, 5.2282149874E+00, 2.9473907087E+01, 4.0628072198E+00, 9.8368700538E-01],
	[4.9015000000E+04, 4.7770923047E+01, 5.2282628529E+00, 2.9483716093E+01, 4.0630853854E+00, 9.8369322207E-01],
	[4.9020000000E+04, 4.7779621443E+01, 5.2283107140E+00, 2.9493527361E+01, 4.0633634869E+00, 9.8369943594E-01],
	[4.9025000000E+04, 4.7788320534E+01, 5.2283585707E+00, 2.9503340889E+01, 4.0636415243E+00, 9.8370564700E-01],
	[4.9030000000E+04, 4.7797020323E+01, 5.2284064230E+00, 2.9513156680E+01, 4.0639194978E+00, 9.8371185524E-01],
	[4.9035000000E+04, 4.7805720807E+01, 5.2284542708E+00, 2.9522974733E+01, 4.0641974072E+00, 9.8371806068E-01],
	[4.9040000000E+04, 4.7814421988E+01, 5.2285021141E+00, 2.9532795048E+01, 4.0644752527E+00, 9.8372426330E-01],
	[4.9045000000E+04, 4.7823123865E+01, 5.2285499530E+00, 2.9542617625E+01, 4.0647530342E+00, 9.8373046312E-01],
	[4.9050000000E+04, 4.7831826439E+01, 5.2285977875E+00, 2.9552442466E+01, 4.0650307518E+00, 9.8373666012E-01],
	[4.9055000000E+04, 4.7840529709E+01, 5.2286456175E+00, 2.9562269570E+01, 4.0653084054E+00, 9.8374285433E-01],
	[4.9060000000E+04, 4.7849233675E+01, 5.2286934431E+00, 2.9572098938E+01, 4.0655859952E+00, 9.8374904573E-01],
	[4.9065000000E+04, 4.7857938338E+01, 5.2287412643E+00, 2.9581930569E+01, 4.0658635210E+00, 9.8375523432E-01],
	[4.9070000000E+04, 4.7866651222E+01, 5.2287898633E+00, 2.9591764465E+01, 4.0661415103E+00, 9.8376142012E-01],
	[4.9075000000E+04, 4.7875373089E+01, 5.2288393189E+00, 2.9601600625E+01, 4.0664200165E+00, 9.8376760312E-01],
	[4.9080000000E+04, 4.7884095658E+01, 5.2288887700E+00, 2.9611439049E+01, 4.0666984589E+00, 9.8377378331E-01],
	[4.9085000000E+04, 4.7892818926E+01, 5.2289382165E+00, 2.9621279739E+01, 4.0669768377E+00, 9.8377996071E-01],
	[4.9090000000E+04, 4.7901542895E+01, 5.2289876585E+00, 2.9631122694E+01, 4.0672551527E+00, 9.8378613532E-01],
	[4.9095000000E+04, 4.7910267564E+01, 5.2290370959E+00, 2.9640967914E+01, 4.0675334041E+00, 9.8379230713E-01],
	[4.9100000000E+04, 4.7918992934E+01, 5.2290865287E+00, 2.9650815401E+01, 4.0678115919E+00, 9.8379847615E-01],
	[4.9105000000E+04, 4.7927719004E+01, 5.2291359569E+00, 2.9660665153E+01, 4.0680897160E+00, 9.8380464237E-01],
	[4.9110000000E+04, 4.7936445774E+01, 5.2291853806E+00, 2.9670517172E+01, 4.0683677765E+00, 9.8381080581E-01],
	[4.9115000000E+04, 4.7945173245E+01, 5.2292347997E+00, 2.9680371458E+01, 4.0686457734E+00, 9.8381696646E-01],
	[4.9120000000E+04, 4.7953901416E+01, 5.2292842143E+00, 2.9690228011E+01, 4.0689237068E+00, 9.8382312432E-01],
	[4.9125000000E+04, 4.7962630287E+01, 5.2293336243E+00, 2.9700086831E+01, 4.0692015766E+00, 9.8382927939E-01],
	[4.9130000000E+04, 4.7971359858E+01, 5.2293830297E+00, 2.9709947918E+01, 4.0694793828E+00, 9.8383543168E-01],
	[4.9135000000E+04, 4.7980090130E+01, 5.2294324306E+00, 2.9719811274E+01, 4.0697571255E+00, 9.8384158119E-01],
	[4.9140000000E+04, 4.7988821102E+01, 5.2294818269E+00, 2.9729676898E+01, 4.0700348047E+00, 9.8384772792E-01],
	[4.9145000000E+04, 4.7997552774E+01, 5.2295312186E+00, 2.9739544790E+01, 4.0703124204E+00, 9.8385387186E-01],
	[4.9150000000E+04, 4.8006285146E+01, 5.2295806058E+00, 2.9749414951E+01, 4.0705899727E+00, 9.8386001303E-01],
	[4.9155000000E+04, 4.8015018218E+01, 5.2296299885E+00, 2.9759287381E+01, 4.0708674614E+00, 9.8386615142E-01],
	[4.9160000000E+04, 4.8023751991E+01, 5.2296793665E+00, 2.9769162080E+01, 4.0711448868E+00, 9.8387228704E-01],
	[4.9165000000E+04, 4.8032486464E+01, 5.2297287401E+00, 2.9779039050E+01, 4.0714222487E+00, 9.8387841988E-01],
	[4.9170000000E+04, 4.8041221636E+01, 5.2297781090E+00, 2.9788918289E+01, 4.0716995472E+00, 9.8388454994E-01],
	[4.9175000000E+04, 4.8049957509E+01, 5.2298274734E+00, 2.9798799798E+01, 4.0719767823E+00, 9.8389067724E-01],
	[4.9180000000E+04, 4.8058694082E+01, 5.2298768333E+00, 2.9808683577E+01, 4.0722539540E+00, 9.8389680176E-01],
	[4.9185000000E+04, 4.8067431356E+01, 5.2299261886E+00, 2.9818569628E+01, 4.0725310624E+00, 9.8390292352E-01],
	[4.9190000000E+04, 4.8076169329E+01, 5.2299755394E+00, 2.9828457950E+01, 4.0728081074E+00, 9.8390904251E-01],
	[4.9195000000E+04, 4.8084908002E+01, 5.2300248856E+00, 2.9838348543E+01, 4.0730850891E+00, 9.8391515873E-01],
	[4.9200000000E+04, 4.8093647375E+01, 5.2300742272E+00, 2.9848241407E+01, 4.0733620075E+00, 9.8392127219E-01],
	[4.9205000000E+04, 4.8102387449E+01, 5.2301235643E+00, 2.9858136544E+01, 4.0736388626E+00, 9.8392738288E-01],
	[4.9210000000E+04, 4.8111128222E+01, 5.2301728969E+00, 2.9868033953E+01, 4.0739156544E+00, 9.8393349082E-01],
	[4.9215000000E+04, 4.8119869695E+01, 5.2302222249E+00, 2.9877933634E+01, 4.0741923830E+00, 9.8393959599E-01],
	[4.9220000000E+04, 4.8128611869E+01, 5.2302715484E+00, 2.9887835588E+01, 4.0744690483E+00, 9.8394569840E-01],
	[4.9225000000E+04, 4.8137354742E+01, 5.2303208673E+00, 2.9897739816E+01, 4.0747456504E+00, 9.8395179806E-01],
	[4.9230000000E+04, 4.8146098315E+01, 5.2303701817E+00, 2.9907646316E+01, 4.0750221893E+00, 9.8395789496E-01],
	[4.9235000000E+04, 4.8154842588E+01, 5.2304194915E+00, 2.9917555091E+01, 4.0752986651E+00, 9.8396398910E-01],
	[4.9240000000E+04, 4.8163587562E+01, 5.2304687968E+00, 2.9927466139E+01, 4.0755750776E+00, 9.8397008049E-01],
	[4.9245000000E+04, 4.8172333235E+01, 5.2305180975E+00, 2.9937379462E+01, 4.0758514270E+00, 9.8397616913E-01],
	[4.9250000000E+04, 4.8181079607E+01, 5.2305673937E+00, 2.9947295059E+01, 4.0761277132E+00, 9.8398225502E-01],
	[4.9255000000E+04, 4.8189826680E+01, 5.2306166854E+00, 2.9957212931E+01, 4.0764039363E+00, 9.8398833816E-01],
	[4.9260000000E+04, 4.8198574453E+01, 5.2306659725E+00, 2.9967133079E+01, 4.0766800963E+00, 9.8399441855E-01],
	[4.9265000000E+04, 4.8207322925E+01, 5.2307152551E+00, 2.9977055502E+01, 4.0769561932E+00, 9.8400049620E-01],
	[4.9270000000E+04, 4.8216072098E+01, 5.2307645332E+00, 2.9986980200E+01, 4.0772322271E+00, 9.8400657110E-01],
	[4.9275000000E+04, 4.8224821970E+01, 5.2308138067E+00, 2.9996907175E+01, 4.0775081979E+00, 9.8401264325E-01],
	[4.9280000000E+04, 4.8233572542E+01, 5.2308630757E+00, 3.0006836425E+01, 4.0777841056E+00, 9.8401871267E-01],
	[4.9285000000E+04, 4.8242323813E+01, 5.2309123401E+00, 3.0016767953E+01, 4.0780599503E+00, 9.8402477934E-01],
	[4.9290000000E+04, 4.8251075785E+01, 5.2309616000E+00, 3.0026701757E+01, 4.0783357320E+00, 9.8403084327E-01],
	[4.9295000000E+04, 4.8259828456E+01, 5.2310108554E+00, 3.0036637838E+01, 4.0786114508E+00, 9.8403690447E-01],
	[4.9300000000E+04, 4.8268581827E+01, 5.2310601063E+00, 3.0046576197E+01, 4.0788871065E+00, 9.8404296292E-01],
	[4.9305000000E+04, 4.8277335898E+01, 5.2311093526E+00, 3.0056516834E+01, 4.0791626993E+00, 9.8404901865E-01],
	[4.9310000000E+04, 4.8286090668E+01, 5.2311585944E+00, 3.0066459749E+01, 4.0794382292E+00, 9.8405507164E-01],
	[4.9315000000E+04, 4.8294846138E+01, 5.2312078316E+00, 3.0076404942E+01, 4.0797136961E+00, 9.8406112189E-01],
	[4.9320000000E+04, 4.8303602308E+01, 5.2312570643E+00, 3.0086352414E+01, 4.0799891001E+00, 9.8406716942E-01],
	[4.9325000000E+04, 4.8312359177E+01, 5.2313062926E+00, 3.0096302164E+01, 4.0802644413E+00, 9.8407321421E-01],
	[4.9330000000E+04, 4.8321116747E+01, 5.2313555162E+00, 3.0106254194E+01, 4.0805397195E+00, 9.8407925628E-01],
	[4.9335000000E+04, 4.8329875015E+01, 5.2314047354E+00, 3.0116208504E+01, 4.0808149349E+00, 9.8408529562E-01],
	[4.9340000000E+04, 4.8338633984E+01, 5.2314539500E+00, 3.0126165093E+01, 4.0810900875E+00, 9.8409133224E-01],
	[4.9345000000E+04, 4.8347393652E+01, 5.2315031601E+00, 3.0136123962E+01, 4.0813651773E+00, 9.8409736613E-01],
	[4.9350000000E+04, 4.8356154019E+01, 5.2315523657E+00, 3.0146085112E+01, 4.0816402042E+00, 9.8410339729E-01],
	[4.9355000000E+04, 4.8364915086E+01, 5.2316015667E+00, 3.0156048542E+01, 4.0819151683E+00, 9.8410942574E-01],
	[4.9360000000E+04, 4.8373676853E+01, 5.2316507633E+00, 3.0166014253E+01, 4.0821900697E+00, 9.8411545147E-01],
	[4.9365000000E+04, 4.8382439319E+01, 5.2316999553E+00, 3.0175982246E+01, 4.0824649083E+00, 9.8412147447E-01],
	[4.9370000000E+04, 4.8391202485E+01, 5.2317491428E+00, 3.0185952520E+01, 4.0827396842E+00, 9.8412749476E-01],
	[4.9375000000E+04, 4.8399966350E+01, 5.2317983257E+00, 3.0195925076E+01, 4.0830143974E+00, 9.8413351234E-01],
	[4.9380000000E+04, 4.8408730915E+01, 5.2318475042E+00, 3.0205899914E+01, 4.0832890478E+00, 9.8413952720E-01],
	[4.9385000000E+04, 4.8417496179E+01, 5.2318966781E+00, 3.0215877034E+01, 4.0835636356E+00, 9.8414553934E-01],
	[4.9390000000E+04, 4.8426262143E+01, 5.2319458476E+00, 3.0225856437E+01, 4.0838381607E+00, 9.8415154878E-01],
	[4.9395000000E+04, 4.8435028806E+01, 5.2319950125E+00, 3.0235838123E+01, 4.0841126231E+00, 9.8415755550E-01],
	[4.9400000000E+04, 4.8443796169E+01, 5.2320441728E+00, 3.0245822092E+01, 4.0843870229E+00, 9.8416355952E-01],
	[4.9405000000E+04, 4.8452564231E+01, 5.2320933287E+00, 3.0255808345E+01, 4.0846613601E+00, 9.8416956083E-01],
	[4.9410000000E+04, 4.8461332992E+01, 5.2321424801E+00, 3.0265796882E+01, 4.0849356347E+00, 9.8417555943E-01],
	[4.9415000000E+04, 4.8470102453E+01, 5.2321916269E+00, 3.0275787703E+01, 4.0852098467E+00, 9.8418155532E-01],
	[4.9420000000E+04, 4.8478872613E+01, 5.2322407693E+00, 3.0285780808E+01, 4.0854839961E+00, 9.8418754852E-01],
	[4.9425000000E+04, 4.8487643473E+01, 5.2322899071E+00, 3.0295776198E+01, 4.0857580829E+00, 9.8419353901E-01],
	[4.9430000000E+04, 4.8496415032E+01, 5.2323390404E+00, 3.0305773873E+01, 4.0860321072E+00, 9.8419952680E-01],
	[4.9435000000E+04, 4.8505187290E+01, 5.2323881693E+00, 3.0315773834E+01, 4.0863060690E+00, 9.8420551189E-01],
	[4.9440000000E+04, 4.8513960248E+01, 5.2324372936E+00, 3.0325776080E+01, 4.0865799683E+00, 9.8421149428E-01],
	[4.9445000000E+04, 4.8522733904E+01, 5.2324864134E+00, 3.0335780612E+01, 4.0868538051E+00, 9.8421747398E-01],
	[4.9450000000E+04, 4.8531508261E+01, 5.2325355287E+00, 3.0345787430E+01, 4.0871275794E+00, 9.8422345098E-01],
	[4.9455000000E+04, 4.8540283316E+01, 5.2325846395E+00, 3.0355796534E+01, 4.0874012913E+00, 9.8422942529E-01],
	[4.9460000000E+04, 4.8549059071E+01, 5.2326337457E+00, 3.0365807925E+01, 4.0876749407E+00, 9.8423539690E-01],
	[4.9465000000E+04, 4.8557835525E+01, 5.2326828475E+00, 3.0375821604E+01, 4.0879485277E+00, 9.8424136582E-01],
	[4.9470000000E+04, 4.8566612678E+01, 5.2327319448E+00, 3.0385837569E+01, 4.0882220523E+00, 9.8424733206E-01],
	[4.9475000000E+04, 4.8575390530E+01, 5.2327810376E+00, 3.0395855823E+01, 4.0884955145E+00, 9.8425329560E-01],
	[4.9480000000E+04, 4.8584169082E+01, 5.2328301259E+00, 3.0405876364E+01, 4.0887689143E+00, 9.8425925646E-01],
	[4.9485000000E+04, 4.8592948333E+01, 5.2328792096E+00, 3.0415899194E+01, 4.0890422518E+00, 9.8426521464E-01],
	[4.9490000000E+04, 4.8601728283E+01, 5.2329282889E+00, 3.0425924311E+01, 4.0893155269E+00, 9.8427117012E-01],
	[4.9495000000E+04, 4.8610508932E+01, 5.2329773637E+00, 3.0435951718E+01, 4.0895887397E+00, 9.8427712293E-01],
	[4.9500000000E+04, 4.8619290280E+01, 5.2330264340E+00, 3.0445981414E+01, 4.0898618902E+00, 9.8428307306E-01],
	[4.9505000000E+04, 4.8628072327E+01, 5.2330754998E+00, 3.0456013399E+01, 4.0901349785E+00, 9.8428902050E-01],
	[4.9510000000E+04, 4.8636855074E+01, 5.2331245611E+00, 3.0466047674E+01, 4.0904080044E+00, 9.8429496527E-01],
	[4.9515000000E+04, 4.8645638519E+01, 5.2331736179E+00, 3.0476084239E+01, 4.0906809681E+00, 9.8430090735E-01],
	[4.9520000000E+04, 4.8654422664E+01, 5.2332226702E+00, 3.0486123094E+01, 4.0909538695E+00, 9.8430684677E-01],
	[4.9525000000E+04, 4.8663207508E+01, 5.2332717180E+00, 3.0496164240E+01, 4.0912267087E+00, 9.8431278350E-01],
	[4.9530000000E+04, 4.8671993051E+01, 5.2333207613E+00, 3.0506207676E+01, 4.0914994858E+00, 9.8431871757E-01],
	[4.9535000000E+04, 4.8680779292E+01, 5.2333698001E+00, 3.0516253404E+01, 4.0917722006E+00, 9.8432464896E-01],
	[4.9540000000E+04, 4.8689566233E+01, 5.2334188345E+00, 3.0526301423E+01, 4.0920448532E+00, 9.8433057768E-01],
	[4.9545000000E+04, 4.8698353873E+01, 5.2334678643E+00, 3.0536351733E+01, 4.0923174437E+00, 9.8433650374E-01],
	[4.9550000000E+04, 4.8707142212E+01, 5.2335168897E+00, 3.0546404336E+01, 4.0925899721E+00, 9.8434242712E-01],
	[4.9555000000E+04, 4.8715931250E+01, 5.2335659105E+00, 3.0556459231E+01, 4.0928624383E+00, 9.8434834784E-01],
	[4.9560000000E+04, 4.8724720986E+01, 5.2336149269E+00, 3.0566516418E+01, 4.0931348424E+00, 9.8435426589E-01],
	[4.9565000000E+04, 4.8733511422E+01, 5.2336639388E+00, 3.0576575899E+01, 4.0934071844E+00, 9.8436018128E-01],
	[4.9570000000E+04, 4.8742302557E+01, 5.2337129462E+00, 3.0586637672E+01, 4.0936794644E+00, 9.8436609401E-01],
	[4.9575000000E+04, 4.8751094390E+01, 5.2337619492E+00, 3.0596701739E+01, 4.0939516823E+00, 9.8437200408E-01],
	[4.9580000000E+04, 4.8759886923E+01, 5.2338109476E+00, 3.0606768100E+01, 4.0942238381E+00, 9.8437791148E-01],
	[4.9585000000E+04, 4.8768680154E+01, 5.2338599416E+00, 3.0616836755E+01, 4.0944959320E+00, 9.8438381623E-01],
	[4.9590000000E+04, 4.8777474084E+01, 5.2339089311E+00, 3.0626907704E+01, 4.0947679638E+00, 9.8438971833E-01],
	[4.9595000000E+04, 4.8786268713E+01, 5.2339579161E+00, 3.0636980948E+01, 4.0950399336E+00, 9.8439561776E-01],
	[4.9600000000E+04, 4.8795064041E+01, 5.2340068966E+00, 3.0647056486E+01, 4.0953118415E+00, 9.8440151454E-01],
	[4.9605000000E+04, 4.8803860068E+01, 5.2340558726E+00, 3.0657134320E+01, 4.0955836873E+00, 9.8440740867E-01],
	[4.9610000000E+04, 4.8812656794E+01, 5.2341048442E+00, 3.0667214449E+01, 4.0958554713E+00, 9.8441330015E-01],
	[4.9615000000E+04, 4.8821454218E+01, 5.2341538113E+00, 3.0677296874E+01, 4.0961271933E+00, 9.8441918898E-01],
	[4.9620000000E+04, 4.8830252341E+01, 5.2342027739E+00, 3.0687381595E+01, 4.0963988534E+00, 9.8442507516E-01],
	[4.9625000000E+04, 4.8839051163E+01, 5.2342517320E+00, 3.0697468612E+01, 4.0966704517E+00, 9.8443095869E-01],
	[4.9630000000E+04, 4.8847850684E+01, 5.2343006857E+00, 3.0707557926E+01, 4.0969419880E+00, 9.8443683958E-01],
	[4.9635000000E+04, 4.8856650903E+01, 5.2343496349E+00, 3.0717649537E+01, 4.0972134625E+00, 9.8444271782E-01],
	[4.9640000000E+04, 4.8865451821E+01, 5.2343985796E+00, 3.0727743446E+01, 4.0974848751E+00, 9.8444859342E-01],
	[4.9645000000E+04, 4.8874253438E+01, 5.2344475198E+00, 3.0737839651E+01, 4.0977562259E+00, 9.8445446637E-01],
	[4.9650000000E+04, 4.8883055753E+01, 5.2344964556E+00, 3.0747938155E+01, 4.0980275149E+00, 9.8446033669E-01],
	[4.9655000000E+04, 4.8891858767E+01, 5.2345453869E+00, 3.0758038956E+01, 4.0982987422E+00, 9.8446620436E-01],
	[4.9660000000E+04, 4.8900662480E+01, 5.2345943138E+00, 3.0768142056E+01, 4.0985699076E+00, 9.8447206940E-01],
	[4.9665000000E+04, 4.8909466892E+01, 5.2346432361E+00, 3.0778247455E+01, 4.0988410113E+00, 9.8447793181E-01],
	[4.9670000000E+04, 4.8918272002E+01, 5.2346921540E+00, 3.0788355153E+01, 4.0991120532E+00, 9.8448379157E-01],
	[4.9675000000E+04, 4.8927077811E+01, 5.2347410674E+00, 3.0798465149E+01, 4.0993830334E+00, 9.8448964871E-01],
	[4.9680000000E+04, 4.8935884318E+01, 5.2347899764E+00, 3.0808577446E+01, 4.0996539519E+00, 9.8449550321E-01],
	[4.9685000000E+04, 4.8944691524E+01, 5.2348388809E+00, 3.0818692042E+01, 4.0999248087E+00, 9.8450135508E-01],
	[4.9690000000E+04, 4.8953499428E+01, 5.2348877809E+00, 3.0828808939E+01, 4.1001956038E+00, 9.8450720432E-01],
	[4.9695000000E+04, 4.8962308031E+01, 5.2349366765E+00, 3.0838928135E+01, 4.1004663372E+00, 9.8451305093E-01],
	[4.9700000000E+04, 4.8971117333E+01, 5.2349855676E+00, 3.0849049633E+01, 4.1007370090E+00, 9.8451889491E-01],
	[4.9705000000E+04, 4.8979927333E+01, 5.2350344542E+00, 3.0859173431E+01, 4.1010076192E+00, 9.8452473627E-01],
	[4.9710000000E+04, 4.8988738032E+01, 5.2350833364E+00, 3.0869299531E+01, 4.1012781678E+00, 9.8453057501E-01],
	[4.9715000000E+04, 4.8997549429E+01, 5.2351322142E+00, 3.0879427933E+01, 4.1015486548E+00, 9.8453641112E-01],
	[4.9720000000E+04, 4.9006361524E+01, 5.2351810874E+00, 3.0889558636E+01, 4.1018190802E+00, 9.8454224461E-01],
	[4.9725000000E+04, 4.9015174319E+01, 5.2352299562E+00, 3.0899691641E+01, 4.1020894440E+00, 9.8454807548E-01],
	[4.9730000000E+04, 4.9023987811E+01, 5.2352788206E+00, 3.0909826949E+01, 4.1023597463E+00, 9.8455390373E-01],
	[4.9735000000E+04, 4.9032802002E+01, 5.2353276805E+00, 3.0919964560E+01, 4.1026299870E+00, 9.8455972936E-01],
	[4.9740000000E+04, 4.9041616891E+01, 5.2353765359E+00, 3.0930104473E+01, 4.1029001663E+00, 9.8456555238E-01],
	[4.9745000000E+04, 4.9050432479E+01, 5.2354253869E+00, 3.0940246690E+01, 4.1031702840E+00, 9.8457137278E-01],
	[4.9750000000E+04, 4.9059248765E+01, 5.2354742334E+00, 3.0950391211E+01, 4.1034403403E+00, 9.8457719057E-01],
	[4.9755000000E+04, 4.9068065750E+01, 5.2355230755E+00, 3.0960538036E+01, 4.1037103350E+00, 9.8458300574E-01],
	[4.9760000000E+04, 4.9076883433E+01, 5.2355719131E+00, 3.0970687164E+01, 4.1039802684E+00, 9.8458881831E-01],
	[4.9765000000E+04, 4.9085701814E+01, 5.2356207463E+00, 3.0980838598E+01, 4.1042501403E+00, 9.8459462827E-01],
	[4.9770000000E+04, 4.9094520894E+01, 5.2356695750E+00, 3.0990992336E+01, 4.1045199508E+00, 9.8460043561E-01],
	[4.9775000000E+04, 4.9103340672E+01, 5.2357183993E+00, 3.1001148379E+01, 4.1047896999E+00, 9.8460624035E-01],
	[4.9780000000E+04, 4.9112161148E+01, 5.2357672191E+00, 3.1011306727E+01, 4.1050593876E+00, 9.8461204249E-01],
	[4.9785000000E+04, 4.9120982323E+01, 5.2358160344E+00, 3.1021467381E+01, 4.1053290140E+00, 9.8461784202E-01],
	[4.9790000000E+04, 4.9129804195E+01, 5.2358648454E+00, 3.1031630341E+01, 4.1055985790E+00, 9.8462363895E-01],
	[4.9795000000E+04, 4.9138626767E+01, 5.2359136518E+00, 3.1041795607E+01, 4.1058680827E+00, 9.8462943328E-01],
	[4.9800000000E+04, 4.9147450036E+01, 5.2359624539E+00, 3.1051963180E+01, 4.1061375250E+00, 9.8463522500E-01],
	[4.9805000000E+04, 4.9156274003E+01, 5.2360112515E+00, 3.1062133060E+01, 4.1064069061E+00, 9.8464101413E-01],
	[4.9810000000E+04, 4.9165098669E+01, 5.2360600446E+00, 3.1072305247E+01, 4.1066762258E+00, 9.8464680066E-01],
	[4.9815000000E+04, 4.9173924033E+01, 5.2361088333E+00, 3.1082479741E+01, 4.1069454843E+00, 9.8465258460E-01],
	[4.9820000000E+04, 4.9182750095E+01, 5.2361576176E+00, 3.1092656543E+01, 4.1072146816E+00, 9.8465836594E-01],
	[4.9825000000E+04, 4.9191576856E+01, 5.2362063974E+00, 3.1102835652E+01, 4.1074838176E+00, 9.8466414469E-01],
	[4.9830000000E+04, 4.9200404314E+01, 5.2362551728E+00, 3.1113017070E+01, 4.1077528924E+00, 9.8466992084E-01],
	[4.9835000000E+04, 4.9209232471E+01, 5.2363039437E+00, 3.1123200797E+01, 4.1080219060E+00, 9.8467569440E-01],
	[4.9840000000E+04, 4.9218061325E+01, 5.2363527102E+00, 3.1133386833E+01, 4.1082908584E+00, 9.8468146538E-01],
	[4.9845000000E+04, 4.9226890878E+01, 5.2364014723E+00, 3.1143575177E+01, 4.1085597496E+00, 9.8468723377E-01],
	[4.9850000000E+04, 4.9235721129E+01, 5.2364502299E+00, 3.1153765831E+01, 4.1088285797E+00, 9.8469299956E-01],
	[4.9855000000E+04, 4.9244552078E+01, 5.2364989831E+00, 3.1163958795E+01, 4.1090973487E+00, 9.8469876278E-01],
	[4.9860000000E+04, 4.9253391491E+01, 5.2365485228E+00, 3.1174154069E+01, 4.1093665976E+00, 9.8470452341E-01],
	[4.9865000000E+04, 4.9262239637E+01, 5.2365988759E+00, 3.1184351653E+01, 4.1096363452E+00, 9.8471028146E-01],
	[4.9870000000E+04, 4.9271088485E+01, 5.2366492245E+00, 3.1194551548E+01, 4.1099060319E+00, 9.8471603692E-01],
	[4.9875000000E+04, 4.9279938035E+01, 5.2366995685E+00, 3.1204753753E+01, 4.1101756576E+00, 9.8472178981E-01],
	[4.9880000000E+04, 4.9288788286E+01, 5.2367499079E+00, 3.1214958270E+01, 4.1104452223E+00, 9.8472754012E-01],
	[4.9885000000E+04, 4.9297639240E+01, 5.2368002428E+00, 3.1225165099E+01, 4.1107147261E+00, 9.8473328785E-01],
	[4.9890000000E+04, 4.9306490897E+01, 5.2368505732E+00, 3.1235374239E+01, 4.1109841691E+00, 9.8473903300E-01],
	[4.9895000000E+04, 4.9315343255E+01, 5.2369008989E+00, 3.1245585691E+01, 4.1112535511E+00, 9.8474477558E-01],
	[4.9900000000E+04, 4.9324196315E+01, 5.2369512201E+00, 3.1255799455E+01, 4.1115228723E+00, 9.8475051559E-01],
	[4.9905000000E+04, 4.9333050077E+01, 5.2370015368E+00, 3.1266015532E+01, 4.1117921326E+00, 9.8475625302E-01],
	[4.9910000000E+04, 4.9341904541E+01, 5.2370518489E+00, 3.1276233922E+01, 4.1120613321E+00, 9.8476198788E-01],
	[4.9915000000E+04, 4.9350759707E+01, 5.2371021564E+00, 3.1286454626E+01, 4.1123304707E+00, 9.8476772018E-01],
	[4.9920000000E+04, 4.9359615575E+01, 5.2371524594E+00, 3.1296677642E+01, 4.1125995486E+00, 9.8477344990E-01],
	[4.9925000000E+04, 4.9368472146E+01, 5.2372027578E+00, 3.1306902973E+01, 4.1128685657E+00, 9.8477917706E-01],
	[4.9930000000E+04, 4.9377329418E+01, 5.2372530517E+00, 3.1317130617E+01, 4.1131375220E+00, 9.8478490165E-01],
	[4.9935000000E+04, 4.9386187392E+01, 5.2373033410E+00, 3.1327360577E+01, 4.1134064175E+00, 9.8479062368E-01],
	[4.9940000000E+04, 4.9395046068E+01, 5.2373536258E+00, 3.1337592850E+01, 4.1136752523E+00, 9.8479634315E-01],
	[4.9945000000E+04, 4.9403905445E+01, 5.2374039060E+00, 3.1347827439E+01, 4.1139440264E+00, 9.8480206005E-01],
	[4.9950000000E+04, 4.9412765525E+01, 5.2374541817E+00, 3.1358064343E+01, 4.1142127397E+00, 9.8480777440E-01],
	[4.9955000000E+04, 4.9421626307E+01, 5.2375044528E+00, 3.1368303562E+01, 4.1144813924E+00, 9.8481348619E-01],
	[4.9960000000E+04, 4.9430487790E+01, 5.2375547194E+00, 3.1378545098E+01, 4.1147499844E+00, 9.8481919541E-01],
	[4.9965000000E+04, 4.9439349975E+01, 5.2376049814E+00, 3.1388788949E+01, 4.1150185157E+00, 9.8482490209E-01],
	[4.9970000000E+04, 4.9448212863E+01, 5.2376552388E+00, 3.1399035117E+01, 4.1152869864E+00, 9.8483060620E-01],
	[4.9975000000E+04, 4.9457076451E+01, 5.2377054918E+00, 3.1409283602E+01, 4.1155553965E+00, 9.8483630777E-01],
	[4.9980000000E+04, 4.9465940742E+01, 5.2377557401E+00, 3.1419534403E+01, 4.1158237460E+00, 9.8484200678E-01],
	[4.9985000000E+04, 4.9474805735E+01, 5.2378059840E+00, 3.1429787522E+01, 4.1160920348E+00, 9.8484770324E-01],
	[4.9990000000E+04, 4.9483671429E+01, 5.2378562233E+00, 3.1440042959E+01, 4.1163602631E+00, 9.8485339715E-01],
	[4.9995000000E+04, 4.9492537825E+01, 5.2379064580E+00, 3.1450300713E+01, 4.1166284308E+00, 9.8485908852E-01],
	[5.0000000000E+04, 4.9501404923E+01, 5.2379566882E+00, 3.1460560786E+01, 4.1168965380E+00, 9.8486477733E-01],
	[5.0005000000E+04, 4.9510272722E+01, 5.2380069139E+00, 3.1470837436E+01, 4.1171648287E+00, 9.8487046360E-01],
	[5.0010000000E+04, 4.9519141224E+01, 5.2380571350E+00, 3.1481116413E+01, 4.1174330588E+00, 9.8487614733E-01],
	[5.0015000000E+04, 4.9528010427E+01, 5.2381073516E+00, 3.1491397717E+01, 4.1177012282E+00, 9.8488182852E-01],
	[5.0020000000E+04, 4.9536880331E+01, 5.2381575636E+00, 3.1501681349E+01, 4.1179693371E+00, 9.8488750716E-01],
	[5.0025000000E+04, 4.9545750937E+