import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

PMMA_MFP = np.array([
	[5.0000000000E+03, 1.9979067767E+00, 7.1663999988E+00, 3.2009224338E-02, 3.1366587269E-02, 3.4013211844E-01],
	[5.0050000000E+03, 2.0001900421E+00, 7.1622973195E+00, 3.2107716558E-02, 3.1461644991E-02, 3.4038562283E-01],
	[5.0100000000E+03, 2.0024736332E+00, 7.1582010819E+00, 3.2206412958E-02, 3.1556891746E-02, 3.4063890912E-01],
	[5.0150000000E+03, 2.0047575496E+00, 7.1541112696E+00, 3.2305313757E-02, 3.1652327701E-02, 3.4089197782E-01],
	[5.0200000000E+03, 2.0070417910E+00, 7.1500278660E+00, 3.2404419173E-02, 3.1747953021E-02, 3.4114482945E-01],
	[5.0250000000E+03, 2.0093263573E+00, 7.1459508548E+00, 3.2503729424E-02, 3.1843767871E-02, 3.4139746468E-01],
	[5.0300000000E+03, 2.0116112480E+00, 7.1418802195E+00, 3.2603244730E-02, 3.1939772417E-02, 3.4164988417E-01],
	[5.0350000000E+03, 2.0138964630E+00, 7.1378159440E+00, 3.2702965310E-02, 3.2035966823E-02, 3.4190208858E-01],
	[5.0400000000E+03, 2.0161820020E+00, 7.1337580119E+00, 3.2802891381E-02, 3.2132351255E-02, 3.4215407856E-01],
	[5.0450000000E+03, 2.0184678647E+00, 7.1297064071E+00, 3.2903023162E-02, 3.2228925877E-02, 3.4240585477E-01],
	[5.0500000000E+03, 2.0207540507E+00, 7.1256611135E+00, 3.3003360873E-02, 3.2325690854E-02, 3.4265741786E-01],
	[5.0550000000E+03, 2.0230405599E+00, 7.1216221150E+00, 3.3103904731E-02, 3.2422646352E-02, 3.4290876848E-01],
	[5.0600000000E+03, 2.0253273920E+00, 7.1175893955E+00, 3.3204654957E-02, 3.2519792534E-02, 3.4315990728E-01],
	[5.0650000000E+03, 2.0276145467E+00, 7.1135629392E+00, 3.3305611768E-02, 3.2617129564E-02, 3.4341083490E-01],
	[5.0700000000E+03, 2.0299020236E+00, 7.1095427302E+00, 3.3406775383E-02, 3.2714657608E-02, 3.4366155199E-01],
	[5.0750000000E+03, 2.0321898227E+00, 7.1055287525E+00, 3.3508146022E-02, 3.2812376829E-02, 3.4391205918E-01],
	[5.0800000000E+03, 2.0344779435E+00, 7.1015209905E+00, 3.3609723902E-02, 3.2910287391E-02, 3.4416235711E-01],
	[5.0850000000E+03, 2.0367768731E+00, 7.0975842145E+00, 3.3711509243E-02, 3.3008393614E-02, 3.4441244643E-01],
	[5.0900000000E+03, 2.0390771558E+00, 7.0936597688E+00, 3.3813502264E-02, 3.3106691952E-02, 3.4466232776E-01],
	[5.0950000000E+03, 2.0413777741E+00, 7.0897413430E+00, 3.3915703183E-02, 3.3205182167E-02, 3.4491200173E-01],
	[5.1000000000E+03, 2.0436787276E+00, 7.0858289219E+00, 3.4018112220E-02, 3.3303864423E-02, 3.4516146899E-01],
	[5.1050000000E+03, 2.0459800162E+00, 7.0819224906E+00, 3.4120729592E-02, 3.3402738885E-02, 3.4541073014E-01],
	[5.1100000000E+03, 2.0482816395E+00, 7.0780220339E+00, 3.4223555520E-02, 3.3501805714E-02, 3.4565978582E-01],
	[5.1150000000E+03, 2.0505835972E+00, 7.0741275370E+00, 3.4326590223E-02, 3.3601065076E-02, 3.4590863666E-01],
	[5.1200000000E+03, 2.0528858890E+00, 7.0702389848E+00, 3.4429833918E-02, 3.3700517132E-02, 3.4615728327E-01],
	[5.1250000000E+03, 2.0551885147E+00, 7.0663563625E+00, 3.4533286825E-02, 3.3800162047E-02, 3.4640572627E-01],
	[5.1300000000E+03, 2.0574914741E+00, 7.0624796553E+00, 3.4636949163E-02, 3.3899999983E-02, 3.4665396628E-01],
	[5.1350000000E+03, 2.0597947667E+00, 7.0586088485E+00, 3.4740821150E-02, 3.4000031103E-02, 3.4690200392E-01],
	[5.1400000000E+03, 2.0620983924E+00, 7.0547439273E+00, 3.4844903007E-02, 3.4100255570E-02, 3.4714983979E-01],
	[5.1450000000E+03, 2.0644023509E+00, 7.0508848771E+00, 3.4949194952E-02, 3.4200673546E-02, 3.4739747451E-01],
	[5.1500000000E+03, 2.0667066419E+00, 7.0470316832E+00, 3.5053697204E-02, 3.4301285194E-02, 3.4764490869E-01],
	[5.1550000000E+03, 2.0690112651E+00, 7.0431843311E+00, 3.5158409981E-02, 3.4402090676E-02, 3.4789214293E-01],
	[5.1600000000E+03, 2.0713162202E+00, 7.0393428063E+00, 3.5263333504E-02, 3.4503090155E-02, 3.4813917784E-01],
	[5.1650000000E+03, 2.0736276510E+00, 7.0355448686E+00, 3.5368467991E-02, 3.4604286417E-02, 3.4838601403E-01],
	[5.1700000000E+03, 2.0759443727E+00, 7.0317830459E+00, 3.5473813661E-02, 3.4705679150E-02, 3.4863265208E-01],
	[5.1750000000E+03, 2.0782614395E+00, 7.0280268680E+00, 3.5579370733E-02, 3.4807266411E-02, 3.4887909261E-01],
	[5.1800000000E+03, 2.0805788511E+00, 7.0242763211E+00, 3.5685139427E-02, 3.4909048363E-02, 3.4912533621E-01],
	[5.1850000000E+03, 2.0828966072E+00, 7.0205313912E+00, 3.5791119961E-02, 3.5011025167E-02, 3.4937138347E-01],
	[5.1900000000E+03, 2.0852147076E+00, 7.0167920646E+00, 3.5897312555E-02, 3.5113196985E-02, 3.4961723498E-01],
	[5.1950000000E+03, 2.0875331520E+00, 7.0130583275E+00, 3.6003717427E-02, 3.5215563979E-02, 3.4986289135E-01],
	[5.2000000000E+03, 2.0898519401E+00, 7.0093301662E+00, 3.6110334798E-02, 3.5318126310E-02, 3.5010835315E-01],
	[5.2050000000E+03, 2.0921710716E+00, 7.0056075669E+00, 3.6217164886E-02, 3.5420884140E-02, 3.5035362097E-01],
	[5.2100000000E+03, 2.0944905462E+00, 7.0018905161E+00, 3.6324207910E-02, 3.5523837629E-02, 3.5059869541E-01],
	[5.2150000000E+03, 2.0968103637E+00, 6.9981790003E+00, 3.6431464090E-02, 3.5626986939E-02, 3.5084357704E-01],
	[5.2200000000E+03, 2.0991305237E+00, 6.9944730057E+00, 3.6538933645E-02, 3.5730332231E-02, 3.5108826645E-01],
	[5.2250000000E+03, 2.1014510261E+00, 6.9907725190E+00, 3.6646616794E-02, 3.5833873665E-02, 3.5133276421E-01],
	[5.2300000000E+03, 2.1037718705E+00, 6.9870775267E+00, 3.6754513756E-02, 3.5937611403E-02, 3.5157707090E-01],
	[5.2350000000E+03, 2.1060930566E+00, 6.9833880154E+00, 3.6862624751E-02, 3.6041545604E-02, 3.5182118710E-01],
	[5.2400000000E+03, 2.1084145842E+00, 6.9797039718E+00, 3.6970949998E-02, 3.6145676430E-02, 3.5206511339E-01],
	[5.2450000000E+03, 2.1107364530E+00, 6.9760253825E+00, 3.7079489716E-02, 3.6250004040E-02, 3.5230885033E-01],
	[5.2500000000E+03, 2.1130686299E+00, 6.9724132300E+00, 3.7188244125E-02, 3.6354533203E-02, 3.5255239850E-01],
	[5.2550000000E+03, 2.1154018773E+00, 6.9688107663E+00, 3.7297213443E-02, 3.6459259848E-02, 3.5279575847E-01],
	[5.2600000000E+03, 2.1177354783E+00, 6.9652135872E+00, 3.7406397891E-02, 3.6564183805E-02, 3.5303893080E-01],
	[5.2650000000E+03, 2.1200694328E+00, 6.9616216800E+00, 3.7515797687E-02, 3.6669305234E-02, 3.5328191606E-01],
	[5.2700000000E+03, 2.1224037405E+00, 6.9580350320E+00, 3.7625413051E-02, 3.6774624295E-02, 3.5352471481E-01],
	[5.2750000000E+03, 2.1247384010E+00, 6.9544536304E+00, 3.7735244203E-02, 3.6880141147E-02, 3.5376732762E-01],
	[5.2800000000E+03, 2.1270734141E+00, 6.9508774628E+00, 3.7845291361E-02, 3.6985855951E-02, 3.5400975504E-01],
	[5.2850000000E+03, 2.1294087796E+00, 6.9473065164E+00, 3.7955554745E-02, 3.7091768865E-02, 3.5425199764E-01],
	[5.2900000000E+03, 2.1317444970E+00, 6.9437407788E+00, 3.8066034575E-02, 3.7197880049E-02, 3.5449405596E-01],
	[5.2950000000E+03, 2.1340805663E+00, 6.9401802373E+00, 3.8176731071E-02, 3.7304189663E-02, 3.5473593057E-01],
	[5.3000000000E+03, 2.1364169870E+00, 6.9366248796E+00, 3.8287644450E-02, 3.7410697865E-02, 3.5497762202E-01],
	[5.3050000000E+03, 2.1387537589E+00, 6.9330746933E+00, 3.8398774934E-02, 3.7517404815E-02, 3.5521913086E-01],
	[5.3100000000E+03, 2.1410908817E+00, 6.9295296658E+00, 3.8510122741E-02, 3.7624310671E-02, 3.5546045763E-01],
	[5.3150000000E+03, 2.1434283551E+00, 6.9259897849E+00, 3.8621688091E-02, 3.7731415592E-02, 3.5570160290E-01],
	[5.3200000000E+03, 2.1457661790E+00, 6.9224550383E+00, 3.8733471204E-02, 3.7838719736E-02, 3.5594256720E-01],
	[5.3250000000E+03, 2.1481043529E+00, 6.9189254138E+00, 3.8845472298E-02, 3.7946223262E-02, 3.5618335108E-01],
	[5.3300000000E+03, 2.1504433319E+00, 6.9154036822E+00, 3.8957691595E-02, 3.8053926555E-02, 3.5642395508E-01],
	[5.3350000000E+03, 2.1527924778E+00, 6.9119469535E+00, 3.9070129312E-02, 3.8161834460E-02, 3.5666437975E-01],
	[5.3400000000E+03, 2.1551419856E+00, 6.9084951883E+00, 3.9182785670E-02, 3.8269942269E-02, 3.5690462563E-01],
	[5.3450000000E+03, 2.1574918552E+00, 6.9050483750E+00, 3.9295660889E-02, 3.8378250141E-02, 3.5714469324E-01],
	[5.3500000000E+03, 2.1598420862E+00, 6.9016065018E+00, 3.9408755187E-02, 3.8486758234E-02, 3.5738458314E-01],
	[5.3550000000E+03, 2.1621926784E+00, 6.8981695570E+00, 3.9522068785E-02, 3.8595466706E-02, 3.5762429585E-01],
	[5.3600000000E+03, 2.1645436314E+00, 6.8947375290E+00, 3.9635601902E-02, 3.8704375715E-02, 3.5786383192E-01],
	[5.3650000000E+03, 2.1668949450E+00, 6.8913104062E+00, 3.9749354758E-02, 3.8813485417E-02, 3.5810319186E-01],
	[5.3700000000E+03, 2.1692466189E+00, 6.8878881769E+00, 3.9863327573E-02, 3.8922795971E-02, 3.5834237622E-01],
	[5.3750000000E+03, 2.1715986529E+00, 6.8844708297E+00, 3.9977520566E-02, 3.9032307534E-02, 3.5858138552E-01],
	[5.3800000000E+03, 2.1739510466E+00, 6.8810583531E+00, 4.0091933956E-02, 3.9142020263E-02, 3.5882022028E-01],
	[5.3850000000E+03, 2.1763037997E+00, 6.8776507356E+00, 4.0206567964E-02, 3.9251934315E-02, 3.5905888105E-01],
	[5.3900000000E+03, 2.1786569121E+00, 6.8742479658E+00, 4.0321422810E-02, 3.9362049848E-02, 3.5929736833E-01],
	[5.3950000000E+03, 2.1810103833E+00, 6.8708500322E+00, 4.0436498712E-02, 3.9472367017E-02, 3.5953568265E-01],
	[5.4000000000E+03, 2.1833642132E+00, 6.8674569237E+00, 4.0551795891E-02, 3.9582885980E-02, 3.5977382453E-01],
	[5.4050000000E+03, 2.1857184014E+00, 6.8640686288E+00, 4.0667314567E-02, 3.9693606893E-02, 3.6001179450E-01],
	[5.4100000000E+03, 2.1880729478E+00, 6.8606851362E+00, 4.0783054959E-02, 3.9804529912E-02, 3.6024959307E-01],
	[5.4150000000E+03, 2.1904278519E+00, 6.8573064348E+00, 4.0899017287E-02, 3.9915655194E-02, 3.6048722076E-01],
	[5.4200000000E+03, 2.1927918268E+00, 6.8539856519E+00, 4.1015201771E-02, 4.0026987611E-02, 3.6072467808E-01],
	[5.4250000000E+03, 2.1951573146E+00, 6.8506765090E+00, 4.1131608631E-02, 4.0138523268E-02, 3.6096196555E-01],
	[5.4300000000E+03, 2.1975231715E+00, 6.8473720100E+00, 4.1248238086E-02, 4.0250261706E-02, 3.6119908368E-01],
	[5.4350000000E+03, 2.1998893973E+00, 6.8440721443E+00, 4.1365090357E-02, 4.0362203079E-02, 3.6143603298E-01],
	[5.4400000000E+03, 2.2022559915E+00, 6.8407769009E+00, 4.1482165663E-02, 4.0474347545E-02, 3.6167281397E-01],
	[5.4450000000E+03, 2.2046229540E+00, 6.8374862693E+00, 4.1599464224E-02, 4.0586695259E-02, 3.6190942714E-01],
	[5.4500000000E+03, 2.2069902845E+00, 6.8342002387E+00, 4.1716986260E-02, 4.0699246376E-02, 3.6214587300E-01],
	[5.4550000000E+03, 2.2093579826E+00, 6.8309187985E+00, 4.1834731991E-02, 4.0812001052E-02, 3.6238215207E-01],
	[5.4600000000E+03, 2.2117260482E+00, 6.8276419380E+00, 4.1952701637E-02, 4.0924959441E-02, 3.6261826484E-01],
	[5.4650000000E+03, 2.2140944809E+00, 6.8243696468E+00, 4.2070895418E-02, 4.1038121700E-02, 3.6285421182E-01],
	[5.4700000000E+03, 2.2164632804E+00, 6.8211019142E+00, 4.2189313553E-02, 4.1151487983E-02, 3.6308999351E-01],
	[5.4750000000E+03, 2.2188324465E+00, 6.8178387298E+00, 4.2307956263E-02, 4.1265058445E-02, 3.6332561041E-01],
	[5.4800000000E+03, 2.2212019788E+00, 6.8145800831E+00, 4.2427125611E-02, 4.1379120356E-02, 3.6356106301E-01],
	[5.4850000000E+03, 2.2235718772E+00, 6.8113259635E+00, 4.2546764998E-02, 4.1493619740E-02, 3.6379635182E-01],
	[5.4900000000E+03, 2.2259421413E+00, 6.8080763608E+00, 4.2666632229E-02, 4.1608326139E-02, 3.6403147733E-01],
	[5.4950000000E+03, 2.2283127709E+00, 6.8048312646E+00, 4.2786727531E-02, 4.1723239713E-02, 3.6426644028E-01],
	[5.5000000000E+03, 2.2306837657E+00, 6.8015906645E+00, 4.2907051129E-02, 4.1838360619E-02, 3.6450124125E-01],
	[5.5050000000E+03, 2.2330593470E+00, 6.7983803342E+00, 4.3027603249E-02, 4.1953691488E-02, 3.6473588075E-01],
	[5.5100000000E+03, 2.2354405193E+00, 6.7952062719E+00, 4.3148384116E-02, 4.2069233098E-02, 3.6497035928E-01],
	[5.5150000000E+03, 2.2378220675E+00, 6.7920365685E+00, 4.3269393956E-02, 4.2184982567E-02, 3.6520467734E-01],
	[5.5200000000E+03, 2.2402039913E+00, 6.7888712141E+00, 4.3390632996E-02, 4.2300940053E-02, 3.6543883545E-01],
	[5.5250000000E+03, 2.2425862904E+00, 6.7857101987E+00, 4.3512101460E-02, 4.2417105714E-02, 3.6567283410E-01],
	[5.5300000000E+03, 2.2449689645E+00, 6.7825535124E+00, 4.3633799575E-02, 4.2533479707E-02, 3.6590667380E-01],
	[5.5350000000E+03, 2.2473520134E+00, 6.7794011456E+00, 4.3755727566E-02, 4.2650062191E-02, 3.6614035504E-01],
	[5.5400000000E+03, 2.2497354367E+00, 6.7762530882E+00, 4.3877885659E-02, 4.2766853323E-02, 3.6637387832E-01],
	[5.5450000000E+03, 2.2521192341E+00, 6.7731093306E+00, 4.4000274080E-02, 4.2883853261E-02, 3.6660724414E-01],
	[5.5500000000E+03, 2.2545034055E+00, 6.7699698631E+00, 4.4122893055E-02, 4.3001062162E-02, 3.6684045300E-01],
	[5.5550000000E+03, 2.2568879505E+00, 6.7668346759E+00, 4.4245742810E-02, 4.3118480183E-02, 3.6707350538E-01],
	[5.5600000000E+03, 2.2592728689E+00, 6.7637037593E+00, 4.4368823571E-02, 4.3236107482E-02, 3.6730640178E-01],
	[5.5650000000E+03, 2.2616581603E+00, 6.7605771037E+00, 4.4492135563E-02, 4.3353944215E-02, 3.6753914268E-01],
	[5.5700000000E+03, 2.2640438245E+00, 6.7574546994E+00, 4.4615679012E-02, 4.3471990539E-02, 3.6777172859E-01],
	[5.5750000000E+03, 2.2664298612E+00, 6.7543365369E+00, 4.4739454145E-02, 4.3590246612E-02, 3.6800415998E-01],
	[5.5800000000E+03, 2.2688162701E+00, 6.7512226067E+00, 4.4863461187E-02, 4.3708712588E-02, 3.6823643735E-01],
	[5.5850000000E+03, 2.2712030511E+00, 6.7481128991E+00, 4.4987700365E-02, 4.3827388625E-02, 3.6846856117E-01],
	[5.5900000000E+03, 2.2735902037E+00, 6.7450074048E+00, 4.5112171904E-02, 4.3946274879E-02, 3.6870053194E-01],
	[5.5950000000E+03, 2.2759843139E+00, 6.7419464326E+00, 4.5236876031E-02, 4.4065375697E-02, 3.6893235013E-01],
	[5.6000000000E+03, 2.2783812430E+00, 6.7389044944E+00, 4.5361812971E-02, 4.4184688641E-02, 3.6916401623E-01],
	[5.6050000000E+03, 2.2807785538E+00, 6.7358666417E+00, 4.5486982950E-02, 4.4304212321E-02, 3.6939553071E-01],
	[5.6100000000E+03, 2.2831762461E+00, 6.7328328653E+00, 4.5612386195E-02, 4.4423946895E-02, 3.6962689405E-01],
	[5.6150000000E+03, 2.2855743196E+00, 6.7298031562E+00, 4.5738022931E-02, 4.4543892517E-02, 3.6985810673E-01],
	[5.6200000000E+03, 2.2879727740E+00, 6.7267775052E+00, 4.5863893385E-02, 4.4664049344E-02, 3.7008916923E-01],
	[5.6250000000E+03, 2.2903716091E+00, 6.7237559034E+00, 4.5989997783E-02, 4.4784417530E-02, 3.7032008202E-01],
	[5.6300000000E+03, 2.2927708245E+00, 6.7207383418E+00, 4.6116336351E-02, 4.4904997232E-02, 3.7055084558E-01],
	[5.6350000000E+03, 2.2951704200E+00, 6.7177248113E+00, 4.6242909315E-02, 4.5025788604E-02, 3.7078146037E-01],
	[5.6400000000E+03, 2.2975703953E+00, 6.7147153030E+00, 4.6369716902E-02, 4.5146791801E-02, 3.7101192686E-01],
	[5.6450000000E+03, 2.2999707502E+00, 6.7117098080E+00, 4.6496759337E-02, 4.5268006979E-02, 3.7124224553E-01],
	[5.6500000000E+03, 2.3023714843E+00, 6.7087083174E+00, 4.6624036846E-02, 4.5389434291E-02, 3.7147241685E-01],
	[5.6550000000E+03, 2.3047725974E+00, 6.7057108223E+00, 4.6751549657E-02, 4.5511073893E-02, 3.7170244127E-01],
	[5.6600000000E+03, 2.3071740893E+00, 6.7027173138E+00, 4.6879297994E-02, 4.5632925939E-02, 3.7193231927E-01],
	[5.6650000000E+03, 2.3095759595E+00, 6.6997277832E+00, 4.7007282085E-02, 4.5754990583E-02, 3.7216205131E-01],
	[5.6700000000E+03, 2.3119782079E+00, 6.6967422216E+00, 4.7135502156E-02, 4.5877267980E-02, 3.7239163785E-01],
	[5.6750000000E+03, 2.3143808342E+00, 6.6937606203E+00, 4.7263958432E-02, 4.5999758283E-02, 3.7262107935E-01],
	[5.6800000000E+03, 2.3167838381E+00, 6.6907829706E+00, 4.7392651141E-02, 4.6122461646E-02, 3.7285037628E-01],
	[5.6850000000E+03, 2.3191934774E+00, 6.6878477610E+00, 4.7521580508E-02, 4.6245382553E-02, 3.7307952909E-01],
	[5.6900000000E+03, 2.3216058504E+00, 6.6849308472E+00, 4.7650746760E-02, 4.6368518497E-02, 3.7330853825E-01],
	[5.6950000000E+03, 2.3240186105E+00, 6.6820177660E+00, 4.7780150124E-02, 4.6491868015E-02, 3.7353740420E-01],
	[5.7000000000E+03, 2.3264317574E+00, 6.6791085091E+00, 4.7909790825E-02, 4.6615431261E-02, 3.7376612740E-01],
	[5.7050000000E+03, 2.3288452908E+00, 6.6762030680E+00, 4.8039669090E-02, 4.6739208389E-02, 3.7399470832E-01],
	[5.7100000000E+03, 2.3312592104E+00, 6.6733014344E+00, 4.8169785145E-02, 4.6863199551E-02, 3.7422314740E-01],
	[5.7150000000E+03, 2.3336735161E+00, 6.6704036000E+00, 4.8300139218E-02, 4.6987404901E-02, 3.7445144509E-01],
	[5.7200000000E+03, 2.3360882074E+00, 6.6675095564E+00, 4.8430731534E-02, 4.7111824592E-02, 3.7467960184E-01],
	[5.7250000000E+03, 2.3385032842E+00, 6.6646192955E+00, 4.8561562319E-02, 4.7236458776E-02, 3.7490761811E-01],
	[5.7300000000E+03, 2.3409187461E+00, 6.6617328090E+00, 4.8692631801E-02, 4.7361307606E-02, 3.7513549435E-01],
	[5.7350000000E+03, 2.3433345929E+00, 6.6588500887E+00, 4.8823940205E-02, 4.7486371234E-02, 3.7536323099E-01],
	[5.7400000000E+03, 2.3457508243E+00, 6.6559711263E+00, 4.8955487759E-02, 4.7611649814E-02, 3.7559082849E-01],
	[5.7450000000E+03, 2.3481674400E+00, 6.6530959138E+00, 4.9087274688E-02, 4.7737143496E-02, 3.7581828729E-01],
	[5.7500000000E+03, 2.3505844398E+00, 6.6502244429E+00, 4.9219301220E-02, 4.7862852433E-02, 3.7604560784E-01],
	[5.7550000000E+03, 2.3530018233E+00, 6.6473567056E+00, 4.9351567580E-02, 4.7988776777E-02, 3.7627279058E-01],
	[5.7600000000E+03, 2.3554195904E+00, 6.6444926938E+00, 4.9484073996E-02, 4.8114916680E-02, 3.7649983595E-01],
	[5.7650000000E+03, 2.3578377407E+00, 6.6416323993E+00, 4.9616820694E-02, 4.8241272293E-02, 3.7672674439E-01],
	[5.7700000000E+03, 2.3602562739E+00, 6.6387758142E+00, 4.9749807901E-02, 4.8367843768E-02, 3.7695351633E-01],
	[5.7750000000E+03, 2.3626787478E+00, 6.6359449864E+00, 4.9883035843E-02, 4.8494633932E-02, 3.7718015223E-01],
	[5.7800000000E+03, 2.3651062369E+00, 6.6331464661E+00, 5.0016504746E-02, 4.8621643779E-02, 3.7740665252E-01],
	[5.7850000000E+03, 2.3675341179E+00, 6.6303515442E+00, 5.0150214839E-02, 4.8748869996E-02, 3.7763301763E-01],
	[5.7900000000E+03, 2.3699623904E+00, 6.6275602132E+00, 5.0284166346E-02, 4.8876312734E-02, 3.7785924799E-01],
	[5.7950000000E+03, 2.3723910542E+00, 6.6247724651E+00, 5.0418359495E-02, 4.9003972143E-02, 3.7808534405E-01],
	[5.8000000000E+03, 2.3748201091E+00, 6.6219882924E+00, 5.0552794513E-02, 4.9131848374E-02, 3.7831130623E-01],
	[5.8050000000E+03, 2.3772495547E+00, 6.6192076875E+00, 5.0687471627E-02, 4.9259941579E-02, 3.7853713497E-01],
	[5.8100000000E+03, 2.3796793908E+00, 6.6164306425E+00, 5.0822391062E-02, 4.9388251907E-02, 3.7876283070E-01],
	[5.8150000000E+03, 2.3821096171E+00, 6.6136571501E+00, 5.0957553046E-02, 4.9516779508E-02, 3.7898839384E-01],
	[5.8200000000E+03, 2.3845402333E+00, 6.6108872025E+00, 5.1092957806E-02, 4.9645524534E-02, 3.7921382484E-01],
	[5.8250000000E+03, 2.3869712391E+00, 6.6081207921E+00, 5.1228605569E-02, 4.9774487134E-02, 3.7943912410E-01],
	[5.8300000000E+03, 2.3894026344E+00, 6.6053579115E+00, 5.1364496560E-02, 4.9903667457E-02, 3.7966429207E-01],
	[5.8350000000E+03, 2.3918344187E+00, 6.6025985531E+00, 5.1500631008E-02, 5.0033065654E-02, 3.7988932917E-01],
	[5.8400000000E+03, 2.3942665919E+00, 6.5998427094E+00, 5.1637009138E-02, 5.0162681874E-02, 3.8011423581E-01],
	[5.8450000000E+03, 2.3966991537E+00, 6.5970903729E+00, 5.1773631179E-02, 5.0292516266E-02, 3.8033901244E-01],
	[5.8500000000E+03, 2.3991321037E+00, 6.5943415362E+00, 5.1910497355E-02, 5.0422568980E-02, 3.8056365946E-01],
	[5.8550000000E+03, 2.4015654418E+00, 6.5915961919E+00, 5.2047607896E-02, 5.0552840165E-02, 3.8078817730E-01],
	[5.8600000000E+03, 2.4039991676E+00, 6.5888543324E+00, 5.2184963027E-02, 5.0683329969E-02, 3.8101256638E-01],
	[5.8650000000E+03, 2.4064332810E+00, 6.5861159505E+00, 5.2322562975E-02, 5.0814038542E-02, 3.8123682712E-01],
	[5.8700000000E+03, 2.4088743633E+00, 6.5834222237E+00, 5.2460407967E-02, 5.0944971442E-02, 3.8146095994E-01],
	[5.8750000000E+03, 2.4113170224E+00, 6.5807392771E+00, 5.2598498231E-02, 5.1076124430E-02, 3.8168496526E-01],
	[5.8800000000E+03, 2.4137600772E+00, 6.5780597049E+00, 5.2736833992E-02, 5.1207496687E-02, 3.8190884349E-01],
	[5.8850000000E+03, 2.4162035276E+00, 6.5753835000E+00, 5.2875415480E-02, 5.1339088363E-02, 3.8213259505E-01],
	[5.8900000000E+03, 2.4186473732E+00, 6.5727106552E+00, 5.3014242919E-02, 5.1470899605E-02, 3.8235622036E-01],
	[5.8950000000E+03, 2.4210916137E+00, 6.5700411636E+00, 5.3153316537E-02, 5.1602930562E-02, 3.8257971982E-01],
	[5.9000000000E+03, 2.4235362490E+00, 6.5673750180E+00, 5.3292636562E-02, 5.1735181381E-02, 3.8280309386E-01],
	[5.9050000000E+03, 2.4259812787E+00, 6.5647122114E+00, 5.3432203220E-02, 5.1867652210E-02, 3.8302634288E-01],
	[5.9100000000E+03, 2.4284267025E+00, 6.5620527370E+00, 5.3572016738E-02, 5.2000343197E-02, 3.8324946730E-01],
	[5.9150000000E+03, 2.4308725202E+00, 6.5593965875E+00, 5.3712077344E-02, 5.2133254490E-02, 3.8347246752E-01],
	[5.9200000000E+03, 2.4333187315E+00, 6.5567437562E+00, 5.3852385265E-02, 5.2266386235E-02, 3.8369534395E-01],
	[5.9250000000E+03, 2.4357653362E+00, 6.5540942360E+00, 5.3992940727E-02, 5.2399738580E-02, 3.8391809701E-01],
	[5.9300000000E+03, 2.4382123340E+00, 6.5514480201E+00, 5.4133743958E-02, 5.2533311672E-02, 3.8414072710E-01],
	[5.9350000000E+03, 2.4406597245E+00, 6.5488051014E+00, 5.4274795185E-02, 5.2667105658E-02, 3.8436323472E-01],
	[5.9400000000E+03, 2.4431075076E+00, 6.5461654733E+00, 5.4416094635E-02, 5.2801120684E-02, 3.8458562029E-01],
	[5.9450000000E+03, 2.4455556830E+00, 6.5435291287E+00, 5.4557642536E-02, 5.2935356897E-02, 3.8480788419E-01],
	[5.9500000000E+03, 2.4480042504E+00, 6.5408960608E+00, 5.4699439114E-02, 5.3069814443E-02, 3.8503002680E-01],
	[5.9550000000E+03, 2.4504532095E+00, 6.5382662629E+00, 5.4841484597E-02, 5.3204493469E-02, 3.8525204850E-01],
	[5.9600000000E+03, 2.4529025601E+00, 6.5356397281E+00, 5.4983779212E-02, 5.3339394120E-02, 3.8547394968E-01],
	[5.9650000000E+03, 2.4553593639E+00, 6.5330611811E+00, 5.5126323186E-02, 5.3474522890E-02, 3.8569573071E-01],
	[5.9700000000E+03, 2.4578168485E+00, 6.5304875922E+00, 5.5269116747E-02, 5.3609873885E-02, 3.8591739199E-01],
	[5.9750000000E+03, 2.4602747323E+00, 6.5279171704E+00, 5.5412160121E-02, 5.3745447000E-02, 3.8613893388E-01],
	[5.9800000000E+03, 2.4627330150E+00, 6.5253499091E+00, 5.5555453537E-02, 5.3881242380E-02, 3.8636035676E-01],
	[5.9850000000E+03, 2.4651916964E+00, 6.5227858018E+00, 5.5698997221E-02, 5.4017260172E-02, 3.8658166102E-01],
	[5.9900000000E+03, 2.4676507762E+00, 6.5202248421E+00, 5.5842791401E-02, 5.4153500520E-02, 3.8680284702E-01],
	[5.9950000000E+03, 2.4701102540E+00, 6.5176670233E+00, 5.5986836303E-02, 5.4289963569E-02, 3.8702391515E-01],
	[6.0000000000E+03, 2.4725701298E+00, 6.5151123392E+00, 5.6131132157E-02, 5.4426649466E-02, 3.8724486578E-01],
	[6.0050000000E+03, 2.4750304031E+00, 6.5125607831E+00, 5.6276536312E-02, 5.4564364117E-02, 3.8746569928E-01],
	[6.0100000000E+03, 2.4774910737E+00, 6.5100123487E+00, 5.6422195560E-02, 5.4702305178E-02, 3.8768641603E-01],
	[6.0150000000E+03, 2.4799521413E+00, 6.5074670296E+00, 5.6568110135E-02, 5.4840472798E-02, 3.8790701640E-01],
	[6.0200000000E+03, 2.4824136058E+00, 6.5049248193E+00, 5.6714280272E-02, 5.4978867125E-02, 3.8812750075E-01],
	[6.0250000000E+03, 2.4848754667E+00, 6.5023857115E+00, 5.6860706204E-02, 5.5117488311E-02, 3.8834786947E-01],
	[6.0300000000E+03, 2.4873377239E+00, 6.4998496999E+00, 5.7007388167E-02, 5.5256336504E-02, 3.8856812292E-01],
	[6.0350000000E+03, 2.4898003771E+00, 6.4973167781E+00, 5.7154326394E-02, 5.5395411852E-02, 3.8878826147E-01],
	[6.0400000000E+03, 2.4922634260E+00, 6.4947869398E+00, 5.7301521122E-02, 5.5534714505E-02, 3.8900828549E-01],
	[6.0450000000E+03, 2.4947268704E+00, 6.4922601787E+00, 5.7448972585E-02, 5.5674244612E-02, 3.8922819534E-01],
	[6.0500000000E+03, 2.4971907099E+00, 6.4897364884E+00, 5.7596681016E-02, 5.5814002321E-02, 3.8944799140E-01],
	[6.0550000000E+03, 2.4996549444E+00, 6.4872158628E+00, 5.7744646651E-02, 5.5953987780E-02, 3.8966767402E-01],
	[6.0600000000E+03, 2.5021249704E+00, 6.4847326510E+00, 5.7892869725E-02, 5.6094206421E-02, 3.8988724358E-01],
	[6.0650000000E+03, 2.5045969966E+00, 6.4822626053E+00, 5.8041350473E-02, 5.6234654725E-02, 3.9010670043E-01],
	[6.0700000000E+03, 2.5070694249E+00, 6.4797955348E+00, 5.8190089128E-02, 5.6375331283E-02, 3.9032604495E-01],
	[6.0750000000E+03, 2.5095422551E+00, 6.4773314334E+00, 5.8339085926E-02, 5.6516236242E-02, 3.9054527748E-01],
	[6.0800000000E+03, 2.5120154869E+00, 6.4748702951E+00, 5.8488341102E-02, 5.6657369750E-02, 3.9076439841E-01],
	[6.0850000000E+03, 2.5144891201E+00, 6.4724121140E+00, 5.8637854890E-02, 5.6798731955E-02, 3.9098340808E-01],
	[6.0900000000E+03, 2.5169631545E+00, 6.4699568839E+00, 5.8787627526E-02, 5.6940323004E-02, 3.9120230686E-01],
	[6.0950000000E+03, 2.5194375896E+00, 6.4675045991E+00, 5.8937659244E-02, 5.7082143045E-02, 3.9142109510E-01],
	[6.1000000000E+03, 2.5219124254E+00, 6.4650552534E+00, 5.9087950279E-02, 5.7224192225E-02, 3.9163977317E-01],
	[6.1050000000E+03, 2.5243876614E+00, 6.4626088411E+00, 5.9238500866E-02, 5.7366470691E-02, 3.9185834142E-01],
	[6.1100000000E+03, 2.5268632975E+00, 6.4601653562E+00, 5.9389311240E-02, 5.7508978589E-02, 3.9207680022E-01],
	[6.1150000000E+03, 2.5293393334E+00, 6.4577247928E+00, 5.9540381636E-02, 5.7651716067E-02, 3.9229514991E-01],
	[6.1200000000E+03, 2.5318157688E+00, 6.4552871450E+00, 5.9691712288E-02, 5.7794683270E-02, 3.9251339085E-01],
	[6.1250000000E+03, 2.5342926035E+00, 6.4528524069E+00, 5.9843303432E-02, 5.7937880345E-02, 3.9273152341E-01],
	[6.1300000000E+03, 2.5367698372E+00, 6.4504205728E+00, 5.9995155303E-02, 5.8081307439E-02, 3.9294954793E-01],
	[6.1350000000E+03, 2.5392474696E+00, 6.4479916367E+00, 6.0147268136E-02, 5.8224964697E-02, 3.9316746476E-01],
	[6.1400000000E+03, 2.5417255005E+00, 6.4455655930E+00, 6.0299642166E-02, 5.8368852264E-02, 3.9338527426E-01],
	[6.1450000000E+03, 2.5442039296E+00, 6.4431424357E+00, 6.0452277627E-02, 5.8512970288E-02, 3.9360297679E-01],
	[6.1500000000E+03, 2.5466827567E+00, 6.4407221591E+00, 6.0605174755E-02, 5.8657318912E-02, 3.9382057269E-01],
	[6.1550000000E+03, 2.5491638075E+00, 6.4383163668E+00, 6.0758333786E-02, 5.8801900223E-02, 3.9403806231E-01],
	[6.1600000000E+03, 2.5516501397E+00, 6.4359444196E+00, 6.0911754953E-02, 5.8946717647E-02, 3.9425544601E-01],
	[6.1650000000E+03, 2.5541368766E+00, 6.4335752696E+00, 6.1065438493E-02, 5.9091766168E-02, 3.9447272413E-01],
	[6.1700000000E+03, 2.5566240181E+00, 6.4312089114E+00, 6.1219384640E-02, 5.9237045931E-02, 3.9468989703E-01],
	[6.1750000000E+03, 2.5591115638E+00, 6.4288453394E+00, 6.1373593630E-02, 5.9382557081E-02, 3.9490696505E-01],
	[6.1800000000E+03, 2.5615995136E+00, 6.4264845480E+00, 6.1528065698E-02, 5.9528299762E-02, 3.9512392853E-01],
	[6.1850000000E+03, 2.5640878670E+00, 6.4241265318E+00, 6.1682801079E-02, 5.9674274119E-02, 3.9534078783E-01],
	[6.1900000000E+03, 2.5665766240E+00, 6.4217712851E+00, 6.1837800008E-02, 5.9820480297E-02, 3.9555754329E-01],
	[6.1950000000E+03, 2.5690657842E+00, 6.4194188027E+00, 6.1993062720E-02, 5.9966918440E-02, 3.9577419526E-01],
	[6.2000000000E+03, 2.5715553473E+00, 6.4170690788E+00, 6.2148589451E-02, 6.0113588691E-02, 3.9599074408E-01],
	[6.2050000000E+03, 2.5740453132E+00, 6.4147221082E+00, 6.2304380437E-02, 6.0260491196E-02, 3.9620719010E-01],
	[6.2100000000E+03, 2.5765356814E+00, 6.4123778854E+00, 6.2460435911E-02, 6.0407626096E-02, 3.9642353365E-01],
	[6.2150000000E+03, 2.5790264519E+00, 6.4100364049E+00, 6.2616756111E-02, 6.0554993537E-02, 3.9663977508E-01],
	[6.2200000000E+03, 2.5815176243E+00, 6.4076976614E+00, 6.2773341270E-02, 6.0702593661E-02, 3.9685591474E-01],
	[6.2250000000E+03, 2.5840091983E+00, 6.4053616494E+00, 6.2930191625E-02, 6.0850426611E-02, 3.9707195296E-01],
	[6.2300000000E+03, 2.5865011738E+00, 6.4030283635E+00, 6.3087307411E-02, 6.0998492531E-02, 3.9728789009E-01],
	[6.2350000000E+03, 2.5889935504E+00, 6.4006977985E+00, 6.3244688863E-02, 6.1146791563E-02, 3.9750372646E-01],
	[6.2400000000E+03, 2.5914863279E+00, 6.3983699489E+00, 6.3402336216E-02, 6.1295323850E-02, 3.9771946242E-01],
	[6.2450000000E+03, 2.5939795060E+00, 6.3960448094E+00, 6.3560249707E-02, 6.1444089535E-02, 3.9793509831E-01],
	[6.2500000000E+03, 2.5964730845E+00, 6.3937223747E+00, 6.3718429570E-02, 6.1593088760E-02, 3.9815063445E-01],
	[6.2550000000E+03, 2.5989700108E+00, 6.3914213649E+00, 6.3876876041E-02, 6.1742325078E-02, 3.9836607119E-01],
	[6.2600000000E+03, 2.6014708121E+00, 6.3891450480E+00, 6.4035589356E-02, 6.1891799280E-02, 3.9858140888E-01],
	[6.2650000000E+03, 2.6039720202E+00, 6.3868713582E+00, 6.4194569749E-02, 6.2041507510E-02, 3.9879664783E-01],
	[6.2700000000E+03, 2.6064736349E+00, 6.3846002905E+00, 6.4353817458E-02, 6.2191449909E-02, 3.9901178839E-01],
	[6.2750000000E+03, 2.6089756559E+00, 6.3823318396E+00, 6.4513332716E-02, 6.2341626621E-02, 3.9922683090E-01],
	[6.2800000000E+03, 2.6114780829E+00, 6.3800660006E+00, 6.4673115760E-02, 6.2492037785E-02, 3.9944177569E-01],
	[6.2850000000E+03, 2.6139809157E+00, 6.3778027684E+00, 6.4833166826E-02, 6.2642683544E-02, 3.9965662308E-01],
	[6.2900000000E+03, 2.6164841540E+00, 6.3755421378E+00, 6.4993486148E-02, 6.2793564038E-02, 3.9987137343E-01],
	[6.2950000000E+03, 2.6189877976E+00, 6.3732841039E+00, 6.5154073963E-02, 6.2944679409E-02, 4.0008602705E-01],
	[6.3000000000E+03, 2.6214918462E+00, 6.3710286615E+00, 6.5314930507E-02, 6.3096029798E-02, 4.0030058428E-01],
	[6.3050000000E+03, 2.6239962995E+00, 6.3687758057E+00, 6.5476056014E-02, 6.3247615345E-02, 4.0051504546E-01],
	[6.3100000000E+03, 2.6265011574E+00, 6.3665255315E+00, 6.5637450721E-02, 6.3399436191E-02, 4.0072941091E-01],
	[6.3150000000E+03, 2.6290064194E+00, 6.3642778337E+00, 6.5799114863E-02, 6.3551492477E-02, 4.0094368096E-01],
	[6.3200000000E+03, 2.6315120855E+00, 6.3620327075E+00, 6.5961048676E-02, 6.3703784341E-02, 4.0115785594E-01],
	[6.3250000000E+03, 2.6340181553E+00, 6.3597901479E+00, 6.6123252396E-02, 6.3856311925E-02, 4.0137193619E-01],
	[6.3300000000E+03, 2.6365246286E+00, 6.3575501500E+00, 6.6285726259E-02, 6.4009075368E-02, 4.0158592203E-01],
	[6.3350000000E+03, 2.6390315051E+00, 6.3553127087E+00, 6.6448470500E-02, 6.4162074810E-02, 4.0179981379E-01],
	[6.3400000000E+03, 2.6415387846E+00, 6.3530778191E+00, 6.6611485355E-02, 6.4315310390E-02, 4.0201361180E-01],
	[6.3450000000E+03, 2.6440464667E+00, 6.3508454763E+00, 6.6774771060E-02, 6.4468782248E-02, 4.0222731640E-01],
	[6.3500000000E+03, 2.6465545514E+00, 6.3486156755E+00, 6.6938327851E-02, 6.4622490523E-02, 4.0244092787E-01],
	[6.3550000000E+03, 2.6490650437E+00, 6.3464011727E+00, 6.7102155964E-02, 6.4776437881E-02, 4.0265444652E-01],
	[6.3600000000E+03, 2.6515800643E+00, 6.3442153913E+00, 6.7266255635E-02, 6.4930627173E-02, 4.0286787264E-01],
	[6.3650000000E+03, 2.6540954934E+00, 6.3420320795E+00, 6.7430627098E-02, 6.5085053361E-02, 4.0308120650E-01],
	[6.3700000000E+03, 2.6566113307E+00, 6.3398512326E+00, 6.7595270592E-02, 6.5239716585E-02, 4.0329444839E-01],
	[6.3750000000E+03, 2.6591275761E+00, 6.3376728459E+00, 6.7760186351E-02, 6.5394616982E-02, 4.0350759862E-01],
	[6.3800000000E+03, 2.6616442291E+00, 6.3354969147E+00, 6.7925374611E-02, 6.5549754691E-02, 4.0372065745E-01],
	[6.3850000000E+03, 2.6641612897E+00, 6.3333234343E+00, 6.8090835608E-02, 6.5705129851E-02, 4.0393362518E-01],
	[6.3900000000E+03, 2.6666787575E+00, 6.3311524000E+00, 6.8256569579E-02, 6.5860742599E-02, 4.0414650210E-01],
	[6.3950000000E+03, 2.6691966323E+00, 6.3289838072E+00, 6.8422576759E-02, 6.6016593072E-02, 4.0435928848E-01],
	[6.4000000000E+03, 2.6717149138E+00, 6.3268176512E+00, 6.8588857384E-02, 6.6172681410E-02, 4.0457198462E-01],
	[6.4050000000E+03, 2.6742336017E+00, 6.3246539274E+00, 6.8755411691E-02, 6.6329007748E-02, 4.0478459079E-01],
	[6.4100000000E+03, 2.6767526959E+00, 6.3224926310E+00, 6.8922239916E-02, 6.6485572225E-02, 4.0499710729E-01],
	[6.4150000000E+03, 2.6792721961E+00, 6.3203337577E+00, 6.9089342294E-02, 6.6642374977E-02, 4.0520953439E-01],
	[6.4200000000E+03, 2.6817921020E+00, 6.3181773026E+00, 6.9256719061E-02, 6.6799416141E-02, 4.0542187238E-01],
	[6.4250000000E+03, 2.6843124134E+00, 6.3160232613E+00, 6.9424370455E-02, 6.6956695855E-02, 4.0563412155E-01],
	[6.4300000000E+03, 2.6868331300E+00, 6.3138716291E+00, 6.9592296711E-02, 6.7114214254E-02, 4.0584628216E-01],
	[6.4350000000E+03, 2.6893542516E+00, 6.3117224016E+00, 6.9760498064E-02, 6.7271971474E-02, 4.0605835452E-01],
	[6.4400000000E+03, 2.6918757778E+00, 6.3095755741E+00, 6.9928974752E-02, 6.7429967653E-02, 4.0627033889E-01],
	[6.4450000000E+03, 2.6943977086E+00, 6.3074311421E+00, 7.0097727011E-02, 6.7588202926E-02, 4.0648223555E-01],
	[6.4500000000E+03, 2.6969200436E+00, 6.3052891010E+00, 7.0266755076E-02, 6.7746677429E-02, 4.0669404479E-01],
	[6.4550000000E+03, 2.6994427825E+00, 6.3031494464E+00, 7.0436059185E-02, 6.7905391297E-02, 4.0690576689E-01],
	[6.4600000000E+03, 2.7019710108E+00, 6.3010446295E+00, 7.0605639573E-02, 6.8064351680E-02, 4.0711740213E-01],
	[6.4650000000E+03, 2.7045004004E+00, 6.2989469380E+00, 7.0775496476E-02, 6.8223552798E-02, 4.0732895078E-01],
	[6.4700000000E+03, 2.7070301997E+00, 6.2968515658E+00, 7.0945630131E-02, 6.8382993752E-02, 4.0754041312E-01],
	[6.4750000000E+03, 2.7095604083E+00, 6.2947585084E+00, 7.1116040774E-02, 6.8542674678E-02, 4.0775178944E-01],
	[6.4800000000E+03, 2.7120910260E+00, 6.2926677616E+00, 7.1286728642E-02, 6.8702595711E-02, 4.0796308000E-01],
	[6.4850000000E+03, 2.7146220526E+00, 6.2905793211E+00, 7.1457693971E-02, 6.8862756985E-02, 4.0817428509E-01],
	[6.4900000000E+03, 2.7171534878E+00, 6.2884931824E+00, 7.1628936997E-02, 6.9023158636E-02, 4.0838540499E-01],
	[6.4950000000E+03, 2.7196853314E+00, 6.2864093414E+00, 7.1800457957E-02, 6.9183800798E-02, 4.0859643996E-01],
	[6.5000000000E+03, 2.7222175832E+00, 6.2843277936E+00, 7.1972257087E-02, 6.9344683605E-02, 4.0880739029E-01],
	[6.5050000000E+03, 2.7247502428E+00, 6.2822485349E+00, 7.2144334623E-02, 6.9505807191E-02, 4.0901825625E-01],
	[6.5100000000E+03, 2.7272833100E+00, 6.2801715609E+00, 7.2316690802E-02, 6.9667171690E-02, 4.0922903811E-01],
	[6.5150000000E+03, 2.7298167847E+00, 6.2780968674E+00, 7.2489325861E-02, 6.9828777236E-02, 4.0943973615E-01],
	[6.5200000000E+03, 2.7323506664E+00, 6.2760244501E+00, 7.2662240035E-02, 6.9990623963E-02, 4.0965035065E-01],
	[6.5250000000E+03, 2.7348849551E+00, 6.2739543049E+00, 7.2835433562E-02, 7.0152712003E-02, 4.0986088188E-01],
	[6.5300000000E+03, 2.7374196504E+00, 6.2718864273E+00, 7.3008906678E-02, 7.0315041490E-02, 4.1007133011E-01],
	[6.5350000000E+03, 2.7399547521E+00, 6.2698208134E+00, 7.3182659619E-02, 7.0477612558E-02, 4.1028169561E-01],
	[6.5400000000E+03, 2.7424902599E+00, 6.2677574588E+00, 7.3356692622E-02, 7.0640425338E-02, 4.1049197865E-01],
	[6.5450000000E+03, 2.7450261736E+00, 6.2656963593E+00, 7.3531005924E-02, 7.0803479963E-02, 4.1070217952E-01],
	[6.5500000000E+03, 2.7475624931E+00, 6.2636375107E+00, 7.3705599761E-02, 7.0966776566E-02, 4.1091229848E-01],
	[6.5550000000E+03, 2.7500992179E+00, 6.2615809090E+00, 7.3880474370E-02, 7.1130315279E-02, 4.1112233580E-01],
	[6.5600000000E+03, 2.7526368233E+00, 6.2595296053E+00, 7.4055629988E-02, 7.1294096950E-02, 4.1133229175E-01],
	[6.5650000000E+03, 2.7551799032E+00, 6.2575130746E+00, 7.4231066850E-02, 7.1458128653E-02, 4.1154216660E-01],
	[6.5700000000E+03, 2.7577233938E+00, 6.2554987279E+00, 7.4406785194E-02, 7.1622402929E-02, 4.1175196063E-01],
	[6.5750000000E+03, 2.7602672948E+00, 6.2534865614E+00, 7.4582785257E-02, 7.1786919909E-02, 4.1196167410E-01],
	[6.5800000000E+03, 2.7628116060E+00, 6.2514765710E+00, 7.4759067275E-02, 7.1951679725E-02, 4.1217130728E-01],
	[6.5850000000E+03, 2.7653563272E+00, 6.2494687527E+00, 7.4935631485E-02, 7.2116682508E-02, 4.1238086044E-01],
	[6.5900000000E+03, 2.7679014581E+00, 6.2474631024E+00, 7.5112478123E-02, 7.2281928390E-02, 4.1259033385E-01],
	[6.5950000000E+03, 2.7704469984E+00, 6.2454596162E+00, 7.5289607427E-02, 7.2447417501E-02, 4.1279972778E-01],
	[6.6000000000E+03, 2.7729929480E+00, 6.2434582902E+00, 7.5467019633E-02, 7.2613149973E-02, 4.1300904250E-01],
	[6.6050000000E+03, 2.7755393065E+00, 6.2414591204E+00, 7.5644714978E-02, 7.2779125936E-02, 4.1321827827E-01],
	[6.6100000000E+03, 2.7780860737E+00, 6.2394621027E+00, 7.5822693699E-02, 7.2945345521E-02, 4.1342743535E-01],
	[6.6150000000E+03, 2.7806332494E+00, 6.2374672334E+00, 7.6000956032E-02, 7.3111808857E-02, 4.1363651403E-01],
	[6.6200000000E+03, 2.7831808334E+00, 6.2354745084E+00, 7.6179502215E-02, 7.3278516076E-02, 4.1384551456E-01],
	[6.6250000000E+03, 2.7857288253E+00, 6.2334839238E+00, 7.6358332485E-02, 7.3445467307E-02, 4.1405443720E-01],
	[6.6300000000E+03, 2.7882772250E+00, 6.2314954757E+00, 7.6537447077E-02, 7.3612662680E-02, 4.1426328224E-01],
	[6.6350000000E+03, 2.7908260322E+00, 6.2295091602E+00, 7.6716846230E-02, 7.3780102324E-02, 4.1447204992E-01],
	[6.6400000000E+03, 2.7933752466E+00, 6.2275249734E+00, 7.6896530180E-02, 7.3947786369E-02, 4.1468074051E-01],
	[6.6450000000E+03, 2.7959248681E+00, 6.2255429115E+00, 7.7076499164E-02, 7.4115714944E-02, 4.1488935429E-01],
	[6.6500000000E+03, 2.7984748964E+00, 6.2235629705E+00, 7.7256753419E-02, 7.4283888177E-02, 4.1509789150E-01],
	[6.6550000000E+03, 2.8010253312E+00, 6.2215851466E+00, 7.7437293182E-02, 7.4452306199E-02, 4.1530635243E-01],
	[6.6600000000E+03, 2.8035761723E+00, 6.2196094360E+00, 7.7618118690E-02, 7.4620969136E-02, 4.1551473732E-01],
	[6.6650000000E+03, 2.8061274195E+00, 6.2176358347E+00, 7.7799230179E-02, 7.4789877118E-02, 4.1572304645E-01],
	[6.6700000000E+03, 2.8086841419E+00, 6.2156971732E+00, 7.7980627888E-02, 7.4959038659E-02, 4.1593128008E-01],
	[6.6750000000E+03, 2.8112414551E+00, 6.2137617318E+00, 7.8162312054E-02, 7.5128445866E-02, 4.1613943846E-01],
	[6.6800000000E+03, 2.8137991794E+00, 6.2118283416E+00, 7.8344282912E-02, 7.5298098570E-02, 4.1634752187E-01],
	[6.6850000000E+03, 2.8163573143E+00, 6.2098969989E+00, 7.8526540700E-02, 7.5467996899E-02, 4.1655553055E-01],
	[6.6900000000E+03, 2.8189158597E+00, 6.2079677000E+00, 7.8709085656E-02, 7.5638140982E-02, 4.1676346478E-01],
	[6.6950000000E+03, 2.8214748153E+00, 6.2060404412E+00, 7.8891918017E-02, 7.5808530945E-02, 4.1697132482E-01],
	[6.7000000000E+03, 2.8240341809E+00, 6.2041152188E+00, 7.9075038019E-02, 7.5979166916E-02, 4.1717911092E-01],
	[6.7050000000E+03, 2.8265939563E+00, 6.2021920292E+00, 7.9258445900E-02, 7.6150049023E-02, 4.1738682335E-01],
	[6.7100000000E+03, 2.8291541411E+00, 6.2002708687E+00, 7.9442141897E-02, 7.6321177392E-02, 4.1759446236E-01],
	[6.7150000000E+03, 2.8317147353E+00, 6.1983517337E+00, 7.9626126247E-02, 7.6492552150E-02, 4.1780202822E-01],
	[6.7200000000E+03, 2.8342757384E+00, 6.1964346205E+00, 7.9810399187E-02, 7.6664173424E-02, 4.1800952119E-01],
	[6.7250000000E+03, 2.8368371504E+00, 6.1945195254E+00, 7.9994960956E-02, 7.6836041340E-02, 4.1821694152E-01],
	[6.7300000000E+03, 2.8393989708E+00, 6.1926064450E+00, 8.0179811789E-02, 7.7008156024E-02, 4.1842428944E-01],
	[6.7350000000E+03, 2.8419611996E+00, 6.1906953755E+00, 8.0364951924E-02, 7.7180517603E-02, 4.1863156516E-01],
	[6.7400000000E+03, 2.8445238365E+00, 6.1887863133E+00, 8.0550381599E-02, 7.7353126203E-02, 4.1883876892E-01],
	[6.7450000000E+03, 2.8470868812E+00, 6.1868792548E+00, 8.0736101050E-02, 7.7525981948E-02, 4.1904590092E-01],
	[6.7500000000E+03, 2.8496503335E+00, 6.1849741966E+00, 8.0922110516E-02, 7.7699084965E-02, 4.1925296137E-01],
	[6.7550000000E+03, 2.8522141932E+00, 6.1830711349E+00, 8.1108410233E-02, 7.7872435378E-02, 4.1945995050E-01],
	[6.7600000000E+03, 2.8547784600E+00, 6.1811700662E+00, 8.1295000439E-02, 7.8046033314E-02, 4.1966686853E-01],
	[6.7650000000E+03, 2.8573431337E+00, 6.1792709870E+00, 8.1481881371E-02, 7.8219878895E-02, 4.1987371566E-01],
	[6.7700000000E+03, 2.8599082140E+00, 6.1773738937E+00, 8.1669053267E-02, 7.8393972249E-02, 4.2008049211E-01],
	[6.7750000000E+03, 2.8624762045E+00, 6.1754952031E+00, 8.1856516364E-02, 7.8568318042E-02, 4.2028719809E-01],
	[6.7800000000E+03, 2.8650470523E+00, 6.1736345076E+00, 8.2044270899E-02, 7.8742916349E-02, 4.2049383383E-01],
	[6.7850000000E+03, 2.8676183112E+00, 6.1717757438E+00, 8.2232317110E-02, 7.8917762870E-02, 4.2070039954E-01],
	[6.7900000000E+03, 2.8701899811E+00, 6.1699189083E+00, 8.2420655234E-02, 7.9092857730E-02, 4.2090689542E-01],
	[6.7950000000E+03, 2.8727620616E+00, 6.1680639977E+00, 8.2609285510E-02, 7.9268201053E-02, 4.2111332170E-01],
	[6.8000000000E+03, 2.8753345527E+00, 6.1662110085E+00, 8.2798208173E-02, 7.9443792962E-02, 4.2131967859E-01],
	[6.8050000000E+03, 2.8779074539E+00, 6.1643599373E+00, 8.2987423463E-02, 7.9619633580E-02, 4.2152596630E-01],
	[6.8100000000E+03, 2.8804807652E+00, 6.1625107808E+00, 8.3176931616E-02, 7.9795723033E-02, 4.2173218504E-01],
	[6.8150000000E+03, 2.8830544861E+00, 6.1606635356E+00, 8.3366732870E-02, 7.9972061441E-02, 4.2193833503E-01],
	[6.8200000000E+03, 2.8856286166E+00, 6.1588181982E+00, 8.3556827463E-02, 8.0148648930E-02, 4.2214441649E-01],
	[6.8250000000E+03, 2.8882031564E+00, 6.1569747654E+00, 8.3747215631E-02, 8.0325485621E-02, 4.2235042961E-01],
	[6.8300000000E+03, 2.8907781053E+00, 6.1551332338E+00, 8.3937897614E-02, 8.0502571638E-02, 4.2255637463E-01],
	[6.8350000000E+03, 2.8933534629E+00, 6.1532936000E+00, 8.4128873648E-02, 8.0679907102E-02, 4.2276225174E-01],
	[6.8400000000E+03, 2.8959292291E+00, 6.1514558606E+00, 8.4320143971E-02, 8.0857492136E-02, 4.2296806116E-01],
	[6.8450000000E+03, 2.8985054037E+00, 6.1496200124E+00, 8.4511708820E-02, 8.1035326862E-02, 4.2317380310E-01],
	[6.8500000000E+03, 2.9010819864E+00, 6.1477860520E+00, 8.4703568434E-02, 8.1213411401E-02, 4.2337947777E-01],
	[6.8550000000E+03, 2.9036589769E+00, 6.1459539761E+00, 8.4895723050E-02, 8.1391745877E-02, 4.2358508539E-01],
	[6.8600000000E+03, 2.9062363751E+00, 6.1441237814E+00, 8.5088172906E-02, 8.1570330409E-02, 4.2379062616E-01],
	[6.8650000000E+03, 2.9088141807E+00, 6.1422954646E+00, 8.5280918240E-02, 8.1749165120E-02, 4.2399610030E-01],
	[6.8700000000E+03, 2.9113923935E+00, 6.1404690224E+00, 8.5473959289E-02, 8.1928250130E-02, 4.2420150802E-01],
	[6.8750000000E+03, 2.9139710132E+00, 6.1386444515E+00, 8.5667296291E-02, 8.2107585560E-02, 4.2440684952E-01],
	[6.8800000000E+03, 2.9165500397E+00, 6.1368217487E+00, 8.5860929484E-02, 8.2287171531E-02, 4.2461212502E-01],
	[6.8850000000E+03, 2.9191327303E+00, 6.1350226036E+00, 8.6054859105E-02, 8.2467014683E-02, 4.2481733472E-01],
	[6.8900000000E+03, 2.9217172261E+00, 6.1332345736E+00, 8.6249085393E-02, 8.2647111469E-02, 4.2502247884E-01],
	[6.8950000000E+03, 2.9243021327E+00, 6.1314483611E+00, 8.6443608585E-02, 8.2827459228E-02, 4.2522755759E-01],
	[6.9000000000E+03, 2.9268874500E+00, 6.1296639632E+00, 8.6638428920E-02, 8.3008058080E-02, 4.2543257117E-01],
	[6.9050000000E+03, 2.9294731777E+00, 6.1278813765E+00, 8.6833546635E-02, 8.3188908146E-02, 4.2563751979E-01],
	[6.9100000000E+03, 2.9320593156E+00, 6.1261005980E+00, 8.7028961967E-02, 8.3370009546E-02, 4.2584240367E-01],
	[6.9150000000E+03, 2.9346458634E+00, 6.1243216246E+00, 8.7224675156E-02, 8.3551362398E-02, 4.2604722300E-01],
	[6.9200000000E+03, 2.9372328209E+00, 6.1225444530E+00, 8.7420686438E-02, 8.3732966823E-02, 4.2625197801E-01],
	[6.9250000000E+03, 2.9398201879E+00, 6.1207690802E+00, 8.7616996052E-02, 8.3914822939E-02, 4.2645666889E-01],
	[6.9300000000E+03, 2.9424079641E+00, 6.1189955030E+00, 8.7813604236E-02, 8.4096930866E-02, 4.2666129586E-01],
	[6.9350000000E+03, 2.9449961494E+00, 6.1172237184E+00, 8.8010511228E-02, 8.4279290722E-02, 4.2686585913E-01],
	[6.9400000000E+03, 2.9475847434E+00, 6.1154537232E+00, 8.8207717265E-02, 8.4461902626E-02, 4.2707035889E-01],
	[6.9450000000E+03, 2.9501737460E+00, 6.1136855144E+00, 8.8405222586E-02, 8.4644766696E-02, 4.2727479536E-01],
	[6.9500000000E+03, 2.9527631570E+00, 6.1119190888E+00, 8.8603027429E-02, 8.4827883051E-02, 4.2747916875E-01],
	[6.9550000000E+03, 2.9553529760E+00, 6.1101544434E+00, 8.8801132032E-02, 8.5011251809E-02, 4.2768347925E-01],
	[6.9600000000E+03, 2.9579432029E+00, 6.1083915751E+00, 8.8999536632E-02, 8.5194873086E-02, 4.2788772709E-01],
	[6.9650000000E+03, 2.9605338374E+00, 6.1066304808E+00, 8.9198241469E-02, 8.5378747002E-02, 4.2809191246E-01],
	[6.9700000000E+03, 2.9631248793E+00, 6.1048711575E+00, 8.9397246780E-02, 8.5562873673E-02, 4.2829603557E-01],
	[6.9750000000E+03, 2.9657163285E+00, 6.1031136022E+00, 8.9596552802E-02, 8.5747253216E-02, 4.2850009663E-01],
	[6.9800000000E+03, 2.9683081845E+00, 6.1013578117E+00, 8.9796159776E-02, 8.5931885749E-02, 4.2870409585E-01],
	[6.9850000000E+03, 2.9709004473E+00, 6.0996037831E+00, 8.9996067938E-02, 8.6116771388E-02, 4.2890803342E-01],
	[6.9900000000E+03, 2.9734931166E+00, 6.0978515133E+00, 9.0196277526E-02, 8.6301910250E-02, 4.2911190956E-01],
	[6.9950000000E+03, 2.9760885704E+00, 6.0961170709E+00, 9.0396788780E-02, 8.6487307695E-02, 4.2931572446E-01],
	[7.0000000000E+03, 2.9786864301E+00, 6.0943978430E+00, 9.0597601936E-02, 8.6672963052E-02, 4.2951947835E-01],
	[7.0050000000E+03, 2.9812847001E+00, 6.0926803269E+00, 9.0800214186E-02, 8.6860241915E-02, 4.2972317141E-01],
	[7.0100000000E+03, 2.9838833802E+00, 6.0909645198E+00, 9.1003134443E-02, 8.7047779275E-02, 4.2992680386E-01],
	[7.0150000000E+03, 2.9864824702E+00, 6.0892504189E+00, 9.1206362953E-02, 8.7235575254E-02, 4.3013037590E-01],
	[7.0200000000E+03, 2.9890819698E+00, 6.0875380210E+00, 9.1409899966E-02, 8.7423629972E-02, 4.3033388773E-01],
	[7.0250000000E+03, 2.9916818788E+00, 6.0858273235E+00, 9.1613745728E-02, 8.7611943552E-02, 4.3053733956E-01],
	[7.0300000000E+03, 2.9942821970E+00, 6.0841183233E+00, 9.1817900488E-02, 8.7800516114E-02, 4.3074073159E-01],
	[7.0350000000E+03, 2.9968829241E+00, 6.0824110176E+00, 9.2022364494E-02, 8.7989347780E-02, 4.3094406403E-01],
	[7.0400000000E+03, 2.9994840600E+00, 6.0807054035E+00, 9.2227137994E-02, 8.8178438669E-02, 4.3114733708E-01],
	[7.0450000000E+03, 3.0020856043E+00, 6.0790014781E+00, 9.2432221236E-02, 8.8367788904E-02, 4.3135055095E-01],
	[7.0500000000E+03, 3.0046875570E+00, 6.0772992385E+00, 9.2637614468E-02, 8.8557398603E-02, 4.3155370583E-01],
	[7.0550000000E+03, 3.0072899177E+00, 6.0755986820E+00, 9.2843317937E-02, 8.8747267888E-02, 4.3175680193E-01],
	[7.0600000000E+03, 3.0098926862E+00, 6.0738998055E+00, 9.3049331893E-02, 8.8937396877E-02, 4.3195983945E-01],
	[7.0650000000E+03, 3.0124958623E+00, 6.0722026064E+00, 9.3255656583E-02, 8.9127785691E-02, 4.3216281860E-01],
	[7.0700000000E+03, 3.0150994458E+00, 6.0705070817E+00, 9.3462292256E-02, 8.9318434450E-02, 4.3236573958E-01],
	[7.0750000000E+03, 3.0177034364E+00, 6.0688132286E+00, 9.3669239158E-02, 8.9509343271E-02, 4.3256860259E-01],
	[7.0800000000E+03, 3.0203078340E+00, 6.0671210443E+00, 9.3876497540E-02, 8.9700512275E-02, 4.3277140784E-01],
	[7.0850000000E+03, 3.0229126383E+00, 6.0654305260E+00, 9.4084067648E-02, 8.9891941581E-02, 4.3297415552E-01],
	[7.0900000000E+03, 3.0255178491E+00, 6.0637416708E+00, 9.4291949732E-02, 9.0083631306E-02, 4.3317684582E-01],
	[7.0950000000E+03, 3.0281234661E+00, 6.0620544759E+00, 9.4500144039E-02, 9.0275581569E-02, 4.3337947891E-01],
	[7.1000000000E+03, 3.0307294891E+00, 6.0603689386E+00, 9.4708650818E-02, 9.0467792489E-02, 4.3358205493E-01],
	[7.1050000000E+03, 3.0333360460E+00, 6.0586859148E+00, 9.4917470316E-02, 9.0660264489E-02, 4.3378457407E-01],
	[7.1100000000E+03, 3.0359470922E+00, 6.0570319114E+00, 9.5126602783E-02, 9.0853007200E-02, 4.3398703646E-01],
	[7.1150000000E+03, 3.0385585481E+00, 6.0553795218E+00, 9.5336048466E-02, 9.1046010995E-02, 4.3418944229E-01],
	[7.1200000000E+03, 3.0411704134E+00, 6.0537287433E+00, 9.5545807615E-02, 9.1239275995E-02, 4.3439179170E-01],
	[7.1250000000E+03, 3.0437826879E+00, 6.0520795732E+00, 9.5755880476E-02, 9.1432802315E-02, 4.3459408485E-01],
	[7.1300000000E+03, 3.0463953714E+00, 6.0504320088E+00, 9.5966267300E-02, 9.1626590073E-02, 4.3479632192E-01],
	[7.1350000000E+03, 3.0490084636E+00, 6.0487860475E+00, 9.6176968333E-02, 9.1820639386E-02, 4.3499850305E-01],
	[7.1400000000E+03, 3.0516219643E+00, 6.0471416864E+00, 9.6387983826E-02, 9.2014950371E-02, 4.3520062841E-01],
	[7.1450000000E+03, 3.0542358734E+00, 6.0454989231E+00, 9.6599314025E-02, 9.2209523145E-02, 4.3540269816E-01],
	[7.1500000000E+03, 3.0568501905E+00, 6.0438577547E+00, 9.6810959180E-02, 9.2404357823E-02, 4.3560471247E-01],
	[7.1550000000E+03, 3.0594649155E+00, 6.0422181786E+00, 9.7022919539E-02, 9.2599454523E-02, 4.3580667148E-01],
	[7.1600000000E+03, 3.0620800481E+00, 6.0405801923E+00, 9.7235195350E-02, 9.2794813360E-02, 4.3600857536E-01],
	[7.1650000000E+03, 3.0646955882E+00, 6.0389437929E+00, 9.7447786863E-02, 9.2990434449E-02, 4.3621042427E-01],
	[7.1700000000E+03, 3.0673115355E+00, 6.0373089779E+00, 9.7660694325E-02, 9.3186317907E-02, 4.3641221837E-01],
	[7.1750000000E+03, 3.0699278897E+00, 6.0356757447E+00, 9.7873917986E-02, 9.3382463849E-02, 4.3661395781E-01],
	[7.1800000000E+03, 3.0725446507E+00, 6.0340440906E+00, 9.8087458094E-02, 9.3578872389E-02, 4.3681564277E-01],
	[7.1850000000E+03, 3.0751618182E+00, 6.0324140129E+00, 9.8301314898E-02, 9.3775543643E-02, 4.3701727339E-01],
	[7.1900000000E+03, 3.0777793920E+00, 6.0307855092E+00, 9.8515488646E-02, 9.3972477725E-02, 4.3721884985E-01],
	[7.1950000000E+03, 3.0803973720E+00, 6.0291585766E+00, 9.8729979586E-02, 9.4169674750E-02, 4.3742037228E-01],
	[7.2000000000E+03, 3.0830157578E+00, 6.0275332128E+00, 9.8944787969E-02, 9.4367134832E-02, 4.3762184087E-01],
	[7.2050000000E+03, 3.0856345492E+00, 6.0259094150E+00, 9.9159914042E-02, 9.4564858085E-02, 4.3782325576E-01],
	[7.2100000000E+03, 3.0882537462E+00, 6.0242871806E+00, 9.9375358054E-02, 9.4762844623E-02, 4.3802461711E-01],
	[7.2150000000E+03, 3.0908733483E+00, 6.0226665071E+00, 9.9591120254E-02, 9.4961094560E-02, 4.3822592508E-01],
	[7.2200000000E+03, 3.0934939868E+00, 6.0210515661E+00, 9.9807200891E-02, 9.5159609648E-02, 4.3842717984E-01],
	[7.2250000000E+03, 3.0961184816E+00, 6.0194609646E+00, 1.0002360021E-01, 9.5358397366E-02, 4.3862838154E-01],
	[7.2300000000E+03, 3.0987433850E+00, 6.0178718833E+00, 1.0024031847E-01, 9.5557448900E-02, 4.3882953033E-01],
	[7.2350000000E+03, 3.1013686969E+00, 6.0162843196E+00, 1.0045735591E-01, 9.5756764364E-02, 4.3903062638E-01],
	[7.2400000000E+03, 3.1039944171E+00, 6.0146982711E+00, 1.0067471278E-01, 9.5956343870E-02, 4.3923166985E-01],
	[7.2450000000E+03, 3.1066205452E+00, 6.0131137352E+00, 1.0089238934E-01, 9.6156187531E-02, 4.3943266089E-01],
	[7.2500000000E+03, 3.1092470811E+00, 6.0115307095E+00, 1.0111038582E-01, 9.6356295459E-02, 4.3963359966E-01],
	[7.2550000000E+03, 3.1118740245E+00, 6.0099491915E+00, 1.0132870248E-01, 9.6556667767E-02, 4.3983448632E-01],
	[7.2600000000E+03, 3.1145013753E+00, 6.0083691787E+00, 1.0154733957E-01, 9.6757304566E-02, 4.4003532103E-01],
	[7.2650000000E+03, 3.1171291333E+00, 6.0067906686E+00, 1.0176629734E-01, 9.6958205969E-02, 4.4023610395E-01],
	[7.2700000000E+03, 3.1197572981E+00, 6.0052136588E+00, 1.0198557603E-01, 9.7159372087E-02, 4.4043683523E-01],
	[7.2750000000E+03, 3.1223858697E+00, 6.0036381468E+00, 1.0220517590E-01, 9.7360803030E-02, 4.4063751503E-01],
	[7.2800000000E+03, 3.1250148477E+00, 6.0020641303E+00, 1.0242509719E-01, 9.7562498911E-02, 4.4083814351E-01],
	[7.2850000000E+03, 3.1276442320E+00, 6.0004916066E+00, 1.0264534016E-01, 9.7764459840E-02, 4.4103872082E-01],
	[7.2900000000E+03, 3.1302740223E+00, 5.9989205734E+00, 1.0286590505E-01, 9.7966685928E-02, 4.4123924713E-01],
	[7.2950000000E+03, 3.1329042185E+00, 5.9973510283E+00, 1.0308679211E-01, 9.8169177285E-02, 4.4143972259E-01],
	[7.3000000000E+03, 3.1355348203E+00, 5.9957829689E+00, 1.0330800158E-01, 9.8371934021E-02, 4.4164014736E-01],
	[7.3050000000E+03, 3.1381658275E+00, 5.9942163926E+00, 1.0352953373E-01, 9.8574956246E-02, 4.4184052159E-01],
	[7.3100000000E+03, 3.1407972399E+00, 5.9926512971E+00, 1.0375138880E-01, 9.8778244071E-02, 4.4204084545E-01],
	[7.3150000000E+03, 3.1434290572E+00, 5.9910876800E+00, 1.0397356704E-01, 9.8981797604E-02, 4.4224111908E-01],
	[7.3200000000E+03, 3.1460612793E+00, 5.9895255389E+00, 1.0419606869E-01, 9.9185616956E-02, 4.4244134266E-01],
	[7.3250000000E+03, 3.1486939059E+00, 5.9879648713E+00, 1.0441889401E-01, 9.9389702234E-02, 4.4264151632E-01],
	[7.3300000000E+03, 3.1513269369E+00, 5.9864056750E+00, 1.0464204325E-01, 9.9594053549E-02, 4.4284164024E-01],
	[7.3350000000E+03, 3.1539603720E+00, 5.9848479474E+00, 1.0486551665E-01, 9.9798671008E-02, 4.4304171456E-01],
	[7.3400000000E+03, 3.1565978102E+00, 5.9833151334E+00, 1.0508931446E-01, 1.0000356488E-01, 4.4324173945E-01],
	[7.3450000000E+03, 3.1592360084E+00, 5.9817860508E+00, 1.0531343694E-01, 1.0020872619E-01, 4.4344171506E-01],
	[7.3500000000E+03, 3.1618746140E+00, 5.9802583991E+00, 1.0553788433E-01, 1.0041415405E-01, 4.4364164154E-01],
	[7.3550000000E+03, 3.1645136267E+00, 5.9787321760E+00, 1.0576265689E-01, 1.0061984857E-01, 4.4384151906E-01],
	[7.3600000000E+03, 3.1671530464E+00, 5.9772073792E+00, 1.0598775485E-01, 1.0082580985E-01, 4.4404134776E-01],
	[7.3650000000E+03, 3.1697928729E+00, 5.9756840064E+00, 1.0621317848E-01, 1.0103203801E-01, 4.4424112781E-01],
	[7.3700000000E+03, 3.1724331058E+00, 5.9741620553E+00, 1.0643892802E-01, 1.0123853316E-01, 4.4444085936E-01],
	[7.3750000000E+03, 3.1750737451E+00, 5.9726415236E+00, 1.0666500372E-01, 1.0144529539E-01, 4.4464054257E-01],
	[7.3800000000E+03, 3.1777147905E+00, 5.9711224090E+00, 1.0689140583E-01, 1.0165232481E-01, 4.4484017760E-01],
	[7.3850000000E+03, 3.1803562417E+00, 5.9696047093E+00, 1.0711813460E-01, 1.0185962154E-01, 4.4503976459E-01],
	[7.3900000000E+03, 3.1829980986E+00, 5.9680884222E+00, 1.0734519027E-01, 1.0206718568E-01, 4.4523930371E-01],
	[7.3950000000E+03, 3.1856403610E+00, 5.9665735453E+00, 1.0757257311E-01, 1.0227501734E-01, 4.4543879511E-01],
	[7.4000000000E+03, 3.1882830286E+00, 5.9650600766E+00, 1.0780028335E-01, 1.0248311661E-01, 4.4563823894E-01],
	[7.4050000000E+03, 3.1909261013E+00, 5.9635480136E+00, 1.0802832125E-01, 1.0269148362E-01, 4.4583763537E-01],
	[7.4100000000E+03, 3.1935695788E+00, 5.9620373541E+00, 1.0825668706E-01, 1.0290011846E-01, 4.4603698454E-01],
	[7.4150000000E+03, 3.1962134609E+00, 5.9605280959E+00, 1.0848538102E-01, 1.0310902124E-01, 4.4623628662E-01],
	[7.4200000000E+03, 3.1988577474E+00, 5.9590202367E+00, 1.0871440339E-01, 1.0331819206E-01, 4.4643554176E-01],
	[7.4250000000E+03, 3.2015024381E+00, 5.9575137744E+00, 1.0894375442E-01, 1.0352763103E-01, 4.4663475011E-01],
	[7.4300000000E+03, 3.2041475328E+00, 5.9560087066E+00, 1.0917343435E-01, 1.0373733825E-01, 4.4683391183E-01],
	[7.4350000000E+03, 3.2067930313E+00, 5.9545050311E+00, 1.0940344344E-01, 1.0394731384E-01, 4.4703302707E-01],
	[7.4400000000E+03, 3.2094389333E+00, 5.9530027458E+00, 1.0963378193E-01, 1.0415755788E-01, 4.4723209593E-01],
	[7.4450000000E+03, 3.2120852387E+00, 5.9515018484E+00, 1.0986445008E-01, 1.0436807050E-01, 4.4743111854E-01],
	[7.4500000000E+03, 3.2147319472E+00, 5.9500023366E+00, 1.1009544814E-01, 1.0457885178E-01, 4.4763009501E-01],
	[7.4550000000E+03, 3.2173801764E+00, 5.9485114001E+00, 1.1032677634E-01, 1.0478990526E-01, 4.4782902546E-01],
	[7.4600000000E+03, 3.2200315125E+00, 5.9470392096E+00, 1.1055843496E-01, 1.0500123592E-01, 4.4802791001E-01],
	[7.4650000000E+03, 3.2226832548E+00, 5.9455683694E+00, 1.1079042422E-01, 1.0521283566E-01, 4.4822674877E-01],
	[7.4700000000E+03, 3.2253354032E+00, 5.9440988774E+00, 1.1102274439E-01, 1.0542470456E-01, 4.4842554188E-01],
	[7.4750000000E+03, 3.2279879574E+00, 5.9426307316E+00, 1.1125539572E-01, 1.0563684273E-01, 4.4862428943E-01],
	[7.4800000000E+03, 3.2306409172E+00, 5.9411639297E+00, 1.1148837845E-01, 1.0584925028E-01, 4.4882299156E-01],
	[7.4850000000E+03, 3.2332942824E+00, 5.9396984696E+00, 1.1172169283E-01, 1.0606192730E-01, 4.4902164837E-01],
	[7.4900000000E+03, 3.2359480528E+00, 5.9382343493E+00, 1.1195533912E-01, 1.0627487390E-01, 4.4922025999E-01],
	[7.4950000000E+03, 3.2386022282E+00, 5.9367715666E+00, 1.1218931756E-01, 1.0648809018E-01, 4.4941882654E-01],
	[7.5000000000E+03, 3.2412568084E+00, 5.9353101193E+00, 1.1242362840E-01, 1.0670157625E-01, 4.4961734814E-01],
	[7.5050000000E+03, 3.2439117931E+00, 5.9338500054E+00, 1.1265827190E-01, 1.0691533220E-01, 4.4981582489E-01],
	[7.5100000000E+03, 3.2465671822E+00, 5.9323912228E+00, 1.1289324830E-01, 1.0712935814E-01, 4.5001425692E-01],
	[7.5150000000E+03, 3.2492229754E+00, 5.9309337694E+00, 1.1312855786E-01, 1.0734365417E-01, 4.5021264435E-01],
	[7.5200000000E+03, 3.2518791726E+00, 5.9294776431E+00, 1.1336420082E-01, 1.0755822038E-01, 4.5041098730E-01],
	[7.5250000000E+03, 3.2545357736E+00, 5.9280228417E+00, 1.1360017743E-01, 1.0777305689E-01, 4.5060928588E-01],
	[7.5300000000E+03, 3.2571927780E+00, 5.9265693632E+00, 1.1383648795E-01, 1.0798816378E-01, 4.5080754021E-01],
	[7.5350000000E+03, 3.2598501858E+00, 5.9251172056E+00, 1.1407313262E-01, 1.0820354117E-01, 4.5100575040E-01],
	[7.5400000000E+03, 3.2625079968E+00, 5.9236663667E+00, 1.1431011170E-01, 1.0841918914E-01, 4.5120391659E-01],
	[7.5450000000E+03, 3.2651662106E+00, 5.9222168445E+00, 1.1454742543E-01, 1.0863510781E-01, 4.5140203888E-01],
	[7.5500000000E+03, 3.2678248271E+00, 5.9207686369E+00, 1.1478507407E-01, 1.0885129726E-01, 4.5160011739E-01],
	[7.5550000000E+03, 3.2704838462E+00, 5.9193217419E+00, 1.1502305786E-01, 1.0906775761E-01, 4.5179815224E-01],
	[7.5600000000E+03, 3.2731432675E+00, 5.9178761574E+00, 1.1526137706E-01, 1.0928448895E-01, 4.5199614355E-01],
	[7.5650000000E+03, 3.2758030909E+00, 5.9164318813E+00, 1.1550003191E-01, 1.0950149137E-01, 4.5219409143E-01],
	[7.5700000000E+03, 3.2784633162E+00, 5.9149889116E+00, 1.1573902267E-01, 1.0971876498E-01, 4.5239199600E-01],
	[7.5750000000E+03, 3.2811250284E+00, 5.9135541437E+00, 1.1597834959E-01, 1.0993631347E-01, 4.5258985739E-01],
	[7.5800000000E+03, 3.2837897467E+00, 5.9121372012E+00, 1.1621801291E-01, 1.1015414205E-01, 4.5278767570E-01],
	[7.5850000000E+03, 3.2864548699E+00, 5.9107215323E+00, 1.1645801289E-01, 1.1037224219E-01, 4.5298545106E-01],
	[7.5900000000E+03, 3.2891203976E+00, 5.9093071348E+00, 1.1669834978E-01, 1.1059061400E-01, 4.5318318358E-01],
	[7.5950000000E+03, 3.2917863297E+00, 5.9078940070E+00, 1.1693902382E-01, 1.1080925757E-01, 4.5338087339E-01],
	[7.6000000000E+03, 3.2944526661E+00, 5.9064821467E+00, 1.1718003528E-01, 1.1102817300E-01, 4.5357852059E-01],
	[7.6050000000E+03, 3.2971194064E+00, 5.9050715521E+00, 1.1742138439E-01, 1.1124736040E-01, 4.5377612530E-01],
	[7.6100000000E+03, 3.2997865506E+00, 5.9036622211E+00, 1.1766307141E-01, 1.1146681985E-01, 4.5397368765E-01],
	[7.6150000000E+03, 3.3024540983E+00, 5.9022541518E+00, 1.1790509659E-01, 1.1168655145E-01, 4.5417120775E-01],
	[7.6200000000E+03, 3.3051220495E+00, 5.9008473422E+00, 1.1814746018E-01, 1.1190655530E-01, 4.5436868572E-01],
	[7.6250000000E+03, 3.3077904038E+00, 5.8994417905E+00, 1.1839016243E-01, 1.1212683150E-01, 4.5456612167E-01],
	[7.6300000000E+03, 3.3104591611E+00, 5.8980374946E+00, 1.1863320359E-01, 1.1234738014E-01, 4.5476351572E-01],
	[7.6350000000E+03, 3.3131283211E+00, 5.8966344525E+00, 1.1887658392E-01, 1.1256820133E-01, 4.5496086800E-01],
	[7.6400000000E+03, 3.3157978838E+00, 5.8952326624E+00, 1.1912030365E-01, 1.1278929515E-01, 4.5515817861E-01],
	[7.6450000000E+03, 3.3184678488E+00, 5.8938321224E+00, 1.1936436305E-01, 1.1301066169E-01, 4.5535544768E-01],
	[7.6500000000E+03, 3.3211382160E+00, 5.8924328304E+00, 1.1960876237E-01, 1.1323230107E-01, 4.5555267532E-01],
	[7.6550000000E+03, 3.3238089852E+00, 5.8910347846E+00, 1.1985350184E-01, 1.1345421336E-01, 4.5574986164E-01],
	[7.6600000000E+03, 3.3264801561E+00, 5.8896379830E+00, 1.2009858173E-01, 1.1367639868E-01, 4.5594700678E-01],
	[7.6650000000E+03, 3.3291517286E+00, 5.8882424238E+00, 1.2034400229E-01, 1.1389885710E-01, 4.5614411084E-01],
	[7.6700000000E+03, 3.3318237024E+00, 5.8868481049E+00, 1.2058976377E-01, 1.1412158873E-01, 4.5634117394E-01],
	[7.6750000000E+03, 3.3344960774E+00, 5.8854550245E+00, 1.2083586641E-01, 1.1434459366E-01, 4.5653819620E-01],
	[7.6800000000E+03, 3.3371688534E+00, 5.8840631808E+00, 1.2108231046E-01, 1.1456787198E-01, 4.5673517773E-01],
	[7.6850000000E+03, 3.3398420301E+00, 5.8826725717E+00, 1.2132909619E-01, 1.1479142379E-01, 4.5693211866E-01],
	[7.6900000000E+03, 3.3425156074E+00, 5.8812831954E+00, 1.2157622384E-01, 1.1501524918E-01, 4.5712901909E-01],
	[7.6950000000E+03, 3.3451895851E+00, 5.8798950500E+00, 1.2182369365E-01, 1.1523934825E-01, 4.5732587916E-01],
	[7.7000000000E+03, 3.3478671971E+00, 5.8785284474E+00, 1.2207150589E-01, 1.1546373276E-01, 4.5752269896E-01],
	[7.7050000000E+03, 3.3505455337E+00, 5.8771650673E+00, 1.2231966080E-01, 1.1568839239E-01, 4.5771947863E-01],
	[7.7100000000E+03, 3.3532242735E+00, 5.8758028875E+00, 1.2256815863E-01, 1.1591332605E-01, 4.5791621828E-01],
	[7.7150000000E+03, 3.3559034162E+00, 5.8744419062E+00, 1.2281699963E-01, 1.1613853385E-01, 4.5811291803E-01],
	[7.7200000000E+03, 3.3585829616E+00, 5.8730821216E+00, 1.2306618406E-01, 1.1636401588E-01, 4.5830957798E-01],
	[7.7250000000E+03, 3.3612629096E+00, 5.8717235318E+00, 1.2331571217E-01, 1.1658977223E-01, 4.5850619827E-01],
	[7.7300000000E+03, 3.3639432599E+00, 5.8703661351E+00, 1.2356558420E-01, 1.1681580298E-01, 4.5870277900E-01],
	[7.7350000000E+03, 3.3666240123E+00, 5.8690099296E+00, 1.2381580041E-01, 1.1704210825E-01, 4.5889932030E-01],
	[7.7400000000E+03, 3.3693051667E+00, 5.8676549135E+00, 1.2406636104E-01, 1.1726868810E-01, 4.5909582228E-01],
	[7.7450000000E+03, 3.3719867228E+00, 5.8663010850E+00, 1.2431726636E-01, 1.1749554265E-01, 4.5929228506E-01],
	[7.7500000000E+03, 3.3746686804E+00, 5.8649484423E+00, 1.2456851660E-01, 1.1772267196E-01, 4.5948870875E-01],
	[7.7550000000E+03, 3.3773510393E+00, 5.8635969835E+00, 1.2482011203E-01, 1.1795007615E-01, 4.5968509348E-01],
	[7.7600000000E+03, 3.3800337994E+00, 5.8622467070E+00, 1.2507205289E-01, 1.1817775530E-01, 4.5988143936E-01],
	[7.7650000000E+03, 3.3827169604E+00, 5.8608976108E+00, 1.2532433944E-01, 1.1840570950E-01, 4.6007774649E-01],
	[7.7700000000E+03, 3.3854005222E+00, 5.8595496932E+00, 1.2557697191E-01, 1.1863393883E-01, 4.6027401496E-01],
	[7.7750000000E+03, 3.3880844845E+00, 5.8582029524E+00, 1.2582995058E-01, 1.1886244339E-01, 4.6047024486E-01],
	[7.7800000000E+03, 3.3907688471E+00, 5.8568573867E+00, 1.2608327568E-01, 1.1909122328E-01, 4.6066643626E-01],
	[7.7850000000E+03, 3.3934536099E+00, 5.8555129941E+00, 1.2633694747E-01, 1.1932027857E-01, 4.6086258925E-01],
	[7.7900000000E+03, 3.3961387726E+00, 5.8541697731E+00, 1.2659096620E-01, 1.1954960936E-01, 4.6105870392E-01],
	[7.7950000000E+03, 3.3988243351E+00, 5.8528277218E+00, 1.2684533212E-01, 1.1977921573E-01, 4.6125478035E-01],
	[7.8000000000E+03, 3.4015102971E+00, 5.8514868384E+00, 1.2710004548E-01, 1.2000909778E-01, 4.6145081863E-01],
	[7.8050000000E+03, 3.4041966585E+00, 5.8501471211E+00, 1.2735510653E-01, 1.2023925559E-01, 4.6164681883E-01],
	[7.8100000000E+03, 3.4068834190E+00, 5.8488085683E+00, 1.2761051553E-01, 1.2046968926E-01, 4.6184278105E-01],
	[7.8150000000E+03, 3.4095705785E+00, 5.8474711781E+00, 1.2786627272E-01, 1.2070039886E-01, 4.6203870538E-01],
	[7.8200000000E+03, 3.4122585894E+00, 5.8461377652E+00, 1.2812237836E-01, 1.2093138627E-01, 4.6223459188E-01],
	[7.8250000000E+03, 3.4149499686E+00, 5.8448239655E+00, 1.2837883270E-01, 1.2116266147E-01, 4.6243044066E-01],
	[7.8300000000E+03, 3.4176417493E+00, 5.8435113000E+00, 1.2863563599E-01, 1.2139421296E-01, 4.6262625179E-01],
	[7.8350000000E+03, 3.4203339315E+00, 5.8421997670E+00, 1.2889278848E-01, 1.2162604084E-01, 4.6282202536E-01],
	[7.8400000000E+03, 3.4230265148E+00, 5.8408893647E+00, 1.2915029042E-01, 1.2185814518E-01, 4.6301776146E-01],
	[7.8450000000E+03, 3.4257194991E+00, 5.8395800916E+00, 1.2940814207E-01, 1.2209052608E-01, 4.6321346017E-01],
	[7.8500000000E+03, 3.4284128842E+00, 5.8382719458E+00, 1.2966634367E-01, 1.2232318363E-01, 4.6340912157E-01],
	[7.8550000000E+03, 3.4311066699E+00, 5.8369649258E+00, 1.2992489548E-01, 1.2255611790E-01, 4.6360474575E-01],
	[7.8600000000E+03, 3.4338008560E+00, 5.8356590297E+00, 1.3018379775E-01, 1.2278932898E-01, 4.6380033280E-01],
	[7.8650000000E+03, 3.4364954423E+00, 5.8343542561E+00, 1.3044305072E-01, 1.2302281697E-01, 4.6399588280E-01],
	[7.8700000000E+03, 3.4391904286E+00, 5.8330506031E+00, 1.3070265466E-01, 1.2325658194E-01, 4.6419139583E-01],
	[7.8750000000E+03, 3.4418858148E+00, 5.8317480691E+00, 1.3096260981E-01, 1.2349062398E-01, 4.6438687199E-01],
	[7.8800000000E+03, 3.4445816005E+00, 5.8304466524E+00, 1.3122291643E-01, 1.2372494318E-01, 4.6458231135E-01],
	[7.8850000000E+03, 3.4472777857E+00, 5.8291463514E+00, 1.3148357476E-01, 1.2395953962E-01, 4.6477771400E-01],
	[7.8900000000E+03, 3.4499743701E+00, 5.8278471643E+00, 1.3174458506E-01, 1.2419441339E-01, 4.6497308002E-01],
	[7.8950000000E+03, 3.4526713536E+00, 5.8265490896E+00, 1.3200594757E-01, 1.2442956457E-01, 4.6516840951E-01],
	[7.9000000000E+03, 3.4553687359E+00, 5.8252521256E+00, 1.3226766256E-01, 1.2466499325E-01, 4.6536370255E-01],
	[7.9050000000E+03, 3.4580665168E+00, 5.8239562706E+00, 1.3252973027E-01, 1.2490069950E-01, 4.6555895922E-01],
	[7.9100000000E+03, 3.4607646963E+00, 5.8226615230E+00, 1.3279215096E-01, 1.2513668342E-01, 4.6575417960E-01],
	[7.9150000000E+03, 3.4634632739E+00, 5.8213678812E+00, 1.3305492487E-01, 1.2537294508E-01, 4.6594936379E-01],
	[7.9200000000E+03, 3.4661622497E+00, 5.8200753434E+00, 1.3331805226E-01, 1.2560948458E-01, 4.6614451186E-01],
	[7.9250000000E+03, 3.4688616233E+00, 5.8187839081E+00, 1.3358153338E-01, 1.2584630199E-01, 4.6633962391E-01],
	[7.9300000000E+03, 3.4715613947E+00, 5.8174935736E+00, 1.3384536848E-01, 1.2608339739E-01, 4.6653470002E-01],
	[7.9350000000E+03, 3.4742615635E+00, 5.8162043382E+00, 1.3410955781E-01, 1.2632077087E-01, 4.6672974027E-01],
	[7.9400000000E+03, 3.4769621296E+00, 5.8149162005E+00, 1.3437410163E-01, 1.2655842252E-01, 4.6692474475E-01],
	[7.9450000000E+03, 3.4796630929E+00, 5.8136291586E+00, 1.3463900018E-01, 1.2679635241E-01, 4.6711971355E-01],
	[7.9500000000E+03, 3.4823676015E+00, 5.8123625817E+00, 1.3490425373E-01, 1.2703457406E-01, 4.6731464674E-01],
	[7.9550000000E+03, 3.4850726540E+00, 5.8110979638E+00, 1.3516986251E-01, 1.2727307483E-01, 4.6750954442E-01],
	[7.9600000000E+03, 3.4877781062E+00, 5.8098344154E+00, 1.3543582678E-01, 1.2751185418E-01, 4.6770440667E-01],
	[7.9650000000E+03, 3.4904839577E+00, 5.8085719349E+00, 1.3570214680E-01, 1.2775091220E-01, 4.6789923358E-01],
	[7.9700000000E+03, 3.4931902085E+00, 5.8073105208E+00, 1.3596882282E-01, 1.2799024896E-01, 4.6809402523E-01],
	[7.9750000000E+03, 3.4958968582E+00, 5.8060501715E+00, 1.3623585508E-01, 1.2822986455E-01, 4.6828878171E-01],
	[7.9800000000E+03, 3.4986039067E+00, 5.8047908854E+00, 1.3650324384E-01, 1.2846975904E-01, 4.6848350311E-01],
	[7.9850000000E+03, 3.5013113539E+00, 5.8035326609E+00, 1.3677098936E-01, 1.2870993252E-01, 4.6867818950E-01],
	[7.9900000000E+03, 3.5040191995E+00, 5.8022754965E+00, 1.3703909188E-01, 1.2895038507E-01, 4.6887284097E-01],
	[7.9950000000E+03, 3.5067274433E+00, 5.8010193907E+00, 1.3730755165E-01, 1.2919111677E-01, 4.6906745762E-01],
	[8.0000000000E+03, 3.5094360852E+00, 5.7997643418E+00, 1.3757636893E-01, 1.2943212769E-01, 4.6926203952E-01],
	[8.0050000000E+03, 3.5121451249E+00, 5.7985103484E+00, 1.3784726028E-01, 1.2967493676E-01, 4.6945658677E-01],
	[8.0100000000E+03, 3.5148545623E+00, 5.7972574089E+00, 1.3811851527E-01, 1.2991802964E-01, 4.6965109944E-01],
	[8.0150000000E+03, 3.5175643972E+00, 5.7960055217E+00, 1.3839013417E-01, 1.3016140640E-01, 4.6984557762E-01],
	[8.0200000000E+03, 3.5202746294E+00, 5.7947546853E+00, 1.3866211722E-01, 1.3040506713E-01, 4.7004002141E-01],
	[8.0250000000E+03, 3.5229852587E+00, 5.7935048982E+00, 1.3893446470E-01, 1.3064901192E-01, 4.7023443087E-01],
	[8.0300000000E+03, 3.5256962848E+00, 5.7922561589E+00, 1.3920717687E-01, 1.3089324084E-01, 4.7042880611E-01],
	[8.0350000000E+03, 3.5284077077E+00, 5.7910084657E+00, 1.3948025397E-01, 1.3113775398E-01, 4.7062314721E-01],
	[8.0400000000E+03, 3.5311195271E+00, 5.7897618172E+00, 1.3975369628E-01, 1.3138255141E-01, 4.7081745424E-01],
	[8.0450000000E+03, 3.5338317429E+00, 5.7885162119E+00, 1.4002750406E-01, 1.3162763323E-01, 4.7101172731E-01],
	[8.0500000000E+03, 3.5365443548E+00, 5.7872716482E+00, 1.4030167756E-01, 1.3187299951E-01, 4.7120596649E-01],
	[8.0550000000E+03, 3.5392573627E+00, 5.7860281247E+00, 1.4057621705E-01, 1.3211865033E-01, 4.7140017187E-01],
	[8.0600000000E+03, 3.5419707664E+00, 5.7847856397E+00, 1.4085112278E-01, 1.3236458578E-01, 4.7159434353E-01],
	[8.0650000000E+03, 3.5446845656E+00, 5.7835441919E+00, 1.4112639503E-01, 1.3261080592E-01, 4.7178848157E-01],
	[8.0700000000E+03, 3.5473987603E+00, 5.7823037796E+00, 1.4140203404E-01, 1.3285731086E-01, 4.7198258606E-01],
	[8.0750000000E+03, 3.5501145714E+00, 5.7810716617E+00, 1.4167804008E-01, 1.3310410622E-01, 4.7217665710E-01],
	[8.0800000000E+03, 3.5528328172E+00, 5.7798526760E+00, 1.4195441342E-01, 1.3335119588E-01, 4.7237069477E-01],
	[8.0850000000E+03, 3.5555514608E+00, 5.7786347012E+00, 1.4223115430E-01, 1.3359857066E-01, 4.7256469913E-01],
	[8.0900000000E+03, 3.5582705021E+00, 5.7774177358E+00, 1.4250826300E-01, 1.3384623065E-01, 4.7275867023E-01],
	[8.0950000000E+03, 3.5609899408E+00, 5.7762017784E+00, 1.4278573976E-01, 1.3409417591E-01, 4.7295260814E-01],
	[8.1000000000E+03, 3.5637097767E+00, 5.7749868275E+00, 1.4306358487E-01, 1.3434240654E-01, 4.7314651290E-01],
	[8.1050000000E+03, 3.5664300097E+00, 5.7737728816E+00, 1.4334179856E-01, 1.3459092260E-01, 4.7334038459E-01],
	[8.1100000000E+03, 3.5691506395E+00, 5.7725599394E+00, 1.4362038112E-01, 1.3483972419E-01, 4.7353422326E-01],
	[8.1150000000E+03, 3.5718716661E+00, 5.7713479993E+00, 1.4389933279E-01, 1.3508881137E-01, 4.7372802896E-01],
	[8.1200000000E+03, 3.5745930891E+00, 5.7701370599E+00, 1.4417865384E-01, 1.3533818422E-01, 4.7392180176E-01],
	[8.1250000000E+03, 3.5773149085E+00, 5.7689271197E+00, 1.4445834452E-01, 1.3558784283E-01, 4.7411554171E-01],
	[8.1300000000E+03, 3.5800371239E+00, 5.7677181774E+00, 1.4473840511E-01, 1.3583778726E-01, 4.7430924888E-01],
	[8.1350000000E+03, 3.5827597353E+00, 5.7665102315E+00, 1.4501883585E-01, 1.3608801761E-01, 4.7450292332E-01],
	[8.1400000000E+03, 3.5854827425E+00, 5.7653032806E+00, 1.4529963702E-01, 1.3633853393E-01, 4.7469656509E-01],
	[8.1450000000E+03, 3.5882061452E+00, 5.7640973231E+00, 1.4558080887E-01, 1.3658933632E-01, 4.7489017425E-01],
	[8.1500000000E+03, 3.5909299434E+00, 5.7628923578E+00, 1.4586235167E-01, 1.3684042485E-01, 4.7508375086E-01],
	[8.1550000000E+03, 3.5936541367E+00, 5.7616883832E+00, 1.4614426567E-01, 1.3709179959E-01, 4.7527729497E-01],
	[8.1600000000E+03, 3.5963787250E+00, 5.7604853978E+00, 1.4642655114E-01, 1.3734346062E-01, 4.7547080666E-01],
	[8.1650000000E+03, 3.5991037081E+00, 5.7592834003E+00, 1.4670920833E-01, 1.3759540801E-01, 4.7566428597E-01],
	[8.1700000000E+03, 3.6018290859E+00, 5.7580823891E+00, 1.4699223752E-01, 1.3784764185E-01, 4.7585773296E-01],
	[8.1750000000E+03, 3.6045548582E+00, 5.7568823630E+00, 1.4727563895E-01, 1.3810016220E-01, 4.7605114770E-01],
	[8.1800000000E+03, 3.6072810247E+00, 5.7556833205E+00, 1.4755941289E-01, 1.3835296915E-01, 4.7624453024E-01],
	[8.1850000000E+03, 3.6100075853E+00, 5.7544852602E+00, 1.4784355961E-01, 1.3860606276E-01, 4.7643788065E-01],
	[8.1900000000E+03, 3.6127345398E+00, 5.7532881807E+00, 1.4812807936E-01, 1.3885944311E-01, 4.7663119898E-01],
	[8.1950000000E+03, 3.6154618881E+00, 5.7520920805E+00, 1.4841297241E-01, 1.3911311028E-01, 4.7682448529E-01],
	[8.2000000000E+03, 3.6181896298E+00, 5.7508969584E+00, 1.4869823901E-01, 1.3936706434E-01, 4.7701773964E-01],
	[8.2050000000E+03, 3.6209190265E+00, 5.7497099035E+00, 1.4898387944E-01, 1.3962131142E-01, 4.7721096209E-01],
	[8.2100000000E+03, 3.6236508638E+00, 5.7485353074E+00, 1.4926989394E-01, 1.3987585542E-01, 4.7740415270E-01],
	[8.2150000000E+03, 3.6263830971E+00, 5.7473616661E+00, 1.4955628278E-01, 1.4013068664E-01, 4.7759731152E-01],
	[8.2200000000E+03, 3.6291157261E+00, 5.7461889783E+00, 1.4984304622E-01, 1.4038580515E-01, 4.7779043863E-01],
	[8.2250000000E+03, 3.6318487508E+00, 5.7450172427E+00, 1.5013018453E-01, 1.4064121101E-01, 4.7798353408E-01],
	[8.2300000000E+03, 3.6345821708E+00, 5.7438464579E+00, 1.5041769797E-01, 1.4089690431E-01, 4.7817659792E-01],
	[8.2350000000E+03, 3.6373159861E+00, 5.7426766225E+00, 1.5070558679E-01, 1.4115288511E-01, 4.7836963023E-01],
	[8.2400000000E+03, 3.6400501964E+00, 5.7415077353E+00, 1.5099385126E-01, 1.4140915349E-01, 4.7856263105E-01],
	[8.2450000000E+03, 3.6427848016E+00, 5.7403397948E+00, 1.5128249164E-01, 1.4166570952E-01, 4.7875560044E-01],
	[8.2500000000E+03, 3.6455198014E+00, 5.7391727997E+00, 1.5157150819E-01, 1.4192255328E-01, 4.7894853848E-01],
	[8.2550000000E+03, 3.6482551958E+00, 5.7380067487E+00, 1.5186090117E-01, 1.4217968482E-01, 4.7914144521E-01],
	[8.2600000000E+03, 3.6509909844E+00, 5.7368416405E+00, 1.5215067085E-01, 1.4243710423E-01, 4.7933432070E-01],
	[8.2650000000E+03, 3.6537271672E+00, 5.7356774737E+00, 1.5244081749E-01, 1.4269481158E-01, 4.7952716500E-01],
	[8.2700000000E+03, 3.6564637440E+00, 5.7345142470E+00, 1.5273134134E-01, 1.4295280693E-01, 4.7971997818E-01],
	[8.2750000000E+03, 3.6592007145E+00, 5.7333519590E+00, 1.5302224267E-01, 1.4321109036E-01, 4.7991276030E-01],
	[8.2800000000E+03, 3.6619380786E+00, 5.7321906085E+00, 1.5331352175E-01, 1.4346966193E-01, 4.8010551142E-01],
	[8.2850000000E+03, 3.6646758361E+00, 5.7310301941E+00, 1.5360517883E-01, 1.4372852172E-01, 4.8029823159E-01],
	[8.2900000000E+03, 3.6674139869E+00, 5.7298707145E+00, 1.5389721417E-01, 1.4398766980E-01, 4.8049092089E-01],
	[8.2950000000E+03, 3.6701525306E+00, 5.7287121684E+00, 1.5418962804E-01, 1.4424710624E-01, 4.8068357935E-01],
	[8.3000000000E+03, 3.6728914673E+00, 5.7275545545E+00, 1.5448242070E-01, 1.4450683110E-01, 4.8087620706E-01],
	[8.3050000000E+03, 3.6756307966E+00, 5.7263978714E+00, 1.5477559241E-01, 1.4476684445E-01, 4.8106880407E-01],
	[8.3100000000E+03, 3.6783705184E+00, 5.7252421178E+00, 1.5506914343E-01, 1.4502714637E-01, 4.8126137043E-01],
	[8.3150000000E+03, 3.6811106326E+00, 5.7240872926E+00, 1.5536307403E-01, 1.4528773692E-01, 4.8145390621E-01],
	[8.3200000000E+03, 3.6838511389E+00, 5.7229333942E+00, 1.5565738446E-01, 1.4554861617E-01, 4.8164641148E-01],
	[8.3250000000E+03, 3.6865920372E+00, 5.7217804215E+00, 1.5595207499E-01, 1.4580978419E-01, 4.8183888628E-01],
	[8.3300000000E+03, 3.6893333272E+00, 5.7206283731E+00, 1.5624714589E-01, 1.4607124104E-01, 4.8203133068E-01],
	[8.3350000000E+03, 3.6920750089E+00, 5.7194772478E+00, 1.5654259740E-01, 1.4633298680E-01, 4.8222374475E-01],
	[8.3400000000E+03, 3.6948203391E+00, 5.7183443291E+00, 1.5683842980E-01, 1.4659503801E-01, 4.8241612853E-01],
	[8.3450000000E+03, 3.6975661651E+00, 5.7172128524E+00, 1.5713464334E-01, 1.4685737888E-01, 4.8260848210E-01],
	[8.3500000000E+03, 3.7003123852E+00, 5.7160822772E+00, 1.5743123829E-01, 1.4712000897E-01, 4.8280080551E-01],
	[8.3550000000E+03, 3.7030589991E+00, 5.7149526021E+00, 1.5772821492E-01, 1.4738292833E-01, 4.8299309883E-01],
	[8.3600000000E+03, 3.7058060068E+00, 5.7138238259E+00, 1.5802557347E-01, 1.4764613704E-01, 4.8318536211E-01],
	[8.3650000000E+03, 3.7085534079E+00, 5.7126959474E+00, 1.5832331422E-01, 1.4790963516E-01, 4.8337759541E-01],
	[8.3700000000E+03, 3.7113012023E+00, 5.7115689652E+00, 1.5862143743E-01, 1.4817342275E-01, 4.8356979880E-01],
	[8.3750000000E+03, 3.7140493899E+00, 5.7104428783E+00, 1.5891994336E-01, 1.4843749989E-01, 4.8376197234E-01],
	[8.3800000000E+03, 3.7167979705E+00, 5.7093176852E+00, 1.5921883226E-01, 1.4870186664E-01, 4.8395411609E-01],
	[8.3850000000E+03, 3.7195469438E+00, 5.7081933848E+00, 1.5951810441E-01, 1.4896652307E-01, 4.8414623011E-01],
	[8.3900000000E+03, 3.7222963098E+00, 5.7070699758E+00, 1.5981776007E-01, 1.4923146923E-01, 4.8433831465E-01],
	[8.3950000000E+03, 3.7250460682E+00, 5.7059474571E+00, 1.6011779949E-01, 1.4949670520E-01, 4.8453036980E-01],
	[8.4000000000E+03, 3.7277962189E+00, 5.7048258272E+00, 1.6041822295E-01, 1.4976223103E-01, 4.8472239561E-01],
	[8.4050000000E+03, 3.7305467616E+00, 5.7037050851E+00, 1.6071903069E-01, 1.5002804680E-01, 4.8491439209E-01],
	[8.4100000000E+03, 3.7332976962E+00, 5.7025852295E+00, 1.6102022299E-01, 1.5029415256E-01, 4.8510635927E-01],
	[8.4150000000E+03, 3.7360490226E+00, 5.7014662592E+00, 1.6132180011E-01, 1.5056054838E-01, 4.8529829718E-01],
	[8.4200000000E+03, 3.7388007405E+00, 5.7003481729E+00, 1.6162376231E-01, 1.5082723433E-01, 4.8549020585E-01],
	[8.4250000000E+03, 3.7415528498E+00, 5.6992309694E+00, 1.6192610985E-01, 1.5109421046E-01, 4.8568208531E-01],
	[8.4300000000E+03, 3.7443053502E+00, 5.6981146475E+00, 1.6222884299E-01, 1.5136147684E-01, 4.8587393558E-01],
	[8.4350000000E+03, 3.7470582417E+00, 5.6969992060E+00, 1.6253196200E-01, 1.5162903354E-01, 4.8606575670E-01],
	[8.4400000000E+03, 3.7498115241E+00, 5.6958846436E+00, 1.6283546714E-01, 1.5189688060E-01, 4.8625754868E-01],
	[8.4450000000E+03, 3.7525651971E+00, 5.6947709592E+00, 1.6313935867E-01, 1.5216501811E-01, 4.8644931157E-01],
	[8.4500000000E+03, 3.7553192606E+00, 5.6936581515E+00, 1.6344363685E-01, 1.5243344611E-01, 4.8664104538E-01],
	[8.4550000000E+03, 3.7580737144E+00, 5.6925462194E+00, 1.6374830195E-01, 1.5270216467E-01, 4.8683275014E-01],
	[8.4600000000E+03, 3.7608285583E+00, 5.6914351616E+00, 1.6405335424E-01, 1.5297117385E-01, 4.8702442589E-01],
	[8.4650000000E+03, 3.7635837922E+00, 5.6903249769E+00, 1.6435879396E-01, 1.5324047371E-01, 4.8721607265E-01],
	[8.4700000000E+03, 3.7663398687E+00, 5.6892179354E+00, 1.6466462138E-01, 1.5351006672E-01, 4.8740769045E-01],
	[8.4750000000E+03, 3.7690992926E+00, 5.6881265822E+00, 1.6497083678E-01, 1.5377996630E-01, 4.8759927932E-01],
	[8.4800000000E+03, 3.7718591089E+00, 5.6870360818E+00, 1.6527744040E-01, 1.5405015686E-01, 4.8779083928E-01],
	[8.4850000000E+03, 3.7746193174E+00, 5.6859464331E+00, 1.6558443252E-01, 1.5432063845E-01, 4.8798237037E-01],
	[8.4900000000E+03, 3.7773799180E+00, 5.6848576349E+00, 1.6589181339E-01, 1.5459141114E-01, 4.8817387262E-01],
	[8.4950000000E+03, 3.7801409105E+00, 5.6837696861E+00, 1.6619958328E-01, 1.5486247499E-01, 4.8836534605E-01],
	[8.5000000000E+03, 3.7829022947E+00, 5.6826825854E+00, 1.6650774244E-01, 1.5513383005E-01, 4.8855679069E-01],
	[8.5050000000E+03, 3.7856640704E+00, 5.6815963318E+00, 1.6681629116E-01, 1.5540547639E-01, 4.8874820657E-01],
	[8.5100000000E+03, 3.7884262375E+00, 5.6805109240E+00, 1.6712522967E-01, 1.5567741407E-01, 4.8893959372E-01],
	[8.5150000000E+03, 3.7911887958E+00, 5.6794263609E+00, 1.6743455826E-01, 1.5594964313E-01, 4.8913095217E-01],
	[8.5200000000E+03, 3.7939517451E+00, 5.6783426414E+00, 1.6774427718E-01, 1.5622216365E-01, 4.8932228195E-01],
	[8.5250000000E+03, 3.7967150853E+00, 5.6772597643E+00, 1.6805438669E-01, 1.5649497568E-01, 4.8951358308E-01],
	[8.5300000000E+03, 3.7994788161E+00, 5.6761777285E+00, 1.6836488706E-01, 1.5676807928E-01, 4.8970485560E-01],
	[8.5350000000E+03, 3.8022429374E+00, 5.6750965327E+00, 1.6867577855E-01, 1.5704147450E-01, 4.8989609954E-01],
	[8.5400000000E+03, 3.8050074490E+00, 5.6740161760E+00, 1.6898706142E-01, 1.5731516140E-01, 4.9008731492E-01],
	[8.5450000000E+03, 3.8077723508E+00, 5.6729366571E+00, 1.6929873594E-01, 1.5758914004E-01, 4.9027850178E-01],
	[8.5500000000E+03, 3.8105376426E+00, 5.6718579748E+00, 1.6961080237E-01, 1.5786341048E-01, 4.9046966014E-01],
	[8.5550000000E+03, 3.8133033241E+00, 5.6707801281E+00, 1.6992326097E-01, 1.5813797278E-01, 4.9066079003E-01],
	[8.5600000000E+03, 3.8160693953E+00, 5.6697031158E+00, 1.7023611200E-01, 1.5841282698E-01, 4.9085189149E-01],
	[8.5650000000E+03, 3.8188358559E+00, 5.6686269368E+00, 1.7054935574E-01, 1.5868797315E-01, 4.9104296454E-01],
	[8.5700000000E+03, 3.8216027059E+00, 5.6675515900E+00, 1.7086299243E-01, 1.5896341134E-01, 4.9123400921E-01],
	[8.5750000000E+03, 3.8243699449E+00, 5.6664770742E+00, 1.7117702235E-01, 1.5923914161E-01, 4.9142502553E-01],
	[8.5800000000E+03, 3.8271375729E+00, 5.6654033883E+00, 1.7149144575E-01, 1.5951516401E-01, 4.9161601354E-01],
	[8.5850000000E+03, 3.8299055896E+00, 5.6643305311E+00, 1.7180626291E-01, 1.5979147860E-01, 4.9180697326E-01],
	[8.5900000000E+03, 3.8326739949E+00, 5.6632585016E+00, 1.7212147408E-01, 1.6006808543E-01, 4.9199790472E-01],
	[8.5950000000E+03, 3.8354427887E+00, 5.6621872986E+00, 1.7243707952E-01, 1.6034498455E-01, 4.9218880795E-01],
	[8.6000000000E+03, 3.8382119706E+00, 5.6611169211E+00, 1.7275307951E-01, 1.6062217603E-01, 4.9237968299E-01],
	[8.6050000000E+03, 3.8409815407E+00, 5.6600473678E+00, 1.7306947430E-01, 1.6089965991E-01, 4.9257052986E-01],
	[8.6100000000E+03, 3.8437544893E+00, 5.6589927913E+00, 1.7338626415E-01, 1.6117745299E-01, 4.9276134859E-01],
	[8.6150000000E+03, 3.8465282995E+00, 5.6579412525E+00, 1.7370344933E-01, 1.6145554133E-01, 4.9295213921E-01],
	[8.6200000000E+03, 3.8493025004E+00, 5.6568905190E+00, 1.7402103011E-01, 1.6173392235E-01, 4.9314290176E-01],
	[8.6250000000E+03, 3.8520770916E+00, 5.6558405897E+00, 1.7433900674E-01, 1.6201259611E-01, 4.9333363626E-01],
	[8.6300000000E+03, 3.8548520730E+00, 5.6547914636E+00, 1.7465737949E-01, 1.6229156267E-01, 4.9352434274E-01],
	[8.6350000000E+03, 3.8576274444E+00, 5.6537431396E+00, 1.7497614863E-01, 1.6257082206E-01, 4.9371502125E-01],
	[8.6400000000E+03, 3.8604032057E+00, 5.6526956167E+00, 1.7529531441E-01, 1.6285037435E-01, 4.9390567179E-01],
	[8.6450000000E+03, 3.8631793567E+00, 5.6516488937E+00, 1.7561487710E-01, 1.6313021959E-01, 4.9409629441E-01],
	[8.6500000000E+03, 3.8659558972E+00, 5.6506029695E+00, 1.7593483696E-01, 1.6341035782E-01, 4.9428688914E-01],
	[8.6550000000E+03, 3.8687328270E+00, 5.6495578432E+00, 1.7625519426E-01, 1.6369078911E-01, 4.9447745601E-01],
	[8.6600000000E+03, 3.8715101461E+00, 5.6485135136E+00, 1.7657594925E-01, 1.6397151350E-01, 4.9466799505E-01],
	[8.6650000000E+03, 3.8742878541E+00, 5.6474699797E+00, 1.7689710222E-01, 1.6425253105E-01, 4.9485850629E-01],
	[8.6700000000E+03, 3.8770659510E+00, 5.6464272403E+00, 1.7721865340E-01, 1.6453384180E-01, 4.9504898975E-01],
	[8.6750000000E+03, 3.8798444366E+00, 5.6453852945E+00, 1.7754060308E-01, 1.6481544580E-01, 4.9523944548E-01],
	[8.6800000000E+03, 3.8826233106E+00, 5.6443441412E+00, 1.7786295151E-01, 1.6509734311E-01, 4.9542987350E-01],
	[8.6850000000E+03, 3.8854025730E+00, 5.6433037793E+00, 1.7818569896E-01, 1.6537953378E-01, 4.9562027385E-01],
	[8.6900000000E+03, 3.8881822235E+00, 5.6422642078E+00, 1.7850884569E-01, 1.6566201785E-01, 4.9581064655E-01],
	[8.6950000000E+03, 3.8909622621E+00, 5.6412254255E+00, 1.7883239196E-01, 1.6594479538E-01, 4.9600099164E-01],
	[8.7000000000E+03, 3.8937426884E+00, 5.6401874316E+00, 1.7915633804E-01, 1.6622786641E-01, 4.9619130914E-01],
	[8.7050000000E+03, 3.8965235024E+00, 5.6391502248E+00, 1.7948068420E-01, 1.6651123099E-01, 4.9638159910E-01],
	[8.7100000000E+03, 3.8993047039E+00, 5.6381138042E+00, 1.7980543068E-01, 1.6679488918E-01, 4.9657186154E-01],
	[8.7150000000E+03, 3.9020862928E+00, 5.6370781687E+00, 1.8013057777E-01, 1.6707884101E-01, 4.9676209649E-01],
	[8.7200000000E+03, 3.9048682687E+00, 5.6360433173E+00, 1.8045612572E-01, 1.6736308655E-01, 4.9695230398E-01],
	[8.7250000000E+03, 3.9076506317E+00, 5.6350092488E+00, 1.8078207480E-01, 1.6764762583E-01, 4.9714248405E-01],
	[8.7300000000E+03, 3.9104333814E+00, 5.6339759624E+00, 1.8110842526E-01, 1.6793245890E-01, 4.9733263672E-01],
	[8.7350000000E+03, 3.9132165178E+00, 5.6329434569E+00, 1.8143517738E-01, 1.6821758582E-01, 4.9752276204E-01],
	[8.7400000000E+03, 3.9160000407E+00, 5.6319117313E+00, 1.8176233142E-01, 1.6850300662E-01, 4.9771286003E-01],
	[8.7450000000E+03, 3.9187844976E+00, 5.6308832334E+00, 1.8208988764E-01, 1.6878872457E-01, 4.9790293072E-01],
	[8.7500000000E+03, 3.9215723076E+00, 5.6298687599E+00, 1.8241784630E-01, 1.6907475399E-01, 4.9809297414E-01],
	[8.7550000000E+03, 3.9243605066E+00, 5.6288550485E+00, 1.8274620768E-01, 1.6936107757E-01, 4.9828299033E-01],
	[8.7600000000E+03, 3.9271490944E+00, 5.6278420983E+00, 1.8307497202E-01, 1.6964769534E-01, 4.9847297932E-01],
	[8.7650000000E+03, 3.9299380707E+00, 5.6268299082E+00, 1.8340413961E-01, 1.6993460735E-01, 4.9866294115E-01],
	[8.7700000000E+03, 3.9327274356E+00, 5.6258184773E+00, 1.8373371069E-01, 1.7022181366E-01, 4.9885287583E-01],
	[8.7750000000E+03, 3.9355171887E+00, 5.6248078045E+00, 1.8406368554E-01, 1.7050931430E-01, 4.9904278341E-01],
	[8.7800000000E+03, 3.9383073299E+00, 5.6237978888E+00, 1.8439406442E-01, 1.7079710932E-01, 4.9923266392E-01],
	[8.7850000000E+03, 3.9410978591E+00, 5.6227887292E+00, 1.8472484759E-01, 1.7108519877E-01, 4.9942251739E-01],
	[8.7900000000E+03, 3.9438887761E+00, 5.6217803248E+00, 1.8505603532E-01, 1.7137358269E-01, 4.9961234386E-01],
	[8.7950000000E+03, 3.9466800807E+00, 5.6207726745E+00, 1.8538762787E-01, 1.7166226113E-01, 4.9980214335E-01],
	[8.8000000000E+03, 3.9494717728E+00, 5.6197657774E+00, 1.8571962550E-01, 1.7195123412E-01, 4.9999191589E-01],
	[8.8050000000E+03, 3.9522638521E+00, 5.6187596324E+00, 1.8605202848E-01, 1.7224050172E-01, 5.0018166153E-01],
	[8.8100000000E+03, 3.9550563186E+00, 5.6177542386E+00, 1.8638483708E-01, 1.7253006397E-01, 5.0037138029E-01],
	[8.8150000000E+03, 3.9578491720E+00, 5.6167495950E+00, 1.8671805155E-01, 1.7281992091E-01, 5.0056107220E-01],
	[8.8200000000E+03, 3.9606424123E+00, 5.6157457006E+00, 1.8705167217E-01, 1.7311007258E-01, 5.0075073731E-01],
	[8.8250000000E+03, 3.9634360391E+00, 5.6147425543E+00, 1.8738569919E-01, 1.7340051903E-01, 5.0094037564E-01],
	[8.8300000000E+03, 3.9662300524E+00, 5.6137401554E+00, 1.8772013288E-01, 1.7369126030E-01, 5.0112998722E-01],
	[8.8350000000E+03, 3.9690244520E+00, 5.6127385027E+00, 1.8805497350E-01, 1.7398229644E-01, 5.0131957209E-01],
	[8.8400000000E+03, 3.9718192377E+00, 5.6117375952E+00, 1.8839022132E-01, 1.7427362747E-01, 5.0150913027E-01],
	[8.8450000000E+03, 3.9746144094E+00, 5.6107374321E+00, 1.8872587661E-01, 1.7456525345E-01, 5.0169866182E-01],
	[8.8500000000E+03, 3.9774099669E+00, 5.6097380123E+00, 1.8906193962E-01, 1.7485717442E-01, 5.0188816675E-01],
	[8.8550000000E+03, 3.9802059100E+00, 5.6087393348E+00, 1.8939841062E-01, 1.7514939042E-01, 5.0207764510E-01],
	[8.8600000000E+03, 3.9830022386E+00, 5.6077413988E+00, 1.8973528988E-01, 1.7544190149E-01, 5.0226709690E-01],
	[8.8650000000E+03, 3.9857989525E+00, 5.6067442031E+00, 1.9007257766E-01, 1.7573470767E-01, 5.0245652219E-01],
	[8.8700000000E+03, 3.9885960515E+00, 5.6057477469E+00, 1.9041027422E-01, 1.7602780900E-01, 5.0264592099E-01],
	[8.8750000000E+03, 3.9913935355E+00, 5.6047520292E+00, 1.9074837983E-01, 1.7632120552E-01, 5.0283529336E-01],
	[8.8800000000E+03, 3.9941914044E+00, 5.6037570490E+00, 1.9108689475E-01, 1.7661489727E-01, 5.0302463930E-01],
	[8.8850000000E+03, 3.9969896647E+00, 5.6027628344E+00, 1.9142581925E-01, 1.7690888433E-01, 5.0321395887E-01],
	[8.8900000000E+03, 3.9997918697E+00, 5.6017843617E+00, 1.9176515359E-01, 1.7720318871E-01, 5.0340325210E-01],
	[8.8950000000E+03, 4.0025944620E+00, 5.6008066100E+00, 1.9210489804E-01, 1.7749778856E-01, 5.0359251900E-01],
	[8.9000000000E+03, 4.0053974414E+00, 5.5998295782E+00, 1.9244505286E-01, 1.7779268393E-01, 5.0378175964E-01],
	[8.9050000000E+03, 4.0082008078E+00, 5.5988532654E+00, 1.9278561831E-01, 1.7808787486E-01, 5.0397097402E-01],
	[8.9100000000E+03, 4.0110045611E+00, 5.5978776708E+00, 1.9312659466E-01, 1.7838336139E-01, 5.0416016220E-01],
	[8.9150000000E+03, 4.0138087010E+00, 5.5969027933E+00, 1.9346798218E-01, 1.7867914354E-01, 5.0434932419E-01],
	[8.9200000000E+03, 4.0166132273E+00, 5.5959286321E+00, 1.9380978112E-01, 1.7897522137E-01, 5.0453846005E-01],
	[8.9250000000E+03, 4.0194181401E+00, 5.5949551862E+00, 1.9415199176E-01, 1.7927159491E-01, 5.0472756979E-01],
	[8.9300000000E+03, 4.0222234389E+00, 5.5939824547E+00, 1.9449461436E-01, 1.7956826420E-01, 5.0491665346E-01],
	[8.9350000000E+03, 4.0250291238E+00, 5.5930104366E+00, 1.9483764918E-01, 1.7986522927E-01, 5.0510571108E-01],
	[8.9400000000E+03, 4.0278351945E+00, 5.5920391311E+00, 1.9518109649E-01, 1.8016249016E-01, 5.0529474270E-01],
	[8.9450000000E+03, 4.0306416509E+00, 5.5910685372E+00, 1.9552495655E-01, 1.8046004691E-01, 5.0548374835E-01],
	[8.9500000000E+03, 4.0334484928E+00, 5.5900986540E+00, 1.9586922963E-01, 1.8075789955E-01, 5.0567272806E-01],
	[8.9550000000E+03, 4.0362557200E+00, 5.5891294806E+00, 1.9621391598E-01, 1.8105604813E-01, 5.0586168186E-01],
	[8.9600000000E+03, 4.0390633325E+00, 5.5881610161E+00, 1.9655901589E-01, 1.8135449267E-01, 5.0605060979E-01],
	[8.9650000000E+03, 4.0418713299E+00, 5.5871932595E+00, 1.9690452960E-01, 1.8165323321E-01, 5.0623951188E-01],
	[8.9700000000E+03, 4.0446797123E+00, 5.5862262100E+00, 1.9725045739E-01, 1.8195226979E-01, 5.0642838805E-01],
	[8.9750000000E+03, 4.0474884793E+00, 5.5852598666E+00, 1.9759679952E-01, 1.8225160245E-01, 5.0661723831E-01],
	[8.9800000000E+03, 4.0502976308E+00, 5.5842942285E+00, 1.9794355626E-01, 1.8255123121E-01, 5.0680606264E-01],
	[8.9850000000E+03, 4.0531071668E+00, 5.5833292946E+00, 1.9829072787E-01, 1.8285115611E-01, 5.0699486105E-01],
	[8.9900000000E+03, 4.0559170869E+00, 5.5823650642E+00, 1.9863831461E-01, 1.8315137719E-01, 5.0718363354E-01],
	[8.9950000000E+03, 4.0587273912E+00, 5.5814015363E+00, 1.9898631675E-01, 1.8345189448E-01, 5.0737238011E-01],
	[9.0000000000E+03, 4.0615380793E+00, 5.5804387100E+00, 1.9933473456E-01, 1.8375270801E-01, 5.0756110076E-01],
	[9.0050000000E+03, 4.0643491511E+00, 5.5794765844E+00, 1.9968493456E-01, 1.8405497858E-01, 5.0774979550E-01],
	[9.0100000000E+03, 4.0671606065E+00, 5.5785151587E+00, 2.0003555484E-01, 1.8435754839E-01, 5.0793846433E-01],
	[9.0150000000E+03, 4.0699724454E+00, 5.5775544318E+00, 2.0038659565E-01, 1.8466041750E-01, 5.0812710724E-01],
	[9.0200000000E+03, 4.0727846674E+00, 5.5765944030E+00, 2.0073805727E-01, 1.8496358593E-01, 5.0831572424E-01],
	[9.0250000000E+03, 4.0755972726E+00, 5.5756350712E+00, 2.0108993997E-01, 1.8526705371E-01, 5.0850431533E-01],
	[9.0300000000E+03, 4.0784117024E+00, 5.5746821274E+00, 2.0144224403E-01, 1.8557083018E-01, 5.0869288052E-01],
	[9.0350000000E+03, 4.0812287283E+00, 5.5737385994E+00, 2.0179496971E-01, 1.8587492042E-01, 5.0888141980E-01],
	[9.0400000000E+03, 4.0840461398E+00, 5.5727957530E+00, 2.0214811728E-01, 1.8617931025E-01, 5.0906993317E-01],
	[9.0450000000E+03, 4.0868639368E+00, 5.5718535873E+00, 2.0250168701E-01, 1.8648399971E-01, 5.0925842065E-01],
	[9.0500000000E+03, 4.0896821190E+00, 5.5709121015E+00, 2.0285567918E-01, 1.8678898883E-01, 5.0944688222E-01],
	[9.0550000000E+03, 4.0925006865E+00, 5.5699712945E+00, 2.0321009405E-01, 1.8709427765E-01, 5.0963531790E-01],
	[9.0600000000E+03, 4.0953196389E+00, 5.5690311657E+00, 2.0356493190E-01, 1.8739986619E-01, 5.0982372768E-01],
	[9.0650000000E+03, 4.0981389761E+00, 5.5680917142E+00, 2.0392019299E-01, 1.8770575449E-01, 5.1001211157E-01],
	[9.0700000000E+03, 4.1009586981E+00, 5.5671529390E+00, 2.0427587761E-01, 1.8801194258E-01, 5.1020046957E-01],
	[9.0750000000E+03, 4.1037788045E+00, 5.5662148393E+00, 2.0463198601E-01, 1.8831843050E-01, 5.1038880168E-01],
	[9.0800000000E+03, 4.1065992953E+00, 5.5652774143E+00, 2.0498851847E-01, 1.8862521827E-01, 5.1057710790E-01],
	[9.0850000000E+03, 4.1094201703E+00, 5.5643406631E+00, 2.0534547526E-01, 1.8893230593E-01, 5.1076538825E-01],
	[9.0900000000E+03, 4.1122414293E+00, 5.5634045849E+00, 2.0570285665E-01, 1.8923969351E-01, 5.1095364271E-01],
	[9.0950000000E+03, 4.1150630721E+00, 5.5624691787E+00, 2.0606066292E-01, 1.8954738103E-01, 5.1114187129E-01],
	[9.1000000000E+03, 4.1178850987E+00, 5.5615344438E+00, 2.0641889432E-01, 1.8985536853E-01, 5.1133007400E-01],
	[9.1050000000E+03, 4.1207075089E+00, 5.5606003793E+00, 2.0677755114E-01, 1.9016365604E-01, 5.1151825084E-01],
	[9.1100000000E+03, 4.1235303024E+00, 5.5596669843E+00, 2.0713663365E-01, 1.9047224359E-01, 5.1170640181E-01],
	[9.1150000000E+03, 4.1263534792E+00, 5.5587342581E+00, 2.0749614211E-01, 1.9078113121E-01, 5.1189452691E-01],
	[9.1200000000E+03, 4.1291770391E+00, 5.5578021997E+00, 2.0785607680E-01, 1.9109031892E-01, 5.1208262615E-01],
	[9.1250000000E+03, 4.1320009819E+00, 5.5568708083E+00, 2.0821643799E-01, 1.9139980677E-01, 5.1227069953E-01],
	[9.1300000000E+03, 4.1348253074E+00, 5.5559400831E+00, 2.0857722595E-01, 1.9170959476E-01, 5.1245874706E-01],
	[9.1350000000E+03, 4.1376500156E+00, 5.5550100232E+00, 2.0893844095E-01, 1.9201968294E-01, 5.1264676873E-01],
	[9.1400000000E+03, 4.1404751062E+00, 5.5540806277E+00, 2.0930008326E-01, 1.9233007133E-01, 5.1283476455E-01],
	[9.1450000000E+03, 4.1433005791E+00, 5.5531518960E+00, 2.0966215316E-01, 1.9264075996E-01, 5.1302273452E-01],
	[9.1500000000E+03, 4.1461264341E+00, 5.5522238270E+00, 2.1002465091E-01, 1.9295174886E-01, 5.1321067866E-01],
	[9.1550000000E+03, 4.1489526711E+00, 5.5512964201E+00, 2.1038757678E-01, 1.9326303806E-01, 5.1339859695E-01],
	[9.1600000000E+03, 4.1517792900E+00, 5.5503696743E+00, 2.1075093105E-01, 1.9357462757E-01, 5.1358648941E-01],
	[9.1650000000E+03, 4.1546062905E+00, 5.5494435887E+00, 2.1111471399E-01, 1.9388651743E-01, 5.1377435603E-01],
	[9.1700000000E+03, 4.1574336725E+00, 5.5485181627E+00, 2.1147892587E-01, 1.9419870767E-01, 5.1396219683E-01],
	[9.1750000000E+03, 4.1602626834E+00, 5.5475979302E+00, 2.1184356696E-01, 1.9451120661E-01, 5.1415001181E-01],
	[9.1800000000E+03, 4.1630946464E+00, 5.5466876854E+00, 2.1220863753E-01, 1.9482402317E-01, 5.1433780096E-01],
	[9.1850000000E+03, 4.1659269936E+00, 5.5457780855E+00, 2.1257413786E-01, 1.9513714033E-01, 5.1452556430E-01],
	[9.1900000000E+03, 4.1687597248E+00, 5.5448691297E+00, 2.1294006821E-01, 1.9545055811E-01, 5.1471330183E-01],
	[9.1950000000E+03, 4.1715928398E+00, 5.5439608171E+00, 2.1330642885E-01, 1.9576427653E-01, 5.1490101354E-01],
	[9.2000000000E+03, 4.1744263385E+00, 5.5430531470E+00, 2.1367322007E-01, 1.9607829563E-01, 5.1508869946E-01],
	[9.2050000000E+03, 4.1772602208E+00, 5.5421461186E+00, 2.1404044212E-01, 1.9639261543E-01, 5.1527635957E-01],
	[9.2100000000E+03, 4.1800944864E+00, 5.5412397309E+00, 2.1440809529E-01, 1.9670723595E-01, 5.1546399389E-01],
	[9.2150000000E+03, 4.1829291352E+00, 5.5403339834E+00, 2.1477617984E-01, 1.9702215722E-01, 5.1565160242E-01],
	[9.2200000000E+03, 4.1857641670E+00, 5.5394288750E+00, 2.1514469604E-01, 1.9733737926E-01, 5.1583918517E-01],
	[9.2250000000E+03, 4.1885995817E+00, 5.5385244052E+00, 2.1551364417E-01, 1.9765290210E-01, 5.1602674213E-01],
	[9.2300000000E+03, 4.1914353792E+00, 5.5376205729E+00, 2.1588302449E-01, 1.9796872575E-01, 5.1621427331E-01],
	[9.2350000000E+03, 4.1942715593E+00, 5.5367173776E+00, 2.1625283729E-01, 1.9828485025E-01, 5.1640177872E-01],
	[9.2400000000E+03, 4.1971081218E+00, 5.5358148183E+00, 2.1662308282E-01, 1.9860127561E-01, 5.1658925837E-01],
	[9.2450000000E+03, 4.1999450666E+00, 5.5349128943E+00, 2.1699376137E-01, 1.9891800186E-01, 5.1677671225E-01],
	[9.2500000000E+03, 4.2027823935E+00, 5.5340116048E+00, 2.1736487320E-01, 1.9923502901E-01, 5.1696414037E-01],
	[9.2550000000E+03, 4.2056201023E+00, 5.5331109489E+00, 2.1773641858E-01, 1.9955235711E-01, 5.1715154274E-01],
	[9.2600000000E+03, 4.2084581930E+00, 5.5322109260E+00, 2.1810839779E-01, 1.9986998615E-01, 5.1733891937E-01],
	[9.2650000000E+03, 4.2112966653E+00, 5.5313115352E+00, 2.1848081111E-01, 2.0018791617E-01, 5.1752627025E-01],
	[9.2700000000E+03, 4.2141355191E+00, 5.5304127757E+00, 2.1885365879E-01, 2.0050614719E-01, 5.1771359539E-01],
	[9.2750000000E+03, 4.2169747543E+00, 5.5295146468E+00, 2.1922694112E-01, 2.0082467922E-01, 5.1790089480E-01],
	[9.2800000000E+03, 4.2198143706E+00, 5.5286171477E+00, 2.1960065836E-01, 2.0114351229E-01, 5.1808816848E-01],
	[9.2850000000E+03, 4.2226543680E+00, 5.5277202776E+00, 2.1997481078E-01, 2.0146264642E-01, 5.1827541644E-01],
	[9.2900000000E+03, 4.2254947463E+00, 5.5268240356E+00, 2.2034939867E-01, 2.0178208163E-01, 5.1846263869E-01],
	[9.2950000000E+03, 4.2283355053E+00, 5.5259284211E+00, 2.2072442228E-01, 2.0210181794E-01, 5.1864983522E-01],
	[9.3000000000E+03, 4.2311766448E+00, 5.5250334333E+00, 2.2109988190E-01, 2.0242185537E-01, 5.1883700605E-01],
	[9.3050000000E+03, 4.2340181648E+00, 5.5241390713E+00, 2.2147577779E-01, 2.0274219393E-01, 5.1902415118E-01],
	[9.3100000000E+03, 4.2368600651E+00, 5.5232453345E+00, 2.2185211023E-01, 2.0306283365E-01, 5.1921127061E-01],
	[9.3150000000E+03, 4.2397023454E+00, 5.5223522220E+00, 2.2222887948E-01, 2.0338377455E-01, 5.1939836435E-01],
	[9.3200000000E+03, 4.2425450057E+00, 5.5214597331E+00, 2.2260608583E-01, 2.0370501663E-01, 5.1958543242E-01],
	[9.3250000000E+03, 4.2453912047E+00, 5.5205784252E+00, 2.2298372953E-01, 2.0402658165E-01, 5.1977247480E-01],
	[9.3300000000E+03, 4.2482386201E+00, 5.5197005165E+00, 2.2336181087E-01, 2.0434845376E-01, 5.1995949152E-01],
	[9.3350000000E+03, 4.2510864181E+00, 5.5188232175E+00, 2.2374033012E-01, 2.0467062728E-01, 5.2014648257E-01],
	[9.3400000000E+03, 4.2539345988E+00, 5.5179465277E+00, 2.2411928755E-01, 2.0499310221E-01, 5.2033344796E-01],
	[9.3450000000E+03, 4.2567831618E+00, 5.5170704462E+00, 2.2449868342E-01, 2.0531587857E-01, 5.2052038770E-01],
	[9.3500000000E+03, 4.2596321071E+00, 5.5161949723E+00, 2.2487851802E-01, 2.0563895639E-01, 5.2070730179E-01],
	[9.3550000000E+03, 4.2624814345E+00, 5.5153201053E+00, 2.2525879162E-01, 2.0596233567E-01, 5.2089419024E-01],
	[9.3600000000E+03, 4.2653311438E+00, 5.5144458444E+00, 2.2563950448E-01, 2.0628601644E-01, 5.2108105306E-01],
	[9.3650000000E+03, 4.2681812349E+00, 5.5135721889E+00, 2.2602065688E-01, 2.0660999871E-01, 5.2126789025E-01],
	[9.3700000000E+03, 4.2710317077E+00, 5.5126991379E+00, 2.2640224909E-01, 2.0693428249E-01, 5.2145470182E-01],
	[9.3750000000E+03, 4.2738825619E+00, 5.5118266909E+00, 2.2678428138E-01, 2.0725886781E-01, 5.2164148778E-01],
	[9.3800000000E+03, 4.2767337975E+00, 5.5109548470E+00, 2.2716675403E-01, 2.0758375468E-01, 5.2182824813E-01],
	[9.3850000000E+03, 4.2795854143E+00, 5.5100836055E+00, 2.2754966731E-01, 2.0790894311E-01, 5.2201498287E-01],
	[9.3900000000E+03, 4.2824374121E+00, 5.5092129657E+00, 2.2793302149E-01, 2.0823443312E-01, 5.2220169202E-01],
	[9.3950000000E+03, 4.2852897907E+00, 5.5083429268E+00, 2.2831681685E-01, 2.0856022472E-01, 5.2238837559E-01],
	[9.4000000000E+03, 4.2881425501E+00, 5.5074734882E+00, 2.2870105365E-01, 2.0888631792E-01, 5.2257503357E-01],
	[9.4050000000E+03, 4.2909956901E+00, 5.5066046490E+00, 2.2908573216E-01, 2.0921271275E-01, 5.2276166597E-01],
	[9.4100000000E+03, 4.2938492105E+00, 5.5057364085E+00, 2.2947085267E-01, 2.0953940922E-01, 5.2294827281E-01],
	[9.4150000000E+03, 4.2967031111E+00, 5.5048687660E+00, 2.2985641544E-01, 2.0986640733E-01, 5.2313485409E-01],
	[9.4200000000E+03, 4.2995573919E+00, 5.5040017208E+00, 2.3024242074E-01, 2.1019370710E-01, 5.2332140982E-01],
	[9.4250000000E+03, 4.3024120526E+00, 5.5031352722E+00, 2.3062886886E-01, 2.1052130854E-01, 5.2350794000E-01],
	[9.4300000000E+03, 4.3052670932E+00, 5.5022694194E+00, 2.3101576005E-01, 2.1084921168E-01, 5.2369444464E-01],
	[9.4350000000E+03, 4.3081225134E+00, 5.5014041616E+00, 2.3140309460E-01, 2.1117741651E-01, 5.2388092375E-01],
	[9.4400000000E+03, 4.3109783132E+00, 5.5005394983E+00, 2.3179087277E-01, 2.1150592305E-01, 5.2406737734E-01],
	[9.4450000000E+03, 4.3138344923E+00, 5.4996754286E+00, 2.3217909484E-01, 2.1183473131E-01, 5.2425380541E-01],
	[9.4500000000E+03, 4.3166910506E+00, 5.4988119518E+00, 2.3256776108E-01, 2.1216384131E-01, 5.2444020797E-01],
	[9.4550000000E+03, 4.3195479880E+00, 5.4979490672E+00, 2.3295687176E-01, 2.1249325305E-01, 5.2462658502E-01],
	[9.4600000000E+03, 4.3224053043E+00, 5.4970867741E+00, 2.3334642716E-01, 2.1282296655E-01, 5.2481293658E-01],
	[9.4650000000E+03, 4.3252629993E+00, 5.4962250718E+00, 2.3373642755E-01, 2.1315298181E-01, 5.2499926266E-01],
	[9.4700000000E+03, 4.3281210730E+00, 5.4953639596E+00, 2.3412687320E-01, 2.1348329885E-01, 5.2518556325E-01],
	[9.4750000000E+03, 4.3309827772E+00, 5.4945134492E+00, 2.3451776438E-01, 2.1381394076E-01, 5.2537183838E-01],
	[9.4800000000E+03, 4.3338457802E+00, 5.4936663431E+00, 2.3490910137E-01, 2.1414489113E-01, 5.2555808804E-01],
	[9.4850000000E+03, 4.3367091648E+00, 5.4928198142E+00, 2.3530088444E-01, 2.1447614346E-01, 5.2574431224E-01],
	[9.4900000000E+03, 4.3395729307E+00, 5.4919738618E+00, 2.3569311386E-01, 2.1480769777E-01, 5.2593051100E-01],
	[9.4950000000E+03, 4.3424370777E+00, 5.4911284852E+00, 2.3608578991E-01, 2.1513955406E-01, 5.2611668431E-01],
	[9.5000000000E+03, 4.3453016058E+00, 5.4902836836E+00, 2.3647891286E-01, 2.1547171234E-01, 5.2630283220E-01],
	[9.5050000000E+03, 4.3481665147E+00, 5.4894394564E+00, 2.3687248297E-01, 2.1580417263E-01, 5.2648895466E-01],
	[9.5100000000E+03, 4.3510318043E+00, 5.4885958029E+00, 2.3726650053E-01, 2.1613693493E-01, 5.2667505168E-01],
	[9.5150000000E+03, 4.3538974746E+00, 5.4877527225E+00, 2.3766096581E-01, 2.1646999925E-01, 5.2686112322E-01],
	[9.5200000000E+03, 4.3567635252E+00, 5.4869102143E+00, 2.3805587908E-01, 2.1680336560E-01, 5.2704716924E-01],
	[9.5250000000E+03, 4.3596299561E+00, 5.4860682777E+00, 2.3845124061E-01, 2.1713703398E-01, 5.2723318974E-01],
	[9.5300000000E+03, 4.3624967672E+00, 5.4852269121E+00, 2.3884705067E-01, 2.1747100440E-01, 5.2741918470E-01],
	[9.5350000000E+03, 4.3653639582E+00, 5.4843861167E+00, 2.3924330955E-01, 2.1780527687E-01, 5.2760515411E-01],
	[9.5400000000E+03, 4.3682315290E+00, 5.4835458909E+00, 2.3964001750E-01, 2.1813985139E-01, 5.2779109795E-01],
	[9.5450000000E+03, 4.3710994796E+00, 5.4827062340E+00, 2.4003717481E-01, 2.1847472798E-01, 5.2797701620E-01],
	[9.5500000000E+03, 4.3739678096E+00, 5.4818671452E+00, 2.4043478175E-01, 2.1880990663E-01, 5.2816290885E-01],
	[9.5550000000E+03, 4.3768365190E+00, 5.4810286240E+00, 2.4083283859E-01, 2.1914538736E-01, 5.2834877589E-01],
	[9.5600000000E+03, 4.3797056077E+00, 5.4801906696E+00, 2.4123134560E-01, 2.1948117016E-01, 5.2853461730E-01],
	[9.5650000000E+03, 4.3825750754E+00, 5.4793532814E+00, 2.4163030306E-01, 2.1981725505E-01, 5.2872043307E-01],
	[9.5700000000E+03, 4.3854449221E+00, 5.4785164586E+00, 2.4202971124E-01, 2.2015364203E-01, 5.2890622318E-01],
	[9.5750000000E+03, 4.3883151476E+00, 5.4776802007E+00, 2.4242957042E-01, 2.2049033111E-01, 5.2909198761E-01],
	[9.5800000000E+03, 4.3911857517E+00, 5.4768445069E+00, 2.4282988086E-01, 2.2082732228E-01, 5.2927772636E-01],
	[9.5850000000E+03, 4.3940567343E+00, 5.4760093765E+00, 2.4323064284E-01, 2.2116461555E-01, 5.2946343941E-01],
	[9.5900000000E+03, 4.3969280952E+00, 5.4751748089E+00, 2.4363185663E-01, 2.2150221093E-01, 5.2964912674E-01],
	[9.5950000000E+03, 4.3997998343E+00, 5.4743408033E+00, 2.4403352251E-01, 2.2184010842E-01, 5.2983478834E-01],
	[9.6000000000E+03, 4.4026719515E+00, 5.4735073593E+00, 2.4443564075E-01, 2.2217830802E-01, 5.3002042419E-01],
	[9.6050000000E+03, 4.4055444466E+00, 5.4726744760E+00, 2.4483821163E-01, 2.2251680974E-01, 5.3020603429E-01],
	[9.6100000000E+03, 4.4084173194E+00, 5.4718421527E+00, 2.4524123541E-01, 2.2285561358E-01, 5.3039161862E-01],
	[9.6150000000E+03, 4.4112905699E+00, 5.4710103889E+00, 2.4564471237E-01, 2.2319471954E-01, 5.3057717716E-01],
	[9.6200000000E+03, 4.4141641978E+00, 5.4701791839E+00, 2.4604864278E-01, 2.2353412761E-01, 5.3076270989E-01],
	[9.6250000000E+03, 4.4170394444E+00, 5.4693520632E+00, 2.4645302692E-01, 2.2387384691E-01, 5.3094821682E-01],
	[9.6300000000E+03, 4.4199181763E+00, 5.4685343157E+00, 2.4685786506E-01, 2.2421389121E-01, 5.3113369791E-01],
	[9.6350000000E+03, 4.4227972887E+00, 5.4677171149E+00, 2.4726315747E-01, 2.2455423780E-01, 5.3131915317E-01],
	[9.6400000000E+03, 4.4256767813E+00, 5.4669004601E+00, 2.4766890443E-01, 2.2489488669E-01, 5.3150458257E-01],
	[9.6450000000E+03, 4.4285566540E+00, 5.4660843506E+00, 2.4807510621E-01, 2.2523583788E-01, 5.3168998610E-01],
	[9.6500000000E+03, 4.4314369067E+00, 5.4652687859E+00, 2.4848176309E-01, 2.2557709136E-01, 5.3187536375E-01],
	[9.6550000000E+03, 4.4343175392E+00, 5.4644537651E+00, 2.4888887533E-01, 2.2591864715E-01, 5.3206071550E-01],
	[9.6600000000E+03, 4.4371985515E+00, 5.4636392878E+00, 2.4929644321E-01, 2.2626050524E-01, 5.3224604134E-01],
	[9.6650000000E+03, 4.4400799433E+00, 5.4628253533E+00, 2.4970446701E-01, 2.2660266562E-01, 5.3243134126E-01],
	[9.6700000000E+03, 4.4429617144E+00, 5.4620119609E+00, 2.5011294700E-01, 2.2694512831E-01, 5.3261661525E-01],
	[9.6750000000E+03, 4.4458438649E+00, 5.4611991099E+00, 2.5052188345E-01, 2.2728789329E-01, 5.3280186329E-01],
	[9.6800000000E+03, 4.4487263944E+00, 5.4603867998E+00, 2.5093127663E-01, 2.2763096058E-01, 5.3298708537E-01],
	[9.6850000000E+03, 4.4516093029E+00, 5.4595750300E+00, 2.5134112682E-01, 2.2797433016E-01, 5.3317228147E-01],
	[9.6900000000E+03, 4.4544925902E+00, 5.4587637996E+00, 2.5175143430E-01, 2.2831800203E-01, 5.3335745159E-01],
	[9.6950000000E+03, 4.4573762562E+00, 5.4579531083E+00, 2.5216219933E-01, 2.2866197620E-01, 5.3354259570E-01],
	[9.7000000000E+03, 4.4602603007E+00, 5.4571429552E+00, 2.5257342220E-01, 2.2900625266E-01, 5.3372771380E-01],
	[9.7050000000E+03, 4.4631447235E+00, 5.4563333397E+00, 2.5298510317E-01, 2.2935083141E-01, 5.3391280588E-01],
	[9.7100000000E+03, 4.4660295246E+00, 5.4555242613E+00, 2.5339724251E-01, 2.2969571245E-01, 5.3409787192E-01],
	[9.7150000000E+03, 4.4689147038E+00, 5.4547157193E+00, 2.5380984051E-01, 2.3004089577E-01, 5.3428291191E-01],
	[9.7200000000E+03, 4.4718002609E+00, 5.4539077130E+00, 2.5422289744E-01, 2.3038638137E-01, 5.3446792583E-01],
	[9.7250000000E+03, 4.4746861958E+00, 5.4531002419E+00, 2.5463641356E-01, 2.3073216925E-01, 5.3465291368E-01],
	[9.7300000000E+03, 4.4775725084E+00, 5.4522933053E+00, 2.5505038916E-01, 2.3107825940E-01, 5.3483787545E-01],
	[9.7350000000E+03, 4.4804591985E+00, 5.4514869026E+00, 2.5546482450E-01, 2.3142465182E-01, 5.3502281111E-01],
	[9.7400000000E+03, 4.4833462659E+00, 5.4506810331E+00, 2.5587971987E-01, 2.3177134650E-01, 5.3520772066E-01],
	[9.7450000000E+03, 4.4862337105E+00, 5.4498756962E+00, 2.5629507553E-01, 2.3211834344E-01, 5.3539260409E-01],
	[9.7500000000E+03, 4.4891215323E+00, 5.4490708913E+00, 2.5671089176E-01, 2.3246564264E-01, 5.3557746138E-01],
	[9.7550000000E+03, 4.4920097309E+00, 5.4482666178E+00, 2.5712716883E-01, 2.3281324409E-01, 5.3576229252E-01],
	[9.7600000000E+03, 4.4948983063E+00, 5.4474628750E+00, 2.5754390702E-01, 2.3316114778E-01, 5.3594709750E-01],
	[9.7650000000E+03, 4.4977872584E+00, 5.4466596624E+00, 2.5796110660E-01, 2.3350935370E-01, 5.3613187631E-01],
	[9.7700000000E+03, 4.5006765870E+00, 5.4458569793E+00, 2.5837876785E-01, 2.3385786186E-01, 5.3631662893E-01],
	[9.7750000000E+03, 4.5035662919E+00, 5.4450548250E+00, 2.5879689104E-01, 2.3420667225E-01, 5.3650135536E-01],
	[9.7800000000E+03, 4.5064577325E+00, 5.4442567640E+00, 2.5921547644E-01, 2.3455579515E-01, 5.3668605558E-01],
	[9.7850000000E+03, 4.5093527193E+00, 5.4434675316E+00, 2.5963452433E-01, 2.3490524438E-01, 5.3687072958E-01],
	[9.7900000000E+03, 4.5122480855E+00, 5.4426788168E+00, 2.6005403498E-01, 2.3525499599E-01, 5.3705537736E-01],
	[9.7950000000E+03, 4.5151438309E+00, 5.4418906188E+00, 2.6047400866E-01, 2.3560504998E-01, 5.3723999889E-01],
	[9.8000000000E+03, 4.5180399555E+00, 5.4411029372E+00, 2.6089444566E-01, 2.3595540634E-01, 5.3742459416E-01],
	[9.8050000000E+03, 4.5209364591E+00, 5.4403157713E+00, 2.6131534624E-01, 2.3630606505E-01, 5.3760916318E-01],
	[9.8100000000E+03, 4.5238333416E+00, 5.4395291204E+00, 2.6173671068E-01, 2.3665702612E-01, 5.3779370591E-01],
	[9.8150000000E+03, 4.5267306027E+00, 5.4387429841E+00, 2.6215853925E-01, 2.3700828953E-01, 5.3797822236E-01],
	[9.8200000000E+03, 4.5296282424E+00, 5.4379573616E+00, 2.6258083223E-01, 2.3735985528E-01, 5.3816271252E-01],
	[9.8250000000E+03, 4.5325262605E+00, 5.4371722525E+00, 2.6300358989E-01, 2.3771172335E-01, 5.3834717636E-01],
	[9.8300000000E+03, 4.5354246569E+00, 5.4363876561E+00, 2.6342681251E-01, 2.3806389374E-01, 5.3853161388E-01],
	[9.8350000000E+03, 4.5383234314E+00, 5.4356035718E+00, 2.6385050036E-01, 2.3841636644E-01, 5.3871602507E-01],
	[9.8400000000E+03, 4.5412225839E+00, 5.4348199990E+00, 2.6427465371E-01, 2.3876914144E-01, 5.3890040992E-01],
	[9.8450000000E+03, 4.5441221142E+00, 5.4340369371E+00, 2.6469927284E-01, 2.3912221872E-01, 5.3908476842E-01],
	[9.8500000000E+03, 4.5470220222E+00, 5.4332543856E+00, 2.6512435803E-01, 2.3947559828E-01, 5.3926910055E-01],
	[9.8550000000E+03, 4.5499223078E+00, 5.4324723438E+00, 2.6554990954E-01, 2.3982928011E-01, 5.3945340631E-01],
	[9.8600000000E+03, 4.5528229708E+00, 5.4316908112E+00, 2.6597592765E-01, 2.4018326420E-01, 5.3963768569E-01],
	[9.8650000000E+03, 4.5557240110E+00, 5.4309097871E+00, 2.6640241264E-01, 2.4053755053E-01, 5.3982193867E-01],
	[9.8700000000E+03, 4.5586254284E+00, 5.4301292710E+00, 2.6682936478E-01, 2.4089213909E-01, 5.4000616524E-01],
	[9.8750000000E+03, 4.5615272228E+00, 5.4293492623E+00, 2.6725678435E-01, 2.4124702987E-01, 5.4019036540E-01],
	[9.8800000000E+03, 4.5644293940E+00, 5.4285697604E+00, 2.6768467162E-01, 2.4160222287E-01, 5.4037453913E-01],
	[9.8850000000E+03, 4.5673319419E+00, 5.4277907647E+00, 2.6811302686E-01, 2.4195771806E-01, 5.4055868642E-01],
	[9.8900000000E+03, 4.5702348664E+00, 5.4270122746E+00, 2.6854185036E-01, 2.4231351544E-01, 5.4074280727E-01],
	[9.8950000000E+03, 4.5731381673E+00, 5.4262342896E+00, 2.6897114237E-01, 2.4266961499E-01, 5.4092690166E-01],
	[9.9000000000E+03, 4.5760418445E+00, 5.4254568091E+00, 2.6940090319E-01, 2.4302601670E-01, 5.4111096959E-01],
	[9.9050000000E+03, 4.5789458978E+00, 5.4246798324E+00, 2.6983113308E-01, 2.4338272055E-01, 5.4129501103E-01],
	[9.9100000000E+03, 4.5818503271E+00, 5.4239033590E+00, 2.7026183232E-01, 2.4373972653E-01, 5.4147902599E-01],
	[9.9150000000E+03, 4.5847551323E+00, 5.4231273884E+00, 2.7069300118E-01, 2.4409703464E-01, 5.4166301446E-01],
	[9.9200000000E+03, 4.5876603132E+00, 5.4223519199E+00, 2.7112463993E-01, 2.4445464484E-01, 5.4184697641E-01],
	[9.9250000000E+03, 4.5905658696E+00, 5.4215769529E+00, 2.7155674886E-01, 2.4481255713E-01, 5.4203091185E-01],
	[9.9300000000E+03, 4.5934718015E+00, 5.4208024870E+00, 2.7198932824E-01, 2.4517077150E-01, 5.4221482077E-01],
	[9.9350000000E+03, 4.5963781087E+00, 5.4200285214E+00, 2.7242237834E-01, 2.4552928792E-01, 5.4239870314E-01],
	[9.9400000000E+03, 4.5992886412E+00, 5.4192643716E+00, 2.7285589944E-01, 2.4588813657E-01, 5.4258255898E-01],
	[9.9450000000E+03, 4.6022004192E+00, 5.4185028111E+00, 2.7328989180E-01, 2.4624729422E-01, 5.4276638825E-01],
	[9.9500000000E+03, 4.6051125756E+00, 5.4177417403E+00, 2.7372435572E-01, 2.4660675406E-01, 5.4295019097E-01],
	[9.9550000000E+03, 4.6080251104E+00, 5.4169811586E+00, 2.7415929145E-01, 2.4696651608E-01, 5.4313396710E-01],
	[9.9600000000E+03, 4.6109380233E+00, 5.4162210656E+00, 2.7459469928E-01, 2.4732658027E-01, 5.4331771666E-01],
	[9.9650000000E+03, 4.6138513143E+00, 5.4154614606E+00, 2.7503057948E-01, 2.4768694661E-01, 5.4350143962E-01],
	[9.9700000000E+03, 4.6167649832E+00, 5.4147023432E+00, 2.7546693233E-01, 2.4804761509E-01, 5.4368513599E-01],
	[9.9750000000E+03, 4.6196790298E+00, 5.4139437126E+00, 2.7590375810E-01, 2.4840858567E-01, 5.4386880574E-01],
	[9.9800000000E+03, 4.6225934541E+00, 5.4131855685E+00, 2.7634105706E-01, 2.4876985836E-01, 5.4405244887E-01],
	[9.9850000000E+03, 4.6255082559E+00, 5.4124279101E+00, 2.7677882950E-01, 2.4913143313E-01, 5.4423606537E-01],
	[9.9900000000E+03, 4.6284234349E+00, 5.4116707371E+00, 2.7721707568E-01, 2.4949330996E-01, 5.4441965524E-01],
	[9.9950000000E+03, 4.6313389912E+00, 5.4109140487E+00, 2.7765579588E-01, 2.4985548883E-01, 5.4460321846E-01],
	[1.0000000000E+04, 4.6342549246E+00, 5.4101578445E+00, 2.7809499038E-01, 2.5021796973E-01, 5.4478675502E-01],
	[1.0005000000E+04, 4.6371712348E+00, 5.4094021239E+00, 2.7853724347E-01, 2.5058284402E-01, 5.4497026492E-01],
	[1.0010000000E+04, 4.6400879219E+00, 5.4086468864E+00, 2.7897997824E-01, 2.5094802473E-01, 5.4515374815E-01],
	[1.0015000000E+04, 4.6430049855E+00, 5.4078921314E+00, 2.7942319500E-01, 2.5131351185E-01, 5.4533720470E-01],
	[1.0020000000E+04, 4.6459224257E+00, 5.4071378584E+00, 2.7986689401E-01, 2.5167930536E-01, 5.4552063455E-01],
	[1.0025000000E+04, 4.6488402423E+00, 5.4063840667E+00, 2.8031107557E-01, 2.5204540525E-01, 5.4570403769E-01],
	[1.0030000000E+04, 4.6517584350E+00, 5.4056307560E+00, 2.8075573996E-01, 2.5241181149E-01, 5.4588741406E-01],
	[1.0035000000E+04, 4.6546770039E+00, 5.4048779255E+00, 2.8120088746E-01, 2.5277852407E-01, 5.4607076364E-01],
	[1.0040000000E+04, 4.6575959487E+00, 5.4041255749E+00, 2.8164651835E-01, 2.5314554296E-01, 5.4625408641E-01],
	[1.0045000000E+04, 4.6605152693E+00, 5.4033737034E+00, 2.8209263291E-01, 2.5351286815E-01, 5.4643738233E-01],
	[1.0050000000E+04, 4.6634349655E+00, 5.4026223107E+00, 2.8253923144E-01, 2.5388049961E-01, 5.4662065139E-01],
	[1.0055000000E+04, 4.6663550373E+00, 5.4018713961E+00, 2.8298631422E-01, 2.5424843734E-01, 5.4680389356E-01],
	[1.0060000000E+04, 4.6692754845E+00, 5.4011209591E+00, 2.8343388152E-01, 2.5461668129E-01, 5.4698710881E-01],
	[1.0065000000E+04, 4.6721963070E+00, 5.4003709992E+00, 2.8388193364E-01, 2.5498523147E-01, 5.4717029713E-01],
	[1.0070000000E+04, 4.6751175045E+00, 5.3996215158E+00, 2.8433047085E-01, 2.5535408783E-01, 5.4735345848E-01],
	[1.0075000000E+04, 4.6780390770E+00, 5.3988725083E+00, 2.8477949344E-01, 2.5572325037E-01, 5.4753659283E-01],
	[1.0080000000E+04, 4.6809610244E+00, 5.3981239763E+00, 2.8522900169E-01, 2.5609271906E-01, 5.4771970018E-01],
	[1.0085000000E+04, 4.6838833464E+00, 5.3973759193E+00, 2.8567899590E-01, 2.5646249387E-01, 5.4790278049E-01],
	[1.0090000000E+04, 4.6868060431E+00, 5.3966283366E+00, 2.8612947633E-01, 2.5683257480E-01, 5.4808583373E-01],
	[1.0095000000E+04, 4.6897291141E+00, 5.3958812277E+00, 2.8658044328E-01, 2.5720296180E-01, 5.4826885989E-01],
	[1.0100000000E+04, 4.6926567052E+00, 5.3951437141E+00, 2.8703189703E-01, 2.5757368815E-01, 5.4845185893E-01],
	[1.0105000000E+04, 4.6955855521E+00, 5.3944085975E+00, 2.8748383786E-01, 2.5794472776E-01, 5.4863483084E-01],
	[1.0110000000E+04, 4.6985147767E+00, 5.3936739447E+00, 2.8793626605E-01, 2.5831607359E-01, 5.4881777559E-01],
	[1.0115000000E+04, 4.7014443789E+00, 5.3929397551E+00, 2.8838918190E-01, 2.5868772561E-01, 5.4900069316E-01],
	[1.0120000000E+04, 4.7043743587E+00, 5.3922060282E+00, 2.8884258568E-01, 2.5905968380E-01, 5.4918358352E-01],
	[1.0125000000E+04, 4.7073047159E+00, 5.3914727635E+00, 2.8929647768E-01, 2.5943194813E-01, 5.4936644665E-01],
	[1.0130000000E+04, 4.7102354503E+00, 5.3907399604E+00, 2.8975085819E-01, 2.5980451857E-01, 5.4954928253E-01],
	[1.0135000000E+04, 4.7131665617E+00, 5.3900076185E+00, 2.9020572748E-01, 2.6017739512E-01, 5.4973209112E-01],
	[1.0140000000E+04, 4.7160980502E+00, 5.3892757372E+00, 2.9066108584E-01, 2.6055057773E-01, 5.4991487242E-01],
	[1.0145000000E+04, 4.7190299155E+00, 5.3885443160E+00, 2.9111693355E-01, 2.6092406638E-01, 5.5009762638E-01],
	[1.0150000000E+04, 4.7219621574E+00, 5.3878133543E+00, 2.9157327091E-01, 2.6129786106E-01, 5.5028035300E-01],
	[1.0155000000E+04, 4.7248947759E+00, 5.3870828518E+00, 2.9203009818E-01, 2.6167196173E-01, 5.5046305225E-01],
	[1.0160000000E+04, 4.7278277708E+00, 5.3863528078E+00, 2.9248741567E-01, 2.6204636836E-01, 5.5064572410E-01],
	[1.0165000000E+04, 4.7307611420E+00, 5.3856232219E+00, 2.9294522364E-01, 2.6242108094E-01, 5.5082836853E-01],
	[1.0170000000E+04, 4.7336948894E+00, 5.3848940935E+00, 2.9340352240E-01, 2.6279609943E-01, 5.5101098552E-01],
	[1.0175000000E+04, 4.7366290127E+00, 5.3841654221E+00, 2.9386231221E-01, 2.6317142380E-01, 5.5119357504E-01],
	[1.0180000000E+04, 4.7395635119E+00, 5.3834372072E+00, 2.9432159336E-01, 2.6354705404E-01, 5.5137613707E-01],
	[1.0185000000E+04, 4.7424983868E+00, 5.3827094483E+00, 2.9478136615E-01, 2.6392299011E-01, 5.5155867159E-01],
	[1.0190000000E+04, 4.7454336373E+00, 5.3819821449E+00, 2.9524163084E-01, 2.6429923198E-01, 5.5174117858E-01],
	[1.0195000000E+04, 4.7483692633E+00, 5.3812552965E+00, 2.9570238774E-01, 2.6467577963E-01, 5.5192365801E-01],
	[1.0200000000E+04, 4.7513052646E+00, 5.3805289026E+00, 2.9616363711E-01, 2.6505263303E-01, 5.5210610986E-01],
	[1.0205000000E+04, 4.7542416411E+00, 5.3798029627E+00, 2.9662537925E-01, 2.6542979214E-01, 5.5228853411E-01],
	[1.0210000000E+04, 4.7571783926E+00, 5.3790774762E+00, 2.9708761444E-01, 2.6580725695E-01, 5.5247093073E-01],
	[1.0215000000E+04, 4.7601155191E+00, 5.3783524426E+00, 2.9755034297E-01, 2.6618502742E-01, 5.5265329970E-01],
	[1.0220000000E+04, 4.7630530203E+00, 5.3776278616E+00, 2.9801356511E-01, 2.6656310351E-01, 5.5283564100E-01],
	[1.0225000000E+04, 4.7659908961E+00, 5.3769037324E+00, 2.9847728116E-01, 2.6694148521E-01, 5.5301795461E-01],
	[1.0230000000E+04, 4.7689291465E+00, 5.3761800547E+00, 2.9894149140E-01, 2.6732017248E-01, 5.5320024050E-01],
	[1.0235000000E+04, 4.7718677712E+00, 5.3754568280E+00, 2.9940619611E-01, 2.6769916529E-01, 5.5338249865E-01],
	[1.0240000000E+04, 4.7748067702E+00, 5.3747340517E+00, 2.9987139557E-01, 2.6807846361E-01, 5.5356472904E-01],
	[1.0245000000E+04, 4.7777461433E+00, 5.3740117254E+00, 3.0033709008E-01, 2.6845806741E-01, 5.5374693166E-01],
	[1.0250000000E+04, 4.7806858903E+00, 5.3732898485E+00, 3.0080327991E-01, 2.6883797665E-01, 5.5392910646E-01],
	[1.0255000000E+04, 4.7836260111E+00, 5.3725684205E+00, 3.0126996536E-01, 2.6921819131E-01, 5.5411125344E-01],
	[1.0260000000E+04, 4.7865682367E+00, 5.3718508789E+00, 3.0173714670E-01, 2.6959872550E-01, 5.5429337257E-01],
	[1.0265000000E+04, 4.7895145296E+00, 5.3711411103E+00, 3.0220482422E-01, 2.6997959536E-01, 5.5447546383E-01],
	[1.0270000000E+04, 4.7924611999E+00, 5.3704317812E+00, 3.0267299820E-01, 2.7036077075E-01, 5.5465752720E-01],
	[1.0275000000E+04, 4.7954082475E+00, 5.3697228909E+00, 3.0314166894E-01, 2.7074225164E-01, 5.5483956266E-01],
	[1.0280000000E+04, 4.7983556723E+00, 5.3690144390E+00, 3.0361083671E-01, 2.7112403800E-01, 5.5502157018E-01],
	[1.0285000000E+04, 4.8013034741E+00, 5.3683064249E+00, 3.0408050179E-01, 2.7150612980E-01, 5.5520354974E-01],
	[1.0290000000E+04, 4.8042516529E+00, 5.3675988483E+00, 3.0455066449E-01, 2.7188852700E-01, 5.5538550132E-01],
	[1.0295000000E+04, 4.8072002084E+00, 5.3668917086E+00, 3.0502132507E-01, 2.7227122957E-01, 5.5556742490E-01],
	[1.0300000000E+04, 4.8101491406E+00, 5.3661850054E+00, 3.0549248382E-01, 2.7265423747E-01, 5.5574932046E-01],
	[1.0305000000E+04, 4.8130984493E+00, 5.3654787381E+00, 3.0596414104E-01, 2.7303755067E-01, 5.5593118798E-01],
	[1.0310000000E+04, 4.8160481343E+00, 5.3647729064E+00, 3.0643629699E-01, 2.7342116914E-01, 5.5611302743E-01],
	[1.0315000000E+04, 4.8189981956E+00, 5.3640675096E+00, 3.0690895198E-01, 2.7380509284E-01, 5.5629483880E-01],
	[1.0320000000E+04, 4.8219486330E+00, 5.3633625473E+00, 3.0738210628E-01, 2.7418932174E-01, 5.5647662206E-01],
	[1.0325000000E+04, 4.8248994463E+00, 5.3626580191E+00, 3.0785576017E-01, 2.7457385579E-01, 5.5665837719E-01],
	[1.0330000000E+04, 4.8278506355E+00, 5.3619539245E+00, 3.0832991395E-01, 2.7495869498E-01, 5.5684010417E-01],
	[1.0335000000E+04, 4.8308022004E+00, 5.3612502630E+00, 3.0880456790E-01, 2.7534383925E-01, 5.5702180298E-01],
	[1.0340000000E+04, 4.8337541408E+00, 5.3605470341E+00, 3.0927972230E-01, 2.7572928857E-01, 5.5720347360E-01],
	[1.0345000000E+04, 4.8367064567E+00, 5.3598442373E+00, 3.0975537744E-01, 2.7611504291E-01, 5.5738511601E-01],
	[1.0350000000E+04, 4.8396591479E+00, 5.3591418722E+00, 3.1023153361E-01, 2.7650110223E-01, 5.5756673019E-01],
	[1.0355000000E+04, 4.8426122142E+00, 5.3584399383E+00, 3.1070819108E-01, 2.7688746650E-01, 5.5774831611E-01],
	[1.0360000000E+04, 4.8455656556E+00, 5.3577384352E+00, 3.1118535014E-01, 2.7727413567E-01, 5.5792987376E-01],
	[1.0365000000E+04, 4.8485194719E+00, 5.3570373622E+00, 3.1166301109E-01, 2.7766110970E-01, 5.5811140312E-01],
	[1.0370000000E+04, 4.8514736629E+00, 5.3563367191E+00, 3.1214117420E-01, 2.7804838857E-01, 5.5829290416E-01],
	[1.0375000000E+04, 4.8544282285E+00, 5.3556365053E+00, 3.1261983975E-01, 2.7843597222E-01, 5.5847437686E-01],
	[1.0380000000E+04, 4.8573831687E+00, 5.3549367203E+00, 3.1309900805E-01, 2.7882386063E-01, 5.5865582121E-01],
	[1.0385000000E+04, 4.8603384832E+00, 5.3542373637E+00, 3.1357867936E-01, 2.7921205376E-01, 5.5883723718E-01],
	[1.0390000000E+04, 4.8632941720E+00, 5.3535384350E+00, 3.1405885397E-01, 2.7960055155E-01, 5.5901862476E-01],
	[1.0395000000E+04, 4.8662502348E+00, 5.3528399337E+00, 3.1453953218E-01, 2.7998935398E-01, 5.5919998392E-01],
	[1.0400000000E+04, 4.8692066716E+00, 5.3521418594E+00, 3.1502071426E-01, 2.8037846101E-01, 5.5938131464E-01],
	[1.0405000000E+04, 4.8721634823E+00, 5.3514442116E+00, 3.1550240051E-01, 2.8076787259E-01, 5.5956261690E-01],
	[1.0410000000E+04, 4.8751206666E+00, 5.3507469899E+00, 3.1598459120E-01, 2.8115758868E-01, 5.5974389069E-01],
	[1.0415000000E+04, 4.8780782245E+00, 5.3500501937E+00, 3.1646728662E-01, 2.8154760925E-01, 5.5992513598E-01],
	[1.0420000000E+04, 4.8810361559E+00, 5.3493538226E+00, 3.1695048706E-01, 2.8193793425E-01, 5.6010635276E-01],
	[1.0425000000E+04, 4.8839961503E+00, 5.3486609182E+00, 3.1743419280E-01, 2.8232857776E-01, 5.6028754100E-01],
	[1.0430000000E+04, 4.8869606579E+00, 5.3479758811E+00, 3.1791840413E-01, 2.8271956035E-01, 5.6046870068E-01],
	[1.0435000000E+04, 4.8899255427E+00, 5.3472912599E+00, 3.1840312133E-01, 2.8311084747E-01, 5.6064983179E-01],
	[1.0440000000E+04, 4.8928908048E+00, 5.3466070544E+00, 3.1888834470E-01, 2.8350243909E-01, 5.6083093430E-01],
	[1.0445000000E+04, 4.8958564439E+00, 5.3459232639E+00, 3.1937407450E-01, 2.8389433517E-01, 5.6101200820E-01],
	[1.0450000000E+04, 4.8988224599E+00, 5.3452398880E+00, 3.1986031104E-01, 2.8428653566E-01, 5.6119305346E-01],
	[1.0455000000E+04, 4.9017888527E+00, 5.3445569264E+00, 3.2034705460E-01, 2.8467904052E-01, 5.6137407007E-01],
	[1.0460000000E+04, 4.9047556221E+00, 5.3438743784E+00, 3.2083430545E-01, 2.8507184971E-01, 5.6155505800E-01],
	[1.0465000000E+04, 4.9077227681E+00, 5.3431922438E+00, 3.2132206389E-01, 2.8546496318E-01, 5.6173601725E-01],
	[1.0470000000E+04, 4.9106902904E+00, 5.3425105220E+00, 3.2181033021E-01, 2.8585838089E-01, 5.6191694778E-01],
	[1.0475000000E+04, 4.9136581890E+00, 5.3418292126E+00, 3.2229910468E-01, 2.8625210280E-01, 5.6209784958E-01],
	[1.0480000000E+04, 4.9166264638E+00, 5.3411483152E+00, 3.2278838760E-01, 2.8664612886E-01, 5.6227872263E-01],
	[1.0485000000E+04, 4.9195951145E+00, 5.3404678293E+00, 3.2327817925E-01, 2.8704045903E-01, 5.6245956691E-01],
	[1.0490000000E+04, 4.9225641410E+00, 5.3397877544E+00, 3.2376847991E-01, 2.8743509326E-01, 5.6264038240E-01],
	[1.0495000000E+04, 4.9255335433E+00, 5.3391080902E+00, 3.2425928988E-01, 2.8783003151E-01, 5.6282116909E-01],
	[1.0500000000E+04, 4.9285033212E+00, 5.3384288361E+00, 3.2475060943E-01, 2.8822527374E-01, 5.6300192694E-01],
	[1.0505000000E+04, 4.9314734745E+00, 5.3377499918E+00, 3.2524243885E-01, 2.8862081989E-01, 5.6318265596E-01],
	[1.0510000000E+04, 4.9344440032E+00, 5.3370715567E+00, 3.2573477844E-01, 2.8901666993E-01, 5.6336335611E-01],
	[1.0515000000E+04, 4.9374149070E+00, 5.3363935305E+00, 3.2622762847E-01, 2.8941282380E-01, 5.6354402736E-01],
	[1.0520000000E+04, 4.9403861860E+00, 5.3357159127E+00, 3.2672098923E-01, 2.8980928147E-01, 5.6372466967E-01],
	[1.0525000000E+04, 4.9433578399E+00, 5.3350387029E+00, 3.2721486100E-01, 2.9020604287E-01, 5.6390528301E-01],
	[1.0530000000E+04, 4.9463298685E+00, 5.3343619006E+00, 3.2770924408E-01, 2.9060310798E-01, 5.6408586734E-01],
	[1.0535000000E+04, 4.9493022719E+00, 5.3336855054E+00, 3.2820413875E-01, 2.9100047673E-01, 5.6426642265E-01],
	[1.0540000000E+04, 4.9522750498E+00, 5.3330095169E+00, 3.2869954530E-01, 2.9139814908E-01, 5.6444694888E-01],
	[1.0545000000E+04, 4.9552482021E+00, 5.3323339345E+00, 3.2919546400E-01, 2.9179612499E-01, 5.6462744603E-01],
	[1.0550000000E+04, 4.9582217287E+00, 5.3316587580E+00, 3.2969189515E-01, 2.9219440440E-01, 5.6480791405E-01],
	[1.0555000000E+04, 4.9611956295E+00, 5.3309839868E+00, 3.3018883903E-01, 2.9259298727E-01, 5.6498835291E-01],
	[1.0560000000E+04, 4.9641699042E+00, 5.3303096205E+00, 3.3068629593E-01, 2.9299187354E-01, 5.6516876259E-01],
	[1.0565000000E+04, 4.9671445529E+00, 5.3296356586E+00, 3.3118426614E-01, 2.9339106318E-01, 5.6534914306E-01],
	[1.0570000000E+04, 4.9701195753E+00, 5.3289621008E+00, 3.3168274994E-01, 2.9379055613E-01, 5.6552949428E-01],
	[1.0575000000E+04, 4.9730949714E+00, 5.3282889466E+00, 3.3218174761E-01, 2.9419035233E-01, 5.6570981623E-01],
	[1.0580000000E+04, 4.9760707410E+00, 5.3276161956E+00, 3.3268125945E-01, 2.9459045175E-01, 5.6589010887E-01],
	[1.0585000000E+04, 4.9790468839E+00, 5.3269438474E+00, 3.3318128574E-01, 2.9499085432E-01, 5.6607037218E-01],
	[1.0590000000E+04, 4.9820234001E+00, 5.3262719014E+00, 3.3368182677E-01, 2.9539156000E-01, 5.6625060613E-01],
	[1.0595000000E+04, 4.9850048358E+00, 5.3256078059E+00, 3.3418288281E-01, 2.9579260773E-01, 5.6643081068E-01],
	[1.0600000000E+04, 4.9879883385E+00, 5.3249468745E+00, 3.3468445417E-01, 2.9619397317E-01, 5.6661098581E-01],
	[1.0605000000E+04, 4.9909722185E+00, 5.3242863368E+00, 3.3518654112E-01, 2.9659564181E-01, 5.6679113149E-01],
	[1.0610000000E+04, 4.9939564758E+00, 5.3236261923E+00, 3.3568914395E-01, 2.9699761361E-01, 5.6697124769E-01],
	[1.0615000000E+04, 4.9969411102E+00, 5.3229664406E+00, 3.3619226295E-01, 2.9739988850E-01, 5.6715133437E-01],
	[1.0620000000E+04, 4.9999261216E+00, 5.3223070813E+00, 3.3669589840E-01, 2.9780246644E-01, 5.6733139152E-01],
	[1.0625000000E+04, 5.0029115098E+00, 5.3216481139E+00, 3.3720005060E-01, 2.9820534738E-01, 5.6751141909E-01],
	[1.0630000000E+04, 5.0058972748E+00, 5.3209895382E+00, 3.3770471982E-01, 2.9860853127E-01, 5.6769141707E-01],
	[1.0635000000E+04, 5.0088834163E+00, 5.3203313536E+00, 3.3820990635E-01, 2.9901201804E-01, 5.6787138542E-01],
	[1.0640000000E+04, 5.0118699343E+00, 5.3196735597E+00, 3.3871561048E-01, 2.9941580766E-01, 5.6805132412E-01],
	[1.0645000000E+04, 5.0148568286E+00, 5.3190161561E+00, 3.3922183250E-01, 2.9981990005E-01, 5.6823123313E-01],
	[1.0650000000E+04, 5.0178440991E+00, 5.3183591424E+00, 3.3972857269E-01, 3.0022429519E-01, 5.6841111242E-01],
	[1.0655000000E+04, 5.0208317457E+00, 5.3177025182E+00, 3.4023583135E-01, 3.0062899300E-01, 5.6859096197E-01],
	[1.0660000000E+04, 5.0238197683E+00, 5.3170462831E+00, 3.4074360874E-01, 3.0103399343E-01, 5.6877078175E-01],
	[1.0665000000E+04, 5.0268081666E+00, 5.3163904366E+00, 3.4125190517E-01, 3.0143929643E-01, 5.6895057173E-01],
	[1.0670000000E+04, 5.0297969406E+00, 5.3157349784E+00, 3.4176072092E-01, 3.0184490195E-01, 5.6913033189E-01],
	[1.0675000000E+04, 5.0327860902E+00, 5.3150799080E+00, 3.4227005628E-01, 3.0225080993E-01, 5.6931006218E-01],
	[1.0680000000E+04, 5.0357756152E+00, 5.3144252250E+00, 3.4277991152E-01, 3.0265702031E-01, 5.6948976259E-01],
	[1.0685000000E+04, 5.0387655156E+00, 5.3137709290E+00, 3.4329028695E-01, 3.0306353305E-01, 5.6966943308E-01],
	[1.0690000000E+04, 5.0417557910E+00, 5.3131170197E+00, 3.4380118284E-01, 3.0347034807E-01, 5.6984907364E-01],
	[1.0695000000E+04, 5.0447464416E+00, 5.3124634965E+00, 3.4431259948E-01, 3.0387746533E-01, 5.7002868422E-01],
	[1.0700000000E+04, 5.0477374670E+00, 5.3118103591E+00, 3.4482453717E-01, 3.0428488478E-01, 5.7020826480E-01],
	[1.0705000000E+04, 5.0507288672E+00, 5.3111576071E+00, 3.4533699618E-01, 3.0469260635E-01, 5.7038781536E-01],
	[1.0710000000E+04, 5.0537206421E+00, 5.3105052401E+00, 3.4584997680E-01, 3.0510062998E-01, 5.7056733586E-01],
	[1.0715000000E+04, 5.0567127915E+00, 5.3098532576E+00, 3.4636347932E-01, 3.0550895562E-01, 5.7074682628E-01],
	[1.0720000000E+04, 5.0597053153E+00, 5.3092016593E+00, 3.4687750403E-01, 3.0591758322E-01, 5.7092628659E-01],
	[1.0725000000E+04, 5.0626982134E+00, 5.3085504447E+00, 3.4739205121E-01, 3.0632651271E-01, 5.7110571676E-01],
	[1.0730000000E+04, 5.0656914856E+00, 5.3078996135E+00, 3.4790712115E-01, 3.0673574403E-01, 5.7128511677E-01],
	[1.0735000000E+04, 5.0686851319E+00, 5.3072491652E+00, 3.4842271414E-01, 3.0714527714E-01, 5.7146448658E-01],
	[1.0740000000E+04, 5.0716791520E+00, 5.3065990995E+00, 3.4893883046E-01, 3.0755511196E-01, 5.7164382617E-01],
	[1.0745000000E+04, 5.0746735459E+00, 5.3059494159E+00, 3.4945547041E-01, 3.0796524844E-01, 5.7182313551E-01],
	[1.0750000000E+04, 5.0776683134E+00, 5.3053001140E+00, 3.4997263426E-01, 3.0837568652E-01, 5.7200241458E-01],
	[1.0755000000E+04, 5.0806634545E+00, 5.3046511935E+00, 3.5049032231E-01, 3.0878642614E-01, 5.7218166334E-01],
	[1.0760000000E+04, 5.0836589689E+00, 5.3040026539E+00, 3.5100853484E-01, 3.0919746724E-01, 5.7236088177E-01],
	[1.0765000000E+04, 5.0866590299E+00, 5.3033607434E+00, 3.5152727214E-01, 3.0960884651E-01, 5.7254006985E-01],
	[1.0770000000E+04, 5.0896619430E+00, 5.3027229131E+00, 3.5204653449E-01, 3.1002054916E-01, 5.7271922753E-01],
	[1.0775000000E+04, 5.0926652339E+00, 5.3020854556E+00, 3.5256632219E-01, 3.1043255337E-01, 5.7289835481E-01],
	[1.0780000000E+04, 5.0956689024E+00, 5.3014483704E+00, 3.5308663552E-01, 3.1084485909E-01, 5.7307745165E-01],
	[1.0785000000E+04, 5.0986729484E+00, 5.3008116571E+00, 3.5360747477E-01, 3.1125746624E-01, 5.7325651802E-01],
	[1.0790000000E+04, 5.1016773717E+00, 5.3001753154E+00, 3.5412884022E-01, 3.1167037478E-01, 5.7343555389E-01],
	[1.0795000000E+04, 5.1046821724E+00, 5.2995393448E+00, 3.5465073217E-01, 3.1208358463E-01, 5.7361455925E-01],
	[1.0800000000E+04, 5.1076873501E+00, 5.2989037449E+00, 3.5517315089E-01, 3.1249709574E-01, 5.7379353406E-01],
	[1.0805000000E+04, 5.1106929048E+00, 5.2982685154E+00, 3.5569609668E-01, 3.1291090805E-01, 5.7397247830E-01],
	[1.0810000000E+04, 5.1136988363E+00, 5.2976336559E+00, 3.5621956983E-01, 3.1332502148E-01, 5.7415139193E-01],
	[1.0815000000E+04, 5.1167051446E+00, 5.2969991660E+00, 3.5674357062E-01, 3.1373943599E-01, 5.7433027494E-01],
	[1.0820000000E+04, 5.1197118295E+00, 5.2963650453E+00, 3.5726809933E-01, 3.1415415150E-01, 5.7450912730E-01],
	[1.0825000000E+04, 5.1227188909E+00, 5.2957312934E+00, 3.5779315626E-01, 3.1456916796E-01, 5.7468794897E-01],
	[1.0830000000E+04, 5.1257263286E+00, 5.2950979100E+00, 3.5831874169E-01, 3.1498448530E-01, 5.7486673994E-01],
	[1.0835000000E+04, 5.1287341426E+00, 5.2944648946E+00, 3.5884485592E-01, 3.1540010345E-01, 5.7504550018E-01],
	[1.0840000000E+04, 5.1317423326E+00, 5.2938322469E+00, 3.5937149922E-01, 3.1581602235E-01, 5.7522422966E-01],
	[1.0845000000E+04, 5.1347508987E+00, 5.2931999665E+00, 3.5989867189E-01, 3.1623224195E-01, 5.7540292835E-01],
	[1.0850000000E+04, 5.1377598405E+00, 5.2925680530E+00, 3.6042637421E-01, 3.1664876216E-01, 5.7558159623E-01],
	[1.0855000000E+04, 5.1407691581E+00, 5.2919365060E+00, 3.6095460647E-01, 3.1706558294E-01, 5.7576023328E-01],
	[1.0860000000E+04, 5.1437788513E+00, 5.2913053252E+00, 3.6148336896E-01, 3.1748270421E-01, 5.7593883946E-01],
	[1.0865000000E+04, 5.1467889199E+00, 5.2906745101E+00, 3.6201266197E-01, 3.1790012590E-01, 5.7611741475E-01],
	[1.0870000000E+04, 5.1497993639E+00, 5.2900440604E+00, 3.6254248578E-01, 3.1831784796E-01, 5.7629595913E-01],
	[1.0875000000E+04, 5.1528101831E+00, 5.2894139757E+00, 3.6307284067E-01, 3.1873587031E-01, 5.7647447256E-01],
	[1.0880000000E+04, 5.1558213774E+00, 5.2887842556E+00, 3.6360372695E-01, 3.1915419289E-01, 5.7665295503E-01],
	[1.0885000000E+04, 5.1588329467E+00, 5.2881548998E+00, 3.6413514489E-01, 3.1957281564E-01, 5.7683140651E-01],
	[1.0890000000E+04, 5.1618448908E+00, 5.2875259078E+00, 3.6466709479E-01, 3.1999173848E-01, 5.7700982697E-01],
	[1.0895000000E+04, 5.1648572096E+00, 5.2868972794E+00, 3.6519957693E-01, 3.2041096134E-01, 5.7718821639E-01],
	[1.0900000000E+04, 5.1678699029E+00, 5.2862690140E+00, 3.6573259159E-01, 3.2083048417E-01, 5.7736657474E-01],
	[1.0905000000E+04, 5.1708829708E+00, 5.2856411114E+00, 3.6626613908E-01, 3.2125030689E-01, 5.7754490199E-01],
	[1.0910000000E+04, 5.1738964130E+00, 5.2850135711E+00, 3.6680021967E-01, 3.2167042943E-01, 5.7772319813E-01],
	[1.0915000000E+04, 5.1769102294E+00, 5.2843863929E+00, 3.6733483365E-01, 3.2209085173E-01, 5.7790146312E-01],
	[1.0920000000E+04, 5.1799244199E+00, 5.2837595762E+00, 3.6786998131E-01, 3.2251157372E-01, 5.7807969694E-01],
	[1.0925000000E+04, 5.1829389843E+00, 5.2831331208E+00, 3.6840566293E-01, 3.2293259533E-01, 5.7825789956E-01],
	[1.0930000000E+04, 5.1859539226E+00, 5.2825070262E+00, 3.6894187882E-01, 3.2335391648E-01, 5.7843607097E-01],
	[1.0935000000E+04, 5.1889692346E+00, 5.2818812922E+00, 3.6947862924E-01, 3.2377553711E-01, 5.7861421113E-01],
	[1.0940000000E+04, 5.1919918261E+00, 5.2812653964E+00, 3.7001591450E-01, 3.2419751980E-01, 5.7879232002E-01],
	[1.0945000000E+04, 5.1950149554E+00, 5.2806500724E+00, 3.7055373488E-01, 3.2461980355E-01, 5.7897039761E-01],
	[1.0950000000E+04, 5.1980384629E+00, 5.2800351010E+00, 3.7109209066E-01, 3.2504238684E-01, 5.7914844389E-01],
	[1.0955000000E+04, 5.2010623487E+00, 5.2794204820E+00, 3.7163098214E-01, 3.2546526962E-01, 5.7932645882E-01],
	[1.0960000000E+04, 5.2040866125E+00, 5.2788062149E+00, 3.7217040960E-01, 3.2588845181E-01, 5.7950444238E-01],
	[1.0965000000E+04, 5.2071112543E+00, 5.2781922994E+00, 3.7271037333E-01, 3.2631193333E-01, 5.7968239454E-01],
	[1.0970000000E+04, 5.2101362740E+00, 5.2775787352E+00, 3.7325087363E-01, 3.2673571413E-01, 5.7986031529E-01],
	[1.0975000000E+04, 5.2131616713E+00, 5.2769655218E+00, 3.7379191077E-01, 3.2715979412E-01, 5.8003820460E-01],
	[1.0980000000E+04, 5.2161874462E+00, 5.2763526589E+00, 3.7433348504E-01, 3.2758417323E-01, 5.8021606246E-01],
	[1.0985000000E+04, 5.2192135985E+00, 5.2757401461E+00, 3.7487559674E-01, 3.2800885140E-01, 5.8039388894E-01],
	[1.0990000000E+04, 5.2222401282E+00, 5.2751279832E+00, 3.7541824615E-01, 3.2843382855E-01, 5.8057168401E-01],
	[1.0995000000E+04, 5.2252670350E+00, 5.2745161697E+00, 3.7596143356E-01, 3.2885910461E-01, 5.8074944765E-01],
	[1.1000000000E+04, 5.2282943190E+00, 5.2739047052E+00, 3.7650515925E-01, 3.2928467950E-01, 5.8092717981E-01],
	[1.1005000000E+04, 5.2313219799E+00, 5.2732935895E+00, 3.7704942352E-01, 3.2971055316E-01, 5.8110488045E-01],
	[1.1010000000E+04, 5.2343500176E+00, 5.2726828221E+00, 3.7759422666E-01, 3.3013672550E-01, 5.8128254954E-01],
	[1.1015000000E+04, 5.2373784320E+00, 5.2720724027E+00, 3.7813956895E-01, 3.3056319647E-01, 5.8146018705E-01],
	[1.1020000000E+04, 5.2404072230E+00, 5.2714623309E+00, 3.7868545068E-01, 3.3098996597E-01, 5.8163779293E-01],
	[1.1025000000E+04, 5.2434363904E+00, 5.2708526065E+00, 3.7923187214E-01, 3.3141703394E-01, 5.8181536715E-01],
	[1.1030000000E+04, 5.2464659342E+00, 5.2702432290E+00, 3.7977883361E-01, 3.3184440030E-01, 5.8199290968E-01],
	[1.1035000000E+04, 5.2494958542E+00, 5.2696341980E+00, 3.8032633539E-01, 3.3227206498E-01, 5.8217042047E-01],
	[1.1040000000E+04, 5.2525261503E+00, 5.2690255133E+00, 3.8087437777E-01, 3.3270002791E-01, 5.8234789950E-01],
	[1.1045000000E+04, 5.2555568223E+00, 5.2684171744E+00, 3.8142296102E-01, 3.3312828900E-01, 5.8252534673E-01],
	[1.1050000000E+04, 5.2585878702E+00, 5.2678091811E+00, 3.8197208545E-01, 3.3355684819E-01, 5.8270276211E-01],
	[1.1055000000E+04, 5.2616192937E+00, 5.2672015329E+00, 3.8252175134E-01, 3.3398570539E-01, 5.8288014563E-01],
	[1.1060000000E+04, 5.2646510929E+00, 5.2665942296E+00, 3.8307195897E-01, 3.3441486053E-01, 5.8305749723E-01],
	[1.1065000000E+04, 5.2676832675E+00, 5.2659872707E+00, 3.8362270864E-01, 3.3484431353E-01, 5.8323481688E-01],
	[1.1070000000E+04, 5.2707158175E+00, 5.2653806559E+00, 3.8417400063E-01, 3.3527406432E-01, 5.8341210456E-01],
	[1.1075000000E+04, 5.2737487427E+00, 5.2647743849E+00, 3.8472583524E-01, 3.3570411282E-01, 5.8358936021E-01],
	[1.1080000000E+04, 5.2767820429E+00, 5.2641684573E+00, 3.8527821274E-01, 3.3613445895E-01, 5.8376658382E-01],
	[1.1085000000E+04, 5.2798157182E+00, 5.2635628727E+00, 3.8583113344E-01, 3.3656510264E-01, 5.8394377534E-01],
	[1.1090000000E+04, 5.2828497683E+00, 5.2629576309E+00, 3.8638459762E-01, 3.3699604380E-01, 5.8412093473E-01],
	[1.1095000000E+04, 5.2858841931E+00, 5.2623527314E+00, 3.8693860556E-01, 3.3742728236E-01, 5.8429806197E-01],
	[1.1100000000E+04, 5.2889189926E+00, 5.2617481739E+00, 3.8749315756E-01, 3.3785881824E-01, 5.8447515701E-01],
	[1.1105000000E+04, 5.2919541665E+00, 5.2611439581E+00, 3.8804825390E-01, 3.3829065136E-01, 5.8465221983E-01],
	[1.1110000000E+04, 5.2949897148E+00, 5.2605400837E+00, 3.8860389488E-01, 3.3872278164E-01, 5.8482925039E-01],
	[1.1115000000E+04, 5.2980313956E+00, 5.2599438191E+00, 3.8916008077E-01, 3.3915526282E-01, 5.8500624864E-01],
	[1.1120000000E+04, 5.3010751814E+00, 5.2593500685E+00, 3.8971681188E-01, 3.3958805740E-01, 5.8518321457E-01],
	[1.1125000000E+04, 5.3041193464E+00, 5.2587566518E+00, 3.9027408849E-01, 3.4002114921E-01, 5.8536014813E-01],
	[1.1130000000E+04, 5.3071638905E+00, 5.2581635686E+00, 3.9083191088E-01, 3.4045453815E-01, 5.8553704928E-01],
	[1.1135000000E+04, 5.3102088136E+00, 5.2575708187E+00, 3.9139027935E-01, 3.4088822416E-01, 5.8571391800E-01],
	[1.1140000000E+04, 5.3132541155E+00, 5.2569784017E+00, 3.9194919419E-01, 3.4132220715E-01, 5.8589075426E-01],
	[1.1145000000E+04, 5.3162997961E+00, 5.2563863171E+00, 3.9250865568E-01, 3.4175648705E-01, 5.8606755800E-01],
	[1.1150000000E+04, 5.3193458554E+00, 5.2557945649E+00, 3.9306866411E-01, 3.4219106376E-01, 5.8624432921E-01],
	[1.1155000000E+04, 5.3223922931E+00, 5.2552031444E+00, 3.9362921978E-01, 3.4262593722E-01, 5.8642106784E-01],
	[1.1160000000E+04, 5.3254391091E+00, 5.2546120555E+00, 3.9419032297E-01, 3.4306110733E-01, 5.8659777387E-01],
	[1.1165000000E+04, 5.3284863034E+00, 5.2540212979E+00, 3.9475197396E-01, 3.4349657402E-01, 5.8677444725E-01],
	[1.1170000000E+04, 5.3315338758E+00, 5.2534308711E+00, 3.9531417306E-01, 3.4393233721E-01, 5.8695108796E-01],
	[1.1175000000E+04, 5.3345818262E+00, 5.2528407748E+00, 3.9587692054E-01, 3.4436839681E-01, 5.8712769596E-01],
	[1.1180000000E+04, 5.3376301544E+00, 5.2522510087E+00, 3.9644021670E-01, 3.4480475274E-01, 5.8730427122E-01],
	[1.1185000000E+04, 5.3406788604E+00, 5.2516615725E+00, 3.9700635252E-01, 3.4524313722E-01, 5.8748081370E-01],
	[1.1190000000E+04, 5.3437279440E+00, 5.2510724659E+00, 3.9757318955E-01, 3.4568193166E-01, 5.8765732337E-01],
	[1.1195000000E+04, 5.3467774051E+00, 5.2504836884E+00, 3.9814058206E-01, 3.4612102551E-01, 5.8783380019E-01],
	[1.1200000000E+04, 5.3498272435E+00, 5.2498952399E+00, 3.9870853033E-01, 3.4656041868E-01, 5.8801024414E-01],
	[1.1205000000E+04, 5.3528774593E+00, 5.2493071199E+00, 3.9927703466E-01, 3.4700011109E-01, 5.8818665517E-01],
	[1.1210000000E+04, 5.3559280521E+00, 5.2487193281E+00, 3.9984609536E-01, 3.4744010265E-01, 5.8836303326E-01],
	[1.1215000000E+04, 5.3589790220E+00, 5.2481318642E+00, 4.0041571271E-01, 3.4788039329E-01, 5.8853937838E-01],
	[1.1220000000E+04, 5.3620303687E+00, 5.2475447278E+00, 4.0098588701E-01, 3.4832098292E-01, 5.8871569048E-01],
	[1.1225000000E+04, 5.3650820923E+00, 5.2469579187E+00, 4.0155661856E-01, 3.4876187145E-01, 5.8889196953E-01],
	[1.1230000000E+04, 5.3681341924E+00, 5.2463714365E+00, 4.0212790765E-01, 3.4920305879E-01, 5.8906821551E-01],
	[1.1235000000E+04, 5.3711866691E+00, 5.2457852808E+00, 4.0269975457E-01, 3.4964454487E-01, 5.8924442837E-01],
	[1.1240000000E+04, 5.3742395222E+00, 5.2451994514E+00, 4.0327215964E-01, 3.5008632959E-01, 5.8942060809E-01],
	[1.1245000000E+04, 5.3772927516E+00, 5.2446139480E+00, 4.0384512313E-01, 3.5052841287E-01, 5.8959675464E-01],
	[1.1250000000E+04, 5.3803463571E+00, 5.2440287701E+00, 4.0441864535E-01, 3.5097079463E-01, 5.8977286797E-01],
	[1.1255000000E+04, 5.3834003387E+00, 5.2434439175E+00, 4.0499272660E-01, 3.5141347477E-01, 5.8994894806E-01],
	[1.1260000000E+04, 5.3864546962E+00, 5.2428593898E+00, 4.0556736716E-01, 3.5185645321E-01, 5.9012499488E-01],
	[1.1265000000E+04, 5.3895094295E+00, 5.2422751868E+00, 4.0614256734E-01, 3.5229972986E-01, 5.9030100839E-01],
	[1.1270000000E+04, 5.3925645384E+00, 5.2416913080E+00, 4.0671832742E-01, 3.5274330464E-01, 5.9047698855E-01],
	[1.1275000000E+04, 5.3956200229E+00, 5.2411077533E+00, 4.0729464772E-01, 3.5318717746E-01, 5.9065293535E-01],
	[1.1280000000E+04, 5.3986758829E+00, 5.2405245222E+00, 4.0787152852E-01, 3.5363134822E-01, 5.9082884874E-01],
	[1.1285000000E+04, 5.4017321182E+00, 5.2399416144E+00, 4.0844897011E-01, 3.5407581685E-01, 5.9100472869E-01],
	[1.1290000000E+04, 5.4047887287E+00, 5.2393590296E+00, 4.0902697281E-01, 3.5452058324E-01, 5.9118057517E-01],
	[1.1295000000E+04, 5.4078535794E+00, 5.2387859210E+00, 4.0960553689E-01, 3.5496572323E-01, 5.9135638814E-01],
	[1.1300000000E+04, 5.4109188543E+00, 5.2382131795E+00, 4.1018466267E-01, 3.5541116156E-01, 5.9153216759E-01],
	[1.1305000000E+04, 5.4139845094E+00, 5.2376407539E+00, 4.1076435042E-01, 3.5585689771E-01, 5.9170791346E-01],
	[1.1310000000E+04, 5.4170505447E+00, 5.2370686440E+00, 4.1134460046E-01, 3.5630293159E-01, 5.9188362574E-01],
	[1.1315000000E+04, 5.4201169600E+00, 5.2364968494E+00, 4.1192541308E-01, 3.5674926313E-01, 5.9205930439E-01],
	[1.1320000000E+04, 5.4231837553E+00, 5.2359253698E+00, 4.1250678857E-01, 3.5719589221E-01, 5.9223494937E-01],
	[1.1325000000E+04, 5.4262509304E+00, 5.2353542049E+00, 4.1308872723E-01, 3.5764281877E-01, 5.9241056066E-01],
	[1.1330000000E+04, 5.4293184851E+00, 5.2347833544E+00, 4.1367122935E-01, 3.5809004270E-01, 5.9258613822E-01],
	[1.1335000000E+04, 5.4323864194E+00, 5.2342128179E+00, 4.1425429524E-01, 3.5853756392E-01, 5.9276168203E-01],
	[1.1340000000E+04, 5.4354547332E+00, 5.2336425952E+00, 4.1483792519E-01, 3.5898538233E-01, 5.9293719204E-01],
	[1.1345000000E+04, 5.4385234263E+00, 5.2330726860E+00, 4.1542211949E-01, 3.5943349784E-01, 5.9311266824E-01],
	[1.1350000000E+04, 5.4415924985E+00, 5.2325030898E+00, 4.1600687845E-01, 3.5988191037E-01, 5.9328811058E-01],
	[1.1355000000E+04, 5.4446619499E+00, 5.2319338065E+00, 4.1659220235E-01, 3.6033061982E-01, 5.9346351904E-01],
	[1.1360000000E+04, 5.4477317802E+00, 5.2313648358E+00, 4.1717809150E-01, 3.6077962609E-01, 5.9363889358E-01],
	[1.1365000000E+04, 5.4508019894E+00, 5.2307961772E+00, 4.1776454619E-01, 3.6122892910E-01, 5.9381423417E-01],
	[1.1370000000E+04, 5.4538725773E+00, 5.2302278305E+00, 4.1835156672E-01, 3.6167852876E-01, 5.9398954079E-01],
	[1.1375000000E+04, 5.4569435437E+00, 5.2296597954E+00, 4.1893915339E-01, 3.6212842496E-01, 5.9416481340E-01],
	[1.1380000000E+04, 5.4600148887E+00, 5.2290920716E+00, 4.1952730648E-01, 3.6257861762E-01, 5.9434005197E-01],
	[1.1385000000E+04, 5.4630866120E+00, 5.2285246588E+00, 4.2011602631E-01, 3.6302910665E-01, 5.9451525647E-01],
	[1.1390000000E+04, 5.4661587136E+00, 5.2279575566E+00, 4.2070531316E-01, 3.6347989194E-01, 5.9469042687E-01],
	[1.1395000000E+04, 5.4692311933E+00, 5.2273907648E+00, 4.2129516733E-01, 3.6393097342E-01, 5.9486556314E-01],
	[1.1400000000E+04, 5.4723040510E+00, 5.2268242831E+00, 4.2188558912E-01, 3.6438235097E-01, 5.9504066524E-01],
	[1.1405000000E+04, 5.4753772865E+00, 5.2262581111E+00, 4.2247657883E-01, 3.6483402451E-01, 5.9521573314E-01],
	[1.1410000000E+04, 5.4784508999E+00, 5.2256922485E+00, 4.2306813675E-01, 3.6528599394E-01, 5.9539076683E-01],
	[1.1415000000E+04, 5.4815248909E+00, 5.2251266951E+00, 4.2366026318E-01, 3.6573825917E-01, 5.9556576626E-01],
	[1.1420000000E+04, 5.4845992594E+00, 5.2245614506E+00, 4.2425295841E-01, 3.6619082010E-01, 5.9574073140E-01],
	[1.1425000000E+04, 5.4876740053E+00, 5.2239965145E+00, 4.2484622275E-01, 3.6664367663E-01, 5.9591566222E-01],
	[1.1430000000E+04, 5.4907491285E+00, 5.2234318867E+00, 4.2544005649E-01, 3.6709682868E-01, 5.9609055870E-01],
	[1.1435000000E+04, 5.4938246289E+00, 5.2228675668E+00, 4.2603445992E-01, 3.6755027613E-01, 5.9626542081E-01],
	[1.1440000000E+04, 5.4969005063E+00, 5.2223035546E+00, 4.2662943335E-01, 3.6800401891E-01, 5.9644024850E-01],
	[1.1445000000E+04, 5.4999767606E+00, 5.2217398497E+00, 4.2722497707E-01, 3.6845805690E-01, 5.9661504176E-01],
	[1.1450000000E+04, 5.5030533918E+00, 5.2211764517E+00, 4.2782109137E-01, 3.6891239001E-01, 5.9678980055E-01],
	[1.1455000000E+04, 5.5061303997E+00, 5.2206133606E+00, 4.2841777657E-01, 3.6936701815E-01, 5.9696452484E-01],
	[1.1460000000E+04, 5.5092077841E+00, 5.2200505758E+00, 4.2901503294E-01, 3.6982194122E-01, 5.9713921461E-01],
	[1.1465000000E+04, 5.5122855450E+00, 5.2194880971E+00, 4.2961286079E-01, 3.7027715911E-01, 5.9731386982E-01],
	[1.1470000000E+04, 5.5153636823E+00, 5.2189259243E+00, 4.3021126042E-01, 3.7073267173E-01, 5.9748849044E-01],
	[1.1475000000E+04, 5.5184475611E+00, 5.2183698300E+00, 4.3081023212E-01, 3.7118853247E-01, 5.9766307645E-01],
	[1.1480000000E+04, 5.5215347911E+00, 5.2178172321E+00, 4.3140977619E-01, 3.7164471764E-01, 5.9783762781E-01],
	[1.1485000000E+04, 5.5246224027E+00, 5.2172649333E+00, 4.3200989293E-01, 3.7210119757E-01, 5.9801214449E-01],
	[1.1490000000E+04, 5.5277103959E+00, 5.2167129333E+00, 4.3261058264E-01, 3.7255797218E-01, 5.9818662647E-01],
	[1.1495000000E+04, 5.5307987704E+00, 5.2161612318E+00, 4.3321184560E-01, 3.7301504137E-01, 5.9836107371E-01],
	[1.1500000000E+04, 5.5338875263E+00, 5.2156098286E+00, 4.3381368213E-01, 3.7347240503E-01, 5.9853548619E-01],
	[1.1505000000E+04, 5.5369766634E+00, 5.2150587233E+00, 4.3441609251E-01, 3.7393006307E-01, 5.9870986387E-01],
	[1.1510000000E+04, 5.5400661816E+00, 5.2145079156E+00, 4.3501907704E-01, 3.7438801538E-01, 5.9888420673E-01],
	[1.1515000000E+04, 5.5431560807E+00, 5.2139574053E+00, 4.3562263603E-01, 3.7484626188E-01, 5.9905851474E-01],
	[1.1520000000E+04, 5.5462463607E+00, 5.2134071921E+00, 4.3622676977E-01, 3.7530480245E-01, 5.9923278787E-01],
	[1.1525000000E+04, 5.5493370213E+00, 5.2128572757E+00, 4.3683147855E-01, 3.7576363699E-01, 5.9940702608E-01],
	[1.1530000000E+04, 5.5524280626E+00, 5.2123076557E+00, 4.3743676267E-01, 3.7622276541E-01, 5.9958122936E-01],
	[1.1535000000E+04, 5.5555194843E+00, 5.2117583320E+00, 4.3804262244E-01, 3.7668218760E-01, 5.9975539767E-01],
	[1.1540000000E+04, 5.5586112864E+00, 5.2112093041E+00, 4.3864905814E-01, 3.7714190347E-01, 5.9992953098E-01],
	[1.1545000000E+04, 5.5617034688E+00, 5.2106605719E+00, 4.3925607008E-01, 3.7760191290E-01, 6.0010362926E-01],
	[1.1550000000E+04, 5.5647960313E+00, 5.2101121351E+00, 4.3986365855E-01, 3.7806221580E-01, 6.0027769249E-01],
	[1.1555000000E+04, 5.5678889738E+00, 5.2095639933E+00, 4.4047182386E-01, 3.7852281207E-01, 6.0045172063E-01],
	[1.1560000000E+04, 5.5709822961E+00, 5.2090161462E+00, 4.4108056629E-01, 3.7898370160E-01, 6.0062571367E-01],
	[1.1565000000E+04, 5.5740759983E+00, 5.2084685937E+00, 4.4168988615E-01, 3.7944488429E-01, 6.0079967156E-01],
	[1.1570000000E+04, 5.5771700801E+00, 5.2079213353E+00, 4.4229978373E-01, 3.7990636003E-01, 6.0097359428E-01],
	[1.1575000000E+04, 5.5802645414E+00, 5.2073743709E+00, 4.4291025933E-01, 3.8036812872E-01, 6.0114748181E-01],
	[1.1580000000E+04, 5.5833593822E+00, 5.2068277000E+00, 4.4352131325E-01, 3.8083019027E-01, 6.0132133410E-01],
	[1.1585000000E+04, 5.5864546023E+00, 5.2062813226E+00, 4.4413294579E-01, 3.8129254455E-01, 6.0149515115E-01],
	[1.1590000000E+04, 5.5895502015E+00, 5.2057352381E+00, 4.4474515724E-01, 3.8175519148E-01, 6.0166893291E-01],
	[1.1595000000E+04, 5.5926461798E+00, 5.2051894465E+00, 4.4535794791E-01, 3.8221813094E-01, 6.0184267936E-01],
	[1.1600000000E+04, 5.5957425371E+00, 5.2046439473E+00, 4.4597131808E-01, 3.8268136283E-01, 6.0201639047E-01],
	[1.1605000000E+04, 5.5988392732E+00, 5.2040987404E+00, 4.4658526806E-01, 3.8314488705E-01, 6.0219006621E-01],
	[1.1610000000E+04, 5.6019363881E+00, 5.2035538254E+00, 4.4719979815E-01, 3.8360870348E-01, 6.0236370656E-01],
	[1.1615000000E+04, 5.6050338815E+00, 5.2030092020E+00, 4.4781490863E-01, 3.8407281203E-01, 6.0253731149E-01],
	[1.1620000000E+04, 5.6081317534E+00, 5.2024648700E+00, 4.4843059982E-01, 3.8453721258E-01, 6.0271088096E-01],
	[1.1625000000E+04, 5.6112300037E+00, 5.2019208291E+00, 4.4904687201E-01, 3.8500190503E-01, 6.0288441496E-01],
	[1.1630000000E+04, 5.6143286322E+00, 5.2013770789E+00, 4.4966372550E-01, 3.8546688928E-01, 6.0305791345E-01],
	[1.1635000000E+04, 5.6174276389E+00, 5.2008336193E+00, 4.5028116058E-01, 3.8593216521E-01, 6.0323137641E-01],
	[1.1640000000E+04, 5.6205270235E+00, 5.2002904500E+00, 4.5089917755E-01, 3.8639773272E-01, 6.0340480380E-01],
	[1.1645000000E+04, 5.6236267861E+00, 5.1997475706E+00, 4.5151777671E-01, 3.8686359171E-01, 6.0357819561E-01],
	[1.1650000000E+04, 5.6267269265E+00, 5.1992049808E+00, 4.5213695837E-01, 3.8732974206E-01, 6.0375155180E-01],
	[1.1655000000E+04, 5.6298274445E+00, 5.1986626805E+00, 4.5275672280E-01, 3.8779618366E-01, 6.0392487235E-01],
	[1.1660000000E+04, 5.6329345447E+00, 5.1981268532E+00, 4.5337707033E-01, 3.8826298039E-01, 6.0409815722E-01],
	[1.1665000000E+04, 5.6360445906E+00, 5.1975938648E+00, 4.5399800123E-01, 3.8873009489E-01, 6.0427140640E-01],
	[1.1670000000E+04, 5.6391550197E+00, 5.1970611594E+00, 4.5461951582E-01, 3.8919750069E-01, 6.0444461985E-01],
	[1.1675000000E+04, 5.6422658320E+00, 5.1965287367E+00, 4.5524161438E-01, 3.8966519766E-01, 6.0461779755E-01],
	[1.1680000000E+04, 5.6453770272E+00, 5.1959965966E+00, 4.5586429722E-01, 3.9013318571E-01, 6.0479093946E-01],
	[1.1685000000E+04, 5.6484886053E+00, 5.1954647386E+00, 4.5648756464E-01, 3.9060146473E-01, 6.0496404558E-01],
	[1.1690000000E+04, 5.6516005662E+00, 5.1949331626E+00, 4.5711141693E-01, 3.9107003460E-01, 6.0513711585E-01],
	[1.1695000000E+04, 5.6547129097E+00, 5.1944018682E+00, 4.5773585439E-01, 3.9153889521E-01, 6.0531015027E-01],
	[1.1700000000E+04, 5.6578256357E+00, 5.1938708552E+00, 4.5836087733E-01, 3.9200804646E-01, 6.0548314880E-01],
	[1.1705000000E+04, 5.6609387442E+00, 5.1933401234E+00, 4.5898648603E-01, 3.9247748824E-01, 6.0565611142E-01],
	[1.1710000000E+04, 5.6640522349E+00, 5.1928096724E+00, 4.5961268079E-01, 3.9294722043E-01, 6.0582903809E-01],
	[1.1715000000E+04, 5.6671661079E+00, 5.1922795020E+00, 4.6023946192E-01, 3.9341724292E-01, 6.0600192880E-01],
	[1.1720000000E+04, 5.6702803628E+00, 5.1917496120E+00, 4.6086682972E-01, 3.9388755561E-01, 6.0617478351E-01],
	[1.1725000000E+04, 5.6733949998E+00, 5.1912200020E+00, 4.6149478447E-01, 3.9435815838E-01, 6.0634760220E-01],
	[1.1730000000E+04, 5.6765100185E+00, 5.1906906717E+00, 4.6212332649E-01, 3.9482905112E-01, 6.0652038485E-01],
	[1.1735000000E+04, 5.6796254190E+00, 5.1901616211E+00, 4.6275245606E-01, 3.9530023371E-01, 6.0669313142E-01],
	[1.1740000000E+04, 5.6827412011E+00, 5.1896328496E+00, 4.6338217349E-01, 3.9577170606E-01, 6.0686584189E-01],
	[1.1745000000E+04, 5.6858573646E+00, 5.1891043572E+00, 4.6401247908E-01, 3.9624346803E-01, 6.0703851624E-01],
	[1.1750000000E+04, 5.6889739095E+00, 5.1885761435E+00, 4.6464337312E-01, 3.9671551953E-01, 6.0721115443E-01],
	[1.1755000000E+04, 5.6920908357E+00, 5.1880482082E+00, 4.6527485591E-01, 3.9718786044E-01, 6.0738375645E-01],
	[1.1760000000E+04, 5.6952081430E+00, 5.1875205511E+00, 4.6590692775E-01, 3.9766049063E-01, 6.0755632226E-01],
	[1.1765000000E+04, 5.6983258313E+00, 5.1869931720E+00, 4.6653958894E-01, 3.9813341002E-01, 6.0772885184E-01],
	[1.1770000000E+04, 5.7014439006E+00, 5.1864660705E+00, 4.6717283978E-01, 3.9860661846E-01, 6.0790134517E-01],
	[1.1775000000E+04, 5.7045623506E+00, 5.1859392464E+00, 4.6780668056E-01, 3.9908011587E-01, 6.0807380221E-01],
	[1.1780000000E+04, 5.7076811813E+00, 5.1854126995E+00, 4.6844111159E-01, 3.9955390211E-01, 6.0824622295E-01],
	[1.1785000000E+04, 5.7108003925E+00, 5.1848864294E+00, 4.6907613316E-01, 4.0002797707E-01, 6.0841860735E-01],
	[1.1790000000E+04, 5.7139199842E+00, 5.1843604359E+00, 4.6971174558E-01, 4.0050234064E-01, 6.0859095539E-01],
	[1.1795000000E+04, 5.7170399562E+00, 5.1838347188E+00, 4.7034794913E-01, 4.0097699271E-01, 6.0876326705E-01],
	[1.1800000000E+04, 5.7201603084E+00, 5.1833092778E+00, 4.7098474413E-01, 4.0145193316E-01, 6.0893554230E-01],
	[1.1805000000E+04, 5.7232810408E+00, 5.1827841126E+00, 4.7162213087E-01, 4.0192716187E-01, 6.0910778111E-01],
	[1.1810000000E+04, 5.7264021531E+00, 5.1822592229E+00, 4.7226010964E-01, 4.0240267872E-01, 6.0927998346E-01],
	[1.1815000000E+04, 5.7295236453E+00, 5.1817346086E+00, 4.7289868074E-01, 4.0287848361E-01, 6.0945214932E-01],
	[1.1820000000E+04, 5.7326455172E+00, 5.1812102693E+00, 4.7353784449E-01, 4.0335457641E-01, 6.0962427867E-01],
	[1.1825000000E+04, 5.7357677688E+00, 5.1806862048E+00, 4.7417760116E-01, 4.0383095701E-01, 6.0979637149E-01],
	[1.1830000000E+04, 5.7388903999E+00, 5.1801624148E+00, 4.7481795107E-01, 4.0430762529E-01, 6.0996842774E-01],
	[1.1835000000E+04, 5.7420134104E+00, 5.1796388990E+00, 4.7545889451E-01, 4.0478458113E-01, 6.1014044740E-01],
	[1.1840000000E+04, 5.7451368002E+00, 5.1791156573E+00, 4.7610043178E-01, 4.0526182442E-01, 6.1031243046E-01],
	[1.1845000000E+04, 5.7482621982E+00, 5.1785941967E+00, 4.7674256318E-01, 4.0573937240E-01, 6.1048437687E-01],
	[1.1850000000E+04, 5.7513955523E+00, 5.1780800151E+00, 4.7738528901E-01, 4.0621728857E-01, 6.1065628662E-01],
	[1.1855000000E+04, 5.7545292915E+00, 5.1775661014E+00, 4.7802860957E-01, 4.0669549221E-01, 6.1082815968E-01],
	[1.1860000000E+04, 5.7576634156E+00, 5.1770524554E+00, 4.7867252515E-01, 4.0717398321E-01, 6.1099999602E-01],
	[1.1865000000E+04, 5.7607979246E+00, 5.1765390769E+00, 4.7931703606E-01, 4.0765276145E-01, 6.1117179554E-01],
	[1.1870000000E+04, 5.7639328184E+00, 5.1760259655E+00, 4.7996214259E-01, 4.0813182680E-01, 6.1134355823E-01],
	[1.1875000000E+04, 5.7670680968E+00, 5.1755131210E+00, 4.8060784505E-01, 4.0861117915E-01, 6.1151528403E-01],
	[1.1880000000E+04, 5.7702037597E+00, 5.1750005432E+00, 4.8125414372E-01, 4.0909081838E-01, 6.1168697292E-01],
	[1.1885000000E+04, 5.7733398069E+00, 5.1744882318E+00, 4.8190103892E-01, 4.0957074437E-01, 6.1185862485E-01],
	[1.1890000000E+04, 5.7764762385E+00, 5.1739761865E+00, 4.8254853094E-01, 4.1005095700E-01, 6.1203023981E-01],
	[1.1895000000E+04, 5.7796130542E+00, 5.1734644072E+00, 4.8319662008E-01, 4.1053145615E-01, 6.1220181774E-01],
	[1.1900000000E+04, 5.7827502540E+00, 5.1729528936E+00, 4.8384530664E-01, 4.1101224171E-01, 6.1237335862E-01],
	[1.1905000000E+04, 5.7858878378E+00, 5.1724416454E+00, 4.8449459092E-01, 4.1149331354E-01, 6.1254486241E-01],
	[1.1910000000E+04, 5.7890258053E+00, 5.1719306623E+00, 4.8514447322E-01, 4.1197467153E-01, 6.1271632908E-01],
	[1.1915000000E+04, 5.7921641566E+00, 5.1714199442E+00, 4.8579495383E-01, 4.1245631556E-01, 6.1288775860E-01],
	[1.1920000000E+04, 5.7953028914E+00, 5.1709094907E+00, 4.8644603306E-01, 4.1293824551E-01, 6.1305915092E-01],
	[1.1925000000E+04, 5.7984420098E+00, 5.1703993017E+00, 4.8709771121E-01, 4.1342046125E-01, 6.1323050602E-01],
	[1.1930000000E+04, 5.8015815115E+00, 5.1698893768E+00, 4.8774998857E-01, 4.1390296267E-01, 6.1340182386E-01],
	[1.1935000000E+04, 5.8047213964E+00, 5.1693797159E+00, 4.8840286544E-01, 4.1438574964E-01, 6.1357310440E-01],
	[1.1940000000E+04, 5.8078616645E+00, 5.1688703187E+00, 4.8905634213E-01, 4.1486882204E-01, 6.1374434762E-01],
	[1.1945000000E+04, 5.8110023157E+00, 5.1683611849E+00, 4.8971041893E-01, 4.1535217975E-01, 6.1391555348E-01],
	[1.1950000000E+04, 5.8141433497E+00, 5.1678523143E+00, 4.9036509614E-01, 4.1583582264E-01, 6.1408672195E-01],
	[1.1955000000E+04, 5.8172847665E+00, 5.1673437066E+00, 4.9102037407E-01, 4.1631975059E-01, 6.1425785298E-01],
	[1.1960000000E+04, 5.8204265661E+00, 5.1668353616E+00, 4.9167625301E-01, 4.1680396347E-01, 6.1442894656E-01],
	[1.1965000000E+04, 5.8235687482E+00, 5.1663272791E+00, 4.9233273326E-01, 4.1728846117E-01, 6.1460000263E-01],
	[1.1970000000E+04, 5.8267113127E+00, 5.1658194588E+00, 4.9298981512E-01, 4.1777324356E-01, 6.1477102118E-01],
	[1.1975000000E+04, 5.8298542596E+00, 5.1653119004E+00, 4.9364749889E-01, 4.1825831052E-01, 6.1494200217E-01],
	[1.1980000000E+04, 5.8329975888E+00, 5.1648046038E+00, 4.9430578487E-01, 4.1874366192E-01, 6.1511294556E-01],
	[1.1985000000E+04, 5.8361413000E+00, 5.1642975686E+00, 4.9496467336E-01, 4.1922929763E-01, 6.1528385133E-01],
	[1.1990000000E+04, 5.8392853933E+00, 5.1637907947E+00, 4.9562416466E-01, 4.1971521753E-01, 6.1545471943E-01],
	[1.1995000000E+04, 5.8424298685E+00, 5.1632842817E+00, 4.9628425906E-01, 4.2020142150E-01, 6.1562554983E-01],
	[1.2000000000E+04, 5.8455747254E+00, 5.1627780295E+00, 4.9694495688E-01, 4.2068790941E-01, 6.1579634251E-01],
	[1.2005000000E+04, 5.8487199640E+00, 5.1622720378E+00, 4.9760625840E-01, 4.2117468114E-01, 6.1596709743E-01],
	[1.2010000000E+04, 5.8518655842E+00, 5.1617663064E+00, 4.9826816393E-01, 4.2166173655E-01, 6.1613781455E-01],
	[1.2015000000E+04, 5.8550115858E+00, 5.1612608350E+00, 4.9893067377E-01, 4.2214907552E-01, 6.1630849385E-01],
	[1.2020000000E+04, 5.8581579687E+00, 5.1607556233E+00, 4.9959378822E-01, 4.2263669793E-01, 6.1647913528E-01],
	[1.2025000000E+04, 5.8613047329E+00, 5.1602506712E+00, 5.0025750757E-01, 4.2312460365E-01, 6.1664973882E-01],
	[1.2030000000E+04, 5.8644518781E+00, 5.1597459784E+00, 5.0092183213E-01, 4.2361279255E-01, 6.1682030444E-01],
	[1.2035000000E+04, 5.8675998112E+00, 5.1592418947E+00, 5.0158676220E-01, 4.2410126899E-01, 6.1699083210E-01],
	[1.2040000000E+04, 5.8707573643E+00, 5.1587460154E+00, 5.0225229808E-01, 4.2459013052E-01, 6.1716132177E-01],
	[1.2045000000E+04, 5.8739153044E+00, 5.1582503895E+00, 5.0291844006E-01, 4.2507927526E-01, 6.1733177342E-01],
	[1.2050000000E+04, 5.8770736316E+00, 5.1577550169E+00, 5.0358518845E-01, 4.2556870307E-01, 6.1750218702E-01],
	[1.2055000000E+04, 5.8802323456E+00, 5.1572598974E+00, 5.0425254354E-01, 4.2605841382E-01, 6.1767256252E-01],
	[1.2060000000E+04, 5.8833914464E+00, 5.1567650307E+00, 5.0492050564E-01, 4.2654840739E-01, 6.1784289991E-01],
	[1.2065000000E+04, 5.8865509339E+00, 5.1562704166E+00, 5.0558907505E-01, 4.2703868366E-01, 6.1801319915E-01],
	[1.2070000000E+04, 5.8897108080E+00, 5.1557760548E+00, 5.0625825206E-01, 4.2752924248E-01, 6.1818346020E-01],
	[1.2075000000E+04, 5.8928710685E+00, 5.1552819451E+00, 5.0692803698E-01, 4.2802008374E-01, 6.1835368304E-01],
	[1.2080000000E+04, 5.8960317154E+00, 5.1547880874E+00, 5.0759843011E-01, 4.2851120730E-01, 6.1852386763E-01],
	[1.2085000000E+04, 5.8991927484E+00, 5.1542944812E+00, 5.0826943174E-01, 4.2900261304E-01, 6.1869401394E-01],
	[1.2090000000E+04, 5.9023541676E+00, 5.1538011265E+00, 5.0894104218E-01, 4.2949430082E-01, 6.1886412194E-01],
	[1.2095000000E+04, 5.9055159728E+00, 5.1533080230E+00, 5.0961326173E-01, 4.2998627051E-01, 6.1903419160E-01],
	[1.2100000000E+04, 5.9086781638E+00, 5.1528151704E+00, 5.1028609069E-01, 4.3047852199E-01, 6.1920422288E-01],
	[1.2105000000E+04, 5.9118407406E+00, 5.1523225686E+00, 5.1095952935E-01, 4.3097105513E-01, 6.1937421576E-01],
	[1.2110000000E+04, 5.9150037031E+00, 5.1518302172E+00, 5.1163357802E-01, 4.3146386979E-01, 6.1954417020E-01],
	[1.2115000000E+04, 5.9181670511E+00, 5.1513381161E+00, 5.1230823699E-01, 4.3195696584E-01, 6.1971408617E-01],
	[1.2120000000E+04, 5.9213307845E+00, 5.1508462650E+00, 5.1298350658E-01, 4.3245034315E-01, 6.1988396365E-01],
	[1.2125000000E+04, 5.9244949033E+00, 5.1503546638E+00, 5.1365938707E-01, 4.3294400159E-01, 6.2005380259E-01],
	[1.2130000000E+04, 5.9276594073E+00, 5.1498633121E+00, 5.1433587877E-01, 4.3343794103E-01, 6.2022360297E-01],
	[1.2135000000E+04, 5.9308242964E+00, 5.1493722097E+00, 5.1501298198E-01, 4.3393216133E-01, 6.2039336475E-01],
	[1.2140000000E+04, 5.9339895704E+00, 5.1488813565E+00, 5.1569069700E-01, 4.3442666237E-01, 6.2056308792E-01],
	[1.2145000000E+04, 5.9371552294E+00, 5.1483907521E+00, 5.1636902413E-01, 4.3492144401E-01, 6.2073277242E-01],
	[1.2150000000E+04, 5.9403212731E+00, 5.1479003964E+00, 5.1704796367E-01, 4.3541650612E-01, 6.2090241824E-01],
	[1.2155000000E+04, 5.9434877014E+00, 5.1474102891E+00, 5.1772751592E-01, 4.3591184857E-01, 6.2107202534E-01],
	[1.2160000000E+04, 5.9466545143E+00, 5.1469204300E+00, 5.1840768118E-01, 4.3640747122E-01, 6.2124159370E-01],
	[1.2165000000E+04, 5.9498217116E+00, 5.1464308189E+00, 5.1908845976E-01, 4.3690337393E-01, 6.2141112327E-01],
	[1.2170000000E+04, 5.9529892932E+00, 5.1459414555E+00, 5.1976985194E-01, 4.3739955658E-01, 6.2158061404E-01],
	[1.2175000000E+04, 5.9561572590E+00, 5.1454523397E+00, 5.2045185804E-01, 4.3789601903E-01, 6.2175006597E-01],
	[1.2180000000E+04, 5.9593256090E+00, 5.1449634711E+00, 5.2113447835E-01, 4.3839276115E-01, 6.2191947902E-01],
	[1.2185000000E+04, 5.9624943429E+00, 5.1444748496E+00, 5.2181771317E-01, 4.3888978280E-01, 6.2208885318E-01],
	[1.2190000000E+04, 5.9656634606E+00, 5.1439864750E+00, 5.2250156281E-01, 4.3938708385E-01, 6.2225818840E-01],
	[1.2195000000E+04, 5.9688329622E+00, 5.1434983469E+00, 5.2318602756E-01, 4.3988466416E-01, 6.2242748467E-01],
	[1.2200000000E+04, 5.9720028474E+00, 5.1430104652E+00, 5.2387110772E-01, 4.4038252359E-01, 6.2259674194E-01],
	[1.2205000000E+04, 5.9751731161E+00, 5.1425228297E+00, 5.2455680361E-01, 4.4088066202E-01, 6.2276596019E-01],
	[1.2210000000E+04, 5.9783437682E+00, 5.1420354401E+00, 5.2524311551E-01, 4.4137907930E-01, 6.2293513939E-01],
	[1.2215000000E+04, 5.9815148037E+00, 5.1415482963E+00, 5.2593004372E-01, 4.4187777530E-01, 6.2310427950E-01],
	[1.2220000000E+04, 5.9846862224E+00, 5.1410613979E+00, 5.2661758856E-01, 4.4237674988E-01, 6.2327338051E-01],
	[1.2225000000E+04, 5.9878580241E+00, 5.1405747448E+00, 5.2730575031E-01, 4.4287600291E-01, 6.2344244237E-01],
	[1.2230000000E+04, 5.9910331694E+00, 5.1400907093E+00, 5.2799452928E-01, 4.4337556811E-01, 6.2361146506E-01],
	[1.2235000000E+04, 5.9942158297E+00, 5.1396126281E+00, 5.2868392577E-01, 4.4387549330E-01, 6.2378044855E-01],
	[1.2240000000E+04, 5.9973988795E+00, 5.1391347867E+00, 5.2937394009E-01, 4.4437569696E-01, 6.2394939281E-01],
	[1.2245000000E+04, 6.0005823184E+00, 5.1386571849E+00, 5.3006457252E-01, 4.4487617894E-01, 6.2411829781E-01],
	[1.2250000000E+04, 6.0037661465E+00, 5.1381798224E+00, 5.3075582338E-01, 4.4537693910E-01, 6.2428716352E-01],
	[1.2255000000E+04, 6.0069503636E+00, 5.1377026990E+00, 5.3144769297E-01, 4.4587797731E-01, 6.2445598990E-01],
	[1.2260000000E+04, 6.0101349696E+00, 5.1372258146E+00, 5.3214018157E-01, 4.4637929344E-01, 6.2462477695E-01],
	[1.2265000000E+04, 6.0133199643E+00, 5.1367491688E+00, 5.3283328951E-01, 4.4688088734E-01, 6.2479352461E-01],
	[1.2270000000E+04, 6.0165053477E+00, 5.1362727615E+00, 5.3352701707E-01, 4.4738275887E-01, 6.2496223286E-01],
	[1.2275000000E+04, 6.0196911197E+00, 5.1357965924E+00, 5.3422136455E-01, 4.4788490790E-01, 6.2513090168E-01],
	[1.2280000000E+04, 6.0228772802E+00, 5.1353206614E+00, 5.3491633227E-01, 4.4838733428E-01, 6.2529953103E-01],
	[1.2285000000E+04, 6.0260638289E+00, 5.1348449682E+00, 5.3561192051E-01, 4.4889003789E-01, 6.2546812089E-01],
	[1.2290000000E+04, 6.0292507660E+00, 5.1343695126E+00, 5.3630812959E-01, 4.4939301858E-01, 6.2563667123E-01],
	[1.2295000000E+04, 6.0324380911E+00, 5.1338942944E+00, 5.3700495980E-01, 4.4989627620E-01, 6.2580518201E-01],
	[1.2300000000E+04, 6.0356258042E+00, 5.1334193133E+00, 5.3770241144E-01, 4.5039981063E-01, 6.2597365321E-01],
	[1.2305000000E+04, 6.0388139053E+00, 5.1329445693E+00, 5.3840048481E-01, 4.5090362171E-01, 6.2614208480E-01],
	[1.2310000000E+04, 6.0420023941E+00, 5.1324700619E+00, 5.3909918022E-01, 4.5140770932E-01, 6.2631047675E-01],
	[1.2315000000E+04, 6.0451912706E+00, 5.1319957911E+00, 5.3979849797E-01, 4.5191207330E-01, 6.2647882904E-01],
	[1.2320000000E+04, 6.0483805346E+00, 5.1315217567E+00, 5.4049843835E-01, 4.5241671352E-01, 6.2664714163E-01],
	[1.2325000000E+04, 6.0515701861E+00, 5.1310479583E+00, 5.4119900167E-01, 4.5292162984E-01, 6.2681541449E-01],
	[1.2330000000E+04, 6.0547602250E+00, 5.1305743958E+00, 5.4190018823E-01, 4.5342682212E-01, 6.2698364760E-01],
	[1.2335000000E+04, 6.0579506511E+00, 5.1301010690E+00, 5.4260199833E-01, 4.5393229021E-01, 6.2715184093E-01],
	[1.2340000000E+04, 6.0611414643E+00, 5.1296279777E+00, 5.4330443228E-01, 4.5443803398E-01, 6.2731999445E-01],
	[1.2345000000E+04, 6.0643326646E+00, 5.1291551216E+00, 5.4400749037E-01, 4.5494405327E-01, 6.2748810813E-01],
	[1.2350000000E+04, 6.0675242517E+00, 5.1286825005E+00, 5.4471117290E-01, 4.5545034796E-01, 6.2765618195E-01],
	[1.2355000000E+04, 6.0707162256E+00, 5.1282101143E+00, 5.4541548018E-01, 4.5595691789E-01, 6.2782421587E-01],
	[1.2360000000E+04, 6.0739085863E+00, 5.1277379627E+00, 5.4612041251E-01, 4.5646376292E-01, 6.2799220987E-01],
	[1.2365000000E+04, 6.0771013335E+00, 5.1272660455E+00, 5.4682597019E-01, 4.5697088291E-01, 6.2816016392E-01],
	[1.2370000000E+04, 6.0802944671E+00, 5.1267943625E+00, 5.4753215352E-01, 4.5747827772E-01, 6.2832807799E-01],
	[1.2375000000E+04, 6.0834879872E+00, 5.1263229135E+00, 5.4823896280E-01, 4.5798594720E-01, 6.2849595206E-01],
	[1.2380000000E+04, 6.0866818934E+00, 5.1258516982E+00, 5.4894639833E-01, 4.5849389121E-01, 6.2866378609E-01],
	[1.2385000000E+04, 6.0898761859E+00, 5.1253807166E+00, 5.4965446042E-01, 4.5900210961E-01, 6.2883158006E-01],
	[1.2390000000E+04, 6.0930708643E+00, 5.1249099682E+00, 5.5036314936E-01, 4.5951060224E-01, 6.2899933394E-01],
	[1.2395000000E+04, 6.0962659287E+00, 5.1244394531E+00, 5.5107246547E-01, 4.6001936897E-01, 6.2916704771E-01],
	[1.2400000000E+04, 6.0994613788E+00, 5.1239691708E+00, 5.5178240903E-01, 4.6052840966E-01, 6.2933472133E-01],
	[1.2405000000E+04, 6.1026572147E+00, 5.1234991213E+00, 5.5249298035E-01, 4.6103772415E-01, 6.2950235478E-01],
	[1.2410000000E+04, 6.1058534362E+00, 5.1230293043E+00, 5.5320417974E-01, 4.6154731230E-01, 6.2966994803E-01],
	[1.2415000000E+04, 6.1090500432E+00, 5.1225597196E+00, 5.5391600749E-01, 4.6205717396E-01, 6.2983750106E-01],
	[1.2420000000E+04, 6.1122470355E+00, 5.1220903670E+00, 5.5462846391E-01, 4.6256730900E-01, 6.3000501383E-01],
	[1.2425000000E+04, 6.1154444131E+00, 5.1216212462E+00, 5.5534154929E-01, 4.6307771725E-01, 6.3017248633E-01],
	[1.2430000000E+04, 6.1186518848E+00, 5.1211596137E+00, 5.5605526395E-01, 4.6358851379E-01, 6.3033991851E-01],
	[1.2435000000E+04, 6.1218605820E+00, 5.1206988316E+00, 5.5676960818E-01, 4.6409959357E-01, 6.3050731036E-01],
	[1.2440000000E+04, 6.1250696710E+00, 5.1202382761E+00, 5.5748458228E-01, 4.6461094660E-01, 6.3067466185E-01],
	[1.2445000000E+04, 6.1282791516E+00, 5.1197779470E+00, 5.5820018655E-01, 4.6512257271E-01, 6.3084197295E-01],
	[1.2450000000E+04, 6.1314890237E+00, 5.1193178443E+00, 5.5891642130E-01, 4.6563447176E-01, 6.3100924364E-01],
	[1.2455000000E+04, 6.1346992872E+00, 5.1188579676E+00, 5.5963328683E-01, 4.6614664361E-01, 6.3117647388E-01],
	[1.2460000000E+04, 6.1379099420E+00, 5.1183983167E+00, 5.6035078344E-01, 4.6665908810E-01, 6.3134366366E-01],
	[1.2465000000E+04, 6.1411209880E+00, 5.1179388916E+00, 5.6106891143E-01, 4.6717180509E-01, 6.3151081294E-01],
	[1.2470000000E+04, 6.1443324251E+00, 5.1174796919E+00, 5.6178767111E-01, 4.6768479443E-01, 6.3167792170E-01],
	[1.2475000000E+04, 6.1475442531E+00, 5.1170207174E+00, 5.6250706277E-01, 4.6819805598E-01, 6.3184498991E-01],
	[1.2480000000E+04, 6.1507564720E+00, 5.1165619680E+00, 5.6322708672E-01, 4.6871158959E-01, 6.3201201754E-01],
	[1.2485000000E+04, 6.1539690817E+00, 5.1161034435E+00, 5.6394774326E-01, 4.6922539510E-01, 6.3217900458E-01],
	[1.2490000000E+04, 6.1571820820E+00, 5.1156451436E+00, 5.6466903269E-01, 4.6973947237E-01, 6.3234595099E-01],
	[1.2495000000E+04, 6.1603954728E+00, 5.1151870682E+00, 5.6539095531E-01, 4.7025382125E-01, 6.3251285674E-01],
	[1.2500000000E+04, 6.1636092541E+00, 5.1147292171E+00, 5.6611351143E-01, 4.7076844160E-01, 6.3267972181E-01],
	[1.2505000000E+04, 6.1668234257E+00, 5.1142715900E+00, 5.6683909044E-01, 4.7128498476E-01, 6.3284654618E-01],
	[1.2510000000E+04, 6.1700379875E+00, 5.1138141868E+00, 5.6756530862E-01, 4.7180180138E-01, 6.3301332982E-01],
	[1.2515000000E+04, 6.1732529394E+00, 5.1133570072E+00, 5.6829216630E-01, 4.7231889130E-01, 6.3318007270E-01],
	[1.2520000000E+04, 6.1764682813E+00, 5.1129000511E+00, 5.6901966377E-01, 4.7283625439E-01, 6.3334677479E-01],
	[1.2525000000E+04, 6.1796840131E+00, 5.1124433183E+00, 5.6974780134E-01, 4.7335389048E-01, 6.3351343608E-01],
	[1.2530000000E+04, 6.1829001346E+00, 5.1119868085E+00, 5.7047657932E-01, 4.7387179943E-01, 6.3368005652E-01],
	[1.2535000000E+04, 6.1861166458E+00, 5.1115305217E+00, 5.7120599802E-01, 4.7438998108E-01, 6.3384663611E-01],
	[1.2540000000E+04, 6.1893335466E+00, 5.1110744574E+00, 5.7193605775E-01, 4.7490843528E-01, 6.3401317481E-01],
	[1.2545000000E+04, 6.1925508368E+00, 5.1106186157E+00, 5.7266675880E-01, 4.7542716188E-01, 6.3417967260E-01],
	[1.2550000000E+04, 6.1957685164E+00, 5.1101629962E+00, 5.7339810149E-01, 4.7594616072E-01, 6.3434612946E-01],
	[1.2555000000E+04, 6.1989865852E+00, 5.1097075988E+00, 5.7413008613E-01, 4.7646543166E-01, 6.3451254534E-01],
	[1.2560000000E+04, 6.2022050431E+00, 5.1092524233E+00, 5.7486271302E-01, 4.7698497454E-01, 6.3467892024E-01],
	[1.2565000000E+04, 6.2054238901E+00, 5.1087974695E+00, 5.7559598248E-01, 4.7750478921E-01, 6.3484525413E-01],
	[1.2570000000E+04, 6.2086431259E+00, 5.1083427372E+00, 5.7632989480E-01, 4.7802487552E-01, 6.3501154697E-01],
	[1.2575000000E+04, 6.2118627506E+00, 5.1078882261E+00, 5.7706445029E-01, 4.7854523330E-01, 6.3517779876E-01],
	[1.2580000000E+04, 6.2150827640E+00, 5.1074339362E+00, 5.7779964927E-01, 4.7906586241E-01, 6.3534400945E-01],
	[1.2585000000E+04, 6.2183031659E+00, 5.1069798672E+00, 5.7853549203E-01, 4.7958676270E-01, 6.3551017903E-01],
	[1.2590000000E+04, 6.2215239563E+00, 5.1065260189E+00, 5.7927197890E-01, 4.8010793400E-01, 6.3567630746E-01],
	[1.2595000000E+04, 6.2247451351E+00, 5.1060723911E+00, 5.8000911017E-01, 4.8062937617E-01, 6.3584239474E-01],
	[1.2600000000E+04, 6.2279667022E+00, 5.1056189836E+00, 5.8074688615E-01, 4.8115108904E-01, 6.3600844082E-01],
	[1.2605000000E+04, 6.2311886574E+00, 5.1051657962E+00, 5.8148530715E-01, 4.8167307247E-01, 6.3617444569E-01],
	[1.2610000000E+04, 6.2344110007E+00, 5.1047128288E+00, 5.8222437348E-01, 4.8219532630E-01, 6.3634040932E-01],
	[1.2615000000E+04, 6.2376337319E+00, 5.1042600811E+00, 5.8296408544E-01, 4.8271785037E-01, 6.3650633169E-01],
	[1.2620000000E+04, 6.2408568509E+00, 5.1038075530E+00, 5.8370444334E-01, 4.8324064453E-01, 6.3667221276E-01],
	[1.2625000000E+04, 6.2440803577E+00, 5.1033552442E+00, 5.8444544750E-01, 4.8376370861E-01, 6.3683805253E-01],
	[1.2630000000E+04, 6.2473143420E+00, 5.1029102128E+00, 5.8518709821E-01, 4.8428716668E-01, 6.3700385096E-01],
	[1.2635000000E+04, 6.2505496636E+00, 5.1024660559E+00, 5.8592939578E-01, 4.8481090643E-01, 6.3716960802E-01],
	[1.2640000000E+04, 6.2537853797E+00, 5.1020221135E+00, 5.8667234053E-01, 4.8533491613E-01, 6.3733532370E-01],
	[1.2645000000E+04, 6.2570214902E+00, 5.1015783852E+00, 5.8741593276E-01, 4.8585919560E-01, 6.3750099797E-01],
	[1.2650000000E+04, 6.2602579949E+00, 5.1011348709E+00, 5.8816017278E-01, 4.8638374470E-01, 6.3766663081E-01],
	[1.2655000000E+04, 6.2634948937E+00, 5.1006915703E+00, 5.8890506089E-01, 4.8690856327E-01, 6.3783222218E-01],
	[1.2660000000E+04, 6.2667321865E+00, 5.1002484835E+00, 5.8965059741E-01, 4.8743365115E-01, 6.3799777207E-01],
	[1.2665000000E+04, 6.2699698732E+00, 5.0998056100E+00, 5.9039678264E-01, 4.8795900819E-01, 6.3816328046E-01],
	[1.2670000000E+04, 6.2732079538E+00, 5.0993629498E+00, 5.9114361688E-01, 4.8848463423E-01, 6.3832874731E-01],
	[1.2675000000E+04, 6.2764464280E+00, 5.0989205026E+00, 5.9189110046E-01, 4.8901052910E-01, 6.3849417261E-01],
	[1.2680000000E+04, 6.2796852958E+00, 5.0984782683E+00, 5.9263923367E-01, 4.8953669266E-01, 6.3865955632E-01],
	[1.2685000000E+04, 6.2829245571E+00, 5.0980362467E+00, 5.9338801682E-01, 4.9006312474E-01, 6.3882489838E-01],
	[1.2690000000E+04, 6.2861642117E+00, 5.0975944375E+00, 5.9413745022E-01, 4.9058982519E-01, 6.3899019878E-01],
	[1.2695000000E+04, 6.2894042596E+00, 5.0971528407E+00, 5.9488753419E-01, 4.9111679385E-01, 6.3915545748E-01],
	[1.2700000000E+04, 6.2926447007E+00, 5.0967114560E+00, 5.9563826901E-01, 4.9164403055E-01, 6.3932067444E-01],
	[1.2705000000E+04, 6.2958855348E+00, 5.0962702833E+00, 5.9638965502E-01, 4.9217153514E-01, 6.3948584965E-01],
	[1.2710000000E+04, 6.2991267619E+00, 5.0958293223E+00, 5.9714169250E-01, 4.9269930746E-01, 6.3965098306E-01],
	[1.2715000000E+04, 6.3023683818E+00, 5.0953885728E+00, 5.9789438178E-01, 4.9322734735E-01, 6.3981607466E-01],
	[1.2720000000E+04, 6.3056103944E+00, 5.0949480348E+00, 5.9864772315E-01, 4.9375565465E-01, 6.3998112441E-01],
	[1.2725000000E+04, 6.3088527997E+00, 5.0945077079E+00, 5.9940171693E-01, 4.9428422920E-01, 6.4014613228E-01],
	[1.2730000000E+04, 6.3120955974E+00, 5.0940675921E+00, 6.0015636343E-01, 4.9481307084E-01, 6.4031109824E-01],
	[1.2735000000E+04, 6.3153387876E+00, 5.0936276871E+00, 6.0091166295E-01, 4.9534217941E-01, 6.4047602226E-01],
	[1.2740000000E+04, 6.3185823701E+00, 5.0931879927E+00, 6.0166761580E-01, 4.9587155474E-01, 6.4064090432E-01],
	[1.2745000000E+04, 6.3218263447E+00, 5.0927485088E+00, 6.0242422229E-01, 4.9640119668E-01, 6.4080574438E-01],
	[1.2750000000E+04, 6.3250707115E+00, 5.0923092352E+00, 6.0318148272E-01, 4.9693110507E-01, 6.4097054241E-01],
	[1.2755000000E+04, 6.3283154702E+00, 5.0918701717E+00, 6.0393939742E-01, 4.9746127974E-01, 6.4113529839E-01],
	[1.2760000000E+04, 6.3315606208E+00, 5.0914313181E+00, 6.0469796667E-01, 4.9799172053E-01, 6.4130001228E-01],
	[1.2765000000E+04, 6.3348061632E+00, 5.0909926742E+00, 6.0545719080E-01, 4.9852242728E-01, 6.4146468406E-01],
	[1.2770000000E+04, 6.3380520972E+00, 5.0905542399E+00, 6.0621707011E-01, 4.9905339983E-01, 6.4162931370E-01],
	[1.2775000000E+04, 6.3412984228E+00, 5.0901160149E+00, 6.0697760491E-01, 4.9958463801E-01, 6.4179390116E-01],
	[1.2780000000E+04, 6.3445451399E+00, 5.0896779992E+00, 6.0773879550E-01, 5.0011614166E-01, 6.4195844643E-01],
	[1.2785000000E+04, 6.3477922482E+00, 5.0892401924E+00, 6.0850064220E-01, 5.0064791063E-01, 6.4212294947E-01],
	[1.2790000000E+04, 6.3510397479E+00, 5.0888025945E+00, 6.0926314532E-01, 5.0117994474E-01, 6.4228741024E-01],
	[1.2795000000E+04, 6.3542876386E+00, 5.0883652052E+00, 6.1002630515E-01, 5.0171224383E-01, 6.4245182874E-01],
	[1.2800000000E+04, 6.3575359204E+00, 5.0879280243E+00, 6.1079012202E-01, 5.0224480773E-01, 6.4261620492E-01],
	[1.2805000000E+04, 6.3607845931E+00, 5.0874910518E+00, 6.1155459623E-01, 5.0277763630E-01, 6.4278053875E-01],
	[1.2810000000E+04, 6.3640336566E+00, 5.0870542873E+00, 6.1231972808E-01, 5.0331072935E-01, 6.4294483021E-01],
	[1.2815000000E+04, 6.3672831109E+00, 5.0866177308E+00, 6.1308551789E-01, 5.0384408673E-01, 6.4310907928E-01],
	[1.2820000000E+04, 6.3705329557E+00, 5.0861813820E+00, 6.1385196597E-01, 5.0437770827E-01, 6.4327328591E-01],
	[1.2825000000E+04, 6.3737831911E+00, 5.0857452407E+00, 6.1461907262E-01, 5.0491159381E-01, 6.4343745009E-01],
	[1.2830000000E+04, 6.3770368668E+00, 5.0853113105E+00, 6.1538683815E-01, 5.0544578213E-01, 6.4360157178E-01],
	[1.2835000000E+04, 6.3802994375E+00, 5.0848831686E+00, 6.1615526287E-01, 5.0598034299E-01, 6.4376565096E-01],
	[1.2840000000E+04, 6.3835624056E+00, 5.0844552295E+00, 6.1692434709E-01, 5.0651516787E-01, 6.4392968760E-01],
	[1.2845000000E+04, 6.3868257711E+00, 5.0840274930E+00, 6.1769409112E-01, 5.0705025658E-01, 6.4409368167E-01],
	[1.2850000000E+04, 6.3900895339E+00, 5.0835999589E+00, 6.1846449526E-01, 5.0758560897E-01, 6.4425763314E-01],
	[1.2855000000E+04, 6.3933536938E+00, 5.0831726271E+00, 6.1923555983E-01, 5.0812122487E-01, 6.4442154199E-01],
	[1.2860000000E+04, 6.3966182508E+00, 5.0827454973E+00, 6.2000728513E-01, 5.0865710411E-01, 6.4458540818E-01],
	[1.2865000000E+04, 6.3998832047E+00, 5.0823185695E+00, 6.2077967148E-01, 5.0919324653E-01, 6.4474923170E-01],
	[1.2870000000E+04, 6.4031485554E+00, 5.0818918434E+00, 6.2155271918E-01, 5.0972965196E-01, 6.4491301251E-01],
	[1.2875000000E+04, 6.4064143029E+00, 5.0814653188E+00, 6.2232642854E-01, 5.1026632024E-01, 6.4507675058E-01],
	[1.2880000000E+04, 6.4096804470E+00, 5.0810389957E+00, 6.2310079986E-01, 5.1080325120E-01, 6.4524044589E-01],
	[1.2885000000E+04, 6.4129469877E+00, 5.0806128737E+00, 6.2387583347E-01, 5.1134044467E-01, 6.4540409841E-01],
	[1.2890000000E+04, 6.4162139247E+00, 5.0801869528E+00, 6.2465152966E-01, 5.1187790048E-01, 6.4556770811E-01],
	[1.2895000000E+04, 6.4194812581E+00, 5.0797612328E+00, 6.2542788875E-01, 5.1241561847E-01, 6.4573127497E-01],
	[1.2900000000E+04, 6.4227489877E+00, 5.0793357134E+00, 6.2620491104E-01, 5.1295359847E-01, 6.4589479896E-01],
	[1.2905000000E+04, 6.4260171134E+00, 5.0789103946E+00, 6.2698259684E-01, 5.1349184032E-01, 6.4605828005E-01],
	[1.2910000000E+04, 6.4292856350E+00, 5.0784852761E+00, 6.2776094647E-01, 5.1403034383E-01, 6.4622171821E-01],
	[1.2915000000E+04, 6.4325545526E+00, 5.0780603578E+00, 6.2853996023E-01, 5.1456910886E-01, 6.4638511342E-01],
	[1.2920000000E+04, 6.4358238659E+00, 5.0776356395E+00, 6.2931963843E-01, 5.1510813522E-01, 6.4654846565E-01],
	[1.2925000000E+04, 6.4390935749E+00, 5.0772111211E+00, 6.3009998138E-01, 5.1564742274E-01, 6.4671177488E-01],
	[1.2930000000E+04, 6.4423636795E+00, 5.0767868023E+00, 6.3088098939E-01, 5.1618697127E-01, 6.4687504107E-01],
	[1.2935000000E+04, 6.4456341796E+00, 5.0763626830E+00, 6.3166266277E-01, 5.1672678063E-01, 6.4703826420E-01],
	[1.2940000000E+04, 6.4489050750E+00, 5.0759387630E+00, 6.3244500182E-01, 5.1726685065E-01, 6.4720144425E-01],
	[1.2945000000E+04, 6.4521763657E+00, 5.0755150422E+00, 6.3322800686E-01, 5.1780718116E-01, 6.4736458118E-01],
	[1.2950000000E+04, 6.4554480515E+00, 5.0750915203E+00, 6.3401167819E-01, 5.1834777199E-01, 6.4752767497E-01],
	[1.2955000000E+04, 6.4587201324E+00, 5.0746681973E+00, 6.3479601613E-01, 5.1888862298E-01, 6.4769072560E-01],
	[1.2960000000E+04, 6.4619926082E+00, 5.0742450729E+00, 6.3558102098E-01, 5.1942973394E-01, 6.4785373303E-01],
	[1.2965000000E+04, 6.4652654789E+00, 5.0738221470E+00, 6.3636669305E-01, 5.1997110471E-01, 6.4801669725E-01],
	[1.2970000000E+04, 6.4685387443E+00, 5.0733994194E+00, 6.3715303266E-01, 5.2051273513E-01, 6.4817961822E-01],
	[1.2975000000E+04, 6.4718124043E+00, 5.0729768899E+00, 6.3794004011E-01, 5.2105462501E-01, 6.4834249592E-01],
	[1.2980000000E+04, 6.4750864589E+00, 5.0725545583E+00, 6.3872771571E-01, 5.2159677419E-01, 6.4850533032E-01],
	[1.2985000000E+04, 6.4783609078E+00, 5.0721324246E+00, 6.3951605976E-01, 5.2213918249E-01, 6.4866812140E-01],
	[1.2990000000E+04, 6.4816357511E+00, 5.0717104885E+00, 6.4030507259E-01, 5.2268184975E-01, 6.4883086914E-01],
	[1.2995000000E+04, 6.4849109886E+00, 5.0712887498E+00, 6.4109475450E-01, 5.2322477579E-01, 6.4899357349E-01],
	[1.3000000000E+04, 6.4881866202E+00, 5.0708672085E+00, 6.4188510579E-01, 5.2376796044E-01, 6.4915623445E-01],
	[1.3005000000E+04, 6.4914626458E+00, 5.0704458642E+00, 6.4267612678E-01, 5.2431140352E-01, 6.4931885198E-01],
	[1.3010000000E+04, 6.4947390653E+00, 5.0700247169E+00, 6.4346781778E-01, 5.2485510487E-01, 6.4948142606E-01],
	[1.3015000000E+04, 6.4980158786E+00, 5.0696037664E+00, 6.4426017909E-01, 5.2539906431E-01, 6.4964395666E-01],
	[1.3020000000E+04, 6.5012930856E+00, 5.0691830125E+00, 6.4505321103E-01, 5.2594328168E-01, 6.4980644376E-01],
	[1.3025000000E+04, 6.5045706862E+00, 5.0687624550E+00, 6.4584691391E-01, 5.2648775678E-01, 6.4996888733E-01],
	[1.3030000000E+04, 6.5078486803E+00, 5.0683420939E+00, 6.4664128803E-01, 5.2703248946E-01, 6.5013128735E-01],
	[1.3035000000E+04, 6.5111270677E+00, 5.0679219288E+00, 6.4743633370E-01, 5.2757747954E-01, 6.5029364378E-01],
	[1.3040000000E+04, 6.5144174341E+00, 5.0675091129E+00, 6.4823205124E-01, 5.2812288067E-01, 6.5045595662E-01],
	[1.3045000000E+04, 6.5177086936E+00, 5.0670967928E+00, 6.4902844095E-01, 5.2866854592E-01, 6.5061822582E-01],
	[1.3050000000E+04, 6.5210003537E+00, 5.0666846642E+00, 6.4982550315E-01, 5.2921446858E-01, 6.5078045137E-01],
	[1.3055000000E+04, 6.5242924143E+00, 5.0662727270E+00, 6.5062323814E-01, 5.2976064848E-01, 6.5094263324E-01],
	[1.3060000000E+04, 6.5275848754E+00, 5.0658609811E+00, 6.5142164623E-01, 5.3030708544E-01, 6.5110477140E-01],
	[1.3065000000E+04, 6.5308777367E+00, 5.0654494262E+00, 6.5222072773E-01, 5.3085377929E-01, 6.5126686584E-01],
	[1.3070000000E+04, 6.5341709983E+00, 5.0650380621E+00, 6.5302048296E-01, 5.3140072986E-01, 6.5142891652E-01],
	[1.3075000000E+04, 6.5374646599E+00, 5.0646268888E+00, 6.5382091222E-01, 5.3194793696E-01, 6.5159092342E-01],
	[1.3080000000E+04, 6.5407587215E+00, 5.0642159061E+00, 6.5462201581E-01, 5.3249540043E-01, 6.5175288652E-01],
	[1.3085000000E+04, 6.5440531830E+00, 5.0638051138E+00, 6.5542379406E-01, 5.3304312008E-01, 6.5191480579E-01],
	[1.3090000000E+04, 6.5473480443E+00, 5.0633945117E+00, 6.5622624728E-01, 5.3359109575E-01, 6.5207668121E-01],
	[1.3095000000E+04, 6.5506433053E+00, 5.0629840997E+00, 6.5702937576E-01, 5.3413932726E-01, 6.5223851275E-01],
	[1.3100000000E+04, 6.5539389658E+00, 5.0625738776E+00, 6.5783317982E-01, 5.3468781444E-01, 6.5240030038E-01],
	[1.3105000000E+04, 6.5572350258E+00, 5.0621638453E+00, 6.5863765978E-01, 5.3523655710E-01, 6.5256204410E-01],
	[1.3110000000E+04, 6.5605314852E+00, 5.0617540026E+00, 6.5944281593E-01, 5.3578555507E-01, 6.5272374386E-01],
	[1.3115000000E+04, 6.5638283438E+00, 5.0613443493E+00, 6.6024864860E-01, 5.3633480817E-01, 6.5288539964E-01],
	[1.3120000000E+04, 6.5671256016E+00, 5.0609348853E+00, 6.6105515808E-01, 5.3688431623E-01, 6.5304701143E-01],
	[1.3125000000E+04, 6.5704232584E+00, 5.0605256105E+00, 6.6186234470E-01, 5.3743407907E-01, 6.5320857919E-01],
	[1.3130000000E+04, 6.5737213142E+00, 5.0601165246E+00, 6.6267020876E-01, 5.3798409652E-01, 6.5337010291E-01],
	[1.3135000000E+04, 6.5770197688E+00, 5.0597076275E+00, 6.6347875056E-01, 5.3853436839E-01, 6.5353158255E-01],
	[1.3140000000E+04, 6.5803186222E+00, 5.0592989190E+00, 6.6428797043E-01, 5.3908489451E-01, 6.5369301810E-01],
	[1.3145000000E+04, 6.5836178742E+00, 5.0588903990E+00, 6.6509786867E-01, 5.3963567470E-01, 6.5385440953E-01],
	[1.3150000000E+04, 6.5869175248E+00, 5.0584820674E+00, 6.6590844559E-01, 5.4018670878E-01, 6.5401575682E-01],
	[1.3155000000E+04, 6.5902175737E+00, 5.0580739239E+00, 6.6671970151E-01, 5.4073799658E-01, 6.5417705994E-01],
	[1.3160000000E+04, 6.5935180210E+00, 5.0576659685E+00, 6.6753163672E-01, 5.4128953791E-01, 6.5433831888E-01],
	[1.3165000000E+04, 6.5968188666E+00, 5.0572582009E+00, 6.6834425154E-01, 5.4184133260E-01, 6.5449953360E-01],
	[1.3170000000E+04, 6.6001201102E+00, 5.0568506210E+00, 6.6915754629E-01, 5.4239338047E-01, 6.5466070408E-01],
	[1.3175000000E+04, 6.6034217519E+00, 5.0564432286E+00, 6.6997152127E-01, 5.4294568133E-01, 6.5482183030E-01],
	[1.3180000000E+04, 6.6067237914E+00, 5.0560360236E+00, 6.7078617679E-01, 5.4349823502E-01, 6.5498291224E-01],
	[1.3185000000E+04, 6.6100262288E+00, 5.0556290058E+00, 6.7160151316E-01, 5.4405104135E-01, 6.5514394987E-01],
	[1.3190000000E+04, 6.6133290639E+00, 5.0552221751E+00, 6.7241753069E-01, 5.4460410014E-01, 6.5530494317E-01],
	[1.3195000000E+04, 6.6166322966E+00, 5.0548155313E+00, 6.7323422970E-01, 5.4515741121E-01, 6.5546589211E-01],
	[1.3200000000E+04, 6.6199359268E+00, 5.0544090743E+00, 6.7405161049E-01, 5.4571097438E-01, 6.5562679668E-01],
	[1.3205000000E+04, 6.6232399544E+00, 5.0540028039E+00, 6.7486967338E-01, 5.4626478947E-01, 6.5578765685E-01],
	[1.3210000000E+04, 6.6265443794E+00, 5.0535967199E+00, 6.7568841866E-01, 5.4681885630E-01, 6.5594847260E-01],
	[1.3215000000E+04, 6.6298492015E+00, 5.0531908221E+00, 6.7650784667E-01, 5.4737317468E-01, 6.5610924390E-01],
	[1.3220000000E+04, 6.6331544206E+00, 5.0527851105E+00, 6.7732795769E-01, 5.4792774445E-01, 6.5626997073E-01],
	[1.3225000000E+04, 6.6364600368E+00, 5.0523795849E+00, 6.7814875206E-01, 5.4848256541E-01, 6.5643065307E-01],
	[1.3230000000E+04, 6.6397660499E+00, 5.0519742451E+00, 6.7897023007E-01, 5.4903763739E-01, 6.5659129090E-01],
	[1.3235000000E+04, 6.6430724598E+00, 5.0515690910E+00, 6.7979239203E-01, 5.4959296020E-01, 6.5675188419E-01],
	[1.3240000000E+04, 6.6463792663E+00, 5.0511641224E+00, 6.8061523826E-01, 5.5014853366E-01, 6.5691243293E-01],
	[1.3245000000E+04, 6.6496864694E+00, 5.0507593391E+00, 6.8143876907E-01, 5.5070435759E-01, 6.5707293708E-01],
	[1.3250000000E+04, 6.6530065454E+00, 5.0503619944E+00, 6.8226298477E-01, 5.5126060389E-01, 6.5723339662E-01],
	[1.3255000000E+04, 6.6563271591E+00, 5.0499649085E+00, 6.8308788567E-01, 5.5181710269E-01, 6.5739381154E-01],
	[1.3260000000E+04, 6.6596481769E+00, 5.0495680035E+00, 6.8391347207E-01, 5.5237385198E-01, 6.5755418181E-01],
	[1.3265000000E+04, 6.6629695986E+00, 5.0491712794E+00, 6.8473974430E-01, 5.5293085157E-01, 6.5771450741E-01],
	[1.3270000000E+04, 6.6662914242E+00, 5.0487747359E+00, 6.8556670266E-01, 5.5348810129E-01, 6.5787478832E-01],
	[1.3275000000E+04, 6.6696136536E+00, 5.0483783729E+00, 6.8639434745E-01, 5.5404560094E-01, 6.5803502451E-01],
	[1.3280000000E+04, 6.6729362866E+00, 5.0479821903E+00, 6.8722267900E-01, 5.5460335036E-01, 6.5819521596E-01],
	[1.3285000000E+04, 6.6762593232E+00, 5.0475861879E+00, 6.8805169761E-01, 5.5516134934E-01, 6.5835536265E-01],
	[1.3290000000E+04, 6.6795827632E+00, 5.0471903655E+00, 6.8888140360E-01, 5.5571959772E-01, 6.5851546457E-01],
	[1.3295000000E+04, 6.6829066066E+00, 5.0467947231E+00, 6.8971179727E-01, 5.5627809531E-01, 6.5867552168E-01],
	[1.3300000000E+04, 6.6862308533E+00, 5.0463992604E+00, 6.9054287893E-01, 5.5683684192E-01, 6.5883553396E-01],
	[1.3305000000E+04, 6.6895555031E+00, 5.0460039774E+00, 6.9137464890E-01, 5.5739583737E-01, 6.5899550140E-01],
	[1.3310000000E+04, 6.6928805559E+00, 5.0456088738E+00, 6.9220710749E-01, 5.5795508147E-01, 6.5915542396E-01],
	[1.3315000000E+04, 6.6962060117E+00, 5.0452139495E+00, 6.9304025501E-01, 5.5851457405E-01, 6.5931530164E-01],
	[1.3320000000E+04, 6.6995318704E+00, 5.0448192044E+00, 6.9387409176E-01, 5.5907431492E-01, 6.5947513441E-01],
	[1.3325000000E+04, 6.7028581318E+00, 5.0444246383E+00, 6.9470861806E-01, 5.5963430389E-01, 6.5963492224E-01],
	[1.3330000000E+04, 6.7061847958E+00, 5.0440302511E+00, 6.9554383423E-01, 5.6019454078E-01, 6.5979466512E-01],
	[1.3335000000E+04, 6.7095118623E+00, 5.0436360425E+00, 6.9637974056E-01, 5.6075502540E-01, 6.5995436302E-01],
	[1.3340000000E+04, 6.7128393313E+00, 5.0432420126E+00, 6.9721633738E-01, 5.6131575757E-01, 6.6011401593E-01],
	[1.3345000000E+04, 6.7161672026E+00, 5.0428481611E+00, 6.9805362499E-01, 5.6187673711E-01, 6.6027362381E-01],
	[1.3350000000E+04, 6.7194954762E+00, 5.0424544879E+00, 6.9889160370E-01, 5.6243796382E-01, 6.6043318666E-01],
	[1.3355000000E+04, 6.7228241519E+00, 5.0420609928E+00, 6.9973027383E-01, 5.6299943752E-01, 6.6059270444E-01],
	[1.3360000000E+04, 6.7261532296E+00, 5.0416676757E+00, 7.0056963569E-01, 5.6356115802E-01, 6.6075217715E-01],
	[1.3365000000E+04, 6.7294827092E+00, 5.0412745364E+00, 7.0140968959E-01, 5.6412312515E-01, 6.6091160475E-01],
	[1.3370000000E+04, 6.7328125906E+00, 5.0408815748E+00, 7.0225043583E-01, 5.6468533871E-01, 6.6107098722E-01],
	[1.3375000000E+04, 6.7361428738E+00, 5.0404887908E+00, 7.0309187473E-01, 5.6524779851E-01, 6.6123032456E-01],
	[1.3380000000E+04, 6.7394735586E+00, 5.0400961841E+00, 7.0393400661E-01, 5.6581050437E-01, 6.6138961672E-01],
	[1.3385000000E+04, 6.7428046449E+00, 5.0397037547E+00, 7.0477683177E-01, 5.6637345611E-01, 6.6154886370E-01],
	[1.3390000000E+04, 6.7461361326E+00, 5.0393115024E+00, 7.0562035052E-01, 5.6693665353E-01, 6.6170806548E-01],
	[1.3395000000E+04, 6.7494680216E+00, 5.0389194271E+00, 7.0646456317E-01, 5.6750009644E-01, 6.6186722202E-01],
	[1.3400000000E+04, 6.7528003118E+00, 5.0385275286E+00, 7.0730947005E-01, 5.6806378467E-01, 6.6202633332E-01],
	[1.3405000000E+04, 6.7561330032E+00, 5.0381358067E+00, 7.0815507144E-01, 5.6862771801E-01, 6.6218539935E-01],
	[1.3410000000E+04, 6.7594660955E+00, 5.0377442614E+00, 7.0900136768E-01, 5.6919189629E-01, 6.6234442009E-01],
	[1.3415000000E+04, 6.7627995888E+00, 5.0373528924E+00, 7.0984835907E-01, 5.6975631932E-01, 6.6250339553E-01],
	[1.3420000000E+04, 6.7661334828E+00, 5.0369616997E+00, 7.1069604592E-01, 5.7032098690E-01, 6.6266232563E-01],
	[1.3425000000E+04, 6.7694677776E+00, 5.0365706830E+00, 7.1154442854E-01, 5.7088589884E-01, 6.6282121038E-01],
	[1.3430000000E+04, 6.7728024730E+00, 5.0361798423E+00, 7.1239350725E-01, 5.7145105497E-01, 6.6298004976E-01],
	[1.3435000000E+04, 6.7761375688E+00, 5.0357891774E+00, 7.1324328235E-01, 5.7201645509E-01, 6.6313884376E-01],
	[1.3440000000E+04, 6.7794730651E+00, 5.0353986881E+00, 7.1409375416E-01, 5.7258209900E-01, 6.6329759234E-01],
	[1.3445000000E+04, 6.7828089617E+00, 5.0350083744E+00, 7.1494492299E-01, 5.7314798653E-01, 6.6345629549E-01],
	[1.3450000000E+04, 6.7861452584E+00, 5.0346182360E+00, 7.1579678915E-01, 5.7371411748E-01, 6.6361495318E-01],
	[1.3455000000E+04, 6.7894819553E+00, 5.0342282728E+00, 7.1664935295E-01, 5.7428049166E-01, 6.6377356538E-01],
	[1.3460000000E+04, 6.7928235734E+00, 5.0338409641E+00, 7.1750261471E-01, 5.7484717359E-01, 6.6393213207E-01],
	[1.3465000000E+04, 6.7961742207E+00, 5.0334585570E+00, 7.1835657473E-01, 5.7541422220E-01, 6.6409065322E-01],
	[1.3470000000E+04, 6.7995252758E+00, 5.0330763210E+00, 7.1921123332E-01, 5.7598151407E-01, 6.6424912880E-01],
	[1.3475000000E+04, 6.8028767387E+00, 5.0326942558E+00, 7.2006659081E-01, 5.7654904901E-01, 6.6440755880E-01],
	[1.3480000000E+04, 6.8062286092E+00, 5.0323123613E+00, 7.2092264749E-01, 5.7711682682E-01, 6.6456594319E-01],
	[1.3485000000E+04, 6.8095808873E+00, 5.0319306375E+00, 7.2177940368E-01, 5.7768484731E-01, 6.6472428194E-01],
	[1.3490000000E+04, 6.8129335729E+00, 5.0315490840E+00, 7.2263685970E-01, 5.7825311030E-01, 6.6488257504E-01],
	[1.3495000000E+04, 6.8162866657E+00, 5.0311677009E+00, 7.2349501586E-01, 5.7882161559E-01, 6.6504082245E-01],
	[1.3500000000E+04, 6.8196401659E+00, 5.0307864880E+00, 7.2435387245E-01, 5.7939036299E-01, 6.6519902416E-01],
	[1.3505000000E+04, 6.8229940731E+00, 5.0304054451E+00, 7.2521342981E-01, 5.7995935232E-01, 6.6535718014E-01],
	[1.3510000000E+04, 6.8263483874E+00, 5.0300245721E+00, 7.2607368824E-01, 5.8052858338E-01, 6.6551529037E-01],
	[1.3515000000E+04, 6.8297031087E+00, 5.0296438688E+00, 7.2693464805E-01, 5.8109805597E-01, 6.6567335482E-01],
	[1.3520000000E+04, 6.8330582368E+00, 5.0292633351E+00, 7.2779630955E-01, 5.8166776992E-01, 6.6583137347E-01],
	[1.3525000000E+04, 6.8364137716E+00, 5.0288829710E+00, 7.2865867306E-01, 5.8223772501E-01, 6.6598934629E-01],
	[1.3530000000E+04, 6.8397697131E+00, 5.0285027762E+00, 7.2952173889E-01, 5.8280792108E-01, 6.6614727328E-01],
	[1.3535000000E+04, 6.8431260611E+00, 5.0281227505E+00, 7.3038550735E-01, 5.8337835791E-01, 6.6630515439E-01],
	[1.3540000000E+04, 6.8464828155E+00, 5.0277428940E+00, 7.3124997874E-01, 5.8394903532E-01, 6.6646298961E-01],
	[1.3545000000E+04, 6.8498399763E+00, 5.0273632063E+00, 7.3211515339E-01, 5.8451995312E-01, 6.6662077891E-01],
	[1.3550000000E+04, 6.8531975432E+00, 5.0269836875E+00, 7.3298103161E-01, 5.8509111111E-01, 6.6677852228E-01],
	[1.3555000000E+04, 6.8565555164E+00, 5.0266043373E+00, 7.3384761370E-01, 5.8566250910E-01, 6.6693621968E-01],
	[1.3560000000E+04, 6.8599138955E+00, 5.0262251556E+00, 7.3471489998E-01, 5.8623414690E-01, 6.6709387110E-01],
	[1.3565000000E+04, 6.8632726806E+00, 5.0258461423E+00, 7.3558289077E-01, 5.8680602431E-01, 6.6725147651E-01],
	[1.3570000000E+04, 6.8666318716E+00, 5.0254672973E+00, 7.3645158637E-01, 5.8737814114E-01, 6.6740903590E-01],
	[1.3575000000E+04, 6.8699914682E+00, 5.0250886203E+00, 7.3732098709E-01, 5.8795049720E-01, 6.6756654923E-01],
	[1.3580000000E+04, 6.8733514705E+00, 5.0247101114E+00, 7.3819109325E-01, 5.8852309229E-01, 6.6772401648E-01],
	[1.3585000000E+04, 6.8767118783E+00, 5.0243317702E+00, 7.3906190516E-01, 5.8909592622E-01, 6.6788143764E-01],
	[1.3590000000E+04, 6.8800726916E+00, 5.0239535968E+00, 7.3993342313E-01, 5.8966899880E-01, 6.6803881268E-01],
	[1.3595000000E+04, 6.8834339101E+00, 5.0235755909E+00, 7.4080564747E-01, 5.9024230982E-01, 6.6819614158E-01],
	[1.3600000000E+04, 6.8867955339E+00, 5.0231977524E+00, 7.4167857851E-01, 5.9081585909E-01, 6.6835342431E-01],
	[1.3605000000E+04, 6.8901575629E+00, 5.0228200812E+00, 7.4255221654E-01, 5.9138964643E-01, 6.6851066085E-01],
	[1.3610000000E+04, 6.8935199968E+00, 5.0224425772E+00, 7.4342656188E-01, 5.9196367163E-01, 6.6866785119E-01],
	[1.3615000000E+04, 6.8968828357E+00, 5.0220652402E+00, 7.4430161484E-01, 5.9253793450E-01, 6.6882499530E-01],
	[1.3620000000E+04, 6.9002460794E+00, 5.0216880700E+00, 7.4517737574E-01, 5.9311243484E-01, 6.6898209315E-01],
	[1.3625000000E+04, 6.9036097278E+00, 5.0213110667E+00, 7.4605384489E-01, 5.9368717246E-01, 6.6913914473E-01],
	[1.3630000000E+04, 6.9069737809E+00, 5.0209342299E+00, 7.4693102259E-01, 5.9426214716E-01, 6.6929615001E-01],
	[1.3635000000E+04, 6.9103382385E+00, 5.0205575596E+00, 7.4780890917E-01, 5.9483735875E-01, 6.6945310897E-01],
	[1.3640000000E+04, 6.9137031005E+00, 5.0201810557E+00, 7.4868750493E-01, 5.9541280703E-01, 6.6961002159E-01],
	[1.3645000000E+04, 6.9170683669E+00, 5.0198047179E+00, 7.4956681019E-01, 5.9598849180E-01, 6.6976688785E-01],
	[1.3650000000E+04, 6.9204340375E+00, 5.0194285463E+00, 7.5044682526E-01, 5.9656441286E-01, 6.6992370773E-01],
	[1.3655000000E+04, 6.9238001122E+00, 5.0190525405E+00, 7.5132755045E-01, 5.9714057003E-01, 6.7008048120E-01],
	[1.3660000000E+04, 6.9271665909E+00, 5.0186767006E+00, 7.5220898608E-01, 5.9771696310E-01, 6.7023720824E-01],
	[1.3665000000E+04, 6.9305334736E+00, 5.0183010264E+00, 7.5309113245E-01, 5.9829359187E-01, 6.7039388884E-01],
	[1.3670000000E+04, 6.9339007601E+00, 5.0179255177E+00, 7.5397398989E-01, 5.9887045615E-01, 6.7055052297E-01],
	[1.3675000000E+04, 6.9372686139E+00, 5.0175502591E+00, 7.5485755869E-01, 5.9944755817E-01, 6.7070711060E-01],
	[1.3680000000E+04, 6.9406503997E+00, 5.0171821673E+00, 7.5574183918E-01, 6.0002509656E-01, 6.7086365173E-01],
	[1.3685000000E+04, 6.9440325974E+00, 5.0168142370E+00, 7.5662683166E-01, 6.0060287049E-01, 6.7102014632E-01],
	[1.3690000000E+04, 6.9474152068E+00, 5.0164464681E+00, 7.5751253646E-01, 6.0118087976E-01, 6.7117659435E-01],
	[1.3695000000E+04, 6.9507982279E+00, 5.0160788604E+00, 7.5840040922E-01, 6.0176004042E-01, 6.7133299581E-01],
	[1.3700000000E+04, 6.9541816605E+00, 5.0157114138E+00, 7.5929137472E-01, 6.0234093292E-01, 6.7148935068E-01],
	[1.3705000000E+04, 6.9575655046E+00, 5.0153441282E+00, 7.6018306113E-01, 6.0292206297E-01, 6.7164565893E-01],
	[1.3710000000E+04, 6.9609497600E+00, 5.0149770035E+00, 7.6107546878E-01, 6.0350343038E-01, 6.7180192054E-01],
	[1.3715000000E+04, 6.9643344266E+00, 5.0146100395E+00, 7.6196859799E-01, 6.0408503496E-01, 6.7195813549E-01],
	[1.3720000000E+04, 6.9677195044E+00, 5.0142432360E+00, 7.6286244908E-01, 6.0466687649E-01, 6.7211430376E-01],
	[1.3725000000E+04, 6.9711049932E+00, 5.0138765931E+00, 7.6375702237E-01, 6.0524895478E-01, 6.7227042534E-01],
	[1.3730000000E+04, 6.9744908930E+00, 5.0135101105E+00, 7.6465231817E-01, 6.0583126962E-01, 6.7242650019E-01],
	[1.3735000000E+04, 6.9778772036E+00, 5.0131437881E+00, 7.6554833682E-01, 6.0641382083E-01, 6.7258252830E-01],
	[1.3740000000E+04, 6.9812639250E+00, 5.0127776258E+00, 7.6644507862E-01, 6.0699660819E-01, 6.7273850965E-01],
	[1.3745000000E+04, 6.9846510570E+00, 5.0124116234E+00, 7.6734254390E-01, 6.0757963151E-01, 6.7289444422E-01],
	[1.3750000000E+04, 6.9880385995E+00, 5.0120457808E+00, 7.6824073298E-01, 6.0816289058E-01, 6.7305033198E-01],
	[1.3755000000E+04, 6.9914265525E+00, 5.0116800980E+00, 7.6913964618E-01, 6.0874638520E-01, 6.7320617293E-01],
	[1.3760000000E+04, 6.9948149159E+00, 5.0113145747E+00, 7.7003928382E-01, 6.0933011517E-01, 6.7336196703E-01],
	[1.3765000000E+04, 6.9982036894E+00, 5.0109492109E+00, 7.7093964621E-01, 6.0991408029E-01, 6.7351771427E-01],
	[1.3770000000E+04, 7.0015928732E+00, 5.0105840063E+00, 7.7184073369E-01, 6.1049828036E-01, 6.7367341462E-01],
	[1.3775000000E+04, 7.0049824670E+00, 5.0102189610E+00, 7.7274254657E-01, 6.1108271517E-01, 6.7382906808E-01],
	[1.3780000000E+04, 7.0083724707E+00, 5.0098540747E+00, 7.7364508516E-01, 6.1166738452E-01, 6.7398467461E-01],
	[1.3785000000E+04, 7.0117628843E+00, 5.0094893474E+00, 7.7454834980E-01, 6.1225228822E-01, 6.7414023420E-01],
	[1.3790000000E+04, 7.0151537076E+00, 5.0091247789E+00, 7.7545234079E-01, 6.1283742604E-01, 6.7429574682E-01],
	[1.3795000000E+04, 7.0185449406E+00, 5.0087603690E+00, 7.7635705847E-01, 6.1342279781E-01, 6.7445121247E-01],
	[1.3800000000E+04, 7.0219365832E+00, 5.0083961177E+00, 7.7726250314E-01, 6.1400840330E-01, 6.7460663111E-01],
	[1.3805000000E+04, 7.0253286352E+00, 5.0080320248E+00, 7.7816867514E-01, 6.1459424231E-01, 6.7476200274E-01],
	[1.3810000000E+04, 7.0287210965E+00, 5.0076680902E+00, 7.7907557478E-01, 6.1518031465E-01, 6.7491732732E-01],
	[1.3815000000E+04, 7.0321139671E+00, 5.0073043138E+00, 7.7998320238E-01, 6.1576662011E-01, 6.7507260484E-01],
	[1.3820000000E+04, 7.0355072469E+00, 5.0069406955E+00, 7.8089155826E-01, 6.1635315848E-01, 6.7522783529E-01],
	[1.3825000000E+04, 7.0389009357E+00, 5.0065772350E+00, 7.8180064275E-01, 6.1693992957E-01, 6.7538301863E-01],
	[1.3830000000E+04, 7.0422950335E+00, 5.0062139324E+00, 7.8271045616E-01, 6.1752693316E-01, 6.7553815486E-01],
	[1.3835000000E+04, 7.0456895401E+00, 5.0058507874E+00, 7.8362099881E-01, 6.1811416905E-01, 6.7569324395E-01],
	[1.3840000000E+04, 7.0490844555E+00, 5.0054878000E+00, 7.8453227103E-01, 6.1870163704E-01, 6.7584828589E-01],
	[1.3845000000E+04, 7.0524797796E+00, 5.0051249700E+00, 7.8544427313E-01, 6.1928933692E-01, 6.7600328065E-01],
	[1.3850000000E+04, 7.0558755122E+00, 5.0047622973E+00, 7.8635700544E-01, 6.1987726848E-01, 6.7615822821E-01],
	[1.3855000000E+04, 7.0592716534E+00, 5.0043997817E+00, 7.8727046828E-01, 6.2046543153E-01, 6.7631312856E-01],
	[1.3860000000E+04, 7.0626682028E+00, 5.0040374232E+00, 7.8818466196E-01, 6.2105382586E-01, 6.7646798168E-01],
	[1.3865000000E+04, 7.0660651606E+00, 5.0036752217E+00, 7.8909958681E-01, 6.2164245126E-01, 6.7662278756E-01],
	[1.3870000000E+04, 7.0694625265E+00, 5.0033131769E+00, 7.9001524314E-01, 6.2223130752E-01, 6.7677754616E-01],
	[1.3875000000E+04, 7.0728603005E+00, 5.0029512888E+00, 7.9093163129E-01, 6.2282039444E-01, 6.7693225747E-01],
	[1.3880000000E+04, 7.0762584824E+00, 5.0025895572E+00, 7.9184875156E-01, 6.2340971181E-01, 6.7708692147E-01],
	[1.3885000000E+04, 7.0796570723E+00, 5.0022279821E+00, 7.9276660429E-01, 6.2399925943E-01, 6.7724153816E-01],
	[1.3890000000E+04, 7.0830560699E+00, 5.0018665633E+00, 7.9368518978E-01, 6.2458903709E-01, 6.7739610749E-01],
	[1.3895000000E+04, 7.0864554752E+00, 5.0015053006E+00, 7.9460450837E-01, 6.2517904458E-01, 6.7755062947E-01],
	[1.3900000000E+04, 7.0898692794E+00, 5.0011510387E+00, 7.9552456037E-01, 6.2576949786E-01, 6.7770510406E-01],
	[1.3905000000E+04, 7.0932837508E+00, 5.0007970522E+00, 7.9644534610E-01, 6.2636018509E-01, 6.7785953126E-01],
	[1.3910000000E+04, 7.0966986381E+00, 5.0004432180E+00, 7.9736686589E-01, 6.2695110219E-01, 6.7801391104E-01],
	[1.3915000000E+04, 7.1001139412E+00, 5.0000895359E+00, 7.9828912005E-01, 6.2754224897E-01, 6.7816824338E-01],
	[1.3920000000E+04, 7.1035296601E+00, 4.9997360060E+00, 7.9921210891E-01, 6.2813362520E-01, 6.7832252827E-01],
	[1.3925000000E+04, 7.1069457947E+00, 4.9993826279E+00, 8.0013583279E-01, 6.2872523068E-01, 6.7847676569E-01],
	[1.3930000000E+04, 7.1103623448E+00, 4.9990294017E+00, 8.0106029200E-01, 6.2931706521E-01, 6.7863095562E-01],
	[1.3935000000E+04, 7.1137793104E+00, 4.9986763272E+00, 8.0198548688E-01, 6.2990912858E-01, 6.7878509805E-01],
	[1.3940000000E+04, 7.1171966913E+00, 4.9983234043E+00, 8.0291141773E-01, 6.3050142059E-01, 6.7893919295E-01],
	[1.3945000000E+04, 7.1206144875E+00, 4.9979706329E+00, 8.0383808489E-01, 6.3109394101E-01, 6.7909324030E-01],
	[1.3950000000E+04, 7.1240326989E+00, 4.9976180128E+00, 8.0476548866E-01, 6.3168668965E-01, 6.7924724010E-01],
	[1.3955000000E+04, 7.1274513253E+00, 4.9972655439E+00, 8.0569362938E-01, 6.3227966630E-01, 6.7940119231E-01],
	[1.3960000000E+04, 7.1308703667E+00, 4.9969132262E+00, 8.0662250737E-01, 6.3287287075E-01, 6.7955509694E-01],
	[1.3965000000E+04, 7.1342898230E+00, 4.9965610594E+00, 8.0755212294E-01, 6.3346630279E-01, 6.7970895395E-01],
	[1.3970000000E+04, 7.1377096940E+00, 4.9962090435E+00, 8.0848247642E-01, 6.3405996222E-01, 6.7986276332E-01],
	[1.3975000000E+04, 7.1411299798E+00, 4.9958571784E+00, 8.0941356812E-01, 6.3465384882E-01, 6.8001652505E-01],
	[1.3980000000E+04, 7.1445506800E+00, 4.9955054639E+00, 8.1034539838E-01, 6.3524796239E-01, 6.8017023912E-01],
	[1.3985000000E+04, 7.1479717948E+00, 4.9951538999E+00, 8.1127796750E-01, 6.3584230271E-01, 6.8032390550E-01],
	[1.3990000000E+04, 7.1513933239E+00, 4.9948024863E+00, 8.1221127582E-01, 6.3643686958E-01, 6.8047752418E-01],
	[1.3995000000E+04, 7.1548152674E+00, 4.9944512230E+00, 8.1314532365E-01, 6.3703166279E-01, 6.8063109515E-01],
	[1.4000000000E+04, 7.1582376250E+00, 4.9941001099E+00, 8.1408011131E-01, 6.3762668213E-01, 6.8078461838E-01],
	[1.4005000000E+04, 7.1616603967E+00, 4.9937491468E+00, 8.1501563913E-01, 6.3822192739E-01, 6.8093809386E-01],
	[1.4010000000E+04, 7.1650835823E+00, 4.9933983336E+00, 8.1595190743E-01, 6.3881739836E-01, 6.8109152157E-01],
	[1.4015000000E+04, 7.1685071819E+00, 4.9930476703E+00, 8.1688891652E-01, 6.3941309482E-01, 6.8124490150E-01],
	[1.4020000000E+04, 7.1719311952E+00, 4.9926971566E+00, 8.1782666674E-01, 6.4000901658E-01, 6.8139823363E-01],
	[1.4025000000E+04, 7.1753556223E+00, 4.9923467925E+00, 8.1876515839E-01, 6.4060516342E-01, 6.8155151793E-01],
	[1.4030000000E+04, 7.1787804629E+00, 4.9919965779E+00, 8.1970439181E-01, 6.4120153512E-01, 6.8170475441E-01],
	[1.4035000000E+04, 7.1822057171E+00, 4.9916465126E+00, 8.2064436731E-01, 6.4179813148E-01, 6.8185794303E-01],
	[1.4040000000E+04, 7.1856313846E+00, 4.9912965966E+00, 8.2158508522E-01, 6.4239495229E-01, 6.8201108378E-01],
	[1.4045000000E+04, 7.1890574655E+00, 4.9909468296E+00, 8.2252654586E-01, 6.4299199733E-01, 6.8216417664E-01],
	[1.4050000000E+04, 7.1924839595E+00, 4.9905972117E+00, 8.2346874954E-01, 6.4358926640E-01, 6.8231722161E-01],
	[1.4055000000E+04, 7.1959108667E+00, 4.9902477426E+00, 8.2441169660E-01, 6.4418675928E-01, 6.8247021865E-01],
	[1.4060000000E+04, 7.1993381869E+00, 4.9898984222E+00, 8.2535538735E-01, 6.4478447577E-01, 6.8262316777E-01],
	[1.4065000000E+04, 7.2027659200E+00, 4.9895492506E+00, 8.2629982211E-01, 6.4538241564E-01, 6.8277606893E-01],
	[1.4070000000E+04, 7.2061940659E+00, 4.9892002274E+00, 8.2724500120E-01, 6.4598057869E-01, 6.8292892212E-01],
	[1.4075000000E+04, 7.2096226245E+00, 4.9888513527E+00, 8.2819092496E-01, 6.4657896471E-01, 6.8308172734E-01],
	[1.4080000000E+04, 7.2130515958E+00, 4.9885026262E+00, 8.2913759369E-01, 6.4717757348E-01, 6.8323448455E-01],
	[1.4085000000E+04, 7.2164809796E+00, 4.9881540479E+00, 8.3008500772E-01, 6.4777640479E-01, 6.8338719375E-01],
	[1.4090000000E+04, 7.2199107758E+00, 4.9878056177E+00, 8.3103316738E-01, 6.4837545843E-01, 6.8353985492E-01],
	[1.4095000000E+04, 7.2233409843E+00, 4.9874573354E+00, 8.3198207298E-01, 6.4897473418E-01, 6.8369246804E-01],
	[1.4100000000E+04, 7.2267716051E+00, 4.9871092010E+00, 8.3293172484E-01, 6.4957423184E-01, 6.8384503309E-01],
	[1.4105000000E+04, 7.2302026380E+00, 4.9867612143E+00, 8.3388212330E-01, 6.5017395119E-01, 6.8399755007E-01],
	[1.4110000000E+04, 7.2336340830E+00, 4.9864133752E+00, 8.3483326866E-01, 6.5077389202E-01, 6.8415001896E-01],
	[1.4115000000E+04, 7.2370659399E+00, 4.9860656836E+00, 8.3578516125E-01, 6.5137405411E-01, 6.8430243973E-01],
	[1.4120000000E+04, 7.2405018186E+00, 4.9857198111E+00, 8.3673780140E-01, 6.5197449510E-01, 6.8445481238E-01],
	[1.4125000000E+04, 7.2439493013E+00, 4.9853792646E+00, 8.3769118943E-01, 6.5257533666E-01, 6.8460713689E-01],
	[1.4130000000E+04, 7.2473972045E+00, 4.9850388618E+00, 8.3864532565E-01, 6.5317639954E-01, 6.8475941324E-01],
	[1.4135000000E+04, 7.2508455281E+00, 4.9846986027E+00, 8.3960021038E-01, 6.5377768352E-01, 6.8491164142E-01],
	[1.4140000000E+04, 7.2542942719E+00, 4.9843584871E+00, 8.4055584397E-01, 6.5437918839E-01, 6.8506382141E-01],
	[1.4145000000E+04, 7.2577434360E+00, 4.9840185150E+00, 8.4151222671E-01, 6.5498091393E-01, 6.8521595320E-01],
	[1.4150000000E+04, 7.2611930201E+00, 4.9836786862E+00, 8.4246935894E-01, 6.5558285993E-01, 6.8536803677E-01],
	[1.4155000000E+04, 7.2646430242E+00, 4.9833390006E+00, 8.4342724098E-01, 6.5618502618E-01, 6.8552007211E-01],
	[1.4160000000E+04, 7.2680934482E+00, 4.9829994581E+00, 8.4438587314E-01, 6.5678741247E-01, 6.8567205920E-01],
	[1.4165000000E+04, 7.2715442920E+00, 4.9826600587E+00, 8.4534525576E-01, 6.5739001857E-01, 6.8582399803E-01],
	[1.4170000000E+04, 7.2749955555E+00, 4.9823208021E+00, 8.4630538915E-01, 6.5799284429E-01, 6.8597588858E-01],
	[1.4175000000E+04, 7.2784472386E+00, 4.9819816883E+00, 8.4726627364E-01, 6.5859588939E-01, 6.8612773083E-01],
	[1.4180000000E+04, 7.2818993412E+00, 4.9816427171E+00, 8.4822790955E-01, 6.5919915367E-01, 6.8627952476E-01],
	[1.4185000000E+04, 7.2853518632E+00, 4.9813038885E+00, 8.4919029719E-01, 6.5980263691E-01, 6.8643127036E-01],
	[1.4190000000E+04, 7.2888048045E+00, 4.9809652024E+00, 8.5015343690E-01, 6.6040633889E-01, 6.8658296760E-01],
	[1.4195000000E+04, 7.2922581651E+00, 4.9806266586E+00, 8.5111732900E-01, 6.6101025941E-01, 6.8673461647E-01],
	[1.4200000000E+04, 7.2957119447E+00, 4.9802882570E+00, 8.5208197380E-01, 6.6161439825E-01, 6.8688621695E-01],
	[1.4205000000E+04, 7.2991661434E+00, 4.9799499975E+00, 8.5304737163E-01, 6.6221875518E-01, 6.8703776902E-01],
	[1.4210000000E+04, 7.3026207610E+00, 4.9796118800E+00, 8.5401352281E-01, 6.6282333001E-01, 6.8718927266E-01],
	[1.4215000000E+04, 7.3060757974E+00, 4.9792739045E+00, 8.5498042767E-01, 6.6342812250E-01, 6.8734072786E-01],
	[1.4220000000E+04, 7.3095312525E+00, 4.9789360707E+00, 8.5594808653E-01, 6.6403313244E-01, 6.8749213460E-01],
	[1.4225000000E+04, 7.3129871263E+00, 4.9785983786E+00, 8.5691649970E-01, 6.6463835963E-01, 6.8764349285E-01],
	[1.4230000000E+04, 7.3164434186E+00, 4.9782608280E+00, 8.5788566752E-01, 6.6524380383E-01, 6.8779480261E-01],
	[1.4235000000E+04, 7.3199001294E+00, 4.9779234189E+00, 8.5885559030E-01, 6.6584946484E-01, 6.8794606385E-01],
	[1.4240000000E+04, 7.3233572585E+00, 4.9775861512E+00, 8.5982626836E-01, 6.6645534244E-01, 6.8809727656E-01],
	[1.4245000000E+04, 7.3268148058E+00, 4.9772490247E+00, 8.6079770204E-01, 6.6706143641E-01, 6.8824844073E-01],
	[1.4250000000E+04, 7.3302727713E+00, 4.9769120394E+00, 8.6176989164E-01, 6.6766774654E-01, 6.8839955632E-01],
	[1.4255000000E+04, 7.3337311549E+00, 4.9765751950E+00, 8.6274283750E-01, 6.6827427260E-01, 6.8855062333E-01],
	[1.4260000000E+04, 7.3371899564E+00, 4.9762384916E+00, 8.6371653994E-01, 6.6888101439E-01, 6.8870164174E-01],
	[1.4265000000E+04, 7.3406491757E+00, 4.9759019290E+00, 8.6469099928E-01, 6.6948797168E-01, 6.8885261153E-01],
	[1.4270000000E+04, 7.3441088129E+00, 4.9755655071E+00, 8.6566621584E-01, 6.7009514425E-01, 6.8900353268E-01],
	[1.4275000000E+04, 7.3475688677E+00, 4.9752292257E+00, 8.6664218994E-01, 6.7070253190E-01, 6.8915440518E-01],
	[1.4280000000E+04, 7.3510293401E+00, 4.9748930849E+00, 8.6761892191E-01, 6.7131013439E-01, 6.8930522901E-01],
	[1.4285000000E+04, 7.3544902300E+00, 4.9745570844E+00, 8.6859641207E-01, 6.7191795152E-01, 6.8945600416E-01],
	[1.4290000000E+04, 7.3579515372E+00, 4.9742212242E+00, 8.6957466075E-01, 6.7252598307E-01, 6.8960673060E-01],
	[1.4295000000E+04, 7.3614132617E+00, 4.9738855042E+00, 8.7055366826E-01, 6.7313422881E-01, 6.8975740832E-01],
	[1.4300000000E+04, 7.3648754035E+00, 4.9735499242E+00, 8.7153343493E-01, 6.7374268853E-01, 6.8990803730E-01],
	[1.4305000000E+04, 7.3683379623E+00, 4.9732144841E+00, 8.7251396108E-01, 6.7435136200E-01, 6.9005861753E-01],
	[1.4310000000E+04, 7.3718009381E+00, 4.9728791839E+00, 8.7349524703E-01, 6.7496024902E-01, 6.9020914899E-01],
	[1.4315000000E+04, 7.3752643309E+00, 4.9725440234E+00, 8.7447729311E-01, 6.7556934937E-01, 6.9035963167E-01],
	[1.4320000000E+04, 7.3787281404E+00, 4.9722090026E+00, 8.7546009964E-01, 6.7617866281E-01, 6.9051006554E-01],
	[1.4325000000E+04, 7.3821923667E+00, 4.9718741212E+00, 8.7644366695E-01, 6.7678818914E-01, 6.9066045059E-01],
	[1.4330000000E+04, 7.3856570095E+00, 4.9715393793E+00, 8.7742799535E-01, 6.7739792814E-01, 6.9081078680E-01],
	[1.4335000000E+04, 7.3891220689E+00, 4.9712047766E+00, 8.7841308516E-01, 6.7800787958E-01, 6.9096107417E-01],
	[1.4340000000E+04, 7.3925875448E+00, 4.9708703132E+00, 8.7939893672E-01, 6.7861804324E-01, 6.9111131266E-01],
	[1.4345000000E+04, 7.3960534369E+00, 4.9705359889E+00, 8.8038555035E-01, 6.7922841891E-01, 6.9126150228E-01],
	[1.4350000000E+04, 7.3995318109E+00, 4.9702070948E+00, 8.8137292636E-01, 6.7983920722E-01, 6.9141164299E-01],
	[1.4355000000E+04, 7.4030139072E+00, 4.9698797830E+00, 8.8236106508E-01, 6.8045026263E-01, 6.9156173478E-01],
	[1.4360000000E+04, 7.4064964286E+00, 4.9695526068E+00, 8.8334996684E-01, 6.8106153012E-01, 6.9171177764E-01],
	[1.4365000000E+04, 7.4099793749E+00, 4.9692255660E+00, 8.8433963195E-01, 6.8167300946E-01, 6.9186177156E-01],
	[1.4370000000E+04, 7.4134627463E+00, 4.9688986605E+00, 8.8533006074E-01, 6.8228470043E-01, 6.9201171651E-01],
	[1.4375000000E+04, 7.4169465424E+00, 4.9685718902E+00, 8.8632125354E-01, 6.8289660282E-01, 6.9216161248E-01],
	[1.4380000000E+04, 7.4204307633E+00, 4.9682452551E+00, 8.8731321066E-01, 6.8350871640E-01, 6.9231145946E-01],
	[1.4385000000E+04, 7.4239154088E+00, 4.9679187550E+00, 8.8830593244E-01, 6.8412104096E-01, 6.9246125743E-01],
	[1.4390000000E+04, 7.4274004789E+00, 4.9675923897E+00, 8.8929941918E-01, 6.8473357626E-01, 6.9261100637E-01],
	[1.4395000000E+04, 7.4308859734E+00, 4.9672661593E+00, 8.9029367122E-01, 6.8534632210E-01, 6.9276070627E-01],
	[1.4400000000E+04, 7.4343718923E+00, 4.9669400636E+00, 8.9128868888E-01, 6.8595927826E-01, 6.9291035711E-01],
	[1.4405000000E+04, 7.4378582354E+00, 4.9666141025E+00, 8.9228447249E-01, 6.8657244450E-01, 6.9305995888E-01],
	[1.4410000000E+04, 7.4413450027E+00, 4.9662882759E+00, 8.9328102235E-01, 6.8718582061E-01, 6.9320951156E-01],
	[1.4415000000E+04, 7.4448321941E+00, 4.9659625837E+00, 8.9427833881E-01, 6.8779940638E-01, 6.9335901513E-01],
	[1.4420000000E+04, 7.4483198094E+00, 4.9656370258E+00, 8.9527642218E-01, 6.8841320157E-01, 6.9350846959E-01],
	[1.4425000000E+04, 7.4518078486E+00, 4.9653116021E+00, 8.9627527279E-01, 6.8902720598E-01, 6.9365787492E-01],
	[1.4430000000E+04, 7.4552963116E+00, 4.9649863125E+00, 8.9727489096E-01, 6.8964141937E-01, 6.9380723110E-01],
	[1.4435000000E+04, 7.4587851983E+00, 4.9646611569E+00, 8.9827527701E-01, 6.9025584152E-01, 6.9395653811E-01],
	[1.4440000000E+04, 7.4622745085E+00, 4.9643361352E+00, 8.9927643126E-01, 6.9087047222E-01, 6.9410579595E-01],
	[1.4445000000E+04, 7.4657642423E+00, 4.9640112473E+00, 9.0027835405E-01, 6.9148531124E-01, 6.9425500460E-01],
	[1.4450000000E+04, 7.4692543994E+00, 4.9636864930E+00, 9.0128104568E-01, 6.9210035835E-01, 6.9440416403E-01],
	[1.4455000000E+04, 7.4727449799E+00, 4.9633618724E+00, 9.0228450650E-01, 6.9271561335E-01, 6.9455327425E-01],
	[1.4460000000E+04, 7.4762359835E+00, 4.9630373852E+00, 9.0328873682E-01, 6.9333107600E-01, 6.9470233522E-01],
	[1.4465000000E+04, 7.4797274103E+00, 4.9627130314E+00, 9.0429373696E-01, 6.9394674609E-01, 6.9485134695E-01],
	[1.4470000000E+04, 7.4832192601E+00, 4.9623888109E+00, 9.0529950724E-01, 6.9456262338E-01, 6.9500030941E-01],
	[1.4475000000E+04, 7.4867115328E+00, 4.9620647236E+00, 9.0630604800E-01, 6.9517870767E-01, 6.9514922259E-01],
	[1.4480000000E+04, 7.4902042283E+00, 4.9617407694E+00, 9.0731335956E-01, 6.9579499871E-01, 6.9529808647E-01],
	[1.4485000000E+04, 7.4936973466E+00, 4.9614169481E+00, 9.0832144223E-01, 6.9641149631E-01, 6.9544690104E-01],
	[1.4490000000E+04, 7.4971908875E+00, 4.9610932597E+00, 9.0933029634E-01, 6.9702820021E-01, 6.9559566629E-01],
	[1.4495000000E+04, 7.5006848509E+00, 4.9607697041E+00, 9.1033992223E-01, 6.9764511022E-01, 6.9574438221E-01],
	[1.4500000000E+04, 7.5041792368E+00, 4.9604462812E+00, 9.1135032020E-01, 6.9826222610E-01, 6.9589304877E-01],
	[1.4505000000E+04, 7.5076740451E+00, 4.9601229909E+00, 9.1236149058E-01, 6.9887954763E-01, 6.9604166596E-01],
	[1.4510000000E+04, 7.5111692756E+00, 4.9597998331E+00, 9.1337343370E-01, 6.9949707458E-01, 6.9619023377E-01],
	[1.4515000000E+04, 7.5146649283E+00, 4.9594768076E+00, 9.1438614989E-01, 7.0011480674E-01, 6.9633875219E-01],
	[1.4520000000E+04, 7.5181610030E+00, 4.9591539144E+00, 9.1539963945E-01, 7.0073274387E-01, 6.9648722120E-01],
	[1.4525000000E+04, 7.5216574998E+00, 4.9588311534E+00, 9.1641390273E-01, 7.0135088575E-01, 6.9663564079E-01],
	[1.4530000000E+04, 7.5251544184E+00, 4.9585085245E+00, 9.1742894004E-01, 7.0196923217E-01, 6.9678401094E-01],
	[1.4535000000E+04, 7.5286517588E+00, 4.9581860275E+00, 9.1844475171E-01, 7.0258778289E-01, 6.9693233165E-01],
	[1.4540000000E+04, 7.5321495209E+00, 4.9578636625E+00, 9.1946133805E-01, 7.0320653770E-01, 6.9708060289E-01],
	[1.4545000000E+04, 7.5356477046E+00, 4.9575414292E+00, 9.2047869941E-01, 7.0382549635E-01, 6.9722882465E-01],
	[1.4550000000E+04, 7.5391463097E+00, 4.9572193276E+00, 9.2149683609E-01, 7.0444465864E-01, 6.9737699692E-01],
	[1.4555000000E+04, 7.5426453363E+00, 4.9568973576E+00, 9.2251574842E-01, 7.0506402434E-01, 6.9752511969E-01],
	[1.4560000000E+04, 7.5461447843E+00, 4.9565755191E+00, 9.2353543673E-01, 7.0568359322E-01, 6.9767319295E-01],
	[1.4565000000E+04, 7.5496446534E+00, 4.9562538120E+00, 9.2455590134E-01, 7.0630336505E-01, 6.9782121667E-01],
	[1.4570000000E+04, 7.5531449437E+00, 4.9559322361E+00, 9.2557714258E-01, 7.0692333962E-01, 6.9796919084E-01],
	[1.4575000000E+04, 7.5566456550E+00, 4.9556107915E+00, 9.2659916076E-01, 7.0754351669E-01, 6.9811711546E-01],
	[1.4580000000E+04, 7.5601562665E+00, 4.9552934198E+00, 9.2762195622E-01, 7.0816405972E-01, 6.9826499051E-01],
	[1.4585000000E+04, 7.5636737616E+00, 4.9549788609E+00, 9.2864552927E-01, 7.0878491688E-01, 6.9841281598E-01],
	[1.4590000000E+04, 7.5671916867E+00, 4.9546644298E+00, 9.2966988025E-01, 7.0940597662E-01, 6.9856059185E-01],
	[1.4595000000E+04, 7.5707100418E+00, 4.9543501264E+00, 9.3069500947E-01, 7.1002723872E-01, 6.9870831811E-01],
	[1.4600000000E+04, 7.5742288268E+00, 4.9540359506E+00, 9.3172091726E-01, 7.1064870296E-01, 6.9885599475E-01],
	[1.4605000000E+04, 7.5777480417E+00, 4.9537219022E+00, 9.3274760395E-01, 7.1127036911E-01, 6.9900362175E-01],
	[1.4610000000E+04, 7.5812676862E+00, 4.9534079813E+00, 9.3377506985E-01, 7.1189223695E-01, 6.9915119910E-01],
	[1.4615000000E+04, 7.5847877603E+00, 4.9530941876E+00, 9.3480331530E-01, 7.1251430625E-01, 6.9929872679E-01],
	[1.4620000000E+04, 7.5883082639E+00, 4.9527805212E+00, 9.3583234062E-01, 7.1313657679E-01, 6.9944620481E-01],
	[1.4625000000E+04, 7.5918291970E+00, 4.9524669818E+00, 9.3686214612E-01, 7.1375904834E-01, 6.9959363314E-01],
	[1.4630000000E+04, 7.5953505594E+00, 4.9521535695E+00, 9.3789273214E-01, 7.1438172067E-01, 6.9974101178E-01],
	[1.4635000000E+04, 7.5988723510E+00, 4.9518402841E+00, 9.3892409901E-01, 7.1500459355E-01, 6.9988834070E-01],
	[1.4640000000E+04, 7.6023945717E+00, 4.9515271255E+00, 9.3995624703E-01, 7.1562766677E-01, 7.0003561990E-01],
	[1.4645000000E+04, 7.6059172215E+00, 4.9512140936E+00, 9.4098917655E-01, 7.1625094009E-01, 7.0018284936E-01],
	[1.4650000000E+04, 7.6094403002E+00, 4.9509011884E+00, 9.4202288788E-01, 7.1687441329E-01, 7.0033002907E-01],
	[1.4655000000E+04, 7.6129638078E+00, 4.9505884097E+00, 9.4305738135E-01, 7.1749808615E-01, 7.0047715902E-01],
	[1.4660000000E+04, 7.6164877441E+00, 4.9502757575E+00, 9.4409265728E-01, 7.1812195842E-01, 7.0062423920E-01],
	[1.4665000000E+04, 7.6200121091E+00, 4.9499632316E+00, 9.4512871599E-01, 7.1874602990E-01, 7.0077126959E-01],
	[1.4670000000E+04, 7.6235369027E+00, 4.9496508320E+00, 9.4616555782E-01, 7.1937030035E-01, 7.0091825019E-01],
	[1.4675000000E+04, 7.6270621248E+00, 4.9493385585E+00, 9.4720318309E-01, 7.1999476954E-01, 7.0106518097E-01],
	[1.4680000000E+04, 7.6305877752E+00, 4.9490264111E+00, 9.4824159211E-01, 7.2061943725E-01, 7.0121206194E-01],
	[1.4685000000E+04, 7.6341138539E+00, 4.9487143897E+00, 9.4928078522E-01, 7.2124430325E-01, 7.0135889307E-01],
	[1.4690000000E+04, 7.6376403608E+00, 4.9484024942E+00, 9.5032076274E-01, 7.2186936731E-01, 7.0150567435E-01],
	[1.4695000000E+04, 7.6411672959E+00, 4.9480907244E+00, 9.5136152500E-01, 7.2249462920E-01, 7.0165240578E-01],
	[1.4700000000E+04, 7.6446946589E+00, 4.9477790804E+00, 9.5240307232E-01, 7.2312008870E-01, 7.0179908734E-01],
	[1.4705000000E+04, 7.6482224498E+00, 4.9474675619E+00, 9.5344540502E-01, 7.2374574558E-01, 7.0194571902E-01],
	[1.4710000000E+04, 7.6517506686E+00, 4.9471561690E+00, 9.5448852343E-01, 7.2437159961E-01, 7.0209230080E-01],
	[1.4715000000E+04, 7.6552793150E+00, 4.9468449015E+00, 9.5553242787E-01, 7.2499765056E-01, 7.0223883269E-01],
	[1.4720000000E+04, 7.6588083892E+00, 4.9465337593E+00, 9.5657711867E-01, 7.2562389820E-01, 7.0238531465E-01],
	[1.4725000000E+04, 7.6623378908E+00, 4.9462227423E+00, 9.5762259616E-01, 7.2625034232E-01, 7.0253174669E-01],
	[1.4730000000E+04, 7.6658678199E+00, 4.9459118504E+00, 9.5866886065E-01, 7.2687698266E-01, 7.0267812879E-01],
	[1.4735000000E+04, 7.6693981764E+00, 4.9456010836E+00, 9.5971591248E-01, 7.2750381902E-01, 7.0282446095E-01],
	[1.4740000000E+04, 7.6729289601E+00, 4.9452904418E+00, 9.6076375196E-01, 7.2813085116E-01, 7.0297074314E-01],
	[1.4745000000E+04, 7.6764601709E+00, 4.9449799248E+00, 9.6181237943E-01, 7.2875807884E-01, 7.0311697536E-01],
	[1.4750000000E+04, 7.6799918089E+00, 4.9446695326E+00, 9.6286179520E-01, 7.2938550185E-01, 7.0326315759E-01],
	[1.4755000000E+04, 7.6835238738E+00, 4.9443592650E+00, 9.6391199961E-01, 7.3001311995E-01, 7.0340928983E-01],
	[1.4760000000E+04, 7.6870563656E+00, 4.9440491221E+00, 9.6496299298E-01, 7.3064093292E-01, 7.0355537207E-01],
	[1.4765000000E+04, 7.6905892842E+00, 4.9437391036E+00, 9.6601477563E-01, 7.3126894052E-01, 7.0370140428E-01],
	[1.4770000000E+04, 7.6941226295E+00, 4.9434292095E+00, 9.6706734789E-01, 7.3189714252E-01, 7.0384738648E-01],
	[1.4775000000E+04, 7.6976564014E+00, 4.9431194397E+00, 9.6812071008E-01, 7.3252553870E-01, 7.0399331863E-01],
	[1.4780000000E+04, 7.7011905999E+00, 4.9428097942E+00, 9.6917486252E-01, 7.3315412882E-01, 7.0413920073E-01],
	[1.4785000000E+04, 7.7047252247E+00, 4.9425002727E+00, 9.7022980556E-01, 7.3378291266E-01, 7.0428503278E-01],
	[1.4790000000E+04, 7.7082602759E+00, 4.9421908753E+00, 9.7128553950E-01, 7.3441188998E-01, 7.0443081475E-01],
	[1.4795000000E+04, 7.7117957533E+00, 4.9418816018E+00, 9.7234206467E-01, 7.3504106056E-01, 7.0457654664E-01],
	[1.4800000000E+04, 7.7153316569E+00, 4.9415724522E+00, 9.7339938140E-01, 7.3567042416E-01, 7.0472222844E-01],
	[1.4805000000E+04, 7.7188679865E+00, 4.9412634263E+00, 9.7445749002E-01, 7.3629998056E-01, 7.0486786014E-01],
	[1.4810000000E+04, 7.7224047421E+00, 4.9409545241E+00, 9.7551639084E-01, 7.3692972952E-01, 7.0501344172E-01],
	[1.4815000000E+04, 7.7259528364E+00, 4.9406500518E+00, 9.7657608420E-01, 7.3755986624E-01, 7.0515897318E-01],
	[1.4820000000E+04, 7.7295069655E+00, 4.9403479107E+00, 9.7763657042E-01, 7.3819029602E-01, 7.0530445451E-01],
	[1.4825000000E+04, 7.7330615298E+00, 4.9400458900E+00, 9.7869784983E-01, 7.3882091846E-01, 7.0544988569E-01],
	[1.4830000000E+04, 7.7366165293E+00, 4.9397439896E+00, 9.7975992274E-01, 7.3945173334E-01, 7.0559526672E-01],
	[1.4835000000E+04, 7.7401719639E+00, 4.9394422094E+00, 9.8082278949E-01, 7.4008274042E-01, 7.0574059758E-01],
	[1.4840000000E+04, 7.7437278334E+00, 4.9391405493E+00, 9.8188645040E-01, 7.4071393948E-01, 7.0588587827E-01],
	[1.4845000000E+04, 7.7472841379E+00, 4.9388390093E+00, 9.8295090580E-01, 7.4134533027E-01, 7.0603110877E-01],
	[1.4850000000E+04, 7.7508408771E+00, 4.9385375892E+00, 9.8401615601E-01, 7.4197691258E-01, 7.0617628908E-01],
	[1.4855000000E+04, 7.7543980511E+00, 4.9382362890E+00, 9.8508220136E-01, 7.4260868617E-01, 7.0632141919E-01],
	[1.4860000000E+04, 7.7579556596E+00, 4.9379351085E+00, 9.8614904217E-01, 7.4324065081E-01, 7.0646649908E-01],
	[1.4865000000E+04, 7.7615137027E+00, 4.9376340477E+00, 9.8721667877E-01, 7.4387280627E-01, 7.0661152874E-01],
	[1.4870000000E+04, 7.7650721802E+00, 4.9373331065E+00, 9.8828511148E-01, 7.4450515231E-01, 7.0675650817E-01],
	[1.4875000000E+04, 7.7686310920E+00, 4.9370322848E+00, 9.8935434063E-01, 7.4513768872E-01, 7.0690143734E-01],
	[1.4880000000E+04, 7.7721904381E+00, 4.9367315826E+00, 9.9042436654E-01, 7.4577041525E-01, 7.0704631625E-01],
	[1.4885000000E+04, 7.7757502183E+00, 4.9364309996E+00, 9.9149518955E-01, 7.4640333168E-01, 7.0719114488E-01],
	[1.4890000000E+04, 7.7793104325E+00, 4.9361305359E+00, 9.9256680997E-01, 7.4703643777E-01, 7.0733592322E-01],
	[1.4895000000E+04, 7.7828710807E+00, 4.9358301914E+00, 9.9363922814E-01, 7.4766973329E-01, 7.0748065126E-01],
	[1.4900000000E+04, 7.7864321628E+00, 4.9355299659E+00, 9.9471244437E-01, 7.4830321801E-01, 7.0762532899E-01],
	[1.4905000000E+04, 7.7899936787E+00, 4.9352298594E+00, 9.9578645899E-01, 7.4893689171E-01, 7.0776995639E-01],
	[1.4910000000E+04, 7.7935556282E+00, 4.9349298719E+00, 9.9686127233E-01, 7.4957075413E-01, 7.0791453345E-01],
	[1.4915000000E+04, 7.7971180113E+00, 4.9346300031E+00, 9.9793688472E-01, 7.5020480507E-01, 7.0805906016E-01],
	[1.4920000000E+04, 7.8006808279E+00, 4.9343302530E+00, 9.9901329648E-01, 7.5083904427E-01, 7.0820353651E-01],
	[1.4925000000E+04, 7.8042440779E+00, 4.9340306216E+00, 1.0000905079E+00, 7.5147347151E-01, 7.0834796249E-01],
	[1.4930000000E+04, 7.8078077613E+00, 4.9337311087E+00, 1.0011685194E+00, 7.5210808657E-01, 7.0849233808E-01],
	[1.4935000000E+04, 7.8113718778E+00, 4.9334317143E+00, 1.0022473312E+00, 7.5274288920E-01, 7.0863666327E-01],
	[1.4940000000E+04, 7.8149364275E+00, 4.9331324383E+00, 1.0033269437E+00, 7.5337787917E-01, 7.0878093806E-01],
	[1.4945000000E+04, 7.8185014102E+00, 4.9328332805E+00, 1.0044073572E+00, 7.5401305625E-01, 7.0892516242E-01],
	[1.4950000000E+04, 7.8220668258E+00, 4.9325342410E+00, 1.0054885720E+00, 7.5464842020E-01, 7.0906933635E-01],
	[1.4955000000E+04, 7.8256326743E+00, 4.9322353195E+00, 1.0065705885E+00, 7.5528397081E-01, 7.0921345984E-01],
	[1.4960000000E+04, 7.8291989556E+00, 4.9319365161E+00, 1.0076534070E+00, 7.5591970782E-01, 7.0935753288E-01],
	[1.4965000000E+04, 7.8327656695E+00, 4.9316378307E+00, 1.0087370277E+00, 7.5655563101E-01, 7.0950155544E-01],
	[1.4970000000E+04, 7.8363328160E+00, 4.9313392630E+00, 1.0098214511E+00, 7.5719174015E-01, 7.0964552753E-01],
	[1.4975000000E+04, 7.8399003949E+00, 4.9310408132E+00, 1.0109066774E+00, 7.5782803500E-01, 7.0978944913E-01],
	[1.4980000000E+04, 7.8434684063E+00, 4.9307424811E+00, 1.0119927070E+00, 7.5846451532E-01, 7.0993332023E-01],
	[1.4985000000E+04, 7.8470368499E+00, 4.9304442665E+00, 1.0130795403E+00, 7.5910118090E-01, 7.1007714081E-01],
	[1.4990000000E+04, 7.8506057258E+00, 4.9301461695E+00, 1.0141671774E+00, 7.5973803148E-01, 7.1022091088E-01],
	[1.4995000000E+04, 7.8541750337E+00, 4.9298481899E+00, 1.0152556188E+00, 7.6037506684E-01, 7.1036463041E-01],
	[1.5000000000E+04, 7.8577447737E+00, 4.9295503276E+00, 1.0163448648E+00, 7.6101228674E-01, 7.1050829940E-01],
	[1.5005000000E+04, 7.8613149456E+00, 4.9292525826E+00, 1.0174377817E+00, 7.6165129705E-01, 7.1065191783E-01],
	[1.5010000000E+04, 7.8648855494E+00, 4.9289549548E+00, 1.0185315091E+00, 7.6229049283E-01, 7.1079548569E-01],
	[1.5015000000E+04, 7.8684565849E+00, 4.9286574441E+00, 1.0196260472E+00, 7.6292987385E-01, 7.1093900298E-01],
	[1.5020000000E+04, 7.8720280520E+00, 4.9283600504E+00, 1.0207213963E+00, 7.6356943986E-01, 7.1108246968E-01],
	[1.5025000000E+04, 7.8755999507E+00, 4.9280627735E+00, 1.0218175569E+00, 7.6420919063E-01, 7.1122588578E-01],
	[1.5030000000E+04, 7.8791722809E+00, 4.9277656136E+00, 1.0229145292E+00, 7.6484912593E-01, 7.1136925127E-01],
	[1.5035000000E+04, 7.8827450425E+00, 4.9274685703E+00, 1.0240123137E+00, 7.6548924551E-01, 7.1151256614E-01],
	[1.5040000000E+04, 7.8863182353E+00, 4.9271716438E+00, 1.0251109105E+00, 7.6612954915E-01, 7.1165583038E-01],
	[1.5045000000E+04, 7.8898918594E+00, 4.9268748338E+00, 1.0262103200E+00, 7.6677003660E-01, 7.1179904398E-01],
	[1.5050000000E+04, 7.8934659145E+00, 4.9265781403E+00, 1.0273105426E+00, 7.6741070764E-01, 7.1194220693E-01],
	[1.5055000000E+04, 7.8970569589E+00, 4.9262877885E+00, 1.0284115786E+00, 7.6805186996E-01, 7.1208531922E-01],
	[1.5060000000E+04, 7.9006489349E+00, 4.9259977347E+00, 1.0295134284E+00, 7.6869322534E-01, 7.1222838084E-01],
	[1.5065000000E+04, 7.9042413514E+00, 4.9257077943E+00, 1.0306160922E+00, 7.6933476441E-01, 7.1237139178E-01],
	[1.5070000000E+04, 7.9078342085E+00, 4.9254179672E+00, 1.0317195704E+00, 7.6997648694E-01, 7.1251435202E-01],
	[1.5075000000E+04, 7.9114275061E+00, 4.9251282532E+00, 1.0328238633E+00, 7.7061839269E-01, 7.1265726156E-01],
	[1.5080000000E+04, 7.9150212440E+00, 4.9248386524E+00, 1.0339289712E+00, 7.7126048143E-01, 7.1280012039E-01],
	[1.5085000000E+04, 7.9186154222E+00, 4.9245491646E+00, 1.0350348946E+00, 7.7190275292E-01, 7.1294292850E-01],
	[1.5090000000E+04, 7.9222100406E+00, 4.9242597897E+00, 1.0361416336E+00, 7.7254520693E-01, 7.1308568588E-01],
	[1.5095000000E+04, 7.9258050991E+00, 4.9239705277E+00, 1.0372491888E+00, 7.7318784322E-01, 7.1322839251E-01],
	[1.5100000000E+04, 7.9294005975E+00, 4.9236813785E+00, 1.0383575602E+00, 7.7383066154E-01, 7.1337104839E-01],
	[1.5105000000E+04, 7.9329965359E+00, 4.9233923419E+00, 1.0394667484E+00, 7.7447366167E-01, 7.1351365352E-01],
	[1.5110000000E+04, 7.9365929141E+00, 4.9231034180E+00, 1.0405767537E+00, 7.7511684337E-01, 7.1365620787E-01],
	[1.5115000000E+04, 7.9401897320E+00, 4.9228146067E+00, 1.0416875763E+00, 7.7576020640E-01, 7.1379871144E-01],
	[1.5120000000E+04, 7.9437869895E+00, 4.9225259078E+00, 1.0427992166E+00, 7.7640375052E-01, 7.1394116422E-01],
	[1.5125000000E+04, 7.9473846865E+00, 4.9222373212E+00, 1.0439116749E+00, 7.7704747550E-01, 7.1408356620E-01],
	[1.5130000000E+04, 7.9509828230E+00, 4.9219488470E+00, 1.0450249516E+00, 7.7769138110E-01, 7.1422591737E-01],
	[1.5135000000E+04, 7.9545813989E+00, 4.9216604850E+00, 1.0461390470E+00, 7.7833546708E-01, 7.1436821772E-01],
	[1.5140000000E+04, 7.9581804140E+00, 4.9213722351E+00, 1.0472539614E+00, 7.7897973321E-01, 7.1451046725E-01],
	[1.5145000000E+04, 7.9617798683E+00, 4.9210840972E+00, 1.0483696951E+00, 7.7962417924E-01, 7.1465266594E-01],
	[1.5150000000E+04, 7.9653797616E+00, 4.9207960713E+00, 1.0494862486E+00, 7.8026880494E-01, 7.1479481378E-01],
	[1.5155000000E+04, 7.9689800940E+00, 4.9205081574E+00, 1.0506036220E+00, 7.8091361007E-01, 7.1493691077E-01],
	[1.5160000000E+04, 7.9725808652E+00, 4.9202203552E+00, 1.0517218159E+00, 7.8155859440E-01, 7.1507895689E-01],
	[1.5165000000E+04, 7.9761820753E+00, 4.9199326648E+00, 1.0528408304E+00, 7.8220375768E-01, 7.1522095214E-01],
	[1.5170000000E+04, 7.9797837240E+00, 4.9196450860E+00, 1.0539606659E+00, 7.8284909968E-01, 7.1536289651E-01],
	[1.5175000000E+04, 7.9833858114E+00, 4.9193576188E+00, 1.0550813227E+00, 7.8349462016E-01, 7.1550478999E-01],
	[1.5180000000E+04, 7.9869883373E+00, 4.9190702631E+00, 1.0562028013E+00, 7.8414031887E-01, 7.1564663256E-01],
	[1.5185000000E+04, 7.9905913017E+00, 4.9187830187E+00, 1.0573251018E+00, 7.8478619559E-01, 7.1578842423E-01],
	[1.5190000000E+04, 7.9941947044E+00, 4.9184958858E+00, 1.0584482247E+00, 7.8543225008E-01, 7.1593016498E-01],
	[1.5195000000E+04, 7.9977985454E+00, 4.9182088640E+00, 1.0595721702E+00, 7.8607848209E-01, 7.1607185481E-01],
	[1.5200000000E+04, 8.0014028245E+00, 4.9179219535E+00, 1.0606969388E+00, 7.8672489139E-01, 7.1621349369E-01],
	[1.5205000000E+04, 8.0050075417E+00, 4.9176351540E+00, 1.0618225306E+00, 7.8737147773E-01, 7.1635508164E-01],
	[1.5210000000E+04, 8.0086126969E+00, 4.9173484656E+00, 1.0629489462E+00, 7.8801824089E-01, 7.1649661863E-01],
	[1.5215000000E+04, 8.0122182900E+00, 4.9170618880E+00, 1.0640761857E+00, 7.8866518061E-01, 7.1663810466E-01],
	[1.5220000000E+04, 8.0158243209E+00, 4.9167754214E+00, 1.0652042496E+00, 7.8931229667E-01, 7.1677953973E-01],
	[1.5225000000E+04, 8.0194307895E+00, 4.9164890655E+00, 1.0663331381E+00, 7.8995958882E-01, 7.1692092381E-01],
	[1.5230000000E+04, 8.0230376957E+00, 4.9162028203E+00, 1.0674628516E+00, 7.9060705682E-01, 7.1706225691E-01],
	[1.5235000000E+04, 8.0266450394E+00, 4.9159166857E+00, 1.0685933904E+00, 7.9125470044E-01, 7.1720353902E-01],
	[1.5240000000E+04, 8.0302528206E+00, 4.9156306617E+00, 1.0697247549E+00, 7.9190251943E-01, 7.1734477012E-01],
	[1.5245000000E+04, 8.0338610392E+00, 4.9153447481E+00, 1.0708569454E+00, 7.9255051355E-01, 7.1748595022E-01],
	[1.5250000000E+04, 8.0374696950E+00, 4.9150589449E+00, 1.0719899622E+00, 7.9319868257E-01, 7.1762707929E-01],
	[1.5255000000E+04, 8.0410787880E+00, 4.9147732520E+00, 1.0731238056E+00, 7.9384702625E-01, 7.1776815734E-01],
	[1.5260000000E+04, 8.0446883180E+00, 4.9144876693E+00, 1.0742584760E+00, 7.9449554434E-01, 7.1790918436E-01],
	[1.5265000000E+04, 8.0482982851E+00, 4.9142021968E+00, 1.0753939737E+00, 7.9514423660E-01, 7.1805016033E-01],
	[1.5270000000E+04, 8.0519086890E+00, 4.9139168343E+00, 1.0765302991E+00, 7.9579310280E-01, 7.1819108525E-01],
	[1.5275000000E+04, 8.0555195298E+00, 4.9136315818E+00, 1.0776674524E+00, 7.9644214270E-01, 7.1833195912E-01],
	[1.5280000000E+04, 8.0591308072E+00, 4.9133464392E+00, 1.0788054341E+00, 7.9709135606E-01, 7.1847278192E-01],
	[1.5285000000E+04, 8.0627425213E+00, 4.9130614065E+00, 1.0799442444E+00, 7.9774074262E-01, 7.1861355364E-01],
	[1.5290000000E+04, 8.0663546720E+00, 4.9127764835E+00, 1.0810838836E+00, 7.9839030217E-01, 7.1875427429E-01],
	[1.5295000000E+04, 8.0699762368E+00, 4.9124949117E+00, 1.0822243522E+00, 7.9904020823E-01, 7.1889494385E-01],
	[1.5300000000E+04, 8.0736067396E+00, 4.9122165145E+00, 1.0833656504E+00, 7.9969045184E-01, 7.1903556231E-01],
	[1.5305000000E+04, 8.0772376887E+00, 4.9119382240E+00, 1.0845077786E+00, 8.0034086856E-01, 7.1917612967E-01],
	[1.5310000000E+04, 8.0808690839E+00, 4.9116600401E+00, 1.0856507370E+00, 8.0099145816E-01, 7.1931664591E-01],
	[1.5315000000E+04, 8.0845009252E+00, 4.9113819628E+00, 1.0867945261E+00, 8.0164222038E-01, 7.1945711104E-01],
	[1.5320000000E+04, 8.0881332124E+00, 4.9111039920E+00, 1.0879391462E+00, 8.0229315499E-01, 7.1959752505E-01],
	[1.5325000000E+04, 8.0917659455E+00, 4.9108261277E+00, 1.0890845975E+00, 8.0294426176E-01, 7.1973788792E-01],
	[1.5330000000E+04, 8.0953991244E+00, 4.9105483697E+00, 1.0902308805E+00, 8.0359554043E-01, 7.1987819965E-01],
	[1.5335000000E+04, 8.0990327490E+00, 4.9102707180E+00, 1.0913779955E+00, 8.0424699078E-01, 7.2001846024E-01],
	[1.5340000000E+04, 8.1026668191E+00, 4.9099931725E+00, 1.0925259427E+00, 8.0489861255E-01, 7.2015866967E-01],
	[1.5345000000E+04, 8.1063013348E+00, 4.9097157331E+00, 1.0936747225E+00, 8.0555040551E-01, 7.2029882794E-01],
	[1.5350000000E+04, 8.1099362959E+00, 4.9094383998E+00, 1.0948243353E+00, 8.0620236942E-01, 7.2043893504E-01],
	[1.5355000000E+04, 8.1135717024E+00, 4.9091611725E+00, 1.0959747814E+00, 8.0685450404E-01, 7.2057899096E-01],
	[1.5360000000E+04, 8.1172075540E+00, 4.9088840511E+00, 1.0971260611E+00, 8.0750680913E-01, 7.2071899571E-01],
	[1.5365000000E+04, 8.1208438509E+00, 4.9086070355E+00, 1.0982781748E+00, 8.0815928444E-01, 7.2085894926E-01],
	[1.5370000000E+04, 8.1244805927E+00, 4.9083301256E+00, 1.0994311228E+00, 8.0881192974E-01, 7.2099885163E-01],
	[1.5375000000E+04, 8.1281177796E+00, 4.9080533214E+00, 1.1005849053E+00, 8.0946474478E-01, 7.2113870278E-01],
	[1.5380000000E+04, 8.1317554113E+00, 4.9077766229E+00, 1.1017395228E+00, 8.1011772933E-01, 7.2127850274E-01],
	[1.5385000000E+04, 8.1353934878E+00, 4.9075000299E+00, 1.1028949756E+00, 8.1077088314E-01, 7.2141825147E-01],
	[1.5390000000E+04, 8.1390320090E+00, 4.9072235423E+00, 1.1040512641E+00, 8.1142420598E-01, 7.2155794898E-01],
	[1.5395000000E+04, 8.1426709749E+00, 4.9069471601E+00, 1.1052083884E+00, 8.1207769759E-01, 7.2169759527E-01],
	[1.5400000000E+04, 8.1463103852E+00, 4.9066708832E+00, 1.1063663491E+00, 8.1273135774E-01, 7.2183719032E-01],
	[1.5405000000E+04, 8.1499502399E+00, 4.9063947116E+00, 1.1075251463E+00, 8.1338518619E-01, 7.2197673413E-01],
	[1.5410000000E+04, 8.1535905390E+00, 4.9061186451E+00, 1.1086847805E+00, 8.1403918270E-01, 7.2211622669E-01],
	[1.5415000000E+04, 8.1572312824E+00, 4.9058426837E+00, 1.1098452520E+00, 8.1469334702E-01, 7.2225566800E-01],
	[1.5420000000E+04, 8.1608724699E+00, 4.9055668273E+00, 1.1110065610E+00, 8.1534767891E-01, 7.2239505805E-01],
	[1.5425000000E+04, 8.1645141015E+00, 4.9052910758E+00, 1.1121687081E+00, 8.1600217813E-01, 7.2253439683E-01],
	[1.5430000000E+04, 8.1681561770E+00, 4.9050154292E+00, 1.1133316933E+00, 8.1665684445E-01, 7.2267368434E-01],
	[1.5435000000E+04, 8.1717986964E+00, 4.9047398874E+00, 1.1144955172E+00, 8.1731167761E-01, 7.2281292057E-01],
	[1.5440000000E+04, 8.1754416597E+00, 4.9044644503E+00, 1.1156601801E+00, 8.1796667738E-01, 7.2295210552E-01],
	[1.5445000000E+04, 8.1790850666E+00, 4.9041891179E+00, 1.1168256822E+00, 8.1862184351E-01, 7.2309123918E-01],
	[1.5450000000E+04, 8.1827289172E+00, 4.9039138900E+00, 1.1179920239E+00, 8.1927717576E-01, 7.2323032154E-01],
	[1.5455000000E+04, 8.1863732113E+00, 4.9036387666E+00, 1.1191592055E+00, 8.1993267389E-01, 7.2336935260E-01],
	[1.5460000000E+04, 8.1900179488E+00, 4.9033637476E+00, 1.1203272275E+00, 8.2058833766E-01, 7.2350833235E-01],
	[1.5465000000E+04, 8.1936631297E+00, 4.9030888330E+00, 1.1214960900E+00, 8.2124416682E-01, 7.2364726079E-01],
	[1.5470000000E+04, 8.1973087538E+00, 4.9028140227E+00, 1.1226657934E+00, 8.2190016114E-01, 7.2378613791E-01],
	[1.5475000000E+04, 8.2009548211E+00, 4.9025393166E+00, 1.1238363382E+00, 8.2255632036E-01, 7.2392496371E-01],
	[1.5480000000E+04, 8.2046013315E+00, 4.9022647145E+00, 1.1250077245E+00, 8.2321264425E-01, 7.2406373817E-01],
	[1.5485000000E+04, 8.2082482849E+00, 4.9019902166E+00, 1.1261799528E+00, 8.2386913257E-01, 7.2420246130E-01],
	[1.5490000000E+04, 8.2118956812E+00, 4.9017158226E+00, 1.1273530233E+00, 8.2452578506E-01, 7.2434113309E-01],
	[1.5495000000E+04, 8.2155435203E+00, 4.9014415325E+00, 1.1285269364E+00, 8.2518260150E-01, 7.2447975353E-01],
	[1.5500000000E+04, 8.2191918021E+00, 4.9011673463E+00, 1.1297016925E+00, 8.2583958163E-01, 7.2461832262E-01],
	[1.5505000000E+04, 8.2228405266E+00, 4.9008932639E+00, 1.1308772918E+00, 8.2649672521E-01, 7.2475684036E-01],
	[1.5510000000E+04, 8.2264896936E+00, 4.9006192851E+00, 1.1320537347E+00, 8.2715403201E-01, 7.2489530673E-01],
	[1.5515000000E+04, 8.2301393030E+00, 4.9003454099E+00, 1.1332310216E+00, 8.2781150177E-01, 7.2503372173E-01],
	[1.5520000000E+04, 8.2337893549E+00, 4.9000716383E+00, 1.1344091527E+00, 8.2846913425E-01, 7.2517208536E-01],
	[1.5525000000E+04, 8.2374398490E+00, 4.8997979702E+00, 1.1355881284E+00, 8.2912692921E-01, 7.2531039761E-01],
	[1.5530000000E+04, 8.2410907853E+00, 4.8995244054E+00, 1.1367679490E+00, 8.2978488642E-01, 7.2544865853E-01],
	[1.5535000000E+04, 8.2447421637E+00, 4.8992509440E+00, 1.1379486149E+00, 8.3044300561E-01, 7.2558686811E-01],
	[1.5540000000E+04, 8.2483989276E+00, 4.8989793020E+00, 1.1391301264E+00, 8.3110138613E-01, 7.2572502637E-01],
	[1.5545000000E+04, 8.2520690829E+00, 4.8987122545E+00, 1.1403124839E+00, 8.3176018944E-01, 7.2586313328E-01],
	[1.5550000000E+04, 8.2557396901E+00, 4.8984453075E+00, 1.1414956875E+00, 8.3241915490E-01, 7.2600118884E-01],
	[1.5555000000E+04, 8.2594107492E+00, 4.8981784609E+00, 1.1426797378E+00, 8.3307828226E-01, 7.2613919305E-01],
	[1.5560000000E+04, 8.2630822601E+00, 4.8979117145E+00, 1.1438646351E+00, 8.3373757128E-01, 7.2627714588E-01],
	[1.5565000000E+04, 8.2667542227E+00, 4.8976450684E+00, 1.1450503795E+00, 8.3439702173E-01, 7.2641504734E-01],
	[1.5570000000E+04, 8.2704266369E+00, 4.8973785224E+00, 1.1462369716E+00, 8.3505663335E-01, 7.2655289741E-01],
	[1.5575000000E+04, 8.2740995025E+00, 4.8971120765E+00, 1.1474244116E+00, 8.3571640590E-01, 7.2669069610E-01],
	[1.5580000000E+04, 8.2777728196E+00, 4.8968457306E+00, 1.1486126999E+00, 8.3637633915E-01, 7.2682844338E-01],
	[1.5585000000E+04, 8.2814465881E+00, 4.8965794846E+00, 1.1498018367E+00, 8.3703643284E-01, 7.2696613925E-01],
	[1.5590000000E+04, 8.2851208078E+00, 4.8963133385E+00, 1.1509918225E+00, 8.3769668673E-01, 7.2710378371E-01],
	[1.5595000000E+04, 8.2887954786E+00, 4.8960472922E+00, 1.1521826576E+00, 8.3835710058E-01, 7.2724137674E-01],
	[1.5600000000E+04, 8.2924706005E+00, 4.8957813457E+00, 1.1533743422E+00, 8.3901767415E-01, 7.2737891834E-01],
	[1.5605000000E+04, 8.2961461733E+00, 4.8955154988E+00, 1.1545668768E+00, 8.3967840720E-01, 7.2751640851E-01],
	[1.5610000000E+04, 8.2998221971E+00, 4.8952497515E+00, 1.1557602616E+00, 8.4033929947E-01, 7.2765384722E-01],
	[1.5615000000E+04, 8.3034986716E+00, 4.8949841038E+00, 1.1569544971E+00, 8.4100035073E-01, 7.2779123448E-01],
	[1.5620000000E+04, 8.3071755969E+00, 4.8947185555E+00, 1.1581495834E+00, 8.4166156073E-01, 7.2792857028E-01],
	[1.5625000000E+04, 8.3108529727E+00, 4.8944531066E+00, 1.1593455211E+00, 8.4232292922E-01, 7.2806585461E-01],
	[1.5630000000E+04, 8.3145307991E+00, 4.8941877570E+00, 1.1605423103E+00, 8.4298445598E-01, 7.2820308746E-01],
	[1.5635000000E+04, 8.3182090760E+00, 4.8939225066E+00, 1.1617399514E+00, 8.4364614074E-01, 7.2834026883E-01],
	[1.5640000000E+04, 8.3218878032E+00, 4.8936573555E+00, 1.1629384449E+00, 8.4430798327E-01, 7.2847739870E-01],
	[1.5645000000E+04, 8.3255669806E+00, 4.8933923034E+00, 1.1641377909E+00, 8.4496998332E-01, 7.2861447707E-01],
	[1.5650000000E+04, 8.3292466082E+00, 4.8931273504E+00, 1.1653379898E+00, 8.4563214064E-01, 7.2875150394E-01],
	[1.5655000000E+04, 8.3329266859E+00, 4.8928624964E+00, 1.1665390420E+00, 8.4629445500E-01, 7.2888847930E-01],
	[1.5660000000E+04, 8.3366072136E+00, 4.8925977412E+00, 1.1677409478E+00, 8.4695692616E-01, 7.2902540313E-01],
	[1.5665000000E+04, 8.3402881912E+00, 4.8923330849E+00, 1.1689437076E+00, 8.4761955385E-01, 7.2916227543E-01],
	[1.5670000000E+04, 8.3439696186E+00, 4.8920685274E+00, 1.1701473216E+00, 8.4828233785E-01, 7.2929909620E-01],
	[1.5675000000E+04, 8.3476514958E+00, 4.8918040686E+00, 1.1713517902E+00, 8.4894527790E-01, 7.2943586543E-01],
	[1.5680000000E+04, 8.3513338225E+00, 4.8915397084E+00, 1.1725571137E+00, 8.4960837376E-01, 7.2957258311E-01],
	[1.5685000000E+04, 8.3550165989E+00, 4.8912754468E+00, 1.1737632925E+00, 8.5027162519E-01, 7.2970924924E-01],
	[1.5690000000E+04, 8.3586998247E+00, 4.8910112837E+00, 1.1749703269E+00, 8.5093503195E-01, 7.2984586380E-01],
	[1.5695000000E+04, 8.3623834999E+00, 4.8907472190E+00, 1.1761782172E+00, 8.5159859378E-01, 7.2998242679E-01],
	[1.5700000000E+04, 8.3660676243E+00, 4.8904832527E+00, 1.1773869638E+00, 8.5226231044E-01, 7.3011893821E-01],
	[1.5705000000E+04, 8.3697521980E+00, 4.8902193846E+00, 1.1785965670E+00, 8.5292618169E-01, 7.3025539804E-01],
	[1.5710000000E+04, 8.3734372208E+00, 4.8899556148E+00, 1.1798070272E+00, 8.5359020729E-01, 7.3039180629E-01],
	[1.5715000000E+04, 8.3771226925E+00, 4.8896919431E+00, 1.1810183446E+00, 8.5425438698E-01, 7.3052816294E-01],
	[1.5720000000E+04, 8.3808086133E+00, 4.8894283696E+00, 1.1822305196E+00, 8.5491872052E-01, 7.3066446799E-01],
	[1.5725000000E+04, 8.3844949828E+00, 4.8891648940E+00, 1.1834435525E+00, 8.5558320768E-01, 7.3080072143E-01],
	[1.5730000000E+04, 8.3881818012E+00, 4.8889015164E+00, 1.1846574438E+00, 8.5624784819E-01, 7.3093692326E-01],
	[1.5735000000E+04, 8.3918690682E+00, 4.8886382367E+00, 1.1858721936E+00, 8.5691264183E-01, 7.3107307347E-01],
	[1.5740000000E+04, 8.3955567837E+00, 4.8883750548E+00, 1.1870878024E+00, 8.5757758833E-01, 7.3120917205E-01],
	[1.5745000000E+04, 8.3992449478E+00, 4.8881119707E+00, 1.1883042704E+00, 8.5824268746E-01, 7.3134521899E-01],
	[1.5750000000E+04, 8.4029335603E+00, 4.8878489842E+00, 1.1895215980E+00, 8.5890793898E-01, 7.3148121430E-01],
	[1.5755000000E+04, 8.4066226211E+00, 4.8875860954E+00, 1.1907397856E+00, 8.5957334263E-01, 7.3161715796E-01],
	[1.5760000000E+04, 8.4103121301E+00, 4.8873233041E+00, 1.1919588335E+00, 8.6023889817E-01, 7.3175304998E-01],
	[1.5765000000E+04, 8.4140020873E+00, 4.8870606103E+00, 1.1931787420E+00, 8.6090460535E-01, 7.3188889033E-01],
	[1.5770000000E+04, 8.4176924925E+00, 4.8867980139E+00, 1.1943995114E+00, 8.6157046393E-01, 7.3202467902E-01],
	[1.5775000000E+04, 8.4213833457E+00, 4.8865355148E+00, 1.1956211421E+00, 8.6223647367E-01, 7.3216041605E-01],
	[1.5780000000E+04, 8.4250746468E+00, 4.8862731131E+00, 1.1968436344E+00, 8.6290263432E-01, 7.3229610139E-01],
	[1.5785000000E+04, 8.4287663956E+00, 4.8860108085E+00, 1.1980669887E+00, 8.6356894562E-01, 7.3243173506E-01],
	[1.5790000000E+04, 8.4324631008E+00, 4.8857501062E+00, 1.1992912052E+00, 8.6423550180E-01, 7.3256731705E-01],
	[1.5795000000E+04, 8.4361740599E+00, 4.8854941057E+00, 1.2005162844E+00, 8.6490249780E-01, 7.3270284734E-01],
	[1.5800000000E+04, 8.4398854768E+00, 4.8852381997E+00, 1.2017422265E+00, 8.6556964464E-01, 7.3283832593E-01],
	[1.5805000000E+04, 8.4435973514E+00, 4.8849823881E+00, 1.2029690319E+00, 8.6623694208E-01, 7.3297375283E-01],
	[1.5810000000E+04, 8.4473096836E+00, 4.8847266708E+00, 1.2041967009E+00, 8.6690438986E-01, 7.3310912801E-01],
	[1.5815000000E+04, 8.4510224734E+00, 4.8844710477E+00, 1.2054252339E+00, 8.6757198774E-01, 7.3324445148E-01],
	[1.5820000000E+04, 8.4547357206E+00, 4.8842155188E+00, 1.2066546311E+00, 8.6823973549E-01, 7.3337972324E-01],
	[1.5825000000E+04, 8.4584494252E+00, 4.8839600840E+00, 1.2078848930E+00, 8.6890763284E-01, 7.3351494327E-01],
	[1.5830000000E+04, 8.4621635871E+00, 4.8837047433E+00, 1.2091160198E+00, 8.6957567957E-01, 7.3365011157E-01],
	[1.5835000000E+04, 8.4658782061E+00, 4.8834494965E+00, 1.2103480119E+00, 8.7024387541E-01, 7.3378522813E-01],
	[1.5840000000E+04, 8.4695932823E+00, 4.8831943437E+00, 1.2115808697E+00, 8.7091222013E-01, 7.3392029296E-01],
	[1.5845000000E+04, 8.4733088154E+00, 4.8829392847E+00, 1.2128145934E+00, 8.7158071348E-01, 7.3405530605E-01],
	[1.5850000000E+04, 8.4770248055E+00, 4.8826843195E+00, 1.2140491834E+00, 8.7224935521E-01, 7.3419026738E-01],
	[1.5855000000E+04, 8.4807412524E+00, 4.8824294480E+00, 1.2152846400E+00, 8.7291814508E-01, 7.3432517696E-01],
	[1.5860000000E+04, 8.4844581560E+00, 4.8821746702E+00, 1.2165209636E+00, 8.7358708285E-01, 7.3446003478E-01],
	[1.5865000000E+04, 8.4881755163E+00, 4.8819199859E+00, 1.2177581545E+00, 8.7425616826E-01, 7.3459484084E-01],
	[1.5870000000E+04, 8.4918933332E+00, 4.8816653953E+00, 1.2189962131E+00, 8.7492540107E-01, 7.3472959513E-01],
	[1.5875000000E+04, 8.4956116066E+00, 4.8814108980E+00, 1.2202351396E+00, 8.7559478104E-01, 7.3486429765E-01],
	[1.5880000000E+04, 8.4993303363E+00, 4.8811564942E+00, 1.2214749344E+00, 8.7626430792E-01, 7.3499894839E-01],
	[1.5885000000E+04, 8.5030495224E+00, 4.8809021837E+00, 1.2227155978E+00, 8.7693398146E-01, 7.3513354734E-01],
	[1.5890000000E+04, 8.5067691647E+00, 4.8806479665E+00, 1.2239571302E+00, 8.7760380141E-01, 7.3526809451E-01],
	[1.5895000000E+04, 8.5104892631E+00, 4.8803938426E+00, 1.2251995319E+00, 8.7827376754E-01, 7.3540258989E-01],
	[1.5900000000E+04, 8.5142098176E+00, 4.8801398117E+00, 1.2264428033E+00, 8.7894387959E-01, 7.3553703347E-01],
	[1.5905000000E+04, 8.5179308280E+00, 4.8798858740E+00, 1.2276869446E+00, 8.7961413732E-01, 7.3567142525E-01],
	[1.5910000000E+04, 8.5216522943E+00, 4.8796320293E+00, 1.2289319563E+00, 8.8028454049E-01, 7.3580576523E-01],
	[1.5915000000E+04, 8.5253742163E+00, 4.8793782775E+00, 1.2301778385E+00, 8.8095508884E-01, 7.3594005340E-01],
	[1.5920000000E+04, 8.5290965941E+00, 4.8791246187E+00, 1.2314245918E+00, 8.8162578213E-01, 7.3607428975E-01],
	[1.5925000000E+04, 8.5328194275E+00, 4.8788710526E+00, 1.2326722164E+00, 8.8229662011E-01, 7.3620847429E-01],
	[1.5930000000E+04, 8.5365427163E+00, 4.8786175794E+00, 1.2339207127E+00, 8.8296760254E-01, 7.3634260701E-01],
	[1.5935000000E+04, 8.5402664607E+00, 4.8783641988E+00, 1.2351700809E+00, 8.8363872917E-01, 7.3647668790E-01],
	[1.5940000000E+04, 8.5439906603E+00, 4.8781109109E+00, 1.2364203214E+00, 8.8430999975E-01, 7.3661071696E-01],
	[1.5945000000E+04, 8.5477153152E+00, 4.8778577156E+00, 1.2376714346E+00, 8.8498141404E-01, 7.3674469418E-01],
	[1.5950000000E+04, 8.5514404253E+00, 4.8776046128E+00, 1.2389234208E+00, 8.8565297179E-01, 7.3687861957E-01],
	[1.5955000000E+04, 8.5551659905E+00, 4.8773516025E+00, 1.2401762803E+00, 8.8632467275E-01, 7.3701249312E-01],
	[1.5960000000E+04, 8.5588920107E+00, 4.8770986845E+00, 1.2414300135E+00, 8.8699651668E-01, 7.3714631483E-01],
	[1.5965000000E+04, 8.5626184858E+00, 4.8768458589E+00, 1.2426846207E+00, 8.8766850333E-01, 7.3728008468E-01],
	[1.5970000000E+04, 8.5663454157E+00, 4.8765931256E+00, 1.2439401022E+00, 8.8834063245E-01, 7.3741380268E-01],
	[1.5975000000E+04, 8.5700728003E+00, 4.8763404844E+00, 1.2451964584E+00, 8.8901290380E-01, 7.3754746883E-01],
	[1.5980000000E+04, 8.5738006396E+00, 4.8760879354E+00, 1.2464536896E+00, 8.8968531713E-01, 7.3768108312E-01],
	[1.5985000000E+04, 8.5775289334E+00, 4.8758354785E+00, 1.2477117961E+00, 8.9035787219E-01, 7.3781464554E-01],
	[1.5990000000E+04, 8.5812576818E+00, 4.8755831136E+00, 1.2489707783E+00, 8.9103056873E-01, 7.3794815610E-01],
	[1.5995000000E+04, 8.5849868845E+00, 4.8753308407E+00, 1.2502306365E+00, 8.9170340652E-01, 7.3808161478E-01],
	[1.6000000000E+04, 8.5887165415E+00, 4.8750786597E+00, 1.2514913710E+00, 8.9237638529E-01, 7.3821502159E-01],
	[1.6005000000E+04, 8.5924466527E+00, 4.8748265704E+00, 1.2527529822E+00, 8.9304950481E-01, 7.3834837653E-01],
	[1.6010000000E+04, 8.5961772181E+00, 4.8745745730E+00, 1.2540154705E+00, 8.9372276483E-01, 7.3848167959E-01],
	[1.6015000000E+04, 8.5999082375E+00, 4.8743226673E+00, 1.2552788360E+00, 8.9439616509E-01, 7.3861493076E-01],
	[1.6020000000E+04, 8.6036397108E+00, 4.8740708532E+00, 1.2565430793E+00, 8.9506970536E-01, 7.3874813004E-01],
	[1.6025000000E+04, 8.6073716380E+00, 4.8738191307E+00, 1.2578082006E+00, 8.9574338538E-01, 7.3888127744E-01],
	[1.6030000000E+04, 8.6111040190E+00, 4.8735674997E+00, 1.2590742002E+00, 8.9641720491E-01, 7.3901437294E-01],
	[1.6035000000E+04, 8.6148368538E+00, 4.8733159602E+00, 1.2603410785E+00, 8.9709116370E-01, 7.3914741655E-01],
	[1.6040000000E+04, 8.6185701421E+00, 4.8730645121E+00, 1.2616088359E+00, 8.9776526150E-01, 7.3928040826E-01],
	[1.6045000000E+04, 8.6223115801E+00, 4.8728156260E+00, 1.2628774726E+00, 8.9843966562E-01, 7.3941334806E-01],
	[1.6050000000E+04, 8.6260645208E+00, 4.8725703741E+00, 1.2641469890E+00, 8.9911444932E-01, 7.3954623596E-01],
	[1.6055000000E+04, 8.6298179253E+00, 4.8723252110E+00, 1.2654173855E+00, 8.9978937223E-01, 7.3967907196E-01],
	[1.6060000000E+04, 8.6335717935E+00, 4.8720801365E+00, 1.2666886623E+00, 9.0046443410E-01, 7.3981185604E-01],
	[1.6065000000E+04, 8.6373261253E+00, 4.8718351507E+00, 1.2679608198E+00, 9.0113963469E-01, 7.3994458821E-01],
	[1.6070000000E+04, 8.6410809206E+00, 4.8715902534E+00, 1.2692338584E+00, 9.0181497376E-01, 7.4007726847E-01],
	[1.6075000000E+04, 8.6448361794E+00, 4.8713454446E+00, 1.2705077783E+00, 9.0249045105E-01, 7.4020989681E-01],
	[1.6080000000E+04, 8.6485919015E+00, 4.8711007242E+00, 1.2717825799E+00, 9.0316606632E-01, 7.4034247322E-01],
	[1.6085000000E+04, 8.6523480869E+00, 4.8708560922E+00, 1.2730582636E+00, 9.0384181933E-01, 7.4047499772E-01],
	[1.6090000000E+04, 8.6561047354E+00, 4.8706115485E+00, 1.2743348297E+00, 9.0451770982E-01, 7.4060747028E-01],
	[1.6095000000E+04, 8.6598618470E+00, 4.8703670930E+00, 1.2756122785E+00, 9.0519373754E-01, 7.4073989092E-01],
	[1.6100000000E+04, 8.6636194216E+00, 4.8701227258E+00, 1.2768906103E+00, 9.0586990226E-01, 7.4087225963E-01],
	[1.6105000000E+04, 8.6673774592E+00, 4.8698784467E+00, 1.2781698255E+00, 9.0654620372E-01, 7.4100457641E-01],
	[1.6110000000E+04, 8.6711359595E+00, 4.8696342556E+00, 1.2794499245E+00, 9.0722264168E-01, 7.4113684125E-01],
	[1.6115000000E+04, 8.6748949226E+00, 4.8693901526E+00, 1.2807309075E+00, 9.0789921589E-01, 7.4126905415E-01],
	[1.6120000000E+04, 8.6786543483E+00, 4.8691461375E+00, 1.2820127749E+00, 9.0857592610E-01, 7.4140121512E-01],
	[1.6125000000E+04, 8.6824142366E+00, 4.8689022104E+00, 1.2832955270E+00, 9.0925277206E-01, 7.4153332414E-01],
	[1.6130000000E+04, 8.6861745874E+00, 4.8686583710E+00, 1.2845791642E+00, 9.0992975353E-01, 7.4166538122E-01],
	[1.6135000000E+04, 8.6899354006E+00, 4.8684146195E+00, 1.2858636868E+00, 9.1060687026E-01, 7.4179738635E-01],
	[1.6140000000E+04, 8.6936966761E+00, 4.8681709556E+00, 1.2871490952E+00, 9.1128412201E-01, 7.4192933954E-01],
	[1.6145000000E+04, 8.6974584138E+00, 4.8679273795E+00, 1.2884353896E+00, 9.1196150852E-01, 7.4206124077E-01],
	[1.6150000000E+04, 8.7012206136E+00, 4.8676838909E+00, 1.2897225705E+00, 9.1263902955E-01, 7.4219309006E-01],
	[1.6155000000E+04, 8.7049832755E+00, 4.8674404899E+00, 1.2910106381E+00, 9.1331668485E-01, 7.4232488739E-01],
	[1.6160000000E+04, 8.7087463993E+00, 4.8671971763E+00, 1.2922995927E+00, 9.1399447417E-01, 7.4245663277E-01],
	[1.6165000000E+04, 8.7125099850E+00, 4.8669539502E+00, 1.2935894348E+00, 9.1467239727E-01, 7.4258832619E-01],
	[1.6170000000E+04, 8.7162740325E+00, 4.8667108115E+00, 1.2948801647E+00, 9.1535045389E-01, 7.4271996765E-01],
	[1.6175000000E+04, 8.7200385417E+00, 4.8664677601E+00, 1.2961717826E+00, 9.1602864380E-01, 7.4285155715E-01],
	[1.6180000000E+04, 8.7238035125E+00, 4.8662247959E+00, 1.2974642890E+00, 9.1670696674E-01, 7.4298309469E-01],
	[1.6185000000E+04, 8.7275689449E+00, 4.8659819189E+00, 1.2987576841E+00, 9.1738542246E-01, 7.4311458027E-01],
	[1.6190000000E+04, 8.7313348386E+00, 4.8657391291E+00, 1.3000519683E+00, 9.1806401072E-01, 7.4324601389E-01],
	[1.6195000000E+04, 8.7351011938E+00, 4.8654964263E+00, 1.3013471420E+00, 9.1874273128E-01, 7.4337739553E-01],
	[1.6200000000E+04, 8.7388680102E+00, 4.8652538106E+00, 1.3026432054E+00, 9.1942158387E-01, 7.4350872521E-01],
	[1.6205000000E+04, 8.7426352878E+00, 4.8650112818E+00, 1.3039401590E+00, 9.2010056826E-01, 7.4364000293E-01],
	[1.6210000000E+04, 8.7464030265E+00, 4.8647688399E+00, 1.3052380030E+00, 9.2077968419E-01, 7.4377122867E-01],
	[1.6215000000E+04, 8.7501712262E+00, 4.8645264849E+00, 1.3065367378E+00, 9.2145893142E-01, 7.4390240244E-01],
	[1.6220000000E+04, 8.7539398868E+00, 4.8642842166E+00, 1.3078363637E+00, 9.2213830971E-01, 7.4403352424E-01],
	[1.6225000000E+04, 8.7577090083E+00, 4.8640420351E+00, 1.3091368810E+00, 9.2281781879E-01, 7.4416459406E-01],
	[1.6230000000E+04, 8.7614785905E+00, 4.8637999403E+00, 1.3104382901E+00, 9.2349745843E-01, 7.4429561191E-01],
	[1.6235000000E+04, 8.7652486334E+00, 4.8635579321E+00, 1.3117405914E+00, 9.2417722838E-01, 7.4442657779E-01],
	[1.6240000000E+04, 8.7690191369E+00, 4.8633160104E+00, 1.3130437851E+00, 9.2485712839E-01, 7.4455749169E-01],
	[1.6245000000E+04, 8.7727901009E+00, 4.8630741752E+00, 1.3143478717E+00, 9.2553715821E-01, 7.4468835361E-01],
	[1.6250000000E+04, 8.7765615253E+00, 4.8628324265E+00, 1.3156528513E+00, 9.2621731759E-01, 7.4481916356E-01],
	[1.6255000000E+04, 8.7803334100E+00, 4.8625907642E+00, 1.3169587245E+00, 9.2689760628E-01, 7.4494992152E-01],
	[1.6260000000E+04, 8.7841057550E+00, 4.8623491882E+00, 1.3182654914E+00, 9.2757802404E-01, 7.4508062751E-01],
	[1.6265000000E+04, 8.7878785601E+00, 4.8621076984E+00, 1.3195731525E+00, 9.2825857062E-01, 7.4521128151E-01],
	[1.6270000000E+04, 8.7916518253E+00, 4.8618662949E+00, 1.3208817081E+00, 9.2893924578E-01, 7.4534188353E-01],
	[1.6275000000E+04, 8.7954255505E+00, 4.8616249775E+00, 1.3221911585E+00, 9.2962004925E-01, 7.4547243357E-01],
	[1.6280000000E+04, 8.7991997356E+00, 4.8613837462E+00, 1.3235015040E+00, 9.3030098080E-01, 7.4560293163E-01],
	[1.6285000000E+04, 8.8029743805E+00, 4.8611426010E+00, 1.3248127451E+00, 9.3098204017E-01, 7.4573337771E-01],
	[1.6290000000E+04, 8.8067494851E+00, 4.8609015418E+00, 1.3261248819E+00, 9.3166322712E-01, 7.4586377180E-01],
	[1.6295000000E+04, 8.8105250494E+00, 4.8606605684E+00, 1.3274379150E+00, 9.3234454140E-01, 7.4599411391E-01],
	[1.6300000000E+04, 8.8143010733E+00, 4.8604196810E+00, 1.3287518445E+00, 9.3302598276E-01, 7.4612440403E-01],
	[1.6305000000E+04, 8.8180920686E+00, 4.8601833603E+00, 1.3300666709E+00, 9.3370787904E-01, 7.4625464217E-01],
	[1.6310000000E+04, 8.8218881961E+00, 4.8599485633E+00, 1.3313823944E+00, 9.3439000819E-01, 7.4638482833E-01],
	[1.6315000000E+04, 8.8256847934E+00, 4.8597138495E+00, 1.3326990155E+00, 9.3507226465E-01, 7.4651496249E-01],
	[1.6320000000E+04, 8.8294818606E+00, 4.8594792190E+00, 1.3340165344E+00, 9.3575464816E-01, 7.4664504468E-01],
	[1.6325000000E+04, 8.8332793975E+00, 4.8592446717E+00, 1.3353349515E+00, 9.3643715849E-01, 7.4677507487E-01],
	[1.6330000000E+04, 8.8370774040E+00, 4.8590102076E+00, 1.3366542671E+00, 9.3711979538E-01, 7.4690505309E-01],
	[1.6335000000E+04, 8.8408758800E+00, 4.8587758265E+00, 1.3379744816E+00, 9.3780255859E-01, 7.4703497931E-01],
	[1.6340000000E+04, 8.8446748256E+00, 4.8585415285E+00, 1.3392955952E+00, 9.3848544787E-01, 7.4716485355E-01],
	[1.6345000000E+04, 8.8484742405E+00, 4.8583073134E+00, 1.3406176084E+00, 9.3916846297E-01, 7.4729467581E-01],
	[1.6350000000E+04, 8.8522741246E+00, 4.8580731812E+00, 1.3419405215E+00, 9.3985160364E-01, 7.4742444607E-01],
	[1.6355000000E+04, 8.8560744780E+00, 4.8578391320E+00, 1.3432643348E+00, 9.4053486964E-01, 7.4755416436E-01],
	[1.6360000000E+04, 8.8598753005E+00, 4.8576051655E+00, 1.3445890486E+00, 9.4121826071E-01, 7.4768383065E-01],
	[1.6365000000E+04, 8.8636765921E+00, 4.8573712818E+00, 1.3459146633E+00, 9.4190177662E-01, 7.4781344496E-01],
	[1.6370000000E+04, 8.8674783526E+00, 4.8571374808E+00, 1.3472411792E+00, 9.4258541711E-01, 7.4794300729E-01],
	[1.6375000000E+04, 8.8712805819E+00, 4.8569037624E+00, 1.3485685967E+00, 9.4326918193E-01, 7.4807251763E-01],
	[1.6380000000E+04, 8.8750832801E+00, 4.8566701267E+00, 1.3498969161E+00, 9.4395307084E-01, 7.4820197599E-01],
	[1.6385000000E+04, 8.8788864469E+00, 4.8564365735E+00, 1.3512261377E+00, 9.4463708359E-01, 7.4833138236E-01],
	[1.6390000000E+04, 8.8826900823E+00, 4.8562031027E+00, 1.3525562618E+00, 9.4532121993E-01, 7.4846073675E-01],
	[1.6395000000E+04, 8.8864941863E+00, 4.8559697144E+00, 1.3538872889E+00, 9.4600547962E-01, 7.4859003915E-01],
	[1.6400000000E+04, 8.8902987587E+00, 4.8557364085E+00, 1.3552192192E+00, 9.4668986239E-01, 7.4871928958E-01],
	[1.6405000000E+04, 8.8941037994E+00, 4.8555031849E+00, 1.3565520531E+00, 9.4737436802E-01, 7.4884848802E-01],
	[1.6410000000E+04, 8.8979093085E+00, 4.8552700436E+00, 1.3578857909E+00, 9.4805899624E-01, 7.4897763448E-01],
	[1.6415000000E+04, 8.9017152857E+00, 4.8550369845E+00, 1.3592204329E+00, 9.4874374682E-01, 7.4910672896E-01],
	[1.6420000000E+04, 8.9055217309E+00, 4.8548040075E+00, 1.3605559796E+00, 9.4942861950E-01, 7.4923577146E-01],
	[1.6425000000E+04, 8.9093286443E+00, 4.8545711127E+00, 1.3618924311E+00, 9.5011361404E-01, 7.4936476198E-01],
	[1.6430000000E+04, 8.9131360255E+00, 4.8543382999E+00, 1.3632297879E+00, 9.5079873018E-01, 7.4949370052E-01],
	[1.6435000000E+04, 8.9169438746E+00, 4.8541055691E+00, 1.3645680504E+00, 9.5148396768E-01, 7.4962258708E-01],
	[1.6440000000E+04, 8.9207521914E+00, 4.8538729202E+00, 1.3659072187E+00, 9.5216932629E-01, 7.4975142167E-01],
	[1.6445000000E+04, 8.9245609759E+00, 4.8536403533E+00, 1.3672472934E+00, 9.5285480577E-01, 7.4988020428E-01],
	[1.6450000000E+04, 8.9283702280E+00, 4.8534078681E+00, 1.3685882746E+00, 9.5354040586E-01, 7.5000893491E-01],
	[1.6455000000E+04, 8.9321799476E+00, 4.8531754648E+00, 1.3699301628E+00, 9.5422612631E-01, 7.5013761357E-01],
	[1.6460000000E+04, 8.9359901346E+00, 4.8529431432E+00, 1.3712729583E+00, 9.5491196689E-01, 7.5026624026E-01],
	[1.6465000000E+04, 8.9398007889E+00, 4.8527109033E+00, 1.3726166614E+00, 9.5559792734E-01, 7.5039481498E-01],
	[1.6470000000E+04, 8.9436119105E+00, 4.8524787449E+00, 1.3739612725E+00, 9.5628400741E-01, 7.5052333773E-01],
	[1.6475000000E+04, 8.9474234993E+00, 4.8522466682E+00, 1.3753067919E+00, 9.5697020685E-01, 7.5065180851E-01],
	[1.6480000000E+04, 8.9512355551E+00, 4.8520146730E+00, 1.3766532199E+00, 9.5765652542E-01, 7.5078022731E-01],
	[1.6485000000E+04, 8.9550480779E+00, 4.8517827592E+00, 1.3780005568E+00, 9.5834296287E-01, 7.5090859416E-01],
	[1.6490000000E+04, 8.9588610677E+00, 4.8515509269E+00, 1.3793488031E+00, 9.5902951895E-01, 7.5103690903E-01],
	[1.6495000000E+04, 8.9626745243E+00, 4.8513191759E+00, 1.3806979591E+00, 9.5971619341E-01, 7.5116517195E-01],
	[1.6500000000E+04, 8.9664884476E+00, 4.8510875062E+00, 1.3820480250E+00, 9.6040298600E-01, 7.5129338290E-01],
	[1.6505000000E+04, 8.9703028375E+00, 4.8508559178E+00, 1.3833990013E+00, 9.6108989648E-01, 7.5142154189E-01],
	[1.6510000000E+04, 8.9741176941E+00, 4.8506244105E+00, 1.3847508882E+00, 9.6177692459E-01, 7.5154964892E-01],
	[1.6515000000E+04, 8.9779330171E+00, 4.8503929844E+00, 1.3861036861E+00, 9.6246407010E-01, 7.5167770399E-01],
	[1.6520000000E+04, 8.9817488065E+00, 4.8501616394E+00, 1.3874573954E+00, 9.6315133274E-01, 7.5180570710E-01],
	[1.6525000000E+04, 8.9855650623E+00, 4.8499303755E+00, 1.3888120163E+00, 9.6383871228E-01, 7.5193365827E-01],
	[1.6530000000E+04, 8.9893817843E+00, 4.8496991925E+00, 1.3901675492E+00, 9.6452620846E-01, 7.5206155747E-01],
	[1.6535000000E+04, 8.9931989724E+00, 4.8494680904E+00, 1.3915239945E+00, 9.6521382103E-01, 7.5218940473E-01],
	[1.6540000000E+04, 8.9970166266E+00, 4.8492370693E+00, 1.3928813525E+00, 9.6590154976E-01, 7.5231720004E-01],
	[1.6545000000E+04, 9.0008347468E+00, 4.8490061289E+00, 1.3942396235E+00, 9.6658939438E-01, 7.5244494339E-01],
	[1.6550000000E+04, 9.0046533329E+00, 4.8487752694E+00, 1.3955988079E+00, 9.6727735465E-01, 7.5257263481E-01],
	[1.6555000000E+04, 9.0084723848E+00, 4.8485444905E+00, 1.3969589060E+00, 9.6796543033E-01, 7.5270027427E-01],
	[1.6560000000E+04, 9.0122919025E+00, 4.8483137924E+00, 1.3983199181E+00, 9.6865362115E-01, 7.5282786180E-01],
	[1.6565000000E+04, 9.0161172080E+00, 4.8480847564E+00, 1.3996818446E+00, 9.6934205164E-01, 7.5295539739E-01],
	[1.6570000000E+04, 9.0199572791E+00, 4.8478600472E+00, 1.4010446858E+00, 9.7003093243E-01, 7.5308288104E-01],
	[1.6575000000E+04, 9.0237978264E+00, 4.8476354162E+00, 1.4024084421E+00, 9.7071992863E-01, 7.5321031275E-01],
	[1.6580000000E+04, 9.0276388498E+00, 4.8474108634E+00, 1.4037731137E+00, 9.7140903999E-01, 7.5333769253E-01],
	[1.6585000000E+04, 9.0314803493E+00, 4.8471863886E+00, 1.4051387011E+00, 9.7209826627E-01, 7.5346502038E-01],
	[1.6590000000E+04, 9.0353223248E+00, 4.8469619919E+00, 1.4065052046E+00, 9.7278760720E-01, 7.5359229629E-01],
	[1.6595000000E+04, 9.0391647761E+00, 4.8467376732E+00, 1.4078726244E+00, 9.7347706255E-01, 7.5371952028E-01],
	[1.6600000000E+04, 9.0430077033E+00, 4.8465134325E+00, 1.4092409610E+00, 9.7416663207E-01, 7.5384669235E-01],
	[1.6605000000E+04, 9.0468511061E+00, 4.8462892697E+00, 1.4106102147E+00, 9.7485631551E-01, 7.5397381249E-01],
	[1.6610000000E+04, 9.0506949846E+00, 4.8460651847E+00, 1.4119803858E+00, 9.7554611263E-01, 7.5410088071E-01],
	[1.6615000000E+04, 9.0545393387E+00, 4.8458411775E+00, 1.4133514747E+00, 9.7623602317E-01, 7.5422789702E-01],
	[1.6620000000E+04, 9.0583841682E+00, 4.8456172481E+00, 1.4147234816E+00, 9.7692604688E-01, 7.5435486141E-01],
	[1.6625000000E+04, 9.0622294731E+00, 4.8453933963E+00, 1.4160964070E+00, 9.7761618353E-01, 7.5448177389E-01],
	[1.6630000000E+04, 9.0660752533E+00, 4.8451696222E+00, 1.4174702512E+00, 9.7830643286E-01, 7.5460863445E-01],
	[1.6635000000E+04, 9.0699215087E+00, 4.8449459258E+00, 1.4188450145E+00, 9.7899679463E-01, 7.5473544311E-01],
	[1.6640000000E+04, 9.0737682392E+00, 4.8447223068E+00, 1.4202206972E+00, 9.7968726858E-01, 7.5486219987E-01],
	[1.6645000000E+04, 9.0776154448E+00, 4.8444987654E+00, 1.4215972997E+00, 9.8037785447E-01, 7.5498890472E-01],
	[1.6650000000E+04, 9.0814631254E+00, 4.8442753014E+00, 1.4229748223E+00, 9.8106855206E-01, 7.5511555767E-01],
	[1.6655000000E+04, 9.0853112808E+00, 4.8440519148E+00, 1.4243532654E+00, 9.8175936109E-01, 7.5524215873E-01],
	[1.6660000000E+04, 9.0891599110E+00, 4.8438286056E+00, 1.4257326293E+00, 9.8245028131E-01, 7.5536870789E-01],
	[1.6665000000E+04, 9.0930090159E+00, 4.8436053737E+00, 1.4271129144E+00, 9.8314131248E-01, 7.5549520516E-01],
	[1.6670000000E+04, 9.0968585954E+00, 4.8433822190E+00, 1.4284941209E+00, 9.8383245436E-01, 7.5562165054E-01],
	[1.6675000000E+04, 9.1007086495E+00, 4.8431591415E+00, 1.4298762492E+00, 9.8452370669E-01, 7.5574804404E-01],
	[1.6680000000E+04, 9.1045591780E+00, 4.8429361412E+00, 1.4312592997E+00, 9.8521506922E-01, 7.5587438565E-01],
	[1.6685000000E+04, 9.1084101809E+00, 4.8427132179E+00, 1.4326432727E+00, 9.8590654171E-01, 7.5600067539E-01],
	[1.6690000000E+04, 9.1122616581E+00, 4.8424903718E+00, 1.4340281685E+00, 9.8659812392E-01, 7.5612691325E-01],
	[1.6695000000E+04, 9.1161136095E+00, 4.8422676026E+00, 1.4354139875E+00, 9.8728981558E-01, 7.5625309923E-01],
	[1.6700000000E+04, 9.1199660350E+00, 4.8420449103E+00, 1.4368007300E+00, 9.8798161646E-01, 7.5637923335E-01],
	[1.6705000000E+04, 9.1238189345E+00, 4.8418222950E+00, 1.4381883963E+00, 9.8867352631E-01, 7.5650531560E-01],
	[1.6710000000E+04, 9.1276723081E+00, 4.8415997565E+00, 1.4395769869E+00, 9.8936554487E-01, 7.5663134598E-01],
	[1.6715000000E+04, 9.1315261554E+00, 4.8413772948E+00, 1.4409665019E+00, 9.9005767191E-01, 7.5675732451E-01],
	[1.6720000000E+04, 9.1353804766E+00, 4.8411549099E+00, 1.4423569418E+00, 9.9074990718E-01, 7.5688325117E-01],
	[1.6725000000E+04, 9.1392352714E+00, 4.8409326017E+00, 1.4437483070E+00, 9.9144225042E-01, 7.5700912599E-01],
	[1.6730000000E+04, 9.1430905399E+00, 4.8407103701E+00, 1.4451405976E+00, 9.9213470138E-01, 7.5713494895E-01],
	[1.6735000000E+04, 9.1469462819E+00, 4.8404882152E+00, 1.4465338142E+00, 9.9282725983E-01, 7.5726072007E-01],
	[1.6740000000E+04, 9.1508024974E+00, 4.8402661368E+00, 1.4479279569E+00, 9.9351992552E-01, 7.5738643934E-01],
	[1.6745000000E+04, 9.1546591863E+00, 4.8400441349E+00, 1.4493230262E+00, 9.9421269818E-01, 7.5751210677E-01],
	[1.6750000000E+04, 9.1585163484E+00, 4.8398222094E+00, 1.4507190224E+00, 9.9490557759E-01, 7.5763772237E-01],
	[1.6755000000E+04, 9.1623739837E+00, 4.8396003604E+00, 1.4521159459E+00, 9.9559856349E-01, 7.5776328613E-01],
	[1.6760000000E+04, 9.1662320922E+00, 4.8393785877E+00, 1.4535137969E+00, 9.9629165563E-01, 7.5788879807E-01],
	[1.6765000000E+04, 9.1700906737E+00, 4.8391568913E+00, 1.4549125758E+00, 9.9698485376E-01, 7.5801425818E-01],
	[1.6770000000E+04, 9.1739497281E+00, 4.8389352712E+00, 1.4563122830E+00, 9.9767815764E-01, 7.5813966646E-01],
	[1.6775000000E+04, 9.1778092554E+00, 4.8387137273E+00, 1.4577129188E+00, 9.9837156702E-01, 7.5826502292E-01],
	[1.6780000000E+04, 9.1816692555E+00, 4.8384922596E+00, 1.4591144835E+00, 9.9906508166E-01, 7.5839032755E-01],
	[1.6785000000E+04, 9.1855297283E+00, 4.8382708680E+00, 1.4605169774E+00, 9.9975870129E-01, 7.5851558036E-01],
	[1.6790000000E+04, 9.1893906737E+00, 4.8380495524E+00, 1.4619204010E+00, 1.0004524257E+00, 7.5864078133E-01],
	[1.6795000000E+04, 9.1932520917E+00, 4.8378283129E+00, 1.4633247545E+00, 1.0011462546E+00, 7.5876593048E-01],
	[1.6800000000E+04, 9.1971139821E+00, 4.8376071493E+00, 1.4647300383E+00, 1.0018401878E+00, 7.5889102780E-01],
	[1.6805000000E+04, 9.2009763449E+00, 4.8373860616E+00, 1.4661362527E+00, 1.0025342249E+00, 7.5901607329E-01],
	[1.6810000000E+04, 9.2048391800E+00, 4.8371650499E+00, 1.4675433981E+00, 1.0032283659E+00, 7.5914106695E-01],
	[1.6815000000E+04, 9.2087024873E+00, 4.8369441139E+00, 1.4689514748E+00, 1.0039226103E+00, 7.5926600879E-01],
	[1.6820000000E+04, 9.2125662667E+00, 4.8367232537E+00, 1.4703604831E+00, 1.0046169581E+00, 7.5939089880E-01],
	[1.6825000000E+04, 9.2164305182E+00, 4.8365024692E+00, 1.4717704234E+00, 1.0053114088E+00, 7.5951573698E-01],
	[1.6830000000E+04, 9.2202952416E+00, 4.8362817604E+00, 1.4731812960E+00, 1.0060059624E+00, 7.5964052334E-01],
	[1.6835000000E+04, 9.2241793197E+00, 4.8360665262E+00, 1.4745931013E+00, 1.0067010773E+00, 7.5976525787E-01],
	[1.6840000000E+04, 9.2280650662E+00, 4.8358517044E+00, 1.4760058396E+00, 1.0073963243E+00, 7.5988994058E-01],
	[1.6845000000E+04, 9.2319512952E+00, 4.8356369560E+00, 1.4774195112E+00, 1.0080916744E+00, 7.6001457147E-01],
	[1.6850000000E+04, 9.2358380068E+00, 4.8354222808E+00, 1.4788341164E+00, 1.0087871273E+00, 7.6013915053E-01],
	[1.6855000000E+04, 9.2397252009E+00, 4.8352076789E+00, 1.4802496557E+00, 1.0094826827E+00, 7.6026367777E-01],
	[1.6860000000E+04, 9.2436128773E+00, 4.8349931501E+00, 1.4816661294E+00, 1.0101783405E+00, 7.6038815318E-01],
	[1.6865000000E+04, 9.2475010360E+00, 4.8347786945E+00, 1.4830835377E+00, 1.0108741003E+00, 7.6051257678E-01],
	[1.6870000000E+04, 9.2513896769E+00, 4.8345643119E+00, 1.4845018811E+00, 1.0115699620E+00, 7.6063694855E-01],
	[1.6875000000E+04, 9.2552787999E+00, 4.8343500024E+00, 1.4859211598E+00, 1.0122659252E+00, 7.6076126851E-01],
	[1.6880000000E+04, 9.2591684049E+00, 4.8341357658E+00, 1.4873413743E+00, 1.0129619898E+00, 7.6088553665E-01],
	[1.6885000000E+04, 9.2630584919E+00, 4.8339216022E+00, 1.4887625248E+00, 1.0136581554E+00, 7.6100975297E-01],
	[1.6890000000E+04, 9.2669490607E+00, 4.8337075115E+00, 1.4901846116E+00, 1.0143544219E+00, 7.6113391747E-01],
	[1.6895000000E+04, 9.2708401113E+00, 4.8334934936E+00, 1.4916076353E+00, 1.0150507890E+00, 7.6125803016E-01],
	[1.6900000000E+04, 9.2747316436E+00, 4.8332795485E+00, 1.4930315959E+00, 1.0157472564E+00, 7.6138209103E-01],
	[1.6905000000E+04, 9.2786236576E+00, 4.8330656762E+00, 1.4944564940E+00, 1.0164438239E+00, 7.6150610009E-01],
	[1.6910000000E+04, 9.2825161531E+00, 4.8328518766E+00, 1.4958823299E+00, 1.0171404913E+00, 7.6163005734E-01],
	[1.6915000000E+04, 9.2864091300E+00, 4.8326381496E+00, 1.4973091038E+00, 1.0178372582E+00, 7.6175396278E-01],
	[1.6920000000E+04, 9.2903025883E+00, 4.8324244953E+00, 1.4987368161E+00, 1.0185341245E+00, 7.6187781641E-01],
	[1.6925000000E+04, 9.2941965278E+00, 4.8322109135E+00, 1.5001654672E+00, 1.0192310900E+00, 7.6200161823E-01],
	[1.6930000000E+04, 9.2980909486E+00, 4.8319974042E+00, 1.5015950574E+00, 1.0199281543E+00, 7.6212536825E-01],
	[1.6935000000E+04, 9.3019858505E+00, 4.8317839675E+00, 1.5030255871E+00, 1.0206253172E+00, 7.6224906646E-01],
	[1.6940000000E+04, 9.3058812334E+00, 4.8315706031E+00, 1.5044570565E+00, 1.0213225784E+00, 7.6237271286E-01],
	[1.6945000000E+04, 9.3097770973E+00, 4.8313573112E+00, 1.5058894661E+00, 1.0220199378E+00, 7.6249630747E-01],
	[1.6950000000E+04, 9.3136734421E+00, 4.8311440915E+00, 1.5073228161E+00, 1.0227173951E+00, 7.6261985027E-01],
	[1.6955000000E+04, 9.3175702676E+00, 4.8309309442E+00, 1.5087571070E+00, 1.0234149500E+00, 7.6274334128E-01],
	[1.6960000000E+04, 9.3214675739E+00, 4.8307178691E+00, 1.5101923389E+00, 1.0241126023E+00, 7.6286678049E-01],
	[1.6965000000E+04, 9.3253653608E+00, 4.8305048663E+00, 1.5116285124E+00, 1.0248103517E+00, 7.6299016790E-01],
	[1.6970000000E+04, 9.3292636282E+00, 4.8302919356E+00, 1.5130656276E+00, 1.0255081980E+00, 7.6311350353E-01],
	[1.6975000000E+04, 9.3331623761E+00, 4.8300790769E+00, 1.5145036851E+00, 1.0262061410E+00, 7.6323678735E-01],
	[1.6980000000E+04, 9.3370616043E+00, 4.8298662904E+00, 1.5159426850E+00, 1.0269041803E+00, 7.6336001939E-01],
	[1.6985000000E+04, 9.3409613129E+00, 4.8296535759E+00, 1.5173826278E+00, 1.0276023158E+00, 7.6348319965E-01],
	[1.6990000000E+04, 9.3448615016E+00, 4.8294409333E+00, 1.5188235137E+00, 1.0283005472E+00, 7.6360632811E-01],
	[1.6995000000E+04, 9.3487621705E+00, 4.8292283627E+00, 1.5202653432E+00, 1.0289988743E+00, 7.6372940480E-01],
	[1.7000000000E+04, 9.3526633195E+00, 4.8290158639E+00, 1.5217081165E+00, 1.0296972968E+00, 7.6385242970E-01],
	[1.7005000000E+04, 9.3565649484E+00, 4.8288034370E+00, 1.5231518341E+00, 1.0303958144E+00, 7.6397540282E-01],
	[1.7010000000E+04, 9.3604670572E+00, 4.8285910819E+00, 1.5245964961E+00, 1.0310944269E+00, 7.6409832416E-01],
	[1.7015000000E+04, 9.3643696458E+00, 4.8283787986E+00, 1.5260421031E+00, 1.0317931342E+00, 7.6422119373E-01],
	[1.7020000000E+04, 9.3682727141E+00, 4.8281665869E+00, 1.5274886552E+00, 1.0324919358E+00, 7.6434401153E-01],
	[1.7025000000E+04, 9.3721762620E+00, 4.8279544469E+00, 1.5289361530E+00, 1.0331908316E+00, 7.6446677755E-01],
	[1.7030000000E+04, 9.3760802895E+00, 4.8277423785E+00, 1.5303845966E+00, 1.0338898214E+00, 7.6458949181E-01],
	[1.7035000000E+04, 9.3799847965E+00, 4.8275303816E+00, 1.5318339865E+00, 1.0345889048E+00, 7.6471215430E-01],
	[1.7040000000E+04, 9.3838897829E+00, 4.8273184563E+00, 1.5332843229E+00, 1.0352880817E+00, 7.6483476503E-01],
	[1.7045000000E+04, 9.3877952486E+00, 4.8271066025E+00, 1.5347356063E+00, 1.0359873518E+00, 7.6495732400E-01],
	[1.7050000000E+04, 9.3917011935E+00, 4.8268948201E+00, 1.5361878369E+00, 1.0366867148E+00, 7.6507983120E-01],
	[1.7055000000E+04, 9.3956076175E+00, 4.8266831090E+00, 1.5376410151E+00, 1.0373861706E+00, 7.6520228666E-01],
	[1.7060000000E+04, 9.3995145207E+00, 4.8264714693E+00, 1.5390951413E+00, 1.0380857187E+00, 7.6532469036E-01],
	[1.7065000000E+04, 9.4034219028E+00, 4.8262599009E+00, 1.5405502157E+00, 1.0387853591E+00, 7.6544704230E-01],
	[1.7070000000E+04, 9.4073297638E+00, 4.8260484038E+00, 1.5420062388E+00, 1.0394850915E+00, 7.6556934251E-01],
	[1.7075000000E+04, 9.4112381036E+00, 4.8258369779E+00, 1.5434632108E+00, 1.0401849155E+00, 7.6569159096E-01],
	[1.7080000000E+04, 9.4151469222E+00, 4.8256256231E+00, 1.5449211321E+00, 1.0408848311E+00, 7.6581378767E-01],
	[1.7085000000E+04, 9.4190562194E+00, 4.8254143394E+00, 1.5463800031E+00, 1.0415848378E+00, 7.6593593265E-01],
	[1.7090000000E+04, 9.4229659952E+00, 4.8252031268E+00, 1.5478398240E+00, 1.0422849356E+00, 7.6605802588E-01],
	[1.7095000000E+04, 9.4268762495E+00, 4.8249919853E+00, 1.5493005953E+00, 1.0429851240E+00, 7.6618006739E-01],
	[1.7100000000E+04, 9.4307869822E+00, 4.8247809147E+00, 1.5507623172E+00, 1.0436854030E+00, 7.6630205716E-01],
	[1.7105000000E+04, 9.4347136267E+00, 4.8245741631E+00, 1.5522249902E+00, 1.0443861604E+00, 7.6642399520E-01],
	[1.7110000000E+04, 9.4386458507E+00, 4.8243688819E+00, 1.5536886144E+00, 1.0450871367E+00, 7.6654588152E-01],
	[1.7115000000E+04, 9.4425785639E+00, 4.8241636694E+00, 1.5551531904E+00, 1.0457882039E+00, 7.6666771612E-01],
	[1.7120000000E+04, 9.4465117663E+00, 4.8239585256E+00, 1.5566187184E+00, 1.0464893615E+00, 7.6678949900E-01],
	[1.7125000000E+04, 9.4504454577E+00, 4.8237534504E+00, 1.5580851987E+00, 1.0471906095E+00, 7.6691123017E-01],
	[1.7130000000E+04, 9.4543796381E+00, 4.8235484438E+00, 1.5595526317E+00, 1.0478919476E+00, 7.6703290962E-01],
	[1.7135000000E+04, 9.4583143075E+00, 4.8233435057E+00, 1.5610210178E+00, 1.0485933755E+00, 7.6715453736E-01],
	[1.7140000000E+04, 9.4622494656E+00, 4.8231386361E+00, 1.5624903573E+00, 1.0492948929E+00, 7.6727611340E-01],
	[1.7145000000E+04, 9.4661851125E+00, 4.8229338350E+00, 1.5639606505E+00, 1.0499964997E+00, 7.6739763774E-01],
	[1.7150000000E+04, 9.4701212480E+00, 4.8227291023E+00, 1.5654318977E+00, 1.0506981955E+00, 7.6751911037E-01],
	[1.7155000000E+04, 9.4740578721E+00, 4.8225244379E+00, 1.5669040994E+00, 1.0513999802E+00, 7.6764053132E-01],
	[1.7160000000E+04, 9.4779949847E+00, 4.8223198419E+00, 1.5683772558E+00, 1.0521018535E+00, 7.6776190057E-01],
	[1.7165000000E+04, 9.4819325857E+00, 4.8221153142E+00, 1.5698513673E+00, 1.0528038151E+00, 7.6788321813E-01],
	[1.7170000000E+04, 9.4858706751E+00, 4.8219108547E+00, 1.5713264342E+00, 1.0535058648E+00, 7.6800448401E-01],
	[1.7175000000E+04, 9.4898092527E+00, 4.8217064633E+00, 1.5728024569E+00, 1.0542080024E+00, 7.6812569820E-01],
	[1.7180000000E+04, 9.4937483184E+00, 4.8215021402E+00, 1.5742794357E+00, 1.0549102276E+00, 7.6824686072E-01],
	[1.7185000000E+04, 9.4976878723E+00, 4.8212978852E+00, 1.5757573710E+00, 1.0556125401E+00, 7.6836797157E-01],
	[1.7190000000E+04, 9.5016279141E+00, 4.8210936982E+00, 1.5772362630E+00, 1.0563149398E+00, 7.6848903074E-01],
	[1.7195000000E+04, 9.5055684439E+00, 4.8208895792E+00, 1.5787161122E+00, 1.0570174263E+00, 7.6861003825E-01],
	[1.7200000000E+04, 9.5095094615E+00, 4.8206855283E+00, 1.5801969188E+00, 1.0577199995E+00, 7.6873099410E-01],
	[1.7205000000E+04, 9.5134509669E+00, 4.8204815453E+00, 1.5816786833E+00, 1.0584226591E+00, 7.6885189829E-01],
	[1.7210000000E+04, 9.5173929599E+00, 4.8202776301E+00, 1.5831614059E+00, 1.0591254048E+00, 7.6897275082E-01],
	[1.7215000000E+04, 9.5213354406E+00, 4.8200737829E+00, 1.5846450870E+00, 1.0598282364E+00, 7.6909355171E-01],
	[1.7220000000E+04, 9.5252784087E+00, 4.8198700034E+00, 1.5861297269E+00, 1.0605311536E+00, 7.6921430094E-01],
	[1.7225000000E+04, 9.5292218643E+00, 4.8196662917E+00, 1.5876153260E+00, 1.0612341562E+00, 7.6933499854E-01],
	[1.7230000000E+04, 9.5331658072E+00, 4.8194626478E+00, 1.5891018847E+00, 1.0619372441E+00, 7.6945564449E-01],
	[1.7235000000E+04, 9.5371102375E+00, 4.8192590715E+00, 1.5905894031E+00, 1.0626404168E+00, 7.6957623882E-01],
	[1.7240000000E+04, 9.5410551549E+00, 4.8190555629E+00, 1.5920778818E+00, 1.0633436742E+00, 7.6969678151E-01],
	[1.7245000000E+04, 9.5450005594E+00, 4.8188521219E+00, 1.5935673210E+00, 1.0640470160E+00, 7.6981727257E-01],
	[1.7250000000E+04, 9.5489464509E+00, 4.8186487485E+00, 1.5950577211E+00, 1.0647504420E+00, 7.6993771202E-01],
	[1.7255000000E+04, 9.5528928294E+00, 4.8184454425E+00, 1.5965490825E+00, 1.0654539520E+00, 7.7005809985E-01],
	[1.7260000000E+04, 9.5568396948E+00, 4.8182422041E+00, 1.5980414054E+00, 1.0661575456E+00, 7.7017843606E-01],
	[1.7265000000E+04, 9.5607870469E+00, 4.8180390331E+00, 1.5995346901E+00, 1.0668612227E+00, 7.7029872067E-01],
	[1.7270000000E+04, 9.5647348857E+00, 4.8178359295E+00, 1.6010289372E+00, 1.0675649830E+00, 7.7041895367E-01],
	[1.7275000000E+04, 9.5686832112E+00, 4.8176328932E+00, 1.6025241468E+00, 1.0682688263E+00, 7.7053913507E-01],
	[1.7280000000E+04, 9.5726320232E+00, 4.8174299242E+00, 1.6040203193E+00, 1.0689727522E+00, 7.7065926488E-01],
	[1.7285000000E+04, 9.5765813217E+00, 4.8172270225E+00, 1.6055174551E+00, 1.0696767607E+00, 7.7077934309E-01],
	[1.7290000000E+04, 9.5805311065E+00, 4.8170241881E+00, 1.6070155546E+00, 1.0703808513E+00, 7.7089936972E-01],
	[1.7295000000E+04, 9.5844813777E+00, 4.8168214208E+00, 1.6085146179E+00, 1.0710850240E+00, 7.7101934477E-01],
	[1.7300000000E+04, 9.5884321350E+00, 4.8166187207E+00, 1.6100146456E+00, 1.0717892784E+00, 7.7113926824E-01],
	[1.7305000000E+04, 9.5923833785E+00, 4.8164160876E+00, 1.6115156379E+00, 1.0724936143E+00, 7.7125914014E-01],
	[1.7310000000E+04, 9.5963351081E+00, 4.8162135217E+00, 1.6130175951E+00, 1.0731980314E+00, 7.7137896047E-01],
	[1.7315000000E+04, 9.6002873236E+00, 4.8160110227E+00, 1.6145205177E+00, 1.0739025296E+00, 7.7149872924E-01],
	[1.7320000000E+04, 9.6042400251E+00, 4.8158085907E+00, 1.6160244059E+00, 1.0746071085E+00, 7.7161844646E-01],
	[1.7325000000E+04, 9.6081932123E+00, 4.8156062257E+00, 1.6175292602E+00, 1.0753117679E+00, 7.7173811212E-01],
	[1.7330000000E+04, 9.6121468853E+00, 4.8154039275E+00, 1.6190350807E+00, 1.0760165076E+00, 7.7185772623E-01],
	[1.7335000000E+04, 9.6161010439E+00, 4.8152016962E+00, 1.6205418680E+00, 1.0767213273E+00, 7.7197728880E-01],
	[1.7340000000E+04, 9.6200556882E+00, 4.8149995318E+00, 1.6220496223E+00, 1.0774262268E+00, 7.7209679983E-01],
	[1.7345000000E+04, 9.6240108179E+00, 4.8147974340E+00, 1.6235583439E+00, 1.0781312059E+00, 7.7221625933E-01],
	[1.7350000000E+04, 9.6279664330E+00, 4.8145954031E+00, 1.6250680332E+00, 1.0788362643E+00, 7.7233566730E-01],
	[1.7355000000E+04, 9.6319225334E+00, 4.8143934388E+00, 1.6265786906E+00, 1.0795414017E+00, 7.7245502374E-01],
	[1.7360000000E+04, 9.6358791191E+00, 4.8141915411E+00, 1.6280903164E+00, 1.0802466179E+00, 7.7257432867E-01],
	[1.7365000000E+04, 9.6398361900E+00, 4.8139897101E+00, 1.6296029108E+00, 1.0809519127E+00, 7.7269358209E-01],
	[1.7370000000E+04, 9.6437937460E+00, 4.8137879456E+00, 1.6311164744E+00, 1.0816572858E+00, 7.7281278400E-01],
	[1.7375000000E+04, 9.6477517870E+00, 4.8135862476E+00, 1.6326310074E+00, 1.0823627370E+00, 7.7293193441E-01],
	[1.7380000000E+04, 9.6517248041E+00, 4.8133884575E+00, 1.6341465101E+00, 1.0830686430E+00, 7.7305103332E-01],
	[1.7385000000E+04, 9.6557048079E+00, 4.8131924531E+00, 1.6356629829E+00, 1.0837747963E+00, 7.7317008074E-01],
	[1.7390000000E+04, 9.6596853076E+00, 4.8129965130E+00, 1.6371804262E+00, 1.0844810281E+00, 7.7328907668E-01],
	[1.7395000000E+04, 9.6636663033E+00, 4.8128006372E+00, 1.6386988402E+00, 1.0851873381E+00, 7.7340802113E-01],
	[1.7400000000E+04, 9.6676477948E+00, 4.8126048257E+00, 1.6402182254E+00, 1.0858937260E+00, 7.7352691412E-01],
	[1.7405000000E+04, 9.6716297820E+00, 4.8124090784E+00, 1.6417385820E+00, 1.0866001916E+00, 7.7364575563E-01],
	[1.7410000000E+04, 9.6756122650E+00, 4.8122133953E+00, 1.6432599104E+00, 1.0873067346E+00, 7.7376454567E-01],
	[1.7415000000E+04, 9.6795952435E+00, 4.8120177763E+00, 1.6447822109E+00, 1.0880133549E+00, 7.7388328426E-01],
	[1.7420000000E+04, 9.6835787175E+00, 4.8118222214E+00, 1.6463054840E+00, 1.0887200521E+00, 7.7400197140E-01],
	[1.7425000000E+04, 9.6875626870E+00, 4.8116267306E+00, 1.6478297298E+00, 1.0894268261E+00, 7.7412060709E-01],
	[1.7430000000E+04, 9.6915471517E+00, 4.8114313039E+00, 1.6493549489E+00, 1.0901336765E+00, 7.7423919134E-01],
	[1.7435000000E+04, 9.6955321118E+00, 4.8112359411E+00, 1.6508811414E+00, 1.0908406031E+00, 7.7435772415E-01],
	[1.7440000000E+04, 9.6995175671E+00, 4.8110406422E+00, 1.6524083078E+00, 1.0915476058E+00, 7.7447620553E-01],
	[1.7445000000E+04, 9.7035035174E+00, 4.8108454073E+00, 1.6539364484E+00, 1.0922546842E+00, 7.7459463549E-01],
	[1.7450000000E+04, 9.7074899628E+00, 4.8106502362E+00, 1.6554655635E+00, 1.0929618381E+00, 7.7471301404E-01],
	[1.7455000000E+04, 9.7114769031E+00, 4.8104551290E+00, 1.6569956535E+00, 1.0936690672E+00, 7.7483134117E-01],
	[1.7460000000E+04, 9.7154643383E+00, 4.8102600856E+00, 1.6585267188E+00, 1.0943763714E+00, 7.7494961689E-01],
	[1.7465000000E+04, 9.7194522683E+00, 4.8100651059E+00, 1.6600587595E+00, 1.0950837504E+00, 7.7506784121E-01],
	[1.7470000000E+04, 9.7234406929E+00, 4.8098701899E+00, 1.6615917762E+00, 1.0957912039E+00, 7.7518601414E-01],
	[1.7475000000E+04, 9.7274296122E+00, 4.8096753376E+00, 1.6631257692E+00, 1.0964987317E+00, 7.7530413568E-01],
	[1.7480000000E+04, 9.7314190261E+00, 4.8094805489E+00, 1.6646607387E+00, 1.0972063336E+00, 7.7542220584E-01],
	[1.7485000000E+04, 9.7354089344E+00, 4.8092858238E+00, 1.6661966851E+00, 1.0979140093E+00, 7.7554022463E-01],
	[1.7490000000E+04, 9.7393993371E+00, 4.8090911623E+00, 1.6677336089E+00, 1.0986217585E+00, 7.7565819204E-01],
	[1.7495000000E+04, 9.7433902341E+00, 4.8088965643E+00, 1.6692715102E+00, 1.0993295811E+00, 7.7577610809E-01],
	[1.7500000000E+04, 9.7473816253E+00, 4.8087020298E+00, 1.6708103895E+00, 1.1000374767E+00, 7.7589397279E-01],
	[1.7505000000E+04, 9.7513735106E+00, 4.8085075587E+00, 1.6723616066E+00, 1.1007503665E+00, 7.7601178613E-01],
	[1.7510000000E+04, 9.7553658901E+00, 4.8083131510E+00, 1.6739138202E+00, 1.1014633311E+00, 7.7612954813E-01],
	[1.7515000000E+04, 9.7593587635E+00, 4.8081188067E+00, 1.6754670305E+00, 1.1021763703E+00, 7.7624725879E-01],
	[1.7520000000E+04, 9.7633521308E+00, 4.8079245257E+00, 1.6770212380E+00, 1.1028894838E+00, 7.7636491812E-01],
	[1.7525000000E+04, 9.7673459919E+00, 4.8077303079E+00, 1.6785764430E+00, 1.1036026713E+00, 7.7648252612E-01],
	[1.7530000000E+04, 9.7713403468E+00, 4.8075361535E+00, 1.6801326458E+00, 1.1043159327E+00, 7.7660008281E-01],
	[1.7535000000E+04, 9.7753351953E+00, 4.8073420622E+00, 1.6816898468E+00, 1.1050292677E+00, 7.7671758818E-01],
	[1.7540000000E+04, 9.7793305374E+00, 4.8071480341E+00, 1.6832480464E+00, 1.1057426759E+00, 7.7683504224E-01],
	[1.7545000000E+04, 9.7833263730E+00, 4.8069540691E+00, 1.6848072449E+00, 1.1064561573E+00, 7.7695244501E-01],
	[1.7550000000E+04, 9.7873227021E+00, 4.8067601673E+00, 1.6863674426E+00, 1.1071697115E+00, 7.7706979649E-01],
	[1.7555000000E+04, 9.7913195245E+00, 4.8065663284E+00, 1.6879286400E+00, 1.1078833383E+00, 7.7718709668E-01],
	[1.7560000000E+04, 9.7953168401E+00, 4.8063725526E+00, 1.6894908374E+00, 1.1085970374E+00, 7.7730434559E-01],
	[1.7565000000E+04, 9.7993146490E+00, 4.8061788398E+00, 1.6910540351E+00, 1.1093108086E+00, 7.7742154322E-01],
	[1.7570000000E+04, 9.8033129509E+00, 4.8059851899E+00, 1.6926182334E+00, 1.1100246517E+00, 7.7753868959E-01],
	[1.7575000000E+04, 9.8073117459E+00, 4.8057916029E+00, 1.6941834329E+00, 1.1107385664E+00, 7.7765578471E-01],
	[1.7580000000E+04, 9.8113110338E+00, 4.8055980788E+00, 1.6957496337E+00, 1.1114525524E+00, 7.7777282857E-01],
	[1.7585000000E+04, 9.8153108146E+00, 4.8054046175E+00, 1.6973168363E+00, 1.1121666095E+00, 7.7788982118E-01],
	[1.7590000000E+04, 9.8193110882E+00, 4.8052112189E+00, 1.6988850409E+00, 1.1128807375E+00, 7.7800676256E-01],
	[1.7595000000E+04, 9.8233118545E+00, 4.8050178832E+00, 1.7004542481E+00, 1.1135949361E+00, 7.7812365271E-01],
	[1.7600000000E+04, 9.8273131134E+00, 4.8048246101E+00, 1.7020244581E+00, 1.1143092051E+00, 7.7824049163E-01],
	[1.7605000000E+04, 9.8313148648E+00, 4.8046313997E+00, 1.7035956712E+00, 1.1150235442E+00, 7.7835727933E-01],
	[1.7610000000E+04, 9.8353171088E+00, 4.8044382519E+00, 1.7051678879E+00, 1.1157379531E+00, 7.7847401583E-01],
	[1.7615000000E+04, 9.8393198451E+00, 4.8042451668E+00, 1.7067411085E+00, 1.1164524317E+00, 7.7859070112E-01],
	[1.7620000000E+04, 9.8433230737E+00, 4.8040521441E+00, 1.7083153333E+00, 1.1171669797E+00, 7.7870733521E-01],
	[1.7625000000E+04, 9.8473267946E+00, 4.8038591840E+00, 1.7098905627E+00, 1.1178815968E+00, 7.7882391812E-01],
	[1.7630000000E+04, 9.8513310076E+00, 4.8036662864E+00, 1.7114667971E+00, 1.1185962829E+00, 7.7894044984E-01],
	[1.7635000000E+04, 9.8553357127E+00, 4.8034734512E+00, 1.7130440368E+00, 1.1193110375E+00, 7.7905693040E-01],
	[1.7640000000E+04, 9.8593409098E+00, 4.8032806785E+00, 1.7146222821E+00, 1.1200258606E+00, 7.7917335978E-01],
	[1.7645000000E+04, 9.8633465988E+00, 4.8030879681E+00, 1.7162015335E+00, 1.1207407518E+00, 7.7928973800E-01],
	[1.7650000000E+04, 9.8673527797E+00, 4.8028953200E+00, 1.7177817912E+00, 1.1214557109E+00, 7.7940606508E-01],
	[1.7655000000E+04, 9.8713594523E+00, 4.8027027342E+00, 1.7193630557E+00, 1.1221707377E+00, 7.7952234100E-01],
	[1.7660000000E+04, 9.8753824693E+00, 4.8025142783E+00, 1.7209453273E+00, 1.1228862592E+00, 7.7963856579E-01],
	[1.7665000000E+04, 9.8794114756E+00, 4.8023272909E+00, 1.7225286063E+00, 1.1236019968E+00, 7.7975473945E-01],
	[1.7670000000E+04, 9.8834409847E+00, 4.8021403638E+00, 1.7241128931E+00, 1.1243178024E+00, 7.7987086199E-01],
	[1.7675000000E+04, 9.8874709966E+00, 4.8019534968E+00, 1.7256981881E+00, 1.1250336758E+00, 7.7998693341E-01],
	[1.7680000000E+04, 9.8915015111E+00, 4.8017666899E+00, 1.7272844916E+00, 1.1257496168E+00, 7.8010295372E-01],
	[1.7685000000E+04, 9.8955325283E+00, 4.8015799432E+00, 1.7288718040E+00, 1.1264656250E+00, 7.8021892294E-01],
	[1.7690000000E+04, 9.8995640479E+00, 4.8013932564E+00, 1.7304601256E+00, 1.1271817003E+00, 7.8033484106E-01],
	[1.7695000000E+04, 9.9035960701E+00, 4.8012066297E+00, 1.7320494568E+00, 1.1278978423E+00, 7.8045070810E-01],
	[1.7700000000E+04, 9.9076285946E+00, 4.8010200630E+00, 1.7336397979E+00, 1.1286140510E+00, 7.8056652406E-01],
	[1.7705000000E+04, 9.9116616214E+00, 4.8008335562E+00, 1.7352311493E+00, 1.1293303259E+00, 7.8068228895E-01],
	[1.7710000000E+04, 9.9156951504E+00, 4.8006471093E+00, 1.7368235113E+00, 1.1300466669E+00, 7.8079800278E-01],
	[1.7715000000E+04, 9.9197291815E+00, 4.8004607223E+00, 1.7384168844E+00, 1.1307630738E+00, 7.8091366556E-01],
	[1.7720000000E+04, 9.9237637147E+00, 4.8002743951E+00, 1.7400112688E+00, 1.1314795462E+00, 7.8102927729E-01],
	[1.7725000000E+04, 9.9277987498E+00, 4.8000881277E+00, 1.7416066650E+00, 1.1321960840E+00, 7.8114483798E-01],
	[1.7730000000E+04, 9.9318342868E+00, 4.7999019201E+00, 1.7432030732E+00, 1.1329126868E+00, 7.8126034764E-01],
	[1.7735000000E+04, 9.9358703257E+00, 4.7997157722E+00, 1.7448004938E+00, 1.1336293545E+00, 7.8137580628E-01],
	[1.7740000000E+04, 9.9399068663E+00, 4.7995296840E+00, 1.7463989273E+00, 1.1343460868E+00, 7.8149121391E-01],
	[1.7745000000E+04, 9.9439439085E+00, 4.7993436554E+00, 1.7479983738E+00, 1.1350628835E+00, 7.8160657053E-01],
	[1.7750000000E+04, 9.9479814523E+00, 4.7991576865E+00, 1.7495988339E+00, 1.1357797442E+00, 7.8172187616E-01],
	[1.7755000000E+04, 9.9520194976E+00, 4.7989717771E+00, 1.7512003079E+00, 1.1364966689E+00, 7.8183713079E-01],
	[1.7760000000E+04, 9.9560580444E+00, 4.7987859273E+00, 1.7528027960E+00, 1.1372136571E+00, 7.8195233444E-01],
	[1.7765000000E+04, 9.9600970925E+00, 4.7986001370E+00, 1.7544062987E+00, 1.1379307088E+00, 7.8206748712E-01],
	[1.7770000000E+04, 9.9641366418E+00, 4.7984144062E+00, 1.7560108164E+00, 1.1386478236E+00, 7.8218258884E-01],
	[1.7775000000E+04, 9.9681766923E+00, 4.7982287348E+00, 1.7576163493E+00, 1.1393650012E+00, 7.8229763959E-01],
	[1.7780000000E+04, 9.9722172439E+00, 4.7980431228E+00, 1.7592228979E+00, 1.1400822416E+00, 7.8241263940E-01],
	[1.7785000000E+04, 9.9762582965E+00, 4.7978575702E+00, 1.7608304624E+00, 1.1407995443E+00, 7.8252758827E-01],
	[1.7790000000E+04, 9.9802998501E+00, 4.7976720769E+00, 1.7624390433E+00, 1.1415169092E+00, 7.8264248620E-01],
	[1.7795000000E+04, 9.9843419046E+00, 4.7974866429E+00, 1.7640486409E+00, 1.1422343360E+00, 7.8275733321E-01],
	[1.7800000000E+04, 9.9883844598E+00, 4.7973012681E+00, 1.7656592556E+00, 1.1429518245E+00, 7.8287212931E-01],
	[1.7805000000E+04, 9.9924275158E+00, 4.7971159526E+00, 1.7672708877E+00, 1.1436693744E+00, 7.8298687450E-01],
	[1.7810000000E+04, 9.9964710723E+00, 4.7969306963E+00, 1.7688835376E+00, 1.1443869855E+00, 7.8310156879E-01],
	[1.7815000000E+04, 1.0000515129E+01, 4.7967454991E+00, 1.7704972056E+00, 1.1451046576E+00, 7.8321621219E-01],
	[1.7820000000E+04, 1.0004559687E+01, 4.7965603611E+00, 1.7721118921E+00, 1.1458223903E+00, 7.8333080471E-01],
	[1.7825000000E+04, 1.0008604745E+01, 4.7963752821E+00, 1.7737275975E+00, 1.1465401835E+00, 7.8344534635E-01],
	[1.7830000000E+04, 1.0012650303E+01, 4.7961902622E+00, 1.7753443220E+00, 1.1472580369E+00, 7.8355983713E-01],
	[1.7835000000E+04, 1.0016696362E+01, 4.7960053012E+00, 1.7769620662E+00, 1.1479759503E+00, 7.8367427706E-01],
	[1.7840000000E+04, 1.0020742921E+01, 4.7958203993E+00, 1.7785808302E+00, 1.1486939234E+00, 7.8378866613E-01],
	[1.7845000000E+04, 1.0024789979E+01, 4.7956355563E+00, 1.7802006145E+00, 1.1494119560E+00, 7.8390300437E-01],
	[1.7850000000E+04, 1.0028837538E+01, 4.7954507722E+00, 1.7818214194E+00, 1.1501300479E+00, 7.8401729178E-01],
	[1.7855000000E+04, 1.0032885597E+01, 4.7952660470E+00, 1.7834432454E+00, 1.1508481987E+00, 7.8413152837E-01],
	[1.7860000000E+04, 1.0036934155E+01, 4.7950813806E+00, 1.7850660926E+00, 1.1515664083E+00, 7.8424571415E-01],
	[1.7865000000E+04, 1.0040983214E+01, 4.7948967730E+00, 1.7866899616E+00, 1.1522846764E+00, 7.8435984912E-01],
	[1.7870000000E+04, 1.0045032772E+01, 4.7947122242E+00, 1.7883148527E+00, 1.1530030028E+00, 7.8447393330E-01],
	[1.7875000000E+04, 1.0049082829E+01, 4.7945277341E+00, 1.7899407661E+00, 1.1537213872E+00, 7.8458796670E-01],
	[1.7880000000E+04, 1.0053133387E+01, 4.7943433027E+00, 1.7915677023E+00, 1.1544398294E+00, 7.8470194931E-01],
	[1.7885000000E+04, 1.0057184443E+01, 4.7941589300E+00, 1.7931956617E+00, 1.1551583291E+00, 7.8481588116E-01],
	[1.7890000000E+04, 1.0061235999E+01, 4.7939746158E+00, 1.7948246445E+00, 1.1558768861E+00, 7.8492976225E-01],
	[1.7895000000E+04, 1.0065288055E+01, 4.7937903603E+00, 1.7964546512E+00, 1.1565955002E+00, 7.8504359259E-01],
	[1.7900000000E+04, 1.0069340609E+01, 4.7936061633E+00, 1.7980856821E+00, 1.1573141711E+00, 7.8515737219E-01],
	[1.7905000000E+04, 1.0073393663E+01, 4.7934220249E+00, 1.7997177375E+00, 1.1580328986E+00, 7.8527110106E-01],
	[1.7910000000E+04, 1.0077447215E+01, 4.7932379449E+00, 1.8013508179E+00, 1.1587516824E+00, 7.8538477920E-01],
	[1.7915000000E+04, 1.0081501267E+01, 4.7930539234E+00, 1.8029849235E+00, 1.1594705223E+00, 7.8549840664E-01],
	[1.7920000000E+04, 1.0085555818E+01, 4.7928699603E+00, 1.8046200548E+00, 1.1601894180E+00, 7.8561198337E-01],
	[1.7925000000E+04, 1.0089610867E+01, 4.7926860555E+00, 1.8062562120E+00, 1.1609083693E+00, 7.8572550940E-01],
	[1.7930000000E+04, 1.0093666415E+01, 4.7925022092E+00, 1.8078933956E+00, 1.1616273760E+00, 7.8583898474E-01],
	[1.7935000000E+04, 1.0097722462E+01, 4.7923184211E+00, 1.8095316059E+00, 1.1623464378E+00, 7.8595240940E-01],
	[1.7940000000E+04, 1.0101779008E+01, 4.7921346913E+00, 1.8111708432E+00, 1.1630655545E+00, 7.8606578339E-01],
	[1.7945000000E+04, 1.0105855379E+01, 4.7919558404E+00, 1.8128111080E+00, 1.1637852665E+00, 7.8617910670E-01],
	[1.7950000000E+04, 1.0109934542E+01, 4.7917776149E+00, 1.8144524005E+00, 1.1645050977E+00, 7.8629237935E-01],
	[1.7955000000E+04, 1.0114014214E+01, 4.7915994457E+00, 1.8160947212E+00, 1.1652249842E+00, 7.8640560134E-01],
	[1.7960000000E+04, 1.0118094395E+01, 4.7914213328E+00, 1.8177380703E+00, 1.1659449258E+00, 7.8651877267E-01],
	[1.7965000000E+04, 1.0122175087E+01, 4.7912432760E+00, 1.8193824483E+00, 1.1666649221E+00, 7.8663189336E-01],
	[1.7970000000E+04, 1.0126256287E+01, 4.7910652754E+00, 1.8210278555E+00, 1.1673849730E+00, 7.8674496341E-01],
	[1.7975000000E+04, 1.0130337998E+01, 4.7908873310E+00, 1.8226742923E+00, 1.1681050781E+00, 7.8685798282E-01],
	[1.7980000000E+04, 1.0134420217E+01, 4.7907094426E+00, 1.8243217589E+00, 1.1688252374E+00, 7.8697095160E-01],
	[1.7985000000E+04, 1.0138502946E+01, 4.7905316103E+00, 1.8259702559E+00, 1.1695454505E+00, 7.8708386977E-01],
	[1.7990000000E+04, 1.0142586184E+01, 4.7903538340E+00, 1.8276197835E+00, 1.1702657171E+00, 7.8719673732E-01],
	[1.7995000000E+04, 1.0146669931E+01, 4.7901761137E+00, 1.8292703420E+00, 1.1709860371E+00, 7.8730955426E-01],
	[1.8000000000E+04, 1.0150754187E+01, 4.7899984494E+00, 1.8309219319E+00, 1.1717064102E+00, 7.8742232059E-01],
	[1.8005000000E+04, 1.0154838952E+01, 4.7898208410E+00, 1.8325745536E+00, 1.1724268362E+00, 7.8753503634E-01],
	[1.8010000000E+04, 1.0158924226E+01, 4.7896432885E+00, 1.8342282072E+00, 1.1731473148E+00, 7.8764770149E-01],
	[1.8015000000E+04, 1.0163010009E+01, 4.7894657919E+00, 1.8358828933E+00, 1.1738678458E+00, 7.8776031606E-01],
	[1.8020000000E+04, 1.0167096301E+01, 4.7892883511E+00, 1.8375386122E+00, 1.1745884289E+00, 7.8787288006E-01],
	[1.8025000000E+04, 1.0171183101E+01, 4.7891109661E+00, 1.8391953642E+00, 1.1753090639E+00, 7.8798539348E-01],
	[1.8030000000E+04, 1.0175270410E+01, 4.7889336369E+00, 1.8408531497E+00, 1.1760297506E+00, 7.8809785635E-01],
	[1.8035000000E+04, 1.0179358227E+01, 4.7887563634E+00, 1.8425119691E+00, 1.1767504887E+00, 7.8821026865E-01],
	[1.8040000000E+04, 1.0183446553E+01, 4.7885791456E+00, 1.8441718226E+00, 1.1774712779E+00, 7.8832263041E-01],
	[1.8045000000E+04, 1.0187535387E+01, 4.7884019835E+00, 1.8458327108E+00, 1.1781921181E+00, 7.8843494163E-01],
	[1.8050000000E+04, 1.0191624729E+01, 4.7882248770E+00, 1.8474946338E+00, 1.1789130091E+00, 7.8854720231E-01],
	[1.8055000000E+04, 1.0195714579E+01, 4.7880478261E+00, 1.8491575921E+00, 1.1796339504E+00, 7.8865941247E-01],
	[1.8060000000E+04, 1.0199804938E+01, 4.7878708308E+00, 1.8508215861E+00, 1.1803549420E+00, 7.8877157210E-01],
	[1.8065000000E+04, 1.0203895804E+01, 4.7876938910E+00, 1.8524866161E+00, 1.1810759836E+00, 7.8888368122E-01],
	[1.8070000000E+04, 1.0207987179E+01, 4.7875170067E+00, 1.8541526824E+00, 1.1817970749E+00, 7.8899573984E-01],
	[1.8075000000E+04, 1.0212079061E+01, 4.7873401779E+00, 1.8558197854E+00, 1.1825182158E+00, 7.8910774795E-01],
	[1.8080000000E+04, 1.0216171451E+01, 4.7871634046E+00, 1.8574879255E+00, 1.1832394059E+00, 7.8921970557E-01],
	[1.8085000000E+04, 1.0220264349E+01, 4.7869866866E+00, 1.8591571031E+00, 1.1839606450E+00, 7.8933161270E-01],
	[1.8090000000E+04, 1.0224357755E+01, 4.7868100240E+00, 1.8608273184E+00, 1.1846819329E+00, 7.8944346936E-01],
	[1.8095000000E+04, 1.0228451668E+01, 4.7866334167E+00, 1.8624985719E+00, 1.1854032693E+00, 7.8955527554E-01],
	[1.8100000000E+04, 1.0232546089E+01, 4.7864568648E+00, 1.8641708638E+00, 1.1861246540E+00, 7.8966703126E-01],
	[1.8105000000E+04, 1.0236641017E+01, 4.7862803681E+00, 1.8658441947E+00, 1.1868460868E+00, 7.8977873653E-01],
	[1.8110000000E+04, 1.0240736452E+01, 4.7861039266E+00, 1.8675185647E+00, 1.1875675675E+00, 7.8989039134E-01],
	[1.8115000000E+04, 1.0244832394E+01, 4.7859275404E+00, 1.8691939743E+00, 1.1882890957E+00, 7.9000199572E-01],
	[1.8120000000E+04, 1.0248928844E+01, 4.7857512094E+00, 1.8708704239E+00, 1.1890106713E+00, 7.9011354966E-01],
	[1.8125000000E+04, 1.0253025801E+01, 4.7855749334E+00, 1.8725479137E+00, 1.1897322939E+00, 7.9022505317E-01],
	[1.8130000000E+04, 1.0257123265E+01, 4.7853987126E+00, 1.8742264442E+00, 1.1904539635E+00, 7.9033650626E-01],
	[1.8135000000E+04, 1.0261221236E+01, 4.7852225469E+00, 1.8759060157E+00, 1.1911756797E+00, 7.9044790894E-01],
	[1.8140000000E+04, 1.0265319713E+01, 4.7850464362E+00, 1.8775866286E+00, 1.1918974422E+00, 7.9055926122E-01],
	[1.8145000000E+04, 1.0269418698E+01, 4.7848703806E+00, 1.8792682832E+00, 1.1926192510E+00, 7.9067056309E-01],
	[1.8150000000E+04, 1.0273518189E+01, 4.7846943799E+00, 1.8809509799E+00, 1.1933411056E+00, 7.9078181458E-01],
	[1.8155000000E+04, 1.0277618187E+01, 4.7845184342E+00, 1.8826347190E+00, 1.1940630060E+00, 7.9089301569E-01],
	[1.8160000000E+04, 1.0281718691E+01, 4.7843425434E+00, 1.8843195010E+00, 1.1947849517E+00, 7.9100416643E-01],
	[1.8165000000E+04, 1.0285819702E+01, 4.7841667074E+00, 1.8860053261E+00, 1.1955069427E+00, 7.9111526680E-01],
	[1.8170000000E+04, 1.0289921219E+01, 4.7839909264E+00, 1.8876921947E+00, 1.1962289786E+00, 7.9122631681E-01],
	[1.8175000000E+04, 1.0294023243E+01, 4.7838152001E+00, 1.8893801072E+00, 1.1969510593E+00, 7.9133731647E-01],
	[1.8180000000E+04, 1.0298125773E+01, 4.7836395286E+00, 1.8910690639E+00, 1.1976731844E+00, 7.9144826578E-01],
	[1.8185000000E+04, 1.0302228809E+01, 4.7834639119E+00, 1.8927590652E+00, 1.1983953538E+00, 7.9155916477E-01],
	[1.8190000000E+04, 1.0306332351E+01, 4.7832883499E+00, 1.8944501115E+00, 1.1991175672E+00, 7.9167001342E-01],
	[1.8195000000E+04, 1.0310436399E+01, 4.7831128427E+00, 1.8961422030E+00, 1.1998398244E+00, 7.9178081176E-01],
	[1.8200000000E+04, 1.0314540953E+01, 4.7829373900E+00, 1.8978353403E+00, 1.2005621251E+00, 7.9189155979E-01],
	[1.8205000000E+04, 1.0318646013E+01, 4.7827619920E+00, 1.8995295235E+00, 1.2012844691E+00, 7.9200225751E-01],
	[1.8210000000E+04, 1.0322751579E+01, 4.7825866486E+00, 1.9012247532E+00, 1.2020068562E+00, 7.9211290494E-01],
	[1.8215000000E+04, 1.0326857650E+01, 4.7824113598E+00, 1.9029210296E+00, 1.2027292861E+00, 7.9222350208E-01],
	[1.8220000000E+04, 1.0330964227E+01, 4.7822361254E+00, 1.9046183531E+00, 1.2034517585E+00, 7.9233404895E-01],
	[1.8225000000E+04, 1.0335071310E+01, 4.7820609456E+00, 1.9063167241E+00, 1.2041742734E+00, 7.9244454554E-01],
	[1.8230000000E+04, 1.0339181759E+01, 4.7818865143E+00, 1.9080161428E+00, 1.2048969132E+00, 7.9255499187E-01],
	[1.8235000000E+04, 1.0343311734E+01, 4.7817167486E+00, 1.9097166098E+00, 1.2056201466E+00, 7.9266538795E-01],
	[1.8240000000E+04, 1.0347442225E+01, 4.7815470354E+00, 1.9114181253E+00, 1.2063434228E+00, 7.9277573379E-01],
	[1.8245000000E+04, 1.0351573233E+01, 4.7813773747E+00, 1.9131206897E+00, 1.2070667415E+00, 7.9288602938E-01],
	[1.8250000000E+04, 1.0355704758E+01, 4.7812077666E+00, 1.9148243033E+00, 1.2077901025E+00, 7.9299627475E-01],
	[1.8255000000E+04, 1.0359836799E+01, 4.7810382109E+00, 1.9165289666E+00, 1.2085135056E+00, 7.9310646990E-01],
	[1.8260000000E+04, 1.0363969357E+01, 4.7808687077E+00, 1.9182346798E+00, 1.2092369505E+00, 7.9321661483E-01],
	[1.8265000000E+04, 1.0368102431E+01, 4.7806992568E+00, 1.9199414434E+00, 1.2099604370E+00, 7.9332670956E-01],
	[1.8270000000E+04, 1.0372236021E+01, 4.7805298584E+00, 1.9216492577E+00, 1.2106839649E+00, 7.9343675410E-01],
	[1.8275000000E+04, 1.0376370128E+01, 4.7803605123E+00, 1.9233581230E+00, 1.2114075338E+00, 7.9354674845E-01],
	[1.8280000000E+04, 1.0380504751E+01, 4.7801912186E+00, 1.9250680397E+00, 1.2121311437E+00, 7.9365669263E-01],
	[1.8285000000E+04, 1.0384639889E+01, 4.7800219771E+00, 1.9267790081E+00, 1.2128547942E+00, 7.9376658663E-01],
	[1.8290000000E+04, 1.0388775544E+01, 4.7798527879E+00, 1.9284910288E+00, 1.2135784851E+00, 7.9387643047E-01],
	[1.8295000000E+04, 1.0392911715E+01, 4.7796836509E+00, 1.9302041018E+00, 1.2143022161E+00, 7.9398622417E-01],
	[1.8300000000E+04, 1.0397048401E+01, 4.7795145661E+00, 1.9319182278E+00, 1.2150259872E+00, 7.9409596771E-01],
	[1.8305000000E+04, 1.0401185604E+01, 4.7793455335E+00, 1.9336334069E+00, 1.2157497979E+00, 7.9420566113E-01],
	[1.8310000000E+04, 1.0405323322E+01, 4.7791765531E+00, 1.9353496396E+00, 1.2164736481E+00, 7.9431530442E-01],
	[1.8315000000E+04, 1.0409461555E+01, 4.7790076247E+00, 1.9370669262E+00, 1.2171975375E+00, 7.9442489759E-01],
	[1.8320000000E+04, 1.0413600304E+01, 4.7788387484E+00, 1.9387852671E+00, 1.2179214659E+00, 7.9453444065E-01],
	[1.8325000000E+04, 1.0417739569E+01, 4.7786699242E+00, 1.9405046627E+00, 1.2186454330E+00, 7.9464393362E-01],
	[1.8330000000E+04, 1.0421879349E+01, 4.7785011520E+00, 1.9422251132E+00, 1.2193694387E+00, 7.9475337649E-01],
	[1.8335000000E+04, 1.0426019644E+01, 4.7783324318E+00, 1.9439466191E+00, 1.2200934827E+00, 7.9486276929E-01],
	[1.8340000000E+04, 1.0430160455E+01, 4.7781637635E+00, 1.9456691807E+00, 1.2208175648E+00, 7.9497211201E-01],
	[1.8345000000E+04, 1.0434301780E+01, 4.7779951472E+00, 1.9473927984E+00, 1.2215416846E+00, 7.9508140466E-01],
	[1.8350000000E+04, 1.0438443621E+01, 4.7778265828E+00, 1.9491174725E+00, 1.2222658421E+00, 7.9519064727E-01],
	[1.8355000000E+04, 1.0442585977E+01, 4.7776580702E+00, 1.9508432034E+00, 1.2229900369E+00, 7.9529983983E-01],
	[1.8360000000E+04, 1.0446728847E+01, 4.7774896095E+00, 1.9525699915E+00, 1.2237142688E+00, 7.9540898235E-01],
	[1.8365000000E+04, 1.0450872233E+01, 4.7773212006E+00, 1.9542978371E+00, 1.2244385376E+00, 7.9551807485E-01],
	[1.8370000000E+04, 1.0455016133E+01, 4.7771528435E+00, 1.9560267405E+00, 1.2251628430E+00, 7.9562711733E-01],
	[1.8375000000E+04, 1.0459160548E+01, 4.7769845381E+00, 1.9577567022E+00, 1.2258871849E+00, 7.9573610980E-01],
	[1.8380000000E+04, 1.0463305477E+01, 4.7768162844E+00, 1.9594877225E+00, 1.2266115629E+00, 7.9584505227E-01],
	[1.8385000000E+04, 1.0467450921E+01, 4.7766480824E+00, 1.9612198017E+00, 1.2273359769E+00, 7.9595394475E-01],
	[1.8390000000E+04, 1.0471596880E+01, 4.7764799321E+00, 1.9629529402E+00, 1.2280604265E+00, 7.9606278725E-01],
	[1.8395000000E+04, 1.0475743353E+01, 4.7763118334E+00, 1.9646871384E+00, 1.2287849117E+00, 7.9617157978E-01],
	[1.8400000000E+04, 1.0479890340E+01, 4.7761437863E+00, 1.9664223967E+00, 1.2295094321E+00, 7.9628032235E-01],
	[1.8405000000E+04, 1.0484037841E+01, 4.7759757908E+00, 1.9681587153E+00, 1.2302339875E+00, 7.9638901496E-01],
	[1.8410000000E+04, 1.0488185857E+01, 4.7758078468E+00, 1.9698960947E+00, 1.2309585777E+00, 7.9649765764E-01],
	[1.8415000000E+04, 1.0492334387E+01, 4.7756399543E+00, 1.9716345351E+00, 1.2316832024E+00, 7.9660625038E-01],
	[1.8420000000E+04, 1.0496483431E+01, 4.7754721133E+00, 1.9733740371E+00, 1.2324078614E+00, 7.9671479319E-01],
	[1.8425000000E+04, 1.0500632988E+01, 4.7753043238E+00, 1.9751146008E+00, 1.2331325545E+00, 7.9682328609E-01],
	[1.8430000000E+04, 1.0504783060E+01, 4.7751365857E+00, 1.9768562268E+00, 1.2338572814E+00, 7.9693172909E-01],
	[1.8435000000E+04, 1.0508933645E+01, 4.7749688989E+00, 1.9785989153E+00, 1.2345820420E+00, 7.9704012219E-01],
	[1.8440000000E+04, 1.0513084744E+01, 4.7748012636E+00, 1.9803426667E+00, 1.2353068359E+00, 7.9714846541E-01],
	[1.8445000000E+04, 1.0517236357E+01, 4.7746336795E+00, 1.9820874814E+00, 1.2360316629E+00, 7.9725675875E-01],
	[1.8450000000E+04, 1.0521388483E+01, 4.7744661468E+00, 1.9838333597E+00, 1.2367565229E+00, 7.9736500222E-01],
	[1.8455000000E+04, 1.0525541122E+01, 4.7742986653E+00, 1.9855803020E+00, 1.2374814155E+00, 7.9747319584E-01],
	[1.8460000000E+04, 1.0529694275E+01, 4.7741312351E+00, 1.9873283086E+00, 1.2382063406E+00, 7.9758133961E-01],
	[1.8465000000E+04, 1.0533847942E+01, 4.7739638561E+00, 1.9890773799E+00, 1.2389312978E+00, 7.9768943354E-01],
	[1.8470000000E+04, 1.0538002121E+01, 4.7737965282E+00, 1.9908275163E+00, 1.2396562871E+00, 7.9779747765E-01],
	[1.8475000000E+04, 1.0542156814E+01, 4.7736292515E+00, 1.9925787181E+00, 1.2403813080E+00, 7.9790547194E-01],
	[1.8480000000E+04, 1.0546312020E+01, 4.7734620260E+00, 1.9943309857E+00, 1.2411063605E+00, 7.9801341642E-01],
	[1.8485000000E+04, 1.0550467739E+01, 4.7732948515E+00, 1.9960843195E+00, 1.2418314443E+00, 7.9812131111E-01],
	[1.8490000000E+04, 1.0554623971E+01, 4.7731277281E+00, 1.9978387197E+00, 1.2425565591E+00, 7.9822915601E-01],
	[1.8495000000E+04, 1.0558780716E+01, 4.7729606558E+00, 1.9995941869E+00, 1.2432817047E+00, 7.9833695113E-01],
	[1.8500000000E+04, 1.0562937973E+01, 4.7727936344E+00, 2.0013507212E+00, 1.2440068809E+00, 7.9844469648E-01],
	[1.8505000000E+04, 1.0567095743E+01, 4.7726266640E+00, 2.0031083231E+00, 1.2447320874E+00, 7.9855239208E-01],
	[1.8510000000E+04, 1.0571254026E+01, 4.7724597446E+00, 2.0048669930E+00, 1.2454573241E+00, 7.9866003793E-01],
	[1.8515000000E+04, 1.0575412822E+01, 4.7722928761E+00, 2.0066267311E+00, 1.2461825906E+00, 7.9876763404E-01],
	[1.8520000000E+04, 1.0579572130E+01, 4.7721260585E+00, 2.0083875380E+00, 1.2469078868E+00, 7.9887518043E-01],
	[1.8525000000E+04, 1.0583741637E+01, 4.7719615757E+00, 2.0101494138E+00, 1.2476335031E+00, 7.9898267710E-01],
	[1.8530000000E+04, 1.0587924129E+01, 4.7718000818E+00, 2.0119123591E+00, 1.2483595236E+00, 7.9909012406E-01],
	[1.8535000000E+04, 1.0592107146E+01, 4.7716386369E+00, 2.0136763741E+00, 1.2490855741E+00, 7.9919752133E-01],
	[1.8540000000E+04, 1.0596290686E+01, 4.7714772410E+00, 2.0154414591E+00, 1.2498116546E+00, 7.9930486891E-01],
	[1.8545000000E+04, 1.0600474750E+01, 4.7713158941E+00, 2.0172076147E+00, 1.2505377647E+00, 7.9941216681E-01],
	[1.8550000000E+04, 1.0604659337E+01, 4.7711545962E+00, 2.0189748411E+00, 1.2512639042E+00, 7.9951941505E-01],
	[1.8555000000E+04, 1.0608844448E+01, 4.7709933471E+00, 2.0207431386E+00, 1.2519900729E+00, 7.9962661364E-01],
	[1.8560000000E+04, 1.0613030082E+01, 4.7708321470E+00, 2.0225125077E+00, 1.2527162705E+00, 7.9973376258E-01],
	[1.8565000000E+04, 1.0617216240E+01, 4.7706709957E+00, 2.0242829487E+00, 1.2534424968E+00, 7.9984086189E-01],
	[1.8570000000E+04, 1.0621402921E+01, 4.7705098933E+00, 2.0260544620E+00, 1.2541687517E+00, 7.9994791157E-01],
	[1.8575000000E+04, 1.0625590124E+01, 4.7703488397E+00, 2.0278270479E+00, 1.2548950347E+00, 8.0005491164E-01],
	[1.8580000000E+04, 1.0629777851E+01, 4.7701878348E+00, 2.0296007068E+00, 1.2556213459E+00, 8.0016186211E-01],
	[1.8585000000E+04, 1.0633966101E+01, 4.7700268787E+00, 2.0313754391E+00, 1.2563476848E+00, 8.0026876299E-01],
	[1.8590000000E+04, 1.0638154874E+01, 4.7698659714E+00, 2.0331512450E+00, 1.2570740512E+00, 8.0037561428E-01],
	[1.8595000000E+04, 1.0642344170E+01, 4.7697051127E+00, 2.0349281250E+00, 1.2578004451E+00, 8.0048241600E-01],
	[1.8600000000E+04, 1.0646533988E+01, 4.7695443027E+00, 2.0367060794E+00, 1.2585268660E+00, 8.0058916817E-01],
	[1.8605000000E+04, 1.0650724329E+01, 4.7693835413E+00, 2.0384851087E+00, 1.2592533138E+00, 8.0069587078E-01],
	[1.8610000000E+04, 1.0654915193E+01, 4.7692228286E+00, 2.0402652130E+00, 1.2599797882E+00, 8.0080252386E-01],
	[1.8615000000E+04, 1.0659106579E+01, 4.7690621644E+00, 2.0420463929E+00, 1.2607062890E+00, 8.0090912740E-01],
	[1.8620000000E+04, 1.0663298488E+01, 4.7689015488E+00, 2.0438286487E+00, 1.2614328161E+00, 8.0101568143E-01],
	[1.8625000000E+04, 1.0667490919E+01, 4.7687409818E+00, 2.0456119807E+00, 1.2621593691E+00, 8.0112218596E-01],
	[1.8630000000E+04, 1.0671683873E+01, 4.7685804632E+00, 2.0473963892E+00, 1.2628859478E+00, 8.0122864099E-01],
	[1.8635000000E+04, 1.0675877349E+01, 4.7684199931E+00, 2.0491818748E+00, 1.2636125520E+00, 8.0133504653E-01],
	[1.8640000000E+04, 1.0680071346E+01, 4.7682595715E+00, 2.0509684376E+00, 1.2643391815E+00, 8.0144140260E-01],
	[1.8645000000E+04, 1.0684265866E+01, 4.7680991983E+00, 2.0527560781E+00, 1.2650658360E+00, 8.0154770921E-01],
	[1.8650000000E+04, 1.0688460908E+01, 4.7679388735E+00, 2.0545447967E+00, 1.2657925153E+00, 8.0165396636E-01],
	[1.8655000000E+04, 1.0692656472E+01, 4.7677785970E+00, 2.0563345936E+00, 1.2665192192E+00, 8.0176017407E-01],
	[1.8660000000E+04, 1.0696852558E+01, 4.7676183689E+00, 2.0581254693E+00, 1.2672459475E+00, 8.0186633236E-01],
	[1.8665000000E+04, 1.0701049166E+01, 4.7674581891E+00, 2.0599174241E+00, 1.2679726998E+00, 8.0197244122E-01],
	[1.8670000000E+04, 1.0705246295E+01, 4.7672980575E+00, 2.0617104584E+00, 1.2686994761E+00, 8.0207850068E-01],
	[1.8675000000E+04, 1.0709443946E+01, 4.7671379743E+00, 2.0635045725E+00, 1.2694262761E+00, 8.0218451074E-01],
	[1.8680000000E+04, 1.0713642119E+01, 4.7669779392E+00, 2.0652997669E+00, 1.2701530994E+00, 8.0229047141E-01],
	[1.8685000000E+04, 1.0717840813E+01, 4.7668179524E+00, 2.0670960417E+00, 1.2708799460E+00, 8.0239638271E-01],
	[1.8690000000E+04, 1.0722040028E+01, 4.7666580137E+00, 2.0688933975E+00, 1.2716068156E+00, 8.0250224465E-01],
	[1.8695000000E+04, 1.0726239765E+01, 4.7664981232E+00, 2.0706918346E+00, 1.2723337079E+00, 8.0260805723E-01],
	[1.8700000000E+04, 1.0730440023E+01, 4.7663382808E+00, 2.0724913534E+00, 1.2730606227E+00, 8.0271382047E-01],
	[1.8705000000E+04, 1.0734640802E+01, 4.7661784865E+00, 2.0742919541E+00, 1.2737875598E+00, 8.0281953438E-01],
	[1.8710000000E+04, 1.0738842103E+01, 4.7660187402E+00, 2.0760936372E+00, 1.2745145190E+00, 8.0292519898E-01],
	[1.8715000000E+04, 1.0743043924E+01, 4.7658590420E+00, 2.0778964030E+00, 1.2752415001E+00, 8.0303081427E-01],
	[1.8720000000E+04, 1.0747246266E+01, 4.7656993918E+00, 2.0797002519E+00, 1.2759685027E+00, 8.0313638026E-01],
	[1.8725000000E+04, 1.0751449130E+01, 4.7655397896E+00, 2.0815051842E+00, 1.2766955267E+00, 8.0324189696E-01],
	[1.8730000000E+04, 1.0755652514E+01, 4.7653802353E+00, 2.0833112004E+00, 1.2774225719E+00, 8.0334736440E-01],
	[1.8735000000E+04, 1.0759856419E+01, 4.7652207290E+00, 2.0851183007E+00, 1.2781496380E+00, 8.0345278257E-01],
	[1.8740000000E+04, 1.0764060844E+01, 4.7650612705E+00, 2.0869264856E+00, 1.2788767248E+00, 8.0355815149E-01],
	[1.8745000000E+04, 1.0768265790E+01, 4.7649018600E+00, 2.0887357553E+00, 1.2796038321E+00, 8.0366347117E-01],
	[1.8750000000E+04, 1.0772471257E+01, 4.7647424972E+00, 2.0905461103E+00, 1.2803309596E+00, 8.0376874163E-01],
	[1.8755000000E+04, 1.0776677244E+01, 4.7645831823E+00, 2.0923575509E+00, 1.2810581071E+00, 8.0387396287E-01],
	[1.8760000000E+04, 1.0780883751E+01, 4.7644239152E+00, 2.0941700775E+00, 1.2817852745E+00, 8.0397913491E-01],
	[1.8765000000E+04, 1.0785090779E+01, 4.7642646959E+00, 2.0959836905E+00, 1.2825124614E+00, 8.0408425775E-01],
	[1.8770000000E+04, 1.0789298327E+01, 4.7641055243E+00, 2.0977983901E+00, 1.2832396676E+00, 8.0418933141E-01],
	[1.8775000000E+04, 1.0793506395E+01, 4.7639464004E+00, 2.0996141768E+00, 1.2839668929E+00, 8.0429435591E-01],
	[1.8780000000E+04, 1.0797714984E+01, 4.7637873242E+00, 2.1014310509E+00, 1.2846941372E+00, 8.0439933124E-01],
	[1.8785000000E+04, 1.0801924092E+01, 4.7636282956E+00, 2.1032490127E+00, 1.2854214000E+00, 8.0450425743E-01],
	[1.8790000000E+04, 1.0806133720E+01, 4.7634693147E+00, 2.1050680628E+00, 1.2861486814E+00, 8.0460913449E-01],
	[1.8795000000E+04, 1.0810343868E+01, 4.7633103813E+00, 2.1068882013E+00, 1.2868759809E+00, 8.0471396243E-01],
	[1.8800000000E+04, 1.0814554536E+01, 4.7631514956E+00, 2.1087094287E+00, 1.2876032984E+00, 8.0481874125E-01],
	[1.8805000000E+04, 1.0818765723E+01, 4.7629926574E+00, 2.1105317453E+00, 1.2883306336E+00, 8.0492347097E-01],
	[1.8810000000E+04, 1.0822977430E+01, 4.7628338667E+00, 2.1123551515E+00, 1.2890579864E+00, 8.0502815161E-01],
	[1.8815000000E+04, 1.0827189657E+01, 4.7626751235E+00, 2.1141796477E+00, 1.2897853565E+00, 8.0513278318E-01],
	[1.8820000000E+04, 1.0831402403E+01, 4.7625164278E+00, 2.1160052342E+00, 1.2905127436E+00, 8.0523736568E-01],
	[1.8825000000E+04, 1.0835633591E+01, 4.7623618872E+00, 2.1178319113E+00, 1.2912407041E+00, 8.0534189913E-01],
	[1.8830000000E+04, 1.0839869821E+01, 4.7622084268E+00, 2.1196596795E+00, 1.2919688223E+00, 8.0544638354E-01],
	[1.8835000000E+04, 1.0844106582E+01, 4.7620550120E+00, 2.1214885390E+00, 1.2926969582E+00, 8.0555081892E-01],
	[1.8840000000E+04, 1.0848343874E+01, 4.7619016429E+00, 2.1233184904E+00, 1.2934251113E+00, 8.0565520529E-01],
	[1.8845000000E+04, 1.0852581697E+01, 4.7617483195E+00, 2.1251495338E+00, 1.2941532816E+00, 8.0575954265E-01],
	[1.8850000000E+04, 1.0856820050E+01, 4.7615950416E+00, 2.1269816697E+00, 1.2948814687E+00, 8.0586383102E-01],
	[1.8855000000E+04, 1.0861058933E+01, 4.7614418094E+00, 2.1288148985E+00, 1.2956096725E+00, 8.0596807042E-01],
	[1.8860000000E+04, 1.0865298347E+01, 4.7612886227E+00, 2.1306492205E+00, 1.2963378927E+00, 8.0607226084E-01],
	[1.8865000000E+04, 1.0869538291E+01, 4.7611354815E+00, 2.1324846360E+00, 1.2970661292E+00, 8.0617640232E-01],
	[1.8870000000E+04, 1.0873778766E+01, 4.7609823858E+00, 2.1343211455E+00, 1.2977943816E+00, 8.0628049485E-01],
	[1.8875000000E+04, 1.0878019771E+01, 4.7608293356E+00, 2.1361587493E+00, 1.2985226498E+00, 8.0638453845E-01],
	[1.8880000000E+04, 1.0882261306E+01, 4.7606763309E+00, 2.1379974477E+00, 1.2992509336E+00, 8.0648853313E-01],
	[1.8885000000E+04, 1.0886503371E+01, 4.7605233716E+00, 2.1398372411E+00, 1.2999792326E+00, 8.0659247890E-01],
	[1.8890000000E+04, 1.0890745965E+01, 4.7603704577E+00, 2.1416781299E+00, 1.3007075467E+00, 8.0669637578E-01],
	[1.8895000000E+04, 1.0894989090E+01, 4.7602175892E+00, 2.1435201144E+00, 1.3014358757E+00, 8.0680022378E-01],
	[1.8900000000E+04, 1.0899232745E+01, 4.7600647661E+00, 2.1453631950E+00, 1.3021642194E+00, 8.0690402291E-01],
	[1.8905000000E+04, 1.0903476929E+01, 4.7599119882E+00, 2.1472073721E+00, 1.3028925774E+00, 8.0700777319E-01],
	[1.8910000000E+04, 1.0907721643E+01, 4.7597592557E+00, 2.1490526460E+00, 1.3036209497E+00, 8.0711147462E-01],
	[1.8915000000E+04, 1.0911966887E+01, 4.7596065684E+00, 2.1508990171E+00, 1.3043493359E+00, 8.0721512722E-01],
	[1.8920000000E+04, 1.0916212660E+01, 4.7594539264E+00, 2.1527464858E+00, 1.3050777358E+00, 8.0731873099E-01],
	[1.8925000000E+04, 1.0920458963E+01, 4.7593013297E+00, 2.1545950523E+00, 1.3058061493E+00, 8.0742228597E-01],
	[1.8930000000E+04, 1.0924705795E+01, 4.7591487781E+00, 2.1564447172E+00, 1.3065345761E+00, 8.0752579214E-01],
	[1.8935000000E+04, 1.0928953157E+01, 4.7589962717E+00, 2.1582954806E+00, 1.3072630160E+00, 8.0762924954E-01],
	[1.8940000000E+04, 1.0933201047E+01, 4.7588438105E+00, 2.1601473431E+00, 1.3079914687E+00, 8.0773265816E-01],
	[1.8945000000E+04, 1.0937449467E+01, 4.7586913944E+00, 2.1620003049E+00, 1.3087199340E+00, 8.0783601803E-01],
	[1.8950000000E+04, 1.0941698416E+01, 4.7585390233E+00, 2.1638543664E+00, 1.3094484118E+00, 8.0793932915E-01],
	[1.8955000000E+04, 1.0945947894E+01, 4.7583866974E+00, 2.1657095280E+00, 1.3101769017E+00, 8.0804259154E-01],
	[1.8960000000E+04, 1.0950197901E+01, 4.7582344165E+00, 2.1675657900E+00, 1.3109054036E+00, 8.0814580521E-01],
	[1.8965000000E+04, 1.0954448437E+01, 4.7580821806E+00, 2.1694231529E+00, 1.3116339173E+00, 8.0824897018E-01],
	[1.8970000000E+04, 1.0958699501E+01, 4.7579299898E+00, 2.1712816169E+00, 1.3123624424E+00, 8.0835208645E-01],
	[1.8975000000E+04, 1.0962951094E+01, 4.7577778439E+00, 2.1731411824E+00, 1.3130909789E+00, 8.0845515404E-01],
	[1.8980000000E+04, 1.0967203216E+01, 4.7576257429E+00, 2.1750018499E+00, 1.3138195264E+00, 8.0855817296E-01],
	[1.8985000000E+04, 1.0971455867E+01, 4.7574736869E+00, 2.1768636196E+00, 1.3145480848E+00, 8.0866114323E-01],
	[1.8990000000E+04, 1.0975709046E+01, 4.7573216758E+00, 2.1787264919E+00, 1.3152766538E+00, 8.0876406485E-01],
	[1.8995000000E+04, 1.0979962753E+01, 4.7571697095E+00, 2.1805904672E+00, 1.3160052332E+00, 8.0886693784E-01],
	[1.9000000000E+04, 1.0984216989E+01, 4.7570177881E+00, 2.1824555458E+00, 1.3167338228E+00, 8.0896976222E-01],
	[1.9005000000E+04, 1.0988471753E+01, 4.7568659116E+00, 2.1843217281E+00, 1.3174624224E+00, 8.0907253799E-01],
	[1.9010000000E+04, 1.0992727046E+01, 4.7567140798E+00, 2.1861890145E+00, 1.3181910317E+00, 8.0917526517E-01],
	[1.9015000000E+04, 1.0996982866E+01, 4.7565622928E+00, 2.1880574053E+00, 1.3189196505E+00, 8.0927794377E-01],
	[1.9020000000E+04, 1.1001239214E+01, 4.7564105505E+00, 2.1899269009E+00, 1.3196482787E+00, 8.0938057380E-01],
	[1.9025000000E+04, 1.1005496091E+01, 4.7562588530E+00, 2.1917975017E+00, 1.3203769159E+00, 8.0948315527E-01],
	[1.9030000000E+04, 1.1009753495E+01, 4.7561072002E+00, 2.1936692080E+00, 1.3211055619E+00, 8.0958568819E-01],
	[1.9035000000E+04, 1.1014011428E+01, 4.7559555920E+00, 2.1955420201E+00, 1.3218342166E+00, 8.0968817257E-01],
	[1.9040000000E+04, 1.1018269888E+01, 4.7558040285E+00, 2.1974159385E+00, 1.3225628797E+00, 8.0979060842E-01],
	[1.9045000000E+04, 1.1022528875E+01, 4.7556525096E+00, 2.1992909635E+00, 1.3232915510E+00, 8.0989299576E-01],
	[1.9050000000E+04, 1.1026788391E+01, 4.7555010353E+00, 2.2011670955E+00, 1.3240202303E+00, 8.0999533458E-01],
	[1.9055000000E+04, 1.1031048434E+01, 4.7553496056E+00, 2.2030443348E+00, 1.3247489173E+00, 8.1009762491E-01],
	[1.9060000000E+04, 1.1035309004E+01, 4.7551982205E+00, 2.2049226818E+00, 1.3254776119E+00, 8.1019986675E-01],
	[1.9065000000E+04, 1.1039570102E+01, 4.7550468798E+00, 2.2068021368E+00, 1.3262063138E+00, 8.1030206011E-01],
	[1.9070000000E+04, 1.1043831727E+01, 4.7548955837E+00, 2.2086827003E+00, 1.3269350227E+00, 8.1040420500E-01],
	[1.9075000000E+04, 1.1048093879E+01, 4.7547443320E+00, 2.2105643725E+00, 1.3276637386E+00, 8.1050630144E-01],
	[1.9080000000E+04, 1.1052356559E+01, 4.7545931248E+00, 2.2124471539E+00, 1.3283924611E+00, 8.1060834943E-01],
	[1.9085000000E+04, 1.1056619765E+01, 4.7544419620E+00, 2.2143310448E+00, 1.3291211900E+00, 8.1071034898E-01],
	[1.9090000000E+04, 1.1060883499E+01, 4.7542908437E+00, 2.2162160455E+00, 1.3298499251E+00, 8.1081230011E-01],
	[1.9095000000E+04, 1.1065147760E+01, 4.7541397697E+00, 2.2181021565E+00, 1.3305786662E+00, 8.1091420282E-01],
	[1.9100000000E+04, 1.1069412547E+01, 4.7539887400E+00, 2.2199893781E+00, 1.3313074131E+00, 8.1101605712E-01],
	[1.9105000000E+04, 1.1073677862E+01, 4.7538377547E+00, 2.2218777106E+00, 1.3320361656E+00, 8.1111786304E-01],
	[1.9110000000E+04, 1.1077943703E+01, 4.7536868137E+00, 2.2237671544E+00, 1.3327649233E+00, 8.1121962057E-01],
	[1.9115000000E+04, 1.1082210071E+01, 4.7535359169E+00, 2.2256577100E+00, 1.3334936862E+00, 8.1132132972E-01],
	[1.9120000000E+04, 1.1086476965E+01, 4.7533850644E+00, 2.2275493775E+00, 1.3342224540E+00, 8.1142299052E-01],
	[1.9125000000E+04, 1.1090748937E+01, 4.7532352705E+00, 2.2294421575E+00, 1.3349513724E+00, 8.1152460296E-01],
	[1.9130000000E+04, 1.1095039610E+01, 4.7530895684E+00, 2.2313360502E+00, 1.3356808786E+00, 8.1162616706E-01],
	[1.9135000000E+04, 1.1099330821E+01, 4.7529439089E+00, 2.2332310561E+00, 1.3364103901E+00, 8.1172768283E-01],
	[1.9140000000E+04, 1.1103622569E+01, 4.7527982919E+00, 2.2351271755E+00, 1.3371399068E+00, 8.1182915028E-01],
	[1.9145000000E+04, 1.1107914856E+01, 4.7526527174E+00, 2.2370244087E+00, 1.3378694285E+00, 8.1193056943E-01],
	[1.9150000000E+04, 1.1112207680E+01, 4.7525071854E+00, 2.2389227562E+00, 1.3385989549E+00, 8.1203194027E-01],
	[1.9155000000E+04, 1.1116501042E+01, 4.7523616958E+00, 2.2408222182E+00, 1.3393284859E+00, 8.1213326283E-01],
	[1.9160000000E+04, 1.1120794941E+01, 4.7522162487E+00, 2.2427227952E+00, 1.3400580212E+00, 8.1223453711E-01],
	[1.9165000000E+04, 1.1125089378E+01, 4.7520708439E+00, 2.2446244875E+00, 1.3407875606E+00, 8.1233576313E-01],
	[1.9170000000E+04, 1.1129384353E+01, 4.7519254815E+00, 2.2465272955E+00, 1.3415171039E+00, 8.1243694090E-01],
	[1.9175000000E+04, 1.1133679864E+01, 4.7517801615E+00, 2.2484312195E+00, 1.3422466509E+00, 8.1253807042E-01],
	[1.9180000000E+04, 1.1137975914E+01, 4.7516348838E+00, 2.2503362599E+00, 1.3429762013E+00, 8.1263915171E-01],
	[1.9185000000E+04, 1.1142272500E+01, 4.7514896484E+00, 2.2522424171E+00, 1.3437057549E+00, 8.1274018478E-01],
	[1.9190000000E+04, 1.1146569624E+01, 4.7513444553E+00, 2.2541496914E+00, 1.3444353116E+00, 8.1284116963E-01],
	[1.9195000000E+04, 1.1150867284E+01, 4.7511993045E+00, 2.2560580832E+00, 1.3451648710E+00, 8.1294210630E-01],
	[1.9200000000E+04, 1.1155165482E+01, 4.7510541959E+00, 2.2579675928E+00, 1.3458944330E+00, 8.1304299477E-01],
	[1.9205000000E+04, 1.1159464217E+01, 4.7509091295E+00, 2.2598782207E+00, 1.3466239974E+00, 8.1314383506E-01],
	[1.9210000000E+04, 1.1163763488E+01, 4.7507641053E+00, 2.2617899671E+00, 1.3473535639E+00, 8.1324462719E-01],
	[1.9215000000E+04, 1.1168063297E+01, 4.7506191233E+00, 2.2637028325E+00, 1.3480831324E+00, 8.1334537117E-01],
	[1.9220000000E+04, 1.1172363642E+01, 4.7504741834E+00, 2.2656168172E+00, 1.3488127026E+00, 8.1344606701E-01],
	[1.9225000000E+04, 1.1176664523E+01, 4.7503292856E+00, 2.2675319216E+00, 1.3495422742E+00, 8.1354671471E-01],
	[1.9230000000E+04, 1.1180965942E+01, 4.7501844299E+00, 2.2694481460E+00, 1.3502718472E+00, 8.1364731429E-01],
	[1.9235000000E+04, 1.1185267897E+01, 4.7500396163E+00, 2.2713654908E+00, 1.3510014212E+00, 8.1374786577E-01],
	[1.9240000000E+04, 1.1189570388E+01, 4.7498948448E+00, 2.2732839563E+00, 1.3517309960E+00, 8.1384836915E-01],
	[1.9245000000E+04, 1.1193873416E+01, 4.7497501153E+00, 2.2752035430E+00, 1.3524605715E+00, 8.1394882444E-01],
	[1.9250000000E+04, 1.1198176980E+01, 4.7496054278E+00, 2.2771242512E+00, 1.3531901474E+00, 8.1404923165E-01],
	[1.9255000000E+04, 1.1202481080E+01, 4.7494607822E+00, 2.2790460812E+00, 1.3539197235E+00, 8.1414959081E-01],
	[1.9260000000E+04, 1.1206785716E+01, 4.7493161787E+00, 2.2809690335E+00, 1.3546492996E+00, 8.1424990191E-01],
	[1.9265000000E+04, 1.1211090889E+01, 4.7491716170E+00, 2.2828931083E+00, 1.3553788754E+00, 8.1435016497E-01],
	[1.9270000000E+04, 1.1215396597E+01, 4.7490270973E+00, 2.2848183060E+00, 1.3561084508E+00, 8.1445038001E-01],
	[1.9275000000E+04, 1.1219702841E+01, 4.7488826195E+00, 2.2867446271E+00, 1.3568380255E+00, 8.1455054702E-01],
	[1.9280000000E+04, 1.1224009622E+01, 4.7487381835E+00, 2.2886720718E+00, 1.3575675994E+00, 8.1465066604E-01],
	[1.9285000000E+04, 1.1228316938E+01, 4.7485937894E+00, 2.2906006406E+00, 1.3582971722E+00, 8.1475073706E-01],
	[1.9290000000E+04, 1.1232624789E+01, 4.7484494371E+00, 2.2925303338E+00, 1.3590267436E+00, 8.1485076009E-01],
	[1.9295000000E+04, 1.1236933177E+01, 4.7483051266E+00, 2.2944611517E+00, 1.3597563135E+00, 8.1495073516E-01],
	[1.9300000000E+04, 1.1241242100E+01, 4.7481608578E+00, 2.2963930947E+00, 1.3604858817E+00, 8.1505066227E-01],
	[1.9305000000E+04, 1.1245551558E+01, 4.7480166309E+00, 2.2983261633E+00, 1.3612154480E+00, 8.1515054143E-01],
	[1.9310000000E+04, 1.1249861552E+01, 4.7478724456E+00, 2.3002603577E+00, 1.3619450120E+00, 8.1525037266E-01],
	[1.9315000000E+04, 1.1254172082E+01, 4.7477283021E+00, 2.3021956783E+00, 1.3626745737E+00, 8.1535015596E-01],
	[1.9320000000E+04, 1.1258483146E+01, 4.7475842002E+00, 2.3041321255E+00, 1.3634041328E+00, 8.1544989135E-01],
	[1.9325000000E+04, 1.1262794746E+01, 4.7474401400E+00, 2.3060696996E+00, 1.3641336891E+00, 8.1554957884E-01],
	[1.9330000000E+04, 1.1267106881E+01, 4.7472961215E+00, 2.3080084010E+00, 1.3648632423E+00, 8.1564921845E-01],
	[1.9335000000E+04, 1.1271419551E+01, 4.7471521445E+00, 2.3099482301E+00, 1.3655927923E+00, 8.1574881018E-01],
	[1.9340000000E+04, 1.1275732756E+01, 4.7470082092E+00, 2.3118891873E+00, 1.3663223389E+00, 8.1584835405E-01],
	[1.9345000000E+04, 1.1280046496E+01, 4.7468643154E+00, 2.3138312728E+00, 1.3670518818E+00, 8.1594785006E-01],
	[1.9350000000E+04, 1.1284360771E+01, 4.7467204632E+00, 2.3157744871E+00, 1.3677814208E+00, 8.1604729823E-01],
	[1.9355000000E+04, 1.1288675580E+01, 4.7465766525E+00, 2.3177188305E+00, 1.3685109557E+00, 8.1614669858E-01],
	[1.9360000000E+04, 1.1292990924E+01, 4.7464328832E+00, 2.3196643035E+00, 1.3692404863E+00, 8.1624605111E-01],
	[1.9365000000E+04, 1.1297306803E+01, 4.7462891555E+00, 2.3216109062E+00, 1.3699700124E+00, 8.1634535584E-01],
	[1.9370000000E+04, 1.1301623217E+01, 4.7461454692E+00, 2.3235586392E+00, 1.3706995337E+00, 8.1644461278E-01],
	[1.9375000000E+04, 1.1305940165E+01, 4.7460018244E+00, 2.3255075028E+00, 1.3714290501E+00, 8.1654382193E-01],
	[1.9380000000E+04, 1.1310257647E+01, 4.7458582210E+00, 2.3274574974E+00, 1.3721585614E+00, 8.1664298332E-01],
	[1.9385000000E+04, 1.1314575664E+01, 4.7457146589E+00, 2.3294086232E+00, 1.3728880672E+00, 8.1674209696E-01],
	[1.9390000000E+04, 1.1318894215E+01, 4.7455711383E+00, 2.3313608807E+00, 1.3736175675E+00, 8.1684116285E-01],
	[1.9395000000E+04, 1.1323213300E+01, 4.7454276589E+00, 2.3333142703E+00, 1.3743470620E+00, 8.1694018101E-01],
	[1.9400000000E+04, 1.1327532920E+01, 4.7452842209E+00, 2.3352687922E+00, 1.3750765505E+00, 8.1703915146E-01],
	[1.9405000000E+04, 1.1331853073E+01, 4.7451408242E+00, 2.3372244470E+00, 1.3758060327E+00, 8.1713807420E-01],
	[1.9410000000E+04, 1.1336173761E+01, 4.7449974688E+00, 2.3391812348E+00, 1.3765355085E+00, 8.1723694924E-01],
	[1.9415000000E+04, 1.1340494982E+01, 4.7448541546E+00, 2.3411391562E+00, 1.3772649777E+00, 8.1733577660E-01],
	[1.9420000000E+04, 1.1344816737E+01, 4.7447108816E+00, 2.3430982114E+00, 1.3779944400E+00, 8.1743455630E-01],
	[1.9425000000E+04, 1.1349139026E+01, 4.7445676499E+00, 2.3450584008E+00, 1.3787238952E+00, 8.1753328834E-01],
	[1.9430000000E+04, 1.1353461849E+01, 4.7444244593E+00, 2.3470197249E+00, 1.3794533432E+00, 8.1763197273E-01],
	[1.9435000000E+04, 1.1357799618E+01, 4.7442844317E+00, 2.3489821839E+00, 1.3801832607E+00, 8.1773060949E-01],
	[1.9440000000E+04, 1.1362146531E+01, 4.7441463068E+00, 2.3509457782E+00, 1.3809134561E+00, 8.1782919864E-01],
	[1.9445000000E+04, 1.1366493989E+01, 4.7440082215E+00, 2.3529105082E+00, 1.3816436447E+00, 8.1792774017E-01],
	[1.9450000000E+04, 1.1370841993E+01, 4.7438701758E+00, 2.3548763742E+00, 1.3823738264E+00, 8.1802623412E-01],
	[1.9455000000E+04, 1.1375190541E+01, 4.7437321695E+00, 2.3568433767E+00, 1.3831040010E+00, 8.1812468048E-01],
	[1.9460000000E+04, 1.1379539634E+01, 4.7435942027E+00, 2.3588115159E+00, 1.3838341682E+00, 8.1822307927E-01],
	[1.9465000000E+04, 1.1383889272E+01, 4.7434562753E+00, 2.3607807923E+00, 1.3845643278E+00, 8.1832143051E-01],
	[1.9470000000E+04, 1.1388239455E+01, 4.7433183874E+00, 2.3627512061E+00, 1.3852944796E+00, 8.1841973420E-01],
	[1.9475000000E+04, 1.1392590182E+01, 4.7431805389E+00, 2.3647227579E+00, 1.3860246234E+00, 8.1851799036E-01],
	[1.9480000000E+04, 1.1396941454E+01, 4.7430427298E+00, 2.3666954479E+00, 1.3867547590E+00, 8.1861619901E-01],
	[1.9485000000E+04, 1.1401293271E+01, 4.7429049600E+00, 2.3686692764E+00, 1.3874848862E+00, 8.1871436015E-01],
	[1.9490000000E+04, 1.1405645632E+01, 4.7427672296E+00, 2.3706442440E+00, 1.3882150048E+00, 8.1881247379E-01],
	[1.9495000000E+04, 1.1409998538E+01, 4.7426295386E+00, 2.3726203509E+00, 1.3889451145E+00, 8.1891053996E-01],
	[1.9500000000E+04, 1.1414351988E+01, 4.7424918868E+00, 2.3745975974E+00, 1.3896752151E+00, 8.1900855866E-01],
	[1.9505000000E+04, 1.1418705982E+01, 4.7423542743E+00, 2.3765759841E+00, 1.3904053065E+00, 8.1910652990E-01],
	[1.9510000000E+04, 1.1423060520E+01, 4.7422167011E+00, 2.3785555111E+00, 1.3911353884E+00, 8.1920445370E-01],
	[1.9515000000E+04, 1.1427415603E+01, 4.7420791671E+00, 2.3805361789E+00, 1.3918654607E+00, 8.1930233008E-01],
	[1.9520000000E+04, 1.1431771230E+01, 4.7419416724E+00, 2.3825179879E+00, 1.3925955230E+00, 8.1940015903E-01],
	[1.9525000000E+04, 1.1436127400E+01, 4.7418042168E+00, 2.3845009384E+00, 1.3933255753E+00, 8.1949794059E-01],
	[1.9530000000E+04, 1.1440484115E+01, 4.7416668005E+00, 2.3864850308E+00, 1.3940556172E+00, 8.1959567475E-01],
	[1.9535000000E+04, 1.1444841373E+01, 4.7415294232E+00, 2.3884702655E+00, 1.3947856487E+00, 8.1969336154E-01],
	[1.9540000000E+04, 1.1449199175E+01, 4.7413920852E+00, 2.3904566427E+00, 1.3955156694E+00, 8.1979100097E-01],
	[1.9545000000E+04, 1.1453557521E+01, 4.7412547862E+00, 2.3924441629E+00, 1.3962456791E+00, 8.1988859304E-01],
	[1.9550000000E+04, 1.1457916411E+01, 4.7411175263E+00, 2.3944328265E+00, 1.3969756777E+00, 8.1998613777E-01],
	[1.9555000000E+04, 1.1462275844E+01, 4.7409803055E+00, 2.3964226338E+00, 1.3977056650E+00, 8.2008363518E-01],
	[1.9560000000E+04, 1.1466635821E+01, 4.7408431238E+00, 2.3984135851E+00, 1.3984356407E+00, 8.2018108528E-01],
	[1.9565000000E+04, 1.1470996341E+01, 4.7407059811E+00, 2.4004056809E+00, 1.3991656046E+00, 8.2027848808E-01],
	[1.9570000000E+04, 1.1475357404E+01, 4.7405688773E+00, 2.4023989215E+00, 1.3998955566E+00, 8.2037584360E-01],
	[1.9575000000E+04, 1.1479719011E+01, 4.7404318126E+00, 2.4043933072E+00, 1.4006254964E+00, 8.2047315184E-01],
	[1.9580000000E+04, 1.1484081161E+01, 4.7402947869E+00, 2.4063888385E+00, 1.4013554238E+00, 8.2057041282E-01],
	[1.9585000000E+04, 1.1488443854E+01, 4.7401578001E+00, 2.4083855157E+00, 1.4020853385E+00, 8.2066762656E-01],
	[1.9590000000E+04, 1.1492807090E+01, 4.7400208522E+00, 2.4103833391E+00, 1.4028152405E+00, 8.2076479306E-01],
	[1.9595000000E+04, 1.1497170869E+01, 4.7398839432E+00, 2.4123823092E+00, 1.4035451295E+00, 8.2086191235E-01],
	[1.9600000000E+04, 1.1501535191E+01, 4.7397470731E+00, 2.4143824262E+00, 1.4042750052E+00, 8.2095898443E-01],
	[1.9605000000E+04, 1.1505900056E+01, 4.7396102419E+00, 2.4163836906E+00, 1.4050048675E+00, 8.2105600931E-01],
	[1.9610000000E+04, 1.1510265463E+01, 4.7394734495E+00, 2.4183861027E+00, 1.4057347162E+00, 8.2115298702E-01],
	[1.9615000000E+04, 1.1514631414E+01, 4.7393366959E+00, 2.4203896630E+00, 1.4064645510E+00, 8.2124991756E-01],
	[1.9620000000E+04, 1.1518997907E+01, 4.7391999811E+00, 2.4223943716E+00, 1.4071943718E+00, 8.2134680095E-01],
	[1.9625000000E+04, 1.1523364942E+01, 4.7390633051E+00, 2.4244002291E+00, 1.4079241783E+00, 8.2144363720E-01],
	[1.9630000000E+04, 1.1527732520E+01, 4.7389266679E+00, 2.4264072358E+00, 1.4086539703E+00, 8.2154042632E-01],
	[1.9635000000E+04, 1.1532100641E+01, 4.7387900694E+00, 2.4284153920E+00, 1.4093837477E+00, 8.2163716833E-01],
	[1.9640000000E+04, 1.1536469304E+01, 4.7386535096E+00, 2.4304246982E+00, 1.4101135102E+00, 8.2173386324E-01],
	[1.9645000000E+04, 1.1540838509E+01, 4.7385169885E+00, 2.4324351546E+00, 1.4108432576E+00, 8.2183051106E-01],
	[1.9650000000E+04, 1.1545208256E+01, 4.7383805061E+00, 2.4344467616E+00, 1.4115729897E+00, 8.2192711181E-01],
	[1.9655000000E+04, 1.1549578546E+01, 4.7382440624E+00, 2.4364595197E+00, 1.4123027064E+00, 8.2202366551E-01],
	[1.9660000000E+04, 1.1553949377E+01, 4.7381076572E+00, 2.4384734292E+00, 1.4130324073E+00, 8.2212017216E-01],
	[1.9665000000E+04, 1.1558320751E+01, 4.7379712907E+00, 2.4404884903E+00, 1.4137620923E+00, 8.2221663178E-01],
	[1.9670000000E+04, 1.1562692667E+01, 4.7378349628E+00, 2.4425047036E+00, 1.4144917612E+00, 8.2231304438E-01],
	[1.9675000000E+04, 1.1567065124E+01, 4.7376986734E+00, 2.4445220694E+00, 1.4152214138E+00, 8.2240940997E-01],
	[1.9680000000E+04, 1.1571438123E+01, 4.7375624226E+00, 2.4465405880E+00, 1.4159510498E+00, 8.2250572858E-01],
	[1.9685000000E+04, 1.1575811664E+01, 4.7374262104E+00, 2.4485602598E+00, 1.4166806692E+00, 8.2260200021E-01],
	[1.9690000000E+04, 1.1580185747E+01, 4.7372900366E+00, 2.4505810852E+00, 1.4174102715E+00, 8.2269822487E-01],
	[1.9695000000E+04, 1.1584560371E+01, 4.7371539013E+00, 2.4526030645E+00, 1.4181398568E+00, 8.2279440259E-01],
	[1.9700000000E+04, 1.1588935537E+01, 4.7370178045E+00, 2.4546261981E+00, 1.4188694247E+00, 8.2289053337E-01],
	[1.9705000000E+04, 1.1593311244E+01, 4.7368817461E+00, 2.4566504864E+00, 1.4195989750E+00, 8.2298661723E-01],
	[1.9710000000E+04, 1.1597687492E+01, 4.7367457262E+00, 2.4586759297E+00, 1.4203285076E+00, 8.2308265418E-01],
	[1.9715000000E+04, 1.1602064282E+01, 4.7366097447E+00, 2.4607025284E+00, 1.4210580223E+00, 8.2317864424E-01],
	[1.9720000000E+04, 1.1606441613E+01, 4.7364738015E+00, 2.4627302828E+00, 1.4217875188E+00, 8.2327458742E-01],
	[1.9725000000E+04, 1.1610819485E+01, 4.7363378967E+00, 2.4647591934E+00, 1.4225169969E+00, 8.2337048373E-01],
	[1.9730000000E+04, 1.1615197898E+01, 4.7362020303E+00, 2.4667892605E+00, 1.4232464564E+00, 8.2346633319E-01],
	[1.9735000000E+04, 1.1619576853E+01, 4.7360662022E+00, 2.4688204844E+00, 1.4239758971E+00, 8.2356213581E-01],
	[1.9740000000E+04, 1.1623956348E+01, 4.7359304123E+00, 2.4708528656E+00, 1.4247053189E+00, 8.2365789160E-01],
	[1.9745000000E+04, 1.1628337805E+01, 4.7357949600E+00, 2.4728864044E+00, 1.4254347700E+00, 8.2375360058E-01],
	[1.9750000000E+04, 1.1632741697E+01, 4.7356641546E+00, 2.4749211011E+00, 1.4261649487E+00, 8.2384926277E-01],
	[1.9755000000E+04, 1.1637146141E+01, 4.7355333859E+00, 2.4769569561E+00, 1.4268951091E+00, 8.2394487817E-01],
	[1.9760000000E+04, 1.1641551138E+01, 4.7354026539E+00, 2.4789939698E+00, 1.4276252509E+00, 8.2404044681E-01],
	[1.9765000000E+04, 1.1645956687E+01, 4.7352719586E+00, 2.4810321426E+00, 1.4283553739E+00, 8.2413596869E-01],
	[1.9770000000E+04, 1.1650362788E+01, 4.7351412999E+00, 2.4830714748E+00, 1.4290854778E+00, 8.2423144383E-01],
	[1.9775000000E+04, 1.1654769441E+01, 4.7350106780E+00, 2.4851119668E+00, 1.4298155626E+00, 8.2432687224E-01],
	[1.9780000000E+04, 1.1659176647E+01, 4.7348800926E+00, 2.4871536189E+00, 1.4305456279E+00, 8.2442225394E-01],
	[1.9785000000E+04, 1.1663584405E+01, 4.7347495438E+00, 2.4891964316E+00, 1.4312756736E+00, 8.2451758895E-01],
	[1.9790000000E+04, 1.1667992714E+01, 4.7346190316E+00, 2.4912404051E+00, 1.4320056994E+00, 8.2461287726E-01],
	[1.9795000000E+04, 1.1672401575E+01, 4.7344885560E+00, 2.4932855399E+00, 1.4327357053E+00, 8.2470811891E-01],
	[1.9800000000E+04, 1.1676810989E+01, 4.7343581170E+00, 2.4953318363E+00, 1.4334656909E+00, 8.2480331390E-01],
	[1.9805000000E+04, 1.1681220954E+01, 4.7342277144E+00, 2.4973792947E+00, 1.4341956561E+00, 8.2489846225E-01],
	[1.9810000000E+04, 1.1685631470E+01, 4.7340973484E+00, 2.4994279154E+00, 1.4349256006E+00, 8.2499356398E-01],
	[1.9815000000E+04, 1.1690042538E+01, 4.7339670188E+00, 2.5014776989E+00, 1.4356555244E+00, 8.2508861908E-01],
	[1.9820000000E+04, 1.1694454158E+01, 4.7338367258E+00, 2.5035286454E+00, 1.4363854270E+00, 8.2518362759E-01],
	[1.9825000000E+04, 1.1698866329E+01, 4.7337064691E+00, 2.5055807554E+00, 1.4371153085E+00, 8.2527858952E-01],
	[1.9830000000E+04, 1.1703279052E+01, 4.7335762490E+00, 2.5076340292E+00, 1.4378451685E+00, 8.2537350488E-01],
	[1.9835000000E+04, 1.1707692326E+01, 4.7334460652E+00, 2.5096884672E+00, 1.4385750069E+00, 8.2546837368E-01],
	[1.9840000000E+04, 1.1712106151E+01, 4.7333159178E+00, 2.5117440697E+00, 1.4393048234E+00, 8.2556319593E-01],
	[1.9845000000E+04, 1.1716520527E+01, 4.7331858068E+00, 2.5138008371E+00, 1.4400346179E+00, 8.2565797166E-01],
	[1.9850000000E+04, 1.1720935454E+01, 4.7330557321E+00, 2.5158587698E+00, 1.4407643901E+00, 8.2575270088E-01],
	[1.9855000000E+04, 1.1725350933E+01, 4.7329256938E+00, 2.5179178682E+00, 1.4414941399E+00, 8.2584738360E-01],
	[1.9860000000E+04, 1.1729766962E+01, 4.7327956917E+00, 2.5199781325E+00, 1.4422238671E+00, 8.2594201984E-01],
	[1.9865000000E+04, 1.1734183543E+01, 4.7326657260E+00, 2.5220395633E+00, 1.4429535714E+00, 8.2603660960E-01],
	[1.9870000000E+04, 1.1738600674E+01, 4.7325357966E+00, 2.5241021607E+00, 1.4436832526E+00, 8.2613115291E-01],
	[1.9875000000E+04, 1.1743018356E+01, 4.7324059034E+00, 2.5261659253E+00, 1.4444129107E+00, 8.2622564978E-01],
	[1.9880000000E+04, 1.1747436588E+01, 4.7322760464E+00, 2.5282308574E+00, 1.4451425452E+00, 8.2632010022E-01],
	[1.9885000000E+04, 1.1751855372E+01, 4.7321462257E+00, 2.5302969573E+00, 1.4458721562E+00, 8.2641450426E-01],
	[1.9890000000E+04, 1.1756274705E+01, 4.7320164412E+00, 2.5323642254E+00, 1.4466017432E+00, 8.2650886189E-01],
	[1.9895000000E+04, 1.1760694590E+01, 4.7318866928E+00, 2.5344326621E+00, 1.4473313063E+00, 8.2660317315E-01],
	[1.9900000000E+04, 1.1765115024E+01, 4.7317569806E+00, 2.5365022678E+00, 1.4480608451E+00, 8.2669743803E-01],
	[1.9905000000E+04, 1.1769536009E+01, 4.7316273045E+00, 2.5385730427E+00, 1.4487903594E+00, 8.2679165656E-01],
	[1.9910000000E+04, 1.1773957544E+01, 4.7314976646E+00, 2.5406449873E+00, 1.4495198491E+00, 8.2688582876E-01],
	[1.9915000000E+04, 1.1778379630E+01, 4.7313680608E+00, 2.5427181020E+00, 1.4502493140E+00, 8.2697995463E-01],
	[1.9920000000E+04, 1.1782802265E+01, 4.7312384930E+00, 2.5447923871E+00, 1.4509787538E+00, 8.2707403419E-01],
	[1.9925000000E+04, 1.1787225451E+01, 4.7311089613E+00, 2.5468678429E+00, 1.4517081684E+00, 8.2716806745E-01],
	[1.9930000000E+04, 1.1791649187E+01, 4.7309794657E+00, 2.5489444699E+00, 1.4524375575E+00, 8.2726205444E-01],
	[1.9935000000E+04, 1.1796073472E+01, 4.7308500061E+00, 2.5510222684E+00, 1.4531669210E+00, 8.2735599516E-01],
	[1.9940000000E+04, 1.1800498308E+01, 4.7307205825E+00, 2.5531012388E+00, 1.4538962587E+00, 8.2744988963E-01],
	[1.9945000000E+04, 1.1804923693E+01, 4.7305911949E+00, 2.5551813814E+00, 1.4546255703E+00, 8.2754373787E-01],
	[1.9950000000E+04, 1.1809349628E+01, 4.7304618432E+00, 2.5572626966E+00, 1.4553548557E+00, 8.2763753988E-01],
	[1.9955000000E+04, 1.1813776112E+01, 4.7303325275E+00, 2.5593451848E+00, 1.4560841146E+00, 8.2773129569E-01],
	[1.9960000000E+04, 1.1818203146E+01, 4.7302032478E+00, 2.5614288463E+00, 1.4568133470E+00, 8.2782500531E-01],
	[1.9965000000E+04, 1.1822630730E+01, 4.7300740039E+00, 2.5635136816E+00, 1.4575425525E+00, 8.2791866875E-01],
	[1.9970000000E+04, 1.1827058863E+01, 4.7299447960E+00, 2.5655996909E+00, 1.4582717309E+00, 8.2801228603E-01],
	[1.9975000000E+04, 1.1831487545E+01, 4.7298156239E+00, 2.5676868747E+00, 1.4590008822E+00, 8.2810585717E-01],
	[1.9980000000E+04, 1.1835916777E+01, 4.7296864877E+00, 2.5697752333E+00, 1.4597300060E+00, 8.2819938217E-01],
	[1.9985000000E+04, 1.1840346558E+01, 4.7295573873E+00, 2.5718647670E+00, 1.4604591022E+00, 8.2829286106E-01],
	[1.9990000000E+04, 1.1844776888E+01, 4.7294283227E+00, 2.5739554763E+00, 1.4611881706E+00, 8.2838629384E-01],
	[1.9995000000E+04, 1.1849207767E+01, 4.7292992939E+00, 2.5760473615E+00, 1.4619172110E+00, 8.2847968054E-01],
	[2.0000000000E+04, 1.1853639195E+01, 4.7291703009E+00, 2.5781404230E+00, 1.4626462232E+00, 8.2857302116E-01],
	[2.0005000000E+04, 1.1858071173E+01, 4.7290413437E+00, 2.5802375196E+00, 1.4633761264E+00, 8.2866631573E-01],
	[2.0010000000E+04, 1.1862503699E+01, 4.7289124222E+00, 2.5823357970E+00, 1.4641060011E+00, 8.2875956426E-01],
	[2.0015000000E+04, 1.1866936773E+01, 4.7287835365E+00, 2.5844352558E+00, 1.4648358471E+00, 8.2885276677E-01],
	[2.0020000000E+04, 1.1871370397E+01, 4.7286546864E+00, 2.5865358962E+00, 1.4655656642E+00, 8.2894592326E-01],
	[2.0025000000E+04, 1.1875804569E+01, 4.7285258720E+00, 2.5886377186E+00, 1.4662954521E+00, 8.2903903375E-01],
	[2.0030000000E+04, 1.1880239290E+01, 4.7283970933E+00, 2.5907407233E+00, 1.4670252108E+00, 8.2913209826E-01],
	[2.0035000000E+04, 1.1884674560E+01, 4.7282683503E+00, 2.5928449109E+00, 1.4677549400E+00, 8.2922511681E-01],
	[2.0040000000E+04, 1.1889110377E+01, 4.7281396428E+00, 2.5949502815E+00, 1.4684846396E+00, 8.2931808940E-01],
	[2.0045000000E+04, 1.1893546744E+01, 4.7280109710E+00, 2.5970568357E+00, 1.4692143092E+00, 8.2941101606E-01],
	[2.0050000000E+04, 1.1897983658E+01, 4.7278823348E+00, 2.5991645737E+00, 1.4699439487E+00, 8.2950389680E-01],
	[2.0055000000E+04, 1.1902421121E+01, 4.7277537341E+00, 2.6012734959E+00, 1.4706735580E+00, 8.2959673162E-01],
	[2.0060000000E+04, 1.1906859132E+01, 4.7276251690E+00, 2.6033836028E+00, 1.4714031368E+00, 8.2968952055E-01],
	[2.0065000000E+04, 1.1911309181E+01, 4.7274989978E+00, 2.6054948946E+00, 1.4721330891E+00, 8.2978226358E-01],
	[2.0070000000E+04, 1.1915771823E+01, 4.7273753313E+00, 2.6076073717E+00, 1.4728634348E+00, 8.2987496075E-01],
	[2.0075000000E+04, 1.1920235024E+01, 4.7272516989E+00, 2.6097210346E+00, 1.4735937506E+00, 8.2996761205E-01],
	[2.0080000000E+04, 1.1924698785E+01, 4.7271281005E+00, 2.6118358835E+00, 1.4743240364E+00, 8.3006021751E-01],
	[2.0085000000E+04, 1.1929163105E+01, 4.7270045360E+00, 2.6139519189E+00, 1.4750542919E+00, 8.3015277713E-01],
	[2.0090000000E+04, 1.1933627985E+01, 4.7268810056E+00, 2.6160691411E+00, 1.4757845170E+00, 8.3024529092E-01],
	[2.0095000000E+04, 1.1938093424E+01, 4.7267575091E+00, 2.6181875505E+00, 1.4765147114E+00, 8.3033775891E-01],
	[2.0100000000E+04, 1.1942559423E+01, 4.7266340466E+00, 2.6203071474E+00, 1.4772448749E+00, 8.3043018110E-01],
	[2.0105000000E+04, 1.1947025980E+01, 4.7265106180E+00, 2.6224279323E+00, 1.4779750074E+00, 8.3052255751E-01],
	[2.0110000000E+04, 1.1951493097E+01, 4.7263872234E+00, 2.6245499055E+00, 1.4787051087E+00, 8.3061488815E-01],
	[2.0115000000E+04, 1.1955960774E+01, 4.7262638626E+00, 2.6266730673E+00, 1.4794351786E+00, 8.3070717302E-01],
	[2.0120000000E+04, 1.1960429009E+01, 4.7261405357E+00, 2.6287974182E+00, 1.4801652168E+00, 8.3079941216E-01],
	[2.0125000000E+04, 1.1964897803E+01, 4.7260172427E+00, 2.6309229585E+00, 1.4808952232E+00, 8.3089160556E-01],
	[2.0130000000E+04, 1.1969367157E+01, 4.7258939835E+00, 2.6330496886E+00, 1.4816251975E+00, 8.3098375324E-01],
	[2.0135000000E+04, 1.1973837069E+01, 4.7257707581E+00, 2.6351776088E+00, 1.4823551397E+00, 8.3107585522E-01],
	[2.0140000000E+04, 1.1978307540E+01, 4.7256475665E+00, 2.6373067195E+00, 1.4830850495E+00, 8.3116791150E-01],
	[2.0145000000E+04, 1.1982778569E+01, 4.7255244088E+00, 2.6394370212E+00, 1.4838149266E+00, 8.3125992211E-01],
	[2.0150000000E+04, 1.1987250158E+01, 4.7254012848E+00, 2.6415685140E+00, 1.4845447710E+00, 8.3135188705E-01],
	[2.0155000000E+04, 1.1991722305E+01, 4.7252781945E+00, 2.6437011986E+00, 1.4852745824E+00, 8.3144380633E-01],
	[2.0160000000E+04, 1.1996195010E+01, 4.7251551380E+00, 2.6458350751E+00, 1.4860043606E+00, 8.3153567998E-01],
	[2.0165000000E+04, 1.2000668274E+01, 4.7250321152E+00, 2.6479701440E+00, 1.4867341055E+00, 8.3162750799E-01],
	[2.0170000000E+04, 1.2005142096E+01, 4.7249091261E+00, 2.6501064056E+00, 1.4874638168E+00, 8.3171929040E-01],
	[2.0175000000E+04, 1.2009616477E+01, 4.7247861707E+00, 2.6522438603E+00, 1.4881934943E+00, 8.3181102720E-01],
	[2.0180000000E+04, 1.2014091416E+01, 4.7246632490E+00, 2.6543825085E+00, 1.4889231379E+00, 8.3190271842E-01],
	[2.0185000000E+04, 1.2018566913E+01, 4.7245403609E+00, 2.6565223506E+00, 1.4896527473E+00, 8.3199436406E-01],
	[2.0190000000E+04, 1.2023042968E+01, 4.7244175065E+00, 2.6586633869E+00, 1.4903823224E+00, 8.3208596414E-01],
	[2.0195000000E+04, 1.2027519581E+01, 4.7242946856E+00, 2.6608056177E+00, 1.4911118630E+00, 8.3217751867E-01],
	[2.0200000000E+04, 1.2031996752E+01, 4.7241718984E+00, 2.6629490436E+00, 1.4918413688E+00, 8.3226902767E-01],
	[2.0205000000E+04, 1.2036474482E+01, 4.7240491447E+00, 2.6650936648E+00, 1.4925708398E+00, 8.3236049115E-01],
	[2.0210000000E+04, 1.2040952769E+01, 4.7239264246E+00, 2.6672394816E+00, 1.4933002756E+00, 8.3245190913E-01],
	[2.0215000000E+04, 1.2045431613E+01, 4.7238037381E+00, 2.6693864946E+00, 1.4940296761E+00, 8.3254328160E-01],
	[2.0220000000E+04, 1.2049911016E+01, 4.7236810851E+00, 2.6715347040E+00, 1.4947590412E+00, 8.3263460860E-01],
	[2.0225000000E+04, 1.2054390976E+01, 4.7235584655E+00, 2.6736841102E+00, 1.4954883706E+00, 8.3272589013E-01],
	[2.0230000000E+04, 1.2058871493E+01, 4.7234358795E+00, 2.6758347135E+00, 1.4962176641E+00, 8.3281712621E-01],
	[2.0235000000E+04, 1.2063352568E+01, 4.7233133270E+00, 2.6779865145E+00, 1.4969469215E+00, 8.3290831685E-01],
	[2.0240000000E+04, 1.2067834201E+01, 4.7231908079E+00, 2.6801395133E+00, 1.4976761427E+00, 8.3299946206E-01],
	[2.0245000000E+04, 1.2072316391E+01, 4.7230683222E+00, 2.6822937105E+00, 1.4984053274E+00, 8.3309056186E-01],
	[2.0250000000E+04, 1.2076799138E+01, 4.7229458700E+00, 2.6844491063E+00, 1.4991344756E+00, 8.3318161626E-01],
	[2.0255000000E+04, 1.2081282442E+01, 4.7228234511E+00, 2.6866057012E+00, 1.4998635868E+00, 8.3327262528E-01],
	[2.0260000000E+04, 1.2085766304E+01, 4.7227010657E+00, 2.6887634955E+00, 1.5005926611E+00, 8.3336358892E-01],
	[2.0265000000E+04, 1.2090250723E+01, 4.7225787136E+00, 2.6909224895E+00, 1.5013216982E+00, 8.3345450720E-01],
	[2.0270000000E+04, 1.2094735698E+01, 4.7224563949E+00, 2.6930826837E+00, 1.5020506978E+00, 8.3354538014E-01],
	[2.0275000000E+04, 1.2099221231E+01, 4.7223341095E+00, 2.6952440784E+00, 1.5027796599E+00, 8.3363620775E-01],
	[2.0280000000E+04, 1.2103707320E+01, 4.7222118575E+00, 2.6974066740E+00, 1.5035085842E+00, 8.3372699005E-01],
	[2.0285000000E+04, 1.2108193967E+01, 4.7220896387E+00, 2.6995704709E+00, 1.5042374705E+00, 8.3381772704E-01],
	[2.0290000000E+04, 1.2112681170E+01, 4.7219674532E+00, 2.7017354694E+00, 1.5049663187E+00, 8.3390841874E-01],
	[2.0295000000E+04, 1.2117168929E+01, 4.7218453010E+00, 2.7039016699E+00, 1.5056951285E+00, 8.3399906516E-01],
	[2.0300000000E+04, 1.2121657246E+01, 4.7217231820E+00, 2.7060690728E+00, 1.5064238997E+00, 8.3408966632E-01],
	[2.0305000000E+04, 1.2126146119E+01, 4.7216010963E+00, 2.7082376784E+00, 1.5071526323E+00, 8.3418022224E-01],
	[2.0310000000E+04, 1.2130635548E+01, 4.7214790438E+00, 2.7104074871E+00, 1.5078813259E+00, 8.3427073292E-01],
	[2.0315000000E+04, 1.2135125534E+01, 4.7213570245E+00, 2.7125784993E+00, 1.5086099805E+00, 8.3436119838E-01],
	[2.0320000000E+04, 1.2139616076E+01, 4.7212350383E+00, 2.7147507154E+00, 1.5093385957E+00, 8.3445161863E-01],
	[2.0325000000E+04, 1.2144107174E+01, 4.7211130854E+00, 2.7169241357E+00, 1.5100671714E+00, 8.3454199369E-01],
	[2.0330000000E+04, 1.2148598829E+01, 4.7209911655E+00, 2.7190987606E+00, 1.5107957075E+00, 8.3463232358E-01],
	[2.0335000000E+04, 1.2153091040E+01, 4.7208692788E+00, 2.7212745905E+00, 1.5115242037E+00, 8.3472260830E-01],
	[2.0340000000E+04, 1.2157583806E+01, 4.7207474252E+00, 2.7234516257E+00, 1.5122526599E+00, 8.3481284786E-01],
	[2.0345000000E+04, 1.2162077129E+01, 4.7206256048E+00, 2.7256298666E+00, 1.5129810758E+00, 8.3490304230E-01],
	[2.0350000000E+04, 1.2166571008E+01, 4.7205038173E+00, 2.7278093136E+00, 1.5137094513E+00, 8.3499319161E-01],
	[2.0355000000E+04, 1.2171065442E+01, 4.7203820630E+00, 2.7299899671E+00, 1.5144377862E+00, 8.3508329581E-01],
	[2.0360000000E+04, 1.2175560433E+01, 4.7202603417E+00, 2.7321718274E+00, 1.5151660803E+00, 8.3517335491E-01],
	[2.0365000000E+04, 1.2180055979E+01, 4.7201386534E+00, 2.7343548949E+00, 1.5158943334E+00, 8.3526336894E-01],
	[2.0370000000E+04, 1.2184552080E+01, 4.7200169981E+00, 2.7365391699E+00, 1.5166225453E+00, 8.3535333790E-01],
	[2.0375000000E+04, 1.2189048738E+01, 4.7198953758E+00, 2.7387246529E+00, 1.5173507159E+00, 8.3544326181E-01],
	[2.0380000000E+04, 1.2193545951E+01, 4.7197737865E+00, 2.7409113442E+00, 1.5180788449E+00, 8.3553314068E-01],
	[2.0385000000E+04, 1.2198043719E+01, 4.7196522302E+00, 2.7430992442E+00, 1.5188069321E+00, 8.3562297453E-01],
	[2.0390000000E+04, 1.2202563051E+01, 4.7195349367E+00, 2.7452883532E+00, 1.5195357417E+00, 8.3571276336E-01],
	[2.0395000000E+04, 1.2207085483E+01, 4.7194181848E+00, 2.7474786717E+00, 1.5202646024E+00, 8.3580250721E-01],
	[2.0400000000E+04, 1.2211608481E+01, 4.7193014643E+00, 2.7496701999E+00, 1.5209934221E+00, 8.3589220607E-01],
	[2.0405000000E+04, 1.2216132045E+01, 4.7191847754E+00, 2.7518629383E+00, 1.5217222004E+00, 8.3598185996E-01],
	[2.0410000000E+04, 1.2220656177E+01, 4.7190681179E+00, 2.7540568873E+00, 1.5224509372E+00, 8.3607146891E-01],
	[2.0415000000E+04, 1.2225180875E+01, 4.7189514919E+00, 2.7562520472E+00, 1.5231796324E+00, 8.3616103291E-01],
	[2.0420000000E+04, 1.2229706140E+01, 4.7188348973E+00, 2.7584484183E+00, 1.5239082857E+00, 8.3625055199E-01],
	[2.0425000000E+04, 1.2234231971E+01, 4.7187183341E+00, 2.7606460011E+00, 1.5246368969E+00, 8.3634002616E-01],
	[2.0430000000E+04, 1.2238758369E+01, 4.7186018024E+00, 2.7628447959E+00, 1.5253654659E+00, 8.3642945544E-01],
	[2.0435000000E+04, 1.2243285333E+01, 4.7184853020E+00, 2.7650448031E+00, 1.5260939925E+00, 8.3651883984E-01],
	[2.0440000000E+04, 1.2247812864E+01, 4.7183688331E+00, 2.7672460231E+00, 1.5268224765E+00, 8.3660817937E-01],
	[2.0445000000E+04, 1.2252340961E+01, 4.7182523954E+00, 2.7694484562E+00, 1.5275509178E+00, 8.3669747405E-01],
	[2.0450000000E+04, 1.2256869624E+01, 4.7181359892E+00, 2.7716521028E+00, 1.5282793160E+00, 8.3678672389E-01],
	[2.0455000000E+04, 1.2261398853E+01, 4.7180196142E+00, 2.7738569633E+00, 1.5290076711E+00, 8.3687592891E-01],
	[2.0460000000E+04, 1.2265928648E+01, 4.7179032706E+00, 2.7760630381E+00, 1.5297359828E+00, 8.3696508912E-01],
	[2.0465000000E+04, 1.2270459010E+01, 4.7177869583E+00, 2.7782703275E+00, 1.5304642510E+00, 8.3705420454E-01],
	[2.0470000000E+04, 1.2274989937E+01, 4.7176706772E+00, 2.7804788318E+00, 1.5311924755E+00, 8.3714327517E-01],
	[2.0475000000E+04, 1.2279521430E+01, 4.7175544274E+00, 2.7826885516E+00, 1.5319206561E+00, 8.3723230105E-01],
	[2.0480000000E+04, 1.2284053489E+01, 4.7174382089E+00, 2.7848994870E+00, 1.5326487926E+00, 8.3732128217E-01],
	[2.0485000000E+04, 1.2288586113E+01, 4.7173220215E+00, 2.7871116386E+00, 1.5333768849E+00, 8.3741021856E-01],
	[2.0490000000E+04, 1.2293119304E+01, 4.7172058655E+00, 2.7893250067E+00, 1.5341049327E+00, 8.3749911022E-01],
	[2.0495000000E+04, 1.2297653060E+01, 4.7170897406E+00, 2.7915395916E+00, 1.5348329359E+00, 8.3758795719E-01],
	[2.0500000000E+04, 1.2302187381E+01, 4.7169736468E+00, 2.7937553938E+00, 1.5355608942E+00, 8.3767675946E-01],
	[2.0505000000E+04, 1.2306722268E+01, 4.7168575843E+00, 2.7959724135E+00, 1.5362888075E+00, 8.3776551705E-01],
	[2.0510000000E+04, 1.2311257720E+01, 4.7167415529E+00, 2.7981906512E+00, 1.5370166757E+00, 8.3785422998E-01],
	[2.0515000000E+04, 1.2315793738E+01, 4.7166255527E+00, 2.8004101073E+00, 1.5377444985E+00, 8.3794289826E-01],
	[2.0520000000E+04, 1.2320330320E+01, 4.7165095835E+00, 2.8026307820E+00, 1.5384722757E+00, 8.3803152191E-01],
	[2.0525000000E+04, 1.2324867468E+01, 4.7163936455E+00, 2.8048526759E+00, 1.5392000072E+00, 8.3812010094E-01],
	[2.0530000000E+04, 1.2329405182E+01, 4.7162777386E+00, 2.8070757892E+00, 1.5399276928E+00, 8.3820863537E-01],
	[2.0535000000E+04, 1.2333943460E+01, 4.7161618627E+00, 2.8093001223E+00, 1.5406553323E+00, 8.3829712521E-01],
	[2.0540000000E+04, 1.2338482303E+01, 4.7160460179E+00, 2.8115256756E+00, 1.5413829254E+00, 8.3838557048E-01],
	[2.0545000000E+04, 1.2343021711E+01, 4.7159302041E+00, 2.8137524495E+00, 1.5421104722E+00, 8.3847397119E-01],
	[2.0550000000E+04, 1.2347561684E+01, 4.7158144214E+00, 2.8159804444E+00, 1.5428379722E+00, 8.3856232735E-01],
	[2.0555000000E+04, 1.2352102222E+01, 4.7156986696E+00, 2.8182096605E+00, 1.5435654255E+00, 8.3865063899E-01],
	[2.0560000000E+04, 1.2356643324E+01, 4.7155829489E+00, 2.8204400984E+00, 1.5442928317E+00, 8.3873890611E-01],
	[2.0565000000E+04, 1.2361184991E+01, 4.7154672591E+00, 2.8226717583E+00, 1.5450201907E+00, 8.3882712873E-01],
	[2.0570000000E+04, 1.2365727223E+01, 4.7153516003E+00, 2.8249046406E+00, 1.5457475024E+00, 8.3891530687E-01],
	[2.0575000000E+04, 1.2370270019E+01, 4.7152359725E+00, 2.8271387457E+00, 1.5464747664E+00, 8.3900344054E-01],
	[2.0580000000E+04, 1.2374813380E+01, 4.7151203755E+00, 2.8293740741E+00, 1.5472019828E+00, 8.3909152975E-01],
	[2.0585000000E+04, 1.2379357305E+01, 4.7150048095E+00, 2.8316106259E+00, 1.5479291512E+00, 8.3917957453E-01],
	[2.0590000000E+04, 1.2383901794E+01, 4.7148892744E+00, 2.8338484017E+00, 1.5486562715E+00, 8.3926757488E-01],
	[2.0595000000E+04, 1.2388446848E+01, 4.7147737702E+00, 2.8360874018E+00, 1.5493833435E+00, 8.3935553082E-01],
	[2.0600000000E+04, 1.2392992466E+01, 4.7146582968E+00, 2.8383276265E+00, 1.5501103671E+00, 8.3944344237E-01],
	[2.0605000000E+04, 1.2397538648E+01, 4.7145428543E+00, 2.8405690763E+00, 1.5508373420E+00, 8.3953130953E-01],
	[2.0610000000E+04, 1.2402085394E+01, 4.7144274426E+00, 2.8428117515E+00, 1.5515642680E+00, 8.3961913234E-01],
	[2.0615000000E+04, 1.2406632704E+01, 4.7143120618E+00, 2.8450556524E+00, 1.5522911451E+00, 8.3970691079E-01],
	[2.0620000000E+04, 1.2411180578E+01, 4.7141967117E+00, 2.8473007796E+00, 1.5530179730E+00, 8.3979464491E-01],
	[2.0625000000E+04, 1.2415729015E+01, 4.7140813924E+00, 2.8495471332E+00, 1.5537447515E+00, 8.3988233471E-01],
	[2.0630000000E+04, 1.2420278017E+01, 4.7139661039E+00, 2.8517947138E+00, 1.5544714804E+00, 8.3996998021E-01],
	[2.0635000000E+04, 1.2424827582E+01, 4.7138508462E+00, 2.8540435216E+00, 1.5551981596E+00, 8.4005758142E-01],
	[2.0640000000E+04, 1.2429377711E+01, 4.7137356192E+00, 2.8562935570E+00, 1.5559247889E+00, 8.4014513836E-01],
	[2.0645000000E+04, 1.2433928403E+01, 4.7136204229E+00, 2.8585448205E+00, 1.5566513681E+00, 8.4023265103E-01],
	[2.0650000000E+04, 1.2438479659E+01, 4.7135052574E+00, 2.8607973123E+00, 1.5573778971E+00, 8.4032011947E-01],
	[2.0655000000E+04, 1.2443031479E+01, 4.7133901225E+00, 2.8630510330E+00, 1.5581043756E+00, 8.4040754367E-01],
	[2.0660000000E+04, 1.2447583862E+01, 4.7132750183E+00, 2.8653059827E+00, 1.5588308034E+00, 8.4049492367E-01],
	[2.0665000000E+04, 1.2452136808E+01, 4.7131599448E+00, 2.8675621620E+00, 1.5595571805E+00, 8.4058225946E-01],
	[2.0670000000E+04, 1.2456690317E+01, 4.7130449019E+00, 2.8698195711E+00, 1.5602835065E+00, 8.4066955108E-01],
	[2.0675000000E+04, 1.2461244390E+01, 4.7129298897E+00, 2.8720782105E+00, 1.5610097814E+00, 8.4075679853E-01],
	[2.0680000000E+04, 1.2465799026E+01, 4.7128149081E+00, 2.8743380805E+00, 1.5617360049E+00, 8.4084400183E-01],
	[2.0685000000E+04, 1.2470354224E+01, 4.7126999571E+00, 2.8765991815E+00, 1.5624621769E+00, 8.4093116099E-01],
	[2.0690000000E+04, 1.2474909986E+01, 4.7125850366E+00, 2.8788615139E+00, 1.5631882972E+00, 8.4101827603E-01],
	[2.0695000000E+04, 1.2479466311E+01, 4.7124701467E+00, 2.8811250780E+00, 1.5639143657E+00, 8.4110534696E-01],
	[2.0700000000E+04, 1.2484023198E+01, 4.7123552874E+00, 2.8833898742E+00, 1.5646403820E+00, 8.4119237381E-01],
	[2.0705000000E+04, 1.2488580648E+01, 4.7122404587E+00, 2.8856559029E+00, 1.5653663461E+00, 8.4127935658E-01],
	[2.0710000000E+04, 1.2493138661E+01, 4.7121256604E+00, 2.8879231644E+00, 1.5660922578E+00, 8.4136629529E-01],
	[2.0715000000E+04, 1.2497703272E+01, 4.7120120862E+00, 2.8901916592E+00, 1.5668183438E+00, 8.4145318996E-01],
	[2.0720000000E+04, 1.2502285941E+01, 4.7119020004E+00, 2.8924613876E+00, 1.5675450350E+00, 8.4154004060E-01],
	[2.0725000000E+04, 1.2506869184E+01, 4.7117919438E+00, 2.8947323500E+00, 1.5682716744E+00, 8.4162684723E-01],
	[2.0730000000E+04, 1.2511453002E+01, 4.7116819163E+00, 2.8970045467E+00, 1.5689982619E+00, 8.4171360986E-01],
	[2.0735000000E+04, 1.2516037393E+01, 4.7115719178E+00, 2.8992779782E+00, 1.5697247972E+00, 8.4180032851E-01],
	[2.0740000000E+04, 1.2520622358E+01, 4.7114619485E+00, 2.9015526447E+00, 1.5704512803E+00, 8.4188700319E-01],
	[2.0745000000E+04, 1.2525207897E+01, 4.7113520082E+00, 2.9038285467E+00, 1.5711777108E+00, 8.4197363392E-01],
	[2.0750000000E+04, 1.2529794009E+01, 4.7112420970E+00, 2.9061056846E+00, 1.5719040887E+00, 8.4206022072E-01],
	[2.0755000000E+04, 1.2534380695E+01, 4.7111322149E+00, 2.9083840586E+00, 1.5726304138E+00, 8.4214676360E-01],
	[2.0760000000E+04, 1.2538967955E+01, 4.7110223617E+00, 2.9106636693E+00, 1.5733566859E+00, 8.4223326257E-01],
	[2.0765000000E+04, 1.2543555788E+01, 4.7109125376E+00, 2.9129445169E+00, 1.5740829048E+00, 8.4231971766E-01],
	[2.0770000000E+04, 1.2548144195E+01, 4.7108027425E+00, 2.9152266018E+00, 1.5748090703E+00, 8.4240612887E-01],
	[2.0775000000E+04, 1.2552733175E+01, 4.7106929764E+00, 2.9175099245E+00, 1.5755351823E+00, 8.4249249623E-01],
	[2.0780000000E+04, 1.2557322728E+01, 4.7105832392E+00, 2.9197944852E+00, 1.5762612405E+00, 8.4257881974E-01],
	[2.0785000000E+04, 1.2561912855E+01, 4.7104735310E+00, 2.9220802843E+00, 1.5769872449E+00, 8.4266509943E-01],
	[2.0790000000E+04, 1.2566503555E+01, 4.7103638518E+00, 2.9243673223E+00, 1.5777131952E+00, 8.4275133531E-01],
	[2.0795000000E+04, 1.2571094827E+01, 4.7102542014E+00, 2.9266555995E+00, 1.5784390913E+00, 8.4283752740E-01],
	[2.0800000000E+04, 1.2575686673E+01, 4.7101445800E+00, 2.9289451163E+00, 1.5791649329E+00, 8.4292367570E-01],
	[2.0805000000E+04, 1.2580279092E+01, 4.7100349875E+00, 2.9312358730E+00, 1.5798907200E+00, 8.4300978025E-01],
	[2.0810000000E+04, 1.2584872084E+01, 4.7099254239E+00, 2.9335278700E+00, 1.5806164523E+00, 8.4309584105E-01],
	[2.0815000000E+04, 1.2589465649E+01, 4.7098158891E+00, 2.9358211077E+00, 1.5813421296E+00, 8.4318185811E-01],
	[2.0820000000E+04, 1.2594059786E+01, 4.7097063832E+00, 2.9381155865E+00, 1.5820677519E+00, 8.4326783146E-01],
	[2.0825000000E+04, 1.2598654497E+01, 4.7095969061E+00, 2.9404113067E+00, 1.5827933188E+00, 8.4335376111E-01],
	[2.0830000000E+04, 1.2603249779E+01, 4.7094874579E+00, 2.9427082687E+00, 1.5835188303E+00, 8.4343964708E-01],
	[2.0835000000E+04, 1.2607845635E+01, 4.7093780384E+00, 2.9450064729E+00, 1.5842442861E+00, 8.4352548938E-01],
	[2.0840000000E+04, 1.2612442063E+01, 4.7092686478E+00, 2.9473059197E+00, 1.5849696862E+00, 8.4361128803E-01],
	[2.0845000000E+04, 1.2617039063E+01, 4.7091592859E+00, 2.9496066094E+00, 1.5856950302E+00, 8.4369704304E-01],
	[2.0850000000E+04, 1.2621636636E+01, 4.7090499528E+00, 2.9519085424E+00, 1.5864203181E+00, 8.4378275443E-01],
	[2.0855000000E+04, 1.2626234781E+01, 4.7089406485E+00, 2.9542117190E+00, 1.5871455496E+00, 8.4386842222E-01],
	[2.0860000000E+04, 1.2630833499E+01, 4.7088313729E+00, 2.9565161398E+00, 1.5878707246E+00, 8.4395404641E-01],
	[2.0865000000E+04, 1.2635432788E+01, 4.7087221261E+00, 2.9588218049E+00, 1.5885958430E+00, 8.4403962704E-01],
	[2.0870000000E+04, 1.2640032650E+01, 4.7086129079E+00, 2.9611287148E+00, 1.5893209045E+00, 8.4412516411E-01],
	[2.0875000000E+04, 1.2644633084E+01, 4.7085037184E+00, 2.9634368699E+00, 1.5900459089E+00, 8.4421065764E-01],
	[2.0880000000E+04, 1.2649234089E+01, 4.7083945576E+00, 2.9657462706E+00, 1.5907708562E+00, 8.4429610764E-01],
	[2.0885000000E+04, 1.2653835667E+01, 4.7082854255E+00, 2.9680569171E+00, 1.5914957461E+00, 8.4438151413E-01],
	[2.0890000000E+04, 1.2658437817E+01, 4.7081763221E+00, 2.9703688100E+00, 1.5922205784E+00, 8.4446687713E-01],
	[2.0895000000E+04, 1.2663040538E+01, 4.7080672472E+00, 2.9726819495E+00, 1.5929453530E+00, 8.4455219666E-01],
	[2.0900000000E+04, 1.2667643831E+01, 4.7079582010E+00, 2.9749963360E+00, 1.5936700697E+00, 8.4463747272E-01],
	[2.0905000000E+04, 1.2672247696E+01, 4.7078491834E+00, 2.9773119700E+00, 1.5943947284E+00, 8.4472270534E-01],
	[2.0910000000E+04, 1.2676852132E+01, 4.7077401944E+00, 2.9796288518E+00, 1.5951193288E+00, 8.4480789453E-01],
	[2.0915000000E+04, 1.2681457140E+01, 4.7076312340E+00, 2.9819469817E+00, 1.5958438708E+00, 8.4489304031E-01],
	[2.0920000000E+04, 1.2686062719E+01, 4.7075223022E+00, 2.9842663601E+00, 1.5965683542E+00, 8.4497814269E-01],
	[2.0925000000E+04, 1.2690668870E+01, 4.7074133989E+00, 2.9865869874E+00, 1.5972927788E+00, 8.4506320169E-01],
	[2.0930000000E+04, 1.2695275592E+01, 4.7073045241E+00, 2.9889088640E+00, 1.5980171446E+00, 8.4514821733E-01],
	[2.0935000000E+04, 1.2699882885E+01, 4.7071956779E+00, 2.9912319903E+00, 1.5987414512E+00, 8.4523318962E-01],
	[2.0940000000E+04, 1.2704490750E+01, 4.7070868601E+00, 2.9935563666E+00, 1.5994656986E+00, 8.4531811858E-01],
	[2.0945000000E+04, 1.2709099185E+01, 4.7069780709E+00, 2.9958819933E+00, 1.6001898865E+00, 8.4540300422E-01],
	[2.0950000000E+04, 1.2713708192E+01, 4.7068693101E+00, 2.9982088708E+00, 1.6009140148E+00, 8.4548784656E-01],
	[2.0955000000E+04, 1.2718317770E+01, 4.7067605779E+00, 3.0005369994E+00, 1.6016380834E+00, 8.4557264562E-01],
	[2.0960000000E+04, 1.2722927919E+01, 4.7066518740E+00, 3.0028663795E+00, 1.6023620920E+00, 8.4565740141E-01],
	[2.0965000000E+04, 1.2727538638E+01, 4.7065431986E+00, 3.0051970116E+00, 1.6030860404E+00, 8.4574211395E-01],
	[2.0970000000E+04, 1.2732149928E+01, 4.7064345516E+00, 3.0075288959E+00, 1.6038099286E+00, 8.4582678326E-01],
	[2.0975000000E+04, 1.2736761790E+01, 4.7063259331E+00, 3.0098620328E+00, 1.6045337563E+00, 8.4591140934E-01],
	[2.0980000000E+04, 1.2741374221E+01, 4.7062173429E+00, 3.0121964228E+00, 1.6052575233E+00, 8.4599599223E-01],
	[2.0985000000E+04, 1.2745987224E+01, 4.7061087811E+00, 3.0145320661E+00, 1.6059812296E+00, 8.4608053193E-01],
	[2.0990000000E+04, 1.2750600797E+01, 4.7060002477E+00, 3.0168689632E+00, 1.6067048749E+00, 8.4616502846E-01],
	[2.0995000000E+04, 1.2755214940E+01, 4.7058917426E+00, 3.0192071145E+00, 1.6074284590E+00, 8.4624948183E-01],
	[2.1000000000E+04, 1.2759829654E+01, 4.7057832659E+00, 3.0215465202E+00, 1.6081519819E+00, 8.4633389207E-01],
	[2.1005000000E+04, 1.2764444938E+01, 4.7056748175E+00, 3.0238871809E+00, 1.6088754432E+00, 8.4641825919E-01],
	[2.1010000000E+04, 1.2769060793E+01, 4.7055663974E+00, 3.0262290968E+00, 1.6095988429E+00, 8.4650258320E-01],
	[2.1015000000E+04, 1.2773677217E+01, 4.7054580056E+00, 3.0285722683E+00, 1.6103221808E+00, 8.4658686413E-01],
	[2.1020000000E+04, 1.2778294212E+01, 4.7053496421E+00, 3.0309166959E+00, 1.6110454567E+00, 8.4667110198E-01],
	[2.1025000000E+04, 1.2782911777E+01, 4.7052413068E+00, 3.0332623798E+00, 1.6117686704E+00, 8.4675529678E-01],
	[2.1030000000E+04, 1.2787529912E+01, 4.7051329998E+00, 3.0356093205E+00, 1.6124918218E+00, 8.4683944853E-01],
	[2.1035000000E+04, 1.2792148617E+01, 4.7050247211E+00, 3.0379575183E+00, 1.6132149107E+00, 8.4692355726E-01],
	[2.1040000000E+04, 1.2796767892E+01, 4.7049164705E+00, 3.0403069737E+00, 1.6139379369E+00, 8.4700762297E-01],
	[2.1045000000E+04, 1.2801387737E+01, 4.7048082482E+00, 3.0426576869E+00, 1.6146609003E+00, 8.4709164569E-01],
	[2.1050000000E+04, 1.2806021413E+01, 4.7047026294E+00, 3.0450096583E+00, 1.6153843153E+00, 8.4717562541E-01],
	[2.1055000000E+04, 1.2810665919E+01, 4.7045990285E+00, 3.0473628884E+00, 1.6161080659E+00, 8.4725956217E-01],
	[2.1060000000E+04, 1.2815311006E+01, 4.7044954545E+00, 3.0497173775E+00, 1.6168317543E+00, 8.4734345596E-01],
	[2.1065000000E+04, 1.2819956674E+01, 4.7043919074E+00, 3.0520731260E+00, 1.6175553804E+00, 8.4742730682E-01],
	[2.1070000000E+04, 1.2824602923E+01, 4.7042883871E+00, 3.0544301342E+00, 1.6182789440E+00, 8.4751111474E-01],
	[2.1075000000E+04, 1.2829249753E+01, 4.7041848936E+00, 3.0567884025E+00, 1.6190024449E+00, 8.4759487975E-01],
	[2.1080000000E+04, 1.2833897164E+01, 4.7040814270E+00, 3.0591479314E+00, 1.6197258829E+00, 8.4767860186E-01],
	[2.1085000000E+04, 1.2838545155E+01, 4.7039779872E+00, 3.0615087211E+00, 1.6204492580E+00, 8.4776228109E-01],
	[2.1090000000E+04, 1.2843193727E+01, 4.7038745742E+00, 3.0638707720E+00, 1.6211725699E+00, 8.4784591744E-01],
	[2.1095000000E+04, 1.2847842880E+01, 4.7037711879E+00, 3.0662340846E+00, 1.6218958184E+00, 8.4792951094E-01],
	[2.1100000000E+04, 1.2852492613E+01, 4.7036678285E+00, 3.0685986592E+00, 1.6226190035E+00, 8.4801306159E-01],
	[2.1105000000E+04, 1.2857142927E+01, 4.7035644958E+00, 3.0709644962E+00, 1.6233421249E+00, 8.4809656942E-01],
	[2.1110000000E+04, 1.2861793821E+01, 4.7034611898E+00, 3.0733315958E+00, 1.6240651824E+00, 8.4818003443E-01],
	[2.1115000000E+04, 1.2866445295E+01, 4.7033579106E+00, 3.0756999587E+00, 1.6247881760E+00, 8.4826345665E-01],
	[2.1120000000E+04, 1.2871097350E+01, 4.7032546581E+00, 3.0780695850E+00, 1.6255111053E+00, 8.4834683607E-01],
	[2.1125000000E+04, 1.2875749985E+01, 4.7031514323E+00, 3.0804404752E+00, 1.6262339704E+00, 8.4843017273E-01],
	[2.1130000000E+04, 1.2880403200E+01, 4.7030482332E+00, 3.0828126296E+00, 1.6269567709E+00, 8.4851346664E-01],
	[2.1135000000E+04, 1.2885056995E+01, 4.7029450608E+00, 3.0851860486E+00, 1.6276795068E+00, 8.4859671780E-01],
	[2.1140000000E+04, 1.2889711370E+01, 4.7028419151E+00, 3.0875607327E+00, 1.6284021778E+00, 8.4867992623E-01],
	[2.1145000000E+04, 1.2894366326E+01, 4.7027387960E+00, 3.0899366821E+00, 1.6291247838E+00, 8.4876309196E-01],
	[2.1150000000E+04, 1.2899021861E+01, 4.7026357035E+00, 3.0923138972E+00, 1.6298473247E+00, 8.4884621498E-01],
	[2.1155000000E+04, 1.2903677975E+01, 4.7025326377E+00, 3.0946923785E+00, 1.6305698002E+00, 8.4892929532E-01],
	[2.1160000000E+04, 1.2908334670E+01, 4.7024295985E+00, 3.0970721262E+00, 1.6312922103E+00, 8.4901233300E-01],
	[2.1165000000E+04, 1.2912991944E+01, 4.7023265859E+00, 3.0994531408E+00, 1.6320145547E+00, 8.4909532802E-01],
	[2.1170000000E+04, 1.2917649798E+01, 4.7022235999E+00, 3.1018354227E+00, 1.6327368332E+00, 8.4917828041E-01],
	[2.1175000000E+04, 1.2922308232E+01, 4.7021206405E+00, 3.1042189722E+00, 1.6334590458E+00, 8.4926119016E-01],
	[2.1180000000E+04, 1.2926967245E+01, 4.7020177076E+00, 3.1066037896E+00, 1.6341811923E+00, 8.4934405731E-01],
	[2.1185000000E+04, 1.2931626837E+01, 4.7019148012E+00, 3.1089898755E+00, 1.6349032724E+00, 8.4942688187E-01],
	[2.1190000000E+04, 1.2936287009E+01, 4.7018119215E+00, 3.1113772301E+00, 1.6356252860E+00, 8.4950966385E-01],
	[2.1195000000E+04, 1.2940947760E+01, 4.7017090682E+00, 3.1137658537E+00, 1.6363472330E+00, 8.4959240326E-01],
	[2.1200000000E+04, 1.2945609091E+01, 4.7016062414E+00, 3.1161557469E+00, 1.6370691132E+00, 8.4967510012E-01],
	[2.1205000000E+04, 1.2950271000E+01, 4.7015034412E+00, 3.1185469100E+00, 1.6377909264E+00, 8.4975775444E-01],
	[2.1210000000E+04, 1.2954933489E+01, 4.7014006674E+00, 3.1209393432E+00, 1.6385126725E+00, 8.4984036625E-01],
	[2.1215000000E+04, 1.2959596556E+01, 4.7012979201E+00, 3.1233330471E+00, 1.6392343512E+00, 8.4992293555E-01],
	[2.1220000000E+04, 1.2964260203E+01, 4.7011951992E+00, 3.1257280220E+00, 1.6399559626E+00, 8.5000546235E-01],
	[2.1225000000E+04, 1.2968924429E+01, 4.7010925048E+00, 3.1281242683E+00, 1.6406775063E+00, 8.5008794669E-01],
	[2.1230000000E+04, 1.2973589233E+01, 4.7009898368E+00, 3.1305217863E+00, 1.6413989822E+00, 8.5017038856E-01],
	[2.1235000000E+04, 1.2978254616E+01, 4.7008871953E+00, 3.1329205764E+00, 1.6421203901E+00, 8.5025278798E-01],
	[2.1240000000E+04, 1.2982920578E+01, 4.7007845801E+00, 3.1353206390E+00, 1.6428417300E+00, 8.5033514498E-01],
	[2.1245000000E+04, 1.2987587119E+01, 4.7006819914E+00, 3.1377219744E+00, 1.6435630015E+00, 8.5041745956E-01],
	[2.1250000000E+04, 1.2992254238E+01, 4.7005794290E+00, 3.1401245831E+00, 1.6442842047E+00, 8.5049973173E-01],
	[2.1255000000E+04, 1.2996921936E+01, 4.7004768930E+00, 3.1425284655E+00, 1.6450053392E+00, 8.5058196152E-01],
	[2.1260000000E+04, 1.3001590212E+01, 4.7003743833E+00, 3.1449336218E+00, 1.6457264050E+00, 8.5066414894E-01],
	[2.1265000000E+04, 1.3006259067E+01, 4.7002719000E+00, 3.1473400524E+00, 1.6464474018E+00, 8.5074629400E-01],
	[2.1270000000E+04, 1.3010928500E+01, 4.7001694430E+00, 3.1497477578E+00, 1.6471683296E+00, 8.5082839673E-01],
	[2.1275000000E+04, 1.3015598511E+01, 4.7000670123E+00, 3.1521567384E+00, 1.6478891881E+00, 8.5091045712E-01],
	[2.1280000000E+04, 1.3020269100E+01, 4.6999646079E+00, 3.1545669944E+00, 1.6486099772E+00, 8.5099247521E-01],
	[2.1285000000E+04, 1.3024940268E+01, 4.6998622299E+00, 3.1569785263E+00, 1.6493306968E+00, 8.5107445100E-01],
	[2.1290000000E+04, 1.3029612014E+01, 4.6997598781E+00, 3.1593913344E+00, 1.6500513466E+00, 8.5115638450E-01],
	[2.1295000000E+04, 1.3034284337E+01, 4.6996575525E+00, 3.1618054191E+00, 1.6507719265E+00, 8.5123827575E-01],
	[2.1300000000E+04, 1.3038957239E+01, 4.6995552532E+00, 3.1642207809E+00, 1.6514924363E+00, 8.5132012474E-01],
	[2.1305000000E+04, 1.3043630719E+01, 4.6994529801E+00, 3.1666374200E+00, 1.6522128760E+00, 8.5140193149E-01],
	[2.1310000000E+04, 1.3048304776E+01, 4.6993507333E+00, 3.1690553368E+00, 1.6529332453E+00, 8.5148369603E-01],
	[2.1315000000E+04, 1.3052979411E+01, 4.6992485127E+00, 3.1714745318E+00, 1.6536535440E+00, 8.5156541836E-01],
	[2.1320000000E+04, 1.3057654624E+01, 4.6991463183E+00, 3.1738950053E+00, 1.6543737721E+00, 8.5164709850E-01],
	[2.1325000000E+04, 1.3062330414E+01, 4.6990441500E+00, 3.1763167576E+00, 1.6550939293E+00, 8.5172873647E-01],
	[2.1330000000E+04, 1.3067006782E+01, 4.6989420079E+00, 3.1787397892E+00, 1.6558140155E+00, 8.5181033227E-01],
	[2.1335000000E+04, 1.3071683728E+01, 4.6988398920E+00, 3.1811641003E+00, 1.6565340305E+00, 8.5189188594E-01],
	[2.1340000000E+04, 1.3076361251E+01, 4.6987378023E+00, 3.1835896915E+00, 1.6572539741E+00, 8.5197339747E-01],
	[2.1345000000E+04, 1.3081039351E+01, 4.6986357386E+00, 3.1860165631E+00, 1.6579738463E+00, 8.5205486689E-01],
	[2.1350000000E+04, 1.3085718029E+01, 4.6985337011E+00, 3.1884447154E+00, 1.6586936468E+00, 8.5213629421E-01],
	[2.1355000000E+04, 1.3090397284E+01, 4.6984316897E+00, 3.1908741488E+00, 1.6594133756E+00, 8.5221767945E-01],
	[2.1360000000E+04, 1.3095077116E+01, 4.6983297044E+00, 3.1933048638E+00, 1.6601330323E+00, 8.5229902263E-01],
	[2.1365000000E+04, 1.3099757525E+01, 4.6982277452E+00, 3.1957368606E+00, 1.6608526169E+00, 8.5238032375E-01],
	[2.1370000000E+04, 1.3104438511E+01, 4.6981258121E+00, 3.1981701396E+00, 1.6615721292E+00, 8.5246158283E-01],
	[2.1375000000E+04, 1.3109120075E+01, 4.6980239050E+00, 3.2006047013E+00, 1.6622915691E+00, 8.5254279989E-01],
	[2.1380000000E+04, 1.3113802215E+01, 4.6979220239E+00, 3.2030405459E+00, 1.6630109364E+00, 8.5262397495E-01],
	[2.1385000000E+04, 1.3118484932E+01, 4.6978201689E+00, 3.2054776740E+00, 1.6637302309E+00, 8.5270510801E-01],
	[2.1390000000E+04, 1.3123186977E+01, 4.6977219156E+00, 3.2079160858E+00, 1.6644502030E+00, 8.5278619910E-01],
	[2.1395000000E+04, 1.3127894360E+01, 4.6976245932E+00, 3.2103557817E+00, 1.6651702932E+00, 8.5286724823E-01],
	[2.1400000000E+04, 1.3132602332E+01, 4.6975272956E+00, 3.2127967622E+00, 1.6658903114E+00, 8.5294825542E-01],
	[2.1405000000E+04, 1.3137310891E+01, 4.6974300228E+00, 3.2152390275E+00, 1.6666102573E+00, 8.5302922068E-01],
	[2.1410000000E+04, 1.3142020039E+01, 4.6973327746E+00, 3.2176825780E+00, 1.6673301309E+00, 8.5311014402E-01],
	[2.1415000000E+04, 1.3146729774E+01, 4.6972355512E+00, 3.2201274142E+00, 1.6680499319E+00, 8.5319102547E-01],
	[2.1420000000E+04, 1.3151440097E+01, 4.6971383525E+00, 3.2225735364E+00, 1.6687696601E+00, 8.5327186503E-01],
	[2.1425000000E+04, 1.3156151007E+01, 4.6970411785E+00, 3.2250209450E+00, 1.6694893155E+00, 8.5335266273E-01],
	[2.1430000000E+04, 1.3160862506E+01, 4.6969440292E+00, 3.2274696404E+00, 1.6702088979E+00, 8.5343341857E-01],
	[2.1435000000E+04, 1.3165574591E+01, 4.6968469045E+00, 3.2299196228E+00, 1.6709284071E+00, 8.5351413258E-01],
	[2.1440000000E+04, 1.3170287264E+01, 4.6967498045E+00, 3.2323708928E+00, 1.6716478430E+00, 8.5359480478E-01],
	[2.1445000000E+04, 1.3175000525E+01, 4.6966527292E+00, 3.2348234507E+00, 1.6723672054E+00, 8.5367543516E-01],
	[2.1450000000E+04, 1.3179714373E+01, 4.6965556785E+00, 3.2372772968E+00, 1.6730864941E+00, 8.5375602376E-01],
	[2.1455000000E+04, 1.3184428808E+01, 4.6964586524E+00, 3.2397324316E+00, 1.6738057090E+00, 8.5383657059E-01],
	[2.1460000000E+04, 1.3189143831E+01, 4.6963616509E+00, 3.2421888554E+00, 1.6745248500E+00, 8.5391707565E-01],
	[2.1465000000E+04, 1.3193859441E+01, 4.6962646740E+00, 3.2446465686E+00, 1.6752439168E+00, 8.5399753898E-01],
	[2.1470000000E+04, 1.3198575637E+01, 4.6961677217E+00, 3.2471055715E+00, 1.6759629094E+00, 8.5407796058E-01],
	[2.1475000000E+04, 1.3203292421E+01, 4.6960707940E+00, 3.2495658646E+00, 1.6766818275E+00, 8.5415834047E-01],
	[2.1480000000E+04, 1.3208009792E+01, 4.6959738909E+00, 3.2520274482E+00, 1.6774006711E+00, 8.5423867866E-01],
	[2.1485000000E+04, 1.3212727750E+01, 4.6958770123E+00, 3.2544903227E+00, 1.6781194399E+00, 8.5431897518E-01],
	[2.1490000000E+04, 1.3217446294E+01, 4.6957801583E+00, 3.2569544885E+00, 1.6788381338E+00, 8.5439923003E-01],
	[2.1495000000E+04, 1.3222165425E+01, 4.6956833288E+00, 3.2594199459E+00, 1.6795567527E+00, 8.5447944324E-01],
	[2.1500000000E+04, 1.3226885144E+01, 4.6955865238E+00, 3.2618866953E+00, 1.6802752964E+00, 8.5455961481E-01],
	[2.1505000000E+04, 1.3231605448E+01, 4.6954897433E+00, 3.2643547372E+00, 1.6809937647E+00, 8.5463974477E-01],
	[2.1510000000E+04, 1.3236326340E+01, 4.6953929873E+00, 3.2668240718E+00, 1.6817121575E+00, 8.5471983313E-01],
	[2.1515000000E+04, 1.3241047817E+01, 4.6952962557E+00, 3.2692946995E+00, 1.6824304746E+00, 8.5479987990E-01],
	[2.1520000000E+04, 1.3245769882E+01, 4.6951995487E+00, 3.2717666208E+00, 1.6831487159E+00, 8.5487988511E-01],
	[2.1525000000E+04, 1.3250492532E+01, 4.6951028661E+00, 3.2742398360E+00, 1.6838668812E+00, 8.5495984876E-01],
	[2.1530000000E+04, 1.3255215770E+01, 4.6950062080E+00, 3.2767143455E+00, 1.6845849704E+00, 8.5503977088E-01],
	[2.1535000000E+04, 1.3259939593E+01, 4.6949095742E+00, 3.2791901497E+00, 1.6853029833E+00, 8.5511965147E-01],
	[2.1540000000E+04, 1.3264664002E+01, 4.6948129649E+00, 3.2816672488E+00, 1.6860209197E+00, 8.5519949056E-01],
	[2.1545000000E+04, 1.3269388998E+01, 4.6947163801E+00, 3.2841456434E+00, 1.6867387796E+00, 8.5527928816E-01],
	[2.1550000000E+04, 1.3274114580E+01, 4.6946198196E+00, 3.2866253338E+00, 1.6874565627E+00, 8.5535904429E-01],
	[2.1555000000E+04, 1.3278840748E+01, 4.6945232835E+00, 3.2891063203E+00, 1.6881742689E+00, 8.5543875896E-01],
	[2.1560000000E+04, 1.3283567501E+01, 4.6944267718E+00, 3.2915886034E+00, 1.6888918981E+00, 8.5551843219E-01],
	[2.1565000000E+04, 1.3288294841E+01, 4.6943302844E+00, 3.2940721834E+00, 1.6896094500E+00, 8.5559806400E-01],
	[2.1570000000E+04, 1.3293022767E+01, 4.6942338214E+00, 3.2965570606E+00, 1.6903269246E+00, 8.5567765439E-01],
	[2.1575000000E+04, 1.3297751278E+01, 4.6941373827E+00, 3.2990432356E+00, 1.6910443217E+00, 8.5575720340E-01],
	[2.1580000000E+04, 1.3302480375E+01, 4.6940409684E+00, 3.3015307086E+00, 1.6917616411E+00, 8.5583671102E-01],
	[2.1585000000E+04, 1.3307210058E+01, 4.6939445784E+00, 3.3040194800E+00, 1.6924788827E+00, 8.5591617728E-01],
	[2.1590000000E+04, 1.3311940326E+01, 4.6938482127E+00, 3.3065095502E+00, 1.6931960464E+00, 8.5599560220E-01],
	[2.1595000000E+04, 1.3316671179E+01, 4.6937518712E+00, 3.3090009196E+00, 1.6939131319E+00, 8.5607498579E-01],
	[2.1600000000E+04, 1.3321402619E+01, 4.6936555541E+00, 3.3114935885E+00, 1.6946301391E+00, 8.5615432807E-01],
	[2.1605000000E+04, 1.3326134643E+01, 4.6935592612E+00, 3.3139875574E+00, 1.6953470679E+00, 8.5623362904E-01],
	[2.1610000000E+04, 1.3330867253E+01, 4.6934629926E+00, 3.3164828266E+00, 1.6960639181E+00, 8.5631288874E-01],
	[2.1615000000E+04, 1.3335600448E+01, 4.6933667482E+00, 3.3189793964E+00, 1.6967806896E+00, 8.5639210717E-01],
	[2.1620000000E+04, 1.3340334229E+01, 4.6932705281E+00, 3.3214772673E+00, 1.6974973822E+00, 8.5647128436E-01],
	[2.1625000000E+04, 1.3345068594E+01, 4.6931743321E+00, 3.3239764397E+00, 1.6982139958E+00, 8.5655042031E-01],
	[2.1630000000E+04, 1.3349803545E+01, 4.6930781604E+00, 3.3264769138E+00, 1.6989305302E+00, 8.5662951504E-01],
	[2.1635000000E+04, 1.3354539080E+01, 4.6929820129E+00, 3.3289786902E+00, 1.6996469853E+00, 8.5670856858E-01],
	[2.1640000000E+04, 1.3359275201E+01, 4.6928858896E+00, 3.3314817691E+00, 1.7003633609E+00, 8.5678758093E-01],
	[2.1645000000E+04, 1.3364011906E+01, 4.6927897904E+00, 3.3339861509E+00, 1.7010796568E+00, 8.5686655211E-01],
	[2.1650000000E+04, 1.3368749197E+01, 4.6926937155E+00, 3.3364918361E+00, 1.7017958730E+00, 8.5694548214E-01],
	[2.1655000000E+04, 1.3373487072E+01, 4.6925976646E+00, 3.3389988250E+00, 1.7025120092E+00, 8.5702437103E-01],
	[2.1660000000E+04, 1.3378225531E+01, 4.6925016379E+00, 3.3415071179E+00, 1.7032280653E+00, 8.5710321881E-01],
	[2.1665000000E+04, 1.3382964576E+01, 4.6924056354E+00, 3.3440167153E+00, 1.7039440412E+00, 8.5718202548E-01],
	[2.1670000000E+04, 1.3387704205E+01, 4.6923096569E+00, 3.3465276176E+00, 1.7046599367E+00, 8.5726079106E-01],
	[2.1675000000E+04, 1.3392444418E+01, 4.6922137026E+00, 3.3490398250E+00, 1.7053757517E+00, 8.5733951557E-01],
	[2.1680000000E+04, 1.3397185216E+01, 4.6921177723E+00, 3.3515533380E+00, 1.7060914860E+00, 8.5741819903E-01],
	[2.1685000000E+04, 1.3401926598E+01, 4.6920218662E+00, 3.3540681570E+00, 1.7068071394E+00, 8.5749684145E-01],
	[2.1690000000E+04, 1.3406668565E+01, 4.6919259841E+00, 3.3565842823E+00, 1.7075227119E+00, 8.5757544285E-01],
	[2.1695000000E+04, 1.3411411116E+01, 4.6918301260E+00, 3.3591017143E+00, 1.7082382032E+00, 8.5765400324E-01],
	[2.1700000000E+04, 1.3416154251E+01, 4.6917342920E+00, 3.3616204534E+00, 1.7089536133E+00, 8.5773252265E-01],
	[2.1705000000E+04, 1.3420897970E+01, 4.6916384821E+00, 3.3641404999E+00, 1.7096689419E+00, 8.5781100108E-01],
	[2.1710000000E+04, 1.3425642273E+01, 4.6915426962E+00, 3.3666618543E+00, 1.7103841889E+00, 8.5788943855E-01],
	[2.1715000000E+04, 1.3430387161E+01, 4.6914469342E+00, 3.3691845170E+00, 1.7110993542E+00, 8.5796783508E-01],
	[2.1720000000E+04, 1.3435132632E+01, 4.6913511963E+00, 3.3717084882E+00, 1.7118144376E+00, 8.5804619069E-01],
	[2.1725000000E+04, 1.3439878687E+01, 4.6912554824E+00, 3.3742337684E+00, 1.7125294390E+00, 8.5812450539E-01],
	[2.1730000000E+04, 1.3444625326E+01, 4.6911597925E+00, 3.3767603580E+00, 1.7132443582E+00, 8.5820277920E-01],
	[2.1735000000E+04, 1.3449394649E+01, 4.6910682649E+00, 3.3792882572E+00, 1.7139601065E+00, 8.5828101214E-01],
	[2.1740000000E+04, 1.3454165959E+01, 4.6909770210E+00, 3.3818174666E+00, 1.7146758308E+00, 8.5835920421E-01],
	[2.1745000000E+04, 1.3458937864E+01, 4.6908857999E+00, 3.3843479865E+00, 1.7153914737E+00, 8.5843735545E-01],
	[2.1750000000E+04, 1.3463710364E+01, 4.6907946015E+00, 3.3868798173E+00, 1.7161070349E+00, 8.5851546586E-01],
	[2.1755000000E+04, 1.3468483459E+01, 4.6907034259E+00, 3.3894129592E+00, 1.7168225144E+00, 8.5859353546E-01],
	[2.1760000000E+04, 1.3473257148E+01, 4.6906122730E+00, 3.3919474128E+00, 1.7175379120E+00, 8.5867156426E-01],
	[2.1765000000E+04, 1.3478031432E+01, 4.6905211428E+00, 3.3944831784E+00, 1.7182532275E+00, 8.5874955229E-01],
	[2.1770000000E+04, 1.3482806311E+01, 4.6904300353E+00, 3.3970202564E+00, 1.7189684608E+00, 8.5882749956E-01],
	[2.1775000000E+04, 1.3487581784E+01, 4.6903389505E+00, 3.3995586471E+00, 1.7196836117E+00, 8.5890540609E-01],
	[2.1780000000E+04, 1.3492357851E+01, 4.6902478884E+00, 3.4020983509E+00, 1.7203986802E+00, 8.5898327189E-01],
	[2.1785000000E+04, 1.3497134513E+01, 4.6901568489E+00, 3.4046393682E+00, 1.7211136660E+00, 8.5906109698E-01],
	[2.1790000000E+04, 1.3501911769E+01, 4.6900658321E+00, 3.4071816994E+00, 1.7218285690E+00, 8.5913888138E-01],
	[2.1795000000E+04, 1.3506689620E+01, 4.6899748380E+00, 3.4097253449E+00, 1.7225433890E+00, 8.5921662510E-01],
	[2.1800000000E+04, 1.3511468064E+01, 4.6898838665E+00, 3.4122703050E+00, 1.7232581260E+00, 8.5929432816E-01],
	[2.1805000000E+04, 1.3516247103E+01, 4.6897929176E+00, 3.4148165801E+00, 1.7239727797E+00, 8.5937199057E-01],
	[2.1810000000E+04, 1.3521026735E+01, 4.6897019913E+00, 3.4173641706E+00, 1.7246873501E+00, 8.5944961236E-01],
	[2.1815000000E+04, 1.3525806962E+01, 4.6896110876E+00, 3.4199130769E+00, 1.7254018369E+00, 8.5952719353E-01],
	[2.1820000000E+04, 1.3530587783E+01, 4.6895202066E+00, 3.4224632993E+00, 1.7261162401E+00, 8.5960473412E-01],
	[2.1825000000E+04, 1.3535369197E+01, 4.6894293481E+00, 3.4250148383E+00, 1.7268305594E+00, 8.5968223412E-01],
	[2.1830000000E+04, 1.3540151205E+01, 4.6893385122E+00, 3.4275676941E+00, 1.7275447948E+00, 8.5975969356E-01],
	[2.1835000000E+04, 1.3544933807E+01, 4.6892476988E+00, 3.4301218672E+00, 1.7282589461E+00, 8.5983711246E-01],
	[2.1840000000E+04, 1.3549717003E+01, 4.6891569080E+00, 3.4326773580E+00, 1.7289730131E+00, 8.5991449083E-01],
	[2.1845000000E+04, 1.3554500792E+01, 4.6890661398E+00, 3.4352341668E+00, 1.7296869957E+00, 8.5999182869E-01],
	[2.1850000000E+04, 1.3559285175E+01, 4.6889753940E+00, 3.4377922940E+00, 1.7304008938E+00, 8.6006912605E-01],
	[2.1855000000E+04, 1.3564070151E+01, 4.6888846708E+00, 3.4403517400E+00, 1.7311147072E+00, 8.6014638294E-01],
	[2.1860000000E+04, 1.3568855720E+01, 4.6887939701E+00, 3.4429125052E+00, 1.7318284357E+00, 8.6022359937E-01],
	[2.1865000000E+04, 1.3573641883E+01, 4.6887032919E+00, 3.4454745900E+00, 1.7325420793E+00, 8.6030077535E-01],
	[2.1870000000E+04, 1.3578428640E+01, 4.6886126362E+00, 3.4480379946E+00, 1.7332556378E+00, 8.6037791090E-01],
	[2.1875000000E+04, 1.3583215989E+01, 4.6885220029E+00, 3.4506027195E+00, 1.7339691110E+00, 8.6045500604E-01],
	[2.1880000000E+04, 1.3588003932E+01, 4.6884313922E+00, 3.4531687652E+00, 1.7346824988E+00, 8.6053206079E-01],
	[2.1885000000E+04, 1.3592792468E+01, 4.6883408038E+00, 3.4557361319E+00, 1.7353958011E+00, 8.6060907516E-01],
	[2.1890000000E+04, 1.3597581597E+01, 4.6882502380E+00, 3.4583048200E+00, 1.7361090176E+00, 8.6068604917E-01],
	[2.1895000000E+04, 1.3602371319E+01, 4.6881596945E+00, 3.4608748299E+00, 1.7368221483E+00, 8.6076298283E-01],
	[2.1900000000E+04, 1.3607161633E+01, 4.6880691735E+00, 3.4634461620E+00, 1.7375351931E+00, 8.6083987617E-01],
	[2.1905000000E+04, 1.3611952541E+01, 4.6879786749E+00, 3.4660188167E+00, 1.7382481517E+00, 8.6091672920E-01],
	[2.1910000000E+04, 1.3616744041E+01, 4.6878881987E+00, 3.4685927943E+00, 1.7389610240E+00, 8.6099354193E-01],
	[2.1915000000E+04, 1.3621536135E+01, 4.6877977448E+00, 3.4711680953E+00, 1.7396738100E+00, 8.6107031439E-01],
	[2.1920000000E+04, 1.3626328820E+01, 4.6877073134E+00, 3.4737447200E+00, 1.7403865094E+00, 8.6114704658E-01],
	[2.1925000000E+04, 1.3631122099E+01, 4.6876169043E+00, 3.4763226687E+00, 1.7410991220E+00, 8.6122373853E-01],
	[2.1930000000E+04, 1.3635915970E+01, 4.6875265176E+00, 3.4789019419E+00, 1.7418116479E+00, 8.6130039026E-01],
	[2.1935000000E+04, 1.3640710433E+01, 4.6874361533E+00, 3.4814825399E+00, 1.7425240868E+00, 8.6137700177E-01],
	[2.1940000000E+04, 1.3645505489E+01, 4.6873458112E+00, 3.4840644632E+00, 1.7432364385E+00, 8.6145357310E-01],
	[2.1945000000E+04, 1.3650301138E+01, 4.6872554915E+00, 3.4866477120E+00, 1.7439487030E+00, 8.6153010424E-01],
	[2.1950000000E+04, 1.3655097378E+01, 4.6871651941E+00, 3.4892322868E+00, 1.7446608801E+00, 8.6160659523E-01],
	[2.1955000000E+04, 1.3659894211E+01, 4.6870749191E+00, 3.4918181880E+00, 1.7453729696E+00, 8.6168304608E-01],
	[2.1960000000E+04, 1.3664691636E+01, 4.6869846663E+00, 3.4944054159E+00, 1.7460849715E+00, 8.6175945679E-01],
	[2.1965000000E+04, 1.3669489653E+01, 4.6868944358E+00, 3.4969939709E+00, 1.7467968855E+00, 8.6183582740E-01],
	[2.1970000000E+04, 1.3674288263E+01, 4.6868042275E+00, 3.4995838533E+00, 1.7475087116E+00, 8.6191215791E-01],
	[2.1975000000E+04, 1.3679087464E+01, 4.6867140416E+00, 3.5021750637E+00, 1.7482204495E+00, 8.6198844834E-01],
	[2.1980000000E+04, 1.3683887257E+01, 4.6866238779E+00, 3.5047676023E+00, 1.7489320992E+00, 8.6206469870E-01],
	[2.1985000000E+04, 1.3688687642E+01, 4.6865337364E+00, 3.5073614695E+00, 1.7496436605E+00, 8.6214090900E-01],
	[2.1990000000E+04, 1.3693488619E+01, 4.6864436172E+00, 3.5099566657E+00, 1.7503551333E+00, 8.6221707928E-01],
	[2.1995000000E+04, 1.3698290187E+01, 4.6863535201E+00, 3.5125531912E+00, 1.7510665173E+00, 8.6229320952E-01],
	[2.2000000000E+04, 1.3703092348E+01, 4.6862634453E+00, 3.5151510465E+00, 1.7517778126E+00, 8.6236929977E-01],
	[2.2005000000E+04, 1.3707895100E+01, 4.6861733927E+00, 3.5177502320E+00, 1.7524890189E+00, 8.6244535001E-01],
	[2.2010000000E+04, 1.3712698443E+01, 4.6860833623E+00, 3.5203507480E+00, 1.7532001361E+00, 8.6252136029E-01],
	[2.2015000000E+04, 1.3717502378E+01, 4.6859933541E+00, 3.5229525948E+00, 1.7539111641E+00, 8.6259733060E-01],
	[2.2020000000E+04, 1.3722306904E+01, 4.6859033680E+00, 3.5255557729E+00, 1.7546221027E+00, 8.6267326096E-01],
	[2.2025000000E+04, 1.3727112022E+01, 4.6858134041E+00, 3.5281602827E+00, 1.7553329518E+00, 8.6274915139E-01],
	[2.2030000000E+04, 1.3731917731E+01, 4.6857234623E+00, 3.5307661245E+00, 1.7560437113E+00, 8.6282500190E-01],
	[2.2035000000E+04, 1.3736724032E+01, 4.6856335427E+00, 3.5333732987E+00, 1.7567543809E+00, 8.6290081251E-01],
	[2.2040000000E+04, 1.3741530923E+01, 4.6855436452E+00, 3.5359818057E+00, 1.7574649607E+00, 8.6297658324E-01],
	[2.2045000000E+04, 1.3746338406E+01, 4.6854537698E+00, 3.5385916458E+00, 1.7581754503E+00, 8.6305231409E-01],
	[2.2050000000E+04, 1.3751146480E+01, 4.6853639165E+00, 3.5412028195E+00, 1.7588858497E+00, 8.6312800509E-01],
	[2.2055000000E+04, 1.3755955144E+01, 4.6852740854E+00, 3.5438153271E+00, 1.7595961588E+00, 8.6320365625E-01],
	[2.2060000000E+04, 1.3760764400E+01, 4.6851842763E+00, 3.5464291689E+00, 1.7603063774E+00, 8.6327926758E-01],
	[2.2065000000E+04, 1.3765574247E+01, 4.6850944892E+00, 3.5490443455E+00, 1.7610165054E+00, 8.6335483910E-01],
	[2.2070000000E+04, 1.3770384684E+01, 4.6850047243E+00, 3.5516608571E+00, 1.7617265426E+00, 8.6343037082E-01],
	[2.2075000000E+04, 1.3775195712E+01, 4.6849149814E+00, 3.5542787042E+00, 1.7624364890E+00, 8.6350586276E-01],
	[2.2080000000E+04, 1.3780007331E+01, 4.6848252605E+00, 3.5568978870E+00, 1.7631463442E+00, 8.6358131494E-01],
	[2.2085000000E+04, 1.3784842439E+01, 4.6847397727E+00, 3.5595184061E+00, 1.7638570802E+00, 8.6365672737E-01],
	[2.2090000000E+04, 1.3789678734E+01, 4.6846544135E+00, 3.5621402617E+00, 1.7645677508E+00, 8.6373210006E-01],
	[2.2095000000E+04, 1.3794515630E+01, 4.6845690752E+00, 3.5647634542E+00, 1.7652783311E+00, 8.6380743304E-01],
	[2.2100000000E+04, 1.3799353128E+01, 4.6844837577E+00, 3.5673879841E+00, 1.7659888210E+00, 8.6388272631E-01],
	[2.2105000000E+04, 1.3804191228E+01, 4.6843984611E+00, 3.5700138517E+00, 1.7666992202E+00, 8.6395797989E-01],
	[2.2110000000E+04, 1.3809029929E+01, 4.6843131853E+00, 3.5726410574E+00, 1.7674095287E+00, 8.6403319380E-01],
	[2.2115000000E+04, 1.3813869231E+01, 4.6842279304E+00, 3.5752696015E+00, 1.7681197464E+00, 8.6410836805E-01],
	[2.2120000000E+04, 1.3818709135E+01, 4.6841426963E+00, 3.5778994845E+00, 1.7688298731E+00, 8.6418350266E-01],
	[2.2125000000E+04, 1.3823549640E+01, 4.6840574830E+00, 3.5805307067E+00, 1.7695399086E+00, 8.6425859764E-01],
	[2.2130000000E+04, 1.3828390746E+01, 4.6839722905E+00, 3.5831632685E+00, 1.7702498528E+00, 8.6433365301E-01],
	[2.2135000000E+04, 1.3833232453E+01, 4.6838871188E+00, 3.5857971703E+00, 1.7709597056E+00, 8.6440866878E-01],
	[2.2140000000E+04, 1.3838074762E+01, 4.6838019679E+00, 3.5884324124E+00, 1.7716694669E+00, 8.6448364497E-01],
	[2.2145000000E+04, 1.3842917671E+01, 4.6837168378E+00, 3.5910689953E+00, 1.7723791365E+00, 8.6455858160E-01],
	[2.2150000000E+04, 1.3847761182E+01, 4.6836317284E+00, 3.5937069192E+00, 1.7730887142E+00, 8.6463347867E-01],
	[2.2155000000E+04, 1.3852605293E+01, 4.6835466398E+00, 3.5963461847E+00, 1.7737982000E+00, 8.6470833621E-01],
	[2.2160000000E+04, 1.3857450005E+01, 4.6834615719E+00, 3.5989867921E+00, 1.7745075937E+00, 8.6478315424E-01],
	[2.2165000000E+04, 1.3862295318E+01, 4.6833765248E+00, 3.6016287417E+00, 1.7752168952E+00, 8.6485793275E-01],
	[2.2170000000E+04, 1.3867141232E+01, 4.6832914984E+00, 3.6042720339E+00, 1.7759261043E+00, 8.6493267178E-01],
	[2.2175000000E+04, 1.3871987747E+01, 4.6832064927E+00, 3.6069166691E+00, 1.7766352209E+00, 8.6500737134E-01],
	[2.2180000000E+04, 1.3876834862E+01, 4.6831215077E+00, 3.6095626478E+00, 1.7773442449E+00, 8.6508203144E-01],
	[2.2185000000E+04, 1.3881682577E+01, 4.6830365434E+00, 3.6122099702E+00, 1.7780531761E+00, 8.6515665210E-01],
	[2.2190000000E+04, 1.3886530893E+01, 4.6829515998E+00, 3.6148586367E+00, 1.7787620144E+00, 8.6523123333E-01],
	[2.2195000000E+04, 1.3891379809E+01, 4.6828666769E+00, 3.6175086478E+00, 1.7794707596E+00, 8.6530577515E-01],
	[2.2200000000E+04, 1.3896229326E+01, 4.6827817747E+00, 3.6201600038E+00, 1.7801794117E+00, 8.6538027758E-01],
	[2.2205000000E+04, 1.3901079443E+01, 4.6826968931E+00, 3.6228127050E+00, 1.7808879705E+00, 8.6545474063E-01],
	[2.2210000000E+04, 1.3905930161E+01, 4.6826120322E+00, 3.6254667520E+00, 1.7815964358E+00, 8.6552916431E-01],
	[2.2215000000E+04, 1.3910781478E+01, 4.6825271919E+00, 3.6281221449E+00, 1.7823048076E+00, 8.6560354864E-01],
	[2.2220000000E+04, 1.3915633396E+01, 4.6824423722E+00, 3.6307788843E+00, 1.7830130856E+00, 8.6567789365E-01],
	[2.2225000000E+04, 1.3920485913E+01, 4.6823575731E+00, 3.6334369705E+00, 1.7837212698E+00, 8.6575219933E-01],
	[2.2230000000E+04, 1.3925339031E+01, 4.6822727947E+00, 3.6360964039E+00, 1.7844293601E+00, 8.6582646572E-01],
	[2.2235000000E+04, 1.3930192749E+01, 4.6821880369E+00, 3.6387571849E+00, 1.7851373562E+00, 8.6590069282E-01],
	[2.2240000000E+04, 1.3935047066E+01, 4.6821032996E+00, 3.6414193137E+00, 1.7858452580E+00, 8.6597488064E-01],
	[2.2245000000E+04, 1.3939901983E+01, 4.6820185829E+00, 3.6440827910E+00, 1.7865530655E+00, 8.6604902922E-01],
	[2.2250000000E+04, 1.3944757500E+01, 4.6819338869E+00, 3.6467476169E+00, 1.7872607785E+00, 8.6612313856E-01],
	[2.2255000000E+04, 1.3949613617E+01, 4.6818492113E+00, 3.6494137918E+00, 1.7879683968E+00, 8.6619720867E-01],
	[2.2260000000E+04, 1.3954470333E+01, 4.6817645563E+00, 3.6520813163E+00, 1.7886759204E+00, 8.6627123958E-01],
	[2.2265000000E+04, 1.3959327649E+01, 4.6816799219E+00, 3.6547501906E+00, 1.7893833490E+00, 8.6634523129E-01],
	[2.2270000000E+04, 1.3964185565E+01, 4.6815953080E+00, 3.6574204151E+00, 1.7900906826E+00, 8.6641918383E-01],
	[2.2275000000E+04, 1.3969044079E+01, 4.6815107146E+00, 3.6600919902E+00, 1.7907979210E+00, 8.6649309721E-01],
	[2.2280000000E+04, 1.3973903194E+01, 4.6814261418E+00, 3.6627649162E+00, 1.7915050642E+00, 8.6656697145E-01],
	[2.2285000000E+04, 1.3978762907E+01, 4.6813415894E+00, 3.6654391937E+00, 1.7922121119E+00, 8.6664080656E-01],
	[2.2290000000E+04, 1.3983623220E+01, 4.6812570575E+00, 3.6681148228E+00, 1.7929190640E+00, 8.6671460255E-01],
	[2.2295000000E+04, 1.3988484132E+01, 4.6811725462E+00, 3.6707918041E+00, 1.7936259204E+00, 8.6678835945E-01],
	[2.2300000000E+04, 1.3993345643E+01, 4.6810880553E+00, 3.6734701379E+00, 1.7943326810E+00, 8.6686207727E-01],
	[2.2305000000E+04, 1.3998207753E+01, 4.6810035848E+00, 3.6761498246E+00, 1.7950393456E+00, 8.6693575602E-01],
	[2.2310000000E+04, 1.4003070463E+01, 4.6809191348E+00, 3.6788308645E+00, 1.7957459141E+00, 8.6700939573E-01],
	[2.2315000000E+04, 1.4007933771E+01, 4.6808347053E+00, 3.6815132580E+00, 1.7964523864E+00, 8.6708299640E-01],
	[2.2320000000E+04, 1.4012797678E+01, 4.6807502962E+00, 3.6841970056E+00, 1.7971587623E+00, 8.6715655805E-01],
	[2.2325000000E+04, 1.4017662184E+01, 4.6806659075E+00, 3.6868821075E+00, 1.7978650417E+00, 8.6723008071E-01],
	[2.2330000000E+04, 1.4022527289E+01, 4.6805815393E+00, 3.6895685643E+00, 1.7985712246E+00, 8.6730356437E-01],
	[2.2335000000E+04, 1.4027392992E+01, 4.6804971915E+00, 3.6922563761E+00, 1.7992773106E+00, 8.6737700907E-01],
	[2.2340000000E+04, 1.4032259294E+01, 4.6804128640E+00, 3.6949455436E+00, 1.7999832998E+00, 8.6745041482E-01],
	[2.2345000000E+04, 1.4037126195E+01, 4.6803285570E+00, 3.6976360669E+00, 1.8006891920E+00, 8.6752378162E-01],
	[2.2350000000E+04, 1.4041993694E+01, 4.6802442703E+00, 3.7003279465E+00, 1.8013949870E+00, 8.6759710951E-01],
	[2.2355000000E+04, 1.4046861792E+01, 4.6801600040E+00, 3.7030211828E+00, 1.8021006848E+00, 8.6767039849E-01],
	[2.2360000000E+04, 1.4051730488E+01, 4.6800757581E+00, 3.7057157761E+00, 1.8028062852E+00, 8.6774364858E-01],
	[2.2365000000E+04, 1.4056599783E+01, 4.6799915325E+00, 3.7084229180E+00, 1.8035144349E+00, 8.6781685979E-01],
	[2.2370000000E+04, 1.4061469676E+01, 4.6799073273E+00, 3.7111332546E+00, 1.8042229175E+00, 8.6789003215E-01],
	[2.2375000000E+04, 1.4066340167E+01, 4.6798231424E+00, 3.7138449656E+00, 1.8049313021E+00, 8.6796316567E-01],
	[2.2380000000E+04, 1.4071211256E+01, 4.6797389778E+00, 3.7165580513E+00, 1.8056395883E+00, 8.6803626036E-01],
	[2.2385000000E+04, 1.4076082943E+01, 4.6796548335E+00, 3.7192725123E+00, 1.8063477763E+00, 8.6810931624E-01],
	[2.2390000000E+04, 1.4080955229E+01, 4.6795707096E+00, 3.7219883488E+00, 1.8070558657E+00, 8.6818233333E-01],
	[2.2395000000E+04, 1.4085828112E+01, 4.6794866059E+00, 3.7247055612E+00, 1.8077638565E+00, 8.6825531164E-01],
	[2.2400000000E+04, 1.4090701593E+01, 4.6794025225E+00, 3.7274241500E+00, 1.8084717485E+00, 8.6832825118E-01],
	[2.2405000000E+04, 1.4095575673E+01, 4.6793184594E+00, 3.7301441156E+00, 1.8091795416E+00, 8.6840115199E-01],
	[2.2410000000E+04, 1.4100450350E+01, 4.6792344166E+00, 3.7328654582E+00, 1.8098872357E+00, 8.6847401406E-01],
	[2.2415000000E+04, 1.4105325625E+01, 4.6791503940E+00, 3.7355881784E+00, 1.8105948306E+00, 8.6854683742E-01],
	[2.2420000000E+04, 1.4110201497E+01, 4.6790663917E+00, 3.7383122765E+00, 1.8113023263E+00, 8.6861962208E-01],
	[2.2425000000E+04, 1.4115077967E+01, 4.6789824096E+00, 3.7410377529E+00, 1.8120097225E+00, 8.6869236807E-01],
	[2.2430000000E+04, 1.4119955035E+01, 4.6788984477E+00, 3.7437646079E+00, 1.8127170192E+00, 8.6876507538E-01],
	[2.2435000000E+04, 1.4124832700E+01, 4.6788145061E+00, 3.7464928421E+00, 1.8134242162E+00, 8.6883774405E-01],
	[2.2440000000E+04, 1.4129731692E+01, 4.6787343289E+00, 3.7492224557E+00, 1.8141322180E+00, 8.6891037409E-01],
	[2.2445000000E+04, 1.4134634037E+01, 4.6786546666E+00, 3.7519534491E+00, 1.8148402407E+00, 8.6898296551E-01],
	[2.2450000000E+04, 1.4139536991E+01, 4.6785750234E+00, 3.7546858228E+00, 1.8155481645E+00, 8.6905551832E-01],
	[2.2455000000E+04, 1.4144440552E+01, 4.6784953994E+00, 3.7574195771E+00, 1.8162559892E+00, 8.6912803256E-01],
	[2.2460000000E+04, 1.4149344722E+01, 4.6784157943E+00, 3.7601547125E+00, 1.8169637148E+00, 8.6920050823E-01],
	[2.2465000000E+04, 1.4154249500E+01, 4.6783362084E+00, 3.7628912293E+00, 1.8176713409E+00, 8.6927294534E-01],
	[2.2470000000E+04, 1.4159154886E+01, 4.6782566416E+00, 3.7656291278E+00, 1.8183788677E+00, 8.6934534392E-01],
	[2.2475000000E+04, 1.4164060880E+01, 4.6781770938E+00, 3.7683684086E+00, 1.8190862948E+00, 8.6941770398E-01],
	[2.2480000000E+04, 1.4168967483E+01, 4.6780975650E+00, 3.7711090719E+00, 1.8197936223E+00, 8.6949002554E-01],
	[2.2485000000E+04, 1.4173874693E+01, 4.6780180553E+00, 3.7738511182E+00, 1.8205008498E+00, 8.6956230861E-01],
	[2.2490000000E+04, 1.4178782511E+01, 4.6779385646E+00, 3.7765945479E+00, 1.8212079775E+00, 8.6963455321E-01],
	[2.2495000000E+04, 1.4183690936E+01, 4.6778590929E+00, 3.7793393613E+00, 1.8219150050E+00, 8.6970675936E-01],
	[2.2500000000E+04, 1.4188599970E+01, 4.6777796403E+00, 3.7820855589E+00, 1.8226219323E+00, 8.6977892707E-01],
	[2.2505000000E+04, 1.4193509611E+01, 4.6777002066E+00, 3.7848331410E+00, 1.8233287592E+00, 8.6985105635E-01],
	[2.2510000000E+04, 1.4198419860E+01, 4.6776207919E+00, 3.7875821080E+00, 1.8240354857E+00, 8.6992314723E-01],
	[2.2515000000E+04, 1.4203330717E+01, 4.6775413963E+00, 3.7903324604E+00, 1.8247421115E+00, 8.6999519973E-01],
	[2.2520000000E+04, 1.4208242180E+01, 4.6774620196E+00, 3.7930841984E+00, 1.8254486366E+00, 8.7006721385E-01],
	[2.2525000000E+04, 1.4213154252E+01, 4.6773826618E+00, 3.7958373226E+00, 1.8261550609E+00, 8.7013918961E-01],
	[2.2530000000E+04, 1.4218066931E+01, 4.6773033231E+00, 3.7985918332E+00, 1.8268613841E+00, 8.7021112703E-01],
	[2.2535000000E+04, 1.4222980217E+01, 4.6772240032E+00, 3.8013477307E+00, 1.8275676062E+00, 8.7028302613E-01],
	[2.2540000000E+04, 1.4227894110E+01, 4.6771447024E+00, 3.8041050154E+00, 1.8282737271E+00, 8.7035488692E-01],
	[2.2545000000E+04, 1.4232808611E+01, 4.6770654204E+00, 3.8068636879E+00, 1.8289797466E+00, 8.7042670942E-01],
	[2.2550000000E+04, 1.4237723719E+01, 4.6769861574E+00, 3.8096237483E+00, 1.8296856646E+00, 8.7049849365E-01],
	[2.2555000000E+04, 1.4242639434E+01, 4.6769069133E+00, 3.8123851972E+00, 1.8303914810E+00, 8.7057023962E-01],
	[2.2560000000E+04, 1.4247555756E+01, 4.6768276881E+00, 3.8151480349E+00, 1.8310971957E+00, 8.7064194735E-01],
	[2.2565000000E+04, 1.4252472684E+01, 4.6767484818E+00, 3.8179122619E+00, 1.8318028084E+00, 8.7071361685E-01],
	[2.2570000000E+04, 1.4257390220E+01, 4.6766692944E+00, 3.8206778784E+00, 1.8325083192E+00, 8.7078524814E-01],
	[2.2575000000E+04, 1.4262308363E+01, 4.6765901259E+00, 3.8234448850E+00, 1.8332137278E+00, 8.7085684124E-01],
	[2.2580000000E+04, 1.4267227113E+01, 4.6765109762E+00, 3.8262132819E+00, 1.8339190342E+00, 8.7092839616E-01],
	[2.2585000000E+04, 1.4272146469E+01, 4.6764318454E+00, 3.8289830696E+00, 1.8346242382E+00, 8.7099991293E-01],
	[2.2590000000E+04, 1.4277066432E+01, 4.6763527335E+00, 3.8317542485E+00, 1.8353293397E+00, 8.7107139155E-01],
	[2.2595000000E+04, 1.4281987001E+01, 4.6762736404E+00, 3.8345268189E+00, 1.8360343386E+00, 8.7114283204E-01],
	[2.2600000000E+04, 1.4286908177E+01, 4.6761945661E+00, 3.8373007813E+00, 1.8367392347E+00, 8.7121423442E-01],
	[2.2605000000E+04, 1.4291829960E+01, 4.6761155107E+00, 3.8400761360E+00, 1.8374440279E+00, 8.7128559871E-01],
	[2.2610000000E+04, 1.4296752349E+01, 4.6760364741E+00, 3.8428528835E+00, 1.8381487181E+00, 8.7135692493E-01],
	[2.2615000000E+04, 1.4301675344E+01, 4.6759574563E+00, 3.8456310240E+00, 1.8388533052E+00, 8.7142821308E-01],
	[2.2620000000E+04, 1.4306598946E+01, 4.6758784573E+00, 3.8484105581E+00, 1.8395577891E+00, 8.7149946319E-01],
	[2.2625000000E+04, 1.4311523154E+01, 4.6757994771E+00, 3.8511914861E+00, 1.8402621695E+00, 8.7157067527E-01],
	[2.2630000000E+04, 1.4316447968E+01, 4.6757205157E+00, 3.8539738084E+00, 1.8409664465E+00, 8.7164184933E-01],
	[2.2635000000E+04, 1.4321373389E+01, 4.6756415731E+00, 3.8567575254E+00, 1.8416706199E+00, 8.7171298541E-01],
	[2.2640000000E+04, 1.4326299415E+01, 4.6755626492E+00, 3.8595426374E+00, 1.8423746894E+00, 8.7178408350E-01],
	[2.2645000000E+04, 1.4331226048E+01, 4.6754837441E+00, 3.8623291449E+00, 1.8430786552E+00, 8.7185514364E-01],
	[2.2650000000E+04, 1.4336153286E+01, 4.6754048578E+00, 3.8651170483E+00, 1.8437825169E+00, 8.7192616583E-01],
	[2.2655000000E+04, 1.4341081131E+01, 4.6753259902E+00, 3.8679063479E+00, 1.8444862745E+00, 8.7199715009E-01],
	[2.2660000000E+04, 1.4346009581E+01, 4.6752471413E+00, 3.8706970441E+00, 1.8451899278E+00, 8.7206809643E-01],
	[2.2665000000E+04, 1.4350938637E+01, 4.6751683112E+00, 3.8734891374E+00, 1.8458934768E+00, 8.7213900489E-01],
	[2.2670000000E+04, 1.4355868299E+01, 4.6750894997E+00, 3.8762826281E+00, 1.8465969213E+00, 8.7220987546E-01],
	[2.2675000000E+04, 1.4360798566E+01, 4.6750107070E+00, 3.8790775166E+00, 1.8473002612E+00, 8.7228070817E-01],
	[2.2680000000E+04, 1.4365729439E+01, 4.6749319330E+00, 3.8818738033E+00, 1.8480034964E+00, 8.7235150304E-01],
	[2.2685000000E+04, 1.4370660918E+01, 4.6748531776E+00, 3.8846714886E+00, 1.8487066267E+00, 8.7242226008E-01],
	[2.2690000000E+04, 1.4375593002E+01, 4.6747744410E+00, 3.8874705729E+00, 1.8494096520E+00, 8.7249297931E-01],
	[2.2695000000E+04, 1.4380525691E+01, 4.6746957230E+00, 3.8902710566E+00, 1.8501125722E+00, 8.7256366074E-01],
	[2.2700000000E+04, 1.4385458986E+01, 4.6746170237E+00, 3.8930729400E+00, 1.8508153872E+00, 8.7263430439E-01],
	[2.2705000000E+04, 1.4390392886E+01, 4.6745383431E+00, 3.8958762236E+00, 1.8515180968E+00, 8.7270491028E-01],
	[2.2710000000E+04, 1.4395327392E+01, 4.6744596811E+00, 3.8986809077E+00, 1.8522207010E+00, 8.7277547842E-01],
	[2.2715000000E+04, 1.4400262502E+01, 4.6743810377E+00, 3.9014869928E+00, 1.8529231996E+00, 8.7284600883E-01],
	[2.2720000000E+04, 1.4405198218E+01, 4.6743024130E+00, 3.9042944792E+00, 1.8536255925E+00, 8.7291650154E-01],
	[2.2725000000E+04, 1.4410134539E+01, 4.6742238069E+00, 3.9071033673E+00, 1.8543278795E+00, 8.7298695654E-01],
	[2.2730000000E+04, 1.4415071465E+01, 4.6741452194E+00, 3.9099136575E+00, 1.8550300606E+00, 8.7305737387E-01],
	[2.2735000000E+04, 1.4420008996E+01, 4.6740666505E+00, 3.9127253502E+00, 1.8557321356E+00, 8.7312775353E-01],
	[2.2740000000E+04, 1.4424947132E+01, 4.6739881002E+00, 3.9155384459E+00, 1.8564341044E+00, 8.7319809555E-01],
	[2.2745000000E+04, 1.4429885872E+01, 4.6739095685E+00, 3.9183529448E+00, 1.8571359670E+00, 8.7326839995E-01],
	[2.2750000000E+04, 1.4434825218E+01, 4.6738310554E+00, 3.9211688474E+00, 1.8578377230E+00, 8.7333866673E-01],
	[2.2755000000E+04, 1.4439765168E+01, 4.6737525608E+00, 3.9239861540E+00, 1.8585393725E+00, 8.7340889591E-01],
	[2.2760000000E+04, 1.4444705722E+01, 4.6736740848E+00, 3.9268048651E+00, 1.8592409154E+00, 8.7347908751E-01],
	[2.2765000000E+04, 1.4449646882E+01, 4.6735956274E+00, 3.9296249811E+00, 1.8599423514E+00, 8.7354924156E-01],
	[2.2770000000E+04, 1.4454588646E+01, 4.6735171885E+00, 3.9324465023E+00, 1.8606436805E+00, 8.7361935806E-01],
	[2.2775000000E+04, 1.4459531014E+01, 4.6734387682E+00, 3.9352694291E+00, 1.8613449026E+00, 8.7368943703E-01],
	[2.2780000000E+04, 1.4464473987E+01, 4.6733603664E+00, 3.9380937620E+00, 1.8620460176E+00, 8.7375947849E-01],
	[2.2785000000E+04, 1.4469417564E+01, 4.6732819831E+00, 3.9409195013E+00, 1.8627470252E+00, 8.7382948245E-01],
	[2.2790000000E+04, 1.4474361746E+01, 4.6732036183E+00, 3.9437466474E+00, 1.8634479255E+00, 8.7389944894E-01],
	[2.2795000000E+04, 1.4479306532E+01, 4.6731252720E+00, 3.9465752007E+00, 1.8641487182E+00, 8.7396937796E-01],
	[2.2800000000E+04, 1.4484267095E+01, 4.6730496361E+00, 3.9494051615E+00, 1.8648500835E+00, 8.7403926954E-01],
	[2.2805000000E+04, 1.4489236563E+01, 4.6729754889E+00, 3.9522365304E+00, 1.8655517137E+00, 8.7410912369E-01],
	[2.2810000000E+04, 1.4494206647E+01, 4.6729013592E+00, 3.9550693076E+00, 1.8662532371E+00, 8.7417894044E-01],
	[2.2815000000E+04, 1.4499177345E+01, 4.6728272469E+00, 3.9579034936E+00, 1.8669546537E+00, 8.7424871978E-01],
	[2.2820000000E+04, 1.4504148658E+01, 4.6727531520E+00, 3.9607390888E+00, 1.8676559633E+00, 8.7431846176E-01],
	[2.2825000000E+04, 1.4509120587E+01, 4.6726790745E+00, 3.9635760935E+00, 1.8683571657E+00, 8.7438816637E-01],
	[2.2830000000E+04, 1.4514093129E+01, 4.6726050145E+00, 3.9664145081E+00, 1.8690582609E+00, 8.7445783364E-01],
	[2.2835000000E+04, 1.4519066287E+01, 4.6725309718E+00, 3.9692543331E+00, 1.8697592487E+00, 8.7452746358E-01],
	[2.2840000000E+04, 1.4524040059E+01, 4.6724569465E+00, 3.9720955688E+00, 1.8704601291E+00, 8.7459705621E-01],
	[2.2845000000E+04, 1.4529014446E+01, 4.6723829385E+00, 3.9749382156E+00, 1.8711609018E+00, 8.7466661155E-01],
	[2.2850000000E+04, 1.4533989448E+01, 4.6723089480E+00, 3.9777822739E+00, 1.8718615669E+00, 8.7473612961E-01],
	[2.2855000000E+04, 1.4538965063E+01, 4.6722349748E+00, 3.9806277441E+00, 1.8725621241E+00, 8.7480561041E-01],
	[2.2860000000E+04, 1.4543941294E+01, 4.6721610189E+00, 3.9834746266E+00, 1.8732625734E+00, 8.7487505397E-01],
	[2.2865000000E+04, 1.4548918138E+01, 4.6720870804E+00, 3.9863229218E+00, 1.8739629146E+00, 8.7494446030E-01],
	[2.2870000000E+04, 1.4553895597E+01, 4.6720131593E+00, 3.9891726301E+00, 1.8746631476E+00, 8.7501382942E-01],
	[2.2875000000E+04, 1.4558873670E+01, 4.6719392554E+00, 3.9920237518E+00, 1.8753632723E+00, 8.7508316134E-01],
	[2.2880000000E+04, 1.4563852358E+01, 4.6718653689E+00, 3.9948762874E+00, 1.8760632886E+00, 8.7515245607E-01],
	[2.2885000000E+04, 1.4568831659E+01, 4.6717914997E+00, 3.9977302372E+00, 1.8767631964E+00, 8.7522171363E-01],
	[2.2890000000E+04, 1.4573811575E+01, 4.6717176478E+00, 4.0005856017E+00, 1.8774629955E+00, 8.7529093404E-01],
	[2.2895000000E+04, 1.4578792104E+01, 4.6716438132E+00, 4.0034423812E+00, 1.8781626859E+00, 8.7536011731E-01],
	[2.2900000000E+04, 1.4583773248E+01, 4.6715699959E+00, 4.0063005761E+00, 1.8788622674E+00, 8.7542926346E-01],
	[2.2905000000E+04, 1.4588755005E+01, 4.6714961959E+00, 4.0091601869E+00, 1.8795617399E+00, 8.7549837250E-01],
	[2.2910000000E+04, 1.4593737376E+01, 4.6714224131E+00, 4.0120212138E+00, 1.8802611032E+00, 8.7556744445E-01],
	[2.2915000000E+04, 1.4598720361E+01, 4.6713486476E+00, 4.0148836574E+00, 1.8809603574E+00, 8.7563647932E-01],
	[2.2920000000E+04, 1.4603703960E+01, 4.6712748994E+00, 4.0177475179E+00, 1.8816595021E+00, 8.7570547713E-01],
	[2.2925000000E+04, 1.4608688172E+01, 4.6712011684E+00, 4.0206127958E+00, 1.8823585375E+00, 8.7577443789E-01],
	[2.2930000000E+04, 1.4613672998E+01, 4.6711274547E+00, 4.0234794915E+00, 1.8830574632E+00, 8.7584336162E-01],
	[2.2935000000E+04, 1.4618658437E+01, 4.6710537582E+00, 4.0263476054E+00, 1.8837562793E+00, 8.7591224833E-01],
	[2.2940000000E+04, 1.4623644490E+01, 4.6709800789E+00, 4.0292171379E+00, 1.8844549855E+00, 8.7598109804E-01],
	[2.2945000000E+04, 1.4628631156E+01, 4.6709064168E+00, 4.0320880892E+00, 1.8851535818E+00, 8.7604991077E-01],
	[2.2950000000E+04, 1.4633618436E+01, 4.6708327720E+00, 4.0349604600E+00, 1.8858520681E+00, 8.7611868653E-01],
	[2.2955000000E+04, 1.4638606329E+01, 4.6707591444E+00, 4.0378342504E+00, 1.8865504442E+00, 8.7618742533E-01],
	[2.2960000000E+04, 1.4643594835E+01, 4.6706855339E+00, 4.0407094611E+00, 1.8872487101E+00, 8.7625612719E-01],
	[2.2965000000E+04, 1.4648583955E+01, 4.6706119406E+00, 4.0435860922E+00, 1.8879468655E+00, 8.7632479213E-01],
	[2.2970000000E+04, 1.4653573687E+01, 4.6705383646E+00, 4.0464641442E+00, 1.8886449105E+00, 8.7639342015E-01],
	[2.2975000000E+04, 1.4658564033E+01, 4.6704648057E+00, 4.0493436176E+00, 1.8893428449E+00, 8.7646201129E-01],
	[2.2980000000E+04, 1.4663554991E+01, 4.6703912639E+00, 4.0522245126E+00, 1.8900406685E+00, 8.7653056555E-01],
	[2.2985000000E+04, 1.4668546563E+01, 4.6703177393E+00, 4.0551068297E+00, 1.8907383813E+00, 8.7659908294E-01],
	[2.2990000000E+04, 1.4673538747E+01, 4.6702442319E+00, 4.0579905693E+00, 1.8914359832E+00, 8.7666756349E-01],
	[2.2995000000E+04, 1.4678531545E+01, 4.6701707416E+00, 4.0608757318E+00, 1.8921334740E+00, 8.7673600720E-01],
	[2.3000000000E+04, 1.4683524955E+01, 4.6700972684E+00, 4.0637623176E+00, 1.8928308536E+00, 8.7680441410E-01],
	[2.3005000000E+04, 1.4688518978E+01, 4.6700238124E+00, 4.0666503270E+00, 1.8935281219E+00, 8.7687278419E-01],
	[2.3010000000E+04, 1.4693513613E+01, 4.6699503735E+00, 4.0695397605E+00, 1.8942252788E+00, 8.7694111751E-01],
	[2.3015000000E+04, 1.4698508861E+01, 4.6698769517E+00, 4.0724306184E+00, 1.8949223241E+00, 8.7700941405E-01],
	[2.3020000000E+04, 1.4703504722E+01, 4.6698035470E+00, 4.0753229012E+00, 1.8956192579E+00, 8.7707767383E-01],
	[2.3025000000E+04, 1.4708501195E+01, 4.6697301594E+00, 4.0782166091E+00, 1.8963160799E+00, 8.7714589688E-01],
	[2.3030000000E+04, 1.4713498280E+01, 4.6696567889E+00, 4.0811117428E+00, 1.8970127900E+00, 8.7721408321E-01],
	[2.3035000000E+04, 1.4718495978E+01, 4.6695834354E+00, 4.0840083024E+00, 1.8977093882E+00, 8.7728223282E-01],
	[2.3040000000E+04, 1.4723494288E+01, 4.6695100991E+00, 4.0869062884E+00, 1.8984058743E+00, 8.7735034575E-01],
	[2.3045000000E+04, 1.4728493211E+01, 4.6694367798E+00, 4.0898057012E+00, 1.8991022482E+00, 8.7741842199E-01],
	[2.3050000000E+04, 1.4733492746E+01, 4.6693634775E+00, 4.0927065413E+00, 1.8997985098E+00, 8.7748646158E-01],
	[2.3055000000E+04, 1.4738492892E+01, 4.6692901923E+00, 4.0956088089E+00, 1.9004946589E+00, 8.7755446452E-01],
	[2.3060000000E+04, 1.4743493651E+01, 4.6692169242E+00, 4.0985125045E+00, 1.9011906956E+00, 8.7762243083E-01],
	[2.3065000000E+04, 1.4748495022E+01, 4.6691436731E+00, 4.1014176284E+00, 1.9018866196E+00, 8.7769036052E-01],
	[2.3070000000E+04, 1.4753497005E+01, 4.6690704390E+00, 4.1043241812E+00, 1.9025824308E+00, 8.7775825361E-01],
	[2.3075000000E+04, 1.4758499600E+01, 4.6689972219E+00, 4.1072321630E+00, 1.9032781292E+00, 8.7782611013E-01],
	[2.3080000000E+04, 1.4763502807E+01, 4.6689240218E+00, 4.1101415745E+00, 1.9039737146E+00, 8.7789393007E-01],
	[2.3085000000E+04, 1.4768506625E+01, 4.6688508388E+00, 4.1130524158E+00, 1.9046691869E+00, 8.7796171346E-01],
	[2.3090000000E+04, 1.4773511055E+01, 4.6687776727E+00, 4.1159646875E+00, 1.9053645460E+00, 8.7802946032E-01],
	[2.3095000000E+04, 1.4778516097E+01, 4.6687045236E+00, 4.1188783900E+00, 1.9060597918E+00, 8.7809717065E-01],
	[2.3100000000E+04, 1.4783521751E+01, 4.6686313916E+00, 4.1217935235E+00, 1.9067549242E+00, 8.7816484448E-01],
	[2.3105000000E+04, 1.4788528016E+01, 4.6685582764E+00, 4.1247100886E+00, 1.9074499430E+00, 8.7823248182E-01],
	[2.3110000000E+04, 1.4793534892E+01, 4.6684851783E+00, 4.1276280856E+00, 1.9081448482E+00, 8.7830008268E-01],
	[2.3115000000E+04, 1.4798542380E+01, 4.6684120971E+00, 4.1305475149E+00, 1.9088396397E+00, 8.7836764709E-01],
	[2.3120000000E+04, 1.4803550480E+01, 4.6683390328E+00, 4.1334683768E+00, 1.9095343173E+00, 8.7843517505E-01],
	[2.3125000000E+04, 1.4808559191E+01, 4.6682659855E+00, 4.1363906719E+00, 1.9102288809E+00, 8.7850266659E-01],
	[2.3130000000E+04, 1.4813568513E+01, 4.6681929552E+00, 4.1393144004E+00, 1.9109233304E+00, 8.7857012171E-01],
	[2.3135000000E+04, 1.4818578446E+01, 4.6681199417E+00, 4.1422395628E+00, 1.9116176658E+00, 8.7863754044E-01],
	[2.3140000000E+04, 1.4823588990E+01, 4.6680469452E+00, 4.1451661595E+00, 1.9123118868E+00, 8.7870492279E-01],
	[2.3145000000E+04, 1.4828600146E+01, 4.6679739656E+00, 4.1480941908E+00, 1.9130059935E+00, 8.7877226878E-01],
	[2.3150000000E+04, 1.4833611912E+01, 4.6679010029E+00, 4.1510236572E+00, 1.9136999856E+00, 8.7883957842E-01],
	[2.3155000000E+04, 1.4838624290E+01, 4.6678280571E+00, 4.1539545590E+00, 1.9143938631E+00, 8.7890685172E-01],
	[2.3160000000E+04, 1.4843637278E+01, 4.6677551281E+00, 4.1568868966E+00, 1.9150876259E+00, 8.7897408871E-01],
	[2.3165000000E+04, 1.4848656676E+01, 4.6676832267E+00, 4.1598206705E+00, 1.9157815405E+00, 8.7904128940E-01],
	[2.3170000000E+04, 1.4853694349E+01, 4.6676144186E+00, 4.1627558810E+00, 1.9164761532E+00, 8.7910845380E-01],
	[2.3175000000E+04, 1.4858732644E+01, 4.6675456265E+00, 4.1656925285E+00, 1.9171706520E+00, 8.7917558193E-01],
	[2.3180000000E+04, 1.4863771560E+01, 4.6674768501E+00, 4.1686306135E+00, 1.9178650366E+00, 8.7924267381E-01],
	[2.3185000000E+04, 1.4868811098E+01, 4.6674080897E+00, 4.1715701362E+00, 1.9185593071E+00, 8.7930972946E-01],
	[2.3190000000E+04, 1.4873851256E+01, 4.6673393450E+00, 4.1745110971E+00, 1.9192534632E+00, 8.7937674888E-01],
	[2.3195000000E+04, 1.4878892037E+01, 4.6672706162E+00, 4.1774534966E+00, 1.9199475050E+00, 8.7944373209E-01],
	[2.3200000000E+04, 1.4883933438E+01, 4.6672019032E+00, 4.1803973351E+00, 1.9206414322E+00, 8.7951067911E-01],
	[2.3205000000E+04, 1.4888975461E+01, 4.6671332061E+00, 4.1833426130E+00, 1.9213352448E+00, 8.7957758996E-01],
	[2.3210000000E+04, 1.4894018105E+01, 4.6670645247E+00, 4.1862893306E+00, 1.9220289427E+00, 8.7964446465E-01],
	[2.3215000000E+04, 1.4899061370E+01, 4.6669958592E+00, 4.1892374884E+00, 1.9227225257E+00, 8.7971130320E-01],
	[2.3220000000E+04, 1.4904105256E+01, 4.6669272095E+00, 4.1921870868E+00, 1.9234159938E+00, 8.7977810562E-01],
	[2.3225000000E+04, 1.4909149763E+01, 4.6668585755E+00, 4.1951381261E+00, 1.9241093468E+00, 8.7984487193E-01],
	[2.3230000000E+04, 1.4914194892E+01, 4.6667899573E+00, 4.1980906068E+00, 1.9248025847E+00, 8.7991160215E-01],
	[2.3235000000E+04, 1.4919240641E+01, 4.6667213549E+00, 4.2010445291E+00, 1.9254957073E+00, 8.7997829628E-01],
	[2.3240000000E+04, 1.4924287010E+01, 4.6666527683E+00, 4.2039998937E+00, 1.9261887145E+00, 8.8004495436E-01],
	[2.3245000000E+04, 1.4929334001E+01, 4.6665841974E+00, 4.2069567007E+00, 1.9268816062E+00, 8.8011157638E-01],
	[2.3250000000E+04, 1.4934381612E+01, 4.6665156423E+00, 4.2099149507E+00, 1.9275743824E+00, 8.8017816238E-01],
	[2.3255000000E+04, 1.4939429844E+01, 4.6664471030E+00, 4.2128746439E+00, 1.9282670429E+00, 8.8024471236E-01],
	[2.3260000000E+04, 1.4944478697E+01, 4.6663785793E+00, 4.2158357809E+00, 1.9289595875E+00, 8.8031122634E-01],
	[2.3265000000E+04, 1.4949528170E+01, 4.6663100715E+00, 4.2187983619E+00, 1.9296520163E+00, 8.8037770433E-01],
	[2.3270000000E+04, 1.4954578263E+01, 4.6662415793E+00, 4.2217623875E+00, 1.9303443290E+00, 8.8044414636E-01],
	[2.3275000000E+04, 1.4959628977E+01, 4.6661731029E+00, 4.2247278579E+00, 1.9310365256E+00, 8.8051055244E-01],
	[2.3280000000E+04, 1.4964680312E+01, 4.6661046421E+00, 4.2276947737E+00, 1.9317286060E+00, 8.8057692258E-01],
	[2.3285000000E+04, 1.4969732266E+01, 4.6660361971E+00, 4.2306631351E+00, 1.9324205701E+00, 8.8064325680E-01],
	[2.3290000000E+04, 1.4974784841E+01, 4.6659677678E+00, 4.2336329425E+00, 1.9331124177E+00, 8.8070955512E-01],
	[2.3295000000E+04, 1.4979838036E+01, 4.6658993542E+00, 4.2366041964E+00, 1.9338041488E+00, 8.8077581755E-01],
	[2.3300000000E+04, 1.4984891852E+01, 4.6658309562E+00, 4.2395768972E+00, 1.9344957632E+00, 8.8084204411E-01],
	[2.3305000000E+04, 1.4989946287E+01, 4.6657625740E+00, 4.2425510452E+00, 1.9351872609E+00, 8.8090823482E-01],
	[2.3310000000E+04, 1.4995001342E+01, 4.6656942074E+00, 4.2455266409E+00, 1.9358786418E+00, 8.8097438968E-01],
	[2.3315000000E+04, 1.5000057018E+01, 4.6656258565E+00, 4.2485036845E+00, 1.9365699056E+00, 8.8104050872E-01],
	[2.3320000000E+04, 1.5005113313E+01, 4.6655575212E+00, 4.2514821767E+00, 1.9372610525E+00, 8.8110659196E-01],
	[2.3325000000E+04, 1.5010170228E+01, 4.6654892016E+00, 4.2544621176E+00, 1.9379520821E+00, 8.8117263940E-01],
	[2.3330000000E+04, 1.5015227763E+01, 4.6654208976E+00, 4.2574435078E+00, 1.9386429945E+00, 8.8123865107E-01],
	[2.3335000000E+04, 1.5020285918E+01, 4.6653526093E+00, 4.2604263475E+00, 1.9393337894E+00, 8.8130462697E-01],
	[2.3340000000E+04, 1.5025344692E+01, 4.6652843365E+00, 4.2634106373E+00, 1.9400244670E+00, 8.8137056714E-01],
	[2.3345000000E+04, 1.5030404086E+01, 4.6652160795E+00, 4.2663963774E+00, 1.9407150269E+00, 8.8143647158E-01],
	[2.3350000000E+04, 1.5035464100E+01, 4.6651478380E+00, 4.2693835684E+00, 1.9414054691E+00, 8.8150234030E-01],
	[2.3355000000E+04, 1.5040524733E+01, 4.6650796121E+00, 4.2723722105E+00, 1.9420957935E+00, 8.8156817334E-01],
	[2.3360000000E+04, 1.5045585986E+01, 4.6650114019E+00, 4.2753623043E+00, 1.9427860001E+00, 8.8163397069E-01],
	[2.3365000000E+04, 1.5050647857E+01, 4.6649432072E+00, 4.2783538500E+00, 1.9434760886E+00, 8.8169973238E-01],
	[2.3370000000E+04, 1.5055710349E+01, 4.6648750281E+00, 4.2813468480E+00, 1.9441660590E+00, 8.8176545843E-01],
	[2.3375000000E+04, 1.5060773459E+01, 4.6648068646E+00, 4.2843412989E+00, 1.9448559113E+00, 8.8183114884E-01],
	[2.3380000000E+04, 1.5065837189E+01, 4.6647387167E+00, 4.2873372028E+00, 1.9455456452E+00, 8.8189680364E-01],
	[2.3385000000E+04, 1.5070901538E+01, 4.6646705844E+00, 4.2903345604E+00, 1.9462352607E+00, 8.8196242284E-01],
	[2.3390000000E+04, 1.5075966506E+01, 4.6646024676E+00, 4.2933333718E+00, 1.9469247577E+00, 8.8202800646E-01],
	[2.3395000000E+04, 1.5081032094E+01, 4.6645343663E+00, 4.2963336377E+00, 1.9476141361E+00, 8.8209355452E-01],
	[2.3400000000E+04, 1.5086098300E+01, 4.6644662807E+00, 4.2993353582E+00, 1.9483033957E+00, 8.8215906702E-01],
	[2.3405000000E+04, 1.5091165125E+01, 4.6643982105E+00, 4.3023385339E+00, 1.9489925366E+00, 8.8222454399E-01],
	[2.3410000000E+04, 1.5096232569E+01, 4.6643301559E+00, 4.3053431651E+00, 1.9496815585E+00, 8.8228998545E-01],
	[2.3415000000E+04, 1.5101300632E+01, 4.6642621168E+00, 4.3083492522E+00, 1.9503704614E+00, 8.8235539140E-01],
	[2.3420000000E+04, 1.5106369313E+01, 4.6641940932E+00, 4.3113567956E+00, 1.9510592451E+00, 8.8242076187E-01],
	[2.3425000000E+04, 1.5111438614E+01, 4.6641260852E+00, 4.3143657957E+00, 1.9517479096E+00, 8.8248609687E-01],
	[2.3430000000E+04, 1.5116508533E+01, 4.6640580926E+00, 4.3173762529E+00, 1.9524364548E+00, 8.8255139642E-01],
	[2.3435000000E+04, 1.5121579071E+01, 4.6639901156E+00, 4.3203881677E+00, 1.9531248806E+00, 8.8261666053E-01],
	[2.3440000000E+04, 1.5126650227E+01, 4.6639221540E+00, 4.3234015403E+00, 1.9538131868E+00, 8.8268188922E-01],
	[2.3445000000E+04, 1.5131722002E+01, 4.6638542079E+00, 4.3264163711E+00, 1.9545013734E+00, 8.8274708251E-01],
	[2.3450000000E+04, 1.5136794395E+01, 4.6637862773E+00, 4.3294326607E+00, 1.9551894403E+00, 8.8281224041E-01],
	[2.3455000000E+04, 1.5141867406E+01, 4.6637183622E+00, 4.3324504093E+00, 1.9558773873E+00, 8.8287736294E-01],
	[2.3460000000E+04, 1.5146941036E+01, 4.6636504626E+00, 4.3354696174E+00, 1.9565652144E+00, 8.8294245012E-01],
	[2.3465000000E+04, 1.5152015284E+01, 4.6635825784E+00, 4.3384902854E+00, 1.9572529215E+00, 8.8300750195E-01],
	[2.3470000000E+04, 1.5157090151E+01, 4.6635147096E+00, 4.3415124136E+00, 1.9579405084E+00, 8.8307251846E-01],
	[2.3475000000E+04, 1.5162165635E+01, 4.6634468563E+00, 4.3445360024E+00, 1.9586279751E+00, 8.8313749967E-01],
	[2.3480000000E+04, 1.5167241738E+01, 4.6633790184E+00, 4.3475610523E+00, 1.9593153214E+00, 8.8320244559E-01],
	[2.3485000000E+04, 1.5172318458E+01, 4.6633111960E+00, 4.3505875637E+00, 1.9600025473E+00, 8.8326735623E-01],
	[2.3490000000E+04, 1.5177395797E+01, 4.6632433890E+00, 4.3536155368E+00, 1.9606896527E+00, 8.8333223162E-01],
	[2.3495000000E+04, 1.5182473754E+01, 4.6631755974E+00, 4.3566449722E+00, 1.9613766374E+00, 8.8339707177E-01],
	[2.3500000000E+04, 1.5187552328E+01, 4.6631078212E+00, 4.3596758702E+00, 1.9620635014E+00, 8.8346187669E-01],
	[2.3505000000E+04, 1.5192631520E+01, 4.6630400604E+00, 4.3627082313E+00, 1.9627502446E+00, 8.8352664640E-01],
	[2.3510000000E+04, 1.5197711330E+01, 4.6629723150E+00, 4.3657420557E+00, 1.9634368668E+00, 8.8359138092E-01],
	[2.3515000000E+04, 1.5202791758E+01, 4.6629045850E+00, 4.3687773440E+00, 1.9641233680E+00, 8.8365608027E-01],
	[2.3520000000E+04, 1.5207872804E+01, 4.6628368704E+00, 4.3718140964E+00, 1.9648097481E+00, 8.8372074445E-01],
	[2.3525000000E+04, 1.5212954467E+01, 4.6627691712E+00, 4.3748523134E+00, 1.9654960069E+00, 8.8378537349E-01],
	[2.3530000000E+04, 1.5218036747E+01, 4.6627014873E+00, 4.3778919955E+00, 1.9661821444E+00, 8.8384996741E-01],
	[2.3535000000E+04, 1.5223119645E+01, 4.6626338188E+00, 4.3809331429E+00, 1.9668681604E+00, 8.8391452622E-01],
	[2.3540000000E+04, 1.5228218784E+01, 4.6625688397E+00, 4.3839757561E+00, 1.9675547920E+00, 8.8397904993E-01],
	[2.3545000000E+04, 1.5233326378E+01, 4.6625052148E+00, 4.3870198355E+00, 1.9682416720E+00, 8.8404353856E-01],
	[2.3550000000E+04, 1.5238434600E+01, 4.6624416043E+00, 4.3900653814E+00, 1.9689284314E+00, 8.8410799213E-01],
	[2.3555000000E+04, 1.5243543449E+01, 4.6623780081E+00, 4.3931123943E+00, 1.9696150700E+00, 8.8417241066E-01],
	[2.3560000000E+04, 1.5248652927E+01, 4.6623144264E+00, 4.3961608746E+00, 1.9703015878E+00, 8.8423679416E-01],
	[2.3565000000E+04, 1.5253763032E+01, 4.6622508590E+00, 4.3992108226E+00, 1.9709879846E+00, 8.8430114265E-01],
	[2.3570000000E+04, 1.5258873766E+01, 4.6621873059E+00, 4.4022622387E+00, 1.9716742604E+00, 8.8436545614E-01],
	[2.3575000000E+04, 1.5263985127E+01, 4.6621237672E+00, 4.4053151235E+00, 1.9723604150E+00, 8.8442973465E-01],
	[2.3580000000E+04, 1.5269097115E+01, 4.6620602428E+00, 4.4083694771E+00, 1.9730464484E+00, 8.8449397820E-01],
	[2.3585000000E+04, 1.5274209732E+01, 4.6619967328E+00, 4.4114253001E+00, 1.9737323605E+00, 8.8455818681E-01],
	[2.3590000000E+04, 1.5279322976E+01, 4.6619332371E+00, 4.4144825928E+00, 1.9744181511E+00, 8.8462236048E-01],
	[2.3595000000E+04, 1.5284436847E+01, 4.6618697557E+00, 4.4175413556E+00, 1.9751038201E+00, 8.8468649924E-01],
	[2.3600000000E+04, 1.5289551346E+01, 4.6618062886E+00, 4.4206015890E+00, 1.9757893675E+00, 8.8475060310E-01],
	[2.3605000000E+04, 1.5294666472E+01, 4.6617428359E+00, 4.4236632933E+00, 1.9764747932E+00, 8.8481467208E-01],
	[2.3610000000E+04, 1.5299782226E+01, 4.6616793974E+00, 4.4267264688E+00, 1.9771600971E+00, 8.8487870620E-01],
	[2.3615000000E+04, 1.5304898607E+01, 4.6616159732E+00, 4.4297911161E+00, 1.9778452791E+00, 8.8494270547E-01],
	[2.3620000000E+04, 1.5310015615E+01, 4.6615525634E+00, 4.4328572355E+00, 1.9785303390E+00, 8.8500666991E-01],
	[2.3625000000E+04, 1.5315133250E+01, 4.6614891678E+00, 4.4359248274E+00, 1.9792152768E+00, 8.8507059953E-01],
	[2.3630000000E+04, 1.5320251513E+01, 4.6614257865E+00, 4.4389938921E+00, 1.9799000924E+00, 8.8513449436E-01],
	[2.3635000000E+04, 1.5325370402E+01, 4.6613624194E+00, 4.4420644302E+00, 1.9805847857E+00, 8.8519835440E-01],
	[2.3640000000E+04, 1.5330489919E+01, 4.6612990667E+00, 4.4451364419E+00, 1.9812693566E+00, 8.8526217968E-01],
	[2.3645000000E+04, 1.5335610063E+01, 4.6612357281E+00, 4.4482099277E+00, 1.9819538050E+00, 8.8532597020E-01],
	[2.3650000000E+04, 1.5340730833E+01, 4.6611724039E+00, 4.4512848880E+00, 1.9826381307E+00, 8.8538972600E-01],
	[2.3655000000E+04, 1.5345852230E+01, 4.6611090939E+00, 4.4543613232E+00, 1.9833223338E+00, 8.8545344708E-01],
	[2.3660000000E+04, 1.5350974255E+01, 4.6610457981E+00, 4.4574392336E+00, 1.9840064141E+00, 8.8551713346E-01],
	[2.3665000000E+04, 1.5356096905E+01, 4.6609825165E+00, 4.4605186196E+00, 1.9846903716E+00, 8.8558078515E-01],
	[2.3670000000E+04, 1.5361220183E+01, 4.6609192492E+00, 4.4635994818E+00, 1.9853742060E+00, 8.8564440218E-01],
	[2.3675000000E+04, 1.5366344087E+01, 4.6608559961E+00, 4.4666818203E+00, 1.9860579174E+00, 8.8570798456E-01],
	[2.3680000000E+04, 1.5371468618E+01, 4.6607927572E+00, 4.4697656357E+00, 1.9867415056E+00, 8.8577153231E-01],
	[2.3685000000E+04, 1.5376593775E+01, 4.6607295326E+00, 4.4728509284E+00, 1.9874249706E+00, 8.8583504544E-01],
	[2.3690000000E+04, 1.5381719559E+01, 4.6606663221E+00, 4.4759376987E+00, 1.9881083121E+00, 8.8589852397E-01],
	[2.3695000000E+04, 1.5386845969E+01, 4.6606031258E+00, 4.4790259470E+00, 1.9887915303E+00, 8.8596196791E-01],
	[2.3700000000E+04, 1.5391973006E+01, 4.6605399438E+00, 4.4821156737E+00, 1.9894746249E+00, 8.8602537729E-01],
	[2.3705000000E+04, 1.5397100668E+01, 4.6604767759E+00, 4.4852068793E+00, 1.9901575958E+00, 8.8608875211E-01],
	[2.3710000000E+04, 1.5402228957E+01, 4.6604136221E+00, 4.4882995641E+00, 1.9908404431E+00, 8.8615209240E-01],
	[2.3715000000E+04, 1.5407357873E+01, 4.6603504826E+00, 4.4913937285E+00, 1.9915231665E+00, 8.8621539818E-01],
	[2.3720000000E+04, 1.5412487414E+01, 4.6602873572E+00, 4.4944893729E+00, 1.9922057660E+00, 8.8627866951E-01],
	[2.3725000000E+04, 1.5417617581E+01, 4.6602242460E+00, 4.4975864977E+00, 1.9928882414E+00, 8.8634190641E-01],
	[2.3730000000E+04, 1.5422748375E+01, 4.6601611489E+00, 4.5006851033E+00, 1.9935705928E+00, 8.8640510891E-01],
	[2.3735000000E+04, 1.5427879794E+01, 4.6600980660E+00, 4.5037851901E+00, 1.9942528199E+00, 8.8646827700E-01],
	[2.3740000000E+04, 1.5433011840E+01, 4.6600349972E+00, 4.5068867585E+00, 1.9949349228E+00, 8.8653141072E-01],
	[2.3745000000E+04, 1.5438144511E+01, 4.6599719426E+00, 4.5099898089E+00, 1.9956169013E+00, 8.8659451007E-01],
	[2.3750000000E+04, 1.5443277808E+01, 4.6599089021E+00, 4.5130943416E+00, 1.9962987553E+00, 8.8665757507E-01],
	[2.3755000000E+04, 1.5448411730E+01, 4.6598458757E+00, 4.5162003572E+00, 1.9969804847E+00, 8.8672060572E-01],
	[2.3760000000E+04, 1.5453546279E+01, 4.6597828634E+00, 4.5193078559E+00, 1.9976620895E+00, 8.8678360205E-01],
	[2.3765000000E+04, 1.5458681453E+01, 4.6597198653E+00, 4.5224168381E+00, 1.9983435695E+00, 8.8684656407E-01],
	[2.3770000000E+04, 1.5463817252E+01, 4.6596568812E+00, 4.5255273044E+00, 1.9990249246E+00, 8.8690949180E-01],
	[2.3775000000E+04, 1.5468953677E+01, 4.6595939112E+00, 4.5286392550E+00, 1.9997061548E+00, 8.8697238524E-01],
	[2.3780000000E+04, 1.5474090728E+01, 4.6595309554E+00, 4.5317526904E+00, 2.0003872600E+00, 8.8703524441E-01],
	[2.3785000000E+04, 1.5479228404E+01, 4.6594680136E+00, 4.5348676109E+00, 2.0010682400E+00, 8.8709806932E-01],
	[2.3790000000E+04, 1.5484366705E+01, 4.6594050859E+00, 4.5379840170E+00, 2.0017490949E+00, 8.8716086000E-01],
	[2.3795000000E+04, 1.5489505632E+01, 4.6593421723E+00, 4.5411019090E+00, 2.0024298244E+00, 8.8722361645E-01],
	[2.3800000000E+04, 1.5494645184E+01, 4.6592792727E+00, 4.5442212873E+00, 2.0031104285E+00, 8.8728633869E-01],
	[2.3805000000E+04, 1.5499785361E+01, 4.6592163872E+00, 4.5473421524E+00, 2.0037909072E+00, 8.8734902673E-01],
	[2.3810000000E+04, 1.5504926163E+01, 4.6591535158E+00, 4.5504645047E+00, 2.0044712602E+00, 8.8741168059E-01],
	[2.3815000000E+04, 1.5510067590E+01, 4.6590906584E+00, 4.5535883444E+00, 2.0051514876E+00, 8.8747430028E-01],
	[2.3820000000E+04, 1.5515209642E+01, 4.6590278150E+00, 4.5567136721E+00, 2.0058315892E+00, 8.8753688581E-01],
	[2.3825000000E+04, 1.5520352320E+01, 4.6589649857E+00, 4.5598404881E+00, 2.0065115649E+00, 8.8759943720E-01],
	[2.3830000000E+04, 1.5525495622E+01, 4.6589021704E+00, 4.5629687928E+00, 2.0071914147E+00, 8.8766195447E-01],
	[2.3835000000E+04, 1.5530639549E+01, 4.6588393692E+00, 4.5660985867E+00, 2.0078711385E+00, 8.8772443763E-01],
	[2.3840000000E+04, 1.5535784101E+01, 4.6587765819E+00, 4.5692298700E+00, 2.0085507361E+00, 8.8778688668E-01],
	[2.3845000000E+04, 1.5540929277E+01, 4.6587138087E+00, 4.5723626433E+00, 2.0092302076E+00, 8.8784930166E-01],
	[2.3850000000E+04, 1.5546075078E+01, 4.6586510495E+00, 4.5754969069E+00, 2.0099095527E+00, 8.8791168256E-01],
	[2.3855000000E+04, 1.5551221504E+01, 4.6585883043E+00, 4.5786326611E+00, 2.0105887714E+00, 8.8797402941E-01],
	[2.3860000000E+04, 1.5556368555E+01, 4.6585255730E+00, 4.5817699065E+00, 2.0112678636E+00, 8.8803634222E-01],
	[2.3865000000E+04, 1.5561516230E+01, 4.6584628558E+00, 4.5849086433E+00, 2.0119468292E+00, 8.8809862101E-01],
	[2.3870000000E+04, 1.5566664529E+01, 4.6584001526E+00, 4.5880488720E+00, 2.0126256682E+00, 8.8816086578E-01],
	[2.3875000000E+04, 1.5571813453E+01, 4.6583374633E+00, 4.5911905931E+00, 2.0133043804E+00, 8.8822307656E-01],
	[2.3880000000E+04, 1.5576963001E+01, 4.6582747880E+00, 4.5943338067E+00, 2.0139829658E+00, 8.8828525335E-01],
	[2.3885000000E+04, 1.5582113174E+01, 4.6582121266E+00, 4.5974785135E+00, 2.0146614242E+00, 8.8834739617E-01],
	[2.3890000000E+04, 1.5587263970E+01, 4.6581494793E+00, 4.6006247138E+00, 2.0153397556E+00, 8.8840950504E-01],
	[2.3895000000E+04, 1.5592415391E+01, 4.6580868458E+00, 4.6037724079E+00, 2.0160179599E+00, 8.8847157997E-01],
	[2.3900000000E+04, 1.5597567436E+01, 4.6580242264E+00, 4.6069215963E+00, 2.0166960370E+00, 8.8853362098E-01],
	[2.3905000000E+04, 1.5602720106E+01, 4.6579616208E+00, 4.6100722793E+00, 2.0173739868E+00, 8.8859562808E-01],
	[2.3910000000E+04, 1.5607873399E+01, 4.6578990292E+00, 4.6132244574E+00, 2.0180518093E+00, 8.8865760127E-01],
	[2.3915000000E+04, 1.5613027316E+01, 4.6578364515E+00, 4.6163781310E+00, 2.0187295042E+00, 8.8871954059E-01],
	[2.3920000000E+04, 1.5618202597E+01, 4.6577773741E+00, 4.6195333004E+00, 2.0194080737E+00, 8.8878144604E-01],
	[2.3925000000E+04, 1.5623381219E+01, 4.6577187648E+00, 4.6226899660E+00, 2.0200866472E+00, 8.8884331764E-01],
	[2.3930000000E+04, 1.5628560476E+01, 4.6576601684E+00, 4.6258481283E+00, 2.0207650941E+00, 8.8890515540E-01],
	[2.3935000000E+04, 1.5633740367E+01, 4.6576015850E+00, 4.6290077877E+00, 2.0214434143E+00, 8.8896695933E-01],
	[2.3940000000E+04, 1.5638920892E+01, 4.6575430146E+00, 4.6321689445E+00, 2.0221216075E+00, 8.8902872946E-01],
	[2.3945000000E+04, 1.5644102052E+01, 4.6574844572E+00, 4.6353315991E+00, 2.0227996738E+00, 8.8909046579E-01],
	[2.3950000000E+04, 1.5649283846E+01, 4.6574259127E+00, 4.6384957520E+00, 2.0234776131E+00, 8.8915216834E-01],
	[2.3955000000E+04, 1.5654466274E+01, 4.6573673812E+00, 4.6416614034E+00, 2.0241554252E+00, 8.8921383713E-01],
	[2.3960000000E+04, 1.5659649336E+01, 4.6573088627E+00, 4.6448285539E+00, 2.0248331102E+00, 8.8927547217E-01],
	[2.3965000000E+04, 1.5664833032E+01, 4.6572503570E+00, 4.6479972039E+00, 2.0255106678E+00, 8.8933707347E-01],
	[2.3970000000E+04, 1.5670017362E+01, 4.6571918644E+00, 4.6511673536E+00, 2.0261880980E+00, 8.8939864104E-01],
	[2.3975000000E+04, 1.5675202326E+01, 4.6571333846E+00, 4.6543390036E+00, 2.0268654008E+00, 8.8946017491E-01],
	[2.3980000000E+04, 1.5680387924E+01, 4.6570749178E+00, 4.6575121541E+00, 2.0275425760E+00, 8.8952167509E-01],
	[2.3985000000E+04, 1.5685574155E+01, 4.6570164639E+00, 4.6606868057E+00, 2.0282196235E+00, 8.8958314159E-01],
	[2.3990000000E+04, 1.5690761021E+01, 4.6569580230E+00, 4.6638629587E+00, 2.0288965433E+00, 8.8964457443E-01],
	[2.3995000000E+04, 1.5695948520E+01, 4.6568995949E+00, 4.6670406135E+00, 2.0295733353E+00, 8.8970597362E-01],
	[2.4000000000E+04, 1.5701136653E+01, 4.6568411797E+00, 4.6702197705E+00, 2.0302499993E+00, 8.8976733917E-01],
	[2.4005000000E+04, 1.5706325419E+01, 4.6567827775E+00, 4.6734004301E+00, 2.0309265354E+00, 8.8982867110E-01],
	[2.4010000000E+04, 1.5711514819E+01, 4.6567243881E+00, 4.6765825927E+00, 2.0316029434E+00, 8.8988996943E-01],
	[2.4015000000E+04, 1.5716704853E+01, 4.6566660117E+00, 4.6797662586E+00, 2.0322792232E+00, 8.8995123417E-01],
	[2.4020000000E+04, 1.5721895519E+01, 4.6566076481E+00, 4.6829514284E+00, 2.0329553748E+00, 8.9001246534E-01],
	[2.4025000000E+04, 1.5727086820E+01, 4.6565492974E+00, 4.6861381023E+00, 2.0336313980E+00, 8.9007366294E-01],
	[2.4030000000E+04, 1.5732278753E+01, 4.6564909596E+00, 4.6893262809E+00, 2.0343072928E+00, 8.9013482700E-01],
	[2.4035000000E+04, 1.5737471320E+01, 4.6564326346E+00, 4.6925159644E+00, 2.0349830591E+00, 8.9019595753E-01],
	[2.4040000000E+04, 1.5742664520E+01, 4.6563743225E+00, 4.6957071532E+00, 2.0356586968E+00, 8.9025705454E-01],
	[2.4045000000E+04, 1.5747858353E+01, 4.6563160232E+00, 4.6988998479E+00, 2.0363342058E+00, 8.9031811805E-01],
	[2.4050000000E+04, 1.5753052820E+01, 4.6562577369E+00, 4.7020940487E+00, 2.0370095860E+00, 8.9037914807E-01],
	[2.4055000000E+04, 1.5758247919E+01, 4.6561994633E+00, 4.7052897561E+00, 2.0376848374E+00, 8.9044014462E-01],
	[2.4060000000E+04, 1.5763443651E+01, 4.6561412026E+00, 4.7084869704E+00, 2.0383599598E+00, 8.9050110771E-01],
	[2.4065000000E+04, 1.5768640017E+01, 4.6560829547E+00, 4.7116856921E+00, 2.0390349533E+00, 8.9056203736E-01],
	[2.4070000000E+04, 1.5773837015E+01, 4.6560247197E+00, 4.7148859216E+00, 2.0397098176E+00, 8.9062293358E-01],
	[2.4075000000E+04, 1.5779034646E+01, 4.6559664975E+00, 4.7180876592E+00, 2.0403845527E+00, 8.9068379639E-01],
	[2.4080000000E+04, 1.5784232910E+01, 4.6559082881E+00, 4.7212909054E+00, 2.0410591586E+00, 8.9074462580E-01],
	[2.4085000000E+04, 1.5789431806E+01, 4.6558500915E+00, 4.7244956605E+00, 2.0417336350E+00, 8.9080542183E-01],
	[2.4090000000E+04, 1.5794631336E+01, 4.6557919077E+00, 4.7277019250E+00, 2.0424079821E+00, 8.9086618448E-01],
	[2.4095000000E+04, 1.5799831498E+01, 4.6557337367E+00, 4.7309096992E+00, 2.0430821996E+00, 8.9092691379E-01],
	[2.4100000000E+04, 1.5805032292E+01, 4.6556755786E+00, 4.7341189836E+00, 2.0437562875E+00, 8.9098760975E-01],
	[2.4105000000E+04, 1.5810233719E+01, 4.6556174332E+00, 4.7373297785E+00, 2.0444302458E+00, 8.9104827239E-01],
	[2.4110000000E+04, 1.5815435778E+01, 4.6555593006E+00, 4.7405420843E+00, 2.0451040742E+00, 8.9110890173E-01],
	[2.4115000000E+04, 1.5820638470E+01, 4.6555011807E+00, 4.7437559015E+00, 2.0457777728E+00, 8.9116949776E-01],
	[2.4120000000E+04, 1.5825841794E+01, 4.6554430737E+00, 4.7469712304E+00, 2.0464513414E+00, 8.9123006052E-01],
	[2.4125000000E+04, 1.5831045751E+01, 4.6553849794E+00, 4.7501880714E+00, 2.0471247800E+00, 8.9129059001E-01],
	[2.4130000000E+04, 1.5836250339E+01, 4.6553268979E+00, 4.7534064250E+00, 2.0477980885E+00, 8.9135108626E-01],
	[2.4135000000E+04, 1.5841455560E+01, 4.6552688291E+00, 4.7566262915E+00, 2.0484712668E+00, 8.9141154926E-01],
	[2.4140000000E+04, 1.5846661413E+01, 4.6552107731E+00, 4.7598476713E+00, 2.0491443148E+00, 8.9147197905E-01],
	[2.4145000000E+04, 1.5851867898E+01, 4.6551527299E+00, 4.7630705648E+00, 2.0498172325E+00, 8.9153237563E-01],
	[2.4150000000E+04, 1.5857075015E+01, 4.6550946994E+00, 4.7662949724E+00, 2.0504900197E+00, 8.9159273903E-01],
	[2.4155000000E+04, 1.5862282764E+01, 4.6550366816E+00, 4.7695208946E+00, 2.0511626764E+00, 8.9165306924E-01],
	[2.4160000000E+04, 1.5867491145E+01, 4.6549786765E+00, 4.7727483316E+00, 2.0518352025E+00, 8.9171336630E-01],
	[2.4165000000E+04, 1.5872700158E+01, 4.6549206842E+00, 4.7759772840E+00, 2.0525075979E+00, 8.9177363021E-01],
	[2.4170000000E+04, 1.5877909803E+01, 4.6548627046E+00, 4.7792077521E+00, 2.0531798626E+00, 8.9183386099E-01],
	[2.4175000000E+04, 1.5883120079E+01, 4.6548047377E+00, 4.7824397363E+00, 2.0538519964E+00, 8.9189405866E-01],
	[2.4180000000E+04, 1.5888330987E+01, 4.6547467836E+00, 4.7856732369E+00, 2.0545239992E+00, 8.9195422322E-01],
	[2.4185000000E+04, 1.5893542527E+01, 4.6546888421E+00, 4.7889082545E+00, 2.0551958711E+00, 8.9201435470E-01],
	[2.4190000000E+04, 1.5898754698E+01, 4.6546309133E+00, 4.7921447894E+00, 2.0558676118E+00, 8.9207445311E-01],
	[2.4195000000E+04, 1.5903967501E+01, 4.6545729972E+00, 4.7953828420E+00, 2.0565392214E+00, 8.9213451847E-01],
	[2.4200000000E+04, 1.5909180935E+01, 4.6545150938E+00, 4.7986224126E+00, 2.0572106997E+00, 8.9219455078E-01],
	[2.4205000000E+04, 1.5914395001E+01, 4.6544572031E+00, 4.8018635018E+00, 2.0578820467E+00, 8.9225455007E-01],
	[2.4210000000E+04, 1.5919609698E+01, 4.6543993251E+00, 4.8051061098E+00, 2.0585532622E+00, 8.9231451634E-01],
	[2.4215000000E+04, 1.5924825027E+01, 4.6543414597E+00, 4.8083502372E+00, 2.0592243463E+00, 8.9237444962E-01],
	[2.4220000000E+04, 1.5930040986E+01, 4.6542836070E+00, 4.8115958842E+00, 2.0598952987E+00, 8.9243434992E-01],
	[2.4225000000E+04, 1.5935257577E+01, 4.6542257670E+00, 4.8148430513E+00, 2.0605661195E+00, 8.9249421726E-01],
	[2.4230000000E+04, 1.5940474799E+01, 4.6541679396E+00, 4.8180917389E+00, 2.0612368086E+00, 8.9255405165E-01],
	[2.4235000000E+04, 1.5945692652E+01, 4.6541101249E+00, 4.8213419473E+00, 2.0619073658E+00, 8.9261385309E-01],
	[2.4240000000E+04, 1.5950911137E+01, 4.6540523228E+00, 4.8245936771E+00, 2.0625777912E+00, 8.9267362162E-01],
	[2.4245000000E+04, 1.5956130252E+01, 4.6539945334E+00, 4.8278469285E+00, 2.0632480845E+00, 8.9273335725E-01],
	[2.4250000000E+04, 1.5961349998E+01, 4.6539367565E+00, 4.8311017020E+00, 2.0639182458E+00, 8.9279305998E-01],
	[2.4255000000E+04, 1.5966570375E+01, 4.6538789924E+00, 4.8343579979E+00, 2.0645882749E+00, 8.9285272984E-01],
	[2.4260000000E+04, 1.5971791383E+01, 4.6538212408E+00, 4.8376158167E+00, 2.0652581719E+00, 8.9291236684E-01],
	[2.4265000000E+04, 1.5977013022E+01, 4.6537635019E+00, 4.8408751588E+00, 2.0659279365E+00, 8.9297197100E-01],
	[2.4270000000E+04, 1.5982235291E+01, 4.6537057755E+00, 4.8441360246E+00, 2.0665975687E+00, 8.9303154232E-01],
	[2.4275000000E+04, 1.5987458191E+01, 4.6536480618E+00, 4.8473984144E+00, 2.0672670685E+00, 8.9309108083E-01],
	[2.4280000000E+04, 1.5992681722E+01, 4.6535903607E+00, 4.8506623286E+00, 2.0679364358E+00, 8.9315058654E-01],
	[2.4285000000E+04, 1.5997905883E+01, 4.6535326722E+00, 4.8539277678E+00, 2.0686056704E+00, 8.9321005947E-01],
	[2.4290000000E+04, 1.6003130675E+01, 4.6534749962E+00, 4.8571947321E+00, 2.0692747723E+00, 8.9326949963E-01],
	[2.4295000000E+04, 1.6008356097E+01, 4.6534173329E+00, 4.8604632222E+00, 2.0699437415E+00, 8.9332890703E-01],
	[2.4300000000E+04, 1.6013582149E+01, 4.6533596821E+00, 4.8637332383E+00, 2.0706125778E+00, 8.9338828169E-01],
	[2.4305000000E+04, 1.6018829529E+01, 4.6533054613E+00, 4.8670047808E+00, 2.0712823043E+00, 8.9344762363E-01],
	[2.4310000000E+04, 1.6024080295E+01, 4.6532517056E+00, 4.8702778502E+00, 2.0719520344E+00, 8.9350693287E-01],
	[2.4315000000E+04, 1.6029331700E+01, 4.6531979615E+00, 4.8735524469E+00, 2.0726216325E+00, 8.9356620941E-01],
	[2.4320000000E+04, 1.6034583747E+01, 4.6531442290E+00, 4.8768285711E+00, 2.0732910984E+00, 8.9362545327E-01],
	[2.4325000000E+04, 1.6039836434E+01, 4.6530905083E+00, 4.8801062235E+00, 2.0739604322E+00, 8.9368466446E-01],
	[2.4330000000E+04, 1.6045089762E+01, 4.6530367992E+00, 4.8833854042E+00, 2.0746296336E+00, 8.9374384301E-01],
	[2.4335000000E+04, 1.6050343731E+01, 4.6529831017E+00, 4.8866661139E+00, 2.0752987026E+00, 8.9380298893E-01],
	[2.4340000000E+04, 1.6055598340E+01, 4.6529294159E+00, 4.8899483527E+00, 2.0759676392E+00, 8.9386210223E-01],
	[2.4345000000E+04, 1.6060853589E+01, 4.6528757418E+00, 4.8932321212E+00, 2.0766364432E+00, 8.9392118293E-01],
	[2.4350000000E+04, 1.6066109479E+01, 4.6528220793E+00, 4.8965174197E+00, 2.0773051147E+00, 8.9398023104E-01],
	[2.4355000000E+04, 1.6071366009E+01, 4.6527684284E+00, 4.8998042487E+00, 2.0779736534E+00, 8.9403924658E-01],
	[2.4360000000E+04, 1.6076623179E+01, 4.6527147892E+00, 4.9030926085E+00, 2.0786420594E+00, 8.9409822956E-01],
	[2.4365000000E+04, 1.6081880989E+01, 4.6526611616E+00, 4.9063824995E+00, 2.0793103325E+00, 8.9415718000E-01],
	[2.4370000000E+04, 1.6087139440E+01, 4.6526075456E+00, 4.9096739222E+00, 2.0799784727E+00, 8.9421609791E-01],
	[2.4375000000E+04, 1.6092398531E+01, 4.6525539412E+00, 4.9129668768E+00, 2.0806464799E+00, 8.9427498332E-01],
	[2.4380000000E+04, 1.6097658262E+01, 4.6525003484E+00, 4.9162613639E+00, 2.0813143540E+00, 8.9433383623E-01],
	[2.4385000000E+04, 1.6102918633E+01, 4.6524467673E+00, 4.9195573839E+00, 2.0819820950E+00, 8.9439265665E-01],
	[2.4390000000E+04, 1.6108179643E+01, 4.6523931977E+00, 4.9228549370E+00, 2.0826497027E+00, 8.9445144462E-01],
	[2.4395000000E+04, 1.6113441294E+01, 4.6523396398E+00, 4.9261540238E+00, 2.0833171771E+00, 8.9451020013E-01],
	[2.4400000000E+04, 1.6118703585E+01, 4.6522860934E+00, 4.9294546446E+00, 2.0839845182E+00, 8.9456892321E-01],
	[2.4405000000E+04, 1.6123966515E+01, 4.6522325586E+00, 4.9327567999E+00, 2.0846517258E+00, 8.9462761387E-01],
	[2.4410000000E+04, 1.6129230085E+01, 4.6521790354E+00, 4.9360604899E+00, 2.0853187999E+00, 8.9468627213E-01],
	[2.4415000000E+04, 1.6134494295E+01, 4.6521255238E+00, 4.9393657152E+00, 2.0859857403E+00, 8.9474489799E-01],
	[2.4420000000E+04, 1.6139759144E+01, 4.6520720238E+00, 4.9426724760E+00, 2.0866525471E+00, 8.9480349149E-01],
	[2.4425000000E+04, 1.6145024633E+01, 4.6520185353E+00, 4.9459807729E+00, 2.0873192201E+00, 8.9486205262E-01],
	[2.4430000000E+04, 1.6150290762E+01, 4.6519650584E+00, 4.9492906062E+00, 2.0879857592E+00, 8.9492058142E-01],
	[2.4435000000E+04, 1.6155557530E+01, 4.6519115931E+00, 4.9526019764E+00, 2.0886521645E+00, 8.9497907789E-01],
	[2.4440000000E+04, 1.6160824937E+01, 4.6518581393E+00, 4.9559148837E+00, 2.0893184358E+00, 8.9503754204E-01],
	[2.4445000000E+04, 1.6166092984E+01, 4.6518046970E+00, 4.9592293286E+00, 2.0899845730E+00, 8.9509597390E-01],
	[2.4450000000E+04, 1.6171361670E+01, 4.6517512663E+00, 4.9625453116E+00, 2.0906505760E+00, 8.9515437348E-01],
	[2.4455000000E+04, 1.6176630995E+01, 4.6516978472E+00, 4.9658628330E+00, 2.0913164449E+00, 8.9521274079E-01],
	[2.4460000000E+04, 1.6181900960E+01, 4.6516444395E+00, 4.9691818931E+00, 2.0919821795E+00, 8.9527107585E-01],
	[2.4465000000E+04, 1.6187171564E+01, 4.6515910434E+00, 4.9725024925E+00, 2.0926477797E+00, 8.9532937867E-01],
	[2.4470000000E+04, 1.6192442806E+01, 4.6515376588E+00, 4.9758246315E+00, 2.0933132454E+00, 8.9538764928E-01],
	[2.4475000000E+04, 1.6197714688E+01, 4.6514842858E+00, 4.9791483104E+00, 2.0939785767E+00, 8.9544588768E-01],
	[2.4480000000E+04, 1.6202987209E+01, 4.6514309242E+00, 4.9824735298E+00, 2.0946437734E+00, 8.9550409389E-01],
	[2.4485000000E+04, 1.6208260369E+01, 4.6513775742E+00, 4.9858002900E+00, 2.0953088354E+00, 8.9556226793E-01],
	[2.4490000000E+04, 1.6213534167E+01, 4.6513242357E+00, 4.9891285914E+00, 2.0959737626E+00, 8.9562040981E-01],
	[2.4495000000E+04, 1.6218808605E+01, 4.6512709086E+00, 4.9924584344E+00, 2.0966385551E+00, 8.9567851955E-01],
	[2.4500000000E+04, 1.6224083681E+01, 4.6512175931E+00, 4.9957898194E+00, 2.0973032127E+00, 8.9573659716E-01],
	[2.4505000000E+04, 1.6229359396E+01, 4.6511642891E+00, 4.9991227468E+00, 2.0979677353E+00, 8.9579464266E-01],
	[2.4510000000E+04, 1.6234635750E+01, 4.6511109965E+00, 5.0024572169E+00, 2.0986321230E+00, 8.9585265606E-01],
	[2.4515000000E+04, 1.6239912742E+01, 4.6510577154E+00, 5.0057932303E+00, 2.0992963755E+00, 8.9591063738E-01],
	[2.4520000000E+04, 1.6245190373E+01, 4.6510044458E+00, 5.0091307873E+00, 2.0999604928E+00, 8.9596858663E-01],
	[2.4525000000E+04, 1.6250468642E+01, 4.6509511877E+00, 5.0124698883E+00, 2.1006244749E+00, 8.9602650384E-01],
	[2.4530000000E+04, 1.6255747550E+01, 4.6508979411E+00, 5.0158105336E+00, 2.1012883217E+00, 8.9608438901E-01],
	[2.4535000000E+04, 1.6261027096E+01, 4.6508447059E+00, 5.0191527238E+00, 2.1019520330E+00, 8.9614224215E-01],
	[2.4540000000E+04, 1.6266307281E+01, 4.6507914821E+00, 5.0224964591E+00, 2.1026156089E+00, 8.9620006330E-01],
	[2.4545000000E+04, 1.6271588104E+01, 4.6507382698E+00, 5.0258417400E+00, 2.1032790493E+00, 8.9625785246E-01],
	[2.4550000000E+04, 1.6276869565E+01, 4.6506850690E+00, 5.0291885670E+00, 2.1039423541E+00, 8.9631560964E-01],
	[2.4555000000E+04, 1.6282151664E+01, 4.6506318796E+00, 5.0325369403E+00, 2.1046055231E+00, 8.9637333487E-01],
	[2.4560000000E+04, 1.6287434402E+01, 4.6505787016E+00, 5.0358868604E+00, 2.1052685565E+00, 8.9643102815E-01],
	[2.4565000000E+04, 1.6292717777E+01, 4.6505255351E+00, 5.0392383277E+00, 2.1059314539E+00, 8.9648868951E-01],
	[2.4570000000E+04, 1.6298001791E+01, 4.6504723800E+00, 5.0425913426E+00, 2.1065942155E+00, 8.9654631895E-01],
	[2.4575000000E+04, 1.6303286443E+01, 4.6504192363E+00, 5.0459459055E+00, 2.1072568412E+00, 8.9660391650E-01],
	[2.4580000000E+04, 1.6308571732E+01, 4.6503661040E+00, 5.0493020167E+00, 2.1079193307E+00, 8.9666148217E-01],
	[2.4585000000E+04, 1.6313857660E+01, 4.6503129832E+00, 5.0526596768E+00, 2.1085816842E+00, 8.9671901598E-01],
	[2.4590000000E+04, 1.6319144225E+01, 4.6502598737E+00, 5.0560188860E+00, 2.1092439015E+00, 8.9677651793E-01],
	[2.4595000000E+04, 1.6324431428E+01, 4.6502067757E+00, 5.0593796448E+00, 2.1099059825E+00, 8.9683398806E-01],
	[2.4600000000E+04, 1.6329719269E+01, 4.6501536891E+00, 5.0627419536E+00, 2.1105679272E+00, 8.9689142636E-01],
	[2.4605000000E+04, 1.6335007747E+01, 4.6501006138E+00, 5.0661058128E+00, 2.1112297354E+00, 8.9694883286E-01],
	[2.4610000000E+04, 1.6340296863E+01, 4.6500475500E+00, 5.0694712228E+00, 2.1118914073E+00, 8.9700620757E-01],
	[2.4615000000E+04, 1.6345586617E+01, 4.6499944975E+00, 5.0728381840E+00, 2.1125529425E+00, 8.9706355051E-01],
	[2.4620000000E+04, 1.6350877008E+01, 4.6499414564E+00, 5.0762066967E+00, 2.1132143412E+00, 8.9712086170E-01],
	[2.4625000000E+04, 1.6356168036E+01, 4.6498884267E+00, 5.0795767614E+00, 2.1138756032E+00, 8.9717814114E-01],
	[2.4630000000E+04, 1.6361459702E+01, 4.6498354084E+00, 5.0829483785E+00, 2.1145367284E+00, 8.9723538886E-01],
	[2.4635000000E+04, 1.6366752006E+01, 4.6497824014E+00, 5.0863215484E+00, 2.1151977168E+00, 8.9729260487E-01],
	[2.4640000000E+04, 1.6372044946E+01, 4.6497294058E+00, 5.0896962715E+00, 2.1158585683E+00, 8.9734978919E-01],
	[2.4645000000E+04, 1.6377338524E+01, 4.6496764216E+00, 5.0930725481E+00, 2.1165192828E+00, 8.9740694182E-01],
	[2.4650000000E+04, 1.6382632739E+01, 4.6496234487E+00, 5.0964503788E+00, 2.1171798603E+00, 8.9746406280E-01],
	[2.4655000000E+04, 1.6387927591E+01, 4.6495704871E+00, 5.0998297638E+00, 2.1178403007E+00, 8.9752115212E-01],
	[2.4660000000E+04, 1.6393223081E+01, 4.6495175369E+00, 5.1032107036E+00, 2.1185006040E+00, 8.9757820982E-01],
	[2.4665000000E+04, 1.6398519207E+01, 4.6494645980E+00, 5.1065931986E+00, 2.1191607700E+00, 8.9763523590E-01],
	[2.4670000000E+04, 1.6403815970E+01, 4.6494116705E+00, 5.1099772491E+00, 2.1198207986E+00, 8.9769223037E-01],
	[2.4675000000E+04, 1.6409113371E+01, 4.6493587543E+00, 5.1133628557E+00, 2.1204806899E+00, 8.9774919327E-01],
	[2.4680000000E+04, 1.6414411408E+01, 4.6493058494E+00, 5.1167500186E+00, 2.1211404437E+00, 8.9780612459E-01],
	[2.4685000000E+04, 1.6419710082E+01, 4.6492529558E+00, 5.1201387383E+00, 2.1218000601E+00, 8.9786302436E-01],
	[2.4690000000E+04, 1.6425009393E+01, 4.6492000736E+00, 5.1235290152E+00, 2.1224595388E+00, 8.9791989259E-01],
	[2.4695000000E+04, 1.6430324377E+01, 4.6491496418E+00, 5.1269208496E+00, 2.1231196396E+00, 8.9797672929E-01],
	[2.4700000000E+04, 1.6435648405E+01, 4.6491005830E+00, 5.1303142421E+00, 2.1237800279E+00, 8.9803353449E-01],
	[2.4705000000E+04, 1.6440973081E+01, 4.6490515347E+00, 5.1337091929E+00, 2.1244402794E+00, 8.9809030820E-01],
	[2.4710000000E+04, 1.6446298403E+01, 4.6490024968E+00, 5.1371057025E+00, 2.1251003940E+00, 8.9814705043E-01],
	[2.4715000000E+04, 1.6451624372E+01, 4.6489534694E+00, 5.1405037712E+00, 2.1257603716E+00, 8.9820376120E-01],
	[2.4720000000E+04, 1.6456950989E+01, 4.6489044524E+00, 5.1439033996E+00, 2.1264202123E+00, 8.9826044053E-01],
	[2.4725000000E+04, 1.6462278251E+01, 4.6488554458E+00, 5.1473045879E+00, 2.1270799159E+00, 8.9831708842E-01],
	[2.4730000000E+04, 1.6467606161E+01, 4.6488064496E+00, 5.1507073367E+00, 2.1277394823E+00, 8.9837370491E-01],
	[2.4735000000E+04, 1.6472934718E+01, 4.6487574639E+00, 5.1541116462E+00, 2.1283989116E+00, 8.9843028999E-01],
	[2.4740000000E+04, 1.6478263921E+01, 4.6487084886E+00, 5.1575175168E+00, 2.1290582035E+00, 8.9848684369E-01],
	[2.4745000000E+04, 1.6483593770E+01, 4.6486595237E+00, 5.1609249491E+00, 2.1297173582E+00, 8.9854336603E-01],
	[2.4750000000E+04, 1.6488924267E+01, 4.6486105692E+00, 5.1643339433E+00, 2.1303763754E+00, 8.9859985701E-01],
	[2.4755000000E+04, 1.6494255409E+01, 4.6485616251E+00, 5.1677445000E+00, 2.1310352551E+00, 8.9865631666E-01],
	[2.4760000000E+04, 1.6499587199E+01, 4.6485126914E+00, 5.1711566194E+00, 2.1316939972E+00, 8.9871274499E-01],
	[2.4765000000E+04, 1.6504919634E+01, 4.6484637681E+00, 5.1745703020E+00, 2.1323526018E+00, 8.9876914201E-01],
	[2.4770000000E+04, 1.6510252716E+01, 4.6484148552E+00, 5.1779855481E+00, 2.1330110686E+00, 8.9882550775E-01],
	[2.4775000000E+04, 1.6515586445E+01, 4.6483659527E+00, 5.1814023583E+00, 2.1336693977E+00, 8.9888184221E-01],
	[2.4780000000E+04, 1.6520920819E+01, 4.6483170606E+00, 5.1848207328E+00, 2.1343275890E+00, 8.9893814542E-01],
	[2.4785000000E+04, 1.6526255840E+01, 4.6482681788E+00, 5.1882406721E+00, 2.1349856424E+00, 8.9899441738E-01],
	[2.4790000000E+04, 1.6531591507E+01, 4.6482193075E+00, 5.1916621766E+00, 2.1356435579E+00, 8.9905065812E-01],
	[2.4795000000E+04, 1.6536927820E+01, 4.6481704465E+00, 5.1950852467E+00, 2.1363013353E+00, 8.9910686764E-01],
	[2.4800000000E+04, 1.6542264779E+01, 4.6481215958E+00, 5.1985098827E+00, 2.1369589747E+00, 8.9916304598E-01],
	[2.4805000000E+04, 1.6547602384E+01, 4.6480727555E+00, 5.2019360852E+00, 2.1376164759E+00, 8.9921919313E-01],
	[2.4810000000E+04, 1.6552940634E+01, 4.6480239256E+00, 5.2053638544E+00, 2.1382738388E+00, 8.9927530912E-01],
	[2.4815000000E+04, 1.6558279531E+01, 4.6479751060E+00, 5.2087931908E+00, 2.1389310635E+00, 8.9933139396E-01],
	[2.4820000000E+04, 1.6563619074E+01, 4.6479262968E+00, 5.2122240948E+00, 2.1395881498E+00, 8.9938744767E-01],
	[2.4825000000E+04, 1.6568959262E+01, 4.6478774979E+00, 5.2156565668E+00, 2.1402450978E+00, 8.9944347026E-01],
	[2.4830000000E+04, 1.6574300096E+01, 4.6478287094E+00, 5.2190906072E+00, 2.1409019072E+00, 8.9949946175E-01],
	[2.4835000000E+04, 1.6579641576E+01, 4.6477799312E+00, 5.2225262163E+00, 2.1415585781E+00, 8.9955542216E-01],
	[2.4840000000E+04, 1.6584983701E+01, 4.6477311633E+00, 5.2259633947E+00, 2.1422151103E+00, 8.9961135150E-01],
	[2.4845000000E+04, 1.6590326472E+01, 4.6476824058E+00, 5.2294021426E+00, 2.1428715039E+00, 8.9966724978E-01],
	[2.4850000000E+04, 1.6595669889E+01, 4.6476336585E+00, 5.2328424605E+00, 2.1435277588E+00, 8.9972311703E-01],
	[2.4855000000E+04, 1.6601013951E+01, 4.6475849216E+00, 5.2362843489E+00, 2.1441838748E+00, 8.9977895325E-01],
	[2.4860000000E+04, 1.6606358658E+01, 4.6475361950E+00, 5.2397278080E+00, 2.1448398520E+00, 8.9983475847E-01],
	[2.4865000000E+04, 1.6611704011E+01, 4.6474874788E+00, 5.2431728383E+00, 2.1454956902E+00, 8.9989053270E-01],
	[2.4870000000E+04, 1.6617050009E+01, 4.6474387728E+00, 5.2466194401E+00, 2.1461513894E+00, 8.9994627595E-01],
	[2.4875000000E+04, 1.6622396652E+01, 4.6473900771E+00, 5.2500676140E+00, 2.1468069495E+00, 9.0000198824E-01],
	[2.4880000000E+04, 1.6627743940E+01, 4.6473413917E+00, 5.2535173603E+00, 2.1474623705E+00, 9.0005766959E-01],
	[2.4885000000E+04, 1.6633091874E+01, 4.6472927166E+00, 5.2569686793E+00, 2.1481176523E+00, 9.0011332001E-01],
	[2.4890000000E+04, 1.6638440453E+01, 4.6472440518E+00, 5.2604215716E+00, 2.1487727948E+00, 9.0016893951E-01],
	[2.4895000000E+04, 1.6643789677E+01, 4.6471953973E+00, 5.2638760374E+00, 2.1494277981E+00, 9.0022452812E-01],
	[2.4900000000E+04, 1.6649139545E+01, 4.6471467531E+00, 5.2673320773E+00, 2.1500826619E+00, 9.0028008585E-01],
	[2.4905000000E+04, 1.6654490059E+01, 4.6470981191E+00, 5.2707896915E+00, 2.1507373862E+00, 9.0033561272E-01],
	[2.4910000000E+04, 1.6659841218E+01, 4.6470494955E+00, 5.2742488806E+00, 2.1513919711E+00, 9.0039110873E-01],
	[2.4915000000E+04, 1.6665193021E+01, 4.6470008820E+00, 5.2777096448E+00, 2.1520464163E+00, 9.0044657392E-01],
	[2.4920000000E+04, 1.6670545469E+01, 4.6469522789E+00, 5.2811719846E+00, 2.1527007219E+00, 9.0050200828E-01],
	[2.4925000000E+04, 1.6675898562E+01, 4.6469036860E+00, 5.2846359005E+00, 2.1533548878E+00, 9.0055741184E-01],
	[2.4930000000E+04, 1.6681252300E+01, 4.6468551034E+00, 5.2881013927E+00, 2.1540089139E+00, 9.0061278461E-01],
	[2.4935000000E+04, 1.6686606682E+01, 4.6468065310E+00, 5.2915684617E+00, 2.1546628002E+00, 9.0066812662E-01],
	[2.4940000000E+04, 1.6691961709E+01, 4.6467579688E+00, 5.2950371080E+00, 2.1553165465E+00, 9.0072343787E-01],
	[2.4945000000E+04, 1.6697317381E+01, 4.6467094169E+00, 5.2985073318E+00, 2.1559701529E+00, 9.0077871837E-01],
	[2.4950000000E+04, 1.6702673696E+01, 4.6466608753E+00, 5.3019791337E+00, 2.1566236193E+00, 9.0083396816E-01],
	[2.4955000000E+04, 1.6708030657E+01, 4.6466123438E+00, 5.3054525139E+00, 2.1572769456E+00, 9.0088918724E-01],
	[2.4960000000E+04, 1.6713388261E+01, 4.6465638226E+00, 5.3089274730E+00, 2.1579301317E+00, 9.0094437562E-01],
	[2.4965000000E+04, 1.6718746510E+01, 4.6465153117E+00, 5.3124040113E+00, 2.1585831776E+00, 9.0099953333E-01],
	[2.4970000000E+04, 1.6724105404E+01, 4.6464668109E+00, 5.3158821292E+00, 2.1592360833E+00, 9.0105466038E-01],
	[2.4975000000E+04, 1.6729464941E+01, 4.6464183204E+00, 5.3193618271E+00, 2.1598888485E+00, 9.0110975678E-01],
	[2.4980000000E+04, 1.6734825123E+01, 4.6463698401E+00, 5.3228431054E+00, 2.1605414734E+00, 9.0116482256E-01],
	[2.4985000000E+04, 1.6740185949E+01, 4.6463213699E+00, 5.3263259645E+00, 2.1611939578E+00, 9.0121985772E-01],
	[2.4990000000E+04, 1.6745547419E+01, 4.6462729100E+00, 5.3298104048E+00, 2.1618463017E+00, 9.0127486228E-01],
	[2.4995000000E+04, 1.6750909532E+01, 4.6462244603E+00, 5.3332964267E+00, 2.1624985050E+00, 9.0132983626E-01],
	[2.5000000000E+04, 1.6756272290E+01, 4.6461760208E+00, 5.3367840307E+00, 2.1631505677E+00, 9.0138477968E-01],
	[2.5005000000E+04, 1.6761635692E+01, 4.6461275915E+00, 5.3402822167E+00, 2.1638039671E+00, 9.0143969254E-01],
	[2.5010000000E+04, 1.6766999738E+01, 4.6460791723E+00, 5.3437819954E+00, 2.1644572253E+00, 9.0149457487E-01],
	[2.5015000000E+04, 1.6772364427E+01, 4.6460307634E+00, 5.3472833672E+00, 2.1651103422E+00, 9.0154942669E-01],
	[2.5020000000E+04, 1.6777729760E+01, 4.6459823646E+00, 5.3507863327E+00, 2.1657633178E+00, 9.0160424799E-01],
	[2.5025000000E+04, 1.6783095737E+01, 4.6459339760E+00, 5.3542908920E+00, 2.1664161519E+00, 9.0165903882E-01],
	[2.5030000000E+04, 1.6788462358E+01, 4.6458855976E+00, 5.3577970458E+00, 2.1670688446E+00, 9.0171379917E-01],
	[2.5035000000E+04, 1.6793829622E+01, 4.6458372293E+00, 5.3613047943E+00, 2.1677213957E+00, 9.0176852906E-01],
	[2.5040000000E+04, 1.6799197530E+01, 4.6457888712E+00, 5.3648141379E+00, 2.1683738052E+00, 9.0182322851E-01],
	[2.5045000000E+04, 1.6804566081E+01, 4.6457405233E+00, 5.3683250772E+00, 2.1690260731E+00, 9.0187789755E-01],
	[2.5050000000E+04, 1.6809935276E+01, 4.6456921855E+00, 5.3718376125E+00, 2.1696781992E+00, 9.0193253617E-01],
	[2.5055000000E+04, 1.6815305114E+01, 4.6456438579E+00, 5.3753517441E+00, 2.1703301836E+00, 9.0198714440E-01],
	[2.5060000000E+04, 1.6820675595E+01, 4.6455955404E+00, 5.3788674726E+00, 2.1709820260E+00, 9.0204172225E-01],
	[2.5065000000E+04, 1.6826046720E+01, 4.6455472331E+00, 5.3823847983E+00, 2.1716337266E+00, 9.0209626974E-01],
	[2.5070000000E+04, 1.6831418488E+01, 4.6454989359E+00, 5.3859037216E+00, 2.1722852852E+00, 9.0215078689E-01],
	[2.5075000000E+04, 1.6836790899E+01, 4.6454506488E+00, 5.3894242429E+00, 2.1729367018E+00, 9.0220527371E-01],
	[2.5080000000E+04, 1.6842163953E+01, 4.6454023718E+00, 5.3929463627E+00, 2.1735879763E+00, 9.0225973021E-01],
	[2.5085000000E+04, 1.6847537651E+01, 4.6453541050E+00, 5.3964700813E+00, 2.1742391087E+00, 9.0231415641E-01],
	[2.5090000000E+04, 1.6852915281E+01, 4.6453063733E+00, 5.3999953991E+00, 2.1748902687E+00, 9.0236855234E-01],
	[2.5095000000E+04, 1.6858313639E+01, 4.6452618553E+00, 5.4035223166E+00, 2.1755423237E+00, 9.0242291800E-01],
	[2.5100000000E+04, 1.6863712651E+01, 4.6452173465E+00, 5.4070508341E+00, 2.1761942373E+00, 9.0247725340E-01],
	[2.5105000000E+04, 1.6869112316E+01, 4.6451728471E+00, 5.4105809521E+00, 2.1768460096E+00, 9.0253155857E-01],
	[2.5110000000E+04, 1.6874512634E+01, 4.6451283569E+00, 5.4141126710E+00, 2.1774976404E+00, 9.0258583353E-01],
	[2.5115000000E+04, 1.6879913605E+01, 4.6450838761E+00, 5.4176459912E+00, 2.1781491296E+00, 9.0264007828E-01],
	[2.5120000000E+04, 1.6885315230E+01, 4.6450394045E+00, 5.4211809131E+00, 2.1788004772E+00, 9.0269429284E-01],
	[2.5125000000E+04, 1.6890717507E+01, 4.6449949422E+00, 5.4247174370E+00, 2.1794516832E+00, 9.0274847723E-01],
	[2.5130000000E+04, 1.6896120437E+01, 4.6449504891E+00, 5.4282555635E+00, 2.1801027474E+00, 9.0280263147E-01],
	[2.5135000000E+04, 1.6901524020E+01, 4.6449060453E+00, 5.4317952928E+00, 2.1807536699E+00, 9.0285675557E-01],
	[2.5140000000E+04, 1.6906928255E+01, 4.6448616108E+00, 5.4353366255E+00, 2.1814044505E+00, 9.0291084954E-01],
	[2.5145000000E+04, 1.6912333144E+01, 4.6448171856E+00, 5.4388795619E+00, 2.1820550893E+00, 9.0296491340E-01],
	[2.5150000000E+04, 1.6917738685E+01, 4.6447727696E+00, 5.4424241024E+00, 2.1827055860E+00, 9.0301894717E-01],
	[2.5155000000E+04, 1.6923144879E+01, 4.6447283629E+00, 5.4459702475E+00, 2.1833559408E+00, 9.0307295087E-01],
	[2.5160000000E+04, 1.6928551725E+01, 4.6446839654E+00, 5.4495179975E+00, 2.1840061535E+00, 9.0312692450E-01],
	[2.5165000000E+04, 1.6933959224E+01, 4.6446395771E+00, 5.4530673528E+00, 2.1846562240E+00, 9.0318086809E-01],
	[2.5170000000E+04, 1.6939367376E+01, 4.6445951982E+00, 5.4566183139E+00, 2.1853061524E+00, 9.0323478165E-01],
	[2.5175000000E+04, 1.6944776180E+01, 4.6445508284E+00, 5.4601708812E+00, 2.1859559385E+00, 9.0328866520E-01],
	[2.5180000000E+04, 1.6950185636E+01, 4.6445064679E+00, 5.4637250550E+00, 2.1866055823E+00, 9.0334251875E-01],
	[2.5185000000E+04, 1.6955595745E+01, 4.6444621166E+00, 5.4672808359E+00, 2.1872550837E+00, 9.0339634231E-01],
	[2.5190000000E+04, 1.6961006506E+01, 4.6444177745E+00, 5.4708382241E+00, 2.1879044428E+00, 9.0345013592E-01],
	[2.5195000000E+04, 1.6966417919E+01, 4.6443734417E+00, 5.4743972201E+00, 2.1885536593E+00, 9.0350389957E-01],
	[2.5200000000E+04, 1.6971829984E+01, 4.6443291181E+00, 5.4779578243E+00, 2.1892027333E+00, 9.0355763328E-01],
	[2.5205000000E+04, 1.6977242702E+01, 4.6442848037E+00, 5.4815200371E+00, 2.1898516646E+00, 9.0361133708E-01],
	[2.5210000000E+04, 1.6982656072E+01, 4.6442404985E+00, 5.4850838589E+00, 2.1905004534E+00, 9.0366501098E-01],
	[2.5215000000E+04, 1.6988070093E+01, 4.6441962025E+00, 5.4886492901E+00, 2.1911490994E+00, 9.0371865499E-01],
	[2.5220000000E+04, 1.6993484767E+01, 4.6441519157E+00, 5.4922163312E+00, 2.1917976026E+00, 9.0377226912E-01],
	[2.5225000000E+04, 1.6998900093E+01, 4.6441076382E+00, 5.4957849825E+00, 2.1924459630E+00, 9.0382585341E-01],
	[2.5230000000E+04, 1.7004316070E+01, 4.6440633698E+00, 5.4993552445E+00, 2.1930941805E+00, 9.0387940785E-01],
	[2.5235000000E+04, 1.7009732700E+01, 4.6440191106E+00, 5.5029271175E+00, 2.1937422551E+00, 9.0393293247E-01],
	[2.5240000000E+04, 1.7015149981E+01, 4.6439748606E+00, 5.5065006020E+00, 2.1943901867E+00, 9.0398642728E-01],
	[2.5245000000E+04, 1.7020567914E+01, 4.6439306198E+00, 5.5100756983E+00, 2.1950379752E+00, 9.0403989230E-01],
	[2.5250000000E+04, 1.7025986499E+01, 4.6438863882E+00, 5.5136524069E+00, 2.1956856206E+00, 9.0409332755E-01],
	[2.5255000000E+04, 1.7031405735E+01, 4.6438421657E+00, 5.5172307282E+00, 2.1963331228E+00, 9.0414673303E-01],
	[2.5260000000E+04, 1.7036825623E+01, 4.6437979525E+00, 5.5208106626E+00, 2.1969804818E+00, 9.0420010877E-01],
	[2.5265000000E+04, 1.7042246162E+01, 4.6437537484E+00, 5.5243922105E+00, 2.1976276975E+00, 9.0425345478E-01],
	[2.5270000000E+04, 1.7047667353E+01, 4.6437095535E+00, 5.5279753722E+00, 2.1982747698E+00, 9.0430677108E-01],
	[2.5275000000E+04, 1.7053089196E+01, 4.6436653677E+00, 5.5315601483E+00, 2.1989216988E+00, 9.0436005768E-01],
	[2.5280000000E+04, 1.7058511689E+01, 4.6436211911E+00, 5.5351465391E+00, 2.1995684843E+00, 9.0441331460E-01],
	[2.5285000000E+04, 1.7063934834E+01, 4.6435770236E+00, 5.5387345451E+00, 2.2002151263E+00, 9.0446654185E-01],
	[2.5290000000E+04, 1.7069358631E+01, 4.6435328653E+00, 5.5423241666E+00, 2.2008616247E+00, 9.0451973946E-01],
	[2.5295000000E+04, 1.7074783078E+01, 4.6434887162E+00, 5.5459154040E+00, 2.2015079795E+00, 9.0457290743E-01],
	[2.5300000000E+04, 1.7080208177E+01, 4.6434445762E+00, 5.5495082577E+00, 2.2021541907E+00, 9.0462604578E-01],
	[2.5305000000E+04, 1.7085633927E+01, 4.6434004454E+00, 5.5531027283E+00, 2.2028002581E+00, 9.0467915454E-01],
	[2.5310000000E+04, 1.7091060328E+01, 4.6433563236E+00, 5.5566988160E+00, 2.2034461817E+00, 9.0473223370E-01],
	[2.5315000000E+04, 1.7096487380E+01, 4.6433122110E+00, 5.5602965212E+00, 2.2040919614E+00, 9.0478528330E-01],
	[2.5320000000E+04, 1.7101915083E+01, 4.6432681076E+00, 5.5638958445E+00, 2.2047375973E+00, 9.0483830334E-01],
	[2.5325000000E+04, 1.7107343437E+01, 4.6432240133E+00, 5.5674967861E+00, 2.2053830892E+00, 9.0489129384E-01],
	[2.5330000000E+04, 1.7112772442E+01, 4.6431799281E+00, 5.5710993466E+00, 2.2060284371E+00, 9.0494425482E-01],
	[2.5335000000E+04, 1.7118202098E+01, 4.6431358520E+00, 5.5747035262E+00, 2.2066736409E+00, 9.0499718629E-01],
	[2.5340000000E+04, 1.7123632404E+01, 4.6430917850E+00, 5.5783093254E+00, 2.2073187006E+00, 9.0505008827E-01],
	[2.5345000000E+04, 1.7129063361E+01, 4.6430477272E+00, 5.5819167447E+00, 2.2079636161E+00, 9.0510296077E-01],
	[2.5350000000E+04, 1.7134494969E+01, 4.6430036784E+00, 5.5855257844E+00, 2.2086083874E+00, 9.0515580382E-01],
	[2.5355000000E+04, 1.7139927228E+01, 4.6429596388E+00, 5.5891364450E+00, 2.2092530144E+00, 9.0520861742E-01],
	[2.5360000000E+04, 1.7145360137E+01, 4.6429156082E+00, 5.5927487267E+00, 2.2098974971E+00, 9.0526140158E-01],
	[2.5365000000E+04, 1.7150793696E+01, 4.6428715868E+00, 5.5963626302E+00, 2.2105418354E+00, 9.0531415633E-01],
	[2.5370000000E+04, 1.7156227906E+01, 4.6428275745E+00, 5.5999781557E+00, 2.2111860292E+00, 9.0536688167E-01],
	[2.5375000000E+04, 1.7161662767E+01, 4.6427835712E+00, 5.6035953036E+00, 2.2118300785E+00, 9.0541957761E-01],
	[2.5380000000E+04, 1.7167098278E+01, 4.6427395770E+00, 5.6072140745E+00, 2.2124739833E+00, 9.0547224417E-01],
	[2.5385000000E+04, 1.7172534439E+01, 4.6426955919E+00, 5.6108344686E+00, 2.2131177435E+00, 9.0552488137E-01],
	[2.5390000000E+04, 1.7177971250E+01, 4.6426516159E+00, 5.6144564864E+00, 2.2137613590E+00, 9.0557748921E-01],
	[2.5395000000E+04, 1.7183408712E+01, 4.6426076490E+00, 5.6180801283E+00, 2.2144048298E+00, 9.0563006772E-01],
	[2.5400000000E+04, 1.7188846824E+01, 4.6425636911E+00, 5.6217053948E+00, 2.2150481558E+00, 9.0568261689E-01],
	[2.5405000000E+04, 1.7194285586E+01, 4.6425197423E+00, 5.6253322861E+00, 2.2156913370E+00, 9.0573513676E-01],
	[2.5410000000E+04, 1.7199724998E+01, 4.6424758026E+00, 5.6289608028E+00, 2.2163343733E+00, 9.0578762732E-01],
	[2.5415000000E+04, 1.7205165060E+01, 4.6424318720E+00, 5.6325909452E+00, 2.2169772647E+00, 9.0584008859E-01],
	[2.5420000000E+04, 1.7210605772E+01, 4.6423879503E+00, 5.6362227137E+00, 2.2176200111E+00, 9.0589252059E-01],
	[2.5425000000E+04, 1.7216047134E+01, 4.6423440378E+00, 5.6398561088E+00, 2.2182626125E+00, 9.0594492334E-01],
	[2.5430000000E+04, 1.7221489146E+01, 4.6423001343E+00, 5.6434911309E+00, 2.2189050687E+00, 9.0599729683E-01],
	[2.5435000000E+04, 1.7226931808E+01, 4.6422562398E+00, 5.6471277803E+00, 2.2195473799E+00, 9.0604964110E-01],
	[2.5440000000E+04, 1.7232375119E+01, 4.6422123544E+00, 5.6507660575E+00, 2.2201895458E+00, 9.0610195614E-01],
	[2.5445000000E+04, 1.7237819081E+01, 4.6421684780E+00, 5.6544059629E+00, 2.2208315665E+00, 9.0615424198E-01],
	[2.5450000000E+04, 1.7243263692E+01, 4.6421246107E+00, 5.6580474969E+00, 2.2214734419E+00, 9.0620649862E-01],
	[2.5455000000E+04, 1.7248708952E+01, 4.6420807524E+00, 5.6616906599E+00, 2.2221151720E+00, 9.0625872609E-01],
	[2.5460000000E+04, 1.7254154862E+01, 4.6420369031E+00, 5.6653354522E+00, 2.2227567566E+00, 9.0631092439E-01],
	[2.5465000000E+04, 1.7259601422E+01, 4.6419930628E+00, 5.6689818744E+00, 2.2233981958E+00, 9.0636309354E-01],
	[2.5470000000E+04, 1.7265048631E+01, 4.6419492316E+00, 5.6726299269E+00, 2.2240394895E+00, 9.0641523355E-01],
	[2.5475000000E+04, 1.7270496489E+01, 4.6419054094E+00, 5.6762796099E+00, 2.2246806376E+00, 9.0646734443E-01],
	[2.5480000000E+04, 1.7275944997E+01, 4.6418615962E+00, 5.6799309240E+00, 2.2253216402E+00, 9.0651942621E-01],
	[2.5485000000E+04, 1.7281394155E+01, 4.6418177920E+00, 5.6835838696E+00, 2.2259624970E+00, 9.0657147888E-01],
	[2.5490000000E+04, 1.7286843961E+01, 4.6417739968E+00, 5.6872384470E+00, 2.2266032082E+00, 9.0662350247E-01],
	[2.5495000000E+04, 1.7292302764E+01, 4.6417315240E+00, 5.6908946567E+00, 2.2272442144E+00, 9.0667549699E-01],
	[2.5500000000E+04, 1.7297777057E+01, 4.6416913938E+00, 5.6945524991E+00, 2.2278858590E+00, 9.0672746246E-01],
	[2.5505000000E+04, 1.7303252009E+01, 4.6416512717E+00, 5.6982119745E+00, 2.2285273586E+00, 9.0677939888E-01],
	[2.5510000000E+04, 1.7308727620E+01, 4.6416111579E+00, 5.7018730834E+00, 2.2291687132E+00, 9.0683130627E-01],
	[2.5515000000E+04, 1.7314203890E+01, 4.6415710523E+00, 5.7055358263E+00, 2.2298099229E+00, 9.0688318464E-01],
	[2.5520000000E+04, 1.7319680820E+01, 4.6415309549E+00, 5.7092002034E+00, 2.2304509874E+00, 9.0693503401E-01],
	[2.5525000000E+04, 1.7325158408E+01, 4.6414908657E+00, 5.7128662153E+00, 2.2310919068E+00, 9.0698685439E-01],
	[2.5530000000E+04, 1.7330636656E+01, 4.6414507847E+00, 5.7165338623E+00, 2.2317326810E+00, 9.0703864579E-01],
	[2.5535000000E+04, 1.7336115562E+01, 4.6414107119E+00, 5.7202031449E+00, 2.2323733100E+00, 9.0709040823E-01],
	[2.5540000000E+04, 1.7341595128E+01, 4.6413706473E+00, 5.7238740634E+00, 2.2330137938E+00, 9.0714214172E-01],
	[2.5545000000E+04, 1.7347075352E+01, 4.6413305908E+00, 5.7275466182E+00, 2.2336541321E+00, 9.0719384628E-01],
	[2.5550000000E+04, 1.7352556235E+01, 4.6412905426E+00, 5.7312208098E+00, 2.2342943251E+00, 9.0724552192E-01],
	[2.5555000000E+04, 1.7358037776E+01, 4.6412505025E+00, 5.7348966386E+00, 2.2349343727E+00, 9.0729716864E-01],
	[2.5560000000E+04, 1.7363519976E+01, 4.6412104707E+00, 5.7385741050E+00, 2.2355742748E+00, 9.0734878648E-01],
	[2.5565000000E+04, 1.7369002835E+01, 4.6411704470E+00, 5.7422532093E+00, 2.2362140313E+00, 9.0740037543E-01],
	[2.5570000000E+04, 1.7374486353E+01, 4.6411304314E+00, 5.7459339521E+00, 2.2368536423E+00, 9.0745193552E-01],
	[2.5575000000E+04, 1.7379970529E+01, 4.6410904241E+00, 5.7496163336E+00, 2.2374931076E+00, 9.0750346675E-01],
	[2.5580000000E+04, 1.7385455363E+01, 4.6410504249E+00, 5.7533003544E+00, 2.2381324273E+00, 9.0755496914E-01],
	[2.5585000000E+04, 1.7390940856E+01, 4.6410104338E+00, 5.7569860148E+00, 2.2387716012E+00, 9.0760644271E-01],
	[2.5590000000E+04, 1.7396427007E+01, 4.6409704509E+00, 5.7606733153E+00, 2.2394106293E+00, 9.0765788746E-01],
	[2.5595000000E+04, 1.7401913817E+01, 4.6409304762E+00, 5.7643622562E+00, 2.2400495116E+00, 9.0770930342E-01],
	[2.5600000000E+04, 1.7407401285E+01, 4.6408905096E+00, 5.7680528379E+00, 2.2406882481E+00, 9.0776069059E-01],
	[2.5605000000E+04, 1.7412889411E+01, 4.6408505512E+00, 5.7717450609E+00, 2.2413268385E+00, 9.0781204899E-01],
	[2.5610000000E+04, 1.7418378195E+01, 4.6408106010E+00, 5.7754389256E+00, 2.2419652831E+00, 9.0786337863E-01],
	[2.5615000000E+04, 1.7423867638E+01, 4.6407706588E+00, 5.7791344323E+00, 2.2426035815E+00, 9.0791467953E-01],
	[2.5620000000E+04, 1.7429357738E+01, 4.6407307248E+00, 5.7828315816E+00, 2.2432417339E+00, 9.0796595170E-01],
	[2.5625000000E+04, 1.7434848497E+01, 4.6406907990E+00, 5.7865303737E+00, 2.2438797402E+00, 9.0801719515E-01],
	[2.5630000000E+04, 1.7440339913E+01, 4.6406508812E+00, 5.7902308092E+00, 2.2445176003E+00, 9.0806840989E-01],
	[2.5635000000E+04, 1.7445831988E+01, 4.6406109717E+00, 5.7939328884E+00, 2.2451553142E+00, 9.0811959595E-01],
	[2.5640000000E+04, 1.7451324720E+01, 4.6405710702E+00, 5.7976366117E+00, 2.2457928818E+00, 9.0817075334E-01],
	[2.5645000000E+04, 1.7456818110E+01, 4.6405311768E+00, 5.8013419795E+00, 2.2464303031E+00, 9.0822188206E-01],
	[2.5650000000E+04, 1.7462312158E+01, 4.6404912916E+00, 5.8050489923E+00, 2.2470675780E+00, 9.0827298213E-01],
	[2.5655000000E+04, 1.7467806864E+01, 4.6404514145E+00, 5.8087576504E+00, 2.2477047065E+00, 9.0832405357E-01],
	[2.5660000000E+04, 1.7473302227E+01, 4.6404115455E+00, 5.8124679543E+00, 2.2483416885E+00, 9.0837509639E-01],
	[2.5665000000E+04, 1.7478798248E+01, 4.6403716846E+00, 5.8161799044E+00, 2.2489785240E+00, 9.0842611060E-01],
	[2.5670000000E+04, 1.7484294927E+01, 4.6403318319E+00, 5.8198935010E+00, 2.2496152130E+00, 9.0847709622E-01],
	[2.5675000000E+04, 1.7489792263E+01, 4.6402919872E+00, 5.8236087447E+00, 2.2502517553E+00, 9.0852805326E-01],
	[2.5680000000E+04, 1.7495290257E+01, 4.6402521506E+00, 5.8273256357E+00, 2.2508881510E+00, 9.0857898174E-01],
	[2.5685000000E+04, 1.7500788908E+01, 4.6402123221E+00, 5.8310441746E+00, 2.2515244000E+00, 9.0862988166E-01],
	[2.5690000000E+04, 1.7506288216E+01, 4.6401725018E+00, 5.8347643617E+00, 2.2521605022E+00, 9.0868075304E-01],
	[2.5695000000E+04, 1.7511788182E+01, 4.6401326895E+00, 5.8384861974E+00, 2.2527964577E+00, 9.0873159590E-01],
	[2.5700000000E+04, 1.7517288805E+01, 4.6400928853E+00, 5.8422096821E+00, 2.2534322663E+00, 9.0878241026E-01],
	[2.5705000000E+04, 1.7522790085E+01, 4.6400530892E+00, 5.8459348163E+00, 2.2540679279E+00, 9.0883319611E-01],
	[2.5710000000E+04, 1.7528292023E+01, 4.6400133011E+00, 5.8496616004E+00, 2.2547034427E+00, 9.0888395348E-01],
	[2.5715000000E+04, 1.7533794617E+01, 4.6399735212E+00, 5.8533900347E+00, 2.2553388105E+00, 9.0893468238E-01],
	[2.5720000000E+04, 1.7539297869E+01, 4.6399337493E+00, 5.8571201197E+00, 2.2559740312E+00, 9.0898538283E-01],
	[2.5725000000E+04, 1.7544801778E+01, 4.6398939855E+00, 5.8608518558E+00, 2.2566091049E+00, 9.0903605484E-01],
	[2.5730000000E+04, 1.7550306343E+01, 4.6398542297E+00, 5.8645852434E+00, 2.2572440314E+00, 9.0908669842E-01],
	[2.5735000000E+04, 1.7555811566E+01, 4.6398144821E+00, 5.8683202829E+00, 2.2578788108E+00, 9.0913731358E-01],
	[2.5740000000E+04, 1.7561317446E+01, 4.6397747425E+00, 5.8720569747E+00, 2.2585134429E+00, 9.0918790035E-01],
	[2.5745000000E+04, 1.7566823982E+01, 4.6397350109E+00, 5.8757953192E+00, 2.2591479278E+00, 9.0923845873E-01],
	[2.5750000000E+04, 1.7572331175E+01, 4.6396952874E+00, 5.8795353169E+00, 2.2597822653E+00, 9.0928898873E-01],
	[2.5755000000E+04, 1.7577839025E+01, 4.6396555720E+00, 5.8832769681E+00, 2.2604164555E+00, 9.0933949038E-01],
	[2.5760000000E+04, 1.7583347532E+01, 4.6396158646E+00, 5.8870202732E+00, 2.2610504983E+00, 9.0938996369E-01],
	[2.5765000000E+04, 1.7588856695E+01, 4.6395761652E+00, 5.8907652328E+00, 2.2616843937E+00, 9.0944040866E-01],
	[2.5770000000E+04, 1.7594366515E+01, 4.6395364739E+00, 5.8945118471E+00, 2.2623181416E+00, 9.0949082532E-01],
	[2.5775000000E+04, 1.7599876992E+01, 4.6394967906E+00, 5.8982601166E+00, 2.2629517419E+00, 9.0954121367E-01],
	[2.5780000000E+04, 1.7605388125E+01, 4.6394571154E+00, 5.9020100416E+00, 2.2635851946E+00, 9.0959157374E-01],
	[2.5785000000E+04, 1.7610899914E+01, 4.6394174482E+00, 5.9057616227E+00, 2.2642184997E+00, 9.0964190553E-01],
	[2.5790000000E+04, 1.7616412360E+01, 4.6393777890E+00, 5.9095148602E+00, 2.2648516571E+00, 9.0969220906E-01],
	[2.5795000000E+04, 1.7621925462E+01, 4.6393381379E+00, 5.9132697545E+00, 2.2654846668E+00, 9.0974248434E-01],
	[2.5800000000E+04, 1.7627439221E+01, 4.6392984948E+00, 5.9170263061E+00, 2.2661175288E+00, 9.0979273139E-01],
	[2.5805000000E+04, 1.7632953635E+01, 4.6392588597E+00, 5.9207845153E+00, 2.2667502429E+00, 9.0984295022E-01],
	[2.5810000000E+04, 1.7638468706E+01, 4.6392192326E+00, 5.9245443825E+00, 2.2673828091E+00, 9.0989314084E-01],
	[2.5815000000E+04, 1.7643984433E+01, 4.6391796135E+00, 5.9283059082E+00, 2.2680152275E+00, 9.0994330327E-01],
	[2.5820000000E+04, 1.7649500817E+01, 4.6391400025E+00, 5.9320690928E+00, 2.2686474979E+00, 9.0999343753E-01],
	[2.5825000000E+04, 1.7655017856E+01, 4.6391003994E+00, 5.9358339367E+00, 2.2692796204E+00, 9.1004354362E-01],
	[2.5830000000E+04, 1.7660535551E+01, 4.6390608044E+00, 5.9396004403E+00, 2.2699115948E+00, 9.1009362156E-01],
	[2.5835000000E+04, 1.7666053902E+01, 4.6390212174E+00, 5.9433686039E+00, 2.2705434211E+00, 9.1014367136E-01],
	[2.5840000000E+04, 1.7671572909E+01, 4.6389816383E+00, 5.9471384281E+00, 2.2711750993E+00, 9.1019369304E-01],
	[2.5845000000E+04, 1.7677092572E+01, 4.6389420673E+00, 5.9509099132E+00, 2.2718066293E+00, 9.1024368662E-01],
	[2.5850000000E+04, 1.7682612891E+01, 4.6389025042E+00, 5.9546830597E+00, 2.2724380111E+00, 9.1029365210E-01],
	[2.5855000000E+04, 1.7688133866E+01, 4.6388629492E+00, 5.9584578678E+00, 2.2730692447E+00, 9.1034358950E-01],
	[2.5860000000E+04, 1.7693655496E+01, 4.6388234021E+00, 5.9622343382E+00, 2.2737003299E+00, 9.1039349883E-01],
	[2.5865000000E+04, 1.7699177782E+01, 4.6387838630E+00, 5.9660124711E+00, 2.2743312669E+00, 9.1044338011E-01],
	[2.5870000000E+04, 1.7704700724E+01, 4.6387443319E+00, 5.9697922669E+00, 2.2749620554E+00, 9.1049323335E-01],
	[2.5875000000E+04, 1.7710224321E+01, 4.6387048087E+00, 5.9735737262E+00, 2.2755926955E+00, 9.1054305857E-01],
	[2.5880000000E+04, 1.7715748573E+01, 4.6386652936E+00, 5.9773568493E+00, 2.2762231871E+00, 9.1059285577E-01],
	[2.5885000000E+04, 1.7721273482E+01, 4.6386257864E+00, 5.9811416365E+00, 2.2768535302E+00, 9.1064262498E-01],
	[2.5890000000E+04, 1.7726799045E+01, 4.6385862871E+00, 5.9849280884E+00, 2.2774837248E+00, 9.1069236621E-01],
	[2.5895000000E+04, 1.7732325264E+01, 4.6385467959E+00, 5.9887162053E+00, 2.2781137708E+00, 9.1074207947E-01],
	[2.5900000000E+04, 1.7737852138E+01, 4.6385073126E+00, 5.9925059876E+00, 2.2787436681E+00, 9.1079176477E-01],
	[2.5905000000E+04, 1.7743386075E+01, 4.6384688320E+00, 5.9962974358E+00, 2.2793737627E+00, 9.1084142214E-01],
	[2.5910000000E+04, 1.7748937239E+01, 4.6384329309E+00, 6.0000905502E+00, 2.2800046035E+00, 9.1089105157E-01],
	[2.5915000000E+04, 1.7754489067E+01, 4.6383970369E+00, 6.0038853313E+00, 2.2806352965E+00, 9.1094065310E-01],
	[2.5920000000E+04, 1.7760041560E+01, 4.6383611501E+00, 6.0076817795E+00, 2.2812658416E+00, 9.1099022672E-01],
	[2.5925000000E+04, 1.7765594719E+01, 4.6383252705E+00, 6.0114798952E+00, 2.2818962388E+00, 9.1103977246E-01],
	[2.5930000000E+04, 1.7771148542E+01, 4.6382893981E+00, 6.0152796788E+00, 2.2825264879E+00, 9.1108929033E-01],
	[2.5935000000E+04, 1.7776703030E+01, 4.6382535329E+00, 6.0190811307E+00, 2.2831565890E+00, 9.1113878034E-01],
	[2.5940000000E+04, 1.7782258183E+01, 4.6382176749E+00, 6.0228842513E+00, 2.2837865421E+00, 9.1118824251E-01],
	[2.5945000000E+04, 1.7787814001E+01, 4.6381818241E+00, 6.0266890410E+00, 2.2844163470E+00, 9.1123767686E-01],
	[2.5950000000E+04, 1.7793370484E+01, 4.6381459805E+00, 6.0304955003E+00, 2.2850460038E+00, 9.1128708338E-01],
	[2.5955000000E+04, 1.7798927631E+01, 4.6381101441E+00, 6.0343036295E+00, 2.2856755123E+00, 9.1133646211E-01],
	[2.5960000000E+04, 1.7804485443E+01, 4.6380743148E+00, 6.0381134291E+00, 2.2863048726E+00, 9.1138581305E-01],
	[2.5965000000E+04, 1.7810043920E+01, 4.6380384927E+00, 6.0419248994E+00, 2.2869340847E+00, 9.1143513621E-01],
	[2.5970000000E+04, 1.7815603061E+01, 4.6380026778E+00, 6.0457380410E+00, 2.2875631483E+00, 9.1148443162E-01],
	[2.5975000000E+04, 1.7821162867E+01, 4.6379668701E+00, 6.0495528541E+00, 2.2881920637E+00, 9.1153369929E-01],
	[2.5980000000E+04, 1.7826723337E+01, 4.6379310695E+00, 6.0533693392E+00, 2.2888208306E+00, 9.1158293922E-01],
	[2.5985000000E+04, 1.7832284471E+01, 4.6378952761E+00, 6.0571874968E+00, 2.2894494490E+00, 9.1163215143E-01],
	[2.5990000000E+04, 1.7837846270E+01, 4.6378594899E+00, 6.0610073272E+00, 2.2900779190E+00, 9.1168133595E-01],
	[2.5995000000E+04, 1.7843408733E+01, 4.6378237108E+00, 6.0648288308E+00, 2.2907062404E+00, 9.1173049277E-01],
	[2.6000000000E+04, 1.7848971861E+01, 4.6377879388E+00, 6.0686520081E+00, 2.2913344133E+00, 9.1177962192E-01],
	[2.6005000000E+04, 1.7854535652E+01, 4.6377521741E+00, 6.0724768594E+00, 2.2919624375E+00, 9.1182872341E-01],
	[2.6010000000E+04, 1.7860100108E+01, 4.6377164165E+00, 6.0763033852E+00, 2.2925903131E+00, 9.1187779726E-01],
	[2.6015000000E+04, 1.7865665228E+01, 4.6376806660E+00, 6.0801315859E+00, 2.2932180400E+00, 9.1192684347E-01],
	[2.6020000000E+04, 1.7871231012E+01, 4.6376449227E+00, 6.0839614618E+00, 2.2938456181E+00, 9.1197586206E-01],
	[2.6025000000E+04, 1.7876797460E+01, 4.6376091865E+00, 6.0877930135E+00, 2.2944730474E+00, 9.1202485305E-01],
	[2.6030000000E+04, 1.7882364572E+01, 4.6375734574E+00, 6.0916262413E+00, 2.2951003280E+00, 9.1207381645E-01],
	[2.6035000000E+04, 1.7887932348E+01, 4.6375377355E+00, 6.0954611456E+00, 2.2957274596E+00, 9.1212275228E-01],
	[2.6040000000E+04, 1.7893500788E+01, 4.6375020208E+00, 6.0992977268E+00, 2.2963544424E+00, 9.1217166054E-01],
	[2.6045000000E+04, 1.7899069892E+01, 4.6374663131E+00, 6.1031359854E+00, 2.2969812762E+00, 9.1222054125E-01],
	[2.6050000000E+04, 1.7904639659E+01, 4.6374306126E+00, 6.1069759218E+00, 2.2976079610E+00, 9.1226939443E-01],
	[2.6055000000E+04, 1.7910210090E+01, 4.6373949192E+00, 6.1108175363E+00, 2.2982344968E+00, 9.1231822009E-01],
	[2.6060000000E+04, 1.7915781185E+01, 4.6373592330E+00, 6.1146608294E+00, 2.2988608836E+00, 9.1236701825E-01],
	[2.6065000000E+04, 1.7921352943E+01, 4.6373235538E+00, 6.1185058015E+00, 2.2994871212E+00, 9.1241578891E-01],
	[2.6070000000E+04, 1.7926925365E+01, 4.6372878818E+00, 6.1223524530E+00, 2.3001132097E+00, 9.1246453210E-01],
	[2.6075000000E+04, 1.7932498451E+01, 4.6372522169E+00, 6.1262007842E+00, 2.3007391490E+00, 9.1251324782E-01],
	[2.6080000000E+04, 1.7938072200E+01, 4.6372165591E+00, 6.1300507958E+00, 2.3013649391E+00, 9.1256193609E-01],
	[2.6085000000E+04, 1.7943646613E+01, 4.6371809085E+00, 6.1339024879E+00, 2.3019905799E+00, 9.1261059693E-01],
	[2.6090000000E+04, 1.7949221689E+01, 4.6371452649E+00, 6.1377558611E+00, 2.3026160715E+00, 9.1265923035E-01],
	[2.6095000000E+04, 1.7954797428E+01, 4.6371096284E+00, 6.1416109158E+00, 2.3032414136E+00, 9.1270783636E-01],
	[2.6100000000E+04, 1.7960373830E+01, 4.6370739990E+00, 6.1454676523E+00, 2.3038666064E+00, 9.1275641498E-01],
	[2.6105000000E+04, 1.7965950896E+01, 4.6370383768E+00, 6.1493260711E+00, 2.3044916498E+00, 9.1280496621E-01],
	[2.6110000000E+04, 1.7971528625E+01, 4.6370027616E+00, 6.1531861726E+00, 2.3051165438E+00, 9.1285349009E-01],
	[2.6115000000E+04, 1.7977107017E+01, 4.6369671535E+00, 6.1570479572E+00, 2.3057412882E+00, 9.1290198661E-01],
	[2.6120000000E+04, 1.7982686072E+01, 4.6369315525E+00, 6.1609114253E+00, 2.3063658831E+00, 9.1295045580E-01],
	[2.6125000000E+04, 1.7988265791E+01, 4.6368959586E+00, 6.1647765774E+00, 2.3069903284E+00, 9.1299889767E-01],
	[2.6130000000E+04, 1.7993846172E+01, 4.6368603718E+00, 6.1686434137E+00, 2.3076146241E+00, 9.1304731222E-01],
	[2.6135000000E+04, 1.7999427216E+01, 4.6368247921E+00, 6.1725119349E+00, 2.3082387702E+00, 9.1309569949E-01],
	[2.6140000000E+04, 1.8005008923E+01, 4.6367892194E+00, 6.1763821411E+00, 2.3088627665E+00, 9.1314405947E-01],
	[2.6145000000E+04, 1.8010591294E+01, 4.6367536538E+00, 6.1802540330E+00, 2.3094866132E+00, 9.1319239219E-01],
	[2.6150000000E+04, 1.8016174326E+01, 4.6367180953E+00, 6.1841276108E+00, 2.3101103100E+00, 9.1324069765E-01],
	[2.6155000000E+04, 1.8021758022E+01, 4.6366825439E+00, 6.1880028750E+00, 2.3107338571E+00, 9.1328897588E-01],
	[2.6160000000E+04, 1.8027342380E+01, 4.6366469995E+00, 6.1918798261E+00, 2.3113572543E+00, 9.1333722688E-01],
	[2.6165000000E+04, 1.8032927401E+01, 4.6366114622E+00, 6.1957584643E+00, 2.3119805017E+00, 9.1338545068E-01],
	[2.6170000000E+04, 1.8038513085E+01, 4.6365759320E+00, 6.1996387902E+00, 2.3126035991E+00, 9.1343364728E-01],
	[2.6175000000E+04, 1.8044099431E+01, 4.6365404088E+00, 6.2035208041E+00, 2.3132265466E+00, 9.1348181670E-01],
	[2.6180000000E+04, 1.8049686440E+01, 4.6365048927E+00, 6.2074045065E+00, 2.3138493441E+00, 9.1352995895E-01],
	[2.6185000000E+04, 1.8055274111E+01, 4.6364693836E+00, 6.2112898977E+00, 2.3144719915E+00, 9.1357807405E-01],
	[2.6190000000E+04, 1.8060862445E+01, 4.6364338816E+00, 6.2151769782E+00, 2.3150944889E+00, 9.1362616202E-01],
	[2.6195000000E+04, 1.8066451441E+01, 4.6363983866E+00, 6.2190657484E+00, 2.3157168362E+00, 9.1367422285E-01],
	[2.6200000000E+04, 1.8072041099E+01, 4.6363628987E+00, 6.2229562087E+00, 2.3163390333E+00, 9.1372225658E-01],
	[2.6205000000E+04, 1.8077631420E+01, 4.6363274178E+00, 6.2268483594E+00, 2.3169610803E+00, 9.1377026321E-01],
	[2.6210000000E+04, 1.8083222403E+01, 4.6362919440E+00, 6.2307422012E+00, 2.3175829770E+00, 9.1381824276E-01],
	[2.6215000000E+04, 1.8088814048E+01, 4.6362564772E+00, 6.2346377342E+00, 2.3182047235E+00, 9.1386619524E-01],
	[2.6220000000E+04, 1.8094406355E+01, 4.6362210174E+00, 6.2385349590E+00, 2.3188263197E+00, 9.1391412067E-01],
	[2.6225000000E+04, 1.8099999324E+01, 4.6361855647E+00, 6.2424338759E+00, 2.3194477656E+00, 9.1396201906E-01],
	[2.6230000000E+04, 1.8105592956E+01, 4.6361501190E+00, 6.2463344855E+00, 2.3200690611E+00, 9.1400989042E-01],
	[2.6235000000E+04, 1.8111187249E+01, 4.6361146803E+00, 6.2502367880E+00, 2.3206902063E+00, 9.1405773478E-01],
	[2.6240000000E+04, 1.8116782204E+01, 4.6360792486E+00, 6.2541407838E+00, 2.3213112009E+00, 9.1410555213E-01],
	[2.6245000000E+04, 1.8122377822E+01, 4.6360438240E+00, 6.2580464735E+00, 2.3219320451E+00, 9.1415334250E-01],
	[2.6250000000E+04, 1.8127974101E+01, 4.6360084064E+00, 6.2619538574E+00, 2.3225527389E+00, 9.1420110591E-01],
	[2.6255000000E+04, 1.8133571041E+01, 4.6359729958E+00, 6.2658629360E+00, 2.3231732820E+00, 9.1424884236E-01],
	[2.6260000000E+04, 1.8139168644E+01, 4.6359375922E+00, 6.2697737095E+00, 2.3237936746E+00, 9.1429655187E-01],
	[2.6265000000E+04, 1.8144766908E+01, 4.6359021956E+00, 6.2736861785E+00, 2.3244139166E+00, 9.1434423445E-01],
	[2.6270000000E+04, 1.8150365834E+01, 4.6358668061E+00, 6.2776003434E+00, 2.3250340079E+00, 9.1439189012E-01],
	[2.6275000000E+04, 1.8155965422E+01, 4.6358314235E+00, 6.2815162046E+00, 2.3256539485E+00, 9.1443951890E-01],
	[2.6280000000E+04, 1.8161565671E+01, 4.6357960480E+00, 6.2854337624E+00, 2.3262737384E+00, 9.1448712079E-01],
	[2.6285000000E+04, 1.8167166582E+01, 4.6357606794E+00, 6.2893530174E+00, 2.3268933776E+00, 9.1453469581E-01],
	[2.6290000000E+04, 1.8172768154E+01, 4.6357253179E+00, 6.2932739698E+00, 2.3275128659E+00, 9.1458224398E-01],
	[2.6295000000E+04, 1.8178370388E+01, 4.6356899633E+00, 6.2971966202E+00, 2.3281322034E+00, 9.1462976530E-01],
	[2.6300000000E+04, 1.8183973283E+01, 4.6356546157E+00, 6.3011209689E+00, 2.3287513901E+00, 9.1467725980E-01],
	[2.6305000000E+04, 1.8189576839E+01, 4.6356192751E+00, 6.3050470164E+00, 2.3293704259E+00, 9.1472472749E-01],
	[2.6310000000E+04, 1.8195181057E+01, 4.6355839415E+00, 6.3089747630E+00, 2.3299893107E+00, 9.1477216838E-01],
	[2.6315000000E+04, 1.8200785936E+01, 4.6355486149E+00, 6.3129042092E+00, 2.3306080446E+00, 9.1481958248E-01],
	[2.6320000000E+04, 1.8206391476E+01, 4.6355132953E+00, 6.3168353554E+00, 2.3312266274E+00, 9.1486696981E-01],
	[2.6325000000E+04, 1.8212017625E+01, 4.6354810390E+00, 6.3207682019E+00, 2.3318461597E+00, 9.1491433039E-01],
	[2.6330000000E+04, 1.8217647259E+01, 4.6354492202E+00, 6.3247027493E+00, 2.3324656970E+00, 9.1496166423E-01],
	[2.6335000000E+04, 1.8223277564E+01, 4.6354174076E+00, 6.3286389979E+00, 2.3330850840E+00, 9.1500897134E-01],
	[2.6340000000E+04, 1.8228908540E+01, 4.6353856013E+00, 6.3325769481E+00, 2.3337043208E+00, 9.1505625173E-01],
	[2.6345000000E+04, 1.8234540186E+01, 4.6353538013E+00, 6.3365166004E+00, 2.3343234073E+00, 9.1510350543E-01],
	[2.6350000000E+04, 1.8240172503E+01, 4.6353220075E+00, 6.3404579552E+00, 2.3349423434E+00, 9.1515073244E-01],
	[2.6355000000E+04, 1.8245805490E+01, 4.6352902200E+00, 6.3444010128E+00, 2.3355611292E+00, 9.1519793278E-01],
	[2.6360000000E+04, 1.8251439148E+01, 4.6352584387E+00, 6.3483457736E+00, 2.3361797646E+00, 9.1524510647E-01],
	[2.6365000000E+04, 1.8257073477E+01, 4.6352266637E+00, 6.3522922382E+00, 2.3367982495E+00, 9.1529225351E-01],
	[2.6370000000E+04, 1.8262708475E+01, 4.6351948949E+00, 6.3562404069E+00, 2.3374165840E+00, 9.1533937392E-01],
	[2.6375000000E+04, 1.8268344145E+01, 4.6351631324E+00, 6.3601902801E+00, 2.3380347680E+00, 9.1538646772E-01],
	[2.6380000000E+04, 1.8273980484E+01, 4.6351313760E+00, 6.3641418583E+00, 2.3386528014E+00, 9.1543353493E-01],
	[2.6385000000E+04, 1.8279617494E+01, 4.6350996260E+00, 6.3680951417E+00, 2.3392706842E+00, 9.1548057554E-01],
	[2.6390000000E+04, 1.8285255174E+01, 4.6350678821E+00, 6.3720501310E+00, 2.3398884165E+00, 9.1552758959E-01],
	[2.6395000000E+04, 1.8290893524E+01, 4.6350361445E+00, 6.3760068264E+00, 2.3405059981E+00, 9.1557457707E-01],
	[2.6400000000E+04, 1.8296532545E+01, 4.6350044131E+00, 6.3799652284E+00, 2.3411234290E+00, 9.1562153802E-01],
	[2.6405000000E+04, 1.8302172236E+01, 4.6349726880E+00, 6.3839253374E+00, 2.3417407093E+00, 9.1566847244E-01],
	[2.6410000000E+04, 1.8307812596E+01, 4.6349409690E+00, 6.3878871537E+00, 2.3423578387E+00, 9.1571538034E-01],
	[2.6415000000E+04, 1.8313453627E+01, 4.6349092563E+00, 6.3918506780E+00, 2.3429748175E+00, 9.1576226174E-01],
	[2.6420000000E+04, 1.8319095327E+01, 4.6348775498E+00, 6.3958159104E+00, 2.3435916454E+00, 9.1580911666E-01],
	[2.6425000000E+04, 1.8324737698E+01, 4.6348458496E+00, 6.3997828515E+00, 2.3442083224E+00, 9.1585594510E-01],
	[2.6430000000E+04, 1.8330380738E+01, 4.6348141555E+00, 6.4037515016E+00, 2.3448248486E+00, 9.1590274709E-01],
	[2.6435000000E+04, 1.8336024448E+01, 4.6347824677E+00, 6.4077218612E+00, 2.3454412239E+00, 9.1594952263E-01],
	[2.6440000000E+04, 1.8341668828E+01, 4.6347507860E+00, 6.4116939307E+00, 2.3460574483E+00, 9.1599627175E-01],
	[2.6445000000E+04, 1.8347313878E+01, 4.6347191106E+00, 6.4156677105E+00, 2.3466735216E+00, 9.1604299445E-01],
	[2.6450000000E+04, 1.8352959597E+01, 4.6346874414E+00, 6.4196432010E+00, 2.3472894440E+00, 9.1608969075E-01],
	[2.6455000000E+04, 1.8358605986E+01, 4.6346557783E+00, 6.4236204026E+00, 2.3479052153E+00, 9.1613636066E-01],
	[2.6460000000E+04, 1.8364253045E+01, 4.6346241215E+00, 6.4275993158E+00, 2.3485208356E+00, 9.1618300420E-01],
	[2.6465000000E+04, 1.8369900773E+01, 4.6345924709E+00, 6.4315799409E+00, 2.3491363048E+00, 9.1622962138E-01],
	[2.6470000000E+04, 1.8375549171E+01, 4.6345608265E+00, 6.4355622783E+00, 2.3497516228E+00, 9.1627621222E-01],
	[2.6475000000E+04, 1.8381198238E+01, 4.6345291882E+00, 6.4395463286E+00, 2.3503667897E+00, 9.1632277673E-01],
	[2.6480000000E+04, 1.8386847974E+01, 4.6344975562E+00, 6.4435320920E+00, 2.3509818053E+00, 9.1636931493E-01],
	[2.6485000000E+04, 1.8392498380E+01, 4.6344659303E+00, 6.4475195690E+00, 2.3515966698E+00, 9.1641582682E-01],
	[2.6490000000E+04, 1.8398149455E+01, 4.6344343106E+00, 6.4515087600E+00, 2.3522113829E+00, 9.1646231243E-01],
	[2.6495000000E+04, 1.8403801199E+01, 4.6344026971E+00, 6.4554996655E+00, 2.3528259448E+00, 9.1650877176E-01],
	[2.6500000000E+04, 1.8409453613E+01, 4.6343710898E+00, 6.4594922857E+00, 2.3534403554E+00, 9.1655520484E-01],
	[2.6505000000E+04, 1.8415106695E+01, 4.6343394887E+00, 6.4634866213E+00, 2.3540546146E+00, 9.1660161167E-01],
	[2.6510000000E+04, 1.8420760447E+01, 4.6343078937E+00, 6.4674826725E+00, 2.3546687224E+00, 9.1664799227E-01],
	[2.6515000000E+04, 1.8426414868E+01, 4.6342763050E+00, 6.4714804397E+00, 2.3552826788E+00, 9.1669434666E-01],
	[2.6520000000E+04, 1.8432069958E+01, 4.6342447224E+00, 6.4754799235E+00, 2.3558964838E+00, 9.1674067484E-01],
	[2.6525000000E+04, 1.8437725717E+01, 4.6342131459E+00, 6.4794811241E+00, 2.3565101372E+00, 9.1678697684E-01],
	[2.6530000000E+04, 1.8443382145E+01, 4.6341815756E+00, 6.4834840421E+00, 2.3571236392E+00, 9.1683325266E-01],
	[2.6535000000E+04, 1.8449039241E+01, 4.6341500115E+00, 6.4874886778E+00, 2.3577369896E+00, 9.1687950233E-01],
	[2.6540000000E+04, 1.8454697007E+01, 4.6341184536E+00, 6.4914950317E+00, 2.3583501884E+00, 9.1692572585E-01],
	[2.6545000000E+04, 1.8460355441E+01, 4.6340869018E+00, 6.4955031041E+00, 2.3589632356E+00, 9.1697192324E-01],
	[2.6550000000E+04, 1.8466014544E+01, 4.6340553562E+00, 6.4995128954E+00, 2.3595761312E+00, 9.1701809451E-01],
	[2.6555000000E+04, 1.8471674316E+01, 4.6340238167E+00, 6.5035244062E+00, 2.3601888751E+00, 9.1706423969E-01],
	[2.6560000000E+04, 1.8477334756E+01, 4.6339922834E+00, 6.5075376367E+00, 2.3608014674E+00, 9.1711035877E-01],
	[2.6565000000E+04, 1.8482995865E+01, 4.6339607562E+00, 6.5115525874E+00, 2.3614139079E+00, 9.1715645178E-01],
	[2.6570000000E+04, 1.8488657642E+01, 4.6339292352E+00, 6.5155692588E+00, 2.3620261966E+00, 9.1720251873E-01],
	[2.6575000000E+04, 1.8494320088E+01, 4.6338977203E+00, 6.5195876512E+00, 2.3626383336E+00, 9.1724855964E-01],
	[2.6580000000E+04, 1.8499983203E+01, 4.6338662116E+00, 6.5236077651E+00, 2.3632503187E+00, 9.1729457452E-01],
	[2.6585000000E+04, 1.8505646986E+01, 4.6338347090E+00, 6.5276296008E+00, 2.3638621520E+00, 9.1734056338E-01],
	[2.6590000000E+04, 1.8511311437E+01, 4.6338032125E+00, 6.5316531587E+00, 2.3644738334E+00, 9.1738652623E-01],
	[2.6595000000E+04, 1.8516976556E+01, 4.6337717222E+00, 6.5356784394E+00, 2.3650853629E+00, 9.1743246310E-01],
	[2.6600000000E+04, 1.8522642344E+01, 4.6337402380E+00, 6.5397054432E+00, 2.3656967405E+00, 9.1747837400E-01],
	[2.6605000000E+04, 1.8528308800E+01, 4.6337087599E+00, 6.5437341704E+00, 2.3663079660E+00, 9.1752425893E-01],
	[2.6610000000E+04, 1.8533975924E+01, 4.6336772880E+00, 6.5477646217E+00, 2.3669190396E+00, 9.1757011792E-01],
	[2.6615000000E+04, 1.8539643717E+01, 4.6336458222E+00, 6.5517967972E+00, 2.3675299612E+00, 9.1761595098E-01],
	[2.6620000000E+04, 1.8545312177E+01, 4.6336143625E+00, 6.5558306975E+00, 2.3681407307E+00, 9.1766175813E-01],
	[2.6625000000E+04, 1.8550981305E+01, 4.6335829090E+00, 6.5598663230E+00, 2.3687513481E+00, 9.1770753936E-01],
	[2.6630000000E+04, 1.8556651102E+01, 4.6335514615E+00, 6.5639036740E+00, 2.3693618135E+00, 9.1775329471E-01],
	[2.6635000000E+04, 1.8562321566E+01, 4.6335200202E+00, 6.5679427511E+00, 2.3699721266E+00, 9.1779902419E-01],
	[2.6640000000E+04, 1.8567992698E+01, 4.6334885850E+00, 6.5719835545E+00, 2.3705822876E+00, 9.1784472781E-01],
	[2.6645000000E+04, 1.8573664498E+01, 4.6334571559E+00, 6.5760260848E+00, 2.3711922964E+00, 9.1789040558E-01],
	[2.6650000000E+04, 1.8579336966E+01, 4.6334257330E+00, 6.5800703423E+00, 2.3718021530E+00, 9.1793605752E-01],
	[2.6655000000E+04, 1.8585010102E+01, 4.6333943161E+00, 6.5841163274E+00, 2.3724118573E+00, 9.1798168364E-01],
	[2.6660000000E+04, 1.8590683905E+01, 4.6333629053E+00, 6.5881640407E+00, 2.3730214093E+00, 9.1802728396E-01],
	[2.6665000000E+04, 1.8596358376E+01, 4.6333315007E+00, 6.5922134824E+00, 2.3736308090E+00, 9.1807285849E-01],
	[2.6670000000E+04, 1.8602033515E+01, 4.6333001021E+00, 6.5962646529E+00, 2.3742400563E+00, 9.1811840724E-01],
	[2.6675000000E+04, 1.8607709321E+01, 4.6332687096E+00, 6.6003175528E+00, 2.3748491513E+00, 9.1816393023E-01],
	[2.6680000000E+04, 1.8613385795E+01, 4.6332373233E+00, 6.6043721824E+00, 2.3754580939E+00, 9.1820942748E-01],
	[2.6685000000E+04, 1.8619062936E+01, 4.6332059430E+00, 6.6084285422E+00, 2.3760668840E+00, 9.1825489900E-01],
	[2.6690000000E+04, 1.8624740744E+01, 4.6331745688E+00, 6.6124866324E+00, 2.3766755217E+00, 9.1830034479E-01],
	[2.6695000000E+04, 1.8630419220E+01, 4.6331432007E+00, 6.6165464537E+00, 2.3772840069E+00, 9.1834576489E-01],
	[2.6700000000E+04, 1.8636098364E+01, 4.6331118387E+00, 6.6206080063E+00, 2.3778923396E+00, 9.1839115929E-01],
	[2.6705000000E+04, 1.8641778174E+01, 4.6330804828E+00, 6.6246712907E+00, 2.3785005198E+00, 9.1843652802E-01],
	[2.6710000000E+04, 1.8647458652E+01, 4.6330491330E+00, 6.6287363073E+00, 2.3791085473E+00, 9.1848187109E-01],
	[2.6715000000E+04, 1.8653139797E+01, 4.6330177892E+00, 6.6328030565E+00, 2.3797164223E+00, 9.1852718851E-01],
	[2.6720000000E+04, 1.8658821609E+01, 4.6329864515E+00, 6.6368715387E+00, 2.3803241447E+00, 9.1857248030E-01],
	[2.6725000000E+04, 1.8664504089E+01, 4.6329551199E+00, 6.6409417544E+00, 2.3809317144E+00, 9.1861774647E-01],
	[2.6730000000E+04, 1.8670187235E+01, 4.6329237944E+00, 6.6450137039E+00, 2.3815391314E+00, 9.1866298704E-01],
	[2.6735000000E+04, 1.8675871048E+01, 4.6328924749E+00, 6.6490873877E+00, 2.3821463957E+00, 9.1870820201E-01],
	[2.6740000000E+04, 1.8681555529E+01, 4.6328611615E+00, 6.6531628062E+00, 2.3827535073E+00, 9.1875339141E-01],
	[2.6745000000E+04, 1.8687243632E+01, 4.6328303015E+00, 6.6572399598E+00, 2.3833606326E+00, 9.1879855525E-01],
	[2.6750000000E+04, 1.8692951994E+01, 4.6328024106E+00, 6.6613188489E+00, 2.3839687084E+00, 9.1884369355E-01],
	[2.6755000000E+04, 1.8698661032E+01, 4.6327745250E+00, 6.6653994739E+00, 2.3845766323E+00, 9.1888880630E-01],
	[2.6760000000E+04, 1.8704370747E+01, 4.6327466449E+00, 6.6694818353E+00, 2.3851844042E+00, 9.1893389354E-01],
	[2.6765000000E+04, 1.8710081138E+01, 4.6327187701E+00, 6.6735659334E+00, 2.3857920241E+00, 9.1897895528E-01],
	[2.6770000000E+04, 1.8715792205E+01, 4.6326909007E+00, 6.6776517687E+00, 2.3863994919E+00, 9.1902399152E-01],
	[2.6775000000E+04, 1.8721503948E+01, 4.6326630367E+00, 6.6817393416E+00, 2.3870068077E+00, 9.1906900229E-01],
	[2.6780000000E+04, 1.8727216367E+01, 4.6326351780E+00, 6.6858286524E+00, 2.3876139713E+00, 9.1911398760E-01],
	[2.6785000000E+04, 1.8732929463E+01, 4.6326073247E+00, 6.6899197017E+00, 2.3882209828E+00, 9.1915894746E-01],
	[2.6790000000E+04, 1.8738643234E+01, 4.6325794768E+00, 6.6940124898E+00, 2.3888278422E+00, 9.1920388188E-01],
	[2.6795000000E+04, 1.8744357682E+01, 4.6325516342E+00, 6.6981070171E+00, 2.3894345493E+00, 9.1924879089E-01],
	[2.6800000000E+04, 1.8750072805E+01, 4.6325237970E+00, 6.7022032841E+00, 2.3900411043E+00, 9.1929367449E-01],
	[2.6805000000E+04, 1.8755788604E+01, 4.6324959652E+00, 6.7063012912E+00, 2.3906475070E+00, 9.1933853270E-01],
	[2.6810000000E+04, 1.8761505079E+01, 4.6324681387E+00, 6.7104010387E+00, 2.3912537574E+00, 9.1938336553E-01],
	[2.6815000000E+04, 1.8767222230E+01, 4.6324403176E+00, 6.7145025271E+00, 2.3918598556E+00, 9.1942817300E-01],
	[2.6820000000E+04, 1.8772940057E+01, 4.6324125018E+00, 6.7186057569E+00, 2.3924658014E+00, 9.1947295512E-01],
	[2.6825000000E+04, 1.8778658559E+01, 4.6323846914E+00, 6.7227107283E+00, 2.3930715949E+00, 9.1951771191E-01],
	[2.6830000000E+04, 1.8784377737E+01, 4.6323568863E+00, 6.7268174420E+00, 2.3936772361E+00, 9.1956244337E-01],
	[2.6835000000E+04, 1.8790097591E+01, 4.6323290866E+00, 6.7309258981E+00, 2.3942827248E+00, 9.1960714954E-01],
	[2.6840000000E+04, 1.8795818120E+01, 4.6323012922E+00, 6.7350360972E+00, 2.3948880611E+00, 9.1965183040E-01],
	[2.6845000000E+04, 1.8801539325E+01, 4.6322735032E+00, 6.7391480397E+00, 2.3954932449E+00, 9.1969648600E-01],
	[2.6850000000E+04, 1.8807261205E+01, 4.6322457195E+00, 6.7432617261E+00, 2.3960982763E+00, 9.1974111632E-01],
	[2.6855000000E+04, 1.8812983761E+01, 4.6322179412E+00, 6.7473771566E+00, 2.3967031552E+00, 9.1978572140E-01],
	[2.6860000000E+04, 1.8818706992E+01, 4.6321901681E+00, 6.7514943317E+00, 2.3973078816E+00, 9.1983030125E-01],
	[2.6865000000E+04, 1.8824430898E+01, 4.6321624005E+00, 6.7556132519E+00, 2.3979124554E+00, 9.1987485587E-01],
	[2.6870000000E+04, 1.8830155480E+01, 4.6321346381E+00, 6.7597339175E+00, 2.3985168767E+00, 9.1991938529E-01],
	[2.6875000000E+04, 1.8835880736E+01, 4.6321068811E+00, 6.7638563290E+00, 2.3991211453E+00, 9.1996388951E-01],
	[2.6880000000E+04, 1.8841606669E+01, 4.6320791294E+00, 6.7679804868E+00, 2.3997252613E+00, 9.2000836856E-01],
	[2.6885000000E+04, 1.8847333276E+01, 4.6320513831E+00, 6.7721063913E+00, 2.4003292247E+00, 9.2005282244E-01],
	[2.6890000000E+04, 1.8853060558E+01, 4.6320236421E+00, 6.7762340429E+00, 2.4009330354E+00, 9.2009725118E-01],
	[2.6895000000E+04, 1.8858788515E+01, 4.6319959064E+00, 6.7803634420E+00, 2.4015366934E+00, 9.2014165477E-01],
	[2.6900000000E+04, 1.8864517148E+01, 4.6319681760E+00, 6.7844945891E+00, 2.4021401987E+00, 9.2018603324E-01],
	[2.6905000000E+04, 1.8870246455E+01, 4.6319404509E+00, 6.7886274845E+00, 2.4027435512E+00, 9.2023038659E-01],
	[2.6910000000E+04, 1.8875976438E+01, 4.6319127312E+00, 6.7927621287E+00, 2.4033467510E+00, 9.2027471484E-01],
	[2.6915000000E+04, 1.8881707095E+01, 4.6318850168E+00, 6.7968985221E+00, 2.4039497979E+00, 9.2031901800E-01],
	[2.6920000000E+04, 1.8887438427E+01, 4.6318573077E+00, 6.8010366651E+00, 2.4045526920E+00, 9.2036329608E-01],
	[2.6925000000E+04, 1.8893170433E+01, 4.6318296039E+00, 6.8051765581E+00, 2.4051554333E+00, 9.2040754910E-01],
	[2.6930000000E+04, 1.8898903115E+01, 4.6318019054E+00, 6.8093182015E+00, 2.4057580218E+00, 9.2045177706E-01],
	[2.6935000000E+04, 1.8904636471E+01, 4.6317742122E+00, 6.8134615958E+00, 2.4063604573E+00, 9.2049597999E-01],
	[2.6940000000E+04, 1.8910370502E+01, 4.6317465243E+00, 6.8176067413E+00, 2.4069627399E+00, 9.2054015788E-01],
	[2.6945000000E+04, 1.8916105207E+01, 4.6317188417E+00, 6.8217536385E+00, 2.4075648696E+00, 9.2058431076E-01],
	[2.6950000000E+04, 1.8921840588E+01, 4.6316911645E+00, 6.8259022878E+00, 2.4081668463E+00, 9.2062843863E-01],
	[2.6955000000E+04, 1.8927576642E+01, 4.6316634925E+00, 6.8300526897E+00, 2.4087686700E+00, 9.2067254151E-01],
	[2.6960000000E+04, 1.8933313371E+01, 4.6316358258E+00, 6.8342048444E+00, 2.4093703407E+00, 9.2071661941E-01],
	[2.6965000000E+04, 1.8939050774E+01, 4.6316081644E+00, 6.8383587524E+00, 2.4099718583E+00, 9.2076067234E-01],
	[2.6970000000E+04, 1.8944788852E+01, 4.6315805083E+00, 6.8425144142E+00, 2.4105732230E+00, 9.2080470032E-01],
	[2.6975000000E+04, 1.8950527604E+01, 4.6315528576E+00, 6.8466718302E+00, 2.4111744345E+00, 9.2084870335E-01],
	[2.6980000000E+04, 1.8956267031E+01, 4.6315252121E+00, 6.8508310008E+00, 2.4117754929E+00, 9.2089268146E-01],
	[2.6985000000E+04, 1.8962007131E+01, 4.6314975718E+00, 6.8549919263E+00, 2.4123763982E+00, 9.2093663464E-01],
	[2.6990000000E+04, 1.8967747906E+01, 4.6314699369E+00, 6.8591546073E+00, 2.4129771503E+00, 9.2098056292E-01],
	[2.6995000000E+04, 1.8973489355E+01, 4.6314423073E+00, 6.8633190441E+00, 2.4135777493E+00, 9.2102446631E-01],
	[2.7000000000E+04, 1.8979231478E+01, 4.6314146829E+00, 6.8674852371E+00, 2.4141781950E+00, 9.2106834481E-01],
	[2.7005000000E+04, 1.8984974275E+01, 4.6313870638E+00, 6.8716531868E+00, 2.4147784875E+00, 9.2111219844E-01],
	[2.7010000000E+04, 1.8990717746E+01, 4.6313594500E+00, 6.8758228935E+00, 2.4153786268E+00, 9.2115602722E-01],
	[2.7015000000E+04, 1.8996461891E+01, 4.6313318415E+00, 6.8799943577E+00, 2.4159786129E+00, 9.2119983115E-01],
	[2.7020000000E+04, 1.9002206710E+01, 4.6313042382E+00, 6.8841675799E+00, 2.4165784456E+00, 9.2124361025E-01],
	[2.7025000000E+04, 1.9007952203E+01, 4.6312766402E+00, 6.8883425603E+00, 2.4171781250E+00, 9.2128736453E-01],
	[2.7030000000E+04, 1.9013698370E+01, 4.6312490475E+00, 6.8925192995E+00, 2.4177776511E+00, 9.2133109401E-01],
	[2.7035000000E+04, 1.9019445210E+01, 4.6312214601E+00, 6.8966977978E+00, 2.4183770238E+00, 9.2137479869E-01],
	[2.7040000000E+04, 1.9025192724E+01, 4.6311938779E+00, 6.9008780557E+00, 2.4189762432E+00, 9.2141847858E-01],
	[2.7045000000E+04, 1.9030940912E+01, 4.6311663010E+00, 6.9050600736E+00, 2.4195753091E+00, 9.2146213370E-01],
	[2.7050000000E+04, 1.9036689774E+01, 4.6311387293E+00, 6.9092438518E+00, 2.4201742216E+00, 9.2150576407E-01],
	[2.7055000000E+04, 1.9042439309E+01, 4.6311111629E+00, 6.9134293909E+00, 2.4207729807E+00, 9.2154936969E-01],
	[2.7060000000E+04, 1.9048189518E+01, 4.6310836018E+00, 6.9176166912E+00, 2.4213715863E+00, 9.2159295057E-01],
	[2.7065000000E+04, 1.9053940400E+01, 4.6310560459E+00, 6.9218057531E+00, 2.4219700384E+00, 9.2163650674E-01],
	[2.7070000000E+04, 1.9059691955E+01, 4.6310284953E+00, 6.9259965771E+00, 2.4225683370E+00, 9.2168003819E-01],
	[2.7075000000E+04, 1.9065444184E+01, 4.6310009499E+00, 6.9301891635E+00, 2.4231664821E+00, 9.2172354495E-01],
	[2.7080000000E+04, 1.9071197087E+01, 4.6309734098E+00, 6.9343835129E+00, 2.4237644736E+00, 9.2176702703E-01],
	[2.7085000000E+04, 1.9076950663E+01, 4.6309458749E+00, 6.9385796255E+00, 2.4243623116E+00, 9.2181048443E-01],
	[2.7090000000E+04, 1.9082704912E+01, 4.6309183453E+00, 6.9427775018E+00, 2.4249599959E+00, 9.2185391718E-01],
	[2.7095000000E+04, 1.9088459834E+01, 4.6308908209E+00, 6.9469771423E+00, 2.4255575266E+00, 9.2189732527E-01],
	[2.7100000000E+04, 1.9094215429E+01, 4.6308633018E+00, 6.9511785473E+00, 2.4261549037E+00, 9.2194070873E-01],
	[2.7105000000E+04, 1.9099971698E+01, 4.6308357879E+00, 6.9553817173E+00, 2.4267521271E+00, 9.2198406757E-01],
	[2.7110000000E+04, 1.9105728639E+01, 4.6308082792E+00, 6.9595866527E+00, 2.4273491969E+00, 9.2202740180E-01],
	[2.7115000000E+04, 1.9111486254E+01, 4.6307807758E+00, 6.9637933538E+00, 2.4279461129E+00, 9.2207071144E-01],
	[2.7120000000E+04, 1.9117244542E+01, 4.6307532776E+00, 6.9680018212E+00, 2.4285428752E+00, 9.2211399648E-01],
	[2.7125000000E+04, 1.9123003502E+01, 4.6307257846E+00, 6.9722120552E+00, 2.4291394838E+00, 9.2215725696E-01],
	[2.7130000000E+04, 1.9128763136E+01, 4.6306982969E+00, 6.9764240562E+00, 2.4297359386E+00, 9.2220049287E-01],
	[2.7135000000E+04, 1.9134523442E+01, 4.6306708144E+00, 6.9806378247E+00, 2.4303322396E+00, 9.2224370424E-01],
	[2.7140000000E+04, 1.9140284422E+01, 4.6306433371E+00, 6.9848533610E+00, 2.4309283868E+00, 9.2228689107E-01],
	[2.7145000000E+04, 1.9146046074E+01, 4.6306158651E+00, 6.9890706657E+00, 2.4315243802E+00, 9.2233005338E-01],
	[2.7150000000E+04, 1.9151808398E+01, 4.6305883983E+00, 6.9932897390E+00, 2.4321202197E+00, 9.2237319118E-01],
	[2.7155000000E+04, 1.9157571396E+01, 4.6305609366E+00, 6.9975105815E+00, 2.4327159054E+00, 9.2241630448E-01],
	[2.7160000000E+04, 1.9163335066E+01, 4.6305334803E+00, 7.0017331934E+00, 2.4333114372E+00, 9.2245939329E-01],
	[2.7165000000E+04, 1.9169099409E+01, 4.6305060291E+00, 7.0059575754E+00, 2.4339068151E+00, 9.2250245763E-01],
	[2.7170000000E+04, 1.9174864424E+01, 4.6304785831E+00, 7.0101837277E+00, 2.4345020390E+00, 9.2254549751E-01],
	[2.7175000000E+04, 1.9180630594E+01, 4.6304512145E+00, 7.0144116508E+00, 2.4350971367E+00, 9.2258851294E-01],
	[2.7180000000E+04, 1.9186419280E+01, 4.6304271142E+00, 7.0186413451E+00, 2.4356933354E+00, 9.2263150394E-01],
	[2.7185000000E+04, 1.9192208648E+01, 4.6304030184E+00, 7.0228728110E+00, 2.4362893809E+00, 9.2267447051E-01],
	[2.7190000000E+04, 1.9197998698E+01, 4.6303789271E+00, 7.0271060489E+00, 2.4368852732E+00, 9.2271741267E-01],
	[2.7195000000E+04, 1.9203789429E+01, 4.6303548404E+00, 7.0313410593E+00, 2.4374810122E+00, 9.2276033043E-01],
	[2.7200000000E+04, 1.9209580842E+01, 4.6303307582E+00, 7.0355778425E+00, 2.4380765981E+00, 9.2280322381E-01],
	[2.7205000000E+04, 1.9215372936E+01, 4.6303066806E+00, 7.0398163990E+00, 2.4386720306E+00, 9.2284609281E-01],
	[2.7210000000E+04, 1.9221165712E+01, 4.6302826076E+00, 7.0440567292E+00, 2.4392673099E+00, 9.2288893745E-01],
	[2.7215000000E+04, 1.9226959169E+01, 4.6302585391E+00, 7.0482988335E+00, 2.4398624359E+00, 9.2293175774E-01],
	[2.7220000000E+04, 1.9232753308E+01, 4.6302344751E+00, 7.0525427123E+00, 2.4404574086E+00, 9.2297455370E-01],
	[2.7225000000E+04, 1.9238548128E+01, 4.6302104157E+00, 7.0567883661E+00, 2.4410522280E+00, 9.2301732533E-01],
	[2.7230000000E+04, 1.9244343629E+01, 4.6301863609E+00, 7.0610357952E+00, 2.4416468940E+00, 9.2306007265E-01],
	[2.7235000000E+04, 1.9250139812E+01, 4.6301623105E+00, 7.0652850001E+00, 2.4422414066E+00, 9.2310279567E-01],
	[2.7240000000E+04, 1.9255936676E+01, 4.6301382647E+00, 7.0695359812E+00, 2.4428357658E+00, 9.2314549441E-01],
	[2.7245000000E+04, 1.9261734222E+01, 4.6301142235E+00, 7.0737887389E+00, 2.4434299717E+00, 9.2318816887E-01],
	[2.7250000000E+04, 1.9267532448E+01, 4.6300901868E+00, 7.0780432736E+00, 2.4440240240E+00, 9.2323081907E-01],
	[2.7255000000E+04, 1.9273331356E+01, 4.6300661546E+00, 7.0822995858E+00, 2.4446179230E+00, 9.2327344502E-01],
	[2.7260000000E+04, 1.9279130944E+01, 4.6300421270E+00, 7.0865576758E+00, 2.4452116685E+00, 9.2331604673E-01],
	[2.7265000000E+04, 1.9284931214E+01, 4.6300181039E+00, 7.0908175441E+00, 2.4458052604E+00, 9.2335862422E-01],
	[2.7270000000E+04, 1.9290732165E+01, 4.6299940853E+00, 7.0950791911E+00, 2.4463986989E+00, 9.2340117750E-01],
	[2.7275000000E+04, 1.9296533796E+01, 4.6299700712E+00, 7.0993426171E+00, 2.4469919839E+00, 9.2344370658E-01],
	[2.7280000000E+04, 1.9302336109E+01, 4.6299460617E+00, 7.1036078227E+00, 2.4475851153E+00, 9.2348621147E-01],
	[2.7285000000E+04, 1.9308139102E+01, 4.6299220567E+00, 7.1078748082E+00, 2.4481780931E+00, 9.2352869219E-01],
	[2.7290000000E+04, 1.9313942776E+01, 4.6298980562E+00, 7.1121435741E+00, 2.4487709174E+00, 9.2357114875E-01],
	[2.7295000000E+04, 1.9319747131E+01, 4.6298740603E+00, 7.1164141207E+00, 2.4493635880E+00, 9.2361358116E-01],
	[2.7300000000E+04, 1.9325552167E+01, 4.6298500688E+00, 7.1206864485E+00, 2.4499561051E+00, 9.2365598943E-01],
	[2.7305000000E+04, 1.9331357883E+01, 4.6298260819E+00, 7.1249605580E+00, 2.4505484685E+00, 9.2369837358E-01],
	[2.7310000000E+04, 1.9337164280E+01, 4.6298020995E+00, 7.1292364494E+00, 2.4511406782E+00, 9.2374073362E-01],
	[2.7315000000E+04, 1.9342971358E+01, 4.6297781216E+00, 7.1335141233E+00, 2.4517327343E+00, 9.2378306955E-01],
	[2.7320000000E+04, 1.9348779116E+01, 4.6297541482E+00, 7.1377935800E+00, 2.4523246367E+00, 9.2382538140E-01],
	[2.7325000000E+04, 1.9354587554E+01, 4.6297301794E+00, 7.1420748200E+00, 2.4529163854E+00, 9.2386766918E-01],
	[2.7330000000E+04, 1.9360396673E+01, 4.6297062150E+00, 7.1463578437E+00, 2.4535079803E+00, 9.2390993290E-01],
	[2.7335000000E+04, 1.9366206473E+01, 4.6296822551E+00, 7.1506426514E+00, 2.4540994215E+00, 9.2395217256E-01],
	[2.7340000000E+04, 1.9372016952E+01, 4.6296582998E+00, 7.1549292437E+00, 2.4546907090E+00, 9.2399438819E-01],
	[2.7345000000E+04, 1.9377828112E+01, 4.6296343490E+00, 7.1592176209E+00, 2.4552818427E+00, 9.2403657980E-01],
	[2.7350000000E+04, 1.9383639953E+01, 4.6296104026E+00, 7.1635077835E+00, 2.4558728225E+00, 9.2407874740E-01],
	[2.7355000000E+04, 1.9389452473E+01, 4.6295864608E+00, 7.1677997318E+00, 2.4564636486E+00, 9.2412089099E-01],
	[2.7360000000E+04, 1.9395265674E+01, 4.6295625235E+00, 7.1720934663E+00, 2.4570543208E+00, 9.2416301061E-01],
	[2.7365000000E+04, 1.9401079555E+01, 4.6295385906E+00, 7.1763889874E+00, 2.4576448392E+00, 9.2420510624E-01],
	[2.7370000000E+04, 1.9406894116E+01, 4.6295146623E+00, 7.1806862955E+00, 2.4582352037E+00, 9.2424717792E-01],
	[2.7375000000E+04, 1.9412709357E+01, 4.6294907384E+00, 7.1849853911E+00, 2.4588254144E+00, 9.2428922565E-01],
	[2.7380000000E+04, 1.9418525278E+01, 4.6294668191E+00, 7.1892862745E+00, 2.4594154711E+00, 9.2433124944E-01],
	[2.7385000000E+04, 1.9424341879E+01, 4.6294429042E+00, 7.1935889462E+00, 2.4600053739E+00, 9.2437324931E-01],
	[2.7390000000E+04, 1.9430159160E+01, 4.6294189939E+00, 7.1978934065E+00, 2.4605951228E+00, 9.2441522526E-01],
	[2.7395000000E+04, 1.9435977121E+01, 4.6293950880E+00, 7.2021996560E+00, 2.4611847177E+00, 9.2445717732E-01],
	[2.7400000000E+04, 1.9441795761E+01, 4.6293711866E+00, 7.2065076949E+00, 2.4617741587E+00, 9.2449910550E-01],
	[2.7405000000E+04, 1.9447615082E+01, 4.6293472897E+00, 7.2108175238E+00, 2.4623634457E+00, 9.2454100980E-01],
	[2.7410000000E+04, 1.9453435082E+01, 4.6293233972E+00, 7.2151291431E+00, 2.4629525787E+00, 9.2458289024E-01],
	[2.7415000000E+04, 1.9459255762E+01, 4.6292995093E+00, 7.2194425531E+00, 2.4635415577E+00, 9.2462474683E-01],
	[2.7420000000E+04, 1.9465077121E+01, 4.6292756258E+00, 7.2237577543E+00, 2.4641303826E+00, 9.2466657958E-01],
	[2.7425000000E+04, 1.9470899160E+01, 4.6292517468E+00, 7.2280747470E+00, 2.4647190535E+00, 9.2470838852E-01],
	[2.7430000000E+04, 1.9476721879E+01, 4.6292278723E+00, 7.2323935318E+00, 2.4653075703E+00, 9.2475017364E-01],
	[2.7435000000E+04, 1.9482545277E+01, 4.6292040023E+00, 7.2367141091E+00, 2.4658959331E+00, 9.2479193496E-01],
	[2.7440000000E+04, 1.9488369355E+01, 4.6291801367E+00, 7.2410364792E+00, 2.4664841417E+00, 9.2483367250E-01],
	[2.7445000000E+04, 1.9494194112E+01, 4.6291562756E+00, 7.2453606425E+00, 2.4670721962E+00, 9.2487538627E-01],
	[2.7450000000E+04, 1.9500019548E+01, 4.6291324190E+00, 7.2496865996E+00, 2.4676600966E+00, 9.2491707628E-01],
	[2.7455000000E+04, 1.9505845664E+01, 4.6291085668E+00, 7.2540143507E+00, 2.4682478429E+00, 9.2495874254E-01],
	[2.7460000000E+04, 1.9511672459E+01, 4.6290847191E+00, 7.2583438964E+00, 2.4688354350E+00, 9.2500038506E-01],
	[2.7465000000E+04, 1.9517499933E+01, 4.6290608759E+00, 7.2626752370E+00, 2.4694228729E+00, 9.2504200386E-01],
	[2.7470000000E+04, 1.9523328086E+01, 4.6290370371E+00, 7.2670083729E+00, 2.4700101567E+00, 9.2508359896E-01],
	[2.7475000000E+04, 1.9529156919E+01, 4.6290132028E+00, 7.2713433046E+00, 2.4705972862E+00, 9.2512517035E-01],
	[2.7480000000E+04, 1.9534986431E+01, 4.6289893730E+00, 7.2756800325E+00, 2.4711842615E+00, 9.2516671806E-01],
	[2.7485000000E+04, 1.9540816621E+01, 4.6289655476E+00, 7.2800185570E+00, 2.4717710825E+00, 9.2520824210E-01],
	[2.7490000000E+04, 1.9546647491E+01, 4.6289417267E+00, 7.2843588786E+00, 2.4723577494E+00, 9.2524974248E-01],
	[2.7495000000E+04, 1.9552479040E+01, 4.6289179102E+00, 7.2887009975E+00, 2.4729442619E+00, 9.2529121921E-01],
	[2.7500000000E+04, 1.9558311268E+01, 4.6288940982E+00, 7.2930449143E+00, 2.4735306202E+00, 9.2533267231E-01],
	[2.7505000000E+04, 1.9564144174E+01, 4.6288702906E+00, 7.2973906294E+00, 2.4741168241E+00, 9.2537410179E-01],
	[2.7510000000E+04, 1.9569977760E+01, 4.6288464875E+00, 7.3017381432E+00, 2.4747028738E+00, 9.2541550766E-01],
	[2.7515000000E+04, 1.9575812024E+01, 4.6288226888E+00, 7.3060874561E+00, 2.4752887691E+00, 9.2545688993E-01],
	[2.7520000000E+04, 1.9581646967E+01, 4.6287988946E+00, 7.3104385685E+00, 2.4758745101E+00, 9.2549824861E-01],
	[2.7525000000E+04, 1.9587482589E+01, 4.6287751048E+00, 7.3147914809E+00, 2.4764600967E+00, 9.2553958373E-01],
	[2.7530000000E+04, 1.9593318889E+01, 4.6287513195E+00, 7.3191461936E+00, 2.4770455289E+00, 9.2558089529E-01],
	[2.7535000000E+04, 1.9599155868E+01, 4.6287275386E+00, 7.3235027071E+00, 2.4776308068E+00, 9.2562218330E-01],
	[2.7540000000E+04, 1.9604993526E+01, 4.6287037621E+00, 7.3278610217E+00, 2.4782159303E+00, 9.2566344778E-01],
	[2.7545000000E+04, 1.9610831862E+01, 4.6286799901E+00, 7.3322211380E+00, 2.4788008993E+00, 9.2570468873E-01],
	[2.7550000000E+04, 1.9616670876E+01, 4.6286562225E+00, 7.3365830564E+00, 2.4793857139E+00, 9.2574590618E-01],
	[2.7555000000E+04, 1.9622510569E+01, 4.6286324594E+00, 7.3409467771E+00, 2.4799703741E+00, 9.2578710014E-01],
	[2.7560000000E+04, 1.9628350941E+01, 4.6286087006E+00, 7.3453123008E+00, 2.4805548798E+00, 9.2582827061E-01],
	[2.7565000000E+04, 1.9634191990E+01, 4.6285849464E+00, 7.3496796277E+00, 2.4811392311E+00, 9.2586941761E-01],
	[2.7570000000E+04, 1.9640033719E+01, 4.6285611965E+00, 7.3540487583E+00, 2.4817234278E+00, 9.2591054115E-01],
	[2.7575000000E+04, 1.9645876125E+01, 4.6285374511E+00, 7.3584196930E+00, 2.4823074701E+00, 9.2595164125E-01],
	[2.7580000000E+04, 1.9651719210E+01, 4.6285137101E+00, 7.3627924322E+00, 2.4828913578E+00, 9.2599271791E-01],
	[2.7585000000E+04, 1.9657562972E+01, 4.6284899735E+00, 7.3671669764E+00, 2.4834750910E+00, 9.2603377115E-01],
	[2.7590000000E+04, 1.9663407413E+01, 4.6284662414E+00, 7.3715433260E+00, 2.4840586697E+00, 9.2607480099E-01],
	[2.7595000000E+04, 1.9669252532E+01, 4.6284425137E+00, 7.3759214814E+00, 2.4846420938E+00, 9.2611580743E-01],
	[2.7600000000E+04, 1.9675098329E+01, 4.6284187904E+00, 7.3803014429E+00, 2.4852253634E+00, 9.2615679049E-01],
	[2.7605000000E+04, 1.9680944804E+01, 4.6283950715E+00, 7.3846832111E+00, 2.4858084783E+00, 9.2619775019E-01],
	[2.7610000000E+04, 1.9686791957E+01, 4.6283713570E+00, 7.3890667863E+00, 2.4863914387E+00, 9.2623868652E-01],
	[2.7615000000E+04, 1.9692651409E+01, 4.6283493623E+00, 7.3934521690E+00, 2.4869749251E+00, 9.2627959951E-01],
	[2.7620000000E+04, 1.9698522023E+01, 4.6283289180E+00, 7.3978393596E+00, 2.4875588710E+00, 9.2632048917E-01],
	[2.7625000000E+04, 1.9704393323E+01, 4.6283084775E+00, 7.4022283584E+00, 2.4881426631E+00, 9.2636135551E-01],
	[2.7630000000E+04, 1.9710265311E+01, 4.6282880407E+00, 7.4066191660E+00, 2.4887263014E+00, 9.2640219854E-01],
	[2.7635000000E+04, 1.9716137985E+01, 4.6282676078E+00, 7.4110117826E+00, 2.4893097857E+00, 9.2644301828E-01],
	[2.7640000000E+04, 1.9722011346E+01, 4.6282471787E+00, 7.4154062089E+00, 2.4898931162E+00, 9.2648381474E-01],
	[2.7645000000E+04, 1.9727885394E+01, 4.6282267533E+00, 7.4198024450E+00, 2.4904762927E+00, 9.2652458793E-01],
	[2.7650000000E+04, 1.9733760129E+01, 4.6282063317E+00, 7.4242004916E+00, 2.4910593153E+00, 9.2656533786E-01],
	[2.7655000000E+04, 1.9739635550E+01, 4.6281859139E+00, 7.4286003490E+00, 2.4916421840E+00, 9.2660606455E-01],
	[2.7660000000E+04, 1.9745511659E+01, 4.6281654999E+00, 7.4330020176E+00, 2.4922248987E+00, 9.2664676801E-01],
	[2.7665000000E+04, 1.9751388453E+01, 4.6281450897E+00, 7.4374054978E+00, 2.4928074595E+00, 9.2668744825E-01],
	[2.7670000000E+04, 1.9757265935E+01, 4.6281246832E+00, 7.4418107900E+00, 2.4933898663E+00, 9.2672810529E-01],
	[2.7675000000E+04, 1.9763144103E+01, 4.6281042805E+00, 7.4462178948E+00, 2.4939721191E+00, 9.2676873913E-01],
	[2.7680000000E+04, 1.9769022957E+01, 4.6280838816E+00, 7.4506268124E+00, 2.4945542179E+00, 9.2680934979E-01],
	[2.7685000000E+04, 1.9774902498E+01, 4.6280634865E+00, 7.4550375433E+00, 2.4951361627E+00, 9.2684993729E-01],
	[2.7690000000E+04, 1.9780782725E+01, 4.6280430951E+00, 7.4594500880E+00, 2.4957179535E+00, 9.2689050163E-01],
	[2.7695000000E+04, 1.9786663638E+01, 4.6280227075E+00, 7.4638644468E+00, 2.4962995903E+00, 9.2693104283E-01],
	[2.7700000000E+04, 1.9792545238E+01, 4.6280023237E+00, 7.4682806201E+00, 2.4968810729E+00, 9.2697156090E-01],
	[2.7705000000E+04, 1.9798427525E+01, 4.6279819437E+00, 7.4726986085E+00, 2.4974624016E+00, 9.2701205585E-01],
	[2.7710000000E+04, 1.9804310497E+01, 4.6279615674E+00, 7.4771184122E+00, 2.4980435761E+00, 9.2705252770E-01],
	[2.7715000000E+04, 1.9810194156E+01, 4.6279411949E+00, 7.4815400317E+00, 2.4986245966E+00, 9.2709297646E-01],
	[2.7720000000E+04, 1.9816078500E+01, 4.6279208261E+00, 7.4859634675E+00, 2.4992054630E+00, 9.2713340213E-01],
	[2.7725000000E+04, 1.9821963531E+01, 4.6279004611E+00, 7.4903887199E+00, 2.4997861752E+00, 9.2717380474E-01],
	[2.7730000000E+04, 1.9827849248E+01, 4.6278800999E+00, 7.4948157894E+00, 2.5003667333E+00, 9.2721418430E-01],
	[2.7735000000E+04, 1.9833735651E+01, 4.6278597425E+00, 7.4992446764E+00, 2.5009471373E+00, 9.2725454082E-01],
	[2.7740000000E+04, 1.9839622740E+01, 4.6278393888E+00, 7.5036753813E+00, 2.5015273872E+00, 9.2729487430E-01],
	[2.7745000000E+04, 1.9845510514E+01, 4.6278190388E+00, 7.5081079045E+00, 2.5021074829E+00, 9.2733518478E-01],
	[2.7750000000E+04, 1.9851398975E+01, 4.6277986926E+00, 7.5125422465E+00, 2.5026874244E+00, 9.2737547224E-01],
	[2.7755000000E+04, 1.9857288121E+01, 4.6277783502E+00, 7.5169784076E+00, 2.5032672118E+00, 9.2741573672E-01],
	[2.7760000000E+04, 1.9863177954E+01, 4.6277580115E+00, 7.5214163883E+00, 2.5038468449E+00, 9.2745597822E-01],
	[2.7765000000E+04, 1.9869068472E+01, 4.6277376766E+00, 7.5258561889E+00, 2.5044263239E+00, 9.2749619676E-01],
	[2.7770000000E+04, 1.9874959675E+01, 4.6277173454E+00, 7.5302978100E+00, 2.5050056486E+00, 9.2753639234E-01],
	[2.7775000000E+04, 1.9880851565E+01, 4.6276970180E+00, 7.5347412520E+00, 2.5055848191E+00, 9.2757656498E-01],
	[2.7780000000E+04, 1.9886744140E+01, 4.6276766943E+00, 7.5391865151E+00, 2.5061638354E+00, 9.2761671469E-01],
	[2.7785000000E+04, 1.9892637400E+01, 4.6276563744E+00, 7.5436336000E+00, 2.5067426974E+00, 9.2765684149E-01],
	[2.7790000000E+04, 1.9898531346E+01, 4.6276360582E+00, 7.5480825069E+00, 2.5073214052E+00, 9.2769694539E-01],
	[2.7795000000E+04, 1.9904425978E+01, 4.6276157457E+00, 7.5525332364E+00, 2.5078999587E+00, 9.2773702640E-01],
	[2.7800000000E+04, 1.9910321295E+01, 4.6275954370E+00, 7.5569857887E+00, 2.5084783579E+00, 9.2777708453E-01],
	[2.7805000000E+04, 1.9916217297E+01, 4.6275751321E+00, 7.5614401644E+00, 2.5090566028E+00, 9.2781711979E-01],
	[2.7810000000E+04, 1.9922113985E+01, 4.6275548308E+00, 7.5658963639E+00, 2.5096346934E+00, 9.2785713221E-01],
	[2.7815000000E+04, 1.9928011358E+01, 4.6275345334E+00, 7.5703543876E+00, 2.5102126297E+00, 9.2789712178E-01],
	[2.7820000000E+04, 1.9933909417E+01, 4.6275142396E+00, 7.5748142358E+00, 2.5107904117E+00, 9.2793708853E-01],
	[2.7825000000E+04, 1.9939808160E+01, 4.6274939496E+00, 7.5792759091E+00, 2.5113680393E+00, 9.2797703247E-01],
	[2.7830000000E+04, 1.9945707589E+01, 4.6274736633E+00, 7.5837394078E+00, 2.5119455126E+00, 9.2801695360E-01],
	[2.7835000000E+04, 1.9951607703E+01, 4.6274533808E+00, 7.5882047323E+00, 2.5125228315E+00, 9.2805685195E-01],
	[2.7840000000E+04, 1.9957508502E+01, 4.6274331020E+00, 7.5926718832E+00, 2.5130999961E+00, 9.2809672752E-01],
	[2.7845000000E+04, 1.9963409986E+01, 4.6274128269E+00, 7.5971408607E+00, 2.5136770063E+00, 9.2813658033E-01],
	[2.7850000000E+04, 1.9969312155E+01, 4.6273925556E+00, 7.6016116653E+00, 2.5142538621E+00, 9.2817641039E-01],
	[2.7855000000E+04, 1.9975215009E+01, 4.6273722879E+00, 7.6060842975E+00, 2.5148305635E+00, 9.2821621770E-01],
	[2.7860000000E+04, 1.9981118548E+01, 4.6273520241E+00, 7.6105587576E+00, 2.5154071105E+00, 9.2825600230E-01],
	[2.7865000000E+04, 1.9987022772E+01, 4.6273317639E+00, 7.6150350461E+00, 2.5159835031E+00, 9.2829576418E-01],
	[2.7870000000E+04, 1.9992927680E+01, 4.6273115074E+00, 7.6195131633E+00, 2.5165597413E+00, 9.2833550336E-01],
	[2.7875000000E+04, 1.9998833274E+01, 4.6272912547E+00, 7.6239931098E+00, 2.5171358250E+00, 9.2837521985E-01],
	[2.7880000000E+04, 2.0004739552E+01, 4.6272710057E+00, 7.6284748859E+00, 2.5177117543E+00, 9.2841491367E-01],
	[2.7885000000E+04, 2.0010646515E+01, 4.6272507604E+00, 7.6329584920E+00, 2.5182875291E+00, 9.2845458483E-01],
	[2.7890000000E+04, 2.0016554162E+01, 4.6272305189E+00, 7.6374439286E+00, 2.5188631495E+00, 9.2849423334E-01],
	[2.7895000000E+04, 2.0022462494E+01, 4.6272102810E+00, 7.6419311961E+00, 2.5194386154E+00, 9.2853385921E-01],
	[2.7900000000E+04, 2.0028371511E+01, 4.6271900469E+00, 7.6464202948E+00, 2.5200139268E+00, 9.2857346245E-01],
	[2.7905000000E+04, 2.0034281212E+01, 4.6271698165E+00, 7.6509112253E+00, 2.5205890837E+00, 9.2861304309E-01],
	[2.7910000000E+04, 2.0040191598E+01, 4.6271495898E+00, 7.6554039879E+00, 2.5211640861E+00, 9.2865260113E-01],
	[2.7915000000E+04, 2.0046102668E+01, 4.6271293668E+00, 7.6598985831E+00, 2.5217389340E+00, 9.2869213658E-01],
	[2.7920000000E+04, 2.0052014423E+01, 4.6271091475E+00, 7.6643950112E+00, 2.5223136274E+00, 9.2873164945E-01],
	[2.7925000000E+04, 2.0057926861E+01, 4.6270889319E+00, 7.6688932728E+00, 2.5228881662E+00, 9.2877113977E-01],
	[2.7930000000E+04, 2.0063839985E+01, 4.6270687201E+00, 7.6733933681E+00, 2.5234625505E+00, 9.2881060753E-01],
	[2.7935000000E+04, 2.0069753792E+01, 4.6270485119E+00, 7.6778952977E+00, 2.5240367803E+00, 9.2885005276E-01],
	[2.7940000000E+04, 2.0075668284E+01, 4.6270283075E+00, 7.6823990619E+00, 2.5246108555E+00, 9.2888947547E-01],
	[2.7945000000E+04, 2.0081583460E+01, 4.6270081067E+00, 7.6869046612E+00, 2.5251847761E+00, 9.2892887567E-01],
	[2.7950000000E+04, 2.0087499320E+01, 4.6269879097E+00, 7.6914120960E+00, 2.5257585422E+00, 9.2896825337E-01],
	[2.7955000000E+04, 2.0093415864E+01, 4.6269677163E+00, 7.6959213667E+00, 2.5263321537E+00, 9.2900760858E-01],
	[2.7960000000E+04, 2.0099333092E+01, 4.6269475267E+00, 7.7004324737E+00, 2.5269056106E+00, 9.2904694132E-01],
	[2.7965000000E+04, 2.0105251004E+01, 4.6269273407E+00, 7.7049454175E+00, 2.5274789129E+00, 9.2908625160E-01],
	[2.7970000000E+04, 2.0111169600E+01, 4.6269071585E+00, 7.7094601984E+00, 2.5280520605E+00, 9.2912553944E-01],
	[2.7975000000E+04, 2.0117088880E+01, 4.6268869799E+00, 7.7139768169E+00, 2.5286250536E+00, 9.2916480484E-01],
	[2.7980000000E+04, 2.0123008844E+01, 4.6268668050E+00, 7.7184952734E+00, 2.5291978920E+00, 9.2920404781E-01],
	[2.7985000000E+04, 2.0128929492E+01, 4.6268466339E+00, 7.7230155683E+00, 2.5297705758E+00, 9.2924326838E-01],
	[2.7990000000E+04, 2.0134850824E+01, 4.6268264664E+00, 7.7275377021E+00, 2.5303431050E+00, 9.2928246655E-01],
	[2.7995000000E+04, 2.0140772839E+01, 4.6268063026E+00, 7.7320616752E+00, 2.5309154795E+00, 9.2932164234E-01],
	[2.8000000000E+04, 2.0146695538E+01, 4.6267861425E+00, 7.7365874879E+00, 2.5314876994E+00, 9.2936079575E-01],
	[2.8005000000E+04, 2.0152618921E+01, 4.6267659861E+00, 7.7411151407E+00, 2.5320597646E+00, 9.2939992681E-01],
	[2.8010000000E+04, 2.0158542987E+01, 4.6267458334E+00, 7.7456446340E+00, 2.5326316751E+00, 9.2943903552E-01],
	[2.8015000000E+04, 2.0164467737E+01, 4.6267256843E+00, 7.7501759683E+00, 2.5332034309E+00, 9.2947812189E-01],
	[2.8020000000E+04, 2.0170393170E+01, 4.6267055390E+00, 7.7547091439E+00, 2.5337750321E+00, 9.2951718595E-01],
	[2.8025000000E+04, 2.0176319287E+01, 4.6266853973E+00, 7.7592441613E+00, 2.5343464785E+00, 9.2955622769E-01],
	[2.8030000000E+04, 2.0182246088E+01, 4.6266652593E+00, 7.7637810209E+00, 2.5349177703E+00, 9.2959524714E-01],
	[2.8035000000E+04, 2.0188173571E+01, 4.6266451250E+00, 7.7683197231E+00, 2.5354889073E+00, 9.2963424431E-01],
	[2.8040000000E+04, 2.0194101738E+01, 4.6266249944E+00, 7.7728602683E+00, 2.5360598896E+00, 9.2967321921E-01],
	[2.8045000000E+04, 2.0200030589E+01, 4.6266048674E+00, 7.7774026570E+00, 2.5366307172E+00, 9.2971217184E-01],
	[2.8050000000E+04, 2.0205960123E+01, 4.6265847441E+00, 7.7819468896E+00, 2.5372013901E+00, 9.2975110224E-01],
	[2.8055000000E+04, 2.0211890340E+01, 4.6265646245E+00, 7.7864929664E+00, 2.5377719082E+00, 9.2979001040E-01],
	[2.8060000000E+04, 2.0217834832E+01, 4.6265464913E+00, 7.7910408880E+00, 2.5383430826E+00, 9.2982889633E-01],
	[2.8065000000E+04, 2.0223788290E+01, 4.6265295686E+00, 7.7955906547E+00, 2.5389145968E+00, 9.2986776007E-01],
	[2.8070000000E+04, 2.0229742441E+01, 4.6265126489E+00, 7.8001422670E+00, 2.5394859569E+00, 9.2990660160E-01],
	[2.8075000000E+04, 2.0235697283E+01, 4.6264957322E+00, 7.8046957252E+00, 2.5400571630E+00, 9.2994542096E-01],
	[2.8080000000E+04, 2.0241652818E+01, 4.6264788187E+00, 7.8092510298E+00, 2.5406282151E+00, 9.2998421814E-01],
	[2.8085000000E+04, 2.0247609044E+01, 4.6264619082E+00, 7.8138081812E+00, 2.5411991131E+00, 9.3002299317E-01],
	[2.8090000000E+04, 2.0253565962E+01, 4.6264450008E+00, 7.8183671799E+00, 2.5417698571E+00, 9.3006174605E-01],
	[2.8095000000E+04, 2.0259523572E+01, 4.6264280964E+00, 7.8229280262E+00, 2.5423404470E+00, 9.3010047680E-01],
	[2.8100000000E+04, 2.0265481874E+01, 4.6264111952E+00, 7.8274907206E+00, 2.5429108829E+00, 9.3013918543E-01],
	[2.8105000000E+04, 2.0271440868E+01, 4.6263942970E+00, 7.8320552634E+00, 2.5434811647E+00, 9.3017787195E-01],
	[2.8110000000E+04, 2.0277400553E+01, 4.6263774018E+00, 7.8366216552E+00, 2.5440512925E+00, 9.3021653638E-01],
	[2.8115000000E+04, 2.0283360930E+01, 4.6263605098E+00, 7.8411898963E+00, 2.5446212661E+00, 9.3025517873E-01],
	[2.8120000000E+04, 2.0289321999E+01, 4.6263436208E+00, 7.8457599871E+00, 2.5451910857E+00, 9.3029379901E-01],
	[2.8125000000E+04, 2.0295283759E+01, 4.6263267348E+00, 7.8503319281E+00, 2.5457607512E+00, 9.3033239723E-01],
	[2.8130000000E+04, 2.0301246211E+01, 4.6263098520E+00, 7.8549057197E+00, 2.5463302626E+00, 9.3037097341E-01],
	[2.8135000000E+04, 2.0307209355E+01, 4.6262929722E+00, 7.8594813623E+00, 2.5468996198E+00, 9.3040952756E-01],
	[2.8140000000E+04, 2.0313173189E+01, 4.6262760954E+00, 7.8640588564E+00, 2.5474688230E+00, 9.3044805968E-01],
	[2.8145000000E+04, 2.0319137716E+01, 4.6262592217E+00, 7.8686382023E+00, 2.5480378721E+00, 9.3048656981E-01],
	[2.8150000000E+04, 2.0325102933E+01, 4.6262423511E+00, 7.8732194004E+00, 2.5486067670E+00, 9.3052505794E-01],
	[2.8155000000E+04, 2.0331068842E+01, 4.6262254835E+00, 7.8778024512E+00, 2.5491755078E+00, 9.3056352408E-01],
	[2.8160000000E+04, 2.0337035442E+01, 4.6262086190E+00, 7.8823873552E+00, 2.5497440944E+00, 9.3060196826E-01],
	[2.8165000000E+04, 2.0343002734E+01, 4.6261917576E+00, 7.8869741127E+00, 2.5503125269E+00, 9.3064039049E-01],
	[2.8170000000E+04, 2.0348970716E+01, 4.6261748991E+00, 7.8915627241E+00, 2.5508808053E+00, 9.3067879077E-01],
	[2.8175000000E+04, 2.0354939390E+01, 4.6261580438E+00, 7.8961531899E+00, 2.5514489295E+00, 9.3071716912E-01],
	[2.8180000000E+04, 2.0360908755E+01, 4.6261411915E+00, 7.9007455104E+00, 2.5520168996E+00, 9.3075552555E-01],
	[2.8185000000E+04, 2.0366878811E+01, 4.6261243422E+00, 7.9053396862E+00, 2.5525847154E+00, 9.3079386007E-01],
	[2.8190000000E+04, 2.0372849558E+01, 4.6261074960E+00, 7.9099357176E+00, 2.5531523771E+00, 9.3083217271E-01],
	[2.8195000000E+04, 2.0378820996E+01, 4.6260906529E+00, 7.9145336050E+00, 2.5537198847E+00, 9.3087046346E-01],
	[2.8200000000E+04, 2.0384793125E+01, 4.6260738128E+00, 7.9191333490E+00, 2.5542872380E+00, 9.3090873235E-01],
	[2.8205000000E+04, 2.0390765945E+01, 4.6260569757E+00, 7.9237349498E+00, 2.5548544372E+00, 9.3094697938E-01],
	[2.8210000000E+04, 2.0396739456E+01, 4.6260401417E+00, 7.9283384079E+00, 2.5554214821E+00, 9.3098520456E-01],
	[2.8215000000E+04, 2.0402713658E+01, 4.6260233108E+00, 7.9329437237E+00, 2.5559883729E+00, 9.3102340792E-01],
	[2.8220000000E+04, 2.0408688550E+01, 4.6260064829E+00, 7.9375508977E+00, 2.5565551095E+00, 9.3106158946E-01],
	[2.8225000000E+04, 2.0414664133E+01, 4.6259896580E+00, 7.9421599302E+00, 2.5571216918E+00, 9.3109974920E-01],
	[2.8230000000E+04, 2.0420640407E+01, 4.6259728361E+00, 7.9467708218E+00, 2.5576881199E+00, 9.3113788714E-01],
	[2.8235000000E+04, 2.0426617371E+01, 4.6259560173E+00, 7.9513835727E+00, 2.5582543938E+00, 9.3117600330E-01],
	[2.8240000000E+04, 2.0432595026E+01, 4.6259392016E+00, 7.9559981835E+00, 2.5588205135E+00, 9.3121409770E-01],
	[2.8245000000E+04, 2.0438573372E+01, 4.6259223889E+00, 7.9606146545E+00, 2.5593864790E+00, 9.3125217034E-01],
	[2.8250000000E+04, 2.0444552408E+01, 4.6259055792E+00, 7.9652329862E+00, 2.5599522902E+00, 9.3129022124E-01],
	[2.8255000000E+04, 2.0450532135E+01, 4.6258887725E+00, 7.9698531790E+00, 2.5605179472E+00, 9.3132825041E-01],
	[2.8260000000E+04, 2.0456512552E+01, 4.6258719689E+00, 7.9744752333E+00, 2.5610834499E+00, 9.3136625786E-01],
	[2.8265000000E+04, 2.0462493659E+01, 4.6258551684E+00, 7.9790991495E+00, 2.5616487984E+00, 9.3140424361E-01],
	[2.8270000000E+04, 2.0468475457E+01, 4.6258383708E+00, 7.9837249281E+00, 2.5622139926E+00, 9.3144220767E-01],
	[2.8275000000E+04, 2.0474457945E+01, 4.6258215763E+00, 7.9883525694E+00, 2.5627790325E+00, 9.3148015004E-01],
	[2.8280000000E+04, 2.0480441124E+01, 4.6258047848E+00, 7.9929820739E+00, 2.5633439182E+00, 9.3151807075E-01],
	[2.8285000000E+04, 2.0486424992E+01, 4.6257879964E+00, 7.9976134421E+00, 2.5639086497E+00, 9.3155596981E-01],
	[2.8290000000E+04, 2.0492409551E+01, 4.6257712109E+00, 8.0022466743E+00, 2.5644732268E+00, 9.3159384722E-01],
	[2.8295000000E+04, 2.0498394800E+01, 4.6257544285E+00, 8.0068817709E+00, 2.5650376497E+00, 9.3163170301E-01],
	[2.8300000000E+04, 2.0504380739E+01, 4.6257376492E+00, 8.0115187324E+00, 2.5656019183E+00, 9.3166953717E-01],
	[2.8305000000E+04, 2.0510367368E+01, 4.6257208728E+00, 8.0161575592E+00, 2.5661660326E+00, 9.3170734974E-01],
	[2.8310000000E+04, 2.0516354687E+01, 4.6257040995E+00, 8.0207982517E+00, 2.5667299926E+00, 9.3174514071E-01],
	[2.8315000000E+04, 2.0522342696E+01, 4.6256873292E+00, 8.0254408103E+00, 2.5672937983E+00, 9.3178291010E-01],
	[2.8320000000E+04, 2.0528331395E+01, 4.6256705619E+00, 8.0300852355E+00, 2.5678574498E+00, 9.3182065793E-01],
	[2.8325000000E+04, 2.0534320784E+01, 4.6256537977E+00, 8.0347315277E+00, 2.5684209469E+00, 9.3185838420E-01],
	[2.8330000000E+04, 2.0540310863E+01, 4.6256370364E+00, 8.0393796873E+00, 2.5689842897E+00, 9.3189608893E-01],
	[2.8335000000E+04, 2.0546301632E+01, 4.6256202782E+00, 8.0440297147E+00, 2.5695474782E+00, 9.3193377214E-01],
	[2.8340000000E+04, 2.0552293090E+01, 4.6256035230E+00, 8.0486816103E+00, 2.5701105124E+00, 9.3197143382E-01],
	[2.8345000000E+04, 2.0558285238E+01, 4.6255867708E+00, 8.0533353746E+00, 2.5706733923E+00, 9.3200907400E-01],
	[2.8350000000E+04, 2.0564278076E+01, 4.6255700217E+00, 8.0579910079E+00, 2.5712361179E+00, 9.3204669269E-01],
	[2.8355000000E+04, 2.0570271603E+01, 4.6255532755E+00, 8.0626485108E+00, 2.5717986891E+00, 9.3208428990E-01],
	[2.8360000000E+04, 2.0576265820E+01, 4.6255365324E+00, 8.0673078836E+00, 2.5723611060E+00, 9.3212186563E-01],
	[2.8365000000E+04, 2.0582260726E+01, 4.6255197923E+00, 8.0719691267E+00, 2.5729233686E+00, 9.3215941990E-01],
	[2.8370000000E+04, 2.0588256322E+01, 4.6255030551E+00, 8.0766322406E+00, 2.5734854768E+00, 9.3219695272E-01],
	[2.8375000000E+04, 2.0594252608E+01, 4.6254863210E+00, 8.0812972256E+00, 2.5740474307E+00, 9.3223446410E-01],
	[2.8380000000E+04, 2.0600249583E+01, 4.6254695899E+00, 8.0859640823E+00, 2.5746092303E+00, 9.3227195406E-01],
	[2.8385000000E+04, 2.0606247247E+01, 4.6254528618E+00, 8.0906328110E+00, 2.5751708755E+00, 9.3230942259E-01],
	[2.8390000000E+04, 2.0612245601E+01, 4.6254361368E+00, 8.0953034122E+00, 2.5757323664E+00, 9.3234686972E-01],
	[2.8395000000E+04, 2.0618244644E+01, 4.6254194147E+00, 8.0999758862E+00, 2.5762937029E+00, 9.3238429546E-01],
	[2.8400000000E+04, 2.0624244376E+01, 4.6254026956E+00, 8.1046502335E+00, 2.5768548850E+00, 9.3242169981E-01],
	[2.8405000000E+04, 2.0630244797E+01, 4.6253859795E+00, 8.1093264545E+00, 2.5774159128E+00, 9.3245908279E-01],
	[2.8410000000E+04, 2.0636245908E+01, 4.6253692665E+00, 8.1140045496E+00, 2.5779767863E+00, 9.3249644440E-01],
	[2.8415000000E+04, 2.0642247707E+01, 4.6253525564E+00, 8.1186845193E+00, 2.5785375054E+00, 9.3253378466E-01],
	[2.8420000000E+04, 2.0648250196E+01, 4.6253358493E+00, 8.1233663639E+00, 2.5790980701E+00, 9.3257110359E-01],
	[2.8425000000E+04, 2.0654253374E+01, 4.6253191453E+00, 8.1280500840E+00, 2.5796584805E+00, 9.3260840118E-01],
	[2.8430000000E+04, 2.0660257241E+01, 4.6253024442E+00, 8.1327356798E+00, 2.5802187365E+00, 9.3264567746E-01],
	[2.8435000000E+04, 2.0666261796E+01, 4.6252857461E+00, 8.1374231519E+00, 2.5807788381E+00, 9.3268293242E-01],
	[2.8440000000E+04, 2.0672267041E+01, 4.6252690511E+00, 8.1421125007E+00, 2.5813387853E+00, 9.3272016609E-01],
	[2.8445000000E+04, 2.0678272975E+01, 4.6252523590E+00, 8.1468037265E+00, 2.5818985782E+00, 9.3275737848E-01],
	[2.8450000000E+04, 2.0684279597E+01, 4.6252356699E+00, 8.1514968298E+00, 2.5824582167E+00, 9.3279456959E-01],
	[2.8455000000E+04, 2.0690286908E+01, 4.6252189838E+00, 8.1561918111E+00, 2.5830177008E+00, 9.3283173944E-01],
	[2.8460000000E+04, 2.0696294908E+01, 4.6252023007E+00, 8.1608886706E+00, 2.5835770305E+00, 9.3286888803E-01],
	[2.8465000000E+04, 2.0702303597E+01, 4.6251856206E+00, 8.1655874090E+00, 2.5841362058E+00, 9.3290601539E-01],
	[2.8470000000E+04, 2.0708312974E+01, 4.6251689435E+00, 8.1702880265E+00, 2.5846952268E+00, 9.3294312151E-01],
	[2.8475000000E+04, 2.0714323040E+01, 4.6251522694E+00, 8.1749905236E+00, 2.5852540933E+00, 9.3298020641E-01],
	[2.8480000000E+04, 2.0720333794E+01, 4.6251355982E+00, 8.1796949008E+00, 2.5858128055E+00, 9.3301727011E-01],
	[2.8485000000E+04, 2.0726345237E+01, 4.6251189301E+00, 8.1844011584E+00, 2.5863713633E+00, 9.3305431260E-01],
	[2.8490000000E+04, 2.0732357369E+01, 4.6251022649E+00, 8.1891092968E+00, 2.5869297666E+00, 9.3309133392E-01],
	[2.8495000000E+04, 2.0738370189E+01, 4.6250856027E+00, 8.1938193166E+00, 2.5874880156E+00, 9.3312833405E-01],
	[2.8500000000E+04, 2.0744383697E+01, 4.6250689435E+00, 8.1985312181E+00, 2.5880461102E+00, 9.3316531302E-01],
	[2.8505000000E+04, 2.0750397894E+01, 4.6250522873E+00, 8.2032450017E+00, 2.5886040504E+00, 9.3320227084E-01],
	[2.8510000000E+04, 2.0756418966E+01, 4.6250365264E+00, 8.2079606678E+00, 2.5891622121E+00, 9.3323920752E-01],
	[2.8515000000E+04, 2.0762456176E+01, 4.6250229957E+00, 8.2126782169E+00, 2.5897211582E+00, 9.3327612306E-01],
	[2.8520000000E+04, 2.0768494083E+01, 4.6250094674E+00, 8.2173976494E+00, 2.5902799507E+00, 9.3331301749E-01],
	[2.8525000000E+04, 2.0774532686E+01, 4.6249959415E+00, 8.2221189658E+00, 2.5908385895E+00, 9.3334989080E-01],
	[2.8530000000E+04, 2.0780571987E+01, 4.6249824180E+00, 8.2268421663E+00, 2.5913970746E+00, 9.3338674302E-01],
	[2.8535000000E+04, 2.0786611985E+01, 4.6249688970E+00, 8.2315672516E+00, 2.5919554060E+00, 9.3342357415E-01],
	[2.8540000000E+04, 2.0792652680E+01, 4.6249553783E+00, 8.2362942219E+00, 2.5925135837E+00, 9.3346038420E-01],
	[2.8545000000E+04, 2.0798694071E+01, 4.6249418621E+00, 8.2410230777E+00, 2.5930716077E+00, 9.3349717319E-01],
	[2.8550000000E+04, 2.0804736159E+01, 4.6249283482E+00, 8.2457538194E+00, 2.5936294780E+00, 9.3353394113E-01],
	[2.8555000000E+04, 2.0810778944E+01, 4.6249148368E+00, 8.2504864475E+00, 2.5941871946E+00, 9.3357068802E-01],
	[2.8560000000E+04, 2.0816822425E+01, 4.6249013278E+00, 8.2552209624E+00, 2.5947447575E+00, 9.3360741388E-01],
	[2.8565000000E+04, 2.0822866604E+01, 4.6248878211E+00, 8.2599573644E+00, 2.5953021666E+00, 9.3364411872E-01],
	[2.8570000000E+04, 2.0828911478E+01, 4.6248743169E+00, 8.2646956540E+00, 2.5958594221E+00, 9.3368080255E-01],
	[2.8575000000E+04, 2.0834957050E+01, 4.6248608151E+00, 8.2694358317E+00, 2.5964165239E+00, 9.3371746538E-01],
	[2.8580000000E+04, 2.0841003317E+01, 4.6248473157E+00, 8.2741778979E+00, 2.5969734720E+00, 9.3375410723E-01],
	[2.8585000000E+04, 2.0847050282E+01, 4.6248338187E+00, 8.2789218529E+00, 2.5975302663E+00, 9.3379072809E-01],
	[2.8590000000E+04, 2.0853097942E+01, 4.6248203240E+00, 8.2836676972E+00, 2.5980869070E+00, 9.3382732800E-01],
	[2.8595000000E+04, 2.0859146299E+01, 4.6248068318E+00, 8.2884154312E+00, 2.5986433939E+00, 9.3386390694E-01],
	[2.8600000000E+04, 2.0865195353E+01, 4.6247933420E+00, 8.2931650554E+00, 2.5991997272E+00, 9.3390046495E-01],
	[2.8605000000E+04, 2.0871245103E+01, 4.6247798546E+00, 8.2979165701E+00, 2.5997559067E+00, 9.3393700202E-01],
	[2.8610000000E+04, 2.0877295549E+01, 4.6247663696E+00, 8.3026699758E+00, 2.6003119325E+00, 9.3397351817E-01],
	[2.8615000000E+04, 2.0883346691E+01, 4.6247528869E+00, 8.3074252729E+00, 2.6008678046E+00, 9.3401001341E-01],
	[2.8620000000E+04, 2.0889398529E+01, 4.6247394067E+00, 8.3121824618E+00, 2.6014235229E+00, 9.3404648775E-01],
	[2.8625000000E+04, 2.0895451064E+01, 4.6247259289E+00, 8.3169415430E+00, 2.6019790876E+00, 9.3408294121E-01],
	[2.8630000000E+04, 2.0901504294E+01, 4.6247124534E+00, 8.3217025169E+00, 2.6025344985E+00, 9.3411937378E-01],
	[2.8635000000E+04, 2.0907558221E+01, 4.6246989803E+00, 8.3264653839E+00, 2.6030897558E+00, 9.3415578550E-01],
	[2.8640000000E+04, 2.0913612844E+01, 4.6246855097E+00, 8.3312301443E+00, 2.6036448593E+00, 9.3419217635E-01],
	[2.8645000000E+04, 2.0919668162E+01, 4.6246720414E+00, 8.3359967987E+00, 2.6041998091E+00, 9.3422854636E-01],
	[2.8650000000E+04, 2.0925724177E+01, 4.6246585755E+00, 8.3407653475E+00, 2.6047546052E+00, 9.3426489554E-01],
	[2.8655000000E+04, 2.0931780887E+01, 4.6246451120E+00, 8.3455357910E+00, 2.6053092475E+00, 9.3430122390E-01],
	[2.8660000000E+04, 2.0937838294E+01, 4.6246316509E+00, 8.3503081298E+00, 2.6058637362E+00, 9.3433753145E-01],
	[2.8665000000E+04, 2.0943896396E+01, 4.6246181922E+00, 8.3550823642E+00, 2.6064180711E+00, 9.3437381820E-01],
	[2.8670000000E+04, 2.0949955194E+01, 4.6246047359E+00, 8.3598584946E+00, 2.6069722524E+00, 9.3441008416E-01],
	[2.8675000000E+04, 2.0956014687E+01, 4.6245912819E+00, 8.3646365215E+00, 2.6075262799E+00, 9.3444632935E-01],
	[2.8680000000E+04, 2.0962074877E+01, 4.6245778304E+00, 8.3694164453E+00, 2.6080801537E+00, 9.3448255376E-01],
	[2.8685000000E+04, 2.0968135762E+01, 4.6245643812E+00, 8.3741982664E+00, 2.6086338737E+00, 9.3451875743E-01],
	[2.8690000000E+04, 2.0974197342E+01, 4.6245509344E+00, 8.3789819852E+00, 2.6091874401E+00, 9.3455494035E-01],
	[2.8695000000E+04, 2.0980259618E+01, 4.6245374900E+00, 8.3837676022E+00, 2.6097408527E+00, 9.3459110253E-01],
	[2.8700000000E+04, 2.0986322590E+01, 4.6245240480E+00, 8.3885551177E+00, 2.6102941117E+00, 9.3462724400E-01],
	[2.8705000000E+04, 2.0992386257E+01, 4.6245106083E+00, 8.3933445323E+00, 2.6108472169E+00, 9.3466336475E-01],
	[2.8710000000E+04, 2.0998450619E+01, 4.6244971710E+00, 8.3981358463E+00, 2.6114001684E+00, 9.3469946481E-01],
	[2.8715000000E+04, 2.1004515677E+01, 4.6244837362E+00, 8.4029290601E+00, 2.6119529662E+00, 9.3473554418E-01],
	[2.8720000000E+04, 2.1010581430E+01, 4.6244703036E+00, 8.4077241742E+00, 2.6125056102E+00, 9.3477160287E-01],
	[2.8725000000E+04, 2.1016647879E+01, 4.6244568735E+00, 8.4125211890E+00, 2.6130581006E+00, 9.3480764089E-01],
	[2.8730000000E+04, 2.1022715023E+01, 4.6244434458E+00, 8.4173201049E+00, 2.6136104373E+00, 9.3484365826E-01],
	[2.8735000000E+04, 2.1028782862E+01, 4.6244300204E+00, 8.4221209224E+00, 2.6141626202E+00, 9.3487965498E-01],
	[2.8740000000E+04, 2.1034851396E+01, 4.6244165974E+00, 8.4269236418E+00, 2.6147146494E+00, 9.3491563108E-01],
	[2.8745000000E+04, 2.1040920625E+01, 4.6244031767E+00, 8.4317282635E+00, 2.6152665250E+00, 9.3495158655E-01],
	[2.8750000000E+04, 2.1046990550E+01, 4.6243897585E+00, 8.4365347881E+00, 2.6158182468E+00, 9.3498752141E-01],
	[2.8755000000E+04, 2.1053061169E+01, 4.6243763426E+00, 8.4413432159E+00, 2.6163698149E+00, 9.3502343567E-01],
	[2.8760000000E+04, 2.1059132484E+01, 4.6243629291E+00, 8.4461535473E+00, 2.6169212293E+00, 9.3505932934E-01],
	[2.8765000000E+04, 2.1065204493E+01, 4.6243495179E+00, 8.4509657829E+00, 2.6174724900E+00, 9.3509520244E-01],
	[2.8770000000E+04, 2.1071277198E+01, 4.6243361091E+00, 8.4557799229E+00, 2.6180235970E+00, 9.3513105497E-01],
	[2.8775000000E+04, 2.1077350597E+01, 4.6243227027E+00, 8.4605959678E+00, 2.6185745503E+00, 9.3516688694E-01],
	[2.8780000000E+04, 2.1083424691E+01, 4.6243092987E+00, 8.4654139180E+00, 2.6191253499E+00, 9.3520269837E-01],
	[2.8785000000E+04, 2.1089499480E+01, 4.6242958970E+00, 8.4702337741E+00, 2.6196759959E+00, 9.3523848927E-01],
	[2.8790000000E+04, 2.1095574964E+01, 4.6242824977E+00, 8.4750555362E+00, 2.6202264881E+00, 9.3527425965E-01],
	[2.8795000000E+04, 2.1101651143E+01, 4.6242691008E+00, 8.4798792050E+00, 2.6207768266E+00, 9.3531000952E-01],
	[2.8800000000E+04, 2.1107728016E+01, 4.6242557062E+00, 8.4847047809E+00, 2.6213270114E+00, 9.3534573888E-01],
	[2.8805000000E+04, 2.1113805584E+01, 4.6242423140E+00, 8.4895322641E+00, 2.6218770425E+00, 9.3538144776E-01],
	[2.8810000000E+04, 2.1119883846E+01, 4.6242289241E+00, 8.4943616553E+00, 2.6224269200E+00, 9.3541713616E-01],
	[2.8815000000E+04, 2.1125962803E+01, 4.6242155367E+00, 8.4991929547E+00, 2.6229766437E+00, 9.3545280410E-01],
	[2.8820000000E+04, 2.1132042455E+01, 4.6242021515E+00, 8.5040261629E+00, 2.6235262138E+00, 9.3548845158E-01],
	[2.8825000000E+04, 2.1138122801E+01, 4.6241887688E+00, 8.5088612802E+00, 2.6240756302E+00, 9.3552407862E-01],
	[2.8830000000E+04, 2.1144203841E+01, 4.6241753884E+00, 8.5136983070E+00, 2.6246248929E+00, 9.3555968523E-01],
	[2.8835000000E+04, 2.1150285576E+01, 4.6241620103E+00, 8.5185372439E+00, 2.6251740019E+00, 9.3559527141E-01],
	[2.8840000000E+04, 2.1156368005E+01, 4.6241486346E+00, 8.5233780911E+00, 2.6257229573E+00, 9.3563083718E-01],
	[2.8845000000E+04, 2.1162451129E+01, 4.6241352613E+00, 8.5282208492E+00, 2.6262717589E+00, 9.3566638256E-01],
	[2.8850000000E+04, 2.1168534947E+01, 4.6241218903E+00, 8.5330655185E+00, 2.6268204069E+00, 9.3570190755E-01],
	[2.8855000000E+04, 2.1174619459E+01, 4.6241085217E+00, 8.5379120995E+00, 2.6273689012E+00, 9.3573741216E-01],
	[2.8860000000E+04, 2.1180704665E+01, 4.6240951555E+00, 8.5427605926E+00, 2.6279172419E+00, 9.3577289640E-01],
	[2.8865000000E+04, 2.1186790565E+01, 4.6240817916E+00, 8.5476109982E+00, 2.6284654289E+00, 9.3580836029E-01],
	[2.8870000000E+04, 2.1192877160E+01, 4.6240684300E+00, 8.5524633168E+00, 2.6290134622E+00, 9.3584380384E-01],
	[2.8875000000E+04, 2.1198964448E+01, 4.6240550708E+00, 8.5573175487E+00, 2.6295613419E+00, 9.3587922705E-01],
	[2.8880000000E+04, 2.1205052431E+01, 4.6240417140E+00, 8.5621736944E+00, 2.6301090679E+00, 9.3591462994E-01],
	[2.8885000000E+04, 2.1211141107E+01, 4.6240283595E+00, 8.5670317544E+00, 2.6306566402E+00, 9.3595001253E-01],
	[2.8890000000E+04, 2.1217230478E+01, 4.6240150073E+00, 8.5718917289E+00, 2.6312040589E+00, 9.3598537481E-01],
	[2.8895000000E+04, 2.1223320542E+01, 4.6240016575E+00, 8.5767536186E+00, 2.6317513239E+00, 9.3602071681E-01],
	[2.8900000000E+04, 2.1229411301E+01, 4.6239883101E+00, 8.5816174237E+00, 2.6322984353E+00, 9.3605603853E-01],
	[2.8905000000E+04, 2.1235502753E+01, 4.6239749650E+00, 8.5864831447E+00, 2.6328453931E+00, 9.3609133998E-01],
	[2.8910000000E+04, 2.1241594899E+01, 4.6239616222E+00, 8.5913507820E+00, 2.6333921972E+00, 9.3612662118E-01],
	[2.8915000000E+04, 2.1247687738E+01, 4.6239482818E+00, 8.5962203361E+00, 2.6339388476E+00, 9.3616188214E-01],
	[2.8920000000E+04, 2.1253781272E+01, 4.6239349437E+00, 8.6010918074E+00, 2.6344853445E+00, 9.3619712286E-01],
	[2.8925000000E+04, 2.1259875499E+01, 4.6239216080E+00, 8.6059651962E+00, 2.6350316877E+00, 9.3623234337E-01],
	[2.8930000000E+04, 2.1265970420E+01, 4.6239082746E+00, 8.6108405031E+00, 2.6355778772E+00, 9.3626754366E-01],
	[2.8935000000E+04, 2.1272066034E+01, 4.6238949436E+00, 8.6157177284E+00, 2.6361239132E+00, 9.3630272376E-01],
	[2.8940000000E+04, 2.1278162341E+01, 4.6238816149E+00, 8.6205968726E+00, 2.6366697955E+00, 9.3633788367E-01],
	[2.8945000000E+04, 2.1284259343E+01, 4.6238682885E+00, 8.6254779360E+00, 2.6372155242E+00, 9.3637302340E-01],
	[2.8950000000E+04, 2.1290357037E+01, 4.6238549645E+00, 8.6303609192E+00, 2.6377610992E+00, 9.3640814297E-01],
	[2.8955000000E+04, 2.1296455426E+01, 4.6238416429E+00, 8.6352458225E+00, 2.6383065207E+00, 9.3644324238E-01],
	[2.8960000000E+04, 2.1302554507E+01, 4.6238283235E+00, 8.6401326464E+00, 2.6388517885E+00, 9.3647832165E-01],
	[2.8965000000E+04, 2.1308654282E+01, 4.6238150065E+00, 8.6450213913E+00, 2.6393969028E+00, 9.3651338079E-01],
	[2.8970000000E+04, 2.1314765364E+01, 4.6238032059E+00, 8.6499120575E+00, 2.6399425198E+00, 9.3654841981E-01],
	[2.8975000000E+04, 2.1320887923E+01, 4.6237929445E+00, 8.6548046456E+00, 2.6404886501E+00, 9.3658343871E-01],
	[2.8980000000E+04, 2.1327011183E+01, 4.6237826849E+00, 8.6596991559E+00, 2.6410346276E+00, 9.3661843752E-01],
	[2.8985000000E+04, 2.1333135146E+01, 4.6237724271E+00, 8.6645955890E+00, 2.6415804521E+00, 9.3665341625E-01],
	[2.8990000000E+04, 2.1339259810E+01, 4.6237621710E+00, 8.6694939451E+00, 2.6421261237E+00, 9.3668837489E-01],
	[2.8995000000E+04, 2.1345385176E+01, 4.6237519168E+00, 8.6743942247E+00, 2.6426716425E+00, 9.3672331348E-01],
	[2.9000000000E+04, 2.1351511243E+01, 4.6237416644E+00, 8.6792964283E+00, 2.6432170083E+00, 9.3675823200E-01],
	[2.9005000000E+04, 2.1357638012E+01, 4.6237314137E+00, 8.6842005562E+00, 2.6437622212E+00, 9.3679313049E-01],
	[2.9010000000E+04, 2.1363765483E+01, 4.6237211649E+00, 8.6891066089E+00, 2.6443072812E+00, 9.3682800894E-01],
	[2.9015000000E+04, 2.1369893655E+01, 4.6237109178E+00, 8.6940145869E+00, 2.6448521884E+00, 9.3686286738E-01],
	[2.9020000000E+04, 2.1376022528E+01, 4.6237006725E+00, 8.6989244904E+00, 2.6453969426E+00, 9.3689770580E-01],
	[2.9025000000E+04, 2.1382152103E+01, 4.6236904290E+00, 8.7038363201E+00, 2.6459415440E+00, 9.3693252423E-01],
	[2.9030000000E+04, 2.1388282379E+01, 4.6236801873E+00, 8.7087500762E+00, 2.6464859925E+00, 9.3696732267E-01],
	[2.9035000000E+04, 2.1394413357E+01, 4.6236699474E+00, 8.7136657592E+00, 2.6470302881E+00, 9.3700210113E-01],
	[2.9040000000E+04, 2.1400545036E+01, 4.6236597093E+00, 8.7185833696E+00, 2.6475744309E+00, 9.3703685963E-01],
	[2.9045000000E+04, 2.1406677416E+01, 4.6236494729E+00, 8.7235029077E+00, 2.6481184208E+00, 9.3707159818E-01],
	[2.9050000000E+04, 2.1412810497E+01, 4.6236392384E+00, 8.7284243740E+00, 2.6486622578E+00, 9.3710631679E-01],
	[2.9055000000E+04, 2.1418944280E+01, 4.6236290056E+00, 8.7333477689E+00, 2.6492059420E+00, 9.3714101546E-01],
	[2.9060000000E+04, 2.1425078764E+01, 4.6236187746E+00, 8.7382730928E+00, 2.6497494733E+00, 9.3717569421E-01],
	[2.9065000000E+04, 2.1431213948E+01, 4.6236085454E+00, 8.7432003462E+00, 2.6502928518E+00, 9.3721035306E-01],
	[2.9070000000E+04, 2.1437349834E+01, 4.6235983179E+00, 8.7481295295E+00, 2.6508360774E+00, 9.3724499200E-01],
	[2.9075000000E+04, 2.1443486421E+01, 4.6235880923E+00, 8.7530606430E+00, 2.6513791502E+00, 9.3727961106E-01],
	[2.9080000000E+04, 2.1449623709E+01, 4.6235778684E+00, 8.7579936873E+00, 2.6519220701E+00, 9.3731421025E-01],
	[2.9085000000E+04, 2.1455761698E+01, 4.6235676463E+00, 8.7629286627E+00, 2.6524648372E+00, 9.3734878957E-01],
	[2.9090000000E+04, 2.1461900387E+01, 4.6235574260E+00, 8.7678655697E+00, 2.6530074515E+00, 9.3738334904E-01],
	[2.9095000000E+04, 2.1468039778E+01, 4.6235472075E+00, 8.7728044086E+00, 2.6535499130E+00, 9.3741788866E-01],
	[2.9100000000E+04, 2.1474179869E+01, 4.6235369907E+00, 8.7777451800E+00, 2.6540922216E+00, 9.3745240846E-01],
	[2.9105000000E+04, 2.1480320661E+01, 4.6235267758E+00, 8.7826878842E+00, 2.6546343775E+00, 9.3748690843E-01],
	[2.9110000000E+04, 2.1486462154E+01, 4.6235165626E+00, 8.7876325217E+00, 2.6551763805E+00, 9.3752138860E-01],
	[2.9115000000E+04, 2.1492604348E+01, 4.6235063512E+00, 8.7925790929E+00, 2.6557182307E+00, 9.3755584897E-01],
	[2.9120000000E+04, 2.1498747242E+01, 4.6234961415E+00, 8.7975275982E+00, 2.6562599281E+00, 9.3759028955E-01],
	[2.9125000000E+04, 2.1504890837E+01, 4.6234859336E+00, 8.8024780380E+00, 2.6568014728E+00, 9.3762471036E-01],
	[2.9130000000E+04, 2.1511035132E+01, 4.6234757276E+00, 8.8074304127E+00, 2.6573428646E+00, 9.3765911140E-01],
	[2.9135000000E+04, 2.1517180128E+01, 4.6234655232E+00, 8.8123847229E+00, 2.6578841037E+00, 9.3769349269E-01],
	[2.9140000000E+04, 2.1523325824E+01, 4.6234553207E+00, 8.8173409688E+00, 2.6584251899E+00, 9.3772785424E-01],
	[2.9145000000E+04, 2.1529472221E+01, 4.6234451199E+00, 8.8222991510E+00, 2.6589661235E+00, 9.3776219606E-01],
	[2.9150000000E+04, 2.1535619319E+01, 4.6234349209E+00, 8.8272592699E+00, 2.6595069042E+00, 9.3779651816E-01],
	[2.9155000000E+04, 2.1541767116E+01, 4.6234247237E+00, 8.8322213258E+00, 2.6600475322E+00, 9.3783082055E-01],
	[2.9160000000E+04, 2.1547915614E+01, 4.6234145282E+00, 8.8371853192E+00, 2.6605880074E+00, 9.3786510325E-01],
	[2.9165000000E+04, 2.1554064812E+01, 4.6234043346E+00, 8.8421512505E+00, 2.6611283299E+00, 9.3789936626E-01],
	[2.9170000000E+04, 2.1560214711E+01, 4.6233941426E+00, 8.8471191202E+00, 2.6616684996E+00, 9.3793360959E-01],
	[2.9175000000E+04, 2.1566365309E+01, 4.6233839525E+00, 8.8520889287E+00, 2.6622085166E+00, 9.3796783326E-01],
	[2.9180000000E+04, 2.1572516608E+01, 4.6233737641E+00, 8.8570606764E+00, 2.6627483808E+00, 9.3800203728E-01],
	[2.9185000000E+04, 2.1578668607E+01, 4.6233635775E+00, 8.8620343637E+00, 2.6632880923E+00, 9.3803622165E-01],
	[2.9190000000E+04, 2.1584821306E+01, 4.6233533927E+00, 8.8670099910E+00, 2.6638276511E+00, 9.3807038640E-01],
	[2.9195000000E+04, 2.1590974705E+01, 4.6233432096E+00, 8.8719875588E+00, 2.6643670572E+00, 9.3810453152E-01],
	[2.9200000000E+04, 2.1597128805E+01, 4.6233330283E+00, 8.8769670675E+00, 2.6649063105E+00, 9.3813865704E-01],
	[2.9205000000E+04, 2.1603283604E+01, 4.6233228487E+00, 8.8819485175E+00, 2.6654454112E+00, 9.3817276296E-01],
	[2.9210000000E+04, 2.1609439103E+01, 4.6233126710E+00, 8.8869319093E+00, 2.6659843591E+00, 9.3820684930E-01],
	[2.9215000000E+04, 2.1615595302E+01, 4.6233024949E+00, 8.8919172432E+00, 2.6665231544E+00, 9.3824091606E-01],
	[2.9220000000E+04, 2.1621752200E+01, 4.6232923207E+00, 8.8969045197E+00, 2.6670617970E+00, 9.3827496326E-01],
	[2.9225000000E+04, 2.1627909799E+01, 4.6232821482E+00, 8.9018937392E+00, 2.6676002869E+00, 9.3830899090E-01],
	[2.9230000000E+04, 2.1634068097E+01, 4.6232719775E+00, 8.9068849022E+00, 2.6681386241E+00, 9.3834299901E-01],
	[2.9235000000E+04, 2.1640227095E+01, 4.6232618085E+00, 8.9118780090E+00, 2.6686768086E+00, 9.3837698758E-01],
	[2.9240000000E+04, 2.1646386793E+01, 4.6232516413E+00, 8.9168730601E+00, 2.6692148405E+00, 9.3841095663E-01],
	[2.9245000000E+04, 2.1652547190E+01, 4.6232414759E+00, 8.9218700560E+00, 2.6697527197E+00, 9.3844490618E-01],
	[2.9250000000E+04, 2.1658708287E+01, 4.6232313122E+00, 8.9268689969E+00, 2.6702904462E+00, 9.3847883623E-01],
	[2.9255000000E+04, 2.1664870084E+01, 4.6232211503E+00, 8.9318698835E+00, 2.6708280202E+00, 9.3851274680E-01],
	[2.9260000000E+04, 2.1671032580E+01, 4.6232109901E+00, 8.9368727160E+00, 2.6713654414E+00, 9.3854663789E-01],
	[2.9265000000E+04, 2.1677195775E+01, 4.6232008317E+00, 8.9418774949E+00, 2.6719027101E+00, 9.3858050951E-01],
	[2.9270000000E+04, 2.1683359670E+01, 4.6231906751E+00, 8.9468842207E+00, 2.6724398261E+00, 9.3861436169E-01],
	[2.9275000000E+04, 2.1689524265E+01, 4.6231805202E+00, 8.9518928937E+00, 2.6729767895E+00, 9.3864819442E-01],
	[2.9280000000E+04, 2.1695689558E+01, 4.6231703670E+00, 8.9569035144E+00, 2.6735136003E+00, 9.3868200772E-01],
	[2.9285000000E+04, 2.1701855551E+01, 4.6231602157E+00, 8.9619160832E+00, 2.6740502584E+00, 9.3871580161E-01],
	[2.9290000000E+04, 2.1708022244E+01, 4.6231500660E+00, 8.9669306005E+00, 2.6745867640E+00, 9.3874957608E-01],
	[2.9295000000E+04, 2.1714189635E+01, 4.6231399182E+00, 8.9719470668E+00, 2.6751231170E+00, 9.3878333116E-01],
	[2.9300000000E+04, 2.1720357726E+01, 4.6231297721E+00, 8.9769654825E+00, 2.6756593174E+00, 9.3881706686E-01],
	[2.9305000000E+04, 2.1726526516E+01, 4.6231196277E+00, 8.9819858480E+00, 2.6761953652E+00, 9.3885078318E-01],
	[2.9310000000E+04, 2.1732696005E+01, 4.6231094851E+00, 8.9870081637E+00, 2.6767312604E+00, 9.3888448013E-01],
	[2.9315000000E+04, 2.1738866193E+01, 4.6230993442E+00, 8.9920324301E+00, 2.6772670031E+00, 9.3891815774E-01],
	[2.9320000000E+04, 2.1745037080E+01, 4.6230892051E+00, 8.9970586475E+00, 2.6778025932E+00, 9.3895181600E-01],
	[2.9325000000E+04, 2.1751208666E+01, 4.6230790678E+00, 9.0020868165E+00, 2.6783380308E+00, 9.3898545494E-01],
	[2.9330000000E+04, 2.1757380952E+01, 4.6230689322E+00, 9.0071169373E+00, 2.6788733158E+00, 9.3901907455E-01],
	[2.9335000000E+04, 2.1763553936E+01, 4.6230587983E+00, 9.0121490106E+00, 2.6794084483E+00, 9.3905267486E-01],
	[2.9340000000E+04, 2.1769727619E+01, 4.6230486662E+00, 9.0171830366E+00, 2.6799434283E+00, 9.3908625587E-01],
	[2.9345000000E+04, 2.1775902000E+01, 4.6230385359E+00, 9.0222190158E+00, 2.6804782557E+00, 9.3911981759E-01],
	[2.9350000000E+04, 2.1782077081E+01, 4.6230284073E+00, 9.0272569486E+00, 2.6810129306E+00, 9.3915336004E-01],
	[2.9355000000E+04, 2.1788252860E+01, 4.6230182804E+00, 9.0322968355E+00, 2.6815474530E+00, 9.3918688323E-01],
	[2.9360000000E+04, 2.1794429339E+01, 4.6230081553E+00, 9.0373386769E+00, 2.6820818229E+00, 9.3922038716E-01],
	[2.9365000000E+04, 2.1800606515E+01, 4.6229980320E+00, 9.0423824732E+00, 2.6826160404E+00, 9.3925387186E-01],
	[2.9370000000E+04, 2.1806784391E+01, 4.6229879103E+00, 9.0474282248E+00, 2.6831501053E+00, 9.3928733732E-01],
	[2.9375000000E+04, 2.1812962965E+01, 4.6229777905E+00, 9.0524759321E+00, 2.6836840177E+00, 9.3932078356E-01],
	[2.9380000000E+04, 2.1819142237E+01, 4.6229676723E+00, 9.0575255956E+00, 2.6842177777E+00, 9.3935421060E-01],
	[2.9385000000E+04, 2.1825322208E+01, 4.6229575560E+00, 9.0625772158E+00, 2.6847513852E+00, 9.3938761844E-01],
	[2.9390000000E+04, 2.1831502878E+01, 4.6229474413E+00, 9.0676307929E+00, 2.6852848403E+00, 9.3942100710E-01],
	[2.9395000000E+04, 2.1837684246E+01, 4.6229373284E+00, 9.0726863275E+00, 2.6858181429E+00, 9.3945437658E-01],
	[2.9400000000E+04, 2.1843866312E+01, 4.6229272173E+00, 9.0777438200E+00, 2.6863512931E+00, 9.3948772689E-01],
	[2.9405000000E+04, 2.1850049077E+01, 4.6229171079E+00, 9.0828032708E+00, 2.6868842909E+00, 9.3952105806E-01],
	[2.9410000000E+04, 2.1856232540E+01, 4.6229070002E+00, 9.0878646803E+00, 2.6874171362E+00, 9.3955437008E-01],
	[2.9415000000E+04, 2.1862416702E+01, 4.6228968942E+00, 9.0929280490E+00, 2.6879498291E+00, 9.3958766297E-01],
	[2.9420000000E+04, 2.1868601561E+01, 4.6228867901E+00, 9.0979933772E+00, 2.6884823696E+00, 9.3962093674E-01],
	[2.9425000000E+04, 2.1874787119E+01, 4.6228766876E+00, 9.1030606654E+00, 2.6890147577E+00, 9.3965419141E-01],
	[2.9430000000E+04, 2.1880973375E+01, 4.6228665869E+00, 9.1081299141E+00, 2.6895469934E+00, 9.3968742698E-01],
	[2.9435000000E+04, 2.1887165164E+01, 4.6228571703E+00, 9.1132011236E+00, 2.6900793808E+00, 9.3972064346E-01],
	[2.9440000000E+04, 2.1893373965E+01, 4.6228500572E+00, 9.1182742944E+00, 2.6906126422E+00, 9.3975384087E-01],
	[2.9445000000E+04, 2.1899583472E+01, 4.6228429453E+00, 9.1233494269E+00, 2.6911457518E+00, 9.3978701921E-01],
	[2.9450000000E+04, 2.1905793686E+01, 4.6228358347E+00, 9.1284265215E+00, 2.6916787097E+00, 9.3982017850E-01],
	[2.9455000000E+04, 2.1912004606E+01, 4.6228287252E+00, 9.1335055787E+00, 2.6922115159E+00, 9.3985331875E-01],
	[2.9460000000E+04, 2.1918216233E+01, 4.6228216170E+00, 9.1385865988E+00, 2.6927441705E+00, 9.3988643997E-01],
	[2.9465000000E+04, 2.1924428565E+01, 4.6228145100E+00, 9.1436695824E+00, 2.6932766733E+00, 9.3991954217E-01],
	[2.9470000000E+04, 2.1930641604E+01, 4.6228074042E+00, 9.1487545298E+00, 2.6938090245E+00, 9.3995262536E-01],
	[2.9475000000E+04, 2.1936855350E+01, 4.6228002996E+00, 9.1538414414E+00, 2.6943412239E+00, 9.3998568956E-01],
	[2.9480000000E+04, 2.1943069801E+01, 4.6227931962E+00, 9.1589303177E+00, 2.6948732718E+00, 9.4001873477E-01],
	[2.9485000000E+04, 2.1949284958E+01, 4.6227860941E+00, 9.1640211591E+00, 2.6954051680E+00, 9.4005176100E-01],
	[2.9490000000E+04, 2.1955500822E+01, 4.6227789931E+00, 9.1691139661E+00, 2.6959369125E+00, 9.4008476827E-01],
	[2.9495000000E+04, 2.1961717391E+01, 4.6227718934E+00, 9.1742087390E+00, 2.6964685054E+00, 9.4011775658E-01],
	[2.9500000000E+04, 2.1967934667E+01, 4.6227647949E+00, 9.1793054782E+00, 2.6969999467E+00, 9.4015072596E-01],
	[2.9505000000E+04, 2.1974152648E+01, 4.6227576976E+00, 9.1844041843E+00, 2.6975312364E+00, 9.4018367640E-01],
	[2.9510000000E+04, 2.1980371336E+01, 4.6227506016E+00, 9.1895048576E+00, 2.6980623744E+00, 9.4021660792E-01],
	[2.9515000000E+04, 2.1986590729E+01, 4.6227435067E+00, 9.1946074986E+00, 2.6985933609E+00, 9.4024952054E-01],
	[2.9520000000E+04, 2.1992810828E+01, 4.6227364130E+00, 9.1997121076E+00, 2.6991241958E+00, 9.4028241426E-01],
	[2.9525000000E+04, 2.1999031633E+01, 4.6227293206E+00, 9.2048186852E+00, 2.6996548790E+00, 9.4031528909E-01],
	[2.9530000000E+04, 2.2005253144E+01, 4.6227222294E+00, 9.2099272316E+00, 2.7001854107E+00, 9.4034814504E-01],
	[2.9535000000E+04, 2.2011475360E+01, 4.6227151394E+00, 9.2150377475E+00, 2.7007157909E+00, 9.4038098213E-01],
	[2.9540000000E+04, 2.2017698282E+01, 4.6227080506E+00, 9.2201502331E+00, 2.7012460195E+00, 9.4041380037E-01],
	[2.9545000000E+04, 2.2023921910E+01, 4.6227009630E+00, 9.2252646889E+00, 2.7017760965E+00, 9.4044659976E-01],
	[2.9550000000E+04, 2.2030146243E+01, 4.6226938766E+00, 9.2303811154E+00, 2.7023060220E+00, 9.4047938032E-01],
	[2.9555000000E+04, 2.2036371282E+01, 4.6226867914E+00, 9.2354995129E+00, 2.7028357960E+00, 9.4051214206E-01],
	[2.9560000000E+04, 2.2042597026E+01, 4.6226797074E+00, 9.2406198819E+00, 2.7033654185E+00, 9.4054488500E-01],
	[2.9565000000E+04, 2.2048823476E+01, 4.6226726247E+00, 9.2457422228E+00, 2.7038948894E+00, 9.4057760913E-01],
	[2.9570000000E+04, 2.2055050631E+01, 4.6226655431E+00, 9.2508665361E+00, 2.7044242088E+00, 9.4061031448E-01],
	[2.9575000000E+04, 2.2061278492E+01, 4.6226584628E+00, 9.2559928221E+00, 2.7049533768E+00, 9.4064300105E-01],
	[2.9580000000E+04, 2.2067507058E+01, 4.6226513837E+00, 9.2611210813E+00, 2.7054823933E+00, 9.4067566886E-01],
	[2.9585000000E+04, 2.2073736329E+01, 4.6226443058E+00, 9.2662513141E+00, 2.7060112583E+00, 9.4070831791E-01],
	[2.9590000000E+04, 2.2079966306E+01, 4.6226372290E+00, 9.2713835210E+00, 2.7065399718E+00, 9.4074094822E-01],
	[2.9595000000E+04, 2.2086196988E+01, 4.6226301535E+00, 9.2765177023E+00, 2.7070685339E+00, 9.4077355979E-01],
	[2.9600000000E+04, 2.2092428375E+01, 4.6226230792E+00, 9.2816538585E+00, 2.7075969445E+00, 9.4080615265E-01],
	[2.9605000000E+04, 2.2098660467E+01, 4.6226160061E+00, 9.2867919900E+00, 2.7081252037E+00, 9.4083872679E-01],
	[2.9610000000E+04, 2.2104893265E+01, 4.6226089342E+00, 9.2919320973E+00, 2.7086533115E+00, 9.4087128224E-01],
	[2.9615000000E+04, 2.2111126767E+01, 4.6226018635E+00, 9.2970741807E+00, 2.7091812678E+00, 9.4090381900E-01],
	[2.9620000000E+04, 2.2117360975E+01, 4.6225947941E+00, 9.3022182407E+00, 2.7097090727E+00, 9.4093633708E-01],
	[2.9625000000E+04, 2.2123595887E+01, 4.6225877258E+00, 9.3073642778E+00, 2.7102367263E+00, 9.4096883649E-01],
	[2.9630000000E+04, 2.2129831504E+01, 4.6225806587E+00, 9.3125122923E+00, 2.7107642285E+00, 9.4100131725E-01],
	[2.9635000000E+04, 2.2136067827E+01, 4.6225735928E+00, 9.3176622846E+00, 2.7112915792E+00, 9.4103377937E-01],
	[2.9640000000E+04, 2.2142304854E+01, 4.6225665282E+00, 9.3228142553E+00, 2.7118187786E+00, 9.4106622285E-01],
	[2.9645000000E+04, 2.2148542586E+01, 4.6225594647E+00, 9.3279682047E+00, 2.7123458267E+00, 9.4109864771E-01],
	[2.9650000000E+04, 2.2154781023E+01, 4.6225524024E+00, 9.3331241332E+00, 2.7128727234E+00, 9.4113105396E-01],
	[2.9655000000E+04, 2.2161020165E+01, 4.6225453414E+00, 9.3382820413E+00, 2.7133994688E+00, 9.4116344161E-01],
	[2.9660000000E+04, 2.2167260011E+01, 4.6225382815E+00, 9.3434419294E+00, 2.7139260628E+00, 9.4119581067E-01],
	[2.9665000000E+04, 2.2173500563E+01, 4.6225312228E+00, 9.3486037979E+00, 2.7144525055E+00, 9.4122816116E-01],
	[2.9670000000E+04, 2.2179741818E+01, 4.6225241654E+00, 9.3537676473E+00, 2.7149787969E+00, 9.4126049307E-01],
	[2.9675000000E+04, 2.2185983779E+01, 4.6225171091E+00, 9.3589334780E+00, 2.7155049371E+00, 9.4129280643E-01],
	[2.9680000000E+04, 2.2192226444E+01, 4.6225100541E+00, 9.3641012904E+00, 2.7160309259E+00, 9.4132510125E-01],
	[2.9685000000E+04, 2.2198469813E+01, 4.6225030002E+00, 9.3692710849E+00, 2.7165567634E+00, 9.4135737753E-01],
	[2.9690000000E+04, 2.2204713887E+01, 4.6224959475E+00, 9.3744428619E+00, 2.7170824497E+00, 9.4138963529E-01],
	[2.9695000000E+04, 2.2210958666E+01, 4.6224888961E+00, 9.3796166219E+00, 2.7176079848E+00, 9.4142187453E-01],
	[2.9700000000E+04, 2.2217204149E+01, 4.6224818458E+00, 9.3847923654E+00, 2.7181333685E+00, 9.4145409528E-01],
	[2.9705000000E+04, 2.2223450336E+01, 4.6224747967E+00, 9.3899700927E+00, 2.7186586011E+00, 9.4148629754E-01],
	[2.9710000000E+04, 2.2229697228E+01, 4.6224677489E+00, 9.3951498042E+00, 2.7191836824E+00, 9.4151848131E-01],
	[2.9715000000E+04, 2.2235944824E+01, 4.6224607022E+00, 9.4003315004E+00, 2.7197086125E+00, 9.4155064662E-01],
	[2.9720000000E+04, 2.2242193124E+01, 4.6224536567E+00, 9.4055151818E+00, 2.7202333914E+00, 9.4158279347E-01],
	[2.9725000000E+04, 2.2248442128E+01, 4.6224466124E+00, 9.4107008487E+00, 2.7207580191E+00, 9.4161492187E-01],
	[2.9730000000E+04, 2.2254691837E+01, 4.6224395693E+00, 9.4158885015E+00, 2.7212824957E+00, 9.4164703184E-01],
	[2.9735000000E+04, 2.2260942250E+01, 4.6224325274E+00, 9.4210781408E+00, 2.7218068210E+00, 9.4167912338E-01],
	[2.9740000000E+04, 2.2267193366E+01, 4.6224254867E+00, 9.4262697668E+00, 2.7223309952E+00, 9.4171119651E-01],
	[2.9745000000E+04, 2.2273445187E+01, 4.6224184472E+00, 9.4314633801E+00, 2.7228550183E+00, 9.4174325123E-01],
	[2.9750000000E+04, 2.2279697712E+01, 4.6224114089E+00, 9.4366589811E+00, 2.7233788902E+00, 9.4177528755E-01],
	[2.9755000000E+04, 2.2285950941E+01, 4.6224043718E+00, 9.4418565702E+00, 2.7239026110E+00, 9.4180730548E-01],
	[2.9760000000E+04, 2.2292204874E+01, 4.6223973359E+00, 9.4470561478E+00, 2.7244261806E+00, 9.4183930504E-01],
	[2.9765000000E+04, 2.2298459511E+01, 4.6223903012E+00, 9.4522577143E+00, 2.7249495992E+00, 9.4187128622E-01],
	[2.9770000000E+04, 2.2304714852E+01, 4.6223832676E+00, 9.4574612702E+00, 2.7254728666E+00, 9.4190324905E-01],
	[2.9775000000E+04, 2.2310970896E+01, 4.6223762353E+00, 9.4626668160E+00, 2.7259959830E+00, 9.4193519353E-01],
	[2.9780000000E+04, 2.2317227644E+01, 4.6223692041E+00, 9.4678743519E+00, 2.7265189483E+00, 9.4196711967E-01],
	[2.9785000000E+04, 2.2323485096E+01, 4.6223621742E+00, 9.4730838785E+00, 2.7270417626E+00, 9.4199902748E-01],
	[2.9790000000E+04, 2.2329743252E+01, 4.6223551454E+00, 9.4782953962E+00, 2.7275644258E+00, 9.4203091697E-01],
	[2.9795000000E+04, 2.2336002112E+01, 4.6223481178E+00, 9.4835089055E+00, 2.7280869379E+00, 9.4206278815E-01],
	[2.9800000000E+04, 2.2342261675E+01, 4.6223410914E+00, 9.4887244066E+00, 2.7286092990E+00, 9.4209464103E-01],
	[2.9805000000E+04, 2.2348521941E+01, 4.6223340662E+00, 9.4939419001E+00, 2.7291315092E+00, 9.4212647562E-01],
	[2.9810000000E+04, 2.2354782912E+01, 4.6223270422E+00, 9.4991613864E+00, 2.7296535683E+00, 9.4215829193E-01],
	[2.9815000000E+04, 2.2361044585E+01, 4.6223200194E+00, 9.5043828659E+00, 2.7301754764E+00, 9.4219008997E-01],
	[2.9820000000E+04, 2.2367306963E+01, 4.6223129977E+00, 9.5096063391E+00, 2.7306972335E+00, 9.4222186975E-01],
	[2.9825000000E+04, 2.2373570043E+01, 4.6223059773E+00, 9.5148318063E+00, 2.7312188397E+00, 9.4225363127E-01],
	[2.9830000000E+04, 2.2379833827E+01, 4.6222989580E+00, 9.5200592680E+00, 2.7317402949E+00, 9.4228537456E-01],
	[2.9835000000E+04, 2.2386098315E+01, 4.6222919399E+00, 9.5252887246E+00, 2.7322615991E+00, 9.4231709961E-01],
	[2.9840000000E+04, 2.2392363505E+01, 4.6222849231E+00, 9.5305201766E+00, 2.7327827525E+00, 9.4234880644E-01],
	[2.9845000000E+04, 2.2398629400E+01, 4.6222779074E+00, 9.5357536244E+00, 2.7333037549E+00, 9.4238049505E-01],
	[2.9850000000E+04, 2.2404895997E+01, 4.6222708928E+00, 9.5409890683E+00, 2.7338246063E+00, 9.4241216547E-01],
	[2.9855000000E+04, 2.2411163297E+01, 4.6222638795E+00, 9.5462265089E+00, 2.7343453069E+00, 9.4244381769E-01],
	[2.9860000000E+04, 2.2417431301E+01, 4.6222568674E+00, 9.5514659466E+00, 2.7348658566E+00, 9.4247545173E-01],
	[2.9865000000E+04, 2.2423700008E+01, 4.6222498564E+00, 9.5567073817E+00, 2.7353862555E+00, 9.4250706759E-01],
	[2.9870000000E+04, 2.2429969418E+01, 4.6222428466E+00, 9.5619508148E+00, 2.7359065034E+00, 9.4253866529E-01],
	[2.9875000000E+04, 2.2436239531E+01, 4.6222358380E+00, 9.5671962461E+00, 2.7364266005E+00, 9.4257024484E-01],
	[2.9880000000E+04, 2.2442510347E+01, 4.6222288306E+00, 9.5724436763E+00, 2.7369465468E+00, 9.4260180624E-01],
	[2.9885000000E+04, 2.2448781866E+01, 4.6222218244E+00, 9.5776931056E+00, 2.7374663422E+00, 9.4263334950E-01],
	[2.9890000000E+04, 2.2455054088E+01, 4.6222148194E+00, 9.5829445346E+00, 2.7379859869E+00, 9.4266487465E-01],
	[2.9895000000E+04, 2.2461327012E+01, 4.6222078155E+00, 9.5881979635E+00, 2.7385054807E+00, 9.4269638167E-01],
	[2.9900000000E+04, 2.2467600640E+01, 4.6222008128E+00, 9.5934533930E+00, 2.7390248237E+00, 9.4272787059E-01],
	[2.9905000000E+04, 2.2473874970E+01, 4.6221938113E+00, 9.5987108234E+00, 2.7395440160E+00, 9.4275934142E-01],
	[2.9910000000E+04, 2.2480159610E+01, 4.6221881525E+00, 9.6039702550E+00, 2.7400636716E+00, 9.4279079416E-01],
	[2.9915000000E+04, 2.2486456250E+01, 4.6221840716E+00, 9.6092316885E+00, 2.7405838989E+00, 9.4282222882E-01],
	[2.9920000000E+04, 2.2492753602E+01, 4.6221799914E+00, 9.6144951241E+00, 2.7411039761E+00, 9.4285364542E-01],
	[2.9925000000E+04, 2.2499051664E+01, 4.6221759118E+00, 9.6197605623E+00, 2.7416239032E+00, 9.4288504396E-01],
	[2.9930000000E+04, 2.2505350437E+01, 4.6221718330E+00, 9.6250280036E+00, 2.7421436802E+00, 9.4291642446E-01],
	[2.9935000000E+04, 2.2511649921E+01, 4.6221677548E+00, 9.6302974483E+00, 2.7426633071E+00, 9.4294778691E-01],
	[2.9940000000E+04, 2.2517950115E+01, 4.6221636773E+00, 9.6355688969E+00, 2.7431827839E+00, 9.4297913134E-01],
	[2.9945000000E+04, 2.2524251021E+01, 4.6221596005E+00, 9.6408423498E+00, 2.7437021107E+00, 9.4301045776E-01],
	[2.9950000000E+04, 2.2530552637E+01, 4.6221555243E+00, 9.6461178074E+00, 2.7442212874E+00, 9.4304176616E-01],
	[2.9955000000E+04, 2.2536854963E+01, 4.6221514489E+00, 9.6513952702E+00, 2.7447403141E+00, 9.4307305657E-01],
	[2.9960000000E+04, 2.2543158000E+01, 4.6221473741E+00, 9.6566747387E+00, 2.7452591907E+00, 9.4310432899E-01],
	[2.9965000000E+04, 2.2549461748E+01, 4.6221433001E+00, 9.6619562131E+00, 2.7457779174E+00, 9.4313558343E-01],
	[2.9970000000E+04, 2.2555766206E+01, 4.6221392267E+00, 9.6672396940E+00, 2.7462964940E+00, 9.4316681990E-01],
	[2.9975000000E+04, 2.2562071375E+01, 4.6221351539E+00, 9.6725251817E+00, 2.7468149207E+00, 9.4319803841E-01],
	[2.9980000000E+04, 2.2568377254E+01, 4.6221310819E+00, 9.6778126768E+00, 2.7473331973E+00, 9.4322923898E-01],
	[2.9985000000E+04, 2.2574683844E+01, 4.6221270106E+00, 9.6831021796E+00, 2.7478513241E+00, 9.4326042160E-01],
	[2.9990000000E+04, 2.2580991144E+01, 4.6221229399E+00, 9.6883936905E+00, 2.7483693008E+00, 9.4329158630E-01],
	[2.9995000000E+04, 2.2587299154E+01, 4.6221188699E+00, 9.6936872101E+00, 2.7488871277E+00, 9.4332273307E-01],
	[3.0000000000E+04, 2.2593607874E+01, 4.6221148006E+00, 9.6989827386E+00, 2.7494048046E+00, 9.4335386194E-01],
	[3.0005000000E+04, 2.2599917305E+01, 4.6221107320E+00, 9.7043082797E+00, 2.7499245802E+00, 9.4338497290E-01],
	[3.0010000000E+04, 2.2606227446E+01, 4.6221066641E+00, 9.7096358567E+00, 2.7504442048E+00, 9.4341606598E-01],
	[3.0015000000E+04, 2.2612538297E+01, 4.6221025968E+00, 9.7149654701E+00, 2.7509636784E+00, 9.4344714117E-01],
	[3.0020000000E+04, 2.2618849858E+01, 4.6220985302E+00, 9.7202971203E+00, 2.7514830010E+00, 9.4347819849E-01],
	[3.0025000000E+04, 2.2625162130E+01, 4.6220944644E+00, 9.7256308077E+00, 2.7520021726E+00, 9.4350923796E-01],
	[3.0030000000E+04, 2.2631475111E+01, 4.6220903991E+00, 9.7309665329E+00, 2.7525211932E+00, 9.4354025957E-01],
	[3.0035000000E+04, 2.2637788803E+01, 4.6220863346E+00, 9.7363042961E+00, 2.7530400628E+00, 9.4357126334E-01],
	[3.0040000000E+04, 2.2644103204E+01, 4.6220822708E+00, 9.7416440979E+00, 2.7535587815E+00, 9.4360224927E-01],
	[3.0045000000E+04, 2.2650418315E+01, 4.6220782076E+00, 9.7469859388E+00, 2.7540773492E+00, 9.4363321739E-01],
	[3.0050000000E+04, 2.2656734137E+01, 4.6220741451E+00, 9.7523298191E+00, 2.7545957661E+00, 9.4366416769E-01],
	[3.0055000000E+04, 2.2663050668E+01, 4.6220700833E+00, 9.7576757392E+00, 2.7551140320E+00, 9.4369510019E-01],
	[3.0060000000E+04, 2.2669367909E+01, 4.6220660222E+00, 9.7630236997E+00, 2.7556321469E+00, 9.4372601490E-01],
	[3.0065000000E+04, 2.2675685859E+01, 4.6220619617E+00, 9.7683737010E+00, 2.7561501111E+00, 9.4375691183E-01],
	[3.0070000000E+04, 2.2682004520E+01, 4.6220579019E+00, 9.7737257435E+00, 2.7566679243E+00, 9.4378779098E-01],
	[3.0075000000E+04, 2.2688323890E+01, 4.6220538428E+00, 9.7790798276E+00, 2.7571855867E+00, 9.4381865237E-01],
	[3.0080000000E+04, 2.2694643970E+01, 4.6220497844E+00, 9.7844359537E+00, 2.7577030982E+00, 9.4384949601E-01],
	[3.0085000000E+04, 2.2700964759E+01, 4.6220457267E+00, 9.7897941224E+00, 2.7582204589E+00, 9.4388032190E-01],
	[3.0090000000E+04, 2.2707286258E+01, 4.6220416696E+00, 9.7951543341E+00, 2.7587376687E+00, 9.4391113006E-01],
	[3.0095000000E+04, 2.2713608467E+01, 4.6220376132E+00, 9.8005165892E+00, 2.7592547278E+00, 9.4394192049E-01],
	[3.0100000000E+04, 2.2719931385E+01, 4.6220335575E+00, 9.8058808881E+00, 2.7597716360E+00, 9.4397269321E-01],
	[3.0105000000E+04, 2.2726255012E+01, 4.6220295025E+00, 9.8112472312E+00, 2.7602883935E+00, 9.4400344823E-01],
	[3.0110000000E+04, 2.2732579349E+01, 4.6220254481E+00, 9.8166156191E+00, 2.7608050002E+00, 9.4403418555E-01],
	[3.0115000000E+04, 2.2738904396E+01, 4.6220213945E+00, 9.8219860522E+00, 2.7613214562E+00, 9.4406490518E-01],
	[3.0120000000E+04, 2.2745230152E+01, 4.6220173415E+00, 9.8273585308E+00, 2.7618377614E+00, 9.4409560714E-01],
	[3.0125000000E+04, 2.2751556617E+01, 4.6220132891E+00, 9.8327330555E+00, 2.7623539159E+00, 9.4412629144E-01],
	[3.0130000000E+04, 2.2757883791E+01, 4.6220092375E+00, 9.8381096267E+00, 2.7628699197E+00, 9.4415695808E-01],
	[3.0135000000E+04, 2.2764211675E+01, 4.6220051865E+00, 9.8434882447E+00, 2.7633857727E+00, 9.4418760707E-01],
	[3.0140000000E+04, 2.2770540268E+01, 4.6220011362E+00, 9.8488689101E+00, 2.7639014751E+00, 9.4421823843E-01],
	[3.0145000000E+04, 2.2776869570E+01, 4.6219970866E+00, 9.8542516233E+00, 2.7644170269E+00, 9.4424885216E-01],
	[3.0150000000E+04, 2.2783199581E+01, 4.6219930377E+00, 9.8596363848E+00, 2.7649324279E+00, 9.4427944828E-01],
	[3.0155000000E+04, 2.2789530301E+01, 4.6219889894E+00, 9.8650231949E+00, 2.7654476783E+00, 9.4431002679E-01],
	[3.0160000000E+04, 2.2795861730E+01, 4.6219849418E+00, 9.8704120541E+00, 2.7659627781E+00, 9.4434058770E-01],
	[3.0165000000E+04, 2.2802193869E+01, 4.6219808949E+00, 9.8758029629E+00, 2.7664777273E+00, 9.4437113102E-01],
	[3.0170000000E+04, 2.2808526716E+01, 4.6219768486E+00, 9.8811959216E+00, 2.7669925259E+00, 9.4440165677E-01],
	[3.0175000000E+04, 2.2814860272E+01, 4.6219728030E+00, 9.8865909308E+00, 2.7675071739E+00, 9.4443216495E-01],
	[3.0180000000E+04, 2.2821194537E+01, 4.6219687581E+00, 9.8919879909E+00, 2.7680216713E+00, 9.4446265557E-01],
	[3.0185000000E+04, 2.2827529511E+01, 4.6219647139E+00, 9.8973871023E+00, 2.7685360182E+00, 9.4449312865E-01],
	[3.0190000000E+04, 2.2833865194E+01, 4.6219606704E+00, 9.9027882654E+00, 2.7690502145E+00, 9.4452358418E-01],
	[3.0195000000E+04, 2.2840201586E+01, 4.6219566275E+00, 9.9081914807E+00, 2.7695642603E+00, 9.4455402219E-01],
	[3.0200000000E+04, 2.2846538686E+01, 4.6219525853E+00, 9.9135967486E+00, 2.7700781556E+00, 9.4458444268E-01],
	[3.0205000000E+04, 2.2852876495E+01, 4.6219485438E+00, 9.9190040696E+00, 2.7705919004E+00, 9.4461484566E-01],
	[3.0210000000E+04, 2.2859215013E+01, 4.6219445029E+00, 9.9244134441E+00, 2.7711054947E+00, 9.4464523115E-01],
	[3.0215000000E+04, 2.2865554239E+01, 4.6219404627E+00, 9.9298248725E+00, 2.7716189385E+00, 9.4467559914E-01],
	[3.0220000000E+04, 2.2871894174E+01, 4.6219364232E+00, 9.9352383553E+00, 2.7721322319E+00, 9.4470594965E-01],
	[3.0225000000E+04, 2.2878234818E+01, 4.6219323843E+00, 9.9406538930E+00, 2.7726453748E+00, 9.4473628270E-01],
	[3.0230000000E+04, 2.2884576170E+01, 4.6219283462E+00, 9.9460714859E+00, 2.7731583673E+00, 9.4476659828E-01],
	[3.0235000000E+04, 2.2890918231E+01, 4.6219243087E+00, 9.9514911345E+00, 2.7736712094E+00, 9.4479689642E-01],
	[3.0240000000E+04, 2.2897261000E+01, 4.6219202718E+00, 9.9569128393E+00, 2.7741839011E+00, 9.4482717711E-01],
	[3.0245000000E+04, 2.2903604477E+01, 4.6219162357E+00, 9.9623366007E+00, 2.7746964424E+00, 9.4485744038E-01],
	[3.0250000000E+04, 2.2909948663E+01, 4.6219122002E+00, 9.9677624190E+00, 2.7752088333E+00, 9.4488768622E-01],
	[3.0255000000E+04, 2.2916293557E+01, 4.6219081654E+00, 9.9731902949E+00, 2.7757210739E+00, 9.4491791465E-01],
	[3.0260000000E+04, 2.2922639160E+01, 4.6219041312E+00, 9.9786202286E+00, 2.7762331642E+00, 9.4494812569E-01],
	[3.0265000000E+04, 2.2928985470E+01, 4.6219000977E+00, 9.9840522207E+00, 2.7767451041E+00, 9.4497831933E-01],
	[3.0270000000E+04, 2.2935332489E+01, 4.6218960649E+00, 9.9894862716E+00, 2.7772568937E+00, 9.4500849559E-01],
	[3.0275000000E+04, 2.2941680216E+01, 4.6218920328E+00, 9.9949223817E+00, 2.7777685330E+00, 9.4503865447E-01],
	[3.0280000000E+04, 2.2948028652E+01, 4.6218880013E+00, 1.0000360551E+01, 2.7782800221E+00, 9.4506879600E-01],
	[3.0285000000E+04, 2.2954377795E+01, 4.6218839705E+00, 1.0005800781E+01, 2.7787913609E+00, 9.4509892017E-01],
	[3.0290000000E+04, 2.2960727646E+01, 4.6218799404E+00, 1.0011243072E+01, 2.7793025494E+00, 9.4512902701E-01],
	[3.0295000000E+04, 2.2967078206E+01, 4.6218759109E+00, 1.0016687423E+01, 2.7798135877E+00, 9.4515911651E-01],
	[3.0300000000E+04, 2.2973429473E+01, 4.6218718821E+00, 1.0022133836E+01, 2.7803244758E+00, 9.4518918868E-01],
	[3.0305000000E+04, 2.2979781449E+01, 4.6218678540E+00, 1.0027582311E+01, 2.7808352137E+00, 9.4521924355E-01],
	[3.0310000000E+04, 2.2986134132E+01, 4.6218638266E+00, 1.0033032848E+01, 2.7813458014E+00, 9.4524928111E-01],
	[3.0315000000E+04, 2.2992487523E+01, 4.6218597998E+00, 1.0038485447E+01, 2.7818562389E+00, 9.4527930137E-01],
	[3.0320000000E+04, 2.2998841622E+01, 4.6218557736E+00, 1.0043940110E+01, 2.7823665263E+00, 9.4530930436E-01],
	[3.0325000000E+04, 2.3005196429E+01, 4.6218517482E+00, 1.0049396837E+01, 2.7828766636E+00, 9.4533929007E-01],
	[3.0330000000E+04, 2.3011551944E+01, 4.6218477234E+00, 1.0054855627E+01, 2.7833866507E+00, 9.4536925852E-01],
	[3.0335000000E+04, 2.3017908166E+01, 4.6218436993E+00, 1.0060316483E+01, 2.7838964877E+00, 9.4539920971E-01],
	[3.0340000000E+04, 2.3024265096E+01, 4.6218396758E+00, 1.0065779403E+01, 2.7844061746E+00, 9.4542914366E-01],
	[3.0345000000E+04, 2.3030622734E+01, 4.6218356530E+00, 1.0071244388E+01, 2.7849157114E+00, 9.4545906037E-01],
	[3.0350000000E+04, 2.3036981079E+01, 4.6218316309E+00, 1.0076711439E+01, 2.7854250982E+00, 9.4548895986E-01],
	[3.0355000000E+04, 2.3043340132E+01, 4.6218276095E+00, 1.0082180557E+01, 2.7859343349E+00, 9.4551884213E-01],
	[3.0360000000E+04, 2.3049699892E+01, 4.6218235887E+00, 1.0087651741E+01, 2.7864434216E+00, 9.4554870720E-01],
	[3.0365000000E+04, 2.3056060360E+01, 4.6218195686E+00, 1.0093124992E+01, 2.7869523583E+00, 9.4557855507E-01],
	[3.0370000000E+04, 2.3062421535E+01, 4.6218155491E+00, 1.0098600311E+01, 2.7874611450E+00, 9.4560838576E-01],
	[3.0375000000E+04, 2.3068783418E+01, 4.6218115303E+00, 1.0104077698E+01, 2.7879697817E+00, 9.4563819927E-01],
	[3.0380000000E+04, 2.3075146008E+01, 4.6218075122E+00, 1.0109557154E+01, 2.7884782684E+00, 9.4566799562E-01],
	[3.0385000000E+04, 2.3081509306E+01, 4.6218034947E+00, 1.0115038678E+01, 2.7889866052E+00, 9.4569777481E-01],
	[3.0390000000E+04, 2.3087876724E+01, 4.6217999484E+00, 1.0120522272E+01, 2.7894950132E+00, 9.4572753685E-01],
	[3.0395000000E+04, 2.3094262130E+01, 4.6217987833E+00, 1.0126007936E+01, 2.7900043912E+00, 9.4575728176E-01],
	[3.0400000000E+04, 2.3100648251E+01, 4.6217976185E+00, 1.0131495669E+01, 2.7905136198E+00, 9.4578700954E-01],
	[3.0405000000E+04, 2.3107035087E+01, 4.6217964539E+00, 1.0136985474E+01, 2.7910226992E+00, 9.4581672020E-01],
	[3.0410000000E+04, 2.3113422638E+01, 4.6217952894E+00, 1.0142477349E+01, 2.7915316293E+00, 9.4584641375E-01],
	[3.0415000000E+04, 2.3119810905E+01, 4.6217941251E+00, 1.0147971296E+01, 2.7920404101E+00, 9.4587609021E-01],
	[3.0420000000E+04, 2.3126199886E+01, 4.6217929611E+00, 1.0153467315E+01, 2.7925490417E+00, 9.4590574958E-01],
	[3.0425000000E+04, 2.3132589583E+01, 4.6217917972E+00, 1.0158965407E+01, 2.7930575240E+00, 9.4593539187E-01],
	[3.0430000000E+04, 2.3138979994E+01, 4.6217906335E+00, 1.0164465571E+01, 2.7935658571E+00, 9.4596501710E-01],
	[3.0435000000E+04, 2.3145371121E+01, 4.6217894700E+00, 1.0169967809E+01, 2.7940740410E+00, 9.4599462526E-01],
	[3.0440000000E+04, 2.3151762963E+01, 4.6217883067E+00, 1.0175472120E+01, 2.7945820757E+00, 9.4602421638E-01],
	[3.0445000000E+04, 2.3158155519E+01, 4.6217871436E+00, 1.0180978506E+01, 2.7950899613E+00, 9.4605379045E-01],
	[3.0450000000E+04, 2.3164548790E+01, 4.6217859807E+00, 1.0186486966E+01, 2.7955976977E+00, 9.4608334750E-01],
	[3.0455000000E+04, 2.3170942777E+01, 4.6217848179E+00, 1.0191997502E+01, 2.7961052850E+00, 9.4611288753E-01],
	[3.0460000000E+04, 2.3177337478E+01, 4.6217836554E+00, 1.0197510113E+01, 2.7966127232E+00, 9.4614241055E-01],
	[3.0465000000E+04, 2.3183732894E+01, 4.6217824930E+00, 1.0203024799E+01, 2.7971200122E+00, 9.4617191657E-01],
	[3.0470000000E+04, 2.3190129024E+01, 4.6217813309E+00, 1.0208541563E+01, 2.7976271522E+00, 9.4620140559E-01],
	[3.0475000000E+04, 2.3196525869E+01, 4.6217801689E+00, 1.0214060403E+01, 2.7981341431E+00, 9.4623087764E-01],
	[3.0480000000E+04, 2.3202923429E+01, 4.6217790071E+00, 1.0219581320E+01, 2.7986409849E+00, 9.4626033272E-01],
	[3.0485000000E+04, 2.3209321704E+01, 4.6217778455E+00, 1.0225104315E+01, 2.7991476777E+00, 9.4628977084E-01],
	[3.0490000000E+04, 2.3215720693E+01, 4.6217766841E+00, 1.0230629388E+01, 2.7996542215E+00, 9.4631919200E-01],
	[3.0495000000E+04, 2.3222120396E+01, 4.6217755229E+00, 1.0236156540E+01, 2.8001606163E+00, 9.4634859623E-01],
	[3.0500000000E+04, 2.3228520815E+01, 4.6217743619E+00, 1.0241685771E+01, 2.8006668620E+00, 9.4637798352E-01],
	[3.0505000000E+04, 2.3234921947E+01, 4.6217732011E+00, 1.0247217082E+01, 2.8011729589E+00, 9.4640735389E-01],
	[3.0510000000E+04, 2.3241323794E+01, 4.6217720405E+00, 1.0252750472E+01, 2.8016789067E+00, 9.4643670735E-01],
	[3.0515000000E+04, 2.3247726356E+01, 4.6217708800E+00, 1.0258285943E+01, 2.8021847056E+00, 9.4646604391E-01],
	[3.0520000000E+04, 2.3254129632E+01, 4.6217697198E+00, 1.0263823494E+01, 2.8026903556E+00, 9.4649536358E-01],
	[3.0525000000E+04, 2.3260533622E+01, 4.6217685597E+00, 1.0269363127E+01, 2.8031958567E+00, 9.4652466636E-01],
	[3.0530000000E+04, 2.3266938326E+01, 4.6217673998E+00, 1.0274904841E+01, 2.8037012089E+00, 9.4655395227E-01],
	[3.0535000000E+04, 2.3273343745E+01, 4.6217662402E+00, 1.0280448638E+01, 2.8042064122E+00, 9.4658322131E-01],
	[3.0540000000E+04, 2.3279749878E+01, 4.6217650807E+00, 1.0285994517E+01, 2.8047114667E+00, 9.4661247351E-01],
	[3.0545000000E+04, 2.3286156725E+01, 4.6217639214E+00, 1.0291542479E+01, 2.8052163723E+00, 9.4664170886E-01],
	[3.0550000000E+04, 2.3292564286E+01, 4.6217627623E+00, 1.0297092525E+01, 2.8057211292E+00, 9.4667092737E-01],
	[3.0555000000E+04, 2.3298972561E+01, 4.6217616033E+00, 1.0302644654E+01, 2.8062257372E+00, 9.4670012906E-01],
	[3.0560000000E+04, 2.3305381550E+01, 4.6217604446E+00, 1.0308198868E+01, 2.8067301964E+00, 9.4672931394E-01],
	[3.0565000000E+04, 2.3311791254E+01, 4.6217592861E+00, 1.0313755166E+01, 2.8072345068E+00, 9.4675848201E-01],
	[3.0570000000E+04, 2.3318201671E+01, 4.6217581277E+00, 1.0319313550E+01, 2.8077386685E+00, 9.4678763329E-01],
	[3.0575000000E+04, 2.3324612802E+01, 4.6217569695E+00, 1.0324874020E+01, 2.8082426815E+00, 9.4681676778E-01],
	[3.0580000000E+04, 2.3331024647E+01, 4.6217558116E+00, 1.0330436575E+01, 2.8087465457E+00, 9.4684588550E-01],
	[3.0585000000E+04, 2.3337437206E+01, 4.6217546538E+00, 1.0336001217E+01, 2.8092502613E+00, 9.4687498645E-01],
	[3.0590000000E+04, 2.3343850479E+01, 4.6217534962E+00, 1.0341567947E+01, 2.8097538281E+00, 9.4690407064E-01],
	[3.0595000000E+04, 2.3350264466E+01, 4.6217523388E+00, 1.0347136763E+01, 2.8102572463E+00, 9.4693313809E-01],
	[3.0600000000E+04, 2.3356679166E+01, 4.6217511816E+00, 1.0352707668E+01, 2.8107605158E+00, 9.4696218881E-01],
	[3.0605000000E+04, 2.3363094581E+01, 4.6217500246E+00, 1.0358280660E+01, 2.8112636367E+00, 9.4699122279E-01],
	[3.0610000000E+04, 2.3369510708E+01, 4.6217488677E+00, 1.0363855742E+01, 2.8117666090E+00, 9.4702024006E-01],
	[3.0615000000E+04, 2.3375927550E+01, 4.6217477111E+00, 1.0369432912E+01, 2.8122694327E+00, 9.4704924062E-01],
	[3.0620000000E+04, 2.3382345105E+01, 4.6217465546E+00, 1.0375012173E+01, 2.8127721078E+00, 9.4707822449E-01],
	[3.0625000000E+04, 2.3388763374E+01, 4.6217453984E+00, 1.0380593523E+01, 2.8132746343E+00, 9.4710719166E-01],
	[3.0630000000E+04, 2.3395182356E+01, 4.6217442423E+00, 1.0386176964E+01, 2.8137770123E+00, 9.4713614216E-01],
	[3.0635000000E+04, 2.3401602052E+01, 4.6217430864E+00, 1.0391762496E+01, 2.8142792418E+00, 9.4716507599E-01],
	[3.0640000000E+04, 2.3408022461E+01, 4.6217419307E+00, 1.0397350119E+01, 2.8147813227E+00, 9.4719399316E-01],
	[3.0645000000E+04, 2.3414443583E+01, 4.6217407752E+00, 1.0402939834E+01, 2.8152832552E+00, 9.4722289369E-01],
	[3.0650000000E+04, 2.3420865419E+01, 4.6217396198E+00, 1.0408531641E+01, 2.8157850392E+00, 9.4725177757E-01],
	[3.0655000000E+04, 2.3427287969E+01, 4.6217384647E+00, 1.0414125542E+01, 2.8162866747E+00, 9.4728064482E-01],
	[3.0660000000E+04, 2.3433711231E+01, 4.6217373098E+00, 1.0419721535E+01, 2.8167881618E+00, 9.4730949546E-01],
	[3.0665000000E+04, 2.3440135207E+01, 4.6217361550E+00, 1.0425319622E+01, 2.8172895004E+00, 9.4733832948E-01],
	[3.0670000000E+04, 2.3446559897E+01, 4.6217350004E+00, 1.0430919803E+01, 2.8177906907E+00, 9.4736714691E-01],
	[3.0675000000E+04, 2.3452985299E+01, 4.6217338461E+00, 1.0436522078E+01, 2.8182917325E+00, 9.4739594774E-01],
	[3.0680000000E+04, 2.3459411414E+01, 4.6217326919E+00, 1.0442126448E+01, 2.8187926260E+00, 9.4742473200E-01],
	[3.0685000000E+04, 2.3465838243E+01, 4.6217315379E+00, 1.0447732914E+01, 2.8192933712E+00, 9.4745349968E-01],
	[3.0690000000E+04, 2.3472265785E+01, 4.6217303841E+00, 1.0453341476E+01, 2.8197939680E+00, 9.4748225080E-01],
	[3.0695000000E+04, 2.3478694040E+01, 4.6217292304E+00, 1.0458952133E+01, 2.8202944165E+00, 9.4751098537E-01],
	[3.0700000000E+04, 2.3485123008E+01, 4.6217280770E+00, 1.0464564888E+01, 2.8207947167E+00, 9.4753970340E-01],
	[3.0705000000E+04, 2.3491552688E+01, 4.6217269237E+00, 1.0470179739E+01, 2.8212948686E+00, 9.4756840489E-01],
	[3.0710000000E+04, 2.3497983082E+01, 4.6217257707E+00, 1.0475796689E+01, 2.8217948723E+00, 9.4759708987E-01],
	[3.0715000000E+04, 2.3504414189E+01, 4.6217246178E+00, 1.0481415736E+01, 2.8222947277E+00, 9.4762575833E-01],
	[3.0720000000E+04, 2.3510846008E+01, 4.6217234651E+00, 1.0487036882E+01, 2.8227944349E+00, 9.4765441028E-01],
	[3.0725000000E+04, 2.3517278541E+01, 4.6217223126E+00, 1.0492660126E+01, 2.8232939938E+00, 9.4768304575E-01],
	[3.0730000000E+04, 2.3523711786E+01, 4.6217211603E+00, 1.0498285470E+01, 2.8237934046E+00, 9.4771166473E-01],
	[3.0735000000E+04, 2.3530145744E+01, 4.6217200082E+00, 1.0503912914E+01, 2.8242926673E+00, 9.4774026724E-01],
	[3.0740000000E+04, 2.3536580415E+01, 4.6217188562E+00, 1.0509542458E+01, 2.8247917817E+00, 9.4776885328E-01],
	[3.0745000000E+04, 2.3543015798E+01, 4.6217177045E+00, 1.0515174102E+01, 2.8252907481E+00, 9.4779742287E-01],
	[3.0750000000E+04, 2.3549451894E+01, 4.6217165529E+00, 1.0520807848E+01, 2.8257895663E+00, 9.4782597601E-01],
	[3.0755000000E+04, 2.3555888702E+01, 4.6217154016E+00, 1.0526443696E+01, 2.8262882364E+00, 9.4785451272E-01],
	[3.0760000000E+04, 2.3562326224E+01, 4.6217142504E+00, 1.0532081645E+01, 2.8267867585E+00, 9.4788303300E-01],
	[3.0765000000E+04, 2.3568764457E+01, 4.6217130994E+00, 1.0537721697E+01, 2.8272851324E+00, 9.4791153687E-01],
	[3.0770000000E+04, 2.3575203404E+01, 4.6217119486E+00, 1.0543363851E+01, 2.8277833584E+00, 9.4794002433E-01],
	[3.0775000000E+04, 2.3581643062E+01, 4.6217107980E+00, 1.0549008109E+01, 2.8282814363E+00, 9.4796849539E-01],
	[3.0780000000E+04, 2.3588083433E+01, 4.6217096475E+00, 1.0554654471E+01, 2.8287793662E+00, 9.4799695007E-01],
	[3.0785000000E+04, 2.3594524517E+01, 4.6217084973E+00, 1.0560302937E+01, 2.8292771481E+00, 9.4802538837E-01],
	[3.0790000000E+04, 2.3600966313E+01, 4.6217073472E+00, 1.0565953508E+01, 2.8297747821E+00, 9.4805381030E-01],
	[3.0795000000E+04, 2.3607408821E+01, 4.6217061973E+00, 1.0571606183E+01, 2.8302722681E+00, 9.4808221588E-01],
	[3.0800000000E+04, 2.3613852041E+01, 4.6217050476E+00, 1.0577260965E+01, 2.8307696062E+00, 9.4811060511E-01],
	[3.0805000000E+04, 2.3620295974E+01, 4.6217038981E+00, 1.0582917852E+01, 2.8312667964E+00, 9.4813897799E-01],
	[3.0810000000E+04, 2.3626740619E+01, 4.6217027488E+00, 1.0588576845E+01, 2.8317638387E+00, 9.4816733456E-01],
	[3.0815000000E+04, 2.3633185976E+01, 4.6217015997E+00, 1.0594237946E+01, 2.8322607331E+00, 9.4819567480E-01],
	[3.0820000000E+04, 2.3639632045E+01, 4.6217004508E+00, 1.0599901154E+01, 2.8327574796E+00, 9.4822399873E-01],
	[3.0825000000E+04, 2.3646078826E+01, 4.6216993020E+00, 1.0605566469E+01, 2.8332540783E+00, 9.4825230636E-01],
	[3.0830000000E+04, 2.3652526320E+01, 4.6216981534E+00, 1.0611233893E+01, 2.8337505292E+00, 9.4828059771E-01],
	[3.0835000000E+04, 2.3658974525E+01, 4.6216970051E+00, 1.0616903426E+01, 2.8342468323E+00, 9.4830887277E-01],
	[3.0840000000E+04, 2.3665423442E+01, 4.6216958569E+00, 1.0622575067E+01, 2.8347429877E+00, 9.4833713156E-01],
	[3.0845000000E+04, 2.3671873072E+01, 4.6216947089E+00, 1.0628248818E+01, 2.8352389952E+00, 9.4836537410E-01],
	[3.0850000000E+04, 2.3678323413E+01, 4.6216935610E+00, 1.0633924679E+01, 2.8357348550E+00, 9.4839360038E-01],
	[3.0855000000E+04, 2.3684774466E+01, 4.6216924134E+00, 1.0639602650E+01, 2.8362305672E+00, 9.4842181041E-01],
	[3.0860000000E+04, 2.3691226231E+01, 4.6216912660E+00, 1.0645282733E+01, 2.8367261316E+00, 9.4845000422E-01],
	[3.0865000000E+04, 2.3697678707E+01, 4.6216901187E+00, 1.0650964926E+01, 2.8372215483E+00, 9.4847818181E-01],
	[3.0870000000E+04, 2.3704131896E+01, 4.6216889716E+00, 1.0656649231E+01, 2.8377168173E+00, 9.4850634318E-01],
	[3.0875000000E+04, 2.3710585796E+01, 4.6216878247E+00, 1.0662335649E+01, 2.8382119387E+00, 9.4853448835E-01],
	[3.0880000000E+04, 2.3717046969E+01, 4.6216875694E+00, 1.0668024179E+01, 2.8387073428E+00, 9.4856261732E-01],
	[3.0885000000E+04, 2.3723522793E+01, 4.6216892069E+00, 1.0673714822E+01, 2.8392035134E+00, 9.4859073012E-01],
	[3.0890000000E+04, 2.3729999336E+01, 4.6216908442E+00, 1.0679407579E+01, 2.8396995369E+00, 9.4861882673E-01],
	[3.0895000000E+04, 2.3736476599E+01, 4.6216924812E+00, 1.0685102449E+01, 2.8401954135E+00, 9.4864690719E-01],
	[3.0900000000E+04, 2.3742954581E+01, 4.6216941180E+00, 1.0690799434E+01, 2.8406911430E+00, 9.4867497149E-01],
	[3.0905000000E+04, 2.3749433283E+01, 4.6216957545E+00, 1.0696498534E+01, 2.8411867256E+00, 9.4870301964E-01],
	[3.0910000000E+04, 2.3755912704E+01, 4.6216973907E+00, 1.0702199749E+01, 2.8416821613E+00, 9.4873105166E-01],
	[3.0915000000E+04, 2.3762392844E+01, 4.6216990267E+00, 1.0707903080E+01, 2.8421774500E+00, 9.4875906755E-01],
	[3.0920000000E+04, 2.3768873703E+01, 4.6217006624E+00, 1.0713608527E+01, 2.8426725918E+00, 9.4878706733E-01],
	[3.0925000000E+04, 2.3775355282E+01, 4.6217022978E+00, 1.0719316090E+01, 2.8431675867E+00, 9.4881505100E-01],
	[3.0930000000E+04, 2.3781837580E+01, 4.6217039330E+00, 1.0725025771E+01, 2.8436624347E+00, 9.4884301857E-01],
	[3.0935000000E+04, 2.3788320597E+01, 4.6217055679E+00, 1.0730737569E+01, 2.8441571359E+00, 9.4887097006E-01],
	[3.0940000000E+04, 2.3794804333E+01, 4.6217072025E+00, 1.0736451485E+01, 2.8446516903E+00, 9.4889890547E-01],
	[3.0945000000E+04, 2.3801288788E+01, 4.6217088369E+00, 1.0742167519E+01, 2.8451460978E+00, 9.4892682481E-01],
	[3.0950000000E+04, 2.3807773962E+01, 4.6217104710E+00, 1.0747885672E+01, 2.8456403586E+00, 9.4895472809E-01],
	[3.0955000000E+04, 2.3814259856E+01, 4.6217121049E+00, 1.0753605944E+01, 2.8461344725E+00, 9.4898261533E-01],
	[3.0960000000E+04, 2.3820746468E+01, 4.6217137385E+00, 1.0759328337E+01, 2.8466284397E+00, 9.4901048652E-01],
	[3.0965000000E+04, 2.3827233799E+01, 4.6217153718E+00, 1.0765052849E+01, 2.8471222602E+00, 9.4903834168E-01],
	[3.0970000000E+04, 2.3833721849E+01, 4.6217170049E+00, 1.0770779482E+01, 2.8476159340E+00, 9.4906618083E-01],
	[3.0975000000E+04, 2.3840210618E+01, 4.6217186377E+00, 1.0776508235E+01, 2.8481094610E+00, 9.4909400396E-01],
	[3.0980000000E+04, 2.3846700105E+01, 4.6217202702E+00, 1.0782239111E+01, 2.8486028414E+00, 9.4912181110E-01],
	[3.0985000000E+04, 2.3853190312E+01, 4.6217219025E+00, 1.0787972108E+01, 2.8490960751E+00, 9.4914960224E-01],
	[3.0990000000E+04, 2.3859681237E+01, 4.6217235345E+00, 1.0793707228E+01, 2.8495891622E+00, 9.4917737740E-01],
	[3.0995000000E+04, 2.3866172881E+01, 4.6217251663E+00, 1.0799444470E+01, 2.8500821026E+00, 9.4920513659E-01],
	[3.1000000000E+04, 2.3872665243E+01, 4.6217267977E+00, 1.0805183836E+01, 2.8505748965E+00, 9.4923287982E-01],
	[3.1005000000E+04, 2.3879158324E+01, 4.6217284290E+00, 1.0810925325E+01, 2.8510675438E+00, 9.4926060709E-01],
	[3.1010000000E+04, 2.3885652124E+01, 4.6217300599E+00, 1.0816668939E+01, 2.8515600445E+00, 9.4928831842E-01],
	[3.1015000000E+04, 2.3892146642E+01, 4.6217316906E+00, 1.0822414677E+01, 2.8520523987E+00, 9.4931601382E-01],
	[3.1020000000E+04, 2.3898641879E+01, 4.6217333211E+00, 1.0828162540E+01, 2.8525446064E+00, 9.4934369329E-01],
	[3.1025000000E+04, 2.3905137834E+01, 4.6217349512E+00, 1.0833912528E+01, 2.8530366675E+00, 9.4937135685E-01],
	[3.1030000000E+04, 2.3911634508E+01, 4.6217365812E+00, 1.0839664643E+01, 2.8535285822E+00, 9.4939900451E-01],
	[3.1035000000E+04, 2.3918131900E+01, 4.6217382108E+00, 1.0845418883E+01, 2.8540203504E+00, 9.4942663627E-01],
	[3.1040000000E+04, 2.3924630011E+01, 4.6217398402E+00, 1.0851175251E+01, 2.8545119722E+00, 9.4945425214E-01],
	[3.1045000000E+04, 2.3931128840E+01, 4.6217414693E+00, 1.0856933746E+01, 2.8550034476E+00, 9.4948185214E-01],
	[3.1050000000E+04, 2.3937628387E+01, 4.6217430982E+00, 1.0862694368E+01, 2.8554947765E+00, 9.4950943627E-01],
	[3.1055000000E+04, 2.3944128652E+01, 4.6217447268E+00, 1.0868457119E+01, 2.8559859591E+00, 9.4953700454E-01],
	[3.1060000000E+04, 2.3950629636E+01, 4.6217463551E+00, 1.0874221998E+01, 2.8564769953E+00, 9.4956455697E-01],
	[3.1065000000E+04, 2.3957131338E+01, 4.6217479832E+00, 1.0879989006E+01, 2.8569678852E+00, 9.4959209355E-01],
	[3.1070000000E+04, 2.3963633758E+01, 4.6217496110E+00, 1.0885758144E+01, 2.8574586288E+00, 9.4961961430E-01],
	[3.1075000000E+04, 2.3970136896E+01, 4.6217512386E+00, 1.0891529411E+01, 2.8579492260E+00, 9.4964711922E-01],
	[3.1080000000E+04, 2.3976640753E+01, 4.6217528659E+00, 1.0897302809E+01, 2.8584396770E+00, 9.4967460833E-01],
	[3.1085000000E+04, 2.3983145327E+01, 4.6217544929E+00, 1.0903078337E+01, 2.8589299817E+00, 9.4970208164E-01],
	[3.1090000000E+04, 2.3989650619E+01, 4.6217561197E+00, 1.0908855997E+01, 2.8594201402E+00, 9.4972953914E-01],
	[3.1095000000E+04, 2.3996156630E+01, 4.6217577462E+00, 1.0914635789E+01, 2.8599101525E+00, 9.4975698086E-01],
	[3.1100000000E+04, 2.4002663358E+01, 4.6217593725E+00, 1.0920417712E+01, 2.8604000186E+00, 9.4978440679E-01],
	[3.1105000000E+04, 2.4009170804E+01, 4.6217609985E+00, 1.0926201768E+01, 2.8608897385E+00, 9.4981181695E-01],
	[3.1110000000E+04, 2.4015678968E+01, 4.6217626242E+00, 1.0931987958E+01, 2.8613793122E+00, 9.4983921135E-01],
	[3.1115000000E+04, 2.4022187850E+01, 4.6217642497E+00, 1.0937776280E+01, 2.8618687398E+00, 9.4986658999E-01],
	[3.1120000000E+04, 2.4028697450E+01, 4.6217658749E+00, 1.0943566737E+01, 2.8623580213E+00, 9.4989395288E-01],
	[3.1125000000E+04, 2.4035207767E+01, 4.6217674998E+00, 1.0949359327E+01, 2.8628471567E+00, 9.4992130004E-01],
	[3.1130000000E+04, 2.4041718802E+01, 4.6217691245E+00, 1.0955154053E+01, 2.8633361460E+00, 9.4994863147E-01],
	[3.1135000000E+04, 2.4048230555E+01, 4.6217707490E+00, 1.0960950914E+01, 2.8638249893E+00, 9.4997594717E-01],
	[3.1140000000E+04, 2.4054743026E+01, 4.6217723731E+00, 1.0966749910E+01, 2.8643136865E+00, 9.5000324716E-01],
	[3.1145000000E+04, 2.4061256214E+01, 4.6217739970E+00, 1.0972551043E+01, 2.8648022378E+00, 9.5003053145E-01],
	[3.1150000000E+04, 2.4067770119E+01, 4.6217756207E+00, 1.0978354312E+01, 2.8652906430E+00, 9.5005780005E-01],
	[3.1155000000E+04, 2.4074284743E+01, 4.6217772441E+00, 1.0984159718E+01, 2.8657789022E+00, 9.5008505295E-01],
	[3.1160000000E+04, 2.4080800083E+01, 4.6217788672E+00, 1.0989967261E+01, 2.8662670156E+00, 9.5011229018E-01],
	[3.1165000000E+04, 2.4087316142E+01, 4.6217804901E+00, 1.0995776943E+01, 2.8667549829E+00, 9.5013951174E-01],
	[3.1170000000E+04, 2.4093832917E+01, 4.6217821127E+00, 1.1001588762E+01, 2.8672428044E+00, 9.5016671763E-01],
	[3.1175000000E+04, 2.4100350410E+01, 4.6217837350E+00, 1.1007402721E+01, 2.8677304800E+00, 9.5019390788E-01],
	[3.1180000000E+04, 2.4106868621E+01, 4.6217853571E+00, 1.1013218819E+01, 2.8682180097E+00, 9.5022108248E-01],
	[3.1185000000E+04, 2.4113387548E+01, 4.6217869789E+00, 1.1019037056E+01, 2.8687053936E+00, 9.5024824144E-01],
	[3.1190000000E+04, 2.4119907193E+01, 4.6217886005E+00, 1.1024857433E+01, 2.8691926317E+00, 9.5027538478E-01],
	[3.1195000000E+04, 2.4126427556E+01, 4.6217902218E+00, 1.1030679951E+01, 2.8696797239E+00, 9.5030251250E-01],
	[3.1200000000E+04, 2.4132948635E+01, 4.6217918429E+00, 1.1036504610E+01, 2.8701666704E+00, 9.5032962461E-01],
	[3.1205000000E+04, 2.4139470432E+01, 4.6217934637E+00, 1.1042331410E+01, 2.8706534711E+00, 9.5035672111E-01],
	[3.1210000000E+04, 2.4145992946E+01, 4.6217950842E+00, 1.1048160353E+01, 2.8711401260E+00, 9.5038380203E-01],
	[3.1215000000E+04, 2.4152516177E+01, 4.6217967045E+00, 1.1053991437E+01, 2.8716266353E+00, 9.5041086736E-01],
	[3.1220000000E+04, 2.4159040125E+01, 4.6217983245E+00, 1.1059824665E+01, 2.8721129988E+00, 9.5043791712E-01],
	[3.1225000000E+04, 2.4165564790E+01, 4.6217999443E+00, 1.1065660035E+01, 2.8725992167E+00, 9.5046495131E-01],
	[3.1230000000E+04, 2.4172090172E+01, 4.6218015638E+00, 1.1071497549E+01, 2.8730852889E+00, 9.5049196994E-01],
	[3.1235000000E+04, 2.4178616271E+01, 4.6218031830E+00, 1.1077337207E+01, 2.8735712155E+00, 9.5051897302E-01],
	[3.1240000000E+04, 2.4185143087E+01, 4.6218048020E+00, 1.1083179010E+01, 2.8740569965E+00, 9.5054596056E-01],
	[3.1245000000E+04, 2.4191670620E+01, 4.6218064207E+00, 1.1089022958E+01, 2.8745426319E+00, 9.5057293257E-01],
	[3.1250000000E+04, 2.4198198870E+01, 4.6218080392E+00, 1.1094869051E+01, 2.8750281217E+00, 9.5059988905E-01],
	[3.1255000000E+04, 2.4204727836E+01, 4.6218096574E+00, 1.1100717290E+01, 2.8755134659E+00, 9.5062683002E-01],
	[3.1260000000E+04, 2.4211257520E+01, 4.6218112753E+00, 1.1106567675E+01, 2.8759986647E+00, 9.5065375548E-01],
	[3.1265000000E+04, 2.4217787920E+01, 4.6218128930E+00, 1.1112420208E+01, 2.8764837179E+00, 9.5068066545E-01],
	[3.1270000000E+04, 2.4224319036E+01, 4.6218145104E+00, 1.1118274887E+01, 2.8769686257E+00, 9.5070755992E-01],
	[3.1275000000E+04, 2.4230850870E+01, 4.6218161276E+00, 1.1124131714E+01, 2.8774533879E+00, 9.5073443891E-01],
	[3.1280000000E+04, 2.4237383420E+01, 4.6218177445E+00, 1.1129990689E+01, 2.8779380048E+00, 9.5076130243E-01],
	[3.1285000000E+04, 2.4243916687E+01, 4.6218193612E+00, 1.1135851812E+01, 2.8784224762E+00, 9.5078815049E-01],
	[3.1290000000E+04, 2.4250450670E+01, 4.6218209776E+00, 1.1141715085E+01, 2.8789068022E+00, 9.5081498309E-01],
	[3.1295000000E+04, 2.4256985370E+01, 4.6218225937E+00, 1.1147580507E+01, 2.8793909829E+00, 9.5084180025E-01],
	[3.1300000000E+04, 2.4263520786E+01, 4.6218242096E+00, 1.1153448079E+01, 2.8798750182E+00, 9.5086860196E-01],
	[3.1305000000E+04, 2.4270056919E+01, 4.6218258252E+00, 1.1159317801E+01, 2.8803589081E+00, 9.5089538825E-01],
	[3.1310000000E+04, 2.4276593768E+01, 4.6218274406E+00, 1.1165189674E+01, 2.8808426528E+00, 9.5092215912E-01],
	[3.1315000000E+04, 2.4283131334E+01, 4.6218290557E+00, 1.1171063698E+01, 2.8813262522E+00, 9.5094891457E-01],
	[3.1320000000E+04, 2.4289669616E+01, 4.6218306706E+00, 1.1176939873E+01, 2.8818097063E+00, 9.5097565462E-01],
	[3.1325000000E+04, 2.4296208614E+01, 4.6218322852E+00, 1.1182818201E+01, 2.8822930151E+00, 9.5100237928E-01],
	[3.1330000000E+04, 2.4302748329E+01, 4.6218338995E+00, 1.1188698681E+01, 2.8827761787E+00, 9.5102908855E-01],
	[3.1335000000E+04, 2.4309288760E+01, 4.6218355136E+00, 1.1194581315E+01, 2.8832591972E+00, 9.5105578244E-01],
	[3.1340000000E+04, 2.4315829907E+01, 4.6218371274E+00, 1.1200466102E+01, 2.8837420704E+00, 9.5108246096E-01],
	[3.1345000000E+04, 2.4322371770E+01, 4.6218387410E+00, 1.1206353042E+01, 2.8842247985E+00, 9.5110912412E-01],
	[3.1350000000E+04, 2.4328914349E+01, 4.6218403543E+00, 1.1212242137E+01, 2.8847073814E+00, 9.5113577193E-01],
	[3.1355000000E+04, 2.4335457645E+01, 4.6218419673E+00, 1.1218133387E+01, 2.8851898193E+00, 9.5116240440E-01],
	[3.1360000000E+04, 2.4342001656E+01, 4.6218435801E+00, 1.1224026791E+01, 2.8856721120E+00, 9.5118902153E-01],
	[3.1365000000E+04, 2.4348546384E+01, 4.6218451927E+00, 1.1229922352E+01, 2.8861542597E+00, 9.5121562333E-01],
	[3.1370000000E+04, 2.4355091828E+01, 4.6218468050E+00, 1.1235820069E+01, 2.8866362623E+00, 9.5124220982E-01],
	[3.1375000000E+04, 2.4361637987E+01, 4.6218484170E+00, 1.1241719942E+01, 2.8871181199E+00, 9.5126878099E-01],
	[3.1380000000E+04, 2.4368203133E+01, 4.6218524760E+00, 1.1247621972E+01, 2.8876010443E+00, 9.5129533687E-01],
	[3.1385000000E+04, 2.4374771030E+01, 4.6218568059E+00, 1.1253526159E+01, 2.8880839587E+00, 9.5132187745E-01],
	[3.1390000000E+04, 2.4381339650E+01, 4.6218611351E+00, 1.1259432505E+01, 2.8885667287E+00, 9.5134840275E-01],
	[3.1395000000E+04, 2.4387908994E+01, 4.6218654637E+00, 1.1265341008E+01, 2.8890493543E+00, 9.5137491278E-01],
	[3.1400000000E+04, 2.4394479062E+01, 4.6218697916E+00, 1.1271251671E+01, 2.8895318355E+00, 9.5140140754E-01],
	[3.1405000000E+04, 2.4401049852E+01, 4.6218741188E+00, 1.1277164492E+01, 2.8900141723E+00, 9.5142788704E-01],
	[3.1410000000E+04, 2.4407621367E+01, 4.6218784453E+00, 1.1283079474E+01, 2.8904963648E+00, 9.5145435129E-01],
	[3.1415000000E+04, 2.4414193604E+01, 4.6218827711E+00, 1.1288996615E+01, 2.8909784130E+00, 9.5148080031E-01],
	[3.1420000000E+04, 2.4420766565E+01, 4.6218870963E+00, 1.1294915917E+01, 2.8914603168E+00, 9.5150723409E-01],
	[3.1425000000E+04, 2.4427340250E+01, 4.6218914207E+00, 1.1300837380E+01, 2.8919420764E+00, 9.5153365264E-01],
	[3.1430000000E+04, 2.4433914657E+01, 4.6218957445E+00, 1.1306761004E+01, 2.8924236918E+00, 9.5156005599E-01],
	[3.1435000000E+04, 2.4440489788E+01, 4.6219000676E+00, 1.1312686790E+01, 2.8929051629E+00, 9.5158644412E-01],
	[3.1440000000E+04, 2.4447065642E+01, 4.6219043900E+00, 1.1318614739E+01, 2.8933864898E+00, 9.5161281706E-01],
	[3.1445000000E+04, 2.4453642219E+01, 4.6219087117E+00, 1.1324544850E+01, 2.8938676725E+00, 9.5163917481E-01],
	[3.1450000000E+04, 2.4460219519E+01, 4.6219130328E+00, 1.1330477124E+01, 2.8943487111E+00, 9.5166551738E-01],
	[3.1455000000E+04, 2.4466797543E+01, 4.6219173531E+00, 1.1336411562E+01, 2.8948296055E+00, 9.5169184478E-01],
	[3.1460000000E+04, 2.4473376289E+01, 4.6219216728E+00, 1.1342348164E+01, 2.8953103558E+00, 9.5171815701E-01],
	[3.1465000000E+04, 2.4479955758E+01, 4.6219259918E+00, 1.1348286931E+01, 2.8957909619E+00, 9.5174445409E-01],
	[3.1470000000E+04, 2.4486535951E+01, 4.6219303101E+00, 1.1354227863E+01, 2.8962714241E+00, 9.5177073602E-01],
	[3.1475000000E+04, 2.4493116866E+01, 4.6219346277E+00, 1.1360170960E+01, 2.8967517421E+00, 9.5179700282E-01],
	[3.1480000000E+04, 2.4499698504E+01, 4.6219389447E+00, 1.1366116223E+01, 2.8972319162E+00, 9.5182325449E-01],
	[3.1485000000E+04, 2.4506280865E+01, 4.6219432609E+00, 1.1372063652E+01, 2.8977119462E+00, 9.5184949103E-01],
	[3.1490000000E+04, 2.4512863949E+01, 4.6219475765E+00, 1.1378013248E+01, 2.8981918322E+00, 9.5187571247E-01],
	[3.1495000000E+04, 2.4519447756E+01, 4.6219518914E+00, 1.1383965012E+01, 2.8986715743E+00, 9.5190191880E-01],
	[3.1500000000E+04, 2.4526032285E+01, 4.6219562056E+00, 1.1389918942E+01, 2.8991511724E+00, 9.5192811004E-01],
	[3.1505000000E+04, 2.4532617538E+01, 4.6219605192E+00, 1.1395875041E+01, 2.8996306267E+00, 9.5195428619E-01],
	[3.1510000000E+04, 2.4539203512E+01, 4.6219648321E+00, 1.1401833309E+01, 2.9001099370E+00, 9.5198044726E-01],
	[3.1515000000E+04, 2.4545790210E+01, 4.6219691442E+00, 1.1407793746E+01, 2.9005891034E+00, 9.5200659327E-01],
	[3.1520000000E+04, 2.4552377630E+01, 4.6219734557E+00, 1.1413756352E+01, 2.9010681260E+00, 9.5203272421E-01],
	[3.1525000000E+04, 2.4558965773E+01, 4.6219777666E+00, 1.1419721127E+01, 2.9015470048E+00, 9.5205884011E-01],
	[3.1530000000E+04, 2.4565554638E+01, 4.6219820767E+00, 1.1425688074E+01, 2.9020257398E+00, 9.5208494096E-01],
	[3.1535000000E+04, 2.4572144226E+01, 4.6219863862E+00, 1.1431657191E+01, 2.9025043310E+00, 9.5211102677E-01],
	[3.1540000000E+04, 2.4578734536E+01, 4.6219906949E+00, 1.1437628479E+01, 2.9029827784E+00, 9.5213709756E-01],
	[3.1545000000E+04, 2.4585325569E+01, 4.6219950030E+00, 1.1443601939E+01, 2.9034610821E+00, 9.5216315334E-01],
	[3.1550000000E+04, 2.4591917324E+01, 4.6219993105E+00, 1.1449577570E+01, 2.9039392421E+00, 9.5218919410E-01],
	[3.1555000000E+04, 2.4598509802E+01, 4.6220036172E+00, 1.1455555375E+01, 2.9044172583E+00, 9.5221521986E-01],
	[3.1560000000E+04, 2.4605103002E+01, 4.6220079233E+00, 1.1461535352E+01, 2.9048951310E+00, 9.5224123064E-01],
	[3.1565000000E+04, 2.4611696924E+01, 4.6220122287E+00, 1.1467517503E+01, 2.9053728599E+00, 9.5226722643E-01],
	[3.1570000000E+04, 2.4618291568E+01, 4.6220165334E+00, 1.1473501828E+01, 2.9058504453E+00, 9.5229320724E-01],
	[3.1575000000E+04, 2.4624886935E+01, 4.6220208374E+00, 1.1479488327E+01, 2.9063278870E+00, 9.5231917309E-01],
	[3.1580000000E+04, 2.4631483024E+01, 4.6220251408E+00, 1.1485477001E+01, 2.9068051852E+00, 9.5234512398E-01],
	[3.1585000000E+04, 2.4638079835E+01, 4.6220294434E+00, 1.1491467850E+01, 2.9072823398E+00, 9.5237105992E-01],
	[3.1590000000E+04, 2.4644677368E+01, 4.6220337454E+00, 1.1497460875E+01, 2.9077593509E+00, 9.5239698093E-01],
	[3.1595000000E+04, 2.4651275623E+01, 4.6220380468E+00, 1.1503456076E+01, 2.9082362185E+00, 9.5242288700E-01],
	[3.1600000000E+04, 2.4657874601E+01, 4.6220423474E+00, 1.1509453453E+01, 2.9087129426E+00, 9.5244877815E-01],
	[3.1605000000E+04, 2.4664474300E+01, 4.6220466474E+00, 1.1515453008E+01, 2.9091895232E+00, 9.5247465438E-01],
	[3.1610000000E+04, 2.4671074721E+01, 4.6220509467E+00, 1.1521454740E+01, 2.9096659604E+00, 9.5250051571E-01],
	[3.1615000000E+04, 2.4677675865E+01, 4.6220552453E+00, 1.1527458650E+01, 2.9101422542E+00, 9.5252636214E-01],
	[3.1620000000E+04, 2.4684277730E+01, 4.6220595433E+00, 1.1533464738E+01, 2.9106184046E+00, 9.5255219368E-01],
	[3.1625000000E+04, 2.4690880317E+01, 4.6220638405E+00, 1.1539473005E+01, 2.9110944116E+00, 9.5257801035E-01],
	[3.1630000000E+04, 2.4697483626E+01, 4.6220681371E+00, 1.1545483451E+01, 2.9115702753E+00, 9.5260381214E-01],
	[3.1635000000E+04, 2.4704087657E+01, 4.6220724330E+00, 1.1551496077E+01, 2.9120459957E+00, 9.5262959906E-01],
	[3.1640000000E+04, 2.4710692409E+01, 4.6220767283E+00, 1.1557510883E+01, 2.9125215727E+00, 9.5265537114E-01],
	[3.1645000000E+04, 2.4717297884E+01, 4.6220810228E+00, 1.1563527869E+01, 2.9129970065E+00, 9.5268112836E-01],
	[3.1650000000E+04, 2.4723904079E+01, 4.6220853167E+00, 1.1569547037E+01, 2.9134722971E+00, 9.5270687075E-01],
	[3.1655000000E+04, 2.4730510997E+01, 4.6220896100E+00, 1.1575568386E+01, 2.9139474444E+00, 9.5273259832E-01],
	[3.1660000000E+04, 2.4737118636E+01, 4.6220939025E+00, 1.1581591917E+01, 2.9144224485E+00, 9.5275831106E-01],
	[3.1665000000E+04, 2.4743726997E+01, 4.6220981944E+00, 1.1587617630E+01, 2.9148973094E+00, 9.5278400899E-01],
	[3.1670000000E+04, 2.4750336080E+01, 4.6221024856E+00, 1.1593645526E+01, 2.9153720271E+00, 9.5280969211E-01],
	[3.1675000000E+04, 2.4756945884E+01, 4.6221067761E+00, 1.1599675606E+01, 2.9158466018E+00, 9.5283536045E-01],
	[3.1680000000E+04, 2.4763556409E+01, 4.6221110659E+00, 1.1605707869E+01, 2.9163210333E+00, 9.5286101399E-01],
	[3.1685000000E+04, 2.4770167656E+01, 4.6221153551E+00, 1.1611742316E+01, 2.9167953217E+00, 9.5288665276E-01],
	[3.1690000000E+04, 2.4776779624E+01, 4.6221196436E+00, 1.1617778948E+01, 2.9172694671E+00, 9.5291227676E-01],
	[3.1695000000E+04, 2.4783392314E+01, 4.6221239315E+00, 1.1623817764E+01, 2.9177434694E+00, 9.5293788600E-01],
	[3.1700000000E+04, 2.4790005725E+01, 4.6221282186E+00, 1.1629858767E+01, 2.9182173287E+00, 9.5296348049E-01],
	[3.1705000000E+04, 2.4796619858E+01, 4.6221325051E+00, 1.1635901955E+01, 2.9186910450E+00, 9.5298906023E-01],
	[3.1710000000E+04, 2.4803234711E+01, 4.6221367909E+00, 1.1641947329E+01, 2.9191646183E+00, 9.5301462524E-01],
	[3.1715000000E+04, 2.4809850286E+01, 4.6221410761E+00, 1.1647994891E+01, 2.9196380487E+00, 9.5304017553E-01],
	[3.1720000000E+04, 2.4816466582E+01, 4.6221453605E+00, 1.1654044639E+01, 2.9201113362E+00, 9.5306571110E-01],
	[3.1725000000E+04, 2.4823083600E+01, 4.6221496443E+00, 1.1660096576E+01, 2.9205844808E+00, 9.5309123195E-01],
	[3.1730000000E+04, 2.4829701338E+01, 4.6221539275E+00, 1.1666150700E+01, 2.9210574825E+00, 9.5311673811E-01],
	[3.1735000000E+04, 2.4836319798E+01, 4.6221582099E+00, 1.1672207013E+01, 2.9215303413E+00, 9.5314222958E-01],
	[3.1740000000E+04, 2.4842938978E+01, 4.6221624917E+00, 1.1678265515E+01, 2.9220030574E+00, 9.5316770636E-01],
	[3.1745000000E+04, 2.4849558880E+01, 4.6221667728E+00, 1.1684326207E+01, 2.9224756306E+00, 9.5319316847E-01],
	[3.1750000000E+04, 2.4856179503E+01, 4.6221710533E+00, 1.1690389088E+01, 2.9229480610E+00, 9.5321861591E-01],
	[3.1755000000E+04, 2.4862800846E+01, 4.6221753331E+00, 1.1696454160E+01, 2.9234203487E+00, 9.5324404869E-01],
	[3.1760000000E+04, 2.4869422911E+01, 4.6221796122E+00, 1.1702521423E+01, 2.9238924937E+00, 9.5326946683E-01],
	[3.1765000000E+04, 2.4876045697E+01, 4.6221838906E+00, 1.1708590877E+01, 2.9243644959E+00, 9.5329487032E-01],
	[3.1770000000E+04, 2.4882669203E+01, 4.6221881684E+00, 1.1714662523E+01, 2.9248363555E+00, 9.5332025919E-01],
	[3.1775000000E+04, 2.4889293430E+01, 4.6221924455E+00, 1.1720736360E+01, 2.9253080724E+00, 9.5334563343E-01],
	[3.1780000000E+04, 2.4895918378E+01, 4.6221967219E+00, 1.1726812391E+01, 2.9257796466E+00, 9.5337099305E-01],
	[3.1785000000E+04, 2.4902544047E+01, 4.6222009977E+00, 1.1732890615E+01, 2.9262510783E+00, 9.5339633807E-01],
	[3.1790000000E+04, 2.4909170436E+01, 4.6222052728E+00, 1.1738971032E+01, 2.9267223674E+00, 9.5342166849E-01],
	[3.1795000000E+04, 2.4915797546E+01, 4.6222095472E+00, 1.1745053643E+01, 2.9271935139E+00, 9.5344698432E-01],
	[3.1800000000E+04, 2.4922425377E+01, 4.6222138209E+00, 1.1751138448E+01, 2.9276645178E+00, 9.5347228557E-01],
	[3.1805000000E+04, 2.4929053929E+01, 4.6222180940E+00, 1.1757225448E+01, 2.9281353793E+00, 9.5349757225E-01],
	[3.1810000000E+04, 2.4935683201E+01, 4.6222223665E+00, 1.1763314644E+01, 2.9286060983E+00, 9.5352284436E-01],
	[3.1815000000E+04, 2.4942313193E+01, 4.6222266382E+00, 1.1769406035E+01, 2.9290766748E+00, 9.5354810192E-01],
	[3.1820000000E+04, 2.4948943906E+01, 4.6222309093E+00, 1.1775499622E+01, 2.9295471088E+00, 9.5357334493E-01],
	[3.1825000000E+04, 2.4955575340E+01, 4.6222351797E+00, 1.1781595407E+01, 2.9300174005E+00, 9.5359857341E-01],
	[3.1830000000E+04, 2.4962207494E+01, 4.6222394495E+00, 1.1787693388E+01, 2.9304875497E+00, 9.5362378735E-01],
	[3.1835000000E+04, 2.4968840368E+01, 4.6222437185E+00, 1.1793793566E+01, 2.9309575566E+00, 9.5364898677E-01],
	[3.1840000000E+04, 2.4975473963E+01, 4.6222479870E+00, 1.1799895943E+01, 2.9314274211E+00, 9.5367417168E-01],
	[3.1845000000E+04, 2.4982108278E+01, 4.6222522547E+00, 1.1806000518E+01, 2.9318971433E+00, 9.5369934209E-01],
	[3.1850000000E+04, 2.4988743313E+01, 4.6222565218E+00, 1.1812107292E+01, 2.9323667232E+00, 9.5372449800E-01],
	[3.1855000000E+04, 2.4995379069E+01, 4.6222607882E+00, 1.1818216265E+01, 2.9328361609E+00, 9.5374963943E-01],
	[3.1860000000E+04, 2.5002015545E+01, 4.6222650540E+00, 1.1824327438E+01, 2.9333054563E+00, 9.5377476637E-01],
	[3.1865000000E+04, 2.5008652741E+01, 4.6222693191E+00, 1.1830440811E+01, 2.9337746095E+00, 9.5379987885E-01],
	[3.1870000000E+04, 2.5015290657E+01, 4.6222735835E+00, 1.1836556385E+01, 2.9342436204E+00, 9.5382497687E-01],
	[3.1875000000E+04, 2.5021929294E+01, 4.6222778473E+00, 1.1842674160E+01, 2.9347124892E+00, 9.5385006043E-01],
	[3.1880000000E+04, 2.5028568650E+01, 4.6222821103E+00, 1.1848794137E+01, 2.9351812159E+00, 9.5387512954E-01],
	[3.1885000000E+04, 2.5035226400E+01, 4.6222887079E+00, 1.1854916315E+01, 2.9356509853E+00, 9.5390018423E-01],
	[3.1890000000E+04, 2.5041887297E+01, 4.6222956242E+00, 1.1861040696E+01, 2.9361207754E+00, 9.5392522448E-01],
	[3.1895000000E+04, 2.5048548922E+01, 4.6223025395E+00, 1.1867167280E+01, 2.9365904239E+00, 9.5395025032E-01],
	[3.1900000000E+04, 2.5055211275E+01, 4.6223094537E+00, 1.1873296067E+01, 2.9370599309E+00, 9.5397526174E-01],
	[3.1905000000E+04, 2.5061874354E+01, 4.6223163668E+00, 1.1879427058E+01, 2.9375292964E+00, 9.5400025876E-01],
	[3.1910000000E+04, 2.5068538162E+01, 4.6223232788E+00, 1.1885560253E+01, 2.9379985203E+00, 9.5402524139E-01],
	[3.1915000000E+04, 2.5075202696E+01, 4.6223301898E+00, 1.1891695653E+01, 2.9384676028E+00, 9.5405020964E-01],
	[3.1920000000E+04, 2.5081867958E+01, 4.6223370997E+00, 1.1897833258E+01, 2.9389365438E+00, 9.5407516351E-01],
	[3.1925000000E+04, 2.5088533948E+01, 4.6223440085E+00, 1.1903973068E+01, 2.9394053434E+00, 9.5410010301E-01],
	[3.1930000000E+04, 2.5095200664E+01, 4.6223509163E+00, 1.1910115085E+01, 2.9398740016E+00, 9.5412502815E-01],
	[3.1935000000E+04, 2.5101868108E+01, 4.6223578229E+00, 1.1916259307E+01, 2.9403425184E+00, 9.5414993894E-01],
	[3.1940000000E+04, 2.5108536279E+01, 4.6223647286E+00, 1.1922405737E+01, 2.9408108938E+00, 9.5417483539E-01],
	[3.1945000000E+04, 2.5115205177E+01, 4.6223716331E+00, 1.1928554374E+01, 2.9412791279E+00, 9.5419971751E-01],
	[3.1950000000E+04, 2.5121874802E+01, 4.6223785366E+00, 1.1934705219E+01, 2.9417472208E+00, 9.5422458530E-01],
	[3.1955000000E+04, 2.5128545155E+01, 4.6223854390E+00, 1.1940858273E+01, 2.9422151723E+00, 9.5424943877E-01],
	[3.1960000000E+04, 2.5135216234E+01, 4.6223923403E+00, 1.1947013535E+01, 2.9426829826E+00, 9.5427427793E-01],
	[3.1965000000E+04, 2.5141888041E+01, 4.6223992406E+00, 1.1953171006E+01, 2.9431506516E+00, 9.5429910280E-01],
	[3.1970000000E+04, 2.5148560574E+01, 4.6224061398E+00, 1.1959330686E+01, 2.9436181794E+00, 9.5432391337E-01],
	[3.1975000000E+04, 2.5155233835E+01, 4.6224130379E+00, 1.1965492577E+01, 2.9440855661E+00, 9.5434870966E-01],
	[3.1980000000E+04, 2.5161907822E+01, 4.6224199349E+00, 1.1971656678E+01, 2.9445528116E+00, 9.5437349168E-01],
	[3.1985000000E+04, 2.5168582536E+01, 4.6224268309E+00, 1.1977822990E+01, 2.9450199160E+00, 9.5439825943E-01],
	[3.1990000000E+04, 2.5175257977E+01, 4.6224337258E+00, 1.1983991514E+01, 2.9454868792E+00, 9.5442301292E-01],
	[3.1995000000E+04, 2.5181934145E+01, 4.6224406197E+00, 1.1990162249E+01, 2.9459537014E+00, 9.5444775216E-01],
	[3.2000000000E+04, 2.5188611040E+01, 4.6224475125E+00, 1.1996335196E+01, 2.9464203825E+00, 9.5447247716E-01],
	[3.2005000000E+04, 2.5195288662E+01, 4.6224544042E+00, 1.2002510357E+01, 2.9468869226E+00, 9.5449718794E-01],
	[3.2010000000E+04, 2.5201967010E+01, 4.6224612949E+00, 1.2008687730E+01, 2.9473533216E+00, 9.5452188448E-01],
	[3.2015000000E+04, 2.5208646085E+01, 4.6224681844E+00, 1.2014867317E+01, 2.9478195797E+00, 9.5454656682E-01],
	[3.2020000000E+04, 2.5215325886E+01, 4.6224750730E+00, 1.2021049118E+01, 2.9482856968E+00, 9.5457123494E-01],
	[3.2025000000E+04, 2.5222006415E+01, 4.6224819604E+00, 1.2027233134E+01, 2.9487516730E+00, 9.5459588887E-01],
	[3.2030000000E+04, 2.5228687669E+01, 4.6224888468E+00, 1.2033419364E+01, 2.9492175083E+00, 9.5462052861E-01],
	[3.2035000000E+04, 2.5235369651E+01, 4.6224957321E+00, 1.2039607810E+01, 2.9496832027E+00, 9.5464515416E-01],
	[3.2040000000E+04, 2.5242052358E+01, 4.6225026164E+00, 1.2045798472E+01, 2.9501487563E+00, 9.5466976555E-01],
	[3.2045000000E+04, 2.5248735793E+01, 4.6225094996E+00, 1.2051991350E+01, 2.9506141690E+00, 9.5469436277E-01],
	[3.2050000000E+04, 2.5255419954E+01, 4.6225163817E+00, 1.2058186445E+01, 2.9510794409E+00, 9.5471894583E-01],
	[3.2055000000E+04, 2.5262104841E+01, 4.6225232628E+00, 1.2064383757E+01, 2.9515445720E+00, 9.5474351475E-01],
	[3.2060000000E+04, 2.5268790454E+01, 4.6225301428E+00, 1.2070583286E+01, 2.9520095623E+00, 9.5476806953E-01],
	[3.2065000000E+04, 2.5275476794E+01, 4.6225370218E+00, 1.2076785034E+01, 2.9524744119E+00, 9.5479261017E-01],
	[3.2070000000E+04, 2.5282163860E+01, 4.6225438996E+00, 1.2082989000E+01, 2.9529391208E+00, 9.5481713670E-01],
	[3.2075000000E+04, 2.5288851653E+01, 4.6225507765E+00, 1.2089195186E+01, 2.9534036891E+00, 9.5484164911E-01],
	[3.2080000000E+04, 2.5295540171E+01, 4.6225576522E+00, 1.2095403590E+01, 2.9538681166E+00, 9.5486614742E-01],
	[3.2085000000E+04, 2.5302229416E+01, 4.6225645269E+00, 1.2101614215E+01, 2.9543324036E+00, 9.5489063163E-01],
	[3.2090000000E+04, 2.5308919387E+01, 4.6225714006E+00, 1.2107827060E+01, 2.9547965499E+00, 9.5491510175E-01],
	[3.2095000000E+04, 2.5315610085E+01, 4.6225782731E+00, 1.2114042125E+01, 2.9552605556E+00, 9.5493955779E-01],
	[3.2100000000E+04, 2.5322301508E+01, 4.6225851446E+00, 1.2120259412E+01, 2.9557244208E+00, 9.5496399976E-01],
	[3.2105000000E+04, 2.5328993657E+01, 4.6225920151E+00, 1.2126478921E+01, 2.9561881455E+00, 9.5498842767E-01],
	[3.2110000000E+04, 2.5335686533E+01, 4.6225988845E+00, 1.2132700651E+01, 2.9566517296E+00, 9.5501284153E-01],
	[3.2115000000E+04, 2.5342380134E+01, 4.6226057528E+00, 1.2138924604E+01, 2.9571151733E+00, 9.5503724133E-01],
	[3.2120000000E+04, 2.5349074462E+01, 4.6226126201E+00, 1.2145150781E+01, 2.9575784765E+00, 9.5506162710E-01],
	[3.2125000000E+04, 2.5355769515E+01, 4.6226194863E+00, 1.2151379180E+01, 2.9580416393E+00, 9.5508599884E-01],
	[3.2130000000E+04, 2.5362465294E+01, 4.6226263515E+00, 1.2157609804E+01, 2.9585046617E+00, 9.5511035656E-01],
	[3.2135000000E+04, 2.5369161799E+01, 4.6226332156E+00, 1.2163842652E+01, 2.9589675437E+00, 9.5513470027E-01],
	[3.2140000000E+04, 2.5375859030E+01, 4.6226400786E+00, 1.2170077724E+01, 2.9594302853E+00, 9.5515902998E-01],
	[3.2145000000E+04, 2.5382556987E+01, 4.6226469406E+00, 1.2176315022E+01, 2.9598928866E+00, 9.5518334569E-01],
	[3.2150000000E+04, 2.5389255669E+01, 4.6226538016E+00, 1.2182554546E+01, 2.9603553476E+00, 9.5520764741E-01],
	[3.2155000000E+04, 2.5395955077E+01, 4.6226606614E+00, 1.2188796296E+01, 2.9608176684E+00, 9.5523193515E-01],
	[3.2160000000E+04, 2.5402655211E+01, 4.6226675203E+00, 1.2195040272E+01, 2.9612798488E+00, 9.5525620892E-01],
	[3.2165000000E+04, 2.5409356071E+01, 4.6226743780E+00, 1.2201286475E+01, 2.9617418891E+00, 9.5528046874E-01],
	[3.2170000000E+04, 2.5416057656E+01, 4.6226812347E+00, 1.2207534906E+01, 2.9622037891E+00, 9.5530471459E-01],
	[3.2175000000E+04, 2.5422759967E+01, 4.6226880904E+00, 1.2213785565E+01, 2.9626655490E+00, 9.5532894651E-01],
	[3.2180000000E+04, 2.5429463003E+01, 4.6226949450E+00, 1.2220038452E+01, 2.9631271687E+00, 9.5535316448E-01],
	[3.2185000000E+04, 2.5436166765E+01, 4.6227017985E+00, 1.2226293568E+01, 2.9635886483E+00, 9.5537736853E-01],
	[3.2190000000E+04, 2.5442871252E+01, 4.6227086510E+00, 1.2232550913E+01, 2.9640499879E+00, 9.5540155866E-01],
	[3.2195000000E+04, 2.5449576465E+01, 4.6227155024E+00, 1.2238810488E+01, 2.9645111873E+00, 9.5542573488E-01],
	[3.2200000000E+04, 2.5456282403E+01, 4.6227223528E+00, 1.2245072294E+01, 2.9649722467E+00, 9.5544989719E-01],
	[3.2205000000E+04, 2.5462989066E+01, 4.6227292021E+00, 1.2251336329E+01, 2.9654331660E+00, 9.5547404561E-01],
	[3.2210000000E+04, 2.5469696455E+01, 4.6227360504E+00, 1.2257602596E+01, 2.9658939454E+00, 9.5549818015E-01],
	[3.2215000000E+04, 2.5476404570E+01, 4.6227428976E+00, 1.2263871095E+01, 2.9663545848E+00, 9.5552230081E-01],
	[3.2220000000E+04, 2.5483113409E+01, 4.6227497438E+00, 1.2270141825E+01, 2.9668150843E+00, 9.5554640759E-01],
	[3.2225000000E+04, 2.5489822974E+01, 4.6227565889E+00, 1.2276414788E+01, 2.9672754438E+00, 9.5557050052E-01],
	[3.2230000000E+04, 2.5496533264E+01, 4.6227634330E+00, 1.2282689983E+01, 2.9677356635E+00, 9.5559457959E-01],
	[3.2235000000E+04, 2.5503244279E+01, 4.6227702760E+00, 1.2288967412E+01, 2.9681957433E+00, 9.5561864482E-01],
	[3.2240000000E+04, 2.5509956019E+01, 4.6227771179E+00, 1.2295247075E+01, 2.9686556832E+00, 9.5564269622E-01],
	[3.2245000000E+04, 2.5516668484E+01, 4.6227839588E+00, 1.2301528972E+01, 2.9691154833E+00, 9.5566673378E-01],
	[3.2250000000E+04, 2.5523381675E+01, 4.6227907987E+00, 1.2307813103E+01, 2.9695751437E+00, 9.5569075753E-01],
	[3.2255000000E+04, 2.5530095590E+01, 4.6227976375E+00, 1.2314099470E+01, 2.9700346643E+00, 9.5571476747E-01],
	[3.2260000000E+04, 2.5536810231E+01, 4.6228044753E+00, 1.2320388072E+01, 2.9704940451E+00, 9.5573876360E-01],
	[3.2265000000E+04, 2.5543525596E+01, 4.6228113120E+00, 1.2326678910E+01, 2.9709532862E+00, 9.5576274595E-01],
	[3.2270000000E+04, 2.5550241687E+01, 4.6228181476E+00, 1.2332971985E+01, 2.9714123877E+00, 9.5578671450E-01],
	[3.2275000000E+04, 2.5556958502E+01, 4.6228249822E+00, 1.2339267297E+01, 2.9718713495E+00, 9.5581066928E-01],
	[3.2280000000E+04, 2.5563676042E+01, 4.6228318158E+00, 1.2345564846E+01, 2.9723301716E+00, 9.5583461029E-01],
	[3.2285000000E+04, 2.5570394307E+01, 4.6228386483E+00, 1.2351864632E+01, 2.9727888542E+00, 9.5585853754E-01],
	[3.2290000000E+04, 2.5577113297E+01, 4.6228454798E+00, 1.2358166657E+01, 2.9732473972E+00, 9.5588245104E-01],
	[3.2295000000E+04, 2.5583833012E+01, 4.6228523102E+00, 1.2364470921E+01, 2.9737058006E+00, 9.5590635079E-01],
	[3.2300000000E+04, 2.5590553451E+01, 4.6228591396E+00, 1.2370777423E+01, 2.9741640645E+00, 9.5593023681E-01],
	[3.2305000000E+04, 2.5597274615E+01, 4.6228659679E+00, 1.2377086166E+01, 2.9746221889E+00, 9.5595410910E-01],
	[3.2310000000E+04, 2.5603996504E+01, 4.6228727951E+00, 1.2383397148E+01, 2.9750801738E+00, 9.5597796768E-01],
	[3.2315000000E+04, 2.5610719117E+01, 4.6228796214E+00, 1.2389710371E+01, 2.9755380193E+00, 9.5600181254E-01],
	[3.2320000000E+04, 2.5617442455E+01, 4.6228864466E+00, 1.2396025835E+01, 2.9759957254E+00, 9.5602564370E-01],
	[3.2325000000E+04, 2.5624166517E+01, 4.6228932707E+00, 1.2402343540E+01, 2.9764532920E+00, 9.5604946117E-01],
	[3.2330000000E+04, 2.5630891304E+01, 4.6229000938E+00, 1.2408663487E+01, 2.9769107193E+00, 9.5607326494E-01],
	[3.2335000000E+04, 2.5637616816E+01, 4.6229069158E+00, 1.2414985676E+01, 2.9773680072E+00, 9.5609705504E-01],
	[3.2340000000E+04, 2.5644343052E+01, 4.6229137368E+00, 1.2421310108E+01, 2.9778251559E+00, 9.5612083147E-01],
	[3.2345000000E+04, 2.5651070012E+01, 4.6229205568E+00, 1.2427636783E+01, 2.9782821652E+00, 9.5614459423E-01],
	[3.2350000000E+04, 2.5657797697E+01, 4.6229273757E+00, 1.2433965702E+01, 2.9787390353E+00, 9.5616834333E-01],
	[3.2355000000E+04, 2.5664526106E+01, 4.6229341936E+00, 1.2440296865E+01, 2.9791957661E+00, 9.5619207879E-01],
	[3.2360000000E+04, 2.5671255240E+01, 4.6229410104E+00, 1.2446630272E+01, 2.9796523578E+00, 9.5621580060E-01],
	[3.2365000000E+04, 2.5677985097E+01, 4.6229478262E+00, 1.2452965924E+01, 2.9801088102E+00, 9.5623950878E-01],
	[3.2370000000E+04, 2.5684715680E+01, 4.6229546409E+00, 1.2459303822E+01, 2.9805651235E+00, 9.5626320333E-01],
	[3.2375000000E+04, 2.5691446986E+01, 4.6229614546E+00, 1.2465643966E+01, 2.9810212976E+00, 9.5628688426E-01],
	[3.2380000000E+04, 2.5698179016E+01, 4.6229682673E+00, 1.2471986355E+01, 2.9814773327E+00, 9.5631055157E-01],
	[3.2385000000E+04, 2.5704911771E+01, 4.6229750789E+00, 1.2478330992E+01, 2.9819332287E+00, 9.5633420529E-01],
	[3.2390000000E+04, 2.5711645250E+01, 4.6229818895E+00, 1.2484677876E+01, 2.9823889856E+00, 9.5635784540E-01],
	[3.2395000000E+04, 2.5718384078E+01, 4.6229893022E+00, 1.2491027008E+01, 2.9828449168E+00, 9.5638147193E-01],
	[3.2400000000E+04, 2.5725138891E+01, 4.6229987032E+00, 1.2497378387E+01, 2.9833017428E+00, 9.5640508488E-01],
	[3.2405000000E+04, 2.5731894435E+01, 4.6230081027E+00, 1.2503732015E+01, 2.9837584303E+00, 9.5642868425E-01],
	[3.2410000000E+04, 2.5738650711E+01, 4.6230175008E+00, 1.2510087893E+01, 2.9842149793E+00, 9.5645227005E-01],
	[3.2415000000E+04, 2.5745407718E+01, 4.6230268974E+00, 1.2516446019E+01, 2.9846713899E+00, 9.5647584229E-01],
	[3.2420000000E+04, 2.5752165456E+01, 4.6230362926E+00, 1.2522806396E+01, 2.9851276620E+00, 9.5649940098E-01],
	[3.2425000000E+04, 2.5758923926E+01, 4.6230456864E+00, 1.2529169023E+01, 2.9855837958E+00, 9.5652294613E-01],
	[3.2430000000E+04, 2.5765683126E+01, 4.6230550788E+00, 1.2535533900E+01, 2.9860397912E+00, 9.5654647774E-01],
	[3.2435000000E+04, 2.5772443058E+01, 4.6230644697E+00, 1.2541901029E+01, 2.9864956482E+00, 9.5656999582E-01],
	[3.2440000000E+04, 2.5779203721E+01, 4.6230738592E+00, 1.2548270410E+01, 2.9869513669E+00, 9.5659350038E-01],
	[3.2445000000E+04, 2.5785965115E+01, 4.6230832473E+00, 1.2554642043E+01, 2.9874069474E+00, 9.5661699143E-01],
	[3.2450000000E+04, 2.5792727241E+01, 4.6230926340E+00, 1.2561015928E+01, 2.9878623895E+00, 9.5664046896E-01],
	[3.2455000000E+04, 2.5799490097E+01, 4.6231020192E+00, 1.2567392067E+01, 2.9883176935E+00, 9.5666393300E-01],
	[3.2460000000E+04, 2.5806253684E+01, 4.6231114030E+00, 1.2573770459E+01, 2.9887728592E+00, 9.5668738355E-01],
	[3.2465000000E+04, 2.5813018002E+01, 4.6231207853E+00, 1.2580151105E+01, 2.9892278868E+00, 9.5671082061E-01],
	[3.2470000000E+04, 2.5819783052E+01, 4.6231301663E+00, 1.2586534005E+01, 2.9896827762E+00, 9.5673424420E-01],
	[3.2475000000E+04, 2.5826548832E+01, 4.6231395458E+00, 1.2592919160E+01, 2.9901375274E+00, 9.5675765432E-01],
	[3.2480000000E+04, 2.5833315343E+01, 4.6231489239E+00, 1.2599306570E+01, 2.9905921406E+00, 9.5678105097E-01],
	[3.2485000000E+04, 2.5840082584E+01, 4.6231583006E+00, 1.2605696237E+01, 2.9910466157E+00, 9.5680443417E-01],
	[3.2490000000E+04, 2.5846850557E+01, 4.6231676758E+00, 1.2612088159E+01, 2.9915009527E+00, 9.5682780393E-01],
	[3.2495000000E+04, 2.5853619260E+01, 4.6231770496E+00, 1.2618482338E+01, 2.9919551517E+00, 9.5685116024E-01],
	[3.2500000000E+04, 2.5860388695E+01, 4.6231864220E+00, 1.2624878774E+01, 2.9924092127E+00, 9.5687450313E-01],
	[3.2505000000E+04, 2.5867158859E+01, 4.6231957930E+00, 1.2631277468E+01, 2.9928631358E+00, 9.5689783259E-01],
	[3.2510000000E+04, 2.5873929755E+01, 4.6232051625E+00, 1.2637678419E+01, 2.9933169209E+00, 9.5692114863E-01],
	[3.2515000000E+04, 2.5880701381E+01, 4.6232145307E+00, 1.2644081629E+01, 2.9937705681E+00, 9.5694445127E-01],
	[3.2520000000E+04, 2.5887473738E+01, 4.6232238974E+00, 1.2650487098E+01, 2.9942240774E+00, 9.5696774050E-01],
	[3.2525000000E+04, 2.5894246825E+01, 4.6232332627E+00, 1.2656894827E+01, 2.9946774488E+00, 9.5699101634E-01],
	[3.2530000000E+04, 2.5901020643E+01, 4.6232426265E+00, 1.2663304815E+01, 2.9951306824E+00, 9.5701427880E-01],
	[3.2535000000E+04, 2.5907795191E+01, 4.6232519890E+00, 1.2669717063E+01, 2.9955837782E+00, 9.5703752787E-01],
	[3.2540000000E+04, 2.5914570470E+01, 4.6232613500E+00, 1.2676131572E+01, 2.9960367362E+00, 9.5706076358E-01],
	[3.2545000000E+04, 2.5921346480E+01, 4.6232707096E+00, 1.2682548342E+01, 2.9964895564E+00, 9.5708398592E-01],
	[3.2550000000E+04, 2.5928123219E+01, 4.6232800678E+00, 1.2688967374E+01, 2.9969422390E+00, 9.5710719490E-01],
	[3.2555000000E+04, 2.5934900689E+01, 4.6232894246E+00, 1.2695388667E+01, 2.9973947838E+00, 9.5713039054E-01],
	[3.2560000000E+04, 2.5941678890E+01, 4.6232987799E+00, 1.2701812224E+01, 2.9978471910E+00, 9.5715357283E-01],
	[3.2565000000E+04, 2.5948457821E+01, 4.6233081339E+00, 1.2708238043E+01, 2.9982994605E+00, 9.5717674179E-01],
	[3.2570000000E+04, 2.5955237482E+01, 4.6233174864E+00, 1.2714666125E+01, 2.9987515923E+00, 9.5719989743E-01],
	[3.2575000000E+04, 2.5962017873E+01, 4.6233268375E+00, 1.2721096472E+01, 2.9992035866E+00, 9.5722303974E-01],
	[3.2580000000E+04, 2.5968798994E+01, 4.6233361872E+00, 1.2727529082E+01, 2.9996554434E+00, 9.5724616875E-01],
	[3.2585000000E+04, 2.5975580846E+01, 4.6233455354E+00, 1.2733963958E+01, 3.0001071626E+00, 9.5726928445E-01],
	[3.2590000000E+04, 2.5982363428E+01, 4.6233548823E+00, 1.2740401098E+01, 3.0005587442E+00, 9.5729238686E-01],
	[3.2595000000E+04, 2.5989146739E+01, 4.6233642277E+00, 1.2746840504E+01, 3.0010101884E+00, 9.5731547597E-01],
	[3.2600000000E+04, 2.5995930781E+01, 4.6233735717E+00, 1.2753282176E+01, 3.0014614952E+00, 9.5733855181E-01],
	[3.2605000000E+04, 2.6002715553E+01, 4.6233829143E+00, 1.2759726115E+01, 3.0019126645E+00, 9.5736161438E-01],
	[3.2610000000E+04, 2.6009501055E+01, 4.6233922555E+00, 1.2766172321E+01, 3.0023636964E+00, 9.5738466367E-01],
	[3.2615000000E+04, 2.6016287287E+01, 4.6234015953E+00, 1.2772620794E+01, 3.0028145909E+00, 9.5740769971E-01],
	[3.2620000000E+04, 2.6023074249E+01, 4.6234109337E+00, 1.2779071535E+01, 3.0032653481E+00, 9.5743072250E-01],
	[3.2625000000E+04, 2.6029861941E+01, 4.6234202707E+00, 1.2785524544E+01, 3.0037159679E+00, 9.5745373205E-01],
	[3.2630000000E+04, 2.6036650363E+01, 4.6234296062E+00, 1.2791979823E+01, 3.0041664505E+00, 9.5747672836E-01],
	[3.2635000000E+04, 2.6043439514E+01, 4.6234389403E+00, 1.2798437370E+01, 3.0046167958E+00, 9.5749971144E-01],
	[3.2640000000E+04, 2.6050229395E+01, 4.6234482731E+00, 1.2804897187E+01, 3.0050670038E+00, 9.5752268130E-01],
	[3.2645000000E+04, 2.6057020007E+01, 4.6234576044E+00, 1.2811359274E+01, 3.0055170747E+00, 9.5754563795E-01],
	[3.2650000000E+04, 2.6063811347E+01, 4.6234669343E+00, 1.2817823632E+01, 3.0059670083E+00, 9.5756858139E-01],
	[3.2655000000E+04, 2.6070603418E+01, 4.6234762628E+00, 1.2824290261E+01, 3.0064168048E+00, 9.5759151163E-01],
	[3.2660000000E+04, 2.6077396218E+01, 4.6234855898E+00, 1.2830759161E+01, 3.0068664642E+00, 9.5761442869E-01],
	[3.2665000000E+04, 2.6084189748E+01, 4.6234949155E+00, 1.2837230333E+01, 3.0073159864E+00, 9.5763733256E-01],
	[3.2670000000E+04, 2.6090984007E+01, 4.6235042398E+00, 1.2843703778E+01, 3.0077653716E+00, 9.5766022325E-01],
	[3.2675000000E+04, 2.6097778996E+01, 4.6235135626E+00, 1.2850179495E+01, 3.0082146197E+00, 9.5768310078E-01],
	[3.2680000000E+04, 2.6104574715E+01, 4.6235228841E+00, 1.2856657486E+01, 3.0086637309E+00, 9.5770596515E-01],
	[3.2685000000E+04, 2.6111371163E+01, 4.6235322041E+00, 1.2863137750E+01, 3.0091127050E+00, 9.5772881636E-01],
	[3.2690000000E+04, 2.6118168340E+01, 4.6235415228E+00, 1.2869620288E+01, 3.0095615421E+00, 9.5775165443E-01],
	[3.2695000000E+04, 2.6124966247E+01, 4.6235508400E+00, 1.2876105102E+01, 3.0100102423E+00, 9.5777447936E-01],
	[3.2700000000E+04, 2.6131764884E+01, 4.6235601558E+00, 1.2882592190E+01, 3.0104588056E+00, 9.5779729116E-01],
	[3.2705000000E+04, 2.6138564249E+01, 4.6235694702E+00, 1.2889081554E+01, 3.0109072321E+00, 9.5782008984E-01],
	[3.2710000000E+04, 2.6145364345E+01, 4.6235787832E+00, 1.2895573193E+01, 3.0113555216E+00, 9.5784287540E-01],
	[3.2715000000E+04, 2.6152165169E+01, 4.6235880948E+00, 1.2902067109E+01, 3.0118036744E+00, 9.5786564785E-01],
	[3.2720000000E+04, 2.6158966723E+01, 4.6235974050E+00, 1.2908563302E+01, 3.0122516903E+00, 9.5788840721E-01],
	[3.2725000000E+04, 2.6165769005E+01, 4.6236067138E+00, 1.2915061773E+01, 3.0126995695E+00, 9.5791115347E-01],
	[3.2730000000E+04, 2.6172572018E+01, 4.6236160212E+00, 1.2921562521E+01, 3.0131473119E+00, 9.5793388665E-01],
	[3.2735000000E+04, 2.6179375759E+01, 4.6236253272E+00, 1.2928065547E+01, 3.0135949176E+00, 9.5795660674E-01],
	[3.2740000000E+04, 2.6186180229E+01, 4.6236346318E+00, 1.2934570852E+01, 3.0140423866E+00, 9.5797931377E-01],
	[3.2745000000E+04, 2.6192985429E+01, 4.6236439350E+00, 1.2941078436E+01, 3.0144897189E+00, 9.5800200774E-01],
	[3.2750000000E+04, 2.6199791357E+01, 4.6236532368E+00, 1.2947588300E+01, 3.0149369146E+00, 9.5802468865E-01],
	[3.2755000000E+04, 2.6206598015E+01, 4.6236625372E+00, 1.2954100444E+01, 3.0153839737E+00, 9.5804735651E-01],
	[3.2760000000E+04, 2.6213405402E+01, 4.6236718362E+00, 1.2960614868E+01, 3.0158308962E+00, 9.5807001133E-01],
	[3.2765000000E+04, 2.6220213517E+01, 4.6236811337E+00, 1.2967131573E+01, 3.0162776822E+00, 9.5809265312E-01],
	[3.2770000000E+04, 2.6227022362E+01, 4.6236904299E+00, 1.2973650560E+01, 3.0167243316E+00, 9.5811528189E-01],
	[3.2775000000E+04, 2.6233831935E+01, 4.6236997247E+00, 1.2980171828E+01, 3.0171708446E+00, 9.5813789763E-01],
	[3.2780000000E+04, 2.6240642237E+01, 4.6237090181E+00, 1.2986695379E+01, 3.0176172210E+00, 9.5816050037E-01],
	[3.2785000000E+04, 2.6247453269E+01, 4.6237183101E+00, 1.2993221212E+01, 3.0180634611E+00, 9.5818309010E-01],
	[3.2790000000E+04, 2.6254265029E+01, 4.6237276007E+00, 1.2999749329E+01, 3.0185095647E+00, 9.5820566684E-01],
	[3.2795000000E+04, 2.6261077517E+01, 4.6237368898E+00, 1.3006279729E+01, 3.0189555319E+00, 9.5822823060E-01],
	[3.2800000000E+04, 2.6267890735E+01, 4.6237461776E+00, 1.3012812413E+01, 3.0194013628E+00, 9.5825078137E-01],
	[3.2805000000E+04, 2.6274704681E+01, 4.6237554640E+00, 1.3019347382E+01, 3.0198470573E+00, 9.5827331917E-01],
	[3.2810000000E+04, 2.6281519356E+01, 4.6237647490E+00, 1.3025884636E+01, 3.0202926156E+00, 9.5829584400E-01],
	[3.2815000000E+04, 2.6288334759E+01, 4.6237740326E+00, 1.3032424175E+01, 3.0207380375E+00, 9.5831835588E-01],
	[3.2820000000E+04, 2.6295150891E+01, 4.6237833148E+00, 1.3038966000E+01, 3.0211833233E+00, 9.5834085480E-01],
	[3.2825000000E+04, 2.6301967752E+01, 4.6237925956E+00, 1.3045510111E+01, 3.0216284728E+00, 9.5836334079E-01],
	[3.2830000000E+04, 2.6308785341E+01, 4.6238018751E+00, 1.3052056509E+01, 3.0220734861E+00, 9.5838581383E-01],
	[3.2835000000E+04, 2.6315603659E+01, 4.6238111531E+00, 1.3058605195E+01, 3.0225183632E+00, 9.5840827395E-01],
	[3.2840000000E+04, 2.6322422705E+01, 4.6238204297E+00, 1.3065156168E+01, 3.0229631042E+00, 9.5843072116E-01],
	[3.2845000000E+04, 2.6329242480E+01, 4.6238297049E+00, 1.3071709429E+01, 3.0234077092E+00, 9.5845315544E-01],
	[3.2850000000E+04, 2.6336062983E+01, 4.6238389788E+00, 1.3078264979E+01, 3.0238521780E+00, 9.5847557683E-01],
	[3.2855000000E+04, 2.6342884214E+01, 4.6238482512E+00, 1.3084822818E+01, 3.0242965108E+00, 9.5849798531E-01],
	[3.2860000000E+04, 2.6349706174E+01, 4.6238575223E+00, 1.3091382946E+01, 3.0247407075E+00, 9.5852038091E-01],
	[3.2865000000E+04, 2.6356528862E+01, 4.6238667919E+00, 1.3097945364E+01, 3.0251847683E+00, 9.5854276362E-01],
	[3.2870000000E+04, 2.6363352279E+01, 4.6238760602E+00, 1.3104510073E+01, 3.0256286931E+00, 9.5856513346E-01],
	[3.2875000000E+04, 2.6370176423E+01, 4.6238853271E+00, 1.3111077072E+01, 3.0260724819E+00, 9.5858749043E-01],
	[3.2880000000E+04, 2.6377001296E+01, 4.6238945926E+00, 1.3117646363E+01, 3.0265161349E+00, 9.5860983454E-01],
	[3.2885000000E+04, 2.6383826897E+01, 4.6239038567E+00, 1.3124217946E+01, 3.0269596520E+00, 9.5863216580E-01],
	[3.2890000000E+04, 2.6390653226E+01, 4.6239131194E+00, 1.3130791820E+01, 3.0274030332E+00, 9.5865448421E-01],
	[3.2895000000E+04, 2.6397480283E+01, 4.6239223807E+00, 1.3137367988E+01, 3.0278462786E+00, 9.5867678979E-01],
	[3.2900000000E+04, 2.6404308069E+01, 4.6239316406E+00, 1.3143946448E+01, 3.0282893882E+00, 9.5869908253E-01],
	[3.2905000000E+04, 2.6411136582E+01, 4.6239408992E+00, 1.3150527202E+01, 3.0287323620E+00, 9.5872136245E-01],
	[3.2910000000E+04, 2.6417965824E+01, 4.6239501563E+00, 1.3157110250E+01, 3.0291752001E+00, 9.5874362956E-01],
	[3.2915000000E+04, 2.6424795793E+01, 4.6239594121E+00, 1.3163695592E+01, 3.0296179024E+00, 9.5876588386E-01],
	[3.2920000000E+04, 2.6431644847E+01, 4.6239710293E+00, 1.3170283230E+01, 3.0300617250E+00, 9.5878812536E-01],
	[3.2925000000E+04, 2.6438495948E+01, 4.6239828136E+00, 1.3176873162E+01, 3.0305055021E+00, 9.5881035407E-01],
	[3.2930000000E+04, 2.6445347784E+01, 4.6239945961E+00, 1.3183465391E+01, 3.0309491439E+00, 9.5883256999E-01],
	[3.2935000000E+04, 2.6452200355E+01, 4.6240063768E+00, 1.3190059915E+01, 3.0313926506E+00, 9.5885477313E-01],
	[3.2940000000E+04, 2.6459053661E+01, 4.6240181558E+00, 1.3196656737E+01, 3.0318360222E+00, 9.5887696351E-01],
	[3.2945000000E+04, 2.6465907702E+01, 4.6240299330E+00, 1.3203255855E+01, 3.0322792587E+00, 9.5889914112E-01],
	[3.2950000000E+04, 2.6472762478E+01, 4.6240417084E+00, 1.3209857272E+01, 3.0327223601E+00, 9.5892130597E-01],
	[3.2955000000E+04, 2.6479617988E+01, 4.6240534822E+00, 1.3216460986E+01, 3.0331653264E+00, 9.5894345808E-01],
	[3.2960000000E+04, 2.6486474234E+01, 4.6240652541E+00, 1.3223066998E+01, 3.0336081578E+00, 9.5896559745E-01],
	[3.2965000000E+04, 2.6493331214E+01, 4.6240770243E+00, 1.3229675310E+01, 3.0340508542E+00, 9.5898772408E-01],
	[3.2970000000E+04, 2.6500188930E+01, 4.6240887927E+00, 1.3236285921E+01, 3.0344934156E+00, 9.5900983799E-01],
	[3.2975000000E+04, 2.6507047380E+01, 4.6241005594E+00, 1.3242898832E+01, 3.0349358420E+00, 9.5903193919E-01],
	[3.2980000000E+04, 2.6513906565E+01, 4.6241123243E+00, 1.3249514043E+01, 3.0353781336E+00, 9.5905402767E-01],
	[3.2985000000E+04, 2.6520766484E+01, 4.6241240875E+00, 1.3256131555E+01, 3.0358202903E+00, 9.5907610344E-01],
	[3.2990000000E+04, 2.6527627138E+01, 4.6241358489E+00, 1.3262751368E+01, 3.0362623121E+00, 9.5909816653E-01],
	[3.2995000000E+04, 2.6534488527E+01, 4.6241476086E+00, 1.3269373483E+01, 3.0367041992E+00, 9.5912021692E-01],
	[3.3000000000E+04, 2.6541350651E+01, 4.6241593665E+00, 1.3275997900E+01, 3.0371459514E+00, 9.5914225464E-01],
	[3.3005000000E+04, 2.6548213509E+01, 4.6241711227E+00, 1.3282624620E+01, 3.0375875689E+00, 9.5916427968E-01],
	[3.3010000000E+04, 2.6555077101E+01, 4.6241828771E+00, 1.3289253642E+01, 3.0380290516E+00, 9.5918629205E-01],
	[3.3015000000E+04, 2.6561941428E+01, 4.6241946298E+00, 1.3295884968E+01, 3.0384703997E+00, 9.5920829177E-01],
	[3.3020000000E+04, 2.6568806490E+01, 4.6242063807E+00, 1.3302518598E+01, 3.0389116130E+00, 9.5923027884E-01],
	[3.3025000000E+04, 2.6575672286E+01, 4.6242181298E+00, 1.3309154532E+01, 3.0393526917E+00, 9.5925225326E-01],
	[3.3030000000E+04, 2.6582538817E+01, 4.6242298773E+00, 1.3315792772E+01, 3.0397936358E+00, 9.5927421505E-01],
	[3.3035000000E+04, 2.6589406081E+01, 4.6242416229E+00, 1.3322433316E+01, 3.0402344453E+00, 9.5929616421E-01],
	[3.3040000000E+04, 2.6596274081E+01, 4.6242533668E+00, 1.3329076166E+01, 3.0406751203E+00, 9.5931810075E-01],
	[3.3045000000E+04, 2.6603142814E+01, 4.6242651090E+00, 1.3335721322E+01, 3.0411156607E+00, 9.5934002467E-01],
	[3.3050000000E+04, 2.6610012282E+01, 4.6242768494E+00, 1.3342368785E+01, 3.0415560665E+00, 9.5936193599E-01],
	[3.3055000000E+04, 2.6616882484E+01, 4.6242885881E+00, 1.3349018555E+01, 3.0419963380E+00, 9.5938383471E-01],
	[3.3060000000E+04, 2.6623753420E+01, 4.6243003250E+00, 1.3355670633E+01, 3.0424364749E+00, 9.5940572084E-01],
	[3.3065000000E+04, 2.6630625091E+01, 4.6243120602E+00, 1.3362325018E+01, 3.0428764775E+00, 9.5942759439E-01],
	[3.3070000000E+04, 2.6637497496E+01, 4.6243237937E+00, 1.3368981712E+01, 3.0433163456E+00, 9.5944945536E-01],
	[3.3075000000E+04, 2.6644370634E+01, 4.6243355254E+00, 1.3375640715E+01, 3.0437560794E+00, 9.5947130376E-01],
	[3.3080000000E+04, 2.6651244507E+01, 4.6243472553E+00, 1.3382302027E+01, 3.0441956789E+00, 9.5949313960E-01],
	[3.3085000000E+04, 2.6658119114E+01, 4.6243589835E+00, 1.3388965649E+01, 3.0446351440E+00, 9.5951496288E-01],
	[3.3090000000E+04, 2.6664994455E+01, 4.6243707100E+00, 1.3395631581E+01, 3.0450744749E+00, 9.5953677362E-01],
	[3.3095000000E+04, 2.6671870530E+01, 4.6243824347E+00, 1.3402299824E+01, 3.0455136715E+00, 9.5955857183E-01],
	[3.3100000000E+04, 2.6678747339E+01, 4.6243941577E+00, 1.3408970378E+01, 3.0459527339E+00, 9.5958035750E-01],
	[3.3105000000E+04, 2.6685624882E+01, 4.6244058790E+00, 1.3415643244E+01, 3.0463916621E+00, 9.5960213064E-01],
	[3.3110000000E+04, 2.6692503159E+01, 4.6244175985E+00, 1.3422318421E+01, 3.0468304561E+00, 9.5962389127E-01],
	[3.3115000000E+04, 2.6699382169E+01, 4.6244293162E+00, 1.3428995911E+01, 3.0472691160E+00, 9.5964563939E-01],
	[3.3120000000E+04, 2.6706261914E+01, 4.6244410323E+00, 1.3435675714E+01, 3.0477076418E+00, 9.5966737501E-01],
	[3.3125000000E+04, 2.6713142392E+01, 4.6244527466E+00, 1.3442357831E+01, 3.0481460335E+00, 9.5968909813E-01],
	[3.3130000000E+04, 2.6720023604E+01, 4.6244644591E+00, 1.3449042261E+01, 3.0485842911E+00, 9.5971080877E-01],
	[3.3135000000E+04, 2.6726905550E+01, 4.6244761699E+00, 1.3455729006E+01, 3.0490224148E+00, 9.5973250693E-01],
	[3.3140000000E+04, 2.6733788229E+01, 4.6244878790E+00, 1.3462418065E+01, 3.0494604044E+00, 9.5975419261E-01],
	[3.3145000000E+04, 2.6740671643E+01, 4.6244995863E+00, 1.3469109440E+01, 3.0498982601E+00, 9.5977586583E-01],
	[3.3150000000E+04, 2.6747555789E+01, 4.6245112919E+00, 1.3475803130E+01, 3.0503359818E+00, 9.5979752660E-01],
	[3.3155000000E+04, 2.6754440670E+01, 4.6245229958E+00, 1.3482499136E+01, 3.0507735697E+00, 9.5981917491E-01],
	[3.3160000000E+04, 2.6761326284E+01, 4.6245346979E+00, 1.3489197459E+01, 3.0512110236E+00, 9.5984081079E-01],
	[3.3165000000E+04, 2.6768212631E+01, 4.6245463983E+00, 1.3495898099E+01, 3.0516483437E+00, 9.5986243422E-01],
	[3.3170000000E+04, 2.6775099712E+01, 4.6245580970E+00, 1.3502601056E+01, 3.0520855300E+00, 9.5988404523E-01],
	[3.3175000000E+04, 2.6781987527E+01, 4.6245697939E+00, 1.3509306332E+01, 3.0525225825E+00, 9.5990564382E-01],
	[3.3180000000E+04, 2.6788876075E+01, 4.6245814891E+00, 1.3516013925E+01, 3.0529595012E+00, 9.5992723000E-01],
	[3.3185000000E+04, 2.6795765356E+01, 4.6245931826E+00, 1.3522723838E+01, 3.0533962862E+00, 9.5994880377E-01],
	[3.3190000000E+04, 2.6802655371E+01, 4.6246048743E+00, 1.3529436070E+01, 3.0538329375E+00, 9.5997036515E-01],
	[3.3195000000E+04, 2.6809546119E+01, 4.6246165643E+00, 1.3536150621E+01, 3.0542694552E+00, 9.5999191413E-01],
	[3.3200000000E+04, 2.6816437600E+01, 4.6246282525E+00, 1.3542867493E+01, 3.0547058391E+00, 9.6001345073E-01],
	[3.3205000000E+04, 2.6823329815E+01, 4.6246399391E+00, 1.3549586685E+01, 3.0551420895E+00, 9.6003497496E-01],
	[3.3210000000E+04, 2.6830222763E+01, 4.6246516239E+00, 1.3556308199E+01, 3.0555782062E+00, 9.6005648682E-01],
	[3.3215000000E+04, 2.6837116444E+01, 4.6246633070E+00, 1.3563032033E+01, 3.0560141894E+00, 9.6007798631E-01],
	[3.3220000000E+04, 2.6844010858E+01, 4.6246749883E+00, 1.3569758190E+01, 3.0564500391E+00, 9.6009947346E-01],
	[3.3225000000E+04, 2.6850906006E+01, 4.6246866679E+00, 1.3576486670E+01, 3.0568857553E+00, 9.6012094825E-01],
	[3.3230000000E+04, 2.6857801886E+01, 4.6246983458E+00, 1.3583217472E+01, 3.0573213380E+00, 9.6014241071E-01],
	[3.3235000000E+04, 2.6864698500E+01, 4.6247100220E+00, 1.3589950598E+01, 3.0577567872E+00, 9.6016386084E-01],
	[3.3240000000E+04, 2.6871595847E+01, 4.6247216964E+00, 1.3596686047E+01, 3.0581921030E+00, 9.6018529865E-01],
	[3.3245000000E+04, 2.6878493927E+01, 4.6247333691E+00, 1.3603423820E+01, 3.0586272855E+00, 9.6020672414E-01],
	[3.3250000000E+04, 2.6885392739E+01, 4.6247450401E+00, 1.3610163919E+01, 3.0590623345E+00, 9.6022813731E-01],
	[3.3255000000E+04, 2.6892292285E+01, 4.6247567094E+00, 1.3616906342E+01, 3.0594972503E+00, 9.6024953819E-01],
	[3.3260000000E+04, 2.6899192564E+01, 4.6247683769E+00, 1.3623651091E+01, 3.0599320328E+00, 9.6027092678E-01],
	[3.3265000000E+04, 2.6906093575E+01, 4.6247800427E+00, 1.3630398166E+01, 3.0603666819E+00, 9.6029230307E-01],
	[3.3270000000E+04, 2.6912995320E+01, 4.6247917068E+00, 1.3637147568E+01, 3.0608011979E+00, 9.6031366709E-01],
	[3.3275000000E+04, 2.6919897797E+01, 4.6248033691E+00, 1.3643899297E+01, 3.0612355806E+00, 9.6033501884E-01],
	[3.3280000000E+04, 2.6926801007E+01, 4.6248150298E+00, 1.3650653353E+01, 3.0616698302E+00, 9.6035635832E-01],
	[3.3285000000E+04, 2.6933704950E+01, 4.6248266887E+00, 1.3657409737E+01, 3.0621039465E+00, 9.6037768554E-01],
	[3.3290000000E+04, 2.6940609625E+01, 4.6248383459E+00, 1.3664168449E+01, 3.0625379298E+00, 9.6039900052E-01],
	[3.3295000000E+04, 2.6947515034E+01, 4.6248500014E+00, 1.3670929490E+01, 3.0629717800E+00, 9.6042030325E-01],
	[3.3300000000E+04, 2.6954421174E+01, 4.6248616551E+00, 1.3677692860E+01, 3.0634054971E+00, 9.6044159374E-01],
	[3.3305000000E+04, 2.6961328048E+01, 4.6248733071E+00, 1.3684458560E+01, 3.0638390811E+00, 9.6046287201E-01],
	[3.3310000000E+04, 2.6968235654E+01, 4.6248849575E+00, 1.3691226590E+01, 3.0642725322E+00, 9.6048413806E-01],
	[3.3315000000E+04, 2.6975143993E+01, 4.6248966060E+00, 1.3697996950E+01, 3.0647058503E+00, 9.6050539190E-01],
	[3.3320000000E+04, 2.6982053064E+01, 4.6249082529E+00, 1.3704769642E+01, 3.0651390354E+00, 9.6052663353E-01],
	[3.3325000000E+04, 2.6988962868E+01, 4.6249198981E+00, 1.3711544665E+01, 3.0655720876E+00, 9.6054786296E-01],
	[3.3330000000E+04, 2.6995873404E+01, 4.6249315415E+00, 1.3718322020E+01, 3.0660050069E+00, 9.6056908020E-01],
	[3.3335000000E+04, 2.7002784673E+01, 4.6249431832E+00, 1.3725101707E+01, 3.0664377933E+00, 9.6059028526E-01],
	[3.3340000000E+04, 2.7009696674E+01, 4.6249548232E+00, 1.3731883728E+01, 3.0668704470E+00, 9.6061147814E-01],
	[3.3345000000E+04, 2.7016609407E+01, 4.6249664615E+00, 1.3738668081E+01, 3.0673029678E+00, 9.6063265886E-01],
	[3.3350000000E+04, 2.7023522873E+01, 4.6249780981E+00, 1.3745454768E+01, 3.0677353558E+00, 9.6065382741E-01],
	[3.3355000000E+04, 2.7030437071E+01, 4.6249897329E+00, 1.3752243790E+01, 3.0681676111E+00, 9.6067498381E-01],
	[3.3360000000E+04, 2.7037352001E+01, 4.6250013661E+00, 1.3759035146E+01, 3.0685997337E+00, 9.6069612806E-01],
	[3.3365000000E+04, 2.7044267664E+01, 4.6250129975E+00, 1.3765828837E+01, 3.0690317236E+00, 9.6071726017E-01],
	[3.3370000000E+04, 2.7051184059E+01, 4.6250246272E+00, 1.3772624864E+01, 3.0694635808E+00, 9.6073838015E-01],
	[3.3375000000E+04, 2.7058101186E+01, 4.6250362552E+00, 1.3779423227E+01, 3.0698953054E+00, 9.6075948800E-01],
	[3.3380000000E+04, 2.7065019045E+01, 4.6250478815E+00, 1.3786223926E+01, 3.0703268974E+00, 9.6078058374E-01],
	[3.3385000000E+04, 2.7071937636E+01, 4.6250595061E+00, 1.3793026962E+01, 3.0707583568E+00, 9.6080166737E-01],
	[3.3390000000E+04, 2.7078856960E+01, 4.6250711290E+00, 1.3799832336E+01, 3.0711896837E+00, 9.6082273890E-01],
	[3.3395000000E+04, 2.7085777015E+01, 4.6250827501E+00, 1.3806640047E+01, 3.0716208781E+00, 9.6084379833E-01],
	[3.3400000000E+04, 2.7092697803E+01, 4.6250943695E+00, 1.3813450097E+01, 3.0720519400E+00, 9.6086484567E-01],
	[3.3405000000E+04, 2.7099619322E+01, 4.6251059873E+00, 1.3820262485E+01, 3.0724828695E+00, 9.6088588093E-01],
	[3.3410000000E+04, 2.7106541573E+01, 4.6251176033E+00, 1.3827077213E+01, 3.0729136665E+00, 9.6090690412E-01],
	[3.3415000000E+04, 2.7113464557E+01, 4.6251292176E+00, 1.3833894280E+01, 3.0733443311E+00, 9.6092791525E-01],
	[3.3420000000E+04, 2.7120388272E+01, 4.6251408302E+00, 1.3840713688E+01, 3.0737748634E+00, 9.6094891431E-01],
	[3.3425000000E+04, 2.7127312719E+01, 4.6251524411E+00, 1.3847535435E+01, 3.0742052633E+00, 9.6096990132E-01],
	[3.3430000000E+04, 2.7134237898E+01, 4.6251640503E+00, 1.3854359524E+01, 3.0746355310E+00, 9.6099087629E-01],
	[3.3435000000E+04, 2.7141163809E+01, 4.6251756578E+00, 1.3861185954E+01, 3.0750656663E+00, 9.6101183923E-01],
	[3.3440000000E+04, 2.7148090451E+01, 4.6251872636E+00, 1.3868014727E+01, 3.0754956695E+00, 9.6103279013E-01],
	[3.3445000000E+04, 2.7155017826E+01, 4.6251988676E+00, 1.3874845841E+01, 3.0759255404E+00, 9.6105372901E-01],
	[3.3450000000E+04, 2.7161964502E+01, 4.6252128306E+00, 1.3881679298E+01, 3.0763565616E+00, 9.6107465588E-01],
	[3.3455000000E+04, 2.7168912794E+01, 4.6252269030E+00, 1.3888515099E+01, 3.0767875117E+00, 9.6109557074E-01],
	[3.3460000000E+04, 2.7175861824E+01, 4.6252409734E+00, 1.3895353243E+01, 3.0772183301E+00, 9.6111647360E-01],
	[3.3465000000E+04, 2.7182811593E+01, 4.6252550417E+00, 1.3902193732E+01, 3.0776490168E+00, 9.6113736447E-01],
	[3.3470000000E+04, 2.7189762101E+01, 4.6252691079E+00, 1.3909036565E+01, 3.0780795718E+00, 9.6115824335E-01],
	[3.3475000000E+04, 2.7196713347E+01, 4.6252831721E+00, 1.3915881743E+01, 3.0785099952E+00, 9.6117911026E-01],
	[3.3480000000E+04, 2.7203665332E+01, 4.6252972342E+00, 1.3922729267E+01, 3.0789402870E+00, 9.6119996519E-01],
	[3.3485000000E+04, 2.7210618055E+01, 4.6253112942E+00, 1.3929579136E+01, 3.0793704473E+00, 9.6122080816E-01],
	[3.3490000000E+04, 2.7217571517E+01, 4.6253253522E+00, 1.3936431352E+01, 3.0798004760E+00, 9.6124163918E-01],
	[3.3495000000E+04, 2.7224525717E+01, 4.6253394082E+00, 1.3943285915E+01, 3.0802303732E+00, 9.6126245824E-01],
	[3.3500000000E+04, 2.7231480656E+01, 4.6253534621E+00, 1.3950142826E+01, 3.0806601390E+00, 9.6128326537E-01],
	[3.3505000000E+04, 2.7238436333E+01, 4.6253675139E+00, 1.3957002084E+01, 3.0810897733E+00, 9.6130406056E-01],
	[3.3510000000E+04, 2.7245392748E+01, 4.6253815637E+00, 1.3963863690E+01, 3.0815192762E+00, 9.6132484382E-01],
	[3.3515000000E+04, 2.7252349902E+01, 4.6253956114E+00, 1.3970727645E+01, 3.0819486477E+00, 9.6134561516E-01],
	[3.3520000000E+04, 2.7259307794E+01, 4.6254096570E+00, 1.3977593949E+01, 3.0823778878E+00, 9.6136637459E-01],
	[3.3525000000E+04, 2.7266266424E+01, 4.6254237007E+00, 1.3984462603E+01, 3.0828069966E+00, 9.6138712212E-01],
	[3.3530000000E+04, 2.7273225793E+01, 4.6254377422E+00, 1.3991333607E+01, 3.0832359741E+00, 9.6140785775E-01],
	[3.3535000000E+04, 2.7280185899E+01, 4.6254517817E+00, 1.3998206961E+01, 3.0836648204E+00, 9.6142858149E-01],
	[3.3540000000E+04, 2.7287146744E+01, 4.6254658192E+00, 1.4005082666E+01, 3.0840935354E+00, 9.6144929334E-01],
	[3.3545000000E+04, 2.7294108327E+01, 4.6254798546E+00, 1.4011960723E+01, 3.0845221192E+00, 9.6146999332E-01],
	[3.3550000000E+04, 2.7301070648E+01, 4.6254938880E+00, 1.4018841132E+01, 3.0849505718E+00, 9.6149068143E-01],
	[3.3555000000E+04, 2.7308033707E+01, 4.6255079193E+00, 1.4025723893E+01, 3.0853788933E+00, 9.6151135767E-01],
	[3.3560000000E+04, 2.7314997504E+01, 4.6255219486E+00, 1.4032609006E+01, 3.0858070836E+00, 9.6153202206E-01],
	[3.3565000000E+04, 2.7321962039E+01, 4.6255359758E+00, 1.4039496473E+01, 3.0862351429E+00, 9.6155267459E-01],
	[3.3570000000E+04, 2.7328927312E+01, 4.6255500010E+00, 1.4046386294E+01, 3.0866630711E+00, 9.6157331529E-01],
	[3.3575000000E+04, 2.7335893323E+01, 4.6255640241E+00, 1.4053278469E+01, 3.0870908683E+00, 9.6159394414E-01],
	[3.3580000000E+04, 2.7342860072E+01, 4.6255780452E+00, 1.4060172998E+01, 3.0875185344E+00, 9.6161456117E-01],
	[3.3585000000E+04, 2.7349827559E+01, 4.6255920642E+00, 1.4067069882E+01, 3.0879460696E+00, 9.6163516637E-01],
	[3.3590000000E+04, 2.7356795784E+01, 4.6256060812E+00, 1.4073969122E+01, 3.0883734739E+00, 9.6165575975E-01],
	[3.3595000000E+04, 2.7363764746E+01, 4.6256200962E+00, 1.4080870718E+01, 3.0888007472E+00, 9.6167634132E-01],
	[3.3600000000E+04, 2.7370734446E+01, 4.6256341091E+00, 1.4087774670E+01, 3.0892278896E+00, 9.6169691109E-01],
	[3.3605000000E+04, 2.7377704884E+01, 4.6256481199E+00, 1.4094680979E+01, 3.0896549012E+00, 9.6171746906E-01],
	[3.3610000000E+04, 2.7384676060E+01, 4.6256621287E+00, 1.4101589645E+01, 3.0900817820E+00, 9.6173801524E-01],
	[3.3615000000E+04, 2.7391647973E+01, 4.6256761355E+00, 1.4108500670E+01, 3.0905085320E+00, 9.6175854963E-01],
	[3.3620000000E+04, 2.7398620624E+01, 4.6256901403E+00, 1.4115414052E+01, 3.0909351512E+00, 9.6177907225E-01],
	[3.3625000000E+04, 2.7405594013E+01, 4.6257041430E+00, 1.4122329793E+01, 3.0913616397E+00, 9.6179958309E-01],
	[3.3630000000E+04, 2.7412568139E+01, 4.6257181436E+00, 1.4129247893E+01, 3.0917879975E+00, 9.6182008217E-01],
	[3.3635000000E+04, 2.7419543002E+01, 4.6257321422E+00, 1.4136168353E+01, 3.0922142246E+00, 9.6184056949E-01],
	[3.3640000000E+04, 2.7426518604E+01, 4.6257461388E+00, 1.4143091173E+01, 3.0926403210E+00, 9.6186104506E-01],
	[3.3645000000E+04, 2.7433494942E+01, 4.6257601334E+00, 1.4150016353E+01, 3.0930662869E+00, 9.6188150889E-01],
	[3.3650000000E+04, 2.7440472019E+01, 4.6257741259E+00, 1.4156943894E+01, 3.0934921221E+00, 9.6190196098E-01],
	[3.3655000000E+04, 2.7447449832E+01, 4.6257881163E+00, 1.4163873797E+01, 3.0939178268E+00, 9.6192240133E-01],
	[3.3660000000E+04, 2.7454428383E+01, 4.6258021048E+00, 1.4170806061E+01, 3.0943434010E+00, 9.6194282996E-01],
	[3.3665000000E+04, 2.7461407672E+01, 4.6258160912E+00, 1.4177740688E+01, 3.0947688447E+00, 9.6196324688E-01],
	[3.3670000000E+04, 2.7468387697E+01, 4.6258300755E+00, 1.4184677677E+01, 3.0951941579E+00, 9.6198365208E-01],
	[3.3675000000E+04, 2.7475368460E+01, 4.6258440578E+00, 1.4191617030E+01, 3.0956193406E+00, 9.6200404557E-01],
	[3.3680000000E+04, 2.7482349961E+01, 4.6258580381E+00, 1.4198558747E+01, 3.0960443930E+00, 9.6202442737E-01],
	[3.3685000000E+04, 2.7489332198E+01, 4.6258720164E+00, 1.4205502827E+01, 3.0964693150E+00, 9.6204479747E-01],
	[3.3690000000E+04, 2.7496315173E+01, 4.6258859926E+00, 1.4212449272E+01, 3.0968941066E+00, 9.6206515589E-01],
	[3.3695000000E+04, 2.7503298885E+01, 4.6258999668E+00, 1.4219398082E+01, 3.0973187679E+00, 9.6208550263E-01],
	[3.3700000000E+04, 2.7510283334E+01, 4.6259139390E+00, 1.4226349258E+01, 3.0977432990E+00, 9.6210583770E-01],
	[3.3705000000E+04, 2.7517268520E+01, 4.6259279091E+00, 1.4233302799E+01, 3.0981676998E+00, 9.6212616111E-01],
	[3.3710000000E+04, 2.7524254443E+01, 4.6259418772E+00, 1.4240258707E+01, 3.0985919703E+00, 9.6214647285E-01],
	[3.3715000000E+04, 2.7531241103E+01, 4.6259558433E+00, 1.4247216982E+01, 3.0990161107E+00, 9.6216677294E-01],
	[3.3720000000E+04, 2.7538228501E+01, 4.6259698074E+00, 1.4254177624E+01, 3.0994401208E+00, 9.6218706139E-01],
	[3.3725000000E+04, 2.7545216635E+01, 4.6259837694E+00, 1.4261140634E+01, 3.0998640009E+00, 9.6220733820E-01],
	[3.3730000000E+04, 2.7552205506E+01, 4.6259977294E+00, 1.4268106012E+01, 3.1002877508E+00, 9.6222760337E-01],
	[3.3735000000E+04, 2.7559195114E+01, 4.6260116873E+00, 1.4275073759E+01, 3.1007113707E+00, 9.6224785692E-01],
	[3.3740000000E+04, 2.7566185459E+01, 4.6260256433E+00, 1.4282043874E+01, 3.1011348605E+00, 9.6226809885E-01],
	[3.3745000000E+04, 2.7573176541E+01, 4.6260395972E+00, 1.4289016360E+01, 3.1015582203E+00, 9.6228832917E-01],
	[3.3750000000E+04, 2.7580168360E+01, 4.6260535491E+00, 1.4295991215E+01, 3.1019814501E+00, 9.6230854788E-01],
	[3.3755000000E+04, 2.7587160916E+01, 4.6260674989E+00, 1.4302968441E+01, 3.1024045500E+00, 9.6232875499E-01],
	[3.3760000000E+04, 2.7594154208E+01, 4.6260814468E+00, 1.4309948038E+01, 3.1028275199E+00, 9.6234895050E-01],
	[3.3765000000E+04, 2.7601148237E+01, 4.6260953926E+00, 1.4316930006E+01, 3.1032503599E+00, 9.6236913444E-01],
	[3.3770000000E+04, 2.7608143003E+01, 4.6261093364E+00, 1.4323914346E+01, 3.1036730701E+00, 9.6238930679E-01],
	[3.3775000000E+04, 2.7615138505E+01, 4.6261232781E+00, 1.4330901058E+01, 3.1040956504E+00, 9.6240946757E-01],
	[3.3780000000E+04, 2.7622134744E+01, 4.6261372179E+00, 1.4337890143E+01, 3.1045181009E+00, 9.6242961678E-01],
	[3.3785000000E+04, 2.7629131720E+01, 4.6261511556E+00, 1.4344881601E+01, 3.1049404217E+00, 9.6244975443E-01],
	[3.3790000000E+04, 2.7636129432E+01, 4.6261650913E+00, 1.4351875433E+01, 3.1053626127E+00, 9.6246988053E-01],
	[3.3795000000E+04, 2.7643127881E+01, 4.6261790250E+00, 1.4358871639E+01, 3.1057846740E+00, 9.6248999508E-01],
	[3.3800000000E+04, 2.7650127066E+01, 4.6261929567E+00, 1.4365870220E+01, 3.1062066056E+00, 9.6251009810E-01],
	[3.3805000000E+04, 2.7657126988E+01, 4.6262068863E+00, 1.4372871175E+01, 3.1066284075E+00, 9.6253018957E-01],
	[3.3810000000E+04, 2.7664127646E+01, 4.6262208139E+00, 1.4379874507E+01, 3.1070500798E+00, 9.6255026953E-01],
	[3.3815000000E+04, 2.7671129041E+01, 4.6262347396E+00, 1.4386880214E+01, 3.1074716225E+00, 9.6257033796E-01],
	[3.3820000000E+04, 2.7678131172E+01, 4.6262486631E+00, 1.4393888297E+01, 3.1078930357E+00, 9.6259039488E-01],
	[3.3825000000E+04, 2.7685134039E+01, 4.6262625847E+00, 1.4400898757E+01, 3.1083143193E+00, 9.6261044029E-01],
	[3.3830000000E+04, 2.7692137643E+01, 4.6262765043E+00, 1.4407911595E+01, 3.1087354734E+00, 9.6263047420E-01],
	[3.3835000000E+04, 2.7699141983E+01, 4.6262904218E+00, 1.4414926810E+01, 3.1091564980E+00, 9.6265049661E-01],
	[3.3840000000E+04, 2.7706147059E+01, 4.6263043374E+00, 1.4421944403E+01, 3.1095773932E+00, 9.6267050754E-01],
	[3.3845000000E+04, 2.7713152871E+01, 4.6263182509E+00, 1.4428964375E+01, 3.1099981590E+00, 9.6269050699E-01],
	[3.3850000000E+04, 2.7720159420E+01, 4.6263321624E+00, 1.4435986727E+01, 3.1104187954E+00, 9.6271049496E-01],
	[3.3855000000E+04, 2.7727166705E+01, 4.6263460719E+00, 1.4443011457E+01, 3.1108393024E+00, 9.6273047147E-01],
	[3.3860000000E+04, 2.7734174726E+01, 4.6263599794E+00, 1.4450038568E+01, 3.1112596802E+00, 9.6275043652E-01],
	[3.3865000000E+04, 2.7741183483E+01, 4.6263738848E+00, 1.4457068060E+01, 3.1116799286E+00, 9.6277039011E-01],
	[3.3870000000E+04, 2.7748192976E+01, 4.6263877883E+00, 1.4464099932E+01, 3.1121000478E+00, 9.6279033225E-01],
	[3.3875000000E+04, 2.7755203205E+01, 4.6264016897E+00, 1.4471134185E+01, 3.1125200377E+00, 9.6281026295E-01],
	[3.3880000000E+04, 2.7762214170E+01, 4.6264155892E+00, 1.4478170821E+01, 3.1129398984E+00, 9.6283018222E-01],
	[3.3885000000E+04, 2.7769225871E+01, 4.6264294866E+00, 1.4485209839E+01, 3.1133596300E+00, 9.6285009006E-01],
	[3.3890000000E+04, 2.7776238309E+01, 4.6264433820E+00, 1.4492251239E+01, 3.1137792324E+00, 9.6286998648E-01],
	[3.3895000000E+04, 2.7783251482E+01, 4.6264572754E+00, 1.4499295023E+01, 3.1141987057E+00, 9.6288987148E-01],
	[3.3900000000E+04, 2.7790265391E+01, 4.6264711668E+00, 1.4506341190E+01, 3.1146180499E+00, 9.6290974508E-01],
	[3.3905000000E+04, 2.7797280035E+01, 4.6264850562E+00, 1.4513389741E+01, 3.1150372651E+00, 9.6292960727E-01],
	[3.3910000000E+04, 2.7804295416E+01, 4.6264989436E+00, 1.4520440677E+01, 3.1154563512E+00, 9.6294945807E-01],
	[3.3915000000E+04, 2.7811311532E+01, 4.6265128290E+00, 1.4527493998E+01, 3.1158753084E+00, 9.6296929748E-01],
	[3.3920000000E+04, 2.7818328384E+01, 4.6265267123E+00, 1.4534549705E+01, 3.1162941366E+00, 9.6298912551E-01],
	[3.3925000000E+04, 2.7825345972E+01, 4.6265405937E+00, 1.4541607797E+01, 3.1167128359E+00, 9.6300894216E-01],
	[3.3930000000E+04, 2.7832364296E+01, 4.6265544731E+00, 1.4548668276E+01, 3.1171314063E+00, 9.6302874744E-01],
	[3.3935000000E+04, 2.7839383355E+01, 4.6265683505E+00, 1.4555731142E+01, 3.1175498478E+00, 9.6304854136E-01],
	[3.3940000000E+04, 2.7846403150E+01, 4.6265822258E+00, 1.4562796395E+01, 3.1179681604E+00, 9.6306832393E-01],
	[3.3945000000E+04, 2.7853423680E+01, 4.6265960992E+00, 1.4569864036E+01, 3.1183863443E+00, 9.6308809515E-01],
	[3.3950000000E+04, 2.7860444946E+01, 4.6266099705E+00, 1.4576934065E+01, 3.1188043994E+00, 9.6310785502E-01],
	[3.3955000000E+04, 2.7867466948E+01, 4.6266238399E+00, 1.4584006482E+01, 3.1192223258E+00, 9.6312760356E-01],
	[3.3960000000E+04, 2.7874489685E+01, 4.6266377072E+00, 1.4591081289E+01, 3.1196401234E+00, 9.6314734077E-01],
	[3.3965000000E+04, 2.7881513158E+01, 4.6266515726E+00, 1.4598158485E+01, 3.1200577923E+00, 9.6316706666E-01],
	[3.3970000000E+04, 2.7888537366E+01, 4.6266654360E+00, 1.4605238071E+01, 3.1204753326E+00, 9.6318678123E-01],
	[3.3975000000E+04, 2.7895562309E+01, 4.6266792973E+00, 1.4612320048E+01, 3.1208927443E+00, 9.6320648449E-01],
	[3.3980000000E+04, 2.7902587988E+01, 4.6266931567E+00, 1.4619404416E+01, 3.1213100274E+00, 9.6322617645E-01],
	[3.3985000000E+04, 2.7909619598E+01, 4.6267076668E+00, 1.4626491175E+01, 3.1217275441E+00, 9.6324585711E-01],
	[3.3990000000E+04, 2.7916665970E+01, 4.6267239360E+00, 1.4633580326E+01, 3.1221459097E+00, 9.6326552648E-01],
	[3.3995000000E+04, 2.7923713083E+01, 4.6267402029E+00, 1.4640671869E+01, 3.1225641473E+00, 9.6328518457E-01],
	[3.4000000000E+04, 2.7930760939E+01, 4.6267564674E+00, 1.4647765805E+01, 3.1229822567E+00, 9.6330483138E-01],
	[3.4005000000E+04, 2.7937809537E+01, 4.6267727296E+00, 1.4654862135E+01, 3.1234002381E+00, 9.6332446692E-01],
	[3.4010000000E+04, 2.7944858877E+01, 4.6267889895E+00, 1.4661960857E+01, 3.1238180915E+00, 9.6334409120E-01],
	[3.4015000000E+04, 2.7951908958E+01, 4.6268052471E+00, 1.4669061974E+01, 3.1242358169E+00, 9.6336370422E-01],
	[3.4020000000E+04, 2.7958959782E+01, 4.6268215023E+00, 1.4676165486E+01, 3.1246534144E+00, 9.6338330600E-01],
	[3.4025000000E+04, 2.7966011348E+01, 4.6268377551E+00, 1.4683271393E+01, 3.1250708839E+00, 9.6340289652E-01],
	[3.4030000000E+04, 2.7973063656E+01, 4.6268540057E+00, 1.4690379695E+01, 3.1254882255E+00, 9.6342247581E-01],
	[3.4035000000E+04, 2.7980116705E+01, 4.6268702539E+00, 1.4697490393E+01, 3.1259054393E+00, 9.6344204387E-01],
	[3.4040000000E+04, 2.7987170497E+01, 4.6268864998E+00, 1.4704603487E+01, 3.1263225252E+00, 9.6346160071E-01],
	[3.4045000000E+04, 2.7994225030E+01, 4.6269027434E+00, 1.4711718979E+01, 3.1267394833E+00, 9.6348114633E-01],
	[3.4050000000E+04, 2.8001280306E+01, 4.6269189846E+00, 1.4718836867E+01, 3.1271563136E+00, 9.6350068073E-01],
	[3.4055000000E+04, 2.8008336322E+01, 4.6269352235E+00, 1.4725957154E+01, 3.1275730162E+00, 9.6352020394E-01],
	[3.4060000000E+04, 2.8015393081E+01, 4.6269514601E+00, 1.4733079838E+01, 3.1279895911E+00, 9.6353971594E-01],
	[3.4065000000E+04, 2.8022450582E+01, 4.6269676943E+00, 1.4740204922E+01, 3.1284060383E+00, 9.6355921675E-01],
	[3.4070000000E+04, 2.8029508824E+01, 4.6269839262E+00, 1.4747332404E+01, 3.1288223578E+00, 9.6357870638E-01],
	[3.4075000000E+04, 2.8036567808E+01, 4.6270001558E+00, 1.4754462286E+01, 3.1292385498E+00, 9.6359818483E-01],
	[3.4080000000E+04, 2.8043627533E+01, 4.6270163831E+00, 1.4761594568E+01, 3.1296546141E+00, 9.6361765211E-01],
	[3.4085000000E+04, 2.8050688000E+01, 4.6270326080E+00, 1.4768729251E+01, 3.1300705508E+00, 9.6363710823E-01],
	[3.4090000000E+04, 2.8057749208E+01, 4.6270488307E+00, 1.4775866334E+01, 3.1304863601E+00, 9.6365655318E-01],
	[3.4095000000E+04, 2.8064811159E+01, 4.6270650510E+00, 1.4783005819E+01, 3.1309020418E+00, 9.6367598698E-01],
	[3.4100000000E+04, 2.8071873850E+01, 4.6270812690E+00, 1.4790147706E+01, 3.1313175960E+00, 9.6369540964E-01],
	[3.4105000000E+04, 2.8078937283E+01, 4.6270974846E+00, 1.4797291995E+01, 3.1317330229E+00, 9.6371482116E-01],
	[3.4110000000E+04, 2.8086001458E+01, 4.6271136980E+00, 1.4804438687E+01, 3.1321483223E+00, 9.6373422155E-01],
	[3.4115000000E+04, 2.8093066374E+01, 4.6271299090E+00, 1.4811587782E+01, 3.1325634943E+00, 9.6375361081E-01],
	[3.4120000000E+04, 2.8100132031E+01, 4.6271461177E+00, 1.4818739281E+01, 3.1329785390E+00, 9.6377298895E-01],
	[3.4125000000E+04, 2.8107198430E+01, 4.6271623241E+00, 1.4825893184E+01, 3.1333934563E+00, 9.6379235598E-01],
	[3.4130000000E+04, 2.8114265570E+01, 4.6271785281E+00, 1.4833049491E+01, 3.1338082464E+00, 9.6381171190E-01],
	[3.4135000000E+04, 2.8121333451E+01, 4.6271947299E+00, 1.4840208204E+01, 3.1342229092E+00, 9.6383105673E-01],
	[3.4140000000E+04, 2.8128402073E+01, 4.6272109293E+00, 1.4847369322E+01, 3.1346374448E+00, 9.6385039046E-01],
	[3.4145000000E+04, 2.8135471437E+01, 4.6272271264E+00, 1.4854532846E+01, 3.1350518532E+00, 9.6386971310E-01],
	[3.4150000000E+04, 2.8142541542E+01, 4.6272433212E+00, 1.4861698777E+01, 3.1354661344E+00, 9.6388902466E-01],
	[3.4155000000E+04, 2.8149612388E+01, 4.6272595137E+00, 1.4868867114E+01, 3.1358802885E+00, 9.6390832515E-01],
	[3.4160000000E+04, 2.8156683975E+01, 4.6272757039E+00, 1.4876037859E+01, 3.1362943155E+00, 9.6392761458E-01],
	[3.4165000000E+04, 2.8163756304E+01, 4.6272918918E+00, 1.4883211011E+01, 3.1367082154E+00, 9.6394689294E-01],
	[3.4170000000E+04, 2.8170829373E+01, 4.6273080773E+00, 1.4890386572E+01, 3.1371219883E+00, 9.6396616025E-01],
	[3.4175000000E+04, 2.8177903183E+01, 4.6273242605E+00, 1.4897564542E+01, 3.1375356341E+00, 9.6398541651E-01],
	[3.4180000000E+04, 2.8184977735E+01, 4.6273404415E+00, 1.4904744920E+01, 3.1379491530E+00, 9.6400466173E-01],
	[3.4185000000E+04, 2.8192053027E+01, 4.6273566201E+00, 1.4911927709E+01, 3.1383625449E+00, 9.6402389592E-01],
	[3.4190000000E+04, 2.8199129061E+01, 4.6273727964E+00, 1.4919112907E+01, 3.1387758099E+00, 9.6404311908E-01],
	[3.4195000000E+04, 2.8206205835E+01, 4.6273889704E+00, 1.4926300516E+01, 3.1391889480E+00, 9.6406233122E-01],
	[3.4200000000E+04, 2.8213283350E+01, 4.6274051421E+00, 1.4933490535E+01, 3.1396019593E+00, 9.6408153234E-01],
	[3.4205000000E+04, 2.8220361606E+01, 4.6274213115E+00, 1.4940682967E+01, 3.1400148437E+00, 9.6410072246E-01],
	[3.4210000000E+04, 2.8227440603E+01, 4.6274374785E+00, 1.4947877810E+01, 3.1404276014E+00, 9.6411990157E-01],
	[3.4215000000E+04, 2.8234520341E+01, 4.6274536433E+00, 1.4955075065E+01, 3.1408402322E+00, 9.6413906969E-01],
	[3.4220000000E+04, 2.8241600819E+01, 4.6274698058E+00, 1.4962274734E+01, 3.1412527364E+00, 9.6415822682E-01],
	[3.4225000000E+04, 2.8248682038E+01, 4.6274859659E+00, 1.4969476815E+01, 3.1416651138E+00, 9.6417737297E-01],
	[3.4230000000E+04, 2.8255763998E+01, 4.6275021238E+00, 1.4976681310E+01, 3.1420773645E+00, 9.6419650814E-01],
	[3.4235000000E+04, 2.8262846698E+01, 4.6275182793E+00, 1.4983888220E+01, 3.1424894887E+00, 9.6421563235E-01],
	[3.4240000000E+04, 2.8269930140E+01, 4.6275344326E+00, 1.4991097544E+01, 3.1429014861E+00, 9.6423474559E-01],
	[3.4245000000E+04, 2.8277014321E+01, 4.6275505835E+00, 1.4998309283E+01, 3.1433133571E+00, 9.6425384788E-01],
	[3.4250000000E+04, 2.8284099244E+01, 4.6275667322E+00, 1.5005523438E+01, 3.1437251014E+00, 9.6427293921E-01],
	[3.4255000000E+04, 2.8291184907E+01, 4.6275828785E+00, 1.5012740009E+01, 3.1441367193E+00, 9.6429201961E-01],
	[3.4260000000E+04, 2.8298271310E+01, 4.6275990226E+00, 1.5019958996E+01, 3.1445482106E+00, 9.6431108907E-01],
	[3.4265000000E+04, 2.8305358454E+01, 4.6276151643E+00, 1.5027180400E+01, 3.1449595755E+00, 9.6433014759E-01],
	[3.4270000000E+04, 2.8312446338E+01, 4.6276313037E+00, 1.5034404221E+01, 3.1453708140E+00, 9.6434919520E-01],
	[3.4275000000E+04, 2.8319534963E+01, 4.6276474409E+00, 1.5041630461E+01, 3.1457819261E+00, 9.6436823189E-01],
	[3.4280000000E+04, 2.8326624328E+01, 4.6276635757E+00, 1.5048859118E+01, 3.1461929118E+00, 9.6438725766E-01],
	[3.4285000000E+04, 2.8333714434E+01, 4.6276797083E+00, 1.5056090194E+01, 3.1466037711E+00, 9.6440627254E-01],
	[3.4290000000E+04, 2.8340805280E+01, 4.6276958385E+00, 1.5063323690E+01, 3.1470145042E+00, 9.6442527651E-01],
	[3.4295000000E+04, 2.8347896866E+01, 4.6277119665E+00, 1.5070559605E+01, 3.1474251110E+00, 9.6444426960E-01],
	[3.4300000000E+04, 2.8354989192E+01, 4.6277280922E+00, 1.5077797940E+01, 3.1478355915E+00, 9.6446325180E-01],
	[3.4305000000E+04, 2.8362082259E+01, 4.6277442155E+00, 1.5085038696E+01, 3.1482459459E+00, 9.6448222312E-01],
	[3.4310000000E+04, 2.8369176066E+01, 4.6277603366E+00, 1.5092281873E+01, 3.1486561740E+00, 9.6450118358E-01],
	[3.4315000000E+04, 2.8376270613E+01, 4.6277764554E+00, 1.5099527471E+01, 3.1490662760E+00, 9.6452013316E-01],
	[3.4320000000E+04, 2.8383365900E+01, 4.6277925719E+00, 1.5106775491E+01, 3.1494762519E+00, 9.6453907189E-01],
	[3.4325000000E+04, 2.8390461927E+01, 4.6278086861E+00, 1.5114025934E+01, 3.1498861017E+00, 9.6455799977E-01],
	[3.4330000000E+04, 2.8397558695E+01, 4.6278247980E+00, 1.5121278799E+01, 3.1502958255E+00, 9.6457691680E-01],
	[3.4335000000E+04, 2.8404656202E+01, 4.6278409076E+00, 1.5128534088E+01, 3.1507054232E+00, 9.6459582300E-01],
	[3.4340000000E+04, 2.8411754450E+01, 4.6278570149E+00, 1.5135791801E+01, 3.1511148949E+00, 9.6461471836E-01],
	[3.4345000000E+04, 2.8418853437E+01, 4.6278731200E+00, 1.5143051937E+01, 3.1515242407E+00, 9.6463360289E-01],
	[3.4350000000E+04, 2.8425953165E+01, 4.6278892227E+00, 1.5150314499E+01, 3.1519334605E+00, 9.6465247661E-01],
	[3.4355000000E+04, 2.8433053632E+01, 4.6279053232E+00, 1.5157579485E+01, 3.1523425544E+00, 9.6467133951E-01],
	[3.4360000000E+04, 2.8440154840E+01, 4.6279214214E+00, 1.5164846897E+01, 3.1527515225E+00, 9.6469019161E-01],
	[3.4365000000E+04, 2.8447256787E+01, 4.6279375173E+00, 1.5172116735E+01, 3.1531603647E+00, 9.6470903291E-01],
	[3.4370000000E+04, 2.8454359474E+01, 4.6279536109E+00, 1.5179389000E+01, 3.1535690811E+00, 9.6472786341E-01],
	[3.4375000000E+04, 2.8461462901E+01, 4.6279697022E+00, 1.5186663692E+01, 3.1539776717E+00, 9.6474668313E-01],
	[3.4380000000E+04, 2.8468567067E+01, 4.6279857912E+00, 1.5193940811E+01, 3.1543861366E+00, 9.6476549206E-01],
	[3.4385000000E+04, 2.8475671974E+01, 4.6280018780E+00, 1.5201220357E+01, 3.1547944758E+00, 9.6478429022E-01],
	[3.4390000000E+04, 2.8482777620E+01, 4.6280179624E+00, 1.5208502333E+01, 3.1552026892E+00, 9.6480307762E-01],
	[3.4395000000E+04, 2.8489884006E+01, 4.6280340446E+00, 1.5215786737E+01, 3.1556107771E+00, 9.6482185425E-01],
	[3.4400000000E+04, 2.8496991131E+01, 4.6280501245E+00, 1.5223073570E+01, 3.1560187393E+00, 9.6484062013E-01],
	[3.4405000000E+04, 2.8504098996E+01, 4.6280662021E+00, 1.5230362833E+01, 3.1564265759E+00, 9.6485937526E-01],
	[3.4410000000E+04, 2.8511207601E+01, 4.6280822775E+00, 1.5237654526E+01, 3.1568342869E+00, 9.6487811965E-01],
	[3.4415000000E+04, 2.8518316945E+01, 4.6280983505E+00, 1.5244948649E+01, 3.1572418724E+00, 9.6489685331E-01],
	[3.4420000000E+04, 2.8525427029E+01, 4.6281144213E+00, 1.5252245204E+01, 3.1576493325E+00, 9.6491557624E-01],
	[3.4425000000E+04, 2.8532537852E+01, 4.6281304898E+00, 1.5259544190E+01, 3.1580566670E+00, 9.6493428844E-01],
	[3.4430000000E+04, 2.8539649415E+01, 4.6281465560E+00, 1.5266845609E+01, 3.1584638761E+00, 9.6495298993E-01],
	[3.4435000000E+04, 2.8546761717E+01, 4.6281626200E+00, 1.5274149459E+01, 3.1588709598E+00, 9.6497168071E-01],
	[3.4440000000E+04, 2.8553874759E+01, 4.6281786817E+00, 1.5281455743E+01, 3.1592779182E+00, 9.6499036078E-01],
	[3.4445000000E+04, 2.8560988540E+01, 4.6281947411E+00, 1.5288764460E+01, 3.1596847512E+00, 9.6500903016E-01],
	[3.4450000000E+04, 2.8568103060E+01, 4.6282107982E+00, 1.5296075610E+01, 3.1600914589E+00, 9.6502768886E-01],
	[3.4455000000E+04, 2.8575218320E+01, 4.6282268530E+00, 1.5303389195E+01, 3.1604980413E+00, 9.6504633686E-01],
	[3.4460000000E+04, 2.8582334319E+01, 4.6282429056E+00, 1.5310705215E+01, 3.1609044984E+00, 9.6506497419E-01],
	[3.4465000000E+04, 2.8589451057E+01, 4.6282589559E+00, 1.5318023670E+01, 3.1613108303E+00, 9.6508360085E-01],
	[3.4470000000E+04, 2.8596568534E+01, 4.6282750039E+00, 1.5325344560E+01, 3.1617170371E+00, 9.6510221685E-01],
	[3.4475000000E+04, 2.8603686751E+01, 4.6282910497E+00, 1.5332667887E+01, 3.1621231187E+00, 9.6512082219E-01],
	[3.4480000000E+04, 2.8610805707E+01, 4.6283070932E+00, 1.5339993650E+01, 3.1625290752E+00, 9.6513941687E-01],
	[3.4485000000E+04, 2.8617925402E+01, 4.6283231344E+00, 1.5347321850E+01, 3.1629349065E+00, 9.6515800091E-01],
	[3.4490000000E+04, 2.8625045836E+01, 4.6283391733E+00, 1.5354652488E+01, 3.1633406128E+00, 9.6517657432E-01],
	[3.4495000000E+04, 2.8632167009E+01, 4.6283552100E+00, 1.5361985563E+01, 3.1637461941E+00, 9.6519513709E-01],
	[3.4500000000E+04, 2.8639288921E+01, 4.6283712444E+00, 1.5369321077E+01, 3.1641516504E+00, 9.6521368924E-01],
	[3.4505000000E+04, 2.8646411573E+01, 4.6283872765E+00, 1.5376659030E+01, 3.1645569817E+00, 9.6523223076E-01],
	[3.4510000000E+04, 2.8653534963E+01, 4.6284033064E+00, 1.5383999422E+01, 3.1649621881E+00, 9.6525076168E-01],
	[3.4515000000E+04, 2.8660659092E+01, 4.6284193340E+00, 1.5391342254E+01, 3.1653672696E+00, 9.6526928199E-01],
	[3.4520000000E+04, 2.8667783960E+01, 4.6284353593E+00, 1.5398687525E+01, 3.1657722262E+00, 9.6528779170E-01],
	[3.4525000000E+04, 2.8674909567E+01, 4.6284513824E+00, 1.5406035238E+01, 3.1661770579E+00, 9.6530629082E-01],
	[3.4530000000E+04, 2.8682035913E+01, 4.6284674032E+00, 1.5413385392E+01, 3.1665817649E+00, 9.6532477935E-01],
	[3.4535000000E+04, 2.8689179180E+01, 4.6284854308E+00, 1.5420737987E+01, 3.1669874848E+00, 9.6534325730E-01],
	[3.4540000000E+04, 2.8696325995E+01, 4.6285038039E+00, 1.5428093024E+01, 3.1673932775E+00, 9.6536172467E-01],
	[3.4545000000E+04, 2.8703473557E+01, 4.6285221745E+00, 1.5435450504E+01, 3.1677989458E+00, 9.6538018148E-01],
	[3.4550000000E+04, 2.8710621863E+01, 4.6285405424E+00, 1.5442810427E+01, 3.1682044898E+00, 9.6539862773E-01],
	[3.4555000000E+04, 2.8717770915E+01, 4.6285589078E+00, 1.5450172793E+01, 3.1686099096E+00, 9.6541706342E-01],
	[3.4560000000E+04, 2.8724920712E+01, 4.6285772706E+00, 1.5457537603E+01, 3.1690152050E+00, 9.6543548856E-01],
	[3.4565000000E+04, 2.8732071255E+01, 4.6285956308E+00, 1.5464904858E+01, 3.1694203763E+00, 9.6545390317E-01],
	[3.4570000000E+04, 2.8739222543E+01, 4.6286139885E+00, 1.5472274557E+01, 3.1698254233E+00, 9.6547230723E-01],
	[3.4575000000E+04, 2.8746374577E+01, 4.6286323435E+00, 1.5479646701E+01, 3.1702303462E+00, 9.6549070077E-01],
	[3.4580000000E+04, 2.8753527355E+01, 4.6286506960E+00, 1.5487021291E+01, 3.1706351449E+00, 9.6550908379E-01],
	[3.4585000000E+04, 2.8760680879E+01, 4.6286690459E+00, 1.5494398328E+01, 3.1710398196E+00, 9.6552745629E-01],
	[3.4590000000E+04, 2.8767835148E+01, 4.6286873932E+00, 1.5501777810E+01, 3.1714443701E+00, 9.6554581828E-01],
	[3.4595000000E+04, 2.8774990162E+01, 4.6287057379E+00, 1.5509159740E+01, 3.1718487967E+00, 9.6556416977E-01],
	[3.4600000000E+04, 2.8782145922E+01, 4.6287240801E+00, 1.5516544118E+01, 3.1722530992E+00, 9.6558251076E-01],
	[3.4605000000E+04, 2.8789302426E+01, 4.6287424196E+00, 1.5523930943E+01, 3.1726572777E+00, 9.6560084126E-01],
	[3.4610000000E+04, 2.8796459676E+01, 4.6287607566E+00, 1.5531320217E+01, 3.1730613323E+00, 9.6561916127E-01],
	[3.4615000000E+04, 2.8803617670E+01, 4.6287790911E+00, 1.5538711940E+01, 3.1734652630E+00, 9.6563747081E-01],
	[3.4620000000E+04, 2.8810776410E+01, 4.6287974229E+00, 1.5546106112E+01, 3.1738690697E+00, 9.6565576988E-01],
	[3.4625000000E+04, 2.8817935894E+01, 4.6288157522E+00, 1.5553502734E+01, 3.1742727527E+00, 9.6567405848E-01],
	[3.4630000000E+04, 2.8825096124E+01, 4.6288340789E+00, 1.5560901806E+01, 3.1746763118E+00, 9.6569233662E-01],
	[3.4635000000E+04, 2.8832257098E+01, 4.6288524030E+00, 1.5568303329E+01, 3.1750797471E+00, 9.6571060431E-01],
	[3.4640000000E+04, 2.8839418818E+01, 4.6288707245E+00, 1.5575707303E+01, 3.1754830586E+00, 9.6572886156E-01],
	[3.4645000000E+04, 2.8846581282E+01, 4.6288890435E+00, 1.5583113729E+01, 3.1758862465E+00, 9.6574710836E-01],
	[3.4650000000E+04, 2.8853744491E+01, 4.6289073599E+00, 1.5590522606E+01, 3.1762893106E+00, 9.6576534474E-01],
	[3.4655000000E+04, 2.8860908445E+01, 4.6289256738E+00, 1.5597933937E+01, 3.1766922510E+00, 9.6578357068E-01],
	[3.4660000000E+04, 2.8868073144E+01, 4.6289439850E+00, 1.5605347720E+01, 3.1770950679E+00, 9.6580178621E-01],
	[3.4665000000E+04, 2.8875238587E+01, 4.6289622937E+00, 1.5612763957E+01, 3.1774977611E+00, 9.6581999132E-01],
	[3.4670000000E+04, 2.8882404776E+01, 4.6289805999E+00, 1.5620182648E+01, 3.1779003307E+00, 9.6583818603E-01],
	[3.4675000000E+04, 2.8889571708E+01, 4.6289989034E+00, 1.5627603793E+01, 3.1783027768E+00, 9.6585637033E-01],
	[3.4680000000E+04, 2.8896739386E+01, 4.6290172044E+00, 1.5635027393E+01, 3.1787050994E+00, 9.6587454424E-01],
	[3.4685000000E+04, 2.8903907808E+01, 4.6290355028E+00, 1.5642453448E+01, 3.1791072985E+00, 9.6589270776E-01],
	[3.4690000000E+04, 2.8911076975E+01, 4.6290537987E+00, 1.5649881960E+01, 3.1795093741E+00, 9.6591086090E-01],
	[3.4695000000E+04, 2.8918246886E+01, 4.6290720920E+00, 1.5657312927E+01, 3.1799113264E+00, 9.6592900367E-01],
	[3.4700000000E+04, 2.8925417542E+01, 4.6290903827E+00, 1.5664746351E+01, 3.1803131552E+00, 9.6594713606E-01],
	[3.4705000000E+04, 2.8932588943E+01, 4.6291086709E+00, 1.5672182232E+01, 3.1807148607E+00, 9.6596525809E-01],
	[3.4710000000E+04, 2.8939761087E+01, 4.6291269565E+00, 1.5679620571E+01, 3.1811164429E+00, 9.6598336977E-01],
	[3.4715000000E+04, 2.8946933977E+01, 4.6291452396E+00, 1.5687061368E+01, 3.1815179017E+00, 9.6600147110E-01],
	[3.4720000000E+04, 2.8954107610E+01, 4.6291635201E+00, 1.5694504623E+01, 3.1819192374E+00, 9.6601956208E-01],
	[3.4725000000E+04, 2.8961281989E+01, 4.6291817980E+00, 1.5701950337E+01, 3.1823204497E+00, 9.6603764272E-01],
	[3.4730000000E+04, 2.8968457111E+01, 4.6292000734E+00, 1.5709398511E+01, 3.1827215389E+00, 9.6605571303E-01],
	[3.4735000000E+04, 2.8975632978E+01, 4.6292183462E+00, 1.5716849144E+01, 3.1831225049E+00, 9.6607377301E-01],
	[3.4740000000E+04, 2.8982809589E+01, 4.6292366164E+00, 1.5724302238E+01, 3.1835233478E+00, 9.6609182268E-01],
	[3.4745000000E+04, 2.8989986945E+01, 4.6292548841E+00, 1.5731757793E+01, 3.1839240676E+00, 9.6610986202E-01],
	[3.4750000000E+04, 2.8997165044E+01, 4.6292731493E+00, 1.5739215809E+01, 3.1843246643E+00, 9.6612789106E-01],
	[3.4755000000E+04, 2.9004343888E+01, 4.6292914118E+00, 1.5746676287E+01, 3.1847251379E+00, 9.6614590979E-01],
	[3.4760000000E+04, 2.9011523476E+01, 4.6293096719E+00, 1.5754139226E+01, 3.1851254886E+00, 9.6616391823E-01],
	[3.4765000000E+04, 2.9018703808E+01, 4.6293279293E+00, 1.5761604629E+01, 3.1855257163E+00, 9.6618191637E-01],
	[3.4770000000E+04, 2.9025884885E+01, 4.6293461843E+00, 1.5769072495E+01, 3.1859258210E+00, 9.6619990423E-01],
	[3.4775000000E+04, 2.9033066705E+01, 4.6293644366E+00, 1.5776542824E+01, 3.1863258028E+00, 9.6621788181E-01],
	[3.4780000000E+04, 2.9040249270E+01, 4.6293826864E+00, 1.5784015617E+01, 3.1867256617E+00, 9.6623584911E-01],
	[3.4785000000E+04, 2.9047432578E+01, 4.6294009337E+00, 1.5791490874E+01, 3.1871253977E+00, 9.6625380614E-01],
	[3.4790000000E+04, 2.9054616631E+01, 4.6294191784E+00, 1.5798968597E+01, 3.1875250110E+00, 9.6627175291E-01],
	[3.4795000000E+04, 2.9061801427E+01, 4.6294374206E+00, 1.5806448785E+01, 3.1879245014E+00, 9.6628968942E-01],
	[3.4800000000E+04, 2.9068986968E+01, 4.6294556602E+00, 1.5813931439E+01, 3.1883238691E+00, 9.6630761568E-01],
	[3.4805000000E+04, 2.9076173252E+01, 4.6294738972E+00, 1.5821416559E+01, 3.1887231140E+00, 9.6632553170E-01],
	[3.4810000000E+04, 2.9083360280E+01, 4.6294921318E+00, 1.5828904145E+01, 3.1891222363E+00, 9.6634343747E-01],
	[3.4815000000E+04, 2.9090548052E+01, 4.6295103637E+00, 1.5836394199E+01, 3.1895212359E+00, 9.6636133302E-01],
	[3.4820000000E+04, 2.9097736568E+01, 4.6295285932E+00, 1.5843886721E+01, 3.1899201128E+00, 9.6637921833E-01],
	[3.4825000000E+04, 2.9104925828E+01, 4.6295468200E+00, 1.5851381711E+01, 3.1903188672E+00, 9.6639709342E-01],
	[3.4830000000E+04, 2.9112115831E+01, 4.6295650444E+00, 1.5858879169E+01, 3.1907174990E+00, 9.6641495829E-01],
	[3.4835000000E+04, 2.9119306579E+01, 4.6295832661E+00, 1.5866379097E+01, 3.1911160082E+00, 9.6643281296E-01],
	[3.4840000000E+04, 2.9126498069E+01, 4.6296014854E+00, 1.5873881494E+01, 3.1915143949E+00, 9.6645065741E-01],
	[3.4845000000E+04, 2.9133690304E+01, 4.6296197021E+00, 1.5881386361E+01, 3.1919126592E+00, 9.6646849167E-01],
	[3.4850000000E+04, 2.9140883282E+01, 4.6296379162E+00, 1.5888893698E+01, 3.1923108010E+00, 9.6648631574E-01],
	[3.4855000000E+04, 2.9148077004E+01, 4.6296561279E+00, 1.5896403506E+01, 3.1927088204E+00, 9.6650412961E-01],
	[3.4860000000E+04, 2.9155271469E+01, 4.6296743369E+00, 1.5903915786E+01, 3.1931067174E+00, 9.6652193331E-01],
	[3.4865000000E+04, 2.9162466678E+01, 4.6296925435E+00, 1.5911430537E+01, 3.1935044920E+00, 9.6653972683E-01],
	[3.4870000000E+04, 2.9169662631E+01, 4.6297107475E+00, 1.5918947761E+01, 3.1939021444E+00, 9.6655751018E-01],
	[3.4875000000E+04, 2.9176859327E+01, 4.6297289489E+00, 1.5926467457E+01, 3.1942996744E+00, 9.6657528336E-01],
	[3.4880000000E+04, 2.9184056766E+01, 4.6297471479E+00, 1.5933989627E+01, 3.1946970822E+00, 9.6659304639E-01],
	[3.4885000000E+04, 2.9191254949E+01, 4.6297653442E+00, 1.5941514270E+01, 3.1950943678E+00, 9.6661079926E-01],
	[3.4890000000E+04, 2.9198453876E+01, 4.6297835381E+00, 1.5949041387E+01, 3.1954915311E+00, 9.6662854199E-01],
	[3.4895000000E+04, 2.9205653545E+01, 4.6298017294E+00, 1.5956570979E+01, 3.1958885723E+00, 9.6664627457E-01],
	[3.4900000000E+04, 2.9212853958E+01, 4.6298199182E+00, 1.5964103046E+01, 3.1962854914E+00, 9.6666399702E-01],
	[3.4905000000E+04, 2.9220055115E+01, 4.6298381044E+00, 1.5971637588E+01, 3.1966822884E+00, 9.6668170934E-01],
	[3.4910000000E+04, 2.9227257014E+01, 4.6298562881E+00, 1.5979174606E+01, 3.1970789633E+00, 9.6669941153E-01],
	[3.4915000000E+04, 2.9234459657E+01, 4.6298744693E+00, 1.5986714101E+01, 3.1974755161E+00, 9.6671710361E-01],
	[3.4920000000E+04, 2.9241663043E+01, 4.6298926479E+00, 1.5994256072E+01, 3.1978719470E+00, 9.6673478558E-01],
	[3.4925000000E+04, 2.9248867173E+01, 4.6299108241E+00, 1.6001800521E+01, 3.1982682559E+00, 9.6675245743E-01],
	[3.4930000000E+04, 2.9256072045E+01, 4.6299289976E+00, 1.6009347448E+01, 3.1986644428E+00, 9.6677011919E-01],
	[3.4935000000E+04, 2.9263277661E+01, 4.6299471687E+00, 1.6016896852E+01, 3.1990605078E+00, 9.6678777085E-01],
	[3.4940000000E+04, 2.9270484020E+01, 4.6299653372E+00, 1.6024448736E+01, 3.1994564510E+00, 9.6680541243E-01],
	[3.4945000000E+04, 2.9277691121E+01, 4.6299835032E+00, 1.6032003098E+01, 3.1998522723E+00, 9.6682304392E-01],
	[3.4950000000E+04, 2.9284898966E+01, 4.6300016667E+00, 1.6039559941E+01, 3.2002479718E+00, 9.6684066533E-01],
	[3.4955000000E+04, 2.9292107554E+01, 4.6300198276E+00, 1.6047119263E+01, 3.2006435495E+00, 9.6685827667E-01],
	[3.4960000000E+04, 2.9299316885E+01, 4.6300379860E+00, 1.6054681066E+01, 3.2010390054E+00, 9.6687587794E-01],
	[3.4965000000E+04, 2.9306526959E+01, 4.6300561419E+00, 1.6062245349E+01, 3.2014343397E+00, 9.6689346916E-01],
	[3.4970000000E+04, 2.9313737776E+01, 4.6300742953E+00, 1.6069812114E+01, 3.2018295522E+00, 9.6691105032E-01],
	[3.4975000000E+04, 2.9320949335E+01, 4.6300924461E+00, 1.6077381361E+01, 3.2022246431E+00, 9.6692862143E-01],
	[3.4980000000E+04, 2.9328161638E+01, 4.6301105944E+00, 1.6084953091E+01, 3.2026196123E+00, 9.6694618250E-01],
	[3.4985000000E+04, 2.9335374683E+01, 4.6301287402E+00, 1.6092527303E+01, 3.2030144600E+00, 9.6696373353E-01],
	[3.4990000000E+04, 2.9342588471E+01, 4.6301468835E+00, 1.6100103998E+01, 3.2034091861E+00, 9.6698127453E-01],
	[3.4995000000E+04, 2.9349803002E+01, 4.6301650243E+00, 1.6107683178E+01, 3.2038037907E+00, 9.6699880550E-01],
	[3.5000000000E+04, 2.9357018276E+01, 4.6301831625E+00, 1.6115264841E+01, 3.2041982737E+00, 9.6701632646E-01],
	[3.5005000000E+04, 2.9364234293E+01, 4.6302012982E+00, 1.6122859287E+01, 3.2045930421E+00, 9.6703383740E-01],
	[3.5010000000E+04, 2.9371451052E+01, 4.6302194314E+00, 1.6130456225E+01, 3.2049876889E+00, 9.6705133833E-01],
	[3.5015000000E+04, 2.9378668554E+01, 4.6302375620E+00, 1.6138055658E+01, 3.2053822139E+00, 9.6706882926E-01],
	[3.5020000000E+04, 2.9385886798E+01, 4.6302556902E+00, 1.6145657585E+01, 3.2057766174E+00, 9.6708631019E-01],
	[3.5025000000E+04, 2.9393105785E+01, 4.6302738158E+00, 1.6153262006E+01, 3.2061708993E+00, 9.6710378114E-01],
	[3.5030000000E+04, 2.9400325515E+01, 4.6302919390E+00, 1.6160868923E+01, 3.2065650596E+00, 9.6712124209E-01],
	[3.5035000000E+04, 2.9407545987E+01, 4.6303100596E+00, 1.6168478335E+01, 3.2069590984E+00, 9.6713869307E-01],
	[3.5040000000E+04, 2.9414767202E+01, 4.6303281776E+00, 1.6176090243E+01, 3.2073530157E+00, 9.6715613408E-01],
	[3.5045000000E+04, 2.9421989159E+01, 4.6303462932E+00, 1.6183704647E+01, 3.2077468115E+00, 9.6717356511E-01],
	[3.5050000000E+04, 2.9429211858E+01, 4.6303644063E+00, 1.6191321549E+01, 3.2081404860E+00, 9.6719098619E-01],
	[3.5055000000E+04, 2.9436435300E+01, 4.6303825168E+00, 1.6198940948E+01, 3.2085340390E+00, 9.6720839731E-01],
	[3.5060000000E+04, 2.9443659485E+01, 4.6304006249E+00, 1.6206562845E+01, 3.2089274707E+00, 9.6722579848E-01],
	[3.5065000000E+04, 2.9450884412E+01, 4.6304187304E+00, 1.6214187240E+01, 3.2093207810E+00, 9.6724318970E-01],
	[3.5070000000E+04, 2.9458110081E+01, 4.6304368334E+00, 1.6221814134E+01, 3.2097139700E+00, 9.6726057099E-01],
	[3.5075000000E+04, 2.9465336492E+01, 4.6304549339E+00, 1.6229443528E+01, 3.2101070378E+00, 9.6727794234E-01],
	[3.5080000000E+04, 2.9472563646E+01, 4.6304730319E+00, 1.6237075421E+01, 3.2104999843E+00, 9.6729530376E-01],
	[3.5085000000E+04, 2.9479791542E+01, 4.6304911274E+00, 1.6244709814E+01, 3.2108928096E+00, 9.6731265527E-01],
	[3.5090000000E+04, 2.9487032814E+01, 4.6305107690E+00, 1.6252346708E+01, 3.2112864085E+00, 9.6732999686E-01],
	[3.5095000000E+04, 2.9494280980E+01, 4.6305311612E+00, 1.6259986103E+01, 3.2116803216E+00, 9.6734732853E-01],
	[3.5100000000E+04, 2.9501529894E+01, 4.6305515506E+00, 1.6267628000E+01, 3.2120741141E+00, 9.6736465031E-01],
	[3.5105000000E+04, 2.9508779558E+01, 4.6305719372E+00, 1.6275272398E+01, 3.2124677857E+00, 9.6738196218E-01],
	[3.5110000000E+04, 2.9516029969E+01, 4.6305923210E+00, 1.6282919299E+01, 3.2128613367E+00, 9.6739926417E-01],
	[3.5115000000E+04, 2.9523281130E+01, 4.6306127019E+00, 1.6290568704E+01, 3.2132547670E+00, 9.6741655626E-01],
	[3.5120000000E+04, 2.9530533039E+01, 4.6306330801E+00, 1.6298220611E+01, 3.2136480767E+00, 9.6743383848E-01],
	[3.5125000000E+04, 2.9537785697E+01, 4.6306534554E+00, 1.6305875023E+01, 3.2140412658E+00, 9.6745111082E-01],
	[3.5130000000E+04, 2.9545039103E+01, 4.6306738279E+00, 1.6313531939E+01, 3.2144343343E+00, 9.6746837329E-01],
	[3.5135000000E+04, 2.9552293257E+01, 4.6306941976E+00, 1.6321191359E+01, 3.2148272822E+00, 9.6748562589E-01],
	[3.5140000000E+04, 2.9559548160E+01, 4.6307145645E+00, 1.6328853285E+01, 3.2152201096E+00, 9.6750286864E-01],
	[3.5145000000E+04, 2.9566803812E+01, 4.6307349286E+00, 1.6336517717E+01, 3.2156128166E+00, 9.6752010153E-01],
	[3.5150000000E+04, 2.9574060212E+01, 4.6307552899E+00, 1.6344184655E+01, 3.2160054031E+00, 9.6753732458E-01],
	[3.5155000000E+04, 2.9581317360E+01, 4.6307756484E+00, 1.6351854100E+01, 3.2163978691E+00, 9.6755453779E-01],
	[3.5160000000E+04, 2.9588575257E+01, 4.6307960041E+00, 1.6359526052E+01, 3.2167902148E+00, 9.6757174116E-01],
	[3.5165000000E+04, 2.9595833902E+01, 4.6308163570E+00, 1.6367200511E+01, 3.2171824402E+00, 9.6758893471E-01],
	[3.5170000000E+04, 2.9603093295E+01, 4.6308367070E+00, 1.6374877478E+01, 3.2175745452E+00, 9.6760611843E-01],
	[3.5175000000E+04, 2.9610353437E+01, 4.6308570543E+00, 1.6382556954E+01, 3.2179665299E+00, 9.6762329233E-01],
	[3.5180000000E+04, 2.9617614327E+01, 4.6308773988E+00, 1.6390238939E+01, 3.2183583944E+00, 9.6764045642E-01],
	[3.5185000000E+04, 2.9624875965E+01, 4.6308977404E+00, 1.6397923434E+01, 3.2187501386E+00, 9.6765761071E-01],
	[3.5190000000E+04, 2.9632138351E+01, 4.6309180793E+00, 1.6405610438E+01, 3.2191417626E+00, 9.6767475519E-01],
	[3.5195000000E+04, 2.9639401485E+01, 4.6309384153E+00, 1.6413299953E+01, 3.2195332665E+00, 9.6769188988E-01],
	[3.5200000000E+04, 2.9646665368E+01, 4.6309587486E+00, 1.6420991978E+01, 3.2199246502E+00, 9.6770901478E-01],
	[3.5205000000E+04, 2.9653929998E+01, 4.6309790791E+00, 1.6428686515E+01, 3.2203159138E+00, 9.6772612990E-01],
	[3.5210000000E+04, 2.9661195377E+01, 4.6309994067E+00, 1.6436383564E+01, 3.2207070574E+00, 9.6774323524E-01],
	[3.5215000000E+04, 2.9668461503E+01, 4.6310197316E+00, 1.6444083125E+01, 3.2210980809E+00, 9.6776033081E-01],
	[3.5220000000E+04, 2.9675728378E+01, 4.6310400537E+00, 1.6451785198E+01, 3.2214889844E+00, 9.6777741661E-01],
	[3.5225000000E+04, 2.9682996001E+01, 4.6310603729E+00, 1.6459489785E+01, 3.2218797680E+00, 9.6779449265E-01],
	[3.5230000000E+04, 2.9690264371E+01, 4.6310806894E+00, 1.6467196885E+01, 3.2222704316E+00, 9.6781155894E-01],
	[3.5235000000E+04, 2.9697533490E+01, 4.6311010031E+00, 1.6474906500E+01, 3.2226609752E+00, 9.6782861547E-01],
	[3.5240000000E+04, 2.9704803356E+01, 4.6311213140E+00, 1.6482618629E+01, 3.2230513990E+00, 9.6784566227E-01],
	[3.5245000000E+04, 2.9712073970E+01, 4.6311416221E+00, 1.6490333273E+01, 3.2234417030E+00, 9.6786269933E-01],
	[3.5250000000E+04, 2.9719345332E+01, 4.6311619274E+00, 1.6498050432E+01, 3.2238318871E+00, 9.6787972666E-01],
	[3.5255000000E+04, 2.9726617442E+01, 4.6311822299E+00, 1.6505770107E+01, 3.2242219515E+00, 9.6789674426E-01],
	[3.5260000000E+04, 2.9733890300E+01, 4.6312025296E+00, 1.6513492299E+01, 3.2246118961E+00, 9.6791375214E-01],
	[3.5265000000E+04, 2.9741163905E+01, 4.6312228266E+00, 1.6521217008E+01, 3.2250017209E+00, 9.6793075030E-01],
	[3.5270000000E+04, 2.9748438258E+01, 4.6312431207E+00, 1.6528944234E+01, 3.2253914261E+00, 9.6794773876E-01],
	[3.5275000000E+04, 2.9755713359E+01, 4.6312634121E+00, 1.6536673978E+01, 3.2257810116E+00, 9.6796471752E-01],
	[3.5280000000E+04, 2.9762989207E+01, 4.6312837006E+00, 1.6544406240E+01, 3.2261704775E+00, 9.6798168658E-01],
	[3.5285000000E+04, 2.9770265803E+01, 4.6313039864E+00, 1.6552141020E+01, 3.2265598238E+00, 9.6799864594E-01],
	[3.5290000000E+04, 2.9777543147E+01, 4.6313242694E+00, 1.6559878320E+01, 3.2269490506E+00, 9.6801559562E-01],
	[3.5295000000E+04, 2.9784821238E+01, 4.6313445496E+00, 1.6567618140E+01, 3.2273381578E+00, 9.6803253563E-01],
	[3.5300000000E+04, 2.9792100077E+01, 4.6313648271E+00, 1.6575360479E+01, 3.2277271455E+00, 9.6804946595E-01],
	[3.5305000000E+04, 2.9799379663E+01, 4.6313851017E+00, 1.6583105340E+01, 3.2281160137E+00, 9.6806638661E-01],
	[3.5310000000E+04, 2.9806659997E+01, 4.6314053736E+00, 1.6590852721E+01, 3.2285047625E+00, 9.6808329761E-01],
	[3.5315000000E+04, 2.9813941078E+01, 4.6314256427E+00, 1.6598602623E+01, 3.2288933919E+00, 9.6810019895E-01],
	[3.5320000000E+04, 2.9821222907E+01, 4.6314459090E+00, 1.6606355048E+01, 3.2292819019E+00, 9.6811709064E-01],
	[3.5325000000E+04, 2.9828505483E+01, 4.6314661725E+00, 1.6614109995E+01, 3.2296702926E+00, 9.6813397268E-01],
	[3.5330000000E+04, 2.9835788806E+01, 4.6314864332E+00, 1.6621867465E+01, 3.2300585640E+00, 9.6815084508E-01],
	[3.5335000000E+04, 2.9843072876E+01, 4.6315066912E+00, 1.6629627459E+01, 3.2304467161E+00, 9.6816770785E-01],
	[3.5340000000E+04, 2.9850357694E+01, 4.6315269464E+00, 1.6637389976E+01, 3.2308347489E+00, 9.6818456099E-01],
	[3.5345000000E+04, 2.9857643260E+01, 4.6315471988E+00, 1.6645155017E+01, 3.2312226625E+00, 9.6820140451E-01],
	[3.5350000000E+04, 2.9864929572E+01, 4.6315674484E+00, 1.6652922583E+01, 3.2316104570E+00, 9.6821823841E-01],
	[3.5355000000E+04, 2.9872216632E+01, 4.6315876953E+00, 1.6660692675E+01, 3.2319981323E+00, 9.6823506270E-01],
	[3.5360000000E+04, 2.9879504439E+01, 4.6316079394E+00, 1.6668465292E+01, 3.2323856884E+00, 9.6825187738E-01],
	[3.5365000000E+04, 2.9886792993E+01, 4.6316281807E+00, 1.6676240435E+01, 3.2327731255E+00, 9.6826868247E-01],
	[3.5370000000E+04, 2.9894082294E+01, 4.6316484192E+00, 1.6684018105E+01, 3.2331604436E+00, 9.6828547796E-01],
	[3.5375000000E+04, 2.9901372342E+01, 4.6316686550E+00, 1.6691798301E+01, 3.2335476426E+00, 9.6830226386E-01],
	[3.5380000000E+04, 2.9908663137E+01, 4.6316888880E+00, 1.6699581026E+01, 3.2339347226E+00, 9.6831904018E-01],
	[3.5385000000E+04, 2.9915954680E+01, 4.6317091182E+00, 1.6707366278E+01, 3.2343216836E+00, 9.6833580692E-01],
	[3.5390000000E+04, 2.9923246969E+01, 4.6317293457E+00, 1.6715154059E+01, 3.2347085258E+00, 9.6835256409E-01],
	[3.5395000000E+04, 2.9930540006E+01, 4.6317495703E+00, 1.6722944369E+01, 3.2350952490E+00, 9.6836931170E-01],
	[3.5400000000E+04, 2.9937833789E+01, 4.6317697923E+00, 1.6730737208E+01, 3.2354818534E+00, 9.6838604975E-01],
	[3.5405000000E+04, 2.9945128319E+01, 4.6317900114E+00, 1.6738532576E+01, 3.2358683389E+00, 9.6840277824E-01],
	[3.5410000000E+04, 2.9952423596E+01, 4.6318102278E+00, 1.6746330476E+01, 3.2362547056E+00, 9.6841949718E-01],
	[3.5415000000E+04, 2.9959719620E+01, 4.6318304414E+00, 1.6754130906E+01, 3.2366409536E+00, 9.6843620658E-01],
	[3.5420000000E+04, 2.9967016391E+01, 4.6318506522E+00, 1.6761933867E+01, 3.2370270828E+00, 9.6845290645E-01],
	[3.5425000000E+04, 2.9974313909E+01, 4.6318708603E+00, 1.6769739360E+01, 3.2374130934E+00, 9.6846959678E-01],
	[3.5430000000E+04, 2.9981612173E+01, 4.6318910657E+00, 1.6777547385E+01, 3.2377989852E+00, 9.6848627759E-01],
	[3.5435000000E+04, 2.9988911184E+01, 4.6319112682E+00, 1.6785357942E+01, 3.2381847584E+00, 9.6850294888E-01],
	[3.5440000000E+04, 2.9996210942E+01, 4.6319314680E+00, 1.6793171033E+01, 3.2385704130E+00, 9.6851961065E-01],
	[3.5445000000E+04, 3.0003511447E+01, 4.6319516650E+00, 1.6800986657E+01, 3.2389559490E+00, 9.6853626291E-01],
	[3.5450000000E+04, 3.0010812698E+01, 4.6319718593E+00, 1.6808804816E+01, 3.2393413665E+00, 9.6855290568E-01],
	[3.5455000000E+04, 3.0018114696E+01, 4.6319920508E+00, 1.6816625508E+01, 3.2397266654E+00, 9.6856953894E-01],
	[3.5460000000E+04, 3.0025417441E+01, 4.6320122396E+00, 1.6824448736E+01, 3.2401118459E+00, 9.6858616272E-01],
	[3.5465000000E+04, 3.0032720932E+01, 4.6320324256E+00, 1.6832274499E+01, 3.2404969079E+00, 9.6860277700E-01],
	[3.5470000000E+04, 3.0040025169E+01, 4.6320526088E+00, 1.6840102798E+01, 3.2408818515E+00, 9.6861938181E-01],
	[3.5475000000E+04, 3.0047330154E+01, 4.6320727893E+00, 1.6847933634E+01, 3.2412666767E+00, 9.6863597715E-01],
	[3.5480000000E+04, 3.0054635884E+01, 4.6320929670E+00, 1.6855767006E+01, 3.2416513836E+00, 9.6865256301E-01],
	[3.5485000000E+04, 3.0061942361E+01, 4.6321131420E+00, 1.6863602915E+01, 3.2420359721E+00, 9.6866913941E-01],
	[3.5490000000E+04, 3.0069249585E+01, 4.6321333142E+00, 1.6871441362E+01, 3.2424204424E+00, 9.6868570636E-01],
	[3.5495000000E+04, 3.0076557555E+01, 4.6321534836E+00, 1.6879282347E+01, 3.2428047944E+00, 9.6870226385E-01],
	[3.5500000000E+04, 3.0083866271E+01, 4.6321736504E+00, 1.6887125871E+01, 3.2431890281E+00, 9.6871881190E-01],
	[3.5505000000E+04, 3.0091175734E+01, 4.6321938143E+00, 1.6894971934E+01, 3.2435731437E+00, 9.6873535051E-01],
	[3.5510000000E+04, 3.0098485943E+01, 4.6322139755E+00, 1.6902820537E+01, 3.2439571411E+00, 9.6875187968E-01],
	[3.5515000000E+04, 3.0105796898E+01, 4.6322341340E+00, 1.6910671680E+01, 3.2443410204E+00, 9.6876839943E-01],
	[3.5520000000E+04, 3.0113108600E+01, 4.6322542897E+00, 1.6918525363E+01, 3.2447247815E+00, 9.6878490975E-01],
	[3.5525000000E+04, 3.0120421047E+01, 4.6322744426E+00, 1.6926381587E+01, 3.2451084246E+00, 9.6880141065E-01],
	[3.5530000000E+04, 3.0127734241E+01, 4.6322945928E+00, 1.6934240353E+01, 3.2454919497E+00, 9.6881790214E-01],
	[3.5535000000E+04, 3.0135048181E+01, 4.6323147403E+00, 1.6942101660E+01, 3.2458753567E+00, 9.6883438423E-01],
	[3.5540000000E+04, 3.0142362868E+01, 4.6323348850E+00, 1.6949965510E+01, 3.2462586458E+00, 9.6885085691E-01],
	[3.5545000000E+04, 3.0149678300E+01, 4.6323550269E+00, 1.6957831903E+01, 3.2466418170E+00, 9.6886732020E-01],
	[3.5550000000E+04, 3.0156994479E+01, 4.6323751662E+00, 1.6965700839E+01, 3.2470248702E+00, 9.6888377410E-01],
	[3.5555000000E+04, 3.0164311403E+01, 4.6323953026E+00, 1.6973572318E+01, 3.2474078056E+00, 9.6890021862E-01],
	[3.5560000000E+04, 3.0171629074E+01, 4.6324154364E+00, 1.6981446342E+01, 3.2477906231E+00, 9.6891665376E-01],
	[3.5565000000E+04, 3.0178947490E+01, 4.6324355673E+00, 1.6989322911E+01, 3.2481733228E+00, 9.6893307953E-01],
	[3.5570000000E+04, 3.0186266653E+01, 4.6324556956E+00, 1.6997202025E+01, 3.2485559047E+00, 9.6894949593E-01],
	[3.5575000000E+04, 3.0193586561E+01, 4.6324758211E+00, 1.7005083684E+01, 3.2489383689E+00, 9.6896590297E-01],
	[3.5580000000E+04, 3.0200907216E+01, 4.6324959438E+00, 1.7012967890E+01, 3.2493207153E+00, 9.6898230066E-01],
	[3.5585000000E+04, 3.0208228616E+01, 4.6325160639E+00, 1.7020854642E+01, 3.2497029441E+00, 9.6899868899E-01],
	[3.5590000000E+04, 3.0215550762E+01, 4.6325361811E+00, 1.7028743941E+01, 3.2500850552E+00, 9.6901506798E-01],
	[3.5595000000E+04, 3.0222873654E+01, 4.6325562957E+00, 1.7036635787E+01, 3.2504670487E+00, 9.6903143764E-01],
	[3.5600000000E+04, 3.0230197292E+01, 4.6325764075E+00, 1.7044530182E+01, 3.2508489246E+00, 9.6904779796E-01],
	[3.5605000000E+04, 3.0237521675E+01, 4.6325965165E+00, 1.7052427125E+01, 3.2512306829E+00, 9.6906414895E-01],
	[3.5610000000E+04, 3.0244846805E+01, 4.6326166229E+00, 1.7060326616E+01, 3.2516123238E+00, 9.6908049063E-01],
	[3.5615000000E+04, 3.0252172680E+01, 4.6326367265E+00, 1.7068228658E+01, 3.2519938471E+00, 9.6909682298E-01],
	[3.5620000000E+04, 3.0259499300E+01, 4.6326568273E+00, 1.7076133248E+01, 3.2523752530E+00, 9.6911314603E-01],
	[3.5625000000E+04, 3.0266826667E+01, 4.6326769255E+00, 1.7084040390E+01, 3.2527565414E+00, 9.6912945977E-01],
	[3.5630000000E+04, 3.0274154779E+01, 4.6326970208E+00, 1.7091950081E+01, 3.2531377124E+00, 9.6914576422E-01],
	[3.5635000000E+04, 3.0281483636E+01, 4.6327171135E+00, 1.7099862324E+01, 3.2535187661E+00, 9.6916205937E-01],
	[3.5640000000E+04, 3.0288813239E+01, 4.6327372034E+00, 1.7107777119E+01, 3.2538997025E+00, 9.6917834523E-01],
	[3.5645000000E+04, 3.0296143588E+01, 4.6327572906E+00, 1.7115694466E+01, 3.2542805215E+00, 9.6919462182E-01],
	[3.5650000000E+04, 3.0303474682E+01, 4.6327773751E+00, 1.7123614365E+01, 3.2546612233E+00, 9.6921088912E-01],
	[3.5655000000E+04, 3.0310819644E+01, 4.6327990385E+00, 1.7131536818E+01, 3.2550427399E+00, 9.6922714716E-01],
	[3.5660000000E+04, 3.0318170893E+01, 4.6328213660E+00, 1.7139461824E+01, 3.2554245328E+00, 9.6924339593E-01],
	[3.5665000000E+04, 3.0325522893E+01, 4.6328436906E+00, 1.7147389384E+01, 3.2558062089E+00, 9.6925963544E-01],
	[3.5670000000E+04, 3.0332875645E+01, 4.6328660121E+00, 1.7155319498E+01, 3.2561877682E+00, 9.6927586570E-01],
	[3.5675000000E+04, 3.0340229150E+01, 4.6328883307E+00, 1.7163252167E+01, 3.2565692106E+00, 9.6929208671E-01],
	[3.5680000000E+04, 3.0347583405E+01, 4.6329106462E+00, 1.7171187392E+01, 3.2569505363E+00, 9.6930829847E-01],
	[3.5685000000E+04, 3.0354938413E+01, 4.6329329586E+00, 1.7179125172E+01, 3.2573317453E+00, 9.6932450101E-01],
	[3.5690000000E+04, 3.0362294172E+01, 4.6329552681E+00, 1.7187065509E+01, 3.2577128376E+00, 9.6934069431E-01],
	[3.5695000000E+04, 3.0369650683E+01, 4.6329775745E+00, 1.7195008403E+01, 3.2580938132E+00, 9.6935687838E-01],
	[3.5700000000E+04, 3.0377007946E+01, 4.6329998780E+00, 1.7202953854E+01, 3.2584746722E+00, 9.6937305323E-01],
	[3.5705000000E+04, 3.0384365960E+01, 4.6330221784E+00, 1.7210901862E+01, 3.2588554146E+00, 9.6938921887E-01],
	[3.5710000000E+04, 3.0391724726E+01, 4.6330444758E+00, 1.7218852429E+01, 3.2592360404E+00, 9.6940537531E-01],
	[3.5715000000E+04, 3.0399084243E+01, 4.6330667701E+00, 1.7226805554E+01, 3.2596165497E+00, 9.6942152253E-01],
	[3.5720000000E+04, 3.0406444512E+01, 4.6330890615E+00, 1.7234761238E+01, 3.2599969425E+00, 9.6943766057E-01],
	[3.5725000000E+04, 3.0413805532E+01, 4.6331113499E+00, 1.7242719482E+01, 3.2603772188E+00, 9.6945378941E-01],
	[3.5730000000E+04, 3.0421167304E+01, 4.6331336352E+00, 1.7250680286E+01, 3.2607573787E+00, 9.6946990906E-01],
	[3.5735000000E+04, 3.0428529827E+01, 4.6331559175E+00, 1.7258643651E+01, 3.2611374221E+00, 9.6948601953E-01],
	[3.5740000000E+04, 3.0435893102E+01, 4.6331781968E+00, 1.7266609576E+01, 3.2615173492E+00, 9.6950212083E-01],
	[3.5745000000E+04, 3.0443257128E+01, 4.6332004731E+00, 1.7274578063E+01, 3.2618971600E+00, 9.6951821296E-01],
	[3.5750000000E+04, 3.0450621906E+01, 4.6332227464E+00, 1.7282549111E+01, 3.2622768544E+00, 9.6953429592E-01],
	[3.5755000000E+04, 3.0457987435E+01, 4.6332450167E+00, 1.7290522722E+01, 3.2626564325E+00, 9.6955036973E-01],
	[3.5760000000E+04, 3.0465353715E+01, 4.6332672840E+00, 1.7298498896E+01, 3.2630358944E+00, 9.6956643438E-01],
	[3.5765000000E+04, 3.0472720746E+01, 4.6332895483E+00, 1.7306477633E+01, 3.2634152401E+00, 9.6958248989E-01],
	[3.5770000000E+04, 3.0480088529E+01, 4.6333118096E+00, 1.7314458934E+01, 3.2637944696E+00, 9.6959853626E-01],
	[3.5775000000E+04, 3.0487457063E+01, 4.6333340678E+00, 1.7322442799E+01, 3.2641735829E+00, 9.6961457349E-01],
	[3.5780000000E+04, 3.0494826348E+01, 4.6333563231E+00, 1.7330429229E+01, 3.2645525802E+00, 9.6963060159E-01],
	[3.5785000000E+04, 3.0502196384E+01, 4.6333785754E+00, 1.7338418224E+01, 3.2649314613E+00, 9.6964662056E-01],
	[3.5790000000E+04, 3.0509567171E+01, 4.6334008246E+00, 1.7346409784E+01, 3.2653102263E+00, 9.6966263042E-01],
	[3.5795000000E+04, 3.0516938710E+01, 4.6334230709E+00, 1.7354403911E+01, 3.2656888754E+00, 9.6967863116E-01],
	[3.5800000000E+04, 3.0524310999E+01, 4.6334453142E+00, 1.7362400604E+01, 3.2660674084E+00, 9.6969462280E-01],
	[3.5805000000E+04, 3.0531684040E+01, 4.6334675544E+00, 1.7370399864E+01, 3.2664458255E+00, 9.6971060533E-01],
	[3.5810000000E+04, 3.0539057831E+01, 4.6334897917E+00, 1.7378401692E+01, 3.2668241267E+00, 9.6972657877E-01],
	[3.5815000000E+04, 3.0546432374E+01, 4.6335120259E+00, 1.7386406087E+01, 3.2672023119E+00, 9.6974254311E-01],
	[3.5820000000E+04, 3.0553807668E+01, 4.6335342572E+00, 1.7394413051E+01, 3.2675803813E+00, 9.6975849837E-01],
	[3.5825000000E+04, 3.0561183712E+01, 4.6335564855E+00, 1.7402422584E+01, 3.2679583349E+00, 9.6977444456E-01],
	[3.5830000000E+04, 3.0568560507E+01, 4.6335787107E+00, 1.7410434686E+01, 3.2683361726E+00, 9.6979038166E-01],
	[3.5835000000E+04, 3.0575938054E+01, 4.6336009330E+00, 1.7418449357E+01, 3.2687138946E+00, 9.6980630970E-01],
	[3.5840000000E+04, 3.0583316351E+01, 4.6336231523E+00, 1.7426466599E+01, 3.2690915008E+00, 9.6982222867E-01],
	[3.5845000000E+04, 3.0590695399E+01, 4.6336453686E+00, 1.7434486412E+01, 3.2694689913E+00, 9.6983813859E-01],
	[3.5850000000E+04, 3.0598075198E+01, 4.6336675819E+00, 1.7442508796E+01, 3.2698463662E+00, 9.6985403945E-01],
	[3.5855000000E+04, 3.0605455747E+01, 4.6336897922E+00, 1.7450533752E+01, 3.2702236254E+00, 9.6986993128E-01],
	[3.5860000000E+04, 3.0612837047E+01, 4.6337119995E+00, 1.7458561280E+01, 3.2706007690E+00, 9.6988581409E-01],
	[3.5865000000E+04, 3.0620219098E+01, 4.6337342038E+00, 1.7466591380E+01, 3.2709777970E+00, 9.6990168789E-01],
	[3.5870000000E+04, 3.0627601900E+01, 4.6337564052E+00, 1.7474624053E+01, 3.2713547094E+00, 9.6991755268E-01],
	[3.5875000000E+04, 3.0634985452E+01, 4.6337786035E+00, 1.7482659300E+01, 3.2717315064E+00, 9.6993340847E-01],
	[3.5880000000E+04, 3.0642369755E+01, 4.6338007989E+00, 1.7490697121E+01, 3.2721081878E+00, 9.6994925526E-01],
	[3.5885000000E+04, 3.0649754809E+01, 4.6338229913E+00, 1.7498737516E+01, 3.2724847538E+00, 9.6996509305E-01],
	[3.5890000000E+04, 3.0657140613E+01, 4.6338451807E+00, 1.7506780487E+01, 3.2728612044E+00, 9.6998092186E-01],
	[3.5895000000E+04, 3.0664527167E+01, 4.6338673671E+00, 1.7514826032E+01, 3.2732375396E+00, 9.6999674169E-01],
	[3.5900000000E+04, 3.0671914472E+01, 4.6338895505E+00, 1.7522874154E+01, 3.2736137595E+00, 9.7001255254E-01],
	[3.5905000000E+04, 3.0679302528E+01, 4.6339117309E+00, 1.7530924851E+01, 3.2739898640E+00, 9.7002835441E-01],
	[3.5910000000E+04, 3.0686691334E+01, 4.6339339084E+00, 1.7538978126E+01, 3.2743658532E+00, 9.7004414732E-01],
	[3.5915000000E+04, 3.0694080891E+01, 4.6339560829E+00, 1.7547033978E+01, 3.2747417271E+00, 9.7005993126E-01],
	[3.5920000000E+04, 3.0701471197E+01, 4.6339782544E+00, 1.7555092407E+01, 3.2751174858E+00, 9.7007570625E-01],
	[3.5925000000E+04, 3.0708862255E+01, 4.6340004229E+00, 1.7563153415E+01, 3.2754931294E+00, 9.7009147228E-01],
	[3.5930000000E+04, 3.0716254062E+01, 4.6340225884E+00, 1.7571217001E+01, 3.2758686577E+00, 9.7010722936E-01],
	[3.5935000000E+04, 3.0723646620E+01, 4.6340447510E+00, 1.7579283166E+01, 3.2762440709E+00, 9.7012297749E-01],
	[3.5940000000E+04, 3.0731039928E+01, 4.6340669105E+00, 1.7587351911E+01, 3.2766193691E+00, 9.7013871669E-01],
	[3.5945000000E+04, 3.0738433987E+01, 4.6340890671E+00, 1.7595423236E+01, 3.2769945521E+00, 9.7015444695E-01],
	[3.5950000000E+04, 3.0745828795E+01, 4.6341112208E+00, 1.7603497142E+01, 3.2773696201E+00, 9.7017016828E-01],
	[3.5955000000E+04, 3.0753224354E+01, 4.6341333714E+00, 1.7611573628E+01, 3.2777445731E+00, 9.7018588069E-01],
	[3.5960000000E+04, 3.0760620663E+01, 4.6341555191E+00, 1.7619652696E+01, 3.2781194111E+00, 9.7020158417E-01],
	[3.5965000000E+04, 3.0768017723E+01, 4.6341776638E+00, 1.7627734346E+01, 3.2784941342E+00, 9.7021727874E-01],
	[3.5970000000E+04, 3.0775415532E+01, 4.6341998055E+00, 1.7635818578E+01, 3.2788687424E+00, 9.7023296440E-01],
	[3.5975000000E+04, 3.0782814091E+01, 4.6342219443E+00, 1.7643905393E+01, 3.2792432357E+00, 9.7024864115E-01],
	[3.5980000000E+04, 3.0790213401E+01, 4.6342440801E+00, 1.7651994791E+01, 3.2796176141E+00, 9.7026430900E-01],
	[3.5985000000E+04, 3.0797613460E+01, 4.6342662129E+00, 1.7660086773E+01, 3.2799918778E+00, 9.7027996796E-01],
	[3.5990000000E+04, 3.0805014270E+01, 4.6342883427E+00, 1.7668181339E+01, 3.2803660266E+00, 9.7029561802E-01],
	[3.5995000000E+04, 3.0812415829E+01, 4.6343104696E+00, 1.7676278490E+01, 3.2807400607E+00, 9.7031125920E-01],
	[3.6000000000E+04, 3.0819818138E+01, 4.6343325935E+00, 1.7684378226E+01, 3.2811139801E+00, 9.7032689150E-01],
	[3.6005000000E+04, 3.0827221198E+01, 4.6343547145E+00, 1.7692480548E+01, 3.2814877847E+00, 9.7034251492E-01],
	[3.6010000000E+04, 3.0834625007E+01, 4.6343768325E+00, 1.7700585456E+01, 3.2818614748E+00, 9.7035812946E-01],
	[3.6015000000E+04, 3.0842029566E+01, 4.6343989475E+00, 1.7708692950E+01, 3.2822350502E+00, 9.7037373514E-01],
	[3.6020000000E+04, 3.0849434875E+01, 4.6344210595E+00, 1.7716803031E+01, 3.2826085110E+00, 9.7038933196E-01],
	[3.6025000000E+04, 3.0856840934E+01, 4.6344431686E+00, 1.7724915700E+01, 3.2829818572E+00, 9.7040491992E-01],
	[3.6030000000E+04, 3.0864247742E+01, 4.6344652747E+00, 1.7733030957E+01, 3.2833550890E+00, 9.7042049902E-01],
	[3.6035000000E+04, 3.0871655300E+01, 4.6344873779E+00, 1.7741148802E+01, 3.2837282062E+00, 9.7043606928E-01],
	[3.6040000000E+04, 3.0879063608E+01, 4.6345094781E+00, 1.7749269236E+01, 3.2841012089E+00, 9.7045163070E-01],
	[3.6045000000E+04, 3.0886472666E+01, 4.6345315753E+00, 1.7757392260E+01, 3.2844740973E+00, 9.7046718328E-01],
	[3.6050000000E+04, 3.0893882473E+01, 4.6345536696E+00, 1.7765517873E+01, 3.2848468712E+00, 9.7048272702E-01],
	[3.6055000000E+04, 3.0901293030E+01, 4.6345757609E+00, 1.7773646077E+01, 3.2852195308E+00, 9.7049826193E-01],
	[3.6060000000E+04, 3.0908704337E+01, 4.6345978493E+00, 1.7781776871E+01, 3.2855920760E+00, 9.7051378802E-01],
	[3.6065000000E+04, 3.0916116393E+01, 4.6346199347E+00, 1.7789910257E+01, 3.2859645069E+00, 9.7052930530E-01],
	[3.6070000000E+04, 3.0923529199E+01, 4.6346420171E+00, 1.7798046234E+01, 3.2863368235E+00, 9.7054481375E-01],
	[3.6075000000E+04, 3.0930942754E+01, 4.6346640966E+00, 1.7806184803E+01, 3.2867090259E+00, 9.7056031340E-01],
	[3.6080000000E+04, 3.0938357058E+01, 4.6346861732E+00, 1.7814325965E+01, 3.2870811141E+00, 9.7057580425E-01],
	[3.6085000000E+04, 3.0945772113E+01, 4.6347082468E+00, 1.7822469720E+01, 3.2874530881E+00, 9.7059128629E-01],
	[3.6090000000E+04, 3.0953187916E+01, 4.6347303174E+00, 1.7830616069E+01, 3.2878249480E+00, 9.7060675954E-01],
	[3.6095000000E+04, 3.0960604469E+01, 4.6347523851E+00, 1.7838765012E+01, 3.2881966938E+00, 9.7062222400E-01],
	[3.6100000000E+04, 3.0968021772E+01, 4.6347744498E+00, 1.7846916549E+01, 3.2885683254E+00, 9.7063767967E-01],
	[3.6105000000E+04, 3.0975439823E+01, 4.6347965116E+00, 1.7855070681E+01, 3.2889398431E+00, 9.7065312657E-01],
	[3.6110000000E+04, 3.0982858624E+01, 4.6348185704E+00, 1.7863227408E+01, 3.2893112467E+00, 9.7066856468E-01],
	[3.6115000000E+04, 3.0990278175E+01, 4.6348406263E+00, 1.7871386732E+01, 3.2896825363E+00, 9.7068399403E-01],
	[3.6120000000E+04, 3.0997698475E+01, 4.6348626792E+00, 1.7879548651E+01, 3.2900537119E+00, 9.7069941461E-01],
	[3.6125000000E+04, 3.1005119523E+01, 4.6348847292E+00, 1.7887713168E+01, 3.2904247737E+00, 9.7071482643E-01],
	[3.6130000000E+04, 3.1012541322E+01, 4.6349067762E+00, 1.7895880282E+01, 3.2907957215E+00, 9.7073022950E-01],
	[3.6135000000E+04, 3.1019963869E+01, 4.6349288203E+00, 1.7904049993E+01, 3.2911665555E+00, 9.7074562381E-01],
	[3.6140000000E+04, 3.1027387165E+01, 4.6349508614E+00, 1.7912222303E+01, 3.2915372757E+00, 9.7076100938E-01],
	[3.6145000000E+04, 3.1034811211E+01, 4.6349728996E+00, 1.7920397211E+01, 3.2919078821E+00, 9.7077638620E-01],
	[3.6150000000E+04, 3.1042236006E+01, 4.6349949349E+00, 1.7928574719E+01, 3.2922783747E+00, 9.7079175429E-01],
	[3.6155000000E+04, 3.1049661549E+01, 4.6350169672E+00, 1.7936754826E+01, 3.2926487536E+00, 9.7080711365E-01],
	[3.6160000000E+04, 3.1057087842E+01, 4.6350389966E+00, 1.7944937533E+01, 3.2930190188E+00, 9.7082246428E-01],
	[3.6165000000E+04, 3.1064514884E+01, 4.6350610230E+00, 1.7953122841E+01, 3.2933891703E+00, 9.7083780618E-01],
	[3.6170000000E+04, 3.1071942675E+01, 4.6350830465E+00, 1.7961310750E+01, 3.2937592082E+00, 9.7085313937E-01],
	[3.6175000000E+04, 3.1079371214E+01, 4.6351050670E+00, 1.7969501260E+01, 3.2941291325E+00, 9.7086846385E-01],
	[3.6180000000E+04, 3.1086800503E+01, 4.6351270847E+00, 1.7977694373E+01, 3.2944989432E+00, 9.7088377962E-01],
	[3.6185000000E+04, 3.1094230541E+01, 4.6351490993E+00, 1.7985890087E+01, 3.2948686404E+00, 9.7089908668E-01],
	[3.6190000000E+04, 3.1101661327E+01, 4.6351711111E+00, 1.7994088405E+01, 3.2952382240E+00, 9.7091438505E-01],
	[3.6195000000E+04, 3.1109092863E+01, 4.6351931199E+00, 1.8002289326E+01, 3.2956076942E+00, 9.7092967472E-01],
	[3.6200000000E+04, 3.1116525147E+01, 4.6352151257E+00, 1.8010492851E+01, 3.2959770510E+00, 9.7094495571E-01],
	[3.6205000000E+04, 3.1123958180E+01, 4.6352371286E+00, 1.8018698980E+01, 3.2963462943E+00, 9.7096022801E-01],
	[3.6210000000E+04, 3.1131391961E+01, 4.6352591286E+00, 1.8026907713E+01, 3.2967154243E+00, 9.7097549163E-01],
	[3.6215000000E+04, 3.1138826492E+01, 4.6352811257E+00, 1.8035119052E+01, 3.2970844409E+00, 9.7099074658E-01],
	[3.6220000000E+04, 3.1146261771E+01, 4.6353031198E+00, 1.8043332997E+01, 3.2974533442E+00, 9.7100599286E-01],
	[3.6225000000E+04, 3.1153697799E+01, 4.6353251110E+00, 1.8051549548E+01, 3.2978221342E+00, 9.7102123048E-01],
	[3.6230000000E+04, 3.1161151550E+01, 4.6353491100E+00, 1.8059768705E+01, 3.2981920192E+00, 9.7103645943E-01],
	[3.6235000000E+04, 3.1168607628E+01, 4.6353732921E+00, 1.8067990470E+01, 3.2985619031E+00, 9.7105167973E-01],
	[3.6240000000E+04, 3.1176064461E+01, 4.6353974709E+00, 1.8076214842E+01, 3.2989316741E+00, 9.7106689139E-01],
	[3.6245000000E+04, 3.1183522049E+01, 4.6354216465E+00, 1.8084441822E+01, 3.2993013322E+00, 9.7108209439E-01],
	[3.6250000000E+04, 3.1190980391E+01, 4.6354458189E+00, 1.8092671410E+01, 3.2996708775E+00, 9.7109728876E-01],
	[3.6255000000E+04, 3.1198439489E+01, 4.6354699881E+00, 1.8100903608E+01, 3.3000403100E+00, 9.7111247449E-01],
	[3.6260000000E+04, 3.1205899341E+01, 4.6354941540E+00, 1.8109138415E+01, 3.3004096298E+00, 9.7112765159E-01],
	[3.6265000000E+04, 3.1213359948E+01, 4.6355183168E+00, 1.8117375832E+01, 3.3007788368E+00, 9.7114282006E-01],
	[3.6270000000E+04, 3.1220821310E+01, 4.6355424764E+00, 1.8125615859E+01, 3.3011479311E+00, 9.7115797992E-01],
	[3.6275000000E+04, 3.1228283426E+01, 4.6355666327E+00, 1.8133858497E+01, 3.3015169128E+00, 9.7117313116E-01],
	[3.6280000000E+04, 3.1235746297E+01, 4.6355907859E+00, 1.8142103746E+01, 3.3018857818E+00, 9.7118827378E-01],
	[3.6285000000E+04, 3.1243209923E+01, 4.6356149359E+00, 1.8150351607E+01, 3.3022545382E+00, 9.7120340780E-01],
	[3.6290000000E+04, 3.1250674303E+01, 4.6356390826E+00, 1.8158602080E+01, 3.3026231821E+00, 9.7121853322E-01],
	[3.6295000000E+04, 3.1258139438E+01, 4.6356632262E+00, 1.8166855166E+01, 3.3029917134E+00, 9.7123365005E-01],
	[3.6300000000E+04, 3.1265605328E+01, 4.6356873665E+00, 1.8175110865E+01, 3.3033601322E+00, 9.7124875828E-01],
	[3.6305000000E+04, 3.1273071972E+01, 4.6357115037E+00, 1.8183369178E+01, 3.3037284386E+00, 9.7126385792E-01],
	[3.6310000000E+04, 3.1280539370E+01, 4.6357356376E+00, 1.8191630105E+01, 3.3040966325E+00, 9.7127894898E-01],
	[3.6315000000E+04, 3.1288007523E+01, 4.6357597684E+00, 1.8199893646E+01, 3.3044647139E+00, 9.7129403147E-01],
	[3.6320000000E+04, 3.1295476431E+01, 4.6357838960E+00, 1.8208159802E+01, 3.3048326830E+00, 9.7130910538E-01],
	[3.6325000000E+04, 3.1302946093E+01, 4.6358080203E+00, 1.8216428574E+01, 3.3052005398E+00, 9.7132417072E-01],
	[3.6330000000E+04, 3.1310416509E+01, 4.6358321415E+00, 1.8224699962E+01, 3.3055682842E+00, 9.7133922750E-01],
	[3.6335000000E+04, 3.1317887680E+01, 4.6358562595E+00, 1.8232973966E+01, 3.3059359164E+00, 9.7135427573E-01],
	[3.6340000000E+04, 3.1325359605E+01, 4.6358803743E+00, 1.8241250587E+01, 3.3063034363E+00, 9.7136931540E-01],
	[3.6345000000E+04, 3.1332832284E+01, 4.6359044859E+00, 1.8249529826E+01, 3.3066708439E+00, 9.7138434652E-01],
	[3.6350000000E+04, 3.1340305718E+01, 4.6359285943E+00, 1.8257811682E+01, 3.3070381394E+00, 9.7139936910E-01],
	[3.6355000000E+04, 3.1347779906E+01, 4.6359526995E+00, 1.8266096157E+01, 3.3074053228E+00, 9.7141438313E-01],
	[3.6360000000E+04, 3.1355254848E+01, 4.6359768015E+00, 1.8274383250E+01, 3.3077723940E+00, 9.7142938864E-01],
	[3.6365000000E+04, 3.1362730545E+01, 4.6360009003E+00, 1.8282672963E+01, 3.3081393531E+00, 9.7144438562E-01],
	[3.6370000000E+04, 3.1370206995E+01, 4.6360249960E+00, 1.8290965295E+01, 3.3085062001E+00, 9.7145937407E-01],
	[3.6375000000E+04, 3.1377684200E+01, 4.6360490884E+00, 1.8299260247E+01, 3.3088729351E+00, 9.7147435400E-01],
	[3.6380000000E+04, 3.1385162159E+01, 4.6360731777E+00, 1.8307557820E+01, 3.3092395581E+00, 9.7148932542E-01],
	[3.6385000000E+04, 3.1392640872E+01, 4.6360972638E+00, 1.8315858015E+01, 3.3096060692E+00, 9.7150428833E-01],
	[3.6390000000E+04, 3.1400120339E+01, 4.6361213467E+00, 1.8324160830E+01, 3.3099724683E+00, 9.7151924273E-01],
	[3.6395000000E+04, 3.1407600560E+01, 4.6361454264E+00, 1.8332466268E+01, 3.3103387555E+00, 9.7153418864E-01],
	[3.6400000000E+04, 3.1415081535E+01, 4.6361695029E+00, 1.8340774328E+01, 3.3107049309E+00, 9.7154912605E-01],
	[3.6405000000E+04, 3.1422563264E+01, 4.6361935763E+00, 1.8349085012E+01, 3.3110709943E+00, 9.7156405497E-01],
	[3.6410000000E+04, 3.1430045747E+01, 4.6362176464E+00, 1.8357398318E+01, 3.3114369460E+00, 9.7157897540E-01],
	[3.6415000000E+04, 3.1437528984E+01, 4.6362417134E+00, 1.8365714249E+01, 3.3118027860E+00, 9.7159388735E-01],
	[3.6420000000E+04, 3.1445012975E+01, 4.6362657772E+00, 1.8374032804E+01, 3.3121685141E+00, 9.7160879083E-01],
	[3.6425000000E+04, 3.1452497720E+01, 4.6362898379E+00, 1.8382353984E+01, 3.3125341306E+00, 9.7162368583E-01],
	[3.6430000000E+04, 3.1459983219E+01, 4.6363138953E+00, 1.8390677789E+01, 3.3128996353E+00, 9.7163857237E-01],
	[3.6435000000E+04, 3.1467469471E+01, 4.6363379496E+00, 1.8399004220E+01, 3.3132650285E+00, 9.7165345045E-01],
	[3.6440000000E+04, 3.1474956478E+01, 4.6363620007E+00, 1.8407333277E+01, 3.3136303100E+00, 9.7166832007E-01],
	[3.6445000000E+04, 3.1482444238E+01, 4.6363860486E+00, 1.8415664960E+01, 3.3139954799E+00, 9.7168318124E-01],
	[3.6450000000E+04, 3.1489932751E+01, 4.6364100934E+00, 1.8423999271E+01, 3.3143605383E+00, 9.7169803396E-01],
	[3.6455000000E+04, 3.1497422019E+01, 4.6364341350E+00, 1.8432336210E+01, 3.3147254851E+00, 9.7171287824E-01],
	[3.6460000000E+04, 3.1504912040E+01, 4.6364581734E+00, 1.8440675777E+01, 3.3150903205E+00, 9.7172771408E-01],
	[3.6465000000E+04, 3.1512402815E+01, 4.6364822086E+00, 1.8449017972E+01, 3.3154550444E+00, 9.7174254149E-01],
	[3.6470000000E+04, 3.1519894343E+01, 4.6365062407E+00, 1.8457362797E+01, 3.3158196568E+00, 9.7175736048E-01],
	[3.6475000000E+04, 3.1527386625E+01, 4.6365302696E+00, 1.8465710250E+01, 3.3161841579E+00, 9.7177217104E-01],
	[3.6480000000E+04, 3.1534879661E+01, 4.6365542953E+00, 1.8474060334E+01, 3.3165485476E+00, 9.7178697318E-01],
	[3.6485000000E+04, 3.1542373450E+01, 4.6365783179E+00, 1.8482413049E+01, 3.3169128260E+00, 9.7180176691E-01],
	[3.6490000000E+04, 3.1549867993E+01, 4.6366023372E+00, 1.8490768394E+01, 3.3172769931E+00, 9.7181655223E-01],
	[3.6495000000E+04, 3.1557363289E+01, 4.6366263535E+00, 1.8499126371E+01, 3.3176410489E+00, 9.7183132914E-01],
	[3.6500000000E+04, 3.1564859339E+01, 4.6366503665E+00, 1.8507486979E+01, 3.3180049935E+00, 9.7184609766E-01],
	[3.6505000000E+04, 3.1572356142E+01, 4.6366743764E+00, 1.8515850220E+01, 3.3183688268E+00, 9.7186085778E-01],
	[3.6510000000E+04, 3.1579853699E+01, 4.6366983831E+00, 1.8524216093E+01, 3.3187325490E+00, 9.7187560952E-01],
	[3.6515000000E+04, 3.1587352009E+01, 4.6367223867E+00, 1.8532584600E+01, 3.3190961601E+00, 9.7189035287E-01],
	[3.6520000000E+04, 3.1594851072E+01, 4.6367463871E+00, 1.8540955741E+01, 3.3194596600E+00, 9.7190508784E-01],
	[3.6525000000E+04, 3.1602350889E+01, 4.6367703844E+00, 1.8549329516E+01, 3.3198230489E+00, 9.7191981444E-01],
	[3.6530000000E+04, 3.1609851458E+01, 4.6367943784E+00, 1.8557705925E+01, 3.3201863267E+00, 9.7193453266E-01],
	[3.6535000000E+04, 3.1617352782E+01, 4.6368183694E+00, 1.8566084970E+01, 3.3205494935E+00, 9.7194924252E-01],
	[3.6540000000E+04, 3.1624854858E+01, 4.6368423571E+00, 1.8574466650E+01, 3.3209125494E+00, 9.7196394403E-01],
	[3.6545000000E+04, 3.1632357688E+01, 4.6368663417E+00, 1.8582850966E+01, 3.3212754942E+00, 9.7197863717E-01],
	[3.6550000000E+04, 3.1639861271E+01, 4.6368903232E+00, 1.8591237919E+01, 3.3216383282E+00, 9.7199332197E-01],
	[3.6555000000E+04, 3.1647365607E+01, 4.6369143015E+00, 1.8599627509E+01, 3.3220010513E+00, 9.7200799842E-01],
	[3.6560000000E+04, 3.1654870696E+01, 4.6369382766E+00, 1.8608019736E+01, 3.3223636635E+00, 9.7202266653E-01],
	[3.6565000000E+04, 3.1662376538E+01, 4.6369622486E+00, 1.8616414601E+01, 3.3227261649E+00, 9.7203732630E-01],
	[3.6570000000E+04, 3.1669883133E+01, 4.6369862174E+00, 1.8624812105E+01, 3.3230885555E+00, 9.7205197774E-01],
	[3.6575000000E+04, 3.1677390482E+01, 4.6370101831E+00, 1.8633212247E+01, 3.3234508353E+00, 9.7206662085E-01],
	[3.6580000000E+04, 3.1684898583E+01, 4.6370341456E+00, 1.8641615029E+01, 3.3238130044E+00, 9.7208125565E-01],
	[3.6585000000E+04, 3.1692407438E+01, 4.6370581050E+00, 1.8650020451E+01, 3.3241750629E+00, 9.7209588212E-01],
	[3.6590000000E+04, 3.1699917045E+01, 4.6370820612E+00, 1.8658428513E+01, 3.3245370106E+00, 9.7211050029E-01],
	[3.6595000000E+04, 3.1707427405E+01, 4.6371060142E+00, 1.8666839216E+01, 3.3248988477E+00, 9.7212511014E-01],
	[3.6600000000E+04, 3.1714938519E+01, 4.6371299642E+00, 1.8675252559E+01, 3.3252605743E+00, 9.7213971170E-01],
	[3.6605000000E+04, 3.1722450385E+01, 4.6371539109E+00, 1.8683668545E+01, 3.3256221902E+00, 9.7215430496E-01],
	[3.6610000000E+04, 3.1729963004E+01, 4.6371778546E+00, 1.8692087173E+01, 3.3259836956E+00, 9.7216888992E-01],
	[3.6615000000E+04, 3.1737476376E+01, 4.6372017950E+00, 1.8700508443E+01, 3.3263450906E+00, 9.7218346660E-01],
	[3.6620000000E+04, 3.1744990500E+01, 4.6372257324E+00, 1.8708932357E+01, 3.3267063750E+00, 9.7219803499E-01],
	[3.6625000000E+04, 3.1752505378E+01, 4.6372496666E+00, 1.8717358914E+01, 3.3270675490E+00, 9.7221259510E-01],
	[3.6630000000E+04, 3.1760021008E+01, 4.6372735976E+00, 1.8725788115E+01, 3.3274286126E+00, 9.7222714694E-01],
	[3.6635000000E+04, 3.1767537391E+01, 4.6372975255E+00, 1.8734219960E+01, 3.3277895658E+00, 9.7224169052E-01],
	[3.6640000000E+04, 3.1775054526E+01, 4.6373214503E+00, 1.8742654451E+01, 3.3281504087E+00, 9.7225622582E-01],
	[3.6645000000E+04, 3.1782572415E+01, 4.6373453719E+00, 1.8751091587E+01, 3.3285111412E+00, 9.7227075287E-01],
	[3.6650000000E+04, 3.1790091056E+01, 4.6373692904E+00, 1.8759531369E+01, 3.3288717635E+00, 9.7228527167E-01],
	[3.6655000000E+04, 3.1797610449E+01, 4.6373932057E+00, 1.8767973797E+01, 3.3292322755E+00, 9.7229978221E-01],
	[3.6660000000E+04, 3.1805130595E+01, 4.6374171179E+00, 1.8776418872E+01, 3.3295926773E+00, 9.7231428451E-01],
	[3.6665000000E+04, 3.1812651494E+01, 4.6374410270E+00, 1.8784866594E+01, 3.3299529689E+00, 9.7232877857E-01],
	[3.6670000000E+04, 3.1820173145E+01, 4.6374649329E+00, 1.8793316964E+01, 3.3303131503E+00, 9.7234326439E-01],
	[3.6675000000E+04, 3.1827695549E+01, 4.6374888357E+00, 1.8801769983E+01, 3.3306732217E+00, 9.7235774199E-01],
	[3.6680000000E+04, 3.1835218705E+01, 4.6375127353E+00, 1.8810225650E+01, 3.3310331829E+00, 9.7237221136E-01],
	[3.6685000000E+04, 3.1842742614E+01, 4.6375366319E+00, 1.8818683966E+01, 3.3313930341E+00, 9.7238667251E-01],
	[3.6690000000E+04, 3.1850267275E+01, 4.6375605252E+00, 1.8827144932E+01, 3.3317527752E+00, 9.7240112544E-01],
	[3.6695000000E+04, 3.1857792689E+01, 4.6375844155E+00, 1.8835608548E+01, 3.3321124064E+00, 9.7241557016E-01],
	[3.6700000000E+04, 3.1865318855E+01, 4.6376083026E+00, 1.8844074815E+01, 3.3324719276E+00, 9.7243000667E-01],
	[3.6705000000E+04, 3.1872845773E+01, 4.6376321866E+00, 1.8852543732E+01, 3.3328313388E+00, 9.7244443498E-01],
	[3.6710000000E+04, 3.1880373443E+01, 4.6376560675E+00, 1.8861015302E+01, 3.3331906402E+00, 9.7245885510E-01],
	[3.6715000000E+04, 3.1887901866E+01, 4.6376799452E+00, 1.8869489523E+01, 3.3335498317E+00, 9.7247326702E-01],
	[3.6720000000E+04, 3.1895431041E+01, 4.6377038198E+00, 1.8877966397E+01, 3.3339089133E+00, 9.7248767076E-01],
	[3.6725000000E+04, 3.1902960969E+01, 4.6377276913E+00, 1.8886445923E+01, 3.3342678852E+00, 9.7250206631E-01],
	[3.6730000000E+04, 3.1910491648E+01, 4.6377515596E+00, 1.8894928103E+01, 3.3346267472E+00, 9.7251645369E-01],
	[3.6735000000E+04, 3.1918023080E+01, 4.6377754248E+00, 1.8903412937E+01, 3.3349854996E+00, 9.7253083289E-01],
	[3.6740000000E+04, 3.1925555264E+01, 4.6377992869E+00, 1.8911900425E+01, 3.3353441422E+00, 9.7254520393E-01],
	[3.6745000000E+04, 3.1933088200E+01, 4.6378231459E+00, 1.8920390568E+01, 3.3357026751E+00, 9.7255956680E-01],
	[3.6750000000E+04, 3.1940621888E+01, 4.6378470018E+00, 1.8928883367E+01, 3.3360610984E+00, 9.7257392151E-01],
	[3.6755000000E+04, 3.1948156328E+01, 4.6378708545E+00, 1.8937378821E+01, 3.3364194121E+00, 9.7258826807E-01],
	[3.6760000000E+04, 3.1955691520E+01, 4.6378947041E+00, 1.8945876931E+01, 3.3367776161E+00, 9.7260260648E-01],
	[3.6765000000E+04, 3.1963227464E+01, 4.6379185506E+00, 1.8954377698E+01, 3.3371357107E+00, 9.7261693675E-01],
	[3.6770000000E+04, 3.1970764161E+01, 4.6379423939E+00, 1.8962881122E+01, 3.3374936957E+00, 9.7263125888E-01],
	[3.6775000000E+04, 3.1978301609E+01, 4.6379662342E+00, 1.8971387204E+01, 3.3378515712E+00, 9.7264557287E-01],
	[3.6780000000E+04, 3.1985839809E+01, 4.6379900713E+00, 1.8979895944E+01, 3.3382093373E+00, 9.7265987873E-01],
	[3.6785000000E+04, 3.1993378761E+01, 4.6380139053E+00, 1.8988407342E+01, 3.3385669940E+00, 9.7267417647E-01],
	[3.6790000000E+04, 3.2000918465E+01, 4.6380377362E+00, 1.8996921399E+01, 3.3389245412E+00, 9.7268846609E-01],
	[3.6795000000E+04, 3.2008458920E+01, 4.6380615640E+00, 1.9005438116E+01, 3.3392819791E+00, 9.7270274759E-01],
	[3.6800000000E+04, 3.2016000128E+01, 4.6380853886E+00, 1.9013957493E+01, 3.3396393077E+00, 9.7271702098E-01],
	[3.6805000000E+04, 3.2023542087E+01, 4.6381092102E+00, 1.9022479530E+01, 3.3399965269E+00, 9.7273128627E-01],
	[3.6810000000E+04, 3.2031089945E+01, 4.6381336279E+00, 1.9031004229E+01, 3.3403540038E+00, 9.7274554345E-01],
	[3.6815000000E+04, 3.2038651841E+01, 4.6381595895E+00, 1.9039531588E+01, 3.3407123184E+00, 9.7275979254E-01],
	[3.6820000000E+04, 3.2046214494E+01, 4.6381855476E+00, 1.9048061610E+01, 3.3410705242E+00, 9.7277403353E-01],
	[3.6825000000E+04, 3.2053777906E+01, 4.6382115024E+00, 1.9056594293E+01, 3.3414286210E+00, 9.7278826644E-01],
	[3.6830000000E+04, 3.2061342075E+01, 4.6382374538E+00, 1.9065129640E+01, 3.3417866090E+00, 9.7280249127E-01],
	[3.6835000000E+04, 3.2068907002E+01, 4.6382634018E+00, 1.9073667650E+01, 3.3421444881E+00, 9.7281670802E-01],
	[3.6840000000E+04, 3.2076472687E+01, 4.6382893464E+00, 1.9082208323E+01, 3.3425022584E+00, 9.7283091670E-01],
	[3.6845000000E+04, 3.2084039130E+01, 4.6383152877E+00, 1.9090751661E+01, 3.3428599200E+00, 9.7284511731E-01],
	[3.6850000000E+04, 3.2091606331E+01, 4.6383412255E+00, 1.9099297663E+01, 3.3432174728E+00, 9.7285930985E-01],
	[3.6855000000E+04, 3.2099174289E+01, 4.6383671600E+00, 1.9107846331E+01, 3.3435749170E+00, 9.7287349434E-01],
	[3.6860000000E+04, 3.2106743005E+01, 4.6383930912E+00, 1.9116397664E+01, 3.3439322524E+00, 9.7288767078E-01],
	[3.6865000000E+04, 3.2114312479E+01, 4.6384190189E+00, 1.9124951663E+01, 3.3442894793E+00, 9.7290183916E-01],
	[3.6870000000E+04, 3.2121882710E+01, 4.6384449433E+00, 1.9133508328E+01, 3.3446465975E+00, 9.7291599951E-01],
	[3.6875000000E+04, 3.2129453699E+01, 4.6384708643E+00, 1.9142067661E+01, 3.3450036071E+00, 9.7293015181E-01],
	[3.6880000000E+04, 3.2137025445E+01, 4.6384967820E+00, 1.9150629661E+01, 3.3453605082E+00, 9.7294429608E-01],
	[3.6885000000E+04, 3.2144597949E+01, 4.6385226963E+00, 1.9159194329E+01, 3.3457173008E+00, 9.7295843232E-01],
	[3.6890000000E+04, 3.2152171211E+01, 4.6385486072E+00, 1.9167761666E+01, 3.3460739849E+00, 9.7297256053E-01],
	[3.6895000000E+04, 3.2159745230E+01, 4.6385745147E+00, 1.9176331671E+01, 3.3464305605E+00, 9.7298668073E-01],
	[3.6900000000E+04, 3.2167320006E+01, 4.6386004189E+00, 1.9184904346E+01, 3.3467870277E+00, 9.7300079291E-01],
	[3.6905000000E+04, 3.2174895540E+01, 4.6386263197E+00, 1.9193479690E+01, 3.3471433866E+00, 9.7301489707E-01],
	[3.6910000000E+04, 3.2182471831E+01, 4.6386522172E+00, 1.9202057705E+01, 3.3474996370E+00, 9.7302899324E-01],
	[3.6915000000E+04, 3.2190048880E+01, 4.6386781112E+00, 1.9210638391E+01, 3.3478557792E+00, 9.7304308140E-01],
	[3.6920000000E+04, 3.2197626686E+01, 4.6387040020E+00, 1.9219221748E+01, 3.3482118130E+00, 9.7305716156E-01],
	[3.6925000000E+04, 3.2205205250E+01, 4.6387298893E+00, 1.9227807776E+01, 3.3485677386E+00, 9.7307123374E-01],
	[3.6930000000E+04, 3.2212784570E+01, 4.6387557733E+00, 1.9236396477E+01, 3.3489235560E+00, 9.7308529792E-01],
	[3.6935000000E+04, 3.2220364649E+01, 4.6387816540E+00, 1.9244987850E+01, 3.3492792652E+00, 9.7309935413E-01],
	[3.6940000000E+04, 3.2227945484E+01, 4.6388075313E+00, 1.9253581897E+01, 3.3496348662E+00, 9.7311340236E-01],
	[3.6945000000E+04, 3.2235527076E+01, 4.6388334052E+00, 1.9262178617E+01, 3.3499903590E+00, 9.7312744261E-01],
	[3.6950000000E+04, 3.2243109426E+01, 4.6388592757E+00, 1.9270778011E+01, 3.3503457438E+00, 9.7314147490E-01],
	[3.6955000000E+04, 3.2250692533E+01, 4.6388851430E+00, 1.9279380079E+01, 3.3507010205E+00, 9.7315549922E-01],
	[3.6960000000E+04, 3.2258276397E+01, 4.6389110068E+00, 1.9287984823E+01, 3.3510561891E+00, 9.7316951559E-01],
	[3.6965000000E+04, 3.2265861018E+01, 4.6389368673E+00, 1.9296592242E+01, 3.3514112497E+00, 9.7318352400E-01],
	[3.6970000000E+04, 3.2273446397E+01, 4.6389627245E+00, 1.9305202337E+01, 3.3517662024E+00, 9.7319752446E-01],
	[3.6975000000E+04, 3.2281032532E+01, 4.6389885783E+00, 1.9313815108E+01, 3.3521210471E+00, 9.7321151698E-01],
	[3.6980000000E+04, 3.2288619424E+01, 4.6390144287E+00, 1.9322430556E+01, 3.3524757839E+00, 9.7322550156E-01],
	[3.6985000000E+04, 3.2296207074E+01, 4.6390402758E+00, 1.9331048682E+01, 3.3528304128E+00, 9.7323947821E-01],
	[3.6990000000E+04, 3.2303795480E+01, 4.6390661195E+00, 1.9339669485E+01, 3.3531849339E+00, 9.7325344692E-01],
	[3.6995000000E+04, 3.2311384644E+01, 4.6390919599E+00, 1.9348292967E+01, 3.3535393471E+00, 9.7326740771E-01],
	[3.7000000000E+04, 3.2318974564E+01, 4.6391177970E+00, 1.9356919127E+01, 3.3538936525E+00, 9.7328136058E-01],
	[3.7005000000E+04, 3.2326565241E+01, 4.6391436307E+00, 1.9365547967E+01, 3.3542478502E+00, 9.7329530554E-01],
	[3.7010000000E+04, 3.2334156675E+01, 4.6391694610E+00, 1.9374179486E+01, 3.3546019402E+00, 9.7330924258E-01],
	[3.7015000000E+04, 3.2341748866E+01, 4.6391952880E+00, 1.9382813685E+01, 3.3549559225E+00, 9.7332317172E-01],
	[3.7020000000E+04, 3.2349341814E+01, 4.6392211117E+00, 1.9391450565E+01, 3.3553097971E+00, 9.7333709296E-01],
	[3.7025000000E+04, 3.2356935519E+01, 4.6392469320E+00, 1.9400090126E+01, 3.3556635640E+00, 9.7335100630E-01],
	[3.7030000000E+04, 3.2364529980E+01, 4.6392727490E+00, 1.9408732369E+01, 3.3560172234E+00, 9.7336491174E-01],
	[3.7035000000E+04, 3.2372125198E+01, 4.6392985626E+00, 1.9417377294E+01, 3.3563707752E+00, 9.7337880930E-01],
	[3.7040000000E+04, 3.2379721173E+01, 4.6393243729E+00, 1.9426024901E+01, 3.3567242195E+00, 9.7339269898E-01],
	[3.7045000000E+04, 3.2387317904E+01, 4.6393501798E+00, 1.9434675191E+01, 3.3570775563E+00, 9.7340658078E-01],
	[3.7050000000E+04, 3.2394915393E+01, 4.6393759834E+00, 1.9443328165E+01, 3.3574307855E+00, 9.7342045471E-01],
	[3.7055000000E+04, 3.2402513638E+01, 4.6394017837E+00, 1.9451983822E+01, 3.3577839074E+00, 9.7343432076E-01],
	[3.7060000000E+04, 3.2410112639E+01, 4.6394275806E+00, 1.9460642164E+01, 3.3581369218E+00, 9.7344817896E-01],
	[3.7065000000E+04, 3.2417712397E+01, 4.6394533742E+00, 1.9469303191E+01, 3.3584898289E+00, 9.7346202929E-01],
	[3.7070000000E+04, 3.2425312912E+01, 4.6394791645E+00, 1.9477966903E+01, 3.3588426286E+00, 9.7347587178E-01],
	[3.7075000000E+04, 3.2432914183E+01, 4.6395049514E+00, 1.9486633301E+01, 3.3591953210E+00, 9.7348970641E-01],
	[3.7080000000E+04, 3.2440516210E+01, 4.6395307350E+00, 1.9495302385E+01, 3.3595479061E+00, 9.7350353320E-01],
	[3.7085000000E+04, 3.2448118995E+01, 4.6395565153E+00, 1.9503974156E+01, 3.3599003839E+00, 9.7351735214E-01],
	[3.7090000000E+04, 3.2455722535E+01, 4.6395822922E+00, 1.9512648614E+01, 3.3602527546E+00, 9.7353116325E-01],
	[3.7095000000E+04, 3.2463326832E+01, 4.6396080658E+00, 1.9521325760E+01, 3.3606050180E+00, 9.7354496654E-01],
	[3.7100000000E+04, 3.2470931886E+01, 4.6396338361E+00, 1.9530005594E+01, 3.3609571743E+00, 9.7355876199E-01],
	[3.7105000000E+04, 3.2478537695E+01, 4.6396596030E+00, 1.9538688117E+01, 3.3613092234E+00, 9.7357254963E-01],
	[3.7110000000E+04, 3.2486144262E+01, 4.6396853666E+00, 1.9547373328E+01, 3.3616611655E+00, 9.7358632944E-01],
	[3.7115000000E+04, 3.2493751584E+01, 4.6397111269E+00, 1.9556061230E+01, 3.3620130005E+00, 9.7360010145E-01],
	[3.7120000000E+04, 3.2501359663E+01, 4.6397368838E+00, 1.9564751821E+01, 3.3623647285E+00, 9.7361386565E-01],
	[3.7125000000E+04, 3.2508968498E+01, 4.6397626375E+00, 1.9573445102E+01, 3.3627163494E+00, 9.7362762205E-01],
	[3.7130000000E+04, 3.2516578089E+01, 4.6397883878E+00, 1.9582141075E+01, 3.3630678634E+00, 9.7364137065E-01],
	[3.7135000000E+04, 3.2524188437E+01, 4.6398141347E+00, 1.9590839739E+01, 3.3634192705E+00, 9.7365511145E-01],
	[3.7140000000E+04, 3.2531799540E+01, 4.6398398784E+00, 1.9599541095E+01, 3.3637705706E+00, 9.7366884447E-01],
	[3.7145000000E+04, 3.2539411400E+01, 4.6398656187E+00, 1.9608245144E+01, 3.3641217639E+00, 9.7368256971E-01],
	[3.7150000000E+04, 3.2547024016E+01, 4.6398913557E+00, 1.9616951885E+01, 3.3644728503E+00, 9.7369628716E-01],
	[3.7155000000E+04, 3.2554637388E+01, 4.6399170894E+00, 1.9625661319E+01, 3.3648238299E+00, 9.7370999684E-01],
	[3.7160000000E+04, 3.2562251516E+01, 4.6399428198E+00, 1.9634373448E+01, 3.3651747027E+00, 9.7372369876E-01],
	[3.7165000000E+04, 3.2569866401E+01, 4.6399685468E+00, 1.9643088270E+01, 3.3655254688E+00, 9.7373739290E-01],
	[3.7170000000E+04, 3.2577482041E+01, 4.6399942705E+00, 1.9651805788E+01, 3.3658761282E+00, 9.7375107929E-01],
	[3.7175000000E+04, 3.2585098437E+01, 4.6400199910E+00, 1.9660526000E+01, 3.3662266809E+00, 9.7376475792E-01],
	[3.7180000000E+04, 3.2592715589E+01, 4.6400457080E+00, 1.9669248909E+01, 3.3665771269E+00, 9.7377842880E-01],
	[3.7185000000E+04, 3.2600333497E+01, 4.6400714218E+00, 1.9677974513E+01, 3.3669274663E+00, 9.7379209194E-01],
	[3.7190000000E+04, 3.2607952161E+01, 4.6400971323E+00, 1.9686702814E+01, 3.3672776991E+00, 9.7380574734E-01],
	[3.7195000000E+04, 3.2615571581E+01, 4.6401228394E+00, 1.9695433812E+01, 3.3676278253E+00, 9.7381939499E-01],
	[3.7200000000E+04, 3.2623191757E+01, 4.6401485433E+00, 1.9704167507E+01, 3.3679778451E+00, 9.7383303492E-01],
	[3.7205000000E+04, 3.2630812689E+01, 4.6401742438E+00, 1.9712903901E+01, 3.3683277583E+00, 9.7384666712E-01],
	[3.7210000000E+04, 3.2638434376E+01, 4.6401999410E+00, 1.9721642993E+01, 3.3686775650E+00, 9.7386029160E-01],
	[3.7215000000E+04, 3.2646056820E+01, 4.6402256349E+00, 1.9730384784E+01, 3.3690272654E+00, 9.7387390835E-01],
	[3.7220000000E+04, 3.2653680019E+01, 4.6402513255E+00, 1.9739129275E+01, 3.3693768593E+00, 9.7388751740E-01],
	[3.7225000000E+04, 3.2661303974E+01, 4.6402770128E+00, 1.9747876465E+01, 3.3697263468E+00, 9.7390111874E-01],
	[3.7230000000E+04, 3.2668928684E+01, 4.6403026968E+00, 1.9756626356E+01, 3.3700757280E+00, 9.7391471237E-01],
	[3.7235000000E+04, 3.2676554150E+01, 4.6403283774E+00, 1.9765378948E+01, 3.3704250029E+00, 9.7392829831E-01],
	[3.7240000000E+04, 3.2684180372E+01, 4.6403540548E+00, 1.9774134241E+01, 3.3707741715E+00, 9.7394187655E-01],
	[3.7245000000E+04, 3.2691807349E+01, 4.6403797288E+00, 1.9782892235E+01, 3.3711232339E+00, 9.7395544710E-01],
	[3.7250000000E+04, 3.2699435083E+01, 4.6404053996E+00, 1.9791652932E+01, 3.3714721900E+00, 9.7396900996E-01],
	[3.7255000000E+04, 3.2707063571E+01, 4.6404310671E+00, 1.9800416332E+01, 3.3718210400E+00, 9.7398256515E-01],
	[3.7260000000E+04, 3.2714692815E+01, 4.6404567312E+00, 1.9809182435E+01, 3.3721697838E+00, 9.7399611266E-01],
	[3.7265000000E+04, 3.2722322815E+01, 4.6404823920E+00, 1.9817951242E+01, 3.3725184215E+00, 9.7400965249E-01],
	[3.7270000000E+04, 3.2729953570E+01, 4.6405080496E+00, 1.9826722752E+01, 3.3728669532E+00, 9.7402318467E-01],
	[3.7275000000E+04, 3.2737585081E+01, 4.6405337038E+00, 1.9835496968E+01, 3.3732153787E+00, 9.7403670918E-01],
	[3.7280000000E+04, 3.2745217347E+01, 4.6405593548E+00, 1.9844273888E+01, 3.3735636982E+00, 9.7405022603E-01],
	[3.7285000000E+04, 3.2752850369E+01, 4.6405850024E+00, 1.9853053514E+01, 3.3739119118E+00, 9.7406373523E-01],
	[3.7290000000E+04, 3.2760484145E+01, 4.6406106468E+00, 1.9861835846E+01, 3.3742600194E+00, 9.7407723678E-01],
	[3.7295000000E+04, 3.2768118678E+01, 4.6406362878E+00, 1.9870620885E+01, 3.3746080210E+00, 9.7409073069E-01],
	[3.7300000000E+04, 3.2775753965E+01, 4.6406619256E+00, 1.9879408630E+01, 3.3749559167E+00, 9.7410421696E-01],
	[3.7305000000E+04, 3.2783390008E+01, 4.6406875600E+00, 1.9888199083E+01, 3.3753037066E+00, 9.7411769560E-01],
	[3.7310000000E+04, 3.2791026806E+01, 4.6407131912E+00, 1.9896992244E+01, 3.3756513906E+00, 9.7413116661E-01],
	[3.7315000000E+04, 3.2798664360E+01, 4.6407388191E+00, 1.9905788113E+01, 3.3759989689E+00, 9.7414463000E-01],
	[3.7320000000E+04, 3.2806302669E+01, 4.6407644437E+00, 1.9914586691E+01, 3.3763464413E+00, 9.7415808576E-01],
	[3.7325000000E+04, 3.2813941733E+01, 4.6407900650E+00, 1.9923387979E+01, 3.3766938080E+00, 9.7417153391E-01],
	[3.7330000000E+04, 3.2821581552E+01, 4.6408156830E+00, 1.9932191976E+01, 3.3770410690E+00, 9.7418497445E-01],
	[3.7335000000E+04, 3.2829222126E+01, 4.6408412977E+00, 1.9940998683E+01, 3.3773882244E+00, 9.7419840738E-01],
	[3.7340000000E+04, 3.2836863455E+01, 4.6408669091E+00, 1.9949808102E+01, 3.3777352740E+00, 9.7421183272E-01],
	[3.7345000000E+04, 3.2844505540E+01, 4.6408925172E+00, 1.9958620231E+01, 3.3780822181E+00, 9.7422525045E-01],
	[3.7350000000E+04, 3.2852148379E+01, 4.6409181221E+00, 1.9967435072E+01, 3.3784290566E+00, 9.7423866060E-01],
	[3.7355000000E+04, 3.2859791974E+01, 4.6409437236E+00, 1.9976252625E+01, 3.3787757895E+00, 9.7425206315E-01],
	[3.7360000000E+04, 3.2867436323E+01, 4.6409693219E+00, 1.9985072891E+01, 3.3791224169E+00, 9.7426545813E-01],
	[3.7365000000E+04, 3.2875081428E+01, 4.6409949169E+00, 1.9993895870E+01, 3.3794689388E+00, 9.7427884552E-01],
	[3.7370000000E+04, 3.2882727287E+01, 4.6410205086E+00, 2.0002721563E+01, 3.3798153552E+00, 9.7429222535E-01],
	[3.7375000000E+04, 3.2890373902E+01, 4.6410460970E+00, 2.0011549969E+01, 3.3801616662E+00, 9.7430559760E-01],
	[3.7380000000E+04, 3.2898021271E+01, 4.6410716822E+00, 2.0020381090E+01, 3.3805078719E+00, 9.7431896229E-01],
	[3.7385000000E+04, 3.2905669395E+01, 4.6410972640E+00, 2.0029214926E+01, 3.3808539721E+00, 9.7433231942E-01],
	[3.7390000000E+04, 3.2913318275E+01, 4.6411228426E+00, 2.0038051478E+01, 3.3811999670E+00, 9.7434566900E-01],
	[3.7395000000E+04, 3.2920967909E+01, 4.6411484179E+00, 2.0046890745E+01, 3.3815458566E+00, 9.7435901103E-01],
	[3.7400000000E+04, 3.2928618297E+01, 4.6411739899E+00, 2.0055732729E+01, 3.3818916410E+00, 9.7437234551E-01],
	[3.7405000000E+04, 3.2936283459E+01, 4.6412011639E+00, 2.0064577430E+01, 3.3822383204E+00, 9.7438567245E-01],
	[3.7410000000E+04, 3.2943953673E+01, 4.6412288260E+00, 2.0073424848E+01, 3.3825852011E+00, 9.7439899185E-01],
	[3.7415000000E+04, 3.2951624648E+01, 4.6412564845E+00, 2.0082274983E+01, 3.3829319770E+00, 9.7441230373E-01],
	[3.7420000000E+04, 3.2959296383E+01, 4.6412841394E+00, 2.0091127838E+01, 3.3832786479E+00, 9.7442560807E-01],
	[3.7425000000E+04, 3.2966968880E+01, 4.6413117909E+00, 2.0099983410E+01, 3.3836252140E+00, 9.7443890489E-01],
	[3.7430000000E+04, 3.2974642137E+01, 4.6413394388E+00, 2.0108841702E+01, 3.3839716752E+00, 9.7445219420E-01],
	[3.7435000000E+04, 3.2982316155E+01, 4.6413670832E+00, 2.0117702714E+01, 3.3843180317E+00, 9.7446547599E-01],
	[3.7440000000E+04, 3.2989990934E+01, 4.6413947241E+00, 2.0126566446E+01, 3.3846642834E+00, 9.7447875028E-01],
	[3.7445000000E+04, 3.2997666473E+01, 4.6414223614E+00, 2.0135432899E+01, 3.3850104304E+00, 9.7449201706E-01],
	[3.7450000000E+04, 3.3005342773E+01, 4.6414499952E+00, 2.0144302072E+01, 3.3853564726E+00, 9.7450527634E-01],
	[3.7455000000E+04, 3.3013019833E+01, 4.6414776255E+00, 2.0153173967E+01, 3.3857024102E+00, 9.7451852812E-01],
	[3.7460000000E+04, 3.3020697654E+01, 4.6415052523E+00, 2.0162048585E+01, 3.3860482432E+00, 9.7453177242E-01],
	[3.7465000000E+04, 3.3028376235E+01, 4.6415328755E+00, 2.0170925924E+01, 3.3863939715E+00, 9.7454500923E-01],
	[3.7470000000E+04, 3.3036055577E+01, 4.6415604952E+00, 2.0179805987E+01, 3.3867395953E+00, 9.7455823856E-01],
	[3.7475000000E+04, 3.3043735680E+01, 4.6415881114E+00, 2.0188688773E+01, 3.3870851145E+00, 9.7457146042E-01],
	[3.7480000000E+04, 3.3051416543E+01, 4.6416157241E+00, 2.0197574284E+01, 3.3874305292E+00, 9.7458467480E-01],
	[3.7485000000E+04, 3.3059098166E+01, 4.6416433333E+00, 2.0206462518E+01, 3.3877758394E+00, 9.7459788171E-01],
	[3.7490000000E+04, 3.3066780550E+01, 4.6416709389E+00, 2.0215353478E+01, 3.3881210452E+00, 9.7461108117E-01],
	[3.7495000000E+04, 3.3074463694E+01, 4.6416985410E+00, 2.0224247162E+01, 3.3884661466E+00, 9.7462427316E-01],
	[3.7500000000E+04, 3.3082147598E+01, 4.6417261396E+00, 2.0233143573E+01, 3.3888111435E+00, 9.7463745771E-01],
	[3.7505000000E+04, 3.3089832263E+01, 4.6417537347E+00, 2.0242042710E+01, 3.3891560361E+00, 9.7465063480E-01],
	[3.7510000000E+04, 3.3097517688E+01, 4.6417813263E+00, 2.0250944574E+01, 3.3895008244E+00, 9.7466380445E-01],
	[3.7515000000E+04, 3.3105203874E+01, 4.6418089143E+00, 2.0259849164E+01, 3.3898455084E+00, 9.7467696666E-01],
	[3.7520000000E+04, 3.3112890819E+01, 4.6418364989E+00, 2.0268756483E+01, 3.3901900881E+00, 9.7469012144E-01],
	[3.7525000000E+04, 3.3120578525E+01, 4.6418640799E+00, 2.0277666530E+01, 3.3905345636E+00, 9.7470326878E-01],
	[3.7530000000E+04, 3.3128266991E+01, 4.6418916575E+00, 2.0286579305E+01, 3.3908789349E+00, 9.7471640870E-01],
	[3.7535000000E+04, 3.3135956217E+01, 4.6419192315E+00, 2.0295494810E+01, 3.3912232020E+00, 9.7472954120E-01],
	[3.7540000000E+04, 3.3143646204E+01, 4.6419468020E+00, 2.0304413044E+01, 3.3915673649E+00, 9.7474266629E-01],
	[3.7545000000E+04, 3.3151336950E+01, 4.6419743690E+00, 2.0313334008E+01, 3.3919114238E+00, 9.7475578396E-01],
	[3.7550000000E+04, 3.3159028457E+01, 4.6420019325E+00, 2.0322257703E+01, 3.3922553786E+00, 9.7476889422E-01],
	[3.7555000000E+04, 3.3166720723E+01, 4.6420294924E+00, 2.0331184129E+01, 3.3925992293E+00, 9.7478199708E-01],
	[3.7560000000E+04, 3.3174413750E+01, 4.6420570489E+00, 2.0340113286E+01, 3.3929429760E+00, 9.7479509255E-01],
	[3.7565000000E+04, 3.3182107537E+01, 4.6420846019E+00, 2.0349045175E+01, 3.3932866187E+00, 9.7480818062E-01],
	[3.7570000000E+04, 3.3189802084E+01, 4.6421121514E+00, 2.0357979797E+01, 3.3936301575E+00, 9.7482126130E-01],
	[3.7575000000E+04, 3.3197497390E+01, 4.6421396973E+00, 2.0366917152E+01, 3.3939735924E+00, 9.7483433459E-01],
	[3.7580000000E+04, 3.3205193457E+01, 4.6421672398E+00, 2.0375857239E+01, 3.3943169233E+00, 9.7484740051E-01],
	[3.7585000000E+04, 3.3212890283E+01, 4.6421947788E+00, 2.0384800061E+01, 3.3946601504E+00, 9.7486045905E-01],
	[3.7590000000E+04, 3.3220587870E+01, 4.6422223142E+00, 2.0393745617E+01, 3.3950032737E+00, 9.7487351022E-01],
	[3.7595000000E+04, 3.3228286216E+01, 4.6422498462E+00, 2.0402693908E+01, 3.3953462932E+00, 9.7488655403E-01],
	[3.7600000000E+04, 3.3235985322E+01, 4.6422773747E+00, 2.0411644934E+01, 3.3956892089E+00, 9.7489959047E-01],
	[3.7605000000E+04, 3.3243685188E+01, 4.6423048996E+00, 2.0420598696E+01, 3.3960320208E+00, 9.7491261956E-01],
	[3.7610000000E+04, 3.3251385813E+01, 4.6423324211E+00, 2.0429555194E+01, 3.3963747291E+00, 9.7492564129E-01],
	[3.7615000000E+04, 3.3259087199E+01, 4.6423599391E+00, 2.0438514429E+01, 3.3967173337E+00, 9.7493865568E-01],
	[3.7620000000E+04, 3.3266789344E+01, 4.6423874536E+00, 2.0447476401E+01, 3.3970598346E+00, 9.7495166272E-01],
	[3.7625000000E+04, 3.3274492249E+01, 4.6424149646E+00, 2.0456441110E+01, 3.3974022320E+00, 9.7496466243E-01],
	[3.7630000000E+04, 3.3282195913E+01, 4.6424424721E+00, 2.0465408558E+01, 3.3977445257E+00, 9.7497765480E-01],
	[3.7635000000E+04, 3.3289900337E+01, 4.6424699761E+00, 2.0474378744E+01, 3.3980867159E+00, 9.7499063984E-01],
	[3.7640000000E+04, 3.3297605521E+01, 4.6424974766E+00, 2.0483351669E+01, 3.3984288026E+00, 9.7500361756E-01],
	[3.7645000000E+04, 3.3305311464E+01, 4.6425249736E+00, 2.0492327334E+01, 3.3987707858E+00, 9.7501658795E-01],
	[3.7650000000E+04, 3.3313018167E+01, 4.6425524672E+00, 2.0501305739E+01, 3.3991126656E+00, 9.7502955103E-01],
	[3.7655000000E+04, 3.3320725630E+01, 4.6425799572E+00, 2.0510286884E+01, 3.3994544419E+00, 9.7504250680E-01],
	[3.7660000000E+04, 3.3328433852E+01, 4.6426074438E+00, 2.0519270770E+01, 3.3997961148E+00, 9.7505545526E-01],
	[3.7665000000E+04, 3.3336142833E+01, 4.6426349269E+00, 2.0528257397E+01, 3.4001376844E+00, 9.7506839642E-01],
	[3.7670000000E+04, 3.3343852574E+01, 4.6426624064E+00, 2.0537246767E+01, 3.4004791506E+00, 9.7508133029E-01],
	[3.7675000000E+04, 3.3351563074E+01, 4.6426898825E+00, 2.0546238879E+01, 3.4008205136E+00, 9.7509425685E-01],
	[3.7680000000E+04, 3.3359274334E+01, 4.6427173552E+00, 2.0555233733E+01, 3.4011617732E+00, 9.7510717614E-01],
	[3.7685000000E+04, 3.3366986353E+01, 4.6427448243E+00, 2.0564231331E+01, 3.4015029296E+00, 9.7512008813E-01],
	[3.7690000000E+04, 3.3374699132E+01, 4.6427722900E+00, 2.0573231672E+01, 3.4018439828E+00, 9.7513299285E-01],
	[3.7695000000E+04, 3.3382412670E+01, 4.6427997521E+00, 2.0582234758E+01, 3.4021849329E+00, 9.7514589029E-01],
	[3.7700000000E+04, 3.3390126967E+01, 4.6428272108E+00, 2.0591240589E+01, 3.4025257798E+00, 9.7515878046E-01],
	[3.7705000000E+04, 3.3397842023E+01, 4.6428546661E+00, 2.0600249164E+01, 3.4028665236E+00, 9.7517166337E-01],
	[3.7710000000E+04, 3.3405557839E+01, 4.6428821178E+00, 2.0609260486E+01, 3.4032071643E+00, 9.7518453901E-01],
	[3.7715000000E+04, 3.3413274414E+01, 4.6429095661E+00, 2.0618274553E+01, 3.4035477019E+00, 9.7519740740E-01],
	[3.7720000000E+04, 3.3420991748E+01, 4.6429370108E+00, 2.0627291367E+01, 3.4038881365E+00, 9.7521026854E-01],
	[3.7725000000E+04, 3.3428709841E+01, 4.6429644521E+00, 2.0636310928E+01, 3.4042284681E+00, 9.7522312242E-01],
	[3.7730000000E+04, 3.3436428694E+01, 4.6429918900E+00, 2.0645333237E+01, 3.4045686968E+00, 9.7523596907E-01],
	[3.7735000000E+04, 3.3444148305E+01, 4.6430193243E+00, 2.0654358293E+01, 3.4049088226E+00, 9.7524880847E-01],
	[3.7740000000E+04, 3.3451868676E+01, 4.6430467552E+00, 2.0663386099E+01, 3.4052488454E+00, 9.7526164064E-01],
	[3.7745000000E+04, 3.3459589806E+01, 4.6430741826E+00, 2.0672416653E+01, 3.4055887654E+00, 9.7527446559E-01],
	[3.7750000000E+04, 3.3467311695E+01, 4.6431016066E+00, 2.0681449956E+01, 3.4059285825E+00, 9.7528728330E-01],
	[3.7755000000E+04, 3.3475034343E+01, 4.6431290271E+00, 2.0690486010E+01, 3.4062682969E+00, 9.7530009380E-01],
	[3.7760000000E+04, 3.3482757750E+01, 4.6431564441E+00, 2.0699524813E+01, 3.4066079085E+00, 9.7531289708E-01],
	[3.7765000000E+04, 3.3490481915E+01, 4.6431838576E+00, 2.0708566368E+01, 3.4069474173E+00, 9.7532569314E-01],
	[3.7770000000E+04, 3.3498206840E+01, 4.6432112677E+00, 2.0717610674E+01, 3.4072868234E+00, 9.7533848201E-01],
	[3.7775000000E+04, 3.3505932524E+01, 4.6432386743E+00, 2.0726657732E+01, 3.4076261268E+00, 9.7535126366E-01],
	[3.7780000000E+04, 3.3513658966E+01, 4.6432660774E+00, 2.0735707542E+01, 3.4079653276E+00, 9.7536403812E-01],
	[3.7785000000E+04, 3.3521386168E+01, 4.6432934771E+00, 2.0744760105E+01, 3.4083044258E+00, 9.7537680539E-01],
	[3.7790000000E+04, 3.3529114128E+01, 4.6433208733E+00, 2.0753815421E+01, 3.4086434214E+00, 9.7538956547E-01],
	[3.7795000000E+04, 3.3536842847E+01, 4.6433482661E+00, 2.0762873490E+01, 3.4089823144E+00, 9.7540231836E-01],
	[3.7800000000E+04, 3.3544572325E+01, 4.6433756553E+00, 2.0771934314E+01, 3.4093211049E+00, 9.7541506407E-01],
	[3.7805000000E+04, 3.3552302562E+01, 4.6434030412E+00, 2.0780997893E+01, 3.4096597929E+00, 9.7542780261E-01],
	[3.7810000000E+04, 3.3560033557E+01, 4.6434304235E+00, 2.0790064226E+01, 3.4099983785E+00, 9.7544053398E-01],
	[3.7815000000E+04, 3.3567765311E+01, 4.6434578024E+00, 2.0799133315E+01, 3.4103368616E+00, 9.7545325818E-01],
	[3.7820000000E+04, 3.3575497824E+01, 4.6434851779E+00, 2.0808205160E+01, 3.4106752423E+00, 9.7546597521E-01],
	[3.7825000000E+04, 3.3583231096E+01, 4.6435125499E+00, 2.0817279762E+01, 3.4110135206E+00, 9.7547868509E-01],
	[3.7830000000E+04, 3.3590965126E+01, 4.6435399184E+00, 2.0826357121E+01, 3.4113516966E+00, 9.7549138782E-01],
	[3.7835000000E+04, 3.3598699915E+01, 4.6435672835E+00, 2.0835437237E+01, 3.4116897703E+00, 9.7550408340E-01],
	[3.7840000000E+04, 3.3606435462E+01, 4.6435946451E+00, 2.0844520111E+01, 3.4120277418E+00, 9.7551677183E-01],
	[3.7845000000E+04, 3.3614171768E+01, 4.6436220033E+00, 2.0853605744E+01, 3.4123656109E+00, 9.7552945312E-01],
	[3.7850000000E+04, 3.3621908832E+01, 4.6436493580E+00, 2.0862694135E+01, 3.4127033779E+00, 9.7554212728E-01],
	[3.7855000000E+04, 3.3629646655E+01, 4.6436767092E+00, 2.0871785286E+01, 3.4130410427E+00, 9.7555479431E-01],
	[3.7860000000E+04, 3.3637385236E+01, 4.6437040570E+00, 2.0880879196E+01, 3.4133786053E+00, 9.7556745421E-01],
	[3.7865000000E+04, 3.3645124576E+01, 4.6437314014E+00, 2.0889975867E+01, 3.4137160658E+00, 9.7558010699E-01],
	[3.7870000000E+04, 3.3652864675E+01, 4.6437587423E+00, 2.0899075299E+01, 3.4140534242E+00, 9.7559275266E-01],
	[3.7875000000E+04, 3.3660605531E+01, 4.6437860798E+00, 2.0908177492E+01, 3.4143906806E+00, 9.7560539121E-01],
	[3.7880000000E+04, 3.3668347146E+01, 4.6438134138E+00, 2.0917282447E+01, 3.4147278349E+00, 9.7561802265E-01],
	[3.7885000000E+04, 3.3676089520E+01, 4.6438407443E+00, 2.0926390163E+01, 3.4150648872E+00, 9.7563064698E-01],
	[3.7890000000E+04, 3.3683832651E+01, 4.6438680715E+00, 2.0935500643E+01, 3.4154018376E+00, 9.7564326422E-01],
	[3.7895000000E+04, 3.3691576541E+01, 4.6438953951E+00, 2.0944613886E+01, 3.4157386860E+00, 9.7565587437E-01],
	[3.7900000000E+04, 3.3699321190E+01, 4.6439227154E+00, 2.0953729892E+01, 3.4160754325E+00, 9.7566847742E-01],
	[3.7905000000E+04, 3.3707066596E+01, 4.6439500322E+00, 2.0962848662E+01, 3.4164120772E+00, 9.7568107339E-01],
	[3.7910000000E+04, 3.3714812761E+01, 4.6439773455E+00, 2.0971970197E+01, 3.4167486200E+00, 9.7569366227E-01],
	[3.7915000000E+04, 3.3722559684E+01, 4.6440046554E+00, 2.0981094497E+01, 3.4170850610E+00, 9.7570624408E-01],
	[3.7920000000E+04, 3.3730307365E+01, 4.6440319619E+00, 2.0990221563E+01, 3.4174214002E+00, 9.7571881881E-01],
	[3.7925000000E+04, 3.3738055804E+01, 4.6440592649E+00, 2.0999351394E+01, 3.4177576376E+00, 9.7573138648E-01],
	[3.7930000000E+04, 3.3745805002E+01, 4.6440865645E+00, 2.1008483992E+01, 3.4180937734E+00, 9.7574394708E-01],
	[3.7935000000E+04, 3.3753554957E+01, 4.6441138606E+00, 2.1017619357E+01, 3.4184298074E+00, 9.7575650063E-01],
	[3.7940000000E+04, 3.3761305671E+01, 4.6441411533E+00, 2.1026757489E+01, 3.4187657398E+00, 9.7576904712E-01],
	[3.7945000000E+04, 3.3769057142E+01, 4.6441684426E+00, 2.1035898390E+01, 3.4191015706E+00, 9.7578158656E-01],
	[3.7950000000E+04, 3.3776809372E+01, 4.6441957284E+00, 2.1045042058E+01, 3.4194372997E+00, 9.7579411895E-01],
	[3.7955000000E+04, 3.3784562360E+01, 4.6442230108E+00, 2.1054188495E+01, 3.4197729273E+00, 9.7580664430E-01],
	[3.7960000000E+04, 3.3792316105E+01, 4.6442502898E+00, 2.1063337702E+01, 3.4201084534E+00, 9.7581916262E-01],
	[3.7965000000E+04, 3.3800070609E+01, 4.6442775654E+00, 2.1072489678E+01, 3.4204438780E+00, 9.7583167390E-01],
	[3.7970000000E+04, 3.3807825870E+01, 4.6443048375E+00, 2.1081644425E+01, 3.4207792011E+00, 9.7584417815E-01],
	[3.7975000000E+04, 3.3815581890E+01, 4.6443321061E+00, 2.1090801942E+01, 3.4211144227E+00, 9.7585667538E-01],
	[3.7980000000E+04, 3.3823338667E+01, 4.6443593714E+00, 2.1099962231E+01, 3.4214495430E+00, 9.7586916559E-01],
	[3.7985000000E+04, 3.3831096202E+01, 4.6443866332E+00, 2.1109125291E+01, 3.4217845618E+00, 9.7588164879E-01],
	[3.7990000000E+04, 3.3838854495E+01, 4.6444138916E+00, 2.1118291124E+01, 3.4221194793E+00, 9.7589412497E-01],
	[3.7995000000E+04, 3.3846613545E+01, 4.6444411465E+00, 2.1127459729E+01, 3.4224542955E+00, 9.7590659415E-01],
	[3.8000000000E+04, 3.3854373354E+01, 4.6444683981E+00, 2.1136631107E+01, 3.4227890104E+00, 9.7591905633E-01],
	[3.8005000000E+04, 3.3862140175E+01, 4.6444963508E+00, 2.1145805258E+01, 3.4231240708E+00, 9.7593151151E-01],
	[3.8010000000E+04, 3.3869919688E+01, 4.6445256438E+00, 2.1154982184E+01, 3.4234598819E+00, 9.7594395970E-01],
	[3.8015000000E+04, 3.3877699964E+01, 4.6445549331E+00, 2.1164161884E+01, 3.4237955922E+00, 9.7595640090E-01],
	[3.8020000000E+04, 3.3885481004E+01, 4.6445842187E+00, 2.1173344359E+01, 3.4241312015E+00, 9.7596883511E-01],
	[3.8025000000E+04, 3.3893262808E+01, 4.6446135007E+00, 2.1182529610E+01, 3.4244667098E+00, 9.7598126235E-01],
	[3.8030000000E+04, 3.3901045375E+01, 4.6446427790E+00, 2.1191717636E+01, 3.4248021174E+00, 9.7599368261E-01],
	[3.8035000000E+04, 3.3908828706E+01, 4.6446720536E+00, 2.1200908439E+01, 3.4251374241E+00, 9.7600609589E-01],
	[3.8040000000E+04, 3.3916612800E+01, 4.6447013246E+00, 2.1210102019E+01, 3.4254726300E+00, 9.7601850221E-01],
	[3.8045000000E+04, 3.3924397658E+01, 4.6447305919E+00, 2.1219298376E+01, 3.4258077351E+00, 9.7603090156E-01],
	[3.8050000000E+04, 3.3932183279E+01, 4.6447598556E+00, 2.1228497511E+01, 3.4261427395E+00, 9.7604329396E-01],
	[3.8055000000E+04, 3.3939969664E+01, 4.6447891156E+00, 2.1237699424E+01, 3.4264776432E+00, 9.7605567939E-01],
	[3.8060000000E+04, 3.3947756812E+01, 4.6448183719E+00, 2.1246904116E+01, 3.4268124462E+00, 9.7606805787E-01],
	[3.8065000000E+04, 3.3955544724E+01, 4.6448476246E+00, 2.1256111588E+01, 3.4271471485E+00, 9.7608042940E-01],
	[3.8070000000E+04, 3.3963333398E+01, 4.6448768736E+00, 2.1265321839E+01, 3.4274817503E+00, 9.7609279398E-01],
	[3.8075000000E+04, 3.3971122837E+01, 4.6449061189E+00, 2.1274534870E+01, 3.4278162514E+00, 9.7610515162E-01],
	[3.8080000000E+04, 3.3978913038E+01, 4.6449353606E+00, 2.1283750682E+01, 3.4281506520E+00, 9.7611750232E-01],
	[3.8085000000E+04, 3.3986704003E+01, 4.6449645987E+00, 2.1292969275E+01, 3.4284849520E+00, 9.7612984609E-01],
	[3.8090000000E+04, 3.3994495731E+01, 4.6449938331E+00, 2.1302190649E+01, 3.4288191516E+00, 9.7614218293E-01],
	[3.8095000000E+04, 3.4002288222E+01, 4.6450230638E+00, 2.1311414806E+01, 3.4291532507E+00, 9.7615451283E-01],
	[3.8100000000E+04, 3.4010081476E+01, 4.6450522909E+00, 2.1320641745E+01, 3.4294872494E+00, 9.7616683582E-01],
	[3.8105000000E+04, 3.4017875494E+01, 4.6450815143E+00, 2.1329871467E+01, 3.4298211476E+00, 9.7617915188E-01],
	[3.8110000000E+04, 3.4025670275E+01, 4.6451107341E+00, 2.1339103973E+01, 3.4301549455E+00, 9.7619146103E-01],
	[3.8115000000E+04, 3.4033465818E+01, 4.6451399502E+00, 2.1348339263E+01, 3.4304886431E+00, 9.7620376327E-01],
	[3.8120000000E+04, 3.4041262125E+01, 4.6451691627E+00, 2.1357577337E+01, 3.4308222403E+00, 9.7621605859E-01],
	[3.8125000000E+04, 3.4049059195E+01, 4.6451983716E+00, 2.1366818196E+01, 3.4311557373E+00, 9.7622834702E-01],
	[3.8130000000E+04, 3.4056857028E+01, 4.6452275768E+00, 2.1376061841E+01, 3.4314891340E+00, 9.7624062854E-01],
	[3.8135000000E+04, 3.4064655625E+01, 4.6452567783E+00, 2.1385308271E+01, 3.4318224305E+00, 9.7625290316E-01],
	[3.8140000000E+04, 3.4072454984E+01, 4.6452859762E+00, 2.1394557488E+01, 3.4321556268E+00, 9.7626517089E-01],
	[3.8145000000E+04, 3.4080255106E+01, 4.6453151705E+00, 2.1403809492E+01, 3.4324887229E+00, 9.7627743173E-01],
	[3.8150000000E+04, 3.4088055991E+01, 4.6453443611E+00, 2.1413064283E+01, 3.4328217189E+00, 9.7628968569E-01],
	[3.8155000000E+04, 3.4095857639E+01, 4.6453735480E+00, 2.1422321861E+01, 3.4331546148E+00, 9.7630193276E-01],
	[3.8160000000E+04, 3.4103660050E+01, 4.6454027314E+00, 2.1431582228E+01, 3.4334874107E+00, 9.7631417295E-01],
	[3.8165000000E+04, 3.4111463223E+01, 4.6454319111E+00, 2.1440845384E+01, 3.4338201065E+00, 9.7632640627E-01],
	[3.8170000000E+04, 3.4119267160E+01, 4.6454610871E+00, 2.1450111329E+01, 3.4341527023E+00, 9.7633863272E-01],
	[3.8175000000E+04, 3.4127071859E+01, 4.6454902595E+00, 2.1459380063E+01, 3.4344851981E+00, 9.7635085230E-01],
	[3.8180000000E+04, 3.4134877321E+01, 4.6455194283E+00, 2.1468651588E+01, 3.4348175940E+00, 9.7636306502E-01],
	[3.8185000000E+04, 3.4142683546E+01, 4.6455485934E+00, 2.1477925903E+01, 3.4351498900E+00, 9.7637527088E-01],
	[3.8190000000E+04, 3.4150490534E+01, 4.6455777549E+00, 2.1487203010E+01, 3.4354820861E+00, 9.7638746988E-01],
	[3.8195000000E+04, 3.4158298284E+01, 4.6456069128E+00, 2.1496482908E+01, 3.4358141823E+00, 9.7639966203E-01],
	[3.8200000000E+04, 3.4166106798E+01, 4.6456360670E+00, 2.1505765598E+01, 3.4361461787E+00, 9.7641184733E-01],
	[3.8205000000E+04, 3.4173916073E+01, 4.6456652176E+00, 2.1515051080E+01, 3.4364780753E+00, 9.7642402579E-01],
	[3.8210000000E+04, 3.4181726112E+01, 4.6456943646E+00, 2.1524339356E+01, 3.4368098722E+00, 9.7643619741E-01],
	[3.8215000000E+04, 3.4189536913E+01, 4.6457235080E+00, 2.1533630425E+01, 3.4371415693E+00, 9.7644836218E-01],
	[3.8220000000E+04, 3.4197348476E+01, 4.6457526477E+00, 2.1542924288E+01, 3.4374731668E+00, 9.7646052013E-01],
	[3.8225000000E+04, 3.4205160803E+01, 4.6457817837E+00, 2.1552220945E+01, 3.4378046645E+00, 9.7647267125E-01],
	[3.8230000000E+04, 3.4212973891E+01, 4.6458109162E+00, 2.1561520397E+01, 3.4381360627E+00, 9.7648481554E-01],
	[3.8235000000E+04, 3.4220787743E+01, 4.6458400450E+00, 2.1570822645E+01, 3.4384673612E+00, 9.7649695301E-01],
	[3.8240000000E+04, 3.4228602356E+01, 4.6458691702E+00, 2.1580127688E+01, 3.4387985601E+00, 9.7650908366E-01],
	[3.8245000000E+04, 3.4236417733E+01, 4.6458982918E+00, 2.1589435528E+01, 3.4391296595E+00, 9.7652120750E-01],
	[3.8250000000E+04, 3.4244233871E+01, 4.6459274097E+00, 2.1598746165E+01, 3.4394606594E+00, 9.7653332453E-01],
	[3.8255000000E+04, 3.4252050772E+01, 4.6459565241E+00, 2.1608059599E+01, 3.4397915598E+00, 9.7654543475E-01],
	[3.8260000000E+04, 3.4259868436E+01, 4.6459856348E+00, 2.1617375830E+01, 3.4401223607E+00, 9.7655753816E-01],
	[3.8265000000E+04, 3.4267686862E+01, 4.6460147418E+00, 2.1626694860E+01, 3.4404530622E+00, 9.7656963478E-01],
	[3.8270000000E+04, 3.4275506050E+01, 4.6460438453E+00, 2.1636016688E+01, 3.4407836643E+00, 9.7658172460E-01],
	[3.8275000000E+04, 3.4283326000E+01, 4.6460729451E+00, 2.1645341316E+01, 3.4411141670E+00, 9.7659380763E-01],
	[3.8280000000E+04, 3.4291146713E+01, 4.6461020414E+00, 2.1654668743E+01, 3.4414445705E+00, 9.7660588388E-01],
	[3.8285000000E+04, 3.4298968188E+01, 4.6461311340E+00, 2.1663998970E+01, 3.4417748746E+00, 9.7661795333E-01],
	[3.8290000000E+04, 3.4306790425E+01, 4.6461602229E+00, 2.1673331998E+01, 3.4421050794E+00, 9.7663001601E-01],
	[3.8295000000E+04, 3.4314613425E+01, 4.6461893083E+00, 2.1682667827E+01, 3.4424351850E+00, 9.7664207191E-01],
	[3.8300000000E+04, 3.4322437187E+01, 4.6462183901E+00, 2.1692006458E+01, 3.4427651914E+00, 9.7665412104E-01],
	[3.8305000000E+04, 3.4330261710E+01, 4.6462474682E+00, 2.1701347890E+01, 3.4430950986E+00, 9.7666616340E-01],
	[3.8310000000E+04, 3.4338086996E+01, 4.6462765427E+00, 2.1710692125E+01, 3.4434249067E+00, 9.7667819900E-01],
	[3.8315000000E+04, 3.4345913044E+01, 4.6463056136E+00, 2.1720039163E+01, 3.4437546156E+00, 9.7669022783E-01],
	[3.8320000000E+04, 3.4353739855E+01, 4.6463346809E+00, 2.1729389005E+01, 3.4440842254E+00, 9.7670224991E-01],
	[3.8325000000E+04, 3.4361567427E+01, 4.6463637446E+00, 2.1738741650E+01, 3.4444137362E+00, 9.7671426523E-01],
	[3.8330000000E+04, 3.4369395761E+01, 4.6463928047E+00, 2.1748097100E+01, 3.4447431480E+00, 9.7672627380E-01],
	[3.8335000000E+04, 3.4377224857E+01, 4.6464218612E+00, 2.1757455354E+01, 3.4450724607E+00, 9.7673827562E-01],
	[3.8340000000E+04, 3.4385054716E+01, 4.6464509140E+00, 2.1766816414E+01, 3.4454016745E+00, 9.7675027071E-01],
	[3.8345000000E+04, 3.4392885336E+01, 4.6464799633E+00, 2.1776180280E+01, 3.4457307894E+00, 9.7676225905E-01],
	[3.8350000000E+04, 3.4400716718E+01, 4.6465090090E+00, 2.1785546952E+01, 3.4460598053E+00, 9.7677424066E-01],
	[3.8355000000E+04, 3.4408548862E+01, 4.6465380510E+00, 2.1794916431E+01, 3.4463887224E+00, 9.7678621553E-01],
	[3.8360000000E+04, 3.4416381768E+01, 4.6465670894E+00, 2.1804288716E+01, 3.4467175406E+00, 9.7679818368E-01],
	[3.8365000000E+04, 3.4424215436E+01, 4.6465961243E+00, 2.1813663810E+01, 3.4470462600E+00, 9.7681014511E-01],
	[3.8370000000E+04, 3.4432049866E+01, 4.6466251555E+00, 2.1823041712E+01, 3.4473748806E+00, 9.7682209982E-01],
	[3.8375000000E+04, 3.4439885057E+01, 4.6466541832E+00, 2.1832422422E+01, 3.4477034025E+00, 9.7683404780E-01],
	[3.8380000000E+04, 3.4447721010E+01, 4.6466832072E+00, 2.1841805942E+01, 3.4480318256E+00, 9.7684598908E-01],
	[3.8385000000E+04, 3.4455557725E+01, 4.6467122276E+00, 2.1851192271E+01, 3.4483601501E+00, 9.7685792365E-01],
	[3.8390000000E+04, 3.4463395202E+01, 4.6467412445E+00, 2.1860581411E+01, 3.4486883759E+00, 9.7686985151E-01],
	[3.8395000000E+04, 3.4471233441E+01, 4.6467702577E+00, 2.1869973360E+01, 3.4490165030E+00, 9.7688177267E-01],
	[3.8400000000E+04, 3.4479072441E+01, 4.6467992673E+00, 2.1879368121E+01, 3.4493445316E+00, 9.7689368714E-01],
	[3.8405000000E+04, 3.4486912203E+01, 4.6468282734E+00, 2.1888765694E+01, 3.4496724616E+00, 9.7690559491E-01],
	[3.8410000000E+04, 3.4494752726E+01, 4.6468572758E+00, 2.1898166078E+01, 3.4500002930E+00, 9.7691749599E-01],
	[3.8415000000E+04, 3.4502594011E+01, 4.6468862747E+00, 2.1907569275E+01, 3.4503280259E+00, 9.7692939039E-01],
	[3.8420000000E+04, 3.4510436058E+01, 4.6469152700E+00, 2.1916975285E+01, 3.4506556604E+00, 9.7694127810E-01],
	[3.8425000000E+04, 3.4518278866E+01, 4.6469442616E+00, 2.1926384108E+01, 3.4509831964E+00, 9.7695315913E-01],
	[3.8430000000E+04, 3.4526122436E+01, 4.6469732497E+00, 2.1935795745E+01, 3.4513106340E+00, 9.7696503349E-01],
	[3.8435000000E+04, 3.4533966767E+01, 4.6470022342E+00, 2.1945210196E+01, 3.4516379731E+00, 9.7697690118E-01],
	[3.8440000000E+04, 3.4541811860E+01, 4.6470312151E+00, 2.1954627463E+01, 3.4519652140E+00, 9.7698876220E-01],
	[3.8445000000E+04, 3.4549657714E+01, 4.6470601924E+00, 2.1964047544E+01, 3.4522923565E+00, 9.7700061656E-01],
	[3.8450000000E+04, 3.4557504329E+01, 4.6470891661E+00, 2.1973470441E+01, 3.4526194007E+00, 9.7701246426E-01],
	[3.8455000000E+04, 3.4565351706E+01, 4.6471181363E+00, 2.1982896155E+01, 3.4529463466E+00, 9.7702430530E-01],
	[3.8460000000E+04, 3.4573199845E+01, 4.6471471028E+00, 2.1992324685E+01, 3.4532731943E+00, 9.7703613969E-01],
	[3.8465000000E+04, 3.4581048744E+01, 4.6471760658E+00, 2.2001756033E+01, 3.4535999438E+00, 9.7704796743E-01],
	[3.8470000000E+04, 3.4588898406E+01, 4.6472050252E+00, 2.2011190198E+01, 3.4539265951E+00, 9.7705978852E-01],
	[3.8475000000E+04, 3.4596748828E+01, 4.6472339809E+00, 2.2020627181E+01, 3.4542531482E+00, 9.7707160298E-01],
	[3.8480000000E+04, 3.4604600012E+01, 4.6472629332E+00, 2.2030066983E+01, 3.4545796033E+00, 9.7708341080E-01],
	[3.8485000000E+04, 3.4612451957E+01, 4.6472918818E+00, 2.2039509604E+01, 3.4549059603E+00, 9.7709521198E-01],
	[3.8490000000E+04, 3.4620304663E+01, 4.6473208269E+00, 2.2048955045E+01, 3.4552322192E+00, 9.7710700654E-01],
	[3.8495000000E+04, 3.4628158130E+01, 4.6473497683E+00, 2.2058403306E+01, 3.4555583800E+00, 9.7711879447E-01],
	[3.8500000000E+04, 3.4636012359E+01, 4.6473787062E+00, 2.2067854387E+01, 3.4558844429E+00, 9.7713057578E-01],
	[3.8505000000E+04, 3.4643867348E+01, 4.6474076405E+00, 2.2077308290E+01, 3.4562104078E+00, 9.7714235046E-01],
	[3.8510000000E+04, 3.4651723099E+01, 4.6474365713E+00, 2.2086765013E+01, 3.4565362748E+00, 9.7715411854E-01],
	[3.8515000000E+04, 3.4659579611E+01, 4.6474654984E+00, 2.2096224559E+01, 3.4568620439E+00, 9.7716588000E-01],
	[3.8520000000E+04, 3.4667436884E+01, 4.6474944220E+00, 2.2105686927E+01, 3.4571877151E+00, 9.7717763486E-01],
	[3.8525000000E+04, 3.4675294918E+01, 4.6475233420E+00, 2.2115152118E+01, 3.4575132885E+00, 9.7718938311E-01],
	[3.8530000000E+04, 3.4683153713E+01, 4.6475522585E+00, 2.2124620133E+01, 3.4578387641E+00, 9.7720112477E-01],
	[3.8535000000E+04, 3.4691013269E+01, 4.6475811714E+00, 2.2134090971E+01, 3.4581641418E+00, 9.7721285982E-01],
	[3.8540000000E+04, 3.4698873586E+01, 4.6476100807E+00, 2.2143564634E+01, 3.4584894218E+00, 9.7722458829E-01],
	[3.8545000000E+04, 3.4706734665E+01, 4.6476389864E+00, 2.2153041121E+01, 3.4588146041E+00, 9.7723631017E-01],
	[3.8550000000E+04, 3.4714596503E+01, 4.6476678885E+00, 2.2162520434E+01, 3.4591396887E+00, 9.7724802546E-01],
	[3.8555000000E+04, 3.4722459103E+01, 4.6476967871E+00, 2.2172002573E+01, 3.4594646757E+00, 9.7725973417E-01],
	[3.8560000000E+04, 3.4730322464E+01, 4.6477256822E+00, 2.2181487537E+01, 3.4597895650E+00, 9.7727143631E-01],
	[3.8565000000E+04, 3.4738186586E+01, 4.6477545736E+00, 2.2190975329E+01, 3.4601143567E+00, 9.7728313187E-01],
	[3.8570000000E+04, 3.4746051468E+01, 4.6477834615E+00, 2.2200465948E+01, 3.4604390509E+00, 9.7729482086E-01],
	[3.8575000000E+04, 3.4753917111E+01, 4.6478123458E+00, 2.2209959394E+01, 3.4607636475E+00, 9.7730650329E-01],
	[3.8580000000E+04, 3.4761783515E+01, 4.6478412266E+00, 2.2219455669E+01, 3.4610881466E+00, 9.7731817915E-01],
	[3.8585000000E+04, 3.4769650680E+01, 4.6478701038E+00, 2.2228954772E+01, 3.4614125482E+00, 9.7732984846E-01],
	[3.8590000000E+04, 3.4777518606E+01, 4.6478989774E+00, 2.2238456704E+01, 3.4617368523E+00, 9.7734151121E-01],
	[3.8595000000E+04, 3.4785387292E+01, 4.6479278475E+00, 2.2247961466E+01, 3.4620610591E+00, 9.7735316741E-01],
	[3.8600000000E+04, 3.4793256739E+01, 4.6479567140E+00, 2.2257469058E+01, 3.4623851684E+00, 9.7736481707E-01],
	[3.8605000000E+04, 3.4801126946E+01, 4.6479855769E+00, 2.2266979480E+01, 3.4627091804E+00, 9.7737646018E-01],
	[3.8610000000E+04, 3.4808997915E+01, 4.6480144363E+00, 2.2276492733E+01, 3.4630330951E+00, 9.7738809675E-01],
	[3.8615000000E+04, 3.4816869643E+01, 4.6480432922E+00, 2.2286008818E+01, 3.4633569125E+00, 9.7739972679E-01],
	[3.8620000000E+04, 3.4824759898E+01, 4.6480741130E+00, 2.2295527735E+01, 3.4636819015E+00, 9.7741135029E-01],
	[3.8625000000E+04, 3.4832651212E+01, 4.6481049626E+00, 2.2305049484E+01, 3.4640068144E+00, 9.7742296727E-01],
	[3.8630000000E+04, 3.4840543293E+01, 4.6481358084E+00, 2.2314574066E+01, 3.4643316303E+00, 9.7743457772E-01],
	[3.8635000000E+04, 3.4848436139E+01, 4.6481666503E+00, 2.2324101482E+01, 3.4646563493E+00, 9.7744618165E-01],
	[3.8640000000E+04, 3.4856329753E+01, 4.6481974885E+00, 2.2333631731E+01, 3.4649809714E+00, 9.7745777906E-01],
	[3.8645000000E+04, 3.4864224132E+01, 4.6482283230E+00, 2.2343164815E+01, 3.4653054965E+00, 9.7746936996E-01],
	[3.8650000000E+04, 3.4872119278E+01, 4.6482591536E+00, 2.2352700733E+01, 3.4656299248E+00, 9.7748095435E-01],
	[3.8655000000E+04, 3.4880015190E+01, 4.6482899804E+00, 2.2362239487E+01, 3.4659542563E+00, 9.7749253224E-01],
	[3.8660000000E+04, 3.4887911868E+01, 4.6483208035E+00, 2.2371781077E+01, 3.4662784909E+00, 9.7750410362E-01],
	[3.8665000000E+04, 3.4895809312E+01, 4.6483516228E+00, 2.2381325502E+01, 3.4666026288E+00, 9.7751566851E-01],
	[3.8670000000E+04, 3.4903707523E+01, 4.6483824383E+00, 2.2390872765E+01, 3.4669266700E+00, 9.7752722690E-01],
	[3.8675000000E+04, 3.4911606499E+01, 4.6484132500E+00, 2.2400422865E+01, 3.4672506144E+00, 9.7753877880E-01],
	[3.8680000000E+04, 3.4919506242E+01, 4.6484440580E+00, 2.2409975802E+01, 3.4675744621E+00, 9.7755032421E-01],
	[3.8685000000E+04, 3.4927406751E+01, 4.6484748621E+00, 2.2419531577E+01, 3.4678982132E+00, 9.7756186314E-01],
	[3.8690000000E+04, 3.4935308026E+01, 4.6485056625E+00, 2.2429090191E+01, 3.4682218676E+00, 9.7757339559E-01],
	[3.8695000000E+04, 3.4943210067E+01, 4.6485364591E+00, 2.2438651645E+01, 3.4685454255E+00, 9.7758492157E-01],
	[3.8700000000E+04, 3.4951112874E+01, 4.6485672520E+00, 2.2448215937E+01, 3.4688688867E+00, 9.7759644107E-01],
	[3.8705000000E+04, 3.4959016447E+01, 4.6485980410E+00, 2.2457783070E+01, 3.4691922515E+00, 9.7760795410E-01],
	[3.8710000000E+04, 3.4966920786E+01, 4.6486288263E+00, 2.2467353043E+01, 3.4695155197E+00, 9.7761946067E-01],
	[3.8715000000E+04, 3.4974825891E+01, 4.6486596078E+00, 2.2476925858E+01, 3.4698386915E+00, 9.7763096078E-01],
	[3.8720000000E+04, 3.4982731762E+01, 4.6486903856E+00, 2.2486501513E+01, 3.4701617668E+00, 9.7764245443E-01],
	[3.8725000000E+04, 3.4990638399E+01, 4.6487211595E+00, 2.2496080011E+01, 3.4704847457E+00, 9.7765394163E-01],
	[3.8730000000E+04, 3.4998545801E+01, 4.6487519297E+00, 2.2505661351E+01, 3.4708076282E+00, 9.7766542238E-01],
	[3.8735000000E+04, 3.5006453970E+01, 4.6487826962E+00, 2.2515245534E+01, 3.4711304144E+00, 9.7767689668E-01],
	[3.8740000000E+04, 3.5014362904E+01, 4.6488134588E+00, 2.2524832561E+01, 3.4714531042E+00, 9.7768836454E-01],
	[3.8745000000E+04, 3.5022272604E+01, 4.6488442178E+00, 2.2534422431E+01, 3.4717756978E+00, 9.7769982597E-01],
	[3.8750000000E+04, 3.5030183070E+01, 4.6488749729E+00, 2.2544015146E+01, 3.4720981950E+00, 9.7771128096E-01],
	[3.8755000000E+04, 3.5038094302E+01, 4.6489057243E+00, 2.2553610705E+01, 3.4724205961E+00, 9.7772272951E-01],
	[3.8760000000E+04, 3.5046006299E+01, 4.6489364719E+00, 2.2563209110E+01, 3.4727429009E+00, 9.7773417164E-01],
	[3.8765000000E+04, 3.5053919062E+01, 4.6489672157E+00, 2.2572810360E+01, 3.4730651095E+00, 9.7774560735E-01],
	[3.8770000000E+04, 3.5061832591E+01, 4.6489979558E+00, 2.2582414457E+01, 3.4733872220E+00, 9.7775703664E-01],
	[3.8775000000E+04, 3.5069746885E+01, 4.6490286921E+00, 2.2592021400E+01, 3.4737092384E+00, 9.7776845951E-01],
	[3.8780000000E+04, 3.5077661945E+01, 4.6490594247E+00, 2.2601631191E+01, 3.4740311587E+00, 9.7777987597E-01],
	[3.8785000000E+04, 3.5085577771E+01, 4.6490901535E+00, 2.2611243829E+01, 3.4743529830E+00, 9.7779128602E-01],
	[3.8790000000E+04, 3.5093494362E+01, 4.6491208785E+00, 2.2620859315E+01, 3.4746747112E+00, 9.7780268966E-01],
	[3.8795000000E+04, 3.5101411719E+01, 4.6491515998E+00, 2.2630477650E+01, 3.4749963434E+00, 9.7781408691E-01],
	[3.8800000000E+04, 3.5109329841E+01, 4.6491823174E+00, 2.2640098834E+01, 3.4753178797E+00, 9.7782547775E-01],
	[3.8805000000E+04, 3.5117248729E+01, 4.6492130311E+00, 2.2649722868E+01, 3.4756393200E+00, 9.7783686221E-01],
	[3.8810000000E+04, 3.5125168382E+01, 4.6492437412E+00, 2.2659349752E+01, 3.4759606644E+00, 9.7784824027E-01],
	[3.8815000000E+04, 3.5133088800E+01, 4.6492744474E+00, 2.2668979486E+01, 3.4762819129E+00, 9.7785961195E-01],
	[3.8820000000E+04, 3.5141009985E+01, 4.6493051499E+00, 2.2678612071E+01, 3.4766030656E+00, 9.7787097724E-01],
	[3.8825000000E+04, 3.5148931934E+01, 4.6493358487E+00, 2.2688247508E+01, 3.4769241224E+00, 9.7788233616E-01],
	[3.8830000000E+04, 3.5156854649E+01, 4.6493665437E+00, 2.2697885796E+01, 3.4772450835E+00, 9.7789368870E-01],
	[3.8835000000E+04, 3.5164778129E+01, 4.6493972350E+00, 2.2707526938E+01, 3.4775659488E+00, 9.7790503487E-01],
	[3.8840000000E+04, 3.5172702375E+01, 4.6494279225E+00, 2.2717170932E+01, 3.4778867184E+00, 9.7791637467E-01],
	[3.8845000000E+04, 3.5180627386E+01, 4.6494586063E+00, 2.2726817779E+01, 3.4782073923E+00, 9.7792770811E-01],
	[3.8850000000E+04, 3.5188553162E+01, 4.6494892863E+00, 2.2736467480E+01, 3.4785279705E+00, 9.7793903519E-01],
	[3.8855000000E+04, 3.5196479703E+01, 4.6495199626E+00, 2.2746120036E+01, 3.4788484531E+00, 9.7795035591E-01],
	[3.8860000000E+04, 3.5204407010E+01, 4.6495506351E+00, 2.2755775446E+01, 3.4791688401E+00, 9.7796167028E-01],
	[3.8865000000E+04, 3.5212335082E+01, 4.6495813039E+00, 2.2765433712E+01, 3.4794891315E+00, 9.7797297831E-01],
	[3.8870000000E+04, 3.5220263919E+01, 4.6496119689E+00, 2.2775094833E+01, 3.4798093273E+00, 9.7798427998E-01],
	[3.8875000000E+04, 3.5228193521E+01, 4.6496426302E+00, 2.2784758811E+01, 3.4801294277E+00, 9.7799557532E-01],
	[3.8880000000E+04, 3.5236123888E+01, 4.6496732878E+00, 2.2794425645E+01, 3.4804494325E+00, 9.7800686431E-01],
	[3.8885000000E+04, 3.5244055021E+01, 4.6497039416E+00, 2.2804095337E+01, 3.4807693419E+00, 9.7801814698E-01],
	[3.8890000000E+04, 3.5251986918E+01, 4.6497345917E+00, 2.2813767886E+01, 3.4810891558E+00, 9.7802942331E-01],
	[3.8895000000E+04, 3.5259919581E+01, 4.6497652380E+00, 2.2823443293E+01, 3.4814088744E+00, 9.7804069331E-01],
	[3.8900000000E+04, 3.5267853008E+01, 4.6497958806E+00, 2.2833121559E+01, 3.4817284976E+00, 9.7805195700E-01],
	[3.8905000000E+04, 3.5275787201E+01, 4.6498265195E+00, 2.2842802685E+01, 3.4820480254E+00, 9.7806321436E-01],
	[3.8910000000E+04, 3.5283722158E+01, 4.6498571546E+00, 2.2852486669E+01, 3.4823674580E+00, 9.7807446541E-01],
	[3.8915000000E+04, 3.5291657881E+01, 4.6498877860E+00, 2.2862173514E+01, 3.4826867952E+00, 9.7808571015E-01],
	[3.8920000000E+04, 3.5299594368E+01, 4.6499184137E+00, 2.2871863219E+01, 3.4830060372E+00, 9.7809694858E-01],
	[3.8925000000E+04, 3.5307531621E+01, 4.6499490376E+00, 2.2881555786E+01, 3.4833251840E+00, 9.7810818070E-01],
	[3.8930000000E+04, 3.5315469638E+01, 4.6499796578E+00, 2.2891251213E+01, 3.4836442356E+00, 9.7811940652E-01],
	[3.8935000000E+04, 3.5323408420E+01, 4.6500102743E+00, 2.2900949503E+01, 3.4839631920E+00, 9.7813062605E-01],
	[3.8940000000E+04, 3.5331347967E+01, 4.6500408870E+00, 2.2910650655E+01, 3.4842820533E+00, 9.7814183929E-01],
	[3.8945000000E+04, 3.5339288279E+01, 4.6500714961E+00, 2.2920354671E+01, 3.4846008195E+00, 9.7815304623E-01],
	[3.8950000000E+04, 3.5347229356E+01, 4.6501021013E+00, 2.2930061549E+01, 3.4849194906E+00, 9.7816424689E-01],
	[3.8955000000E+04, 3.5355171197E+01, 4.6501327029E+00, 2.2939771292E+01, 3.4852380667E+00, 9.7817544126E-01],
	[3.8960000000E+04, 3.5363113803E+01, 4.6501633007E+00, 2.2949483898E+01, 3.4855565478E+00, 9.7818662936E-01],
	[3.8965000000E+04, 3.5371057174E+01, 4.6501938948E+00, 2.2959199370E+01, 3.4858749338E+00, 9.7819781119E-01],
	[3.8970000000E+04, 3.5379001309E+01, 4.6502244852E+00, 2.2968917707E+01, 3.4861932250E+00, 9.7820898674E-01],
	[3.8975000000E+04, 3.5386946210E+01, 4.6502550719E+00, 2.2978638909E+01, 3.4865114212E+00, 9.7822015602E-01],
	[3.8980000000E+04, 3.5394891874E+01, 4.6502856548E+00, 2.2988362978E+01, 3.4868295225E+00, 9.7823131905E-01],
	[3.8985000000E+04, 3.5402838304E+01, 4.6503162340E+00, 2.2998089914E+01, 3.4871475289E+00, 9.7824247581E-01],
	[3.8990000000E+04, 3.5410785498E+01, 4.6503468095E+00, 2.3007819717E+01, 3.4874654406E+00, 9.7825362631E-01],
	[3.8995000000E+04, 3.5418733456E+01, 4.6503773813E+00, 2.3017552387E+01, 3.4877832574E+00, 9.7826477057E-01],
	[3.9000000000E+04, 3.5426682180E+01, 4.6504079493E+00, 2.3027287926E+01, 3.4881009794E+00, 9.7827590857E-01],
	[3.9005000000E+04, 3.5434631667E+01, 4.6504385137E+00, 2.3037026334E+01, 3.4884186067E+00, 9.7828704033E-01],
	[3.9010000000E+04, 3.5442581919E+01, 4.6504690743E+00, 2.3046767610E+01, 3.4887361393E+00, 9.7829816585E-01],
	[3.9015000000E+04, 3.5450532936E+01, 4.6504996312E+00, 2.3056511756E+01, 3.4890535772E+00, 9.7830928513E-01],
	[3.9020000000E+04, 3.5458484717E+01, 4.6505301844E+00, 2.3066258772E+01, 3.4893709204E+00, 9.7832039818E-01],
	[3.9025000000E+04, 3.5466437262E+01, 4.6505607338E+00, 2.3076008659E+01, 3.4896881690E+00, 9.7833150499E-01],
	[3.9030000000E+04, 3.5474390572E+01, 4.6505912796E+00, 2.3085761417E+01, 3.4900053231E+00, 9.7834260558E-01],
	[3.9035000000E+04, 3.5482344647E+01, 4.6506218217E+00, 2.3095517046E+01, 3.4903223825E+00, 9.7835369995E-01],
	[3.9040000000E+04, 3.5490299485E+01, 4.6506523600E+00, 2.3105275547E+01, 3.4906393474E+00, 9.7836478810E-01],
	[3.9045000000E+04, 3.5498255088E+01, 4.6506828946E+00, 2.3115036921E+01, 3.4909562178E+00, 9.7837587003E-01],
	[3.9050000000E+04, 3.5506211455E+01, 4.6507134255E+00, 2.3124801168E+01, 3.4912729938E+00, 9.7838694575E-01],
	[3.9055000000E+04, 3.5514168587E+01, 4.6507439527E+00, 2.3134568288E+01, 3.4915896752E+00, 9.7839801526E-01],
	[3.9060000000E+04, 3.5522126483E+01, 4.6507744762E+00, 2.3144338282E+01, 3.4919062623E+00, 9.7840907857E-01],
	[3.9065000000E+04, 3.5530085143E+01, 4.6508049960E+00, 2.3154111150E+01, 3.4922227550E+00, 9.7842013568E-01],
	[3.9070000000E+04, 3.5538044567E+01, 4.6508355121E+00, 2.3163886893E+01, 3.4925391533E+00, 9.7843118659E-01],
	[3.9075000000E+04, 3.5546004755E+01, 4.6508660245E+00, 2.3173665512E+01, 3.4928554573E+00, 9.7844223131E-01],
	[3.9080000000E+04, 3.5553965708E+01, 4.6508965332E+00, 2.3183447006E+01, 3.4931716670E+00, 9.7845326983E-01],
	[3.9085000000E+04, 3.5561927424E+01, 4.6509270382E+00, 2.3193231377E+01, 3.4934877824E+00, 9.7846430217E-01],
	[3.9090000000E+04, 3.5569889905E+01, 4.6509575394E+00, 2.3203018624E+01, 3.4938038036E+00, 9.7847532833E-01],
	[3.9095000000E+04, 3.5577853150E+01, 4.6509880370E+00, 2.3212808749E+01, 3.4941197306E+00, 9.7848634831E-01],
	[3.9100000000E+04, 3.5585817159E+01, 4.6510185309E+00, 2.3222601751E+01, 3.4944355633E+00, 9.7849736212E-01],
	[3.9105000000E+04, 3.5593781931E+01, 4.6510490210E+00, 2.3232397632E+01, 3.4947513020E+00, 9.7850836975E-01],
	[3.9110000000E+04, 3.5601747468E+01, 4.6510795075E+00, 2.3242196391E+01, 3.4950669465E+00, 9.7851937122E-01],
	[3.9115000000E+04, 3.5609713769E+01, 4.6511099903E+00, 2.3251998029E+01, 3.4953824969E+00, 9.7853036652E-01],
	[3.9120000000E+04, 3.5617680834E+01, 4.6511404694E+00, 2.3261802547E+01, 3.4956979533E+00, 9.7854135566E-01],
	[3.9125000000E+04, 3.5625648663E+01, 4.6511709448E+00, 2.3271609946E+01, 3.4960133156E+00, 9.7855233865E-01],
	[3.9130000000E+04, 3.5633617256E+01, 4.6512014165E+00, 2.3281420224E+01, 3.4963285839E+00, 9.7856331548E-01],
	[3.9135000000E+04, 3.5641586612E+01, 4.6512318845E+00, 2.3291233384E+01, 3.4966437583E+00, 9.7857428616E-01],
	[3.9140000000E+04, 3.5649556733E+01, 4.6512623488E+00, 2.3301049425E+01, 3.4969588387E+00, 9.7858525070E-01],
	[3.9145000000E+04, 3.5657527617E+01, 4.6512928094E+00, 2.3310868349E+01, 3.4972738252E+00, 9.7859620910E-01],
	[3.9150000000E+04, 3.5665499265E+01, 4.6513232663E+00, 2.3320690154E+01, 3.4975887178E+00, 9.7860716136E-01],
	[3.9155000000E+04, 3.5673471677E+01, 4.6513537195E+00, 2.3330514843E+01, 3.4979035166E+00, 9.7861810748E-01],
	[3.9160000000E+04, 3.5681444852E+01, 4.6513841691E+00, 2.3340342415E+01, 3.4982182215E+00, 9.7862904747E-01],
	[3.9165000000E+04, 3.5689418792E+01, 4.6514146149E+00, 2.3350172871E+01, 3.4985328326E+00, 9.7863998134E-01],
	[3.9170000000E+04, 3.5697393495E+01, 4.6514450571E+00, 2.3360006212E+01, 3.4988473500E+00, 9.7865090908E-01],
	[3.9175000000E+04, 3.5705368961E+01, 4.6514754956E+00, 2.3369842437E+01, 3.4991617736E+00, 9.7866183070E-01],
	[3.9180000000E+04, 3.5713345192E+01, 4.6515059304E+00, 2.3379681548E+01, 3.4994761036E+00, 9.7867274620E-01],
	[3.9185000000E+04, 3.5721322186E+01, 4.6515363615E+00, 2.3389523545E+01, 3.4997903398E+00, 9.7868365560E-01],
	[3.9190000000E+04, 3.5729299944E+01, 4.6515667889E+00, 2.3399368428E+01, 3.5001044824E+00, 9.7869455888E-01],
	[3.9195000000E+04, 3.5737278465E+01, 4.6515972126E+00, 2.3409216197E+01, 3.5004185314E+00, 9.7870545606E-01],
	[3.9200000000E+04, 3.5745257750E+01, 4.6516276327E+00, 2.3419066854E+01, 3.5007324868E+00, 9.7871634714E-01],
	[3.9205000000E+04, 3.5753237798E+01, 4.6516580491E+00, 2.3428920399E+01, 3.5010463486E+00, 9.7872723212E-01],
	[3.9210000000E+04, 3.5761218610E+01, 4.6516884618E+00, 2.3438776832E+01, 3.5013601169E+00, 9.7873811100E-01],
	[3.9215000000E+04, 3.5769200185E+01, 4.6517188708E+00, 2.3448636154E+01, 3.5016737917E+00, 9.7874898380E-01],
	[3.9220000000E+04, 3.5777182524E+01, 4.6517492761E+00, 2.3458498365E+01, 3.5019873731E+00, 9.7875985050E-01],
	[3.9225000000E+04, 3.5785165627E+01, 4.6517796778E+00, 2.3468363465E+01, 3.5023008609E+00, 9.7877071113E-01],
	[3.9230000000E+04, 3.5793149492E+01, 4.6518100758E+00, 2.3478231456E+01, 3.5026142554E+00, 9.7878156567E-01],
	[3.9235000000E+04, 3.5801134121E+01, 4.6518404701E+00, 2.3488102337E+01, 3.5029275565E+00, 9.7879241414E-01],
	[3.9240000000E+04, 3.5809131231E+01, 4.6518721387E+00, 2.3497976110E+01, 3.5032416012E+00, 9.7880325654E-01],
	[3.9245000000E+04, 3.5817135316E+01, 4.6519044803E+00, 2.3507852774E+01, 3.5035559960E+00, 9.7881409287E-01],
	[3.9250000000E+04, 3.5825140170E+01, 4.6519368181E+00, 2.3517732330E+01, 3.5038702977E+00, 9.7882492313E-01],
	[3.9255000000E+04, 3.5833145793E+01, 4.6519691519E+00, 2.3527614778E+01, 3.5041845064E+00, 9.7883574733E-01],
	[3.9260000000E+04, 3.5841152185E+01, 4.6520014819E+00, 2.3537500120E+01, 3.5044986220E+00, 9.7884656547E-01],
	[3.9265000000E+04, 3.5849159346E+01, 4.6520338080E+00, 2.3547388355E+01, 3.5048126446E+00, 9.7885737756E-01],
	[3.9270000000E+04, 3.5857167276E+01, 4.6520661302E+00, 2.3557279484E+01, 3.5051265743E+00, 9.7886818360E-01],
	[3.9275000000E+04, 3.5865175975E+01, 4.6520984485E+00, 2.3567173507E+01, 3.5054404110E+00, 9.7887898359E-01],
	[3.9280000000E+04, 3.5873185443E+01, 4.6521307629E+00, 2.3577070426E+01, 3.5057541548E+00, 9.7888977754E-01],
	[3.9285000000E+04, 3.5881195679E+01, 4.6521630734E+00, 2.3586970239E+01, 3.5060678057E+00, 9.7890056545E-01],
	[3.9290000000E+04, 3.5889206685E+01, 4.6521953800E+00, 2.3596872949E+01, 3.5063813638E+00, 9.7891134733E-01],
	[3.9295000000E+04, 3.5897218459E+01, 4.6522276827E+00, 2.3606778555E+01, 3.5066948290E+00, 9.7892212317E-01],
	[3.9300000000E+04, 3.5905231002E+01, 4.6522599816E+00, 2.3616687058E+01, 3.5070082014E+00, 9.7893289298E-01],
	[3.9305000000E+04, 3.5913244314E+01, 4.6522922766E+00, 2.3626598458E+01, 3.5073214811E+00, 9.7894365677E-01],
	[3.9310000000E+04, 3.5921258394E+01, 4.6523245677E+00, 2.3636512756E+01, 3.5076346680E+00, 9.7895441454E-01],
	[3.9315000000E+04, 3.5929273244E+01, 4.6523568549E+00, 2.3646429952E+01, 3.5079477623E+00, 9.7896516628E-01],
	[3.9320000000E+04, 3.5937288862E+01, 4.6523891382E+00, 2.3656350047E+01, 3.5082607638E+00, 9.7897591202E-01],
	[3.9325000000E+04, 3.5945305249E+01, 4.6524214176E+00, 2.3666273041E+01, 3.5085736727E+00, 9.7898665174E-01],
	[3.9330000000E+04, 3.5953322404E+01, 4.6524536932E+00, 2.3676198935E+01, 3.5088864890E+00, 9.7899738546E-01],
	[3.9335000000E+04, 3.5961340328E+01, 4.6524859649E+00, 2.3686127729E+01, 3.5091992126E+00, 9.7900811318E-01],
	[3.9340000000E+04, 3.5969359021E+01, 4.6525182327E+00, 2.3696059424E+01, 3.5095118438E+00, 9.7901883489E-01],
	[3.9345000000E+04, 3.5977378482E+01, 4.6525504966E+00, 2.3705994020E+01, 3.5098243823E+00, 9.7902955061E-01],
	[3.9350000000E+04, 3.5985398712E+01, 4.6525827567E+00, 2.3715931517E+01, 3.5101368284E+00, 9.7904026034E-01],
	[3.9355000000E+04, 3.5993419710E+01, 4.6526150128E+00, 2.3725871917E+01, 3.5104491820E+00, 9.7905096408E-01],
	[3.9360000000E+04, 3.6001441477E+01, 4.6526472651E+00, 2.3735815219E+01, 3.5107614432E+00, 9.7906166183E-01],
	[3.9365000000E+04, 3.6009464012E+01, 4.6526795136E+00, 2.3745761424E+01, 3.5110736119E+00, 9.7907235360E-01],
	[3.9370000000E+04, 3.6017487316E+01, 4.6527117581E+00, 2.3755710533E+01, 3.5113856883E+00, 9.7908303940E-01],
	[3.9375000000E+04, 3.6025511388E+01, 4.6527439988E+00, 2.3765662546E+01, 3.5116976722E+00, 9.7909371922E-01],
	[3.9380000000E+04, 3.6033536229E+01, 4.6527762356E+00, 2.3775617463E+01, 3.5120095639E+00, 9.7910439307E-01],
	[3.9385000000E+04, 3.6041561838E+01, 4.6528084686E+00, 2.3785575286E+01, 3.5123213633E+00, 9.7911506095E-01],
	[3.9390000000E+04, 3.6049588215E+01, 4.6528406976E+00, 2.3795536013E+01, 3.5126330704E+00, 9.7912572287E-01],
	[3.9395000000E+04, 3.6057615361E+01, 4.6528729229E+00, 2.3805499647E+01, 3.5129446852E+00, 9.7913637883E-01],
	[3.9400000000E+04, 3.6065643275E+01, 4.6529051442E+00, 2.3815466187E+01, 3.5132562079E+00, 9.7914702884E-01],
	[3.9405000000E+04, 3.6073671958E+01, 4.6529373617E+00, 2.3825435634E+01, 3.5135676383E+00, 9.7915767289E-01],
	[3.9410000000E+04, 3.6081701408E+01, 4.6529695753E+00, 2.3835407988E+01, 3.5138789766E+00, 9.7916831099E-01],
	[3.9415000000E+04, 3.6089731627E+01, 4.6530017850E+00, 2.3845383250E+01, 3.5141902228E+00, 9.7917894315E-01],
	[3.9420000000E+04, 3.6097762614E+01, 4.6530339909E+00, 2.3855361421E+01, 3.5145013769E+00, 9.7918956936E-01],
	[3.9425000000E+04, 3.6105794370E+01, 4.6530661929E+00, 2.3865342500E+01, 3.5148124389E+00, 9.7920018964E-01],
	[3.9430000000E+04, 3.6113826893E+01, 4.6530983911E+00, 2.3875326488E+01, 3.5151234088E+00, 9.7921080399E-01],
	[3.9435000000E+04, 3.6121860185E+01, 4.6531305854E+00, 2.3885313387E+01, 3.5154342868E+00, 9.7922141240E-01],
	[3.9440000000E+04, 3.6129894245E+01, 4.6531627758E+00, 2.3895303195E+01, 3.5157450728E+00, 9.7923201488E-01],
	[3.9445000000E+04, 3.6137929073E+01, 4.6531949624E+00, 2.3905295914E+01, 3.5160557668E+00, 9.7924261145E-01],
	[3.9450000000E+04, 3.6145964669E+01, 4.6532271452E+00, 2.3915291545E+01, 3.5163663689E+00, 9.7925320209E-01],
	[3.9455000000E+04, 3.6154001033E+01, 4.6532593240E+00, 2.3925290087E+01, 3.5166768792E+00, 9.7926378682E-01],
	[3.9460000000E+04, 3.6162038165E+01, 4.6532914991E+00, 2.3935291541E+01, 3.5169872975E+00, 9.7927436563E-01],
	[3.9465000000E+04, 3.6170076065E+01, 4.6533236702E+00, 2.3945295908E+01, 3.5172976241E+00, 9.7928493853E-01],
	[3.9470000000E+04, 3.6178114733E+01, 4.6533558375E+00, 2.3955303188E+01, 3.5176078588E+00, 9.7929550553E-01],
	[3.9475000000E+04, 3.6186154169E+01, 4.6533880010E+00, 2.3965313381E+01, 3.5179180017E+00, 9.7930606663E-01],
	[3.9480000000E+04, 3.6194194373E+01, 4.6534201606E+00, 2.3975326489E+01, 3.5182280529E+00, 9.7931662183E-01],
	[3.9485000000E+04, 3.6202235345E+01, 4.6534523163E+00, 2.3985342511E+01, 3.5185380124E+00, 9.7932717113E-01],
	[3.9490000000E+04, 3.6210277085E+01, 4.6534844682E+00, 2.3995361448E+01, 3.5188478802E+00, 9.7933771454E-01],
	[3.9495000000E+04, 3.6218319593E+01, 4.6535166163E+00, 2.4005383301E+01, 3.5191576563E+00, 9.7934825207E-01],
	[3.9500000000E+04, 3.6226362868E+01, 4.6535487605E+00, 2.4015408070E+01, 3.5194673408E+00, 9.7935878371E-01],
	[3.9505000000E+04, 3.6234406912E+01, 4.6535809009E+00, 2.4025435755E+01, 3.5197769337E+00, 9.7936930947E-01],
	[3.9510000000E+04, 3.6242451723E+01, 4.6536130374E+00, 2.4035466357E+01, 3.5200864351E+00, 9.7937982936E-01],
	[3.9515000000E+04, 3.6250497302E+01, 4.6536451701E+00, 2.4045499877E+01, 3.5203958448E+00, 9.7939034337E-01],
	[3.9520000000E+04, 3.6258543648E+01, 4.6536772989E+00, 2.4055536314E+01, 3.5207051631E+00, 9.7940085151E-01],
	[3.9525000000E+04, 3.6266590763E+01, 4.6537094239E+00, 2.4065575670E+01, 3.5210143899E+00, 9.7941135378E-01],
	[3.9530000000E+04, 3.6274638645E+01, 4.6537415450E+00, 2.4075617944E+01, 3.5213235252E+00, 9.7942185020E-01],
	[3.9535000000E+04, 3.6282687294E+01, 4.6537736623E+00, 2.4085663138E+01, 3.5216325692E+00, 9.7943234075E-01],
	[3.9540000000E+04, 3.6290736712E+01, 4.6538057758E+00, 2.4095711252E+01, 3.5219415217E+00, 9.7944282545E-01],
	[3.9545000000E+04, 3.6298786897E+01, 4.6538378854E+00, 2.4105762286E+01, 3.5222503828E+00, 9.7945330430E-01],
	[3.9550000000E+04, 3.6306837850E+01, 4.6538699912E+00, 2.4115816241E+01, 3.5225591526E+00, 9.7946377730E-01],
	[3.9555000000E+04, 3.6314889570E+01, 4.6539020932E+00, 2.4125873117E+01, 3.5228678311E+00, 9.7947424445E-01],
	[3.9560000000E+04, 3.6322942058E+01, 4.6539341913E+00, 2.4135932915E+01, 3.5231764183E+00, 9.7948470577E-01],
	[3.9565000000E+04, 3.6330995313E+01, 4.6539662855E+00, 2.4145995635E+01, 3.5234849142E+00, 9.7949516124E-01],
	[3.9570000000E+04, 3.6339049336E+01, 4.6539983760E+00, 2.4156061278E+01, 3.5237933190E+00, 9.7950561089E-01],
	[3.9575000000E+04, 3.6347104126E+01, 4.6540304626E+00, 2.4166129844E+01, 3.5241016325E+00, 9.7951605470E-01],
	[3.9580000000E+04, 3.6355159684E+01, 4.6540625454E+00, 2.4176201333E+01, 3.5244098549E+00, 9.7952649268E-01],
	[3.9585000000E+04, 3.6363216009E+01, 4.6540946243E+00, 2.4186275747E+01, 3.5247179861E+00, 9.7953692485E-01],
	[3.9590000000E+04, 3.6371273102E+01, 4.6541266994E+00, 2.4196353085E+01, 3.5250260262E+00, 9.7954735119E-01],
	[3.9595000000E+04, 3.6379330962E+01, 4.6541587707E+00, 2.4206433349E+01, 3.5253339753E+00, 9.7955777172E-01],
	[3.9600000000E+04, 3.6387389589E+01, 4.6541908382E+00, 2.4216516538E+01, 3.5256418333E+00, 9.7956818643E-01],
	[3.9605000000E+04, 3.6395448984E+01, 4.6542229018E+00, 2.4226602653E+01, 3.5259496003E+00, 9.7957859534E-01],
	[3.9610000000E+04, 3.6403509146E+01, 4.6542549616E+00, 2.4236691694E+01, 3.5262572762E+00, 9.7958899844E-01],
	[3.9615000000E+04, 3.6411570075E+01, 4.6542870176E+00, 2.4246783663E+01, 3.5265648613E+00, 9.7959939574E-01],
	[3.9620000000E+04, 3.6419631772E+01, 4.6543190697E+00, 2.4256878559E+01, 3.5268723554E+00, 9.7960978724E-01],
	[3.9625000000E+04, 3.6427694236E+01, 4.6543511181E+00, 2.4266976383E+01, 3.5271797585E+00, 9.7962017295E-01],
	[3.9630000000E+04, 3.6435757467E+01, 4.6543831626E+00, 2.4277077135E+01, 3.5274870708E+00, 9.7963055287E-01],
	[3.9635000000E+04, 3.6443821465E+01, 4.6544152033E+00, 2.4287180817E+01, 3.5277942923E+00, 9.7964092699E-01],
	[3.9640000000E+04, 3.6451886231E+01, 4.6544472401E+00, 2.4297287428E+01, 3.5281014229E+00, 9.7965129534E-01],
	[3.9645000000E+04, 3.6459951763E+01, 4.6544792732E+00, 2.4307396968E+01, 3.5284084628E+00, 9.7966165790E-01],
	[3.9650000000E+04, 3.6468018063E+01, 4.6545113024E+00, 2.4317509439E+01, 3.5287154119E+00, 9.7967201469E-01],
	[3.9655000000E+04, 3.6476085130E+01, 4.6545433278E+00, 2.4327624841E+01, 3.5290222702E+00, 9.7968236571E-01],
	[3.9660000000E+04, 3.6484152964E+01, 4.6545753494E+00, 2.4337743174E+01, 3.5293290379E+00, 9.7969271095E-01],
	[3.9665000000E+04, 3.6492221565E+01, 4.6546073671E+00, 2.4347864439E+01, 3.5296357149E+00, 9.7970305043E-01],
	[3.9670000000E+04, 3.6500290933E+01, 4.6546393811E+00, 2.4357988636E+01, 3.5299423012E+00, 9.7971338415E-01],
	[3.9675000000E+04, 3.6508361068E+01, 4.6546713912E+00, 2.4368115767E+01, 3.5302487969E+00, 9.7972371211E-01],
	[3.9680000000E+04, 3.6516431970E+01, 4.6547033976E+00, 2.4378245830E+01, 3.5305552021E+00, 9.7973403431E-01],
	[3.9685000000E+04, 3.6524503639E+01, 4.6547354001E+00, 2.4388378827E+01, 3.5308615166E+00, 9.7974435076E-01],
	[3.9690000000E+04, 3.6532576075E+01, 4.6547673988E+00, 2.4398514758E+01, 3.5311677407E+00, 9.7975466146E-01],
	[3.9695000000E+04, 3.6540649277E+01, 4.6547993937E+00, 2.4408653624E+01, 3.5314738742E+00, 9.7976496642E-01],
	[3.9700000000E+04, 3.6548723247E+01, 4.6548313847E+00, 2.4418795425E+01, 3.5317799173E+00, 9.7977526563E-01],
	[3.9705000000E+04, 3.6556797984E+01, 4.6548633720E+00, 2.4428940161E+01, 3.5320858699E+00, 9.7978555911E-01],
	[3.9710000000E+04, 3.6564873487E+01, 4.6548953555E+00, 2.4439087834E+01, 3.5323917322E+00, 9.7979584685E-01],
	[3.9715000000E+04, 3.6572949757E+01, 4.6549273351E+00, 2.4449238444E+01, 3.5326975040E+00, 9.7980612887E-01],
	[3.9720000000E+04, 3.6581026795E+01, 4.6549593110E+00, 2.4459391990E+01, 3.5330031855E+00, 9.7981640515E-01],
	[3.9725000000E+04, 3.6589104598E+01, 4.6549912830E+00, 2.4469548474E+01, 3.5333087766E+00, 9.7982667572E-01],
	[3.9730000000E+04, 3.6597183169E+01, 4.6550232513E+00, 2.4479707896E+01, 3.5336142775E+00, 9.7983694056E-01],
	[3.9735000000E+04, 3.6605262506E+01, 4.6550552157E+00, 2.4489870257E+01, 3.5339196881E+00, 9.7984719969E-01],
	[3.9740000000E+04, 3.6613342610E+01, 4.6550871763E+00, 2.4500035556E+01, 3.5342250084E+00, 9.7985745310E-01],
	[3.9745000000E+04, 3.6621423481E+01, 4.6551191332E+00, 2.4510203795E+01, 3.5345302385E+00, 9.7986770080E-01],
	[3.9750000000E+04, 3.6629505118E+01, 4.6551510862E+00, 2.4520374974E+01, 3.5348353785E+00, 9.7987794280E-01],
	[3.9755000000E+04, 3.6637587522E+01, 4.6551830354E+00, 2.4530549094E+01, 3.5351404283E+00, 9.7988817910E-01],
	[3.9760000000E+04, 3.6645670693E+01, 4.6552149809E+00, 2.4540726154E+01, 3.5354453879E+00, 9.7989840969E-01],
	[3.9765000000E+04, 3.6653754630E+01, 4.6552469225E+00, 2.4550906156E+01, 3.5357502575E+00, 9.7990863460E-01],
	[3.9770000000E+04, 3.6661839334E+01, 4.6552788603E+00, 2.4561089100E+01, 3.5360550370E+00, 9.7991885381E-01],
	[3.9775000000E+04, 3.6669924804E+01, 4.6553107944E+00, 2.4571274986E+01, 3.5363597264E+00, 9.7992906733E-01],
	[3.9780000000E+04, 3.6678011041E+01, 4.6553427246E+00, 2.4581463814E+01, 3.5366643259E+00, 9.7993927516E-01],
	[3.9785000000E+04, 3.6686098044E+01, 4.6553746511E+00, 2.4591655587E+01, 3.5369688354E+00, 9.7994947732E-01],
	[3.9790000000E+04, 3.6694185814E+01, 4.6554065737E+00, 2.4601850302E+01, 3.5372732549E+00, 9.7995967380E-01],
	[3.9795000000E+04, 3.6702274350E+01, 4.6554384926E+00, 2.4612047963E+01, 3.5375775845E+00, 9.7996986460E-01],
	[3.9800000000E+04, 3.6710363652E+01, 4.6554704077E+00, 2.4622248568E+01, 3.5378818242E+00, 9.7998004973E-01],
	[3.9805000000E+04, 3.6718453721E+01, 4.6555023190E+00, 2.4632452118E+01, 3.5381859740E+00, 9.7999022920E-01],
	[3.9810000000E+04, 3.6726544556E+01, 4.6555342265E+00, 2.4642658614E+01, 3.5384900340E+00, 9.8000040300E-01],
	[3.9815000000E+04, 3.6734636158E+01, 4.6555661302E+00, 2.4652868056E+01, 3.5387940042E+00, 9.8001057114E-01],
	[3.9820000000E+04, 3.6742728526E+01, 4.6555980301E+00, 2.4663080445E+01, 3.5390978846E+00, 9.8002073363E-01],
	[3.9825000000E+04, 3.6750821660E+01, 4.6556299262E+00, 2.4673295781E+01, 3.5394016752E+00, 9.8003089046E-01],
	[3.9830000000E+04, 3.6758915561E+01, 4.6556618186E+00, 2.4683514064E+01, 3.5397053761E+00, 9.8004104164E-01],
	[3.9835000000E+04, 3.6767010228E+01, 4.6556937071E+00, 2.4693735296E+01, 3.5400089874E+00, 9.8005118718E-01],
	[3.9840000000E+04, 3.6775105661E+01, 4.6557255919E+00, 2.4703959477E+01, 3.5403125089E+00, 9.8006132707E-01],
	[3.9845000000E+04, 3.6783201860E+01, 4.6557574729E+00, 2.4714186606E+01, 3.5406159409E+00, 9.8007146133E-01],
	[3.9850000000E+04, 3.6791298825E+01, 4.6557893501E+00, 2.4724416685E+01, 3.5409192832E+00, 9.8008158994E-01],
	[3.9855000000E+04, 3.6799396557E+01, 4.6558212236E+00, 2.4734649714E+01, 3.5412225359E+00, 9.8009171293E-01],
	[3.9860000000E+04, 3.6807495055E+01, 4.6558530932E+00, 2.4744885693E+01, 3.5415256991E+00, 9.8010183029E-01],
	[3.9865000000E+04, 3.6815594319E+01, 4.6558849591E+00, 2.4755124624E+01, 3.5418287728E+00, 9.8011194202E-01],
	[3.9870000000E+04, 3.6823700081E+01, 4.6559174363E+00, 2.4765366506E+01, 3.5421321660E+00, 9.8012204813E-01],
	[3.9875000000E+04, 3.6831818678E+01, 4.6559512043E+00, 2.4775611340E+01, 3.5424363309E+00, 9.8013214863E-01],
	[3.9880000000E+04, 3.6839938046E+01, 4.6559849682E+00, 2.4785859126E+01, 3.5427404065E+00, 9.8014224351E-01],
	[3.9885000000E+04, 3.6848058185E+01, 4.6560187281E+00, 2.4796109866E+01, 3.5430443928E+00, 9.8015233277E-01],
	[3.9890000000E+04, 3.6856179097E+01, 4.6560524841E+00, 2.4806363559E+01, 3.5433482900E+00, 9.8016241643E-01],
	[3.9895000000E+04, 3.6864300780E+01, 4.6560862361E+00, 2.4816620205E+01, 3.5436520980E+00, 9.8017249449E-01],
	[3.9900000000E+04, 3.6872423234E+01, 4.6561199840E+00, 2.4826879806E+01, 3.5439558169E+00, 9.8018256694E-01],
	[3.9905000000E+04, 3.6880546460E+01, 4.6561537280E+00, 2.4837142362E+01, 3.5442594467E+00, 9.8019263380E-01],
	[3.9910000000E+04, 3.6888670458E+01, 4.6561874681E+00, 2.4847407873E+01, 3.5445629874E+00, 9.8020269507E-01],
	[3.9915000000E+04, 3.6896795226E+01, 4.6562212041E+00, 2.4857676340E+01, 3.5448664390E+00, 9.8021275074E-01],
	[3.9920000000E+04, 3.6904920767E+01, 4.6562549362E+00, 2.4867947763E+01, 3.5451698017E+00, 9.8022280083E-01],
	[3.9925000000E+04, 3.6913047079E+01, 4.6562886642E+00, 2.4878222144E+01, 3.5454730753E+00, 9.8023284533E-01],
	[3.9930000000E+04, 3.6921174162E+01, 4.6563223883E+00, 2.4888499481E+01, 3.5457762600E+00, 9.8024288426E-01],
	[3.9935000000E+04, 3.6929302017E+01, 4.6563561084E+00, 2.4898779776E+01, 3.5460793557E+00, 9.8025291760E-01],
	[3.9940000000E+04, 3.6937430643E+01, 4.6563898246E+00, 2.4909063029E+01, 3.5463823626E+00, 9.8026294538E-01],
	[3.9945000000E+04, 3.6945560040E+01, 4.6564235367E+00, 2.4919349241E+01, 3.5466852805E+00, 9.8027296758E-01],
	[3.9950000000E+04, 3.6953690209E+01, 4.6564572449E+00, 2.4929638412E+01, 3.5469881096E+00, 9.8028298422E-01],
	[3.9955000000E+04, 3.6961821149E+01, 4.6564909491E+00, 2.4939930543E+01, 3.5472908499E+00, 9.8029299530E-01],
	[3.9960000000E+04, 3.6969952860E+01, 4.6565246494E+00, 2.4950225634E+01, 3.5475935014E+00, 9.8030300082E-01],
	[3.9965000000E+04, 3.6978085342E+01, 4.6565583456E+00, 2.4960523685E+01, 3.5478960641E+00, 9.8031300078E-01],
	[3.9970000000E+04, 3.6986218596E+01, 4.6565920379E+00, 2.4970824698E+01, 3.5481985381E+00, 9.8032299519E-01],
	[3.9975000000E+04, 3.6994352621E+01, 4.6566257262E+00, 2.4981128672E+01, 3.5485009234E+00, 9.8033298406E-01],
	[3.9980000000E+04, 3.7002487417E+01, 4.6566594106E+00, 2.4991435608E+01, 3.5488032200E+00, 9.8034296737E-01],
	[3.9985000000E+04, 3.7010622984E+01, 4.6566930910E+00, 2.5001745507E+01, 3.5491054279E+00, 9.8035294515E-01],
	[3.9990000000E+04, 3.7018759322E+01, 4.6567267674E+00, 2.5012058368E+01, 3.5494075472E+00, 9.8036291739E-01],
	[3.9995000000E+04, 3.7026896432E+01, 4.6567604398E+00, 2.5022374194E+01, 3.5497095780E+00, 9.8037288409E-01],
	[4.0000000000E+04, 3.7035034312E+01, 4.6567941083E+00, 2.5032692983E+01, 3.5500115201E+00, 9.8038284526E-01],
	[4.0005000000E+04, 3.7043172964E+01, 4.6568277729E+00, 2.5043039373E+01, 3.5503138689E+00, 9.8039280090E-01],
	[4.0010000000E+04, 3.7051312387E+01, 4.6568614334E+00, 2.5053388746E+01, 3.5506161289E+00, 9.8040275102E-01],
	[4.0015000000E+04, 3.7059452580E+01, 4.6568950900E+00, 2.5063741102E+01, 3.5509183001E+00, 9.8041269562E-01],
	[4.0020000000E+04, 3.7067593545E+01, 4.6569287426E+00, 2.5074096440E+01, 3.5512203825E+00, 9.8042263470E-01],
	[4.0025000000E+04, 3.7075735281E+01, 4.6569623913E+00, 2.5084454763E+01, 3.5515223763E+00, 9.8043256827E-01],
	[4.0030000000E+04, 3.7083877787E+01, 4.6569960360E+00, 2.5094816070E+01, 3.5518242813E+00, 9.8044249633E-01],
	[4.0035000000E+04, 3.7092021065E+01, 4.6570296768E+00, 2.5105180361E+01, 3.5521260976E+00, 9.8045241888E-01],
	[4.0040000000E+04, 3.7100165113E+01, 4.6570633135E+00, 2.5115547638E+01, 3.5524278254E+00, 9.8046233592E-01],
	[4.0045000000E+04, 3.7108309932E+01, 4.6570969464E+00, 2.5125917901E+01, 3.5527294645E+00, 9.8047224747E-01],
	[4.0050000000E+04, 3.7116455522E+01, 4.6571305753E+00, 2.5136291149E+01, 3.5530310150E+00, 9.8048215352E-01],
	[4.0055000000E+04, 3.7124601883E+01, 4.6571642002E+00, 2.5146667385E+01, 3.5533324770E+00, 9.8049205407E-01],
	[4.0060000000E+04, 3.7132749015E+01, 4.6571978211E+00, 2.5157046607E+01, 3.5536338504E+00, 9.8050194914E-01],
	[4.0065000000E+04, 3.7140896918E+01, 4.6572314382E+00, 2.5167428817E+01, 3.5539351354E+00, 9.8051183872E-01],
	[4.0070000000E+04, 3.7149045591E+01, 4.6572650512E+00, 2.5177814016E+01, 3.5542363318E+00, 9.8052172281E-01],
	[4.0075000000E+04, 3.7157195035E+01, 4.6572986603E+00, 2.5188202203E+01, 3.5545374399E+00, 9.8053160143E-01],
	[4.0080000000E+04, 3.7165345250E+01, 4.6573322655E+00, 2.5198593379E+01, 3.5548384595E+00, 9.8054147457E-01],
	[4.0085000000E+04, 3.7173496235E+01, 4.6573658667E+00, 2.5208987544E+01, 3.5551393908E+00, 9.8055134224E-01],
	[4.0090000000E+04, 3.7181647991E+01, 4.6573994640E+00, 2.5219384700E+01, 3.5554402337E+00, 9.8056120444E-01],
	[4.0095000000E+04, 3.7189800518E+01, 4.6574330573E+00, 2.5229784846E+01, 3.5557409882E+00, 9.8057106117E-01],
	[4.0100000000E+04, 3.7197953815E+01, 4.6574666466E+00, 2.5240187984E+01, 3.5560416545E+00, 9.8058091243E-01],
	[4.0105000000E+04, 3.7206107883E+01, 4.6575002321E+00, 2.5250594113E+01, 3.5563422325E+00, 9.8059075824E-01],
	[4.0110000000E+04, 3.7214262722E+01, 4.6575338135E+00, 2.5261003234E+01, 3.5566427223E+00, 9.8060059858E-01],
	[4.0115000000E+04, 3.7222418331E+01, 4.6575673911E+00, 2.5271415347E+01, 3.5569431238E+00, 9.8061043347E-01],
	[4.0120000000E+04, 3.7230574710E+01, 4.6576009647E+00, 2.5281830454E+01, 3.5572434372E+00, 9.8062026291E-01],
	[4.0125000000E+04, 3.7238731860E+01, 4.6576345343E+00, 2.5292248554E+01, 3.5575436624E+00, 9.8063008690E-01],
	[4.0130000000E+04, 3.7246889781E+01, 4.6576681000E+00, 2.5302669648E+01, 3.5578437995E+00, 9.8063990544E-01],
	[4.0135000000E+04, 3.7255048472E+01, 4.6577016618E+00, 2.5313093736E+01, 3.5581438485E+00, 9.8064971854E-01],
	[4.0140000000E+04, 3.7263207933E+01, 4.6577352196E+00, 2.5323520820E+01, 3.5584438094E+00, 9.8065952619E-01],
	[4.0145000000E+04, 3.7271368165E+01, 4.6577687735E+00, 2.5333950899E+01, 3.5587436823E+00, 9.8066932841E-01],
	[4.0150000000E+04, 3.7279529167E+01, 4.6578023235E+00, 2.5344383973E+01, 3.5590434671E+00, 9.8067912520E-01],
	[4.0155000000E+04, 3.7287690940E+01, 4.6578358695E+00, 2.5354820045E+01, 3.5593431640E+00, 9.8068891655E-01],
	[4.0160000000E+04, 3.7295853483E+01, 4.6578694116E+00, 2.5365259113E+01, 3.5596427729E+00, 9.8069870247E-01],
	[4.0165000000E+04, 3.7304016796E+01, 4.6579029497E+00, 2.5375701178E+01, 3.5599422939E+00, 9.8070848297E-01],
	[4.0170000000E+04, 3.7312180880E+01, 4.6579364839E+00, 2.5386146242E+01, 3.5602417270E+00, 9.8071825805E-01],
	[4.0175000000E+04, 3.7320345734E+01, 4.6579700142E+00, 2.5396594304E+01, 3.5605410722E+00, 9.8072802770E-01],
	[4.0180000000E+04, 3.7328511358E+01, 4.6580035406E+00, 2.5407045364E+01, 3.5608403296E+00, 9.8073779194E-01],
	[4.0185000000E+04, 3.7336677752E+01, 4.6580370630E+00, 2.5417499424E+01, 3.5611394991E+00, 9.8074755077E-01],
	[4.0190000000E+04, 3.7344844916E+01, 4.6580705815E+00, 2.5427956484E+01, 3.5614385809E+00, 9.8075730418E-01],
	[4.0195000000E+04, 3.7353012851E+01, 4.6581040960E+00, 2.5438416544E+01, 3.5617375749E+00, 9.8076705218E-01],
	[4.0200000000E+04, 3.7361181556E+01, 4.6581376067E+00, 2.5448879605E+01, 3.5620364811E+00, 9.8077679479E-01],
	[4.0205000000E+04, 3.7369351031E+01, 4.6581711134E+00, 2.5459345668E+01, 3.5623352997E+00, 9.8078653198E-01],
	[4.0210000000E+04, 3.7377521276E+01, 4.6582046161E+00, 2.5469814732E+01, 3.5626340306E+00, 9.8079626378E-01],
	[4.0215000000E+04, 3.7385692291E+01, 4.6582381150E+00, 2.5480286798E+01, 3.5629326739E+00, 9.8080599019E-01],
	[4.0220000000E+04, 3.7393864076E+01, 4.6582716099E+00, 2.5490761867E+01, 3.5632312295E+00, 9.8081571120E-01],
	[4.0225000000E+04, 3.7402036631E+01, 4.6583051009E+00, 2.5501239939E+01, 3.5635296975E+00, 9.8082542682E-01],
	[4.0230000000E+04, 3.7410209957E+01, 4.6583385880E+00, 2.5511721015E+01, 3.5638280780E+00, 9.8083513705E-01],
	[4.0235000000E+04, 3.7418384052E+01, 4.6583720712E+00, 2.5522205096E+01, 3.5641263710E+00, 9.8084484190E-01],
	[4.0240000000E+04, 3.7426558917E+01, 4.6584055504E+00, 2.5532692181E+01, 3.5644245764E+00, 9.8085454137E-01],
	[4.0245000000E+04, 3.7434734552E+01, 4.6584390258E+00, 2.5543182271E+01, 3.5647226944E+00, 9.8086423546E-01],
	[4.0250000000E+04, 3.7442910957E+01, 4.6584724972E+00, 2.5553675367E+01, 3.5650207249E+00, 9.8087392417E-01],
	[4.0255000000E+04, 3.7451088132E+01, 4.6585059647E+00, 2.5564171469E+01, 3.5653186680E+00, 9.8088360751E-01],
	[4.0260000000E+04, 3.7459266077E+01, 4.6585394283E+00, 2.5574670578E+01, 3.5656165237E+00, 9.8089328548E-01],
	[4.0265000000E+04, 3.7467444792E+01, 4.6585728879E+00, 2.5585172693E+01, 3.5659142920E+00, 9.8090295809E-01],
	[4.0270000000E+04, 3.7475624276E+01, 4.6586063437E+00, 2.5595677817E+01, 3.5662119730E+00, 9.8091262533E-01],
	[4.0275000000E+04, 3.7483804531E+01, 4.6586397955E+00, 2.5606185949E+01, 3.5665095667E+00, 9.8092228721E-01],
	[4.0280000000E+04, 3.7491985555E+01, 4.6586732434E+00, 2.5616697089E+01, 3.5668070731E+00, 9.8093194374E-01],
	[4.0285000000E+04, 3.7500167349E+01, 4.6587066874E+00, 2.5627211238E+01, 3.5671044923E+00, 9.8094159491E-01],
	[4.0290000000E+04, 3.7508349912E+01, 4.6587401275E+00, 2.5637728397E+01, 3.5674018242E+00, 9.8095124073E-01],
	[4.0295000000E+04, 3.7516533246E+01, 4.6587735637E+00, 2.5648248566E+01, 3.5676990690E+00, 9.8096088120E-01],
	[4.0300000000E+04, 3.7524717349E+01, 4.6588069960E+00, 2.5658771746E+01, 3.5679962266E+00, 9.8097051632E-01],
	[4.0305000000E+04, 3.7532902221E+01, 4.6588404244E+00, 2.5669297936E+01, 3.5682932970E+00, 9.8098014610E-01],
	[4.0310000000E+04, 3.7541087864E+01, 4.6588738488E+00, 2.5679827138E+01, 3.5685902803E+00, 9.8098977054E-01],
	[4.0315000000E+04, 3.7549274276E+01, 4.6589072694E+00, 2.5690359352E+01, 3.5688871766E+00, 9.8099938965E-01],
	[4.0320000000E+04, 3.7557461457E+01, 4.6589406860E+00, 2.5700894579E+01, 3.5691839858E+00, 9.8100900342E-01],
	[4.0325000000E+04, 3.7565649408E+01, 4.6589740988E+00, 2.5711432819E+01, 3.5694807080E+00, 9.8101861186E-01],
	[4.0330000000E+04, 3.7573838129E+01, 4.6590075076E+00, 2.5721974072E+01, 3.5697773431E+00, 9.8102821498E-01],
	[4.0335000000E+04, 3.7582027619E+01, 4.6590409126E+00, 2.5732518339E+01, 3.5700738913E+00, 9.8103781276E-01],
	[4.0340000000E+04, 3.7590217879E+01, 4.6590743136E+00, 2.5743065621E+01, 3.5703703526E+00, 9.8104740523E-01],
	[4.0345000000E+04, 3.7598408908E+01, 4.6591077108E+00, 2.5753615917E+01, 3.5706667269E+00, 9.8105699238E-01],
	[4.0350000000E+04, 3.7606600707E+01, 4.6591411040E+00, 2.5764169229E+01, 3.5709630144E+00, 9.8106657421E-01],
	[4.0355000000E+04, 3.7614793275E+01, 4.6591744934E+00, 2.5774725557E+01, 3.5712592150E+00, 9.8107615073E-01],
	[4.0360000000E+04, 3.7622986612E+01, 4.6592078788E+00, 2.5785284901E+01, 3.5715553288E+00, 9.8108572194E-01],
	[4.0365000000E+04, 3.7631180719E+01, 4.6592412604E+00, 2.5795847263E+01, 3.5718513557E+00, 9.8109528784E-01],
	[4.0370000000E+04, 3.7639375595E+01, 4.6592746380E+00, 2.5806412641E+01, 3.5721472959E+00, 9.8110484844E-01],
	[4.0375000000E+04, 3.7647571241E+01, 4.6593080118E+00, 2.5816981038E+01, 3.5724431494E+00, 9.8111440374E-01],
	[4.0380000000E+04, 3.7655767656E+01, 4.6593413816E+00, 2.5827552453E+01, 3.5727389161E+00, 9.8112395373E-01],
	[4.0385000000E+04, 3.7663964840E+01, 4.6593747476E+00, 2.5838126886E+01, 3.5730345961E+00, 9.8113349844E-01],
	[4.0390000000E+04, 3.7672162794E+01, 4.6594081097E+00, 2.5848704339E+01, 3.5733301895E+00, 9.8114303785E-01],
	[4.0395000000E+04, 3.7680361516E+01, 4.6594414679E+00, 2.5859284812E+01, 3.5736256963E+00, 9.8115257197E-01],
	[4.0400000000E+04, 3.7688561008E+01, 4.6594748222E+00, 2.5869868305E+01, 3.5739211164E+00, 9.8116210081E-01],
	[4.0405000000E+04, 3.7696761270E+01, 4.6595081726E+00, 2.5880454819E+01, 3.5742164500E+00, 9.8117162436E-01],
	[4.0410000000E+04, 3.7704962300E+01, 4.6595415191E+00, 2.5891044355E+01, 3.5745116970E+00, 9.8118114263E-01],
	[4.0415000000E+04, 3.7713164099E+01, 4.6595748618E+00, 2.5901636912E+01, 3.5748068575E+00, 9.8119065563E-01],
	[4.0420000000E+04, 3.7721366668E+01, 4.6596082005E+00, 2.5912232491E+01, 3.5751019315E+00, 9.8120016335E-01],
	[4.0425000000E+04, 3.7729570006E+01, 4.6596415354E+00, 2.5922831093E+01, 3.5753969190E+00, 9.8120966580E-01],
	[4.0430000000E+04, 3.7737774113E+01, 4.6596748664E+00, 2.5933432719E+01, 3.5756918201E+00, 9.8121916298E-01],
	[4.0435000000E+04, 3.7745978989E+01, 4.6597081935E+00, 2.5944037368E+01, 3.5759866348E+00, 9.8122865489E-01],
	[4.0440000000E+04, 3.7754184634E+01, 4.6597415167E+00, 2.5954645041E+01, 3.5762813632E+00, 9.8123814155E-01],
	[4.0445000000E+04, 3.7762391048E+01, 4.6597748360E+00, 2.5965255739E+01, 3.5765760051E+00, 9.8124762294E-01],
	[4.0450000000E+04, 3.7770598231E+01, 4.6598081515E+00, 2.5975869463E+01, 3.5768705607E+00, 9.8125709908E-01],
	[4.0455000000E+04, 3.7778806183E+01, 4.6598414631E+00, 2.5986486212E+01, 3.5771650301E+00, 9.8126656996E-01],
	[4.0460000000E+04, 3.7787014904E+01, 4.6598747707E+00, 2.5997105987E+01, 3.5774594131E+00, 9.8127603559E-01],
	[4.0465000000E+04, 3.7795224393E+01, 4.6599080746E+00, 2.6007728788E+01, 3.5777537100E+00, 9.8128549598E-01],
	[4.0470000000E+04, 3.7803434652E+01, 4.6599413745E+00, 2.6018354617E+01, 3.5780479206E+00, 9.8129495112E-01],
	[4.0475000000E+04, 3.7811645680E+01, 4.6599746706E+00, 2.6028983474E+01, 3.5783420450E+00, 9.8130440101E-01],
	[4.0480000000E+04, 3.7819857476E+01, 4.6600079628E+00, 2.6039615359E+01, 3.5786360833E+00, 9.8131384567E-01],
	[4.0485000000E+04, 3.7828070042E+01, 4.6600412511E+00, 2.6050250272E+01, 3.5789300354E+00, 9.8132328510E-01],
	[4.0490000000E+04, 3.7836283376E+01, 4.6600745355E+00, 2.6060888215E+01, 3.5792239015E+00, 9.8133271929E-01],
	[4.0495000000E+04, 3.7844497479E+01, 4.6601078161E+00, 2.6071529187E+01, 3.5795176814E+00, 9.8134214825E-01],
	[4.0500000000E+04, 3.7852712351E+01, 4.6601410928E+00, 2.6082173189E+01, 3.5798113754E+00, 9.8135157198E-01],
	[4.0505000000E+04, 3.7860927991E+01, 4.6601743656E+00, 2.6092820222E+01, 3.5801049833E+00, 9.8136099049E-01],
	[4.0510000000E+04, 3.7869144400E+01, 4.6602076346E+00, 2.6103470285E+01, 3.5803985052E+00, 9.8137040378E-01],
	[4.0515000000E+04, 3.7877378563E+01, 4.6602426848E+00, 2.6114123381E+01, 3.5806931468E+00, 9.8137981185E-01],
	[4.0520000000E+04, 3.7885614267E+01, 4.6602778116E+00, 2.6124779508E+01, 3.5809877571E+00, 9.8138921470E-01],
	[4.0525000000E+04, 3.7893850746E+01, 4.6603129344E+00, 2.6135438668E+01, 3.5812822817E+00, 9.8139861235E-01],
	[4.0530000000E+04, 3.7902087999E+01, 4.6603480531E+00, 2.6146100861E+01, 3.5815767206E+00, 9.8140800478E-01],
	[4.0535000000E+04, 3.7910326025E+01, 4.6603831677E+00, 2.6156766087E+01, 3.5818710738E+00, 9.8141739201E-01],
	[4.0540000000E+04, 3.7918564826E+01, 4.6604182783E+00, 2.6167434348E+01, 3.5821653414E+00, 9.8142677403E-01],
	[4.0545000000E+04, 3.7926804401E+01, 4.6604533848E+00, 2.6178105643E+01, 3.5824595233E+00, 9.8143615085E-01],
	[4.0550000000E+04, 3.7935044750E+01, 4.6604884872E+00, 2.6188779973E+01, 3.5827536197E+00, 9.8144552248E-01],
	[4.0555000000E+04, 3.7943285873E+01, 4.6605235855E+00, 2.6199457338E+01, 3.5830476305E+00, 9.8145488891E-01],
	[4.0560000000E+04, 3.7951527771E+01, 4.6605586798E+00, 2.6210137739E+01, 3.5833415557E+00, 9.8146425015E-01],
	[4.0565000000E+04, 3.7959770442E+01, 4.6605937701E+00, 2.6220821177E+01, 3.5836353954E+00, 9.8147360620E-01],
	[4.0570000000E+04, 3.7968013887E+01, 4.6606288563E+00, 2.6231507652E+01, 3.5839291497E+00, 9.8148295707E-01],
	[4.0575000000E+04, 3.7976258106E+01, 4.6606639384E+00, 2.6242197164E+01, 3.5842228185E+00, 9.8149230275E-01],
	[4.0580000000E+04, 3.7984503099E+01, 4.6606990164E+00, 2.6252889714E+01, 3.5845164018E+00, 9.8150164325E-01],
	[4.0585000000E+04, 3.7992748866E+01, 4.6607340904E+00, 2.6263585302E+01, 3.5848098998E+00, 9.8151097858E-01],
	[4.0590000000E+04, 3.8000995406E+01, 4.6607691604E+00, 2.6274283929E+01, 3.5851033124E+00, 9.8152030873E-01],
	[4.0595000000E+04, 3.8009242721E+01, 4.6608042263E+00, 2.6284985596E+01, 3.5853966396E+00, 9.8152963371E-01],
	[4.0600000000E+04, 3.8017490809E+01, 4.6608392881E+00, 2.6295690302E+01, 3.5856898815E+00, 9.8153895353E-01],
	[4.0605000000E+04, 3.8025739672E+01, 4.6608743459E+00, 2.6306398049E+01, 3.5859830382E+00, 9.8154826817E-01],
	[4.0610000000E+04, 3.8033989308E+01, 4.6609093996E+00, 2.6317108837E+01, 3.5862761096E+00, 9.8155757766E-01],
	[4.0615000000E+04, 3.8042239718E+01, 4.6609444493E+00, 2.6327822666E+01, 3.5865690957E+00, 9.8156688199E-01],
	[4.0620000000E+04, 3.8050490901E+01, 4.6609794949E+00, 2.6338539537E+01, 3.5868619966E+00, 9.8157618116E-01],
	[4.0625000000E+04, 3.8058742858E+01, 4.6610145365E+00, 2.6349259450E+01, 3.5871548124E+00, 9.8158547518E-01],
	[4.0630000000E+04, 3.8066995589E+01, 4.6610495740E+00, 2.6359982406E+01, 3.5874475430E+00, 9.8159476405E-01],
	[4.0635000000E+04, 3.8075249094E+01, 4.6610846075E+00, 2.6370708405E+01, 3.5877401885E+00, 9.8160404777E-01],
	[4.0640000000E+04, 3.8083503372E+01, 4.6611196369E+00, 2.6381437448E+01, 3.5880327488E+00, 9.8161332634E-01],
	[4.0645000000E+04, 3.8091758424E+01, 4.6611546623E+00, 2.6392169535E+01, 3.5883252241E+00, 9.8162259978E-01],
	[4.0650000000E+04, 3.8100014250E+01, 4.6611896836E+00, 2.6402904667E+01, 3.5886176144E+00, 9.8163186807E-01],
	[4.0655000000E+04, 3.8108270849E+01, 4.6612247009E+00, 2.6413642845E+01, 3.5889099197E+00, 9.8164113124E-01],
	[4.0660000000E+04, 3.8116528221E+01, 4.6612597142E+00, 2.6424384068E+01, 3.5892021399E+00, 9.8165038926E-01],
	[4.0665000000E+04, 3.8124786368E+01, 4.6612947234E+00, 2.6435128337E+01, 3.5894942752E+00, 9.8165964216E-01],
	[4.0670000000E+04, 3.8133045287E+01, 4.6613297285E+00, 2.6445875653E+01, 3.5897863256E+00, 9.8166888994E-01],
	[4.0675000000E+04, 3.8141304981E+01, 4.6613647297E+00, 2.6456626016E+01, 3.5900782911E+00, 9.8167813258E-01],
	[4.0680000000E+04, 3.8149565447E+01, 4.6613997268E+00, 2.6467379426E+01, 3.5903701717E+00, 9.8168737011E-01],
	[4.0685000000E+04, 3.8157826687E+01, 4.6614347198E+00, 2.6478135885E+01, 3.5906619674E+00, 9.8169660252E-01],
	[4.0690000000E+04, 3.8166088701E+01, 4.6614697088E+00, 2.6488895393E+01, 3.5909536783E+00, 9.8170582982E-01],
	[4.0695000000E+04, 3.8174351488E+01, 4.6615046938E+00, 2.6499657950E+01, 3.5912453045E+00, 9.8171505200E-01],
	[4.0700000000E+04, 3.8182615048E+01, 4.6615396747E+00, 2.6510423556E+01, 3.5915368458E+00, 9.8172426907E-01],
	[4.0705000000E+04, 3.8190879382E+01, 4.6615746516E+00, 2.6521192213E+01, 3.5918283025E+00, 9.8173348104E-01],
	[4.0710000000E+04, 3.8199144489E+01, 4.6616096245E+00, 2.6531963920E+01, 3.5921196744E+00, 9.8174268790E-01],
	[4.0715000000E+04, 3.8207410369E+01, 4.6616445933E+00, 2.6542738678E+01, 3.5924109616E+00, 9.8175188967E-01],
	[4.0720000000E+04, 3.8215677023E+01, 4.6616795581E+00, 2.6553516488E+01, 3.5927021642E+00, 9.8176108634E-01],
	[4.0725000000E+04, 3.8223944450E+01, 4.6617145189E+00, 2.6564297350E+01, 3.5929932821E+00, 9.8177027791E-01],
	[4.0730000000E+04, 3.8232212650E+01, 4.6617494757E+00, 2.6575081264E+01, 3.5932843155E+00, 9.8177946439E-01],
	[4.0735000000E+04, 3.8240481623E+01, 4.6617844284E+00, 2.6585868232E+01, 3.5935752642E+00, 9.8178864578E-01],
	[4.0740000000E+04, 3.8248751370E+01, 4.6618193771E+00, 2.6596658253E+01, 3.5938661285E+00, 9.8179782209E-01],
	[4.0745000000E+04, 3.8257021890E+01, 4.6618543217E+00, 2.6607451328E+01, 3.5941569082E+00, 9.8180699331E-01],
	[4.0750000000E+04, 3.8265293182E+01, 4.6618892623E+00, 2.6618247458E+01, 3.5944476034E+00, 9.8181615946E-01],
	[4.0755000000E+04, 3.8273565248E+01, 4.6619241990E+00, 2.6629046643E+01, 3.5947382141E+00, 9.8182532053E-01],
	[4.0760000000E+04, 3.8281838088E+01, 4.6619591315E+00, 2.6639848883E+01, 3.5950287405E+00, 9.8183447652E-01],
	[4.0765000000E+04, 3.8290111700E+01, 4.6619940601E+00, 2.6650654179E+01, 3.5953191824E+00, 9.8184362744E-01],
	[4.0770000000E+04, 3.8298386085E+01, 4.6620289846E+00, 2.6661462532E+01, 3.5956095399E+00, 9.8185277330E-01],
	[4.0775000000E+04, 3.8306661243E+01, 4.6620639052E+00, 2.6672273942E+01, 3.5958998131E+00, 9.8186191409E-01],
	[4.0780000000E+04, 3.8314937175E+01, 4.6620988217E+00, 2.6683088409E+01, 3.5961900019E+00, 9.8187104982E-01],
	[4.0785000000E+04, 3.8323213879E+01, 4.6621337341E+00, 2.6693905934E+01, 3.5964801064E+00, 9.8188018049E-01],
	[4.0790000000E+04, 3.8331491356E+01, 4.6621686426E+00, 2.6704726518E+01, 3.5967701267E+00, 9.8188930610E-01],
	[4.0795000000E+04, 3.8339769607E+01, 4.6622035470E+00, 2.6715550161E+01, 3.5970600627E+00, 9.8189842666E-01],
	[4.0800000000E+04, 3.8348048630E+01, 4.6622384475E+00, 2.6726376863E+01, 3.5973499145E+00, 9.8190754217E-01],
	[4.0805000000E+04, 3.8356328426E+01, 4.6622733439E+00, 2.6737206625E+01, 3.5976396822E+00, 9.8191665263E-01],
	[4.0810000000E+04, 3.8364608995E+01, 4.6623082363E+00, 2.6748039447E+01, 3.5979293656E+00, 9.8192575805E-01],
	[4.0815000000E+04, 3.8372890337E+01, 4.6623431247E+00, 2.6758875330E+01, 3.5982189649E+00, 9.8193485843E-01],
	[4.0820000000E+04, 3.8381172451E+01, 4.6623780090E+00, 2.6769714275E+01, 3.5985084802E+00, 9.8194395376E-01],
	[4.0825000000E+04, 3.8389455339E+01, 4.6624128894E+00, 2.6780556281E+01, 3.5987979113E+00, 9.8195304407E-01],
	[4.0830000000E+04, 3.8397738999E+01, 4.6624477657E+00, 2.6791401350E+01, 3.5990872584E+00, 9.8196212934E-01],
	[4.0835000000E+04, 3.8406023432E+01, 4.6624826381E+00, 2.6802249482E+01, 3.5993765214E+00, 9.8197120957E-01],
	[4.0840000000E+04, 3.8414308638E+01, 4.6625175064E+00, 2.6813100677E+01, 3.5996657005E+00, 9.8198028479E-01],
	[4.0845000000E+04, 3.8422594617E+01, 4.6625523707E+00, 2.6823954936E+01, 3.5999547956E+00, 9.8198935497E-01],
	[4.0850000000E+04, 3.8430881368E+01, 4.6625872310E+00, 2.6834812259E+01, 3.6002438067E+00, 9.8199842014E-01],
	[4.0855000000E+04, 3.8439168892E+01, 4.6626220873E+00, 2.6845672647E+01, 3.6005327340E+00, 9.8200748029E-01],
	[4.0860000000E+04, 3.8447457188E+01, 4.6626569396E+00, 2.6856536101E+01, 3.6008215773E+00, 9.8201653542E-01],
	[4.0865000000E+04, 3.8455746257E+01, 4.6626917879E+00, 2.6867402620E+01, 3.6011103368E+00, 9.8202558554E-01],
	[4.0870000000E+04, 3.8464036099E+01, 4.6627266322E+00, 2.6878272205E+01, 3.6013990124E+00, 9.8203463066E-01],
	[4.0875000000E+04, 3.8472326714E+01, 4.6627614725E+00, 2.6889144857E+01, 3.6016876042E+00, 9.8204367076E-01],
	[4.0880000000E+04, 3.8480618101E+01, 4.6627963088E+00, 2.6900020577E+01, 3.6019761123E+00, 9.8205270586E-01],
	[4.0885000000E+04, 3.8488910260E+01, 4.6628311411E+00, 2.6910899364E+01, 3.6022645366E+00, 9.8206173596E-01],
	[4.0890000000E+04, 3.8497203192E+01, 4.6628659694E+00, 2.6921781220E+01, 3.6025528772E+00, 9.8207076107E-01],
	[4.0895000000E+04, 3.8505496897E+01, 4.6629007937E+00, 2.6932666144E+01, 3.6028411341E+00, 9.8207978118E-01],
	[4.0900000000E+04, 3.8513791374E+01, 4.6629356140E+00, 2.6943554137E+01, 3.6031293073E+00, 9.8208879629E-01],
	[4.0905000000E+04, 3.8522086623E+01, 4.6629704303E+00, 2.6954445201E+01, 3.6034173968E+00, 9.8209780642E-01],
	[4.0910000000E+04, 3.8530382645E+01, 4.6630052426E+00, 2.6965339334E+01, 3.6037054028E+00, 9.8210681156E-01],
	[4.0915000000E+04, 3.8538679439E+01, 4.6630400509E+00, 2.6976236538E+01, 3.6039933252E+00, 9.8211581172E-01],
	[4.0920000000E+04, 3.8546977006E+01, 4.6630748552E+00, 2.6987136813E+01, 3.6042811640E+00, 9.8212480690E-01],
	[4.0925000000E+04, 3.8555275345E+01, 4.6631096555E+00, 2.6998040160E+01, 3.6045689192E+00, 9.8213379710E-01],
	[4.0930000000E+04, 3.8563574456E+01, 4.6631444519E+00, 2.7008946579E+01, 3.6048565910E+00, 9.8214278233E-01],
	[4.0935000000E+04, 3.8571874340E+01, 4.6631792442E+00, 2.7019856071E+01, 3.6051441793E+00, 9.8215176258E-01],
	[4.0940000000E+04, 3.8580174996E+01, 4.6632140326E+00, 2.7030768636E+01, 3.6054316841E+00, 9.8216073787E-01],
	[4.0945000000E+04, 3.8588476424E+01, 4.6632488169E+00, 2.7041684275E+01, 3.6057191055E+00, 9.8216970819E-01],
	[4.0950000000E+04, 3.8596778625E+01, 4.6632835973E+00, 2.7052602987E+01, 3.6060064435E+00, 9.8217867354E-01],
	[4.0955000000E+04, 3.8605081598E+01, 4.6633183737E+00, 2.7063524775E+01, 3.6062936981E+00, 9.8218763394E-01],
	[4.0960000000E+04, 3.8613385343E+01, 4.6633531461E+00, 2.7074449637E+01, 3.6065808694E+00, 9.8219658938E-01],
	[4.0965000000E+04, 3.8621689860E+01, 4.6633879145E+00, 2.7085377575E+01, 3.6068679574E+00, 9.8220553987E-01],
	[4.0970000000E+04, 3.8629995149E+01, 4.6634226789E+00, 2.7096308589E+01, 3.6071549621E+00, 9.8221448541E-01],
	[4.0975000000E+04, 3.8638301211E+01, 4.6634574394E+00, 2.7107242680E+01, 3.6074418835E+00, 9.8222342599E-01],
	[4.0980000000E+04, 3.8646608044E+01, 4.6634921958E+00, 2.7118179848E+01, 3.6077287217E+00, 9.8223236163E-01],
	[4.0985000000E+04, 3.8654915650E+01, 4.6635269483E+00, 2.7129120093E+01, 3.6080154767E+00, 9.8224129233E-01],
	[4.0990000000E+04, 3.8663224028E+01, 4.6635616968E+00, 2.7140063416E+01, 3.6083021485E+00, 9.8225021809E-01],
	[4.0995000000E+04, 3.8671533178E+01, 4.6635964413E+00, 2.7151009818E+01, 3.6085887371E+00, 9.8225913892E-01],
	[4.1000000000E+04, 3.8679843099E+01, 4.6636311819E+00, 2.7161959299E+01, 3.6088752427E+00, 9.8226805481E-01],
	[4.1005000000E+04, 3.8688153793E+01, 4.6636659185E+00, 2.7172911860E+01, 3.6091616651E+00, 9.8227696577E-01],
	[4.1010000000E+04, 3.8696465259E+01, 4.6637006510E+00, 2.7183867500E+01, 3.6094480044E+00, 9.8228587180E-01],
	[4.1015000000E+04, 3.8704777497E+01, 4.6637353797E+00, 2.7194826221E+01, 3.6097342607E+00, 9.8229477290E-01],
	[4.1020000000E+04, 3.8713090506E+01, 4.6637701043E+00, 2.7205788023E+01, 3.6100204340E+00, 9.8230366909E-01],
	[4.1025000000E+04, 3.8721404288E+01, 4.6638048250E+00, 2.7216752906E+01, 3.6103065243E+00, 9.8231256035E-01],
	[4.1030000000E+04, 3.8729718842E+01, 4.6638395417E+00, 2.7227720872E+01, 3.6105925316E+00, 9.8232144670E-01],
	[4.1035000000E+04, 3.8738034167E+01, 4.6638742544E+00, 2.7238691920E+01, 3.6108784560E+00, 9.8233032813E-01],
	[4.1040000000E+04, 3.8746350264E+01, 4.6639089631E+00, 2.7249666050E+01, 3.6111642975E+00, 9.8233920466E-01],
	[4.1045000000E+04, 3.8754667133E+01, 4.6639436679E+00, 2.7260643265E+01, 3.6114500561E+00, 9.8234807628E-01],
	[4.1050000000E+04, 3.8762984774E+01, 4.6639783687E+00, 2.7271623563E+01, 3.6117357319E+00, 9.8235694299E-01],
	[4.1055000000E+04, 3.8771303187E+01, 4.6640130656E+00, 2.7282606946E+01, 3.6120213248E+00, 9.8236580480E-01],
	[4.1060000000E+04, 3.8779622371E+01, 4.6640477584E+00, 2.7293593413E+01, 3.6123068349E+00, 9.8237466171E-01],
	[4.1065000000E+04, 3.8787942327E+01, 4.6640824473E+00, 2.7304582966E+01, 3.6125922623E+00, 9.8238351372E-01],
	[4.1070000000E+04, 3.8796263055E+01, 4.6641171323E+00, 2.7315575605E+01, 3.6128776069E+00, 9.8239236084E-01],
	[4.1075000000E+04, 3.8804584555E+01, 4.6641518133E+00, 2.7326571330E+01, 3.6131628688E+00, 9.8240120308E-01],
	[4.1080000000E+04, 3.8812906826E+01, 4.6641864903E+00, 2.7337570142E+01, 3.6134480479E+00, 9.8241004042E-01],
	[4.1085000000E+04, 3.8821229869E+01, 4.6642211633E+00, 2.7348572042E+01, 3.6137331445E+00, 9.8241887288E-01],
	[4.1090000000E+04, 3.8829553683E+01, 4.6642558324E+00, 2.7359577029E+01, 3.6140181583E+00, 9.8242770046E-01],
	[4.1095000000E+04, 3.8837878270E+01, 4.6642904976E+00, 2.7370585105E+01, 3.6143030896E+00, 9.8243652316E-01],
	[4.1100000000E+04, 3.8846203627E+01, 4.6643251587E+00, 2.7381596269E+01, 3.6145879383E+00, 9.8244534098E-01],
	[4.1105000000E+04, 3.8854529756E+01, 4.6643598159E+00, 2.7392610523E+01, 3.6148727044E+00, 9.8245415393E-01],
	[4.1110000000E+04, 3.8862856657E+01, 4.6643944692E+00, 2.7403627867E+01, 3.6151573880E+00, 9.8246296201E-01],
	[4.1115000000E+04, 3.8871184330E+01, 4.6644291185E+00, 2.7414648301E+01, 3.6154419891E+00, 9.8247176522E-01],
	[4.1120000000E+04, 3.8879512773E+01, 4.6644637638E+00, 2.7425671826E+01, 3.6157265077E+00, 9.8248056357E-01],
	[4.1125000000E+04, 3.8887841989E+01, 4.6644984052E+00, 2.7436698442E+01, 3.6160109439E+00, 9.8248935706E-01],
	[4.1130000000E+04, 3.8896171975E+01, 4.6645330426E+00, 2.7447728150E+01, 3.6162952977E+00, 9.8249814569E-01],
	[4.1135000000E+04, 3.8904502733E+01, 4.6645676761E+00, 2.7458760950E+01, 3.6165795690E+00, 9.8250692946E-01],
	[4.1140000000E+04, 3.8912834263E+01, 4.6646023056E+00, 2.7469796843E+01, 3.6168637580E+00, 9.8251570838E-01],
	[4.1145000000E+04, 3.8921166564E+01, 4.6646369312E+00, 2.7480835829E+01, 3.6171478646E+00, 9.8252448245E-01],
	[4.1150000000E+04, 3.8929499636E+01, 4.6646715528E+00, 2.7491877909E+01, 3.6174318890E+00, 9.8253325168E-01],
	[4.1155000000E+04, 3.8937833480E+01, 4.6647061705E+00, 2.7502923083E+01, 3.6177158310E+00, 9.8254201606E-01],
	[4.1160000000E+04, 3.8946168094E+01, 4.6647407842E+00, 2.7513971352E+01, 3.6179996908E+00, 9.8255077559E-01],
	[4.1165000000E+04, 3.8954512793E+01, 4.6647763509E+00, 2.7525022716E+01, 3.6182841244E+00, 9.8255953029E-01],
	[4.1170000000E+04, 3.8962866697E+01, 4.6648127797E+00, 2.7536077176E+01, 3.6185690698E+00, 9.8256828016E-01],
	[4.1175000000E+04, 3.8971221377E+01, 4.6648492043E+00, 2.7547134732E+01, 3.6188539331E+00, 9.8257702519E-01],
	[4.1180000000E+04, 3.8979576833E+01, 4.6648856248E+00, 2.7558195385E+01, 3.6191387145E+00, 9.8258576539E-01],
	[4.1185000000E+04, 3.8987933067E+01, 4.6649220412E+00, 2.7569259135E+01, 3.6194234139E+00, 9.8259450077E-01],
	[4.1190000000E+04, 3.8996290077E+01, 4.6649584534E+00, 2.7580325982E+01, 3.6197080314E+00, 9.8260323132E-01],
	[4.1195000000E+04, 3.9004647863E+01, 4.6649948614E+00, 2.7591395928E+01, 3.6199925669E+00, 9.8261195705E-01],
	[4.1200000000E+04, 3.9013006426E+01, 4.6650312654E+00, 2.7602468972E+01, 3.6202770206E+00, 9.8262067796E-01],
	[4.1205000000E+04, 3.9021365766E+01, 4.6650676652E+00, 2.7613545116E+01, 3.6205613924E+00, 9.8262939405E-01],
	[4.1210000000E+04, 3.9029725882E+01, 4.6651040609E+00, 2.7624624359E+01, 3.6208456823E+00, 9.8263810534E-01],
	[4.1215000000E+04, 3.9038086775E+01, 4.6651404524E+00, 2.7635706702E+01, 3.6211298905E+00, 9.8264681181E-01],
	[4.1220000000E+04, 3.9046448444E+01, 4.6651768398E+00, 2.7646792146E+01, 3.6214140168E+00, 9.8265551348E-01],
	[4.1225000000E+04, 3.9054810890E+01, 4.6652132231E+00, 2.7657880691E+01, 3.6216980615E+00, 9.8266421034E-01],
	[4.1230000000E+04, 3.9063174112E+01, 4.6652496023E+00, 2.7668972338E+01, 3.6219820244E+00, 9.8267290240E-01],
	[4.1235000000E+04, 3.9071538111E+01, 4.6652859773E+00, 2.7680067087E+01, 3.6222659056E+00, 9.8268158967E-01],
	[4.1240000000E+04, 3.9079902886E+01, 4.6653223482E+00, 2.7691164938E+01, 3.6225497051E+00, 9.8269027214E-01],
	[4.1245000000E+04, 3.9088268437E+01, 4.6653587149E+00, 2.7702265893E+01, 3.6228334229E+00, 9.8269894981E-01],
	[4.1250000000E+04, 3.9096634765E+01, 4.6653950776E+00, 2.7713369951E+01, 3.6231170592E+00, 9.8270762270E-01],
	[4.1255000000E+04, 3.9105001869E+01, 4.6654314361E+00, 2.7724477113E+01, 3.6234006138E+00, 9.8271629080E-01],
	[4.1260000000E+04, 3.9113369749E+01, 4.6654677905E+00, 2.7735587380E+01, 3.6236840869E+00, 9.8272495411E-01],
	[4.1265000000E+04, 3.9121738406E+01, 4.6655041408E+00, 2.7746700751E+01, 3.6239674785E+00, 9.8273361265E-01],
	[4.1270000000E+04, 3.9130107839E+01, 4.6655404870E+00, 2.7757817228E+01, 3.6242507885E+00, 9.8274226641E-01],
	[4.1275000000E+04, 3.9138478048E+01, 4.6655768290E+00, 2.7768936812E+01, 3.6245340171E+00, 9.8275091539E-01],
	[4.1280000000E+04, 3.9146849033E+01, 4.6656131669E+00, 2.7780059501E+01, 3.6248171642E+00, 9.8275955960E-01],
	[4.1285000000E+04, 3.9155220795E+01, 4.6656495007E+00, 2.7791185298E+01, 3.6251002298E+00, 9.8276819903E-01],
	[4.1290000000E+04, 3.9163593333E+01, 4.6656858304E+00, 2.7802314202E+01, 3.6253832141E+00, 9.8277683371E-01],
	[4.1295000000E+04, 3.9171966647E+01, 4.6657221560E+00, 2.7813446215E+01, 3.6256661169E+00, 9.8278546362E-01],
	[4.1300000000E+04, 3.9180340737E+01, 4.6657584774E+00, 2.7824581336E+01, 3.6259489384E+00, 9.8279408876E-01],
	[4.1305000000E+04, 3.9188715603E+01, 4.6657947947E+00, 2.7835719565E+01, 3.6262316786E+00, 9.8280270915E-01],
	[4.1310000000E+04, 3.9197091245E+01, 4.6658311080E+00, 2.7846860904E+01, 3.6265143375E+00, 9.8281132479E-01],
	[4.1315000000E+04, 3.9205467664E+01, 4.6658674171E+00, 2.7858005354E+01, 3.6267969151E+00, 9.8281993567E-01],
	[4.1320000000E+04, 3.9213844858E+01, 4.6659037221E+00, 2.7869152913E+01, 3.6270794115E+00, 9.8282854180E-01],
	[4.1325000000E+04, 3.9222222829E+01, 4.6659400230E+00, 2.7880303584E+01, 3.6273618266E+00, 9.8283714318E-01],
	[4.1330000000E+04, 3.9230601575E+01, 4.6659763197E+00, 2.7891457366E+01, 3.6276441606E+00, 9.8284573983E-01],
	[4.1335000000E+04, 3.9238981098E+01, 4.6660126124E+00, 2.7902614260E+01, 3.6279264134E+00, 9.8285433173E-01],
	[4.1340000000E+04, 3.9247361396E+01, 4.6660489010E+00, 2.7913774266E+01, 3.6282085850E+00, 9.8286291889E-01],
	[4.1345000000E+04, 3.9255742470E+01, 4.6660851854E+00, 2.7924937385E+01, 3.6284906755E+00, 9.8287150131E-01],
	[4.1350000000E+04, 3.9264124321E+01, 4.6661214658E+00, 2.7936103618E+01, 3.6287726850E+00, 9.8288007901E-01],
	[4.1355000000E+04, 3.9272506947E+01, 4.6661577420E+00, 2.7947272964E+01, 3.6290546134E+00, 9.8288865197E-01],
	[4.1360000000E+04, 3.9280890349E+01, 4.6661940142E+00, 2.7958445425E+01, 3.6293364607E+00, 9.8289722021E-01],
	[4.1365000000E+04, 3.9289274527E+01, 4.6662302822E+00, 2.7969621001E+01, 3.6296182270E+00, 9.8290578372E-01],
	[4.1370000000E+04, 3.9297659481E+01, 4.6662665462E+00, 2.7980799692E+01, 3.6298999124E+00, 9.8291434251E-01],
	[4.1375000000E+04, 3.9306045210E+01, 4.6663028060E+00, 2.7991981499E+01, 3.6301815168E+00, 9.8292289659E-01],
	[4.1380000000E+04, 3.9314431716E+01, 4.6663390617E+00, 2.8003166422E+01, 3.6304630403E+00, 9.8293144595E-01],
	[4.1385000000E+04, 3.9322818997E+01, 4.6663753134E+00, 2.8014354463E+01, 3.6307444828E+00, 9.8293999059E-01],
	[4.1390000000E+04, 3.9331207053E+01, 4.6664115609E+00, 2.8025545620E+01, 3.6310258445E+00, 9.8294853053E-01],
	[4.1395000000E+04, 3.9339595886E+01, 4.6664478044E+00, 2.8036739895E+01, 3.6313071254E+00, 9.8295706576E-01],
	[4.1400000000E+04, 3.9347985494E+01, 4.6664840437E+00, 2.8047937289E+01, 3.6315883254E+00, 9.8296559628E-01],
	[4.1405000000E+04, 3.9356375878E+01, 4.6665202790E+00, 2.8059137802E+01, 3.6318694446E+00, 9.8297412210E-01],
	[4.1410000000E+04, 3.9364767038E+01, 4.6665565101E+00, 2.8070341433E+01, 3.6321504831E+00, 9.8298264323E-01],
	[4.1415000000E+04, 3.9373158973E+01, 4.6665927372E+00, 2.8081548185E+01, 3.6324314408E+00, 9.8299115966E-01],
	[4.1420000000E+04, 3.9381551684E+01, 4.6666289601E+00, 2.8092758057E+01, 3.6327123178E+00, 9.8299967139E-01],
	[4.1425000000E+04, 3.9389945170E+01, 4.6666651790E+00, 2.8103971049E+01, 3.6329931141E+00, 9.8300817844E-01],
	[4.1430000000E+04, 3.9398339432E+01, 4.6667013938E+00, 2.8115187163E+01, 3.6332738297E+00, 9.8301668080E-01],
	[4.1435000000E+04, 3.9406734470E+01, 4.6667376045E+00, 2.8126406399E+01, 3.6335544647E+00, 9.8302517847E-01],
	[4.1440000000E+04, 3.9415130283E+01, 4.6667738111E+00, 2.8137628757E+01, 3.6338350191E+00, 9.8303367147E-01],
	[4.1445000000E+04, 3.9423526872E+01, 4.6668100137E+00, 2.8148854237E+01, 3.6341154929E+00, 9.8304215978E-01],
	[4.1450000000E+04, 3.9431924236E+01, 4.6668462121E+00, 2.8160082841E+01, 3.6343958862E+00, 9.8305064342E-01],
	[4.1455000000E+04, 3.9440322375E+01, 4.6668824065E+00, 2.8171314569E+01, 3.6346761989E+00, 9.8305912238E-01],
	[4.1460000000E+04, 3.9448721290E+01, 4.6669185967E+00, 2.8182549421E+01, 3.6349564311E+00, 9.8306759668E-01],
	[4.1465000000E+04, 3.9457120980E+01, 4.6669547829E+00, 2.8193787397E+01, 3.6352365828E+00, 9.8307606631E-01],
	[4.1470000000E+04, 3.9465521446E+01, 4.6669909650E+00, 2.8205028499E+01, 3.6355166541E+00, 9.8308453127E-01],
	[4.1475000000E+04, 3.9473922687E+01, 4.6670271430E+00, 2.8216272726E+01, 3.6357966450E+00, 9.8309299157E-01],
	[4.1480000000E+04, 3.9482324704E+01, 4.6670633170E+00, 2.8227520080E+01, 3.6360765554E+00, 9.8310144721E-01],
	[4.1485000000E+04, 3.9490727496E+01, 4.6670994868E+00, 2.8238770560E+01, 3.6363563855E+00, 9.8310989820E-01],
	[4.1490000000E+04, 3.9499131063E+01, 4.6671356526E+00, 2.8250024168E+01, 3.6366361352E+00, 9.8311834453E-01],
	[4.1495000000E+04, 3.9507535405E+01, 4.6671718143E+00, 2.8261280903E+01, 3.6369158047E+00, 9.8312678622E-01],
	[4.1500000000E+04, 3.9515940523E+01, 4.6672079720E+00, 2.8272540766E+01, 3.6371953938E+00, 9.8313522325E-01],
	[4.1505000000E+04, 3.9524346416E+01, 4.6672441255E+00, 2.8283803758E+01, 3.6374749026E+00, 9.8314365564E-01],
	[4.1510000000E+04, 3.9532753084E+01, 4.6672802750E+00, 2.8295069879E+01, 3.6377543313E+00, 9.8315208339E-01],
	[4.1515000000E+04, 3.9541160527E+01, 4.6673164204E+00, 2.8306339130E+01, 3.6380336797E+00, 9.8316050650E-01],
	[4.1520000000E+04, 3.9549568745E+01, 4.6673525617E+00, 2.8317611511E+01, 3.6383129479E+00, 9.8316892497E-01],
	[4.1525000000E+04, 3.9557977739E+01, 4.6673886990E+00, 2.8328887022E+01, 3.6385921359E+00, 9.8317733881E-01],
	[4.1530000000E+04, 3.9566387508E+01, 4.6674248322E+00, 2.8340165665E+01, 3.6388712438E+00, 9.8318574802E-01],
	[4.1535000000E+04, 3.9574798052E+01, 4.6674609613E+00, 2.8351447439E+01, 3.6391502716E+00, 9.8319415260E-01],
	[4.1540000000E+04, 3.9583209370E+01, 4.6674970863E+00, 2.8362732345E+01, 3.6394292193E+00, 9.8320255255E-01],
	[4.1545000000E+04, 3.9591621464E+01, 4.6675332073E+00, 2.8374020384E+01, 3.6397080870E+00, 9.8321094789E-01],
	[4.1550000000E+04, 3.9600034334E+01, 4.6675693242E+00, 2.8385311556E+01, 3.6399868746E+00, 9.8321933860E-01],
	[4.1555000000E+04, 3.9608447978E+01, 4.6676054370E+00, 2.8396605862E+01, 3.6402655823E+00, 9.8322772470E-01],
	[4.1560000000E+04, 3.9616862397E+01, 4.6676415458E+00, 2.8407903301E+01, 3.6405442099E+00, 9.8323610618E-01],
	[4.1565000000E+04, 3.9625277591E+01, 4.6676776505E+00, 2.8419203875E+01, 3.6408227576E+00, 9.8324448305E-01],
	[4.1570000000E+04, 3.9633693560E+01, 4.6677137512E+00, 2.8430507584E+01, 3.6411012254E+00, 9.8325285531E-01],
	[4.1575000000E+04, 3.9642110304E+01, 4.6677498478E+00, 2.8441814429E+01, 3.6413796133E+00, 9.8326122297E-01],
	[4.1580000000E+04, 3.9650527822E+01, 4.6677859403E+00, 2.8453124410E+01, 3.6416579213E+00, 9.8326958602E-01],
	[4.1585000000E+04, 3.9658946116E+01, 4.6678220288E+00, 2.8464437527E+01, 3.6419361494E+00, 9.8327794448E-01],
	[4.1590000000E+04, 3.9667365185E+01, 4.6678581132E+00, 2.8475753782E+01, 3.6422142977E+00, 9.8328629833E-01],
	[4.1595000000E+04, 3.9675785028E+01, 4.6678941935E+00, 2.8487073173E+01, 3.6424923663E+00, 9.8329464760E-01],
	[4.1600000000E+04, 3.9684205646E+01, 4.6679302698E+00, 2.8498395703E+01, 3.6427703551E+00, 9.8330299227E-01],
	[4.1605000000E+04, 3.9692627039E+01, 4.6679663420E+00, 2.8509721371E+01, 3.6430482641E+00, 9.8331133235E-01],
	[4.1610000000E+04, 3.9701049207E+01, 4.6680024102E+00, 2.8521050179E+01, 3.6433260934E+00, 9.8331966785E-01],
	[4.1615000000E+04, 3.9709472150E+01, 4.6680384743E+00, 2.8532382125E+01, 3.6436038430E+00, 9.8332799876E-01],
	[4.1620000000E+04, 3.9717895867E+01, 4.6680745344E+00, 2.8543717212E+01, 3.6438815130E+00, 9.8333632510E-01],
	[4.1625000000E+04, 3.9726320359E+01, 4.6681105904E+00, 2.8555055439E+01, 3.6441591033E+00, 9.8334464685E-01],
	[4.1630000000E+04, 3.9734745626E+01, 4.6681466424E+00, 2.8566396808E+01, 3.6444366140E+00, 9.8335296403E-01],
	[4.1635000000E+04, 3.9743171667E+01, 4.6681826903E+00, 2.8577741317E+01, 3.6447140452E+00, 9.8336127664E-01],
	[4.1640000000E+04, 3.9751598483E+01, 4.6682187341E+00, 2.8589088969E+01, 3.6449913967E+00, 9.8336958468E-01],
	[4.1645000000E+04, 3.9760026074E+01, 4.6682547739E+00, 2.8600439763E+01, 3.6452686688E+00, 9.8337788815E-01],
	[4.1650000000E+04, 3.9768454439E+01, 4.6682908097E+00, 2.8611793700E+01, 3.6455458613E+00, 9.8338618706E-01],
	[4.1655000000E+04, 3.9776883579E+01, 4.6683268414E+00, 2.8623150780E+01, 3.6458229743E+00, 9.8339448141E-01],
	[4.1660000000E+04, 3.9785313494E+01, 4.6683628691E+00, 2.8634511004E+01, 3.6461000079E+00, 9.8340277120E-01],
	[4.1665000000E+04, 3.9793744183E+01, 4.6683988927E+00, 2.8645874373E+01, 3.6463769621E+00, 9.8341105644E-01],
	[4.1670000000E+04, 3.9802175646E+01, 4.6684349123E+00, 2.8657240887E+01, 3.6466538369E+00, 9.8341933712E-01],
	[4.1675000000E+04, 3.9810607884E+01, 4.6684709278E+00, 2.8668610546E+01, 3.6469306323E+00, 9.8342761325E-01],
	[4.1680000000E+04, 3.9819040896E+01, 4.6685069393E+00, 2.8679983350E+01, 3.6472073483E+00, 9.8343588484E-01],
	[4.1685000000E+04, 3.9827474683E+01, 4.6685429467E+00, 2.8691359302E+01, 3.6474839851E+00, 9.8344415188E-01],
	[4.1690000000E+04, 3.9835909245E+01, 4.6685789501E+00, 2.8702738400E+01, 3.6477605425E+00, 9.8345241438E-01],
	[4.1695000000E+04, 3.9844344580E+01, 4.6686149495E+00, 2.8714120645E+01, 3.6480370206E+00, 9.8346067234E-01],
	[4.1700000000E+04, 3.9852780690E+01, 4.6686509448E+00, 2.8725506038E+01, 3.6483134196E+00, 9.8346892577E-01],
	[4.1705000000E+04, 3.9861217575E+01, 4.6686869361E+00, 2.8736894580E+01, 3.6485897392E+00, 9.8347717466E-01],
	[4.1710000000E+04, 3.9869655234E+01, 4.6687229233E+00, 2.8748286271E+01, 3.6488659797E+00, 9.8348541902E-01],
	[4.1715000000E+04, 3.9878093667E+01, 4.6687589066E+00, 2.8759681111E+01, 3.6491421411E+00, 9.8349365886E-01],
	[4.1720000000E+04, 3.9886532874E+01, 4.6687948857E+00, 2.8771079100E+01, 3.6494182233E+00, 9.8350189417E-01],
	[4.1725000000E+04, 3.9894972856E+01, 4.6688308609E+00, 2.8782480240E+01, 3.6496942264E+00, 9.8351012495E-01],
	[4.1730000000E+04, 3.9903413612E+01, 4.6688668320E+00, 2.8793884531E+01, 3.6499701504E+00, 9.8351835122E-01],
	[4.1735000000E+04, 3.9911855142E+01, 4.6689027991E+00, 2.8805291973E+01, 3.6502459953E+00, 9.8352657297E-01],
	[4.1740000000E+04, 3.9920297447E+01, 4.6689387621E+00, 2.8816702567E+01, 3.6505217612E+00, 9.8353479021E-01],
	[4.1745000000E+04, 3.9928740525E+01, 4.6689747211E+00, 2.8828116313E+01, 3.6507974481E+00, 9.8354300294E-01],
	[4.1750000000E+04, 3.9937184378E+01, 4.6690106761E+00, 2.8839533212E+01, 3.6510730560E+00, 9.8355121116E-01],
	[4.1755000000E+04, 3.9945629005E+01, 4.6690466271E+00, 2.8850953265E+01, 3.6513485849E+00, 9.8355941487E-01],
	[4.1760000000E+04, 3.9954074406E+01, 4.6690825740E+00, 2.8862376471E+01, 3.6516240349E+00, 9.8356761409E-01],
	[4.1765000000E+04, 3.9962520581E+01, 4.6691185169E+00, 2.8873802831E+01, 3.6518994060E+00, 9.8357580880E-01],
	[4.1770000000E+04, 3.9970967531E+01, 4.6691544558E+00, 2.8885232346E+01, 3.6521746983E+00, 9.8358399901E-01],
	[4.1775000000E+04, 3.9979415254E+01, 4.6691903906E+00, 2.8896665017E+01, 3.6524499116E+00, 9.8359218473E-01],
	[4.1780000000E+04, 3.9987863751E+01, 4.6692263214E+00, 2.8908100843E+01, 3.6527250462E+00, 9.8360036596E-01],
	[4.1785000000E+04, 3.9996313023E+01, 4.6692622482E+00, 2.8919539825E+01, 3.6530001019E+00, 9.8360854270E-01],
	[4.1790000000E+04, 4.0004763068E+01, 4.6692981710E+00, 2.8930981964E+01, 3.6532750789E+00, 9.8361671495E-01],
	[4.1795000000E+04, 4.0013213887E+01, 4.6693340898E+00, 2.8942427260E+01, 3.6535499771E+00, 9.8362488272E-01],
	[4.1800000000E+04, 4.0021665481E+01, 4.6693700045E+00, 2.8953875714E+01, 3.6538247966E+00, 9.8363304601E-01],
	[4.1805000000E+04, 4.0030117848E+01, 4.6694059152E+00, 2.8965327327E+01, 3.6540995374E+00, 9.8364120482E-01],
	[4.1810000000E+04, 4.0038570989E+01, 4.6694418219E+00, 2.8976782097E+01, 3.6543741995E+00, 9.8364935916E-01],
	[4.1815000000E+04, 4.0047024904E+01, 4.6694777246E+00, 2.8988240028E+01, 3.6546487830E+00, 9.8365750902E-01],
	[4.1820000000E+04, 4.0055479593E+01, 4.6695136233E+00, 2.8999701117E+01, 3.6549232879E+00, 9.8366565442E-01],
	[4.1825000000E+04, 4.0063935056E+01, 4.6695495179E+00, 2.9011165367E+01, 3.6551977141E+00, 9.8367379535E-01],
	[4.1830000000E+04, 4.0072408904E+01, 4.6695871778E+00, 2.9022632778E+01, 3.6554732926E+00, 9.8368193181E-01],
	[4.1835000000E+04, 4.0080883652E+01, 4.6696248454E+00, 2.9034103350E+01, 3.6557488010E+00, 9.8369006381E-01],
	[4.1840000000E+04, 4.0089359179E+01, 4.6696625089E+00, 2.9045577083E+01, 3.6560242310E+00, 9.8369819135E-01],
	[4.1845000000E+04, 4.0097835484E+01, 4.6697001681E+00, 2.9057053979E+01, 3.6562995827E+00, 9.8370631444E-01],
	[4.1850000000E+04, 4.0106312569E+01, 4.6697378232E+00, 2.9068534038E+01, 3.6565748561E+00, 9.8371443308E-01],
	[4.1855000000E+04, 4.0114790433E+01, 4.6697754741E+00, 2.9080017259E+01, 3.6568500512E+00, 9.8372254726E-01],
	[4.1860000000E+04, 4.0123269077E+01, 4.6698131208E+00, 2.9091503644E+01, 3.6571251680E+00, 9.8373065700E-01],
	[4.1865000000E+04, 4.0131748499E+01, 4.6698507632E+00, 2.9102993193E+01, 3.6574002066E+00, 9.8373876229E-01],
	[4.1870000000E+04, 4.0140228700E+01, 4.6698884015E+00, 2.9114485907E+01, 3.6576751669E+00, 9.8374686314E-01],
	[4.1875000000E+04, 4.0148709680E+01, 4.6699260356E+00, 2.9125981786E+01, 3.6579500491E+00, 9.8375495955E-01],
	[4.1880000000E+04, 4.0157191439E+01, 4.6699636655E+00, 2.9137480831E+01, 3.6582248531E+00, 9.8376305152E-01],
	[4.1885000000E+04, 4.0165673977E+01, 4.6700012913E+00, 2.9148983042E+01, 3.6584995790E+00, 9.8377113906E-01],
	[4.1890000000E+04, 4.0174157294E+01, 4.6700389128E+00, 2.9160488419E+01, 3.6587742267E+00, 9.8377922217E-01],
	[4.1895000000E+04, 4.0182641390E+01, 4.6700765301E+00, 2.9171996963E+01, 3.6590487964E+00, 9.8378730085E-01],
	[4.1900000000E+04, 4.0191126265E+01, 4.6701141433E+00, 2.9183508675E+01, 3.6593232880E+00, 9.8379537510E-01],
	[4.1905000000E+04, 4.0199611919E+01, 4.6701517523E+00, 2.9195023555E+01, 3.6595977015E+00, 9.8380344493E-01],
	[4.1910000000E+04, 4.0208098351E+01, 4.6701893570E+00, 2.9206541604E+01, 3.6598720371E+00, 9.8381151034E-01],
	[4.1915000000E+04, 4.0216585563E+01, 4.6702269577E+00, 2.9218062822E+01, 3.6601462946E+00, 9.8381957134E-01],
	[4.1920000000E+04, 4.0225073553E+01, 4.6702645541E+00, 2.9229587209E+01, 3.6604204742E+00, 9.8382762792E-01],
	[4.1925000000E+04, 4.0233562322E+01, 4.6703021463E+00, 2.9241114766E+01, 3.6606945759E+00, 9.8383568008E-01],
	[4.1930000000E+04, 4.0242051870E+01, 4.6703397344E+00, 2.9252645494E+01, 3.6609685997E+00, 9.8384372784E-01],
	[4.1935000000E+04, 4.0250542196E+01, 4.6703773183E+00, 2.9264179393E+01, 3.6612425456E+00, 9.8385177119E-01],
	[4.1940000000E+04, 4.0259033301E+01, 4.6704148980E+00, 2.9275716464E+01, 3.6615164136E+00, 9.8385981013E-01],
	[4.1945000000E+04, 4.0267525185E+01, 4.6704524735E+00, 2.9287256706E+01, 3.6617902038E+00, 9.8386784468E-01],
	[4.1950000000E+04, 4.0276017848E+01, 4.6704900448E+00, 2.9298800121E+01, 3.6620639162E+00, 9.8387587482E-01],
	[4.1955000000E+04, 4.0284511289E+01, 4.6705276120E+00, 2.9310346709E+01, 3.6623375508E+00, 9.8388390057E-01],
	[4.1960000000E+04, 4.0293005509E+01, 4.6705651750E+00, 2.9321896471E+01, 3.6626111076E+00, 9.8389192193E-01],
	[4.1965000000E+04, 4.0301500507E+01, 4.6706027338E+00, 2.9333449406E+01, 3.6628845867E+00, 9.8389993890E-01],
	[4.1970000000E+04, 4.0309996285E+01, 4.6706402885E+00, 2.9345005516E+01, 3.6631579882E+00, 9.8390795148E-01],
	[4.1975000000E+04, 4.0318492840E+01, 4.6706778390E+00, 2.9356564802E+01, 3.6634313119E+00, 9.8391595967E-01],
	[4.1980000000E+04, 4.0326990174E+01, 4.6707153853E+00, 2.9368127262E+01, 3.6637045580E+00, 9.8392396348E-01],
	[4.1985000000E+04, 4.0335488287E+01, 4.6707529274E+00, 2.9379692899E+01, 3.6639777265E+00, 9.8393196292E-01],
	[4.1990000000E+04, 4.0343987178E+01, 4.6707904654E+00, 2.9391261712E+01, 3.6642508173E+00, 9.8393995797E-01],
	[4.1995000000E+04, 4.0352486848E+01, 4.6708279992E+00, 2.9402833702E+01, 3.6645238306E+00, 9.8394794865E-01],
	[4.2000000000E+04, 4.0360987296E+01, 4.6708655288E+00, 2.9414408869E+01, 3.6647967664E+00, 9.8395593496E-01],
	[4.2005000000E+04, 4.0369488523E+01, 4.6709030543E+00, 2.9425987214E+01, 3.6650696246E+00, 9.8396391690E-01],
	[4.2010000000E+04, 4.0377990528E+01, 4.6709405756E+00, 2.9437568738E+01, 3.6653424053E+00, 9.8397189448E-01],
	[4.2015000000E+04, 4.0386493312E+01, 4.6709780927E+00, 2.9449153441E+01, 3.6656151085E+00, 9.8397986769E-01],
	[4.2020000000E+04, 4.0394996873E+01, 4.6710156057E+00, 2.9460741323E+01, 3.6658877343E+00, 9.8398783654E-01],
	[4.2025000000E+04, 4.0403501214E+01, 4.6710531145E+00, 2.9472332386E+01, 3.6661602827E+00, 9.8399580104E-01],
	[4.2030000000E+04, 4.0412006332E+01, 4.6710906192E+00, 2.9483926628E+01, 3.6664327537E+00, 9.8400376118E-01],
	[4.2035000000E+04, 4.0420512229E+01, 4.6711281197E+00, 2.9495524052E+01, 3.6667051473E+00, 9.8401171696E-01],
	[4.2040000000E+04, 4.0429018904E+01, 4.6711656160E+00, 2.9507124657E+01, 3.6669774636E+00, 9.8401966840E-01],
	[4.2045000000E+04, 4.0437526358E+01, 4.6712031082E+00, 2.9518728443E+01, 3.6672497025E+00, 9.8402761549E-01],
	[4.2050000000E+04, 4.0446034589E+01, 4.6712405962E+00, 2.9530335413E+01, 3.6675218642E+00, 9.8403555823E-01],
	[4.2055000000E+04, 4.0454543599E+01, 4.6712780801E+00, 2.9541945565E+01, 3.6677939486E+00, 9.8404349663E-01],
	[4.2060000000E+04, 4.0463053387E+01, 4.6713155598E+00, 2.9553558900E+01, 3.6680659557E+00, 9.8405143069E-01],
	[4.2065000000E+04, 4.0471563954E+01, 4.6713530353E+00, 2.9565175420E+01, 3.6683378856E+00, 9.8405936041E-01],
	[4.2070000000E+04, 4.0480075298E+01, 4.6713905067E+00, 2.9576795124E+01, 3.6686097384E+00, 9.8406728580E-01],
	[4.2075000000E+04, 4.0488587421E+01, 4.6714279739E+00, 2.9588418012E+01, 3.6688815139E+00, 9.8407520685E-01],
	[4.2080000000E+04, 4.0497100321E+01, 4.6714654370E+00, 2.9600044086E+01, 3.6691532124E+00, 9.8408312357E-01],
	[4.2085000000E+04, 4.0505614000E+01, 4.6715028960E+00, 2.9611673346E+01, 3.6694248337E+00, 9.8409103596E-01],
	[4.2090000000E+04, 4.0514128457E+01, 4.6715403508E+00, 2.9623305792E+01, 3.6696963779E+00, 9.8409894403E-01],
	[4.2095000000E+04, 4.0522643692E+01, 4.6715778014E+00, 2.9634941426E+01, 3.6699678450E+00, 9.8410684777E-01],
	[4.2100000000E+04, 4.0531159705E+01, 4.6716152479E+00, 2.9646580246E+01, 3.6702392352E+00, 9.8411474719E-01],
	[4.2105000000E+04, 4.0539676496E+01, 4.6716526903E+00, 2.9658222254E+01, 3.6705105483E+00, 9.8412264229E-01],
	[4.2110000000E+04, 4.0548194065E+01, 4.6716901285E+00, 2.9669867451E+01, 3.6707817844E+00, 9.8413053307E-01],
	[4.2115000000E+04, 4.0556712412E+01, 4.6717275625E+00, 2.9681515837E+01, 3.6710529435E+00, 9.8413841954E-01],
	[4.2120000000E+04, 4.0565231537E+01, 4.6717649924E+00, 2.9693167411E+01, 3.6713240257E+00, 9.8414630169E-01],
	[4.2125000000E+04, 4.0573751440E+01, 4.6718024182E+00, 2.9704822176E+01, 3.6715950310E+00, 9.8415417954E-01],
	[4.2130000000E+04, 4.0582272121E+01, 4.6718398398E+00, 2.9716480131E+01, 3.6718659594E+00, 9.8416205308E-01],
	[4.2135000000E+04, 4.0590793579E+01, 4.6718772573E+00, 2.9728141277E+01, 3.6721368110E+00, 9.8416992231E-01],
	[4.2140000000E+04, 4.0599315816E+01, 4.6719146707E+00, 2.9739805614E+01, 3.6724075857E+00, 9.8417778724E-01],
	[4.2145000000E+04, 4.0607838830E+01, 4.6719520799E+00, 2.9751473143E+01, 3.6726782836E+00, 9.8418564787E-01],
	[4.2150000000E+04, 4.0616362623E+01, 4.6719894849E+00, 2.9763143864E+01, 3.6729489047E+00, 9.8419350420E-01],
	[4.2155000000E+04, 4.0624887193E+01, 4.6720268859E+00, 2.9774817778E+01, 3.6732194491E+00, 9.8420135624E-01],
	[4.2160000000E+04, 4.0633412540E+01, 4.6720642827E+00, 2.9786494885E+01, 3.6734899167E+00, 9.8420920398E-01],
	[4.2165000000E+04, 4.0641938666E+01, 4.6721016753E+00, 2.9798175186E+01, 3.6737603077E+00, 9.8421704743E-01],
	[4.2170000000E+04, 4.0650465569E+01, 4.6721390639E+00, 2.9809858681E+01, 3.6740306219E+00, 9.8422488660E-01],
	[4.2175000000E+04, 4.0658993250E+01, 4.6721764482E+00, 2.9821545371E+01, 3.6743008595E+00, 9.8423272147E-01],
	[4.2180000000E+04, 4.0667521709E+01, 4.6722138285E+00, 2.9833235256E+01, 3.6745710204E+00, 9.8424055207E-01],
	[4.2185000000E+04, 4.0676050945E+01, 4.6722512046E+00, 2.9844928337E+01, 3.6748411047E+00, 9.8424837838E-01],
	[4.2190000000E+04, 4.0684580959E+01, 4.6722885766E+00, 2.9856624615E+01, 3.6751111125E+00, 9.8425620041E-01],
	[4.2195000000E+04, 4.0693111751E+01, 4.6723259445E+00, 2.9868324089E+01, 3.6753810437E+00, 9.8426401816E-01],
	[4.2200000000E+04, 4.0701643320E+01, 4.6723633082E+00, 2.9880026760E+01, 3.6756508984E+00, 9.8427183164E-01],
	[4.2205000000E+04, 4.0710175667E+01, 4.6724006678E+00, 2.9891732629E+01, 3.6759206765E+00, 9.8427964085E-01],
	[4.2210000000E+04, 4.0718708792E+01, 4.6724380233E+00, 2.9903441696E+01, 3.6761903782E+00, 9.8428744579E-01],
	[4.2215000000E+04, 4.0727242694E+01, 4.6724753747E+00, 2.9915153962E+01, 3.6764600034E+00, 9.8429524646E-01],
	[4.2220000000E+04, 4.0735777373E+01, 4.6725127219E+00, 2.9926869427E+01, 3.6767295522E+00, 9.8430304287E-01],
	[4.2225000000E+04, 4.0744312830E+01, 4.6725500650E+00, 2.9938588092E+01, 3.6769990246E+00, 9.8431083501E-01],
	[4.2230000000E+04, 4.0752849065E+01, 4.6725874040E+00, 2.9950309957E+01, 3.6772684206E+00, 9.8431862289E-01],
	[4.2235000000E+04, 4.0761386077E+01, 4.6726247389E+00, 2.9962035023E+01, 3.6775377402E+00, 9.8432640652E-01],
	[4.2240000000E+04, 4.0769923866E+01, 4.6726620696E+00, 2.9973763290E+01, 3.6778069836E+00, 9.8433418589E-01],
	[4.2245000000E+04, 4.0778462433E+01, 4.6726993962E+00, 2.9985494758E+01, 3.6780761506E+00, 9.8434196100E-01],
	[4.2250000000E+04, 4.0787001777E+01, 4.6727367187E+00, 2.9997229429E+01, 3.6783452413E+00, 9.8434973187E-01],
	[4.2255000000E+04, 4.0795541899E+01, 4.6727740371E+00, 3.0008967303E+01, 3.6786142558E+00, 9.8435749848E-01],
	[4.2260000000E+04, 4.0804082798E+01, 4.6728113514E+00, 3.0020708379E+01, 3.6788831941E+00, 9.8436526085E-01],
	[4.2265000000E+04, 4.0812624474E+01, 4.6728486615E+00, 3.0032452660E+01, 3.6791520561E+00, 9.8437301898E-01],
	[4.2270000000E+04, 4.0821166927E+01, 4.6728859675E+00, 3.0044200144E+01, 3.6794208420E+00, 9.8438077287E-01],
	[4.2275000000E+04, 4.0829710158E+01, 4.6729232695E+00, 3.0055950833E+01, 3.6796895517E+00, 9.8438852251E-01],
	[4.2280000000E+04, 4.0838254167E+01, 4.6729605673E+00, 3.0067704728E+01, 3.6799581853E+00, 9.8439626792E-01],
	[4.2285000000E+04, 4.0846798952E+01, 4.6729978609E+00, 3.0079461828E+01, 3.6802267428E+00, 9.8440400909E-01],
	[4.2290000000E+04, 4.0855344515E+01, 4.6730351505E+00, 3.0091222134E+01, 3.6804952242E+00, 9.8441174604E-01],
	[4.2295000000E+04, 4.0863890855E+01, 4.6730724360E+00, 3.0102985646E+01, 3.6807636296E+00, 9.8441947875E-01],
	[4.2300000000E+04, 4.0872437972E+01, 4.6731097173E+00, 3.0114752366E+01, 3.6810319589E+00, 9.8442720724E-01],
	[4.2305000000E+04, 4.0880985866E+01, 4.6731469946E+00, 3.0126522294E+01, 3.6813002123E+00, 9.8443493150E-01],
	[4.2310000000E+04, 4.0889534537E+01, 4.6731842677E+00, 3.0138295429E+01, 3.6815683896E+00, 9.8444265153E-01],
	[4.2315000000E+04, 4.0898083986E+01, 4.6732215368E+00, 3.0150071774E+01, 3.6818364910E+00, 9.8445036735E-01],
	[4.2320000000E+04, 4.0906634211E+01, 4.6732588017E+00, 3.0161851327E+01, 3.6821045165E+00, 9.8445807895E-01],
	[4.2325000000E+04, 4.0915185214E+01, 4.6732960625E+00, 3.0173634090E+01, 3.6823724661E+00, 9.8446578633E-01],
	[4.2330000000E+04, 4.0923736994E+01, 4.6733333192E+00, 3.0185420063E+01, 3.6826403398E+00, 9.8447348950E-01],
	[4.2335000000E+04, 4.0932289550E+01, 4.6733705718E+00, 3.0197209247E+01, 3.6829081377E+00, 9.8448118846E-01],
	[4.2340000000E+04, 4.0940842884E+01, 4.6734078204E+00, 3.0209001642E+01, 3.6831758597E+00, 9.8448888322E-01],
	[4.2345000000E+04, 4.0949396995E+01, 4.6734450648E+00, 3.0220797248E+01, 3.6834435059E+00, 9.8449657376E-01],
	[4.2350000000E+04, 4.0957951883E+01, 4.6734823051E+00, 3.0232596067E+01, 3.6837110764E+00, 9.8450426010E-01],
	[4.2355000000E+04, 4.0966507547E+01, 4.6735195413E+00, 3.0244398098E+01, 3.6839785711E+00, 9.8451194224E-01],
	[4.2360000000E+04, 4.0975063989E+01, 4.6735567734E+00, 3.0256203342E+01, 3.6842459901E+00, 9.8451962018E-01],
	[4.2365000000E+04, 4.0983621208E+01, 4.6735940014E+00, 3.0268011799E+01, 3.6845133333E+00, 9.8452729393E-01],
	[4.2370000000E+04, 4.0992179203E+01, 4.6736312253E+00, 3.0279823471E+01, 3.6847806009E+00, 9.8453496348E-01],
	[4.2375000000E+04, 4.1000737975E+01, 4.6736684451E+00, 3.0291638357E+01, 3.6850477929E+00, 9.8454262883E-01],
	[4.2380000000E+04, 4.1009297524E+01, 4.6737056608E+00, 3.0303456459E+01, 3.6853149092E+00, 9.8455029000E-01],
	[4.2385000000E+04, 4.1017857850E+01, 4.6737428725E+00, 3.0315277776E+01, 3.6855819499E+00, 9.8455794698E-01],
	[4.2390000000E+04, 4.1026418953E+01, 4.6737800800E+00, 3.0327102309E+01, 3.6858489151E+00, 9.8456559978E-01],
	[4.2395000000E+04, 4.1034980833E+01, 4.6738172835E+00, 3.0338930058E+01, 3.6861158047E+00, 9.8457324839E-01],
	[4.2400000000E+04, 4.1043543489E+01, 4.6738544828E+00, 3.0350761025E+01, 3.6863826188E+00, 9.8458089282E-01],
	[4.2405000000E+04, 4.1052106922E+01, 4.6738916781E+00, 3.0362595209E+01, 3.6866493574E+00, 9.8458853308E-01],
	[4.2410000000E+04, 4.1060671132E+01, 4.6739288692E+00, 3.0374432611E+01, 3.6869160205E+00, 9.8459616916E-01],
	[4.2415000000E+04, 4.1069236119E+01, 4.6739660563E+00, 3.0386273232E+01, 3.6871826081E+00, 9.8460380106E-01],
	[4.2420000000E+04, 4.1077801882E+01, 4.6740032393E+00, 3.0398117071E+01, 3.6874491204E+00, 9.8461142880E-01],
	[4.2425000000E+04, 4.1086368422E+01, 4.6740404182E+00, 3.0409964131E+01, 3.6877155572E+00, 9.8461905236E-01],
	[4.2430000000E+04, 4.1094935738E+01, 4.6740775930E+00, 3.0421814410E+01, 3.6879819187E+00, 9.8462667176E-01],
	[4.2435000000E+04, 4.1103503831E+01, 4.6741147638E+00, 3.0433667910E+01, 3.6882482048E+00, 9.8463428700E-01],
	[4.2440000000E+04, 4.1112072701E+01, 4.6741519304E+00, 3.0445524630E+01, 3.6885144155E+00, 9.8464189807E-01],
	[4.2445000000E+04, 4.1120642347E+01, 4.6741890930E+00, 3.0457384572E+01, 3.6887805510E+00, 9.8464950499E-01],
	[4.2450000000E+04, 4.1129212770E+01, 4.6742262515E+00, 3.0469247737E+01, 3.6890466112E+00, 9.8465710775E-01],
	[4.2455000000E+04, 4.1137783969E+01, 4.6742634059E+00, 3.0481114123E+01, 3.6893125962E+00, 9.8466470635E-01],
	[4.2460000000E+04, 4.1146355945E+01, 4.6743005562E+00, 3.0492983733E+01, 3.6895785059E+00, 9.8467230080E-01],
	[4.2465000000E+04, 4.1154928697E+01, 4.6743377025E+00, 3.0504856566E+01, 3.6898443405E+00, 9.8467989110E-01],
	[4.2470000000E+04, 4.1163502226E+01, 4.6743748447E+00, 3.0516732623E+01, 3.6901100998E+00, 9.8468747726E-01],
	[4.2475000000E+04, 4.1172076531E+01, 4.6744119827E+00, 3.0528611905E+01, 3.6903757841E+00, 9.8469505927E-01],
	[4.2480000000E+04, 4.1180651613E+01, 4.6744491168E+00, 3.0540494411E+01, 3.6906413931E+00, 9.8470263713E-01],
	[4.2485000000E+04, 4.1189227471E+01, 4.6744862467E+00, 3.0552380144E+01, 3.6909069271E+00, 9.8471021086E-01],
	[4.2490000000E+04, 4.1197804106E+01, 4.6745233726E+00, 3.0564269102E+01, 3.6911723860E+00, 9.8471778045E-01],
	[4.2495000000E+04, 4.1206381516E+01, 4.6745604944E+00, 3.0576161286E+01, 3.6914377699E+00, 9.8472534590E-01],
	[4.2500000000E+04, 4.1214965515E+01, 4.6745981830E+00, 3.0588056697E+01, 3.6917034814E+00, 9.8473290722E-01],
	[4.2505000000E+04, 4.1223562200E+01, 4.6746370369E+00, 3.0599955336E+01, 3.6919699430E+00, 9.8474046441E-01],
	[4.2510000000E+04, 4.1232159665E+01, 4.6746758866E+00, 3.0611857203E+01, 3.6922363297E+00, 9.8474801747E-01],
	[4.2515000000E+04, 4.1240757912E+01, 4.6747147320E+00, 3.0623762298E+01, 3.6925026415E+00, 9.8475556640E-01],
	[4.2520000000E+04, 4.1249356941E+01, 4.6747535732E+00, 3.0635670622E+01, 3.6927688786E+00, 9.8476311121E-01],
	[4.2525000000E+04, 4.1257956752E+01, 4.6747924101E+00, 3.0647582176E+01, 3.6930350409E+00, 9.8477065189E-01],
	[4.2530000000E+04, 4.1266557343E+01, 4.6748312428E+00, 3.0659496960E+01, 3.6933011285E+00, 9.8477818846E-01],
	[4.2535000000E+04, 4.1275158717E+01, 4.6748700713E+00, 3.0671414973E+01, 3.6935671413E+00, 9.8478572091E-01],
	[4.2540000000E+04, 4.1283760872E+01, 4.6749088955E+00, 3.0683336218E+01, 3.6938330795E+00, 9.8479324925E-01],
	[4.2545000000E+04, 4.1292363808E+01, 4.6749477155E+00, 3.0695260695E+01, 3.6940989429E+00, 9.8480077347E-01],
	[4.2550000000E+04, 4.1300967525E+01, 4.6749865312E+00, 3.0707188403E+01, 3.6943647318E+00, 9.8480829359E-01],
	[4.2555000000E+04, 4.1309572025E+01, 4.6750253427E+00, 3.0719119343E+01, 3.6946304460E+00, 9.8481580959E-01],
	[4.2560000000E+04, 4.1318177305E+01, 4.6750641499E+00, 3.0731053517E+01, 3.6948960856E+00, 9.8482332149E-01],
	[4.2565000000E+04, 4.1326783367E+01, 4.6751029529E+00, 3.0742990924E+01, 3.6951616506E+00, 9.8483082929E-01],
	[4.2570000000E+04, 4.1335390210E+01, 4.6751417517E+00, 3.0754931564E+01, 3.6954271411E+00, 9.8483833299E-01],
	[4.2575000000E+04, 4.1343997835E+01, 4.6751805463E+00, 3.0766875440E+01, 3.6956925571E+00, 9.8484583259E-01],
	[4.2580000000E+04, 4.1352606240E+01, 4.6752193366E+00, 3.0778822550E+01, 3.6959578986E+00, 9.8485332809E-01],
	[4.2585000000E+04, 4.1361215428E+01, 4.6752581227E+00, 3.0790772895E+01, 3.6962231656E+00, 9.8486081950E-01],
	[4.2590000000E+04, 4.1369825396E+01, 4.6752969045E+00, 3.0802726476E+01, 3.6964883582E+00, 9.8486830681E-01],
	[4.2595000000E+04, 4.1378436146E+01, 4.6753356821E+00, 3.0814683294E+01, 3.6967534763E+00, 9.8487579004E-01],
	[4.2600000000E+04, 4.1387047676E+01, 4.6753744555E+00, 3.0826643349E+01, 3.6970185200E+00, 9.8488326919E-01],
	[4.2605000000E+04, 4.1395659988E+01, 4.6754132247E+00, 3.0838606641E+01, 3.6972834894E+00, 9.8489074424E-01],
	[4.2610000000E+04, 4.1404273082E+01, 4.6754519896E+00, 3.0850573170E+01, 3.6975483844E+00, 9.8489821522E-01],
	[4.2615000000E+04, 4.1412886956E+01, 4.6754907503E+00, 3.0862542938E+01, 3.6978132051E+00, 9.8490568211E-01],
	[4.2620000000E+04, 4.1421501612E+01, 4.6755295068E+00, 3.0874515945E+01, 3.6980779515E+00, 9.8491314493E-01],
	[4.2625000000E+04, 4.1430117048E+01, 4.6755682590E+00, 3.0886492192E+01, 3.6983426236E+00, 9.8492060368E-01],
	[4.2630000000E+04, 4.1438733266E+01, 4.6756070070E+00, 3.0898471678E+01, 3.6986072215E+00, 9.8492805835E-01],
	[4.2635000000E+04, 4.1447350265E+01, 4.6756457508E+00, 3.0910454404E+01, 3.6988717451E+00, 9.8493550895E-01],
	[4.2640000000E+04, 4.1455968045E+01, 4.6756844904E+00, 3.0922440372E+01, 3.6991361946E+00, 9.8494295548E-01],
	[4.2645000000E+04, 4.1464586606E+01, 4.6757232258E+00, 3.0934429581E+01, 3.6994005698E+00, 9.8495039795E-01],
	[4.2650000000E+04, 4.1473205948E+01, 4.6757619569E+00, 3.0946422031E+01, 3.6996648709E+00, 9.8495783635E-01],
	[4.2655000000E+04, 4.1481826070E+01, 4.6758006838E+00, 3.0958417724E+01, 3.6999290979E+00, 9.8496527069E-01],
	[4.2660000000E+04, 4.1490446974E+01, 4.6758394065E+00, 3.0970416660E+01, 3.7001932508E+00, 9.8497270098E-01],
	[4.2665000000E+04, 4.1499068659E+01, 4.6758781250E+00, 3.0982418839E+01, 3.7004573296E+00, 9.8498012721E-01],
	[4.2670000000E+04, 4.1507691125E+01, 4.6759168393E+00, 3.0994424261E+01, 3.7007213344E+00, 9.8498754938E-01],
	[4.2675000000E+04, 4.1516314372E+01, 4.6759555493E+00, 3.1006432929E+01, 3.7009852651E+00, 9.8499496750E-01],
	[4.2680000000E+04, 4.1524938399E+01, 4.6759942552E+00, 3.1018444841E+01, 3.7012491218E+00, 9.8500238157E-01],
	[4.2685000000E+04, 4.1533563208E+01, 4.6760329568E+00, 3.1030459998E+01, 3.7015129045E+00, 9.8500979160E-01],
	[4.2690000000E+04, 4.1542188797E+01, 4.6760716542E+00, 3.1042478401E+01, 3.7017766133E+00, 9.8501719758E-01],
	[4.2695000000E+04, 4.1550815167E+01, 4.6761103474E+00, 3.1054500050E+01, 3.7020402482E+00, 9.8502459952E-01],
	[4.2700000000E+04, 4.1559442318E+01, 4.6761490364E+00, 3.1066524946E+01, 3.7023038091E+00, 9.8503199742E-01],
	[4.2705000000E+04, 4.1568070250E+01, 4.6761877211E+00, 3.1078553090E+01, 3.7025672962E+00, 9.8503939128E-01],
	[4.2710000000E+04, 4.1576698962E+01, 4.6762264017E+00, 3.1090584481E+01, 3.7028307094E+00, 9.8504678110E-01],
	[4.2715000000E+04, 4.1585328455E+01, 4.6762650781E+00, 3.1102619120E+01, 3.7030940487E+00, 9.8505416689E-01],
	[4.2720000000E+04, 4.1593958729E+01, 4.6763037502E+00, 3.1114657009E+01, 3.7033573143E+00, 9.8506154866E-01],
	[4.2725000000E+04, 4.1602589784E+01, 4.6763424182E+00, 3.1126698146E+01, 3.7036205061E+00, 9.8506892639E-01],
	[4.2730000000E+04, 4.1611221619E+01, 4.6763810819E+00, 3.1138742534E+01, 3.7038836241E+00, 9.8507630009E-01],
	[4.2735000000E+04, 4.1619854235E+01, 4.6764197414E+00, 3.1150790171E+01, 3.7041466684E+00, 9.8508366978E-01],
	[4.2740000000E+04, 4.1628487632E+01, 4.6764583968E+00, 3.1162841060E+01, 3.7044096389E+00, 9.8509103544E-01],
	[4.2745000000E+04, 4.1637121809E+01, 4.6764970479E+00, 3.1174895199E+01, 3.7046725358E+00, 9.8509839708E-01],
	[4.2750000000E+04, 4.1645756767E+01, 4.6765356948E+00, 3.1186952591E+01, 3.7049353590E+00, 9.8510575471E-01],
	[4.2755000000E+04, 4.1654392505E+01, 4.6765743375E+00, 3.1199013234E+01, 3.7051981086E+00, 9.8511310832E-01],
	[4.2760000000E+04, 4.1663029024E+01, 4.6766129761E+00, 3.1211077131E+01, 3.7054607846E+00, 9.8512045791E-01],
	[4.2765000000E+04, 4.1671666324E+01, 4.6766516104E+00, 3.1223144281E+01, 3.7057233870E+00, 9.8512780350E-01],
	[4.2770000000E+04, 4.1680304404E+01, 4.6766902405E+00, 3.1235214684E+01, 3.7059859158E+00, 9.8513514508E-01],
	[4.2775000000E+04, 4.1688943264E+01, 4.6767288665E+00, 3.1247288342E+01, 3.7062483711E+00, 9.8514248266E-01],
	[4.2780000000E+04, 4.1697582905E+01, 4.6767674882E+00, 3.1259365254E+01, 3.7065107528E+00, 9.8514981623E-01],
	[4.2785000000E+04, 4.1706223327E+01, 4.6768061057E+00, 3.1271445422E+01, 3.7067730611E+00, 9.8515714580E-01],
	[4.2790000000E+04, 4.1714864529E+01, 4.6768447191E+00, 3.1283528845E+01, 3.7070352959E+00, 9.8516447138E-01],
	[4.2795000000E+04, 4.1723506511E+01, 4.6768833282E+00, 3.1295615525E+01, 3.7072974573E+00, 9.8517179295E-01],
	[4.2800000000E+04, 4.1732149274E+01, 4.6769219332E+00, 3.1307705461E+01, 3.7075595452E+00, 9.8517911054E-01],
	[4.2805000000E+04, 4.1740792817E+01, 4.6769605340E+00, 3.1319798655E+01, 3.7078215598E+00, 9.8518642413E-01],
	[4.2810000000E+04, 4.1749437140E+01, 4.6769991306E+00, 3.1331895106E+01, 3.7080835010E+00, 9.8519373373E-01],
	[4.2815000000E+04, 4.1758082244E+01, 4.6770377230E+00, 3.1343994815E+01, 3.7083453688E+00, 9.8520103935E-01],
	[4.2820000000E+04, 4.1766728128E+01, 4.6770763112E+00, 3.1356097784E+01, 3.7086071633E+00, 9.8520834098E-01],
	[4.2825000000E+04, 4.1775374792E+01, 4.6771148952E+00, 3.1368204011E+01, 3.7088688846E+00, 9.8521563863E-01],
	[4.2830000000E+04, 4.1784022237E+01, 4.6771534750E+00, 3.1380313498E+01, 3.7091305325E+00, 9.8522293230E-01],
	[4.2835000000E+04, 4.1792670462E+01, 4.6771920507E+00, 3.1392426245E+01, 3.7093921072E+00, 9.8523022199E-01],
	[4.2840000000E+04, 4.1801319467E+01, 4.6772306221E+00, 3.1404542253E+01, 3.7096536087E+00, 9.8523750771E-01],
	[4.2845000000E+04, 4.1809969252E+01, 4.6772691894E+00, 3.1416661523E+01, 3.7099150370E+00, 9.8524478945E-01],
	[4.2850000000E+04, 4.1818619818E+01, 4.6773077525E+00, 3.1428784054E+01, 3.7101763921E+00, 9.8525206723E-01],
	[4.2855000000E+04, 4.1827271163E+01, 4.6773463114E+00, 3.1440909847E+01, 3.7104376741E+00, 9.8525934103E-01],
	[4.2860000000E+04, 4.1835923289E+01, 4.6773848662E+00, 3.1453038903E+01, 3.7106988829E+00, 9.8526661087E-01],
	[4.2865000000E+04, 4.1844576195E+01, 4.6774234167E+00, 3.1465171222E+01, 3.7109600186E+00, 9.8527387675E-01],
	[4.2870000000E+04, 4.1853229881E+01, 4.6774619631E+00, 3.1477306804E+01, 3.7112210813E+00, 9.8528113866E-01],
	[4.2875000000E+04, 4.1861884347E+01, 4.6775005053E+00, 3.1489445651E+01, 3.7114820709E+00, 9.8528839662E-01],
	[4.2880000000E+04, 4.1870539593E+01, 4.6775390433E+00, 3.1501587763E+01, 3.7117429875E+00, 9.8529565061E-01],
	[4.2885000000E+04, 4.1879195619E+01, 4.6775775771E+00, 3.1513733140E+01, 3.7120038311E+00, 9.8530290066E-01],
	[4.2890000000E+04, 4.1887852426E+01, 4.6776161068E+00, 3.1525881782E+01, 3.7122646016E+00, 9.8531014675E-01],
	[4.2895000000E+04, 4.1896510012E+01, 4.6776546323E+00, 3.1538033691E+01, 3.7125252993E+00, 9.8531738889E-01],
	[4.2900000000E+04, 4.1905168378E+01, 4.6776931536E+00, 3.1550188866E+01, 3.7127859240E+00, 9.8532462709E-01],
	[4.2905000000E+04, 4.1913827524E+01, 4.6777316708E+00, 3.1562347308E+01, 3.7130464758E+00, 9.8533186133E-01],
	[4.2910000000E+04, 4.1922487450E+01, 4.6777701838E+00, 3.1574509018E+01, 3.7133069547E+00, 9.8533909164E-01],
	[4.2915000000E+04, 4.1931148156E+01, 4.6778086926E+00, 3.1586673997E+01, 3.7135673608E+00, 9.8534631801E-01],
	[4.2920000000E+04, 4.1939809642E+01, 4.6778471972E+00, 3.1598842244E+01, 3.7138276940E+00, 9.8535354043E-01],
	[4.2925000000E+04, 4.1948471908E+01, 4.6778856977E+00, 3.1611013760E+01, 3.7140879544E+00, 9.8536075892E-01],
	[4.2930000000E+04, 4.1957134953E+01, 4.6779241940E+00, 3.1623188545E+01, 3.7143481420E+00, 9.8536797348E-01],
	[4.2935000000E+04, 4.1965798779E+01, 4.6779626861E+00, 3.1635366601E+01, 3.7146082569E+00, 9.8537518410E-01],
	[4.2940000000E+04, 4.1974463384E+01, 4.6780011741E+00, 3.1647547928E+01, 3.7148682990E+00, 9.8538239080E-01],
	[4.2945000000E+04, 4.1983128769E+01, 4.6780396579E+00, 3.1659732525E+01, 3.7151282684E+00, 9.8538959357E-01],
	[4.2950000000E+04, 4.1991794934E+01, 4.6780781375E+00, 3.1671920395E+01, 3.7153881652E+00, 9.8539679242E-01],
	[4.2955000000E+04, 4.2000461879E+01, 4.6781166130E+00, 3.1684111536E+01, 3.7156479892E+00, 9.8540398734E-01],
	[4.2960000000E+04, 4.2009129603E+01, 4.6781550843E+00, 3.1696305950E+01, 3.7159077406E+00, 9.8541117834E-01],
	[4.2965000000E+04, 4.2017798107E+01, 4.6781935515E+00, 3.1708503637E+01, 3.7161674194E+00, 9.8541836542E-01],
	[4.2970000000E+04, 4.2026467391E+01, 4.6782320145E+00, 3.1720704598E+01, 3.7164270256E+00, 9.8542554859E-01],
	[4.2975000000E+04, 4.2035137454E+01, 4.6782704733E+00, 3.1732908833E+01, 3.7166865593E+00, 9.8543272785E-01],
	[4.2980000000E+04, 4.2043808297E+01, 4.6783089280E+00, 3.1745116343E+01, 3.7169460204E+00, 9.8543990320E-01],
	[4.2985000000E+04, 4.2052479920E+01, 4.6783473785E+00, 3.1757327127E+01, 3.7172054090E+00, 9.8544707463E-01],
	[4.2990000000E+04, 4.2061152322E+01, 4.6783858249E+00, 3.1769541188E+01, 3.7174647250E+00, 9.8545424216E-01],
	[4.2995000000E+04, 4.2069825504E+01, 4.6784242671E+00, 3.1781758524E+01, 3.7177239686E+00, 9.8546140579E-01],
	[4.3000000000E+04, 4.2078499465E+01, 4.6784627052E+00, 3.1793979137E+01, 3.7179831398E+00, 9.8546856551E-01],
	[4.3005000000E+04, 4.2087174206E+01, 4.6785011391E+00, 3.1806203027E+01, 3.7182422385E+00, 9.8547572134E-01],
	[4.3010000000E+04, 4.2095849727E+01, 4.6785395688E+00, 3.1818430195E+01, 3.7185012649E+00, 9.8548287327E-01],
	[4.3015000000E+04, 4.2104526027E+01, 4.6785779944E+00, 3.1830660641E+01, 3.7187602188E+00, 9.8549002130E-01],
	[4.3020000000E+04, 4.2113203106E+01, 4.6786164159E+00, 3.1842894366E+01, 3.7190191004E+00, 9.8549716544E-01],
	[4.3025000000E+04, 4.2121880965E+01, 4.6786548332E+00, 3.1855131369E+01, 3.7192779097E+00, 9.8550430569E-01],
	[4.3030000000E+04, 4.2130559603E+01, 4.6786932463E+00, 3.1867371652E+01, 3.7195366467E+00, 9.8551144206E-01],
	[4.3035000000E+04, 4.2139239021E+01, 4.6787316553E+00, 3.1879615216E+01, 3.7197953114E+00, 9.8551857453E-01],
	[4.3040000000E+04, 4.2147919218E+01, 4.6787700602E+00, 3.1891862060E+01, 3.7200539038E+00, 9.8552570313E-01],
	[4.3045000000E+04, 4.2156600195E+01, 4.6788084609E+00, 3.1904112185E+01, 3.7203124241E+00, 9.8553282784E-01],
	[4.3050000000E+04, 4.2165281951E+01, 4.6788468574E+00, 3.1916365591E+01, 3.7205708721E+00, 9.8553994867E-01],
	[4.3055000000E+04, 4.2173964486E+01, 4.6788852499E+00, 3.1928622280E+01, 3.7208292479E+00, 9.8554706563E-01],
	[4.3060000000E+04, 4.2182647801E+01, 4.6789236381E+00, 3.1940882251E+01, 3.7210875516E+00, 9.8555417871E-01],
	[4.3065000000E+04, 4.2191331894E+01, 4.6789620223E+00, 3.1953145506E+01, 3.7213457831E+00, 9.8556128792E-01],
	[4.3070000000E+04, 4.2200016768E+01, 4.6790004022E+00, 3.1965412044E+01, 3.7216039425E+00, 9.8556839327E-01],
	[4.3075000000E+04, 4.2208702420E+01, 4.6790387781E+00, 3.1977681866E+01, 3.7218620298E+00, 9.8557549474E-01],
	[4.3080000000E+04, 4.2217388852E+01, 4.6790771498E+00, 3.1989954972E+01, 3.7221200451E+00, 9.8558259235E-01],
	[4.3085000000E+04, 4.2226076063E+01, 4.6791155174E+00, 3.2002231364E+01, 3.7223779883E+00, 9.8558968609E-01],
	[4.3090000000E+04, 4.2234764053E+01, 4.6791538808E+00, 3.2014511041E+01, 3.7226358595E+00, 9.8559677598E-01],
	[4.3095000000E+04, 4.2243452822E+01, 4.6791922401E+00, 3.2026794004E+01, 3.7228936588E+00, 9.8560386201E-01],
	[4.3100000000E+04, 4.2252142370E+01, 4.6792305953E+00, 3.2039080254E+01, 3.7231513860E+00, 9.8561094418E-01],
	[4.3105000000E+04, 4.2260832698E+01, 4.6792689463E+00, 3.2051369791E+01, 3.7234090413E+00, 9.8561802250E-01],
	[4.3110000000E+04, 4.2269523804E+01, 4.6793072932E+00, 3.2063662616E+01, 3.7236666247E+00, 9.8562509696E-01],
	[4.3115000000E+04, 4.2278215690E+01, 4.6793456360E+00, 3.2075958728E+01, 3.7239241362E+00, 9.8563216758E-01],
	[4.3120000000E+04, 4.2286908355E+01, 4.6793839746E+00, 3.2088258129E+01, 3.7241815759E+00, 9.8563923435E-01],
	[4.3125000000E+04, 4.2295601799E+01, 4.6794223091E+00, 3.2100560820E+01, 3.7244389436E+00, 9.8564629727E-01],
	[4.3130000000E+04, 4.2304296022E+01, 4.6794606394E+00, 3.2112866799E+01, 3.7246962396E+00, 9.8565335635E-01],
	[4.3135000000E+04, 4.2312991024E+01, 4.6794989657E+00, 3.2125176069E+01, 3.7249534638E+00, 9.8566041160E-01],
	[4.3140000000E+04, 4.2321686805E+01, 4.6795372878E+00, 3.2137488630E+01, 3.7252106161E+00, 9.8566746300E-01],
	[4.3145000000E+04, 4.2330383364E+01, 4.6795756058E+00, 3.2149804481E+01, 3.7254676968E+00, 9.8567451057E-01],
	[4.3150000000E+04, 4.2339080703E+01, 4.6796139196E+00, 3.2162123624E+01, 3.7257247057E+00, 9.8568155431E-01],
	[4.3155000000E+04, 4.2347778821E+01, 4.6796522294E+00, 3.2174446059E+01, 3.7259816429E+00, 9.8568859421E-01],
	[4.3160000000E+04, 4.2356477718E+01, 4.6796905350E+00, 3.2186771787E+01, 3.7262385084E+00, 9.8569563029E-01],
	[4.3165000000E+04, 4.2365177393E+01, 4.6797288364E+00, 3.2199100807E+01, 3.7264953023E+00, 9.8570266254E-01],
	[4.3170000000E+04, 4.2373877848E+01, 4.6797671338E+00, 3.2211433121E+01, 3.7267520245E+00, 9.8570969096E-01],
	[4.3175000000E+04, 4.2382579081E+01, 4.6798054270E+00, 3.2223768730E+01, 3.7270086751E+00, 9.8571671556E-01],
	[4.3180000000E+04, 4.2391281093E+01, 4.6798437161E+00, 3.2236107632E+01, 3.7272652542E+00, 9.8572373635E-01],
	[4.3185000000E+04, 4.2399992644E+01, 4.6798828426E+00, 3.2248449830E+01, 3.7275223632E+00, 9.8573075331E-01],
	[4.3190000000E+04, 4.2408713921E+01, 4.6799228238E+00, 3.2260795323E+01, 3.7277800148E+00, 9.8573776646E-01],
	[4.3195000000E+04, 4.2417435981E+01, 4.6799628006E+00, 3.2273144113E+01, 3.7280375950E+00, 9.8574477580E-01],
	[4.3200000000E+04, 4.2426158825E+01, 4.6800027732E+00, 3.2285496199E+01, 3.7282951039E+00, 9.8575178133E-01],
	[4.3205000000E+04, 4.2434882452E+01, 4.6800427415E+00, 3.2297851581E+01, 3.7285525414E+00, 9.8575878305E-01],
	[4.3210000000E+04, 4.2443606864E+01, 4.6800827055E+00, 3.2310210262E+01, 3.7288099075E+00, 9.8576578096E-01],
	[4.3215000000E+04, 4.2452332060E+01, 4.6801226652E+00, 3.2322572240E+01, 3.7290672024E+00, 9.8577277507E-01],
	[4.3220000000E+04, 4.2461058040E+01, 4.6801626206E+00, 3.2334937517E+01, 3.7293244260E+00, 9.8577976537E-01],
	[4.3225000000E+04, 4.2469784803E+01, 4.6802025718E+00, 3.2347306093E+01, 3.7295815783E+00, 9.8578675188E-01],
	[4.3230000000E+04, 4.2478512351E+01, 4.6802425187E+00, 3.2359677969E+01, 3.7298386595E+00, 9.8579373459E-01],
	[4.3235000000E+04, 4.2487240682E+01, 4.6802824612E+00, 3.2372053144E+01, 3.7300956694E+00, 9.8580071351E-01],
	[4.3240000000E+04, 4.2495969797E+01, 4.6803223996E+00, 3.2384431620E+01, 3.7303526081E+00, 9.8580768863E-01],
	[4.3245000000E+04, 4.2504699696E+01, 4.6803623336E+00, 3.2396813397E+01, 3.7306094757E+00, 9.8581465996E-01],
	[4.3250000000E+04, 4.2513430378E+01, 4.6804022634E+00, 3.2409198476E+01, 3.7308662722E+00, 9.8582162751E-01],
	[4.3255000000E+04, 4.2522161845E+01, 4.6804421888E+00, 3.2421586857E+01, 3.7311229975E+00, 9.8582859127E-01],
	[4.3260000000E+04, 4.2530894095E+01, 4.6804821101E+00, 3.2433978540E+01, 3.7313796518E+00, 9.8583555124E-01],
	[4.3265000000E+04, 4.2539627129E+01, 4.6805220270E+00, 3.2446373526E+01, 3.7316362350E+00, 9.8584250744E-01],
	[4.3270000000E+04, 4.2548360946E+01, 4.6805619397E+00, 3.2458771815E+01, 3.7318927471E+00, 9.8584945985E-01],
	[4.3275000000E+04, 4.2557095547E+01, 4.6806018481E+00, 3.2471173409E+01, 3.7321491883E+00, 9.8585640849E-01],
	[4.3280000000E+04, 4.2565830932E+01, 4.6806417522E+00, 3.2483578307E+01, 3.7324055584E+00, 9.8586335335E-01],
	[4.3285000000E+04, 4.2574567100E+01, 4.6806816520E+00, 3.2495986510E+01, 3.7326618576E+00, 9.8587029444E-01],
	[4.3290000000E+04, 4.2583304052E+01, 4.6807215476E+00, 3.2508398019E+01, 3.7329180859E+00, 9.8587723176E-01],
	[4.3295000000E+04, 4.2592041788E+01, 4.6807614389E+00, 3.2520812834E+01, 3.7331742432E+00, 9.8588416532E-01],
	[4.3300000000E+04, 4.2600780307E+01, 4.6808013260E+00, 3.2533230955E+01, 3.7334303296E+00, 9.8589109510E-01],
	[4.3305000000E+04, 4.2609519610E+01, 4.6808412088E+00, 3.2545652383E+01, 3.7336863452E+00, 9.8589802113E-01],
	[4.3310000000E+04, 4.2618259696E+01, 4.6808810873E+00, 3.2558077119E+01, 3.7339422899E+00, 9.8590494339E-01],
	[4.3315000000E+04, 4.2627000565E+01, 4.6809209616E+00, 3.2570505162E+01, 3.7341981638E+00, 9.8591186190E-01],
	[4.3320000000E+04, 4.2635742219E+01, 4.6809608315E+00, 3.2582936514E+01, 3.7344539669E+00, 9.8591877664E-01],
	[4.3325000000E+04, 4.2644484655E+01, 4.6810006973E+00, 3.2595371176E+01, 3.7347096992E+00, 9.8592568764E-01],
	[4.3330000000E+04, 4.2653227875E+01, 4.6810405587E+00, 3.2607809146E+01, 3.7349653608E+00, 9.8593259488E-01],
	[4.3335000000E+04, 4.2661971879E+01, 4.6810804160E+00, 3.2620250427E+01, 3.7352209516E+00, 9.8593949837E-01],
	[4.3340000000E+04, 4.2670716666E+01, 4.6811202689E+00, 3.2632695018E+01, 3.7354764717E+00, 9.8594639811E-01],
	[4.3345000000E+04, 4.2679462236E+01, 4.6811601176E+00, 3.2645142920E+01, 3.7357319211E+00, 9.8595329411E-01],
	[4.3350000000E+04, 4.2688208590E+01, 4.6811999620E+00, 3.2657594133E+01, 3.7359872999E+00, 9.8596018636E-01],
	[4.3355000000E+04, 4.2696955727E+01, 4.6812398022E+00, 3.2670048659E+01, 3.7362426080E+00, 9.8596707488E-01],
	[4.3360000000E+04, 4.2705703647E+01, 4.6812796381E+00, 3.2682506497E+01, 3.7364978456E+00, 9.8597395965E-01],
	[4.3365000000E+04, 4.2714452351E+01, 4.6813194698E+00, 3.2694967648E+01, 3.7367530125E+00, 9.8598084069E-01],
	[4.3370000000E+04, 4.2723201838E+01, 4.6813592972E+00, 3.2707432113E+01, 3.7370081089E+00, 9.8598771800E-01],
	[4.3375000000E+04, 4.2731952108E+01, 4.6813991204E+00, 3.2719899891E+01, 3.7372631347E+00, 9.8599459157E-01],
	[4.3380000000E+04, 4.2740703161E+01, 4.6814389393E+00, 3.2732370984E+01, 3.7375180900E+00, 9.8600146141E-01],
	[4.3385000000E+04, 4.2749454998E+01, 4.6814787540E+00, 3.2744845392E+01, 3.7377729748E+00, 9.8600832753E-01],
	[4.3390000000E+04, 4.2758207618E+01, 4.6815185644E+00, 3.2757323115E+01, 3.7380277891E+00, 9.8601518992E-01],
	[4.3395000000E+04, 4.2766961021E+01, 4.6815583705E+00, 3.2769804155E+01, 3.7382825330E+00, 9.8602204858E-01],
	[4.3400000000E+04, 4.2775715207E+01, 4.6815981725E+00, 3.2782288511E+01, 3.7385372065E+00, 9.8602890353E-01],
	[4.3405000000E+04, 4.2784470176E+01, 4.6816379701E+00, 3.2794776183E+01, 3.7387918096E+00, 9.8603575476E-01],
	[4.3410000000E+04, 4.2793225929E+01, 4.6816777635E+00, 3.2807267174E+01, 3.7390463422E+00, 9.8604260227E-01],
	[4.3415000000E+04, 4.2801982464E+01, 4.6817175527E+00, 3.2819761482E+01, 3.7393008046E+00, 9.8604944607E-01],
	[4.3420000000E+04, 4.2810739783E+01, 4.6817573377E+00, 3.2832259109E+01, 3.7395551966E+00, 9.8605628615E-01],
	[4.3425000000E+04, 4.2819497885E+01, 4.6817971184E+00, 3.2844760055E+01, 3.7398095183E+00, 9.8606312253E-01],
	[4.3430000000E+04, 4.2828256769E+01, 4.6818368948E+00, 3.2857264320E+01, 3.7400637697E+00, 9.8606995520E-01],
	[4.3435000000E+04, 4.2837016437E+01, 4.6818766670E+00, 3.2869771905E+01, 3.7403179508E+00, 9.8607678416E-01],
	[4.3440000000E+04, 4.2845776888E+01, 4.6819164350E+00, 3.2882282811E+01, 3.7405720617E+00, 9.8608360942E-01],
	[4.3445000000E+04, 4.2854538122E+01, 4.6819561987E+00, 3.2894797037E+01, 3.7408261024E+00, 9.8609043098E-01],
	[4.3450000000E+04, 4.2863300138E+01, 4.6819959582E+00, 3.2907314585E+01, 3.7410800729E+00, 9.8609724884E-01],
	[4.3455000000E+04, 4.2872062938E+01, 4.6820357134E+00, 3.2919835455E+01, 3.7413339732E+00, 9.8610406300E-01],
	[4.3460000000E+04, 4.2880826520E+01, 4.6820754645E+00, 3.2932359648E+01, 3.7415878034E+00, 9.8611087347E-01],
	[4.3465000000E+04, 4.2889590886E+01, 4.6821152112E+00, 3.2944887163E+01, 3.7418415635E+00, 9.8611768025E-01],
	[4.3470000000E+04, 4.2898356034E+01, 4.6821549538E+00, 3.2957418002E+01, 3.7420952535E+00, 9.8612448334E-01],
	[4.3475000000E+04, 4.2907121965E+01, 4.6821946921E+00, 3.2969952165E+01, 3.7423488734E+00, 9.8613128274E-01],
	[4.3480000000E+04, 4.2915888679E+01, 4.6822344262E+00, 3.2982489652E+01, 3.7426024232E+00, 9.8613807846E-01],
	[4.3485000000E+04, 4.2924656176E+01, 4.6822741560E+00, 3.2995030465E+01, 3.7428559030E+00, 9.8614487049E-01],
	[4.3490000000E+04, 4.2933424456E+01, 4.6823138816E+00, 3.3007574602E+01, 3.7431093128E+00, 9.8615165884E-01],
	[4.3495000000E+04, 4.2942193518E+01, 4.6823536030E+00, 3.3020122066E+01, 3.7433626527E+00, 9.8615844351E-01],
	[4.3500000000E+04, 4.2950963363E+01, 4.6823933202E+00, 3.3032672856E+01, 3.7436159225E+00, 9.8616522451E-01],
	[4.3505000000E+04, 4.2959733991E+01, 4.6824330331E+00, 3.3045226973E+01, 3.7438691225E+00, 9.8617200183E-01],
	[4.3510000000E+04, 4.2968505402E+01, 4.6824727418E+00, 3.3057784418E+01, 3.7441222525E+00, 9.8617877549E-01],
	[4.3515000000E+04, 4.2977277595E+01, 4.6825124463E+00, 3.3070345191E+01, 3.7443753126E+00, 9.8618554547E-01],
	[4.3520000000E+04, 4.2986050571E+01, 4.6825521465E+00, 3.3082909292E+01, 3.7446283029E+00, 9.8619231178E-01],
	[4.3525000000E+04, 4.2994824330E+01, 4.6825918426E+00, 3.3095476721E+01, 3.7448812233E+00, 9.8619907443E-01],
	[4.3530000000E+04, 4.3003598871E+01, 4.6826315344E+00, 3.3108047481E+01, 3.7451340740E+00, 9.8620583341E-01],
	[4.3535000000E+04, 4.3012374195E+01, 4.6826712219E+00, 3.3120621570E+01, 3.7453868548E+00, 9.8621258874E-01],
	[4.3540000000E+04, 4.3021150302E+01, 4.6827109053E+00, 3.3133198990E+01, 3.7456395658E+00, 9.8621934040E-01],
	[4.3545000000E+04, 4.3029927191E+01, 4.6827505844E+00, 3.3145779741E+01, 3.7458922071E+00, 9.8622608841E-01],
	[4.3550000000E+04, 4.3038704862E+01, 4.6827902593E+00, 3.3158363823E+01, 3.7461447787E+00, 9.8623283277E-01],
	[4.3555000000E+04, 4.3047483316E+01, 4.6828299300E+00, 3.3170951237E+01, 3.7463972806E+00, 9.8623957347E-01],
	[4.3560000000E+04, 4.3056262553E+01, 4.6828695965E+00, 3.3183541984E+01, 3.7466497128E+00, 9.8624631053E-01],
	[4.3565000000E+04, 4.3065042572E+01, 4.6829092588E+00, 3.3196136063E+01, 3.7469020753E+00, 9.8625304393E-01],
	[4.3570000000E+04, 4.3073823374E+01, 4.6829489168E+00, 3.3208733476E+01, 3.7471543683E+00, 9.8625977369E-01],
	[4.3575000000E+04, 4.3082604958E+01, 4.6829885707E+00, 3.3221334223E+01, 3.7474065916E+00, 9.8626649981E-01],
	[4.3580000000E+04, 4.3091387325E+01, 4.6830282203E+00, 3.3233938305E+01, 3.7476587453E+00, 9.8627322228E-01],
	[4.3585000000E+04, 4.3100170474E+01, 4.6830678657E+00, 3.3246545721E+01, 3.7479108294E+00, 9.8627994112E-01],
	[4.3590000000E+04, 4.3108954405E+01, 4.6831075069E+00, 3.3259156473E+01, 3.7481628440E+00, 9.8628665632E-01],
	[4.3595000000E+04, 4.3117739119E+01, 4.6831471439E+00, 3.3271770561E+01, 3.7484147891E+00, 9.8629336789E-01],
	[4.3600000000E+04, 4.3126524615E+01, 4.6831867766E+00, 3.3284387985E+01, 3.7486666648E+00, 9.8630007582E-01],
	[4.3605000000E+04, 4.3135310893E+01, 4.6832264052E+00, 3.3297008746E+01, 3.7489184709E+00, 9.8630678012E-01],
	[4.3610000000E+04, 4.3144097954E+01, 4.6832660296E+00, 3.3309632845E+01, 3.7491702076E+00, 9.8631348080E-01],
	[4.3615000000E+04, 4.3152885797E+01, 4.6833056497E+00, 3.3322260281E+01, 3.7494218749E+00, 9.8632017785E-01],
	[4.3620000000E+04, 4.3161674422E+01, 4.6833452656E+00, 3.3334891056E+01, 3.7496734727E+00, 9.8632687128E-01],
	[4.3625000000E+04, 4.3170463830E+01, 4.6833848774E+00, 3.3347525170E+01, 3.7499250012E+00, 9.8633356108E-01],
	[4.3630000000E+04, 4.3179254020E+01, 4.6834244849E+00, 3.3360162623E+01, 3.7501764604E+00, 9.8634024727E-01],
	[4.3635000000E+04, 4.3188044992E+01, 4.6834640882E+00, 3.3372803417E+01, 3.7504278502E+00, 9.8634692984E-01],
	[4.3640000000E+04, 4.3196836746E+01, 4.6835036874E+00, 3.3385447551E+01, 3.7506791707E+00, 9.8635360879E-01],
	[4.3645000000E+04, 4.3205629282E+01, 4.6835432823E+00, 3.3398095025E+01, 3.7509304219E+00, 9.8636028413E-01],
	[4.3650000000E+04, 4.3214422601E+01, 4.6835828730E+00, 3.3410745841E+01, 3.7511816038E+00, 9.8636695587E-01],
	[4.3655000000E+04, 4.3223216702E+01, 4.6836224595E+00, 3.3423399999E+01, 3.7514327165E+00, 9.8637362399E-01],
	[4.3660000000E+04, 4.3232011584E+01, 4.6836620418E+00, 3.3436057500E+01, 3.7516837601E+00, 9.8638028851E-01],
	[4.3665000000E+04, 4.3240807249E+01, 4.6837016200E+00, 3.3448718343E+01, 3.7519347344E+00, 9.8638694942E-01],
	[4.3670000000E+04, 4.3249603696E+01, 4.6837411939E+00, 3.3461382530E+01, 3.7521856395E+00, 9.8639360674E-01],
	[4.3675000000E+04, 4.3258400925E+01, 4.6837807636E+00, 3.3474050061E+01, 3.7524364755E+00, 9.8640026045E-01],
	[4.3680000000E+04, 4.3267198936E+01, 4.6838203291E+00, 3.3486720937E+01, 3.7526872424E+00, 9.8640691056E-01],
	[4.3685000000E+04, 4.3275997729E+01, 4.6838598905E+00, 3.3499395157E+01, 3.7529379401E+00, 9.8641355709E-01],
	[4.3690000000E+04, 4.3284797305E+01, 4.6838994476E+00, 3.3512072723E+01, 3.7531885688E+00, 9.8642020001E-01],
	[4.3695000000E+04, 4.3293597662E+01, 4.6839390006E+00, 3.3524753634E+01, 3.7534391285E+00, 9.8642683935E-01],
	[4.3700000000E+04, 4.3302398801E+01, 4.6839785493E+00, 3.3537437892E+01, 3.7536896191E+00, 9.8643347510E-01],
	[4.3705000000E+04, 4.3311200722E+01, 4.6840180939E+00, 3.3550125497E+01, 3.7539400407E+00, 9.8644010726E-01],
	[4.3710000000E+04, 4.3320003424E+01, 4.6840576343E+00, 3.3562816450E+01, 3.7541903933E+00, 9.8644673584E-01],
	[4.3715000000E+04, 4.3328806909E+01, 4.6840971705E+00, 3.3575510750E+01, 3.7544406770E+00, 9.8645336084E-01],
	[4.3720000000E+04, 4.3337611176E+01, 4.6841367025E+00, 3.3588208399E+01, 3.7546908917E+00, 9.8645998226E-01],
	[4.3725000000E+04, 4.3346416224E+01, 4.6841762303E+00, 3.3600909397E+01, 3.7549410375E+00, 9.8646660010E-01],
	[4.3730000000E+04, 4.3355222055E+01, 4.6842157539E+00, 3.3613613744E+01, 3.7551911144E+00, 9.8647321436E-01],
	[4.3735000000E+04, 4.3364028667E+01, 4.6842552734E+00, 3.3626321441E+01, 3.7554411225E+00, 9.8647982505E-01],
	[4.3740000000E+04, 4.3372836061E+01, 4.6842947886E+00, 3.3639032489E+01, 3.7556910617E+00, 9.8648643217E-01],
	[4.3745000000E+04, 4.3381644236E+01, 4.6843342997E+00, 3.3651746888E+01, 3.7559409321E+00, 9.8649303572E-01],
	[4.3750000000E+04, 4.3390453194E+01, 4.6843738066E+00, 3.3664464638E+01, 3.7561907336E+00, 9.8649963571E-01],
	[4.3755000000E+04, 4.3399262933E+01, 4.6844133093E+00, 3.3677185740E+01, 3.7564404664E+00, 9.8650623213E-01],
	[4.3760000000E+04, 4.3408073454E+01, 4.6844528078E+00, 3.3689910194E+01, 3.7566901305E+00, 9.8651282498E-01],
	[4.3765000000E+04, 4.3416884757E+01, 4.6844923022E+00, 3.3702638001E+01, 3.7569397258E+00, 9.8651941428E-01],
	[4.3770000000E+04, 4.3425696841E+01, 4.6845317923E+00, 3.3715369162E+01, 3.7571892524E+00, 9.8652600002E-01],
	[4.3775000000E+04, 4.3434509707E+01, 4.6845712783E+00, 3.3728103677E+01, 3.7574387103E+00, 9.8653258220E-01],
	[4.3780000000E+04, 4.3443323354E+01, 4.6846107602E+00, 3.3740841546E+01, 3.7576880996E+00, 9.8653916083E-01],
	[4.3785000000E+04, 4.3452137784E+01, 4.6846502378E+00, 3.3753582770E+01, 3.7579374202E+00, 9.8654573591E-01],
	[4.3790000000E+04, 4.3460952994E+01, 4.6846897113E+00, 3.3766327350E+01, 3.7581866722E+00, 9.8655230744E-01],
	[4.3795000000E+04, 4.3469768987E+01, 4.6847291806E+00, 3.3779075285E+01, 3.7584358556E+00, 9.8655887542E-01],
	[4.3800000000E+04, 4.3478585761E+01, 4.6847686457E+00, 3.3791826577E+01, 3.7586849704E+00, 9.8656543986E-01],
	[4.3805000000E+04, 4.3487403316E+01, 4.6848081066E+00, 3.3804581226E+01, 3.7589340167E+00, 9.8657200075E-01],
	[4.3810000000E+04, 4.3496221653E+01, 4.6848475634E+00, 3.3817339233E+01, 3.7591829945E+00, 9.8657855811E-01],
	[4.3815000000E+04, 4.3505040772E+01, 4.6848870160E+00, 3.3830100597E+01, 3.7594319038E+00, 9.8658511192E-01],
	[4.3820000000E+04, 4.3513860672E+01, 4.6849264644E+00, 3.3842865320E+01, 3.7596807445E+00, 9.8659166220E-01],
	[4.3825000000E+04, 4.3522681353E+01, 4.6849659087E+00, 3.3855633401E+01, 3.7599295169E+00, 9.8659820894E-01],
	[4.3830000000E+04, 4.3531502816E+01, 4.6850053488E+00, 3.3868404843E+01, 3.7601782208E+00, 9.8660475216E-01],
	[4.3835000000E+04, 4.3540325060E+01, 4.6850447847E+00, 3.3881179644E+01, 3.7604268562E+00, 9.8661129184E-01],
	[4.3840000000E+04, 4.3549148086E+01, 4.6850842165E+00, 3.3893957805E+01, 3.7606754233E+00, 9.8661782799E-01],
	[4.3845000000E+04, 4.3557971893E+01, 4.6851236441E+00, 3.3906739328E+01, 3.7609239221E+00, 9.8662436062E-01],
	[4.3850000000E+04, 4.3566796481E+01, 4.6851630675E+00, 3.3919524212E+01, 3.7611723525E+00, 9.8663088973E-01],
	[4.3855000000E+04, 4.3575621851E+01, 4.6852024868E+00, 3.3932312458E+01, 3.7614207145E+00, 9.8663741531E-01],
	[4.3860000000E+04, 4.3584448002E+01, 4.6852419019E+00, 3.3945104066E+01, 3.7616690083E+00, 9.8664393738E-01],
	[4.3865000000E+04, 4.3593274934E+01, 4.6852813128E+00, 3.3957899037E+01, 3.7619172338E+00, 9.8665045592E-01],
	[4.3870000000E+04, 4.3602102648E+01, 4.6853207196E+00, 3.3970697372E+01, 3.7621653910E+00, 9.8665697096E-01],
	[4.3875000000E+04, 4.3610931143E+01, 4.6853601222E+00, 3.3983499071E+01, 3.7624134801E+00, 9.8666348248E-01],
	[4.3880000000E+04, 4.3619768535E+01, 4.6854002831E+00, 3.3996304134E+01, 3.7626620529E+00, 9.8666999049E-01],
	[4.3885000000E+04, 4.3628616281E+01, 4.6854413386E+00, 3.4009112562E+01, 3.7629112086E+00, 9.8667649499E-01],
	[4.3890000000E+04, 4.3637464814E+01, 4.6854823897E+00, 3.4021924356E+01, 3.7631602963E+00, 9.8668299598E-01],
	[4.3895000000E+04, 4.3646314133E+01, 4.6855234366E+00, 3.4034739515E+01, 3.7634093159E+00, 9.8668949348E-01],
	[4.3900000000E+04, 4.3655164238E+01, 4.6855644791E+00, 3.4047558041E+01, 3.7636582675E+00, 9.8669598746E-01],
	[4.3905000000E+04, 4.3664015130E+01, 4.6856055174E+00, 3.4060379934E+01, 3.7639071511E+00, 9.8670247795E-01],
	[4.3910000000E+04, 4.3672866808E+01, 4.6856465513E+00, 3.4073205195E+01, 3.7641559667E+00, 9.8670896495E-01],
	[4.3915000000E+04, 4.3681719272E+01, 4.6856875809E+00, 3.4086033823E+01, 3.7644047145E+00, 9.8671544844E-01],
	[4.3920000000E+04, 4.3690572522E+01, 4.6857286061E+00, 3.4098865820E+01, 3.7646533943E+00, 9.8672192844E-01],
	[4.3925000000E+04, 4.3699426559E+01, 4.6857696271E+00, 3.4111701186E+01, 3.7649020062E+00, 9.8672840495E-01],
	[4.3930000000E+04, 4.3708281382E+01, 4.6858106438E+00, 3.4124539921E+01, 3.7651505502E+00, 9.8673487797E-01],
	[4.3935000000E+04, 4.3717136991E+01, 4.6858516561E+00, 3.4137382026E+01, 3.7653990264E+00, 9.8674134750E-01],
	[4.3940000000E+04, 4.3725993386E+01, 4.6858926642E+00, 3.4150227502E+01, 3.7656474348E+00, 9.8674781355E-01],
	[4.3945000000E+04, 4.3734850567E+01, 4.6859336679E+00, 3.4163076349E+01, 3.7658957754E+00, 9.8675427611E-01],
	[4.3950000000E+04, 4.3743708534E+01, 4.6859746673E+00, 3.4175928567E+01, 3.7661440482E+00, 9.8676073518E-01],
	[4.3955000000E+04, 4.3752567288E+01, 4.6860156625E+00, 3.4188784157E+01, 3.7663922532E+00, 9.8676719078E-01],
	[4.3960000000E+04, 4.3761426827E+01, 4.6860566533E+00, 3.4201643119E+01, 3.7666403905E+00, 9.8677364290E-01],
	[4.3965000000E+04, 4.3770287153E+01, 4.6860976398E+00, 3.4214505455E+01, 3.7668884601E+00, 9.8678009154E-01],
	[4.3970000000E+04, 4.3779148264E+01, 4.6861386220E+00, 3.4227371164E+01, 3.7671364620E+00, 9.8678653670E-01],
	[4.3975000000E+04, 4.3788010162E+01, 4.6861795999E+00, 3.4240240247E+01, 3.7673843963E+00, 9.8679297839E-01],
	[4.3980000000E+04, 4.3796872846E+01, 4.6862205735E+00, 3.4253112704E+01, 3.7676322629E+00, 9.8679941661E-01],
	[4.3985000000E+04, 4.3805736315E+01, 4.6862615428E+00, 3.4265988537E+01, 3.7678800618E+00, 9.8680585136E-01],
	[4.3990000000E+04, 4.3814600571E+01, 4.6863025078E+00, 3.4278867745E+01, 3.7681277932E+00, 9.8681228265E-01],
	[4.3995000000E+04, 4.3823465612E+01, 4.6863434686E+00, 3.4291750328E+01, 3.7683754570E+00, 9.8681871046E-01],
	[4.4000000000E+04, 4.3832331440E+01, 4.6863844250E+00, 3.4304636289E+01, 3.7686230533E+00, 9.8682513482E-01],
	[4.4005000000E+04, 4.3841198053E+01, 4.6864253771E+00, 3.4317525626E+01, 3.7688705820E+00, 9.8683155571E-01],
	[4.4010000000E+04, 4.3850065452E+01, 4.6864663249E+00, 3.4330418341E+01, 3.7691180432E+00, 9.8683797314E-01],
	[4.4015000000E+04, 4.3858933637E+01, 4.6865072685E+00, 3.4343314434E+01, 3.7693654369E+00, 9.8684438711E-01],
	[4.4020000000E+04, 4.3867802608E+01, 4.6865482077E+00, 3.4356213905E+01, 3.7696127632E+00, 9.8685079763E-01],
	[4.4025000000E+04, 4.3876672365E+01, 4.6865891426E+00, 3.4369116755E+01, 3.7698600220E+00, 9.8685720469E-01],
	[4.4030000000E+04, 4.3885542907E+01, 4.6866300733E+00, 3.4382022985E+01, 3.7701072134E+00, 9.8686360831E-01],
	[4.4035000000E+04, 4.3894414236E+01, 4.6866709997E+00, 3.4394932594E+01, 3.7703543374E+00, 9.8687000847E-01],
	[4.4040000000E+04, 4.3903286350E+01, 4.6867119217E+00, 3.4407845585E+01, 3.7706013941E+00, 9.8687640518E-01],
	[4.4045000000E+04, 4.3912159249E+01, 4.6867528395E+00, 3.4420761956E+01, 3.7708483833E+00, 9.8688279844E-01],
	[4.4050000000E+04, 4.3921032935E+01, 4.6867937530E+00, 3.4433681708E+01, 3.7710953053E+00, 9.8688918826E-01],
	[4.4055000000E+04, 4.3929907406E+01, 4.6868346622E+00, 3.4446604843E+01, 3.7713421599E+00, 9.8689557464E-01],
	[4.4060000000E+04, 4.3938782663E+01, 4.6868755672E+00, 3.4459531360E+01, 3.7715889473E+00, 9.8690195757E-01],
	[4.4065000000E+04, 4.3947658705E+01, 4.6869164678E+00, 3.4472461260E+01, 3.7718356674E+00, 9.8690833707E-01],
	[4.4070000000E+04, 4.3956535534E+01, 4.6869573642E+00, 3.4485394544E+01, 3.7720823203E+00, 9.8691471313E-01],
	[4.4075000000E+04, 4.3965413147E+01, 4.6869982563E+00, 3.4498331211E+01, 3.7723289059E+00, 9.8692108575E-01],
	[4.4080000000E+04, 4.3974291547E+01, 4.6870391440E+00, 3.4511271263E+01, 3.7725754244E+00, 9.8692745495E-01],
	[4.4085000000E+04, 4.3983170732E+01, 4.6870800276E+00, 3.4524214700E+01, 3.7728218757E+00, 9.8693382070E-01],
	[4.4090000000E+04, 4.3992050702E+01, 4.6871209068E+00, 3.4537161523E+01, 3.7730682598E+00, 9.8694018303E-01],
	[4.4095000000E+04, 4.4000931458E+01, 4.6871617817E+00, 3.4550111732E+01, 3.7733145768E+00, 9.8694654193E-01],
	[4.4100000000E+04, 4.4009813000E+01, 4.6872026524E+00, 3.4563065327E+01, 3.7735608267E+00, 9.8695289741E-01],
	[4.4105000000E+04, 4.4018695327E+01, 4.6872435188E+00, 3.4576022309E+01, 3.7738070096E+00, 9.8695924946E-01],
	[4.4110000000E+04, 4.4027578440E+01, 4.6872843809E+00, 3.4588982678E+01, 3.7740531253E+00, 9.8696559809E-01],
	[4.4115000000E+04, 4.4036462338E+01, 4.6873252388E+00, 3.4601946436E+01, 3.7742991741E+00, 9.8697194330E-01],
	[4.4120000000E+04, 4.4045347021E+01, 4.6873660924E+00, 3.4614913582E+01, 3.7745451558E+00, 9.8697828509E-01],
	[4.4125000000E+04, 4.4054232490E+01, 4.6874069417E+00, 3.4627884117E+01, 3.7747910705E+00, 9.8698462346E-01],
	[4.4130000000E+04, 4.4063118745E+01, 4.6874477867E+00, 3.4640858042E+01, 3.7750369183E+00, 9.8699095842E-01],
	[4.4135000000E+04, 4.4072005784E+01, 4.6874886274E+00, 3.4653835356E+01, 3.7752826991E+00, 9.8699728997E-01],
	[4.4140000000E+04, 4.4080893609E+01, 4.6875294639E+00, 3.4666816061E+01, 3.7755284129E+00, 9.8700361811E-01],
	[4.4145000000E+04, 4.4089782220E+01, 4.6875702961E+00, 3.4679800157E+01, 3.7757740599E+00, 9.8700994283E-01],
	[4.4150000000E+04, 4.4098671616E+01, 4.6876111241E+00, 3.4692787645E+01, 3.7760196400E+00, 9.8701626415E-01],
	[4.4155000000E+04, 4.4107561797E+01, 4.6876519478E+00, 3.4705778525E+01, 3.7762651533E+00, 9.8702258207E-01],
	[4.4160000000E+04, 4.4116452763E+01, 4.6876927672E+00, 3.4718772797E+01, 3.7765105997E+00, 9.8702889658E-01],
	[4.4165000000E+04, 4.4125344515E+01, 4.6877335823E+00, 3.4731770462E+01, 3.7767559793E+00, 9.8703520769E-01],
	[4.4170000000E+04, 4.4134237052E+01, 4.6877743932E+00, 3.4744771521E+01, 3.7770012921E+00, 9.8704151540E-01],
	[4.4175000000E+04, 4.4143130374E+01, 4.6878151998E+00, 3.4757775973E+01, 3.7772465381E+00, 9.8704781971E-01],
	[4.4180000000E+04, 4.4152024481E+01, 4.6878560022E+00, 3.4770783821E+01, 3.7774917174E+00, 9.8705412063E-01],
	[4.4185000000E+04, 4.4160919374E+01, 4.6878968002E+00, 3.4783795063E+01, 3.7777368299E+00, 9.8706041815E-01],
	[4.4190000000E+04, 4.4169815051E+01, 4.6879375941E+00, 3.4796809701E+01, 3.7779818758E+00, 9.8706671228E-01],
	[4.4195000000E+04, 4.4178711514E+01, 4.6879783836E+00, 3.4809827735E+01, 3.7782268550E+00, 9.8707300302E-01],
	[4.4200000000E+04, 4.4187608762E+01, 4.6880191689E+00, 3.4822849165E+01, 3.7784717675E+00, 9.8707929038E-01],
	[4.4205000000E+04, 4.4196506795E+01, 4.6880599500E+00, 3.4835873992E+01, 3.7787166134E+00, 9.8708557434E-01],
	[4.4210000000E+04, 4.4205405613E+01, 4.6881007268E+00, 3.4848902217E+01, 3.7789613927E+00, 9.8709185493E-01],
	[4.4215000000E+04, 4.4214305217E+01, 4.6881414993E+00, 3.4861933840E+01, 3.7792061054E+00, 9.8709813213E-01],
	[4.4220000000E+04, 4.4223205605E+01, 4.6881822676E+00, 3.4874968862E+01, 3.7794507515E+00, 9.8710440594E-01],
	[4.4225000000E+04, 4.4232106778E+01, 4.6882230316E+00, 3.4888007282E+01, 3.7796953310E+00, 9.8711067638E-01],
	[4.4230000000E+04, 4.4241008737E+01, 4.6882637914E+00, 3.4901049102E+01, 3.7799398441E+00, 9.8711694345E-01],
	[4.4235000000E+04, 4.4249911480E+01, 4.6883045469E+00, 3.4914094322E+01, 3.7801842906E+00, 9.8712320714E-01],
	[4.4240000000E+04, 4.4258815008E+01, 4.6883452982E+00, 3.4927142943E+01, 3.7804286707E+00, 9.8712946745E-01],
	[4.4245000000E+04, 4.4267719322E+01, 4.6883860452E+00, 3.4940194965E+01, 3.7806729843E+00, 9.8713572440E-01],
	[4.4250000000E+04, 4.4276624420E+01, 4.6884267879E+00, 3.4953250388E+01, 3.7809172315E+00, 9.8714197797E-01],
	[4.4255000000E+04, 4.4285530303E+01, 4.6884675265E+00, 3.4966309213E+01, 3.7811614122E+00, 9.8714822818E-01],
	[4.4260000000E+04, 4.4294436971E+01, 4.6885082607E+00, 3.4979371441E+01, 3.7814055266E+00, 9.8715447502E-01],
	[4.4265000000E+04, 4.4303344424E+01, 4.6885489907E+00, 3.4992437072E+01, 3.7816495746E+00, 9.8716071850E-01],
	[4.4270000000E+04, 4.4312252662E+01, 4.6885897165E+00, 3.5005506106E+01, 3.7818935563E+00, 9.8716695861E-01],
	[4.4275000000E+04, 4.4321161685E+01, 4.6886304380E+00, 3.5018578545E+01, 3.7821374716E+00, 9.8717319537E-01],
	[4.4280000000E+04, 4.4330071492E+01, 4.6886711553E+00, 3.5031654388E+01, 3.7823813206E+00, 9.8717942877E-01],
	[4.4285000000E+04, 4.4338982084E+01, 4.6887118683E+00, 3.5044733636E+01, 3.7826251034E+00, 9.8718565881E-01],
	[4.4290000000E+04, 4.4347893461E+01, 4.6887525771E+00, 3.5057816290E+01, 3.7828688199E+00, 9.8719188549E-01],
	[4.4295000000E+04, 4.4356805623E+01, 4.6887932817E+00, 3.5070902350E+01, 3.7831124701E+00, 9.8719810883E-01],
	[4.4300000000E+04, 4.4365718570E+01, 4.6888339820E+00, 3.5083991816E+01, 3.7833560542E+00, 9.8720432881E-01],
	[4.4305000000E+04, 4.4374632301E+01, 4.6888746781E+00, 3.5097084689E+01, 3.7835995720E+00, 9.8721054545E-01],
	[4.4310000000E+04, 4.4383546817E+01, 4.6889153699E+00, 3.5110180970E+01, 3.7838430237E+00, 9.8721675874E-01],
	[4.4315000000E+04, 4.4392462118E+01, 4.6889560575E+00, 3.5123280660E+01, 3.7840864092E+00, 9.8722296868E-01],
	[4.4320000000E+04, 4.4401378203E+01, 4.6889967408E+00, 3.5136383757E+01, 3.7843297286E+00, 9.8722917528E-01],
	[4.4325000000E+04, 4.4410295073E+01, 4.6890374200E+00, 3.5149490264E+01, 3.7845729820E+00, 9.8723537854E-01],
	[4.4330000000E+04, 4.4419212727E+01, 4.6890780948E+00, 3.5162600180E+01, 3.7848161692E+00, 9.8724157846E-01],
	[4.4335000000E+04, 4.4428131167E+01, 4.6891187655E+00, 3.5175713507E+01, 3.7850592903E+00, 9.8724777504E-01],
	[4.4340000000E+04, 4.4437050390E+01, 4.6891594319E+00, 3.5188830244E+01, 3.7853023455E+00, 9.8725396829E-01],
	[4.4345000000E+04, 4.4445970399E+01, 4.6892000941E+00, 3.5201950392E+01, 3.7855453346E+00, 9.8726015821E-01],
	[4.4350000000E+04, 4.4454891192E+01, 4.6892407520E+00, 3.5215073951E+01, 3.7857882577E+00, 9.8726634479E-01],
	[4.4355000000E+04, 4.4463812769E+01, 4.6892814057E+00, 3.5228200923E+01, 3.7860311149E+00, 9.8727252804E-01],
	[4.4360000000E+04, 4.4472735131E+01, 4.6893220552E+00, 3.5241331307E+01, 3.7862739061E+00, 9.8727870796E-01],
	[4.4365000000E+04, 4.4481658277E+01, 4.6893627005E+00, 3.5254465105E+01, 3.7865166314E+00, 9.8728488456E-01],
	[4.4370000000E+04, 4.4490582208E+01, 4.6894033415E+00, 3.5267602316E+01, 3.7867592907E+00, 9.8729105783E-01],
	[4.4375000000E+04, 4.4499506924E+01, 4.6894439783E+00, 3.5280742941E+01, 3.7870018842E+00, 9.8729722778E-01],
	[4.4380000000E+04, 4.4508432423E+01, 4.6894846109E+00, 3.5293886981E+01, 3.7872444119E+00, 9.8730339441E-01],
	[4.4385000000E+04, 4.4517358708E+01, 4.6895252392E+00, 3.5307034435E+01, 3.7874868737E+00, 9.8730955773E-01],
	[4.4390000000E+04, 4.4526285776E+01, 4.6895658634E+00, 3.5320185306E+01, 3.7877292696E+00, 9.8731571772E-01],
	[4.4395000000E+04, 4.4535213629E+01, 4.6896064833E+00, 3.5333339593E+01, 3.7879715998E+00, 9.8732187440E-01],
	[4.4400000000E+04, 4.4544142266E+01, 4.6896470989E+00, 3.5346497296E+01, 3.7882138642E+00, 9.8732802777E-01],
	[4.4405000000E+04, 4.4553071688E+01, 4.6896877104E+00, 3.5359658416E+01, 3.7884560629E+00, 9.8733417782E-01],
	[4.4410000000E+04, 4.4562001894E+01, 4.6897283176E+00, 3.5372822954E+01, 3.7886981958E+00, 9.8734032457E-01],
	[4.4415000000E+04, 4.4570932884E+01, 4.6897689207E+00, 3.5385990910E+01, 3.7889402631E+00, 9.8734646801E-01],
	[4.4420000000E+04, 4.4579864659E+01, 4.6898095195E+00, 3.5399162285E+01, 3.7891822646E+00, 9.8735260814E-01],
	[4.4425000000E+04, 4.4588797218E+01, 4.6898501140E+00, 3.5412337078E+01, 3.7894242005E+00, 9.8735874497E-01],
	[4.4430000000E+04, 4.4597730561E+01, 4.6898907044E+00, 3.5425515292E+01, 3.7896660707E+00, 9.8736487850E-01],
	[4.4435000000E+04, 4.4606664688E+01, 4.6899312905E+00, 3.5438696925E+01, 3.7899078753E+00, 9.8737100873E-01],
	[4.4440000000E+04, 4.4615599599E+01, 4.6899718725E+00, 3.5451881979E+01, 3.7901496144E+00, 9.8737713565E-01],
	[4.4445000000E+04, 4.4624535295E+01, 4.6900124502E+00, 3.5465070455E+01, 3.7903912878E+00, 9.8738325929E-01],
	[4.4450000000E+04, 4.4633471775E+01, 4.6900530237E+00, 3.5478262352E+01, 3.7906328957E+00, 9.8738937963E-01],
	[4.4455000000E+04, 4.4642409038E+01, 4.6900935930E+00, 3.5491457671E+01, 3.7908744381E+00, 9.8739549667E-01],
	[4.4460000000E+04, 4.4651347087E+01, 4.6901341580E+00, 3.5504656413E+01, 3.7911159150E+00, 9.8740161043E-01],
	[4.4465000000E+04, 4.4660285919E+01, 4.6901747189E+00, 3.5517858577E+01, 3.7913573263E+00, 9.8740772089E-01],
	[4.4470000000E+04, 4.4669225535E+01, 4.6902152756E+00, 3.5531064166E+01, 3.7915986722E+00, 9.8741382807E-01],
	[4.4475000000E+04, 4.4678165935E+01, 4.6902558280E+00, 3.5544273179E+01, 3.7918399527E+00, 9.8741993197E-01],
	[4.4480000000E+04, 4.4687107119E+01, 4.6902963763E+00, 3.5557485616E+01, 3.7920811677E+00, 9.8742603258E-01],
	[4.4485000000E+04, 4.4696049088E+01, 4.6903369203E+00, 3.5570701478E+01, 3.7923223174E+00, 9.8743212991E-01],
	[4.4490000000E+04, 4.4704991840E+01, 4.6903774601E+00, 3.5583920767E+01, 3.7925634017E+00, 9.8743822396E-01],
	[4.4495000000E+04, 4.4713935376E+01, 4.6904179957E+00, 3.5597143481E+01, 3.7928044206E+00, 9.8744431474E-01],
	[4.4500000000E+04, 4.4722879697E+01, 4.6904585271E+00, 3.5610369622E+01, 3.7930453742E+00, 9.8745040223E-01],
	[4.4505000000E+04, 4.4731824801E+01, 4.6904990544E+00, 3.5623599190E+01, 3.7932862624E+00, 9.8745648646E-01],
	[4.4510000000E+04, 4.4740770689E+01, 4.6905395774E+00, 3.5636832186E+01, 3.7935270854E+00, 9.8746256741E-01],
	[4.4515000000E+04, 4.4749717361E+01, 4.6905800962E+00, 3.5650068610E+01, 3.7937678431E+00, 9.8746864509E-01],
	[4.4520000000E+04, 4.4758664817E+01, 4.6906206108E+00, 3.5663308463E+01, 3.7940085356E+00, 9.8747471950E-01],
	[4.4525000000E+04, 4.4767613057E+01, 4.6906611212E+00, 3.5676551744E+01, 3.7942491628E+00, 9.8748079065E-01],
	[4.4530000000E+04, 4.4776562081E+01, 4.6907016274E+00, 3.5689798456E+01, 3.7944897248E+00, 9.8748685853E-01],
	[4.4535000000E+04, 4.4785511888E+01, 4.6907421294E+00, 3.5703048598E+01, 3.7947302217E+00, 9.8749292315E-01],
	[4.4540000000E+04, 4.4794462479E+01, 4.6907826272E+00, 3.5716302170E+01, 3.7949706534E+00, 9.8749898451E-01],
	[4.4545000000E+04, 4.4803413855E+01, 4.6908231208E+00, 3.5729559174E+01, 3.7952110200E+00, 9.8750504261E-01],
	[4.4550000000E+04, 4.4812366013E+01, 4.6908636102E+00, 3.5742819609E+01, 3.7954513214E+00, 9.8751109745E-01],
	[4.4555000000E+04, 4.4821318956E+01, 4.6909040955E+00, 3.5756083476E+01, 3.7956915577E+00, 9.8751714904E-01],
	[4.4560000000E+04, 4.4830272682E+01, 4.6909445765E+00, 3.5769350777E+01, 3.7959317290E+00, 9.8752319737E-01],
	[4.4565000000E+04, 4.4839227193E+01, 4.6909850533E+00, 3.5782621510E+01, 3.7961718353E+00, 9.8752924246E-01],
	[4.4570000000E+04, 4.4848182486E+01, 4.6910255260E+00, 3.5795895677E+01, 3.7964118765E+00, 9.8753528429E-01],
	[4.4575000000E+04, 4.4857138564E+01, 4.6910659944E+00, 3.5809173278E+01, 3.7966518527E+00, 9.8754132287E-01],
	[4.4580000000E+04, 4.4866095425E+01, 4.6911064587E+00, 3.5822454314E+01, 3.7968917639E+00, 9.8754735821E-01],
	[4.4585000000E+04, 4.4875056332E+01, 4.6911472185E+00, 3.5835738786E+01, 3.7971318298E+00, 9.8755339031E-01],
	[4.4590000000E+04, 4.4884032429E+01, 4.6911892974E+00, 3.5849026693E+01, 3.7973728011E+00, 9.8755941916E-01],
	[4.4595000000E+04, 4.4893009315E+01, 4.6912313720E+00, 3.5862318036E+01, 3.7976137076E+00, 9.8756544477E-01],
	[4.4600000000E+04, 4.4901986990E+01, 4.6912734423E+00, 3.5875612816E+01, 3.7978545492E+00, 9.8757146714E-01],
	[4.4605000000E+04, 4.4910965453E+01, 4.6913155082E+00, 3.5888911033E+01, 3.7980953261E+00, 9.8757748628E-01],
	[4.4610000000E+04, 4.4919944705E+01, 4.6913575698E+00, 3.5902212688E+01, 3.7983360382E+00, 9.8758350218E-01],
	[4.4615000000E+04, 4.4928924746E+01, 4.6913996270E+00, 3.5915517781E+01, 3.7985766856E+00, 9.8758951485E-01],
	[4.4620000000E+04, 4.4937905575E+01, 4.6914416799E+00, 3.5928826313E+01, 3.7988172683E+00, 9.8759552429E-01],
	[4.4625000000E+04, 4.4946887193E+01, 4.6914837285E+00, 3.5942138284E+01, 3.7990577863E+00, 9.8760153050E-01],
	[4.4630000000E+04, 4.4955869599E+01, 4.6915257727E+00, 3.5955453694E+01, 3.7992982396E+00, 9.8760753348E-01],
	[4.4635000000E+04, 4.4964852794E+01, 4.6915678126E+00, 3.5968772545E+01, 3.7995386283E+00, 9.8761353323E-01],
	[4.4640000000E+04, 4.4973836778E+01, 4.6916098482E+00, 3.5982094837E+01, 3.7997789523E+00, 9.8761952977E-01],
	[4.4645000000E+04, 4.4982821549E+01, 4.6916518794E+00, 3.5995420570E+01, 3.8000192117E+00, 9.8762552307E-01],
	[4.4650000000E+04, 4.4991807110E+01, 4.6916939063E+00, 3.6008749745E+01, 3.8002594066E+00, 9.8763151316E-01],
	[4.4655000000E+04, 4.5000793458E+01, 4.6917359289E+00, 3.6022082362E+01, 3.8004995369E+00, 9.8763750004E-01],
	[4.4660000000E+04, 4.5009780596E+01, 4.6917779471E+00, 3.6035418422E+01, 3.8007396026E+00, 9.8764348369E-01],
	[4.4665000000E+04, 4.5018768521E+01, 4.6918199611E+00, 3.6048757925E+01, 3.8009796039E+00, 9.8764946413E-01],
	[4.4670000000E+04, 4.5027757235E+01, 4.6918619707E+00, 3.6062100872E+01, 3.8012195406E+00, 9.8765544136E-01],
	[4.4675000000E+04, 4.5036746738E+01, 4.6919039759E+00, 3.6075447263E+01, 3.8014594129E+00, 9.8766141538E-01],
	[4.4680000000E+04, 4.5045737028E+01, 4.6919459769E+00, 3.6088797099E+01, 3.8016992207E+00, 9.8766738619E-01],
	[4.4685000000E+04, 4.5054728107E+01, 4.6919879735E+00, 3.6102150380E+01, 3.8019389640E+00, 9.8767335379E-01],
	[4.4690000000E+04, 4.5063719975E+01, 4.6920299658E+00, 3.6115507107E+01, 3.8021786430E+00, 9.8767931818E-01],
	[4.4695000000E+04, 4.5072712630E+01, 4.6920719538E+00, 3.6128867281E+01, 3.8024182576E+00, 9.8768527937E-01],
	[4.4700000000E+04, 4.5081706074E+01, 4.6921139374E+00, 3.6142230901E+01, 3.8026578078E+00, 9.8769123737E-01],
	[4.4705000000E+04, 4.5090700306E+01, 4.6921559167E+00, 3.6155597968E+01, 3.8028972936E+00, 9.8769719216E-01],
	[4.4710000000E+04, 4.5099695327E+01, 4.6921978918E+00, 3.6168968483E+01, 3.8031367152E+00, 9.8770314375E-01],
	[4.4715000000E+04, 4.5108691135E+01, 4.6922398625E+00, 3.6182342447E+01, 3.8033760724E+00, 9.8770909215E-01],
	[4.4720000000E+04, 4.5117687732E+01, 4.6922818288E+00, 3.6195719859E+01, 3.8036153654E+00, 9.8771503735E-01],
	[4.4725000000E+04, 4.5126685117E+01, 4.6923237909E+00, 3.6209100720E+01, 3.8038545940E+00, 9.8772097936E-01],
	[4.4730000000E+04, 4.5135683290E+01, 4.6923657486E+00, 3.6222485032E+01, 3.8040937585E+00, 9.8772691818E-01],
	[4.4735000000E+04, 4.5144682252E+01, 4.6924077021E+00, 3.6235872794E+01, 3.8043328587E+00, 9.8773285381E-01],
	[4.4740000000E+04, 4.5153682001E+01, 4.6924496512E+00, 3.6249264006E+01, 3.8045718947E+00, 9.8773878626E-01],
	[4.4745000000E+04, 4.5162682539E+01, 4.6924915960E+00, 3.6262658670E+01, 3.8048108666E+00, 9.8774471552E-01],
	[4.4750000000E+04, 4.5171683864E+01, 4.6925335365E+00, 3.6276056786E+01, 3.8050497743E+00, 9.8775064159E-01],
	[4.4755000000E+04, 4.5180685978E+01, 4.6925754727E+00, 3.6289458354E+01, 3.8052886179E+00, 9.8775656449E-01],
	[4.4760000000E+04, 4.5189688880E+01, 4.6926174045E+00, 3.6302863374E+01, 3.8055273973E+00, 9.8776248421E-01],
	[4.4765000000E+04, 4.5198692569E+01, 4.6926593321E+00, 3.6316271849E+01, 3.8057661127E+00, 9.8776840074E-01],
	[4.4770000000E+04, 4.5207697047E+01, 4.6927012553E+00, 3.6329683777E+01, 3.8060047640E+00, 9.8777431411E-01],
	[4.4775000000E+04, 4.5216702313E+01, 4.6927431743E+00, 3.6343099159E+01, 3.8062433513E+00, 9.8778022430E-01],
	[4.4780000000E+04, 4.5225708367E+01, 4.6927850889E+00, 3.6356517996E+01, 3.8064818745E+00, 9.8778613131E-01],
	[4.4785000000E+04, 4.5234715208E+01, 4.6928269993E+00, 3.6369940289E+01, 3.8067203337E+00, 9.8779203516E-01],
	[4.4790000000E+04, 4.5243722838E+01, 4.6928689053E+00, 3.6383366037E+01, 3.8069587290E+00, 9.8779793584E-01],
	[4.4795000000E+04, 4.5252731255E+01, 4.6929108070E+00, 3.6396795242E+01, 3.8071970603E+00, 9.8780383335E-01],
	[4.4800000000E+04, 4.5261740461E+01, 4.6929527044E+00, 3.6410227903E+01, 3.8074353276E+00, 9.8780972769E-01],
	[4.4805000000E+04, 4.5270750454E+01, 4.6929945976E+00, 3.6423664022E+01, 3.8076735310E+00, 9.8781561888E-01],
	[4.4810000000E+04, 4.5279761235E+01, 4.6930364864E+00, 3.6437103599E+01, 3.8079116706E+00, 9.8782150690E-01],
	[4.4815000000E+04, 4.5288772804E+01, 4.6930783709E+00, 3.6450546634E+01, 3.8081497462E+00, 9.8782739176E-01],
	[4.4820000000E+04, 4.5297785161E+01, 4.6931202511E+00, 3.6463993129E+01, 3.8083877580E+00, 9.8783327347E-01],
	[4.4825000000E+04, 4.5306798305E+01, 4.6931621270E+00, 3.6477443082E+01, 3.8086257060E+00, 9.8783915202E-01],
	[4.4830000000E+04, 4.5315812238E+01, 4.6932039987E+00, 3.6490896495E+01, 3.8088635902E+00, 9.8784502741E-01],
	[4.4835000000E+04, 4.5324826958E+01, 4.6932458660E+00, 3.6504353369E+01, 3.8091014105E+00, 9.8785089966E-01],
	[4.4840000000E+04, 4.5333842466E+01, 4.6932877290E+00, 3.6517813704E+01, 3.8093391671E+00, 9.8785676875E-01],
	[4.4845000000E+04, 4.5342858761E+01, 4.6933295878E+00, 3.6531277500E+01, 3.8095768600E+00, 9.8786263470E-01],
	[4.4850000000E+04, 4.5351875845E+01, 4.6933714422E+00, 3.6544744758E+01, 3.8098144891E+00, 9.8786849750E-01],
	[4.4855000000E+04, 4.5360893716E+01, 4.6934132924E+00, 3.6558215478E+01, 3.8100520545E+00, 9.8787435715E-01],
	[4.4860000000E+04, 4.5369912374E+01, 4.6934551382E+00, 3.6571689662E+01, 3.8102895563E+00, 9.8788021366E-01],
	[4.4865000000E+04, 4.5378931821E+01, 4.6934969798E+00, 3.6585167308E+01, 3.8105269943E+00, 9.8788606704E-01],
	[4.4870000000E+04, 4.5387952055E+01, 4.6935388171E+00, 3.6598648419E+01, 3.8107643688E+00, 9.8789191727E-01],
	[4.4875000000E+04, 4.5396973076E+01, 4.6935806501E+00, 3.6612132994E+01, 3.8110016796E+00, 9.8789776436E-01],
	[4.4880000000E+04, 4.5405994885E+01, 4.6936224788E+00, 3.6625621034E+01, 3.8112389268E+00, 9.8790360832E-01],
	[4.4885000000E+04, 4.5415017482E+01, 4.6936643032E+00, 3.6639112539E+01, 3.8114761104E+00, 9.8790944915E-01],
	[4.4890000000E+04, 4.5424040866E+01, 4.6937061233E+00, 3.6652607511E+01, 3.8117132305E+00, 9.8791528684E-01],
	[4.4895000000E+04, 4.5433065038E+01, 4.6937479392E+00, 3.6666105948E+01, 3.8119502870E+00, 9.8792112140E-01],
	[4.4900000000E+04, 4.5442089997E+01, 4.6937897507E+00, 3.6679607853E+01, 3.8121872801E+00, 9.8792695284E-01],
	[4.4905000000E+04, 4.5451115744E+01, 4.6938315580E+00, 3.6693113225E+01, 3.8124242096E+00, 9.8793278115E-01],
	[4.4910000000E+04, 4.5460142278E+01, 4.6938733610E+00, 3.6706622065E+01, 3.8126610757E+00, 9.8793860633E-01],
	[4.4915000000E+04, 4.5469169600E+01, 4.6939151597E+00, 3.6720134374E+01, 3.8128978783E+00, 9.8794442839E-01],
	[4.4920000000E+04, 4.5478197709E+01, 4.6939569541E+00, 3.6733650151E+01, 3.8131346175E+00, 9.8795024734E-01],
	[4.4925000000E+04, 4.5487226606E+01, 4.6939987443E+00, 3.6747169398E+01, 3.8133712933E+00, 9.8795606316E-01],
	[4.4930000000E+04, 4.5496256290E+01, 4.6940405302E+00, 3.6760692115E+01, 3.8136079057E+00, 9.8796187586E-01],
	[4.4935000000E+04, 4.5505286761E+01, 4.6940823118E+00, 3.6774218303E+01, 3.8138444547E+00, 9.8796768545E-01],
	[4.4940000000E+04, 4.5514318020E+01, 4.6941240891E+00, 3.6787747961E+01, 3.8140809404E+00, 9.8797349193E-01],
	[4.4945000000E+04, 4.5523350066E+01, 4.6941658621E+00, 3.6801281091E+01, 3.8143173627E+00, 9.8797929529E-01],
	[4.4950000000E+04, 4.5532382899E+01, 4.6942076309E+00, 3.6814817693E+01, 3.8145537218E+00, 9.8798509555E-01],
	[4.4955000000E+04, 4.5541416520E+01, 4.6942493954E+00, 3.6828357767E+01, 3.8147900176E+00, 9.8799089269E-01],
	[4.4960000000E+04, 4.5550450928E+01, 4.6942911556E+00, 3.6841901315E+01, 3.8150262501E+00, 9.8799668673E-01],
	[4.4965000000E+04, 4.5559486123E+01, 4.6943329116E+00, 3.6855448335E+01, 3.8152624194E+00, 9.8800247767E-01],
	[4.4970000000E+04, 4.5568522106E+01, 4.6943746632E+00, 3.6868998830E+01, 3.8154985254E+00, 9.8800826550E-01],
	[4.4975000000E+04, 4.5577558875E+01, 4.6944164106E+00, 3.6882552800E+01, 3.8157345683E+00, 9.8801405023E-01],
	[4.4980000000E+04, 4.5586596432E+01, 4.6944581538E+00, 3.6896110244E+01, 3.8159705480E+00, 9.8801983186E-01],
	[4.4985000000E+04, 4.5595634776E+01, 4.6944998927E+00, 3.6909671164E+01, 3.8162064645E+00, 9.8802561040E-01],
	[4.4990000000E+04, 4.5604673908E+01, 4.6945416273E+00, 3.6923235560E+01, 3.8164423179E+00, 9.8803138584E-01],
	[4.4995000000E+04, 4.5613713826E+01, 4.6945833576E+00, 3.6936803432E+01, 3.8166781082E+00, 9.8803715818E-01],
	[4.5000000000E+04, 4.5622754532E+01, 4.6946250837E+00, 3.6950374782E+01, 3.8169138354E+00, 9.8804292744E-01],
	[4.5005000000E+04, 4.5631796024E+01, 4.6946668055E+00, 3.6963967562E+01, 3.8171496910E+00, 9.8804869360E-01],
	[4.5010000000E+04, 4.5640838304E+01, 4.6947085230E+00, 3.6977563831E+01, 3.8173854835E+00, 9.8805445668E-01],
	[4.5015000000E+04, 4.5649881371E+01, 4.6947502363E+00, 3.6991163591E+01, 3.8176212127E+00, 9.8806021667E-01],
	[4.5020000000E+04, 4.5658925225E+01, 4.6947919453E+00, 3.7004766840E+01, 3.8178568789E+00, 9.8806597357E-01],
	[4.5025000000E+04, 4.5667969866E+01, 4.6948336500E+00, 3.7018373580E+01, 3.8180924820E+00, 9.8807172739E-01],
	[4.5030000000E+04, 4.5677015294E+01, 4.6948753505E+00, 3.7031983812E+01, 3.8183280220E+00, 9.8807747813E-01],
	[4.5035000000E+04, 4.5686061509E+01, 4.6949170467E+00, 3.7045597536E+01, 3.8185634989E+00, 9.8808322580E-01],
	[4.5040000000E+04, 4.5695108511E+01, 4.6949587387E+00, 3.7059214752E+01, 3.8187989128E+00, 9.8808897038E-01],
	[4.5045000000E+04, 4.5704156300E+01, 4.6950004264E+00, 3.7072835460E+01, 3.8190342637E+00, 9.8809471189E-01],
	[4.5050000000E+04, 4.5713204876E+01, 4.6950421099E+00, 3.7086459662E+01, 3.8192695515E+00, 9.8810045033E-01],
	[4.5055000000E+04, 4.5722254239E+01, 4.6950837891E+00, 3.7100087358E+01, 3.8195047765E+00, 9.8810618569E-01],
	[4.5060000000E+04, 4.5731304388E+01, 4.6951254640E+00, 3.7113718549E+01, 3.8197399384E+00, 9.8811191798E-01],
	[4.5065000000E+04, 4.5740355325E+01, 4.6951671347E+00, 3.7127353234E+01, 3.8199750375E+00, 9.8811764721E-01],
	[4.5070000000E+04, 4.5749407048E+01, 4.6952088012E+00, 3.7140991415E+01, 3.8202100736E+00, 9.8812337337E-01],
	[4.5075000000E+04, 4.5758459559E+01, 4.6952504633E+00, 3.7154633091E+01, 3.8204450468E+00, 9.8812909646E-01],
	[4.5080000000E+04, 4.5767512856E+01, 4.6952921213E+00, 3.7168278264E+01, 3.8206799572E+00, 9.8813481649E-01],
	[4.5085000000E+04, 4.5776566940E+01, 4.6953337749E+00, 3.7181926934E+01, 3.8209148047E+00, 9.8814053346E-01],
	[4.5090000000E+04, 4.5785621811E+01, 4.6953754244E+00, 3.7195579102E+01, 3.8211495894E+00, 9.8814624737E-01],
	[4.5095000000E+04, 4.5794677468E+01, 4.6954170696E+00, 3.7209234767E+01, 3.8213843113E+00, 9.8815195823E-01],
	[4.5100000000E+04, 4.5803733912E+01, 4.6954587105E+00, 3.7222893930E+01, 3.8216189704E+00, 9.8815766602E-01],
	[4.5105000000E+04, 4.5812791143E+01, 4.6955003472E+00, 3.7236556593E+01, 3.8218535668E+00, 9.8816337077E-01],
	[4.5110000000E+04, 4.5821849161E+01, 4.6955419796E+00, 3.7250222755E+01, 3.8220881004E+00, 9.8816907246E-01],
	[4.5115000000E+04, 4.5830907966E+01, 4.6955836078E+00, 3.7263892417E+01, 3.8223225712E+00, 9.8817477110E-01],
	[4.5120000000E+04, 4.5839967557E+01, 4.6956252318E+00, 3.7277565580E+01, 3.8225569794E+00, 9.8818046669E-01],
	[4.5125000000E+04, 4.5849027935E+01, 4.6956668515E+00, 3.7291242243E+01, 3.8227913249E+00, 9.8818615924E-01],
	[4.5130000000E+04, 4.5858089099E+01, 4.6957084670E+00, 3.7304922409E+01, 3.8230256078E+00, 9.8819184874E-01],
	[4.5135000000E+04, 4.5867151050E+01, 4.6957500782E+00, 3.7318606076E+01, 3.8232598280E+00, 9.8819753520E-01],
	[4.5140000000E+04, 4.5876213788E+01, 4.6957916852E+00, 3.7332293245E+01, 3.8234939856E+00, 9.8820321862E-01],
	[4.5145000000E+04, 4.5885277312E+01, 4.6958332879E+00, 3.7345983918E+01, 3.8237280806E+00, 9.8820889899E-01],
	[4.5150000000E+04, 4.5894341623E+01, 4.6958748864E+00, 3.7359678094E+01, 3.8239621131E+00, 9.8821457633E-01],
	[4.5155000000E+04, 4.5903406720E+01, 4.6959164807E+00, 3.7373375774E+01, 3.8241960829E+00, 9.8822025064E-01],
	[4.5160000000E+04, 4.5912472604E+01, 4.6959580707E+00, 3.7387076959E+01, 3.8244299903E+00, 9.8822592191E-01],
	[4.5165000000E+04, 4.5921539274E+01, 4.6959996565E+00, 3.7400781648E+01, 3.8246638351E+00, 9.8823159014E-01],
	[4.5170000000E+04, 4.5930606731E+01, 4.6960412381E+00, 3.7414489844E+01, 3.8248976175E+00, 9.8823725535E-01],
	[4.5175000000E+04, 4.5939674975E+01, 4.6960828154E+00, 3.7428201545E+01, 3.8251313374E+00, 9.8824291753E-01],
	[4.5180000000E+04, 4.5948744005E+01, 4.6961243885E+00, 3.7441916753E+01, 3.8253649948E+00, 9.8824857668E-01],
	[4.5185000000E+04, 4.5957813821E+01, 4.6961659573E+00, 3.7455635468E+01, 3.8255985898E+00, 9.8825423280E-01],
	[4.5190000000E+04, 4.5966884424E+01, 4.6962075220E+00, 3.7469357691E+01, 3.8258321224E+00, 9.8825988591E-01],
	[4.5195000000E+04, 4.5975955813E+01, 4.6962490824E+00, 3.7483083422E+01, 3.8260655926E+00, 9.8826553599E-01],
	[4.5200000000E+04, 4.5985027988E+01, 4.6962906385E+00, 3.7496812661E+01, 3.8262990005E+00, 9.8827118305E-01],
	[4.5205000000E+04, 4.5994100950E+01, 4.6963321905E+00, 3.7510545409E+01, 3.8265323460E+00, 9.8827682709E-01],
	[4.5210000000E+04, 4.6003174698E+01, 4.6963737382E+00, 3.7524281668E+01, 3.8267656292E+00, 9.8828246812E-01],
	[4.5215000000E+04, 4.6012249233E+01, 4.6964152817E+00, 3.7538021436E+01, 3.8269988501E+00, 9.8828810613E-01],
	[4.5220000000E+04, 4.6021324553E+01, 4.6964568209E+00, 3.7551764715E+01, 3.8272320087E+00, 9.8829374113E-01],
	[4.5225000000E+04, 4.6030400660E+01, 4.6964983560E+00, 3.7565511505E+01, 3.8274651050E+00, 9.8829937312E-01],
	[4.5230000000E+04, 4.6039477554E+01, 4.6965398868E+00, 3.7579261807E+01, 3.8276981392E+00, 9.8830500210E-01],
	[4.5235000000E+04, 4.6048555233E+01, 4.6965814133E+00, 3.7593015620E+01, 3.8279311110E+00, 9.8831062807E-01],
	[4.5240000000E+04, 4.6057633699E+01, 4.6966229357E+00, 3.7606772947E+01, 3.8281640207E+00, 9.8831625104E-01],
	[4.5245000000E+04, 4.6066712951E+01, 4.6966644538E+00, 3.7620533787E+01, 3.8283968683E+00, 9.8832187100E-01],
	[4.5250000000E+04, 4.6075792989E+01, 4.6967059678E+00, 3.7634298140E+01, 3.8286296536E+00, 9.8832748797E-01],
	[4.5255000000E+04, 4.6084873814E+01, 4.6967474774E+00, 3.7648066008E+01, 3.8288623768E+00, 9.8833310193E-01],
	[4.5260000000E+04, 4.6093955424E+01, 4.6967889829E+00, 3.7661837390E+01, 3.8290950380E+00, 9.8833871289E-01],
	[4.5265000000E+04, 4.6103037821E+01, 4.6968304842E+00, 3.7675612288E+01, 3.8293276370E+00, 9.8834432086E-01],
	[4.5270000000E+04, 4.6112121004E+01, 4.6968719812E+00, 3.7689390701E+01, 3.8295601739E+00, 9.8834992583E-01],
	[4.5275000000E+04, 4.6121204973E+01, 4.6969134741E+00, 3.7703172631E+01, 3.8297926488E+00, 9.8835552781E-01],
	[4.5280000000E+04, 4.6130289728E+01, 4.6969549627E+00, 3.7716958077E+01, 3.8300250617E+00, 9.8836112679E-01],
	[4.5285000000E+04, 4.6139375269E+01, 4.6969964471E+00, 3.7730747041E+01, 3.8302574125E+00, 9.8836672279E-01],
	[4.5290000000E+04, 4.6148461596E+01, 4.6970379272E+00, 3.7744539522E+01, 3.8304897014E+00, 9.8837231580E-01],
	[4.5295000000E+04, 4.6157548709E+01, 4.6970794032E+00, 3.7758335522E+01, 3.8307219283E+00, 9.8837790583E-01],
	[4.5300000000E+04, 4.6166636608E+01, 4.6971208750E+00, 3.7772135040E+01, 3.8309540933E+00, 9.8838349287E-01],
	[4.5305000000E+04, 4.6175736535E+01, 4.6971633525E+00, 3.7785938078E+01, 3.8311869456E+00, 9.8838907692E-01],
	[4.5310000000E+04, 4.6184843685E+01, 4.6972064036E+00, 3.7799744636E+01, 3.8314201648E+00, 9.8839465800E-01],
	[4.5315000000E+04, 4.6193951626E+01, 4.6972494503E+00, 3.7813554714E+01, 3.8316533222E+00, 9.8840023610E-01],
	[4.5320000000E+04, 4.6203060358E+01, 4.6972924927E+00, 3.7827368312E+01, 3.8318864179E+00, 9.8840581122E-01],
	[4.5325000000E+04, 4.6212169881E+01, 4.6973355307E+00, 3.7841185432E+01, 3.8321194518E+00, 9.8841138336E-01],
	[4.5330000000E+04, 4.6221280194E+01, 4.6973785644E+00, 3.7855006074E+01, 3.8323524239E+00, 9.8841695254E-01],
	[4.5335000000E+04, 4.6230391299E+01, 4.6974215937E+00, 3.7868830238E+01, 3.8325853344E+00, 9.8842251874E-01],
	[4.5340000000E+04, 4.6239503194E+01, 4.6974646186E+00, 3.7882657925E+01, 3.8328181831E+00, 9.8842808197E-01],
	[4.5345000000E+04, 4.6248615880E+01, 4.6975076393E+00, 3.7896489136E+01, 3.8330509702E+00, 9.8843364223E-01],
	[4.5350000000E+04, 4.6257729357E+01, 4.6975506555E+00, 3.7910323870E+01, 3.8332836956E+00, 9.8843919953E-01],
	[4.5355000000E+04, 4.6266843625E+01, 4.6975936674E+00, 3.7924162129E+01, 3.8335163594E+00, 9.8844475386E-01],
	[4.5360000000E+04, 4.6275958684E+01, 4.6976366750E+00, 3.7938003912E+01, 3.8337489616E+00, 9.8845030523E-01],
	[4.5365000000E+04, 4.6285074533E+01, 4.6976796782E+00, 3.7951849221E+01, 3.8339815022E+00, 9.8845585363E-01],
	[4.5370000000E+04, 4.6294191173E+01, 4.6977226771E+00, 3.7965698056E+01, 3.8342139812E+00, 9.8846139908E-01],
	[4.5375000000E+04, 4.6303308604E+01, 4.6977656716E+00, 3.7979550418E+01, 3.8344463987E+00, 9.8846694157E-01],
	[4.5380000000E+04, 4.6312426826E+01, 4.6978086618E+00, 3.7993406306E+01, 3.8346787546E+00, 9.8847248110E-01],
	[4.5385000000E+04, 4.6321545838E+01, 4.6978516476E+00, 3.8007265722E+01, 3.8349110491E+00, 9.8847801768E-01],
	[4.5390000000E+04, 4.6330665641E+01, 4.6978946291E+00, 3.8021128665E+01, 3.8351432820E+00, 9.8848355131E-01],
	[4.5395000000E+04, 4.6339786235E+01, 4.6979376063E+00, 3.8034995138E+01, 3.8353754535E+00, 9.8848908199E-01],
	[4.5400000000E+04, 4.6348907619E+01, 4.6979805791E+00, 3.8048865139E+01, 3.8356075636E+00, 9.8849460972E-01],
	[4.5405000000E+04, 4.6358029794E+01, 4.6980235476E+00, 3.8062738669E+01, 3.8358396122E+00, 9.8850013450E-01],
	[4.5410000000E+04, 4.6367152760E+01, 4.6980665117E+00, 3.8076615730E+01, 3.8360715994E+00, 9.8850565634E-01],
	[4.5415000000E+04, 4.6376276516E+01, 4.6981094715E+00, 3.8090496321E+01, 3.8363035252E+00, 9.8851117523E-01],
	[4.5420000000E+04, 4.6385401063E+01, 4.6981524270E+00, 3.8104380443E+01, 3.8365353897E+00, 9.8851669118E-01],
	[4.5425000000E+04, 4.6394526400E+01, 4.6981953781E+00, 3.8118268097E+01, 3.8367671928E+00, 9.8852220419E-01],
	[4.5430000000E+04, 4.6403652528E+01, 4.6982383249E+00, 3.8132159282E+01, 3.8369989346E+00, 9.8852771426E-01],
	[4.5435000000E+04, 4.6412779446E+01, 4.6982812674E+00, 3.8146054000E+01, 3.8372306151E+00, 9.8853322140E-01],
	[4.5440000000E+04, 4.6421907155E+01, 4.6983242055E+00, 3.8159952251E+01, 3.8374622343E+00, 9.8853872560E-01],
	[4.5445000000E+04, 4.6431035654E+01, 4.6983671393E+00, 3.8173854036E+01, 3.8376937922E+00, 9.8854422687E-01],
	[4.5450000000E+04, 4.6440164944E+01, 4.6984100688E+00, 3.8187759355E+01, 3.8379252889E+00, 9.8854972521E-01],
	[4.5455000000E+04, 4.6449295024E+01, 4.6984529939E+00, 3.8201668208E+01, 3.8381567244E+00, 9.8855522062E-01],
	[4.5460000000E+04, 4.6458425895E+01, 4.6984959147E+00, 3.8215580597E+01, 3.8383880987E+00, 9.8856071310E-01],
	[4.5465000000E+04, 4.6467557556E+01, 4.6985388312E+00, 3.8229496521E+01, 3.8386194118E+00, 9.8856620265E-01],
	[4.5470000000E+04, 4.6476690007E+01, 4.6985817433E+00, 3.8243415981E+01, 3.8388506637E+00, 9.8857168928E-01],
	[4.5475000000E+04, 4.6485823249E+01, 4.6986246512E+00, 3.8257338978E+01, 3.8390818545E+00, 9.8857717299E-01],
	[4.5480000000E+04, 4.6494957281E+01, 4.6986675547E+00, 3.8271265512E+01, 3.8393129842E+00, 9.8858265378E-01],
	[4.5485000000E+04, 4.6504092104E+01, 4.6987104538E+00, 3.8285195583E+01, 3.8395440528E+00, 9.8858813164E-01],
	[4.5490000000E+04, 4.6513227717E+01, 4.6987533487E+00, 3.8299129193E+01, 3.8397750603E+00, 9.8859360659E-01],
	[4.5495000000E+04, 4.6522364120E+01, 4.6987962392E+00, 3.8313066341E+01, 3.8400060067E+00, 9.8859907863E-01],
	[4.5500000000E+04, 4.6531501313E+01, 4.6988391254E+00, 3.8327007029E+01, 3.8402368921E+00, 9.8860454775E-01],
	[4.5505000000E+04, 4.6540639297E+01, 4.6988820073E+00, 3.8340951256E+01, 3.8404677165E+00, 9.8861001396E-01],
	[4.5510000000E+04, 4.6549778070E+01, 4.6989248849E+00, 3.8354899023E+01, 3.8406984799E+00, 9.8861547726E-01],
	[4.5515000000E+04, 4.6558917635E+01, 4.6989677581E+00, 3.8368850331E+01, 3.8409291824E+00, 9.8862093765E-01],
	[4.5520000000E+04, 4.6568057989E+01, 4.6990106270E+00, 3.8382805180E+01, 3.8411598238E+00, 9.8862639514E-01],
	[4.5525000000E+04, 4.6577199133E+01, 4.6990534916E+00, 3.8396763571E+01, 3.8413904044E+00, 9.8863184972E-01],
	[4.5530000000E+04, 4.6586341068E+01, 4.6990963519E+00, 3.8410725504E+01, 3.8416209240E+00, 9.8863730139E-01],
	[4.5535000000E+04, 4.6595483793E+01, 4.6991392079E+00, 3.8424690980E+01, 3.8418513827E+00, 9.8864275017E-01],
	[4.5540000000E+04, 4.6604627308E+01, 4.6991820595E+00, 3.8438659999E+01, 3.8420817806E+00, 9.8864819604E-01],
	[4.5545000000E+04, 4.6613771613E+01, 4.6992249069E+00, 3.8452632562E+01, 3.8423121175E+00, 9.8865363902E-01],
	[4.5550000000E+04, 4.6622916708E+01, 4.6992677499E+00, 3.8466608669E+01, 3.8425423937E+00, 9.8865907910E-01],
	[4.5555000000E+04, 4.6632062593E+01, 4.6993105886E+00, 3.8480588321E+01, 3.8427726091E+00, 9.8866451629E-01],
	[4.5560000000E+04, 4.6641209268E+01, 4.6993534231E+00, 3.8494571518E+01, 3.8430027636E+00, 9.8866995058E-01],
	[4.5565000000E+04, 4.6650356733E+01, 4.6993962532E+00, 3.8508558261E+01, 3.8432328574E+00, 9.8867538198E-01],
	[4.5570000000E+04, 4.6659504988E+01, 4.6994390789E+00, 3.8522548550E+01, 3.8434628904E+00, 9.8868081050E-01],
	[4.5575000000E+04, 4.6668654034E+01, 4.6994819004E+00, 3.8536542386E+01, 3.8436928627E+00, 9.8868623612E-01],
	[4.5580000000E+04, 4.6677803869E+01, 4.6995247176E+00, 3.8550539769E+01, 3.8439227743E+00, 9.8869165886E-01],
	[4.5585000000E+04, 4.6686954494E+01, 4.6995675305E+00, 3.8564540700E+01, 3.8441526252E+00, 9.8869707872E-01],
	[4.5590000000E+04, 4.6696105909E+01, 4.6996103390E+00, 3.8578545180E+01, 3.8443824154E+00, 9.8870249569E-01],
	[4.5595000000E+04, 4.6705258114E+01, 4.6996531433E+00, 3.8592553208E+01, 3.8446121450E+00, 9.8870790978E-01],
	[4.5600000000E+04, 4.6714411109E+01, 4.6996959432E+00, 3.8606564786E+01, 3.8448418140E+00, 9.8871332100E-01],
	[4.5605000000E+04, 4.6723564894E+01, 4.6997387389E+00, 3.8620579913E+01, 3.8450714223E+00, 9.8871872933E-01],
	[4.5610000000E+04, 4.6732719469E+01, 4.6997815302E+00, 3.8634598591E+01, 3.8453009700E+00, 9.8872413480E-01],
	[4.5615000000E+04, 4.6741874833E+01, 4.6998243173E+00, 3.8648620820E+01, 3.8455304572E+00, 9.8872953738E-01],
	[4.5620000000E+04, 4.6751030988E+01, 4.6998671000E+00, 3.8662646600E+01, 3.8457598838E+00, 9.8873493710E-01],
	[4.5625000000E+04, 4.6760187932E+01, 4.6999098785E+00, 3.8676675932E+01, 3.8459892499E+00, 9.8874033395E-01],
	[4.5630000000E+04, 4.6769345666E+01, 4.6999526526E+00, 3.8690708817E+01, 3.8462185555E+00, 9.8874572792E-01],
	[4.5635000000E+04, 4.6778504190E+01, 4.6999954225E+00, 3.8704745254E+01, 3.8464478006E+00, 9.8875111903E-01],
	[4.5640000000E+04, 4.6787663503E+01, 4.7000381880E+00, 3.8718785245E+01, 3.8466769852E+00, 9.8875650728E-01],
	[4.5645000000E+04, 4.6796823607E+01, 4.7000809493E+00, 3.8732828790E+01, 3.8469061094E+00, 9.8876189266E-01],
	[4.5650000000E+04, 4.6805984500E+01, 4.7001237062E+00, 3.8746875889E+01, 3.8471351732E+00, 9.8876727518E-01],
	[4.5655000000E+04, 4.6815146182E+01, 4.7001664589E+00, 3.8760926543E+01, 3.8473641765E+00, 9.8877265484E-01],
	[4.5660000000E+04, 4.6824308655E+01, 4.7002092073E+00, 3.8774980753E+01, 3.8475931195E+00, 9.8877803164E-01],
	[4.5665000000E+04, 4.6833471917E+01, 4.7002519514E+00, 3.8789038519E+01, 3.8478220021E+00, 9.8878340559E-01],
	[4.5670000000E+04, 4.6842635969E+01, 4.7002946912E+00, 3.8803099841E+01, 3.8480508243E+00, 9.8878877668E-01],
	[4.5675000000E+04, 4.6851800810E+01, 4.7003374267E+00, 3.8817164720E+01, 3.8482795862E+00, 9.8879414492E-01],
	[4.5680000000E+04, 4.6860966441E+01, 4.7003801579E+00, 3.8831233157E+01, 3.8485082878E+00, 9.8879951031E-01],
	[4.5685000000E+04, 4.6870132861E+01, 4.7004228848E+00, 3.8845305151E+01, 3.8487369292E+00, 9.8880487284E-01],
	[4.5690000000E+04, 4.6879300072E+01, 4.7004656074E+00, 3.8859380705E+01, 3.8489655102E+00, 9.8881023253E-01],
	[4.5695000000E+04, 4.6888468071E+01, 4.7005083258E+00, 3.8873459817E+01, 3.8491940310E+00, 9.8881558938E-01],
	[4.5700000000E+04, 4.6897636860E+01, 4.7005510399E+00, 3.8887542489E+01, 3.8494224916E+00, 9.8882094338E-01],
	[4.5705000000E+04, 4.6906806439E+01, 4.7005937496E+00, 3.8901628721E+01, 3.8496508920E+00, 9.8882629453E-01],
	[4.5710000000E+04, 4.6915976807E+01, 4.7006364551E+00, 3.8915718513E+01, 3.8498792322E+00, 9.8883164285E-01],
	[4.5715000000E+04, 4.6925147965E+01, 4.7006791563E+00, 3.8929811867E+01, 3.8501075122E+00, 9.8883698833E-01],
	[4.5720000000E+04, 4.6934319912E+01, 4.7007218533E+00, 3.8943908782E+01, 3.8503357321E+00, 9.8884233096E-01],
	[4.5725000000E+04, 4.6943492649E+01, 4.7007645459E+00, 3.8958009259E+01, 3.8505638918E+00, 9.8884767076E-01],
	[4.5730000000E+04, 4.6952666175E+01, 4.7008072343E+00, 3.8972113299E+01, 3.8507919915E+00, 9.8885300773E-01],
	[4.5735000000E+04, 4.6961840490E+01, 4.7008499184E+00, 3.8986220902E+01, 3.8510200310E+00, 9.8885834186E-01],
	[4.5740000000E+04, 4.6971015595E+01, 4.7008925982E+00, 3.9000332069E+01, 3.8512480105E+00, 9.8886367316E-01],
	[4.5745000000E+04, 4.6980191489E+01, 4.7009352737E+00, 3.9014446800E+01, 3.8514759300E+00, 9.8886900163E-01],
	[4.5750000000E+04, 4.6989368173E+01, 4.7009779450E+00, 3.9028565095E+01, 3.8517037894E+00, 9.8887432727E-01],
	[4.5755000000E+04, 4.6998545646E+01, 4.7010206119E+00, 3.9042686956E+01, 3.8519315888E+00, 9.8887965008E-01],
	[4.5760000000E+04, 4.7007723908E+01, 4.7010632747E+00, 3.9056812382E+01, 3.8521593283E+00, 9.8888497007E-01],
	[4.5765000000E+04, 4.7016902960E+01, 4.7011059331E+00, 3.9070941374E+01, 3.8523870077E+00, 9.8889028723E-01],
	[4.5770000000E+04, 4.7026082800E+01, 4.7011485872E+00, 3.9085073934E+01, 3.8526146272E+00, 9.8889560157E-01],
	[4.5775000000E+04, 4.7035263430E+01, 4.7011912371E+00, 3.9099210060E+01, 3.8528421868E+00, 9.8890091309E-01],
	[4.5780000000E+04, 4.7044444850E+01, 4.7012338827E+00, 3.9113349754E+01, 3.8530696865E+00, 9.8890622179E-01],
	[4.5785000000E+04, 4.7053627058E+01, 4.7012765241E+00, 3.9127493017E+01, 3.8532971263E+00, 9.8891152767E-01],
	[4.5790000000E+04, 4.7062810056E+01, 4.7013191611E+00, 3.9141639848E+01, 3.8535245063E+00, 9.8891683073E-01],
	[4.5795000000E+04, 4.7071993843E+01, 4.7013617939E+00, 3.9155790248E+01, 3.8537518264E+00, 9.8892213098E-01],
	[4.5800000000E+04, 4.7081178419E+01, 4.7014044225E+00, 3.9169944218E+01, 3.8539790867E+00, 9.8892742841E-01],
	[4.5805000000E+04, 4.7090363784E+01, 4.7014470468E+00, 3.9184101759E+01, 3.8542062871E+00, 9.8893272303E-01],
	[4.5810000000E+04, 4.7099549939E+01, 4.7014896668E+00, 3.9198262870E+01, 3.8544334278E+00, 9.8893801484E-01],
	[4.5815000000E+04, 4.7108736882E+01, 4.7015322825E+00, 3.9212427552E+01, 3.8546605087E+00, 9.8894330385E-01],
	[4.5820000000E+04, 4.7117924615E+01, 4.7015748940E+00, 3.9226595807E+01, 3.8548875299E+00, 9.8894859004E-01],
	[4.5825000000E+04, 4.7127113136E+01, 4.7016175012E+00, 3.9240767633E+01, 3.8551144914E+00, 9.8895387343E-01],
	[4.5830000000E+04, 4.7136302447E+01, 4.7016601041E+00, 3.9254943033E+01, 3.8553413931E+00, 9.8895915401E-01],
	[4.5835000000E+04, 4.7145492547E+01, 4.7017027028E+00, 3.9269122006E+01, 3.8555682352E+00, 9.8896443179E-01],
	[4.5840000000E+04, 4.7154683436E+01, 4.7017452972E+00, 3.9283304552E+01, 3.8557950176E+00, 9.8896970677E-01],
	[4.5845000000E+04, 4.7163875113E+01, 4.7017878874E+00, 3.9297490673E+01, 3.8560217403E+00, 9.8897497895E-01],
	[4.5850000000E+04, 4.7173067580E+01, 4.7018304733E+00, 3.9311680369E+01, 3.8562484034E+00, 9.8898024833E-01],
	[4.5855000000E+04, 4.7182260836E+01, 4.7018730549E+00, 3.9325873640E+01, 3.8564750069E+00, 9.8898551492E-01],
	[4.5860000000E+04, 4.7191454881E+01, 4.7019156323E+00, 3.9340070488E+01, 3.8567015509E+00, 9.8899077870E-01],
	[4.5865000000E+04, 4.7200649714E+01, 4.7019582055E+00, 3.9354270911E+01, 3.8569280353E+00, 9.8899603970E-01],
	[4.5870000000E+04, 4.7209845337E+01, 4.7020007743E+00, 3.9368474912E+01, 3.8571544601E+00, 9.8900129790E-01],
	[4.5875000000E+04, 4.7219041748E+01, 4.7020433390E+00, 3.9382682489E+01, 3.8573808254E+00, 9.8900655331E-01],
	[4.5880000000E+04, 4.7228238948E+01, 4.7020858993E+00, 3.9396893645E+01, 3.8576071312E+00, 9.8901180594E-01],
	[4.5885000000E+04, 4.7237436938E+01, 4.7021284554E+00, 3.9411108380E+01, 3.8578333775E+00, 9.8901705577E-01],
	[4.5890000000E+04, 4.7246635716E+01, 4.7021710073E+00, 3.9425326693E+01, 3.8580595643E+00, 9.8902230282E-01],
	[4.5895000000E+04, 4.7255835282E+01, 4.7022135549E+00, 3.9439548586E+01, 3.8582856917E+00, 9.8902754708E-01],
	[4.5900000000E+04, 4.7265035638E+01, 4.7022560983E+00, 3.9453774058E+01, 3.8585117597E+00, 9.8903278856E-01],
	[4.5905000000E+04, 4.7274236782E+01, 4.7022986374E+00, 3.9468003112E+01, 3.8587377682E+00, 9.8903802726E-01],
	[4.5910000000E+04, 4.7283438716E+01, 4.7023411723E+00, 3.9482235746E+01, 3.8589637174E+00, 9.8904326318E-01],
	[4.5915000000E+04, 4.7292641438E+01, 4.7023837029E+00, 3.9496471961E+01, 3.8591896072E+00, 9.8904849632E-01],
	[4.5920000000E+04, 4.7301844948E+01, 4.7024262293E+00, 3.9510711759E+01, 3.8594154377E+00, 9.8905372668E-01],
	[4.5925000000E+04, 4.7311049248E+01, 4.7024687514E+00, 3.9524955139E+01, 3.8596412088E+00, 9.8905895427E-01],
	[4.5930000000E+04, 4.7320254336E+01, 4.7025112693E+00, 3.9539202103E+01, 3.8598669206E+00, 9.8906417909E-01],
	[4.5935000000E+04, 4.7329460212E+01, 4.7025537829E+00, 3.9553452650E+01, 3.8600925732E+00, 9.8906940113E-01],
	[4.5940000000E+04, 4.7338666878E+01, 4.7025962923E+00, 3.9567706781E+01, 3.8603181665E+00, 9.8907462040E-01],
	[4.5945000000E+04, 4.7347874332E+01, 4.7026387974E+00, 3.9581964496E+01, 3.8605437005E+00, 9.8907983690E-01],
	[4.5950000000E+04, 4.7357082574E+01, 4.7026812984E+00, 3.9596225797E+01, 3.8607691753E+00, 9.8908505063E-01],
	[4.5955000000E+04, 4.7366291606E+01, 4.7027237950E+00, 3.9610490683E+01, 3.8609945909E+00, 9.8909026160E-01],
	[4.5960000000E+04, 4.7375501425E+01, 4.7027662875E+00, 3.9624759155E+01, 3.8612199473E+00, 9.8909546980E-01],
	[4.5965000000E+04, 4.7384712034E+01, 4.7028087756E+00, 3.9639031214E+01, 3.8614452445E+00, 9.8910067524E-01],
	[4.5970000000E+04, 4.7393923431E+01, 4.7028512596E+00, 3.9653306860E+01, 3.8616704826E+00, 9.8910587792E-01],
	[4.5975000000E+04, 4.7403135616E+01, 4.7028937393E+00, 3.9667586094E+01, 3.8618956616E+00, 9.8911107783E-01],
	[4.5980000000E+04, 4.7412348590E+01, 4.7029362148E+00, 3.9681868916E+01, 3.8621207814E+00, 9.8911627499E-01],
	[4.5985000000E+04, 4.7421562353E+01, 4.7029786860E+00, 3.9696155327E+01, 3.8623458422E+00, 9.8912146939E-01],
	[4.5990000000E+04, 4.7430776904E+01, 4.7030211531E+00, 3.9710445326E+01, 3.8625708439E+00, 9.8912666103E-01],
	[4.5995000000E+04, 4.7439992243E+01, 4.7030636158E+00, 3.9724738916E+01, 3.8627957865E+00, 9.8913184993E-01],
	[4.6000000000E+04, 4.7449208371E+01, 4.7031060744E+00, 3.9739036096E+01, 3.8630206701E+00, 9.8913703606E-01],
	[4.6005000000E+04, 4.7458425287E+01, 4.7031485287E+00, 3.9753336866E+01, 3.8632454947E+00, 9.8914221945E-01],
	[4.6010000000E+04, 4.7467642992E+01, 4.7031909788E+00, 3.9767641228E+01, 3.8634702603E+00, 9.8914740009E-01],
	[4.6015000000E+04, 4.7476861485E+01, 4.7032334246E+00, 3.9781949181E+01, 3.8636949670E+00, 9.8915257798E-01],
	[4.6020000000E+04, 4.7486080766E+01, 4.7032758663E+00, 3.9796260727E+01, 3.8639196147E+00, 9.8915775312E-01],
	[4.6025000000E+04, 4.7495300836E+01, 4.7033183037E+00, 3.9810575865E+01, 3.8641442034E+00, 9.8916292552E-01],
	[4.6030000000E+04, 4.7504521694E+01, 4.7033607368E+00, 3.9824894596E+01, 3.8643687333E+00, 9.8916809517E-01],
	[4.6035000000E+04, 4.7513757098E+01, 4.7034043740E+00, 3.9839216922E+01, 3.8645941110E+00, 9.8917326208E-01],
	[4.6040000000E+04, 4.7522997253E+01, 4.7034483546E+00, 3.9853542842E+01, 3.8648196908E+00, 9.8917842625E-01],
	[4.6045000000E+04, 4.7532238202E+01, 4.7034923307E+00, 3.9867872356E+01, 3.8650452118E+00, 9.8918358769E-01],
	[4.6050000000E+04, 4.7541479944E+01, 4.7035363026E+00, 3.9882205466E+01, 3.8652706741E+00, 9.8918874638E-01],
	[4.6055000000E+04, 4.7550722479E+01, 4.7035802700E+00, 3.9896542172E+01, 3.8654960777E+00, 9.8919390234E-01],
	[4.6060000000E+04, 4.7559965807E+01, 4.7036242331E+00, 3.9910882474E+01, 3.8657214225E+00, 9.8919905557E-01],
	[4.6065000000E+04, 4.7569209929E+01, 4.7036681918E+00, 3.9925226373E+01, 3.8659467087E+00, 9.8920420606E-01],
	[4.6070000000E+04, 4.7578454843E+01, 4.7037121462E+00, 3.9939573869E+01, 3.8661719362E+00, 9.8920935382E-01],
	[4.6075000000E+04, 4.7587700551E+01, 4.7037560962E+00, 3.9953924963E+01, 3.8663971050E+00, 9.8921449885E-01],
	[4.6080000000E+04, 4.7596947052E+01, 4.7038000418E+00, 3.9968279655E+01, 3.8666222152E+00, 9.8921964115E-01],
	[4.6085000000E+04, 4.7606194346E+01, 4.7038439831E+00, 3.9982637947E+01, 3.8668472668E+00, 9.8922478073E-01],
	[4.6090000000E+04, 4.7615442433E+01, 4.7038879201E+00, 3.9996999838E+01, 3.8670722597E+00, 9.8922991758E-01],
	[4.6095000000E+04, 4.7624691313E+01, 4.7039318526E+00, 4.0011365328E+01, 3.8672971941E+00, 9.8923505170E-01],
	[4.6100000000E+04, 4.7633940986E+01, 4.7039757809E+00, 4.0025734419E+01, 3.8675220700E+00, 9.8924018311E-01],
	[4.6105000000E+04, 4.7643191452E+01, 4.7040197047E+00, 4.0040107112E+01, 3.8677468873E+00, 9.8924531179E-01],
	[4.6110000000E+04, 4.7652442711E+01, 4.7040636242E+00, 4.0054483405E+01, 3.8679716461E+00, 9.8925043776E-01],
	[4.6115000000E+04, 4.7661694763E+01, 4.7041075394E+00, 4.0068863301E+01, 3.8681963464E+00, 9.8925556100E-01],
	[4.6120000000E+04, 4.7670947608E+01, 4.7041514502E+00, 4.0083246799E+01, 3.8684209882E+00, 9.8926068153E-01],
	[4.6125000000E+04, 4.7680201246E+01, 4.7041953567E+00, 4.0097633900E+01, 3.8686455715E+00, 9.8926579935E-01],
	[4.6130000000E+04, 4.7689455677E+01, 4.7042392588E+00, 4.0112024604E+01, 3.8688700965E+00, 9.8927091445E-01],
	[4.6135000000E+04, 4.7698710900E+01, 4.7042831565E+00, 4.0126418913E+01, 3.8690945629E+00, 9.8927602684E-01],
	[4.6140000000E+04, 4.7707966917E+01, 4.7043270500E+00, 4.0140816826E+01, 3.8693189710E+00, 9.8928113652E-01],
	[4.6145000000E+04, 4.7717223727E+01, 4.7043709390E+00, 4.0155218344E+01, 3.8695433208E+00, 9.8928624349E-01],
	[4.6150000000E+04, 4.7726481329E+01, 4.7044148237E+00, 4.0169623468E+01, 3.8697676121E+00, 9.8929134776E-01],
	[4.6155000000E+04, 4.7735739724E+01, 4.7044587041E+00, 4.0184032197E+01, 3.8699918451E+00, 9.8929644932E-01],
	[4.6160000000E+04, 4.7744998912E+01, 4.7045025802E+00, 4.0198444534E+01, 3.8702160198E+00, 9.8930154817E-01],
	[4.6165000000E+04, 4.7754258893E+01, 4.7045464518E+00, 4.0212860477E+01, 3.8704401362E+00, 9.8930664432E-01],
	[4.6170000000E+04, 4.7763519667E+01, 4.7045903192E+00, 4.0227280028E+01, 3.8706641943E+00, 9.8931173778E-01],
	[4.6175000000E+04, 4.7772781233E+01, 4.7046341822E+00, 4.0241703187E+01, 3.8708881941E+00, 9.8931682853E-01],
	[4.6180000000E+04, 4.7782043592E+01, 4.7046780409E+00, 4.0256129955E+01, 3.8711121357E+00, 9.8932191658E-01],
	[4.6185000000E+04, 4.7791306744E+01, 4.7047218952E+00, 4.0270560332E+01, 3.8713360191E+00, 9.8932700194E-01],
	[4.6190000000E+04, 4.7800570689E+01, 4.7047657452E+00, 4.0284994318E+01, 3.8715598442E+00, 9.8933208460E-01],
	[4.6195000000E+04, 4.7809835426E+01, 4.7048095908E+00, 4.0299431915E+01, 3.8717836112E+00, 9.8933716457E-01],
	[4.6200000000E+04, 4.7819100956E+01, 4.7048534321E+00, 4.0313873122E+01, 3.8720073200E+00, 9.8934224185E-01],
	[4.6205000000E+04, 4.7828367279E+01, 4.7048972691E+00, 4.0328317941E+01, 3.8722309706E+00, 9.8934731643E-01],
	[4.6210000000E+04, 4.7837634394E+01, 4.7049411018E+00, 4.0342766371E+01, 3.8724545632E+00, 9.8935238833E-01],
	[4.6215000000E+04, 4.7846902302E+01, 4.7049849301E+00, 4.0357218413E+01, 3.8726780976E+00, 9.8935745754E-01],
	[4.6220000000E+04, 4.7856171002E+01, 4.7050287540E+00, 4.0371674068E+01, 3.8729015739E+00, 9.8936252406E-01],
	[4.6225000000E+04, 4.7865440495E+01, 4.7050725737E+00, 4.0386133337E+01, 3.8731249922E+00, 9.8936758790E-01],
	[4.6230000000E+04, 4.7874710781E+01, 4.7051163890E+00, 4.0400596219E+01, 3.8733483524E+00, 9.8937264906E-01],
	[4.6235000000E+04, 4.7883981859E+01, 4.7051602000E+00, 4.0415062715E+01, 3.8735716546E+00, 9.8937770753E-01],
	[4.6240000000E+04, 4.7893253730E+01, 4.7052040066E+00, 4.0429532826E+01, 3.8737948987E+00, 9.8938276333E-01],
	[4.6245000000E+04, 4.7902526393E+01, 4.7052478089E+00, 4.0444006553E+01, 3.8740180849E+00, 9.8938781645E-01],
	[4.6250000000E+04, 4.7911799849E+01, 4.7052916069E+00, 4.0458483895E+01, 3.8742412131E+00, 9.8939286688E-01],
	[4.6255000000E+04, 4.7921074097E+01, 4.7053354006E+00, 4.0472964853E+01, 3.8744642833E+00, 9.8939791465E-01],
	[4.6260000000E+04, 4.7930349138E+01, 4.7053791899E+00, 4.0487449429E+01, 3.8746872956E+00, 9.8940295974E-01],
	[4.6265000000E+04, 4.7939624971E+01, 4.7054229749E+00, 4.0501937621E+01, 3.8749102500E+00, 9.8940800216E-01],
	[4.6270000000E+04, 4.7948901596E+01, 4.7054667556E+00, 4.0516429432E+01, 3.8751331465E+00, 9.8941304190E-01],
	[4.6275000000E+04, 4.7958179014E+01, 4.7055105320E+00, 4.0530924861E+01, 3.8753559851E+00, 9.8941807898E-01],
	[4.6280000000E+04, 4.7967457224E+01, 4.7055543040E+00, 4.0545423908E+01, 3.8755787659E+00, 9.8942311339E-01],
	[4.6285000000E+04, 4.7976736227E+01, 4.7055980718E+00, 4.0559926576E+01, 3.8758014888E+00, 9.8942814513E-01],
	[4.6290000000E+04, 4.7986016022E+01, 4.7056418352E+00, 4.0574432863E+01, 3.8760241539E+00, 9.8943317421E-01],
	[4.6295000000E+04, 4.7995296609E+01, 4.7056855942E+00, 4.0588942770E+01, 3.8762467612E+00, 9.8943820063E-01],
	[4.6300000000E+04, 4.8004577989E+01, 4.7057293490E+00, 4.0603456298E+01, 3.8764693108E+00, 9.8944322438E-01],
	[4.6305000000E+04, 4.8013860161E+01, 4.7057730995E+00, 4.0617973448E+01, 3.8766918025E+00, 9.8944824547E-01],
	[4.6310000000E+04, 4.8023143125E+01, 4.7058168456E+00, 4.0632494220E+01, 3.8769142365E+00, 9.8945326391E-01],
	[4.6315000000E+04, 4.8032426882E+01, 4.7058605874E+00, 4.0647018614E+01, 3.8771366128E+00, 9.8945827968E-01],
	[4.6320000000E+04, 4.8041711430E+01, 4.7059043249E+00, 4.0661546631E+01, 3.8773589314E+00, 9.8946329280E-01],
	[4.6325000000E+04, 4.8050996771E+01, 4.7059480581E+00, 4.0676078271E+01, 3.8775811923E+00, 9.8946830327E-01],
	[4.6330000000E+04, 4.8060282905E+01, 4.7059917869E+00, 4.0690613536E+01, 3.8778033956E+00, 9.8947331108E-01],
	[4.6335000000E+04, 4.8069569830E+01, 4.7060355115E+00, 4.0705152425E+01, 3.8780255412E+00, 9.8947831625E-01],
	[4.6340000000E+04, 4.8078857548E+01, 4.7060792317E+00, 4.0719694939E+01, 3.8782476292E+00, 9.8948331876E-01],
	[4.6345000000E+04, 4.8088146057E+01, 4.7061229477E+00, 4.0734241079E+01, 3.8784696595E+00, 9.8948831862E-01],
	[4.6350000000E+04, 4.8097435359E+01, 4.7061666593E+00, 4.0748790844E+01, 3.8786916323E+00, 9.8949331584E-01],
	[4.6355000000E+04, 4.8106725453E+01, 4.7062103666E+00, 4.0763344237E+01, 3.8789135475E+00, 9.8949831041E-01],
	[4.6360000000E+04, 4.8116016339E+01, 4.7062540696E+00, 4.0777901256E+01, 3.8791354052E+00, 9.8950330234E-01],
	[4.6365000000E+04, 4.8125308017E+01, 4.7062977683E+00, 4.0792461903E+01, 3.8793572053E+00, 9.8950829162E-01],
	[4.6370000000E+04, 4.8134600487E+01, 4.7063414627E+00, 4.0807026178E+01, 3.8795789479E+00, 9.8951327827E-01],
	[4.6375000000E+04, 4.8143893750E+01, 4.7063851528E+00, 4.0821594081E+01, 3.8798006331E+00, 9.8951826227E-01],
	[4.6380000000E+04, 4.8153187804E+01, 4.7064288386E+00, 4.0836165614E+01, 3.8800222607E+00, 9.8952324364E-01],
	[4.6385000000E+04, 4.8162482650E+01, 4.7064725200E+00, 4.0850740776E+01, 3.8802438309E+00, 9.8952822237E-01],
	[4.6390000000E+04, 4.8171778288E+01, 4.7065161972E+00, 4.0865319569E+01, 3.8804653437E+00, 9.8953319847E-01],
	[4.6395000000E+04, 4.8181074719E+01, 4.7065598701E+00, 4.0879901992E+01, 3.8806867990E+00, 9.8953817193E-01],
	[4.6400000000E+04, 4.8190371941E+01, 4.7066035386E+00, 4.0894488046E+01, 3.8809081970E+00, 9.8954314276E-01],
	[4.6405000000E+04, 4.8199669955E+01, 4.7066472029E+00, 4.0909077732E+01, 3.8811295376E+00, 9.8954811096E-01],
	[4.6410000000E+04, 4.8208968761E+01, 4.7066908629E+00, 4.0923671050E+01, 3.8813508208E+00, 9.8955307653E-01],
	[4.6415000000E+04, 4.8218268359E+01, 4.7067345185E+00, 4.0938268001E+01, 3.8815720467E+00, 9.8955803948E-01],
	[4.6420000000E+04, 4.8227568749E+01, 4.7067781699E+00, 4.0952868585E+01, 3.8817932152E+00, 9.8956299979E-01],
	[4.6425000000E+04, 4.8236869931E+01, 4.7068218170E+00, 4.0967472802E+01, 3.8820143265E+00, 9.8956795749E-01],
	[4.6430000000E+04, 4.8246171904E+01, 4.7068654598E+00, 4.0982080654E+01, 3.8822353805E+00, 9.8957291256E-01],
	[4.6435000000E+04, 4.8255474670E+01, 4.7069090983E+00, 4.0996692141E+01, 3.8824563772E+00, 9.8957786501E-01],
	[4.6440000000E+04, 4.8264778227E+01, 4.7069527325E+00, 4.1011307263E+01, 3.8826773167E+00, 9.8958281484E-01],
	[4.6445000000E+04, 4.8274082576E+01, 4.7069963624E+00, 4.1025926021E+01, 3.8828981989E+00, 9.8958776205E-01],
	[4.6450000000E+04, 4.8283387717E+01, 4.7070399880E+00, 4.1040548415E+01, 3.8831190240E+00, 9.8959270664E-01],
	[4.6455000000E+04, 4.8292693649E+01, 4.7070836093E+00, 4.1055174446E+01, 3.8833397918E+00, 9.8959764862E-01],
	[4.6460000000E+04, 4.8302000373E+01, 4.7071272263E+00, 4.1069804114E+01, 3.8835605025E+00, 9.8960258798E-01],
	[4.6465000000E+04, 4.8311307890E+01, 4.7071708390E+00, 4.1084437420E+01, 3.8837811561E+00, 9.8960752473E-01],
	[4.6470000000E+04, 4.8320616197E+01, 4.7072144475E+00, 4.1099074365E+01, 3.8840017525E+00, 9.8961245888E-01],
	[4.6475000000E+04, 4.8329925297E+01, 4.7072580516E+00, 4.1113714948E+01, 3.8842222918E+00, 9.8961739041E-01],
	[4.6480000000E+04, 4.8339235188E+01, 4.7073016515E+00, 4.1128359171E+01, 3.8844427740E+00, 9.8962231933E-01],
	[4.6485000000E+04, 4.8348545870E+01, 4.7073452471E+00, 4.1143007033E+01, 3.8846631992E+00, 9.8962724565E-01],
	[4.6490000000E+04, 4.8357857345E+01, 4.7073888384E+00, 4.1157658536E+01, 3.8848835673E+00, 9.8963216936E-01],
	[4.6495000000E+04, 4.8367169611E+01, 4.7074324254E+00, 4.1172313680E+01, 3.8851038784E+00, 9.8963709047E-01],
	[4.6500000000E+04, 4.8376482668E+01, 4.7074760081E+00, 4.1186972465E+01, 3.8853241324E+00, 9.8964200897E-01],
	[4.6505000000E+04, 4.8385796518E+01, 4.7075195866E+00, 4.1201634892E+01, 3.8855443295E+00, 9.8964692488E-01],
	[4.6510000000E+04, 4.8395111158E+01, 4.7075631608E+00, 4.1216300962E+01, 3.8857644695E+00, 9.8965183818E-01],
	[4.6515000000E+04, 4.8404426591E+01, 4.7076067306E+00, 4.1230970675E+01, 3.8859845527E+00, 9.8965674889E-01],
	[4.6520000000E+04, 4.8413742814E+01, 4.7076502963E+00, 4.1245644031E+01, 3.8862045788E+00, 9.8966165701E-01],
	[4.6525000000E+04, 4.8423059830E+01, 4.7076938576E+00, 4.1260321031E+01, 3.8864245481E+00, 9.8966656252E-01],
	[4.6530000000E+04, 4.8432377637E+01, 4.7077374146E+00, 4.1275001675E+01, 3.8866444605E+00, 9.8967146545E-01],
	[4.6535000000E+04, 4.8441696235E+01, 4.7077809674E+00, 4.1289685965E+01, 3.8868643160E+00, 9.8967636578E-01],
	[4.6540000000E+04, 4.8451015625E+01, 4.7078245159E+00, 4.1304373900E+01, 3.8870841146E+00, 9.8968126353E-01],
	[4.6545000000E+04, 4.8460335806E+01, 4.7078680601E+00, 4.1319065481E+01, 3.8873038564E+00, 9.8968615868E-01],
	[4.6550000000E+04, 4.8469656778E+01, 4.7079116001E+00, 4.1333760709E+01, 3.8875235413E+00, 9.8969105125E-01],
	[4.6555000000E+04, 4.8478978542E+01, 4.7079551357E+00, 4.1348459584E+01, 3.8877431695E+00, 9.8969594123E-01],
	[4.6560000000E+04, 4.8488301098E+01, 4.7079986671E+00, 4.1363162106E+01, 3.8879627408E+00, 9.8970082862E-01],
	[4.6565000000E+04, 4.8497624445E+01, 4.7080421943E+00, 4.1377868276E+01, 3.8881822554E+00, 9.8970571344E-01],
	[4.6570000000E+04, 4.8506948583E+01, 4.7080857171E+00, 4.1392578095E+01, 3.8884017133E+00, 9.8971059567E-01],
	[4.6575000000E+04, 4.8516273512E+01, 4.7081292357E+00, 4.1407291564E+01, 3.8886211144E+00, 9.8971547533E-01],
	[4.6580000000E+04, 4.8525599233E+01, 4.7081727500E+00, 4.1422008681E+01, 3.8888404588E+00, 9.8972035240E-01],
	[4.6585000000E+04, 4.8534925745E+01, 4.7082162601E+00, 4.1436729449E+01, 3.8890597465E+00, 9.8972522690E-01],
	[4.6590000000E+04, 4.8544253048E+01, 4.7082597658E+00, 4.1451453868E+01, 3.8892789775E+00, 9.8973009882E-01],
	[4.6595000000E+04, 4.8553581143E+01, 4.7083032673E+00, 4.1466181938E+01, 3.8894981519E+00, 9.8973496817E-01],
	[4.6600000000E+04, 4.8562910029E+01, 4.7083467646E+00, 4.1480913659E+01, 3.8897172697E+00, 9.8973983495E-01],
	[4.6605000000E+04, 4.8572239706E+01, 4.7083902576E+00, 4.1495649033E+01, 3.8899363308E+00, 9.8974469915E-01],
	[4.6610000000E+04, 4.8581570174E+01, 4.7084337463E+00, 4.1510388059E+01, 3.8901553354E+00, 9.8974956079E-01],
	[4.6615000000E+04, 4.8590901434E+01, 4.7084772307E+00, 4.1525130739E+01, 3.8903742833E+00, 9.8975441986E-01],
	[4.6620000000E+04, 4.8600233484E+01, 4.7085207109E+00, 4.1539877072E+01, 3.8905931747E+00, 9.8975927636E-01],
	[4.6625000000E+04, 4.8609566326E+01, 4.7085641869E+00, 4.1554627060E+01, 3.8908120096E+00, 9.8976413029E-01],
	[4.6630000000E+04, 4.8618899959E+01, 4.7086076585E+00, 4.1569380702E+01, 3.8910307879E+00, 9.8976898167E-01],
	[4.6635000000E+04, 4.8628234383E+01, 4.7086511259E+00, 4.1584138000E+01, 3.8912495098E+00, 9.8977383048E-01],
	[4.6640000000E+04, 4.8637569598E+01, 4.7086945891E+00, 4.1598898954E+01, 3.8914681751E+00, 9.8977867673E-01],
	[4.6645000000E+04, 4.8646905604E+01, 4.7087380480E+00, 4.1613663563E+01, 3.8916867840E+00, 9.8978352042E-01],
	[4.6650000000E+04, 4.8656242402E+01, 4.7087815026E+00, 4.1628431830E+01, 3.8919053365E+00, 9.8978836155E-01],
	[4.6655000000E+04, 4.8665579990E+01, 4.7088249530E+00, 4.1643203754E+01, 3.8921238325E+00, 9.8979320013E-01],
	[4.6660000000E+04, 4.8674918369E+01, 4.7088683991E+00, 4.1657979336E+01, 3.8923422721E+00, 9.8979803615E-01],
	[4.6665000000E+04, 4.8684257540E+01, 4.7089118410E+00, 4.1672758576E+01, 3.8925606553E+00, 9.8980286962E-01],
	[4.6670000000E+04, 4.8693597501E+01, 4.7089552786E+00, 4.1687541475E+01, 3.8927789822E+00, 9.8980770054E-01],
	[4.6675000000E+04, 4.8702938254E+01, 4.7089987120E+00, 4.1702328033E+01, 3.8929972527E+00, 9.8981252891E-01],
	[4.6680000000E+04, 4.8712279797E+01, 4.7090421411E+00, 4.1717118252E+01, 3.8932154668E+00, 9.8981735472E-01],
	[4.6685000000E+04, 4.8721622131E+01, 4.7090855659E+00, 4.1731912130E+01, 3.8934336247E+00, 9.8982217799E-01],
	[4.6690000000E+04, 4.8730965256E+01, 4.7091289865E+00, 4.1746709670E+01, 3.8936517262E+00, 9.8982699872E-01],
	[4.6695000000E+04, 4.8740309172E+01, 4.7091724029E+00, 4.1761510871E+01, 3.8938697715E+00, 9.8983181690E-01],
	[4.6700000000E+04, 4.8749653879E+01, 4.7092158150E+00, 4.1776315734E+01, 3.8940877605E+00, 9.8983663254E-01],
	[4.6705000000E+04, 4.8758999377E+01, 4.7092592229E+00, 4.1791124260E+01, 3.8943056933E+00, 9.8984144564E-01],
	[4.6710000000E+04, 4.8768345666E+01, 4.7093026265E+00, 4.1805936448E+01, 3.8945235699E+00, 9.8984625619E-01],
	[4.6715000000E+04, 4.8777692746E+01, 4.7093460259E+00, 4.1820752300E+01, 3.8947413902E+00, 9.8985106421E-01],
	[4.6720000000E+04, 4.8787040616E+01, 4.7093894210E+00, 4.1835571816E+01, 3.8949591544E+00, 9.8985586969E-01],
	[4.6725000000E+04, 4.8796389277E+01, 4.7094328119E+00, 4.1850394997E+01, 3.8951768624E+00, 9.8986067264E-01],
	[4.6730000000E+04, 4.8805738729E+01, 4.7094761985E+00, 4.1865221843E+01, 3.8953945143E+00, 9.8986547305E-01],
	[4.6735000000E+04, 4.8815088972E+01, 4.7095195809E+00, 4.1880052354E+01, 3.8956121100E+00, 9.8987027093E-01],
	[4.6740000000E+04, 4.8824440005E+01, 4.7095629591E+00, 4.1894886531E+01, 3.8958296497E+00, 9.8987506627E-01],
	[4.6745000000E+04, 4.8833791829E+01, 4.7096063330E+00, 4.1909724375E+01, 3.8960471332E+00, 9.8987985909E-01],
	[4.6750000000E+04, 4.8843144444E+01, 4.7096497026E+00, 4.1924565886E+01, 3.8962645607E+00, 9.8988464938E-01],
	[4.6755000000E+04, 4.8852497850E+01, 4.7096930681E+00, 4.1939411064E+01, 3.8964819321E+00, 9.8988943714E-01],
	[4.6760000000E+04, 4.8861852046E+01, 4.7097364293E+00, 4.1954259911E+01, 3.8966992475E+00, 9.8989422238E-01],
	[4.6765000000E+04, 4.8871207033E+01, 4.7097797862E+00, 4.1969112426E+01, 3.8969165069E+00, 9.8989900509E-01],
	[4.6770000000E+04, 4.8880562811E+01, 4.7098231390E+00, 4.1983968611E+01, 3.8971337102E+00, 9.8990378528E-01],
	[4.6775000000E+04, 4.8889929481E+01, 4.7098673549E+00, 4.1998828465E+01, 3.8973515158E+00, 9.8990856295E-01],
	[4.6780000000E+04, 4.8899304602E+01, 4.7099122239E+00, 4.2013691989E+01, 3.8975697643E+00, 9.8991333810E-01],
	[4.6785000000E+04, 4.8908680519E+01, 4.7099570886E+00, 4.2028559184E+01, 3.8977879569E+00, 9.8991811074E-01],
	[4.6790000000E+04, 4.8918057231E+01, 4.7100019489E+00, 4.2043430050E+01, 3.8980060937E+00, 9.8992288085E-01],
	[4.6795000000E+04, 4.8927434739E+01, 4.7100468048E+00, 4.2058304588E+01, 3.8982241746E+00, 9.8992764845E-01],
	[4.6800000000E+04, 4.8936813042E+01, 4.7100916563E+00, 4.2073182798E+01, 3.8984421997E+00, 9.8993241354E-01],
	[4.6805000000E+04, 4.8946192140E+01, 4.7101365035E+00, 4.2088064681E+01, 3.8986601691E+00, 9.8993717611E-01],
	[4.6810000000E+04, 4.8955572034E+01, 4.7101813464E+00, 4.2102950238E+01, 3.8988780826E+00, 9.8994193618E-01],
	[4.6815000000E+04, 4.8964952723E+01, 4.7102261848E+00, 4.2117839467E+01, 3.8990959404E+00, 9.8994669373E-01],
	[4.6820000000E+04, 4.8974334208E+01, 4.7102710189E+00, 4.2132732372E+01, 3.8993137425E+00, 9.8995144878E-01],
	[4.6825000000E+04, 4.8983716488E+01, 4.7103158487E+00, 4.2147628951E+01, 3.8995314888E+00, 9.8995620132E-01],
	[4.6830000000E+04, 4.8993099563E+01, 4.7103606740E+00, 4.2162529205E+01, 3.8997491795E+00, 9.8996095136E-01],
	[4.6835000000E+04, 4.9002483434E+01, 4.7104054951E+00, 4.2177433135E+01, 3.8999668144E+00, 9.8996569889E-01],
	[4.6840000000E+04, 4.9011868100E+01, 4.7104503117E+00, 4.2192340742E+01, 3.9001843937E+00, 9.8997044392E-01],
	[4.6845000000E+04, 4.9021253561E+01, 4.7104951240E+00, 4.2207252025E+01, 3.9004019174E+00, 9.8997518645E-01],
	[4.6850000000E+04, 4.9030639817E+01, 4.7105399320E+00, 4.2222166986E+01, 3.9006193854E+00, 9.8997992648E-01],
	[4.6855000000E+04, 4.9040026869E+01, 4.7105847356E+00, 4.2237085625E+01, 3.9008367978E+00, 9.8998466401E-01],
	[4.6860000000E+04, 4.9049414716E+01, 4.7106295348E+00, 4.2252007942E+01, 3.9010541546E+00, 9.8998939905E-01],
	[4.6865000000E+04, 4.9058803358E+01, 4.7106743297E+00, 4.2266933938E+01, 3.9012714559E+00, 9.8999413159E-01],
	[4.6870000000E+04, 4.9068192795E+01, 4.7107191202E+00, 4.2281863614E+01, 3.9014887016E+00, 9.8999886164E-01],
	[4.6875000000E+04, 4.9077583028E+01, 4.7107639064E+00, 4.2296796969E+01, 3.9017058918E+00, 9.9000358920E-01],
	[4.6880000000E+04, 4.9086974056E+01, 4.7108086882E+00, 4.2311734005E+01, 3.9019230264E+00, 9.9000831427E-01],
	[4.6885000000E+04, 4.9096365878E+01, 4.7108534657E+00, 4.2326674722E+01, 3.9021401056E+00, 9.9001303685E-01],
	[4.6890000000E+04, 4.9105758496E+01, 4.7108982388E+00, 4.2341619120E+01, 3.9023571293E+00, 9.9001775694E-01],
	[4.6895000000E+04, 4.9115151909E+01, 4.7109430076E+00, 4.2356567200E+01, 3.9025740975E+00, 9.9002247454E-01],
	[4.6900000000E+04, 4.9124546118E+01, 4.7109877720E+00, 4.2371518963E+01, 3.9027910103E+00, 9.9002718966E-01],
	[4.6905000000E+04, 4.9133941121E+01, 4.7110325321E+00, 4.2386474409E+01, 3.9030078676E+00, 9.9003190230E-01],
	[4.6910000000E+04, 4.9143336919E+01, 4.7110772879E+00, 4.2401433539E+01, 3.9032246696E+00, 9.9003661245E-01],
	[4.6915000000E+04, 4.9152733512E+01, 4.7111220393E+00, 4.2416396352E+01, 3.9034414161E+00, 9.9004132013E-01],
	[4.6920000000E+04, 4.9162130901E+01, 4.7111667863E+00, 4.2431362850E+01, 3.9036581073E+00, 9.9004602533E-01],
	[4.6925000000E+04, 4.9171529084E+01, 4.7112115290E+00, 4.2446333034E+01, 3.9038747432E+00, 9.9005072805E-01],
	[4.6930000000E+04, 4.9180928062E+01, 4.7112562674E+00, 4.2461306902E+01, 3.9040913237E+00, 9.9005542829E-01],
	[4.6935000000E+04, 4.9190327836E+01, 4.7113010014E+00, 4.2476284457E+01, 3.9043078489E+00, 9.9006012606E-01],
	[4.6940000000E+04, 4.9199728404E+01, 4.7113457311E+00, 4.2491265699E+01, 3.9045243188E+00, 9.9006482135E-01],
	[4.6945000000E+04, 4.9209129767E+01, 4.7113904564E+00, 4.2506250628E+01, 3.9047407334E+00, 9.9006951418E-01],
	[4.6950000000E+04, 4.9218531925E+01, 4.7114351774E+00, 4.2521239244E+01, 3.9049570928E+00, 9.9007420453E-01],
	[4.6955000000E+04, 4.9227934878E+01, 4.7114798941E+00, 4.2536231549E+01, 3.9051733970E+00, 9.9007889242E-01],
	[4.6960000000E+04, 4.9237338626E+01, 4.7115246064E+00, 4.2551227542E+01, 3.9053896459E+00, 9.9008357784E-01],
	[4.6965000000E+04, 4.9246743169E+01, 4.7115693144E+00, 4.2566227224E+01, 3.9056058396E+00, 9.9008826079E-01],
	[4.6970000000E+04, 4.9256148506E+01, 4.7116140181E+00, 4.2581230597E+01, 3.9058219781E+00, 9.9009294128E-01],
	[4.6975000000E+04, 4.9265554639E+01, 4.7116587174E+00, 4.2596237659E+01, 3.9060380615E+00, 9.9009761931E-01],
	[4.6980000000E+04, 4.9274961566E+01, 4.7117034124E+00, 4.2611248412E+01, 3.9062540897E+00, 9.9010229487E-01],
	[4.6985000000E+04, 4.9284369288E+01, 4.7117481030E+00, 4.2626262857E+01, 3.9064700628E+00, 9.9010696797E-01],
	[4.6990000000E+04, 4.9293777805E+01, 4.7117927894E+00, 4.2641280993E+01, 3.9066859808E+00, 9.9011163862E-01],
	[4.6995000000E+04, 4.9303187116E+01, 4.7118374713E+00, 4.2656302822E+01, 3.9069018436E+00, 9.9011630681E-01],
	[4.7000000000E+04, 4.9312597223E+01, 4.7118821490E+00, 4.2671328343E+01, 3.9071176515E+00, 9.9012097254E-01],
	[4.7005000000E+04, 4.9322008124E+01, 4.7119268223E+00, 4.2686357558E+01, 3.9073334042E+00, 9.9012563582E-01],
	[4.7010000000E+04, 4.9331419819E+01, 4.7119714914E+00, 4.2701390466E+01, 3.9075491019E+00, 9.9013029665E-01],
	[4.7015000000E+04, 4.9340832310E+01, 4.7120161560E+00, 4.2716427069E+01, 3.9077647446E+00, 9.9013495502E-01],
	[4.7020000000E+04, 4.9350245595E+01, 4.7120608164E+00, 4.2731467367E+01, 3.9079803323E+00, 9.9013961095E-01],
	[4.7025000000E+04, 4.9359659674E+01, 4.7121054724E+00, 4.2746511360E+01, 3.9081958651E+00, 9.9014426442E-01],
	[4.7030000000E+04, 4.9369074549E+01, 4.7121501241E+00, 4.2761559049E+01, 3.9084113428E+00, 9.9014891545E-01],
	[4.7035000000E+04, 4.9378490218E+01, 4.7121947715E+00, 4.2776610435E+01, 3.9086267656E+00, 9.9015356404E-01],
	[4.7040000000E+04, 4.9387906681E+01, 4.7122394145E+00, 4.2791665517E+01, 3.9088421335E+00, 9.9015821018E-01],
	[4.7045000000E+04, 4.9397323940E+01, 4.7122840533E+00, 4.2806724297E+01, 3.9090574465E+00, 9.9016285387E-01],
	[4.7050000000E+04, 4.9406741992E+01, 4.7123286877E+00, 4.2821786775E+01, 3.9092727046E+00, 9.9016749513E-01],
	[4.7055000000E+04, 4.9416160840E+01, 4.7123733178E+00, 4.2836852951E+01, 3.9094879078E+00, 9.9017213395E-01],
	[4.7060000000E+04, 4.9425580481E+01, 4.7124179436E+00, 4.2851922826E+01, 3.9097030561E+00, 9.9017677032E-01],
	[4.7065000000E+04, 4.9435000918E+01, 4.7124625650E+00, 4.2866996401E+01, 3.9099181496E+00, 9.9018140427E-01],
	[4.7070000000E+04, 4.9444422148E+01, 4.7125071821E+00, 4.2882073676E+01, 3.9101331883E+00, 9.9018603577E-01],
	[4.7075000000E+04, 4.9453844174E+01, 4.7125517950E+00, 4.2897154651E+01, 3.9103481722E+00, 9.9019066484E-01],
	[4.7080000000E+04, 4.9463266994E+01, 4.7125964035E+00, 4.2912239328E+01, 3.9105631014E+00, 9.9019529148E-01],
	[4.7085000000E+04, 4.9472690608E+01, 4.7126410077E+00, 4.2927327706E+01, 3.9107779757E+00, 9.9019991569E-01],
	[4.7090000000E+04, 4.9482115016E+01, 4.7126856075E+00, 4.2942419786E+01, 3.9109927953E+00, 9.9020453746E-01],
	[4.7095000000E+04, 4.9491540219E+01, 4.7127302031E+00, 4.2957515568E+01, 3.9112075602E+00, 9.9020915681E-01],
	[4.7100000000E+04, 4.9500966217E+01, 4.7127747943E+00, 4.2972615054E+01, 3.9114222704E+00, 9.9021377373E-01],
	[4.7105000000E+04, 4.9510393009E+01, 4.7128193813E+00, 4.2987718243E+01, 3.9116369259E+00, 9.9021838823E-01],
	[4.7110000000E+04, 4.9519820595E+01, 4.7128639639E+00, 4.3002825137E+01, 3.9118515267E+00, 9.9022300030E-01],
	[4.7115000000E+04, 4.9529248975E+01, 4.7129085422E+00, 4.3017935735E+01, 3.9120660729E+00, 9.9022760995E-01],
	[4.7120000000E+04, 4.9538678150E+01, 4.7129531162E+00, 4.3033050039E+01, 3.9122805644E+00, 9.9023221718E-01],
	[4.7125000000E+04, 4.9548108119E+01, 4.7129976859E+00, 4.3048168048E+01, 3.9124950013E+00, 9.9023682199E-01],
	[4.7130000000E+04, 4.9557538883E+01, 4.7130422513E+00, 4.3063289763E+01, 3.9127093836E+00, 9.9024142438E-01],
	[4.7135000000E+04, 4.9566970441E+01, 4.7130868124E+00, 4.3078415185E+01, 3.9129237113E+00, 9.9024602435E-01],
	[4.7140000000E+04, 4.9576402792E+01, 4.7131313692E+00, 4.3093544314E+01, 3.9131379845E+00, 9.9025062191E-01],
	[4.7145000000E+04, 4.9585835939E+01, 4.7131759216E+00, 4.3108677151E+01, 3.9133522031E+00, 9.9025521705E-01],
	[4.7150000000E+04, 4.9595269879E+01, 4.7132204698E+00, 4.3123813696E+01, 3.9135663672E+00, 9.9025980979E-01],
	[4.7155000000E+04, 4.9604704614E+01, 4.7132650137E+00, 4.3138953950E+01, 3.9137804768E+00, 9.9026440011E-01],
	[4.7160000000E+04, 4.9614140143E+01, 4.7133095533E+00, 4.3154097913E+01, 3.9139945319E+00, 9.9026898802E-01],
	[4.7165000000E+04, 4.9623576465E+01, 4.7133540885E+00, 4.3169245587E+01, 3.9142085325E+00, 9.9027357352E-01],
	[4.7170000000E+04, 4.9633013583E+01, 4.7133986195E+00, 4.3184396970E+01, 3.9144224787E+00, 9.9027815661E-01],
	[4.7175000000E+04, 4.9642451494E+01, 4.7134431462E+00, 4.3199552064E+01, 3.9146363704E+00, 9.9028273730E-01],
	[4.7180000000E+04, 4.9651890199E+01, 4.7134876685E+00, 4.3214710870E+01, 3.9148502077E+00, 9.9028731558E-01],
	[4.7185000000E+04, 4.9661329699E+01, 4.7135321866E+00, 4.3229873387E+01, 3.9150639906E+00, 9.9029189147E-01],
	[4.7190000000E+04, 4.9670769992E+01, 4.7135767004E+00, 4.3245039617E+01, 3.9152777192E+00, 9.9029646495E-01],
	[4.7195000000E+04, 4.9680211080E+01, 4.7136212098E+00, 4.3260209560E+01, 3.9154913933E+00, 9.9030103603E-01],
	[4.7200000000E+04, 4.9689652961E+01, 4.7136657150E+00, 4.3275383216E+01, 3.9157050132E+00, 9.9030560471E-01],
	[4.7205000000E+04, 4.9699095637E+01, 4.7137102159E+00, 4.3290560586E+01, 3.9159185787E+00, 9.9031017099E-01],
	[4.7210000000E+04, 4.9708539107E+01, 4.7137547125E+00, 4.3305741671E+01, 3.9161320898E+00, 9.9031473488E-01],
	[4.7215000000E+04, 4.9717983370E+01, 4.7137992048E+00, 4.3320926470E+01, 3.9163455467E+00, 9.9031929638E-01],
	[4.7220000000E+04, 4.9727428428E+01, 4.7138436928E+00, 4.3336114985E+01, 3.9165589494E+00, 9.9032385548E-01],
	[4.7225000000E+04, 4.9736874280E+01, 4.7138881765E+00, 4.3351307216E+01, 3.9167722977E+00, 9.9032841219E-01],
	[4.7230000000E+04, 4.9746320925E+01, 4.7139326560E+00, 4.3366503164E+01, 3.9169855919E+00, 9.9033296651E-01],
	[4.7235000000E+04, 4.9755768365E+01, 4.7139771311E+00, 4.3381702829E+01, 3.9171988318E+00, 9.9033751845E-01],
	[4.7240000000E+04, 4.9765216598E+01, 4.7140216020E+00, 4.3396906211E+01, 3.9174120175E+00, 9.9034206799E-01],
	[4.7245000000E+04, 4.9774665625E+01, 4.7140660685E+00, 4.3412113311E+01, 3.9176251490E+00, 9.9034661515E-01],
	[4.7250000000E+04, 4.9784115447E+01, 4.7141105308E+00, 4.3427324130E+01, 3.9178382264E+00, 9.9035115993E-01],
	[4.7255000000E+04, 4.9793566062E+01, 4.7141549888E+00, 4.3442538667E+01, 3.9180512496E+00, 9.9035570232E-01],
	[4.7260000000E+04, 4.9803017470E+01, 4.7141994425E+00, 4.3457756925E+01, 3.9182642187E+00, 9.9036024233E-01],
	[4.7265000000E+04, 4.9812469673E+01, 4.7142438919E+00, 4.3472978902E+01, 3.9184771337E+00, 9.9036477996E-01],
	[4.7270000000E+04, 4.9821922670E+01, 4.7142883371E+00, 4.3488204600E+01, 3.9186899945E+00, 9.9036931521E-01],
	[4.7275000000E+04, 4.9831376460E+01, 4.7143327779E+00, 4.3503434020E+01, 3.9189028013E+00, 9.9037384809E-01],
	[4.7280000000E+04, 4.9840831044E+01, 4.7143772145E+00, 4.3518667161E+01, 3.9191155541E+00, 9.9037837858E-01],
	[4.7285000000E+04, 4.9850286422E+01, 4.7144216468E+00, 4.3533904024E+01, 3.9193282528E+00, 9.9038290671E-01],
	[4.7290000000E+04, 4.9859742593E+01, 4.7144660748E+00, 4.3549144610E+01, 3.9195408975E+00, 9.9038743246E-01],
	[4.7295000000E+04, 4.9869199558E+01, 4.7145104986E+00, 4.3564388919E+01, 3.9197534882E+00, 9.9039195584E-01],
	[4.7300000000E+04, 4.9878657317E+01, 4.7145549180E+00, 4.3579636952E+01, 3.9199660249E+00, 9.9039647685E-01],
	[4.7305000000E+04, 4.9888115870E+01, 4.7145993332E+00, 4.3594888709E+01, 3.9201785076E+00, 9.9040099549E-01],
	[4.7310000000E+04, 4.9897575216E+01, 4.7146437441E+00, 4.3610144190E+01, 3.9203909364E+00, 9.9040551176E-01],
	[4.7315000000E+04, 4.9907035356E+01, 4.7146881508E+00, 4.3625403398E+01, 3.9206033113E+00, 9.9041002567E-01],
	[4.7320000000E+04, 4.9916496290E+01, 4.7147325531E+00, 4.3640666330E+01, 3.9208156322E+00, 9.9041453721E-01],
	[4.7325000000E+04, 4.9925958017E+01, 4.7147769512E+00, 4.3655932990E+01, 3.9210278993E+00, 9.9041904639E-01],
	[4.7330000000E+04, 4.9935420537E+01, 4.7148213450E+00, 4.3671203376E+01, 3.9212401124E+00, 9.9042355321E-01],
	[4.7335000000E+04, 4.9944883852E+01, 4.7148657346E+00, 4.3686477489E+01, 3.9214522718E+00, 9.9042805767E-01],
	[4.7340000000E+04, 4.9954347960E+01, 4.7149101199E+00, 4.3701755330E+01, 3.9216643772E+00, 9.9043255976E-01],
	[4.7345000000E+04, 4.9963812861E+01, 4.7149545009E+00, 4.3717036900E+01, 3.9218764289E+00, 9.9043705951E-01],
	[4.7350000000E+04, 4.9973278556E+01, 4.7149988776E+00, 4.3732322198E+01, 3.9220884267E+00, 9.9044155689E-01],
	[4.7355000000E+04, 4.9982745045E+01, 4.7150432501E+00, 4.3747611226E+01, 3.9223003708E+00, 9.9044605192E-01],
	[4.7360000000E+04, 4.9992212326E+01, 4.7150876183E+00, 4.3762903984E+01, 3.9225122610E+00, 9.9045054459E-01],
	[4.7365000000E+04, 5.0001680402E+01, 4.7151319822E+00, 4.3778200472E+01, 3.9227240976E+00, 9.9045503492E-01],
	[4.7370000000E+04, 5.0011149271E+01, 4.7151763419E+00, 4.3793500691E+01, 3.9229358804E+00, 9.9045952289E-01],
	[4.7375000000E+04, 5.0020618933E+01, 4.7152206973E+00, 4.3808804642E+01, 3.9231476095E+00, 9.9046400852E-01],
	[4.7380000000E+04, 5.0030089389E+01, 4.7152650484E+00, 4.3824112324E+01, 3.9233592848E+00, 9.9046849179E-01],
	[4.7385000000E+04, 5.0039560638E+01, 4.7153093953E+00, 4.3839423740E+01, 3.9235709065E+00, 9.9047297272E-01],
	[4.7390000000E+04, 5.0049032681E+01, 4.7153537379E+00, 4.3854738888E+01, 3.9237824746E+00, 9.9047745131E-01],
	[4.7395000000E+04, 5.0058505516E+01, 4.7153980763E+00, 4.3870057769E+01, 3.9239939890E+00, 9.9048192755E-01],
	[4.7400000000E+04, 5.0067979146E+01, 4.7154424103E+00, 4.3885380385E+01, 3.9242054497E+00, 9.9048640145E-01],
	[4.7405000000E+04, 5.0077453568E+01, 4.7154867402E+00, 4.3900706735E+01, 3.9244168569E+00, 9.9049087301E-01],
	[4.7410000000E+04, 5.0086928784E+01, 4.7155310658E+00, 4.3916036821E+01, 3.9246282105E+00, 9.9049534223E-01],
	[4.7415000000E+04, 5.0096404793E+01, 4.7155753871E+00, 4.3931370642E+01, 3.9248395105E+00, 9.9049980911E-01],
	[4.7420000000E+04, 5.0105881596E+01, 4.7156197041E+00, 4.3946708199E+01, 3.9250507569E+00, 9.9050427365E-01],
	[4.7425000000E+04, 5.0115359192E+01, 4.7156640169E+00, 4.3962049492E+01, 3.9252619498E+00, 9.9050873586E-01],
	[4.7430000000E+04, 5.0124837581E+01, 4.7157083255E+00, 4.3977394523E+01, 3.9254730892E+00, 9.9051319574E-01],
	[4.7435000000E+04, 5.0134316763E+01, 4.7157526298E+00, 4.3992743292E+01, 3.9256841751E+00, 9.9051765330E-01],
	[4.7440000000E+04, 5.0143796739E+01, 4.7157969298E+00, 4.4008095798E+01, 3.9258952075E+00, 9.9052210853E-01],
	[4.7445000000E+04, 5.0153277507E+01, 4.7158412256E+00, 4.4023452044E+01, 3.9261061864E+00, 9.9052656145E-01],
	[4.7450000000E+04, 5.0162759069E+01, 4.7158855171E+00, 4.4038812028E+01, 3.9263171119E+00, 9.9053101205E-01],
	[4.7455000000E+04, 5.0172241424E+01, 4.7159298044E+00, 4.4054175753E+01, 3.9265279839E+00, 9.9053546033E-01],
	[4.7460000000E+04, 5.0181724572E+01, 4.7159740874E+00, 4.4069543217E+01, 3.9267388026E+00, 9.9053990630E-01],
	[4.7465000000E+04, 5.0191208514E+01, 4.7160183662E+00, 4.4084914423E+01, 3.9269495678E+00, 9.9054434995E-01],
	[4.7470000000E+04, 5.0200693248E+01, 4.7160626408E+00, 4.4100289369E+01, 3.9271602797E+00, 9.9054879129E-01],
	[4.7475000000E+04, 5.0210178775E+01, 4.7161069111E+00, 4.4115668057E+01, 3.9273709382E+00, 9.9055323031E-01],
	[4.7480000000E+04, 5.0219665096E+01, 4.7161511771E+00, 4.4131050488E+01, 3.9275815433E+00, 9.9055766703E-01],
	[4.7485000000E+04, 5.0229152210E+01, 4.7161954389E+00, 4.4146436662E+01, 3.9277920952E+00, 9.9056210144E-01],
	[4.7490000000E+04, 5.0238640116E+01, 4.7162396964E+00, 4.4161826579E+01, 3.9280025937E+00, 9.9056653353E-01],
	[4.7495000000E+04, 5.0248128816E+01, 4.7162839498E+00, 4.4177220239E+01, 3.9282130389E+00, 9.9057096332E-01],
	[4.7500000000E+04, 5.0257618309E+01, 4.7163281988E+00, 4.4192617644E+01, 3.9284234309E+00, 9.9057539080E-01],
	[4.7505000000E+04, 5.0267108594E+01, 4.7163724436E+00, 4.4208018794E+01, 3.9286337696E+00, 9.9057981598E-01],
	[4.7510000000E+04, 5.0276599673E+01, 4.7164166842E+00, 4.4223423690E+01, 3.9288440551E+00, 9.9058423886E-01],
	[4.7515000000E+04, 5.0286091545E+01, 4.7164609206E+00, 4.4238832331E+01, 3.9290542874E+00, 9.9058865943E-01],
	[4.7520000000E+04, 5.0295584209E+01, 4.7165051526E+00, 4.4254244719E+01, 3.9292644664E+00, 9.9059307770E-01],
	[4.7525000000E+04, 5.0305077667E+01, 4.7165493805E+00, 4.4269660853E+01, 3.9294745923E+00, 9.9059749366E-01],
	[4.7530000000E+04, 5.0314589278E+01, 4.7165950616E+00, 4.4285080735E+01, 3.9296857826E+00, 9.9060190733E-01],
	[4.7535000000E+04, 5.0324102128E+01, 4.7166407752E+00, 4.4300504366E+01, 3.9298969482E+00, 9.9060631870E-01],
	[4.7540000000E+04, 5.0333615775E+01, 4.7166864845E+00, 4.4315931744E+01, 3.9301080607E+00, 9.9061072778E-01],
	[4.7545000000E+04, 5.0343130220E+01, 4.7167321895E+00, 4.4331362872E+01, 3.9303191201E+00, 9.9061513455E-01],
	[4.7550000000E+04, 5.0352645463E+01, 4.7167778900E+00, 4.4346797749E+01, 3.9305301266E+00, 9.9061953903E-01],
	[4.7555000000E+04, 5.0362161503E+01, 4.7168235862E+00, 4.4362236376E+01, 3.9307410800E+00, 9.9062394122E-01],
	[4.7560000000E+04, 5.0371678341E+01, 4.7168692781E+00, 4.4377678754E+01, 3.9309519804E+00, 9.9062834112E-01],
	[4.7565000000E+04, 5.0381195976E+01, 4.7169149656E+00, 4.4393124883E+01, 3.9311628278E+00, 9.9063273872E-01],
	[4.7570000000E+04, 5.0390714410E+01, 4.7169606487E+00, 4.4408574764E+01, 3.9313736223E+00, 9.9063713404E-01],
	[4.7575000000E+04, 5.0400233640E+01, 4.7170063274E+00, 4.4424028396E+01, 3.9315843639E+00, 9.9064152706E-01],
	[4.7580000000E+04, 5.0409753669E+01, 4.7170520018E+00, 4.4439485782E+01, 3.9317950525E+00, 9.9064591780E-01],
	[4.7585000000E+04, 5.0419274495E+01, 4.7170976719E+00, 4.4454946920E+01, 3.9320056882E+00, 9.9065030625E-01],
	[4.7590000000E+04, 5.0428796118E+01, 4.7171433376E+00, 4.4470411812E+01, 3.9322162710E+00, 9.9065469242E-01],
	[4.7595000000E+04, 5.0438318539E+01, 4.7171889989E+00, 4.4485880459E+01, 3.9324268009E+00, 9.9065907630E-01],
	[4.7600000000E+04, 5.0447841758E+01, 4.7172346559E+00, 4.4501352860E+01, 3.9326372780E+00, 9.9066345790E-01],
	[4.7605000000E+04, 5.0457365774E+01, 4.7172803085E+00, 4.4516829016E+01, 3.9328477023E+00, 9.9066783721E-01],
	[4.7610000000E+04, 5.0466890588E+01, 4.7173259568E+00, 4.4532308928E+01, 3.9330580737E+00, 9.9067221425E-01],
	[4.7615000000E+04, 5.0476416199E+01, 4.7173716007E+00, 4.4547792596E+01, 3.9332683924E+00, 9.9067658900E-01],
	[4.7620000000E+04, 5.0485942607E+01, 4.7174172403E+00, 4.4563280021E+01, 3.9334786582E+00, 9.9068096148E-01],
	[4.7625000000E+04, 5.0495469813E+01, 4.7174628755E+00, 4.4578771203E+01, 3.9336888713E+00, 9.9068533167E-01],
	[4.7630000000E+04, 5.0504997816E+01, 4.7175085064E+00, 4.4594266143E+01, 3.9338990316E+00, 9.9068969960E-01],
	[4.7635000000E+04, 5.0514526617E+01, 4.7175541329E+00, 4.4609764842E+01, 3.9341091392E+00, 9.9069406524E-01],
	[4.7640000000E+04, 5.0524056215E+01, 4.7175997551E+00, 4.4625267299E+01, 3.9343191941E+00, 9.9069842862E-01],
	[4.7645000000E+04, 5.0533586611E+01, 4.7176453729E+00, 4.4640773516E+01, 3.9345291963E+00, 9.9070278972E-01],
	[4.7650000000E+04, 5.0543117803E+01, 4.7176909864E+00, 4.4656283492E+01, 3.9347391458E+00, 9.9070714855E-01],
	[4.7655000000E+04, 5.0552649794E+01, 4.7177365955E+00, 4.4671797229E+01, 3.9349490426E+00, 9.9071150510E-01],
	[4.7660000000E+04, 5.0562182581E+01, 4.7177822003E+00, 4.4687314727E+01, 3.9351588868E+00, 9.9071585939E-01],
	[4.7665000000E+04, 5.0571716166E+01, 4.7178278008E+00, 4.4702835986E+01, 3.9353686784E+00, 9.9072021141E-01],
	[4.7670000000E+04, 5.0581250548E+01, 4.7178733969E+00, 4.4718361007E+01, 3.9355784174E+00, 9.9072456117E-01],
	[4.7675000000E+04, 5.0590785727E+01, 4.7179189886E+00, 4.4733889791E+01, 3.9357881037E+00, 9.9072890865E-01],
	[4.7680000000E+04, 5.0600321704E+01, 4.7179645761E+00, 4.4749422337E+01, 3.9359977375E+00, 9.9073325388E-01],
	[4.7685000000E+04, 5.0609858478E+01, 4.7180101591E+00, 4.4764958648E+01, 3.9362073188E+00, 9.9073759683E-01],
	[4.7690000000E+04, 5.0619396049E+01, 4.7180557379E+00, 4.4780498722E+01, 3.9364168475E+00, 9.9074193753E-01],
	[4.7695000000E+04, 5.0628934417E+01, 4.7181013123E+00, 4.4796042560E+01, 3.9366263237E+00, 9.9074627597E-01],
	[4.7700000000E+04, 5.0638473582E+01, 4.7181468824E+00, 4.4811590164E+01, 3.9368357473E+00, 9.9075061214E-01],
	[4.7705000000E+04, 5.0648013545E+01, 4.7181924481E+00, 4.4827141533E+01, 3.9370451185E+00, 9.9075494606E-01],
	[4.7710000000E+04, 5.0657554304E+01, 4.7182380095E+00, 4.4842696668E+01, 3.9372544372E+00, 9.9075927772E-01],
	[4.7715000000E+04, 5.0667095861E+01, 4.7182835666E+00, 4.4858255570E+01, 3.9374637035E+00, 9.9076360712E-01],
	[4.7720000000E+04, 5.0676638215E+01, 4.7183291193E+00, 4.4873818239E+01, 3.9376729173E+00, 9.9076793426E-01],
	[4.7725000000E+04, 5.0686181366E+01, 4.7183746677E+00, 4.4889384676E+01, 3.9378820787E+00, 9.9077225916E-01],
	[4.7730000000E+04, 5.0695725314E+01, 4.7184202117E+00, 4.4904954881E+01, 3.9380911877E+00, 9.9077658180E-01],
	[4.7735000000E+04, 5.0705270060E+01, 4.7184657515E+00, 4.4920528854E+01, 3.9383002443E+00, 9.9078090218E-01],
	[4.7740000000E+04, 5.0714815602E+01, 4.7185112869E+00, 4.4936106597E+01, 3.9385092486E+00, 9.9078522032E-01],
	[4.7745000000E+04, 5.0724361941E+01, 4.7185568180E+00, 4.4951688109E+01, 3.9387182005E+00, 9.9078953621E-01],
	[4.7750000000E+04, 5.0733909077E+01, 4.7186023447E+00, 4.4967273392E+01, 3.9389271001E+00, 9.9079384984E-01],
	[4.7755000000E+04, 5.0743457011E+01, 4.7186478671E+00, 4.4982862445E+01, 3.9391359473E+00, 9.9079816123E-01],
	[4.7760000000E+04, 5.0753005741E+01, 4.7186933852E+00, 4.4998455270E+01, 3.9393447423E+00, 9.9080247038E-01],
	[4.7765000000E+04, 5.0762555268E+01, 4.7187388990E+00, 4.5014051866E+01, 3.9395534850E+00, 9.9080677728E-01],
	[4.7770000000E+04, 5.0772105592E+01, 4.7187844084E+00, 4.5029652235E+01, 3.9397621754E+00, 9.9081108193E-01],
	[4.7775000000E+04, 5.0781656713E+01, 4.7188299135E+00, 4.5045256376E+01, 3.9399708136E+00, 9.9081538435E-01],
	[4.7780000000E+04, 5.0791208631E+01, 4.7188754143E+00, 4.5060864291E+01, 3.9401793995E+00, 9.9081968452E-01],
	[4.7785000000E+04, 5.0800761346E+01, 4.7189209108E+00, 4.5076475979E+01, 3.9403879333E+00, 9.9082398245E-01],
	[4.7790000000E+04, 5.0810314858E+01, 4.7189664029E+00, 4.5092091442E+01, 3.9405964148E+00, 9.9082827814E-01],
	[4.7795000000E+04, 5.0819869166E+01, 4.7190118908E+00, 4.5107710680E+01, 3.9408048442E+00, 9.9083257159E-01],
	[4.7800000000E+04, 5.0829424272E+01, 4.7190573743E+00, 4.5123333693E+01, 3.9410132214E+00, 9.9083686281E-01],
	[4.7805000000E+04, 5.0838980174E+01, 4.7191028534E+00, 4.5138960482E+01, 3.9412215465E+00, 9.9084115179E-01],
	[4.7810000000E+04, 5.0848536873E+01, 4.7191483283E+00, 4.5154591048E+01, 3.9414298194E+00, 9.9084543854E-01],
	[4.7815000000E+04, 5.0858094369E+01, 4.7191937989E+00, 4.5170225390E+01, 3.9416380403E+00, 9.9084972305E-01],
	[4.7820000000E+04, 5.0867652662E+01, 4.7192392651E+00, 4.5185863510E+01, 3.9418462090E+00, 9.9085400533E-01],
	[4.7825000000E+04, 5.0877211751E+01, 4.7192847270E+00, 4.5201505408E+01, 3.9420543257E+00, 9.9085828538E-01],
	[4.7830000000E+04, 5.0886771637E+01, 4.7193301846E+00, 4.5217151084E+01, 3.9422623903E+00, 9.9086256320E-01],
	[4.7835000000E+04, 5.0896332320E+01, 4.7193756379E+00, 4.5232800540E+01, 3.9424704029E+00, 9.9086683879E-01],
	[4.7840000000E+04, 5.0905893799E+01, 4.7194210869E+00, 4.5248453775E+01, 3.9426783635E+00, 9.9087111215E-01],
	[4.7845000000E+04, 5.0915456076E+01, 4.7194665316E+00, 4.5264110790E+01, 3.9428862721E+00, 9.9087538329E-01],
	[4.7850000000E+04, 5.0925019149E+01, 4.7195119719E+00, 4.5279771585E+01, 3.9430941287E+00, 9.9087965220E-01],
	[4.7855000000E+04, 5.0934583018E+01, 4.7195574079E+00, 4.5295436162E+01, 3.9433019333E+00, 9.9088391889E-01],
	[4.7860000000E+04, 5.0944147684E+01, 4.7196028397E+00, 4.5311104520E+01, 3.9435096859E+00, 9.9088818335E-01],
	[4.7865000000E+04, 5.0953713147E+01, 4.7196482671E+00, 4.5326776660E+01, 3.9437173867E+00, 9.9089244559E-01],
	[4.7870000000E+04, 5.0963279407E+01, 4.7196936902E+00, 4.5342452583E+01, 3.9439250355E+00, 9.9089670561E-01],
	[4.7875000000E+04, 5.0972846463E+01, 4.7197391090E+00, 4.5358132289E+01, 3.9441326324E+00, 9.9090096341E-01],
	[4.7880000000E+04, 5.0982414315E+01, 4.7197845235E+00, 4.5373815779E+01, 3.9443401774E+00, 9.9090521900E-01],
	[4.7885000000E+04, 5.0991982965E+01, 4.7198299337E+00, 4.5389503053E+01, 3.9445476706E+00, 9.9090947236E-01],
	[4.7890000000E+04, 5.1001552410E+01, 4.7198753396E+00, 4.5405194112E+01, 3.9447551119E+00, 9.9091372351E-01],
	[4.7895000000E+04, 5.1011122652E+01, 4.7199207412E+00, 4.5420888956E+01, 3.9449625014E+00, 9.9091797245E-01],
	[4.7900000000E+04, 5.1020693691E+01, 4.7199661385E+00, 4.5436587585E+01, 3.9451698391E+00, 9.9092221917E-01],
	[4.7905000000E+04, 5.1030265526E+01, 4.7200115315E+00, 4.5452290001E+01, 3.9453771250E+00, 9.9092646368E-01],
	[4.7910000000E+04, 5.1039838158E+01, 4.7200569202E+00, 4.5467996204E+01, 3.9455843591E+00, 9.9093070597E-01],
	[4.7915000000E+04, 5.1049411586E+01, 4.7201023046E+00, 4.5483706194E+01, 3.9457915414E+00, 9.9093494606E-01],
	[4.7920000000E+04, 5.1058985811E+01, 4.7201476846E+00, 4.5499419972E+01, 3.9459986720E+00, 9.9093918394E-01],
	[4.7925000000E+04, 5.1068560832E+01, 4.7201930604E+00, 4.5515137538E+01, 3.9462057508E+00, 9.9094341961E-01],
	[4.7930000000E+04, 5.1078136649E+01, 4.7202384319E+00, 4.5530858893E+01, 3.9464127780E+00, 9.9094765307E-01],
	[4.7935000000E+04, 5.1087713263E+01, 4.7202837991E+00, 4.5546584037E+01, 3.9466197535E+00, 9.9095188433E-01],
	[4.7940000000E+04, 5.1097290673E+01, 4.7203291620E+00, 4.5562312971E+01, 3.9468266772E+00, 9.9095611338E-01],
	[4.7945000000E+04, 5.1106868879E+01, 4.7203745206E+00, 4.5578045696E+01, 3.9470335494E+00, 9.9096034023E-01],
	[4.7950000000E+04, 5.1116447882E+01, 4.7204198749E+00, 4.5593782212E+01, 3.9472403699E+00, 9.9096456488E-01],
	[4.7955000000E+04, 5.1126027681E+01, 4.7204652249E+00, 4.5609522519E+01, 3.9474471387E+00, 9.9096878732E-01],
	[4.7960000000E+04, 5.1135608277E+01, 4.7205105706E+00, 4.5625266618E+01, 3.9476538560E+00, 9.9097300757E-01],
	[4.7965000000E+04, 5.1145189669E+01, 4.7205559121E+00, 4.5641014509E+01, 3.9478605216E+00, 9.9097722562E-01],
	[4.7970000000E+04, 5.1154771857E+01, 4.7206012492E+00, 4.5656766193E+01, 3.9480671357E+00, 9.9098144147E-01],
	[4.7975000000E+04, 5.1164354841E+01, 4.7206465820E+00, 4.5672521671E+01, 3.9482736982E+00, 9.9098565512E-01],
	[4.7980000000E+04, 5.1173938621E+01, 4.7206919106E+00, 4.5688280943E+01, 3.9484802092E+00, 9.9098986658E-01],
	[4.7985000000E+04, 5.1183523198E+01, 4.7207372349E+00, 4.5704044010E+01, 3.9486866687E+00, 9.9099407584E-01],
	[4.7990000000E+04, 5.1193108571E+01, 4.7207825549E+00, 4.5719810871E+01, 3.9488930767E+00, 9.9099828291E-01],
	[4.7995000000E+04, 5.1202694740E+01, 4.7208278706E+00, 4.5735581529E+01, 3.9490994331E+00, 9.9100248779E-01],
	[4.8000000000E+04, 5.1212281705E+01, 4.7208731820E+00, 4.5751355982E+01, 3.9493057381E+00, 9.9100669048E-01],
	[4.8005000000E+04, 5.1221869467E+01, 4.7209184891E+00, 4.5767134232E+01, 3.9495119917E+00, 9.9101089098E-01],
	[4.8010000000E+04, 5.1231458024E+01, 4.7209637919E+00, 4.5782916279E+01, 3.9497181938E+00, 9.9101508929E-01],
	[4.8015000000E+04, 5.1241047378E+01, 4.7210090905E+00, 4.5798702123E+01, 3.9499243445E+00, 9.9101928541E-01],
	[4.8020000000E+04, 5.1250637528E+01, 4.7210543848E+00, 4.5814491766E+01, 3.9501304438E+00, 9.9102347935E-01],
	[4.8025000000E+04, 5.1260228474E+01, 4.7210996748E+00, 4.5830285208E+01, 3.9503364917E+00, 9.9102767110E-01],
	[4.8030000000E+04, 5.1269820215E+01, 4.7211449605E+00, 4.5846082449E+01, 3.9505424882E+00, 9.9103186067E-01],
	[4.8035000000E+04, 5.1279412753E+01, 4.7211902419E+00, 4.5861883489E+01, 3.9507484334E+00, 9.9103604806E-01],
	[4.8040000000E+04, 5.1289006087E+01, 4.7212355191E+00, 4.5877688330E+01, 3.9509543273E+00, 9.9104023326E-01],
	[4.8045000000E+04, 5.1298600217E+01, 4.7212807919E+00, 4.5893496971E+01, 3.9511601698E+00, 9.9104441629E-01],
	[4.8050000000E+04, 5.1308195143E+01, 4.7213260605E+00, 4.5909309414E+01, 3.9513659610E+00, 9.9104859713E-01],
	[4.8055000000E+04, 5.1317790865E+01, 4.7213713249E+00, 4.5925125659E+01, 3.9515717010E+00, 9.9105277580E-01],
	[4.8060000000E+04, 5.1327387383E+01, 4.7214165849E+00, 4.5940945706E+01, 3.9517773896E+00, 9.9105695229E-01],
	[4.8065000000E+04, 5.1336984697E+01, 4.7214618407E+00, 4.5956769555E+01, 3.9519830271E+00, 9.9106112661E-01],
	[4.8070000000E+04, 5.1346582807E+01, 4.7215070922E+00, 4.5972597208E+01, 3.9521886133E+00, 9.9106529875E-01],
	[4.8075000000E+04, 5.1356181713E+01, 4.7215523394E+00, 4.5988428665E+01, 3.9523941482E+00, 9.9106946872E-01],
	[4.8080000000E+04, 5.1365781414E+01, 4.7215975824E+00, 4.6004263927E+01, 3.9525996320E+00, 9.9107363651E-01],
	[4.8085000000E+04, 5.1375381912E+01, 4.7216428211E+00, 4.6020102993E+01, 3.9528050646E+00, 9.9107780214E-01],
	[4.8090000000E+04, 5.1384983205E+01, 4.7216880555E+00, 4.6035945865E+01, 3.9530104461E+00, 9.9108196559E-01],
	[4.8095000000E+04, 5.1394585295E+01, 4.7217332856E+00, 4.6051792542E+01, 3.9532157763E+00, 9.9108612688E-01],
	[4.8100000000E+04, 5.1404188180E+01, 4.7217785115E+00, 4.6067643026E+01, 3.9534210555E+00, 9.9109028599E-01],
	[4.8105000000E+04, 5.1413791861E+01, 4.7218237331E+00, 4.6083497318E+01, 3.9536262835E+00, 9.9109444295E-01],
	[4.8110000000E+04, 5.1423396337E+01, 4.7218689504E+00, 4.6099355416E+01, 3.9538314605E+00, 9.9109859773E-01],
	[4.8115000000E+04, 5.1433001610E+01, 4.7219141635E+00, 4.6115217323E+01, 3.9540365864E+00, 9.9110275035E-01],
	[4.8120000000E+04, 5.1442607678E+01, 4.7219593723E+00, 4.6131083038E+01, 3.9542416612E+00, 9.9110690081E-01],
	[4.8125000000E+04, 5.1452214542E+01, 4.7220045769E+00, 4.6146952562E+01, 3.9544466849E+00, 9.9111104911E-01],
	[4.8130000000E+04, 5.1461822202E+01, 4.7220497771E+00, 4.6162825896E+01, 3.9546516576E+00, 9.9111519525E-01],
	[4.8135000000E+04, 5.1471430657E+01, 4.7220949732E+00, 4.6178703040E+01, 3.9548565793E+00, 9.9111933923E-01],
	[4.8140000000E+04, 5.1481039908E+01, 4.7221401649E+00, 4.6194583994E+01, 3.9550614501E+00, 9.9112348105E-01],
	[4.8145000000E+04, 5.1490649955E+01, 4.7221853524E+00, 4.6210468760E+01, 3.9552662698E+00, 9.9112762071E-01],
	[4.8150000000E+04, 5.1500260797E+01, 4.7222305356E+00, 4.6226357337E+01, 3.9554710386E+00, 9.9113175821E-01],
	[4.8155000000E+04, 5.1509872435E+01, 4.7222757146E+00, 4.6242249727E+01, 3.9556757564E+00, 9.9113589357E-01],
	[4.8160000000E+04, 5.1519484869E+01, 4.7223208893E+00, 4.6258145929E+01, 3.9558804233E+00, 9.9114002676E-01],
	[4.8165000000E+04, 5.1529098098E+01, 4.7223660598E+00, 4.6274045944E+01, 3.9560850393E+00, 9.9114415781E-01],
	[4.8170000000E+04, 5.1538712123E+01, 4.7224112260E+00, 4.6289949774E+01, 3.9562896044E+00, 9.9114828670E-01],
	[4.8175000000E+04, 5.1548326944E+01, 4.7224563879E+00, 4.6305857417E+01, 3.9564941186E+00, 9.9115241344E-01],
	[4.8180000000E+04, 5.1557942560E+01, 4.7225015456E+00, 4.6321768875E+01, 3.9566985820E+00, 9.9115653804E-01],
	[4.8185000000E+04, 5.1567558972E+01, 4.7225466991E+00, 4.6337684148E+01, 3.9569029945E+00, 9.9116066049E-01],
	[4.8190000000E+04, 5.1577176179E+01, 4.7225918482E+00, 4.6353603238E+01, 3.9571073562E+00, 9.9116478078E-01],
	[4.8195000000E+04, 5.1586794181E+01, 4.7226369932E+00, 4.6369526143E+01, 3.9573116670E+00, 9.9116889894E-01],
	[4.8200000000E+04, 5.1596412980E+01, 4.7226821339E+00, 4.6385452865E+01, 3.9575159271E+00, 9.9117301495E-01],
	[4.8205000000E+04, 5.1606032573E+01, 4.7227272703E+00, 4.6401383405E+01, 3.9577201364E+00, 9.9117712881E-01],
	[4.8210000000E+04, 5.1615652962E+01, 4.7227724025E+00, 4.6417317763E+01, 3.9579242950E+00, 9.9118124054E-01],
	[4.8215000000E+04, 5.1625274147E+01, 4.7228175304E+00, 4.6433255939E+01, 3.9581284028E+00, 9.9118535012E-01],
	[4.8220000000E+04, 5.1634896127E+01, 4.7228626541E+00, 4.6449197934E+01, 3.9583324599E+00, 9.9118945756E-01],
	[4.8225000000E+04, 5.1644518902E+01, 4.7229077735E+00, 4.6465143748E+01, 3.9585364662E+00, 9.9119356287E-01],
	[4.8230000000E+04, 5.1654142473E+01, 4.7229528887E+00, 4.6481093382E+01, 3.9587404219E+00, 9.9119766603E-01],
	[4.8235000000E+04, 5.1663766839E+01, 4.7229979996E+00, 4.6497046837E+01, 3.9589443269E+00, 9.9120176706E-01],
	[4.8240000000E+04, 5.1673392001E+01, 4.7230431063E+00, 4.6513004113E+01, 3.9591481812E+00, 9.9120586596E-01],
	[4.8245000000E+04, 5.1683017958E+01, 4.7230882088E+00, 4.6528965210E+01, 3.9593519849E+00, 9.9120996272E-01],
	[4.8250000000E+04, 5.1692644710E+01, 4.7231333070E+00, 4.6544930129E+01, 3.9595557380E+00, 9.9121405735E-01],
	[4.8255000000E+04, 5.1702272257E+01, 4.7231784009E+00, 4.6560898871E+01, 3.9597594405E+00, 9.9121814984E-01],
	[4.8260000000E+04, 5.1711900600E+01, 4.7232234907E+00, 4.6576871436E+01, 3.9599630924E+00, 9.9122224021E-01],
	[4.8265000000E+04, 5.1721529738E+01, 4.7232685761E+00, 4.6592847825E+01, 3.9601666937E+00, 9.9122632844E-01],
	[4.8270000000E+04, 5.1731159672E+01, 4.7233136574E+00, 4.6608828037E+01, 3.9603702444E+00, 9.9123041455E-01],
	[4.8275000000E+04, 5.1740790400E+01, 4.7233587344E+00, 4.6624812074E+01, 3.9605737446E+00, 9.9123449853E-01],
	[4.8280000000E+04, 5.1750421924E+01, 4.7234038071E+00, 4.6640799937E+01, 3.9607771943E+00, 9.9123858038E-01],
	[4.8285000000E+04, 5.1760054243E+01, 4.7234488757E+00, 4.6656791625E+01, 3.9609805934E+00, 9.9124266011E-01],
	[4.8290000000E+04, 5.1769687357E+01, 4.7234939399E+00, 4.6672787139E+01, 3.9611839421E+00, 9.9124673771E-01],
	[4.8295000000E+04, 5.1779338347E+01, 4.7235404021E+00, 4.6688786480E+01, 3.9613883264E+00, 9.9125081320E-01],
	[4.8300000000E+04, 5.1788990899E+01, 4.7235869224E+00, 4.6704789648E+01, 3.9615927087E+00, 9.9125488656E-01],
	[4.8305000000E+04, 5.1798644251E+01, 4.7236334383E+00, 4.6720796644E+01, 3.9617970407E+00, 9.9125895780E-01],
	[4.8310000000E+04, 5.1808298402E+01, 4.7236799499E+00, 4.6736807468E+01, 3.9620013222E+00, 9.9126302692E-01],
	[4.8315000000E+04, 5.1817953354E+01, 4.7237264571E+00, 4.6752822121E+01, 3.9622055535E+00, 9.9126709392E-01],
	[4.8320000000E+04, 5.1827609105E+01, 4.7237729600E+00, 4.6768840603E+01, 3.9624097343E+00, 9.9127115881E-01],
	[4.8325000000E+04, 5.1837265656E+01, 4.7238194585E+00, 4.6784862915E+01, 3.9626138649E+00, 9.9127522158E-01],
	[4.8330000000E+04, 5.1846923007E+01, 4.7238659526E+00, 4.6800889057E+01, 3.9628179452E+00, 9.9127928223E-01],
	[4.8335000000E+04, 5.1856581158E+01, 4.7239124424E+00, 4.6816919031E+01, 3.9630219752E+00, 9.9128334077E-01],
	[4.8340000000E+04, 5.1866240109E+01, 4.7239589279E+00, 4.6832952835E+01, 3.9632259549E+00, 9.9128739720E-01],
	[4.8345000000E+04, 5.1875899859E+01, 4.7240054090E+00, 4.6848990472E+01, 3.9634298843E+00, 9.9129145152E-01],
	[4.8350000000E+04, 5.1885560410E+01, 4.7240518858E+00, 4.6865031940E+01, 3.9636337636E+00, 9.9129550373E-01],
	[4.8355000000E+04, 5.1895221760E+01, 4.7240983582E+00, 4.6881077242E+01, 3.9638375926E+00, 9.9129955383E-01],
	[4.8360000000E+04, 5.1904883910E+01, 4.7241448262E+00, 4.6897126377E+01, 3.9640413714E+00, 9.9130360182E-01],
	[4.8365000000E+04, 5.1914546859E+01, 4.7241912899E+00, 4.6913179347E+01, 3.9642451000E+00, 9.9130764770E-01],
	[4.8370000000E+04, 5.1924210609E+01, 4.7242377493E+00, 4.6929236150E+01, 3.9644487785E+00, 9.9131169148E-01],
	[4.8375000000E+04, 5.1933875158E+01, 4.7242842043E+00, 4.6945296789E+01, 3.9646524068E+00, 9.9131573316E-01],
	[4.8380000000E+04, 5.1943540506E+01, 4.7243306550E+00, 4.6961361263E+01, 3.9648559849E+00, 9.9131977273E-01],
	[4.8385000000E+04, 5.1953206655E+01, 4.7243771013E+00, 4.6977429574E+01, 3.9650595130E+00, 9.9132381020E-01],
	[4.8390000000E+04, 5.1962873603E+01, 4.7244235433E+00, 4.6993501720E+01, 3.9652629909E+00, 9.9132784557E-01],
	[4.8395000000E+04, 5.1972541351E+01, 4.7244699810E+00, 4.7009577704E+01, 3.9654664188E+00, 9.9133187884E-01],
	[4.8400000000E+04, 5.1982209898E+01, 4.7245164143E+00, 4.7025657526E+01, 3.9656697966E+00, 9.9133591001E-01],
	[4.8405000000E+04, 5.1991879245E+01, 4.7245628432E+00, 4.7041741185E+01, 3.9658731243E+00, 9.9133993908E-01],
	[4.8410000000E+04, 5.2001549392E+01, 4.7246092679E+00, 4.7057828684E+01, 3.9660764020E+00, 9.9134396606E-01],
	[4.8415000000E+04, 5.2011220338E+01, 4.7246556881E+00, 4.7073920021E+01, 3.9662796297E+00, 9.9134799094E-01],
	[4.8420000000E+04, 5.2020892083E+01, 4.7247021041E+00, 4.7090015198E+01, 3.9664828074E+00, 9.9135201373E-01],
	[4.8425000000E+04, 5.2030564629E+01, 4.7247485157E+00, 4.7106114216E+01, 3.9666859351E+00, 9.9135603442E-01],
	[4.8430000000E+04, 5.2040237973E+01, 4.7247949230E+00, 4.7122217074E+01, 3.9668890128E+00, 9.9136005303E-01],
	[4.8435000000E+04, 5.2049912118E+01, 4.7248413259E+00, 4.7138323773E+01, 3.9670920406E+00, 9.9136406954E-01],
	[4.8440000000E+04, 5.2059587062E+01, 4.7248877245E+00, 4.7154434314E+01, 3.9672950184E+00, 9.9136808396E-01],
	[4.8445000000E+04, 5.2069262805E+01, 4.7249341188E+00, 4.7170548698E+01, 3.9674979463E+00, 9.9137209630E-01],
	[4.8450000000E+04, 5.2078939348E+01, 4.7249805087E+00, 4.7186666924E+01, 3.9677008244E+00, 9.9137610654E-01],
	[4.8455000000E+04, 5.2088616690E+01, 4.7250268944E+00, 4.7202788993E+01, 3.9679036525E+00, 9.9138011470E-01],
	[4.8460000000E+04, 5.2098294832E+01, 4.7250732756E+00, 4.7218914906E+01, 3.9681064307E+00, 9.9138412078E-01],
	[4.8465000000E+04, 5.2107973773E+01, 4.7251196526E+00, 4.7235044664E+01, 3.9683091591E+00, 9.9138812477E-01],
	[4.8470000000E+04, 5.2117653513E+01, 4.7251660252E+00, 4.7251178267E+01, 3.9685118377E+00, 9.9139212668E-01],
	[4.8475000000E+04, 5.2127334053E+01, 4.7252123935E+00, 4.7267315715E+01, 3.9687144664E+00, 9.9139612651E-01],
	[4.8480000000E+04, 5.2137015392E+01, 4.7252587575E+00, 4.7283457008E+01, 3.9689170453E+00, 9.9140012426E-01],
	[4.8485000000E+04, 5.2146697531E+01, 4.7253051171E+00, 4.7299602149E+01, 3.9691195745E+00, 9.9140411993E-01],
	[4.8490000000E+04, 5.2156380469E+01, 4.7253514724E+00, 4.7315751136E+01, 3.9693220539E+00, 9.9140811352E-01],
	[4.8495000000E+04, 5.2166064206E+01, 4.7253978234E+00, 4.7331903971E+01, 3.9695244835E+00, 9.9141210503E-01],
	[4.8500000000E+04, 5.2175748742E+01, 4.7254441700E+00, 4.7348060653E+01, 3.9697268633E+00, 9.9141609447E-01],
	[4.8505000000E+04, 5.2185434078E+01, 4.7254905124E+00, 4.7364221185E+01, 3.9699291935E+00, 9.9142008183E-01],
	[4.8510000000E+04, 5.2195120213E+01, 4.7255368504E+00, 4.7380385565E+01, 3.9701314739E+00, 9.9142406712E-01],
	[4.8515000000E+04, 5.2204807147E+01, 4.7255831841E+00, 4.7396553795E+01, 3.9703337047E+00, 9.9142805034E-01],
	[4.8520000000E+04, 5.2214494881E+01, 4.7256295135E+00, 4.7412725875E+01, 3.9705358858E+00, 9.9143203149E-01],
	[4.8525000000E+04, 5.2224183414E+01, 4.7256758385E+00, 4.7428901805E+01, 3.9707380172E+00, 9.9143601056E-01],
	[4.8530000000E+04, 5.2233872746E+01, 4.7257221593E+00, 4.7445081587E+01, 3.9709400990E+00, 9.9143998757E-01],
	[4.8535000000E+04, 5.2243562877E+01, 4.7257684757E+00, 4.7461265220E+01, 3.9711421311E+00, 9.9144396251E-01],
	[4.8540000000E+04, 5.2253253807E+01, 4.7258147878E+00, 4.7477452706E+01, 3.9713441137E+00, 9.9144793538E-01],
	[4.8545000000E+04, 5.2262945537E+01, 4.7258610956E+00, 4.7493644044E+01, 3.9715460466E+00, 9.9145190619E-01],
	[4.8550000000E+04, 5.2272638065E+01, 4.7259073990E+00, 4.7509839235E+01, 3.9717479300E+00, 9.9145587493E-01],
	[4.8555000000E+04, 5.2282331393E+01, 4.7259536982E+00, 4.7526038280E+01, 3.9719497638E+00, 9.9145984161E-01],
	[4.8560000000E+04, 5.2292025520E+01, 4.7259999930E+00, 4.7542241179E+01, 3.9721515481E+00, 9.9146380623E-01],
	[4.8565000000E+04, 5.2301720446E+01, 4.7260462835E+00, 4.7558447933E+01, 3.9723532829E+00, 9.9146776878E-01],
	[4.8570000000E+04, 5.2311416171E+01, 4.7260925697E+00, 4.7574658542E+01, 3.9725549681E+00, 9.9147172928E-01],
	[4.8575000000E+04, 5.2321112695E+01, 4.7261388516E+00, 4.7590873007E+01, 3.9727566038E+00, 9.9147568772E-01],
	[4.8580000000E+04, 5.2330810018E+01, 4.7261851292E+00, 4.7607091329E+01, 3.9729581901E+00, 9.9147964410E-01],
	[4.8585000000E+04, 5.2340508140E+01, 4.7262314025E+00, 4.7623313507E+01, 3.9731597269E+00, 9.9148359842E-01],
	[4.8590000000E+04, 5.2350207061E+01, 4.7262776715E+00, 4.7639539543E+01, 3.9733612143E+00, 9.9148755069E-01],
	[4.8595000000E+04, 5.2359906781E+01, 4.7263239362E+00, 4.7655769436E+01, 3.9735626522E+00, 9.9149150090E-01],
	[4.8600000000E+04, 5.2369607300E+01, 4.7263701965E+00, 4.7672003188E+01, 3.9737640407E+00, 9.9149544906E-01],
	[4.8605000000E+04, 5.2379308619E+01, 4.7264164526E+00, 4.7688240799E+01, 3.9739653799E+00, 9.9149939517E-01],
	[4.8610000000E+04, 5.2389010736E+01, 4.7264627043E+00, 4.7704482269E+01, 3.9741666696E+00, 9.9150333923E-01],
	[4.8615000000E+04, 5.2398713651E+01, 4.7265089518E+00, 4.7720727599E+01, 3.9743679100E+00, 9.9150728124E-01],
	[4.8620000000E+04, 5.2408417366E+01, 4.7265551949E+00, 4.7736976790E+01, 3.9745691010E+00, 9.9151122120E-01],
	[4.8625000000E+04, 5.2418121880E+01, 4.7266014337E+00, 4.7753229841E+01, 3.9747702427E+00, 9.9151515911E-01],
	[4.8630000000E+04, 5.2427827192E+01, 4.7266476683E+00, 4.7769486754E+01, 3.9749713351E+00, 9.9151909498E-01],
	[4.8635000000E+04, 5.2437533304E+01, 4.7266938985E+00, 4.7785747530E+01, 3.9751723782E+00, 9.9152302880E-01],
	[4.8640000000E+04, 5.2447240214E+01, 4.7267401244E+00, 4.7802012167E+01, 3.9753733720E+00, 9.9152696058E-01],
	[4.8645000000E+04, 5.2456947923E+01, 4.7267863460E+00, 4.7818280668E+01, 3.9755743165E+00, 9.9153089031E-01],
	[4.8650000000E+04, 5.2466656431E+01, 4.7268325634E+00, 4.7834553033E+01, 3.9757752118E+00, 9.9153481800E-01],
	[4.8655000000E+04, 5.2476365738E+01, 4.7268787764E+00, 4.7850829261E+01, 3.9759760579E+00, 9.9153874365E-01],
	[4.8660000000E+04, 5.2486075843E+01, 4.7269249851E+00, 4.7867109354E+01, 3.9761768547E+00, 9.9154266727E-01],
	[4.8665000000E+04, 5.2495786748E+01, 4.7269711896E+00, 4.7883393313E+01, 3.9763776024E+00, 9.9154658884E-01],
	[4.8670000000E+04, 5.2505498451E+01, 4.7270173897E+00, 4.7899681137E+01, 3.9765783008E+00, 9.9155050838E-01],
	[4.8675000000E+04, 5.2515210952E+01, 4.7270635856E+00, 4.7915972827E+01, 3.9767789501E+00, 9.9155442588E-01],
	[4.8680000000E+04, 5.2524924253E+01, 4.7271097771E+00, 4.7932268384E+01, 3.9769795502E+00, 9.9155834134E-01],
	[4.8685000000E+04, 5.2534638352E+01, 4.7271559644E+00, 4.7948567808E+01, 3.9771801012E+00, 9.9156225478E-01],
	[4.8690000000E+04, 5.2544353250E+01, 4.7272021474E+00, 4.7964871100E+01, 3.9773806031E+00, 9.9156616618E-01],
	[4.8695000000E+04, 5.2554068946E+01, 4.7272483261E+00, 4.7981178260E+01, 3.9775810559E+00, 9.9157007554E-01],
	[4.8700000000E+04, 5.2563785441E+01, 4.7272945004E+00, 4.7997489289E+01, 3.9777814596E+00, 9.9157398288E-01],
	[4.8705000000E+04, 5.2573502735E+01, 4.7273406705E+00, 4.8013804187E+01, 3.9779818142E+00, 9.9157788819E-01],
	[4.8710000000E+04, 5.2583220827E+01, 4.7273868364E+00, 4.8030122956E+01, 3.9781821197E+00, 9.9158179147E-01],
	[4.8715000000E+04, 5.2592939718E+01, 4.7274329979E+00, 4.8046445594E+01, 3.9783823763E+00, 9.9158569272E-01],
	[4.8720000000E+04, 5.2602659408E+01, 4.7274791551E+00, 4.8062772104E+01, 3.9785825838E+00, 9.9158959195E-01],
	[4.8725000000E+04, 5.2612379896E+01, 4.7275253081E+00, 4.8079102484E+01, 3.9787827423E+00, 9.9159348915E-01],
	[4.8730000000E+04, 5.2622101182E+01, 4.7275714567E+00, 4.8095436737E+01, 3.9789828518E+00, 9.9159738433E-01],
	[4.8735000000E+04, 5.2631823268E+01, 4.7276176011E+00, 4.8111774862E+01, 3.9791829123E+00, 9.9160127749E-01],
	[4.8740000000E+04, 5.2641546151E+01, 4.7276637412E+00, 4.8128116860E+01, 3.9793829239E+00, 9.9160516862E-01],
	[4.8745000000E+04, 5.2651269833E+01, 4.7277098770E+00, 4.8144462732E+01, 3.9795828865E+00, 9.9160905773E-01],
	[4.8750000000E+04, 5.2660994314E+01, 4.7277560086E+00, 4.8160812478E+01, 3.9797828002E+00, 9.9161294483E-01],
	[4.8755000000E+04, 5.2670719593E+01, 4.7278021358E+00, 4.8177166098E+01, 3.9799826650E+00, 9.9161682991E-01],
	[4.8760000000E+04, 5.2680445671E+01, 4.7278482588E+00, 4.8193523593E+01, 3.9801824809E+00, 9.9162071297E-01],
	[4.8765000000E+04, 5.2690172547E+01, 4.7278943775E+00, 4.8209884964E+01, 3.9803822479E+00, 9.9162459401E-01],
	[4.8770000000E+04, 5.2699900221E+01, 4.7279404919E+00, 4.8226250211E+01, 3.9805819660E+00, 9.9162847304E-01],
	[4.8775000000E+04, 5.2709628694E+01, 4.7279866020E+00, 4.8242619334E+01, 3.9807816354E+00, 9.9163235006E-01],
	[4.8780000000E+04, 5.2719357965E+01, 4.7280327079E+00, 4.8258992335E+01, 3.9809812558E+00, 9.9163622506E-01],
	[4.8785000000E+04, 5.2729088035E+01, 4.7280788095E+00, 4.8275369213E+01, 3.9811808275E+00, 9.9164009805E-01],
	[4.8790000000E+04, 5.2738818903E+01, 4.7281249068E+00, 4.8291749970E+01, 3.9813803504E+00, 9.9164396903E-01],
	[4.8795000000E+04, 5.2748550569E+01, 4.7281709998E+00, 4.8308134605E+01, 3.9815798245E+00, 9.9164783801E-01],
	[4.8800000000E+04, 5.2758283033E+01, 4.7282170886E+00, 4.8324523119E+01, 3.9817792498E+00, 9.9165170497E-01],
	[4.8805000000E+04, 5.2768016296E+01, 4.7282631731E+00, 4.8340915513E+01, 3.9819786264E+00, 9.9165556993E-01],
	[4.8810000000E+04, 5.2777750357E+01, 4.7283092533E+00, 4.8357311788E+01, 3.9821779542E+00, 9.9165943288E-01],
	[4.8815000000E+04, 5.2787485217E+01, 4.7283553292E+00, 4.8373711943E+01, 3.9823772334E+00, 9.9166329383E-01],
	[4.8820000000E+04, 5.2797220874E+01, 4.7284014009E+00, 4.8390115979E+01, 3.9825764638E+00, 9.9166715278E-01],
	[4.8825000000E+04, 5.2806957330E+01, 4.7284474683E+00, 4.8406523897E+01, 3.9827756455E+00, 9.9167100972E-01],
	[4.8830000000E+04, 5.2816694584E+01, 4.7284935314E+00, 4.8422935698E+01, 3.9829747786E+00, 9.9167486466E-01],
	[4.8835000000E+04, 5.2826432637E+01, 4.7285395903E+00, 4.8439351381E+01, 3.9831738630E+00, 9.9167871760E-01],
	[4.8840000000E+04, 5.2836171487E+01, 4.7285856449E+00, 4.8455770948E+01, 3.9833728988E+00, 9.9168256855E-01],
	[4.8845000000E+04, 5.2845911136E+01, 4.7286316952E+00, 4.8472194399E+01, 3.9835718860E+00, 9.9168641749E-01],
	[4.8850000000E+04, 5.2855651583E+01, 4.7286777413E+00, 4.8488621734E+01, 3.9837708246E+00, 9.9169026444E-01],
	[4.8855000000E+04, 5.2865392828E+01, 4.7287237831E+00, 4.8505052954E+01, 3.9839697145E+00, 9.9169410939E-01],
	[4.8860000000E+04, 5.2875134871E+01, 4.7287698206E+00, 4.8521488060E+01, 3.9841685559E+00, 9.9169795235E-01],
	[4.8865000000E+04, 5.2884877712E+01, 4.7288158539E+00, 4.8537927051E+01, 3.9843673488E+00, 9.9170179331E-01],
	[4.8870000000E+04, 5.2894621351E+01, 4.7288618829E+00, 4.8554369929E+01, 3.9845660931E+00, 9.9170563229E-01],
	[4.8875000000E+04, 5.2904365789E+01, 4.7289079077E+00, 4.8570816694E+01, 3.9847647889E+00, 9.9170946927E-01],
	[4.8880000000E+04, 5.2914111024E+01, 4.7289539282E+00, 4.8587267347E+01, 3.9849634361E+00, 9.9171330426E-01],
	[4.8885000000E+04, 5.2923857058E+01, 4.7289999444E+00, 4.8603721888E+01, 3.9851620349E+00, 9.9171713726E-01],
	[4.8890000000E+04, 5.2933603889E+01, 4.7290459564E+00, 4.8620180317E+01, 3.9853605852E+00, 9.9172096828E-01],
	[4.8895000000E+04, 5.2943351519E+01, 4.7290919641E+00, 4.8636642635E+01, 3.9855590871E+00, 9.9172479730E-01],
	[4.8900000000E+04, 5.2953099946E+01, 4.7291379676E+00, 4.8653108843E+01, 3.9857575405E+00, 9.9172862435E-01],
	[4.8905000000E+04, 5.2962849172E+01, 4.7291839668E+00, 4.8669578942E+01, 3.9859559454E+00, 9.9173244940E-01],
	[4.8910000000E+04, 5.2972599195E+01, 4.7292299617E+00, 4.8686052930E+01, 3.9861543020E+00, 9.9173627248E-01],
	[4.8915000000E+04, 5.2982350017E+01, 4.7292759524E+00, 4.8702530811E+01, 3.9863526102E+00, 9.9174009357E-01],
	[4.8920000000E+04, 5.2992101636E+01, 4.7293219389E+00, 4.8719012582E+01, 3.9865508699E+00, 9.9174391268E-01],
	[4.8925000000E+04, 5.3001854053E+01, 4.7293679211E+00, 4.8735498246E+01, 3.9867490814E+00, 9.9174772981E-01],
	[4.8930000000E+04, 5.3011607268E+01, 4.7294138990E+00, 4.8751987803E+01, 3.9869472444E+00, 9.9175154497E-01],
	[4.8935000000E+04, 5.3021361281E+01, 4.7294598727E+00, 4.8768481253E+01, 3.9871453592E+00, 9.9175535814E-01],
	[4.8940000000E+04, 5.3031116092E+01, 4.7295058421E+00, 4.8784978597E+01, 3.9873434256E+00, 9.9175916934E-01],
	[4.8945000000E+04, 5.3040871701E+01, 4.7295518073E+00, 4.8801479835E+01, 3.9875414437E+00, 9.9176297856E-01],
	[4.8950000000E+04, 5.3050628107E+01, 4.7295977683E+00, 4.8817984968E+01, 3.9877394135E+00, 9.9176678581E-01],
	[4.8955000000E+04, 5.3060385312E+01, 4.7296437249E+00, 4.8834493997E+01, 3.9879373351E+00, 9.9177059109E-01],
	[4.8960000000E+04, 5.3070143314E+01, 4.7296896774E+00, 4.8851006921E+01, 3.9881352084E+00, 9.9177439439E-01],
	[4.8965000000E+04, 5.3079902114E+01, 4.7297356256E+00, 4.8867523741E+01, 3.9883330335E+00, 9.9177819572E-01],
	[4.8970000000E+04, 5.3089661711E+01, 4.7297815695E+00, 4.8884044459E+01, 3.9885308103E+00, 9.9178199509E-01],
	[4.8975000000E+04, 5.3099422107E+01, 4.7298275092E+00, 4.8900569074E+01, 3.9887285390E+00, 9.9178579248E-01],
	[4.8980000000E+04, 5.3109183300E+01, 4.7298734447E+00, 4.8917097587E+01, 3.9889262195E+00, 9.9178958791E-01],
	[4.8985000000E+04, 5.3118945291E+01, 4.7299193759E+00, 4.8933629999E+01, 3.9891238517E+00, 9.9179338137E-01],
	[4.8990000000E+04, 5.3128708079E+01, 4.7299653029E+00, 4.8950166309E+01, 3.9893214359E+00, 9.9179717286E-01],
	[4.8995000000E+04, 5.3138471666E+01, 4.7300112256E+00, 4.8966706519E+01, 3.9895189718E+00, 9.9180096239E-01],
	[4.9000000000E+04, 5.3148236050E+01, 4.7300571441E+00, 4.8983250629E+01, 3.9897164597E+00, 9.9180474996E-01],
	[4.9005000000E+04, 5.3158001231E+01, 4.7301030584E+00, 4.8999798640E+01, 3.9899138995E+00, 9.9180853556E-01],
	[4.9010000000E+04, 5.3167767211E+01, 4.7301489684E+00, 4.9016350552E+01, 3.9901112911E+00, 9.9181231920E-01],
	[4.9015000000E+04, 5.3177533987E+01, 4.7301948742E+00, 4.9032906365E+01, 3.9903086347E+00, 9.9181610089E-01],
	[4.9020000000E+04, 5.3187301562E+01, 4.7302407757E+00, 4.9049466081E+01, 3.9905059302E+00, 9.9181988061E-01],
	[4.9025000000E+04, 5.3197069934E+01, 4.7302866730E+00, 4.9066029699E+01, 3.9907031777E+00, 9.9182365838E-01],
	[4.9030000000E+04, 5.3206839103E+01, 4.7303325661E+00, 4.9082597221E+01, 3.9909003771E+00, 9.9182743419E-01],
	[4.9035000000E+04, 5.3216609071E+01, 4.7303784549E+00, 4.9099168646E+01, 3.9910975285E+00, 9.9183120804E-01],
	[4.9040000000E+04, 5.3226379835E+01, 4.7304243395E+00, 4.9115743975E+01, 3.9912946319E+00, 9.9183497994E-01],
	[4.9045000000E+04, 5.3236151397E+01, 4.7304702199E+00, 4.9132323209E+01, 3.9914916874E+00, 9.9183874989E-01],
	[4.9050000000E+04, 5.3245923757E+01, 4.7305160961E+00, 4.9148906349E+01, 3.9916886948E+00, 9.9184251789E-01],
	[4.9055000000E+04, 5.3255696914E+01, 4.7305619680E+00, 4.9165493394E+01, 3.9918856544E+00, 9.9184628393E-01],
	[4.9060000000E+04, 5.3265470869E+01, 4.7306078356E+00, 4.9182084346E+01, 3.9920825659E+00, 9.9185004802E-01],
	[4.9065000000E+04, 5.3275245621E+01, 4.7306536991E+00, 4.9198679204E+01, 3.9922794296E+00, 9.9185381017E-01],
	[4.9070000000E+04, 5.3285029682E+01, 4.7307002415E+00, 4.9215277970E+01, 3.9924767798E+00, 9.9185757037E-01],
	[4.9075000000E+04, 5.3294823914E+01, 4.7307475319E+00, 4.9231880643E+01, 3.9926746705E+00, 9.9186132862E-01],
	[4.9080000000E+04, 5.3304618948E+01, 4.7307948178E+00, 4.9248487225E+01, 3.9928725133E+00, 9.9186508492E-01],
	[4.9085000000E+04, 5.3314414784E+01, 4.7308420995E+00, 4.9265097716E+01, 3.9930703084E+00, 9.9186883928E-01],
	[4.9090000000E+04, 5.3324211422E+01, 4.7308893768E+00, 4.9281712116E+01, 3.9932680556E+00, 9.9187259170E-01],
	[4.9095000000E+04, 5.3334008862E+01, 4.7309366497E+00, 4.9298330427E+01, 3.9934657551E+00, 9.9187634218E-01],
	[4.9100000000E+04, 5.3343807105E+01, 4.7309839184E+00, 4.9314952648E+01, 3.9936634068E+00, 9.9188009071E-01],
	[4.9105000000E+04, 5.3353606149E+01, 4.7310311826E+00, 4.9331578779E+01, 3.9938610108E+00, 9.9188383731E-01],
	[4.9110000000E+04, 5.3363405996E+01, 4.7310784426E+00, 4.9348208823E+01, 3.9940585671E+00, 9.9188758196E-01],
	[4.9115000000E+04, 5.3373206644E+01, 4.7311256981E+00, 4.9364842778E+01, 3.9942560756E+00, 9.9189132468E-01],
	[4.9120000000E+04, 5.3383008095E+01, 4.7311729494E+00, 4.9381480646E+01, 3.9944535364E+00, 9.9189506546E-01],
	[4.9125000000E+04, 5.3392810348E+01, 4.7312201963E+00, 4.9398122427E+01, 3.9946509496E+00, 9.9189880431E-01],
	[4.9130000000E+04, 5.3402613402E+01, 4.7312674389E+00, 4.9414768122E+01, 3.9948483151E+00, 9.9190254122E-01],
	[4.9135000000E+04, 5.3412417259E+01, 4.7313146771E+00, 4.9431417731E+01, 3.9950456329E+00, 9.9190627620E-01],
	[4.9140000000E+04, 5.3422221917E+01, 4.7313619110E+00, 4.9448071255E+01, 3.9952429031E+00, 9.9191000924E-01],
	[4.9145000000E+04, 5.3432027378E+01, 4.7314091406E+00, 4.9464728693E+01, 3.9954401257E+00, 9.9191374036E-01],
	[4.9150000000E+04, 5.3441833640E+01, 4.7314563659E+00, 4.9481390048E+01, 3.9956373007E+00, 9.9191746954E-01],
	[4.9155000000E+04, 5.3451640705E+01, 4.7315035868E+00, 4.9498055318E+01, 3.9958344281E+00, 9.9192119680E-01],
	[4.9160000000E+04, 5.3461448571E+01, 4.7315508033E+00, 4.9514724506E+01, 3.9960315079E+00, 9.9192492212E-01],
	[4.9165000000E+04, 5.3471257239E+01, 4.7315980156E+00, 4.9531397611E+01, 3.9962285402E+00, 9.9192864552E-01],
	[4.9170000000E+04, 5.3481066709E+01, 4.7316452235E+00, 4.9548074633E+01, 3.9964255249E+00, 9.9193236700E-01],
	[4.9175000000E+04, 5.3490876981E+01, 4.7316924271E+00, 4.9564755574E+01, 3.9966224622E+00, 9.9193608655E-01],
	[4.9180000000E+04, 5.3500688054E+01, 4.7317396263E+00, 4.9581440434E+01, 3.9968193518E+00, 9.9193980418E-01],
	[4.9185000000E+04, 5.3510499930E+01, 4.7317868213E+00, 4.9598129213E+01, 3.9970161941E+00, 9.9194351988E-01],
	[4.9190000000E+04, 5.3520312607E+01, 4.7318340119E+00, 4.9614821911E+01, 3.9972129888E+00, 9.9194723366E-01],
	[4.9195000000E+04, 5.3530126086E+01, 4.7318811982E+00, 4.9631518531E+01, 3.9974097360E+00, 9.9195094553E-01],
	[4.9200000000E+04, 5.3539940367E+01, 4.7319283801E+00, 4.9648219071E+01, 3.9976064359E+00, 9.9195465547E-01],
	[4.9205000000E+04, 5.3549755450E+01, 4.7319755577E+00, 4.9664923533E+01, 3.9978030882E+00, 9.9195836350E-01],
	[4.9210000000E+04, 5.3559571334E+01, 4.7320227310E+00, 4.9681631916E+01, 3.9979996932E+00, 9.9196206961E-01],
	[4.9215000000E+04, 5.3569388020E+01, 4.7320699000E+00, 4.9698344223E+01, 3.9981962508E+00, 9.9196577380E-01],
	[4.9220000000E+04, 5.3579205508E+01, 4.7321170647E+00, 4.9715060452E+01, 3.9983927609E+00, 9.9196947608E-01],
	[4.9225000000E+04, 5.3589023797E+01, 4.7321642250E+00, 4.9731780604E+01, 3.9985892238E+00, 9.9197317644E-01],
	[4.9230000000E+04, 5.3598842888E+01, 4.7322113810E+00, 4.9748504681E+01, 3.9987856392E+00, 9.9197687489E-01],
	[4.9235000000E+04, 5.3608662781E+01, 4.7322585327E+00, 4.9765232683E+01, 3.9989820073E+00, 9.9198057144E-01],
	[4.9240000000E+04, 5.3618483475E+01, 4.7323056801E+00, 4.9781964609E+01, 3.9991783281E+00, 9.9198426607E-01],
	[4.9245000000E+04, 5.3628304971E+01, 4.7323528232E+00, 4.9798700461E+01, 3.9993746016E+00, 9.9198795879E-01],
	[4.9250000000E+04, 5.3638127269E+01, 4.7323999619E+00, 4.9815440239E+01, 3.9995708278E+00, 9.9199164960E-01],
	[4.9255000000E+04, 5.3647950368E+01, 4.7324470963E+00, 4.9832183944E+01, 3.9997670067E+00, 9.9199533851E-01],
	[4.9260000000E+04, 5.3657774269E+01, 4.7324942265E+00, 4.9848931576E+01, 3.9999631384E+00, 9.9199902551E-01],
	[4.9265000000E+04, 5.3667598972E+01, 4.7325413523E+00, 4.9865683136E+01, 4.0001592228E+00, 9.9200271060E-01],
	[4.9270000000E+04, 5.3677424475E+01, 4.7325884738E+00, 4.9882438624E+01, 4.0003552600E+00, 9.9200639380E-01],
	[4.9275000000E+04, 5.3687250781E+01, 4.7326355909E+00, 4.9899198041E+01, 4.0005512500E+00, 9.9201007508E-01],
	[4.9280000000E+04, 5.3697077888E+01, 4.7326827038E+00, 4.9915961387E+01, 4.0007471928E+00, 9.9201375447E-01],
	[4.9285000000E+04, 5.3706905796E+01, 4.7327298123E+00, 4.9932728663E+01, 4.0009430883E+00, 9.9201743196E-01],
	[4.9290000000E+04, 5.3716734506E+01, 4.7327769166E+00, 4.9949499869E+01, 4.0011389368E+00, 9.9202110755E-01],
	[4.9295000000E+04, 5.3726564018E+01, 4.7328240165E+00, 4.9966275007E+01, 4.0013347380E+00, 9.9202478124E-01],
	[4.9300000000E+04, 5.3736394330E+01, 4.7328711121E+00, 4.9983054075E+01, 4.0015304922E+00, 9.9202845303E-01],
	[4.9305000000E+04, 5.3746225445E+01, 4.7329182035E+00, 4.9999837075E+01, 4.0017261992E+00, 9.9203212292E-01],
	[4.9310000000E+04, 5.3756057360E+01, 4.7329652905E+00, 5.0016624008E+01, 4.0019218591E+00, 9.9203579092E-01],
	[4.9315000000E+04, 5.3765890078E+01, 4.7330123732E+00, 5.0033414874E+01, 4.0021174719E+00, 9.9203945703E-01],
	[4.9320000000E+04, 5.3775723596E+01, 4.7330594516E+00, 5.0050209673E+01, 4.0023130377E+00, 9.9204312125E-01],
	[4.9325000000E+04, 5.3785557916E+01, 4.7331065257E+00, 5.0067008406E+01, 4.0025085563E+00, 9.9204678357E-01],
	[4.9330000000E+04, 5.3795393037E+01, 4.7331535955E+00, 5.0083811074E+01, 4.0027040280E+00, 9.9205044400E-01],
	[4.9335000000E+04, 5.3805228960E+01, 4.7332006609E+00, 5.0100617677E+01, 4.0028994526E+00, 9.9205410254E-01],
	[4.9340000000E+04, 5.3815065684E+01, 4.7332477221E+00, 5.0117428215E+01, 4.0030948302E+00, 9.9205775920E-01],
	[4.9345000000E+04, 5.3824903209E+01, 4.7332947790E+00, 5.0134242690E+01, 4.0032901608E+00, 9.9206141396E-01],
	[4.9350000000E+04, 5.3834741535E+01, 4.7333418316E+00, 5.0151061101E+01, 4.0034854444E+00, 9.9206506684E-01],
	[4.9355000000E+04, 5.3844580663E+01, 4.7333888799E+00, 5.0167883449E+01, 4.0036806811E+00, 9.9206871784E-01],
	[4.9360000000E+04, 5.3854420592E+01, 4.7334359239E+00, 5.0184709734E+01, 4.0038758708E+00, 9.9207236695E-01],
	[4.9365000000E+04, 5.3864261322E+01, 4.7334829636E+00, 5.0201539958E+01, 4.0040710135E+00, 9.9207601417E-01],
	[4.9370000000E+04, 5.3874102854E+01, 4.7335299990E+00, 5.0218374121E+01, 4.0042661094E+00, 9.9207965952E-01],
	[4.9375000000E+04, 5.3883945186E+01, 4.7335770300E+00, 5.0235212223E+01, 4.0044611583E+00, 9.9208330298E-01],
	[4.9380000000E+04, 5.3893788320E+01, 4.7336240569E+00, 5.0252054264E+01, 4.0046561603E+00, 9.9208694457E-01],
	[4.9385000000E+04, 5.3903632255E+01, 4.7336710794E+00, 5.0268900246E+01, 4.0048511155E+00, 9.9209058427E-01],
	[4.9390000000E+04, 5.3913476991E+01, 4.7337180976E+00, 5.0285750169E+01, 4.0050460238E+00, 9.9209422210E-01],
	[4.9395000000E+04, 5.3923322529E+01, 4.7337651115E+00, 5.0302604033E+01, 4.0052408853E+00, 9.9209785805E-01],
	[4.9400000000E+04, 5.3933168867E+01, 4.7338121211E+00, 5.0319461838E+01, 4.0054356999E+00, 9.9210149213E-01],
	[4.9405000000E+04, 5.3943016007E+01, 4.7338591265E+00, 5.0336323586E+01, 4.0056304678E+00, 9.9210512433E-01],
	[4.9410000000E+04, 5.3952863948E+01, 4.7339061275E+00, 5.0353189277E+01, 4.0058251888E+00, 9.9210875466E-01],
	[4.9415000000E+04, 5.3962712689E+01, 4.7339531243E+00, 5.0370058912E+01, 4.0060198630E+00, 9.9211238311E-01],
	[4.9420000000E+04, 5.3972562232E+01, 4.7340001167E+00, 5.0386932490E+01, 4.0062144905E+00, 9.9211600970E-01],
	[4.9425000000E+04, 5.3982412576E+01, 4.7340471049E+00, 5.0403810012E+01, 4.0064090713E+00, 9.9211963441E-01],
	[4.9430000000E+04, 5.3992263721E+01, 4.7340940888E+00, 5.0420691480E+01, 4.0066036052E+00, 9.9212325726E-01],
	[4.9435000000E+04, 5.4002115667E+01, 4.7341410684E+00, 5.0437576893E+01, 4.0067980925E+00, 9.9212687823E-01],
	[4.9440000000E+04, 5.4011968414E+01, 4.7341880437E+00, 5.0454466252E+01, 4.0069925331E+00, 9.9213049734E-01],
	[4.9445000000E+04, 5.4021821962E+01, 4.7342350148E+00, 5.0471359558E+01, 4.0071869270E+00, 9.9213411459E-01],
	[4.9450000000E+04, 5.4031676311E+01, 4.7342819815E+00, 5.0488256811E+01, 4.0073812742E+00, 9.9213772997E-01],
	[4.9455000000E+04, 5.4041531461E+01, 4.7343289440E+00, 5.0505158011E+01, 4.0075755747E+00, 9.9214134349E-01],
	[4.9460000000E+04, 5.4051387412E+01, 4.7343759022E+00, 5.0522063160E+01, 4.0077698286E+00, 9.9214495514E-01],
	[4.9465000000E+04, 5.4061244163E+01, 4.7344228561E+00, 5.0538972257E+01, 4.0079640359E+00, 9.9214856493E-01],
	[4.9470000000E+04, 5.4071101716E+01, 4.7344698057E+00, 5.0555885303E+01, 4.0081581965E+00, 9.9215217286E-01],
	[4.9475000000E+04, 5.4080960070E+01, 4.7345167511E+00, 5.0572802299E+01, 4.0083523106E+00, 9.9215577894E-01],
	[4.9480000000E+04, 5.4090819224E+01, 4.7345636922E+00, 5.0589723245E+01, 4.0085463780E+00, 9.9215938315E-01],
	[4.9485000000E+04, 5.4100679179E+01, 4.7346106290E+00, 5.0606648141E+01, 4.0087403989E+00, 9.9216298551E-01],
	[4.9490000000E+04, 5.4110539936E+01, 4.7346575615E+00, 5.0623576989E+01, 4.0089343733E+00, 9.9216658601E-01],
	[4.9495000000E+04, 5.4120401492E+01, 4.7347044897E+00, 5.0640509789E+01, 4.0091283011E+00, 9.9217018465E-01],
	[4.9500000000E+04, 5.4130263850E+01, 4.7347514137E+00, 5.0657446541E+01, 4.0093221824E+00, 9.9217378145E-01],
	[4.9505000000E+04, 5.4140127009E+01, 4.7347983334E+00, 5.0674387246E+01, 4.0095160172E+00, 9.9217737639E-01],
	[4.9510000000E+04, 5.4149990968E+01, 4.7348452488E+00, 5.0691331904E+01, 4.0097098055E+00, 9.9218096947E-01],
	[4.9515000000E+04, 5.4159855728E+01, 4.7348921599E+00, 5.0708280516E+01, 4.0099035473E+00, 9.9218456071E-01],
	[4.9520000000E+04, 5.4169721289E+01, 4.7349390668E+00, 5.0725233083E+01, 4.0100972426E+00, 9.9218815010E-01],
	[4.9525000000E+04, 5.4179587651E+01, 4.7349859694E+00, 5.0742189604E+01, 4.0102908915E+00, 9.9219173763E-01],
	[4.9530000000E+04, 5.4189454813E+01, 4.7350328677E+00, 5.0759150081E+01, 4.0104844940E+00, 9.9219532333E-01],
	[4.9535000000E+04, 5.4199322776E+01, 4.7350797618E+00, 5.0776114513E+01, 4.0106780501E+00, 9.9219890717E-01],
	[4.9540000000E+04, 5.4209191540E+01, 4.7351266516E+00, 5.0793082903E+01, 4.0108715597E+00, 9.9220248917E-01],
	[4.9545000000E+04, 5.4219061104E+01, 4.7351735371E+00, 5.0810055249E+01, 4.0110650230E+00, 9.9220606932E-01],
	[4.9550000000E+04, 5.4228931469E+01, 4.7352204184E+00, 5.0827031552E+01, 4.0112584399E+00, 9.9220964763E-01],
	[4.9555000000E+04, 5.4238802635E+01, 4.7352672954E+00, 5.0844011814E+01, 4.0114518105E+00, 9.9221322410E-01],
	[4.9560000000E+04, 5.4248674601E+01, 4.7353141681E+00, 5.0860996034E+01, 4.0116451347E+00, 9.9221679873E-01],
	[4.9565000000E+04, 5.4258547368E+01, 4.7353610365E+00, 5.0877984214E+01, 4.0118384126E+00, 9.9222037152E-01],
	[4.9570000000E+04, 5.4268420936E+01, 4.7354079007E+00, 5.0894976353E+01, 4.0120316442E+00, 9.9222394247E-01],
	[4.9575000000E+04, 5.4278295304E+01, 4.7354547607E+00, 5.0911972452E+01, 4.0122248294E+00, 9.9222751158E-01],
	[4.9580000000E+04, 5.4288170472E+01, 4.7355016163E+00, 5.0928972512E+01, 4.0124179684E+00, 9.9223107885E-01],
	[4.9585000000E+04, 5.4298046441E+01, 4.7355484677E+00, 5.0945976533E+01, 4.0126110612E+00, 9.9223464429E-01],
	[4.9590000000E+04, 5.4307923211E+01, 4.7355953149E+00, 5.0962984515E+01, 4.0128041077E+00, 9.9223820790E-01],
	[4.9595000000E+04, 5.4317800781E+01, 4.7356421578E+00, 5.0979996460E+01, 4.0129971079E+00, 9.9224176967E-01],
	[4.9600000000E+04, 5.4327679152E+01, 4.7356889964E+00, 5.0997012368E+01, 4.0131900620E+00, 9.9224532961E-01],
	[4.9605000000E+04, 5.4337558323E+01, 4.7357358308E+00, 5.1014032239E+01, 4.0133829698E+00, 9.9224888771E-01],
	[4.9610000000E+04, 5.4347438295E+01, 4.7357826609E+00, 5.1031056073E+01, 4.0135758315E+00, 9.9225244399E-01],
	[4.9615000000E+04, 5.4357319067E+01, 4.7358294868E+00, 5.1048083872E+01, 4.0137686469E+00, 9.9225599843E-01],
	[4.9620000000E+04, 5.4367200639E+01, 4.7358763084E+00, 5.1065115636E+01, 4.0139614163E+00, 9.9225955105E-01],
	[4.9625000000E+04, 5.4377083012E+01, 4.7359231257E+00, 5.1082151365E+01, 4.0141541394E+00, 9.9226310184E-01],
	[4.9630000000E+04, 5.4386966186E+01, 4.7359699388E+00, 5.1099191060E+01, 4.0143468165E+00, 9.9226665081E-01],
	[4.9635000000E+04, 5.4396850159E+01, 4.7360167476E+00, 5.1116234722E+01, 4.0145394474E+00, 9.9227019795E-01],
	[4.9640000000E+04, 5.4406734934E+01, 4.7360635522E+00, 5.1133282350E+01, 4.0147320323E+00, 9.9227374326E-01],
	[4.9645000000E+04, 5.4416620508E+01, 4.7361103525E+00, 5.1150333946E+01, 4.0149245710E+00, 9.9227728675E-01],
	[4.9650000000E+04, 5.4426506883E+01, 4.7361571486E+00, 5.1167389510E+01, 4.0151170637E+00, 9.9228082842E-01],
	[4.9655000000E+04, 5.4436394058E+01, 4.7362039405E+00, 5.1184449043E+01, 4.0153095103E+00, 9.9228436827E-01],
	[4.9660000000E+04, 5.4446282033E+01, 4.7362507281E+00, 5.1201512544E+01, 4.0155019109E+00, 9.9228790630E-01],
	[4.9665000000E+04, 5.4456170809E+01, 4.7362975114E+00, 5.1218580015E+01, 4.0156942655E+00, 9.9229144252E-01],
	[4.9670000000E+04, 5.4466060385E+01, 4.7363442905E+00, 5.1235651456E+01, 4.0158865741E+00, 9.9229497691E-01],
	[4.9675000000E+04, 5.4475950761E+01, 4.7363910653E+00, 5.1252726868E+01, 4.0160788367E+00, 9.9229850949E-01],
	[4.9680000000E+04, 5.4485841938E+01, 4.7364378359E+00, 5.1269806251E+01, 4.0162710533E+00, 9.9230204025E-01],
	[4.9685000000E+04, 5.4495733915E+01, 4.7364846023E+00, 5.1286889605E+01, 4.0164632239E+00, 9.9230556919E-01],
	[4.9690000000E+04, 5.4505626691E+01, 4.7365313644E+00, 5.1303976932E+01, 4.0166553486E+00, 9.9230909633E-01],
	[4.9695000000E+04, 5.4515520269E+01, 4.7365781222E+00, 5.1321068231E+01, 4.0168474274E+00, 9.9231262165E-01],
	[4.9700000000E+04, 5.4525414646E+01, 4.7366248759E+00, 5.1338163504E+01, 4.0170394602E+00, 9.9231614516E-01],
	[4.9705000000E+04, 5.4535309823E+01, 4.7366716252E+00, 5.1355262750E+01, 4.0172314472E+00, 9.9231966686E-01],
	[4.9710000000E+04, 5.4545205801E+01, 4.7367183704E+00, 5.1372365971E+01, 4.0174233882E+00, 9.9232318675E-01],
	[4.9715000000E+04, 5.4555102579E+01, 4.7367651113E+00, 5.1389473166E+01, 4.0176152834E+00, 9.9232670483E-01],
	[4.9720000000E+04, 5.4565000157E+01, 4.7368118479E+00, 5.1406584337E+01, 4.0178071328E+00, 9.9233022110E-01],
	[4.9725000000E+04, 5.4574898535E+01, 4.7368585803E+00, 5.1423699483E+01, 4.0179989363E+00, 9.9233373557E-01],
	[4.9730000000E+04, 5.4584797713E+01, 4.7369053085E+00, 5.1440818606E+01, 4.0181906939E+00, 9.9233724823E-01],
	[4.9735000000E+04, 5.4594697691E+01, 4.7369520325E+00, 5.1457941706E+01, 4.0183824058E+00, 9.9234075909E-01],
	[4.9740000000E+04, 5.4604598469E+01, 4.7369987522E+00, 5.1475068783E+01, 4.0185740718E+00, 9.9234426815E-01],
	[4.9745000000E+04, 5.4614500047E+01, 4.7370454676E+00, 5.1492199838E+01, 4.0187656921E+00, 9.9234777540E-01],
	[4.9750000000E+04, 5.4624402425E+01, 4.7370921789E+00, 5.1509334872E+01, 4.0189572666E+00, 9.9235128086E-01],
	[4.9755000000E+04, 5.4634305604E+01, 4.7371388859E+00, 5.1526473884E+01, 4.0191487954E+00, 9.9235478451E-01],
	[4.9760000000E+04, 5.4644209582E+01, 4.7371855886E+00, 5.1543616876E+01, 4.0193402784E+00, 9.9235828637E-01],
	[4.9765000000E+04, 5.4654114360E+01, 4.7372322872E+00, 5.1560763848E+01, 4.0195317157E+00, 9.9236178643E-01],
	[4.9770000000E+04, 5.4664019938E+01, 4.7372789815E+00, 5.1577914801E+01, 4.0197231073E+00, 9.9236528469E-01],
	[4.9775000000E+04, 5.4673926316E+01, 4.7373256716E+00, 5.1595069735E+01, 4.0199144532E+00, 9.9236878115E-01],
	[4.9780000000E+04, 5.4683833494E+01, 4.7373723574E+00, 5.1612228650E+01, 4.0201057534E+00, 9.9237227582E-01],
	[4.9785000000E+04, 5.4693741472E+01, 4.7374190390E+00, 5.1629391548E+01, 4.0202970080E+00, 9.9237576870E-01],
	[4.9790000000E+04, 5.4703650250E+01, 4.7374657164E+00, 5.1646558428E+01, 4.0204882169E+00, 9.9237925979E-01],
	[4.9795000000E+04, 5.4713559828E+01, 4.7375123896E+00, 5.1663729291E+01, 4.0206793802E+00, 9.9238274908E-01],
	[4.9800000000E+04, 5.4723470205E+01, 4.7375590585E+00, 5.1680904138E+01, 4.0208704979E+00, 9.9238623659E-01],
	[4.9805000000E+04, 5.4733381383E+01, 4.7376057232E+00, 5.1698082969E+01, 4.0210615700E+00, 9.9238972230E-01],
	[4.9810000000E+04, 5.4743293360E+01, 4.7376523837E+00, 5.1715265785E+01, 4.0212525964E+00, 9.9239320623E-01],
	[4.9815000000E+04, 5.4753206137E+01, 4.7376990400E+00, 5.1732452586E+01, 4.0214435774E+00, 9.9239668837E-01],
	[4.9820000000E+04, 5.4763119714E+01, 4.7377456920E+00, 5.1749643373E+01, 4.0216345127E+00, 9.9240016872E-01],
	[4.9825000000E+04, 5.4773034091E+01, 4.7377923398E+00, 5.1766838147E+01, 4.0218254025E+00, 9.9240364729E-01],
	[4.9830000000E+04, 5.4782949267E+01, 4.7378389834E+00, 5.1784036907E+01, 4.0220162468E+00, 9.9240712407E-01],
	[4.9835000000E+04, 5.4792865243E+01, 4.7378856228E+00, 5.1801239654E+01, 4.0222070456E+00, 9.9241059907E-01],
	[4.9840000000E+04, 5.4802782019E+01, 4.7379322579E+00, 5.1818446390E+01, 4.0223977989E+00, 9.9241407229E-01],
	[4.9845000000E+04, 5.4812699595E+01, 4.7379788889E+00, 5.1835657114E+01, 4.0225885067E+00, 9.9241754373E-01],
	[4.9850000000E+04, 5.4822617970E+01, 4.7380255156E+00, 5.1852871827E+01, 4.0227791690E+00, 9.9242101339E-01],
	[4.9855000000E+04, 5.4832537145E+01, 4.7380721381E+00, 5.1870090529E+01, 4.0229697859E+00, 9.9242448127E-01],
	[4.9860000000E+04, 5.4842465933E+01, 4.7381194480E+00, 5.1887313221E+01, 4.0231609034E+00, 9.9242794737E-01],
	[4.9865000000E+04, 5.4852404637E+01, 4.7381674689E+00, 5.1904539904E+01, 4.0233525402E+00, 9.9243141170E-01],
	[4.9870000000E+04, 5.4862344146E+01, 4.7382154854E+00, 5.1921770578E+01, 4.0235441317E+00, 9.9243487424E-01],
	[4.9875000000E+04, 5.4872284460E+01, 4.7382634977E+00, 5.1939005243E+01, 4.0237356779E+00, 9.9243833502E-01],
	[4.9880000000E+04, 5.4882225577E+01, 4.7383115056E+00, 5.1956243901E+01, 4.0239271787E+00, 9.9244179402E-01],
	[4.9885000000E+04, 5.4892167499E+01, 4.7383595092E+00, 5.1973486551E+01, 4.0241186342E+00, 9.9244525125E-01],
	[4.9890000000E+04, 5.4902110225E+01, 4.7384075084E+00, 5.1990733194E+01, 4.0243100444E+00, 9.9244870671E-01],
	[4.9895000000E+04, 5.4912053755E+01, 4.7384555034E+00, 5.2007983831E+01, 4.0245014093E+00, 9.9245216039E-01],
	[4.9900000000E+04, 5.4921998090E+01, 4.7385034940E+00, 5.2025238462E+01, 4.0246927290E+00, 9.9245561231E-01],
	[4.9905000000E+04, 5.4931943229E+01, 4.7385514802E+00, 5.2042497088E+01, 4.0248840034E+00, 9.9245906246E-01],
	[4.9910000000E+04, 5.4941889172E+01, 4.7385994622E+00, 5.2059759709E+01, 4.0250752325E+00, 9.9246251084E-01],
	[4.9915000000E+04, 5.4951835919E+01, 4.7386474399E+00, 5.2077026325E+01, 4.0252664164E+00, 9.9246595746E-01],
	[4.9920000000E+04, 5.4961783471E+01, 4.7386954132E+00, 5.2094296938E+01, 4.0254575551E+00, 9.9246940231E-01],
	[4.9925000000E+04, 5.4971731826E+01, 4.7387433822E+00, 5.2111571548E+01, 4.0256486486E+00, 9.9247284540E-01],
	[4.9930000000E+04, 5.4981680986E+01, 4.7387913469E+00, 5.2128850155E+01, 4.0258396969E+00, 9.9247628672E-01],
	[4.9935000000E+04, 5.4991630950E+01, 4.7388393072E+00, 5.2146132760E+01, 4.0260307000E+00, 9.9247972628E-01],
	[4.9940000000E+04, 5.5001581718E+01, 4.7388872633E+00, 5.2163419364E+01, 4.0262216580E+00, 9.9248316408E-01],
	[4.9945000000E+04, 5.5011533290E+01, 4.7389352150E+00, 5.2180709966E+01, 4.0264125708E+00, 9.9248660012E-01],
	[4.9950000000E+04, 5.5021485666E+01, 4.7389831624E+00, 5.2198004568E+01, 4.0266034385E+00, 9.9249003440E-01],
	[4.9955000000E+04, 5.5031438847E+01, 4.7390311055E+00, 5.2215303170E+01, 4.0267942611E+00, 9.9249346692E-01],
	[4.9960000000E+04, 5.5041392831E+01, 4.7390790443E+00, 5.2232605772E+01, 4.0269850386E+00, 9.9249689769E-01],
	[4.9965000000E+04, 5.5051347619E+01, 4.7391269788E+00, 5.2249912375E+01, 4.0271757710E+00, 9.9250032670E-01],
	[4.9970000000E+04, 5.5061303212E+01, 4.7391749090E+00, 5.2267222980E+01, 4.0273664583E+00, 9.9250375395E-01],
	[4.9975000000E+04, 5.5071259608E+01, 4.7392228348E+00, 5.2284537586E+01, 4.0275571006E+00, 9.9250717945E-01],
	[4.9980000000E+04, 5.5081216809E+01, 4.7392707564E+00, 5.2301856196E+01, 4.0277476978E+00, 9.9251060320E-01],
	[4.9985000000E+04, 5.5091174813E+01, 4.7393186736E+00, 5.2319178808E+01, 4.0279382500E+00, 9.9251402520E-01],
	[4.9990000000E+04, 5.5101133621E+01, 4.7393665866E+00, 5.2336505424E+01, 4.0281287573E+00, 9.9251744544E-01],
	[4.9995000000E+04, 5.5111093234E+01, 4.7394144952E+00, 5.2353836044E+01, 4.0283192195E+00, 9.9252086394E-01],
	[5.0000000000E+04, 5.5121053650E+01, 4.7394623995E+00, 5.2371170669E+01, 4.0285096367E+00, 9.9252428068E-01],
	[5.0005000000E+04, 5.5131014870E+01, 4.7395102995E+00, 5.2388519957E+01, 4.0287000720E+00, 9.9252769568E-01],
	[5.0010000000E+04, 5.5140976894E+01, 4.7395581952E+00, 5.2405873255E+01, 4.0288904623E+00, 9.9253110894E-01],
	[5.0015000000E+04, 5.5150939722E+01, 4.7396060866E+00, 5.2423230566E+01, 4.0290808076E+00, 9.9253452044E-01],
	[5.0020000000E+04, 5.5160903354E+01, 4.7396539737E+00, 5.2440591890E+01, 4.0292711080E+00, 9.9253793021E-01],
	[5.0025000000E+04, 5.5170867790E+01, 4.739