from netbox.plugins import PluginTemplateExtension
from django.urls import reverse
from django.utils.html import format_html


class DeviceInterfaceGridButton(PluginTemplateExtension):
    """Add Interface Grid View button to device pages"""
    
    model = 'dcim.device'
    
    def buttons(self):
        """Add button to device detail page"""
        obj = self.context['object']
        url = reverse('plugins:netbox_interface_view:interface_grid', kwargs={'device_id': obj.pk})
        return format_html(
            '<a href="{}" class="btn btn-sm btn-primary" title="View Interface Grid">'
            '<i class="mdi mdi-view-grid"></i> View Interface Grid'
            '</a>',
            url
        )


template_extensions = [DeviceInterfaceGridButton]
