"""
Definition of constants for vxlapi.
"""

# Import Python Modules
# ==============================
from enum import Enum


MAX_MSG_LEN = 8
XL_CAN_MAX_DATA_LEN = 64
XL_INVALID_PORTHANDLE = -1


class XL_AC_Flags(Enum):
    XL_ACTIVATE_NONE = 0
    XL_ACTIVATE_RESET_CLOCK = 8


class XL_AcceptanceFilter(Enum):
    XL_CAN_STD = 1
    XL_CAN_EXT = 2


class XL_BusCapabilities(Enum):
    XL_BUS_COMPATIBLE_CAN = 1
    XL_BUS_ACTIVE_CAP_CAN = 65536


class XL_BusStatus(Enum):
    XL_CHIPSTAT_BUSOFF = 1
    XL_CHIPSTAT_ERROR_PASSIVE = 2
    XL_CHIPSTAT_ERROR_WARNING = 4
    XL_CHIPSTAT_ERROR_ACTIVE = 8


class XL_BusTypes(Enum):
    XL_BUS_TYPE_NONE = 0
    XL_BUS_TYPE_CAN = 1


class XL_CANFD_BusParams_CanOpMode(Enum):
    XL_BUS_PARAMS_CANOPMODE_CAN20 = 1
    XL_BUS_PARAMS_CANOPMODE_CANFD = 2
    XL_BUS_PARAMS_CANOPMODE_CANFD_NO_ISO = 8


class XL_CANFD_ConfigOptions(Enum):
    CANFD_CONFOPT_NO_ISO = 8


class XL_CANFD_RX_EV_ERROR_errorCode(Enum):
    XL_CAN_ERRC_BIT_ERROR = 1
    XL_CAN_ERRC_FORM_ERROR = 2
    XL_CAN_ERRC_STUFF_ERROR = 3
    XL_CAN_ERRC_OTHER_ERROR = 4
    XL_CAN_ERRC_CRC_ERROR = 5
    XL_CAN_ERRC_ACK_ERROR = 6
    XL_CAN_ERRC_NACK_ERROR = 7
    XL_CAN_ERRC_OVLD_ERROR = 8
    XL_CAN_ERRC_EXCPT_ERROR = 9


class XL_CANFD_RX_EventTags(Enum):
    XL_SYNC_PULSE = 11
    XL_CAN_EV_TAG_RX_OK = 1024
    XL_CAN_EV_TAG_RX_ERROR = 1025
    XL_CAN_EV_TAG_TX_ERROR = 1026
    XL_CAN_EV_TAG_TX_REQUEST = 1027
    XL_CAN_EV_TAG_TX_OK = 1028
    XL_CAN_EV_TAG_CHIP_STATE = 1033


class XL_CANFD_RX_MessageFlags(Enum):
    XL_CAN_RXMSG_FLAG_NONE = 0
    XL_CAN_RXMSG_FLAG_EDL = 1
    XL_CAN_RXMSG_FLAG_BRS = 2
    XL_CAN_RXMSG_FLAG_ESI = 4
    XL_CAN_RXMSG_FLAG_RTR = 16
    XL_CAN_RXMSG_FLAG_EF = 512
    XL_CAN_RXMSG_FLAG_ARB_LOST = 1024
    XL_CAN_RXMSG_FLAG_WAKEUP = 8192
    XL_CAN_RXMSG_FLAG_TE = 16384


class XL_CANFD_TX_EventTags(Enum):
    XL_CAN_EV_TAG_TX_MSG = 1088


class XL_CANFD_TX_MessageFlags(Enum):
    XL_CAN_TXMSG_FLAG_NONE = 0
    XL_CAN_TXMSG_FLAG_EDL = 1
    XL_CAN_TXMSG_FLAG_BRS = 2
    XL_CAN_TXMSG_FLAG_RTR = 16
    XL_CAN_TXMSG_FLAG_HIGHPRIO = 128
    XL_CAN_TXMSG_FLAG_WAKEUP = 512


class XL_ChannelCapabilities(Enum):
    XL_CHANNEL_FLAG_TIME_SYNC_RUNNING = 1
    XL_CHANNEL_FLAG_NO_HWSYNC_SUPPORT = 1024
    XL_CHANNEL_FLAG_SPDIF_CAPABLE = 16384
    XL_CHANNEL_FLAG_CANFD_BOSCH_SUPPORT = 536870912
    XL_CHANNEL_FLAG_CMACTLICENSE_SUPPORT = 1073741824
    XL_CHANNEL_FLAG_CANFD_ISO_SUPPORT = 2147483648


class XL_EventTags(Enum):
    XL_NO_COMMAND = 0
    XL_RECEIVE_MSG = 1
    XL_CHIP_STATE = 4
    XL_TRANSCEIVER = 6
    XL_TIMER = 8
    XL_TRANSMIT_MSG = 10
    XL_SYNC_PULSE = 11
    XL_APPLICATION_NOTIFICATION = 15


class XL_InterfaceVersion(Enum):
    XL_INTERFACE_VERSION_V2 = 2
    XL_INTERFACE_VERSION_V3 = 3
    XL_INTERFACE_VERSION = XL_INTERFACE_VERSION_V3
    XL_INTERFACE_VERSION_V4 = 4


class XL_MessageFlags(Enum):
    XL_CAN_MSG_FLAG_NONE = 0
    XL_CAN_MSG_FLAG_ERROR_FRAME = 1
    XL_CAN_MSG_FLAG_OVERRUN = 2
    XL_CAN_MSG_FLAG_NERR = 4
    XL_CAN_MSG_FLAG_WAKEUP = 8
    XL_CAN_MSG_FLAG_REMOTE_FRAME = 16
    XL_CAN_MSG_FLAG_RESERVED_1 = 32
    XL_CAN_MSG_FLAG_TX_COMPLETED = 64
    XL_CAN_MSG_FLAG_TX_REQUEST = 128
    XL_CAN_MSG_FLAG_SRR_BIT_DOM = 512
    XL_EVENT_FLAG_OVERRUN = 1


class XL_MessageFlagsExtended(Enum):
    XL_CAN_EXT_MSG_ID = 2147483648


class XL_OutputMode(Enum):
    XL_OUTPUT_MODE_SILENT = 0
    XL_OUTPUT_MODE_NORMAL = 1
    XL_OUTPUT_MODE_TX_OFF = 2
    XL_OUTPUT_MODE_SJA_1000_SILENT = 3


class XL_Sizes(Enum):
    XL_MAX_LENGTH = 31
    XL_MAX_APPNAME = 32
    XL_MAX_NAME_LENGTH = 48
    XLEVENT_SIZE = 48
    XL_CONFIG_MAX_CHANNELS = 64
    XL_APPLCONFIG_MAX_CHANNELS = 256


class XL_Status(Enum):
    XL_SUCCESS = 0
    XL_PENDING = 1
    XL_ERR_QUEUE_IS_EMPTY = 10
    XL_ERR_HW_NOT_PRESENT = 129


class XL_TimeSyncNewValue(Enum):
    XL_SET_TIMESYNC_NO_CHANGE = 0
    XL_SET_TIMESYNC_ON = 1
    XL_SET_TIMESYNC_OFF = 2
