import { ReactWidget, UseSignal } from '@jupyterlab/apputils';
import { TextItem } from '@jupyterlab/statusbar';
import * as React from 'react';
const ProjectComponent = (props) => {
    return (React.createElement(UseSignal, { signal: props.manager.projectChanged, initialArgs: { newValue: null } }, (_, change) => change.newValue ? (React.createElement(TextItem, { source: change.newValue.name, title: `Active project: ${change.newValue.path}` })) : null));
};
export function createProjectStatus(props) {
    return ReactWidget.create(React.createElement(ProjectComponent, Object.assign({}, props)));
}
//# sourceMappingURL=statusbar.js.map