import { JupyterFrontEnd } from '@jupyterlab/application';
import { ICommandPalette } from '@jupyterlab/apputils';
import { IStateDB } from '@jupyterlab/coreutils';
import { IFileBrowserFactory } from '@jupyterlab/filebrowser';
import { ILauncher } from '@jupyterlab/launcher';
import { IMainMenu } from '@jupyterlab/mainmenu';
import { IStatusBar } from '@jupyterlab/statusbar';
import { IEnvironmentManager } from 'jupyterlab_conda';
import { IProjectManager, Templates } from './tokens';
/**
 * Activate the project manager plugin
 *
 * @param app The application object
 * @param state The application state handler
 * @param browserFactory The file browser factory
 * @param settings The project template settings
 * @param palette The command palette
 * @param launcher The application launcher
 * @param menu The application menu
 * @param statusbar The application status bar
 */
export declare function activateProjectManager(app: JupyterFrontEnd, state: IStateDB, browserFactory: IFileBrowserFactory, settings: Templates.IProject, palette: ICommandPalette, condaManager: IEnvironmentManager | null, launcher: ILauncher | null, menu: IMainMenu | null, statusbar: IStatusBar | null): IProjectManager;
