# Django Payplus

Django app for Nalo Solutions Limited mobile money payment platform integration.


Requirements
---

* python 3.5+
* django 2.2+
* requests 2.24+


> Please use python virtual environment for project isolation


Installation
---
1. Run `pip install djangopayplus` to install package.

2. Add `'payplus'` to `settings.py` at INSTALLED_APPS section like this:

    ```python
    INSTALLED_APPS = [
        ...

        'payplus',
    ]
    ```
3. Also include the below at the bottom of `settings.py` like this:

    ```
    ...

    # complusory Payment Settings
    PAYMENT_CALLBACK = /url/to/callback/
    PAYMENT_GATEWAY =  /url/to/gateway/

    # optional payment settings
    PAYMENT_MERCHANT = NSP_XXXXXX
    PAYMENT_PASSWORD = password
    PAYMENT_USERNAME = username

    ```

4. Run `python manage.py migrate` to create the associated models.

5. Start the server and verify all is runing well


Sending payment request
---

Prerequiste mostly your validated data should have the below parameters:

| Parameter    | Description                                                                                                                                        | Format  |
|--------------|----------------------------------------------------------------------------------------------------------------------------------------------------|---------|
| order_id     | The unique identification for the payment order. This is also generated at the client side and will be returned in the charging response.          | STRING  |
| customerName | The name of the payment authorizer or the buyer. Eg. Jane Doe                                                                                      | STRING  |
| amount       | This is the invoice amount stated in units of Ghanaian cedis. Note: the amount should be used without the currency. Eg. 2.00                       | DECIMAL |
| item_desc    | The description of the purchased item or service. Eg. bulksms                                                                                      | STRING  |

1. Sending payment with optional settings

```python

    from payplus.momopay import MomoPayProcessor
    from django.views import View

    class MomoPaymentView(View):

        def post(self, request, *args, **kwargs):
            ...
            
            response = MomoPayProcessor(data=validated_data).pay()
```

2. Sending payment without optional settings

```python

    from payplus.momopay import MomoPayProcessor
    from django.views import View

    class MomoPaymentView(View):

        def post(self, request, *args, **kwargs):
            ...
            
            response = MomoPayProcessor(
                data=validated_data,
                merchant=merchant{
                    "id": "your-merchant-id",
                    "username": "merchant-username",
                    "password": "merchant-password",                    
                }
            ).pay()
```
Request response
---
When you initiate the momo payment call, a sample requset response below is received.
```
    On Success

    {
        status: True,
        message: Passed
    }


    On Failure
    {
        status: False,
        message: reason of failure
    }
```



Receiving callback
---

```python

    from payplus.momopay import MomoPayProcessor
    from django.views import View
    import json

    class MomoPaymentCallbackView(View):

        def post(self, request, *args, **kwargs):

            post_data = json.loads(request.body)
            ...
            
            response = MomoPayProcessor(callback=validated_data).onCallback()
```


Callback response
---
When you initiate the momo payment call, a sample callback response below is received.

`On Success`

```json

    {
        "status": True,
        "transactionID": 22,
        "amount": 1.00
    }
```

`On Failure`

```json

    {
        "status": False,
        "message": reason of failure
    }
```

Upgrade 
---
```bash

    pip install djangopayplus --upgrade

```

Need help, have any questions, suggestions?
----

Submit an issue/PR or email us at noc@nalosolutions.com
