from .base_operator import BaseOperator


def create_operator(
    metadata: dict, 
    operator_function: callable, 
    generate_report: callable = None
):
    class NewOperator(BaseOperator): pass

    # Operator name as used by Airflow
    NewOperator.__name__ = metadata.get("name", "BaseOperator")
    
    # Operator custom function
    NewOperator.operator_function = operator_function

    # Operator custom Generate Report function
    if generate_report:
        NewOperator.generate_report = generate_report
    
    return NewOperator