# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['GroupWithAssumableRolesPolicyArgs', 'GroupWithAssumableRolesPolicy']

@pulumi.input_type
class GroupWithAssumableRolesPolicyArgs:
    def __init__(__self__, *,
                 assumable_roles: pulumi.Input[Sequence[pulumi.Input[str]]],
                 group_users: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a GroupWithAssumableRolesPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] assumable_roles: List of IAM roles ARNs which can be assumed by the group
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_users: List of IAM users to have in an IAM group which can assume the role
        :param pulumi.Input[str] name: Name of IAM policy and IAM group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to add.
        """
        pulumi.set(__self__, "assumable_roles", assumable_roles)
        pulumi.set(__self__, "group_users", group_users)
        pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="assumableRoles")
    def assumable_roles(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of IAM roles ARNs which can be assumed by the group
        """
        return pulumi.get(self, "assumable_roles")

    @assumable_roles.setter
    def assumable_roles(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "assumable_roles", value)

    @property
    @pulumi.getter(name="groupUsers")
    def group_users(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of IAM users to have in an IAM group which can assume the role
        """
        return pulumi.get(self, "group_users")

    @group_users.setter
    def group_users(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "group_users", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of IAM policy and IAM group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to add.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class GroupWithAssumableRolesPolicy(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assumable_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource helps you create an IAM Group with Users who are allowed to assume specified
        IAM roles.

        ## Example Usage
        ## Group With Assumable Roles Policy

        ```python
        import pulumi
        import pulumi_aws_iam as iam

        group_with_assume_roles_policy = iam.GroupWithAssumableRolesPolicy(
            'group_with_assume_roles_policy',
            name='production-readonly',
            assumable_roles=['arn:aws:iam::835367859855:role/readonly'],
            group_users=['user1','user2'],
        )

        pulumi.export('group_with_assume_roles_policy', group_with_assume_roles_policy)
        ```
        {{ /example }}

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] assumable_roles: List of IAM roles ARNs which can be assumed by the group
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_users: List of IAM users to have in an IAM group which can assume the role
        :param pulumi.Input[str] name: Name of IAM policy and IAM group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to add.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupWithAssumableRolesPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource helps you create an IAM Group with Users who are allowed to assume specified
        IAM roles.

        ## Example Usage
        ## Group With Assumable Roles Policy

        ```python
        import pulumi
        import pulumi_aws_iam as iam

        group_with_assume_roles_policy = iam.GroupWithAssumableRolesPolicy(
            'group_with_assume_roles_policy',
            name='production-readonly',
            assumable_roles=['arn:aws:iam::835367859855:role/readonly'],
            group_users=['user1','user2'],
        )

        pulumi.export('group_with_assume_roles_policy', group_with_assume_roles_policy)
        ```
        {{ /example }}

        :param str resource_name: The name of the resource.
        :param GroupWithAssumableRolesPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupWithAssumableRolesPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assumable_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupWithAssumableRolesPolicyArgs.__new__(GroupWithAssumableRolesPolicyArgs)

            if assumable_roles is None and not opts.urn:
                raise TypeError("Missing required property 'assumable_roles'")
            __props__.__dict__["assumable_roles"] = assumable_roles
            if group_users is None and not opts.urn:
                raise TypeError("Missing required property 'group_users'")
            __props__.__dict__["group_users"] = group_users
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["group_arn"] = None
            __props__.__dict__["group_name"] = None
            __props__.__dict__["policy_arn"] = None
        super(GroupWithAssumableRolesPolicy, __self__).__init__(
            'aws-iam:index:GroupWithAssumableRolesPolicy',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="assumableRoles")
    def assumable_roles(self) -> pulumi.Output[Sequence[str]]:
        """
        List of IAM roles ARNs which can be assumed by the group
        """
        return pulumi.get(self, "assumable_roles")

    @property
    @pulumi.getter(name="groupArn")
    def group_arn(self) -> pulumi.Output[str]:
        """
        IAM group arn.
        """
        return pulumi.get(self, "group_arn")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[str]:
        """
        IAM group name.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="groupUsers")
    def group_users(self) -> pulumi.Output[Sequence[str]]:
        """
        List of IAM users in IAM group
        """
        return pulumi.get(self, "group_users")

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> pulumi.Output[str]:
        """
        Assume role policy ARN of IAM group
        """
        return pulumi.get(self, "policy_arn")

