# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
sys.path.insert(0, os.path.abspath('..'))
import recommonmark.parser

# -- JUPYTER theme -----------------------------------------------------------
# from jupyter_sphinx_theme import *
# init_theme()
# globaltoc_depth = -1

# -- Project information -----------------------------------------------------

project = 'bebi103'
copyright = '2020, Justin Bois'
author = 'Justin Bois'

# The full version, including alpha/beta/rc tags
release = ''


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'recommonmark',
    'sphinx.ext.todo',
    'sphinx.ext.githubpages',
    'sphinx.ext.autosectionlabel',
    'sphinx.ext.autosummary',
    'nbsphinx',
    'bokeh.sphinxext.bokeh_plot',
    'sphinx_copybutton',
    'sphinx.ext.napoleon'
]

autodoc_default_options = {
    'members': True,
    'inherited-members': True
}
autodoc_member_order = 'groupwise'

autosummary_generate = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
source_suffix = ['.rst', '.md', '.ipynb']

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = [
    '**_build',
    '**Thumbs.db',
    '**.DS_Store',
    '**.ipynb_checkpoints',
    '**/__pycache__/**',
    '*/data/*',
    'Untitled**',
    '**.key',
    '**/.pytest_cache/**',
]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# # This is processed by Jinja2 and inserted before each notebook
# nbsphinx_prolog = r"""
# {% set docname = env.doc2path(env.docname, base='doc') %}
# .. only:: html
#     .. role:: raw-html(raw)
#         :format: html
#     .. nbinfo::
#         This page was generated from `{{ docname }}`__.
#         Interactive online version:
#         :raw-html:`<a href="https://mybinder.org/v2/gh/spatialaudio/nbsphinx/{{ env.config.release }}?filepath={{ docname }}"><img alt="Binder badge" src="https://mybinder.org/badge_logo.svg" style="vertical-align:text-bottom"></a>`
#     __ https://github.com/spatialaudio/nbsphinx/blob/
#         {{ env.config.release }}/{{ docname }}
# .. raw:: latex
#     \nbsphinxstartnotebook{\scriptsize\noindent\strut
#     \textcolor{gray}{The following section was generated from
#     \sphinxcode{\sphinxupquote{\strut {{ docname | escape_latex }}}} \dotfill}}
# """

# # This is processed by Jinja2 and inserted after each notebook
# nbsphinx_epilog = r"""
# .. raw:: latex
#     \nbsphinxstopnotebook{\scriptsize\noindent\strut
#     \textcolor{gray}{\dotfill\ \sphinxcode{\sphinxupquote{\strut
#     {{ env.doc2path(env.docname, base='doc') | escape_latex }}}} ends here.}}
# """


# -- Options for HTML output -------------------------------------------------
# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
html_show_sphinx = False

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
html_show_copyright = False

html_last_updated_fmt = ''

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

def setup(app):
    app.add_css_file('custom.css')

# html_logo = '_static/logo.png'

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}
#---sphinx-themes-----
html_theme = 'sphinx_rtd_theme'

html_theme_options = {
#    'analytics_id': 'UA-65442910-1',  #  Provided by Google in your dashboard
    'display_version': False,
    'logo_only': True,
    'prev_next_buttons_location': 'bottom',
    'style_external_links': False,
    'style_nav_header_background': '#F0F0F0',
    # Toc options
    'collapse_navigation': True,
    'sticky_navigation': True,
    'navigation_depth': 4,
}
