"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MyRedis = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * @experimental
 */
class MyRedis extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, name, opts) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k;
        super(scope, name);
        const namespace = (_b = opts.namespace) !== null && _b !== void 0 ? _b : 'default';
        this.namespace = namespace;
        var configMapName = (_c = opts.configMapName) !== null && _c !== void 0 ? _c : name;
        var storageClassName = (_d = opts.storageClassName) !== null && _d !== void 0 ? _d : 'gp2';
        const volumeProvisioner = (_e = opts.volumeProvisioner) !== null && _e !== void 0 ? _e : 'kubernetes.io/aws-ebs';
        const storageClassParams = (_f = opts.storageClassParams) !== null && _f !== void 0 ? _f : { type: 'gp2', fsType: 'ext4' };
        const volumeRequest = {
            storage: k8s.Quantity.fromString(String(opts.volumeSize)),
        };
        const replicas = (_g = opts.replicas) !== null && _g !== void 0 ? _g : 1;
        const resources = {
            limits: convertQuantity((_h = opts.resources) === null || _h === void 0 ? void 0 : _h.limits, {
                cpu: '400m',
                memory: '512Mi',
            }),
            requests: convertQuantity((_j = opts.resources) === null || _j === void 0 ? void 0 : _j.requests, {
                cpu: '200m',
                memory: '256Mi',
            }),
        };
        const nodeSelectorParams = (_k = opts.nodeSelectorParams) !== null && _k !== void 0 ? _k : undefined;
        const label = {
            ...opts.labels,
            app: name,
        };
        if (opts.createStorageClass === true) {
            const storageClassOpts = {
                metadata: {
                    name: storageClassName,
                },
                provisioner: volumeProvisioner,
                allowVolumeExpansion: true,
                reclaimPolicy: 'Retain',
                parameters: {
                    ...storageClassParams,
                },
            };
            const storageclass = new k8s.KubeStorageClass(this, 'storageclass', storageClassOpts);
            this.name = storageclass.name;
            var storageClassName = storageclass.name;
        }
        if (configMapName != name) {
            // pass
        }
        else {
            const configMapOpts = {
                metadata: {
                    name: `${name}-redis-conf`,
                    namespace: namespace,
                },
                data: {
                    'master.conf': '\nbind 0.0.0.0' +
                        '\ndaemonize no' +
                        '\nport 6379' +
                        '\ntcp-backlog 511' +
                        '\ntimeout 0' +
                        '\ntcp-keepalive 300' +
                        '\nsupervised no',
                    'slave.conf': `\nslaveof ${name} 6379`,
                },
            };
            const configmap = new k8s.KubeConfigMap(this, 'cm', configMapOpts);
            this.name = configmap.name;
            var configMapName = configmap.name;
        }
        const serviceOpts = {
            metadata: {
                labels: label,
                name: name,
                namespace: namespace,
            },
            spec: {
                type: 'ClusterIP',
                selector: label,
                ports: [{ port: 6379, targetPort: k8s.IntOrString.fromNumber(6379) }],
            },
        };
        const svc = new k8s.KubeService(this, 'service', serviceOpts);
        this.name = svc.name;
        const pvcProps = {
            metadata: {
                name: name,
                namespace: namespace,
            },
            spec: {
                accessModes: ['ReadWriteOnce'],
                storageClassName: storageClassName,
                resources: {
                    requests: volumeRequest,
                },
            },
        };
        // const initRedis: k8s.Container = {
        //   name: 'init-redis',
        //   image: opts.image,
        //   command: [
        //     'bash',
        //     '-c',
        //     'set -ex\n# Generate mysql server-id from pod ordinal index.\nmkdir -p /etc/redis\n[[ `hostname` =~ -([0-9]+)$ ]] || exit 1\nordinal=${BASH_REMATCH[1]}\n# Copy appropriate conf.d files from config-map to emptyDir.\nif [[ $ordinal -eq 0 ]]; then\ncp /mnt/redis/master.conf /etc/redis/redis.conf\nelse\ncp /mnt/redis/slave.conf /etc/redis/redis.conf\nfi',
        //   ],
        //   volumeMounts: [{
        //     name: name,
        //     mountPath: '/data',
        //   },
        //   {
        //     name: `${name}-redis-conf`,
        //     mountPath: '/mnt/config-map',
        //   }],
        // };
        const redis = {
            name: 'redis',
            image: opts.image,
            ports: [{
                    containerPort: 6379,
                }],
            command: [
                'bash',
                '-c',
                '[[ `hostname` =~ -([0-9]+)$ ]] || exit 1\nordinal=${BASH_REMATCH[1]}\nif [[ $ordinal -eq 0 ]]; then\nredis-server /mnt/redis/master.conf\nelse\nredis-server /mnt/redis/slave.conf\nfi',
            ],
            resources: resources,
            env: renderEnv(opts.env),
            volumeMounts: [{
                    name: name,
                    mountPath: '/data',
                },
                {
                    name: `${name}-redis-conf`,
                    mountPath: '/mnt/redis/',
                }],
        };
        const stsOpts = {
            metadata: {
                labels: label,
                name: name,
                namespace: namespace,
            },
            spec: {
                serviceName: svc.name,
                replicas: replicas,
                selector: { matchLabels: label },
                template: {
                    metadata: { labels: label },
                    spec: {
                        containers: [
                            redis,
                        ],
                        terminationGracePeriodSeconds: 10,
                        nodeSelector: nodeSelectorParams,
                        volumes: [{
                                name: `${name}-redis-conf`,
                                configMap: {
                                    name: `${configMapName}`,
                                },
                            }],
                    },
                },
                volumeClaimTemplates: [pvcProps],
            },
        };
        const sts = new k8s.KubeStatefulSet(this, 'statefulset', stsOpts);
        this.name = sts.name;
    }
}
exports.MyRedis = MyRedis;
_a = JSII_RTTI_SYMBOL_1;
MyRedis[_a] = { fqn: "@opencdk8s/cdk8s-redis-sts.MyRedis", version: "0.0.7" };
function renderEnv(env = {}) {
    const result = new Array();
    for (const [key, value] of Object.entries(env)) {
        result.push({
            name: key,
            value: value,
        });
    }
    return result;
}
/**
 * Converts a `ResourceQuantity` type to a k8s.Quantity map.
 *
 * If `user` is defined, the values provided there (or lack thereof) will be
 * passed on. This means that if the user, for example, did not specify a value
 * for `cpu`, this value will be omitted from the resource requirements. This is
 * intentional, in case the user intentionally wants to omit a constraint.
 *
 * If `user` is not defined, `defaults` are used.
 */
function convertQuantity(user, defaults) {
    // defaults
    if (!user) {
        return {
            cpu: k8s.Quantity.fromString(defaults.cpu),
            memory: k8s.Quantity.fromString(defaults.memory),
        };
    }
    const result = {};
    if (user.cpu) {
        result.cpu = k8s.Quantity.fromString(user.cpu);
    }
    if (user.memory) {
        result.memory = k8s.Quantity.fromString(user.memory);
    }
    return result;
}
//# sourceMappingURL=data:application/json;base64,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