import { Construct } from 'constructs';
/**
 * @experimental
 */
export interface StsOpts {
    /**
     * @default 1
     * @experimental
     */
    readonly replicas?: number;
    /**
     * (experimental) Container image.
     *
     * @experimental
     */
    readonly image: string;
    /**
     * (experimental) namespace.
     *
     * @default - default
     * @experimental
     */
    readonly namespace: string;
    /**
     * (experimental) Option to create storage class, if enabled, a storage class will be created for the statefulset.
     *
     * @default true
     * @experimental
     */
    readonly createStorageClass?: boolean;
    /**
     * (experimental) The storage class to use for our PVC.
     *
     * @default 'gp2-expandable'
     * @experimental
     */
    readonly storageClassName?: string;
    /**
     * (experimental) The name of the configmap to use instead of the default one.
     *
     * @experimental
     */
    readonly configMapName?: string;
    /**
     * (experimental) Each StorageClass has a provisioner that determines what volume plugin is used for provisioning PVs.
     *
     * This field must be specified.
     * See [this](https://kubernetes.io/docs/concepts/storage/storage-classes/#provisioner) for Ref
     *
     * @default 'kubernetes.io/aws-ebs'
     * @experimental
     */
    readonly volumeProvisioner?: string;
    /**
     * (experimental) Storage class params.
     *
     * @default - { type = gp2, fsType: ext4 }
     * @experimental
     */
    readonly storageClassParams?: {
        [name: string]: string;
    };
    /**
     * (experimental) nodeSelector params.
     *
     * @default - undefined
     * @experimental
     */
    readonly nodeSelectorParams?: {
        [name: string]: string;
    };
    /**
     * (experimental) Additional labels to apply to resources.
     *
     * @default - none
     * @experimental
     */
    readonly labels?: {
        [name: string]: string;
    };
    /**
     * (experimental) Resources requests for the DB.
     *
     * @default - Requests = { CPU = 200m, Mem = 256Mi }, Limits = { CPU = 400m, Mem = 512Mi }
     * @experimental
     */
    readonly resources?: ResourceRequirements;
    /**
     * (experimental) The Volume size of our DB in string, e.g 10Gi, 20Gi.
     *
     * @experimental
     */
    readonly volumeSize?: string;
    /**
     * (experimental) Environment variables to pass to the pod.
     *
     * @experimental
     */
    readonly env?: {
        [name: string]: string;
    };
}
/**
 * @experimental
 */
export interface ResourceRequirements {
    /**
     * (experimental) Maximum resources for the web app.
     *
     * @default - CPU = 400m, Mem = 512Mi
     * @experimental
     */
    readonly limits?: ResourceQuantity;
    /**
     * (experimental) Required resources for the web app.
     *
     * @default - CPU = 200m, Mem = 256Mi
     * @experimental
     */
    readonly requests?: ResourceQuantity;
}
/**
 * @experimental
 */
export interface ResourceQuantity {
    /**
     * @default - no limit
     * @experimental
     */
    readonly cpu?: string;
    /**
     * @default - no limit
     * @experimental
     */
    readonly memory?: string;
}
/**
 * @experimental
 */
export declare class MyRedis extends Construct {
    /**
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    readonly namespace: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, name: string, opts: StsOpts);
}
