# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.file_metadata import FileMetadata
from typing import Optional, Set
from typing_extensions import Self

class UpdateFileResponse(BaseModel):
    """
    UpdateFileResponse represents the response to a file metadata update request. This message returns the complete, updated metadata for the modified file. UpdateFileResponse represents the response to a file metadata update request. This message provides comprehensive information about the updated file state, including the complete metadata and additional status information.  Key features: - Complete updated metadata reflection - Version tracking - Update timestamp information - Change verification data
    """ # noqa: E501
    metadata: Optional[FileMetadata] = None
    update_timestamp: Optional[StrictStr] = Field(default=None, alias="updateTimestamp")
    previous_version_id: Optional[StrictStr] = Field(default=None, alias="previousVersionId")
    change_summary: Optional[StrictStr] = Field(default=None, alias="changeSummary")
    change_author: Optional[StrictStr] = Field(default=None, alias="changeAuthor")
    update_sequence_number: Optional[StrictStr] = Field(default=None, alias="updateSequenceNumber")
    __properties: ClassVar[List[str]] = ["metadata", "updateTimestamp", "previousVersionId", "changeSummary", "changeAuthor", "updateSequenceNumber"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateFileResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateFileResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "metadata": FileMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "updateTimestamp": obj.get("updateTimestamp"),
            "previousVersionId": obj.get("previousVersionId"),
            "changeSummary": obj.get("changeSummary"),
            "changeAuthor": obj.get("changeAuthor"),
            "updateSequenceNumber": obj.get("updateSequenceNumber")
        })
        return _obj


