# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class TransactionSplit(BaseModel):
    """
    PlaidAccountTransactionSplit represents a split of a PlaidAccountTransaction.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The unique ID for this transaction.")
    user_id: Optional[StrictStr] = Field(default=None, description="The user ID associated with this transaction.", alias="userId")
    link_id: Optional[StrictStr] = Field(default=None, description="The link ID associated with this transaction.", alias="linkId")
    description: Optional[StrictStr] = Field(default=None, description="The description of the transaction.")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The amount of money involved in the transaction.")
    categories: Optional[List[StrictStr]] = Field(default=None, description="The set of categories that the transaction belongs to.")
    personal_finance_category_primary: Optional[StrictStr] = Field(default=None, description="The primary personal finance category of the transaction.", alias="personalFinanceCategoryPrimary")
    personal_finance_category_detailed: Optional[StrictStr] = Field(default=None, description="The detailed personal finance category of the transaction.", alias="personalFinanceCategoryDetailed")
    tags: Optional[List[StrictStr]] = Field(default=None, description="Tags associated with this transaction.")
    authorized_date: Optional[datetime] = Field(default=None, alias="authorizedDate")
    authorized_datetime: Optional[datetime] = Field(default=None, description="The date-time when the transaction was authorized.", alias="authorizedDatetime")
    time_of_split: Optional[datetime] = Field(default=None, alias="timeOfSplit")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    gl_code: Optional[StrictStr] = Field(default=None, description="The general ledger code associated with this transaction.", alias="glCode")
    cost_center: Optional[StrictStr] = Field(default=None, description="The cost center associated with this transaction.", alias="costCenter")
    project_code: Optional[StrictStr] = Field(default=None, description="The project associated with this transaction.", alias="projectCode")
    tax_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="taxAmount")
    tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="taxRate")
    tax_code: Optional[StrictStr] = Field(default=None, alias="taxCode")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    created_by_email: Optional[StrictStr] = Field(default=None, alias="createdByEmail")
    __properties: ClassVar[List[str]] = ["id", "userId", "linkId", "description", "amount", "categories", "personalFinanceCategoryPrimary", "personalFinanceCategoryDetailed", "tags", "authorizedDate", "authorizedDatetime", "timeOfSplit", "deletedAt", "glCode", "costCenter", "projectCode", "taxAmount", "taxRate", "taxCode", "createdAt", "updatedAt", "createdByEmail"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransactionSplit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransactionSplit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "userId": obj.get("userId"),
            "linkId": obj.get("linkId"),
            "description": obj.get("description"),
            "amount": obj.get("amount"),
            "categories": obj.get("categories"),
            "personalFinanceCategoryPrimary": obj.get("personalFinanceCategoryPrimary"),
            "personalFinanceCategoryDetailed": obj.get("personalFinanceCategoryDetailed"),
            "tags": obj.get("tags"),
            "authorizedDate": obj.get("authorizedDate"),
            "authorizedDatetime": obj.get("authorizedDatetime"),
            "timeOfSplit": obj.get("timeOfSplit"),
            "deletedAt": obj.get("deletedAt"),
            "glCode": obj.get("glCode"),
            "costCenter": obj.get("costCenter"),
            "projectCode": obj.get("projectCode"),
            "taxAmount": obj.get("taxAmount"),
            "taxRate": obj.get("taxRate"),
            "taxCode": obj.get("taxCode"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "createdByEmail": obj.get("createdByEmail")
        })
        return _obj


