# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.business_account import BusinessAccount
from solomonai_backend_client_sdk.models.role import Role
from solomonai_backend_client_sdk.models.team_member_status import TeamMemberStatus
from solomonai_backend_client_sdk.models.user_account import UserAccount
from typing import Optional, Set
from typing_extensions import Self

class TeamMember(BaseModel):
    """
    TeamMember
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the team member.")
    user_account: Optional[UserAccount] = Field(default=None, alias="userAccount")
    business_account: Optional[BusinessAccount] = Field(default=None, alias="businessAccount")
    status: Optional[TeamMemberStatus] = TeamMemberStatus.UNSPECIFIED
    joined_at: Optional[datetime] = Field(default=None, description="Timestamp indicating when the member joined the team.", alias="joinedAt")
    deleted_at: Optional[datetime] = Field(default=None, description="Timestamp for when the member was removed or deleted from the team (optional).", alias="deletedAt")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Metadata in JSON format, allowing additional structured data (optional).")
    roles: Optional[List[Role]] = None
    last_active: Optional[datetime] = Field(default=None, alias="lastActive")
    __properties: ClassVar[List[str]] = ["id", "userAccount", "businessAccount", "status", "joinedAt", "deletedAt", "metadata", "roles", "lastActive"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TeamMember from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user_account
        if self.user_account:
            _dict['userAccount'] = self.user_account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of business_account
        if self.business_account:
            _dict['businessAccount'] = self.business_account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in roles (list)
        _items = []
        if self.roles:
            for _item in self.roles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['roles'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TeamMember from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "userAccount": UserAccount.from_dict(obj["userAccount"]) if obj.get("userAccount") is not None else None,
            "businessAccount": BusinessAccount.from_dict(obj["businessAccount"]) if obj.get("businessAccount") is not None else None,
            "status": obj.get("status") if obj.get("status") is not None else TeamMemberStatus.UNSPECIFIED,
            "joinedAt": obj.get("joinedAt"),
            "deletedAt": obj.get("deletedAt"),
            "metadata": obj.get("metadata"),
            "roles": [Role.from_dict(_item) for _item in obj["roles"]] if obj.get("roles") is not None else None,
            "lastActive": obj.get("lastActive")
        })
        return _obj


